// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e33042){var e = e33042;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__33043_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__33043_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__33043_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__33043_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__33043_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33044_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33044_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33045_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33045_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__33050 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33050,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33050,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33046_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33046_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__33053 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33053,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33053,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33047_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33047_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33048_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33048_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33049_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33049_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33056_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__33056_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__33057 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__33057) : intersecting_vars.call(null,G__33057));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__33060,optional_QMARK_,fuel,max_fuel){
var map__33061 = p__33060;
var map__33061__$1 = (((((!((map__33061 == null))))?(((((map__33061.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33061.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33061):map__33061);
var res = map__33061__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33061__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33128){
var state_val_33129 = (state_33128[(1)]);
if((state_val_33129 === (7))){
var inst_33117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33118 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_33119 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33118,clause);
var inst_33120 = [null,inst_33119];
var inst_33121 = (new cljs.core.PersistentVector(null,2,(5),inst_33117,inst_33120,null));
var state_33128__$1 = state_33128;
var statearr_33130_33158 = state_33128__$1;
(statearr_33130_33158[(2)] = inst_33121);

(statearr_33130_33158[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (1))){
var state_33128__$1 = state_33128;
var statearr_33131_33159 = state_33128__$1;
(statearr_33131_33159[(2)] = null);

(statearr_33131_33159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (4))){
var inst_33063 = (state_33128[(2)]);
var state_33128__$1 = state_33128;
var statearr_33132_33160 = state_33128__$1;
(statearr_33132_33160[(2)] = inst_33063);

(statearr_33132_33160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (15))){
var inst_33106 = (state_33128[(2)]);
var inst_33107 = fluree.db.util.async.throw_err(inst_33106);
var inst_33108 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_33107);
var inst_33109 = cljs.core.count(inst_33108);
var inst_33110 = fluree.db.query.analytical.add_fuel(inst_33109,fuel,max_fuel);
var inst_33111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33112 = [inst_33107,r];
var inst_33113 = (new cljs.core.PersistentVector(null,2,(5),inst_33111,inst_33112,null));
var state_33128__$1 = (function (){var statearr_33133 = state_33128;
(statearr_33133[(7)] = inst_33110);

return statearr_33133;
})();
var statearr_33134_33161 = state_33128__$1;
(statearr_33134_33161[(2)] = inst_33113);

(statearr_33134_33161[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (13))){
var inst_33072 = (state_33128[(8)]);
var inst_33085 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33086 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_33085);
var inst_33087 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33072);
var inst_33088 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33087);
var inst_33089 = cljs.core.set(inst_33088);
var inst_33090 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33086);
var inst_33091 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33090);
var inst_33092 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33089,inst_33091);
var inst_33093 = (function (){var all_wd = inst_33072;
var optional = inst_33086;
var all_wd_vars = inst_33089;
var all_vars = inst_33092;
return (function (p1__33058_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__33058_SHARP_) : all_vars.call(null,p1__33058_SHARP_));
});
})();
var inst_33094 = cljs.core.keys(vars);
var inst_33095 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33093,inst_33094);
var inst_33096 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_33095);
var inst_33097 = cljs.core.set(inst_33096);
var inst_33098 = (function (){var all_wd = inst_33072;
var optional = inst_33086;
var all_wd_vars = inst_33089;
var all_vars = inst_33092;
var intersecting_vars = inst_33097;
return (function (p1__33059_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__33059_SHARP_);
});
})();
var inst_33099 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33098,inst_33072);
var inst_33100 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33099);
var inst_33101 = fluree.db.query.analytical.select_from_tuples(inst_33100,res);
var inst_33102 = fluree.db.query.analytical.replace_vars_wikidata(inst_33072,inst_33097,vars);
var inst_33103 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_33097,inst_33092);
var inst_33104 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_33102,inst_33100,inst_33101,inst_33103,inst_33086);
var state_33128__$1 = state_33128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33128__$1,(15),inst_33104);
} else {
if((state_val_33129 === (6))){
var inst_33073 = (state_33128[(9)]);
var inst_33071 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33072 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_33071);
var inst_33073__$1 = optional_QMARK_;
var state_33128__$1 = (function (){var statearr_33135 = state_33128;
(statearr_33135[(9)] = inst_33073__$1);

(statearr_33135[(8)] = inst_33072);

return statearr_33135;
})();
if(cljs.core.truth_(inst_33073__$1)){
var statearr_33136_33162 = state_33128__$1;
(statearr_33136_33162[(1)] = (9));

} else {
var statearr_33137_33163 = state_33128__$1;
(statearr_33137_33163[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (3))){
var inst_33126 = (state_33128[(2)]);
var state_33128__$1 = state_33128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33128__$1,inst_33126);
} else {
if((state_val_33129 === (12))){
var inst_33081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33082 = [null,r];
var inst_33083 = (new cljs.core.PersistentVector(null,2,(5),inst_33081,inst_33082,null));
var state_33128__$1 = state_33128;
var statearr_33138_33164 = state_33128__$1;
(statearr_33138_33164[(2)] = inst_33083);

(statearr_33138_33164[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (2))){
var _ = (function (){var statearr_33139 = state_33128;
(statearr_33139[(4)] = cljs.core.cons((5),(state_33128[(4)])));

return statearr_33139;
})();
var inst_33069 = (r == null);
var state_33128__$1 = state_33128;
if(cljs.core.truth_(inst_33069)){
var statearr_33140_33165 = state_33128__$1;
(statearr_33140_33165[(1)] = (6));

} else {
var statearr_33141_33166 = state_33128__$1;
(statearr_33141_33166[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (11))){
var inst_33079 = (state_33128[(2)]);
var state_33128__$1 = state_33128;
if(cljs.core.truth_(inst_33079)){
var statearr_33143_33167 = state_33128__$1;
(statearr_33143_33167[(1)] = (12));

} else {
var statearr_33144_33168 = state_33128__$1;
(statearr_33144_33168[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (9))){
var inst_33072 = (state_33128[(8)]);
var inst_33075 = cljs.core.empty_QMARK_(inst_33072);
var inst_33076 = (!(inst_33075));
var state_33128__$1 = state_33128;
var statearr_33145_33169 = state_33128__$1;
(statearr_33145_33169[(2)] = inst_33076);

(statearr_33145_33169[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (5))){
var _ = (function (){var statearr_33146 = state_33128;
(statearr_33146[(4)] = cljs.core.rest((state_33128[(4)])));

return statearr_33146;
})();
var state_33128__$1 = state_33128;
var ex33142 = (state_33128__$1[(2)]);
var statearr_33147_33170 = state_33128__$1;
(statearr_33147_33170[(5)] = ex33142);


if((ex33142 instanceof Error)){
var statearr_33148_33171 = state_33128__$1;
(statearr_33148_33171[(1)] = (4));

(statearr_33148_33171[(5)] = null);

} else {
throw ex33142;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (14))){
var inst_33115 = (state_33128[(2)]);
var state_33128__$1 = state_33128;
var statearr_33149_33172 = state_33128__$1;
(statearr_33149_33172[(2)] = inst_33115);

(statearr_33149_33172[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (10))){
var inst_33073 = (state_33128[(9)]);
var state_33128__$1 = state_33128;
var statearr_33150_33173 = state_33128__$1;
(statearr_33150_33173[(2)] = inst_33073);

(statearr_33150_33173[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33129 === (8))){
var inst_33123 = (state_33128[(2)]);
var _ = (function (){var statearr_33151 = state_33128;
(statearr_33151[(4)] = cljs.core.rest((state_33128[(4)])));

return statearr_33151;
})();
var state_33128__$1 = state_33128;
var statearr_33152_33174 = state_33128__$1;
(statearr_33152_33174[(2)] = inst_33123);

(statearr_33152_33174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33153 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33153[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__);

(statearr_33153[(1)] = (1));

return statearr_33153;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1 = (function (state_33128){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33128);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33154){var ex__16304__auto__ = e33154;
var statearr_33155_33175 = state_33128;
(statearr_33155_33175[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33128[(4)]))){
var statearr_33156_33176 = state_33128;
(statearr_33156_33176[(1)] = cljs.core.first((state_33128[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33177 = state_33128;
state_33128 = G__33177;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = function(state_33128){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1.call(this,state_33128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33157 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33157[(6)] = c__16375__auto__);

return statearr_33157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__33179 = arguments.length;
switch (G__33179) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33273){
var state_val_33274 = (state_33273[(1)]);
if((state_val_33274 === (7))){
var inst_33186 = (state_33273[(7)]);
var inst_33196 = clojure.string.starts_with_QMARK_(inst_33186,"$fdb");
var state_33273__$1 = state_33273;
if(inst_33196){
var statearr_33275_33324 = state_33273__$1;
(statearr_33275_33324[(1)] = (9));

} else {
var statearr_33276_33325 = state_33273__$1;
(statearr_33276_33325[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (20))){
var state_33273__$1 = state_33273;
var statearr_33277_33326 = state_33273__$1;
(statearr_33277_33326[(2)] = null);

(statearr_33277_33326[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (27))){
var inst_33236 = (state_33273[(8)]);
var state_33273__$1 = state_33273;
var statearr_33278_33327 = state_33273__$1;
(statearr_33278_33327[(2)] = inst_33236);

(statearr_33278_33327[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (1))){
var state_33273__$1 = state_33273;
var statearr_33279_33328 = state_33273__$1;
(statearr_33279_33328[(2)] = null);

(statearr_33279_33328[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (24))){
var inst_33259 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
var statearr_33280_33329 = state_33273__$1;
(statearr_33280_33329[(2)] = inst_33259);

(statearr_33280_33329[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (4))){
var inst_33180 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
var statearr_33281_33330 = state_33273__$1;
(statearr_33281_33330[(2)] = inst_33180);

(statearr_33281_33330[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (15))){
var inst_33203 = (state_33273[(9)]);
var inst_33209 = (state_33273[(2)]);
var inst_33210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33211 = cljs.core.PersistentVector.EMPTY;
var inst_33212 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33213 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33211,inst_33212);
var inst_33214 = [inst_33203,inst_33213];
var inst_33215 = (new cljs.core.PersistentVector(null,2,(5),inst_33210,inst_33214,null));
var state_33273__$1 = (function (){var statearr_33282 = state_33273;
(statearr_33282[(10)] = inst_33209);

return statearr_33282;
})();
var statearr_33283_33331 = state_33273__$1;
(statearr_33283_33331[(2)] = inst_33215);

(statearr_33283_33331[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (21))){
var inst_33262 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
var statearr_33284_33332 = state_33273__$1;
(statearr_33284_33332[(2)] = inst_33262);

(statearr_33284_33332[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (13))){
var inst_33203 = (state_33273[(9)]);
var inst_33206 = (function(){throw inst_33203})();
var state_33273__$1 = state_33273;
var statearr_33285_33333 = state_33273__$1;
(statearr_33285_33333[(2)] = inst_33206);

(statearr_33285_33333[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (22))){
var inst_33225 = (state_33273[(11)]);
var inst_33227 = (state_33273[(12)]);
var inst_33229 = fluree.db.query.analytical.parse_block_from_source(inst_33225);
var inst_33230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33231 = [cljs.core.cst$kw$sources,inst_33227];
var inst_33232 = (new cljs.core.PersistentVector(null,2,(5),inst_33230,inst_33231,null));
var inst_33233 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_33232);
var state_33273__$1 = (function (){var statearr_33286 = state_33273;
(statearr_33286[(13)] = inst_33229);

return statearr_33286;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33273__$1,(25),inst_33233);
} else {
if((state_val_33274 === (29))){
var inst_33240 = (state_33273[(2)]);
var inst_33241 = fluree.db.util.async.throw_err(inst_33240);
var state_33273__$1 = state_33273;
var statearr_33287_33334 = state_33273__$1;
(statearr_33287_33334[(2)] = inst_33241);

(statearr_33287_33334[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (6))){
var inst_33189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33190 = cljs.core.PersistentVector.EMPTY;
var inst_33191 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33192 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33190,inst_33191);
var inst_33193 = [db,inst_33192];
var inst_33194 = (new cljs.core.PersistentVector(null,2,(5),inst_33189,inst_33193,null));
var state_33273__$1 = state_33273;
var statearr_33288_33335 = state_33273__$1;
(statearr_33288_33335[(2)] = inst_33194);

(statearr_33288_33335[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (28))){
var inst_33244 = (state_33273[(2)]);
var inst_33245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33246 = cljs.core.PersistentVector.EMPTY;
var inst_33247 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_33248 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33246,inst_33247);
var inst_33249 = [inst_33244,inst_33248];
var inst_33250 = (new cljs.core.PersistentVector(null,2,(5),inst_33245,inst_33249,null));
var state_33273__$1 = state_33273;
var statearr_33289_33336 = state_33273__$1;
(statearr_33289_33336[(2)] = inst_33250);

(statearr_33289_33336[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (25))){
var inst_33229 = (state_33273[(13)]);
var inst_33235 = (state_33273[(2)]);
var inst_33236 = fluree.db.util.async.throw_err(inst_33235);
var state_33273__$1 = (function (){var statearr_33290 = state_33273;
(statearr_33290[(8)] = inst_33236);

return statearr_33290;
})();
if(cljs.core.truth_(inst_33229)){
var statearr_33291_33337 = state_33273__$1;
(statearr_33291_33337[(1)] = (26));

} else {
var statearr_33292_33338 = state_33273__$1;
(statearr_33292_33338[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (17))){
var state_33273__$1 = state_33273;
var statearr_33293_33339 = state_33273__$1;
(statearr_33293_33339[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (3))){
var inst_33271 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33273__$1,inst_33271);
} else {
if((state_val_33274 === (12))){
var inst_33203 = (state_33273[(9)]);
var inst_33202 = (state_33273[(2)]);
var inst_33203__$1 = fluree.db.util.async.throw_err(inst_33202);
var inst_33204 = fluree.db.util.core.exception_QMARK_(inst_33203__$1);
var state_33273__$1 = (function (){var statearr_33295 = state_33273;
(statearr_33295[(9)] = inst_33203__$1);

return statearr_33295;
})();
if(inst_33204){
var statearr_33296_33340 = state_33273__$1;
(statearr_33296_33340[(1)] = (13));

} else {
var statearr_33297_33341 = state_33273__$1;
(statearr_33297_33341[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (2))){
var inst_33186 = (state_33273[(7)]);
var _ = (function (){var statearr_33298 = state_33273;
(statearr_33298[(4)] = cljs.core.cons((5),(state_33273[(4)])));

return statearr_33298;
})();
var inst_33186__$1 = cljs.core.first(clause);
var inst_33187 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_33186__$1);
var state_33273__$1 = (function (){var statearr_33299 = state_33273;
(statearr_33299[(7)] = inst_33186__$1);

return statearr_33299;
})();
if(inst_33187){
var statearr_33300_33342 = state_33273__$1;
(statearr_33300_33342[(1)] = (6));

} else {
var statearr_33301_33343 = state_33273__$1;
(statearr_33301_33343[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (23))){
var inst_33186 = (state_33273[(7)]);
var inst_33252 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33186)," is not supported in Fluree"].join('');
var inst_33253 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33254 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33255 = cljs.core.PersistentHashMap.fromArrays(inst_33253,inst_33254);
var inst_33256 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33252,inst_33255);
var inst_33257 = (function(){throw inst_33256})();
var state_33273__$1 = state_33273;
var statearr_33302_33344 = state_33273__$1;
(statearr_33302_33344[(2)] = inst_33257);

(statearr_33302_33344[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (19))){
var inst_33227 = (state_33273[(12)]);
var inst_33186 = (state_33273[(7)]);
var inst_33224 = fluree.db.query.analytical.isolate_source_name(inst_33186);
var inst_33225 = fluree.db.query.analytical.isolate_source_block(inst_33186);
var inst_33226 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_33224);
var inst_33227__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_33226);
var state_33273__$1 = (function (){var statearr_33303 = state_33273;
(statearr_33303[(11)] = inst_33225);

(statearr_33303[(12)] = inst_33227__$1);

return statearr_33303;
})();
if(cljs.core.truth_(inst_33227__$1)){
var statearr_33304_33345 = state_33273__$1;
(statearr_33304_33345[(1)] = (22));

} else {
var statearr_33305_33346 = state_33273__$1;
(statearr_33305_33346[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (11))){
var inst_33266 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
var statearr_33307_33347 = state_33273__$1;
(statearr_33307_33347[(2)] = inst_33266);

(statearr_33307_33347[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (9))){
var inst_33186 = (state_33273[(7)]);
var inst_33198 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_33186,(4));
var inst_33199 = fluree.db.query.analytical.parse_block_from_source(inst_33198);
var inst_33200 = fluree.db.time_travel.as_of_block(db,inst_33199);
var state_33273__$1 = state_33273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33273__$1,(12),inst_33200);
} else {
if((state_val_33274 === (5))){
var _ = (function (){var statearr_33308 = state_33273;
(statearr_33308[(4)] = cljs.core.rest((state_33273[(4)])));

return statearr_33308;
})();
var state_33273__$1 = state_33273;
var ex33306 = (state_33273__$1[(2)]);
var statearr_33309_33348 = state_33273__$1;
(statearr_33309_33348[(5)] = ex33306);


if((ex33306 instanceof Error)){
var statearr_33310_33349 = state_33273__$1;
(statearr_33310_33349[(1)] = (4));

(statearr_33310_33349[(5)] = null);

} else {
throw ex33306;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (14))){
var state_33273__$1 = state_33273;
var statearr_33311_33350 = state_33273__$1;
(statearr_33311_33350[(2)] = null);

(statearr_33311_33350[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (26))){
var inst_33236 = (state_33273[(8)]);
var inst_33229 = (state_33273[(13)]);
var inst_33238 = fluree.db.time_travel.as_of_block(inst_33236,inst_33229);
var state_33273__$1 = state_33273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33273__$1,(29),inst_33238);
} else {
if((state_val_33274 === (16))){
var inst_33219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33220 = ["$wd",clause];
var inst_33221 = (new cljs.core.PersistentVector(null,2,(5),inst_33219,inst_33220,null));
var state_33273__$1 = state_33273;
var statearr_33312_33351 = state_33273__$1;
(statearr_33312_33351[(2)] = inst_33221);

(statearr_33312_33351[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (10))){
var inst_33186 = (state_33273[(7)]);
var inst_33217 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_33186);
var state_33273__$1 = state_33273;
if(inst_33217){
var statearr_33313_33352 = state_33273__$1;
(statearr_33313_33352[(1)] = (16));

} else {
var statearr_33314_33353 = state_33273__$1;
(statearr_33314_33353[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (18))){
var inst_33264 = (state_33273[(2)]);
var state_33273__$1 = state_33273;
var statearr_33315_33354 = state_33273__$1;
(statearr_33315_33354[(2)] = inst_33264);

(statearr_33315_33354[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33274 === (8))){
var inst_33268 = (state_33273[(2)]);
var _ = (function (){var statearr_33316 = state_33273;
(statearr_33316[(4)] = cljs.core.rest((state_33273[(4)])));

return statearr_33316;
})();
var state_33273__$1 = state_33273;
var statearr_33317_33355 = state_33273__$1;
(statearr_33317_33355[(2)] = inst_33268);

(statearr_33317_33355[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_33318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33318[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_33318[(1)] = (1));

return statearr_33318;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_33273){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33273);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33319){var ex__16304__auto__ = e33319;
var statearr_33320_33356 = state_33273;
(statearr_33320_33356[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33273[(4)]))){
var statearr_33321_33357 = state_33273;
(statearr_33321_33357[(1)] = cljs.core.first((state_33273[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33358 = state_33273;
state_33273 = G__33358;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_33273){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_33273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33322 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33322[(6)] = c__16375__auto__);

return statearr_33322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__33359){
var vec__33360 = p__33359;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33360,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33360,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33363_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__33363_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__33367 = subjects;
var vec__33368 = G__33367;
var seq__33369 = cljs.core.seq(vec__33368);
var first__33370 = cljs.core.first(seq__33369);
var seq__33369__$1 = cljs.core.next(seq__33369);
var subject = first__33370;
var r = seq__33369__$1;
var acc = expanded_map;
var G__33367__$1 = G__33367;
var acc__$1 = acc;
while(true){
var vec__33374 = G__33367__$1;
var seq__33375 = cljs.core.seq(vec__33374);
var first__33376 = cljs.core.first(seq__33375);
var seq__33375__$1 = cljs.core.next(seq__33375);
var subject__$1 = first__33376;
var r__$1 = seq__33375__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__33377 = r__$1;
var G__33378 = acc__$2;
G__33367__$1 = G__33377;
acc__$1 = G__33378;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__33367__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__33367__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__33367__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__33367__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__33367__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__33367__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__33374,seq__33375,first__33376,seq__33375__$1,subject__$1,r__$1,acc__$2,G__33367,vec__33368,seq__33369,first__33370,seq__33369__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__33379 = r__$1;
var G__33380 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__33367__$1 = G__33379;
acc__$1 = G__33380;
continue;
} else {
var G__33381 = subjects;
var G__33382 = acc_STAR_;
G__33367__$1 = G__33381;
acc__$1 = G__33382;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33383_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__33383_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33474){
var state_val_33475 = (state_33474[(1)]);
if((state_val_33475 === (7))){
var state_33474__$1 = state_33474;
var statearr_33476_33522 = state_33474__$1;
(statearr_33476_33522[(2)] = (100));

(statearr_33476_33522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (20))){
var inst_33423 = (state_33474[(7)]);
var state_33474__$1 = state_33474;
var statearr_33477_33523 = state_33474__$1;
(statearr_33477_33523[(2)] = inst_33423);

(statearr_33477_33523[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (1))){
var state_33474__$1 = state_33474;
var statearr_33478_33524 = state_33474__$1;
(statearr_33478_33524[(2)] = null);

(statearr_33478_33524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (24))){
var inst_33460 = (state_33474[(8)]);
var inst_33461 = (state_33474[(9)]);
var inst_33395 = (state_33474[(10)]);
var inst_33462 = (state_33474[(11)]);
var inst_33465 = (function (){var max_depth = inst_33395;
var recur_map__$1 = inst_33461;
var subjects = inst_33460;
var tuples = inst_33462;
return (function (p1__33384_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__33384_SHARP_)],null));
});
})();
var inst_33466 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33465,inst_33462);
var inst_33467 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_33466);
var state_33474__$1 = state_33474;
var statearr_33479_33525 = state_33474__$1;
(statearr_33479_33525[(2)] = inst_33467);

(statearr_33479_33525[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (4))){
var inst_33385 = (state_33474[(2)]);
var state_33474__$1 = state_33474;
var statearr_33480_33526 = state_33474__$1;
(statearr_33480_33526[(2)] = inst_33385);

(statearr_33480_33526[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (15))){
var inst_33408 = (state_33474[(12)]);
var inst_33419 = cljs.core.PersistentVector.EMPTY;
var inst_33420 = cljs.core.seq(inst_33408);
var inst_33421 = cljs.core.first(inst_33420);
var inst_33422 = cljs.core.next(inst_33420);
var inst_33423 = inst_33419;
var inst_33424 = inst_33408;
var state_33474__$1 = (function (){var statearr_33481 = state_33474;
(statearr_33481[(13)] = inst_33422);

(statearr_33481[(14)] = inst_33421);

(statearr_33481[(15)] = inst_33424);

(statearr_33481[(7)] = inst_33423);

return statearr_33481;
})();
var statearr_33482_33527 = state_33474__$1;
(statearr_33482_33527[(2)] = null);

(statearr_33482_33527[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (21))){
var inst_33444 = (state_33474[(2)]);
var state_33474__$1 = state_33474;
var statearr_33483_33528 = state_33474__$1;
(statearr_33483_33528[(2)] = inst_33444);

(statearr_33483_33528[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (13))){
var inst_33457 = (state_33474[(2)]);
var state_33474__$1 = state_33474;
var statearr_33484_33529 = state_33474__$1;
(statearr_33484_33529[(2)] = inst_33457);

(statearr_33484_33529[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (22))){
var inst_33431 = (state_33474[(16)]);
var inst_33423 = (state_33474[(7)]);
var inst_33438 = (state_33474[(2)]);
var inst_33439 = fluree.db.util.async.throw_err(inst_33438);
var inst_33440 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_33423,inst_33439);
var inst_33423__$1 = inst_33440;
var inst_33424 = inst_33431;
var state_33474__$1 = (function (){var statearr_33485 = state_33474;
(statearr_33485[(15)] = inst_33424);

(statearr_33485[(7)] = inst_33423__$1);

return statearr_33485;
})();
var statearr_33486_33530 = state_33474__$1;
(statearr_33486_33530[(2)] = null);

(statearr_33486_33530[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (6))){
var inst_33391 = (state_33474[(17)]);
var state_33474__$1 = state_33474;
var statearr_33487_33531 = state_33474__$1;
(statearr_33487_33531[(2)] = inst_33391);

(statearr_33487_33531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (25))){
var inst_33469 = (state_33474[(2)]);
var _ = (function (){var statearr_33488 = state_33474;
(statearr_33488[(4)] = cljs.core.rest((state_33474[(4)])));

return statearr_33488;
})();
var state_33474__$1 = state_33474;
var statearr_33489_33532 = state_33474__$1;
(statearr_33489_33532[(2)] = inst_33469);

(statearr_33489_33532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (17))){
var inst_33430 = (state_33474[(18)]);
var inst_33424 = (state_33474[(15)]);
var inst_33429 = cljs.core.seq(inst_33424);
var inst_33430__$1 = cljs.core.first(inst_33429);
var inst_33431 = cljs.core.next(inst_33429);
var state_33474__$1 = (function (){var statearr_33490 = state_33474;
(statearr_33490[(18)] = inst_33430__$1);

(statearr_33490[(16)] = inst_33431);

return statearr_33490;
})();
if(cljs.core.truth_(inst_33430__$1)){
var statearr_33491_33533 = state_33474__$1;
(statearr_33491_33533[(1)] = (19));

} else {
var statearr_33492_33534 = state_33474__$1;
(statearr_33492_33534[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (3))){
var inst_33472 = (state_33474[(2)]);
var state_33474__$1 = state_33474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33474__$1,inst_33472);
} else {
if((state_val_33475 === (12))){
var inst_33408 = (state_33474[(12)]);
var inst_33397 = (state_33474[(19)]);
var inst_33403 = cljs.core.vals(inst_33397);
var inst_33404 = cljs.core.flatten(inst_33403);
var inst_33405 = cljs.core.set(inst_33404);
var inst_33406 = cljs.core.keys(inst_33397);
var inst_33407 = cljs.core.set(inst_33406);
var inst_33408__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_33405,inst_33407);
var inst_33409 = cljs.core.empty_QMARK_(inst_33408__$1);
var state_33474__$1 = (function (){var statearr_33493 = state_33474;
(statearr_33493[(12)] = inst_33408__$1);

return statearr_33493;
})();
if(inst_33409){
var statearr_33494_33535 = state_33474__$1;
(statearr_33494_33535[(1)] = (14));

} else {
var statearr_33495_33536 = state_33474__$1;
(statearr_33495_33536[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (2))){
var inst_33391 = (state_33474[(17)]);
var _ = (function (){var statearr_33496 = state_33474;
(statearr_33496[(4)] = cljs.core.cons((5),(state_33474[(4)])));

return statearr_33496;
})();
var inst_33391__$1 = depth;
var state_33474__$1 = (function (){var statearr_33497 = state_33474;
(statearr_33497[(17)] = inst_33391__$1);

return statearr_33497;
})();
if(cljs.core.truth_(inst_33391__$1)){
var statearr_33498_33537 = state_33474__$1;
(statearr_33498_33537[(1)] = (6));

} else {
var statearr_33499_33538 = state_33474__$1;
(statearr_33499_33538[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (23))){
var inst_33462 = (state_33474[(11)]);
var state_33474__$1 = state_33474;
var statearr_33500_33539 = state_33474__$1;
(statearr_33500_33539[(2)] = inst_33462);

(statearr_33500_33539[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (19))){
var inst_33430 = (state_33474[(18)]);
var inst_33433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33434 = [inst_33430,predicate];
var inst_33435 = (new cljs.core.PersistentVector(null,2,(5),inst_33433,inst_33434,null));
var inst_33436 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33435);
var state_33474__$1 = state_33474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33474__$1,(22),inst_33436);
} else {
if((state_val_33475 === (11))){
var inst_33397 = (state_33474[(19)]);
var state_33474__$1 = state_33474;
var statearr_33502_33540 = state_33474__$1;
(statearr_33502_33540[(2)] = inst_33397);

(statearr_33502_33540[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (9))){
var inst_33398 = (state_33474[(20)]);
var inst_33395 = (state_33474[(10)]);
var inst_33400 = (inst_33398 >= inst_33395);
var state_33474__$1 = state_33474;
if(cljs.core.truth_(inst_33400)){
var statearr_33503_33541 = state_33474__$1;
(statearr_33503_33541[(1)] = (11));

} else {
var statearr_33504_33542 = state_33474__$1;
(statearr_33504_33542[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (5))){
var _ = (function (){var statearr_33505 = state_33474;
(statearr_33505[(4)] = cljs.core.rest((state_33474[(4)])));

return statearr_33505;
})();
var state_33474__$1 = state_33474;
var ex33501 = (state_33474__$1[(2)]);
var statearr_33506_33543 = state_33474__$1;
(statearr_33506_33543[(5)] = ex33501);


if((ex33501 instanceof Error)){
var statearr_33507_33544 = state_33474__$1;
(statearr_33507_33544[(1)] = (4));

(statearr_33507_33544[(5)] = null);

} else {
throw ex33501;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (14))){
var inst_33397 = (state_33474[(19)]);
var state_33474__$1 = state_33474;
var statearr_33508_33545 = state_33474__$1;
(statearr_33508_33545[(2)] = inst_33397);

(statearr_33508_33545[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (16))){
var inst_33455 = (state_33474[(2)]);
var state_33474__$1 = state_33474;
var statearr_33509_33546 = state_33474__$1;
(statearr_33509_33546[(2)] = inst_33455);

(statearr_33509_33546[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (10))){
var inst_33460 = (state_33474[(8)]);
var inst_33461 = (state_33474[(9)]);
var inst_33459 = (state_33474[(2)]);
var inst_33460__$1 = cljs.core.keys(inst_33459);
var inst_33461__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_33460__$1,inst_33459);
var inst_33462 = fluree.db.query.analytical.recur_map__GT_tuples(inst_33460__$1,inst_33461__$1);
var state_33474__$1 = (function (){var statearr_33510 = state_33474;
(statearr_33510[(8)] = inst_33460__$1);

(statearr_33510[(9)] = inst_33461__$1);

(statearr_33510[(11)] = inst_33462);

return statearr_33510;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_33511_33547 = state_33474__$1;
(statearr_33511_33547[(1)] = (23));

} else {
var statearr_33512_33548 = state_33474__$1;
(statearr_33512_33548[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (18))){
var inst_33398 = (state_33474[(20)]);
var inst_33397 = (state_33474[(19)]);
var inst_33446 = (state_33474[(2)]);
var inst_33447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33448 = [(0),(2)];
var inst_33449 = (new cljs.core.PersistentVector(null,2,(5),inst_33447,inst_33448,null));
var inst_33450 = fluree.db.query.analytical.get_ns_arrays(inst_33449,inst_33446);
var inst_33451 = fluree.db.query.analytical.tuples__GT_map(inst_33397,inst_33450);
var inst_33452 = (inst_33398 + (1));
var inst_33397__$1 = inst_33451;
var inst_33398__$1 = inst_33452;
var state_33474__$1 = (function (){var statearr_33513 = state_33474;
(statearr_33513[(20)] = inst_33398__$1);

(statearr_33513[(19)] = inst_33397__$1);

return statearr_33513;
})();
var statearr_33514_33549 = state_33474__$1;
(statearr_33514_33549[(2)] = null);

(statearr_33514_33549[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33475 === (8))){
var inst_33395 = (state_33474[(2)]);
var inst_33396 = recur_map;
var inst_33397 = inst_33396;
var inst_33398 = (1);
var state_33474__$1 = (function (){var statearr_33515 = state_33474;
(statearr_33515[(20)] = inst_33398);

(statearr_33515[(10)] = inst_33395);

(statearr_33515[(19)] = inst_33397);

return statearr_33515;
})();
var statearr_33516_33550 = state_33474__$1;
(statearr_33516_33550[(2)] = null);

(statearr_33516_33550[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_33517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33517[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__);

(statearr_33517[(1)] = (1));

return statearr_33517;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1 = (function (state_33474){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33474);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33518){var ex__16304__auto__ = e33518;
var statearr_33519_33551 = state_33474;
(statearr_33519_33551[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33474[(4)]))){
var statearr_33520_33552 = state_33474;
(statearr_33520_33552[(1)] = cljs.core.first((state_33474[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33553 = state_33474;
state_33474 = G__33553;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = function(state_33474){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1.call(this,state_33474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33521 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33521[(6)] = c__16375__auto__);

return statearr_33521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__33554,clause,fuel,max_fuel){
var map__33555 = p__33554;
var map__33555__$1 = (((((!((map__33555 == null))))?(((((map__33555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33555.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33555):map__33555);
var res = map__33555__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33555__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33555__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33555__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33687){
var state_val_33688 = (state_33687[(1)]);
if((state_val_33688 === (7))){
var state_33687__$1 = state_33687;
var statearr_33689_33755 = state_33687__$1;
(statearr_33689_33755[(2)] = false);

(statearr_33689_33755[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (20))){
var inst_33619 = (state_33687[(7)]);
var state_33687__$1 = state_33687;
var statearr_33690_33756 = state_33687__$1;
(statearr_33690_33756[(2)] = inst_33619);

(statearr_33690_33756[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (27))){
var inst_33623 = (state_33687[(8)]);
var inst_33647 = (state_33687[(2)]);
var state_33687__$1 = (function (){var statearr_33691 = state_33687;
(statearr_33691[(9)] = inst_33647);

return statearr_33691;
})();
if(cljs.core.truth_(inst_33623)){
var statearr_33692_33757 = state_33687__$1;
(statearr_33692_33757[(1)] = (28));

} else {
var statearr_33693_33758 = state_33687__$1;
(statearr_33693_33758[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (1))){
var state_33687__$1 = state_33687;
var statearr_33694_33759 = state_33687__$1;
(statearr_33694_33759[(2)] = null);

(statearr_33694_33759[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (24))){
var inst_33635 = (state_33687[(2)]);
var inst_33636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_33637 = fluree.db.query.analytical.variable_QMARK_(inst_33636);
var state_33687__$1 = (function (){var statearr_33695 = state_33687;
(statearr_33695[(10)] = inst_33635);

return statearr_33695;
})();
if(cljs.core.truth_(inst_33637)){
var statearr_33696_33760 = state_33687__$1;
(statearr_33696_33760[(1)] = (25));

} else {
var statearr_33697_33761 = state_33687__$1;
(statearr_33697_33761[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (4))){
var inst_33557 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
var statearr_33698_33762 = state_33687__$1;
(statearr_33698_33762[(2)] = inst_33557);

(statearr_33698_33762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (15))){
var inst_33605 = (state_33687[(11)]);
var state_33687__$1 = state_33687;
var statearr_33699_33763 = state_33687__$1;
(statearr_33699_33763[(2)] = inst_33605);

(statearr_33699_33763[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (21))){
var inst_33590 = (state_33687[(12)]);
var inst_33678 = (state_33687[(2)]);
var inst_33679 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_33680 = cljs.core.keys(inst_33590);
var inst_33681 = [inst_33680,vars,inst_33678];
var inst_33682 = cljs.core.PersistentHashMap.fromArrays(inst_33679,inst_33681);
var _ = (function (){var statearr_33700 = state_33687;
(statearr_33700[(4)] = cljs.core.rest((state_33687[(4)])));

return statearr_33700;
})();
var state_33687__$1 = state_33687;
var statearr_33701_33764 = state_33687__$1;
(statearr_33701_33764[(2)] = inst_33682);

(statearr_33701_33764[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (31))){
var inst_33619 = (state_33687[(7)]);
var inst_33621 = (state_33687[(13)]);
var inst_33654 = cljs.core.PersistentHashMap.EMPTY;
var inst_33655 = cljs.core.flatten(inst_33619);
var inst_33656 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33654,inst_33621,inst_33655);
var state_33687__$1 = state_33687;
var statearr_33702_33765 = state_33687__$1;
(statearr_33702_33765[(2)] = inst_33656);

(statearr_33702_33765[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (32))){
var inst_33621 = (state_33687[(13)]);
var inst_33658 = cljs.core.coll_QMARK_(inst_33621);
var state_33687__$1 = state_33687;
if(inst_33658){
var statearr_33703_33766 = state_33687__$1;
(statearr_33703_33766[(1)] = (34));

} else {
var statearr_33704_33767 = state_33687__$1;
(statearr_33704_33767[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (33))){
var inst_33669 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
var statearr_33705_33768 = state_33687__$1;
(statearr_33705_33768[(2)] = inst_33669);

(statearr_33705_33768[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (13))){
var inst_33567 = (state_33687[(14)]);
var state_33687__$1 = state_33687;
var statearr_33706_33769 = state_33687__$1;
(statearr_33706_33769[(2)] = inst_33567);

(statearr_33706_33769[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (22))){
var inst_33603 = (state_33687[(15)]);
var inst_33627 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33603)].join('');
var inst_33628 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33629 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33630 = cljs.core.PersistentHashMap.fromArrays(inst_33628,inst_33629);
var inst_33631 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33627,inst_33630);
var inst_33632 = (function(){throw inst_33631})();
var state_33687__$1 = state_33687;
var statearr_33707_33770 = state_33687__$1;
(statearr_33707_33770[(2)] = inst_33632);

(statearr_33707_33770[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (36))){
var inst_33667 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
var statearr_33708_33771 = state_33687__$1;
(statearr_33708_33771[(2)] = inst_33667);

(statearr_33708_33771[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (29))){
var inst_33621 = (state_33687[(13)]);
var inst_33652 = typeof inst_33621 === 'number';
var state_33687__$1 = state_33687;
if(cljs.core.truth_(inst_33652)){
var statearr_33709_33772 = state_33687__$1;
(statearr_33709_33772[(1)] = (31));

} else {
var statearr_33710_33773 = state_33687__$1;
(statearr_33710_33773[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (6))){
var inst_33567 = (state_33687[(14)]);
var inst_33572 = inst_33567.cljs$lang$protocol_mask$partition0$;
var inst_33573 = (inst_33572 & (64));
var inst_33574 = inst_33567.cljs$core$ISeq$;
var inst_33575 = (cljs.core.PROTOCOL_SENTINEL === inst_33574);
var inst_33576 = ((inst_33573) || (inst_33575));
var state_33687__$1 = state_33687;
if(cljs.core.truth_(inst_33576)){
var statearr_33711_33774 = state_33687__$1;
(statearr_33711_33774[(1)] = (9));

} else {
var statearr_33712_33775 = state_33687__$1;
(statearr_33712_33775[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (28))){
var inst_33619 = (state_33687[(7)]);
var inst_33649 = cljs.core.PersistentHashMap.EMPTY;
var inst_33650 = fluree.db.query.analytical.tuples__GT_map(inst_33649,inst_33619);
var state_33687__$1 = state_33687;
var statearr_33713_33776 = state_33687__$1;
(statearr_33713_33776[(2)] = inst_33650);

(statearr_33713_33776[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (25))){
var state_33687__$1 = state_33687;
var statearr_33714_33777 = state_33687__$1;
(statearr_33714_33777[(2)] = null);

(statearr_33714_33777[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (34))){
var inst_33619 = (state_33687[(7)]);
var inst_33615 = (state_33687[(16)]);
var inst_33660 = cljs.core.PersistentHashMap.EMPTY;
var inst_33661 = cljs.core.first(inst_33615);
var inst_33662 = cljs.core.first(inst_33661);
var inst_33663 = cljs.core.flatten(inst_33619);
var inst_33664 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33660,inst_33662,inst_33663);
var state_33687__$1 = state_33687;
var statearr_33715_33778 = state_33687__$1;
(statearr_33715_33778[(2)] = inst_33664);

(statearr_33715_33778[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (17))){
var inst_33603 = (state_33687[(15)]);
var inst_33604 = (state_33687[(17)]);
var inst_33609 = (state_33687[(2)]);
var inst_33610 = [inst_33609];
var inst_33611 = cljs.core.PersistentHashMap.fromArrays(inst_33604,inst_33610);
var inst_33612 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_33603,inst_33611);
var state_33687__$1 = state_33687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33687__$1,(18),inst_33612);
} else {
if((state_val_33688 === (3))){
var inst_33685 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33687__$1,inst_33685);
} else {
if((state_val_33688 === (12))){
var inst_33567 = (state_33687[(14)]);
var inst_33585 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33567);
var state_33687__$1 = state_33687;
var statearr_33716_33779 = state_33687__$1;
(statearr_33716_33779[(2)] = inst_33585);

(statearr_33716_33779[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (2))){
var inst_33567 = (state_33687[(14)]);
var _ = (function (){var statearr_33717 = state_33687;
(statearr_33717[(4)] = cljs.core.cons((5),(state_33687[(4)])));

return statearr_33717;
})();
var inst_33567__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_33569 = (inst_33567__$1 == null);
var inst_33570 = cljs.core.not(inst_33569);
var state_33687__$1 = (function (){var statearr_33718 = state_33687;
(statearr_33718[(14)] = inst_33567__$1);

return statearr_33718;
})();
if(inst_33570){
var statearr_33719_33780 = state_33687__$1;
(statearr_33719_33780[(1)] = (6));

} else {
var statearr_33720_33781 = state_33687__$1;
(statearr_33720_33781[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (23))){
var state_33687__$1 = state_33687;
var statearr_33721_33782 = state_33687__$1;
(statearr_33721_33782[(2)] = null);

(statearr_33721_33782[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (35))){
var state_33687__$1 = state_33687;
var statearr_33722_33783 = state_33687__$1;
(statearr_33722_33783[(2)] = null);

(statearr_33722_33783[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (19))){
var inst_33603 = (state_33687[(15)]);
var inst_33624 = (state_33687[(18)]);
var inst_33621 = cljs.core.first(inst_33603);
var inst_33622 = cljs.core.first(clause);
var inst_33623 = fluree.db.query.analytical.variable_QMARK_(inst_33622);
var inst_33624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_33603,(1));
var inst_33625 = fluree.db.query.analytical.variable_QMARK_(inst_33624__$1);
var state_33687__$1 = (function (){var statearr_33723 = state_33687;
(statearr_33723[(18)] = inst_33624__$1);

(statearr_33723[(8)] = inst_33623);

(statearr_33723[(13)] = inst_33621);

return statearr_33723;
})();
if(cljs.core.truth_(inst_33625)){
var statearr_33724_33784 = state_33687__$1;
(statearr_33724_33784[(1)] = (22));

} else {
var statearr_33725_33785 = state_33687__$1;
(statearr_33725_33785[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (11))){
var inst_33580 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
var statearr_33727_33786 = state_33687__$1;
(statearr_33727_33786[(2)] = inst_33580);

(statearr_33727_33786[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (9))){
var state_33687__$1 = state_33687;
var statearr_33728_33787 = state_33687__$1;
(statearr_33728_33787[(2)] = true);

(statearr_33728_33787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (5))){
var _ = (function (){var statearr_33729 = state_33687;
(statearr_33729[(4)] = cljs.core.rest((state_33687[(4)])));

return statearr_33729;
})();
var state_33687__$1 = state_33687;
var ex33726 = (state_33687__$1[(2)]);
var statearr_33730_33788 = state_33687__$1;
(statearr_33730_33788[(5)] = ex33726);


if((ex33726 instanceof Error)){
var statearr_33731_33789 = state_33687__$1;
(statearr_33731_33789[(1)] = (4));

(statearr_33731_33789[(5)] = null);

} else {
throw ex33726;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (14))){
var inst_33605 = (state_33687[(11)]);
var inst_33593 = (state_33687[(19)]);
var inst_33594 = (state_33687[(20)]);
var inst_33590 = (state_33687[(12)]);
var inst_33588 = (state_33687[(2)]);
var inst_33589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33588,cljs.core.cst$kw$search);
var inst_33590__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33588,cljs.core.cst$kw$rel);
var inst_33591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33588,cljs.core.cst$kw$opts);
var inst_33592 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_33593__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_33591);
var inst_33594__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_33591);
var inst_33596 = (function (){var map__33563 = inst_33588;
var search = inst_33589;
var rel = inst_33590__$1;
var opts = inst_33591;
var common_keys = inst_33592;
var object_fn = inst_33593__$1;
var recur_depth = inst_33594__$1;
return (function (p__33595,common_key){
var vec__33732 = p__33595;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33732,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33732,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__33735 = cljs.core._EQ_;
var expr__33736 = idx_of;
if(cljs.core.truth_((pred__33735.cljs$core$IFn$_invoke$arity$2 ? pred__33735.cljs$core$IFn$_invoke$arity$2((0),expr__33736) : pred__33735.call(null,(0),expr__33736)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__33735.cljs$core$IFn$_invoke$arity$2 ? pred__33735.cljs$core$IFn$_invoke$arity$2((1),expr__33736) : pred__33735.call(null,(1),expr__33736)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__33735.cljs$core$IFn$_invoke$arity$2 ? pred__33735.cljs$core$IFn$_invoke$arity$2((2),expr__33736) : pred__33735.call(null,(2),expr__33736)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__33736)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_33597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33598 = cljs.core.PersistentHashMap.EMPTY;
var inst_33599 = [inst_33598,inst_33589];
var inst_33600 = (new cljs.core.PersistentVector(null,2,(5),inst_33597,inst_33599,null));
var inst_33601 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33596,inst_33600,inst_33592);
var inst_33602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33601,(0),null);
var inst_33603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33601,(1),null);
var inst_33604 = [cljs.core.cst$kw$object_DASH_fn];
var inst_33605__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_33602);
var state_33687__$1 = (function (){var statearr_33738 = state_33687;
(statearr_33738[(11)] = inst_33605__$1);

(statearr_33738[(19)] = inst_33593__$1);

(statearr_33738[(15)] = inst_33603);

(statearr_33738[(20)] = inst_33594__$1);

(statearr_33738[(17)] = inst_33604);

(statearr_33738[(12)] = inst_33590__$1);

return statearr_33738;
})();
if(cljs.core.truth_(inst_33605__$1)){
var statearr_33739_33790 = state_33687__$1;
(statearr_33739_33790[(1)] = (15));

} else {
var statearr_33740_33791 = state_33687__$1;
(statearr_33740_33791[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (26))){
var inst_33603 = (state_33687[(15)]);
var inst_33640 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33603)].join('');
var inst_33641 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33642 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33643 = cljs.core.PersistentHashMap.fromArrays(inst_33641,inst_33642);
var inst_33644 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33640,inst_33643);
var inst_33645 = (function(){throw inst_33644})();
var state_33687__$1 = state_33687;
var statearr_33741_33792 = state_33687__$1;
(statearr_33741_33792[(2)] = inst_33645);

(statearr_33741_33792[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (16))){
var inst_33593 = (state_33687[(19)]);
var state_33687__$1 = state_33687;
var statearr_33742_33793 = state_33687__$1;
(statearr_33742_33793[(2)] = inst_33593);

(statearr_33742_33793[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (30))){
var inst_33624 = (state_33687[(18)]);
var inst_33594 = (state_33687[(20)]);
var inst_33623 = (state_33687[(8)]);
var inst_33671 = (state_33687[(2)]);
var inst_33672 = fluree.db.query.analytical.tuples__GT_recur(db,inst_33624,inst_33671,inst_33594,inst_33623);
var state_33687__$1 = state_33687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33687__$1,(37),inst_33672);
} else {
if((state_val_33688 === (10))){
var state_33687__$1 = state_33687;
var statearr_33743_33794 = state_33687__$1;
(statearr_33743_33794[(2)] = false);

(statearr_33743_33794[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (18))){
var inst_33615 = (state_33687[(16)]);
var inst_33594 = (state_33687[(20)]);
var inst_33590 = (state_33687[(12)]);
var inst_33614 = (state_33687[(2)]);
var inst_33615__$1 = fluree.db.util.async.throw_err(inst_33614);
var inst_33616 = cljs.core.count(inst_33615__$1);
var inst_33617 = fluree.db.query.analytical.add_fuel(inst_33616,fuel,max_fuel);
var inst_33618 = cljs.core.vals(inst_33590);
var inst_33619 = fluree.db.query.analytical.get_ns_arrays(inst_33618,inst_33615__$1);
var state_33687__$1 = (function (){var statearr_33744 = state_33687;
(statearr_33744[(7)] = inst_33619);

(statearr_33744[(16)] = inst_33615__$1);

(statearr_33744[(21)] = inst_33617);

return statearr_33744;
})();
if(cljs.core.truth_(inst_33594)){
var statearr_33745_33795 = state_33687__$1;
(statearr_33745_33795[(1)] = (19));

} else {
var statearr_33746_33796 = state_33687__$1;
(statearr_33746_33796[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (37))){
var inst_33674 = (state_33687[(2)]);
var inst_33675 = fluree.db.util.async.throw_err(inst_33674);
var state_33687__$1 = state_33687;
var statearr_33747_33797 = state_33687__$1;
(statearr_33747_33797[(2)] = inst_33675);

(statearr_33747_33797[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33688 === (8))){
var inst_33583 = (state_33687[(2)]);
var state_33687__$1 = state_33687;
if(cljs.core.truth_(inst_33583)){
var statearr_33748_33798 = state_33687__$1;
(statearr_33748_33798[(1)] = (12));

} else {
var statearr_33749_33799 = state_33687__$1;
(statearr_33749_33799[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33750 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33750[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_33750[(1)] = (1));

return statearr_33750;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_33687){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33687);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33751){var ex__16304__auto__ = e33751;
var statearr_33752_33800 = state_33687;
(statearr_33752_33800[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33687[(4)]))){
var statearr_33753_33801 = state_33687;
(statearr_33753_33801[(1)] = cljs.core.first((state_33687[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33802 = state_33687;
state_33687 = G__33802;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = function(state_33687){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_33687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33754 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33754[(6)] = c__16375__auto__);

return statearr_33754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__33803,res,clause){
var map__33804 = p__33803;
var map__33804__$1 = (((((!((map__33804 == null))))?(((((map__33804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33804):map__33804);
var db = map__33804__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33804__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33804__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33804__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33904){
var state_val_33905 = (state_33904[(1)]);
if((state_val_33905 === (7))){
var inst_33815 = (state_33904[(7)]);
var state_33904__$1 = state_33904;
var statearr_33906_33946 = state_33904__$1;
(statearr_33906_33946[(2)] = inst_33815);

(statearr_33906_33946[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (20))){
var inst_33895 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
var statearr_33907_33947 = state_33904__$1;
(statearr_33907_33947[(2)] = inst_33895);

(statearr_33907_33947[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (1))){
var state_33904__$1 = state_33904;
var statearr_33908_33948 = state_33904__$1;
(statearr_33908_33948[(2)] = null);

(statearr_33908_33948[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (24))){
var inst_33874 = (state_33904[(2)]);
var inst_33875 = fluree.db.util.async.throw_err(inst_33874);
var state_33904__$1 = state_33904;
var statearr_33909_33949 = state_33904__$1;
(statearr_33909_33949[(2)] = inst_33875);

(statearr_33909_33949[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (4))){
var inst_33808 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
var statearr_33910_33950 = state_33904__$1;
(statearr_33910_33950[(2)] = inst_33808);

(statearr_33910_33950[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (15))){
var inst_33817 = (state_33904[(8)]);
var inst_33815 = (state_33904[(7)]);
var inst_33836 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_33837 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_33838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33839 = [inst_33815];
var inst_33840 = (new cljs.core.PersistentVector(null,1,(5),inst_33838,inst_33839,null));
var inst_33841 = (function (){var subject_var = inst_33815;
var object_var = inst_33817;
var min_sid = inst_33836;
var max_sid = (0);
return (function (p1__33806_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__33806_SHARP_);
});
})();
var inst_33842 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_33836,(0));
var inst_33843 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33841,inst_33842);
var inst_33844 = cljs.core.PersistentHashMap.EMPTY;
var inst_33845 = [inst_33840,inst_33843,inst_33844];
var inst_33846 = cljs.core.PersistentHashMap.fromArrays(inst_33837,inst_33845);
var state_33904__$1 = state_33904;
var statearr_33911_33951 = state_33904__$1;
(statearr_33911_33951[(2)] = inst_33846);

(statearr_33911_33951[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (21))){
var inst_33868 = (state_33904[(9)]);
var state_33904__$1 = state_33904;
var statearr_33912_33952 = state_33904__$1;
(statearr_33912_33952[(2)] = inst_33868);

(statearr_33912_33952[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (13))){
var inst_33817 = (state_33904[(8)]);
var state_33904__$1 = state_33904;
if(cljs.core.truth_(inst_33817)){
var statearr_33913_33953 = state_33904__$1;
(statearr_33913_33953[(1)] = (18));

} else {
var statearr_33914_33954 = state_33904__$1;
(statearr_33914_33954[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (22))){
var inst_33868 = (state_33904[(9)]);
var inst_33872 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_33868);
var state_33904__$1 = state_33904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33904__$1,(24),inst_33872);
} else {
if((state_val_33905 === (6))){
var inst_33817 = (state_33904[(8)]);
var state_33904__$1 = state_33904;
var statearr_33915_33955 = state_33904__$1;
(statearr_33915_33955[(2)] = inst_33817);

(statearr_33915_33955[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (17))){
var inst_33865 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
var statearr_33916_33956 = state_33904__$1;
(statearr_33916_33956[(2)] = inst_33865);

(statearr_33916_33956[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (3))){
var inst_33902 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33904__$1,inst_33902);
} else {
if((state_val_33905 === (12))){
var inst_33830 = ["_tx",null,"_block",null];
var inst_33831 = (new cljs.core.PersistentArrayMap(null,2,inst_33830,null));
var inst_33832 = (new cljs.core.PersistentHashSet(null,inst_33831,null));
var inst_33833 = cljs.core.last(clause);
var inst_33834 = (inst_33832.cljs$core$IFn$_invoke$arity$1 ? inst_33832.cljs$core$IFn$_invoke$arity$1(inst_33833) : inst_33832.call(null,inst_33833));
var state_33904__$1 = state_33904;
if(cljs.core.truth_(inst_33834)){
var statearr_33917_33957 = state_33904__$1;
(statearr_33917_33957[(1)] = (15));

} else {
var statearr_33918_33958 = state_33904__$1;
(statearr_33918_33958[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (2))){
var inst_33815 = (state_33904[(7)]);
var _ = (function (){var statearr_33919 = state_33904;
(statearr_33919[(4)] = cljs.core.cons((5),(state_33904[(4)])));

return statearr_33919;
})();
var inst_33814 = cljs.core.first(clause);
var inst_33815__$1 = fluree.db.query.analytical.variable_QMARK_(inst_33814);
var inst_33816 = cljs.core.last(clause);
var inst_33817 = fluree.db.query.analytical.variable_QMARK_(inst_33816);
var state_33904__$1 = (function (){var statearr_33920 = state_33904;
(statearr_33920[(8)] = inst_33817);

(statearr_33920[(7)] = inst_33815__$1);

return statearr_33920;
})();
if(cljs.core.truth_(inst_33815__$1)){
var statearr_33921_33959 = state_33904__$1;
(statearr_33921_33959[(1)] = (6));

} else {
var statearr_33922_33960 = state_33904__$1;
(statearr_33922_33960[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (23))){
var inst_33817 = (state_33904[(8)]);
var inst_33877 = (state_33904[(2)]);
var inst_33878 = fluree.db.flake.sid__GT_cid(inst_33877);
var inst_33879 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_33878);
var inst_33880 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_33881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33882 = [inst_33817];
var inst_33883 = (new cljs.core.PersistentVector(null,1,(5),inst_33881,inst_33882,null));
var inst_33884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33886 = [inst_33879];
var inst_33887 = (new cljs.core.PersistentVector(null,1,(5),inst_33885,inst_33886,null));
var inst_33888 = [inst_33887];
var inst_33889 = (new cljs.core.PersistentVector(null,1,(5),inst_33884,inst_33888,null));
var inst_33890 = cljs.core.PersistentHashMap.EMPTY;
var inst_33891 = [inst_33883,inst_33889,inst_33890];
var inst_33892 = cljs.core.PersistentHashMap.fromArrays(inst_33880,inst_33891);
var state_33904__$1 = state_33904;
var statearr_33923_33961 = state_33904__$1;
(statearr_33923_33961[(2)] = inst_33892);

(statearr_33923_33961[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (19))){
var state_33904__$1 = state_33904;
var statearr_33924_33962 = state_33904__$1;
(statearr_33924_33962[(2)] = null);

(statearr_33924_33962[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (11))){
var inst_33899 = (state_33904[(2)]);
var _ = (function (){var statearr_33926 = state_33904;
(statearr_33926[(4)] = cljs.core.rest((state_33904[(4)])));

return statearr_33926;
})();
var state_33904__$1 = state_33904;
var statearr_33927_33963 = state_33904__$1;
(statearr_33927_33963[(2)] = inst_33899);

(statearr_33927_33963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (9))){
var inst_33823 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33824 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33825 = cljs.core.PersistentHashMap.fromArrays(inst_33823,inst_33824);
var inst_33826 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_33825);
var inst_33827 = (function(){throw inst_33826})();
var state_33904__$1 = state_33904;
var statearr_33928_33964 = state_33904__$1;
(statearr_33928_33964[(2)] = inst_33827);

(statearr_33928_33964[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (5))){
var _ = (function (){var statearr_33929 = state_33904;
(statearr_33929[(4)] = cljs.core.rest((state_33904[(4)])));

return statearr_33929;
})();
var state_33904__$1 = state_33904;
var ex33925 = (state_33904__$1[(2)]);
var statearr_33930_33965 = state_33904__$1;
(statearr_33930_33965[(5)] = ex33925);


if((ex33925 instanceof Error)){
var statearr_33931_33966 = state_33904__$1;
(statearr_33931_33966[(1)] = (4));

(statearr_33931_33966[(5)] = null);

} else {
throw ex33925;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (14))){
var inst_33897 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
var statearr_33932_33967 = state_33904__$1;
(statearr_33932_33967[(2)] = inst_33897);

(statearr_33932_33967[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (16))){
var inst_33817 = (state_33904[(8)]);
var inst_33815 = (state_33904[(7)]);
var inst_33848 = cljs.core.last(clause);
var inst_33849 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_33848);
var inst_33850 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_33851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33850,inst_33849);
var inst_33852 = fluree.db.flake.min_subject_id(inst_33849);
var inst_33853 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_33854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33855 = [inst_33815];
var inst_33856 = (new cljs.core.PersistentVector(null,1,(5),inst_33854,inst_33855,null));
var inst_33857 = (function (){var subject_var = inst_33815;
var object_var = inst_33817;
var cid = inst_33849;
var max_sid = inst_33851;
var min_sid = inst_33852;
return (function (p1__33807_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__33807_SHARP_);
});
})();
var inst_33858 = (inst_33851 + (1));
var inst_33859 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_33852,inst_33858);
var inst_33860 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33857,inst_33859);
var inst_33861 = cljs.core.PersistentHashMap.EMPTY;
var inst_33862 = [inst_33856,inst_33860,inst_33861];
var inst_33863 = cljs.core.PersistentHashMap.fromArrays(inst_33853,inst_33862);
var state_33904__$1 = state_33904;
var statearr_33933_33968 = state_33904__$1;
(statearr_33933_33968[(2)] = inst_33863);

(statearr_33933_33968[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (10))){
var inst_33815 = (state_33904[(7)]);
var state_33904__$1 = state_33904;
if(cljs.core.truth_(inst_33815)){
var statearr_33934_33969 = state_33904__$1;
(statearr_33934_33969[(1)] = (12));

} else {
var statearr_33935_33970 = state_33904__$1;
(statearr_33935_33970[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (18))){
var inst_33868 = (state_33904[(9)]);
var inst_33868__$1 = cljs.core.first(clause);
var inst_33869 = typeof inst_33868__$1 === 'number';
var state_33904__$1 = (function (){var statearr_33936 = state_33904;
(statearr_33936[(9)] = inst_33868__$1);

return statearr_33936;
})();
if(cljs.core.truth_(inst_33869)){
var statearr_33937_33971 = state_33904__$1;
(statearr_33937_33971[(1)] = (21));

} else {
var statearr_33938_33972 = state_33904__$1;
(statearr_33938_33972[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33905 === (8))){
var inst_33821 = (state_33904[(2)]);
var state_33904__$1 = state_33904;
if(cljs.core.truth_(inst_33821)){
var statearr_33939_33973 = state_33904__$1;
(statearr_33939_33973[(1)] = (9));

} else {
var statearr_33940_33974 = state_33904__$1;
(statearr_33940_33974[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33941 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33941[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__);

(statearr_33941[(1)] = (1));

return statearr_33941;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1 = (function (state_33904){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33904);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33942){var ex__16304__auto__ = e33942;
var statearr_33943_33975 = state_33904;
(statearr_33943_33975[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33904[(4)]))){
var statearr_33944_33976 = state_33904;
(statearr_33944_33976[(1)] = cljs.core.first((state_33904[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33977 = state_33904;
state_33904 = G__33977;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = function(state_33904){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1.call(this,state_33904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33945 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33945[(6)] = c__16375__auto__);

return statearr_33945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__33984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__33984 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__33984;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__33985(s__33986){
return (new cljs.core.LazySeq(null,(function (){
var s__33986__$1 = s__33986;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__33986__$1);
if(temp__5735__auto__){
var s__33986__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33986__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__33986__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__33988 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__33987 = (0);
while(true){
if((i__33987 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__33987);
var delta = (x - mean);
cljs.core.chunk_append(b__33988,(delta * delta));

var G__33990 = (i__33987 + (1));
i__33987 = G__33990;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33988),fluree$db$query$analytical$variance_$_iter__33985(cljs.core.chunk_rest(s__33986__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33988),null);
}
} else {
var x = cljs.core.first(s__33986__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__33985(cljs.core.rest(s__33986__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__33989 = variance(coll);
return Math.sqrt(G__33989);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__33991 = null;
var G__33991__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__33991__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__33991 = function(n,coll){
switch(arguments.length){
case 1:
return G__33991__1.call(this,n);
case 2:
return G__33991__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33991.cljs$core$IFn$_invoke$arity$1 = G__33991__1;
G__33991.cljs$core$IFn$_invoke$arity$2 = G__33991__2;
return G__33991;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__33992 = null;
var G__33992__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__33992__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__33992 = function(n,coll){
switch(arguments.length){
case 1:
return G__33992__1.call(this,n);
case 2:
return G__33992__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33992.cljs$core$IFn$_invoke$arity$1 = G__33992__1;
G__33992.cljs$core$IFn$_invoke$arity$2 = G__33992__2;
return G__33992;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__33993 = null;
var G__33993__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__33993__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__33993 = function(n,coll){
switch(arguments.length){
case 1:
return G__33993__1.call(this,n);
case 2:
return G__33993__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33993.cljs$core$IFn$_invoke$arity$1 = G__33993__1;
G__33993.cljs$core$IFn$_invoke$arity$2 = G__33993__2;
return G__33993;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__33994 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33994,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33994,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33994,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__33997 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__34000 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__34000) : agg_fn.call(null,G__34000));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33997,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33997,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__34001 = agg;
var map__34001__$1 = (((((!((map__34001 == null))))?(((((map__34001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34001.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34001):map__34001);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34001__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34001__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34001__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__34004 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34004,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34004,(1),null);
var map__34007 = res__$1;
var map__34007__$1 = (((((!((map__34007 == null))))?(((((map__34007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34007.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34007):map__34007);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34007__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34007__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34003_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__34003_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34009_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34009_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34010_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34010_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34011_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34011_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34012_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34012_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__34015,row,b_tuple){
var vec__34016 = p__34015;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34016,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34016,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34013_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34013_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34014_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34014_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34019_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__34019_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34020_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34020_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34025 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34027 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__34026 = (function (p1__34021_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34021_SHARP_);
});
return fexpr__34026(G__34027);
})()),cljs.core.set(b_idxs));
var fexpr__34024 = (function (p1__34022_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34022_SHARP_);
});
return fexpr__34024(G__34025);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34023_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34023_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34028_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34028_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34029_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34029_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34034 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34036 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34035 = (function (p1__34030_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34030_SHARP_);
});
return fexpr__34035(G__34036);
})()),cljs.core.set(b_idxs));
var fexpr__34033 = (function (p1__34031_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34031_SHARP_);
});
return fexpr__34033(G__34034);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34032_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34032_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34037_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34037_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34038_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34038_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34047 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34049 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34048 = (function (p1__34039_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34039_SHARP_);
});
return fexpr__34048(G__34049);
})()),cljs.core.set(b_idxs));
var fexpr__34046 = (function (p1__34040_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34040_SHARP_);
});
return fexpr__34046(G__34047);
})();
var vec__34043 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__34050,a_tuple){
var vec__34051 = p__34050;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34051,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34051,(1),null);
var vec__34054 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34054,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34054,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34043,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34043,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34041_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34041_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34042_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34042_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__34058 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34058,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34058,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34057_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__34057_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__34063 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34063,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34063,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34061_SHARP_){
return fluree.db.util.core.index_of(headers,p1__34061_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__34062_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__34062_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__34066,filters,optional_QMARK_){
var map__34067 = p__34066;
var map__34067__$1 = (((((!((map__34067 == null))))?(((((map__34067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34067):map__34067);
var tuple_map = map__34067__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34067__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34067__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34067__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__34069 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34069,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34069,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__34072 = res;
var map__34072__$1 = (((((!((map__34072 == null))))?(((((map__34072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34072.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34072):map__34072);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34072__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34072__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34129){
var state_val_34130 = (state_34129[(1)]);
if((state_val_34130 === (7))){
var inst_34103 = (state_34129[(7)]);
var inst_34101 = (state_34129[(2)]);
var inst_34102 = fluree.db.util.async.throw_err(inst_34101);
var inst_34103__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34102,(0),null);
var inst_34104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34102,(1),null);
var inst_34105 = (inst_34103__$1 == null);
var state_34129__$1 = (function (){var statearr_34131 = state_34129;
(statearr_34131[(8)] = inst_34104);

(statearr_34131[(7)] = inst_34103__$1);

return statearr_34131;
})();
if(cljs.core.truth_(inst_34105)){
var statearr_34132_34161 = state_34129__$1;
(statearr_34132_34161[(1)] = (8));

} else {
var statearr_34133_34162 = state_34129__$1;
(statearr_34133_34162[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (1))){
var inst_34081 = optional_clauses;
var inst_34082 = cljs.core.seq(inst_34081);
var inst_34083 = cljs.core.first(inst_34082);
var inst_34084 = cljs.core.next(inst_34082);
var inst_34085 = where_tuples;
var inst_34086 = inst_34081;
var inst_34087 = inst_34085;
var state_34129__$1 = (function (){var statearr_34134 = state_34129;
(statearr_34134[(9)] = inst_34083);

(statearr_34134[(10)] = inst_34084);

(statearr_34134[(11)] = inst_34086);

(statearr_34134[(12)] = inst_34087);

return statearr_34134;
})();
var statearr_34135_34163 = state_34129__$1;
(statearr_34135_34163[(2)] = null);

(statearr_34135_34163[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (4))){
var inst_34094 = (state_34129[(13)]);
var inst_34093 = (state_34129[(14)]);
var inst_34087 = (state_34129[(12)]);
var inst_34099 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_34087,inst_34093,inst_34094,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_34087,inst_34093,inst_34094,true,fuel,max_fuel,opts));
var state_34129__$1 = state_34129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34129__$1,(7),inst_34099);
} else {
if((state_val_34130 === (15))){
var state_34129__$1 = state_34129;
var statearr_34136_34164 = state_34129__$1;
(statearr_34136_34164[(2)] = null);

(statearr_34136_34164[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (13))){
var inst_34120 = (state_34129[(2)]);
var state_34129__$1 = state_34129;
var statearr_34137_34165 = state_34129__$1;
(statearr_34137_34165[(2)] = inst_34120);

(statearr_34137_34165[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (6))){
var inst_34125 = (state_34129[(2)]);
var state_34129__$1 = state_34129;
var statearr_34138_34166 = state_34129__$1;
(statearr_34138_34166[(2)] = inst_34125);

(statearr_34138_34166[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (3))){
var inst_34127 = (state_34129[(2)]);
var state_34129__$1 = state_34129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34129__$1,inst_34127);
} else {
if((state_val_34130 === (12))){
var state_34129__$1 = state_34129;
var statearr_34139_34167 = state_34129__$1;
(statearr_34139_34167[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (2))){
var inst_34086 = (state_34129[(11)]);
var inst_34093 = (state_34129[(14)]);
var inst_34092 = cljs.core.seq(inst_34086);
var inst_34093__$1 = cljs.core.first(inst_34092);
var inst_34094 = cljs.core.next(inst_34092);
var state_34129__$1 = (function (){var statearr_34141 = state_34129;
(statearr_34141[(13)] = inst_34094);

(statearr_34141[(14)] = inst_34093__$1);

return statearr_34141;
})();
if(cljs.core.truth_(inst_34093__$1)){
var statearr_34142_34168 = state_34129__$1;
(statearr_34142_34168[(1)] = (4));

} else {
var statearr_34143_34169 = state_34129__$1;
(statearr_34143_34169[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (11))){
var inst_34104 = (state_34129[(8)]);
var inst_34103 = (state_34129[(7)]);
var inst_34086 = inst_34104;
var inst_34087 = inst_34103;
var state_34129__$1 = (function (){var statearr_34144 = state_34129;
(statearr_34144[(11)] = inst_34086);

(statearr_34144[(12)] = inst_34087);

return statearr_34144;
})();
var statearr_34145_34170 = state_34129__$1;
(statearr_34145_34170[(2)] = null);

(statearr_34145_34170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (9))){
var inst_34093 = (state_34129[(14)]);
var inst_34109 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_34093);
var state_34129__$1 = state_34129;
if(cljs.core.truth_(inst_34109)){
var statearr_34146_34171 = state_34129__$1;
(statearr_34146_34171[(1)] = (11));

} else {
var statearr_34147_34172 = state_34129__$1;
(statearr_34147_34172[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (5))){
var inst_34087 = (state_34129[(12)]);
var state_34129__$1 = state_34129;
var statearr_34148_34173 = state_34129__$1;
(statearr_34148_34173[(2)] = inst_34087);

(statearr_34148_34173[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (14))){
var inst_34104 = (state_34129[(8)]);
var inst_34087 = (state_34129[(12)]);
var inst_34103 = (state_34129[(7)]);
var inst_34114 = fluree.db.query.analytical.left_outer_join(inst_34087,inst_34103);
var inst_34086 = inst_34104;
var inst_34087__$1 = inst_34114;
var state_34129__$1 = (function (){var statearr_34149 = state_34129;
(statearr_34149[(11)] = inst_34086);

(statearr_34149[(12)] = inst_34087__$1);

return statearr_34149;
})();
var statearr_34150_34174 = state_34129__$1;
(statearr_34150_34174[(2)] = null);

(statearr_34150_34174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (16))){
var inst_34118 = (state_34129[(2)]);
var state_34129__$1 = state_34129;
var statearr_34152_34175 = state_34129__$1;
(statearr_34152_34175[(2)] = inst_34118);

(statearr_34152_34175[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (10))){
var inst_34122 = (state_34129[(2)]);
var state_34129__$1 = state_34129;
var statearr_34153_34176 = state_34129__$1;
(statearr_34153_34176[(2)] = inst_34122);

(statearr_34153_34176[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34130 === (8))){
var inst_34104 = (state_34129[(8)]);
var inst_34087 = (state_34129[(12)]);
var tmp34151 = inst_34087;
var inst_34086 = inst_34104;
var inst_34087__$1 = tmp34151;
var state_34129__$1 = (function (){var statearr_34154 = state_34129;
(statearr_34154[(11)] = inst_34086);

(statearr_34154[(12)] = inst_34087__$1);

return statearr_34154;
})();
var statearr_34155_34177 = state_34129__$1;
(statearr_34155_34177[(2)] = null);

(statearr_34155_34177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0 = (function (){
var statearr_34156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34156[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__);

(statearr_34156[(1)] = (1));

return statearr_34156;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1 = (function (state_34129){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34129);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34157){var ex__16304__auto__ = e34157;
var statearr_34158_34178 = state_34129;
(statearr_34158_34178[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34129[(4)]))){
var statearr_34159_34179 = state_34129;
(statearr_34159_34179[(1)] = cljs.core.first((state_34129[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34180 = state_34129;
state_34129 = G__34180;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = function(state_34129){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1.call(this,state_34129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34160 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34160[(6)] = c__16375__auto__);

return statearr_34160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34182){
var vec__34183 = p__34182;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34183,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34183,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34181_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34181_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__34187,p__34188,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__34189 = p__34187;
var map__34189__$1 = (((((!((map__34189 == null))))?(((((map__34189.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34189.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34189):map__34189);
var q_map = map__34189__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34189__$1,cljs.core.cst$kw$prefixes);
var map__34190 = p__34188;
var map__34190__$1 = (((((!((map__34190 == null))))?(((((map__34190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34190.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34190):map__34190);
var res = map__34190__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34190__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34399){
var state_val_34400 = (state_34399[(1)]);
if((state_val_34400 === (7))){
var inst_34297 = cljs.core.count(clause);
var inst_34298 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34297);
var inst_34299 = cljs.core.second(clause);
var inst_34300 = clojure.string.starts_with_QMARK_(inst_34299,"fullText:");
var inst_34301 = ((inst_34298) && (inst_34300));
var state_34399__$1 = state_34399;
if(cljs.core.truth_(inst_34301)){
var statearr_34401_34496 = state_34399__$1;
(statearr_34401_34496[(1)] = (31));

} else {
var statearr_34402_34497 = state_34399__$1;
(statearr_34402_34497[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (59))){
var inst_34368 = (state_34399[(7)]);
var inst_34371 = (state_34399[(2)]);
var inst_34372 = fluree.db.util.async.throw_err(inst_34371);
var inst_34373 = [inst_34372,r];
var inst_34374 = (new cljs.core.PersistentVector(null,2,(5),inst_34368,inst_34373,null));
var state_34399__$1 = state_34399;
var statearr_34403_34498 = state_34399__$1;
(statearr_34403_34498[(2)] = inst_34374);

(statearr_34403_34498[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (20))){
var inst_34261 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34404_34499 = state_34399__$1;
(statearr_34404_34499[(2)] = inst_34261);

(statearr_34404_34499[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (58))){
var inst_34377 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34405_34500 = state_34399__$1;
(statearr_34405_34500[(2)] = inst_34377);

(statearr_34405_34500[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (27))){
var inst_34291 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34406_34501 = state_34399__$1;
(statearr_34406_34501[(2)] = inst_34291);

(statearr_34406_34501[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (1))){
var state_34399__$1 = state_34399;
var statearr_34407_34502 = state_34399__$1;
(statearr_34407_34502[(2)] = null);

(statearr_34407_34502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (24))){
var inst_34255 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34408_34503 = state_34399__$1;
(statearr_34408_34503[(2)] = inst_34255);

(statearr_34408_34503[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (55))){
var inst_34379 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34409_34504 = state_34399__$1;
(statearr_34409_34504[(2)] = inst_34379);

(statearr_34409_34504[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (39))){
var inst_34333 = cljs.core.count(clause);
var inst_34334 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_34333);
var state_34399__$1 = state_34399;
if(inst_34334){
var statearr_34410_34505 = state_34399__$1;
(statearr_34410_34505[(1)] = (42));

} else {
var statearr_34411_34506 = state_34399__$1;
(statearr_34411_34506[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (46))){
var state_34399__$1 = state_34399;
var statearr_34412_34507 = state_34399__$1;
(statearr_34412_34507[(2)] = null);

(statearr_34412_34507[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (4))){
var inst_34193 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34413_34508 = state_34399__$1;
(statearr_34413_34508[(2)] = inst_34193);

(statearr_34413_34508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (54))){
var state_34399__$1 = state_34399;
var statearr_34414_34509 = state_34399__$1;
(statearr_34414_34509[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (15))){
var inst_34293 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34416_34510 = state_34399__$1;
(statearr_34416_34510[(2)] = inst_34293);

(statearr_34416_34510[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (48))){
var inst_34350 = (state_34399[(8)]);
var inst_34348 = (state_34399[(2)]);
var inst_34349 = fluree.db.util.async.throw_err(inst_34348);
var inst_34350__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34349,(0),null);
var inst_34351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34349,(1),null);
var inst_34352 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34350__$1);
var state_34399__$1 = (function (){var statearr_34417 = state_34399;
(statearr_34417[(9)] = inst_34351);

(statearr_34417[(8)] = inst_34350__$1);

return statearr_34417;
})();
if(inst_34352){
var statearr_34418_34511 = state_34399__$1;
(statearr_34418_34511[(1)] = (49));

} else {
var statearr_34419_34512 = state_34399__$1;
(statearr_34419_34512[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (50))){
var inst_34351 = (state_34399[(9)]);
var inst_34359 = cljs.core.second(inst_34351);
var inst_34360 = clojure.string.starts_with_QMARK_(inst_34359,"fullText:");
var state_34399__$1 = state_34399;
if(inst_34360){
var statearr_34420_34513 = state_34399__$1;
(statearr_34420_34513[(1)] = (53));

} else {
var statearr_34421_34514 = state_34399__$1;
(statearr_34421_34514[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (21))){
var inst_34227 = (state_34399[(10)]);
var inst_34229 = (state_34399[(11)]);
var inst_34238 = (state_34399[(12)]);
var inst_34202 = (state_34399[(13)]);
var inst_34232 = (state_34399[(14)]);
var inst_34230 = (state_34399[(15)]);
var inst_34206 = (state_34399[(16)]);
var inst_34239 = (state_34399[(17)]);
var inst_34231 = (state_34399[(18)]);
var inst_34243 = (state_34399[(2)]);
var inst_34244 = fluree.db.util.async.throw_err(inst_34243);
var inst_34245 = (function (){var new_res = inst_34244;
var vec__34224 = inst_34227;
var rest = inst_34239;
var tuples = inst_34232;
var seq__34225 = inst_34230;
var G__34223 = inst_34231;
var first__34226 = inst_34229;
var expr__34204 = inst_34202;
var pred__34203 = inst_34206;
var seq__34235 = inst_34239;
var first__34236 = inst_34238;
var segment_type = inst_34202;
var vec__34234 = inst_34231;
var clause_group = inst_34238;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_34246 = cljs.core.keys(vars);
var inst_34247 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34245,inst_34244,inst_34246);
var inst_34248 = fluree.db.query.analytical.res_absorb_vars(inst_34247);
var state_34399__$1 = (function (){var statearr_34422 = state_34399;
(statearr_34422[(19)] = inst_34248);

return statearr_34422;
})();
if(cljs.core.truth_(inst_34232)){
var statearr_34423_34515 = state_34399__$1;
(statearr_34423_34515[(1)] = (22));

} else {
var statearr_34424_34516 = state_34399__$1;
(statearr_34424_34516[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (31))){
var inst_34303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34304 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_34305 = [inst_34304,r];
var inst_34306 = (new cljs.core.PersistentVector(null,2,(5),inst_34303,inst_34305,null));
var state_34399__$1 = state_34399;
var statearr_34425_34517 = state_34399__$1;
(statearr_34425_34517[(2)] = inst_34306);

(statearr_34425_34517[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (32))){
var inst_34308 = cljs.core.count(clause);
var inst_34309 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34308);
var inst_34310 = cljs.core.second(clause);
var inst_34311 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34310,"rdf:type");
var inst_34312 = ((inst_34309) && (inst_34311));
var state_34399__$1 = state_34399;
if(cljs.core.truth_(inst_34312)){
var statearr_34426_34518 = state_34399__$1;
(statearr_34426_34518[(1)] = (34));

} else {
var statearr_34427_34519 = state_34399__$1;
(statearr_34427_34519[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (40))){
var inst_34388 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34428_34520 = state_34399__$1;
(statearr_34428_34520[(2)] = inst_34388);

(statearr_34428_34520[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (56))){
var inst_34351 = (state_34399[(9)]);
var inst_34350 = (state_34399[(8)]);
var inst_34368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34369 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_34350,res,inst_34351,fuel,max_fuel);
var state_34399__$1 = (function (){var statearr_34429 = state_34399;
(statearr_34429[(7)] = inst_34368);

return statearr_34429;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(59),inst_34369);
} else {
if((state_val_34400 === (33))){
var inst_34392 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34430_34521 = state_34399__$1;
(statearr_34430_34521[(2)] = inst_34392);

(statearr_34430_34521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (13))){
var inst_34227 = (state_34399[(10)]);
var inst_34227__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34228 = cljs.core.seq(inst_34227__$1);
var inst_34229 = cljs.core.first(inst_34228);
var inst_34230 = cljs.core.next(inst_34228);
var inst_34231 = inst_34227__$1;
var inst_34232 = null;
var state_34399__$1 = (function (){var statearr_34431 = state_34399;
(statearr_34431[(10)] = inst_34227__$1);

(statearr_34431[(11)] = inst_34229);

(statearr_34431[(14)] = inst_34232);

(statearr_34431[(15)] = inst_34230);

(statearr_34431[(18)] = inst_34231);

return statearr_34431;
})();
var statearr_34432_34522 = state_34399__$1;
(statearr_34432_34522[(2)] = null);

(statearr_34432_34522[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (22))){
var inst_34248 = (state_34399[(19)]);
var inst_34232 = (state_34399[(14)]);
var inst_34239 = (state_34399[(17)]);
var inst_34250 = fluree.db.query.analytical.outer_union(inst_34232,inst_34248);
var inst_34231 = inst_34239;
var inst_34232__$1 = inst_34250;
var state_34399__$1 = (function (){var statearr_34433 = state_34399;
(statearr_34433[(14)] = inst_34232__$1);

(statearr_34433[(18)] = inst_34231);

return statearr_34433;
})();
var statearr_34434_34523 = state_34399__$1;
(statearr_34434_34523[(2)] = null);

(statearr_34434_34523[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (36))){
var inst_34390 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34435_34524 = state_34399__$1;
(statearr_34435_34524[(2)] = inst_34390);

(statearr_34435_34524[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (41))){
var inst_34325 = (state_34399[(20)]);
var inst_34328 = (state_34399[(2)]);
var inst_34329 = fluree.db.util.async.throw_err(inst_34328);
var inst_34330 = [inst_34329,r];
var inst_34331 = (new cljs.core.PersistentVector(null,2,(5),inst_34325,inst_34330,null));
var state_34399__$1 = state_34399;
var statearr_34436_34525 = state_34399__$1;
(statearr_34436_34525[(2)] = inst_34331);

(statearr_34436_34525[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (43))){
var state_34399__$1 = state_34399;
var statearr_34437_34526 = state_34399__$1;
(statearr_34437_34526[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (29))){
var inst_34202 = (state_34399[(13)]);
var inst_34285 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34202)].join('');
var inst_34286 = (new Error(inst_34285));
var inst_34287 = (function(){throw inst_34286})();
var state_34399__$1 = state_34399;
var statearr_34439_34527 = state_34399__$1;
(statearr_34439_34527[(2)] = inst_34287);

(statearr_34439_34527[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (44))){
var inst_34386 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34440_34528 = state_34399__$1;
(statearr_34440_34528[(2)] = inst_34386);

(statearr_34440_34528[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (6))){
var inst_34202 = (state_34399[(13)]);
var inst_34206 = (state_34399[(16)]);
var inst_34201 = cljs.core.keys(clause);
var inst_34202__$1 = cljs.core.first(inst_34201);
var inst_34206__$1 = cljs.core._EQ_;
var inst_34207 = (function (){var G__34441 = cljs.core.cst$kw$optional;
var G__34442 = inst_34202__$1;
return (inst_34206__$1.cljs$core$IFn$_invoke$arity$2 ? inst_34206__$1.cljs$core$IFn$_invoke$arity$2(G__34441,G__34442) : inst_34206__$1.call(null,G__34441,G__34442));
})();
var state_34399__$1 = (function (){var statearr_34443 = state_34399;
(statearr_34443[(13)] = inst_34202__$1);

(statearr_34443[(16)] = inst_34206__$1);

return statearr_34443;
})();
if(cljs.core.truth_(inst_34207)){
var statearr_34444_34529 = state_34399__$1;
(statearr_34444_34529[(1)] = (9));

} else {
var statearr_34445_34530 = state_34399__$1;
(statearr_34445_34530[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (28))){
var inst_34279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34280 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34281 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_34280,optional_QMARK_);
var inst_34282 = [inst_34281,r];
var inst_34283 = (new cljs.core.PersistentVector(null,2,(5),inst_34279,inst_34282,null));
var state_34399__$1 = state_34399;
var statearr_34446_34531 = state_34399__$1;
(statearr_34446_34531[(2)] = inst_34283);

(statearr_34446_34531[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (51))){
var inst_34381 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34447_34532 = state_34399__$1;
(statearr_34447_34532[(2)] = inst_34381);

(statearr_34447_34532[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (25))){
var inst_34202 = (state_34399[(13)]);
var inst_34206 = (state_34399[(16)]);
var inst_34267 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34268 = (function (){var segment_type = inst_34202;
var pred__34203 = inst_34206;
var expr__34204 = inst_34202;
var bindings = inst_34267;
return (function (p1__34186_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__34186_SHARP_);
});
})();
var inst_34269 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34268,inst_34267);
var inst_34270 = cljs.core.PersistentHashMap.EMPTY;
var inst_34271 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34270,inst_34269);
var inst_34272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34273 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_34271);
var inst_34274 = [inst_34273,r];
var inst_34275 = (new cljs.core.PersistentVector(null,2,(5),inst_34272,inst_34274,null));
var state_34399__$1 = state_34399;
var statearr_34448_34533 = state_34399__$1;
(statearr_34448_34533[(2)] = inst_34275);

(statearr_34448_34533[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (34))){
var inst_34314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34315 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_34399__$1 = (function (){var statearr_34449 = state_34399;
(statearr_34449[(21)] = inst_34314);

return statearr_34449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(37),inst_34315);
} else {
if((state_val_34400 === (17))){
var inst_34263 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34450_34534 = state_34399__$1;
(statearr_34450_34534[(2)] = inst_34263);

(statearr_34450_34534[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (3))){
var inst_34397 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34399__$1,inst_34397);
} else {
if((state_val_34400 === (12))){
var inst_34209 = (state_34399[(22)]);
var inst_34213 = (state_34399[(2)]);
var inst_34214 = fluree.db.util.async.throw_err(inst_34213);
var inst_34215 = [inst_34214,r];
var inst_34216 = (new cljs.core.PersistentVector(null,2,(5),inst_34209,inst_34215,null));
var state_34399__$1 = state_34399;
var statearr_34451_34535 = state_34399__$1;
(statearr_34451_34535[(2)] = inst_34216);

(statearr_34451_34535[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (2))){
var _ = (function (){var statearr_34452 = state_34399;
(statearr_34452[(4)] = cljs.core.cons((5),(state_34399[(4)])));

return statearr_34452;
})();
var inst_34199 = cljs.core.map_QMARK_(clause);
var state_34399__$1 = state_34399;
if(inst_34199){
var statearr_34453_34536 = state_34399__$1;
(statearr_34453_34536[(1)] = (6));

} else {
var statearr_34454_34537 = state_34399__$1;
(statearr_34454_34537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (23))){
var inst_34248 = (state_34399[(19)]);
var inst_34239 = (state_34399[(17)]);
var inst_34231 = inst_34239;
var inst_34232 = inst_34248;
var state_34399__$1 = (function (){var statearr_34455 = state_34399;
(statearr_34455[(14)] = inst_34232);

(statearr_34455[(18)] = inst_34231);

return statearr_34455;
})();
var statearr_34456_34538 = state_34399__$1;
(statearr_34456_34538[(2)] = null);

(statearr_34456_34538[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (47))){
var inst_34384 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34457_34539 = state_34399__$1;
(statearr_34457_34539[(2)] = inst_34384);

(statearr_34457_34539[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (35))){
var inst_34322 = cljs.core.count(clause);
var inst_34323 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_34322);
var state_34399__$1 = state_34399;
if(inst_34323){
var statearr_34458_34540 = state_34399__$1;
(statearr_34458_34540[(1)] = (38));

} else {
var statearr_34459_34541 = state_34399__$1;
(statearr_34459_34541[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (19))){
var inst_34232 = (state_34399[(14)]);
var inst_34257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34258 = [inst_34232,r];
var inst_34259 = (new cljs.core.PersistentVector(null,2,(5),inst_34257,inst_34258,null));
var state_34399__$1 = state_34399;
var statearr_34460_34542 = state_34399__$1;
(statearr_34460_34542[(2)] = inst_34259);

(statearr_34460_34542[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (57))){
var state_34399__$1 = state_34399;
var statearr_34461_34543 = state_34399__$1;
(statearr_34461_34543[(2)] = null);

(statearr_34461_34543[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (11))){
var inst_34295 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34463_34544 = state_34399__$1;
(statearr_34463_34544[(2)] = inst_34295);

(statearr_34463_34544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (9))){
var inst_34209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34210 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_34211 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_34210,res,fuel,max_fuel,opts);
var state_34399__$1 = (function (){var statearr_34464 = state_34399;
(statearr_34464[(22)] = inst_34209);

return statearr_34464;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(12),inst_34211);
} else {
if((state_val_34400 === (5))){
var _ = (function (){var statearr_34465 = state_34399;
(statearr_34465[(4)] = cljs.core.rest((state_34399[(4)])));

return statearr_34465;
})();
var state_34399__$1 = state_34399;
var ex34462 = (state_34399__$1[(2)]);
var statearr_34466_34545 = state_34399__$1;
(statearr_34466_34545[(5)] = ex34462);


if((ex34462 instanceof Error)){
var statearr_34467_34546 = state_34399__$1;
(statearr_34467_34546[(1)] = (4));

(statearr_34467_34546[(5)] = null);

} else {
throw ex34462;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (14))){
var inst_34202 = (state_34399[(13)]);
var inst_34206 = (state_34399[(16)]);
var inst_34265 = (function (){var G__34468 = cljs.core.cst$kw$bind;
var G__34469 = inst_34202;
return (inst_34206.cljs$core$IFn$_invoke$arity$2 ? inst_34206.cljs$core$IFn$_invoke$arity$2(G__34468,G__34469) : inst_34206.call(null,G__34468,G__34469));
})();
var state_34399__$1 = state_34399;
if(cljs.core.truth_(inst_34265)){
var statearr_34470_34547 = state_34399__$1;
(statearr_34470_34547[(1)] = (25));

} else {
var statearr_34471_34548 = state_34399__$1;
(statearr_34471_34548[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (45))){
var inst_34346 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_34399__$1 = state_34399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(48),inst_34346);
} else {
if((state_val_34400 === (53))){
var inst_34351 = (state_34399[(9)]);
var inst_34350 = (state_34399[(8)]);
var inst_34362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34363 = fluree.db.query.analytical.full_text__GT_tuples(inst_34350,res,inst_34351);
var inst_34364 = [inst_34363,r];
var inst_34365 = (new cljs.core.PersistentVector(null,2,(5),inst_34362,inst_34364,null));
var state_34399__$1 = state_34399;
var statearr_34472_34549 = state_34399__$1;
(statearr_34472_34549[(2)] = inst_34365);

(statearr_34472_34549[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (26))){
var inst_34202 = (state_34399[(13)]);
var inst_34206 = (state_34399[(16)]);
var inst_34277 = (function (){var G__34473 = cljs.core.cst$kw$filter;
var G__34474 = inst_34202;
return (inst_34206.cljs$core$IFn$_invoke$arity$2 ? inst_34206.cljs$core$IFn$_invoke$arity$2(G__34473,G__34474) : inst_34206.call(null,G__34473,G__34474));
})();
var state_34399__$1 = state_34399;
if(cljs.core.truth_(inst_34277)){
var statearr_34475_34550 = state_34399__$1;
(statearr_34475_34550[(1)] = (28));

} else {
var statearr_34476_34551 = state_34399__$1;
(statearr_34476_34551[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (16))){
var inst_34238 = (state_34399[(12)]);
var inst_34231 = (state_34399[(18)]);
var inst_34237 = cljs.core.seq(inst_34231);
var inst_34238__$1 = cljs.core.first(inst_34237);
var inst_34239 = cljs.core.next(inst_34237);
var state_34399__$1 = (function (){var statearr_34477 = state_34399;
(statearr_34477[(12)] = inst_34238__$1);

(statearr_34477[(17)] = inst_34239);

return statearr_34477;
})();
if(cljs.core.truth_(inst_34238__$1)){
var statearr_34478_34552 = state_34399__$1;
(statearr_34478_34552[(1)] = (18));

} else {
var statearr_34479_34553 = state_34399__$1;
(statearr_34479_34553[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (38))){
var inst_34325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34326 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_34399__$1 = (function (){var statearr_34480 = state_34399;
(statearr_34480[(20)] = inst_34325);

return statearr_34480;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(41),inst_34326);
} else {
if((state_val_34400 === (30))){
var inst_34289 = (state_34399[(2)]);
var state_34399__$1 = state_34399;
var statearr_34481_34554 = state_34399__$1;
(statearr_34481_34554[(2)] = inst_34289);

(statearr_34481_34554[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (10))){
var inst_34202 = (state_34399[(13)]);
var inst_34206 = (state_34399[(16)]);
var inst_34218 = (function (){var G__34482 = cljs.core.cst$kw$union;
var G__34483 = inst_34202;
return (inst_34206.cljs$core$IFn$_invoke$arity$2 ? inst_34206.cljs$core$IFn$_invoke$arity$2(G__34482,G__34483) : inst_34206.call(null,G__34482,G__34483));
})();
var state_34399__$1 = state_34399;
if(cljs.core.truth_(inst_34218)){
var statearr_34484_34555 = state_34399__$1;
(statearr_34484_34555[(1)] = (13));

} else {
var statearr_34485_34556 = state_34399__$1;
(statearr_34485_34556[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (18))){
var inst_34238 = (state_34399[(12)]);
var inst_34241 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_34238,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_34238,q_map,vars,fuel,max_fuel,opts));
var state_34399__$1 = state_34399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(21),inst_34241);
} else {
if((state_val_34400 === (52))){
var inst_34356 = (state_34399[(2)]);
var inst_34357 = fluree.db.util.async.throw_err(inst_34356);
var state_34399__$1 = state_34399;
var statearr_34486_34557 = state_34399__$1;
(statearr_34486_34557[(2)] = inst_34357);

(statearr_34486_34557[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (42))){
var inst_34336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34337 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_34338 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_34337);
var inst_34339 = [inst_34338,r];
var inst_34340 = (new cljs.core.PersistentVector(null,2,(5),inst_34336,inst_34339,null));
var state_34399__$1 = state_34399;
var statearr_34487_34558 = state_34399__$1;
(statearr_34487_34558[(2)] = inst_34340);

(statearr_34487_34558[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (37))){
var inst_34314 = (state_34399[(21)]);
var inst_34317 = (state_34399[(2)]);
var inst_34318 = fluree.db.util.async.throw_err(inst_34317);
var inst_34319 = [inst_34318,r];
var inst_34320 = (new cljs.core.PersistentVector(null,2,(5),inst_34314,inst_34319,null));
var state_34399__$1 = state_34399;
var statearr_34488_34559 = state_34399__$1;
(statearr_34488_34559[(2)] = inst_34320);

(statearr_34488_34559[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (8))){
var inst_34394 = (state_34399[(2)]);
var _ = (function (){var statearr_34489 = state_34399;
(statearr_34489[(4)] = cljs.core.rest((state_34399[(4)])));

return statearr_34489;
})();
var state_34399__$1 = state_34399;
var statearr_34490_34560 = state_34399__$1;
(statearr_34490_34560[(2)] = inst_34394);

(statearr_34490_34560[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34400 === (49))){
var inst_34351 = (state_34399[(9)]);
var inst_34354 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_34351,r,res,optional_QMARK_,fuel,max_fuel);
var state_34399__$1 = state_34399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34399__$1,(52),inst_34354);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34491[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_34491[(1)] = (1));

return statearr_34491;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34399){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34399);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34492){var ex__16304__auto__ = e34492;
var statearr_34493_34561 = state_34399;
(statearr_34493_34561[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34399[(4)]))){
var statearr_34494_34562 = state_34399;
(statearr_34494_34562[(1)] = cljs.core.first((state_34399[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34563 = state_34399;
state_34399 = G__34563;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = function(state_34399){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34495 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34495[(6)] = c__16375__auto__);

return statearr_34495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__34565 = arguments.length;
switch (G__34565) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34645){
var state_val_34646 = (state_34645[(1)]);
if((state_val_34646 === (7))){
var inst_34640 = (state_34645[(2)]);
var _ = (function (){var statearr_34647 = state_34645;
(statearr_34647[(4)] = cljs.core.rest((state_34645[(4)])));

return statearr_34647;
})();
var state_34645__$1 = state_34645;
var statearr_34648_34696 = state_34645__$1;
(statearr_34648_34696[(2)] = inst_34640);

(statearr_34648_34696[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (20))){
var inst_34605 = (state_34645[(7)]);
var inst_34617 = (state_34645[(2)]);
var inst_34587 = inst_34605;
var inst_34588 = inst_34617;
var state_34645__$1 = (function (){var statearr_34649 = state_34645;
(statearr_34649[(8)] = inst_34588);

(statearr_34649[(9)] = inst_34587);

return statearr_34649;
})();
var statearr_34650_34697 = state_34645__$1;
(statearr_34650_34697[(2)] = null);

(statearr_34650_34697[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (1))){
var state_34645__$1 = state_34645;
var statearr_34651_34698 = state_34645__$1;
(statearr_34651_34698[(2)] = null);

(statearr_34651_34698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (24))){
var inst_34588 = (state_34645[(8)]);
var inst_34605 = (state_34645[(7)]);
var inst_34604 = (state_34645[(10)]);
var inst_34625 = fluree.db.query.analytical.inner_join(inst_34588,inst_34604);
var inst_34587 = inst_34605;
var inst_34588__$1 = inst_34625;
var state_34645__$1 = (function (){var statearr_34652 = state_34645;
(statearr_34652[(8)] = inst_34588__$1);

(statearr_34652[(9)] = inst_34587);

return statearr_34652;
})();
var statearr_34653_34699 = state_34645__$1;
(statearr_34653_34699[(2)] = null);

(statearr_34653_34699[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (4))){
var inst_34566 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34655_34700 = state_34645__$1;
(statearr_34655_34700[(2)] = inst_34566);

(statearr_34655_34700[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (15))){
var inst_34604 = (state_34645[(10)]);
var state_34645__$1 = state_34645;
if(cljs.core.truth_(inst_34604)){
var statearr_34656_34701 = state_34645__$1;
(statearr_34656_34701[(1)] = (18));

} else {
var statearr_34657_34702 = state_34645__$1;
(statearr_34657_34702[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (21))){
var inst_34588 = (state_34645[(8)]);
var inst_34605 = (state_34645[(7)]);
var tmp34654 = inst_34588;
var inst_34587 = inst_34605;
var inst_34588__$1 = tmp34654;
var state_34645__$1 = (function (){var statearr_34658 = state_34645;
(statearr_34658[(8)] = inst_34588__$1);

(statearr_34658[(9)] = inst_34587);

return statearr_34658;
})();
var statearr_34659_34703 = state_34645__$1;
(statearr_34659_34703[(2)] = null);

(statearr_34659_34703[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (13))){
var inst_34588 = (state_34645[(8)]);
var inst_34611 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_34588,cljs.core.cst$kw$vars);
var inst_34612 = cljs.core.empty_QMARK_(inst_34611);
var state_34645__$1 = state_34645;
if(inst_34612){
var statearr_34660_34704 = state_34645__$1;
(statearr_34660_34704[(1)] = (15));

} else {
var statearr_34661_34705 = state_34645__$1;
(statearr_34661_34705[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (22))){
var state_34645__$1 = state_34645;
var statearr_34662_34706 = state_34645__$1;
(statearr_34662_34706[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (6))){
var inst_34594 = (state_34645[(11)]);
var inst_34587 = (state_34645[(9)]);
var inst_34593 = cljs.core.seq(inst_34587);
var inst_34594__$1 = cljs.core.first(inst_34593);
var inst_34595 = cljs.core.next(inst_34593);
var state_34645__$1 = (function (){var statearr_34664 = state_34645;
(statearr_34664[(12)] = inst_34595);

(statearr_34664[(11)] = inst_34594__$1);

return statearr_34664;
})();
if(cljs.core.truth_(inst_34594__$1)){
var statearr_34665_34707 = state_34645__$1;
(statearr_34665_34707[(1)] = (8));

} else {
var statearr_34666_34708 = state_34645__$1;
(statearr_34666_34708[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (25))){
var state_34645__$1 = state_34645;
var statearr_34667_34709 = state_34645__$1;
(statearr_34667_34709[(2)] = null);

(statearr_34667_34709[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (17))){
var inst_34633 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34668_34710 = state_34645__$1;
(statearr_34668_34710[(2)] = inst_34633);

(statearr_34668_34710[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (3))){
var inst_34643 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34645__$1,inst_34643);
} else {
if((state_val_34646 === (12))){
var inst_34605 = (state_34645[(7)]);
var inst_34604 = (state_34645[(10)]);
var inst_34587 = inst_34605;
var inst_34588 = inst_34604;
var state_34645__$1 = (function (){var statearr_34669 = state_34645;
(statearr_34669[(8)] = inst_34588);

(statearr_34669[(9)] = inst_34587);

return statearr_34669;
})();
var statearr_34670_34711 = state_34645__$1;
(statearr_34670_34711[(2)] = null);

(statearr_34670_34711[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (2))){
var _ = (function (){var statearr_34671 = state_34645;
(statearr_34671[(4)] = cljs.core.cons((5),(state_34645[(4)])));

return statearr_34671;
})();
var inst_34579 = where;
var inst_34580 = cljs.core.seq(inst_34579);
var inst_34581 = cljs.core.first(inst_34580);
var inst_34582 = cljs.core.next(inst_34580);
var inst_34583 = [cljs.core.cst$kw$vars];
var inst_34584 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_34585 = [inst_34584];
var inst_34586 = cljs.core.PersistentHashMap.fromArrays(inst_34583,inst_34585);
var inst_34587 = inst_34579;
var inst_34588 = inst_34586;
var state_34645__$1 = (function (){var statearr_34672 = state_34645;
(statearr_34672[(8)] = inst_34588);

(statearr_34672[(13)] = inst_34581);

(statearr_34672[(14)] = inst_34582);

(statearr_34672[(9)] = inst_34587);

return statearr_34672;
})();
var statearr_34673_34712 = state_34645__$1;
(statearr_34673_34712[(2)] = null);

(statearr_34673_34712[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (23))){
var inst_34631 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34674_34713 = state_34645__$1;
(statearr_34674_34713[(2)] = inst_34631);

(statearr_34674_34713[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (19))){
var inst_34588 = (state_34645[(8)]);
var state_34645__$1 = state_34645;
var statearr_34675_34714 = state_34645__$1;
(statearr_34675_34714[(2)] = inst_34588);

(statearr_34675_34714[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (11))){
var inst_34594 = (state_34645[(11)]);
var inst_34602 = (state_34645[(2)]);
var inst_34603 = fluree.db.util.async.throw_err(inst_34602);
var inst_34604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34603,(0),null);
var inst_34605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34603,(1),null);
var inst_34606 = cljs.core.count(inst_34594);
var inst_34607 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_34606);
var state_34645__$1 = (function (){var statearr_34677 = state_34645;
(statearr_34677[(7)] = inst_34605);

(statearr_34677[(10)] = inst_34604);

return statearr_34677;
})();
if(inst_34607){
var statearr_34678_34715 = state_34645__$1;
(statearr_34678_34715[(1)] = (12));

} else {
var statearr_34679_34716 = state_34645__$1;
(statearr_34679_34716[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (9))){
var inst_34588 = (state_34645[(8)]);
var state_34645__$1 = state_34645;
var statearr_34680_34717 = state_34645__$1;
(statearr_34680_34717[(2)] = inst_34588);

(statearr_34680_34717[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (5))){
var _ = (function (){var statearr_34681 = state_34645;
(statearr_34681[(4)] = cljs.core.rest((state_34645[(4)])));

return statearr_34681;
})();
var state_34645__$1 = state_34645;
var ex34676 = (state_34645__$1[(2)]);
var statearr_34682_34718 = state_34645__$1;
(statearr_34682_34718[(5)] = ex34676);


if((ex34676 instanceof Error)){
var statearr_34683_34719 = state_34645__$1;
(statearr_34683_34719[(1)] = (4));

(statearr_34683_34719[(5)] = null);

} else {
throw ex34676;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (14))){
var inst_34635 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34684_34720 = state_34645__$1;
(statearr_34684_34720[(2)] = inst_34635);

(statearr_34684_34720[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (26))){
var inst_34629 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34685_34721 = state_34645__$1;
(statearr_34685_34721[(2)] = inst_34629);

(statearr_34685_34721[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (16))){
var inst_34604 = (state_34645[(10)]);
var inst_34620 = (inst_34604 == null);
var state_34645__$1 = state_34645;
if(cljs.core.truth_(inst_34620)){
var statearr_34686_34722 = state_34645__$1;
(statearr_34686_34722[(1)] = (21));

} else {
var statearr_34687_34723 = state_34645__$1;
(statearr_34687_34723[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (10))){
var inst_34638 = (state_34645[(2)]);
var state_34645__$1 = state_34645;
var statearr_34688_34724 = state_34645__$1;
(statearr_34688_34724[(2)] = inst_34638);

(statearr_34688_34724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (18))){
var inst_34604 = (state_34645[(10)]);
var state_34645__$1 = state_34645;
var statearr_34689_34725 = state_34645__$1;
(statearr_34689_34725[(2)] = inst_34604);

(statearr_34689_34725[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34646 === (8))){
var inst_34588 = (state_34645[(8)]);
var inst_34595 = (state_34645[(12)]);
var inst_34594 = (state_34645[(11)]);
var inst_34600 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_34588,inst_34594,inst_34595,false,fuel,max_fuel,opts);
var state_34645__$1 = state_34645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34645__$1,(11),inst_34600);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_34690 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34690[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_34690[(1)] = (1));

return statearr_34690;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_34645){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34645);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34691){var ex__16304__auto__ = e34691;
var statearr_34692_34726 = state_34645;
(statearr_34692_34726[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34645[(4)]))){
var statearr_34693_34727 = state_34645;
(statearr_34693_34727[(1)] = cljs.core.first((state_34645[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34728 = state_34645;
state_34645 = G__34728;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_34645){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_34645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34694 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34694[(6)] = c__16375__auto__);

return statearr_34694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34783){
var state_val_34784 = (state_34783[(1)]);
if((state_val_34784 === (7))){
var state_34783__$1 = state_34783;
var statearr_34785_34823 = state_34783__$1;
(statearr_34785_34823[(2)] = false);

(statearr_34785_34823[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (20))){
var inst_34773 = (state_34783[(7)]);
var inst_34761 = (state_34783[(8)]);
var inst_34775 = fluree.db.query.analytical.tuples__GT_filtered(inst_34773,inst_34761,null);
var state_34783__$1 = state_34783;
var statearr_34786_34824 = state_34783__$1;
(statearr_34786_34824[(2)] = inst_34775);

(statearr_34786_34824[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (1))){
var state_34783__$1 = state_34783;
var statearr_34787_34825 = state_34783__$1;
(statearr_34787_34825[(2)] = null);

(statearr_34787_34825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (4))){
var inst_34729 = (state_34783[(2)]);
var state_34783__$1 = state_34783;
var statearr_34788_34826 = state_34783__$1;
(statearr_34788_34826[(2)] = inst_34729);

(statearr_34788_34826[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (15))){
var inst_34760 = (state_34783[(9)]);
var inst_34764 = (state_34783[(2)]);
var inst_34765 = fluree.db.util.async.throw_err(inst_34764);
var state_34783__$1 = (function (){var statearr_34789 = state_34783;
(statearr_34789[(10)] = inst_34765);

return statearr_34789;
})();
if(cljs.core.truth_(inst_34760)){
var statearr_34790_34827 = state_34783__$1;
(statearr_34790_34827[(1)] = (16));

} else {
var statearr_34791_34828 = state_34783__$1;
(statearr_34791_34828[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (21))){
var inst_34773 = (state_34783[(7)]);
var state_34783__$1 = state_34783;
var statearr_34792_34829 = state_34783__$1;
(statearr_34792_34829[(2)] = inst_34773);

(statearr_34792_34829[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (13))){
var inst_34736 = (state_34783[(11)]);
var state_34783__$1 = state_34783;
var statearr_34793_34830 = state_34783__$1;
(statearr_34793_34830[(2)] = inst_34736);

(statearr_34793_34830[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (22))){
var inst_34778 = (state_34783[(2)]);
var _ = (function (){var statearr_34794 = state_34783;
(statearr_34794[(4)] = cljs.core.rest((state_34783[(4)])));

return statearr_34794;
})();
var state_34783__$1 = state_34783;
var statearr_34795_34831 = state_34783__$1;
(statearr_34795_34831[(2)] = inst_34778);

(statearr_34795_34831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (6))){
var inst_34736 = (state_34783[(11)]);
var inst_34741 = inst_34736.cljs$lang$protocol_mask$partition0$;
var inst_34742 = (inst_34741 & (64));
var inst_34743 = inst_34736.cljs$core$ISeq$;
var inst_34744 = (cljs.core.PROTOCOL_SENTINEL === inst_34743);
var inst_34745 = ((inst_34742) || (inst_34744));
var state_34783__$1 = state_34783;
if(cljs.core.truth_(inst_34745)){
var statearr_34796_34832 = state_34783__$1;
(statearr_34796_34832[(1)] = (9));

} else {
var statearr_34797_34833 = state_34783__$1;
(statearr_34797_34833[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (17))){
var inst_34765 = (state_34783[(10)]);
var state_34783__$1 = state_34783;
var statearr_34798_34834 = state_34783__$1;
(statearr_34798_34834[(2)] = inst_34765);

(statearr_34798_34834[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (3))){
var inst_34781 = (state_34783[(2)]);
var state_34783__$1 = state_34783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34783__$1,inst_34781);
} else {
if((state_val_34784 === (12))){
var inst_34736 = (state_34783[(11)]);
var inst_34754 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34736);
var state_34783__$1 = state_34783;
var statearr_34799_34835 = state_34783__$1;
(statearr_34799_34835[(2)] = inst_34754);

(statearr_34799_34835[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (2))){
var inst_34736 = (state_34783[(11)]);
var _ = (function (){var statearr_34800 = state_34783;
(statearr_34800[(4)] = cljs.core.cons((5),(state_34783[(4)])));

return statearr_34800;
})();
var inst_34736__$1 = q_map;
var inst_34738 = (inst_34736__$1 == null);
var inst_34739 = cljs.core.not(inst_34738);
var state_34783__$1 = (function (){var statearr_34801 = state_34783;
(statearr_34801[(11)] = inst_34736__$1);

return statearr_34801;
})();
if(inst_34739){
var statearr_34802_34836 = state_34783__$1;
(statearr_34802_34836[(1)] = (6));

} else {
var statearr_34803_34837 = state_34783__$1;
(statearr_34803_34837[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (19))){
var inst_34769 = (state_34783[(2)]);
var inst_34770 = fluree.db.util.async.throw_err(inst_34769);
var state_34783__$1 = state_34783;
var statearr_34804_34838 = state_34783__$1;
(statearr_34804_34838[(2)] = inst_34770);

(statearr_34804_34838[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (11))){
var inst_34749 = (state_34783[(2)]);
var state_34783__$1 = state_34783;
var statearr_34806_34839 = state_34783__$1;
(statearr_34806_34839[(2)] = inst_34749);

(statearr_34806_34839[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (9))){
var state_34783__$1 = state_34783;
var statearr_34807_34840 = state_34783__$1;
(statearr_34807_34840[(2)] = true);

(statearr_34807_34840[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (5))){
var _ = (function (){var statearr_34808 = state_34783;
(statearr_34808[(4)] = cljs.core.rest((state_34783[(4)])));

return statearr_34808;
})();
var state_34783__$1 = state_34783;
var ex34805 = (state_34783__$1[(2)]);
var statearr_34809_34841 = state_34783__$1;
(statearr_34809_34841[(5)] = ex34805);


if((ex34805 instanceof Error)){
var statearr_34810_34842 = state_34783__$1;
(statearr_34810_34842[(1)] = (4));

(statearr_34810_34842[(5)] = null);

} else {
throw ex34805;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (14))){
var inst_34757 = (state_34783[(2)]);
var inst_34758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34757,cljs.core.cst$kw$vars);
var inst_34759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34757,cljs.core.cst$kw$where);
var inst_34760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34757,cljs.core.cst$kw$optional);
var inst_34761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34757,cljs.core.cst$kw$filter);
var inst_34762 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_34759,q_map,inst_34758,fuel,max_fuel,opts);
var state_34783__$1 = (function (){var statearr_34811 = state_34783;
(statearr_34811[(9)] = inst_34760);

(statearr_34811[(8)] = inst_34761);

return statearr_34811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34783__$1,(15),inst_34762);
} else {
if((state_val_34784 === (16))){
var inst_34760 = (state_34783[(9)]);
var inst_34765 = (state_34783[(10)]);
var inst_34767 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_34760,inst_34765,fuel,max_fuel,opts);
var state_34783__$1 = state_34783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34783__$1,(19),inst_34767);
} else {
if((state_val_34784 === (10))){
var state_34783__$1 = state_34783;
var statearr_34812_34843 = state_34783__$1;
(statearr_34812_34843[(2)] = false);

(statearr_34812_34843[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (18))){
var inst_34761 = (state_34783[(8)]);
var inst_34773 = (state_34783[(2)]);
var state_34783__$1 = (function (){var statearr_34813 = state_34783;
(statearr_34813[(7)] = inst_34773);

return statearr_34813;
})();
if(cljs.core.truth_(inst_34761)){
var statearr_34814_34844 = state_34783__$1;
(statearr_34814_34844[(1)] = (20));

} else {
var statearr_34815_34845 = state_34783__$1;
(statearr_34815_34845[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34784 === (8))){
var inst_34752 = (state_34783[(2)]);
var state_34783__$1 = state_34783;
if(cljs.core.truth_(inst_34752)){
var statearr_34816_34846 = state_34783__$1;
(statearr_34816_34846[(1)] = (12));

} else {
var statearr_34817_34847 = state_34783__$1;
(statearr_34817_34847[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16301__auto____0 = (function (){
var statearr_34818 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34818[(0)] = fluree$db$query$analytical$q_$_state_machine__16301__auto__);

(statearr_34818[(1)] = (1));

return statearr_34818;
});
var fluree$db$query$analytical$q_$_state_machine__16301__auto____1 = (function (state_34783){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34783);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34819){var ex__16304__auto__ = e34819;
var statearr_34820_34848 = state_34783;
(statearr_34820_34848[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34783[(4)]))){
var statearr_34821_34849 = state_34783;
(statearr_34821_34849[(1)] = cljs.core.first((state_34783[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34850 = state_34783;
state_34783 = G__34850;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16301__auto__ = function(state_34783){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____1.call(this,state_34783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16301__auto____0;
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34822 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34822[(6)] = c__16375__auto__);

return statearr_34822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
