// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__10202){
var vec__10203 = p__10202;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10203,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10203,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__10206 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10206,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10206,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10206,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10206,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10206,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5735__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__10209 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10209,(4),null);
var vec__10212 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10212,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10212,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10212,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10212,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10212,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__10215 = segmap;
var map__10215__$1 = (((((!((map__10215 == null))))?(((((map__10215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10215.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10215):map__10215);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__10218 = arguments.length;
switch (G__10218) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10222 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10226 = cljs.core.next(segs__$1);
var G__10227 = nrelseg;
var G__10228 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10226;
relseg__$1 = G__10227;
result__$1 = G__10228;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10222,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10222,(1),null);
var G__10229 = (gline + (1));
var G__10230 = cljs.core.next(lines__$1);
var G__10231 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10232 = result__$1;
gline = G__10229;
lines__$1 = G__10230;
relseg = G__10231;
result = G__10232;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__10234 = segmap;
var map__10234__$1 = (((((!((map__10234 == null))))?(((((map__10234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10234.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10234):map__10234);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10234__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10234__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10234__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10234__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10234__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__10233_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__10233_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__10237 = arguments.length;
switch (G__10237) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10241 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10245 = cljs.core.next(segs__$1);
var G__10246 = nrelseg;
var G__10247 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10245;
relseg__$1 = G__10246;
result__$1 = G__10247;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10241,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10241,(1),null);
var G__10248 = (gline + (1));
var G__10249 = cljs.core.next(lines__$1);
var G__10250 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10251 = result__$1;
gline = G__10248;
lines__$1 = G__10249;
relseg = G__10250;
result = G__10251;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10252){
var vec__10253 = p__10252;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10253,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__10256){
var vec__10257 = p__10256;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10257,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10257,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10257,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10257,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10257,(4),null);
var seg = vec__10257;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10260){
var vec__10261 = p__10260;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10261,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10261,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10261,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10261,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10261,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__10267 = cljs.core.seq(infos);
var chunk__10268 = null;
var count__10269 = (0);
var i__10270 = (0);
while(true){
if((i__10270 < count__10269)){
var info = chunk__10268.cljs$core$IIndexed$_nth$arity$2(null,i__10270);
var segv_10621 = info__GT_segv(info,source_idx,line,col);
var gline_10622 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10623 = cljs.core.count(cljs.core.deref(lines));
if((gline_10622 > (lc_10623 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10267,chunk__10268,count__10269,i__10270,segv_10621,gline_10622,lc_10623,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10622 - (lc_10623 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10621], null));
});})(seq__10267,chunk__10268,count__10269,i__10270,segv_10621,gline_10622,lc_10623,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10267,chunk__10268,count__10269,i__10270,segv_10621,gline_10622,lc_10623,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10622], null),cljs.core.conj,segv_10621);
});})(seq__10267,chunk__10268,count__10269,i__10270,segv_10621,gline_10622,lc_10623,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10624 = seq__10267;
var G__10625 = chunk__10268;
var G__10626 = count__10269;
var G__10627 = (i__10270 + (1));
seq__10267 = G__10624;
chunk__10268 = G__10625;
count__10269 = G__10626;
i__10270 = G__10627;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__10267);
if(temp__5735__auto__){
var seq__10267__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10267__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__10267__$1);
var G__10628 = cljs.core.chunk_rest(seq__10267__$1);
var G__10629 = c__4556__auto__;
var G__10630 = cljs.core.count(c__4556__auto__);
var G__10631 = (0);
seq__10267 = G__10628;
chunk__10268 = G__10629;
count__10269 = G__10630;
i__10270 = G__10631;
continue;
} else {
var info = cljs.core.first(seq__10267__$1);
var segv_10632 = info__GT_segv(info,source_idx,line,col);
var gline_10633 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10634 = cljs.core.count(cljs.core.deref(lines));
if((gline_10633 > (lc_10634 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10267,chunk__10268,count__10269,i__10270,segv_10632,gline_10633,lc_10634,info,seq__10267__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10633 - (lc_10634 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10632], null));
});})(seq__10267,chunk__10268,count__10269,i__10270,segv_10632,gline_10633,lc_10634,info,seq__10267__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10267,chunk__10268,count__10269,i__10270,segv_10632,gline_10633,lc_10634,info,seq__10267__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10633], null),cljs.core.conj,segv_10632);
});})(seq__10267,chunk__10268,count__10269,i__10270,segv_10632,gline_10633,lc_10634,info,seq__10267__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10635 = cljs.core.next(seq__10267__$1);
var G__10636 = null;
var G__10637 = (0);
var G__10638 = (0);
seq__10267 = G__10635;
chunk__10268 = G__10636;
count__10269 = G__10637;
i__10270 = G__10638;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__10271_10639 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__10272_10640 = null;
var count__10273_10641 = (0);
var i__10274_10642 = (0);
while(true){
if((i__10274_10642 < count__10273_10641)){
var vec__10447_10643 = chunk__10272_10640.cljs$core$IIndexed$_nth$arity$2(null,i__10274_10642);
var source_idx_10644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10447_10643,(0),null);
var vec__10450_10645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10447_10643,(1),null);
var __10646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10450_10645,(0),null);
var lines_10647__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10450_10645,(1),null);
var seq__10453_10648 = cljs.core.seq(lines_10647__$1);
var chunk__10454_10649 = null;
var count__10455_10650 = (0);
var i__10456_10651 = (0);
while(true){
if((i__10456_10651 < count__10455_10650)){
var vec__10495_10652 = chunk__10454_10649.cljs$core$IIndexed$_nth$arity$2(null,i__10456_10651);
var line_10653 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10495_10652,(0),null);
var cols_10654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10495_10652,(1),null);
var seq__10498_10655 = cljs.core.seq(cols_10654);
var chunk__10499_10656 = null;
var count__10500_10657 = (0);
var i__10501_10658 = (0);
while(true){
if((i__10501_10658 < count__10500_10657)){
var vec__10508_10659 = chunk__10499_10656.cljs$core$IIndexed$_nth$arity$2(null,i__10501_10658);
var col_10660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10508_10659,(0),null);
var infos_10661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10508_10659,(1),null);
encode_cols(infos_10661,source_idx_10644,line_10653,col_10660);


var G__10662 = seq__10498_10655;
var G__10663 = chunk__10499_10656;
var G__10664 = count__10500_10657;
var G__10665 = (i__10501_10658 + (1));
seq__10498_10655 = G__10662;
chunk__10499_10656 = G__10663;
count__10500_10657 = G__10664;
i__10501_10658 = G__10665;
continue;
} else {
var temp__5735__auto___10666 = cljs.core.seq(seq__10498_10655);
if(temp__5735__auto___10666){
var seq__10498_10667__$1 = temp__5735__auto___10666;
if(cljs.core.chunked_seq_QMARK_(seq__10498_10667__$1)){
var c__4556__auto___10668 = cljs.core.chunk_first(seq__10498_10667__$1);
var G__10669 = cljs.core.chunk_rest(seq__10498_10667__$1);
var G__10670 = c__4556__auto___10668;
var G__10671 = cljs.core.count(c__4556__auto___10668);
var G__10672 = (0);
seq__10498_10655 = G__10669;
chunk__10499_10656 = G__10670;
count__10500_10657 = G__10671;
i__10501_10658 = G__10672;
continue;
} else {
var vec__10511_10673 = cljs.core.first(seq__10498_10667__$1);
var col_10674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10511_10673,(0),null);
var infos_10675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10511_10673,(1),null);
encode_cols(infos_10675,source_idx_10644,line_10653,col_10674);


var G__10676 = cljs.core.next(seq__10498_10667__$1);
var G__10677 = null;
var G__10678 = (0);
var G__10679 = (0);
seq__10498_10655 = G__10676;
chunk__10499_10656 = G__10677;
count__10500_10657 = G__10678;
i__10501_10658 = G__10679;
continue;
}
} else {
}
}
break;
}


var G__10680 = seq__10453_10648;
var G__10681 = chunk__10454_10649;
var G__10682 = count__10455_10650;
var G__10683 = (i__10456_10651 + (1));
seq__10453_10648 = G__10680;
chunk__10454_10649 = G__10681;
count__10455_10650 = G__10682;
i__10456_10651 = G__10683;
continue;
} else {
var temp__5735__auto___10684 = cljs.core.seq(seq__10453_10648);
if(temp__5735__auto___10684){
var seq__10453_10685__$1 = temp__5735__auto___10684;
if(cljs.core.chunked_seq_QMARK_(seq__10453_10685__$1)){
var c__4556__auto___10686 = cljs.core.chunk_first(seq__10453_10685__$1);
var G__10687 = cljs.core.chunk_rest(seq__10453_10685__$1);
var G__10688 = c__4556__auto___10686;
var G__10689 = cljs.core.count(c__4556__auto___10686);
var G__10690 = (0);
seq__10453_10648 = G__10687;
chunk__10454_10649 = G__10688;
count__10455_10650 = G__10689;
i__10456_10651 = G__10690;
continue;
} else {
var vec__10514_10691 = cljs.core.first(seq__10453_10685__$1);
var line_10692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10514_10691,(0),null);
var cols_10693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10514_10691,(1),null);
var seq__10517_10694 = cljs.core.seq(cols_10693);
var chunk__10518_10695 = null;
var count__10519_10696 = (0);
var i__10520_10697 = (0);
while(true){
if((i__10520_10697 < count__10519_10696)){
var vec__10527_10698 = chunk__10518_10695.cljs$core$IIndexed$_nth$arity$2(null,i__10520_10697);
var col_10699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10527_10698,(0),null);
var infos_10700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10527_10698,(1),null);
encode_cols(infos_10700,source_idx_10644,line_10692,col_10699);


var G__10701 = seq__10517_10694;
var G__10702 = chunk__10518_10695;
var G__10703 = count__10519_10696;
var G__10704 = (i__10520_10697 + (1));
seq__10517_10694 = G__10701;
chunk__10518_10695 = G__10702;
count__10519_10696 = G__10703;
i__10520_10697 = G__10704;
continue;
} else {
var temp__5735__auto___10705__$1 = cljs.core.seq(seq__10517_10694);
if(temp__5735__auto___10705__$1){
var seq__10517_10706__$1 = temp__5735__auto___10705__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10517_10706__$1)){
var c__4556__auto___10707 = cljs.core.chunk_first(seq__10517_10706__$1);
var G__10708 = cljs.core.chunk_rest(seq__10517_10706__$1);
var G__10709 = c__4556__auto___10707;
var G__10710 = cljs.core.count(c__4556__auto___10707);
var G__10711 = (0);
seq__10517_10694 = G__10708;
chunk__10518_10695 = G__10709;
count__10519_10696 = G__10710;
i__10520_10697 = G__10711;
continue;
} else {
var vec__10530_10712 = cljs.core.first(seq__10517_10706__$1);
var col_10713 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530_10712,(0),null);
var infos_10714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530_10712,(1),null);
encode_cols(infos_10714,source_idx_10644,line_10692,col_10713);


var G__10715 = cljs.core.next(seq__10517_10706__$1);
var G__10716 = null;
var G__10717 = (0);
var G__10718 = (0);
seq__10517_10694 = G__10715;
chunk__10518_10695 = G__10716;
count__10519_10696 = G__10717;
i__10520_10697 = G__10718;
continue;
}
} else {
}
}
break;
}


var G__10719 = cljs.core.next(seq__10453_10685__$1);
var G__10720 = null;
var G__10721 = (0);
var G__10722 = (0);
seq__10453_10648 = G__10719;
chunk__10454_10649 = G__10720;
count__10455_10650 = G__10721;
i__10456_10651 = G__10722;
continue;
}
} else {
}
}
break;
}


var G__10723 = seq__10271_10639;
var G__10724 = chunk__10272_10640;
var G__10725 = count__10273_10641;
var G__10726 = (i__10274_10642 + (1));
seq__10271_10639 = G__10723;
chunk__10272_10640 = G__10724;
count__10273_10641 = G__10725;
i__10274_10642 = G__10726;
continue;
} else {
var temp__5735__auto___10727 = cljs.core.seq(seq__10271_10639);
if(temp__5735__auto___10727){
var seq__10271_10728__$1 = temp__5735__auto___10727;
if(cljs.core.chunked_seq_QMARK_(seq__10271_10728__$1)){
var c__4556__auto___10729 = cljs.core.chunk_first(seq__10271_10728__$1);
var G__10730 = cljs.core.chunk_rest(seq__10271_10728__$1);
var G__10731 = c__4556__auto___10729;
var G__10732 = cljs.core.count(c__4556__auto___10729);
var G__10733 = (0);
seq__10271_10639 = G__10730;
chunk__10272_10640 = G__10731;
count__10273_10641 = G__10732;
i__10274_10642 = G__10733;
continue;
} else {
var vec__10533_10734 = cljs.core.first(seq__10271_10728__$1);
var source_idx_10735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10533_10734,(0),null);
var vec__10536_10736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10533_10734,(1),null);
var __10737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10536_10736,(0),null);
var lines_10738__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10536_10736,(1),null);
var seq__10539_10739 = cljs.core.seq(lines_10738__$1);
var chunk__10540_10740 = null;
var count__10541_10741 = (0);
var i__10542_10742 = (0);
while(true){
if((i__10542_10742 < count__10541_10741)){
var vec__10581_10743 = chunk__10540_10740.cljs$core$IIndexed$_nth$arity$2(null,i__10542_10742);
var line_10744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10581_10743,(0),null);
var cols_10745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10581_10743,(1),null);
var seq__10584_10746 = cljs.core.seq(cols_10745);
var chunk__10585_10747 = null;
var count__10586_10748 = (0);
var i__10587_10749 = (0);
while(true){
if((i__10587_10749 < count__10586_10748)){
var vec__10594_10750 = chunk__10585_10747.cljs$core$IIndexed$_nth$arity$2(null,i__10587_10749);
var col_10751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10594_10750,(0),null);
var infos_10752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10594_10750,(1),null);
encode_cols(infos_10752,source_idx_10735,line_10744,col_10751);


var G__10753 = seq__10584_10746;
var G__10754 = chunk__10585_10747;
var G__10755 = count__10586_10748;
var G__10756 = (i__10587_10749 + (1));
seq__10584_10746 = G__10753;
chunk__10585_10747 = G__10754;
count__10586_10748 = G__10755;
i__10587_10749 = G__10756;
continue;
} else {
var temp__5735__auto___10757__$1 = cljs.core.seq(seq__10584_10746);
if(temp__5735__auto___10757__$1){
var seq__10584_10758__$1 = temp__5735__auto___10757__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10584_10758__$1)){
var c__4556__auto___10759 = cljs.core.chunk_first(seq__10584_10758__$1);
var G__10760 = cljs.core.chunk_rest(seq__10584_10758__$1);
var G__10761 = c__4556__auto___10759;
var G__10762 = cljs.core.count(c__4556__auto___10759);
var G__10763 = (0);
seq__10584_10746 = G__10760;
chunk__10585_10747 = G__10761;
count__10586_10748 = G__10762;
i__10587_10749 = G__10763;
continue;
} else {
var vec__10597_10764 = cljs.core.first(seq__10584_10758__$1);
var col_10765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10597_10764,(0),null);
var infos_10766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10597_10764,(1),null);
encode_cols(infos_10766,source_idx_10735,line_10744,col_10765);


var G__10767 = cljs.core.next(seq__10584_10758__$1);
var G__10768 = null;
var G__10769 = (0);
var G__10770 = (0);
seq__10584_10746 = G__10767;
chunk__10585_10747 = G__10768;
count__10586_10748 = G__10769;
i__10587_10749 = G__10770;
continue;
}
} else {
}
}
break;
}


var G__10771 = seq__10539_10739;
var G__10772 = chunk__10540_10740;
var G__10773 = count__10541_10741;
var G__10774 = (i__10542_10742 + (1));
seq__10539_10739 = G__10771;
chunk__10540_10740 = G__10772;
count__10541_10741 = G__10773;
i__10542_10742 = G__10774;
continue;
} else {
var temp__5735__auto___10775__$1 = cljs.core.seq(seq__10539_10739);
if(temp__5735__auto___10775__$1){
var seq__10539_10776__$1 = temp__5735__auto___10775__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10539_10776__$1)){
var c__4556__auto___10777 = cljs.core.chunk_first(seq__10539_10776__$1);
var G__10778 = cljs.core.chunk_rest(seq__10539_10776__$1);
var G__10779 = c__4556__auto___10777;
var G__10780 = cljs.core.count(c__4556__auto___10777);
var G__10781 = (0);
seq__10539_10739 = G__10778;
chunk__10540_10740 = G__10779;
count__10541_10741 = G__10780;
i__10542_10742 = G__10781;
continue;
} else {
var vec__10600_10782 = cljs.core.first(seq__10539_10776__$1);
var line_10783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10600_10782,(0),null);
var cols_10784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10600_10782,(1),null);
var seq__10603_10785 = cljs.core.seq(cols_10784);
var chunk__10604_10786 = null;
var count__10605_10787 = (0);
var i__10606_10788 = (0);
while(true){
if((i__10606_10788 < count__10605_10787)){
var vec__10613_10789 = chunk__10604_10786.cljs$core$IIndexed$_nth$arity$2(null,i__10606_10788);
var col_10790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10613_10789,(0),null);
var infos_10791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10613_10789,(1),null);
encode_cols(infos_10791,source_idx_10735,line_10783,col_10790);


var G__10792 = seq__10603_10785;
var G__10793 = chunk__10604_10786;
var G__10794 = count__10605_10787;
var G__10795 = (i__10606_10788 + (1));
seq__10603_10785 = G__10792;
chunk__10604_10786 = G__10793;
count__10605_10787 = G__10794;
i__10606_10788 = G__10795;
continue;
} else {
var temp__5735__auto___10796__$2 = cljs.core.seq(seq__10603_10785);
if(temp__5735__auto___10796__$2){
var seq__10603_10797__$1 = temp__5735__auto___10796__$2;
if(cljs.core.chunked_seq_QMARK_(seq__10603_10797__$1)){
var c__4556__auto___10798 = cljs.core.chunk_first(seq__10603_10797__$1);
var G__10799 = cljs.core.chunk_rest(seq__10603_10797__$1);
var G__10800 = c__4556__auto___10798;
var G__10801 = cljs.core.count(c__4556__auto___10798);
var G__10802 = (0);
seq__10603_10785 = G__10799;
chunk__10604_10786 = G__10800;
count__10605_10787 = G__10801;
i__10606_10788 = G__10802;
continue;
} else {
var vec__10616_10803 = cljs.core.first(seq__10603_10797__$1);
var col_10804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10616_10803,(0),null);
var infos_10805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10616_10803,(1),null);
encode_cols(infos_10805,source_idx_10735,line_10783,col_10804);


var G__10806 = cljs.core.next(seq__10603_10797__$1);
var G__10807 = null;
var G__10808 = (0);
var G__10809 = (0);
seq__10603_10785 = G__10806;
chunk__10604_10786 = G__10807;
count__10605_10787 = G__10808;
i__10606_10788 = G__10809;
continue;
}
} else {
}
}
break;
}


var G__10810 = cljs.core.next(seq__10539_10776__$1);
var G__10811 = null;
var G__10812 = (0);
var G__10813 = (0);
seq__10539_10739 = G__10810;
chunk__10540_10740 = G__10811;
count__10541_10741 = G__10812;
i__10542_10742 = G__10813;
continue;
}
} else {
}
}
break;
}


var G__10814 = cljs.core.next(seq__10271_10728__$1);
var G__10815 = null;
var G__10816 = (0);
var G__10817 = (0);
seq__10271_10639 = G__10814;
chunk__10272_10640 = G__10815;
count__10273_10641 = G__10816;
i__10274_10642 = G__10817;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__10619 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__10264_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10264_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__10265_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__10265_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10266_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__10266_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__10620 = G__10619;
goog.object.set(G__10620,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__10620;
} else {
return G__10619;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__10818 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10818,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10818,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__10821 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10821,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10821,(1),null);
var G__10827 = cljs.core.next(col_map_seq);
var G__10828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__10821,col,infos,vec__10818,line,col_map){
return (function (v,p__10824){
var map__10825 = p__10824;
var map__10825__$1 = (((((!((map__10825 == null))))?(((((map__10825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10825.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10825):map__10825);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10825__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10825__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__10821,col,infos,vec__10818,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__10827;
new_cols = G__10828;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__10829 = cljs.core.next(line_map_seq);
var G__10830 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__10829;
new_lines = G__10830;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__10831_11103 = cljs.core.seq(reverse_map);
var chunk__10832_11104 = null;
var count__10833_11105 = (0);
var i__10834_11106 = (0);
while(true){
if((i__10834_11106 < count__10833_11105)){
var vec__10969_11107 = chunk__10832_11104.cljs$core$IIndexed$_nth$arity$2(null,i__10834_11106);
var line_11108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10969_11107,(0),null);
var columns_11109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10969_11107,(1),null);
var seq__10972_11110 = cljs.core.seq(columns_11109);
var chunk__10973_11111 = null;
var count__10974_11112 = (0);
var i__10975_11113 = (0);
while(true){
if((i__10975_11113 < count__10974_11112)){
var vec__11006_11114 = chunk__10973_11111.cljs$core$IIndexed$_nth$arity$2(null,i__10975_11113);
var column_11115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11006_11114,(0),null);
var column_info_11116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11006_11114,(1),null);
var seq__11009_11117 = cljs.core.seq(column_info_11116);
var chunk__11010_11118 = null;
var count__11011_11119 = (0);
var i__11012_11120 = (0);
while(true){
if((i__11012_11120 < count__11011_11119)){
var map__11017_11121 = chunk__11010_11118.cljs$core$IIndexed$_nth$arity$2(null,i__11012_11120);
var map__11017_11122__$1 = (((((!((map__11017_11121 == null))))?(((((map__11017_11121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11017_11121.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11017_11121):map__11017_11121);
var gline_11123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11017_11122__$1,cljs.core.cst$kw$gline);
var gcol_11124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11017_11122__$1,cljs.core.cst$kw$gcol);
var name_11125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11017_11122__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11123], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11009_11117,chunk__11010_11118,count__11011_11119,i__11012_11120,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11017_11121,map__11017_11122__$1,gline_11123,gcol_11124,name_11125,vec__11006_11114,column_11115,column_info_11116,vec__10969_11107,line_11108,columns_11109,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11124], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11108,cljs.core.cst$kw$col,column_11115,cljs.core.cst$kw$name,name_11125], null));
});})(seq__11009_11117,chunk__11010_11118,count__11011_11119,i__11012_11120,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11017_11121,map__11017_11122__$1,gline_11123,gcol_11124,name_11125,vec__11006_11114,column_11115,column_info_11116,vec__10969_11107,line_11108,columns_11109,inverted))
,cljs.core.sorted_map()));


var G__11126 = seq__11009_11117;
var G__11127 = chunk__11010_11118;
var G__11128 = count__11011_11119;
var G__11129 = (i__11012_11120 + (1));
seq__11009_11117 = G__11126;
chunk__11010_11118 = G__11127;
count__11011_11119 = G__11128;
i__11012_11120 = G__11129;
continue;
} else {
var temp__5735__auto___11130 = cljs.core.seq(seq__11009_11117);
if(temp__5735__auto___11130){
var seq__11009_11131__$1 = temp__5735__auto___11130;
if(cljs.core.chunked_seq_QMARK_(seq__11009_11131__$1)){
var c__4556__auto___11132 = cljs.core.chunk_first(seq__11009_11131__$1);
var G__11133 = cljs.core.chunk_rest(seq__11009_11131__$1);
var G__11134 = c__4556__auto___11132;
var G__11135 = cljs.core.count(c__4556__auto___11132);
var G__11136 = (0);
seq__11009_11117 = G__11133;
chunk__11010_11118 = G__11134;
count__11011_11119 = G__11135;
i__11012_11120 = G__11136;
continue;
} else {
var map__11019_11137 = cljs.core.first(seq__11009_11131__$1);
var map__11019_11138__$1 = (((((!((map__11019_11137 == null))))?(((((map__11019_11137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11019_11137.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11019_11137):map__11019_11137);
var gline_11139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11019_11138__$1,cljs.core.cst$kw$gline);
var gcol_11140 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11019_11138__$1,cljs.core.cst$kw$gcol);
var name_11141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11019_11138__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11139], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11009_11117,chunk__11010_11118,count__11011_11119,i__11012_11120,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11019_11137,map__11019_11138__$1,gline_11139,gcol_11140,name_11141,seq__11009_11131__$1,temp__5735__auto___11130,vec__11006_11114,column_11115,column_info_11116,vec__10969_11107,line_11108,columns_11109,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11140], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11108,cljs.core.cst$kw$col,column_11115,cljs.core.cst$kw$name,name_11141], null));
});})(seq__11009_11117,chunk__11010_11118,count__11011_11119,i__11012_11120,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11019_11137,map__11019_11138__$1,gline_11139,gcol_11140,name_11141,seq__11009_11131__$1,temp__5735__auto___11130,vec__11006_11114,column_11115,column_info_11116,vec__10969_11107,line_11108,columns_11109,inverted))
,cljs.core.sorted_map()));


var G__11142 = cljs.core.next(seq__11009_11131__$1);
var G__11143 = null;
var G__11144 = (0);
var G__11145 = (0);
seq__11009_11117 = G__11142;
chunk__11010_11118 = G__11143;
count__11011_11119 = G__11144;
i__11012_11120 = G__11145;
continue;
}
} else {
}
}
break;
}


var G__11146 = seq__10972_11110;
var G__11147 = chunk__10973_11111;
var G__11148 = count__10974_11112;
var G__11149 = (i__10975_11113 + (1));
seq__10972_11110 = G__11146;
chunk__10973_11111 = G__11147;
count__10974_11112 = G__11148;
i__10975_11113 = G__11149;
continue;
} else {
var temp__5735__auto___11150 = cljs.core.seq(seq__10972_11110);
if(temp__5735__auto___11150){
var seq__10972_11151__$1 = temp__5735__auto___11150;
if(cljs.core.chunked_seq_QMARK_(seq__10972_11151__$1)){
var c__4556__auto___11152 = cljs.core.chunk_first(seq__10972_11151__$1);
var G__11153 = cljs.core.chunk_rest(seq__10972_11151__$1);
var G__11154 = c__4556__auto___11152;
var G__11155 = cljs.core.count(c__4556__auto___11152);
var G__11156 = (0);
seq__10972_11110 = G__11153;
chunk__10973_11111 = G__11154;
count__10974_11112 = G__11155;
i__10975_11113 = G__11156;
continue;
} else {
var vec__11021_11157 = cljs.core.first(seq__10972_11151__$1);
var column_11158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11021_11157,(0),null);
var column_info_11159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11021_11157,(1),null);
var seq__11024_11160 = cljs.core.seq(column_info_11159);
var chunk__11025_11161 = null;
var count__11026_11162 = (0);
var i__11027_11163 = (0);
while(true){
if((i__11027_11163 < count__11026_11162)){
var map__11032_11164 = chunk__11025_11161.cljs$core$IIndexed$_nth$arity$2(null,i__11027_11163);
var map__11032_11165__$1 = (((((!((map__11032_11164 == null))))?(((((map__11032_11164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11032_11164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11032_11164):map__11032_11164);
var gline_11166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11032_11165__$1,cljs.core.cst$kw$gline);
var gcol_11167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11032_11165__$1,cljs.core.cst$kw$gcol);
var name_11168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11032_11165__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11166], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11024_11160,chunk__11025_11161,count__11026_11162,i__11027_11163,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11032_11164,map__11032_11165__$1,gline_11166,gcol_11167,name_11168,vec__11021_11157,column_11158,column_info_11159,seq__10972_11151__$1,temp__5735__auto___11150,vec__10969_11107,line_11108,columns_11109,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11167], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11108,cljs.core.cst$kw$col,column_11158,cljs.core.cst$kw$name,name_11168], null));
});})(seq__11024_11160,chunk__11025_11161,count__11026_11162,i__11027_11163,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11032_11164,map__11032_11165__$1,gline_11166,gcol_11167,name_11168,vec__11021_11157,column_11158,column_info_11159,seq__10972_11151__$1,temp__5735__auto___11150,vec__10969_11107,line_11108,columns_11109,inverted))
,cljs.core.sorted_map()));


var G__11169 = seq__11024_11160;
var G__11170 = chunk__11025_11161;
var G__11171 = count__11026_11162;
var G__11172 = (i__11027_11163 + (1));
seq__11024_11160 = G__11169;
chunk__11025_11161 = G__11170;
count__11026_11162 = G__11171;
i__11027_11163 = G__11172;
continue;
} else {
var temp__5735__auto___11173__$1 = cljs.core.seq(seq__11024_11160);
if(temp__5735__auto___11173__$1){
var seq__11024_11174__$1 = temp__5735__auto___11173__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11024_11174__$1)){
var c__4556__auto___11175 = cljs.core.chunk_first(seq__11024_11174__$1);
var G__11176 = cljs.core.chunk_rest(seq__11024_11174__$1);
var G__11177 = c__4556__auto___11175;
var G__11178 = cljs.core.count(c__4556__auto___11175);
var G__11179 = (0);
seq__11024_11160 = G__11176;
chunk__11025_11161 = G__11177;
count__11026_11162 = G__11178;
i__11027_11163 = G__11179;
continue;
} else {
var map__11034_11180 = cljs.core.first(seq__11024_11174__$1);
var map__11034_11181__$1 = (((((!((map__11034_11180 == null))))?(((((map__11034_11180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11034_11180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11034_11180):map__11034_11180);
var gline_11182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034_11181__$1,cljs.core.cst$kw$gline);
var gcol_11183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034_11181__$1,cljs.core.cst$kw$gcol);
var name_11184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11034_11181__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11182], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11024_11160,chunk__11025_11161,count__11026_11162,i__11027_11163,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11034_11180,map__11034_11181__$1,gline_11182,gcol_11183,name_11184,seq__11024_11174__$1,temp__5735__auto___11173__$1,vec__11021_11157,column_11158,column_info_11159,seq__10972_11151__$1,temp__5735__auto___11150,vec__10969_11107,line_11108,columns_11109,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11183], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11108,cljs.core.cst$kw$col,column_11158,cljs.core.cst$kw$name,name_11184], null));
});})(seq__11024_11160,chunk__11025_11161,count__11026_11162,i__11027_11163,seq__10972_11110,chunk__10973_11111,count__10974_11112,i__10975_11113,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11034_11180,map__11034_11181__$1,gline_11182,gcol_11183,name_11184,seq__11024_11174__$1,temp__5735__auto___11173__$1,vec__11021_11157,column_11158,column_info_11159,seq__10972_11151__$1,temp__5735__auto___11150,vec__10969_11107,line_11108,columns_11109,inverted))
,cljs.core.sorted_map()));


var G__11185 = cljs.core.next(seq__11024_11174__$1);
var G__11186 = null;
var G__11187 = (0);
var G__11188 = (0);
seq__11024_11160 = G__11185;
chunk__11025_11161 = G__11186;
count__11026_11162 = G__11187;
i__11027_11163 = G__11188;
continue;
}
} else {
}
}
break;
}


var G__11189 = cljs.core.next(seq__10972_11151__$1);
var G__11190 = null;
var G__11191 = (0);
var G__11192 = (0);
seq__10972_11110 = G__11189;
chunk__10973_11111 = G__11190;
count__10974_11112 = G__11191;
i__10975_11113 = G__11192;
continue;
}
} else {
}
}
break;
}


var G__11193 = seq__10831_11103;
var G__11194 = chunk__10832_11104;
var G__11195 = count__10833_11105;
var G__11196 = (i__10834_11106 + (1));
seq__10831_11103 = G__11193;
chunk__10832_11104 = G__11194;
count__10833_11105 = G__11195;
i__10834_11106 = G__11196;
continue;
} else {
var temp__5735__auto___11197 = cljs.core.seq(seq__10831_11103);
if(temp__5735__auto___11197){
var seq__10831_11198__$1 = temp__5735__auto___11197;
if(cljs.core.chunked_seq_QMARK_(seq__10831_11198__$1)){
var c__4556__auto___11199 = cljs.core.chunk_first(seq__10831_11198__$1);
var G__11200 = cljs.core.chunk_rest(seq__10831_11198__$1);
var G__11201 = c__4556__auto___11199;
var G__11202 = cljs.core.count(c__4556__auto___11199);
var G__11203 = (0);
seq__10831_11103 = G__11200;
chunk__10832_11104 = G__11201;
count__10833_11105 = G__11202;
i__10834_11106 = G__11203;
continue;
} else {
var vec__11036_11204 = cljs.core.first(seq__10831_11198__$1);
var line_11205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11036_11204,(0),null);
var columns_11206 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11036_11204,(1),null);
var seq__11039_11207 = cljs.core.seq(columns_11206);
var chunk__11040_11208 = null;
var count__11041_11209 = (0);
var i__11042_11210 = (0);
while(true){
if((i__11042_11210 < count__11041_11209)){
var vec__11073_11211 = chunk__11040_11208.cljs$core$IIndexed$_nth$arity$2(null,i__11042_11210);
var column_11212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11073_11211,(0),null);
var column_info_11213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11073_11211,(1),null);
var seq__11076_11214 = cljs.core.seq(column_info_11213);
var chunk__11077_11215 = null;
var count__11078_11216 = (0);
var i__11079_11217 = (0);
while(true){
if((i__11079_11217 < count__11078_11216)){
var map__11084_11218 = chunk__11077_11215.cljs$core$IIndexed$_nth$arity$2(null,i__11079_11217);
var map__11084_11219__$1 = (((((!((map__11084_11218 == null))))?(((((map__11084_11218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11084_11218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11084_11218):map__11084_11218);
var gline_11220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11084_11219__$1,cljs.core.cst$kw$gline);
var gcol_11221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11084_11219__$1,cljs.core.cst$kw$gcol);
var name_11222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11084_11219__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11220], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11076_11214,chunk__11077_11215,count__11078_11216,i__11079_11217,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11084_11218,map__11084_11219__$1,gline_11220,gcol_11221,name_11222,vec__11073_11211,column_11212,column_info_11213,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11221], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11205,cljs.core.cst$kw$col,column_11212,cljs.core.cst$kw$name,name_11222], null));
});})(seq__11076_11214,chunk__11077_11215,count__11078_11216,i__11079_11217,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11084_11218,map__11084_11219__$1,gline_11220,gcol_11221,name_11222,vec__11073_11211,column_11212,column_info_11213,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted))
,cljs.core.sorted_map()));


var G__11223 = seq__11076_11214;
var G__11224 = chunk__11077_11215;
var G__11225 = count__11078_11216;
var G__11226 = (i__11079_11217 + (1));
seq__11076_11214 = G__11223;
chunk__11077_11215 = G__11224;
count__11078_11216 = G__11225;
i__11079_11217 = G__11226;
continue;
} else {
var temp__5735__auto___11227__$1 = cljs.core.seq(seq__11076_11214);
if(temp__5735__auto___11227__$1){
var seq__11076_11228__$1 = temp__5735__auto___11227__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11076_11228__$1)){
var c__4556__auto___11229 = cljs.core.chunk_first(seq__11076_11228__$1);
var G__11230 = cljs.core.chunk_rest(seq__11076_11228__$1);
var G__11231 = c__4556__auto___11229;
var G__11232 = cljs.core.count(c__4556__auto___11229);
var G__11233 = (0);
seq__11076_11214 = G__11230;
chunk__11077_11215 = G__11231;
count__11078_11216 = G__11232;
i__11079_11217 = G__11233;
continue;
} else {
var map__11086_11234 = cljs.core.first(seq__11076_11228__$1);
var map__11086_11235__$1 = (((((!((map__11086_11234 == null))))?(((((map__11086_11234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11086_11234.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11086_11234):map__11086_11234);
var gline_11236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11086_11235__$1,cljs.core.cst$kw$gline);
var gcol_11237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11086_11235__$1,cljs.core.cst$kw$gcol);
var name_11238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11086_11235__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11236], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11076_11214,chunk__11077_11215,count__11078_11216,i__11079_11217,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11086_11234,map__11086_11235__$1,gline_11236,gcol_11237,name_11238,seq__11076_11228__$1,temp__5735__auto___11227__$1,vec__11073_11211,column_11212,column_info_11213,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11237], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11205,cljs.core.cst$kw$col,column_11212,cljs.core.cst$kw$name,name_11238], null));
});})(seq__11076_11214,chunk__11077_11215,count__11078_11216,i__11079_11217,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11086_11234,map__11086_11235__$1,gline_11236,gcol_11237,name_11238,seq__11076_11228__$1,temp__5735__auto___11227__$1,vec__11073_11211,column_11212,column_info_11213,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted))
,cljs.core.sorted_map()));


var G__11239 = cljs.core.next(seq__11076_11228__$1);
var G__11240 = null;
var G__11241 = (0);
var G__11242 = (0);
seq__11076_11214 = G__11239;
chunk__11077_11215 = G__11240;
count__11078_11216 = G__11241;
i__11079_11217 = G__11242;
continue;
}
} else {
}
}
break;
}


var G__11243 = seq__11039_11207;
var G__11244 = chunk__11040_11208;
var G__11245 = count__11041_11209;
var G__11246 = (i__11042_11210 + (1));
seq__11039_11207 = G__11243;
chunk__11040_11208 = G__11244;
count__11041_11209 = G__11245;
i__11042_11210 = G__11246;
continue;
} else {
var temp__5735__auto___11247__$1 = cljs.core.seq(seq__11039_11207);
if(temp__5735__auto___11247__$1){
var seq__11039_11248__$1 = temp__5735__auto___11247__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11039_11248__$1)){
var c__4556__auto___11249 = cljs.core.chunk_first(seq__11039_11248__$1);
var G__11250 = cljs.core.chunk_rest(seq__11039_11248__$1);
var G__11251 = c__4556__auto___11249;
var G__11252 = cljs.core.count(c__4556__auto___11249);
var G__11253 = (0);
seq__11039_11207 = G__11250;
chunk__11040_11208 = G__11251;
count__11041_11209 = G__11252;
i__11042_11210 = G__11253;
continue;
} else {
var vec__11088_11254 = cljs.core.first(seq__11039_11248__$1);
var column_11255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11088_11254,(0),null);
var column_info_11256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11088_11254,(1),null);
var seq__11091_11257 = cljs.core.seq(column_info_11256);
var chunk__11092_11258 = null;
var count__11093_11259 = (0);
var i__11094_11260 = (0);
while(true){
if((i__11094_11260 < count__11093_11259)){
var map__11099_11261 = chunk__11092_11258.cljs$core$IIndexed$_nth$arity$2(null,i__11094_11260);
var map__11099_11262__$1 = (((((!((map__11099_11261 == null))))?(((((map__11099_11261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11099_11261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11099_11261):map__11099_11261);
var gline_11263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11099_11262__$1,cljs.core.cst$kw$gline);
var gcol_11264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11099_11262__$1,cljs.core.cst$kw$gcol);
var name_11265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11099_11262__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11263], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11091_11257,chunk__11092_11258,count__11093_11259,i__11094_11260,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11099_11261,map__11099_11262__$1,gline_11263,gcol_11264,name_11265,vec__11088_11254,column_11255,column_info_11256,seq__11039_11248__$1,temp__5735__auto___11247__$1,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11264], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11205,cljs.core.cst$kw$col,column_11255,cljs.core.cst$kw$name,name_11265], null));
});})(seq__11091_11257,chunk__11092_11258,count__11093_11259,i__11094_11260,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11099_11261,map__11099_11262__$1,gline_11263,gcol_11264,name_11265,vec__11088_11254,column_11255,column_info_11256,seq__11039_11248__$1,temp__5735__auto___11247__$1,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted))
,cljs.core.sorted_map()));


var G__11266 = seq__11091_11257;
var G__11267 = chunk__11092_11258;
var G__11268 = count__11093_11259;
var G__11269 = (i__11094_11260 + (1));
seq__11091_11257 = G__11266;
chunk__11092_11258 = G__11267;
count__11093_11259 = G__11268;
i__11094_11260 = G__11269;
continue;
} else {
var temp__5735__auto___11270__$2 = cljs.core.seq(seq__11091_11257);
if(temp__5735__auto___11270__$2){
var seq__11091_11271__$1 = temp__5735__auto___11270__$2;
if(cljs.core.chunked_seq_QMARK_(seq__11091_11271__$1)){
var c__4556__auto___11272 = cljs.core.chunk_first(seq__11091_11271__$1);
var G__11273 = cljs.core.chunk_rest(seq__11091_11271__$1);
var G__11274 = c__4556__auto___11272;
var G__11275 = cljs.core.count(c__4556__auto___11272);
var G__11276 = (0);
seq__11091_11257 = G__11273;
chunk__11092_11258 = G__11274;
count__11093_11259 = G__11275;
i__11094_11260 = G__11276;
continue;
} else {
var map__11101_11277 = cljs.core.first(seq__11091_11271__$1);
var map__11101_11278__$1 = (((((!((map__11101_11277 == null))))?(((((map__11101_11277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11101_11277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11101_11277):map__11101_11277);
var gline_11279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11101_11278__$1,cljs.core.cst$kw$gline);
var gcol_11280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11101_11278__$1,cljs.core.cst$kw$gcol);
var name_11281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11101_11278__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11279], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11091_11257,chunk__11092_11258,count__11093_11259,i__11094_11260,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11101_11277,map__11101_11278__$1,gline_11279,gcol_11280,name_11281,seq__11091_11271__$1,temp__5735__auto___11270__$2,vec__11088_11254,column_11255,column_info_11256,seq__11039_11248__$1,temp__5735__auto___11247__$1,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11280], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11205,cljs.core.cst$kw$col,column_11255,cljs.core.cst$kw$name,name_11281], null));
});})(seq__11091_11257,chunk__11092_11258,count__11093_11259,i__11094_11260,seq__11039_11207,chunk__11040_11208,count__11041_11209,i__11042_11210,seq__10831_11103,chunk__10832_11104,count__10833_11105,i__10834_11106,map__11101_11277,map__11101_11278__$1,gline_11279,gcol_11280,name_11281,seq__11091_11271__$1,temp__5735__auto___11270__$2,vec__11088_11254,column_11255,column_info_11256,seq__11039_11248__$1,temp__5735__auto___11247__$1,vec__11036_11204,line_11205,columns_11206,seq__10831_11198__$1,temp__5735__auto___11197,inverted))
,cljs.core.sorted_map()));


var G__11282 = cljs.core.next(seq__11091_11271__$1);
var G__11283 = null;
var G__11284 = (0);
var G__11285 = (0);
seq__11091_11257 = G__11282;
chunk__11092_11258 = G__11283;
count__11093_11259 = G__11284;
i__11094_11260 = G__11285;
continue;
}
} else {
}
}
break;
}


var G__11286 = cljs.core.next(seq__11039_11248__$1);
var G__11287 = null;
var G__11288 = (0);
var G__11289 = (0);
seq__11039_11207 = G__11286;
chunk__11040_11208 = G__11287;
count__11041_11209 = G__11288;
i__11042_11210 = G__11289;
continue;
}
} else {
}
}
break;
}


var G__11290 = cljs.core.next(seq__10831_11198__$1);
var G__11291 = null;
var G__11292 = (0);
var G__11293 = (0);
seq__10831_11103 = G__11290;
chunk__10832_11104 = G__11291;
count__10833_11105 = G__11292;
i__10834_11106 = G__11293;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
