// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e16285){var e = e16285;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__16286_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__16286_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__16286_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__16286_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__16286_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16287_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16287_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16288_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16288_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__16293 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16293,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16293,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16289_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16289_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__16296 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16296,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16296,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16290_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16290_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16291_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16291_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16292_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__16292_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16299_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__16299_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__16300 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__16300) : intersecting_vars.call(null,G__16300));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__16303,optional_QMARK_,fuel,max_fuel){
var map__16304 = p__16303;
var map__16304__$1 = (((((!((map__16304 == null))))?(((((map__16304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16304.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16304):map__16304);
var res = map__16304__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16304__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16371){
var state_val_16372 = (state_16371[(1)]);
if((state_val_16372 === (7))){
var inst_16360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16361 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_16362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_16361,clause);
var inst_16363 = [null,inst_16362];
var inst_16364 = (new cljs.core.PersistentVector(null,2,(5),inst_16360,inst_16363,null));
var state_16371__$1 = state_16371;
var statearr_16373_16401 = state_16371__$1;
(statearr_16373_16401[(2)] = inst_16364);

(statearr_16373_16401[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (1))){
var state_16371__$1 = state_16371;
var statearr_16374_16402 = state_16371__$1;
(statearr_16374_16402[(2)] = null);

(statearr_16374_16402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (4))){
var inst_16306 = (state_16371[(2)]);
var state_16371__$1 = state_16371;
var statearr_16375_16403 = state_16371__$1;
(statearr_16375_16403[(2)] = inst_16306);

(statearr_16375_16403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (15))){
var inst_16349 = (state_16371[(2)]);
var inst_16350 = fluree.db.util.async.throw_err(inst_16349);
var inst_16351 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_16350);
var inst_16352 = cljs.core.count(inst_16351);
var inst_16353 = fluree.db.query.analytical.add_fuel(inst_16352,fuel,max_fuel);
var inst_16354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16355 = [inst_16350,r];
var inst_16356 = (new cljs.core.PersistentVector(null,2,(5),inst_16354,inst_16355,null));
var state_16371__$1 = (function (){var statearr_16376 = state_16371;
(statearr_16376[(7)] = inst_16353);

return statearr_16376;
})();
var statearr_16377_16404 = state_16371__$1;
(statearr_16377_16404[(2)] = inst_16356);

(statearr_16377_16404[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (13))){
var inst_16315 = (state_16371[(8)]);
var inst_16328 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16329 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_16328);
var inst_16330 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_16315);
var inst_16331 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16330);
var inst_16332 = cljs.core.set(inst_16331);
var inst_16333 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_16329);
var inst_16334 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16333);
var inst_16335 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16332,inst_16334);
var inst_16336 = (function (){var all_wd = inst_16315;
var optional = inst_16329;
var all_wd_vars = inst_16332;
var all_vars = inst_16335;
return (function (p1__16301_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__16301_SHARP_) : all_vars.call(null,p1__16301_SHARP_));
});
})();
var inst_16337 = cljs.core.keys(vars);
var inst_16338 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16336,inst_16337);
var inst_16339 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_16338);
var inst_16340 = cljs.core.set(inst_16339);
var inst_16341 = (function (){var all_wd = inst_16315;
var optional = inst_16329;
var all_wd_vars = inst_16332;
var all_vars = inst_16335;
var intersecting_vars = inst_16340;
return (function (p1__16302_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__16302_SHARP_);
});
})();
var inst_16342 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16341,inst_16315);
var inst_16343 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_16342);
var inst_16344 = fluree.db.query.analytical.select_from_tuples(inst_16343,res);
var inst_16345 = fluree.db.query.analytical.replace_vars_wikidata(inst_16315,inst_16340,vars);
var inst_16346 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_16340,inst_16335);
var inst_16347 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_16345,inst_16343,inst_16344,inst_16346,inst_16329);
var state_16371__$1 = state_16371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16371__$1,(15),inst_16347);
} else {
if((state_val_16372 === (6))){
var inst_16316 = (state_16371[(9)]);
var inst_16314 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16315 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_16314);
var inst_16316__$1 = optional_QMARK_;
var state_16371__$1 = (function (){var statearr_16378 = state_16371;
(statearr_16378[(8)] = inst_16315);

(statearr_16378[(9)] = inst_16316__$1);

return statearr_16378;
})();
if(cljs.core.truth_(inst_16316__$1)){
var statearr_16379_16405 = state_16371__$1;
(statearr_16379_16405[(1)] = (9));

} else {
var statearr_16380_16406 = state_16371__$1;
(statearr_16380_16406[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (3))){
var inst_16369 = (state_16371[(2)]);
var state_16371__$1 = state_16371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16371__$1,inst_16369);
} else {
if((state_val_16372 === (12))){
var inst_16324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16325 = [null,r];
var inst_16326 = (new cljs.core.PersistentVector(null,2,(5),inst_16324,inst_16325,null));
var state_16371__$1 = state_16371;
var statearr_16381_16407 = state_16371__$1;
(statearr_16381_16407[(2)] = inst_16326);

(statearr_16381_16407[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (2))){
var _ = (function (){var statearr_16382 = state_16371;
(statearr_16382[(4)] = cljs.core.cons((5),(state_16371[(4)])));

return statearr_16382;
})();
var inst_16312 = (r == null);
var state_16371__$1 = state_16371;
if(cljs.core.truth_(inst_16312)){
var statearr_16383_16408 = state_16371__$1;
(statearr_16383_16408[(1)] = (6));

} else {
var statearr_16384_16409 = state_16371__$1;
(statearr_16384_16409[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (11))){
var inst_16322 = (state_16371[(2)]);
var state_16371__$1 = state_16371;
if(cljs.core.truth_(inst_16322)){
var statearr_16386_16410 = state_16371__$1;
(statearr_16386_16410[(1)] = (12));

} else {
var statearr_16387_16411 = state_16371__$1;
(statearr_16387_16411[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (9))){
var inst_16315 = (state_16371[(8)]);
var inst_16318 = cljs.core.empty_QMARK_(inst_16315);
var inst_16319 = (!(inst_16318));
var state_16371__$1 = state_16371;
var statearr_16388_16412 = state_16371__$1;
(statearr_16388_16412[(2)] = inst_16319);

(statearr_16388_16412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (5))){
var _ = (function (){var statearr_16389 = state_16371;
(statearr_16389[(4)] = cljs.core.rest((state_16371[(4)])));

return statearr_16389;
})();
var state_16371__$1 = state_16371;
var ex16385 = (state_16371__$1[(2)]);
var statearr_16390_16413 = state_16371__$1;
(statearr_16390_16413[(5)] = ex16385);


if((ex16385 instanceof Error)){
var statearr_16391_16414 = state_16371__$1;
(statearr_16391_16414[(1)] = (4));

(statearr_16391_16414[(5)] = null);

} else {
throw ex16385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (14))){
var inst_16358 = (state_16371[(2)]);
var state_16371__$1 = state_16371;
var statearr_16392_16415 = state_16371__$1;
(statearr_16392_16415[(2)] = inst_16358);

(statearr_16392_16415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (10))){
var inst_16316 = (state_16371[(9)]);
var state_16371__$1 = state_16371;
var statearr_16393_16416 = state_16371__$1;
(statearr_16393_16416[(2)] = inst_16316);

(statearr_16393_16416[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16372 === (8))){
var inst_16366 = (state_16371[(2)]);
var _ = (function (){var statearr_16394 = state_16371;
(statearr_16394[(4)] = cljs.core.rest((state_16371[(4)])));

return statearr_16394;
})();
var state_16371__$1 = state_16371;
var statearr_16395_16417 = state_16371__$1;
(statearr_16395_16417[(2)] = inst_16366);

(statearr_16395_16417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_16396 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16396[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__);

(statearr_16396[(1)] = (1));

return statearr_16396;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1 = (function (state_16371){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16371);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16397){var ex__2417__auto__ = e16397;
var statearr_16398_16418 = state_16371;
(statearr_16398_16418[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16371[(4)]))){
var statearr_16399_16419 = state_16371;
(statearr_16399_16419[(1)] = cljs.core.first((state_16371[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16420 = state_16371;
state_16371 = G__16420;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__ = function(state_16371){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1.call(this,state_16371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16400 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16400[(6)] = c__2436__auto__);

return statearr_16400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__16422 = arguments.length;
switch (G__16422) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16516){
var state_val_16517 = (state_16516[(1)]);
if((state_val_16517 === (7))){
var inst_16429 = (state_16516[(7)]);
var inst_16439 = clojure.string.starts_with_QMARK_(inst_16429,"$fdb");
var state_16516__$1 = state_16516;
if(inst_16439){
var statearr_16518_16567 = state_16516__$1;
(statearr_16518_16567[(1)] = (9));

} else {
var statearr_16519_16568 = state_16516__$1;
(statearr_16519_16568[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (20))){
var state_16516__$1 = state_16516;
var statearr_16520_16569 = state_16516__$1;
(statearr_16520_16569[(2)] = null);

(statearr_16520_16569[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (27))){
var inst_16479 = (state_16516[(8)]);
var state_16516__$1 = state_16516;
var statearr_16521_16570 = state_16516__$1;
(statearr_16521_16570[(2)] = inst_16479);

(statearr_16521_16570[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (1))){
var state_16516__$1 = state_16516;
var statearr_16522_16571 = state_16516__$1;
(statearr_16522_16571[(2)] = null);

(statearr_16522_16571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (24))){
var inst_16502 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
var statearr_16523_16572 = state_16516__$1;
(statearr_16523_16572[(2)] = inst_16502);

(statearr_16523_16572[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (4))){
var inst_16423 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
var statearr_16524_16573 = state_16516__$1;
(statearr_16524_16573[(2)] = inst_16423);

(statearr_16524_16573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (15))){
var inst_16446 = (state_16516[(9)]);
var inst_16452 = (state_16516[(2)]);
var inst_16453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16454 = cljs.core.PersistentVector.EMPTY;
var inst_16455 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16456 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16454,inst_16455);
var inst_16457 = [inst_16446,inst_16456];
var inst_16458 = (new cljs.core.PersistentVector(null,2,(5),inst_16453,inst_16457,null));
var state_16516__$1 = (function (){var statearr_16525 = state_16516;
(statearr_16525[(10)] = inst_16452);

return statearr_16525;
})();
var statearr_16526_16574 = state_16516__$1;
(statearr_16526_16574[(2)] = inst_16458);

(statearr_16526_16574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (21))){
var inst_16505 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
var statearr_16527_16575 = state_16516__$1;
(statearr_16527_16575[(2)] = inst_16505);

(statearr_16527_16575[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (13))){
var inst_16446 = (state_16516[(9)]);
var inst_16449 = (function(){throw inst_16446})();
var state_16516__$1 = state_16516;
var statearr_16528_16576 = state_16516__$1;
(statearr_16528_16576[(2)] = inst_16449);

(statearr_16528_16576[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (22))){
var inst_16470 = (state_16516[(11)]);
var inst_16468 = (state_16516[(12)]);
var inst_16472 = fluree.db.query.analytical.parse_block_from_source(inst_16468);
var inst_16473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16474 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_16470];
var inst_16475 = (new cljs.core.PersistentVector(null,2,(5),inst_16473,inst_16474,null));
var inst_16476 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_16475);
var state_16516__$1 = (function (){var statearr_16529 = state_16516;
(statearr_16529[(13)] = inst_16472);

return statearr_16529;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16516__$1,(25),inst_16476);
} else {
if((state_val_16517 === (29))){
var inst_16483 = (state_16516[(2)]);
var inst_16484 = fluree.db.util.async.throw_err(inst_16483);
var state_16516__$1 = state_16516;
var statearr_16530_16577 = state_16516__$1;
(statearr_16530_16577[(2)] = inst_16484);

(statearr_16530_16577[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (6))){
var inst_16432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16433 = cljs.core.PersistentVector.EMPTY;
var inst_16434 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16435 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16433,inst_16434);
var inst_16436 = [db,inst_16435];
var inst_16437 = (new cljs.core.PersistentVector(null,2,(5),inst_16432,inst_16436,null));
var state_16516__$1 = state_16516;
var statearr_16531_16578 = state_16516__$1;
(statearr_16531_16578[(2)] = inst_16437);

(statearr_16531_16578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (28))){
var inst_16487 = (state_16516[(2)]);
var inst_16488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16489 = cljs.core.PersistentVector.EMPTY;
var inst_16490 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_16491 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16489,inst_16490);
var inst_16492 = [inst_16487,inst_16491];
var inst_16493 = (new cljs.core.PersistentVector(null,2,(5),inst_16488,inst_16492,null));
var state_16516__$1 = state_16516;
var statearr_16532_16579 = state_16516__$1;
(statearr_16532_16579[(2)] = inst_16493);

(statearr_16532_16579[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (25))){
var inst_16472 = (state_16516[(13)]);
var inst_16478 = (state_16516[(2)]);
var inst_16479 = fluree.db.util.async.throw_err(inst_16478);
var state_16516__$1 = (function (){var statearr_16533 = state_16516;
(statearr_16533[(8)] = inst_16479);

return statearr_16533;
})();
if(cljs.core.truth_(inst_16472)){
var statearr_16534_16580 = state_16516__$1;
(statearr_16534_16580[(1)] = (26));

} else {
var statearr_16535_16581 = state_16516__$1;
(statearr_16535_16581[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (17))){
var state_16516__$1 = state_16516;
var statearr_16536_16582 = state_16516__$1;
(statearr_16536_16582[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (3))){
var inst_16514 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16516__$1,inst_16514);
} else {
if((state_val_16517 === (12))){
var inst_16446 = (state_16516[(9)]);
var inst_16445 = (state_16516[(2)]);
var inst_16446__$1 = fluree.db.util.async.throw_err(inst_16445);
var inst_16447 = fluree.db.util.core.exception_QMARK_(inst_16446__$1);
var state_16516__$1 = (function (){var statearr_16538 = state_16516;
(statearr_16538[(9)] = inst_16446__$1);

return statearr_16538;
})();
if(inst_16447){
var statearr_16539_16583 = state_16516__$1;
(statearr_16539_16583[(1)] = (13));

} else {
var statearr_16540_16584 = state_16516__$1;
(statearr_16540_16584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (2))){
var inst_16429 = (state_16516[(7)]);
var _ = (function (){var statearr_16541 = state_16516;
(statearr_16541[(4)] = cljs.core.cons((5),(state_16516[(4)])));

return statearr_16541;
})();
var inst_16429__$1 = cljs.core.first(clause);
var inst_16430 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_16429__$1);
var state_16516__$1 = (function (){var statearr_16542 = state_16516;
(statearr_16542[(7)] = inst_16429__$1);

return statearr_16542;
})();
if(inst_16430){
var statearr_16543_16585 = state_16516__$1;
(statearr_16543_16585[(1)] = (6));

} else {
var statearr_16544_16586 = state_16516__$1;
(statearr_16544_16586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (23))){
var inst_16429 = (state_16516[(7)]);
var inst_16495 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16429)," is not supported in Fluree"].join('');
var inst_16496 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16497 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16498 = cljs.core.PersistentHashMap.fromArrays(inst_16496,inst_16497);
var inst_16499 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16495,inst_16498);
var inst_16500 = (function(){throw inst_16499})();
var state_16516__$1 = state_16516;
var statearr_16545_16587 = state_16516__$1;
(statearr_16545_16587[(2)] = inst_16500);

(statearr_16545_16587[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (19))){
var inst_16470 = (state_16516[(11)]);
var inst_16429 = (state_16516[(7)]);
var inst_16467 = fluree.db.query.analytical.isolate_source_name(inst_16429);
var inst_16468 = fluree.db.query.analytical.isolate_source_block(inst_16429);
var inst_16469 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16467);
var inst_16470__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_16469);
var state_16516__$1 = (function (){var statearr_16546 = state_16516;
(statearr_16546[(11)] = inst_16470__$1);

(statearr_16546[(12)] = inst_16468);

return statearr_16546;
})();
if(cljs.core.truth_(inst_16470__$1)){
var statearr_16547_16588 = state_16516__$1;
(statearr_16547_16588[(1)] = (22));

} else {
var statearr_16548_16589 = state_16516__$1;
(statearr_16548_16589[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (11))){
var inst_16509 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
var statearr_16550_16590 = state_16516__$1;
(statearr_16550_16590[(2)] = inst_16509);

(statearr_16550_16590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (9))){
var inst_16429 = (state_16516[(7)]);
var inst_16441 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_16429,(4));
var inst_16442 = fluree.db.query.analytical.parse_block_from_source(inst_16441);
var inst_16443 = fluree.db.time_travel.as_of_block(db,inst_16442);
var state_16516__$1 = state_16516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16516__$1,(12),inst_16443);
} else {
if((state_val_16517 === (5))){
var _ = (function (){var statearr_16551 = state_16516;
(statearr_16551[(4)] = cljs.core.rest((state_16516[(4)])));

return statearr_16551;
})();
var state_16516__$1 = state_16516;
var ex16549 = (state_16516__$1[(2)]);
var statearr_16552_16591 = state_16516__$1;
(statearr_16552_16591[(5)] = ex16549);


if((ex16549 instanceof Error)){
var statearr_16553_16592 = state_16516__$1;
(statearr_16553_16592[(1)] = (4));

(statearr_16553_16592[(5)] = null);

} else {
throw ex16549;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (14))){
var state_16516__$1 = state_16516;
var statearr_16554_16593 = state_16516__$1;
(statearr_16554_16593[(2)] = null);

(statearr_16554_16593[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (26))){
var inst_16479 = (state_16516[(8)]);
var inst_16472 = (state_16516[(13)]);
var inst_16481 = fluree.db.time_travel.as_of_block(inst_16479,inst_16472);
var state_16516__$1 = state_16516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16516__$1,(29),inst_16481);
} else {
if((state_val_16517 === (16))){
var inst_16462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16463 = ["$wd",clause];
var inst_16464 = (new cljs.core.PersistentVector(null,2,(5),inst_16462,inst_16463,null));
var state_16516__$1 = state_16516;
var statearr_16555_16594 = state_16516__$1;
(statearr_16555_16594[(2)] = inst_16464);

(statearr_16555_16594[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (10))){
var inst_16429 = (state_16516[(7)]);
var inst_16460 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_16429);
var state_16516__$1 = state_16516;
if(inst_16460){
var statearr_16556_16595 = state_16516__$1;
(statearr_16556_16595[(1)] = (16));

} else {
var statearr_16557_16596 = state_16516__$1;
(statearr_16557_16596[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (18))){
var inst_16507 = (state_16516[(2)]);
var state_16516__$1 = state_16516;
var statearr_16558_16597 = state_16516__$1;
(statearr_16558_16597[(2)] = inst_16507);

(statearr_16558_16597[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16517 === (8))){
var inst_16511 = (state_16516[(2)]);
var _ = (function (){var statearr_16559 = state_16516;
(statearr_16559[(4)] = cljs.core.rest((state_16516[(4)])));

return statearr_16559;
})();
var state_16516__$1 = state_16516;
var statearr_16560_16598 = state_16516__$1;
(statearr_16560_16598[(2)] = inst_16511);

(statearr_16560_16598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2414__auto__ = null;
var fluree$db$query$analytical$state_machine__2414__auto____0 = (function (){
var statearr_16561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16561[(0)] = fluree$db$query$analytical$state_machine__2414__auto__);

(statearr_16561[(1)] = (1));

return statearr_16561;
});
var fluree$db$query$analytical$state_machine__2414__auto____1 = (function (state_16516){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16516);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16562){var ex__2417__auto__ = e16562;
var statearr_16563_16599 = state_16516;
(statearr_16563_16599[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16516[(4)]))){
var statearr_16564_16600 = state_16516;
(statearr_16564_16600[(1)] = cljs.core.first((state_16516[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16601 = state_16516;
state_16516 = G__16601;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2414__auto__ = function(state_16516){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2414__auto____1.call(this,state_16516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2414__auto____0;
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2414__auto____1;
return fluree$db$query$analytical$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16565 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16565[(6)] = c__2436__auto__);

return statearr_16565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__16602){
var vec__16603 = p__16602;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16603,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16603,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16606_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__16606_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__16610 = subjects;
var vec__16611 = G__16610;
var seq__16612 = cljs.core.seq(vec__16611);
var first__16613 = cljs.core.first(seq__16612);
var seq__16612__$1 = cljs.core.next(seq__16612);
var subject = first__16613;
var r = seq__16612__$1;
var acc = expanded_map;
var G__16610__$1 = G__16610;
var acc__$1 = acc;
while(true){
var vec__16617 = G__16610__$1;
var seq__16618 = cljs.core.seq(vec__16617);
var first__16619 = cljs.core.first(seq__16618);
var seq__16618__$1 = cljs.core.next(seq__16618);
var subject__$1 = first__16619;
var r__$1 = seq__16618__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__16620 = r__$1;
var G__16621 = acc__$2;
G__16610__$1 = G__16620;
acc__$1 = G__16621;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__16610__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__16610__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__16610__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__16610__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__16610__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__16610__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__16617,seq__16618,first__16619,seq__16618__$1,subject__$1,r__$1,acc__$2,G__16610,vec__16611,seq__16612,first__16613,seq__16612__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__16622 = r__$1;
var G__16623 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__16610__$1 = G__16622;
acc__$1 = G__16623;
continue;
} else {
var G__16624 = subjects;
var G__16625 = acc_STAR_;
G__16610__$1 = G__16624;
acc__$1 = G__16625;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16626_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__16626_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16717){
var state_val_16718 = (state_16717[(1)]);
if((state_val_16718 === (7))){
var state_16717__$1 = state_16717;
var statearr_16719_16765 = state_16717__$1;
(statearr_16719_16765[(2)] = (100));

(statearr_16719_16765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (20))){
var inst_16666 = (state_16717[(7)]);
var state_16717__$1 = state_16717;
var statearr_16720_16766 = state_16717__$1;
(statearr_16720_16766[(2)] = inst_16666);

(statearr_16720_16766[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (1))){
var state_16717__$1 = state_16717;
var statearr_16721_16767 = state_16717__$1;
(statearr_16721_16767[(2)] = null);

(statearr_16721_16767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (24))){
var inst_16703 = (state_16717[(8)]);
var inst_16705 = (state_16717[(9)]);
var inst_16638 = (state_16717[(10)]);
var inst_16704 = (state_16717[(11)]);
var inst_16708 = (function (){var max_depth = inst_16638;
var recur_map__$1 = inst_16704;
var subjects = inst_16703;
var tuples = inst_16705;
return (function (p1__16627_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__16627_SHARP_)],null));
});
})();
var inst_16709 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16708,inst_16705);
var inst_16710 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_16709);
var state_16717__$1 = state_16717;
var statearr_16722_16768 = state_16717__$1;
(statearr_16722_16768[(2)] = inst_16710);

(statearr_16722_16768[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (4))){
var inst_16628 = (state_16717[(2)]);
var state_16717__$1 = state_16717;
var statearr_16723_16769 = state_16717__$1;
(statearr_16723_16769[(2)] = inst_16628);

(statearr_16723_16769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (15))){
var inst_16651 = (state_16717[(12)]);
var inst_16662 = cljs.core.PersistentVector.EMPTY;
var inst_16663 = cljs.core.seq(inst_16651);
var inst_16664 = cljs.core.first(inst_16663);
var inst_16665 = cljs.core.next(inst_16663);
var inst_16666 = inst_16662;
var inst_16667 = inst_16651;
var state_16717__$1 = (function (){var statearr_16724 = state_16717;
(statearr_16724[(7)] = inst_16666);

(statearr_16724[(13)] = inst_16667);

(statearr_16724[(14)] = inst_16665);

(statearr_16724[(15)] = inst_16664);

return statearr_16724;
})();
var statearr_16725_16770 = state_16717__$1;
(statearr_16725_16770[(2)] = null);

(statearr_16725_16770[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (21))){
var inst_16687 = (state_16717[(2)]);
var state_16717__$1 = state_16717;
var statearr_16726_16771 = state_16717__$1;
(statearr_16726_16771[(2)] = inst_16687);

(statearr_16726_16771[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (13))){
var inst_16700 = (state_16717[(2)]);
var state_16717__$1 = state_16717;
var statearr_16727_16772 = state_16717__$1;
(statearr_16727_16772[(2)] = inst_16700);

(statearr_16727_16772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (22))){
var inst_16666 = (state_16717[(7)]);
var inst_16674 = (state_16717[(16)]);
var inst_16681 = (state_16717[(2)]);
var inst_16682 = fluree.db.util.async.throw_err(inst_16681);
var inst_16683 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_16666,inst_16682);
var inst_16666__$1 = inst_16683;
var inst_16667 = inst_16674;
var state_16717__$1 = (function (){var statearr_16728 = state_16717;
(statearr_16728[(7)] = inst_16666__$1);

(statearr_16728[(13)] = inst_16667);

return statearr_16728;
})();
var statearr_16729_16773 = state_16717__$1;
(statearr_16729_16773[(2)] = null);

(statearr_16729_16773[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (6))){
var inst_16634 = (state_16717[(17)]);
var state_16717__$1 = state_16717;
var statearr_16730_16774 = state_16717__$1;
(statearr_16730_16774[(2)] = inst_16634);

(statearr_16730_16774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (25))){
var inst_16712 = (state_16717[(2)]);
var _ = (function (){var statearr_16731 = state_16717;
(statearr_16731[(4)] = cljs.core.rest((state_16717[(4)])));

return statearr_16731;
})();
var state_16717__$1 = state_16717;
var statearr_16732_16775 = state_16717__$1;
(statearr_16732_16775[(2)] = inst_16712);

(statearr_16732_16775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (17))){
var inst_16667 = (state_16717[(13)]);
var inst_16673 = (state_16717[(18)]);
var inst_16672 = cljs.core.seq(inst_16667);
var inst_16673__$1 = cljs.core.first(inst_16672);
var inst_16674 = cljs.core.next(inst_16672);
var state_16717__$1 = (function (){var statearr_16733 = state_16717;
(statearr_16733[(18)] = inst_16673__$1);

(statearr_16733[(16)] = inst_16674);

return statearr_16733;
})();
if(cljs.core.truth_(inst_16673__$1)){
var statearr_16734_16776 = state_16717__$1;
(statearr_16734_16776[(1)] = (19));

} else {
var statearr_16735_16777 = state_16717__$1;
(statearr_16735_16777[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (3))){
var inst_16715 = (state_16717[(2)]);
var state_16717__$1 = state_16717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16717__$1,inst_16715);
} else {
if((state_val_16718 === (12))){
var inst_16640 = (state_16717[(19)]);
var inst_16651 = (state_16717[(12)]);
var inst_16646 = cljs.core.vals(inst_16640);
var inst_16647 = cljs.core.flatten(inst_16646);
var inst_16648 = cljs.core.set(inst_16647);
var inst_16649 = cljs.core.keys(inst_16640);
var inst_16650 = cljs.core.set(inst_16649);
var inst_16651__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_16648,inst_16650);
var inst_16652 = cljs.core.empty_QMARK_(inst_16651__$1);
var state_16717__$1 = (function (){var statearr_16736 = state_16717;
(statearr_16736[(12)] = inst_16651__$1);

return statearr_16736;
})();
if(inst_16652){
var statearr_16737_16778 = state_16717__$1;
(statearr_16737_16778[(1)] = (14));

} else {
var statearr_16738_16779 = state_16717__$1;
(statearr_16738_16779[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (2))){
var inst_16634 = (state_16717[(17)]);
var _ = (function (){var statearr_16739 = state_16717;
(statearr_16739[(4)] = cljs.core.cons((5),(state_16717[(4)])));

return statearr_16739;
})();
var inst_16634__$1 = depth;
var state_16717__$1 = (function (){var statearr_16740 = state_16717;
(statearr_16740[(17)] = inst_16634__$1);

return statearr_16740;
})();
if(cljs.core.truth_(inst_16634__$1)){
var statearr_16741_16780 = state_16717__$1;
(statearr_16741_16780[(1)] = (6));

} else {
var statearr_16742_16781 = state_16717__$1;
(statearr_16742_16781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (23))){
var inst_16705 = (state_16717[(9)]);
var state_16717__$1 = state_16717;
var statearr_16743_16782 = state_16717__$1;
(statearr_16743_16782[(2)] = inst_16705);

(statearr_16743_16782[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (19))){
var inst_16673 = (state_16717[(18)]);
var inst_16676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16677 = [inst_16673,predicate];
var inst_16678 = (new cljs.core.PersistentVector(null,2,(5),inst_16676,inst_16677,null));
var inst_16679 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16678);
var state_16717__$1 = state_16717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16717__$1,(22),inst_16679);
} else {
if((state_val_16718 === (11))){
var inst_16640 = (state_16717[(19)]);
var state_16717__$1 = state_16717;
var statearr_16745_16783 = state_16717__$1;
(statearr_16745_16783[(2)] = inst_16640);

(statearr_16745_16783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (9))){
var inst_16641 = (state_16717[(20)]);
var inst_16638 = (state_16717[(10)]);
var inst_16643 = (inst_16641 >= inst_16638);
var state_16717__$1 = state_16717;
if(cljs.core.truth_(inst_16643)){
var statearr_16746_16784 = state_16717__$1;
(statearr_16746_16784[(1)] = (11));

} else {
var statearr_16747_16785 = state_16717__$1;
(statearr_16747_16785[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (5))){
var _ = (function (){var statearr_16748 = state_16717;
(statearr_16748[(4)] = cljs.core.rest((state_16717[(4)])));

return statearr_16748;
})();
var state_16717__$1 = state_16717;
var ex16744 = (state_16717__$1[(2)]);
var statearr_16749_16786 = state_16717__$1;
(statearr_16749_16786[(5)] = ex16744);


if((ex16744 instanceof Error)){
var statearr_16750_16787 = state_16717__$1;
(statearr_16750_16787[(1)] = (4));

(statearr_16750_16787[(5)] = null);

} else {
throw ex16744;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (14))){
var inst_16640 = (state_16717[(19)]);
var state_16717__$1 = state_16717;
var statearr_16751_16788 = state_16717__$1;
(statearr_16751_16788[(2)] = inst_16640);

(statearr_16751_16788[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (16))){
var inst_16698 = (state_16717[(2)]);
var state_16717__$1 = state_16717;
var statearr_16752_16789 = state_16717__$1;
(statearr_16752_16789[(2)] = inst_16698);

(statearr_16752_16789[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (10))){
var inst_16703 = (state_16717[(8)]);
var inst_16704 = (state_16717[(11)]);
var inst_16702 = (state_16717[(2)]);
var inst_16703__$1 = cljs.core.keys(inst_16702);
var inst_16704__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_16703__$1,inst_16702);
var inst_16705 = fluree.db.query.analytical.recur_map__GT_tuples(inst_16703__$1,inst_16704__$1);
var state_16717__$1 = (function (){var statearr_16753 = state_16717;
(statearr_16753[(8)] = inst_16703__$1);

(statearr_16753[(9)] = inst_16705);

(statearr_16753[(11)] = inst_16704__$1);

return statearr_16753;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_16754_16790 = state_16717__$1;
(statearr_16754_16790[(1)] = (23));

} else {
var statearr_16755_16791 = state_16717__$1;
(statearr_16755_16791[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (18))){
var inst_16641 = (state_16717[(20)]);
var inst_16640 = (state_16717[(19)]);
var inst_16689 = (state_16717[(2)]);
var inst_16690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16691 = [(0),(2)];
var inst_16692 = (new cljs.core.PersistentVector(null,2,(5),inst_16690,inst_16691,null));
var inst_16693 = fluree.db.query.analytical.get_ns_arrays(inst_16692,inst_16689);
var inst_16694 = fluree.db.query.analytical.tuples__GT_map(inst_16640,inst_16693);
var inst_16695 = (inst_16641 + (1));
var inst_16640__$1 = inst_16694;
var inst_16641__$1 = inst_16695;
var state_16717__$1 = (function (){var statearr_16756 = state_16717;
(statearr_16756[(20)] = inst_16641__$1);

(statearr_16756[(19)] = inst_16640__$1);

return statearr_16756;
})();
var statearr_16757_16792 = state_16717__$1;
(statearr_16757_16792[(2)] = null);

(statearr_16757_16792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16718 === (8))){
var inst_16638 = (state_16717[(2)]);
var inst_16639 = recur_map;
var inst_16640 = inst_16639;
var inst_16641 = (1);
var state_16717__$1 = (function (){var statearr_16758 = state_16717;
(statearr_16758[(20)] = inst_16641);

(statearr_16758[(19)] = inst_16640);

(statearr_16758[(10)] = inst_16638);

return statearr_16758;
})();
var statearr_16759_16793 = state_16717__$1;
(statearr_16759_16793[(2)] = null);

(statearr_16759_16793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0 = (function (){
var statearr_16760 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16760[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__);

(statearr_16760[(1)] = (1));

return statearr_16760;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1 = (function (state_16717){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16717);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16761){var ex__2417__auto__ = e16761;
var statearr_16762_16794 = state_16717;
(statearr_16762_16794[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16717[(4)]))){
var statearr_16763_16795 = state_16717;
(statearr_16763_16795[(1)] = cljs.core.first((state_16717[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16796 = state_16717;
state_16717 = G__16796;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__ = function(state_16717){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1.call(this,state_16717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16764 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16764[(6)] = c__2436__auto__);

return statearr_16764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__16797,clause,fuel,max_fuel){
var map__16798 = p__16797;
var map__16798__$1 = (((((!((map__16798 == null))))?(((((map__16798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16798):map__16798);
var res = map__16798__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16798__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16798__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16798__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16930){
var state_val_16931 = (state_16930[(1)]);
if((state_val_16931 === (7))){
var state_16930__$1 = state_16930;
var statearr_16932_16998 = state_16930__$1;
(statearr_16932_16998[(2)] = false);

(statearr_16932_16998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (20))){
var inst_16862 = (state_16930[(7)]);
var state_16930__$1 = state_16930;
var statearr_16933_16999 = state_16930__$1;
(statearr_16933_16999[(2)] = inst_16862);

(statearr_16933_16999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (27))){
var inst_16866 = (state_16930[(8)]);
var inst_16890 = (state_16930[(2)]);
var state_16930__$1 = (function (){var statearr_16934 = state_16930;
(statearr_16934[(9)] = inst_16890);

return statearr_16934;
})();
if(cljs.core.truth_(inst_16866)){
var statearr_16935_17000 = state_16930__$1;
(statearr_16935_17000[(1)] = (28));

} else {
var statearr_16936_17001 = state_16930__$1;
(statearr_16936_17001[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (1))){
var state_16930__$1 = state_16930;
var statearr_16937_17002 = state_16930__$1;
(statearr_16937_17002[(2)] = null);

(statearr_16937_17002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (24))){
var inst_16878 = (state_16930[(2)]);
var inst_16879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_16880 = fluree.db.query.analytical.variable_QMARK_(inst_16879);
var state_16930__$1 = (function (){var statearr_16938 = state_16930;
(statearr_16938[(10)] = inst_16878);

return statearr_16938;
})();
if(cljs.core.truth_(inst_16880)){
var statearr_16939_17003 = state_16930__$1;
(statearr_16939_17003[(1)] = (25));

} else {
var statearr_16940_17004 = state_16930__$1;
(statearr_16940_17004[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (4))){
var inst_16800 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
var statearr_16941_17005 = state_16930__$1;
(statearr_16941_17005[(2)] = inst_16800);

(statearr_16941_17005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (15))){
var inst_16848 = (state_16930[(11)]);
var state_16930__$1 = state_16930;
var statearr_16942_17006 = state_16930__$1;
(statearr_16942_17006[(2)] = inst_16848);

(statearr_16942_17006[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (21))){
var inst_16833 = (state_16930[(12)]);
var inst_16921 = (state_16930[(2)]);
var inst_16922 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_16923 = cljs.core.keys(inst_16833);
var inst_16924 = [inst_16923,vars,inst_16921];
var inst_16925 = cljs.core.PersistentHashMap.fromArrays(inst_16922,inst_16924);
var _ = (function (){var statearr_16943 = state_16930;
(statearr_16943[(4)] = cljs.core.rest((state_16930[(4)])));

return statearr_16943;
})();
var state_16930__$1 = state_16930;
var statearr_16944_17007 = state_16930__$1;
(statearr_16944_17007[(2)] = inst_16925);

(statearr_16944_17007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (31))){
var inst_16862 = (state_16930[(7)]);
var inst_16864 = (state_16930[(13)]);
var inst_16897 = cljs.core.PersistentHashMap.EMPTY;
var inst_16898 = cljs.core.flatten(inst_16862);
var inst_16899 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_16897,inst_16864,inst_16898);
var state_16930__$1 = state_16930;
var statearr_16945_17008 = state_16930__$1;
(statearr_16945_17008[(2)] = inst_16899);

(statearr_16945_17008[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (32))){
var inst_16864 = (state_16930[(13)]);
var inst_16901 = cljs.core.coll_QMARK_(inst_16864);
var state_16930__$1 = state_16930;
if(inst_16901){
var statearr_16946_17009 = state_16930__$1;
(statearr_16946_17009[(1)] = (34));

} else {
var statearr_16947_17010 = state_16930__$1;
(statearr_16947_17010[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (33))){
var inst_16912 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
var statearr_16948_17011 = state_16930__$1;
(statearr_16948_17011[(2)] = inst_16912);

(statearr_16948_17011[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (13))){
var inst_16810 = (state_16930[(14)]);
var state_16930__$1 = state_16930;
var statearr_16949_17012 = state_16930__$1;
(statearr_16949_17012[(2)] = inst_16810);

(statearr_16949_17012[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (22))){
var inst_16846 = (state_16930[(15)]);
var inst_16870 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16846)].join('');
var inst_16871 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16872 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16873 = cljs.core.PersistentHashMap.fromArrays(inst_16871,inst_16872);
var inst_16874 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16870,inst_16873);
var inst_16875 = (function(){throw inst_16874})();
var state_16930__$1 = state_16930;
var statearr_16950_17013 = state_16930__$1;
(statearr_16950_17013[(2)] = inst_16875);

(statearr_16950_17013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (36))){
var inst_16910 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
var statearr_16951_17014 = state_16930__$1;
(statearr_16951_17014[(2)] = inst_16910);

(statearr_16951_17014[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (29))){
var inst_16864 = (state_16930[(13)]);
var inst_16895 = typeof inst_16864 === 'number';
var state_16930__$1 = state_16930;
if(cljs.core.truth_(inst_16895)){
var statearr_16952_17015 = state_16930__$1;
(statearr_16952_17015[(1)] = (31));

} else {
var statearr_16953_17016 = state_16930__$1;
(statearr_16953_17016[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (6))){
var inst_16810 = (state_16930[(14)]);
var inst_16815 = inst_16810.cljs$lang$protocol_mask$partition0$;
var inst_16816 = (inst_16815 & (64));
var inst_16817 = inst_16810.cljs$core$ISeq$;
var inst_16818 = (cljs.core.PROTOCOL_SENTINEL === inst_16817);
var inst_16819 = ((inst_16816) || (inst_16818));
var state_16930__$1 = state_16930;
if(cljs.core.truth_(inst_16819)){
var statearr_16954_17017 = state_16930__$1;
(statearr_16954_17017[(1)] = (9));

} else {
var statearr_16955_17018 = state_16930__$1;
(statearr_16955_17018[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (28))){
var inst_16862 = (state_16930[(7)]);
var inst_16892 = cljs.core.PersistentHashMap.EMPTY;
var inst_16893 = fluree.db.query.analytical.tuples__GT_map(inst_16892,inst_16862);
var state_16930__$1 = state_16930;
var statearr_16956_17019 = state_16930__$1;
(statearr_16956_17019[(2)] = inst_16893);

(statearr_16956_17019[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (25))){
var state_16930__$1 = state_16930;
var statearr_16957_17020 = state_16930__$1;
(statearr_16957_17020[(2)] = null);

(statearr_16957_17020[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (34))){
var inst_16862 = (state_16930[(7)]);
var inst_16858 = (state_16930[(16)]);
var inst_16903 = cljs.core.PersistentHashMap.EMPTY;
var inst_16904 = cljs.core.first(inst_16858);
var inst_16905 = cljs.core.first(inst_16904);
var inst_16906 = cljs.core.flatten(inst_16862);
var inst_16907 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_16903,inst_16905,inst_16906);
var state_16930__$1 = state_16930;
var statearr_16958_17021 = state_16930__$1;
(statearr_16958_17021[(2)] = inst_16907);

(statearr_16958_17021[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (17))){
var inst_16847 = (state_16930[(17)]);
var inst_16846 = (state_16930[(15)]);
var inst_16852 = (state_16930[(2)]);
var inst_16853 = [inst_16852];
var inst_16854 = cljs.core.PersistentHashMap.fromArrays(inst_16847,inst_16853);
var inst_16855 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_16846,inst_16854);
var state_16930__$1 = state_16930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16930__$1,(18),inst_16855);
} else {
if((state_val_16931 === (3))){
var inst_16928 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16930__$1,inst_16928);
} else {
if((state_val_16931 === (12))){
var inst_16810 = (state_16930[(14)]);
var inst_16828 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16810);
var state_16930__$1 = state_16930;
var statearr_16959_17022 = state_16930__$1;
(statearr_16959_17022[(2)] = inst_16828);

(statearr_16959_17022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (2))){
var inst_16810 = (state_16930[(14)]);
var _ = (function (){var statearr_16960 = state_16930;
(statearr_16960[(4)] = cljs.core.cons((5),(state_16930[(4)])));

return statearr_16960;
})();
var inst_16810__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_16812 = (inst_16810__$1 == null);
var inst_16813 = cljs.core.not(inst_16812);
var state_16930__$1 = (function (){var statearr_16961 = state_16930;
(statearr_16961[(14)] = inst_16810__$1);

return statearr_16961;
})();
if(inst_16813){
var statearr_16962_17023 = state_16930__$1;
(statearr_16962_17023[(1)] = (6));

} else {
var statearr_16963_17024 = state_16930__$1;
(statearr_16963_17024[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (23))){
var state_16930__$1 = state_16930;
var statearr_16964_17025 = state_16930__$1;
(statearr_16964_17025[(2)] = null);

(statearr_16964_17025[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (35))){
var state_16930__$1 = state_16930;
var statearr_16965_17026 = state_16930__$1;
(statearr_16965_17026[(2)] = null);

(statearr_16965_17026[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (19))){
var inst_16846 = (state_16930[(15)]);
var inst_16867 = (state_16930[(18)]);
var inst_16864 = cljs.core.first(inst_16846);
var inst_16865 = cljs.core.first(clause);
var inst_16866 = fluree.db.query.analytical.variable_QMARK_(inst_16865);
var inst_16867__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_16846,(1));
var inst_16868 = fluree.db.query.analytical.variable_QMARK_(inst_16867__$1);
var state_16930__$1 = (function (){var statearr_16966 = state_16930;
(statearr_16966[(8)] = inst_16866);

(statearr_16966[(13)] = inst_16864);

(statearr_16966[(18)] = inst_16867__$1);

return statearr_16966;
})();
if(cljs.core.truth_(inst_16868)){
var statearr_16967_17027 = state_16930__$1;
(statearr_16967_17027[(1)] = (22));

} else {
var statearr_16968_17028 = state_16930__$1;
(statearr_16968_17028[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (11))){
var inst_16823 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
var statearr_16970_17029 = state_16930__$1;
(statearr_16970_17029[(2)] = inst_16823);

(statearr_16970_17029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (9))){
var state_16930__$1 = state_16930;
var statearr_16971_17030 = state_16930__$1;
(statearr_16971_17030[(2)] = true);

(statearr_16971_17030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (5))){
var _ = (function (){var statearr_16972 = state_16930;
(statearr_16972[(4)] = cljs.core.rest((state_16930[(4)])));

return statearr_16972;
})();
var state_16930__$1 = state_16930;
var ex16969 = (state_16930__$1[(2)]);
var statearr_16973_17031 = state_16930__$1;
(statearr_16973_17031[(5)] = ex16969);


if((ex16969 instanceof Error)){
var statearr_16974_17032 = state_16930__$1;
(statearr_16974_17032[(1)] = (4));

(statearr_16974_17032[(5)] = null);

} else {
throw ex16969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (14))){
var inst_16833 = (state_16930[(12)]);
var inst_16848 = (state_16930[(11)]);
var inst_16836 = (state_16930[(19)]);
var inst_16837 = (state_16930[(20)]);
var inst_16831 = (state_16930[(2)]);
var inst_16832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16831,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_16833__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16831,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_16834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16831,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_16835 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_16836__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_16834);
var inst_16837__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_16834);
var inst_16839 = (function (){var map__16806 = inst_16831;
var search = inst_16832;
var rel = inst_16833__$1;
var opts = inst_16834;
var common_keys = inst_16835;
var object_fn = inst_16836__$1;
var recur_depth = inst_16837__$1;
return (function (p__16838,common_key){
var vec__16975 = p__16838;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16975,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16975,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__16978 = cljs.core._EQ_;
var expr__16979 = idx_of;
if(cljs.core.truth_((pred__16978.cljs$core$IFn$_invoke$arity$2 ? pred__16978.cljs$core$IFn$_invoke$arity$2((0),expr__16979) : pred__16978.call(null,(0),expr__16979)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__16978.cljs$core$IFn$_invoke$arity$2 ? pred__16978.cljs$core$IFn$_invoke$arity$2((1),expr__16979) : pred__16978.call(null,(1),expr__16979)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__16978.cljs$core$IFn$_invoke$arity$2 ? pred__16978.cljs$core$IFn$_invoke$arity$2((2),expr__16979) : pred__16978.call(null,(2),expr__16979)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__16979)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_16840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16841 = cljs.core.PersistentHashMap.EMPTY;
var inst_16842 = [inst_16841,inst_16832];
var inst_16843 = (new cljs.core.PersistentVector(null,2,(5),inst_16840,inst_16842,null));
var inst_16844 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16839,inst_16843,inst_16835);
var inst_16845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16844,(0),null);
var inst_16846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16844,(1),null);
var inst_16847 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_16848__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_16845);
var state_16930__$1 = (function (){var statearr_16981 = state_16930;
(statearr_16981[(17)] = inst_16847);

(statearr_16981[(15)] = inst_16846);

(statearr_16981[(12)] = inst_16833__$1);

(statearr_16981[(11)] = inst_16848__$1);

(statearr_16981[(19)] = inst_16836__$1);

(statearr_16981[(20)] = inst_16837__$1);

return statearr_16981;
})();
if(cljs.core.truth_(inst_16848__$1)){
var statearr_16982_17033 = state_16930__$1;
(statearr_16982_17033[(1)] = (15));

} else {
var statearr_16983_17034 = state_16930__$1;
(statearr_16983_17034[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (26))){
var inst_16846 = (state_16930[(15)]);
var inst_16883 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16846)].join('');
var inst_16884 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16885 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16886 = cljs.core.PersistentHashMap.fromArrays(inst_16884,inst_16885);
var inst_16887 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16883,inst_16886);
var inst_16888 = (function(){throw inst_16887})();
var state_16930__$1 = state_16930;
var statearr_16984_17035 = state_16930__$1;
(statearr_16984_17035[(2)] = inst_16888);

(statearr_16984_17035[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (16))){
var inst_16836 = (state_16930[(19)]);
var state_16930__$1 = state_16930;
var statearr_16985_17036 = state_16930__$1;
(statearr_16985_17036[(2)] = inst_16836);

(statearr_16985_17036[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (30))){
var inst_16866 = (state_16930[(8)]);
var inst_16867 = (state_16930[(18)]);
var inst_16837 = (state_16930[(20)]);
var inst_16914 = (state_16930[(2)]);
var inst_16915 = fluree.db.query.analytical.tuples__GT_recur(db,inst_16867,inst_16914,inst_16837,inst_16866);
var state_16930__$1 = state_16930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16930__$1,(37),inst_16915);
} else {
if((state_val_16931 === (10))){
var state_16930__$1 = state_16930;
var statearr_16986_17037 = state_16930__$1;
(statearr_16986_17037[(2)] = false);

(statearr_16986_17037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (18))){
var inst_16858 = (state_16930[(16)]);
var inst_16833 = (state_16930[(12)]);
var inst_16837 = (state_16930[(20)]);
var inst_16857 = (state_16930[(2)]);
var inst_16858__$1 = fluree.db.util.async.throw_err(inst_16857);
var inst_16859 = cljs.core.count(inst_16858__$1);
var inst_16860 = fluree.db.query.analytical.add_fuel(inst_16859,fuel,max_fuel);
var inst_16861 = cljs.core.vals(inst_16833);
var inst_16862 = fluree.db.query.analytical.get_ns_arrays(inst_16861,inst_16858__$1);
var state_16930__$1 = (function (){var statearr_16987 = state_16930;
(statearr_16987[(7)] = inst_16862);

(statearr_16987[(21)] = inst_16860);

(statearr_16987[(16)] = inst_16858__$1);

return statearr_16987;
})();
if(cljs.core.truth_(inst_16837)){
var statearr_16988_17038 = state_16930__$1;
(statearr_16988_17038[(1)] = (19));

} else {
var statearr_16989_17039 = state_16930__$1;
(statearr_16989_17039[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (37))){
var inst_16917 = (state_16930[(2)]);
var inst_16918 = fluree.db.util.async.throw_err(inst_16917);
var state_16930__$1 = state_16930;
var statearr_16990_17040 = state_16930__$1;
(statearr_16990_17040[(2)] = inst_16918);

(statearr_16990_17040[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16931 === (8))){
var inst_16826 = (state_16930[(2)]);
var state_16930__$1 = state_16930;
if(cljs.core.truth_(inst_16826)){
var statearr_16991_17041 = state_16930__$1;
(statearr_16991_17041[(1)] = (12));

} else {
var statearr_16992_17042 = state_16930__$1;
(statearr_16992_17042[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_16993 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16993[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__);

(statearr_16993[(1)] = (1));

return statearr_16993;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1 = (function (state_16930){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16930);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16994){var ex__2417__auto__ = e16994;
var statearr_16995_17043 = state_16930;
(statearr_16995_17043[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16930[(4)]))){
var statearr_16996_17044 = state_16930;
(statearr_16996_17044[(1)] = cljs.core.first((state_16930[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17045 = state_16930;
state_16930 = G__17045;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__ = function(state_16930){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1.call(this,state_16930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16997 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16997[(6)] = c__2436__auto__);

return statearr_16997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__17046,res,clause){
var map__17047 = p__17046;
var map__17047__$1 = (((((!((map__17047 == null))))?(((((map__17047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17047):map__17047);
var db = map__17047__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17047__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17047__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17047__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17147){
var state_val_17148 = (state_17147[(1)]);
if((state_val_17148 === (7))){
var inst_17058 = (state_17147[(7)]);
var state_17147__$1 = state_17147;
var statearr_17149_17189 = state_17147__$1;
(statearr_17149_17189[(2)] = inst_17058);

(statearr_17149_17189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (20))){
var inst_17138 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
var statearr_17150_17190 = state_17147__$1;
(statearr_17150_17190[(2)] = inst_17138);

(statearr_17150_17190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (1))){
var state_17147__$1 = state_17147;
var statearr_17151_17191 = state_17147__$1;
(statearr_17151_17191[(2)] = null);

(statearr_17151_17191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (24))){
var inst_17117 = (state_17147[(2)]);
var inst_17118 = fluree.db.util.async.throw_err(inst_17117);
var state_17147__$1 = state_17147;
var statearr_17152_17192 = state_17147__$1;
(statearr_17152_17192[(2)] = inst_17118);

(statearr_17152_17192[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (4))){
var inst_17051 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
var statearr_17153_17193 = state_17147__$1;
(statearr_17153_17193[(2)] = inst_17051);

(statearr_17153_17193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (15))){
var inst_17058 = (state_17147[(7)]);
var inst_17060 = (state_17147[(8)]);
var inst_17079 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17080 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17082 = [inst_17058];
var inst_17083 = (new cljs.core.PersistentVector(null,1,(5),inst_17081,inst_17082,null));
var inst_17084 = (function (){var subject_var = inst_17058;
var object_var = inst_17060;
var min_sid = inst_17079;
var max_sid = (0);
return (function (p1__17049_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17049_SHARP_);
});
})();
var inst_17085 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_17079,(0));
var inst_17086 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17084,inst_17085);
var inst_17087 = cljs.core.PersistentHashMap.EMPTY;
var inst_17088 = [inst_17083,inst_17086,inst_17087];
var inst_17089 = cljs.core.PersistentHashMap.fromArrays(inst_17080,inst_17088);
var state_17147__$1 = state_17147;
var statearr_17154_17194 = state_17147__$1;
(statearr_17154_17194[(2)] = inst_17089);

(statearr_17154_17194[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (21))){
var inst_17111 = (state_17147[(9)]);
var state_17147__$1 = state_17147;
var statearr_17155_17195 = state_17147__$1;
(statearr_17155_17195[(2)] = inst_17111);

(statearr_17155_17195[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (13))){
var inst_17060 = (state_17147[(8)]);
var state_17147__$1 = state_17147;
if(cljs.core.truth_(inst_17060)){
var statearr_17156_17196 = state_17147__$1;
(statearr_17156_17196[(1)] = (18));

} else {
var statearr_17157_17197 = state_17147__$1;
(statearr_17157_17197[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (22))){
var inst_17111 = (state_17147[(9)]);
var inst_17115 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_17111);
var state_17147__$1 = state_17147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17147__$1,(24),inst_17115);
} else {
if((state_val_17148 === (6))){
var inst_17060 = (state_17147[(8)]);
var state_17147__$1 = state_17147;
var statearr_17158_17198 = state_17147__$1;
(statearr_17158_17198[(2)] = inst_17060);

(statearr_17158_17198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (17))){
var inst_17108 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
var statearr_17159_17199 = state_17147__$1;
(statearr_17159_17199[(2)] = inst_17108);

(statearr_17159_17199[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (3))){
var inst_17145 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17147__$1,inst_17145);
} else {
if((state_val_17148 === (12))){
var inst_17073 = ["_tx",null,"_block",null];
var inst_17074 = (new cljs.core.PersistentArrayMap(null,2,inst_17073,null));
var inst_17075 = (new cljs.core.PersistentHashSet(null,inst_17074,null));
var inst_17076 = cljs.core.last(clause);
var inst_17077 = (inst_17075.cljs$core$IFn$_invoke$arity$1 ? inst_17075.cljs$core$IFn$_invoke$arity$1(inst_17076) : inst_17075.call(null,inst_17076));
var state_17147__$1 = state_17147;
if(cljs.core.truth_(inst_17077)){
var statearr_17160_17200 = state_17147__$1;
(statearr_17160_17200[(1)] = (15));

} else {
var statearr_17161_17201 = state_17147__$1;
(statearr_17161_17201[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (2))){
var inst_17058 = (state_17147[(7)]);
var _ = (function (){var statearr_17162 = state_17147;
(statearr_17162[(4)] = cljs.core.cons((5),(state_17147[(4)])));

return statearr_17162;
})();
var inst_17057 = cljs.core.first(clause);
var inst_17058__$1 = fluree.db.query.analytical.variable_QMARK_(inst_17057);
var inst_17059 = cljs.core.last(clause);
var inst_17060 = fluree.db.query.analytical.variable_QMARK_(inst_17059);
var state_17147__$1 = (function (){var statearr_17163 = state_17147;
(statearr_17163[(7)] = inst_17058__$1);

(statearr_17163[(8)] = inst_17060);

return statearr_17163;
})();
if(cljs.core.truth_(inst_17058__$1)){
var statearr_17164_17202 = state_17147__$1;
(statearr_17164_17202[(1)] = (6));

} else {
var statearr_17165_17203 = state_17147__$1;
(statearr_17165_17203[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (23))){
var inst_17060 = (state_17147[(8)]);
var inst_17120 = (state_17147[(2)]);
var inst_17121 = fluree.db.flake.sid__GT_cid(inst_17120);
var inst_17122 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_17121);
var inst_17123 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17125 = [inst_17060];
var inst_17126 = (new cljs.core.PersistentVector(null,1,(5),inst_17124,inst_17125,null));
var inst_17127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17129 = [inst_17122];
var inst_17130 = (new cljs.core.PersistentVector(null,1,(5),inst_17128,inst_17129,null));
var inst_17131 = [inst_17130];
var inst_17132 = (new cljs.core.PersistentVector(null,1,(5),inst_17127,inst_17131,null));
var inst_17133 = cljs.core.PersistentHashMap.EMPTY;
var inst_17134 = [inst_17126,inst_17132,inst_17133];
var inst_17135 = cljs.core.PersistentHashMap.fromArrays(inst_17123,inst_17134);
var state_17147__$1 = state_17147;
var statearr_17166_17204 = state_17147__$1;
(statearr_17166_17204[(2)] = inst_17135);

(statearr_17166_17204[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (19))){
var state_17147__$1 = state_17147;
var statearr_17167_17205 = state_17147__$1;
(statearr_17167_17205[(2)] = null);

(statearr_17167_17205[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (11))){
var inst_17142 = (state_17147[(2)]);
var _ = (function (){var statearr_17169 = state_17147;
(statearr_17169[(4)] = cljs.core.rest((state_17147[(4)])));

return statearr_17169;
})();
var state_17147__$1 = state_17147;
var statearr_17170_17206 = state_17147__$1;
(statearr_17170_17206[(2)] = inst_17142);

(statearr_17170_17206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (9))){
var inst_17066 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17067 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17068 = cljs.core.PersistentHashMap.fromArrays(inst_17066,inst_17067);
var inst_17069 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_17068);
var inst_17070 = (function(){throw inst_17069})();
var state_17147__$1 = state_17147;
var statearr_17171_17207 = state_17147__$1;
(statearr_17171_17207[(2)] = inst_17070);

(statearr_17171_17207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (5))){
var _ = (function (){var statearr_17172 = state_17147;
(statearr_17172[(4)] = cljs.core.rest((state_17147[(4)])));

return statearr_17172;
})();
var state_17147__$1 = state_17147;
var ex17168 = (state_17147__$1[(2)]);
var statearr_17173_17208 = state_17147__$1;
(statearr_17173_17208[(5)] = ex17168);


if((ex17168 instanceof Error)){
var statearr_17174_17209 = state_17147__$1;
(statearr_17174_17209[(1)] = (4));

(statearr_17174_17209[(5)] = null);

} else {
throw ex17168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (14))){
var inst_17140 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
var statearr_17175_17210 = state_17147__$1;
(statearr_17175_17210[(2)] = inst_17140);

(statearr_17175_17210[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (16))){
var inst_17058 = (state_17147[(7)]);
var inst_17060 = (state_17147[(8)]);
var inst_17091 = cljs.core.last(clause);
var inst_17092 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_17091);
var inst_17093 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_17094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17093,inst_17092);
var inst_17095 = fluree.db.flake.min_subject_id(inst_17092);
var inst_17096 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17098 = [inst_17058];
var inst_17099 = (new cljs.core.PersistentVector(null,1,(5),inst_17097,inst_17098,null));
var inst_17100 = (function (){var subject_var = inst_17058;
var object_var = inst_17060;
var cid = inst_17092;
var max_sid = inst_17094;
var min_sid = inst_17095;
return (function (p1__17050_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17050_SHARP_);
});
})();
var inst_17101 = (inst_17094 + (1));
var inst_17102 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_17095,inst_17101);
var inst_17103 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17100,inst_17102);
var inst_17104 = cljs.core.PersistentHashMap.EMPTY;
var inst_17105 = [inst_17099,inst_17103,inst_17104];
var inst_17106 = cljs.core.PersistentHashMap.fromArrays(inst_17096,inst_17105);
var state_17147__$1 = state_17147;
var statearr_17176_17211 = state_17147__$1;
(statearr_17176_17211[(2)] = inst_17106);

(statearr_17176_17211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (10))){
var inst_17058 = (state_17147[(7)]);
var state_17147__$1 = state_17147;
if(cljs.core.truth_(inst_17058)){
var statearr_17177_17212 = state_17147__$1;
(statearr_17177_17212[(1)] = (12));

} else {
var statearr_17178_17213 = state_17147__$1;
(statearr_17178_17213[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (18))){
var inst_17111 = (state_17147[(9)]);
var inst_17111__$1 = cljs.core.first(clause);
var inst_17112 = typeof inst_17111__$1 === 'number';
var state_17147__$1 = (function (){var statearr_17179 = state_17147;
(statearr_17179[(9)] = inst_17111__$1);

return statearr_17179;
})();
if(cljs.core.truth_(inst_17112)){
var statearr_17180_17214 = state_17147__$1;
(statearr_17180_17214[(1)] = (21));

} else {
var statearr_17181_17215 = state_17147__$1;
(statearr_17181_17215[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17148 === (8))){
var inst_17064 = (state_17147[(2)]);
var state_17147__$1 = state_17147;
if(cljs.core.truth_(inst_17064)){
var statearr_17182_17216 = state_17147__$1;
(statearr_17182_17216[(1)] = (9));

} else {
var statearr_17183_17217 = state_17147__$1;
(statearr_17183_17217[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_17184 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17184[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__);

(statearr_17184[(1)] = (1));

return statearr_17184;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1 = (function (state_17147){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17147);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17185){var ex__2417__auto__ = e17185;
var statearr_17186_17218 = state_17147;
(statearr_17186_17218[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17147[(4)]))){
var statearr_17187_17219 = state_17147;
(statearr_17187_17219[(1)] = cljs.core.first((state_17147[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17220 = state_17147;
state_17147 = G__17220;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__ = function(state_17147){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1.call(this,state_17147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17188 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17188[(6)] = c__2436__auto__);

return statearr_17188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__17227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__17227 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__17227;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__17228(s__17229){
return (new cljs.core.LazySeq(null,(function (){
var s__17229__$1 = s__17229;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__17229__$1);
if(temp__5735__auto__){
var s__17229__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17229__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__17229__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__17231 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__17230 = (0);
while(true){
if((i__17230 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__17230);
var delta = (x - mean);
cljs.core.chunk_append(b__17231,(delta * delta));

var G__17233 = (i__17230 + (1));
i__17230 = G__17233;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17231),fluree$db$query$analytical$variance_$_iter__17228(cljs.core.chunk_rest(s__17229__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17231),null);
}
} else {
var x = cljs.core.first(s__17229__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__17228(cljs.core.rest(s__17229__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__17232 = variance(coll);
return Math.sqrt(G__17232);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__17234 = null;
var G__17234__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17234__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17234 = function(n,coll){
switch(arguments.length){
case 1:
return G__17234__1.call(this,n);
case 2:
return G__17234__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17234.cljs$core$IFn$_invoke$arity$1 = G__17234__1;
G__17234.cljs$core$IFn$_invoke$arity$2 = G__17234__2;
return G__17234;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17235 = null;
var G__17235__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17235__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17235 = function(n,coll){
switch(arguments.length){
case 1:
return G__17235__1.call(this,n);
case 2:
return G__17235__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17235.cljs$core$IFn$_invoke$arity$1 = G__17235__1;
G__17235.cljs$core$IFn$_invoke$arity$2 = G__17235__2;
return G__17235;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17236 = null;
var G__17236__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__17236__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__17236 = function(n,coll){
switch(arguments.length){
case 1:
return G__17236__1.call(this,n);
case 2:
return G__17236__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17236.cljs$core$IFn$_invoke$arity$1 = G__17236__1;
G__17236.cljs$core$IFn$_invoke$arity$2 = G__17236__2;
return G__17236;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__17237 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17237,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17237,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17237,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17240 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__17243 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__17243) : agg_fn.call(null,G__17243));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17240,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17240,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__17244 = agg;
var map__17244__$1 = (((((!((map__17244 == null))))?(((((map__17244.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17244.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17244):map__17244);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17244__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17244__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17244__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__17247 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17247,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17247,(1),null);
var map__17250 = res__$1;
var map__17250__$1 = (((((!((map__17250 == null))))?(((((map__17250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17250):map__17250);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17250__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17250__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17246_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__17246_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17252_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__17252_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17253_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17253_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17254_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17254_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17255_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__17255_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__17258,row,b_tuple){
var vec__17259 = p__17258;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17259,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17259,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17256_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17256_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17257_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__17257_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17262_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__17262_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17263_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17263_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17268 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17270 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__17269 = (function (p1__17264_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17264_SHARP_);
});
return fexpr__17269(G__17270);
})()),cljs.core.set(b_idxs));
var fexpr__17267 = (function (p1__17265_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17265_SHARP_);
});
return fexpr__17267(G__17268);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17266_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17266_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17271_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17271_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17272_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17272_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17277 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17279 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__17278 = (function (p1__17273_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17273_SHARP_);
});
return fexpr__17278(G__17279);
})()),cljs.core.set(b_idxs));
var fexpr__17276 = (function (p1__17274_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17274_SHARP_);
});
return fexpr__17276(G__17277);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17275_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17275_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17280_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17280_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17281_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17281_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__17290 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__17292 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__17291 = (function (p1__17282_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__17282_SHARP_);
});
return fexpr__17291(G__17292);
})()),cljs.core.set(b_idxs));
var fexpr__17289 = (function (p1__17283_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__17283_SHARP_);
});
return fexpr__17289(G__17290);
})();
var vec__17286 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__17293,a_tuple){
var vec__17294 = p__17293;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17294,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17294,(1),null);
var vec__17297 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17297,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17297,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17286,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17286,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17284_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17284_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17285_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17285_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__17301 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17301,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17301,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__17300_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__17300_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__17306 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17306,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17306,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17304_SHARP_){
return fluree.db.util.core.index_of(headers,p1__17304_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__17305_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__17305_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__17309,filters,optional_QMARK_){
var map__17310 = p__17309;
var map__17310__$1 = (((((!((map__17310 == null))))?(((((map__17310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17310):map__17310);
var tuple_map = map__17310__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17310__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17310__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17310__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__17312 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17312,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17312,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__17315 = res;
var map__17315__$1 = (((((!((map__17315 == null))))?(((((map__17315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17315):map__17315);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17315__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17315__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (7))){
var inst_17346 = (state_17372[(7)]);
var inst_17344 = (state_17372[(2)]);
var inst_17345 = fluree.db.util.async.throw_err(inst_17344);
var inst_17346__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17345,(0),null);
var inst_17347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17345,(1),null);
var inst_17348 = (inst_17346__$1 == null);
var state_17372__$1 = (function (){var statearr_17374 = state_17372;
(statearr_17374[(7)] = inst_17346__$1);

(statearr_17374[(8)] = inst_17347);

return statearr_17374;
})();
if(cljs.core.truth_(inst_17348)){
var statearr_17375_17404 = state_17372__$1;
(statearr_17375_17404[(1)] = (8));

} else {
var statearr_17376_17405 = state_17372__$1;
(statearr_17376_17405[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (1))){
var inst_17324 = optional_clauses;
var inst_17325 = cljs.core.seq(inst_17324);
var inst_17326 = cljs.core.first(inst_17325);
var inst_17327 = cljs.core.next(inst_17325);
var inst_17328 = where_tuples;
var inst_17329 = inst_17324;
var inst_17330 = inst_17328;
var state_17372__$1 = (function (){var statearr_17377 = state_17372;
(statearr_17377[(9)] = inst_17329);

(statearr_17377[(10)] = inst_17327);

(statearr_17377[(11)] = inst_17326);

(statearr_17377[(12)] = inst_17330);

return statearr_17377;
})();
var statearr_17378_17406 = state_17372__$1;
(statearr_17378_17406[(2)] = null);

(statearr_17378_17406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (4))){
var inst_17336 = (state_17372[(13)]);
var inst_17337 = (state_17372[(14)]);
var inst_17330 = (state_17372[(12)]);
var inst_17342 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_17330,inst_17336,inst_17337,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_17330,inst_17336,inst_17337,true,fuel,max_fuel,opts));
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17372__$1,(7),inst_17342);
} else {
if((state_val_17373 === (15))){
var state_17372__$1 = state_17372;
var statearr_17379_17407 = state_17372__$1;
(statearr_17379_17407[(2)] = null);

(statearr_17379_17407[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (13))){
var inst_17363 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17380_17408 = state_17372__$1;
(statearr_17380_17408[(2)] = inst_17363);

(statearr_17380_17408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var inst_17368 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17381_17409 = state_17372__$1;
(statearr_17381_17409[(2)] = inst_17368);

(statearr_17381_17409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (3))){
var inst_17370 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (12))){
var state_17372__$1 = state_17372;
var statearr_17382_17410 = state_17372__$1;
(statearr_17382_17410[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (2))){
var inst_17329 = (state_17372[(9)]);
var inst_17336 = (state_17372[(13)]);
var inst_17335 = cljs.core.seq(inst_17329);
var inst_17336__$1 = cljs.core.first(inst_17335);
var inst_17337 = cljs.core.next(inst_17335);
var state_17372__$1 = (function (){var statearr_17384 = state_17372;
(statearr_17384[(13)] = inst_17336__$1);

(statearr_17384[(14)] = inst_17337);

return statearr_17384;
})();
if(cljs.core.truth_(inst_17336__$1)){
var statearr_17385_17411 = state_17372__$1;
(statearr_17385_17411[(1)] = (4));

} else {
var statearr_17386_17412 = state_17372__$1;
(statearr_17386_17412[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (11))){
var inst_17346 = (state_17372[(7)]);
var inst_17347 = (state_17372[(8)]);
var inst_17329 = inst_17347;
var inst_17330 = inst_17346;
var state_17372__$1 = (function (){var statearr_17387 = state_17372;
(statearr_17387[(9)] = inst_17329);

(statearr_17387[(12)] = inst_17330);

return statearr_17387;
})();
var statearr_17388_17413 = state_17372__$1;
(statearr_17388_17413[(2)] = null);

(statearr_17388_17413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (9))){
var inst_17336 = (state_17372[(13)]);
var inst_17352 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_17336);
var state_17372__$1 = state_17372;
if(cljs.core.truth_(inst_17352)){
var statearr_17389_17414 = state_17372__$1;
(statearr_17389_17414[(1)] = (11));

} else {
var statearr_17390_17415 = state_17372__$1;
(statearr_17390_17415[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (5))){
var inst_17330 = (state_17372[(12)]);
var state_17372__$1 = state_17372;
var statearr_17391_17416 = state_17372__$1;
(statearr_17391_17416[(2)] = inst_17330);

(statearr_17391_17416[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (14))){
var inst_17330 = (state_17372[(12)]);
var inst_17346 = (state_17372[(7)]);
var inst_17347 = (state_17372[(8)]);
var inst_17357 = fluree.db.query.analytical.left_outer_join(inst_17330,inst_17346);
var inst_17329 = inst_17347;
var inst_17330__$1 = inst_17357;
var state_17372__$1 = (function (){var statearr_17392 = state_17372;
(statearr_17392[(9)] = inst_17329);

(statearr_17392[(12)] = inst_17330__$1);

return statearr_17392;
})();
var statearr_17393_17417 = state_17372__$1;
(statearr_17393_17417[(2)] = null);

(statearr_17393_17417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (16))){
var inst_17361 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17395_17418 = state_17372__$1;
(statearr_17395_17418[(2)] = inst_17361);

(statearr_17395_17418[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (10))){
var inst_17365 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17396_17419 = state_17372__$1;
(statearr_17396_17419[(2)] = inst_17365);

(statearr_17396_17419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (8))){
var inst_17330 = (state_17372[(12)]);
var inst_17347 = (state_17372[(8)]);
var tmp17394 = inst_17330;
var inst_17329 = inst_17347;
var inst_17330__$1 = tmp17394;
var state_17372__$1 = (function (){var statearr_17397 = state_17372;
(statearr_17397[(9)] = inst_17329);

(statearr_17397[(12)] = inst_17330__$1);

return statearr_17397;
})();
var statearr_17398_17420 = state_17372__$1;
(statearr_17398_17420[(2)] = null);

(statearr_17398_17420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0 = (function (){
var statearr_17399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17399[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__);

(statearr_17399[(1)] = (1));

return statearr_17399;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1 = (function (state_17372){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17372);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17400){var ex__2417__auto__ = e17400;
var statearr_17401_17421 = state_17372;
(statearr_17401_17421[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17372[(4)]))){
var statearr_17402_17422 = state_17372;
(statearr_17402_17422[(1)] = cljs.core.first((state_17372[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17423 = state_17372;
state_17372 = G__17423;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17403 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17403[(6)] = c__2436__auto__);

return statearr_17403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__17425){
var vec__17426 = p__17425;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17426,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17426,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17424_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17424_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__17430,p__17431,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__17432 = p__17430;
var map__17432__$1 = (((((!((map__17432 == null))))?(((((map__17432.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17432.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17432):map__17432);
var q_map = map__17432__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17432__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__17433 = p__17431;
var map__17433__$1 = (((((!((map__17433 == null))))?(((((map__17433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17433.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17433):map__17433);
var res = map__17433__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17433__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17642){
var state_val_17643 = (state_17642[(1)]);
if((state_val_17643 === (7))){
var inst_17540 = cljs.core.count(clause);
var inst_17541 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_17540);
var inst_17542 = cljs.core.second(clause);
var inst_17543 = clojure.string.starts_with_QMARK_(inst_17542,"fullText:");
var inst_17544 = ((inst_17541) && (inst_17543));
var state_17642__$1 = state_17642;
if(cljs.core.truth_(inst_17544)){
var statearr_17644_17739 = state_17642__$1;
(statearr_17644_17739[(1)] = (31));

} else {
var statearr_17645_17740 = state_17642__$1;
(statearr_17645_17740[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (59))){
var inst_17611 = (state_17642[(7)]);
var inst_17614 = (state_17642[(2)]);
var inst_17615 = fluree.db.util.async.throw_err(inst_17614);
var inst_17616 = [inst_17615,r];
var inst_17617 = (new cljs.core.PersistentVector(null,2,(5),inst_17611,inst_17616,null));
var state_17642__$1 = state_17642;
var statearr_17646_17741 = state_17642__$1;
(statearr_17646_17741[(2)] = inst_17617);

(statearr_17646_17741[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (20))){
var inst_17504 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17647_17742 = state_17642__$1;
(statearr_17647_17742[(2)] = inst_17504);

(statearr_17647_17742[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (58))){
var inst_17620 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17648_17743 = state_17642__$1;
(statearr_17648_17743[(2)] = inst_17620);

(statearr_17648_17743[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (27))){
var inst_17534 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17649_17744 = state_17642__$1;
(statearr_17649_17744[(2)] = inst_17534);

(statearr_17649_17744[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (1))){
var state_17642__$1 = state_17642;
var statearr_17650_17745 = state_17642__$1;
(statearr_17650_17745[(2)] = null);

(statearr_17650_17745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (24))){
var inst_17498 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17651_17746 = state_17642__$1;
(statearr_17651_17746[(2)] = inst_17498);

(statearr_17651_17746[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (55))){
var inst_17622 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17652_17747 = state_17642__$1;
(statearr_17652_17747[(2)] = inst_17622);

(statearr_17652_17747[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (39))){
var inst_17576 = cljs.core.count(clause);
var inst_17577 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_17576);
var state_17642__$1 = state_17642;
if(inst_17577){
var statearr_17653_17748 = state_17642__$1;
(statearr_17653_17748[(1)] = (42));

} else {
var statearr_17654_17749 = state_17642__$1;
(statearr_17654_17749[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (46))){
var state_17642__$1 = state_17642;
var statearr_17655_17750 = state_17642__$1;
(statearr_17655_17750[(2)] = null);

(statearr_17655_17750[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (4))){
var inst_17436 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17656_17751 = state_17642__$1;
(statearr_17656_17751[(2)] = inst_17436);

(statearr_17656_17751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (54))){
var state_17642__$1 = state_17642;
var statearr_17657_17752 = state_17642__$1;
(statearr_17657_17752[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (15))){
var inst_17536 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17659_17753 = state_17642__$1;
(statearr_17659_17753[(2)] = inst_17536);

(statearr_17659_17753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (48))){
var inst_17593 = (state_17642[(8)]);
var inst_17591 = (state_17642[(2)]);
var inst_17592 = fluree.db.util.async.throw_err(inst_17591);
var inst_17593__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17592,(0),null);
var inst_17594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17592,(1),null);
var inst_17595 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_17593__$1);
var state_17642__$1 = (function (){var statearr_17660 = state_17642;
(statearr_17660[(8)] = inst_17593__$1);

(statearr_17660[(9)] = inst_17594);

return statearr_17660;
})();
if(inst_17595){
var statearr_17661_17754 = state_17642__$1;
(statearr_17661_17754[(1)] = (49));

} else {
var statearr_17662_17755 = state_17642__$1;
(statearr_17662_17755[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (50))){
var inst_17594 = (state_17642[(9)]);
var inst_17602 = cljs.core.second(inst_17594);
var inst_17603 = clojure.string.starts_with_QMARK_(inst_17602,"fullText:");
var state_17642__$1 = state_17642;
if(inst_17603){
var statearr_17663_17756 = state_17642__$1;
(statearr_17663_17756[(1)] = (53));

} else {
var statearr_17664_17757 = state_17642__$1;
(statearr_17664_17757[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (21))){
var inst_17481 = (state_17642[(10)]);
var inst_17470 = (state_17642[(11)]);
var inst_17473 = (state_17642[(12)]);
var inst_17472 = (state_17642[(13)]);
var inst_17445 = (state_17642[(14)]);
var inst_17482 = (state_17642[(15)]);
var inst_17474 = (state_17642[(16)]);
var inst_17475 = (state_17642[(17)]);
var inst_17449 = (state_17642[(18)]);
var inst_17486 = (state_17642[(2)]);
var inst_17487 = fluree.db.util.async.throw_err(inst_17486);
var inst_17488 = (function (){var vec__17477 = inst_17474;
var expr__17447 = inst_17445;
var new_res = inst_17487;
var rest = inst_17482;
var pred__17446 = inst_17449;
var tuples = inst_17475;
var first__17469 = inst_17472;
var first__17479 = inst_17481;
var seq__17468 = inst_17473;
var vec__17467 = inst_17470;
var segment_type = inst_17445;
var G__17466 = inst_17474;
var clause_group = inst_17481;
var seq__17478 = inst_17482;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_17489 = cljs.core.keys(vars);
var inst_17490 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17488,inst_17487,inst_17489);
var inst_17491 = fluree.db.query.analytical.res_absorb_vars(inst_17490);
var state_17642__$1 = (function (){var statearr_17665 = state_17642;
(statearr_17665[(19)] = inst_17491);

return statearr_17665;
})();
if(cljs.core.truth_(inst_17475)){
var statearr_17666_17758 = state_17642__$1;
(statearr_17666_17758[(1)] = (22));

} else {
var statearr_17667_17759 = state_17642__$1;
(statearr_17667_17759[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (31))){
var inst_17546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17547 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_17548 = [inst_17547,r];
var inst_17549 = (new cljs.core.PersistentVector(null,2,(5),inst_17546,inst_17548,null));
var state_17642__$1 = state_17642;
var statearr_17668_17760 = state_17642__$1;
(statearr_17668_17760[(2)] = inst_17549);

(statearr_17668_17760[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (32))){
var inst_17551 = cljs.core.count(clause);
var inst_17552 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_17551);
var inst_17553 = cljs.core.second(clause);
var inst_17554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17553,"rdf:type");
var inst_17555 = ((inst_17552) && (inst_17554));
var state_17642__$1 = state_17642;
if(cljs.core.truth_(inst_17555)){
var statearr_17669_17761 = state_17642__$1;
(statearr_17669_17761[(1)] = (34));

} else {
var statearr_17670_17762 = state_17642__$1;
(statearr_17670_17762[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (40))){
var inst_17631 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17671_17763 = state_17642__$1;
(statearr_17671_17763[(2)] = inst_17631);

(statearr_17671_17763[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (56))){
var inst_17593 = (state_17642[(8)]);
var inst_17594 = (state_17642[(9)]);
var inst_17611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17612 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_17593,res,inst_17594,fuel,max_fuel);
var state_17642__$1 = (function (){var statearr_17672 = state_17642;
(statearr_17672[(7)] = inst_17611);

return statearr_17672;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(59),inst_17612);
} else {
if((state_val_17643 === (33))){
var inst_17635 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17673_17764 = state_17642__$1;
(statearr_17673_17764[(2)] = inst_17635);

(statearr_17673_17764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (13))){
var inst_17470 = (state_17642[(11)]);
var inst_17470__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17471 = cljs.core.seq(inst_17470__$1);
var inst_17472 = cljs.core.first(inst_17471);
var inst_17473 = cljs.core.next(inst_17471);
var inst_17474 = inst_17470__$1;
var inst_17475 = null;
var state_17642__$1 = (function (){var statearr_17674 = state_17642;
(statearr_17674[(11)] = inst_17470__$1);

(statearr_17674[(12)] = inst_17473);

(statearr_17674[(13)] = inst_17472);

(statearr_17674[(16)] = inst_17474);

(statearr_17674[(17)] = inst_17475);

return statearr_17674;
})();
var statearr_17675_17765 = state_17642__$1;
(statearr_17675_17765[(2)] = null);

(statearr_17675_17765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (22))){
var inst_17491 = (state_17642[(19)]);
var inst_17482 = (state_17642[(15)]);
var inst_17475 = (state_17642[(17)]);
var inst_17493 = fluree.db.query.analytical.outer_union(inst_17475,inst_17491);
var inst_17474 = inst_17482;
var inst_17475__$1 = inst_17493;
var state_17642__$1 = (function (){var statearr_17676 = state_17642;
(statearr_17676[(16)] = inst_17474);

(statearr_17676[(17)] = inst_17475__$1);

return statearr_17676;
})();
var statearr_17677_17766 = state_17642__$1;
(statearr_17677_17766[(2)] = null);

(statearr_17677_17766[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (36))){
var inst_17633 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17678_17767 = state_17642__$1;
(statearr_17678_17767[(2)] = inst_17633);

(statearr_17678_17767[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (41))){
var inst_17568 = (state_17642[(20)]);
var inst_17571 = (state_17642[(2)]);
var inst_17572 = fluree.db.util.async.throw_err(inst_17571);
var inst_17573 = [inst_17572,r];
var inst_17574 = (new cljs.core.PersistentVector(null,2,(5),inst_17568,inst_17573,null));
var state_17642__$1 = state_17642;
var statearr_17679_17768 = state_17642__$1;
(statearr_17679_17768[(2)] = inst_17574);

(statearr_17679_17768[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (43))){
var state_17642__$1 = state_17642;
var statearr_17680_17769 = state_17642__$1;
(statearr_17680_17769[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (29))){
var inst_17445 = (state_17642[(14)]);
var inst_17528 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17445)].join('');
var inst_17529 = (new Error(inst_17528));
var inst_17530 = (function(){throw inst_17529})();
var state_17642__$1 = state_17642;
var statearr_17682_17770 = state_17642__$1;
(statearr_17682_17770[(2)] = inst_17530);

(statearr_17682_17770[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (44))){
var inst_17629 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17683_17771 = state_17642__$1;
(statearr_17683_17771[(2)] = inst_17629);

(statearr_17683_17771[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (6))){
var inst_17445 = (state_17642[(14)]);
var inst_17449 = (state_17642[(18)]);
var inst_17444 = cljs.core.keys(clause);
var inst_17445__$1 = cljs.core.first(inst_17444);
var inst_17449__$1 = cljs.core._EQ_;
var inst_17450 = (function (){var G__17684 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__17685 = inst_17445__$1;
return (inst_17449__$1.cljs$core$IFn$_invoke$arity$2 ? inst_17449__$1.cljs$core$IFn$_invoke$arity$2(G__17684,G__17685) : inst_17449__$1.call(null,G__17684,G__17685));
})();
var state_17642__$1 = (function (){var statearr_17686 = state_17642;
(statearr_17686[(14)] = inst_17445__$1);

(statearr_17686[(18)] = inst_17449__$1);

return statearr_17686;
})();
if(cljs.core.truth_(inst_17450)){
var statearr_17687_17772 = state_17642__$1;
(statearr_17687_17772[(1)] = (9));

} else {
var statearr_17688_17773 = state_17642__$1;
(statearr_17688_17773[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (28))){
var inst_17522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17523 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17524 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_17523,optional_QMARK_);
var inst_17525 = [inst_17524,r];
var inst_17526 = (new cljs.core.PersistentVector(null,2,(5),inst_17522,inst_17525,null));
var state_17642__$1 = state_17642;
var statearr_17689_17774 = state_17642__$1;
(statearr_17689_17774[(2)] = inst_17526);

(statearr_17689_17774[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (51))){
var inst_17624 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17690_17775 = state_17642__$1;
(statearr_17690_17775[(2)] = inst_17624);

(statearr_17690_17775[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (25))){
var inst_17445 = (state_17642[(14)]);
var inst_17449 = (state_17642[(18)]);
var inst_17510 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17511 = (function (){var segment_type = inst_17445;
var pred__17446 = inst_17449;
var expr__17447 = inst_17445;
var bindings = inst_17510;
return (function (p1__17429_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__17429_SHARP_);
});
})();
var inst_17512 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17511,inst_17510);
var inst_17513 = cljs.core.PersistentHashMap.EMPTY;
var inst_17514 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17513,inst_17512);
var inst_17515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17516 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_17514);
var inst_17517 = [inst_17516,r];
var inst_17518 = (new cljs.core.PersistentVector(null,2,(5),inst_17515,inst_17517,null));
var state_17642__$1 = state_17642;
var statearr_17691_17776 = state_17642__$1;
(statearr_17691_17776[(2)] = inst_17518);

(statearr_17691_17776[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (34))){
var inst_17557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17558 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_17642__$1 = (function (){var statearr_17692 = state_17642;
(statearr_17692[(21)] = inst_17557);

return statearr_17692;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(37),inst_17558);
} else {
if((state_val_17643 === (17))){
var inst_17506 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17693_17777 = state_17642__$1;
(statearr_17693_17777[(2)] = inst_17506);

(statearr_17693_17777[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (3))){
var inst_17640 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17642__$1,inst_17640);
} else {
if((state_val_17643 === (12))){
var inst_17452 = (state_17642[(22)]);
var inst_17456 = (state_17642[(2)]);
var inst_17457 = fluree.db.util.async.throw_err(inst_17456);
var inst_17458 = [inst_17457,r];
var inst_17459 = (new cljs.core.PersistentVector(null,2,(5),inst_17452,inst_17458,null));
var state_17642__$1 = state_17642;
var statearr_17694_17778 = state_17642__$1;
(statearr_17694_17778[(2)] = inst_17459);

(statearr_17694_17778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (2))){
var _ = (function (){var statearr_17695 = state_17642;
(statearr_17695[(4)] = cljs.core.cons((5),(state_17642[(4)])));

return statearr_17695;
})();
var inst_17442 = cljs.core.map_QMARK_(clause);
var state_17642__$1 = state_17642;
if(inst_17442){
var statearr_17696_17779 = state_17642__$1;
(statearr_17696_17779[(1)] = (6));

} else {
var statearr_17697_17780 = state_17642__$1;
(statearr_17697_17780[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (23))){
var inst_17491 = (state_17642[(19)]);
var inst_17482 = (state_17642[(15)]);
var inst_17474 = inst_17482;
var inst_17475 = inst_17491;
var state_17642__$1 = (function (){var statearr_17698 = state_17642;
(statearr_17698[(16)] = inst_17474);

(statearr_17698[(17)] = inst_17475);

return statearr_17698;
})();
var statearr_17699_17781 = state_17642__$1;
(statearr_17699_17781[(2)] = null);

(statearr_17699_17781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (47))){
var inst_17627 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17700_17782 = state_17642__$1;
(statearr_17700_17782[(2)] = inst_17627);

(statearr_17700_17782[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (35))){
var inst_17565 = cljs.core.count(clause);
var inst_17566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_17565);
var state_17642__$1 = state_17642;
if(inst_17566){
var statearr_17701_17783 = state_17642__$1;
(statearr_17701_17783[(1)] = (38));

} else {
var statearr_17702_17784 = state_17642__$1;
(statearr_17702_17784[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (19))){
var inst_17475 = (state_17642[(17)]);
var inst_17500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17501 = [inst_17475,r];
var inst_17502 = (new cljs.core.PersistentVector(null,2,(5),inst_17500,inst_17501,null));
var state_17642__$1 = state_17642;
var statearr_17703_17785 = state_17642__$1;
(statearr_17703_17785[(2)] = inst_17502);

(statearr_17703_17785[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (57))){
var state_17642__$1 = state_17642;
var statearr_17704_17786 = state_17642__$1;
(statearr_17704_17786[(2)] = null);

(statearr_17704_17786[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (11))){
var inst_17538 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17706_17787 = state_17642__$1;
(statearr_17706_17787[(2)] = inst_17538);

(statearr_17706_17787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (9))){
var inst_17452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17453 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17454 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_17453,res,fuel,max_fuel,opts);
var state_17642__$1 = (function (){var statearr_17707 = state_17642;
(statearr_17707[(22)] = inst_17452);

return statearr_17707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(12),inst_17454);
} else {
if((state_val_17643 === (5))){
var _ = (function (){var statearr_17708 = state_17642;
(statearr_17708[(4)] = cljs.core.rest((state_17642[(4)])));

return statearr_17708;
})();
var state_17642__$1 = state_17642;
var ex17705 = (state_17642__$1[(2)]);
var statearr_17709_17788 = state_17642__$1;
(statearr_17709_17788[(5)] = ex17705);


if((ex17705 instanceof Error)){
var statearr_17710_17789 = state_17642__$1;
(statearr_17710_17789[(1)] = (4));

(statearr_17710_17789[(5)] = null);

} else {
throw ex17705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (14))){
var inst_17445 = (state_17642[(14)]);
var inst_17449 = (state_17642[(18)]);
var inst_17508 = (function (){var G__17711 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__17712 = inst_17445;
return (inst_17449.cljs$core$IFn$_invoke$arity$2 ? inst_17449.cljs$core$IFn$_invoke$arity$2(G__17711,G__17712) : inst_17449.call(null,G__17711,G__17712));
})();
var state_17642__$1 = state_17642;
if(cljs.core.truth_(inst_17508)){
var statearr_17713_17790 = state_17642__$1;
(statearr_17713_17790[(1)] = (25));

} else {
var statearr_17714_17791 = state_17642__$1;
(statearr_17714_17791[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (45))){
var inst_17589 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_17642__$1 = state_17642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(48),inst_17589);
} else {
if((state_val_17643 === (53))){
var inst_17593 = (state_17642[(8)]);
var inst_17594 = (state_17642[(9)]);
var inst_17605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17606 = fluree.db.query.analytical.full_text__GT_tuples(inst_17593,res,inst_17594);
var inst_17607 = [inst_17606,r];
var inst_17608 = (new cljs.core.PersistentVector(null,2,(5),inst_17605,inst_17607,null));
var state_17642__$1 = state_17642;
var statearr_17715_17792 = state_17642__$1;
(statearr_17715_17792[(2)] = inst_17608);

(statearr_17715_17792[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (26))){
var inst_17445 = (state_17642[(14)]);
var inst_17449 = (state_17642[(18)]);
var inst_17520 = (function (){var G__17716 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__17717 = inst_17445;
return (inst_17449.cljs$core$IFn$_invoke$arity$2 ? inst_17449.cljs$core$IFn$_invoke$arity$2(G__17716,G__17717) : inst_17449.call(null,G__17716,G__17717));
})();
var state_17642__$1 = state_17642;
if(cljs.core.truth_(inst_17520)){
var statearr_17718_17793 = state_17642__$1;
(statearr_17718_17793[(1)] = (28));

} else {
var statearr_17719_17794 = state_17642__$1;
(statearr_17719_17794[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (16))){
var inst_17481 = (state_17642[(10)]);
var inst_17474 = (state_17642[(16)]);
var inst_17480 = cljs.core.seq(inst_17474);
var inst_17481__$1 = cljs.core.first(inst_17480);
var inst_17482 = cljs.core.next(inst_17480);
var state_17642__$1 = (function (){var statearr_17720 = state_17642;
(statearr_17720[(10)] = inst_17481__$1);

(statearr_17720[(15)] = inst_17482);

return statearr_17720;
})();
if(cljs.core.truth_(inst_17481__$1)){
var statearr_17721_17795 = state_17642__$1;
(statearr_17721_17795[(1)] = (18));

} else {
var statearr_17722_17796 = state_17642__$1;
(statearr_17722_17796[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (38))){
var inst_17568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17569 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_17642__$1 = (function (){var statearr_17723 = state_17642;
(statearr_17723[(20)] = inst_17568);

return statearr_17723;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(41),inst_17569);
} else {
if((state_val_17643 === (30))){
var inst_17532 = (state_17642[(2)]);
var state_17642__$1 = state_17642;
var statearr_17724_17797 = state_17642__$1;
(statearr_17724_17797[(2)] = inst_17532);

(statearr_17724_17797[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (10))){
var inst_17445 = (state_17642[(14)]);
var inst_17449 = (state_17642[(18)]);
var inst_17461 = (function (){var G__17725 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__17726 = inst_17445;
return (inst_17449.cljs$core$IFn$_invoke$arity$2 ? inst_17449.cljs$core$IFn$_invoke$arity$2(G__17725,G__17726) : inst_17449.call(null,G__17725,G__17726));
})();
var state_17642__$1 = state_17642;
if(cljs.core.truth_(inst_17461)){
var statearr_17727_17798 = state_17642__$1;
(statearr_17727_17798[(1)] = (13));

} else {
var statearr_17728_17799 = state_17642__$1;
(statearr_17728_17799[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (18))){
var inst_17481 = (state_17642[(10)]);
var inst_17484 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_17481,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_17481,q_map,vars,fuel,max_fuel,opts));
var state_17642__$1 = state_17642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(21),inst_17484);
} else {
if((state_val_17643 === (52))){
var inst_17599 = (state_17642[(2)]);
var inst_17600 = fluree.db.util.async.throw_err(inst_17599);
var state_17642__$1 = state_17642;
var statearr_17729_17800 = state_17642__$1;
(statearr_17729_17800[(2)] = inst_17600);

(statearr_17729_17800[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (42))){
var inst_17579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17580 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_17581 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_17580);
var inst_17582 = [inst_17581,r];
var inst_17583 = (new cljs.core.PersistentVector(null,2,(5),inst_17579,inst_17582,null));
var state_17642__$1 = state_17642;
var statearr_17730_17801 = state_17642__$1;
(statearr_17730_17801[(2)] = inst_17583);

(statearr_17730_17801[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (37))){
var inst_17557 = (state_17642[(21)]);
var inst_17560 = (state_17642[(2)]);
var inst_17561 = fluree.db.util.async.throw_err(inst_17560);
var inst_17562 = [inst_17561,r];
var inst_17563 = (new cljs.core.PersistentVector(null,2,(5),inst_17557,inst_17562,null));
var state_17642__$1 = state_17642;
var statearr_17731_17802 = state_17642__$1;
(statearr_17731_17802[(2)] = inst_17563);

(statearr_17731_17802[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (8))){
var inst_17637 = (state_17642[(2)]);
var _ = (function (){var statearr_17732 = state_17642;
(statearr_17732[(4)] = cljs.core.rest((state_17642[(4)])));

return statearr_17732;
})();
var state_17642__$1 = state_17642;
var statearr_17733_17803 = state_17642__$1;
(statearr_17733_17803[(2)] = inst_17637);

(statearr_17733_17803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17643 === (49))){
var inst_17594 = (state_17642[(9)]);
var inst_17597 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_17594,r,res,optional_QMARK_,fuel,max_fuel);
var state_17642__$1 = state_17642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17642__$1,(52),inst_17597);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_17734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17734[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__);

(statearr_17734[(1)] = (1));

return statearr_17734;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1 = (function (state_17642){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17642);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17735){var ex__2417__auto__ = e17735;
var statearr_17736_17804 = state_17642;
(statearr_17736_17804[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17642[(4)]))){
var statearr_17737_17805 = state_17642;
(statearr_17737_17805[(1)] = cljs.core.first((state_17642[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17806 = state_17642;
state_17642 = G__17806;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__ = function(state_17642){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1.call(this,state_17642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17738 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17738[(6)] = c__2436__auto__);

return statearr_17738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__17808 = arguments.length;
switch (G__17808) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17888){
var state_val_17889 = (state_17888[(1)]);
if((state_val_17889 === (7))){
var inst_17883 = (state_17888[(2)]);
var _ = (function (){var statearr_17890 = state_17888;
(statearr_17890[(4)] = cljs.core.rest((state_17888[(4)])));

return statearr_17890;
})();
var state_17888__$1 = state_17888;
var statearr_17891_17939 = state_17888__$1;
(statearr_17891_17939[(2)] = inst_17883);

(statearr_17891_17939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (20))){
var inst_17848 = (state_17888[(7)]);
var inst_17860 = (state_17888[(2)]);
var inst_17830 = inst_17848;
var inst_17831 = inst_17860;
var state_17888__$1 = (function (){var statearr_17892 = state_17888;
(statearr_17892[(8)] = inst_17830);

(statearr_17892[(9)] = inst_17831);

return statearr_17892;
})();
var statearr_17893_17940 = state_17888__$1;
(statearr_17893_17940[(2)] = null);

(statearr_17893_17940[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (1))){
var state_17888__$1 = state_17888;
var statearr_17894_17941 = state_17888__$1;
(statearr_17894_17941[(2)] = null);

(statearr_17894_17941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (24))){
var inst_17847 = (state_17888[(10)]);
var inst_17848 = (state_17888[(7)]);
var inst_17831 = (state_17888[(9)]);
var inst_17868 = fluree.db.query.analytical.inner_join(inst_17831,inst_17847);
var inst_17830 = inst_17848;
var inst_17831__$1 = inst_17868;
var state_17888__$1 = (function (){var statearr_17895 = state_17888;
(statearr_17895[(8)] = inst_17830);

(statearr_17895[(9)] = inst_17831__$1);

return statearr_17895;
})();
var statearr_17896_17942 = state_17888__$1;
(statearr_17896_17942[(2)] = null);

(statearr_17896_17942[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (4))){
var inst_17809 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17898_17943 = state_17888__$1;
(statearr_17898_17943[(2)] = inst_17809);

(statearr_17898_17943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (15))){
var inst_17847 = (state_17888[(10)]);
var state_17888__$1 = state_17888;
if(cljs.core.truth_(inst_17847)){
var statearr_17899_17944 = state_17888__$1;
(statearr_17899_17944[(1)] = (18));

} else {
var statearr_17900_17945 = state_17888__$1;
(statearr_17900_17945[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (21))){
var inst_17848 = (state_17888[(7)]);
var inst_17831 = (state_17888[(9)]);
var tmp17897 = inst_17831;
var inst_17830 = inst_17848;
var inst_17831__$1 = tmp17897;
var state_17888__$1 = (function (){var statearr_17901 = state_17888;
(statearr_17901[(8)] = inst_17830);

(statearr_17901[(9)] = inst_17831__$1);

return statearr_17901;
})();
var statearr_17902_17946 = state_17888__$1;
(statearr_17902_17946[(2)] = null);

(statearr_17902_17946[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (13))){
var inst_17831 = (state_17888[(9)]);
var inst_17854 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_17831,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_17855 = cljs.core.empty_QMARK_(inst_17854);
var state_17888__$1 = state_17888;
if(inst_17855){
var statearr_17903_17947 = state_17888__$1;
(statearr_17903_17947[(1)] = (15));

} else {
var statearr_17904_17948 = state_17888__$1;
(statearr_17904_17948[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (22))){
var state_17888__$1 = state_17888;
var statearr_17905_17949 = state_17888__$1;
(statearr_17905_17949[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (6))){
var inst_17837 = (state_17888[(11)]);
var inst_17830 = (state_17888[(8)]);
var inst_17836 = cljs.core.seq(inst_17830);
var inst_17837__$1 = cljs.core.first(inst_17836);
var inst_17838 = cljs.core.next(inst_17836);
var state_17888__$1 = (function (){var statearr_17907 = state_17888;
(statearr_17907[(11)] = inst_17837__$1);

(statearr_17907[(12)] = inst_17838);

return statearr_17907;
})();
if(cljs.core.truth_(inst_17837__$1)){
var statearr_17908_17950 = state_17888__$1;
(statearr_17908_17950[(1)] = (8));

} else {
var statearr_17909_17951 = state_17888__$1;
(statearr_17909_17951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (25))){
var state_17888__$1 = state_17888;
var statearr_17910_17952 = state_17888__$1;
(statearr_17910_17952[(2)] = null);

(statearr_17910_17952[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (17))){
var inst_17876 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17911_17953 = state_17888__$1;
(statearr_17911_17953[(2)] = inst_17876);

(statearr_17911_17953[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (3))){
var inst_17886 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17888__$1,inst_17886);
} else {
if((state_val_17889 === (12))){
var inst_17847 = (state_17888[(10)]);
var inst_17848 = (state_17888[(7)]);
var inst_17830 = inst_17848;
var inst_17831 = inst_17847;
var state_17888__$1 = (function (){var statearr_17912 = state_17888;
(statearr_17912[(8)] = inst_17830);

(statearr_17912[(9)] = inst_17831);

return statearr_17912;
})();
var statearr_17913_17954 = state_17888__$1;
(statearr_17913_17954[(2)] = null);

(statearr_17913_17954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (2))){
var _ = (function (){var statearr_17914 = state_17888;
(statearr_17914[(4)] = cljs.core.cons((5),(state_17888[(4)])));

return statearr_17914;
})();
var inst_17822 = where;
var inst_17823 = cljs.core.seq(inst_17822);
var inst_17824 = cljs.core.first(inst_17823);
var inst_17825 = cljs.core.next(inst_17823);
var inst_17826 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17827 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_17828 = [inst_17827];
var inst_17829 = cljs.core.PersistentHashMap.fromArrays(inst_17826,inst_17828);
var inst_17830 = inst_17822;
var inst_17831 = inst_17829;
var state_17888__$1 = (function (){var statearr_17915 = state_17888;
(statearr_17915[(13)] = inst_17824);

(statearr_17915[(14)] = inst_17825);

(statearr_17915[(8)] = inst_17830);

(statearr_17915[(9)] = inst_17831);

return statearr_17915;
})();
var statearr_17916_17955 = state_17888__$1;
(statearr_17916_17955[(2)] = null);

(statearr_17916_17955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (23))){
var inst_17874 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17917_17956 = state_17888__$1;
(statearr_17917_17956[(2)] = inst_17874);

(statearr_17917_17956[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (19))){
var inst_17831 = (state_17888[(9)]);
var state_17888__$1 = state_17888;
var statearr_17918_17957 = state_17888__$1;
(statearr_17918_17957[(2)] = inst_17831);

(statearr_17918_17957[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (11))){
var inst_17837 = (state_17888[(11)]);
var inst_17845 = (state_17888[(2)]);
var inst_17846 = fluree.db.util.async.throw_err(inst_17845);
var inst_17847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17846,(0),null);
var inst_17848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17846,(1),null);
var inst_17849 = cljs.core.count(inst_17837);
var inst_17850 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_17849);
var state_17888__$1 = (function (){var statearr_17920 = state_17888;
(statearr_17920[(10)] = inst_17847);

(statearr_17920[(7)] = inst_17848);

return statearr_17920;
})();
if(inst_17850){
var statearr_17921_17958 = state_17888__$1;
(statearr_17921_17958[(1)] = (12));

} else {
var statearr_17922_17959 = state_17888__$1;
(statearr_17922_17959[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (9))){
var inst_17831 = (state_17888[(9)]);
var state_17888__$1 = state_17888;
var statearr_17923_17960 = state_17888__$1;
(statearr_17923_17960[(2)] = inst_17831);

(statearr_17923_17960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (5))){
var _ = (function (){var statearr_17924 = state_17888;
(statearr_17924[(4)] = cljs.core.rest((state_17888[(4)])));

return statearr_17924;
})();
var state_17888__$1 = state_17888;
var ex17919 = (state_17888__$1[(2)]);
var statearr_17925_17961 = state_17888__$1;
(statearr_17925_17961[(5)] = ex17919);


if((ex17919 instanceof Error)){
var statearr_17926_17962 = state_17888__$1;
(statearr_17926_17962[(1)] = (4));

(statearr_17926_17962[(5)] = null);

} else {
throw ex17919;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (14))){
var inst_17878 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17927_17963 = state_17888__$1;
(statearr_17927_17963[(2)] = inst_17878);

(statearr_17927_17963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (26))){
var inst_17872 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17928_17964 = state_17888__$1;
(statearr_17928_17964[(2)] = inst_17872);

(statearr_17928_17964[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (16))){
var inst_17847 = (state_17888[(10)]);
var inst_17863 = (inst_17847 == null);
var state_17888__$1 = state_17888;
if(cljs.core.truth_(inst_17863)){
var statearr_17929_17965 = state_17888__$1;
(statearr_17929_17965[(1)] = (21));

} else {
var statearr_17930_17966 = state_17888__$1;
(statearr_17930_17966[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (10))){
var inst_17881 = (state_17888[(2)]);
var state_17888__$1 = state_17888;
var statearr_17931_17967 = state_17888__$1;
(statearr_17931_17967[(2)] = inst_17881);

(statearr_17931_17967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (18))){
var inst_17847 = (state_17888[(10)]);
var state_17888__$1 = state_17888;
var statearr_17932_17968 = state_17888__$1;
(statearr_17932_17968[(2)] = inst_17847);

(statearr_17932_17968[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17889 === (8))){
var inst_17837 = (state_17888[(11)]);
var inst_17831 = (state_17888[(9)]);
var inst_17838 = (state_17888[(12)]);
var inst_17843 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_17831,inst_17837,inst_17838,false,fuel,max_fuel,opts);
var state_17888__$1 = state_17888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17888__$1,(11),inst_17843);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2414__auto__ = null;
var fluree$db$query$analytical$state_machine__2414__auto____0 = (function (){
var statearr_17933 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17933[(0)] = fluree$db$query$analytical$state_machine__2414__auto__);

(statearr_17933[(1)] = (1));

return statearr_17933;
});
var fluree$db$query$analytical$state_machine__2414__auto____1 = (function (state_17888){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17888);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17934){var ex__2417__auto__ = e17934;
var statearr_17935_17969 = state_17888;
(statearr_17935_17969[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17888[(4)]))){
var statearr_17936_17970 = state_17888;
(statearr_17936_17970[(1)] = cljs.core.first((state_17888[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17971 = state_17888;
state_17888 = G__17971;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2414__auto__ = function(state_17888){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2414__auto____1.call(this,state_17888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2414__auto____0;
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2414__auto____1;
return fluree$db$query$analytical$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17937 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17937[(6)] = c__2436__auto__);

return statearr_17937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18026){
var state_val_18027 = (state_18026[(1)]);
if((state_val_18027 === (7))){
var state_18026__$1 = state_18026;
var statearr_18028_18066 = state_18026__$1;
(statearr_18028_18066[(2)] = false);

(statearr_18028_18066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (20))){
var inst_18004 = (state_18026[(7)]);
var inst_18016 = (state_18026[(8)]);
var inst_18018 = fluree.db.query.analytical.tuples__GT_filtered(inst_18016,inst_18004,null);
var state_18026__$1 = state_18026;
var statearr_18029_18067 = state_18026__$1;
(statearr_18029_18067[(2)] = inst_18018);

(statearr_18029_18067[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (1))){
var state_18026__$1 = state_18026;
var statearr_18030_18068 = state_18026__$1;
(statearr_18030_18068[(2)] = null);

(statearr_18030_18068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (4))){
var inst_17972 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
var statearr_18031_18069 = state_18026__$1;
(statearr_18031_18069[(2)] = inst_17972);

(statearr_18031_18069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (15))){
var inst_18003 = (state_18026[(9)]);
var inst_18007 = (state_18026[(2)]);
var inst_18008 = fluree.db.util.async.throw_err(inst_18007);
var state_18026__$1 = (function (){var statearr_18032 = state_18026;
(statearr_18032[(10)] = inst_18008);

return statearr_18032;
})();
if(cljs.core.truth_(inst_18003)){
var statearr_18033_18070 = state_18026__$1;
(statearr_18033_18070[(1)] = (16));

} else {
var statearr_18034_18071 = state_18026__$1;
(statearr_18034_18071[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (21))){
var inst_18016 = (state_18026[(8)]);
var state_18026__$1 = state_18026;
var statearr_18035_18072 = state_18026__$1;
(statearr_18035_18072[(2)] = inst_18016);

(statearr_18035_18072[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (13))){
var inst_17979 = (state_18026[(11)]);
var state_18026__$1 = state_18026;
var statearr_18036_18073 = state_18026__$1;
(statearr_18036_18073[(2)] = inst_17979);

(statearr_18036_18073[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (22))){
var inst_18021 = (state_18026[(2)]);
var _ = (function (){var statearr_18037 = state_18026;
(statearr_18037[(4)] = cljs.core.rest((state_18026[(4)])));

return statearr_18037;
})();
var state_18026__$1 = state_18026;
var statearr_18038_18074 = state_18026__$1;
(statearr_18038_18074[(2)] = inst_18021);

(statearr_18038_18074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (6))){
var inst_17979 = (state_18026[(11)]);
var inst_17984 = inst_17979.cljs$lang$protocol_mask$partition0$;
var inst_17985 = (inst_17984 & (64));
var inst_17986 = inst_17979.cljs$core$ISeq$;
var inst_17987 = (cljs.core.PROTOCOL_SENTINEL === inst_17986);
var inst_17988 = ((inst_17985) || (inst_17987));
var state_18026__$1 = state_18026;
if(cljs.core.truth_(inst_17988)){
var statearr_18039_18075 = state_18026__$1;
(statearr_18039_18075[(1)] = (9));

} else {
var statearr_18040_18076 = state_18026__$1;
(statearr_18040_18076[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (17))){
var inst_18008 = (state_18026[(10)]);
var state_18026__$1 = state_18026;
var statearr_18041_18077 = state_18026__$1;
(statearr_18041_18077[(2)] = inst_18008);

(statearr_18041_18077[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (3))){
var inst_18024 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18026__$1,inst_18024);
} else {
if((state_val_18027 === (12))){
var inst_17979 = (state_18026[(11)]);
var inst_17997 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17979);
var state_18026__$1 = state_18026;
var statearr_18042_18078 = state_18026__$1;
(statearr_18042_18078[(2)] = inst_17997);

(statearr_18042_18078[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (2))){
var inst_17979 = (state_18026[(11)]);
var _ = (function (){var statearr_18043 = state_18026;
(statearr_18043[(4)] = cljs.core.cons((5),(state_18026[(4)])));

return statearr_18043;
})();
var inst_17979__$1 = q_map;
var inst_17981 = (inst_17979__$1 == null);
var inst_17982 = cljs.core.not(inst_17981);
var state_18026__$1 = (function (){var statearr_18044 = state_18026;
(statearr_18044[(11)] = inst_17979__$1);

return statearr_18044;
})();
if(inst_17982){
var statearr_18045_18079 = state_18026__$1;
(statearr_18045_18079[(1)] = (6));

} else {
var statearr_18046_18080 = state_18026__$1;
(statearr_18046_18080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (19))){
var inst_18012 = (state_18026[(2)]);
var inst_18013 = fluree.db.util.async.throw_err(inst_18012);
var state_18026__$1 = state_18026;
var statearr_18047_18081 = state_18026__$1;
(statearr_18047_18081[(2)] = inst_18013);

(statearr_18047_18081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (11))){
var inst_17992 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
var statearr_18049_18082 = state_18026__$1;
(statearr_18049_18082[(2)] = inst_17992);

(statearr_18049_18082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (9))){
var state_18026__$1 = state_18026;
var statearr_18050_18083 = state_18026__$1;
(statearr_18050_18083[(2)] = true);

(statearr_18050_18083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (5))){
var _ = (function (){var statearr_18051 = state_18026;
(statearr_18051[(4)] = cljs.core.rest((state_18026[(4)])));

return statearr_18051;
})();
var state_18026__$1 = state_18026;
var ex18048 = (state_18026__$1[(2)]);
var statearr_18052_18084 = state_18026__$1;
(statearr_18052_18084[(5)] = ex18048);


if((ex18048 instanceof Error)){
var statearr_18053_18085 = state_18026__$1;
(statearr_18053_18085[(1)] = (4));

(statearr_18053_18085[(5)] = null);

} else {
throw ex18048;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (14))){
var inst_18000 = (state_18026[(2)]);
var inst_18001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18000,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18000,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_18003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18000,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_18004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18000,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_18005 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_18002,q_map,inst_18001,fuel,max_fuel,opts);
var state_18026__$1 = (function (){var statearr_18054 = state_18026;
(statearr_18054[(7)] = inst_18004);

(statearr_18054[(9)] = inst_18003);

return statearr_18054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18026__$1,(15),inst_18005);
} else {
if((state_val_18027 === (16))){
var inst_18008 = (state_18026[(10)]);
var inst_18003 = (state_18026[(9)]);
var inst_18010 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_18003,inst_18008,fuel,max_fuel,opts);
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18026__$1,(19),inst_18010);
} else {
if((state_val_18027 === (10))){
var state_18026__$1 = state_18026;
var statearr_18055_18086 = state_18026__$1;
(statearr_18055_18086[(2)] = false);

(statearr_18055_18086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (18))){
var inst_18004 = (state_18026[(7)]);
var inst_18016 = (state_18026[(2)]);
var state_18026__$1 = (function (){var statearr_18056 = state_18026;
(statearr_18056[(8)] = inst_18016);

return statearr_18056;
})();
if(cljs.core.truth_(inst_18004)){
var statearr_18057_18087 = state_18026__$1;
(statearr_18057_18087[(1)] = (20));

} else {
var statearr_18058_18088 = state_18026__$1;
(statearr_18058_18088[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (8))){
var inst_17995 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
if(cljs.core.truth_(inst_17995)){
var statearr_18059_18089 = state_18026__$1;
(statearr_18059_18089[(1)] = (12));

} else {
var statearr_18060_18090 = state_18026__$1;
(statearr_18060_18090[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2414__auto____0 = (function (){
var statearr_18061 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18061[(0)] = fluree$db$query$analytical$q_$_state_machine__2414__auto__);

(statearr_18061[(1)] = (1));

return statearr_18061;
});
var fluree$db$query$analytical$q_$_state_machine__2414__auto____1 = (function (state_18026){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18026);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18062){var ex__2417__auto__ = e18062;
var statearr_18063_18091 = state_18026;
(statearr_18063_18091[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18026[(4)]))){
var statearr_18064_18092 = state_18026;
(statearr_18064_18092[(1)] = cljs.core.first((state_18026[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18093 = state_18026;
state_18026 = G__18093;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2414__auto__ = function(state_18026){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2414__auto____1.call(this,state_18026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2414__auto____0;
fluree$db$query$analytical$q_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18065 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18065[(6)] = c__2436__auto__);

return statearr_18065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
