// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63495 = arguments.length;
switch (G__63495) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___63534 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63516){
var state_val_63517 = (state_63516[(1)]);
if((state_val_63517 === (1))){
var state_63516__$1 = state_63516;
var statearr_63518_63535 = state_63516__$1;
(statearr_63518_63535[(2)] = null);

(statearr_63518_63535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63517 === (2))){
var _ = (function (){var statearr_63519 = state_63516;
(statearr_63519[(4)] = cljs.core.cons((5),(state_63516[(4)])));

return statearr_63519;
})();
var inst_63502 = fluree.db.session.db(conn,ledger,null);
var state_63516__$1 = state_63516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63516__$1,(7),inst_63502);
} else {
if((state_val_63517 === (3))){
var inst_63512 = (state_63516[(2)]);
var inst_63513 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63512);
var inst_63514 = cljs.core.async.close_BANG_(pc);
var state_63516__$1 = (function (){var statearr_63521 = state_63516;
(statearr_63521[(7)] = inst_63513);

return statearr_63521;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63516__$1,inst_63514);
} else {
if((state_val_63517 === (4))){
var inst_63496 = (state_63516[(2)]);
var state_63516__$1 = state_63516;
var statearr_63522_63536 = state_63516__$1;
(statearr_63522_63536[(2)] = inst_63496);

(statearr_63522_63536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63517 === (5))){
var _ = (function (){var statearr_63523 = state_63516;
(statearr_63523[(4)] = cljs.core.rest((state_63516[(4)])));

return statearr_63523;
})();
var state_63516__$1 = state_63516;
var ex63520 = (state_63516__$1[(2)]);
var statearr_63524_63537 = state_63516__$1;
(statearr_63524_63537[(5)] = ex63520);


var statearr_63525_63538 = state_63516__$1;
(statearr_63525_63538[(1)] = (4));

(statearr_63525_63538[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63517 === (6))){
var inst_63508 = (state_63516[(2)]);
var inst_63509 = fluree.db.util.async.throw_err(inst_63508);
var _ = (function (){var statearr_63526 = state_63516;
(statearr_63526[(4)] = cljs.core.rest((state_63516[(4)])));

return statearr_63526;
})();
var state_63516__$1 = state_63516;
var statearr_63527_63539 = state_63516__$1;
(statearr_63527_63539[(2)] = inst_63509);

(statearr_63527_63539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63517 === (7))){
var inst_63504 = (state_63516[(2)]);
var inst_63505 = fluree.db.util.async.throw_err(inst_63504);
var inst_63506 = fluree.db.time_travel.as_of_block(inst_63505,block);
var state_63516__$1 = state_63516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63516__$1,(6),inst_63506);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2414__auto__ = null;
var fluree$db$api$ledger$state_machine__2414__auto____0 = (function (){
var statearr_63528 = [null,null,null,null,null,null,null,null];
(statearr_63528[(0)] = fluree$db$api$ledger$state_machine__2414__auto__);

(statearr_63528[(1)] = (1));

return statearr_63528;
});
var fluree$db$api$ledger$state_machine__2414__auto____1 = (function (state_63516){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63516);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63529){var ex__2417__auto__ = e63529;
var statearr_63530_63540 = state_63516;
(statearr_63530_63540[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63516[(4)]))){
var statearr_63531_63541 = state_63516;
(statearr_63531_63541[(1)] = cljs.core.first((state_63516[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63542 = state_63516;
state_63516 = G__63542;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2414__auto__ = function(state_63516){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2414__auto____1.call(this,state_63516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2414__auto____0;
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2414__auto____1;
return fluree$db$api$ledger$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63532 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63532[(6)] = c__2436__auto___63534);

return statearr_63532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63583){
var state_val_63584 = (state_63583[(1)]);
if((state_val_63584 === (7))){
var inst_63552 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63583__$1 = state_63583;
if(inst_63552){
var statearr_63585_63616 = state_63583__$1;
(statearr_63585_63616[(1)] = (9));

} else {
var statearr_63586_63617 = state_63583__$1;
(statearr_63586_63617[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (1))){
var state_63583__$1 = state_63583;
var statearr_63587_63618 = state_63583__$1;
(statearr_63587_63618[(2)] = null);

(statearr_63587_63618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (4))){
var inst_63543 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63588_63619 = state_63583__$1;
(statearr_63588_63619[(2)] = inst_63543);

(statearr_63588_63619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (15))){
var inst_63560 = (state_63583[(7)]);
var inst_63559 = (state_63583[(2)]);
var inst_63560__$1 = fluree.db.util.async.throw_err(inst_63559);
var state_63583__$1 = (function (){var statearr_63589 = state_63583;
(statearr_63589[(7)] = inst_63560__$1);

return statearr_63589;
})();
if(cljs.core.truth_(inst_63560__$1)){
var statearr_63590_63620 = state_63583__$1;
(statearr_63590_63620[(1)] = (16));

} else {
var statearr_63591_63621 = state_63583__$1;
(statearr_63591_63621[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (13))){
var state_63583__$1 = state_63583;
var statearr_63592_63622 = state_63583__$1;
(statearr_63592_63622[(2)] = null);

(statearr_63592_63622[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (6))){
var state_63583__$1 = state_63583;
var statearr_63593_63623 = state_63583__$1;
(statearr_63593_63623[(2)] = db);

(statearr_63593_63623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (17))){
var inst_63564 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63565 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63566 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63567 = cljs.core.PersistentHashMap.fromArrays(inst_63565,inst_63566);
var inst_63568 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63564,inst_63567);
var inst_63569 = (function(){throw inst_63568})();
var state_63583__$1 = state_63583;
var statearr_63594_63624 = state_63583__$1;
(statearr_63594_63624[(2)] = inst_63569);

(statearr_63594_63624[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (3))){
var inst_63581 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63583__$1,inst_63581);
} else {
if((state_val_63584 === (12))){
var inst_63557 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63583__$1 = state_63583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63583__$1,(15),inst_63557);
} else {
if((state_val_63584 === (2))){
var _ = (function (){var statearr_63595 = state_63583;
(statearr_63595[(4)] = cljs.core.cons((5),(state_63583[(4)])));

return statearr_63595;
})();
var inst_63549 = cljs.core.not(auth);
var state_63583__$1 = state_63583;
if(inst_63549){
var statearr_63596_63625 = state_63583__$1;
(statearr_63596_63625[(1)] = (6));

} else {
var statearr_63597_63626 = state_63583__$1;
(statearr_63597_63626[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (11))){
var inst_63576 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63599_63627 = state_63583__$1;
(statearr_63599_63627[(2)] = inst_63576);

(statearr_63599_63627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (9))){
var inst_63554 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_63583__$1 = state_63583;
var statearr_63600_63628 = state_63583__$1;
(statearr_63600_63628[(2)] = inst_63554);

(statearr_63600_63628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (5))){
var _ = (function (){var statearr_63601 = state_63583;
(statearr_63601[(4)] = cljs.core.rest((state_63583[(4)])));

return statearr_63601;
})();
var state_63583__$1 = state_63583;
var ex63598 = (state_63583__$1[(2)]);
var statearr_63602_63629 = state_63583__$1;
(statearr_63602_63629[(5)] = ex63598);


if((ex63598 instanceof Error)){
var statearr_63603_63630 = state_63583__$1;
(statearr_63603_63630[(1)] = (4));

(statearr_63603_63630[(5)] = null);

} else {
throw ex63598;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (14))){
var inst_63574 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63604_63631 = state_63583__$1;
(statearr_63604_63631[(2)] = inst_63574);

(statearr_63604_63631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (16))){
var inst_63560 = (state_63583[(7)]);
var inst_63562 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63560);
var state_63583__$1 = state_63583;
var statearr_63605_63632 = state_63583__$1;
(statearr_63605_63632[(2)] = inst_63562);

(statearr_63605_63632[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (10))){
var state_63583__$1 = state_63583;
var statearr_63606_63633 = state_63583__$1;
(statearr_63606_63633[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (18))){
var inst_63571 = (state_63583[(2)]);
var state_63583__$1 = state_63583;
var statearr_63608_63634 = state_63583__$1;
(statearr_63608_63634[(2)] = inst_63571);

(statearr_63608_63634[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63584 === (8))){
var inst_63578 = (state_63583[(2)]);
var _ = (function (){var statearr_63609 = state_63583;
(statearr_63609[(4)] = cljs.core.rest((state_63583[(4)])));

return statearr_63609;
})();
var state_63583__$1 = state_63583;
var statearr_63610_63635 = state_63583__$1;
(statearr_63610_63635[(2)] = inst_63578);

(statearr_63610_63635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0 = (function (){
var statearr_63611 = [null,null,null,null,null,null,null,null];
(statearr_63611[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__);

(statearr_63611[(1)] = (1));

return statearr_63611;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1 = (function (state_63583){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63583);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63612){var ex__2417__auto__ = e63612;
var statearr_63613_63636 = state_63583;
(statearr_63613_63636[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63583[(4)]))){
var statearr_63614_63637 = state_63583;
(statearr_63614_63637[(1)] = cljs.core.first((state_63583[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63638 = state_63583;
state_63583 = G__63638;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__ = function(state_63583){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1.call(this,state_63583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63615 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63615[(6)] = c__2436__auto__);

return statearr_63615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63702){
var state_val_63703 = (state_63702[(1)]);
if((state_val_63703 === (7))){
var inst_63648 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63702__$1 = state_63702;
if(inst_63648){
var statearr_63704_63753 = state_63702__$1;
(statearr_63704_63753[(1)] = (9));

} else {
var statearr_63705_63754 = state_63702__$1;
(statearr_63705_63754[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (20))){
var inst_63672 = (state_63702[(7)]);
var state_63702__$1 = state_63702;
if(cljs.core.truth_(inst_63672)){
var statearr_63706_63755 = state_63702__$1;
(statearr_63706_63755[(1)] = (22));

} else {
var statearr_63707_63756 = state_63702__$1;
(statearr_63707_63756[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (27))){
var state_63702__$1 = state_63702;
var statearr_63708_63757 = state_63702__$1;
(statearr_63708_63757[(2)] = null);

(statearr_63708_63757[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (1))){
var state_63702__$1 = state_63702;
var statearr_63709_63758 = state_63702__$1;
(statearr_63709_63758[(2)] = null);

(statearr_63709_63758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (24))){
var inst_63686 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63710_63759 = state_63702__$1;
(statearr_63710_63759[(2)] = inst_63686);

(statearr_63710_63759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (4))){
var inst_63639 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63711_63760 = state_63702__$1;
(statearr_63711_63760[(2)] = inst_63639);

(statearr_63711_63760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (15))){
var inst_63655 = (state_63702[(8)]);
var inst_63654 = (state_63702[(2)]);
var inst_63655__$1 = fluree.db.util.async.throw_err(inst_63654);
var state_63702__$1 = (function (){var statearr_63712 = state_63702;
(statearr_63712[(8)] = inst_63655__$1);

return statearr_63712;
})();
if(cljs.core.truth_(inst_63655__$1)){
var statearr_63713_63761 = state_63702__$1;
(statearr_63713_63761[(1)] = (16));

} else {
var statearr_63714_63762 = state_63702__$1;
(statearr_63714_63762[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (21))){
var inst_63688 = (state_63702[(9)]);
var inst_63688__$1 = (state_63702[(2)]);
var state_63702__$1 = (function (){var statearr_63715 = state_63702;
(statearr_63715[(9)] = inst_63688__$1);

return statearr_63715;
})();
if(cljs.core.truth_(inst_63688__$1)){
var statearr_63716_63763 = state_63702__$1;
(statearr_63716_63763[(1)] = (29));

} else {
var statearr_63717_63764 = state_63702__$1;
(statearr_63717_63764[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (31))){
var inst_63672 = (state_63702[(7)]);
var inst_63688 = (state_63702[(9)]);
var inst_63696 = (state_63702[(2)]);
var inst_63697 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63672,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_63688,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_63696], 0));
var _ = (function (){var statearr_63718 = state_63702;
(statearr_63718[(4)] = cljs.core.rest((state_63702[(4)])));

return statearr_63718;
})();
var state_63702__$1 = state_63702;
var statearr_63719_63765 = state_63702__$1;
(statearr_63719_63765[(2)] = inst_63697);

(statearr_63719_63765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (32))){
var inst_63692 = (state_63702[(2)]);
var inst_63693 = fluree.db.util.async.throw_err(inst_63692);
var state_63702__$1 = state_63702;
var statearr_63720_63766 = state_63702__$1;
(statearr_63720_63766[(2)] = inst_63693);

(statearr_63720_63766[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (13))){
var state_63702__$1 = state_63702;
var statearr_63721_63767 = state_63702__$1;
(statearr_63721_63767[(2)] = null);

(statearr_63721_63767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (22))){
var inst_63672 = (state_63702[(7)]);
var inst_63676 = fluree.db.auth.roles(db,inst_63672);
var state_63702__$1 = state_63702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63702__$1,(25),inst_63676);
} else {
if((state_val_63703 === (29))){
var inst_63688 = (state_63702[(9)]);
var inst_63690 = fluree.db.permissions.permission_map(db,inst_63688,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_63702__$1 = state_63702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63702__$1,(32),inst_63690);
} else {
if((state_val_63703 === (6))){
var state_63702__$1 = state_63702;
var statearr_63722_63768 = state_63702__$1;
(statearr_63722_63768[(2)] = null);

(statearr_63722_63768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (28))){
var inst_63684 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63723_63769 = state_63702__$1;
(statearr_63723_63769[(2)] = inst_63684);

(statearr_63723_63769[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (25))){
var inst_63678 = (state_63702[(2)]);
var inst_63679 = fluree.db.util.async.throw_err(inst_63678);
var state_63702__$1 = state_63702;
var statearr_63724_63770 = state_63702__$1;
(statearr_63724_63770[(2)] = inst_63679);

(statearr_63724_63770[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (17))){
var inst_63658 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63660 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63661 = cljs.core.PersistentHashMap.fromArrays(inst_63659,inst_63660);
var inst_63662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63658,inst_63661);
var inst_63663 = (function(){throw inst_63662})();
var state_63702__$1 = state_63702;
var statearr_63725_63771 = state_63702__$1;
(statearr_63725_63771[(2)] = inst_63663);

(statearr_63725_63771[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (3))){
var inst_63700 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63702__$1,inst_63700);
} else {
if((state_val_63703 === (12))){
var inst_63652 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63702__$1 = state_63702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63702__$1,(15),inst_63652);
} else {
if((state_val_63703 === (2))){
var _ = (function (){var statearr_63726 = state_63702;
(statearr_63726[(4)] = cljs.core.cons((5),(state_63702[(4)])));

return statearr_63726;
})();
var inst_63645 = (auth == null);
var state_63702__$1 = state_63702;
if(cljs.core.truth_(inst_63645)){
var statearr_63727_63772 = state_63702__$1;
(statearr_63727_63772[(1)] = (6));

} else {
var statearr_63728_63773 = state_63702__$1;
(statearr_63728_63773[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (23))){
var state_63702__$1 = state_63702;
var statearr_63729_63774 = state_63702__$1;
(statearr_63729_63774[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (19))){
var state_63702__$1 = state_63702;
var statearr_63731_63775 = state_63702__$1;
(statearr_63731_63775[(2)] = roles);

(statearr_63731_63775[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (11))){
var inst_63670 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63733_63776 = state_63702__$1;
(statearr_63733_63776[(2)] = inst_63670);

(statearr_63733_63776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (9))){
var state_63702__$1 = state_63702;
var statearr_63734_63777 = state_63702__$1;
(statearr_63734_63777[(2)] = (0));

(statearr_63734_63777[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (5))){
var _ = (function (){var statearr_63735 = state_63702;
(statearr_63735[(4)] = cljs.core.rest((state_63702[(4)])));

return statearr_63735;
})();
var state_63702__$1 = state_63702;
var ex63732 = (state_63702__$1[(2)]);
var statearr_63736_63778 = state_63702__$1;
(statearr_63736_63778[(5)] = ex63732);


if((ex63732 instanceof Error)){
var statearr_63737_63779 = state_63702__$1;
(statearr_63737_63779[(1)] = (4));

(statearr_63737_63779[(5)] = null);

} else {
throw ex63732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (14))){
var inst_63668 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63738_63780 = state_63702__$1;
(statearr_63738_63780[(2)] = inst_63668);

(statearr_63738_63780[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (26))){
var state_63702__$1 = state_63702;
var statearr_63739_63781 = state_63702__$1;
(statearr_63739_63781[(2)] = null);

(statearr_63739_63781[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (16))){
var inst_63655 = (state_63702[(8)]);
var state_63702__$1 = state_63702;
var statearr_63740_63782 = state_63702__$1;
(statearr_63740_63782[(2)] = inst_63655);

(statearr_63740_63782[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (30))){
var state_63702__$1 = state_63702;
var statearr_63741_63783 = state_63702__$1;
(statearr_63741_63783[(2)] = null);

(statearr_63741_63783[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (10))){
var state_63702__$1 = state_63702;
if(cljs.core.truth_(auth)){
var statearr_63742_63784 = state_63702__$1;
(statearr_63742_63784[(1)] = (12));

} else {
var statearr_63743_63785 = state_63702__$1;
(statearr_63743_63785[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (18))){
var inst_63665 = (state_63702[(2)]);
var state_63702__$1 = state_63702;
var statearr_63744_63786 = state_63702__$1;
(statearr_63744_63786[(2)] = inst_63665);

(statearr_63744_63786[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63703 === (8))){
var inst_63672 = (state_63702[(2)]);
var state_63702__$1 = (function (){var statearr_63745 = state_63702;
(statearr_63745[(7)] = inst_63672);

return statearr_63745;
})();
if(cljs.core.truth_(roles)){
var statearr_63746_63787 = state_63702__$1;
(statearr_63746_63787[(1)] = (19));

} else {
var statearr_63747_63788 = state_63702__$1;
(statearr_63747_63788[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0 = (function (){
var statearr_63748 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63748[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__);

(statearr_63748[(1)] = (1));

return statearr_63748;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1 = (function (state_63702){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63702);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63749){var ex__2417__auto__ = e63749;
var statearr_63750_63789 = state_63702;
(statearr_63750_63789[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63702[(4)]))){
var statearr_63751_63790 = state_63702;
(statearr_63751_63790[(1)] = cljs.core.first((state_63702[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63791 = state_63702;
state_63702 = G__63791;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__ = function(state_63702){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1.call(this,state_63702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63752 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63752[(6)] = c__2436__auto__);

return statearr_63752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__63792 = db;
var map__63792__$1 = (((((!((map__63792 == null))))?(((((map__63792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63792):map__63792);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63792__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63792__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63792__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63800){
var state_val_63801 = (state_63800[(1)]);
if((state_val_63801 === (1))){
var inst_63794 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63795 = fluree.db.session.db(conn,inst_63794,null);
var state_63800__$1 = state_63800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63800__$1,(2),inst_63795);
} else {
if((state_val_63801 === (2))){
var inst_63797 = (state_63800[(2)]);
var inst_63798 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63797);
var state_63800__$1 = state_63800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63800__$1,inst_63798);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0 = (function (){
var statearr_63802 = [null,null,null,null,null,null,null];
(statearr_63802[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__);

(statearr_63802[(1)] = (1));

return statearr_63802;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1 = (function (state_63800){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63800);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63803){var ex__2417__auto__ = e63803;
var statearr_63804_63831 = state_63800;
(statearr_63804_63831[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63800[(4)]))){
var statearr_63805_63832 = state_63800;
(statearr_63805_63832[(1)] = cljs.core.first((state_63800[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63833 = state_63800;
state_63800 = G__63833;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = function(state_63800){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1.call(this,state_63800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63806 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63806[(6)] = c__2436__auto__);

return statearr_63806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63819){
var state_val_63820 = (state_63819[(1)]);
if((state_val_63820 === (1))){
var inst_63807 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63808 = fluree.db.session.db(conn,inst_63807,null);
var state_63819__$1 = state_63819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63819__$1,(2),inst_63808);
} else {
if((state_val_63820 === (2))){
var inst_63810 = (state_63819[(7)]);
var inst_63810__$1 = (state_63819[(2)]);
var inst_63811 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63810__$1);
var inst_63812 = newer_block_QMARK_(inst_63811);
var state_63819__$1 = (function (){var statearr_63821 = state_63819;
(statearr_63821[(7)] = inst_63810__$1);

return statearr_63821;
})();
if(inst_63812){
var statearr_63822_63834 = state_63819__$1;
(statearr_63822_63834[(1)] = (3));

} else {
var statearr_63823_63835 = state_63819__$1;
(statearr_63823_63835[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63820 === (3))){
var inst_63810 = (state_63819[(7)]);
var inst_63814 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63810);
var state_63819__$1 = state_63819;
var statearr_63824_63836 = state_63819__$1;
(statearr_63824_63836[(2)] = inst_63814);

(statearr_63824_63836[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63820 === (4))){
var state_63819__$1 = state_63819;
var statearr_63825_63837 = state_63819__$1;
(statearr_63825_63837[(2)] = null);

(statearr_63825_63837[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63820 === (5))){
var inst_63817 = (state_63819[(2)]);
var state_63819__$1 = state_63819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63819__$1,inst_63817);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0 = (function (){
var statearr_63826 = [null,null,null,null,null,null,null,null];
(statearr_63826[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__);

(statearr_63826[(1)] = (1));

return statearr_63826;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1 = (function (state_63819){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63819);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63827){var ex__2417__auto__ = e63827;
var statearr_63828_63838 = state_63819;
(statearr_63828_63838[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63819[(4)]))){
var statearr_63829_63839 = state_63819;
(statearr_63829_63839[(1)] = cljs.core.first((state_63819[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63840 = state_63819;
state_63819 = G__63840;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = function(state_63819){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1.call(this,state_63819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63830 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63830[(6)] = c__2436__auto__);

return statearr_63830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__63841 = db;
var map__63841__$1 = (((((!((map__63841 == null))))?(((((map__63841.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63841.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63841):map__63841);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63841__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2436__auto___63918 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63892){
var state_val_63893 = (state_63892[(1)]);
if((state_val_63893 === (7))){
var inst_63858 = (state_63892[(7)]);
var inst_63869 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63858,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63892__$1 = state_63892;
if(inst_63869){
var statearr_63894_63919 = state_63892__$1;
(statearr_63894_63919[(1)] = (9));

} else {
var statearr_63895_63920 = state_63892__$1;
(statearr_63895_63920[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (1))){
var inst_63851 = (state_63892[(8)]);
var inst_63843 = (state_63892[(9)]);
var inst_63843__$1 = cljs.core.async.timeout(timeout);
var inst_63851__$1 = res_port;
var inst_63852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63853 = [inst_63843__$1,inst_63851__$1];
var inst_63854 = (new cljs.core.PersistentVector(null,2,(5),inst_63852,inst_63853,null));
var state_63892__$1 = (function (){var statearr_63896 = state_63892;
(statearr_63896[(8)] = inst_63851__$1);

(statearr_63896[(9)] = inst_63843__$1);

return statearr_63896;
})();
return cljs.core.async.ioc_alts_BANG_(state_63892__$1,(2),inst_63854);
} else {
if((state_val_63893 === (4))){
var inst_63851 = (state_63892[(8)]);
var inst_63858 = (state_63892[(7)]);
var inst_63862 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63858,inst_63851);
var state_63892__$1 = state_63892;
if(inst_63862){
var statearr_63897_63921 = state_63892__$1;
(statearr_63897_63921[(1)] = (6));

} else {
var statearr_63898_63922 = state_63892__$1;
(statearr_63898_63922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (13))){
var inst_63877 = (state_63892[(10)]);
var inst_63888 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63877);
var state_63892__$1 = state_63892;
var statearr_63899_63923 = state_63892__$1;
(statearr_63899_63923[(2)] = inst_63888);

(statearr_63899_63923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (6))){
var inst_63856 = (state_63892[(11)]);
var inst_63867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63856,(0),null);
var state_63892__$1 = state_63892;
var statearr_63900_63924 = state_63892__$1;
(statearr_63900_63924[(2)] = inst_63867);

(statearr_63900_63924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (3))){
var state_63892__$1 = state_63892;
var statearr_63901_63925 = state_63892__$1;
(statearr_63901_63925[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_63901_63925[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (12))){
var inst_63881 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_63882 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63883 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63884 = cljs.core.PersistentHashMap.fromArrays(inst_63882,inst_63883);
var inst_63885 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63881,inst_63884);
var inst_63886 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63885);
var state_63892__$1 = state_63892;
var statearr_63902_63926 = state_63892__$1;
(statearr_63902_63926[(2)] = inst_63886);

(statearr_63902_63926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (2))){
var inst_63856 = (state_63892[(11)]);
var inst_63858 = (state_63892[(7)]);
var inst_63843 = (state_63892[(9)]);
var inst_63856__$1 = (state_63892[(2)]);
var inst_63857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63856__$1,(0),null);
var inst_63858__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63856__$1,(1),null);
var inst_63859 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63858__$1,inst_63843);
var state_63892__$1 = (function (){var statearr_63903 = state_63892;
(statearr_63903[(11)] = inst_63856__$1);

(statearr_63903[(12)] = inst_63857);

(statearr_63903[(7)] = inst_63858__$1);

return statearr_63903;
})();
if(inst_63859){
var statearr_63904_63927 = state_63892__$1;
(statearr_63904_63927[(1)] = (3));

} else {
var statearr_63905_63928 = state_63892__$1;
(statearr_63905_63928[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (11))){
var inst_63873 = (state_63892[(2)]);
var state_63892__$1 = state_63892;
var statearr_63906_63929 = state_63892__$1;
(statearr_63906_63929[(2)] = inst_63873);

(statearr_63906_63929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (9))){
var inst_63857 = (state_63892[(12)]);
var state_63892__$1 = state_63892;
var statearr_63907_63930 = state_63892__$1;
(statearr_63907_63930[(2)] = inst_63857);

(statearr_63907_63930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (5))){
var inst_63877 = (state_63892[(10)]);
var inst_63877__$1 = (state_63892[(2)]);
var inst_63878 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_63879 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_63877__$1);
var state_63892__$1 = (function (){var statearr_63908 = state_63892;
(statearr_63908[(10)] = inst_63877__$1);

(statearr_63908[(13)] = inst_63878);

return statearr_63908;
})();
if(inst_63879){
var statearr_63909_63931 = state_63892__$1;
(statearr_63909_63931[(1)] = (12));

} else {
var statearr_63910_63932 = state_63892__$1;
(statearr_63910_63932[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (14))){
var inst_63890 = (state_63892[(2)]);
var state_63892__$1 = state_63892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63892__$1,inst_63890);
} else {
if((state_val_63893 === (10))){
var state_63892__$1 = state_63892;
var statearr_63911_63933 = state_63892__$1;
(statearr_63911_63933[(2)] = null);

(statearr_63911_63933[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63893 === (8))){
var inst_63875 = (state_63892[(2)]);
var state_63892__$1 = state_63892;
var statearr_63912_63934 = state_63892__$1;
(statearr_63912_63934[(2)] = inst_63875);

(statearr_63912_63934[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0 = (function (){
var statearr_63913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63913[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__);

(statearr_63913[(1)] = (1));

return statearr_63913;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1 = (function (state_63892){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63892);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63914){var ex__2417__auto__ = e63914;
var statearr_63915_63935 = state_63892;
(statearr_63915_63935[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63892[(4)]))){
var statearr_63916_63936 = state_63892;
(statearr_63916_63936[(1)] = cljs.core.first((state_63892[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63937 = state_63892;
state_63892 = G__63937;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__ = function(state_63892){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1.call(this,state_63892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63917 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63917[(6)] = c__2436__auto___63918);

return statearr_63917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__63939 = arguments.length;
switch (G__63939) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__63940){
var map__63941 = p__63940;
var map__63941__$1 = (((((!((map__63941 == null))))?(((((map__63941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63941):map__63941);
var opts = map__63941__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63941__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63941__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63941__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63941__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63941__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___64031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63993){
var state_val_63994 = (state_63993[(1)]);
if((state_val_63994 === (7))){
var inst_63955 = (state_63993[(7)]);
var inst_63957 = fluree.db.api.ledger.syncTo_db(inst_63955,syncTo,syncTimeout);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63993__$1,(10),inst_63957);
} else {
if((state_val_63994 === (20))){
var inst_63979 = (state_63993[(8)]);
var state_63993__$1 = state_63993;
var statearr_63995_64032 = state_63993__$1;
(statearr_63995_64032[(2)] = inst_63979);

(statearr_63995_64032[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (1))){
var state_63993__$1 = state_63993;
var statearr_63996_64033 = state_63993__$1;
(statearr_63996_64033[(2)] = null);

(statearr_63996_64033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (4))){
var inst_63943 = (state_63993[(2)]);
var inst_63944 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63943);
var inst_63945 = cljs.core.async.close_BANG_(pc);
var state_63993__$1 = (function (){var statearr_63997 = state_63993;
(statearr_63997[(9)] = inst_63944);

return statearr_63997;
})();
var statearr_63998_64034 = state_63993__$1;
(statearr_63998_64034[(2)] = inst_63945);

(statearr_63998_64034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (15))){
var inst_63971 = (state_63993[(10)]);
var inst_63973 = fluree.db.api.ledger.add_db_permissions(inst_63971,auth,roles);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63993__$1,(18),inst_63973);
} else {
if((state_val_63994 === (21))){
var inst_63987 = (state_63993[(2)]);
var inst_63988 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63987);
var _ = (function (){var statearr_63999 = state_63993;
(statearr_63999[(4)] = cljs.core.rest((state_63993[(4)])));

return statearr_63999;
})();
var state_63993__$1 = state_63993;
var statearr_64000_64035 = state_63993__$1;
(statearr_64000_64035[(2)] = inst_63988);

(statearr_64000_64035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (13))){
var inst_63971 = (state_63993[(2)]);
var state_63993__$1 = (function (){var statearr_64001 = state_63993;
(statearr_64001[(10)] = inst_63971);

return statearr_64001;
})();
if(cljs.core.truth_(roles)){
var statearr_64002_64036 = state_63993__$1;
(statearr_64002_64036[(1)] = (15));

} else {
var statearr_64003_64037 = state_63993__$1;
(statearr_64003_64037[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (22))){
var inst_63983 = (state_63993[(2)]);
var inst_63984 = fluree.db.util.async.throw_err(inst_63983);
var state_63993__$1 = state_63993;
var statearr_64004_64038 = state_63993__$1;
(statearr_64004_64038[(2)] = inst_63984);

(statearr_64004_64038[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (6))){
var inst_63954 = (state_63993[(2)]);
var inst_63955 = fluree.db.util.async.throw_err(inst_63954);
var state_63993__$1 = (function (){var statearr_64005 = state_63993;
(statearr_64005[(7)] = inst_63955);

return statearr_64005;
})();
if(cljs.core.truth_(syncTo)){
var statearr_64006_64039 = state_63993__$1;
(statearr_64006_64039[(1)] = (7));

} else {
var statearr_64007_64040 = state_63993__$1;
(statearr_64007_64040[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (17))){
var inst_63979 = (state_63993[(2)]);
var state_63993__$1 = (function (){var statearr_64008 = state_63993;
(statearr_64008[(8)] = inst_63979);

return statearr_64008;
})();
if(cljs.core.truth_(auth)){
var statearr_64009_64041 = state_63993__$1;
(statearr_64009_64041[(1)] = (19));

} else {
var statearr_64010_64042 = state_63993__$1;
(statearr_64010_64042[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (3))){
var inst_63991 = (state_63993[(2)]);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63993__$1,inst_63991);
} else {
if((state_val_63994 === (12))){
var inst_63963 = (state_63993[(11)]);
var state_63993__$1 = state_63993;
var statearr_64011_64043 = state_63993__$1;
(statearr_64011_64043[(2)] = inst_63963);

(statearr_64011_64043[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (2))){
var _ = (function (){var statearr_64012 = state_63993;
(statearr_64012[(4)] = cljs.core.cons((5),(state_63993[(4)])));

return statearr_64012;
})();
var inst_63952 = fluree.db.session.db(conn,ledger,null);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63993__$1,(6),inst_63952);
} else {
if((state_val_63994 === (19))){
var inst_63979 = (state_63993[(8)]);
var inst_63981 = fluree.db.api.ledger.add_db_permissions(inst_63979,auth,roles);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63993__$1,(22),inst_63981);
} else {
if((state_val_63994 === (11))){
var inst_63963 = (state_63993[(11)]);
var inst_63965 = fluree.db.time_travel.as_of_block(inst_63963,block);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63993__$1,(14),inst_63965);
} else {
if((state_val_63994 === (9))){
var inst_63963 = (state_63993[(2)]);
var state_63993__$1 = (function (){var statearr_64014 = state_63993;
(statearr_64014[(11)] = inst_63963);

return statearr_64014;
})();
if(cljs.core.truth_(block)){
var statearr_64015_64044 = state_63993__$1;
(statearr_64015_64044[(1)] = (11));

} else {
var statearr_64016_64045 = state_63993__$1;
(statearr_64016_64045[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (5))){
var _ = (function (){var statearr_64017 = state_63993;
(statearr_64017[(4)] = cljs.core.rest((state_63993[(4)])));

return statearr_64017;
})();
var state_63993__$1 = state_63993;
var ex64013 = (state_63993__$1[(2)]);
var statearr_64018_64046 = state_63993__$1;
(statearr_64018_64046[(5)] = ex64013);


var statearr_64019_64047 = state_63993__$1;
(statearr_64019_64047[(1)] = (4));

(statearr_64019_64047[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (14))){
var inst_63967 = (state_63993[(2)]);
var inst_63968 = fluree.db.util.async.throw_err(inst_63967);
var state_63993__$1 = state_63993;
var statearr_64020_64048 = state_63993__$1;
(statearr_64020_64048[(2)] = inst_63968);

(statearr_64020_64048[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (16))){
var inst_63971 = (state_63993[(10)]);
var state_63993__$1 = state_63993;
var statearr_64021_64049 = state_63993__$1;
(statearr_64021_64049[(2)] = inst_63971);

(statearr_64021_64049[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (10))){
var inst_63959 = (state_63993[(2)]);
var inst_63960 = fluree.db.util.async.throw_err(inst_63959);
var state_63993__$1 = state_63993;
var statearr_64022_64050 = state_63993__$1;
(statearr_64022_64050[(2)] = inst_63960);

(statearr_64022_64050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (18))){
var inst_63975 = (state_63993[(2)]);
var inst_63976 = fluree.db.util.async.throw_err(inst_63975);
var state_63993__$1 = state_63993;
var statearr_64023_64051 = state_63993__$1;
(statearr_64023_64051[(2)] = inst_63976);

(statearr_64023_64051[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (8))){
var inst_63955 = (state_63993[(7)]);
var state_63993__$1 = state_63993;
var statearr_64024_64052 = state_63993__$1;
(statearr_64024_64052[(2)] = inst_63955);

(statearr_64024_64052[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2414__auto__ = null;
var fluree$db$api$ledger$state_machine__2414__auto____0 = (function (){
var statearr_64025 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64025[(0)] = fluree$db$api$ledger$state_machine__2414__auto__);

(statearr_64025[(1)] = (1));

return statearr_64025;
});
var fluree$db$api$ledger$state_machine__2414__auto____1 = (function (state_63993){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63993);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64026){var ex__2417__auto__ = e64026;
var statearr_64027_64053 = state_63993;
(statearr_64027_64053[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63993[(4)]))){
var statearr_64028_64054 = state_63993;
(statearr_64028_64054[(1)] = cljs.core.first((state_63993[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64055 = state_63993;
state_63993 = G__64055;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2414__auto__ = function(state_63993){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2414__auto____1.call(this,state_63993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2414__auto____0;
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2414__auto____1;
return fluree$db$api$ledger$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64029 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64029[(6)] = c__2436__auto___64031);

return statearr_64029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

