// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27090,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27094 = k27090;
var G__27094__$1 = (((G__27094 instanceof cljs.core.Keyword))?G__27094.fqn:null);
switch (G__27094__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27090,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27095){
var vec__27096 = p__27095;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27096,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27096,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27089){
var self__ = this;
var G__27089__$1 = this;
return (new cljs.core.RecordIter((0),G__27089__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__27099 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__27099(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27091,other27092){
var self__ = this;
var this27091__$1 = this;
return (((!((other27092 == null)))) && ((this27091__$1.constructor === other27092.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.conn,other27092.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.network,other27092.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.dbid,other27092.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.db_name,other27092.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.update_chan,other27092.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.transact_chan,other27092.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.state,other27092.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.schema_cache,other27092.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.blank_db,other27092.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.close,other27092.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.id,other27092.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27091__$1.__extmap,other27092.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27089){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27100 = cljs.core.keyword_identical_QMARK_;
var expr__27101 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__27103 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27104 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27103,G__27104) : pred__27100.call(null,G__27103,G__27104));
})())){
return (new fluree.db.session.DbSession(G__27089,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27105 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27106 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27105,G__27106) : pred__27100.call(null,G__27105,G__27106));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27089,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27107 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27108 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27107,G__27108) : pred__27100.call(null,G__27107,G__27108));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27089,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27109 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27110 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27109,G__27110) : pred__27100.call(null,G__27109,G__27110));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27089,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27111 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27112 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27111,G__27112) : pred__27100.call(null,G__27111,G__27112));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27089,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27113 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27114 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27113,G__27114) : pred__27100.call(null,G__27113,G__27114));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27089,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27115 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27116 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27115,G__27116) : pred__27100.call(null,G__27115,G__27116));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27089,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27117 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27118 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27117,G__27118) : pred__27100.call(null,G__27117,G__27118));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27089,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27119 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27120 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27119,G__27120) : pred__27100.call(null,G__27119,G__27120));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27089,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27121 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27122 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27121,G__27122) : pred__27100.call(null,G__27121,G__27122));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27089,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27123 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27124 = expr__27101;
return (pred__27100.cljs$core$IFn$_invoke$arity$2 ? pred__27100.cljs$core$IFn$_invoke$arity$2(G__27123,G__27124) : pred__27100.call(null,G__27123,G__27124));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27089,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27089),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27089){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27089,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27093){
var extmap__4419__auto__ = (function (){var G__27125 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27093,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27093)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27125);
} else {
return G__27125;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27093),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27093),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27127 = session;
var map__27127__$1 = (((((!((map__27127 == null))))?(((((map__27127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27127.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27127):map__27127);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27127__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27127__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___27345 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27272){
var state_val_27273 = (state_27272[(1)]);
if((state_val_27273 === (7))){
var state_27272__$1 = state_27272;
var statearr_27274_27346 = state_27272__$1;
(statearr_27274_27346[(2)] = false);

(statearr_27274_27346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (20))){
var inst_27162 = (state_27272[(7)]);
var inst_27169 = (state_27272[(8)]);
var inst_27161 = (state_27272[(9)]);
var inst_27178 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27169);
var inst_27179 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27161),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27162)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27178),"."].join('');
var state_27272__$1 = state_27272;
var statearr_27275_27347 = state_27272__$1;
(statearr_27275_27347[(2)] = inst_27179);

(statearr_27275_27347[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (27))){
var inst_27253 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27276_27348 = state_27272__$1;
(statearr_27276_27348[(2)] = inst_27253);

(statearr_27276_27348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (1))){
var state_27272__$1 = state_27272;
var statearr_27277_27349 = state_27272__$1;
(statearr_27277_27349[(2)] = null);

(statearr_27277_27349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (24))){
var state_27272__$1 = state_27272;
var statearr_27278_27350 = state_27272__$1;
(statearr_27278_27350[(2)] = null);

(statearr_27278_27350[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (39))){
var state_27272__$1 = state_27272;
var statearr_27279_27351 = state_27272__$1;
(statearr_27279_27351[(2)] = false);

(statearr_27279_27351[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (46))){
var inst_27261 = (state_27272[(10)]);
var inst_27264 = (state_27272[(2)]);
var inst_27265 = fluree.db.util.async.throw_err(inst_27264);
var inst_27266 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27261,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27265);
var inst_27267 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27266);
var _ = (function (){var statearr_27280 = state_27272;
(statearr_27280[(4)] = cljs.core.rest((state_27272[(4)])));

return statearr_27280;
})();
var state_27272__$1 = state_27272;
var statearr_27281_27352 = state_27272__$1;
(statearr_27281_27352[(2)] = inst_27267);

(statearr_27281_27352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (4))){
var inst_27129 = (state_27272[(2)]);
var inst_27130 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27129);
var state_27272__$1 = state_27272;
var statearr_27282_27353 = state_27272__$1;
(statearr_27282_27353[(2)] = inst_27130);

(statearr_27282_27353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (15))){
var inst_27169 = (state_27272[(8)]);
var inst_27168 = (state_27272[(2)]);
var inst_27169__$1 = fluree.db.util.async.throw_err(inst_27168);
var inst_27170 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27169__$1);
var inst_27171 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27170);
var inst_27172 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27171);
var state_27272__$1 = (function (){var statearr_27283 = state_27272;
(statearr_27283[(8)] = inst_27169__$1);

return statearr_27283;
})();
if(inst_27172){
var statearr_27284_27354 = state_27272__$1;
(statearr_27284_27354[(1)] = (16));

} else {
var statearr_27285_27355 = state_27272__$1;
(statearr_27285_27355[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (21))){
var inst_27181 = (state_27272[(2)]);
var inst_27182 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27183 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27184 = cljs.core.PersistentHashMap.fromArrays(inst_27182,inst_27183);
var inst_27185 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27181,inst_27184);
var inst_27186 = (function(){throw inst_27185})();
var state_27272__$1 = state_27272;
var statearr_27286_27356 = state_27272__$1;
(statearr_27286_27356[(2)] = inst_27186);

(statearr_27286_27356[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (31))){
var inst_27208 = (state_27272[(11)]);
var inst_27207 = (state_27272[(2)]);
var inst_27208__$1 = fluree.db.util.async.throw_err(inst_27207);
var state_27272__$1 = (function (){var statearr_27287 = state_27272;
(statearr_27287[(11)] = inst_27208__$1);

return statearr_27287;
})();
if(cljs.core.truth_(inst_27208__$1)){
var statearr_27288_27357 = state_27272__$1;
(statearr_27288_27357[(1)] = (32));

} else {
var statearr_27289_27358 = state_27272__$1;
(statearr_27289_27358[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (32))){
var inst_27208 = (state_27272[(11)]);
var inst_27212 = (inst_27208 == null);
var inst_27213 = cljs.core.not(inst_27212);
var state_27272__$1 = state_27272;
if(inst_27213){
var statearr_27290_27359 = state_27272__$1;
(statearr_27290_27359[(1)] = (35));

} else {
var statearr_27291_27360 = state_27272__$1;
(statearr_27291_27360[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (40))){
var inst_27223 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27292_27361 = state_27272__$1;
(statearr_27292_27361[(2)] = inst_27223);

(statearr_27292_27361[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (33))){
var inst_27162 = (state_27272[(7)]);
var inst_27161 = (state_27272[(9)]);
var inst_27200 = (state_27272[(12)]);
var inst_27242 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27200)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27161),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27162),"."].join('');
var inst_27243 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27244 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27245 = cljs.core.PersistentHashMap.fromArrays(inst_27243,inst_27244);
var inst_27246 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27242,inst_27245);
var inst_27247 = (function(){throw inst_27246})();
var state_27272__$1 = state_27272;
var statearr_27293_27362 = state_27272__$1;
(statearr_27293_27362[(2)] = inst_27247);

(statearr_27293_27362[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (13))){
var inst_27138 = (state_27272[(13)]);
var state_27272__$1 = state_27272;
var statearr_27294_27363 = state_27272__$1;
(statearr_27294_27363[(2)] = inst_27138);

(statearr_27294_27363[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (22))){
var inst_27169 = (state_27272[(8)]);
var inst_27194 = (state_27272[(14)]);
var inst_27193 = (state_27272[(2)]);
var inst_27194__$1 = fluree.db.util.async.throw_err(inst_27193);
var inst_27195 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27169);
var state_27272__$1 = (function (){var statearr_27295 = state_27272;
(statearr_27295[(15)] = inst_27195);

(statearr_27295[(14)] = inst_27194__$1);

return statearr_27295;
})();
if(cljs.core.truth_(inst_27194__$1)){
var statearr_27296_27364 = state_27272__$1;
(statearr_27296_27364[(1)] = (23));

} else {
var statearr_27297_27365 = state_27272__$1;
(statearr_27297_27365[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (36))){
var state_27272__$1 = state_27272;
var statearr_27298_27366 = state_27272__$1;
(statearr_27298_27366[(2)] = false);

(statearr_27298_27366[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (41))){
var inst_27208 = (state_27272[(11)]);
var inst_27228 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27208);
var state_27272__$1 = state_27272;
var statearr_27299_27367 = state_27272__$1;
(statearr_27299_27367[(2)] = inst_27228);

(statearr_27299_27367[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (43))){
var inst_27199 = (state_27272[(16)]);
var inst_27231 = (state_27272[(2)]);
var inst_27232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27231,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27231,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27231,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27235 = fluree.db.dbproto._with(inst_27199,inst_27233,inst_27232);
var state_27272__$1 = (function (){var statearr_27300 = state_27272;
(statearr_27300[(17)] = inst_27234);

return statearr_27300;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(44),inst_27235);
} else {
if((state_val_27273 === (29))){
var inst_27160 = (state_27272[(18)]);
var inst_27162 = (state_27272[(7)]);
var inst_27161 = (state_27272[(9)]);
var inst_27200 = (state_27272[(12)]);
var inst_27205 = fluree.db.storage.core.read_block(inst_27160,inst_27161,inst_27162,inst_27200);
var state_27272__$1 = state_27272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(31),inst_27205);
} else {
if((state_val_27273 === (44))){
var inst_27200 = (state_27272[(12)]);
var inst_27237 = (state_27272[(2)]);
var inst_27238 = fluree.db.util.async.throw_err(inst_27237);
var inst_27239 = (inst_27200 + (1));
var inst_27199 = inst_27238;
var inst_27200__$1 = inst_27239;
var state_27272__$1 = (function (){var statearr_27301 = state_27272;
(statearr_27301[(16)] = inst_27199);

(statearr_27301[(12)] = inst_27200__$1);

return statearr_27301;
})();
var statearr_27302_27368 = state_27272__$1;
(statearr_27302_27368[(2)] = null);

(statearr_27302_27368[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (6))){
var inst_27138 = (state_27272[(13)]);
var inst_27143 = inst_27138.cljs$lang$protocol_mask$partition0$;
var inst_27144 = (inst_27143 & (64));
var inst_27145 = inst_27138.cljs$core$ISeq$;
var inst_27146 = (cljs.core.PROTOCOL_SENTINEL === inst_27145);
var inst_27147 = ((inst_27144) || (inst_27146));
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27147)){
var statearr_27303_27369 = state_27272__$1;
(statearr_27303_27369[(1)] = (9));

} else {
var statearr_27304_27370 = state_27272__$1;
(statearr_27304_27370[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (28))){
var inst_27199 = (state_27272[(16)]);
var state_27272__$1 = state_27272;
var statearr_27305_27371 = state_27272__$1;
(statearr_27305_27371[(2)] = inst_27199);

(statearr_27305_27371[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (25))){
var inst_27256 = (state_27272[(19)]);
var inst_27256__$1 = (state_27272[(2)]);
var inst_27257 = fluree.db.query.schema.schema_map(inst_27256__$1);
var state_27272__$1 = (function (){var statearr_27306 = state_27272;
(statearr_27306[(19)] = inst_27256__$1);

return statearr_27306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(45),inst_27257);
} else {
if((state_val_27273 === (34))){
var inst_27249 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27307_27372 = state_27272__$1;
(statearr_27307_27372[(2)] = inst_27249);

(statearr_27307_27372[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (17))){
var state_27272__$1 = state_27272;
var statearr_27308_27373 = state_27272__$1;
(statearr_27308_27373[(2)] = null);

(statearr_27308_27373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (3))){
var inst_27270 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27272__$1,inst_27270);
} else {
if((state_val_27273 === (12))){
var inst_27138 = (state_27272[(13)]);
var inst_27156 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27138);
var state_27272__$1 = state_27272;
var statearr_27309_27374 = state_27272__$1;
(statearr_27309_27374[(2)] = inst_27156);

(statearr_27309_27374[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (2))){
var inst_27138 = (state_27272[(13)]);
var _ = (function (){var statearr_27310 = state_27272;
(statearr_27310[(4)] = cljs.core.cons((5),(state_27272[(4)])));

return statearr_27310;
})();
var inst_27137 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27138__$1 = session;
var inst_27140 = (inst_27138__$1 == null);
var inst_27141 = cljs.core.not(inst_27140);
var state_27272__$1 = (function (){var statearr_27311 = state_27272;
(statearr_27311[(20)] = inst_27137);

(statearr_27311[(13)] = inst_27138__$1);

return statearr_27311;
})();
if(inst_27141){
var statearr_27312_27375 = state_27272__$1;
(statearr_27312_27375[(1)] = (6));

} else {
var statearr_27313_27376 = state_27272__$1;
(statearr_27313_27376[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (23))){
var inst_27194 = (state_27272[(14)]);
var inst_27197 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27194);
var inst_27198 = (inst_27197 + (1));
var inst_27199 = inst_27194;
var inst_27200 = inst_27198;
var state_27272__$1 = (function (){var statearr_27314 = state_27272;
(statearr_27314[(16)] = inst_27199);

(statearr_27314[(12)] = inst_27200);

return statearr_27314;
})();
var statearr_27315_27377 = state_27272__$1;
(statearr_27315_27377[(2)] = null);

(statearr_27315_27377[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (35))){
var inst_27208 = (state_27272[(11)]);
var inst_27215 = inst_27208.cljs$lang$protocol_mask$partition0$;
var inst_27216 = (inst_27215 & (64));
var inst_27217 = inst_27208.cljs$core$ISeq$;
var inst_27218 = (cljs.core.PROTOCOL_SENTINEL === inst_27217);
var inst_27219 = ((inst_27216) || (inst_27218));
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27219)){
var statearr_27316_27378 = state_27272__$1;
(statearr_27316_27378[(1)] = (38));

} else {
var statearr_27317_27379 = state_27272__$1;
(statearr_27317_27379[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (19))){
var inst_27162 = (state_27272[(7)]);
var inst_27161 = (state_27272[(9)]);
var inst_27176 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27161),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27162)," is not found on this ledger group."].join('');
var state_27272__$1 = state_27272;
var statearr_27318_27380 = state_27272__$1;
(statearr_27318_27380[(2)] = inst_27176);

(statearr_27318_27380[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (11))){
var inst_27151 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27320_27381 = state_27272__$1;
(statearr_27320_27381[(2)] = inst_27151);

(statearr_27320_27381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (9))){
var state_27272__$1 = state_27272;
var statearr_27321_27382 = state_27272__$1;
(statearr_27321_27382[(2)] = true);

(statearr_27321_27382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (5))){
var _ = (function (){var statearr_27322 = state_27272;
(statearr_27322[(4)] = cljs.core.rest((state_27272[(4)])));

return statearr_27322;
})();
var state_27272__$1 = state_27272;
var ex27319 = (state_27272__$1[(2)]);
var statearr_27323_27383 = state_27272__$1;
(statearr_27323_27383[(5)] = ex27319);


var statearr_27324_27384 = state_27272__$1;
(statearr_27324_27384[(1)] = (4));

(statearr_27324_27384[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (14))){
var inst_27160 = (state_27272[(18)]);
var inst_27162 = (state_27272[(7)]);
var inst_27161 = (state_27272[(9)]);
var inst_27159 = (state_27272[(2)]);
var inst_27160__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27159,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27161__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27159,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27162__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27159,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27164 = [inst_27161__$1,inst_27162__$1];
var inst_27165 = (new cljs.core.PersistentVector(null,2,(5),inst_27163,inst_27164,null));
var inst_27166 = fluree.db.operations.ledger_info_async(inst_27160__$1,inst_27165);
var state_27272__$1 = (function (){var statearr_27325 = state_27272;
(statearr_27325[(18)] = inst_27160__$1);

(statearr_27325[(7)] = inst_27162__$1);

(statearr_27325[(9)] = inst_27161__$1);

return statearr_27325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(15),inst_27166);
} else {
if((state_val_27273 === (45))){
var inst_27261 = (state_27272[(10)]);
var inst_27256 = (state_27272[(19)]);
var inst_27259 = (state_27272[(2)]);
var inst_27260 = fluree.db.util.async.throw_err(inst_27259);
var inst_27261__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27256,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27260);
var inst_27262 = fluree.db.query.schema.setting_map(inst_27261__$1);
var state_27272__$1 = (function (){var statearr_27326 = state_27272;
(statearr_27326[(10)] = inst_27261__$1);

return statearr_27326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(46),inst_27262);
} else {
if((state_val_27273 === (26))){
var inst_27195 = (state_27272[(15)]);
var inst_27200 = (state_27272[(12)]);
var inst_27202 = (inst_27200 > inst_27195);
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27202)){
var statearr_27327_27385 = state_27272__$1;
(statearr_27327_27385[(1)] = (28));

} else {
var statearr_27328_27386 = state_27272__$1;
(statearr_27328_27386[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (16))){
var inst_27169 = (state_27272[(8)]);
var inst_27174 = cljs.core.empty_QMARK_(inst_27169);
var state_27272__$1 = state_27272;
if(inst_27174){
var statearr_27329_27387 = state_27272__$1;
(statearr_27329_27387[(1)] = (19));

} else {
var statearr_27330_27388 = state_27272__$1;
(statearr_27330_27388[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (38))){
var state_27272__$1 = state_27272;
var statearr_27331_27389 = state_27272__$1;
(statearr_27331_27389[(2)] = true);

(statearr_27331_27389[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (30))){
var inst_27251 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
var statearr_27332_27390 = state_27272__$1;
(statearr_27332_27390[(2)] = inst_27251);

(statearr_27332_27390[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (10))){
var state_27272__$1 = state_27272;
var statearr_27333_27391 = state_27272__$1;
(statearr_27333_27391[(2)] = false);

(statearr_27333_27391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (18))){
var inst_27160 = (state_27272[(18)]);
var inst_27162 = (state_27272[(7)]);
var inst_27169 = (state_27272[(8)]);
var inst_27137 = (state_27272[(20)]);
var inst_27161 = (state_27272[(9)]);
var inst_27189 = (state_27272[(2)]);
var inst_27190 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27169);
var inst_27191 = fluree.db.storage.core.reify_db(inst_27160,inst_27161,inst_27162,inst_27137,inst_27190);
var state_27272__$1 = (function (){var statearr_27334 = state_27272;
(statearr_27334[(21)] = inst_27189);

return statearr_27334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27272__$1,(22),inst_27191);
} else {
if((state_val_27273 === (42))){
var inst_27208 = (state_27272[(11)]);
var state_27272__$1 = state_27272;
var statearr_27335_27392 = state_27272__$1;
(statearr_27335_27392[(2)] = inst_27208);

(statearr_27335_27392[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (37))){
var inst_27226 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27226)){
var statearr_27336_27393 = state_27272__$1;
(statearr_27336_27393[(1)] = (41));

} else {
var statearr_27337_27394 = state_27272__$1;
(statearr_27337_27394[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27273 === (8))){
var inst_27154 = (state_27272[(2)]);
var state_27272__$1 = state_27272;
if(cljs.core.truth_(inst_27154)){
var statearr_27338_27395 = state_27272__$1;
(statearr_27338_27395[(1)] = (12));

} else {
var statearr_27339_27396 = state_27272__$1;
(statearr_27339_27396[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0 = (function (){
var statearr_27340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27340[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__);

(statearr_27340[(1)] = (1));

return statearr_27340;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1 = (function (state_27272){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27272);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27341){var ex__2417__auto__ = e27341;
var statearr_27342_27397 = state_27272;
(statearr_27342_27397[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27272[(4)]))){
var statearr_27343_27398 = state_27272;
(statearr_27343_27398[(1)] = cljs.core.first((state_27272[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27399 = state_27272;
state_27272 = G__27399;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__ = function(state_27272){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1.call(this,state_27272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27344 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27344[(6)] = c__2436__auto___27345);

return statearr_27344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27400 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__27400,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27400;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27401 = cljs.core.get_global_hierarchy;
return (fexpr__27401.cljs$core$IFn$_invoke$arity$0 ? fexpr__27401.cljs$core$IFn$_invoke$arity$0() : fexpr__27401.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27403){
var state_val_27404 = (state_27403[(1)]);
if((state_val_27404 === (1))){
var state_27403__$1 = state_27403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27403__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_27405 = [null,null,null,null,null,null,null];
(statearr_27405[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_27405[(1)] = (1));

return statearr_27405;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_27403){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27403);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27406){var ex__2417__auto__ = e27406;
var statearr_27407_27410 = state_27403;
(statearr_27407_27410[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27403[(4)]))){
var statearr_27408_27411 = state_27403;
(statearr_27408_27411[(1)] = cljs.core.first((state_27403[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27412 = state_27403;
state_27403 = G__27412;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_27403){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_27403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27409 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27409[(6)] = c__2436__auto__);

return statearr_27409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27414){
var map__27415 = p__27414;
var map__27415__$1 = (((((!((map__27415 == null))))?(((((map__27415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27415.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27415):map__27415);
var data = map__27415__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27415__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27415__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27415__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27475){
var state_val_27476 = (state_27475[(1)]);
if((state_val_27476 === (7))){
var inst_27430 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27431 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27432 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27430),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27431),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27433 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27432], 0));
var state_27475__$1 = state_27475;
var statearr_27477_27515 = state_27475__$1;
(statearr_27477_27515[(2)] = inst_27433);

(statearr_27477_27515[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (1))){
var state_27475__$1 = state_27475;
var statearr_27478_27516 = state_27475__$1;
(statearr_27478_27516[(2)] = null);

(statearr_27478_27516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (4))){
var inst_27417 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27479_27517 = state_27475__$1;
(statearr_27479_27517[(2)] = inst_27417);

(statearr_27479_27517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (15))){
var inst_27456 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27480_27518 = state_27475__$1;
(statearr_27480_27518[(2)] = inst_27456);

(statearr_27480_27518[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (13))){
var inst_27447 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27449 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27450 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27451 = [inst_27449,inst_27450];
var inst_27452 = (new cljs.core.PersistentVector(null,2,(5),inst_27448,inst_27451,null));
var inst_27453 = (function (){var G__27481 = inst_27447;
var G__27482 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27483 = inst_27452;
var G__27484 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27481,G__27482,G__27483,G__27484) : fluree.db.conn_events.process_event.call(null,G__27481,G__27482,G__27483,G__27484));
})();
var state_27475__$1 = state_27475;
var statearr_27485_27519 = state_27475__$1;
(statearr_27485_27519[(2)] = inst_27453);

(statearr_27485_27519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (6))){
var inst_27427 = (state_27475[(7)]);
var inst_27426 = (state_27475[(8)]);
var inst_27425 = (state_27475[(2)]);
var inst_27426__$1 = fluree.db.util.async.throw_err(inst_27425);
var inst_27427__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27426__$1);
var inst_27428 = (block <= inst_27427__$1);
var state_27475__$1 = (function (){var statearr_27486 = state_27475;
(statearr_27486[(7)] = inst_27427__$1);

(statearr_27486[(8)] = inst_27426__$1);

return statearr_27486;
})();
if(cljs.core.truth_(inst_27428)){
var statearr_27487_27520 = state_27475__$1;
(statearr_27487_27520[(1)] = (7));

} else {
var statearr_27488_27521 = state_27475__$1;
(statearr_27488_27521[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (17))){
var state_27475__$1 = state_27475;
var statearr_27489_27522 = state_27475__$1;
(statearr_27489_27522[(2)] = null);

(statearr_27489_27522[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (3))){
var inst_27473 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27475__$1,inst_27473);
} else {
if((state_val_27476 === (12))){
var inst_27468 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27490_27523 = state_27475__$1;
(statearr_27490_27523[(2)] = inst_27468);

(statearr_27490_27523[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (2))){
var inst_27423 = (state_27475[(9)]);
var _ = (function (){var statearr_27491 = state_27475;
(statearr_27491[(4)] = cljs.core.cons((5),(state_27475[(4)])));

return statearr_27491;
})();
var inst_27423__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_27475__$1 = (function (){var statearr_27492 = state_27475;
(statearr_27492[(9)] = inst_27423__$1);

return statearr_27492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27475__$1,(6),inst_27423__$1);
} else {
if((state_val_27476 === (11))){
var state_27475__$1 = state_27475;
var statearr_27494_27524 = state_27475__$1;
(statearr_27494_27524[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (9))){
var inst_27470 = (state_27475[(2)]);
var _ = (function (){var statearr_27496 = state_27475;
(statearr_27496[(4)] = cljs.core.rest((state_27475[(4)])));

return statearr_27496;
})();
var state_27475__$1 = state_27475;
var statearr_27497_27525 = state_27475__$1;
(statearr_27497_27525[(2)] = inst_27470);

(statearr_27497_27525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (5))){
var _ = (function (){var statearr_27498 = state_27475;
(statearr_27498[(4)] = cljs.core.rest((state_27475[(4)])));

return statearr_27498;
})();
var state_27475__$1 = state_27475;
var ex27493 = (state_27475__$1[(2)]);
var statearr_27499_27526 = state_27475__$1;
(statearr_27499_27526[(5)] = ex27493);


if((ex27493 instanceof Error)){
var statearr_27500_27527 = state_27475__$1;
(statearr_27500_27527[(1)] = (4));

(statearr_27500_27527[(5)] = null);

} else {
throw ex27493;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (14))){
var state_27475__$1 = state_27475;
var statearr_27501_27528 = state_27475__$1;
(statearr_27501_27528[(2)] = null);

(statearr_27501_27528[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (16))){
var inst_27427 = (state_27475[(7)]);
var inst_27459 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27460 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27461 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27459),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27460),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27427),". Forcing a db reload."].join('');
var inst_27462 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27461], 0));
var inst_27463 = fluree.db.session.reload_db_BANG_(session);
var state_27475__$1 = (function (){var statearr_27502 = state_27475;
(statearr_27502[(10)] = inst_27462);

return statearr_27502;
})();
var statearr_27503_27529 = state_27475__$1;
(statearr_27503_27529[(2)] = inst_27463);

(statearr_27503_27529[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (10))){
var inst_27427 = (state_27475[(7)]);
var inst_27423 = (state_27475[(9)]);
var inst_27426 = (state_27475[(8)]);
var inst_27438 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27439 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27440 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27438),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27439),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27441 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27440], 0));
var inst_27442 = (function (){var current_db_ch = inst_27423;
var current_db = inst_27426;
var current_block = inst_27427;
return (function (p1__27413_SHARP_){
if((p1__27413_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27413_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__27413_SHARP_);
}
});
})();
var inst_27443 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27442,flakes);
var inst_27444 = fluree.db.dbproto._with(inst_27426,block,inst_27443);
var inst_27445 = fluree.db.session.cas_db_BANG_(session,inst_27423,inst_27444);
var state_27475__$1 = (function (){var statearr_27504 = state_27475;
(statearr_27504[(11)] = inst_27441);

return statearr_27504;
})();
if(inst_27445){
var statearr_27505_27530 = state_27475__$1;
(statearr_27505_27530[(1)] = (13));

} else {
var statearr_27506_27531 = state_27475__$1;
(statearr_27506_27531[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (18))){
var inst_27466 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27507_27532 = state_27475__$1;
(statearr_27507_27532[(2)] = inst_27466);

(statearr_27507_27532[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (8))){
var inst_27427 = (state_27475[(7)]);
var inst_27435 = ((1) + inst_27427);
var inst_27436 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27435);
var state_27475__$1 = state_27475;
if(inst_27436){
var statearr_27508_27533 = state_27475__$1;
(statearr_27508_27533[(1)] = (10));

} else {
var statearr_27509_27534 = state_27475__$1;
(statearr_27509_27534[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_27510 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27510[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_27510[(1)] = (1));

return statearr_27510;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_27475){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27475);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27511){var ex__2417__auto__ = e27511;
var statearr_27512_27535 = state_27475;
(statearr_27512_27535[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27475[(4)]))){
var statearr_27513_27536 = state_27475;
(statearr_27513_27536[(1)] = cljs.core.first((state_27475[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27537 = state_27475;
state_27475 = G__27537;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_27475){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_27475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27514 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27514[(6)] = c__2436__auto__);

return statearr_27514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27544){
var state_val_27545 = (state_27544[(1)]);
if((state_val_27545 === (1))){
var inst_27538 = fluree.db.session.clear_db_BANG_(session);
var inst_27539 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27540 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27541 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27539),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27540)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27542 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27541], 0));
var state_27544__$1 = (function (){var statearr_27546 = state_27544;
(statearr_27546[(7)] = inst_27542);

(statearr_27546[(8)] = inst_27538);

return statearr_27546;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27544__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_27547 = [null,null,null,null,null,null,null,null,null];
(statearr_27547[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_27547[(1)] = (1));

return statearr_27547;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_27544){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27544);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27548){var ex__2417__auto__ = e27548;
var statearr_27549_27552 = state_27544;
(statearr_27549_27552[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27544[(4)]))){
var statearr_27550_27553 = state_27544;
(statearr_27550_27553[(1)] = cljs.core.first((state_27544[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27554 = state_27544;
state_27544 = G__27554;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_27544){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_27544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27551 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27551[(6)] = c__2436__auto__);

return statearr_27551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27556 = arguments.length;
switch (G__27556) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__27557 = session;
var map__27557__$1 = (((((!((map__27557 == null))))?(((((map__27557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27557):map__27557);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27557__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27559_27562 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27559_27562.cljs$core$IFn$_invoke$arity$3 ? fexpr__27559_27562.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__27559_27562.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__27560_27563 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__27560_27563.cljs$core$IFn$_invoke$arity$0 ? fexpr__27560_27563.cljs$core$IFn$_invoke$arity$0() : fexpr__27560_27563.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27616){
var state_val_27617 = (state_27616[(1)]);
if((state_val_27617 === (7))){
var inst_27612 = (state_27616[(2)]);
var state_27616__$1 = state_27616;
var statearr_27618_27649 = state_27616__$1;
(statearr_27618_27649[(2)] = inst_27612);

(statearr_27618_27649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (1))){
var state_27616__$1 = state_27616;
var statearr_27619_27650 = state_27616__$1;
(statearr_27619_27650[(2)] = null);

(statearr_27619_27650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (4))){
var inst_27567 = (state_27616[(7)]);
var inst_27566 = (state_27616[(2)]);
var inst_27567__$1 = fluree.db.util.async.throw_err(inst_27566);
var inst_27568 = fluree.db.session.from_cache(network,ledger_id);
var inst_27569 = (inst_27567__$1 == null);
var state_27616__$1 = (function (){var statearr_27620 = state_27616;
(statearr_27620[(8)] = inst_27568);

(statearr_27620[(7)] = inst_27567__$1);

return statearr_27620;
})();
if(cljs.core.truth_(inst_27569)){
var statearr_27621_27651 = state_27616__$1;
(statearr_27621_27651[(1)] = (5));

} else {
var statearr_27622_27652 = state_27616__$1;
(statearr_27622_27652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (15))){
var inst_27604 = (state_27616[(2)]);
var state_27616__$1 = (function (){var statearr_27623 = state_27616;
(statearr_27623[(9)] = inst_27604);

return statearr_27623;
})();
var statearr_27624_27653 = state_27616__$1;
(statearr_27624_27653[(2)] = null);

(statearr_27624_27653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (13))){
var inst_27608 = (state_27616[(2)]);
var state_27616__$1 = state_27616;
var statearr_27626_27654 = state_27616__$1;
(statearr_27626_27654[(2)] = inst_27608);

(statearr_27626_27654[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (6))){
var inst_27568 = (state_27616[(8)]);
var inst_27574 = (inst_27568 == null);
var state_27616__$1 = state_27616;
if(cljs.core.truth_(inst_27574)){
var statearr_27627_27655 = state_27616__$1;
(statearr_27627_27655[(1)] = (8));

} else {
var statearr_27628_27656 = state_27616__$1;
(statearr_27628_27656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (17))){
var _ = (function (){var statearr_27629 = state_27616;
(statearr_27629[(4)] = cljs.core.rest((state_27616[(4)])));

return statearr_27629;
})();
var state_27616__$1 = state_27616;
var ex27625 = (state_27616__$1[(2)]);
var statearr_27630_27657 = state_27616__$1;
(statearr_27630_27657[(5)] = ex27625);


var statearr_27631_27658 = state_27616__$1;
(statearr_27631_27658[(1)] = (16));

(statearr_27631_27658[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (3))){
var inst_27614 = (state_27616[(2)]);
var state_27616__$1 = state_27616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27616__$1,inst_27614);
} else {
if((state_val_27617 === (12))){
var state_27616__$1 = state_27616;
var statearr_27632_27659 = state_27616__$1;
(statearr_27632_27659[(2)] = null);

(statearr_27632_27659[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (2))){
var state_27616__$1 = state_27616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27616__$1,(4),update_chan);
} else {
if((state_val_27617 === (11))){
var state_27616__$1 = state_27616;
var statearr_27633_27660 = state_27616__$1;
(statearr_27633_27660[(2)] = null);

(statearr_27633_27660[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (9))){
var state_27616__$1 = state_27616;
var statearr_27634_27661 = state_27616__$1;
(statearr_27634_27661[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (5))){
var inst_27571 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27572 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27571], 0));
var state_27616__$1 = state_27616;
var statearr_27636_27662 = state_27616__$1;
(statearr_27636_27662[(2)] = inst_27572);

(statearr_27636_27662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (14))){
var inst_27568 = (state_27616[(8)]);
var inst_27567 = (state_27616[(7)]);
var _ = (function (){var statearr_27637 = state_27616;
(statearr_27637[(4)] = cljs.core.cons((17),(state_27616[(4)])));

return statearr_27637;
})();
var inst_27592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27567,(0),null);
var inst_27593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27567,(1),null);
var inst_27594 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27595 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27567], 0));
var inst_27596 = fluree.db.util.core.trunc(inst_27595,(200));
var inst_27597 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27594,inst_27596], 0));
var inst_27598 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_27568,inst_27592,inst_27593) : fluree.db.session.process_ledger_update.call(null,inst_27568,inst_27592,inst_27593));
var state_27616__$1 = (function (){var statearr_27638 = state_27616;
(statearr_27638[(10)] = inst_27597);

return statearr_27638;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27616__$1,(18),inst_27598);
} else {
if((state_val_27617 === (16))){
var inst_27567 = (state_27616[(7)]);
var inst_27582 = (state_27616[(2)]);
var inst_27583 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27582,"Exception processing ledger updates for message: ",inst_27567], 0));
var state_27616__$1 = state_27616;
var statearr_27639_27663 = state_27616__$1;
(statearr_27639_27663[(2)] = inst_27583);

(statearr_27639_27663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (10))){
var inst_27610 = (state_27616[(2)]);
var state_27616__$1 = state_27616;
var statearr_27640_27664 = state_27616__$1;
(statearr_27640_27664[(2)] = inst_27610);

(statearr_27640_27664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (18))){
var inst_27600 = (state_27616[(2)]);
var inst_27601 = fluree.db.util.async.throw_err(inst_27600);
var _ = (function (){var statearr_27641 = state_27616;
(statearr_27641[(4)] = cljs.core.rest((state_27616[(4)])));

return statearr_27641;
})();
var state_27616__$1 = state_27616;
var statearr_27642_27665 = state_27616__$1;
(statearr_27642_27665[(2)] = inst_27601);

(statearr_27642_27665[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27617 === (8))){
var inst_27567 = (state_27616[(7)]);
var inst_27576 = cljs.core.first(inst_27567);
var inst_27577 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27576], 0));
var inst_27578 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_27577].join('');
var inst_27579 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27578], 0));
var state_27616__$1 = state_27616;
var statearr_27643_27666 = state_27616__$1;
(statearr_27643_27666[(2)] = inst_27579);

(statearr_27643_27666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0 = (function (){
var statearr_27644 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27644[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__);

(statearr_27644[(1)] = (1));

return statearr_27644;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1 = (function (state_27616){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27616);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27645){var ex__2417__auto__ = e27645;
var statearr_27646_27667 = state_27616;
(statearr_27646_27667[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27616[(4)]))){
var statearr_27647_27668 = state_27616;
(statearr_27647_27668[(1)] = cljs.core.first((state_27616[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27669 = state_27616;
state_27616 = G__27669;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__ = function(state_27616){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1.call(this,state_27616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27648 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27648[(6)] = c__2436__auto__);

return statearr_27648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27670){
var map__27671 = p__27670;
var map__27671__$1 = (((((!((map__27671 == null))))?(((((map__27671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27671):map__27671);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27671__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27676 = block_result;
var map__27676__$1 = (((((!((map__27676 == null))))?(((((map__27676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27676):map__27676);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27676__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27676__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27676__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27676__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27676__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27677 = tx_result;
var map__27677__$1 = (((((!((map__27677 == null))))?(((((map__27677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27677.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27677):map__27677);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27677__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27677__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27673_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__27673_SHARP_.t);
}):(function (p1__27674_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27674_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27675_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27675_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27675_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27680 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27684 = arguments.length;
switch (G__27684) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27685){
var map__27686 = p__27685;
var map__27686__$1 = (((((!((map__27686 == null))))?(((((map__27686.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27686.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27686):map__27686);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27686__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27686__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27686__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27686__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27688 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27688,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27688,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27688,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__27692_27812 = network;
var G__27693_27813 = ledger_id;
var G__27694_27814 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__27695_27815 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27696 = cljs.core.seq(tids);
var chunk__27697 = null;
var count__27698 = (0);
var i__27699 = (0);
while(true){
if((i__27699 < count__27698)){
var tid = chunk__27697.cljs$core$IIndexed$_nth$arity$2(null,i__27699);
var temp__5735__auto___27817__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___27817__$1)){
var keyed_callbacks_27818 = temp__5735__auto___27817__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27819 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27740_27820 = cljs.core.seq(keyed_callbacks_27818);
var chunk__27741_27821 = null;
var count__27742_27822 = (0);
var i__27743_27823 = (0);
while(true){
if((i__27743_27823 < count__27742_27822)){
var vec__27752_27824 = chunk__27741_27821.cljs$core$IIndexed$_nth$arity$2(null,i__27743_27823);
var k_27825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27752_27824,(0),null);
var f_27826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27752_27824,(1),null);
try{(f_27826.cljs$core$IFn$_invoke$arity$1 ? f_27826.cljs$core$IFn$_invoke$arity$1(tx_response_27819) : f_27826.call(null,tx_response_27819));
}catch (e27755){var e_27827 = e27755;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27827,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__27828 = seq__27740_27820;
var G__27829 = chunk__27741_27821;
var G__27830 = count__27742_27822;
var G__27831 = (i__27743_27823 + (1));
seq__27740_27820 = G__27828;
chunk__27741_27821 = G__27829;
count__27742_27822 = G__27830;
i__27743_27823 = G__27831;
continue;
} else {
var temp__5735__auto___27832__$2 = cljs.core.seq(seq__27740_27820);
if(temp__5735__auto___27832__$2){
var seq__27740_27833__$1 = temp__5735__auto___27832__$2;
if(cljs.core.chunked_seq_QMARK_(seq__27740_27833__$1)){
var c__4556__auto___27834 = cljs.core.chunk_first(seq__27740_27833__$1);
var G__27835 = cljs.core.chunk_rest(seq__27740_27833__$1);
var G__27836 = c__4556__auto___27834;
var G__27837 = cljs.core.count(c__4556__auto___27834);
var G__27838 = (0);
seq__27740_27820 = G__27835;
chunk__27741_27821 = G__27836;
count__27742_27822 = G__27837;
i__27743_27823 = G__27838;
continue;
} else {
var vec__27756_27839 = cljs.core.first(seq__27740_27833__$1);
var k_27840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27756_27839,(0),null);
var f_27841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27756_27839,(1),null);
try{(f_27841.cljs$core$IFn$_invoke$arity$1 ? f_27841.cljs$core$IFn$_invoke$arity$1(tx_response_27819) : f_27841.call(null,tx_response_27819));
}catch (e27759){var e_27842 = e27759;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27842,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__27843 = cljs.core.next(seq__27740_27833__$1);
var G__27844 = null;
var G__27845 = (0);
var G__27846 = (0);
seq__27740_27820 = G__27843;
chunk__27741_27821 = G__27844;
count__27742_27822 = G__27845;
i__27743_27823 = G__27846;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27847 = seq__27696;
var G__27848 = chunk__27697;
var G__27849 = count__27698;
var G__27850 = (i__27699 + (1));
seq__27696 = G__27847;
chunk__27697 = G__27848;
count__27698 = G__27849;
i__27699 = G__27850;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__27696);
if(temp__5735__auto____$1){
var seq__27696__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__27696__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__27696__$1);
var G__27851 = cljs.core.chunk_rest(seq__27696__$1);
var G__27852 = c__4556__auto__;
var G__27853 = cljs.core.count(c__4556__auto__);
var G__27854 = (0);
seq__27696 = G__27851;
chunk__27697 = G__27852;
count__27698 = G__27853;
i__27699 = G__27854;
continue;
} else {
var tid = cljs.core.first(seq__27696__$1);
var temp__5735__auto___27855__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___27855__$2)){
var keyed_callbacks_27856 = temp__5735__auto___27855__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27857 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27760_27858 = cljs.core.seq(keyed_callbacks_27856);
var chunk__27761_27859 = null;
var count__27762_27860 = (0);
var i__27763_27861 = (0);
while(true){
if((i__27763_27861 < count__27762_27860)){
var vec__27772_27862 = chunk__27761_27859.cljs$core$IIndexed$_nth$arity$2(null,i__27763_27861);
var k_27863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27772_27862,(0),null);
var f_27864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27772_27862,(1),null);
try{(f_27864.cljs$core$IFn$_invoke$arity$1 ? f_27864.cljs$core$IFn$_invoke$arity$1(tx_response_27857) : f_27864.call(null,tx_response_27857));
}catch (e27775){var e_27865 = e27775;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27865,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__27866 = seq__27760_27858;
var G__27867 = chunk__27761_27859;
var G__27868 = count__27762_27860;
var G__27869 = (i__27763_27861 + (1));
seq__27760_27858 = G__27866;
chunk__27761_27859 = G__27867;
count__27762_27860 = G__27868;
i__27763_27861 = G__27869;
continue;
} else {
var temp__5735__auto___27870__$3 = cljs.core.seq(seq__27760_27858);
if(temp__5735__auto___27870__$3){
var seq__27760_27871__$1 = temp__5735__auto___27870__$3;
if(cljs.core.chunked_seq_QMARK_(seq__27760_27871__$1)){
var c__4556__auto___27872 = cljs.core.chunk_first(seq__27760_27871__$1);
var G__27873 = cljs.core.chunk_rest(seq__27760_27871__$1);
var G__27874 = c__4556__auto___27872;
var G__27875 = cljs.core.count(c__4556__auto___27872);
var G__27876 = (0);
seq__27760_27858 = G__27873;
chunk__27761_27859 = G__27874;
count__27762_27860 = G__27875;
i__27763_27861 = G__27876;
continue;
} else {
var vec__27776_27877 = cljs.core.first(seq__27760_27871__$1);
var k_27878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27776_27877,(0),null);
var f_27879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27776_27877,(1),null);
try{(f_27879.cljs$core$IFn$_invoke$arity$1 ? f_27879.cljs$core$IFn$_invoke$arity$1(tx_response_27857) : f_27879.call(null,tx_response_27857));
}catch (e27779){var e_27880 = e27779;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27880,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__27881 = cljs.core.next(seq__27760_27871__$1);
var G__27882 = null;
var G__27883 = (0);
var G__27884 = (0);
seq__27760_27858 = G__27881;
chunk__27761_27859 = G__27882;
count__27762_27860 = G__27883;
i__27763_27861 = G__27884;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27885 = cljs.core.next(seq__27696__$1);
var G__27886 = null;
var G__27887 = (0);
var G__27888 = (0);
seq__27696 = G__27885;
chunk__27697 = G__27886;
count__27698 = G__27887;
i__27699 = G__27888;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__27691_27816 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27691_27816.cljs$core$IFn$_invoke$arity$4 ? fexpr__27691_27816.cljs$core$IFn$_invoke$arity$4(G__27692_27812,G__27693_27813,G__27694_27814,G__27695_27815) : fexpr__27691_27816.call(null,G__27692_27812,G__27693_27813,G__27694_27814,G__27695_27815));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27889 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2436__auto___27890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27796){
var state_val_27797 = (state_27796[(1)]);
if((state_val_27797 === (1))){
var state_27796__$1 = state_27796;
var statearr_27798_27891 = state_27796__$1;
(statearr_27798_27891[(2)] = null);

(statearr_27798_27891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27797 === (2))){
var inst_27781 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27796__$1 = state_27796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27796__$1,(4),inst_27781);
} else {
if((state_val_27797 === (3))){
var inst_27794 = (state_27796[(2)]);
var state_27796__$1 = state_27796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27796__$1,inst_27794);
} else {
if((state_val_27797 === (4))){
var inst_27783 = (state_27796[(7)]);
var inst_27783__$1 = (state_27796[(2)]);
var inst_27784 = (inst_27783__$1 == null);
var state_27796__$1 = (function (){var statearr_27799 = state_27796;
(statearr_27799[(7)] = inst_27783__$1);

return statearr_27799;
})();
if(cljs.core.truth_(inst_27784)){
var statearr_27800_27892 = state_27796__$1;
(statearr_27800_27892[(1)] = (5));

} else {
var statearr_27801_27893 = state_27796__$1;
(statearr_27801_27893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27797 === (5))){
var inst_27786 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27787 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27786], 0));
var state_27796__$1 = state_27796;
var statearr_27802_27894 = state_27796__$1;
(statearr_27802_27894[(2)] = inst_27787);

(statearr_27802_27894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27797 === (6))){
var inst_27783 = (state_27796[(7)]);
var inst_27789 = (transact_handler_27889.cljs$core$IFn$_invoke$arity$2 ? transact_handler_27889.cljs$core$IFn$_invoke$arity$2(conn,inst_27783) : transact_handler_27889.call(null,conn,inst_27783));
var state_27796__$1 = (function (){var statearr_27803 = state_27796;
(statearr_27803[(8)] = inst_27789);

return statearr_27803;
})();
var statearr_27804_27895 = state_27796__$1;
(statearr_27804_27895[(2)] = null);

(statearr_27804_27895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27797 === (7))){
var inst_27792 = (state_27796[(2)]);
var state_27796__$1 = state_27796;
var statearr_27805_27896 = state_27796__$1;
(statearr_27805_27896[(2)] = inst_27792);

(statearr_27805_27896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_27806 = [null,null,null,null,null,null,null,null,null];
(statearr_27806[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_27806[(1)] = (1));

return statearr_27806;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_27796){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27796);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27807){var ex__2417__auto__ = e27807;
var statearr_27808_27897 = state_27796;
(statearr_27808_27897[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27796[(4)]))){
var statearr_27809_27898 = state_27796;
(statearr_27809_27898[(1)] = cljs.core.first((state_27796[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27899 = state_27796;
state_27796 = G__27899;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_27796){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_27796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27810 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27810[(6)] = c__2436__auto___27890);

return statearr_27810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__27900_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__27900_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__27900_SHARP_) + (1))], 0));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__27901_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__27901_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27904 = arguments.length;
switch (G__27904) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27905 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__27902_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__27902_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27905);
} else {
return G__27905;
}
})();
var seq__27906 = cljs.core.seq(sessions);
var chunk__27907 = null;
var count__27908 = (0);
var i__27909 = (0);
while(true){
if((i__27909 < count__27908)){
var session = chunk__27907.cljs$core$IIndexed$_nth$arity$2(null,i__27909);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27911 = seq__27906;
var G__27912 = chunk__27907;
var G__27913 = count__27908;
var G__27914 = (i__27909 + (1));
seq__27906 = G__27911;
chunk__27907 = G__27912;
count__27908 = G__27913;
i__27909 = G__27914;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__27906);
if(temp__5735__auto__){
var seq__27906__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27906__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__27906__$1);
var G__27915 = cljs.core.chunk_rest(seq__27906__$1);
var G__27916 = c__4556__auto__;
var G__27917 = cljs.core.count(c__4556__auto__);
var G__27918 = (0);
seq__27906 = G__27915;
chunk__27907 = G__27916;
count__27908 = G__27917;
i__27909 = G__27918;
continue;
} else {
var session = cljs.core.first(seq__27906__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27919 = cljs.core.next(seq__27906__$1);
var G__27920 = null;
var G__27921 = (0);
var G__27922 = (0);
seq__27906 = G__27919;
chunk__27907 = G__27920;
count__27908 = G__27921;
i__27909 = G__27922;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
