// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16026_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16026_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__16030 = coll;
var vec__16031 = G__16030;
var seq__16032 = cljs.core.seq(vec__16031);
var first__16033 = cljs.core.first(seq__16032);
var seq__16032__$1 = cljs.core.next(seq__16032);
var clause = first__16033;
var r = seq__16032__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16030__$1 = G__16030;
var res__$1 = res;
while(true){
var vec__16037 = G__16030__$1;
var seq__16038 = cljs.core.seq(vec__16037);
var first__16039 = cljs.core.first(seq__16038);
var seq__16038__$1 = cljs.core.next(seq__16038);
var clause__$1 = first__16039;
var r__$1 = seq__16038__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16040 = r__$1;
var G__16041 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__16030__$1 = G__16040;
res__$1 = G__16041;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__16045 = coll;
var vec__16046 = G__16045;
var seq__16047 = cljs.core.seq(vec__16046);
var first__16048 = cljs.core.first(seq__16047);
var seq__16047__$1 = cljs.core.next(seq__16047);
var clause = first__16048;
var r = seq__16047__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16045__$1 = G__16045;
var res__$1 = res;
while(true){
var vec__16052 = G__16045__$1;
var seq__16053 = cljs.core.seq(vec__16052);
var first__16054 = cljs.core.first(seq__16053);
var seq__16053__$1 = cljs.core.next(seq__16053);
var clause__$1 = first__16054;
var r__$1 = seq__16053__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16055 = r__$1;
var G__16056 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__16045__$1 = G__16055;
res__$1 = G__16056;
continue;
} else {
var G__16057 = r__$1;
var G__16058 = res__$2;
G__16045__$1 = G__16057;
res__$1 = G__16058;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__16062 = coll;
var vec__16063 = G__16062;
var seq__16064 = cljs.core.seq(vec__16063);
var first__16065 = cljs.core.first(seq__16064);
var seq__16064__$1 = cljs.core.next(seq__16064);
var clause = first__16065;
var r = seq__16064__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16062__$1 = G__16062;
var res__$1 = res;
while(true){
var vec__16069 = G__16062__$1;
var seq__16070 = cljs.core.seq(vec__16069);
var first__16071 = cljs.core.first(seq__16070);
var seq__16070__$1 = cljs.core.next(seq__16070);
var clause__$1 = first__16071;
var r__$1 = seq__16070__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16072 = r__$1;
var G__16073 = res__$2;
G__16062__$1 = G__16072;
res__$1 = G__16073;
continue;
} else {
var G__16074 = r__$1;
var G__16075 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__16062__$1 = G__16074;
res__$1 = G__16075;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__16079 = opts;
var map__16079__$1 = (((((!((map__16079 == null))))?(((((map__16079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16079):map__16079);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16079__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16079__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16079__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16079__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16079__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16076_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16076_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__16077_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__16077_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__16078_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__16078_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16094){
var state_val_16095 = (state_16094[(1)]);
if((state_val_16095 === (1))){
var inst_16081 = fluree.db.util.core.url_encode(query);
var inst_16082 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16081)].join('');
var inst_16083 = ["User-Agent","Accept"];
var inst_16084 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_16085 = cljs.core.PersistentHashMap.fromArrays(inst_16083,inst_16084);
var inst_16086 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_16087 = [inst_16085,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_16088 = cljs.core.PersistentHashMap.fromArrays(inst_16086,inst_16087);
var inst_16089 = fluree.db.util.xhttp.get(inst_16082,inst_16088);
var state_16094__$1 = state_16094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16094__$1,(2),inst_16089);
} else {
if((state_val_16095 === (2))){
var inst_16091 = (state_16094[(2)]);
var inst_16092 = fluree.db.util.async.throw_err(inst_16091);
var state_16094__$1 = state_16094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16094__$1,inst_16092);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0 = (function (){
var statearr_16096 = [null,null,null,null,null,null,null];
(statearr_16096[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__);

(statearr_16096[(1)] = (1));

return statearr_16096;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1 = (function (state_16094){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16094);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16097){var ex__2417__auto__ = e16097;
var statearr_16098_16101 = state_16094;
(statearr_16098_16101[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16094[(4)]))){
var statearr_16099_16102 = state_16094;
(statearr_16099_16102[(1)] = cljs.core.first((state_16094[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16103 = state_16094;
state_16094 = G__16103;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__ = function(state_16094){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1.call(this,state_16094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16100 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16100[(6)] = c__2436__auto__);

return statearr_16100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16121){
var state_val_16122 = (state_16121[(1)]);
if((state_val_16122 === (1))){
var inst_16104 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_16121__$1 = state_16121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16121__$1,(2),inst_16104);
} else {
if((state_val_16122 === (2))){
var inst_16107 = (state_16121[(7)]);
var inst_16106 = (state_16121[(2)]);
var inst_16107__$1 = fluree.db.util.async.throw_err(inst_16106);
var inst_16108 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_16107__$1);
var inst_16109 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_16108);
var state_16121__$1 = (function (){var statearr_16123 = state_16121;
(statearr_16123[(7)] = inst_16107__$1);

return statearr_16123;
})();
if(inst_16109){
var statearr_16124_16133 = state_16121__$1;
(statearr_16124_16133[(1)] = (3));

} else {
var statearr_16125_16134 = state_16121__$1;
(statearr_16125_16134[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16122 === (3))){
var inst_16107 = (state_16121[(7)]);
var state_16121__$1 = state_16121;
var statearr_16126_16135 = state_16121__$1;
(statearr_16126_16135[(2)] = inst_16107);

(statearr_16126_16135[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16122 === (4))){
var inst_16107 = (state_16121[(7)]);
var inst_16112 = (function (){var body = inst_16107;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_16113 = cljs.core.second(inst_16107);
var inst_16114 = cljs.core.second(inst_16113);
var inst_16115 = cljs.core.first(inst_16114);
var inst_16116 = cljs.core.second(inst_16115);
var inst_16117 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_16112,inst_16116);
var state_16121__$1 = state_16121;
var statearr_16127_16136 = state_16121__$1;
(statearr_16127_16136[(2)] = inst_16117);

(statearr_16127_16136[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16122 === (5))){
var inst_16119 = (state_16121[(2)]);
var state_16121__$1 = state_16121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16121__$1,inst_16119);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0 = (function (){
var statearr_16128 = [null,null,null,null,null,null,null,null];
(statearr_16128[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__);

(statearr_16128[(1)] = (1));

return statearr_16128;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1 = (function (state_16121){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16121);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16129){var ex__2417__auto__ = e16129;
var statearr_16130_16137 = state_16121;
(statearr_16130_16137[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16121[(4)]))){
var statearr_16131_16138 = state_16121;
(statearr_16131_16138[(1)] = cljs.core.first((state_16121[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16139 = state_16121;
state_16121 = G__16139;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__ = function(state_16121){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1.call(this,state_16121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16132 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16132[(6)] = c__2436__auto__);

return statearr_16132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16140_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16140_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16141_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16141_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16142_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__16142_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16142_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__16142_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16208){
var state_val_16209 = (state_16208[(1)]);
if((state_val_16209 === (7))){
var inst_16153 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_16208__$1 = state_16208;
var statearr_16210_16251 = state_16208__$1;
(statearr_16210_16251[(2)] = inst_16153);

(statearr_16210_16251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (20))){
var inst_16181 = (state_16208[(7)]);
var inst_16201 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_16181,all_vars);
var state_16208__$1 = state_16208;
var statearr_16211_16252 = state_16208__$1;
(statearr_16211_16252[(2)] = inst_16201);

(statearr_16211_16252[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (1))){
var state_16208__$1 = state_16208;
var statearr_16212_16253 = state_16208__$1;
(statearr_16212_16253[(2)] = null);

(statearr_16212_16253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (24))){
var inst_16187 = (state_16208[(8)]);
var inst_16182 = (state_16208[(9)]);
var inst_16181 = (state_16208[(7)]);
var inst_16192 = (state_16208[(2)]);
var inst_16193 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_16187,(0),inst_16192);
var inst_16194 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16195 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_16181);
var inst_16196 = [inst_16182,inst_16195];
var inst_16197 = cljs.core.PersistentHashMap.fromArrays(inst_16194,inst_16196);
var inst_16198 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16193,inst_16197);
var inst_16199 = (function(){throw inst_16198})();
var state_16208__$1 = state_16208;
var statearr_16213_16254 = state_16208__$1;
(statearr_16213_16254[(2)] = inst_16199);

(statearr_16213_16254[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (4))){
var inst_16143 = (state_16208[(2)]);
var state_16208__$1 = state_16208;
var statearr_16214_16255 = state_16208__$1;
(statearr_16214_16255[(2)] = inst_16143);

(statearr_16214_16255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (15))){
var inst_16173 = (state_16208[(2)]);
var state_16208__$1 = state_16208;
var statearr_16215_16256 = state_16208__$1;
(statearr_16215_16256[(2)] = inst_16173);

(statearr_16215_16256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (21))){
var inst_16203 = (state_16208[(2)]);
var _ = (function (){var statearr_16216 = state_16208;
(statearr_16216[(4)] = cljs.core.rest((state_16208[(4)])));

return statearr_16216;
})();
var state_16208__$1 = state_16208;
var statearr_16217_16257 = state_16208__$1;
(statearr_16217_16257[(2)] = inst_16203);

(statearr_16217_16257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (13))){
var state_16208__$1 = state_16208;
var statearr_16218_16258 = state_16208__$1;
(statearr_16218_16258[(2)] = true);

(statearr_16218_16258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (22))){
var inst_16186 = (state_16208[(10)]);
var state_16208__$1 = state_16208;
var statearr_16219_16259 = state_16208__$1;
(statearr_16219_16259[(2)] = inst_16186);

(statearr_16219_16259[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (6))){
var state_16208__$1 = state_16208;
var statearr_16220_16260 = state_16208__$1;
(statearr_16220_16260[(2)] = null);

(statearr_16220_16260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (17))){
var inst_16160 = (state_16208[(11)]);
var state_16208__$1 = state_16208;
var statearr_16221_16261 = state_16208__$1;
(statearr_16221_16261[(2)] = inst_16160);

(statearr_16221_16261[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (3))){
var inst_16206 = (state_16208[(2)]);
var state_16208__$1 = state_16208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16208__$1,inst_16206);
} else {
if((state_val_16209 === (12))){
var inst_16176 = (state_16208[(2)]);
var state_16208__$1 = state_16208;
if(cljs.core.truth_(inst_16176)){
var statearr_16222_16262 = state_16208__$1;
(statearr_16222_16262[(1)] = (16));

} else {
var statearr_16223_16263 = state_16208__$1;
(statearr_16223_16263[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (2))){
var _ = (function (){var statearr_16224 = state_16208;
(statearr_16224[(4)] = cljs.core.cons((5),(state_16208[(4)])));

return statearr_16224;
})();
var inst_16150 = cljs.core.empty_QMARK_(matching_vars);
var state_16208__$1 = state_16208;
if(inst_16150){
var statearr_16225_16264 = state_16208__$1;
(statearr_16225_16264[(1)] = (6));

} else {
var statearr_16226_16265 = state_16208__$1;
(statearr_16226_16265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (23))){
var state_16208__$1 = state_16208;
var statearr_16227_16266 = state_16208__$1;
(statearr_16227_16266[(2)] = (1000));

(statearr_16227_16266[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (19))){
var inst_16186 = (state_16208[(10)]);
var inst_16183 = (state_16208[(12)]);
var inst_16181 = (state_16208[(7)]);
var inst_16186__$1 = cljs.core.count(inst_16183);
var inst_16187 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_16181);
var inst_16188 = (inst_16186__$1 < (1000));
var state_16208__$1 = (function (){var statearr_16228 = state_16208;
(statearr_16228[(10)] = inst_16186__$1);

(statearr_16228[(8)] = inst_16187);

return statearr_16228;
})();
if(cljs.core.truth_(inst_16188)){
var statearr_16229_16267 = state_16208__$1;
(statearr_16229_16267[(1)] = (22));

} else {
var statearr_16230_16268 = state_16208__$1;
(statearr_16230_16268[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (11))){
var state_16208__$1 = state_16208;
var statearr_16232_16269 = state_16208__$1;
(statearr_16232_16269[(2)] = false);

(statearr_16232_16269[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (9))){
var inst_16160 = (state_16208[(11)]);
var inst_16159 = (state_16208[(2)]);
var inst_16160__$1 = fluree.db.util.async.throw_err(inst_16159);
var inst_16162 = (inst_16160__$1 == null);
var inst_16163 = cljs.core.not(inst_16162);
var state_16208__$1 = (function (){var statearr_16233 = state_16208;
(statearr_16233[(11)] = inst_16160__$1);

return statearr_16233;
})();
if(inst_16163){
var statearr_16234_16270 = state_16208__$1;
(statearr_16234_16270[(1)] = (10));

} else {
var statearr_16235_16271 = state_16208__$1;
(statearr_16235_16271[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (5))){
var _ = (function (){var statearr_16236 = state_16208;
(statearr_16236[(4)] = cljs.core.rest((state_16208[(4)])));

return statearr_16236;
})();
var state_16208__$1 = state_16208;
var ex16231 = (state_16208__$1[(2)]);
var statearr_16237_16272 = state_16208__$1;
(statearr_16237_16272[(5)] = ex16231);


if((ex16231 instanceof Error)){
var statearr_16238_16273 = state_16208__$1;
(statearr_16238_16273[(1)] = (4));

(statearr_16238_16273[(5)] = null);

} else {
throw ex16231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (14))){
var state_16208__$1 = state_16208;
var statearr_16239_16274 = state_16208__$1;
(statearr_16239_16274[(2)] = false);

(statearr_16239_16274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (16))){
var inst_16160 = (state_16208[(11)]);
var inst_16178 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16160);
var state_16208__$1 = state_16208;
var statearr_16240_16275 = state_16208__$1;
(statearr_16240_16275[(2)] = inst_16178);

(statearr_16240_16275[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (10))){
var inst_16160 = (state_16208[(11)]);
var inst_16165 = inst_16160.cljs$lang$protocol_mask$partition0$;
var inst_16166 = (inst_16165 & (64));
var inst_16167 = inst_16160.cljs$core$ISeq$;
var inst_16168 = (cljs.core.PROTOCOL_SENTINEL === inst_16167);
var inst_16169 = ((inst_16166) || (inst_16168));
var state_16208__$1 = state_16208;
if(cljs.core.truth_(inst_16169)){
var statearr_16241_16276 = state_16208__$1;
(statearr_16241_16276[(1)] = (13));

} else {
var statearr_16242_16277 = state_16208__$1;
(statearr_16242_16277[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (18))){
var inst_16182 = (state_16208[(9)]);
var inst_16181 = (state_16208[(7)]);
var inst_16181__$1 = (state_16208[(2)]);
var inst_16182__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16181__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_16183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16181__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_16184 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_16182__$1);
var state_16208__$1 = (function (){var statearr_16243 = state_16208;
(statearr_16243[(9)] = inst_16182__$1);

(statearr_16243[(12)] = inst_16183);

(statearr_16243[(7)] = inst_16181__$1);

return statearr_16243;
})();
if(inst_16184){
var statearr_16244_16278 = state_16208__$1;
(statearr_16244_16278[(1)] = (19));

} else {
var statearr_16245_16279 = state_16208__$1;
(statearr_16245_16279[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16209 === (8))){
var inst_16155 = (state_16208[(2)]);
var inst_16156 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_16155,optional_clauses);
var inst_16157 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_16156);
var state_16208__$1 = state_16208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16208__$1,(9),inst_16157);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_16246 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16246[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__);

(statearr_16246[(1)] = (1));

return statearr_16246;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1 = (function (state_16208){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16208);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16247){var ex__2417__auto__ = e16247;
var statearr_16248_16280 = state_16208;
(statearr_16248_16280[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16208[(4)]))){
var statearr_16249_16281 = state_16208;
(statearr_16249_16281[(1)] = cljs.core.first((state_16208[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16282 = state_16208;
state_16208 = G__16282;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__ = function(state_16208){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1.call(this,state_16208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16250 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16250[(6)] = c__2436__auto__);

return statearr_16250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
