// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61829_61998 = cljs.core.seq(servers);
var chunk__61830_61999 = null;
var count__61831_62000 = (0);
var i__61832_62001 = (0);
while(true){
if((i__61832_62001 < count__61831_62000)){
var server_62002 = chunk__61830_61999.cljs$core$IIndexed$_nth$arity$2(null,i__61832_62001);
var healthcheck_uri_62003 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62002),"/fdb/health"].join('');
var resp_chan_62004 = fluree.db.util.xhttp.post_json(healthcheck_uri_62003,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2436__auto___62005 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002){
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = ((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002){
return (function (state_61893){
var state_val_61894 = (state_61893[(1)]);
if((state_val_61894 === (1))){
var state_61893__$1 = state_61893;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61893__$1,(2),resp_chan_62004);
} else {
if((state_val_61894 === (2))){
var inst_61882 = (state_61893[(7)]);
var inst_61882__$1 = (state_61893[(2)]);
var inst_61883 = fluree.db.util.core.exception_QMARK_(inst_61882__$1);
var state_61893__$1 = (function (){var statearr_61895 = state_61893;
(statearr_61895[(7)] = inst_61882__$1);

return statearr_61895;
})();
if(inst_61883){
var statearr_61896_62006 = state_61893__$1;
(statearr_61896_62006[(1)] = (3));

} else {
var statearr_61897_62007 = state_61893__$1;
(statearr_61897_62007[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61894 === (3))){
var inst_61882 = (state_61893[(7)]);
var inst_61885 = cljs.core.ex_message(inst_61882);
var inst_61886 = cljs.core.ex_data(inst_61882);
var inst_61887 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61885,inst_61886], 0));
var state_61893__$1 = state_61893;
var statearr_61898_62008 = state_61893__$1;
(statearr_61898_62008[(2)] = inst_61887);

(statearr_61898_62008[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61894 === (4))){
var inst_61889 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62002);
var state_61893__$1 = state_61893;
var statearr_61899_62009 = state_61893__$1;
(statearr_61899_62009[(2)] = inst_61889);

(statearr_61899_62009[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61894 === (5))){
var inst_61891 = (state_61893[(2)]);
var state_61893__$1 = state_61893;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61893__$1,inst_61891);
} else {
return null;
}
}
}
}
}
});})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002))
;
return ((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,switch__2413__auto__,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_61900 = [null,null,null,null,null,null,null,null];
(statearr_61900[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_61900[(1)] = (1));

return statearr_61900;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_61893){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61893);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61901){var ex__2417__auto__ = e61901;
var statearr_61902_62010 = state_61893;
(statearr_61902_62010[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61893[(4)]))){
var statearr_61903_62011 = state_61893;
(statearr_61903_62011[(1)] = cljs.core.first((state_61893[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62012 = state_61893;
state_61893 = G__62012;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_61893){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_61893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
;})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,switch__2413__auto__,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002))
})();
var state__2438__auto__ = (function (){var statearr_61904 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61904[(6)] = c__2436__auto___62005);

return statearr_61904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62005,healthcheck_uri_62003,resp_chan_62004,server_62002))
);



var G__62013 = seq__61829_61998;
var G__62014 = chunk__61830_61999;
var G__62015 = count__61831_62000;
var G__62016 = (i__61832_62001 + (1));
seq__61829_61998 = G__62013;
chunk__61830_61999 = G__62014;
count__61831_62000 = G__62015;
i__61832_62001 = G__62016;
continue;
} else {
var temp__5735__auto___62017 = cljs.core.seq(seq__61829_61998);
if(temp__5735__auto___62017){
var seq__61829_62018__$1 = temp__5735__auto___62017;
if(cljs.core.chunked_seq_QMARK_(seq__61829_62018__$1)){
var c__4556__auto___62019 = cljs.core.chunk_first(seq__61829_62018__$1);
var G__62020 = cljs.core.chunk_rest(seq__61829_62018__$1);
var G__62021 = c__4556__auto___62019;
var G__62022 = cljs.core.count(c__4556__auto___62019);
var G__62023 = (0);
seq__61829_61998 = G__62020;
chunk__61830_61999 = G__62021;
count__61831_62000 = G__62022;
i__61832_62001 = G__62023;
continue;
} else {
var server_62024 = cljs.core.first(seq__61829_62018__$1);
var healthcheck_uri_62025 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62024),"/fdb/health"].join('');
var resp_chan_62026 = fluree.db.util.xhttp.post_json(healthcheck_uri_62025,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2436__auto___62027 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017){
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = ((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017){
return (function (state_61917){
var state_val_61918 = (state_61917[(1)]);
if((state_val_61918 === (1))){
var state_61917__$1 = state_61917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61917__$1,(2),resp_chan_62026);
} else {
if((state_val_61918 === (2))){
var inst_61906 = (state_61917[(7)]);
var inst_61906__$1 = (state_61917[(2)]);
var inst_61907 = fluree.db.util.core.exception_QMARK_(inst_61906__$1);
var state_61917__$1 = (function (){var statearr_61919 = state_61917;
(statearr_61919[(7)] = inst_61906__$1);

return statearr_61919;
})();
if(inst_61907){
var statearr_61920_62028 = state_61917__$1;
(statearr_61920_62028[(1)] = (3));

} else {
var statearr_61921_62029 = state_61917__$1;
(statearr_61921_62029[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61918 === (3))){
var inst_61906 = (state_61917[(7)]);
var inst_61909 = cljs.core.ex_message(inst_61906);
var inst_61910 = cljs.core.ex_data(inst_61906);
var inst_61911 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61909,inst_61910], 0));
var state_61917__$1 = state_61917;
var statearr_61922_62030 = state_61917__$1;
(statearr_61922_62030[(2)] = inst_61911);

(statearr_61922_62030[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61918 === (4))){
var inst_61913 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62024);
var state_61917__$1 = state_61917;
var statearr_61923_62031 = state_61917__$1;
(statearr_61923_62031[(2)] = inst_61913);

(statearr_61923_62031[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61918 === (5))){
var inst_61915 = (state_61917[(2)]);
var state_61917__$1 = state_61917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61917__$1,inst_61915);
} else {
return null;
}
}
}
}
}
});})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017))
;
return ((function (seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,switch__2413__auto__,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_61924 = [null,null,null,null,null,null,null,null];
(statearr_61924[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_61924[(1)] = (1));

return statearr_61924;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_61917){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61917);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61925){var ex__2417__auto__ = e61925;
var statearr_61926_62032 = state_61917;
(statearr_61926_62032[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61917[(4)]))){
var statearr_61927_62033 = state_61917;
(statearr_61927_62033[(1)] = cljs.core.first((state_61917[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62034 = state_61917;
state_61917 = G__62034;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_61917){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_61917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
;})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,switch__2413__auto__,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017))
})();
var state__2438__auto__ = (function (){var statearr_61928 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61928[(6)] = c__2436__auto___62027);

return statearr_61928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});})(seq__61829_61998,chunk__61830_61999,count__61831_62000,i__61832_62001,c__2436__auto___62027,healthcheck_uri_62025,resp_chan_62026,server_62024,seq__61829_62018__$1,temp__5735__auto___62017))
);



var G__62035 = cljs.core.next(seq__61829_62018__$1);
var G__62036 = null;
var G__62037 = (0);
var G__62038 = (0);
seq__61829_61998 = G__62035;
chunk__61830_61999 = G__62036;
count__61831_62000 = G__62037;
i__61832_62001 = G__62038;
continue;
}
} else {
}
}
break;
}

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61972){
var state_val_61973 = (state_61972[(1)]);
if((state_val_61973 === (7))){
var inst_61944 = (state_61972[(7)]);
var inst_61951 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61944,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61972__$1 = state_61972;
if(inst_61951){
var statearr_61974_62039 = state_61972__$1;
(statearr_61974_62039[(1)] = (9));

} else {
var statearr_61975_62040 = state_61972__$1;
(statearr_61975_62040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (1))){
var inst_61937 = (state_61972[(8)]);
var inst_61936 = (state_61972[(9)]);
var inst_61936__$1 = promise_chan;
var inst_61937__$1 = cljs.core.async.timeout((60000));
var inst_61938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61939 = [inst_61936__$1,inst_61937__$1];
var inst_61940 = (new cljs.core.PersistentVector(null,2,(5),inst_61938,inst_61939,null));
var state_61972__$1 = (function (){var statearr_61976 = state_61972;
(statearr_61976[(8)] = inst_61937__$1);

(statearr_61976[(9)] = inst_61936__$1);

return statearr_61976;
})();
return cljs.core.async.ioc_alts_BANG_(state_61972__$1,(2),inst_61940);
} else {
if((state_val_61973 === (4))){
var inst_61944 = (state_61972[(7)]);
var inst_61937 = (state_61972[(8)]);
var inst_61948 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61944,inst_61937);
var state_61972__$1 = state_61972;
if(inst_61948){
var statearr_61977_62041 = state_61972__$1;
(statearr_61977_62041[(1)] = (6));

} else {
var statearr_61978_62042 = state_61972__$1;
(statearr_61978_62042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (13))){
var state_61972__$1 = state_61972;
var statearr_61979_62043 = state_61972__$1;
(statearr_61979_62043[(2)] = null);

(statearr_61979_62043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (6))){
var state_61972__$1 = state_61972;
var statearr_61980_62044 = state_61972__$1;
(statearr_61980_62044[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61980_62044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (3))){
var state_61972__$1 = state_61972;
var statearr_61981_62045 = state_61972__$1;
(statearr_61981_62045[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61981_62045[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (12))){
var inst_61962 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61963 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61964 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61965 = cljs.core.PersistentHashMap.fromArrays(inst_61963,inst_61964);
var inst_61966 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61965);
var inst_61967 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61966);
var state_61972__$1 = (function (){var statearr_61982 = state_61972;
(statearr_61982[(10)] = inst_61962);

return statearr_61982;
})();
var statearr_61983_62046 = state_61972__$1;
(statearr_61983_62046[(2)] = inst_61967);

(statearr_61983_62046[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (2))){
var inst_61944 = (state_61972[(7)]);
var inst_61936 = (state_61972[(9)]);
var inst_61942 = (state_61972[(2)]);
var inst_61943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61942,(0),null);
var inst_61944__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61942,(1),null);
var inst_61945 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61944__$1,inst_61936);
var state_61972__$1 = (function (){var statearr_61984 = state_61972;
(statearr_61984[(7)] = inst_61944__$1);

(statearr_61984[(11)] = inst_61943);

return statearr_61984;
})();
if(inst_61945){
var statearr_61985_62047 = state_61972__$1;
(statearr_61985_62047[(1)] = (3));

} else {
var statearr_61986_62048 = state_61972__$1;
(statearr_61986_62048[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (11))){
var inst_61955 = (state_61972[(2)]);
var state_61972__$1 = state_61972;
var statearr_61987_62049 = state_61972__$1;
(statearr_61987_62049[(2)] = inst_61955);

(statearr_61987_62049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (9))){
var inst_61943 = (state_61972[(11)]);
var state_61972__$1 = state_61972;
var statearr_61988_62050 = state_61972__$1;
(statearr_61988_62050[(2)] = inst_61943);

(statearr_61988_62050[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (5))){
var inst_61959 = (state_61972[(2)]);
var inst_61960 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61959);
var state_61972__$1 = state_61972;
if(inst_61960){
var statearr_61989_62051 = state_61972__$1;
(statearr_61989_62051[(1)] = (12));

} else {
var statearr_61990_62052 = state_61972__$1;
(statearr_61990_62052[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (14))){
var inst_61970 = (state_61972[(2)]);
var state_61972__$1 = state_61972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61972__$1,inst_61970);
} else {
if((state_val_61973 === (10))){
var state_61972__$1 = state_61972;
var statearr_61991_62053 = state_61972__$1;
(statearr_61991_62053[(2)] = null);

(statearr_61991_62053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61973 === (8))){
var inst_61957 = (state_61972[(2)]);
var state_61972__$1 = state_61972;
var statearr_61992_62054 = state_61972__$1;
(statearr_61992_62054[(2)] = inst_61957);

(statearr_61992_62054[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_61993 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61993[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_61993[(1)] = (1));

return statearr_61993;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_61972){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61972);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61994){var ex__2417__auto__ = e61994;
var statearr_61995_62055 = state_61972;
(statearr_61995_62055[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61972[(4)]))){
var statearr_61996_62056 = state_61972;
(statearr_61996_62056[(1)] = cljs.core.first((state_61972[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62057 = state_61972;
state_61972 = G__62057;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_61972){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_61972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61997 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61997[(6)] = c__2436__auto__);

return statearr_61997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62101){
var state_val_62102 = (state_62101[(1)]);
if((state_val_62102 === (7))){
var state_62101__$1 = state_62101;
var statearr_62103_62129 = state_62101__$1;
(statearr_62103_62129[(2)] = null);

(statearr_62103_62129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (1))){
var state_62101__$1 = state_62101;
var statearr_62104_62130 = state_62101__$1;
(statearr_62104_62130[(2)] = null);

(statearr_62104_62130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (4))){
var inst_62058 = (state_62101[(2)]);
var state_62101__$1 = state_62101;
var statearr_62105_62131 = state_62101__$1;
(statearr_62105_62131[(2)] = inst_62058);

(statearr_62105_62131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (6))){
var inst_62080 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62101__$1 = state_62101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62101__$1,(9),inst_62080);
} else {
if((state_val_62102 === (3))){
var inst_62099 = (state_62101[(2)]);
var state_62101__$1 = state_62101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62101__$1,inst_62099);
} else {
if((state_val_62102 === (12))){
var inst_62093 = (state_62101[(2)]);
var state_62101__$1 = state_62101;
var statearr_62106_62132 = state_62101__$1;
(statearr_62106_62132[(2)] = inst_62093);

(statearr_62106_62132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (2))){
var inst_62069 = (state_62101[(7)]);
var inst_62064 = (state_62101[(8)]);
var inst_62074 = (state_62101[(9)]);
var _ = (function (){var statearr_62107 = state_62101;
(statearr_62107[(4)] = cljs.core.cons((5),(state_62101[(4)])));

return statearr_62107;
})();
var inst_62064__$1 = fluree.db.util.core.random_uuid();
var inst_62065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62066 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62067 = (new cljs.core.PersistentVector(null,2,(5),inst_62065,inst_62066,null));
var inst_62068 = (function (){var lock_id = inst_62064__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62069__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62067,inst_62068);
var inst_62070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62071 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62072 = (new cljs.core.PersistentVector(null,3,(5),inst_62070,inst_62071,null));
var inst_62073 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62069__$1,inst_62072);
var inst_62074__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62064__$1,inst_62073);
var inst_62075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62076 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62077 = (new cljs.core.PersistentVector(null,3,(5),inst_62075,inst_62076,null));
var inst_62078 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62069__$1,inst_62077);
var state_62101__$1 = (function (){var statearr_62108 = state_62101;
(statearr_62108[(7)] = inst_62069__$1);

(statearr_62108[(8)] = inst_62064__$1);

(statearr_62108[(10)] = inst_62078);

(statearr_62108[(9)] = inst_62074__$1);

return statearr_62108;
})();
if(inst_62074__$1){
var statearr_62109_62133 = state_62101__$1;
(statearr_62109_62133[(1)] = (6));

} else {
var statearr_62110_62134 = state_62101__$1;
(statearr_62110_62134[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (11))){
var inst_62085 = (state_62101[(11)]);
var inst_62078 = (state_62101[(10)]);
var inst_62084 = (state_62101[(12)]);
var inst_62091 = fluree.db.util.xhttp.try_socket(inst_62084,sub_chan,pub_chan,inst_62078,(60000),inst_62085);
var state_62101__$1 = state_62101;
var statearr_62112_62135 = state_62101__$1;
(statearr_62112_62135[(2)] = inst_62091);

(statearr_62112_62135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (9))){
var inst_62069 = (state_62101[(7)]);
var inst_62064 = (state_62101[(8)]);
var inst_62078 = (state_62101[(10)]);
var inst_62074 = (state_62101[(9)]);
var inst_62082 = (state_62101[(13)]);
var inst_62084 = (state_62101[(12)]);
var inst_62082__$1 = (state_62101[(2)]);
var inst_62083 = clojure.string.replace(inst_62082__$1,"http","ws");
var inst_62084__$1 = [inst_62083,"/fdb/ws"].join('');
var inst_62085 = (function (){var lock_id = inst_62064;
var state = inst_62069;
var have_lock_QMARK_ = inst_62074;
var resp_chan = inst_62078;
var healthy_server = inst_62082__$1;
var ws_url = inst_62084__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62086 = fluree.db.util.core.exception_QMARK_(inst_62082__$1);
var state_62101__$1 = (function (){var statearr_62113 = state_62101;
(statearr_62113[(11)] = inst_62085);

(statearr_62113[(13)] = inst_62082__$1);

(statearr_62113[(12)] = inst_62084__$1);

return statearr_62113;
})();
if(inst_62086){
var statearr_62114_62136 = state_62101__$1;
(statearr_62114_62136[(1)] = (10));

} else {
var statearr_62115_62137 = state_62101__$1;
(statearr_62115_62137[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (5))){
var _ = (function (){var statearr_62116 = state_62101;
(statearr_62116[(4)] = cljs.core.rest((state_62101[(4)])));

return statearr_62116;
})();
var state_62101__$1 = state_62101;
var ex62111 = (state_62101__$1[(2)]);
var statearr_62117_62138 = state_62101__$1;
(statearr_62117_62138[(5)] = ex62111);


if((ex62111 instanceof Error)){
var statearr_62118_62139 = state_62101__$1;
(statearr_62118_62139[(1)] = (4));

(statearr_62118_62139[(5)] = null);

} else {
throw ex62111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (10))){
var inst_62078 = (state_62101[(10)]);
var inst_62082 = (state_62101[(13)]);
var inst_62088 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62089 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62078,inst_62082);
var state_62101__$1 = (function (){var statearr_62119 = state_62101;
(statearr_62119[(14)] = inst_62088);

return statearr_62119;
})();
var statearr_62120_62140 = state_62101__$1;
(statearr_62120_62140[(2)] = inst_62089);

(statearr_62120_62140[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62102 === (8))){
var inst_62078 = (state_62101[(10)]);
var inst_62096 = (state_62101[(2)]);
var _ = (function (){var statearr_62121 = state_62101;
(statearr_62121[(4)] = cljs.core.rest((state_62101[(4)])));

return statearr_62121;
})();
var state_62101__$1 = (function (){var statearr_62122 = state_62101;
(statearr_62122[(15)] = inst_62096);

return statearr_62122;
})();
var statearr_62123_62141 = state_62101__$1;
(statearr_62123_62141[(2)] = inst_62078);

(statearr_62123_62141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2414__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_62124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62124[(0)] = fluree$db$connection$establish_socket_$_state_machine__2414__auto__);

(statearr_62124[(1)] = (1));

return statearr_62124;
});
var fluree$db$connection$establish_socket_$_state_machine__2414__auto____1 = (function (state_62101){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62101);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62125){var ex__2417__auto__ = e62125;
var statearr_62126_62142 = state_62101;
(statearr_62126_62142[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62101[(4)]))){
var statearr_62127_62143 = state_62101;
(statearr_62127_62143[(1)] = cljs.core.first((state_62101[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62144 = state_62101;
state_62101 = G__62144;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2414__auto__ = function(state_62101){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2414__auto____1.call(this,state_62101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2414__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2414__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62128 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62128[(6)] = c__2436__auto__);

return statearr_62128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k62146,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__62150 = k62146;
var G__62150__$1 = (((G__62150 instanceof cljs.core.Keyword))?G__62150.fqn:null);
switch (G__62150__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62146,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__62151){
var vec__62152 = p__62151;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62152,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62152,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62145){
var self__ = this;
var G__62145__$1 = this;
return (new cljs.core.RecordIter((0),G__62145__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__62155 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__62155(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62147,other62148){
var self__ = this;
var this62147__$1 = this;
return (((!((other62148 == null)))) && ((this62147__$1.constructor === other62148.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.id,other62148.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.servers,other62148.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.state,other62148.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.req_chan,other62148.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.sub_chan,other62148.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.pub_chan,other62148.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.storage_read,other62148.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.storage_write,other62148.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.object_cache,other62148.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.parallelism,other62148.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.serializer,other62148.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.default_network,other62148.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.transactor_QMARK_,other62148.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.publish,other62148.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.transact_handler,other62148.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.tx_private_key,other62148.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.tx_key_id,other62148.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.meta,other62148.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.add_listener,other62148.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.remove_listener,other62148.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.close,other62148.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62147__$1.__extmap,other62148.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__62145){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__62156 = cljs.core.keyword_identical_QMARK_;
var expr__62157 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__62159 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62160 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62159,G__62160) : pred__62156.call(null,G__62159,G__62160));
})())){
return (new fluree.db.connection.Connection(G__62145,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62161 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62162 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62161,G__62162) : pred__62156.call(null,G__62161,G__62162));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62145,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62163 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62164 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62163,G__62164) : pred__62156.call(null,G__62163,G__62164));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62145,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62165 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62166 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62165,G__62166) : pred__62156.call(null,G__62165,G__62166));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62145,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62167 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62168 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62167,G__62168) : pred__62156.call(null,G__62167,G__62168));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62145,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62169 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62170 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62169,G__62170) : pred__62156.call(null,G__62169,G__62170));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62145,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62171 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62172 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62171,G__62172) : pred__62156.call(null,G__62171,G__62172));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62145,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62173 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62174 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62173,G__62174) : pred__62156.call(null,G__62173,G__62174));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__62145,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62175 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62176 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62175,G__62176) : pred__62156.call(null,G__62175,G__62176));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__62145,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62177 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62178 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62177,G__62178) : pred__62156.call(null,G__62177,G__62178));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__62145,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62179 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62180 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62179,G__62180) : pred__62156.call(null,G__62179,G__62180));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62145,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62181 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62182 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62181,G__62182) : pred__62156.call(null,G__62181,G__62182));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62145,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62183 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62184 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62183,G__62184) : pred__62156.call(null,G__62183,G__62184));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62145,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62185 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62186 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62185,G__62186) : pred__62156.call(null,G__62185,G__62186));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62145,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62187 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62188 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62187,G__62188) : pred__62156.call(null,G__62187,G__62188));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62145,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62189 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62190 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62189,G__62190) : pred__62156.call(null,G__62189,G__62190));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62145,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62191 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62192 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62191,G__62192) : pred__62156.call(null,G__62191,G__62192));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62145,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62193 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62194 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62193,G__62194) : pred__62156.call(null,G__62193,G__62194));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62145,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62195 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62196 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62195,G__62196) : pred__62156.call(null,G__62195,G__62196));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62145,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62197 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62198 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62197,G__62198) : pred__62156.call(null,G__62197,G__62198));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62145,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62199 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62200 = expr__62157;
return (pred__62156.cljs$core$IFn$_invoke$arity$2 ? pred__62156.cljs$core$IFn$_invoke$arity$2(G__62199,G__62200) : pred__62156.call(null,G__62199,G__62200));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62145,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__62145),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__62145){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62145,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62149){
var extmap__4419__auto__ = (function (){var G__62201 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62149,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62149)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62201);
} else {
return G__62201;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62149),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62149),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62206 = servers_STAR_;
var vec__62207 = G__62206;
var seq__62208 = cljs.core.seq(vec__62207);
var first__62209 = cljs.core.first(seq__62208);
var seq__62208__$1 = cljs.core.next(seq__62208);
var server = first__62209;
var r = seq__62208__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62206__$1 = G__62206;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62213 = G__62206__$1;
var seq__62214 = cljs.core.seq(vec__62213);
var first__62215 = cljs.core.first(seq__62214);
var seq__62214__$1 = cljs.core.next(seq__62214);
var server__$1 = first__62215;
var r__$1 = seq__62214__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62216 = r__$1;
var G__62217 = is_https_QMARK_;
var G__62218 = result_STAR_;
G__62206__$1 = G__62216;
https_QMARK___$1 = G__62217;
result__$1 = G__62218;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62219 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62219 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62219);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62248){
var state_val_62249 = (state_62248[(1)]);
if((state_val_62249 === (7))){
var inst_62234 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62235 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62236 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62237 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62238 = fluree.db.connection.establish_socket(inst_62234,inst_62235,inst_62236,inst_62237);
var state_62248__$1 = state_62248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62248__$1,(9),inst_62238);
} else {
if((state_val_62249 === (1))){
var state_62248__$1 = state_62248;
var statearr_62250_62269 = state_62248__$1;
(statearr_62250_62269[(2)] = null);

(statearr_62250_62269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (4))){
var inst_62220 = (state_62248[(2)]);
var state_62248__$1 = state_62248;
var statearr_62251_62270 = state_62248__$1;
(statearr_62251_62270[(2)] = inst_62220);

(statearr_62251_62270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (6))){
var inst_62231 = (state_62248[(7)]);
var state_62248__$1 = state_62248;
var statearr_62252_62271 = state_62248__$1;
(statearr_62252_62271[(2)] = inst_62231);

(statearr_62252_62271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (3))){
var inst_62246 = (state_62248[(2)]);
var state_62248__$1 = state_62248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62248__$1,inst_62246);
} else {
if((state_val_62249 === (2))){
var inst_62231 = (state_62248[(7)]);
var _ = (function (){var statearr_62254 = state_62248;
(statearr_62254[(4)] = cljs.core.cons((5),(state_62248[(4)])));

return statearr_62254;
})();
var inst_62226 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62228 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62229 = [inst_62228,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62230 = (new cljs.core.PersistentVector(null,3,(5),inst_62227,inst_62229,null));
var inst_62231__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62226,inst_62230);
var state_62248__$1 = (function (){var statearr_62255 = state_62248;
(statearr_62255[(7)] = inst_62231__$1);

return statearr_62255;
})();
if(cljs.core.truth_(inst_62231__$1)){
var statearr_62256_62272 = state_62248__$1;
(statearr_62256_62272[(1)] = (6));

} else {
var statearr_62257_62273 = state_62248__$1;
(statearr_62257_62273[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (9))){
var inst_62240 = (state_62248[(2)]);
var inst_62241 = fluree.db.util.async.throw_err(inst_62240);
var state_62248__$1 = state_62248;
var statearr_62258_62274 = state_62248__$1;
(statearr_62258_62274[(2)] = inst_62241);

(statearr_62258_62274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (5))){
var _ = (function (){var statearr_62259 = state_62248;
(statearr_62259[(4)] = cljs.core.rest((state_62248[(4)])));

return statearr_62259;
})();
var state_62248__$1 = state_62248;
var ex62253 = (state_62248__$1[(2)]);
var statearr_62260_62275 = state_62248__$1;
(statearr_62260_62275[(5)] = ex62253);


if((ex62253 instanceof Error)){
var statearr_62261_62276 = state_62248__$1;
(statearr_62261_62276[(1)] = (4));

(statearr_62261_62276[(5)] = null);

} else {
throw ex62253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62249 === (8))){
var inst_62243 = (state_62248[(2)]);
var _ = (function (){var statearr_62262 = state_62248;
(statearr_62262[(4)] = cljs.core.rest((state_62248[(4)])));

return statearr_62262;
})();
var state_62248__$1 = state_62248;
var statearr_62263_62277 = state_62248__$1;
(statearr_62263_62277[(2)] = inst_62243);

(statearr_62263_62277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2414__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_62264 = [null,null,null,null,null,null,null,null];
(statearr_62264[(0)] = fluree$db$connection$get_socket_$_state_machine__2414__auto__);

(statearr_62264[(1)] = (1));

return statearr_62264;
});
var fluree$db$connection$get_socket_$_state_machine__2414__auto____1 = (function (state_62248){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62248);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62265){var ex__2417__auto__ = e62265;
var statearr_62266_62278 = state_62248;
(statearr_62266_62278[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62248[(4)]))){
var statearr_62267_62279 = state_62248;
(statearr_62267_62279[(1)] = cljs.core.first((state_62248[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62280 = state_62248;
state_62248 = G__62280;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2414__auto__ = function(state_62248){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2414__auto____1.call(this,state_62248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2414__auto____0;
fluree$db$connection$get_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2414__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62268 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62268[(6)] = c__2436__auto__);

return statearr_62268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62281){var e = e62281;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62428){
var state_val_62429 = (state_62428[(1)]);
if((state_val_62429 === (7))){
var inst_62424 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62431_62514 = state_62428__$1;
(statearr_62431_62514[(2)] = inst_62424);

(statearr_62431_62514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (20))){
var _ = (function (){var statearr_62432 = state_62428;
(statearr_62432[(4)] = cljs.core.rest((state_62428[(4)])));

return statearr_62432;
})();
var state_62428__$1 = state_62428;
var ex62430 = (state_62428__$1[(2)]);
var statearr_62433_62515 = state_62428__$1;
(statearr_62433_62515[(5)] = ex62430);


var statearr_62434_62516 = state_62428__$1;
(statearr_62434_62516[(1)] = (10));

(statearr_62434_62516[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (27))){
var inst_62326 = (state_62428[(7)]);
var inst_62344 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_62326);
var state_62428__$1 = state_62428;
var statearr_62435_62517 = state_62428__$1;
(statearr_62435_62517[(2)] = inst_62344);

(statearr_62435_62517[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (1))){
var inst_62283 = (0);
var state_62428__$1 = (function (){var statearr_62436 = state_62428;
(statearr_62436[(8)] = inst_62283);

return statearr_62436;
})();
var statearr_62437_62518 = state_62428__$1;
(statearr_62437_62518[(2)] = null);

(statearr_62437_62518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (24))){
var state_62428__$1 = state_62428;
var statearr_62438_62519 = state_62428__$1;
(statearr_62438_62519[(2)] = true);

(statearr_62438_62519[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (39))){
var inst_62414 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62439_62520 = state_62428__$1;
(statearr_62439_62520[(2)] = inst_62414);

(statearr_62439_62520[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (4))){
var inst_62286 = (state_62428[(9)]);
var inst_62286__$1 = (state_62428[(2)]);
var state_62428__$1 = (function (){var statearr_62440 = state_62428;
(statearr_62440[(9)] = inst_62286__$1);

return statearr_62440;
})();
if(cljs.core.truth_(inst_62286__$1)){
var statearr_62441_62521 = state_62428__$1;
(statearr_62441_62521[(1)] = (5));

} else {
var statearr_62442_62522 = state_62428__$1;
(statearr_62442_62522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (15))){
var inst_62299 = (state_62428[(10)]);
var state_62428__$1 = state_62428;
var statearr_62443_62523 = state_62428__$1;
(statearr_62443_62523[(2)] = inst_62299);

(statearr_62443_62523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (21))){
var inst_62326 = (state_62428[(7)]);
var inst_62331 = inst_62326.cljs$lang$protocol_mask$partition0$;
var inst_62332 = (inst_62331 & (64));
var inst_62333 = inst_62326.cljs$core$ISeq$;
var inst_62334 = (cljs.core.PROTOCOL_SENTINEL === inst_62333);
var inst_62335 = ((inst_62332) || (inst_62334));
var state_62428__$1 = state_62428;
if(cljs.core.truth_(inst_62335)){
var statearr_62444_62524 = state_62428__$1;
(statearr_62444_62524[(1)] = (24));

} else {
var statearr_62445_62525 = state_62428__$1;
(statearr_62445_62525[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (31))){
var state_62428__$1 = state_62428;
var statearr_62446_62526 = state_62428__$1;
(statearr_62446_62526[(2)] = null);

(statearr_62446_62526[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (32))){
var inst_62323 = (state_62428[(11)]);
var inst_62350 = (state_62428[(12)]);
var inst_62324 = (state_62428[(13)]);
var inst_62388 = (state_62428[(2)]);
var inst_62389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62390 = [inst_62323,inst_62350,inst_62324];
var inst_62391 = (new cljs.core.PersistentVector(null,3,(5),inst_62389,inst_62390,null));
var inst_62392 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62391) : publish_fn.call(null,conn,inst_62391));
var state_62428__$1 = (function (){var statearr_62447 = state_62428;
(statearr_62447[(14)] = inst_62388);

return statearr_62447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62428__$1,(33),inst_62392);
} else {
if((state_val_62429 === (40))){
var inst_62404 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62428__$1 = state_62428;
var statearr_62448_62527 = state_62428__$1;
(statearr_62448_62527[(2)] = inst_62404);

(statearr_62448_62527[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (33))){
var inst_62394 = (state_62428[(15)]);
var inst_62394__$1 = (state_62428[(2)]);
var inst_62395 = inst_62394__$1 === true;
var state_62428__$1 = (function (){var statearr_62449 = state_62428;
(statearr_62449[(15)] = inst_62394__$1);

return statearr_62449;
})();
if(cljs.core.truth_(inst_62395)){
var statearr_62450_62528 = state_62428__$1;
(statearr_62450_62528[(1)] = (34));

} else {
var statearr_62451_62529 = state_62428__$1;
(statearr_62451_62529[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (13))){
var inst_62299 = (state_62428[(10)]);
var inst_62296 = (state_62428[(2)]);
var inst_62297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62296,(0),null);
var inst_62298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62296,(1),null);
var inst_62299__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62296,(2),null);
var state_62428__$1 = (function (){var statearr_62452 = state_62428;
(statearr_62452[(10)] = inst_62299__$1);

(statearr_62452[(16)] = inst_62297);

(statearr_62452[(17)] = inst_62298);

return statearr_62452;
})();
if(cljs.core.truth_(inst_62299__$1)){
var statearr_62453_62530 = state_62428__$1;
(statearr_62453_62530[(1)] = (14));

} else {
var statearr_62454_62531 = state_62428__$1;
(statearr_62454_62531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (22))){
var state_62428__$1 = state_62428;
var statearr_62455_62532 = state_62428__$1;
(statearr_62455_62532[(2)] = false);

(statearr_62455_62532[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (36))){
var inst_62416 = (state_62428[(2)]);
var _ = (function (){var statearr_62456 = state_62428;
(statearr_62456[(4)] = cljs.core.rest((state_62428[(4)])));

return statearr_62456;
})();
var state_62428__$1 = state_62428;
var statearr_62457_62533 = state_62428__$1;
(statearr_62457_62533[(2)] = inst_62416);

(statearr_62457_62533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (41))){
var state_62428__$1 = state_62428;
var statearr_62458_62534 = state_62428__$1;
(statearr_62458_62534[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (43))){
var inst_62394 = (state_62428[(15)]);
var inst_62407 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62394], 0));
var state_62428__$1 = state_62428;
var statearr_62460_62535 = state_62428__$1;
(statearr_62460_62535[(2)] = inst_62407);

(statearr_62460_62535[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (29))){
var inst_62325 = (state_62428[(18)]);
var inst_62347 = (state_62428[(19)]);
var inst_62347__$1 = (state_62428[(2)]);
var inst_62348 = fluree.db.util.core.random_uuid();
var inst_62349 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62348);
var inst_62350 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62347__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62349);
var inst_62351 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62347__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62428__$1 = (function (){var statearr_62461 = state_62428;
(statearr_62461[(20)] = inst_62351);

(statearr_62461[(12)] = inst_62350);

(statearr_62461[(19)] = inst_62347__$1);

return statearr_62461;
})();
if(cljs.core.truth_(inst_62325)){
var statearr_62462_62536 = state_62428__$1;
(statearr_62462_62536[(1)] = (30));

} else {
var statearr_62463_62537 = state_62428__$1;
(statearr_62463_62537[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (44))){
var state_62428__$1 = state_62428;
var statearr_62464_62538 = state_62428__$1;
(statearr_62464_62538[(2)] = null);

(statearr_62464_62538[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (6))){
var state_62428__$1 = state_62428;
var statearr_62465_62539 = state_62428__$1;
(statearr_62465_62539[(2)] = null);

(statearr_62465_62539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (28))){
var inst_62326 = (state_62428[(7)]);
var state_62428__$1 = state_62428;
var statearr_62466_62540 = state_62428__$1;
(statearr_62466_62540[(2)] = inst_62326);

(statearr_62466_62540[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (25))){
var state_62428__$1 = state_62428;
var statearr_62467_62541 = state_62428__$1;
(statearr_62467_62541[(2)] = false);

(statearr_62467_62541[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (34))){
var state_62428__$1 = state_62428;
var statearr_62468_62542 = state_62428__$1;
(statearr_62468_62542[(2)] = null);

(statearr_62468_62542[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (17))){
var inst_62288 = (state_62428[(21)]);
var inst_62299 = (state_62428[(10)]);
var inst_62306 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62299,inst_62288);
var state_62428__$1 = state_62428;
var statearr_62469_62543 = state_62428__$1;
(statearr_62469_62543[(2)] = inst_62306);

(statearr_62469_62543[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (3))){
var inst_62426 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62428__$1,inst_62426);
} else {
if((state_val_62429 === (12))){
var state_62428__$1 = state_62428;
var statearr_62470_62544 = state_62428__$1;
(statearr_62470_62544[(2)] = null);

(statearr_62470_62544[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (2))){
var state_62428__$1 = state_62428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62428__$1,(4),req_chan);
} else {
if((state_val_62429 === (23))){
var inst_62342 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
if(cljs.core.truth_(inst_62342)){
var statearr_62471_62545 = state_62428__$1;
(statearr_62471_62545[(1)] = (27));

} else {
var statearr_62472_62546 = state_62428__$1;
(statearr_62472_62546[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (35))){
var inst_62394 = (state_62428[(15)]);
var inst_62398 = fluree.db.util.core.exception_QMARK_(inst_62394);
var state_62428__$1 = state_62428;
if(inst_62398){
var statearr_62473_62547 = state_62428__$1;
(statearr_62473_62547[(1)] = (37));

} else {
var statearr_62474_62548 = state_62428__$1;
(statearr_62474_62548[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (19))){
var inst_62312 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62475_62549 = state_62428__$1;
(statearr_62475_62549[(2)] = inst_62312);

(statearr_62475_62549[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (11))){
var inst_62286 = (state_62428[(9)]);
var state_62428__$1 = state_62428;
var statearr_62476_62550 = state_62428__$1;
(statearr_62476_62550[(2)] = inst_62286);

(statearr_62476_62550[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (9))){
var inst_62283 = (state_62428[(8)]);
var inst_62419 = (state_62428[(2)]);
var inst_62420 = (inst_62283 + (1));
var inst_62283__$1 = inst_62420;
var state_62428__$1 = (function (){var statearr_62477 = state_62428;
(statearr_62477[(22)] = inst_62419);

(statearr_62477[(8)] = inst_62283__$1);

return statearr_62477;
})();
var statearr_62478_62551 = state_62428__$1;
(statearr_62478_62551[(2)] = null);

(statearr_62478_62551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (5))){
var state_62428__$1 = state_62428;
var statearr_62479_62552 = state_62428__$1;
(statearr_62479_62552[(2)] = null);

(statearr_62479_62552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (14))){
var inst_62299 = (state_62428[(10)]);
var inst_62301 = fluree.db.util.async.channel_QMARK_(inst_62299);
var state_62428__$1 = state_62428;
var statearr_62480_62553 = state_62428__$1;
(statearr_62480_62553[(2)] = inst_62301);

(statearr_62480_62553[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (45))){
var inst_62410 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62481_62554 = state_62428__$1;
(statearr_62481_62554[(2)] = inst_62410);

(statearr_62481_62554[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (26))){
var inst_62339 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62482_62555 = state_62428__$1;
(statearr_62482_62555[(2)] = inst_62339);

(statearr_62482_62555[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (16))){
var inst_62304 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
if(cljs.core.truth_(inst_62304)){
var statearr_62483_62556 = state_62428__$1;
(statearr_62483_62556[(1)] = (17));

} else {
var statearr_62484_62557 = state_62428__$1;
(statearr_62484_62557[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (38))){
var inst_62394 = (state_62428[(15)]);
var inst_62402 = (inst_62394 == null);
var state_62428__$1 = state_62428;
if(cljs.core.truth_(inst_62402)){
var statearr_62485_62558 = state_62428__$1;
(statearr_62485_62558[(1)] = (40));

} else {
var statearr_62486_62559 = state_62428__$1;
(statearr_62486_62559[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (30))){
var inst_62351 = (state_62428[(20)]);
var inst_62323 = (state_62428[(11)]);
var inst_62325 = (state_62428[(18)]);
var inst_62326 = (state_62428[(7)]);
var inst_62350 = (state_62428[(12)]);
var inst_62324 = (state_62428[(13)]);
var inst_62283 = (state_62428[(8)]);
var inst_62347 = (state_62428[(19)]);
var inst_62286 = (state_62428[(9)]);
var inst_62322 = (state_62428[(23)]);
var inst_62353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62354 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62350];
var inst_62355 = (new cljs.core.PersistentVector(null,2,(5),inst_62353,inst_62354,null));
var inst_62356 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62355,inst_62325);
var inst_62383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62384 = (function (){var resp_chan = inst_62325;
var vec__62318 = inst_62286;
var timeout = inst_62351;
var c__2436__auto____$1 = inst_62383;
var i = inst_62283;
var data = inst_62324;
var map__62321 = inst_62347;
var _ = inst_62322;
var req_id = inst_62350;
var operation = inst_62323;
var msg = inst_62286;
var opts = inst_62326;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62381){
var state_val_62382 = (state_62381[(1)]);
if((state_val_62382 === (1))){
var inst_62360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62361 = cljs.core.async.timeout(timeout);
var inst_62362 = [resp_chan,inst_62361];
var inst_62363 = (new cljs.core.PersistentVector(null,2,(5),inst_62360,inst_62362,null));
var state_62381__$1 = state_62381;
return cljs.core.async.ioc_alts_BANG_(state_62381__$1,(2),inst_62363);
} else {
if((state_val_62382 === (2))){
var inst_62366 = (state_62381[(7)]);
var inst_62365 = (state_62381[(2)]);
var inst_62366__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62365,(0),null);
var inst_62367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62365,(1),null);
var inst_62368 = (function (){var vec__62357 = inst_62365;
var resp = inst_62366__$1;
var c = inst_62367;
return (function (p1__62282_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62282_SHARP_,req_id);
});
})();
var inst_62369 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62368);
var inst_62370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62367,resp_chan);
var state_62381__$1 = (function (){var statearr_62487 = state_62381;
(statearr_62487[(8)] = inst_62369);

(statearr_62487[(7)] = inst_62366__$1);

return statearr_62487;
})();
if(inst_62370){
var statearr_62488_62560 = state_62381__$1;
(statearr_62488_62560[(1)] = (3));

} else {
var statearr_62489_62561 = state_62381__$1;
(statearr_62489_62561[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62382 === (3))){
var inst_62366 = (state_62381[(7)]);
var state_62381__$1 = state_62381;
var statearr_62490_62562 = state_62381__$1;
(statearr_62490_62562[(2)] = inst_62366);

(statearr_62490_62562[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62382 === (4))){
var inst_62373 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62374 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62375 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62376 = cljs.core.PersistentHashMap.fromArrays(inst_62374,inst_62375);
var inst_62377 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62373,inst_62376);
var state_62381__$1 = state_62381;
var statearr_62491_62563 = state_62381__$1;
(statearr_62491_62563[(2)] = inst_62377);

(statearr_62491_62563[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62382 === (5))){
var inst_62379 = (state_62381[(2)]);
var state_62381__$1 = state_62381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62381__$1,inst_62379);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____0 = (function (){
var statearr_62492 = [null,null,null,null,null,null,null,null,null];
(statearr_62492[(0)] = fluree$db$connection$msg_producer_$_state_machine__2414__auto__);

(statearr_62492[(1)] = (1));

return statearr_62492;
});
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____1 = (function (state_62381){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62381);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62493){var ex__2417__auto__ = e62493;
var statearr_62494_62564 = state_62381;
(statearr_62494_62564[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62381[(4)]))){
var statearr_62495_62565 = state_62381;
(statearr_62495_62565[(1)] = cljs.core.first((state_62381[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62566 = state_62381;
state_62381 = G__62566;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = function(state_62381){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____1.call(this,state_62381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62496 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62496[(6)] = c__2436__auto____$1);

return statearr_62496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_62385 = cljs.core.async.impl.dispatch.run(inst_62384);
var state_62428__$1 = (function (){var statearr_62497 = state_62428;
(statearr_62497[(24)] = inst_62385);

(statearr_62497[(25)] = inst_62356);

return statearr_62497;
})();
var statearr_62498_62567 = state_62428__$1;
(statearr_62498_62567[(2)] = inst_62383);

(statearr_62498_62567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (10))){
var inst_62286 = (state_62428[(9)]);
var inst_62288 = (state_62428[(2)]);
var inst_62292 = cljs.core.sequential_QMARK_(inst_62286);
var state_62428__$1 = (function (){var statearr_62499 = state_62428;
(statearr_62499[(21)] = inst_62288);

return statearr_62499;
})();
if(inst_62292){
var statearr_62500_62568 = state_62428__$1;
(statearr_62500_62568[(1)] = (11));

} else {
var statearr_62501_62569 = state_62428__$1;
(statearr_62501_62569[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (18))){
var inst_62288 = (state_62428[(21)]);
var inst_62286 = (state_62428[(9)]);
var inst_62308 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62286], 0));
var inst_62309 = ["Error processing ledger request, no valid return channel: ",inst_62308].join('');
var inst_62310 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62288,inst_62309], 0));
var state_62428__$1 = state_62428;
var statearr_62502_62570 = state_62428__$1;
(statearr_62502_62570[(2)] = inst_62310);

(statearr_62502_62570[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (42))){
var inst_62412 = (state_62428[(2)]);
var state_62428__$1 = state_62428;
var statearr_62503_62571 = state_62428__$1;
(statearr_62503_62571[(2)] = inst_62412);

(statearr_62503_62571[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (37))){
var inst_62394 = (state_62428[(15)]);
var inst_62400 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62394,"Error processing message in producer."], 0));
var state_62428__$1 = state_62428;
var statearr_62504_62572 = state_62428__$1;
(statearr_62504_62572[(2)] = inst_62400);

(statearr_62504_62572[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62429 === (8))){
var inst_62326 = (state_62428[(7)]);
var inst_62286 = (state_62428[(9)]);
var _ = (function (){var statearr_62505 = state_62428;
(statearr_62505[(4)] = cljs.core.cons((20),(state_62428[(4)])));

return statearr_62505;
})();
var inst_62322 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62286], 0));
var inst_62323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62286,(0),null);
var inst_62324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62286,(1),null);
var inst_62325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62286,(2),null);
var inst_62326__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62286,(3),null);
var inst_62328 = (inst_62326__$1 == null);
var inst_62329 = cljs.core.not(inst_62328);
var state_62428__$1 = (function (){var statearr_62506 = state_62428;
(statearr_62506[(11)] = inst_62323);

(statearr_62506[(18)] = inst_62325);

(statearr_62506[(7)] = inst_62326__$1);

(statearr_62506[(13)] = inst_62324);

(statearr_62506[(23)] = inst_62322);

return statearr_62506;
})();
if(inst_62329){
var statearr_62507_62573 = state_62428__$1;
(statearr_62507_62573[(1)] = (21));

} else {
var statearr_62508_62574 = state_62428__$1;
(statearr_62508_62574[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____0 = (function (){
var statearr_62509 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62509[(0)] = fluree$db$connection$msg_producer_$_state_machine__2414__auto__);

(statearr_62509[(1)] = (1));

return statearr_62509;
});
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____1 = (function (state_62428){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62428);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62510){var ex__2417__auto__ = e62510;
var statearr_62511_62575 = state_62428;
(statearr_62511_62575[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62428[(4)]))){
var statearr_62512_62576 = state_62428;
(statearr_62512_62576[(1)] = cljs.core.first((state_62428[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62577 = state_62428;
state_62428 = G__62577;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = function(state_62428){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____1.call(this,state_62428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62513 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62513[(6)] = c__2436__auto__);

return statearr_62513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62578 = conn;
var map__62578__$1 = (((((!((map__62578 == null))))?(((((map__62578.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62578.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__62578):map__62578);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62578__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62661){
var state_val_62662 = (state_62661[(1)]);
if((state_val_62662 === (7))){
var inst_62657 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62663_62714 = state_62661__$1;
(statearr_62663_62714[(2)] = inst_62657);

(statearr_62663_62714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (20))){
var inst_62598 = (state_62661[(7)]);
var inst_62612 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62613 = [inst_62598];
var inst_62614 = cljs.core.PersistentHashMap.fromArrays(inst_62612,inst_62613);
var inst_62615 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_62614], 0));
var state_62661__$1 = state_62661;
var statearr_62664_62715 = state_62661__$1;
(statearr_62664_62715[(2)] = inst_62615);

(statearr_62664_62715[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (27))){
var state_62661__$1 = state_62661;
var statearr_62665_62716 = state_62661__$1;
(statearr_62665_62716[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (1))){
var inst_62580 = (0);
var state_62661__$1 = (function (){var statearr_62667 = state_62661;
(statearr_62667[(8)] = inst_62580);

return statearr_62667;
})();
var statearr_62668_62717 = state_62661__$1;
(statearr_62668_62717[(2)] = null);

(statearr_62668_62717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (24))){
var inst_62591 = (state_62661[(9)]);
var inst_62640 = fluree.db.util.core.exception_QMARK_(inst_62591);
var state_62661__$1 = state_62661;
if(inst_62640){
var statearr_62669_62718 = state_62661__$1;
(statearr_62669_62718[(1)] = (26));

} else {
var statearr_62670_62719 = state_62661__$1;
(statearr_62670_62719[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (4))){
var inst_62585 = (state_62661[(10)]);
var inst_62590 = (state_62661[(2)]);
var inst_62591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62590,(0),null);
var inst_62592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62590,(1),null);
var inst_62593 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62592,inst_62585);
var state_62661__$1 = (function (){var statearr_62671 = state_62661;
(statearr_62671[(9)] = inst_62591);

return statearr_62671;
})();
if(inst_62593){
var statearr_62672_62720 = state_62661__$1;
(statearr_62672_62720[(1)] = (5));

} else {
var statearr_62673_62721 = state_62661__$1;
(statearr_62673_62721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (15))){
var inst_62598 = (state_62661[(7)]);
var inst_62607 = typeof inst_62598 === 'string';
var state_62661__$1 = state_62661;
if(cljs.core.truth_(inst_62607)){
var statearr_62674_62722 = state_62661__$1;
(statearr_62674_62722[(1)] = (17));

} else {
var statearr_62675_62723 = state_62661__$1;
(statearr_62675_62723[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (21))){
var state_62661__$1 = state_62661;
var statearr_62676_62724 = state_62661__$1;
(statearr_62676_62724[(2)] = null);

(statearr_62676_62724[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (31))){
var inst_62651 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62677_62725 = state_62661__$1;
(statearr_62677_62725[(2)] = inst_62651);

(statearr_62677_62725[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (13))){
var inst_62624 = (state_62661[(2)]);
var inst_62625 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62626 = fluree.db.connection.close_websocket(inst_62625);
var inst_62627 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62628 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_62627);
var state_62661__$1 = (function (){var statearr_62678 = state_62661;
(statearr_62678[(11)] = inst_62624);

(statearr_62678[(12)] = inst_62626);

return statearr_62678;
})();
var statearr_62679_62726 = state_62661__$1;
(statearr_62679_62726[(2)] = inst_62628);

(statearr_62679_62726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (22))){
var inst_62618 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62680_62727 = state_62661__$1;
(statearr_62680_62727[(2)] = inst_62618);

(statearr_62680_62727[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (29))){
var inst_62591 = (state_62661[(9)]);
var inst_62646 = fluree.db.util.json.parse(inst_62591);
var inst_62647 = fluree.db.conn_events.process_events(conn,inst_62646);
var inst_62580 = (0);
var state_62661__$1 = (function (){var statearr_62681 = state_62661;
(statearr_62681[(8)] = inst_62580);

(statearr_62681[(13)] = inst_62647);

return statearr_62681;
})();
var statearr_62682_62728 = state_62661__$1;
(statearr_62682_62728[(2)] = null);

(statearr_62682_62728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (6))){
var inst_62591 = (state_62661[(9)]);
var inst_62636 = (inst_62591 == null);
var state_62661__$1 = state_62661;
if(cljs.core.truth_(inst_62636)){
var statearr_62683_62729 = state_62661__$1;
(statearr_62683_62729[(1)] = (23));

} else {
var statearr_62684_62730 = state_62661__$1;
(statearr_62684_62730[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (28))){
var inst_62653 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62685_62731 = state_62661__$1;
(statearr_62685_62731[(2)] = inst_62653);

(statearr_62685_62731[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (25))){
var inst_62655 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62686_62732 = state_62661__$1;
(statearr_62686_62732[(2)] = inst_62655);

(statearr_62686_62732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (17))){
var inst_62598 = (state_62661[(7)]);
var inst_62609 = cljs.core.eval(inst_62598);
var state_62661__$1 = state_62661;
var statearr_62687_62733 = state_62661__$1;
(statearr_62687_62733[(2)] = inst_62609);

(statearr_62687_62733[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (3))){
var inst_62659 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62661__$1,inst_62659);
} else {
if((state_val_62662 === (12))){
var inst_62598 = (state_62661[(7)]);
var inst_62603 = cljs.core.fn_QMARK_(inst_62598);
var state_62661__$1 = state_62661;
if(inst_62603){
var statearr_62688_62734 = state_62661__$1;
(statearr_62688_62734[(1)] = (14));

} else {
var statearr_62689_62735 = state_62661__$1;
(statearr_62689_62735[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (2))){
var inst_62585 = (state_62661[(10)]);
var inst_62585__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_62586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62587 = [sub_chan,inst_62585__$1];
var inst_62588 = (new cljs.core.PersistentVector(null,2,(5),inst_62586,inst_62587,null));
var state_62661__$1 = (function (){var statearr_62690 = state_62661;
(statearr_62690[(10)] = inst_62585__$1);

return statearr_62690;
})();
return cljs.core.async.ioc_alts_BANG_(state_62661__$1,(4),inst_62588);
} else {
if((state_val_62662 === (23))){
var inst_62638 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_62661__$1 = state_62661;
var statearr_62691_62736 = state_62661__$1;
(statearr_62691_62736[(2)] = inst_62638);

(statearr_62691_62736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (19))){
var inst_62620 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62692_62737 = state_62661__$1;
(statearr_62692_62737[(2)] = inst_62620);

(statearr_62692_62737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (11))){
var inst_62601 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_62661__$1 = state_62661;
var statearr_62693_62738 = state_62661__$1;
(statearr_62693_62738[(2)] = inst_62601);

(statearr_62693_62738[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (9))){
var inst_62580 = (state_62661[(8)]);
var inst_62630 = fluree.db.connection.ping_transactor(conn);
var inst_62631 = (inst_62580 + (1));
var inst_62580__$1 = inst_62631;
var state_62661__$1 = (function (){var statearr_62694 = state_62661;
(statearr_62694[(14)] = inst_62630);

(statearr_62694[(8)] = inst_62580__$1);

return statearr_62694;
})();
var statearr_62695_62739 = state_62661__$1;
(statearr_62695_62739[(2)] = null);

(statearr_62695_62739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (5))){
var inst_62580 = (state_62661[(8)]);
var inst_62595 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_62580);
var state_62661__$1 = state_62661;
if(inst_62595){
var statearr_62696_62740 = state_62661__$1;
(statearr_62696_62740[(1)] = (8));

} else {
var statearr_62697_62741 = state_62661__$1;
(statearr_62697_62741[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (14))){
var inst_62598 = (state_62661[(7)]);
var inst_62605 = (inst_62598.cljs$core$IFn$_invoke$arity$0 ? inst_62598.cljs$core$IFn$_invoke$arity$0() : inst_62598.call(null));
var state_62661__$1 = state_62661;
var statearr_62698_62742 = state_62661__$1;
(statearr_62698_62742[(2)] = inst_62605);

(statearr_62698_62742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (26))){
var inst_62591 = (state_62661[(9)]);
var inst_62642 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62591], 0));
var inst_62580 = (0);
var state_62661__$1 = (function (){var statearr_62699 = state_62661;
(statearr_62699[(15)] = inst_62642);

(statearr_62699[(8)] = inst_62580);

return statearr_62699;
})();
var statearr_62700_62743 = state_62661__$1;
(statearr_62700_62743[(2)] = null);

(statearr_62700_62743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (16))){
var inst_62622 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62701_62744 = state_62661__$1;
(statearr_62701_62744[(2)] = inst_62622);

(statearr_62701_62744[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (30))){
var state_62661__$1 = state_62661;
var statearr_62702_62745 = state_62661__$1;
(statearr_62702_62745[(2)] = null);

(statearr_62702_62745[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (10))){
var inst_62634 = (state_62661[(2)]);
var state_62661__$1 = state_62661;
var statearr_62703_62746 = state_62661__$1;
(statearr_62703_62746[(2)] = inst_62634);

(statearr_62703_62746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (18))){
var state_62661__$1 = state_62661;
var statearr_62704_62747 = state_62661__$1;
(statearr_62704_62747[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62662 === (8))){
var inst_62598 = (state_62661[(7)]);
var inst_62597 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_62598__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62599 = (inst_62598__$1 == null);
var state_62661__$1 = (function (){var statearr_62706 = state_62661;
(statearr_62706[(16)] = inst_62597);

(statearr_62706[(7)] = inst_62598__$1);

return statearr_62706;
})();
if(cljs.core.truth_(inst_62599)){
var statearr_62707_62748 = state_62661__$1;
(statearr_62707_62748[(1)] = (11));

} else {
var statearr_62708_62749 = state_62661__$1;
(statearr_62708_62749[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0 = (function (){
var statearr_62709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62709[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2414__auto__);

(statearr_62709[(1)] = (1));

return statearr_62709;
});
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1 = (function (state_62661){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62661);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62710){var ex__2417__auto__ = e62710;
var statearr_62711_62750 = state_62661;
(statearr_62711_62750[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62661[(4)]))){
var statearr_62712_62751 = state_62661;
(statearr_62712_62751[(1)] = cljs.core.first((state_62661[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62752 = state_62661;
state_62661 = G__62752;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__ = function(state_62661){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1.call(this,state_62661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62713 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62713[(6)] = c__2436__auto__);

return statearr_62713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62754 = arguments.length;
switch (G__62754) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62755 = opts;
var map__62755__$1 = (((((!((map__62755 == null))))?(((((map__62755.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62755.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__62755):map__62755);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62755__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62755__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62818){
var state_val_62819 = (state_62818[(1)]);
if((state_val_62819 === (7))){
var inst_62766 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62768 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62769 = (new cljs.core.PersistentVector(null,2,(5),inst_62767,inst_62768,null));
var inst_62770 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62766,inst_62769);
var state_62818__$1 = state_62818;
var statearr_62820_62861 = state_62818__$1;
(statearr_62820_62861[(2)] = inst_62770);

(statearr_62820_62861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (20))){
var inst_62797 = (state_62818[(7)]);
var state_62818__$1 = state_62818;
var statearr_62821_62862 = state_62818__$1;
(statearr_62821_62862[(2)] = inst_62797);

(statearr_62821_62862[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (1))){
var state_62818__$1 = state_62818;
var statearr_62822_62863 = state_62818__$1;
(statearr_62822_62863[(2)] = null);

(statearr_62822_62863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (4))){
var inst_62757 = (state_62818[(2)]);
var state_62818__$1 = state_62818;
var statearr_62823_62864 = state_62818__$1;
(statearr_62823_62864[(2)] = inst_62757);

(statearr_62823_62864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (15))){
var inst_62772 = (state_62818[(8)]);
var inst_62791 = (state_62818[(2)]);
var state_62818__$1 = (function (){var statearr_62824 = state_62818;
(statearr_62824[(9)] = inst_62791);

return statearr_62824;
})();
if(cljs.core.truth_(inst_62772)){
var statearr_62825_62865 = state_62818__$1;
(statearr_62825_62865[(1)] = (16));

} else {
var statearr_62826_62866 = state_62818__$1;
(statearr_62826_62866[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (21))){
var inst_62777 = (state_62818[(10)]);
var inst_62806 = (state_62818[(2)]);
var inst_62807 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62808 = [(5000),inst_62806,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_62809 = cljs.core.PersistentHashMap.fromArrays(inst_62807,inst_62808);
var inst_62810 = fluree.db.util.xhttp.get(inst_62777,inst_62809);
var state_62818__$1 = state_62818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62818__$1,(22),inst_62810);
} else {
if((state_val_62819 === (13))){
var inst_62772 = (state_62818[(8)]);
var inst_62786 = (state_62818[(11)]);
var inst_62788 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62786,"X-fdb-jwt",inst_62772);
var state_62818__$1 = state_62818;
var statearr_62827_62867 = state_62818__$1;
(statearr_62827_62867[(2)] = inst_62788);

(statearr_62827_62867[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (22))){
var inst_62812 = (state_62818[(2)]);
var inst_62813 = fluree.db.util.async.throw_err(inst_62812);
var _ = (function (){var statearr_62828 = state_62818;
(statearr_62828[(4)] = cljs.core.rest((state_62818[(4)])));

return statearr_62828;
})();
var state_62818__$1 = state_62818;
var statearr_62829_62868 = state_62818__$1;
(statearr_62829_62868[(2)] = inst_62813);

(statearr_62829_62868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (6))){
var inst_62763 = (state_62818[(12)]);
var state_62818__$1 = state_62818;
var statearr_62830_62869 = state_62818__$1;
(statearr_62830_62869[(2)] = inst_62763);

(statearr_62830_62869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (17))){
var inst_62791 = (state_62818[(9)]);
var state_62818__$1 = state_62818;
var statearr_62831_62870 = state_62818__$1;
(statearr_62831_62870[(2)] = inst_62791);

(statearr_62831_62870[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (3))){
var inst_62816 = (state_62818[(2)]);
var state_62818__$1 = state_62818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62818__$1,inst_62816);
} else {
if((state_val_62819 === (12))){
var inst_62772 = (state_62818[(8)]);
var inst_62786 = (state_62818[(2)]);
var state_62818__$1 = (function (){var statearr_62832 = state_62818;
(statearr_62832[(11)] = inst_62786);

return statearr_62832;
})();
if(cljs.core.truth_(inst_62772)){
var statearr_62833_62871 = state_62818__$1;
(statearr_62833_62871[(1)] = (13));

} else {
var statearr_62834_62872 = state_62818__$1;
(statearr_62834_62872[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (2))){
var inst_62763 = (state_62818[(12)]);
var _ = (function (){var statearr_62835 = state_62818;
(statearr_62835[(4)] = cljs.core.cons((5),(state_62818[(4)])));

return statearr_62835;
})();
var inst_62763__$1 = jwt;
var state_62818__$1 = (function (){var statearr_62836 = state_62818;
(statearr_62836[(12)] = inst_62763__$1);

return statearr_62836;
})();
if(cljs.core.truth_(inst_62763__$1)){
var statearr_62837_62873 = state_62818__$1;
(statearr_62837_62873[(1)] = (6));

} else {
var statearr_62838_62874 = state_62818__$1;
(statearr_62838_62874[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (19))){
var inst_62777 = (state_62818[(10)]);
var inst_62797 = (state_62818[(7)]);
var inst_62799 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62800 = [inst_62797];
var inst_62801 = cljs.core.PersistentHashMap.fromArrays(inst_62799,inst_62800);
var inst_62802 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62777,inst_62801,private$);
var inst_62803 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62802);
var state_62818__$1 = state_62818;
var statearr_62839_62875 = state_62818__$1;
(statearr_62839_62875[(2)] = inst_62803);

(statearr_62839_62875[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (11))){
var inst_62781 = (state_62818[(13)]);
var state_62818__$1 = state_62818;
var statearr_62841_62876 = state_62818__$1;
(statearr_62841_62876[(2)] = inst_62781);

(statearr_62841_62876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (9))){
var inst_62773 = (state_62818[(14)]);
var inst_62776 = (state_62818[(2)]);
var inst_62777 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62776),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62773)].join('');
var inst_62779 = ["Accept"];
var inst_62780 = ["application/json"];
var inst_62781 = cljs.core.PersistentHashMap.fromArrays(inst_62779,inst_62780);
var state_62818__$1 = (function (){var statearr_62842 = state_62818;
(statearr_62842[(10)] = inst_62777);

(statearr_62842[(13)] = inst_62781);

return statearr_62842;
})();
if(cljs.core.truth_(private$)){
var statearr_62843_62877 = state_62818__$1;
(statearr_62843_62877[(1)] = (10));

} else {
var statearr_62844_62878 = state_62818__$1;
(statearr_62844_62878[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (5))){
var _ = (function (){var statearr_62845 = state_62818;
(statearr_62845[(4)] = cljs.core.rest((state_62818[(4)])));

return statearr_62845;
})();
var state_62818__$1 = state_62818;
var ex62840 = (state_62818__$1[(2)]);
var statearr_62846_62879 = state_62818__$1;
(statearr_62846_62879[(5)] = ex62840);


if((ex62840 instanceof Error)){
var statearr_62847_62880 = state_62818__$1;
(statearr_62847_62880[(1)] = (4));

(statearr_62847_62880[(5)] = null);

} else {
throw ex62840;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (14))){
var inst_62786 = (state_62818[(11)]);
var state_62818__$1 = state_62818;
var statearr_62848_62881 = state_62818__$1;
(statearr_62848_62881[(2)] = inst_62786);

(statearr_62848_62881[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (16))){
var inst_62772 = (state_62818[(8)]);
var inst_62791 = (state_62818[(9)]);
var inst_62793 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62772)].join('');
var inst_62794 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62791,"Authorization",inst_62793);
var state_62818__$1 = state_62818;
var statearr_62849_62882 = state_62818__$1;
(statearr_62849_62882[(2)] = inst_62794);

(statearr_62849_62882[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (10))){
var inst_62781 = (state_62818[(13)]);
var inst_62783 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62781,"X-fdb-pri",private$);
var state_62818__$1 = state_62818;
var statearr_62850_62883 = state_62818__$1;
(statearr_62850_62883[(2)] = inst_62783);

(statearr_62850_62883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (18))){
var inst_62797 = (state_62818[(2)]);
var state_62818__$1 = (function (){var statearr_62851 = state_62818;
(statearr_62851[(7)] = inst_62797);

return statearr_62851;
})();
if(cljs.core.truth_(private$)){
var statearr_62852_62884 = state_62818__$1;
(statearr_62852_62884[(1)] = (19));

} else {
var statearr_62853_62885 = state_62818__$1;
(statearr_62853_62885[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62819 === (8))){
var inst_62772 = (state_62818[(2)]);
var inst_62773 = clojure.string.replace(k,"_","/");
var inst_62774 = fluree.db.connection.get_server(conn_id,servers);
var state_62818__$1 = (function (){var statearr_62854 = state_62818;
(statearr_62854[(14)] = inst_62773);

(statearr_62854[(8)] = inst_62772);

return statearr_62854;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62818__$1,(9),inst_62774);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2414__auto__ = null;
var fluree$db$connection$state_machine__2414__auto____0 = (function (){
var statearr_62855 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62855[(0)] = fluree$db$connection$state_machine__2414__auto__);

(statearr_62855[(1)] = (1));

return statearr_62855;
});
var fluree$db$connection$state_machine__2414__auto____1 = (function (state_62818){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62818);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62856){var ex__2417__auto__ = e62856;
var statearr_62857_62886 = state_62818;
(statearr_62857_62886[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62818[(4)]))){
var statearr_62858_62887 = state_62818;
(statearr_62858_62887[(1)] = cljs.core.first((state_62818[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62888 = state_62818;
state_62818 = G__62888;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2414__auto__ = function(state_62818){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2414__auto____1.call(this,state_62818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2414__auto____0;
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2414__auto____1;
return fluree$db$connection$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62859 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62859[(6)] = c__2436__auto__);

return statearr_62859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62889_SHARP_){
if(cljs.core.truth_(p1__62889_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62890 = opts;
var map__62890__$1 = (((((!((map__62890 == null))))?(((((map__62890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__62890):map__62890);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62890__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62890__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e62892){var _ = e62892;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62893_62894 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62893_62894.cljs$core$IFn$_invoke$arity$0 ? fexpr__62893_62894.cljs$core$IFn$_invoke$arity$0() : fexpr__62893_62894.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___62927 = arguments.length;
var i__4737__auto___62928 = (0);
while(true){
if((i__4737__auto___62928 < len__4736__auto___62927)){
args__4742__auto__.push((arguments[i__4737__auto___62928]));

var G__62929 = (i__4737__auto___62928 + (1));
i__4737__auto___62928 = G__62929;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62897){
var vec__62898 = p__62897;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62898,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2436__auto___62930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62915){
var state_val_62916 = (state_62915[(1)]);
if((state_val_62916 === (1))){
var inst_62901 = fluree.db.connection.get_socket(conn);
var state_62915__$1 = state_62915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62915__$1,(2),inst_62901);
} else {
if((state_val_62916 === (2))){
var inst_62903 = (state_62915[(2)]);
var inst_62904 = (inst_62903 == null);
var inst_62905 = fluree.db.util.core.exception_QMARK_(inst_62903);
var inst_62906 = ((inst_62904) || (inst_62905));
var state_62915__$1 = state_62915;
if(cljs.core.truth_(inst_62906)){
var statearr_62917_62931 = state_62915__$1;
(statearr_62917_62931[(1)] = (3));

} else {
var statearr_62918_62932 = state_62915__$1;
(statearr_62918_62932[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62916 === (3))){
var inst_62908 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62909 = cljs.core.async.close_BANG_(conn);
var state_62915__$1 = (function (){var statearr_62919 = state_62915;
(statearr_62919[(7)] = inst_62908);

return statearr_62919;
})();
var statearr_62920_62933 = state_62915__$1;
(statearr_62920_62933[(2)] = inst_62909);

(statearr_62920_62933[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62916 === (4))){
var inst_62911 = fluree.db.connection.msg_consumer(conn);
var state_62915__$1 = state_62915;
var statearr_62921_62934 = state_62915__$1;
(statearr_62921_62934[(2)] = inst_62911);

(statearr_62921_62934[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62916 === (5))){
var inst_62913 = (state_62915[(2)]);
var state_62915__$1 = state_62915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62915__$1,inst_62913);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2414__auto__ = null;
var fluree$db$connection$state_machine__2414__auto____0 = (function (){
var statearr_62922 = [null,null,null,null,null,null,null,null];
(statearr_62922[(0)] = fluree$db$connection$state_machine__2414__auto__);

(statearr_62922[(1)] = (1));

return statearr_62922;
});
var fluree$db$connection$state_machine__2414__auto____1 = (function (state_62915){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62915);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62923){var ex__2417__auto__ = e62923;
var statearr_62924_62935 = state_62915;
(statearr_62924_62935[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62915[(4)]))){
var statearr_62925_62936 = state_62915;
(statearr_62925_62936[(1)] = cljs.core.first((state_62915[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62937 = state_62915;
state_62915 = G__62937;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2414__auto__ = function(state_62915){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2414__auto____1.call(this,state_62915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2414__auto____0;
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2414__auto____1;
return fluree$db$connection$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62926 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62926[(6)] = c__2436__auto___62930);

return statearr_62926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62895){
var G__62896 = cljs.core.first(seq62895);
var seq62895__$1 = cljs.core.next(seq62895);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62896,seq62895__$1);
}));

