// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16506){
var state_val_16507 = (state_16506[(1)]);
if((state_val_16507 === (7))){
var inst_16495 = (state_16506[(7)]);
var inst_16497 = fluree.db.storage.core.serde(conn);
var inst_16498 = fluree.db.serde.protocol._deserialize_block(inst_16497,inst_16495);
var state_16506__$1 = state_16506;
var statearr_16508_16527 = state_16506__$1;
(statearr_16508_16527[(2)] = inst_16498);

(statearr_16508_16527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (1))){
var state_16506__$1 = state_16506;
var statearr_16509_16528 = state_16506__$1;
(statearr_16509_16528[(2)] = null);

(statearr_16509_16528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (4))){
var inst_16485 = (state_16506[(2)]);
var state_16506__$1 = state_16506;
var statearr_16510_16529 = state_16506__$1;
(statearr_16510_16529[(2)] = inst_16485);

(statearr_16510_16529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (6))){
var inst_16495 = (state_16506[(7)]);
var inst_16494 = (state_16506[(2)]);
var inst_16495__$1 = fluree.db.util.async.throw_err(inst_16494);
var state_16506__$1 = (function (){var statearr_16511 = state_16506;
(statearr_16511[(7)] = inst_16495__$1);

return statearr_16511;
})();
if(cljs.core.truth_(inst_16495__$1)){
var statearr_16512_16530 = state_16506__$1;
(statearr_16512_16530[(1)] = (7));

} else {
var statearr_16513_16531 = state_16506__$1;
(statearr_16513_16531[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (3))){
var inst_16504 = (state_16506[(2)]);
var state_16506__$1 = state_16506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16506__$1,inst_16504);
} else {
if((state_val_16507 === (2))){
var _ = (function (){var statearr_16515 = state_16506;
(statearr_16515[(4)] = cljs.core.cons((5),(state_16506[(4)])));

return statearr_16515;
})();
var inst_16491 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_16492 = fluree.db.storage.core.storage_read(conn,inst_16491);
var state_16506__$1 = state_16506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16506__$1,(6),inst_16492);
} else {
if((state_val_16507 === (9))){
var inst_16501 = (state_16506[(2)]);
var _ = (function (){var statearr_16516 = state_16506;
(statearr_16516[(4)] = cljs.core.rest((state_16506[(4)])));

return statearr_16516;
})();
var state_16506__$1 = state_16506;
var statearr_16517_16532 = state_16506__$1;
(statearr_16517_16532[(2)] = inst_16501);

(statearr_16517_16532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (5))){
var _ = (function (){var statearr_16518 = state_16506;
(statearr_16518[(4)] = cljs.core.rest((state_16506[(4)])));

return statearr_16518;
})();
var state_16506__$1 = state_16506;
var ex16514 = (state_16506__$1[(2)]);
var statearr_16519_16533 = state_16506__$1;
(statearr_16519_16533[(5)] = ex16514);


if((ex16514 instanceof Error)){
var statearr_16520_16534 = state_16506__$1;
(statearr_16520_16534[(1)] = (4));

(statearr_16520_16534[(5)] = null);

} else {
throw ex16514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16507 === (8))){
var state_16506__$1 = state_16506;
var statearr_16521_16535 = state_16506__$1;
(statearr_16521_16535[(2)] = null);

(statearr_16521_16535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2414__auto____0 = (function (){
var statearr_16522 = [null,null,null,null,null,null,null,null];
(statearr_16522[(0)] = fluree$db$storage$core$read_block_$_state_machine__2414__auto__);

(statearr_16522[(1)] = (1));

return statearr_16522;
});
var fluree$db$storage$core$read_block_$_state_machine__2414__auto____1 = (function (state_16506){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16506);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16523){var ex__2417__auto__ = e16523;
var statearr_16524_16536 = state_16506;
(statearr_16524_16536[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16506[(4)]))){
var statearr_16525_16537 = state_16506;
(statearr_16525_16537[(1)] = cljs.core.first((state_16506[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16538 = state_16506;
state_16506 = G__16538;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2414__auto__ = function(state_16506){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2414__auto____1.call(this,state_16506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16526 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16526[(6)] = c__2436__auto__);

return statearr_16526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16561){
var state_val_16562 = (state_16561[(1)]);
if((state_val_16562 === (7))){
var inst_16550 = (state_16561[(7)]);
var inst_16552 = fluree.db.storage.core.serde(conn);
var inst_16553 = fluree.db.serde.protocol._deserialize_block(inst_16552,inst_16550);
var state_16561__$1 = state_16561;
var statearr_16563_16582 = state_16561__$1;
(statearr_16563_16582[(2)] = inst_16553);

(statearr_16563_16582[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (1))){
var state_16561__$1 = state_16561;
var statearr_16564_16583 = state_16561__$1;
(statearr_16564_16583[(2)] = null);

(statearr_16564_16583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (4))){
var inst_16539 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
var statearr_16565_16584 = state_16561__$1;
(statearr_16565_16584[(2)] = inst_16539);

(statearr_16565_16584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (6))){
var inst_16550 = (state_16561[(7)]);
var inst_16549 = (state_16561[(2)]);
var inst_16550__$1 = fluree.db.util.async.throw_err(inst_16549);
var state_16561__$1 = (function (){var statearr_16566 = state_16561;
(statearr_16566[(7)] = inst_16550__$1);

return statearr_16566;
})();
if(cljs.core.truth_(inst_16550__$1)){
var statearr_16567_16585 = state_16561__$1;
(statearr_16567_16585[(1)] = (7));

} else {
var statearr_16568_16586 = state_16561__$1;
(statearr_16568_16586[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (3))){
var inst_16559 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16561__$1,inst_16559);
} else {
if((state_val_16562 === (2))){
var _ = (function (){var statearr_16570 = state_16561;
(statearr_16570[(4)] = cljs.core.cons((5),(state_16561[(4)])));

return statearr_16570;
})();
var inst_16545 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_16546 = [inst_16545,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16547 = fluree.db.storage.core.storage_read(conn,inst_16546);
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16561__$1,(6),inst_16547);
} else {
if((state_val_16562 === (9))){
var inst_16556 = (state_16561[(2)]);
var _ = (function (){var statearr_16571 = state_16561;
(statearr_16571[(4)] = cljs.core.rest((state_16561[(4)])));

return statearr_16571;
})();
var state_16561__$1 = state_16561;
var statearr_16572_16587 = state_16561__$1;
(statearr_16572_16587[(2)] = inst_16556);

(statearr_16572_16587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (5))){
var _ = (function (){var statearr_16573 = state_16561;
(statearr_16573[(4)] = cljs.core.rest((state_16561[(4)])));

return statearr_16573;
})();
var state_16561__$1 = state_16561;
var ex16569 = (state_16561__$1[(2)]);
var statearr_16574_16588 = state_16561__$1;
(statearr_16574_16588[(5)] = ex16569);


if((ex16569 instanceof Error)){
var statearr_16575_16589 = state_16561__$1;
(statearr_16575_16589[(1)] = (4));

(statearr_16575_16589[(5)] = null);

} else {
throw ex16569;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16562 === (8))){
var state_16561__$1 = state_16561;
var statearr_16576_16590 = state_16561__$1;
(statearr_16576_16590[(2)] = null);

(statearr_16576_16590[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0 = (function (){
var statearr_16577 = [null,null,null,null,null,null,null,null];
(statearr_16577[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__);

(statearr_16577[(1)] = (1));

return statearr_16577;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1 = (function (state_16561){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16561);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16578){var ex__2417__auto__ = e16578;
var statearr_16579_16591 = state_16561;
(statearr_16579_16591[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16561[(4)]))){
var statearr_16580_16592 = state_16561;
(statearr_16580_16592[(1)] = cljs.core.first((state_16561[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16593 = state_16561;
state_16561 = G__16593;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__ = function(state_16561){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1.call(this,state_16561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16581 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16581[(6)] = c__2436__auto__);

return statearr_16581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16617){
var state_val_16618 = (state_16617[(1)]);
if((state_val_16618 === (1))){
var state_16617__$1 = state_16617;
var statearr_16619_16633 = state_16617__$1;
(statearr_16619_16633[(2)] = null);

(statearr_16619_16633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (2))){
var _ = (function (){var statearr_16620 = state_16617;
(statearr_16620[(4)] = cljs.core.cons((5),(state_16617[(4)])));

return statearr_16620;
})();
var inst_16600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16601 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16602 = (new cljs.core.PersistentVector(null,3,(5),inst_16600,inst_16601,null));
var inst_16603 = cljs.core.select_keys(block_data,inst_16602);
var inst_16604 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16603);
var inst_16605 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_16604);
var inst_16606 = [inst_16605,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16607 = fluree.db.storage.core.serde(conn);
var inst_16608 = fluree.db.serde.protocol._serialize_block(inst_16607,inst_16603);
var inst_16609 = fluree.db.storage.core.storage_write(conn,inst_16606,inst_16608);
var state_16617__$1 = state_16617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16617__$1,(6),inst_16609);
} else {
if((state_val_16618 === (3))){
var inst_16615 = (state_16617[(2)]);
var state_16617__$1 = state_16617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16617__$1,inst_16615);
} else {
if((state_val_16618 === (4))){
var inst_16594 = (state_16617[(2)]);
var state_16617__$1 = state_16617;
var statearr_16622_16634 = state_16617__$1;
(statearr_16622_16634[(2)] = inst_16594);

(statearr_16622_16634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (5))){
var _ = (function (){var statearr_16623 = state_16617;
(statearr_16623[(4)] = cljs.core.rest((state_16617[(4)])));

return statearr_16623;
})();
var state_16617__$1 = state_16617;
var ex16621 = (state_16617__$1[(2)]);
var statearr_16624_16635 = state_16617__$1;
(statearr_16624_16635[(5)] = ex16621);


if((ex16621 instanceof Error)){
var statearr_16625_16636 = state_16617__$1;
(statearr_16625_16636[(1)] = (4));

(statearr_16625_16636[(5)] = null);

} else {
throw ex16621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16618 === (6))){
var inst_16611 = (state_16617[(2)]);
var inst_16612 = fluree.db.util.async.throw_err(inst_16611);
var _ = (function (){var statearr_16626 = state_16617;
(statearr_16626[(4)] = cljs.core.rest((state_16617[(4)])));

return statearr_16626;
})();
var state_16617__$1 = state_16617;
var statearr_16627_16637 = state_16617__$1;
(statearr_16627_16637[(2)] = inst_16612);

(statearr_16627_16637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0 = (function (){
var statearr_16628 = [null,null,null,null,null,null,null];
(statearr_16628[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__);

(statearr_16628[(1)] = (1));

return statearr_16628;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1 = (function (state_16617){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16617);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16629){var ex__2417__auto__ = e16629;
var statearr_16630_16638 = state_16617;
(statearr_16630_16638[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16617[(4)]))){
var statearr_16631_16639 = state_16617;
(statearr_16631_16639[(1)] = cljs.core.first((state_16617[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16640 = state_16617;
state_16617 = G__16640;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__ = function(state_16617){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1.call(this,state_16617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16632 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16632[(6)] = c__2436__auto__);

return statearr_16632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16663){
var state_val_16664 = (state_16663[(1)]);
if((state_val_16664 === (1))){
var state_16663__$1 = state_16663;
var statearr_16665_16679 = state_16663__$1;
(statearr_16665_16679[(2)] = null);

(statearr_16665_16679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (2))){
var _ = (function (){var statearr_16666 = state_16663;
(statearr_16666[(4)] = cljs.core.cons((5),(state_16663[(4)])));

return statearr_16666;
})();
var inst_16647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16648 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16649 = (new cljs.core.PersistentVector(null,3,(5),inst_16647,inst_16648,null));
var inst_16650 = cljs.core.select_keys(block_data,inst_16649);
var inst_16651 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16650);
var inst_16652 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_16651);
var inst_16653 = fluree.db.storage.core.serde(conn);
var inst_16654 = fluree.db.serde.protocol._serialize_block(inst_16653,inst_16650);
var inst_16655 = fluree.db.storage.core.storage_write(conn,inst_16652,inst_16654);
var state_16663__$1 = state_16663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16663__$1,(6),inst_16655);
} else {
if((state_val_16664 === (3))){
var inst_16661 = (state_16663[(2)]);
var state_16663__$1 = state_16663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16663__$1,inst_16661);
} else {
if((state_val_16664 === (4))){
var inst_16641 = (state_16663[(2)]);
var state_16663__$1 = state_16663;
var statearr_16668_16680 = state_16663__$1;
(statearr_16668_16680[(2)] = inst_16641);

(statearr_16668_16680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (5))){
var _ = (function (){var statearr_16669 = state_16663;
(statearr_16669[(4)] = cljs.core.rest((state_16663[(4)])));

return statearr_16669;
})();
var state_16663__$1 = state_16663;
var ex16667 = (state_16663__$1[(2)]);
var statearr_16670_16681 = state_16663__$1;
(statearr_16670_16681[(5)] = ex16667);


if((ex16667 instanceof Error)){
var statearr_16671_16682 = state_16663__$1;
(statearr_16671_16682[(1)] = (4));

(statearr_16671_16682[(5)] = null);

} else {
throw ex16667;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16664 === (6))){
var inst_16657 = (state_16663[(2)]);
var inst_16658 = fluree.db.util.async.throw_err(inst_16657);
var _ = (function (){var statearr_16672 = state_16663;
(statearr_16672[(4)] = cljs.core.rest((state_16663[(4)])));

return statearr_16672;
})();
var state_16663__$1 = state_16663;
var statearr_16673_16683 = state_16663__$1;
(statearr_16673_16683[(2)] = inst_16658);

(statearr_16673_16683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2414__auto____0 = (function (){
var statearr_16674 = [null,null,null,null,null,null,null];
(statearr_16674[(0)] = fluree$db$storage$core$write_block_$_state_machine__2414__auto__);

(statearr_16674[(1)] = (1));

return statearr_16674;
});
var fluree$db$storage$core$write_block_$_state_machine__2414__auto____1 = (function (state_16663){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16663);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16675){var ex__2417__auto__ = e16675;
var statearr_16676_16684 = state_16663;
(statearr_16676_16684[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16663[(4)]))){
var statearr_16677_16685 = state_16663;
(statearr_16677_16685[(1)] = cljs.core.first((state_16663[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16686 = state_16663;
state_16663 = G__16686;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2414__auto__ = function(state_16663){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2414__auto____1.call(this,state_16663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16678 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16678[(6)] = c__2436__auto__);

return statearr_16678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16706){
var state_val_16707 = (state_16706[(1)]);
if((state_val_16707 === (1))){
var state_16706__$1 = state_16706;
var statearr_16708_16722 = state_16706__$1;
(statearr_16708_16722[(2)] = null);

(statearr_16708_16722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (2))){
var _ = (function (){var statearr_16709 = state_16706;
(statearr_16709[(4)] = cljs.core.cons((5),(state_16706[(4)])));

return statearr_16709;
})();
var inst_16693 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_16694 = [history,next_his_key];
var inst_16695 = cljs.core.PersistentHashMap.fromArrays(inst_16693,inst_16694);
var inst_16696 = fluree.db.storage.core.serde(conn);
var inst_16697 = fluree.db.serde.protocol._serialize_leaf(inst_16696,inst_16695);
var inst_16698 = fluree.db.storage.core.storage_write(conn,his_key,inst_16697);
var state_16706__$1 = state_16706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16706__$1,(6),inst_16698);
} else {
if((state_val_16707 === (3))){
var inst_16704 = (state_16706[(2)]);
var state_16706__$1 = state_16706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16706__$1,inst_16704);
} else {
if((state_val_16707 === (4))){
var inst_16687 = (state_16706[(2)]);
var state_16706__$1 = state_16706;
var statearr_16711_16723 = state_16706__$1;
(statearr_16711_16723[(2)] = inst_16687);

(statearr_16711_16723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (5))){
var _ = (function (){var statearr_16712 = state_16706;
(statearr_16712[(4)] = cljs.core.rest((state_16706[(4)])));

return statearr_16712;
})();
var state_16706__$1 = state_16706;
var ex16710 = (state_16706__$1[(2)]);
var statearr_16713_16724 = state_16706__$1;
(statearr_16713_16724[(5)] = ex16710);


if((ex16710 instanceof Error)){
var statearr_16714_16725 = state_16706__$1;
(statearr_16714_16725[(1)] = (4));

(statearr_16714_16725[(5)] = null);

} else {
throw ex16710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16707 === (6))){
var inst_16700 = (state_16706[(2)]);
var inst_16701 = fluree.db.util.async.throw_err(inst_16700);
var _ = (function (){var statearr_16715 = state_16706;
(statearr_16715[(4)] = cljs.core.rest((state_16706[(4)])));

return statearr_16715;
})();
var state_16706__$1 = state_16706;
var statearr_16716_16726 = state_16706__$1;
(statearr_16716_16726[(2)] = inst_16701);

(statearr_16716_16726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2414__auto____0 = (function (){
var statearr_16717 = [null,null,null,null,null,null,null];
(statearr_16717[(0)] = fluree$db$storage$core$write_history_$_state_machine__2414__auto__);

(statearr_16717[(1)] = (1));

return statearr_16717;
});
var fluree$db$storage$core$write_history_$_state_machine__2414__auto____1 = (function (state_16706){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16706);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16718){var ex__2417__auto__ = e16718;
var statearr_16719_16727 = state_16706;
(statearr_16719_16727[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16706[(4)]))){
var statearr_16720_16728 = state_16706;
(statearr_16720_16728[(1)] = cljs.core.first((state_16706[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16729 = state_16706;
state_16706 = G__16729;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2414__auto__ = function(state_16706){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2414__auto____1.call(this,state_16706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16721 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16721[(6)] = c__2436__auto__);

return statearr_16721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16755){
var state_val_16756 = (state_16755[(1)]);
if((state_val_16756 === (1))){
var state_16755__$1 = state_16755;
var statearr_16757_16774 = state_16755__$1;
(statearr_16757_16774[(2)] = null);

(statearr_16757_16774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16756 === (2))){
var inst_16736 = (state_16755[(7)]);
var _ = (function (){var statearr_16758 = state_16755;
(statearr_16758[(4)] = cljs.core.cons((5),(state_16755[(4)])));

return statearr_16758;
})();
var inst_16736__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_16737 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16736__$1),"-his"].join('');
var inst_16738 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_16739 = [flakes,inst_16737];
var inst_16740 = cljs.core.PersistentHashMap.fromArrays(inst_16738,inst_16739);
var inst_16741 = fluree.db.storage.core.serde(conn);
var inst_16742 = fluree.db.serde.protocol._serialize_leaf(inst_16741,inst_16740);
var inst_16743 = fluree.db.storage.core.write_history(conn,history,inst_16737,null);
var inst_16744 = fluree.db.storage.core.storage_write(conn,inst_16736__$1,inst_16742);
var state_16755__$1 = (function (){var statearr_16759 = state_16755;
(statearr_16759[(8)] = inst_16744);

(statearr_16759[(7)] = inst_16736__$1);

return statearr_16759;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16755__$1,(6),inst_16743);
} else {
if((state_val_16756 === (3))){
var inst_16753 = (state_16755[(2)]);
var state_16755__$1 = state_16755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16755__$1,inst_16753);
} else {
if((state_val_16756 === (4))){
var inst_16730 = (state_16755[(2)]);
var state_16755__$1 = state_16755;
var statearr_16761_16775 = state_16755__$1;
(statearr_16761_16775[(2)] = inst_16730);

(statearr_16761_16775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16756 === (5))){
var _ = (function (){var statearr_16762 = state_16755;
(statearr_16762[(4)] = cljs.core.rest((state_16755[(4)])));

return statearr_16762;
})();
var state_16755__$1 = state_16755;
var ex16760 = (state_16755__$1[(2)]);
var statearr_16763_16776 = state_16755__$1;
(statearr_16763_16776[(5)] = ex16760);


if((ex16760 instanceof Error)){
var statearr_16764_16777 = state_16755__$1;
(statearr_16764_16777[(1)] = (4));

(statearr_16764_16777[(5)] = null);

} else {
throw ex16760;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16756 === (6))){
var inst_16744 = (state_16755[(8)]);
var inst_16746 = (state_16755[(2)]);
var inst_16747 = fluree.db.util.async.throw_err(inst_16746);
var state_16755__$1 = (function (){var statearr_16765 = state_16755;
(statearr_16765[(9)] = inst_16747);

return statearr_16765;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16755__$1,(7),inst_16744);
} else {
if((state_val_16756 === (7))){
var inst_16736 = (state_16755[(7)]);
var inst_16749 = (state_16755[(2)]);
var inst_16750 = fluree.db.util.async.throw_err(inst_16749);
var _ = (function (){var statearr_16766 = state_16755;
(statearr_16766[(4)] = cljs.core.rest((state_16755[(4)])));

return statearr_16766;
})();
var state_16755__$1 = (function (){var statearr_16767 = state_16755;
(statearr_16767[(10)] = inst_16750);

return statearr_16767;
})();
var statearr_16768_16778 = state_16755__$1;
(statearr_16768_16778[(2)] = inst_16736);

(statearr_16768_16778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_16769 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16769[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__);

(statearr_16769[(1)] = (1));

return statearr_16769;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1 = (function (state_16755){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16755);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16770){var ex__2417__auto__ = e16770;
var statearr_16771_16779 = state_16755;
(statearr_16771_16779[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16755[(4)]))){
var statearr_16772_16780 = state_16755;
(statearr_16772_16780[(1)] = cljs.core.first((state_16755[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16781 = state_16755;
state_16755 = G__16781;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__ = function(state_16755){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1.call(this,state_16755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16773 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16773[(6)] = c__2436__auto__);

return statearr_16773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16798){
var state_val_16799 = (state_16798[(1)]);
if((state_val_16799 === (1))){
var state_16798__$1 = state_16798;
var statearr_16800_16815 = state_16798__$1;
(statearr_16800_16815[(2)] = null);

(statearr_16800_16815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16799 === (2))){
var _ = (function (){var statearr_16801 = state_16798;
(statearr_16801[(4)] = cljs.core.cons((5),(state_16798[(4)])));

return statearr_16801;
})();
var inst_16788 = fluree.db.storage.core.serde(conn);
var inst_16789 = fluree.db.serde.protocol._serialize_branch(inst_16788,data);
var inst_16790 = fluree.db.storage.core.storage_write(conn,key,inst_16789);
var state_16798__$1 = state_16798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16798__$1,(6),inst_16790);
} else {
if((state_val_16799 === (3))){
var inst_16796 = (state_16798[(2)]);
var state_16798__$1 = state_16798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16798__$1,inst_16796);
} else {
if((state_val_16799 === (4))){
var inst_16782 = (state_16798[(2)]);
var state_16798__$1 = state_16798;
var statearr_16803_16816 = state_16798__$1;
(statearr_16803_16816[(2)] = inst_16782);

(statearr_16803_16816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16799 === (5))){
var _ = (function (){var statearr_16804 = state_16798;
(statearr_16804[(4)] = cljs.core.rest((state_16798[(4)])));

return statearr_16804;
})();
var state_16798__$1 = state_16798;
var ex16802 = (state_16798__$1[(2)]);
var statearr_16805_16817 = state_16798__$1;
(statearr_16805_16817[(5)] = ex16802);


if((ex16802 instanceof Error)){
var statearr_16806_16818 = state_16798__$1;
(statearr_16806_16818[(1)] = (4));

(statearr_16806_16818[(5)] = null);

} else {
throw ex16802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16799 === (6))){
var inst_16792 = (state_16798[(2)]);
var inst_16793 = fluree.db.util.async.throw_err(inst_16792);
var _ = (function (){var statearr_16807 = state_16798;
(statearr_16807[(4)] = cljs.core.rest((state_16798[(4)])));

return statearr_16807;
})();
var state_16798__$1 = (function (){var statearr_16808 = state_16798;
(statearr_16808[(7)] = inst_16793);

return statearr_16808;
})();
var statearr_16809_16819 = state_16798__$1;
(statearr_16809_16819[(2)] = key);

(statearr_16809_16819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0 = (function (){
var statearr_16810 = [null,null,null,null,null,null,null,null];
(statearr_16810[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__);

(statearr_16810[(1)] = (1));

return statearr_16810;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1 = (function (state_16798){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16798);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16811){var ex__2417__auto__ = e16811;
var statearr_16812_16820 = state_16798;
(statearr_16812_16820[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16798[(4)]))){
var statearr_16813_16821 = state_16798;
(statearr_16813_16821[(1)] = cljs.core.first((state_16798[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16822 = state_16798;
state_16798 = G__16822;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__ = function(state_16798){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1.call(this,state_16798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16814 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16814[(6)] = c__2436__auto__);

return statearr_16814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__16823_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__16823_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__16824){
var map__16825 = p__16824;
var map__16825__$1 = (((((!((map__16825 == null))))?(((((map__16825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16825.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16825):map__16825);
var progress = map__16825__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16825__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16874){
var state_val_16875 = (state_16874[(1)]);
if((state_val_16875 === (7))){
var state_16874__$1 = state_16874;
var statearr_16876_16905 = state_16874__$1;
(statearr_16876_16905[(2)] = false);

(statearr_16876_16905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (1))){
var state_16874__$1 = state_16874;
var statearr_16877_16906 = state_16874__$1;
(statearr_16877_16906[(2)] = null);

(statearr_16877_16906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (4))){
var inst_16827 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
var statearr_16878_16907 = state_16874__$1;
(statearr_16878_16907[(2)] = inst_16827);

(statearr_16878_16907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (15))){
var inst_16860 = (state_16874[(7)]);
var inst_16868 = (state_16874[(2)]);
var inst_16869 = fluree.db.util.async.throw_err(inst_16868);
var _ = (function (){var statearr_16879 = state_16874;
(statearr_16879[(4)] = cljs.core.rest((state_16874[(4)])));

return statearr_16879;
})();
var state_16874__$1 = (function (){var statearr_16880 = state_16874;
(statearr_16880[(8)] = inst_16869);

return statearr_16880;
})();
var statearr_16881_16908 = state_16874__$1;
(statearr_16881_16908[(2)] = inst_16860);

(statearr_16881_16908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (13))){
var inst_16834 = (state_16874[(9)]);
var state_16874__$1 = state_16874;
var statearr_16882_16909 = state_16874__$1;
(statearr_16882_16909[(2)] = inst_16834);

(statearr_16882_16909[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (6))){
var inst_16834 = (state_16874[(9)]);
var inst_16839 = inst_16834.cljs$lang$protocol_mask$partition0$;
var inst_16840 = (inst_16839 & (64));
var inst_16841 = inst_16834.cljs$core$ISeq$;
var inst_16842 = (cljs.core.PROTOCOL_SENTINEL === inst_16841);
var inst_16843 = ((inst_16840) || (inst_16842));
var state_16874__$1 = state_16874;
if(cljs.core.truth_(inst_16843)){
var statearr_16883_16910 = state_16874__$1;
(statearr_16883_16910[(1)] = (9));

} else {
var statearr_16884_16911 = state_16874__$1;
(statearr_16884_16911[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (3))){
var inst_16872 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16874__$1,inst_16872);
} else {
if((state_val_16875 === (12))){
var inst_16834 = (state_16874[(9)]);
var inst_16852 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16834);
var state_16874__$1 = state_16874;
var statearr_16885_16912 = state_16874__$1;
(statearr_16885_16912[(2)] = inst_16852);

(statearr_16885_16912[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (2))){
var inst_16834 = (state_16874[(9)]);
var _ = (function (){var statearr_16886 = state_16874;
(statearr_16886[(4)] = cljs.core.cons((5),(state_16874[(4)])));

return statearr_16886;
})();
var inst_16834__$1 = db;
var inst_16836 = (inst_16834__$1 == null);
var inst_16837 = cljs.core.not(inst_16836);
var state_16874__$1 = (function (){var statearr_16887 = state_16874;
(statearr_16887[(9)] = inst_16834__$1);

return statearr_16887;
})();
if(inst_16837){
var statearr_16888_16913 = state_16874__$1;
(statearr_16888_16913[(1)] = (6));

} else {
var statearr_16889_16914 = state_16874__$1;
(statearr_16889_16914[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (11))){
var inst_16847 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
var statearr_16891_16915 = state_16874__$1;
(statearr_16891_16915[(2)] = inst_16847);

(statearr_16891_16915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (9))){
var state_16874__$1 = state_16874;
var statearr_16892_16916 = state_16874__$1;
(statearr_16892_16916[(2)] = true);

(statearr_16892_16916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (5))){
var _ = (function (){var statearr_16893 = state_16874;
(statearr_16893[(4)] = cljs.core.rest((state_16874[(4)])));

return statearr_16893;
})();
var state_16874__$1 = state_16874;
var ex16890 = (state_16874__$1[(2)]);
var statearr_16894_16917 = state_16874__$1;
(statearr_16894_16917[(5)] = ex16890);


if((ex16890 instanceof Error)){
var statearr_16895_16918 = state_16874__$1;
(statearr_16895_16918[(1)] = (4));

(statearr_16895_16918[(5)] = null);

} else {
throw ex16890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (14))){
var inst_16860 = (state_16874[(7)]);
var inst_16855 = (state_16874[(2)]);
var inst_16856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16855,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16855,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16855,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_16859 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16855,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16860__$1 = fluree.db.storage.core.ledger_garbage_key(inst_16857,inst_16858,inst_16859);
var inst_16861 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_16862 = [inst_16858,inst_16859,garbage];
var inst_16863 = cljs.core.PersistentHashMap.fromArrays(inst_16861,inst_16862);
var inst_16864 = fluree.db.storage.core.serde(inst_16856);
var inst_16865 = fluree.db.serde.protocol._serialize_garbage(inst_16864,inst_16863);
var inst_16866 = fluree.db.storage.core.storage_write(inst_16856,inst_16860__$1,inst_16865);
var state_16874__$1 = (function (){var statearr_16896 = state_16874;
(statearr_16896[(7)] = inst_16860__$1);

return statearr_16896;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16874__$1,(15),inst_16866);
} else {
if((state_val_16875 === (10))){
var state_16874__$1 = state_16874;
var statearr_16897_16919 = state_16874__$1;
(statearr_16897_16919[(2)] = false);

(statearr_16897_16919[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16875 === (8))){
var inst_16850 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
if(cljs.core.truth_(inst_16850)){
var statearr_16898_16920 = state_16874__$1;
(statearr_16898_16920[(1)] = (12));

} else {
var statearr_16899_16921 = state_16874__$1;
(statearr_16899_16921[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0 = (function (){
var statearr_16900 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16900[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__);

(statearr_16900[(1)] = (1));

return statearr_16900;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1 = (function (state_16874){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16874);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16901){var ex__2417__auto__ = e16901;
var statearr_16902_16922 = state_16874;
(statearr_16902_16922[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16874[(4)]))){
var statearr_16903_16923 = state_16874;
(statearr_16903_16923[(1)] = cljs.core.first((state_16874[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16924 = state_16874;
state_16874 = G__16924;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__ = function(state_16874){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1.call(this,state_16874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2414__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16904 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16904[(6)] = c__2436__auto__);

return statearr_16904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__16926 = arguments.length;
switch (G__16926) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17002){
var state_val_17003 = (state_17002[(1)]);
if((state_val_17003 === (7))){
var state_17002__$1 = state_17002;
var statearr_17004_17043 = state_17002__$1;
(statearr_17004_17043[(2)] = false);

(statearr_17004_17043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (20))){
var inst_16961 = (state_17002[(7)]);
var inst_16976 = (state_17002[(8)]);
var inst_16969 = (state_17002[(9)]);
var inst_16967 = (state_17002[(10)]);
var inst_16966 = (state_17002[(11)]);
var inst_16962 = (state_17002[(12)]);
var inst_16964 = (state_17002[(13)]);
var inst_16970 = (state_17002[(14)]);
var inst_16960 = (state_17002[(15)]);
var inst_16971 = (state_17002[(16)]);
var inst_16959 = (state_17002[(17)]);
var inst_16958 = (state_17002[(18)]);
var inst_16968 = (state_17002[(19)]);
var inst_16957 = (state_17002[(20)]);
var inst_16981 = (state_17002[(2)]);
var inst_16982 = fluree.db.storage.core.child_data(inst_16966);
var inst_16983 = fluree.db.storage.core.child_data(inst_16968);
var inst_16984 = fluree.db.util.core.current_time_millis();
var inst_16985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16986 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_16987 = (new cljs.core.PersistentVector(null,2,(5),inst_16985,inst_16986,null));
var inst_16988 = cljs.core.select_keys(inst_16960,inst_16987);
var inst_16989 = fluree.db.storage.core.child_data(inst_16959);
var inst_16990 = [inst_16962,inst_16971,inst_16964,inst_16976,inst_16981,inst_16982,inst_16983,inst_16957,inst_16984,inst_16958,inst_16967,inst_16988,inst_16989];
var inst_16991 = cljs.core.PersistentHashMap.fromArrays(inst_16970,inst_16990);
var inst_16992 = fluree.db.storage.core.serde(inst_16961);
var inst_16993 = fluree.db.serde.protocol._serialize_db_root(inst_16992,inst_16991);
var inst_16994 = fluree.db.storage.core.storage_write(inst_16961,inst_16969,inst_16993);
var state_17002__$1 = state_17002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17002__$1,(21),inst_16994);
} else {
if((state_val_17003 === (1))){
var state_17002__$1 = state_17002;
var statearr_17005_17044 = state_17002__$1;
(statearr_17005_17044[(2)] = null);

(statearr_17005_17044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (4))){
var inst_16927 = (state_17002[(2)]);
var state_17002__$1 = state_17002;
var statearr_17006_17045 = state_17002__$1;
(statearr_17006_17045[(2)] = inst_16927);

(statearr_17006_17045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (15))){
var inst_16972 = (state_17002[(21)]);
var state_17002__$1 = state_17002;
var statearr_17007_17046 = state_17002__$1;
(statearr_17007_17046[(2)] = inst_16972);

(statearr_17007_17046[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (21))){
var inst_16969 = (state_17002[(9)]);
var inst_16996 = (state_17002[(2)]);
var inst_16997 = fluree.db.util.async.throw_err(inst_16996);
var _ = (function (){var statearr_17008 = state_17002;
(statearr_17008[(4)] = cljs.core.rest((state_17002[(4)])));

return statearr_17008;
})();
var state_17002__$1 = (function (){var statearr_17009 = state_17002;
(statearr_17009[(22)] = inst_16997);

return statearr_17009;
})();
var statearr_17010_17047 = state_17002__$1;
(statearr_17010_17047[(2)] = inst_16969);

(statearr_17010_17047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (13))){
var inst_16934 = (state_17002[(23)]);
var state_17002__$1 = state_17002;
var statearr_17011_17048 = state_17002__$1;
(statearr_17011_17048[(2)] = inst_16934);

(statearr_17011_17048[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (6))){
var inst_16934 = (state_17002[(23)]);
var inst_16939 = inst_16934.cljs$lang$protocol_mask$partition0$;
var inst_16940 = (inst_16939 & (64));
var inst_16941 = inst_16934.cljs$core$ISeq$;
var inst_16942 = (cljs.core.PROTOCOL_SENTINEL === inst_16941);
var inst_16943 = ((inst_16940) || (inst_16942));
var state_17002__$1 = state_17002;
if(cljs.core.truth_(inst_16943)){
var statearr_17012_17049 = state_17002__$1;
(statearr_17012_17049[(1)] = (9));

} else {
var statearr_17013_17050 = state_17002__$1;
(statearr_17013_17050[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (17))){
var inst_16977 = (state_17002[(24)]);
var inst_16976 = (state_17002[(2)]);
var inst_16977__$1 = custom_ecount;
var state_17002__$1 = (function (){var statearr_17014 = state_17002;
(statearr_17014[(8)] = inst_16976);

(statearr_17014[(24)] = inst_16977__$1);

return statearr_17014;
})();
if(cljs.core.truth_(inst_16977__$1)){
var statearr_17015_17051 = state_17002__$1;
(statearr_17015_17051[(1)] = (18));

} else {
var statearr_17016_17052 = state_17002__$1;
(statearr_17016_17052[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (3))){
var inst_17000 = (state_17002[(2)]);
var state_17002__$1 = state_17002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17002__$1,inst_17000);
} else {
if((state_val_17003 === (12))){
var inst_16934 = (state_17002[(23)]);
var inst_16952 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16934);
var state_17002__$1 = state_17002;
var statearr_17017_17053 = state_17002__$1;
(statearr_17017_17053[(2)] = inst_16952);

(statearr_17017_17053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (2))){
var inst_16934 = (state_17002[(23)]);
var _ = (function (){var statearr_17018 = state_17002;
(statearr_17018[(4)] = cljs.core.cons((5),(state_17002[(4)])));

return statearr_17018;
})();
var inst_16934__$1 = db;
var inst_16936 = (inst_16934__$1 == null);
var inst_16937 = cljs.core.not(inst_16936);
var state_17002__$1 = (function (){var statearr_17019 = state_17002;
(statearr_17019[(23)] = inst_16934__$1);

return statearr_17019;
})();
if(inst_16937){
var statearr_17020_17054 = state_17002__$1;
(statearr_17020_17054[(1)] = (6));

} else {
var statearr_17021_17055 = state_17002__$1;
(statearr_17021_17055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (19))){
var inst_16965 = (state_17002[(25)]);
var state_17002__$1 = state_17002;
var statearr_17022_17056 = state_17002__$1;
(statearr_17022_17056[(2)] = inst_16965);

(statearr_17022_17056[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (11))){
var inst_16947 = (state_17002[(2)]);
var state_17002__$1 = state_17002;
var statearr_17024_17057 = state_17002__$1;
(statearr_17024_17057[(2)] = inst_16947);

(statearr_17024_17057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (9))){
var state_17002__$1 = state_17002;
var statearr_17025_17058 = state_17002__$1;
(statearr_17025_17058[(2)] = true);

(statearr_17025_17058[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (5))){
var _ = (function (){var statearr_17026 = state_17002;
(statearr_17026[(4)] = cljs.core.rest((state_17002[(4)])));

return statearr_17026;
})();
var state_17002__$1 = state_17002;
var ex17023 = (state_17002__$1[(2)]);
var statearr_17027_17059 = state_17002__$1;
(statearr_17027_17059[(5)] = ex17023);


if((ex17023 instanceof Error)){
var statearr_17028_17060 = state_17002__$1;
(statearr_17028_17060[(1)] = (4));

(statearr_17028_17060[(5)] = null);

} else {
throw ex17023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (14))){
var inst_16962 = (state_17002[(12)]);
var inst_16964 = (state_17002[(13)]);
var inst_16960 = (state_17002[(15)]);
var inst_16972 = (state_17002[(21)]);
var inst_16955 = (state_17002[(2)]);
var inst_16956 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_16958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_16959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_16960__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_16961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16962__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_16964__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_16965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_16966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_16967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_16968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16955,new cljs.core.Keyword(null,"post","post",269697687));
var inst_16969 = fluree.db.storage.core.ledger_root_key(inst_16956,inst_16964__$1,inst_16962__$1);
var inst_16970 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_16971 = fluree.db.storage.core.child_data(inst_16963);
var inst_16972__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_16960__$1);
var state_17002__$1 = (function (){var statearr_17029 = state_17002;
(statearr_17029[(7)] = inst_16961);

(statearr_17029[(25)] = inst_16965);

(statearr_17029[(9)] = inst_16969);

(statearr_17029[(10)] = inst_16967);

(statearr_17029[(11)] = inst_16966);

(statearr_17029[(12)] = inst_16962__$1);

(statearr_17029[(13)] = inst_16964__$1);

(statearr_17029[(14)] = inst_16970);

(statearr_17029[(15)] = inst_16960__$1);

(statearr_17029[(16)] = inst_16971);

(statearr_17029[(17)] = inst_16959);

(statearr_17029[(18)] = inst_16958);

(statearr_17029[(21)] = inst_16972__$1);

(statearr_17029[(19)] = inst_16968);

(statearr_17029[(20)] = inst_16957);

return statearr_17029;
})();
if(cljs.core.truth_(inst_16972__$1)){
var statearr_17030_17061 = state_17002__$1;
(statearr_17030_17061[(1)] = (15));

} else {
var statearr_17031_17062 = state_17002__$1;
(statearr_17031_17062[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (16))){
var state_17002__$1 = state_17002;
var statearr_17032_17063 = state_17002__$1;
(statearr_17032_17063[(2)] = (0));

(statearr_17032_17063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (10))){
var state_17002__$1 = state_17002;
var statearr_17033_17064 = state_17002__$1;
(statearr_17033_17064[(2)] = false);

(statearr_17033_17064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (18))){
var inst_16977 = (state_17002[(24)]);
var state_17002__$1 = state_17002;
var statearr_17034_17065 = state_17002__$1;
(statearr_17034_17065[(2)] = inst_16977);

(statearr_17034_17065[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17003 === (8))){
var inst_16950 = (state_17002[(2)]);
var state_17002__$1 = state_17002;
if(cljs.core.truth_(inst_16950)){
var statearr_17035_17066 = state_17002__$1;
(statearr_17035_17066[(1)] = (12));

} else {
var statearr_17036_17067 = state_17002__$1;
(statearr_17036_17067[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2414__auto__ = null;
var fluree$db$storage$core$state_machine__2414__auto____0 = (function (){
var statearr_17037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17037[(0)] = fluree$db$storage$core$state_machine__2414__auto__);

(statearr_17037[(1)] = (1));

return statearr_17037;
});
var fluree$db$storage$core$state_machine__2414__auto____1 = (function (state_17002){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17002);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17038){var ex__2417__auto__ = e17038;
var statearr_17039_17068 = state_17002;
(statearr_17039_17068[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17002[(4)]))){
var statearr_17040_17069 = state_17002;
(statearr_17040_17069[(1)] = cljs.core.first((state_17002[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17070 = state_17002;
state_17002 = G__17070;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2414__auto__ = function(state_17002){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2414__auto____1.call(this,state_17002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2414__auto____0;
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2414__auto____1;
return fluree$db$storage$core$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17041 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17041[(6)] = c__2436__auto__);

return statearr_17041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___17122 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17100){
var state_val_17101 = (state_17100[(1)]);
if((state_val_17101 === (7))){
var inst_17087 = cljs.core.async.close_BANG_(return_ch);
var state_17100__$1 = state_17100;
var statearr_17102_17123 = state_17100__$1;
(statearr_17102_17123[(2)] = inst_17087);

(statearr_17102_17123[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (1))){
var state_17100__$1 = state_17100;
var statearr_17103_17124 = state_17100__$1;
(statearr_17103_17124[(2)] = null);

(statearr_17103_17124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (4))){
var inst_17071 = (state_17100[(2)]);
var inst_17072 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17073 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17071);
var inst_17074 = cljs.core.async.close_BANG_(return_ch);
var state_17100__$1 = (function (){var statearr_17104 = state_17100;
(statearr_17104[(7)] = inst_17073);

(statearr_17104[(8)] = inst_17072);

return statearr_17104;
})();
var statearr_17105_17125 = state_17100__$1;
(statearr_17105_17125[(2)] = inst_17074);

(statearr_17105_17125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (6))){
var inst_17082 = (state_17100[(9)]);
var inst_17082__$1 = (state_17100[(2)]);
var inst_17083 = (inst_17082__$1 == null);
var inst_17084 = (inst_17082__$1 instanceof Error);
var inst_17085 = ((inst_17083) || (inst_17084));
var state_17100__$1 = (function (){var statearr_17106 = state_17100;
(statearr_17106[(9)] = inst_17082__$1);

return statearr_17106;
})();
if(cljs.core.truth_(inst_17085)){
var statearr_17107_17126 = state_17100__$1;
(statearr_17107_17126[(1)] = (7));

} else {
var statearr_17108_17127 = state_17100__$1;
(statearr_17108_17127[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (3))){
var inst_17098 = (state_17100[(2)]);
var state_17100__$1 = state_17100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17100__$1,inst_17098);
} else {
if((state_val_17101 === (2))){
var _ = (function (){var statearr_17110 = state_17100;
(statearr_17110[(4)] = cljs.core.cons((5),(state_17100[(4)])));

return statearr_17110;
})();
var inst_17080 = fluree.db.storage.core.storage_read(conn,key);
var state_17100__$1 = state_17100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17100__$1,(6),inst_17080);
} else {
if((state_val_17101 === (9))){
var inst_17095 = (state_17100[(2)]);
var _ = (function (){var statearr_17111 = state_17100;
(statearr_17111[(4)] = cljs.core.rest((state_17100[(4)])));

return statearr_17111;
})();
var state_17100__$1 = state_17100;
var statearr_17112_17128 = state_17100__$1;
(statearr_17112_17128[(2)] = inst_17095);

(statearr_17112_17128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (5))){
var _ = (function (){var statearr_17113 = state_17100;
(statearr_17113[(4)] = cljs.core.rest((state_17100[(4)])));

return statearr_17113;
})();
var state_17100__$1 = state_17100;
var ex17109 = (state_17100__$1[(2)]);
var statearr_17114_17129 = state_17100__$1;
(statearr_17114_17129[(5)] = ex17109);


var statearr_17115_17130 = state_17100__$1;
(statearr_17115_17130[(1)] = (4));

(statearr_17115_17130[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17101 === (8))){
var inst_17082 = (state_17100[(9)]);
var inst_17089 = fluree.db.storage.core.serde(conn);
var inst_17090 = fluree.db.serde.protocol._deserialize_leaf(inst_17089,inst_17082);
var inst_17091 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17090);
var inst_17092 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_17091);
var inst_17093 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17092);
var state_17100__$1 = state_17100;
var statearr_17116_17131 = state_17100__$1;
(statearr_17116_17131[(2)] = inst_17093);

(statearr_17116_17131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0 = (function (){
var statearr_17117 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17117[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2414__auto__);

(statearr_17117[(1)] = (1));

return statearr_17117;
});
var fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1 = (function (state_17100){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17100);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17118){var ex__2417__auto__ = e17118;
var statearr_17119_17132 = state_17100;
(statearr_17119_17132[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17100[(4)]))){
var statearr_17120_17133 = state_17100;
(statearr_17120_17133[(1)] = cljs.core.first((state_17100[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17134 = state_17100;
state_17100 = G__17134;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__ = function(state_17100){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1.call(this,state_17100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17121 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17121[(6)] = c__2436__auto___17122);

return statearr_17121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17136 = arguments.length;
switch (G__17136) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___17248 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17199){
var state_val_17200 = (state_17199[(1)]);
if((state_val_17200 === (7))){
var state_17199__$1 = state_17199;
var statearr_17201_17249 = state_17199__$1;
(statearr_17201_17249[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17201_17249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (20))){
var inst_17178 = cljs.core.PersistentVector.EMPTY;
var state_17199__$1 = state_17199;
var statearr_17202_17250 = state_17199__$1;
(statearr_17202_17250[(2)] = inst_17178);

(statearr_17202_17250[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (1))){
var state_17199__$1 = state_17199;
var statearr_17203_17251 = state_17199__$1;
(statearr_17203_17251[(2)] = null);

(statearr_17203_17251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (24))){
var state_17199__$1 = state_17199;
var statearr_17204_17252 = state_17199__$1;
(statearr_17204_17252[(2)] = null);

(statearr_17204_17252[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (4))){
var inst_17139 = (state_17199[(2)]);
var inst_17140 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17141 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17139);
var inst_17142 = cljs.core.async.close_BANG_(result_ch);
var state_17199__$1 = (function (){var statearr_17205 = state_17199;
(statearr_17205[(7)] = inst_17140);

(statearr_17205[(8)] = inst_17141);

return statearr_17205;
})();
var statearr_17206_17253 = state_17199__$1;
(statearr_17206_17253[(2)] = inst_17142);

(statearr_17206_17253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (15))){
var inst_17164 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17207_17254 = state_17199__$1;
(statearr_17207_17254[(2)] = inst_17164);

(statearr_17207_17254[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (21))){
var inst_17153 = (state_17199[(9)]);
var inst_17151 = (state_17199[(10)]);
var inst_17181 = (state_17199[(11)]);
var inst_17168 = (state_17199[(12)]);
var inst_17152 = (state_17199[(13)]);
var inst_17188 = (state_17199[(2)]);
var inst_17189 = (function (){var base_node = inst_17151;
var first_flake = inst_17152;
var node_t = inst_17153;
var source = inst_17168;
var coll = inst_17181;
var conj_QMARK_ = inst_17188;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__17209 = f.p;
var fexpr__17208 = (function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__17208.cljs$core$IFn$_invoke$arity$1 ? fexpr__17208.cljs$core$IFn$_invoke$arity$1(G__17209) : fexpr__17208.call(null,G__17209));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_17190 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17151);
var inst_17191 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17189,inst_17190,inst_17181);
var inst_17192 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_17191);
var inst_17193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17151,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17192);
var inst_17194 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17193);
var _ = (function (){var statearr_17210 = state_17199;
(statearr_17210[(4)] = cljs.core.rest((state_17199[(4)])));

return statearr_17210;
})();
var state_17199__$1 = state_17199;
var statearr_17211_17255 = state_17199__$1;
(statearr_17211_17255[(2)] = inst_17194);

(statearr_17211_17255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (13))){
var state_17199__$1 = state_17199;
var statearr_17212_17256 = state_17199__$1;
(statearr_17212_17256[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17212_17256[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (22))){
var inst_17153 = (state_17199[(9)]);
var inst_17151 = (state_17199[(10)]);
var inst_17181 = (state_17199[(11)]);
var inst_17168 = (state_17199[(12)]);
var inst_17152 = (state_17199[(13)]);
var inst_17182 = (function (){var base_node = inst_17151;
var first_flake = inst_17152;
var node_t = inst_17153;
var source = inst_17168;
var coll = inst_17181;
return (function (f){
return f.op === true;
});
})();
var state_17199__$1 = state_17199;
var statearr_17213_17257 = state_17199__$1;
(statearr_17213_17257[(2)] = inst_17182);

(statearr_17213_17257[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (6))){
var inst_17153 = (state_17199[(9)]);
var inst_17151 = (state_17199[(10)]);
var inst_17150 = (state_17199[(2)]);
var inst_17151__$1 = fluree.db.util.async.throw_err(inst_17150);
var inst_17152 = fluree.db.dbproto._first_flake(inst_17151__$1);
var inst_17153__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17151__$1);
var inst_17154 = (inst_17153__$1 > t);
var state_17199__$1 = (function (){var statearr_17214 = state_17199;
(statearr_17214[(9)] = inst_17153__$1);

(statearr_17214[(10)] = inst_17151__$1);

(statearr_17214[(13)] = inst_17152);

return statearr_17214;
})();
if(cljs.core.truth_(inst_17154)){
var statearr_17215_17258 = state_17199__$1;
(statearr_17215_17258[(1)] = (7));

} else {
var statearr_17216_17259 = state_17199__$1;
(statearr_17216_17259[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (17))){
var inst_17152 = (state_17199[(13)]);
var inst_17169 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17152,rhs,leftmost_QMARK_,t);
var state_17199__$1 = state_17199;
var statearr_17217_17260 = state_17199__$1;
(statearr_17217_17260[(2)] = inst_17169);

(statearr_17217_17260[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (3))){
var inst_17197 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17199__$1,inst_17197);
} else {
if((state_val_17200 === (12))){
var inst_17166 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17218_17261 = state_17199__$1;
(statearr_17218_17261[(2)] = inst_17166);

(statearr_17218_17261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (2))){
var _ = (function (){var statearr_17219 = state_17199;
(statearr_17219[(4)] = cljs.core.cons((5),(state_17199[(4)])));

return statearr_17219;
})();
var inst_17148 = fluree.db.dbproto._resolve(node);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17199__$1,(6),inst_17148);
} else {
if((state_val_17200 === (23))){
var inst_17153 = (state_17199[(9)]);
var inst_17151 = (state_17199[(10)]);
var inst_17181 = (state_17199[(11)]);
var inst_17168 = (state_17199[(12)]);
var inst_17152 = (state_17199[(13)]);
var inst_17184 = (function (){var base_node = inst_17151;
var first_flake = inst_17152;
var node_t = inst_17153;
var source = inst_17168;
var coll = inst_17181;
return (function (f){
return f.op === false;
});
})();
var state_17199__$1 = state_17199;
var statearr_17220_17262 = state_17199__$1;
(statearr_17220_17262[(2)] = inst_17184);

(statearr_17220_17262[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (19))){
var inst_17171 = (state_17199[(14)]);
var inst_17174 = (state_17199[(2)]);
var inst_17175 = fluree.db.util.async.throw_err(inst_17174);
var inst_17176 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17171,inst_17175);
var state_17199__$1 = state_17199;
var statearr_17221_17263 = state_17199__$1;
(statearr_17221_17263[(2)] = inst_17176);

(statearr_17221_17263[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (11))){
var inst_17153 = (state_17199[(9)]);
var inst_17160 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17153,t);
var state_17199__$1 = state_17199;
if(inst_17160){
var statearr_17223_17264 = state_17199__$1;
(statearr_17223_17264[(1)] = (13));

} else {
var statearr_17224_17265 = state_17199__$1;
(statearr_17224_17265[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (9))){
var inst_17168 = (state_17199[(12)]);
var inst_17168__$1 = (state_17199[(2)]);
var state_17199__$1 = (function (){var statearr_17225 = state_17199;
(statearr_17225[(12)] = inst_17168__$1);

return statearr_17225;
})();
var G__17226_17266 = inst_17168__$1;
var G__17226_17267__$1 = (((G__17226_17266 instanceof cljs.core.Keyword))?G__17226_17266.fqn:null);
switch (G__17226_17267__$1) {
case "novelty":
var statearr_17227_17269 = state_17199__$1;
(statearr_17227_17269[(1)] = (17));


break;
case "history":
var statearr_17228_17270 = state_17199__$1;
(statearr_17228_17270[(1)] = (18));


break;
case "none":
var statearr_17229_17271 = state_17199__$1;
(statearr_17229_17271[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17226_17267__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (5))){
var _ = (function (){var statearr_17230 = state_17199;
(statearr_17230[(4)] = cljs.core.rest((state_17199[(4)])));

return statearr_17230;
})();
var state_17199__$1 = state_17199;
var ex17222 = (state_17199__$1[(2)]);
var statearr_17231_17272 = state_17199__$1;
(statearr_17231_17272[(5)] = ex17222);


var statearr_17232_17273 = state_17199__$1;
(statearr_17232_17273[(1)] = (4));

(statearr_17232_17273[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (14))){
var state_17199__$1 = state_17199;
var statearr_17233_17274 = state_17199__$1;
(statearr_17233_17274[(2)] = null);

(statearr_17233_17274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (16))){
var inst_17168 = (state_17199[(12)]);
var inst_17181 = (state_17199[(2)]);
var state_17199__$1 = (function (){var statearr_17234 = state_17199;
(statearr_17234[(11)] = inst_17181);

return statearr_17234;
})();
var G__17235_17275 = inst_17168;
var G__17235_17276__$1 = (((G__17235_17275 instanceof cljs.core.Keyword))?G__17235_17275.fqn:null);
switch (G__17235_17276__$1) {
case "novelty":
var statearr_17236_17278 = state_17199__$1;
(statearr_17236_17278[(1)] = (22));


break;
case "history":
var statearr_17237_17279 = state_17199__$1;
(statearr_17237_17279[(1)] = (23));


break;
case "none":
var statearr_17238_17280 = state_17199__$1;
(statearr_17238_17280[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17235_17276__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (10))){
var state_17199__$1 = state_17199;
var statearr_17239_17281 = state_17199__$1;
(statearr_17239_17281[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17239_17281[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17200 === (18))){
var inst_17153 = (state_17199[(9)]);
var inst_17151 = (state_17199[(10)]);
var inst_17168 = (state_17199[(12)]);
var inst_17152 = (state_17199[(13)]);
var inst_17171 = (function (){var base_node = inst_17151;
var first_flake = inst_17152;
var node_t = inst_17153;
var source = inst_17168;
return (function (p1__17138_SHARP_){
return (p1__17138_SHARP_.t <= t);
});
})();
var inst_17172 = fluree.db.dbproto._resolve_history(node);
var state_17199__$1 = (function (){var statearr_17240 = state_17199;
(statearr_17240[(14)] = inst_17171);

return statearr_17240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17199__$1,(19),inst_17172);
} else {
if((state_val_17200 === (8))){
var inst_17153 = (state_17199[(9)]);
var inst_17157 = (inst_17153 < t);
var state_17199__$1 = state_17199;
if(cljs.core.truth_(inst_17157)){
var statearr_17241_17282 = state_17199__$1;
(statearr_17241_17282[(1)] = (10));

} else {
var statearr_17242_17283 = state_17199__$1;
(statearr_17242_17283[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0 = (function (){
var statearr_17243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17243[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__);

(statearr_17243[(1)] = (1));

return statearr_17243;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1 = (function (state_17199){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17199);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17244){var ex__2417__auto__ = e17244;
var statearr_17245_17284 = state_17199;
(statearr_17245_17284[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17199[(4)]))){
var statearr_17246_17285 = state_17199;
(statearr_17246_17285[(1)] = cljs.core.first((state_17199[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17286 = state_17199;
state_17199 = G__17286;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__ = function(state_17199){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1.call(this,state_17199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2414__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17247 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17247[(6)] = c__2436__auto___17248);

return statearr_17247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17343){
var state_val_17344 = (state_17343[(1)]);
if((state_val_17344 === (7))){
var state_17343__$1 = state_17343;
var statearr_17345_17381 = state_17343__$1;
(statearr_17345_17381[(2)] = null);

(statearr_17345_17381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (1))){
var state_17343__$1 = state_17343;
var statearr_17346_17382 = state_17343__$1;
(statearr_17346_17382[(2)] = null);

(statearr_17346_17382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (4))){
var inst_17289 = (state_17343[(2)]);
var inst_17290 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_17289], 0));
var inst_17291 = (function(){throw inst_17289})();
var state_17343__$1 = (function (){var statearr_17347 = state_17343;
(statearr_17347[(7)] = inst_17290);

return statearr_17347;
})();
var statearr_17348_17383 = state_17343__$1;
(statearr_17348_17383[(2)] = inst_17291);

(statearr_17348_17383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (15))){
var inst_17319 = (state_17343[(2)]);
var state_17343__$1 = state_17343;
var statearr_17349_17384 = state_17343__$1;
(statearr_17349_17384[(2)] = inst_17319);

(statearr_17349_17384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (13))){
var inst_17297 = (state_17343[(8)]);
var inst_17313 = (state_17343[(9)]);
var inst_17315 = (function (){var node_t = inst_17297;
var G__17302 = inst_17313;
return (function (p1__17288_SHARP_){
return (p1__17288_SHARP_.t <= from_t);
});
})();
var inst_17316 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17315,inst_17313);
var state_17343__$1 = state_17343;
var statearr_17350_17385 = state_17343__$1;
(statearr_17350_17385[(2)] = inst_17316);

(statearr_17350_17385[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (6))){
var inst_17303 = fluree.db.dbproto._resolve_history(node);
var state_17343__$1 = state_17343;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17343__$1,(9),inst_17303);
} else {
if((state_val_17344 === (17))){
var inst_17328 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_17329 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17328)].join('');
var inst_17330 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17331 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_17332 = cljs.core.PersistentHashMap.fromArrays(inst_17330,inst_17331);
var inst_17333 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17329,inst_17332);
var inst_17334 = (function(){throw inst_17333})();
var state_17343__$1 = state_17343;
var statearr_17351_17386 = state_17343__$1;
(statearr_17351_17386[(2)] = inst_17334);

(statearr_17351_17386[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (3))){
var inst_17341 = (state_17343[(2)]);
var state_17343__$1 = state_17343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17343__$1,inst_17341);
} else {
if((state_val_17344 === (12))){
var inst_17313 = (state_17343[(2)]);
var state_17343__$1 = (function (){var statearr_17352 = state_17343;
(statearr_17352[(9)] = inst_17313);

return statearr_17352;
})();
if(cljs.core.truth_(from_t)){
var statearr_17353_17387 = state_17343__$1;
(statearr_17353_17387[(1)] = (13));

} else {
var statearr_17354_17388 = state_17343__$1;
(statearr_17354_17388[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (2))){
var inst_17297 = (state_17343[(8)]);
var _ = (function (){var statearr_17355 = state_17343;
(statearr_17355[(4)] = cljs.core.cons((5),(state_17343[(4)])));

return statearr_17355;
})();
var inst_17297__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17298 = (from_t == null);
var inst_17299 = (inst_17297__$1 <= from_t);
var inst_17300 = ((inst_17298) || (inst_17299));
var state_17343__$1 = (function (){var statearr_17356 = state_17343;
(statearr_17356[(8)] = inst_17297__$1);

return statearr_17356;
})();
if(cljs.core.truth_(inst_17300)){
var statearr_17357_17389 = state_17343__$1;
(statearr_17357_17389[(1)] = (6));

} else {
var statearr_17358_17390 = state_17343__$1;
(statearr_17358_17390[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (11))){
var inst_17306 = (state_17343[(10)]);
var state_17343__$1 = state_17343;
var statearr_17360_17391 = state_17343__$1;
(statearr_17360_17391[(2)] = inst_17306);

(statearr_17360_17391[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (9))){
var inst_17297 = (state_17343[(8)]);
var inst_17305 = (state_17343[(2)]);
var inst_17306 = fluree.db.util.async.throw_err(inst_17305);
var inst_17307 = (to_t > inst_17297);
var state_17343__$1 = (function (){var statearr_17361 = state_17343;
(statearr_17361[(10)] = inst_17306);

return statearr_17361;
})();
if(cljs.core.truth_(inst_17307)){
var statearr_17362_17392 = state_17343__$1;
(statearr_17362_17392[(1)] = (10));

} else {
var statearr_17363_17393 = state_17343__$1;
(statearr_17363_17393[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (5))){
var _ = (function (){var statearr_17364 = state_17343;
(statearr_17364[(4)] = cljs.core.rest((state_17343[(4)])));

return statearr_17364;
})();
var state_17343__$1 = state_17343;
var ex17359 = (state_17343__$1[(2)]);
var statearr_17365_17394 = state_17343__$1;
(statearr_17365_17394[(5)] = ex17359);


var statearr_17366_17395 = state_17343__$1;
(statearr_17366_17395[(1)] = (4));

(statearr_17366_17395[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (14))){
var inst_17313 = (state_17343[(9)]);
var state_17343__$1 = state_17343;
var statearr_17367_17396 = state_17343__$1;
(statearr_17367_17396[(2)] = inst_17313);

(statearr_17367_17396[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (16))){
var state_17343__$1 = state_17343;
var statearr_17368_17397 = state_17343__$1;
(statearr_17368_17397[(2)] = null);

(statearr_17368_17397[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (10))){
var inst_17297 = (state_17343[(8)]);
var inst_17306 = (state_17343[(10)]);
var inst_17309 = (function (){var node_t = inst_17297;
var G__17302 = inst_17306;
return (function (p1__17287_SHARP_){
return (p1__17287_SHARP_.t < to_t);
});
})();
var inst_17310 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_17309,inst_17306);
var state_17343__$1 = state_17343;
var statearr_17369_17398 = state_17343__$1;
(statearr_17369_17398[(2)] = inst_17310);

(statearr_17369_17398[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (18))){
var inst_17323 = (state_17343[(11)]);
var inst_17324 = (state_17343[(12)]);
var inst_17322 = (state_17343[(13)]);
var inst_17336 = (state_17343[(2)]);
var inst_17337 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17323,inst_17324,leftmost_QMARK_,to_t);
var inst_17338 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17337,inst_17322);
var _ = (function (){var statearr_17370 = state_17343;
(statearr_17370[(4)] = cljs.core.rest((state_17343[(4)])));

return statearr_17370;
})();
var state_17343__$1 = (function (){var statearr_17371 = state_17343;
(statearr_17371[(14)] = inst_17336);

return statearr_17371;
})();
var statearr_17372_17399 = state_17343__$1;
(statearr_17372_17399[(2)] = inst_17338);

(statearr_17372_17399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17344 === (8))){
var inst_17322 = (state_17343[(2)]);
var inst_17323 = fluree.db.dbproto._first_flake(node);
var inst_17324 = fluree.db.dbproto._rhs(node);
var inst_17325 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_17343__$1 = (function (){var statearr_17373 = state_17343;
(statearr_17373[(11)] = inst_17323);

(statearr_17373[(12)] = inst_17324);

(statearr_17373[(13)] = inst_17322);

return statearr_17373;
})();
if(cljs.core.truth_(inst_17325)){
var statearr_17374_17400 = state_17343__$1;
(statearr_17374_17400[(1)] = (16));

} else {
var statearr_17375_17401 = state_17343__$1;
(statearr_17375_17401[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0 = (function (){
var statearr_17376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17376[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__);

(statearr_17376[(1)] = (1));

return statearr_17376;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1 = (function (state_17343){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17343);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17377){var ex__2417__auto__ = e17377;
var statearr_17378_17402 = state_17343;
(statearr_17378_17402[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17343[(4)]))){
var statearr_17379_17403 = state_17343;
(statearr_17379_17403[(1)] = cljs.core.first((state_17343[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17404 = state_17343;
state_17343 = G__17404;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__ = function(state_17343){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1.call(this,state_17343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17380 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17380[(6)] = c__2436__auto__);

return statearr_17380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__17405_17415 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__17406_17416 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17405_17415,G__17406_17416) : object_cache.call(null,G__17405_17415,G__17406_17416));

var G__17407 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__17408 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__17409 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__17410 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17409,G__17410) : object_cache.call(null,G__17409,G__17410));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17407,G__17408) : object_cache.call(null,G__17407,G__17408));
} else {
var G__17411 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__17412 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__17413 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__17414 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17413,G__17414) : object_cache.call(null,G__17413,G__17414));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17411,G__17412) : object_cache.call(null,G__17411,G__17412));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17437){
var state_val_17438 = (state_17437[(1)]);
if((state_val_17438 === (7))){
var state_17437__$1 = state_17437;
var statearr_17439_17459 = state_17437__$1;
(statearr_17439_17459[(2)] = null);

(statearr_17439_17459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (1))){
var state_17437__$1 = state_17437;
var statearr_17440_17460 = state_17437__$1;
(statearr_17440_17460[(2)] = null);

(statearr_17440_17460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (4))){
var inst_17417 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
var statearr_17441_17461 = state_17437__$1;
(statearr_17441_17461[(2)] = inst_17417);

(statearr_17441_17461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (6))){
var inst_17423 = (state_17437[(7)]);
var inst_17425 = fluree.db.storage.core.serde(conn);
var state_17437__$1 = (function (){var statearr_17442 = state_17437;
(statearr_17442[(8)] = inst_17425);

return statearr_17442;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17437__$1,(9),inst_17423);
} else {
if((state_val_17438 === (3))){
var inst_17435 = (state_17437[(2)]);
var state_17437__$1 = state_17437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17437__$1,inst_17435);
} else {
if((state_val_17438 === (2))){
var inst_17423 = (state_17437[(7)]);
var _ = (function (){var statearr_17444 = state_17437;
(statearr_17444[(4)] = cljs.core.cons((5),(state_17437[(4)])));

return statearr_17444;
})();
var inst_17423__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_17437__$1 = (function (){var statearr_17445 = state_17437;
(statearr_17445[(7)] = inst_17423__$1);

return statearr_17445;
})();
if(cljs.core.truth_(inst_17423__$1)){
var statearr_17446_17462 = state_17437__$1;
(statearr_17446_17462[(1)] = (6));

} else {
var statearr_17447_17463 = state_17437__$1;
(statearr_17447_17463[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (9))){
var inst_17425 = (state_17437[(8)]);
var inst_17427 = (state_17437[(2)]);
var inst_17428 = fluree.db.util.async.throw_err(inst_17427);
var inst_17429 = fluree.db.serde.protocol._deserialize_branch(inst_17425,inst_17428);
var state_17437__$1 = state_17437;
var statearr_17448_17464 = state_17437__$1;
(statearr_17448_17464[(2)] = inst_17429);

(statearr_17448_17464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (5))){
var _ = (function (){var statearr_17449 = state_17437;
(statearr_17449[(4)] = cljs.core.rest((state_17437[(4)])));

return statearr_17449;
})();
var state_17437__$1 = state_17437;
var ex17443 = (state_17437__$1[(2)]);
var statearr_17450_17465 = state_17437__$1;
(statearr_17450_17465[(5)] = ex17443);


if((ex17443 instanceof Error)){
var statearr_17451_17466 = state_17437__$1;
(statearr_17451_17466[(1)] = (4));

(statearr_17451_17466[(5)] = null);

} else {
throw ex17443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17438 === (8))){
var inst_17432 = (state_17437[(2)]);
var _ = (function (){var statearr_17452 = state_17437;
(statearr_17452[(4)] = cljs.core.rest((state_17437[(4)])));

return statearr_17452;
})();
var state_17437__$1 = state_17437;
var statearr_17453_17467 = state_17437__$1;
(statearr_17453_17467[(2)] = inst_17432);

(statearr_17453_17467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0 = (function (){
var statearr_17454 = [null,null,null,null,null,null,null,null,null];
(statearr_17454[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2414__auto__);

(statearr_17454[(1)] = (1));

return statearr_17454;
});
var fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1 = (function (state_17437){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17437);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17455){var ex__2417__auto__ = e17455;
var statearr_17456_17468 = state_17437;
(statearr_17456_17468[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17437[(4)]))){
var statearr_17457_17469 = state_17437;
(statearr_17457_17469[(1)] = cljs.core.first((state_17437[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17470 = state_17437;
state_17437 = G__17470;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__ = function(state_17437){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1.call(this,state_17437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17458 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17458[(6)] = c__2436__auto__);

return statearr_17458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___17616 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17561){
var state_val_17562 = (state_17561[(1)]);
if((state_val_17562 === (7))){
var inst_17488 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_17489 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17490 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17491 = cljs.core.PersistentHashMap.fromArrays(inst_17489,inst_17490);
var inst_17492 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17488,inst_17491);
var inst_17493 = (function(){throw inst_17492})();
var state_17561__$1 = state_17561;
var statearr_17563_17617 = state_17561__$1;
(statearr_17563_17617[(2)] = inst_17493);

(statearr_17563_17617[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (20))){
var inst_17485 = (state_17561[(7)]);
var state_17561__$1 = state_17561;
var statearr_17564_17618 = state_17561__$1;
(statearr_17564_17618[(2)] = inst_17485);

(statearr_17564_17618[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (27))){
var inst_17539 = (state_17561[(2)]);
var state_17561__$1 = state_17561;
var statearr_17565_17619 = state_17561__$1;
(statearr_17565_17619[(2)] = inst_17539);

(statearr_17565_17619[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (1))){
var state_17561__$1 = state_17561;
var statearr_17566_17620 = state_17561__$1;
(statearr_17566_17620[(2)] = null);

(statearr_17566_17620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (24))){
var inst_17542 = (state_17561[(2)]);
var state_17561__$1 = state_17561;
if(cljs.core.truth_(inst_17542)){
var statearr_17567_17621 = state_17561__$1;
(statearr_17567_17621[(1)] = (28));

} else {
var statearr_17568_17622 = state_17561__$1;
(statearr_17568_17622[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (4))){
var inst_17471 = (state_17561[(2)]);
var inst_17472 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17473 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17471);
var inst_17474 = cljs.core.async.close_BANG_(return_ch);
var state_17561__$1 = (function (){var statearr_17569 = state_17561;
(statearr_17569[(8)] = inst_17473);

(statearr_17569[(9)] = inst_17472);

return statearr_17569;
})();
var statearr_17570_17623 = state_17561__$1;
(statearr_17570_17623[(2)] = inst_17474);

(statearr_17570_17623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (15))){
var inst_17518 = (state_17561[(2)]);
var state_17561__$1 = state_17561;
if(cljs.core.truth_(inst_17518)){
var statearr_17571_17624 = state_17561__$1;
(statearr_17571_17624[(1)] = (19));

} else {
var statearr_17572_17625 = state_17561__$1;
(statearr_17572_17625[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (21))){
var inst_17523 = (state_17561[(10)]);
var inst_17526 = (state_17561[(11)]);
var inst_17523__$1 = (state_17561[(2)]);
var inst_17524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17523__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_17525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17523__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_17526__$1 = config;
var inst_17528 = (inst_17526__$1 == null);
var inst_17529 = cljs.core.not(inst_17528);
var state_17561__$1 = (function (){var statearr_17573 = state_17561;
(statearr_17573[(10)] = inst_17523__$1);

(statearr_17573[(12)] = inst_17524);

(statearr_17573[(13)] = inst_17525);

(statearr_17573[(11)] = inst_17526__$1);

return statearr_17573;
})();
if(inst_17529){
var statearr_17574_17626 = state_17561__$1;
(statearr_17574_17626[(1)] = (22));

} else {
var statearr_17575_17627 = state_17561__$1;
(statearr_17575_17627[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (13))){
var inst_17485 = (state_17561[(7)]);
var inst_17507 = inst_17485.cljs$lang$protocol_mask$partition0$;
var inst_17508 = (inst_17507 & (64));
var inst_17509 = inst_17485.cljs$core$ISeq$;
var inst_17510 = (cljs.core.PROTOCOL_SENTINEL === inst_17509);
var inst_17511 = ((inst_17508) || (inst_17510));
var state_17561__$1 = state_17561;
if(cljs.core.truth_(inst_17511)){
var statearr_17576_17628 = state_17561__$1;
(statearr_17576_17628[(1)] = (16));

} else {
var statearr_17577_17629 = state_17561__$1;
(statearr_17577_17629[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (22))){
var inst_17526 = (state_17561[(11)]);
var inst_17531 = inst_17526.cljs$lang$protocol_mask$partition0$;
var inst_17532 = (inst_17531 & (64));
var inst_17533 = inst_17526.cljs$core$ISeq$;
var inst_17534 = (cljs.core.PROTOCOL_SENTINEL === inst_17533);
var inst_17535 = ((inst_17532) || (inst_17534));
var state_17561__$1 = state_17561;
if(cljs.core.truth_(inst_17535)){
var statearr_17578_17630 = state_17561__$1;
(statearr_17578_17630[(1)] = (25));

} else {
var statearr_17579_17631 = state_17561__$1;
(statearr_17579_17631[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (29))){
var inst_17526 = (state_17561[(11)]);
var state_17561__$1 = state_17561;
var statearr_17580_17632 = state_17561__$1;
(statearr_17580_17632[(2)] = inst_17526);

(statearr_17580_17632[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (6))){
var inst_17485 = (state_17561[(7)]);
var inst_17484 = (state_17561[(2)]);
var inst_17485__$1 = fluree.db.util.async.throw_err(inst_17484);
var inst_17486 = (inst_17485__$1 == null);
var state_17561__$1 = (function (){var statearr_17581 = state_17561;
(statearr_17581[(7)] = inst_17485__$1);

return statearr_17581;
})();
if(cljs.core.truth_(inst_17486)){
var statearr_17582_17633 = state_17561__$1;
(statearr_17582_17633[(1)] = (7));

} else {
var statearr_17583_17634 = state_17561__$1;
(statearr_17583_17634[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (28))){
var inst_17526 = (state_17561[(11)]);
var inst_17544 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17526);
var state_17561__$1 = state_17561;
var statearr_17584_17635 = state_17561__$1;
(statearr_17584_17635[(2)] = inst_17544);

(statearr_17584_17635[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (25))){
var state_17561__$1 = state_17561;
var statearr_17585_17636 = state_17561__$1;
(statearr_17585_17636[(2)] = true);

(statearr_17585_17636[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (17))){
var state_17561__$1 = state_17561;
var statearr_17586_17637 = state_17561__$1;
(statearr_17586_17637[(2)] = false);

(statearr_17586_17637[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (3))){
var inst_17559 = (state_17561[(2)]);
var state_17561__$1 = state_17561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17561__$1,inst_17559);
} else {
if((state_val_17562 === (12))){
var inst_17485 = (state_17561[(7)]);
var inst_17502 = (state_17561[(2)]);
var inst_17504 = (inst_17485 == null);
var inst_17505 = cljs.core.not(inst_17504);
var state_17561__$1 = (function (){var statearr_17587 = state_17561;
(statearr_17587[(14)] = inst_17502);

return statearr_17587;
})();
if(inst_17505){
var statearr_17588_17638 = state_17561__$1;
(statearr_17588_17638[(1)] = (13));

} else {
var statearr_17589_17639 = state_17561__$1;
(statearr_17589_17639[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (2))){
var _ = (function (){var statearr_17590 = state_17561;
(statearr_17590[(4)] = cljs.core.cons((5),(state_17561[(4)])));

return statearr_17590;
})();
var inst_17482 = fluree.db.storage.core.read_branch(conn,key);
var state_17561__$1 = state_17561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17561__$1,(6),inst_17482);
} else {
if((state_val_17562 === (23))){
var state_17561__$1 = state_17561;
var statearr_17591_17640 = state_17561__$1;
(statearr_17591_17640[(2)] = false);

(statearr_17591_17640[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (19))){
var inst_17485 = (state_17561[(7)]);
var inst_17520 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17485);
var state_17561__$1 = state_17561;
var statearr_17592_17641 = state_17561__$1;
(statearr_17592_17641[(2)] = inst_17520);

(statearr_17592_17641[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (11))){
var state_17561__$1 = state_17561;
var statearr_17594_17642 = state_17561__$1;
(statearr_17594_17642[(2)] = null);

(statearr_17594_17642[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (9))){
var inst_17485 = (state_17561[(7)]);
var inst_17496 = (state_17561[(2)]);
var inst_17497 = fluree.db.util.core.exception_QMARK_(inst_17485);
var state_17561__$1 = (function (){var statearr_17595 = state_17561;
(statearr_17595[(15)] = inst_17496);

return statearr_17595;
})();
if(inst_17497){
var statearr_17596_17643 = state_17561__$1;
(statearr_17596_17643[(1)] = (10));

} else {
var statearr_17597_17644 = state_17561__$1;
(statearr_17597_17644[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (5))){
var _ = (function (){var statearr_17598 = state_17561;
(statearr_17598[(4)] = cljs.core.rest((state_17561[(4)])));

return statearr_17598;
})();
var state_17561__$1 = state_17561;
var ex17593 = (state_17561__$1[(2)]);
var statearr_17599_17645 = state_17561__$1;
(statearr_17599_17645[(5)] = ex17593);


var statearr_17600_17646 = state_17561__$1;
(statearr_17600_17646[(1)] = (4));

(statearr_17600_17646[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (14))){
var state_17561__$1 = state_17561;
var statearr_17601_17647 = state_17561__$1;
(statearr_17601_17647[(2)] = false);

(statearr_17601_17647[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (26))){
var state_17561__$1 = state_17561;
var statearr_17602_17648 = state_17561__$1;
(statearr_17602_17648[(2)] = false);

(statearr_17602_17648[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (16))){
var state_17561__$1 = state_17561;
var statearr_17603_17649 = state_17561__$1;
(statearr_17603_17649[(2)] = true);

(statearr_17603_17649[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (30))){
var inst_17523 = (state_17561[(10)]);
var inst_17524 = (state_17561[(12)]);
var inst_17525 = (state_17561[(13)]);
var inst_17485 = (state_17561[(7)]);
var inst_17502 = (state_17561[(14)]);
var inst_17547 = (state_17561[(2)]);
var inst_17548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17547,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_17550 = (function (){var data = inst_17485;
var _ = inst_17502;
var map__17480 = inst_17523;
var children = inst_17524;
var rhs = inst_17525;
var map__17481 = inst_17547;
var comparator = inst_17548;
return (function (idx,p__17549){
var map__17604 = p__17549;
var map__17604__$1 = (((((!((map__17604 == null))))?(((((map__17604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17604.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17604):map__17604);
var child = map__17604__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17604__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17604__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17604__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17604__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17604__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_17551 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_17550,inst_17524);
var inst_17552 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_17551);
var inst_17553 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_17552,inst_17551);
var inst_17554 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_17548,inst_17553);
var inst_17555 = fluree.db.index.__GT_IndexNode(block,t,inst_17525,inst_17554,config,leftmost_QMARK_);
var inst_17556 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17555);
var _ = (function (){var statearr_17606 = state_17561;
(statearr_17606[(4)] = cljs.core.rest((state_17561[(4)])));

return statearr_17606;
})();
var state_17561__$1 = state_17561;
var statearr_17607_17650 = state_17561__$1;
(statearr_17607_17650[(2)] = inst_17556);

(statearr_17607_17650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (10))){
var inst_17485 = (state_17561[(7)]);
var inst_17499 = (function(){throw inst_17485})();
var state_17561__$1 = state_17561;
var statearr_17608_17651 = state_17561__$1;
(statearr_17608_17651[(2)] = inst_17499);

(statearr_17608_17651[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (18))){
var inst_17515 = (state_17561[(2)]);
var state_17561__$1 = state_17561;
var statearr_17609_17652 = state_17561__$1;
(statearr_17609_17652[(2)] = inst_17515);

(statearr_17609_17652[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17562 === (8))){
var state_17561__$1 = state_17561;
var statearr_17610_17653 = state_17561__$1;
(statearr_17610_17653[(2)] = null);

(statearr_17610_17653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0 = (function (){
var statearr_17611 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17611[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__);

(statearr_17611[(1)] = (1));

return statearr_17611;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1 = (function (state_17561){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17561);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17612){var ex__2417__auto__ = e17612;
var statearr_17613_17654 = state_17561;
(statearr_17613_17654[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17561[(4)]))){
var statearr_17614_17655 = state_17561;
(statearr_17614_17655[(1)] = cljs.core.first((state_17561[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17656 = state_17561;
state_17561 = G__17656;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__ = function(state_17561){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1.call(this,state_17561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17615 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17615[(6)] = c__2436__auto___17616);

return statearr_17615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17677){
var state_val_17678 = (state_17677[(1)]);
if((state_val_17678 === (7))){
var state_17677__$1 = state_17677;
var statearr_17679_17699 = state_17677__$1;
(statearr_17679_17699[(2)] = null);

(statearr_17679_17699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (1))){
var state_17677__$1 = state_17677;
var statearr_17680_17700 = state_17677__$1;
(statearr_17680_17700[(2)] = null);

(statearr_17680_17700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (4))){
var inst_17657 = (state_17677[(2)]);
var state_17677__$1 = state_17677;
var statearr_17681_17701 = state_17677__$1;
(statearr_17681_17701[(2)] = inst_17657);

(statearr_17681_17701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (6))){
var inst_17663 = (state_17677[(7)]);
var inst_17665 = fluree.db.storage.core.serde(conn);
var state_17677__$1 = (function (){var statearr_17682 = state_17677;
(statearr_17682[(8)] = inst_17665);

return statearr_17682;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17677__$1,(9),inst_17663);
} else {
if((state_val_17678 === (3))){
var inst_17675 = (state_17677[(2)]);
var state_17677__$1 = state_17677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17677__$1,inst_17675);
} else {
if((state_val_17678 === (2))){
var inst_17663 = (state_17677[(7)]);
var _ = (function (){var statearr_17684 = state_17677;
(statearr_17684[(4)] = cljs.core.cons((5),(state_17677[(4)])));

return statearr_17684;
})();
var inst_17663__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_17677__$1 = (function (){var statearr_17685 = state_17677;
(statearr_17685[(7)] = inst_17663__$1);

return statearr_17685;
})();
if(cljs.core.truth_(inst_17663__$1)){
var statearr_17686_17702 = state_17677__$1;
(statearr_17686_17702[(1)] = (6));

} else {
var statearr_17687_17703 = state_17677__$1;
(statearr_17687_17703[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (9))){
var inst_17665 = (state_17677[(8)]);
var inst_17667 = (state_17677[(2)]);
var inst_17668 = fluree.db.util.async.throw_err(inst_17667);
var inst_17669 = fluree.db.serde.protocol._deserialize_leaf(inst_17665,inst_17668);
var state_17677__$1 = state_17677;
var statearr_17688_17704 = state_17677__$1;
(statearr_17688_17704[(2)] = inst_17669);

(statearr_17688_17704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (5))){
var _ = (function (){var statearr_17689 = state_17677;
(statearr_17689[(4)] = cljs.core.rest((state_17677[(4)])));

return statearr_17689;
})();
var state_17677__$1 = state_17677;
var ex17683 = (state_17677__$1[(2)]);
var statearr_17690_17705 = state_17677__$1;
(statearr_17690_17705[(5)] = ex17683);


if((ex17683 instanceof Error)){
var statearr_17691_17706 = state_17677__$1;
(statearr_17691_17706[(1)] = (4));

(statearr_17691_17706[(5)] = null);

} else {
throw ex17683;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17678 === (8))){
var inst_17672 = (state_17677[(2)]);
var _ = (function (){var statearr_17692 = state_17677;
(statearr_17692[(4)] = cljs.core.rest((state_17677[(4)])));

return statearr_17692;
})();
var state_17677__$1 = state_17677;
var statearr_17693_17707 = state_17677__$1;
(statearr_17693_17707[(2)] = inst_17672);

(statearr_17693_17707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_17694 = [null,null,null,null,null,null,null,null,null];
(statearr_17694[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__);

(statearr_17694[(1)] = (1));

return statearr_17694;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1 = (function (state_17677){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17677);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17695){var ex__2417__auto__ = e17695;
var statearr_17696_17708 = state_17677;
(statearr_17696_17708[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17677[(4)]))){
var statearr_17697_17709 = state_17677;
(statearr_17697_17709[(1)] = cljs.core.first((state_17677[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17710 = state_17677;
state_17677 = G__17710;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__ = function(state_17677){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1.call(this,state_17677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17698 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17698[(6)] = c__2436__auto__);

return statearr_17698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___17848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17795){
var state_val_17796 = (state_17795[(1)]);
if((state_val_17796 === (7))){
var inst_17727 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_17728 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17729 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17730 = cljs.core.PersistentHashMap.fromArrays(inst_17728,inst_17729);
var inst_17731 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17727,inst_17730);
var inst_17732 = (function(){throw inst_17731})();
var state_17795__$1 = state_17795;
var statearr_17797_17849 = state_17795__$1;
(statearr_17797_17849[(2)] = inst_17732);

(statearr_17797_17849[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (20))){
var inst_17724 = (state_17795[(7)]);
var state_17795__$1 = state_17795;
var statearr_17798_17850 = state_17795__$1;
(statearr_17798_17850[(2)] = inst_17724);

(statearr_17798_17850[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (27))){
var inst_17778 = (state_17795[(2)]);
var state_17795__$1 = state_17795;
var statearr_17799_17851 = state_17795__$1;
(statearr_17799_17851[(2)] = inst_17778);

(statearr_17799_17851[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (1))){
var state_17795__$1 = state_17795;
var statearr_17800_17852 = state_17795__$1;
(statearr_17800_17852[(2)] = null);

(statearr_17800_17852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (24))){
var inst_17781 = (state_17795[(2)]);
var state_17795__$1 = state_17795;
if(cljs.core.truth_(inst_17781)){
var statearr_17801_17853 = state_17795__$1;
(statearr_17801_17853[(1)] = (28));

} else {
var statearr_17802_17854 = state_17795__$1;
(statearr_17802_17854[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (4))){
var inst_17711 = (state_17795[(2)]);
var inst_17712 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17713 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17711);
var inst_17714 = cljs.core.async.close_BANG_(return_ch);
var state_17795__$1 = (function (){var statearr_17803 = state_17795;
(statearr_17803[(8)] = inst_17712);

(statearr_17803[(9)] = inst_17713);

return statearr_17803;
})();
var statearr_17804_17855 = state_17795__$1;
(statearr_17804_17855[(2)] = inst_17714);

(statearr_17804_17855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (15))){
var inst_17757 = (state_17795[(2)]);
var state_17795__$1 = state_17795;
if(cljs.core.truth_(inst_17757)){
var statearr_17805_17856 = state_17795__$1;
(statearr_17805_17856[(1)] = (19));

} else {
var statearr_17806_17857 = state_17795__$1;
(statearr_17806_17857[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (21))){
var inst_17765 = (state_17795[(10)]);
var inst_17762 = (state_17795[(2)]);
var inst_17763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17762,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_17764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17762,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_17765__$1 = config;
var inst_17767 = (inst_17765__$1 == null);
var inst_17768 = cljs.core.not(inst_17767);
var state_17795__$1 = (function (){var statearr_17807 = state_17795;
(statearr_17807[(11)] = inst_17763);

(statearr_17807[(12)] = inst_17764);

(statearr_17807[(10)] = inst_17765__$1);

return statearr_17807;
})();
if(inst_17768){
var statearr_17808_17858 = state_17795__$1;
(statearr_17808_17858[(1)] = (22));

} else {
var statearr_17809_17859 = state_17795__$1;
(statearr_17809_17859[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (13))){
var inst_17724 = (state_17795[(7)]);
var inst_17746 = inst_17724.cljs$lang$protocol_mask$partition0$;
var inst_17747 = (inst_17746 & (64));
var inst_17748 = inst_17724.cljs$core$ISeq$;
var inst_17749 = (cljs.core.PROTOCOL_SENTINEL === inst_17748);
var inst_17750 = ((inst_17747) || (inst_17749));
var state_17795__$1 = state_17795;
if(cljs.core.truth_(inst_17750)){
var statearr_17810_17860 = state_17795__$1;
(statearr_17810_17860[(1)] = (16));

} else {
var statearr_17811_17861 = state_17795__$1;
(statearr_17811_17861[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (22))){
var inst_17765 = (state_17795[(10)]);
var inst_17770 = inst_17765.cljs$lang$protocol_mask$partition0$;
var inst_17771 = (inst_17770 & (64));
var inst_17772 = inst_17765.cljs$core$ISeq$;
var inst_17773 = (cljs.core.PROTOCOL_SENTINEL === inst_17772);
var inst_17774 = ((inst_17771) || (inst_17773));
var state_17795__$1 = state_17795;
if(cljs.core.truth_(inst_17774)){
var statearr_17812_17862 = state_17795__$1;
(statearr_17812_17862[(1)] = (25));

} else {
var statearr_17813_17863 = state_17795__$1;
(statearr_17813_17863[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (29))){
var inst_17765 = (state_17795[(10)]);
var state_17795__$1 = state_17795;
var statearr_17814_17864 = state_17795__$1;
(statearr_17814_17864[(2)] = inst_17765);

(statearr_17814_17864[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (6))){
var inst_17724 = (state_17795[(7)]);
var inst_17724__$1 = (state_17795[(2)]);
var inst_17725 = (inst_17724__$1 == null);
var state_17795__$1 = (function (){var statearr_17815 = state_17795;
(statearr_17815[(7)] = inst_17724__$1);

return statearr_17815;
})();
if(cljs.core.truth_(inst_17725)){
var statearr_17816_17865 = state_17795__$1;
(statearr_17816_17865[(1)] = (7));

} else {
var statearr_17817_17866 = state_17795__$1;
(statearr_17817_17866[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (28))){
var inst_17765 = (state_17795[(10)]);
var inst_17783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17765);
var state_17795__$1 = state_17795;
var statearr_17818_17867 = state_17795__$1;
(statearr_17818_17867[(2)] = inst_17783);

(statearr_17818_17867[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (25))){
var state_17795__$1 = state_17795;
var statearr_17819_17868 = state_17795__$1;
(statearr_17819_17868[(2)] = true);

(statearr_17819_17868[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (17))){
var state_17795__$1 = state_17795;
var statearr_17820_17869 = state_17795__$1;
(statearr_17820_17869[(2)] = false);

(statearr_17820_17869[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (3))){
var inst_17793 = (state_17795[(2)]);
var state_17795__$1 = state_17795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17795__$1,inst_17793);
} else {
if((state_val_17796 === (12))){
var inst_17724 = (state_17795[(7)]);
var inst_17741 = (state_17795[(2)]);
var inst_17743 = (inst_17724 == null);
var inst_17744 = cljs.core.not(inst_17743);
var state_17795__$1 = (function (){var statearr_17821 = state_17795;
(statearr_17821[(13)] = inst_17741);

return statearr_17821;
})();
if(inst_17744){
var statearr_17822_17870 = state_17795__$1;
(statearr_17822_17870[(1)] = (13));

} else {
var statearr_17823_17871 = state_17795__$1;
(statearr_17823_17871[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (2))){
var _ = (function (){var statearr_17824 = state_17795;
(statearr_17824[(4)] = cljs.core.cons((5),(state_17795[(4)])));

return statearr_17824;
})();
var inst_17722 = fluree.db.storage.core.read_leaf(conn,key);
var state_17795__$1 = state_17795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17795__$1,(6),inst_17722);
} else {
if((state_val_17796 === (23))){
var state_17795__$1 = state_17795;
var statearr_17825_17872 = state_17795__$1;
(statearr_17825_17872[(2)] = false);

(statearr_17825_17872[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (19))){
var inst_17724 = (state_17795[(7)]);
var inst_17759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17724);
var state_17795__$1 = state_17795;
var statearr_17826_17873 = state_17795__$1;
(statearr_17826_17873[(2)] = inst_17759);

(statearr_17826_17873[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (11))){
var state_17795__$1 = state_17795;
var statearr_17828_17874 = state_17795__$1;
(statearr_17828_17874[(2)] = null);

(statearr_17828_17874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (9))){
var inst_17724 = (state_17795[(7)]);
var inst_17735 = (state_17795[(2)]);
var inst_17736 = fluree.db.util.core.exception_QMARK_(inst_17724);
var state_17795__$1 = (function (){var statearr_17829 = state_17795;
(statearr_17829[(14)] = inst_17735);

return statearr_17829;
})();
if(inst_17736){
var statearr_17830_17875 = state_17795__$1;
(statearr_17830_17875[(1)] = (10));

} else {
var statearr_17831_17876 = state_17795__$1;
(statearr_17831_17876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (5))){
var _ = (function (){var statearr_17832 = state_17795;
(statearr_17832[(4)] = cljs.core.rest((state_17795[(4)])));

return statearr_17832;
})();
var state_17795__$1 = state_17795;
var ex17827 = (state_17795__$1[(2)]);
var statearr_17833_17877 = state_17795__$1;
(statearr_17833_17877[(5)] = ex17827);


var statearr_17834_17878 = state_17795__$1;
(statearr_17834_17878[(1)] = (4));

(statearr_17834_17878[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (14))){
var state_17795__$1 = state_17795;
var statearr_17835_17879 = state_17795__$1;
(statearr_17835_17879[(2)] = false);

(statearr_17835_17879[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (26))){
var state_17795__$1 = state_17795;
var statearr_17836_17880 = state_17795__$1;
(statearr_17836_17880[(2)] = false);

(statearr_17836_17880[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (16))){
var state_17795__$1 = state_17795;
var statearr_17837_17881 = state_17795__$1;
(statearr_17837_17881[(2)] = true);

(statearr_17837_17881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (30))){
var inst_17763 = (state_17795[(11)]);
var inst_17786 = (state_17795[(2)]);
var inst_17787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17786,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_17788 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_17787,inst_17763);
var inst_17789 = fluree.db.index.data_node(block,t,inst_17788,rhs,config);
var inst_17790 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17789);
var _ = (function (){var statearr_17838 = state_17795;
(statearr_17838[(4)] = cljs.core.rest((state_17795[(4)])));

return statearr_17838;
})();
var state_17795__$1 = state_17795;
var statearr_17839_17882 = state_17795__$1;
(statearr_17839_17882[(2)] = inst_17790);

(statearr_17839_17882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (10))){
var inst_17724 = (state_17795[(7)]);
var inst_17738 = (function(){throw inst_17724})();
var state_17795__$1 = state_17795;
var statearr_17840_17883 = state_17795__$1;
(statearr_17840_17883[(2)] = inst_17738);

(statearr_17840_17883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (18))){
var inst_17754 = (state_17795[(2)]);
var state_17795__$1 = state_17795;
var statearr_17841_17884 = state_17795__$1;
(statearr_17841_17884[(2)] = inst_17754);

(statearr_17841_17884[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17796 === (8))){
var state_17795__$1 = state_17795;
var statearr_17842_17885 = state_17795__$1;
(statearr_17842_17885[(2)] = null);

(statearr_17842_17885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0 = (function (){
var statearr_17843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17843[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__);

(statearr_17843[(1)] = (1));

return statearr_17843;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1 = (function (state_17795){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17795);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17844){var ex__2417__auto__ = e17844;
var statearr_17845_17886 = state_17795;
(statearr_17845_17886[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17795[(4)]))){
var statearr_17846_17887 = state_17795;
(statearr_17846_17887[(1)] = cljs.core.first((state_17795[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17888 = state_17795;
state_17795 = G__17888;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__ = function(state_17795){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1.call(this,state_17795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17847 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17847[(6)] = c__2436__auto___17848);

return statearr_17847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k17890,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__17894 = k17890;
var G__17894__$1 = (((G__17894 instanceof cljs.core.Keyword))?G__17894.fqn:null);
switch (G__17894__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k17890,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__17895){
var vec__17896 = p__17895;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17896,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17896,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__17889){
var self__ = this;
var G__17889__$1 = this;
return (new cljs.core.RecordIter((0),G__17889__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__17899 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__17900 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__17901 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__17902 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17901,G__17902) : object_cache.call(null,G__17901,G__17902));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__17903 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__17904 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17903,G__17904) : object_cache.call(null,G__17903,G__17904));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17899,G__17900) : object_cache.call(null,G__17899,G__17900));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__17905 = history_id;
var G__17906 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__17905,G__17906) : object_cache.call(null,G__17905,G__17906));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__17907 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__17907(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this17891,other17892){
var self__ = this;
var this17891__$1 = this;
return (((!((other17892 == null)))) && ((this17891__$1.constructor === other17892.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.conn,other17892.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.config,other17892.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.network,other17892.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.dbid,other17892.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.id,other17892.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.leaf,other17892.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.first,other17892.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.rhs,other17892.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.size,other17892.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.block,other17892.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.t,other17892.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.tt_id,other17892.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.leftmost_QMARK_,other17892.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.tempid,other17892.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this17891__$1.__extmap,other17892.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__17889){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__17908 = cljs.core.keyword_identical_QMARK_;
var expr__17909 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__17911 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__17912 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17911,G__17912) : pred__17908.call(null,G__17911,G__17912));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__17889,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17913 = new cljs.core.Keyword(null,"config","config",994861415);
var G__17914 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17913,G__17914) : pred__17908.call(null,G__17913,G__17914));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__17889,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17915 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__17916 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17915,G__17916) : pred__17908.call(null,G__17915,G__17916));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__17889,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17917 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__17918 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17917,G__17918) : pred__17908.call(null,G__17917,G__17918));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__17889,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17919 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__17920 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17919,G__17920) : pred__17908.call(null,G__17919,G__17920));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__17889,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17921 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__17922 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17921,G__17922) : pred__17908.call(null,G__17921,G__17922));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__17889,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17923 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__17924 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17923,G__17924) : pred__17908.call(null,G__17923,G__17924));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__17889,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17925 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__17926 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17925,G__17926) : pred__17908.call(null,G__17925,G__17926));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__17889,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17927 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__17928 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17927,G__17928) : pred__17908.call(null,G__17927,G__17928));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__17889,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17929 = new cljs.core.Keyword(null,"block","block",664686210);
var G__17930 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17929,G__17930) : pred__17908.call(null,G__17929,G__17930));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__17889,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17931 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__17932 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17931,G__17932) : pred__17908.call(null,G__17931,G__17932));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__17889,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17933 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__17934 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17933,G__17934) : pred__17908.call(null,G__17933,G__17934));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__17889,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17935 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__17936 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17935,G__17936) : pred__17908.call(null,G__17935,G__17936));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__17889,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__17937 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__17938 = expr__17909;
return (pred__17908.cljs$core$IFn$_invoke$arity$2 ? pred__17908.cljs$core$IFn$_invoke$arity$2(G__17937,G__17938) : pred__17908.call(null,G__17937,G__17938));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__17889,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__17889),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__17889){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__17889,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__17893){
var extmap__4419__auto__ = (function (){var G__17939 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__17893,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__17893)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__17939);
} else {
return G__17939;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__17893),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__17893),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17941 = blank_db;
var map__17941__$1 = (((((!((map__17941 == null))))?(((((map__17941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17941):map__17941);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17941__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17941__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17941__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__17942 = root_data;
var map__17942__$1 = (((((!((map__17942 == null))))?(((((map__17942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17942.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17942):map__17942);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17942__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17942__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17942__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17942__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_17966){
var state_val_17967 = (state_17966[(1)]);
if((state_val_17967 === (7))){
var state_17966__$1 = state_17966;
var statearr_17968_17988 = state_17966__$1;
(statearr_17968_17988[(2)] = null);

(statearr_17968_17988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (1))){
var state_17966__$1 = state_17966;
var statearr_17969_17989 = state_17966__$1;
(statearr_17969_17989[(2)] = null);

(statearr_17969_17989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (4))){
var inst_17945 = (state_17966[(2)]);
var state_17966__$1 = state_17966;
var statearr_17970_17990 = state_17966__$1;
(statearr_17970_17990[(2)] = inst_17945);

(statearr_17970_17990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (6))){
var inst_17952 = (state_17966[(7)]);
var inst_17954 = fluree.db.storage.core.serde(conn);
var state_17966__$1 = (function (){var statearr_17971 = state_17966;
(statearr_17971[(8)] = inst_17954);

return statearr_17971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17966__$1,(9),inst_17952);
} else {
if((state_val_17967 === (3))){
var inst_17964 = (state_17966[(2)]);
var state_17966__$1 = state_17966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17966__$1,inst_17964);
} else {
if((state_val_17967 === (2))){
var inst_17952 = (state_17966[(7)]);
var _ = (function (){var statearr_17973 = state_17966;
(statearr_17973[(4)] = cljs.core.cons((5),(state_17966[(4)])));

return statearr_17973;
})();
var inst_17951 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_17952__$1 = fluree.db.storage.core.storage_read(conn,inst_17951);
var state_17966__$1 = (function (){var statearr_17974 = state_17966;
(statearr_17974[(7)] = inst_17952__$1);

return statearr_17974;
})();
if(cljs.core.truth_(inst_17952__$1)){
var statearr_17975_17991 = state_17966__$1;
(statearr_17975_17991[(1)] = (6));

} else {
var statearr_17976_17992 = state_17966__$1;
(statearr_17976_17992[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (9))){
var inst_17954 = (state_17966[(8)]);
var inst_17956 = (state_17966[(2)]);
var inst_17957 = fluree.db.util.async.throw_err(inst_17956);
var inst_17958 = fluree.db.serde.protocol._deserialize_garbage(inst_17954,inst_17957);
var state_17966__$1 = state_17966;
var statearr_17977_17993 = state_17966__$1;
(statearr_17977_17993[(2)] = inst_17958);

(statearr_17977_17993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (5))){
var _ = (function (){var statearr_17978 = state_17966;
(statearr_17978[(4)] = cljs.core.rest((state_17966[(4)])));

return statearr_17978;
})();
var state_17966__$1 = state_17966;
var ex17972 = (state_17966__$1[(2)]);
var statearr_17979_17994 = state_17966__$1;
(statearr_17979_17994[(5)] = ex17972);


if((ex17972 instanceof Error)){
var statearr_17980_17995 = state_17966__$1;
(statearr_17980_17995[(1)] = (4));

(statearr_17980_17995[(5)] = null);

} else {
throw ex17972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17967 === (8))){
var inst_17961 = (state_17966[(2)]);
var _ = (function (){var statearr_17981 = state_17966;
(statearr_17981[(4)] = cljs.core.rest((state_17966[(4)])));

return statearr_17981;
})();
var state_17966__$1 = state_17966;
var statearr_17982_17996 = state_17966__$1;
(statearr_17982_17996[(2)] = inst_17961);

(statearr_17982_17996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0 = (function (){
var statearr_17983 = [null,null,null,null,null,null,null,null,null];
(statearr_17983[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__);

(statearr_17983[(1)] = (1));

return statearr_17983;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1 = (function (state_17966){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_17966);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e17984){var ex__2417__auto__ = e17984;
var statearr_17985_17997 = state_17966;
(statearr_17985_17997[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_17966[(4)]))){
var statearr_17986_17998 = state_17966;
(statearr_17986_17998[(1)] = cljs.core.first((state_17966[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17999 = state_17966;
state_17966 = G__17999;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__ = function(state_17966){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1.call(this,state_17966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_17987 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_17987[(6)] = c__2436__auto__);

return statearr_17987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18021){
var state_val_18022 = (state_18021[(1)]);
if((state_val_18022 === (7))){
var state_18021__$1 = state_18021;
var statearr_18023_18043 = state_18021__$1;
(statearr_18023_18043[(2)] = null);

(statearr_18023_18043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (1))){
var state_18021__$1 = state_18021;
var statearr_18024_18044 = state_18021__$1;
(statearr_18024_18044[(2)] = null);

(statearr_18024_18044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (4))){
var inst_18000 = (state_18021[(2)]);
var state_18021__$1 = state_18021;
var statearr_18025_18045 = state_18021__$1;
(statearr_18025_18045[(2)] = inst_18000);

(statearr_18025_18045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (6))){
var inst_18007 = (state_18021[(7)]);
var inst_18009 = fluree.db.storage.core.serde(conn);
var state_18021__$1 = (function (){var statearr_18026 = state_18021;
(statearr_18026[(8)] = inst_18009);

return statearr_18026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18021__$1,(9),inst_18007);
} else {
if((state_val_18022 === (3))){
var inst_18019 = (state_18021[(2)]);
var state_18021__$1 = state_18021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18021__$1,inst_18019);
} else {
if((state_val_18022 === (2))){
var inst_18007 = (state_18021[(7)]);
var _ = (function (){var statearr_18028 = state_18021;
(statearr_18028[(4)] = cljs.core.cons((5),(state_18021[(4)])));

return statearr_18028;
})();
var inst_18006 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_18007__$1 = fluree.db.storage.core.storage_read(conn,inst_18006);
var state_18021__$1 = (function (){var statearr_18029 = state_18021;
(statearr_18029[(7)] = inst_18007__$1);

return statearr_18029;
})();
if(cljs.core.truth_(inst_18007__$1)){
var statearr_18030_18046 = state_18021__$1;
(statearr_18030_18046[(1)] = (6));

} else {
var statearr_18031_18047 = state_18021__$1;
(statearr_18031_18047[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (9))){
var inst_18009 = (state_18021[(8)]);
var inst_18011 = (state_18021[(2)]);
var inst_18012 = fluree.db.util.async.throw_err(inst_18011);
var inst_18013 = fluree.db.serde.protocol._deserialize_db_root(inst_18009,inst_18012);
var state_18021__$1 = state_18021;
var statearr_18032_18048 = state_18021__$1;
(statearr_18032_18048[(2)] = inst_18013);

(statearr_18032_18048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (5))){
var _ = (function (){var statearr_18033 = state_18021;
(statearr_18033[(4)] = cljs.core.rest((state_18021[(4)])));

return statearr_18033;
})();
var state_18021__$1 = state_18021;
var ex18027 = (state_18021__$1[(2)]);
var statearr_18034_18049 = state_18021__$1;
(statearr_18034_18049[(5)] = ex18027);


if((ex18027 instanceof Error)){
var statearr_18035_18050 = state_18021__$1;
(statearr_18035_18050[(1)] = (4));

(statearr_18035_18050[(5)] = null);

} else {
throw ex18027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18022 === (8))){
var inst_18016 = (state_18021[(2)]);
var _ = (function (){var statearr_18036 = state_18021;
(statearr_18036[(4)] = cljs.core.rest((state_18021[(4)])));

return statearr_18036;
})();
var state_18021__$1 = state_18021;
var statearr_18037_18051 = state_18021__$1;
(statearr_18037_18051[(2)] = inst_18016);

(statearr_18037_18051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0 = (function (){
var statearr_18038 = [null,null,null,null,null,null,null,null,null];
(statearr_18038[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__);

(statearr_18038[(1)] = (1));

return statearr_18038;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1 = (function (state_18021){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18021);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18039){var ex__2417__auto__ = e18039;
var statearr_18040_18052 = state_18021;
(statearr_18040_18052[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18021[(4)]))){
var statearr_18041_18053 = state_18021;
(statearr_18041_18053[(1)] = cljs.core.first((state_18021[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18054 = state_18021;
state_18021 = G__18054;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__ = function(state_18021){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1.call(this,state_18021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2414__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18042 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18042[(6)] = c__2436__auto__);

return statearr_18042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18090){
var state_val_18091 = (state_18090[(1)]);
if((state_val_18091 === (7))){
var inst_18064 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18065 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18066 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18067 = cljs.core.PersistentHashMap.fromArrays(inst_18065,inst_18066);
var inst_18068 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18064,inst_18067);
var inst_18069 = (function(){throw inst_18068})();
var state_18090__$1 = state_18090;
var statearr_18092_18114 = state_18090__$1;
(statearr_18092_18114[(2)] = inst_18069);

(statearr_18092_18114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (1))){
var state_18090__$1 = state_18090;
var statearr_18093_18115 = state_18090__$1;
(statearr_18093_18115[(2)] = null);

(statearr_18093_18115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (4))){
var inst_18055 = (state_18090[(2)]);
var state_18090__$1 = state_18090;
var statearr_18094_18116 = state_18090__$1;
(statearr_18094_18116[(2)] = inst_18055);

(statearr_18094_18116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (6))){
var state_18090__$1 = state_18090;
var statearr_18095_18117 = state_18090__$1;
(statearr_18095_18117[(2)] = null);

(statearr_18095_18117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (3))){
var inst_18088 = (state_18090[(2)]);
var state_18090__$1 = state_18090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18090__$1,inst_18088);
} else {
if((state_val_18091 === (2))){
var inst_18061 = (state_18090[(7)]);
var _ = (function (){var statearr_18096 = state_18090;
(statearr_18096[(4)] = cljs.core.cons((5),(state_18090[(4)])));

return statearr_18096;
})();
var inst_18061__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_18090__$1 = (function (){var statearr_18097 = state_18090;
(statearr_18097[(7)] = inst_18061__$1);

return statearr_18097;
})();
if(cljs.core.truth_(inst_18061__$1)){
var statearr_18098_18118 = state_18090__$1;
(statearr_18098_18118[(1)] = (6));

} else {
var statearr_18099_18119 = state_18090__$1;
(statearr_18099_18119[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (11))){
var inst_18080 = (state_18090[(8)]);
var inst_18083 = (state_18090[(2)]);
var inst_18084 = fluree.db.util.async.throw_err(inst_18083);
var inst_18085 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18080,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18084);
var _ = (function (){var statearr_18101 = state_18090;
(statearr_18101[(4)] = cljs.core.rest((state_18090[(4)])));

return statearr_18101;
})();
var state_18090__$1 = state_18090;
var statearr_18102_18120 = state_18090__$1;
(statearr_18102_18120[(2)] = inst_18085);

(statearr_18102_18120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (9))){
var inst_18075 = (state_18090[(9)]);
var inst_18073 = (state_18090[(2)]);
var inst_18074 = fluree.db.util.async.throw_err(inst_18073);
var inst_18075__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_18074);
var inst_18076 = fluree.db.query.schema.schema_map(inst_18075__$1);
var state_18090__$1 = (function (){var statearr_18103 = state_18090;
(statearr_18103[(9)] = inst_18075__$1);

return statearr_18103;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18090__$1,(10),inst_18076);
} else {
if((state_val_18091 === (5))){
var _ = (function (){var statearr_18104 = state_18090;
(statearr_18104[(4)] = cljs.core.rest((state_18090[(4)])));

return statearr_18104;
})();
var state_18090__$1 = state_18090;
var ex18100 = (state_18090__$1[(2)]);
var statearr_18105_18121 = state_18090__$1;
(statearr_18105_18121[(5)] = ex18100);


if((ex18100 instanceof Error)){
var statearr_18106_18122 = state_18090__$1;
(statearr_18106_18122[(1)] = (4));

(statearr_18106_18122[(5)] = null);

} else {
throw ex18100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18091 === (10))){
var inst_18075 = (state_18090[(9)]);
var inst_18080 = (state_18090[(8)]);
var inst_18078 = (state_18090[(2)]);
var inst_18079 = fluree.db.util.async.throw_err(inst_18078);
var inst_18080__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18075,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18079);
var inst_18081 = fluree.db.query.schema.setting_map(inst_18080__$1);
var state_18090__$1 = (function (){var statearr_18107 = state_18090;
(statearr_18107[(8)] = inst_18080__$1);

return statearr_18107;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18090__$1,(11),inst_18081);
} else {
if((state_val_18091 === (8))){
var inst_18061 = (state_18090[(7)]);
var inst_18071 = (state_18090[(2)]);
var state_18090__$1 = (function (){var statearr_18108 = state_18090;
(statearr_18108[(10)] = inst_18071);

return statearr_18108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18090__$1,(9),inst_18061);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0 = (function (){
var statearr_18109 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18109[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2414__auto__);

(statearr_18109[(1)] = (1));

return statearr_18109;
});
var fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1 = (function (state_18090){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18090);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18110){var ex__2417__auto__ = e18110;
var statearr_18111_18123 = state_18090;
(statearr_18111_18123[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18090[(4)]))){
var statearr_18112_18124 = state_18090;
(statearr_18112_18124[(1)] = cljs.core.first((state_18090[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18125 = state_18090;
state_18090 = G__18125;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__ = function(state_18090){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1.call(this,state_18090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2414__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2414__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18113 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18113[(6)] = c__2436__auto__);

return statearr_18113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18127 = arguments.length;
switch (G__18127) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18177){
var state_val_18178 = (state_18177[(1)]);
if((state_val_18178 === (7))){
var inst_18137 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18138 = (new Error(inst_18137));
var inst_18139 = (function(){throw inst_18138})();
var state_18177__$1 = state_18177;
var statearr_18179_18215 = state_18177__$1;
(statearr_18179_18215[(2)] = inst_18139);

(statearr_18179_18215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (20))){
var inst_18166 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18180_18216 = state_18177__$1;
(statearr_18180_18216[(2)] = inst_18166);

(statearr_18180_18216[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (1))){
var state_18177__$1 = state_18177;
var statearr_18181_18217 = state_18177__$1;
(statearr_18181_18217[(2)] = null);

(statearr_18181_18217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (4))){
var inst_18128 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18182_18218 = state_18177__$1;
(statearr_18182_18218[(2)] = inst_18128);

(statearr_18182_18218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (15))){
var inst_18146 = (state_18177[(7)]);
var inst_18150 = (state_18177[(8)]);
var inst_18158 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18146,inst_18150);
var state_18177__$1 = state_18177;
var statearr_18183_18219 = state_18177__$1;
(statearr_18183_18219[(2)] = inst_18158);

(statearr_18183_18219[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (13))){
var inst_18145 = (state_18177[(9)]);
var inst_18156 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18145,end);
var state_18177__$1 = state_18177;
if(inst_18156){
var statearr_18184_18220 = state_18177__$1;
(statearr_18184_18220[(1)] = (15));

} else {
var statearr_18185_18221 = state_18177__$1;
(statearr_18185_18221[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (6))){
var state_18177__$1 = state_18177;
var statearr_18186_18222 = state_18177__$1;
(statearr_18186_18222[(2)] = null);

(statearr_18186_18222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (17))){
var inst_18168 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18187_18223 = state_18177__$1;
(statearr_18187_18223[(2)] = inst_18168);

(statearr_18187_18223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (3))){
var inst_18175 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18177__$1,inst_18175);
} else {
if((state_val_18178 === (12))){
var inst_18146 = (state_18177[(7)]);
var state_18177__$1 = state_18177;
var statearr_18188_18224 = state_18177__$1;
(statearr_18188_18224[(2)] = inst_18146);

(statearr_18188_18224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (2))){
var _ = (function (){var statearr_18189 = state_18177;
(statearr_18189[(4)] = cljs.core.cons((5),(state_18177[(4)])));

return statearr_18189;
})();
var inst_18134 = (end >= start);
var state_18177__$1 = state_18177;
if(cljs.core.truth_(inst_18134)){
var statearr_18190_18225 = state_18177__$1;
(statearr_18190_18225[(1)] = (6));

} else {
var statearr_18191_18226 = state_18177__$1;
(statearr_18191_18226[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (19))){
var state_18177__$1 = state_18177;
var statearr_18192_18227 = state_18177__$1;
(statearr_18192_18227[(2)] = null);

(statearr_18192_18227[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (11))){
var inst_18150 = (state_18177[(8)]);
var inst_18150__$1 = (state_18177[(2)]);
var inst_18151 = (inst_18150__$1 == null);
var inst_18152 = (inst_18150__$1 instanceof Error);
var inst_18153 = ((inst_18151) || (inst_18152));
var state_18177__$1 = (function (){var statearr_18194 = state_18177;
(statearr_18194[(8)] = inst_18150__$1);

return statearr_18194;
})();
if(cljs.core.truth_(inst_18153)){
var statearr_18195_18228 = state_18177__$1;
(statearr_18195_18228[(1)] = (12));

} else {
var statearr_18196_18229 = state_18177__$1;
(statearr_18196_18229[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (9))){
var inst_18145 = (state_18177[(9)]);
var inst_18148 = fluree.db.storage.core.read_block(conn,network,dbid,inst_18145);
var state_18177__$1 = state_18177;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18177__$1,(11),inst_18148);
} else {
if((state_val_18178 === (5))){
var _ = (function (){var statearr_18197 = state_18177;
(statearr_18197[(4)] = cljs.core.rest((state_18177[(4)])));

return statearr_18197;
})();
var state_18177__$1 = state_18177;
var ex18193 = (state_18177__$1[(2)]);
var statearr_18198_18230 = state_18177__$1;
(statearr_18198_18230[(5)] = ex18193);


if((ex18193 instanceof Error)){
var statearr_18199_18231 = state_18177__$1;
(statearr_18199_18231[(1)] = (4));

(statearr_18199_18231[(5)] = null);

} else {
throw ex18193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (14))){
var inst_18170 = (state_18177[(2)]);
var state_18177__$1 = state_18177;
var statearr_18200_18232 = state_18177__$1;
(statearr_18200_18232[(2)] = inst_18170);

(statearr_18200_18232[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (16))){
var state_18177__$1 = state_18177;
var statearr_18201_18233 = state_18177__$1;
(statearr_18201_18233[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (10))){
var inst_18172 = (state_18177[(2)]);
var _ = (function (){var statearr_18203 = state_18177;
(statearr_18203[(4)] = cljs.core.rest((state_18177[(4)])));

return statearr_18203;
})();
var state_18177__$1 = state_18177;
var statearr_18204_18234 = state_18177__$1;
(statearr_18204_18234[(2)] = inst_18172);

(statearr_18204_18234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (18))){
var inst_18145 = (state_18177[(9)]);
var inst_18146 = (state_18177[(7)]);
var inst_18150 = (state_18177[(8)]);
var inst_18161 = (inst_18145 + (1));
var inst_18162 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18146,inst_18150);
var inst_18145__$1 = inst_18161;
var inst_18146__$1 = inst_18162;
var state_18177__$1 = (function (){var statearr_18205 = state_18177;
(statearr_18205[(9)] = inst_18145__$1);

(statearr_18205[(7)] = inst_18146__$1);

return statearr_18205;
})();
var statearr_18206_18235 = state_18177__$1;
(statearr_18206_18235[(2)] = null);

(statearr_18206_18235[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18178 === (8))){
var inst_18141 = (state_18177[(2)]);
var inst_18142 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18143 = start;
var inst_18144 = cljs.core.PersistentVector.EMPTY;
var inst_18145 = inst_18143;
var inst_18146 = inst_18144;
var state_18177__$1 = (function (){var statearr_18207 = state_18177;
(statearr_18207[(10)] = inst_18142);

(statearr_18207[(11)] = inst_18141);

(statearr_18207[(9)] = inst_18145);

(statearr_18207[(7)] = inst_18146);

return statearr_18207;
})();
var statearr_18208_18236 = state_18177__$1;
(statearr_18208_18236[(2)] = null);

(statearr_18208_18236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2414__auto__ = null;
var fluree$db$storage$core$state_machine__2414__auto____0 = (function (){
var statearr_18209 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18209[(0)] = fluree$db$storage$core$state_machine__2414__auto__);

(statearr_18209[(1)] = (1));

return statearr_18209;
});
var fluree$db$storage$core$state_machine__2414__auto____1 = (function (state_18177){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18177);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18210){var ex__2417__auto__ = e18210;
var statearr_18211_18237 = state_18177;
(statearr_18211_18237[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18177[(4)]))){
var statearr_18212_18238 = state_18177;
(statearr_18212_18238[(1)] = cljs.core.first((state_18177[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18239 = state_18177;
state_18177 = G__18239;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2414__auto__ = function(state_18177){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2414__auto____1.call(this,state_18177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2414__auto____0;
fluree$db$storage$core$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2414__auto____1;
return fluree$db$storage$core$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18213 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18213[(6)] = c__2436__auto__);

return statearr_18213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18255){
var state_val_18256 = (state_18255[(1)]);
if((state_val_18256 === (1))){
var state_18255__$1 = state_18255;
var statearr_18257_18271 = state_18255__$1;
(statearr_18257_18271[(2)] = null);

(statearr_18257_18271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18256 === (2))){
var _ = (function (){var statearr_18258 = state_18255;
(statearr_18258[(4)] = cljs.core.cons((5),(state_18255[(4)])));

return statearr_18258;
})();
var inst_18246 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18255__$1,(6),inst_18246);
} else {
if((state_val_18256 === (3))){
var inst_18253 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18255__$1,inst_18253);
} else {
if((state_val_18256 === (4))){
var inst_18240 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
var statearr_18260_18272 = state_18255__$1;
(statearr_18260_18272[(2)] = inst_18240);

(statearr_18260_18272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18256 === (5))){
var _ = (function (){var statearr_18261 = state_18255;
(statearr_18261[(4)] = cljs.core.rest((state_18255[(4)])));

return statearr_18261;
})();
var state_18255__$1 = state_18255;
var ex18259 = (state_18255__$1[(2)]);
var statearr_18262_18273 = state_18255__$1;
(statearr_18262_18273[(5)] = ex18259);


if((ex18259 instanceof Error)){
var statearr_18263_18274 = state_18255__$1;
(statearr_18263_18274[(1)] = (4));

(statearr_18263_18274[(5)] = null);

} else {
throw ex18259;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18256 === (6))){
var inst_18248 = (state_18255[(2)]);
var inst_18249 = fluree.db.util.async.throw_err(inst_18248);
var inst_18250 = cljs.core.first(inst_18249);
var _ = (function (){var statearr_18264 = state_18255;
(statearr_18264[(4)] = cljs.core.rest((state_18255[(4)])));

return statearr_18264;
})();
var state_18255__$1 = state_18255;
var statearr_18265_18275 = state_18255__$1;
(statearr_18265_18275[(2)] = inst_18250);

(statearr_18265_18275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2414__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2414__auto____0 = (function (){
var statearr_18266 = [null,null,null,null,null,null,null];
(statearr_18266[(0)] = fluree$db$storage$core$block_$_state_machine__2414__auto__);

(statearr_18266[(1)] = (1));

return statearr_18266;
});
var fluree$db$storage$core$block_$_state_machine__2414__auto____1 = (function (state_18255){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18255);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18267){var ex__2417__auto__ = e18267;
var statearr_18268_18276 = state_18255;
(statearr_18268_18276[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18255[(4)]))){
var statearr_18269_18277 = state_18255;
(statearr_18269_18277[(1)] = cljs.core.first((state_18255[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18278 = state_18255;
state_18255 = G__18278;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2414__auto__ = function(state_18255){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2414__auto____1.call(this,state_18255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2414__auto____0;
fluree$db$storage$core$block_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2414__auto____1;
return fluree$db$storage$core$block_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18270 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18270[(6)] = c__2436__auto__);

return statearr_18270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
