// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21657 = null;
var G__21657__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__21657__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__21657__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__21657 = function(result,flake){
switch(arguments.length){
case 0:
return G__21657__0.call(this);
case 1:
return G__21657__1.call(this,result);
case 2:
return G__21657__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21657.cljs$core$IFn$_invoke$arity$0 = G__21657__0;
G__21657.cljs$core$IFn$_invoke$arity$1 = G__21657__1;
G__21657.cljs$core$IFn$_invoke$arity$2 = G__21657__2;
return G__21657;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21658 = null;
var G__21658__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__21658__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__21658__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__21658 = function(result,flakes){
switch(arguments.length){
case 0:
return G__21658__0.call(this);
case 1:
return G__21658__1.call(this,result);
case 2:
return G__21658__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21658.cljs$core$IFn$_invoke$arity$0 = G__21658__0;
G__21658.cljs$core$IFn$_invoke$arity$1 = G__21658__1;
G__21658.cljs$core$IFn$_invoke$arity$2 = G__21658__2;
return G__21658;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__21660 = res;
var G__21660__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__21659_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__21659_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__21660):G__21660);
var G__21660__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__21660__$1):G__21660__$1);
var G__21660__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__21660__$2):G__21660__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__21660__$3);
} else {
return G__21660__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__21662 = arguments.length;
switch (G__21662) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21965){
var state_val_21966 = (state_21965[(1)]);
if((state_val_21966 === (65))){
var inst_21692 = (state_21965[(7)]);
var inst_21823 = (state_21965[(8)]);
var inst_21816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21817 = cljs.core.deref(cache);
var inst_21818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21819 = flake.o;
var inst_21820 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21692);
var inst_21821 = [inst_21819,inst_21820];
var inst_21822 = (new cljs.core.PersistentVector(null,2,(5),inst_21818,inst_21821,null));
var inst_21823__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21817,inst_21822);
var state_21965__$1 = (function (){var statearr_21967 = state_21965;
(statearr_21967[(9)] = inst_21816);

(statearr_21967[(8)] = inst_21823__$1);

return statearr_21967;
})();
if(cljs.core.truth_(inst_21823__$1)){
var statearr_21968_22134 = state_21965__$1;
(statearr_21968_22134[(1)] = (68));

} else {
var statearr_21969_22135 = state_21965__$1;
(statearr_21969_22135[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (70))){
var inst_21816 = (state_21965[(9)]);
var inst_21841 = (state_21965[(2)]);
var inst_21842 = [inst_21841,offset_map];
var inst_21843 = (new cljs.core.PersistentVector(null,2,(5),inst_21816,inst_21842,null));
var state_21965__$1 = state_21965;
var statearr_21970_22136 = state_21965__$1;
(statearr_21970_22136[(2)] = inst_21843);

(statearr_21970_22136[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (62))){
var inst_21730 = (state_21965[(10)]);
var inst_21724 = (state_21965[(11)]);
var inst_21726 = (state_21965[(12)]);
var inst_21686 = (state_21965[(13)]);
var inst_21703 = (state_21965[(14)]);
var inst_21729 = (state_21965[(15)]);
var inst_21728 = (state_21965[(16)]);
var inst_21785 = (state_21965[(17)]);
var inst_21801 = (state_21965[(18)]);
var inst_21692 = (state_21965[(7)]);
var inst_21725 = (state_21965[(19)]);
var inst_21727 = (state_21965[(20)]);
var inst_21803 = (function (){var map__21669 = inst_21724;
var p = inst_21730;
var pred_spec__$1 = inst_21686;
var orderBy = inst_21728;
var nested_select_spec = inst_21785;
var multi_QMARK_ = inst_21725;
var limit = inst_21727;
var offset = inst_21729;
var G__21787 = inst_21801;
var k = inst_21703;
var pred_spec_SINGLEQUOTE_ = inst_21692;
var ref_QMARK_ = inst_21726;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_21804 = (inst_21803.cljs$core$IFn$_invoke$arity$1 ? inst_21803.cljs$core$IFn$_invoke$arity$1(inst_21801) : inst_21803.call(null,inst_21801));
var state_21965__$1 = state_21965;
var statearr_21971_22137 = state_21965__$1;
(statearr_21971_22137[(2)] = inst_21804);

(statearr_21971_22137[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (74))){
var inst_21850 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21850)){
var statearr_21972_22138 = state_21965__$1;
(statearr_21972_22138[(1)] = (75));

} else {
var statearr_21973_22139 = state_21965__$1;
(statearr_21973_22139[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (7))){
var inst_21673 = (state_21965[(21)]);
var state_21965__$1 = state_21965;
var statearr_21974_22140 = state_21965__$1;
(statearr_21974_22140[(2)] = inst_21673);

(statearr_21974_22140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (59))){
var inst_21795 = (state_21965[(22)]);
var inst_21797 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_21798 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21797,inst_21795);
var state_21965__$1 = state_21965;
var statearr_21975_22141 = state_21965__$1;
(statearr_21975_22141[(2)] = inst_21798);

(statearr_21975_22141[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (86))){
var inst_21730 = (state_21965[(10)]);
var inst_21724 = (state_21965[(11)]);
var inst_21726 = (state_21965[(12)]);
var inst_21686 = (state_21965[(13)]);
var inst_21863 = (state_21965[(23)]);
var inst_21703 = (state_21965[(14)]);
var inst_21729 = (state_21965[(15)]);
var inst_21728 = (state_21965[(16)]);
var inst_21692 = (state_21965[(7)]);
var inst_21725 = (state_21965[(19)]);
var inst_21727 = (state_21965[(20)]);
var inst_21881 = (state_21965[(24)]);
var inst_21883 = (function (){var map__21669 = inst_21724;
var p = inst_21730;
var pred_spec__$1 = inst_21686;
var orderBy = inst_21728;
var children = inst_21863;
var G__21875 = inst_21881;
var multi_QMARK_ = inst_21725;
var limit = inst_21727;
var offset = inst_21729;
var k = inst_21703;
var pred_spec_SINGLEQUOTE_ = inst_21692;
var ref_QMARK_ = inst_21726;
return (function (n){
var G__21976 = db;
var G__21977 = cache;
var G__21978 = fuel;
var G__21979 = max_fuel;
var G__21980 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null);
var G__21981 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__21976,G__21977,G__21978,G__21979,G__21980,G__21981) : fluree.db.query.fql.flakes__GT_res.call(null,G__21976,G__21977,G__21978,G__21979,G__21980,G__21981));
});
})();
var inst_21884 = (inst_21883.cljs$core$IFn$_invoke$arity$1 ? inst_21883.cljs$core$IFn$_invoke$arity$1(inst_21881) : inst_21883.call(null,inst_21881));
var state_21965__$1 = state_21965;
var statearr_21982_22142 = state_21965__$1;
(statearr_21982_22142[(2)] = inst_21884);

(statearr_21982_22142[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (20))){
var inst_21701 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_21983_22143 = state_21965__$1;
(statearr_21983_22143[(2)] = inst_21701);

(statearr_21983_22143[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (72))){
var inst_21692 = (state_21965[(7)]);
var inst_21847 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = state_21965;
var statearr_21984_22144 = state_21965__$1;
(statearr_21984_22144[(2)] = inst_21847);

(statearr_21984_22144[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (58))){
var inst_21794 = (state_21965[(2)]);
var inst_21795 = fluree.db.util.async.throw_err(inst_21794);
var state_21965__$1 = (function (){var statearr_21985 = state_21965;
(statearr_21985[(22)] = inst_21795);

return statearr_21985;
})();
if(cljs.core.truth_(fuel)){
var statearr_21986_22145 = state_21965__$1;
(statearr_21986_22145[(1)] = (59));

} else {
var statearr_21987_22146 = state_21965__$1;
(statearr_21987_22146[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (60))){
var inst_21795 = (state_21965[(22)]);
var state_21965__$1 = state_21965;
var statearr_21988_22147 = state_21965__$1;
(statearr_21988_22147[(2)] = inst_21795);

(statearr_21988_22147[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (27))){
var inst_21692 = (state_21965[(7)]);
var inst_21721 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21692);
var state_21965__$1 = state_21965;
var statearr_21989_22148 = state_21965__$1;
(statearr_21989_22148[(2)] = inst_21721);

(statearr_21989_22148[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (1))){
var state_21965__$1 = state_21965;
var statearr_21990_22149 = state_21965__$1;
(statearr_21990_22149[(2)] = null);

(statearr_21990_22149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (69))){
var inst_21692 = (state_21965[(7)]);
var inst_21826 = flake.o;
var inst_21827 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21692);
var inst_21828 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_21826,inst_21827);
var state_21965__$1 = state_21965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21965__$1,(71),inst_21828);
} else {
if((state_val_21966 === (101))){
var inst_21926 = (state_21965[(25)]);
var inst_21703 = (state_21965[(14)]);
var inst_21925 = (state_21965[(26)]);
var inst_21945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21703,inst_21925);
var inst_21947 = [inst_21946,inst_21926];
var inst_21948 = (new cljs.core.PersistentVector(null,2,(5),inst_21945,inst_21947,null));
var state_21965__$1 = state_21965;
var statearr_21991_22150 = state_21965__$1;
(statearr_21991_22150[(2)] = inst_21948);

(statearr_21991_22150[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (24))){
var state_21965__$1 = state_21965;
var statearr_21992_22151 = state_21965__$1;
(statearr_21992_22151[(2)] = true);

(statearr_21992_22151[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (102))){
var state_21965__$1 = state_21965;
var statearr_21993_22152 = state_21965__$1;
(statearr_21993_22152[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (55))){
var inst_21692 = (state_21965[(7)]);
var inst_21814 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21814)){
var statearr_21995_22153 = state_21965__$1;
(statearr_21995_22153[(1)] = (65));

} else {
var statearr_21996_22154 = state_21965__$1;
(statearr_21996_22154[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (85))){
var inst_21881 = (state_21965[(2)]);
var state_21965__$1 = (function (){var statearr_21997 = state_21965;
(statearr_21997[(24)] = inst_21881);

return statearr_21997;
})();
var statearr_21998_22155 = state_21965__$1;
(statearr_21998_22155[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (39))){
var inst_21730 = (state_21965[(10)]);
var inst_21747 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21730,cljs.core.dec);
var state_21965__$1 = state_21965;
var statearr_22000_22156 = state_21965__$1;
(statearr_22000_22156[(2)] = inst_21747);

(statearr_22000_22156[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (88))){
var inst_21887 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21965__$1,(82),inst_21887);
} else {
if((state_val_21966 === (46))){
var inst_21770 = cljs.core.not(recur_QMARK_);
var state_21965__$1 = state_21965;
if(inst_21770){
var statearr_22001_22157 = state_21965__$1;
(statearr_22001_22157[(1)] = (48));

} else {
var statearr_22002_22158 = state_21965__$1;
(statearr_22002_22158[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (4))){
var inst_21663 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22003_22159 = state_21965__$1;
(statearr_22003_22159[(2)] = inst_21663);

(statearr_22003_22159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (77))){
var inst_21916 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22004_22160 = state_21965__$1;
(statearr_22004_22160[(2)] = inst_21916);

(statearr_22004_22160[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (106))){
var inst_21956 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22005_22161 = state_21965__$1;
(statearr_22005_22161[(2)] = inst_21956);

(statearr_22005_22161[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (95))){
var inst_21725 = (state_21965[(19)]);
var state_21965__$1 = state_21965;
var statearr_22006_22162 = state_21965__$1;
(statearr_22006_22162[(2)] = inst_21725);

(statearr_22006_22162[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (54))){
var inst_21692 = (state_21965[(7)]);
var inst_21782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21783 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21784 = (new cljs.core.PersistentVector(null,3,(5),inst_21782,inst_21783,null));
var inst_21785 = cljs.core.select_keys(inst_21692,inst_21784);
var inst_21786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21789 = flake.o;
var inst_21790 = [inst_21789];
var inst_21791 = (new cljs.core.PersistentVector(null,1,(5),inst_21788,inst_21790,null));
var inst_21792 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21791);
var state_21965__$1 = (function (){var statearr_22007 = state_21965;
(statearr_22007[(27)] = inst_21786);

(statearr_22007[(17)] = inst_21785);

return statearr_22007;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21965__$1,(58),inst_21792);
} else {
if((state_val_21966 === (92))){
var inst_21906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21907 = flake.o;
var inst_21908 = [inst_21907,offset_map];
var inst_21909 = (new cljs.core.PersistentVector(null,2,(5),inst_21906,inst_21908,null));
var state_21965__$1 = state_21965;
var statearr_22008_22163 = state_21965__$1;
(statearr_22008_22163[(2)] = inst_21909);

(statearr_22008_22163[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (104))){
var inst_21926 = (state_21965[(25)]);
var inst_21951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21952 = [acc,inst_21926];
var inst_21953 = (new cljs.core.PersistentVector(null,2,(5),inst_21951,inst_21952,null));
var state_21965__$1 = state_21965;
var statearr_22009_22164 = state_21965__$1;
(statearr_22009_22164[(2)] = inst_21953);

(statearr_22009_22164[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (15))){
var inst_21693 = (state_21965[(28)]);
var state_21965__$1 = state_21965;
var statearr_22010_22165 = state_21965__$1;
(statearr_22010_22165[(2)] = inst_21693);

(statearr_22010_22165[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (48))){
var inst_21772 = (state_21965[(29)]);
var inst_21692 = (state_21965[(7)]);
var inst_21772__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = (function (){var statearr_22011 = state_21965;
(statearr_22011[(29)] = inst_21772__$1);

return statearr_22011;
})();
if(cljs.core.truth_(inst_21772__$1)){
var statearr_22012_22166 = state_21965__$1;
(statearr_22012_22166[(1)] = (51));

} else {
var statearr_22013_22167 = state_21965__$1;
(statearr_22013_22167[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (50))){
var inst_21780 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21780)){
var statearr_22014_22168 = state_21965__$1;
(statearr_22014_22168[(1)] = (54));

} else {
var statearr_22015_22169 = state_21965__$1;
(statearr_22015_22169[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (75))){
var inst_21692 = (state_21965[(7)]);
var inst_21852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21853 = flake.o;
var inst_21854 = [inst_21853];
var inst_21855 = (new cljs.core.PersistentVector(null,1,(5),inst_21852,inst_21854,null));
var inst_21856 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21857 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21692);
var inst_21858 = [inst_21857];
var inst_21859 = cljs.core.PersistentHashMap.fromArrays(inst_21856,inst_21858);
var inst_21860 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21855,inst_21859);
var state_21965__$1 = state_21965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21965__$1,(78),inst_21860);
} else {
if((state_val_21966 === (99))){
var inst_21925 = (state_21965[(26)]);
var inst_21942 = (inst_21925 == null);
var inst_21943 = cljs.core.not(inst_21942);
var state_21965__$1 = state_21965;
if(inst_21943){
var statearr_22016_22170 = state_21965__$1;
(statearr_22016_22170[(1)] = (101));

} else {
var statearr_22017_22171 = state_21965__$1;
(statearr_22017_22171[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (21))){
var inst_21692 = (state_21965[(7)]);
var inst_21708 = inst_21692.cljs$lang$protocol_mask$partition0$;
var inst_21709 = (inst_21708 & (64));
var inst_21710 = inst_21692.cljs$core$ISeq$;
var inst_21711 = (cljs.core.PROTOCOL_SENTINEL === inst_21710);
var inst_21712 = ((inst_21709) || (inst_21711));
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21712)){
var statearr_22018_22172 = state_21965__$1;
(statearr_22018_22172[(1)] = (24));

} else {
var statearr_22019_22173 = state_21965__$1;
(statearr_22019_22173[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (31))){
var inst_21725 = (state_21965[(19)]);
var state_21965__$1 = state_21965;
var statearr_22020_22174 = state_21965__$1;
(statearr_22020_22174[(2)] = inst_21725);

(statearr_22020_22174[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (32))){
var inst_21742 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21742)){
var statearr_22021_22175 = state_21965__$1;
(statearr_22021_22175[(1)] = (36));

} else {
var statearr_22022_22176 = state_21965__$1;
(statearr_22022_22176[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (40))){
var inst_21730 = (state_21965[(10)]);
var inst_21729 = (state_21965[(15)]);
var inst_21749 = (inst_21729 - (1));
var inst_21750 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21730,inst_21749);
var state_21965__$1 = state_21965;
var statearr_22023_22177 = state_21965__$1;
(statearr_22023_22177[(2)] = inst_21750);

(statearr_22023_22177[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (91))){
var inst_21914 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22024_22178 = state_21965__$1;
(statearr_22024_22178[(2)] = inst_21914);

(statearr_22024_22178[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (56))){
var inst_21920 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22025_22179 = state_21965__$1;
(statearr_22025_22179[(2)] = inst_21920);

(statearr_22025_22179[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (33))){
var inst_21730 = (state_21965[(10)]);
var inst_21729 = (state_21965[(15)]);
var inst_21733 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21729);
var inst_21734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21730);
var inst_21735 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21734);
var inst_21736 = ((inst_21733) && (inst_21735));
var state_21965__$1 = state_21965;
var statearr_22026_22180 = state_21965__$1;
(statearr_22026_22180[(2)] = inst_21736);

(statearr_22026_22180[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (13))){
var inst_21686 = (state_21965[(13)]);
var inst_21690 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21686,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_21965__$1 = state_21965;
var statearr_22027_22181 = state_21965__$1;
(statearr_22027_22181[(2)] = inst_21690);

(statearr_22027_22181[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (22))){
var state_21965__$1 = state_21965;
var statearr_22028_22182 = state_21965__$1;
(statearr_22028_22182[(2)] = false);

(statearr_22028_22182[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (90))){
var state_21965__$1 = state_21965;
var statearr_22029_22183 = state_21965__$1;
(statearr_22029_22183[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (36))){
var inst_21730 = (state_21965[(10)]);
var inst_21744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21730);
var state_21965__$1 = (function (){var statearr_22031 = state_21965;
(statearr_22031[(30)] = inst_21744);

return statearr_22031;
})();
if(cljs.core.truth_(inst_21745)){
var statearr_22032_22184 = state_21965__$1;
(statearr_22032_22184[(1)] = (39));

} else {
var statearr_22033_22185 = state_21965__$1;
(statearr_22033_22185[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (41))){
var inst_21744 = (state_21965[(30)]);
var inst_21752 = (state_21965[(2)]);
var inst_21753 = [null,inst_21752];
var inst_21754 = (new cljs.core.PersistentVector(null,2,(5),inst_21744,inst_21753,null));
var state_21965__$1 = state_21965;
var statearr_22034_22186 = state_21965__$1;
(statearr_22034_22186[(2)] = inst_21754);

(statearr_22034_22186[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (89))){
var inst_21897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21898 = ["_id"];
var inst_21899 = flake.o;
var inst_21900 = [inst_21899];
var inst_21901 = cljs.core.PersistentHashMap.fromArrays(inst_21898,inst_21900);
var inst_21902 = [inst_21901,offset_map];
var inst_21903 = (new cljs.core.PersistentVector(null,2,(5),inst_21897,inst_21902,null));
var state_21965__$1 = state_21965;
var statearr_22035_22187 = state_21965__$1;
(statearr_22035_22187[(2)] = inst_21903);

(statearr_22035_22187[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (100))){
var inst_21960 = (state_21965[(2)]);
var _ = (function (){var statearr_22036 = state_21965;
(statearr_22036[(4)] = cljs.core.rest((state_21965[(4)])));

return statearr_22036;
})();
var state_21965__$1 = state_21965;
var statearr_22037_22188 = state_21965__$1;
(statearr_22037_22188[(2)] = inst_21960);

(statearr_22037_22188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (43))){
var inst_21725 = (state_21965[(19)]);
var state_21965__$1 = state_21965;
var statearr_22038_22189 = state_21965__$1;
(statearr_22038_22189[(2)] = inst_21725);

(statearr_22038_22189[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (61))){
var inst_21801 = (state_21965[(2)]);
var state_21965__$1 = (function (){var statearr_22039 = state_21965;
(statearr_22039[(18)] = inst_21801);

return statearr_22039;
})();
var statearr_22040_22190 = state_21965__$1;
(statearr_22040_22190[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (29))){
var inst_21724 = (state_21965[(11)]);
var inst_21725 = (state_21965[(19)]);
var inst_21724__$1 = (state_21965[(2)]);
var inst_21725__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21724__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_21965__$1 = (function (){var statearr_22042 = state_21965;
(statearr_22042[(10)] = inst_21730);

(statearr_22042[(11)] = inst_21724__$1);

(statearr_22042[(12)] = inst_21726);

(statearr_22042[(15)] = inst_21729);

(statearr_22042[(16)] = inst_21728);

(statearr_22042[(19)] = inst_21725__$1);

(statearr_22042[(20)] = inst_21727);

return statearr_22042;
})();
if(cljs.core.truth_(inst_21725__$1)){
var statearr_22043_22191 = state_21965__$1;
(statearr_22043_22191[(1)] = (30));

} else {
var statearr_22044_22192 = state_21965__$1;
(statearr_22044_22192[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (44))){
var inst_21764 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21764)){
var statearr_22045_22193 = state_21965__$1;
(statearr_22045_22193[(1)] = (45));

} else {
var statearr_22046_22194 = state_21965__$1;
(statearr_22046_22194[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (93))){
var state_21965__$1 = state_21965;
var statearr_22047_22195 = state_21965__$1;
(statearr_22047_22195[(2)] = null);

(statearr_22047_22195[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (6))){
var inst_21675 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21676 = (inst_21675 == null);
var state_21965__$1 = state_21965;
var statearr_22048_22196 = state_21965__$1;
(statearr_22048_22196[(2)] = inst_21676);

(statearr_22048_22196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (28))){
var inst_21692 = (state_21965[(7)]);
var state_21965__$1 = state_21965;
var statearr_22049_22197 = state_21965__$1;
(statearr_22049_22197[(2)] = inst_21692);

(statearr_22049_22197[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (64))){
var inst_21807 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21965__$1,(57),inst_21807);
} else {
if((state_val_21966 === (103))){
var inst_21958 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22050_22198 = state_21965__$1;
(statearr_22050_22198[(2)] = inst_21958);

(statearr_22050_22198[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (51))){
var inst_21772 = (state_21965[(29)]);
var state_21965__$1 = state_21965;
var statearr_22051_22199 = state_21965__$1;
(statearr_22051_22199[(2)] = inst_21772);

(statearr_22051_22199[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (25))){
var state_21965__$1 = state_21965;
var statearr_22052_22200 = state_21965__$1;
(statearr_22052_22200[(2)] = false);

(statearr_22052_22200[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (34))){
var inst_21729 = (state_21965[(15)]);
var state_21965__$1 = state_21965;
var statearr_22053_22201 = state_21965__$1;
(statearr_22053_22201[(2)] = inst_21729);

(statearr_22053_22201[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (17))){
var inst_21692 = (state_21965[(7)]);
var inst_21703 = (state_21965[(2)]);
var inst_21705 = (inst_21692 == null);
var inst_21706 = cljs.core.not(inst_21705);
var state_21965__$1 = (function (){var statearr_22054 = state_21965;
(statearr_22054[(14)] = inst_21703);

return statearr_22054;
})();
if(inst_21706){
var statearr_22055_22202 = state_21965__$1;
(statearr_22055_22202[(1)] = (21));

} else {
var statearr_22056_22203 = state_21965__$1;
(statearr_22056_22203[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (3))){
var inst_21963 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21965__$1,inst_21963);
} else {
if((state_val_21966 === (12))){
var inst_21686 = (state_21965[(13)]);
var state_21965__$1 = state_21965;
var statearr_22057_22204 = state_21965__$1;
(statearr_22057_22204[(2)] = inst_21686);

(statearr_22057_22204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (2))){
var inst_21673 = (state_21965[(21)]);
var _ = (function (){var statearr_22058 = state_21965;
(statearr_22058[(4)] = cljs.core.cons((5),(state_21965[(4)])));

return statearr_22058;
})();
var inst_21673__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_21965__$1 = (function (){var statearr_22059 = state_21965;
(statearr_22059[(21)] = inst_21673__$1);

return statearr_22059;
})();
if(cljs.core.truth_(inst_21673__$1)){
var statearr_22060_22205 = state_21965__$1;
(statearr_22060_22205[(1)] = (6));

} else {
var statearr_22061_22206 = state_21965__$1;
(statearr_22061_22206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (66))){
var inst_21845 = (state_21965[(31)]);
var inst_21845__$1 = componentFollow_QMARK_;
var state_21965__$1 = (function (){var statearr_22062 = state_21965;
(statearr_22062[(31)] = inst_21845__$1);

return statearr_22062;
})();
if(cljs.core.truth_(inst_21845__$1)){
var statearr_22063_22207 = state_21965__$1;
(statearr_22063_22207[(1)] = (72));

} else {
var statearr_22064_22208 = state_21965__$1;
(statearr_22064_22208[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (23))){
var inst_21719 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21719)){
var statearr_22065_22209 = state_21965__$1;
(statearr_22065_22209[(1)] = (27));

} else {
var statearr_22066_22210 = state_21965__$1;
(statearr_22066_22210[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (47))){
var inst_21922 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22067_22211 = state_21965__$1;
(statearr_22067_22211[(2)] = inst_21922);

(statearr_22067_22211[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (35))){
var inst_21739 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22068_22212 = state_21965__$1;
(statearr_22068_22212[(2)] = inst_21739);

(statearr_22068_22212[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (82))){
var inst_21874 = (state_21965[(32)]);
var inst_21889 = (state_21965[(2)]);
var inst_21890 = fluree.db.util.async.throw_err(inst_21889);
var inst_21891 = [inst_21890,offset_map];
var inst_21892 = (new cljs.core.PersistentVector(null,2,(5),inst_21874,inst_21891,null));
var state_21965__$1 = state_21965;
var statearr_22069_22213 = state_21965__$1;
(statearr_22069_22213[(2)] = inst_21892);

(statearr_22069_22213[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (76))){
var inst_21726 = (state_21965[(12)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21726)){
var statearr_22070_22214 = state_21965__$1;
(statearr_22070_22214[(1)] = (89));

} else {
var statearr_22071_22215 = state_21965__$1;
(statearr_22071_22215[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (97))){
var inst_21932 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21932)){
var statearr_22072_22216 = state_21965__$1;
(statearr_22072_22216[(1)] = (98));

} else {
var statearr_22073_22217 = state_21965__$1;
(statearr_22073_22217[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (19))){
var inst_21692 = (state_21965[(7)]);
var inst_21699 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = state_21965;
var statearr_22074_22218 = state_21965__$1;
(statearr_22074_22218[(2)] = inst_21699);

(statearr_22074_22218[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (57))){
var inst_21786 = (state_21965[(27)]);
var inst_21809 = (state_21965[(2)]);
var inst_21810 = fluree.db.util.async.throw_err(inst_21809);
var inst_21811 = [inst_21810,offset_map];
var inst_21812 = (new cljs.core.PersistentVector(null,2,(5),inst_21786,inst_21811,null));
var state_21965__$1 = state_21965;
var statearr_22075_22219 = state_21965__$1;
(statearr_22075_22219[(2)] = inst_21812);

(statearr_22075_22219[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (68))){
var inst_21823 = (state_21965[(8)]);
var state_21965__$1 = state_21965;
var statearr_22076_22220 = state_21965__$1;
(statearr_22076_22220[(2)] = inst_21823);

(statearr_22076_22220[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (11))){
var inst_21686 = (state_21965[(13)]);
var inst_21686__$1 = (state_21965[(2)]);
var inst_21687 = cljs.core.contains_QMARK_(inst_21686__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_21965__$1 = (function (){var statearr_22078 = state_21965;
(statearr_22078[(13)] = inst_21686__$1);

return statearr_22078;
})();
if(inst_21687){
var statearr_22079_22221 = state_21965__$1;
(statearr_22079_22221[(1)] = (12));

} else {
var statearr_22080_22222 = state_21965__$1;
(statearr_22080_22222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (9))){
var inst_21681 = flake.p;
var inst_21682 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21683 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_21681,inst_21682);
var state_21965__$1 = state_21965;
var statearr_22081_22223 = state_21965__$1;
(statearr_22081_22223[(2)] = inst_21683);

(statearr_22081_22223[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (5))){
var _ = (function (){var statearr_22082 = state_21965;
(statearr_22082[(4)] = cljs.core.rest((state_21965[(4)])));

return statearr_22082;
})();
var state_21965__$1 = state_21965;
var ex22077 = (state_21965__$1[(2)]);
var statearr_22083_22224 = state_21965__$1;
(statearr_22083_22224[(5)] = ex22077);


if((ex22077 instanceof Error)){
var statearr_22084_22225 = state_21965__$1;
(statearr_22084_22225[(1)] = (4));

(statearr_22084_22225[(5)] = null);

} else {
throw ex22077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (83))){
var inst_21863 = (state_21965[(23)]);
var inst_21877 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_21878 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21877,inst_21863);
var state_21965__$1 = state_21965;
var statearr_22085_22226 = state_21965__$1;
(statearr_22085_22226[(2)] = inst_21878);

(statearr_22085_22226[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (14))){
var inst_21693 = (state_21965[(28)]);
var inst_21692 = (state_21965[(7)]);
var inst_21692__$1 = (state_21965[(2)]);
var inst_21693__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21692__$1);
var state_21965__$1 = (function (){var statearr_22086 = state_21965;
(statearr_22086[(28)] = inst_21693__$1);

(statearr_22086[(7)] = inst_21692__$1);

return statearr_22086;
})();
if(cljs.core.truth_(inst_21693__$1)){
var statearr_22087_22227 = state_21965__$1;
(statearr_22087_22227[(1)] = (15));

} else {
var statearr_22088_22228 = state_21965__$1;
(statearr_22088_22228[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (45))){
var inst_21766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21767 = [null,offset_map];
var inst_21768 = (new cljs.core.PersistentVector(null,2,(5),inst_21766,inst_21767,null));
var state_21965__$1 = state_21965;
var statearr_22089_22229 = state_21965__$1;
(statearr_22089_22229[(2)] = inst_21768);

(statearr_22089_22229[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (53))){
var inst_21777 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22090_22230 = state_21965__$1;
(statearr_22090_22230[(2)] = inst_21777);

(statearr_22090_22230[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (78))){
var inst_21863 = (state_21965[(23)]);
var inst_21862 = (state_21965[(2)]);
var inst_21863__$1 = fluree.db.util.async.throw_err(inst_21862);
var inst_21864 = cljs.core.empty_QMARK_(inst_21863__$1);
var state_21965__$1 = (function (){var statearr_22091 = state_21965;
(statearr_22091[(23)] = inst_21863__$1);

return statearr_22091;
})();
if(inst_21864){
var statearr_22092_22231 = state_21965__$1;
(statearr_22092_22231[(1)] = (79));

} else {
var statearr_22093_22232 = state_21965__$1;
(statearr_22093_22232[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (26))){
var inst_21716 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22094_22233 = state_21965__$1;
(statearr_22094_22233[(2)] = inst_21716);

(statearr_22094_22233[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (16))){
var inst_21696 = (state_21965[(33)]);
var inst_21692 = (state_21965[(7)]);
var inst_21696__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = (function (){var statearr_22095 = state_21965;
(statearr_22095[(33)] = inst_21696__$1);

return statearr_22095;
})();
if(cljs.core.truth_(inst_21696__$1)){
var statearr_22096_22234 = state_21965__$1;
(statearr_22096_22234[(1)] = (18));

} else {
var statearr_22097_22235 = state_21965__$1;
(statearr_22097_22235[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (81))){
var inst_21894 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22098_22236 = state_21965__$1;
(statearr_22098_22236[(2)] = inst_21894);

(statearr_22098_22236[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (79))){
var inst_21866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21867 = ["_id"];
var inst_21868 = flake.o;
var inst_21869 = [inst_21868];
var inst_21870 = cljs.core.PersistentHashMap.fromArrays(inst_21867,inst_21869);
var inst_21871 = [inst_21870,offset_map];
var inst_21872 = (new cljs.core.PersistentVector(null,2,(5),inst_21866,inst_21871,null));
var state_21965__$1 = state_21965;
var statearr_22099_22237 = state_21965__$1;
(statearr_22099_22237[(2)] = inst_21872);

(statearr_22099_22237[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (38))){
var inst_21925 = (state_21965[(26)]);
var inst_21924 = (state_21965[(2)]);
var inst_21925__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21924,(0),null);
var inst_21926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21924,(1),null);
var inst_21927 = (inst_21925__$1 == null);
var inst_21928 = cljs.core.not(inst_21927);
var state_21965__$1 = (function (){var statearr_22100 = state_21965;
(statearr_22100[(25)] = inst_21926);

(statearr_22100[(26)] = inst_21925__$1);

return statearr_22100;
})();
if(inst_21928){
var statearr_22101_22238 = state_21965__$1;
(statearr_22101_22238[(1)] = (95));

} else {
var statearr_22102_22239 = state_21965__$1;
(statearr_22102_22239[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (98))){
var inst_21926 = (state_21965[(25)]);
var inst_21703 = (state_21965[(14)]);
var inst_21925 = (state_21965[(26)]);
var inst_21934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21935 = cljs.core.PersistentVector.EMPTY;
var inst_21936 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_21703,inst_21935);
var inst_21937 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21936,inst_21925);
var inst_21938 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21703,inst_21937);
var inst_21939 = [inst_21938,inst_21926];
var inst_21940 = (new cljs.core.PersistentVector(null,2,(5),inst_21934,inst_21939,null));
var state_21965__$1 = state_21965;
var statearr_22103_22240 = state_21965__$1;
(statearr_22103_22240[(2)] = inst_21940);

(statearr_22103_22240[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (87))){
var inst_21881 = (state_21965[(24)]);
var state_21965__$1 = state_21965;
var statearr_22104_22241 = state_21965__$1;
(statearr_22104_22241[(2)] = inst_21881);

(statearr_22104_22241[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (30))){
var inst_21729 = (state_21965[(15)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21729)){
var statearr_22105_22242 = state_21965__$1;
(statearr_22105_22242[(1)] = (33));

} else {
var statearr_22106_22243 = state_21965__$1;
(statearr_22106_22243[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (73))){
var inst_21845 = (state_21965[(31)]);
var state_21965__$1 = state_21965;
var statearr_22107_22244 = state_21965__$1;
(statearr_22107_22244[(2)] = inst_21845);

(statearr_22107_22244[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (96))){
var state_21965__$1 = state_21965;
var statearr_22108_22245 = state_21965__$1;
(statearr_22108_22245[(2)] = false);

(statearr_22108_22245[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (10))){
var state_21965__$1 = state_21965;
var statearr_22109_22246 = state_21965__$1;
(statearr_22109_22246[(2)] = pred_spec);

(statearr_22109_22246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (18))){
var inst_21696 = (state_21965[(33)]);
var state_21965__$1 = state_21965;
var statearr_22110_22247 = state_21965__$1;
(statearr_22110_22247[(2)] = inst_21696);

(statearr_22110_22247[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (105))){
var state_21965__$1 = state_21965;
var statearr_22111_22248 = state_21965__$1;
(statearr_22111_22248[(2)] = null);

(statearr_22111_22248[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (52))){
var inst_21692 = (state_21965[(7)]);
var inst_21775 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21692);
var state_21965__$1 = state_21965;
var statearr_22112_22249 = state_21965__$1;
(statearr_22112_22249[(2)] = inst_21775);

(statearr_22112_22249[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (67))){
var inst_21918 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22113_22250 = state_21965__$1;
(statearr_22113_22250[(2)] = inst_21918);

(statearr_22113_22250[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (71))){
var inst_21692 = (state_21965[(7)]);
var inst_21830 = (state_21965[(2)]);
var inst_21831 = fluree.db.util.async.throw_err(inst_21830);
var inst_21832 = cljs.core._deref(cache);
var inst_21833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21834 = flake.o;
var inst_21835 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21692);
var inst_21836 = [inst_21834,inst_21835];
var inst_21837 = (new cljs.core.PersistentVector(null,2,(5),inst_21833,inst_21836,null));
var inst_21838 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21832,inst_21837,inst_21831);
var inst_21839 = cljs.core._vreset_BANG_(cache,inst_21838);
var state_21965__$1 = (function (){var statearr_22114 = state_21965;
(statearr_22114[(34)] = inst_21839);

return statearr_22114;
})();
var statearr_22115_22251 = state_21965__$1;
(statearr_22115_22251[(2)] = inst_21831);

(statearr_22115_22251[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (42))){
var inst_21703 = (state_21965[(14)]);
var inst_21728 = (state_21965[(16)]);
var inst_21727 = (state_21965[(20)]);
var inst_21757 = cljs.core.not(inst_21728);
var inst_21758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_21703);
var inst_21759 = cljs.core.count(inst_21758);
var inst_21760 = (inst_21759 >= inst_21727);
var inst_21761 = ((inst_21757) && (inst_21760));
var state_21965__$1 = state_21965;
var statearr_22116_22252 = state_21965__$1;
(statearr_22116_22252[(2)] = inst_21761);

(statearr_22116_22252[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (80))){
var inst_21874 = cljs.core.PersistentVector.EMPTY_NODE;
var state_21965__$1 = (function (){var statearr_22117 = state_21965;
(statearr_22117[(32)] = inst_21874);

return statearr_22117;
})();
if(cljs.core.truth_(fuel)){
var statearr_22118_22253 = state_21965__$1;
(statearr_22118_22253[(1)] = (83));

} else {
var statearr_22119_22254 = state_21965__$1;
(statearr_22119_22254[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (37))){
var inst_21725 = (state_21965[(19)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21725)){
var statearr_22120_22255 = state_21965__$1;
(statearr_22120_22255[(1)] = (42));

} else {
var statearr_22121_22256 = state_21965__$1;
(statearr_22121_22256[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (63))){
var inst_21801 = (state_21965[(18)]);
var state_21965__$1 = state_21965;
var statearr_22122_22257 = state_21965__$1;
(statearr_22122_22257[(2)] = inst_21801);

(statearr_22122_22257[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (94))){
var inst_21912 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
var statearr_22123_22258 = state_21965__$1;
(statearr_22123_22258[(2)] = inst_21912);

(statearr_22123_22258[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (8))){
var inst_21679 = (state_21965[(2)]);
var state_21965__$1 = state_21965;
if(cljs.core.truth_(inst_21679)){
var statearr_22124_22259 = state_21965__$1;
(statearr_22124_22259[(1)] = (9));

} else {
var statearr_22125_22260 = state_21965__$1;
(statearr_22125_22260[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (49))){
var state_21965__$1 = state_21965;
var statearr_22126_22261 = state_21965__$1;
(statearr_22126_22261[(2)] = false);

(statearr_22126_22261[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21966 === (84))){
var inst_21863 = (state_21965[(23)]);
var state_21965__$1 = state_21965;
var statearr_22127_22262 = state_21965__$1;
(statearr_22127_22262[(2)] = inst_21863);

(statearr_22127_22262[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_22128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22128[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_22128[(1)] = (1));

return statearr_22128;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_21965){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21965);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22129){var ex__2417__auto__ = e22129;
var statearr_22130_22263 = state_21965;
(statearr_22130_22263[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21965[(4)]))){
var statearr_22131_22264 = state_21965;
(statearr_22131_22264[(1)] = cljs.core.first((state_21965[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22265 = state_21965;
state_21965 = G__22265;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_21965){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_21965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22132 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22132[(6)] = c__2436__auto__);

return statearr_22132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22445){
var state_val_22446 = (state_22445[(1)]);
if((state_val_22446 === (7))){
var inst_22440 = (state_22445[(2)]);
var _ = (function (){var statearr_22447 = state_22445;
(statearr_22447[(4)] = cljs.core.rest((state_22445[(4)])));

return statearr_22447;
})();
var state_22445__$1 = state_22445;
var statearr_22448_22543 = state_22445__$1;
(statearr_22448_22543[(2)] = inst_22440);

(statearr_22448_22543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (59))){
var inst_22326 = (state_22445[(7)]);
var state_22445__$1 = state_22445;
var statearr_22449_22544 = state_22445__$1;
(statearr_22449_22544[(2)] = inst_22326);

(statearr_22449_22544[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (20))){
var inst_22335 = (state_22445[(8)]);
var inst_22332 = (state_22445[(2)]);
var inst_22333 = fluree.db.util.async.throw_err(inst_22332);
var inst_22334 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_22333);
var inst_22335__$1 = cljs.core.not_empty(inst_22334);
var state_22445__$1 = (function (){var statearr_22450 = state_22445;
(statearr_22450[(8)] = inst_22335__$1);

return statearr_22450;
})();
if(cljs.core.truth_(inst_22335__$1)){
var statearr_22451_22545 = state_22445__$1;
(statearr_22451_22545[(1)] = (21));

} else {
var statearr_22452_22546 = state_22445__$1;
(statearr_22452_22546[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (58))){
var inst_22325 = (state_22445[(9)]);
var state_22445__$1 = state_22445;
var statearr_22453_22547 = state_22445__$1;
(statearr_22453_22547[(2)] = inst_22325);

(statearr_22453_22547[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (60))){
var inst_22432 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22454_22548 = state_22445__$1;
(statearr_22454_22548[(2)] = inst_22432);

(statearr_22454_22548[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (27))){
var inst_22367 = (state_22445[(10)]);
var inst_22357 = (state_22445[(11)]);
var inst_22365 = (state_22445[(12)]);
var inst_22364 = cljs.core.seq(inst_22357);
var inst_22365__$1 = cljs.core.first(inst_22364);
var inst_22366 = cljs.core.next(inst_22364);
var inst_22367__$1 = cljs.core.not(inst_22365__$1);
var state_22445__$1 = (function (){var statearr_22455 = state_22445;
(statearr_22455[(10)] = inst_22367__$1);

(statearr_22455[(12)] = inst_22365__$1);

(statearr_22455[(13)] = inst_22366);

return statearr_22455;
})();
if(inst_22367__$1){
var statearr_22456_22549 = state_22445__$1;
(statearr_22456_22549[(1)] = (29));

} else {
var statearr_22457_22550 = state_22445__$1;
(statearr_22457_22550[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (1))){
var state_22445__$1 = state_22445;
var statearr_22458_22551 = state_22445__$1;
(statearr_22458_22551[(2)] = null);

(statearr_22458_22551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (24))){
var inst_22335 = (state_22445[(8)]);
var inst_22341 = cljs.core.count(inst_22335);
var inst_22342 = fluree.db.query.fql.add_fuel(fuel,inst_22341,max_fuel);
var state_22445__$1 = state_22445;
var statearr_22459_22552 = state_22445__$1;
(statearr_22459_22552[(2)] = inst_22342);

(statearr_22459_22552[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (55))){
var inst_22324 = (state_22445[(14)]);
var state_22445__$1 = state_22445;
var statearr_22460_22553 = state_22445__$1;
(statearr_22460_22553[(2)] = inst_22324);

(statearr_22460_22553[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (39))){
var inst_22322 = (state_22445[(15)]);
var state_22445__$1 = state_22445;
var statearr_22461_22554 = state_22445__$1;
(statearr_22461_22554[(2)] = inst_22322);

(statearr_22461_22554[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (46))){
var inst_22420 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22462_22555 = state_22445__$1;
(statearr_22462_22555[(2)] = inst_22420);

(statearr_22462_22555[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (4))){
var inst_22266 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22463_22556 = state_22445__$1;
(statearr_22463_22556[(2)] = inst_22266);

(statearr_22463_22556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (54))){
var inst_22359 = (state_22445[(16)]);
var inst_22411 = (state_22445[(2)]);
var inst_22412 = fluree.db.util.async.throw_err(inst_22411);
var inst_22413 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22359,inst_22412);
var state_22445__$1 = state_22445;
var statearr_22464_22557 = state_22445__$1;
(statearr_22464_22557[(2)] = inst_22413);

(statearr_22464_22557[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (15))){
var state_22445__$1 = state_22445;
var statearr_22465_22558 = state_22445__$1;
(statearr_22465_22558[(2)] = false);

(statearr_22465_22558[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (48))){
var inst_22359 = (state_22445[(16)]);
var state_22445__$1 = state_22445;
var statearr_22466_22559 = state_22445__$1;
(statearr_22466_22559[(2)] = inst_22359);

(statearr_22466_22559[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (50))){
var inst_22358 = (state_22445[(17)]);
var inst_22366 = (state_22445[(13)]);
var inst_22415 = (state_22445[(2)]);
var inst_22416 = (inst_22358 + (1));
var inst_22357 = inst_22366;
var inst_22358__$1 = inst_22416;
var inst_22359 = inst_22415;
var state_22445__$1 = (function (){var statearr_22467 = state_22445;
(statearr_22467[(11)] = inst_22357);

(statearr_22467[(16)] = inst_22359);

(statearr_22467[(17)] = inst_22358__$1);

return statearr_22467;
})();
var statearr_22468_22560 = state_22445__$1;
(statearr_22468_22560[(2)] = null);

(statearr_22468_22560[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (21))){
var state_22445__$1 = state_22445;
var statearr_22469_22561 = state_22445__$1;
(statearr_22469_22561[(2)] = fuel);

(statearr_22469_22561[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (31))){
var inst_22376 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22376)){
var statearr_22470_22562 = state_22445__$1;
(statearr_22470_22562[(1)] = (35));

} else {
var statearr_22471_22563 = state_22445__$1;
(statearr_22471_22563[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (32))){
var inst_22358 = (state_22445[(17)]);
var inst_22323 = (state_22445[(18)]);
var inst_22371 = (inst_22358 >= inst_22323);
var state_22445__$1 = state_22445;
var statearr_22472_22564 = state_22445__$1;
(statearr_22472_22564[(2)] = inst_22371);

(statearr_22472_22564[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (40))){
var inst_22383 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22383)){
var statearr_22473_22565 = state_22445__$1;
(statearr_22473_22565[(1)] = (41));

} else {
var statearr_22474_22566 = state_22445__$1;
(statearr_22474_22566[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (56))){
var inst_22325 = (state_22445[(9)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22325)){
var statearr_22475_22567 = state_22445__$1;
(statearr_22475_22567[(1)] = (58));

} else {
var statearr_22476_22568 = state_22445__$1;
(statearr_22476_22568[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (33))){
var inst_22323 = (state_22445[(18)]);
var state_22445__$1 = state_22445;
var statearr_22477_22569 = state_22445__$1;
(statearr_22477_22569[(2)] = inst_22323);

(statearr_22477_22569[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (13))){
var inst_22316 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22316)){
var statearr_22478_22570 = state_22445__$1;
(statearr_22478_22570[(1)] = (17));

} else {
var statearr_22479_22571 = state_22445__$1;
(statearr_22479_22571[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (22))){
var inst_22335 = (state_22445[(8)]);
var state_22445__$1 = state_22445;
var statearr_22481_22572 = state_22445__$1;
(statearr_22481_22572[(2)] = inst_22335);

(statearr_22481_22572[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (36))){
var inst_22322 = (state_22445[(15)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22322)){
var statearr_22482_22573 = state_22445__$1;
(statearr_22482_22573[(1)] = (38));

} else {
var statearr_22483_22574 = state_22445__$1;
(statearr_22483_22574[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (41))){
var inst_22359 = (state_22445[(16)]);
var inst_22358 = (state_22445[(17)]);
var inst_22366 = (state_22445[(13)]);
var inst_22385 = (inst_22358 + (1));
var tmp22480 = inst_22359;
var inst_22357 = inst_22366;
var inst_22358__$1 = inst_22385;
var inst_22359__$1 = tmp22480;
var state_22445__$1 = (function (){var statearr_22484 = state_22445;
(statearr_22484[(11)] = inst_22357);

(statearr_22484[(16)] = inst_22359__$1);

(statearr_22484[(17)] = inst_22358__$1);

return statearr_22484;
})();
var statearr_22485_22575 = state_22445__$1;
(statearr_22485_22575[(2)] = null);

(statearr_22485_22575[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (43))){
var inst_22422 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22486_22576 = state_22445__$1;
(statearr_22486_22576[(2)] = inst_22422);

(statearr_22486_22576[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (29))){
var inst_22367 = (state_22445[(10)]);
var state_22445__$1 = state_22445;
var statearr_22487_22577 = state_22445__$1;
(statearr_22487_22577[(2)] = inst_22367);

(statearr_22487_22577[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (44))){
var inst_22365 = (state_22445[(12)]);
var inst_22389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22390 = [inst_22365];
var inst_22391 = (new cljs.core.PersistentVector(null,1,(5),inst_22389,inst_22390,null));
var inst_22392 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22391);
var state_22445__$1 = state_22445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22445__$1,(47),inst_22392);
} else {
if((state_val_22446 === (6))){
var inst_22283 = (state_22445[(19)]);
var inst_22290 = (state_22445[(20)]);
var inst_22289 = cljs.core.seq(inst_22283);
var inst_22290__$1 = cljs.core.first(inst_22289);
var inst_22291 = cljs.core.next(inst_22289);
var inst_22292 = cljs.core.not(inst_22290__$1);
var state_22445__$1 = (function (){var statearr_22488 = state_22445;
(statearr_22488[(20)] = inst_22290__$1);

(statearr_22488[(21)] = inst_22291);

return statearr_22488;
})();
if(inst_22292){
var statearr_22489_22578 = state_22445__$1;
(statearr_22489_22578[(1)] = (8));

} else {
var statearr_22490_22579 = state_22445__$1;
(statearr_22490_22579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (28))){
var inst_22324 = (state_22445[(14)]);
var inst_22426 = (state_22445[(2)]);
var state_22445__$1 = (function (){var statearr_22491 = state_22445;
(statearr_22491[(22)] = inst_22426);

return statearr_22491;
})();
if(cljs.core.truth_(inst_22324)){
var statearr_22492_22580 = state_22445__$1;
(statearr_22492_22580[(1)] = (55));

} else {
var statearr_22493_22581 = state_22445__$1;
(statearr_22493_22581[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (51))){
var inst_22395 = (state_22445[(23)]);
var inst_22404 = cljs.core.count(inst_22395);
var inst_22405 = fluree.db.query.fql.add_fuel(fuel,inst_22404,max_fuel);
var state_22445__$1 = state_22445;
var statearr_22494_22582 = state_22445__$1;
(statearr_22494_22582[(2)] = inst_22405);

(statearr_22494_22582[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (25))){
var state_22445__$1 = state_22445;
var statearr_22495_22583 = state_22445__$1;
(statearr_22495_22583[(2)] = null);

(statearr_22495_22583[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (34))){
var inst_22374 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22496_22584 = state_22445__$1;
(statearr_22496_22584[(2)] = inst_22374);

(statearr_22496_22584[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (17))){
var inst_22300 = (state_22445[(24)]);
var inst_22318 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22300);
var state_22445__$1 = state_22445;
var statearr_22497_22585 = state_22445__$1;
(statearr_22497_22585[(2)] = inst_22318);

(statearr_22497_22585[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (3))){
var inst_22443 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22445__$1,inst_22443);
} else {
if((state_val_22446 === (12))){
var state_22445__$1 = state_22445;
var statearr_22498_22586 = state_22445__$1;
(statearr_22498_22586[(2)] = false);

(statearr_22498_22586[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (2))){
var _ = (function (){var statearr_22499 = state_22445;
(statearr_22499[(4)] = cljs.core.cons((5),(state_22445[(4)])));

return statearr_22499;
})();
var inst_22279 = reverse_refs_specs;
var inst_22280 = cljs.core.seq(inst_22279);
var inst_22281 = cljs.core.first(inst_22280);
var inst_22282 = cljs.core.next(inst_22280);
var inst_22283 = inst_22279;
var inst_22284 = null;
var state_22445__$1 = (function (){var statearr_22500 = state_22445;
(statearr_22500[(19)] = inst_22283);

(statearr_22500[(25)] = inst_22282);

(statearr_22500[(26)] = inst_22284);

(statearr_22500[(27)] = inst_22281);

return statearr_22500;
})();
var statearr_22501_22587 = state_22445__$1;
(statearr_22501_22587[(2)] = null);

(statearr_22501_22587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (23))){
var inst_22339 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22339)){
var statearr_22502_22588 = state_22445__$1;
(statearr_22502_22588[(1)] = (24));

} else {
var statearr_22503_22589 = state_22445__$1;
(statearr_22503_22589[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (47))){
var inst_22300 = (state_22445[(24)]);
var inst_22395 = (state_22445[(23)]);
var inst_22394 = (state_22445[(2)]);
var inst_22395__$1 = fluree.db.util.async.throw_err(inst_22394);
var inst_22396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22397 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22398 = (new cljs.core.PersistentVector(null,4,(5),inst_22396,inst_22397,null));
var inst_22399 = cljs.core.select_keys(inst_22300,inst_22398);
var inst_22400 = cljs.core.empty_QMARK_(inst_22395__$1);
var state_22445__$1 = (function (){var statearr_22504 = state_22445;
(statearr_22504[(28)] = inst_22399);

(statearr_22504[(23)] = inst_22395__$1);

return statearr_22504;
})();
if(inst_22400){
var statearr_22505_22590 = state_22445__$1;
(statearr_22505_22590[(1)] = (48));

} else {
var statearr_22506_22591 = state_22445__$1;
(statearr_22506_22591[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (35))){
var inst_22359 = (state_22445[(16)]);
var state_22445__$1 = state_22445;
var statearr_22507_22592 = state_22445__$1;
(statearr_22507_22592[(2)] = inst_22359);

(statearr_22507_22592[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (19))){
var inst_22299 = (state_22445[(29)]);
var inst_22321 = (state_22445[(2)]);
var inst_22322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22321,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22321,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22321,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22321,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22321,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22328 = [subject_id,inst_22299];
var inst_22329 = (new cljs.core.PersistentVector(null,2,(5),inst_22327,inst_22328,null));
var inst_22330 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22329);
var state_22445__$1 = (function (){var statearr_22508 = state_22445;
(statearr_22508[(15)] = inst_22322);

(statearr_22508[(7)] = inst_22326);

(statearr_22508[(14)] = inst_22324);

(statearr_22508[(9)] = inst_22325);

(statearr_22508[(18)] = inst_22323);

return statearr_22508;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22445__$1,(20),inst_22330);
} else {
if((state_val_22446 === (57))){
var inst_22284 = (state_22445[(26)]);
var inst_22291 = (state_22445[(21)]);
var inst_22426 = (state_22445[(22)]);
var inst_22434 = (state_22445[(2)]);
var inst_22435 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22284,inst_22434,inst_22426);
var inst_22283 = inst_22291;
var inst_22284__$1 = inst_22435;
var state_22445__$1 = (function (){var statearr_22509 = state_22445;
(statearr_22509[(19)] = inst_22283);

(statearr_22509[(26)] = inst_22284__$1);

return statearr_22509;
})();
var statearr_22510_22593 = state_22445__$1;
(statearr_22510_22593[(2)] = null);

(statearr_22510_22593[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (11))){
var inst_22300 = (state_22445[(24)]);
var inst_22305 = inst_22300.cljs$lang$protocol_mask$partition0$;
var inst_22306 = (inst_22305 & (64));
var inst_22307 = inst_22300.cljs$core$ISeq$;
var inst_22308 = (cljs.core.PROTOCOL_SENTINEL === inst_22307);
var inst_22309 = ((inst_22306) || (inst_22308));
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22309)){
var statearr_22512_22594 = state_22445__$1;
(statearr_22512_22594[(1)] = (14));

} else {
var statearr_22513_22595 = state_22445__$1;
(statearr_22513_22595[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (9))){
var inst_22300 = (state_22445[(24)]);
var inst_22290 = (state_22445[(20)]);
var inst_22299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22290,(0),null);
var inst_22300__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22290,(1),null);
var inst_22302 = (inst_22300__$1 == null);
var inst_22303 = cljs.core.not(inst_22302);
var state_22445__$1 = (function (){var statearr_22514 = state_22445;
(statearr_22514[(24)] = inst_22300__$1);

(statearr_22514[(29)] = inst_22299);

return statearr_22514;
})();
if(inst_22303){
var statearr_22515_22596 = state_22445__$1;
(statearr_22515_22596[(1)] = (11));

} else {
var statearr_22516_22597 = state_22445__$1;
(statearr_22516_22597[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (5))){
var _ = (function (){var statearr_22517 = state_22445;
(statearr_22517[(4)] = cljs.core.rest((state_22445[(4)])));

return statearr_22517;
})();
var state_22445__$1 = state_22445;
var ex22511 = (state_22445__$1[(2)]);
var statearr_22518_22598 = state_22445__$1;
(statearr_22518_22598[(5)] = ex22511);


if((ex22511 instanceof Error)){
var statearr_22519_22599 = state_22445__$1;
(statearr_22519_22599[(1)] = (4));

(statearr_22519_22599[(5)] = null);

} else {
throw ex22511;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (14))){
var state_22445__$1 = state_22445;
var statearr_22520_22600 = state_22445__$1;
(statearr_22520_22600[(2)] = true);

(statearr_22520_22600[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (45))){
var state_22445__$1 = state_22445;
var statearr_22521_22601 = state_22445__$1;
(statearr_22521_22601[(2)] = null);

(statearr_22521_22601[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (53))){
var inst_22399 = (state_22445[(28)]);
var inst_22395 = (state_22445[(23)]);
var inst_22408 = (state_22445[(2)]);
var inst_22409 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22399,inst_22395) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22399,inst_22395));
var state_22445__$1 = (function (){var statearr_22522 = state_22445;
(statearr_22522[(30)] = inst_22408);

return statearr_22522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22445__$1,(54),inst_22409);
} else {
if((state_val_22446 === (26))){
var inst_22335 = (state_22445[(8)]);
var inst_22345 = (state_22445[(2)]);
var inst_22353 = cljs.core.seq(inst_22335);
var inst_22354 = cljs.core.first(inst_22353);
var inst_22355 = cljs.core.next(inst_22353);
var inst_22356 = cljs.core.PersistentVector.EMPTY;
var inst_22357 = inst_22335;
var inst_22358 = (0);
var inst_22359 = inst_22356;
var state_22445__$1 = (function (){var statearr_22523 = state_22445;
(statearr_22523[(11)] = inst_22357);

(statearr_22523[(31)] = inst_22345);

(statearr_22523[(32)] = inst_22355);

(statearr_22523[(16)] = inst_22359);

(statearr_22523[(33)] = inst_22354);

(statearr_22523[(17)] = inst_22358);

return statearr_22523;
})();
var statearr_22524_22602 = state_22445__$1;
(statearr_22524_22602[(2)] = null);

(statearr_22524_22602[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (16))){
var inst_22313 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22525_22603 = state_22445__$1;
(statearr_22525_22603[(2)] = inst_22313);

(statearr_22525_22603[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (38))){
var inst_22322 = (state_22445[(15)]);
var inst_22358 = (state_22445[(17)]);
var inst_22380 = (inst_22358 < inst_22322);
var state_22445__$1 = state_22445;
var statearr_22526_22604 = state_22445__$1;
(statearr_22526_22604[(2)] = inst_22380);

(statearr_22526_22604[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (30))){
var inst_22323 = (state_22445[(18)]);
var state_22445__$1 = state_22445;
if(cljs.core.truth_(inst_22323)){
var statearr_22527_22605 = state_22445__$1;
(statearr_22527_22605[(1)] = (32));

} else {
var statearr_22528_22606 = state_22445__$1;
(statearr_22528_22606[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (10))){
var inst_22438 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22529_22607 = state_22445__$1;
(statearr_22529_22607[(2)] = inst_22438);

(statearr_22529_22607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (18))){
var inst_22300 = (state_22445[(24)]);
var state_22445__$1 = state_22445;
var statearr_22530_22608 = state_22445__$1;
(statearr_22530_22608[(2)] = inst_22300);

(statearr_22530_22608[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (52))){
var state_22445__$1 = state_22445;
var statearr_22531_22609 = state_22445__$1;
(statearr_22531_22609[(2)] = null);

(statearr_22531_22609[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (42))){
var state_22445__$1 = state_22445;
var statearr_22532_22610 = state_22445__$1;
(statearr_22532_22610[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (37))){
var inst_22424 = (state_22445[(2)]);
var state_22445__$1 = state_22445;
var statearr_22534_22611 = state_22445__$1;
(statearr_22534_22611[(2)] = inst_22424);

(statearr_22534_22611[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (8))){
var inst_22284 = (state_22445[(26)]);
var state_22445__$1 = state_22445;
var statearr_22535_22612 = state_22445__$1;
(statearr_22535_22612[(2)] = inst_22284);

(statearr_22535_22612[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22446 === (49))){
var state_22445__$1 = state_22445;
if(cljs.core.truth_(fuel)){
var statearr_22536_22613 = state_22445__$1;
(statearr_22536_22613[(1)] = (51));

} else {
var statearr_22537_22614 = state_22445__$1;
(statearr_22537_22614[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0 = (function (){
var statearr_22538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22538[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__);

(statearr_22538[(1)] = (1));

return statearr_22538;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1 = (function (state_22445){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22445);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22539){var ex__2417__auto__ = e22539;
var statearr_22540_22615 = state_22445;
(statearr_22540_22615[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22445[(4)]))){
var statearr_22541_22616 = state_22445;
(statearr_22541_22616[(1)] = cljs.core.first((state_22445[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22617 = state_22445;
state_22445 = G__22617;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__ = function(state_22445){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1.call(this,state_22445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22542 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22542[(6)] = c__2436__auto__);

return statearr_22542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null),cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o(f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"depth","depth",1768663640)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22736){
var state_val_22737 = (state_22736[(1)]);
if((state_val_22737 === (7))){
var inst_22731 = (state_22736[(2)]);
var _ = (function (){var statearr_22738 = state_22736;
(statearr_22738[(4)] = cljs.core.rest((state_22736[(4)])));

return statearr_22738;
})();
var state_22736__$1 = state_22736;
var statearr_22739_22794 = state_22736__$1;
(statearr_22739_22794[(2)] = inst_22731);

(statearr_22739_22794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (20))){
var inst_22673 = (state_22736[(7)]);
var state_22736__$1 = state_22736;
var statearr_22740_22795 = state_22736__$1;
(statearr_22740_22795[(2)] = inst_22673);

(statearr_22740_22795[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (27))){
var inst_22638 = (state_22736[(8)]);
var inst_22694 = (state_22736[(9)]);
var inst_22713 = (state_22736[(2)]);
var inst_22714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22713,(0),null);
var inst_22715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22713,(1),null);
var inst_22716 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22638);
var inst_22717 = fluree.db.query.fql.s(f);
var inst_22718 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22716,inst_22717);
var inst_22719 = cljs.core.empty_QMARK_(inst_22694);
var inst_22720 = ((inst_22718) || (inst_22719));
var state_22736__$1 = (function (){var statearr_22741 = state_22736;
(statearr_22741[(10)] = inst_22714);

(statearr_22741[(11)] = inst_22715);

return statearr_22741;
})();
if(cljs.core.truth_(inst_22720)){
var statearr_22742_22796 = state_22736__$1;
(statearr_22742_22796[(1)] = (30));

} else {
var statearr_22743_22797 = state_22736__$1;
(statearr_22743_22797[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (1))){
var state_22736__$1 = state_22736;
var statearr_22744_22798 = state_22736__$1;
(statearr_22744_22798[(2)] = null);

(statearr_22744_22798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (24))){
var inst_22638 = (state_22736[(8)]);
var inst_22694 = (state_22736[(9)]);
var inst_22694__$1 = (state_22736[(2)]);
var inst_22695 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22638,inst_22694__$1);
var inst_22699 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22638);
var inst_22700 = fluree.db.query.fql.s(f);
var inst_22701 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22699,inst_22700);
var state_22736__$1 = (function (){var statearr_22745 = state_22736;
(statearr_22745[(12)] = inst_22695);

(statearr_22745[(9)] = inst_22694__$1);

return statearr_22745;
})();
if(inst_22701){
var statearr_22746_22799 = state_22736__$1;
(statearr_22746_22799[(1)] = (25));

} else {
var statearr_22747_22800 = state_22736__$1;
(statearr_22747_22800[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (4))){
var inst_22619 = (state_22736[(2)]);
var state_22736__$1 = state_22736;
var statearr_22748_22801 = state_22736__$1;
(statearr_22748_22801[(2)] = inst_22619);

(statearr_22748_22801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (15))){
var inst_22656 = (state_22736[(13)]);
var state_22736__$1 = state_22736;
var statearr_22749_22802 = state_22736__$1;
(statearr_22749_22802[(2)] = inst_22656);

(statearr_22749_22802[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (21))){
var inst_22682 = (state_22736[(2)]);
var state_22736__$1 = state_22736;
var statearr_22750_22803 = state_22736__$1;
(statearr_22750_22803[(2)] = inst_22682);

(statearr_22750_22803[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (31))){
var inst_22638 = (state_22736[(8)]);
var inst_22714 = (state_22736[(10)]);
var inst_22694 = (state_22736[(9)]);
var inst_22723 = cljs.core.assoc_in(inst_22638,inst_22694,inst_22714);
var state_22736__$1 = state_22736;
var statearr_22751_22804 = state_22736__$1;
(statearr_22751_22804[(2)] = inst_22723);

(statearr_22751_22804[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (32))){
var inst_22638 = (state_22736[(8)]);
var inst_22645 = (state_22736[(14)]);
var inst_22725 = (state_22736[(2)]);
var inst_22726 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22638,inst_22725);
var inst_22637 = inst_22645;
var inst_22638__$1 = inst_22726;
var state_22736__$1 = (function (){var statearr_22752 = state_22736;
(statearr_22752[(8)] = inst_22638__$1);

(statearr_22752[(15)] = inst_22637);

return statearr_22752;
})();
var statearr_22753_22805 = state_22736__$1;
(statearr_22753_22805[(2)] = null);

(statearr_22753_22805[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (13))){
var inst_22638 = (state_22736[(8)]);
var inst_22653 = (state_22736[(16)]);
var inst_22653__$1 = (state_22736[(2)]);
var inst_22654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22655 = [k];
var inst_22656 = (new cljs.core.PersistentVector(null,1,(5),inst_22654,inst_22655,null));
var inst_22657 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22638);
var inst_22658 = fluree.db.query.fql.s(f);
var inst_22659 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_22657,inst_22658);
var inst_22660 = cljs.core.empty_QMARK_(inst_22653__$1);
var inst_22661 = (!(inst_22660));
var inst_22662 = ((inst_22659) && (inst_22661));
var state_22736__$1 = (function (){var statearr_22754 = state_22736;
(statearr_22754[(13)] = inst_22656);

(statearr_22754[(16)] = inst_22653__$1);

return statearr_22754;
})();
if(cljs.core.truth_(inst_22662)){
var statearr_22755_22806 = state_22736__$1;
(statearr_22755_22806[(1)] = (14));

} else {
var statearr_22756_22807 = state_22736__$1;
(statearr_22756_22807[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (22))){
var inst_22687 = (state_22736[(17)]);
var inst_22691 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_22687);
var state_22736__$1 = state_22736;
var statearr_22757_22808 = state_22736__$1;
(statearr_22757_22808[(2)] = inst_22691);

(statearr_22757_22808[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (29))){
var inst_22710 = (state_22736[(2)]);
var inst_22711 = fluree.db.util.async.throw_err(inst_22710);
var state_22736__$1 = state_22736;
var statearr_22758_22809 = state_22736__$1;
(statearr_22758_22809[(2)] = inst_22711);

(statearr_22758_22809[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (6))){
var inst_22637 = (state_22736[(15)]);
var inst_22644 = (state_22736[(18)]);
var inst_22643 = cljs.core.seq(inst_22637);
var inst_22644__$1 = cljs.core.first(inst_22643);
var inst_22645 = cljs.core.next(inst_22643);
var inst_22646 = cljs.core.not(inst_22644__$1);
var state_22736__$1 = (function (){var statearr_22759 = state_22736;
(statearr_22759[(18)] = inst_22644__$1);

(statearr_22759[(14)] = inst_22645);

return statearr_22759;
})();
if(inst_22646){
var statearr_22760_22810 = state_22736__$1;
(statearr_22760_22810[(1)] = (8));

} else {
var statearr_22761_22811 = state_22736__$1;
(statearr_22761_22811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (28))){
var inst_22705 = (state_22736[(2)]);
var inst_22706 = fluree.db.util.async.throw_err(inst_22705);
var state_22736__$1 = state_22736;
var statearr_22762_22812 = state_22736__$1;
(statearr_22762_22812[(2)] = inst_22706);

(statearr_22762_22812[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (25))){
var inst_22638 = (state_22736[(8)]);
var inst_22703 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_22638,pred_spec,f,component_follow_QMARK_,true);
var state_22736__$1 = state_22736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22736__$1,(28),inst_22703);
} else {
if((state_val_22737 === (17))){
var inst_22634 = (state_22736[(19)]);
var inst_22638 = (state_22736[(8)]);
var inst_22637 = (state_22736[(15)]);
var inst_22635 = (state_22736[(20)]);
var inst_22632 = (state_22736[(21)]);
var inst_22664 = (state_22736[(22)]);
var inst_22665 = (state_22736[(23)]);
var inst_22644 = (state_22736[(18)]);
var inst_22645 = (state_22736[(14)]);
var inst_22667 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22638,inst_22665);
var inst_22668 = (function (){var keys_SINGLEQUOTE_ = inst_22665;
var r = inst_22645;
var vec__22640 = inst_22637;
var G__22628 = inst_22637;
var child_path = inst_22664;
var vec__22629 = inst_22632;
var acc__$1 = inst_22638;
var seq__22641 = inst_22645;
var value = inst_22667;
var seq__22630 = inst_22635;
var first__22642 = inst_22644;
var first__22631 = inst_22634;
return (function (p1__22618_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(p1__22618_SHARP_),cljs.core.first(child_path));
});
})();
var inst_22669 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_22668,inst_22667);
var inst_22670 = cljs.core.first(inst_22669);
var inst_22671 = inst_22667.indexOf(inst_22670);
var inst_22672 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22665,inst_22671);
var inst_22673 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22672,k);
var inst_22674 = cljs.core.rest(inst_22664);
var inst_22675 = cljs.core.count(inst_22674);
var inst_22676 = (inst_22675 > (0));
var state_22736__$1 = (function (){var statearr_22763 = state_22736;
(statearr_22763[(7)] = inst_22673);

return statearr_22763;
})();
if(cljs.core.truth_(inst_22676)){
var statearr_22764_22813 = state_22736__$1;
(statearr_22764_22813[(1)] = (19));

} else {
var statearr_22765_22814 = state_22736__$1;
(statearr_22765_22814[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (3))){
var inst_22734 = (state_22736[(2)]);
var state_22736__$1 = state_22736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22736__$1,inst_22734);
} else {
if((state_val_22737 === (12))){
var inst_22644 = (state_22736[(18)]);
var inst_22651 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_22644);
var state_22736__$1 = state_22736;
var statearr_22766_22815 = state_22736__$1;
(statearr_22766_22815[(2)] = inst_22651);

(statearr_22766_22815[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (2))){
var inst_22632 = (state_22736[(21)]);
var _ = (function (){var statearr_22767 = state_22736;
(statearr_22767[(4)] = cljs.core.cons((5),(state_22736[(4)])));

return statearr_22767;
})();
var inst_22632__$1 = new_child_paths;
var inst_22633 = cljs.core.seq(inst_22632__$1);
var inst_22634 = cljs.core.first(inst_22633);
var inst_22635 = cljs.core.next(inst_22633);
var inst_22636 = acc;
var inst_22637 = inst_22632__$1;
var inst_22638 = inst_22636;
var state_22736__$1 = (function (){var statearr_22768 = state_22736;
(statearr_22768[(19)] = inst_22634);

(statearr_22768[(8)] = inst_22638);

(statearr_22768[(15)] = inst_22637);

(statearr_22768[(20)] = inst_22635);

(statearr_22768[(21)] = inst_22632__$1);

return statearr_22768;
})();
var statearr_22769_22816 = state_22736__$1;
(statearr_22769_22816[(2)] = null);

(statearr_22769_22816[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (23))){
var inst_22687 = (state_22736[(17)]);
var state_22736__$1 = state_22736;
var statearr_22770_22817 = state_22736__$1;
(statearr_22770_22817[(2)] = inst_22687);

(statearr_22770_22817[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (19))){
var inst_22673 = (state_22736[(7)]);
var inst_22664 = (state_22736[(22)]);
var inst_22678 = cljs.core.rest(inst_22664);
var inst_22664__$1 = inst_22678;
var inst_22665 = inst_22673;
var state_22736__$1 = (function (){var statearr_22771 = state_22736;
(statearr_22771[(22)] = inst_22664__$1);

(statearr_22771[(23)] = inst_22665);

return statearr_22771;
})();
var statearr_22772_22818 = state_22736__$1;
(statearr_22772_22818[(2)] = null);

(statearr_22772_22818[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (11))){
var inst_22644 = (state_22736[(18)]);
var state_22736__$1 = state_22736;
var statearr_22774_22819 = state_22736__$1;
(statearr_22774_22819[(2)] = inst_22644);

(statearr_22774_22819[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (9))){
var state_22736__$1 = state_22736;
if(cljs.core.truth_(parent_exists)){
var statearr_22775_22820 = state_22736__$1;
(statearr_22775_22820[(1)] = (11));

} else {
var statearr_22776_22821 = state_22736__$1;
(statearr_22776_22821[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (5))){
var _ = (function (){var statearr_22777 = state_22736;
(statearr_22777[(4)] = cljs.core.rest((state_22736[(4)])));

return statearr_22777;
})();
var state_22736__$1 = state_22736;
var ex22773 = (state_22736__$1[(2)]);
var statearr_22778_22822 = state_22736__$1;
(statearr_22778_22822[(5)] = ex22773);


if((ex22773 instanceof Error)){
var statearr_22779_22823 = state_22736__$1;
(statearr_22779_22823[(1)] = (4));

(statearr_22779_22823[(5)] = null);

} else {
throw ex22773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (14))){
var inst_22656 = (state_22736[(13)]);
var inst_22653 = (state_22736[(16)]);
var inst_22664 = inst_22653;
var inst_22665 = inst_22656;
var state_22736__$1 = (function (){var statearr_22780 = state_22736;
(statearr_22780[(22)] = inst_22664);

(statearr_22780[(23)] = inst_22665);

return statearr_22780;
})();
var statearr_22781_22824 = state_22736__$1;
(statearr_22781_22824[(2)] = null);

(statearr_22781_22824[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (26))){
var inst_22695 = (state_22736[(12)]);
var inst_22708 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_22695,pred_spec,f,component_follow_QMARK_,true);
var state_22736__$1 = state_22736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22736__$1,(29),inst_22708);
} else {
if((state_val_22737 === (16))){
var inst_22687 = (state_22736[(17)]);
var inst_22687__$1 = (state_22736[(2)]);
var inst_22688 = cljs.core.count(inst_22687__$1);
var inst_22689 = (inst_22688 > (1));
var state_22736__$1 = (function (){var statearr_22782 = state_22736;
(statearr_22782[(17)] = inst_22687__$1);

return statearr_22782;
})();
if(cljs.core.truth_(inst_22689)){
var statearr_22783_22825 = state_22736__$1;
(statearr_22783_22825[(1)] = (22));

} else {
var statearr_22784_22826 = state_22736__$1;
(statearr_22784_22826[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (30))){
var inst_22714 = (state_22736[(10)]);
var state_22736__$1 = state_22736;
var statearr_22785_22827 = state_22736__$1;
(statearr_22785_22827[(2)] = inst_22714);

(statearr_22785_22827[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (10))){
var inst_22729 = (state_22736[(2)]);
var state_22736__$1 = state_22736;
var statearr_22786_22828 = state_22736__$1;
(statearr_22786_22828[(2)] = inst_22729);

(statearr_22786_22828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (18))){
var inst_22684 = (state_22736[(2)]);
var state_22736__$1 = state_22736;
var statearr_22787_22829 = state_22736__$1;
(statearr_22787_22829[(2)] = inst_22684);

(statearr_22787_22829[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22737 === (8))){
var inst_22638 = (state_22736[(8)]);
var state_22736__$1 = state_22736;
var statearr_22788_22830 = state_22736__$1;
(statearr_22788_22830[(2)] = inst_22638);

(statearr_22788_22830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____0 = (function (){
var statearr_22789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22789[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__);

(statearr_22789[(1)] = (1));

return statearr_22789;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____1 = (function (state_22736){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22736);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22790){var ex__2417__auto__ = e22790;
var statearr_22791_22831 = state_22736;
(statearr_22791_22831[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22736[(4)]))){
var statearr_22792_22832 = state_22736;
(statearr_22792_22832[(1)] = cljs.core.first((state_22736[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22833 = state_22736;
state_22736 = G__22833;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__ = function(state_22736){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____1.call(this,state_22736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22793 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22793[(6)] = c__2436__auto__);

return statearr_22793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22946){
var state_val_22947 = (state_22946[(1)]);
if((state_val_22947 === (7))){
var inst_22849 = (state_22946[(7)]);
var inst_22849__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22946__$1 = (function (){var statearr_22948 = state_22946;
(statearr_22948[(7)] = inst_22849__$1);

return statearr_22948;
})();
if(cljs.core.truth_(inst_22849__$1)){
var statearr_22949_23015 = state_22946__$1;
(statearr_22949_23015[(1)] = (9));

} else {
var statearr_22950_23016 = state_22946__$1;
(statearr_22950_23016[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (20))){
var inst_22866 = (state_22946[(8)]);
var inst_22856 = (state_22946[(9)]);
var inst_22844 = (state_22946[(10)]);
var inst_22898 = (state_22946[(2)]);
var inst_22899 = fluree.db.query.fql.add_in_multi_flakes(inst_22844,inst_22866,inst_22856,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_22946__$1 = (function (){var statearr_22951 = state_22946;
(statearr_22951[(11)] = inst_22898);

return statearr_22951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22946__$1,(25),inst_22899);
} else {
if((state_val_22947 === (27))){
var inst_22868 = (state_22946[(12)]);
var inst_22905 = cljs.core.not(inst_22868);
var state_22946__$1 = state_22946;
var statearr_22952_23017 = state_22946__$1;
(statearr_22952_23017[(2)] = inst_22905);

(statearr_22952_23017[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (1))){
var state_22946__$1 = state_22946;
var statearr_22953_23018 = state_22946__$1;
(statearr_22953_23018[(2)] = null);

(statearr_22953_23018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (24))){
var inst_22892 = (state_22946[(2)]);
var inst_22893 = fluree.db.util.async.throw_err(inst_22892);
var state_22946__$1 = state_22946;
var statearr_22954_23019 = state_22946__$1;
(statearr_22954_23019[(2)] = inst_22893);

(statearr_22954_23019[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (39))){
var inst_22924 = (state_22946[(13)]);
var inst_22926 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_22927 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22926,inst_22924);
var state_22946__$1 = state_22946;
var statearr_22955_23020 = state_22946__$1;
(statearr_22955_23020[(2)] = inst_22927);

(statearr_22955_23020[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (4))){
var inst_22834 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22956_23021 = state_22946__$1;
(statearr_22956_23021[(2)] = inst_22834);

(statearr_22956_23021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (15))){
var inst_22874 = (state_22946[(14)]);
var state_22946__$1 = state_22946;
var statearr_22957_23022 = state_22946__$1;
(statearr_22957_23022[(2)] = inst_22874);

(statearr_22957_23022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (21))){
var inst_22887 = (state_22946[(15)]);
var inst_22889 = f.o;
var inst_22890 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_22889,inst_22887);
var state_22946__$1 = state_22946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22946__$1,(24),inst_22890);
} else {
if((state_val_22947 === (31))){
var inst_22902 = (state_22946[(16)]);
var inst_22867 = (state_22946[(17)]);
var inst_22938 = (state_22946[(2)]);
var inst_22939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22940 = [inst_22902,inst_22938,inst_22867];
var inst_22941 = (new cljs.core.PersistentVector(null,3,(5),inst_22939,inst_22940,null));
var _ = (function (){var statearr_22958 = state_22946;
(statearr_22958[(4)] = cljs.core.rest((state_22946[(4)])));

return statearr_22958;
})();
var state_22946__$1 = state_22946;
var statearr_22959_23023 = state_22946__$1;
(statearr_22959_23023[(2)] = inst_22941);

(statearr_22959_23023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (32))){
var inst_22898 = (state_22946[(11)]);
var inst_22912 = cljs.core.rest(flakes);
var inst_22913 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_22912,inst_22898);
var state_22946__$1 = state_22946;
var statearr_22960_23024 = state_22946__$1;
(statearr_22960_23024[(2)] = inst_22913);

(statearr_22960_23024[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (40))){
var inst_22924 = (state_22946[(13)]);
var state_22946__$1 = state_22946;
var statearr_22961_23025 = state_22946__$1;
(statearr_22961_23025[(2)] = inst_22924);

(statearr_22961_23025[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (33))){
var state_22946__$1 = state_22946;
var statearr_22962_23026 = state_22946__$1;
(statearr_22962_23026[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (13))){
var state_22946__$1 = state_22946;
var statearr_22964_23027 = state_22946__$1;
(statearr_22964_23027[(2)] = false);

(statearr_22964_23027[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (22))){
var state_22946__$1 = state_22946;
var statearr_22965_23028 = state_22946__$1;
(statearr_22965_23028[(2)] = null);

(statearr_22965_23028[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (36))){
var state_22946__$1 = state_22946;
var statearr_22966_23029 = state_22946__$1;
(statearr_22966_23029[(2)] = null);

(statearr_22966_23029[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (41))){
var inst_22916 = (state_22946[(18)]);
var inst_22930 = (state_22946[(2)]);
var inst_22931 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_22916,inst_22930);
var state_22946__$1 = state_22946;
var statearr_22967_23030 = state_22946__$1;
(statearr_22967_23030[(2)] = inst_22931);

(statearr_22967_23030[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (29))){
var inst_22909 = cljs.core.rest(flakes);
var state_22946__$1 = state_22946;
var statearr_22968_23031 = state_22946__$1;
(statearr_22968_23031[(2)] = inst_22909);

(statearr_22968_23031[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (6))){
var inst_22846 = (state_22946[(19)]);
var state_22946__$1 = state_22946;
var statearr_22969_23032 = state_22946__$1;
(statearr_22969_23032[(2)] = inst_22846);

(statearr_22969_23032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (28))){
var inst_22907 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
if(cljs.core.truth_(inst_22907)){
var statearr_22970_23033 = state_22946__$1;
(statearr_22970_23033[(1)] = (29));

} else {
var statearr_22971_23034 = state_22946__$1;
(statearr_22971_23034[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (25))){
var inst_22874 = (state_22946[(14)]);
var inst_22901 = (state_22946[(2)]);
var inst_22902 = fluree.db.util.async.throw_err(inst_22901);
var state_22946__$1 = (function (){var statearr_22972 = state_22946;
(statearr_22972[(16)] = inst_22902);

return statearr_22972;
})();
if(cljs.core.truth_(inst_22874)){
var statearr_22973_23035 = state_22946__$1;
(statearr_22973_23035[(1)] = (26));

} else {
var statearr_22974_23036 = state_22946__$1;
(statearr_22974_23036[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (34))){
var inst_22936 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22975_23037 = state_22946__$1;
(statearr_22975_23037[(2)] = inst_22936);

(statearr_22975_23037[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (17))){
var inst_22879 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
if(cljs.core.truth_(inst_22879)){
var statearr_22976_23038 = state_22946__$1;
(statearr_22976_23038[(1)] = (18));

} else {
var statearr_22977_23039 = state_22946__$1;
(statearr_22977_23039[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (3))){
var inst_22944 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22946__$1,inst_22944);
} else {
if((state_val_22947 === (12))){
var inst_22860 = (state_22946[(20)]);
var state_22946__$1 = state_22946;
var statearr_22978_23040 = state_22946__$1;
(statearr_22978_23040[(2)] = inst_22860);

(statearr_22978_23040[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (2))){
var inst_22846 = (state_22946[(19)]);
var _ = (function (){var statearr_22979 = state_22946;
(statearr_22979[(4)] = cljs.core.cons((5),(state_22946[(4)])));

return statearr_22979;
})();
var inst_22843 = fluree.db.query.fql.s(f);
var inst_22844 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22843);
var inst_22845 = fluree.db.query.fql.o(f);
var inst_22846__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22946__$1 = (function (){var statearr_22980 = state_22946;
(statearr_22980[(19)] = inst_22846__$1);

(statearr_22980[(21)] = inst_22845);

(statearr_22980[(10)] = inst_22844);

return statearr_22980;
})();
if(cljs.core.truth_(inst_22846__$1)){
var statearr_22981_23041 = state_22946__$1;
(statearr_22981_23041[(1)] = (6));

} else {
var statearr_22982_23042 = state_22946__$1;
(statearr_22982_23042[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (23))){
var inst_22896 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22983_23043 = state_22946__$1;
(statearr_22983_23043[(2)] = inst_22896);

(statearr_22983_23043[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (35))){
var inst_22845 = (state_22946[(21)]);
var inst_22916 = cljs.core.rest(flakes);
var inst_22918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22919 = [inst_22845];
var inst_22920 = (new cljs.core.PersistentVector(null,1,(5),inst_22918,inst_22919,null));
var inst_22921 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22920);
var state_22946__$1 = (function (){var statearr_22984 = state_22946;
(statearr_22984[(18)] = inst_22916);

return statearr_22984;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22946__$1,(38),inst_22921);
} else {
if((state_val_22947 === (19))){
var inst_22867 = (state_22946[(17)]);
var inst_22887 = (state_22946[(15)]);
var inst_22882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22883 = f.p;
var inst_22884 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_22883];
var inst_22885 = (new cljs.core.PersistentVector(null,2,(5),inst_22882,inst_22884,null));
var inst_22886 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22867,inst_22885);
var inst_22887__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_22886);
var state_22946__$1 = (function (){var statearr_22985 = state_22946;
(statearr_22985[(15)] = inst_22887__$1);

return statearr_22985;
})();
if(cljs.core.truth_(inst_22887__$1)){
var statearr_22986_23044 = state_22946__$1;
(statearr_22986_23044[(1)] = (21));

} else {
var statearr_22987_23045 = state_22946__$1;
(statearr_22987_23045[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (11))){
var inst_22854 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22989_23046 = state_22946__$1;
(statearr_22989_23046[(2)] = inst_22854);

(statearr_22989_23046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (9))){
var inst_22849 = (state_22946[(7)]);
var state_22946__$1 = state_22946;
var statearr_22990_23047 = state_22946__$1;
(statearr_22990_23047[(2)] = inst_22849);

(statearr_22990_23047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (5))){
var _ = (function (){var statearr_22991 = state_22946;
(statearr_22991[(4)] = cljs.core.rest((state_22946[(4)])));

return statearr_22991;
})();
var state_22946__$1 = state_22946;
var ex22988 = (state_22946__$1[(2)]);
var statearr_22992_23048 = state_22946__$1;
(statearr_22992_23048[(5)] = ex22988);


if((ex22988 instanceof Error)){
var statearr_22993_23049 = state_22946__$1;
(statearr_22993_23049[(1)] = (4));

(statearr_22993_23049[(5)] = null);

} else {
throw ex22988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (14))){
var inst_22874 = (state_22946[(14)]);
var inst_22856 = (state_22946[(9)]);
var inst_22867 = (state_22946[(17)]);
var inst_22864 = (state_22946[(2)]);
var inst_22865 = fluree.db.query.fql.get_recursion_map_multi(recursion_map,inst_22856,f,select_spec,inst_22864);
var inst_22866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22865,(0),null);
var inst_22867__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22865,(1),null);
var inst_22868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22865,(2),null);
var inst_22869 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22871 = [inst_22856,new cljs.core.Keyword(null,"depth","depth",1768663640)];
var inst_22872 = (new cljs.core.PersistentVector(null,2,(5),inst_22870,inst_22871,null));
var inst_22873 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22867__$1,inst_22872);
var inst_22874__$1 = (inst_22869 < inst_22873);
var state_22946__$1 = (function (){var statearr_22994 = state_22946;
(statearr_22994[(8)] = inst_22866);

(statearr_22994[(14)] = inst_22874__$1);

(statearr_22994[(12)] = inst_22868);

(statearr_22994[(17)] = inst_22867__$1);

return statearr_22994;
})();
if(cljs.core.truth_(inst_22874__$1)){
var statearr_22995_23050 = state_22946__$1;
(statearr_22995_23050[(1)] = (15));

} else {
var statearr_22996_23051 = state_22946__$1;
(statearr_22996_23051[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (26))){
var inst_22874 = (state_22946[(14)]);
var state_22946__$1 = state_22946;
var statearr_22997_23052 = state_22946__$1;
(statearr_22997_23052[(2)] = inst_22874);

(statearr_22997_23052[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (16))){
var inst_22868 = (state_22946[(12)]);
var inst_22877 = cljs.core.not(inst_22868);
var state_22946__$1 = state_22946;
var statearr_22998_23053 = state_22946__$1;
(statearr_22998_23053[(2)] = inst_22877);

(statearr_22998_23053[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (38))){
var inst_22923 = (state_22946[(2)]);
var inst_22924 = fluree.db.util.async.throw_err(inst_22923);
var state_22946__$1 = (function (){var statearr_22999 = state_22946;
(statearr_22999[(13)] = inst_22924);

return statearr_22999;
})();
if(cljs.core.truth_(fuel)){
var statearr_23000_23054 = state_22946__$1;
(statearr_23000_23054[(1)] = (39));

} else {
var statearr_23001_23055 = state_22946__$1;
(statearr_23001_23055[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (30))){
var inst_22898 = (state_22946[(11)]);
var state_22946__$1 = state_22946;
if(cljs.core.truth_(inst_22898)){
var statearr_23002_23056 = state_22946__$1;
(statearr_23002_23056[(1)] = (32));

} else {
var statearr_23003_23057 = state_22946__$1;
(statearr_23003_23057[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (10))){
var inst_22852 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22946__$1 = state_22946;
var statearr_23004_23058 = state_22946__$1;
(statearr_23004_23058[(2)] = inst_22852);

(statearr_23004_23058[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (18))){
var state_22946__$1 = state_22946;
var statearr_23005_23059 = state_22946__$1;
(statearr_23005_23059[(2)] = null);

(statearr_23005_23059[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (37))){
var inst_22934 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_23006_23060 = state_22946__$1;
(statearr_23006_23060[(2)] = inst_22934);

(statearr_23006_23060[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (8))){
var inst_22856 = (state_22946[(9)]);
var inst_22845 = (state_22946[(21)]);
var inst_22860 = (state_22946[(20)]);
var inst_22856__$1 = (state_22946[(2)]);
var inst_22857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22858 = [inst_22856__$1,inst_22845];
var inst_22859 = (new cljs.core.PersistentVector(null,2,(5),inst_22857,inst_22858,null));
var inst_22860__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_22859);
var state_22946__$1 = (function (){var statearr_23007 = state_22946;
(statearr_23007[(9)] = inst_22856__$1);

(statearr_23007[(20)] = inst_22860__$1);

return statearr_23007;
})();
if(cljs.core.truth_(inst_22860__$1)){
var statearr_23008_23061 = state_22946__$1;
(statearr_23008_23061[(1)] = (12));

} else {
var statearr_23009_23062 = state_22946__$1;
(statearr_23009_23062[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____0 = (function (){
var statearr_23010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23010[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__);

(statearr_23010[(1)] = (1));

return statearr_23010;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____1 = (function (state_22946){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22946);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23011){var ex__2417__auto__ = e23011;
var statearr_23012_23063 = state_22946;
(statearr_23012_23063[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22946[(4)]))){
var statearr_23013_23064 = state_22946;
(statearr_23013_23064[(1)] = cljs.core.first((state_22946[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23065 = state_22946;
state_22946 = G__23065;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__ = function(state_22946){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____1.call(this,state_22946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23014 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23014[(6)] = c__2436__auto__);

return statearr_23014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_(select_spec__$1))?fluree.db.query.fql.full_select_spec(db,cache,select_spec__$1,fluree.db.query.fql.s(f)):select_spec__$1);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s(f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23228){
var state_val_23229 = (state_23228[(1)]);
if((state_val_23229 === (7))){
var inst_23077 = (state_23228[(7)]);
var inst_23077__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23228__$1 = (function (){var statearr_23230 = state_23228;
(statearr_23230[(7)] = inst_23077__$1);

return statearr_23230;
})();
if(cljs.core.truth_(inst_23077__$1)){
var statearr_23231_23329 = state_23228__$1;
(statearr_23231_23329[(1)] = (9));

} else {
var statearr_23232_23330 = state_23228__$1;
(statearr_23232_23330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (59))){
var inst_23209 = (state_23228[(8)]);
var inst_23211 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_23212 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23211,inst_23209);
var state_23228__$1 = state_23228;
var statearr_23233_23331 = state_23228__$1;
(statearr_23233_23331[(2)] = inst_23212);

(statearr_23233_23331[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (20))){
var inst_23111 = (state_23228[(9)]);
var inst_23084 = (state_23228[(10)]);
var inst_23116 = (state_23228[(11)]);
var inst_23111__$1 = (state_23228[(2)]);
var inst_23112 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_23113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23111__$1,inst_23084);
var inst_23114 = cljs.core.vals(inst_23113);
var inst_23115 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,inst_23114);
var inst_23116__$1 = (inst_23112 < inst_23115);
var state_23228__$1 = (function (){var statearr_23234 = state_23228;
(statearr_23234[(9)] = inst_23111__$1);

(statearr_23234[(11)] = inst_23116__$1);

return statearr_23234;
})();
if(cljs.core.truth_(inst_23116__$1)){
var statearr_23235_23332 = state_23228__$1;
(statearr_23235_23332[(1)] = (21));

} else {
var statearr_23236_23333 = state_23228__$1;
(statearr_23236_23333[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (58))){
var inst_23208 = (state_23228[(2)]);
var inst_23209 = fluree.db.util.async.throw_err(inst_23208);
var state_23228__$1 = (function (){var statearr_23237 = state_23228;
(statearr_23237[(8)] = inst_23209);

return statearr_23237;
})();
if(cljs.core.truth_(fuel)){
var statearr_23238_23334 = state_23228__$1;
(statearr_23238_23334[(1)] = (59));

} else {
var statearr_23239_23335 = state_23228__$1;
(statearr_23239_23335[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (60))){
var inst_23209 = (state_23228[(8)]);
var state_23228__$1 = state_23228;
var statearr_23240_23336 = state_23228__$1;
(statearr_23240_23336[(2)] = inst_23209);

(statearr_23240_23336[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (27))){
var inst_23128 = (state_23228[(12)]);
var inst_23130 = f.o;
var inst_23131 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23130,inst_23128);
var state_23228__$1 = state_23228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23228__$1,(30),inst_23131);
} else {
if((state_val_23229 === (1))){
var state_23228__$1 = state_23228;
var statearr_23241_23337 = state_23228__$1;
(statearr_23241_23337[(2)] = null);

(statearr_23241_23337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (24))){
var state_23228__$1 = state_23228;
var statearr_23242_23338 = state_23228__$1;
(statearr_23242_23338[(2)] = null);

(statearr_23242_23338[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (55))){
var inst_23199 = cljs.core.rest(flakes);
var state_23228__$1 = state_23228;
var statearr_23243_23339 = state_23228__$1;
(statearr_23243_23339[(2)] = inst_23199);

(statearr_23243_23339[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (39))){
var inst_23139 = (state_23228[(13)]);
var inst_23169 = (state_23228[(2)]);
var state_23228__$1 = (function (){var statearr_23244 = state_23228;
(statearr_23244[(14)] = inst_23169);

return statearr_23244;
})();
if(cljs.core.truth_(inst_23139)){
var statearr_23245_23340 = state_23228__$1;
(statearr_23245_23340[(1)] = (40));

} else {
var statearr_23246_23341 = state_23228__$1;
(statearr_23246_23341[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (46))){
var state_23228__$1 = state_23228;
var statearr_23247_23342 = state_23228__$1;
(statearr_23247_23342[(2)] = acc);

(statearr_23247_23342[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (4))){
var inst_23066 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
var statearr_23248_23343 = state_23228__$1;
(statearr_23248_23343[(2)] = inst_23066);

(statearr_23248_23343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (54))){
var inst_23197 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
if(cljs.core.truth_(inst_23197)){
var statearr_23249_23344 = state_23228__$1;
(statearr_23249_23344[(1)] = (55));

} else {
var statearr_23250_23345 = state_23228__$1;
(statearr_23250_23345[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (15))){
var inst_23084 = (state_23228[(10)]);
var inst_23099 = fluree.db.query.fql.get_recursion_map(db,recursion_map,select_spec,cache,inst_23084,f);
var state_23228__$1 = state_23228;
var statearr_23251_23346 = state_23228__$1;
(statearr_23251_23346[(2)] = inst_23099);

(statearr_23251_23346[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (48))){
var inst_23191 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
var statearr_23252_23347 = state_23228__$1;
(statearr_23252_23347[(2)] = inst_23191);

(statearr_23252_23347[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (50))){
var state_23228__$1 = state_23228;
var statearr_23253_23348 = state_23228__$1;
(statearr_23253_23348[(2)] = null);

(statearr_23253_23348[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (21))){
var inst_23116 = (state_23228[(11)]);
var state_23228__$1 = state_23228;
var statearr_23254_23349 = state_23228__$1;
(statearr_23254_23349[(2)] = inst_23116);

(statearr_23254_23349[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (31))){
var inst_23088 = (state_23228[(15)]);
var inst_23084 = (state_23228[(10)]);
var inst_23141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23088,inst_23084);
var inst_23142 = cljs.core.count(inst_23141);
var inst_23143 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_23144 = (inst_23142 > inst_23143);
var state_23228__$1 = state_23228;
var statearr_23255_23350 = state_23228__$1;
(statearr_23255_23350[(2)] = inst_23144);

(statearr_23255_23350[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (32))){
var inst_23073 = (state_23228[(16)]);
var state_23228__$1 = state_23228;
var statearr_23256_23351 = state_23228__$1;
(statearr_23256_23351[(2)] = inst_23073);

(statearr_23256_23351[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (40))){
var inst_23139 = (state_23228[(13)]);
var inst_23169 = (state_23228[(14)]);
var inst_23084 = (state_23228[(10)]);
var inst_23171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23169,inst_23084);
var inst_23172 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23171,inst_23139], 0));
var inst_23173 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23169,inst_23084,inst_23172);
var state_23228__$1 = state_23228;
var statearr_23257_23352 = state_23228__$1;
(statearr_23257_23352[(2)] = inst_23173);

(statearr_23257_23352[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (56))){
var inst_23072 = (state_23228[(17)]);
var inst_23201 = cljs.core.rest(flakes);
var inst_23203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23204 = [inst_23072];
var inst_23205 = (new cljs.core.PersistentVector(null,1,(5),inst_23203,inst_23204,null));
var inst_23206 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23205);
var state_23228__$1 = (function (){var statearr_23258 = state_23228;
(statearr_23258[(18)] = inst_23201);

return statearr_23258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23228__$1,(58),inst_23206);
} else {
if((state_val_23229 === (33))){
var inst_23147 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
if(cljs.core.truth_(inst_23147)){
var statearr_23259_23353 = state_23228__$1;
(statearr_23259_23353[(1)] = (34));

} else {
var statearr_23260_23354 = state_23228__$1;
(statearr_23260_23354[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (13))){
var state_23228__$1 = state_23228;
var statearr_23261_23355 = state_23228__$1;
(statearr_23261_23355[(2)] = false);

(statearr_23261_23355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (22))){
var inst_23096 = (state_23228[(19)]);
var state_23228__$1 = state_23228;
var statearr_23262_23356 = state_23228__$1;
(statearr_23262_23356[(2)] = inst_23096);

(statearr_23262_23356[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (36))){
var inst_23223 = (state_23228[(2)]);
var _ = (function (){var statearr_23263 = state_23228;
(statearr_23263[(4)] = cljs.core.rest((state_23228[(4)])));

return statearr_23263;
})();
var state_23228__$1 = state_23228;
var statearr_23264_23357 = state_23228__$1;
(statearr_23264_23357[(2)] = inst_23223);

(statearr_23264_23357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (41))){
var inst_23169 = (state_23228[(14)]);
var state_23228__$1 = state_23228;
var statearr_23265_23358 = state_23228__$1;
(statearr_23265_23358[(2)] = inst_23169);

(statearr_23265_23358[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (43))){
var inst_23176 = (state_23228[(20)]);
var state_23228__$1 = state_23228;
var statearr_23266_23359 = state_23228__$1;
(statearr_23266_23359[(2)] = inst_23176);

(statearr_23266_23359[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (61))){
var inst_23201 = (state_23228[(18)]);
var inst_23215 = (state_23228[(2)]);
var inst_23216 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23201,inst_23215);
var state_23228__$1 = state_23228;
var statearr_23267_23360 = state_23228__$1;
(statearr_23267_23360[(2)] = inst_23216);

(statearr_23267_23360[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (29))){
var inst_23137 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
var statearr_23268_23361 = state_23228__$1;
(statearr_23268_23361[(2)] = inst_23137);

(statearr_23268_23361[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (44))){
var inst_23096 = (state_23228[(19)]);
var state_23228__$1 = state_23228;
if(cljs.core.truth_(inst_23096)){
var statearr_23269_23362 = state_23228__$1;
(statearr_23269_23362[(1)] = (46));

} else {
var statearr_23270_23363 = state_23228__$1;
(statearr_23270_23363[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (6))){
var inst_23074 = (state_23228[(21)]);
var state_23228__$1 = state_23228;
var statearr_23271_23364 = state_23228__$1;
(statearr_23271_23364[(2)] = inst_23074);

(statearr_23271_23364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (28))){
var state_23228__$1 = state_23228;
var statearr_23272_23365 = state_23228__$1;
(statearr_23272_23365[(2)] = null);

(statearr_23272_23365[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (51))){
var inst_23189 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
var statearr_23273_23366 = state_23228__$1;
(statearr_23273_23366[(2)] = inst_23189);

(statearr_23273_23366[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (25))){
var inst_23128 = (state_23228[(12)]);
var inst_23111 = (state_23228[(9)]);
var inst_23123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23124 = f.p;
var inst_23125 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_23124];
var inst_23126 = (new cljs.core.PersistentVector(null,2,(5),inst_23123,inst_23125,null));
var inst_23127 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23111,inst_23126);
var inst_23128__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23127);
var state_23228__$1 = (function (){var statearr_23274 = state_23228;
(statearr_23274[(12)] = inst_23128__$1);

return statearr_23274;
})();
if(cljs.core.truth_(inst_23128__$1)){
var statearr_23275_23367 = state_23228__$1;
(statearr_23275_23367[(1)] = (27));

} else {
var statearr_23276_23368 = state_23228__$1;
(statearr_23276_23368[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (34))){
var inst_23111 = (state_23228[(9)]);
var inst_23149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23150 = cljs.core.rest(flakes);
var inst_23151 = [acc,inst_23150,inst_23111];
var inst_23152 = (new cljs.core.PersistentVector(null,3,(5),inst_23149,inst_23151,null));
var state_23228__$1 = state_23228;
var statearr_23277_23369 = state_23228__$1;
(statearr_23277_23369[(2)] = inst_23152);

(statearr_23277_23369[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (17))){
var inst_23096 = (state_23228[(19)]);
var inst_23102 = (state_23228[(2)]);
var state_23228__$1 = (function (){var statearr_23278 = state_23228;
(statearr_23278[(22)] = inst_23102);

return statearr_23278;
})();
if(cljs.core.truth_(inst_23096)){
var statearr_23279_23370 = state_23228__$1;
(statearr_23279_23370[(1)] = (18));

} else {
var statearr_23280_23371 = state_23228__$1;
(statearr_23280_23371[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (3))){
var inst_23226 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23228__$1,inst_23226);
} else {
if((state_val_23229 === (12))){
var inst_23092 = (state_23228[(23)]);
var state_23228__$1 = state_23228;
var statearr_23281_23372 = state_23228__$1;
(statearr_23281_23372[(2)] = inst_23092);

(statearr_23281_23372[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (2))){
var inst_23074 = (state_23228[(21)]);
var _ = (function (){var statearr_23282 = state_23228;
(statearr_23282[(4)] = cljs.core.cons((5),(state_23228[(4)])));

return statearr_23282;
})();
var inst_23072 = f.o;
var inst_23073 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_23074__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23228__$1 = (function (){var statearr_23283 = state_23228;
(statearr_23283[(17)] = inst_23072);

(statearr_23283[(21)] = inst_23074__$1);

(statearr_23283[(16)] = inst_23073);

return statearr_23283;
})();
if(cljs.core.truth_(inst_23074__$1)){
var statearr_23284_23373 = state_23228__$1;
(statearr_23284_23373[(1)] = (6));

} else {
var statearr_23285_23374 = state_23228__$1;
(statearr_23285_23374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (23))){
var inst_23120 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
if(cljs.core.truth_(inst_23120)){
var statearr_23286_23375 = state_23228__$1;
(statearr_23286_23375[(1)] = (24));

} else {
var statearr_23287_23376 = state_23228__$1;
(statearr_23287_23376[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (47))){
var state_23228__$1 = state_23228;
var statearr_23288_23377 = state_23228__$1;
(statearr_23288_23377[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (35))){
var inst_23073 = (state_23228[(16)]);
var state_23228__$1 = state_23228;
if(cljs.core.truth_(inst_23073)){
var statearr_23290_23378 = state_23228__$1;
(statearr_23290_23378[(1)] = (37));

} else {
var statearr_23291_23379 = state_23228__$1;
(statearr_23291_23379[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (19))){
var inst_23102 = (state_23228[(22)]);
var inst_23072 = (state_23228[(17)]);
var inst_23084 = (state_23228[(10)]);
var inst_23105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23106 = [inst_23084,inst_23072];
var inst_23107 = (new cljs.core.PersistentVector(null,2,(5),inst_23105,inst_23106,null));
var inst_23108 = ((0) + (1));
var inst_23109 = cljs.core.assoc_in(inst_23102,inst_23107,inst_23108);
var state_23228__$1 = state_23228;
var statearr_23292_23380 = state_23228__$1;
(statearr_23292_23380[(2)] = inst_23109);

(statearr_23292_23380[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (57))){
var inst_23111 = (state_23228[(9)]);
var inst_23193 = (state_23228[(24)]);
var inst_23218 = (state_23228[(2)]);
var inst_23219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23220 = [inst_23193,inst_23218,inst_23111];
var inst_23221 = (new cljs.core.PersistentVector(null,3,(5),inst_23219,inst_23220,null));
var state_23228__$1 = state_23228;
var statearr_23293_23381 = state_23228__$1;
(statearr_23293_23381[(2)] = inst_23221);

(statearr_23293_23381[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (11))){
var inst_23082 = (state_23228[(2)]);
var state_23228__$1 = state_23228;
var statearr_23295_23382 = state_23228__$1;
(statearr_23295_23382[(2)] = inst_23082);

(statearr_23295_23382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (9))){
var inst_23077 = (state_23228[(7)]);
var state_23228__$1 = state_23228;
var statearr_23296_23383 = state_23228__$1;
(statearr_23296_23383[(2)] = inst_23077);

(statearr_23296_23383[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (5))){
var _ = (function (){var statearr_23297 = state_23228;
(statearr_23297[(4)] = cljs.core.rest((state_23228[(4)])));

return statearr_23297;
})();
var state_23228__$1 = state_23228;
var ex23294 = (state_23228__$1[(2)]);
var statearr_23298_23384 = state_23228__$1;
(statearr_23298_23384[(5)] = ex23294);


if((ex23294 instanceof Error)){
var statearr_23299_23385 = state_23228__$1;
(statearr_23299_23385[(1)] = (4));

(statearr_23299_23385[(5)] = null);

} else {
throw ex23294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (14))){
var inst_23096 = (state_23228[(19)]);
var inst_23096__$1 = (state_23228[(2)]);
var inst_23097 = cljs.core.not(inst_23096__$1);
var state_23228__$1 = (function (){var statearr_23300 = state_23228;
(statearr_23300[(19)] = inst_23096__$1);

return statearr_23300;
})();
if(inst_23097){
var statearr_23301_23386 = state_23228__$1;
(statearr_23301_23386[(1)] = (15));

} else {
var statearr_23302_23387 = state_23228__$1;
(statearr_23302_23387[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (45))){
var inst_23116 = (state_23228[(11)]);
var inst_23193 = (state_23228[(2)]);
var state_23228__$1 = (function (){var statearr_23303 = state_23228;
(statearr_23303[(24)] = inst_23193);

return statearr_23303;
})();
if(cljs.core.truth_(inst_23116)){
var statearr_23304_23388 = state_23228__$1;
(statearr_23304_23388[(1)] = (52));

} else {
var statearr_23305_23389 = state_23228__$1;
(statearr_23305_23389[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (53))){
var inst_23096 = (state_23228[(19)]);
var state_23228__$1 = state_23228;
var statearr_23306_23390 = state_23228__$1;
(statearr_23306_23390[(2)] = inst_23096);

(statearr_23306_23390[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (26))){
var inst_23073 = (state_23228[(16)]);
var inst_23139 = (state_23228[(2)]);
var state_23228__$1 = (function (){var statearr_23307 = state_23228;
(statearr_23307[(13)] = inst_23139);

return statearr_23307;
})();
if(cljs.core.truth_(inst_23073)){
var statearr_23308_23391 = state_23228__$1;
(statearr_23308_23391[(1)] = (31));

} else {
var statearr_23309_23392 = state_23228__$1;
(statearr_23309_23392[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (16))){
var state_23228__$1 = state_23228;
var statearr_23310_23393 = state_23228__$1;
(statearr_23310_23393[(2)] = recursion_map);

(statearr_23310_23393[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (38))){
var inst_23072 = (state_23228[(17)]);
var inst_23088 = (state_23228[(15)]);
var inst_23084 = (state_23228[(10)]);
var inst_23164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23165 = [inst_23084,new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23166 = (new cljs.core.PersistentVector(null,2,(5),inst_23164,inst_23165,null));
var inst_23167 = cljs.core.assoc_in(inst_23088,inst_23166,inst_23072);
var state_23228__$1 = state_23228;
var statearr_23311_23394 = state_23228__$1;
(statearr_23311_23394[(2)] = inst_23167);

(statearr_23311_23394[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (30))){
var inst_23133 = (state_23228[(2)]);
var inst_23134 = fluree.db.util.async.throw_err(inst_23133);
var state_23228__$1 = state_23228;
var statearr_23312_23395 = state_23228__$1;
(statearr_23312_23395[(2)] = inst_23134);

(statearr_23312_23395[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (10))){
var inst_23080 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23228__$1 = state_23228;
var statearr_23313_23396 = state_23228__$1;
(statearr_23313_23396[(2)] = inst_23080);

(statearr_23313_23396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (18))){
var inst_23102 = (state_23228[(22)]);
var state_23228__$1 = state_23228;
var statearr_23314_23397 = state_23228__$1;
(statearr_23314_23397[(2)] = inst_23102);

(statearr_23314_23397[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (52))){
var inst_23116 = (state_23228[(11)]);
var state_23228__$1 = state_23228;
var statearr_23315_23398 = state_23228__$1;
(statearr_23315_23398[(2)] = inst_23116);

(statearr_23315_23398[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (42))){
var inst_23096 = (state_23228[(19)]);
var inst_23176 = (state_23228[(2)]);
var inst_23177 = cljs.core.not(inst_23096);
var state_23228__$1 = (function (){var statearr_23316 = state_23228;
(statearr_23316[(20)] = inst_23176);

return statearr_23316;
})();
if(inst_23177){
var statearr_23317_23399 = state_23228__$1;
(statearr_23317_23399[(1)] = (43));

} else {
var statearr_23318_23400 = state_23228__$1;
(statearr_23318_23400[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (37))){
var inst_23072 = (state_23228[(17)]);
var inst_23088 = (state_23228[(15)]);
var inst_23084 = (state_23228[(10)]);
var inst_23155 = cljs.core.PersistentVector.EMPTY;
var inst_23156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23088,inst_23084);
var inst_23157 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23158 = [inst_23072];
var inst_23159 = cljs.core.PersistentHashMap.fromArrays(inst_23157,inst_23158);
var inst_23160 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23156,inst_23159);
var inst_23161 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23155,inst_23160);
var inst_23162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23088,inst_23084,inst_23161);
var state_23228__$1 = state_23228;
var statearr_23319_23401 = state_23228__$1;
(statearr_23319_23401[(2)] = inst_23162);

(statearr_23319_23401[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (8))){
var inst_23072 = (state_23228[(17)]);
var inst_23092 = (state_23228[(23)]);
var inst_23084 = (state_23228[(10)]);
var inst_23084__$1 = (state_23228[(2)]);
var inst_23085 = cljs.core.PersistentVector.EMPTY;
var inst_23086 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_23084__$1);
var inst_23087 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23085,inst_23086);
var inst_23088 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc,inst_23087);
var inst_23089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23090 = [inst_23084__$1,inst_23072];
var inst_23091 = (new cljs.core.PersistentVector(null,2,(5),inst_23089,inst_23090,null));
var inst_23092__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_23091);
var state_23228__$1 = (function (){var statearr_23320 = state_23228;
(statearr_23320[(23)] = inst_23092__$1);

(statearr_23320[(15)] = inst_23088);

(statearr_23320[(10)] = inst_23084__$1);

return statearr_23320;
})();
if(cljs.core.truth_(inst_23092__$1)){
var statearr_23321_23402 = state_23228__$1;
(statearr_23321_23402[(1)] = (12));

} else {
var statearr_23322_23403 = state_23228__$1;
(statearr_23322_23403[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23229 === (49))){
var inst_23176 = (state_23228[(20)]);
var inst_23084 = (state_23228[(10)]);
var inst_23183 = cljs.core.PersistentVector.EMPTY;
var inst_23184 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_23084);
var inst_23185 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23183,inst_23184);
var inst_23186 = cljs.core.assoc_in(acc,inst_23185,inst_23176);
var state_23228__$1 = state_23228;
var statearr_23323_23404 = state_23228__$1;
(statearr_23323_23404[(2)] = inst_23186);

(statearr_23323_23404[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0 = (function (){
var statearr_23324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23324[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__);

(statearr_23324[(1)] = (1));

return statearr_23324;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1 = (function (state_23228){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23228);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23325){var ex__2417__auto__ = e23325;
var statearr_23326_23405 = state_23228;
(statearr_23326_23405[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23228[(4)]))){
var statearr_23327_23406 = state_23228;
(statearr_23327_23406[(1)] = cljs.core.first((state_23228[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23407 = state_23228;
state_23228 = G__23407;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__ = function(state_23228){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1.call(this,state_23228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23328 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23328[(6)] = c__2436__auto__);

return statearr_23328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23598){
var state_val_23599 = (state_23598[(1)]);
if((state_val_23599 === (7))){
var state_23598__$1 = state_23598;
var statearr_23600_23692 = state_23598__$1;
(statearr_23600_23692[(2)] = null);

(statearr_23600_23692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (20))){
var inst_23446 = cljs.core.PersistentHashMap.EMPTY;
var state_23598__$1 = state_23598;
var statearr_23601_23693 = state_23598__$1;
(statearr_23601_23693[(2)] = inst_23446);

(statearr_23601_23693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (58))){
var inst_23556 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23602_23694 = state_23598__$1;
(statearr_23602_23694[(2)] = inst_23556);

(statearr_23602_23694[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (27))){
var inst_23448 = (state_23598[(7)]);
var inst_23434 = (state_23598[(8)]);
var inst_23464 = (state_23598[(9)]);
var inst_23428 = (state_23598[(10)]);
var inst_23577 = (state_23598[(2)]);
var inst_23578 = (function (){var top_level_subject = inst_23428;
var select_spec = inst_23434;
var base_acc = inst_23448;
var acc_PLUS_refs = inst_23464;
var result = inst_23577;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23579 = cljs.core.PersistentVector.EMPTY;
var inst_23580 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23434);
var inst_23581 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23580);
var inst_23582 = cljs.core.vals(inst_23581);
var inst_23583 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23434);
var inst_23584 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23583);
var inst_23585 = cljs.core.vals(inst_23584);
var inst_23586 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23582,inst_23585);
var inst_23587 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23578,inst_23579,inst_23586);
var inst_23589 = (function (){var top_level_subject = inst_23428;
var select_spec = inst_23434;
var base_acc = inst_23448;
var acc_PLUS_refs = inst_23464;
var result = inst_23577;
var sort_preds = inst_23587;
return (function (acc,p__23588){
var vec__23603 = p__23588;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23603,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23603,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23603,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23603,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23590 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23589,inst_23577,inst_23587);
var state_23598__$1 = state_23598;
var statearr_23606_23695 = state_23598__$1;
(statearr_23606_23695[(2)] = inst_23590);

(statearr_23606_23695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (1))){
var state_23598__$1 = state_23598;
var statearr_23607_23696 = state_23598__$1;
(statearr_23607_23696[(2)] = null);

(statearr_23607_23696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (24))){
var inst_23464 = (state_23598[(9)]);
var inst_23464__$1 = (state_23598[(2)]);
var inst_23465 = flakes;
var inst_23466 = cljs.core.PersistentHashMap.EMPTY;
var inst_23467 = cljs.core.PersistentHashMap.EMPTY;
var inst_23468 = inst_23465;
var inst_23469 = inst_23464__$1;
var inst_23470 = inst_23466;
var inst_23471 = inst_23467;
var state_23598__$1 = (function (){var statearr_23608 = state_23598;
(statearr_23608[(11)] = inst_23470);

(statearr_23608[(9)] = inst_23464__$1);

(statearr_23608[(12)] = inst_23471);

(statearr_23608[(13)] = inst_23468);

(statearr_23608[(14)] = inst_23469);

return statearr_23608;
})();
var statearr_23609_23697 = state_23598__$1;
(statearr_23609_23697[(2)] = null);

(statearr_23609_23697[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (55))){
var inst_23558 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23610_23698 = state_23598__$1;
(statearr_23610_23698[(2)] = inst_23558);

(statearr_23610_23698[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (39))){
var inst_23484 = (state_23598[(15)]);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23484)){
var statearr_23611_23699 = state_23598__$1;
(statearr_23611_23699[(1)] = (42));

} else {
var statearr_23612_23700 = state_23598__$1;
(statearr_23612_23700[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (46))){
var inst_23434 = (state_23598[(8)]);
var inst_23479 = (state_23598[(16)]);
var inst_23485 = (state_23598[(17)]);
var inst_23469 = (state_23598[(14)]);
var inst_23522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23523 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23469,inst_23434,inst_23479,inst_23485,false);
var state_23598__$1 = (function (){var statearr_23613 = state_23598;
(statearr_23613[(18)] = inst_23522);

return statearr_23613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23598__$1,(49),inst_23523);
} else {
if((state_val_23599 === (4))){
var inst_23408 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23614_23701 = state_23598__$1;
(statearr_23614_23701[(2)] = inst_23408);

(statearr_23614_23701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (54))){
var state_23598__$1 = state_23598;
var statearr_23615_23702 = state_23598__$1;
(statearr_23615_23702[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (15))){
var inst_23434 = (state_23598[(8)]);
var inst_23435 = (state_23598[(19)]);
var inst_23434__$1 = (state_23598[(2)]);
var inst_23435__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23434__$1);
var state_23598__$1 = (function (){var statearr_23617 = state_23598;
(statearr_23617[(8)] = inst_23434__$1);

(statearr_23617[(19)] = inst_23435__$1);

return statearr_23617;
})();
if(cljs.core.truth_(inst_23435__$1)){
var statearr_23618_23703 = state_23598__$1;
(statearr_23618_23703[(1)] = (16));

} else {
var statearr_23619_23704 = state_23598__$1;
(statearr_23619_23704[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (48))){
var inst_23560 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23620_23705 = state_23598__$1;
(statearr_23620_23705[(2)] = inst_23560);

(statearr_23620_23705[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (50))){
var inst_23434 = (state_23598[(8)]);
var inst_23535 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23434);
var state_23598__$1 = state_23598;
var statearr_23621_23706 = state_23598__$1;
(statearr_23621_23706[(2)] = inst_23535);

(statearr_23621_23706[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (21))){
var inst_23434 = (state_23598[(8)]);
var inst_23448 = (state_23598[(2)]);
var inst_23449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23450 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23451 = (new cljs.core.PersistentVector(null,2,(5),inst_23449,inst_23450,null));
var inst_23452 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23434,inst_23451);
var state_23598__$1 = (function (){var statearr_23622 = state_23598;
(statearr_23622[(7)] = inst_23448);

return statearr_23622;
})();
if(cljs.core.truth_(inst_23452)){
var statearr_23623_23707 = state_23598__$1;
(statearr_23623_23707[(1)] = (22));

} else {
var statearr_23624_23708 = state_23598__$1;
(statearr_23624_23708[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (31))){
var inst_23484 = (state_23598[(15)]);
var inst_23488 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23484);
var state_23598__$1 = state_23598;
var statearr_23625_23709 = state_23598__$1;
(statearr_23625_23709[(2)] = inst_23488);

(statearr_23625_23709[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (32))){
var inst_23486 = (state_23598[(20)]);
var state_23598__$1 = state_23598;
var statearr_23626_23710 = state_23598__$1;
(statearr_23626_23710[(2)] = inst_23486);

(statearr_23626_23710[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (40))){
var inst_23564 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23627_23711 = state_23598__$1;
(statearr_23627_23711[(2)] = inst_23564);

(statearr_23627_23711[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (56))){
var inst_23470 = (state_23598[(11)]);
var inst_23471 = (state_23598[(12)]);
var inst_23468 = (state_23598[(13)]);
var inst_23469 = (state_23598[(14)]);
var inst_23550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23551 = cljs.core.rest(inst_23468);
var inst_23552 = [inst_23469,inst_23551,inst_23470,inst_23471];
var inst_23553 = (new cljs.core.PersistentVector(null,4,(5),inst_23550,inst_23552,null));
var state_23598__$1 = state_23598;
var statearr_23628_23712 = state_23598__$1;
(statearr_23628_23712[(2)] = inst_23553);

(statearr_23628_23712[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (33))){
var inst_23491 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23491)){
var statearr_23629_23713 = state_23598__$1;
(statearr_23629_23713[(1)] = (34));

} else {
var statearr_23630_23714 = state_23598__$1;
(statearr_23630_23714[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (13))){
var inst_23428 = (state_23598[(10)]);
var inst_23431 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23428);
var state_23598__$1 = state_23598;
var statearr_23631_23715 = state_23598__$1;
(statearr_23631_23715[(2)] = inst_23431);

(statearr_23631_23715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (22))){
var inst_23434 = (state_23598[(8)]);
var inst_23454 = cljs.core.first(flakes);
var inst_23455 = fluree.db.query.fql.s(inst_23454);
var inst_23456 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23434);
var inst_23457 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23455,inst_23456);
var state_23598__$1 = state_23598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23598__$1,(25),inst_23457);
} else {
if((state_val_23599 === (36))){
var inst_23479 = (state_23598[(16)]);
var inst_23566 = (state_23598[(2)]);
var inst_23567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23566,(0),null);
var inst_23568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23566,(1),null);
var inst_23569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23566,(2),null);
var inst_23570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23566,(3),null);
var inst_23571 = inst_23479.s;
var inst_23572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23567,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23571);
var inst_23468 = inst_23568;
var inst_23469 = inst_23572;
var inst_23470 = inst_23569;
var inst_23471 = inst_23570;
var state_23598__$1 = (function (){var statearr_23632 = state_23598;
(statearr_23632[(11)] = inst_23470);

(statearr_23632[(12)] = inst_23471);

(statearr_23632[(13)] = inst_23468);

(statearr_23632[(14)] = inst_23469);

return statearr_23632;
})();
var statearr_23633_23716 = state_23598__$1;
(statearr_23633_23716[(2)] = null);

(statearr_23633_23716[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (41))){
var inst_23502 = (state_23598[(2)]);
var inst_23503 = fluree.db.util.async.throw_err(inst_23502);
var state_23598__$1 = state_23598;
var statearr_23634_23717 = state_23598__$1;
(statearr_23634_23717[(2)] = inst_23503);

(statearr_23634_23717[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (43))){
var inst_23434 = (state_23598[(8)]);
var inst_23520 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23434);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23520)){
var statearr_23635_23718 = state_23598__$1;
(statearr_23635_23718[(1)] = (46));

} else {
var statearr_23636_23719 = state_23598__$1;
(statearr_23636_23719[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (29))){
var inst_23434 = (state_23598[(8)]);
var inst_23486 = (state_23598[(20)]);
var inst_23479 = (state_23598[(16)]);
var inst_23468 = (state_23598[(13)]);
var inst_23484 = (state_23598[(15)]);
var inst_23479__$1 = cljs.core.first(inst_23468);
var inst_23480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23481 = inst_23479__$1.p;
var inst_23482 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23481];
var inst_23483 = (new cljs.core.PersistentVector(null,3,(5),inst_23480,inst_23482,null));
var inst_23484__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23434,inst_23483);
var inst_23485 = fluree.db.query.fql.component_follow_QMARK_(inst_23484__$1,inst_23434);
var inst_23486__$1 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(inst_23484__$1);
var state_23598__$1 = (function (){var statearr_23637 = state_23598;
(statearr_23637[(20)] = inst_23486__$1);

(statearr_23637[(16)] = inst_23479__$1);

(statearr_23637[(17)] = inst_23485);

(statearr_23637[(15)] = inst_23484__$1);

return statearr_23637;
})();
if(cljs.core.truth_(inst_23486__$1)){
var statearr_23638_23720 = state_23598__$1;
(statearr_23638_23720[(1)] = (31));

} else {
var statearr_23639_23721 = state_23598__$1;
(statearr_23639_23721[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (44))){
var inst_23562 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23640_23722 = state_23598__$1;
(statearr_23640_23722[(2)] = inst_23562);

(statearr_23640_23722[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (6))){
var state_23598__$1 = state_23598;
var statearr_23641_23723 = state_23598__$1;
(statearr_23641_23723[(2)] = null);

(statearr_23641_23723[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (28))){
var inst_23469 = (state_23598[(14)]);
var state_23598__$1 = state_23598;
var statearr_23642_23724 = state_23598__$1;
(statearr_23642_23724[(2)] = inst_23469);

(statearr_23642_23724[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (51))){
var state_23598__$1 = state_23598;
var statearr_23643_23725 = state_23598__$1;
(statearr_23643_23725[(2)] = false);

(statearr_23643_23725[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (25))){
var inst_23448 = (state_23598[(7)]);
var inst_23459 = (state_23598[(2)]);
var inst_23460 = fluree.db.util.async.throw_err(inst_23459);
var inst_23461 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23448,inst_23460], 0));
var state_23598__$1 = state_23598;
var statearr_23644_23726 = state_23598__$1;
(statearr_23644_23726[(2)] = inst_23461);

(statearr_23644_23726[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (34))){
var inst_23434 = (state_23598[(8)]);
var inst_23470 = (state_23598[(11)]);
var inst_23479 = (state_23598[(16)]);
var inst_23468 = (state_23598[(13)]);
var inst_23484 = (state_23598[(15)]);
var inst_23469 = (state_23598[(14)]);
var inst_23493 = fluree.db.query.fql.flake__GT_recur_multi(db,inst_23479,inst_23484,inst_23470,inst_23468,inst_23469,fuel,max_fuel,inst_23434,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_23598__$1 = state_23598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23598__$1,(37),inst_23493);
} else {
if((state_val_23599 === (17))){
var inst_23434 = (state_23598[(8)]);
var inst_23438 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23434);
var state_23598__$1 = state_23598;
var statearr_23646_23727 = state_23598__$1;
(statearr_23646_23727[(2)] = inst_23438);

(statearr_23646_23727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (3))){
var inst_23596 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23598__$1,inst_23596);
} else {
if((state_val_23599 === (12))){
var _ = (function (){var statearr_23647 = state_23598;
(statearr_23647[(4)] = cljs.core.rest((state_23598[(4)])));

return statearr_23647;
})();
var state_23598__$1 = state_23598;
var ex23645 = (state_23598__$1[(2)]);
var statearr_23648_23728 = state_23598__$1;
(statearr_23648_23728[(5)] = ex23645);


var statearr_23649_23729 = state_23598__$1;
(statearr_23649_23729[(1)] = (11));

(statearr_23649_23729[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (2))){
var _ = (function (){var statearr_23650 = state_23598;
(statearr_23650[(4)] = cljs.core.cons((5),(state_23598[(4)])));

return statearr_23650;
})();
var inst_23414 = cljs.core.not_empty(flakes);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23414)){
var statearr_23651_23730 = state_23598__$1;
(statearr_23651_23730[(1)] = (6));

} else {
var statearr_23652_23731 = state_23598__$1;
(statearr_23652_23731[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (23))){
var inst_23448 = (state_23598[(7)]);
var state_23598__$1 = state_23598;
var statearr_23653_23732 = state_23598__$1;
(statearr_23653_23732[(2)] = inst_23448);

(statearr_23653_23732[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (47))){
var inst_23434 = (state_23598[(8)]);
var inst_23532 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23434);
var inst_23533 = cljs.core.empty_QMARK_(inst_23532);
var state_23598__$1 = state_23598;
if(inst_23533){
var statearr_23654_23733 = state_23598__$1;
(statearr_23654_23733[(1)] = (50));

} else {
var statearr_23655_23734 = state_23598__$1;
(statearr_23655_23734[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (35))){
var inst_23484 = (state_23598[(15)]);
var inst_23498 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23484);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23498)){
var statearr_23656_23735 = state_23598__$1;
(statearr_23656_23735[(1)] = (38));

} else {
var statearr_23657_23736 = state_23598__$1;
(statearr_23657_23736[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (19))){
var inst_23428 = (state_23598[(10)]);
var inst_23442 = ["_id"];
var inst_23443 = [inst_23428];
var inst_23444 = cljs.core.PersistentHashMap.fromArrays(inst_23442,inst_23443);
var state_23598__$1 = state_23598;
var statearr_23658_23737 = state_23598__$1;
(statearr_23658_23737[(2)] = inst_23444);

(statearr_23658_23737[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (57))){
var state_23598__$1 = state_23598;
var statearr_23659_23738 = state_23598__$1;
(statearr_23659_23738[(2)] = null);

(statearr_23659_23738[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (11))){
var inst_23416 = (state_23598[(2)]);
var inst_23417 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23416], 0));
var inst_23418 = (function(){throw inst_23416})();
var state_23598__$1 = (function (){var statearr_23661 = state_23598;
(statearr_23661[(21)] = inst_23417);

return statearr_23661;
})();
var statearr_23662_23739 = state_23598__$1;
(statearr_23662_23739[(2)] = inst_23418);

(statearr_23662_23739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (9))){
var _ = (function (){var statearr_23663 = state_23598;
(statearr_23663[(4)] = cljs.core.cons((12),(state_23598[(4)])));

return statearr_23663;
})();
var inst_23424 = cljs.core.first(flakes);
var inst_23425 = fluree.db.query.fql.s(inst_23424);
var ___$1 = (function (){var statearr_23664 = state_23598;
(statearr_23664[(4)] = cljs.core.rest((state_23598[(4)])));

return statearr_23664;
})();
var state_23598__$1 = state_23598;
var statearr_23665_23740 = state_23598__$1;
(statearr_23665_23740[(2)] = inst_23425);

(statearr_23665_23740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (5))){
var _ = (function (){var statearr_23666 = state_23598;
(statearr_23666[(4)] = cljs.core.rest((state_23598[(4)])));

return statearr_23666;
})();
var state_23598__$1 = state_23598;
var ex23660 = (state_23598__$1[(2)]);
var statearr_23667_23741 = state_23598__$1;
(statearr_23667_23741[(5)] = ex23660);


if((ex23660 instanceof Error)){
var statearr_23668_23742 = state_23598__$1;
(statearr_23668_23742[(1)] = (4));

(statearr_23668_23742[(5)] = null);

} else {
throw ex23660;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (14))){
var state_23598__$1 = state_23598;
var statearr_23669_23743 = state_23598__$1;
(statearr_23669_23743[(2)] = base_select_spec);

(statearr_23669_23743[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (45))){
var inst_23470 = (state_23598[(11)]);
var inst_23468 = (state_23598[(13)]);
var inst_23511 = (state_23598[(2)]);
var inst_23512 = fluree.db.util.async.throw_err(inst_23511);
var inst_23513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23512,(0),null);
var inst_23514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23512,(1),null);
var inst_23515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23516 = cljs.core.rest(inst_23468);
var inst_23517 = [inst_23513,inst_23516,inst_23470,inst_23514];
var inst_23518 = (new cljs.core.PersistentVector(null,4,(5),inst_23515,inst_23517,null));
var state_23598__$1 = state_23598;
var statearr_23670_23744 = state_23598__$1;
(statearr_23670_23744[(2)] = inst_23518);

(statearr_23670_23744[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (53))){
var inst_23470 = (state_23598[(11)]);
var inst_23479 = (state_23598[(16)]);
var inst_23471 = (state_23598[(12)]);
var inst_23468 = (state_23598[(13)]);
var inst_23540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23541 = ["_id"];
var inst_23542 = inst_23479.s;
var inst_23543 = [inst_23542];
var inst_23544 = cljs.core.PersistentHashMap.fromArrays(inst_23541,inst_23543);
var inst_23545 = cljs.core.rest(inst_23468);
var inst_23546 = [inst_23544,inst_23545,inst_23470,inst_23471];
var inst_23547 = (new cljs.core.PersistentVector(null,4,(5),inst_23540,inst_23546,null));
var state_23598__$1 = state_23598;
var statearr_23671_23745 = state_23598__$1;
(statearr_23671_23745[(2)] = inst_23547);

(statearr_23671_23745[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (26))){
var inst_23468 = (state_23598[(13)]);
var inst_23473 = cljs.core.empty_QMARK_(inst_23468);
var state_23598__$1 = state_23598;
if(inst_23473){
var statearr_23672_23746 = state_23598__$1;
(statearr_23672_23746[(1)] = (28));

} else {
var statearr_23673_23747 = state_23598__$1;
(statearr_23673_23747[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (16))){
var inst_23435 = (state_23598[(19)]);
var state_23598__$1 = state_23598;
var statearr_23674_23748 = state_23598__$1;
(statearr_23674_23748[(2)] = inst_23435);

(statearr_23674_23748[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (38))){
var inst_23434 = (state_23598[(8)]);
var inst_23470 = (state_23598[(11)]);
var inst_23479 = (state_23598[(16)]);
var inst_23468 = (state_23598[(13)]);
var inst_23484 = (state_23598[(15)]);
var inst_23469 = (state_23598[(14)]);
var inst_23500 = fluree.db.query.fql.flake__GT_recur(db,inst_23479,inst_23484,inst_23470,inst_23468,inst_23469,fuel,max_fuel,inst_23434,cache);
var state_23598__$1 = state_23598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23598__$1,(41),inst_23500);
} else {
if((state_val_23599 === (30))){
var inst_23575 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
var statearr_23675_23749 = state_23598__$1;
(statearr_23675_23749[(2)] = inst_23575);

(statearr_23675_23749[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (10))){
var inst_23428 = (state_23598[(2)]);
var inst_23429 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23598__$1 = (function (){var statearr_23676 = state_23598;
(statearr_23676[(10)] = inst_23428);

return statearr_23676;
})();
if(cljs.core.truth_(inst_23429)){
var statearr_23677_23750 = state_23598__$1;
(statearr_23677_23750[(1)] = (13));

} else {
var statearr_23678_23751 = state_23598__$1;
(statearr_23678_23751[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (18))){
var inst_23440 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23440)){
var statearr_23679_23752 = state_23598__$1;
(statearr_23679_23752[(1)] = (19));

} else {
var statearr_23680_23753 = state_23598__$1;
(statearr_23680_23753[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (52))){
var inst_23538 = (state_23598[(2)]);
var state_23598__$1 = state_23598;
if(cljs.core.truth_(inst_23538)){
var statearr_23681_23754 = state_23598__$1;
(statearr_23681_23754[(1)] = (53));

} else {
var statearr_23682_23755 = state_23598__$1;
(statearr_23682_23755[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (42))){
var inst_23479 = (state_23598[(16)]);
var inst_23485 = (state_23598[(17)]);
var inst_23471 = (state_23598[(12)]);
var inst_23484 = (state_23598[(15)]);
var inst_23469 = (state_23598[(14)]);
var inst_23509 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23469,inst_23484,inst_23479,inst_23485,false,inst_23471);
var state_23598__$1 = state_23598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23598__$1,(45),inst_23509);
} else {
if((state_val_23599 === (37))){
var inst_23495 = (state_23598[(2)]);
var inst_23496 = fluree.db.util.async.throw_err(inst_23495);
var state_23598__$1 = state_23598;
var statearr_23683_23756 = state_23598__$1;
(statearr_23683_23756[(2)] = inst_23496);

(statearr_23683_23756[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (8))){
var inst_23593 = (state_23598[(2)]);
var _ = (function (){var statearr_23684 = state_23598;
(statearr_23684[(4)] = cljs.core.rest((state_23598[(4)])));

return statearr_23684;
})();
var state_23598__$1 = state_23598;
var statearr_23685_23757 = state_23598__$1;
(statearr_23685_23757[(2)] = inst_23593);

(statearr_23685_23757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23599 === (49))){
var inst_23522 = (state_23598[(18)]);
var inst_23470 = (state_23598[(11)]);
var inst_23471 = (state_23598[(12)]);
var inst_23468 = (state_23598[(13)]);
var inst_23525 = (state_23598[(2)]);
var inst_23526 = fluree.db.util.async.throw_err(inst_23525);
var inst_23527 = cljs.core.first(inst_23526);
var inst_23528 = cljs.core.rest(inst_23468);
var inst_23529 = [inst_23527,inst_23528,inst_23470,inst_23471];
var inst_23530 = (new cljs.core.PersistentVector(null,4,(5),inst_23522,inst_23529,null));
var state_23598__$1 = state_23598;
var statearr_23686_23758 = state_23598__$1;
(statearr_23686_23758[(2)] = inst_23530);

(statearr_23686_23758[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0 = (function (){
var statearr_23687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23687[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__);

(statearr_23687[(1)] = (1));

return statearr_23687;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1 = (function (state_23598){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23598);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23688){var ex__2417__auto__ = e23688;
var statearr_23689_23759 = state_23598;
(statearr_23689_23759[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23598[(4)]))){
var statearr_23690_23760 = state_23598;
(statearr_23690_23760[(1)] = cljs.core.first((state_23598[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23761 = state_23598;
state_23598 = G__23761;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__ = function(state_23598){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1.call(this,state_23598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23691 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23691[(6)] = c__2436__auto__);

return statearr_23691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23764 = arguments.length;
switch (G__23764) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23806){
var state_val_23807 = (state_23806[(1)]);
if((state_val_23807 === (7))){
var inst_23772 = (state_23806[(7)]);
var state_23806__$1 = state_23806;
var statearr_23808_23838 = state_23806__$1;
(statearr_23808_23838[(2)] = inst_23772);

(statearr_23808_23838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (1))){
var state_23806__$1 = state_23806;
var statearr_23809_23839 = state_23806__$1;
(statearr_23809_23839[(2)] = null);

(statearr_23809_23839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (4))){
var inst_23765 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
var statearr_23810_23840 = state_23806__$1;
(statearr_23810_23840[(2)] = inst_23765);

(statearr_23810_23840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (15))){
var inst_23800 = (state_23806[(2)]);
var inst_23801 = fluree.db.util.async.throw_err(inst_23800);
var _ = (function (){var statearr_23811 = state_23806;
(statearr_23811[(4)] = cljs.core.rest((state_23806[(4)])));

return statearr_23811;
})();
var state_23806__$1 = state_23806;
var statearr_23812_23841 = state_23806__$1;
(statearr_23812_23841[(2)] = inst_23801);

(statearr_23812_23841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (13))){
var inst_23784 = (state_23806[(8)]);
var state_23806__$1 = state_23806;
var statearr_23813_23842 = state_23806__$1;
(statearr_23813_23842[(2)] = inst_23784);

(statearr_23813_23842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (6))){
var inst_23772 = (state_23806[(7)]);
var inst_23774 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23775 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23772,inst_23774);
var state_23806__$1 = state_23806;
var statearr_23814_23843 = state_23806__$1;
(statearr_23814_23843[(2)] = inst_23775);

(statearr_23814_23843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (3))){
var inst_23804 = (state_23806[(2)]);
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23806__$1,inst_23804);
} else {
if((state_val_23807 === (12))){
var inst_23784 = (state_23806[(8)]);
var inst_23786 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23787 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23784,inst_23786);
var state_23806__$1 = state_23806;
var statearr_23815_23844 = state_23806__$1;
(statearr_23815_23844[(2)] = inst_23787);

(statearr_23815_23844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (2))){
var _ = (function (){var statearr_23816 = state_23806;
(statearr_23816[(4)] = cljs.core.cons((5),(state_23806[(4)])));

return statearr_23816;
})();
var inst_23772 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23806__$1 = (function (){var statearr_23817 = state_23806;
(statearr_23817[(7)] = inst_23772);

return statearr_23817;
})();
if(cljs.core.truth_(fuel)){
var statearr_23818_23845 = state_23806__$1;
(statearr_23818_23845[(1)] = (6));

} else {
var statearr_23819_23846 = state_23806__$1;
(statearr_23819_23846[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (11))){
var inst_23784 = (state_23806[(2)]);
var state_23806__$1 = (function (){var statearr_23821 = state_23806;
(statearr_23821[(8)] = inst_23784);

return statearr_23821;
})();
if(cljs.core.truth_(limit)){
var statearr_23822_23847 = state_23806__$1;
(statearr_23822_23847[(1)] = (12));

} else {
var statearr_23823_23848 = state_23806__$1;
(statearr_23823_23848[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (9))){
var inst_23778 = (state_23806[(9)]);
var inst_23780 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23781 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23778,inst_23780);
var state_23806__$1 = state_23806;
var statearr_23824_23849 = state_23806__$1;
(statearr_23824_23849[(2)] = inst_23781);

(statearr_23824_23849[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (5))){
var _ = (function (){var statearr_23825 = state_23806;
(statearr_23825[(4)] = cljs.core.rest((state_23806[(4)])));

return statearr_23825;
})();
var state_23806__$1 = state_23806;
var ex23820 = (state_23806__$1[(2)]);
var statearr_23826_23850 = state_23806__$1;
(statearr_23826_23850[(5)] = ex23820);


if((ex23820 instanceof Error)){
var statearr_23827_23851 = state_23806__$1;
(statearr_23827_23851[(1)] = (4));

(statearr_23827_23851[(5)] = null);

} else {
throw ex23820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (14))){
var inst_23790 = (state_23806[(2)]);
var inst_23791 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23792 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23791);
var inst_23793 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23790,inst_23792);
var inst_23794 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23793,flakes);
var inst_23795 = cljs.core.PersistentVector.EMPTY;
var inst_23796 = (function (){var xf = inst_23793;
var flakes_by_sub = inst_23794;
return (function (p1__23762_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23762_SHARP_);
});
})();
var inst_23797 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23796,inst_23794);
var inst_23798 = fluree.db.util.async.merge_into_QMARK_(inst_23795,inst_23797);
var state_23806__$1 = state_23806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23806__$1,(15),inst_23798);
} else {
if((state_val_23807 === (10))){
var inst_23778 = (state_23806[(9)]);
var state_23806__$1 = state_23806;
var statearr_23828_23852 = state_23806__$1;
(statearr_23828_23852[(2)] = inst_23778);

(statearr_23828_23852[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23807 === (8))){
var inst_23778 = (state_23806[(2)]);
var state_23806__$1 = (function (){var statearr_23829 = state_23806;
(statearr_23829[(9)] = inst_23778);

return statearr_23829;
})();
if(cljs.core.truth_(offset)){
var statearr_23830_23853 = state_23806__$1;
(statearr_23830_23853[(1)] = (9));

} else {
var statearr_23831_23854 = state_23806__$1;
(statearr_23831_23854[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_23832 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23832[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_23832[(1)] = (1));

return statearr_23832;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_23806){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23806);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23833){var ex__2417__auto__ = e23833;
var statearr_23834_23855 = state_23806;
(statearr_23834_23855[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23806[(4)]))){
var statearr_23835_23856 = state_23806;
(statearr_23835_23856[(1)] = cljs.core.first((state_23806[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23857 = state_23806;
state_23806 = G__23857;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_23806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_23806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23836 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23836[(6)] = c__2436__auto__);

return statearr_23836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23859 = arguments.length;
switch (G__23859) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23943){
var state_val_23944 = (state_23943[(1)]);
if((state_val_23944 === (7))){
var inst_23938 = (state_23943[(2)]);
var _ = (function (){var statearr_23946 = state_23943;
(statearr_23946[(4)] = cljs.core.rest((state_23943[(4)])));

return statearr_23946;
})();
var state_23943__$1 = state_23943;
var statearr_23947_23994 = state_23943__$1;
(statearr_23947_23994[(2)] = inst_23938);

(statearr_23947_23994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (20))){
var inst_23887 = (state_23943[(7)]);
var inst_23879 = (state_23943[(8)]);
var inst_23880 = (state_23943[(9)]);
var inst_23908 = (inst_23879 + (1));
var tmp23945 = inst_23880;
var inst_23878 = inst_23887;
var inst_23879__$1 = inst_23908;
var inst_23880__$1 = tmp23945;
var state_23943__$1 = (function (){var statearr_23948 = state_23943;
(statearr_23948[(8)] = inst_23879__$1);

(statearr_23948[(10)] = inst_23878);

(statearr_23948[(9)] = inst_23880__$1);

return statearr_23948;
})();
var statearr_23949_23995 = state_23943__$1;
(statearr_23949_23995[(2)] = null);

(statearr_23949_23995[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (27))){
var inst_23913 = (state_23943[(11)]);
var inst_23922 = (state_23943[(2)]);
var inst_23923 = fluree.db.util.async.throw_err(inst_23922);
var inst_23924 = (inst_23913.cljs$core$IFn$_invoke$arity$1 ? inst_23913.cljs$core$IFn$_invoke$arity$1(inst_23923) : inst_23913.call(null,inst_23923));
var state_23943__$1 = state_23943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23943__$1,(26),inst_23924);
} else {
if((state_val_23944 === (1))){
var state_23943__$1 = state_23943;
var statearr_23950_23996 = state_23943__$1;
(statearr_23950_23996[(2)] = null);

(statearr_23950_23996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (24))){
var state_23943__$1 = state_23943;
var statearr_23951_23997 = state_23943__$1;
(statearr_23951_23997[(2)] = null);

(statearr_23951_23997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (4))){
var inst_23860 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
var statearr_23952_23998 = state_23943__$1;
(statearr_23952_23998[(2)] = inst_23860);

(statearr_23952_23998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (15))){
var inst_23901 = (state_23943[(12)]);
var inst_23901__$1 = offset;
var state_23943__$1 = (function (){var statearr_23953 = state_23943;
(statearr_23953[(12)] = inst_23901__$1);

return statearr_23953;
})();
if(cljs.core.truth_(inst_23901__$1)){
var statearr_23954_23999 = state_23943__$1;
(statearr_23954_23999[(1)] = (17));

} else {
var statearr_23955_24000 = state_23943__$1;
(statearr_23955_24000[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (21))){
var state_23943__$1 = state_23943;
var statearr_23956_24001 = state_23943__$1;
(statearr_23956_24001[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (13))){
var inst_23896 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
var statearr_23958_24002 = state_23943__$1;
(statearr_23958_24002[(2)] = inst_23896);

(statearr_23958_24002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (22))){
var inst_23934 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
var statearr_23959_24003 = state_23943__$1;
(statearr_23959_24003[(2)] = inst_23934);

(statearr_23959_24003[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (6))){
var inst_23886 = (state_23943[(13)]);
var inst_23888 = (state_23943[(14)]);
var inst_23878 = (state_23943[(10)]);
var inst_23885 = cljs.core.seq(inst_23878);
var inst_23886__$1 = cljs.core.first(inst_23885);
var inst_23887 = cljs.core.next(inst_23885);
var inst_23888__$1 = (inst_23886__$1 == null);
var state_23943__$1 = (function (){var statearr_23960 = state_23943;
(statearr_23960[(7)] = inst_23887);

(statearr_23960[(13)] = inst_23886__$1);

(statearr_23960[(14)] = inst_23888__$1);

return statearr_23960;
})();
if(cljs.core.truth_(inst_23888__$1)){
var statearr_23961_24004 = state_23943__$1;
(statearr_23961_24004[(1)] = (8));

} else {
var statearr_23962_24005 = state_23943__$1;
(statearr_23962_24005[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (25))){
var inst_23932 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
var statearr_23963_24006 = state_23943__$1;
(statearr_23963_24006[(2)] = inst_23932);

(statearr_23963_24006[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (17))){
var inst_23879 = (state_23943[(8)]);
var inst_23903 = (inst_23879 < offset);
var state_23943__$1 = state_23943;
var statearr_23964_24007 = state_23943__$1;
(statearr_23964_24007[(2)] = inst_23903);

(statearr_23964_24007[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (3))){
var inst_23941 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23943__$1,inst_23941);
} else {
if((state_val_23944 === (12))){
var inst_23891 = (state_23943[(15)]);
var state_23943__$1 = state_23943;
var statearr_23965_24008 = state_23943__$1;
(statearr_23965_24008[(2)] = inst_23891);

(statearr_23965_24008[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (2))){
var inst_23873 = (state_23943[(16)]);
var _ = (function (){var statearr_23966 = state_23943;
(statearr_23966[(4)] = cljs.core.cons((5),(state_23943[(4)])));

return statearr_23966;
})();
var inst_23873__$1 = subjects;
var inst_23874 = cljs.core.seq(inst_23873__$1);
var inst_23875 = cljs.core.first(inst_23874);
var inst_23876 = cljs.core.next(inst_23874);
var inst_23877 = cljs.core.PersistentVector.EMPTY;
var inst_23878 = inst_23873__$1;
var inst_23879 = (0);
var inst_23880 = inst_23877;
var state_23943__$1 = (function (){var statearr_23967 = state_23943;
(statearr_23967[(16)] = inst_23873__$1);

(statearr_23967[(8)] = inst_23879);

(statearr_23967[(10)] = inst_23878);

(statearr_23967[(17)] = inst_23875);

(statearr_23967[(9)] = inst_23880);

(statearr_23967[(18)] = inst_23876);

return statearr_23967;
})();
var statearr_23968_24009 = state_23943__$1;
(statearr_23968_24009[(2)] = null);

(statearr_23968_24009[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (23))){
var inst_23873 = (state_23943[(16)]);
var inst_23887 = (state_23943[(7)]);
var inst_23886 = (state_23943[(13)]);
var inst_23879 = (state_23943[(8)]);
var inst_23878 = (state_23943[(10)]);
var inst_23875 = (state_23943[(17)]);
var inst_23880 = (state_23943[(9)]);
var inst_23876 = (state_23943[(18)]);
var inst_23912 = (inst_23879 + (1));
var inst_23913 = (function (){var r = inst_23887;
var vec__23870 = inst_23873;
var G__23869 = inst_23878;
var first__23872 = inst_23875;
var acc = inst_23880;
var n = inst_23879;
var vec__23882 = inst_23878;
var seq__23871 = inst_23876;
var s = inst_23886;
var seq__23883 = inst_23887;
var first__23884 = inst_23886;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23915 = [inst_23886];
var inst_23916 = (new cljs.core.PersistentVector(null,1,(5),inst_23914,inst_23915,null));
var inst_23917 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23918 = [limit];
var inst_23919 = cljs.core.PersistentHashMap.fromArrays(inst_23917,inst_23918);
var inst_23920 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23916,inst_23919);
var state_23943__$1 = (function (){var statearr_23969 = state_23943;
(statearr_23969[(11)] = inst_23913);

(statearr_23969[(19)] = inst_23912);

return statearr_23969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23943__$1,(27),inst_23920);
} else {
if((state_val_23944 === (19))){
var inst_23906 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
if(cljs.core.truth_(inst_23906)){
var statearr_23970_24010 = state_23943__$1;
(statearr_23970_24010[(1)] = (20));

} else {
var statearr_23971_24011 = state_23943__$1;
(statearr_23971_24011[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (11))){
var inst_23879 = (state_23943[(8)]);
var inst_23893 = (inst_23879 > limit);
var state_23943__$1 = state_23943;
var statearr_23973_24012 = state_23943__$1;
(statearr_23973_24012[(2)] = inst_23893);

(statearr_23973_24012[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (9))){
var inst_23891 = (state_23943[(15)]);
var inst_23891__$1 = limit;
var state_23943__$1 = (function (){var statearr_23974 = state_23943;
(statearr_23974[(15)] = inst_23891__$1);

return statearr_23974;
})();
if(cljs.core.truth_(inst_23891__$1)){
var statearr_23975_24013 = state_23943__$1;
(statearr_23975_24013[(1)] = (11));

} else {
var statearr_23976_24014 = state_23943__$1;
(statearr_23976_24014[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (5))){
var _ = (function (){var statearr_23977 = state_23943;
(statearr_23977[(4)] = cljs.core.rest((state_23943[(4)])));

return statearr_23977;
})();
var state_23943__$1 = state_23943;
var ex23972 = (state_23943__$1[(2)]);
var statearr_23978_24015 = state_23943__$1;
(statearr_23978_24015[(5)] = ex23972);


if((ex23972 instanceof Error)){
var statearr_23979_24016 = state_23943__$1;
(statearr_23979_24016[(1)] = (4));

(statearr_23979_24016[(5)] = null);

} else {
throw ex23972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (14))){
var inst_23880 = (state_23943[(9)]);
var state_23943__$1 = state_23943;
var statearr_23980_24017 = state_23943__$1;
(statearr_23980_24017[(2)] = inst_23880);

(statearr_23980_24017[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (26))){
var inst_23887 = (state_23943[(7)]);
var inst_23912 = (state_23943[(19)]);
var inst_23880 = (state_23943[(9)]);
var inst_23926 = (state_23943[(2)]);
var inst_23927 = fluree.db.util.async.throw_err(inst_23926);
var inst_23928 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23880,inst_23927);
var inst_23878 = inst_23887;
var inst_23879 = inst_23912;
var inst_23880__$1 = inst_23928;
var state_23943__$1 = (function (){var statearr_23981 = state_23943;
(statearr_23981[(8)] = inst_23879);

(statearr_23981[(10)] = inst_23878);

(statearr_23981[(9)] = inst_23880__$1);

return statearr_23981;
})();
var statearr_23982_24018 = state_23943__$1;
(statearr_23982_24018[(2)] = null);

(statearr_23982_24018[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (16))){
var inst_23936 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
var statearr_23983_24019 = state_23943__$1;
(statearr_23983_24019[(2)] = inst_23936);

(statearr_23983_24019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (10))){
var inst_23898 = (state_23943[(2)]);
var state_23943__$1 = state_23943;
if(cljs.core.truth_(inst_23898)){
var statearr_23984_24020 = state_23943__$1;
(statearr_23984_24020[(1)] = (14));

} else {
var statearr_23985_24021 = state_23943__$1;
(statearr_23985_24021[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (18))){
var inst_23901 = (state_23943[(12)]);
var state_23943__$1 = state_23943;
var statearr_23986_24022 = state_23943__$1;
(statearr_23986_24022[(2)] = inst_23901);

(statearr_23986_24022[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23944 === (8))){
var inst_23888 = (state_23943[(14)]);
var state_23943__$1 = state_23943;
var statearr_23987_24023 = state_23943__$1;
(statearr_23987_24023[(2)] = inst_23888);

(statearr_23987_24023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_23988 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23988[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_23988[(1)] = (1));

return statearr_23988;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_23943){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23943);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23989){var ex__2417__auto__ = e23989;
var statearr_23990_24024 = state_23943;
(statearr_23990_24024[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23943[(4)]))){
var statearr_23991_24025 = state_23943;
(statearr_23991_24025[(1)] = cljs.core.first((state_23943[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24026 = state_23943;
state_23943 = G__24026;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_23943){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_23943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23992 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23992[(6)] = c__2436__auto__);

return statearr_23992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24028 = arguments.length;
switch (G__24028) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24216){
var state_val_24217 = (state_24216[(1)]);
if((state_val_24217 === (7))){
var state_24216__$1 = state_24216;
var statearr_24218_24289 = state_24216__$1;
(statearr_24218_24289[(2)] = null);

(statearr_24218_24289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (20))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24099 = (state_24216[(2)]);
var inst_24100 = fluree.db.util.async.throw_err(inst_24099);
var inst_24101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24102 = [inst_24069];
var inst_24103 = (new cljs.core.PersistentVector(null,1,(5),inst_24101,inst_24102,null));
var inst_24104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24105 = [inst_24069,inst_24071];
var inst_24106 = (new cljs.core.PersistentVector(null,2,(5),inst_24104,inst_24105,null));
var inst_24107 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24103,cljs.core._LT_,inst_24106);
var state_24216__$1 = (function (){var statearr_24219 = state_24216;
(statearr_24219[(9)] = inst_24100);

return statearr_24219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(21),inst_24107);
} else {
if((state_val_24217 === (27))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24136 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24070) : inst_24088.call(null,cljs.core._GT__EQ_,inst_24070));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24136)){
var statearr_24220_24290 = state_24216__$1;
(statearr_24220_24290[(1)] = (30));

} else {
var statearr_24221_24291 = state_24216__$1;
(statearr_24221_24291[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (1))){
var state_24216__$1 = state_24216;
var statearr_24222_24292 = state_24216__$1;
(statearr_24222_24292[(2)] = null);

(statearr_24222_24292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (24))){
var inst_24185 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24223_24293 = state_24216__$1;
(statearr_24223_24293[(2)] = inst_24185);

(statearr_24223_24293[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (39))){
var inst_24175 = null;
var state_24216__$1 = state_24216;
var statearr_24224_24294 = state_24216__$1;
(statearr_24224_24294[(2)] = inst_24175);

(statearr_24224_24294[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (46))){
var inst_24196 = (state_24216[(12)]);
var inst_24062 = (state_24216[(13)]);
var inst_24054 = inst_24062;
var inst_24055 = inst_24196;
var state_24216__$1 = (function (){var statearr_24225 = state_24216;
(statearr_24225[(14)] = inst_24055);

(statearr_24225[(15)] = inst_24054);

return statearr_24225;
})();
var statearr_24226_24295 = state_24216__$1;
(statearr_24226_24295[(2)] = null);

(statearr_24226_24295[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (4))){
var inst_24029 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24227_24296 = state_24216__$1;
(statearr_24227_24296[(2)] = inst_24029);

(statearr_24227_24296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (15))){
var state_24216__$1 = state_24216;
var statearr_24228_24297 = state_24216__$1;
(statearr_24228_24297[(2)] = null);

(statearr_24228_24297[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (21))){
var inst_24100 = (state_24216[(9)]);
var inst_24109 = (state_24216[(2)]);
var inst_24110 = fluree.db.util.async.throw_err(inst_24109);
var inst_24111 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24100,inst_24110);
var state_24216__$1 = state_24216;
var statearr_24229_24298 = state_24216__$1;
(statearr_24229_24298[(2)] = inst_24111);

(statearr_24229_24298[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (31))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24149 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24070) : inst_24088.call(null,cljs.core._LT_,inst_24070));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24149)){
var statearr_24230_24299 = state_24216__$1;
(statearr_24230_24299[(1)] = (34));

} else {
var statearr_24231_24300 = state_24216__$1;
(statearr_24231_24300[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (32))){
var inst_24181 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24232_24301 = state_24216__$1;
(statearr_24232_24301[(2)] = inst_24181);

(statearr_24232_24301[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (40))){
var inst_24177 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24233_24302 = state_24216__$1;
(statearr_24233_24302[(2)] = inst_24177);

(statearr_24233_24302[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (33))){
var inst_24146 = (state_24216[(2)]);
var inst_24147 = fluree.db.util.async.throw_err(inst_24146);
var state_24216__$1 = state_24216;
var statearr_24234_24303 = state_24216__$1;
(statearr_24234_24303[(2)] = inst_24147);

(statearr_24234_24303[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (13))){
var inst_24206 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24235_24304 = state_24216__$1;
(statearr_24235_24304[(2)] = inst_24206);

(statearr_24235_24304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (22))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24116 = [inst_24069,inst_24071];
var inst_24117 = (new cljs.core.PersistentVector(null,2,(5),inst_24115,inst_24116,null));
var inst_24118 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24117);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(25),inst_24118);
} else {
if((state_val_24217 === (36))){
var inst_24179 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24236_24305 = state_24216__$1;
(statearr_24236_24305[(2)] = inst_24179);

(statearr_24236_24305[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (41))){
var inst_24172 = (state_24216[(2)]);
var inst_24173 = fluree.db.util.async.throw_err(inst_24172);
var state_24216__$1 = state_24216;
var statearr_24237_24306 = state_24216__$1;
(statearr_24237_24306[(2)] = inst_24173);

(statearr_24237_24306[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (43))){
var inst_24188 = (state_24216[(16)]);
var inst_24055 = (state_24216[(14)]);
var inst_24189 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24055,inst_24188);
var state_24216__$1 = state_24216;
var statearr_24238_24307 = state_24216__$1;
(statearr_24238_24307[(2)] = inst_24189);

(statearr_24238_24307[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (29))){
var inst_24133 = (state_24216[(2)]);
var inst_24134 = fluree.db.util.async.throw_err(inst_24133);
var state_24216__$1 = state_24216;
var statearr_24239_24308 = state_24216__$1;
(statearr_24239_24308[(2)] = inst_24134);

(statearr_24239_24308[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (44))){
var inst_24188 = (state_24216[(16)]);
var inst_24055 = (state_24216[(14)]);
var inst_24191 = cljs.core.PersistentHashSet.EMPTY;
var inst_24192 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24191,inst_24188);
var inst_24193 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24055,inst_24192);
var state_24216__$1 = state_24216;
var statearr_24240_24309 = state_24216__$1;
(statearr_24240_24309[(2)] = inst_24193);

(statearr_24240_24309[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (6))){
var inst_24040 = (state_24216[(17)]);
var inst_24050 = cljs.core.seq(inst_24040);
var inst_24051 = cljs.core.first(inst_24050);
var inst_24052 = cljs.core.next(inst_24050);
var inst_24053 = cljs.core.PersistentHashSet.EMPTY;
var inst_24054 = inst_24040;
var inst_24055 = inst_24053;
var state_24216__$1 = (function (){var statearr_24241 = state_24216;
(statearr_24241[(18)] = inst_24052);

(statearr_24241[(19)] = inst_24051);

(statearr_24241[(14)] = inst_24055);

(statearr_24241[(15)] = inst_24054);

return statearr_24241;
})();
var statearr_24242_24310 = state_24216__$1;
(statearr_24242_24310[(2)] = null);

(statearr_24242_24310[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (28))){
var inst_24183 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24243_24311 = state_24216__$1;
(statearr_24243_24311[(2)] = inst_24183);

(statearr_24243_24311[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (25))){
var inst_24120 = (state_24216[(2)]);
var inst_24121 = fluree.db.util.async.throw_err(inst_24120);
var state_24216__$1 = state_24216;
var statearr_24244_24312 = state_24216__$1;
(statearr_24244_24312[(2)] = inst_24121);

(statearr_24244_24312[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (34))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24152 = [inst_24069];
var inst_24153 = (new cljs.core.PersistentVector(null,1,(5),inst_24151,inst_24152,null));
var inst_24154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24155 = [inst_24069,inst_24071];
var inst_24156 = (new cljs.core.PersistentVector(null,2,(5),inst_24154,inst_24155,null));
var inst_24157 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24153,cljs.core._LT_,inst_24156);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(37),inst_24157);
} else {
if((state_val_24217 === (17))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24092 = [inst_24069,inst_24071];
var inst_24093 = (new cljs.core.PersistentVector(null,2,(5),inst_24091,inst_24092,null));
var inst_24094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24095 = [inst_24069];
var inst_24096 = (new cljs.core.PersistentVector(null,1,(5),inst_24094,inst_24095,null));
var inst_24097 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24093,cljs.core._LT__EQ_,inst_24096);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(20),inst_24097);
} else {
if((state_val_24217 === (3))){
var inst_24214 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24216__$1,inst_24214);
} else {
if((state_val_24217 === (12))){
var inst_24069 = (state_24216[(8)]);
var inst_24061 = (state_24216[(20)]);
var inst_24069__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(0),null);
var inst_24070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(1),null);
var inst_24071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(2),null);
var inst_24072 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24069__$1);
var inst_24073 = cljs.core.not(inst_24072);
var state_24216__$1 = (function (){var statearr_24245 = state_24216;
(statearr_24245[(7)] = inst_24071);

(statearr_24245[(8)] = inst_24069__$1);

(statearr_24245[(10)] = inst_24070);

return statearr_24245;
})();
if(inst_24073){
var statearr_24246_24313 = state_24216__$1;
(statearr_24246_24313[(1)] = (14));

} else {
var statearr_24247_24314 = state_24216__$1;
(statearr_24247_24314[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (2))){
var inst_24040 = (state_24216[(17)]);
var _ = (function (){var statearr_24248 = state_24216;
(statearr_24248[(4)] = cljs.core.cons((5),(state_24216[(4)])));

return statearr_24248;
})();
var inst_24038 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24038,(0),null);
var inst_24040__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24038,(1),null);
var inst_24041 = cljs.core.not_empty(inst_24040__$1);
var state_24216__$1 = (function (){var statearr_24249 = state_24216;
(statearr_24249[(17)] = inst_24040__$1);

(statearr_24249[(21)] = inst_24039);

return statearr_24249;
})();
if(cljs.core.truth_(inst_24041)){
var statearr_24250_24315 = state_24216__$1;
(statearr_24250_24315[(1)] = (6));

} else {
var statearr_24251_24316 = state_24216__$1;
(statearr_24251_24316[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (23))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24123 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24070) : inst_24088.call(null,cljs.core._GT_,inst_24070));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24123)){
var statearr_24252_24317 = state_24216__$1;
(statearr_24252_24317[(1)] = (26));

} else {
var statearr_24253_24318 = state_24216__$1;
(statearr_24253_24318[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (47))){
var inst_24204 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24254_24319 = state_24216__$1;
(statearr_24254_24319[(2)] = inst_24204);

(statearr_24254_24319[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (35))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24162 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24070) : inst_24088.call(null,cljs.core._LT__EQ_,inst_24070));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24162)){
var statearr_24255_24320 = state_24216__$1;
(statearr_24255_24320[(1)] = (38));

} else {
var statearr_24256_24321 = state_24216__$1;
(statearr_24256_24321[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (19))){
var inst_24039 = (state_24216[(21)]);
var inst_24187 = (state_24216[(2)]);
var inst_24188 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24187);
var state_24216__$1 = (function (){var statearr_24257 = state_24216;
(statearr_24257[(16)] = inst_24188);

return statearr_24257;
})();
var G__24258_24322 = inst_24039;
var G__24258_24323__$1 = (((G__24258_24322 instanceof cljs.core.Keyword))?G__24258_24322.fqn:null);
switch (G__24258_24323__$1) {
case "or":
var statearr_24259_24325 = state_24216__$1;
(statearr_24259_24325[(1)] = (43));


break;
case "and":
var statearr_24260_24326 = state_24216__$1;
(statearr_24260_24326[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24258_24323__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (11))){
var inst_24055 = (state_24216[(14)]);
var state_24216__$1 = state_24216;
var statearr_24262_24327 = state_24216__$1;
(statearr_24262_24327[(2)] = inst_24055);

(statearr_24262_24327[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (9))){
var inst_24061 = (state_24216[(20)]);
var inst_24054 = (state_24216[(15)]);
var inst_24060 = cljs.core.seq(inst_24054);
var inst_24061__$1 = cljs.core.first(inst_24060);
var inst_24062 = cljs.core.next(inst_24060);
var inst_24063 = cljs.core.not(inst_24061__$1);
var state_24216__$1 = (function (){var statearr_24263 = state_24216;
(statearr_24263[(13)] = inst_24062);

(statearr_24263[(20)] = inst_24061__$1);

return statearr_24263;
})();
if(inst_24063){
var statearr_24264_24328 = state_24216__$1;
(statearr_24264_24328[(1)] = (11));

} else {
var statearr_24265_24329 = state_24216__$1;
(statearr_24265_24329[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (5))){
var _ = (function (){var statearr_24266 = state_24216;
(statearr_24266[(4)] = cljs.core.rest((state_24216[(4)])));

return statearr_24266;
})();
var state_24216__$1 = state_24216;
var ex24261 = (state_24216__$1[(2)]);
var statearr_24267_24330 = state_24216__$1;
(statearr_24267_24330[(5)] = ex24261);


if((ex24261 instanceof Error)){
var statearr_24268_24331 = state_24216__$1;
(statearr_24268_24331[(1)] = (4));

(statearr_24268_24331[(5)] = null);

} else {
throw ex24261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (14))){
var inst_24069 = (state_24216[(8)]);
var inst_24075 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24069);
var inst_24076 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24075)].join('');
var inst_24077 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24078 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24079 = cljs.core.PersistentHashMap.fromArrays(inst_24077,inst_24078);
var inst_24080 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24076,inst_24079);
var inst_24081 = (function(){throw inst_24080})();
var state_24216__$1 = state_24216;
var statearr_24269_24332 = state_24216__$1;
(statearr_24269_24332[(2)] = inst_24081);

(statearr_24269_24332[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (45))){
var inst_24196 = (state_24216[(12)]);
var state_24216__$1 = state_24216;
var statearr_24270_24333 = state_24216__$1;
(statearr_24270_24333[(2)] = inst_24196);

(statearr_24270_24333[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (26))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24126 = [inst_24069,inst_24071];
var inst_24127 = (new cljs.core.PersistentVector(null,2,(5),inst_24125,inst_24126,null));
var inst_24128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24129 = [inst_24069];
var inst_24130 = (new cljs.core.PersistentVector(null,1,(5),inst_24128,inst_24129,null));
var inst_24131 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24127,cljs.core._LT__EQ_,inst_24130);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(29),inst_24131);
} else {
if((state_val_24217 === (16))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24084 = (state_24216[(2)]);
var inst_24088__$1 = cljs.core.identical_QMARK_;
var inst_24089 = (inst_24088__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24088__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24070) : inst_24088__$1.call(null,cljs.core.not_EQ_,inst_24070));
var state_24216__$1 = (function (){var statearr_24271 = state_24216;
(statearr_24271[(22)] = inst_24084);

(statearr_24271[(11)] = inst_24088__$1);

return statearr_24271;
})();
if(cljs.core.truth_(inst_24089)){
var statearr_24272_24334 = state_24216__$1;
(statearr_24272_24334[(1)] = (17));

} else {
var statearr_24273_24335 = state_24216__$1;
(statearr_24273_24335[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (38))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24165 = [inst_24069];
var inst_24166 = (new cljs.core.PersistentVector(null,1,(5),inst_24164,inst_24165,null));
var inst_24167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24168 = [inst_24069,inst_24071];
var inst_24169 = (new cljs.core.PersistentVector(null,2,(5),inst_24167,inst_24168,null));
var inst_24170 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24166,cljs.core._LT__EQ_,inst_24169);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(41),inst_24170);
} else {
if((state_val_24217 === (30))){
var inst_24071 = (state_24216[(7)]);
var inst_24069 = (state_24216[(8)]);
var inst_24138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24139 = [inst_24069,inst_24071];
var inst_24140 = (new cljs.core.PersistentVector(null,2,(5),inst_24138,inst_24139,null));
var inst_24141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24142 = [inst_24069];
var inst_24143 = (new cljs.core.PersistentVector(null,1,(5),inst_24141,inst_24142,null));
var inst_24144 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24140,cljs.core._LT__EQ_,inst_24143);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(33),inst_24144);
} else {
if((state_val_24217 === (10))){
var inst_24208 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24274_24336 = state_24216__$1;
(statearr_24274_24336[(2)] = inst_24208);

(statearr_24274_24336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (18))){
var inst_24070 = (state_24216[(10)]);
var inst_24088 = (state_24216[(11)]);
var inst_24113 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24070) : inst_24088.call(null,cljs.core._EQ_,inst_24070));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24113)){
var statearr_24275_24337 = state_24216__$1;
(statearr_24275_24337[(1)] = (22));

} else {
var statearr_24276_24338 = state_24216__$1;
(statearr_24276_24338[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (42))){
var inst_24196 = (state_24216[(12)]);
var inst_24039 = (state_24216[(21)]);
var inst_24196__$1 = (state_24216[(2)]);
var inst_24197 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24039);
var inst_24198 = cljs.core.empty_QMARK_(inst_24196__$1);
var inst_24199 = ((inst_24197) && (inst_24198));
var state_24216__$1 = (function (){var statearr_24277 = state_24216;
(statearr_24277[(12)] = inst_24196__$1);

return statearr_24277;
})();
if(cljs.core.truth_(inst_24199)){
var statearr_24278_24339 = state_24216__$1;
(statearr_24278_24339[(1)] = (45));

} else {
var statearr_24279_24340 = state_24216__$1;
(statearr_24279_24340[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (37))){
var inst_24159 = (state_24216[(2)]);
var inst_24160 = fluree.db.util.async.throw_err(inst_24159);
var state_24216__$1 = state_24216;
var statearr_24280_24341 = state_24216__$1;
(statearr_24280_24341[(2)] = inst_24160);

(statearr_24280_24341[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24217 === (8))){
var inst_24211 = (state_24216[(2)]);
var _ = (function (){var statearr_24281 = state_24216;
(statearr_24281[(4)] = cljs.core.rest((state_24216[(4)])));

return statearr_24281;
})();
var state_24216__$1 = state_24216;
var statearr_24282_24342 = state_24216__$1;
(statearr_24282_24342[(2)] = inst_24211);

(statearr_24282_24342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_24283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24283[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_24283[(1)] = (1));

return statearr_24283;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_24216){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24216);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24284){var ex__2417__auto__ = e24284;
var statearr_24285_24343 = state_24216;
(statearr_24285_24343[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24216[(4)]))){
var statearr_24286_24344 = state_24216;
(statearr_24286_24344[(1)] = cljs.core.first((state_24216[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24345 = state_24216;
state_24216 = G__24345;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_24216){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_24216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24287 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24287[(6)] = c__2436__auto__);

return statearr_24287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__24347,offset,limit){
var map__24348 = p__24347;
var map__24348__$1 = (((((!((map__24348 == null))))?(((((map__24348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24348.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24348):map__24348);
var res = map__24348__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24348__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24348__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24350 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24350,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24350,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__24353 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__24346_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24346_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__24353__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__24353):G__24353);
var G__24353__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__24353__$1):G__24353__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__24353__$2);
} else {
return G__24353__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__24354_SHARP_){
return ((typeof p1__24354_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24354_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24355_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24355_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24359 = vars;
var vec__24360 = G__24359;
var seq__24361 = cljs.core.seq(vec__24360);
var first__24362 = cljs.core.first(seq__24361);
var seq__24361__$1 = cljs.core.next(seq__24361);
var var$ = first__24362;
var r = seq__24361__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24359__$1 = G__24359;
var all_vars__$1 = all_vars;
while(true){
var vec__24367 = G__24359__$1;
var seq__24368 = cljs.core.seq(vec__24367);
var first__24369 = cljs.core.first(seq__24368);
var seq__24368__$1 = cljs.core.next(seq__24368);
var var$__$1 = first__24369;
var r__$1 = seq__24368__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24370 = cljs.core.set(all_vars__$2);
return (fexpr__24370.cljs$core$IFn$_invoke$arity$1 ? fexpr__24370.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24370.call(null,var$__$1));
})())){
var G__24371 = r__$1;
var G__24372 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24359__$1 = G__24371;
all_vars__$1 = G__24372;
continue;
} else {
var G__24373 = r__$1;
var G__24374 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24359__$1 = G__24373;
all_vars__$1 = G__24374;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24409){
var state_val_24410 = (state_24409[(1)]);
if((state_val_24410 === (1))){
var inst_24382 = functionArray;
var inst_24383 = cljs.core.seq(inst_24382);
var inst_24384 = cljs.core.first(inst_24383);
var inst_24385 = cljs.core.next(inst_24383);
var inst_24386 = cljs.core.PersistentVector.EMPTY;
var inst_24387 = inst_24382;
var inst_24388 = inst_24386;
var state_24409__$1 = (function (){var statearr_24411 = state_24409;
(statearr_24411[(7)] = inst_24384);

(statearr_24411[(8)] = inst_24388);

(statearr_24411[(9)] = inst_24385);

(statearr_24411[(10)] = inst_24387);

return statearr_24411;
})();
var statearr_24412_24425 = state_24409__$1;
(statearr_24412_24425[(2)] = null);

(statearr_24412_24425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24410 === (2))){
var inst_24394 = (state_24409[(11)]);
var inst_24387 = (state_24409[(10)]);
var inst_24393 = cljs.core.seq(inst_24387);
var inst_24394__$1 = cljs.core.first(inst_24393);
var inst_24395 = cljs.core.next(inst_24393);
var state_24409__$1 = (function (){var statearr_24413 = state_24409;
(statearr_24413[(11)] = inst_24394__$1);

(statearr_24413[(12)] = inst_24395);

return statearr_24413;
})();
if(cljs.core.truth_(inst_24394__$1)){
var statearr_24414_24426 = state_24409__$1;
(statearr_24414_24426[(1)] = (4));

} else {
var statearr_24415_24427 = state_24409__$1;
(statearr_24415_24427[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24410 === (3))){
var inst_24407 = (state_24409[(2)]);
var state_24409__$1 = state_24409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24409__$1,inst_24407);
} else {
if((state_val_24410 === (4))){
var inst_24394 = (state_24409[(11)]);
var inst_24397 = (inst_24394.cljs$core$IFn$_invoke$arity$1 ? inst_24394.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24394.call(null,tuple));
var state_24409__$1 = state_24409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24409__$1,(7),inst_24397);
} else {
if((state_val_24410 === (5))){
var inst_24388 = (state_24409[(8)]);
var state_24409__$1 = state_24409;
var statearr_24416_24428 = state_24409__$1;
(statearr_24416_24428[(2)] = inst_24388);

(statearr_24416_24428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24410 === (6))){
var inst_24405 = (state_24409[(2)]);
var state_24409__$1 = state_24409;
var statearr_24417_24429 = state_24409__$1;
(statearr_24417_24429[(2)] = inst_24405);

(statearr_24417_24429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24410 === (7))){
var inst_24388 = (state_24409[(8)]);
var inst_24395 = (state_24409[(12)]);
var inst_24399 = (state_24409[(2)]);
var inst_24400 = fluree.db.util.async.throw_err(inst_24399);
var inst_24401 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24388,inst_24400);
var inst_24387 = inst_24395;
var inst_24388__$1 = inst_24401;
var state_24409__$1 = (function (){var statearr_24418 = state_24409;
(statearr_24418[(8)] = inst_24388__$1);

(statearr_24418[(10)] = inst_24387);

return statearr_24418;
})();
var statearr_24419_24430 = state_24409__$1;
(statearr_24419_24430[(2)] = null);

(statearr_24419_24430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0 = (function (){
var statearr_24420 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24420[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__);

(statearr_24420[(1)] = (1));

return statearr_24420;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1 = (function (state_24409){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24409);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24421){var ex__2417__auto__ = e24421;
var statearr_24422_24431 = state_24409;
(statearr_24422_24431[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24409[(4)]))){
var statearr_24423_24432 = state_24409;
(statearr_24423_24432[(1)] = cljs.core.first((state_24409[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24433 = state_24409;
state_24409 = G__24433;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__ = function(state_24409){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1.call(this,state_24409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24424 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24424[(6)] = c__2436__auto__);

return statearr_24424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__24435,headers,vars,opts){
var map__24436 = p__24435;
var map__24436__$1 = (((((!((map__24436 == null))))?(((((map__24436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24436):map__24436);
var select_spec = map__24436__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24436__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24436__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24436__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24436__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24523){
var state_val_24524 = (state_24523[(1)]);
if((state_val_24524 === (7))){
var state_24523__$1 = state_24523;
var statearr_24525_24667 = state_24523__$1;
(statearr_24525_24667[(2)] = null);

(statearr_24525_24667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (1))){
var state_24523__$1 = state_24523;
var statearr_24526_24668 = state_24523__$1;
(statearr_24526_24668[(2)] = null);

(statearr_24526_24668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (4))){
var inst_24438 = (state_24523[(2)]);
var state_24523__$1 = state_24523;
var statearr_24527_24669 = state_24523__$1;
(statearr_24527_24669[(2)] = inst_24438);

(statearr_24527_24669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (15))){
var inst_24512 = (state_24523[(2)]);
var inst_24513 = fluree.db.util.async.throw_err(inst_24512);
var state_24523__$1 = state_24523;
var statearr_24528_24670 = state_24523__$1;
(statearr_24528_24670[(2)] = inst_24513);

(statearr_24528_24670[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (13))){
var inst_24456 = (state_24523[(7)]);
var inst_24448 = (state_24523[(8)]);
var inst_24515 = (function (){var pp = inst_24448;
var functionArray = inst_24456;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24434_SHARP_){
return (p1__24434_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__24434_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__24434_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_24516 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24515,tuples);
var state_24523__$1 = state_24523;
var statearr_24529_24671 = state_24523__$1;
(statearr_24529_24671[(2)] = inst_24516);

(statearr_24529_24671[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (6))){
var inst_24445 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_24523__$1 = state_24523;
var statearr_24530_24672 = state_24523__$1;
(statearr_24530_24672[(2)] = inst_24445);

(statearr_24530_24672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (3))){
var inst_24521 = (state_24523[(2)]);
var state_24523__$1 = state_24523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24523__$1,inst_24521);
} else {
if((state_val_24524 === (12))){
var inst_24456 = (state_24523[(7)]);
var inst_24448 = (state_24523[(8)]);
var inst_24508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_24509 = (function (){var pp = inst_24448;
var functionArray = inst_24456;
var c__2436__auto____$1 = inst_24508;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24506){
var state_val_24507 = (state_24506[(1)]);
if((state_val_24507 === (7))){
var inst_24482 = (state_24506[(2)]);
var inst_24483 = fluree.db.util.async.throw_err(inst_24482);
var state_24506__$1 = (function (){var statearr_24531 = state_24506;
(statearr_24531[(7)] = inst_24483);

return statearr_24531;
})();
if(cljs.core.truth_(pp)){
var statearr_24532_24673 = state_24506__$1;
(statearr_24532_24673[(1)] = (8));

} else {
var statearr_24533_24674 = state_24506__$1;
(statearr_24533_24674[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (1))){
var inst_24465 = tuples;
var inst_24466 = cljs.core.seq(inst_24465);
var inst_24467 = cljs.core.first(inst_24466);
var inst_24468 = cljs.core.next(inst_24466);
var inst_24469 = cljs.core.PersistentVector.EMPTY;
var inst_24470 = inst_24465;
var inst_24471 = inst_24469;
var state_24506__$1 = (function (){var statearr_24534 = state_24506;
(statearr_24534[(8)] = inst_24470);

(statearr_24534[(9)] = inst_24468);

(statearr_24534[(10)] = inst_24471);

(statearr_24534[(11)] = inst_24467);

return statearr_24534;
})();
var statearr_24535_24675 = state_24506__$1;
(statearr_24535_24675[(2)] = null);

(statearr_24535_24675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (4))){
var inst_24477 = (state_24506[(12)]);
var inst_24480 = fluree.db.query.fql.format_tuple(functionArray,inst_24477);
var state_24506__$1 = state_24506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24506__$1,(7),inst_24480);
} else {
if((state_val_24507 === (15))){
var state_24506__$1 = state_24506;
var statearr_24536_24676 = state_24506__$1;
(statearr_24536_24676[(2)] = null);

(statearr_24536_24676[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (13))){
var inst_24495 = (state_24506[(2)]);
var state_24506__$1 = state_24506;
var statearr_24537_24677 = state_24506__$1;
(statearr_24537_24677[(2)] = inst_24495);

(statearr_24537_24677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (6))){
var inst_24502 = (state_24506[(2)]);
var state_24506__$1 = state_24506;
var statearr_24538_24678 = state_24506__$1;
(statearr_24538_24678[(2)] = inst_24502);

(statearr_24538_24678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (3))){
var inst_24504 = (state_24506[(2)]);
var state_24506__$1 = state_24506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24506__$1,inst_24504);
} else {
if((state_val_24507 === (12))){
var state_24506__$1 = state_24506;
var statearr_24539_24679 = state_24506__$1;
(statearr_24539_24679[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (2))){
var inst_24470 = (state_24506[(8)]);
var inst_24477 = (state_24506[(12)]);
var inst_24476 = cljs.core.seq(inst_24470);
var inst_24477__$1 = cljs.core.first(inst_24476);
var inst_24478 = cljs.core.next(inst_24476);
var state_24506__$1 = (function (){var statearr_24541 = state_24506;
(statearr_24541[(12)] = inst_24477__$1);

(statearr_24541[(13)] = inst_24478);

return statearr_24541;
})();
if(cljs.core.truth_(inst_24477__$1)){
var statearr_24542_24680 = state_24506__$1;
(statearr_24542_24680[(1)] = (4));

} else {
var statearr_24543_24681 = state_24506__$1;
(statearr_24543_24681[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (11))){
var inst_24483 = (state_24506[(7)]);
var state_24506__$1 = state_24506;
var statearr_24544_24682 = state_24506__$1;
(statearr_24544_24682[(2)] = inst_24483);

(statearr_24544_24682[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (9))){
var state_24506__$1 = state_24506;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24545_24683 = state_24506__$1;
(statearr_24545_24683[(1)] = (11));

} else {
var statearr_24546_24684 = state_24506__$1;
(statearr_24546_24684[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (5))){
var inst_24471 = (state_24506[(10)]);
var state_24506__$1 = state_24506;
var statearr_24547_24685 = state_24506__$1;
(statearr_24547_24685[(2)] = inst_24471);

(statearr_24547_24685[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (14))){
var inst_24483 = (state_24506[(7)]);
var inst_24490 = cljs.core.first(inst_24483);
var state_24506__$1 = state_24506;
var statearr_24548_24686 = state_24506__$1;
(statearr_24548_24686[(2)] = inst_24490);

(statearr_24548_24686[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (16))){
var inst_24493 = (state_24506[(2)]);
var state_24506__$1 = state_24506;
var statearr_24549_24687 = state_24506__$1;
(statearr_24549_24687[(2)] = inst_24493);

(statearr_24549_24687[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (10))){
var inst_24471 = (state_24506[(10)]);
var inst_24478 = (state_24506[(13)]);
var inst_24497 = (state_24506[(2)]);
var inst_24498 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24471,inst_24497);
var inst_24470 = inst_24478;
var inst_24471__$1 = inst_24498;
var state_24506__$1 = (function (){var statearr_24550 = state_24506;
(statearr_24550[(8)] = inst_24470);

(statearr_24550[(10)] = inst_24471__$1);

return statearr_24550;
})();
var statearr_24551_24688 = state_24506__$1;
(statearr_24551_24688[(2)] = null);

(statearr_24551_24688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24507 === (8))){
var inst_24483 = (state_24506[(7)]);
var inst_24485 = cljs.core.zipmap(pp,inst_24483);
var state_24506__$1 = state_24506;
var statearr_24552_24689 = state_24506__$1;
(statearr_24552_24689[(2)] = inst_24485);

(statearr_24552_24689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24553[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24553[(1)] = (1));

return statearr_24553;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_24506){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24506);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24554){var ex__2417__auto__ = e24554;
var statearr_24555_24690 = state_24506;
(statearr_24555_24690[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24506[(4)]))){
var statearr_24556_24691 = state_24506;
(statearr_24556_24691[(1)] = cljs.core.first((state_24506[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24692 = state_24506;
state_24506 = G__24692;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_24506){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_24506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24557 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24557[(6)] = c__2436__auto____$1);

return statearr_24557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_24510 = cljs.core.async.impl.dispatch.run(inst_24509);
var state_24523__$1 = (function (){var statearr_24558 = state_24523;
(statearr_24558[(9)] = inst_24510);

return statearr_24558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24523__$1,(15),inst_24508);
} else {
if((state_val_24524 === (2))){
var _ = (function (){var statearr_24559 = state_24523;
(statearr_24559[(4)] = cljs.core.cons((5),(state_24523[(4)])));

return statearr_24559;
})();
var state_24523__$1 = state_24523;
if(cljs.core.truth_(prettyPrint)){
var statearr_24560_24693 = state_24523__$1;
(statearr_24560_24693[(1)] = (6));

} else {
var statearr_24561_24694 = state_24523__$1;
(statearr_24561_24694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (11))){
var inst_24456 = (state_24523[(2)]);
var state_24523__$1 = (function (){var statearr_24563 = state_24523;
(statearr_24563[(7)] = inst_24456);

return statearr_24563;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24564_24695 = state_24523__$1;
(statearr_24564_24695[(1)] = (12));

} else {
var statearr_24565_24696 = state_24523__$1;
(statearr_24565_24696[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (9))){
var inst_24448 = (state_24523[(8)]);
var inst_24450 = (function (){var pp = inst_24448;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2436__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24600){
var state_val_24601 = (state_24600[(1)]);
if((state_val_24601 === (7))){
var state_24600__$1 = state_24600;
var statearr_24602_24697 = state_24600__$1;
(statearr_24602_24697[(2)] = null);

(statearr_24602_24697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (1))){
var state_24600__$1 = state_24600;
var statearr_24603_24698 = state_24600__$1;
(statearr_24603_24698[(2)] = null);

(statearr_24603_24698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (4))){
var inst_24566 = (state_24600[(2)]);
var state_24600__$1 = state_24600;
var statearr_24604_24699 = state_24600__$1;
(statearr_24604_24699[(2)] = inst_24566);

(statearr_24604_24699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (6))){
var inst_24576 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24577 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_24578 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_24579 = [inst_24577,inst_24578,opts];
var inst_24580 = cljs.core.PersistentHashMap.fromArrays(inst_24576,inst_24579);
var inst_24581 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24580) : fluree.db.query.fql.query.call(null,db,inst_24580));
var state_24600__$1 = state_24600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24600__$1,(9),inst_24581);
} else {
if((state_val_24601 === (3))){
var inst_24598 = (state_24600[(2)]);
var state_24600__$1 = state_24600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24600__$1,inst_24598);
} else {
if((state_val_24601 === (12))){
var inst_24592 = (state_24600[(2)]);
var state_24600__$1 = state_24600;
var statearr_24605_24700 = state_24600__$1;
(statearr_24605_24700[(2)] = inst_24592);

(statearr_24605_24700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (2))){
var _ = (function (){var statearr_24606 = state_24600;
(statearr_24606[(4)] = cljs.core.cons((5),(state_24600[(4)])));

return statearr_24606;
})();
var inst_24572 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_24600__$1 = state_24600;
if(cljs.core.truth_(inst_24572)){
var statearr_24607_24701 = state_24600__$1;
(statearr_24607_24701[(1)] = (6));

} else {
var statearr_24608_24702 = state_24600__$1;
(statearr_24608_24702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (11))){
var inst_24587 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24588 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_24589 = [inst_24588];
var inst_24590 = cljs.core.PersistentHashMap.fromArrays(inst_24587,inst_24589);
var state_24600__$1 = state_24600;
var statearr_24610_24703 = state_24600__$1;
(statearr_24610_24703[(2)] = inst_24590);

(statearr_24610_24703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (9))){
var inst_24584 = (state_24600[(7)]);
var inst_24583 = (state_24600[(2)]);
var inst_24584__$1 = fluree.db.util.async.throw_err(inst_24583);
var state_24600__$1 = (function (){var statearr_24611 = state_24600;
(statearr_24611[(7)] = inst_24584__$1);

return statearr_24611;
})();
if(cljs.core.truth_(inst_24584__$1)){
var statearr_24612_24704 = state_24600__$1;
(statearr_24612_24704[(1)] = (10));

} else {
var statearr_24613_24705 = state_24600__$1;
(statearr_24613_24705[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (5))){
var _ = (function (){var statearr_24614 = state_24600;
(statearr_24614[(4)] = cljs.core.rest((state_24600[(4)])));

return statearr_24614;
})();
var state_24600__$1 = state_24600;
var ex24609 = (state_24600__$1[(2)]);
var statearr_24615_24706 = state_24600__$1;
(statearr_24615_24706[(5)] = ex24609);


if((ex24609 instanceof Error)){
var statearr_24616_24707 = state_24600__$1;
(statearr_24616_24707[(1)] = (4));

(statearr_24616_24707[(5)] = null);

} else {
throw ex24609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (10))){
var inst_24584 = (state_24600[(7)]);
var state_24600__$1 = state_24600;
var statearr_24617_24708 = state_24600__$1;
(statearr_24617_24708[(2)] = inst_24584);

(statearr_24617_24708[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24601 === (8))){
var inst_24595 = (state_24600[(2)]);
var _ = (function (){var statearr_24618 = state_24600;
(statearr_24618[(4)] = cljs.core.rest((state_24600[(4)])));

return statearr_24618;
})();
var state_24600__$1 = state_24600;
var statearr_24619_24709 = state_24600__$1;
(statearr_24619_24709[(2)] = inst_24595);

(statearr_24619_24709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24620 = [null,null,null,null,null,null,null,null];
(statearr_24620[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24620[(1)] = (1));

return statearr_24620;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_24600){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24600);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24621){var ex__2417__auto__ = e24621;
var statearr_24622_24710 = state_24600;
(statearr_24622_24710[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24600[(4)]))){
var statearr_24623_24711 = state_24600;
(statearr_24623_24711[(1)] = cljs.core.first((state_24600[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24712 = state_24600;
state_24600 = G__24712;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_24600){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_24600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24624 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24624[(6)] = c__2436__auto____$1);

return statearr_24624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto____$1;
});
} else {
return (function (tuple){
var c__2436__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24636){
var state_val_24637 = (state_24636[(1)]);
if((state_val_24637 === (1))){
var state_24636__$1 = state_24636;
var statearr_24638_24713 = state_24636__$1;
(statearr_24638_24713[(2)] = null);

(statearr_24638_24713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24637 === (2))){
var _ = (function (){var statearr_24639 = state_24636;
(statearr_24639[(4)] = cljs.core.cons((5),(state_24636[(4)])));

return statearr_24639;
})();
var inst_24631 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_24640 = state_24636;
(statearr_24640[(4)] = cljs.core.rest((state_24636[(4)])));

return statearr_24640;
})();
var state_24636__$1 = state_24636;
var statearr_24641_24714 = state_24636__$1;
(statearr_24641_24714[(2)] = inst_24631);

(statearr_24641_24714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24637 === (3))){
var inst_24634 = (state_24636[(2)]);
var state_24636__$1 = state_24636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24636__$1,inst_24634);
} else {
if((state_val_24637 === (4))){
var inst_24625 = (state_24636[(2)]);
var state_24636__$1 = state_24636;
var statearr_24643_24715 = state_24636__$1;
(statearr_24643_24715[(2)] = inst_24625);

(statearr_24643_24715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24637 === (5))){
var _ = (function (){var statearr_24644 = state_24636;
(statearr_24644[(4)] = cljs.core.rest((state_24636[(4)])));

return statearr_24644;
})();
var state_24636__$1 = state_24636;
var ex24642 = (state_24636__$1[(2)]);
var statearr_24645_24716 = state_24636__$1;
(statearr_24645_24716[(5)] = ex24642);


if((ex24642 instanceof Error)){
var statearr_24646_24717 = state_24636__$1;
(statearr_24646_24717[(1)] = (4));

(statearr_24646_24717[(5)] = null);

} else {
throw ex24642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24647 = [null,null,null,null,null,null,null];
(statearr_24647[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24647[(1)] = (1));

return statearr_24647;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_24636){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24636);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24648){var ex__2417__auto__ = e24648;
var statearr_24649_24718 = state_24636;
(statearr_24649_24718[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24636[(4)]))){
var statearr_24650_24719 = state_24636;
(statearr_24650_24719[(1)] = cljs.core.first((state_24636[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24720 = state_24636;
state_24636 = G__24720;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_24636){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_24636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24651 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24651[(6)] = c__2436__auto____$1);

return statearr_24651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto____$1;
});
}
});
})();
var inst_24451 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24450,select);
var state_24523__$1 = state_24523;
var statearr_24652_24721 = state_24523__$1;
(statearr_24652_24721[(2)] = inst_24451);

(statearr_24652_24721[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (5))){
var _ = (function (){var statearr_24653 = state_24523;
(statearr_24653[(4)] = cljs.core.rest((state_24523[(4)])));

return statearr_24653;
})();
var state_24523__$1 = state_24523;
var ex24562 = (state_24523__$1[(2)]);
var statearr_24654_24722 = state_24523__$1;
(statearr_24654_24722[(5)] = ex24562);


if((ex24562 instanceof Error)){
var statearr_24655_24723 = state_24523__$1;
(statearr_24655_24723[(1)] = (4));

(statearr_24655_24723[(5)] = null);

} else {
throw ex24562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (14))){
var inst_24518 = (state_24523[(2)]);
var _ = (function (){var statearr_24656 = state_24523;
(statearr_24656[(4)] = cljs.core.rest((state_24523[(4)])));

return statearr_24656;
})();
var state_24523__$1 = state_24523;
var statearr_24657_24724 = state_24523__$1;
(statearr_24657_24724[(2)] = inst_24518);

(statearr_24657_24724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (10))){
var inst_24448 = (state_24523[(8)]);
var inst_24453 = (function (){var pp = inst_24448;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_24454 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24453,select);
var state_24523__$1 = state_24523;
var statearr_24658_24725 = state_24523__$1;
(statearr_24658_24725[(2)] = inst_24454);

(statearr_24658_24725[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24524 === (8))){
var inst_24448 = (state_24523[(2)]);
var state_24523__$1 = (function (){var statearr_24659 = state_24523;
(statearr_24659[(8)] = inst_24448);

return statearr_24659;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24660_24726 = state_24523__$1;
(statearr_24660_24726[(1)] = (9));

} else {
var statearr_24661_24727 = state_24523__$1;
(statearr_24661_24727[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24662 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24662[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24662[(1)] = (1));

return statearr_24662;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_24523){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24523);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24663){var ex__2417__auto__ = e24663;
var statearr_24664_24728 = state_24523;
(statearr_24664_24728[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24523[(4)]))){
var statearr_24665_24729 = state_24523;
(statearr_24665_24729[(1)] = cljs.core.first((state_24523[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24730 = state_24523;
state_24523 = G__24730;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_24523){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_24523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24666 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24666[(6)] = c__2436__auto__);

return statearr_24666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24732 = arguments.length;
switch (G__24732) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24733,p__24734,group_limit,opts){
var map__24735 = p__24733;
var map__24735__$1 = (((((!((map__24735 == null))))?(((((map__24735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24735):map__24735);
var res = map__24735__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24735__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24736 = p__24734;
var map__24736__$1 = (((((!((map__24736 == null))))?(((((map__24736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24736):map__24736);
var select_spec = map__24736__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24736__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24848){
var state_val_24849 = (state_24848[(1)]);
if((state_val_24849 === (7))){
var inst_24745 = (state_24848[(7)]);
var state_24848__$1 = state_24848;
var statearr_24850_24930 = state_24848__$1;
(statearr_24850_24930[(2)] = inst_24745);

(statearr_24850_24930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (20))){
var inst_24780 = (state_24848[(2)]);
var state_24848__$1 = (function (){var statearr_24851 = state_24848;
(statearr_24851[(8)] = inst_24780);

return statearr_24851;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24852_24931 = state_24848__$1;
(statearr_24852_24931[(1)] = (21));

} else {
var statearr_24853_24932 = state_24848__$1;
(statearr_24853_24932[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (27))){
var inst_24789 = (state_24848[(9)]);
var inst_24794 = inst_24789.cljs$lang$protocol_mask$partition0$;
var inst_24795 = (inst_24794 & (64));
var inst_24796 = inst_24789.cljs$core$ISeq$;
var inst_24797 = (cljs.core.PROTOCOL_SENTINEL === inst_24796);
var inst_24798 = ((inst_24795) || (inst_24797));
var state_24848__$1 = state_24848;
if(cljs.core.truth_(inst_24798)){
var statearr_24854_24933 = state_24848__$1;
(statearr_24854_24933[(1)] = (30));

} else {
var statearr_24855_24934 = state_24848__$1;
(statearr_24855_24934[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (1))){
var state_24848__$1 = state_24848;
var statearr_24856_24935 = state_24848__$1;
(statearr_24856_24935[(2)] = null);

(statearr_24856_24935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (24))){
var inst_24784 = (state_24848[(10)]);
var inst_24780 = (state_24848[(8)]);
var inst_24786 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_24780,inst_24784,group_limit);
var state_24848__$1 = state_24848;
var statearr_24857_24936 = state_24848__$1;
(statearr_24857_24936[(2)] = inst_24786);

(statearr_24857_24936[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (39))){
var inst_24815 = (state_24848[(11)]);
var state_24848__$1 = state_24848;
var statearr_24858_24937 = state_24848__$1;
(statearr_24858_24937[(2)] = inst_24815);

(statearr_24858_24937[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (46))){
var inst_24833 = (state_24848[(12)]);
var inst_24835 = cljs.core.PersistentVector.EMPTY;
var inst_24836 = cljs.core.PersistentHashSet.EMPTY;
var inst_24837 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24836,inst_24833);
var inst_24838 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24835,inst_24837);
var state_24848__$1 = state_24848;
var statearr_24859_24938 = state_24848__$1;
(statearr_24859_24938[(2)] = inst_24838);

(statearr_24859_24938[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (4))){
var inst_24739 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
var statearr_24860_24939 = state_24848__$1;
(statearr_24860_24939[(2)] = inst_24739);

(statearr_24860_24939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (15))){
var inst_24766 = (state_24848[(13)]);
var inst_24768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24769 = [inst_24766];
var inst_24770 = (new cljs.core.PersistentVector(null,1,(5),inst_24768,inst_24769,null));
var state_24848__$1 = state_24848;
var statearr_24861_24940 = state_24848__$1;
(statearr_24861_24940[(2)] = inst_24770);

(statearr_24861_24940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (48))){
var inst_24841 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
var statearr_24862_24941 = state_24848__$1;
(statearr_24862_24941[(2)] = inst_24841);

(statearr_24862_24941[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (21))){
var state_24848__$1 = state_24848;
var statearr_24863_24942 = state_24848__$1;
(statearr_24863_24942[(2)] = (0));

(statearr_24863_24942[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (31))){
var state_24848__$1 = state_24848;
var statearr_24864_24943 = state_24848__$1;
(statearr_24864_24943[(2)] = false);

(statearr_24864_24943[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (32))){
var inst_24802 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
var statearr_24865_24944 = state_24848__$1;
(statearr_24865_24944[(2)] = inst_24802);

(statearr_24865_24944[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (40))){
var inst_24784 = (state_24848[(10)]);
var state_24848__$1 = state_24848;
var statearr_24866_24945 = state_24848__$1;
(statearr_24866_24945[(2)] = inst_24784);

(statearr_24866_24945[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (33))){
var inst_24789 = (state_24848[(9)]);
var inst_24807 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_24789);
var state_24848__$1 = state_24848;
var statearr_24867_24946 = state_24848__$1;
(statearr_24867_24946[(2)] = inst_24807);

(statearr_24867_24946[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (13))){
var inst_24755 = (state_24848[(14)]);
var state_24848__$1 = state_24848;
var statearr_24868_24947 = state_24848__$1;
(statearr_24868_24947[(2)] = inst_24755);

(statearr_24868_24947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (22))){
var state_24848__$1 = state_24848;
var statearr_24869_24948 = state_24848__$1;
(statearr_24869_24948[(2)] = offset);

(statearr_24869_24948[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (36))){
var inst_24815 = (state_24848[(11)]);
var inst_24815__$1 = limit;
var state_24848__$1 = (function (){var statearr_24870 = state_24848;
(statearr_24870[(11)] = inst_24815__$1);

return statearr_24870;
})();
if(cljs.core.truth_(inst_24815__$1)){
var statearr_24871_24949 = state_24848__$1;
(statearr_24871_24949[(1)] = (39));

} else {
var statearr_24872_24950 = state_24848__$1;
(statearr_24872_24950[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (41))){
var inst_24819 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
var statearr_24873_24951 = state_24848__$1;
(statearr_24873_24951[(2)] = inst_24819);

(statearr_24873_24951[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (43))){
var inst_24812 = (state_24848[(15)]);
var state_24848__$1 = state_24848;
var statearr_24874_24952 = state_24848__$1;
(statearr_24874_24952[(2)] = inst_24812);

(statearr_24874_24952[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (29))){
var inst_24805 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
if(cljs.core.truth_(inst_24805)){
var statearr_24875_24953 = state_24848__$1;
(statearr_24875_24953[(1)] = (33));

} else {
var statearr_24876_24954 = state_24848__$1;
(statearr_24876_24954[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (44))){
var inst_24811 = (state_24848[(16)]);
var inst_24828 = (state_24848[(2)]);
var inst_24829 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24830 = fluree.db.query.fql.format_filter_tuples(db,inst_24828,select_spec,inst_24811,vars,inst_24829);
var state_24848__$1 = state_24848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24848__$1,(45),inst_24830);
} else {
if((state_val_24849 === (6))){
var inst_24747 = cljs.core.count(select);
var inst_24748 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24747);
var state_24848__$1 = state_24848;
var statearr_24877_24955 = state_24848__$1;
(statearr_24877_24955[(2)] = inst_24748);

(statearr_24877_24955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (28))){
var state_24848__$1 = state_24848;
var statearr_24878_24956 = state_24848__$1;
(statearr_24878_24956[(2)] = false);

(statearr_24878_24956[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (25))){
var inst_24780 = (state_24848[(8)]);
var state_24848__$1 = state_24848;
var statearr_24879_24957 = state_24848__$1;
(statearr_24879_24957[(2)] = inst_24780);

(statearr_24879_24957[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (34))){
var inst_24789 = (state_24848[(9)]);
var state_24848__$1 = state_24848;
var statearr_24880_24958 = state_24848__$1;
(statearr_24880_24958[(2)] = inst_24789);

(statearr_24880_24958[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (17))){
var inst_24773 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
var statearr_24881_24959 = state_24848__$1;
(statearr_24881_24959[(2)] = inst_24773);

(statearr_24881_24959[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (3))){
var inst_24846 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24848__$1,inst_24846);
} else {
if((state_val_24849 === (12))){
var inst_24755 = (state_24848[(14)]);
var inst_24757 = cljs.core.first(select);
var inst_24758 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24757);
var inst_24759 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24758);
var inst_24760 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24759,(1));
var inst_24761 = [inst_24760];
var inst_24762 = [inst_24755];
var inst_24763 = cljs.core.PersistentHashMap.fromArrays(inst_24761,inst_24762);
var state_24848__$1 = state_24848;
var statearr_24882_24960 = state_24848__$1;
(statearr_24882_24960[(2)] = inst_24763);

(statearr_24882_24960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (2))){
var inst_24745 = (state_24848[(7)]);
var _ = (function (){var statearr_24883 = state_24848;
(statearr_24883[(4)] = cljs.core.cons((5),(state_24848[(4)])));

return statearr_24883;
})();
var inst_24745__$1 = aggregates;
var state_24848__$1 = (function (){var statearr_24884 = state_24848;
(statearr_24884[(7)] = inst_24745__$1);

return statearr_24884;
})();
if(cljs.core.truth_(inst_24745__$1)){
var statearr_24885_24961 = state_24848__$1;
(statearr_24885_24961[(1)] = (6));

} else {
var statearr_24886_24962 = state_24848__$1;
(statearr_24886_24962[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (23))){
var inst_24784 = (state_24848[(2)]);
var state_24848__$1 = (function (){var statearr_24887 = state_24848;
(statearr_24887[(10)] = inst_24784);

return statearr_24887;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24888_24963 = state_24848__$1;
(statearr_24888_24963[(1)] = (24));

} else {
var statearr_24889_24964 = state_24848__$1;
(statearr_24889_24964[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (47))){
var inst_24833 = (state_24848[(12)]);
var state_24848__$1 = state_24848;
var statearr_24890_24965 = state_24848__$1;
(statearr_24890_24965[(2)] = inst_24833);

(statearr_24890_24965[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (35))){
var inst_24810 = (state_24848[(2)]);
var inst_24811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24810,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24810,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24813 = cljs.core.not(orderBy);
var state_24848__$1 = (function (){var statearr_24891 = state_24848;
(statearr_24891[(15)] = inst_24812);

(statearr_24891[(16)] = inst_24811);

return statearr_24891;
})();
if(inst_24813){
var statearr_24892_24966 = state_24848__$1;
(statearr_24892_24966[(1)] = (36));

} else {
var statearr_24893_24967 = state_24848__$1;
(statearr_24893_24967[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (19))){
var state_24848__$1 = state_24848;
var statearr_24894_24968 = state_24848__$1;
(statearr_24894_24968[(2)] = res);

(statearr_24894_24968[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (11))){
var inst_24843 = (state_24848[(2)]);
var _ = (function (){var statearr_24896 = state_24848;
(statearr_24896[(4)] = cljs.core.rest((state_24848[(4)])));

return statearr_24896;
})();
var state_24848__$1 = state_24848;
var statearr_24897_24969 = state_24848__$1;
(statearr_24897_24969[(2)] = inst_24843);

(statearr_24897_24969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (9))){
var inst_24753 = cljs.core.first(aggregates);
var inst_24754 = fluree.db.query.analytical.calculate_aggregate(res,inst_24753);
var inst_24755 = cljs.core.second(inst_24754);
var state_24848__$1 = (function (){var statearr_24898 = state_24848;
(statearr_24898[(14)] = inst_24755);

return statearr_24898;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24899_24970 = state_24848__$1;
(statearr_24899_24970[(1)] = (12));

} else {
var statearr_24900_24971 = state_24848__$1;
(statearr_24900_24971[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (5))){
var _ = (function (){var statearr_24901 = state_24848;
(statearr_24901[(4)] = cljs.core.rest((state_24848[(4)])));

return statearr_24901;
})();
var state_24848__$1 = state_24848;
var ex24895 = (state_24848__$1[(2)]);
var statearr_24902_24972 = state_24848__$1;
(statearr_24902_24972[(5)] = ex24895);


if((ex24895 instanceof Error)){
var statearr_24903_24973 = state_24848__$1;
(statearr_24903_24973[(1)] = (4));

(statearr_24903_24973[(5)] = null);

} else {
throw ex24895;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (14))){
var inst_24766 = (state_24848[(2)]);
var state_24848__$1 = (function (){var statearr_24904 = state_24848;
(statearr_24904[(13)] = inst_24766);

return statearr_24904;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24905_24974 = state_24848__$1;
(statearr_24905_24974[(1)] = (15));

} else {
var statearr_24906_24975 = state_24848__$1;
(statearr_24906_24975[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (45))){
var inst_24832 = (state_24848[(2)]);
var inst_24833 = fluree.db.util.async.throw_err(inst_24832);
var state_24848__$1 = (function (){var statearr_24907 = state_24848;
(statearr_24907[(12)] = inst_24833);

return statearr_24907;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24908_24976 = state_24848__$1;
(statearr_24908_24976[(1)] = (46));

} else {
var statearr_24909_24977 = state_24848__$1;
(statearr_24909_24977[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (26))){
var inst_24789 = (state_24848[(9)]);
var inst_24789__$1 = (state_24848[(2)]);
var inst_24791 = (inst_24789__$1 == null);
var inst_24792 = cljs.core.not(inst_24791);
var state_24848__$1 = (function (){var statearr_24910 = state_24848;
(statearr_24910[(9)] = inst_24789__$1);

return statearr_24910;
})();
if(inst_24792){
var statearr_24911_24978 = state_24848__$1;
(statearr_24911_24978[(1)] = (27));

} else {
var statearr_24912_24979 = state_24848__$1;
(statearr_24912_24979[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (16))){
var inst_24766 = (state_24848[(13)]);
var state_24848__$1 = state_24848;
var statearr_24913_24980 = state_24848__$1;
(statearr_24913_24980[(2)] = inst_24766);

(statearr_24913_24980[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (38))){
var inst_24822 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
if(cljs.core.truth_(inst_24822)){
var statearr_24914_24981 = state_24848__$1;
(statearr_24914_24981[(1)] = (42));

} else {
var statearr_24915_24982 = state_24848__$1;
(statearr_24915_24982[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (30))){
var state_24848__$1 = state_24848;
var statearr_24916_24983 = state_24848__$1;
(statearr_24916_24983[(2)] = true);

(statearr_24916_24983[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (10))){
var state_24848__$1 = state_24848;
if(cljs.core.truth_(aggregates)){
var statearr_24917_24984 = state_24848__$1;
(statearr_24917_24984[(1)] = (18));

} else {
var statearr_24918_24985 = state_24848__$1;
(statearr_24918_24985[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (18))){
var inst_24777 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24848__$1 = state_24848;
var statearr_24919_24986 = state_24848__$1;
(statearr_24919_24986[(2)] = inst_24777);

(statearr_24919_24986[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (42))){
var inst_24812 = (state_24848[(15)]);
var inst_24784 = (state_24848[(10)]);
var inst_24824 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_24784,inst_24812);
var inst_24825 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24824);
var state_24848__$1 = state_24848;
var statearr_24920_24987 = state_24848__$1;
(statearr_24920_24987[(2)] = inst_24825);

(statearr_24920_24987[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (37))){
var state_24848__$1 = state_24848;
var statearr_24921_24988 = state_24848__$1;
(statearr_24921_24988[(2)] = false);

(statearr_24921_24988[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24849 === (8))){
var inst_24751 = (state_24848[(2)]);
var state_24848__$1 = state_24848;
if(cljs.core.truth_(inst_24751)){
var statearr_24922_24989 = state_24848__$1;
(statearr_24922_24989[(1)] = (9));

} else {
var statearr_24923_24990 = state_24848__$1;
(statearr_24923_24990[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_24924 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24924[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_24924[(1)] = (1));

return statearr_24924;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_24848){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24848);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24925){var ex__2417__auto__ = e24925;
var statearr_24926_24991 = state_24848;
(statearr_24926_24991[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24848[(4)]))){
var statearr_24927_24992 = state_24848;
(statearr_24927_24992[(1)] = cljs.core.first((state_24848[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24993 = state_24848;
state_24848 = G__24993;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_24848){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_24848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24928 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24928[(6)] = c__2436__auto__);

return statearr_24928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24996,groupBy){
var map__24997 = p__24996;
var map__24997__$1 = (((((!((map__24997 == null))))?(((((map__24997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24997.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24997):map__24997);
var res = map__24997__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24997__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24997__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24999 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24999,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24999,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24994_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24994_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24995_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24995_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__25002,p__25003,opts){
var map__25004 = p__25002;
var map__25004__$1 = (((((!((map__25004 == null))))?(((((map__25004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25004.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25004):map__25004);
var res = map__25004__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25004__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25004__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25005 = p__25003;
var map__25005__$1 = (((((!((map__25005 == null))))?(((((map__25005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25005):map__25005);
var select_spec = map__25005__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25005__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_25230){
var state_val_25231 = (state_25230[(1)]);
if((state_val_25231 === (65))){
var inst_25192 = (state_25230[(2)]);
var inst_25193 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_25192,opts);
var state_25230__$1 = state_25230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25230__$1,(66),inst_25193);
} else {
if((state_val_25231 === (70))){
var inst_25196 = (state_25230[(7)]);
var inst_25201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25202 = [inst_25196];
var inst_25203 = (new cljs.core.PersistentVector(null,1,(5),inst_25201,inst_25202,null));
var state_25230__$1 = state_25230;
var statearr_25232_25355 = state_25230__$1;
(statearr_25232_25355[(2)] = inst_25203);

(statearr_25232_25355[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (62))){
var inst_25185 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25233_25356 = state_25230__$1;
(statearr_25233_25356[(2)] = inst_25185);

(statearr_25233_25356[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (74))){
var state_25230__$1 = state_25230;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25234_25357 = state_25230__$1;
(statearr_25234_25357[(1)] = (76));

} else {
var statearr_25235_25358 = state_25230__$1;
(statearr_25235_25358[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (7))){
var state_25230__$1 = state_25230;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25236_25359 = state_25230__$1;
(statearr_25236_25359[(1)] = (63));

} else {
var statearr_25237_25360 = state_25230__$1;
(statearr_25237_25360[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (59))){
var inst_25118 = (state_25230[(8)]);
var inst_25109 = (state_25230[(9)]);
var inst_25161 = (state_25230[(2)]);
var inst_25162 = fluree.db.util.async.throw_err(inst_25161);
var inst_25163 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25109,inst_25118,inst_25162);
var state_25230__$1 = state_25230;
var statearr_25238_25361 = state_25230__$1;
(statearr_25238_25361[(2)] = inst_25163);

(statearr_25238_25361[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (20))){
var inst_25062 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25239_25362 = state_25230__$1;
(statearr_25239_25362[(2)] = inst_25062);

(statearr_25239_25362[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (72))){
var inst_25206 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25240_25363 = state_25230__$1;
(statearr_25240_25363[(2)] = inst_25206);

(statearr_25240_25363[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (58))){
var inst_25166 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25241_25364 = state_25230__$1;
(statearr_25241_25364[(2)] = inst_25166);

(statearr_25241_25364[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (60))){
var inst_25064 = (state_25230[(10)]);
var inst_25179 = (state_25230[(11)]);
var inst_25181 = cljs.core.sorted_map_by(inst_25064);
var inst_25182 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25181,inst_25179);
var state_25230__$1 = state_25230;
var statearr_25242_25365 = state_25230__$1;
(statearr_25242_25365[(2)] = inst_25182);

(statearr_25242_25365[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (27))){
var inst_25015 = (state_25230[(12)]);
var inst_25046 = (state_25230[(13)]);
var inst_25045 = (state_25230[(14)]);
var inst_25049 = (function (){var group_map = inst_25015;
var orderByIdx = inst_25045;
var orderDirection = inst_25046;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
})();
var state_25230__$1 = state_25230;
var statearr_25243_25366 = state_25230__$1;
(statearr_25243_25366[(2)] = inst_25049);

(statearr_25243_25366[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (1))){
var state_25230__$1 = state_25230;
var statearr_25244_25367 = state_25230__$1;
(statearr_25244_25367[(2)] = null);

(statearr_25244_25367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (69))){
var inst_25223 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25245_25368 = state_25230__$1;
(statearr_25245_25368[(2)] = inst_25223);

(statearr_25245_25368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (24))){
var inst_25046 = (state_25230[(13)]);
var inst_25044 = cljs.core.second(orderBy);
var inst_25045 = fluree.db.util.core.index_of(groupBy,inst_25044);
var inst_25046__$1 = cljs.core.first(orderBy);
var inst_25047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_25046__$1);
var state_25230__$1 = (function (){var statearr_25246 = state_25230;
(statearr_25246[(13)] = inst_25046__$1);

(statearr_25246[(14)] = inst_25045);

return statearr_25246;
})();
if(inst_25047){
var statearr_25247_25369 = state_25230__$1;
(statearr_25247_25369[(1)] = (27));

} else {
var statearr_25248_25370 = state_25230__$1;
(statearr_25248_25370[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (55))){
var inst_25118 = (state_25230[(8)]);
var inst_25109 = (state_25230[(9)]);
var inst_25150 = (state_25230[(2)]);
var inst_25151 = fluree.db.util.async.throw_err(inst_25150);
var inst_25152 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25109,inst_25118,inst_25151);
var state_25230__$1 = state_25230;
var statearr_25249_25371 = state_25230__$1;
(statearr_25249_25371[(2)] = inst_25152);

(statearr_25249_25371[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (39))){
var inst_25109 = (state_25230[(9)]);
var state_25230__$1 = state_25230;
var statearr_25250_25372 = state_25230__$1;
(statearr_25250_25372[(2)] = inst_25109);

(statearr_25250_25372[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (46))){
var state_25230__$1 = state_25230;
var statearr_25251_25373 = state_25230__$1;
(statearr_25251_25373[(2)] = null);

(statearr_25251_25373[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (4))){
var inst_25008 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25252_25374 = state_25230__$1;
(statearr_25252_25374[(2)] = inst_25008);

(statearr_25252_25374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (77))){
var state_25230__$1 = state_25230;
var statearr_25253_25375 = state_25230__$1;
(statearr_25253_25375[(1)] = (79));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (54))){
var inst_25168 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25255_25376 = state_25230__$1;
(statearr_25255_25376[(2)] = inst_25168);

(statearr_25255_25376[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (15))){
var inst_25015 = (state_25230[(12)]);
var inst_25027 = (function (){var group_map = inst_25015;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
})();
var state_25230__$1 = state_25230;
var statearr_25256_25377 = state_25230__$1;
(statearr_25256_25377[(2)] = inst_25027);

(statearr_25256_25377[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (48))){
var inst_25136 = (state_25230[(15)]);
var inst_25139 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_25136,select_spec,opts);
var state_25230__$1 = state_25230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25230__$1,(51),inst_25139);
} else {
if((state_val_25231 === (50))){
var inst_25170 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25257_25378 = state_25230__$1;
(statearr_25257_25378[(2)] = inst_25170);

(statearr_25257_25378[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (75))){
var inst_25221 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25258_25379 = state_25230__$1;
(statearr_25258_25379[(2)] = inst_25221);

(statearr_25258_25379[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (21))){
var inst_25037 = cljs.core.set(groupBy);
var inst_25038 = cljs.core.second(orderBy);
var inst_25039 = (inst_25037.cljs$core$IFn$_invoke$arity$1 ? inst_25037.cljs$core$IFn$_invoke$arity$1(inst_25038) : inst_25037.call(null,inst_25038));
var state_25230__$1 = state_25230;
var statearr_25259_25380 = state_25230__$1;
(statearr_25259_25380[(2)] = inst_25039);

(statearr_25259_25380[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (31))){
var state_25230__$1 = state_25230;
var statearr_25260_25381 = state_25230__$1;
(statearr_25260_25381[(2)] = null);

(statearr_25260_25381[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (32))){
var inst_25058 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25261_25382 = state_25230__$1;
(statearr_25261_25382[(2)] = inst_25058);

(statearr_25261_25382[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (40))){
var inst_25108 = (state_25230[(16)]);
var inst_25126 = (inst_25108 > (0));
var state_25230__$1 = state_25230;
if(cljs.core.truth_(inst_25126)){
var statearr_25262_25383 = state_25230__$1;
(statearr_25262_25383[(1)] = (42));

} else {
var statearr_25263_25384 = state_25230__$1;
(statearr_25263_25384[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (56))){
var inst_25133 = (state_25230[(17)]);
var inst_25121 = (state_25230[(18)]);
var inst_25136 = (state_25230[(15)]);
var inst_25156 = cljs.core.count(inst_25121);
var inst_25157 = (inst_25133 - limit);
var inst_25158 = (inst_25156 - inst_25157);
var inst_25159 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_25136,select_spec,inst_25158,opts);
var state_25230__$1 = state_25230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25230__$1,(59),inst_25159);
} else {
if((state_val_25231 === (33))){
var inst_25015 = (state_25230[(12)]);
var inst_25066 = cljs.core.keys(inst_25015);
var inst_25067 = cljs.core.first(inst_25066);
var inst_25068 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25069 = cljs.core.vals(inst_25015);
var inst_25070 = cljs.core.first(inst_25069);
var inst_25071 = [headers,vars,inst_25070];
var inst_25072 = cljs.core.PersistentHashMap.fromArrays(inst_25068,inst_25071);
var inst_25073 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_25072,select_spec,limit,opts);
var state_25230__$1 = (function (){var statearr_25264 = state_25230;
(statearr_25264[(19)] = inst_25067);

return statearr_25264;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25230__$1,(36),inst_25073);
} else {
if((state_val_25231 === (13))){
var inst_25032 = cljs.core.not(orderBy);
var state_25230__$1 = state_25230;
if(inst_25032){
var statearr_25265_25385 = state_25230__$1;
(statearr_25265_25385[(1)] = (18));

} else {
var statearr_25266_25386 = state_25230__$1;
(statearr_25266_25386[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (22))){
var inst_25035 = (state_25230[(20)]);
var state_25230__$1 = state_25230;
var statearr_25267_25387 = state_25230__$1;
(statearr_25267_25387[(2)] = inst_25035);

(statearr_25267_25387[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (36))){
var inst_25067 = (state_25230[(19)]);
var inst_25075 = (state_25230[(2)]);
var inst_25076 = fluree.db.util.async.throw_err(inst_25075);
var inst_25077 = [inst_25067];
var inst_25078 = [inst_25076];
var inst_25079 = cljs.core.PersistentHashMap.fromArrays(inst_25077,inst_25078);
var state_25230__$1 = state_25230;
var statearr_25268_25388 = state_25230__$1;
(statearr_25268_25388[(2)] = inst_25079);

(statearr_25268_25388[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (41))){
var inst_25177 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25269_25389 = state_25230__$1;
(statearr_25269_25389[(2)] = inst_25177);

(statearr_25269_25389[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (43))){
var state_25230__$1 = state_25230;
var statearr_25270_25390 = state_25230__$1;
(statearr_25270_25390[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (61))){
var inst_25179 = (state_25230[(11)]);
var state_25230__$1 = state_25230;
var statearr_25272_25391 = state_25230__$1;
(statearr_25272_25391[(2)] = inst_25179);

(statearr_25272_25391[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (29))){
var inst_25053 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25273_25392 = state_25230__$1;
(statearr_25273_25392[(2)] = inst_25053);

(statearr_25273_25392[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (44))){
var inst_25175 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25274_25393 = state_25230__$1;
(statearr_25274_25393[(2)] = inst_25175);

(statearr_25274_25393[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (6))){
var inst_25016 = (state_25230[(21)]);
var inst_25015 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var inst_25016__$1 = orderBy;
var state_25230__$1 = (function (){var statearr_25275 = state_25230;
(statearr_25275[(21)] = inst_25016__$1);

(statearr_25275[(12)] = inst_25015);

return statearr_25275;
})();
if(cljs.core.truth_(inst_25016__$1)){
var statearr_25276_25394 = state_25230__$1;
(statearr_25276_25394[(1)] = (9));

} else {
var statearr_25277_25395 = state_25230__$1;
(statearr_25277_25395[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (28))){
var inst_25015 = (state_25230[(12)]);
var inst_25046 = (state_25230[(13)]);
var inst_25045 = (state_25230[(14)]);
var inst_25051 = (function (){var group_map = inst_25015;
var orderByIdx = inst_25045;
var orderDirection = inst_25046;
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
})();
var state_25230__$1 = state_25230;
var statearr_25279_25396 = state_25230__$1;
(statearr_25279_25396[(2)] = inst_25051);

(statearr_25279_25396[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (64))){
var state_25230__$1 = state_25230;
var statearr_25280_25397 = state_25230__$1;
(statearr_25280_25397[(2)] = limit);

(statearr_25280_25397[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (51))){
var inst_25133 = (state_25230[(17)]);
var inst_25118 = (state_25230[(8)]);
var inst_25119 = (state_25230[(22)]);
var inst_25108 = (state_25230[(16)]);
var inst_25109 = (state_25230[(9)]);
var inst_25122 = (state_25230[(23)]);
var inst_25141 = (state_25230[(2)]);
var inst_25142 = fluree.db.util.async.throw_err(inst_25141);
var inst_25143 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25109,inst_25118,inst_25142);
var tmp25278 = inst_25108;
var inst_25105 = inst_25119;
var inst_25106 = inst_25122;
var inst_25107 = inst_25133;
var inst_25108__$1 = tmp25278;
var inst_25109__$1 = inst_25143;
var state_25230__$1 = (function (){var statearr_25281 = state_25230;
(statearr_25281[(24)] = inst_25107);

(statearr_25281[(25)] = inst_25106);

(statearr_25281[(16)] = inst_25108__$1);

(statearr_25281[(9)] = inst_25109__$1);

(statearr_25281[(26)] = inst_25105);

return statearr_25281;
})();
var statearr_25282_25398 = state_25230__$1;
(statearr_25282_25398[(2)] = null);

(statearr_25282_25398[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (25))){
var state_25230__$1 = state_25230;
var statearr_25283_25399 = state_25230__$1;
(statearr_25283_25399[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (34))){
var inst_25015 = (state_25230[(12)]);
var inst_25095 = cljs.core.keys(inst_25015);
var inst_25096 = cljs.core.seq(inst_25095);
var inst_25097 = cljs.core.first(inst_25096);
var inst_25098 = cljs.core.next(inst_25096);
var inst_25099 = cljs.core.vals(inst_25015);
var inst_25100 = cljs.core.seq(inst_25099);
var inst_25101 = cljs.core.first(inst_25100);
var inst_25102 = cljs.core.next(inst_25100);
var inst_25103 = offset;
var inst_25104 = cljs.core.PersistentHashMap.EMPTY;
var inst_25105 = inst_25095;
var inst_25106 = inst_25099;
var inst_25107 = (0);
var inst_25108 = inst_25103;
var inst_25109 = inst_25104;
var state_25230__$1 = (function (){var statearr_25285 = state_25230;
(statearr_25285[(24)] = inst_25107);

(statearr_25285[(27)] = inst_25101);

(statearr_25285[(25)] = inst_25106);

(statearr_25285[(28)] = inst_25097);

(statearr_25285[(29)] = inst_25098);

(statearr_25285[(16)] = inst_25108);

(statearr_25285[(9)] = inst_25109);

(statearr_25285[(26)] = inst_25105);

(statearr_25285[(30)] = inst_25102);

return statearr_25285;
})();
var statearr_25286_25400 = state_25230__$1;
(statearr_25286_25400[(2)] = null);

(statearr_25286_25400[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (17))){
var inst_25030 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25287_25401 = state_25230__$1;
(statearr_25287_25401[(2)] = inst_25030);

(statearr_25287_25401[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (3))){
var inst_25228 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25230__$1,inst_25228);
} else {
if((state_val_25231 === (12))){
var inst_25024 = cljs.core.first(orderBy);
var inst_25025 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25024,"DESC");
var state_25230__$1 = state_25230;
if(inst_25025){
var statearr_25288_25402 = state_25230__$1;
(statearr_25288_25402[(1)] = (15));

} else {
var statearr_25289_25403 = state_25230__$1;
(statearr_25289_25403[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (2))){
var _ = (function (){var statearr_25290 = state_25230;
(statearr_25290[(4)] = cljs.core.cons((5),(state_25230[(4)])));

return statearr_25290;
})();
var state_25230__$1 = state_25230;
if(cljs.core.truth_(groupBy)){
var statearr_25291_25404 = state_25230__$1;
(statearr_25291_25404[(1)] = (6));

} else {
var statearr_25292_25405 = state_25230__$1;
(statearr_25292_25405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (66))){
var inst_25196 = (state_25230[(7)]);
var inst_25195 = (state_25230[(2)]);
var inst_25196__$1 = fluree.db.util.async.throw_err(inst_25195);
var inst_25197 = cljs.core.coll_QMARK_(inst_25196__$1);
var inst_25198 = (!(inst_25197));
var state_25230__$1 = (function (){var statearr_25293 = state_25230;
(statearr_25293[(7)] = inst_25196__$1);

return statearr_25293;
})();
if(inst_25198){
var statearr_25294_25406 = state_25230__$1;
(statearr_25294_25406[(1)] = (67));

} else {
var statearr_25295_25407 = state_25230__$1;
(statearr_25295_25407[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (23))){
var inst_25042 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
if(cljs.core.truth_(inst_25042)){
var statearr_25296_25408 = state_25230__$1;
(statearr_25296_25408[(1)] = (24));

} else {
var statearr_25297_25409 = state_25230__$1;
(statearr_25297_25409[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (47))){
var inst_25173 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25298_25410 = state_25230__$1;
(statearr_25298_25410[(2)] = inst_25173);

(statearr_25298_25410[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (35))){
var inst_25187 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25299_25411 = state_25230__$1;
(statearr_25299_25411[(2)] = inst_25187);

(statearr_25299_25411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (76))){
var inst_25196 = (state_25230[(7)]);
var inst_25212 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_25196);
var state_25230__$1 = state_25230;
var statearr_25300_25412 = state_25230__$1;
(statearr_25300_25412[(2)] = inst_25212);

(statearr_25300_25412[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (19))){
var inst_25035 = (state_25230[(20)]);
var inst_25035__$1 = orderBy;
var state_25230__$1 = (function (){var statearr_25301 = state_25230;
(statearr_25301[(20)] = inst_25035__$1);

return statearr_25301;
})();
if(cljs.core.truth_(inst_25035__$1)){
var statearr_25302_25413 = state_25230__$1;
(statearr_25302_25413[(1)] = (21));

} else {
var statearr_25303_25414 = state_25230__$1;
(statearr_25303_25414[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (57))){
var state_25230__$1 = state_25230;
var statearr_25304_25415 = state_25230__$1;
(statearr_25304_25415[(2)] = null);

(statearr_25304_25415[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (68))){
var state_25230__$1 = state_25230;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25305_25416 = state_25230__$1;
(statearr_25305_25416[(1)] = (73));

} else {
var statearr_25306_25417 = state_25230__$1;
(statearr_25306_25417[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (11))){
var inst_25022 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
if(cljs.core.truth_(inst_25022)){
var statearr_25308_25418 = state_25230__$1;
(statearr_25308_25418[(1)] = (12));

} else {
var statearr_25309_25419 = state_25230__$1;
(statearr_25309_25419[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (9))){
var inst_25018 = cljs.core.second(orderBy);
var inst_25019 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25018,groupBy);
var state_25230__$1 = state_25230;
var statearr_25310_25420 = state_25230__$1;
(statearr_25310_25420[(2)] = inst_25019);

(statearr_25310_25420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (5))){
var _ = (function (){var statearr_25311 = state_25230;
(statearr_25311[(4)] = cljs.core.rest((state_25230[(4)])));

return statearr_25311;
})();
var state_25230__$1 = state_25230;
var ex25307 = (state_25230__$1[(2)]);
var statearr_25312_25421 = state_25230__$1;
(statearr_25312_25421[(5)] = ex25307);


if((ex25307 instanceof Error)){
var statearr_25313_25422 = state_25230__$1;
(statearr_25313_25422[(1)] = (4));

(statearr_25313_25422[(5)] = null);

} else {
throw ex25307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (14))){
var inst_25064 = (state_25230[(2)]);
var state_25230__$1 = (function (){var statearr_25314 = state_25230;
(statearr_25314[(10)] = inst_25064);

return statearr_25314;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25315_25423 = state_25230__$1;
(statearr_25315_25423[(1)] = (33));

} else {
var statearr_25316_25424 = state_25230__$1;
(statearr_25316_25424[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (45))){
var inst_25107 = (state_25230[(24)]);
var inst_25133 = (state_25230[(17)]);
var inst_25121 = (state_25230[(18)]);
var inst_25132 = cljs.core.count(inst_25121);
var inst_25133__$1 = (inst_25107 + inst_25132);
var inst_25134 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25135 = [headers,vars,inst_25121];
var inst_25136 = cljs.core.PersistentHashMap.fromArrays(inst_25134,inst_25135);
var inst_25137 = (limit > inst_25133__$1);
var state_25230__$1 = (function (){var statearr_25317 = state_25230;
(statearr_25317[(17)] = inst_25133__$1);

(statearr_25317[(15)] = inst_25136);

return statearr_25317;
})();
if(cljs.core.truth_(inst_25137)){
var statearr_25318_25425 = state_25230__$1;
(statearr_25318_25425[(1)] = (48));

} else {
var statearr_25319_25426 = state_25230__$1;
(statearr_25319_25426[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (53))){
var inst_25133 = (state_25230[(17)]);
var inst_25154 = (limit < inst_25133);
var state_25230__$1 = state_25230;
if(cljs.core.truth_(inst_25154)){
var statearr_25320_25427 = state_25230__$1;
(statearr_25320_25427[(1)] = (56));

} else {
var statearr_25321_25428 = state_25230__$1;
(statearr_25321_25428[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (78))){
var inst_25219 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25322_25429 = state_25230__$1;
(statearr_25322_25429[(2)] = inst_25219);

(statearr_25322_25429[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (26))){
var inst_25060 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25323_25430 = state_25230__$1;
(statearr_25323_25430[(2)] = inst_25060);

(statearr_25323_25430[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (16))){
var state_25230__$1 = state_25230;
var statearr_25324_25431 = state_25230__$1;
(statearr_25324_25431[(2)] = fluree.db.query.fql.compare_fn);

(statearr_25324_25431[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (81))){
var inst_25217 = (state_25230[(2)]);
var state_25230__$1 = state_25230;
var statearr_25325_25432 = state_25230__$1;
(statearr_25325_25432[(2)] = inst_25217);

(statearr_25325_25432[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (79))){
var inst_25196 = (state_25230[(7)]);
var state_25230__$1 = state_25230;
var statearr_25326_25433 = state_25230__$1;
(statearr_25326_25433[(2)] = inst_25196);

(statearr_25326_25433[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (38))){
var inst_25064 = (state_25230[(10)]);
var inst_25179 = (state_25230[(2)]);
var state_25230__$1 = (function (){var statearr_25327 = state_25230;
(statearr_25327[(11)] = inst_25179);

return statearr_25327;
})();
if(cljs.core.truth_(inst_25064)){
var statearr_25328_25434 = state_25230__$1;
(statearr_25328_25434[(1)] = (60));

} else {
var statearr_25329_25435 = state_25230__$1;
(statearr_25329_25435[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (30))){
var state_25230__$1 = state_25230;
var statearr_25330_25436 = state_25230__$1;
(statearr_25330_25436[(2)] = null);

(statearr_25330_25436[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (73))){
var inst_25196 = (state_25230[(7)]);
var inst_25209 = cljs.core.first(inst_25196);
var state_25230__$1 = state_25230;
var statearr_25331_25437 = state_25230__$1;
(statearr_25331_25437[(2)] = inst_25209);

(statearr_25331_25437[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (10))){
var inst_25016 = (state_25230[(21)]);
var state_25230__$1 = state_25230;
var statearr_25332_25438 = state_25230__$1;
(statearr_25332_25438[(2)] = inst_25016);

(statearr_25332_25438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (18))){
var state_25230__$1 = state_25230;
var statearr_25333_25439 = state_25230__$1;
(statearr_25333_25439[(2)] = null);

(statearr_25333_25439[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (52))){
var inst_25136 = (state_25230[(15)]);
var inst_25148 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_25136,select_spec,opts);
var state_25230__$1 = state_25230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25230__$1,(55),inst_25148);
} else {
if((state_val_25231 === (67))){
var state_25230__$1 = state_25230;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25336_25440 = state_25230__$1;
(statearr_25336_25440[(1)] = (70));

} else {
var statearr_25337_25441 = state_25230__$1;
(statearr_25337_25441[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (71))){
var inst_25196 = (state_25230[(7)]);
var state_25230__$1 = state_25230;
var statearr_25338_25442 = state_25230__$1;
(statearr_25338_25442[(2)] = inst_25196);

(statearr_25338_25442[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (42))){
var inst_25107 = (state_25230[(24)]);
var inst_25119 = (state_25230[(22)]);
var inst_25108 = (state_25230[(16)]);
var inst_25109 = (state_25230[(9)]);
var inst_25122 = (state_25230[(23)]);
var inst_25128 = (inst_25108 - (1));
var tmp25334 = inst_25107;
var tmp25335 = inst_25109;
var inst_25105 = inst_25119;
var inst_25106 = inst_25122;
var inst_25107__$1 = tmp25334;
var inst_25108__$1 = inst_25128;
var inst_25109__$1 = tmp25335;
var state_25230__$1 = (function (){var statearr_25339 = state_25230;
(statearr_25339[(24)] = inst_25107__$1);

(statearr_25339[(25)] = inst_25106);

(statearr_25339[(16)] = inst_25108__$1);

(statearr_25339[(9)] = inst_25109__$1);

(statearr_25339[(26)] = inst_25105);

return statearr_25339;
})();
var statearr_25340_25443 = state_25230__$1;
(statearr_25340_25443[(2)] = null);

(statearr_25340_25443[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (80))){
var state_25230__$1 = state_25230;
var statearr_25341_25444 = state_25230__$1;
(statearr_25341_25444[(2)] = null);

(statearr_25341_25444[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (37))){
var inst_25106 = (state_25230[(25)]);
var inst_25121 = (state_25230[(18)]);
var inst_25105 = (state_25230[(26)]);
var inst_25117 = cljs.core.seq(inst_25105);
var inst_25118 = cljs.core.first(inst_25117);
var inst_25119 = cljs.core.next(inst_25117);
var inst_25120 = cljs.core.seq(inst_25106);
var inst_25121__$1 = cljs.core.first(inst_25120);
var inst_25122 = cljs.core.next(inst_25120);
var inst_25123 = (inst_25121__$1 == null);
var state_25230__$1 = (function (){var statearr_25342 = state_25230;
(statearr_25342[(18)] = inst_25121__$1);

(statearr_25342[(8)] = inst_25118);

(statearr_25342[(22)] = inst_25119);

(statearr_25342[(23)] = inst_25122);

return statearr_25342;
})();
if(cljs.core.truth_(inst_25123)){
var statearr_25343_25445 = state_25230__$1;
(statearr_25343_25445[(1)] = (39));

} else {
var statearr_25344_25446 = state_25230__$1;
(statearr_25344_25446[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (63))){
var state_25230__$1 = state_25230;
var statearr_25345_25447 = state_25230__$1;
(statearr_25345_25447[(2)] = (1));

(statearr_25345_25447[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (8))){
var inst_25225 = (state_25230[(2)]);
var _ = (function (){var statearr_25346 = state_25230;
(statearr_25346[(4)] = cljs.core.rest((state_25230[(4)])));

return statearr_25346;
})();
var state_25230__$1 = state_25230;
var statearr_25347_25448 = state_25230__$1;
(statearr_25347_25448[(2)] = inst_25225);

(statearr_25347_25448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25231 === (49))){
var inst_25133 = (state_25230[(17)]);
var inst_25146 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_25133);
var state_25230__$1 = state_25230;
if(inst_25146){
var statearr_25348_25449 = state_25230__$1;
(statearr_25348_25449[(1)] = (52));

} else {
var statearr_25349_25450 = state_25230__$1;
(statearr_25349_25450[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0 = (function (){
var statearr_25350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25350[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__);

(statearr_25350[(1)] = (1));

return statearr_25350;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1 = (function (state_25230){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_25230);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e25351){var ex__2417__auto__ = e25351;
var statearr_25352_25451 = state_25230;
(statearr_25352_25451[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_25230[(4)]))){
var statearr_25353_25452 = state_25230;
(statearr_25353_25452[(1)] = cljs.core.first((state_25230[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25453 = state_25230;
state_25230 = G__25453;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__ = function(state_25230){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1.call(this,state_25230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_25354 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_25354[(6)] = c__2436__auto__);

return statearr_25354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25456,opts){
var map__25457 = p__25456;
var map__25457__$1 = (((((!((map__25457 == null))))?(((((map__25457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25457):map__25457);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25457__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25457__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25457__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25457__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25454_SHARP_){
return cljs.core.contains_QMARK_(p1__25454_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25455_SHARP_){
return cljs.core.contains_QMARK_(p1__25455_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__25466 = cljs.core.first(orderBy);
var fexpr__25465 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25465.cljs$core$IFn$_invoke$arity$1 ? fexpr__25465.cljs$core$IFn$_invoke$arity$1(G__25466) : fexpr__25465.call(null,G__25466));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25467,p__25468){
var map__25469 = p__25467;
var map__25469__$1 = (((((!((map__25469 == null))))?(((((map__25469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25469):map__25469);
var query_map = map__25469__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25469__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25470 = p__25468;
var map__25470__$1 = (((((!((map__25470 == null))))?(((((map__25470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25470):map__25470);
var where_result = map__25470__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25470__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25470__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25473 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25473,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25473,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25473,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_25506){
var state_val_25507 = (state_25506[(1)]);
if((state_val_25507 === (7))){
var inst_25485 = (state_25506[(7)]);
var state_25506__$1 = state_25506;
var statearr_25508_25531 = state_25506__$1;
(statearr_25508_25531[(2)] = inst_25485);

(statearr_25508_25531[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (1))){
var state_25506__$1 = state_25506;
var statearr_25509_25532 = state_25506__$1;
(statearr_25509_25532[(2)] = null);

(statearr_25509_25532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (4))){
var inst_25476 = (state_25506[(2)]);
var state_25506__$1 = state_25506;
var statearr_25510_25533 = state_25506__$1;
(statearr_25510_25533[(2)] = inst_25476);

(statearr_25510_25533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (13))){
var inst_25495 = (state_25506[(2)]);
var inst_25496 = fluree.db.util.async.throw_err(inst_25495);
var state_25506__$1 = state_25506;
var statearr_25511_25534 = state_25506__$1;
(statearr_25511_25534[(2)] = inst_25496);

(statearr_25511_25534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (6))){
var inst_25485 = (state_25506[(7)]);
var inst_25484 = (state_25506[(2)]);
var inst_25485__$1 = fluree.db.util.async.throw_err(inst_25484);
var inst_25486 = fluree.db.util.core.exception_QMARK_(inst_25485__$1);
var state_25506__$1 = (function (){var statearr_25512 = state_25506;
(statearr_25512[(7)] = inst_25485__$1);

return statearr_25512;
})();
if(inst_25486){
var statearr_25513_25535 = state_25506__$1;
(statearr_25513_25535[(1)] = (7));

} else {
var statearr_25514_25536 = state_25506__$1;
(statearr_25514_25536[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (3))){
var inst_25504 = (state_25506[(2)]);
var state_25506__$1 = state_25506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25506__$1,inst_25504);
} else {
if((state_val_25507 === (12))){
var inst_25499 = (state_25506[(2)]);
var state_25506__$1 = state_25506;
var statearr_25515_25537 = state_25506__$1;
(statearr_25515_25537[(2)] = inst_25499);

(statearr_25515_25537[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (2))){
var _ = (function (){var statearr_25516 = state_25506;
(statearr_25516[(4)] = cljs.core.cons((5),(state_25506[(4)])));

return statearr_25516;
})();
var inst_25482 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25506__$1 = state_25506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25506__$1,(6),inst_25482);
} else {
if((state_val_25507 === (11))){
var state_25506__$1 = state_25506;
var statearr_25518_25538 = state_25506__$1;
(statearr_25518_25538[(2)] = null);

(statearr_25518_25538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (9))){
var inst_25501 = (state_25506[(2)]);
var _ = (function (){var statearr_25519 = state_25506;
(statearr_25519[(4)] = cljs.core.rest((state_25506[(4)])));

return statearr_25519;
})();
var state_25506__$1 = state_25506;
var statearr_25520_25539 = state_25506__$1;
(statearr_25520_25539[(2)] = inst_25501);

(statearr_25520_25539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (5))){
var _ = (function (){var statearr_25521 = state_25506;
(statearr_25521[(4)] = cljs.core.rest((state_25506[(4)])));

return statearr_25521;
})();
var state_25506__$1 = state_25506;
var ex25517 = (state_25506__$1[(2)]);
var statearr_25522_25540 = state_25506__$1;
(statearr_25522_25540[(5)] = ex25517);


if((ex25517 instanceof Error)){
var statearr_25523_25541 = state_25506__$1;
(statearr_25523_25541[(1)] = (4));

(statearr_25523_25541[(5)] = null);

} else {
throw ex25517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25507 === (10))){
var inst_25485 = (state_25506[(7)]);
var inst_25490 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25485);
var inst_25491 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25485);
var inst_25492 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25490,inst_25491,query_map,opts);
var inst_25493 = fluree.db.query.fql.process_ad_hoc_res(db,inst_25485,inst_25492,opts);
var state_25506__$1 = state_25506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25506__$1,(13),inst_25493);
} else {
if((state_val_25507 === (8))){
var state_25506__$1 = state_25506;
var statearr_25524_25542 = state_25506__$1;
(statearr_25524_25542[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0 = (function (){
var statearr_25526 = [null,null,null,null,null,null,null,null];
(statearr_25526[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__);

(statearr_25526[(1)] = (1));

return statearr_25526;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1 = (function (state_25506){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_25506);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e25527){var ex__2417__auto__ = e25527;
var statearr_25528_25543 = state_25506;
(statearr_25528_25543[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_25506[(4)]))){
var statearr_25529_25544 = state_25506;
(statearr_25529_25544[(1)] = cljs.core.first((state_25506[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25545 = state_25506;
state_25506 = G__25545;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__ = function(state_25506){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1.call(this,state_25506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_25530 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_25530[(6)] = c__2436__auto__);

return statearr_25530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25546 = query_map;
var map__25546__$1 = (((((!((map__25546 == null))))?(((((map__25546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25546.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25546):map__25546);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25546__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25548 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25548,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25548;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_25919){
var state_val_25920 = (state_25919[(1)]);
if((state_val_25920 === (121))){
var inst_25860 = (state_25919[(7)]);
var inst_25632 = (state_25919[(8)]);
var inst_25630 = (state_25919[(9)]);
var inst_25864 = (state_25919[(10)]);
var inst_25868 = (state_25919[(2)]);
var inst_25869 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25632,fuel,max_fuel,inst_25630,inst_25860,inst_25864,inst_25868);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(115),inst_25869);
} else {
if((state_val_25920 === (65))){
var inst_25709 = (state_25919[(11)]);
var inst_25632 = (state_25919[(8)]);
var inst_25620 = (state_25919[(12)]);
var inst_25630 = (state_25919[(9)]);
var inst_25723 = (state_25919[(2)]);
var inst_25724 = fluree.db.util.async.throw_err(inst_25723);
var inst_25725 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_25709,inst_25724);
var inst_25726 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25632,fuel,max_fuel,inst_25630,inst_25725,inst_25620);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(66),inst_25726);
} else {
if((state_val_25920 === (70))){
var inst_25619 = (state_25919[(13)]);
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25619)){
var statearr_25921_26113 = state_25919__$1;
(statearr_25921_26113[(1)] = (73));

} else {
var statearr_25922_26114 = state_25919__$1;
(statearr_25922_26114[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (62))){
var inst_25711 = cljs.core.PersistentHashMap.EMPTY;
var state_25919__$1 = state_25919;
var statearr_25923_26115 = state_25919__$1;
(statearr_25923_26115[(2)] = inst_25711);

(statearr_25923_26115[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (74))){
var inst_25622 = (state_25919[(14)]);
var inst_25620 = (state_25919[(12)]);
var inst_25745 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25746 = [inst_25620,inst_25622];
var inst_25747 = cljs.core.PersistentHashMap.fromArrays(inst_25745,inst_25746);
var state_25919__$1 = state_25919;
var statearr_25924_26116 = state_25919__$1;
(statearr_25924_26116[(2)] = inst_25747);

(statearr_25924_26116[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (110))){
var inst_25828 = (state_25919[(15)]);
var inst_25842 = (state_25919[(2)]);
var inst_25843 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_25828,false);
var state_25919__$1 = (function (){var statearr_25925 = state_25919;
(statearr_25925[(16)] = inst_25842);

return statearr_25925;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(111),inst_25843);
} else {
if((state_val_25920 === (130))){
var inst_25909 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25909)){
var statearr_25926_26117 = state_25919__$1;
(statearr_25926_26117[(1)] = (131));

} else {
var statearr_25927_26118 = state_25919__$1;
(statearr_25927_26118[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (128))){
var inst_25900 = (state_25919[(17)]);
var inst_25903 = cljs.core.coll_QMARK_(inst_25900);
var inst_25904 = fluree.db.util.core.exception_QMARK_(inst_25900);
var inst_25905 = (!(inst_25904));
var inst_25906 = ((inst_25903) && (inst_25905));
var state_25919__$1 = state_25919;
var statearr_25928_26119 = state_25919__$1;
(statearr_25928_26119[(2)] = inst_25906);

(statearr_25928_26119[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (7))){
var inst_25580 = (state_25919[(18)]);
var inst_25580__$1 = selectOne;
var state_25919__$1 = (function (){var statearr_25929 = state_25919;
(statearr_25929[(18)] = inst_25580__$1);

return statearr_25929;
})();
if(cljs.core.truth_(inst_25580__$1)){
var statearr_25930_26120 = state_25919__$1;
(statearr_25930_26120[(1)] = (9));

} else {
var statearr_25931_26121 = state_25919__$1;
(statearr_25931_26121[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (59))){
var inst_25703 = (state_25919[(19)]);
var inst_25705 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25706 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25703,inst_25705);
var state_25919__$1 = state_25919;
var statearr_25932_26122 = state_25919__$1;
(statearr_25932_26122[(2)] = inst_25706);

(statearr_25932_26122[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (86))){
var inst_25781 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(89),inst_25781);
} else {
if((state_val_25920 === (20))){
var inst_25610 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25933_26123 = state_25919__$1;
(statearr_25933_26123[(2)] = inst_25610);

(statearr_25933_26123[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (72))){
var inst_25891 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25934_26124 = state_25919__$1;
(statearr_25934_26124[(2)] = inst_25891);

(statearr_25934_26124[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (58))){
var inst_25703 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_25935 = state_25919;
(statearr_25935[(19)] = inst_25703);

return statearr_25935;
})();
var statearr_25936_26125 = state_25919__$1;
(statearr_25936_26125[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (60))){
var inst_25703 = (state_25919[(19)]);
var state_25919__$1 = state_25919;
var statearr_25938_26126 = state_25919__$1;
(statearr_25938_26126[(2)] = inst_25703);

(statearr_25938_26126[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (27))){
var inst_25619 = (state_25919[(13)]);
var inst_25634 = cljs.core.vector_QMARK_(inst_25619);
var state_25919__$1 = state_25919;
if(inst_25634){
var statearr_25939_26127 = state_25919__$1;
(statearr_25939_26127[(1)] = (30));

} else {
var statearr_25940_26128 = state_25919__$1;
(statearr_25940_26128[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (1))){
var state_25919__$1 = state_25919;
var statearr_25941_26129 = state_25919__$1;
(statearr_25941_26129[(2)] = null);

(statearr_25941_26129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (69))){
var inst_25740 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25740)){
var statearr_25942_26130 = state_25919__$1;
(statearr_25942_26130[(1)] = (70));

} else {
var statearr_25943_26131 = state_25919__$1;
(statearr_25943_26131[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (101))){
var inst_25619 = (state_25919[(13)]);
var inst_25858 = (state_25919[(2)]);
var inst_25859 = cljs.core.PersistentVector.EMPTY;
var inst_25860 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25859,inst_25858);
var state_25919__$1 = (function (){var statearr_25944 = state_25919;
(statearr_25944[(7)] = inst_25860);

return statearr_25944;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_25945_26132 = state_25919__$1;
(statearr_25945_26132[(1)] = (116));

} else {
var statearr_25946_26133 = state_25919__$1;
(statearr_25946_26133[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (24))){
var inst_25623 = (state_25919[(20)]);
var inst_25621 = (state_25919[(21)]);
var inst_25627 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25623,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25621);
var state_25919__$1 = state_25919;
var statearr_25947_26134 = state_25919__$1;
(statearr_25947_26134[(2)] = inst_25627);

(statearr_25947_26134[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (102))){
var inst_25822 = (state_25919[(22)]);
var state_25919__$1 = state_25919;
var statearr_25948_26135 = state_25919__$1;
(statearr_25948_26135[(2)] = inst_25822);

(statearr_25948_26135[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (55))){
var inst_25893 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25949_26136 = state_25919__$1;
(statearr_25949_26136[(2)] = inst_25893);

(statearr_25949_26136[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (85))){
var inst_25775 = (state_25919[(2)]);
var inst_25776 = fluree.db.util.async.throw_err(inst_25775);
var state_25919__$1 = state_25919;
var statearr_25950_26137 = state_25919__$1;
(statearr_25950_26137[(2)] = inst_25776);

(statearr_25950_26137[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (39))){
var inst_25669 = typeof from === 'string';
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25669)){
var statearr_25951_26138 = state_25919__$1;
(statearr_25951_26138[(1)] = (42));

} else {
var statearr_25952_26139 = state_25919__$1;
(statearr_25952_26139[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (88))){
var inst_25887 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25953_26140 = state_25919__$1;
(statearr_25953_26140[(2)] = inst_25887);

(statearr_25953_26140[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (46))){
var inst_25688 = (state_25919[(2)]);
var inst_25689 = fluree.db.util.async.throw_err(inst_25688);
var state_25919__$1 = state_25919;
var statearr_25954_26141 = state_25919__$1;
(statearr_25954_26141[(2)] = inst_25689);

(statearr_25954_26141[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (4))){
var inst_25567 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25955_26142 = state_25919__$1;
(statearr_25955_26142[(2)] = inst_25567);

(statearr_25955_26142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (77))){
var inst_25756 = (state_25919[(2)]);
var inst_25757 = fluree.db.util.async.throw_err(inst_25756);
var state_25919__$1 = state_25919;
var statearr_25956_26143 = state_25919__$1;
(statearr_25956_26143[(2)] = inst_25757);

(statearr_25956_26143[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (106))){
var state_25919__$1 = state_25919;
if(cljs.core.truth_(fuel)){
var statearr_25957_26144 = state_25919__$1;
(statearr_25957_26144[(1)] = (108));

} else {
var statearr_25958_26145 = state_25919__$1;
(statearr_25958_26145[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (119))){
var state_25919__$1 = state_25919;
var statearr_25959_26146 = state_25919__$1;
(statearr_25959_26146[(2)] = null);

(statearr_25959_26146[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (95))){
var state_25919__$1 = state_25919;
var statearr_25960_26147 = state_25919__$1;
(statearr_25960_26147[(2)] = null);

(statearr_25960_26147[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (54))){
var inst_25732 = typeof from === 'string';
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25732)){
var statearr_25961_26148 = state_25919__$1;
(statearr_25961_26148[(1)] = (67));

} else {
var statearr_25962_26149 = state_25919__$1;
(statearr_25962_26149[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (92))){
var inst_25622 = (state_25919[(14)]);
var inst_25632 = (state_25919[(8)]);
var inst_25620 = (state_25919[(12)]);
var inst_25630 = (state_25919[(9)]);
var inst_25792 = (state_25919[(2)]);
var inst_25793 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25632,fuel,max_fuel,inst_25630,inst_25792,inst_25620,inst_25622);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(93),inst_25793);
} else {
if((state_val_25920 === (104))){
var inst_25856 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25963_26150 = state_25919__$1;
(statearr_25963_26150[(2)] = inst_25856);

(statearr_25963_26150[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (15))){
var inst_25597 = (state_25919[(23)]);
var inst_25602 = inst_25597.cljs$lang$protocol_mask$partition0$;
var inst_25603 = (inst_25602 & (64));
var inst_25604 = inst_25597.cljs$core$ISeq$;
var inst_25605 = (cljs.core.PROTOCOL_SENTINEL === inst_25604);
var inst_25606 = ((inst_25603) || (inst_25605));
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25606)){
var statearr_25964_26151 = state_25919__$1;
(statearr_25964_26151[(1)] = (18));

} else {
var statearr_25965_26152 = state_25919__$1;
(statearr_25965_26152[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (48))){
var inst_25620 = (state_25919[(12)]);
var state_25919__$1 = state_25919;
var statearr_25966_26153 = state_25919__$1;
(statearr_25966_26153[(2)] = inst_25620);

(statearr_25966_26153[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (50))){
var state_25919__$1 = state_25919;
var statearr_25967_26154 = state_25919__$1;
(statearr_25967_26154[(2)] = null);

(statearr_25967_26154[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (116))){
var state_25919__$1 = state_25919;
var statearr_25968_26155 = state_25919__$1;
(statearr_25968_26155[(2)] = null);

(statearr_25968_26155[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (75))){
var inst_25749 = (state_25919[(2)]);
var inst_25750 = fluree.db.query.range._block_or_tx_collection(db,inst_25749);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(76),inst_25750);
} else {
if((state_val_25920 === (99))){
var inst_25885 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25969_26156 = state_25919__$1;
(statearr_25969_26156[(2)] = inst_25885);

(statearr_25969_26156[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (21))){
var inst_25597 = (state_25919[(23)]);
var inst_25615 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_25597);
var state_25919__$1 = state_25919;
var statearr_25970_26157 = state_25919__$1;
(statearr_25970_26157[(2)] = inst_25615);

(statearr_25970_26157[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (31))){
var inst_25619 = (state_25919[(13)]);
var inst_25642 = typeof inst_25619 === 'string';
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25642)){
var statearr_25971_26158 = state_25919__$1;
(statearr_25971_26158[(1)] = (33));

} else {
var statearr_25972_26159 = state_25919__$1;
(statearr_25972_26159[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (113))){
var inst_25822 = (state_25919[(22)]);
var state_25919__$1 = state_25919;
var statearr_25973_26160 = state_25919__$1;
(statearr_25973_26160[(2)] = inst_25822);

(statearr_25973_26160[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (32))){
var inst_25658 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_25974_26161 = state_25919__$1;
(statearr_25974_26161[(2)] = inst_25658);

(statearr_25974_26161[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (40))){
var inst_25691 = typeof from === 'string';
var inst_25692 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25693 = clojure.string.includes_QMARK_(inst_25692,"/");
var inst_25694 = ((inst_25691) && (inst_25693));
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25694)){
var statearr_25975_26162 = state_25919__$1;
(statearr_25975_26162[(1)] = (53));

} else {
var statearr_25976_26163 = state_25919__$1;
(statearr_25976_26163[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (129))){
var inst_25901 = (state_25919[(24)]);
var state_25919__$1 = state_25919;
var statearr_25977_26164 = state_25919__$1;
(statearr_25977_26164[(2)] = inst_25901);

(statearr_25977_26164[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (91))){
var inst_25784 = (state_25919[(25)]);
var inst_25788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25789 = [inst_25784];
var inst_25790 = (new cljs.core.PersistentVector(null,1,(5),inst_25788,inst_25789,null));
var state_25919__$1 = state_25919;
var statearr_25978_26165 = state_25919__$1;
(statearr_25978_26165[(2)] = inst_25790);

(statearr_25978_26165[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (117))){
var inst_25620 = (state_25919[(12)]);
var state_25919__$1 = state_25919;
var statearr_25979_26166 = state_25919__$1;
(statearr_25979_26166[(2)] = inst_25620);

(statearr_25979_26166[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (108))){
var inst_25837 = cljs.core._deref(fuel);
var inst_25838 = (inst_25837 + (1));
var inst_25839 = cljs.core._vreset_BANG_(fuel,inst_25838);
var state_25919__$1 = state_25919;
var statearr_25980_26167 = state_25919__$1;
(statearr_25980_26167[(2)] = inst_25839);

(statearr_25980_26167[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (56))){
var inst_25697 = (state_25919[(26)]);
var inst_25699 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_25700 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25697,inst_25699);
var state_25919__$1 = state_25919;
var statearr_25981_26168 = state_25919__$1;
(statearr_25981_26168[(2)] = inst_25700);

(statearr_25981_26168[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (33))){
var inst_25619 = (state_25919[(13)]);
var inst_25644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25645 = [inst_25619,"ASC"];
var inst_25646 = (new cljs.core.PersistentVector(null,2,(5),inst_25644,inst_25645,null));
var state_25919__$1 = state_25919;
var statearr_25982_26169 = state_25919__$1;
(statearr_25982_26169[(2)] = inst_25646);

(statearr_25982_26169[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (13))){
var inst_25586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25587 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25588 = cljs.core.PersistentHashMap.fromArrays(inst_25586,inst_25587);
var inst_25589 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25588);
var inst_25590 = (function(){throw inst_25589})();
var state_25919__$1 = state_25919;
var statearr_25983_26170 = state_25919__$1;
(statearr_25983_26170[(2)] = inst_25590);

(statearr_25983_26170[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (22))){
var inst_25597 = (state_25919[(23)]);
var state_25919__$1 = state_25919;
var statearr_25984_26171 = state_25919__$1;
(statearr_25984_26171[(2)] = inst_25597);

(statearr_25984_26171[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (90))){
var state_25919__$1 = state_25919;
var statearr_25985_26172 = state_25919__$1;
(statearr_25985_26172[(2)] = null);

(statearr_25985_26172[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (109))){
var state_25919__$1 = state_25919;
var statearr_25986_26173 = state_25919__$1;
(statearr_25986_26173[(2)] = null);

(statearr_25986_26173[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (36))){
var inst_25649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25650 = [null,null];
var inst_25651 = (new cljs.core.PersistentVector(null,2,(5),inst_25649,inst_25650,null));
var state_25919__$1 = state_25919;
var statearr_25987_26174 = state_25919__$1;
(statearr_25987_26174[(2)] = inst_25651);

(statearr_25987_26174[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (41))){
var inst_25665 = (state_25919[(27)]);
var inst_25895 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_25988 = state_25919;
(statearr_25988[(28)] = inst_25895);

return statearr_25988;
})();
if(cljs.core.truth_(inst_25665)){
var statearr_25989_26175 = state_25919__$1;
(statearr_25989_26175[(1)] = (125));

} else {
var statearr_25990_26176 = state_25919__$1;
(statearr_25990_26176[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (118))){
var inst_25619 = (state_25919[(13)]);
var inst_25864 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_25991 = state_25919;
(statearr_25991[(10)] = inst_25864);

return statearr_25991;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_25992_26177 = state_25919__$1;
(statearr_25992_26177[(1)] = (119));

} else {
var statearr_25993_26178 = state_25919__$1;
(statearr_25993_26178[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (89))){
var inst_25784 = (state_25919[(25)]);
var inst_25783 = (state_25919[(2)]);
var inst_25784__$1 = fluree.db.util.async.throw_err(inst_25783);
var inst_25785 = (inst_25784__$1 == null);
var state_25919__$1 = (function (){var statearr_25994 = state_25919;
(statearr_25994[(25)] = inst_25784__$1);

return statearr_25994;
})();
if(cljs.core.truth_(inst_25785)){
var statearr_25995_26179 = state_25919__$1;
(statearr_25995_26179[(1)] = (90));

} else {
var statearr_25996_26180 = state_25919__$1;
(statearr_25996_26180[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (100))){
var inst_25821 = (state_25919[(29)]);
var inst_25828 = (state_25919[(15)]);
var inst_25827 = cljs.core.seq(inst_25821);
var inst_25828__$1 = cljs.core.first(inst_25827);
var inst_25829 = cljs.core.next(inst_25827);
var inst_25830 = cljs.core.not(inst_25828__$1);
var state_25919__$1 = (function (){var statearr_25997 = state_25919;
(statearr_25997[(30)] = inst_25829);

(statearr_25997[(15)] = inst_25828__$1);

return statearr_25997;
})();
if(inst_25830){
var statearr_25998_26181 = state_25919__$1;
(statearr_25998_26181[(1)] = (102));

} else {
var statearr_25999_26182 = state_25919__$1;
(statearr_25999_26182[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (131))){
var inst_25900 = (state_25919[(17)]);
var inst_25911 = cljs.core.first(inst_25900);
var state_25919__$1 = state_25919;
var statearr_26000_26183 = state_25919__$1;
(statearr_26000_26183[(2)] = inst_25911);

(statearr_26000_26183[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (122))){
var inst_25875 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_25876 = ["Invalid 'from' in query:",inst_25875].join('');
var inst_25877 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25878 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25879 = cljs.core.PersistentHashMap.fromArrays(inst_25877,inst_25878);
var inst_25880 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25876,inst_25879);
var state_25919__$1 = state_25919;
var statearr_26001_26184 = state_25919__$1;
(statearr_26001_26184[(2)] = inst_25880);

(statearr_26001_26184[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (43))){
var state_25919__$1 = state_25919;
var statearr_26002_26185 = state_25919__$1;
(statearr_26002_26185[(2)] = null);

(statearr_26002_26185[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (61))){
var inst_25619 = (state_25919[(13)]);
var inst_25709 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_26003 = state_25919;
(statearr_26003[(11)] = inst_25709);

return statearr_26003;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_26004_26186 = state_25919__$1;
(statearr_26004_26186[(1)] = (62));

} else {
var statearr_26005_26187 = state_25919__$1;
(statearr_26005_26187[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (29))){
var inst_25664 = (state_25919[(2)]);
var inst_25665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25664,(0),null);
var inst_25666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25664,(1),null);
var inst_25667 = typeof where === 'string';
var state_25919__$1 = (function (){var statearr_26006 = state_25919;
(statearr_26006[(27)] = inst_25665);

(statearr_26006[(31)] = inst_25666);

return statearr_26006;
})();
if(cljs.core.truth_(inst_25667)){
var statearr_26007_26188 = state_25919__$1;
(statearr_26007_26188[(1)] = (39));

} else {
var statearr_26008_26189 = state_25919__$1;
(statearr_26008_26189[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (44))){
var inst_25673 = (state_25919[(2)]);
var inst_25674 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_25673);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(45),inst_25674);
} else {
if((state_val_25920 === (93))){
var inst_25795 = (state_25919[(2)]);
var inst_25796 = fluree.db.util.async.throw_err(inst_25795);
var state_25919__$1 = (function (){var statearr_26009 = state_25919;
(statearr_26009[(32)] = inst_25796);

return statearr_26009;
})();
if(cljs.core.truth_(fuel)){
var statearr_26010_26190 = state_25919__$1;
(statearr_26010_26190[(1)] = (94));

} else {
var statearr_26011_26191 = state_25919__$1;
(statearr_26011_26191[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (6))){
var inst_25577 = (state_25919[(33)]);
var state_25919__$1 = state_25919;
var statearr_26012_26192 = state_25919__$1;
(statearr_26012_26192[(2)] = inst_25577);

(statearr_26012_26192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (111))){
var inst_25845 = (state_25919[(2)]);
var inst_25846 = fluree.db.util.async.throw_err(inst_25845);
var state_25919__$1 = state_25919;
var statearr_26013_26193 = state_25919__$1;
(statearr_26013_26193[(2)] = inst_25846);

(statearr_26013_26193[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (28))){
var inst_25660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25661 = [null,null];
var inst_25662 = (new cljs.core.PersistentVector(null,2,(5),inst_25660,inst_25661,null));
var state_25919__$1 = state_25919;
var statearr_26014_26194 = state_25919__$1;
(statearr_26014_26194[(2)] = inst_25662);

(statearr_26014_26194[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (64))){
var inst_25717 = (state_25919[(2)]);
var inst_25718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25719 = [from];
var inst_25720 = (new cljs.core.PersistentVector(null,1,(5),inst_25718,inst_25719,null));
var inst_25721 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25720,inst_25717);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(65),inst_25721);
} else {
if((state_val_25920 === (103))){
var inst_25828 = (state_25919[(15)]);
var inst_25833 = cljs.core.int_QMARK_(inst_25828);
var state_25919__$1 = state_25919;
if(inst_25833){
var statearr_26015_26195 = state_25919__$1;
(statearr_26015_26195[(1)] = (105));

} else {
var statearr_26016_26196 = state_25919__$1;
(statearr_26016_26196[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (51))){
var inst_25622 = (state_25919[(14)]);
var state_25919__$1 = state_25919;
var statearr_26017_26197 = state_25919__$1;
(statearr_26017_26197[(2)] = inst_25622);

(statearr_26017_26197[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (25))){
var inst_25623 = (state_25919[(20)]);
var state_25919__$1 = state_25919;
var statearr_26018_26198 = state_25919__$1;
(statearr_26018_26198[(2)] = inst_25623);

(statearr_26018_26198[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (34))){
var state_25919__$1 = state_25919;
var statearr_26019_26199 = state_25919__$1;
(statearr_26019_26199[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (125))){
var inst_25622 = (state_25919[(14)]);
var inst_25665 = (state_25919[(27)]);
var inst_25620 = (state_25919[(12)]);
var inst_25895 = (state_25919[(28)]);
var inst_25666 = (state_25919[(31)]);
var inst_25897 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25665,inst_25666,inst_25622,inst_25620,inst_25895);
var state_25919__$1 = state_25919;
var statearr_26021_26200 = state_25919__$1;
(statearr_26021_26200[(2)] = inst_25897);

(statearr_26021_26200[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (17))){
var inst_25613 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25613)){
var statearr_26022_26201 = state_25919__$1;
(statearr_26022_26201[(1)] = (21));

} else {
var statearr_26023_26202 = state_25919__$1;
(statearr_26023_26202[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (3))){
var inst_25917 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25919__$1,inst_25917);
} else {
if((state_val_25920 === (12))){
var inst_25583 = (state_25919[(34)]);
var state_25919__$1 = state_25919;
var statearr_26024_26203 = state_25919__$1;
(statearr_26024_26203[(2)] = inst_25583);

(statearr_26024_26203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (2))){
var inst_25577 = (state_25919[(33)]);
var _ = (function (){var statearr_26025 = state_25919;
(statearr_26025[(4)] = cljs.core.cons((5),(state_25919[(4)])));

return statearr_26025;
})();
var inst_25577__$1 = select;
var state_25919__$1 = (function (){var statearr_26026 = state_25919;
(statearr_26026[(33)] = inst_25577__$1);

return statearr_26026;
})();
if(cljs.core.truth_(inst_25577__$1)){
var statearr_26027_26204 = state_25919__$1;
(statearr_26027_26204[(1)] = (6));

} else {
var statearr_26028_26205 = state_25919__$1;
(statearr_26028_26205[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (66))){
var inst_25728 = (state_25919[(2)]);
var inst_25729 = fluree.db.util.async.throw_err(inst_25728);
var state_25919__$1 = state_25919;
var statearr_26029_26206 = state_25919__$1;
(statearr_26029_26206[(2)] = inst_25729);

(statearr_26029_26206[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (107))){
var inst_25848 = (state_25919[(35)]);
var inst_25848__$1 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_26030 = state_25919;
(statearr_26030[(35)] = inst_25848__$1);

return statearr_26030;
})();
if(cljs.core.truth_(inst_25848__$1)){
var statearr_26031_26207 = state_25919__$1;
(statearr_26031_26207[(1)] = (112));

} else {
var statearr_26032_26208 = state_25919__$1;
(statearr_26032_26208[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (23))){
var inst_25621 = (state_25919[(21)]);
var inst_25596 = (state_25919[(36)]);
var inst_25618 = (state_25919[(2)]);
var inst_25619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25618,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25618,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25621__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25618,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25618,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25623 = fluree.db.query.fql_parser.parse_db(db,inst_25596,opts_SINGLEQUOTE_);
var inst_25624 = (inst_25621__$1 == null);
var inst_25625 = cljs.core.not(inst_25624);
var state_25919__$1 = (function (){var statearr_26033 = state_25919;
(statearr_26033[(14)] = inst_25622);

(statearr_26033[(13)] = inst_25619);

(statearr_26033[(20)] = inst_25623);

(statearr_26033[(12)] = inst_25620);

(statearr_26033[(21)] = inst_25621__$1);

return statearr_26033;
})();
if(inst_25625){
var statearr_26034_26209 = state_25919__$1;
(statearr_26034_26209[(1)] = (24));

} else {
var statearr_26035_26210 = state_25919__$1;
(statearr_26035_26210[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (47))){
var state_25919__$1 = state_25919;
var statearr_26036_26211 = state_25919__$1;
(statearr_26036_26211[(2)] = null);

(statearr_26036_26211[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (35))){
var inst_25656 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26037_26212 = state_25919__$1;
(statearr_26037_26212[(2)] = inst_25656);

(statearr_26037_26212[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (127))){
var inst_25901 = (state_25919[(24)]);
var inst_25900 = (state_25919[(2)]);
var inst_25901__$1 = selectOne;
var state_25919__$1 = (function (){var statearr_26038 = state_25919;
(statearr_26038[(24)] = inst_25901__$1);

(statearr_26038[(17)] = inst_25900);

return statearr_26038;
})();
if(cljs.core.truth_(inst_25901__$1)){
var statearr_26039_26213 = state_25919__$1;
(statearr_26039_26213[(1)] = (128));

} else {
var statearr_26040_26214 = state_25919__$1;
(statearr_26040_26214[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (82))){
var inst_25622 = (state_25919[(14)]);
var inst_25620 = (state_25919[(12)]);
var inst_25764 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25765 = [inst_25620,inst_25622];
var inst_25766 = cljs.core.PersistentHashMap.fromArrays(inst_25764,inst_25765);
var state_25919__$1 = state_25919;
var statearr_26041_26215 = state_25919__$1;
(statearr_26041_26215[(2)] = inst_25766);

(statearr_26041_26215[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (76))){
var inst_25632 = (state_25919[(8)]);
var inst_25630 = (state_25919[(9)]);
var inst_25752 = (state_25919[(2)]);
var inst_25753 = fluree.db.util.async.throw_err(inst_25752);
var inst_25754 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25632,fuel,max_fuel,inst_25630,inst_25753);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(77),inst_25754);
} else {
if((state_val_25920 === (97))){
var inst_25816 = from;
var inst_25817 = cljs.core.seq(inst_25816);
var inst_25818 = cljs.core.first(inst_25817);
var inst_25819 = cljs.core.next(inst_25817);
var inst_25820 = cljs.core.PersistentVector.EMPTY;
var inst_25821 = inst_25816;
var inst_25822 = inst_25820;
var state_25919__$1 = (function (){var statearr_26042 = state_25919;
(statearr_26042[(29)] = inst_25821);

(statearr_26042[(37)] = inst_25819);

(statearr_26042[(22)] = inst_25822);

(statearr_26042[(38)] = inst_25818);

return statearr_26042;
})();
var statearr_26043_26216 = state_25919__$1;
(statearr_26043_26216[(2)] = null);

(statearr_26043_26216[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (19))){
var state_25919__$1 = state_25919;
var statearr_26044_26217 = state_25919__$1;
(statearr_26044_26217[(2)] = false);

(statearr_26044_26217[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (57))){
var inst_25697 = (state_25919[(26)]);
var state_25919__$1 = state_25919;
var statearr_26045_26218 = state_25919__$1;
(statearr_26045_26218[(2)] = inst_25697);

(statearr_26045_26218[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (68))){
var state_25919__$1 = state_25919;
var statearr_26046_26219 = state_25919__$1;
(statearr_26046_26219[(2)] = false);

(statearr_26046_26219[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (11))){
var inst_25594 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26047_26220 = state_25919__$1;
(statearr_26047_26220[(2)] = inst_25594);

(statearr_26047_26220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (115))){
var inst_25871 = (state_25919[(2)]);
var inst_25872 = fluree.db.util.async.throw_err(inst_25871);
var state_25919__$1 = state_25919;
var statearr_26049_26221 = state_25919__$1;
(statearr_26049_26221[(2)] = inst_25872);

(statearr_26049_26221[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (9))){
var inst_25580 = (state_25919[(18)]);
var state_25919__$1 = state_25919;
var statearr_26050_26222 = state_25919__$1;
(statearr_26050_26222[(2)] = inst_25580);

(statearr_26050_26222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (5))){
var _ = (function (){var statearr_26051 = state_25919;
(statearr_26051[(4)] = cljs.core.rest((state_25919[(4)])));

return statearr_26051;
})();
var state_25919__$1 = state_25919;
var ex26048 = (state_25919__$1[(2)]);
var statearr_26052_26223 = state_25919__$1;
(statearr_26052_26223[(5)] = ex26048);


if((ex26048 instanceof Error)){
var statearr_26053_26224 = state_25919__$1;
(statearr_26053_26224[(1)] = (4));

(statearr_26053_26224[(5)] = null);

} else {
throw ex26048;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (112))){
var inst_25822 = (state_25919[(22)]);
var inst_25848 = (state_25919[(35)]);
var inst_25850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25822,inst_25848);
var state_25919__$1 = state_25919;
var statearr_26054_26225 = state_25919__$1;
(statearr_26054_26225[(2)] = inst_25850);

(statearr_26054_26225[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (83))){
var inst_25768 = (state_25919[(2)]);
var inst_25769 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_25768);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(84),inst_25769);
} else {
if((state_val_25920 === (14))){
var inst_25592 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26055_26226 = state_25919__$1;
(statearr_26055_26226[(2)] = inst_25592);

(statearr_26055_26226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (45))){
var inst_25619 = (state_25919[(13)]);
var inst_25676 = (state_25919[(2)]);
var inst_25677 = fluree.db.util.async.throw_err(inst_25676);
var state_25919__$1 = (function (){var statearr_26056 = state_25919;
(statearr_26056[(39)] = inst_25677);

return statearr_26056;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_26057_26227 = state_25919__$1;
(statearr_26057_26227[(1)] = (47));

} else {
var statearr_26058_26228 = state_25919__$1;
(statearr_26058_26228[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (53))){
var inst_25697 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_25919__$1 = (function (){var statearr_26059 = state_25919;
(statearr_26059[(26)] = inst_25697);

return statearr_26059;
})();
if(cljs.core.truth_(fuel)){
var statearr_26060_26229 = state_25919__$1;
(statearr_26060_26229[(1)] = (56));

} else {
var statearr_26061_26230 = state_25919__$1;
(statearr_26061_26230[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (78))){
var inst_25619 = (state_25919[(13)]);
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25619)){
var statearr_26062_26231 = state_25919__$1;
(statearr_26062_26231[(1)] = (81));

} else {
var statearr_26063_26232 = state_25919__$1;
(statearr_26063_26232[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (132))){
var inst_25900 = (state_25919[(17)]);
var state_25919__$1 = state_25919;
var statearr_26064_26233 = state_25919__$1;
(statearr_26064_26233[(2)] = inst_25900);

(statearr_26064_26233[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (26))){
var inst_25619 = (state_25919[(13)]);
var inst_25630 = (state_25919[(2)]);
var inst_25631 = cljs.core.PersistentHashMap.EMPTY;
var inst_25632 = cljs.core.volatile_BANG_(inst_25631);
var state_25919__$1 = (function (){var statearr_26065 = state_25919;
(statearr_26065[(8)] = inst_25632);

(statearr_26065[(9)] = inst_25630);

return statearr_26065;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_26066_26234 = state_25919__$1;
(statearr_26066_26234[(1)] = (27));

} else {
var statearr_26067_26235 = state_25919__$1;
(statearr_26067_26235[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (123))){
var state_25919__$1 = state_25919;
var statearr_26068_26236 = state_25919__$1;
(statearr_26068_26236[(2)] = null);

(statearr_26068_26236[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (16))){
var state_25919__$1 = state_25919;
var statearr_26069_26237 = state_25919__$1;
(statearr_26069_26237[(2)] = false);

(statearr_26069_26237[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (133))){
var inst_25914 = (state_25919[(2)]);
var _ = (function (){var statearr_26070 = state_25919;
(statearr_26070[(4)] = cljs.core.rest((state_25919[(4)])));

return statearr_26070;
})();
var state_25919__$1 = state_25919;
var statearr_26071_26238 = state_25919__$1;
(statearr_26071_26238[(2)] = inst_25914);

(statearr_26071_26238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (81))){
var inst_25762 = cljs.core.PersistentHashMap.EMPTY;
var state_25919__$1 = state_25919;
var statearr_26072_26239 = state_25919__$1;
(statearr_26072_26239[(2)] = inst_25762);

(statearr_26072_26239[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (120))){
var inst_25622 = (state_25919[(14)]);
var state_25919__$1 = state_25919;
var statearr_26073_26240 = state_25919__$1;
(statearr_26073_26240[(2)] = inst_25622);

(statearr_26073_26240[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (79))){
var inst_25778 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_25919__$1 = state_25919;
if(inst_25778){
var statearr_26074_26241 = state_25919__$1;
(statearr_26074_26241[(1)] = (86));

} else {
var statearr_26075_26242 = state_25919__$1;
(statearr_26075_26242[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (38))){
var inst_25654 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26076_26243 = state_25919__$1;
(statearr_26076_26243[(2)] = inst_25654);

(statearr_26076_26243[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (126))){
var inst_25895 = (state_25919[(28)]);
var state_25919__$1 = state_25919;
var statearr_26077_26244 = state_25919__$1;
(statearr_26077_26244[(2)] = inst_25895);

(statearr_26077_26244[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (98))){
var state_25919__$1 = state_25919;
var statearr_26078_26245 = state_25919__$1;
(statearr_26078_26245[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (124))){
var inst_25883 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26080_26246 = state_25919__$1;
(statearr_26080_26246[(2)] = inst_25883);

(statearr_26080_26246[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (87))){
var inst_25805 = cljs.core.sequential_QMARK_(from);
var inst_25806 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25807 = ((inst_25805) && (inst_25806));
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25807)){
var statearr_26081_26247 = state_25919__$1;
(statearr_26081_26247[(1)] = (97));

} else {
var statearr_26082_26248 = state_25919__$1;
(statearr_26082_26248[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (30))){
var inst_25619 = (state_25919[(13)]);
var inst_25636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25637 = cljs.core.second(inst_25619);
var inst_25638 = cljs.core.first(inst_25619);
var inst_25639 = [inst_25637,inst_25638];
var inst_25640 = (new cljs.core.PersistentVector(null,2,(5),inst_25636,inst_25639,null));
var state_25919__$1 = state_25919;
var statearr_26083_26249 = state_25919__$1;
(statearr_26083_26249[(2)] = inst_25640);

(statearr_26083_26249[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (73))){
var inst_25743 = cljs.core.PersistentHashMap.EMPTY;
var state_25919__$1 = state_25919;
var statearr_26084_26250 = state_25919__$1;
(statearr_26084_26250[(2)] = inst_25743);

(statearr_26084_26250[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (96))){
var inst_25796 = (state_25919[(32)]);
var inst_25803 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_26085 = state_25919;
(statearr_26085[(40)] = inst_25803);

return statearr_26085;
})();
var statearr_26086_26251 = state_25919__$1;
(statearr_26086_26251[(2)] = inst_25796);

(statearr_26086_26251[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (10))){
var inst_25583 = (state_25919[(34)]);
var inst_25583__$1 = selectDistinct;
var state_25919__$1 = (function (){var statearr_26087 = state_25919;
(statearr_26087[(34)] = inst_25583__$1);

return statearr_26087;
})();
if(cljs.core.truth_(inst_25583__$1)){
var statearr_26088_26252 = state_25919__$1;
(statearr_26088_26252[(1)] = (12));

} else {
var statearr_26089_26253 = state_25919__$1;
(statearr_26089_26253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (18))){
var state_25919__$1 = state_25919;
var statearr_26090_26254 = state_25919__$1;
(statearr_26090_26254[(2)] = true);

(statearr_26090_26254[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (105))){
var inst_25828 = (state_25919[(15)]);
var state_25919__$1 = state_25919;
var statearr_26091_26255 = state_25919__$1;
(statearr_26091_26255[(2)] = inst_25828);

(statearr_26091_26255[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (52))){
var inst_25677 = (state_25919[(39)]);
var inst_25632 = (state_25919[(8)]);
var inst_25630 = (state_25919[(9)]);
var inst_25681 = (state_25919[(41)]);
var inst_25685 = (state_25919[(2)]);
var inst_25686 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25632,fuel,max_fuel,inst_25630,inst_25677,inst_25681,inst_25685);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(46),inst_25686);
} else {
if((state_val_25920 === (114))){
var inst_25829 = (state_25919[(30)]);
var inst_25853 = (state_25919[(2)]);
var inst_25821 = inst_25829;
var inst_25822 = inst_25853;
var state_25919__$1 = (function (){var statearr_26092 = state_25919;
(statearr_26092[(29)] = inst_25821);

(statearr_26092[(22)] = inst_25822);

return statearr_26092;
})();
var statearr_26093_26256 = state_25919__$1;
(statearr_26093_26256[(2)] = null);

(statearr_26093_26256[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (67))){
var inst_25734 = ["_tx",null,"_block",null];
var inst_25735 = (new cljs.core.PersistentArrayMap(null,2,inst_25734,null));
var inst_25736 = (new cljs.core.PersistentHashSet(null,inst_25735,null));
var inst_25737 = (inst_25736.cljs$core$IFn$_invoke$arity$1 ? inst_25736.cljs$core$IFn$_invoke$arity$1(from) : inst_25736.call(null,from));
var state_25919__$1 = state_25919;
var statearr_26094_26257 = state_25919__$1;
(statearr_26094_26257[(2)] = inst_25737);

(statearr_26094_26257[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (71))){
var inst_25759 = typeof from === 'string';
var state_25919__$1 = state_25919;
if(cljs.core.truth_(inst_25759)){
var statearr_26095_26258 = state_25919__$1;
(statearr_26095_26258[(1)] = (78));

} else {
var statearr_26096_26259 = state_25919__$1;
(statearr_26096_26259[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (42))){
var state_25919__$1 = state_25919;
var statearr_26097_26260 = state_25919__$1;
(statearr_26097_26260[(2)] = from);

(statearr_26097_26260[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (80))){
var inst_25889 = (state_25919[(2)]);
var state_25919__$1 = state_25919;
var statearr_26098_26261 = state_25919__$1;
(statearr_26098_26261[(2)] = inst_25889);

(statearr_26098_26261[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (37))){
var state_25919__$1 = state_25919;
var statearr_26099_26262 = state_25919__$1;
(statearr_26099_26262[(2)] = null);

(statearr_26099_26262[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (63))){
var inst_25622 = (state_25919[(14)]);
var inst_25620 = (state_25919[(12)]);
var inst_25713 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25714 = [inst_25620,inst_25622];
var inst_25715 = cljs.core.PersistentHashMap.fromArrays(inst_25713,inst_25714);
var state_25919__$1 = state_25919;
var statearr_26100_26263 = state_25919__$1;
(statearr_26100_26263[(2)] = inst_25715);

(statearr_26100_26263[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (94))){
var inst_25798 = cljs.core._deref(fuel);
var inst_25799 = (inst_25798 + (1));
var inst_25800 = cljs.core._vreset_BANG_(fuel,inst_25799);
var state_25919__$1 = state_25919;
var statearr_26101_26264 = state_25919__$1;
(statearr_26101_26264[(2)] = inst_25800);

(statearr_26101_26264[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (8))){
var inst_25597 = (state_25919[(23)]);
var inst_25596 = (state_25919[(2)]);
var inst_25597__$1 = opts_SINGLEQUOTE_;
var inst_25599 = (inst_25597__$1 == null);
var inst_25600 = cljs.core.not(inst_25599);
var state_25919__$1 = (function (){var statearr_26102 = state_25919;
(statearr_26102[(23)] = inst_25597__$1);

(statearr_26102[(36)] = inst_25596);

return statearr_26102;
})();
if(inst_25600){
var statearr_26103_26265 = state_25919__$1;
(statearr_26103_26265[(1)] = (15));

} else {
var statearr_26104_26266 = state_25919__$1;
(statearr_26104_26266[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (49))){
var inst_25619 = (state_25919[(13)]);
var inst_25681 = (state_25919[(2)]);
var state_25919__$1 = (function (){var statearr_26105 = state_25919;
(statearr_26105[(41)] = inst_25681);

return statearr_26105;
})();
if(cljs.core.truth_(inst_25619)){
var statearr_26106_26267 = state_25919__$1;
(statearr_26106_26267[(1)] = (50));

} else {
var statearr_26107_26268 = state_25919__$1;
(statearr_26107_26268[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25920 === (84))){
var inst_25632 = (state_25919[(8)]);
var inst_25630 = (state_25919[(9)]);
var inst_25771 = (state_25919[(2)]);
var inst_25772 = fluree.db.util.async.throw_err(inst_25771);
var inst_25773 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25632,fuel,max_fuel,inst_25630,inst_25772);
var state_25919__$1 = state_25919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25919__$1,(85),inst_25773);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2414__auto____0 = (function (){
var statearr_26108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26108[(0)] = fluree$db$query$fql$query_$_state_machine__2414__auto__);

(statearr_26108[(1)] = (1));

return statearr_26108;
});
var fluree$db$query$fql$query_$_state_machine__2414__auto____1 = (function (state_25919){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_25919);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26109){var ex__2417__auto__ = e26109;
var statearr_26110_26269 = state_25919;
(statearr_26110_26269[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_25919[(4)]))){
var statearr_26111_26270 = state_25919;
(statearr_26111_26270[(1)] = cljs.core.first((state_25919[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26271 = state_25919;
state_25919 = G__26271;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2414__auto__ = function(state_25919){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2414__auto____1.call(this,state_25919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2414__auto____0;
fluree$db$query$fql$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2414__auto____1;
return fluree$db$query$fql$query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26112 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26112[(6)] = c__2436__auto__);

return statearr_26112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}

});
