// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18282 = arguments.length;
switch (G__18282) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18285 = arguments.length;
switch (G__18285) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___18338 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18316){
var state_val_18317 = (state_18316[(1)]);
if((state_val_18317 === (1))){
var state_18316__$1 = state_18316;
var statearr_18318_18339 = state_18316__$1;
(statearr_18318_18339[(2)] = null);

(statearr_18318_18339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (2))){
var _ = (function (){var statearr_18319 = state_18316;
(statearr_18319[(4)] = cljs.core.cons((5),(state_18316[(4)])));

return statearr_18319;
})();
var inst_18293 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18316__$1 = state_18316;
if(cljs.core.truth_(inst_18293)){
var statearr_18320_18340 = state_18316__$1;
(statearr_18320_18340[(1)] = (6));

} else {
var statearr_18321_18341 = state_18316__$1;
(statearr_18321_18341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (3))){
var inst_18314 = (state_18316[(2)]);
var state_18316__$1 = state_18316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18316__$1,inst_18314);
} else {
if((state_val_18317 === (4))){
var inst_18286 = (state_18316[(2)]);
var inst_18287 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18286);
var state_18316__$1 = state_18316;
var statearr_18323_18342 = state_18316__$1;
(statearr_18323_18342[(2)] = inst_18287);

(statearr_18323_18342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (5))){
var _ = (function (){var statearr_18324 = state_18316;
(statearr_18324[(4)] = cljs.core.rest((state_18316[(4)])));

return statearr_18324;
})();
var state_18316__$1 = state_18316;
var ex18322 = (state_18316__$1[(2)]);
var statearr_18325_18343 = state_18316__$1;
(statearr_18325_18343[(5)] = ex18322);


var statearr_18326_18344 = state_18316__$1;
(statearr_18326_18344[(1)] = (4));

(statearr_18326_18344[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (6))){
var inst_18295 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18296 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18297 = cljs.core.PersistentHashMap.fromArrays(inst_18295,inst_18296);
var inst_18298 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18297);
var inst_18299 = (function(){throw inst_18298})();
var state_18316__$1 = state_18316;
var statearr_18327_18345 = state_18316__$1;
(statearr_18327_18345[(2)] = inst_18299);

(statearr_18327_18345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (7))){
var inst_18301 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18303 = [operation,data,pc,opts];
var inst_18304 = (new cljs.core.PersistentVector(null,4,(5),inst_18302,inst_18303,null));
var inst_18305 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18301,inst_18304);
var inst_18306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18307 = [operation,data,pc,opts];
var inst_18308 = (new cljs.core.PersistentVector(null,4,(5),inst_18306,inst_18307,null));
var inst_18309 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_18308], 0));
var state_18316__$1 = (function (){var statearr_18328 = state_18316;
(statearr_18328[(7)] = inst_18305);

return statearr_18328;
})();
var statearr_18329_18346 = state_18316__$1;
(statearr_18329_18346[(2)] = inst_18309);

(statearr_18329_18346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18317 === (8))){
var inst_18311 = (state_18316[(2)]);
var _ = (function (){var statearr_18330 = state_18316;
(statearr_18330[(4)] = cljs.core.rest((state_18316[(4)])));

return statearr_18330;
})();
var state_18316__$1 = state_18316;
var statearr_18331_18347 = state_18316__$1;
(statearr_18331_18347[(2)] = inst_18311);

(statearr_18331_18347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2414__auto__ = null;
var fluree$db$operations$state_machine__2414__auto____0 = (function (){
var statearr_18332 = [null,null,null,null,null,null,null,null];
(statearr_18332[(0)] = fluree$db$operations$state_machine__2414__auto__);

(statearr_18332[(1)] = (1));

return statearr_18332;
});
var fluree$db$operations$state_machine__2414__auto____1 = (function (state_18316){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18316);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18333){var ex__2417__auto__ = e18333;
var statearr_18334_18348 = state_18316;
(statearr_18334_18348[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18316[(4)]))){
var statearr_18335_18349 = state_18316;
(statearr_18335_18349[(1)] = cljs.core.first((state_18316[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18350 = state_18316;
state_18316 = G__18350;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2414__auto__ = function(state_18316){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2414__auto____1.call(this,state_18316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2414__auto____0;
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2414__auto____1;
return fluree$db$operations$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18336 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18336[(6)] = c__2436__auto___18338);

return statearr_18336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18352 = arguments.length;
switch (G__18352) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18353){
var map__18354 = p__18353;
var map__18354__$1 = (((((!((map__18354 == null))))?(((((map__18354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18354):map__18354);
var opts = map__18354__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18354__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18356 = session;
var map__18356__$1 = (((((!((map__18356 == null))))?(((((map__18356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18356.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18356):map__18356);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18356__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18356__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18356__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___18418 = arguments.length;
var i__4737__auto___18419 = (0);
while(true){
if((i__4737__auto___18419 < len__4736__auto___18418)){
args__4742__auto__.push((arguments[i__4737__auto___18419]));

var G__18420 = (i__4737__auto___18419 + (1));
i__4737__auto___18419 = G__18420;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18361){
var vec__18362 = p__18361;
var map__18365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18362,(0),null);
var map__18365__$1 = (((((!((map__18365 == null))))?(((((map__18365.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18365.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18365):map__18365);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18365__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18365__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18362;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18398){
var state_val_18399 = (state_18398[(1)]);
if((state_val_18399 === (7))){
var inst_18381 = (state_18398[(2)]);
var state_18398__$1 = state_18398;
var statearr_18400_18421 = state_18398__$1;
(statearr_18400_18421[(2)] = inst_18381);

(statearr_18400_18421[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (1))){
var inst_18368 = (state_18398[(7)]);
var inst_18368__$1 = session;
var inst_18370 = (inst_18368__$1 == null);
var inst_18371 = cljs.core.not(inst_18370);
var state_18398__$1 = (function (){var statearr_18401 = state_18398;
(statearr_18401[(7)] = inst_18368__$1);

return statearr_18401;
})();
if(inst_18371){
var statearr_18402_18422 = state_18398__$1;
(statearr_18402_18422[(1)] = (2));

} else {
var statearr_18403_18423 = state_18398__$1;
(statearr_18403_18423[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (4))){
var inst_18384 = (state_18398[(2)]);
var state_18398__$1 = state_18398;
if(cljs.core.truth_(inst_18384)){
var statearr_18404_18424 = state_18398__$1;
(statearr_18404_18424[(1)] = (8));

} else {
var statearr_18405_18425 = state_18398__$1;
(statearr_18405_18425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (6))){
var state_18398__$1 = state_18398;
var statearr_18406_18426 = state_18398__$1;
(statearr_18406_18426[(2)] = false);

(statearr_18406_18426[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (3))){
var state_18398__$1 = state_18398;
var statearr_18407_18427 = state_18398__$1;
(statearr_18407_18427[(2)] = false);

(statearr_18407_18427[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (2))){
var inst_18368 = (state_18398[(7)]);
var inst_18373 = inst_18368.cljs$lang$protocol_mask$partition0$;
var inst_18374 = (inst_18373 & (64));
var inst_18375 = inst_18368.cljs$core$ISeq$;
var inst_18376 = (cljs.core.PROTOCOL_SENTINEL === inst_18375);
var inst_18377 = ((inst_18374) || (inst_18376));
var state_18398__$1 = state_18398;
if(cljs.core.truth_(inst_18377)){
var statearr_18408_18428 = state_18398__$1;
(statearr_18408_18428[(1)] = (5));

} else {
var statearr_18409_18429 = state_18398__$1;
(statearr_18409_18429[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (9))){
var inst_18368 = (state_18398[(7)]);
var state_18398__$1 = state_18398;
var statearr_18410_18430 = state_18398__$1;
(statearr_18410_18430[(2)] = inst_18368);

(statearr_18410_18430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (5))){
var state_18398__$1 = state_18398;
var statearr_18411_18431 = state_18398__$1;
(statearr_18411_18431[(2)] = true);

(statearr_18411_18431[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18399 === (10))){
var inst_18389 = (state_18398[(2)]);
var inst_18390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18389,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18389,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18389,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18393 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18394 = [inst_18390,inst_18391,toBlock,toTime];
var inst_18395 = cljs.core.PersistentHashMap.fromArrays(inst_18393,inst_18394);
var inst_18396 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18392,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18395);
var state_18398__$1 = state_18398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18398__$1,inst_18396);
} else {
if((state_val_18399 === (8))){
var inst_18368 = (state_18398[(7)]);
var inst_18386 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18368);
var state_18398__$1 = state_18398;
var statearr_18412_18432 = state_18398__$1;
(statearr_18412_18432[(2)] = inst_18386);

(statearr_18412_18432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2414__auto__ = null;
var fluree$db$operations$state_machine__2414__auto____0 = (function (){
var statearr_18413 = [null,null,null,null,null,null,null,null];
(statearr_18413[(0)] = fluree$db$operations$state_machine__2414__auto__);

(statearr_18413[(1)] = (1));

return statearr_18413;
});
var fluree$db$operations$state_machine__2414__auto____1 = (function (state_18398){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18398);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18414){var ex__2417__auto__ = e18414;
var statearr_18415_18433 = state_18398;
(statearr_18415_18433[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18398[(4)]))){
var statearr_18416_18434 = state_18398;
(statearr_18416_18434[(1)] = cljs.core.first((state_18398[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18435 = state_18398;
state_18398 = G__18435;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2414__auto__ = function(state_18398){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2414__auto____1.call(this,state_18398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2414__auto____0;
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2414__auto____1;
return fluree$db$operations$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18417 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18417[(6)] = c__2436__auto__);

return statearr_18417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18359){
var G__18360 = cljs.core.first(seq18359);
var seq18359__$1 = cljs.core.next(seq18359);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18360,seq18359__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18436 = session;
var map__18436__$1 = (((((!((map__18436 == null))))?(((((map__18436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18436):map__18436);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18436__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18436__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18436__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18439 = arguments.length;
switch (G__18439) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18440 = opts;
var map__18440__$1 = (((((!((map__18440 == null))))?(((((map__18440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18440):map__18440);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
