// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___54119 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54170){
var state_val_54171 = (state_54170[(1)]);
if((state_val_54171 === (7))){
var inst_54165 = (state_54170[(2)]);
var _ = (function (){var statearr_54172 = state_54170;
(statearr_54172[(4)] = cljs.core.rest((state_54170[(4)])));

return statearr_54172;
})();
var state_54170__$1 = state_54170;
var statearr_54173_54200 = state_54170__$1;
(statearr_54173_54200[(2)] = inst_54165);

(statearr_54173_54200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (1))){
var state_54170__$1 = state_54170;
var statearr_54174_54201 = state_54170__$1;
(statearr_54174_54201[(2)] = null);

(statearr_54174_54201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (4))){
var inst_54120 = (state_54170[(2)]);
var state_54170__$1 = state_54170;
var statearr_54175_54202 = state_54170__$1;
(statearr_54175_54202[(2)] = inst_54120);

(statearr_54175_54202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (13))){
var inst_54161 = (state_54170[(2)]);
var state_54170__$1 = state_54170;
var statearr_54176_54203 = state_54170__$1;
(statearr_54176_54203[(2)] = inst_54161);

(statearr_54176_54203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (6))){
var inst_54138 = (state_54170[(7)]);
var inst_54145 = (state_54170[(8)]);
var inst_54144 = cljs.core.seq(inst_54138);
var inst_54145__$1 = cljs.core.first(inst_54144);
var inst_54146 = cljs.core.next(inst_54144);
var inst_54147 = cljs.core.not(inst_54145__$1);
var state_54170__$1 = (function (){var statearr_54177 = state_54170;
(statearr_54177[(8)] = inst_54145__$1);

(statearr_54177[(9)] = inst_54146);

return statearr_54177;
})();
if(inst_54147){
var statearr_54178_54204 = state_54170__$1;
(statearr_54178_54204[(1)] = (8));

} else {
var statearr_54179_54205 = state_54170__$1;
(statearr_54179_54205[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (3))){
var inst_54168 = (state_54170[(2)]);
var state_54170__$1 = state_54170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54170__$1,inst_54168);
} else {
if((state_val_54171 === (12))){
var inst_54145 = (state_54170[(8)]);
var inst_54146 = (state_54170[(9)]);
var inst_54139 = (state_54170[(10)]);
var inst_54158 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54139,inst_54145);
var inst_54138 = inst_54146;
var inst_54139__$1 = inst_54158;
var state_54170__$1 = (function (){var statearr_54180 = state_54170;
(statearr_54180[(7)] = inst_54138);

(statearr_54180[(10)] = inst_54139__$1);

return statearr_54180;
})();
var statearr_54181_54206 = state_54170__$1;
(statearr_54181_54206[(2)] = null);

(statearr_54181_54206[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (2))){
var _ = (function (){var statearr_54182 = state_54170;
(statearr_54182[(4)] = cljs.core.cons((5),(state_54170[(4)])));

return statearr_54182;
})();
var inst_54133 = args;
var inst_54134 = cljs.core.seq(inst_54133);
var inst_54135 = cljs.core.first(inst_54134);
var inst_54136 = cljs.core.next(inst_54134);
var inst_54137 = cljs.core.PersistentVector.EMPTY;
var inst_54138 = inst_54133;
var inst_54139 = inst_54137;
var state_54170__$1 = (function (){var statearr_54183 = state_54170;
(statearr_54183[(7)] = inst_54138);

(statearr_54183[(11)] = inst_54135);

(statearr_54183[(12)] = inst_54136);

(statearr_54183[(10)] = inst_54139);

return statearr_54183;
})();
var statearr_54184_54207 = state_54170__$1;
(statearr_54184_54207[(2)] = null);

(statearr_54184_54207[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (11))){
var inst_54145 = (state_54170[(8)]);
var state_54170__$1 = state_54170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54170__$1,(14),inst_54145);
} else {
if((state_val_54171 === (9))){
var inst_54145 = (state_54170[(8)]);
var inst_54150 = fluree.db.util.async.channel_QMARK_(inst_54145);
var state_54170__$1 = state_54170;
if(inst_54150){
var statearr_54186_54208 = state_54170__$1;
(statearr_54186_54208[(1)] = (11));

} else {
var statearr_54187_54209 = state_54170__$1;
(statearr_54187_54209[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (5))){
var _ = (function (){var statearr_54188 = state_54170;
(statearr_54188[(4)] = cljs.core.rest((state_54170[(4)])));

return statearr_54188;
})();
var state_54170__$1 = state_54170;
var ex54185 = (state_54170__$1[(2)]);
var statearr_54189_54210 = state_54170__$1;
(statearr_54189_54210[(5)] = ex54185);


if((ex54185 instanceof Error)){
var statearr_54190_54211 = state_54170__$1;
(statearr_54190_54211[(1)] = (4));

(statearr_54190_54211[(5)] = null);

} else {
throw ex54185;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (14))){
var inst_54146 = (state_54170[(9)]);
var inst_54139 = (state_54170[(10)]);
var inst_54153 = (state_54170[(2)]);
var inst_54154 = fluree.db.util.async.throw_err(inst_54153);
var inst_54155 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54139,inst_54154);
var inst_54138 = inst_54146;
var inst_54139__$1 = inst_54155;
var state_54170__$1 = (function (){var statearr_54191 = state_54170;
(statearr_54191[(7)] = inst_54138);

(statearr_54191[(10)] = inst_54139__$1);

return statearr_54191;
})();
var statearr_54192_54212 = state_54170__$1;
(statearr_54192_54212[(2)] = null);

(statearr_54192_54212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (10))){
var inst_54163 = (state_54170[(2)]);
var state_54170__$1 = state_54170;
var statearr_54193_54213 = state_54170__$1;
(statearr_54193_54213[(2)] = inst_54163);

(statearr_54193_54213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54171 === (8))){
var inst_54139 = (state_54170[(10)]);
var state_54170__$1 = state_54170;
var statearr_54194_54214 = state_54170__$1;
(statearr_54194_54214[(2)] = inst_54139);

(statearr_54194_54214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0 = (function (){
var statearr_54195 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54195[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__);

(statearr_54195[(1)] = (1));

return statearr_54195;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1 = (function (state_54170){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54170);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54196){var ex__2417__auto__ = e54196;
var statearr_54197_54215 = state_54170;
(statearr_54197_54215[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54170[(4)]))){
var statearr_54198_54216 = state_54170;
(statearr_54198_54216[(1)] = cljs.core.first((state_54170[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54217 = state_54170;
state_54170 = G__54217;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__ = function(state_54170){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1.call(this,state_54170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54199 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54199[(6)] = c__2436__auto__);

return statearr_54199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54218 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54218,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54218,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54266){
var state_val_54267 = (state_54266[(1)]);
if((state_val_54267 === (7))){
var state_54266__$1 = state_54266;
var statearr_54268_54297 = state_54266__$1;
(statearr_54268_54297[(2)] = coll);

(statearr_54268_54297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (1))){
var state_54266__$1 = state_54266;
var statearr_54269_54298 = state_54266__$1;
(statearr_54269_54298[(2)] = null);

(statearr_54269_54298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (4))){
var inst_54221 = (state_54266[(2)]);
var state_54266__$1 = state_54266;
var statearr_54270_54299 = state_54266__$1;
(statearr_54270_54299[(2)] = inst_54221);

(statearr_54270_54299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (15))){
var inst_54240 = (state_54266[(7)]);
var inst_54248 = (state_54266[(2)]);
var inst_54249 = fluree.db.dbfunctions.internal.nth(inst_54240,inst_54248);
var inst_54250 = cljs.core.count(inst_54240);
var inst_54251 = ((9) + inst_54250);
var inst_54252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54253 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54255 = [inst_54240,inst_54248];
var inst_54256 = (new cljs.core.PersistentVector(null,2,(5),inst_54254,inst_54255,null));
var inst_54257 = ["nth",inst_54256,inst_54249];
var inst_54258 = cljs.core.PersistentHashMap.fromArrays(inst_54253,inst_54257);
var inst_54259 = [inst_54258,inst_54251];
var inst_54260 = (new cljs.core.PersistentVector(null,2,(5),inst_54252,inst_54259,null));
var inst_54261 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54260);
var _ = (function (){var statearr_54271 = state_54266;
(statearr_54271[(4)] = cljs.core.rest((state_54266[(4)])));

return statearr_54271;
})();
var state_54266__$1 = (function (){var statearr_54272 = state_54266;
(statearr_54272[(8)] = inst_54261);

return statearr_54272;
})();
var statearr_54273_54300 = state_54266__$1;
(statearr_54273_54300[(2)] = inst_54249);

(statearr_54273_54300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (13))){
var state_54266__$1 = state_54266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54266__$1,(16),key);
} else {
if((state_val_54267 === (6))){
var state_54266__$1 = state_54266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54266__$1,(9),coll);
} else {
if((state_val_54267 === (3))){
var inst_54264 = (state_54266[(2)]);
var state_54266__$1 = state_54266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54266__$1,inst_54264);
} else {
if((state_val_54267 === (12))){
var inst_54240 = (state_54266[(2)]);
var inst_54241 = fluree.db.util.async.channel_QMARK_(key);
var state_54266__$1 = (function (){var statearr_54274 = state_54266;
(statearr_54274[(7)] = inst_54240);

return statearr_54274;
})();
if(inst_54241){
var statearr_54275_54301 = state_54266__$1;
(statearr_54275_54301[(1)] = (13));

} else {
var statearr_54276_54302 = state_54266__$1;
(statearr_54276_54302[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (2))){
var _ = (function (){var statearr_54277 = state_54266;
(statearr_54277[(4)] = cljs.core.cons((5),(state_54266[(4)])));

return statearr_54277;
})();
var inst_54227 = fluree.db.util.async.channel_QMARK_(coll);
var state_54266__$1 = state_54266;
if(inst_54227){
var statearr_54278_54303 = state_54266__$1;
(statearr_54278_54303[(1)] = (6));

} else {
var statearr_54279_54304 = state_54266__$1;
(statearr_54279_54304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (11))){
var inst_54234 = (state_54266[(9)]);
var state_54266__$1 = state_54266;
var statearr_54281_54305 = state_54266__$1;
(statearr_54281_54305[(2)] = inst_54234);

(statearr_54281_54305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (9))){
var inst_54230 = (state_54266[(2)]);
var inst_54231 = fluree.db.util.async.throw_err(inst_54230);
var state_54266__$1 = state_54266;
var statearr_54282_54306 = state_54266__$1;
(statearr_54282_54306[(2)] = inst_54231);

(statearr_54282_54306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (5))){
var _ = (function (){var statearr_54283 = state_54266;
(statearr_54283[(4)] = cljs.core.rest((state_54266[(4)])));

return statearr_54283;
})();
var state_54266__$1 = state_54266;
var ex54280 = (state_54266__$1[(2)]);
var statearr_54284_54307 = state_54266__$1;
(statearr_54284_54307[(5)] = ex54280);


if((ex54280 instanceof Error)){
var statearr_54285_54308 = state_54266__$1;
(statearr_54285_54308[(1)] = (4));

(statearr_54285_54308[(5)] = null);

} else {
throw ex54280;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (14))){
var state_54266__$1 = state_54266;
var statearr_54286_54309 = state_54266__$1;
(statearr_54286_54309[(2)] = key);

(statearr_54286_54309[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (16))){
var inst_54244 = (state_54266[(2)]);
var inst_54245 = fluree.db.util.async.throw_err(inst_54244);
var state_54266__$1 = state_54266;
var statearr_54287_54310 = state_54266__$1;
(statearr_54287_54310[(2)] = inst_54245);

(statearr_54287_54310[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (10))){
var inst_54234 = (state_54266[(9)]);
var inst_54237 = cljs.core.vec(inst_54234);
var state_54266__$1 = state_54266;
var statearr_54288_54311 = state_54266__$1;
(statearr_54288_54311[(2)] = inst_54237);

(statearr_54288_54311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54267 === (8))){
var inst_54234 = (state_54266[(9)]);
var inst_54234__$1 = (state_54266[(2)]);
var inst_54235 = cljs.core.set_QMARK_(inst_54234__$1);
var state_54266__$1 = (function (){var statearr_54289 = state_54266;
(statearr_54289[(9)] = inst_54234__$1);

return statearr_54289;
})();
if(inst_54235){
var statearr_54290_54312 = state_54266__$1;
(statearr_54290_54312[(1)] = (10));

} else {
var statearr_54291_54313 = state_54266__$1;
(statearr_54291_54313[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0 = (function (){
var statearr_54292 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54292[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__);

(statearr_54292[(1)] = (1));

return statearr_54292;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1 = (function (state_54266){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54266);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54293){var ex__2417__auto__ = e54293;
var statearr_54294_54314 = state_54266;
(statearr_54294_54314[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54266[(4)]))){
var statearr_54295_54315 = state_54266;
(statearr_54295_54315[(1)] = cljs.core.first((state_54266[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54316 = state_54266;
state_54266 = G__54316;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__ = function(state_54266){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1.call(this,state_54266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54296 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54296[(6)] = c__2436__auto__);

return statearr_54296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54377){
var state_val_54378 = (state_54377[(1)]);
if((state_val_54378 === (7))){
var state_54377__$1 = state_54377;
var statearr_54379_54413 = state_54377__$1;
(statearr_54379_54413[(2)] = test);

(statearr_54379_54413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (20))){
var inst_54351 = (state_54377[(2)]);
var inst_54352 = fluree.db.util.async.throw_err(inst_54351);
var state_54377__$1 = state_54377;
var statearr_54380_54414 = state_54377__$1;
(statearr_54380_54414[(2)] = inst_54352);

(statearr_54380_54414[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (1))){
var state_54377__$1 = state_54377;
var statearr_54381_54415 = state_54377__$1;
(statearr_54381_54415[(2)] = null);

(statearr_54381_54415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (4))){
var inst_54317 = (state_54377[(2)]);
var state_54377__$1 = state_54377;
var statearr_54382_54416 = state_54377__$1;
(statearr_54382_54416[(2)] = inst_54317);

(statearr_54382_54416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (15))){
var inst_54335 = (state_54377[(7)]);
var inst_54343 = (state_54377[(2)]);
var inst_54344 = [inst_54343,f];
var inst_54345 = (new cljs.core.PersistentVector(null,2,(5),inst_54335,inst_54344,null));
var state_54377__$1 = state_54377;
var statearr_54383_54417 = state_54377__$1;
(statearr_54383_54417[(2)] = inst_54345);

(statearr_54383_54417[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (13))){
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54377__$1,(16),t);
} else {
if((state_val_54378 === (6))){
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54377__$1,(9),test);
} else {
if((state_val_54378 === (17))){
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54377__$1,(20),f);
} else {
if((state_val_54378 === (3))){
var inst_54375 = (state_54377[(2)]);
var state_54377__$1 = state_54377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54377__$1,inst_54375);
} else {
if((state_val_54378 === (12))){
var inst_54333 = (state_54377[(8)]);
var inst_54359 = (state_54377[(2)]);
var inst_54360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54359,(0),null);
var inst_54361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54359,(1),null);
var inst_54362 = fluree.db.dbfunctions.internal.if_else(inst_54333,inst_54360,inst_54361);
var inst_54363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54364 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54366 = [inst_54333,inst_54360,inst_54361];
var inst_54367 = (new cljs.core.PersistentVector(null,3,(5),inst_54365,inst_54366,null));
var inst_54368 = ["if-else",inst_54367,inst_54362];
var inst_54369 = cljs.core.PersistentHashMap.fromArrays(inst_54364,inst_54368);
var inst_54370 = [inst_54369,(10)];
var inst_54371 = (new cljs.core.PersistentVector(null,2,(5),inst_54363,inst_54370,null));
var inst_54372 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54371);
var _ = (function (){var statearr_54384 = state_54377;
(statearr_54384[(4)] = cljs.core.rest((state_54377[(4)])));

return statearr_54384;
})();
var state_54377__$1 = (function (){var statearr_54385 = state_54377;
(statearr_54385[(9)] = inst_54372);

return statearr_54385;
})();
var statearr_54386_54418 = state_54377__$1;
(statearr_54386_54418[(2)] = inst_54362);

(statearr_54386_54418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (2))){
var _ = (function (){var statearr_54387 = state_54377;
(statearr_54387[(4)] = cljs.core.cons((5),(state_54377[(4)])));

return statearr_54387;
})();
var inst_54326 = fluree.db.util.async.channel_QMARK_(test);
var state_54377__$1 = state_54377;
if(inst_54326){
var statearr_54388_54419 = state_54377__$1;
(statearr_54388_54419[(1)] = (6));

} else {
var statearr_54389_54420 = state_54377__$1;
(statearr_54389_54420[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (19))){
var inst_54347 = (state_54377[(10)]);
var inst_54355 = (state_54377[(2)]);
var inst_54356 = [f,inst_54355];
var inst_54357 = (new cljs.core.PersistentVector(null,2,(5),inst_54347,inst_54356,null));
var state_54377__$1 = state_54377;
var statearr_54390_54421 = state_54377__$1;
(statearr_54390_54421[(2)] = inst_54357);

(statearr_54390_54421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (11))){
var inst_54347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54348 = fluree.db.util.async.channel_QMARK_(f);
var state_54377__$1 = (function (){var statearr_54392 = state_54377;
(statearr_54392[(10)] = inst_54347);

return statearr_54392;
})();
if(inst_54348){
var statearr_54393_54422 = state_54377__$1;
(statearr_54393_54422[(1)] = (17));

} else {
var statearr_54394_54423 = state_54377__$1;
(statearr_54394_54423[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (9))){
var inst_54329 = (state_54377[(2)]);
var inst_54330 = fluree.db.util.async.throw_err(inst_54329);
var state_54377__$1 = state_54377;
var statearr_54395_54424 = state_54377__$1;
(statearr_54395_54424[(2)] = inst_54330);

(statearr_54395_54424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (5))){
var _ = (function (){var statearr_54396 = state_54377;
(statearr_54396[(4)] = cljs.core.rest((state_54377[(4)])));

return statearr_54396;
})();
var state_54377__$1 = state_54377;
var ex54391 = (state_54377__$1[(2)]);
var statearr_54397_54425 = state_54377__$1;
(statearr_54397_54425[(5)] = ex54391);


if((ex54391 instanceof Error)){
var statearr_54398_54426 = state_54377__$1;
(statearr_54398_54426[(1)] = (4));

(statearr_54398_54426[(5)] = null);

} else {
throw ex54391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (14))){
var state_54377__$1 = state_54377;
var statearr_54399_54427 = state_54377__$1;
(statearr_54399_54427[(2)] = t);

(statearr_54399_54427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (16))){
var inst_54339 = (state_54377[(2)]);
var inst_54340 = fluree.db.util.async.throw_err(inst_54339);
var state_54377__$1 = state_54377;
var statearr_54400_54428 = state_54377__$1;
(statearr_54400_54428[(2)] = inst_54340);

(statearr_54400_54428[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (10))){
var inst_54335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54336 = fluree.db.util.async.channel_QMARK_(t);
var state_54377__$1 = (function (){var statearr_54401 = state_54377;
(statearr_54401[(7)] = inst_54335);

return statearr_54401;
})();
if(inst_54336){
var statearr_54402_54429 = state_54377__$1;
(statearr_54402_54429[(1)] = (13));

} else {
var statearr_54403_54430 = state_54377__$1;
(statearr_54403_54430[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (18))){
var state_54377__$1 = state_54377;
var statearr_54404_54431 = state_54377__$1;
(statearr_54404_54431[(2)] = f);

(statearr_54404_54431[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54378 === (8))){
var inst_54333 = (state_54377[(8)]);
var inst_54333__$1 = (state_54377[(2)]);
var state_54377__$1 = (function (){var statearr_54405 = state_54377;
(statearr_54405[(8)] = inst_54333__$1);

return statearr_54405;
})();
if(cljs.core.truth_(inst_54333__$1)){
var statearr_54406_54432 = state_54377__$1;
(statearr_54406_54432[(1)] = (10));

} else {
var statearr_54407_54433 = state_54377__$1;
(statearr_54407_54433[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0 = (function (){
var statearr_54408 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54408[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__);

(statearr_54408[(1)] = (1));

return statearr_54408;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1 = (function (state_54377){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54377);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54409){var ex__2417__auto__ = e54409;
var statearr_54410_54434 = state_54377;
(statearr_54410_54434[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54377[(4)]))){
var statearr_54411_54435 = state_54377;
(statearr_54411_54435[(1)] = cljs.core.first((state_54377[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54436 = state_54377;
state_54377 = G__54436;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__ = function(state_54377){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1.call(this,state_54377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54412 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54412[(6)] = c__2436__auto__);

return statearr_54412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54466){
var state_val_54467 = (state_54466[(1)]);
if((state_val_54467 === (7))){
var state_54466__$1 = state_54466;
var statearr_54468_54487 = state_54466__$1;
(statearr_54468_54487[(2)] = arg);

(statearr_54468_54487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (1))){
var state_54466__$1 = state_54466;
var statearr_54469_54488 = state_54466__$1;
(statearr_54469_54488[(2)] = null);

(statearr_54469_54488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (4))){
var inst_54437 = (state_54466[(2)]);
var state_54466__$1 = state_54466;
var statearr_54470_54489 = state_54466__$1;
(statearr_54470_54489[(2)] = inst_54437);

(statearr_54470_54489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (6))){
var state_54466__$1 = state_54466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54466__$1,(9),arg);
} else {
if((state_val_54467 === (3))){
var inst_54464 = (state_54466[(2)]);
var state_54466__$1 = state_54466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54466__$1,inst_54464);
} else {
if((state_val_54467 === (2))){
var _ = (function (){var statearr_54472 = state_54466;
(statearr_54472[(4)] = cljs.core.cons((5),(state_54466[(4)])));

return statearr_54472;
})();
var inst_54443 = fluree.db.util.async.channel_QMARK_(arg);
var state_54466__$1 = state_54466;
if(inst_54443){
var statearr_54473_54490 = state_54466__$1;
(statearr_54473_54490[(1)] = (6));

} else {
var statearr_54474_54491 = state_54466__$1;
(statearr_54474_54491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (9))){
var inst_54446 = (state_54466[(2)]);
var inst_54447 = fluree.db.util.async.throw_err(inst_54446);
var state_54466__$1 = state_54466;
var statearr_54475_54492 = state_54466__$1;
(statearr_54475_54492[(2)] = inst_54447);

(statearr_54475_54492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (5))){
var _ = (function (){var statearr_54476 = state_54466;
(statearr_54476[(4)] = cljs.core.rest((state_54466[(4)])));

return statearr_54476;
})();
var state_54466__$1 = state_54466;
var ex54471 = (state_54466__$1[(2)]);
var statearr_54477_54493 = state_54466__$1;
(statearr_54477_54493[(5)] = ex54471);


if((ex54471 instanceof Error)){
var statearr_54478_54494 = state_54466__$1;
(statearr_54478_54494[(1)] = (4));

(statearr_54478_54494[(5)] = null);

} else {
throw ex54471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54467 === (8))){
var inst_54450 = (state_54466[(2)]);
var inst_54451 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54450);
var inst_54452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54453 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54455 = [inst_54450];
var inst_54456 = (new cljs.core.PersistentVector(null,1,(5),inst_54454,inst_54455,null));
var inst_54457 = ["nil?",inst_54456,inst_54451];
var inst_54458 = cljs.core.PersistentHashMap.fromArrays(inst_54453,inst_54457);
var inst_54459 = [inst_54458,(10)];
var inst_54460 = (new cljs.core.PersistentVector(null,2,(5),inst_54452,inst_54459,null));
var inst_54461 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54460);
var _ = (function (){var statearr_54479 = state_54466;
(statearr_54479[(4)] = cljs.core.rest((state_54466[(4)])));

return statearr_54479;
})();
var state_54466__$1 = (function (){var statearr_54480 = state_54466;
(statearr_54480[(7)] = inst_54461);

return statearr_54480;
})();
var statearr_54481_54495 = state_54466__$1;
(statearr_54481_54495[(2)] = inst_54451);

(statearr_54481_54495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_54482 = [null,null,null,null,null,null,null,null];
(statearr_54482[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__);

(statearr_54482[(1)] = (1));

return statearr_54482;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1 = (function (state_54466){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54466);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54483){var ex__2417__auto__ = e54483;
var statearr_54484_54496 = state_54466;
(statearr_54484_54496[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54466[(4)]))){
var statearr_54485_54497 = state_54466;
(statearr_54485_54497[(1)] = cljs.core.first((state_54466[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54498 = state_54466;
state_54466 = G__54498;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__ = function(state_54466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1.call(this,state_54466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54486 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54486[(6)] = c__2436__auto__);

return statearr_54486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54528){
var state_val_54529 = (state_54528[(1)]);
if((state_val_54529 === (7))){
var state_54528__$1 = state_54528;
var statearr_54530_54549 = state_54528__$1;
(statearr_54530_54549[(2)] = arg);

(statearr_54530_54549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (1))){
var state_54528__$1 = state_54528;
var statearr_54531_54550 = state_54528__$1;
(statearr_54531_54550[(2)] = null);

(statearr_54531_54550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (4))){
var inst_54499 = (state_54528[(2)]);
var state_54528__$1 = state_54528;
var statearr_54532_54551 = state_54528__$1;
(statearr_54532_54551[(2)] = inst_54499);

(statearr_54532_54551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (6))){
var state_54528__$1 = state_54528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54528__$1,(9),arg);
} else {
if((state_val_54529 === (3))){
var inst_54526 = (state_54528[(2)]);
var state_54528__$1 = state_54528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54528__$1,inst_54526);
} else {
if((state_val_54529 === (2))){
var _ = (function (){var statearr_54534 = state_54528;
(statearr_54534[(4)] = cljs.core.cons((5),(state_54528[(4)])));

return statearr_54534;
})();
var inst_54505 = fluree.db.util.async.channel_QMARK_(arg);
var state_54528__$1 = state_54528;
if(inst_54505){
var statearr_54535_54552 = state_54528__$1;
(statearr_54535_54552[(1)] = (6));

} else {
var statearr_54536_54553 = state_54528__$1;
(statearr_54536_54553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (9))){
var inst_54508 = (state_54528[(2)]);
var inst_54509 = fluree.db.util.async.throw_err(inst_54508);
var state_54528__$1 = state_54528;
var statearr_54537_54554 = state_54528__$1;
(statearr_54537_54554[(2)] = inst_54509);

(statearr_54537_54554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (5))){
var _ = (function (){var statearr_54538 = state_54528;
(statearr_54538[(4)] = cljs.core.rest((state_54528[(4)])));

return statearr_54538;
})();
var state_54528__$1 = state_54528;
var ex54533 = (state_54528__$1[(2)]);
var statearr_54539_54555 = state_54528__$1;
(statearr_54539_54555[(5)] = ex54533);


if((ex54533 instanceof Error)){
var statearr_54540_54556 = state_54528__$1;
(statearr_54540_54556[(1)] = (4));

(statearr_54540_54556[(5)] = null);

} else {
throw ex54533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54529 === (8))){
var inst_54512 = (state_54528[(2)]);
var inst_54513 = fluree.db.dbfunctions.internal.not(inst_54512);
var inst_54514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54515 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54517 = [inst_54512];
var inst_54518 = (new cljs.core.PersistentVector(null,1,(5),inst_54516,inst_54517,null));
var inst_54519 = ["not?",inst_54518,inst_54513];
var inst_54520 = cljs.core.PersistentHashMap.fromArrays(inst_54515,inst_54519);
var inst_54521 = [inst_54520,(10)];
var inst_54522 = (new cljs.core.PersistentVector(null,2,(5),inst_54514,inst_54521,null));
var inst_54523 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54522);
var _ = (function (){var statearr_54541 = state_54528;
(statearr_54541[(4)] = cljs.core.rest((state_54528[(4)])));

return statearr_54541;
})();
var state_54528__$1 = (function (){var statearr_54542 = state_54528;
(statearr_54542[(7)] = inst_54523);

return statearr_54542;
})();
var statearr_54543_54557 = state_54528__$1;
(statearr_54543_54557[(2)] = inst_54513);

(statearr_54543_54557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0 = (function (){
var statearr_54544 = [null,null,null,null,null,null,null,null];
(statearr_54544[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__);

(statearr_54544[(1)] = (1));

return statearr_54544;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1 = (function (state_54528){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54528);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54545){var ex__2417__auto__ = e54545;
var statearr_54546_54558 = state_54528;
(statearr_54546_54558[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54528[(4)]))){
var statearr_54547_54559 = state_54528;
(statearr_54547_54559[(1)] = cljs.core.first((state_54528[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54560 = state_54528;
state_54528 = G__54560;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__ = function(state_54528){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1.call(this,state_54528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54548 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54548[(6)] = c__2436__auto__);

return statearr_54548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54590){
var state_val_54591 = (state_54590[(1)]);
if((state_val_54591 === (7))){
var state_54590__$1 = state_54590;
var statearr_54592_54611 = state_54590__$1;
(statearr_54592_54611[(2)] = arg);

(statearr_54592_54611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (1))){
var state_54590__$1 = state_54590;
var statearr_54593_54612 = state_54590__$1;
(statearr_54593_54612[(2)] = null);

(statearr_54593_54612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (4))){
var inst_54561 = (state_54590[(2)]);
var state_54590__$1 = state_54590;
var statearr_54594_54613 = state_54590__$1;
(statearr_54594_54613[(2)] = inst_54561);

(statearr_54594_54613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (6))){
var state_54590__$1 = state_54590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54590__$1,(9),arg);
} else {
if((state_val_54591 === (3))){
var inst_54588 = (state_54590[(2)]);
var state_54590__$1 = state_54590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54590__$1,inst_54588);
} else {
if((state_val_54591 === (2))){
var _ = (function (){var statearr_54596 = state_54590;
(statearr_54596[(4)] = cljs.core.cons((5),(state_54590[(4)])));

return statearr_54596;
})();
var inst_54567 = fluree.db.util.async.channel_QMARK_(arg);
var state_54590__$1 = state_54590;
if(inst_54567){
var statearr_54597_54614 = state_54590__$1;
(statearr_54597_54614[(1)] = (6));

} else {
var statearr_54598_54615 = state_54590__$1;
(statearr_54598_54615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (9))){
var inst_54570 = (state_54590[(2)]);
var inst_54571 = fluree.db.util.async.throw_err(inst_54570);
var state_54590__$1 = state_54590;
var statearr_54599_54616 = state_54590__$1;
(statearr_54599_54616[(2)] = inst_54571);

(statearr_54599_54616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (5))){
var _ = (function (){var statearr_54600 = state_54590;
(statearr_54600[(4)] = cljs.core.rest((state_54590[(4)])));

return statearr_54600;
})();
var state_54590__$1 = state_54590;
var ex54595 = (state_54590__$1[(2)]);
var statearr_54601_54617 = state_54590__$1;
(statearr_54601_54617[(5)] = ex54595);


if((ex54595 instanceof Error)){
var statearr_54602_54618 = state_54590__$1;
(statearr_54602_54618[(1)] = (4));

(statearr_54602_54618[(5)] = null);

} else {
throw ex54595;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54591 === (8))){
var inst_54574 = (state_54590[(2)]);
var inst_54575 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54574);
var inst_54576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54577 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54579 = [inst_54574];
var inst_54580 = (new cljs.core.PersistentVector(null,1,(5),inst_54578,inst_54579,null));
var inst_54581 = ["empty?",inst_54580,inst_54575];
var inst_54582 = cljs.core.PersistentHashMap.fromArrays(inst_54577,inst_54581);
var inst_54583 = [inst_54582,(10)];
var inst_54584 = (new cljs.core.PersistentVector(null,2,(5),inst_54576,inst_54583,null));
var inst_54585 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54584);
var _ = (function (){var statearr_54603 = state_54590;
(statearr_54603[(4)] = cljs.core.rest((state_54590[(4)])));

return statearr_54603;
})();
var state_54590__$1 = (function (){var statearr_54604 = state_54590;
(statearr_54604[(7)] = inst_54585);

return statearr_54604;
})();
var statearr_54605_54619 = state_54590__$1;
(statearr_54605_54619[(2)] = inst_54575);

(statearr_54605_54619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_54606 = [null,null,null,null,null,null,null,null];
(statearr_54606[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__);

(statearr_54606[(1)] = (1));

return statearr_54606;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1 = (function (state_54590){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54590);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54607){var ex__2417__auto__ = e54607;
var statearr_54608_54620 = state_54590;
(statearr_54608_54620[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54590[(4)]))){
var statearr_54609_54621 = state_54590;
(statearr_54609_54621[(1)] = cljs.core.first((state_54590[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54622 = state_54590;
state_54590 = G__54622;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__ = function(state_54590){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1.call(this,state_54590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54610 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54610[(6)] = c__2436__auto__);

return statearr_54610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54667 = arguments.length;
var i__4737__auto___54668 = (0);
while(true){
if((i__4737__auto___54668 < len__4736__auto___54667)){
args__4742__auto__.push((arguments[i__4737__auto___54668]));

var G__54669 = (i__4737__auto___54668 + (1));
i__4737__auto___54668 = G__54669;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54650){
var state_val_54651 = (state_54650[(1)]);
if((state_val_54651 === (1))){
var state_54650__$1 = state_54650;
var statearr_54652_54670 = state_54650__$1;
(statearr_54652_54670[(2)] = null);

(statearr_54652_54670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54651 === (2))){
var _ = (function (){var statearr_54653 = state_54650;
(statearr_54653[(4)] = cljs.core.cons((5),(state_54650[(4)])));

return statearr_54653;
})();
var inst_54631 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54650__$1 = state_54650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54650__$1,(6),inst_54631);
} else {
if((state_val_54651 === (3))){
var inst_54648 = (state_54650[(2)]);
var state_54650__$1 = state_54650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54650__$1,inst_54648);
} else {
if((state_val_54651 === (4))){
var inst_54625 = (state_54650[(2)]);
var state_54650__$1 = state_54650;
var statearr_54655_54671 = state_54650__$1;
(statearr_54655_54671[(2)] = inst_54625);

(statearr_54655_54671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54651 === (5))){
var _ = (function (){var statearr_54656 = state_54650;
(statearr_54656[(4)] = cljs.core.rest((state_54650[(4)])));

return statearr_54656;
})();
var state_54650__$1 = state_54650;
var ex54654 = (state_54650__$1[(2)]);
var statearr_54657_54672 = state_54650__$1;
(statearr_54657_54672[(5)] = ex54654);


if((ex54654 instanceof Error)){
var statearr_54658_54673 = state_54650__$1;
(statearr_54658_54673[(1)] = (4));

(statearr_54658_54673[(5)] = null);

} else {
throw ex54654;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54651 === (6))){
var inst_54633 = (state_54650[(2)]);
var inst_54634 = fluree.db.util.async.throw_err(inst_54633);
var inst_54635 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54634);
var inst_54636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54637 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54639 = [inst_54634];
var inst_54640 = (new cljs.core.PersistentVector(null,1,(5),inst_54638,inst_54639,null));
var inst_54641 = ["str",inst_54640,inst_54635];
var inst_54642 = cljs.core.PersistentHashMap.fromArrays(inst_54637,inst_54641);
var inst_54643 = [inst_54642,(10)];
var inst_54644 = (new cljs.core.PersistentVector(null,2,(5),inst_54636,inst_54643,null));
var inst_54645 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54644);
var _ = (function (){var statearr_54659 = state_54650;
(statearr_54659[(4)] = cljs.core.rest((state_54650[(4)])));

return statearr_54659;
})();
var state_54650__$1 = (function (){var statearr_54660 = state_54650;
(statearr_54660[(7)] = inst_54645);

return statearr_54660;
})();
var statearr_54661_54674 = state_54650__$1;
(statearr_54661_54674[(2)] = inst_54635);

(statearr_54661_54674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54662 = [null,null,null,null,null,null,null,null];
(statearr_54662[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54662[(1)] = (1));

return statearr_54662;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54650){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54650);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54663){var ex__2417__auto__ = e54663;
var statearr_54664_54675 = state_54650;
(statearr_54664_54675[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54650[(4)]))){
var statearr_54665_54676 = state_54650;
(statearr_54665_54676[(1)] = cljs.core.first((state_54650[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54677 = state_54650;
state_54650 = G__54677;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54650){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54666 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54666[(6)] = c__2436__auto__);

return statearr_54666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54623){
var G__54624 = cljs.core.first(seq54623);
var seq54623__$1 = cljs.core.next(seq54623);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54624,seq54623__$1);
}));

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54707){
var state_val_54708 = (state_54707[(1)]);
if((state_val_54708 === (7))){
var state_54707__$1 = state_54707;
var statearr_54709_54728 = state_54707__$1;
(statearr_54709_54728[(2)] = str);

(statearr_54709_54728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (1))){
var state_54707__$1 = state_54707;
var statearr_54710_54729 = state_54707__$1;
(statearr_54710_54729[(2)] = null);

(statearr_54710_54729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (4))){
var inst_54678 = (state_54707[(2)]);
var state_54707__$1 = state_54707;
var statearr_54711_54730 = state_54707__$1;
(statearr_54711_54730[(2)] = inst_54678);

(statearr_54711_54730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (6))){
var state_54707__$1 = state_54707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54707__$1,(9),str);
} else {
if((state_val_54708 === (3))){
var inst_54705 = (state_54707[(2)]);
var state_54707__$1 = state_54707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54707__$1,inst_54705);
} else {
if((state_val_54708 === (2))){
var _ = (function (){var statearr_54713 = state_54707;
(statearr_54713[(4)] = cljs.core.cons((5),(state_54707[(4)])));

return statearr_54713;
})();
var inst_54684 = fluree.db.util.async.channel_QMARK_(str);
var state_54707__$1 = state_54707;
if(inst_54684){
var statearr_54714_54731 = state_54707__$1;
(statearr_54714_54731[(1)] = (6));

} else {
var statearr_54715_54732 = state_54707__$1;
(statearr_54715_54732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (9))){
var inst_54687 = (state_54707[(2)]);
var inst_54688 = fluree.db.util.async.throw_err(inst_54687);
var state_54707__$1 = state_54707;
var statearr_54716_54733 = state_54707__$1;
(statearr_54716_54733[(2)] = inst_54688);

(statearr_54716_54733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (5))){
var _ = (function (){var statearr_54717 = state_54707;
(statearr_54717[(4)] = cljs.core.rest((state_54707[(4)])));

return statearr_54717;
})();
var state_54707__$1 = state_54707;
var ex54712 = (state_54707__$1[(2)]);
var statearr_54718_54734 = state_54707__$1;
(statearr_54718_54734[(5)] = ex54712);


if((ex54712 instanceof Error)){
var statearr_54719_54735 = state_54707__$1;
(statearr_54719_54735[(1)] = (4));

(statearr_54719_54735[(5)] = null);

} else {
throw ex54712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54708 === (8))){
var inst_54691 = (state_54707[(2)]);
var inst_54692 = fluree.db.dbfunctions.internal.lower_case(inst_54691);
var inst_54693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54694 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54696 = [inst_54691];
var inst_54697 = (new cljs.core.PersistentVector(null,1,(5),inst_54695,inst_54696,null));
var inst_54698 = ["lower-case",inst_54697,inst_54692];
var inst_54699 = cljs.core.PersistentHashMap.fromArrays(inst_54694,inst_54698);
var inst_54700 = [inst_54699,(10)];
var inst_54701 = (new cljs.core.PersistentVector(null,2,(5),inst_54693,inst_54700,null));
var inst_54702 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54701);
var _ = (function (){var statearr_54720 = state_54707;
(statearr_54720[(4)] = cljs.core.rest((state_54707[(4)])));

return statearr_54720;
})();
var state_54707__$1 = (function (){var statearr_54721 = state_54707;
(statearr_54721[(7)] = inst_54702);

return statearr_54721;
})();
var statearr_54722_54736 = state_54707__$1;
(statearr_54722_54736[(2)] = inst_54692);

(statearr_54722_54736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0 = (function (){
var statearr_54723 = [null,null,null,null,null,null,null,null];
(statearr_54723[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__);

(statearr_54723[(1)] = (1));

return statearr_54723;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1 = (function (state_54707){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54707);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54724){var ex__2417__auto__ = e54724;
var statearr_54725_54737 = state_54707;
(statearr_54725_54737[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54707[(4)]))){
var statearr_54726_54738 = state_54707;
(statearr_54726_54738[(1)] = cljs.core.first((state_54707[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54739 = state_54707;
state_54707 = G__54739;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__ = function(state_54707){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1.call(this,state_54707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54727 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54727[(6)] = c__2436__auto__);

return statearr_54727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54769){
var state_val_54770 = (state_54769[(1)]);
if((state_val_54770 === (7))){
var state_54769__$1 = state_54769;
var statearr_54771_54790 = state_54769__$1;
(statearr_54771_54790[(2)] = str);

(statearr_54771_54790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (1))){
var state_54769__$1 = state_54769;
var statearr_54772_54791 = state_54769__$1;
(statearr_54772_54791[(2)] = null);

(statearr_54772_54791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (4))){
var inst_54740 = (state_54769[(2)]);
var state_54769__$1 = state_54769;
var statearr_54773_54792 = state_54769__$1;
(statearr_54773_54792[(2)] = inst_54740);

(statearr_54773_54792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (6))){
var state_54769__$1 = state_54769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54769__$1,(9),str);
} else {
if((state_val_54770 === (3))){
var inst_54767 = (state_54769[(2)]);
var state_54769__$1 = state_54769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54769__$1,inst_54767);
} else {
if((state_val_54770 === (2))){
var _ = (function (){var statearr_54775 = state_54769;
(statearr_54775[(4)] = cljs.core.cons((5),(state_54769[(4)])));

return statearr_54775;
})();
var inst_54746 = fluree.db.util.async.channel_QMARK_(str);
var state_54769__$1 = state_54769;
if(inst_54746){
var statearr_54776_54793 = state_54769__$1;
(statearr_54776_54793[(1)] = (6));

} else {
var statearr_54777_54794 = state_54769__$1;
(statearr_54777_54794[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (9))){
var inst_54749 = (state_54769[(2)]);
var inst_54750 = fluree.db.util.async.throw_err(inst_54749);
var state_54769__$1 = state_54769;
var statearr_54778_54795 = state_54769__$1;
(statearr_54778_54795[(2)] = inst_54750);

(statearr_54778_54795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (5))){
var _ = (function (){var statearr_54779 = state_54769;
(statearr_54779[(4)] = cljs.core.rest((state_54769[(4)])));

return statearr_54779;
})();
var state_54769__$1 = state_54769;
var ex54774 = (state_54769__$1[(2)]);
var statearr_54780_54796 = state_54769__$1;
(statearr_54780_54796[(5)] = ex54774);


if((ex54774 instanceof Error)){
var statearr_54781_54797 = state_54769__$1;
(statearr_54781_54797[(1)] = (4));

(statearr_54781_54797[(5)] = null);

} else {
throw ex54774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54770 === (8))){
var inst_54753 = (state_54769[(2)]);
var inst_54754 = fluree.db.dbfunctions.internal.upper_case(inst_54753);
var inst_54755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54756 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54758 = [inst_54753];
var inst_54759 = (new cljs.core.PersistentVector(null,1,(5),inst_54757,inst_54758,null));
var inst_54760 = ["upper-case",inst_54759,inst_54754];
var inst_54761 = cljs.core.PersistentHashMap.fromArrays(inst_54756,inst_54760);
var inst_54762 = [inst_54761,(10)];
var inst_54763 = (new cljs.core.PersistentVector(null,2,(5),inst_54755,inst_54762,null));
var inst_54764 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54763);
var _ = (function (){var statearr_54782 = state_54769;
(statearr_54782[(4)] = cljs.core.rest((state_54769[(4)])));

return statearr_54782;
})();
var state_54769__$1 = (function (){var statearr_54783 = state_54769;
(statearr_54783[(7)] = inst_54764);

return statearr_54783;
})();
var statearr_54784_54798 = state_54769__$1;
(statearr_54784_54798[(2)] = inst_54754);

(statearr_54784_54798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0 = (function (){
var statearr_54785 = [null,null,null,null,null,null,null,null];
(statearr_54785[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__);

(statearr_54785[(1)] = (1));

return statearr_54785;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1 = (function (state_54769){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54769);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54786){var ex__2417__auto__ = e54786;
var statearr_54787_54799 = state_54769;
(statearr_54787_54799[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54769[(4)]))){
var statearr_54788_54800 = state_54769;
(statearr_54788_54800[(1)] = cljs.core.first((state_54769[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54801 = state_54769;
state_54769 = G__54801;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__ = function(state_54769){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1.call(this,state_54769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54789 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54789[(6)] = c__2436__auto__);

return statearr_54789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54803 = arguments.length;
switch (G__54803) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54831){
var state_val_54832 = (state_54831[(1)]);
if((state_val_54832 === (1))){
var state_54831__$1 = state_54831;
var statearr_54833_54849 = state_54831__$1;
(statearr_54833_54849[(2)] = null);

(statearr_54833_54849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54832 === (2))){
var _ = (function (){var statearr_54834 = state_54831;
(statearr_54834[(4)] = cljs.core.cons((5),(state_54831[(4)])));

return statearr_54834;
})();
var inst_54813 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54831__$1 = state_54831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54831__$1,(6),inst_54813);
} else {
if((state_val_54832 === (3))){
var inst_54829 = (state_54831[(2)]);
var state_54831__$1 = state_54831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54831__$1,inst_54829);
} else {
if((state_val_54832 === (4))){
var inst_54804 = (state_54831[(2)]);
var state_54831__$1 = state_54831;
var statearr_54836_54850 = state_54831__$1;
(statearr_54836_54850[(2)] = inst_54804);

(statearr_54836_54850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54832 === (5))){
var _ = (function (){var statearr_54837 = state_54831;
(statearr_54837[(4)] = cljs.core.rest((state_54831[(4)])));

return statearr_54837;
})();
var state_54831__$1 = state_54831;
var ex54835 = (state_54831__$1[(2)]);
var statearr_54838_54851 = state_54831__$1;
(statearr_54838_54851[(5)] = ex54835);


if((ex54835 instanceof Error)){
var statearr_54839_54852 = state_54831__$1;
(statearr_54839_54852[(1)] = (4));

(statearr_54839_54852[(5)] = null);

} else {
throw ex54835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54832 === (6))){
var inst_54815 = (state_54831[(2)]);
var inst_54816 = fluree.db.util.async.throw_err(inst_54815);
var inst_54817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54816,(0),null);
var inst_54818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54816,(1),null);
var inst_54819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54820 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54821 = ["?s","?ctx",inst_54817];
var inst_54822 = cljs.core.PersistentHashMap.fromArrays(inst_54820,inst_54821);
var inst_54823 = ((10) + inst_54818);
var inst_54824 = [inst_54822,inst_54823];
var inst_54825 = (new cljs.core.PersistentVector(null,2,(5),inst_54819,inst_54824,null));
var inst_54826 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54825);
var _ = (function (){var statearr_54840 = state_54831;
(statearr_54840[(4)] = cljs.core.rest((state_54831[(4)])));

return statearr_54840;
})();
var state_54831__$1 = (function (){var statearr_54841 = state_54831;
(statearr_54841[(7)] = inst_54826);

return statearr_54841;
})();
var statearr_54842_54853 = state_54831__$1;
(statearr_54842_54853[(2)] = inst_54817);

(statearr_54842_54853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54843 = [null,null,null,null,null,null,null,null];
(statearr_54843[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54843[(1)] = (1));

return statearr_54843;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54831){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54831);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54844){var ex__2417__auto__ = e54844;
var statearr_54845_54854 = state_54831;
(statearr_54845_54854[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54831[(4)]))){
var statearr_54846_54855 = state_54831;
(statearr_54846_54855[(1)] = cljs.core.first((state_54831[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54856 = state_54831;
state_54831 = G__54856;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54831){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54847 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54847[(6)] = c__2436__auto__);

return statearr_54847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54858 = arguments.length;
switch (G__54858) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54896){
var state_val_54897 = (state_54896[(1)]);
if((state_val_54897 === (7))){
var inst_54889 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54896__$1 = state_54896;
var statearr_54898_54918 = state_54896__$1;
(statearr_54898_54918[(2)] = inst_54889);

(statearr_54898_54918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (1))){
var state_54896__$1 = state_54896;
var statearr_54899_54919 = state_54896__$1;
(statearr_54899_54919[(2)] = null);

(statearr_54899_54919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (4))){
var inst_54859 = (state_54896[(2)]);
var state_54896__$1 = state_54896;
var statearr_54900_54920 = state_54896__$1;
(statearr_54900_54920[(2)] = inst_54859);

(statearr_54900_54920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (6))){
var inst_54870 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54896__$1 = state_54896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54896__$1,(10),inst_54870);
} else {
if((state_val_54897 === (3))){
var inst_54894 = (state_54896[(2)]);
var state_54896__$1 = state_54896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54896__$1,inst_54894);
} else {
if((state_val_54897 === (2))){
var _ = (function (){var statearr_54902 = state_54896;
(statearr_54902[(4)] = cljs.core.cons((5),(state_54896[(4)])));

return statearr_54902;
})();
var inst_54865 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54896__$1 = state_54896;
if(cljs.core.truth_(inst_54865)){
var statearr_54903_54921 = state_54896__$1;
(statearr_54903_54921[(1)] = (6));

} else {
var statearr_54904_54922 = state_54896__$1;
(statearr_54904_54922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (9))){
var inst_54876 = (state_54896[(2)]);
var inst_54877 = fluree.db.util.async.throw_err(inst_54876);
var inst_54878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54877,(0),null);
var inst_54879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54877,(1),null);
var inst_54880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54881 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54882 = ["?p","?ctx",inst_54878];
var inst_54883 = cljs.core.PersistentHashMap.fromArrays(inst_54881,inst_54882);
var inst_54884 = ((10) + inst_54879);
var inst_54885 = [inst_54883,inst_54884];
var inst_54886 = (new cljs.core.PersistentVector(null,2,(5),inst_54880,inst_54885,null));
var inst_54887 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54886);
var state_54896__$1 = (function (){var statearr_54905 = state_54896;
(statearr_54905[(7)] = inst_54887);

return statearr_54905;
})();
var statearr_54906_54923 = state_54896__$1;
(statearr_54906_54923[(2)] = inst_54878);

(statearr_54906_54923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (5))){
var _ = (function (){var statearr_54907 = state_54896;
(statearr_54907[(4)] = cljs.core.rest((state_54896[(4)])));

return statearr_54907;
})();
var state_54896__$1 = state_54896;
var ex54901 = (state_54896__$1[(2)]);
var statearr_54908_54924 = state_54896__$1;
(statearr_54908_54924[(5)] = ex54901);


if((ex54901 instanceof Error)){
var statearr_54909_54925 = state_54896__$1;
(statearr_54909_54925[(1)] = (4));

(statearr_54909_54925[(5)] = null);

} else {
throw ex54901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54897 === (10))){
var inst_54872 = (state_54896[(2)]);
var inst_54873 = fluree.db.util.async.throw_err(inst_54872);
var inst_54874 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54873);
var state_54896__$1 = state_54896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54896__$1,(9),inst_54874);
} else {
if((state_val_54897 === (8))){
var inst_54891 = (state_54896[(2)]);
var _ = (function (){var statearr_54910 = state_54896;
(statearr_54910[(4)] = cljs.core.rest((state_54896[(4)])));

return statearr_54910;
})();
var state_54896__$1 = state_54896;
var statearr_54911_54926 = state_54896__$1;
(statearr_54911_54926[(2)] = inst_54891);

(statearr_54911_54926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54912 = [null,null,null,null,null,null,null,null];
(statearr_54912[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54912[(1)] = (1));

return statearr_54912;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54896){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54896);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54913){var ex__2417__auto__ = e54913;
var statearr_54914_54927 = state_54896;
(statearr_54914_54927[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54896[(4)]))){
var statearr_54915_54928 = state_54896;
(statearr_54915_54928[(1)] = cljs.core.first((state_54896[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54929 = state_54896;
state_54896 = G__54929;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54896){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54916 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54916[(6)] = c__2436__auto__);

return statearr_54916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54978 = arguments.length;
var i__4737__auto___54979 = (0);
while(true){
if((i__4737__auto___54979 < len__4736__auto___54978)){
args__4742__auto__.push((arguments[i__4737__auto___54979]));

var G__54980 = (i__4737__auto___54979 + (1));
i__4737__auto___54979 = G__54980;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54961){
var state_val_54962 = (state_54961[(1)]);
if((state_val_54962 === (1))){
var state_54961__$1 = state_54961;
var statearr_54963_54981 = state_54961__$1;
(statearr_54963_54981[(2)] = null);

(statearr_54963_54981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (2))){
var _ = (function (){var statearr_54964 = state_54961;
(statearr_54964[(4)] = cljs.core.cons((5),(state_54961[(4)])));

return statearr_54964;
})();
var inst_54938 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54961__$1 = state_54961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54961__$1,(6),inst_54938);
} else {
if((state_val_54962 === (3))){
var inst_54959 = (state_54961[(2)]);
var state_54961__$1 = state_54961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54961__$1,inst_54959);
} else {
if((state_val_54962 === (4))){
var inst_54932 = (state_54961[(2)]);
var state_54961__$1 = state_54961;
var statearr_54966_54982 = state_54961__$1;
(statearr_54966_54982[(2)] = inst_54932);

(statearr_54966_54982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (5))){
var _ = (function (){var statearr_54967 = state_54961;
(statearr_54967[(4)] = cljs.core.rest((state_54961[(4)])));

return statearr_54967;
})();
var state_54961__$1 = state_54961;
var ex54965 = (state_54961__$1[(2)]);
var statearr_54968_54983 = state_54961__$1;
(statearr_54968_54983[(5)] = ex54965);


if((ex54965 instanceof Error)){
var statearr_54969_54984 = state_54961__$1;
(statearr_54969_54984[(1)] = (4));

(statearr_54969_54984[(5)] = null);

} else {
throw ex54965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54962 === (6))){
var inst_54940 = (state_54961[(2)]);
var inst_54941 = fluree.db.util.async.throw_err(inst_54940);
var inst_54942 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54941);
var inst_54943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54944 = [inst_54941];
var inst_54945 = (new cljs.core.PersistentVector(null,1,(5),inst_54943,inst_54944,null));
var inst_54946 = cljs.core.count(inst_54945);
var inst_54947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54948 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54950 = [inst_54941];
var inst_54951 = (new cljs.core.PersistentVector(null,1,(5),inst_54949,inst_54950,null));
var inst_54952 = ["and",inst_54951,inst_54942];
var inst_54953 = cljs.core.PersistentHashMap.fromArrays(inst_54948,inst_54952);
var inst_54954 = [inst_54953,inst_54946];
var inst_54955 = (new cljs.core.PersistentVector(null,2,(5),inst_54947,inst_54954,null));
var inst_54956 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54955);
var _ = (function (){var statearr_54970 = state_54961;
(statearr_54970[(4)] = cljs.core.rest((state_54961[(4)])));

return statearr_54970;
})();
var state_54961__$1 = (function (){var statearr_54971 = state_54961;
(statearr_54971[(7)] = inst_54956);

return statearr_54971;
})();
var statearr_54972_54985 = state_54961__$1;
(statearr_54972_54985[(2)] = inst_54942);

(statearr_54972_54985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54973 = [null,null,null,null,null,null,null,null];
(statearr_54973[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54973[(1)] = (1));

return statearr_54973;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54961){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54961);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54974){var ex__2417__auto__ = e54974;
var statearr_54975_54986 = state_54961;
(statearr_54975_54986[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54961[(4)]))){
var statearr_54976_54987 = state_54961;
(statearr_54976_54987[(1)] = cljs.core.first((state_54961[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54988 = state_54961;
state_54961 = G__54988;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54961){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54977 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54977[(6)] = c__2436__auto__);

return statearr_54977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54930){
var G__54931 = cljs.core.first(seq54930);
var seq54930__$1 = cljs.core.next(seq54930);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54931,seq54930__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55037 = arguments.length;
var i__4737__auto___55038 = (0);
while(true){
if((i__4737__auto___55038 < len__4736__auto___55037)){
args__4742__auto__.push((arguments[i__4737__auto___55038]));

var G__55039 = (i__4737__auto___55038 + (1));
i__4737__auto___55038 = G__55039;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55020){
var state_val_55021 = (state_55020[(1)]);
if((state_val_55021 === (1))){
var state_55020__$1 = state_55020;
var statearr_55022_55040 = state_55020__$1;
(statearr_55022_55040[(2)] = null);

(statearr_55022_55040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55021 === (2))){
var _ = (function (){var statearr_55023 = state_55020;
(statearr_55023[(4)] = cljs.core.cons((5),(state_55020[(4)])));

return statearr_55023;
})();
var inst_54997 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55020__$1 = state_55020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55020__$1,(6),inst_54997);
} else {
if((state_val_55021 === (3))){
var inst_55018 = (state_55020[(2)]);
var state_55020__$1 = state_55020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55020__$1,inst_55018);
} else {
if((state_val_55021 === (4))){
var inst_54991 = (state_55020[(2)]);
var state_55020__$1 = state_55020;
var statearr_55025_55041 = state_55020__$1;
(statearr_55025_55041[(2)] = inst_54991);

(statearr_55025_55041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55021 === (5))){
var _ = (function (){var statearr_55026 = state_55020;
(statearr_55026[(4)] = cljs.core.rest((state_55020[(4)])));

return statearr_55026;
})();
var state_55020__$1 = state_55020;
var ex55024 = (state_55020__$1[(2)]);
var statearr_55027_55042 = state_55020__$1;
(statearr_55027_55042[(5)] = ex55024);


if((ex55024 instanceof Error)){
var statearr_55028_55043 = state_55020__$1;
(statearr_55028_55043[(1)] = (4));

(statearr_55028_55043[(5)] = null);

} else {
throw ex55024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55021 === (6))){
var inst_54999 = (state_55020[(2)]);
var inst_55000 = fluree.db.util.async.throw_err(inst_54999);
var inst_55001 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55000);
var inst_55002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55003 = [inst_55000];
var inst_55004 = (new cljs.core.PersistentVector(null,1,(5),inst_55002,inst_55003,null));
var inst_55005 = cljs.core.count(inst_55004);
var inst_55006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55007 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55009 = [inst_55000];
var inst_55010 = (new cljs.core.PersistentVector(null,1,(5),inst_55008,inst_55009,null));
var inst_55011 = ["or",inst_55010,inst_55001];
var inst_55012 = cljs.core.PersistentHashMap.fromArrays(inst_55007,inst_55011);
var inst_55013 = [inst_55012,inst_55005];
var inst_55014 = (new cljs.core.PersistentVector(null,2,(5),inst_55006,inst_55013,null));
var inst_55015 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55014);
var _ = (function (){var statearr_55029 = state_55020;
(statearr_55029[(4)] = cljs.core.rest((state_55020[(4)])));

return statearr_55029;
})();
var state_55020__$1 = (function (){var statearr_55030 = state_55020;
(statearr_55030[(7)] = inst_55015);

return statearr_55030;
})();
var statearr_55031_55044 = state_55020__$1;
(statearr_55031_55044[(2)] = inst_55001);

(statearr_55031_55044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55032 = [null,null,null,null,null,null,null,null];
(statearr_55032[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55032[(1)] = (1));

return statearr_55032;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55020){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55020);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55033){var ex__2417__auto__ = e55033;
var statearr_55034_55045 = state_55020;
(statearr_55034_55045[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55020[(4)]))){
var statearr_55035_55046 = state_55020;
(statearr_55035_55046[(1)] = cljs.core.first((state_55020[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55047 = state_55020;
state_55020 = G__55047;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55020){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55036 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55036[(6)] = c__2436__auto__);

return statearr_55036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54989){
var G__54990 = cljs.core.first(seq54989);
var seq54989__$1 = cljs.core.next(seq54989);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54990,seq54989__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55085){
var state_val_55086 = (state_55085[(1)]);
if((state_val_55086 === (7))){
var inst_55061 = fluree.db.util.async.channel_QMARK_(coll);
var state_55085__$1 = state_55085;
if(inst_55061){
var statearr_55087_55110 = state_55085__$1;
(statearr_55087_55110[(1)] = (10));

} else {
var statearr_55088_55111 = state_55085__$1;
(statearr_55088_55111[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (1))){
var state_55085__$1 = state_55085;
var statearr_55089_55112 = state_55085__$1;
(statearr_55089_55112[(2)] = null);

(statearr_55089_55112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (4))){
var inst_55048 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
var statearr_55090_55113 = state_55085__$1;
(statearr_55090_55113[(2)] = inst_55048);

(statearr_55090_55113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (13))){
var inst_55064 = (state_55085[(2)]);
var inst_55065 = fluree.db.util.async.throw_err(inst_55064);
var state_55085__$1 = state_55085;
var statearr_55091_55114 = state_55085__$1;
(statearr_55091_55114[(2)] = inst_55065);

(statearr_55091_55114[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (6))){
var inst_55056 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55085__$1,(9),inst_55056);
} else {
if((state_val_55086 === (3))){
var inst_55083 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55085__$1,inst_55083);
} else {
if((state_val_55086 === (12))){
var inst_55068 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
var statearr_55092_55115 = state_55085__$1;
(statearr_55092_55115[(2)] = inst_55068);

(statearr_55092_55115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (2))){
var _ = (function (){var statearr_55093 = state_55085;
(statearr_55093[(4)] = cljs.core.cons((5),(state_55085[(4)])));

return statearr_55093;
})();
var inst_55054 = cljs.core.vector_QMARK_(coll);
var state_55085__$1 = state_55085;
if(inst_55054){
var statearr_55094_55116 = state_55085__$1;
(statearr_55094_55116[(1)] = (6));

} else {
var statearr_55095_55117 = state_55085__$1;
(statearr_55095_55117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (11))){
var state_55085__$1 = state_55085;
var statearr_55097_55118 = state_55085__$1;
(statearr_55097_55118[(2)] = coll);

(statearr_55097_55118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (9))){
var inst_55058 = (state_55085[(2)]);
var inst_55059 = fluree.db.util.async.throw_err(inst_55058);
var state_55085__$1 = state_55085;
var statearr_55098_55119 = state_55085__$1;
(statearr_55098_55119[(2)] = inst_55059);

(statearr_55098_55119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (5))){
var _ = (function (){var statearr_55099 = state_55085;
(statearr_55099[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55099;
})();
var state_55085__$1 = state_55085;
var ex55096 = (state_55085__$1[(2)]);
var statearr_55100_55120 = state_55085__$1;
(statearr_55100_55120[(5)] = ex55096);


if((ex55096 instanceof Error)){
var statearr_55101_55121 = state_55085__$1;
(statearr_55101_55121[(1)] = (4));

(statearr_55101_55121[(5)] = null);

} else {
throw ex55096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (10))){
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55085__$1,(13),coll);
} else {
if((state_val_55086 === (8))){
var inst_55070 = (state_55085[(2)]);
var inst_55071 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55070);
var inst_55072 = cljs.core.count(inst_55071);
var inst_55073 = ((9) + inst_55072);
var inst_55074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55075 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55076 = ["count",inst_55070,inst_55072];
var inst_55077 = cljs.core.PersistentHashMap.fromArrays(inst_55075,inst_55076);
var inst_55078 = [inst_55077,inst_55073];
var inst_55079 = (new cljs.core.PersistentVector(null,2,(5),inst_55074,inst_55078,null));
var inst_55080 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55079);
var _ = (function (){var statearr_55102 = state_55085;
(statearr_55102[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55102;
})();
var state_55085__$1 = (function (){var statearr_55103 = state_55085;
(statearr_55103[(7)] = inst_55080);

return statearr_55103;
})();
var statearr_55104_55122 = state_55085__$1;
(statearr_55104_55122[(2)] = inst_55072);

(statearr_55104_55122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0 = (function (){
var statearr_55105 = [null,null,null,null,null,null,null,null];
(statearr_55105[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__);

(statearr_55105[(1)] = (1));

return statearr_55105;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1 = (function (state_55085){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55085);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55106){var ex__2417__auto__ = e55106;
var statearr_55107_55123 = state_55085;
(statearr_55107_55123[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55085[(4)]))){
var statearr_55108_55124 = state_55085;
(statearr_55108_55124[(1)] = cljs.core.first((state_55085[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55125 = state_55085;
state_55085 = G__55125;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__ = function(state_55085){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1.call(this,state_55085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55109 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55109[(6)] = c__2436__auto__);

return statearr_55109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55175){
var state_val_55176 = (state_55175[(1)]);
if((state_val_55176 === (7))){
var state_55175__$1 = state_55175;
var statearr_55177_55210 = state_55175__$1;
(statearr_55177_55210[(2)] = subject);

(statearr_55177_55210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (1))){
var state_55175__$1 = state_55175;
var statearr_55178_55211 = state_55175__$1;
(statearr_55178_55211[(2)] = null);

(statearr_55178_55211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (4))){
var inst_55126 = (state_55175[(2)]);
var state_55175__$1 = state_55175;
var statearr_55179_55212 = state_55175__$1;
(statearr_55179_55212[(2)] = inst_55126);

(statearr_55179_55212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (15))){
var inst_55139 = (state_55175[(7)]);
var state_55175__$1 = state_55175;
var statearr_55180_55213 = state_55175__$1;
(statearr_55180_55213[(2)] = inst_55139);

(statearr_55180_55213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (13))){
var inst_55143 = (state_55175[(2)]);
var inst_55144 = fluree.db.util.async.throw_err(inst_55143);
var state_55175__$1 = state_55175;
var statearr_55181_55214 = state_55175__$1;
(statearr_55181_55214[(2)] = inst_55144);

(statearr_55181_55214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (6))){
var state_55175__$1 = state_55175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55175__$1,(9),subject);
} else {
if((state_val_55176 === (17))){
var inst_55139 = (state_55175[(7)]);
var inst_55153 = cljs.core.first(inst_55139);
var state_55175__$1 = state_55175;
var statearr_55182_55215 = state_55175__$1;
(statearr_55182_55215[(2)] = inst_55153);

(statearr_55182_55215[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (3))){
var inst_55173 = (state_55175[(2)]);
var state_55175__$1 = state_55175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55175__$1,inst_55173);
} else {
if((state_val_55176 === (12))){
var inst_55139 = (state_55175[(7)]);
var inst_55147 = (state_55175[(2)]);
var inst_55148 = cljs.core.vector_QMARK_(inst_55139);
var state_55175__$1 = (function (){var statearr_55183 = state_55175;
(statearr_55183[(8)] = inst_55147);

return statearr_55183;
})();
if(inst_55148){
var statearr_55184_55216 = state_55175__$1;
(statearr_55184_55216[(1)] = (14));

} else {
var statearr_55185_55217 = state_55175__$1;
(statearr_55185_55217[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (2))){
var _ = (function (){var statearr_55186 = state_55175;
(statearr_55186[(4)] = cljs.core.cons((5),(state_55175[(4)])));

return statearr_55186;
})();
var inst_55132 = fluree.db.util.async.channel_QMARK_(subject);
var state_55175__$1 = state_55175;
if(inst_55132){
var statearr_55187_55218 = state_55175__$1;
(statearr_55187_55218[(1)] = (6));

} else {
var statearr_55188_55219 = state_55175__$1;
(statearr_55188_55219[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (19))){
var inst_55156 = (state_55175[(2)]);
var state_55175__$1 = state_55175;
var statearr_55189_55220 = state_55175__$1;
(statearr_55189_55220[(2)] = inst_55156);

(statearr_55189_55220[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (11))){
var state_55175__$1 = state_55175;
var statearr_55191_55221 = state_55175__$1;
(statearr_55191_55221[(2)] = pred);

(statearr_55191_55221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (9))){
var inst_55135 = (state_55175[(2)]);
var inst_55136 = fluree.db.util.async.throw_err(inst_55135);
var state_55175__$1 = state_55175;
var statearr_55192_55222 = state_55175__$1;
(statearr_55192_55222[(2)] = inst_55136);

(statearr_55192_55222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (5))){
var _ = (function (){var statearr_55193 = state_55175;
(statearr_55193[(4)] = cljs.core.rest((state_55175[(4)])));

return statearr_55193;
})();
var state_55175__$1 = state_55175;
var ex55190 = (state_55175__$1[(2)]);
var statearr_55194_55223 = state_55175__$1;
(statearr_55194_55223[(5)] = ex55190);


if((ex55190 instanceof Error)){
var statearr_55195_55224 = state_55175__$1;
(statearr_55195_55224[(1)] = (4));

(statearr_55195_55224[(5)] = null);

} else {
throw ex55190;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (14))){
var inst_55139 = (state_55175[(7)]);
var inst_55150 = cljs.core.count(inst_55139);
var inst_55151 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55150);
var state_55175__$1 = state_55175;
if(inst_55151){
var statearr_55196_55225 = state_55175__$1;
(statearr_55196_55225[(1)] = (17));

} else {
var statearr_55197_55226 = state_55175__$1;
(statearr_55197_55226[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (16))){
var inst_55139 = (state_55175[(7)]);
var inst_55147 = (state_55175[(8)]);
var inst_55159 = (state_55175[(2)]);
var inst_55160 = fluree.db.dbfunctions.internal.get(inst_55159,inst_55147);
var inst_55161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55162 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55164 = [inst_55139,inst_55147];
var inst_55165 = (new cljs.core.PersistentVector(null,2,(5),inst_55163,inst_55164,null));
var inst_55166 = ["get",inst_55165,inst_55160];
var inst_55167 = cljs.core.PersistentHashMap.fromArrays(inst_55162,inst_55166);
var inst_55168 = [inst_55167,(10)];
var inst_55169 = (new cljs.core.PersistentVector(null,2,(5),inst_55161,inst_55168,null));
var inst_55170 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55169);
var _ = (function (){var statearr_55198 = state_55175;
(statearr_55198[(4)] = cljs.core.rest((state_55175[(4)])));

return statearr_55198;
})();
var state_55175__$1 = (function (){var statearr_55199 = state_55175;
(statearr_55199[(9)] = inst_55170);

return statearr_55199;
})();
var statearr_55200_55227 = state_55175__$1;
(statearr_55200_55227[(2)] = inst_55160);

(statearr_55200_55227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (10))){
var state_55175__$1 = state_55175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55175__$1,(13),pred);
} else {
if((state_val_55176 === (18))){
var inst_55139 = (state_55175[(7)]);
var state_55175__$1 = state_55175;
var statearr_55201_55228 = state_55175__$1;
(statearr_55201_55228[(2)] = inst_55139);

(statearr_55201_55228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (8))){
var inst_55139 = (state_55175[(2)]);
var inst_55140 = fluree.db.util.async.channel_QMARK_(pred);
var state_55175__$1 = (function (){var statearr_55202 = state_55175;
(statearr_55202[(7)] = inst_55139);

return statearr_55202;
})();
if(inst_55140){
var statearr_55203_55229 = state_55175__$1;
(statearr_55203_55229[(1)] = (10));

} else {
var statearr_55204_55230 = state_55175__$1;
(statearr_55204_55230[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0 = (function (){
var statearr_55205 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55205[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__);

(statearr_55205[(1)] = (1));

return statearr_55205;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1 = (function (state_55175){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55175);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55206){var ex__2417__auto__ = e55206;
var statearr_55207_55231 = state_55175;
(statearr_55207_55231[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55175[(4)]))){
var statearr_55208_55232 = state_55175;
(statearr_55208_55232[(1)] = cljs.core.first((state_55175[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55233 = state_55175;
state_55175 = G__55233;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__ = function(state_55175){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1.call(this,state_55175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55209 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55209[(6)] = c__2436__auto__);

return statearr_55209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55272){
var state_val_55273 = (state_55272[(1)]);
if((state_val_55273 === (7))){
var inst_55240 = (state_55272[(7)]);
var state_55272__$1 = state_55272;
var statearr_55274_55298 = state_55272__$1;
(statearr_55274_55298[(2)] = inst_55240);

(statearr_55274_55298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (1))){
var state_55272__$1 = state_55272;
var statearr_55275_55299 = state_55272__$1;
(statearr_55275_55299[(2)] = null);

(statearr_55275_55299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (4))){
var inst_55234 = (state_55272[(2)]);
var state_55272__$1 = state_55272;
var statearr_55276_55300 = state_55272__$1;
(statearr_55276_55300[(2)] = inst_55234);

(statearr_55276_55300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (6))){
var inst_55242 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55272__$1 = state_55272;
var statearr_55277_55301 = state_55272__$1;
(statearr_55277_55301[(2)] = inst_55242);

(statearr_55277_55301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (3))){
var inst_55270 = (state_55272[(2)]);
var state_55272__$1 = state_55272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55272__$1,inst_55270);
} else {
if((state_val_55273 === (12))){
var inst_55252 = (state_55272[(2)]);
var inst_55253 = fluree.db.util.async.throw_err(inst_55252);
var inst_55254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55253,(0),null);
var inst_55255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55253,(1),null);
var inst_55256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55257 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55258 = ["?pO","?ctx",inst_55254];
var inst_55259 = cljs.core.PersistentHashMap.fromArrays(inst_55257,inst_55258);
var inst_55260 = ((10) + inst_55255);
var inst_55261 = [inst_55259,inst_55260];
var inst_55262 = (new cljs.core.PersistentVector(null,2,(5),inst_55256,inst_55261,null));
var inst_55263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55262);
var state_55272__$1 = (function (){var statearr_55278 = state_55272;
(statearr_55278[(8)] = inst_55263);

return statearr_55278;
})();
var statearr_55279_55302 = state_55272__$1;
(statearr_55279_55302[(2)] = inst_55254);

(statearr_55279_55302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (2))){
var inst_55240 = (state_55272[(7)]);
var _ = (function (){var statearr_55280 = state_55272;
(statearr_55280[(4)] = cljs.core.cons((5),(state_55272[(4)])));

return statearr_55280;
})();
var inst_55240__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55272__$1 = (function (){var statearr_55281 = state_55272;
(statearr_55281[(7)] = inst_55240__$1);

return statearr_55281;
})();
if(cljs.core.truth_(inst_55240__$1)){
var statearr_55282_55303 = state_55272__$1;
(statearr_55282_55303[(1)] = (6));

} else {
var statearr_55283_55304 = state_55272__$1;
(statearr_55283_55304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (11))){
var inst_55267 = (state_55272[(2)]);
var _ = (function (){var statearr_55285 = state_55272;
(statearr_55285[(4)] = cljs.core.rest((state_55272[(4)])));

return statearr_55285;
})();
var state_55272__$1 = state_55272;
var statearr_55286_55305 = state_55272__$1;
(statearr_55286_55305[(2)] = inst_55267);

(statearr_55286_55305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (9))){
var inst_55250 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55272__$1 = state_55272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55272__$1,(12),inst_55250);
} else {
if((state_val_55273 === (5))){
var _ = (function (){var statearr_55287 = state_55272;
(statearr_55287[(4)] = cljs.core.rest((state_55272[(4)])));

return statearr_55287;
})();
var state_55272__$1 = state_55272;
var ex55284 = (state_55272__$1[(2)]);
var statearr_55288_55306 = state_55272__$1;
(statearr_55288_55306[(5)] = ex55284);


if((ex55284 instanceof Error)){
var statearr_55289_55307 = state_55272__$1;
(statearr_55289_55307[(1)] = (4));

(statearr_55289_55307[(5)] = null);

} else {
throw ex55284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (10))){
var inst_55265 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55272__$1 = state_55272;
var statearr_55290_55308 = state_55272__$1;
(statearr_55290_55308[(2)] = inst_55265);

(statearr_55290_55308[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55273 === (8))){
var inst_55245 = (state_55272[(2)]);
var state_55272__$1 = state_55272;
if(cljs.core.truth_(inst_55245)){
var statearr_55291_55309 = state_55272__$1;
(statearr_55291_55309[(1)] = (9));

} else {
var statearr_55292_55310 = state_55272__$1;
(statearr_55292_55310[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0 = (function (){
var statearr_55293 = [null,null,null,null,null,null,null,null,null];
(statearr_55293[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__);

(statearr_55293[(1)] = (1));

return statearr_55293;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1 = (function (state_55272){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55272);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55294){var ex__2417__auto__ = e55294;
var statearr_55295_55311 = state_55272;
(statearr_55295_55311[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55272[(4)]))){
var statearr_55296_55312 = state_55272;
(statearr_55296_55312[(1)] = cljs.core.first((state_55272[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55313 = state_55272;
state_55272 = G__55313;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__ = function(state_55272){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1.call(this,state_55272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55297 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55297[(6)] = c__2436__auto__);

return statearr_55297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55365){
var state_val_55366 = (state_55365[(1)]);
if((state_val_55366 === (7))){
var state_55365__$1 = state_55365;
var statearr_55367_55400 = state_55365__$1;
(statearr_55367_55400[(2)] = subject);

(statearr_55367_55400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (1))){
var state_55365__$1 = state_55365;
var statearr_55368_55401 = state_55365__$1;
(statearr_55368_55401[(2)] = null);

(statearr_55368_55401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (4))){
var inst_55314 = (state_55365[(2)]);
var state_55365__$1 = state_55365;
var statearr_55369_55402 = state_55365__$1;
(statearr_55369_55402[(2)] = inst_55314);

(statearr_55369_55402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (15))){
var inst_55327 = (state_55365[(7)]);
var state_55365__$1 = state_55365;
var statearr_55370_55403 = state_55365__$1;
(statearr_55370_55403[(2)] = inst_55327);

(statearr_55370_55403[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (13))){
var inst_55331 = (state_55365[(2)]);
var inst_55332 = fluree.db.util.async.throw_err(inst_55331);
var state_55365__$1 = state_55365;
var statearr_55371_55404 = state_55365__$1;
(statearr_55371_55404[(2)] = inst_55332);

(statearr_55371_55404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (6))){
var state_55365__$1 = state_55365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55365__$1,(9),subject);
} else {
if((state_val_55366 === (17))){
var inst_55327 = (state_55365[(7)]);
var inst_55341 = cljs.core.first(inst_55327);
var state_55365__$1 = state_55365;
var statearr_55372_55405 = state_55365__$1;
(statearr_55372_55405[(2)] = inst_55341);

(statearr_55372_55405[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (3))){
var inst_55363 = (state_55365[(2)]);
var state_55365__$1 = state_55365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55365__$1,inst_55363);
} else {
if((state_val_55366 === (12))){
var inst_55327 = (state_55365[(7)]);
var inst_55335 = (state_55365[(2)]);
var inst_55336 = cljs.core.vector_QMARK_(inst_55327);
var state_55365__$1 = (function (){var statearr_55373 = state_55365;
(statearr_55373[(8)] = inst_55335);

return statearr_55373;
})();
if(inst_55336){
var statearr_55374_55406 = state_55365__$1;
(statearr_55374_55406[(1)] = (14));

} else {
var statearr_55375_55407 = state_55365__$1;
(statearr_55375_55407[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (2))){
var _ = (function (){var statearr_55376 = state_55365;
(statearr_55376[(4)] = cljs.core.cons((5),(state_55365[(4)])));

return statearr_55376;
})();
var inst_55320 = fluree.db.util.async.channel_QMARK_(subject);
var state_55365__$1 = state_55365;
if(inst_55320){
var statearr_55377_55408 = state_55365__$1;
(statearr_55377_55408[(1)] = (6));

} else {
var statearr_55378_55409 = state_55365__$1;
(statearr_55378_55409[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (19))){
var inst_55344 = (state_55365[(2)]);
var state_55365__$1 = state_55365;
var statearr_55379_55410 = state_55365__$1;
(statearr_55379_55410[(2)] = inst_55344);

(statearr_55379_55410[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (11))){
var state_55365__$1 = state_55365;
var statearr_55381_55411 = state_55365__$1;
(statearr_55381_55411[(2)] = path);

(statearr_55381_55411[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (9))){
var inst_55323 = (state_55365[(2)]);
var inst_55324 = fluree.db.util.async.throw_err(inst_55323);
var state_55365__$1 = state_55365;
var statearr_55382_55412 = state_55365__$1;
(statearr_55382_55412[(2)] = inst_55324);

(statearr_55382_55412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (5))){
var _ = (function (){var statearr_55383 = state_55365;
(statearr_55383[(4)] = cljs.core.rest((state_55365[(4)])));

return statearr_55383;
})();
var state_55365__$1 = state_55365;
var ex55380 = (state_55365__$1[(2)]);
var statearr_55384_55413 = state_55365__$1;
(statearr_55384_55413[(5)] = ex55380);


if((ex55380 instanceof Error)){
var statearr_55385_55414 = state_55365__$1;
(statearr_55385_55414[(1)] = (4));

(statearr_55385_55414[(5)] = null);

} else {
throw ex55380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (14))){
var inst_55327 = (state_55365[(7)]);
var inst_55338 = cljs.core.count(inst_55327);
var inst_55339 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55338);
var state_55365__$1 = state_55365;
if(inst_55339){
var statearr_55386_55415 = state_55365__$1;
(statearr_55386_55415[(1)] = (17));

} else {
var statearr_55387_55416 = state_55365__$1;
(statearr_55387_55416[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (16))){
var inst_55327 = (state_55365[(7)]);
var inst_55335 = (state_55365[(8)]);
var inst_55347 = (state_55365[(2)]);
var inst_55348 = fluree.db.dbfunctions.internal.get_all(inst_55347,inst_55335);
var inst_55349 = cljs.core.count(inst_55335);
var inst_55350 = ((9) + inst_55349);
var inst_55351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55352 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55354 = [inst_55327,inst_55335];
var inst_55355 = (new cljs.core.PersistentVector(null,2,(5),inst_55353,inst_55354,null));
var inst_55356 = ["get-all",inst_55355,inst_55348];
var inst_55357 = cljs.core.PersistentHashMap.fromArrays(inst_55352,inst_55356);
var inst_55358 = [inst_55357,inst_55350];
var inst_55359 = (new cljs.core.PersistentVector(null,2,(5),inst_55351,inst_55358,null));
var inst_55360 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55359);
var _ = (function (){var statearr_55388 = state_55365;
(statearr_55388[(4)] = cljs.core.rest((state_55365[(4)])));

return statearr_55388;
})();
var state_55365__$1 = (function (){var statearr_55389 = state_55365;
(statearr_55389[(9)] = inst_55360);

return statearr_55389;
})();
var statearr_55390_55417 = state_55365__$1;
(statearr_55390_55417[(2)] = inst_55348);

(statearr_55390_55417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (10))){
var state_55365__$1 = state_55365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55365__$1,(13),path);
} else {
if((state_val_55366 === (18))){
var inst_55327 = (state_55365[(7)]);
var state_55365__$1 = state_55365;
var statearr_55391_55418 = state_55365__$1;
(statearr_55391_55418[(2)] = inst_55327);

(statearr_55391_55418[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55366 === (8))){
var inst_55327 = (state_55365[(2)]);
var inst_55328 = fluree.db.util.async.channel_QMARK_(path);
var state_55365__$1 = (function (){var statearr_55392 = state_55365;
(statearr_55392[(7)] = inst_55327);

return statearr_55392;
})();
if(inst_55328){
var statearr_55393_55419 = state_55365__$1;
(statearr_55393_55419[(1)] = (10));

} else {
var statearr_55394_55420 = state_55365__$1;
(statearr_55394_55420[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0 = (function (){
var statearr_55395 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55395[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__);

(statearr_55395[(1)] = (1));

return statearr_55395;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1 = (function (state_55365){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55365);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55396){var ex__2417__auto__ = e55396;
var statearr_55397_55421 = state_55365;
(statearr_55397_55421[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55365[(4)]))){
var statearr_55398_55422 = state_55365;
(statearr_55398_55422[(1)] = cljs.core.first((state_55365[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55423 = state_55365;
state_55365 = G__55423;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__ = function(state_55365){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1.call(this,state_55365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55399 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55399[(6)] = c__2436__auto__);

return statearr_55399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55462){
var state_val_55463 = (state_55462[(1)]);
if((state_val_55463 === (7))){
var state_55462__$1 = state_55462;
var statearr_55464_55488 = state_55462__$1;
(statearr_55464_55488[(2)] = subject);

(statearr_55464_55488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (1))){
var state_55462__$1 = state_55462;
var statearr_55465_55489 = state_55462__$1;
(statearr_55465_55489[(2)] = null);

(statearr_55465_55489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (4))){
var inst_55424 = (state_55462[(2)]);
var state_55462__$1 = state_55462;
var statearr_55466_55490 = state_55462__$1;
(statearr_55466_55490[(2)] = inst_55424);

(statearr_55466_55490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (13))){
var inst_55441 = (state_55462[(2)]);
var inst_55442 = fluree.db.util.async.throw_err(inst_55441);
var state_55462__$1 = state_55462;
var statearr_55467_55491 = state_55462__$1;
(statearr_55467_55491[(2)] = inst_55442);

(statearr_55467_55491[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (6))){
var state_55462__$1 = state_55462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55462__$1,(9),subject);
} else {
if((state_val_55463 === (3))){
var inst_55460 = (state_55462[(2)]);
var state_55462__$1 = state_55462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55462__$1,inst_55460);
} else {
if((state_val_55463 === (12))){
var inst_55437 = (state_55462[(7)]);
var inst_55445 = (state_55462[(2)]);
var inst_55446 = fluree.db.dbfunctions.internal.get_in(inst_55437,inst_55445);
var inst_55447 = cljs.core.count(inst_55445);
var inst_55448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55449 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55451 = [inst_55437,inst_55445];
var inst_55452 = (new cljs.core.PersistentVector(null,2,(5),inst_55450,inst_55451,null));
var inst_55453 = ["get-in",inst_55452,inst_55446];
var inst_55454 = cljs.core.PersistentHashMap.fromArrays(inst_55449,inst_55453);
var inst_55455 = [inst_55454,inst_55447];
var inst_55456 = (new cljs.core.PersistentVector(null,2,(5),inst_55448,inst_55455,null));
var inst_55457 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55456);
var _ = (function (){var statearr_55468 = state_55462;
(statearr_55468[(4)] = cljs.core.rest((state_55462[(4)])));

return statearr_55468;
})();
var state_55462__$1 = (function (){var statearr_55469 = state_55462;
(statearr_55469[(8)] = inst_55457);

return statearr_55469;
})();
var statearr_55470_55492 = state_55462__$1;
(statearr_55470_55492[(2)] = inst_55446);

(statearr_55470_55492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (2))){
var _ = (function (){var statearr_55471 = state_55462;
(statearr_55471[(4)] = cljs.core.cons((5),(state_55462[(4)])));

return statearr_55471;
})();
var inst_55430 = fluree.db.util.async.channel_QMARK_(subject);
var state_55462__$1 = state_55462;
if(inst_55430){
var statearr_55472_55493 = state_55462__$1;
(statearr_55472_55493[(1)] = (6));

} else {
var statearr_55473_55494 = state_55462__$1;
(statearr_55473_55494[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (11))){
var state_55462__$1 = state_55462;
var statearr_55475_55495 = state_55462__$1;
(statearr_55475_55495[(2)] = path);

(statearr_55475_55495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (9))){
var inst_55433 = (state_55462[(2)]);
var inst_55434 = fluree.db.util.async.throw_err(inst_55433);
var state_55462__$1 = state_55462;
var statearr_55476_55496 = state_55462__$1;
(statearr_55476_55496[(2)] = inst_55434);

(statearr_55476_55496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (5))){
var _ = (function (){var statearr_55477 = state_55462;
(statearr_55477[(4)] = cljs.core.rest((state_55462[(4)])));

return statearr_55477;
})();
var state_55462__$1 = state_55462;
var ex55474 = (state_55462__$1[(2)]);
var statearr_55478_55497 = state_55462__$1;
(statearr_55478_55497[(5)] = ex55474);


if((ex55474 instanceof Error)){
var statearr_55479_55498 = state_55462__$1;
(statearr_55479_55498[(1)] = (4));

(statearr_55479_55498[(5)] = null);

} else {
throw ex55474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55463 === (10))){
var state_55462__$1 = state_55462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55462__$1,(13),path);
} else {
if((state_val_55463 === (8))){
var inst_55437 = (state_55462[(2)]);
var inst_55438 = fluree.db.util.async.channel_QMARK_(path);
var state_55462__$1 = (function (){var statearr_55480 = state_55462;
(statearr_55480[(7)] = inst_55437);

return statearr_55480;
})();
if(inst_55438){
var statearr_55481_55499 = state_55462__$1;
(statearr_55481_55499[(1)] = (10));

} else {
var statearr_55482_55500 = state_55462__$1;
(statearr_55482_55500[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0 = (function (){
var statearr_55483 = [null,null,null,null,null,null,null,null,null];
(statearr_55483[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__);

(statearr_55483[(1)] = (1));

return statearr_55483;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1 = (function (state_55462){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55462);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55484){var ex__2417__auto__ = e55484;
var statearr_55485_55501 = state_55462;
(statearr_55485_55501[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55462[(4)]))){
var statearr_55486_55502 = state_55462;
(statearr_55486_55502[(1)] = cljs.core.first((state_55462[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55503 = state_55462;
state_55462 = G__55503;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__ = function(state_55462){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1.call(this,state_55462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55487 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55487[(6)] = c__2436__auto__);

return statearr_55487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55548){
var state_val_55549 = (state_55548[(1)]);
if((state_val_55549 === (7))){
var state_55548__$1 = state_55548;
var statearr_55550_55579 = state_55548__$1;
(statearr_55550_55579[(2)] = coll);

(statearr_55550_55579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (1))){
var state_55548__$1 = state_55548;
var statearr_55551_55580 = state_55548__$1;
(statearr_55551_55580[(2)] = null);

(statearr_55551_55580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (4))){
var inst_55504 = (state_55548[(2)]);
var state_55548__$1 = state_55548;
var statearr_55552_55581 = state_55548__$1;
(statearr_55552_55581[(2)] = inst_55504);

(statearr_55552_55581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (15))){
var inst_55524 = (state_55548[(7)]);
var inst_55532 = (state_55548[(2)]);
var inst_55533 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55524,inst_55532);
var inst_55534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55535 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55537 = [inst_55524,inst_55532];
var inst_55538 = (new cljs.core.PersistentVector(null,2,(5),inst_55536,inst_55537,null));
var inst_55539 = ["contains?",inst_55538,inst_55533];
var inst_55540 = cljs.core.PersistentHashMap.fromArrays(inst_55535,inst_55539);
var inst_55541 = [inst_55540,(10)];
var inst_55542 = (new cljs.core.PersistentVector(null,2,(5),inst_55534,inst_55541,null));
var inst_55543 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55542);
var _ = (function (){var statearr_55553 = state_55548;
(statearr_55553[(4)] = cljs.core.rest((state_55548[(4)])));

return statearr_55553;
})();
var state_55548__$1 = (function (){var statearr_55554 = state_55548;
(statearr_55554[(8)] = inst_55543);

return statearr_55554;
})();
var statearr_55555_55582 = state_55548__$1;
(statearr_55555_55582[(2)] = inst_55533);

(statearr_55555_55582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (13))){
var state_55548__$1 = state_55548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55548__$1,(16),key);
} else {
if((state_val_55549 === (6))){
var state_55548__$1 = state_55548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55548__$1,(9),coll);
} else {
if((state_val_55549 === (3))){
var inst_55546 = (state_55548[(2)]);
var state_55548__$1 = state_55548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55548__$1,inst_55546);
} else {
if((state_val_55549 === (12))){
var inst_55524 = (state_55548[(2)]);
var inst_55525 = fluree.db.util.async.channel_QMARK_(key);
var state_55548__$1 = (function (){var statearr_55556 = state_55548;
(statearr_55556[(7)] = inst_55524);

return statearr_55556;
})();
if(inst_55525){
var statearr_55557_55583 = state_55548__$1;
(statearr_55557_55583[(1)] = (13));

} else {
var statearr_55558_55584 = state_55548__$1;
(statearr_55558_55584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (2))){
var _ = (function (){var statearr_55559 = state_55548;
(statearr_55559[(4)] = cljs.core.cons((5),(state_55548[(4)])));

return statearr_55559;
})();
var inst_55510 = fluree.db.util.async.channel_QMARK_(coll);
var state_55548__$1 = state_55548;
if(inst_55510){
var statearr_55560_55585 = state_55548__$1;
(statearr_55560_55585[(1)] = (6));

} else {
var statearr_55561_55586 = state_55548__$1;
(statearr_55561_55586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (11))){
var inst_55517 = (state_55548[(9)]);
var inst_55521 = cljs.core.flatten(inst_55517);
var inst_55522 = cljs.core.set(inst_55521);
var state_55548__$1 = state_55548;
var statearr_55563_55587 = state_55548__$1;
(statearr_55563_55587[(2)] = inst_55522);

(statearr_55563_55587[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (9))){
var inst_55513 = (state_55548[(2)]);
var inst_55514 = fluree.db.util.async.throw_err(inst_55513);
var state_55548__$1 = state_55548;
var statearr_55564_55588 = state_55548__$1;
(statearr_55564_55588[(2)] = inst_55514);

(statearr_55564_55588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (5))){
var _ = (function (){var statearr_55565 = state_55548;
(statearr_55565[(4)] = cljs.core.rest((state_55548[(4)])));

return statearr_55565;
})();
var state_55548__$1 = state_55548;
var ex55562 = (state_55548__$1[(2)]);
var statearr_55566_55589 = state_55548__$1;
(statearr_55566_55589[(5)] = ex55562);


if((ex55562 instanceof Error)){
var statearr_55567_55590 = state_55548__$1;
(statearr_55567_55590[(1)] = (4));

(statearr_55567_55590[(5)] = null);

} else {
throw ex55562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (14))){
var state_55548__$1 = state_55548;
var statearr_55568_55591 = state_55548__$1;
(statearr_55568_55591[(2)] = key);

(statearr_55568_55591[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (16))){
var inst_55528 = (state_55548[(2)]);
var inst_55529 = fluree.db.util.async.throw_err(inst_55528);
var state_55548__$1 = state_55548;
var statearr_55569_55592 = state_55548__$1;
(statearr_55569_55592[(2)] = inst_55529);

(statearr_55569_55592[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (10))){
var inst_55517 = (state_55548[(9)]);
var state_55548__$1 = state_55548;
var statearr_55570_55593 = state_55548__$1;
(statearr_55570_55593[(2)] = inst_55517);

(statearr_55570_55593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55549 === (8))){
var inst_55517 = (state_55548[(9)]);
var inst_55517__$1 = (state_55548[(2)]);
var inst_55518 = cljs.core.set_QMARK_(inst_55517__$1);
var state_55548__$1 = (function (){var statearr_55571 = state_55548;
(statearr_55571[(9)] = inst_55517__$1);

return statearr_55571;
})();
if(inst_55518){
var statearr_55572_55594 = state_55548__$1;
(statearr_55572_55594[(1)] = (10));

} else {
var statearr_55573_55595 = state_55548__$1;
(statearr_55573_55595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_55574 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55574[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__);

(statearr_55574[(1)] = (1));

return statearr_55574;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1 = (function (state_55548){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55548);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55575){var ex__2417__auto__ = e55575;
var statearr_55576_55596 = state_55548;
(statearr_55576_55596[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55548[(4)]))){
var statearr_55577_55597 = state_55548;
(statearr_55577_55597[(1)] = cljs.core.first((state_55548[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55598 = state_55548;
state_55548 = G__55598;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__ = function(state_55548){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1.call(this,state_55548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55578 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55578[(6)] = c__2436__auto__);

return statearr_55578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55663 = arguments.length;
var i__4737__auto___55664 = (0);
while(true){
if((i__4737__auto___55664 < len__4736__auto___55663)){
args__4742__auto__.push((arguments[i__4737__auto___55664]));

var G__55665 = (i__4737__auto___55664 + (1));
i__4737__auto___55664 = G__55665;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55641){
var state_val_55642 = (state_55641[(1)]);
if((state_val_55642 === (7))){
var inst_55610 = (state_55641[(7)]);
var inst_55617 = cljs.core.first(inst_55610);
var state_55641__$1 = state_55641;
var statearr_55643_55666 = state_55641__$1;
(statearr_55643_55666[(2)] = inst_55617);

(statearr_55643_55666[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (1))){
var state_55641__$1 = state_55641;
var statearr_55644_55667 = state_55641__$1;
(statearr_55644_55667[(2)] = null);

(statearr_55644_55667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (4))){
var inst_55601 = (state_55641[(2)]);
var state_55641__$1 = state_55641;
var statearr_55645_55668 = state_55641__$1;
(statearr_55645_55668[(2)] = inst_55601);

(statearr_55645_55668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (6))){
var inst_55610 = (state_55641[(7)]);
var inst_55609 = (state_55641[(2)]);
var inst_55610__$1 = fluree.db.util.async.throw_err(inst_55609);
var inst_55611 = cljs.core.count(inst_55610__$1);
var inst_55612 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55611);
var inst_55613 = cljs.core.first(inst_55610__$1);
var inst_55614 = cljs.core.coll_QMARK_(inst_55613);
var inst_55615 = ((inst_55612) && (inst_55614));
var state_55641__$1 = (function (){var statearr_55646 = state_55641;
(statearr_55646[(7)] = inst_55610__$1);

return statearr_55646;
})();
if(cljs.core.truth_(inst_55615)){
var statearr_55647_55669 = state_55641__$1;
(statearr_55647_55669[(1)] = (7));

} else {
var statearr_55648_55670 = state_55641__$1;
(statearr_55648_55670[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (3))){
var inst_55639 = (state_55641[(2)]);
var state_55641__$1 = state_55641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55641__$1,inst_55639);
} else {
if((state_val_55642 === (2))){
var _ = (function (){var statearr_55650 = state_55641;
(statearr_55650[(4)] = cljs.core.cons((5),(state_55641[(4)])));

return statearr_55650;
})();
var inst_55607 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55641__$1 = state_55641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55641__$1,(6),inst_55607);
} else {
if((state_val_55642 === (9))){
var inst_55620 = (state_55641[(2)]);
var inst_55621 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55620);
var inst_55622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55623 = [inst_55620];
var inst_55624 = (new cljs.core.PersistentVector(null,1,(5),inst_55622,inst_55623,null));
var inst_55625 = cljs.core.count(inst_55624);
var inst_55626 = ((9) + inst_55625);
var inst_55627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55628 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55630 = [inst_55620];
var inst_55631 = (new cljs.core.PersistentVector(null,1,(5),inst_55629,inst_55630,null));
var inst_55632 = ["hash-set",inst_55631,inst_55621];
var inst_55633 = cljs.core.PersistentHashMap.fromArrays(inst_55628,inst_55632);
var inst_55634 = [inst_55633,inst_55626];
var inst_55635 = (new cljs.core.PersistentVector(null,2,(5),inst_55627,inst_55634,null));
var inst_55636 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55635);
var _ = (function (){var statearr_55651 = state_55641;
(statearr_55651[(4)] = cljs.core.rest((state_55641[(4)])));

return statearr_55651;
})();
var state_55641__$1 = (function (){var statearr_55652 = state_55641;
(statearr_55652[(8)] = inst_55636);

return statearr_55652;
})();
var statearr_55653_55671 = state_55641__$1;
(statearr_55653_55671[(2)] = inst_55621);

(statearr_55653_55671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (5))){
var _ = (function (){var statearr_55654 = state_55641;
(statearr_55654[(4)] = cljs.core.rest((state_55641[(4)])));

return statearr_55654;
})();
var state_55641__$1 = state_55641;
var ex55649 = (state_55641__$1[(2)]);
var statearr_55655_55672 = state_55641__$1;
(statearr_55655_55672[(5)] = ex55649);


if((ex55649 instanceof Error)){
var statearr_55656_55673 = state_55641__$1;
(statearr_55656_55673[(1)] = (4));

(statearr_55656_55673[(5)] = null);

} else {
throw ex55649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (8))){
var inst_55610 = (state_55641[(7)]);
var state_55641__$1 = state_55641;
var statearr_55657_55674 = state_55641__$1;
(statearr_55657_55674[(2)] = inst_55610);

(statearr_55657_55674[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55658 = [null,null,null,null,null,null,null,null,null];
(statearr_55658[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55658[(1)] = (1));

return statearr_55658;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55641){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55641);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55659){var ex__2417__auto__ = e55659;
var statearr_55660_55675 = state_55641;
(statearr_55660_55675[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55641[(4)]))){
var statearr_55661_55676 = state_55641;
(statearr_55661_55676[(1)] = cljs.core.first((state_55641[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55677 = state_55641;
state_55641 = G__55677;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55641){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55662 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55662[(6)] = c__2436__auto__);

return statearr_55662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55599){
var G__55600 = cljs.core.first(seq55599);
var seq55599__$1 = cljs.core.next(seq55599);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55600,seq55599__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55727 = arguments.length;
var i__4737__auto___55728 = (0);
while(true){
if((i__4737__auto___55728 < len__4736__auto___55727)){
args__4742__auto__.push((arguments[i__4737__auto___55728]));

var G__55729 = (i__4737__auto___55728 + (1));
i__4737__auto___55728 = G__55729;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55710){
var state_val_55711 = (state_55710[(1)]);
if((state_val_55711 === (1))){
var state_55710__$1 = state_55710;
var statearr_55712_55730 = state_55710__$1;
(statearr_55712_55730[(2)] = null);

(statearr_55712_55730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55711 === (2))){
var _ = (function (){var statearr_55713 = state_55710;
(statearr_55713[(4)] = cljs.core.cons((5),(state_55710[(4)])));

return statearr_55713;
})();
var inst_55686 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55710__$1 = state_55710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55710__$1,(6),inst_55686);
} else {
if((state_val_55711 === (3))){
var inst_55708 = (state_55710[(2)]);
var state_55710__$1 = state_55710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55710__$1,inst_55708);
} else {
if((state_val_55711 === (4))){
var inst_55680 = (state_55710[(2)]);
var state_55710__$1 = state_55710;
var statearr_55715_55731 = state_55710__$1;
(statearr_55715_55731[(2)] = inst_55680);

(statearr_55715_55731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55711 === (5))){
var _ = (function (){var statearr_55716 = state_55710;
(statearr_55716[(4)] = cljs.core.rest((state_55710[(4)])));

return statearr_55716;
})();
var state_55710__$1 = state_55710;
var ex55714 = (state_55710__$1[(2)]);
var statearr_55717_55732 = state_55710__$1;
(statearr_55717_55732[(5)] = ex55714);


if((ex55714 instanceof Error)){
var statearr_55718_55733 = state_55710__$1;
(statearr_55718_55733[(1)] = (4));

(statearr_55718_55733[(5)] = null);

} else {
throw ex55714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55711 === (6))){
var inst_55688 = (state_55710[(2)]);
var inst_55689 = fluree.db.util.async.throw_err(inst_55688);
var inst_55690 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55689);
var inst_55691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55692 = [inst_55689];
var inst_55693 = (new cljs.core.PersistentVector(null,1,(5),inst_55691,inst_55692,null));
var inst_55694 = cljs.core.count(inst_55693);
var inst_55695 = ((9) + inst_55694);
var inst_55696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55697 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55699 = [inst_55689];
var inst_55700 = (new cljs.core.PersistentVector(null,1,(5),inst_55698,inst_55699,null));
var inst_55701 = ["==",inst_55700,inst_55690];
var inst_55702 = cljs.core.PersistentHashMap.fromArrays(inst_55697,inst_55701);
var inst_55703 = [inst_55702,inst_55695];
var inst_55704 = (new cljs.core.PersistentVector(null,2,(5),inst_55696,inst_55703,null));
var inst_55705 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55704);
var _ = (function (){var statearr_55719 = state_55710;
(statearr_55719[(4)] = cljs.core.rest((state_55710[(4)])));

return statearr_55719;
})();
var state_55710__$1 = (function (){var statearr_55720 = state_55710;
(statearr_55720[(7)] = inst_55705);

return statearr_55720;
})();
var statearr_55721_55734 = state_55710__$1;
(statearr_55721_55734[(2)] = inst_55690);

(statearr_55721_55734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55722 = [null,null,null,null,null,null,null,null];
(statearr_55722[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55722[(1)] = (1));

return statearr_55722;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55710){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55710);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55723){var ex__2417__auto__ = e55723;
var statearr_55724_55735 = state_55710;
(statearr_55724_55735[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55710[(4)]))){
var statearr_55725_55736 = state_55710;
(statearr_55725_55736[(1)] = cljs.core.first((state_55710[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55737 = state_55710;
state_55710 = G__55737;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55726 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55726[(6)] = c__2436__auto__);

return statearr_55726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55678){
var G__55679 = cljs.core.first(seq55678);
var seq55678__$1 = cljs.core.next(seq55678);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55679,seq55678__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55787 = arguments.length;
var i__4737__auto___55788 = (0);
while(true){
if((i__4737__auto___55788 < len__4736__auto___55787)){
args__4742__auto__.push((arguments[i__4737__auto___55788]));

var G__55789 = (i__4737__auto___55788 + (1));
i__4737__auto___55788 = G__55789;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55770){
var state_val_55771 = (state_55770[(1)]);
if((state_val_55771 === (1))){
var state_55770__$1 = state_55770;
var statearr_55772_55790 = state_55770__$1;
(statearr_55772_55790[(2)] = null);

(statearr_55772_55790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55771 === (2))){
var _ = (function (){var statearr_55773 = state_55770;
(statearr_55773[(4)] = cljs.core.cons((5),(state_55770[(4)])));

return statearr_55773;
})();
var inst_55746 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55770__$1 = state_55770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55770__$1,(6),inst_55746);
} else {
if((state_val_55771 === (3))){
var inst_55768 = (state_55770[(2)]);
var state_55770__$1 = state_55770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55770__$1,inst_55768);
} else {
if((state_val_55771 === (4))){
var inst_55740 = (state_55770[(2)]);
var state_55770__$1 = state_55770;
var statearr_55775_55791 = state_55770__$1;
(statearr_55775_55791[(2)] = inst_55740);

(statearr_55775_55791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55771 === (5))){
var _ = (function (){var statearr_55776 = state_55770;
(statearr_55776[(4)] = cljs.core.rest((state_55770[(4)])));

return statearr_55776;
})();
var state_55770__$1 = state_55770;
var ex55774 = (state_55770__$1[(2)]);
var statearr_55777_55792 = state_55770__$1;
(statearr_55777_55792[(5)] = ex55774);


if((ex55774 instanceof Error)){
var statearr_55778_55793 = state_55770__$1;
(statearr_55778_55793[(1)] = (4));

(statearr_55778_55793[(5)] = null);

} else {
throw ex55774;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55771 === (6))){
var inst_55748 = (state_55770[(2)]);
var inst_55749 = fluree.db.util.async.throw_err(inst_55748);
var inst_55750 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55749);
var inst_55751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55752 = [inst_55749];
var inst_55753 = (new cljs.core.PersistentVector(null,1,(5),inst_55751,inst_55752,null));
var inst_55754 = cljs.core.count(inst_55753);
var inst_55755 = ((9) + inst_55754);
var inst_55756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55757 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55759 = [inst_55749];
var inst_55760 = (new cljs.core.PersistentVector(null,1,(5),inst_55758,inst_55759,null));
var inst_55761 = [">",inst_55760,inst_55750];
var inst_55762 = cljs.core.PersistentHashMap.fromArrays(inst_55757,inst_55761);
var inst_55763 = [inst_55762,inst_55755];
var inst_55764 = (new cljs.core.PersistentVector(null,2,(5),inst_55756,inst_55763,null));
var inst_55765 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55764);
var _ = (function (){var statearr_55779 = state_55770;
(statearr_55779[(4)] = cljs.core.rest((state_55770[(4)])));

return statearr_55779;
})();
var state_55770__$1 = (function (){var statearr_55780 = state_55770;
(statearr_55780[(7)] = inst_55765);

return statearr_55780;
})();
var statearr_55781_55794 = state_55770__$1;
(statearr_55781_55794[(2)] = inst_55750);

(statearr_55781_55794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55782 = [null,null,null,null,null,null,null,null];
(statearr_55782[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55782[(1)] = (1));

return statearr_55782;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55770){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55770);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55783){var ex__2417__auto__ = e55783;
var statearr_55784_55795 = state_55770;
(statearr_55784_55795[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55770[(4)]))){
var statearr_55785_55796 = state_55770;
(statearr_55785_55796[(1)] = cljs.core.first((state_55770[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55797 = state_55770;
state_55770 = G__55797;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55770){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55786 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55786[(6)] = c__2436__auto__);

return statearr_55786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55738){
var G__55739 = cljs.core.first(seq55738);
var seq55738__$1 = cljs.core.next(seq55738);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55739,seq55738__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55847 = arguments.length;
var i__4737__auto___55848 = (0);
while(true){
if((i__4737__auto___55848 < len__4736__auto___55847)){
args__4742__auto__.push((arguments[i__4737__auto___55848]));

var G__55849 = (i__4737__auto___55848 + (1));
i__4737__auto___55848 = G__55849;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55830){
var state_val_55831 = (state_55830[(1)]);
if((state_val_55831 === (1))){
var state_55830__$1 = state_55830;
var statearr_55832_55850 = state_55830__$1;
(statearr_55832_55850[(2)] = null);

(statearr_55832_55850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55831 === (2))){
var _ = (function (){var statearr_55833 = state_55830;
(statearr_55833[(4)] = cljs.core.cons((5),(state_55830[(4)])));

return statearr_55833;
})();
var inst_55806 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55830__$1 = state_55830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55830__$1,(6),inst_55806);
} else {
if((state_val_55831 === (3))){
var inst_55828 = (state_55830[(2)]);
var state_55830__$1 = state_55830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55830__$1,inst_55828);
} else {
if((state_val_55831 === (4))){
var inst_55800 = (state_55830[(2)]);
var state_55830__$1 = state_55830;
var statearr_55835_55851 = state_55830__$1;
(statearr_55835_55851[(2)] = inst_55800);

(statearr_55835_55851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55831 === (5))){
var _ = (function (){var statearr_55836 = state_55830;
(statearr_55836[(4)] = cljs.core.rest((state_55830[(4)])));

return statearr_55836;
})();
var state_55830__$1 = state_55830;
var ex55834 = (state_55830__$1[(2)]);
var statearr_55837_55852 = state_55830__$1;
(statearr_55837_55852[(5)] = ex55834);


if((ex55834 instanceof Error)){
var statearr_55838_55853 = state_55830__$1;
(statearr_55838_55853[(1)] = (4));

(statearr_55838_55853[(5)] = null);

} else {
throw ex55834;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55831 === (6))){
var inst_55808 = (state_55830[(2)]);
var inst_55809 = fluree.db.util.async.throw_err(inst_55808);
var inst_55810 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55809);
var inst_55811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55812 = [inst_55809];
var inst_55813 = (new cljs.core.PersistentVector(null,1,(5),inst_55811,inst_55812,null));
var inst_55814 = cljs.core.count(inst_55813);
var inst_55815 = ((9) + inst_55814);
var inst_55816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55817 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55819 = [inst_55809];
var inst_55820 = (new cljs.core.PersistentVector(null,1,(5),inst_55818,inst_55819,null));
var inst_55821 = ["<",inst_55820,inst_55810];
var inst_55822 = cljs.core.PersistentHashMap.fromArrays(inst_55817,inst_55821);
var inst_55823 = [inst_55822,inst_55815];
var inst_55824 = (new cljs.core.PersistentVector(null,2,(5),inst_55816,inst_55823,null));
var inst_55825 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55824);
var _ = (function (){var statearr_55839 = state_55830;
(statearr_55839[(4)] = cljs.core.rest((state_55830[(4)])));

return statearr_55839;
})();
var state_55830__$1 = (function (){var statearr_55840 = state_55830;
(statearr_55840[(7)] = inst_55825);

return statearr_55840;
})();
var statearr_55841_55854 = state_55830__$1;
(statearr_55841_55854[(2)] = inst_55810);

(statearr_55841_55854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55842 = [null,null,null,null,null,null,null,null];
(statearr_55842[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55842[(1)] = (1));

return statearr_55842;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55830){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55830);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55843){var ex__2417__auto__ = e55843;
var statearr_55844_55855 = state_55830;
(statearr_55844_55855[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55830[(4)]))){
var statearr_55845_55856 = state_55830;
(statearr_55845_55856[(1)] = cljs.core.first((state_55830[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55857 = state_55830;
state_55830 = G__55857;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55846 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55846[(6)] = c__2436__auto__);

return statearr_55846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55798){
var G__55799 = cljs.core.first(seq55798);
var seq55798__$1 = cljs.core.next(seq55798);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55799,seq55798__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55907 = arguments.length;
var i__4737__auto___55908 = (0);
while(true){
if((i__4737__auto___55908 < len__4736__auto___55907)){
args__4742__auto__.push((arguments[i__4737__auto___55908]));

var G__55909 = (i__4737__auto___55908 + (1));
i__4737__auto___55908 = G__55909;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55890){
var state_val_55891 = (state_55890[(1)]);
if((state_val_55891 === (1))){
var state_55890__$1 = state_55890;
var statearr_55892_55910 = state_55890__$1;
(statearr_55892_55910[(2)] = null);

(statearr_55892_55910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (2))){
var _ = (function (){var statearr_55893 = state_55890;
(statearr_55893[(4)] = cljs.core.cons((5),(state_55890[(4)])));

return statearr_55893;
})();
var inst_55866 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55890__$1,(6),inst_55866);
} else {
if((state_val_55891 === (3))){
var inst_55888 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55890__$1,inst_55888);
} else {
if((state_val_55891 === (4))){
var inst_55860 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55895_55911 = state_55890__$1;
(statearr_55895_55911[(2)] = inst_55860);

(statearr_55895_55911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (5))){
var _ = (function (){var statearr_55896 = state_55890;
(statearr_55896[(4)] = cljs.core.rest((state_55890[(4)])));

return statearr_55896;
})();
var state_55890__$1 = state_55890;
var ex55894 = (state_55890__$1[(2)]);
var statearr_55897_55912 = state_55890__$1;
(statearr_55897_55912[(5)] = ex55894);


if((ex55894 instanceof Error)){
var statearr_55898_55913 = state_55890__$1;
(statearr_55898_55913[(1)] = (4));

(statearr_55898_55913[(5)] = null);

} else {
throw ex55894;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (6))){
var inst_55868 = (state_55890[(2)]);
var inst_55869 = fluree.db.util.async.throw_err(inst_55868);
var inst_55870 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55869);
var inst_55871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55872 = [inst_55869];
var inst_55873 = (new cljs.core.PersistentVector(null,1,(5),inst_55871,inst_55872,null));
var inst_55874 = cljs.core.count(inst_55873);
var inst_55875 = ((9) + inst_55874);
var inst_55876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55877 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55879 = [inst_55869];
var inst_55880 = (new cljs.core.PersistentVector(null,1,(5),inst_55878,inst_55879,null));
var inst_55881 = ["<=",inst_55880,inst_55870];
var inst_55882 = cljs.core.PersistentHashMap.fromArrays(inst_55877,inst_55881);
var inst_55883 = [inst_55882,inst_55875];
var inst_55884 = (new cljs.core.PersistentVector(null,2,(5),inst_55876,inst_55883,null));
var inst_55885 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55884);
var _ = (function (){var statearr_55899 = state_55890;
(statearr_55899[(4)] = cljs.core.rest((state_55890[(4)])));

return statearr_55899;
})();
var state_55890__$1 = (function (){var statearr_55900 = state_55890;
(statearr_55900[(7)] = inst_55885);

return statearr_55900;
})();
var statearr_55901_55914 = state_55890__$1;
(statearr_55901_55914[(2)] = inst_55870);

(statearr_55901_55914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55902 = [null,null,null,null,null,null,null,null];
(statearr_55902[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55902[(1)] = (1));

return statearr_55902;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55890){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55890);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55903){var ex__2417__auto__ = e55903;
var statearr_55904_55915 = state_55890;
(statearr_55904_55915[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55890[(4)]))){
var statearr_55905_55916 = state_55890;
(statearr_55905_55916[(1)] = cljs.core.first((state_55890[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55917 = state_55890;
state_55890 = G__55917;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55890){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55906 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55906[(6)] = c__2436__auto__);

return statearr_55906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55858){
var G__55859 = cljs.core.first(seq55858);
var seq55858__$1 = cljs.core.next(seq55858);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55859,seq55858__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55967 = arguments.length;
var i__4737__auto___55968 = (0);
while(true){
if((i__4737__auto___55968 < len__4736__auto___55967)){
args__4742__auto__.push((arguments[i__4737__auto___55968]));

var G__55969 = (i__4737__auto___55968 + (1));
i__4737__auto___55968 = G__55969;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55950){
var state_val_55951 = (state_55950[(1)]);
if((state_val_55951 === (1))){
var state_55950__$1 = state_55950;
var statearr_55952_55970 = state_55950__$1;
(statearr_55952_55970[(2)] = null);

(statearr_55952_55970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55951 === (2))){
var _ = (function (){var statearr_55953 = state_55950;
(statearr_55953[(4)] = cljs.core.cons((5),(state_55950[(4)])));

return statearr_55953;
})();
var inst_55926 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55950__$1 = state_55950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55950__$1,(6),inst_55926);
} else {
if((state_val_55951 === (3))){
var inst_55948 = (state_55950[(2)]);
var state_55950__$1 = state_55950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55950__$1,inst_55948);
} else {
if((state_val_55951 === (4))){
var inst_55920 = (state_55950[(2)]);
var state_55950__$1 = state_55950;
var statearr_55955_55971 = state_55950__$1;
(statearr_55955_55971[(2)] = inst_55920);

(statearr_55955_55971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55951 === (5))){
var _ = (function (){var statearr_55956 = state_55950;
(statearr_55956[(4)] = cljs.core.rest((state_55950[(4)])));

return statearr_55956;
})();
var state_55950__$1 = state_55950;
var ex55954 = (state_55950__$1[(2)]);
var statearr_55957_55972 = state_55950__$1;
(statearr_55957_55972[(5)] = ex55954);


if((ex55954 instanceof Error)){
var statearr_55958_55973 = state_55950__$1;
(statearr_55958_55973[(1)] = (4));

(statearr_55958_55973[(5)] = null);

} else {
throw ex55954;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55951 === (6))){
var inst_55928 = (state_55950[(2)]);
var inst_55929 = fluree.db.util.async.throw_err(inst_55928);
var inst_55930 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55929);
var inst_55931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55932 = [inst_55929];
var inst_55933 = (new cljs.core.PersistentVector(null,1,(5),inst_55931,inst_55932,null));
var inst_55934 = cljs.core.count(inst_55933);
var inst_55935 = ((9) + inst_55934);
var inst_55936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55937 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55939 = [inst_55929];
var inst_55940 = (new cljs.core.PersistentVector(null,1,(5),inst_55938,inst_55939,null));
var inst_55941 = [">=",inst_55940,inst_55930];
var inst_55942 = cljs.core.PersistentHashMap.fromArrays(inst_55937,inst_55941);
var inst_55943 = [inst_55942,inst_55935];
var inst_55944 = (new cljs.core.PersistentVector(null,2,(5),inst_55936,inst_55943,null));
var inst_55945 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55944);
var _ = (function (){var statearr_55959 = state_55950;
(statearr_55959[(4)] = cljs.core.rest((state_55950[(4)])));

return statearr_55959;
})();
var state_55950__$1 = (function (){var statearr_55960 = state_55950;
(statearr_55960[(7)] = inst_55945);

return statearr_55960;
})();
var statearr_55961_55974 = state_55950__$1;
(statearr_55961_55974[(2)] = inst_55930);

(statearr_55961_55974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55962 = [null,null,null,null,null,null,null,null];
(statearr_55962[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55962[(1)] = (1));

return statearr_55962;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55950){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55950);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55963){var ex__2417__auto__ = e55963;
var statearr_55964_55975 = state_55950;
(statearr_55964_55975[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55950[(4)]))){
var statearr_55965_55976 = state_55950;
(statearr_55965_55976[(1)] = cljs.core.first((state_55950[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55977 = state_55950;
state_55950 = G__55977;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55966 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55966[(6)] = c__2436__auto__);

return statearr_55966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55918){
var G__55919 = cljs.core.first(seq55918);
var seq55918__$1 = cljs.core.next(seq55918);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55919,seq55918__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56027 = arguments.length;
var i__4737__auto___56028 = (0);
while(true){
if((i__4737__auto___56028 < len__4736__auto___56027)){
args__4742__auto__.push((arguments[i__4737__auto___56028]));

var G__56029 = (i__4737__auto___56028 + (1));
i__4737__auto___56028 = G__56029;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56010){
var state_val_56011 = (state_56010[(1)]);
if((state_val_56011 === (1))){
var state_56010__$1 = state_56010;
var statearr_56012_56030 = state_56010__$1;
(statearr_56012_56030[(2)] = null);

(statearr_56012_56030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56011 === (2))){
var _ = (function (){var statearr_56013 = state_56010;
(statearr_56013[(4)] = cljs.core.cons((5),(state_56010[(4)])));

return statearr_56013;
})();
var inst_55986 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56010__$1 = state_56010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56010__$1,(6),inst_55986);
} else {
if((state_val_56011 === (3))){
var inst_56008 = (state_56010[(2)]);
var state_56010__$1 = state_56010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56010__$1,inst_56008);
} else {
if((state_val_56011 === (4))){
var inst_55980 = (state_56010[(2)]);
var state_56010__$1 = state_56010;
var statearr_56015_56031 = state_56010__$1;
(statearr_56015_56031[(2)] = inst_55980);

(statearr_56015_56031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56011 === (5))){
var _ = (function (){var statearr_56016 = state_56010;
(statearr_56016[(4)] = cljs.core.rest((state_56010[(4)])));

return statearr_56016;
})();
var state_56010__$1 = state_56010;
var ex56014 = (state_56010__$1[(2)]);
var statearr_56017_56032 = state_56010__$1;
(statearr_56017_56032[(5)] = ex56014);


if((ex56014 instanceof Error)){
var statearr_56018_56033 = state_56010__$1;
(statearr_56018_56033[(1)] = (4));

(statearr_56018_56033[(5)] = null);

} else {
throw ex56014;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56011 === (6))){
var inst_55988 = (state_56010[(2)]);
var inst_55989 = fluree.db.util.async.throw_err(inst_55988);
var inst_55990 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55989);
var inst_55991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55992 = [inst_55989];
var inst_55993 = (new cljs.core.PersistentVector(null,1,(5),inst_55991,inst_55992,null));
var inst_55994 = cljs.core.count(inst_55993);
var inst_55995 = ((9) + inst_55994);
var inst_55996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55997 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55999 = [inst_55989];
var inst_56000 = (new cljs.core.PersistentVector(null,1,(5),inst_55998,inst_55999,null));
var inst_56001 = ["max",inst_56000,inst_55990];
var inst_56002 = cljs.core.PersistentHashMap.fromArrays(inst_55997,inst_56001);
var inst_56003 = [inst_56002,inst_55995];
var inst_56004 = (new cljs.core.PersistentVector(null,2,(5),inst_55996,inst_56003,null));
var inst_56005 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56004);
var _ = (function (){var statearr_56019 = state_56010;
(statearr_56019[(4)] = cljs.core.rest((state_56010[(4)])));

return statearr_56019;
})();
var state_56010__$1 = (function (){var statearr_56020 = state_56010;
(statearr_56020[(7)] = inst_56005);

return statearr_56020;
})();
var statearr_56021_56034 = state_56010__$1;
(statearr_56021_56034[(2)] = inst_55990);

(statearr_56021_56034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56022 = [null,null,null,null,null,null,null,null];
(statearr_56022[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56022[(1)] = (1));

return statearr_56022;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56010){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56010);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56023){var ex__2417__auto__ = e56023;
var statearr_56024_56035 = state_56010;
(statearr_56024_56035[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56010[(4)]))){
var statearr_56025_56036 = state_56010;
(statearr_56025_56036[(1)] = cljs.core.first((state_56010[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56037 = state_56010;
state_56010 = G__56037;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56010){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56026 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56026[(6)] = c__2436__auto__);

return statearr_56026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55978){
var G__55979 = cljs.core.first(seq55978);
var seq55978__$1 = cljs.core.next(seq55978);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55979,seq55978__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56086 = arguments.length;
var i__4737__auto___56087 = (0);
while(true){
if((i__4737__auto___56087 < len__4736__auto___56086)){
args__4742__auto__.push((arguments[i__4737__auto___56087]));

var G__56088 = (i__4737__auto___56087 + (1));
i__4737__auto___56087 = G__56088;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56069){
var state_val_56070 = (state_56069[(1)]);
if((state_val_56070 === (1))){
var state_56069__$1 = state_56069;
var statearr_56071_56089 = state_56069__$1;
(statearr_56071_56089[(2)] = null);

(statearr_56071_56089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56070 === (2))){
var _ = (function (){var statearr_56072 = state_56069;
(statearr_56072[(4)] = cljs.core.cons((5),(state_56069[(4)])));

return statearr_56072;
})();
var inst_56046 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56069__$1 = state_56069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56069__$1,(6),inst_56046);
} else {
if((state_val_56070 === (3))){
var inst_56067 = (state_56069[(2)]);
var state_56069__$1 = state_56069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56069__$1,inst_56067);
} else {
if((state_val_56070 === (4))){
var inst_56040 = (state_56069[(2)]);
var state_56069__$1 = state_56069;
var statearr_56074_56090 = state_56069__$1;
(statearr_56074_56090[(2)] = inst_56040);

(statearr_56074_56090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56070 === (5))){
var _ = (function (){var statearr_56075 = state_56069;
(statearr_56075[(4)] = cljs.core.rest((state_56069[(4)])));

return statearr_56075;
})();
var state_56069__$1 = state_56069;
var ex56073 = (state_56069__$1[(2)]);
var statearr_56076_56091 = state_56069__$1;
(statearr_56076_56091[(5)] = ex56073);


if((ex56073 instanceof Error)){
var statearr_56077_56092 = state_56069__$1;
(statearr_56077_56092[(1)] = (4));

(statearr_56077_56092[(5)] = null);

} else {
throw ex56073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56070 === (6))){
var inst_56048 = (state_56069[(2)]);
var inst_56049 = fluree.db.util.async.throw_err(inst_56048);
var inst_56050 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56049);
var inst_56051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56052 = [inst_56049];
var inst_56053 = (new cljs.core.PersistentVector(null,1,(5),inst_56051,inst_56052,null));
var inst_56054 = cljs.core.count(inst_56053);
var inst_56055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56056 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56058 = [inst_56049];
var inst_56059 = (new cljs.core.PersistentVector(null,1,(5),inst_56057,inst_56058,null));
var inst_56060 = ["min",inst_56059,inst_56050];
var inst_56061 = cljs.core.PersistentHashMap.fromArrays(inst_56056,inst_56060);
var inst_56062 = [inst_56061,inst_56054];
var inst_56063 = (new cljs.core.PersistentVector(null,2,(5),inst_56055,inst_56062,null));
var inst_56064 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56063);
var _ = (function (){var statearr_56078 = state_56069;
(statearr_56078[(4)] = cljs.core.rest((state_56069[(4)])));

return statearr_56078;
})();
var state_56069__$1 = (function (){var statearr_56079 = state_56069;
(statearr_56079[(7)] = inst_56064);

return statearr_56079;
})();
var statearr_56080_56093 = state_56069__$1;
(statearr_56080_56093[(2)] = inst_56050);

(statearr_56080_56093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56081 = [null,null,null,null,null,null,null,null];
(statearr_56081[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56081[(1)] = (1));

return statearr_56081;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56069){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56069);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56082){var ex__2417__auto__ = e56082;
var statearr_56083_56094 = state_56069;
(statearr_56083_56094[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56069[(4)]))){
var statearr_56084_56095 = state_56069;
(statearr_56084_56095[(1)] = cljs.core.first((state_56069[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56096 = state_56069;
state_56069 = G__56096;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56069){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56085 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56085[(6)] = c__2436__auto__);

return statearr_56085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56038){
var G__56039 = cljs.core.first(seq56038);
var seq56038__$1 = cljs.core.next(seq56038);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56039,seq56038__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56098 = arguments.length;
switch (G__56098) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56143){
var state_val_56144 = (state_56143[(1)]);
if((state_val_56144 === (7))){
var state_56143__$1 = state_56143;
var statearr_56145_56282 = state_56143__$1;
(statearr_56145_56282[(2)] = query_map);

(statearr_56145_56282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (1))){
var state_56143__$1 = state_56143;
var statearr_56146_56283 = state_56143__$1;
(statearr_56146_56283[(2)] = null);

(statearr_56146_56283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (4))){
var inst_56099 = (state_56143[(2)]);
var state_56143__$1 = state_56143;
var statearr_56147_56284 = state_56143__$1;
(statearr_56147_56284[(2)] = inst_56099);

(statearr_56147_56284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (13))){
var inst_56121 = (state_56143[(7)]);
var inst_56125 = (state_56143[(2)]);
var inst_56126 = fluree.db.util.async.throw_err(inst_56125);
var inst_56127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56126,(0),null);
var inst_56128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56126,(1),null);
var inst_56129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56130 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56132 = [inst_56121];
var inst_56133 = (new cljs.core.PersistentVector(null,1,(5),inst_56131,inst_56132,null));
var inst_56134 = ["query",inst_56133,inst_56127];
var inst_56135 = cljs.core.PersistentHashMap.fromArrays(inst_56130,inst_56134);
var inst_56136 = [inst_56135,inst_56128];
var inst_56137 = (new cljs.core.PersistentVector(null,2,(5),inst_56129,inst_56136,null));
var inst_56138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56137);
var _ = (function (){var statearr_56148 = state_56143;
(statearr_56148[(4)] = cljs.core.rest((state_56143[(4)])));

return statearr_56148;
})();
var state_56143__$1 = (function (){var statearr_56149 = state_56143;
(statearr_56149[(8)] = inst_56138);

return statearr_56149;
})();
var statearr_56150_56285 = state_56143__$1;
(statearr_56150_56285[(2)] = inst_56127);

(statearr_56150_56285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (6))){
var state_56143__$1 = state_56143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56143__$1,(9),query_map);
} else {
if((state_val_56144 === (3))){
var inst_56141 = (state_56143[(2)]);
var state_56143__$1 = state_56143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56143__$1,inst_56141);
} else {
if((state_val_56144 === (12))){
var inst_56121 = (state_56143[(7)]);
var inst_56121__$1 = (state_56143[(2)]);
var inst_56122 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56123 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56122,inst_56121__$1);
var state_56143__$1 = (function (){var statearr_56151 = state_56143;
(statearr_56151[(7)] = inst_56121__$1);

return statearr_56151;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56143__$1,(13),inst_56123);
} else {
if((state_val_56144 === (2))){
var _ = (function (){var statearr_56152 = state_56143;
(statearr_56152[(4)] = cljs.core.cons((5),(state_56143[(4)])));

return statearr_56152;
})();
var inst_56108 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56143__$1 = state_56143;
if(inst_56108){
var statearr_56153_56286 = state_56143__$1;
(statearr_56153_56286[(1)] = (6));

} else {
var statearr_56154_56287 = state_56143__$1;
(statearr_56154_56287[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (11))){
var inst_56115 = (state_56143[(9)]);
var state_56143__$1 = state_56143;
var statearr_56156_56288 = state_56143__$1;
(statearr_56156_56288[(2)] = inst_56115);

(statearr_56156_56288[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (9))){
var inst_56111 = (state_56143[(2)]);
var inst_56112 = fluree.db.util.async.throw_err(inst_56111);
var state_56143__$1 = state_56143;
var statearr_56157_56289 = state_56143__$1;
(statearr_56157_56289[(2)] = inst_56112);

(statearr_56157_56289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (5))){
var _ = (function (){var statearr_56158 = state_56143;
(statearr_56158[(4)] = cljs.core.rest((state_56143[(4)])));

return statearr_56158;
})();
var state_56143__$1 = state_56143;
var ex56155 = (state_56143__$1[(2)]);
var statearr_56159_56290 = state_56143__$1;
(statearr_56159_56290[(5)] = ex56155);


if((ex56155 instanceof Error)){
var statearr_56160_56291 = state_56143__$1;
(statearr_56160_56291[(1)] = (4));

(statearr_56160_56291[(5)] = null);

} else {
throw ex56155;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (10))){
var inst_56115 = (state_56143[(9)]);
var inst_56118 = fluree.db.util.json.parse(inst_56115);
var state_56143__$1 = state_56143;
var statearr_56161_56292 = state_56143__$1;
(statearr_56161_56292[(2)] = inst_56118);

(statearr_56161_56292[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56144 === (8))){
var inst_56115 = (state_56143[(9)]);
var inst_56115__$1 = (state_56143[(2)]);
var inst_56116 = typeof inst_56115__$1 === 'string';
var state_56143__$1 = (function (){var statearr_56162 = state_56143;
(statearr_56162[(9)] = inst_56115__$1);

return statearr_56162;
})();
if(cljs.core.truth_(inst_56116)){
var statearr_56163_56293 = state_56143__$1;
(statearr_56163_56293[(1)] = (10));

} else {
var statearr_56164_56294 = state_56143__$1;
(statearr_56164_56294[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56165 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56165[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56165[(1)] = (1));

return statearr_56165;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56143){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56143);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56166){var ex__2417__auto__ = e56166;
var statearr_56167_56295 = state_56143;
(statearr_56167_56295[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56143[(4)]))){
var statearr_56168_56296 = state_56143;
(statearr_56168_56296[(1)] = cljs.core.first((state_56143[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56297 = state_56143;
state_56143 = G__56297;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56143){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56169 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56169[(6)] = c__2436__auto__);

return statearr_56169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56240){
var state_val_56241 = (state_56240[(1)]);
if((state_val_56241 === (7))){
var state_56240__$1 = state_56240;
var statearr_56242_56298 = state_56240__$1;
(statearr_56242_56298[(2)] = select);

(statearr_56242_56298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (20))){
var inst_56210 = (state_56240[(2)]);
var inst_56211 = fluree.db.util.async.channel_QMARK_(limit);
var state_56240__$1 = (function (){var statearr_56243 = state_56240;
(statearr_56243[(7)] = inst_56210);

return statearr_56243;
})();
if(inst_56211){
var statearr_56244_56299 = state_56240__$1;
(statearr_56244_56299[(1)] = (22));

} else {
var statearr_56245_56300 = state_56240__$1;
(statearr_56245_56300[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (1))){
var state_56240__$1 = state_56240;
var statearr_56246_56301 = state_56240__$1;
(statearr_56246_56301[(2)] = null);

(statearr_56246_56301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (24))){
var inst_56186 = (state_56240[(8)]);
var inst_56202 = (state_56240[(9)]);
var inst_56210 = (state_56240[(7)]);
var inst_56194 = (state_56240[(10)]);
var inst_56218 = (state_56240[(2)]);
var inst_56219 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56220 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56219,inst_56186,inst_56194,inst_56202,inst_56210,inst_56218);
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(26),inst_56220);
} else {
if((state_val_56241 === (4))){
var inst_56170 = (state_56240[(2)]);
var state_56240__$1 = state_56240;
var statearr_56247_56302 = state_56240__$1;
(statearr_56247_56302[(2)] = inst_56170);

(statearr_56247_56302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (15))){
var state_56240__$1 = state_56240;
var statearr_56248_56303 = state_56240__$1;
(statearr_56248_56303[(2)] = where);

(statearr_56248_56303[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (21))){
var inst_56206 = (state_56240[(2)]);
var inst_56207 = fluree.db.util.async.throw_err(inst_56206);
var state_56240__$1 = state_56240;
var statearr_56249_56304 = state_56240__$1;
(statearr_56249_56304[(2)] = inst_56207);

(statearr_56249_56304[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (13))){
var inst_56190 = (state_56240[(2)]);
var inst_56191 = fluree.db.util.async.throw_err(inst_56190);
var state_56240__$1 = state_56240;
var statearr_56250_56305 = state_56240__$1;
(statearr_56250_56305[(2)] = inst_56191);

(statearr_56250_56305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (22))){
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(25),limit);
} else {
if((state_val_56241 === (6))){
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(9),select);
} else {
if((state_val_56241 === (25))){
var inst_56214 = (state_56240[(2)]);
var inst_56215 = fluree.db.util.async.throw_err(inst_56214);
var state_56240__$1 = state_56240;
var statearr_56251_56306 = state_56240__$1;
(statearr_56251_56306[(2)] = inst_56215);

(statearr_56251_56306[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (17))){
var inst_56198 = (state_56240[(2)]);
var inst_56199 = fluree.db.util.async.throw_err(inst_56198);
var state_56240__$1 = state_56240;
var statearr_56252_56307 = state_56240__$1;
(statearr_56252_56307[(2)] = inst_56199);

(statearr_56252_56307[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (3))){
var inst_56238 = (state_56240[(2)]);
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56240__$1,inst_56238);
} else {
if((state_val_56241 === (12))){
var inst_56194 = (state_56240[(2)]);
var inst_56195 = fluree.db.util.async.channel_QMARK_(where);
var state_56240__$1 = (function (){var statearr_56253 = state_56240;
(statearr_56253[(10)] = inst_56194);

return statearr_56253;
})();
if(inst_56195){
var statearr_56254_56308 = state_56240__$1;
(statearr_56254_56308[(1)] = (14));

} else {
var statearr_56255_56309 = state_56240__$1;
(statearr_56255_56309[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (2))){
var _ = (function (){var statearr_56256 = state_56240;
(statearr_56256[(4)] = cljs.core.cons((5),(state_56240[(4)])));

return statearr_56256;
})();
var inst_56179 = fluree.db.util.async.channel_QMARK_(select);
var state_56240__$1 = state_56240;
if(inst_56179){
var statearr_56257_56310 = state_56240__$1;
(statearr_56257_56310[(1)] = (6));

} else {
var statearr_56258_56311 = state_56240__$1;
(statearr_56258_56311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (23))){
var state_56240__$1 = state_56240;
var statearr_56259_56312 = state_56240__$1;
(statearr_56259_56312[(2)] = limit);

(statearr_56259_56312[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (19))){
var state_56240__$1 = state_56240;
var statearr_56260_56313 = state_56240__$1;
(statearr_56260_56313[(2)] = block);

(statearr_56260_56313[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (11))){
var state_56240__$1 = state_56240;
var statearr_56262_56314 = state_56240__$1;
(statearr_56262_56314[(2)] = from);

(statearr_56262_56314[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (9))){
var inst_56182 = (state_56240[(2)]);
var inst_56183 = fluree.db.util.async.throw_err(inst_56182);
var state_56240__$1 = state_56240;
var statearr_56263_56315 = state_56240__$1;
(statearr_56263_56315[(2)] = inst_56183);

(statearr_56263_56315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (5))){
var _ = (function (){var statearr_56264 = state_56240;
(statearr_56264[(4)] = cljs.core.rest((state_56240[(4)])));

return statearr_56264;
})();
var state_56240__$1 = state_56240;
var ex56261 = (state_56240__$1[(2)]);
var statearr_56265_56316 = state_56240__$1;
(statearr_56265_56316[(5)] = ex56261);


if((ex56261 instanceof Error)){
var statearr_56266_56317 = state_56240__$1;
(statearr_56266_56317[(1)] = (4));

(statearr_56266_56317[(5)] = null);

} else {
throw ex56261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (14))){
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(17),where);
} else {
if((state_val_56241 === (26))){
var inst_56186 = (state_56240[(8)]);
var inst_56202 = (state_56240[(9)]);
var inst_56210 = (state_56240[(7)]);
var inst_56194 = (state_56240[(10)]);
var inst_56222 = (state_56240[(2)]);
var inst_56223 = fluree.db.util.async.throw_err(inst_56222);
var inst_56224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56223,(0),null);
var inst_56225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56223,(1),null);
var inst_56226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56227 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56229 = [inst_56186,inst_56194,inst_56202,inst_56210];
var inst_56230 = (new cljs.core.PersistentVector(null,4,(5),inst_56228,inst_56229,null));
var inst_56231 = ["query",inst_56230,inst_56224];
var inst_56232 = cljs.core.PersistentHashMap.fromArrays(inst_56227,inst_56231);
var inst_56233 = [inst_56232,inst_56225];
var inst_56234 = (new cljs.core.PersistentVector(null,2,(5),inst_56226,inst_56233,null));
var inst_56235 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56234);
var _ = (function (){var statearr_56267 = state_56240;
(statearr_56267[(4)] = cljs.core.rest((state_56240[(4)])));

return statearr_56267;
})();
var state_56240__$1 = (function (){var statearr_56268 = state_56240;
(statearr_56268[(11)] = inst_56235);

return statearr_56268;
})();
var statearr_56269_56318 = state_56240__$1;
(statearr_56269_56318[(2)] = inst_56224);

(statearr_56269_56318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (16))){
var inst_56202 = (state_56240[(2)]);
var inst_56203 = fluree.db.util.async.channel_QMARK_(block);
var state_56240__$1 = (function (){var statearr_56270 = state_56240;
(statearr_56270[(9)] = inst_56202);

return statearr_56270;
})();
if(inst_56203){
var statearr_56271_56319 = state_56240__$1;
(statearr_56271_56319[(1)] = (18));

} else {
var statearr_56272_56320 = state_56240__$1;
(statearr_56272_56320[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56241 === (10))){
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(13),from);
} else {
if((state_val_56241 === (18))){
var state_56240__$1 = state_56240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56240__$1,(21),block);
} else {
if((state_val_56241 === (8))){
var inst_56186 = (state_56240[(2)]);
var inst_56187 = fluree.db.util.async.channel_QMARK_(from);
var state_56240__$1 = (function (){var statearr_56273 = state_56240;
(statearr_56273[(8)] = inst_56186);

return statearr_56273;
})();
if(inst_56187){
var statearr_56274_56321 = state_56240__$1;
(statearr_56274_56321[(1)] = (10));

} else {
var statearr_56275_56322 = state_56240__$1;
(statearr_56275_56322[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56276 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56276[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56276[(1)] = (1));

return statearr_56276;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56240){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56240);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56277){var ex__2417__auto__ = e56277;
var statearr_56278_56323 = state_56240;
(statearr_56278_56323[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56240[(4)]))){
var statearr_56279_56324 = state_56240;
(statearr_56279_56324[(1)] = cljs.core.first((state_56240[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56325 = state_56240;
state_56240 = G__56325;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56240){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56280 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56280[(6)] = c__2436__auto__);

return statearr_56280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56381){
var state_val_56382 = (state_56381[(1)]);
if((state_val_56382 === (7))){
var state_56381__$1 = state_56381;
var statearr_56383_56414 = state_56381__$1;
(statearr_56383_56414[(2)] = startSubject);

(statearr_56383_56414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (1))){
var state_56381__$1 = state_56381;
var statearr_56384_56415 = state_56381__$1;
(statearr_56384_56415[(2)] = null);

(statearr_56384_56415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (4))){
var inst_56326 = (state_56381[(2)]);
var state_56381__$1 = state_56381;
var statearr_56385_56416 = state_56381__$1;
(statearr_56385_56416[(2)] = inst_56326);

(statearr_56385_56416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (15))){
var inst_56358 = (state_56381[(2)]);
var inst_56359 = fluree.db.util.async.throw_err(inst_56358);
var inst_56360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56359,(0),null);
var inst_56361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56359,(1),null);
var inst_56362 = cljs.core.empty_QMARK_(inst_56360);
var state_56381__$1 = (function (){var statearr_56386 = state_56381;
(statearr_56386[(7)] = inst_56361);

return statearr_56386;
})();
if(inst_56362){
var statearr_56387_56417 = state_56381__$1;
(statearr_56387_56417[(1)] = (16));

} else {
var statearr_56388_56418 = state_56381__$1;
(statearr_56388_56418[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (13))){
var inst_56346 = (state_56381[(8)]);
var inst_56354 = (state_56381[(9)]);
var inst_56342 = (state_56381[(10)]);
var inst_56354__$1 = (state_56381[(2)]);
var inst_56355 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56356 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56355,inst_56342,inst_56346,inst_56354__$1);
var state_56381__$1 = (function (){var statearr_56389 = state_56381;
(statearr_56389[(9)] = inst_56354__$1);

return statearr_56389;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56381__$1,(15),inst_56356);
} else {
if((state_val_56382 === (6))){
var state_56381__$1 = state_56381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56381__$1,(9),startSubject);
} else {
if((state_val_56382 === (17))){
var state_56381__$1 = state_56381;
var statearr_56390_56419 = state_56381__$1;
(statearr_56390_56419[(2)] = true);

(statearr_56390_56419[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (3))){
var inst_56379 = (state_56381[(2)]);
var state_56381__$1 = state_56381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56381__$1,inst_56379);
} else {
if((state_val_56382 === (12))){
var state_56381__$1 = state_56381;
var statearr_56391_56420 = state_56381__$1;
(statearr_56391_56420[(2)] = endSubject);

(statearr_56391_56420[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (2))){
var _ = (function (){var statearr_56392 = state_56381;
(statearr_56392[(4)] = cljs.core.cons((5),(state_56381[(4)])));

return statearr_56392;
})();
var inst_56335 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56381__$1 = state_56381;
if(inst_56335){
var statearr_56393_56421 = state_56381__$1;
(statearr_56393_56421[(1)] = (6));

} else {
var statearr_56394_56422 = state_56381__$1;
(statearr_56394_56422[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (11))){
var state_56381__$1 = state_56381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56381__$1,(14),endSubject);
} else {
if((state_val_56382 === (9))){
var inst_56338 = (state_56381[(2)]);
var inst_56339 = fluree.db.util.async.throw_err(inst_56338);
var state_56381__$1 = state_56381;
var statearr_56396_56423 = state_56381__$1;
(statearr_56396_56423[(2)] = inst_56339);

(statearr_56396_56423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (5))){
var _ = (function (){var statearr_56397 = state_56381;
(statearr_56397[(4)] = cljs.core.rest((state_56381[(4)])));

return statearr_56397;
})();
var state_56381__$1 = state_56381;
var ex56395 = (state_56381__$1[(2)]);
var statearr_56398_56424 = state_56381__$1;
(statearr_56398_56424[(5)] = ex56395);


if((ex56395 instanceof Error)){
var statearr_56399_56425 = state_56381__$1;
(statearr_56399_56425[(1)] = (4));

(statearr_56399_56425[(5)] = null);

} else {
throw ex56395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (14))){
var inst_56350 = (state_56381[(2)]);
var inst_56351 = fluree.db.util.async.throw_err(inst_56350);
var state_56381__$1 = state_56381;
var statearr_56400_56426 = state_56381__$1;
(statearr_56400_56426[(2)] = inst_56351);

(statearr_56400_56426[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (16))){
var state_56381__$1 = state_56381;
var statearr_56401_56427 = state_56381__$1;
(statearr_56401_56427[(2)] = false);

(statearr_56401_56427[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (10))){
var inst_56345 = (state_56381[(2)]);
var inst_56346 = fluree.db.util.async.throw_err(inst_56345);
var inst_56347 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56381__$1 = (function (){var statearr_56402 = state_56381;
(statearr_56402[(8)] = inst_56346);

return statearr_56402;
})();
if(inst_56347){
var statearr_56403_56428 = state_56381__$1;
(statearr_56403_56428[(1)] = (11));

} else {
var statearr_56404_56429 = state_56381__$1;
(statearr_56404_56429[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (18))){
var inst_56346 = (state_56381[(8)]);
var inst_56361 = (state_56381[(7)]);
var inst_56354 = (state_56381[(9)]);
var inst_56342 = (state_56381[(10)]);
var inst_56366 = (state_56381[(2)]);
var inst_56367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56368 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56370 = [inst_56342,inst_56346,inst_56354];
var inst_56371 = (new cljs.core.PersistentVector(null,3,(5),inst_56369,inst_56370,null));
var inst_56372 = ["relationship?",inst_56371,inst_56366];
var inst_56373 = cljs.core.PersistentHashMap.fromArrays(inst_56368,inst_56372);
var inst_56374 = [inst_56373,inst_56361];
var inst_56375 = (new cljs.core.PersistentVector(null,2,(5),inst_56367,inst_56374,null));
var inst_56376 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56375);
var _ = (function (){var statearr_56405 = state_56381;
(statearr_56405[(4)] = cljs.core.rest((state_56381[(4)])));

return statearr_56405;
})();
var state_56381__$1 = (function (){var statearr_56406 = state_56381;
(statearr_56406[(11)] = inst_56376);

return statearr_56406;
})();
var statearr_56407_56430 = state_56381__$1;
(statearr_56407_56430[(2)] = inst_56366);

(statearr_56407_56430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56382 === (8))){
var inst_56342 = (state_56381[(2)]);
var inst_56343 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56381__$1 = (function (){var statearr_56408 = state_56381;
(statearr_56408[(10)] = inst_56342);

return statearr_56408;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56381__$1,(10),inst_56343);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_56409 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56409[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__);

(statearr_56409[(1)] = (1));

return statearr_56409;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1 = (function (state_56381){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56381);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56410){var ex__2417__auto__ = e56410;
var statearr_56411_56431 = state_56381;
(statearr_56411_56431[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56381[(4)]))){
var statearr_56412_56432 = state_56381;
(statearr_56412_56432[(1)] = cljs.core.first((state_56381[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56433 = state_56381;
state_56381 = G__56433;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__ = function(state_56381){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1.call(this,state_56381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56413 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56413[(6)] = c__2436__auto__);

return statearr_56413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56470){
var state_val_56471 = (state_56470[(1)]);
if((state_val_56471 === (7))){
var state_56470__$1 = state_56470;
var statearr_56472_56492 = state_56470__$1;
(statearr_56472_56492[(2)] = pred_name);

(statearr_56472_56492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (1))){
var state_56470__$1 = state_56470;
var statearr_56473_56493 = state_56470__$1;
(statearr_56473_56493[(2)] = null);

(statearr_56473_56493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (4))){
var inst_56434 = (state_56470[(2)]);
var state_56470__$1 = state_56470;
var statearr_56474_56494 = state_56470__$1;
(statearr_56474_56494[(2)] = inst_56434);

(statearr_56474_56494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (6))){
var state_56470__$1 = state_56470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56470__$1,(9),pred_name);
} else {
if((state_val_56471 === (3))){
var inst_56468 = (state_56470[(2)]);
var state_56470__$1 = state_56470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56470__$1,inst_56468);
} else {
if((state_val_56471 === (2))){
var _ = (function (){var statearr_56476 = state_56470;
(statearr_56476[(4)] = cljs.core.cons((5),(state_56470[(4)])));

return statearr_56476;
})();
var inst_56443 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56470__$1 = state_56470;
if(inst_56443){
var statearr_56477_56495 = state_56470__$1;
(statearr_56477_56495[(1)] = (6));

} else {
var statearr_56478_56496 = state_56470__$1;
(statearr_56478_56496[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (9))){
var inst_56446 = (state_56470[(2)]);
var inst_56447 = fluree.db.util.async.throw_err(inst_56446);
var state_56470__$1 = state_56470;
var statearr_56479_56497 = state_56470__$1;
(statearr_56479_56497[(2)] = inst_56447);

(statearr_56479_56497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (5))){
var _ = (function (){var statearr_56480 = state_56470;
(statearr_56480[(4)] = cljs.core.rest((state_56470[(4)])));

return statearr_56480;
})();
var state_56470__$1 = state_56470;
var ex56475 = (state_56470__$1[(2)]);
var statearr_56481_56498 = state_56470__$1;
(statearr_56481_56498[(5)] = ex56475);


if((ex56475 instanceof Error)){
var statearr_56482_56499 = state_56470__$1;
(statearr_56482_56499[(1)] = (4));

(statearr_56482_56499[(5)] = null);

} else {
throw ex56475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (10))){
var inst_56450 = (state_56470[(7)]);
var inst_56454 = (state_56470[(2)]);
var inst_56455 = fluree.db.util.async.throw_err(inst_56454);
var inst_56456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56455,(0),null);
var inst_56457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56455,(1),null);
var inst_56458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56459 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56460 = ["max-pred-val",inst_56450,inst_56456];
var inst_56461 = cljs.core.PersistentHashMap.fromArrays(inst_56459,inst_56460);
var inst_56462 = (inst_56457 + (10));
var inst_56463 = [inst_56461,inst_56462];
var inst_56464 = (new cljs.core.PersistentVector(null,2,(5),inst_56458,inst_56463,null));
var inst_56465 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56464);
var _ = (function (){var statearr_56483 = state_56470;
(statearr_56483[(4)] = cljs.core.rest((state_56470[(4)])));

return statearr_56483;
})();
var state_56470__$1 = (function (){var statearr_56484 = state_56470;
(statearr_56484[(8)] = inst_56465);

return statearr_56484;
})();
var statearr_56485_56500 = state_56470__$1;
(statearr_56485_56500[(2)] = inst_56456);

(statearr_56485_56500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56471 === (8))){
var inst_56450 = (state_56470[(7)]);
var inst_56450__$1 = (state_56470[(2)]);
var inst_56451 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56452 = fluree.db.dbfunctions.internal.max_pred_val(inst_56451,inst_56450__$1,null);
var state_56470__$1 = (function (){var statearr_56486 = state_56470;
(statearr_56486[(7)] = inst_56450__$1);

return statearr_56486;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56470__$1,(10),inst_56452);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0 = (function (){
var statearr_56487 = [null,null,null,null,null,null,null,null,null];
(statearr_56487[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__);

(statearr_56487[(1)] = (1));

return statearr_56487;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1 = (function (state_56470){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56470);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56488){var ex__2417__auto__ = e56488;
var statearr_56489_56501 = state_56470;
(statearr_56489_56501[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56470[(4)]))){
var statearr_56490_56502 = state_56470;
(statearr_56490_56502[(1)] = cljs.core.first((state_56470[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56503 = state_56470;
state_56470 = G__56503;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__ = function(state_56470){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1.call(this,state_56470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56491 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56491[(6)] = c__2436__auto__);

return statearr_56491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56530){
var state_val_56531 = (state_56530[(1)]);
if((state_val_56531 === (7))){
var state_56530__$1 = state_56530;
var statearr_56532_56551 = state_56530__$1;
(statearr_56532_56551[(2)] = n);

(statearr_56532_56551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (1))){
var state_56530__$1 = state_56530;
var statearr_56533_56552 = state_56530__$1;
(statearr_56533_56552[(2)] = null);

(statearr_56533_56552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (4))){
var inst_56504 = (state_56530[(2)]);
var state_56530__$1 = state_56530;
var statearr_56534_56553 = state_56530__$1;
(statearr_56534_56553[(2)] = inst_56504);

(statearr_56534_56553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (6))){
var state_56530__$1 = state_56530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56530__$1,(9),n);
} else {
if((state_val_56531 === (3))){
var inst_56528 = (state_56530[(2)]);
var state_56530__$1 = state_56530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56530__$1,inst_56528);
} else {
if((state_val_56531 === (2))){
var _ = (function (){var statearr_56536 = state_56530;
(statearr_56536[(4)] = cljs.core.cons((5),(state_56530[(4)])));

return statearr_56536;
})();
var inst_56510 = fluree.db.util.async.channel_QMARK_(n);
var state_56530__$1 = state_56530;
if(inst_56510){
var statearr_56537_56554 = state_56530__$1;
(statearr_56537_56554[(1)] = (6));

} else {
var statearr_56538_56555 = state_56530__$1;
(statearr_56538_56555[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (9))){
var inst_56513 = (state_56530[(2)]);
var inst_56514 = fluree.db.util.async.throw_err(inst_56513);
var state_56530__$1 = state_56530;
var statearr_56539_56556 = state_56530__$1;
(statearr_56539_56556[(2)] = inst_56514);

(statearr_56539_56556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (5))){
var _ = (function (){var statearr_56540 = state_56530;
(statearr_56540[(4)] = cljs.core.rest((state_56530[(4)])));

return statearr_56540;
})();
var state_56530__$1 = state_56530;
var ex56535 = (state_56530__$1[(2)]);
var statearr_56541_56557 = state_56530__$1;
(statearr_56541_56557[(5)] = ex56535);


if((ex56535 instanceof Error)){
var statearr_56542_56558 = state_56530__$1;
(statearr_56542_56558[(1)] = (4));

(statearr_56542_56558[(5)] = null);

} else {
throw ex56535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56531 === (8))){
var inst_56517 = (state_56530[(2)]);
var inst_56518 = fluree.db.dbfunctions.internal.inc(inst_56517);
var inst_56519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56520 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56521 = ["inc",inst_56517,inst_56518];
var inst_56522 = cljs.core.PersistentHashMap.fromArrays(inst_56520,inst_56521);
var inst_56523 = [inst_56522,(10)];
var inst_56524 = (new cljs.core.PersistentVector(null,2,(5),inst_56519,inst_56523,null));
var inst_56525 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56524);
var _ = (function (){var statearr_56543 = state_56530;
(statearr_56543[(4)] = cljs.core.rest((state_56530[(4)])));

return statearr_56543;
})();
var state_56530__$1 = (function (){var statearr_56544 = state_56530;
(statearr_56544[(7)] = inst_56525);

return statearr_56544;
})();
var statearr_56545_56559 = state_56530__$1;
(statearr_56545_56559[(2)] = inst_56518);

(statearr_56545_56559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0 = (function (){
var statearr_56546 = [null,null,null,null,null,null,null,null];
(statearr_56546[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__);

(statearr_56546[(1)] = (1));

return statearr_56546;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1 = (function (state_56530){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56530);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56547){var ex__2417__auto__ = e56547;
var statearr_56548_56560 = state_56530;
(statearr_56548_56560[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56530[(4)]))){
var statearr_56549_56561 = state_56530;
(statearr_56549_56561[(1)] = cljs.core.first((state_56530[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56562 = state_56530;
state_56530 = G__56562;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__ = function(state_56530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1.call(this,state_56530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56550 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56550[(6)] = c__2436__auto__);

return statearr_56550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56589){
var state_val_56590 = (state_56589[(1)]);
if((state_val_56590 === (7))){
var state_56589__$1 = state_56589;
var statearr_56591_56610 = state_56589__$1;
(statearr_56591_56610[(2)] = n);

(statearr_56591_56610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (1))){
var state_56589__$1 = state_56589;
var statearr_56592_56611 = state_56589__$1;
(statearr_56592_56611[(2)] = null);

(statearr_56592_56611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (4))){
var inst_56563 = (state_56589[(2)]);
var state_56589__$1 = state_56589;
var statearr_56593_56612 = state_56589__$1;
(statearr_56593_56612[(2)] = inst_56563);

(statearr_56593_56612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (6))){
var state_56589__$1 = state_56589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56589__$1,(9),n);
} else {
if((state_val_56590 === (3))){
var inst_56587 = (state_56589[(2)]);
var state_56589__$1 = state_56589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56589__$1,inst_56587);
} else {
if((state_val_56590 === (2))){
var _ = (function (){var statearr_56595 = state_56589;
(statearr_56595[(4)] = cljs.core.cons((5),(state_56589[(4)])));

return statearr_56595;
})();
var inst_56569 = fluree.db.util.async.channel_QMARK_(n);
var state_56589__$1 = state_56589;
if(inst_56569){
var statearr_56596_56613 = state_56589__$1;
(statearr_56596_56613[(1)] = (6));

} else {
var statearr_56597_56614 = state_56589__$1;
(statearr_56597_56614[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (9))){
var inst_56572 = (state_56589[(2)]);
var inst_56573 = fluree.db.util.async.throw_err(inst_56572);
var state_56589__$1 = state_56589;
var statearr_56598_56615 = state_56589__$1;
(statearr_56598_56615[(2)] = inst_56573);

(statearr_56598_56615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (5))){
var _ = (function (){var statearr_56599 = state_56589;
(statearr_56599[(4)] = cljs.core.rest((state_56589[(4)])));

return statearr_56599;
})();
var state_56589__$1 = state_56589;
var ex56594 = (state_56589__$1[(2)]);
var statearr_56600_56616 = state_56589__$1;
(statearr_56600_56616[(5)] = ex56594);


if((ex56594 instanceof Error)){
var statearr_56601_56617 = state_56589__$1;
(statearr_56601_56617[(1)] = (4));

(statearr_56601_56617[(5)] = null);

} else {
throw ex56594;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56590 === (8))){
var inst_56576 = (state_56589[(2)]);
var inst_56577 = fluree.db.dbfunctions.internal.dec(inst_56576);
var inst_56578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56579 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56580 = ["dec",inst_56576,inst_56577];
var inst_56581 = cljs.core.PersistentHashMap.fromArrays(inst_56579,inst_56580);
var inst_56582 = [inst_56581,(10)];
var inst_56583 = (new cljs.core.PersistentVector(null,2,(5),inst_56578,inst_56582,null));
var inst_56584 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56583);
var _ = (function (){var statearr_56602 = state_56589;
(statearr_56602[(4)] = cljs.core.rest((state_56589[(4)])));

return statearr_56602;
})();
var state_56589__$1 = (function (){var statearr_56603 = state_56589;
(statearr_56603[(7)] = inst_56584);

return statearr_56603;
})();
var statearr_56604_56618 = state_56589__$1;
(statearr_56604_56618[(2)] = inst_56577);

(statearr_56604_56618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0 = (function (){
var statearr_56605 = [null,null,null,null,null,null,null,null];
(statearr_56605[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__);

(statearr_56605[(1)] = (1));

return statearr_56605;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1 = (function (state_56589){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56589);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56606){var ex__2417__auto__ = e56606;
var statearr_56607_56619 = state_56589;
(statearr_56607_56619[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56589[(4)]))){
var statearr_56608_56620 = state_56589;
(statearr_56608_56620[(1)] = cljs.core.first((state_56589[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56621 = state_56589;
state_56589 = G__56621;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__ = function(state_56589){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1.call(this,state_56589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56609 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56609[(6)] = c__2436__auto__);

return statearr_56609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56671 = arguments.length;
var i__4737__auto___56672 = (0);
while(true){
if((i__4737__auto___56672 < len__4736__auto___56671)){
args__4742__auto__.push((arguments[i__4737__auto___56672]));

var G__56673 = (i__4737__auto___56672 + (1));
i__4737__auto___56672 = G__56673;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56654){
var state_val_56655 = (state_56654[(1)]);
if((state_val_56655 === (1))){
var state_56654__$1 = state_56654;
var statearr_56656_56674 = state_56654__$1;
(statearr_56656_56674[(2)] = null);

(statearr_56656_56674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56655 === (2))){
var _ = (function (){var statearr_56657 = state_56654;
(statearr_56657[(4)] = cljs.core.cons((5),(state_56654[(4)])));

return statearr_56657;
})();
var inst_56630 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56654__$1 = state_56654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56654__$1,(6),inst_56630);
} else {
if((state_val_56655 === (3))){
var inst_56652 = (state_56654[(2)]);
var state_56654__$1 = state_56654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56654__$1,inst_56652);
} else {
if((state_val_56655 === (4))){
var inst_56624 = (state_56654[(2)]);
var state_56654__$1 = state_56654;
var statearr_56659_56675 = state_56654__$1;
(statearr_56659_56675[(2)] = inst_56624);

(statearr_56659_56675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56655 === (5))){
var _ = (function (){var statearr_56660 = state_56654;
(statearr_56660[(4)] = cljs.core.rest((state_56654[(4)])));

return statearr_56660;
})();
var state_56654__$1 = state_56654;
var ex56658 = (state_56654__$1[(2)]);
var statearr_56661_56676 = state_56654__$1;
(statearr_56661_56676[(5)] = ex56658);


if((ex56658 instanceof Error)){
var statearr_56662_56677 = state_56654__$1;
(statearr_56662_56677[(1)] = (4));

(statearr_56662_56677[(5)] = null);

} else {
throw ex56658;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56655 === (6))){
var inst_56632 = (state_56654[(2)]);
var inst_56633 = fluree.db.util.async.throw_err(inst_56632);
var inst_56634 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56633);
var inst_56635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56636 = [inst_56633];
var inst_56637 = (new cljs.core.PersistentVector(null,1,(5),inst_56635,inst_56636,null));
var inst_56638 = cljs.core.count(inst_56637);
var inst_56639 = ((9) + inst_56638);
var inst_56640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56641 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56643 = [inst_56633];
var inst_56644 = (new cljs.core.PersistentVector(null,1,(5),inst_56642,inst_56643,null));
var inst_56645 = ["+",inst_56644,inst_56634];
var inst_56646 = cljs.core.PersistentHashMap.fromArrays(inst_56641,inst_56645);
var inst_56647 = [inst_56646,inst_56639];
var inst_56648 = (new cljs.core.PersistentVector(null,2,(5),inst_56640,inst_56647,null));
var inst_56649 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56648);
var _ = (function (){var statearr_56663 = state_56654;
(statearr_56663[(4)] = cljs.core.rest((state_56654[(4)])));

return statearr_56663;
})();
var state_56654__$1 = (function (){var statearr_56664 = state_56654;
(statearr_56664[(7)] = inst_56649);

return statearr_56664;
})();
var statearr_56665_56678 = state_56654__$1;
(statearr_56665_56678[(2)] = inst_56634);

(statearr_56665_56678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56666 = [null,null,null,null,null,null,null,null];
(statearr_56666[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56666[(1)] = (1));

return statearr_56666;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56654){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56654);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56667){var ex__2417__auto__ = e56667;
var statearr_56668_56679 = state_56654;
(statearr_56668_56679[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56654[(4)]))){
var statearr_56669_56680 = state_56654;
(statearr_56669_56680[(1)] = cljs.core.first((state_56654[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56681 = state_56654;
state_56654 = G__56681;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56670 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56670[(6)] = c__2436__auto__);

return statearr_56670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56622){
var G__56623 = cljs.core.first(seq56622);
var seq56622__$1 = cljs.core.next(seq56622);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56623,seq56622__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56731 = arguments.length;
var i__4737__auto___56732 = (0);
while(true){
if((i__4737__auto___56732 < len__4736__auto___56731)){
args__4742__auto__.push((arguments[i__4737__auto___56732]));

var G__56733 = (i__4737__auto___56732 + (1));
i__4737__auto___56732 = G__56733;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56714){
var state_val_56715 = (state_56714[(1)]);
if((state_val_56715 === (1))){
var state_56714__$1 = state_56714;
var statearr_56716_56734 = state_56714__$1;
(statearr_56716_56734[(2)] = null);

(statearr_56716_56734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56715 === (2))){
var _ = (function (){var statearr_56717 = state_56714;
(statearr_56717[(4)] = cljs.core.cons((5),(state_56714[(4)])));

return statearr_56717;
})();
var inst_56690 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56714__$1 = state_56714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56714__$1,(6),inst_56690);
} else {
if((state_val_56715 === (3))){
var inst_56712 = (state_56714[(2)]);
var state_56714__$1 = state_56714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56714__$1,inst_56712);
} else {
if((state_val_56715 === (4))){
var inst_56684 = (state_56714[(2)]);
var state_56714__$1 = state_56714;
var statearr_56719_56735 = state_56714__$1;
(statearr_56719_56735[(2)] = inst_56684);

(statearr_56719_56735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56715 === (5))){
var _ = (function (){var statearr_56720 = state_56714;
(statearr_56720[(4)] = cljs.core.rest((state_56714[(4)])));

return statearr_56720;
})();
var state_56714__$1 = state_56714;
var ex56718 = (state_56714__$1[(2)]);
var statearr_56721_56736 = state_56714__$1;
(statearr_56721_56736[(5)] = ex56718);


if((ex56718 instanceof Error)){
var statearr_56722_56737 = state_56714__$1;
(statearr_56722_56737[(1)] = (4));

(statearr_56722_56737[(5)] = null);

} else {
throw ex56718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56715 === (6))){
var inst_56692 = (state_56714[(2)]);
var inst_56693 = fluree.db.util.async.throw_err(inst_56692);
var inst_56694 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56693);
var inst_56695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56696 = [inst_56693];
var inst_56697 = (new cljs.core.PersistentVector(null,1,(5),inst_56695,inst_56696,null));
var inst_56698 = cljs.core.count(inst_56697);
var inst_56699 = ((9) + inst_56698);
var inst_56700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56701 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56703 = [inst_56693];
var inst_56704 = (new cljs.core.PersistentVector(null,1,(5),inst_56702,inst_56703,null));
var inst_56705 = ["-",inst_56704,inst_56694];
var inst_56706 = cljs.core.PersistentHashMap.fromArrays(inst_56701,inst_56705);
var inst_56707 = [inst_56706,inst_56699];
var inst_56708 = (new cljs.core.PersistentVector(null,2,(5),inst_56700,inst_56707,null));
var inst_56709 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56708);
var _ = (function (){var statearr_56723 = state_56714;
(statearr_56723[(4)] = cljs.core.rest((state_56714[(4)])));

return statearr_56723;
})();
var state_56714__$1 = (function (){var statearr_56724 = state_56714;
(statearr_56724[(7)] = inst_56709);

return statearr_56724;
})();
var statearr_56725_56738 = state_56714__$1;
(statearr_56725_56738[(2)] = inst_56694);

(statearr_56725_56738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56726 = [null,null,null,null,null,null,null,null];
(statearr_56726[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56726[(1)] = (1));

return statearr_56726;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56714){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56714);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56727){var ex__2417__auto__ = e56727;
var statearr_56728_56739 = state_56714;
(statearr_56728_56739[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56714[(4)]))){
var statearr_56729_56740 = state_56714;
(statearr_56729_56740[(1)] = cljs.core.first((state_56714[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56741 = state_56714;
state_56714 = G__56741;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56714){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56730 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56730[(6)] = c__2436__auto__);

return statearr_56730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56682){
var G__56683 = cljs.core.first(seq56682);
var seq56682__$1 = cljs.core.next(seq56682);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56683,seq56682__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56791 = arguments.length;
var i__4737__auto___56792 = (0);
while(true){
if((i__4737__auto___56792 < len__4736__auto___56791)){
args__4742__auto__.push((arguments[i__4737__auto___56792]));

var G__56793 = (i__4737__auto___56792 + (1));
i__4737__auto___56792 = G__56793;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56774){
var state_val_56775 = (state_56774[(1)]);
if((state_val_56775 === (1))){
var state_56774__$1 = state_56774;
var statearr_56776_56794 = state_56774__$1;
(statearr_56776_56794[(2)] = null);

(statearr_56776_56794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56775 === (2))){
var _ = (function (){var statearr_56777 = state_56774;
(statearr_56777[(4)] = cljs.core.cons((5),(state_56774[(4)])));

return statearr_56777;
})();
var inst_56750 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56774__$1 = state_56774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56774__$1,(6),inst_56750);
} else {
if((state_val_56775 === (3))){
var inst_56772 = (state_56774[(2)]);
var state_56774__$1 = state_56774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56774__$1,inst_56772);
} else {
if((state_val_56775 === (4))){
var inst_56744 = (state_56774[(2)]);
var state_56774__$1 = state_56774;
var statearr_56779_56795 = state_56774__$1;
(statearr_56779_56795[(2)] = inst_56744);

(statearr_56779_56795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56775 === (5))){
var _ = (function (){var statearr_56780 = state_56774;
(statearr_56780[(4)] = cljs.core.rest((state_56774[(4)])));

return statearr_56780;
})();
var state_56774__$1 = state_56774;
var ex56778 = (state_56774__$1[(2)]);
var statearr_56781_56796 = state_56774__$1;
(statearr_56781_56796[(5)] = ex56778);


if((ex56778 instanceof Error)){
var statearr_56782_56797 = state_56774__$1;
(statearr_56782_56797[(1)] = (4));

(statearr_56782_56797[(5)] = null);

} else {
throw ex56778;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56775 === (6))){
var inst_56752 = (state_56774[(2)]);
var inst_56753 = fluree.db.util.async.throw_err(inst_56752);
var inst_56754 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56753);
var inst_56755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56756 = [inst_56753];
var inst_56757 = (new cljs.core.PersistentVector(null,1,(5),inst_56755,inst_56756,null));
var inst_56758 = cljs.core.count(inst_56757);
var inst_56759 = ((9) + inst_56758);
var inst_56760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56761 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56763 = [inst_56753];
var inst_56764 = (new cljs.core.PersistentVector(null,1,(5),inst_56762,inst_56763,null));
var inst_56765 = ["*",inst_56764,inst_56754];
var inst_56766 = cljs.core.PersistentHashMap.fromArrays(inst_56761,inst_56765);
var inst_56767 = [inst_56766,inst_56759];
var inst_56768 = (new cljs.core.PersistentVector(null,2,(5),inst_56760,inst_56767,null));
var inst_56769 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56768);
var _ = (function (){var statearr_56783 = state_56774;
(statearr_56783[(4)] = cljs.core.rest((state_56774[(4)])));

return statearr_56783;
})();
var state_56774__$1 = (function (){var statearr_56784 = state_56774;
(statearr_56784[(7)] = inst_56769);

return statearr_56784;
})();
var statearr_56785_56798 = state_56774__$1;
(statearr_56785_56798[(2)] = inst_56754);

(statearr_56785_56798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56786 = [null,null,null,null,null,null,null,null];
(statearr_56786[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56786[(1)] = (1));

return statearr_56786;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56774){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56774);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56787){var ex__2417__auto__ = e56787;
var statearr_56788_56799 = state_56774;
(statearr_56788_56799[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56774[(4)]))){
var statearr_56789_56800 = state_56774;
(statearr_56789_56800[(1)] = cljs.core.first((state_56774[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56801 = state_56774;
state_56774 = G__56801;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56774){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56790 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56790[(6)] = c__2436__auto__);

return statearr_56790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56742){
var G__56743 = cljs.core.first(seq56742);
var seq56742__$1 = cljs.core.next(seq56742);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56743,seq56742__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56851 = arguments.length;
var i__4737__auto___56852 = (0);
while(true){
if((i__4737__auto___56852 < len__4736__auto___56851)){
args__4742__auto__.push((arguments[i__4737__auto___56852]));

var G__56853 = (i__4737__auto___56852 + (1));
i__4737__auto___56852 = G__56853;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56834){
var state_val_56835 = (state_56834[(1)]);
if((state_val_56835 === (1))){
var state_56834__$1 = state_56834;
var statearr_56836_56854 = state_56834__$1;
(statearr_56836_56854[(2)] = null);

(statearr_56836_56854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56835 === (2))){
var _ = (function (){var statearr_56837 = state_56834;
(statearr_56837[(4)] = cljs.core.cons((5),(state_56834[(4)])));

return statearr_56837;
})();
var inst_56810 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56834__$1 = state_56834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56834__$1,(6),inst_56810);
} else {
if((state_val_56835 === (3))){
var inst_56832 = (state_56834[(2)]);
var state_56834__$1 = state_56834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56834__$1,inst_56832);
} else {
if((state_val_56835 === (4))){
var inst_56804 = (state_56834[(2)]);
var state_56834__$1 = state_56834;
var statearr_56839_56855 = state_56834__$1;
(statearr_56839_56855[(2)] = inst_56804);

(statearr_56839_56855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56835 === (5))){
var _ = (function (){var statearr_56840 = state_56834;
(statearr_56840[(4)] = cljs.core.rest((state_56834[(4)])));

return statearr_56840;
})();
var state_56834__$1 = state_56834;
var ex56838 = (state_56834__$1[(2)]);
var statearr_56841_56856 = state_56834__$1;
(statearr_56841_56856[(5)] = ex56838);


if((ex56838 instanceof Error)){
var statearr_56842_56857 = state_56834__$1;
(statearr_56842_56857[(1)] = (4));

(statearr_56842_56857[(5)] = null);

} else {
throw ex56838;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56835 === (6))){
var inst_56812 = (state_56834[(2)]);
var inst_56813 = fluree.db.util.async.throw_err(inst_56812);
var inst_56814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56813);
var inst_56815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56816 = [inst_56813];
var inst_56817 = (new cljs.core.PersistentVector(null,1,(5),inst_56815,inst_56816,null));
var inst_56818 = cljs.core.count(inst_56817);
var inst_56819 = ((9) + inst_56818);
var inst_56820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56821 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56823 = [inst_56813];
var inst_56824 = (new cljs.core.PersistentVector(null,1,(5),inst_56822,inst_56823,null));
var inst_56825 = ["/",inst_56824,inst_56814];
var inst_56826 = cljs.core.PersistentHashMap.fromArrays(inst_56821,inst_56825);
var inst_56827 = [inst_56826,inst_56819];
var inst_56828 = (new cljs.core.PersistentVector(null,2,(5),inst_56820,inst_56827,null));
var inst_56829 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56828);
var _ = (function (){var statearr_56843 = state_56834;
(statearr_56843[(4)] = cljs.core.rest((state_56834[(4)])));

return statearr_56843;
})();
var state_56834__$1 = (function (){var statearr_56844 = state_56834;
(statearr_56844[(7)] = inst_56829);

return statearr_56844;
})();
var statearr_56845_56858 = state_56834__$1;
(statearr_56845_56858[(2)] = inst_56814);

(statearr_56845_56858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56846 = [null,null,null,null,null,null,null,null];
(statearr_56846[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56846[(1)] = (1));

return statearr_56846;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56834){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56834);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56847){var ex__2417__auto__ = e56847;
var statearr_56848_56859 = state_56834;
(statearr_56848_56859[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56834[(4)]))){
var statearr_56849_56860 = state_56834;
(statearr_56849_56860[(1)] = cljs.core.first((state_56834[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56861 = state_56834;
state_56834 = G__56861;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56834){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56850 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56850[(6)] = c__2436__auto__);

return statearr_56850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56802){
var G__56803 = cljs.core.first(seq56802);
var seq56802__$1 = cljs.core.next(seq56802);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56803,seq56802__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56899){
var state_val_56900 = (state_56899[(1)]);
if((state_val_56900 === (7))){
var state_56899__$1 = state_56899;
var statearr_56901_56925 = state_56899__$1;
(statearr_56901_56925[(2)] = n);

(statearr_56901_56925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (1))){
var state_56899__$1 = state_56899;
var statearr_56902_56926 = state_56899__$1;
(statearr_56902_56926[(2)] = null);

(statearr_56902_56926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (4))){
var inst_56862 = (state_56899[(2)]);
var state_56899__$1 = state_56899;
var statearr_56903_56927 = state_56899__$1;
(statearr_56903_56927[(2)] = inst_56862);

(statearr_56903_56927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (13))){
var inst_56879 = (state_56899[(2)]);
var inst_56880 = fluree.db.util.async.throw_err(inst_56879);
var state_56899__$1 = state_56899;
var statearr_56904_56928 = state_56899__$1;
(statearr_56904_56928[(2)] = inst_56880);

(statearr_56904_56928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (6))){
var state_56899__$1 = state_56899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56899__$1,(9),n);
} else {
if((state_val_56900 === (3))){
var inst_56897 = (state_56899[(2)]);
var state_56899__$1 = state_56899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56899__$1,inst_56897);
} else {
if((state_val_56900 === (12))){
var inst_56875 = (state_56899[(7)]);
var inst_56883 = (state_56899[(2)]);
var inst_56884 = fluree.db.dbfunctions.internal.quot(inst_56875,inst_56883);
var inst_56885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56886 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56888 = [inst_56875,inst_56883];
var inst_56889 = (new cljs.core.PersistentVector(null,2,(5),inst_56887,inst_56888,null));
var inst_56890 = ["quot",inst_56889,inst_56884];
var inst_56891 = cljs.core.PersistentHashMap.fromArrays(inst_56886,inst_56890);
var inst_56892 = [inst_56891,(2)];
var inst_56893 = (new cljs.core.PersistentVector(null,2,(5),inst_56885,inst_56892,null));
var inst_56894 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56893);
var _ = (function (){var statearr_56905 = state_56899;
(statearr_56905[(4)] = cljs.core.rest((state_56899[(4)])));

return statearr_56905;
})();
var state_56899__$1 = (function (){var statearr_56906 = state_56899;
(statearr_56906[(8)] = inst_56894);

return statearr_56906;
})();
var statearr_56907_56929 = state_56899__$1;
(statearr_56907_56929[(2)] = inst_56884);

(statearr_56907_56929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (2))){
var _ = (function (){var statearr_56908 = state_56899;
(statearr_56908[(4)] = cljs.core.cons((5),(state_56899[(4)])));

return statearr_56908;
})();
var inst_56868 = fluree.db.util.async.channel_QMARK_(n);
var state_56899__$1 = state_56899;
if(inst_56868){
var statearr_56909_56930 = state_56899__$1;
(statearr_56909_56930[(1)] = (6));

} else {
var statearr_56910_56931 = state_56899__$1;
(statearr_56910_56931[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (11))){
var state_56899__$1 = state_56899;
var statearr_56912_56932 = state_56899__$1;
(statearr_56912_56932[(2)] = d);

(statearr_56912_56932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (9))){
var inst_56871 = (state_56899[(2)]);
var inst_56872 = fluree.db.util.async.throw_err(inst_56871);
var state_56899__$1 = state_56899;
var statearr_56913_56933 = state_56899__$1;
(statearr_56913_56933[(2)] = inst_56872);

(statearr_56913_56933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (5))){
var _ = (function (){var statearr_56914 = state_56899;
(statearr_56914[(4)] = cljs.core.rest((state_56899[(4)])));

return statearr_56914;
})();
var state_56899__$1 = state_56899;
var ex56911 = (state_56899__$1[(2)]);
var statearr_56915_56934 = state_56899__$1;
(statearr_56915_56934[(5)] = ex56911);


if((ex56911 instanceof Error)){
var statearr_56916_56935 = state_56899__$1;
(statearr_56916_56935[(1)] = (4));

(statearr_56916_56935[(5)] = null);

} else {
throw ex56911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (10))){
var state_56899__$1 = state_56899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56899__$1,(13),d);
} else {
if((state_val_56900 === (8))){
var inst_56875 = (state_56899[(2)]);
var inst_56876 = fluree.db.util.async.channel_QMARK_(d);
var state_56899__$1 = (function (){var statearr_56917 = state_56899;
(statearr_56917[(7)] = inst_56875);

return statearr_56917;
})();
if(inst_56876){
var statearr_56918_56936 = state_56899__$1;
(statearr_56918_56936[(1)] = (10));

} else {
var statearr_56919_56937 = state_56899__$1;
(statearr_56919_56937[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0 = (function (){
var statearr_56920 = [null,null,null,null,null,null,null,null,null];
(statearr_56920[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__);

(statearr_56920[(1)] = (1));

return statearr_56920;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1 = (function (state_56899){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56899);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56921){var ex__2417__auto__ = e56921;
var statearr_56922_56938 = state_56899;
(statearr_56922_56938[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56899[(4)]))){
var statearr_56923_56939 = state_56899;
(statearr_56923_56939[(1)] = cljs.core.first((state_56899[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56940 = state_56899;
state_56899 = G__56940;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__ = function(state_56899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1.call(this,state_56899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56924 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56924[(6)] = c__2436__auto__);

return statearr_56924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56978){
var state_val_56979 = (state_56978[(1)]);
if((state_val_56979 === (7))){
var state_56978__$1 = state_56978;
var statearr_56980_57004 = state_56978__$1;
(statearr_56980_57004[(2)] = n);

(statearr_56980_57004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (1))){
var state_56978__$1 = state_56978;
var statearr_56981_57005 = state_56978__$1;
(statearr_56981_57005[(2)] = null);

(statearr_56981_57005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (4))){
var inst_56941 = (state_56978[(2)]);
var state_56978__$1 = state_56978;
var statearr_56982_57006 = state_56978__$1;
(statearr_56982_57006[(2)] = inst_56941);

(statearr_56982_57006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (13))){
var inst_56958 = (state_56978[(2)]);
var inst_56959 = fluree.db.util.async.throw_err(inst_56958);
var state_56978__$1 = state_56978;
var statearr_56983_57007 = state_56978__$1;
(statearr_56983_57007[(2)] = inst_56959);

(statearr_56983_57007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (6))){
var state_56978__$1 = state_56978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56978__$1,(9),n);
} else {
if((state_val_56979 === (3))){
var inst_56976 = (state_56978[(2)]);
var state_56978__$1 = state_56978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56978__$1,inst_56976);
} else {
if((state_val_56979 === (12))){
var inst_56954 = (state_56978[(7)]);
var inst_56962 = (state_56978[(2)]);
var inst_56963 = fluree.db.dbfunctions.internal.mod(inst_56954,inst_56962);
var inst_56964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56965 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56967 = [inst_56954,inst_56962];
var inst_56968 = (new cljs.core.PersistentVector(null,2,(5),inst_56966,inst_56967,null));
var inst_56969 = ["mod",inst_56968,inst_56963];
var inst_56970 = cljs.core.PersistentHashMap.fromArrays(inst_56965,inst_56969);
var inst_56971 = [inst_56970,(2)];
var inst_56972 = (new cljs.core.PersistentVector(null,2,(5),inst_56964,inst_56971,null));
var inst_56973 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56972);
var _ = (function (){var statearr_56984 = state_56978;
(statearr_56984[(4)] = cljs.core.rest((state_56978[(4)])));

return statearr_56984;
})();
var state_56978__$1 = (function (){var statearr_56985 = state_56978;
(statearr_56985[(8)] = inst_56973);

return statearr_56985;
})();
var statearr_56986_57008 = state_56978__$1;
(statearr_56986_57008[(2)] = inst_56963);

(statearr_56986_57008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (2))){
var _ = (function (){var statearr_56987 = state_56978;
(statearr_56987[(4)] = cljs.core.cons((5),(state_56978[(4)])));

return statearr_56987;
})();
var inst_56947 = fluree.db.util.async.channel_QMARK_(n);
var state_56978__$1 = state_56978;
if(inst_56947){
var statearr_56988_57009 = state_56978__$1;
(statearr_56988_57009[(1)] = (6));

} else {
var statearr_56989_57010 = state_56978__$1;
(statearr_56989_57010[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (11))){
var state_56978__$1 = state_56978;
var statearr_56991_57011 = state_56978__$1;
(statearr_56991_57011[(2)] = d);

(statearr_56991_57011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (9))){
var inst_56950 = (state_56978[(2)]);
var inst_56951 = fluree.db.util.async.throw_err(inst_56950);
var state_56978__$1 = state_56978;
var statearr_56992_57012 = state_56978__$1;
(statearr_56992_57012[(2)] = inst_56951);

(statearr_56992_57012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (5))){
var _ = (function (){var statearr_56993 = state_56978;
(statearr_56993[(4)] = cljs.core.rest((state_56978[(4)])));

return statearr_56993;
})();
var state_56978__$1 = state_56978;
var ex56990 = (state_56978__$1[(2)]);
var statearr_56994_57013 = state_56978__$1;
(statearr_56994_57013[(5)] = ex56990);


if((ex56990 instanceof Error)){
var statearr_56995_57014 = state_56978__$1;
(statearr_56995_57014[(1)] = (4));

(statearr_56995_57014[(5)] = null);

} else {
throw ex56990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56979 === (10))){
var state_56978__$1 = state_56978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56978__$1,(13),d);
} else {
if((state_val_56979 === (8))){
var inst_56954 = (state_56978[(2)]);
var inst_56955 = fluree.db.util.async.channel_QMARK_(d);
var state_56978__$1 = (function (){var statearr_56996 = state_56978;
(statearr_56996[(7)] = inst_56954);

return statearr_56996;
})();
if(inst_56955){
var statearr_56997_57015 = state_56978__$1;
(statearr_56997_57015[(1)] = (10));

} else {
var statearr_56998_57016 = state_56978__$1;
(statearr_56998_57016[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0 = (function (){
var statearr_56999 = [null,null,null,null,null,null,null,null,null];
(statearr_56999[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__);

(statearr_56999[(1)] = (1));

return statearr_56999;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1 = (function (state_56978){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56978);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57000){var ex__2417__auto__ = e57000;
var statearr_57001_57017 = state_56978;
(statearr_57001_57017[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56978[(4)]))){
var statearr_57002_57018 = state_56978;
(statearr_57002_57018[(1)] = cljs.core.first((state_56978[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57019 = state_56978;
state_56978 = G__57019;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__ = function(state_56978){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1.call(this,state_56978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57003 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57003[(6)] = c__2436__auto__);

return statearr_57003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57057){
var state_val_57058 = (state_57057[(1)]);
if((state_val_57058 === (7))){
var state_57057__$1 = state_57057;
var statearr_57059_57083 = state_57057__$1;
(statearr_57059_57083[(2)] = n);

(statearr_57059_57083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (1))){
var state_57057__$1 = state_57057;
var statearr_57060_57084 = state_57057__$1;
(statearr_57060_57084[(2)] = null);

(statearr_57060_57084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (4))){
var inst_57020 = (state_57057[(2)]);
var state_57057__$1 = state_57057;
var statearr_57061_57085 = state_57057__$1;
(statearr_57061_57085[(2)] = inst_57020);

(statearr_57061_57085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (13))){
var inst_57037 = (state_57057[(2)]);
var inst_57038 = fluree.db.util.async.throw_err(inst_57037);
var state_57057__$1 = state_57057;
var statearr_57062_57086 = state_57057__$1;
(statearr_57062_57086[(2)] = inst_57038);

(statearr_57062_57086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (6))){
var state_57057__$1 = state_57057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57057__$1,(9),n);
} else {
if((state_val_57058 === (3))){
var inst_57055 = (state_57057[(2)]);
var state_57057__$1 = state_57057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57057__$1,inst_57055);
} else {
if((state_val_57058 === (12))){
var inst_57033 = (state_57057[(7)]);
var inst_57041 = (state_57057[(2)]);
var inst_57042 = fluree.db.dbfunctions.internal.rem(inst_57033,inst_57041);
var inst_57043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57044 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57046 = [inst_57033,inst_57041];
var inst_57047 = (new cljs.core.PersistentVector(null,2,(5),inst_57045,inst_57046,null));
var inst_57048 = ["rem",inst_57047,inst_57042];
var inst_57049 = cljs.core.PersistentHashMap.fromArrays(inst_57044,inst_57048);
var inst_57050 = [inst_57049,(2)];
var inst_57051 = (new cljs.core.PersistentVector(null,2,(5),inst_57043,inst_57050,null));
var inst_57052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57051);
var _ = (function (){var statearr_57063 = state_57057;
(statearr_57063[(4)] = cljs.core.rest((state_57057[(4)])));

return statearr_57063;
})();
var state_57057__$1 = (function (){var statearr_57064 = state_57057;
(statearr_57064[(8)] = inst_57052);

return statearr_57064;
})();
var statearr_57065_57087 = state_57057__$1;
(statearr_57065_57087[(2)] = inst_57042);

(statearr_57065_57087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (2))){
var _ = (function (){var statearr_57066 = state_57057;
(statearr_57066[(4)] = cljs.core.cons((5),(state_57057[(4)])));

return statearr_57066;
})();
var inst_57026 = fluree.db.util.async.channel_QMARK_(n);
var state_57057__$1 = state_57057;
if(inst_57026){
var statearr_57067_57088 = state_57057__$1;
(statearr_57067_57088[(1)] = (6));

} else {
var statearr_57068_57089 = state_57057__$1;
(statearr_57068_57089[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (11))){
var state_57057__$1 = state_57057;
var statearr_57070_57090 = state_57057__$1;
(statearr_57070_57090[(2)] = d);

(statearr_57070_57090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (9))){
var inst_57029 = (state_57057[(2)]);
var inst_57030 = fluree.db.util.async.throw_err(inst_57029);
var state_57057__$1 = state_57057;
var statearr_57071_57091 = state_57057__$1;
(statearr_57071_57091[(2)] = inst_57030);

(statearr_57071_57091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (5))){
var _ = (function (){var statearr_57072 = state_57057;
(statearr_57072[(4)] = cljs.core.rest((state_57057[(4)])));

return statearr_57072;
})();
var state_57057__$1 = state_57057;
var ex57069 = (state_57057__$1[(2)]);
var statearr_57073_57092 = state_57057__$1;
(statearr_57073_57092[(5)] = ex57069);


if((ex57069 instanceof Error)){
var statearr_57074_57093 = state_57057__$1;
(statearr_57074_57093[(1)] = (4));

(statearr_57074_57093[(5)] = null);

} else {
throw ex57069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57058 === (10))){
var state_57057__$1 = state_57057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57057__$1,(13),d);
} else {
if((state_val_57058 === (8))){
var inst_57033 = (state_57057[(2)]);
var inst_57034 = fluree.db.util.async.channel_QMARK_(d);
var state_57057__$1 = (function (){var statearr_57075 = state_57057;
(statearr_57075[(7)] = inst_57033);

return statearr_57075;
})();
if(inst_57034){
var statearr_57076_57094 = state_57057__$1;
(statearr_57076_57094[(1)] = (10));

} else {
var statearr_57077_57095 = state_57057__$1;
(statearr_57077_57095[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0 = (function (){
var statearr_57078 = [null,null,null,null,null,null,null,null,null];
(statearr_57078[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__);

(statearr_57078[(1)] = (1));

return statearr_57078;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1 = (function (state_57057){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57057);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57079){var ex__2417__auto__ = e57079;
var statearr_57080_57096 = state_57057;
(statearr_57080_57096[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57057[(4)]))){
var statearr_57081_57097 = state_57057;
(statearr_57081_57097[(1)] = cljs.core.first((state_57057[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57098 = state_57057;
state_57057 = G__57098;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__ = function(state_57057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1.call(this,state_57057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57082 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57082[(6)] = c__2436__auto__);

return statearr_57082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57125){
var state_val_57126 = (state_57125[(1)]);
if((state_val_57126 === (7))){
var state_57125__$1 = state_57125;
var statearr_57127_57146 = state_57125__$1;
(statearr_57127_57146[(2)] = x);

(statearr_57127_57146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (1))){
var state_57125__$1 = state_57125;
var statearr_57128_57147 = state_57125__$1;
(statearr_57128_57147[(2)] = null);

(statearr_57128_57147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (4))){
var inst_57099 = (state_57125[(2)]);
var state_57125__$1 = state_57125;
var statearr_57129_57148 = state_57125__$1;
(statearr_57129_57148[(2)] = inst_57099);

(statearr_57129_57148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (6))){
var state_57125__$1 = state_57125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57125__$1,(9),x);
} else {
if((state_val_57126 === (3))){
var inst_57123 = (state_57125[(2)]);
var state_57125__$1 = state_57125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57125__$1,inst_57123);
} else {
if((state_val_57126 === (2))){
var _ = (function (){var statearr_57131 = state_57125;
(statearr_57131[(4)] = cljs.core.cons((5),(state_57125[(4)])));

return statearr_57131;
})();
var inst_57105 = fluree.db.util.async.channel_QMARK_(x);
var state_57125__$1 = state_57125;
if(inst_57105){
var statearr_57132_57149 = state_57125__$1;
(statearr_57132_57149[(1)] = (6));

} else {
var statearr_57133_57150 = state_57125__$1;
(statearr_57133_57150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (9))){
var inst_57108 = (state_57125[(2)]);
var inst_57109 = fluree.db.util.async.throw_err(inst_57108);
var state_57125__$1 = state_57125;
var statearr_57134_57151 = state_57125__$1;
(statearr_57134_57151[(2)] = inst_57109);

(statearr_57134_57151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (5))){
var _ = (function (){var statearr_57135 = state_57125;
(statearr_57135[(4)] = cljs.core.rest((state_57125[(4)])));

return statearr_57135;
})();
var state_57125__$1 = state_57125;
var ex57130 = (state_57125__$1[(2)]);
var statearr_57136_57152 = state_57125__$1;
(statearr_57136_57152[(5)] = ex57130);


if((ex57130 instanceof Error)){
var statearr_57137_57153 = state_57125__$1;
(statearr_57137_57153[(1)] = (4));

(statearr_57137_57153[(5)] = null);

} else {
throw ex57130;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57126 === (8))){
var inst_57112 = (state_57125[(2)]);
var inst_57113 = fluree.db.dbfunctions.internal.boolean$(inst_57112);
var inst_57114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57115 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57116 = ["boolean",inst_57112,inst_57113];
var inst_57117 = cljs.core.PersistentHashMap.fromArrays(inst_57115,inst_57116);
var inst_57118 = [inst_57117,(10)];
var inst_57119 = (new cljs.core.PersistentVector(null,2,(5),inst_57114,inst_57118,null));
var inst_57120 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57119);
var _ = (function (){var statearr_57138 = state_57125;
(statearr_57138[(4)] = cljs.core.rest((state_57125[(4)])));

return statearr_57138;
})();
var state_57125__$1 = (function (){var statearr_57139 = state_57125;
(statearr_57139[(7)] = inst_57120);

return statearr_57139;
})();
var statearr_57140_57154 = state_57125__$1;
(statearr_57140_57154[(2)] = inst_57113);

(statearr_57140_57154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0 = (function (){
var statearr_57141 = [null,null,null,null,null,null,null,null];
(statearr_57141[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__);

(statearr_57141[(1)] = (1));

return statearr_57141;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1 = (function (state_57125){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57125);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57142){var ex__2417__auto__ = e57142;
var statearr_57143_57155 = state_57125;
(statearr_57143_57155[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57125[(4)]))){
var statearr_57144_57156 = state_57125;
(statearr_57144_57156[(1)] = cljs.core.first((state_57125[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57157 = state_57125;
state_57125 = G__57157;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__ = function(state_57125){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1.call(this,state_57125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57145 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57145[(6)] = c__2436__auto__);

return statearr_57145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57195){
var state_val_57196 = (state_57195[(1)]);
if((state_val_57196 === (7))){
var state_57195__$1 = state_57195;
var statearr_57197_57221 = state_57195__$1;
(statearr_57197_57221[(2)] = pattern);

(statearr_57197_57221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (1))){
var state_57195__$1 = state_57195;
var statearr_57198_57222 = state_57195__$1;
(statearr_57198_57222[(2)] = null);

(statearr_57198_57222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (4))){
var inst_57158 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
var statearr_57199_57223 = state_57195__$1;
(statearr_57199_57223[(2)] = inst_57158);

(statearr_57199_57223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (13))){
var inst_57175 = (state_57195[(2)]);
var inst_57176 = fluree.db.util.async.throw_err(inst_57175);
var state_57195__$1 = state_57195;
var statearr_57200_57224 = state_57195__$1;
(statearr_57200_57224[(2)] = inst_57176);

(statearr_57200_57224[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (6))){
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57195__$1,(9),pattern);
} else {
if((state_val_57196 === (3))){
var inst_57193 = (state_57195[(2)]);
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57195__$1,inst_57193);
} else {
if((state_val_57196 === (12))){
var inst_57171 = (state_57195[(7)]);
var inst_57179 = (state_57195[(2)]);
var inst_57180 = fluree.db.dbfunctions.internal.re_find(inst_57171,inst_57179);
var inst_57181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57182 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57184 = [inst_57171,inst_57179];
var inst_57185 = (new cljs.core.PersistentVector(null,2,(5),inst_57183,inst_57184,null));
var inst_57186 = ["re-find",inst_57185,inst_57180];
var inst_57187 = cljs.core.PersistentHashMap.fromArrays(inst_57182,inst_57186);
var inst_57188 = [inst_57187,(10)];
var inst_57189 = (new cljs.core.PersistentVector(null,2,(5),inst_57181,inst_57188,null));
var inst_57190 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57189);
var _ = (function (){var statearr_57201 = state_57195;
(statearr_57201[(4)] = cljs.core.rest((state_57195[(4)])));

return statearr_57201;
})();
var state_57195__$1 = (function (){var statearr_57202 = state_57195;
(statearr_57202[(8)] = inst_57190);

return statearr_57202;
})();
var statearr_57203_57225 = state_57195__$1;
(statearr_57203_57225[(2)] = inst_57180);

(statearr_57203_57225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (2))){
var _ = (function (){var statearr_57204 = state_57195;
(statearr_57204[(4)] = cljs.core.cons((5),(state_57195[(4)])));

return statearr_57204;
})();
var inst_57164 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57195__$1 = state_57195;
if(inst_57164){
var statearr_57205_57226 = state_57195__$1;
(statearr_57205_57226[(1)] = (6));

} else {
var statearr_57206_57227 = state_57195__$1;
(statearr_57206_57227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (11))){
var state_57195__$1 = state_57195;
var statearr_57208_57228 = state_57195__$1;
(statearr_57208_57228[(2)] = string);

(statearr_57208_57228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (9))){
var inst_57167 = (state_57195[(2)]);
var inst_57168 = fluree.db.util.async.throw_err(inst_57167);
var state_57195__$1 = state_57195;
var statearr_57209_57229 = state_57195__$1;
(statearr_57209_57229[(2)] = inst_57168);

(statearr_57209_57229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (5))){
var _ = (function (){var statearr_57210 = state_57195;
(statearr_57210[(4)] = cljs.core.rest((state_57195[(4)])));

return statearr_57210;
})();
var state_57195__$1 = state_57195;
var ex57207 = (state_57195__$1[(2)]);
var statearr_57211_57230 = state_57195__$1;
(statearr_57211_57230[(5)] = ex57207);


if((ex57207 instanceof Error)){
var statearr_57212_57231 = state_57195__$1;
(statearr_57212_57231[(1)] = (4));

(statearr_57212_57231[(5)] = null);

} else {
throw ex57207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57196 === (10))){
var state_57195__$1 = state_57195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57195__$1,(13),string);
} else {
if((state_val_57196 === (8))){
var inst_57171 = (state_57195[(2)]);
var inst_57172 = fluree.db.util.async.channel_QMARK_(string);
var state_57195__$1 = (function (){var statearr_57213 = state_57195;
(statearr_57213[(7)] = inst_57171);

return statearr_57213;
})();
if(inst_57172){
var statearr_57214_57232 = state_57195__$1;
(statearr_57214_57232[(1)] = (10));

} else {
var statearr_57215_57233 = state_57195__$1;
(statearr_57215_57233[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0 = (function (){
var statearr_57216 = [null,null,null,null,null,null,null,null,null];
(statearr_57216[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__);

(statearr_57216[(1)] = (1));

return statearr_57216;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1 = (function (state_57195){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57195);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57217){var ex__2417__auto__ = e57217;
var statearr_57218_57234 = state_57195;
(statearr_57218_57234[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57195[(4)]))){
var statearr_57219_57235 = state_57195;
(statearr_57219_57235[(1)] = cljs.core.first((state_57195[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57236 = state_57195;
state_57195 = G__57236;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__ = function(state_57195){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1.call(this,state_57195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57220 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57220[(6)] = c__2436__auto__);

return statearr_57220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57263){
var state_val_57264 = (state_57263[(1)]);
if((state_val_57264 === (7))){
var state_57263__$1 = state_57263;
var statearr_57265_57284 = state_57263__$1;
(statearr_57265_57284[(2)] = email);

(statearr_57265_57284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (1))){
var state_57263__$1 = state_57263;
var statearr_57266_57285 = state_57263__$1;
(statearr_57266_57285[(2)] = null);

(statearr_57266_57285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (4))){
var inst_57237 = (state_57263[(2)]);
var state_57263__$1 = state_57263;
var statearr_57267_57286 = state_57263__$1;
(statearr_57267_57286[(2)] = inst_57237);

(statearr_57267_57286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (6))){
var state_57263__$1 = state_57263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57263__$1,(9),email);
} else {
if((state_val_57264 === (3))){
var inst_57261 = (state_57263[(2)]);
var state_57263__$1 = state_57263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57263__$1,inst_57261);
} else {
if((state_val_57264 === (2))){
var _ = (function (){var statearr_57269 = state_57263;
(statearr_57269[(4)] = cljs.core.cons((5),(state_57263[(4)])));

return statearr_57269;
})();
var inst_57243 = fluree.db.util.async.channel_QMARK_(email);
var state_57263__$1 = state_57263;
if(inst_57243){
var statearr_57270_57287 = state_57263__$1;
(statearr_57270_57287[(1)] = (6));

} else {
var statearr_57271_57288 = state_57263__$1;
(statearr_57271_57288[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (9))){
var inst_57246 = (state_57263[(2)]);
var inst_57247 = fluree.db.util.async.throw_err(inst_57246);
var state_57263__$1 = state_57263;
var statearr_57272_57289 = state_57263__$1;
(statearr_57272_57289[(2)] = inst_57247);

(statearr_57272_57289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (5))){
var _ = (function (){var statearr_57273 = state_57263;
(statearr_57273[(4)] = cljs.core.rest((state_57263[(4)])));

return statearr_57273;
})();
var state_57263__$1 = state_57263;
var ex57268 = (state_57263__$1[(2)]);
var statearr_57274_57290 = state_57263__$1;
(statearr_57274_57290[(5)] = ex57268);


if((ex57268 instanceof Error)){
var statearr_57275_57291 = state_57263__$1;
(statearr_57275_57291[(1)] = (4));

(statearr_57275_57291[(5)] = null);

} else {
throw ex57268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57264 === (8))){
var inst_57250 = (state_57263[(2)]);
var inst_57251 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57250);
var inst_57252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57253 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57254 = ["re-find",inst_57250,inst_57251];
var inst_57255 = cljs.core.PersistentHashMap.fromArrays(inst_57253,inst_57254);
var inst_57256 = [inst_57255,(10)];
var inst_57257 = (new cljs.core.PersistentVector(null,2,(5),inst_57252,inst_57256,null));
var inst_57258 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57257);
var _ = (function (){var statearr_57276 = state_57263;
(statearr_57276[(4)] = cljs.core.rest((state_57263[(4)])));

return statearr_57276;
})();
var state_57263__$1 = (function (){var statearr_57277 = state_57263;
(statearr_57277[(7)] = inst_57258);

return statearr_57277;
})();
var statearr_57278_57292 = state_57263__$1;
(statearr_57278_57292[(2)] = inst_57251);

(statearr_57278_57292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_57279 = [null,null,null,null,null,null,null,null];
(statearr_57279[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__);

(statearr_57279[(1)] = (1));

return statearr_57279;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1 = (function (state_57263){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57263);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57280){var ex__2417__auto__ = e57280;
var statearr_57281_57293 = state_57263;
(statearr_57281_57293[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57263[(4)]))){
var statearr_57282_57294 = state_57263;
(statearr_57282_57294[(1)] = cljs.core.first((state_57263[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57295 = state_57263;
state_57263 = G__57295;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__ = function(state_57263){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1.call(this,state_57263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57283 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57283[(6)] = c__2436__auto__);

return statearr_57283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57342){
var state_val_57343 = (state_57342[(1)]);
if((state_val_57343 === (7))){
var inst_57312 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57342__$1 = state_57342;
if(cljs.core.truth_(inst_57312)){
var statearr_57344_57371 = state_57342__$1;
(statearr_57344_57371[(1)] = (9));

} else {
var statearr_57345_57372 = state_57342__$1;
(statearr_57345_57372[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (1))){
var state_57342__$1 = state_57342;
var statearr_57346_57373 = state_57342__$1;
(statearr_57346_57373[(2)] = null);

(statearr_57346_57373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (4))){
var inst_57296 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
var statearr_57347_57374 = state_57342__$1;
(statearr_57347_57374[(2)] = inst_57296);

(statearr_57347_57374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (15))){
var inst_57323 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
var statearr_57348_57375 = state_57342__$1;
(statearr_57348_57375[(2)] = inst_57323);

(statearr_57348_57375[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (13))){
var inst_57320 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57342__$1 = state_57342;
var statearr_57349_57376 = state_57342__$1;
(statearr_57349_57376[(2)] = inst_57320);

(statearr_57349_57376[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (6))){
var inst_57307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57308 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57309 = [inst_57308,(0)];
var inst_57310 = (new cljs.core.PersistentVector(null,2,(5),inst_57307,inst_57309,null));
var state_57342__$1 = state_57342;
var statearr_57350_57377 = state_57342__$1;
(statearr_57350_57377[(2)] = inst_57310);

(statearr_57350_57377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (3))){
var inst_57340 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57342__$1,inst_57340);
} else {
if((state_val_57343 === (12))){
var inst_57316 = (state_57342[(2)]);
var inst_57317 = fluree.db.util.async.throw_err(inst_57316);
var state_57342__$1 = state_57342;
var statearr_57351_57378 = state_57342__$1;
(statearr_57351_57378[(2)] = inst_57317);

(statearr_57351_57378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (2))){
var _ = (function (){var statearr_57352 = state_57342;
(statearr_57352[(4)] = cljs.core.cons((5),(state_57342[(4)])));

return statearr_57352;
})();
var inst_57305 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57342__$1 = state_57342;
if(cljs.core.truth_(inst_57305)){
var statearr_57353_57379 = state_57342__$1;
(statearr_57353_57379[(1)] = (6));

} else {
var statearr_57354_57380 = state_57342__$1;
(statearr_57354_57380[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (11))){
var inst_57325 = (state_57342[(2)]);
var state_57342__$1 = state_57342;
var statearr_57356_57381 = state_57342__$1;
(statearr_57356_57381[(2)] = inst_57325);

(statearr_57356_57381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (9))){
var inst_57314 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57342__$1 = state_57342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57342__$1,(12),inst_57314);
} else {
if((state_val_57343 === (5))){
var _ = (function (){var statearr_57357 = state_57342;
(statearr_57357[(4)] = cljs.core.rest((state_57342[(4)])));

return statearr_57357;
})();
var state_57342__$1 = state_57342;
var ex57355 = (state_57342__$1[(2)]);
var statearr_57358_57382 = state_57342__$1;
(statearr_57358_57382[(5)] = ex57355);


if((ex57355 instanceof Error)){
var statearr_57359_57383 = state_57342__$1;
(statearr_57359_57383[(1)] = (4));

(statearr_57359_57383[(5)] = null);

} else {
throw ex57355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (14))){
var state_57342__$1 = state_57342;
var statearr_57360_57384 = state_57342__$1;
(statearr_57360_57384[(2)] = null);

(statearr_57360_57384[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (10))){
var state_57342__$1 = state_57342;
var statearr_57361_57385 = state_57342__$1;
(statearr_57361_57385[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57343 === (8))){
var inst_57327 = (state_57342[(2)]);
var inst_57328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57327,(0),null);
var inst_57329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57327,(1),null);
var inst_57330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57331 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57332 = ["?user_id","?ctx",inst_57328];
var inst_57333 = cljs.core.PersistentHashMap.fromArrays(inst_57331,inst_57332);
var inst_57334 = ((10) + inst_57329);
var inst_57335 = [inst_57333,inst_57334];
var inst_57336 = (new cljs.core.PersistentVector(null,2,(5),inst_57330,inst_57335,null));
var inst_57337 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57336);
var _ = (function (){var statearr_57363 = state_57342;
(statearr_57363[(4)] = cljs.core.rest((state_57342[(4)])));

return statearr_57363;
})();
var state_57342__$1 = (function (){var statearr_57364 = state_57342;
(statearr_57364[(7)] = inst_57337);

return statearr_57364;
})();
var statearr_57365_57386 = state_57342__$1;
(statearr_57365_57386[(2)] = inst_57328);

(statearr_57365_57386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0 = (function (){
var statearr_57366 = [null,null,null,null,null,null,null,null];
(statearr_57366[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__);

(statearr_57366[(1)] = (1));

return statearr_57366;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1 = (function (state_57342){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57342);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57367){var ex__2417__auto__ = e57367;
var statearr_57368_57387 = state_57342;
(statearr_57368_57387[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57342[(4)]))){
var statearr_57369_57388 = state_57342;
(statearr_57369_57388[(1)] = cljs.core.first((state_57342[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57389 = state_57342;
state_57342 = G__57389;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__ = function(state_57342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1.call(this,state_57342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57370 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57370[(6)] = c__2436__auto__);

return statearr_57370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57417){
var state_val_57418 = (state_57417[(1)]);
if((state_val_57418 === (7))){
var inst_57410 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57417__$1 = state_57417;
var statearr_57419_57438 = state_57417__$1;
(statearr_57419_57438[(2)] = inst_57410);

(statearr_57419_57438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (1))){
var state_57417__$1 = state_57417;
var statearr_57420_57439 = state_57417__$1;
(statearr_57420_57439[(2)] = null);

(statearr_57420_57439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (4))){
var inst_57390 = (state_57417[(2)]);
var state_57417__$1 = state_57417;
var statearr_57421_57440 = state_57417__$1;
(statearr_57421_57440[(2)] = inst_57390);

(statearr_57421_57440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (6))){
var inst_57398 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57417__$1 = state_57417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57417__$1,(9),inst_57398);
} else {
if((state_val_57418 === (3))){
var inst_57415 = (state_57417[(2)]);
var state_57417__$1 = state_57417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57417__$1,inst_57415);
} else {
if((state_val_57418 === (2))){
var _ = (function (){var statearr_57423 = state_57417;
(statearr_57423[(4)] = cljs.core.cons((5),(state_57417[(4)])));

return statearr_57423;
})();
var inst_57396 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57417__$1 = state_57417;
if(cljs.core.truth_(inst_57396)){
var statearr_57424_57441 = state_57417__$1;
(statearr_57424_57441[(1)] = (6));

} else {
var statearr_57425_57442 = state_57417__$1;
(statearr_57425_57442[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (9))){
var inst_57400 = (state_57417[(2)]);
var inst_57401 = fluree.db.util.async.throw_err(inst_57400);
var inst_57402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57403 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57404 = ["?auth_id","?ctx",inst_57401];
var inst_57405 = cljs.core.PersistentHashMap.fromArrays(inst_57403,inst_57404);
var inst_57406 = [inst_57405,(10)];
var inst_57407 = (new cljs.core.PersistentVector(null,2,(5),inst_57402,inst_57406,null));
var inst_57408 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57407);
var state_57417__$1 = (function (){var statearr_57426 = state_57417;
(statearr_57426[(7)] = inst_57408);

return statearr_57426;
})();
var statearr_57427_57443 = state_57417__$1;
(statearr_57427_57443[(2)] = inst_57401);

(statearr_57427_57443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (5))){
var _ = (function (){var statearr_57428 = state_57417;
(statearr_57428[(4)] = cljs.core.rest((state_57417[(4)])));

return statearr_57428;
})();
var state_57417__$1 = state_57417;
var ex57422 = (state_57417__$1[(2)]);
var statearr_57429_57444 = state_57417__$1;
(statearr_57429_57444[(5)] = ex57422);


if((ex57422 instanceof Error)){
var statearr_57430_57445 = state_57417__$1;
(statearr_57430_57445[(1)] = (4));

(statearr_57430_57445[(5)] = null);

} else {
throw ex57422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57418 === (8))){
var inst_57412 = (state_57417[(2)]);
var _ = (function (){var statearr_57431 = state_57417;
(statearr_57431[(4)] = cljs.core.rest((state_57417[(4)])));

return statearr_57431;
})();
var state_57417__$1 = state_57417;
var statearr_57432_57446 = state_57417__$1;
(statearr_57432_57446[(2)] = inst_57412);

(statearr_57432_57446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0 = (function (){
var statearr_57433 = [null,null,null,null,null,null,null,null];
(statearr_57433[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__);

(statearr_57433[(1)] = (1));

return statearr_57433;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1 = (function (state_57417){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57417);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57434){var ex__2417__auto__ = e57434;
var statearr_57435_57447 = state_57417;
(statearr_57435_57447[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57417[(4)]))){
var statearr_57436_57448 = state_57417;
(statearr_57436_57448[(1)] = cljs.core.first((state_57417[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57449 = state_57417;
state_57417 = G__57449;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__ = function(state_57417){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1.call(this,state_57417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57437 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57437[(6)] = c__2436__auto__);

return statearr_57437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57451 = arguments.length;
switch (G__57451) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57493){
var state_val_57494 = (state_57493[(1)]);
if((state_val_57494 === (7))){
var state_57493__$1 = state_57493;
var statearr_57495_57525 = state_57493__$1;
(statearr_57495_57525[(2)] = seed);

(statearr_57495_57525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (1))){
var state_57493__$1 = state_57493;
var statearr_57496_57526 = state_57493__$1;
(statearr_57496_57526[(2)] = null);

(statearr_57496_57526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (4))){
var inst_57452 = (state_57493[(2)]);
var state_57493__$1 = state_57493;
var statearr_57497_57527 = state_57493__$1;
(statearr_57497_57527[(2)] = inst_57452);

(statearr_57497_57527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (15))){
var state_57493__$1 = state_57493;
var statearr_57498_57528 = state_57493__$1;
(statearr_57498_57528[(2)] = (10));

(statearr_57498_57528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (13))){
var inst_57469 = (state_57493[(2)]);
var inst_57470 = fluree.db.util.async.throw_err(inst_57469);
var state_57493__$1 = state_57493;
var statearr_57499_57529 = state_57493__$1;
(statearr_57499_57529[(2)] = inst_57470);

(statearr_57499_57529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (6))){
var state_57493__$1 = state_57493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57493__$1,(9),seed);
} else {
if((state_val_57494 === (3))){
var inst_57491 = (state_57493[(2)]);
var state_57493__$1 = state_57493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57493__$1,inst_57491);
} else {
if((state_val_57494 === (12))){
var inst_57473 = (state_57493[(7)]);
var inst_57473__$1 = (state_57493[(2)]);
var state_57493__$1 = (function (){var statearr_57500 = state_57493;
(statearr_57500[(7)] = inst_57473__$1);

return statearr_57500;
})();
if(cljs.core.truth_(inst_57473__$1)){
var statearr_57501_57530 = state_57493__$1;
(statearr_57501_57530[(1)] = (14));

} else {
var statearr_57502_57531 = state_57493__$1;
(statearr_57502_57531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (2))){
var _ = (function (){var statearr_57503 = state_57493;
(statearr_57503[(4)] = cljs.core.cons((5),(state_57493[(4)])));

return statearr_57503;
})();
var inst_57458 = fluree.db.util.async.channel_QMARK_(seed);
var state_57493__$1 = state_57493;
if(inst_57458){
var statearr_57504_57532 = state_57493__$1;
(statearr_57504_57532[(1)] = (6));

} else {
var statearr_57505_57533 = state_57493__$1;
(statearr_57505_57533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (11))){
var state_57493__$1 = state_57493;
var statearr_57507_57534 = state_57493__$1;
(statearr_57507_57534[(2)] = max);

(statearr_57507_57534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (9))){
var inst_57461 = (state_57493[(2)]);
var inst_57462 = fluree.db.util.async.throw_err(inst_57461);
var state_57493__$1 = state_57493;
var statearr_57508_57535 = state_57493__$1;
(statearr_57508_57535[(2)] = inst_57462);

(statearr_57508_57535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (5))){
var _ = (function (){var statearr_57509 = state_57493;
(statearr_57509[(4)] = cljs.core.rest((state_57493[(4)])));

return statearr_57509;
})();
var state_57493__$1 = state_57493;
var ex57506 = (state_57493__$1[(2)]);
var statearr_57510_57536 = state_57493__$1;
(statearr_57510_57536[(5)] = ex57506);


if((ex57506 instanceof Error)){
var statearr_57511_57537 = state_57493__$1;
(statearr_57511_57537[(1)] = (4));

(statearr_57511_57537[(5)] = null);

} else {
throw ex57506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (14))){
var inst_57473 = (state_57493[(7)]);
var state_57493__$1 = state_57493;
var statearr_57512_57538 = state_57493__$1;
(statearr_57512_57538[(2)] = inst_57473);

(statearr_57512_57538[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (16))){
var inst_57465 = (state_57493[(8)]);
var inst_57477 = (state_57493[(2)]);
var inst_57478 = fluree.db.dbfunctions.internal.rand(inst_57465,inst_57477);
var inst_57479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57480 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57482 = [seed,max];
var inst_57483 = (new cljs.core.PersistentVector(null,2,(5),inst_57481,inst_57482,null));
var inst_57484 = ["rand",inst_57483,inst_57478];
var inst_57485 = cljs.core.PersistentHashMap.fromArrays(inst_57480,inst_57484);
var inst_57486 = [inst_57485,(10)];
var inst_57487 = (new cljs.core.PersistentVector(null,2,(5),inst_57479,inst_57486,null));
var inst_57488 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57487);
var _ = (function (){var statearr_57513 = state_57493;
(statearr_57513[(4)] = cljs.core.rest((state_57493[(4)])));

return statearr_57513;
})();
var state_57493__$1 = (function (){var statearr_57514 = state_57493;
(statearr_57514[(9)] = inst_57488);

return statearr_57514;
})();
var statearr_57515_57539 = state_57493__$1;
(statearr_57515_57539[(2)] = inst_57478);

(statearr_57515_57539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57494 === (10))){
var state_57493__$1 = state_57493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57493__$1,(13),max);
} else {
if((state_val_57494 === (8))){
var inst_57465 = (state_57493[(2)]);
var inst_57466 = fluree.db.util.async.channel_QMARK_(max);
var state_57493__$1 = (function (){var statearr_57516 = state_57493;
(statearr_57516[(8)] = inst_57465);

return statearr_57516;
})();
if(inst_57466){
var statearr_57517_57540 = state_57493__$1;
(statearr_57517_57540[(1)] = (10));

} else {
var statearr_57518_57541 = state_57493__$1;
(statearr_57518_57541[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_57519 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57519[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_57519[(1)] = (1));

return statearr_57519;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_57493){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57493);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57520){var ex__2417__auto__ = e57520;
var statearr_57521_57542 = state_57493;
(statearr_57521_57542[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57493[(4)]))){
var statearr_57522_57543 = state_57493;
(statearr_57522_57543[(1)] = cljs.core.first((state_57493[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57544 = state_57493;
state_57493 = G__57544;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_57493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_57493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57523 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57523[(6)] = c__2436__auto__);

return statearr_57523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57565){
var state_val_57566 = (state_57565[(1)]);
if((state_val_57566 === (1))){
var state_57565__$1 = state_57565;
var statearr_57567_57582 = state_57565__$1;
(statearr_57567_57582[(2)] = null);

(statearr_57567_57582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (2))){
var _ = (function (){var statearr_57568 = state_57565;
(statearr_57568[(4)] = cljs.core.cons((5),(state_57565[(4)])));

return statearr_57568;
})();
var inst_57551 = fluree.db.util.core.random_uuid();
var inst_57552 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57551);
var inst_57553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57554 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57555 = cljs.core.PersistentVector.EMPTY;
var inst_57556 = ["uuid",inst_57555,inst_57552];
var inst_57557 = cljs.core.PersistentHashMap.fromArrays(inst_57554,inst_57556);
var inst_57558 = [inst_57557,(10)];
var inst_57559 = (new cljs.core.PersistentVector(null,2,(5),inst_57553,inst_57558,null));
var inst_57560 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57559);
var ___$1 = (function (){var statearr_57569 = state_57565;
(statearr_57569[(4)] = cljs.core.rest((state_57565[(4)])));

return statearr_57569;
})();
var state_57565__$1 = (function (){var statearr_57570 = state_57565;
(statearr_57570[(7)] = inst_57560);

return statearr_57570;
})();
var statearr_57571_57583 = state_57565__$1;
(statearr_57571_57583[(2)] = inst_57552);

(statearr_57571_57583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (3))){
var inst_57563 = (state_57565[(2)]);
var state_57565__$1 = state_57565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57565__$1,inst_57563);
} else {
if((state_val_57566 === (4))){
var inst_57545 = (state_57565[(2)]);
var state_57565__$1 = state_57565;
var statearr_57573_57584 = state_57565__$1;
(statearr_57573_57584[(2)] = inst_57545);

(statearr_57573_57584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57566 === (5))){
var _ = (function (){var statearr_57574 = state_57565;
(statearr_57574[(4)] = cljs.core.rest((state_57565[(4)])));

return statearr_57574;
})();
var state_57565__$1 = state_57565;
var ex57572 = (state_57565__$1[(2)]);
var statearr_57575_57585 = state_57565__$1;
(statearr_57575_57585[(5)] = ex57572);


if((ex57572 instanceof Error)){
var statearr_57576_57586 = state_57565__$1;
(statearr_57576_57586[(1)] = (4));

(statearr_57576_57586[(5)] = null);

} else {
throw ex57572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0 = (function (){
var statearr_57577 = [null,null,null,null,null,null,null,null];
(statearr_57577[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__);

(statearr_57577[(1)] = (1));

return statearr_57577;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1 = (function (state_57565){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57565);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57578){var ex__2417__auto__ = e57578;
var statearr_57579_57587 = state_57565;
(statearr_57579_57587[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57565[(4)]))){
var statearr_57580_57588 = state_57565;
(statearr_57580_57588[(1)] = cljs.core.first((state_57565[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57589 = state_57565;
state_57565 = G__57589;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__ = function(state_57565){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1.call(this,state_57565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57581 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57581[(6)] = c__2436__auto__);

return statearr_57581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57619){
var state_val_57620 = (state_57619[(1)]);
if((state_val_57620 === (7))){
var state_57619__$1 = state_57619;
var statearr_57621_57640 = state_57619__$1;
(statearr_57621_57640[(2)] = num);

(statearr_57621_57640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (1))){
var state_57619__$1 = state_57619;
var statearr_57622_57641 = state_57619__$1;
(statearr_57622_57641[(2)] = null);

(statearr_57622_57641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (4))){
var inst_57590 = (state_57619[(2)]);
var state_57619__$1 = state_57619;
var statearr_57623_57642 = state_57619__$1;
(statearr_57623_57642[(2)] = inst_57590);

(statearr_57623_57642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (6))){
var state_57619__$1 = state_57619;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57619__$1,(9),num);
} else {
if((state_val_57620 === (3))){
var inst_57617 = (state_57619[(2)]);
var state_57619__$1 = state_57619;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57619__$1,inst_57617);
} else {
if((state_val_57620 === (2))){
var _ = (function (){var statearr_57625 = state_57619;
(statearr_57625[(4)] = cljs.core.cons((5),(state_57619[(4)])));

return statearr_57625;
})();
var inst_57596 = fluree.db.util.async.channel_QMARK_(num);
var state_57619__$1 = state_57619;
if(inst_57596){
var statearr_57626_57643 = state_57619__$1;
(statearr_57626_57643[(1)] = (6));

} else {
var statearr_57627_57644 = state_57619__$1;
(statearr_57627_57644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (9))){
var inst_57599 = (state_57619[(2)]);
var inst_57600 = fluree.db.util.async.throw_err(inst_57599);
var state_57619__$1 = state_57619;
var statearr_57628_57645 = state_57619__$1;
(statearr_57628_57645[(2)] = inst_57600);

(statearr_57628_57645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (5))){
var _ = (function (){var statearr_57629 = state_57619;
(statearr_57629[(4)] = cljs.core.rest((state_57619[(4)])));

return statearr_57629;
})();
var state_57619__$1 = state_57619;
var ex57624 = (state_57619__$1[(2)]);
var statearr_57630_57646 = state_57619__$1;
(statearr_57630_57646[(5)] = ex57624);


if((ex57624 instanceof Error)){
var statearr_57631_57647 = state_57619__$1;
(statearr_57631_57647[(1)] = (4));

(statearr_57631_57647[(5)] = null);

} else {
throw ex57624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57620 === (8))){
var inst_57603 = (state_57619[(2)]);
var inst_57604 = fluree.db.dbfunctions.internal.ceil(inst_57603);
var inst_57605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57606 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57608 = [fluree.db.dbfunctions.fns.ceil];
var inst_57609 = (new cljs.core.PersistentVector(null,1,(5),inst_57607,inst_57608,null));
var inst_57610 = ["",inst_57609,inst_57604];
var inst_57611 = cljs.core.PersistentHashMap.fromArrays(inst_57606,inst_57610);
var inst_57612 = [inst_57611,(10)];
var inst_57613 = (new cljs.core.PersistentVector(null,2,(5),inst_57605,inst_57612,null));
var inst_57614 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57613);
var _ = (function (){var statearr_57632 = state_57619;
(statearr_57632[(4)] = cljs.core.rest((state_57619[(4)])));

return statearr_57632;
})();
var state_57619__$1 = (function (){var statearr_57633 = state_57619;
(statearr_57633[(7)] = inst_57614);

return statearr_57633;
})();
var statearr_57634_57648 = state_57619__$1;
(statearr_57634_57648[(2)] = inst_57604);

(statearr_57634_57648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0 = (function (){
var statearr_57635 = [null,null,null,null,null,null,null,null];
(statearr_57635[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__);

(statearr_57635[(1)] = (1));

return statearr_57635;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1 = (function (state_57619){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57619);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57636){var ex__2417__auto__ = e57636;
var statearr_57637_57649 = state_57619;
(statearr_57637_57649[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57619[(4)]))){
var statearr_57638_57650 = state_57619;
(statearr_57638_57650[(1)] = cljs.core.first((state_57619[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57651 = state_57619;
state_57619 = G__57651;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__ = function(state_57619){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1.call(this,state_57619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57639 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57639[(6)] = c__2436__auto__);

return statearr_57639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57681){
var state_val_57682 = (state_57681[(1)]);
if((state_val_57682 === (7))){
var state_57681__$1 = state_57681;
var statearr_57683_57702 = state_57681__$1;
(statearr_57683_57702[(2)] = num);

(statearr_57683_57702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (1))){
var state_57681__$1 = state_57681;
var statearr_57684_57703 = state_57681__$1;
(statearr_57684_57703[(2)] = null);

(statearr_57684_57703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (4))){
var inst_57652 = (state_57681[(2)]);
var state_57681__$1 = state_57681;
var statearr_57685_57704 = state_57681__$1;
(statearr_57685_57704[(2)] = inst_57652);

(statearr_57685_57704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (6))){
var state_57681__$1 = state_57681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57681__$1,(9),num);
} else {
if((state_val_57682 === (3))){
var inst_57679 = (state_57681[(2)]);
var state_57681__$1 = state_57681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57681__$1,inst_57679);
} else {
if((state_val_57682 === (2))){
var _ = (function (){var statearr_57687 = state_57681;
(statearr_57687[(4)] = cljs.core.cons((5),(state_57681[(4)])));

return statearr_57687;
})();
var inst_57658 = fluree.db.util.async.channel_QMARK_(num);
var state_57681__$1 = state_57681;
if(inst_57658){
var statearr_57688_57705 = state_57681__$1;
(statearr_57688_57705[(1)] = (6));

} else {
var statearr_57689_57706 = state_57681__$1;
(statearr_57689_57706[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (9))){
var inst_57661 = (state_57681[(2)]);
var inst_57662 = fluree.db.util.async.throw_err(inst_57661);
var state_57681__$1 = state_57681;
var statearr_57690_57707 = state_57681__$1;
(statearr_57690_57707[(2)] = inst_57662);

(statearr_57690_57707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (5))){
var _ = (function (){var statearr_57691 = state_57681;
(statearr_57691[(4)] = cljs.core.rest((state_57681[(4)])));

return statearr_57691;
})();
var state_57681__$1 = state_57681;
var ex57686 = (state_57681__$1[(2)]);
var statearr_57692_57708 = state_57681__$1;
(statearr_57692_57708[(5)] = ex57686);


if((ex57686 instanceof Error)){
var statearr_57693_57709 = state_57681__$1;
(statearr_57693_57709[(1)] = (4));

(statearr_57693_57709[(5)] = null);

} else {
throw ex57686;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57682 === (8))){
var inst_57665 = (state_57681[(2)]);
var inst_57666 = fluree.db.dbfunctions.internal.floor(inst_57665);
var inst_57667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57668 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57670 = [fluree.db.dbfunctions.fns.floor];
var inst_57671 = (new cljs.core.PersistentVector(null,1,(5),inst_57669,inst_57670,null));
var inst_57672 = ["",inst_57671,inst_57666];
var inst_57673 = cljs.core.PersistentHashMap.fromArrays(inst_57668,inst_57672);
var inst_57674 = [inst_57673,(10)];
var inst_57675 = (new cljs.core.PersistentVector(null,2,(5),inst_57667,inst_57674,null));
var inst_57676 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57675);
var _ = (function (){var statearr_57694 = state_57681;
(statearr_57694[(4)] = cljs.core.rest((state_57681[(4)])));

return statearr_57694;
})();
var state_57681__$1 = (function (){var statearr_57695 = state_57681;
(statearr_57695[(7)] = inst_57676);

return statearr_57695;
})();
var statearr_57696_57710 = state_57681__$1;
(statearr_57696_57710[(2)] = inst_57666);

(statearr_57696_57710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0 = (function (){
var statearr_57697 = [null,null,null,null,null,null,null,null];
(statearr_57697[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__);

(statearr_57697[(1)] = (1));

return statearr_57697;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1 = (function (state_57681){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57681);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57698){var ex__2417__auto__ = e57698;
var statearr_57699_57711 = state_57681;
(statearr_57699_57711[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57681[(4)]))){
var statearr_57700_57712 = state_57681;
(statearr_57700_57712[(1)] = cljs.core.first((state_57681[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57713 = state_57681;
state_57681 = G__57713;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__ = function(state_57681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1.call(this,state_57681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57701 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57701[(6)] = c__2436__auto__);

return statearr_57701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
