// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.crypto.util');
goog.require('cljs.core');
goog.require('alphabase.core');
/**
 * Normalizes string for consistent hashing.
 */
fluree.crypto.util.normalize_string = (function fluree$crypto$util$normalize_string(s){
return s.normalize("NFKC");
});
/**
 * Does simple check when input format not specified.
 *   Assumes either string or bytes
 */
fluree.crypto.util.coerce_input_format = (function fluree$crypto$util$coerce_input_format(x){
if(typeof x === 'string'){
return new cljs.core.Keyword(null,"string","string",-1989541586);
} else {
return new cljs.core.Keyword(null,"bytes","bytes",1175866680);
}
});
/**
 * Normalizes string then converts to a byte-array.
 *   If value is already a byte-array, returns original value.
 */
fluree.crypto.util.string__GT_byte_array = (function fluree$crypto$util$string__GT_byte_array(s){
return alphabase.core.string__GT_bytes(fluree.crypto.util.normalize_string(s));
});
fluree.crypto.util.byte_array__GT_string = (function fluree$crypto$util$byte_array__GT_string(s){
return alphabase.core.bytes__GT_string(s);
});
