(ns fluree.db.util.account-id
  (:require [fluree.crypto.secp256k1 :as secp256k1]))


(defn from-public-key [public-key]
  (secp256k1/get-sin-from-public-key public-key))


(def from-private-key
  (comp from-public-key secp256k1/pub-key-from-private))


(defn from-message [message signature]
  (-> message
      (secp256k1/recover-public-key signature)
      from-public-key))
