// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4776__auto___127731 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true;

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127778){
var state_val_127779 = (state_127778[(1)]);
if((state_val_127779 === (7))){
var inst_127748 = (state_127778[(7)]);
var state_127778__$1 = state_127778;
var statearr_127780_127801 = state_127778__$1;
(statearr_127780_127801[(2)] = inst_127748);

(statearr_127780_127801[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (1))){
var state_127778__$1 = state_127778;
var statearr_127781_127802 = state_127778__$1;
(statearr_127781_127802[(2)] = null);

(statearr_127781_127802[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127778,(3),Error,null,(2));
var inst_127743 = cljs.core.seq(args);
var inst_127744 = cljs.core.first(inst_127743);
var inst_127745 = cljs.core.next(inst_127743);
var inst_127746 = cljs.core.PersistentVector.EMPTY;
var inst_127747 = args;
var inst_127748 = inst_127746;
var state_127778__$1 = (function (){var statearr_127782 = state_127778;
(statearr_127782[(8)] = inst_127744);

(statearr_127782[(9)] = inst_127745);

(statearr_127782[(7)] = inst_127748);

(statearr_127782[(10)] = inst_127747);

return statearr_127782;
})();
var statearr_127783_127803 = state_127778__$1;
(statearr_127783_127803[(2)] = null);

(statearr_127783_127803[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (13))){
var inst_127748 = (state_127778[(7)]);
var inst_127755 = (state_127778[(11)]);
var inst_127762 = (state_127778[(2)]);
var inst_127763 = fluree.db.util.async.throw_err(inst_127762);
var inst_127764 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_127748,inst_127763);
var inst_127747 = inst_127755;
var inst_127748__$1 = inst_127764;
var state_127778__$1 = (function (){var statearr_127784 = state_127778;
(statearr_127784[(7)] = inst_127748__$1);

(statearr_127784[(10)] = inst_127747);

return statearr_127784;
})();
var statearr_127785_127804 = state_127778__$1;
(statearr_127785_127804[(2)] = null);

(statearr_127785_127804[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (6))){
var inst_127774 = (state_127778[(2)]);
var state_127778__$1 = state_127778;
var statearr_127786_127805 = state_127778__$1;
(statearr_127786_127805[(2)] = inst_127774);


cljs.core.async.impl.ioc_helpers.process_exception(state_127778__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (3))){
var inst_127732 = (state_127778[(2)]);
var state_127778__$1 = state_127778;
var statearr_127787_127806 = state_127778__$1;
(statearr_127787_127806[(2)] = inst_127732);


cljs.core.async.impl.ioc_helpers.process_exception(state_127778__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (12))){
var inst_127770 = (state_127778[(2)]);
var state_127778__$1 = state_127778;
var statearr_127788_127807 = state_127778__$1;
(statearr_127788_127807[(2)] = inst_127770);

(statearr_127788_127807[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (2))){
var inst_127776 = (state_127778[(2)]);
var state_127778__$1 = state_127778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127778__$1,inst_127776);
} else {
if((state_val_127779 === (11))){
var inst_127748 = (state_127778[(7)]);
var inst_127755 = (state_127778[(11)]);
var inst_127754 = (state_127778[(12)]);
var inst_127767 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_127748,inst_127754);
var inst_127747 = inst_127755;
var inst_127748__$1 = inst_127767;
var state_127778__$1 = (function (){var statearr_127789 = state_127778;
(statearr_127789[(7)] = inst_127748__$1);

(statearr_127789[(10)] = inst_127747);

return statearr_127789;
})();
var statearr_127790_127808 = state_127778__$1;
(statearr_127790_127808[(2)] = null);

(statearr_127790_127808[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (9))){
var inst_127772 = (state_127778[(2)]);
var state_127778__$1 = state_127778;
var statearr_127791_127809 = state_127778__$1;
(statearr_127791_127809[(2)] = inst_127772);

(statearr_127791_127809[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (5))){
var inst_127747 = (state_127778[(10)]);
var inst_127754 = (state_127778[(12)]);
var inst_127753 = cljs.core.seq(inst_127747);
var inst_127754__$1 = cljs.core.first(inst_127753);
var inst_127755 = cljs.core.next(inst_127753);
var inst_127756 = cljs.core.not(inst_127754__$1);
var state_127778__$1 = (function (){var statearr_127792 = state_127778;
(statearr_127792[(11)] = inst_127755);

(statearr_127792[(12)] = inst_127754__$1);

return statearr_127792;
})();
if(inst_127756){
var statearr_127793_127810 = state_127778__$1;
(statearr_127793_127810[(1)] = (7));

} else {
var statearr_127794_127811 = state_127778__$1;
(statearr_127794_127811[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127779 === (10))){
var inst_127754 = (state_127778[(12)]);
var state_127778__$1 = state_127778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127778__$1,(13),inst_127754);
} else {
if((state_val_127779 === (8))){
var inst_127754 = (state_127778[(12)]);
var inst_127759 = fluree.db.util.async.channel_QMARK_(inst_127754);
var state_127778__$1 = state_127778;
if(inst_127759){
var statearr_127795_127812 = state_127778__$1;
(statearr_127795_127812[(1)] = (10));

} else {
var statearr_127796_127813 = state_127778__$1;
(statearr_127796_127813[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____0 = (function (){
var statearr_127797 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_127797[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__);

(statearr_127797[(1)] = (1));

return statearr_127797;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____1 = (function (state_127778){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127778);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127798){if((e127798 instanceof Object)){
var ex__109974__auto__ = e127798;
var statearr_127799_127814 = state_127778;
(statearr_127799_127814[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127778);

return cljs.core.cst$kw$recur;
} else {
throw e127798;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127815 = state_127778;
state_127778 = G__127815;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__ = function(state_127778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____1.call(this,state_127778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127800 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127800[(6)] = c__110077__auto__);

return statearr_127800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__127816 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__127816,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__127816,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),((function (vec__127816,res,cost){
return (function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
});})(vec__127816,res,cost))
);
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127861){
var state_val_127862 = (state_127861[(1)]);
if((state_val_127862 === (7))){
var inst_127830 = (state_127861[(7)]);
var inst_127830__$1 = (state_127861[(2)]);
var inst_127831 = cljs.core.set_QMARK_(inst_127830__$1);
var state_127861__$1 = (function (){var statearr_127863 = state_127861;
(statearr_127863[(7)] = inst_127830__$1);

return statearr_127863;
})();
if(inst_127831){
var statearr_127864_127885 = state_127861__$1;
(statearr_127864_127885[(1)] = (9));

} else {
var statearr_127865_127886 = state_127861__$1;
(statearr_127865_127886[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (1))){
var state_127861__$1 = state_127861;
var statearr_127866_127887 = state_127861__$1;
(statearr_127866_127887[(2)] = null);

(statearr_127866_127887[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127861,(3),Error,null,(2));
var inst_127823 = fluree.db.util.async.channel_QMARK_(coll);
var state_127861__$1 = state_127861;
if(inst_127823){
var statearr_127867_127888 = state_127861__$1;
(statearr_127867_127888[(1)] = (5));

} else {
var statearr_127868_127889 = state_127861__$1;
(statearr_127868_127889[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (15))){
var inst_127840 = (state_127861[(2)]);
var inst_127841 = fluree.db.util.async.throw_err(inst_127840);
var state_127861__$1 = state_127861;
var statearr_127869_127890 = state_127861__$1;
(statearr_127869_127890[(2)] = inst_127841);

(statearr_127869_127890[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (13))){
var state_127861__$1 = state_127861;
var statearr_127870_127891 = state_127861__$1;
(statearr_127870_127891[(2)] = key);

(statearr_127870_127891[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (6))){
var state_127861__$1 = state_127861;
var statearr_127871_127892 = state_127861__$1;
(statearr_127871_127892[(2)] = coll);

(statearr_127871_127892[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (3))){
var inst_127819 = (state_127861[(2)]);
var state_127861__$1 = state_127861;
var statearr_127872_127893 = state_127861__$1;
(statearr_127872_127893[(2)] = inst_127819);


cljs.core.async.impl.ioc_helpers.process_exception(state_127861__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (12))){
var state_127861__$1 = state_127861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127861__$1,(15),key);
} else {
if((state_val_127862 === (2))){
var inst_127859 = (state_127861[(2)]);
var state_127861__$1 = state_127861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127861__$1,inst_127859);
} else {
if((state_val_127862 === (11))){
var inst_127836 = (state_127861[(2)]);
var inst_127837 = fluree.db.util.async.channel_QMARK_(key);
var state_127861__$1 = (function (){var statearr_127873 = state_127861;
(statearr_127873[(8)] = inst_127836);

return statearr_127873;
})();
if(inst_127837){
var statearr_127874_127894 = state_127861__$1;
(statearr_127874_127894[(1)] = (12));

} else {
var statearr_127875_127895 = state_127861__$1;
(statearr_127875_127895[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (9))){
var inst_127830 = (state_127861[(7)]);
var inst_127833 = cljs.core.vec(inst_127830);
var state_127861__$1 = state_127861;
var statearr_127876_127896 = state_127861__$1;
(statearr_127876_127896[(2)] = inst_127833);

(statearr_127876_127896[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (5))){
var state_127861__$1 = state_127861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127861__$1,(8),coll);
} else {
if((state_val_127862 === (14))){
var inst_127836 = (state_127861[(8)]);
var inst_127844 = (state_127861[(2)]);
var inst_127845 = fluree.db.dbfunctions.internal.nth(inst_127836,inst_127844);
var inst_127846 = cljs.core.count(inst_127836);
var inst_127847 = ((9) + inst_127846);
var inst_127848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127849 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_127850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127851 = [inst_127836,inst_127844];
var inst_127852 = (new cljs.core.PersistentVector(null,2,(5),inst_127850,inst_127851,null));
var inst_127853 = ["nth",inst_127852,inst_127845];
var inst_127854 = cljs.core.PersistentHashMap.fromArrays(inst_127849,inst_127853);
var inst_127855 = [inst_127854,inst_127847];
var inst_127856 = (new cljs.core.PersistentVector(null,2,(5),inst_127848,inst_127855,null));
var inst_127857 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_127856);
var state_127861__$1 = (function (){var statearr_127877 = state_127861;
(statearr_127877[(9)] = inst_127857);

return statearr_127877;
})();
var statearr_127878_127897 = state_127861__$1;
(statearr_127878_127897[(2)] = inst_127845);


cljs.core.async.impl.ioc_helpers.process_exception(state_127861__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (10))){
var inst_127830 = (state_127861[(7)]);
var state_127861__$1 = state_127861;
var statearr_127879_127898 = state_127861__$1;
(statearr_127879_127898[(2)] = inst_127830);

(statearr_127879_127898[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127862 === (8))){
var inst_127826 = (state_127861[(2)]);
var inst_127827 = fluree.db.util.async.throw_err(inst_127826);
var state_127861__$1 = state_127861;
var statearr_127880_127899 = state_127861__$1;
(statearr_127880_127899[(2)] = inst_127827);

(statearr_127880_127899[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____0 = (function (){
var statearr_127881 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127881[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__);

(statearr_127881[(1)] = (1));

return statearr_127881;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____1 = (function (state_127861){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127861);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127882){if((e127882 instanceof Object)){
var ex__109974__auto__ = e127882;
var statearr_127883_127900 = state_127861;
(statearr_127883_127900[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127861);

return cljs.core.cst$kw$recur;
} else {
throw e127882;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127901 = state_127861;
state_127861 = G__127901;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__ = function(state_127861){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____1.call(this,state_127861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127884 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127884[(6)] = c__110077__auto__);

return statearr_127884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127959){
var state_val_127960 = (state_127959[(1)]);
if((state_val_127960 === (7))){
var inst_127916 = (state_127959[(7)]);
var inst_127916__$1 = (state_127959[(2)]);
var state_127959__$1 = (function (){var statearr_127961 = state_127959;
(statearr_127961[(7)] = inst_127916__$1);

return statearr_127961;
})();
if(cljs.core.truth_(inst_127916__$1)){
var statearr_127962_127988 = state_127959__$1;
(statearr_127962_127988[(1)] = (9));

} else {
var statearr_127963_127989 = state_127959__$1;
(statearr_127963_127989[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (1))){
var state_127959__$1 = state_127959;
var statearr_127964_127990 = state_127959__$1;
(statearr_127964_127990[(2)] = null);

(statearr_127964_127990[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127959,(3),Error,null,(2));
var inst_127909 = fluree.db.util.async.channel_QMARK_(test);
var state_127959__$1 = state_127959;
if(inst_127909){
var statearr_127965_127991 = state_127959__$1;
(statearr_127965_127991[(1)] = (5));

} else {
var statearr_127966_127992 = state_127959__$1;
(statearr_127966_127992[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (15))){
var inst_127922 = (state_127959[(2)]);
var inst_127923 = fluree.db.util.async.throw_err(inst_127922);
var state_127959__$1 = state_127959;
var statearr_127967_127993 = state_127959__$1;
(statearr_127967_127993[(2)] = inst_127923);

(statearr_127967_127993[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (13))){
var state_127959__$1 = state_127959;
var statearr_127968_127994 = state_127959__$1;
(statearr_127968_127994[(2)] = t);

(statearr_127968_127994[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (6))){
var state_127959__$1 = state_127959;
var statearr_127969_127995 = state_127959__$1;
(statearr_127969_127995[(2)] = test);

(statearr_127969_127995[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (17))){
var state_127959__$1 = state_127959;
var statearr_127970_127996 = state_127959__$1;
(statearr_127970_127996[(2)] = f);

(statearr_127970_127996[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (3))){
var inst_127902 = (state_127959[(2)]);
var state_127959__$1 = state_127959;
var statearr_127971_127997 = state_127959__$1;
(statearr_127971_127997[(2)] = inst_127902);


cljs.core.async.impl.ioc_helpers.process_exception(state_127959__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (12))){
var state_127959__$1 = state_127959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127959__$1,(15),t);
} else {
if((state_val_127960 === (2))){
var inst_127957 = (state_127959[(2)]);
var state_127959__$1 = state_127959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127959__$1,inst_127957);
} else {
if((state_val_127960 === (19))){
var inst_127934 = (state_127959[(2)]);
var inst_127935 = fluree.db.util.async.throw_err(inst_127934);
var state_127959__$1 = state_127959;
var statearr_127972_127998 = state_127959__$1;
(statearr_127972_127998[(2)] = inst_127935);

(statearr_127972_127998[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (11))){
var inst_127916 = (state_127959[(7)]);
var inst_127942 = (state_127959[(2)]);
var inst_127943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127942,(0),null);
var inst_127944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127942,(1),null);
var inst_127945 = fluree.db.dbfunctions.internal.if_else(inst_127916,inst_127943,inst_127944);
var inst_127946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127947 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_127948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127949 = [inst_127916,inst_127943,inst_127944];
var inst_127950 = (new cljs.core.PersistentVector(null,3,(5),inst_127948,inst_127949,null));
var inst_127951 = ["if-else",inst_127950,inst_127945];
var inst_127952 = cljs.core.PersistentHashMap.fromArrays(inst_127947,inst_127951);
var inst_127953 = [inst_127952,(10)];
var inst_127954 = (new cljs.core.PersistentVector(null,2,(5),inst_127946,inst_127953,null));
var inst_127955 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_127954);
var state_127959__$1 = (function (){var statearr_127973 = state_127959;
(statearr_127973[(8)] = inst_127955);

return statearr_127973;
})();
var statearr_127974_127999 = state_127959__$1;
(statearr_127974_127999[(2)] = inst_127945);


cljs.core.async.impl.ioc_helpers.process_exception(state_127959__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (9))){
var inst_127918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127919 = fluree.db.util.async.channel_QMARK_(t);
var state_127959__$1 = (function (){var statearr_127975 = state_127959;
(statearr_127975[(9)] = inst_127918);

return statearr_127975;
})();
if(inst_127919){
var statearr_127976_128000 = state_127959__$1;
(statearr_127976_128000[(1)] = (12));

} else {
var statearr_127977_128001 = state_127959__$1;
(statearr_127977_128001[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (5))){
var state_127959__$1 = state_127959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127959__$1,(8),test);
} else {
if((state_val_127960 === (14))){
var inst_127918 = (state_127959[(9)]);
var inst_127926 = (state_127959[(2)]);
var inst_127927 = [inst_127926,f];
var inst_127928 = (new cljs.core.PersistentVector(null,2,(5),inst_127918,inst_127927,null));
var state_127959__$1 = state_127959;
var statearr_127978_128002 = state_127959__$1;
(statearr_127978_128002[(2)] = inst_127928);

(statearr_127978_128002[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (16))){
var state_127959__$1 = state_127959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127959__$1,(19),f);
} else {
if((state_val_127960 === (10))){
var inst_127930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127931 = fluree.db.util.async.channel_QMARK_(f);
var state_127959__$1 = (function (){var statearr_127979 = state_127959;
(statearr_127979[(10)] = inst_127930);

return statearr_127979;
})();
if(inst_127931){
var statearr_127980_128003 = state_127959__$1;
(statearr_127980_128003[(1)] = (16));

} else {
var statearr_127981_128004 = state_127959__$1;
(statearr_127981_128004[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (18))){
var inst_127930 = (state_127959[(10)]);
var inst_127938 = (state_127959[(2)]);
var inst_127939 = [f,inst_127938];
var inst_127940 = (new cljs.core.PersistentVector(null,2,(5),inst_127930,inst_127939,null));
var state_127959__$1 = state_127959;
var statearr_127982_128005 = state_127959__$1;
(statearr_127982_128005[(2)] = inst_127940);

(statearr_127982_128005[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127960 === (8))){
var inst_127912 = (state_127959[(2)]);
var inst_127913 = fluree.db.util.async.throw_err(inst_127912);
var state_127959__$1 = state_127959;
var statearr_127983_128006 = state_127959__$1;
(statearr_127983_128006[(2)] = inst_127913);

(statearr_127983_128006[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____0 = (function (){
var statearr_127984 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_127984[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__);

(statearr_127984[(1)] = (1));

return statearr_127984;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____1 = (function (state_127959){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127959);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127985){if((e127985 instanceof Object)){
var ex__109974__auto__ = e127985;
var statearr_127986_128007 = state_127959;
(statearr_127986_128007[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127959);

return cljs.core.cst$kw$recur;
} else {
throw e127985;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128008 = state_127959;
state_127959 = G__128008;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__ = function(state_127959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____1.call(this,state_127959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127987 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127987[(6)] = c__110077__auto__);

return statearr_127987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128035){
var state_val_128036 = (state_128035[(1)]);
if((state_val_128036 === (1))){
var state_128035__$1 = state_128035;
var statearr_128037_128049 = state_128035__$1;
(statearr_128037_128049[(2)] = null);

(statearr_128037_128049[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128036 === (2))){
var inst_128033 = (state_128035[(2)]);
var state_128035__$1 = state_128035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128035__$1,inst_128033);
} else {
if((state_val_128036 === (3))){
var inst_128009 = (state_128035[(2)]);
var state_128035__$1 = state_128035;
var statearr_128038_128050 = state_128035__$1;
(statearr_128038_128050[(2)] = inst_128009);


cljs.core.async.impl.ioc_helpers.process_exception(state_128035__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128036 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128035,(3),Error,null,(2));
var inst_128013 = fluree.db.util.async.channel_QMARK_(arg);
var state_128035__$1 = state_128035;
if(inst_128013){
var statearr_128039_128051 = state_128035__$1;
(statearr_128039_128051[(1)] = (5));

} else {
var statearr_128040_128052 = state_128035__$1;
(statearr_128040_128052[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128036 === (5))){
var state_128035__$1 = state_128035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128035__$1,(8),arg);
} else {
if((state_val_128036 === (6))){
var state_128035__$1 = state_128035;
var statearr_128041_128053 = state_128035__$1;
(statearr_128041_128053[(2)] = arg);

(statearr_128041_128053[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128036 === (7))){
var inst_128020 = (state_128035[(2)]);
var inst_128021 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_128020);
var inst_128022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128023 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128025 = [inst_128020];
var inst_128026 = (new cljs.core.PersistentVector(null,1,(5),inst_128024,inst_128025,null));
var inst_128027 = ["nil?",inst_128026,inst_128021];
var inst_128028 = cljs.core.PersistentHashMap.fromArrays(inst_128023,inst_128027);
var inst_128029 = [inst_128028,(10)];
var inst_128030 = (new cljs.core.PersistentVector(null,2,(5),inst_128022,inst_128029,null));
var inst_128031 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128030);
var state_128035__$1 = (function (){var statearr_128042 = state_128035;
(statearr_128042[(7)] = inst_128031);

return statearr_128042;
})();
var statearr_128043_128054 = state_128035__$1;
(statearr_128043_128054[(2)] = inst_128021);


cljs.core.async.impl.ioc_helpers.process_exception(state_128035__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128036 === (8))){
var inst_128016 = (state_128035[(2)]);
var inst_128017 = fluree.db.util.async.throw_err(inst_128016);
var state_128035__$1 = state_128035;
var statearr_128044_128055 = state_128035__$1;
(statearr_128044_128055[(2)] = inst_128017);

(statearr_128044_128055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_128045 = [null,null,null,null,null,null,null,null];
(statearr_128045[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__);

(statearr_128045[(1)] = (1));

return statearr_128045;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____1 = (function (state_128035){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128035);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128046){if((e128046 instanceof Object)){
var ex__109974__auto__ = e128046;
var statearr_128047_128056 = state_128035;
(statearr_128047_128056[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128035);

return cljs.core.cst$kw$recur;
} else {
throw e128046;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128057 = state_128035;
state_128035 = G__128057;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__ = function(state_128035){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____1.call(this,state_128035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128048 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128048[(6)] = c__110077__auto__);

return statearr_128048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128084){
var state_val_128085 = (state_128084[(1)]);
if((state_val_128085 === (1))){
var state_128084__$1 = state_128084;
var statearr_128086_128098 = state_128084__$1;
(statearr_128086_128098[(2)] = null);

(statearr_128086_128098[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128085 === (2))){
var inst_128082 = (state_128084[(2)]);
var state_128084__$1 = state_128084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128084__$1,inst_128082);
} else {
if((state_val_128085 === (3))){
var inst_128058 = (state_128084[(2)]);
var state_128084__$1 = state_128084;
var statearr_128087_128099 = state_128084__$1;
(statearr_128087_128099[(2)] = inst_128058);


cljs.core.async.impl.ioc_helpers.process_exception(state_128084__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128085 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128084,(3),Error,null,(2));
var inst_128062 = fluree.db.util.async.channel_QMARK_(arg);
var state_128084__$1 = state_128084;
if(inst_128062){
var statearr_128088_128100 = state_128084__$1;
(statearr_128088_128100[(1)] = (5));

} else {
var statearr_128089_128101 = state_128084__$1;
(statearr_128089_128101[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128085 === (5))){
var state_128084__$1 = state_128084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128084__$1,(8),arg);
} else {
if((state_val_128085 === (6))){
var state_128084__$1 = state_128084;
var statearr_128090_128102 = state_128084__$1;
(statearr_128090_128102[(2)] = arg);

(statearr_128090_128102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128085 === (7))){
var inst_128069 = (state_128084[(2)]);
var inst_128070 = fluree.db.dbfunctions.internal.not(inst_128069);
var inst_128071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128072 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128074 = [inst_128069];
var inst_128075 = (new cljs.core.PersistentVector(null,1,(5),inst_128073,inst_128074,null));
var inst_128076 = ["not?",inst_128075,inst_128070];
var inst_128077 = cljs.core.PersistentHashMap.fromArrays(inst_128072,inst_128076);
var inst_128078 = [inst_128077,(10)];
var inst_128079 = (new cljs.core.PersistentVector(null,2,(5),inst_128071,inst_128078,null));
var inst_128080 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128079);
var state_128084__$1 = (function (){var statearr_128091 = state_128084;
(statearr_128091[(7)] = inst_128080);

return statearr_128091;
})();
var statearr_128092_128103 = state_128084__$1;
(statearr_128092_128103[(2)] = inst_128070);


cljs.core.async.impl.ioc_helpers.process_exception(state_128084__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128085 === (8))){
var inst_128065 = (state_128084[(2)]);
var inst_128066 = fluree.db.util.async.throw_err(inst_128065);
var state_128084__$1 = state_128084;
var statearr_128093_128104 = state_128084__$1;
(statearr_128093_128104[(2)] = inst_128066);

(statearr_128093_128104[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____0 = (function (){
var statearr_128094 = [null,null,null,null,null,null,null,null];
(statearr_128094[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__);

(statearr_128094[(1)] = (1));

return statearr_128094;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____1 = (function (state_128084){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128084);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128095){if((e128095 instanceof Object)){
var ex__109974__auto__ = e128095;
var statearr_128096_128105 = state_128084;
(statearr_128096_128105[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128084);

return cljs.core.cst$kw$recur;
} else {
throw e128095;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128106 = state_128084;
state_128084 = G__128106;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__ = function(state_128084){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____1.call(this,state_128084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128097 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128097[(6)] = c__110077__auto__);

return statearr_128097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128133){
var state_val_128134 = (state_128133[(1)]);
if((state_val_128134 === (1))){
var state_128133__$1 = state_128133;
var statearr_128135_128147 = state_128133__$1;
(statearr_128135_128147[(2)] = null);

(statearr_128135_128147[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128134 === (2))){
var inst_128131 = (state_128133[(2)]);
var state_128133__$1 = state_128133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128133__$1,inst_128131);
} else {
if((state_val_128134 === (3))){
var inst_128107 = (state_128133[(2)]);
var state_128133__$1 = state_128133;
var statearr_128136_128148 = state_128133__$1;
(statearr_128136_128148[(2)] = inst_128107);


cljs.core.async.impl.ioc_helpers.process_exception(state_128133__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128134 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128133,(3),Error,null,(2));
var inst_128111 = fluree.db.util.async.channel_QMARK_(arg);
var state_128133__$1 = state_128133;
if(inst_128111){
var statearr_128137_128149 = state_128133__$1;
(statearr_128137_128149[(1)] = (5));

} else {
var statearr_128138_128150 = state_128133__$1;
(statearr_128138_128150[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128134 === (5))){
var state_128133__$1 = state_128133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128133__$1,(8),arg);
} else {
if((state_val_128134 === (6))){
var state_128133__$1 = state_128133;
var statearr_128139_128151 = state_128133__$1;
(statearr_128139_128151[(2)] = arg);

(statearr_128139_128151[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128134 === (7))){
var inst_128118 = (state_128133[(2)]);
var inst_128119 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_128118);
var inst_128120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128121 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128123 = [inst_128118];
var inst_128124 = (new cljs.core.PersistentVector(null,1,(5),inst_128122,inst_128123,null));
var inst_128125 = ["empty?",inst_128124,inst_128119];
var inst_128126 = cljs.core.PersistentHashMap.fromArrays(inst_128121,inst_128125);
var inst_128127 = [inst_128126,(10)];
var inst_128128 = (new cljs.core.PersistentVector(null,2,(5),inst_128120,inst_128127,null));
var inst_128129 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128128);
var state_128133__$1 = (function (){var statearr_128140 = state_128133;
(statearr_128140[(7)] = inst_128129);

return statearr_128140;
})();
var statearr_128141_128152 = state_128133__$1;
(statearr_128141_128152[(2)] = inst_128119);


cljs.core.async.impl.ioc_helpers.process_exception(state_128133__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128134 === (8))){
var inst_128114 = (state_128133[(2)]);
var inst_128115 = fluree.db.util.async.throw_err(inst_128114);
var state_128133__$1 = state_128133;
var statearr_128142_128153 = state_128133__$1;
(statearr_128142_128153[(2)] = inst_128115);

(statearr_128142_128153[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_128143 = [null,null,null,null,null,null,null,null];
(statearr_128143[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__);

(statearr_128143[(1)] = (1));

return statearr_128143;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____1 = (function (state_128133){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128133);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128144){if((e128144 instanceof Object)){
var ex__109974__auto__ = e128144;
var statearr_128145_128154 = state_128133;
(statearr_128145_128154[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128133);

return cljs.core.cst$kw$recur;
} else {
throw e128144;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128155 = state_128133;
state_128133 = G__128155;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__ = function(state_128133){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____1.call(this,state_128133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128146 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128146[(6)] = c__110077__auto__);

return statearr_128146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4736__auto__ = [];
var len__4730__auto___128190 = arguments.length;
var i__4731__auto___128191 = (0);
while(true){
if((i__4731__auto___128191 < len__4730__auto___128190)){
args__4736__auto__.push((arguments[i__4731__auto___128191]));

var G__128192 = (i__4731__auto___128191 + (1));
i__4731__auto___128191 = G__128192;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128180){
var state_val_128181 = (state_128180[(1)]);
if((state_val_128181 === (1))){
var state_128180__$1 = state_128180;
var statearr_128182_128193 = state_128180__$1;
(statearr_128182_128193[(2)] = null);

(statearr_128182_128193[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128181 === (2))){
var inst_128178 = (state_128180[(2)]);
var state_128180__$1 = state_128180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128180__$1,inst_128178);
} else {
if((state_val_128181 === (3))){
var inst_128158 = (state_128180[(2)]);
var state_128180__$1 = state_128180;
var statearr_128183_128194 = state_128180__$1;
(statearr_128183_128194[(2)] = inst_128158);


cljs.core.async.impl.ioc_helpers.process_exception(state_128180__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128181 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128180,(3),Error,null,(2));
var inst_128162 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_128180__$1 = state_128180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128180__$1,(5),inst_128162);
} else {
if((state_val_128181 === (5))){
var inst_128164 = (state_128180[(2)]);
var inst_128165 = fluree.db.util.async.throw_err(inst_128164);
var inst_128166 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_128165);
var inst_128167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128168 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128170 = [inst_128165];
var inst_128171 = (new cljs.core.PersistentVector(null,1,(5),inst_128169,inst_128170,null));
var inst_128172 = ["str",inst_128171,inst_128166];
var inst_128173 = cljs.core.PersistentHashMap.fromArrays(inst_128168,inst_128172);
var inst_128174 = [inst_128173,(10)];
var inst_128175 = (new cljs.core.PersistentVector(null,2,(5),inst_128167,inst_128174,null));
var inst_128176 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128175);
var state_128180__$1 = (function (){var statearr_128184 = state_128180;
(statearr_128184[(7)] = inst_128176);

return statearr_128184;
})();
var statearr_128185_128195 = state_128180__$1;
(statearr_128185_128195[(2)] = inst_128166);


cljs.core.async.impl.ioc_helpers.process_exception(state_128180__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_128186 = [null,null,null,null,null,null,null,null];
(statearr_128186[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_128186[(1)] = (1));

return statearr_128186;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_128180){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128180);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128187){if((e128187 instanceof Object)){
var ex__109974__auto__ = e128187;
var statearr_128188_128196 = state_128180;
(statearr_128188_128196[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128180);

return cljs.core.cst$kw$recur;
} else {
throw e128187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128197 = state_128180;
state_128180 = G__128197;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_128180){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_128180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128189 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128189[(6)] = c__110077__auto__);

return statearr_128189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq128156){
var G__128157 = cljs.core.first(seq128156);
var seq128156__$1 = cljs.core.next(seq128156);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128157,seq128156__$1);
});

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128224){
var state_val_128225 = (state_128224[(1)]);
if((state_val_128225 === (1))){
var state_128224__$1 = state_128224;
var statearr_128226_128238 = state_128224__$1;
(statearr_128226_128238[(2)] = null);

(statearr_128226_128238[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128225 === (2))){
var inst_128222 = (state_128224[(2)]);
var state_128224__$1 = state_128224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128224__$1,inst_128222);
} else {
if((state_val_128225 === (3))){
var inst_128198 = (state_128224[(2)]);
var state_128224__$1 = state_128224;
var statearr_128227_128239 = state_128224__$1;
(statearr_128227_128239[(2)] = inst_128198);


cljs.core.async.impl.ioc_helpers.process_exception(state_128224__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128225 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128224,(3),Error,null,(2));
var inst_128202 = fluree.db.util.async.channel_QMARK_(str);
var state_128224__$1 = state_128224;
if(inst_128202){
var statearr_128228_128240 = state_128224__$1;
(statearr_128228_128240[(1)] = (5));

} else {
var statearr_128229_128241 = state_128224__$1;
(statearr_128229_128241[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128225 === (5))){
var state_128224__$1 = state_128224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128224__$1,(8),str);
} else {
if((state_val_128225 === (6))){
var state_128224__$1 = state_128224;
var statearr_128230_128242 = state_128224__$1;
(statearr_128230_128242[(2)] = str);

(statearr_128230_128242[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128225 === (7))){
var inst_128209 = (state_128224[(2)]);
var inst_128210 = fluree.db.dbfunctions.internal.lower_case(inst_128209);
var inst_128211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128212 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128214 = [inst_128209];
var inst_128215 = (new cljs.core.PersistentVector(null,1,(5),inst_128213,inst_128214,null));
var inst_128216 = ["lower-case",inst_128215,inst_128210];
var inst_128217 = cljs.core.PersistentHashMap.fromArrays(inst_128212,inst_128216);
var inst_128218 = [inst_128217,(10)];
var inst_128219 = (new cljs.core.PersistentVector(null,2,(5),inst_128211,inst_128218,null));
var inst_128220 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128219);
var state_128224__$1 = (function (){var statearr_128231 = state_128224;
(statearr_128231[(7)] = inst_128220);

return statearr_128231;
})();
var statearr_128232_128243 = state_128224__$1;
(statearr_128232_128243[(2)] = inst_128210);


cljs.core.async.impl.ioc_helpers.process_exception(state_128224__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128225 === (8))){
var inst_128205 = (state_128224[(2)]);
var inst_128206 = fluree.db.util.async.throw_err(inst_128205);
var state_128224__$1 = state_128224;
var statearr_128233_128244 = state_128224__$1;
(statearr_128233_128244[(2)] = inst_128206);

(statearr_128233_128244[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____0 = (function (){
var statearr_128234 = [null,null,null,null,null,null,null,null];
(statearr_128234[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__);

(statearr_128234[(1)] = (1));

return statearr_128234;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____1 = (function (state_128224){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128224);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128235){if((e128235 instanceof Object)){
var ex__109974__auto__ = e128235;
var statearr_128236_128245 = state_128224;
(statearr_128236_128245[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128224);

return cljs.core.cst$kw$recur;
} else {
throw e128235;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128246 = state_128224;
state_128224 = G__128246;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__ = function(state_128224){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____1.call(this,state_128224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128237 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128237[(6)] = c__110077__auto__);

return statearr_128237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128273){
var state_val_128274 = (state_128273[(1)]);
if((state_val_128274 === (1))){
var state_128273__$1 = state_128273;
var statearr_128275_128287 = state_128273__$1;
(statearr_128275_128287[(2)] = null);

(statearr_128275_128287[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128274 === (2))){
var inst_128271 = (state_128273[(2)]);
var state_128273__$1 = state_128273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128273__$1,inst_128271);
} else {
if((state_val_128274 === (3))){
var inst_128247 = (state_128273[(2)]);
var state_128273__$1 = state_128273;
var statearr_128276_128288 = state_128273__$1;
(statearr_128276_128288[(2)] = inst_128247);


cljs.core.async.impl.ioc_helpers.process_exception(state_128273__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128274 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128273,(3),Error,null,(2));
var inst_128251 = fluree.db.util.async.channel_QMARK_(str);
var state_128273__$1 = state_128273;
if(inst_128251){
var statearr_128277_128289 = state_128273__$1;
(statearr_128277_128289[(1)] = (5));

} else {
var statearr_128278_128290 = state_128273__$1;
(statearr_128278_128290[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128274 === (5))){
var state_128273__$1 = state_128273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128273__$1,(8),str);
} else {
if((state_val_128274 === (6))){
var state_128273__$1 = state_128273;
var statearr_128279_128291 = state_128273__$1;
(statearr_128279_128291[(2)] = str);

(statearr_128279_128291[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128274 === (7))){
var inst_128258 = (state_128273[(2)]);
var inst_128259 = fluree.db.dbfunctions.internal.upper_case(inst_128258);
var inst_128260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128261 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128263 = [inst_128258];
var inst_128264 = (new cljs.core.PersistentVector(null,1,(5),inst_128262,inst_128263,null));
var inst_128265 = ["upper-case",inst_128264,inst_128259];
var inst_128266 = cljs.core.PersistentHashMap.fromArrays(inst_128261,inst_128265);
var inst_128267 = [inst_128266,(10)];
var inst_128268 = (new cljs.core.PersistentVector(null,2,(5),inst_128260,inst_128267,null));
var inst_128269 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128268);
var state_128273__$1 = (function (){var statearr_128280 = state_128273;
(statearr_128280[(7)] = inst_128269);

return statearr_128280;
})();
var statearr_128281_128292 = state_128273__$1;
(statearr_128281_128292[(2)] = inst_128259);


cljs.core.async.impl.ioc_helpers.process_exception(state_128273__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128274 === (8))){
var inst_128254 = (state_128273[(2)]);
var inst_128255 = fluree.db.util.async.throw_err(inst_128254);
var state_128273__$1 = state_128273;
var statearr_128282_128293 = state_128273__$1;
(statearr_128282_128293[(2)] = inst_128255);

(statearr_128282_128293[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____0 = (function (){
var statearr_128283 = [null,null,null,null,null,null,null,null];
(statearr_128283[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__);

(statearr_128283[(1)] = (1));

return statearr_128283;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____1 = (function (state_128273){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128273);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128284){if((e128284 instanceof Object)){
var ex__109974__auto__ = e128284;
var statearr_128285_128294 = state_128273;
(statearr_128285_128294[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128273);

return cljs.core.cst$kw$recur;
} else {
throw e128284;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128295 = state_128273;
state_128273 = G__128295;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__ = function(state_128273){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____1.call(this,state_128273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128286 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128286[(6)] = c__110077__auto__);

return statearr_128286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4120__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4120__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__128297 = arguments.length;
switch (G__128297) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128322){
var state_val_128323 = (state_128322[(1)]);
if((state_val_128323 === (1))){
var state_128322__$1 = state_128322;
var statearr_128324_128333 = state_128322__$1;
(statearr_128324_128333[(2)] = null);

(statearr_128324_128333[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128323 === (2))){
var inst_128320 = (state_128322[(2)]);
var state_128322__$1 = state_128322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128322__$1,inst_128320);
} else {
if((state_val_128323 === (3))){
var inst_128298 = (state_128322[(2)]);
var state_128322__$1 = state_128322;
var statearr_128325_128334 = state_128322__$1;
(statearr_128325_128334[(2)] = inst_128298);


cljs.core.async.impl.ioc_helpers.process_exception(state_128322__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128323 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128322,(3),Error,null,(2));
var inst_128305 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_128322__$1 = state_128322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128322__$1,(5),inst_128305);
} else {
if((state_val_128323 === (5))){
var inst_128307 = (state_128322[(2)]);
var inst_128308 = fluree.db.util.async.throw_err(inst_128307);
var inst_128309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128308,(0),null);
var inst_128310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128308,(1),null);
var inst_128311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128312 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128313 = ["?s","?ctx",inst_128309];
var inst_128314 = cljs.core.PersistentHashMap.fromArrays(inst_128312,inst_128313);
var inst_128315 = ((10) + inst_128310);
var inst_128316 = [inst_128314,inst_128315];
var inst_128317 = (new cljs.core.PersistentVector(null,2,(5),inst_128311,inst_128316,null));
var inst_128318 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128317);
var state_128322__$1 = (function (){var statearr_128326 = state_128322;
(statearr_128326[(7)] = inst_128318);

return statearr_128326;
})();
var statearr_128327_128335 = state_128322__$1;
(statearr_128327_128335[(2)] = inst_128309);


cljs.core.async.impl.ioc_helpers.process_exception(state_128322__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_128328 = [null,null,null,null,null,null,null,null];
(statearr_128328[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_128328[(1)] = (1));

return statearr_128328;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_128322){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128322);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128329){if((e128329 instanceof Object)){
var ex__109974__auto__ = e128329;
var statearr_128330_128336 = state_128322;
(statearr_128330_128336[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128322);

return cljs.core.cst$kw$recur;
} else {
throw e128329;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128337 = state_128322;
state_128322 = G__128337;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_128322){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_128322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128331 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128331[(6)] = c__110077__auto__);

return statearr_128331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2;

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__128339 = arguments.length;
switch (G__128339) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128374){
var state_val_128375 = (state_128374[(1)]);
if((state_val_128375 === (7))){
var inst_128370 = (state_128374[(2)]);
var state_128374__$1 = state_128374;
var statearr_128376_128389 = state_128374__$1;
(statearr_128376_128389[(2)] = inst_128370);


cljs.core.async.impl.ioc_helpers.process_exception(state_128374__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128375 === (1))){
var state_128374__$1 = state_128374;
var statearr_128377_128390 = state_128374__$1;
(statearr_128377_128390[(2)] = null);

(statearr_128377_128390[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128375 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128374,(3),Error,null,(2));
var inst_128344 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128374__$1 = state_128374;
if(cljs.core.truth_(inst_128344)){
var statearr_128378_128391 = state_128374__$1;
(statearr_128378_128391[(1)] = (5));

} else {
var statearr_128379_128392 = state_128374__$1;
(statearr_128379_128392[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128375 === (6))){
var inst_128368 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_128374__$1 = state_128374;
var statearr_128380_128393 = state_128374__$1;
(statearr_128380_128393[(2)] = inst_128368);

(statearr_128380_128393[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128375 === (3))){
var inst_128340 = (state_128374[(2)]);
var state_128374__$1 = state_128374;
var statearr_128381_128394 = state_128374__$1;
(statearr_128381_128394[(2)] = inst_128340);


cljs.core.async.impl.ioc_helpers.process_exception(state_128374__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128375 === (2))){
var inst_128372 = (state_128374[(2)]);
var state_128374__$1 = state_128374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128374__$1,inst_128372);
} else {
if((state_val_128375 === (9))){
var inst_128351 = (state_128374[(2)]);
var inst_128352 = fluree.db.util.async.throw_err(inst_128351);
var inst_128353 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_128352);
var state_128374__$1 = state_128374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128374__$1,(8),inst_128353);
} else {
if((state_val_128375 === (5))){
var inst_128349 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_128374__$1 = state_128374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128374__$1,(9),inst_128349);
} else {
if((state_val_128375 === (8))){
var inst_128355 = (state_128374[(2)]);
var inst_128356 = fluree.db.util.async.throw_err(inst_128355);
var inst_128357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128356,(0),null);
var inst_128358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128356,(1),null);
var inst_128359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128360 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128361 = ["?p","?ctx",inst_128357];
var inst_128362 = cljs.core.PersistentHashMap.fromArrays(inst_128360,inst_128361);
var inst_128363 = ((10) + inst_128358);
var inst_128364 = [inst_128362,inst_128363];
var inst_128365 = (new cljs.core.PersistentVector(null,2,(5),inst_128359,inst_128364,null));
var inst_128366 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128365);
var state_128374__$1 = (function (){var statearr_128382 = state_128374;
(statearr_128382[(7)] = inst_128366);

return statearr_128382;
})();
var statearr_128383_128395 = state_128374__$1;
(statearr_128383_128395[(2)] = inst_128357);

(statearr_128383_128395[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_128384 = [null,null,null,null,null,null,null,null];
(statearr_128384[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_128384[(1)] = (1));

return statearr_128384;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_128374){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128374);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128385){if((e128385 instanceof Object)){
var ex__109974__auto__ = e128385;
var statearr_128386_128396 = state_128374;
(statearr_128386_128396[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128374);

return cljs.core.cst$kw$recur;
} else {
throw e128385;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128397 = state_128374;
state_128374 = G__128397;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_128374){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_128374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128387 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128387[(6)] = c__110077__auto__);

return statearr_128387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2;

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4736__auto__ = [];
var len__4730__auto___128436 = arguments.length;
var i__4731__auto___128437 = (0);
while(true){
if((i__4731__auto___128437 < len__4730__auto___128436)){
args__4736__auto__.push((arguments[i__4731__auto___128437]));

var G__128438 = (i__4731__auto___128437 + (1));
i__4731__auto___128437 = G__128438;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128426){
var state_val_128427 = (state_128426[(1)]);
if((state_val_128427 === (1))){
var state_128426__$1 = state_128426;
var statearr_128428_128439 = state_128426__$1;
(statearr_128428_128439[(2)] = null);

(statearr_128428_128439[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128427 === (2))){
var inst_128424 = (state_128426[(2)]);
var state_128426__$1 = state_128426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128426__$1,inst_128424);
} else {
if((state_val_128427 === (3))){
var inst_128400 = (state_128426[(2)]);
var state_128426__$1 = state_128426;
var statearr_128429_128440 = state_128426__$1;
(statearr_128429_128440[(2)] = inst_128400);


cljs.core.async.impl.ioc_helpers.process_exception(state_128426__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128427 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128426,(3),Error,null,(2));
var inst_128404 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_128426__$1 = state_128426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128426__$1,(5),inst_128404);
} else {
if((state_val_128427 === (5))){
var inst_128406 = (state_128426[(2)]);
var inst_128407 = fluree.db.util.async.throw_err(inst_128406);
var inst_128408 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_128407);
var inst_128409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128410 = [inst_128407];
var inst_128411 = (new cljs.core.PersistentVector(null,1,(5),inst_128409,inst_128410,null));
var inst_128412 = cljs.core.count(inst_128411);
var inst_128413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128414 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128416 = [inst_128407];
var inst_128417 = (new cljs.core.PersistentVector(null,1,(5),inst_128415,inst_128416,null));
var inst_128418 = ["and",inst_128417,inst_128408];
var inst_128419 = cljs.core.PersistentHashMap.fromArrays(inst_128414,inst_128418);
var inst_128420 = [inst_128419,inst_128412];
var inst_128421 = (new cljs.core.PersistentVector(null,2,(5),inst_128413,inst_128420,null));
var inst_128422 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128421);
var state_128426__$1 = (function (){var statearr_128430 = state_128426;
(statearr_128430[(7)] = inst_128422);

return statearr_128430;
})();
var statearr_128431_128441 = state_128426__$1;
(statearr_128431_128441[(2)] = inst_128408);


cljs.core.async.impl.ioc_helpers.process_exception(state_128426__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_128432 = [null,null,null,null,null,null,null,null];
(statearr_128432[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_128432[(1)] = (1));

return statearr_128432;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_128426){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128426);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128433){if((e128433 instanceof Object)){
var ex__109974__auto__ = e128433;
var statearr_128434_128442 = state_128426;
(statearr_128434_128442[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128426);

return cljs.core.cst$kw$recur;
} else {
throw e128433;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128443 = state_128426;
state_128426 = G__128443;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_128426){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_128426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128435 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128435[(6)] = c__110077__auto__);

return statearr_128435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq128398){
var G__128399 = cljs.core.first(seq128398);
var seq128398__$1 = cljs.core.next(seq128398);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128399,seq128398__$1);
});

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4736__auto__ = [];
var len__4730__auto___128482 = arguments.length;
var i__4731__auto___128483 = (0);
while(true){
if((i__4731__auto___128483 < len__4730__auto___128482)){
args__4736__auto__.push((arguments[i__4731__auto___128483]));

var G__128484 = (i__4731__auto___128483 + (1));
i__4731__auto___128483 = G__128484;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128472){
var state_val_128473 = (state_128472[(1)]);
if((state_val_128473 === (1))){
var state_128472__$1 = state_128472;
var statearr_128474_128485 = state_128472__$1;
(statearr_128474_128485[(2)] = null);

(statearr_128474_128485[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128473 === (2))){
var inst_128470 = (state_128472[(2)]);
var state_128472__$1 = state_128472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128472__$1,inst_128470);
} else {
if((state_val_128473 === (3))){
var inst_128446 = (state_128472[(2)]);
var state_128472__$1 = state_128472;
var statearr_128475_128486 = state_128472__$1;
(statearr_128475_128486[(2)] = inst_128446);


cljs.core.async.impl.ioc_helpers.process_exception(state_128472__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128473 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128472,(3),Error,null,(2));
var inst_128450 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_128472__$1 = state_128472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128472__$1,(5),inst_128450);
} else {
if((state_val_128473 === (5))){
var inst_128452 = (state_128472[(2)]);
var inst_128453 = fluree.db.util.async.throw_err(inst_128452);
var inst_128454 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_128453);
var inst_128455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128456 = [inst_128453];
var inst_128457 = (new cljs.core.PersistentVector(null,1,(5),inst_128455,inst_128456,null));
var inst_128458 = cljs.core.count(inst_128457);
var inst_128459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128460 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128462 = [inst_128453];
var inst_128463 = (new cljs.core.PersistentVector(null,1,(5),inst_128461,inst_128462,null));
var inst_128464 = ["or",inst_128463,inst_128454];
var inst_128465 = cljs.core.PersistentHashMap.fromArrays(inst_128460,inst_128464);
var inst_128466 = [inst_128465,inst_128458];
var inst_128467 = (new cljs.core.PersistentVector(null,2,(5),inst_128459,inst_128466,null));
var inst_128468 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128467);
var state_128472__$1 = (function (){var statearr_128476 = state_128472;
(statearr_128476[(7)] = inst_128468);

return statearr_128476;
})();
var statearr_128477_128487 = state_128472__$1;
(statearr_128477_128487[(2)] = inst_128454);


cljs.core.async.impl.ioc_helpers.process_exception(state_128472__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_128478 = [null,null,null,null,null,null,null,null];
(statearr_128478[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_128478[(1)] = (1));

return statearr_128478;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_128472){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128472);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128479){if((e128479 instanceof Object)){
var ex__109974__auto__ = e128479;
var statearr_128480_128488 = state_128472;
(statearr_128480_128488[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128472);

return cljs.core.cst$kw$recur;
} else {
throw e128479;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128489 = state_128472;
state_128472 = G__128489;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_128472){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_128472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128481 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128481[(6)] = c__110077__auto__);

return statearr_128481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq128444){
var G__128445 = cljs.core.first(seq128444);
var seq128444__$1 = cljs.core.next(seq128444);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128445,seq128444__$1);
});

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128524){
var state_val_128525 = (state_128524[(1)]);
if((state_val_128525 === (7))){
var inst_128510 = (state_128524[(2)]);
var inst_128511 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_128510);
var inst_128512 = cljs.core.count(inst_128511);
var inst_128513 = ((9) + inst_128512);
var inst_128514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128515 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128516 = ["count",inst_128510,inst_128512];
var inst_128517 = cljs.core.PersistentHashMap.fromArrays(inst_128515,inst_128516);
var inst_128518 = [inst_128517,inst_128513];
var inst_128519 = (new cljs.core.PersistentVector(null,2,(5),inst_128514,inst_128518,null));
var inst_128520 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128519);
var state_128524__$1 = (function (){var statearr_128526 = state_128524;
(statearr_128526[(7)] = inst_128520);

return statearr_128526;
})();
var statearr_128527_128542 = state_128524__$1;
(statearr_128527_128542[(2)] = inst_128512);


cljs.core.async.impl.ioc_helpers.process_exception(state_128524__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (1))){
var state_128524__$1 = state_128524;
var statearr_128528_128543 = state_128524__$1;
(statearr_128528_128543[(2)] = null);

(statearr_128528_128543[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128524,(3),Error,null,(2));
var inst_128494 = cljs.core.vector_QMARK_(coll);
var state_128524__$1 = state_128524;
if(inst_128494){
var statearr_128529_128544 = state_128524__$1;
(statearr_128529_128544[(1)] = (5));

} else {
var statearr_128530_128545 = state_128524__$1;
(statearr_128530_128545[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (6))){
var inst_128501 = fluree.db.util.async.channel_QMARK_(coll);
var state_128524__$1 = state_128524;
if(inst_128501){
var statearr_128531_128546 = state_128524__$1;
(statearr_128531_128546[(1)] = (9));

} else {
var statearr_128532_128547 = state_128524__$1;
(statearr_128532_128547[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (3))){
var inst_128490 = (state_128524[(2)]);
var state_128524__$1 = state_128524;
var statearr_128533_128548 = state_128524__$1;
(statearr_128533_128548[(2)] = inst_128490);


cljs.core.async.impl.ioc_helpers.process_exception(state_128524__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (12))){
var inst_128504 = (state_128524[(2)]);
var inst_128505 = fluree.db.util.async.throw_err(inst_128504);
var state_128524__$1 = state_128524;
var statearr_128534_128549 = state_128524__$1;
(statearr_128534_128549[(2)] = inst_128505);

(statearr_128534_128549[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (2))){
var inst_128522 = (state_128524[(2)]);
var state_128524__$1 = state_128524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128524__$1,inst_128522);
} else {
if((state_val_128525 === (11))){
var inst_128508 = (state_128524[(2)]);
var state_128524__$1 = state_128524;
var statearr_128535_128550 = state_128524__$1;
(statearr_128535_128550[(2)] = inst_128508);

(statearr_128535_128550[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (9))){
var state_128524__$1 = state_128524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128524__$1,(12),coll);
} else {
if((state_val_128525 === (5))){
var inst_128496 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_128524__$1 = state_128524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128524__$1,(8),inst_128496);
} else {
if((state_val_128525 === (10))){
var state_128524__$1 = state_128524;
var statearr_128536_128551 = state_128524__$1;
(statearr_128536_128551[(2)] = coll);

(statearr_128536_128551[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128525 === (8))){
var inst_128498 = (state_128524[(2)]);
var inst_128499 = fluree.db.util.async.throw_err(inst_128498);
var state_128524__$1 = state_128524;
var statearr_128537_128552 = state_128524__$1;
(statearr_128537_128552[(2)] = inst_128499);

(statearr_128537_128552[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____0 = (function (){
var statearr_128538 = [null,null,null,null,null,null,null,null];
(statearr_128538[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__);

(statearr_128538[(1)] = (1));

return statearr_128538;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____1 = (function (state_128524){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128524);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128539){if((e128539 instanceof Object)){
var ex__109974__auto__ = e128539;
var statearr_128540_128553 = state_128524;
(statearr_128540_128553[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128524);

return cljs.core.cst$kw$recur;
} else {
throw e128539;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128554 = state_128524;
state_128524 = G__128554;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__ = function(state_128524){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____1.call(this,state_128524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128541 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128541[(6)] = c__110077__auto__);

return statearr_128541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128601){
var state_val_128602 = (state_128601[(1)]);
if((state_val_128602 === (7))){
var inst_128566 = (state_128601[(2)]);
var inst_128567 = fluree.db.util.async.channel_QMARK_(pred);
var state_128601__$1 = (function (){var statearr_128603 = state_128601;
(statearr_128603[(7)] = inst_128566);

return statearr_128603;
})();
if(inst_128567){
var statearr_128604_128629 = state_128601__$1;
(statearr_128604_128629[(1)] = (9));

} else {
var statearr_128605_128630 = state_128601__$1;
(statearr_128605_128630[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (1))){
var state_128601__$1 = state_128601;
var statearr_128606_128631 = state_128601__$1;
(statearr_128606_128631[(2)] = null);

(statearr_128606_128631[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128601,(3),Error,null,(2));
var inst_128559 = fluree.db.util.async.channel_QMARK_(subject);
var state_128601__$1 = state_128601;
if(inst_128559){
var statearr_128607_128632 = state_128601__$1;
(statearr_128607_128632[(1)] = (5));

} else {
var statearr_128608_128633 = state_128601__$1;
(statearr_128608_128633[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (15))){
var inst_128566 = (state_128601[(7)]);
var inst_128574 = (state_128601[(8)]);
var inst_128586 = (state_128601[(2)]);
var inst_128587 = fluree.db.dbfunctions.internal.get(inst_128586,inst_128574);
var inst_128588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128589 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128591 = [inst_128566,inst_128574];
var inst_128592 = (new cljs.core.PersistentVector(null,2,(5),inst_128590,inst_128591,null));
var inst_128593 = ["get",inst_128592,inst_128587];
var inst_128594 = cljs.core.PersistentHashMap.fromArrays(inst_128589,inst_128593);
var inst_128595 = [inst_128594,(10)];
var inst_128596 = (new cljs.core.PersistentVector(null,2,(5),inst_128588,inst_128595,null));
var inst_128597 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128596);
var state_128601__$1 = (function (){var statearr_128609 = state_128601;
(statearr_128609[(9)] = inst_128597);

return statearr_128609;
})();
var statearr_128610_128634 = state_128601__$1;
(statearr_128610_128634[(2)] = inst_128587);


cljs.core.async.impl.ioc_helpers.process_exception(state_128601__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (13))){
var inst_128566 = (state_128601[(7)]);
var inst_128577 = cljs.core.count(inst_128566);
var inst_128578 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_128577);
var state_128601__$1 = state_128601;
if(inst_128578){
var statearr_128611_128635 = state_128601__$1;
(statearr_128611_128635[(1)] = (16));

} else {
var statearr_128612_128636 = state_128601__$1;
(statearr_128612_128636[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (6))){
var state_128601__$1 = state_128601;
var statearr_128613_128637 = state_128601__$1;
(statearr_128613_128637[(2)] = subject);

(statearr_128613_128637[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (17))){
var inst_128566 = (state_128601[(7)]);
var state_128601__$1 = state_128601;
var statearr_128614_128638 = state_128601__$1;
(statearr_128614_128638[(2)] = inst_128566);

(statearr_128614_128638[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (3))){
var inst_128555 = (state_128601[(2)]);
var state_128601__$1 = state_128601;
var statearr_128615_128639 = state_128601__$1;
(statearr_128615_128639[(2)] = inst_128555);


cljs.core.async.impl.ioc_helpers.process_exception(state_128601__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (12))){
var inst_128570 = (state_128601[(2)]);
var inst_128571 = fluree.db.util.async.throw_err(inst_128570);
var state_128601__$1 = state_128601;
var statearr_128616_128640 = state_128601__$1;
(statearr_128616_128640[(2)] = inst_128571);

(statearr_128616_128640[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (2))){
var inst_128599 = (state_128601[(2)]);
var state_128601__$1 = state_128601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128601__$1,inst_128599);
} else {
if((state_val_128602 === (11))){
var inst_128566 = (state_128601[(7)]);
var inst_128574 = (state_128601[(2)]);
var inst_128575 = cljs.core.vector_QMARK_(inst_128566);
var state_128601__$1 = (function (){var statearr_128617 = state_128601;
(statearr_128617[(8)] = inst_128574);

return statearr_128617;
})();
if(inst_128575){
var statearr_128618_128641 = state_128601__$1;
(statearr_128618_128641[(1)] = (13));

} else {
var statearr_128619_128642 = state_128601__$1;
(statearr_128619_128642[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (9))){
var state_128601__$1 = state_128601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128601__$1,(12),pred);
} else {
if((state_val_128602 === (5))){
var state_128601__$1 = state_128601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128601__$1,(8),subject);
} else {
if((state_val_128602 === (14))){
var inst_128566 = (state_128601[(7)]);
var state_128601__$1 = state_128601;
var statearr_128620_128643 = state_128601__$1;
(statearr_128620_128643[(2)] = inst_128566);

(statearr_128620_128643[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (16))){
var inst_128566 = (state_128601[(7)]);
var inst_128580 = cljs.core.first(inst_128566);
var state_128601__$1 = state_128601;
var statearr_128621_128644 = state_128601__$1;
(statearr_128621_128644[(2)] = inst_128580);

(statearr_128621_128644[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (10))){
var state_128601__$1 = state_128601;
var statearr_128622_128645 = state_128601__$1;
(statearr_128622_128645[(2)] = pred);

(statearr_128622_128645[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (18))){
var inst_128583 = (state_128601[(2)]);
var state_128601__$1 = state_128601;
var statearr_128623_128646 = state_128601__$1;
(statearr_128623_128646[(2)] = inst_128583);

(statearr_128623_128646[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128602 === (8))){
var inst_128562 = (state_128601[(2)]);
var inst_128563 = fluree.db.util.async.throw_err(inst_128562);
var state_128601__$1 = state_128601;
var statearr_128624_128647 = state_128601__$1;
(statearr_128624_128647[(2)] = inst_128563);

(statearr_128624_128647[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____0 = (function (){
var statearr_128625 = [null,null,null,null,null,null,null,null,null,null];
(statearr_128625[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__);

(statearr_128625[(1)] = (1));

return statearr_128625;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____1 = (function (state_128601){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128601);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128626){if((e128626 instanceof Object)){
var ex__109974__auto__ = e128626;
var statearr_128627_128648 = state_128601;
(statearr_128627_128648[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128601);

return cljs.core.cst$kw$recur;
} else {
throw e128626;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128649 = state_128601;
state_128601 = G__128649;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__ = function(state_128601){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____1.call(this,state_128601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128628 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128628[(6)] = c__110077__auto__);

return statearr_128628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128685){
var state_val_128686 = (state_128685[(1)]);
if((state_val_128686 === (7))){
var inst_128659 = (state_128685[(2)]);
var state_128685__$1 = state_128685;
if(cljs.core.truth_(inst_128659)){
var statearr_128687_128704 = state_128685__$1;
(statearr_128687_128704[(1)] = (8));

} else {
var statearr_128688_128705 = state_128685__$1;
(statearr_128688_128705[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (1))){
var state_128685__$1 = state_128685;
var statearr_128689_128706 = state_128685__$1;
(statearr_128689_128706[(2)] = null);

(statearr_128689_128706[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (4))){
var inst_128654 = (state_128685[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128685,(3),Error,null,(2));
var inst_128654__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128685__$1 = (function (){var statearr_128690 = state_128685;
(statearr_128690[(7)] = inst_128654__$1);

return statearr_128690;
})();
if(cljs.core.truth_(inst_128654__$1)){
var statearr_128691_128707 = state_128685__$1;
(statearr_128691_128707[(1)] = (5));

} else {
var statearr_128692_128708 = state_128685__$1;
(statearr_128692_128708[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (6))){
var inst_128654 = (state_128685[(7)]);
var state_128685__$1 = state_128685;
var statearr_128693_128709 = state_128685__$1;
(statearr_128693_128709[(2)] = inst_128654);

(statearr_128693_128709[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (3))){
var inst_128650 = (state_128685[(2)]);
var state_128685__$1 = state_128685;
var statearr_128694_128710 = state_128685__$1;
(statearr_128694_128710[(2)] = inst_128650);


cljs.core.async.impl.ioc_helpers.process_exception(state_128685__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (2))){
var inst_128683 = (state_128685[(2)]);
var state_128685__$1 = state_128685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128685__$1,inst_128683);
} else {
if((state_val_128686 === (11))){
var inst_128666 = (state_128685[(2)]);
var inst_128667 = fluree.db.util.async.throw_err(inst_128666);
var inst_128668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128667,(0),null);
var inst_128669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_128667,(1),null);
var inst_128670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128671 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128672 = ["?pO","?ctx",inst_128668];
var inst_128673 = cljs.core.PersistentHashMap.fromArrays(inst_128671,inst_128672);
var inst_128674 = ((10) + inst_128669);
var inst_128675 = [inst_128673,inst_128674];
var inst_128676 = (new cljs.core.PersistentVector(null,2,(5),inst_128670,inst_128675,null));
var inst_128677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128676);
var state_128685__$1 = (function (){var statearr_128695 = state_128685;
(statearr_128695[(8)] = inst_128677);

return statearr_128695;
})();
var statearr_128696_128711 = state_128685__$1;
(statearr_128696_128711[(2)] = inst_128668);

(statearr_128696_128711[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (9))){
var inst_128679 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_128685__$1 = state_128685;
var statearr_128697_128712 = state_128685__$1;
(statearr_128697_128712[(2)] = inst_128679);

(statearr_128697_128712[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (5))){
var inst_128656 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128685__$1 = state_128685;
var statearr_128698_128713 = state_128685__$1;
(statearr_128698_128713[(2)] = inst_128656);

(statearr_128698_128713[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (10))){
var inst_128681 = (state_128685[(2)]);
var state_128685__$1 = state_128685;
var statearr_128699_128714 = state_128685__$1;
(statearr_128699_128714[(2)] = inst_128681);


cljs.core.async.impl.ioc_helpers.process_exception(state_128685__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128686 === (8))){
var inst_128664 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_128685__$1 = state_128685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128685__$1,(11),inst_128664);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____0 = (function (){
var statearr_128700 = [null,null,null,null,null,null,null,null,null];
(statearr_128700[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__);

(statearr_128700[(1)] = (1));

return statearr_128700;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____1 = (function (state_128685){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128685);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128701){if((e128701 instanceof Object)){
var ex__109974__auto__ = e128701;
var statearr_128702_128715 = state_128685;
(statearr_128702_128715[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128685);

return cljs.core.cst$kw$recur;
} else {
throw e128701;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128716 = state_128685;
state_128685 = G__128716;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__ = function(state_128685){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____1.call(this,state_128685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128703 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128703[(6)] = c__110077__auto__);

return statearr_128703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128765){
var state_val_128766 = (state_128765[(1)]);
if((state_val_128766 === (7))){
var inst_128728 = (state_128765[(2)]);
var inst_128729 = fluree.db.util.async.channel_QMARK_(path);
var state_128765__$1 = (function (){var statearr_128767 = state_128765;
(statearr_128767[(7)] = inst_128728);

return statearr_128767;
})();
if(inst_128729){
var statearr_128768_128793 = state_128765__$1;
(statearr_128768_128793[(1)] = (9));

} else {
var statearr_128769_128794 = state_128765__$1;
(statearr_128769_128794[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (1))){
var state_128765__$1 = state_128765;
var statearr_128770_128795 = state_128765__$1;
(statearr_128770_128795[(2)] = null);

(statearr_128770_128795[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128765,(3),Error,null,(2));
var inst_128721 = fluree.db.util.async.channel_QMARK_(subject);
var state_128765__$1 = state_128765;
if(inst_128721){
var statearr_128771_128796 = state_128765__$1;
(statearr_128771_128796[(1)] = (5));

} else {
var statearr_128772_128797 = state_128765__$1;
(statearr_128772_128797[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (15))){
var inst_128728 = (state_128765[(7)]);
var inst_128736 = (state_128765[(8)]);
var inst_128748 = (state_128765[(2)]);
var inst_128749 = fluree.db.dbfunctions.internal.get_all(inst_128748,inst_128736);
var inst_128750 = cljs.core.count(inst_128736);
var inst_128751 = ((9) + inst_128750);
var inst_128752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128753 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128755 = [inst_128728,inst_128736];
var inst_128756 = (new cljs.core.PersistentVector(null,2,(5),inst_128754,inst_128755,null));
var inst_128757 = ["get-all",inst_128756,inst_128749];
var inst_128758 = cljs.core.PersistentHashMap.fromArrays(inst_128753,inst_128757);
var inst_128759 = [inst_128758,inst_128751];
var inst_128760 = (new cljs.core.PersistentVector(null,2,(5),inst_128752,inst_128759,null));
var inst_128761 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128760);
var state_128765__$1 = (function (){var statearr_128773 = state_128765;
(statearr_128773[(9)] = inst_128761);

return statearr_128773;
})();
var statearr_128774_128798 = state_128765__$1;
(statearr_128774_128798[(2)] = inst_128749);


cljs.core.async.impl.ioc_helpers.process_exception(state_128765__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (13))){
var inst_128728 = (state_128765[(7)]);
var inst_128739 = cljs.core.count(inst_128728);
var inst_128740 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_128739);
var state_128765__$1 = state_128765;
if(inst_128740){
var statearr_128775_128799 = state_128765__$1;
(statearr_128775_128799[(1)] = (16));

} else {
var statearr_128776_128800 = state_128765__$1;
(statearr_128776_128800[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (6))){
var state_128765__$1 = state_128765;
var statearr_128777_128801 = state_128765__$1;
(statearr_128777_128801[(2)] = subject);

(statearr_128777_128801[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (17))){
var inst_128728 = (state_128765[(7)]);
var state_128765__$1 = state_128765;
var statearr_128778_128802 = state_128765__$1;
(statearr_128778_128802[(2)] = inst_128728);

(statearr_128778_128802[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (3))){
var inst_128717 = (state_128765[(2)]);
var state_128765__$1 = state_128765;
var statearr_128779_128803 = state_128765__$1;
(statearr_128779_128803[(2)] = inst_128717);


cljs.core.async.impl.ioc_helpers.process_exception(state_128765__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (12))){
var inst_128732 = (state_128765[(2)]);
var inst_128733 = fluree.db.util.async.throw_err(inst_128732);
var state_128765__$1 = state_128765;
var statearr_128780_128804 = state_128765__$1;
(statearr_128780_128804[(2)] = inst_128733);

(statearr_128780_128804[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (2))){
var inst_128763 = (state_128765[(2)]);
var state_128765__$1 = state_128765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128765__$1,inst_128763);
} else {
if((state_val_128766 === (11))){
var inst_128728 = (state_128765[(7)]);
var inst_128736 = (state_128765[(2)]);
var inst_128737 = cljs.core.vector_QMARK_(inst_128728);
var state_128765__$1 = (function (){var statearr_128781 = state_128765;
(statearr_128781[(8)] = inst_128736);

return statearr_128781;
})();
if(inst_128737){
var statearr_128782_128805 = state_128765__$1;
(statearr_128782_128805[(1)] = (13));

} else {
var statearr_128783_128806 = state_128765__$1;
(statearr_128783_128806[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (9))){
var state_128765__$1 = state_128765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128765__$1,(12),path);
} else {
if((state_val_128766 === (5))){
var state_128765__$1 = state_128765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128765__$1,(8),subject);
} else {
if((state_val_128766 === (14))){
var inst_128728 = (state_128765[(7)]);
var state_128765__$1 = state_128765;
var statearr_128784_128807 = state_128765__$1;
(statearr_128784_128807[(2)] = inst_128728);

(statearr_128784_128807[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (16))){
var inst_128728 = (state_128765[(7)]);
var inst_128742 = cljs.core.first(inst_128728);
var state_128765__$1 = state_128765;
var statearr_128785_128808 = state_128765__$1;
(statearr_128785_128808[(2)] = inst_128742);

(statearr_128785_128808[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (10))){
var state_128765__$1 = state_128765;
var statearr_128786_128809 = state_128765__$1;
(statearr_128786_128809[(2)] = path);

(statearr_128786_128809[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (18))){
var inst_128745 = (state_128765[(2)]);
var state_128765__$1 = state_128765;
var statearr_128787_128810 = state_128765__$1;
(statearr_128787_128810[(2)] = inst_128745);

(statearr_128787_128810[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128766 === (8))){
var inst_128724 = (state_128765[(2)]);
var inst_128725 = fluree.db.util.async.throw_err(inst_128724);
var state_128765__$1 = state_128765;
var statearr_128788_128811 = state_128765__$1;
(statearr_128788_128811[(2)] = inst_128725);

(statearr_128788_128811[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____0 = (function (){
var statearr_128789 = [null,null,null,null,null,null,null,null,null,null];
(statearr_128789[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__);

(statearr_128789[(1)] = (1));

return statearr_128789;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____1 = (function (state_128765){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128765);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128790){if((e128790 instanceof Object)){
var ex__109974__auto__ = e128790;
var statearr_128791_128812 = state_128765;
(statearr_128791_128812[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128765);

return cljs.core.cst$kw$recur;
} else {
throw e128790;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128813 = state_128765;
state_128765 = G__128813;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__ = function(state_128765){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____1.call(this,state_128765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128792 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128792[(6)] = c__110077__auto__);

return statearr_128792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128849){
var state_val_128850 = (state_128849[(1)]);
if((state_val_128850 === (7))){
var inst_128825 = (state_128849[(2)]);
var inst_128826 = fluree.db.util.async.channel_QMARK_(path);
var state_128849__$1 = (function (){var statearr_128851 = state_128849;
(statearr_128851[(7)] = inst_128825);

return statearr_128851;
})();
if(inst_128826){
var statearr_128852_128868 = state_128849__$1;
(statearr_128852_128868[(1)] = (9));

} else {
var statearr_128853_128869 = state_128849__$1;
(statearr_128853_128869[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (1))){
var state_128849__$1 = state_128849;
var statearr_128854_128870 = state_128849__$1;
(statearr_128854_128870[(2)] = null);

(statearr_128854_128870[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128849,(3),Error,null,(2));
var inst_128818 = fluree.db.util.async.channel_QMARK_(subject);
var state_128849__$1 = state_128849;
if(inst_128818){
var statearr_128855_128871 = state_128849__$1;
(statearr_128855_128871[(1)] = (5));

} else {
var statearr_128856_128872 = state_128849__$1;
(statearr_128856_128872[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (6))){
var state_128849__$1 = state_128849;
var statearr_128857_128873 = state_128849__$1;
(statearr_128857_128873[(2)] = subject);

(statearr_128857_128873[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (3))){
var inst_128814 = (state_128849[(2)]);
var state_128849__$1 = state_128849;
var statearr_128858_128874 = state_128849__$1;
(statearr_128858_128874[(2)] = inst_128814);


cljs.core.async.impl.ioc_helpers.process_exception(state_128849__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (12))){
var inst_128829 = (state_128849[(2)]);
var inst_128830 = fluree.db.util.async.throw_err(inst_128829);
var state_128849__$1 = state_128849;
var statearr_128859_128875 = state_128849__$1;
(statearr_128859_128875[(2)] = inst_128830);

(statearr_128859_128875[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (2))){
var inst_128847 = (state_128849[(2)]);
var state_128849__$1 = state_128849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128849__$1,inst_128847);
} else {
if((state_val_128850 === (11))){
var inst_128825 = (state_128849[(7)]);
var inst_128833 = (state_128849[(2)]);
var inst_128834 = fluree.db.dbfunctions.internal.get_in(inst_128825,inst_128833);
var inst_128835 = cljs.core.count(inst_128833);
var inst_128836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128837 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128839 = [inst_128825,inst_128833];
var inst_128840 = (new cljs.core.PersistentVector(null,2,(5),inst_128838,inst_128839,null));
var inst_128841 = ["get-in",inst_128840,inst_128834];
var inst_128842 = cljs.core.PersistentHashMap.fromArrays(inst_128837,inst_128841);
var inst_128843 = [inst_128842,inst_128835];
var inst_128844 = (new cljs.core.PersistentVector(null,2,(5),inst_128836,inst_128843,null));
var inst_128845 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128844);
var state_128849__$1 = (function (){var statearr_128860 = state_128849;
(statearr_128860[(8)] = inst_128845);

return statearr_128860;
})();
var statearr_128861_128876 = state_128849__$1;
(statearr_128861_128876[(2)] = inst_128834);


cljs.core.async.impl.ioc_helpers.process_exception(state_128849__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (9))){
var state_128849__$1 = state_128849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128849__$1,(12),path);
} else {
if((state_val_128850 === (5))){
var state_128849__$1 = state_128849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128849__$1,(8),subject);
} else {
if((state_val_128850 === (10))){
var state_128849__$1 = state_128849;
var statearr_128862_128877 = state_128849__$1;
(statearr_128862_128877[(2)] = path);

(statearr_128862_128877[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128850 === (8))){
var inst_128821 = (state_128849[(2)]);
var inst_128822 = fluree.db.util.async.throw_err(inst_128821);
var state_128849__$1 = state_128849;
var statearr_128863_128878 = state_128849__$1;
(statearr_128863_128878[(2)] = inst_128822);

(statearr_128863_128878[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____0 = (function (){
var statearr_128864 = [null,null,null,null,null,null,null,null,null];
(statearr_128864[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__);

(statearr_128864[(1)] = (1));

return statearr_128864;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____1 = (function (state_128849){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128849);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128865){if((e128865 instanceof Object)){
var ex__109974__auto__ = e128865;
var statearr_128866_128879 = state_128849;
(statearr_128866_128879[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128849);

return cljs.core.cst$kw$recur;
} else {
throw e128865;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128880 = state_128849;
state_128849 = G__128880;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__ = function(state_128849){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____1.call(this,state_128849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128867 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128867[(6)] = c__110077__auto__);

return statearr_128867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_128922){
var state_val_128923 = (state_128922[(1)]);
if((state_val_128923 === (7))){
var inst_128892 = (state_128922[(7)]);
var inst_128892__$1 = (state_128922[(2)]);
var inst_128893 = cljs.core.set_QMARK_(inst_128892__$1);
var state_128922__$1 = (function (){var statearr_128924 = state_128922;
(statearr_128924[(7)] = inst_128892__$1);

return statearr_128924;
})();
if(inst_128893){
var statearr_128925_128946 = state_128922__$1;
(statearr_128925_128946[(1)] = (9));

} else {
var statearr_128926_128947 = state_128922__$1;
(statearr_128926_128947[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (1))){
var state_128922__$1 = state_128922;
var statearr_128927_128948 = state_128922__$1;
(statearr_128927_128948[(2)] = null);

(statearr_128927_128948[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_128922,(3),Error,null,(2));
var inst_128885 = fluree.db.util.async.channel_QMARK_(coll);
var state_128922__$1 = state_128922;
if(inst_128885){
var statearr_128928_128949 = state_128922__$1;
(statearr_128928_128949[(1)] = (5));

} else {
var statearr_128929_128950 = state_128922__$1;
(statearr_128929_128950[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (15))){
var inst_128903 = (state_128922[(2)]);
var inst_128904 = fluree.db.util.async.throw_err(inst_128903);
var state_128922__$1 = state_128922;
var statearr_128930_128951 = state_128922__$1;
(statearr_128930_128951[(2)] = inst_128904);

(statearr_128930_128951[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (13))){
var state_128922__$1 = state_128922;
var statearr_128931_128952 = state_128922__$1;
(statearr_128931_128952[(2)] = key);

(statearr_128931_128952[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (6))){
var state_128922__$1 = state_128922;
var statearr_128932_128953 = state_128922__$1;
(statearr_128932_128953[(2)] = coll);

(statearr_128932_128953[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (3))){
var inst_128881 = (state_128922[(2)]);
var state_128922__$1 = state_128922;
var statearr_128933_128954 = state_128922__$1;
(statearr_128933_128954[(2)] = inst_128881);


cljs.core.async.impl.ioc_helpers.process_exception(state_128922__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (12))){
var state_128922__$1 = state_128922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128922__$1,(15),key);
} else {
if((state_val_128923 === (2))){
var inst_128920 = (state_128922[(2)]);
var state_128922__$1 = state_128922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_128922__$1,inst_128920);
} else {
if((state_val_128923 === (11))){
var inst_128899 = (state_128922[(2)]);
var inst_128900 = fluree.db.util.async.channel_QMARK_(key);
var state_128922__$1 = (function (){var statearr_128934 = state_128922;
(statearr_128934[(8)] = inst_128899);

return statearr_128934;
})();
if(inst_128900){
var statearr_128935_128955 = state_128922__$1;
(statearr_128935_128955[(1)] = (12));

} else {
var statearr_128936_128956 = state_128922__$1;
(statearr_128936_128956[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (9))){
var inst_128892 = (state_128922[(7)]);
var state_128922__$1 = state_128922;
var statearr_128937_128957 = state_128922__$1;
(statearr_128937_128957[(2)] = inst_128892);

(statearr_128937_128957[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (5))){
var state_128922__$1 = state_128922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_128922__$1,(8),coll);
} else {
if((state_val_128923 === (14))){
var inst_128899 = (state_128922[(8)]);
var inst_128907 = (state_128922[(2)]);
var inst_128908 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_128899,inst_128907);
var inst_128909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128910 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128912 = [inst_128899,inst_128907];
var inst_128913 = (new cljs.core.PersistentVector(null,2,(5),inst_128911,inst_128912,null));
var inst_128914 = ["contains?",inst_128913,inst_128908];
var inst_128915 = cljs.core.PersistentHashMap.fromArrays(inst_128910,inst_128914);
var inst_128916 = [inst_128915,(10)];
var inst_128917 = (new cljs.core.PersistentVector(null,2,(5),inst_128909,inst_128916,null));
var inst_128918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128917);
var state_128922__$1 = (function (){var statearr_128938 = state_128922;
(statearr_128938[(9)] = inst_128918);

return statearr_128938;
})();
var statearr_128939_128958 = state_128922__$1;
(statearr_128939_128958[(2)] = inst_128908);


cljs.core.async.impl.ioc_helpers.process_exception(state_128922__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (10))){
var inst_128892 = (state_128922[(7)]);
var inst_128896 = cljs.core.flatten(inst_128892);
var inst_128897 = cljs.core.set(inst_128896);
var state_128922__$1 = state_128922;
var statearr_128940_128959 = state_128922__$1;
(statearr_128940_128959[(2)] = inst_128897);

(statearr_128940_128959[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_128923 === (8))){
var inst_128888 = (state_128922[(2)]);
var inst_128889 = fluree.db.util.async.throw_err(inst_128888);
var state_128922__$1 = state_128922;
var statearr_128941_128960 = state_128922__$1;
(statearr_128941_128960[(2)] = inst_128889);

(statearr_128941_128960[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_128942 = [null,null,null,null,null,null,null,null,null,null];
(statearr_128942[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__);

(statearr_128942[(1)] = (1));

return statearr_128942;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____1 = (function (state_128922){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_128922);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e128943){if((e128943 instanceof Object)){
var ex__109974__auto__ = e128943;
var statearr_128944_128961 = state_128922;
(statearr_128944_128961[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_128922);

return cljs.core.cst$kw$recur;
} else {
throw e128943;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__128962 = state_128922;
state_128922 = G__128962;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__ = function(state_128922){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____1.call(this,state_128922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_128945 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_128945[(6)] = c__110077__auto__);

return statearr_128945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129017 = arguments.length;
var i__4731__auto___129018 = (0);
while(true){
if((i__4731__auto___129018 < len__4730__auto___129017)){
args__4736__auto__.push((arguments[i__4731__auto___129018]));

var G__129019 = (i__4731__auto___129018 + (1));
i__4731__auto___129018 = G__129019;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129002){
var state_val_129003 = (state_129002[(1)]);
if((state_val_129003 === (1))){
var state_129002__$1 = state_129002;
var statearr_129004_129020 = state_129002__$1;
(statearr_129004_129020[(2)] = null);

(statearr_129004_129020[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129003 === (2))){
var inst_129000 = (state_129002[(2)]);
var state_129002__$1 = state_129002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129002__$1,inst_129000);
} else {
if((state_val_129003 === (3))){
var inst_128965 = (state_129002[(2)]);
var state_129002__$1 = state_129002;
var statearr_129005_129021 = state_129002__$1;
(statearr_129005_129021[(2)] = inst_128965);


cljs.core.async.impl.ioc_helpers.process_exception(state_129002__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129003 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129002,(3),Error,null,(2));
var inst_128969 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129002__$1 = state_129002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129002__$1,(5),inst_128969);
} else {
if((state_val_129003 === (5))){
var inst_128972 = (state_129002[(7)]);
var inst_128971 = (state_129002[(2)]);
var inst_128972__$1 = fluree.db.util.async.throw_err(inst_128971);
var inst_128973 = cljs.core.count(inst_128972__$1);
var inst_128974 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_128973);
var inst_128975 = cljs.core.first(inst_128972__$1);
var inst_128976 = cljs.core.coll_QMARK_(inst_128975);
var inst_128977 = ((inst_128974) && (inst_128976));
var state_129002__$1 = (function (){var statearr_129006 = state_129002;
(statearr_129006[(7)] = inst_128972__$1);

return statearr_129006;
})();
if(cljs.core.truth_(inst_128977)){
var statearr_129007_129022 = state_129002__$1;
(statearr_129007_129022[(1)] = (6));

} else {
var statearr_129008_129023 = state_129002__$1;
(statearr_129008_129023[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129003 === (6))){
var inst_128972 = (state_129002[(7)]);
var inst_128979 = cljs.core.first(inst_128972);
var state_129002__$1 = state_129002;
var statearr_129009_129024 = state_129002__$1;
(statearr_129009_129024[(2)] = inst_128979);

(statearr_129009_129024[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129003 === (7))){
var inst_128972 = (state_129002[(7)]);
var state_129002__$1 = state_129002;
var statearr_129010_129025 = state_129002__$1;
(statearr_129010_129025[(2)] = inst_128972);

(statearr_129010_129025[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129003 === (8))){
var inst_128982 = (state_129002[(2)]);
var inst_128983 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_128982);
var inst_128984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128985 = [inst_128982];
var inst_128986 = (new cljs.core.PersistentVector(null,1,(5),inst_128984,inst_128985,null));
var inst_128987 = cljs.core.count(inst_128986);
var inst_128988 = ((9) + inst_128987);
var inst_128989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128990 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_128991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128992 = [inst_128982];
var inst_128993 = (new cljs.core.PersistentVector(null,1,(5),inst_128991,inst_128992,null));
var inst_128994 = ["hash-set",inst_128993,inst_128983];
var inst_128995 = cljs.core.PersistentHashMap.fromArrays(inst_128990,inst_128994);
var inst_128996 = [inst_128995,inst_128988];
var inst_128997 = (new cljs.core.PersistentVector(null,2,(5),inst_128989,inst_128996,null));
var inst_128998 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_128997);
var state_129002__$1 = (function (){var statearr_129011 = state_129002;
(statearr_129011[(8)] = inst_128998);

return statearr_129011;
})();
var statearr_129012_129026 = state_129002__$1;
(statearr_129012_129026[(2)] = inst_128983);


cljs.core.async.impl.ioc_helpers.process_exception(state_129002__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129013 = [null,null,null,null,null,null,null,null,null];
(statearr_129013[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129013[(1)] = (1));

return statearr_129013;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129002){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129002);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129014){if((e129014 instanceof Object)){
var ex__109974__auto__ = e129014;
var statearr_129015_129027 = state_129002;
(statearr_129015_129027[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129002);

return cljs.core.cst$kw$recur;
} else {
throw e129014;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129028 = state_129002;
state_129002 = G__129028;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129016 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129016[(6)] = c__110077__auto__);

return statearr_129016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq128963){
var G__128964 = cljs.core.first(seq128963);
var seq128963__$1 = cljs.core.next(seq128963);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128964,seq128963__$1);
});

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129068 = arguments.length;
var i__4731__auto___129069 = (0);
while(true){
if((i__4731__auto___129069 < len__4730__auto___129068)){
args__4736__auto__.push((arguments[i__4731__auto___129069]));

var G__129070 = (i__4731__auto___129069 + (1));
i__4731__auto___129069 = G__129070;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129058){
var state_val_129059 = (state_129058[(1)]);
if((state_val_129059 === (1))){
var state_129058__$1 = state_129058;
var statearr_129060_129071 = state_129058__$1;
(statearr_129060_129071[(2)] = null);

(statearr_129060_129071[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129059 === (2))){
var inst_129056 = (state_129058[(2)]);
var state_129058__$1 = state_129058;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129058__$1,inst_129056);
} else {
if((state_val_129059 === (3))){
var inst_129031 = (state_129058[(2)]);
var state_129058__$1 = state_129058;
var statearr_129061_129072 = state_129058__$1;
(statearr_129061_129072[(2)] = inst_129031);


cljs.core.async.impl.ioc_helpers.process_exception(state_129058__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129059 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129058,(3),Error,null,(2));
var inst_129035 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129058__$1 = state_129058;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129058__$1,(5),inst_129035);
} else {
if((state_val_129059 === (5))){
var inst_129037 = (state_129058[(2)]);
var inst_129038 = fluree.db.util.async.throw_err(inst_129037);
var inst_129039 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_129038);
var inst_129040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129041 = [inst_129038];
var inst_129042 = (new cljs.core.PersistentVector(null,1,(5),inst_129040,inst_129041,null));
var inst_129043 = cljs.core.count(inst_129042);
var inst_129044 = ((9) + inst_129043);
var inst_129045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129046 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129048 = [inst_129038];
var inst_129049 = (new cljs.core.PersistentVector(null,1,(5),inst_129047,inst_129048,null));
var inst_129050 = ["==",inst_129049,inst_129039];
var inst_129051 = cljs.core.PersistentHashMap.fromArrays(inst_129046,inst_129050);
var inst_129052 = [inst_129051,inst_129044];
var inst_129053 = (new cljs.core.PersistentVector(null,2,(5),inst_129045,inst_129052,null));
var inst_129054 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129053);
var state_129058__$1 = (function (){var statearr_129062 = state_129058;
(statearr_129062[(7)] = inst_129054);

return statearr_129062;
})();
var statearr_129063_129073 = state_129058__$1;
(statearr_129063_129073[(2)] = inst_129039);


cljs.core.async.impl.ioc_helpers.process_exception(state_129058__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129064 = [null,null,null,null,null,null,null,null];
(statearr_129064[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129064[(1)] = (1));

return statearr_129064;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129058){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129058);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129065){if((e129065 instanceof Object)){
var ex__109974__auto__ = e129065;
var statearr_129066_129074 = state_129058;
(statearr_129066_129074[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129058);

return cljs.core.cst$kw$recur;
} else {
throw e129065;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129075 = state_129058;
state_129058 = G__129075;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129058){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129067 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129067[(6)] = c__110077__auto__);

return statearr_129067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq129029){
var G__129030 = cljs.core.first(seq129029);
var seq129029__$1 = cljs.core.next(seq129029);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129030,seq129029__$1);
});

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129115 = arguments.length;
var i__4731__auto___129116 = (0);
while(true){
if((i__4731__auto___129116 < len__4730__auto___129115)){
args__4736__auto__.push((arguments[i__4731__auto___129116]));

var G__129117 = (i__4731__auto___129116 + (1));
i__4731__auto___129116 = G__129117;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129105){
var state_val_129106 = (state_129105[(1)]);
if((state_val_129106 === (1))){
var state_129105__$1 = state_129105;
var statearr_129107_129118 = state_129105__$1;
(statearr_129107_129118[(2)] = null);

(statearr_129107_129118[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129106 === (2))){
var inst_129103 = (state_129105[(2)]);
var state_129105__$1 = state_129105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129105__$1,inst_129103);
} else {
if((state_val_129106 === (3))){
var inst_129078 = (state_129105[(2)]);
var state_129105__$1 = state_129105;
var statearr_129108_129119 = state_129105__$1;
(statearr_129108_129119[(2)] = inst_129078);


cljs.core.async.impl.ioc_helpers.process_exception(state_129105__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129106 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129105,(3),Error,null,(2));
var inst_129082 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129105__$1 = state_129105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129105__$1,(5),inst_129082);
} else {
if((state_val_129106 === (5))){
var inst_129084 = (state_129105[(2)]);
var inst_129085 = fluree.db.util.async.throw_err(inst_129084);
var inst_129086 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_129085);
var inst_129087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129088 = [inst_129085];
var inst_129089 = (new cljs.core.PersistentVector(null,1,(5),inst_129087,inst_129088,null));
var inst_129090 = cljs.core.count(inst_129089);
var inst_129091 = ((9) + inst_129090);
var inst_129092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129093 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129095 = [inst_129085];
var inst_129096 = (new cljs.core.PersistentVector(null,1,(5),inst_129094,inst_129095,null));
var inst_129097 = [">",inst_129096,inst_129086];
var inst_129098 = cljs.core.PersistentHashMap.fromArrays(inst_129093,inst_129097);
var inst_129099 = [inst_129098,inst_129091];
var inst_129100 = (new cljs.core.PersistentVector(null,2,(5),inst_129092,inst_129099,null));
var inst_129101 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129100);
var state_129105__$1 = (function (){var statearr_129109 = state_129105;
(statearr_129109[(7)] = inst_129101);

return statearr_129109;
})();
var statearr_129110_129120 = state_129105__$1;
(statearr_129110_129120[(2)] = inst_129086);


cljs.core.async.impl.ioc_helpers.process_exception(state_129105__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129111 = [null,null,null,null,null,null,null,null];
(statearr_129111[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129111[(1)] = (1));

return statearr_129111;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129105){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129105);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129112){if((e129112 instanceof Object)){
var ex__109974__auto__ = e129112;
var statearr_129113_129121 = state_129105;
(statearr_129113_129121[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129105);

return cljs.core.cst$kw$recur;
} else {
throw e129112;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129122 = state_129105;
state_129105 = G__129122;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129105){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129114 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129114[(6)] = c__110077__auto__);

return statearr_129114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq129076){
var G__129077 = cljs.core.first(seq129076);
var seq129076__$1 = cljs.core.next(seq129076);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129077,seq129076__$1);
});

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129162 = arguments.length;
var i__4731__auto___129163 = (0);
while(true){
if((i__4731__auto___129163 < len__4730__auto___129162)){
args__4736__auto__.push((arguments[i__4731__auto___129163]));

var G__129164 = (i__4731__auto___129163 + (1));
i__4731__auto___129163 = G__129164;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129152){
var state_val_129153 = (state_129152[(1)]);
if((state_val_129153 === (1))){
var state_129152__$1 = state_129152;
var statearr_129154_129165 = state_129152__$1;
(statearr_129154_129165[(2)] = null);

(statearr_129154_129165[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129153 === (2))){
var inst_129150 = (state_129152[(2)]);
var state_129152__$1 = state_129152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129152__$1,inst_129150);
} else {
if((state_val_129153 === (3))){
var inst_129125 = (state_129152[(2)]);
var state_129152__$1 = state_129152;
var statearr_129155_129166 = state_129152__$1;
(statearr_129155_129166[(2)] = inst_129125);


cljs.core.async.impl.ioc_helpers.process_exception(state_129152__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129153 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129152,(3),Error,null,(2));
var inst_129129 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129152__$1 = state_129152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129152__$1,(5),inst_129129);
} else {
if((state_val_129153 === (5))){
var inst_129131 = (state_129152[(2)]);
var inst_129132 = fluree.db.util.async.throw_err(inst_129131);
var inst_129133 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_129132);
var inst_129134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129135 = [inst_129132];
var inst_129136 = (new cljs.core.PersistentVector(null,1,(5),inst_129134,inst_129135,null));
var inst_129137 = cljs.core.count(inst_129136);
var inst_129138 = ((9) + inst_129137);
var inst_129139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129140 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129142 = [inst_129132];
var inst_129143 = (new cljs.core.PersistentVector(null,1,(5),inst_129141,inst_129142,null));
var inst_129144 = ["<",inst_129143,inst_129133];
var inst_129145 = cljs.core.PersistentHashMap.fromArrays(inst_129140,inst_129144);
var inst_129146 = [inst_129145,inst_129138];
var inst_129147 = (new cljs.core.PersistentVector(null,2,(5),inst_129139,inst_129146,null));
var inst_129148 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129147);
var state_129152__$1 = (function (){var statearr_129156 = state_129152;
(statearr_129156[(7)] = inst_129148);

return statearr_129156;
})();
var statearr_129157_129167 = state_129152__$1;
(statearr_129157_129167[(2)] = inst_129133);


cljs.core.async.impl.ioc_helpers.process_exception(state_129152__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129158 = [null,null,null,null,null,null,null,null];
(statearr_129158[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129158[(1)] = (1));

return statearr_129158;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129152){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129152);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129159){if((e129159 instanceof Object)){
var ex__109974__auto__ = e129159;
var statearr_129160_129168 = state_129152;
(statearr_129160_129168[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129152);

return cljs.core.cst$kw$recur;
} else {
throw e129159;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129169 = state_129152;
state_129152 = G__129169;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129152){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129161 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129161[(6)] = c__110077__auto__);

return statearr_129161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq129123){
var G__129124 = cljs.core.first(seq129123);
var seq129123__$1 = cljs.core.next(seq129123);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129124,seq129123__$1);
});

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129209 = arguments.length;
var i__4731__auto___129210 = (0);
while(true){
if((i__4731__auto___129210 < len__4730__auto___129209)){
args__4736__auto__.push((arguments[i__4731__auto___129210]));

var G__129211 = (i__4731__auto___129210 + (1));
i__4731__auto___129210 = G__129211;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129199){
var state_val_129200 = (state_129199[(1)]);
if((state_val_129200 === (1))){
var state_129199__$1 = state_129199;
var statearr_129201_129212 = state_129199__$1;
(statearr_129201_129212[(2)] = null);

(statearr_129201_129212[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129200 === (2))){
var inst_129197 = (state_129199[(2)]);
var state_129199__$1 = state_129199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129199__$1,inst_129197);
} else {
if((state_val_129200 === (3))){
var inst_129172 = (state_129199[(2)]);
var state_129199__$1 = state_129199;
var statearr_129202_129213 = state_129199__$1;
(statearr_129202_129213[(2)] = inst_129172);


cljs.core.async.impl.ioc_helpers.process_exception(state_129199__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129200 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129199,(3),Error,null,(2));
var inst_129176 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129199__$1 = state_129199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129199__$1,(5),inst_129176);
} else {
if((state_val_129200 === (5))){
var inst_129178 = (state_129199[(2)]);
var inst_129179 = fluree.db.util.async.throw_err(inst_129178);
var inst_129180 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_129179);
var inst_129181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129182 = [inst_129179];
var inst_129183 = (new cljs.core.PersistentVector(null,1,(5),inst_129181,inst_129182,null));
var inst_129184 = cljs.core.count(inst_129183);
var inst_129185 = ((9) + inst_129184);
var inst_129186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129187 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129189 = [inst_129179];
var inst_129190 = (new cljs.core.PersistentVector(null,1,(5),inst_129188,inst_129189,null));
var inst_129191 = ["<=",inst_129190,inst_129180];
var inst_129192 = cljs.core.PersistentHashMap.fromArrays(inst_129187,inst_129191);
var inst_129193 = [inst_129192,inst_129185];
var inst_129194 = (new cljs.core.PersistentVector(null,2,(5),inst_129186,inst_129193,null));
var inst_129195 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129194);
var state_129199__$1 = (function (){var statearr_129203 = state_129199;
(statearr_129203[(7)] = inst_129195);

return statearr_129203;
})();
var statearr_129204_129214 = state_129199__$1;
(statearr_129204_129214[(2)] = inst_129180);


cljs.core.async.impl.ioc_helpers.process_exception(state_129199__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129205 = [null,null,null,null,null,null,null,null];
(statearr_129205[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129205[(1)] = (1));

return statearr_129205;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129199){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129199);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129206){if((e129206 instanceof Object)){
var ex__109974__auto__ = e129206;
var statearr_129207_129215 = state_129199;
(statearr_129207_129215[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129199);

return cljs.core.cst$kw$recur;
} else {
throw e129206;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129216 = state_129199;
state_129199 = G__129216;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129208 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129208[(6)] = c__110077__auto__);

return statearr_129208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq129170){
var G__129171 = cljs.core.first(seq129170);
var seq129170__$1 = cljs.core.next(seq129170);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129171,seq129170__$1);
});

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129256 = arguments.length;
var i__4731__auto___129257 = (0);
while(true){
if((i__4731__auto___129257 < len__4730__auto___129256)){
args__4736__auto__.push((arguments[i__4731__auto___129257]));

var G__129258 = (i__4731__auto___129257 + (1));
i__4731__auto___129257 = G__129258;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129246){
var state_val_129247 = (state_129246[(1)]);
if((state_val_129247 === (1))){
var state_129246__$1 = state_129246;
var statearr_129248_129259 = state_129246__$1;
(statearr_129248_129259[(2)] = null);

(statearr_129248_129259[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129247 === (2))){
var inst_129244 = (state_129246[(2)]);
var state_129246__$1 = state_129246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129246__$1,inst_129244);
} else {
if((state_val_129247 === (3))){
var inst_129219 = (state_129246[(2)]);
var state_129246__$1 = state_129246;
var statearr_129249_129260 = state_129246__$1;
(statearr_129249_129260[(2)] = inst_129219);


cljs.core.async.impl.ioc_helpers.process_exception(state_129246__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129247 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129246,(3),Error,null,(2));
var inst_129223 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129246__$1 = state_129246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129246__$1,(5),inst_129223);
} else {
if((state_val_129247 === (5))){
var inst_129225 = (state_129246[(2)]);
var inst_129226 = fluree.db.util.async.throw_err(inst_129225);
var inst_129227 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_129226);
var inst_129228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129229 = [inst_129226];
var inst_129230 = (new cljs.core.PersistentVector(null,1,(5),inst_129228,inst_129229,null));
var inst_129231 = cljs.core.count(inst_129230);
var inst_129232 = ((9) + inst_129231);
var inst_129233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129234 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129236 = [inst_129226];
var inst_129237 = (new cljs.core.PersistentVector(null,1,(5),inst_129235,inst_129236,null));
var inst_129238 = [">=",inst_129237,inst_129227];
var inst_129239 = cljs.core.PersistentHashMap.fromArrays(inst_129234,inst_129238);
var inst_129240 = [inst_129239,inst_129232];
var inst_129241 = (new cljs.core.PersistentVector(null,2,(5),inst_129233,inst_129240,null));
var inst_129242 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129241);
var state_129246__$1 = (function (){var statearr_129250 = state_129246;
(statearr_129250[(7)] = inst_129242);

return statearr_129250;
})();
var statearr_129251_129261 = state_129246__$1;
(statearr_129251_129261[(2)] = inst_129227);


cljs.core.async.impl.ioc_helpers.process_exception(state_129246__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129252 = [null,null,null,null,null,null,null,null];
(statearr_129252[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129252[(1)] = (1));

return statearr_129252;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129246){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129246);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129253){if((e129253 instanceof Object)){
var ex__109974__auto__ = e129253;
var statearr_129254_129262 = state_129246;
(statearr_129254_129262[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129246);

return cljs.core.cst$kw$recur;
} else {
throw e129253;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129263 = state_129246;
state_129246 = G__129263;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129246){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129255 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129255[(6)] = c__110077__auto__);

return statearr_129255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq129217){
var G__129218 = cljs.core.first(seq129217);
var seq129217__$1 = cljs.core.next(seq129217);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129218,seq129217__$1);
});

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129303 = arguments.length;
var i__4731__auto___129304 = (0);
while(true){
if((i__4731__auto___129304 < len__4730__auto___129303)){
args__4736__auto__.push((arguments[i__4731__auto___129304]));

var G__129305 = (i__4731__auto___129304 + (1));
i__4731__auto___129304 = G__129305;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129293){
var state_val_129294 = (state_129293[(1)]);
if((state_val_129294 === (1))){
var state_129293__$1 = state_129293;
var statearr_129295_129306 = state_129293__$1;
(statearr_129295_129306[(2)] = null);

(statearr_129295_129306[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129294 === (2))){
var inst_129291 = (state_129293[(2)]);
var state_129293__$1 = state_129293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129293__$1,inst_129291);
} else {
if((state_val_129294 === (3))){
var inst_129266 = (state_129293[(2)]);
var state_129293__$1 = state_129293;
var statearr_129296_129307 = state_129293__$1;
(statearr_129296_129307[(2)] = inst_129266);


cljs.core.async.impl.ioc_helpers.process_exception(state_129293__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129294 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129293,(3),Error,null,(2));
var inst_129270 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129293__$1 = state_129293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129293__$1,(5),inst_129270);
} else {
if((state_val_129294 === (5))){
var inst_129272 = (state_129293[(2)]);
var inst_129273 = fluree.db.util.async.throw_err(inst_129272);
var inst_129274 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_129273);
var inst_129275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129276 = [inst_129273];
var inst_129277 = (new cljs.core.PersistentVector(null,1,(5),inst_129275,inst_129276,null));
var inst_129278 = cljs.core.count(inst_129277);
var inst_129279 = ((9) + inst_129278);
var inst_129280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129281 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129283 = [inst_129273];
var inst_129284 = (new cljs.core.PersistentVector(null,1,(5),inst_129282,inst_129283,null));
var inst_129285 = ["max",inst_129284,inst_129274];
var inst_129286 = cljs.core.PersistentHashMap.fromArrays(inst_129281,inst_129285);
var inst_129287 = [inst_129286,inst_129279];
var inst_129288 = (new cljs.core.PersistentVector(null,2,(5),inst_129280,inst_129287,null));
var inst_129289 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129288);
var state_129293__$1 = (function (){var statearr_129297 = state_129293;
(statearr_129297[(7)] = inst_129289);

return statearr_129297;
})();
var statearr_129298_129308 = state_129293__$1;
(statearr_129298_129308[(2)] = inst_129274);


cljs.core.async.impl.ioc_helpers.process_exception(state_129293__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129299 = [null,null,null,null,null,null,null,null];
(statearr_129299[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129299[(1)] = (1));

return statearr_129299;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129293){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129293);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129300){if((e129300 instanceof Object)){
var ex__109974__auto__ = e129300;
var statearr_129301_129309 = state_129293;
(statearr_129301_129309[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129293);

return cljs.core.cst$kw$recur;
} else {
throw e129300;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129310 = state_129293;
state_129293 = G__129310;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129302 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129302[(6)] = c__110077__auto__);

return statearr_129302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq129264){
var G__129265 = cljs.core.first(seq129264);
var seq129264__$1 = cljs.core.next(seq129264);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129265,seq129264__$1);
});

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129349 = arguments.length;
var i__4731__auto___129350 = (0);
while(true){
if((i__4731__auto___129350 < len__4730__auto___129349)){
args__4736__auto__.push((arguments[i__4731__auto___129350]));

var G__129351 = (i__4731__auto___129350 + (1));
i__4731__auto___129350 = G__129351;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129339){
var state_val_129340 = (state_129339[(1)]);
if((state_val_129340 === (1))){
var state_129339__$1 = state_129339;
var statearr_129341_129352 = state_129339__$1;
(statearr_129341_129352[(2)] = null);

(statearr_129341_129352[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129340 === (2))){
var inst_129337 = (state_129339[(2)]);
var state_129339__$1 = state_129339;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129339__$1,inst_129337);
} else {
if((state_val_129340 === (3))){
var inst_129313 = (state_129339[(2)]);
var state_129339__$1 = state_129339;
var statearr_129342_129353 = state_129339__$1;
(statearr_129342_129353[(2)] = inst_129313);


cljs.core.async.impl.ioc_helpers.process_exception(state_129339__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129340 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129339,(3),Error,null,(2));
var inst_129317 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129339__$1 = state_129339;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129339__$1,(5),inst_129317);
} else {
if((state_val_129340 === (5))){
var inst_129319 = (state_129339[(2)]);
var inst_129320 = fluree.db.util.async.throw_err(inst_129319);
var inst_129321 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_129320);
var inst_129322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129323 = [inst_129320];
var inst_129324 = (new cljs.core.PersistentVector(null,1,(5),inst_129322,inst_129323,null));
var inst_129325 = cljs.core.count(inst_129324);
var inst_129326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129327 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129329 = [inst_129320];
var inst_129330 = (new cljs.core.PersistentVector(null,1,(5),inst_129328,inst_129329,null));
var inst_129331 = ["min",inst_129330,inst_129321];
var inst_129332 = cljs.core.PersistentHashMap.fromArrays(inst_129327,inst_129331);
var inst_129333 = [inst_129332,inst_129325];
var inst_129334 = (new cljs.core.PersistentVector(null,2,(5),inst_129326,inst_129333,null));
var inst_129335 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129334);
var state_129339__$1 = (function (){var statearr_129343 = state_129339;
(statearr_129343[(7)] = inst_129335);

return statearr_129343;
})();
var statearr_129344_129354 = state_129339__$1;
(statearr_129344_129354[(2)] = inst_129321);


cljs.core.async.impl.ioc_helpers.process_exception(state_129339__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129345 = [null,null,null,null,null,null,null,null];
(statearr_129345[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129345[(1)] = (1));

return statearr_129345;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129339){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129339);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129346){if((e129346 instanceof Object)){
var ex__109974__auto__ = e129346;
var statearr_129347_129355 = state_129339;
(statearr_129347_129355[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129339);

return cljs.core.cst$kw$recur;
} else {
throw e129346;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129356 = state_129339;
state_129339 = G__129356;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129339){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129348 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129348[(6)] = c__110077__auto__);

return statearr_129348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq129311){
var G__129312 = cljs.core.first(seq129311);
var seq129311__$1 = cljs.core.next(seq129311);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129312,seq129311__$1);
});

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__129358 = arguments.length;
switch (G__129358) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129400){
var state_val_129401 = (state_129400[(1)]);
if((state_val_129401 === (7))){
var inst_129373 = (state_129400[(7)]);
var inst_129373__$1 = (state_129400[(2)]);
var inst_129374 = typeof inst_129373__$1 === 'string';
var state_129400__$1 = (function (){var statearr_129402 = state_129400;
(statearr_129402[(7)] = inst_129373__$1);

return statearr_129402;
})();
if(cljs.core.truth_(inst_129374)){
var statearr_129403_129522 = state_129400__$1;
(statearr_129403_129522[(1)] = (9));

} else {
var statearr_129404_129523 = state_129400__$1;
(statearr_129404_129523[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (1))){
var state_129400__$1 = state_129400;
var statearr_129405_129524 = state_129400__$1;
(statearr_129405_129524[(2)] = null);

(statearr_129405_129524[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129400,(3),Error,null,(2));
var inst_129366 = fluree.db.util.async.channel_QMARK_(query_map);
var state_129400__$1 = state_129400;
if(inst_129366){
var statearr_129406_129525 = state_129400__$1;
(statearr_129406_129525[(1)] = (5));

} else {
var statearr_129407_129526 = state_129400__$1;
(statearr_129407_129526[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (6))){
var state_129400__$1 = state_129400;
var statearr_129408_129527 = state_129400__$1;
(statearr_129408_129527[(2)] = query_map);

(statearr_129408_129527[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (3))){
var inst_129359 = (state_129400[(2)]);
var state_129400__$1 = state_129400;
var statearr_129409_129528 = state_129400__$1;
(statearr_129409_129528[(2)] = inst_129359);


cljs.core.async.impl.ioc_helpers.process_exception(state_129400__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (12))){
var inst_129379 = (state_129400[(8)]);
var inst_129383 = (state_129400[(2)]);
var inst_129384 = fluree.db.util.async.throw_err(inst_129383);
var inst_129385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129384,(0),null);
var inst_129386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129384,(1),null);
var inst_129387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129388 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129390 = [inst_129379];
var inst_129391 = (new cljs.core.PersistentVector(null,1,(5),inst_129389,inst_129390,null));
var inst_129392 = ["query",inst_129391,inst_129385];
var inst_129393 = cljs.core.PersistentHashMap.fromArrays(inst_129388,inst_129392);
var inst_129394 = [inst_129393,inst_129386];
var inst_129395 = (new cljs.core.PersistentVector(null,2,(5),inst_129387,inst_129394,null));
var inst_129396 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129395);
var state_129400__$1 = (function (){var statearr_129410 = state_129400;
(statearr_129410[(9)] = inst_129396);

return statearr_129410;
})();
var statearr_129411_129529 = state_129400__$1;
(statearr_129411_129529[(2)] = inst_129385);


cljs.core.async.impl.ioc_helpers.process_exception(state_129400__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (2))){
var inst_129398 = (state_129400[(2)]);
var state_129400__$1 = state_129400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129400__$1,inst_129398);
} else {
if((state_val_129401 === (11))){
var inst_129379 = (state_129400[(8)]);
var inst_129379__$1 = (state_129400[(2)]);
var inst_129380 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129381 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_129380,inst_129379__$1);
var state_129400__$1 = (function (){var statearr_129412 = state_129400;
(statearr_129412[(8)] = inst_129379__$1);

return statearr_129412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129400__$1,(12),inst_129381);
} else {
if((state_val_129401 === (9))){
var inst_129373 = (state_129400[(7)]);
var inst_129376 = fluree.db.util.json.parse(inst_129373);
var state_129400__$1 = state_129400;
var statearr_129413_129530 = state_129400__$1;
(statearr_129413_129530[(2)] = inst_129376);

(statearr_129413_129530[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (5))){
var state_129400__$1 = state_129400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129400__$1,(8),query_map);
} else {
if((state_val_129401 === (10))){
var inst_129373 = (state_129400[(7)]);
var state_129400__$1 = state_129400;
var statearr_129414_129531 = state_129400__$1;
(statearr_129414_129531[(2)] = inst_129373);

(statearr_129414_129531[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129401 === (8))){
var inst_129369 = (state_129400[(2)]);
var inst_129370 = fluree.db.util.async.throw_err(inst_129369);
var state_129400__$1 = state_129400;
var statearr_129415_129532 = state_129400__$1;
(statearr_129415_129532[(2)] = inst_129370);

(statearr_129415_129532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129416 = [null,null,null,null,null,null,null,null,null,null];
(statearr_129416[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129416[(1)] = (1));

return statearr_129416;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129400){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129400);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129417){if((e129417 instanceof Object)){
var ex__109974__auto__ = e129417;
var statearr_129418_129533 = state_129400;
(statearr_129418_129533[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129400);

return cljs.core.cst$kw$recur;
} else {
throw e129417;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129534 = state_129400;
state_129400 = G__129534;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129419 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129419[(6)] = c__110077__auto__);

return statearr_129419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129487){
var state_val_129488 = (state_129487[(1)]);
if((state_val_129488 === (7))){
var inst_129434 = (state_129487[(2)]);
var inst_129435 = fluree.db.util.async.channel_QMARK_(from);
var state_129487__$1 = (function (){var statearr_129489 = state_129487;
(statearr_129489[(7)] = inst_129434);

return statearr_129489;
})();
if(inst_129435){
var statearr_129490_129535 = state_129487__$1;
(statearr_129490_129535[(1)] = (9));

} else {
var statearr_129491_129536 = state_129487__$1;
(statearr_129491_129536[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (20))){
var inst_129454 = (state_129487[(2)]);
var inst_129455 = fluree.db.util.async.throw_err(inst_129454);
var state_129487__$1 = state_129487;
var statearr_129492_129537 = state_129487__$1;
(statearr_129492_129537[(2)] = inst_129455);

(statearr_129492_129537[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (1))){
var state_129487__$1 = state_129487;
var statearr_129493_129538 = state_129487__$1;
(statearr_129493_129538[(2)] = null);

(statearr_129493_129538[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (24))){
var inst_129462 = (state_129487[(2)]);
var inst_129463 = fluree.db.util.async.throw_err(inst_129462);
var state_129487__$1 = state_129487;
var statearr_129494_129539 = state_129487__$1;
(statearr_129494_129539[(2)] = inst_129463);

(statearr_129494_129539[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129487,(3),Error,null,(2));
var inst_129427 = fluree.db.util.async.channel_QMARK_(select);
var state_129487__$1 = state_129487;
if(inst_129427){
var statearr_129495_129540 = state_129487__$1;
(statearr_129495_129540[(1)] = (5));

} else {
var statearr_129496_129541 = state_129487__$1;
(statearr_129496_129541[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (15))){
var inst_129450 = (state_129487[(2)]);
var inst_129451 = fluree.db.util.async.channel_QMARK_(block);
var state_129487__$1 = (function (){var statearr_129497 = state_129487;
(statearr_129497[(8)] = inst_129450);

return statearr_129497;
})();
if(inst_129451){
var statearr_129498_129542 = state_129487__$1;
(statearr_129498_129542[(1)] = (17));

} else {
var statearr_129499_129543 = state_129487__$1;
(statearr_129499_129543[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (21))){
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(24),limit);
} else {
if((state_val_129488 === (13))){
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(16),where);
} else {
if((state_val_129488 === (22))){
var state_129487__$1 = state_129487;
var statearr_129500_129544 = state_129487__$1;
(statearr_129500_129544[(2)] = limit);

(statearr_129500_129544[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (6))){
var state_129487__$1 = state_129487;
var statearr_129501_129545 = state_129487__$1;
(statearr_129501_129545[(2)] = select);

(statearr_129501_129545[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (25))){
var inst_129458 = (state_129487[(9)]);
var inst_129434 = (state_129487[(7)]);
var inst_129442 = (state_129487[(10)]);
var inst_129450 = (state_129487[(8)]);
var inst_129470 = (state_129487[(2)]);
var inst_129471 = fluree.db.util.async.throw_err(inst_129470);
var inst_129472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129471,(0),null);
var inst_129473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129471,(1),null);
var inst_129474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129475 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129477 = [inst_129434,inst_129442,inst_129450,inst_129458];
var inst_129478 = (new cljs.core.PersistentVector(null,4,(5),inst_129476,inst_129477,null));
var inst_129479 = ["query",inst_129478,inst_129472];
var inst_129480 = cljs.core.PersistentHashMap.fromArrays(inst_129475,inst_129479);
var inst_129481 = [inst_129480,inst_129473];
var inst_129482 = (new cljs.core.PersistentVector(null,2,(5),inst_129474,inst_129481,null));
var inst_129483 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129482);
var state_129487__$1 = (function (){var statearr_129502 = state_129487;
(statearr_129502[(11)] = inst_129483);

return statearr_129502;
})();
var statearr_129503_129546 = state_129487__$1;
(statearr_129503_129546[(2)] = inst_129472);


cljs.core.async.impl.ioc_helpers.process_exception(state_129487__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (17))){
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(20),block);
} else {
if((state_val_129488 === (3))){
var inst_129420 = (state_129487[(2)]);
var state_129487__$1 = state_129487;
var statearr_129504_129547 = state_129487__$1;
(statearr_129504_129547[(2)] = inst_129420);


cljs.core.async.impl.ioc_helpers.process_exception(state_129487__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (12))){
var inst_129438 = (state_129487[(2)]);
var inst_129439 = fluree.db.util.async.throw_err(inst_129438);
var state_129487__$1 = state_129487;
var statearr_129505_129548 = state_129487__$1;
(statearr_129505_129548[(2)] = inst_129439);

(statearr_129505_129548[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (2))){
var inst_129485 = (state_129487[(2)]);
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129487__$1,inst_129485);
} else {
if((state_val_129488 === (23))){
var inst_129458 = (state_129487[(9)]);
var inst_129434 = (state_129487[(7)]);
var inst_129442 = (state_129487[(10)]);
var inst_129450 = (state_129487[(8)]);
var inst_129466 = (state_129487[(2)]);
var inst_129467 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129468 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_129467,inst_129434,inst_129442,inst_129450,inst_129458,inst_129466);
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(25),inst_129468);
} else {
if((state_val_129488 === (19))){
var inst_129458 = (state_129487[(2)]);
var inst_129459 = fluree.db.util.async.channel_QMARK_(limit);
var state_129487__$1 = (function (){var statearr_129506 = state_129487;
(statearr_129506[(9)] = inst_129458);

return statearr_129506;
})();
if(inst_129459){
var statearr_129507_129549 = state_129487__$1;
(statearr_129507_129549[(1)] = (21));

} else {
var statearr_129508_129550 = state_129487__$1;
(statearr_129508_129550[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (11))){
var inst_129442 = (state_129487[(2)]);
var inst_129443 = fluree.db.util.async.channel_QMARK_(where);
var state_129487__$1 = (function (){var statearr_129509 = state_129487;
(statearr_129509[(10)] = inst_129442);

return statearr_129509;
})();
if(inst_129443){
var statearr_129510_129551 = state_129487__$1;
(statearr_129510_129551[(1)] = (13));

} else {
var statearr_129511_129552 = state_129487__$1;
(statearr_129511_129552[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (9))){
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(12),from);
} else {
if((state_val_129488 === (5))){
var state_129487__$1 = state_129487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129487__$1,(8),select);
} else {
if((state_val_129488 === (14))){
var state_129487__$1 = state_129487;
var statearr_129512_129553 = state_129487__$1;
(statearr_129512_129553[(2)] = where);

(statearr_129512_129553[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (16))){
var inst_129446 = (state_129487[(2)]);
var inst_129447 = fluree.db.util.async.throw_err(inst_129446);
var state_129487__$1 = state_129487;
var statearr_129513_129554 = state_129487__$1;
(statearr_129513_129554[(2)] = inst_129447);

(statearr_129513_129554[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (10))){
var state_129487__$1 = state_129487;
var statearr_129514_129555 = state_129487__$1;
(statearr_129514_129555[(2)] = from);

(statearr_129514_129555[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (18))){
var state_129487__$1 = state_129487;
var statearr_129515_129556 = state_129487__$1;
(statearr_129515_129556[(2)] = block);

(statearr_129515_129556[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129488 === (8))){
var inst_129430 = (state_129487[(2)]);
var inst_129431 = fluree.db.util.async.throw_err(inst_129430);
var state_129487__$1 = state_129487;
var statearr_129516_129557 = state_129487__$1;
(statearr_129516_129557[(2)] = inst_129431);

(statearr_129516_129557[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129517 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_129517[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129517[(1)] = (1));

return statearr_129517;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129487){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129487);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129518){if((e129518 instanceof Object)){
var ex__109974__auto__ = e129518;
var statearr_129519_129558 = state_129487;
(statearr_129519_129558[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129487);

return cljs.core.cst$kw$recur;
} else {
throw e129518;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129559 = state_129487;
state_129487 = G__129559;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129487){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129520 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129520[(6)] = c__110077__auto__);

return statearr_129520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6;

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129612){
var state_val_129613 = (state_129612[(1)]);
if((state_val_129613 === (7))){
var inst_129574 = (state_129612[(2)]);
var inst_129575 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_129612__$1 = (function (){var statearr_129614 = state_129612;
(statearr_129614[(7)] = inst_129574);

return statearr_129614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129612__$1,(9),inst_129575);
} else {
if((state_val_129613 === (1))){
var state_129612__$1 = state_129612;
var statearr_129615_129638 = state_129612__$1;
(statearr_129615_129638[(2)] = null);

(statearr_129615_129638[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129612,(3),Error,null,(2));
var inst_129567 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_129612__$1 = state_129612;
if(inst_129567){
var statearr_129616_129639 = state_129612__$1;
(statearr_129616_129639[(1)] = (5));

} else {
var statearr_129617_129640 = state_129612__$1;
(statearr_129617_129640[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (15))){
var state_129612__$1 = state_129612;
var statearr_129618_129641 = state_129612__$1;
(statearr_129618_129641[(2)] = false);

(statearr_129618_129641[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (13))){
var inst_129582 = (state_129612[(2)]);
var inst_129583 = fluree.db.util.async.throw_err(inst_129582);
var state_129612__$1 = state_129612;
var statearr_129619_129642 = state_129612__$1;
(statearr_129619_129642[(2)] = inst_129583);

(statearr_129619_129642[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (6))){
var state_129612__$1 = state_129612;
var statearr_129620_129643 = state_129612__$1;
(statearr_129620_129643[(2)] = startSubject);

(statearr_129620_129643[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (17))){
var inst_129574 = (state_129612[(7)]);
var inst_129578 = (state_129612[(8)]);
var inst_129593 = (state_129612[(9)]);
var inst_129586 = (state_129612[(10)]);
var inst_129598 = (state_129612[(2)]);
var inst_129599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129600 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129602 = [inst_129574,inst_129578,inst_129586];
var inst_129603 = (new cljs.core.PersistentVector(null,3,(5),inst_129601,inst_129602,null));
var inst_129604 = ["relationship?",inst_129603,inst_129598];
var inst_129605 = cljs.core.PersistentHashMap.fromArrays(inst_129600,inst_129604);
var inst_129606 = [inst_129605,inst_129593];
var inst_129607 = (new cljs.core.PersistentVector(null,2,(5),inst_129599,inst_129606,null));
var inst_129608 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129607);
var state_129612__$1 = (function (){var statearr_129621 = state_129612;
(statearr_129621[(11)] = inst_129608);

return statearr_129621;
})();
var statearr_129622_129644 = state_129612__$1;
(statearr_129622_129644[(2)] = inst_129598);


cljs.core.async.impl.ioc_helpers.process_exception(state_129612__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (3))){
var inst_129560 = (state_129612[(2)]);
var state_129612__$1 = state_129612;
var statearr_129623_129645 = state_129612__$1;
(statearr_129623_129645[(2)] = inst_129560);


cljs.core.async.impl.ioc_helpers.process_exception(state_129612__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (12))){
var inst_129574 = (state_129612[(7)]);
var inst_129578 = (state_129612[(8)]);
var inst_129586 = (state_129612[(10)]);
var inst_129586__$1 = (state_129612[(2)]);
var inst_129587 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129588 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_129587,inst_129574,inst_129578,inst_129586__$1);
var state_129612__$1 = (function (){var statearr_129624 = state_129612;
(statearr_129624[(10)] = inst_129586__$1);

return statearr_129624;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129612__$1,(14),inst_129588);
} else {
if((state_val_129613 === (2))){
var inst_129610 = (state_129612[(2)]);
var state_129612__$1 = state_129612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129612__$1,inst_129610);
} else {
if((state_val_129613 === (11))){
var state_129612__$1 = state_129612;
var statearr_129625_129646 = state_129612__$1;
(statearr_129625_129646[(2)] = endSubject);

(statearr_129625_129646[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (9))){
var inst_129577 = (state_129612[(2)]);
var inst_129578 = fluree.db.util.async.throw_err(inst_129577);
var inst_129579 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_129612__$1 = (function (){var statearr_129626 = state_129612;
(statearr_129626[(8)] = inst_129578);

return statearr_129626;
})();
if(inst_129579){
var statearr_129627_129647 = state_129612__$1;
(statearr_129627_129647[(1)] = (10));

} else {
var statearr_129628_129648 = state_129612__$1;
(statearr_129628_129648[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (5))){
var state_129612__$1 = state_129612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129612__$1,(8),startSubject);
} else {
if((state_val_129613 === (14))){
var inst_129590 = (state_129612[(2)]);
var inst_129591 = fluree.db.util.async.throw_err(inst_129590);
var inst_129592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129591,(0),null);
var inst_129593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129591,(1),null);
var inst_129594 = cljs.core.empty_QMARK_(inst_129592);
var state_129612__$1 = (function (){var statearr_129629 = state_129612;
(statearr_129629[(9)] = inst_129593);

return statearr_129629;
})();
if(inst_129594){
var statearr_129630_129649 = state_129612__$1;
(statearr_129630_129649[(1)] = (15));

} else {
var statearr_129631_129650 = state_129612__$1;
(statearr_129631_129650[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (16))){
var state_129612__$1 = state_129612;
var statearr_129632_129651 = state_129612__$1;
(statearr_129632_129651[(2)] = true);

(statearr_129632_129651[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129613 === (10))){
var state_129612__$1 = state_129612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129612__$1,(13),endSubject);
} else {
if((state_val_129613 === (8))){
var inst_129570 = (state_129612[(2)]);
var inst_129571 = fluree.db.util.async.throw_err(inst_129570);
var state_129612__$1 = state_129612;
var statearr_129633_129652 = state_129612__$1;
(statearr_129633_129652[(2)] = inst_129571);

(statearr_129633_129652[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_129634 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_129634[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__);

(statearr_129634[(1)] = (1));

return statearr_129634;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____1 = (function (state_129612){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129612);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129635){if((e129635 instanceof Object)){
var ex__109974__auto__ = e129635;
var statearr_129636_129653 = state_129612;
(statearr_129636_129653[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129612);

return cljs.core.cst$kw$recur;
} else {
throw e129635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129654 = state_129612;
state_129612 = G__129654;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__ = function(state_129612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____1.call(this,state_129612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129637 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129637[(6)] = c__110077__auto__);

return statearr_129637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129688){
var state_val_129689 = (state_129688[(1)]);
if((state_val_129689 === (7))){
var inst_129669 = (state_129688[(7)]);
var inst_129669__$1 = (state_129688[(2)]);
var inst_129670 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129671 = fluree.db.dbfunctions.internal.max_pred_val(inst_129670,inst_129669__$1);
var state_129688__$1 = (function (){var statearr_129690 = state_129688;
(statearr_129690[(7)] = inst_129669__$1);

return statearr_129690;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129688__$1,(9),inst_129671);
} else {
if((state_val_129689 === (1))){
var state_129688__$1 = state_129688;
var statearr_129691_129703 = state_129688__$1;
(statearr_129691_129703[(2)] = null);

(statearr_129691_129703[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129689 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129688,(3),Error,null,(2));
var inst_129662 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_129688__$1 = state_129688;
if(inst_129662){
var statearr_129692_129704 = state_129688__$1;
(statearr_129692_129704[(1)] = (5));

} else {
var statearr_129693_129705 = state_129688__$1;
(statearr_129693_129705[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129689 === (6))){
var state_129688__$1 = state_129688;
var statearr_129694_129706 = state_129688__$1;
(statearr_129694_129706[(2)] = pred_name);

(statearr_129694_129706[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129689 === (3))){
var inst_129655 = (state_129688[(2)]);
var state_129688__$1 = state_129688;
var statearr_129695_129707 = state_129688__$1;
(statearr_129695_129707[(2)] = inst_129655);


cljs.core.async.impl.ioc_helpers.process_exception(state_129688__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129689 === (2))){
var inst_129686 = (state_129688[(2)]);
var state_129688__$1 = state_129688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129688__$1,inst_129686);
} else {
if((state_val_129689 === (9))){
var inst_129669 = (state_129688[(7)]);
var inst_129673 = (state_129688[(2)]);
var inst_129674 = fluree.db.util.async.throw_err(inst_129673);
var inst_129675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129674,(0),null);
var inst_129676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_129674,(1),null);
var inst_129677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129678 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129679 = ["max-pred-val",inst_129669,inst_129675];
var inst_129680 = cljs.core.PersistentHashMap.fromArrays(inst_129678,inst_129679);
var inst_129681 = (inst_129676 + (10));
var inst_129682 = [inst_129680,inst_129681];
var inst_129683 = (new cljs.core.PersistentVector(null,2,(5),inst_129677,inst_129682,null));
var inst_129684 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129683);
var state_129688__$1 = (function (){var statearr_129696 = state_129688;
(statearr_129696[(8)] = inst_129684);

return statearr_129696;
})();
var statearr_129697_129708 = state_129688__$1;
(statearr_129697_129708[(2)] = inst_129675);


cljs.core.async.impl.ioc_helpers.process_exception(state_129688__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129689 === (5))){
var state_129688__$1 = state_129688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129688__$1,(8),pred_name);
} else {
if((state_val_129689 === (8))){
var inst_129665 = (state_129688[(2)]);
var inst_129666 = fluree.db.util.async.throw_err(inst_129665);
var state_129688__$1 = state_129688;
var statearr_129698_129709 = state_129688__$1;
(statearr_129698_129709[(2)] = inst_129666);

(statearr_129698_129709[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____0 = (function (){
var statearr_129699 = [null,null,null,null,null,null,null,null,null];
(statearr_129699[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__);

(statearr_129699[(1)] = (1));

return statearr_129699;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____1 = (function (state_129688){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129688);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129700){if((e129700 instanceof Object)){
var ex__109974__auto__ = e129700;
var statearr_129701_129710 = state_129688;
(statearr_129701_129710[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129688);

return cljs.core.cst$kw$recur;
} else {
throw e129700;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129711 = state_129688;
state_129688 = G__129711;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__ = function(state_129688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____1.call(this,state_129688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129702 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129702[(6)] = c__110077__auto__);

return statearr_129702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129735){
var state_val_129736 = (state_129735[(1)]);
if((state_val_129736 === (1))){
var state_129735__$1 = state_129735;
var statearr_129737_129749 = state_129735__$1;
(statearr_129737_129749[(2)] = null);

(statearr_129737_129749[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129736 === (2))){
var inst_129733 = (state_129735[(2)]);
var state_129735__$1 = state_129735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129735__$1,inst_129733);
} else {
if((state_val_129736 === (3))){
var inst_129712 = (state_129735[(2)]);
var state_129735__$1 = state_129735;
var statearr_129738_129750 = state_129735__$1;
(statearr_129738_129750[(2)] = inst_129712);


cljs.core.async.impl.ioc_helpers.process_exception(state_129735__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129736 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129735,(3),Error,null,(2));
var inst_129716 = fluree.db.util.async.channel_QMARK_(n);
var state_129735__$1 = state_129735;
if(inst_129716){
var statearr_129739_129751 = state_129735__$1;
(statearr_129739_129751[(1)] = (5));

} else {
var statearr_129740_129752 = state_129735__$1;
(statearr_129740_129752[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129736 === (5))){
var state_129735__$1 = state_129735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129735__$1,(8),n);
} else {
if((state_val_129736 === (6))){
var state_129735__$1 = state_129735;
var statearr_129741_129753 = state_129735__$1;
(statearr_129741_129753[(2)] = n);

(statearr_129741_129753[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129736 === (7))){
var inst_129723 = (state_129735[(2)]);
var inst_129724 = fluree.db.dbfunctions.internal.inc(inst_129723);
var inst_129725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129726 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129727 = ["inc",inst_129723,inst_129724];
var inst_129728 = cljs.core.PersistentHashMap.fromArrays(inst_129726,inst_129727);
var inst_129729 = [inst_129728,(10)];
var inst_129730 = (new cljs.core.PersistentVector(null,2,(5),inst_129725,inst_129729,null));
var inst_129731 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129730);
var state_129735__$1 = (function (){var statearr_129742 = state_129735;
(statearr_129742[(7)] = inst_129731);

return statearr_129742;
})();
var statearr_129743_129754 = state_129735__$1;
(statearr_129743_129754[(2)] = inst_129724);


cljs.core.async.impl.ioc_helpers.process_exception(state_129735__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129736 === (8))){
var inst_129719 = (state_129735[(2)]);
var inst_129720 = fluree.db.util.async.throw_err(inst_129719);
var state_129735__$1 = state_129735;
var statearr_129744_129755 = state_129735__$1;
(statearr_129744_129755[(2)] = inst_129720);

(statearr_129744_129755[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____0 = (function (){
var statearr_129745 = [null,null,null,null,null,null,null,null];
(statearr_129745[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__);

(statearr_129745[(1)] = (1));

return statearr_129745;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____1 = (function (state_129735){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129735);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129746){if((e129746 instanceof Object)){
var ex__109974__auto__ = e129746;
var statearr_129747_129756 = state_129735;
(statearr_129747_129756[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129735);

return cljs.core.cst$kw$recur;
} else {
throw e129746;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129757 = state_129735;
state_129735 = G__129757;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__ = function(state_129735){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____1.call(this,state_129735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129748 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129748[(6)] = c__110077__auto__);

return statearr_129748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129781){
var state_val_129782 = (state_129781[(1)]);
if((state_val_129782 === (1))){
var state_129781__$1 = state_129781;
var statearr_129783_129795 = state_129781__$1;
(statearr_129783_129795[(2)] = null);

(statearr_129783_129795[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129782 === (2))){
var inst_129779 = (state_129781[(2)]);
var state_129781__$1 = state_129781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129781__$1,inst_129779);
} else {
if((state_val_129782 === (3))){
var inst_129758 = (state_129781[(2)]);
var state_129781__$1 = state_129781;
var statearr_129784_129796 = state_129781__$1;
(statearr_129784_129796[(2)] = inst_129758);


cljs.core.async.impl.ioc_helpers.process_exception(state_129781__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129782 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129781,(3),Error,null,(2));
var inst_129762 = fluree.db.util.async.channel_QMARK_(n);
var state_129781__$1 = state_129781;
if(inst_129762){
var statearr_129785_129797 = state_129781__$1;
(statearr_129785_129797[(1)] = (5));

} else {
var statearr_129786_129798 = state_129781__$1;
(statearr_129786_129798[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_129782 === (5))){
var state_129781__$1 = state_129781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129781__$1,(8),n);
} else {
if((state_val_129782 === (6))){
var state_129781__$1 = state_129781;
var statearr_129787_129799 = state_129781__$1;
(statearr_129787_129799[(2)] = n);

(statearr_129787_129799[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129782 === (7))){
var inst_129769 = (state_129781[(2)]);
var inst_129770 = fluree.db.dbfunctions.internal.dec(inst_129769);
var inst_129771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129772 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129773 = ["dec",inst_129769,inst_129770];
var inst_129774 = cljs.core.PersistentHashMap.fromArrays(inst_129772,inst_129773);
var inst_129775 = [inst_129774,(10)];
var inst_129776 = (new cljs.core.PersistentVector(null,2,(5),inst_129771,inst_129775,null));
var inst_129777 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129776);
var state_129781__$1 = (function (){var statearr_129788 = state_129781;
(statearr_129788[(7)] = inst_129777);

return statearr_129788;
})();
var statearr_129789_129800 = state_129781__$1;
(statearr_129789_129800[(2)] = inst_129770);


cljs.core.async.impl.ioc_helpers.process_exception(state_129781__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129782 === (8))){
var inst_129765 = (state_129781[(2)]);
var inst_129766 = fluree.db.util.async.throw_err(inst_129765);
var state_129781__$1 = state_129781;
var statearr_129790_129801 = state_129781__$1;
(statearr_129790_129801[(2)] = inst_129766);

(statearr_129790_129801[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____0 = (function (){
var statearr_129791 = [null,null,null,null,null,null,null,null];
(statearr_129791[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__);

(statearr_129791[(1)] = (1));

return statearr_129791;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____1 = (function (state_129781){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129781);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129792){if((e129792 instanceof Object)){
var ex__109974__auto__ = e129792;
var statearr_129793_129802 = state_129781;
(statearr_129793_129802[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129781);

return cljs.core.cst$kw$recur;
} else {
throw e129792;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129803 = state_129781;
state_129781 = G__129803;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__ = function(state_129781){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____1.call(this,state_129781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129794 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129794[(6)] = c__110077__auto__);

return statearr_129794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129843 = arguments.length;
var i__4731__auto___129844 = (0);
while(true){
if((i__4731__auto___129844 < len__4730__auto___129843)){
args__4736__auto__.push((arguments[i__4731__auto___129844]));

var G__129845 = (i__4731__auto___129844 + (1));
i__4731__auto___129844 = G__129845;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129833){
var state_val_129834 = (state_129833[(1)]);
if((state_val_129834 === (1))){
var state_129833__$1 = state_129833;
var statearr_129835_129846 = state_129833__$1;
(statearr_129835_129846[(2)] = null);

(statearr_129835_129846[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129834 === (2))){
var inst_129831 = (state_129833[(2)]);
var state_129833__$1 = state_129833;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129833__$1,inst_129831);
} else {
if((state_val_129834 === (3))){
var inst_129806 = (state_129833[(2)]);
var state_129833__$1 = state_129833;
var statearr_129836_129847 = state_129833__$1;
(statearr_129836_129847[(2)] = inst_129806);


cljs.core.async.impl.ioc_helpers.process_exception(state_129833__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129834 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129833,(3),Error,null,(2));
var inst_129810 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129833__$1 = state_129833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129833__$1,(5),inst_129810);
} else {
if((state_val_129834 === (5))){
var inst_129812 = (state_129833[(2)]);
var inst_129813 = fluree.db.util.async.throw_err(inst_129812);
var inst_129814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_129813);
var inst_129815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129816 = [inst_129813];
var inst_129817 = (new cljs.core.PersistentVector(null,1,(5),inst_129815,inst_129816,null));
var inst_129818 = cljs.core.count(inst_129817);
var inst_129819 = ((9) + inst_129818);
var inst_129820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129821 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129823 = [inst_129813];
var inst_129824 = (new cljs.core.PersistentVector(null,1,(5),inst_129822,inst_129823,null));
var inst_129825 = ["+",inst_129824,inst_129814];
var inst_129826 = cljs.core.PersistentHashMap.fromArrays(inst_129821,inst_129825);
var inst_129827 = [inst_129826,inst_129819];
var inst_129828 = (new cljs.core.PersistentVector(null,2,(5),inst_129820,inst_129827,null));
var inst_129829 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129828);
var state_129833__$1 = (function (){var statearr_129837 = state_129833;
(statearr_129837[(7)] = inst_129829);

return statearr_129837;
})();
var statearr_129838_129848 = state_129833__$1;
(statearr_129838_129848[(2)] = inst_129814);


cljs.core.async.impl.ioc_helpers.process_exception(state_129833__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129839 = [null,null,null,null,null,null,null,null];
(statearr_129839[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129839[(1)] = (1));

return statearr_129839;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129833){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129833);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129840){if((e129840 instanceof Object)){
var ex__109974__auto__ = e129840;
var statearr_129841_129849 = state_129833;
(statearr_129841_129849[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129833);

return cljs.core.cst$kw$recur;
} else {
throw e129840;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129850 = state_129833;
state_129833 = G__129850;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129833){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129842 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129842[(6)] = c__110077__auto__);

return statearr_129842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq129804){
var G__129805 = cljs.core.first(seq129804);
var seq129804__$1 = cljs.core.next(seq129804);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129805,seq129804__$1);
});

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129890 = arguments.length;
var i__4731__auto___129891 = (0);
while(true){
if((i__4731__auto___129891 < len__4730__auto___129890)){
args__4736__auto__.push((arguments[i__4731__auto___129891]));

var G__129892 = (i__4731__auto___129891 + (1));
i__4731__auto___129891 = G__129892;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129880){
var state_val_129881 = (state_129880[(1)]);
if((state_val_129881 === (1))){
var state_129880__$1 = state_129880;
var statearr_129882_129893 = state_129880__$1;
(statearr_129882_129893[(2)] = null);

(statearr_129882_129893[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129881 === (2))){
var inst_129878 = (state_129880[(2)]);
var state_129880__$1 = state_129880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129880__$1,inst_129878);
} else {
if((state_val_129881 === (3))){
var inst_129853 = (state_129880[(2)]);
var state_129880__$1 = state_129880;
var statearr_129883_129894 = state_129880__$1;
(statearr_129883_129894[(2)] = inst_129853);


cljs.core.async.impl.ioc_helpers.process_exception(state_129880__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129881 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129880,(3),Error,null,(2));
var inst_129857 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129880__$1 = state_129880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129880__$1,(5),inst_129857);
} else {
if((state_val_129881 === (5))){
var inst_129859 = (state_129880[(2)]);
var inst_129860 = fluree.db.util.async.throw_err(inst_129859);
var inst_129861 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_129860);
var inst_129862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129863 = [inst_129860];
var inst_129864 = (new cljs.core.PersistentVector(null,1,(5),inst_129862,inst_129863,null));
var inst_129865 = cljs.core.count(inst_129864);
var inst_129866 = ((9) + inst_129865);
var inst_129867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129868 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129870 = [inst_129860];
var inst_129871 = (new cljs.core.PersistentVector(null,1,(5),inst_129869,inst_129870,null));
var inst_129872 = ["-",inst_129871,inst_129861];
var inst_129873 = cljs.core.PersistentHashMap.fromArrays(inst_129868,inst_129872);
var inst_129874 = [inst_129873,inst_129866];
var inst_129875 = (new cljs.core.PersistentVector(null,2,(5),inst_129867,inst_129874,null));
var inst_129876 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129875);
var state_129880__$1 = (function (){var statearr_129884 = state_129880;
(statearr_129884[(7)] = inst_129876);

return statearr_129884;
})();
var statearr_129885_129895 = state_129880__$1;
(statearr_129885_129895[(2)] = inst_129861);


cljs.core.async.impl.ioc_helpers.process_exception(state_129880__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129886 = [null,null,null,null,null,null,null,null];
(statearr_129886[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129886[(1)] = (1));

return statearr_129886;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129880){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129880);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129887){if((e129887 instanceof Object)){
var ex__109974__auto__ = e129887;
var statearr_129888_129896 = state_129880;
(statearr_129888_129896[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129880);

return cljs.core.cst$kw$recur;
} else {
throw e129887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129897 = state_129880;
state_129880 = G__129897;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129889 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129889[(6)] = c__110077__auto__);

return statearr_129889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq129851){
var G__129852 = cljs.core.first(seq129851);
var seq129851__$1 = cljs.core.next(seq129851);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129852,seq129851__$1);
});

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129937 = arguments.length;
var i__4731__auto___129938 = (0);
while(true){
if((i__4731__auto___129938 < len__4730__auto___129937)){
args__4736__auto__.push((arguments[i__4731__auto___129938]));

var G__129939 = (i__4731__auto___129938 + (1));
i__4731__auto___129938 = G__129939;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129927){
var state_val_129928 = (state_129927[(1)]);
if((state_val_129928 === (1))){
var state_129927__$1 = state_129927;
var statearr_129929_129940 = state_129927__$1;
(statearr_129929_129940[(2)] = null);

(statearr_129929_129940[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129928 === (2))){
var inst_129925 = (state_129927[(2)]);
var state_129927__$1 = state_129927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129927__$1,inst_129925);
} else {
if((state_val_129928 === (3))){
var inst_129900 = (state_129927[(2)]);
var state_129927__$1 = state_129927;
var statearr_129930_129941 = state_129927__$1;
(statearr_129930_129941[(2)] = inst_129900);


cljs.core.async.impl.ioc_helpers.process_exception(state_129927__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129928 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129927,(3),Error,null,(2));
var inst_129904 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129927__$1 = state_129927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129927__$1,(5),inst_129904);
} else {
if((state_val_129928 === (5))){
var inst_129906 = (state_129927[(2)]);
var inst_129907 = fluree.db.util.async.throw_err(inst_129906);
var inst_129908 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_129907);
var inst_129909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129910 = [inst_129907];
var inst_129911 = (new cljs.core.PersistentVector(null,1,(5),inst_129909,inst_129910,null));
var inst_129912 = cljs.core.count(inst_129911);
var inst_129913 = ((9) + inst_129912);
var inst_129914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129915 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129917 = [inst_129907];
var inst_129918 = (new cljs.core.PersistentVector(null,1,(5),inst_129916,inst_129917,null));
var inst_129919 = ["*",inst_129918,inst_129908];
var inst_129920 = cljs.core.PersistentHashMap.fromArrays(inst_129915,inst_129919);
var inst_129921 = [inst_129920,inst_129913];
var inst_129922 = (new cljs.core.PersistentVector(null,2,(5),inst_129914,inst_129921,null));
var inst_129923 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129922);
var state_129927__$1 = (function (){var statearr_129931 = state_129927;
(statearr_129931[(7)] = inst_129923);

return statearr_129931;
})();
var statearr_129932_129942 = state_129927__$1;
(statearr_129932_129942[(2)] = inst_129908);


cljs.core.async.impl.ioc_helpers.process_exception(state_129927__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129933 = [null,null,null,null,null,null,null,null];
(statearr_129933[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129933[(1)] = (1));

return statearr_129933;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129927){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129927);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129934){if((e129934 instanceof Object)){
var ex__109974__auto__ = e129934;
var statearr_129935_129943 = state_129927;
(statearr_129935_129943[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129927);

return cljs.core.cst$kw$recur;
} else {
throw e129934;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129944 = state_129927;
state_129927 = G__129944;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129936 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129936[(6)] = c__110077__auto__);

return statearr_129936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq129898){
var G__129899 = cljs.core.first(seq129898);
var seq129898__$1 = cljs.core.next(seq129898);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129899,seq129898__$1);
});

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___129984 = arguments.length;
var i__4731__auto___129985 = (0);
while(true){
if((i__4731__auto___129985 < len__4730__auto___129984)){
args__4736__auto__.push((arguments[i__4731__auto___129985]));

var G__129986 = (i__4731__auto___129985 + (1));
i__4731__auto___129985 = G__129986;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_129974){
var state_val_129975 = (state_129974[(1)]);
if((state_val_129975 === (1))){
var state_129974__$1 = state_129974;
var statearr_129976_129987 = state_129974__$1;
(statearr_129976_129987[(2)] = null);

(statearr_129976_129987[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_129975 === (2))){
var inst_129972 = (state_129974[(2)]);
var state_129974__$1 = state_129974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_129974__$1,inst_129972);
} else {
if((state_val_129975 === (3))){
var inst_129947 = (state_129974[(2)]);
var state_129974__$1 = state_129974;
var statearr_129977_129988 = state_129974__$1;
(statearr_129977_129988[(2)] = inst_129947);


cljs.core.async.impl.ioc_helpers.process_exception(state_129974__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_129975 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_129974,(3),Error,null,(2));
var inst_129951 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_129974__$1 = state_129974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_129974__$1,(5),inst_129951);
} else {
if((state_val_129975 === (5))){
var inst_129953 = (state_129974[(2)]);
var inst_129954 = fluree.db.util.async.throw_err(inst_129953);
var inst_129955 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_129954);
var inst_129956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129957 = [inst_129954];
var inst_129958 = (new cljs.core.PersistentVector(null,1,(5),inst_129956,inst_129957,null));
var inst_129959 = cljs.core.count(inst_129958);
var inst_129960 = ((9) + inst_129959);
var inst_129961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129962 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_129963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129964 = [inst_129954];
var inst_129965 = (new cljs.core.PersistentVector(null,1,(5),inst_129963,inst_129964,null));
var inst_129966 = ["/",inst_129965,inst_129955];
var inst_129967 = cljs.core.PersistentHashMap.fromArrays(inst_129962,inst_129966);
var inst_129968 = [inst_129967,inst_129960];
var inst_129969 = (new cljs.core.PersistentVector(null,2,(5),inst_129961,inst_129968,null));
var inst_129970 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_129969);
var state_129974__$1 = (function (){var statearr_129978 = state_129974;
(statearr_129978[(7)] = inst_129970);

return statearr_129978;
})();
var statearr_129979_129989 = state_129974__$1;
(statearr_129979_129989[(2)] = inst_129955);


cljs.core.async.impl.ioc_helpers.process_exception(state_129974__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_129980 = [null,null,null,null,null,null,null,null];
(statearr_129980[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_129980[(1)] = (1));

return statearr_129980;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_129974){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_129974);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e129981){if((e129981 instanceof Object)){
var ex__109974__auto__ = e129981;
var statearr_129982_129990 = state_129974;
(statearr_129982_129990[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_129974);

return cljs.core.cst$kw$recur;
} else {
throw e129981;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__129991 = state_129974;
state_129974 = G__129991;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_129974){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_129974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_129983 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_129983[(6)] = c__110077__auto__);

return statearr_129983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq129945){
var G__129946 = cljs.core.first(seq129945);
var seq129945__$1 = cljs.core.next(seq129945);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129946,seq129945__$1);
});

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130026){
var state_val_130027 = (state_130026[(1)]);
if((state_val_130027 === (7))){
var inst_130003 = (state_130026[(2)]);
var inst_130004 = fluree.db.util.async.channel_QMARK_(d);
var state_130026__$1 = (function (){var statearr_130028 = state_130026;
(statearr_130028[(7)] = inst_130003);

return statearr_130028;
})();
if(inst_130004){
var statearr_130029_130045 = state_130026__$1;
(statearr_130029_130045[(1)] = (9));

} else {
var statearr_130030_130046 = state_130026__$1;
(statearr_130030_130046[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (1))){
var state_130026__$1 = state_130026;
var statearr_130031_130047 = state_130026__$1;
(statearr_130031_130047[(2)] = null);

(statearr_130031_130047[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130026,(3),Error,null,(2));
var inst_129996 = fluree.db.util.async.channel_QMARK_(n);
var state_130026__$1 = state_130026;
if(inst_129996){
var statearr_130032_130048 = state_130026__$1;
(statearr_130032_130048[(1)] = (5));

} else {
var statearr_130033_130049 = state_130026__$1;
(statearr_130033_130049[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (6))){
var state_130026__$1 = state_130026;
var statearr_130034_130050 = state_130026__$1;
(statearr_130034_130050[(2)] = n);

(statearr_130034_130050[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (3))){
var inst_129992 = (state_130026[(2)]);
var state_130026__$1 = state_130026;
var statearr_130035_130051 = state_130026__$1;
(statearr_130035_130051[(2)] = inst_129992);


cljs.core.async.impl.ioc_helpers.process_exception(state_130026__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (12))){
var inst_130007 = (state_130026[(2)]);
var inst_130008 = fluree.db.util.async.throw_err(inst_130007);
var state_130026__$1 = state_130026;
var statearr_130036_130052 = state_130026__$1;
(statearr_130036_130052[(2)] = inst_130008);

(statearr_130036_130052[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (2))){
var inst_130024 = (state_130026[(2)]);
var state_130026__$1 = state_130026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130026__$1,inst_130024);
} else {
if((state_val_130027 === (11))){
var inst_130003 = (state_130026[(7)]);
var inst_130011 = (state_130026[(2)]);
var inst_130012 = fluree.db.dbfunctions.internal.quot(inst_130003,inst_130011);
var inst_130013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130014 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130016 = [inst_130003,inst_130011];
var inst_130017 = (new cljs.core.PersistentVector(null,2,(5),inst_130015,inst_130016,null));
var inst_130018 = ["quot",inst_130017,inst_130012];
var inst_130019 = cljs.core.PersistentHashMap.fromArrays(inst_130014,inst_130018);
var inst_130020 = [inst_130019,(2)];
var inst_130021 = (new cljs.core.PersistentVector(null,2,(5),inst_130013,inst_130020,null));
var inst_130022 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130021);
var state_130026__$1 = (function (){var statearr_130037 = state_130026;
(statearr_130037[(8)] = inst_130022);

return statearr_130037;
})();
var statearr_130038_130053 = state_130026__$1;
(statearr_130038_130053[(2)] = inst_130012);


cljs.core.async.impl.ioc_helpers.process_exception(state_130026__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (9))){
var state_130026__$1 = state_130026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130026__$1,(12),d);
} else {
if((state_val_130027 === (5))){
var state_130026__$1 = state_130026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130026__$1,(8),n);
} else {
if((state_val_130027 === (10))){
var state_130026__$1 = state_130026;
var statearr_130039_130054 = state_130026__$1;
(statearr_130039_130054[(2)] = d);

(statearr_130039_130054[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130027 === (8))){
var inst_129999 = (state_130026[(2)]);
var inst_130000 = fluree.db.util.async.throw_err(inst_129999);
var state_130026__$1 = state_130026;
var statearr_130040_130055 = state_130026__$1;
(statearr_130040_130055[(2)] = inst_130000);

(statearr_130040_130055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____0 = (function (){
var statearr_130041 = [null,null,null,null,null,null,null,null,null];
(statearr_130041[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__);

(statearr_130041[(1)] = (1));

return statearr_130041;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____1 = (function (state_130026){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130026);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130042){if((e130042 instanceof Object)){
var ex__109974__auto__ = e130042;
var statearr_130043_130056 = state_130026;
(statearr_130043_130056[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130026);

return cljs.core.cst$kw$recur;
} else {
throw e130042;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130057 = state_130026;
state_130026 = G__130057;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__ = function(state_130026){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____1.call(this,state_130026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130044 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130044[(6)] = c__110077__auto__);

return statearr_130044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130092){
var state_val_130093 = (state_130092[(1)]);
if((state_val_130093 === (7))){
var inst_130069 = (state_130092[(2)]);
var inst_130070 = fluree.db.util.async.channel_QMARK_(d);
var state_130092__$1 = (function (){var statearr_130094 = state_130092;
(statearr_130094[(7)] = inst_130069);

return statearr_130094;
})();
if(inst_130070){
var statearr_130095_130111 = state_130092__$1;
(statearr_130095_130111[(1)] = (9));

} else {
var statearr_130096_130112 = state_130092__$1;
(statearr_130096_130112[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (1))){
var state_130092__$1 = state_130092;
var statearr_130097_130113 = state_130092__$1;
(statearr_130097_130113[(2)] = null);

(statearr_130097_130113[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130092,(3),Error,null,(2));
var inst_130062 = fluree.db.util.async.channel_QMARK_(n);
var state_130092__$1 = state_130092;
if(inst_130062){
var statearr_130098_130114 = state_130092__$1;
(statearr_130098_130114[(1)] = (5));

} else {
var statearr_130099_130115 = state_130092__$1;
(statearr_130099_130115[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (6))){
var state_130092__$1 = state_130092;
var statearr_130100_130116 = state_130092__$1;
(statearr_130100_130116[(2)] = n);

(statearr_130100_130116[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (3))){
var inst_130058 = (state_130092[(2)]);
var state_130092__$1 = state_130092;
var statearr_130101_130117 = state_130092__$1;
(statearr_130101_130117[(2)] = inst_130058);


cljs.core.async.impl.ioc_helpers.process_exception(state_130092__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (12))){
var inst_130073 = (state_130092[(2)]);
var inst_130074 = fluree.db.util.async.throw_err(inst_130073);
var state_130092__$1 = state_130092;
var statearr_130102_130118 = state_130092__$1;
(statearr_130102_130118[(2)] = inst_130074);

(statearr_130102_130118[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (2))){
var inst_130090 = (state_130092[(2)]);
var state_130092__$1 = state_130092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130092__$1,inst_130090);
} else {
if((state_val_130093 === (11))){
var inst_130069 = (state_130092[(7)]);
var inst_130077 = (state_130092[(2)]);
var inst_130078 = fluree.db.dbfunctions.internal.mod(inst_130069,inst_130077);
var inst_130079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130080 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130082 = [inst_130069,inst_130077];
var inst_130083 = (new cljs.core.PersistentVector(null,2,(5),inst_130081,inst_130082,null));
var inst_130084 = ["mod",inst_130083,inst_130078];
var inst_130085 = cljs.core.PersistentHashMap.fromArrays(inst_130080,inst_130084);
var inst_130086 = [inst_130085,(2)];
var inst_130087 = (new cljs.core.PersistentVector(null,2,(5),inst_130079,inst_130086,null));
var inst_130088 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130087);
var state_130092__$1 = (function (){var statearr_130103 = state_130092;
(statearr_130103[(8)] = inst_130088);

return statearr_130103;
})();
var statearr_130104_130119 = state_130092__$1;
(statearr_130104_130119[(2)] = inst_130078);


cljs.core.async.impl.ioc_helpers.process_exception(state_130092__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (9))){
var state_130092__$1 = state_130092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130092__$1,(12),d);
} else {
if((state_val_130093 === (5))){
var state_130092__$1 = state_130092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130092__$1,(8),n);
} else {
if((state_val_130093 === (10))){
var state_130092__$1 = state_130092;
var statearr_130105_130120 = state_130092__$1;
(statearr_130105_130120[(2)] = d);

(statearr_130105_130120[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130093 === (8))){
var inst_130065 = (state_130092[(2)]);
var inst_130066 = fluree.db.util.async.throw_err(inst_130065);
var state_130092__$1 = state_130092;
var statearr_130106_130121 = state_130092__$1;
(statearr_130106_130121[(2)] = inst_130066);

(statearr_130106_130121[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____0 = (function (){
var statearr_130107 = [null,null,null,null,null,null,null,null,null];
(statearr_130107[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__);

(statearr_130107[(1)] = (1));

return statearr_130107;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____1 = (function (state_130092){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130092);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130108){if((e130108 instanceof Object)){
var ex__109974__auto__ = e130108;
var statearr_130109_130122 = state_130092;
(statearr_130109_130122[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130092);

return cljs.core.cst$kw$recur;
} else {
throw e130108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130123 = state_130092;
state_130092 = G__130123;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__ = function(state_130092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____1.call(this,state_130092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130110 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130110[(6)] = c__110077__auto__);

return statearr_130110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130158){
var state_val_130159 = (state_130158[(1)]);
if((state_val_130159 === (7))){
var inst_130135 = (state_130158[(2)]);
var inst_130136 = fluree.db.util.async.channel_QMARK_(d);
var state_130158__$1 = (function (){var statearr_130160 = state_130158;
(statearr_130160[(7)] = inst_130135);

return statearr_130160;
})();
if(inst_130136){
var statearr_130161_130177 = state_130158__$1;
(statearr_130161_130177[(1)] = (9));

} else {
var statearr_130162_130178 = state_130158__$1;
(statearr_130162_130178[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (1))){
var state_130158__$1 = state_130158;
var statearr_130163_130179 = state_130158__$1;
(statearr_130163_130179[(2)] = null);

(statearr_130163_130179[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130158,(3),Error,null,(2));
var inst_130128 = fluree.db.util.async.channel_QMARK_(n);
var state_130158__$1 = state_130158;
if(inst_130128){
var statearr_130164_130180 = state_130158__$1;
(statearr_130164_130180[(1)] = (5));

} else {
var statearr_130165_130181 = state_130158__$1;
(statearr_130165_130181[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (6))){
var state_130158__$1 = state_130158;
var statearr_130166_130182 = state_130158__$1;
(statearr_130166_130182[(2)] = n);

(statearr_130166_130182[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (3))){
var inst_130124 = (state_130158[(2)]);
var state_130158__$1 = state_130158;
var statearr_130167_130183 = state_130158__$1;
(statearr_130167_130183[(2)] = inst_130124);


cljs.core.async.impl.ioc_helpers.process_exception(state_130158__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (12))){
var inst_130139 = (state_130158[(2)]);
var inst_130140 = fluree.db.util.async.throw_err(inst_130139);
var state_130158__$1 = state_130158;
var statearr_130168_130184 = state_130158__$1;
(statearr_130168_130184[(2)] = inst_130140);

(statearr_130168_130184[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (2))){
var inst_130156 = (state_130158[(2)]);
var state_130158__$1 = state_130158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130158__$1,inst_130156);
} else {
if((state_val_130159 === (11))){
var inst_130135 = (state_130158[(7)]);
var inst_130143 = (state_130158[(2)]);
var inst_130144 = fluree.db.dbfunctions.internal.rem(inst_130135,inst_130143);
var inst_130145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130146 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130148 = [inst_130135,inst_130143];
var inst_130149 = (new cljs.core.PersistentVector(null,2,(5),inst_130147,inst_130148,null));
var inst_130150 = ["rem",inst_130149,inst_130144];
var inst_130151 = cljs.core.PersistentHashMap.fromArrays(inst_130146,inst_130150);
var inst_130152 = [inst_130151,(2)];
var inst_130153 = (new cljs.core.PersistentVector(null,2,(5),inst_130145,inst_130152,null));
var inst_130154 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130153);
var state_130158__$1 = (function (){var statearr_130169 = state_130158;
(statearr_130169[(8)] = inst_130154);

return statearr_130169;
})();
var statearr_130170_130185 = state_130158__$1;
(statearr_130170_130185[(2)] = inst_130144);


cljs.core.async.impl.ioc_helpers.process_exception(state_130158__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (9))){
var state_130158__$1 = state_130158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130158__$1,(12),d);
} else {
if((state_val_130159 === (5))){
var state_130158__$1 = state_130158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130158__$1,(8),n);
} else {
if((state_val_130159 === (10))){
var state_130158__$1 = state_130158;
var statearr_130171_130186 = state_130158__$1;
(statearr_130171_130186[(2)] = d);

(statearr_130171_130186[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130159 === (8))){
var inst_130131 = (state_130158[(2)]);
var inst_130132 = fluree.db.util.async.throw_err(inst_130131);
var state_130158__$1 = state_130158;
var statearr_130172_130187 = state_130158__$1;
(statearr_130172_130187[(2)] = inst_130132);

(statearr_130172_130187[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____0 = (function (){
var statearr_130173 = [null,null,null,null,null,null,null,null,null];
(statearr_130173[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__);

(statearr_130173[(1)] = (1));

return statearr_130173;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____1 = (function (state_130158){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130158);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130174){if((e130174 instanceof Object)){
var ex__109974__auto__ = e130174;
var statearr_130175_130188 = state_130158;
(statearr_130175_130188[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130158);

return cljs.core.cst$kw$recur;
} else {
throw e130174;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130189 = state_130158;
state_130158 = G__130189;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__ = function(state_130158){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____1.call(this,state_130158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130176 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130176[(6)] = c__110077__auto__);

return statearr_130176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130213){
var state_val_130214 = (state_130213[(1)]);
if((state_val_130214 === (1))){
var state_130213__$1 = state_130213;
var statearr_130215_130227 = state_130213__$1;
(statearr_130215_130227[(2)] = null);

(statearr_130215_130227[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130214 === (2))){
var inst_130211 = (state_130213[(2)]);
var state_130213__$1 = state_130213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130213__$1,inst_130211);
} else {
if((state_val_130214 === (3))){
var inst_130190 = (state_130213[(2)]);
var state_130213__$1 = state_130213;
var statearr_130216_130228 = state_130213__$1;
(statearr_130216_130228[(2)] = inst_130190);


cljs.core.async.impl.ioc_helpers.process_exception(state_130213__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130214 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130213,(3),Error,null,(2));
var inst_130194 = fluree.db.util.async.channel_QMARK_(x);
var state_130213__$1 = state_130213;
if(inst_130194){
var statearr_130217_130229 = state_130213__$1;
(statearr_130217_130229[(1)] = (5));

} else {
var statearr_130218_130230 = state_130213__$1;
(statearr_130218_130230[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130214 === (5))){
var state_130213__$1 = state_130213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130213__$1,(8),x);
} else {
if((state_val_130214 === (6))){
var state_130213__$1 = state_130213;
var statearr_130219_130231 = state_130213__$1;
(statearr_130219_130231[(2)] = x);

(statearr_130219_130231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130214 === (7))){
var inst_130201 = (state_130213[(2)]);
var inst_130202 = fluree.db.dbfunctions.internal.boolean$(inst_130201);
var inst_130203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130204 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130205 = ["boolean",inst_130201,inst_130202];
var inst_130206 = cljs.core.PersistentHashMap.fromArrays(inst_130204,inst_130205);
var inst_130207 = [inst_130206,(10)];
var inst_130208 = (new cljs.core.PersistentVector(null,2,(5),inst_130203,inst_130207,null));
var inst_130209 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130208);
var state_130213__$1 = (function (){var statearr_130220 = state_130213;
(statearr_130220[(7)] = inst_130209);

return statearr_130220;
})();
var statearr_130221_130232 = state_130213__$1;
(statearr_130221_130232[(2)] = inst_130202);


cljs.core.async.impl.ioc_helpers.process_exception(state_130213__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130214 === (8))){
var inst_130197 = (state_130213[(2)]);
var inst_130198 = fluree.db.util.async.throw_err(inst_130197);
var state_130213__$1 = state_130213;
var statearr_130222_130233 = state_130213__$1;
(statearr_130222_130233[(2)] = inst_130198);

(statearr_130222_130233[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____0 = (function (){
var statearr_130223 = [null,null,null,null,null,null,null,null];
(statearr_130223[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__);

(statearr_130223[(1)] = (1));

return statearr_130223;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____1 = (function (state_130213){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130213);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130224){if((e130224 instanceof Object)){
var ex__109974__auto__ = e130224;
var statearr_130225_130234 = state_130213;
(statearr_130225_130234[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130213);

return cljs.core.cst$kw$recur;
} else {
throw e130224;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130235 = state_130213;
state_130213 = G__130235;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__ = function(state_130213){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____1.call(this,state_130213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130226 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130226[(6)] = c__110077__auto__);

return statearr_130226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130270){
var state_val_130271 = (state_130270[(1)]);
if((state_val_130271 === (7))){
var inst_130247 = (state_130270[(2)]);
var inst_130248 = fluree.db.util.async.channel_QMARK_(string);
var state_130270__$1 = (function (){var statearr_130272 = state_130270;
(statearr_130272[(7)] = inst_130247);

return statearr_130272;
})();
if(inst_130248){
var statearr_130273_130289 = state_130270__$1;
(statearr_130273_130289[(1)] = (9));

} else {
var statearr_130274_130290 = state_130270__$1;
(statearr_130274_130290[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (1))){
var state_130270__$1 = state_130270;
var statearr_130275_130291 = state_130270__$1;
(statearr_130275_130291[(2)] = null);

(statearr_130275_130291[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130270,(3),Error,null,(2));
var inst_130240 = fluree.db.util.async.channel_QMARK_(pattern);
var state_130270__$1 = state_130270;
if(inst_130240){
var statearr_130276_130292 = state_130270__$1;
(statearr_130276_130292[(1)] = (5));

} else {
var statearr_130277_130293 = state_130270__$1;
(statearr_130277_130293[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (6))){
var state_130270__$1 = state_130270;
var statearr_130278_130294 = state_130270__$1;
(statearr_130278_130294[(2)] = pattern);

(statearr_130278_130294[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (3))){
var inst_130236 = (state_130270[(2)]);
var state_130270__$1 = state_130270;
var statearr_130279_130295 = state_130270__$1;
(statearr_130279_130295[(2)] = inst_130236);


cljs.core.async.impl.ioc_helpers.process_exception(state_130270__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (12))){
var inst_130251 = (state_130270[(2)]);
var inst_130252 = fluree.db.util.async.throw_err(inst_130251);
var state_130270__$1 = state_130270;
var statearr_130280_130296 = state_130270__$1;
(statearr_130280_130296[(2)] = inst_130252);

(statearr_130280_130296[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (2))){
var inst_130268 = (state_130270[(2)]);
var state_130270__$1 = state_130270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130270__$1,inst_130268);
} else {
if((state_val_130271 === (11))){
var inst_130247 = (state_130270[(7)]);
var inst_130255 = (state_130270[(2)]);
var inst_130256 = fluree.db.dbfunctions.internal.re_find(inst_130247,inst_130255);
var inst_130257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130258 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130260 = [inst_130247,inst_130255];
var inst_130261 = (new cljs.core.PersistentVector(null,2,(5),inst_130259,inst_130260,null));
var inst_130262 = ["re-find",inst_130261,inst_130256];
var inst_130263 = cljs.core.PersistentHashMap.fromArrays(inst_130258,inst_130262);
var inst_130264 = [inst_130263,(10)];
var inst_130265 = (new cljs.core.PersistentVector(null,2,(5),inst_130257,inst_130264,null));
var inst_130266 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130265);
var state_130270__$1 = (function (){var statearr_130281 = state_130270;
(statearr_130281[(8)] = inst_130266);

return statearr_130281;
})();
var statearr_130282_130297 = state_130270__$1;
(statearr_130282_130297[(2)] = inst_130256);


cljs.core.async.impl.ioc_helpers.process_exception(state_130270__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (9))){
var state_130270__$1 = state_130270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130270__$1,(12),string);
} else {
if((state_val_130271 === (5))){
var state_130270__$1 = state_130270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130270__$1,(8),pattern);
} else {
if((state_val_130271 === (10))){
var state_130270__$1 = state_130270;
var statearr_130283_130298 = state_130270__$1;
(statearr_130283_130298[(2)] = string);

(statearr_130283_130298[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130271 === (8))){
var inst_130243 = (state_130270[(2)]);
var inst_130244 = fluree.db.util.async.throw_err(inst_130243);
var state_130270__$1 = state_130270;
var statearr_130284_130299 = state_130270__$1;
(statearr_130284_130299[(2)] = inst_130244);

(statearr_130284_130299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____0 = (function (){
var statearr_130285 = [null,null,null,null,null,null,null,null,null];
(statearr_130285[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__);

(statearr_130285[(1)] = (1));

return statearr_130285;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____1 = (function (state_130270){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130270);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130286){if((e130286 instanceof Object)){
var ex__109974__auto__ = e130286;
var statearr_130287_130300 = state_130270;
(statearr_130287_130300[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130270);

return cljs.core.cst$kw$recur;
} else {
throw e130286;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130301 = state_130270;
state_130270 = G__130301;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__ = function(state_130270){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____1.call(this,state_130270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130288 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130288[(6)] = c__110077__auto__);

return statearr_130288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130325){
var state_val_130326 = (state_130325[(1)]);
if((state_val_130326 === (1))){
var state_130325__$1 = state_130325;
var statearr_130327_130339 = state_130325__$1;
(statearr_130327_130339[(2)] = null);

(statearr_130327_130339[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130326 === (2))){
var inst_130323 = (state_130325[(2)]);
var state_130325__$1 = state_130325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130325__$1,inst_130323);
} else {
if((state_val_130326 === (3))){
var inst_130302 = (state_130325[(2)]);
var state_130325__$1 = state_130325;
var statearr_130328_130340 = state_130325__$1;
(statearr_130328_130340[(2)] = inst_130302);


cljs.core.async.impl.ioc_helpers.process_exception(state_130325__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130326 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130325,(3),Error,null,(2));
var inst_130306 = fluree.db.util.async.channel_QMARK_(email);
var state_130325__$1 = state_130325;
if(inst_130306){
var statearr_130329_130341 = state_130325__$1;
(statearr_130329_130341[(1)] = (5));

} else {
var statearr_130330_130342 = state_130325__$1;
(statearr_130330_130342[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130326 === (5))){
var state_130325__$1 = state_130325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130325__$1,(8),email);
} else {
if((state_val_130326 === (6))){
var state_130325__$1 = state_130325;
var statearr_130331_130343 = state_130325__$1;
(statearr_130331_130343[(2)] = email);

(statearr_130331_130343[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130326 === (7))){
var inst_130313 = (state_130325[(2)]);
var inst_130314 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_130313);
var inst_130315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130316 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130317 = ["re-find",inst_130313,inst_130314];
var inst_130318 = cljs.core.PersistentHashMap.fromArrays(inst_130316,inst_130317);
var inst_130319 = [inst_130318,(10)];
var inst_130320 = (new cljs.core.PersistentVector(null,2,(5),inst_130315,inst_130319,null));
var inst_130321 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130320);
var state_130325__$1 = (function (){var statearr_130332 = state_130325;
(statearr_130332[(7)] = inst_130321);

return statearr_130332;
})();
var statearr_130333_130344 = state_130325__$1;
(statearr_130333_130344[(2)] = inst_130314);


cljs.core.async.impl.ioc_helpers.process_exception(state_130325__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130326 === (8))){
var inst_130309 = (state_130325[(2)]);
var inst_130310 = fluree.db.util.async.throw_err(inst_130309);
var state_130325__$1 = state_130325;
var statearr_130334_130345 = state_130325__$1;
(statearr_130334_130345[(2)] = inst_130310);

(statearr_130334_130345[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_130335 = [null,null,null,null,null,null,null,null];
(statearr_130335[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__);

(statearr_130335[(1)] = (1));

return statearr_130335;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____1 = (function (state_130325){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130325);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130336){if((e130336 instanceof Object)){
var ex__109974__auto__ = e130336;
var statearr_130337_130346 = state_130325;
(statearr_130337_130346[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130325);

return cljs.core.cst$kw$recur;
} else {
throw e130336;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130347 = state_130325;
state_130325 = G__130347;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__ = function(state_130325){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____1.call(this,state_130325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130338 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130338[(6)] = c__110077__auto__);

return statearr_130338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130391){
var state_val_130392 = (state_130391[(1)]);
if((state_val_130392 === (7))){
var inst_130377 = (state_130391[(2)]);
var inst_130378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_130377,(0),null);
var inst_130379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_130377,(1),null);
var inst_130380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130381 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130382 = ["?user_id","?ctx",inst_130378];
var inst_130383 = cljs.core.PersistentHashMap.fromArrays(inst_130381,inst_130382);
var inst_130384 = ((10) + inst_130379);
var inst_130385 = [inst_130383,inst_130384];
var inst_130386 = (new cljs.core.PersistentVector(null,2,(5),inst_130380,inst_130385,null));
var inst_130387 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130386);
var state_130391__$1 = (function (){var statearr_130393 = state_130391;
(statearr_130393[(7)] = inst_130387);

return statearr_130393;
})();
var statearr_130394_130413 = state_130391__$1;
(statearr_130394_130413[(2)] = inst_130378);


cljs.core.async.impl.ioc_helpers.process_exception(state_130391__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (1))){
var state_130391__$1 = state_130391;
var statearr_130395_130414 = state_130391__$1;
(statearr_130395_130414[(2)] = null);

(statearr_130395_130414[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130391,(3),Error,null,(2));
var inst_130355 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130391__$1 = state_130391;
if(cljs.core.truth_(inst_130355)){
var statearr_130396_130415 = state_130391__$1;
(statearr_130396_130415[(1)] = (5));

} else {
var statearr_130397_130416 = state_130391__$1;
(statearr_130397_130416[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (13))){
var state_130391__$1 = state_130391;
var statearr_130398_130417 = state_130391__$1;
(statearr_130398_130417[(2)] = null);

(statearr_130398_130417[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (6))){
var inst_130362 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130391__$1 = state_130391;
if(cljs.core.truth_(inst_130362)){
var statearr_130399_130418 = state_130391__$1;
(statearr_130399_130418[(1)] = (8));

} else {
var statearr_130400_130419 = state_130391__$1;
(statearr_130400_130419[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (3))){
var inst_130348 = (state_130391[(2)]);
var state_130391__$1 = state_130391;
var statearr_130401_130420 = state_130391__$1;
(statearr_130401_130420[(2)] = inst_130348);


cljs.core.async.impl.ioc_helpers.process_exception(state_130391__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (12))){
var inst_130370 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_130391__$1 = state_130391;
var statearr_130402_130421 = state_130391__$1;
(statearr_130402_130421[(2)] = inst_130370);

(statearr_130402_130421[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (2))){
var inst_130389 = (state_130391[(2)]);
var state_130391__$1 = state_130391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130391__$1,inst_130389);
} else {
if((state_val_130392 === (11))){
var inst_130366 = (state_130391[(2)]);
var inst_130367 = fluree.db.util.async.throw_err(inst_130366);
var state_130391__$1 = state_130391;
var statearr_130403_130422 = state_130391__$1;
(statearr_130403_130422[(2)] = inst_130367);

(statearr_130403_130422[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (9))){
var state_130391__$1 = state_130391;
var statearr_130404_130423 = state_130391__$1;
(statearr_130404_130423[(1)] = (12));



return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (5))){
var inst_130357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130358 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_130359 = [inst_130358,(0)];
var inst_130360 = (new cljs.core.PersistentVector(null,2,(5),inst_130357,inst_130359,null));
var state_130391__$1 = state_130391;
var statearr_130406_130424 = state_130391__$1;
(statearr_130406_130424[(2)] = inst_130360);

(statearr_130406_130424[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (14))){
var inst_130373 = (state_130391[(2)]);
var state_130391__$1 = state_130391;
var statearr_130407_130425 = state_130391__$1;
(statearr_130407_130425[(2)] = inst_130373);

(statearr_130407_130425[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (10))){
var inst_130375 = (state_130391[(2)]);
var state_130391__$1 = state_130391;
var statearr_130408_130426 = state_130391__$1;
(statearr_130408_130426[(2)] = inst_130375);

(statearr_130408_130426[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130392 === (8))){
var inst_130364 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_130391__$1 = state_130391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130391__$1,(11),inst_130364);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____0 = (function (){
var statearr_130409 = [null,null,null,null,null,null,null,null];
(statearr_130409[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__);

(statearr_130409[(1)] = (1));

return statearr_130409;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____1 = (function (state_130391){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130391);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130410){if((e130410 instanceof Object)){
var ex__109974__auto__ = e130410;
var statearr_130411_130427 = state_130391;
(statearr_130411_130427[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130391);

return cljs.core.cst$kw$recur;
} else {
throw e130410;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130428 = state_130391;
state_130391 = G__130428;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__ = function(state_130391){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____1.call(this,state_130391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130412 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130412[(6)] = c__110077__auto__);

return statearr_130412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130453){
var state_val_130454 = (state_130453[(1)]);
if((state_val_130454 === (1))){
var state_130453__$1 = state_130453;
var statearr_130455_130467 = state_130453__$1;
(statearr_130455_130467[(2)] = null);

(statearr_130455_130467[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130454 === (2))){
var inst_130451 = (state_130453[(2)]);
var state_130453__$1 = state_130453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130453__$1,inst_130451);
} else {
if((state_val_130454 === (3))){
var inst_130429 = (state_130453[(2)]);
var state_130453__$1 = state_130453;
var statearr_130456_130468 = state_130453__$1;
(statearr_130456_130468[(2)] = inst_130429);


cljs.core.async.impl.ioc_helpers.process_exception(state_130453__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130454 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130453,(3),Error,null,(2));
var inst_130433 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130453__$1 = state_130453;
if(cljs.core.truth_(inst_130433)){
var statearr_130457_130469 = state_130453__$1;
(statearr_130457_130469[(1)] = (5));

} else {
var statearr_130458_130470 = state_130453__$1;
(statearr_130458_130470[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130454 === (5))){
var inst_130435 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_130453__$1 = state_130453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130453__$1,(8),inst_130435);
} else {
if((state_val_130454 === (6))){
var inst_130447 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_130453__$1 = state_130453;
var statearr_130459_130471 = state_130453__$1;
(statearr_130459_130471[(2)] = inst_130447);

(statearr_130459_130471[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130454 === (7))){
var inst_130449 = (state_130453[(2)]);
var state_130453__$1 = state_130453;
var statearr_130460_130472 = state_130453__$1;
(statearr_130460_130472[(2)] = inst_130449);


cljs.core.async.impl.ioc_helpers.process_exception(state_130453__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130454 === (8))){
var inst_130437 = (state_130453[(2)]);
var inst_130438 = fluree.db.util.async.throw_err(inst_130437);
var inst_130439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130440 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130441 = ["?auth_id","?ctx",inst_130438];
var inst_130442 = cljs.core.PersistentHashMap.fromArrays(inst_130440,inst_130441);
var inst_130443 = [inst_130442,(10)];
var inst_130444 = (new cljs.core.PersistentVector(null,2,(5),inst_130439,inst_130443,null));
var inst_130445 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130444);
var state_130453__$1 = (function (){var statearr_130461 = state_130453;
(statearr_130461[(7)] = inst_130445);

return statearr_130461;
})();
var statearr_130462_130473 = state_130453__$1;
(statearr_130462_130473[(2)] = inst_130438);

(statearr_130462_130473[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____0 = (function (){
var statearr_130463 = [null,null,null,null,null,null,null,null];
(statearr_130463[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__);

(statearr_130463[(1)] = (1));

return statearr_130463;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____1 = (function (state_130453){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130453);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130464){if((e130464 instanceof Object)){
var ex__109974__auto__ = e130464;
var statearr_130465_130474 = state_130453;
(statearr_130465_130474[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130453);

return cljs.core.cst$kw$recur;
} else {
throw e130464;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130475 = state_130453;
state_130453 = G__130475;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__ = function(state_130453){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____1.call(this,state_130453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130466 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130466[(6)] = c__110077__auto__);

return statearr_130466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__130477 = arguments.length;
switch (G__130477) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
});

fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130516){
var state_val_130517 = (state_130516[(1)]);
if((state_val_130517 === (7))){
var inst_130489 = (state_130516[(2)]);
var inst_130490 = fluree.db.util.async.channel_QMARK_(max);
var state_130516__$1 = (function (){var statearr_130518 = state_130516;
(statearr_130518[(7)] = inst_130489);

return statearr_130518;
})();
if(inst_130490){
var statearr_130519_130541 = state_130516__$1;
(statearr_130519_130541[(1)] = (9));

} else {
var statearr_130520_130542 = state_130516__$1;
(statearr_130520_130542[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (1))){
var state_130516__$1 = state_130516;
var statearr_130521_130543 = state_130516__$1;
(statearr_130521_130543[(2)] = null);

(statearr_130521_130543[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130516,(3),Error,null,(2));
var inst_130482 = fluree.db.util.async.channel_QMARK_(seed);
var state_130516__$1 = state_130516;
if(inst_130482){
var statearr_130522_130544 = state_130516__$1;
(statearr_130522_130544[(1)] = (5));

} else {
var statearr_130523_130545 = state_130516__$1;
(statearr_130523_130545[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (15))){
var inst_130489 = (state_130516[(7)]);
var inst_130501 = (state_130516[(2)]);
var inst_130502 = fluree.db.dbfunctions.internal.rand(inst_130489,inst_130501);
var inst_130503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130504 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130506 = [seed,max];
var inst_130507 = (new cljs.core.PersistentVector(null,2,(5),inst_130505,inst_130506,null));
var inst_130508 = ["rand",inst_130507,inst_130502];
var inst_130509 = cljs.core.PersistentHashMap.fromArrays(inst_130504,inst_130508);
var inst_130510 = [inst_130509,(10)];
var inst_130511 = (new cljs.core.PersistentVector(null,2,(5),inst_130503,inst_130510,null));
var inst_130512 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130511);
var state_130516__$1 = (function (){var statearr_130524 = state_130516;
(statearr_130524[(8)] = inst_130512);

return statearr_130524;
})();
var statearr_130525_130546 = state_130516__$1;
(statearr_130525_130546[(2)] = inst_130502);


cljs.core.async.impl.ioc_helpers.process_exception(state_130516__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (13))){
var inst_130497 = (state_130516[(9)]);
var state_130516__$1 = state_130516;
var statearr_130526_130547 = state_130516__$1;
(statearr_130526_130547[(2)] = inst_130497);

(statearr_130526_130547[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (6))){
var state_130516__$1 = state_130516;
var statearr_130527_130548 = state_130516__$1;
(statearr_130527_130548[(2)] = seed);

(statearr_130527_130548[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (3))){
var inst_130478 = (state_130516[(2)]);
var state_130516__$1 = state_130516;
var statearr_130528_130549 = state_130516__$1;
(statearr_130528_130549[(2)] = inst_130478);


cljs.core.async.impl.ioc_helpers.process_exception(state_130516__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (12))){
var inst_130493 = (state_130516[(2)]);
var inst_130494 = fluree.db.util.async.throw_err(inst_130493);
var state_130516__$1 = state_130516;
var statearr_130529_130550 = state_130516__$1;
(statearr_130529_130550[(2)] = inst_130494);

(statearr_130529_130550[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (2))){
var inst_130514 = (state_130516[(2)]);
var state_130516__$1 = state_130516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130516__$1,inst_130514);
} else {
if((state_val_130517 === (11))){
var inst_130497 = (state_130516[(9)]);
var inst_130497__$1 = (state_130516[(2)]);
var state_130516__$1 = (function (){var statearr_130530 = state_130516;
(statearr_130530[(9)] = inst_130497__$1);

return statearr_130530;
})();
if(cljs.core.truth_(inst_130497__$1)){
var statearr_130531_130551 = state_130516__$1;
(statearr_130531_130551[(1)] = (13));

} else {
var statearr_130532_130552 = state_130516__$1;
(statearr_130532_130552[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (9))){
var state_130516__$1 = state_130516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130516__$1,(12),max);
} else {
if((state_val_130517 === (5))){
var state_130516__$1 = state_130516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130516__$1,(8),seed);
} else {
if((state_val_130517 === (14))){
var state_130516__$1 = state_130516;
var statearr_130533_130553 = state_130516__$1;
(statearr_130533_130553[(2)] = (10));

(statearr_130533_130553[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (10))){
var state_130516__$1 = state_130516;
var statearr_130534_130554 = state_130516__$1;
(statearr_130534_130554[(2)] = max);

(statearr_130534_130554[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130517 === (8))){
var inst_130485 = (state_130516[(2)]);
var inst_130486 = fluree.db.util.async.throw_err(inst_130485);
var state_130516__$1 = state_130516;
var statearr_130535_130555 = state_130516__$1;
(statearr_130535_130555[(2)] = inst_130486);

(statearr_130535_130555[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__109971__auto____0 = (function (){
var statearr_130536 = [null,null,null,null,null,null,null,null,null,null];
(statearr_130536[(0)] = fluree$db$dbfunctions$fns$state_machine__109971__auto__);

(statearr_130536[(1)] = (1));

return statearr_130536;
});
var fluree$db$dbfunctions$fns$state_machine__109971__auto____1 = (function (state_130516){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130516);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130537){if((e130537 instanceof Object)){
var ex__109974__auto__ = e130537;
var statearr_130538_130556 = state_130516;
(statearr_130538_130556[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130516);

return cljs.core.cst$kw$recur;
} else {
throw e130537;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130557 = state_130516;
state_130516 = G__130557;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__109971__auto__ = function(state_130516){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__109971__auto____1.call(this,state_130516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130539 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130539[(6)] = c__110077__auto__);

return statearr_130539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3;

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130575){
var state_val_130576 = (state_130575[(1)]);
if((state_val_130576 === (1))){
var state_130575__$1 = state_130575;
var statearr_130577_130585 = state_130575__$1;
(statearr_130577_130585[(2)] = null);

(statearr_130577_130585[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130576 === (2))){
var inst_130573 = (state_130575[(2)]);
var state_130575__$1 = state_130575;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130575__$1,inst_130573);
} else {
if((state_val_130576 === (3))){
var inst_130558 = (state_130575[(2)]);
var state_130575__$1 = state_130575;
var statearr_130578_130586 = state_130575__$1;
(statearr_130578_130586[(2)] = inst_130558);


cljs.core.async.impl.ioc_helpers.process_exception(state_130575__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130576 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130575,(3),Error,null,(2));
var inst_130562 = fluree.db.util.core.random_uuid();
var inst_130563 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130562);
var inst_130564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130565 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130566 = cljs.core.PersistentVector.EMPTY;
var inst_130567 = ["uuid",inst_130566,inst_130563];
var inst_130568 = cljs.core.PersistentHashMap.fromArrays(inst_130565,inst_130567);
var inst_130569 = [inst_130568,(10)];
var inst_130570 = (new cljs.core.PersistentVector(null,2,(5),inst_130564,inst_130569,null));
var inst_130571 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130570);
var state_130575__$1 = (function (){var statearr_130579 = state_130575;
(statearr_130579[(7)] = inst_130571);

return statearr_130579;
})();
var statearr_130580_130587 = state_130575__$1;
(statearr_130580_130587[(2)] = inst_130563);


cljs.core.async.impl.ioc_helpers.process_exception(state_130575__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____0 = (function (){
var statearr_130581 = [null,null,null,null,null,null,null,null];
(statearr_130581[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__);

(statearr_130581[(1)] = (1));

return statearr_130581;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____1 = (function (state_130575){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130575);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130582){if((e130582 instanceof Object)){
var ex__109974__auto__ = e130582;
var statearr_130583_130588 = state_130575;
(statearr_130583_130588[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130575);

return cljs.core.cst$kw$recur;
} else {
throw e130582;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130589 = state_130575;
state_130575 = G__130589;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__ = function(state_130575){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____1.call(this,state_130575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130584 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130584[(6)] = c__110077__auto__);

return statearr_130584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130616){
var state_val_130617 = (state_130616[(1)]);
if((state_val_130617 === (1))){
var state_130616__$1 = state_130616;
var statearr_130618_130630 = state_130616__$1;
(statearr_130618_130630[(2)] = null);

(statearr_130618_130630[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130617 === (2))){
var inst_130614 = (state_130616[(2)]);
var state_130616__$1 = state_130616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130616__$1,inst_130614);
} else {
if((state_val_130617 === (3))){
var inst_130590 = (state_130616[(2)]);
var state_130616__$1 = state_130616;
var statearr_130619_130631 = state_130616__$1;
(statearr_130619_130631[(2)] = inst_130590);


cljs.core.async.impl.ioc_helpers.process_exception(state_130616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130617 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130616,(3),Error,null,(2));
var inst_130594 = fluree.db.util.async.channel_QMARK_(num);
var state_130616__$1 = state_130616;
if(inst_130594){
var statearr_130620_130632 = state_130616__$1;
(statearr_130620_130632[(1)] = (5));

} else {
var statearr_130621_130633 = state_130616__$1;
(statearr_130621_130633[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130617 === (5))){
var state_130616__$1 = state_130616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130616__$1,(8),num);
} else {
if((state_val_130617 === (6))){
var state_130616__$1 = state_130616;
var statearr_130622_130634 = state_130616__$1;
(statearr_130622_130634[(2)] = num);

(statearr_130622_130634[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130617 === (7))){
var inst_130601 = (state_130616[(2)]);
var inst_130602 = fluree.db.dbfunctions.internal.ceil(inst_130601);
var inst_130603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130604 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130606 = [fluree.db.dbfunctions.fns.ceil];
var inst_130607 = (new cljs.core.PersistentVector(null,1,(5),inst_130605,inst_130606,null));
var inst_130608 = ["",inst_130607,inst_130602];
var inst_130609 = cljs.core.PersistentHashMap.fromArrays(inst_130604,inst_130608);
var inst_130610 = [inst_130609,(10)];
var inst_130611 = (new cljs.core.PersistentVector(null,2,(5),inst_130603,inst_130610,null));
var inst_130612 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130611);
var state_130616__$1 = (function (){var statearr_130623 = state_130616;
(statearr_130623[(7)] = inst_130612);

return statearr_130623;
})();
var statearr_130624_130635 = state_130616__$1;
(statearr_130624_130635[(2)] = inst_130602);


cljs.core.async.impl.ioc_helpers.process_exception(state_130616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130617 === (8))){
var inst_130597 = (state_130616[(2)]);
var inst_130598 = fluree.db.util.async.throw_err(inst_130597);
var state_130616__$1 = state_130616;
var statearr_130625_130636 = state_130616__$1;
(statearr_130625_130636[(2)] = inst_130598);

(statearr_130625_130636[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____0 = (function (){
var statearr_130626 = [null,null,null,null,null,null,null,null];
(statearr_130626[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__);

(statearr_130626[(1)] = (1));

return statearr_130626;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____1 = (function (state_130616){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130616);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130627){if((e130627 instanceof Object)){
var ex__109974__auto__ = e130627;
var statearr_130628_130637 = state_130616;
(statearr_130628_130637[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130616);

return cljs.core.cst$kw$recur;
} else {
throw e130627;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130638 = state_130616;
state_130616 = G__130638;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__ = function(state_130616){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____1.call(this,state_130616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130629 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130629[(6)] = c__110077__auto__);

return statearr_130629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130665){
var state_val_130666 = (state_130665[(1)]);
if((state_val_130666 === (1))){
var state_130665__$1 = state_130665;
var statearr_130667_130679 = state_130665__$1;
(statearr_130667_130679[(2)] = null);

(statearr_130667_130679[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130666 === (2))){
var inst_130663 = (state_130665[(2)]);
var state_130665__$1 = state_130665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130665__$1,inst_130663);
} else {
if((state_val_130666 === (3))){
var inst_130639 = (state_130665[(2)]);
var state_130665__$1 = state_130665;
var statearr_130668_130680 = state_130665__$1;
(statearr_130668_130680[(2)] = inst_130639);


cljs.core.async.impl.ioc_helpers.process_exception(state_130665__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130666 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130665,(3),Error,null,(2));
var inst_130643 = fluree.db.util.async.channel_QMARK_(num);
var state_130665__$1 = state_130665;
if(inst_130643){
var statearr_130669_130681 = state_130665__$1;
(statearr_130669_130681[(1)] = (5));

} else {
var statearr_130670_130682 = state_130665__$1;
(statearr_130670_130682[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130666 === (5))){
var state_130665__$1 = state_130665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130665__$1,(8),num);
} else {
if((state_val_130666 === (6))){
var state_130665__$1 = state_130665;
var statearr_130671_130683 = state_130665__$1;
(statearr_130671_130683[(2)] = num);

(statearr_130671_130683[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130666 === (7))){
var inst_130650 = (state_130665[(2)]);
var inst_130651 = fluree.db.dbfunctions.internal.floor(inst_130650);
var inst_130652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130653 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_130654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130655 = [fluree.db.dbfunctions.fns.floor];
var inst_130656 = (new cljs.core.PersistentVector(null,1,(5),inst_130654,inst_130655,null));
var inst_130657 = ["",inst_130656,inst_130651];
var inst_130658 = cljs.core.PersistentHashMap.fromArrays(inst_130653,inst_130657);
var inst_130659 = [inst_130658,(10)];
var inst_130660 = (new cljs.core.PersistentVector(null,2,(5),inst_130652,inst_130659,null));
var inst_130661 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_130660);
var state_130665__$1 = (function (){var statearr_130672 = state_130665;
(statearr_130672[(7)] = inst_130661);

return statearr_130672;
})();
var statearr_130673_130684 = state_130665__$1;
(statearr_130673_130684[(2)] = inst_130651);


cljs.core.async.impl.ioc_helpers.process_exception(state_130665__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130666 === (8))){
var inst_130646 = (state_130665[(2)]);
var inst_130647 = fluree.db.util.async.throw_err(inst_130646);
var state_130665__$1 = state_130665;
var statearr_130674_130685 = state_130665__$1;
(statearr_130674_130685[(2)] = inst_130647);

(statearr_130674_130685[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____0 = (function (){
var statearr_130675 = [null,null,null,null,null,null,null,null];
(statearr_130675[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__);

(statearr_130675[(1)] = (1));

return statearr_130675;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____1 = (function (state_130665){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130665);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130676){if((e130676 instanceof Object)){
var ex__109974__auto__ = e130676;
var statearr_130677_130686 = state_130665;
(statearr_130677_130686[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130665);

return cljs.core.cst$kw$recur;
} else {
throw e130676;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130687 = state_130665;
state_130665 = G__130687;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__ = function(state_130665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____1.call(this,state_130665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130678 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130678[(6)] = c__110077__auto__);

return statearr_130678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
