// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__105475 = s;
var map__105475__$1 = (((((!((map__105475 == null))))?(((((map__105475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105475):map__105475);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105475__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105475__$1,cljs.core.cst$kw$info);
var d = (0);
var G__105478 = info;
var map__105479 = G__105478;
var map__105479__$1 = (((((!((map__105479 == null))))?(((((map__105479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105479.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105479):map__105479);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105479__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__105478__$1 = G__105478;
while(true){
var d__$2 = d__$1;
var map__105483 = G__105478__$1;
var map__105483__$1 = (((((!((map__105483 == null))))?(((((map__105483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105483.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105483):map__105483);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105483__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__105485 = (d__$2 + (1));
var G__105486 = shadow__$1;
d__$1 = G__105485;
G__105478__$1 = G__105486;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__105487){
var map__105488 = p__105487;
var map__105488__$1 = (((((!((map__105488 == null))))?(((((map__105488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105488.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105488):map__105488);
var name_var = map__105488__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105488__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105488__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__105490 = info;
var map__105490__$1 = (((((!((map__105490 == null))))?(((((map__105490.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105490.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105490):map__105490);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105490__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105490__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__105492 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__105492) : cljs.compiler.munge.call(null,G__105492));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__105494 = arguments.length;
switch (G__105494) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__105495 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",17,1,11478,11478,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__105495.cljs$core$IFn$_invoke$arity$1 ? fexpr__105495.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__105495.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__105497 = cp;
switch (G__105497) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__105499_105503 = cljs.core.seq(s);
var chunk__105500_105504 = null;
var count__105501_105505 = (0);
var i__105502_105506 = (0);
while(true){
if((i__105502_105506 < count__105501_105505)){
var c_105507 = chunk__105500_105504.cljs$core$IIndexed$_nth$arity$2(null,i__105502_105506);
sb.append(cljs.compiler.escape_char(c_105507));


var G__105508 = seq__105499_105503;
var G__105509 = chunk__105500_105504;
var G__105510 = count__105501_105505;
var G__105511 = (i__105502_105506 + (1));
seq__105499_105503 = G__105508;
chunk__105500_105504 = G__105509;
count__105501_105505 = G__105510;
i__105502_105506 = G__105511;
continue;
} else {
var temp__5735__auto___105512 = cljs.core.seq(seq__105499_105503);
if(temp__5735__auto___105512){
var seq__105499_105513__$1 = temp__5735__auto___105512;
if(cljs.core.chunked_seq_QMARK_(seq__105499_105513__$1)){
var c__4550__auto___105514 = cljs.core.chunk_first(seq__105499_105513__$1);
var G__105515 = cljs.core.chunk_rest(seq__105499_105513__$1);
var G__105516 = c__4550__auto___105514;
var G__105517 = cljs.core.count(c__4550__auto___105514);
var G__105518 = (0);
seq__105499_105503 = G__105515;
chunk__105500_105504 = G__105516;
count__105501_105505 = G__105517;
i__105502_105506 = G__105518;
continue;
} else {
var c_105519 = cljs.core.first(seq__105499_105513__$1);
sb.append(cljs.compiler.escape_char(c_105519));


var G__105520 = cljs.core.next(seq__105499_105513__$1);
var G__105521 = null;
var G__105522 = (0);
var G__105523 = (0);
seq__105499_105503 = G__105520;
chunk__105500_105504 = G__105521;
count__105501_105505 = G__105522;
i__105502_105506 = G__105523;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__105524 = cljs.core.get_global_hierarchy;
return (fexpr__105524.cljs$core$IFn$_invoke$arity$0 ? fexpr__105524.cljs$core$IFn$_invoke$arity$0() : fexpr__105524.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__105525_105532 = ast;
var map__105525_105533__$1 = (((((!((map__105525_105532 == null))))?(((((map__105525_105532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105525_105532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105525_105532):map__105525_105532);
var env_105534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105525_105533__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_105534))){
var map__105527_105535 = env_105534;
var map__105527_105536__$1 = (((((!((map__105527_105535 == null))))?(((((map__105527_105535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105527_105535.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105527_105535):map__105527_105535);
var line_105537 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105527_105536__$1,cljs.core.cst$kw$line);
var column_105538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105527_105536__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,((function (map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534){
return (function (m){
var minfo = (function (){var G__105529 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__105531 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__105530 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__105530.cljs$core$IFn$_invoke$arity$1 ? fexpr__105530.cljs$core$IFn$_invoke$arity$1(G__105531) : fexpr__105530.call(null,G__105531));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__105529,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__105529;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_105537 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (minfo,map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534){
return (function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_105538)?(column_105538 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (minfo,map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534){
return (function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
});})(minfo,map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534))
,cljs.core.sorted_map()));
});})(map__105527_105535,map__105527_105536__$1,line_105537,column_105538,map__105525_105532,map__105525_105533__$1,env_105534))
);
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__105547 = arguments.length;
switch (G__105547) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___105554 = arguments.length;
var i__4731__auto___105555 = (0);
while(true){
if((i__4731__auto___105555 < len__4730__auto___105554)){
args_arr__4751__auto__.push((arguments[i__4731__auto___105555]));

var G__105556 = (i__4731__auto___105555 + (1));
i__4731__auto___105555 = G__105556;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_105557 = (function (){var G__105548 = a;
if((!(typeof a === 'string'))){
return G__105548.toString();
} else {
return G__105548;
}
})();
var temp__5739__auto___105558 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___105558 == null)){
} else {
var sm_data_105559 = temp__5739__auto___105558;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_105559,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,((function (sm_data_105559,temp__5739__auto___105558,s_105557){
return (function (p1__105539_SHARP_){
return (p1__105539_SHARP_ + s_105557.length);
});})(sm_data_105559,temp__5739__auto___105558,s_105557))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_105557], 0));

}
}
}
}

return null;
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__105549 = cljs.core.seq(xs);
var chunk__105550 = null;
var count__105551 = (0);
var i__105552 = (0);
while(true){
if((i__105552 < count__105551)){
var x = chunk__105550.cljs$core$IIndexed$_nth$arity$2(null,i__105552);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__105560 = seq__105549;
var G__105561 = chunk__105550;
var G__105562 = count__105551;
var G__105563 = (i__105552 + (1));
seq__105549 = G__105560;
chunk__105550 = G__105561;
count__105551 = G__105562;
i__105552 = G__105563;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__105549);
if(temp__5735__auto__){
var seq__105549__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__105549__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__105549__$1);
var G__105564 = cljs.core.chunk_rest(seq__105549__$1);
var G__105565 = c__4550__auto__;
var G__105566 = cljs.core.count(c__4550__auto__);
var G__105567 = (0);
seq__105549 = G__105564;
chunk__105550 = G__105565;
count__105551 = G__105566;
i__105552 = G__105567;
continue;
} else {
var x = cljs.core.first(seq__105549__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__105568 = cljs.core.next(seq__105549__$1);
var G__105569 = null;
var G__105570 = (0);
var G__105571 = (0);
seq__105549 = G__105568;
chunk__105550 = G__105569;
count__105551 = G__105570;
i__105552 = G__105571;
continue;
}
} else {
return null;
}
}
break;
}
});

/** @this {Function} */
cljs.compiler.emits.cljs$lang$applyTo = (function (seq105541){
var G__105542 = cljs.core.first(seq105541);
var seq105541__$1 = cljs.core.next(seq105541);
var G__105543 = cljs.core.first(seq105541__$1);
var seq105541__$2 = cljs.core.next(seq105541__$1);
var G__105544 = cljs.core.first(seq105541__$2);
var seq105541__$3 = cljs.core.next(seq105541__$2);
var G__105545 = cljs.core.first(seq105541__$3);
var seq105541__$4 = cljs.core.next(seq105541__$3);
var G__105546 = cljs.core.first(seq105541__$4);
var seq105541__$5 = cljs.core.next(seq105541__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__105542,G__105543,G__105544,G__105545,G__105546,seq105541__$5);
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (5);

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__105572){
var map__105573 = p__105572;
var map__105573__$1 = (((((!((map__105573 == null))))?(((((map__105573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105573):map__105573);
var m = map__105573__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105573__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__105582 = arguments.length;
switch (G__105582) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___105588 = arguments.length;
var i__4731__auto___105589 = (0);
while(true){
if((i__4731__auto___105589 < len__4730__auto___105588)){
args_arr__4751__auto__.push((arguments[i__4731__auto___105589]));

var G__105590 = (i__4731__auto___105589 + (1));
i__4731__auto___105589 = G__105590;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__105583_105591 = cljs.core.seq(xs);
var chunk__105584_105592 = null;
var count__105585_105593 = (0);
var i__105586_105594 = (0);
while(true){
if((i__105586_105594 < count__105585_105593)){
var x_105595 = chunk__105584_105592.cljs$core$IIndexed$_nth$arity$2(null,i__105586_105594);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_105595);


var G__105596 = seq__105583_105591;
var G__105597 = chunk__105584_105592;
var G__105598 = count__105585_105593;
var G__105599 = (i__105586_105594 + (1));
seq__105583_105591 = G__105596;
chunk__105584_105592 = G__105597;
count__105585_105593 = G__105598;
i__105586_105594 = G__105599;
continue;
} else {
var temp__5735__auto___105600 = cljs.core.seq(seq__105583_105591);
if(temp__5735__auto___105600){
var seq__105583_105601__$1 = temp__5735__auto___105600;
if(cljs.core.chunked_seq_QMARK_(seq__105583_105601__$1)){
var c__4550__auto___105602 = cljs.core.chunk_first(seq__105583_105601__$1);
var G__105603 = cljs.core.chunk_rest(seq__105583_105601__$1);
var G__105604 = c__4550__auto___105602;
var G__105605 = cljs.core.count(c__4550__auto___105602);
var G__105606 = (0);
seq__105583_105591 = G__105603;
chunk__105584_105592 = G__105604;
count__105585_105593 = G__105605;
i__105586_105594 = G__105606;
continue;
} else {
var x_105607 = cljs.core.first(seq__105583_105601__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_105607);


var G__105608 = cljs.core.next(seq__105583_105601__$1);
var G__105609 = null;
var G__105610 = (0);
var G__105611 = (0);
seq__105583_105591 = G__105608;
chunk__105584_105592 = G__105609;
count__105585_105593 = G__105610;
i__105586_105594 = G__105611;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
});

/** @this {Function} */
cljs.compiler.emitln.cljs$lang$applyTo = (function (seq105576){
var G__105577 = cljs.core.first(seq105576);
var seq105576__$1 = cljs.core.next(seq105576);
var G__105578 = cljs.core.first(seq105576__$1);
var seq105576__$2 = cljs.core.next(seq105576__$1);
var G__105579 = cljs.core.first(seq105576__$2);
var seq105576__$3 = cljs.core.next(seq105576__$2);
var G__105580 = cljs.core.first(seq105576__$3);
var seq105576__$4 = cljs.core.next(seq105576__$3);
var G__105581 = cljs.core.first(seq105576__$4);
var seq105576__$5 = cljs.core.next(seq105576__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__105577,G__105578,G__105579,G__105580,G__105581,seq105576__$5);
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (5);

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__105612_105616 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__105613_105617 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__105614_105618 = true;
var _STAR_print_fn_STAR__temp_val__105615_105619 = ((function (_STAR_print_newline_STAR__orig_val__105612_105616,_STAR_print_fn_STAR__orig_val__105613_105617,_STAR_print_newline_STAR__temp_val__105614_105618,sb__4661__auto__){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__105612_105616,_STAR_print_fn_STAR__orig_val__105613_105617,_STAR_print_newline_STAR__temp_val__105614_105618,sb__4661__auto__))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__105614_105618;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__105615_105619;

try{cljs.compiler.emit(expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__105613_105617;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__105612_105616;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__105620 = cljs.core.get_global_hierarchy;
return (fexpr__105620.cljs$core$IFn$_invoke$arity$0 ? fexpr__105620.cljs$core$IFn$_invoke$arity$0() : fexpr__105620.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__105621 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105621,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105621,(1),null);
var G__105624 = ns;
var G__105625 = name;
var G__105626 = ((function (G__105624,G__105625,vec__105621,ns,name){
return (function (){
var G__105627 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__105627) : cljs.compiler.emit_constant.call(null,G__105627));
});})(G__105624,G__105625,vec__105621,ns,name))
;
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__105624,G__105625,G__105626) : cljs.compiler.emit_record_value.call(null,G__105624,G__105625,G__105626));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__105628 = cljs.core.keys(x);
var G__105629 = cljs.core.vals(x);
var G__105630 = cljs.compiler.emit_constants_comma_sep;
var G__105631 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__105628,G__105629,G__105630,G__105631) : cljs.compiler.emit_map.call(null,G__105628,G__105629,G__105630,G__105631));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__105632 = ((function (m){
return (function (){
return cljs.compiler.emit_constant_no_meta(v);
});})(m))
;
var G__105633 = ((function (G__105632,m){
return (function (){
return cljs.compiler.emit_constant_no_meta(m);
});})(G__105632,m))
;
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__105632,G__105633) : cljs.compiler.emit_with_meta.call(null,G__105632,G__105633));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__105634 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105634,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105634,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105634,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4120__auto__)){
var G__105637 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__105637) : x.call(null,G__105637));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4120__auto__)){
var G__105638 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__105638) : x.call(null,G__105638));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__105640 = items;
var G__105641 = ((function (G__105640,items){
return (function (p1__105639_SHARP_){
return ((function (G__105640,items){
return (function (){
return cljs.compiler.emit_constant(p1__105639_SHARP_);
});
;})(G__105640,items))
});})(G__105640,items))
;
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__105640,G__105641) : cljs.compiler.emit_js_object.call(null,G__105640,G__105641));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__105643){
var map__105644 = p__105643;
var map__105644__$1 = (((((!((map__105644 == null))))?(((((map__105644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105644):map__105644);
var ast = map__105644__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105644__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105644__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105644__$1,cljs.core.cst$kw$form);
var temp__5733__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__105646 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__105646__$1 = (((((!((map__105646 == null))))?(((((map__105646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105646):map__105646);
var cenv = map__105646__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105646__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4131__auto__ = js_module_name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__105648 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4120__auto__ = (function (){var G__105650 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__105650) : cljs.compiler.es5_GT__EQ_.call(null,G__105650));
})();
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4120__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__105648,cljs.analyzer.es5_allowed);
} else {
return G__105648;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4131__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__105651 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__105651,reserved);
} else {
return G__105651;
}
})();
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__105652_105653 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__105652_105654__$1 = (((G__105652_105653 instanceof cljs.core.Keyword))?G__105652_105653.fqn:null);
switch (G__105652_105654__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4120__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__105656){
var map__105657 = p__105656;
var map__105657__$1 = (((((!((map__105657 == null))))?(((((map__105657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105657):map__105657);
var arg = map__105657__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105657__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105657__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105657__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105657__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__105659 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__105659__$1 = (((((!((map__105659 == null))))?(((((map__105659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105659.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105659):map__105659);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105659__$1,cljs.core.cst$kw$name);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__105661){
var map__105662 = p__105661;
var map__105662__$1 = (((((!((map__105662 == null))))?(((((map__105662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105662):map__105662);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105662__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105662__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105662__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_(((function (keys__$1){
return (function (p1__105664_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__105664_SHARP_),cljs.core.cst$kw$const);
});})(keys__$1))
,keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__105665 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__105665) : comma_sep.call(null,G__105665));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__105666 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__105666) : comma_sep.call(null,G__105666));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__105667){
var map__105668 = p__105667;
var map__105668__$1 = (((((!((map__105668 == null))))?(((((map__105668.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105668.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105668):map__105668);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105668__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105668__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105668__$1,cljs.core.cst$kw$vals);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__105670){
var map__105671 = p__105670;
var map__105671__$1 = (((((!((map__105671 == null))))?(((((map__105671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105671):map__105671);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105671__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105671__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_(((function (items__$1){
return (function (p1__105673_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__105673_SHARP_),cljs.core.cst$kw$const);
});})(items__$1))
,items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__105674 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__105674) : comma_sep.call(null,G__105674));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__105675){
var map__105676 = p__105675;
var map__105676__$1 = (((((!((map__105676 == null))))?(((((map__105676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105676):map__105676);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105676__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105676__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___105700 = cljs.core.seq(items);
if(temp__5735__auto___105700){
var items_105701__$1 = temp__5735__auto___105700;
var vec__105678_105702 = items_105701__$1;
var seq__105679_105703 = cljs.core.seq(vec__105678_105702);
var first__105680_105704 = cljs.core.first(seq__105679_105703);
var seq__105679_105705__$1 = cljs.core.next(seq__105679_105703);
var vec__105681_105706 = first__105680_105704;
var k_105707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105681_105706,(0),null);
var v_105708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105681_105706,(1),null);
var r_105709 = seq__105679_105705__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_105707),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_105708) : emit_js_object_val.call(null,v_105708)));

var seq__105684_105710 = cljs.core.seq(r_105709);
var chunk__105685_105711 = null;
var count__105686_105712 = (0);
var i__105687_105713 = (0);
while(true){
if((i__105687_105713 < count__105686_105712)){
var vec__105694_105714 = chunk__105685_105711.cljs$core$IIndexed$_nth$arity$2(null,i__105687_105713);
var k_105715__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105694_105714,(0),null);
var v_105716__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105694_105714,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_105715__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_105716__$1) : emit_js_object_val.call(null,v_105716__$1)));


var G__105717 = seq__105684_105710;
var G__105718 = chunk__105685_105711;
var G__105719 = count__105686_105712;
var G__105720 = (i__105687_105713 + (1));
seq__105684_105710 = G__105717;
chunk__105685_105711 = G__105718;
count__105686_105712 = G__105719;
i__105687_105713 = G__105720;
continue;
} else {
var temp__5735__auto___105721__$1 = cljs.core.seq(seq__105684_105710);
if(temp__5735__auto___105721__$1){
var seq__105684_105722__$1 = temp__5735__auto___105721__$1;
if(cljs.core.chunked_seq_QMARK_(seq__105684_105722__$1)){
var c__4550__auto___105723 = cljs.core.chunk_first(seq__105684_105722__$1);
var G__105724 = cljs.core.chunk_rest(seq__105684_105722__$1);
var G__105725 = c__4550__auto___105723;
var G__105726 = cljs.core.count(c__4550__auto___105723);
var G__105727 = (0);
seq__105684_105710 = G__105724;
chunk__105685_105711 = G__105725;
count__105686_105712 = G__105726;
i__105687_105713 = G__105727;
continue;
} else {
var vec__105697_105728 = cljs.core.first(seq__105684_105722__$1);
var k_105729__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105697_105728,(0),null);
var v_105730__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105697_105728,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_105729__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_105730__$1) : emit_js_object_val.call(null,v_105730__$1)));


var G__105731 = cljs.core.next(seq__105684_105722__$1);
var G__105732 = null;
var G__105733 = (0);
var G__105734 = (0);
seq__105684_105710 = G__105731;
chunk__105685_105711 = G__105732;
count__105686_105712 = G__105733;
i__105687_105713 = G__105734;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__105735){
var map__105736 = p__105735;
var map__105736__$1 = (((((!((map__105736 == null))))?(((((map__105736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105736):map__105736);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105736__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105736__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105736__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__105738){
var map__105739 = p__105738;
var map__105739__$1 = (((((!((map__105739 == null))))?(((((map__105739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105739):map__105739);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105739__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105739__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__105741){
var map__105742 = p__105741;
var map__105742__$1 = (((((!((map__105742 == null))))?(((((map__105742.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105742.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105742):map__105742);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105742__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__105744){
var map__105745 = p__105744;
var map__105745__$1 = (((((!((map__105745 == null))))?(((((map__105745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105745):map__105745);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105745__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105745__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__105747 = cljs.analyzer.unwrap_quote(expr);
var map__105747__$1 = (((((!((map__105747 == null))))?(((((map__105747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105747.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105747):map__105747);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105747__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105747__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105747__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4131__auto__ = (function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4120__auto__){
var and__4120__auto____$1 = form;
if(cljs.core.truth_(and__4120__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = (!((const_expr == null)));
if(and__4120__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4120__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__105749 = cljs.analyzer.unwrap_quote(expr);
var map__105749__$1 = (((((!((map__105749 == null))))?(((((map__105749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105749.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105749):map__105749);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105749__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105749__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105749__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4131__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = (!((const_expr == null)));
if(and__4120__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4120__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4131__auto__ = (function (){var fexpr__105752 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__105752.cljs$core$IFn$_invoke$arity$1 ? fexpr__105752.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__105752.call(null,tag));
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__105753){
var map__105754 = p__105753;
var map__105754__$1 = (((((!((map__105754 == null))))?(((((map__105754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105754):map__105754);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105754__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105754__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105754__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105754__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105754__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4131__auto__ = unchecked;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__105756){
var map__105757 = p__105756;
var map__105757__$1 = (((((!((map__105757 == null))))?(((((map__105757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105757):map__105757);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105757__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105757__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105757__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105757__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__105759_105795 = cljs.core.seq(nodes);
var chunk__105760_105796 = null;
var count__105761_105797 = (0);
var i__105762_105798 = (0);
while(true){
if((i__105762_105798 < count__105761_105797)){
var map__105779_105799 = chunk__105760_105796.cljs$core$IIndexed$_nth$arity$2(null,i__105762_105798);
var map__105779_105800__$1 = (((((!((map__105779_105799 == null))))?(((((map__105779_105799.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105779_105799.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105779_105799):map__105779_105799);
var ts_105801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105779_105800__$1,cljs.core.cst$kw$tests);
var map__105780_105802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105779_105800__$1,cljs.core.cst$kw$then);
var map__105780_105803__$1 = (((((!((map__105780_105802 == null))))?(((((map__105780_105802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105780_105802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105780_105802):map__105780_105802);
var then_105804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105780_105803__$1,cljs.core.cst$kw$then);
var seq__105783_105805 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_105801));
var chunk__105784_105806 = null;
var count__105785_105807 = (0);
var i__105786_105808 = (0);
while(true){
if((i__105786_105808 < count__105785_105807)){
var test_105809 = chunk__105784_105806.cljs$core$IIndexed$_nth$arity$2(null,i__105786_105808);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_105809,":");


var G__105810 = seq__105783_105805;
var G__105811 = chunk__105784_105806;
var G__105812 = count__105785_105807;
var G__105813 = (i__105786_105808 + (1));
seq__105783_105805 = G__105810;
chunk__105784_105806 = G__105811;
count__105785_105807 = G__105812;
i__105786_105808 = G__105813;
continue;
} else {
var temp__5735__auto___105814 = cljs.core.seq(seq__105783_105805);
if(temp__5735__auto___105814){
var seq__105783_105815__$1 = temp__5735__auto___105814;
if(cljs.core.chunked_seq_QMARK_(seq__105783_105815__$1)){
var c__4550__auto___105816 = cljs.core.chunk_first(seq__105783_105815__$1);
var G__105817 = cljs.core.chunk_rest(seq__105783_105815__$1);
var G__105818 = c__4550__auto___105816;
var G__105819 = cljs.core.count(c__4550__auto___105816);
var G__105820 = (0);
seq__105783_105805 = G__105817;
chunk__105784_105806 = G__105818;
count__105785_105807 = G__105819;
i__105786_105808 = G__105820;
continue;
} else {
var test_105821 = cljs.core.first(seq__105783_105815__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_105821,":");


var G__105822 = cljs.core.next(seq__105783_105815__$1);
var G__105823 = null;
var G__105824 = (0);
var G__105825 = (0);
seq__105783_105805 = G__105822;
chunk__105784_105806 = G__105823;
count__105785_105807 = G__105824;
i__105786_105808 = G__105825;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_105804);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_105804);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__105826 = seq__105759_105795;
var G__105827 = chunk__105760_105796;
var G__105828 = count__105761_105797;
var G__105829 = (i__105762_105798 + (1));
seq__105759_105795 = G__105826;
chunk__105760_105796 = G__105827;
count__105761_105797 = G__105828;
i__105762_105798 = G__105829;
continue;
} else {
var temp__5735__auto___105830 = cljs.core.seq(seq__105759_105795);
if(temp__5735__auto___105830){
var seq__105759_105831__$1 = temp__5735__auto___105830;
if(cljs.core.chunked_seq_QMARK_(seq__105759_105831__$1)){
var c__4550__auto___105832 = cljs.core.chunk_first(seq__105759_105831__$1);
var G__105833 = cljs.core.chunk_rest(seq__105759_105831__$1);
var G__105834 = c__4550__auto___105832;
var G__105835 = cljs.core.count(c__4550__auto___105832);
var G__105836 = (0);
seq__105759_105795 = G__105833;
chunk__105760_105796 = G__105834;
count__105761_105797 = G__105835;
i__105762_105798 = G__105836;
continue;
} else {
var map__105787_105837 = cljs.core.first(seq__105759_105831__$1);
var map__105787_105838__$1 = (((((!((map__105787_105837 == null))))?(((((map__105787_105837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105787_105837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105787_105837):map__105787_105837);
var ts_105839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105787_105838__$1,cljs.core.cst$kw$tests);
var map__105788_105840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105787_105838__$1,cljs.core.cst$kw$then);
var map__105788_105841__$1 = (((((!((map__105788_105840 == null))))?(((((map__105788_105840.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105788_105840.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105788_105840):map__105788_105840);
var then_105842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105788_105841__$1,cljs.core.cst$kw$then);
var seq__105791_105843 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_105839));
var chunk__105792_105844 = null;
var count__105793_105845 = (0);
var i__105794_105846 = (0);
while(true){
if((i__105794_105846 < count__105793_105845)){
var test_105847 = chunk__105792_105844.cljs$core$IIndexed$_nth$arity$2(null,i__105794_105846);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_105847,":");


var G__105848 = seq__105791_105843;
var G__105849 = chunk__105792_105844;
var G__105850 = count__105793_105845;
var G__105851 = (i__105794_105846 + (1));
seq__105791_105843 = G__105848;
chunk__105792_105844 = G__105849;
count__105793_105845 = G__105850;
i__105794_105846 = G__105851;
continue;
} else {
var temp__5735__auto___105852__$1 = cljs.core.seq(seq__105791_105843);
if(temp__5735__auto___105852__$1){
var seq__105791_105853__$1 = temp__5735__auto___105852__$1;
if(cljs.core.chunked_seq_QMARK_(seq__105791_105853__$1)){
var c__4550__auto___105854 = cljs.core.chunk_first(seq__105791_105853__$1);
var G__105855 = cljs.core.chunk_rest(seq__105791_105853__$1);
var G__105856 = c__4550__auto___105854;
var G__105857 = cljs.core.count(c__4550__auto___105854);
var G__105858 = (0);
seq__105791_105843 = G__105855;
chunk__105792_105844 = G__105856;
count__105793_105845 = G__105857;
i__105794_105846 = G__105858;
continue;
} else {
var test_105859 = cljs.core.first(seq__105791_105853__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_105859,":");


var G__105860 = cljs.core.next(seq__105791_105853__$1);
var G__105861 = null;
var G__105862 = (0);
var G__105863 = (0);
seq__105791_105843 = G__105860;
chunk__105792_105844 = G__105861;
count__105793_105845 = G__105862;
i__105794_105846 = G__105863;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_105842);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_105842);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__105864 = cljs.core.next(seq__105759_105831__$1);
var G__105865 = null;
var G__105866 = (0);
var G__105867 = (0);
seq__105759_105795 = G__105864;
chunk__105760_105796 = G__105865;
count__105761_105797 = G__105866;
i__105762_105798 = G__105867;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__105868){
var map__105869 = p__105868;
var map__105869__$1 = (((((!((map__105869 == null))))?(((((map__105869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105869.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105869):map__105869);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105869__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105869__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__105874 = env;
var G__105875 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__105874,G__105875) : cljs.compiler.resolve_type.call(null,G__105874,G__105875));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__105876 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105876,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105876,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (idx,vec__105876,fstr,rstr,ret_t,axstr){
return (function (p1__105871_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__105871_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__105871_SHARP_));
});})(idx,vec__105876,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__105879 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__105879,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__105879;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__105882 = env;
var G__105883 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__105882,G__105883) : cljs.compiler.resolve_type.call(null,G__105882,G__105883));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ts__$1,xs){
return (function (p1__105884_SHARP_){
return cljs.compiler.resolve_type(env,p1__105884_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__105885 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__105886 = cljs.core.seq(vec__105885);
var first__105887 = cljs.core.first(seq__105886);
var seq__105886__$1 = cljs.core.next(seq__105886);
var p = first__105887;
var first__105887__$1 = cljs.core.first(seq__105886__$1);
var seq__105886__$2 = cljs.core.next(seq__105886__$1);
var ts = first__105887__$1;
var first__105887__$2 = cljs.core.first(seq__105886__$2);
var seq__105886__$3 = cljs.core.next(seq__105886__$2);
var n = first__105887__$2;
var xs = seq__105886__$3;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4120__auto__){
var and__4120__auto____$1 = ts;
if(cljs.core.truth_(and__4120__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__105888 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__105889 = cljs.core.seq(vec__105888);
var first__105890 = cljs.core.first(seq__105889);
var seq__105889__$1 = cljs.core.next(seq__105889);
var p = first__105890;
var first__105890__$1 = cljs.core.first(seq__105889__$1);
var seq__105889__$2 = cljs.core.next(seq__105889__$1);
var ts = first__105890__$1;
var xs = seq__105889__$2;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4120__auto__){
var and__4120__auto____$1 = ts;
if(cljs.core.truth_(and__4120__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__105892 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__105891 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__105891.cljs$core$IFn$_invoke$arity$1 ? fexpr__105891.cljs$core$IFn$_invoke$arity$1(G__105892) : fexpr__105891.call(null,G__105892));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__105895 = arguments.length;
switch (G__105895) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__105903 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (docs,docs__$1,docs__$2){
return (function (p1__105893_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__105893_SHARP_);
} else {
return p1__105893_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines(e));
var seq__105904 = cljs.core.seq(vec__105903);
var first__105905 = cljs.core.first(seq__105904);
var seq__105904__$1 = cljs.core.next(seq__105904);
var x = first__105905;
var ys = seq__105904__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__105906 = cljs.core.seq(ys);
var chunk__105907 = null;
var count__105908 = (0);
var i__105909 = (0);
while(true){
if((i__105909 < count__105908)){
var next_line = chunk__105907.cljs$core$IIndexed$_nth$arity$2(null,i__105909);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__105915 = seq__105906;
var G__105916 = chunk__105907;
var G__105917 = count__105908;
var G__105918 = (i__105909 + (1));
seq__105906 = G__105915;
chunk__105907 = G__105916;
count__105908 = G__105917;
i__105909 = G__105918;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__105906);
if(temp__5735__auto__){
var seq__105906__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__105906__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__105906__$1);
var G__105919 = cljs.core.chunk_rest(seq__105906__$1);
var G__105920 = c__4550__auto__;
var G__105921 = cljs.core.count(c__4550__auto__);
var G__105922 = (0);
seq__105906 = G__105919;
chunk__105907 = G__105920;
count__105908 = G__105921;
i__105909 = G__105922;
continue;
} else {
var next_line = cljs.core.first(seq__105906__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__105923 = cljs.core.next(seq__105906__$1);
var G__105924 = null;
var G__105925 = (0);
var G__105926 = (0);
seq__105906 = G__105923;
chunk__105907 = G__105924;
count__105908 = G__105925;
i__105909 = G__105926;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__105910_105927 = cljs.core.seq(docs__$2);
var chunk__105911_105928 = null;
var count__105912_105929 = (0);
var i__105913_105930 = (0);
while(true){
if((i__105913_105930 < count__105912_105929)){
var e_105931 = chunk__105911_105928.cljs$core$IIndexed$_nth$arity$2(null,i__105913_105930);
if(cljs.core.truth_(e_105931)){
print_comment_lines(e_105931);
} else {
}


var G__105932 = seq__105910_105927;
var G__105933 = chunk__105911_105928;
var G__105934 = count__105912_105929;
var G__105935 = (i__105913_105930 + (1));
seq__105910_105927 = G__105932;
chunk__105911_105928 = G__105933;
count__105912_105929 = G__105934;
i__105913_105930 = G__105935;
continue;
} else {
var temp__5735__auto___105936 = cljs.core.seq(seq__105910_105927);
if(temp__5735__auto___105936){
var seq__105910_105937__$1 = temp__5735__auto___105936;
if(cljs.core.chunked_seq_QMARK_(seq__105910_105937__$1)){
var c__4550__auto___105938 = cljs.core.chunk_first(seq__105910_105937__$1);
var G__105939 = cljs.core.chunk_rest(seq__105910_105937__$1);
var G__105940 = c__4550__auto___105938;
var G__105941 = cljs.core.count(c__4550__auto___105938);
var G__105942 = (0);
seq__105910_105927 = G__105939;
chunk__105911_105928 = G__105940;
count__105912_105929 = G__105941;
i__105913_105930 = G__105942;
continue;
} else {
var e_105943 = cljs.core.first(seq__105910_105937__$1);
if(cljs.core.truth_(e_105943)){
print_comment_lines(e_105943);
} else {
}


var G__105944 = cljs.core.next(seq__105910_105937__$1);
var G__105945 = null;
var G__105946 = (0);
var G__105947 = (0);
seq__105910_105927 = G__105944;
chunk__105911_105928 = G__105945;
count__105912_105929 = G__105946;
i__105913_105930 = G__105947;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4120__auto__ = cljs.core.some(((function (opts){
return (function (p1__105949_SHARP_){
return goog.string.startsWith(p1__105949_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = opts;
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4120__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__105950){
var map__105951 = p__105950;
var map__105951__$1 = (((((!((map__105951 == null))))?(((((map__105951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105951.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105951):map__105951);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$test);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105951__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4131__auto__ = init;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__4120__auto__){
return test;
} else {
return and__4120__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__105953){
var map__105954 = p__105953;
var map__105954__$1 = (((((!((map__105954 == null))))?(((((map__105954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105954.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105954):map__105954);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105954__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105954__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105954__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__105956_105980 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__105957_105981 = null;
var count__105958_105982 = (0);
var i__105959_105983 = (0);
while(true){
if((i__105959_105983 < count__105958_105982)){
var vec__105966_105984 = chunk__105957_105981.cljs$core$IIndexed$_nth$arity$2(null,i__105959_105983);
var i_105985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105966_105984,(0),null);
var param_105986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105966_105984,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_105986);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__105987 = seq__105956_105980;
var G__105988 = chunk__105957_105981;
var G__105989 = count__105958_105982;
var G__105990 = (i__105959_105983 + (1));
seq__105956_105980 = G__105987;
chunk__105957_105981 = G__105988;
count__105958_105982 = G__105989;
i__105959_105983 = G__105990;
continue;
} else {
var temp__5735__auto___105991 = cljs.core.seq(seq__105956_105980);
if(temp__5735__auto___105991){
var seq__105956_105992__$1 = temp__5735__auto___105991;
if(cljs.core.chunked_seq_QMARK_(seq__105956_105992__$1)){
var c__4550__auto___105993 = cljs.core.chunk_first(seq__105956_105992__$1);
var G__105994 = cljs.core.chunk_rest(seq__105956_105992__$1);
var G__105995 = c__4550__auto___105993;
var G__105996 = cljs.core.count(c__4550__auto___105993);
var G__105997 = (0);
seq__105956_105980 = G__105994;
chunk__105957_105981 = G__105995;
count__105958_105982 = G__105996;
i__105959_105983 = G__105997;
continue;
} else {
var vec__105969_105998 = cljs.core.first(seq__105956_105992__$1);
var i_105999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105969_105998,(0),null);
var param_106000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105969_105998,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_106000);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__106001 = cljs.core.next(seq__105956_105992__$1);
var G__106002 = null;
var G__106003 = (0);
var G__106004 = (0);
seq__105956_105980 = G__106001;
chunk__105957_105981 = G__106002;
count__105958_105982 = G__106003;
i__105959_105983 = G__106004;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__105972_106005 = cljs.core.seq(params);
var chunk__105973_106006 = null;
var count__105974_106007 = (0);
var i__105975_106008 = (0);
while(true){
if((i__105975_106008 < count__105974_106007)){
var param_106009 = chunk__105973_106006.cljs$core$IIndexed$_nth$arity$2(null,i__105975_106008);
cljs.compiler.emit(param_106009);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106009,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106010 = seq__105972_106005;
var G__106011 = chunk__105973_106006;
var G__106012 = count__105974_106007;
var G__106013 = (i__105975_106008 + (1));
seq__105972_106005 = G__106010;
chunk__105973_106006 = G__106011;
count__105974_106007 = G__106012;
i__105975_106008 = G__106013;
continue;
} else {
var temp__5735__auto___106014 = cljs.core.seq(seq__105972_106005);
if(temp__5735__auto___106014){
var seq__105972_106015__$1 = temp__5735__auto___106014;
if(cljs.core.chunked_seq_QMARK_(seq__105972_106015__$1)){
var c__4550__auto___106016 = cljs.core.chunk_first(seq__105972_106015__$1);
var G__106017 = cljs.core.chunk_rest(seq__105972_106015__$1);
var G__106018 = c__4550__auto___106016;
var G__106019 = cljs.core.count(c__4550__auto___106016);
var G__106020 = (0);
seq__105972_106005 = G__106017;
chunk__105973_106006 = G__106018;
count__105974_106007 = G__106019;
i__105975_106008 = G__106020;
continue;
} else {
var param_106021 = cljs.core.first(seq__105972_106015__$1);
cljs.compiler.emit(param_106021);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106021,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106022 = cljs.core.next(seq__105972_106015__$1);
var G__106023 = null;
var G__106024 = (0);
var G__106025 = (0);
seq__105972_106005 = G__106022;
chunk__105973_106006 = G__106023;
count__105974_106007 = G__106024;
i__105975_106008 = G__106025;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__105976_106026 = cljs.core.seq(params);
var chunk__105977_106027 = null;
var count__105978_106028 = (0);
var i__105979_106029 = (0);
while(true){
if((i__105979_106029 < count__105978_106028)){
var param_106030 = chunk__105977_106027.cljs$core$IIndexed$_nth$arity$2(null,i__105979_106029);
cljs.compiler.emit(param_106030);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106030,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106031 = seq__105976_106026;
var G__106032 = chunk__105977_106027;
var G__106033 = count__105978_106028;
var G__106034 = (i__105979_106029 + (1));
seq__105976_106026 = G__106031;
chunk__105977_106027 = G__106032;
count__105978_106028 = G__106033;
i__105979_106029 = G__106034;
continue;
} else {
var temp__5735__auto___106035 = cljs.core.seq(seq__105976_106026);
if(temp__5735__auto___106035){
var seq__105976_106036__$1 = temp__5735__auto___106035;
if(cljs.core.chunked_seq_QMARK_(seq__105976_106036__$1)){
var c__4550__auto___106037 = cljs.core.chunk_first(seq__105976_106036__$1);
var G__106038 = cljs.core.chunk_rest(seq__105976_106036__$1);
var G__106039 = c__4550__auto___106037;
var G__106040 = cljs.core.count(c__4550__auto___106037);
var G__106041 = (0);
seq__105976_106026 = G__106038;
chunk__105977_106027 = G__106039;
count__105978_106028 = G__106040;
i__105979_106029 = G__106041;
continue;
} else {
var param_106042 = cljs.core.first(seq__105976_106036__$1);
cljs.compiler.emit(param_106042);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106042,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106043 = cljs.core.next(seq__105976_106036__$1);
var G__106044 = null;
var G__106045 = (0);
var G__106046 = (0);
seq__105976_106026 = G__106043;
chunk__105977_106027 = G__106044;
count__105978_106028 = G__106045;
i__105979_106029 = G__106046;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__106047 = cljs.core.seq(params);
var chunk__106048 = null;
var count__106049 = (0);
var i__106050 = (0);
while(true){
if((i__106050 < count__106049)){
var param = chunk__106048.cljs$core$IIndexed$_nth$arity$2(null,i__106050);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106051 = seq__106047;
var G__106052 = chunk__106048;
var G__106053 = count__106049;
var G__106054 = (i__106050 + (1));
seq__106047 = G__106051;
chunk__106048 = G__106052;
count__106049 = G__106053;
i__106050 = G__106054;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__106047);
if(temp__5735__auto__){
var seq__106047__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__106047__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__106047__$1);
var G__106055 = cljs.core.chunk_rest(seq__106047__$1);
var G__106056 = c__4550__auto__;
var G__106057 = cljs.core.count(c__4550__auto__);
var G__106058 = (0);
seq__106047 = G__106055;
chunk__106048 = G__106056;
count__106049 = G__106057;
i__106050 = G__106058;
continue;
} else {
var param = cljs.core.first(seq__106047__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106059 = cljs.core.next(seq__106047__$1);
var G__106060 = null;
var G__106061 = (0);
var G__106062 = (0);
seq__106047 = G__106059;
chunk__106048 = G__106060;
count__106049 = G__106061;
i__106050 = G__106062;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__106063){
var map__106064 = p__106063;
var map__106064__$1 = (((((!((map__106064 == null))))?(((((map__106064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106064):map__106064);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106064__$1,cljs.core.cst$kw$recurs);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__106066){
var map__106067 = p__106066;
var map__106067__$1 = (((((!((map__106067 == null))))?(((((map__106067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106067):map__106067);
var f = map__106067__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106067__$1,cljs.core.cst$kw$recurs);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_106077__$1 = (function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_106078 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_106077__$1);
var delegate_name_106079 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_106078),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_106079," = function (");

var seq__106069_106080 = cljs.core.seq(params);
var chunk__106070_106081 = null;
var count__106071_106082 = (0);
var i__106072_106083 = (0);
while(true){
if((i__106072_106083 < count__106071_106082)){
var param_106084 = chunk__106070_106081.cljs$core$IIndexed$_nth$arity$2(null,i__106072_106083);
cljs.compiler.emit(param_106084);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106084,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106085 = seq__106069_106080;
var G__106086 = chunk__106070_106081;
var G__106087 = count__106071_106082;
var G__106088 = (i__106072_106083 + (1));
seq__106069_106080 = G__106085;
chunk__106070_106081 = G__106086;
count__106071_106082 = G__106087;
i__106072_106083 = G__106088;
continue;
} else {
var temp__5735__auto___106089 = cljs.core.seq(seq__106069_106080);
if(temp__5735__auto___106089){
var seq__106069_106090__$1 = temp__5735__auto___106089;
if(cljs.core.chunked_seq_QMARK_(seq__106069_106090__$1)){
var c__4550__auto___106091 = cljs.core.chunk_first(seq__106069_106090__$1);
var G__106092 = cljs.core.chunk_rest(seq__106069_106090__$1);
var G__106093 = c__4550__auto___106091;
var G__106094 = cljs.core.count(c__4550__auto___106091);
var G__106095 = (0);
seq__106069_106080 = G__106092;
chunk__106070_106081 = G__106093;
count__106071_106082 = G__106094;
i__106072_106083 = G__106095;
continue;
} else {
var param_106096 = cljs.core.first(seq__106069_106090__$1);
cljs.compiler.emit(param_106096);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106096,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106097 = cljs.core.next(seq__106069_106090__$1);
var G__106098 = null;
var G__106099 = (0);
var G__106100 = (0);
seq__106069_106080 = G__106097;
chunk__106070_106081 = G__106098;
count__106071_106082 = G__106099;
i__106072_106083 = G__106100;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_106078," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_106101 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_106101,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_106079,".call(this,");

var seq__106073_106102 = cljs.core.seq(params);
var chunk__106074_106103 = null;
var count__106075_106104 = (0);
var i__106076_106105 = (0);
while(true){
if((i__106076_106105 < count__106075_106104)){
var param_106106 = chunk__106074_106103.cljs$core$IIndexed$_nth$arity$2(null,i__106076_106105);
cljs.compiler.emit(param_106106);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106106,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106107 = seq__106073_106102;
var G__106108 = chunk__106074_106103;
var G__106109 = count__106075_106104;
var G__106110 = (i__106076_106105 + (1));
seq__106073_106102 = G__106107;
chunk__106074_106103 = G__106108;
count__106075_106104 = G__106109;
i__106076_106105 = G__106110;
continue;
} else {
var temp__5735__auto___106111 = cljs.core.seq(seq__106073_106102);
if(temp__5735__auto___106111){
var seq__106073_106112__$1 = temp__5735__auto___106111;
if(cljs.core.chunked_seq_QMARK_(seq__106073_106112__$1)){
var c__4550__auto___106113 = cljs.core.chunk_first(seq__106073_106112__$1);
var G__106114 = cljs.core.chunk_rest(seq__106073_106112__$1);
var G__106115 = c__4550__auto___106113;
var G__106116 = cljs.core.count(c__4550__auto___106113);
var G__106117 = (0);
seq__106073_106102 = G__106114;
chunk__106074_106103 = G__106115;
count__106075_106104 = G__106116;
i__106076_106105 = G__106117;
continue;
} else {
var param_106118 = cljs.core.first(seq__106073_106112__$1);
cljs.compiler.emit(param_106118);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_106118,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__106119 = cljs.core.next(seq__106073_106112__$1);
var G__106120 = null;
var G__106121 = (0);
var G__106122 = (0);
seq__106073_106102 = G__106119;
chunk__106074_106103 = G__106120;
count__106075_106104 = G__106121;
i__106076_106105 = G__106122;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106078,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_106078,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_106077__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106078,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_106079,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_106078,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__106126){
var map__106127 = p__106126;
var map__106127__$1 = (((((!((map__106127 == null))))?(((((map__106127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106127.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106127):map__106127);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$recur_DASH_frames);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106127__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__106123_SHARP_){
var and__4120__auto__ = p1__106123_SHARP_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__106123_SHARP_));
} else {
return and__4120__auto__;
}
});})(map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,recur_frames)], 0)),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_106180__$1 = (function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_106181 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_106180__$1);
var maxparams_106182 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_106183 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (name_106180__$1,mname_106181,maxparams_106182,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_106181),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_106180__$1,mname_106181,maxparams_106182,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,methods$));
var ms_106184 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (name_106180__$1,mname_106181,maxparams_106182,mmap_106183,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__106124_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__106124_SHARP_)));
});})(name_106180__$1,mname_106181,maxparams_106182,mmap_106183,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,cljs.core.seq(mmap_106183));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_106181," = null;");

var seq__106129_106185 = cljs.core.seq(ms_106184);
var chunk__106130_106186 = null;
var count__106131_106187 = (0);
var i__106132_106188 = (0);
while(true){
if((i__106132_106188 < count__106131_106187)){
var vec__106139_106189 = chunk__106130_106186.cljs$core$IIndexed$_nth$arity$2(null,i__106132_106188);
var n_106190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106139_106189,(0),null);
var meth_106191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106139_106189,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_106190," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106191))){
cljs.compiler.emit_variadic_fn_method(meth_106191);
} else {
cljs.compiler.emit_fn_method(meth_106191);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__106192 = seq__106129_106185;
var G__106193 = chunk__106130_106186;
var G__106194 = count__106131_106187;
var G__106195 = (i__106132_106188 + (1));
seq__106129_106185 = G__106192;
chunk__106130_106186 = G__106193;
count__106131_106187 = G__106194;
i__106132_106188 = G__106195;
continue;
} else {
var temp__5735__auto___106196 = cljs.core.seq(seq__106129_106185);
if(temp__5735__auto___106196){
var seq__106129_106197__$1 = temp__5735__auto___106196;
if(cljs.core.chunked_seq_QMARK_(seq__106129_106197__$1)){
var c__4550__auto___106198 = cljs.core.chunk_first(seq__106129_106197__$1);
var G__106199 = cljs.core.chunk_rest(seq__106129_106197__$1);
var G__106200 = c__4550__auto___106198;
var G__106201 = cljs.core.count(c__4550__auto___106198);
var G__106202 = (0);
seq__106129_106185 = G__106199;
chunk__106130_106186 = G__106200;
count__106131_106187 = G__106201;
i__106132_106188 = G__106202;
continue;
} else {
var vec__106142_106203 = cljs.core.first(seq__106129_106197__$1);
var n_106204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106142_106203,(0),null);
var meth_106205 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106142_106203,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_106204," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106205))){
cljs.compiler.emit_variadic_fn_method(meth_106205);
} else {
cljs.compiler.emit_fn_method(meth_106205);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__106206 = cljs.core.next(seq__106129_106197__$1);
var G__106207 = null;
var G__106208 = (0);
var G__106209 = (0);
seq__106129_106185 = G__106206;
chunk__106130_106186 = G__106207;
count__106131_106187 = G__106208;
i__106132_106188 = G__106209;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106181," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_106182),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_106182)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_106182));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__106145_106210 = cljs.core.seq(ms_106184);
var chunk__106146_106211 = null;
var count__106147_106212 = (0);
var i__106148_106213 = (0);
while(true){
if((i__106148_106213 < count__106147_106212)){
var vec__106155_106214 = chunk__106146_106211.cljs$core$IIndexed$_nth$arity$2(null,i__106148_106213);
var n_106215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106155_106214,(0),null);
var meth_106216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106155_106214,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106216))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_106217 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_106217," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_106218 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_106217," = new cljs.core.IndexedSeq(",a_106218,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_106215,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_106182)),(((cljs.core.count(maxparams_106182) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_106217,");"], 0));
} else {
var pcnt_106219 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_106216));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_106219,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_106215,".call(this",(((pcnt_106219 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_106219,maxparams_106182)),null,(1),null)),(2),null))),");");
}


var G__106220 = seq__106145_106210;
var G__106221 = chunk__106146_106211;
var G__106222 = count__106147_106212;
var G__106223 = (i__106148_106213 + (1));
seq__106145_106210 = G__106220;
chunk__106146_106211 = G__106221;
count__106147_106212 = G__106222;
i__106148_106213 = G__106223;
continue;
} else {
var temp__5735__auto___106224 = cljs.core.seq(seq__106145_106210);
if(temp__5735__auto___106224){
var seq__106145_106225__$1 = temp__5735__auto___106224;
if(cljs.core.chunked_seq_QMARK_(seq__106145_106225__$1)){
var c__4550__auto___106226 = cljs.core.chunk_first(seq__106145_106225__$1);
var G__106227 = cljs.core.chunk_rest(seq__106145_106225__$1);
var G__106228 = c__4550__auto___106226;
var G__106229 = cljs.core.count(c__4550__auto___106226);
var G__106230 = (0);
seq__106145_106210 = G__106227;
chunk__106146_106211 = G__106228;
count__106147_106212 = G__106229;
i__106148_106213 = G__106230;
continue;
} else {
var vec__106158_106231 = cljs.core.first(seq__106145_106225__$1);
var n_106232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106158_106231,(0),null);
var meth_106233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106158_106231,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106233))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_106234 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_106234," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_106235 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_106234," = new cljs.core.IndexedSeq(",a_106235,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_106232,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_106182)),(((cljs.core.count(maxparams_106182) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_106234,");"], 0));
} else {
var pcnt_106236 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_106233));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_106236,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_106232,".call(this",(((pcnt_106236 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_106236,maxparams_106182)),null,(1),null)),(2),null))),");");
}


var G__106237 = cljs.core.next(seq__106145_106225__$1);
var G__106238 = null;
var G__106239 = (0);
var G__106240 = (0);
seq__106145_106210 = G__106237;
chunk__106146_106211 = G__106238;
count__106147_106212 = G__106239;
i__106148_106213 = G__106240;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_106241 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_106184)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_106241,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106181,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106181,".cljs$lang$applyTo = ",cljs.core.some(((function (name_106180__$1,mname_106181,maxparams_106182,mmap_106183,ms_106184,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__106125_SHARP_){
var vec__106161 = p1__106125_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106161,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106161,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_106180__$1,mname_106181,maxparams_106182,mmap_106183,ms_106184,loop_locals,map__106127,map__106127__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,ms_106184),".cljs$lang$applyTo;");
} else {
}

var seq__106164_106242 = cljs.core.seq(ms_106184);
var chunk__106165_106243 = null;
var count__106166_106244 = (0);
var i__106167_106245 = (0);
while(true){
if((i__106167_106245 < count__106166_106244)){
var vec__106174_106246 = chunk__106165_106243.cljs$core$IIndexed$_nth$arity$2(null,i__106167_106245);
var n_106247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106174_106246,(0),null);
var meth_106248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106174_106246,(1),null);
var c_106249 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_106248));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106248))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106181,".cljs$core$IFn$_invoke$arity$variadic = ",n_106247,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_106181,".cljs$core$IFn$_invoke$arity$",c_106249," = ",n_106247,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__106250 = seq__106164_106242;
var G__106251 = chunk__106165_106243;
var G__106252 = count__106166_106244;
var G__106253 = (i__106167_106245 + (1));
seq__106164_106242 = G__106250;
chunk__106165_106243 = G__106251;
count__106166_106244 = G__106252;
i__106167_106245 = G__106253;
continue;
} else {
var temp__5735__auto___106254 = cljs.core.seq(seq__106164_106242);
if(temp__5735__auto___106254){
var seq__106164_106255__$1 = temp__5735__auto___106254;
if(cljs.core.chunked_seq_QMARK_(seq__106164_106255__$1)){
var c__4550__auto___106256 = cljs.core.chunk_first(seq__106164_106255__$1);
var G__106257 = cljs.core.chunk_rest(seq__106164_106255__$1);
var G__106258 = c__4550__auto___106256;
var G__106259 = cljs.core.count(c__4550__auto___106256);
var G__106260 = (0);
seq__106164_106242 = G__106257;
chunk__106165_106243 = G__106258;
count__106166_106244 = G__106259;
i__106167_106245 = G__106260;
continue;
} else {
var vec__106177_106261 = cljs.core.first(seq__106164_106255__$1);
var n_106262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106177_106261,(0),null);
var meth_106263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106177_106261,(1),null);
var c_106264 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_106263));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_106263))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_106181,".cljs$core$IFn$_invoke$arity$variadic = ",n_106262,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_106181,".cljs$core$IFn$_invoke$arity$",c_106264," = ",n_106262,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__106265 = cljs.core.next(seq__106164_106255__$1);
var G__106266 = null;
var G__106267 = (0);
var G__106268 = (0);
seq__106164_106242 = G__106265;
chunk__106165_106243 = G__106266;
count__106166_106244 = G__106267;
i__106167_106245 = G__106268;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_106181,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__106269){
var map__106270 = p__106269;
var map__106270__$1 = (((((!((map__106270 == null))))?(((((map__106270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106270.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106270):map__106270);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106270__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106270__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106270__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__106272_106276 = cljs.core.seq(statements);
var chunk__106273_106277 = null;
var count__106274_106278 = (0);
var i__106275_106279 = (0);
while(true){
if((i__106275_106279 < count__106274_106278)){
var s_106280 = chunk__106273_106277.cljs$core$IIndexed$_nth$arity$2(null,i__106275_106279);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_106280);


var G__106281 = seq__106272_106276;
var G__106282 = chunk__106273_106277;
var G__106283 = count__106274_106278;
var G__106284 = (i__106275_106279 + (1));
seq__106272_106276 = G__106281;
chunk__106273_106277 = G__106282;
count__106274_106278 = G__106283;
i__106275_106279 = G__106284;
continue;
} else {
var temp__5735__auto___106285 = cljs.core.seq(seq__106272_106276);
if(temp__5735__auto___106285){
var seq__106272_106286__$1 = temp__5735__auto___106285;
if(cljs.core.chunked_seq_QMARK_(seq__106272_106286__$1)){
var c__4550__auto___106287 = cljs.core.chunk_first(seq__106272_106286__$1);
var G__106288 = cljs.core.chunk_rest(seq__106272_106286__$1);
var G__106289 = c__4550__auto___106287;
var G__106290 = cljs.core.count(c__4550__auto___106287);
var G__106291 = (0);
seq__106272_106276 = G__106288;
chunk__106273_106277 = G__106289;
count__106274_106278 = G__106290;
i__106275_106279 = G__106291;
continue;
} else {
var s_106292 = cljs.core.first(seq__106272_106286__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_106292);


var G__106293 = cljs.core.next(seq__106272_106286__$1);
var G__106294 = null;
var G__106295 = (0);
var G__106296 = (0);
seq__106272_106276 = G__106293;
chunk__106273_106277 = G__106294;
count__106274_106278 = G__106295;
i__106275_106279 = G__106296;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__106297){
var map__106298 = p__106297;
var map__106298__$1 = (((((!((map__106298 == null))))?(((((map__106298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106298.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106298):map__106298);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106298__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106298__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106298__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106298__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106298__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__106300,is_loop){
var map__106301 = p__106300;
var map__106301__$1 = (((((!((map__106301 == null))))?(((((map__106301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106301):map__106301);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106301__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106301__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106301__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__106303_106317 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__106304_106318 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_lexical_renames_STAR__orig_val__106303_106317,context,map__106301,map__106301__$1,expr,bindings,env){
return (function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR__orig_val__106303_106317,context,map__106301,map__106301__$1,expr,bindings,env))
,bindings):null));
cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__106304_106318;

try{var seq__106305_106319 = cljs.core.seq(bindings);
var chunk__106306_106320 = null;
var count__106307_106321 = (0);
var i__106308_106322 = (0);
while(true){
if((i__106308_106322 < count__106307_106321)){
var map__106313_106323 = chunk__106306_106320.cljs$core$IIndexed$_nth$arity$2(null,i__106308_106322);
var map__106313_106324__$1 = (((((!((map__106313_106323 == null))))?(((((map__106313_106323.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106313_106323.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106313_106323):map__106313_106323);
var binding_106325 = map__106313_106324__$1;
var init_106326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106313_106324__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_106325);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_106326,";");


var G__106327 = seq__106305_106319;
var G__106328 = chunk__106306_106320;
var G__106329 = count__106307_106321;
var G__106330 = (i__106308_106322 + (1));
seq__106305_106319 = G__106327;
chunk__106306_106320 = G__106328;
count__106307_106321 = G__106329;
i__106308_106322 = G__106330;
continue;
} else {
var temp__5735__auto___106331 = cljs.core.seq(seq__106305_106319);
if(temp__5735__auto___106331){
var seq__106305_106332__$1 = temp__5735__auto___106331;
if(cljs.core.chunked_seq_QMARK_(seq__106305_106332__$1)){
var c__4550__auto___106333 = cljs.core.chunk_first(seq__106305_106332__$1);
var G__106334 = cljs.core.chunk_rest(seq__106305_106332__$1);
var G__106335 = c__4550__auto___106333;
var G__106336 = cljs.core.count(c__4550__auto___106333);
var G__106337 = (0);
seq__106305_106319 = G__106334;
chunk__106306_106320 = G__106335;
count__106307_106321 = G__106336;
i__106308_106322 = G__106337;
continue;
} else {
var map__106315_106338 = cljs.core.first(seq__106305_106332__$1);
var map__106315_106339__$1 = (((((!((map__106315_106338 == null))))?(((((map__106315_106338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106315_106338.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106315_106338):map__106315_106338);
var binding_106340 = map__106315_106339__$1;
var init_106341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106315_106339__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_106340);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_106341,";");


var G__106342 = cljs.core.next(seq__106305_106332__$1);
var G__106343 = null;
var G__106344 = (0);
var G__106345 = (0);
seq__106305_106319 = G__106342;
chunk__106306_106320 = G__106343;
count__106307_106321 = G__106344;
i__106308_106322 = G__106345;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__106303_106317;
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__106346){
var map__106347 = p__106346;
var map__106347__$1 = (((((!((map__106347 == null))))?(((((map__106347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106347.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106347):map__106347);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106347__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4607__auto___106349 = cljs.core.count(exprs);
var i_106350 = (0);
while(true){
if((i_106350 < n__4607__auto___106349)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_106350) : temps.call(null,i_106350))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_106350) : exprs.call(null,i_106350)),";");

var G__106351 = (i_106350 + (1));
i_106350 = G__106351;
continue;
} else {
}
break;
}

var n__4607__auto___106352 = cljs.core.count(exprs);
var i_106353 = (0);
while(true){
if((i_106353 < n__4607__auto___106352)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_106353) : params.call(null,i_106353)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_106353) : temps.call(null,i_106353)),";");

var G__106354 = (i_106353 + (1));
i_106353 = G__106354;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__106355){
var map__106356 = p__106355;
var map__106356__$1 = (((((!((map__106356 == null))))?(((((map__106356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106356.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106356):map__106356);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106356__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106356__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106356__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__106358_106370 = cljs.core.seq(bindings);
var chunk__106359_106371 = null;
var count__106360_106372 = (0);
var i__106361_106373 = (0);
while(true){
if((i__106361_106373 < count__106360_106372)){
var map__106366_106374 = chunk__106359_106371.cljs$core$IIndexed$_nth$arity$2(null,i__106361_106373);
var map__106366_106375__$1 = (((((!((map__106366_106374 == null))))?(((((map__106366_106374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106366_106374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106366_106374):map__106366_106374);
var binding_106376 = map__106366_106375__$1;
var init_106377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106366_106375__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_106376)," = ",init_106377,";");


var G__106378 = seq__106358_106370;
var G__106379 = chunk__106359_106371;
var G__106380 = count__106360_106372;
var G__106381 = (i__106361_106373 + (1));
seq__106358_106370 = G__106378;
chunk__106359_106371 = G__106379;
count__106360_106372 = G__106380;
i__106361_106373 = G__106381;
continue;
} else {
var temp__5735__auto___106382 = cljs.core.seq(seq__106358_106370);
if(temp__5735__auto___106382){
var seq__106358_106383__$1 = temp__5735__auto___106382;
if(cljs.core.chunked_seq_QMARK_(seq__106358_106383__$1)){
var c__4550__auto___106384 = cljs.core.chunk_first(seq__106358_106383__$1);
var G__106385 = cljs.core.chunk_rest(seq__106358_106383__$1);
var G__106386 = c__4550__auto___106384;
var G__106387 = cljs.core.count(c__4550__auto___106384);
var G__106388 = (0);
seq__106358_106370 = G__106385;
chunk__106359_106371 = G__106386;
count__106360_106372 = G__106387;
i__106361_106373 = G__106388;
continue;
} else {
var map__106368_106389 = cljs.core.first(seq__106358_106383__$1);
var map__106368_106390__$1 = (((((!((map__106368_106389 == null))))?(((((map__106368_106389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106368_106389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106368_106389):map__106368_106389);
var binding_106391 = map__106368_106390__$1;
var init_106392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106368_106390__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_106391)," = ",init_106392,";");


var G__106393 = cljs.core.next(seq__106358_106383__$1);
var G__106394 = null;
var G__106395 = (0);
var G__106396 = (0);
seq__106358_106370 = G__106393;
chunk__106359_106371 = G__106394;
count__106360_106372 = G__106395;
i__106361_106373 = G__106396;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__106399){
var map__106400 = p__106399;
var map__106400__$1 = (((((!((map__106400 == null))))?(((((map__106400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106400):map__106400);
var expr = map__106400__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106400__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106400__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106400__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4120__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4120__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4120__auto__ = protocol;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = tag;
if(cljs.core.truth_(and__4120__auto____$1)){
var or__4131__auto__ = (function (){var and__4120__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto____$2){
var and__4120__auto____$3 = protocol;
if(cljs.core.truth_(and__4120__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4120__auto____$3;
}
} else {
return and__4120__auto____$2;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto____$2 = (function (){var or__4131__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4120__auto____$2)){
var or__4131__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
var and__4120__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4120__auto____$3){
var and__4120__auto____$4 = cljs.core.not((function (){var fexpr__106410 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__106410.cljs$core$IFn$_invoke$arity$1 ? fexpr__106410.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__106410.call(null,tag));
})());
if(and__4120__auto____$4){
var temp__5735__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4120__auto____$4;
}
} else {
return and__4120__auto____$3;
}
}
} else {
return and__4120__auto____$2;
}
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr))),cljs.core.cst$sym$boolean)));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,cljs.analyzer.infer_tag(env,f));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__106402 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (arity > mfa);
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env){
return (function (p1__106397_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__106397_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env){
return (function (p1__106398_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__106398_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__106400,map__106400__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106402,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106402,(1),null);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_106415 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_106415,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_106416 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_106416,args)),(((mfa_106416 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_106416,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = js_QMARK_;
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto__){
var G__106414 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__106413 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__106413.cljs$core$IFn$_invoke$arity$1 ? fexpr__106413.cljs$core$IFn$_invoke$arity$1(G__106414) : fexpr__106413.call(null,G__106414));
} else {
return and__4120__auto__;
}
})())){
var fprop_106417 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_106417," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_106417,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_106417," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_106417,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__106418){
var map__106419 = p__106418;
var map__106419__$1 = (((((!((map__106419 == null))))?(((((map__106419.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106419.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106419):map__106419);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106419__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106419__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106419__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__106421){
var map__106422 = p__106421;
var map__106422__$1 = (((((!((map__106422 == null))))?(((((map__106422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106422):map__106422);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106422__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106422__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106422__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target," = ",val);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__106424 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__106424__$1 = (((((!((map__106424 == null))))?(((((map__106424.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106424.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106424):map__106424);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106424__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106424__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__106425 = options;
var map__106425__$1 = (((((!((map__106425 == null))))?(((((map__106425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106425.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106425):map__106425);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106425__$1,cljs.core.cst$kw$target);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106425__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__106426 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__106431 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__106431__$1 = (((((!((map__106431 == null))))?(((((map__106431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106431):map__106431);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106431__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106431__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106426,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106426,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__106433_106453 = cljs.core.seq(libs_to_load);
var chunk__106434_106454 = null;
var count__106435_106455 = (0);
var i__106436_106456 = (0);
while(true){
if((i__106436_106456 < count__106435_106455)){
var lib_106457 = chunk__106434_106454.cljs$core$IIndexed$_nth$arity$2(null,i__106436_106456);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_106457)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_106457),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106457),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_106457),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106457),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_106457,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106457),"');");
}

}
}
}


var G__106458 = seq__106433_106453;
var G__106459 = chunk__106434_106454;
var G__106460 = count__106435_106455;
var G__106461 = (i__106436_106456 + (1));
seq__106433_106453 = G__106458;
chunk__106434_106454 = G__106459;
count__106435_106455 = G__106460;
i__106436_106456 = G__106461;
continue;
} else {
var temp__5735__auto___106462 = cljs.core.seq(seq__106433_106453);
if(temp__5735__auto___106462){
var seq__106433_106463__$1 = temp__5735__auto___106462;
if(cljs.core.chunked_seq_QMARK_(seq__106433_106463__$1)){
var c__4550__auto___106464 = cljs.core.chunk_first(seq__106433_106463__$1);
var G__106465 = cljs.core.chunk_rest(seq__106433_106463__$1);
var G__106466 = c__4550__auto___106464;
var G__106467 = cljs.core.count(c__4550__auto___106464);
var G__106468 = (0);
seq__106433_106453 = G__106465;
chunk__106434_106454 = G__106466;
count__106435_106455 = G__106467;
i__106436_106456 = G__106468;
continue;
} else {
var lib_106469 = cljs.core.first(seq__106433_106463__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_106469)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_106469),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106469),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_106469),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106469),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_106469,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_106469),"');");
}

}
}
}


var G__106470 = cljs.core.next(seq__106433_106463__$1);
var G__106471 = null;
var G__106472 = (0);
var G__106473 = (0);
seq__106433_106453 = G__106470;
chunk__106434_106454 = G__106471;
count__106435_106455 = G__106472;
i__106436_106456 = G__106473;
continue;
}
} else {
}
}
break;
}

var seq__106437_106474 = cljs.core.seq(node_libs);
var chunk__106438_106475 = null;
var count__106439_106476 = (0);
var i__106440_106477 = (0);
while(true){
if((i__106440_106477 < count__106439_106476)){
var lib_106478 = chunk__106438_106475.cljs$core$IIndexed$_nth$arity$2(null,i__106440_106477);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_106478)," = require('",lib_106478,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__106479 = seq__106437_106474;
var G__106480 = chunk__106438_106475;
var G__106481 = count__106439_106476;
var G__106482 = (i__106440_106477 + (1));
seq__106437_106474 = G__106479;
chunk__106438_106475 = G__106480;
count__106439_106476 = G__106481;
i__106440_106477 = G__106482;
continue;
} else {
var temp__5735__auto___106483 = cljs.core.seq(seq__106437_106474);
if(temp__5735__auto___106483){
var seq__106437_106484__$1 = temp__5735__auto___106483;
if(cljs.core.chunked_seq_QMARK_(seq__106437_106484__$1)){
var c__4550__auto___106485 = cljs.core.chunk_first(seq__106437_106484__$1);
var G__106486 = cljs.core.chunk_rest(seq__106437_106484__$1);
var G__106487 = c__4550__auto___106485;
var G__106488 = cljs.core.count(c__4550__auto___106485);
var G__106489 = (0);
seq__106437_106474 = G__106486;
chunk__106438_106475 = G__106487;
count__106439_106476 = G__106488;
i__106440_106477 = G__106489;
continue;
} else {
var lib_106490 = cljs.core.first(seq__106437_106484__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_106490)," = require('",lib_106490,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__106491 = cljs.core.next(seq__106437_106484__$1);
var G__106492 = null;
var G__106493 = (0);
var G__106494 = (0);
seq__106437_106474 = G__106491;
chunk__106438_106475 = G__106492;
count__106439_106476 = G__106493;
i__106440_106477 = G__106494;
continue;
}
} else {
}
}
break;
}

var seq__106441_106495 = cljs.core.seq(global_exports_libs);
var chunk__106442_106496 = null;
var count__106443_106497 = (0);
var i__106444_106498 = (0);
while(true){
if((i__106444_106498 < count__106443_106497)){
var lib_106499 = chunk__106442_106496.cljs$core$IIndexed$_nth$arity$2(null,i__106444_106498);
var map__106449_106500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_106499));
var map__106449_106501__$1 = (((((!((map__106449_106500 == null))))?(((((map__106449_106500.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106449_106500.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106449_106500):map__106449_106500);
var global_exports_106502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106449_106501__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_106502,lib_106499);


var G__106503 = seq__106441_106495;
var G__106504 = chunk__106442_106496;
var G__106505 = count__106443_106497;
var G__106506 = (i__106444_106498 + (1));
seq__106441_106495 = G__106503;
chunk__106442_106496 = G__106504;
count__106443_106497 = G__106505;
i__106444_106498 = G__106506;
continue;
} else {
var temp__5735__auto___106507 = cljs.core.seq(seq__106441_106495);
if(temp__5735__auto___106507){
var seq__106441_106508__$1 = temp__5735__auto___106507;
if(cljs.core.chunked_seq_QMARK_(seq__106441_106508__$1)){
var c__4550__auto___106509 = cljs.core.chunk_first(seq__106441_106508__$1);
var G__106510 = cljs.core.chunk_rest(seq__106441_106508__$1);
var G__106511 = c__4550__auto___106509;
var G__106512 = cljs.core.count(c__4550__auto___106509);
var G__106513 = (0);
seq__106441_106495 = G__106510;
chunk__106442_106496 = G__106511;
count__106443_106497 = G__106512;
i__106444_106498 = G__106513;
continue;
} else {
var lib_106514 = cljs.core.first(seq__106441_106508__$1);
var map__106451_106515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_106514));
var map__106451_106516__$1 = (((((!((map__106451_106515 == null))))?(((((map__106451_106515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106451_106515.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106451_106515):map__106451_106515);
var global_exports_106517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106451_106516__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_106517,lib_106514);


var G__106518 = cljs.core.next(seq__106441_106508__$1);
var G__106519 = null;
var G__106520 = (0);
var G__106521 = (0);
seq__106441_106495 = G__106518;
chunk__106442_106496 = G__106519;
count__106443_106497 = G__106520;
i__106444_106498 = G__106521;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__106522){
var map__106523 = p__106522;
var map__106523__$1 = (((((!((map__106523 == null))))?(((((map__106523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106523):map__106523);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106523__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__106525){
var map__106526 = p__106525;
var map__106526__$1 = (((((!((map__106526 == null))))?(((((map__106526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106526.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106526):map__106526);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106526__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__106528){
var map__106529 = p__106528;
var map__106529__$1 = (((((!((map__106529 == null))))?(((((map__106529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106529):map__106529);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106529__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106529__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106529__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106529__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106529__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__106531_106555 = cljs.core.seq(protocols);
var chunk__106532_106556 = null;
var count__106533_106557 = (0);
var i__106534_106558 = (0);
while(true){
if((i__106534_106558 < count__106533_106557)){
var protocol_106559 = chunk__106532_106556.cljs$core$IIndexed$_nth$arity$2(null,i__106534_106558);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_106559)),"}");


var G__106560 = seq__106531_106555;
var G__106561 = chunk__106532_106556;
var G__106562 = count__106533_106557;
var G__106563 = (i__106534_106558 + (1));
seq__106531_106555 = G__106560;
chunk__106532_106556 = G__106561;
count__106533_106557 = G__106562;
i__106534_106558 = G__106563;
continue;
} else {
var temp__5735__auto___106564 = cljs.core.seq(seq__106531_106555);
if(temp__5735__auto___106564){
var seq__106531_106565__$1 = temp__5735__auto___106564;
if(cljs.core.chunked_seq_QMARK_(seq__106531_106565__$1)){
var c__4550__auto___106566 = cljs.core.chunk_first(seq__106531_106565__$1);
var G__106567 = cljs.core.chunk_rest(seq__106531_106565__$1);
var G__106568 = c__4550__auto___106566;
var G__106569 = cljs.core.count(c__4550__auto___106566);
var G__106570 = (0);
seq__106531_106555 = G__106567;
chunk__106532_106556 = G__106568;
count__106533_106557 = G__106569;
i__106534_106558 = G__106570;
continue;
} else {
var protocol_106571 = cljs.core.first(seq__106531_106565__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_106571)),"}");


var G__106572 = cljs.core.next(seq__106531_106565__$1);
var G__106573 = null;
var G__106574 = (0);
var G__106575 = (0);
seq__106531_106555 = G__106572;
chunk__106532_106556 = G__106573;
count__106533_106557 = G__106574;
i__106534_106558 = G__106575;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__106535_106576 = cljs.core.seq(fields__$1);
var chunk__106536_106577 = null;
var count__106537_106578 = (0);
var i__106538_106579 = (0);
while(true){
if((i__106538_106579 < count__106537_106578)){
var fld_106580 = chunk__106536_106577.cljs$core$IIndexed$_nth$arity$2(null,i__106538_106579);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_106580," = ",fld_106580,";");


var G__106581 = seq__106535_106576;
var G__106582 = chunk__106536_106577;
var G__106583 = count__106537_106578;
var G__106584 = (i__106538_106579 + (1));
seq__106535_106576 = G__106581;
chunk__106536_106577 = G__106582;
count__106537_106578 = G__106583;
i__106538_106579 = G__106584;
continue;
} else {
var temp__5735__auto___106585 = cljs.core.seq(seq__106535_106576);
if(temp__5735__auto___106585){
var seq__106535_106586__$1 = temp__5735__auto___106585;
if(cljs.core.chunked_seq_QMARK_(seq__106535_106586__$1)){
var c__4550__auto___106587 = cljs.core.chunk_first(seq__106535_106586__$1);
var G__106588 = cljs.core.chunk_rest(seq__106535_106586__$1);
var G__106589 = c__4550__auto___106587;
var G__106590 = cljs.core.count(c__4550__auto___106587);
var G__106591 = (0);
seq__106535_106576 = G__106588;
chunk__106536_106577 = G__106589;
count__106537_106578 = G__106590;
i__106538_106579 = G__106591;
continue;
} else {
var fld_106592 = cljs.core.first(seq__106535_106586__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_106592," = ",fld_106592,";");


var G__106593 = cljs.core.next(seq__106535_106586__$1);
var G__106594 = null;
var G__106595 = (0);
var G__106596 = (0);
seq__106535_106576 = G__106593;
chunk__106536_106577 = G__106594;
count__106537_106578 = G__106595;
i__106538_106579 = G__106596;
continue;
}
} else {
}
}
break;
}

var seq__106539_106597 = cljs.core.seq(pmasks);
var chunk__106540_106598 = null;
var count__106541_106599 = (0);
var i__106542_106600 = (0);
while(true){
if((i__106542_106600 < count__106541_106599)){
var vec__106549_106601 = chunk__106540_106598.cljs$core$IIndexed$_nth$arity$2(null,i__106542_106600);
var pno_106602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106549_106601,(0),null);
var pmask_106603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106549_106601,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_106602,"$ = ",pmask_106603,";");


var G__106604 = seq__106539_106597;
var G__106605 = chunk__106540_106598;
var G__106606 = count__106541_106599;
var G__106607 = (i__106542_106600 + (1));
seq__106539_106597 = G__106604;
chunk__106540_106598 = G__106605;
count__106541_106599 = G__106606;
i__106542_106600 = G__106607;
continue;
} else {
var temp__5735__auto___106608 = cljs.core.seq(seq__106539_106597);
if(temp__5735__auto___106608){
var seq__106539_106609__$1 = temp__5735__auto___106608;
if(cljs.core.chunked_seq_QMARK_(seq__106539_106609__$1)){
var c__4550__auto___106610 = cljs.core.chunk_first(seq__106539_106609__$1);
var G__106611 = cljs.core.chunk_rest(seq__106539_106609__$1);
var G__106612 = c__4550__auto___106610;
var G__106613 = cljs.core.count(c__4550__auto___106610);
var G__106614 = (0);
seq__106539_106597 = G__106611;
chunk__106540_106598 = G__106612;
count__106541_106599 = G__106613;
i__106542_106600 = G__106614;
continue;
} else {
var vec__106552_106615 = cljs.core.first(seq__106539_106609__$1);
var pno_106616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106552_106615,(0),null);
var pmask_106617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106552_106615,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_106616,"$ = ",pmask_106617,";");


var G__106618 = cljs.core.next(seq__106539_106609__$1);
var G__106619 = null;
var G__106620 = (0);
var G__106621 = (0);
seq__106539_106597 = G__106618;
chunk__106540_106598 = G__106619;
count__106541_106599 = G__106620;
i__106542_106600 = G__106621;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__106622){
var map__106623 = p__106622;
var map__106623__$1 = (((((!((map__106623 == null))))?(((((map__106623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106623):map__106623);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106623__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106623__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106623__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106623__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106623__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__106625_106649 = cljs.core.seq(protocols);
var chunk__106626_106650 = null;
var count__106627_106651 = (0);
var i__106628_106652 = (0);
while(true){
if((i__106628_106652 < count__106627_106651)){
var protocol_106653 = chunk__106626_106650.cljs$core$IIndexed$_nth$arity$2(null,i__106628_106652);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_106653)),"}");


var G__106654 = seq__106625_106649;
var G__106655 = chunk__106626_106650;
var G__106656 = count__106627_106651;
var G__106657 = (i__106628_106652 + (1));
seq__106625_106649 = G__106654;
chunk__106626_106650 = G__106655;
count__106627_106651 = G__106656;
i__106628_106652 = G__106657;
continue;
} else {
var temp__5735__auto___106658 = cljs.core.seq(seq__106625_106649);
if(temp__5735__auto___106658){
var seq__106625_106659__$1 = temp__5735__auto___106658;
if(cljs.core.chunked_seq_QMARK_(seq__106625_106659__$1)){
var c__4550__auto___106660 = cljs.core.chunk_first(seq__106625_106659__$1);
var G__106661 = cljs.core.chunk_rest(seq__106625_106659__$1);
var G__106662 = c__4550__auto___106660;
var G__106663 = cljs.core.count(c__4550__auto___106660);
var G__106664 = (0);
seq__106625_106649 = G__106661;
chunk__106626_106650 = G__106662;
count__106627_106651 = G__106663;
i__106628_106652 = G__106664;
continue;
} else {
var protocol_106665 = cljs.core.first(seq__106625_106659__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_106665)),"}");


var G__106666 = cljs.core.next(seq__106625_106659__$1);
var G__106667 = null;
var G__106668 = (0);
var G__106669 = (0);
seq__106625_106649 = G__106666;
chunk__106626_106650 = G__106667;
count__106627_106651 = G__106668;
i__106628_106652 = G__106669;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__106629_106670 = cljs.core.seq(fields__$1);
var chunk__106630_106671 = null;
var count__106631_106672 = (0);
var i__106632_106673 = (0);
while(true){
if((i__106632_106673 < count__106631_106672)){
var fld_106674 = chunk__106630_106671.cljs$core$IIndexed$_nth$arity$2(null,i__106632_106673);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_106674," = ",fld_106674,";");


var G__106675 = seq__106629_106670;
var G__106676 = chunk__106630_106671;
var G__106677 = count__106631_106672;
var G__106678 = (i__106632_106673 + (1));
seq__106629_106670 = G__106675;
chunk__106630_106671 = G__106676;
count__106631_106672 = G__106677;
i__106632_106673 = G__106678;
continue;
} else {
var temp__5735__auto___106679 = cljs.core.seq(seq__106629_106670);
if(temp__5735__auto___106679){
var seq__106629_106680__$1 = temp__5735__auto___106679;
if(cljs.core.chunked_seq_QMARK_(seq__106629_106680__$1)){
var c__4550__auto___106681 = cljs.core.chunk_first(seq__106629_106680__$1);
var G__106682 = cljs.core.chunk_rest(seq__106629_106680__$1);
var G__106683 = c__4550__auto___106681;
var G__106684 = cljs.core.count(c__4550__auto___106681);
var G__106685 = (0);
seq__106629_106670 = G__106682;
chunk__106630_106671 = G__106683;
count__106631_106672 = G__106684;
i__106632_106673 = G__106685;
continue;
} else {
var fld_106686 = cljs.core.first(seq__106629_106680__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_106686," = ",fld_106686,";");


var G__106687 = cljs.core.next(seq__106629_106680__$1);
var G__106688 = null;
var G__106689 = (0);
var G__106690 = (0);
seq__106629_106670 = G__106687;
chunk__106630_106671 = G__106688;
count__106631_106672 = G__106689;
i__106632_106673 = G__106690;
continue;
}
} else {
}
}
break;
}

var seq__106633_106691 = cljs.core.seq(pmasks);
var chunk__106634_106692 = null;
var count__106635_106693 = (0);
var i__106636_106694 = (0);
while(true){
if((i__106636_106694 < count__106635_106693)){
var vec__106643_106695 = chunk__106634_106692.cljs$core$IIndexed$_nth$arity$2(null,i__106636_106694);
var pno_106696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106643_106695,(0),null);
var pmask_106697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106643_106695,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_106696,"$ = ",pmask_106697,";");


var G__106698 = seq__106633_106691;
var G__106699 = chunk__106634_106692;
var G__106700 = count__106635_106693;
var G__106701 = (i__106636_106694 + (1));
seq__106633_106691 = G__106698;
chunk__106634_106692 = G__106699;
count__106635_106693 = G__106700;
i__106636_106694 = G__106701;
continue;
} else {
var temp__5735__auto___106702 = cljs.core.seq(seq__106633_106691);
if(temp__5735__auto___106702){
var seq__106633_106703__$1 = temp__5735__auto___106702;
if(cljs.core.chunked_seq_QMARK_(seq__106633_106703__$1)){
var c__4550__auto___106704 = cljs.core.chunk_first(seq__106633_106703__$1);
var G__106705 = cljs.core.chunk_rest(seq__106633_106703__$1);
var G__106706 = c__4550__auto___106704;
var G__106707 = cljs.core.count(c__4550__auto___106704);
var G__106708 = (0);
seq__106633_106691 = G__106705;
chunk__106634_106692 = G__106706;
count__106635_106693 = G__106707;
i__106636_106694 = G__106708;
continue;
} else {
var vec__106646_106709 = cljs.core.first(seq__106633_106703__$1);
var pno_106710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106646_106709,(0),null);
var pmask_106711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106646_106709,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_106710,"$ = ",pmask_106711,";");


var G__106712 = cljs.core.next(seq__106633_106703__$1);
var G__106713 = null;
var G__106714 = (0);
var G__106715 = (0);
seq__106633_106691 = G__106712;
chunk__106634_106692 = G__106713;
count__106635_106693 = G__106714;
i__106636_106694 = G__106715;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__106716){
var map__106717 = p__106716;
var map__106717__$1 = (((((!((map__106717 == null))))?(((((map__106717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106717):map__106717);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106717__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106717__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106717__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106717__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106717__$1,cljs.core.cst$kw$env);
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__106719){
var map__106720 = p__106719;
var map__106720__$1 = (((((!((map__106720 == null))))?(((((map__106720.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106720.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__106720):map__106720);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106720__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106720__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106720__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106720__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__106720__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4120__auto__ = code;
if(cljs.core.truth_(and__4120__auto__)){
var G__106722 = clojure.string.trim(code);
var G__106723 = "/*";
return goog.string.startsWith(G__106722,G__106723);
} else {
return and__4120__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__105467__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__105467__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__106728 = cljs.core.seq(table);
var chunk__106729 = null;
var count__106730 = (0);
var i__106731 = (0);
while(true){
if((i__106731 < count__106730)){
var vec__106738 = chunk__106729.cljs$core$IIndexed$_nth$arity$2(null,i__106731);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106738,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106738,(1),null);
var ns_106744 = cljs.core.namespace(sym);
var name_106745 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__106746 = seq__106728;
var G__106747 = chunk__106729;
var G__106748 = count__106730;
var G__106749 = (i__106731 + (1));
seq__106728 = G__106746;
chunk__106729 = G__106747;
count__106730 = G__106748;
i__106731 = G__106749;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__106728);
if(temp__5735__auto__){
var seq__106728__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__106728__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__106728__$1);
var G__106750 = cljs.core.chunk_rest(seq__106728__$1);
var G__106751 = c__4550__auto__;
var G__106752 = cljs.core.count(c__4550__auto__);
var G__106753 = (0);
seq__106728 = G__106750;
chunk__106729 = G__106751;
count__106730 = G__106752;
i__106731 = G__106753;
continue;
} else {
var vec__106741 = cljs.core.first(seq__106728__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106741,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106741,(1),null);
var ns_106754 = cljs.core.namespace(sym);
var name_106755 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__106756 = cljs.core.next(seq__106728__$1);
var G__106757 = null;
var G__106758 = (0);
var G__106759 = (0);
seq__106728 = G__106756;
chunk__106729 = G__106757;
count__106730 = G__106758;
i__106731 = G__106759;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__106761 = arguments.length;
switch (G__106761) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.core.cst$kw$cljs$analyzer_SLASH_externs.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_106766 = cljs.core.first(ks);
var vec__106762_106767 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_106766);
var top_106768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__106762_106767,(0),null);
var prefix_SINGLEQUOTE__106769 = vec__106762_106767;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_106766)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__106769) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_106768)) || (cljs.core.contains_QMARK_(known_externs,top_106768)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__106769)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_106768);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__106769)),";");
}
} else {
}

var m_106770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_106766);
if(cljs.core.empty_QMARK_(m_106770)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__106769,m_106770,top_level,known_externs);
}

var G__106771 = cljs.core.next(ks);
ks = G__106771;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;

