// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__124721 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__124721,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__124721,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__124721,(2),null);
if(cljs.core.truth_((function (){var and__4120__auto__ = network;
if(cljs.core.truth_(and__4120__auto__)){
return maybe_alias;
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_124815){
var state_val_124816 = (state_124815[(1)]);
if((state_val_124816 === (7))){
var state_124815__$1 = state_124815;
var statearr_124817_124856 = state_124815__$1;
(statearr_124817_124856[(2)] = false);

(statearr_124817_124856[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (20))){
var inst_124779 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
var statearr_124818_124857 = state_124815__$1;
(statearr_124818_124857[(2)] = inst_124779);

(statearr_124818_124857[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (1))){
var state_124815__$1 = state_124815;
var statearr_124819_124858 = state_124815__$1;
(statearr_124819_124858[(2)] = null);

(statearr_124819_124858[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (24))){
var inst_124792 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_124793 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_124794 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_124795 = cljs.core.PersistentHashMap.fromArrays(inst_124793,inst_124794);
var inst_124796 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_124792,inst_124795);
var inst_124797 = (function(){throw inst_124796})();
var state_124815__$1 = state_124815;
var statearr_124820_124859 = state_124815__$1;
(statearr_124820_124859[(2)] = inst_124797);

(statearr_124820_124859[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_124815,(3),Error,null,(2));
var inst_124730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124731 = [pred_id];
var inst_124732 = (new cljs.core.PersistentVector(null,1,(5),inst_124730,inst_124731,null));
var inst_124733 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_124732);
var state_124815__$1 = state_124815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124815__$1,(5),inst_124733);
} else {
if((state_val_124816 === (15))){
var inst_124766 = (state_124815[(7)]);
var inst_124771 = inst_124766.cljs$lang$protocol_mask$partition0$;
var inst_124772 = (inst_124771 & (64));
var inst_124773 = inst_124766.cljs$core$ISeq$;
var inst_124774 = (cljs.core.PROTOCOL_SENTINEL === inst_124773);
var inst_124775 = ((inst_124772) || (inst_124774));
var state_124815__$1 = state_124815;
if(cljs.core.truth_(inst_124775)){
var statearr_124821_124860 = state_124815__$1;
(statearr_124821_124860[(1)] = (18));

} else {
var statearr_124822_124861 = state_124815__$1;
(statearr_124822_124861[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (21))){
var inst_124766 = (state_124815[(7)]);
var inst_124784 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_124766);
var state_124815__$1 = state_124815;
var statearr_124823_124862 = state_124815__$1;
(statearr_124823_124862[(2)] = inst_124784);

(statearr_124823_124862[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (13))){
var inst_124737 = (state_124815[(8)]);
var state_124815__$1 = state_124815;
var statearr_124824_124863 = state_124815__$1;
(statearr_124824_124863[(2)] = inst_124737);

(statearr_124824_124863[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (22))){
var inst_124766 = (state_124815[(7)]);
var state_124815__$1 = state_124815;
var statearr_124825_124864 = state_124815__$1;
(statearr_124825_124864[(2)] = inst_124766);

(statearr_124825_124864[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (6))){
var inst_124737 = (state_124815[(8)]);
var inst_124742 = inst_124737.cljs$lang$protocol_mask$partition0$;
var inst_124743 = (inst_124742 & (64));
var inst_124744 = inst_124737.cljs$core$ISeq$;
var inst_124745 = (cljs.core.PROTOCOL_SENTINEL === inst_124744);
var inst_124746 = ((inst_124743) || (inst_124745));
var state_124815__$1 = state_124815;
if(cljs.core.truth_(inst_124746)){
var statearr_124826_124865 = state_124815__$1;
(statearr_124826_124865[(1)] = (9));

} else {
var statearr_124827_124866 = state_124815__$1;
(statearr_124827_124866[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (25))){
var state_124815__$1 = state_124815;
var statearr_124828_124867 = state_124815__$1;
(statearr_124828_124867[(2)] = null);

(statearr_124828_124867[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (17))){
var inst_124782 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
if(cljs.core.truth_(inst_124782)){
var statearr_124829_124868 = state_124815__$1;
(statearr_124829_124868[(1)] = (21));

} else {
var statearr_124830_124869 = state_124815__$1;
(statearr_124830_124869[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (3))){
var inst_124724 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
var statearr_124831_124870 = state_124815__$1;
(statearr_124831_124870[(2)] = inst_124724);


cljs.core.async.impl.ioc_helpers.process_exception(state_124815__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (12))){
var inst_124737 = (state_124815[(8)]);
var inst_124755 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_124737);
var state_124815__$1 = state_124815;
var statearr_124832_124871 = state_124815__$1;
(statearr_124832_124871[(2)] = inst_124755);

(statearr_124832_124871[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (2))){
var inst_124813 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_124815__$1,inst_124813);
} else {
if((state_val_124816 === (23))){
var inst_124762 = (state_124815[(9)]);
var inst_124787 = (state_124815[(2)]);
var inst_124788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124787,cljs.core.cst$kw$novelty_DASH_min);
var inst_124789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124787,cljs.core.cst$kw$novelty_DASH_max);
var inst_124790 = (inst_124762 > inst_124789);
var state_124815__$1 = (function (){var statearr_124833 = state_124815;
(statearr_124833[(10)] = inst_124788);

return statearr_124833;
})();
if(cljs.core.truth_(inst_124790)){
var statearr_124834_124872 = state_124815__$1;
(statearr_124834_124872[(1)] = (24));

} else {
var statearr_124835_124873 = state_124815__$1;
(statearr_124835_124873[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (19))){
var state_124815__$1 = state_124815;
var statearr_124836_124874 = state_124815__$1;
(statearr_124836_124874[(2)] = false);

(statearr_124836_124874[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (11))){
var inst_124750 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
var statearr_124837_124875 = state_124815__$1;
(statearr_124837_124875[(2)] = inst_124750);

(statearr_124837_124875[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (9))){
var state_124815__$1 = state_124815;
var statearr_124838_124876 = state_124815__$1;
(statearr_124838_124876[(2)] = true);

(statearr_124838_124876[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (5))){
var inst_124737 = (state_124815[(8)]);
var inst_124735 = (state_124815[(2)]);
var inst_124736 = fluree.db.util.async.throw_err(inst_124735);
var inst_124737__$1 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_124739 = (inst_124737__$1 == null);
var inst_124740 = cljs.core.not(inst_124739);
var state_124815__$1 = (function (){var statearr_124839 = state_124815;
(statearr_124839[(8)] = inst_124737__$1);

(statearr_124839[(11)] = inst_124736);

return statearr_124839;
})();
if(inst_124740){
var statearr_124840_124877 = state_124815__$1;
(statearr_124840_124877[(1)] = (6));

} else {
var statearr_124841_124878 = state_124815__$1;
(statearr_124841_124878[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (14))){
var inst_124766 = (state_124815[(7)]);
var inst_124736 = (state_124815[(11)]);
var inst_124758 = (state_124815[(2)]);
var inst_124759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124758,cljs.core.cst$kw$post);
var inst_124760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124758,cljs.core.cst$kw$size);
var inst_124761 = fluree.db.flake.size_bytes(inst_124736);
var inst_124762 = (inst_124760 + inst_124761);
var inst_124763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124764 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_124765 = (new cljs.core.PersistentVector(null,2,(5),inst_124763,inst_124764,null));
var inst_124766__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_124765);
var inst_124768 = (inst_124766__$1 == null);
var inst_124769 = cljs.core.not(inst_124768);
var state_124815__$1 = (function (){var statearr_124842 = state_124815;
(statearr_124842[(7)] = inst_124766__$1);

(statearr_124842[(12)] = inst_124759);

(statearr_124842[(9)] = inst_124762);

return statearr_124842;
})();
if(inst_124769){
var statearr_124843_124879 = state_124815__$1;
(statearr_124843_124879[(1)] = (15));

} else {
var statearr_124844_124880 = state_124815__$1;
(statearr_124844_124880[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (26))){
var inst_124759 = (state_124815[(12)]);
var inst_124762 = (state_124815[(9)]);
var inst_124736 = (state_124815[(11)]);
var inst_124800 = (state_124815[(2)]);
var inst_124801 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_124759,inst_124736);
var inst_124802 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_124803 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_124802,cljs.core.empty);
var inst_124804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124805 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_124806 = (new cljs.core.PersistentVector(null,2,(5),inst_124804,inst_124805,null));
var inst_124807 = cljs.core.assoc_in(db,inst_124806,inst_124801);
var inst_124808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124809 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_124810 = (new cljs.core.PersistentVector(null,2,(5),inst_124808,inst_124809,null));
var inst_124811 = cljs.core.assoc_in(inst_124807,inst_124810,inst_124762);
var state_124815__$1 = (function (){var statearr_124845 = state_124815;
(statearr_124845[(13)] = inst_124803);

(statearr_124845[(14)] = inst_124800);

return statearr_124845;
})();
var statearr_124846_124881 = state_124815__$1;
(statearr_124846_124881[(2)] = inst_124811);


cljs.core.async.impl.ioc_helpers.process_exception(state_124815__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (16))){
var state_124815__$1 = state_124815;
var statearr_124847_124882 = state_124815__$1;
(statearr_124847_124882[(2)] = false);

(statearr_124847_124882[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (10))){
var state_124815__$1 = state_124815;
var statearr_124848_124883 = state_124815__$1;
(statearr_124848_124883[(2)] = false);

(statearr_124848_124883[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (18))){
var state_124815__$1 = state_124815;
var statearr_124849_124884 = state_124815__$1;
(statearr_124849_124884[(2)] = true);

(statearr_124849_124884[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124816 === (8))){
var inst_124753 = (state_124815[(2)]);
var state_124815__$1 = state_124815;
if(cljs.core.truth_(inst_124753)){
var statearr_124850_124885 = state_124815__$1;
(statearr_124850_124885[(1)] = (12));

} else {
var statearr_124851_124886 = state_124815__$1;
(statearr_124851_124886[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____0 = (function (){
var statearr_124852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_124852[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__);

(statearr_124852[(1)] = (1));

return statearr_124852;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____1 = (function (state_124815){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_124815);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e124853){if((e124853 instanceof Object)){
var ex__109974__auto__ = e124853;
var statearr_124854_124887 = state_124815;
(statearr_124854_124887[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_124815);

return cljs.core.cst$kw$recur;
} else {
throw e124853;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__124888 = state_124815;
state_124815 = G__124888;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__ = function(state_124815){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____1.call(this,state_124815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_124855 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_124855[(6)] = c__110077__auto__);

return statearr_124855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_125083){
var state_val_125084 = (state_125083[(1)]);
if((state_val_125084 === (7))){
var inst_124922 = (state_125083[(7)]);
var inst_124914 = (state_125083[(8)]);
var inst_124918 = (state_125083[(9)]);
var inst_124897 = (state_125083[(10)]);
var inst_124928 = (state_125083[(11)]);
var inst_124912 = (state_125083[(12)]);
var inst_124912__$1 = (state_125083[(2)]);
var inst_124913 = (function (){var t = inst_124897;
var _ = inst_124912__$1;
return ((function (t,_,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,state_val_125084,c__110077__auto__){
return (function (p1__124889_SHARP_){
return cljs.core.not((function (){var G__125085 = p1__124889_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__125085) : fluree.db.graphdb.exclude_predicates.call(null,G__125085));
})());
});
;})(t,_,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,state_val_125084,c__110077__auto__))
})();
var inst_124914__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_124913,flakes);
var inst_124915 = cljs.core.PersistentHashSet.EMPTY;
var inst_124916 = (function (){var t = inst_124897;
var _ = inst_124912__$1;
var add_flakes = inst_124914__$1;
return ((function (t,_,add_flakes,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,state_val_125084,c__110077__auto__){
return (function (p1__124890_SHARP_){
return p1__124890_SHARP_.p;
});
;})(t,_,add_flakes,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,state_val_125084,c__110077__auto__))
})();
var inst_124917 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_124916,inst_124914__$1);
var inst_124918__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_124915,inst_124917);
var inst_124919 = cljs.core.PersistentHashMap.EMPTY;
var inst_124920 = (function (){var t = inst_124897;
var _ = inst_124912__$1;
var add_flakes = inst_124914__$1;
var add_preds = inst_124918__$1;
return ((function (t,_,add_flakes,add_preds,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,inst_124916,inst_124917,inst_124918__$1,inst_124919,state_val_125084,c__110077__auto__){
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
;})(t,_,add_flakes,add_preds,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,inst_124916,inst_124917,inst_124918__$1,inst_124919,state_val_125084,c__110077__auto__))
})();
var inst_124921 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_124920,inst_124918__$1);
var inst_124922__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_124919,inst_124921);
var inst_124923 = cljs.core.PersistentHashMap.EMPTY;
var inst_124924 = (function (){var t = inst_124897;
var _ = inst_124912__$1;
var add_flakes = inst_124914__$1;
var add_preds = inst_124918__$1;
var idx_QMARK__map = inst_124922__$1;
return ((function (t,_,add_flakes,add_preds,idx_QMARK__map,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,inst_124916,inst_124917,inst_124918__$1,inst_124919,inst_124920,inst_124921,inst_124922__$1,inst_124923,state_val_125084,c__110077__auto__){
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
;})(t,_,add_flakes,add_preds,idx_QMARK__map,inst_124922,inst_124914,inst_124918,inst_124897,inst_124928,inst_124912,inst_124912__$1,inst_124913,inst_124914__$1,inst_124915,inst_124916,inst_124917,inst_124918__$1,inst_124919,inst_124920,inst_124921,inst_124922__$1,inst_124923,state_val_125084,c__110077__auto__))
})();
var inst_124925 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_124924,inst_124918__$1);
var inst_124926 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_124923,inst_124925);
var inst_124927 = fluree.db.flake.size_bytes(inst_124914__$1);
var inst_124928__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_124914__$1);
var inst_124929 = fluree.db.util.schema.setting_change_QMARK_(inst_124914__$1);
var inst_124930 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_124931 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124930,(0));
var state_125083__$1 = (function (){var statearr_125086 = state_125083;
(statearr_125086[(7)] = inst_124922__$1);

(statearr_125086[(8)] = inst_124914__$1);

(statearr_125086[(13)] = inst_124927);

(statearr_125086[(14)] = inst_124931);

(statearr_125086[(9)] = inst_124918__$1);

(statearr_125086[(15)] = inst_124926);

(statearr_125086[(11)] = inst_124928__$1);

(statearr_125086[(16)] = inst_124929);

(statearr_125086[(12)] = inst_124912__$1);

return statearr_125086;
})();
if(cljs.core.truth_(inst_124928__$1)){
var statearr_125087_125145 = state_125083__$1;
(statearr_125087_125145[(1)] = (8));

} else {
var statearr_125088_125146 = state_125083__$1;
(statearr_125088_125146[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (20))){
var inst_124922 = (state_125083[(7)]);
var inst_124977 = (state_125083[(17)]);
var inst_124937 = (state_125083[(18)]);
var inst_124914 = (state_125083[(8)]);
var inst_124927 = (state_125083[(13)]);
var inst_124987 = (state_125083[(19)]);
var inst_125009 = (state_125083[(20)]);
var inst_124931 = (state_125083[(14)]);
var inst_124918 = (state_125083[(9)]);
var inst_125005 = (state_125083[(21)]);
var inst_124897 = (state_125083[(10)]);
var inst_125017 = (state_125083[(22)]);
var inst_124986 = (state_125083[(23)]);
var inst_125007 = (state_125083[(24)]);
var inst_125016 = (state_125083[(25)]);
var inst_124926 = (state_125083[(15)]);
var inst_125006 = (state_125083[(26)]);
var inst_125010 = (state_125083[(27)]);
var inst_124928 = (state_125083[(11)]);
var inst_125008 = (state_125083[(28)]);
var inst_124929 = (state_125083[(16)]);
var inst_124912 = (state_125083[(12)]);
var inst_125055 = inst_125016.s;
var inst_125056 = fluree.db.flake.sid__GT_cid(inst_125055);
var inst_125057 = (function (){var flakes_bytes = inst_124927;
var t = inst_124897;
var first__125014 = inst_125016;
var seq__125013 = inst_125017;
var spot = inst_125006;
var add_flakes = inst_124914;
var first__124984 = inst_124986;
var root_setting_change_QMARK_ = inst_124929;
var ref_QMARK__map = inst_124926;
var r = inst_125017;
var vec__125012 = inst_125005;
var psot = inst_125007;
var add_pred_to_idx_QMARK_ = inst_124937;
var _ = inst_124912;
var cid = inst_125056;
var ecount = inst_125010;
var seq__124983 = inst_124987;
var pred_ecount = inst_124931;
var G__124981 = inst_125005;
var db_STAR_ = inst_124977;
var schema_change_QMARK_ = inst_124928;
var add_preds = inst_124918;
var opst = inst_125009;
var vec__124982 = inst_124914;
var idx_QMARK__map = inst_124922;
var post = inst_125008;
var f = inst_125016;
return ((function (flakes_bytes,t,first__125014,seq__125013,spot,add_flakes,first__124984,root_setting_change_QMARK_,ref_QMARK__map,r,vec__125012,psot,add_pred_to_idx_QMARK_,_,cid,ecount,seq__124983,pred_ecount,G__124981,db_STAR_,schema_change_QMARK_,add_preds,opst,vec__124982,idx_QMARK__map,post,f,inst_124922,inst_124977,inst_124937,inst_124914,inst_124927,inst_124987,inst_125009,inst_124931,inst_124918,inst_125005,inst_124897,inst_125017,inst_124986,inst_125007,inst_125016,inst_124926,inst_125006,inst_125010,inst_124928,inst_125008,inst_124929,inst_124912,inst_125055,inst_125056,state_val_125084,c__110077__auto__){
return (function (p1__124891_SHARP_){
if(cljs.core.truth_(p1__124891_SHARP_)){
var x__4219__auto__ = p1__124891_SHARP_;
var y__4220__auto__ = f.s;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
} else {
return f.s;
}
});
;})(flakes_bytes,t,first__125014,seq__125013,spot,add_flakes,first__124984,root_setting_change_QMARK_,ref_QMARK__map,r,vec__125012,psot,add_pred_to_idx_QMARK_,_,cid,ecount,seq__124983,pred_ecount,G__124981,db_STAR_,schema_change_QMARK_,add_preds,opst,vec__124982,idx_QMARK__map,post,f,inst_124922,inst_124977,inst_124937,inst_124914,inst_124927,inst_124987,inst_125009,inst_124931,inst_124918,inst_125005,inst_124897,inst_125017,inst_124986,inst_125007,inst_125016,inst_124926,inst_125006,inst_125010,inst_124928,inst_125008,inst_124929,inst_124912,inst_125055,inst_125056,state_val_125084,c__110077__auto__))
})();
var inst_125058 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_125010,inst_125056,inst_125057);
var inst_125059 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_125006,inst_125016);
var inst_125060 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_125007,inst_125016);
var inst_125061 = inst_125016.p;
var inst_125062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124922,inst_125061);
var state_125083__$1 = (function (){var statearr_125089 = state_125083;
(statearr_125089[(29)] = inst_125059);

(statearr_125089[(30)] = inst_125060);

(statearr_125089[(31)] = inst_125058);

return statearr_125089;
})();
if(cljs.core.truth_(inst_125062)){
var statearr_125090_125147 = state_125083__$1;
(statearr_125090_125147[(1)] = (33));

} else {
var statearr_125091_125148 = state_125083__$1;
(statearr_125091_125148[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (27))){
var inst_124929 = (state_125083[(16)]);
var inst_125043 = (state_125083[(2)]);
var state_125083__$1 = (function (){var statearr_125092 = state_125083;
(statearr_125092[(32)] = inst_125043);

return statearr_125092;
})();
if(cljs.core.truth_(inst_124929)){
var statearr_125093_125149 = state_125083__$1;
(statearr_125093_125149[(1)] = (29));

} else {
var statearr_125094_125150 = state_125083__$1;
(statearr_125094_125150[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (1))){
var state_125083__$1 = state_125083;
var statearr_125095_125151 = state_125083__$1;
(statearr_125095_125151[(2)] = null);

(statearr_125095_125151[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (24))){
var inst_125034 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
if(cljs.core.truth_(inst_125034)){
var statearr_125096_125152 = state_125083__$1;
(statearr_125096_125152[(1)] = (25));

} else {
var statearr_125097_125153 = state_125083__$1;
(statearr_125097_125153[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (4))){
var inst_124897 = (state_125083[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125083,(3),Error,null,(2));
var inst_124896 = cljs.core.first(flakes);
var inst_124897__$1 = inst_124896.t;
var inst_124898 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_124899 = (inst_124898 - (1));
var inst_124900 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_124897__$1,inst_124899);
var state_125083__$1 = (function (){var statearr_125098 = state_125083;
(statearr_125098[(10)] = inst_124897__$1);

return statearr_125098;
})();
if(inst_124900){
var statearr_125099_125154 = state_125083__$1;
(statearr_125099_125154[(1)] = (5));

} else {
var statearr_125100_125155 = state_125083__$1;
(statearr_125100_125155[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (15))){
var inst_124965 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
var statearr_125101_125156 = state_125083__$1;
(statearr_125101_125156[(2)] = inst_124965);

(statearr_125101_125156[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (21))){
var inst_125077 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
var statearr_125102_125157 = state_125083__$1;
(statearr_125102_125157[(2)] = inst_125077);

(statearr_125102_125157[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (31))){
var inst_125053 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
var statearr_125103_125158 = state_125083__$1;
(statearr_125103_125158[(2)] = inst_125053);

(statearr_125103_125158[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (32))){
var inst_125043 = (state_125083[(32)]);
var inst_125048 = (state_125083[(2)]);
var inst_125049 = fluree.db.util.async.throw_err(inst_125048);
var inst_125050 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_125043,cljs.core.cst$kw$settings,inst_125049);
var state_125083__$1 = state_125083;
var statearr_125104_125159 = state_125083__$1;
(statearr_125104_125159[(2)] = inst_125050);

(statearr_125104_125159[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (33))){
var inst_125016 = (state_125083[(25)]);
var inst_125008 = (state_125083[(28)]);
var inst_125064 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_125008,inst_125016);
var state_125083__$1 = state_125083;
var statearr_125105_125160 = state_125083__$1;
(statearr_125105_125160[(2)] = inst_125064);

(statearr_125105_125160[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (13))){
var inst_124949 = (state_125083[(33)]);
var inst_124955 = (state_125083[(34)]);
var inst_124958 = fluree.db.graphdb.add_predicate_to_idx(inst_124949,inst_124955);
var state_125083__$1 = state_125083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125083__$1,(16),inst_124958);
} else {
if((state_val_125084 === (22))){
var inst_124928 = (state_125083[(11)]);
var state_125083__$1 = state_125083;
var statearr_125106_125161 = state_125083__$1;
(statearr_125106_125161[(2)] = inst_124928);

(statearr_125106_125161[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (36))){
var inst_125009 = (state_125083[(20)]);
var inst_125016 = (state_125083[(25)]);
var inst_125071 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_125009,inst_125016);
var state_125083__$1 = state_125083;
var statearr_125107_125162 = state_125083__$1;
(statearr_125107_125162[(2)] = inst_125071);

(statearr_125107_125162[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (29))){
var inst_125043 = (state_125083[(32)]);
var inst_125046 = fluree.db.query.schema.setting_map(inst_125043);
var state_125083__$1 = state_125083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125083__$1,(32),inst_125046);
} else {
if((state_val_125084 === (6))){
var state_125083__$1 = state_125083;
var statearr_125108_125163 = state_125083__$1;
(statearr_125108_125163[(2)] = null);

(statearr_125108_125163[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (28))){
var inst_125028 = (state_125083[(35)]);
var inst_125038 = (state_125083[(2)]);
var inst_125039 = fluree.db.util.async.throw_err(inst_125038);
var inst_125040 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_125028,cljs.core.cst$kw$schema,inst_125039);
var state_125083__$1 = state_125083;
var statearr_125109_125164 = state_125083__$1;
(statearr_125109_125164[(2)] = inst_125040);

(statearr_125109_125164[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (25))){
var inst_125028 = (state_125083[(35)]);
var inst_125036 = fluree.db.query.schema.schema_map(inst_125028);
var state_125083__$1 = state_125083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125083__$1,(28),inst_125036);
} else {
if((state_val_125084 === (34))){
var inst_125008 = (state_125083[(28)]);
var state_125083__$1 = state_125083;
var statearr_125110_125165 = state_125083__$1;
(statearr_125110_125165[(2)] = inst_125008);

(statearr_125110_125165[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (17))){
var inst_125005 = (state_125083[(21)]);
var inst_125016 = (state_125083[(25)]);
var inst_125015 = cljs.core.seq(inst_125005);
var inst_125016__$1 = cljs.core.first(inst_125015);
var inst_125017 = cljs.core.next(inst_125015);
var inst_125018 = cljs.core.not(inst_125016__$1);
var state_125083__$1 = (function (){var statearr_125111 = state_125083;
(statearr_125111[(22)] = inst_125017);

(statearr_125111[(25)] = inst_125016__$1);

return statearr_125111;
})();
if(inst_125018){
var statearr_125112_125166 = state_125083__$1;
(statearr_125112_125166[(1)] = (19));

} else {
var statearr_125113_125167 = state_125083__$1;
(statearr_125113_125167[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (3))){
var inst_124892 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
var statearr_125114_125168 = state_125083__$1;
(statearr_125114_125168[(2)] = inst_124892);


cljs.core.async.impl.ioc_helpers.process_exception(state_125083__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (12))){
var inst_124977 = (state_125083[(17)]);
var inst_124914 = (state_125083[(8)]);
var inst_124927 = (state_125083[(13)]);
var inst_124897 = (state_125083[(10)]);
var inst_124967 = (state_125083[(2)]);
var inst_124968 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_124967,cljs.core.cst$kw$t,inst_124897);
var inst_124969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124970 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_124971 = (new cljs.core.PersistentVector(null,2,(5),inst_124969,inst_124970,null));
var inst_124972 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_124968,inst_124971,cljs.core._PLUS_,inst_124927);
var inst_124973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124974 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_124975 = (new cljs.core.PersistentVector(null,2,(5),inst_124973,inst_124974,null));
var inst_124976 = cljs.core.count(inst_124914);
var inst_124977__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_124972,inst_124975,cljs.core._PLUS_,inst_124976);
var inst_124985 = cljs.core.seq(inst_124914);
var inst_124986 = cljs.core.first(inst_124985);
var inst_124987 = cljs.core.next(inst_124985);
var inst_124988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124989 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_124990 = (new cljs.core.PersistentVector(null,2,(5),inst_124988,inst_124989,null));
var inst_124991 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_124977__$1,inst_124990);
var inst_124992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124993 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_124994 = (new cljs.core.PersistentVector(null,2,(5),inst_124992,inst_124993,null));
var inst_124995 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_124977__$1,inst_124994);
var inst_124996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124997 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_124998 = (new cljs.core.PersistentVector(null,2,(5),inst_124996,inst_124997,null));
var inst_124999 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_124977__$1,inst_124998);
var inst_125000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125001 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_125002 = (new cljs.core.PersistentVector(null,2,(5),inst_125000,inst_125001,null));
var inst_125003 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_124977__$1,inst_125002);
var inst_125004 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_125005 = inst_124914;
var inst_125006 = inst_124991;
var inst_125007 = inst_124995;
var inst_125008 = inst_124999;
var inst_125009 = inst_125003;
var inst_125010 = inst_125004;
var state_125083__$1 = (function (){var statearr_125115 = state_125083;
(statearr_125115[(17)] = inst_124977__$1);

(statearr_125115[(19)] = inst_124987);

(statearr_125115[(20)] = inst_125009);

(statearr_125115[(21)] = inst_125005);

(statearr_125115[(23)] = inst_124986);

(statearr_125115[(24)] = inst_125007);

(statearr_125115[(26)] = inst_125006);

(statearr_125115[(27)] = inst_125010);

(statearr_125115[(28)] = inst_125008);

return statearr_125115;
})();
var statearr_125116_125169 = state_125083__$1;
(statearr_125116_125169[(2)] = null);

(statearr_125116_125169[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (2))){
var inst_125081 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125083__$1,inst_125081);
} else {
if((state_val_125084 === (23))){
var inst_125028 = (state_125083[(35)]);
var inst_125031 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_125028);
var inst_125032 = (inst_125031 == null);
var state_125083__$1 = state_125083;
var statearr_125117_125170 = state_125083__$1;
(statearr_125117_125170[(2)] = inst_125032);

(statearr_125117_125170[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (35))){
var inst_125016 = (state_125083[(25)]);
var inst_124926 = (state_125083[(15)]);
var inst_125067 = (state_125083[(2)]);
var inst_125068 = inst_125016.p;
var inst_125069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124926,inst_125068);
var state_125083__$1 = (function (){var statearr_125118 = state_125083;
(statearr_125118[(36)] = inst_125067);

return statearr_125118;
})();
if(cljs.core.truth_(inst_125069)){
var statearr_125119_125171 = state_125083__$1;
(statearr_125119_125171[(1)] = (36));

} else {
var statearr_125120_125172 = state_125083__$1;
(statearr_125120_125172[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (19))){
var inst_124977 = (state_125083[(17)]);
var inst_124927 = (state_125083[(13)]);
var inst_125009 = (state_125083[(20)]);
var inst_125007 = (state_125083[(24)]);
var inst_125006 = (state_125083[(26)]);
var inst_125010 = (state_125083[(27)]);
var inst_124928 = (state_125083[(11)]);
var inst_125008 = (state_125083[(28)]);
var inst_125020 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_125021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125022 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_125023 = (new cljs.core.PersistentVector(null,2,(5),inst_125021,inst_125022,null));
var inst_125024 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_124977,inst_125023);
var inst_125025 = (inst_124927 + inst_125024);
var inst_125026 = [inst_125006,inst_125007,inst_125008,inst_125009,inst_125025];
var inst_125027 = cljs.core.PersistentHashMap.fromArrays(inst_125020,inst_125026);
var inst_125028 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_124977,cljs.core.cst$kw$ecount,inst_125010,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_125027], 0));
var state_125083__$1 = (function (){var statearr_125121 = state_125083;
(statearr_125121[(35)] = inst_125028);

return statearr_125121;
})();
if(cljs.core.truth_(inst_124928)){
var statearr_125122_125173 = state_125083__$1;
(statearr_125122_125173[(1)] = (22));

} else {
var statearr_125123_125174 = state_125083__$1;
(statearr_125123_125174[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (11))){
var inst_124955 = (state_125083[(34)]);
var inst_124948 = (state_125083[(37)]);
var inst_124954 = cljs.core.seq(inst_124948);
var inst_124955__$1 = cljs.core.first(inst_124954);
var inst_124956 = cljs.core.next(inst_124954);
var state_125083__$1 = (function (){var statearr_125124 = state_125083;
(statearr_125124[(38)] = inst_124956);

(statearr_125124[(34)] = inst_124955__$1);

return statearr_125124;
})();
if(cljs.core.truth_(inst_124955__$1)){
var statearr_125125_125175 = state_125083__$1;
(statearr_125125_125175[(1)] = (13));

} else {
var statearr_125126_125176 = state_125083__$1;
(statearr_125126_125176[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (9))){
var inst_124935 = cljs.core.PersistentVector.EMPTY;
var state_125083__$1 = state_125083;
var statearr_125127_125177 = state_125083__$1;
(statearr_125127_125177[(2)] = inst_124935);

(statearr_125127_125177[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (5))){
var inst_124897 = (state_125083[(10)]);
var inst_124902 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_124903 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_124904 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124902)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124903)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_124897),"."].join('');
var inst_124905 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_124906 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_124907 = cljs.core.PersistentHashMap.fromArrays(inst_124905,inst_124906);
var inst_124908 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_124904,inst_124907);
var inst_124909 = (function(){throw inst_124908})();
var state_125083__$1 = state_125083;
var statearr_125128_125178 = state_125083__$1;
(statearr_125128_125178[(2)] = inst_124909);

(statearr_125128_125178[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (14))){
var inst_124949 = (state_125083[(33)]);
var state_125083__$1 = state_125083;
var statearr_125129_125179 = state_125083__$1;
(statearr_125129_125179[(2)] = inst_124949);

(statearr_125129_125179[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (26))){
var inst_125028 = (state_125083[(35)]);
var state_125083__$1 = state_125083;
var statearr_125130_125180 = state_125083__$1;
(statearr_125130_125180[(2)] = inst_125028);

(statearr_125130_125180[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (16))){
var inst_124956 = (state_125083[(38)]);
var inst_124960 = (state_125083[(2)]);
var inst_124961 = fluree.db.util.async.throw_err(inst_124960);
var inst_124948 = inst_124956;
var inst_124949 = inst_124961;
var state_125083__$1 = (function (){var statearr_125131 = state_125083;
(statearr_125131[(33)] = inst_124949);

(statearr_125131[(37)] = inst_124948);

return statearr_125131;
})();
var statearr_125132_125181 = state_125083__$1;
(statearr_125132_125181[(2)] = null);

(statearr_125132_125181[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (38))){
var inst_125067 = (state_125083[(36)]);
var inst_125017 = (state_125083[(22)]);
var inst_125059 = (state_125083[(29)]);
var inst_125060 = (state_125083[(30)]);
var inst_125058 = (state_125083[(31)]);
var inst_125074 = (state_125083[(2)]);
var inst_125005 = inst_125017;
var inst_125006 = inst_125059;
var inst_125007 = inst_125060;
var inst_125008 = inst_125067;
var inst_125009 = inst_125074;
var inst_125010 = inst_125058;
var state_125083__$1 = (function (){var statearr_125133 = state_125083;
(statearr_125133[(20)] = inst_125009);

(statearr_125133[(21)] = inst_125005);

(statearr_125133[(24)] = inst_125007);

(statearr_125133[(26)] = inst_125006);

(statearr_125133[(27)] = inst_125010);

(statearr_125133[(28)] = inst_125008);

return statearr_125133;
})();
var statearr_125134_125182 = state_125083__$1;
(statearr_125134_125182[(2)] = null);

(statearr_125134_125182[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (30))){
var inst_125043 = (state_125083[(32)]);
var state_125083__$1 = state_125083;
var statearr_125135_125183 = state_125083__$1;
(statearr_125135_125183[(2)] = inst_125043);

(statearr_125135_125183[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (10))){
var inst_124937 = (state_125083[(18)]);
var inst_124937__$1 = (state_125083[(2)]);
var inst_124945 = cljs.core.seq(inst_124937__$1);
var inst_124946 = cljs.core.first(inst_124945);
var inst_124947 = cljs.core.next(inst_124945);
var inst_124948 = inst_124937__$1;
var inst_124949 = db;
var state_125083__$1 = (function (){var statearr_125136 = state_125083;
(statearr_125136[(33)] = inst_124949);

(statearr_125136[(18)] = inst_124937__$1);

(statearr_125136[(39)] = inst_124946);

(statearr_125136[(40)] = inst_124947);

(statearr_125136[(37)] = inst_124948);

return statearr_125136;
})();
var statearr_125137_125184 = state_125083__$1;
(statearr_125137_125184[(2)] = null);

(statearr_125137_125184[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (18))){
var inst_125079 = (state_125083[(2)]);
var state_125083__$1 = state_125083;
var statearr_125138_125185 = state_125083__$1;
(statearr_125138_125185[(2)] = inst_125079);


cljs.core.async.impl.ioc_helpers.process_exception(state_125083__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (37))){
var inst_125009 = (state_125083[(20)]);
var state_125083__$1 = state_125083;
var statearr_125139_125186 = state_125083__$1;
(statearr_125139_125186[(2)] = inst_125009);

(statearr_125139_125186[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125084 === (8))){
var inst_124914 = (state_125083[(8)]);
var inst_124931 = (state_125083[(14)]);
var inst_124933 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_124914,inst_124931);
var state_125083__$1 = state_125083;
var statearr_125140_125187 = state_125083__$1;
(statearr_125140_125187[(2)] = inst_124933);

(statearr_125140_125187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__109971__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__109971__auto____0 = (function (){
var statearr_125141 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_125141[(0)] = fluree$db$graphdb$with_t_$_state_machine__109971__auto__);

(statearr_125141[(1)] = (1));

return statearr_125141;
});
var fluree$db$graphdb$with_t_$_state_machine__109971__auto____1 = (function (state_125083){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125083);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125142){if((e125142 instanceof Object)){
var ex__109974__auto__ = e125142;
var statearr_125143_125188 = state_125083;
(statearr_125143_125188[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125083);

return cljs.core.cst$kw$recur;
} else {
throw e125142;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125189 = state_125083;
state_125083 = G__125189;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__109971__auto__ = function(state_125083){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__109971__auto____1.call(this,state_125083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__109971__auto____0;
fluree$db$graphdb$with_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__109971__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_125144 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125144[(6)] = c__110077__auto__);

return statearr_125144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___125324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___125324,resp_ch){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___125324,resp_ch){
return (function (state_125281){
var state_val_125282 = (state_125281[(1)]);
if((state_val_125282 === (7))){
var inst_125209 = (state_125281[(2)]);
var inst_125210 = cljs.core.empty_QMARK_(flakes);
var state_125281__$1 = (function (){var statearr_125283 = state_125281;
(statearr_125283[(7)] = inst_125209);

return statearr_125283;
})();
if(inst_125210){
var statearr_125284_125325 = state_125281__$1;
(statearr_125284_125325[(1)] = (8));

} else {
var statearr_125285_125326 = state_125281__$1;
(statearr_125285_125326[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (20))){
var state_125281__$1 = state_125281;
var statearr_125286_125327 = state_125281__$1;
(statearr_125286_125327[(2)] = null);

(statearr_125286_125327[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (1))){
var state_125281__$1 = state_125281;
var statearr_125287_125328 = state_125281__$1;
(statearr_125287_125328[(2)] = null);

(statearr_125287_125328[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (24))){
var inst_125239 = (state_125281[(8)]);
var inst_125238 = (state_125281[(9)]);
var inst_125256 = (state_125281[(10)]);
var inst_125261 = inst_125238.t;
var inst_125262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125263 = [inst_125238];
var inst_125264 = (new cljs.core.PersistentVector(null,1,(5),inst_125262,inst_125263,null));
var inst_125229 = inst_125239;
var inst_125230 = inst_125261;
var inst_125231 = inst_125264;
var inst_125232 = inst_125256;
var state_125281__$1 = (function (){var statearr_125288 = state_125281;
(statearr_125288[(11)] = inst_125231);

(statearr_125288[(12)] = inst_125232);

(statearr_125288[(13)] = inst_125229);

(statearr_125288[(14)] = inst_125230);

return statearr_125288;
})();
var statearr_125289_125329 = state_125281__$1;
(statearr_125289_125329[(2)] = null);

(statearr_125289_125329[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125281,(3),java.lang.Exception,null,(2));
var inst_125195 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_125196 = (inst_125195 + (1));
var inst_125197 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_125196);
var state_125281__$1 = state_125281;
if(inst_125197){
var statearr_125290_125330 = state_125281__$1;
(statearr_125290_125330[(1)] = (5));

} else {
var statearr_125291_125331 = state_125281__$1;
(statearr_125291_125331[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (15))){
var inst_125245 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
if(cljs.core.truth_(inst_125245)){
var statearr_125292_125332 = state_125281__$1;
(statearr_125292_125332[(1)] = (16));

} else {
var statearr_125293_125333 = state_125281__$1;
(statearr_125293_125333[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (21))){
var inst_125270 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
var statearr_125294_125334 = state_125281__$1;
(statearr_125294_125334[(2)] = inst_125270);

(statearr_125294_125334[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (13))){
var inst_125238 = (state_125281[(9)]);
var inst_125230 = (state_125281[(14)]);
var inst_125241 = inst_125238.t;
var inst_125242 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_125230,inst_125241);
var state_125281__$1 = state_125281;
var statearr_125295_125335 = state_125281__$1;
(statearr_125295_125335[(2)] = inst_125242);

(statearr_125295_125335[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (22))){
var inst_125238 = (state_125281[(9)]);
var inst_125255 = (state_125281[(2)]);
var inst_125256 = fluree.db.util.async.throw_err(inst_125255);
var inst_125257 = (inst_125238 == null);
var state_125281__$1 = (function (){var statearr_125296 = state_125281;
(statearr_125296[(10)] = inst_125256);

return statearr_125296;
})();
if(cljs.core.truth_(inst_125257)){
var statearr_125297_125336 = state_125281__$1;
(statearr_125297_125336[(1)] = (23));

} else {
var statearr_125298_125337 = state_125281__$1;
(statearr_125298_125337[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (6))){
var state_125281__$1 = state_125281;
var statearr_125299_125338 = state_125281__$1;
(statearr_125299_125338[(2)] = null);

(statearr_125299_125338[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (25))){
var inst_125267 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
var statearr_125300_125339 = state_125281__$1;
(statearr_125300_125339[(2)] = inst_125267);

(statearr_125300_125339[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (17))){
var state_125281__$1 = state_125281;
var statearr_125301_125340 = state_125281__$1;
(statearr_125301_125340[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (3))){
var inst_125190 = (state_125281[(2)]);
var inst_125191 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_125190);
var state_125281__$1 = state_125281;
var statearr_125303_125341 = state_125281__$1;
(statearr_125303_125341[(2)] = inst_125191);


cljs.core.async.impl.ioc_helpers.process_exception(state_125281__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (12))){
var inst_125274 = (state_125281[(2)]);
var inst_125275 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_125274);
var state_125281__$1 = state_125281;
var statearr_125304_125342 = state_125281__$1;
(statearr_125304_125342[(2)] = inst_125275);

(statearr_125304_125342[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (2))){
var inst_125279 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125281__$1,inst_125279);
} else {
if((state_val_125282 === (23))){
var inst_125256 = (state_125281[(10)]);
var inst_125259 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_125256,cljs.core.cst$kw$block,block);
var state_125281__$1 = state_125281;
var statearr_125305_125343 = state_125281__$1;
(statearr_125305_125343[(2)] = inst_125259);

(statearr_125305_125343[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (19))){
var inst_125231 = (state_125281[(11)]);
var inst_125232 = (state_125281[(12)]);
var inst_125230 = (state_125281[(14)]);
var inst_125251 = (inst_125230 + (1));
var inst_125252 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_125232,cljs.core.cst$kw$t,inst_125251);
var inst_125253 = fluree.db.graphdb.with_t(inst_125252,inst_125231);
var state_125281__$1 = state_125281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125281__$1,(22),inst_125253);
} else {
if((state_val_125282 === (11))){
var inst_125229 = (state_125281[(13)]);
var inst_125238 = (state_125281[(9)]);
var inst_125237 = cljs.core.seq(inst_125229);
var inst_125238__$1 = cljs.core.first(inst_125237);
var inst_125239 = cljs.core.next(inst_125237);
var state_125281__$1 = (function (){var statearr_125306 = state_125281;
(statearr_125306[(8)] = inst_125239);

(statearr_125306[(9)] = inst_125238__$1);

return statearr_125306;
})();
if(cljs.core.truth_(inst_125238__$1)){
var statearr_125307_125344 = state_125281__$1;
(statearr_125307_125344[(1)] = (13));

} else {
var statearr_125308_125345 = state_125281__$1;
(statearr_125308_125345[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (9))){
var inst_125215 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_125223 = cljs.core.seq(inst_125215);
var inst_125224 = cljs.core.first(inst_125223);
var inst_125225 = cljs.core.next(inst_125223);
var inst_125226 = cljs.core.first(inst_125215);
var inst_125227 = inst_125226.t;
var inst_125228 = cljs.core.PersistentVector.EMPTY;
var inst_125229 = inst_125215;
var inst_125230 = inst_125227;
var inst_125231 = inst_125228;
var inst_125232 = db;
var state_125281__$1 = (function (){var statearr_125309 = state_125281;
(statearr_125309[(15)] = inst_125225);

(statearr_125309[(11)] = inst_125231);

(statearr_125309[(12)] = inst_125232);

(statearr_125309[(13)] = inst_125229);

(statearr_125309[(16)] = inst_125224);

(statearr_125309[(14)] = inst_125230);

return statearr_125309;
})();
var statearr_125310_125346 = state_125281__$1;
(statearr_125310_125346[(2)] = null);

(statearr_125310_125346[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (5))){
var inst_125199 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_125200 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_125201 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_125199)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_125200)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_125202 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_125203 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_125204 = cljs.core.PersistentHashMap.fromArrays(inst_125202,inst_125203);
var inst_125205 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_125201,inst_125204);
var inst_125206 = (function(){throw inst_125205})();
var state_125281__$1 = state_125281;
var statearr_125313_125347 = state_125281__$1;
(statearr_125313_125347[(2)] = inst_125206);

(statearr_125313_125347[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (14))){
var inst_125238 = (state_125281[(9)]);
var state_125281__$1 = state_125281;
var statearr_125314_125348 = state_125281__$1;
(statearr_125314_125348[(2)] = inst_125238);

(statearr_125314_125348[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (16))){
var inst_125231 = (state_125281[(11)]);
var inst_125232 = (state_125281[(12)]);
var inst_125239 = (state_125281[(8)]);
var inst_125238 = (state_125281[(9)]);
var inst_125230 = (state_125281[(14)]);
var inst_125247 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_125231,inst_125238);
var tmp125311 = inst_125232;
var tmp125312 = inst_125230;
var inst_125229 = inst_125239;
var inst_125230__$1 = tmp125312;
var inst_125231__$1 = inst_125247;
var inst_125232__$1 = tmp125311;
var state_125281__$1 = (function (){var statearr_125315 = state_125281;
(statearr_125315[(11)] = inst_125231__$1);

(statearr_125315[(12)] = inst_125232__$1);

(statearr_125315[(13)] = inst_125229);

(statearr_125315[(14)] = inst_125230__$1);

return statearr_125315;
})();
var statearr_125316_125349 = state_125281__$1;
(statearr_125316_125349[(2)] = null);

(statearr_125316_125349[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (10))){
var inst_125277 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
var statearr_125317_125350 = state_125281__$1;
(statearr_125317_125350[(2)] = inst_125277);


cljs.core.async.impl.ioc_helpers.process_exception(state_125281__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (18))){
var inst_125272 = (state_125281[(2)]);
var state_125281__$1 = state_125281;
var statearr_125318_125351 = state_125281__$1;
(statearr_125318_125351[(2)] = inst_125272);

(statearr_125318_125351[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125282 === (8))){
var inst_125212 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_125213 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_125212);
var state_125281__$1 = state_125281;
var statearr_125319_125352 = state_125281__$1;
(statearr_125319_125352[(2)] = inst_125213);

(statearr_125319_125352[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___125324,resp_ch))
;
return ((function (switch__109970__auto__,c__110077__auto___125324,resp_ch){
return (function() {
var fluree$db$graphdb$with_$_state_machine__109971__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__109971__auto____0 = (function (){
var statearr_125320 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_125320[(0)] = fluree$db$graphdb$with_$_state_machine__109971__auto__);

(statearr_125320[(1)] = (1));

return statearr_125320;
});
var fluree$db$graphdb$with_$_state_machine__109971__auto____1 = (function (state_125281){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125281);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125321){if((e125321 instanceof Object)){
var ex__109974__auto__ = e125321;
var statearr_125322_125353 = state_125281;
(statearr_125322_125353[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125281);

return cljs.core.cst$kw$recur;
} else {
throw e125321;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125354 = state_125281;
state_125281 = G__125354;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__109971__auto__ = function(state_125281){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__109971__auto____1.call(this,state_125281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__109971__auto____0;
fluree$db$graphdb$with_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__109971__auto____1;
return fluree$db$graphdb$with_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___125324,resp_ch))
})();
var state__110079__auto__ = (function (){var statearr_125323 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125323[(6)] = c__110077__auto___125324);

return statearr_125323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___125324,resp_ch))
);


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_125407){
var state_val_125408 = (state_125407[(1)]);
if((state_val_125408 === (7))){
var inst_125364 = (state_125407[(2)]);
var inst_125365 = (function (){var tt_id_SINGLEQUOTE_ = inst_125364;
return ((function (tt_id_SINGLEQUOTE_,inst_125364,state_val_125408,c__110077__auto__){
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
;})(tt_id_SINGLEQUOTE_,inst_125364,state_val_125408,c__110077__auto__))
})();
var inst_125366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_125364);
var inst_125367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125368 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_125369 = (new cljs.core.PersistentVector(null,4,(5),inst_125367,inst_125368,null));
var inst_125370 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_125365,inst_125366,inst_125369);
var inst_125371 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_125372 = cljs.core.reverse(inst_125371);
var inst_125373 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_125372);
var inst_125381 = cljs.core.seq(inst_125373);
var inst_125382 = cljs.core.first(inst_125381);
var inst_125383 = cljs.core.next(inst_125381);
var inst_125384 = inst_125370;
var inst_125385 = inst_125373;
var state_125407__$1 = (function (){var statearr_125409 = state_125407;
(statearr_125409[(7)] = inst_125382);

(statearr_125409[(8)] = inst_125385);

(statearr_125409[(9)] = inst_125384);

(statearr_125409[(10)] = inst_125383);

return statearr_125409;
})();
var statearr_125410_125429 = state_125407__$1;
(statearr_125410_125429[(2)] = null);

(statearr_125410_125429[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (1))){
var state_125407__$1 = state_125407;
var statearr_125411_125430 = state_125407__$1;
(statearr_125411_125430[(2)] = null);

(statearr_125411_125430[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125407,(3),Error,null,(2));
var inst_125359 = (tt_id == null);
var state_125407__$1 = state_125407;
if(cljs.core.truth_(inst_125359)){
var statearr_125412_125431 = state_125407__$1;
(statearr_125412_125431[(1)] = (5));

} else {
var statearr_125413_125432 = state_125407__$1;
(statearr_125413_125432[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (13))){
var inst_125392 = (state_125407[(11)]);
var inst_125396 = (state_125407[(2)]);
var inst_125397 = fluree.db.util.async.throw_err(inst_125396);
var inst_125384 = inst_125397;
var inst_125385 = inst_125392;
var state_125407__$1 = (function (){var statearr_125414 = state_125407;
(statearr_125414[(8)] = inst_125385);

(statearr_125414[(9)] = inst_125384);

return statearr_125414;
})();
var statearr_125415_125433 = state_125407__$1;
(statearr_125415_125433[(2)] = null);

(statearr_125415_125433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (6))){
var state_125407__$1 = state_125407;
var statearr_125416_125434 = state_125407__$1;
(statearr_125416_125434[(2)] = tt_id);

(statearr_125416_125434[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (3))){
var inst_125355 = (state_125407[(2)]);
var state_125407__$1 = state_125407;
var statearr_125417_125435 = state_125407__$1;
(statearr_125417_125435[(2)] = inst_125355);


cljs.core.async.impl.ioc_helpers.process_exception(state_125407__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (12))){
var inst_125401 = (state_125407[(2)]);
var state_125407__$1 = state_125407;
var statearr_125418_125436 = state_125407__$1;
(statearr_125418_125436[(2)] = inst_125401);

(statearr_125418_125436[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (2))){
var inst_125405 = (state_125407[(2)]);
var state_125407__$1 = state_125407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125407__$1,inst_125405);
} else {
if((state_val_125408 === (11))){
var inst_125384 = (state_125407[(9)]);
var state_125407__$1 = state_125407;
var statearr_125419_125437 = state_125407__$1;
(statearr_125419_125437[(2)] = inst_125384);

(statearr_125419_125437[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (9))){
var inst_125403 = (state_125407[(2)]);
var state_125407__$1 = state_125407;
var statearr_125420_125438 = state_125407__$1;
(statearr_125420_125438[(2)] = inst_125403);


cljs.core.async.impl.ioc_helpers.process_exception(state_125407__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (5))){
var inst_125361 = fluree.db.util.core.random_uuid();
var state_125407__$1 = state_125407;
var statearr_125421_125439 = state_125407__$1;
(statearr_125421_125439[(2)] = inst_125361);

(statearr_125421_125439[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125408 === (10))){
var inst_125384 = (state_125407[(9)]);
var inst_125391 = (state_125407[(12)]);
var inst_125394 = fluree.db.graphdb.with_t(inst_125384,inst_125391);
var state_125407__$1 = state_125407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125407__$1,(13),inst_125394);
} else {
if((state_val_125408 === (8))){
var inst_125385 = (state_125407[(8)]);
var inst_125391 = (state_125407[(12)]);
var inst_125390 = cljs.core.seq(inst_125385);
var inst_125391__$1 = cljs.core.first(inst_125390);
var inst_125392 = cljs.core.next(inst_125390);
var state_125407__$1 = (function (){var statearr_125422 = state_125407;
(statearr_125422[(11)] = inst_125392);

(statearr_125422[(12)] = inst_125391__$1);

return statearr_125422;
})();
if(cljs.core.truth_(inst_125391__$1)){
var statearr_125423_125440 = state_125407__$1;
(statearr_125423_125440[(1)] = (10));

} else {
var statearr_125424_125441 = state_125407__$1;
(statearr_125424_125441[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____0 = (function (){
var statearr_125425 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_125425[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__);

(statearr_125425[(1)] = (1));

return statearr_125425;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____1 = (function (state_125407){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125407);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125426){if((e125426 instanceof Object)){
var ex__109974__auto__ = e125426;
var statearr_125427_125442 = state_125407;
(statearr_125427_125442[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125407);

return cljs.core.cst$kw$recur;
} else {
throw e125426;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125443 = state_125407;
state_125407 = G__125443;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__ = function(state_125407){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____1.call(this,state_125407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_125428 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125428[(6)] = c__110077__auto__);

return statearr_125428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___125612 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___125612,return_chan){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___125612,return_chan){
return (function (state_125555){
var state_val_125556 = (state_125555[(1)]);
if((state_val_125556 === (7))){
var inst_125526 = (state_125555[(7)]);
var inst_125526__$1 = (state_125555[(2)]);
var state_125555__$1 = (function (){var statearr_125557 = state_125555;
(statearr_125557[(7)] = inst_125526__$1);

return statearr_125557;
})();
if(cljs.core.truth_(inst_125526__$1)){
var statearr_125558_125613 = state_125555__$1;
(statearr_125558_125613[(1)] = (28));

} else {
var statearr_125559_125614 = state_125555__$1;
(statearr_125559_125614[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (20))){
var inst_125496 = (state_125555[(8)]);
var inst_125500 = cljs.core.first(inst_125496);
var state_125555__$1 = state_125555;
var statearr_125560_125615 = state_125555__$1;
(statearr_125560_125615[(2)] = inst_125500);

(statearr_125560_125615[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (27))){
var inst_125520 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125561_125616 = state_125555__$1;
(statearr_125561_125616[(2)] = inst_125520);

(statearr_125561_125616[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (1))){
var state_125555__$1 = state_125555;
var statearr_125562_125617 = state_125555__$1;
(statearr_125562_125617[(2)] = null);

(statearr_125562_125617[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (24))){
var inst_125508 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125563_125618 = state_125555__$1;
(statearr_125563_125618[(2)] = inst_125508);

(statearr_125563_125618[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (39))){
var inst_125547 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125564_125619 = state_125555__$1;
(statearr_125564_125619[(2)] = inst_125547);

(statearr_125564_125619[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125555,(3),java.lang.Exception,null,(2));
var inst_125454 = typeof ident === 'number';
var state_125555__$1 = state_125555;
if(cljs.core.truth_(inst_125454)){
var statearr_125565_125620 = state_125555__$1;
(statearr_125565_125620[(1)] = (5));

} else {
var statearr_125566_125621 = state_125555__$1;
(statearr_125566_125621[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (15))){
var inst_125487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125488 = cljs.core.first(ident);
var inst_125489 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_125488);
var inst_125490 = cljs.core.second(ident);
var inst_125491 = [inst_125489,inst_125490];
var inst_125492 = (new cljs.core.PersistentVector(null,2,(5),inst_125487,inst_125491,null));
var inst_125493 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_125492);
var state_125555__$1 = state_125555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125555__$1,(18),inst_125493);
} else {
if((state_val_125556 === (21))){
var inst_125502 = (state_125555[(9)]);
var inst_125502__$1 = (state_125555[(2)]);
var inst_125503 = (inst_125502__$1 == null);
var state_125555__$1 = (function (){var statearr_125567 = state_125555;
(statearr_125567[(9)] = inst_125502__$1);

return statearr_125567;
})();
if(cljs.core.truth_(inst_125503)){
var statearr_125568_125622 = state_125555__$1;
(statearr_125568_125622[(1)] = (22));

} else {
var statearr_125569_125623 = state_125555__$1;
(statearr_125569_125623[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (31))){
var state_125555__$1 = state_125555;
var statearr_125570_125624 = state_125555__$1;
(statearr_125570_125624[(2)] = strict_QMARK_);

(statearr_125570_125624[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (32))){
var inst_125530 = (state_125555[(10)]);
var state_125555__$1 = state_125555;
var statearr_125571_125625 = state_125555__$1;
(statearr_125571_125625[(2)] = inst_125530);

(statearr_125571_125625[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (33))){
var inst_125534 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
if(cljs.core.truth_(inst_125534)){
var statearr_125572_125626 = state_125555__$1;
(statearr_125572_125626[(1)] = (34));

} else {
var statearr_125573_125627 = state_125555__$1;
(statearr_125573_125627[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (13))){
var inst_125484 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_125555__$1 = state_125555;
if(inst_125484){
var statearr_125574_125628 = state_125555__$1;
(statearr_125574_125628[(1)] = (15));

} else {
var statearr_125575_125629 = state_125555__$1;
(statearr_125575_125629[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (22))){
var state_125555__$1 = state_125555;
var statearr_125576_125630 = state_125555__$1;
(statearr_125576_125630[(2)] = null);

(statearr_125576_125630[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (36))){
var inst_125549 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125577_125631 = state_125555__$1;
(statearr_125577_125631[(2)] = inst_125549);

(statearr_125577_125631[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (29))){
var inst_125530 = (state_125555[(10)]);
var inst_125526 = (state_125555[(7)]);
var inst_125530__$1 = (inst_125526 == null);
var state_125555__$1 = (function (){var statearr_125578 = state_125555;
(statearr_125578[(10)] = inst_125530__$1);

return statearr_125578;
})();
if(cljs.core.truth_(inst_125530__$1)){
var statearr_125579_125632 = state_125555__$1;
(statearr_125579_125632[(1)] = (31));

} else {
var statearr_125580_125633 = state_125555__$1;
(statearr_125580_125633[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (6))){
var inst_125469 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_125470 = cljs.core.first(ident);
var inst_125471 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_125470);
var inst_125472 = (inst_125471 == null);
var inst_125473 = ((inst_125469) && (inst_125472));
var state_125555__$1 = state_125555;
if(cljs.core.truth_(inst_125473)){
var statearr_125581_125634 = state_125555__$1;
(statearr_125581_125634[(1)] = (12));

} else {
var statearr_125582_125635 = state_125555__$1;
(statearr_125582_125635[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (28))){
var inst_125526 = (state_125555[(7)]);
var inst_125528 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_125526);
var state_125555__$1 = state_125555;
var statearr_125583_125636 = state_125555__$1;
(statearr_125583_125636[(2)] = inst_125528);

(statearr_125583_125636[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (25))){
var inst_125511 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_125512 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_125511].join('');
var inst_125513 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_125514 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_125515 = cljs.core.PersistentHashMap.fromArrays(inst_125513,inst_125514);
var inst_125516 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_125512,inst_125515);
var inst_125517 = (function(){throw inst_125516})();
var state_125555__$1 = state_125555;
var statearr_125584_125637 = state_125555__$1;
(statearr_125584_125637[(2)] = inst_125517);

(statearr_125584_125637[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (34))){
var inst_125536 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_125537 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_125538 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_125539 = cljs.core.PersistentHashMap.fromArrays(inst_125537,inst_125538);
var inst_125540 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_125536,inst_125539);
var inst_125541 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_125540);
var state_125555__$1 = state_125555;
var statearr_125585_125638 = state_125555__$1;
(statearr_125585_125638[(2)] = inst_125541);

(statearr_125585_125638[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (17))){
var inst_125522 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125586_125639 = state_125555__$1;
(statearr_125586_125639[(2)] = inst_125522);

(statearr_125586_125639[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (3))){
var inst_125444 = (state_125555[(2)]);
var inst_125445 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_125446 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_125447 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_125448 = cljs.core.PersistentHashMap.fromArrays(inst_125446,inst_125447);
var inst_125449 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_125445,inst_125448,inst_125444);
var inst_125450 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_125449);
var state_125555__$1 = state_125555;
var statearr_125587_125640 = state_125555__$1;
(statearr_125587_125640[(2)] = inst_125450);


cljs.core.async.impl.ioc_helpers.process_exception(state_125555__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (12))){
var inst_125475 = cljs.core.first(ident);
var inst_125476 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_125475], 0));
var inst_125477 = ["Subject ID lookup failed. The predicate ",inst_125476," does not exist."].join('');
var inst_125478 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_125479 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_125480 = cljs.core.PersistentHashMap.fromArrays(inst_125478,inst_125479);
var inst_125481 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_125477,inst_125480);
var inst_125482 = (function(){throw inst_125481})();
var state_125555__$1 = state_125555;
var statearr_125588_125641 = state_125555__$1;
(statearr_125588_125641[(2)] = inst_125482);

(statearr_125588_125641[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (2))){
var inst_125553 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125555__$1,inst_125553);
} else {
if((state_val_125556 === (23))){
var inst_125502 = (state_125555[(9)]);
var inst_125506 = inst_125502.s;
var state_125555__$1 = state_125555;
var statearr_125589_125642 = state_125555__$1;
(statearr_125589_125642[(2)] = inst_125506);

(statearr_125589_125642[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (35))){
var state_125555__$1 = state_125555;
var statearr_125590_125643 = state_125555__$1;
(statearr_125590_125643[(1)] = (37));



return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (19))){
var state_125555__$1 = state_125555;
var statearr_125592_125644 = state_125555__$1;
(statearr_125592_125644[(2)] = null);

(statearr_125592_125644[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (11))){
var inst_125467 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125593_125645 = state_125555__$1;
(statearr_125593_125645[(2)] = inst_125467);

(statearr_125593_125645[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (9))){
var state_125555__$1 = state_125555;
var statearr_125594_125646 = state_125555__$1;
(statearr_125594_125646[(2)] = ident);

(statearr_125594_125646[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (5))){
var inst_125456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125457 = [ident];
var inst_125458 = (new cljs.core.PersistentVector(null,1,(5),inst_125456,inst_125457,null));
var inst_125459 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_125458);
var state_125555__$1 = state_125555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125555__$1,(8),inst_125459);
} else {
if((state_val_125556 === (14))){
var inst_125524 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125595_125647 = state_125555__$1;
(statearr_125595_125647[(2)] = inst_125524);

(statearr_125595_125647[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (26))){
var state_125555__$1 = state_125555;
var statearr_125596_125648 = state_125555__$1;
(statearr_125596_125648[(2)] = null);

(statearr_125596_125648[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (16))){
var state_125555__$1 = state_125555;
var statearr_125597_125649 = state_125555__$1;
(statearr_125597_125649[(1)] = (25));



return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (38))){
var state_125555__$1 = state_125555;
var statearr_125599_125650 = state_125555__$1;
(statearr_125599_125650[(2)] = null);

(statearr_125599_125650[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (30))){
var inst_125551 = (state_125555[(2)]);
var state_125555__$1 = state_125555;
var statearr_125600_125651 = state_125555__$1;
(statearr_125600_125651[(2)] = inst_125551);


cljs.core.async.impl.ioc_helpers.process_exception(state_125555__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (10))){
var state_125555__$1 = state_125555;
var statearr_125601_125652 = state_125555__$1;
(statearr_125601_125652[(2)] = null);

(statearr_125601_125652[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (18))){
var inst_125496 = (state_125555[(8)]);
var inst_125495 = (state_125555[(2)]);
var inst_125496__$1 = fluree.db.util.async.throw_err(inst_125495);
var inst_125497 = (inst_125496__$1 == null);
var state_125555__$1 = (function (){var statearr_125602 = state_125555;
(statearr_125602[(8)] = inst_125496__$1);

return statearr_125602;
})();
if(cljs.core.truth_(inst_125497)){
var statearr_125603_125653 = state_125555__$1;
(statearr_125603_125653[(1)] = (19));

} else {
var statearr_125604_125654 = state_125555__$1;
(statearr_125604_125654[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (37))){
var inst_125544 = cljs.core.async.close_BANG_(return_chan);
var state_125555__$1 = state_125555;
var statearr_125605_125655 = state_125555__$1;
(statearr_125605_125655[(2)] = inst_125544);

(statearr_125605_125655[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125556 === (8))){
var inst_125461 = (state_125555[(2)]);
var inst_125462 = fluree.db.util.async.throw_err(inst_125461);
var inst_125463 = cljs.core.not_empty(inst_125462);
var state_125555__$1 = state_125555;
if(cljs.core.truth_(inst_125463)){
var statearr_125606_125656 = state_125555__$1;
(statearr_125606_125656[(1)] = (9));

} else {
var statearr_125607_125657 = state_125555__$1;
(statearr_125607_125657[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___125612,return_chan))
;
return ((function (switch__109970__auto__,c__110077__auto___125612,return_chan){
return (function() {
var fluree$db$graphdb$subid_$_state_machine__109971__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__109971__auto____0 = (function (){
var statearr_125608 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_125608[(0)] = fluree$db$graphdb$subid_$_state_machine__109971__auto__);

(statearr_125608[(1)] = (1));

return statearr_125608;
});
var fluree$db$graphdb$subid_$_state_machine__109971__auto____1 = (function (state_125555){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125555);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125609){if((e125609 instanceof Object)){
var ex__109974__auto__ = e125609;
var statearr_125610_125658 = state_125555;
(statearr_125610_125658[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125555);

return cljs.core.cst$kw$recur;
} else {
throw e125609;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125659 = state_125555;
state_125555 = G__125659;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__109971__auto__ = function(state_125555){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__109971__auto____1.call(this,state_125555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__109971__auto____0;
fluree$db$graphdb$subid_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__109971__auto____1;
return fluree$db$graphdb$subid_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___125612,return_chan))
})();
var state__110079__auto__ = (function (){var statearr_125611 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125611[(6)] = c__110077__auto___125612);

return statearr_125611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___125612,return_chan))
);


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k125661,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__125665 = k125661;
var G__125665__$1 = (((G__125665 instanceof cljs.core.Keyword))?G__125665.fqn:null);
switch (G__125665__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k125661,else__4388__auto__);

}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__125666){
var vec__125667 = p__125666;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__125667,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__125667,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__125660){
var self__ = this;
var G__125660__$1 = this;
return (new cljs.core.RecordIter((0),G__125660__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__125670 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__125670(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this125662,other125663){
var self__ = this;
var this125662__$1 = this;
return (((!((other125663 == null)))) && ((this125662__$1.constructor === other125663.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.conn,other125663.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.network,other125663.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.dbid,other125663.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.block,other125663.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.t,other125663.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.tt_id,other125663.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.stats,other125663.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.spot,other125663.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.psot,other125663.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.post,other125663.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.opst,other125663.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.schema,other125663.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.settings,other125663.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.index_configs,other125663.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.schema_cache,other125663.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.novelty,other125663.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.permissions,other125663.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.fork,other125663.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.fork_block,other125663.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.current_db_fn,other125663.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this125662__$1.__extmap,other125663.__extmap)));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__125660){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__125671 = cljs.core.keyword_identical_QMARK_;
var expr__125672 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__125674 = cljs.core.cst$kw$conn;
var G__125675 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125674,G__125675) : pred__125671.call(null,G__125674,G__125675));
})())){
return (new fluree.db.graphdb.GraphDb(G__125660,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125676 = cljs.core.cst$kw$network;
var G__125677 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125676,G__125677) : pred__125671.call(null,G__125676,G__125677));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__125660,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125678 = cljs.core.cst$kw$dbid;
var G__125679 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125678,G__125679) : pred__125671.call(null,G__125678,G__125679));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__125660,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125680 = cljs.core.cst$kw$block;
var G__125681 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125680,G__125681) : pred__125671.call(null,G__125680,G__125681));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__125660,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125682 = cljs.core.cst$kw$t;
var G__125683 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125682,G__125683) : pred__125671.call(null,G__125682,G__125683));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__125660,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125684 = cljs.core.cst$kw$tt_DASH_id;
var G__125685 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125684,G__125685) : pred__125671.call(null,G__125684,G__125685));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__125660,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125686 = cljs.core.cst$kw$stats;
var G__125687 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125686,G__125687) : pred__125671.call(null,G__125686,G__125687));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__125660,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125688 = cljs.core.cst$kw$spot;
var G__125689 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125688,G__125689) : pred__125671.call(null,G__125688,G__125689));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__125660,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125690 = cljs.core.cst$kw$psot;
var G__125691 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125690,G__125691) : pred__125671.call(null,G__125690,G__125691));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__125660,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125692 = cljs.core.cst$kw$post;
var G__125693 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125692,G__125693) : pred__125671.call(null,G__125692,G__125693));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__125660,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125694 = cljs.core.cst$kw$opst;
var G__125695 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125694,G__125695) : pred__125671.call(null,G__125694,G__125695));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__125660,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125696 = cljs.core.cst$kw$schema;
var G__125697 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125696,G__125697) : pred__125671.call(null,G__125696,G__125697));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__125660,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125698 = cljs.core.cst$kw$settings;
var G__125699 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125698,G__125699) : pred__125671.call(null,G__125698,G__125699));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__125660,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125700 = cljs.core.cst$kw$index_DASH_configs;
var G__125701 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125700,G__125701) : pred__125671.call(null,G__125700,G__125701));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__125660,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125702 = cljs.core.cst$kw$schema_DASH_cache;
var G__125703 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125702,G__125703) : pred__125671.call(null,G__125702,G__125703));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__125660,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125704 = cljs.core.cst$kw$novelty;
var G__125705 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125704,G__125705) : pred__125671.call(null,G__125704,G__125705));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__125660,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125706 = cljs.core.cst$kw$permissions;
var G__125707 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125706,G__125707) : pred__125671.call(null,G__125706,G__125707));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__125660,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125708 = cljs.core.cst$kw$fork;
var G__125709 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125708,G__125709) : pred__125671.call(null,G__125708,G__125709));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__125660,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125710 = cljs.core.cst$kw$fork_DASH_block;
var G__125711 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125710,G__125711) : pred__125671.call(null,G__125710,G__125711));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__125660,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__125712 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__125713 = expr__125672;
return (pred__125671.cljs$core$IFn$_invoke$arity$2 ? pred__125671.cljs$core$IFn$_invoke$arity$2(G__125712,G__125713) : pred__125671.call(null,G__125712,G__125713));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__125660,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__125660),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__125660){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__125660,self__.__extmap,self__.__hash));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_125726){
var state_val_125727 = (state_125726[(1)]);
if((state_val_125727 === (1))){
var state_125726__$1 = state_125726;
var statearr_125728_125946 = state_125726__$1;
(statearr_125728_125946[(2)] = null);

(statearr_125728_125946[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125727 === (2))){
var inst_125724 = (state_125726[(2)]);
var state_125726__$1 = state_125726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125726__$1,inst_125724);
} else {
if((state_val_125727 === (3))){
var inst_125714 = (state_125726[(2)]);
var state_125726__$1 = state_125726;
var statearr_125729_125947 = state_125726__$1;
(statearr_125729_125947[(2)] = inst_125714);


cljs.core.async.impl.ioc_helpers.process_exception(state_125726__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125727 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125726,(3),Error,null,(2));
var inst_125718 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_125726__$1 = state_125726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125726__$1,(5),inst_125718);
} else {
if((state_val_125727 === (5))){
var inst_125720 = (state_125726[(2)]);
var inst_125721 = fluree.db.util.async.throw_err(inst_125720);
var inst_125722 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_125721,cljs.core.cst$kw$permissions,self__.permissions);
var state_125726__$1 = state_125726;
var statearr_125730_125948 = state_125726__$1;
(statearr_125730_125948[(2)] = inst_125722);


cljs.core.async.impl.ioc_helpers.process_exception(state_125726__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__109971__auto__ = null;
var fluree$db$graphdb$state_machine__109971__auto____0 = (function (){
var statearr_125731 = [null,null,null,null,null,null,null];
(statearr_125731[(0)] = fluree$db$graphdb$state_machine__109971__auto__);

(statearr_125731[(1)] = (1));

return statearr_125731;
});
var fluree$db$graphdb$state_machine__109971__auto____1 = (function (state_125726){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125726);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125732){if((e125732 instanceof Object)){
var ex__109974__auto__ = e125732;
var statearr_125733_125949 = state_125726;
(statearr_125733_125949[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125726);

return cljs.core.cst$kw$recur;
} else {
throw e125732;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125950 = state_125726;
state_125726 = G__125950;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__109971__auto__ = function(state_125726){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__109971__auto____1.call(this,state_125726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__109971__auto____0;
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__109971__auto____1;
return fluree$db$graphdb$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_125734 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125734[(6)] = c__110077__auto__);

return statearr_125734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__125735 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__125735.cljs$core$IFn$_invoke$arity$1 ? fexpr__125735.cljs$core$IFn$_invoke$arity$1(property) : fexpr__125735.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__125736 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__125736.cljs$core$IFn$_invoke$arity$1 ? fexpr__125736.cljs$core$IFn$_invoke$arity$1(property) : fexpr__125736.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__125737 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$id,G__125737);
} else {
return G__125737;
}
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_125766){
var state_val_125767 = (state_125766[(1)]);
if((state_val_125767 === (7))){
var inst_125750 = (state_125766[(7)]);
var inst_125754 = cljs.core.first(inst_125750);
var state_125766__$1 = state_125766;
var statearr_125768_125951 = state_125766__$1;
(statearr_125768_125951[(2)] = inst_125754);

(statearr_125768_125951[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (1))){
var state_125766__$1 = state_125766;
var statearr_125769_125952 = state_125766__$1;
(statearr_125769_125952[(2)] = null);

(statearr_125769_125952[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125766,(3),Error,null,(2));
var inst_125743 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_125744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125745 = [tag_id,(30)];
var inst_125746 = (new cljs.core.PersistentVector(null,2,(5),inst_125744,inst_125745,null));
var inst_125747 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_125743,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_125746);
var state_125766__$1 = state_125766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125766__$1,(5),inst_125747);
} else {
if((state_val_125767 === (6))){
var state_125766__$1 = state_125766;
var statearr_125770_125953 = state_125766__$1;
(statearr_125770_125953[(2)] = null);

(statearr_125770_125953[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (3))){
var inst_125738 = (state_125766[(2)]);
var state_125766__$1 = state_125766;
var statearr_125771_125954 = state_125766__$1;
(statearr_125771_125954[(2)] = inst_125738);


cljs.core.async.impl.ioc_helpers.process_exception(state_125766__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (2))){
var inst_125764 = (state_125766[(2)]);
var state_125766__$1 = state_125766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125766__$1,inst_125764);
} else {
if((state_val_125767 === (11))){
var inst_125762 = (state_125766[(2)]);
var state_125766__$1 = state_125766;
var statearr_125772_125955 = state_125766__$1;
(statearr_125772_125955[(2)] = inst_125762);


cljs.core.async.impl.ioc_helpers.process_exception(state_125766__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (9))){
var state_125766__$1 = state_125766;
var statearr_125773_125956 = state_125766__$1;
(statearr_125773_125956[(2)] = null);

(statearr_125773_125956[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (5))){
var inst_125750 = (state_125766[(7)]);
var inst_125749 = (state_125766[(2)]);
var inst_125750__$1 = fluree.db.util.async.throw_err(inst_125749);
var inst_125751 = (inst_125750__$1 == null);
var state_125766__$1 = (function (){var statearr_125774 = state_125766;
(statearr_125774[(7)] = inst_125750__$1);

return statearr_125774;
})();
if(cljs.core.truth_(inst_125751)){
var statearr_125775_125957 = state_125766__$1;
(statearr_125775_125957[(1)] = (6));

} else {
var statearr_125776_125958 = state_125766__$1;
(statearr_125776_125958[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (10))){
var inst_125756 = (state_125766[(8)]);
var inst_125760 = inst_125756.o;
var state_125766__$1 = state_125766;
var statearr_125777_125959 = state_125766__$1;
(statearr_125777_125959[(2)] = inst_125760);

(statearr_125777_125959[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125767 === (8))){
var inst_125756 = (state_125766[(8)]);
var inst_125756__$1 = (state_125766[(2)]);
var inst_125757 = (inst_125756__$1 == null);
var state_125766__$1 = (function (){var statearr_125778 = state_125766;
(statearr_125778[(8)] = inst_125756__$1);

return statearr_125778;
})();
if(cljs.core.truth_(inst_125757)){
var statearr_125779_125960 = state_125766__$1;
(statearr_125779_125960[(1)] = (9));

} else {
var statearr_125780_125961 = state_125766__$1;
(statearr_125780_125961[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__109971__auto__ = null;
var fluree$db$graphdb$state_machine__109971__auto____0 = (function (){
var statearr_125781 = [null,null,null,null,null,null,null,null,null];
(statearr_125781[(0)] = fluree$db$graphdb$state_machine__109971__auto__);

(statearr_125781[(1)] = (1));

return statearr_125781;
});
var fluree$db$graphdb$state_machine__109971__auto____1 = (function (state_125766){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125766);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125782){if((e125782 instanceof Object)){
var ex__109974__auto__ = e125782;
var statearr_125783_125962 = state_125766;
(statearr_125783_125962[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125766);

return cljs.core.cst$kw$recur;
} else {
throw e125782;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125963 = state_125766;
state_125766 = G__125963;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__109971__auto__ = function(state_125766){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__109971__auto____1.call(this,state_125766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__109971__auto____0;
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__109971__auto____1;
return fluree$db$graphdb$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_125784 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125784[(6)] = c__110077__auto__);

return statearr_125784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_125817){
var state_val_125818 = (state_125817[(1)]);
if((state_val_125818 === (7))){
var inst_125794 = (state_125817[(2)]);
var inst_125795 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_125817__$1 = (function (){var statearr_125819 = state_125817;
(statearr_125819[(7)] = inst_125794);

return statearr_125819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125817__$1,(8),inst_125795);
} else {
if((state_val_125818 === (1))){
var state_125817__$1 = state_125817;
var statearr_125820_125964 = state_125817__$1;
(statearr_125820_125964[(2)] = null);

(statearr_125820_125964[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125817,(3),Error,null,(2));
var inst_125789 = typeof pred === 'string';
var state_125817__$1 = state_125817;
if(cljs.core.truth_(inst_125789)){
var statearr_125821_125965 = state_125817__$1;
(statearr_125821_125965[(1)] = (5));

} else {
var statearr_125822_125966 = state_125817__$1;
(statearr_125822_125966[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (15))){
var inst_125798 = (state_125817[(8)]);
var inst_125806 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_125798,/:/);
var inst_125807 = cljs.core.second(inst_125806);
var state_125817__$1 = state_125817;
var statearr_125823_125967 = state_125817__$1;
(statearr_125823_125967[(2)] = inst_125807);

(statearr_125823_125967[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (13))){
var state_125817__$1 = state_125817;
var statearr_125824_125968 = state_125817__$1;
(statearr_125824_125968[(2)] = null);

(statearr_125824_125968[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (6))){
var inst_125792 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_125817__$1 = state_125817;
var statearr_125825_125969 = state_125817__$1;
(statearr_125825_125969[(2)] = inst_125792);

(statearr_125825_125969[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (17))){
var inst_125810 = (state_125817[(2)]);
var state_125817__$1 = state_125817;
var statearr_125826_125970 = state_125817__$1;
(statearr_125826_125970[(2)] = inst_125810);

(statearr_125826_125970[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (3))){
var inst_125785 = (state_125817[(2)]);
var state_125817__$1 = state_125817;
var statearr_125827_125971 = state_125817__$1;
(statearr_125827_125971[(2)] = inst_125785);


cljs.core.async.impl.ioc_helpers.process_exception(state_125817__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (12))){
var inst_125798 = (state_125817[(8)]);
var inst_125804 = clojure.string.includes_QMARK_(inst_125798,":");
var state_125817__$1 = state_125817;
if(inst_125804){
var statearr_125828_125972 = state_125817__$1;
(statearr_125828_125972[(1)] = (15));

} else {
var statearr_125829_125973 = state_125817__$1;
(statearr_125829_125973[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (2))){
var inst_125815 = (state_125817[(2)]);
var state_125817__$1 = state_125817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125817__$1,inst_125815);
} else {
if((state_val_125818 === (11))){
var inst_125802 = (state_125817[(2)]);
var state_125817__$1 = state_125817;
if(cljs.core.truth_(inst_125802)){
var statearr_125830_125974 = state_125817__$1;
(statearr_125830_125974[(1)] = (12));

} else {
var statearr_125831_125975 = state_125817__$1;
(statearr_125831_125975[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (9))){
var inst_125798 = (state_125817[(8)]);
var state_125817__$1 = state_125817;
var statearr_125832_125976 = state_125817__$1;
(statearr_125832_125976[(2)] = inst_125798);

(statearr_125832_125976[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (5))){
var state_125817__$1 = state_125817;
var statearr_125833_125977 = state_125817__$1;
(statearr_125833_125977[(2)] = pred);

(statearr_125833_125977[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (14))){
var inst_125813 = (state_125817[(2)]);
var state_125817__$1 = state_125817;
var statearr_125834_125978 = state_125817__$1;
(statearr_125834_125978[(2)] = inst_125813);


cljs.core.async.impl.ioc_helpers.process_exception(state_125817__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (16))){
var inst_125798 = (state_125817[(8)]);
var state_125817__$1 = state_125817;
var statearr_125835_125979 = state_125817__$1;
(statearr_125835_125979[(2)] = inst_125798);

(statearr_125835_125979[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (10))){
var inst_125794 = (state_125817[(7)]);
var state_125817__$1 = state_125817;
var statearr_125836_125980 = state_125817__$1;
(statearr_125836_125980[(2)] = inst_125794);

(statearr_125836_125980[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125818 === (8))){
var inst_125794 = (state_125817[(7)]);
var inst_125797 = (state_125817[(2)]);
var inst_125798 = fluree.db.util.async.throw_err(inst_125797);
var state_125817__$1 = (function (){var statearr_125837 = state_125817;
(statearr_125837[(8)] = inst_125798);

return statearr_125837;
})();
if(cljs.core.truth_(inst_125794)){
var statearr_125838_125981 = state_125817__$1;
(statearr_125838_125981[(1)] = (9));

} else {
var statearr_125839_125982 = state_125817__$1;
(statearr_125839_125982[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__109971__auto__ = null;
var fluree$db$graphdb$state_machine__109971__auto____0 = (function (){
var statearr_125840 = [null,null,null,null,null,null,null,null,null];
(statearr_125840[(0)] = fluree$db$graphdb$state_machine__109971__auto__);

(statearr_125840[(1)] = (1));

return statearr_125840;
});
var fluree$db$graphdb$state_machine__109971__auto____1 = (function (state_125817){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125817);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125841){if((e125841 instanceof Object)){
var ex__109974__auto__ = e125841;
var statearr_125842_125983 = state_125817;
(statearr_125842_125983[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125817);

return cljs.core.cst$kw$recur;
} else {
throw e125841;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125984 = state_125817;
state_125817 = G__125984;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__109971__auto__ = function(state_125817){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__109971__auto____1.call(this,state_125817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__109971__auto____0;
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__109971__auto____1;
return fluree$db$graphdb$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_125843 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125843[(6)] = c__110077__auto__);

return statearr_125843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_125872){
var state_val_125873 = (state_125872[(1)]);
if((state_val_125873 === (7))){
var inst_125856 = (state_125872[(7)]);
var inst_125860 = cljs.core.first(inst_125856);
var state_125872__$1 = state_125872;
var statearr_125874_125985 = state_125872__$1;
(statearr_125874_125985[(2)] = inst_125860);

(statearr_125874_125985[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (1))){
var state_125872__$1 = state_125872;
var statearr_125875_125986 = state_125872__$1;
(statearr_125875_125986[(2)] = null);

(statearr_125875_125986[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125872,(3),Error,null,(2));
var inst_125849 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_125850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_125851 = [(30),tag_name];
var inst_125852 = (new cljs.core.PersistentVector(null,2,(5),inst_125850,inst_125851,null));
var inst_125853 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_125849,cljs.core.cst$kw$post,cljs.core._EQ_,inst_125852);
var state_125872__$1 = state_125872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125872__$1,(5),inst_125853);
} else {
if((state_val_125873 === (6))){
var state_125872__$1 = state_125872;
var statearr_125876_125987 = state_125872__$1;
(statearr_125876_125987[(2)] = null);

(statearr_125876_125987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (3))){
var inst_125844 = (state_125872[(2)]);
var state_125872__$1 = state_125872;
var statearr_125877_125988 = state_125872__$1;
(statearr_125877_125988[(2)] = inst_125844);


cljs.core.async.impl.ioc_helpers.process_exception(state_125872__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (2))){
var inst_125870 = (state_125872[(2)]);
var state_125872__$1 = state_125872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125872__$1,inst_125870);
} else {
if((state_val_125873 === (11))){
var inst_125868 = (state_125872[(2)]);
var state_125872__$1 = state_125872;
var statearr_125878_125989 = state_125872__$1;
(statearr_125878_125989[(2)] = inst_125868);


cljs.core.async.impl.ioc_helpers.process_exception(state_125872__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (9))){
var state_125872__$1 = state_125872;
var statearr_125879_125990 = state_125872__$1;
(statearr_125879_125990[(2)] = null);

(statearr_125879_125990[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (5))){
var inst_125856 = (state_125872[(7)]);
var inst_125855 = (state_125872[(2)]);
var inst_125856__$1 = fluree.db.util.async.throw_err(inst_125855);
var inst_125857 = (inst_125856__$1 == null);
var state_125872__$1 = (function (){var statearr_125880 = state_125872;
(statearr_125880[(7)] = inst_125856__$1);

return statearr_125880;
})();
if(cljs.core.truth_(inst_125857)){
var statearr_125881_125991 = state_125872__$1;
(statearr_125881_125991[(1)] = (6));

} else {
var statearr_125882_125992 = state_125872__$1;
(statearr_125882_125992[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (10))){
var inst_125862 = (state_125872[(8)]);
var inst_125866 = inst_125862.s;
var state_125872__$1 = state_125872;
var statearr_125883_125993 = state_125872__$1;
(statearr_125883_125993[(2)] = inst_125866);

(statearr_125883_125993[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125873 === (8))){
var inst_125862 = (state_125872[(8)]);
var inst_125862__$1 = (state_125872[(2)]);
var inst_125863 = (inst_125862__$1 == null);
var state_125872__$1 = (function (){var statearr_125884 = state_125872;
(statearr_125884[(8)] = inst_125862__$1);

return statearr_125884;
})();
if(cljs.core.truth_(inst_125863)){
var statearr_125885_125994 = state_125872__$1;
(statearr_125885_125994[(1)] = (9));

} else {
var statearr_125886_125995 = state_125872__$1;
(statearr_125886_125995[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__109971__auto__ = null;
var fluree$db$graphdb$state_machine__109971__auto____0 = (function (){
var statearr_125887 = [null,null,null,null,null,null,null,null,null];
(statearr_125887[(0)] = fluree$db$graphdb$state_machine__109971__auto__);

(statearr_125887[(1)] = (1));

return statearr_125887;
});
var fluree$db$graphdb$state_machine__109971__auto____1 = (function (state_125872){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125872);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125888){if((e125888 instanceof Object)){
var ex__109974__auto__ = e125888;
var statearr_125889_125996 = state_125872;
(statearr_125889_125996[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125872);

return cljs.core.cst$kw$recur;
} else {
throw e125888;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__125997 = state_125872;
state_125872 = G__125997;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__109971__auto__ = function(state_125872){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__109971__auto____1.call(this,state_125872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__109971__auto____0;
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__109971__auto____1;
return fluree$db$graphdb$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_125890 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125890[(6)] = c__110077__auto__);

return statearr_125890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_125922){
var state_val_125923 = (state_125922[(1)]);
if((state_val_125923 === (7))){
var inst_125918 = (state_125922[(2)]);
var state_125922__$1 = state_125922;
var statearr_125924_125998 = state_125922__$1;
(statearr_125924_125998[(2)] = inst_125918);


cljs.core.async.impl.ioc_helpers.process_exception(state_125922__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (1))){
var state_125922__$1 = state_125922;
var statearr_125925_125999 = state_125922__$1;
(statearr_125925_125999[(2)] = null);

(statearr_125925_125999[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_125922,(3),Error,null,(2));
var inst_125895 = clojure.string.includes_QMARK_(tag_name,"/");
var state_125922__$1 = state_125922;
if(inst_125895){
var statearr_125926_126000 = state_125922__$1;
(statearr_125926_126000[(1)] = (5));

} else {
var statearr_125927_126001 = state_125922__$1;
(statearr_125927_126001[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (15))){
var inst_125912 = (state_125922[(2)]);
var inst_125913 = fluree.db.util.async.throw_err(inst_125912);
var state_125922__$1 = state_125922;
var statearr_125928_126002 = state_125922__$1;
(statearr_125928_126002[(2)] = inst_125913);

(statearr_125928_126002[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (13))){
var state_125922__$1 = state_125922;
var statearr_125929_126003 = state_125922__$1;
(statearr_125929_126003[(2)] = null);

(statearr_125929_126003[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (6))){
var inst_125902 = typeof pred === 'string';
var state_125922__$1 = state_125922;
if(cljs.core.truth_(inst_125902)){
var statearr_125930_126004 = state_125922__$1;
(statearr_125930_126004[(1)] = (9));

} else {
var statearr_125931_126005 = state_125922__$1;
(statearr_125931_126005[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (3))){
var inst_125891 = (state_125922[(2)]);
var state_125922__$1 = state_125922;
var statearr_125932_126006 = state_125922__$1;
(statearr_125932_126006[(2)] = inst_125891);


cljs.core.async.impl.ioc_helpers.process_exception(state_125922__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (12))){
var inst_125907 = (state_125922[(7)]);
var inst_125909 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_125907),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_125910 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_125909);
var state_125922__$1 = state_125922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125922__$1,(15),inst_125910);
} else {
if((state_val_125923 === (2))){
var inst_125920 = (state_125922[(2)]);
var state_125922__$1 = state_125922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_125922__$1,inst_125920);
} else {
if((state_val_125923 === (11))){
var inst_125907 = (state_125922[(7)]);
var inst_125907__$1 = (state_125922[(2)]);
var state_125922__$1 = (function (){var statearr_125933 = state_125922;
(statearr_125933[(7)] = inst_125907__$1);

return statearr_125933;
})();
if(cljs.core.truth_(inst_125907__$1)){
var statearr_125934_126007 = state_125922__$1;
(statearr_125934_126007[(1)] = (12));

} else {
var statearr_125935_126008 = state_125922__$1;
(statearr_125935_126008[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (9))){
var state_125922__$1 = state_125922;
var statearr_125936_126009 = state_125922__$1;
(statearr_125936_126009[(2)] = pred);

(statearr_125936_126009[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (5))){
var inst_125897 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_125922__$1 = state_125922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_125922__$1,(8),inst_125897);
} else {
if((state_val_125923 === (14))){
var inst_125916 = (state_125922[(2)]);
var state_125922__$1 = state_125922;
var statearr_125937_126010 = state_125922__$1;
(statearr_125937_126010[(2)] = inst_125916);

(statearr_125937_126010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (10))){
var inst_125905 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_125922__$1 = state_125922;
var statearr_125938_126011 = state_125922__$1;
(statearr_125938_126011[(2)] = inst_125905);

(statearr_125938_126011[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_125923 === (8))){
var inst_125899 = (state_125922[(2)]);
var inst_125900 = fluree.db.util.async.throw_err(inst_125899);
var state_125922__$1 = state_125922;
var statearr_125939_126012 = state_125922__$1;
(statearr_125939_126012[(2)] = inst_125900);

(statearr_125939_126012[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$graphdb$state_machine__109971__auto__ = null;
var fluree$db$graphdb$state_machine__109971__auto____0 = (function (){
var statearr_125940 = [null,null,null,null,null,null,null,null];
(statearr_125940[(0)] = fluree$db$graphdb$state_machine__109971__auto__);

(statearr_125940[(1)] = (1));

return statearr_125940;
});
var fluree$db$graphdb$state_machine__109971__auto____1 = (function (state_125922){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_125922);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e125941){if((e125941 instanceof Object)){
var ex__109974__auto__ = e125941;
var statearr_125942_126013 = state_125922;
(statearr_125942_126013[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_125922);

return cljs.core.cst$kw$recur;
} else {
throw e125941;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126014 = state_125922;
state_125922 = G__126014;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__109971__auto__ = function(state_125922){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__109971__auto____1.call(this,state_125922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__109971__auto____0;
fluree$db$graphdb$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__109971__auto____1;
return fluree$db$graphdb$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_125943 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_125943[(6)] = c__110077__auto__);

return statearr_125943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
});

fluree.db.graphdb.GraphDb.cljs$lang$type = true;

fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
});

fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.graphdb/GraphDb");
});

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__125664){
var extmap__4424__auto__ = (function (){var G__125944 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__125664,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__125664)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__125944);
} else {
return G__125944;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__125664),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__125664),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$dbid,cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$block,cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$t,cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$stats,cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(db__$1),cljs.core.cst$kw$permissions,cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db__$1)], null)], 0)));
});
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
