// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('clojure.string');
goog.require('cljs.core.async');

/** @define {boolean} */
goog.define("fluree.db.api.ledger.browser_env",false);
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__132529 = arguments.length;
switch (G__132529) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
});

fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
console.log("test2072-root-db");

var temp__5733__auto__ = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___132558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___132558,pc,block,temp__5733__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___132558,pc,block,temp__5733__auto__){
return (function (state_132547){
var state_val_132548 = (state_132547[(1)]);
if((state_val_132548 === (1))){
var state_132547__$1 = state_132547;
var statearr_132549_132559 = state_132547__$1;
(statearr_132549_132559[(2)] = null);

(statearr_132549_132559[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132548 === (2))){
var inst_132543 = (state_132547[(2)]);
var inst_132544 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_132543);
var inst_132545 = cljs.core.async.close_BANG_(pc);
var state_132547__$1 = (function (){var statearr_132550 = state_132547;
(statearr_132550[(7)] = inst_132544);

return statearr_132550;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_132547__$1,inst_132545);
} else {
if((state_val_132548 === (3))){
var inst_132530 = (state_132547[(2)]);
var state_132547__$1 = state_132547;
var statearr_132551_132560 = state_132547__$1;
(statearr_132551_132560[(2)] = inst_132530);


cljs.core.async.impl.ioc_helpers.process_exception(state_132547__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132548 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132547,(3),java.lang.Exception,null,(2));
var inst_132534 = fluree.db.session.db(conn,ledger,null);
var state_132547__$1 = state_132547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132547__$1,(6),inst_132534);
} else {
if((state_val_132548 === (5))){
var inst_132540 = (state_132547[(2)]);
var inst_132541 = fluree.db.util.async.throw_err(inst_132540);
var state_132547__$1 = state_132547;
var statearr_132552_132561 = state_132547__$1;
(statearr_132552_132561[(2)] = inst_132541);


cljs.core.async.impl.ioc_helpers.process_exception(state_132547__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132548 === (6))){
var inst_132536 = (state_132547[(2)]);
var inst_132537 = fluree.db.util.async.throw_err(inst_132536);
var inst_132538 = fluree.db.time_travel.as_of_block(inst_132537,block);
var state_132547__$1 = state_132547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132547__$1,(5),inst_132538);
} else {
return null;
}
}
}
}
}
}
});})(c__110077__auto___132558,pc,block,temp__5733__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto___132558,pc,block,temp__5733__auto__){
return (function() {
var fluree$db$api$ledger$state_machine__109971__auto__ = null;
var fluree$db$api$ledger$state_machine__109971__auto____0 = (function (){
var statearr_132553 = [null,null,null,null,null,null,null,null];
(statearr_132553[(0)] = fluree$db$api$ledger$state_machine__109971__auto__);

(statearr_132553[(1)] = (1));

return statearr_132553;
});
var fluree$db$api$ledger$state_machine__109971__auto____1 = (function (state_132547){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132547);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132554){if((e132554 instanceof Object)){
var ex__109974__auto__ = e132554;
var statearr_132555_132562 = state_132547;
(statearr_132555_132562[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132547);

return cljs.core.cst$kw$recur;
} else {
throw e132554;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132563 = state_132547;
state_132547 = G__132563;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__109971__auto__ = function(state_132547){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__109971__auto____1.call(this,state_132547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__109971__auto____0;
fluree$db$api$ledger$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__109971__auto____1;
return fluree$db$api$ledger$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___132558,pc,block,temp__5733__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132556 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132556[(6)] = c__110077__auto___132558);

return statearr_132556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___132558,pc,block,temp__5733__auto__))
);


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
});

fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3;

/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__132565 = arguments.length;
switch (G__132565) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
});

fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
if(fluree.db.api.ledger.browser_env){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
} else {
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
console.log("test2072-db");

var c__110077__auto___132733 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___132733,pc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___132733,pc){
return (function (state_132666){
var state_val_132667 = (state_132666[(1)]);
if((state_val_132667 === (7))){
var state_132666__$1 = state_132666;
var statearr_132668_132734 = state_132666__$1;
(statearr_132668_132734[(2)] = false);

(statearr_132668_132734[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (20))){
var inst_132598 = (state_132666[(7)]);
var inst_132623 = (state_132666[(2)]);
var state_132666__$1 = (function (){var statearr_132669 = state_132666;
(statearr_132669[(8)] = inst_132623);

return statearr_132669;
})();
if(cljs.core.truth_(inst_132598)){
var statearr_132670_132735 = state_132666__$1;
(statearr_132670_132735[(1)] = (25));

} else {
var statearr_132671_132736 = state_132666__$1;
(statearr_132671_132736[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (27))){
var inst_132635 = (state_132666[(9)]);
var inst_132635__$1 = (state_132666[(2)]);
var state_132666__$1 = (function (){var statearr_132672 = state_132666;
(statearr_132672[(9)] = inst_132635__$1);

return statearr_132672;
})();
if(cljs.core.truth_(inst_132635__$1)){
var statearr_132673_132737 = state_132666__$1;
(statearr_132673_132737[(1)] = (32));

} else {
var statearr_132674_132738 = state_132666__$1;
(statearr_132674_132738[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (1))){
var state_132666__$1 = state_132666;
var statearr_132675_132739 = state_132666__$1;
(statearr_132675_132739[(2)] = null);

(statearr_132675_132739[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (24))){
var inst_132620 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
var statearr_132676_132740 = state_132666__$1;
(statearr_132676_132740[(2)] = inst_132620);

(statearr_132676_132740[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (39))){
var inst_132599 = (state_132666[(10)]);
var inst_132648 = (state_132666[(11)]);
var inst_132650 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_132648,cljs.core.cst$kw$auth,inst_132599);
var state_132666__$1 = state_132666;
var statearr_132677_132741 = state_132666__$1;
(statearr_132677_132741[(2)] = inst_132650);

(statearr_132677_132741[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132666,(3),java.lang.Exception,null,(2));
var inst_132573 = fluree.db.session.db(conn,ledger,null);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132666__$1,(5),inst_132573);
} else {
if((state_val_132667 === (15))){
var inst_132599 = (state_132666[(10)]);
var inst_132602 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_132599);
var state_132666__$1 = state_132666;
var statearr_132678_132742 = state_132666__$1;
(statearr_132678_132742[(2)] = inst_132602);

(statearr_132678_132742[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (21))){
var inst_132610 = (state_132666[(12)]);
var inst_132609 = (state_132666[(2)]);
var inst_132610__$1 = fluree.db.util.async.throw_err(inst_132609);
var state_132666__$1 = (function (){var statearr_132679 = state_132666;
(statearr_132679[(12)] = inst_132610__$1);

return statearr_132679;
})();
if(cljs.core.truth_(inst_132610__$1)){
var statearr_132680_132743 = state_132666__$1;
(statearr_132680_132743[(1)] = (22));

} else {
var statearr_132681_132744 = state_132666__$1;
(statearr_132681_132744[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (31))){
var inst_132629 = (state_132666[(2)]);
var inst_132630 = fluree.db.util.async.throw_err(inst_132629);
var state_132666__$1 = state_132666;
var statearr_132682_132745 = state_132666__$1;
(statearr_132682_132745[(2)] = inst_132630);

(statearr_132682_132745[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (32))){
var inst_132576 = (state_132666[(13)]);
var inst_132635 = (state_132666[(9)]);
var inst_132637 = fluree.db.permissions.permission_map(inst_132576,inst_132635,cljs.core.cst$kw$query);
var state_132666__$1 = state_132666;
var statearr_132683_132746 = state_132666__$1;
(statearr_132683_132746[(2)] = inst_132637);

(statearr_132683_132746[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (40))){
var inst_132648 = (state_132666[(11)]);
var state_132666__$1 = state_132666;
var statearr_132684_132747 = state_132666__$1;
(statearr_132684_132747[(2)] = inst_132648);

(statearr_132684_132747[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (33))){
var state_132666__$1 = state_132666;
var statearr_132685_132748 = state_132666__$1;
(statearr_132685_132748[(2)] = null);

(statearr_132685_132748[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (13))){
var state_132666__$1 = state_132666;
var statearr_132686_132749 = state_132666__$1;
(statearr_132686_132749[(2)] = opts);

(statearr_132686_132749[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (22))){
var inst_132610 = (state_132666[(12)]);
var state_132666__$1 = state_132666;
var statearr_132687_132750 = state_132666__$1;
(statearr_132687_132750[(2)] = inst_132610);

(statearr_132687_132750[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (36))){
var inst_132576 = (state_132666[(13)]);
var state_132666__$1 = state_132666;
var statearr_132688_132751 = state_132666__$1;
(statearr_132688_132751[(2)] = inst_132576);

(statearr_132688_132751[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (41))){
var inst_132635 = (state_132666[(9)]);
var inst_132653 = (state_132666[(2)]);
var state_132666__$1 = (function (){var statearr_132689 = state_132666;
(statearr_132689[(14)] = inst_132653);

return statearr_132689;
})();
if(cljs.core.truth_(inst_132635)){
var statearr_132690_132752 = state_132666__$1;
(statearr_132690_132752[(1)] = (42));

} else {
var statearr_132691_132753 = state_132666__$1;
(statearr_132691_132753[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (43))){
var inst_132653 = (state_132666[(14)]);
var state_132666__$1 = state_132666;
var statearr_132692_132754 = state_132666__$1;
(statearr_132692_132754[(2)] = inst_132653);

(statearr_132692_132754[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (29))){
var state_132666__$1 = state_132666;
var statearr_132693_132755 = state_132666__$1;
(statearr_132693_132755[(2)] = null);

(statearr_132693_132755[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (44))){
var inst_132661 = (state_132666[(2)]);
var inst_132662 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_132661);
var state_132666__$1 = state_132666;
var statearr_132694_132756 = state_132666__$1;
(statearr_132694_132756[(2)] = inst_132662);


cljs.core.async.impl.ioc_helpers.process_exception(state_132666__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (6))){
var inst_132581 = opts.cljs$lang$protocol_mask$partition0$;
var inst_132582 = (inst_132581 & (64));
var inst_132583 = opts.cljs$core$ISeq$;
var inst_132584 = (cljs.core.PROTOCOL_SENTINEL === inst_132583);
var inst_132585 = ((inst_132582) || (inst_132584));
var state_132666__$1 = state_132666;
if(cljs.core.truth_(inst_132585)){
var statearr_132695_132757 = state_132666__$1;
(statearr_132695_132757[(1)] = (9));

} else {
var statearr_132696_132758 = state_132666__$1;
(statearr_132696_132758[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (28))){
var inst_132576 = (state_132666[(13)]);
var inst_132623 = (state_132666[(8)]);
var inst_132627 = fluree.db.auth.roles(inst_132576,inst_132623);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132666__$1,(31),inst_132627);
} else {
if((state_val_132667 === (25))){
var inst_132598 = (state_132666[(7)]);
var state_132666__$1 = state_132666;
var statearr_132697_132759 = state_132666__$1;
(statearr_132697_132759[(2)] = inst_132598);

(statearr_132697_132759[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (34))){
var inst_132600 = (state_132666[(15)]);
var inst_132640 = (state_132666[(2)]);
var state_132666__$1 = (function (){var statearr_132698 = state_132666;
(statearr_132698[(16)] = inst_132640);

return statearr_132698;
})();
if(cljs.core.truth_(inst_132600)){
var statearr_132699_132760 = state_132666__$1;
(statearr_132699_132760[(1)] = (35));

} else {
var statearr_132700_132761 = state_132666__$1;
(statearr_132700_132761[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (17))){
var inst_132605 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
if(cljs.core.truth_(inst_132605)){
var statearr_132701_132762 = state_132666__$1;
(statearr_132701_132762[(1)] = (18));

} else {
var statearr_132702_132763 = state_132666__$1;
(statearr_132702_132763[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (3))){
var inst_132566 = (state_132666[(2)]);
var inst_132567 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_132566);
var inst_132568 = cljs.core.async.close_BANG_(pc);
var state_132666__$1 = (function (){var statearr_132703 = state_132666;
(statearr_132703[(17)] = inst_132567);

return statearr_132703;
})();
var statearr_132704_132764 = state_132666__$1;
(statearr_132704_132764[(2)] = inst_132568);


cljs.core.async.impl.ioc_helpers.process_exception(state_132666__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (12))){
var inst_132594 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_132666__$1 = state_132666;
var statearr_132705_132765 = state_132666__$1;
(statearr_132705_132765[(2)] = inst_132594);

(statearr_132705_132765[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (2))){
var inst_132664 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132666__$1,inst_132664);
} else {
if((state_val_132667 === (23))){
var inst_132599 = (state_132666[(10)]);
var inst_132613 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_132599)," unknown."].join('');
var inst_132614 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_132615 = [(401),cljs.core.cst$kw$db_SLASH_invalid_DASH_auth];
var inst_132616 = cljs.core.PersistentHashMap.fromArrays(inst_132614,inst_132615);
var inst_132617 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_132613,inst_132616);
var inst_132618 = (function(){throw inst_132617})();
var state_132666__$1 = state_132666;
var statearr_132706_132766 = state_132666__$1;
(statearr_132706_132766[(2)] = inst_132618);

(statearr_132706_132766[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (35))){
var inst_132600 = (state_132666[(15)]);
var inst_132576 = (state_132666[(13)]);
var inst_132642 = fluree.db.time_travel.as_of_block(inst_132576,inst_132600);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132666__$1,(38),inst_132642);
} else {
if((state_val_132667 === (19))){
var state_132666__$1 = state_132666;
var statearr_132707_132767 = state_132666__$1;
(statearr_132707_132767[(2)] = null);

(statearr_132707_132767[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (11))){
var inst_132589 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
var statearr_132708_132768 = state_132666__$1;
(statearr_132708_132768[(2)] = inst_132589);

(statearr_132708_132768[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (9))){
var state_132666__$1 = state_132666;
var statearr_132709_132769 = state_132666__$1;
(statearr_132709_132769[(2)] = true);

(statearr_132709_132769[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (5))){
var inst_132575 = (state_132666[(2)]);
var inst_132576 = fluree.db.util.async.throw_err(inst_132575);
var inst_132578 = (opts == null);
var inst_132579 = cljs.core.not(inst_132578);
var state_132666__$1 = (function (){var statearr_132710 = state_132666;
(statearr_132710[(13)] = inst_132576);

return statearr_132710;
})();
if(inst_132579){
var statearr_132711_132770 = state_132666__$1;
(statearr_132711_132770[(1)] = (6));

} else {
var statearr_132712_132771 = state_132666__$1;
(statearr_132712_132771[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (14))){
var inst_132599 = (state_132666[(10)]);
var inst_132597 = (state_132666[(2)]);
var inst_132598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_132597,cljs.core.cst$kw$roles);
var inst_132599__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_132597,cljs.core.cst$kw$auth);
var inst_132600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_132597,cljs.core.cst$kw$block);
var state_132666__$1 = (function (){var statearr_132713 = state_132666;
(statearr_132713[(10)] = inst_132599__$1);

(statearr_132713[(7)] = inst_132598);

(statearr_132713[(15)] = inst_132600);

return statearr_132713;
})();
if(cljs.core.truth_(inst_132599__$1)){
var statearr_132714_132772 = state_132666__$1;
(statearr_132714_132772[(1)] = (15));

} else {
var statearr_132715_132773 = state_132666__$1;
(statearr_132715_132773[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (45))){
var inst_132653 = (state_132666[(14)]);
var inst_132656 = (state_132666[(2)]);
var inst_132657 = fluree.db.util.async.throw_err(inst_132656);
var inst_132658 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_132653,cljs.core.cst$kw$permissions,inst_132657);
var state_132666__$1 = state_132666;
var statearr_132716_132774 = state_132666__$1;
(statearr_132716_132774[(2)] = inst_132658);

(statearr_132716_132774[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (26))){
var inst_132623 = (state_132666[(8)]);
var state_132666__$1 = state_132666;
if(cljs.core.truth_(inst_132623)){
var statearr_132717_132775 = state_132666__$1;
(statearr_132717_132775[(1)] = (28));

} else {
var statearr_132718_132776 = state_132666__$1;
(statearr_132718_132776[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (16))){
var inst_132599 = (state_132666[(10)]);
var state_132666__$1 = state_132666;
var statearr_132719_132777 = state_132666__$1;
(statearr_132719_132777[(2)] = inst_132599);

(statearr_132719_132777[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (38))){
var inst_132644 = (state_132666[(2)]);
var inst_132645 = fluree.db.util.async.throw_err(inst_132644);
var state_132666__$1 = state_132666;
var statearr_132720_132778 = state_132666__$1;
(statearr_132720_132778[(2)] = inst_132645);

(statearr_132720_132778[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (30))){
var inst_132633 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
var statearr_132721_132779 = state_132666__$1;
(statearr_132721_132779[(2)] = inst_132633);

(statearr_132721_132779[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (10))){
var state_132666__$1 = state_132666;
var statearr_132722_132780 = state_132666__$1;
(statearr_132722_132780[(2)] = false);

(statearr_132722_132780[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (18))){
var inst_132599 = (state_132666[(10)]);
var inst_132576 = (state_132666[(13)]);
var inst_132607 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_132576,inst_132599);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132666__$1,(21),inst_132607);
} else {
if((state_val_132667 === (42))){
var inst_132640 = (state_132666[(16)]);
var state_132666__$1 = state_132666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132666__$1,(45),inst_132640);
} else {
if((state_val_132667 === (37))){
var inst_132599 = (state_132666[(10)]);
var inst_132648 = (state_132666[(2)]);
var state_132666__$1 = (function (){var statearr_132723 = state_132666;
(statearr_132723[(11)] = inst_132648);

return statearr_132723;
})();
if(cljs.core.truth_(inst_132599)){
var statearr_132724_132781 = state_132666__$1;
(statearr_132724_132781[(1)] = (39));

} else {
var statearr_132725_132782 = state_132666__$1;
(statearr_132725_132782[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132667 === (8))){
var inst_132592 = (state_132666[(2)]);
var state_132666__$1 = state_132666;
if(cljs.core.truth_(inst_132592)){
var statearr_132726_132783 = state_132666__$1;
(statearr_132726_132783[(1)] = (12));

} else {
var statearr_132727_132784 = state_132666__$1;
(statearr_132727_132784[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___132733,pc))
;
return ((function (switch__109970__auto__,c__110077__auto___132733,pc){
return (function() {
var fluree$db$api$ledger$state_machine__109971__auto__ = null;
var fluree$db$api$ledger$state_machine__109971__auto____0 = (function (){
var statearr_132728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_132728[(0)] = fluree$db$api$ledger$state_machine__109971__auto__);

(statearr_132728[(1)] = (1));

return statearr_132728;
});
var fluree$db$api$ledger$state_machine__109971__auto____1 = (function (state_132666){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132666);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132729){if((e132729 instanceof Object)){
var ex__109974__auto__ = e132729;
var statearr_132730_132785 = state_132666;
(statearr_132730_132785[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132666);

return cljs.core.cst$kw$recur;
} else {
throw e132729;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132786 = state_132666;
state_132666 = G__132786;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__109971__auto__ = function(state_132666){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__109971__auto____1.call(this,state_132666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__109971__auto____0;
fluree$db$api$ledger$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__109971__auto____1;
return fluree$db$api$ledger$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___132733,pc))
})();
var state__110079__auto__ = (function (){var statearr_132731 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132731[(6)] = c__110077__auto___132733);

return statearr_132731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___132733,pc))
);


return pc;
}
});

fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3;

fluree.db.api.ledger.isolate_ledger_id = (function fluree$db$api$ledger$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
fluree.db.api.ledger.db_ident_QMARK_ = (function fluree$db$api$ledger$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.ledger.get_sources = (function fluree$db$api$ledger$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.keyword__GT_str(key))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}

var db_ident_QMARK_ = fluree.db.api.ledger.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.ledger.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$auth,auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
