// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(500)], 0)));
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4120__auto__ = typeof value === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4120__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,291,null,291,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",15,1,699,null,699,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,221,null,221,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",19,1,503,null,503,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,421,null,421,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + count of numbers in <="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",17,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,382,null,382,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + count of numbers in >"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",12,1,247,null,247,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,711,null,711,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,515,null,515,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,591,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,605,null,605,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",13,1,735,null,735,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",15,1,681,null,681,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,408,null,408,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + count of numbers in <="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,447,null,447,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"Count of numbers in min"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,772,null,772,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,179,null,179,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,550,null,550,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,368,null,368,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + count of objects in =="]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",14,1,644,null,644,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,434,null,434,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + count of numbers in max"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,578,null,578,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",20,1,487,null,487,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",13,1,323,323,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,540,null,540,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,527,null,527,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",14,1,304,null,304,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",12,1,785,null,785,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,261,null,261,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,395,null,395,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + count of numbers in <"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,563,null,563,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,747,null,747,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",16,1,340,340,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,354,354,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",19,1,669,null,669,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,205,null,205,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,59,null,59,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,618,null,618,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,192,null,192,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",10,1,631,null,631,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,460,null,460,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,1,279,null,279,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",11,1,723,null,723,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",14,1,304,null,304,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,234,null,234,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Users/bplatz/fluree/fluree.db/src/fluree/db/dbfunctions/fns.cljc",14,1,656,null,656,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__130691 = cljs.core.meta(f);
var map__130691__$1 = (((((!((map__130691 == null))))?(((((map__130691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__130691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__130691):map__130691);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__130691__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__130691__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4120__auto__ = (function (){var G__130696 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__130695 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__130695.cljs$core$IFn$_invoke$arity$1 ? fexpr__130695.cljs$core$IFn$_invoke$arity$1(G__130696) : fexpr__130695.call(null,G__130696));
})();
if(cljs.core.truth_(and__4120__auto__)){
var G__130698 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__130697 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__130697.cljs$core$IFn$_invoke$arity$1 ? fexpr__130697.cljs$core$IFn$_invoke$arity$1(G__130698) : fexpr__130697.call(null,G__130698));
} else {
return and__4120__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__130691,map__130691__$1,spec,arglists,arglist,_AMPERSAND_args_QMARK_){
return (function (p1__130690_SHARP_){
return (cljs.core.count(p1__130690_SHARP_) - (1));
});})(map__130691,map__130691__$1,spec,arglists,arglist,_AMPERSAND_args_QMARK_))
,arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__130700 = arguments.length;
switch (G__130700) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
});

fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3;

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll)),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__130704 = arguments.length;
switch (G__130704) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
});

fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_130823){
var state_val_130824 = (state_130823[(1)]);
if((state_val_130824 === (7))){
var inst_130721 = (state_130823[(7)]);
var state_130823__$1 = state_130823;
var statearr_130825_130889 = state_130823__$1;
(statearr_130825_130889[(2)] = inst_130721);

(statearr_130825_130889[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (20))){
var inst_130728 = (state_130823[(8)]);
var inst_130718 = (state_130823[(9)]);
var inst_130721 = (state_130823[(7)]);
var inst_130727 = (state_130823[(10)]);
var inst_130717 = (state_130823[(11)]);
var inst_130747 = (state_130823[(12)]);
var inst_130740 = (state_130823[(13)]);
var inst_130720 = (state_130823[(14)]);
var inst_130743 = [inst_130727];
var inst_130744 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_130743);
var inst_130745 = (function (){var x = inst_130727;
var r = inst_130728;
var first__130725 = inst_130727;
var acc = inst_130721;
var vec__130723 = inst_130720;
var seq__130724 = inst_130728;
var seq__130714 = inst_130718;
var first__130715 = inst_130717;
var G__130712 = inst_130720;
var vec__130713 = vec;
var or__4131__auto__ = inst_130740;
return ((function (x,r,first__130725,acc,vec__130723,seq__130724,seq__130714,first__130715,G__130712,vec__130713,or__4131__auto__,inst_130728,inst_130718,inst_130721,inst_130727,inst_130717,inst_130747,inst_130740,inst_130720,inst_130743,inst_130744,state_val_130824,c__110077__auto__){
return (function (p1__130702_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__130702_SHARP_);
});
;})(x,r,first__130725,acc,vec__130723,seq__130724,seq__130714,first__130715,G__130712,vec__130713,or__4131__auto__,inst_130728,inst_130718,inst_130721,inst_130727,inst_130717,inst_130747,inst_130740,inst_130720,inst_130743,inst_130744,state_val_130824,c__110077__auto__))
})();
var inst_130746 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_130745,params);
var inst_130747__$1 = cljs.core.some(inst_130744,inst_130746);
var state_130823__$1 = (function (){var statearr_130826 = state_130823;
(statearr_130826[(12)] = inst_130747__$1);

return statearr_130826;
})();
if(cljs.core.truth_(inst_130747__$1)){
var statearr_130827_130890 = state_130823__$1;
(statearr_130827_130890[(1)] = (22));

} else {
var statearr_130828_130891 = state_130823__$1;
(statearr_130828_130891[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (27))){
var inst_130761 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130829_130892 = state_130823__$1;
(statearr_130829_130892[(2)] = inst_130761);

(statearr_130829_130892[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (1))){
var state_130823__$1 = state_130823;
var statearr_130830_130893 = state_130823__$1;
(statearr_130830_130893[(2)] = null);

(statearr_130830_130893[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (24))){
var inst_130763 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130831_130894 = state_130823__$1;
(statearr_130831_130894[(2)] = inst_130763);

(statearr_130831_130894[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (39))){
var state_130823__$1 = state_130823;
var statearr_130832_130895 = state_130823__$1;
(statearr_130832_130895[(1)] = (42));



return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_130823,(3),Error,null,(2));
var inst_130716 = cljs.core.seq(vec);
var inst_130717 = cljs.core.first(inst_130716);
var inst_130718 = cljs.core.next(inst_130716);
var inst_130719 = cljs.core.PersistentVector.EMPTY;
var inst_130720 = vec;
var inst_130721 = inst_130719;
var state_130823__$1 = (function (){var statearr_130834 = state_130823;
(statearr_130834[(9)] = inst_130718);

(statearr_130834[(7)] = inst_130721);

(statearr_130834[(11)] = inst_130717);

(statearr_130834[(14)] = inst_130720);

return statearr_130834;
})();
var statearr_130835_130896 = state_130823__$1;
(statearr_130835_130896[(2)] = null);

(statearr_130835_130896[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (15))){
var inst_130811 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130836_130897 = state_130823__$1;
(statearr_130836_130897[(2)] = inst_130811);

(statearr_130836_130897[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (21))){
var inst_130765 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130837_130898 = state_130823__$1;
(statearr_130837_130898[(2)] = inst_130765);

(statearr_130837_130898[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (31))){
var inst_130727 = (state_130823[(10)]);
var inst_130775 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_130727,funType,params);
var state_130823__$1 = state_130823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130823__$1,(34),inst_130775);
} else {
if((state_val_130824 === (32))){
var inst_130727 = (state_130823[(10)]);
var inst_130780 = (inst_130727 == null);
var state_130823__$1 = state_130823;
if(cljs.core.truth_(inst_130780)){
var statearr_130838_130899 = state_130823__$1;
(statearr_130838_130899[(1)] = (35));

} else {
var statearr_130839_130900 = state_130823__$1;
(statearr_130839_130900[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (40))){
var inst_130801 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130840_130901 = state_130823__$1;
(statearr_130840_130901[(2)] = inst_130801);

(statearr_130840_130901[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (33))){
var inst_130805 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130841_130902 = state_130823__$1;
(statearr_130841_130902[(2)] = inst_130805);

(statearr_130841_130902[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (13))){
var inst_130727 = (state_130823[(10)]);
var state_130823__$1 = state_130823;
var statearr_130842_130903 = state_130823__$1;
(statearr_130842_130903[(2)] = inst_130727);

(statearr_130842_130903[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (22))){
var inst_130747 = (state_130823[(12)]);
var state_130823__$1 = state_130823;
var statearr_130843_130904 = state_130823__$1;
(statearr_130843_130904[(2)] = inst_130747);

(statearr_130843_130904[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (36))){
var inst_130727 = (state_130823[(10)]);
var inst_130783 = cljs.core.list_QMARK_(inst_130727);
var state_130823__$1 = state_130823;
if(inst_130783){
var statearr_130844_130905 = state_130823__$1;
(statearr_130844_130905[(1)] = (38));

} else {
var statearr_130845_130906 = state_130823__$1;
(statearr_130845_130906[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (41))){
var inst_130787 = (state_130823[(2)]);
var inst_130788 = fluree.db.util.async.throw_err(inst_130787);
var state_130823__$1 = state_130823;
var statearr_130846_130907 = state_130823__$1;
(statearr_130846_130907[(2)] = inst_130788);

(statearr_130846_130907[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (43))){
var state_130823__$1 = state_130823;
var statearr_130847_130908 = state_130823__$1;
(statearr_130847_130908[(2)] = null);

(statearr_130847_130908[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (29))){
var inst_130727 = (state_130823[(10)]);
var inst_130773 = cljs.core.vector_QMARK_(inst_130727);
var state_130823__$1 = state_130823;
if(inst_130773){
var statearr_130848_130909 = state_130823__$1;
(statearr_130848_130909[(1)] = (31));

} else {
var statearr_130849_130910 = state_130823__$1;
(statearr_130849_130910[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (44))){
var inst_130799 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130850_130911 = state_130823__$1;
(statearr_130850_130911[(2)] = inst_130799);

(statearr_130850_130911[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (6))){
var inst_130819 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130851_130912 = state_130823__$1;
(statearr_130851_130912[(2)] = inst_130819);


cljs.core.async.impl.ioc_helpers.process_exception(state_130823__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (28))){
var inst_130727 = (state_130823[(10)]);
var state_130823__$1 = state_130823;
var statearr_130852_130913 = state_130823__$1;
(statearr_130852_130913[(2)] = inst_130727);

(statearr_130852_130913[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (25))){
var inst_130750 = (state_130823[(15)]);
var state_130823__$1 = state_130823;
var statearr_130853_130914 = state_130823__$1;
(statearr_130853_130914[(2)] = inst_130750);

(statearr_130853_130914[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (34))){
var inst_130777 = (state_130823[(2)]);
var inst_130778 = fluree.db.util.async.throw_err(inst_130777);
var state_130823__$1 = state_130823;
var statearr_130854_130915 = state_130823__$1;
(statearr_130854_130915[(2)] = inst_130778);

(statearr_130854_130915[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (17))){
var inst_130727 = (state_130823[(10)]);
var inst_130767 = inst_130727 === true;
var inst_130768 = inst_130727 === false;
var inst_130769 = (inst_130727 == null);
var inst_130770 = ((inst_130767) || (inst_130768) || (inst_130769));
var state_130823__$1 = state_130823;
if(cljs.core.truth_(inst_130770)){
var statearr_130855_130916 = state_130823__$1;
(statearr_130855_130916[(1)] = (28));

} else {
var statearr_130856_130917 = state_130823__$1;
(statearr_130856_130917[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (3))){
var inst_130705 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130857_130918 = state_130823__$1;
(statearr_130857_130918[(2)] = inst_130705);


cljs.core.async.impl.ioc_helpers.process_exception(state_130823__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (12))){
var inst_130728 = (state_130823[(8)]);
var inst_130721 = (state_130823[(7)]);
var inst_130813 = (state_130823[(2)]);
var inst_130814 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_130721,inst_130813);
var inst_130720 = inst_130728;
var inst_130721__$1 = inst_130814;
var state_130823__$1 = (function (){var statearr_130858 = state_130823;
(statearr_130858[(7)] = inst_130721__$1);

(statearr_130858[(14)] = inst_130720);

return statearr_130858;
})();
var statearr_130859_130919 = state_130823__$1;
(statearr_130859_130919[(2)] = null);

(statearr_130859_130919[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (2))){
var inst_130821 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_130823__$1,inst_130821);
} else {
if((state_val_130824 === (23))){
var inst_130750 = (state_130823[(15)]);
var inst_130750__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_130823__$1 = (function (){var statearr_130860 = state_130823;
(statearr_130860[(15)] = inst_130750__$1);

return statearr_130860;
})();
if(inst_130750__$1){
var statearr_130861_130920 = state_130823__$1;
(statearr_130861_130920[(1)] = (25));

} else {
var statearr_130862_130921 = state_130823__$1;
(statearr_130862_130921[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (35))){
var inst_130727 = (state_130823[(10)]);
var state_130823__$1 = state_130823;
var statearr_130863_130922 = state_130823__$1;
(statearr_130863_130922[(2)] = inst_130727);

(statearr_130863_130922[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (19))){
var inst_130740 = (state_130823[(13)]);
var state_130823__$1 = state_130823;
var statearr_130864_130923 = state_130823__$1;
(statearr_130864_130923[(2)] = inst_130740);

(statearr_130864_130923[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (11))){
var inst_130727 = (state_130823[(10)]);
var inst_130735 = typeof inst_130727 === 'number';
var state_130823__$1 = state_130823;
if(cljs.core.truth_(inst_130735)){
var statearr_130865_130924 = state_130823__$1;
(statearr_130865_130924[(1)] = (13));

} else {
var statearr_130866_130925 = state_130823__$1;
(statearr_130866_130925[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (9))){
var inst_130817 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130867_130926 = state_130823__$1;
(statearr_130867_130926[(2)] = inst_130817);

(statearr_130867_130926[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (5))){
var inst_130727 = (state_130823[(10)]);
var inst_130720 = (state_130823[(14)]);
var inst_130726 = cljs.core.seq(inst_130720);
var inst_130727__$1 = cljs.core.first(inst_130726);
var inst_130728 = cljs.core.next(inst_130726);
var inst_130729 = (inst_130727__$1 == null);
var state_130823__$1 = (function (){var statearr_130868 = state_130823;
(statearr_130868[(8)] = inst_130728);

(statearr_130868[(10)] = inst_130727__$1);

return statearr_130868;
})();
if(cljs.core.truth_(inst_130729)){
var statearr_130869_130927 = state_130823__$1;
(statearr_130869_130927[(1)] = (7));

} else {
var statearr_130870_130928 = state_130823__$1;
(statearr_130870_130928[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (14))){
var inst_130727 = (state_130823[(10)]);
var inst_130738 = (inst_130727 instanceof cljs.core.Symbol);
var state_130823__$1 = state_130823;
if(cljs.core.truth_(inst_130738)){
var statearr_130871_130929 = state_130823__$1;
(statearr_130871_130929[(1)] = (16));

} else {
var statearr_130872_130930 = state_130823__$1;
(statearr_130872_130930[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (26))){
var inst_130727 = (state_130823[(10)]);
var inst_130753 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_130754 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130727)," used in function.",inst_130753].join('');
var inst_130755 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_130756 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_130757 = cljs.core.PersistentHashMap.fromArrays(inst_130755,inst_130756);
var inst_130758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_130754,inst_130757);
var inst_130759 = (function(){throw inst_130758})();
var state_130823__$1 = state_130823;
var statearr_130873_130931 = state_130823__$1;
(statearr_130873_130931[(2)] = inst_130759);

(statearr_130873_130931[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (16))){
var inst_130727 = (state_130823[(10)]);
var inst_130740 = (state_130823[(13)]);
var inst_130740__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_130727) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_130727));
var state_130823__$1 = (function (){var statearr_130874 = state_130823;
(statearr_130874[(13)] = inst_130740__$1);

return statearr_130874;
})();
if(cljs.core.truth_(inst_130740__$1)){
var statearr_130875_130932 = state_130823__$1;
(statearr_130875_130932[(1)] = (19));

} else {
var statearr_130876_130933 = state_130823__$1;
(statearr_130876_130933[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (38))){
var inst_130727 = (state_130823[(10)]);
var inst_130785 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_130727,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_130727,funType,params));
var state_130823__$1 = state_130823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_130823__$1,(41),inst_130785);
} else {
if((state_val_130824 === (30))){
var inst_130807 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130877_130934 = state_130823__$1;
(statearr_130877_130934[(2)] = inst_130807);

(statearr_130877_130934[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (10))){
var inst_130727 = (state_130823[(10)]);
var state_130823__$1 = state_130823;
var statearr_130878_130935 = state_130823__$1;
(statearr_130878_130935[(2)] = inst_130727);

(statearr_130878_130935[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (18))){
var inst_130809 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130879_130936 = state_130823__$1;
(statearr_130879_130936[(2)] = inst_130809);

(statearr_130879_130936[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (42))){
var inst_130727 = (state_130823[(10)]);
var inst_130791 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_130727], 0));
var inst_130792 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_130793 = ["Illegal element (",inst_130791,") in vector: ",inst_130792,"."].join('');
var inst_130794 = cljs.core.PersistentHashMap.EMPTY;
var inst_130795 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_130793,inst_130794);
var inst_130796 = (function(){throw inst_130795})();
var state_130823__$1 = state_130823;
var statearr_130880_130937 = state_130823__$1;
(statearr_130880_130937[(2)] = inst_130796);

(statearr_130880_130937[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (37))){
var inst_130803 = (state_130823[(2)]);
var state_130823__$1 = state_130823;
var statearr_130881_130938 = state_130823__$1;
(statearr_130881_130938[(2)] = inst_130803);

(statearr_130881_130938[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_130824 === (8))){
var inst_130727 = (state_130823[(10)]);
var inst_130732 = typeof inst_130727 === 'string';
var state_130823__$1 = state_130823;
if(cljs.core.truth_(inst_130732)){
var statearr_130882_130939 = state_130823__$1;
(statearr_130882_130939[(1)] = (10));

} else {
var statearr_130883_130940 = state_130823__$1;
(statearr_130883_130940[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__109971__auto____0 = (function (){
var statearr_130884 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_130884[(0)] = fluree$db$dbfunctions$core$state_machine__109971__auto__);

(statearr_130884[(1)] = (1));

return statearr_130884;
});
var fluree$db$dbfunctions$core$state_machine__109971__auto____1 = (function (state_130823){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_130823);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e130885){if((e130885 instanceof Object)){
var ex__109974__auto__ = e130885;
var statearr_130886_130941 = state_130823;
(statearr_130886_130941[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_130823);

return cljs.core.cst$kw$recur;
} else {
throw e130885;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__130942 = state_130823;
state_130823 = G__130942;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__109971__auto__ = function(state_130823){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__109971__auto____1.call(this,state_130823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__109971__auto____0;
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__109971__auto____1;
return fluree$db$dbfunctions$core$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_130887 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_130887[(6)] = c__110077__auto__);

return statearr_130887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4;

/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__130945 = arguments.length;
switch (G__130945) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
});

fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_131119){
var state_val_131120 = (state_131119[(1)]);
if((state_val_131120 === (62))){
var state_131119__$1 = state_131119;
var statearr_131121_131212 = state_131119__$1;
(statearr_131121_131212[(2)] = null);

(statearr_131121_131212[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (7))){
var state_131119__$1 = state_131119;
var statearr_131122_131213 = state_131119__$1;
(statearr_131122_131213[(2)] = false);

(statearr_131122_131213[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (59))){
var state_131119__$1 = state_131119;
var statearr_131123_131214 = state_131119__$1;
(statearr_131123_131214[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (20))){
var inst_130952 = (state_131119[(7)]);
var inst_130996 = (state_131119[(2)]);
var inst_131004 = cljs.core.seq(inst_130952);
var inst_131005 = cljs.core.first(inst_131004);
var inst_131006 = cljs.core.next(inst_131004);
var inst_131007 = cljs.core.PersistentVector.EMPTY;
var inst_131008 = inst_130952;
var inst_131009 = inst_131007;
var state_131119__$1 = (function (){var statearr_131125 = state_131119;
(statearr_131125[(8)] = inst_131009);

(statearr_131125[(9)] = inst_130996);

(statearr_131125[(10)] = inst_131005);

(statearr_131125[(11)] = inst_131008);

(statearr_131125[(12)] = inst_131006);

return statearr_131125;
})();
var statearr_131126_131215 = state_131119__$1;
(statearr_131126_131215[(2)] = null);

(statearr_131126_131215[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (58))){
var inst_131015 = (state_131119[(13)]);
var state_131119__$1 = state_131119;
var statearr_131127_131216 = state_131119__$1;
(statearr_131127_131216[(2)] = inst_131015);

(statearr_131127_131216[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (60))){
var inst_131093 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131128_131217 = state_131119__$1;
(statearr_131128_131217[(2)] = inst_131093);

(statearr_131128_131217[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (27))){
var inst_131009 = (state_131119[(8)]);
var state_131119__$1 = state_131119;
var statearr_131129_131218 = state_131119__$1;
(statearr_131129_131218[(2)] = inst_131009);

(statearr_131129_131218[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (1))){
var state_131119__$1 = state_131119;
var statearr_131130_131219 = state_131119__$1;
(statearr_131130_131219[(2)] = null);

(statearr_131130_131219[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (24))){
var inst_131015 = (state_131119[(13)]);
var inst_131019 = inst_131015 === false;
var state_131119__$1 = state_131119;
var statearr_131131_131220 = state_131119__$1;
(statearr_131131_131220[(2)] = inst_131019);

(statearr_131131_131220[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (55))){
var inst_131015 = (state_131119[(13)]);
var inst_131078 = (inst_131015 == null);
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131078)){
var statearr_131132_131221 = state_131119__$1;
(statearr_131132_131221[(1)] = (58));

} else {
var statearr_131133_131222 = state_131119__$1;
(statearr_131133_131222[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (39))){
var inst_131038 = (state_131119[(14)]);
var inst_131015 = (state_131119[(13)]);
var inst_131038__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_131015) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_131015));
var state_131119__$1 = (function (){var statearr_131134 = state_131119;
(statearr_131134[(14)] = inst_131038__$1);

return statearr_131134;
})();
if(cljs.core.truth_(inst_131038__$1)){
var statearr_131135_131223 = state_131119__$1;
(statearr_131135_131223[(1)] = (42));

} else {
var statearr_131136_131224 = state_131119__$1;
(statearr_131136_131224[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (46))){
var inst_131048 = (state_131119[(15)]);
var inst_131048__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_131119__$1 = (function (){var statearr_131137 = state_131119;
(statearr_131137[(15)] = inst_131048__$1);

return statearr_131137;
})();
if(inst_131048__$1){
var statearr_131138_131225 = state_131119__$1;
(statearr_131138_131225[(1)] = (48));

} else {
var statearr_131139_131226 = state_131119__$1;
(statearr_131139_131226[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (4))){
var inst_130952 = (state_131119[(7)]);
var inst_130951 = (state_131119[(16)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131119,(3),Error,null,(2));
var inst_130951__$1 = cljs.core.first(form);
var inst_130952__$1 = cljs.core.rest(form);
var inst_130953 = cljs.core.count(inst_130952__$1);
var inst_130954 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_130951__$1,type);
var state_131119__$1 = (function (){var statearr_131140 = state_131119;
(statearr_131140[(17)] = inst_130953);

(statearr_131140[(7)] = inst_130952__$1);

(statearr_131140[(16)] = inst_130951__$1);

return statearr_131140;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131119__$1,(5),inst_130954);
} else {
if((state_val_131120 === (54))){
var inst_131015 = (state_131119[(13)]);
var inst_131073 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_131015,type,params);
var state_131119__$1 = state_131119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131119__$1,(57),inst_131073);
} else {
if((state_val_131120 === (15))){
var inst_130982 = (state_131119[(18)]);
var state_131119__$1 = state_131119;
var statearr_131141_131227 = state_131119__$1;
(statearr_131141_131227[(2)] = inst_130982);

(statearr_131141_131227[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (48))){
var inst_131048 = (state_131119[(15)]);
var state_131119__$1 = state_131119;
var statearr_131142_131228 = state_131119__$1;
(statearr_131142_131228[(2)] = inst_131048);

(statearr_131142_131228[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (50))){
var inst_131059 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131143_131229 = state_131119__$1;
(statearr_131143_131229[(2)] = inst_131059);

(statearr_131143_131229[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (21))){
var inst_131008 = (state_131119[(11)]);
var inst_131015 = (state_131119[(13)]);
var inst_131014 = cljs.core.seq(inst_131008);
var inst_131015__$1 = cljs.core.first(inst_131014);
var inst_131016 = cljs.core.next(inst_131014);
var state_131119__$1 = (function (){var statearr_131144 = state_131119;
(statearr_131144[(19)] = inst_131016);

(statearr_131144[(13)] = inst_131015__$1);

return statearr_131144;
})();
if(cljs.core.truth_(inst_131015__$1)){
var statearr_131145_131230 = state_131119__$1;
(statearr_131145_131230[(1)] = (23));

} else {
var statearr_131146_131231 = state_131119__$1;
(statearr_131146_131231[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (31))){
var inst_131009 = (state_131119[(8)]);
var inst_131016 = (state_131119[(19)]);
var inst_131105 = (state_131119[(2)]);
var inst_131106 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_131009,inst_131105);
var inst_131008 = inst_131016;
var inst_131009__$1 = inst_131106;
var state_131119__$1 = (function (){var statearr_131147 = state_131119;
(statearr_131147[(8)] = inst_131009__$1);

(statearr_131147[(11)] = inst_131008);

return statearr_131147;
})();
var statearr_131148_131232 = state_131119__$1;
(statearr_131148_131232[(2)] = null);

(statearr_131148_131232[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (32))){
var inst_131027 = (state_131119[(2)]);
var inst_131028 = fluree.db.util.async.throw_err(inst_131027);
var state_131119__$1 = state_131119;
var statearr_131149_131233 = state_131119__$1;
(statearr_131149_131233[(2)] = inst_131028);

(statearr_131149_131233[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (40))){
var inst_131015 = (state_131119[(13)]);
var inst_131065 = inst_131015 === true;
var inst_131066 = inst_131015 === false;
var inst_131067 = (inst_131015 == null);
var inst_131068 = ((inst_131065) || (inst_131066) || (inst_131067));
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131068)){
var statearr_131150_131234 = state_131119__$1;
(statearr_131150_131234[(1)] = (51));

} else {
var statearr_131151_131235 = state_131119__$1;
(statearr_131151_131235[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (56))){
var inst_131095 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131152_131236 = state_131119__$1;
(statearr_131152_131236[(2)] = inst_131095);

(statearr_131152_131236[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (33))){
var inst_131015 = (state_131119[(13)]);
var state_131119__$1 = state_131119;
var statearr_131153_131237 = state_131119__$1;
(statearr_131153_131237[(2)] = inst_131015);

(statearr_131153_131237[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (13))){
var inst_130957 = (state_131119[(20)]);
var state_131119__$1 = state_131119;
var statearr_131154_131238 = state_131119__$1;
(statearr_131154_131238[(2)] = inst_130957);

(statearr_131154_131238[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (22))){
var inst_130979 = (state_131119[(21)]);
var inst_131112 = (state_131119[(2)]);
var inst_131113 = cljs.core.cst$sym$_QMARK_ctx;
var inst_131114 = cljs.core.cons(inst_131113,inst_131112);
var inst_131115 = cljs.core.cons(inst_130979,inst_131114);
var state_131119__$1 = state_131119;
var statearr_131155_131239 = state_131119__$1;
(statearr_131155_131239[(2)] = inst_131115);


cljs.core.async.impl.ioc_helpers.process_exception(state_131119__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (36))){
var inst_131015 = (state_131119[(13)]);
var state_131119__$1 = state_131119;
var statearr_131156_131240 = state_131119__$1;
(statearr_131156_131240[(2)] = inst_131015);

(statearr_131156_131240[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (41))){
var inst_131099 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131157_131241 = state_131119__$1;
(statearr_131157_131241[(2)] = inst_131099);

(statearr_131157_131241[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (43))){
var inst_131009 = (state_131119[(8)]);
var inst_131016 = (state_131119[(19)]);
var inst_131038 = (state_131119[(14)]);
var inst_130996 = (state_131119[(9)]);
var inst_130953 = (state_131119[(17)]);
var inst_130957 = (state_131119[(20)]);
var inst_130978 = (state_131119[(22)]);
var inst_130952 = (state_131119[(7)]);
var inst_130981 = (state_131119[(23)]);
var inst_130951 = (state_131119[(16)]);
var inst_131005 = (state_131119[(10)]);
var inst_130982 = (state_131119[(18)]);
var inst_131045 = (state_131119[(24)]);
var inst_130979 = (state_131119[(21)]);
var inst_131008 = (state_131119[(11)]);
var inst_131006 = (state_131119[(12)]);
var inst_130980 = (state_131119[(25)]);
var inst_131015 = (state_131119[(13)]);
var inst_131041 = [inst_131015];
var inst_131042 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_131041);
var inst_131043 = (function (){var arity = inst_130980;
var args_n = inst_130953;
var fn_map = inst_130957;
var first__131003 = inst_131005;
var seq__131012 = inst_131016;
var first__131013 = inst_131015;
var vec__131011 = inst_131008;
var args = inst_130952;
var map__130950 = inst_130978;
var r = inst_131016;
var _ = inst_130996;
var seq__131002 = inst_131006;
var acc = inst_131009;
var vec__131001 = inst_130952;
var arglist = inst_130981;
var fn_name = inst_130951;
var _AMPERSAND_args_QMARK_ = inst_130982;
var arg = inst_131015;
var or__4131__auto__ = inst_131038;
var G__131000 = inst_131008;
var f = inst_130979;
return ((function (arity,args_n,fn_map,first__131003,seq__131012,first__131013,vec__131011,args,map__130950,r,_,seq__131002,acc,vec__131001,arglist,fn_name,_AMPERSAND_args_QMARK_,arg,or__4131__auto__,G__131000,f,inst_131009,inst_131016,inst_131038,inst_130996,inst_130953,inst_130957,inst_130978,inst_130952,inst_130981,inst_130951,inst_131005,inst_130982,inst_131045,inst_130979,inst_131008,inst_131006,inst_130980,inst_131015,inst_131041,inst_131042,state_val_131120,c__110077__auto__){
return (function (p1__130943_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__130943_SHARP_);
});
;})(arity,args_n,fn_map,first__131003,seq__131012,first__131013,vec__131011,args,map__130950,r,_,seq__131002,acc,vec__131001,arglist,fn_name,_AMPERSAND_args_QMARK_,arg,or__4131__auto__,G__131000,f,inst_131009,inst_131016,inst_131038,inst_130996,inst_130953,inst_130957,inst_130978,inst_130952,inst_130981,inst_130951,inst_131005,inst_130982,inst_131045,inst_130979,inst_131008,inst_131006,inst_130980,inst_131015,inst_131041,inst_131042,state_val_131120,c__110077__auto__))
})();
var inst_131044 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_131043,params);
var inst_131045__$1 = cljs.core.some(inst_131042,inst_131044);
var state_131119__$1 = (function (){var statearr_131158 = state_131119;
(statearr_131158[(24)] = inst_131045__$1);

return statearr_131158;
})();
if(cljs.core.truth_(inst_131045__$1)){
var statearr_131159_131242 = state_131119__$1;
(statearr_131159_131242[(1)] = (45));

} else {
var statearr_131160_131243 = state_131119__$1;
(statearr_131160_131243[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (61))){
var inst_131015 = (state_131119[(13)]);
var inst_131082 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_131015], 0));
var inst_131083 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_131015) : type.call(null,inst_131015));
var inst_131084 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_131085 = ["Illegal element (",inst_131082,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_131083),") in function argument: ",inst_131084,"."].join('');
var inst_131086 = cljs.core.PersistentHashMap.EMPTY;
var inst_131087 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_131085,inst_131086);
var inst_131088 = (function(){throw inst_131087})();
var state_131119__$1 = state_131119;
var statearr_131161_131244 = state_131119__$1;
(statearr_131161_131244[(2)] = inst_131088);

(statearr_131161_131244[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (29))){
var inst_131015 = (state_131119[(13)]);
var inst_131025 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_131015,type,params);
var state_131119__$1 = state_131119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131119__$1,(32),inst_131025);
} else {
if((state_val_131120 === (44))){
var inst_131063 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131162_131245 = state_131119__$1;
(statearr_131162_131245[(2)] = inst_131063);

(statearr_131162_131245[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (6))){
var inst_130957 = (state_131119[(20)]);
var inst_130962 = inst_130957.cljs$lang$protocol_mask$partition0$;
var inst_130963 = (inst_130962 & (64));
var inst_130964 = inst_130957.cljs$core$ISeq$;
var inst_130965 = (cljs.core.PROTOCOL_SENTINEL === inst_130964);
var inst_130966 = ((inst_130963) || (inst_130965));
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_130966)){
var statearr_131163_131246 = state_131119__$1;
(statearr_131163_131246[(1)] = (9));

} else {
var statearr_131164_131247 = state_131119__$1;
(statearr_131164_131247[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (28))){
var inst_131110 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131165_131248 = state_131119__$1;
(statearr_131165_131248[(2)] = inst_131110);

(statearr_131165_131248[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (51))){
var inst_131015 = (state_131119[(13)]);
var state_131119__$1 = state_131119;
var statearr_131166_131249 = state_131119__$1;
(statearr_131166_131249[(2)] = inst_131015);

(statearr_131166_131249[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (25))){
var inst_131021 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131021)){
var statearr_131167_131250 = state_131119__$1;
(statearr_131167_131250[(1)] = (26));

} else {
var statearr_131168_131251 = state_131119__$1;
(statearr_131168_131251[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (34))){
var inst_131015 = (state_131119[(13)]);
var inst_131033 = typeof inst_131015 === 'number';
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131033)){
var statearr_131169_131252 = state_131119__$1;
(statearr_131169_131252[(1)] = (36));

} else {
var statearr_131170_131253 = state_131119__$1;
(statearr_131170_131253[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (17))){
var inst_130987 = (state_131119[(2)]);
var inst_130988 = cljs.core.not(inst_130987);
var state_131119__$1 = state_131119;
if(inst_130988){
var statearr_131171_131254 = state_131119__$1;
(statearr_131171_131254[(1)] = (18));

} else {
var statearr_131172_131255 = state_131119__$1;
(statearr_131172_131255[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (3))){
var inst_130946 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131173_131256 = state_131119__$1;
(statearr_131173_131256[(2)] = inst_130946);


cljs.core.async.impl.ioc_helpers.process_exception(state_131119__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (12))){
var inst_130957 = (state_131119[(20)]);
var inst_130975 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_130957);
var state_131119__$1 = state_131119;
var statearr_131174_131257 = state_131119__$1;
(statearr_131174_131257[(2)] = inst_130975);

(statearr_131174_131257[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (2))){
var inst_131117 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_131119__$1,inst_131117);
} else {
if((state_val_131120 === (23))){
var inst_131015 = (state_131119[(13)]);
var state_131119__$1 = state_131119;
var statearr_131175_131258 = state_131119__$1;
(statearr_131175_131258[(2)] = inst_131015);

(statearr_131175_131258[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (47))){
var inst_131061 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131176_131259 = state_131119__$1;
(statearr_131176_131259[(2)] = inst_131061);

(statearr_131176_131259[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (35))){
var inst_131103 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131177_131260 = state_131119__$1;
(statearr_131177_131260[(2)] = inst_131103);

(statearr_131177_131260[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (19))){
var state_131119__$1 = state_131119;
var statearr_131178_131261 = state_131119__$1;
(statearr_131178_131261[(2)] = null);

(statearr_131178_131261[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (57))){
var inst_131075 = (state_131119[(2)]);
var inst_131076 = fluree.db.util.async.throw_err(inst_131075);
var state_131119__$1 = state_131119;
var statearr_131179_131262 = state_131119__$1;
(statearr_131179_131262[(2)] = inst_131076);

(statearr_131179_131262[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (11))){
var inst_130970 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131180_131263 = state_131119__$1;
(statearr_131180_131263[(2)] = inst_130970);

(statearr_131180_131263[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (9))){
var state_131119__$1 = state_131119;
var statearr_131181_131264 = state_131119__$1;
(statearr_131181_131264[(2)] = true);

(statearr_131181_131264[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (5))){
var inst_130957 = (state_131119[(20)]);
var inst_130956 = (state_131119[(2)]);
var inst_130957__$1 = fluree.db.util.async.throw_err(inst_130956);
var inst_130959 = (inst_130957__$1 == null);
var inst_130960 = cljs.core.not(inst_130959);
var state_131119__$1 = (function (){var statearr_131182 = state_131119;
(statearr_131182[(20)] = inst_130957__$1);

return statearr_131182;
})();
if(inst_130960){
var statearr_131183_131265 = state_131119__$1;
(statearr_131183_131265[(1)] = (6));

} else {
var statearr_131184_131266 = state_131119__$1;
(statearr_131184_131266[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (14))){
var inst_130978 = (state_131119[(22)]);
var inst_130982 = (state_131119[(18)]);
var inst_130978__$1 = (state_131119[(2)]);
var inst_130979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_130978__$1,cljs.core.cst$kw$f);
var inst_130980 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_130978__$1,cljs.core.cst$kw$arity);
var inst_130981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_130978__$1,cljs.core.cst$kw$arglist);
var inst_130982__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_130978__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_131119__$1 = (function (){var statearr_131185 = state_131119;
(statearr_131185[(22)] = inst_130978__$1);

(statearr_131185[(23)] = inst_130981);

(statearr_131185[(18)] = inst_130982__$1);

(statearr_131185[(21)] = inst_130979);

(statearr_131185[(25)] = inst_130980);

return statearr_131185;
})();
if(cljs.core.truth_(inst_130982__$1)){
var statearr_131186_131267 = state_131119__$1;
(statearr_131186_131267[(1)] = (15));

} else {
var statearr_131187_131268 = state_131119__$1;
(statearr_131187_131268[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (45))){
var inst_131045 = (state_131119[(24)]);
var state_131119__$1 = state_131119;
var statearr_131188_131269 = state_131119__$1;
(statearr_131188_131269[(2)] = inst_131045);

(statearr_131188_131269[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (53))){
var inst_131097 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131189_131270 = state_131119__$1;
(statearr_131189_131270[(2)] = inst_131097);

(statearr_131189_131270[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (26))){
var inst_131015 = (state_131119[(13)]);
var inst_131023 = cljs.core.list_QMARK_(inst_131015);
var state_131119__$1 = state_131119;
if(inst_131023){
var statearr_131190_131271 = state_131119__$1;
(statearr_131190_131271[(1)] = (29));

} else {
var statearr_131191_131272 = state_131119__$1;
(statearr_131191_131272[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (16))){
var inst_130953 = (state_131119[(17)]);
var inst_130980 = (state_131119[(25)]);
var inst_130985 = (inst_130980.cljs$core$IFn$_invoke$arity$1 ? inst_130980.cljs$core$IFn$_invoke$arity$1(inst_130953) : inst_130980.call(null,inst_130953));
var state_131119__$1 = state_131119;
var statearr_131192_131273 = state_131119__$1;
(statearr_131192_131273[(2)] = inst_130985);

(statearr_131192_131273[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (38))){
var inst_131101 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131193_131274 = state_131119__$1;
(statearr_131193_131274[(2)] = inst_131101);

(statearr_131193_131274[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (30))){
var inst_131015 = (state_131119[(13)]);
var inst_131030 = typeof inst_131015 === 'string';
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131030)){
var statearr_131194_131275 = state_131119__$1;
(statearr_131194_131275[(1)] = (33));

} else {
var statearr_131195_131276 = state_131119__$1;
(statearr_131195_131276[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (10))){
var state_131119__$1 = state_131119;
var statearr_131196_131277 = state_131119__$1;
(statearr_131196_131277[(2)] = false);

(statearr_131196_131277[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (18))){
var inst_130953 = (state_131119[(17)]);
var inst_130951 = (state_131119[(16)]);
var inst_130980 = (state_131119[(25)]);
var inst_130990 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130951),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130980),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130953),"."].join('');
var inst_130991 = cljs.core.PersistentHashMap.EMPTY;
var inst_130992 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_130990,inst_130991);
var inst_130993 = (function(){throw inst_130992})();
var state_131119__$1 = state_131119;
var statearr_131197_131278 = state_131119__$1;
(statearr_131197_131278[(2)] = inst_130993);

(statearr_131197_131278[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (52))){
var inst_131015 = (state_131119[(13)]);
var inst_131071 = cljs.core.vector_QMARK_(inst_131015);
var state_131119__$1 = state_131119;
if(inst_131071){
var statearr_131198_131279 = state_131119__$1;
(statearr_131198_131279[(1)] = (54));

} else {
var statearr_131199_131280 = state_131119__$1;
(statearr_131199_131280[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (42))){
var inst_131038 = (state_131119[(14)]);
var state_131119__$1 = state_131119;
var statearr_131200_131281 = state_131119__$1;
(statearr_131200_131281[(2)] = inst_131038);

(statearr_131200_131281[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (37))){
var inst_131015 = (state_131119[(13)]);
var inst_131036 = (inst_131015 instanceof cljs.core.Symbol);
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_131036)){
var statearr_131201_131282 = state_131119__$1;
(statearr_131201_131282[(1)] = (39));

} else {
var statearr_131202_131283 = state_131119__$1;
(statearr_131202_131283[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (63))){
var inst_131091 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
var statearr_131203_131284 = state_131119__$1;
(statearr_131203_131284[(2)] = inst_131091);

(statearr_131203_131284[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (8))){
var inst_130973 = (state_131119[(2)]);
var state_131119__$1 = state_131119;
if(cljs.core.truth_(inst_130973)){
var statearr_131204_131285 = state_131119__$1;
(statearr_131204_131285[(1)] = (12));

} else {
var statearr_131205_131286 = state_131119__$1;
(statearr_131205_131286[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131120 === (49))){
var inst_131015 = (state_131119[(13)]);
var inst_131051 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_131052 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_131015)," used in function argument: ",inst_131051].join('');
var inst_131053 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131054 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_131055 = cljs.core.PersistentHashMap.fromArrays(inst_131053,inst_131054);
var inst_131056 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_131052,inst_131055);
var inst_131057 = (function(){throw inst_131056})();
var state_131119__$1 = state_131119;
var statearr_131206_131287 = state_131119__$1;
(statearr_131206_131287[(2)] = inst_131057);

(statearr_131206_131287[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__109971__auto____0 = (function (){
var statearr_131207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_131207[(0)] = fluree$db$dbfunctions$core$state_machine__109971__auto__);

(statearr_131207[(1)] = (1));

return statearr_131207;
});
var fluree$db$dbfunctions$core$state_machine__109971__auto____1 = (function (state_131119){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_131119);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e131208){if((e131208 instanceof Object)){
var ex__109974__auto__ = e131208;
var statearr_131209_131288 = state_131119;
(statearr_131209_131288[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_131119);

return cljs.core.cst$kw$recur;
} else {
throw e131208;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__131289 = state_131119;
state_131119 = G__131289;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__109971__auto__ = function(state_131119){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__109971__auto____1.call(this,state_131119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__109971__auto____0;
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__109971__auto____1;
return fluree$db$dbfunctions$core$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_131210 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_131210[(6)] = c__110077__auto__);

return statearr_131210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4;

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__131291 = arguments.length;
switch (G__131291) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
});

fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_131363){
var state_val_131364 = (state_131363[(1)]);
if((state_val_131364 === (7))){
var inst_131359 = (state_131363[(2)]);
var state_131363__$1 = state_131363;
var statearr_131365_131395 = state_131363__$1;
(statearr_131365_131395[(2)] = inst_131359);


cljs.core.async.impl.ioc_helpers.process_exception(state_131363__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (20))){
var inst_131351 = (state_131363[(2)]);
var inst_131352 = [cljs.core.cst$kw$fnstr];
var inst_131353 = [fn_str];
var inst_131354 = cljs.core.PersistentHashMap.fromArrays(inst_131352,inst_131353);
var inst_131355 = cljs.core.with_meta(inst_131351,inst_131354);
var state_131363__$1 = state_131363;
var statearr_131366_131396 = state_131363__$1;
(statearr_131366_131396[(2)] = inst_131355);


cljs.core.async.impl.ioc_helpers.process_exception(state_131363__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (1))){
var state_131363__$1 = state_131363;
var statearr_131367_131397 = state_131363__$1;
(statearr_131367_131397[(2)] = null);

(statearr_131367_131397[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131363,(3),Error,null,(2));
var inst_131296 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var inst_131297 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var inst_131298 = ((inst_131296) || (inst_131297));
var state_131363__$1 = state_131363;
if(cljs.core.truth_(inst_131298)){
var statearr_131368_131398 = state_131363__$1;
(statearr_131368_131398[(1)] = (5));

} else {
var statearr_131369_131399 = state_131363__$1;
(statearr_131369_131399[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (15))){
var inst_131343 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_131363__$1 = state_131363;
var statearr_131370_131400 = state_131363__$1;
(statearr_131370_131400[(2)] = inst_131343);

(statearr_131370_131400[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (13))){
var inst_131323 = (state_131363[(2)]);
var inst_131324 = cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_131325 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_131324,type,params);
var state_131363__$1 = (function (){var statearr_131371 = state_131363;
(statearr_131371[(7)] = inst_131323);

return statearr_131371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131363__$1,(14),inst_131325);
} else {
if((state_val_131364 === (6))){
var state_131363__$1 = state_131363;
var statearr_131372_131401 = state_131363__$1;
(statearr_131372_131401[(2)] = null);

(statearr_131372_131401[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (17))){
var inst_131346 = (state_131363[(2)]);
var state_131363__$1 = state_131363;
if(cljs.core.truth_(inst_131346)){
var statearr_131373_131402 = state_131363__$1;
(statearr_131373_131402[(1)] = (18));

} else {
var statearr_131374_131403 = state_131363__$1;
(statearr_131374_131403[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (3))){
var inst_131292 = (state_131363[(2)]);
var state_131363__$1 = state_131363;
var statearr_131375_131404 = state_131363__$1;
(statearr_131375_131404[(2)] = inst_131292);


cljs.core.async.impl.ioc_helpers.process_exception(state_131363__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (12))){
var inst_131317 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131318 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_131319 = cljs.core.PersistentHashMap.fromArrays(inst_131317,inst_131318);
var inst_131320 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_131319);
var inst_131321 = (function(){throw inst_131320})();
var state_131363__$1 = state_131363;
var statearr_131376_131405 = state_131363__$1;
(statearr_131376_131405[(2)] = inst_131321);

(statearr_131376_131405[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (2))){
var inst_131361 = (state_131363[(2)]);
var state_131363__$1 = state_131363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_131363__$1,inst_131361);
} else {
if((state_val_131364 === (19))){
var inst_131341 = (state_131363[(8)]);
var inst_131349 = cljs.core.eval(inst_131341);
var state_131363__$1 = state_131363;
var statearr_131377_131406 = state_131363__$1;
(statearr_131377_131406[(2)] = inst_131349);

(statearr_131377_131406[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (11))){
var state_131363__$1 = state_131363;
var statearr_131378_131407 = state_131363__$1;
(statearr_131378_131407[(2)] = null);

(statearr_131378_131407[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (9))){
var inst_131303 = (state_131363[(2)]);
var inst_131304 = (function(){throw inst_131303})();
var inst_131305 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_131306 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131307 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_131308 = cljs.core.PersistentHashMap.fromArrays(inst_131306,inst_131307);
var inst_131309 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_131305,inst_131308);
var inst_131310 = (function(){throw inst_131309})();
var state_131363__$1 = (function (){var statearr_131379 = state_131363;
(statearr_131379[(9)] = inst_131304);

return statearr_131379;
})();
var statearr_131380_131408 = state_131363__$1;
(statearr_131380_131408[(2)] = inst_131310);


cljs.core.async.impl.ioc_helpers.process_exception(state_131363__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (5))){
var inst_131300 = (function (){return ((function (state_val_131364,c__110077__auto__){
return (function (n){
return cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
;})(state_val_131364,c__110077__auto__))
})();
var inst_131301 = fluree.db.dbfunctions.core.true_or_false = inst_131300;
var state_131363__$1 = state_131363;
var statearr_131381_131409 = state_131363__$1;
(statearr_131381_131409[(2)] = inst_131301);

(statearr_131381_131409[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (14))){
var inst_131327 = (state_131363[(2)]);
var inst_131328 = fluree.db.util.async.throw_err(inst_131327);
var inst_131329 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_131330 = (new cljs.core.List(null,inst_131329,null,(1),null));
var inst_131331 = cljs.core.cst$sym$_QMARK_ctx;
var inst_131332 = (new cljs.core.List(null,inst_131331,null,(1),null));
var inst_131333 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_131332);
var inst_131334 = cljs.core.seq(inst_131333);
var inst_131335 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_131334);
var inst_131336 = cljs.core.vec(inst_131335);
var inst_131337 = (new cljs.core.List(null,inst_131336,null,(1),null));
var inst_131338 = (new cljs.core.List(null,inst_131328,null,(1),null));
var inst_131339 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_131330,inst_131337,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_131338], 0));
var inst_131340 = cljs.core.seq(inst_131339);
var inst_131341 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_131340);
var state_131363__$1 = (function (){var statearr_131382 = state_131363;
(statearr_131382[(8)] = inst_131341);

return statearr_131382;
})();
if(cljs.core.truth_(params)){
var statearr_131383_131410 = state_131363__$1;
(statearr_131383_131410[(1)] = (15));

} else {
var statearr_131384_131411 = state_131363__$1;
(statearr_131384_131411[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (16))){
var state_131363__$1 = state_131363;
var statearr_131385_131412 = state_131363__$1;
(statearr_131385_131412[(2)] = params);

(statearr_131385_131412[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131363,(9),java.lang.Exception,null,(8));
var inst_131314 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_131363__$1 = state_131363;
if(cljs.core.truth_(inst_131314)){
var statearr_131386_131413 = state_131363__$1;
(statearr_131386_131413[(1)] = (11));

} else {
var statearr_131387_131414 = state_131363__$1;
(statearr_131387_131414[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (18))){
var inst_131341 = (state_131363[(8)]);
var state_131363__$1 = state_131363;
var statearr_131388_131415 = state_131363__$1;
(statearr_131388_131415[(2)] = inst_131341);

(statearr_131388_131415[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131364 === (8))){
var inst_131357 = (state_131363[(2)]);
var state_131363__$1 = state_131363;
var statearr_131389_131416 = state_131363__$1;
(statearr_131389_131416[(2)] = inst_131357);

(statearr_131389_131416[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$core$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__109971__auto____0 = (function (){
var statearr_131390 = [null,null,null,null,null,null,null,null,null,null];
(statearr_131390[(0)] = fluree$db$dbfunctions$core$state_machine__109971__auto__);

(statearr_131390[(1)] = (1));

return statearr_131390;
});
var fluree$db$dbfunctions$core$state_machine__109971__auto____1 = (function (state_131363){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_131363);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e131391){if((e131391 instanceof Object)){
var ex__109974__auto__ = e131391;
var statearr_131392_131417 = state_131363;
(statearr_131392_131417[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_131363);

return cljs.core.cst$kw$recur;
} else {
throw e131391;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__131418 = state_131363;
state_131363 = G__131418;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__109971__auto__ = function(state_131363){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__109971__auto____1.call(this,state_131363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__109971__auto____0;
fluree$db$dbfunctions$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__109971__auto____1;
return fluree$db$dbfunctions$core$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_131393 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_131393[(6)] = c__110077__auto__);

return statearr_131393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4;

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_131443){
var state_val_131444 = (state_131443[(1)]);
if((state_val_131444 === (7))){
var inst_131431 = (state_131443[(7)]);
var state_131443__$1 = state_131443;
var statearr_131445_131458 = state_131443__$1;
(statearr_131445_131458[(2)] = inst_131431);

(statearr_131445_131458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131444 === (1))){
var state_131443__$1 = state_131443;
var statearr_131446_131459 = state_131443__$1;
(statearr_131446_131459[(2)] = null);

(statearr_131446_131459[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131444 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131443,(3),Error,null,(2));
var inst_131423 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_131424 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_131425 = [db,block_instant,s,p,auth_id,fuel];
var inst_131426 = cljs.core.PersistentHashMap.fromArrays(inst_131424,inst_131425);
var inst_131427 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_131423,"txn",null);
var state_131443__$1 = (function (){var statearr_131447 = state_131443;
(statearr_131447[(8)] = inst_131426);

return statearr_131447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131443__$1,(5),inst_131427);
} else {
if((state_val_131444 === (6))){
var inst_131431 = (state_131443[(7)]);
var state_131443__$1 = state_131443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131443__$1,(9),inst_131431);
} else {
if((state_val_131444 === (3))){
var inst_131419 = (state_131443[(2)]);
var state_131443__$1 = state_131443;
var statearr_131448_131460 = state_131443__$1;
(statearr_131448_131460[(2)] = inst_131419);


cljs.core.async.impl.ioc_helpers.process_exception(state_131443__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131444 === (2))){
var inst_131441 = (state_131443[(2)]);
var state_131443__$1 = state_131443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_131443__$1,inst_131441);
} else {
if((state_val_131444 === (9))){
var inst_131435 = (state_131443[(2)]);
var inst_131436 = fluree.db.util.async.throw_err(inst_131435);
var state_131443__$1 = state_131443;
var statearr_131449_131461 = state_131443__$1;
(statearr_131449_131461[(2)] = inst_131436);

(statearr_131449_131461[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131444 === (5))){
var inst_131431 = (state_131443[(7)]);
var inst_131426 = (state_131443[(8)]);
var inst_131429 = (state_131443[(2)]);
var inst_131430 = fluree.db.util.async.throw_err(inst_131429);
var inst_131431__$1 = (inst_131430.cljs$core$IFn$_invoke$arity$1 ? inst_131430.cljs$core$IFn$_invoke$arity$1(inst_131426) : inst_131430.call(null,inst_131426));
var inst_131432 = fluree.db.util.async.channel_QMARK_(inst_131431__$1);
var state_131443__$1 = (function (){var statearr_131450 = state_131443;
(statearr_131450[(7)] = inst_131431__$1);

return statearr_131450;
})();
if(inst_131432){
var statearr_131451_131462 = state_131443__$1;
(statearr_131451_131462[(1)] = (6));

} else {
var statearr_131452_131463 = state_131443__$1;
(statearr_131452_131463[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131444 === (8))){
var inst_131439 = (state_131443[(2)]);
var state_131443__$1 = state_131443;
var statearr_131453_131464 = state_131443__$1;
(statearr_131453_131464[(2)] = inst_131439);


cljs.core.async.impl.ioc_helpers.process_exception(state_131443__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____0 = (function (){
var statearr_131454 = [null,null,null,null,null,null,null,null,null];
(statearr_131454[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__);

(statearr_131454[(1)] = (1));

return statearr_131454;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____1 = (function (state_131443){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_131443);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e131455){if((e131455 instanceof Object)){
var ex__109974__auto__ = e131455;
var statearr_131456_131465 = state_131443;
(statearr_131456_131465[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_131443);

return cljs.core.cst$kw$recur;
} else {
throw e131455;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__131466 = state_131443;
state_131443 = G__131466;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__ = function(state_131443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____1.call(this,state_131443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_131457 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_131457[(6)] = c__110077__auto__);

return statearr_131457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
