// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__110137 = arguments.length;
switch (G__110137) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async110138 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async110138 = (function (f,blockable,meta110139){
this.f = f;
this.blockable = blockable;
this.meta110139 = meta110139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_110140,meta110139__$1){
var self__ = this;
var _110140__$1 = this;
return (new cljs.core.async.t_cljs$core$async110138(self__.f,self__.blockable,meta110139__$1));
});

cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_110140){
var self__ = this;
var _110140__$1 = this;
return self__.meta110139;
});

cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async110138.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async110138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta110139], null);
});

cljs.core.async.t_cljs$core$async110138.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async110138.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async110138";

cljs.core.async.t_cljs$core$async110138.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async110138");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async110138.
 */
cljs.core.async.__GT_t_cljs$core$async110138 = (function cljs$core$async$__GT_t_cljs$core$async110138(f__$1,blockable__$1,meta110139){
return (new cljs.core.async.t_cljs$core$async110138(f__$1,blockable__$1,meta110139));
});

}

return (new cljs.core.async.t_cljs$core$async110138(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__110144 = arguments.length;
switch (G__110144) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__110147 = arguments.length;
switch (G__110147) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__110150 = arguments.length;
switch (G__110150) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_110152 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_110152) : fn1.call(null,val_110152));
} else {
cljs.core.async.impl.dispatch.run(((function (val_110152,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_110152) : fn1.call(null,val_110152));
});})(val_110152,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__110154 = arguments.length;
switch (G__110154) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5733__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___110156 = n;
var x_110157 = (0);
while(true){
if((x_110157 < n__4607__auto___110156)){
(a[x_110157] = (0));

var G__110158 = (x_110157 + (1));
x_110157 = G__110158;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__110159 = (i + (1));
i = G__110159;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async110160 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async110160 = (function (flag,meta110161){
this.flag = flag;
this.meta110161 = meta110161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_110162,meta110161__$1){
var self__ = this;
var _110162__$1 = this;
return (new cljs.core.async.t_cljs$core$async110160(self__.flag,meta110161__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_110162){
var self__ = this;
var _110162__$1 = this;
return self__.meta110161;
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta110161], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async110160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async110160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async110160";

cljs.core.async.t_cljs$core$async110160.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async110160");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async110160.
 */
cljs.core.async.__GT_t_cljs$core$async110160 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async110160(flag__$1,meta110161){
return (new cljs.core.async.t_cljs$core$async110160(flag__$1,meta110161));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async110160(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async110163 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async110163 = (function (flag,cb,meta110164){
this.flag = flag;
this.cb = cb;
this.meta110164 = meta110164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_110165,meta110164__$1){
var self__ = this;
var _110165__$1 = this;
return (new cljs.core.async.t_cljs$core$async110163(self__.flag,self__.cb,meta110164__$1));
});

cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_110165){
var self__ = this;
var _110165__$1 = this;
return self__.meta110164;
});

cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async110163.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async110163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta110164], null);
});

cljs.core.async.t_cljs$core$async110163.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async110163.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async110163";

cljs.core.async.t_cljs$core$async110163.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async110163");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async110163.
 */
cljs.core.async.__GT_t_cljs$core$async110163 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async110163(flag__$1,cb__$1,meta110164){
return (new cljs.core.async.t_cljs$core$async110163(flag__$1,cb__$1,meta110164));
});

}

return (new cljs.core.async.t_cljs$core$async110163(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__110166_SHARP_){
var G__110168 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__110166_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__110168) : fret.call(null,G__110168));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__110167_SHARP_){
var G__110169 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__110167_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__110169) : fret.call(null,G__110169));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__110170 = (i + (1));
i = G__110170;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5735__auto__ = (function (){var and__4120__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4120__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___110176 = arguments.length;
var i__4731__auto___110177 = (0);
while(true){
if((i__4731__auto___110177 < len__4730__auto___110176)){
args__4736__auto__.push((arguments[i__4731__auto___110177]));

var G__110178 = (i__4731__auto___110177 + (1));
i__4731__auto___110177 = G__110178;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__110173){
var map__110174 = p__110173;
var map__110174__$1 = (((((!((map__110174 == null))))?(((((map__110174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110174.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110174):map__110174);
var opts = map__110174__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq110171){
var G__110172 = cljs.core.first(seq110171);
var seq110171__$1 = cljs.core.next(seq110171);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__110172,seq110171__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__110180 = arguments.length;
switch (G__110180) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__110077__auto___110226 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___110226){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___110226){
return (function (state_110204){
var state_val_110205 = (state_110204[(1)]);
if((state_val_110205 === (7))){
var inst_110200 = (state_110204[(2)]);
var state_110204__$1 = state_110204;
var statearr_110206_110227 = state_110204__$1;
(statearr_110206_110227[(2)] = inst_110200);

(statearr_110206_110227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (1))){
var state_110204__$1 = state_110204;
var statearr_110207_110228 = state_110204__$1;
(statearr_110207_110228[(2)] = null);

(statearr_110207_110228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (4))){
var inst_110183 = (state_110204[(7)]);
var inst_110183__$1 = (state_110204[(2)]);
var inst_110184 = (inst_110183__$1 == null);
var state_110204__$1 = (function (){var statearr_110208 = state_110204;
(statearr_110208[(7)] = inst_110183__$1);

return statearr_110208;
})();
if(cljs.core.truth_(inst_110184)){
var statearr_110209_110229 = state_110204__$1;
(statearr_110209_110229[(1)] = (5));

} else {
var statearr_110210_110230 = state_110204__$1;
(statearr_110210_110230[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (13))){
var state_110204__$1 = state_110204;
var statearr_110211_110231 = state_110204__$1;
(statearr_110211_110231[(2)] = null);

(statearr_110211_110231[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (6))){
var inst_110183 = (state_110204[(7)]);
var state_110204__$1 = state_110204;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110204__$1,(11),to,inst_110183);
} else {
if((state_val_110205 === (3))){
var inst_110202 = (state_110204[(2)]);
var state_110204__$1 = state_110204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110204__$1,inst_110202);
} else {
if((state_val_110205 === (12))){
var state_110204__$1 = state_110204;
var statearr_110212_110232 = state_110204__$1;
(statearr_110212_110232[(2)] = null);

(statearr_110212_110232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (2))){
var state_110204__$1 = state_110204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110204__$1,(4),from);
} else {
if((state_val_110205 === (11))){
var inst_110193 = (state_110204[(2)]);
var state_110204__$1 = state_110204;
if(cljs.core.truth_(inst_110193)){
var statearr_110213_110233 = state_110204__$1;
(statearr_110213_110233[(1)] = (12));

} else {
var statearr_110214_110234 = state_110204__$1;
(statearr_110214_110234[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (9))){
var state_110204__$1 = state_110204;
var statearr_110215_110235 = state_110204__$1;
(statearr_110215_110235[(2)] = null);

(statearr_110215_110235[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (5))){
var state_110204__$1 = state_110204;
if(cljs.core.truth_(close_QMARK_)){
var statearr_110216_110236 = state_110204__$1;
(statearr_110216_110236[(1)] = (8));

} else {
var statearr_110217_110237 = state_110204__$1;
(statearr_110217_110237[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (14))){
var inst_110198 = (state_110204[(2)]);
var state_110204__$1 = state_110204;
var statearr_110218_110238 = state_110204__$1;
(statearr_110218_110238[(2)] = inst_110198);

(statearr_110218_110238[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (10))){
var inst_110190 = (state_110204[(2)]);
var state_110204__$1 = state_110204;
var statearr_110219_110239 = state_110204__$1;
(statearr_110219_110239[(2)] = inst_110190);

(statearr_110219_110239[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110205 === (8))){
var inst_110187 = cljs.core.async.close_BANG_(to);
var state_110204__$1 = state_110204;
var statearr_110220_110240 = state_110204__$1;
(statearr_110220_110240[(2)] = inst_110187);

(statearr_110220_110240[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___110226))
;
return ((function (switch__109970__auto__,c__110077__auto___110226){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_110221 = [null,null,null,null,null,null,null,null];
(statearr_110221[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_110221[(1)] = (1));

return statearr_110221;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_110204){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110204);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110222){if((e110222 instanceof Object)){
var ex__109974__auto__ = e110222;
var statearr_110223_110241 = state_110204;
(statearr_110223_110241[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110204);

return cljs.core.cst$kw$recur;
} else {
throw e110222;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110242 = state_110204;
state_110204 = G__110242;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_110204){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_110204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___110226))
})();
var state__110079__auto__ = (function (){var statearr_110224 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110224[(6)] = c__110077__auto___110226);

return statearr_110224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___110226))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__110243){
var vec__110244 = p__110243;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110244,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110244,(1),null);
var job = vec__110244;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__110077__auto___110415 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results){
return (function (state_110251){
var state_val_110252 = (state_110251[(1)]);
if((state_val_110252 === (1))){
var state_110251__$1 = state_110251;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110251__$1,(2),res,v);
} else {
if((state_val_110252 === (2))){
var inst_110248 = (state_110251[(2)]);
var inst_110249 = cljs.core.async.close_BANG_(res);
var state_110251__$1 = (function (){var statearr_110253 = state_110251;
(statearr_110253[(7)] = inst_110248);

return statearr_110253;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_110251__$1,inst_110249);
} else {
return null;
}
}
});})(c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results))
;
return ((function (switch__109970__auto__,c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_110254 = [null,null,null,null,null,null,null,null];
(statearr_110254[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__);

(statearr_110254[(1)] = (1));

return statearr_110254;
});
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1 = (function (state_110251){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110251);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110255){if((e110255 instanceof Object)){
var ex__109974__auto__ = e110255;
var statearr_110256_110416 = state_110251;
(statearr_110256_110416[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110251);

return cljs.core.cst$kw$recur;
} else {
throw e110255;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110417 = state_110251;
state_110251 = G__110417;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = function(state_110251){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1.call(this,state_110251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results))
})();
var state__110079__auto__ = (function (){var statearr_110257 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110257[(6)] = c__110077__auto___110415);

return statearr_110257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___110415,res,vec__110244,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__110258){
var vec__110259 = p__110258;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110259,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110259,(1),null);
var job = vec__110259;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___110418 = n;
var __110419 = (0);
while(true){
if((__110419 < n__4607__auto___110418)){
var G__110262_110420 = type;
var G__110262_110421__$1 = (((G__110262_110420 instanceof cljs.core.Keyword))?G__110262_110420.fqn:null);
switch (G__110262_110421__$1) {
case "compute":
var c__110077__auto___110423 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__110419,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (__110419,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function (state_110275){
var state_val_110276 = (state_110275[(1)]);
if((state_val_110276 === (1))){
var state_110275__$1 = state_110275;
var statearr_110277_110424 = state_110275__$1;
(statearr_110277_110424[(2)] = null);

(statearr_110277_110424[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110276 === (2))){
var state_110275__$1 = state_110275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110275__$1,(4),jobs);
} else {
if((state_val_110276 === (3))){
var inst_110273 = (state_110275[(2)]);
var state_110275__$1 = state_110275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110275__$1,inst_110273);
} else {
if((state_val_110276 === (4))){
var inst_110265 = (state_110275[(2)]);
var inst_110266 = process(inst_110265);
var state_110275__$1 = state_110275;
if(cljs.core.truth_(inst_110266)){
var statearr_110278_110425 = state_110275__$1;
(statearr_110278_110425[(1)] = (5));

} else {
var statearr_110279_110426 = state_110275__$1;
(statearr_110279_110426[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110276 === (5))){
var state_110275__$1 = state_110275;
var statearr_110280_110427 = state_110275__$1;
(statearr_110280_110427[(2)] = null);

(statearr_110280_110427[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110276 === (6))){
var state_110275__$1 = state_110275;
var statearr_110281_110428 = state_110275__$1;
(statearr_110281_110428[(2)] = null);

(statearr_110281_110428[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110276 === (7))){
var inst_110271 = (state_110275[(2)]);
var state_110275__$1 = state_110275;
var statearr_110282_110429 = state_110275__$1;
(statearr_110282_110429[(2)] = inst_110271);

(statearr_110282_110429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__110419,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
;
return ((function (__110419,switch__109970__auto__,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_110283 = [null,null,null,null,null,null,null];
(statearr_110283[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__);

(statearr_110283[(1)] = (1));

return statearr_110283;
});
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1 = (function (state_110275){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110275);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110284){if((e110284 instanceof Object)){
var ex__109974__auto__ = e110284;
var statearr_110285_110430 = state_110275;
(statearr_110285_110430[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110275);

return cljs.core.cst$kw$recur;
} else {
throw e110284;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110431 = state_110275;
state_110275 = G__110431;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = function(state_110275){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1.call(this,state_110275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__;
})()
;})(__110419,switch__109970__auto__,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
})();
var state__110079__auto__ = (function (){var statearr_110286 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110286[(6)] = c__110077__auto___110423);

return statearr_110286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(__110419,c__110077__auto___110423,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
);


break;
case "async":
var c__110077__auto___110432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__110419,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (__110419,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function (state_110299){
var state_val_110300 = (state_110299[(1)]);
if((state_val_110300 === (1))){
var state_110299__$1 = state_110299;
var statearr_110301_110433 = state_110299__$1;
(statearr_110301_110433[(2)] = null);

(statearr_110301_110433[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110300 === (2))){
var state_110299__$1 = state_110299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110299__$1,(4),jobs);
} else {
if((state_val_110300 === (3))){
var inst_110297 = (state_110299[(2)]);
var state_110299__$1 = state_110299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110299__$1,inst_110297);
} else {
if((state_val_110300 === (4))){
var inst_110289 = (state_110299[(2)]);
var inst_110290 = async(inst_110289);
var state_110299__$1 = state_110299;
if(cljs.core.truth_(inst_110290)){
var statearr_110302_110434 = state_110299__$1;
(statearr_110302_110434[(1)] = (5));

} else {
var statearr_110303_110435 = state_110299__$1;
(statearr_110303_110435[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110300 === (5))){
var state_110299__$1 = state_110299;
var statearr_110304_110436 = state_110299__$1;
(statearr_110304_110436[(2)] = null);

(statearr_110304_110436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110300 === (6))){
var state_110299__$1 = state_110299;
var statearr_110305_110437 = state_110299__$1;
(statearr_110305_110437[(2)] = null);

(statearr_110305_110437[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110300 === (7))){
var inst_110295 = (state_110299[(2)]);
var state_110299__$1 = state_110299;
var statearr_110306_110438 = state_110299__$1;
(statearr_110306_110438[(2)] = inst_110295);

(statearr_110306_110438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__110419,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
;
return ((function (__110419,switch__109970__auto__,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_110307 = [null,null,null,null,null,null,null];
(statearr_110307[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__);

(statearr_110307[(1)] = (1));

return statearr_110307;
});
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1 = (function (state_110299){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110299);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110308){if((e110308 instanceof Object)){
var ex__109974__auto__ = e110308;
var statearr_110309_110439 = state_110299;
(statearr_110309_110439[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110299);

return cljs.core.cst$kw$recur;
} else {
throw e110308;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110440 = state_110299;
state_110299 = G__110440;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = function(state_110299){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1.call(this,state_110299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__;
})()
;})(__110419,switch__109970__auto__,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
})();
var state__110079__auto__ = (function (){var statearr_110310 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110310[(6)] = c__110077__auto___110432);

return statearr_110310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(__110419,c__110077__auto___110432,G__110262_110420,G__110262_110421__$1,n__4607__auto___110418,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__110262_110421__$1)].join('')));

}

var G__110441 = (__110419 + (1));
__110419 = G__110441;
continue;
} else {
}
break;
}

var c__110077__auto___110442 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___110442,jobs,results,process,async){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___110442,jobs,results,process,async){
return (function (state_110332){
var state_val_110333 = (state_110332[(1)]);
if((state_val_110333 === (7))){
var inst_110328 = (state_110332[(2)]);
var state_110332__$1 = state_110332;
var statearr_110334_110443 = state_110332__$1;
(statearr_110334_110443[(2)] = inst_110328);

(statearr_110334_110443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110333 === (1))){
var state_110332__$1 = state_110332;
var statearr_110335_110444 = state_110332__$1;
(statearr_110335_110444[(2)] = null);

(statearr_110335_110444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110333 === (4))){
var inst_110313 = (state_110332[(7)]);
var inst_110313__$1 = (state_110332[(2)]);
var inst_110314 = (inst_110313__$1 == null);
var state_110332__$1 = (function (){var statearr_110336 = state_110332;
(statearr_110336[(7)] = inst_110313__$1);

return statearr_110336;
})();
if(cljs.core.truth_(inst_110314)){
var statearr_110337_110445 = state_110332__$1;
(statearr_110337_110445[(1)] = (5));

} else {
var statearr_110338_110446 = state_110332__$1;
(statearr_110338_110446[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110333 === (6))){
var inst_110318 = (state_110332[(8)]);
var inst_110313 = (state_110332[(7)]);
var inst_110318__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_110319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110320 = [inst_110313,inst_110318__$1];
var inst_110321 = (new cljs.core.PersistentVector(null,2,(5),inst_110319,inst_110320,null));
var state_110332__$1 = (function (){var statearr_110339 = state_110332;
(statearr_110339[(8)] = inst_110318__$1);

return statearr_110339;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110332__$1,(8),jobs,inst_110321);
} else {
if((state_val_110333 === (3))){
var inst_110330 = (state_110332[(2)]);
var state_110332__$1 = state_110332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110332__$1,inst_110330);
} else {
if((state_val_110333 === (2))){
var state_110332__$1 = state_110332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110332__$1,(4),from);
} else {
if((state_val_110333 === (9))){
var inst_110325 = (state_110332[(2)]);
var state_110332__$1 = (function (){var statearr_110340 = state_110332;
(statearr_110340[(9)] = inst_110325);

return statearr_110340;
})();
var statearr_110341_110447 = state_110332__$1;
(statearr_110341_110447[(2)] = null);

(statearr_110341_110447[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110333 === (5))){
var inst_110316 = cljs.core.async.close_BANG_(jobs);
var state_110332__$1 = state_110332;
var statearr_110342_110448 = state_110332__$1;
(statearr_110342_110448[(2)] = inst_110316);

(statearr_110342_110448[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110333 === (8))){
var inst_110318 = (state_110332[(8)]);
var inst_110323 = (state_110332[(2)]);
var state_110332__$1 = (function (){var statearr_110343 = state_110332;
(statearr_110343[(10)] = inst_110323);

return statearr_110343;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110332__$1,(9),results,inst_110318);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___110442,jobs,results,process,async))
;
return ((function (switch__109970__auto__,c__110077__auto___110442,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_110344 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_110344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__);

(statearr_110344[(1)] = (1));

return statearr_110344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1 = (function (state_110332){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110332);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110345){if((e110345 instanceof Object)){
var ex__109974__auto__ = e110345;
var statearr_110346_110449 = state_110332;
(statearr_110346_110449[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110332);

return cljs.core.cst$kw$recur;
} else {
throw e110345;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110450 = state_110332;
state_110332 = G__110450;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = function(state_110332){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1.call(this,state_110332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___110442,jobs,results,process,async))
})();
var state__110079__auto__ = (function (){var statearr_110347 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110347[(6)] = c__110077__auto___110442);

return statearr_110347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___110442,jobs,results,process,async))
);


var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,jobs,results,process,async){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,jobs,results,process,async){
return (function (state_110385){
var state_val_110386 = (state_110385[(1)]);
if((state_val_110386 === (7))){
var inst_110381 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
var statearr_110387_110451 = state_110385__$1;
(statearr_110387_110451[(2)] = inst_110381);

(statearr_110387_110451[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (20))){
var state_110385__$1 = state_110385;
var statearr_110388_110452 = state_110385__$1;
(statearr_110388_110452[(2)] = null);

(statearr_110388_110452[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (1))){
var state_110385__$1 = state_110385;
var statearr_110389_110453 = state_110385__$1;
(statearr_110389_110453[(2)] = null);

(statearr_110389_110453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (4))){
var inst_110350 = (state_110385[(7)]);
var inst_110350__$1 = (state_110385[(2)]);
var inst_110351 = (inst_110350__$1 == null);
var state_110385__$1 = (function (){var statearr_110390 = state_110385;
(statearr_110390[(7)] = inst_110350__$1);

return statearr_110390;
})();
if(cljs.core.truth_(inst_110351)){
var statearr_110391_110454 = state_110385__$1;
(statearr_110391_110454[(1)] = (5));

} else {
var statearr_110392_110455 = state_110385__$1;
(statearr_110392_110455[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (15))){
var inst_110363 = (state_110385[(8)]);
var state_110385__$1 = state_110385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110385__$1,(18),to,inst_110363);
} else {
if((state_val_110386 === (21))){
var inst_110376 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
var statearr_110393_110456 = state_110385__$1;
(statearr_110393_110456[(2)] = inst_110376);

(statearr_110393_110456[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (13))){
var inst_110378 = (state_110385[(2)]);
var state_110385__$1 = (function (){var statearr_110394 = state_110385;
(statearr_110394[(9)] = inst_110378);

return statearr_110394;
})();
var statearr_110395_110457 = state_110385__$1;
(statearr_110395_110457[(2)] = null);

(statearr_110395_110457[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (6))){
var inst_110350 = (state_110385[(7)]);
var state_110385__$1 = state_110385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110385__$1,(11),inst_110350);
} else {
if((state_val_110386 === (17))){
var inst_110371 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
if(cljs.core.truth_(inst_110371)){
var statearr_110396_110458 = state_110385__$1;
(statearr_110396_110458[(1)] = (19));

} else {
var statearr_110397_110459 = state_110385__$1;
(statearr_110397_110459[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (3))){
var inst_110383 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110385__$1,inst_110383);
} else {
if((state_val_110386 === (12))){
var inst_110360 = (state_110385[(10)]);
var state_110385__$1 = state_110385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110385__$1,(14),inst_110360);
} else {
if((state_val_110386 === (2))){
var state_110385__$1 = state_110385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110385__$1,(4),results);
} else {
if((state_val_110386 === (19))){
var state_110385__$1 = state_110385;
var statearr_110398_110460 = state_110385__$1;
(statearr_110398_110460[(2)] = null);

(statearr_110398_110460[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (11))){
var inst_110360 = (state_110385[(2)]);
var state_110385__$1 = (function (){var statearr_110399 = state_110385;
(statearr_110399[(10)] = inst_110360);

return statearr_110399;
})();
var statearr_110400_110461 = state_110385__$1;
(statearr_110400_110461[(2)] = null);

(statearr_110400_110461[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (9))){
var state_110385__$1 = state_110385;
var statearr_110401_110462 = state_110385__$1;
(statearr_110401_110462[(2)] = null);

(statearr_110401_110462[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (5))){
var state_110385__$1 = state_110385;
if(cljs.core.truth_(close_QMARK_)){
var statearr_110402_110463 = state_110385__$1;
(statearr_110402_110463[(1)] = (8));

} else {
var statearr_110403_110464 = state_110385__$1;
(statearr_110403_110464[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (14))){
var inst_110363 = (state_110385[(8)]);
var inst_110365 = (state_110385[(11)]);
var inst_110363__$1 = (state_110385[(2)]);
var inst_110364 = (inst_110363__$1 == null);
var inst_110365__$1 = cljs.core.not(inst_110364);
var state_110385__$1 = (function (){var statearr_110404 = state_110385;
(statearr_110404[(8)] = inst_110363__$1);

(statearr_110404[(11)] = inst_110365__$1);

return statearr_110404;
})();
if(inst_110365__$1){
var statearr_110405_110465 = state_110385__$1;
(statearr_110405_110465[(1)] = (15));

} else {
var statearr_110406_110466 = state_110385__$1;
(statearr_110406_110466[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (16))){
var inst_110365 = (state_110385[(11)]);
var state_110385__$1 = state_110385;
var statearr_110407_110467 = state_110385__$1;
(statearr_110407_110467[(2)] = inst_110365);

(statearr_110407_110467[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (10))){
var inst_110357 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
var statearr_110408_110468 = state_110385__$1;
(statearr_110408_110468[(2)] = inst_110357);

(statearr_110408_110468[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (18))){
var inst_110368 = (state_110385[(2)]);
var state_110385__$1 = state_110385;
var statearr_110409_110469 = state_110385__$1;
(statearr_110409_110469[(2)] = inst_110368);

(statearr_110409_110469[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110386 === (8))){
var inst_110354 = cljs.core.async.close_BANG_(to);
var state_110385__$1 = state_110385;
var statearr_110410_110470 = state_110385__$1;
(statearr_110410_110470[(2)] = inst_110354);

(statearr_110410_110470[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,jobs,results,process,async))
;
return ((function (switch__109970__auto__,c__110077__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_110411 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110411[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__);

(statearr_110411[(1)] = (1));

return statearr_110411;
});
var cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1 = (function (state_110385){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110385);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110412){if((e110412 instanceof Object)){
var ex__109974__auto__ = e110412;
var statearr_110413_110471 = state_110385;
(statearr_110413_110471[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110385);

return cljs.core.cst$kw$recur;
} else {
throw e110412;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110472 = state_110385;
state_110385 = G__110472;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__ = function(state_110385){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1.call(this,state_110385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,jobs,results,process,async))
})();
var state__110079__auto__ = (function (){var statearr_110414 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110414[(6)] = c__110077__auto__);

return statearr_110414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,jobs,results,process,async))
);

return c__110077__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__110474 = arguments.length;
switch (G__110474) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__110477 = arguments.length;
switch (G__110477) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__110480 = arguments.length;
switch (G__110480) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__110077__auto___110529 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___110529,tc,fc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___110529,tc,fc){
return (function (state_110506){
var state_val_110507 = (state_110506[(1)]);
if((state_val_110507 === (7))){
var inst_110502 = (state_110506[(2)]);
var state_110506__$1 = state_110506;
var statearr_110508_110530 = state_110506__$1;
(statearr_110508_110530[(2)] = inst_110502);

(statearr_110508_110530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (1))){
var state_110506__$1 = state_110506;
var statearr_110509_110531 = state_110506__$1;
(statearr_110509_110531[(2)] = null);

(statearr_110509_110531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (4))){
var inst_110483 = (state_110506[(7)]);
var inst_110483__$1 = (state_110506[(2)]);
var inst_110484 = (inst_110483__$1 == null);
var state_110506__$1 = (function (){var statearr_110510 = state_110506;
(statearr_110510[(7)] = inst_110483__$1);

return statearr_110510;
})();
if(cljs.core.truth_(inst_110484)){
var statearr_110511_110532 = state_110506__$1;
(statearr_110511_110532[(1)] = (5));

} else {
var statearr_110512_110533 = state_110506__$1;
(statearr_110512_110533[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (13))){
var state_110506__$1 = state_110506;
var statearr_110513_110534 = state_110506__$1;
(statearr_110513_110534[(2)] = null);

(statearr_110513_110534[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (6))){
var inst_110483 = (state_110506[(7)]);
var inst_110489 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_110483) : p.call(null,inst_110483));
var state_110506__$1 = state_110506;
if(cljs.core.truth_(inst_110489)){
var statearr_110514_110535 = state_110506__$1;
(statearr_110514_110535[(1)] = (9));

} else {
var statearr_110515_110536 = state_110506__$1;
(statearr_110515_110536[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (3))){
var inst_110504 = (state_110506[(2)]);
var state_110506__$1 = state_110506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110506__$1,inst_110504);
} else {
if((state_val_110507 === (12))){
var state_110506__$1 = state_110506;
var statearr_110516_110537 = state_110506__$1;
(statearr_110516_110537[(2)] = null);

(statearr_110516_110537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (2))){
var state_110506__$1 = state_110506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110506__$1,(4),ch);
} else {
if((state_val_110507 === (11))){
var inst_110483 = (state_110506[(7)]);
var inst_110493 = (state_110506[(2)]);
var state_110506__$1 = state_110506;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110506__$1,(8),inst_110493,inst_110483);
} else {
if((state_val_110507 === (9))){
var state_110506__$1 = state_110506;
var statearr_110517_110538 = state_110506__$1;
(statearr_110517_110538[(2)] = tc);

(statearr_110517_110538[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (5))){
var inst_110486 = cljs.core.async.close_BANG_(tc);
var inst_110487 = cljs.core.async.close_BANG_(fc);
var state_110506__$1 = (function (){var statearr_110518 = state_110506;
(statearr_110518[(8)] = inst_110486);

return statearr_110518;
})();
var statearr_110519_110539 = state_110506__$1;
(statearr_110519_110539[(2)] = inst_110487);

(statearr_110519_110539[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (14))){
var inst_110500 = (state_110506[(2)]);
var state_110506__$1 = state_110506;
var statearr_110520_110540 = state_110506__$1;
(statearr_110520_110540[(2)] = inst_110500);

(statearr_110520_110540[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (10))){
var state_110506__$1 = state_110506;
var statearr_110521_110541 = state_110506__$1;
(statearr_110521_110541[(2)] = fc);

(statearr_110521_110541[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110507 === (8))){
var inst_110495 = (state_110506[(2)]);
var state_110506__$1 = state_110506;
if(cljs.core.truth_(inst_110495)){
var statearr_110522_110542 = state_110506__$1;
(statearr_110522_110542[(1)] = (12));

} else {
var statearr_110523_110543 = state_110506__$1;
(statearr_110523_110543[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___110529,tc,fc))
;
return ((function (switch__109970__auto__,c__110077__auto___110529,tc,fc){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_110524 = [null,null,null,null,null,null,null,null,null];
(statearr_110524[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_110524[(1)] = (1));

return statearr_110524;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_110506){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110506);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110525){if((e110525 instanceof Object)){
var ex__109974__auto__ = e110525;
var statearr_110526_110544 = state_110506;
(statearr_110526_110544[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110506);

return cljs.core.cst$kw$recur;
} else {
throw e110525;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110545 = state_110506;
state_110506 = G__110545;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_110506){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_110506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___110529,tc,fc))
})();
var state__110079__auto__ = (function (){var statearr_110527 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110527[(6)] = c__110077__auto___110529);

return statearr_110527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___110529,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_110566){
var state_val_110567 = (state_110566[(1)]);
if((state_val_110567 === (7))){
var inst_110562 = (state_110566[(2)]);
var state_110566__$1 = state_110566;
var statearr_110568_110586 = state_110566__$1;
(statearr_110568_110586[(2)] = inst_110562);

(statearr_110568_110586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (1))){
var inst_110546 = init;
var state_110566__$1 = (function (){var statearr_110569 = state_110566;
(statearr_110569[(7)] = inst_110546);

return statearr_110569;
})();
var statearr_110570_110587 = state_110566__$1;
(statearr_110570_110587[(2)] = null);

(statearr_110570_110587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (4))){
var inst_110549 = (state_110566[(8)]);
var inst_110549__$1 = (state_110566[(2)]);
var inst_110550 = (inst_110549__$1 == null);
var state_110566__$1 = (function (){var statearr_110571 = state_110566;
(statearr_110571[(8)] = inst_110549__$1);

return statearr_110571;
})();
if(cljs.core.truth_(inst_110550)){
var statearr_110572_110588 = state_110566__$1;
(statearr_110572_110588[(1)] = (5));

} else {
var statearr_110573_110589 = state_110566__$1;
(statearr_110573_110589[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (6))){
var inst_110553 = (state_110566[(9)]);
var inst_110549 = (state_110566[(8)]);
var inst_110546 = (state_110566[(7)]);
var inst_110553__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_110546,inst_110549) : f.call(null,inst_110546,inst_110549));
var inst_110554 = cljs.core.reduced_QMARK_(inst_110553__$1);
var state_110566__$1 = (function (){var statearr_110574 = state_110566;
(statearr_110574[(9)] = inst_110553__$1);

return statearr_110574;
})();
if(inst_110554){
var statearr_110575_110590 = state_110566__$1;
(statearr_110575_110590[(1)] = (8));

} else {
var statearr_110576_110591 = state_110566__$1;
(statearr_110576_110591[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (3))){
var inst_110564 = (state_110566[(2)]);
var state_110566__$1 = state_110566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110566__$1,inst_110564);
} else {
if((state_val_110567 === (2))){
var state_110566__$1 = state_110566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110566__$1,(4),ch);
} else {
if((state_val_110567 === (9))){
var inst_110553 = (state_110566[(9)]);
var inst_110546 = inst_110553;
var state_110566__$1 = (function (){var statearr_110577 = state_110566;
(statearr_110577[(7)] = inst_110546);

return statearr_110577;
})();
var statearr_110578_110592 = state_110566__$1;
(statearr_110578_110592[(2)] = null);

(statearr_110578_110592[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (5))){
var inst_110546 = (state_110566[(7)]);
var state_110566__$1 = state_110566;
var statearr_110579_110593 = state_110566__$1;
(statearr_110579_110593[(2)] = inst_110546);

(statearr_110579_110593[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (10))){
var inst_110560 = (state_110566[(2)]);
var state_110566__$1 = state_110566;
var statearr_110580_110594 = state_110566__$1;
(statearr_110580_110594[(2)] = inst_110560);

(statearr_110580_110594[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110567 === (8))){
var inst_110553 = (state_110566[(9)]);
var inst_110556 = cljs.core.deref(inst_110553);
var state_110566__$1 = state_110566;
var statearr_110581_110595 = state_110566__$1;
(statearr_110581_110595[(2)] = inst_110556);

(statearr_110581_110595[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__109971__auto__ = null;
var cljs$core$async$reduce_$_state_machine__109971__auto____0 = (function (){
var statearr_110582 = [null,null,null,null,null,null,null,null,null,null];
(statearr_110582[(0)] = cljs$core$async$reduce_$_state_machine__109971__auto__);

(statearr_110582[(1)] = (1));

return statearr_110582;
});
var cljs$core$async$reduce_$_state_machine__109971__auto____1 = (function (state_110566){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110566);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110583){if((e110583 instanceof Object)){
var ex__109974__auto__ = e110583;
var statearr_110584_110596 = state_110566;
(statearr_110584_110596[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110566);

return cljs.core.cst$kw$recur;
} else {
throw e110583;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110597 = state_110566;
state_110566 = G__110597;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__109971__auto__ = function(state_110566){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__109971__auto____1.call(this,state_110566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__109971__auto____0;
cljs$core$async$reduce_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__109971__auto____1;
return cljs$core$async$reduce_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_110585 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110585[(6)] = c__110077__auto__);

return statearr_110585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,f__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,f__$1){
return (function (state_110603){
var state_val_110604 = (state_110603[(1)]);
if((state_val_110604 === (1))){
var inst_110598 = cljs.core.async.reduce(f__$1,init,ch);
var state_110603__$1 = state_110603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110603__$1,(2),inst_110598);
} else {
if((state_val_110604 === (2))){
var inst_110600 = (state_110603[(2)]);
var inst_110601 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_110600) : f__$1.call(null,inst_110600));
var state_110603__$1 = state_110603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110603__$1,inst_110601);
} else {
return null;
}
}
});})(c__110077__auto__,f__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__109971__auto__ = null;
var cljs$core$async$transduce_$_state_machine__109971__auto____0 = (function (){
var statearr_110605 = [null,null,null,null,null,null,null];
(statearr_110605[(0)] = cljs$core$async$transduce_$_state_machine__109971__auto__);

(statearr_110605[(1)] = (1));

return statearr_110605;
});
var cljs$core$async$transduce_$_state_machine__109971__auto____1 = (function (state_110603){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110603);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110606){if((e110606 instanceof Object)){
var ex__109974__auto__ = e110606;
var statearr_110607_110609 = state_110603;
(statearr_110607_110609[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110603);

return cljs.core.cst$kw$recur;
} else {
throw e110606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110610 = state_110603;
state_110603 = G__110610;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__109971__auto__ = function(state_110603){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__109971__auto____1.call(this,state_110603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__109971__auto____0;
cljs$core$async$transduce_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__109971__auto____1;
return cljs$core$async$transduce_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,f__$1))
})();
var state__110079__auto__ = (function (){var statearr_110608 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110608[(6)] = c__110077__auto__);

return statearr_110608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,f__$1))
);

return c__110077__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__110612 = arguments.length;
switch (G__110612) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_110637){
var state_val_110638 = (state_110637[(1)]);
if((state_val_110638 === (7))){
var inst_110619 = (state_110637[(2)]);
var state_110637__$1 = state_110637;
var statearr_110639_110660 = state_110637__$1;
(statearr_110639_110660[(2)] = inst_110619);

(statearr_110639_110660[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (1))){
var inst_110613 = cljs.core.seq(coll);
var inst_110614 = inst_110613;
var state_110637__$1 = (function (){var statearr_110640 = state_110637;
(statearr_110640[(7)] = inst_110614);

return statearr_110640;
})();
var statearr_110641_110661 = state_110637__$1;
(statearr_110641_110661[(2)] = null);

(statearr_110641_110661[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (4))){
var inst_110614 = (state_110637[(7)]);
var inst_110617 = cljs.core.first(inst_110614);
var state_110637__$1 = state_110637;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_110637__$1,(7),ch,inst_110617);
} else {
if((state_val_110638 === (13))){
var inst_110631 = (state_110637[(2)]);
var state_110637__$1 = state_110637;
var statearr_110642_110662 = state_110637__$1;
(statearr_110642_110662[(2)] = inst_110631);

(statearr_110642_110662[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (6))){
var inst_110622 = (state_110637[(2)]);
var state_110637__$1 = state_110637;
if(cljs.core.truth_(inst_110622)){
var statearr_110643_110663 = state_110637__$1;
(statearr_110643_110663[(1)] = (8));

} else {
var statearr_110644_110664 = state_110637__$1;
(statearr_110644_110664[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (3))){
var inst_110635 = (state_110637[(2)]);
var state_110637__$1 = state_110637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110637__$1,inst_110635);
} else {
if((state_val_110638 === (12))){
var state_110637__$1 = state_110637;
var statearr_110645_110665 = state_110637__$1;
(statearr_110645_110665[(2)] = null);

(statearr_110645_110665[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (2))){
var inst_110614 = (state_110637[(7)]);
var state_110637__$1 = state_110637;
if(cljs.core.truth_(inst_110614)){
var statearr_110646_110666 = state_110637__$1;
(statearr_110646_110666[(1)] = (4));

} else {
var statearr_110647_110667 = state_110637__$1;
(statearr_110647_110667[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (11))){
var inst_110628 = cljs.core.async.close_BANG_(ch);
var state_110637__$1 = state_110637;
var statearr_110648_110668 = state_110637__$1;
(statearr_110648_110668[(2)] = inst_110628);

(statearr_110648_110668[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (9))){
var state_110637__$1 = state_110637;
if(cljs.core.truth_(close_QMARK_)){
var statearr_110649_110669 = state_110637__$1;
(statearr_110649_110669[(1)] = (11));

} else {
var statearr_110650_110670 = state_110637__$1;
(statearr_110650_110670[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (5))){
var inst_110614 = (state_110637[(7)]);
var state_110637__$1 = state_110637;
var statearr_110651_110671 = state_110637__$1;
(statearr_110651_110671[(2)] = inst_110614);

(statearr_110651_110671[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (10))){
var inst_110633 = (state_110637[(2)]);
var state_110637__$1 = state_110637;
var statearr_110652_110672 = state_110637__$1;
(statearr_110652_110672[(2)] = inst_110633);

(statearr_110652_110672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110638 === (8))){
var inst_110614 = (state_110637[(7)]);
var inst_110624 = cljs.core.next(inst_110614);
var inst_110614__$1 = inst_110624;
var state_110637__$1 = (function (){var statearr_110653 = state_110637;
(statearr_110653[(7)] = inst_110614__$1);

return statearr_110653;
})();
var statearr_110654_110673 = state_110637__$1;
(statearr_110654_110673[(2)] = null);

(statearr_110654_110673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_110655 = [null,null,null,null,null,null,null,null];
(statearr_110655[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_110655[(1)] = (1));

return statearr_110655;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_110637){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110637);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110656){if((e110656 instanceof Object)){
var ex__109974__auto__ = e110656;
var statearr_110657_110674 = state_110637;
(statearr_110657_110674[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110637);

return cljs.core.cst$kw$recur;
} else {
throw e110656;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110675 = state_110637;
state_110637 = G__110675;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_110637){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_110637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_110658 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110658[(6)] = c__110077__auto__);

return statearr_110658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4434__auto__.call(null,_));
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4431__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4434__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4431__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async110676 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async110676 = (function (ch,cs,meta110677){
this.ch = ch;
this.cs = cs;
this.meta110677 = meta110677;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_110678,meta110677__$1){
var self__ = this;
var _110678__$1 = this;
return (new cljs.core.async.t_cljs$core$async110676(self__.ch,self__.cs,meta110677__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_110678){
var self__ = this;
var _110678__$1 = this;
return self__.meta110677;
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta110677], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async110676.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async110676.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async110676";

cljs.core.async.t_cljs$core$async110676.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async110676");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async110676.
 */
cljs.core.async.__GT_t_cljs$core$async110676 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async110676(ch__$1,cs__$1,meta110677){
return (new cljs.core.async.t_cljs$core$async110676(ch__$1,cs__$1,meta110677));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async110676(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__110077__auto___110898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___110898,cs,m,dchan,dctr,done){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___110898,cs,m,dchan,dctr,done){
return (function (state_110813){
var state_val_110814 = (state_110813[(1)]);
if((state_val_110814 === (7))){
var inst_110809 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110815_110899 = state_110813__$1;
(statearr_110815_110899[(2)] = inst_110809);

(statearr_110815_110899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (20))){
var inst_110712 = (state_110813[(7)]);
var inst_110724 = cljs.core.first(inst_110712);
var inst_110725 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110724,(0),null);
var inst_110726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110724,(1),null);
var state_110813__$1 = (function (){var statearr_110816 = state_110813;
(statearr_110816[(8)] = inst_110725);

return statearr_110816;
})();
if(cljs.core.truth_(inst_110726)){
var statearr_110817_110900 = state_110813__$1;
(statearr_110817_110900[(1)] = (22));

} else {
var statearr_110818_110901 = state_110813__$1;
(statearr_110818_110901[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (27))){
var inst_110681 = (state_110813[(9)]);
var inst_110754 = (state_110813[(10)]);
var inst_110756 = (state_110813[(11)]);
var inst_110761 = (state_110813[(12)]);
var inst_110761__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_110754,inst_110756);
var inst_110762 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_110761__$1,inst_110681,done);
var state_110813__$1 = (function (){var statearr_110819 = state_110813;
(statearr_110819[(12)] = inst_110761__$1);

return statearr_110819;
})();
if(cljs.core.truth_(inst_110762)){
var statearr_110820_110902 = state_110813__$1;
(statearr_110820_110902[(1)] = (30));

} else {
var statearr_110821_110903 = state_110813__$1;
(statearr_110821_110903[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (1))){
var state_110813__$1 = state_110813;
var statearr_110822_110904 = state_110813__$1;
(statearr_110822_110904[(2)] = null);

(statearr_110822_110904[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (24))){
var inst_110712 = (state_110813[(7)]);
var inst_110731 = (state_110813[(2)]);
var inst_110732 = cljs.core.next(inst_110712);
var inst_110690 = inst_110732;
var inst_110691 = null;
var inst_110692 = (0);
var inst_110693 = (0);
var state_110813__$1 = (function (){var statearr_110823 = state_110813;
(statearr_110823[(13)] = inst_110690);

(statearr_110823[(14)] = inst_110691);

(statearr_110823[(15)] = inst_110693);

(statearr_110823[(16)] = inst_110692);

(statearr_110823[(17)] = inst_110731);

return statearr_110823;
})();
var statearr_110824_110905 = state_110813__$1;
(statearr_110824_110905[(2)] = null);

(statearr_110824_110905[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (39))){
var state_110813__$1 = state_110813;
var statearr_110828_110906 = state_110813__$1;
(statearr_110828_110906[(2)] = null);

(statearr_110828_110906[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (4))){
var inst_110681 = (state_110813[(9)]);
var inst_110681__$1 = (state_110813[(2)]);
var inst_110682 = (inst_110681__$1 == null);
var state_110813__$1 = (function (){var statearr_110829 = state_110813;
(statearr_110829[(9)] = inst_110681__$1);

return statearr_110829;
})();
if(cljs.core.truth_(inst_110682)){
var statearr_110830_110907 = state_110813__$1;
(statearr_110830_110907[(1)] = (5));

} else {
var statearr_110831_110908 = state_110813__$1;
(statearr_110831_110908[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (15))){
var inst_110690 = (state_110813[(13)]);
var inst_110691 = (state_110813[(14)]);
var inst_110693 = (state_110813[(15)]);
var inst_110692 = (state_110813[(16)]);
var inst_110708 = (state_110813[(2)]);
var inst_110709 = (inst_110693 + (1));
var tmp110825 = inst_110690;
var tmp110826 = inst_110691;
var tmp110827 = inst_110692;
var inst_110690__$1 = tmp110825;
var inst_110691__$1 = tmp110826;
var inst_110692__$1 = tmp110827;
var inst_110693__$1 = inst_110709;
var state_110813__$1 = (function (){var statearr_110832 = state_110813;
(statearr_110832[(13)] = inst_110690__$1);

(statearr_110832[(18)] = inst_110708);

(statearr_110832[(14)] = inst_110691__$1);

(statearr_110832[(15)] = inst_110693__$1);

(statearr_110832[(16)] = inst_110692__$1);

return statearr_110832;
})();
var statearr_110833_110909 = state_110813__$1;
(statearr_110833_110909[(2)] = null);

(statearr_110833_110909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (21))){
var inst_110735 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110837_110910 = state_110813__$1;
(statearr_110837_110910[(2)] = inst_110735);

(statearr_110837_110910[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (31))){
var inst_110761 = (state_110813[(12)]);
var inst_110765 = done(null);
var inst_110766 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_110761);
var state_110813__$1 = (function (){var statearr_110838 = state_110813;
(statearr_110838[(19)] = inst_110765);

return statearr_110838;
})();
var statearr_110839_110911 = state_110813__$1;
(statearr_110839_110911[(2)] = inst_110766);

(statearr_110839_110911[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (32))){
var inst_110753 = (state_110813[(20)]);
var inst_110755 = (state_110813[(21)]);
var inst_110754 = (state_110813[(10)]);
var inst_110756 = (state_110813[(11)]);
var inst_110768 = (state_110813[(2)]);
var inst_110769 = (inst_110756 + (1));
var tmp110834 = inst_110753;
var tmp110835 = inst_110755;
var tmp110836 = inst_110754;
var inst_110753__$1 = tmp110834;
var inst_110754__$1 = tmp110836;
var inst_110755__$1 = tmp110835;
var inst_110756__$1 = inst_110769;
var state_110813__$1 = (function (){var statearr_110840 = state_110813;
(statearr_110840[(20)] = inst_110753__$1);

(statearr_110840[(21)] = inst_110755__$1);

(statearr_110840[(22)] = inst_110768);

(statearr_110840[(10)] = inst_110754__$1);

(statearr_110840[(11)] = inst_110756__$1);

return statearr_110840;
})();
var statearr_110841_110912 = state_110813__$1;
(statearr_110841_110912[(2)] = null);

(statearr_110841_110912[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (40))){
var inst_110781 = (state_110813[(23)]);
var inst_110785 = done(null);
var inst_110786 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_110781);
var state_110813__$1 = (function (){var statearr_110842 = state_110813;
(statearr_110842[(24)] = inst_110785);

return statearr_110842;
})();
var statearr_110843_110913 = state_110813__$1;
(statearr_110843_110913[(2)] = inst_110786);

(statearr_110843_110913[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (33))){
var inst_110772 = (state_110813[(25)]);
var inst_110774 = cljs.core.chunked_seq_QMARK_(inst_110772);
var state_110813__$1 = state_110813;
if(inst_110774){
var statearr_110844_110914 = state_110813__$1;
(statearr_110844_110914[(1)] = (36));

} else {
var statearr_110845_110915 = state_110813__$1;
(statearr_110845_110915[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (13))){
var inst_110702 = (state_110813[(26)]);
var inst_110705 = cljs.core.async.close_BANG_(inst_110702);
var state_110813__$1 = state_110813;
var statearr_110846_110916 = state_110813__$1;
(statearr_110846_110916[(2)] = inst_110705);

(statearr_110846_110916[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (22))){
var inst_110725 = (state_110813[(8)]);
var inst_110728 = cljs.core.async.close_BANG_(inst_110725);
var state_110813__$1 = state_110813;
var statearr_110847_110917 = state_110813__$1;
(statearr_110847_110917[(2)] = inst_110728);

(statearr_110847_110917[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (36))){
var inst_110772 = (state_110813[(25)]);
var inst_110776 = cljs.core.chunk_first(inst_110772);
var inst_110777 = cljs.core.chunk_rest(inst_110772);
var inst_110778 = cljs.core.count(inst_110776);
var inst_110753 = inst_110777;
var inst_110754 = inst_110776;
var inst_110755 = inst_110778;
var inst_110756 = (0);
var state_110813__$1 = (function (){var statearr_110848 = state_110813;
(statearr_110848[(20)] = inst_110753);

(statearr_110848[(21)] = inst_110755);

(statearr_110848[(10)] = inst_110754);

(statearr_110848[(11)] = inst_110756);

return statearr_110848;
})();
var statearr_110849_110918 = state_110813__$1;
(statearr_110849_110918[(2)] = null);

(statearr_110849_110918[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (41))){
var inst_110772 = (state_110813[(25)]);
var inst_110788 = (state_110813[(2)]);
var inst_110789 = cljs.core.next(inst_110772);
var inst_110753 = inst_110789;
var inst_110754 = null;
var inst_110755 = (0);
var inst_110756 = (0);
var state_110813__$1 = (function (){var statearr_110850 = state_110813;
(statearr_110850[(20)] = inst_110753);

(statearr_110850[(21)] = inst_110755);

(statearr_110850[(27)] = inst_110788);

(statearr_110850[(10)] = inst_110754);

(statearr_110850[(11)] = inst_110756);

return statearr_110850;
})();
var statearr_110851_110919 = state_110813__$1;
(statearr_110851_110919[(2)] = null);

(statearr_110851_110919[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (43))){
var state_110813__$1 = state_110813;
var statearr_110852_110920 = state_110813__$1;
(statearr_110852_110920[(2)] = null);

(statearr_110852_110920[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (29))){
var inst_110797 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110853_110921 = state_110813__$1;
(statearr_110853_110921[(2)] = inst_110797);

(statearr_110853_110921[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (44))){
var inst_110806 = (state_110813[(2)]);
var state_110813__$1 = (function (){var statearr_110854 = state_110813;
(statearr_110854[(28)] = inst_110806);

return statearr_110854;
})();
var statearr_110855_110922 = state_110813__$1;
(statearr_110855_110922[(2)] = null);

(statearr_110855_110922[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (6))){
var inst_110745 = (state_110813[(29)]);
var inst_110744 = cljs.core.deref(cs);
var inst_110745__$1 = cljs.core.keys(inst_110744);
var inst_110746 = cljs.core.count(inst_110745__$1);
var inst_110747 = cljs.core.reset_BANG_(dctr,inst_110746);
var inst_110752 = cljs.core.seq(inst_110745__$1);
var inst_110753 = inst_110752;
var inst_110754 = null;
var inst_110755 = (0);
var inst_110756 = (0);
var state_110813__$1 = (function (){var statearr_110856 = state_110813;
(statearr_110856[(20)] = inst_110753);

(statearr_110856[(21)] = inst_110755);

(statearr_110856[(30)] = inst_110747);

(statearr_110856[(10)] = inst_110754);

(statearr_110856[(29)] = inst_110745__$1);

(statearr_110856[(11)] = inst_110756);

return statearr_110856;
})();
var statearr_110857_110923 = state_110813__$1;
(statearr_110857_110923[(2)] = null);

(statearr_110857_110923[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (28))){
var inst_110753 = (state_110813[(20)]);
var inst_110772 = (state_110813[(25)]);
var inst_110772__$1 = cljs.core.seq(inst_110753);
var state_110813__$1 = (function (){var statearr_110858 = state_110813;
(statearr_110858[(25)] = inst_110772__$1);

return statearr_110858;
})();
if(inst_110772__$1){
var statearr_110859_110924 = state_110813__$1;
(statearr_110859_110924[(1)] = (33));

} else {
var statearr_110860_110925 = state_110813__$1;
(statearr_110860_110925[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (25))){
var inst_110755 = (state_110813[(21)]);
var inst_110756 = (state_110813[(11)]);
var inst_110758 = (inst_110756 < inst_110755);
var inst_110759 = inst_110758;
var state_110813__$1 = state_110813;
if(cljs.core.truth_(inst_110759)){
var statearr_110861_110926 = state_110813__$1;
(statearr_110861_110926[(1)] = (27));

} else {
var statearr_110862_110927 = state_110813__$1;
(statearr_110862_110927[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (34))){
var state_110813__$1 = state_110813;
var statearr_110863_110928 = state_110813__$1;
(statearr_110863_110928[(2)] = null);

(statearr_110863_110928[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (17))){
var state_110813__$1 = state_110813;
var statearr_110864_110929 = state_110813__$1;
(statearr_110864_110929[(2)] = null);

(statearr_110864_110929[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (3))){
var inst_110811 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110813__$1,inst_110811);
} else {
if((state_val_110814 === (12))){
var inst_110740 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110865_110930 = state_110813__$1;
(statearr_110865_110930[(2)] = inst_110740);

(statearr_110865_110930[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (2))){
var state_110813__$1 = state_110813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110813__$1,(4),ch);
} else {
if((state_val_110814 === (23))){
var state_110813__$1 = state_110813;
var statearr_110866_110931 = state_110813__$1;
(statearr_110866_110931[(2)] = null);

(statearr_110866_110931[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (35))){
var inst_110795 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110867_110932 = state_110813__$1;
(statearr_110867_110932[(2)] = inst_110795);

(statearr_110867_110932[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (19))){
var inst_110712 = (state_110813[(7)]);
var inst_110716 = cljs.core.chunk_first(inst_110712);
var inst_110717 = cljs.core.chunk_rest(inst_110712);
var inst_110718 = cljs.core.count(inst_110716);
var inst_110690 = inst_110717;
var inst_110691 = inst_110716;
var inst_110692 = inst_110718;
var inst_110693 = (0);
var state_110813__$1 = (function (){var statearr_110868 = state_110813;
(statearr_110868[(13)] = inst_110690);

(statearr_110868[(14)] = inst_110691);

(statearr_110868[(15)] = inst_110693);

(statearr_110868[(16)] = inst_110692);

return statearr_110868;
})();
var statearr_110869_110933 = state_110813__$1;
(statearr_110869_110933[(2)] = null);

(statearr_110869_110933[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (11))){
var inst_110690 = (state_110813[(13)]);
var inst_110712 = (state_110813[(7)]);
var inst_110712__$1 = cljs.core.seq(inst_110690);
var state_110813__$1 = (function (){var statearr_110870 = state_110813;
(statearr_110870[(7)] = inst_110712__$1);

return statearr_110870;
})();
if(inst_110712__$1){
var statearr_110871_110934 = state_110813__$1;
(statearr_110871_110934[(1)] = (16));

} else {
var statearr_110872_110935 = state_110813__$1;
(statearr_110872_110935[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (9))){
var inst_110742 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110873_110936 = state_110813__$1;
(statearr_110873_110936[(2)] = inst_110742);

(statearr_110873_110936[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (5))){
var inst_110688 = cljs.core.deref(cs);
var inst_110689 = cljs.core.seq(inst_110688);
var inst_110690 = inst_110689;
var inst_110691 = null;
var inst_110692 = (0);
var inst_110693 = (0);
var state_110813__$1 = (function (){var statearr_110874 = state_110813;
(statearr_110874[(13)] = inst_110690);

(statearr_110874[(14)] = inst_110691);

(statearr_110874[(15)] = inst_110693);

(statearr_110874[(16)] = inst_110692);

return statearr_110874;
})();
var statearr_110875_110937 = state_110813__$1;
(statearr_110875_110937[(2)] = null);

(statearr_110875_110937[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (14))){
var state_110813__$1 = state_110813;
var statearr_110876_110938 = state_110813__$1;
(statearr_110876_110938[(2)] = null);

(statearr_110876_110938[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (45))){
var inst_110803 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110877_110939 = state_110813__$1;
(statearr_110877_110939[(2)] = inst_110803);

(statearr_110877_110939[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (26))){
var inst_110745 = (state_110813[(29)]);
var inst_110799 = (state_110813[(2)]);
var inst_110800 = cljs.core.seq(inst_110745);
var state_110813__$1 = (function (){var statearr_110878 = state_110813;
(statearr_110878[(31)] = inst_110799);

return statearr_110878;
})();
if(inst_110800){
var statearr_110879_110940 = state_110813__$1;
(statearr_110879_110940[(1)] = (42));

} else {
var statearr_110880_110941 = state_110813__$1;
(statearr_110880_110941[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (16))){
var inst_110712 = (state_110813[(7)]);
var inst_110714 = cljs.core.chunked_seq_QMARK_(inst_110712);
var state_110813__$1 = state_110813;
if(inst_110714){
var statearr_110881_110942 = state_110813__$1;
(statearr_110881_110942[(1)] = (19));

} else {
var statearr_110882_110943 = state_110813__$1;
(statearr_110882_110943[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (38))){
var inst_110792 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110883_110944 = state_110813__$1;
(statearr_110883_110944[(2)] = inst_110792);

(statearr_110883_110944[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (30))){
var state_110813__$1 = state_110813;
var statearr_110884_110945 = state_110813__$1;
(statearr_110884_110945[(2)] = null);

(statearr_110884_110945[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (10))){
var inst_110691 = (state_110813[(14)]);
var inst_110693 = (state_110813[(15)]);
var inst_110701 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_110691,inst_110693);
var inst_110702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110701,(0),null);
var inst_110703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110701,(1),null);
var state_110813__$1 = (function (){var statearr_110885 = state_110813;
(statearr_110885[(26)] = inst_110702);

return statearr_110885;
})();
if(cljs.core.truth_(inst_110703)){
var statearr_110886_110946 = state_110813__$1;
(statearr_110886_110946[(1)] = (13));

} else {
var statearr_110887_110947 = state_110813__$1;
(statearr_110887_110947[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (18))){
var inst_110738 = (state_110813[(2)]);
var state_110813__$1 = state_110813;
var statearr_110888_110948 = state_110813__$1;
(statearr_110888_110948[(2)] = inst_110738);

(statearr_110888_110948[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (42))){
var state_110813__$1 = state_110813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110813__$1,(45),dchan);
} else {
if((state_val_110814 === (37))){
var inst_110681 = (state_110813[(9)]);
var inst_110781 = (state_110813[(23)]);
var inst_110772 = (state_110813[(25)]);
var inst_110781__$1 = cljs.core.first(inst_110772);
var inst_110782 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_110781__$1,inst_110681,done);
var state_110813__$1 = (function (){var statearr_110889 = state_110813;
(statearr_110889[(23)] = inst_110781__$1);

return statearr_110889;
})();
if(cljs.core.truth_(inst_110782)){
var statearr_110890_110949 = state_110813__$1;
(statearr_110890_110949[(1)] = (39));

} else {
var statearr_110891_110950 = state_110813__$1;
(statearr_110891_110950[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110814 === (8))){
var inst_110693 = (state_110813[(15)]);
var inst_110692 = (state_110813[(16)]);
var inst_110695 = (inst_110693 < inst_110692);
var inst_110696 = inst_110695;
var state_110813__$1 = state_110813;
if(cljs.core.truth_(inst_110696)){
var statearr_110892_110951 = state_110813__$1;
(statearr_110892_110951[(1)] = (10));

} else {
var statearr_110893_110952 = state_110813__$1;
(statearr_110893_110952[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___110898,cs,m,dchan,dctr,done))
;
return ((function (switch__109970__auto__,c__110077__auto___110898,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__109971__auto__ = null;
var cljs$core$async$mult_$_state_machine__109971__auto____0 = (function (){
var statearr_110894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110894[(0)] = cljs$core$async$mult_$_state_machine__109971__auto__);

(statearr_110894[(1)] = (1));

return statearr_110894;
});
var cljs$core$async$mult_$_state_machine__109971__auto____1 = (function (state_110813){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_110813);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e110895){if((e110895 instanceof Object)){
var ex__109974__auto__ = e110895;
var statearr_110896_110953 = state_110813;
(statearr_110896_110953[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110813);

return cljs.core.cst$kw$recur;
} else {
throw e110895;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__110954 = state_110813;
state_110813 = G__110954;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__109971__auto__ = function(state_110813){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__109971__auto____1.call(this,state_110813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__109971__auto____0;
cljs$core$async$mult_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__109971__auto____1;
return cljs$core$async$mult_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___110898,cs,m,dchan,dctr,done))
})();
var state__110079__auto__ = (function (){var statearr_110897 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_110897[(6)] = c__110077__auto___110898);

return statearr_110897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___110898,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__110956 = arguments.length;
switch (G__110956) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4434__auto__.call(null,m,state_map));
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4431__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4434__auto__.call(null,m,mode));
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4431__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___110968 = arguments.length;
var i__4731__auto___110969 = (0);
while(true){
if((i__4731__auto___110969 < len__4730__auto___110968)){
args__4736__auto__.push((arguments[i__4731__auto___110969]));

var G__110970 = (i__4731__auto___110969 + (1));
i__4731__auto___110969 = G__110970;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__110962){
var map__110963 = p__110962;
var map__110963__$1 = (((((!((map__110963 == null))))?(((((map__110963.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110963.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110963):map__110963);
var opts = map__110963__$1;
var statearr_110965_110971 = state;
(statearr_110965_110971[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts(((function (map__110963,map__110963__$1,opts){
return (function (val){
var statearr_110966_110972 = state;
(statearr_110966_110972[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__110963,map__110963__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_110967_110973 = state;
(statearr_110967_110973[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq110958){
var G__110959 = cljs.core.first(seq110958);
var seq110958__$1 = cljs.core.next(seq110958);
var G__110960 = cljs.core.first(seq110958__$1);
var seq110958__$2 = cljs.core.next(seq110958__$1);
var G__110961 = cljs.core.first(seq110958__$2);
var seq110958__$3 = cljs.core.next(seq110958__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__110959,G__110960,G__110961,seq110958__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async110974 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async110974 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta110975){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta110975 = meta110975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_110976,meta110975__$1){
var self__ = this;
var _110976__$1 = this;
return (new cljs.core.async.t_cljs$core$async110974(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta110975__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_110976){
var self__ = this;
var _110976__$1 = this;
return self__.meta110975;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta110975], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async110974.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async110974.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async110974";

cljs.core.async.t_cljs$core$async110974.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async110974");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async110974.
 */
cljs.core.async.__GT_t_cljs$core$async110974 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async110974(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta110975){
return (new cljs.core.async.t_cljs$core$async110974(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta110975));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async110974(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__110077__auto___111138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_111078){
var state_val_111079 = (state_111078[(1)]);
if((state_val_111079 === (7))){
var inst_110993 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
var statearr_111080_111139 = state_111078__$1;
(statearr_111080_111139[(2)] = inst_110993);

(statearr_111080_111139[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (20))){
var inst_111005 = (state_111078[(7)]);
var state_111078__$1 = state_111078;
var statearr_111081_111140 = state_111078__$1;
(statearr_111081_111140[(2)] = inst_111005);

(statearr_111081_111140[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (27))){
var state_111078__$1 = state_111078;
var statearr_111082_111141 = state_111078__$1;
(statearr_111082_111141[(2)] = null);

(statearr_111082_111141[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (1))){
var inst_110980 = (state_111078[(8)]);
var inst_110980__$1 = calc_state();
var inst_110982 = (inst_110980__$1 == null);
var inst_110983 = cljs.core.not(inst_110982);
var state_111078__$1 = (function (){var statearr_111083 = state_111078;
(statearr_111083[(8)] = inst_110980__$1);

return statearr_111083;
})();
if(inst_110983){
var statearr_111084_111142 = state_111078__$1;
(statearr_111084_111142[(1)] = (2));

} else {
var statearr_111085_111143 = state_111078__$1;
(statearr_111085_111143[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (24))){
var inst_111052 = (state_111078[(9)]);
var inst_111038 = (state_111078[(10)]);
var inst_111029 = (state_111078[(11)]);
var inst_111052__$1 = (inst_111029.cljs$core$IFn$_invoke$arity$1 ? inst_111029.cljs$core$IFn$_invoke$arity$1(inst_111038) : inst_111029.call(null,inst_111038));
var state_111078__$1 = (function (){var statearr_111086 = state_111078;
(statearr_111086[(9)] = inst_111052__$1);

return statearr_111086;
})();
if(cljs.core.truth_(inst_111052__$1)){
var statearr_111087_111144 = state_111078__$1;
(statearr_111087_111144[(1)] = (29));

} else {
var statearr_111088_111145 = state_111078__$1;
(statearr_111088_111145[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (4))){
var inst_110996 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_110996)){
var statearr_111089_111146 = state_111078__$1;
(statearr_111089_111146[(1)] = (8));

} else {
var statearr_111090_111147 = state_111078__$1;
(statearr_111090_111147[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (15))){
var inst_111023 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_111023)){
var statearr_111091_111148 = state_111078__$1;
(statearr_111091_111148[(1)] = (19));

} else {
var statearr_111092_111149 = state_111078__$1;
(statearr_111092_111149[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (21))){
var inst_111028 = (state_111078[(12)]);
var inst_111028__$1 = (state_111078[(2)]);
var inst_111029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111028__$1,cljs.core.cst$kw$solos);
var inst_111030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111028__$1,cljs.core.cst$kw$mutes);
var inst_111031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111028__$1,cljs.core.cst$kw$reads);
var state_111078__$1 = (function (){var statearr_111093 = state_111078;
(statearr_111093[(13)] = inst_111030);

(statearr_111093[(12)] = inst_111028__$1);

(statearr_111093[(11)] = inst_111029);

return statearr_111093;
})();
return cljs.core.async.ioc_alts_BANG_(state_111078__$1,(22),inst_111031);
} else {
if((state_val_111079 === (31))){
var inst_111060 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_111060)){
var statearr_111094_111150 = state_111078__$1;
(statearr_111094_111150[(1)] = (32));

} else {
var statearr_111095_111151 = state_111078__$1;
(statearr_111095_111151[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (32))){
var inst_111037 = (state_111078[(14)]);
var state_111078__$1 = state_111078;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111078__$1,(35),out,inst_111037);
} else {
if((state_val_111079 === (33))){
var inst_111028 = (state_111078[(12)]);
var inst_111005 = inst_111028;
var state_111078__$1 = (function (){var statearr_111096 = state_111078;
(statearr_111096[(7)] = inst_111005);

return statearr_111096;
})();
var statearr_111097_111152 = state_111078__$1;
(statearr_111097_111152[(2)] = null);

(statearr_111097_111152[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (13))){
var inst_111005 = (state_111078[(7)]);
var inst_111012 = inst_111005.cljs$lang$protocol_mask$partition0$;
var inst_111013 = (inst_111012 & (64));
var inst_111014 = inst_111005.cljs$core$ISeq$;
var inst_111015 = (cljs.core.PROTOCOL_SENTINEL === inst_111014);
var inst_111016 = ((inst_111013) || (inst_111015));
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_111016)){
var statearr_111098_111153 = state_111078__$1;
(statearr_111098_111153[(1)] = (16));

} else {
var statearr_111099_111154 = state_111078__$1;
(statearr_111099_111154[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (22))){
var inst_111037 = (state_111078[(14)]);
var inst_111038 = (state_111078[(10)]);
var inst_111036 = (state_111078[(2)]);
var inst_111037__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111036,(0),null);
var inst_111038__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111036,(1),null);
var inst_111039 = (inst_111037__$1 == null);
var inst_111040 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_111038__$1,change);
var inst_111041 = ((inst_111039) || (inst_111040));
var state_111078__$1 = (function (){var statearr_111100 = state_111078;
(statearr_111100[(14)] = inst_111037__$1);

(statearr_111100[(10)] = inst_111038__$1);

return statearr_111100;
})();
if(cljs.core.truth_(inst_111041)){
var statearr_111101_111155 = state_111078__$1;
(statearr_111101_111155[(1)] = (23));

} else {
var statearr_111102_111156 = state_111078__$1;
(statearr_111102_111156[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (36))){
var inst_111028 = (state_111078[(12)]);
var inst_111005 = inst_111028;
var state_111078__$1 = (function (){var statearr_111103 = state_111078;
(statearr_111103[(7)] = inst_111005);

return statearr_111103;
})();
var statearr_111104_111157 = state_111078__$1;
(statearr_111104_111157[(2)] = null);

(statearr_111104_111157[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (29))){
var inst_111052 = (state_111078[(9)]);
var state_111078__$1 = state_111078;
var statearr_111105_111158 = state_111078__$1;
(statearr_111105_111158[(2)] = inst_111052);

(statearr_111105_111158[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (6))){
var state_111078__$1 = state_111078;
var statearr_111106_111159 = state_111078__$1;
(statearr_111106_111159[(2)] = false);

(statearr_111106_111159[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (28))){
var inst_111048 = (state_111078[(2)]);
var inst_111049 = calc_state();
var inst_111005 = inst_111049;
var state_111078__$1 = (function (){var statearr_111107 = state_111078;
(statearr_111107[(15)] = inst_111048);

(statearr_111107[(7)] = inst_111005);

return statearr_111107;
})();
var statearr_111108_111160 = state_111078__$1;
(statearr_111108_111160[(2)] = null);

(statearr_111108_111160[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (25))){
var inst_111074 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
var statearr_111109_111161 = state_111078__$1;
(statearr_111109_111161[(2)] = inst_111074);

(statearr_111109_111161[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (34))){
var inst_111072 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
var statearr_111110_111162 = state_111078__$1;
(statearr_111110_111162[(2)] = inst_111072);

(statearr_111110_111162[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (17))){
var state_111078__$1 = state_111078;
var statearr_111111_111163 = state_111078__$1;
(statearr_111111_111163[(2)] = false);

(statearr_111111_111163[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (3))){
var state_111078__$1 = state_111078;
var statearr_111112_111164 = state_111078__$1;
(statearr_111112_111164[(2)] = false);

(statearr_111112_111164[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (12))){
var inst_111076 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111078__$1,inst_111076);
} else {
if((state_val_111079 === (2))){
var inst_110980 = (state_111078[(8)]);
var inst_110985 = inst_110980.cljs$lang$protocol_mask$partition0$;
var inst_110986 = (inst_110985 & (64));
var inst_110987 = inst_110980.cljs$core$ISeq$;
var inst_110988 = (cljs.core.PROTOCOL_SENTINEL === inst_110987);
var inst_110989 = ((inst_110986) || (inst_110988));
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_110989)){
var statearr_111113_111165 = state_111078__$1;
(statearr_111113_111165[(1)] = (5));

} else {
var statearr_111114_111166 = state_111078__$1;
(statearr_111114_111166[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (23))){
var inst_111037 = (state_111078[(14)]);
var inst_111043 = (inst_111037 == null);
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_111043)){
var statearr_111115_111167 = state_111078__$1;
(statearr_111115_111167[(1)] = (26));

} else {
var statearr_111116_111168 = state_111078__$1;
(statearr_111116_111168[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (35))){
var inst_111063 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
if(cljs.core.truth_(inst_111063)){
var statearr_111117_111169 = state_111078__$1;
(statearr_111117_111169[(1)] = (36));

} else {
var statearr_111118_111170 = state_111078__$1;
(statearr_111118_111170[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (19))){
var inst_111005 = (state_111078[(7)]);
var inst_111025 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_111005);
var state_111078__$1 = state_111078;
var statearr_111119_111171 = state_111078__$1;
(statearr_111119_111171[(2)] = inst_111025);

(statearr_111119_111171[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (11))){
var inst_111005 = (state_111078[(7)]);
var inst_111009 = (inst_111005 == null);
var inst_111010 = cljs.core.not(inst_111009);
var state_111078__$1 = state_111078;
if(inst_111010){
var statearr_111120_111172 = state_111078__$1;
(statearr_111120_111172[(1)] = (13));

} else {
var statearr_111121_111173 = state_111078__$1;
(statearr_111121_111173[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (9))){
var inst_110980 = (state_111078[(8)]);
var state_111078__$1 = state_111078;
var statearr_111122_111174 = state_111078__$1;
(statearr_111122_111174[(2)] = inst_110980);

(statearr_111122_111174[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (5))){
var state_111078__$1 = state_111078;
var statearr_111123_111175 = state_111078__$1;
(statearr_111123_111175[(2)] = true);

(statearr_111123_111175[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (14))){
var state_111078__$1 = state_111078;
var statearr_111124_111176 = state_111078__$1;
(statearr_111124_111176[(2)] = false);

(statearr_111124_111176[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (26))){
var inst_111038 = (state_111078[(10)]);
var inst_111045 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_111038);
var state_111078__$1 = state_111078;
var statearr_111125_111177 = state_111078__$1;
(statearr_111125_111177[(2)] = inst_111045);

(statearr_111125_111177[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (16))){
var state_111078__$1 = state_111078;
var statearr_111126_111178 = state_111078__$1;
(statearr_111126_111178[(2)] = true);

(statearr_111126_111178[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (38))){
var inst_111068 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
var statearr_111127_111179 = state_111078__$1;
(statearr_111127_111179[(2)] = inst_111068);

(statearr_111127_111179[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (30))){
var inst_111030 = (state_111078[(13)]);
var inst_111038 = (state_111078[(10)]);
var inst_111029 = (state_111078[(11)]);
var inst_111055 = cljs.core.empty_QMARK_(inst_111029);
var inst_111056 = (inst_111030.cljs$core$IFn$_invoke$arity$1 ? inst_111030.cljs$core$IFn$_invoke$arity$1(inst_111038) : inst_111030.call(null,inst_111038));
var inst_111057 = cljs.core.not(inst_111056);
var inst_111058 = ((inst_111055) && (inst_111057));
var state_111078__$1 = state_111078;
var statearr_111128_111180 = state_111078__$1;
(statearr_111128_111180[(2)] = inst_111058);

(statearr_111128_111180[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (10))){
var inst_110980 = (state_111078[(8)]);
var inst_111001 = (state_111078[(2)]);
var inst_111002 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111001,cljs.core.cst$kw$solos);
var inst_111003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111001,cljs.core.cst$kw$mutes);
var inst_111004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111001,cljs.core.cst$kw$reads);
var inst_111005 = inst_110980;
var state_111078__$1 = (function (){var statearr_111129 = state_111078;
(statearr_111129[(16)] = inst_111002);

(statearr_111129[(17)] = inst_111003);

(statearr_111129[(18)] = inst_111004);

(statearr_111129[(7)] = inst_111005);

return statearr_111129;
})();
var statearr_111130_111181 = state_111078__$1;
(statearr_111130_111181[(2)] = null);

(statearr_111130_111181[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (18))){
var inst_111020 = (state_111078[(2)]);
var state_111078__$1 = state_111078;
var statearr_111131_111182 = state_111078__$1;
(statearr_111131_111182[(2)] = inst_111020);

(statearr_111131_111182[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (37))){
var state_111078__$1 = state_111078;
var statearr_111132_111183 = state_111078__$1;
(statearr_111132_111183[(2)] = null);

(statearr_111132_111183[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111079 === (8))){
var inst_110980 = (state_111078[(8)]);
var inst_110998 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_110980);
var state_111078__$1 = state_111078;
var statearr_111133_111184 = state_111078__$1;
(statearr_111133_111184[(2)] = inst_110998);

(statearr_111133_111184[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__109970__auto__,c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__109971__auto__ = null;
var cljs$core$async$mix_$_state_machine__109971__auto____0 = (function (){
var statearr_111134 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111134[(0)] = cljs$core$async$mix_$_state_machine__109971__auto__);

(statearr_111134[(1)] = (1));

return statearr_111134;
});
var cljs$core$async$mix_$_state_machine__109971__auto____1 = (function (state_111078){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111078);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111135){if((e111135 instanceof Object)){
var ex__109974__auto__ = e111135;
var statearr_111136_111185 = state_111078;
(statearr_111136_111185[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111078);

return cljs.core.cst$kw$recur;
} else {
throw e111135;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111186 = state_111078;
state_111078 = G__111186;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__109971__auto__ = function(state_111078){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__109971__auto____1.call(this,state_111078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__109971__auto____0;
cljs$core$async$mix_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__109971__auto____1;
return cljs$core$async$mix_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__110079__auto__ = (function (){var statearr_111137 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111137[(6)] = c__110077__auto___111138);

return statearr_111137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111138,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4434__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4431__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4434__auto__.call(null,p,v,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4431__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__111188 = arguments.length;
switch (G__111188) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4434__auto__.call(null,p));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4431__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4434__auto__.call(null,p,v));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4431__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__111192 = arguments.length;
switch (G__111192) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4131__auto__,mults){
return (function (p1__111190_SHARP_){
if(cljs.core.truth_((p1__111190_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__111190_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__111190_SHARP_.call(null,topic)))){
return p1__111190_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__111190_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async111193 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async111193 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta111194){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta111194 = meta111194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_111195,meta111194__$1){
var self__ = this;
var _111195__$1 = this;
return (new cljs.core.async.t_cljs$core$async111193(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta111194__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_111195){
var self__ = this;
var _111195__$1 = this;
return self__.meta111194;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta111194], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async111193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async111193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async111193";

cljs.core.async.t_cljs$core$async111193.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async111193");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async111193.
 */
cljs.core.async.__GT_t_cljs$core$async111193 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async111193(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta111194){
return (new cljs.core.async.t_cljs$core$async111193(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta111194));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async111193(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__110077__auto___111313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111313,mults,ensure_mult,p){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111313,mults,ensure_mult,p){
return (function (state_111267){
var state_val_111268 = (state_111267[(1)]);
if((state_val_111268 === (7))){
var inst_111263 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111269_111314 = state_111267__$1;
(statearr_111269_111314[(2)] = inst_111263);

(statearr_111269_111314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (20))){
var state_111267__$1 = state_111267;
var statearr_111270_111315 = state_111267__$1;
(statearr_111270_111315[(2)] = null);

(statearr_111270_111315[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (1))){
var state_111267__$1 = state_111267;
var statearr_111271_111316 = state_111267__$1;
(statearr_111271_111316[(2)] = null);

(statearr_111271_111316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (24))){
var inst_111246 = (state_111267[(7)]);
var inst_111255 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_111246);
var state_111267__$1 = state_111267;
var statearr_111272_111317 = state_111267__$1;
(statearr_111272_111317[(2)] = inst_111255);

(statearr_111272_111317[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (4))){
var inst_111198 = (state_111267[(8)]);
var inst_111198__$1 = (state_111267[(2)]);
var inst_111199 = (inst_111198__$1 == null);
var state_111267__$1 = (function (){var statearr_111273 = state_111267;
(statearr_111273[(8)] = inst_111198__$1);

return statearr_111273;
})();
if(cljs.core.truth_(inst_111199)){
var statearr_111274_111318 = state_111267__$1;
(statearr_111274_111318[(1)] = (5));

} else {
var statearr_111275_111319 = state_111267__$1;
(statearr_111275_111319[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (15))){
var inst_111240 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111276_111320 = state_111267__$1;
(statearr_111276_111320[(2)] = inst_111240);

(statearr_111276_111320[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (21))){
var inst_111260 = (state_111267[(2)]);
var state_111267__$1 = (function (){var statearr_111277 = state_111267;
(statearr_111277[(9)] = inst_111260);

return statearr_111277;
})();
var statearr_111278_111321 = state_111267__$1;
(statearr_111278_111321[(2)] = null);

(statearr_111278_111321[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (13))){
var inst_111222 = (state_111267[(10)]);
var inst_111224 = cljs.core.chunked_seq_QMARK_(inst_111222);
var state_111267__$1 = state_111267;
if(inst_111224){
var statearr_111279_111322 = state_111267__$1;
(statearr_111279_111322[(1)] = (16));

} else {
var statearr_111280_111323 = state_111267__$1;
(statearr_111280_111323[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (22))){
var inst_111252 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
if(cljs.core.truth_(inst_111252)){
var statearr_111281_111324 = state_111267__$1;
(statearr_111281_111324[(1)] = (23));

} else {
var statearr_111282_111325 = state_111267__$1;
(statearr_111282_111325[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (6))){
var inst_111198 = (state_111267[(8)]);
var inst_111248 = (state_111267[(11)]);
var inst_111246 = (state_111267[(7)]);
var inst_111246__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_111198) : topic_fn.call(null,inst_111198));
var inst_111247 = cljs.core.deref(mults);
var inst_111248__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_111247,inst_111246__$1);
var state_111267__$1 = (function (){var statearr_111283 = state_111267;
(statearr_111283[(11)] = inst_111248__$1);

(statearr_111283[(7)] = inst_111246__$1);

return statearr_111283;
})();
if(cljs.core.truth_(inst_111248__$1)){
var statearr_111284_111326 = state_111267__$1;
(statearr_111284_111326[(1)] = (19));

} else {
var statearr_111285_111327 = state_111267__$1;
(statearr_111285_111327[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (25))){
var inst_111257 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111286_111328 = state_111267__$1;
(statearr_111286_111328[(2)] = inst_111257);

(statearr_111286_111328[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (17))){
var inst_111222 = (state_111267[(10)]);
var inst_111231 = cljs.core.first(inst_111222);
var inst_111232 = cljs.core.async.muxch_STAR_(inst_111231);
var inst_111233 = cljs.core.async.close_BANG_(inst_111232);
var inst_111234 = cljs.core.next(inst_111222);
var inst_111208 = inst_111234;
var inst_111209 = null;
var inst_111210 = (0);
var inst_111211 = (0);
var state_111267__$1 = (function (){var statearr_111287 = state_111267;
(statearr_111287[(12)] = inst_111208);

(statearr_111287[(13)] = inst_111209);

(statearr_111287[(14)] = inst_111211);

(statearr_111287[(15)] = inst_111210);

(statearr_111287[(16)] = inst_111233);

return statearr_111287;
})();
var statearr_111288_111329 = state_111267__$1;
(statearr_111288_111329[(2)] = null);

(statearr_111288_111329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (3))){
var inst_111265 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111267__$1,inst_111265);
} else {
if((state_val_111268 === (12))){
var inst_111242 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111289_111330 = state_111267__$1;
(statearr_111289_111330[(2)] = inst_111242);

(statearr_111289_111330[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (2))){
var state_111267__$1 = state_111267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111267__$1,(4),ch);
} else {
if((state_val_111268 === (23))){
var state_111267__$1 = state_111267;
var statearr_111290_111331 = state_111267__$1;
(statearr_111290_111331[(2)] = null);

(statearr_111290_111331[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (19))){
var inst_111198 = (state_111267[(8)]);
var inst_111248 = (state_111267[(11)]);
var inst_111250 = cljs.core.async.muxch_STAR_(inst_111248);
var state_111267__$1 = state_111267;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111267__$1,(22),inst_111250,inst_111198);
} else {
if((state_val_111268 === (11))){
var inst_111208 = (state_111267[(12)]);
var inst_111222 = (state_111267[(10)]);
var inst_111222__$1 = cljs.core.seq(inst_111208);
var state_111267__$1 = (function (){var statearr_111291 = state_111267;
(statearr_111291[(10)] = inst_111222__$1);

return statearr_111291;
})();
if(inst_111222__$1){
var statearr_111292_111332 = state_111267__$1;
(statearr_111292_111332[(1)] = (13));

} else {
var statearr_111293_111333 = state_111267__$1;
(statearr_111293_111333[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (9))){
var inst_111244 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111294_111334 = state_111267__$1;
(statearr_111294_111334[(2)] = inst_111244);

(statearr_111294_111334[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (5))){
var inst_111205 = cljs.core.deref(mults);
var inst_111206 = cljs.core.vals(inst_111205);
var inst_111207 = cljs.core.seq(inst_111206);
var inst_111208 = inst_111207;
var inst_111209 = null;
var inst_111210 = (0);
var inst_111211 = (0);
var state_111267__$1 = (function (){var statearr_111295 = state_111267;
(statearr_111295[(12)] = inst_111208);

(statearr_111295[(13)] = inst_111209);

(statearr_111295[(14)] = inst_111211);

(statearr_111295[(15)] = inst_111210);

return statearr_111295;
})();
var statearr_111296_111335 = state_111267__$1;
(statearr_111296_111335[(2)] = null);

(statearr_111296_111335[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (14))){
var state_111267__$1 = state_111267;
var statearr_111300_111336 = state_111267__$1;
(statearr_111300_111336[(2)] = null);

(statearr_111300_111336[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (16))){
var inst_111222 = (state_111267[(10)]);
var inst_111226 = cljs.core.chunk_first(inst_111222);
var inst_111227 = cljs.core.chunk_rest(inst_111222);
var inst_111228 = cljs.core.count(inst_111226);
var inst_111208 = inst_111227;
var inst_111209 = inst_111226;
var inst_111210 = inst_111228;
var inst_111211 = (0);
var state_111267__$1 = (function (){var statearr_111301 = state_111267;
(statearr_111301[(12)] = inst_111208);

(statearr_111301[(13)] = inst_111209);

(statearr_111301[(14)] = inst_111211);

(statearr_111301[(15)] = inst_111210);

return statearr_111301;
})();
var statearr_111302_111337 = state_111267__$1;
(statearr_111302_111337[(2)] = null);

(statearr_111302_111337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (10))){
var inst_111208 = (state_111267[(12)]);
var inst_111209 = (state_111267[(13)]);
var inst_111211 = (state_111267[(14)]);
var inst_111210 = (state_111267[(15)]);
var inst_111216 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_111209,inst_111211);
var inst_111217 = cljs.core.async.muxch_STAR_(inst_111216);
var inst_111218 = cljs.core.async.close_BANG_(inst_111217);
var inst_111219 = (inst_111211 + (1));
var tmp111297 = inst_111208;
var tmp111298 = inst_111209;
var tmp111299 = inst_111210;
var inst_111208__$1 = tmp111297;
var inst_111209__$1 = tmp111298;
var inst_111210__$1 = tmp111299;
var inst_111211__$1 = inst_111219;
var state_111267__$1 = (function (){var statearr_111303 = state_111267;
(statearr_111303[(12)] = inst_111208__$1);

(statearr_111303[(13)] = inst_111209__$1);

(statearr_111303[(17)] = inst_111218);

(statearr_111303[(14)] = inst_111211__$1);

(statearr_111303[(15)] = inst_111210__$1);

return statearr_111303;
})();
var statearr_111304_111338 = state_111267__$1;
(statearr_111304_111338[(2)] = null);

(statearr_111304_111338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (18))){
var inst_111237 = (state_111267[(2)]);
var state_111267__$1 = state_111267;
var statearr_111305_111339 = state_111267__$1;
(statearr_111305_111339[(2)] = inst_111237);

(statearr_111305_111339[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111268 === (8))){
var inst_111211 = (state_111267[(14)]);
var inst_111210 = (state_111267[(15)]);
var inst_111213 = (inst_111211 < inst_111210);
var inst_111214 = inst_111213;
var state_111267__$1 = state_111267;
if(cljs.core.truth_(inst_111214)){
var statearr_111306_111340 = state_111267__$1;
(statearr_111306_111340[(1)] = (10));

} else {
var statearr_111307_111341 = state_111267__$1;
(statearr_111307_111341[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111313,mults,ensure_mult,p))
;
return ((function (switch__109970__auto__,c__110077__auto___111313,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111308[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111308[(1)] = (1));

return statearr_111308;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111267){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111267);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111309){if((e111309 instanceof Object)){
var ex__109974__auto__ = e111309;
var statearr_111310_111342 = state_111267;
(statearr_111310_111342[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111267);

return cljs.core.cst$kw$recur;
} else {
throw e111309;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111343 = state_111267;
state_111267 = G__111343;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111267){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111313,mults,ensure_mult,p))
})();
var state__110079__auto__ = (function (){var statearr_111311 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111311[(6)] = c__110077__auto___111313);

return statearr_111311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111313,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__111345 = arguments.length;
switch (G__111345) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__111348 = arguments.length;
switch (G__111348) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__111351 = arguments.length;
switch (G__111351) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__110077__auto___111418 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_111390){
var state_val_111391 = (state_111390[(1)]);
if((state_val_111391 === (7))){
var state_111390__$1 = state_111390;
var statearr_111392_111419 = state_111390__$1;
(statearr_111392_111419[(2)] = null);

(statearr_111392_111419[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (1))){
var state_111390__$1 = state_111390;
var statearr_111393_111420 = state_111390__$1;
(statearr_111393_111420[(2)] = null);

(statearr_111393_111420[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (4))){
var inst_111354 = (state_111390[(7)]);
var inst_111356 = (inst_111354 < cnt);
var state_111390__$1 = state_111390;
if(cljs.core.truth_(inst_111356)){
var statearr_111394_111421 = state_111390__$1;
(statearr_111394_111421[(1)] = (6));

} else {
var statearr_111395_111422 = state_111390__$1;
(statearr_111395_111422[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (15))){
var inst_111386 = (state_111390[(2)]);
var state_111390__$1 = state_111390;
var statearr_111396_111423 = state_111390__$1;
(statearr_111396_111423[(2)] = inst_111386);

(statearr_111396_111423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (13))){
var inst_111379 = cljs.core.async.close_BANG_(out);
var state_111390__$1 = state_111390;
var statearr_111397_111424 = state_111390__$1;
(statearr_111397_111424[(2)] = inst_111379);

(statearr_111397_111424[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (6))){
var state_111390__$1 = state_111390;
var statearr_111398_111425 = state_111390__$1;
(statearr_111398_111425[(2)] = null);

(statearr_111398_111425[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (3))){
var inst_111388 = (state_111390[(2)]);
var state_111390__$1 = state_111390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111390__$1,inst_111388);
} else {
if((state_val_111391 === (12))){
var inst_111376 = (state_111390[(8)]);
var inst_111376__$1 = (state_111390[(2)]);
var inst_111377 = cljs.core.some(cljs.core.nil_QMARK_,inst_111376__$1);
var state_111390__$1 = (function (){var statearr_111399 = state_111390;
(statearr_111399[(8)] = inst_111376__$1);

return statearr_111399;
})();
if(cljs.core.truth_(inst_111377)){
var statearr_111400_111426 = state_111390__$1;
(statearr_111400_111426[(1)] = (13));

} else {
var statearr_111401_111427 = state_111390__$1;
(statearr_111401_111427[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (2))){
var inst_111353 = cljs.core.reset_BANG_(dctr,cnt);
var inst_111354 = (0);
var state_111390__$1 = (function (){var statearr_111402 = state_111390;
(statearr_111402[(9)] = inst_111353);

(statearr_111402[(7)] = inst_111354);

return statearr_111402;
})();
var statearr_111403_111428 = state_111390__$1;
(statearr_111403_111428[(2)] = null);

(statearr_111403_111428[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (11))){
var inst_111354 = (state_111390[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111390,(10),Object,null,(9));
var inst_111363 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_111354) : chs__$1.call(null,inst_111354));
var inst_111364 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_111354) : done.call(null,inst_111354));
var inst_111365 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_111363,inst_111364);
var state_111390__$1 = state_111390;
var statearr_111404_111429 = state_111390__$1;
(statearr_111404_111429[(2)] = inst_111365);


cljs.core.async.impl.ioc_helpers.process_exception(state_111390__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (9))){
var inst_111354 = (state_111390[(7)]);
var inst_111367 = (state_111390[(2)]);
var inst_111368 = (inst_111354 + (1));
var inst_111354__$1 = inst_111368;
var state_111390__$1 = (function (){var statearr_111405 = state_111390;
(statearr_111405[(7)] = inst_111354__$1);

(statearr_111405[(10)] = inst_111367);

return statearr_111405;
})();
var statearr_111406_111430 = state_111390__$1;
(statearr_111406_111430[(2)] = null);

(statearr_111406_111430[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (5))){
var inst_111374 = (state_111390[(2)]);
var state_111390__$1 = (function (){var statearr_111407 = state_111390;
(statearr_111407[(11)] = inst_111374);

return statearr_111407;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111390__$1,(12),dchan);
} else {
if((state_val_111391 === (14))){
var inst_111376 = (state_111390[(8)]);
var inst_111381 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_111376);
var state_111390__$1 = state_111390;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111390__$1,(16),out,inst_111381);
} else {
if((state_val_111391 === (16))){
var inst_111383 = (state_111390[(2)]);
var state_111390__$1 = (function (){var statearr_111408 = state_111390;
(statearr_111408[(12)] = inst_111383);

return statearr_111408;
})();
var statearr_111409_111431 = state_111390__$1;
(statearr_111409_111431[(2)] = null);

(statearr_111409_111431[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (10))){
var inst_111358 = (state_111390[(2)]);
var inst_111359 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_111390__$1 = (function (){var statearr_111410 = state_111390;
(statearr_111410[(13)] = inst_111358);

return statearr_111410;
})();
var statearr_111411_111432 = state_111390__$1;
(statearr_111411_111432[(2)] = inst_111359);


cljs.core.async.impl.ioc_helpers.process_exception(state_111390__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111391 === (8))){
var inst_111372 = (state_111390[(2)]);
var state_111390__$1 = state_111390;
var statearr_111412_111433 = state_111390__$1;
(statearr_111412_111433[(2)] = inst_111372);

(statearr_111412_111433[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__109970__auto__,c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111413[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111413[(1)] = (1));

return statearr_111413;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111390){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111390);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111414){if((e111414 instanceof Object)){
var ex__109974__auto__ = e111414;
var statearr_111415_111434 = state_111390;
(statearr_111415_111434[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111390);

return cljs.core.cst$kw$recur;
} else {
throw e111414;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111435 = state_111390;
state_111390 = G__111435;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111390){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__110079__auto__ = (function (){var statearr_111416 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111416[(6)] = c__110077__auto___111418);

return statearr_111416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111418,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__111438 = arguments.length;
switch (G__111438) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111492 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111492,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111492,out){
return (function (state_111470){
var state_val_111471 = (state_111470[(1)]);
if((state_val_111471 === (7))){
var inst_111450 = (state_111470[(7)]);
var inst_111449 = (state_111470[(8)]);
var inst_111449__$1 = (state_111470[(2)]);
var inst_111450__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111449__$1,(0),null);
var inst_111451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_111449__$1,(1),null);
var inst_111452 = (inst_111450__$1 == null);
var state_111470__$1 = (function (){var statearr_111472 = state_111470;
(statearr_111472[(9)] = inst_111451);

(statearr_111472[(7)] = inst_111450__$1);

(statearr_111472[(8)] = inst_111449__$1);

return statearr_111472;
})();
if(cljs.core.truth_(inst_111452)){
var statearr_111473_111493 = state_111470__$1;
(statearr_111473_111493[(1)] = (8));

} else {
var statearr_111474_111494 = state_111470__$1;
(statearr_111474_111494[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (1))){
var inst_111439 = cljs.core.vec(chs);
var inst_111440 = inst_111439;
var state_111470__$1 = (function (){var statearr_111475 = state_111470;
(statearr_111475[(10)] = inst_111440);

return statearr_111475;
})();
var statearr_111476_111495 = state_111470__$1;
(statearr_111476_111495[(2)] = null);

(statearr_111476_111495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (4))){
var inst_111440 = (state_111470[(10)]);
var state_111470__$1 = state_111470;
return cljs.core.async.ioc_alts_BANG_(state_111470__$1,(7),inst_111440);
} else {
if((state_val_111471 === (6))){
var inst_111466 = (state_111470[(2)]);
var state_111470__$1 = state_111470;
var statearr_111477_111496 = state_111470__$1;
(statearr_111477_111496[(2)] = inst_111466);

(statearr_111477_111496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (3))){
var inst_111468 = (state_111470[(2)]);
var state_111470__$1 = state_111470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111470__$1,inst_111468);
} else {
if((state_val_111471 === (2))){
var inst_111440 = (state_111470[(10)]);
var inst_111442 = cljs.core.count(inst_111440);
var inst_111443 = (inst_111442 > (0));
var state_111470__$1 = state_111470;
if(cljs.core.truth_(inst_111443)){
var statearr_111479_111497 = state_111470__$1;
(statearr_111479_111497[(1)] = (4));

} else {
var statearr_111480_111498 = state_111470__$1;
(statearr_111480_111498[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (11))){
var inst_111440 = (state_111470[(10)]);
var inst_111459 = (state_111470[(2)]);
var tmp111478 = inst_111440;
var inst_111440__$1 = tmp111478;
var state_111470__$1 = (function (){var statearr_111481 = state_111470;
(statearr_111481[(11)] = inst_111459);

(statearr_111481[(10)] = inst_111440__$1);

return statearr_111481;
})();
var statearr_111482_111499 = state_111470__$1;
(statearr_111482_111499[(2)] = null);

(statearr_111482_111499[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (9))){
var inst_111450 = (state_111470[(7)]);
var state_111470__$1 = state_111470;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111470__$1,(11),out,inst_111450);
} else {
if((state_val_111471 === (5))){
var inst_111464 = cljs.core.async.close_BANG_(out);
var state_111470__$1 = state_111470;
var statearr_111483_111500 = state_111470__$1;
(statearr_111483_111500[(2)] = inst_111464);

(statearr_111483_111500[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (10))){
var inst_111462 = (state_111470[(2)]);
var state_111470__$1 = state_111470;
var statearr_111484_111501 = state_111470__$1;
(statearr_111484_111501[(2)] = inst_111462);

(statearr_111484_111501[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111471 === (8))){
var inst_111451 = (state_111470[(9)]);
var inst_111440 = (state_111470[(10)]);
var inst_111450 = (state_111470[(7)]);
var inst_111449 = (state_111470[(8)]);
var inst_111454 = (function (){var cs = inst_111440;
var vec__111445 = inst_111449;
var v = inst_111450;
var c = inst_111451;
return ((function (cs,vec__111445,v,c,inst_111451,inst_111440,inst_111450,inst_111449,state_val_111471,c__110077__auto___111492,out){
return (function (p1__111436_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__111436_SHARP_);
});
;})(cs,vec__111445,v,c,inst_111451,inst_111440,inst_111450,inst_111449,state_val_111471,c__110077__auto___111492,out))
})();
var inst_111455 = cljs.core.filterv(inst_111454,inst_111440);
var inst_111440__$1 = inst_111455;
var state_111470__$1 = (function (){var statearr_111485 = state_111470;
(statearr_111485[(10)] = inst_111440__$1);

return statearr_111485;
})();
var statearr_111486_111502 = state_111470__$1;
(statearr_111486_111502[(2)] = null);

(statearr_111486_111502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111492,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111492,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111487 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111487[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111487[(1)] = (1));

return statearr_111487;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111470){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111470);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111488){if((e111488 instanceof Object)){
var ex__109974__auto__ = e111488;
var statearr_111489_111503 = state_111470;
(statearr_111489_111503[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111470);

return cljs.core.cst$kw$recur;
} else {
throw e111488;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111504 = state_111470;
state_111470 = G__111504;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111492,out))
})();
var state__110079__auto__ = (function (){var statearr_111490 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111490[(6)] = c__110077__auto___111492);

return statearr_111490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111492,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__111506 = arguments.length;
switch (G__111506) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111551 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111551,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111551,out){
return (function (state_111530){
var state_val_111531 = (state_111530[(1)]);
if((state_val_111531 === (7))){
var inst_111512 = (state_111530[(7)]);
var inst_111512__$1 = (state_111530[(2)]);
var inst_111513 = (inst_111512__$1 == null);
var inst_111514 = cljs.core.not(inst_111513);
var state_111530__$1 = (function (){var statearr_111532 = state_111530;
(statearr_111532[(7)] = inst_111512__$1);

return statearr_111532;
})();
if(inst_111514){
var statearr_111533_111552 = state_111530__$1;
(statearr_111533_111552[(1)] = (8));

} else {
var statearr_111534_111553 = state_111530__$1;
(statearr_111534_111553[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (1))){
var inst_111507 = (0);
var state_111530__$1 = (function (){var statearr_111535 = state_111530;
(statearr_111535[(8)] = inst_111507);

return statearr_111535;
})();
var statearr_111536_111554 = state_111530__$1;
(statearr_111536_111554[(2)] = null);

(statearr_111536_111554[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (4))){
var state_111530__$1 = state_111530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111530__$1,(7),ch);
} else {
if((state_val_111531 === (6))){
var inst_111525 = (state_111530[(2)]);
var state_111530__$1 = state_111530;
var statearr_111537_111555 = state_111530__$1;
(statearr_111537_111555[(2)] = inst_111525);

(statearr_111537_111555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (3))){
var inst_111527 = (state_111530[(2)]);
var inst_111528 = cljs.core.async.close_BANG_(out);
var state_111530__$1 = (function (){var statearr_111538 = state_111530;
(statearr_111538[(9)] = inst_111527);

return statearr_111538;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_111530__$1,inst_111528);
} else {
if((state_val_111531 === (2))){
var inst_111507 = (state_111530[(8)]);
var inst_111509 = (inst_111507 < n);
var state_111530__$1 = state_111530;
if(cljs.core.truth_(inst_111509)){
var statearr_111539_111556 = state_111530__$1;
(statearr_111539_111556[(1)] = (4));

} else {
var statearr_111540_111557 = state_111530__$1;
(statearr_111540_111557[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (11))){
var inst_111507 = (state_111530[(8)]);
var inst_111517 = (state_111530[(2)]);
var inst_111518 = (inst_111507 + (1));
var inst_111507__$1 = inst_111518;
var state_111530__$1 = (function (){var statearr_111541 = state_111530;
(statearr_111541[(8)] = inst_111507__$1);

(statearr_111541[(10)] = inst_111517);

return statearr_111541;
})();
var statearr_111542_111558 = state_111530__$1;
(statearr_111542_111558[(2)] = null);

(statearr_111542_111558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (9))){
var state_111530__$1 = state_111530;
var statearr_111543_111559 = state_111530__$1;
(statearr_111543_111559[(2)] = null);

(statearr_111543_111559[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (5))){
var state_111530__$1 = state_111530;
var statearr_111544_111560 = state_111530__$1;
(statearr_111544_111560[(2)] = null);

(statearr_111544_111560[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (10))){
var inst_111522 = (state_111530[(2)]);
var state_111530__$1 = state_111530;
var statearr_111545_111561 = state_111530__$1;
(statearr_111545_111561[(2)] = inst_111522);

(statearr_111545_111561[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111531 === (8))){
var inst_111512 = (state_111530[(7)]);
var state_111530__$1 = state_111530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111530__$1,(11),out,inst_111512);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111551,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111551,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111546 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_111546[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111546[(1)] = (1));

return statearr_111546;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111530){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111530);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111547){if((e111547 instanceof Object)){
var ex__109974__auto__ = e111547;
var statearr_111548_111562 = state_111530;
(statearr_111548_111562[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111530);

return cljs.core.cst$kw$recur;
} else {
throw e111547;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111563 = state_111530;
state_111530 = G__111563;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111551,out))
})();
var state__110079__auto__ = (function (){var statearr_111549 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111549[(6)] = c__110077__auto___111551);

return statearr_111549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111551,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async111565 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async111565 = (function (f,ch,meta111566){
this.f = f;
this.ch = ch;
this.meta111566 = meta111566;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_111567,meta111566__$1){
var self__ = this;
var _111567__$1 = this;
return (new cljs.core.async.t_cljs$core$async111565(self__.f,self__.ch,meta111566__$1));
});

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_111567){
var self__ = this;
var _111567__$1 = this;
return self__.meta111566;
});

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async111568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async111568 = (function (f,ch,meta111566,_,fn1,meta111569){
this.f = f;
this.ch = ch;
this.meta111566 = meta111566;
this._ = _;
this.fn1 = fn1;
this.meta111569 = meta111569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_111570,meta111569__$1){
var self__ = this;
var _111570__$1 = this;
return (new cljs.core.async.t_cljs$core$async111568(self__.f,self__.ch,self__.meta111566,self__._,self__.fn1,meta111569__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_111570){
var self__ = this;
var _111570__$1 = this;
return self__.meta111569;
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__111564_SHARP_){
var G__111571 = (((p1__111564_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__111564_SHARP_) : self__.f.call(null,p1__111564_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__111571) : f1.call(null,G__111571));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta111566,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async111565], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta111569], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async111568.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async111568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async111568";

cljs.core.async.t_cljs$core$async111568.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async111568");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async111568.
 */
cljs.core.async.__GT_t_cljs$core$async111568 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async111568(f__$1,ch__$1,meta111566__$1,___$2,fn1__$1,meta111569){
return (new cljs.core.async.t_cljs$core$async111568(f__$1,ch__$1,meta111566__$1,___$2,fn1__$1,meta111569));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async111568(self__.f,self__.ch,self__.meta111566,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__111572 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__111572) : self__.f.call(null,G__111572));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111565.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async111565.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta111566], null);
});

cljs.core.async.t_cljs$core$async111565.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async111565.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async111565";

cljs.core.async.t_cljs$core$async111565.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async111565");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async111565.
 */
cljs.core.async.__GT_t_cljs$core$async111565 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async111565(f__$1,ch__$1,meta111566){
return (new cljs.core.async.t_cljs$core$async111565(f__$1,ch__$1,meta111566));
});

}

return (new cljs.core.async.t_cljs$core$async111565(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async111573 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async111573 = (function (f,ch,meta111574){
this.f = f;
this.ch = ch;
this.meta111574 = meta111574;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_111575,meta111574__$1){
var self__ = this;
var _111575__$1 = this;
return (new cljs.core.async.t_cljs$core$async111573(self__.f,self__.ch,meta111574__$1));
});

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_111575){
var self__ = this;
var _111575__$1 = this;
return self__.meta111574;
});

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111573.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async111573.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta111574], null);
});

cljs.core.async.t_cljs$core$async111573.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async111573.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async111573";

cljs.core.async.t_cljs$core$async111573.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async111573");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async111573.
 */
cljs.core.async.__GT_t_cljs$core$async111573 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async111573(f__$1,ch__$1,meta111574){
return (new cljs.core.async.t_cljs$core$async111573(f__$1,ch__$1,meta111574));
});

}

return (new cljs.core.async.t_cljs$core$async111573(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async111576 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async111576 = (function (p,ch,meta111577){
this.p = p;
this.ch = ch;
this.meta111577 = meta111577;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_111578,meta111577__$1){
var self__ = this;
var _111578__$1 = this;
return (new cljs.core.async.t_cljs$core$async111576(self__.p,self__.ch,meta111577__$1));
});

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_111578){
var self__ = this;
var _111578__$1 = this;
return self__.meta111577;
});

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async111576.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async111576.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta111577], null);
});

cljs.core.async.t_cljs$core$async111576.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async111576.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async111576";

cljs.core.async.t_cljs$core$async111576.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async111576");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async111576.
 */
cljs.core.async.__GT_t_cljs$core$async111576 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async111576(p__$1,ch__$1,meta111577){
return (new cljs.core.async.t_cljs$core$async111576(p__$1,ch__$1,meta111577));
});

}

return (new cljs.core.async.t_cljs$core$async111576(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__111580 = arguments.length;
switch (G__111580) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111620 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111620,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111620,out){
return (function (state_111601){
var state_val_111602 = (state_111601[(1)]);
if((state_val_111602 === (7))){
var inst_111597 = (state_111601[(2)]);
var state_111601__$1 = state_111601;
var statearr_111603_111621 = state_111601__$1;
(statearr_111603_111621[(2)] = inst_111597);

(statearr_111603_111621[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (1))){
var state_111601__$1 = state_111601;
var statearr_111604_111622 = state_111601__$1;
(statearr_111604_111622[(2)] = null);

(statearr_111604_111622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (4))){
var inst_111583 = (state_111601[(7)]);
var inst_111583__$1 = (state_111601[(2)]);
var inst_111584 = (inst_111583__$1 == null);
var state_111601__$1 = (function (){var statearr_111605 = state_111601;
(statearr_111605[(7)] = inst_111583__$1);

return statearr_111605;
})();
if(cljs.core.truth_(inst_111584)){
var statearr_111606_111623 = state_111601__$1;
(statearr_111606_111623[(1)] = (5));

} else {
var statearr_111607_111624 = state_111601__$1;
(statearr_111607_111624[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (6))){
var inst_111583 = (state_111601[(7)]);
var inst_111588 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_111583) : p.call(null,inst_111583));
var state_111601__$1 = state_111601;
if(cljs.core.truth_(inst_111588)){
var statearr_111608_111625 = state_111601__$1;
(statearr_111608_111625[(1)] = (8));

} else {
var statearr_111609_111626 = state_111601__$1;
(statearr_111609_111626[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (3))){
var inst_111599 = (state_111601[(2)]);
var state_111601__$1 = state_111601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111601__$1,inst_111599);
} else {
if((state_val_111602 === (2))){
var state_111601__$1 = state_111601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111601__$1,(4),ch);
} else {
if((state_val_111602 === (11))){
var inst_111591 = (state_111601[(2)]);
var state_111601__$1 = state_111601;
var statearr_111610_111627 = state_111601__$1;
(statearr_111610_111627[(2)] = inst_111591);

(statearr_111610_111627[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (9))){
var state_111601__$1 = state_111601;
var statearr_111611_111628 = state_111601__$1;
(statearr_111611_111628[(2)] = null);

(statearr_111611_111628[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (5))){
var inst_111586 = cljs.core.async.close_BANG_(out);
var state_111601__$1 = state_111601;
var statearr_111612_111629 = state_111601__$1;
(statearr_111612_111629[(2)] = inst_111586);

(statearr_111612_111629[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (10))){
var inst_111594 = (state_111601[(2)]);
var state_111601__$1 = (function (){var statearr_111613 = state_111601;
(statearr_111613[(8)] = inst_111594);

return statearr_111613;
})();
var statearr_111614_111630 = state_111601__$1;
(statearr_111614_111630[(2)] = null);

(statearr_111614_111630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111602 === (8))){
var inst_111583 = (state_111601[(7)]);
var state_111601__$1 = state_111601;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111601__$1,(11),out,inst_111583);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111620,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111620,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111615 = [null,null,null,null,null,null,null,null,null];
(statearr_111615[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111615[(1)] = (1));

return statearr_111615;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111601){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111601);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111616){if((e111616 instanceof Object)){
var ex__109974__auto__ = e111616;
var statearr_111617_111631 = state_111601;
(statearr_111617_111631[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111601);

return cljs.core.cst$kw$recur;
} else {
throw e111616;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111632 = state_111601;
state_111601 = G__111632;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111620,out))
})();
var state__110079__auto__ = (function (){var statearr_111618 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111618[(6)] = c__110077__auto___111620);

return statearr_111618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111620,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__111634 = arguments.length;
switch (G__111634) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_111697){
var state_val_111698 = (state_111697[(1)]);
if((state_val_111698 === (7))){
var inst_111693 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
var statearr_111699_111737 = state_111697__$1;
(statearr_111699_111737[(2)] = inst_111693);

(statearr_111699_111737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (20))){
var inst_111663 = (state_111697[(7)]);
var inst_111674 = (state_111697[(2)]);
var inst_111675 = cljs.core.next(inst_111663);
var inst_111649 = inst_111675;
var inst_111650 = null;
var inst_111651 = (0);
var inst_111652 = (0);
var state_111697__$1 = (function (){var statearr_111700 = state_111697;
(statearr_111700[(8)] = inst_111650);

(statearr_111700[(9)] = inst_111651);

(statearr_111700[(10)] = inst_111649);

(statearr_111700[(11)] = inst_111652);

(statearr_111700[(12)] = inst_111674);

return statearr_111700;
})();
var statearr_111701_111738 = state_111697__$1;
(statearr_111701_111738[(2)] = null);

(statearr_111701_111738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (1))){
var state_111697__$1 = state_111697;
var statearr_111702_111739 = state_111697__$1;
(statearr_111702_111739[(2)] = null);

(statearr_111702_111739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (4))){
var inst_111638 = (state_111697[(13)]);
var inst_111638__$1 = (state_111697[(2)]);
var inst_111639 = (inst_111638__$1 == null);
var state_111697__$1 = (function (){var statearr_111703 = state_111697;
(statearr_111703[(13)] = inst_111638__$1);

return statearr_111703;
})();
if(cljs.core.truth_(inst_111639)){
var statearr_111704_111740 = state_111697__$1;
(statearr_111704_111740[(1)] = (5));

} else {
var statearr_111705_111741 = state_111697__$1;
(statearr_111705_111741[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (15))){
var state_111697__$1 = state_111697;
var statearr_111709_111742 = state_111697__$1;
(statearr_111709_111742[(2)] = null);

(statearr_111709_111742[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (21))){
var state_111697__$1 = state_111697;
var statearr_111710_111743 = state_111697__$1;
(statearr_111710_111743[(2)] = null);

(statearr_111710_111743[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (13))){
var inst_111650 = (state_111697[(8)]);
var inst_111651 = (state_111697[(9)]);
var inst_111649 = (state_111697[(10)]);
var inst_111652 = (state_111697[(11)]);
var inst_111659 = (state_111697[(2)]);
var inst_111660 = (inst_111652 + (1));
var tmp111706 = inst_111650;
var tmp111707 = inst_111651;
var tmp111708 = inst_111649;
var inst_111649__$1 = tmp111708;
var inst_111650__$1 = tmp111706;
var inst_111651__$1 = tmp111707;
var inst_111652__$1 = inst_111660;
var state_111697__$1 = (function (){var statearr_111711 = state_111697;
(statearr_111711[(8)] = inst_111650__$1);

(statearr_111711[(9)] = inst_111651__$1);

(statearr_111711[(10)] = inst_111649__$1);

(statearr_111711[(11)] = inst_111652__$1);

(statearr_111711[(14)] = inst_111659);

return statearr_111711;
})();
var statearr_111712_111744 = state_111697__$1;
(statearr_111712_111744[(2)] = null);

(statearr_111712_111744[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (22))){
var state_111697__$1 = state_111697;
var statearr_111713_111745 = state_111697__$1;
(statearr_111713_111745[(2)] = null);

(statearr_111713_111745[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (6))){
var inst_111638 = (state_111697[(13)]);
var inst_111647 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_111638) : f.call(null,inst_111638));
var inst_111648 = cljs.core.seq(inst_111647);
var inst_111649 = inst_111648;
var inst_111650 = null;
var inst_111651 = (0);
var inst_111652 = (0);
var state_111697__$1 = (function (){var statearr_111714 = state_111697;
(statearr_111714[(8)] = inst_111650);

(statearr_111714[(9)] = inst_111651);

(statearr_111714[(10)] = inst_111649);

(statearr_111714[(11)] = inst_111652);

return statearr_111714;
})();
var statearr_111715_111746 = state_111697__$1;
(statearr_111715_111746[(2)] = null);

(statearr_111715_111746[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (17))){
var inst_111663 = (state_111697[(7)]);
var inst_111667 = cljs.core.chunk_first(inst_111663);
var inst_111668 = cljs.core.chunk_rest(inst_111663);
var inst_111669 = cljs.core.count(inst_111667);
var inst_111649 = inst_111668;
var inst_111650 = inst_111667;
var inst_111651 = inst_111669;
var inst_111652 = (0);
var state_111697__$1 = (function (){var statearr_111716 = state_111697;
(statearr_111716[(8)] = inst_111650);

(statearr_111716[(9)] = inst_111651);

(statearr_111716[(10)] = inst_111649);

(statearr_111716[(11)] = inst_111652);

return statearr_111716;
})();
var statearr_111717_111747 = state_111697__$1;
(statearr_111717_111747[(2)] = null);

(statearr_111717_111747[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (3))){
var inst_111695 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111697__$1,inst_111695);
} else {
if((state_val_111698 === (12))){
var inst_111683 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
var statearr_111718_111748 = state_111697__$1;
(statearr_111718_111748[(2)] = inst_111683);

(statearr_111718_111748[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (2))){
var state_111697__$1 = state_111697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111697__$1,(4),in$);
} else {
if((state_val_111698 === (23))){
var inst_111691 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
var statearr_111719_111749 = state_111697__$1;
(statearr_111719_111749[(2)] = inst_111691);

(statearr_111719_111749[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (19))){
var inst_111678 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
var statearr_111720_111750 = state_111697__$1;
(statearr_111720_111750[(2)] = inst_111678);

(statearr_111720_111750[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (11))){
var inst_111663 = (state_111697[(7)]);
var inst_111649 = (state_111697[(10)]);
var inst_111663__$1 = cljs.core.seq(inst_111649);
var state_111697__$1 = (function (){var statearr_111721 = state_111697;
(statearr_111721[(7)] = inst_111663__$1);

return statearr_111721;
})();
if(inst_111663__$1){
var statearr_111722_111751 = state_111697__$1;
(statearr_111722_111751[(1)] = (14));

} else {
var statearr_111723_111752 = state_111697__$1;
(statearr_111723_111752[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (9))){
var inst_111685 = (state_111697[(2)]);
var inst_111686 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_111697__$1 = (function (){var statearr_111724 = state_111697;
(statearr_111724[(15)] = inst_111685);

return statearr_111724;
})();
if(cljs.core.truth_(inst_111686)){
var statearr_111725_111753 = state_111697__$1;
(statearr_111725_111753[(1)] = (21));

} else {
var statearr_111726_111754 = state_111697__$1;
(statearr_111726_111754[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (5))){
var inst_111641 = cljs.core.async.close_BANG_(out);
var state_111697__$1 = state_111697;
var statearr_111727_111755 = state_111697__$1;
(statearr_111727_111755[(2)] = inst_111641);

(statearr_111727_111755[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (14))){
var inst_111663 = (state_111697[(7)]);
var inst_111665 = cljs.core.chunked_seq_QMARK_(inst_111663);
var state_111697__$1 = state_111697;
if(inst_111665){
var statearr_111728_111756 = state_111697__$1;
(statearr_111728_111756[(1)] = (17));

} else {
var statearr_111729_111757 = state_111697__$1;
(statearr_111729_111757[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (16))){
var inst_111681 = (state_111697[(2)]);
var state_111697__$1 = state_111697;
var statearr_111730_111758 = state_111697__$1;
(statearr_111730_111758[(2)] = inst_111681);

(statearr_111730_111758[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111698 === (10))){
var inst_111650 = (state_111697[(8)]);
var inst_111652 = (state_111697[(11)]);
var inst_111657 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_111650,inst_111652);
var state_111697__$1 = state_111697;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111697__$1,(13),out,inst_111657);
} else {
if((state_val_111698 === (18))){
var inst_111663 = (state_111697[(7)]);
var inst_111672 = cljs.core.first(inst_111663);
var state_111697__$1 = state_111697;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111697__$1,(20),out,inst_111672);
} else {
if((state_val_111698 === (8))){
var inst_111651 = (state_111697[(9)]);
var inst_111652 = (state_111697[(11)]);
var inst_111654 = (inst_111652 < inst_111651);
var inst_111655 = inst_111654;
var state_111697__$1 = state_111697;
if(cljs.core.truth_(inst_111655)){
var statearr_111731_111759 = state_111697__$1;
(statearr_111731_111759[(1)] = (10));

} else {
var statearr_111732_111760 = state_111697__$1;
(statearr_111732_111760[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_111733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111733[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__);

(statearr_111733[(1)] = (1));

return statearr_111733;
});
var cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____1 = (function (state_111697){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111697);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111734){if((e111734 instanceof Object)){
var ex__109974__auto__ = e111734;
var statearr_111735_111761 = state_111697;
(statearr_111735_111761[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111697);

return cljs.core.cst$kw$recur;
} else {
throw e111734;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111762 = state_111697;
state_111697 = G__111762;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__ = function(state_111697){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____1.call(this,state_111697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__109971__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_111736 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111736[(6)] = c__110077__auto__);

return statearr_111736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__111764 = arguments.length;
switch (G__111764) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__111767 = arguments.length;
switch (G__111767) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__111770 = arguments.length;
switch (G__111770) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111817 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111817,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111817,out){
return (function (state_111794){
var state_val_111795 = (state_111794[(1)]);
if((state_val_111795 === (7))){
var inst_111789 = (state_111794[(2)]);
var state_111794__$1 = state_111794;
var statearr_111796_111818 = state_111794__$1;
(statearr_111796_111818[(2)] = inst_111789);

(statearr_111796_111818[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (1))){
var inst_111771 = null;
var state_111794__$1 = (function (){var statearr_111797 = state_111794;
(statearr_111797[(7)] = inst_111771);

return statearr_111797;
})();
var statearr_111798_111819 = state_111794__$1;
(statearr_111798_111819[(2)] = null);

(statearr_111798_111819[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (4))){
var inst_111774 = (state_111794[(8)]);
var inst_111774__$1 = (state_111794[(2)]);
var inst_111775 = (inst_111774__$1 == null);
var inst_111776 = cljs.core.not(inst_111775);
var state_111794__$1 = (function (){var statearr_111799 = state_111794;
(statearr_111799[(8)] = inst_111774__$1);

return statearr_111799;
})();
if(inst_111776){
var statearr_111800_111820 = state_111794__$1;
(statearr_111800_111820[(1)] = (5));

} else {
var statearr_111801_111821 = state_111794__$1;
(statearr_111801_111821[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (6))){
var state_111794__$1 = state_111794;
var statearr_111802_111822 = state_111794__$1;
(statearr_111802_111822[(2)] = null);

(statearr_111802_111822[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (3))){
var inst_111791 = (state_111794[(2)]);
var inst_111792 = cljs.core.async.close_BANG_(out);
var state_111794__$1 = (function (){var statearr_111803 = state_111794;
(statearr_111803[(9)] = inst_111791);

return statearr_111803;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_111794__$1,inst_111792);
} else {
if((state_val_111795 === (2))){
var state_111794__$1 = state_111794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111794__$1,(4),ch);
} else {
if((state_val_111795 === (11))){
var inst_111774 = (state_111794[(8)]);
var inst_111783 = (state_111794[(2)]);
var inst_111771 = inst_111774;
var state_111794__$1 = (function (){var statearr_111804 = state_111794;
(statearr_111804[(7)] = inst_111771);

(statearr_111804[(10)] = inst_111783);

return statearr_111804;
})();
var statearr_111805_111823 = state_111794__$1;
(statearr_111805_111823[(2)] = null);

(statearr_111805_111823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (9))){
var inst_111774 = (state_111794[(8)]);
var state_111794__$1 = state_111794;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111794__$1,(11),out,inst_111774);
} else {
if((state_val_111795 === (5))){
var inst_111771 = (state_111794[(7)]);
var inst_111774 = (state_111794[(8)]);
var inst_111778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_111774,inst_111771);
var state_111794__$1 = state_111794;
if(inst_111778){
var statearr_111807_111824 = state_111794__$1;
(statearr_111807_111824[(1)] = (8));

} else {
var statearr_111808_111825 = state_111794__$1;
(statearr_111808_111825[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (10))){
var inst_111786 = (state_111794[(2)]);
var state_111794__$1 = state_111794;
var statearr_111809_111826 = state_111794__$1;
(statearr_111809_111826[(2)] = inst_111786);

(statearr_111809_111826[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111795 === (8))){
var inst_111771 = (state_111794[(7)]);
var tmp111806 = inst_111771;
var inst_111771__$1 = tmp111806;
var state_111794__$1 = (function (){var statearr_111810 = state_111794;
(statearr_111810[(7)] = inst_111771__$1);

return statearr_111810;
})();
var statearr_111811_111827 = state_111794__$1;
(statearr_111811_111827[(2)] = null);

(statearr_111811_111827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111817,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111817,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111812 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_111812[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111812[(1)] = (1));

return statearr_111812;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111794){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111794);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111813){if((e111813 instanceof Object)){
var ex__109974__auto__ = e111813;
var statearr_111814_111828 = state_111794;
(statearr_111814_111828[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111794);

return cljs.core.cst$kw$recur;
} else {
throw e111813;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111829 = state_111794;
state_111794 = G__111829;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111794){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111817,out))
})();
var state__110079__auto__ = (function (){var statearr_111815 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111815[(6)] = c__110077__auto___111817);

return statearr_111815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111817,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__111831 = arguments.length;
switch (G__111831) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111897 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111897,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111897,out){
return (function (state_111869){
var state_val_111870 = (state_111869[(1)]);
if((state_val_111870 === (7))){
var inst_111865 = (state_111869[(2)]);
var state_111869__$1 = state_111869;
var statearr_111871_111898 = state_111869__$1;
(statearr_111871_111898[(2)] = inst_111865);

(statearr_111871_111898[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (1))){
var inst_111832 = (new Array(n));
var inst_111833 = inst_111832;
var inst_111834 = (0);
var state_111869__$1 = (function (){var statearr_111872 = state_111869;
(statearr_111872[(7)] = inst_111834);

(statearr_111872[(8)] = inst_111833);

return statearr_111872;
})();
var statearr_111873_111899 = state_111869__$1;
(statearr_111873_111899[(2)] = null);

(statearr_111873_111899[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (4))){
var inst_111837 = (state_111869[(9)]);
var inst_111837__$1 = (state_111869[(2)]);
var inst_111838 = (inst_111837__$1 == null);
var inst_111839 = cljs.core.not(inst_111838);
var state_111869__$1 = (function (){var statearr_111874 = state_111869;
(statearr_111874[(9)] = inst_111837__$1);

return statearr_111874;
})();
if(inst_111839){
var statearr_111875_111900 = state_111869__$1;
(statearr_111875_111900[(1)] = (5));

} else {
var statearr_111876_111901 = state_111869__$1;
(statearr_111876_111901[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (15))){
var inst_111859 = (state_111869[(2)]);
var state_111869__$1 = state_111869;
var statearr_111877_111902 = state_111869__$1;
(statearr_111877_111902[(2)] = inst_111859);

(statearr_111877_111902[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (13))){
var state_111869__$1 = state_111869;
var statearr_111878_111903 = state_111869__$1;
(statearr_111878_111903[(2)] = null);

(statearr_111878_111903[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (6))){
var inst_111834 = (state_111869[(7)]);
var inst_111855 = (inst_111834 > (0));
var state_111869__$1 = state_111869;
if(cljs.core.truth_(inst_111855)){
var statearr_111879_111904 = state_111869__$1;
(statearr_111879_111904[(1)] = (12));

} else {
var statearr_111880_111905 = state_111869__$1;
(statearr_111880_111905[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (3))){
var inst_111867 = (state_111869[(2)]);
var state_111869__$1 = state_111869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111869__$1,inst_111867);
} else {
if((state_val_111870 === (12))){
var inst_111833 = (state_111869[(8)]);
var inst_111857 = cljs.core.vec(inst_111833);
var state_111869__$1 = state_111869;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111869__$1,(15),out,inst_111857);
} else {
if((state_val_111870 === (2))){
var state_111869__$1 = state_111869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111869__$1,(4),ch);
} else {
if((state_val_111870 === (11))){
var inst_111849 = (state_111869[(2)]);
var inst_111850 = (new Array(n));
var inst_111833 = inst_111850;
var inst_111834 = (0);
var state_111869__$1 = (function (){var statearr_111881 = state_111869;
(statearr_111881[(10)] = inst_111849);

(statearr_111881[(7)] = inst_111834);

(statearr_111881[(8)] = inst_111833);

return statearr_111881;
})();
var statearr_111882_111906 = state_111869__$1;
(statearr_111882_111906[(2)] = null);

(statearr_111882_111906[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (9))){
var inst_111833 = (state_111869[(8)]);
var inst_111847 = cljs.core.vec(inst_111833);
var state_111869__$1 = state_111869;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111869__$1,(11),out,inst_111847);
} else {
if((state_val_111870 === (5))){
var inst_111842 = (state_111869[(11)]);
var inst_111834 = (state_111869[(7)]);
var inst_111833 = (state_111869[(8)]);
var inst_111837 = (state_111869[(9)]);
var inst_111841 = (inst_111833[inst_111834] = inst_111837);
var inst_111842__$1 = (inst_111834 + (1));
var inst_111843 = (inst_111842__$1 < n);
var state_111869__$1 = (function (){var statearr_111883 = state_111869;
(statearr_111883[(11)] = inst_111842__$1);

(statearr_111883[(12)] = inst_111841);

return statearr_111883;
})();
if(cljs.core.truth_(inst_111843)){
var statearr_111884_111907 = state_111869__$1;
(statearr_111884_111907[(1)] = (8));

} else {
var statearr_111885_111908 = state_111869__$1;
(statearr_111885_111908[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (14))){
var inst_111862 = (state_111869[(2)]);
var inst_111863 = cljs.core.async.close_BANG_(out);
var state_111869__$1 = (function (){var statearr_111887 = state_111869;
(statearr_111887[(13)] = inst_111862);

return statearr_111887;
})();
var statearr_111888_111909 = state_111869__$1;
(statearr_111888_111909[(2)] = inst_111863);

(statearr_111888_111909[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (10))){
var inst_111853 = (state_111869[(2)]);
var state_111869__$1 = state_111869;
var statearr_111889_111910 = state_111869__$1;
(statearr_111889_111910[(2)] = inst_111853);

(statearr_111889_111910[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111870 === (8))){
var inst_111842 = (state_111869[(11)]);
var inst_111833 = (state_111869[(8)]);
var tmp111886 = inst_111833;
var inst_111833__$1 = tmp111886;
var inst_111834 = inst_111842;
var state_111869__$1 = (function (){var statearr_111890 = state_111869;
(statearr_111890[(7)] = inst_111834);

(statearr_111890[(8)] = inst_111833__$1);

return statearr_111890;
})();
var statearr_111891_111911 = state_111869__$1;
(statearr_111891_111911[(2)] = null);

(statearr_111891_111911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111897,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111897,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111892[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111892[(1)] = (1));

return statearr_111892;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111869){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111869);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111893){if((e111893 instanceof Object)){
var ex__109974__auto__ = e111893;
var statearr_111894_111912 = state_111869;
(statearr_111894_111912[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111869);

return cljs.core.cst$kw$recur;
} else {
throw e111893;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__111913 = state_111869;
state_111869 = G__111913;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111869){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111897,out))
})();
var state__110079__auto__ = (function (){var statearr_111895 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111895[(6)] = c__110077__auto___111897);

return statearr_111895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111897,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__111915 = arguments.length;
switch (G__111915) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__110077__auto___111985 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___111985,out){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___111985,out){
return (function (state_111957){
var state_val_111958 = (state_111957[(1)]);
if((state_val_111958 === (7))){
var inst_111953 = (state_111957[(2)]);
var state_111957__$1 = state_111957;
var statearr_111959_111986 = state_111957__$1;
(statearr_111959_111986[(2)] = inst_111953);

(statearr_111959_111986[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (1))){
var inst_111916 = [];
var inst_111917 = inst_111916;
var inst_111918 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_111957__$1 = (function (){var statearr_111960 = state_111957;
(statearr_111960[(7)] = inst_111918);

(statearr_111960[(8)] = inst_111917);

return statearr_111960;
})();
var statearr_111961_111987 = state_111957__$1;
(statearr_111961_111987[(2)] = null);

(statearr_111961_111987[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (4))){
var inst_111921 = (state_111957[(9)]);
var inst_111921__$1 = (state_111957[(2)]);
var inst_111922 = (inst_111921__$1 == null);
var inst_111923 = cljs.core.not(inst_111922);
var state_111957__$1 = (function (){var statearr_111962 = state_111957;
(statearr_111962[(9)] = inst_111921__$1);

return statearr_111962;
})();
if(inst_111923){
var statearr_111963_111988 = state_111957__$1;
(statearr_111963_111988[(1)] = (5));

} else {
var statearr_111964_111989 = state_111957__$1;
(statearr_111964_111989[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (15))){
var inst_111947 = (state_111957[(2)]);
var state_111957__$1 = state_111957;
var statearr_111965_111990 = state_111957__$1;
(statearr_111965_111990[(2)] = inst_111947);

(statearr_111965_111990[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (13))){
var state_111957__$1 = state_111957;
var statearr_111966_111991 = state_111957__$1;
(statearr_111966_111991[(2)] = null);

(statearr_111966_111991[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (6))){
var inst_111917 = (state_111957[(8)]);
var inst_111942 = inst_111917.length;
var inst_111943 = (inst_111942 > (0));
var state_111957__$1 = state_111957;
if(cljs.core.truth_(inst_111943)){
var statearr_111967_111992 = state_111957__$1;
(statearr_111967_111992[(1)] = (12));

} else {
var statearr_111968_111993 = state_111957__$1;
(statearr_111968_111993[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (3))){
var inst_111955 = (state_111957[(2)]);
var state_111957__$1 = state_111957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111957__$1,inst_111955);
} else {
if((state_val_111958 === (12))){
var inst_111917 = (state_111957[(8)]);
var inst_111945 = cljs.core.vec(inst_111917);
var state_111957__$1 = state_111957;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111957__$1,(15),out,inst_111945);
} else {
if((state_val_111958 === (2))){
var state_111957__$1 = state_111957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111957__$1,(4),ch);
} else {
if((state_val_111958 === (11))){
var inst_111925 = (state_111957[(10)]);
var inst_111921 = (state_111957[(9)]);
var inst_111935 = (state_111957[(2)]);
var inst_111936 = [];
var inst_111937 = inst_111936.push(inst_111921);
var inst_111917 = inst_111936;
var inst_111918 = inst_111925;
var state_111957__$1 = (function (){var statearr_111969 = state_111957;
(statearr_111969[(7)] = inst_111918);

(statearr_111969[(11)] = inst_111935);

(statearr_111969[(12)] = inst_111937);

(statearr_111969[(8)] = inst_111917);

return statearr_111969;
})();
var statearr_111970_111994 = state_111957__$1;
(statearr_111970_111994[(2)] = null);

(statearr_111970_111994[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (9))){
var inst_111917 = (state_111957[(8)]);
var inst_111933 = cljs.core.vec(inst_111917);
var state_111957__$1 = state_111957;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_111957__$1,(11),out,inst_111933);
} else {
if((state_val_111958 === (5))){
var inst_111918 = (state_111957[(7)]);
var inst_111925 = (state_111957[(10)]);
var inst_111921 = (state_111957[(9)]);
var inst_111925__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_111921) : f.call(null,inst_111921));
var inst_111926 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_111925__$1,inst_111918);
var inst_111927 = cljs.core.keyword_identical_QMARK_(inst_111918,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_111928 = ((inst_111926) || (inst_111927));
var state_111957__$1 = (function (){var statearr_111971 = state_111957;
(statearr_111971[(10)] = inst_111925__$1);

return statearr_111971;
})();
if(cljs.core.truth_(inst_111928)){
var statearr_111972_111995 = state_111957__$1;
(statearr_111972_111995[(1)] = (8));

} else {
var statearr_111973_111996 = state_111957__$1;
(statearr_111973_111996[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (14))){
var inst_111950 = (state_111957[(2)]);
var inst_111951 = cljs.core.async.close_BANG_(out);
var state_111957__$1 = (function (){var statearr_111975 = state_111957;
(statearr_111975[(13)] = inst_111950);

return statearr_111975;
})();
var statearr_111976_111997 = state_111957__$1;
(statearr_111976_111997[(2)] = inst_111951);

(statearr_111976_111997[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (10))){
var inst_111940 = (state_111957[(2)]);
var state_111957__$1 = state_111957;
var statearr_111977_111998 = state_111957__$1;
(statearr_111977_111998[(2)] = inst_111940);

(statearr_111977_111998[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111958 === (8))){
var inst_111925 = (state_111957[(10)]);
var inst_111917 = (state_111957[(8)]);
var inst_111921 = (state_111957[(9)]);
var inst_111930 = inst_111917.push(inst_111921);
var tmp111974 = inst_111917;
var inst_111917__$1 = tmp111974;
var inst_111918 = inst_111925;
var state_111957__$1 = (function (){var statearr_111978 = state_111957;
(statearr_111978[(7)] = inst_111918);

(statearr_111978[(14)] = inst_111930);

(statearr_111978[(8)] = inst_111917__$1);

return statearr_111978;
})();
var statearr_111979_111999 = state_111957__$1;
(statearr_111979_111999[(2)] = null);

(statearr_111979_111999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___111985,out))
;
return ((function (switch__109970__auto__,c__110077__auto___111985,out){
return (function() {
var cljs$core$async$state_machine__109971__auto__ = null;
var cljs$core$async$state_machine__109971__auto____0 = (function (){
var statearr_111980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111980[(0)] = cljs$core$async$state_machine__109971__auto__);

(statearr_111980[(1)] = (1));

return statearr_111980;
});
var cljs$core$async$state_machine__109971__auto____1 = (function (state_111957){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_111957);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e111981){if((e111981 instanceof Object)){
var ex__109974__auto__ = e111981;
var statearr_111982_112000 = state_111957;
(statearr_111982_112000[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111957);

return cljs.core.cst$kw$recur;
} else {
throw e111981;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__112001 = state_111957;
state_111957 = G__112001;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
cljs$core$async$state_machine__109971__auto__ = function(state_111957){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__109971__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__109971__auto____1.call(this,state_111957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__109971__auto____0;
cljs$core$async$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__109971__auto____1;
return cljs$core$async$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___111985,out))
})();
var state__110079__auto__ = (function (){var statearr_111983 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_111983[(6)] = c__110077__auto___111985);

return statearr_111983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___111985,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

