// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__105623 = cljs.core._EQ_;
var expr__105624 = e.getLastErrorCode();
if(cljs.core.truth_(pred__105623.call(null,goog.net.ErrorCode.NO_ERROR,expr__105624))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__105623.call(null,goog.net.ErrorCode.EXCEPTION,expr__105624))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__105623.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__105624))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__105623.call(null,goog.net.ErrorCode.ABORT,expr__105624))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__105623.call(null,goog.net.ErrorCode.TIMEOUT,expr__105624))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__105626 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__105626,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__105626;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__105627 = opts;
var map__105627__$1 = (((((!((map__105627 == null))))?(((((map__105627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__105627):map__105627);
var request_timeout = cljs.core.get.call(null,map__105627__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__105627__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__105627__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__105629 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__105629__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__105629,headers):G__105629);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__105629__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__105629__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e105630){var e_105631 = e105630;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_105631);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__105632 = opts;
var map__105632__$1 = (((((!((map__105632 == null))))?(((((map__105632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__105632):map__105632);
var request_timeout = cljs.core.get.call(null,map__105632__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__105632__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__105632__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__105632__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__105632__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__105634 = cljs.core.PersistentArrayMap.EMPTY;
var G__105634__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__105634,headers):G__105634);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__105634__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__105634__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__105636 = output_format;
var G__105636__$1 = (((G__105636 instanceof cljs.core.Keyword))?G__105636.fqn:null);
switch (G__105636__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e105635){var e_105638 = e105635;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_105638);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__105639 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__105639,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__105639;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105669){
var state_val_105670 = (state_105669[(1)]);
if((state_val_105670 === (7))){
var inst_105665 = (state_105669[(2)]);
var state_105669__$1 = state_105669;
var statearr_105671_105689 = state_105669__$1;
(statearr_105671_105689[(2)] = inst_105665);

(statearr_105671_105689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (1))){
var state_105669__$1 = state_105669;
var statearr_105672_105690 = state_105669__$1;
(statearr_105672_105690[(2)] = null);

(statearr_105672_105690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (4))){
var inst_105643 = (state_105669[(7)]);
var inst_105643__$1 = (state_105669[(2)]);
var inst_105644 = (inst_105643__$1 == null);
var state_105669__$1 = (function (){var statearr_105673 = state_105669;
(statearr_105673[(7)] = inst_105643__$1);

return statearr_105673;
})();
if(cljs.core.truth_(inst_105644)){
var statearr_105674_105691 = state_105669__$1;
(statearr_105674_105691[(1)] = (5));

} else {
var statearr_105675_105692 = state_105669__$1;
(statearr_105675_105692[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (6))){
var inst_105643 = (state_105669[(7)]);
var inst_105651 = cljs.core.nth.call(null,inst_105643,(0),null);
var inst_105652 = cljs.core.nth.call(null,inst_105643,(1),null);
var state_105669__$1 = (function (){var statearr_105676 = state_105669;
(statearr_105676[(8)] = inst_105652);

(statearr_105676[(9)] = inst_105651);

return statearr_105676;
})();
var statearr_105677_105693 = state_105669__$1;
(statearr_105677_105693[(2)] = null);

(statearr_105677_105693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (3))){
var inst_105667 = (state_105669[(2)]);
var state_105669__$1 = state_105669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105669__$1,inst_105667);
} else {
if((state_val_105670 === (2))){
var state_105669__$1 = state_105669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105669__$1,(4),pub_chan);
} else {
if((state_val_105670 === (9))){
var inst_105652 = (state_105669[(8)]);
var inst_105653 = (state_105669[(2)]);
var inst_105654 = fluree.db.util.log.error.call(null,inst_105653,"Websocket send message error:",inst_105653);
var inst_105655 = cljs.core.async.put_BANG_.call(null,inst_105652,false);
var state_105669__$1 = (function (){var statearr_105678 = state_105669;
(statearr_105678[(10)] = inst_105654);

return statearr_105678;
})();
var statearr_105679_105694 = state_105669__$1;
(statearr_105679_105694[(2)] = inst_105655);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105669__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (5))){
var inst_105646 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_105669__$1 = state_105669;
var statearr_105680_105695 = state_105669__$1;
(statearr_105680_105695[(2)] = inst_105646);

(statearr_105680_105695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (10))){
var inst_105652 = (state_105669[(8)]);
var inst_105651 = (state_105669[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105669,(9),Error,null,(8));
var inst_105659 = ws.send(inst_105651);
var inst_105660 = cljs.core.async.put_BANG_.call(null,inst_105652,true);
var state_105669__$1 = (function (){var statearr_105681 = state_105669;
(statearr_105681[(11)] = inst_105659);

return statearr_105681;
})();
var statearr_105682_105696 = state_105669__$1;
(statearr_105682_105696[(2)] = inst_105660);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105669__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105670 === (8))){
var inst_105662 = (state_105669[(2)]);
var state_105669__$1 = (function (){var statearr_105683 = state_105669;
(statearr_105683[(12)] = inst_105662);

return statearr_105683;
})();
var statearr_105684_105697 = state_105669__$1;
(statearr_105684_105697[(2)] = null);

(statearr_105684_105697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0 = (function (){
var statearr_105685 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105685[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__);

(statearr_105685[(1)] = (1));

return statearr_105685;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1 = (function (state_105669){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105686){if((e105686 instanceof Object)){
var ex__99978__auto__ = e105686;
var statearr_105687_105698 = state_105669;
(statearr_105687_105698[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105669);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105686;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105699 = state_105669;
state_105669 = G__105699;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__ = function(state_105669){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1.call(this,state_105669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105688 = f__100070__auto__.call(null);
(statearr_105688[(6)] = c__100069__auto__);

return statearr_105688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__100069__auto___105737 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105725){
var state_val_105726 = (state_105725[(1)]);
if((state_val_105726 === (1))){
var inst_105704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105705 = [open_QMARK_,timeout_chan];
var inst_105706 = (new cljs.core.PersistentVector(null,2,(5),inst_105704,inst_105705,null));
var state_105725__$1 = state_105725;
return cljs.core.async.ioc_alts_BANG_.call(null,state_105725__$1,(2),inst_105706,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_105726 === (2))){
var inst_105708 = (state_105725[(2)]);
var inst_105709 = cljs.core.nth.call(null,inst_105708,(0),null);
var inst_105710 = cljs.core.nth.call(null,inst_105708,(1),null);
var inst_105711 = cljs.core._EQ_.call(null,inst_105710,timeout_chan);
var state_105725__$1 = (function (){var statearr_105727 = state_105725;
(statearr_105727[(7)] = inst_105709);

return statearr_105727;
})();
if(inst_105711){
var statearr_105728_105738 = state_105725__$1;
(statearr_105728_105738[(1)] = (3));

} else {
var statearr_105729_105739 = state_105725__$1;
(statearr_105729_105739[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105726 === (3))){
var inst_105713 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_105714 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_105715 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_105716 = cljs.core.PersistentHashMap.fromArrays(inst_105714,inst_105715);
var inst_105717 = cljs.core.ex_info.call(null,inst_105713,inst_105716);
var inst_105718 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_105717);
var inst_105719 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_105725__$1 = (function (){var statearr_105730 = state_105725;
(statearr_105730[(8)] = inst_105718);

return statearr_105730;
})();
var statearr_105731_105740 = state_105725__$1;
(statearr_105731_105740[(2)] = inst_105719);

(statearr_105731_105740[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105726 === (4))){
var inst_105721 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_105725__$1 = state_105725;
var statearr_105732_105741 = state_105725__$1;
(statearr_105732_105741[(2)] = inst_105721);

(statearr_105732_105741[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105726 === (5))){
var inst_105723 = (state_105725[(2)]);
var state_105725__$1 = state_105725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105725__$1,inst_105723);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0 = (function (){
var statearr_105733 = [null,null,null,null,null,null,null,null,null];
(statearr_105733[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__);

(statearr_105733[(1)] = (1));

return statearr_105733;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1 = (function (state_105725){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105734){if((e105734 instanceof Object)){
var ex__99978__auto__ = e105734;
var statearr_105735_105742 = state_105725;
(statearr_105735_105742[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105743 = state_105725;
state_105725 = G__105743;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__ = function(state_105725){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1.call(this,state_105725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105736 = f__100070__auto__.call(null);
(statearr_105736[(6)] = c__100069__auto___105737);

return statearr_105736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
