// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__102947 = arguments.length;
switch (G__102947) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__102948 = options;
var map__102948__$1 = (((((!((map__102948 == null))))?(((((map__102948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__102948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__102948):map__102948);
var keyword_fn = cljs.core.get.call(null,map__102948__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.call(null,k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return keyword_fn.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__102976_102997 = cljs.core.seq.call(null,x__$1);
var chunk__102977_102998 = null;
var count__102978_102999 = (0);
var i__102979_103000 = (0);
while(true){
if((i__102979_103000 < count__102978_102999)){
var vec__102986_103001 = cljs.core._nth.call(null,chunk__102977_102998,i__102979_103000);
var k_103002 = cljs.core.nth.call(null,vec__102986_103001,(0),null);
var v_103003 = cljs.core.nth.call(null,vec__102986_103001,(1),null);
goog.object.set(m,keyfn.call(null,k_103002),fluree$db$util$json$thisfn.call(null,v_103003));


var G__103004 = seq__102976_102997;
var G__103005 = chunk__102977_102998;
var G__103006 = count__102978_102999;
var G__103007 = (i__102979_103000 + (1));
seq__102976_102997 = G__103004;
chunk__102977_102998 = G__103005;
count__102978_102999 = G__103006;
i__102979_103000 = G__103007;
continue;
} else {
var temp__5735__auto___103008 = cljs.core.seq.call(null,seq__102976_102997);
if(temp__5735__auto___103008){
var seq__102976_103009__$1 = temp__5735__auto___103008;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__102976_103009__$1)){
var c__4556__auto___103010 = cljs.core.chunk_first.call(null,seq__102976_103009__$1);
var G__103011 = cljs.core.chunk_rest.call(null,seq__102976_103009__$1);
var G__103012 = c__4556__auto___103010;
var G__103013 = cljs.core.count.call(null,c__4556__auto___103010);
var G__103014 = (0);
seq__102976_102997 = G__103011;
chunk__102977_102998 = G__103012;
count__102978_102999 = G__103013;
i__102979_103000 = G__103014;
continue;
} else {
var vec__102989_103015 = cljs.core.first.call(null,seq__102976_103009__$1);
var k_103016 = cljs.core.nth.call(null,vec__102989_103015,(0),null);
var v_103017 = cljs.core.nth.call(null,vec__102989_103015,(1),null);
goog.object.set(m,keyfn.call(null,k_103016),fluree$db$util$json$thisfn.call(null,v_103017));


var G__103018 = cljs.core.next.call(null,seq__102976_103009__$1);
var G__103019 = null;
var G__103020 = (0);
var G__103021 = (0);
seq__102976_102997 = G__103018;
chunk__102977_102998 = G__103019;
count__102978_102999 = G__103020;
i__102979_103000 = G__103021;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
var seq__102992_103022 = cljs.core.seq.call(null,cljs.core.map.call(null,fluree$db$util$json$thisfn,x__$1));
var chunk__102993_103023 = null;
var count__102994_103024 = (0);
var i__102995_103025 = (0);
while(true){
if((i__102995_103025 < count__102994_103024)){
var x_103026__$2 = cljs.core._nth.call(null,chunk__102993_103023,i__102995_103025);
arr.push(x_103026__$2);


var G__103027 = seq__102992_103022;
var G__103028 = chunk__102993_103023;
var G__103029 = count__102994_103024;
var G__103030 = (i__102995_103025 + (1));
seq__102992_103022 = G__103027;
chunk__102993_103023 = G__103028;
count__102994_103024 = G__103029;
i__102995_103025 = G__103030;
continue;
} else {
var temp__5735__auto___103031 = cljs.core.seq.call(null,seq__102992_103022);
if(temp__5735__auto___103031){
var seq__102992_103032__$1 = temp__5735__auto___103031;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__102992_103032__$1)){
var c__4556__auto___103033 = cljs.core.chunk_first.call(null,seq__102992_103032__$1);
var G__103034 = cljs.core.chunk_rest.call(null,seq__102992_103032__$1);
var G__103035 = c__4556__auto___103033;
var G__103036 = cljs.core.count.call(null,c__4556__auto___103033);
var G__103037 = (0);
seq__102992_103022 = G__103034;
chunk__102993_103023 = G__103035;
count__102994_103024 = G__103036;
i__102995_103025 = G__103037;
continue;
} else {
var x_103038__$2 = cljs.core.first.call(null,seq__102992_103032__$1);
arr.push(x_103038__$2);


var G__103039 = cljs.core.next.call(null,seq__102992_103032__$1);
var G__103040 = null;
var G__103041 = (0);
var G__103042 = (0);
seq__102992_103022 = G__103039;
chunk__102993_103023 = G__103040;
count__102994_103024 = G__103041;
i__102995_103025 = G__103042;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn.call(null,x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.call(null,JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string.call(null,x))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js.call(null,x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8.call(null,fluree.db.util.json.stringify.call(null,x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.call(null,(1),depth)){
return ((cljs.core.every_QMARK_.call(null,cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count.call(null,coordinates))));
} else {
return (((!((coordinates == null)))) && (cljs.core.every_QMARK_.call(null,cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,(function (p1__103043_SHARP_){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(depth - (1)),p1__103043_SHARP_);
}),coordinates))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_.call(null,coordinates)) && (((4) <= cljs.core.count.call(null,coordinates))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,coordinates),cljs.core.last.call(null,coordinates))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Feature",(function (geometry){
var and__4115__auto__ = (function (){var or__4126__auto__ = fluree.db.util.json.valid_geojson_QMARK_.call(null,new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.map_QMARK_.call(null,new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4115__auto__;
}
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,(function (p1__103044_SHARP_){
return cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,p1__103044_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
