// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_102127){
var state_val_102128 = (state_102127[(1)]);
if((state_val_102128 === (7))){
var inst_102104 = (state_102127[(7)]);
var state_102127__$1 = state_102127;
var statearr_102129_102145 = state_102127__$1;
(statearr_102129_102145[(2)] = inst_102104);

(statearr_102129_102145[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (1))){
var state_102127__$1 = state_102127;
var statearr_102130_102146 = state_102127__$1;
(statearr_102130_102146[(2)] = null);

(statearr_102130_102146[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_102127,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_102100 = cljs.core.seq.call(null,chs);
var inst_102101 = cljs.core.first.call(null,inst_102100);
var inst_102102 = cljs.core.next.call(null,inst_102100);
var inst_102103 = chs;
var inst_102104 = coll;
var state_102127__$1 = (function (){var statearr_102131 = state_102127;
(statearr_102131[(8)] = inst_102103);

(statearr_102131[(7)] = inst_102104);

(statearr_102131[(9)] = inst_102102);

(statearr_102131[(10)] = inst_102101);

return statearr_102131;
})();
var statearr_102132_102147 = state_102127__$1;
(statearr_102132_102147[(2)] = null);

(statearr_102132_102147[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (6))){
var inst_102123 = (state_102127[(2)]);
var state_102127__$1 = state_102127;
var statearr_102133_102148 = state_102127__$1;
(statearr_102133_102148[(2)] = inst_102123);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102127__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (3))){
var inst_102089 = (state_102127[(2)]);
var state_102127__$1 = state_102127;
var statearr_102134_102149 = state_102127__$1;
(statearr_102134_102149[(2)] = inst_102089);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102127__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (2))){
var inst_102125 = (state_102127[(2)]);
var state_102127__$1 = state_102127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_102127__$1,inst_102125);
} else {
if((state_val_102128 === (9))){
var inst_102121 = (state_102127[(2)]);
var state_102127__$1 = state_102127;
var statearr_102135_102150 = state_102127__$1;
(statearr_102135_102150[(2)] = inst_102121);

(statearr_102135_102150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (5))){
var inst_102103 = (state_102127[(8)]);
var inst_102110 = (state_102127[(11)]);
var inst_102109 = cljs.core.seq.call(null,inst_102103);
var inst_102110__$1 = cljs.core.first.call(null,inst_102109);
var inst_102111 = cljs.core.next.call(null,inst_102109);
var inst_102112 = cljs.core.not.call(null,inst_102110__$1);
var state_102127__$1 = (function (){var statearr_102136 = state_102127;
(statearr_102136[(11)] = inst_102110__$1);

(statearr_102136[(12)] = inst_102111);

return statearr_102136;
})();
if(inst_102112){
var statearr_102137_102151 = state_102127__$1;
(statearr_102137_102151[(1)] = (7));

} else {
var statearr_102138_102152 = state_102127__$1;
(statearr_102138_102152[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (10))){
var inst_102104 = (state_102127[(7)]);
var inst_102111 = (state_102127[(12)]);
var inst_102116 = (state_102127[(2)]);
var inst_102117 = fluree.db.util.async.throw_err.call(null,inst_102116);
var inst_102118 = cljs.core.conj.call(null,inst_102104,inst_102117);
var inst_102103 = inst_102111;
var inst_102104__$1 = inst_102118;
var state_102127__$1 = (function (){var statearr_102139 = state_102127;
(statearr_102139[(8)] = inst_102103);

(statearr_102139[(7)] = inst_102104__$1);

return statearr_102139;
})();
var statearr_102140_102153 = state_102127__$1;
(statearr_102140_102153[(2)] = null);

(statearr_102140_102153[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102128 === (8))){
var inst_102110 = (state_102127[(11)]);
var state_102127__$1 = state_102127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102127__$1,(10),inst_102110);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_102141 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_102141[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__);

(statearr_102141[(1)] = (1));

return statearr_102141;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1 = (function (state_102127){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_102127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e102142){if((e102142 instanceof Object)){
var ex__99978__auto__ = e102142;
var statearr_102143_102154 = state_102127;
(statearr_102143_102154[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e102142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__102155 = state_102127;
state_102127 = G__102155;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__ = function(state_102127){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1.call(this,state_102127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_102144 = f__100070__auto__.call(null);
(statearr_102144[(6)] = c__100069__auto__);

return statearr_102144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_102177){
var state_val_102178 = (state_102177[(1)]);
if((state_val_102178 === (7))){
var inst_102164 = (state_102177[(7)]);
var inst_102163 = (state_102177[(2)]);
var inst_102164__$1 = fluree.db.util.async.throw_err.call(null,inst_102163);
var inst_102165 = (inst_102164__$1 == null);
var state_102177__$1 = (function (){var statearr_102179 = state_102177;
(statearr_102179[(7)] = inst_102164__$1);

return statearr_102179;
})();
if(cljs.core.truth_(inst_102165)){
var statearr_102180_102195 = state_102177__$1;
(statearr_102180_102195[(1)] = (8));

} else {
var statearr_102181_102196 = state_102177__$1;
(statearr_102181_102196[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (1))){
var state_102177__$1 = state_102177;
var statearr_102182_102197 = state_102177__$1;
(statearr_102182_102197[(2)] = null);

(statearr_102182_102197[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_102177,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_102160 = coll;
var state_102177__$1 = (function (){var statearr_102183 = state_102177;
(statearr_102183[(8)] = inst_102160);

return statearr_102183;
})();
var statearr_102184_102198 = state_102177__$1;
(statearr_102184_102198[(2)] = null);

(statearr_102184_102198[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (6))){
var inst_102173 = (state_102177[(2)]);
var state_102177__$1 = state_102177;
var statearr_102185_102199 = state_102177__$1;
(statearr_102185_102199[(2)] = inst_102173);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102177__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (3))){
var inst_102156 = (state_102177[(2)]);
var state_102177__$1 = state_102177;
var statearr_102186_102200 = state_102177__$1;
(statearr_102186_102200[(2)] = inst_102156);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102177__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (2))){
var inst_102175 = (state_102177[(2)]);
var state_102177__$1 = state_102177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_102177__$1,inst_102175);
} else {
if((state_val_102178 === (9))){
var inst_102160 = (state_102177[(8)]);
var inst_102164 = (state_102177[(7)]);
var inst_102168 = cljs.core.conj.call(null,inst_102160,inst_102164);
var inst_102160__$1 = inst_102168;
var state_102177__$1 = (function (){var statearr_102187 = state_102177;
(statearr_102187[(8)] = inst_102160__$1);

return statearr_102187;
})();
var statearr_102188_102201 = state_102177__$1;
(statearr_102188_102201[(2)] = null);

(statearr_102188_102201[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (5))){
var state_102177__$1 = state_102177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_102177__$1,(7),chan);
} else {
if((state_val_102178 === (10))){
var inst_102171 = (state_102177[(2)]);
var state_102177__$1 = state_102177;
var statearr_102189_102202 = state_102177__$1;
(statearr_102189_102202[(2)] = inst_102171);

(statearr_102189_102202[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_102178 === (8))){
var inst_102160 = (state_102177[(8)]);
var state_102177__$1 = state_102177;
var statearr_102190_102203 = state_102177__$1;
(statearr_102190_102203[(2)] = inst_102160);

(statearr_102190_102203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_102191 = [null,null,null,null,null,null,null,null,null];
(statearr_102191[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__);

(statearr_102191[(1)] = (1));

return statearr_102191;
});
var fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1 = (function (state_102177){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_102177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e102192){if((e102192 instanceof Object)){
var ex__99978__auto__ = e102192;
var statearr_102193_102204 = state_102177;
(statearr_102193_102204[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_102177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e102192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__102205 = state_102177;
state_102177 = G__102205;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__ = function(state_102177){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1.call(this,state_102177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__99975__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_102194 = f__100070__auto__.call(null);
(statearr_102194[(6)] = c__100069__auto__);

return statearr_102194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
