// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108826){
var state_val_108827 = (state_108826[(1)]);
if((state_val_108827 === (1))){
var state_108826__$1 = state_108826;
var statearr_108828_108840 = state_108826__$1;
(statearr_108828_108840[(2)] = null);

(statearr_108828_108840[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108827 === (2))){
var inst_108824 = (state_108826[(2)]);
var state_108826__$1 = state_108826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108826__$1,inst_108824);
} else {
if((state_val_108827 === (3))){
var inst_108808 = (state_108826[(2)]);
var state_108826__$1 = state_108826;
var statearr_108829_108841 = state_108826__$1;
(statearr_108829_108841[(2)] = inst_108808);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108827 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108826,(3),Error,null,(2));
var inst_108812 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_108813 = fluree.db.storage.core.storage_read.call(null,conn,inst_108812);
var state_108826__$1 = state_108826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108826__$1,(5),inst_108813);
} else {
if((state_val_108827 === (5))){
var inst_108816 = (state_108826[(7)]);
var inst_108815 = (state_108826[(2)]);
var inst_108816__$1 = fluree.db.util.async.throw_err.call(null,inst_108815);
var state_108826__$1 = (function (){var statearr_108830 = state_108826;
(statearr_108830[(7)] = inst_108816__$1);

return statearr_108830;
})();
if(cljs.core.truth_(inst_108816__$1)){
var statearr_108831_108842 = state_108826__$1;
(statearr_108831_108842[(1)] = (6));

} else {
var statearr_108832_108843 = state_108826__$1;
(statearr_108832_108843[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108827 === (6))){
var inst_108816 = (state_108826[(7)]);
var inst_108818 = fluree.db.storage.core.serde.call(null,conn);
var inst_108819 = fluree.db.serde.protocol._deserialize_block.call(null,inst_108818,inst_108816);
var state_108826__$1 = state_108826;
var statearr_108833_108844 = state_108826__$1;
(statearr_108833_108844[(2)] = inst_108819);

(statearr_108833_108844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108827 === (7))){
var state_108826__$1 = state_108826;
var statearr_108834_108845 = state_108826__$1;
(statearr_108834_108845[(2)] = null);

(statearr_108834_108845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108827 === (8))){
var inst_108822 = (state_108826[(2)]);
var state_108826__$1 = state_108826;
var statearr_108835_108846 = state_108826__$1;
(statearr_108835_108846[(2)] = inst_108822);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__99975__auto____0 = (function (){
var statearr_108836 = [null,null,null,null,null,null,null,null];
(statearr_108836[(0)] = fluree$db$storage$core$read_block_$_state_machine__99975__auto__);

(statearr_108836[(1)] = (1));

return statearr_108836;
});
var fluree$db$storage$core$read_block_$_state_machine__99975__auto____1 = (function (state_108826){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108837){if((e108837 instanceof Object)){
var ex__99978__auto__ = e108837;
var statearr_108838_108847 = state_108826;
(statearr_108838_108847[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108837;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108848 = state_108826;
state_108826 = G__108848;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__99975__auto__ = function(state_108826){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__99975__auto____1.call(this,state_108826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108839 = f__100070__auto__.call(null);
(statearr_108839[(6)] = c__100069__auto__);

return statearr_108839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108868){
var state_val_108869 = (state_108868[(1)]);
if((state_val_108869 === (1))){
var state_108868__$1 = state_108868;
var statearr_108870_108882 = state_108868__$1;
(statearr_108870_108882[(2)] = null);

(statearr_108870_108882[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108869 === (2))){
var inst_108866 = (state_108868[(2)]);
var state_108868__$1 = state_108868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108868__$1,inst_108866);
} else {
if((state_val_108869 === (3))){
var inst_108849 = (state_108868[(2)]);
var state_108868__$1 = state_108868;
var statearr_108871_108883 = state_108868__$1;
(statearr_108871_108883[(2)] = inst_108849);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108868__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108869 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108868,(3),Error,null,(2));
var inst_108853 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_108854 = [inst_108853,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_108855 = fluree.db.storage.core.storage_read.call(null,conn,inst_108854);
var state_108868__$1 = state_108868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108868__$1,(5),inst_108855);
} else {
if((state_val_108869 === (5))){
var inst_108858 = (state_108868[(7)]);
var inst_108857 = (state_108868[(2)]);
var inst_108858__$1 = fluree.db.util.async.throw_err.call(null,inst_108857);
var state_108868__$1 = (function (){var statearr_108872 = state_108868;
(statearr_108872[(7)] = inst_108858__$1);

return statearr_108872;
})();
if(cljs.core.truth_(inst_108858__$1)){
var statearr_108873_108884 = state_108868__$1;
(statearr_108873_108884[(1)] = (6));

} else {
var statearr_108874_108885 = state_108868__$1;
(statearr_108874_108885[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108869 === (6))){
var inst_108858 = (state_108868[(7)]);
var inst_108860 = fluree.db.storage.core.serde.call(null,conn);
var inst_108861 = fluree.db.serde.protocol._deserialize_block.call(null,inst_108860,inst_108858);
var state_108868__$1 = state_108868;
var statearr_108875_108886 = state_108868__$1;
(statearr_108875_108886[(2)] = inst_108861);

(statearr_108875_108886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108869 === (7))){
var state_108868__$1 = state_108868;
var statearr_108876_108887 = state_108868__$1;
(statearr_108876_108887[(2)] = null);

(statearr_108876_108887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108869 === (8))){
var inst_108864 = (state_108868[(2)]);
var state_108868__$1 = state_108868;
var statearr_108877_108888 = state_108868__$1;
(statearr_108877_108888[(2)] = inst_108864);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108868__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0 = (function (){
var statearr_108878 = [null,null,null,null,null,null,null,null];
(statearr_108878[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__);

(statearr_108878[(1)] = (1));

return statearr_108878;
});
var fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1 = (function (state_108868){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108879){if((e108879 instanceof Object)){
var ex__99978__auto__ = e108879;
var statearr_108880_108889 = state_108868;
(statearr_108880_108889[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108868);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108890 = state_108868;
state_108868 = G__108890;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__ = function(state_108868){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1.call(this,state_108868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108881 = f__100070__auto__.call(null);
(statearr_108881[(6)] = c__100069__auto__);

return statearr_108881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108911){
var state_val_108912 = (state_108911[(1)]);
if((state_val_108912 === (1))){
var state_108911__$1 = state_108911;
var statearr_108913_108920 = state_108911__$1;
(statearr_108913_108920[(2)] = null);

(statearr_108913_108920[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108912 === (2))){
var inst_108909 = (state_108911[(2)]);
var state_108911__$1 = state_108911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108911__$1,inst_108909);
} else {
if((state_val_108912 === (3))){
var inst_108891 = (state_108911[(2)]);
var state_108911__$1 = state_108911;
var statearr_108914_108921 = state_108911__$1;
(statearr_108914_108921[(2)] = inst_108891);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108911__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108912 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108911,(3),Error,null,(2));
var inst_108895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108896 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_108897 = (new cljs.core.PersistentVector(null,3,(5),inst_108895,inst_108896,null));
var inst_108898 = cljs.core.select_keys.call(null,block_data,inst_108897);
var inst_108899 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_108898);
var inst_108900 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_108899);
var inst_108901 = [inst_108900,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_108902 = fluree.db.storage.core.serde.call(null,conn);
var inst_108903 = fluree.db.serde.protocol._serialize_block.call(null,inst_108902,inst_108898);
var inst_108904 = fluree.db.storage.core.storage_write.call(null,conn,inst_108901,inst_108903);
var state_108911__$1 = state_108911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108911__$1,(5),inst_108904);
} else {
if((state_val_108912 === (5))){
var inst_108906 = (state_108911[(2)]);
var inst_108907 = fluree.db.util.async.throw_err.call(null,inst_108906);
var state_108911__$1 = state_108911;
var statearr_108915_108922 = state_108911__$1;
(statearr_108915_108922[(2)] = inst_108907);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108911__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0 = (function (){
var statearr_108916 = [null,null,null,null,null,null,null];
(statearr_108916[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__);

(statearr_108916[(1)] = (1));

return statearr_108916;
});
var fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1 = (function (state_108911){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108917){if((e108917 instanceof Object)){
var ex__99978__auto__ = e108917;
var statearr_108918_108923 = state_108911;
(statearr_108918_108923[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108924 = state_108911;
state_108911 = G__108924;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__ = function(state_108911){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1.call(this,state_108911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108919 = f__100070__auto__.call(null);
(statearr_108919[(6)] = c__100069__auto__);

return statearr_108919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108944){
var state_val_108945 = (state_108944[(1)]);
if((state_val_108945 === (1))){
var state_108944__$1 = state_108944;
var statearr_108946_108953 = state_108944__$1;
(statearr_108946_108953[(2)] = null);

(statearr_108946_108953[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108945 === (2))){
var inst_108942 = (state_108944[(2)]);
var state_108944__$1 = state_108944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108944__$1,inst_108942);
} else {
if((state_val_108945 === (3))){
var inst_108925 = (state_108944[(2)]);
var state_108944__$1 = state_108944;
var statearr_108947_108954 = state_108944__$1;
(statearr_108947_108954[(2)] = inst_108925);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108944__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108945 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108944,(3),Error,null,(2));
var inst_108929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108930 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_108931 = (new cljs.core.PersistentVector(null,3,(5),inst_108929,inst_108930,null));
var inst_108932 = cljs.core.select_keys.call(null,block_data,inst_108931);
var inst_108933 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_108932);
var inst_108934 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_108933);
var inst_108935 = fluree.db.storage.core.serde.call(null,conn);
var inst_108936 = fluree.db.serde.protocol._serialize_block.call(null,inst_108935,inst_108932);
var inst_108937 = fluree.db.storage.core.storage_write.call(null,conn,inst_108934,inst_108936);
var state_108944__$1 = state_108944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108944__$1,(5),inst_108937);
} else {
if((state_val_108945 === (5))){
var inst_108939 = (state_108944[(2)]);
var inst_108940 = fluree.db.util.async.throw_err.call(null,inst_108939);
var state_108944__$1 = state_108944;
var statearr_108948_108955 = state_108944__$1;
(statearr_108948_108955[(2)] = inst_108940);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108944__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__99975__auto____0 = (function (){
var statearr_108949 = [null,null,null,null,null,null,null];
(statearr_108949[(0)] = fluree$db$storage$core$write_block_$_state_machine__99975__auto__);

(statearr_108949[(1)] = (1));

return statearr_108949;
});
var fluree$db$storage$core$write_block_$_state_machine__99975__auto____1 = (function (state_108944){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108950){if((e108950 instanceof Object)){
var ex__99978__auto__ = e108950;
var statearr_108951_108956 = state_108944;
(statearr_108951_108956[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108950;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108957 = state_108944;
state_108944 = G__108957;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__99975__auto__ = function(state_108944){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__99975__auto____1.call(this,state_108944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108952 = f__100070__auto__.call(null);
(statearr_108952[(6)] = c__100069__auto__);

return statearr_108952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108974){
var state_val_108975 = (state_108974[(1)]);
if((state_val_108975 === (1))){
var state_108974__$1 = state_108974;
var statearr_108976_108983 = state_108974__$1;
(statearr_108976_108983[(2)] = null);

(statearr_108976_108983[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108975 === (2))){
var inst_108972 = (state_108974[(2)]);
var state_108974__$1 = state_108974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108974__$1,inst_108972);
} else {
if((state_val_108975 === (3))){
var inst_108958 = (state_108974[(2)]);
var state_108974__$1 = state_108974;
var statearr_108977_108984 = state_108974__$1;
(statearr_108977_108984[(2)] = inst_108958);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108974__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108975 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108974,(3),Error,null,(2));
var inst_108962 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_108963 = [history,next_his_key];
var inst_108964 = cljs.core.PersistentHashMap.fromArrays(inst_108962,inst_108963);
var inst_108965 = fluree.db.storage.core.serde.call(null,conn);
var inst_108966 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_108965,inst_108964);
var inst_108967 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_108966);
var state_108974__$1 = state_108974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108974__$1,(5),inst_108967);
} else {
if((state_val_108975 === (5))){
var inst_108969 = (state_108974[(2)]);
var inst_108970 = fluree.db.util.async.throw_err.call(null,inst_108969);
var state_108974__$1 = state_108974;
var statearr_108978_108985 = state_108974__$1;
(statearr_108978_108985[(2)] = inst_108970);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108974__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__99975__auto____0 = (function (){
var statearr_108979 = [null,null,null,null,null,null,null];
(statearr_108979[(0)] = fluree$db$storage$core$write_history_$_state_machine__99975__auto__);

(statearr_108979[(1)] = (1));

return statearr_108979;
});
var fluree$db$storage$core$write_history_$_state_machine__99975__auto____1 = (function (state_108974){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108980){if((e108980 instanceof Object)){
var ex__99978__auto__ = e108980;
var statearr_108981_108986 = state_108974;
(statearr_108981_108986[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108987 = state_108974;
state_108974 = G__108987;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__99975__auto__ = function(state_108974){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__99975__auto____1.call(this,state_108974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108982 = f__100070__auto__.call(null);
(statearr_108982[(6)] = c__100069__auto__);

return statearr_108982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109010){
var state_val_109011 = (state_109010[(1)]);
if((state_val_109011 === (1))){
var state_109010__$1 = state_109010;
var statearr_109012_109022 = state_109010__$1;
(statearr_109012_109022[(2)] = null);

(statearr_109012_109022[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109011 === (2))){
var inst_109008 = (state_109010[(2)]);
var state_109010__$1 = state_109010;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109010__$1,inst_109008);
} else {
if((state_val_109011 === (3))){
var inst_108988 = (state_109010[(2)]);
var state_109010__$1 = state_109010;
var statearr_109013_109023 = state_109010__$1;
(statearr_109013_109023[(2)] = inst_108988);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109010__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109011 === (4))){
var inst_108992 = (state_109010[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109010,(3),Error,null,(2));
var inst_108992__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_108993 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_108992__$1),"-his"].join('');
var inst_108994 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_108995 = [flakes,inst_108993];
var inst_108996 = cljs.core.PersistentHashMap.fromArrays(inst_108994,inst_108995);
var inst_108997 = fluree.db.storage.core.serde.call(null,conn);
var inst_108998 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_108997,inst_108996);
var inst_108999 = fluree.db.storage.core.write_history.call(null,conn,history,inst_108993,null);
var inst_109000 = fluree.db.storage.core.storage_write.call(null,conn,inst_108992__$1,inst_108998);
var state_109010__$1 = (function (){var statearr_109014 = state_109010;
(statearr_109014[(8)] = inst_109000);

(statearr_109014[(7)] = inst_108992__$1);

return statearr_109014;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109010__$1,(5),inst_108999);
} else {
if((state_val_109011 === (5))){
var inst_109000 = (state_109010[(8)]);
var inst_109002 = (state_109010[(2)]);
var inst_109003 = fluree.db.util.async.throw_err.call(null,inst_109002);
var state_109010__$1 = (function (){var statearr_109015 = state_109010;
(statearr_109015[(9)] = inst_109003);

return statearr_109015;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109010__$1,(6),inst_109000);
} else {
if((state_val_109011 === (6))){
var inst_108992 = (state_109010[(7)]);
var inst_109005 = (state_109010[(2)]);
var inst_109006 = fluree.db.util.async.throw_err.call(null,inst_109005);
var state_109010__$1 = (function (){var statearr_109016 = state_109010;
(statearr_109016[(10)] = inst_109006);

return statearr_109016;
})();
var statearr_109017_109024 = state_109010__$1;
(statearr_109017_109024[(2)] = inst_108992);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109010__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_109018 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_109018[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__);

(statearr_109018[(1)] = (1));

return statearr_109018;
});
var fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1 = (function (state_109010){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109010);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109019){if((e109019 instanceof Object)){
var ex__99978__auto__ = e109019;
var statearr_109020_109025 = state_109010;
(statearr_109020_109025[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109010);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109026 = state_109010;
state_109010 = G__109026;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__ = function(state_109010){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1.call(this,state_109010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109021 = f__100070__auto__.call(null);
(statearr_109021[(6)] = c__100069__auto__);

return statearr_109021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109040){
var state_val_109041 = (state_109040[(1)]);
if((state_val_109041 === (1))){
var state_109040__$1 = state_109040;
var statearr_109042_109050 = state_109040__$1;
(statearr_109042_109050[(2)] = null);

(statearr_109042_109050[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109041 === (2))){
var inst_109038 = (state_109040[(2)]);
var state_109040__$1 = state_109040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109040__$1,inst_109038);
} else {
if((state_val_109041 === (3))){
var inst_109027 = (state_109040[(2)]);
var state_109040__$1 = state_109040;
var statearr_109043_109051 = state_109040__$1;
(statearr_109043_109051[(2)] = inst_109027);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109040__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109041 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109040,(3),Error,null,(2));
var inst_109031 = fluree.db.storage.core.serde.call(null,conn);
var inst_109032 = fluree.db.serde.protocol._serialize_branch.call(null,inst_109031,data);
var inst_109033 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_109032);
var state_109040__$1 = state_109040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109040__$1,(5),inst_109033);
} else {
if((state_val_109041 === (5))){
var inst_109035 = (state_109040[(2)]);
var inst_109036 = fluree.db.util.async.throw_err.call(null,inst_109035);
var state_109040__$1 = (function (){var statearr_109044 = state_109040;
(statearr_109044[(7)] = inst_109036);

return statearr_109044;
})();
var statearr_109045_109052 = state_109040__$1;
(statearr_109045_109052[(2)] = key);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109040__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0 = (function (){
var statearr_109046 = [null,null,null,null,null,null,null,null];
(statearr_109046[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__);

(statearr_109046[(1)] = (1));

return statearr_109046;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1 = (function (state_109040){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109047){if((e109047 instanceof Object)){
var ex__99978__auto__ = e109047;
var statearr_109048_109053 = state_109040;
(statearr_109048_109053[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109040);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109054 = state_109040;
state_109040 = G__109054;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__ = function(state_109040){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1.call(this,state_109040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109049 = f__100070__auto__.call(null);
(statearr_109049[(6)] = c__100069__auto__);

return statearr_109049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__109055_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__109055_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__109056){
var map__109057 = p__109056;
var map__109057__$1 = (((((!((map__109057 == null))))?(((((map__109057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109057):map__109057);
var progress = map__109057__$1;
var garbage = cljs.core.get.call(null,map__109057__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109102){
var state_val_109103 = (state_109102[(1)]);
if((state_val_109103 === (7))){
var inst_109079 = (state_109102[(2)]);
var state_109102__$1 = state_109102;
if(cljs.core.truth_(inst_109079)){
var statearr_109104_109125 = state_109102__$1;
(statearr_109104_109125[(1)] = (11));

} else {
var statearr_109105_109126 = state_109102__$1;
(statearr_109105_109126[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (1))){
var state_109102__$1 = state_109102;
var statearr_109106_109127 = state_109102__$1;
(statearr_109106_109127[(2)] = null);

(statearr_109106_109127[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109102,(3),Error,null,(2));
var inst_109065 = (db == null);
var inst_109066 = cljs.core.not.call(null,inst_109065);
var state_109102__$1 = state_109102;
if(inst_109066){
var statearr_109107_109128 = state_109102__$1;
(statearr_109107_109128[(1)] = (5));

} else {
var statearr_109108_109129 = state_109102__$1;
(statearr_109108_109129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (13))){
var inst_109089 = (state_109102[(7)]);
var inst_109084 = (state_109102[(2)]);
var inst_109085 = cljs.core.get.call(null,inst_109084,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_109086 = cljs.core.get.call(null,inst_109084,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_109087 = cljs.core.get.call(null,inst_109084,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_109088 = cljs.core.get.call(null,inst_109084,new cljs.core.Keyword(null,"block","block",664686210));
var inst_109089__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_109086,inst_109087,inst_109088);
var inst_109090 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_109091 = [inst_109087,inst_109088,garbage];
var inst_109092 = cljs.core.PersistentHashMap.fromArrays(inst_109090,inst_109091);
var inst_109093 = fluree.db.storage.core.serde.call(null,inst_109085);
var inst_109094 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_109093,inst_109092);
var inst_109095 = fluree.db.storage.core.storage_write.call(null,inst_109085,inst_109089__$1,inst_109094);
var state_109102__$1 = (function (){var statearr_109109 = state_109102;
(statearr_109109[(7)] = inst_109089__$1);

return statearr_109109;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109102__$1,(14),inst_109095);
} else {
if((state_val_109103 === (6))){
var state_109102__$1 = state_109102;
var statearr_109110_109130 = state_109102__$1;
(statearr_109110_109130[(2)] = false);

(statearr_109110_109130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (3))){
var inst_109059 = (state_109102[(2)]);
var state_109102__$1 = state_109102;
var statearr_109111_109131 = state_109102__$1;
(statearr_109111_109131[(2)] = inst_109059);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109102__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (12))){
var state_109102__$1 = state_109102;
var statearr_109112_109132 = state_109102__$1;
(statearr_109112_109132[(2)] = db);

(statearr_109112_109132[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (2))){
var inst_109100 = (state_109102[(2)]);
var state_109102__$1 = state_109102;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109102__$1,inst_109100);
} else {
if((state_val_109103 === (11))){
var inst_109081 = cljs.core.apply.call(null,cljs.core.hash_map,db);
var state_109102__$1 = state_109102;
var statearr_109113_109133 = state_109102__$1;
(statearr_109113_109133[(2)] = inst_109081);

(statearr_109113_109133[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (9))){
var state_109102__$1 = state_109102;
var statearr_109114_109134 = state_109102__$1;
(statearr_109114_109134[(2)] = false);

(statearr_109114_109134[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (5))){
var inst_109068 = db.cljs$lang$protocol_mask$partition0$;
var inst_109069 = (inst_109068 & (64));
var inst_109070 = db.cljs$core$ISeq$;
var inst_109071 = (cljs.core.PROTOCOL_SENTINEL === inst_109070);
var inst_109072 = ((inst_109069) || (inst_109071));
var state_109102__$1 = state_109102;
if(cljs.core.truth_(inst_109072)){
var statearr_109115_109135 = state_109102__$1;
(statearr_109115_109135[(1)] = (8));

} else {
var statearr_109116_109136 = state_109102__$1;
(statearr_109116_109136[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (14))){
var inst_109089 = (state_109102[(7)]);
var inst_109097 = (state_109102[(2)]);
var inst_109098 = fluree.db.util.async.throw_err.call(null,inst_109097);
var state_109102__$1 = (function (){var statearr_109117 = state_109102;
(statearr_109117[(8)] = inst_109098);

return statearr_109117;
})();
var statearr_109118_109137 = state_109102__$1;
(statearr_109118_109137[(2)] = inst_109089);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109102__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (10))){
var inst_109076 = (state_109102[(2)]);
var state_109102__$1 = state_109102;
var statearr_109119_109138 = state_109102__$1;
(statearr_109119_109138[(2)] = inst_109076);

(statearr_109119_109138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109103 === (8))){
var state_109102__$1 = state_109102;
var statearr_109120_109139 = state_109102__$1;
(statearr_109120_109139[(2)] = true);

(statearr_109120_109139[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0 = (function (){
var statearr_109121 = [null,null,null,null,null,null,null,null,null];
(statearr_109121[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__);

(statearr_109121[(1)] = (1));

return statearr_109121;
});
var fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1 = (function (state_109102){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109122){if((e109122 instanceof Object)){
var ex__99978__auto__ = e109122;
var statearr_109123_109140 = state_109102;
(statearr_109123_109140[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109102);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109141 = state_109102;
state_109102 = G__109141;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__ = function(state_109102){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1.call(this,state_109102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__99975__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109124 = f__100070__auto__.call(null);
(statearr_109124[(6)] = c__100069__auto__);

return statearr_109124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__109143 = arguments.length;
switch (G__109143) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109214){
var state_val_109215 = (state_109214[(1)]);
if((state_val_109215 === (7))){
var inst_109164 = (state_109214[(2)]);
var state_109214__$1 = state_109214;
if(cljs.core.truth_(inst_109164)){
var statearr_109216_109247 = state_109214__$1;
(statearr_109216_109247[(1)] = (11));

} else {
var statearr_109217_109248 = state_109214__$1;
(statearr_109217_109248[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (20))){
var inst_109183 = (state_109214[(7)]);
var inst_109209 = (state_109214[(2)]);
var inst_109210 = fluree.db.util.async.throw_err.call(null,inst_109209);
var state_109214__$1 = (function (){var statearr_109218 = state_109214;
(statearr_109218[(8)] = inst_109210);

return statearr_109218;
})();
var statearr_109219_109249 = state_109214__$1;
(statearr_109219_109249[(2)] = inst_109183);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109214__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (1))){
var state_109214__$1 = state_109214;
var statearr_109220_109250 = state_109214__$1;
(statearr_109220_109250[(2)] = null);

(statearr_109220_109250[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109214,(3),Error,null,(2));
var inst_109150 = (db == null);
var inst_109151 = cljs.core.not.call(null,inst_109150);
var state_109214__$1 = state_109214;
if(inst_109151){
var statearr_109221_109251 = state_109214__$1;
(statearr_109221_109251[(1)] = (5));

} else {
var statearr_109222_109252 = state_109214__$1;
(statearr_109222_109252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (15))){
var state_109214__$1 = state_109214;
var statearr_109223_109253 = state_109214__$1;
(statearr_109223_109253[(2)] = (0));

(statearr_109223_109253[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (13))){
var inst_109176 = (state_109214[(9)]);
var inst_109186 = (state_109214[(10)]);
var inst_109178 = (state_109214[(11)]);
var inst_109174 = (state_109214[(12)]);
var inst_109169 = (state_109214[(2)]);
var inst_109170 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_109171 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_109172 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_109173 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_109174__$1 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_109175 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_109176__$1 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"block","block",664686210));
var inst_109177 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_109178__$1 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_109179 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_109180 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_109181 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_109182 = cljs.core.get.call(null,inst_109169,new cljs.core.Keyword(null,"post","post",269697687));
var inst_109183 = fluree.db.storage.core.ledger_root_key.call(null,inst_109170,inst_109178__$1,inst_109176__$1);
var inst_109184 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_109185 = fluree.db.storage.core.child_data.call(null,inst_109177);
var inst_109186__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_109174__$1);
var state_109214__$1 = (function (){var statearr_109224 = state_109214;
(statearr_109224[(13)] = inst_109180);

(statearr_109224[(14)] = inst_109172);

(statearr_109224[(9)] = inst_109176__$1);

(statearr_109224[(10)] = inst_109186__$1);

(statearr_109224[(11)] = inst_109178__$1);

(statearr_109224[(15)] = inst_109184);

(statearr_109224[(16)] = inst_109181);

(statearr_109224[(17)] = inst_109179);

(statearr_109224[(18)] = inst_109185);

(statearr_109224[(7)] = inst_109183);

(statearr_109224[(12)] = inst_109174__$1);

(statearr_109224[(19)] = inst_109175);

(statearr_109224[(20)] = inst_109173);

(statearr_109224[(21)] = inst_109171);

(statearr_109224[(22)] = inst_109182);

return statearr_109224;
})();
if(cljs.core.truth_(inst_109186__$1)){
var statearr_109225_109254 = state_109214__$1;
(statearr_109225_109254[(1)] = (14));

} else {
var statearr_109226_109255 = state_109214__$1;
(statearr_109226_109255[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (6))){
var state_109214__$1 = state_109214;
var statearr_109227_109256 = state_109214__$1;
(statearr_109227_109256[(2)] = false);

(statearr_109227_109256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (17))){
var state_109214__$1 = state_109214;
var statearr_109228_109257 = state_109214__$1;
(statearr_109228_109257[(2)] = custom_ecount);

(statearr_109228_109257[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (3))){
var inst_109144 = (state_109214[(2)]);
var state_109214__$1 = state_109214;
var statearr_109229_109258 = state_109214__$1;
(statearr_109229_109258[(2)] = inst_109144);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109214__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (12))){
var state_109214__$1 = state_109214;
var statearr_109230_109259 = state_109214__$1;
(statearr_109230_109259[(2)] = db);

(statearr_109230_109259[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (2))){
var inst_109212 = (state_109214[(2)]);
var state_109214__$1 = state_109214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109214__$1,inst_109212);
} else {
if((state_val_109215 === (19))){
var inst_109180 = (state_109214[(13)]);
var inst_109172 = (state_109214[(14)]);
var inst_109176 = (state_109214[(9)]);
var inst_109178 = (state_109214[(11)]);
var inst_109190 = (state_109214[(23)]);
var inst_109184 = (state_109214[(15)]);
var inst_109181 = (state_109214[(16)]);
var inst_109185 = (state_109214[(18)]);
var inst_109183 = (state_109214[(7)]);
var inst_109174 = (state_109214[(12)]);
var inst_109175 = (state_109214[(19)]);
var inst_109173 = (state_109214[(20)]);
var inst_109171 = (state_109214[(21)]);
var inst_109182 = (state_109214[(22)]);
var inst_109194 = (state_109214[(2)]);
var inst_109195 = fluree.db.storage.core.child_data.call(null,inst_109180);
var inst_109196 = fluree.db.storage.core.child_data.call(null,inst_109182);
var inst_109197 = fluree.db.util.core.current_time_millis.call(null);
var inst_109198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109199 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_109200 = (new cljs.core.PersistentVector(null,2,(5),inst_109198,inst_109199,null));
var inst_109201 = cljs.core.select_keys.call(null,inst_109174,inst_109200);
var inst_109202 = fluree.db.storage.core.child_data.call(null,inst_109173);
var inst_109203 = [inst_109176,inst_109185,inst_109178,inst_109190,inst_109194,inst_109195,inst_109196,inst_109171,inst_109197,inst_109172,inst_109181,inst_109201,inst_109202];
var inst_109204 = cljs.core.PersistentHashMap.fromArrays(inst_109184,inst_109203);
var inst_109205 = fluree.db.storage.core.serde.call(null,inst_109175);
var inst_109206 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_109205,inst_109204);
var inst_109207 = fluree.db.storage.core.storage_write.call(null,inst_109175,inst_109183,inst_109206);
var state_109214__$1 = state_109214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109214__$1,(20),inst_109207);
} else {
if((state_val_109215 === (11))){
var inst_109166 = cljs.core.apply.call(null,cljs.core.hash_map,db);
var state_109214__$1 = state_109214;
var statearr_109231_109260 = state_109214__$1;
(statearr_109231_109260[(2)] = inst_109166);

(statearr_109231_109260[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (9))){
var state_109214__$1 = state_109214;
var statearr_109232_109261 = state_109214__$1;
(statearr_109232_109261[(2)] = false);

(statearr_109232_109261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (5))){
var inst_109153 = db.cljs$lang$protocol_mask$partition0$;
var inst_109154 = (inst_109153 & (64));
var inst_109155 = db.cljs$core$ISeq$;
var inst_109156 = (cljs.core.PROTOCOL_SENTINEL === inst_109155);
var inst_109157 = ((inst_109154) || (inst_109156));
var state_109214__$1 = state_109214;
if(cljs.core.truth_(inst_109157)){
var statearr_109233_109262 = state_109214__$1;
(statearr_109233_109262[(1)] = (8));

} else {
var statearr_109234_109263 = state_109214__$1;
(statearr_109234_109263[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (14))){
var inst_109186 = (state_109214[(10)]);
var state_109214__$1 = state_109214;
var statearr_109235_109264 = state_109214__$1;
(statearr_109235_109264[(2)] = inst_109186);

(statearr_109235_109264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (16))){
var inst_109190 = (state_109214[(2)]);
var state_109214__$1 = (function (){var statearr_109236 = state_109214;
(statearr_109236[(23)] = inst_109190);

return statearr_109236;
})();
if(cljs.core.truth_(custom_ecount)){
var statearr_109237_109265 = state_109214__$1;
(statearr_109237_109265[(1)] = (17));

} else {
var statearr_109238_109266 = state_109214__$1;
(statearr_109238_109266[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (10))){
var inst_109161 = (state_109214[(2)]);
var state_109214__$1 = state_109214;
var statearr_109239_109267 = state_109214__$1;
(statearr_109239_109267[(2)] = inst_109161);

(statearr_109239_109267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (18))){
var inst_109179 = (state_109214[(17)]);
var state_109214__$1 = state_109214;
var statearr_109240_109268 = state_109214__$1;
(statearr_109240_109268[(2)] = inst_109179);

(statearr_109240_109268[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109215 === (8))){
var state_109214__$1 = state_109214;
var statearr_109241_109269 = state_109214__$1;
(statearr_109241_109269[(2)] = true);

(statearr_109241_109269[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__99975__auto__ = null;
var fluree$db$storage$core$state_machine__99975__auto____0 = (function (){
var statearr_109242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109242[(0)] = fluree$db$storage$core$state_machine__99975__auto__);

(statearr_109242[(1)] = (1));

return statearr_109242;
});
var fluree$db$storage$core$state_machine__99975__auto____1 = (function (state_109214){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109243){if((e109243 instanceof Object)){
var ex__99978__auto__ = e109243;
var statearr_109244_109270 = state_109214;
(statearr_109244_109270[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109214);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109243;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109271 = state_109214;
state_109214 = G__109271;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99975__auto__ = function(state_109214){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99975__auto____1.call(this,state_109214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99975__auto____0;
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99975__auto____1;
return fluree$db$storage$core$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109245 = f__100070__auto__.call(null);
(statearr_109245[(6)] = c__100069__auto__);

return statearr_109245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___109313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109298){
var state_val_109299 = (state_109298[(1)]);
if((state_val_109299 === (1))){
var state_109298__$1 = state_109298;
var statearr_109300_109314 = state_109298__$1;
(statearr_109300_109314[(2)] = null);

(statearr_109300_109314[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109299 === (2))){
var inst_109296 = (state_109298[(2)]);
var state_109298__$1 = state_109298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109298__$1,inst_109296);
} else {
if((state_val_109299 === (3))){
var inst_109272 = (state_109298[(2)]);
var inst_109273 = error_fn.call(null);
var inst_109274 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109272);
var inst_109275 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_109298__$1 = (function (){var statearr_109301 = state_109298;
(statearr_109301[(7)] = inst_109273);

(statearr_109301[(8)] = inst_109274);

return statearr_109301;
})();
var statearr_109302_109315 = state_109298__$1;
(statearr_109302_109315[(2)] = inst_109275);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109298__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109299 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109298,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_109279 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_109298__$1 = state_109298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109298__$1,(5),inst_109279);
} else {
if((state_val_109299 === (5))){
var inst_109281 = (state_109298[(9)]);
var inst_109281__$1 = (state_109298[(2)]);
var inst_109282 = (inst_109281__$1 == null);
var inst_109283 = (inst_109281__$1 instanceof Error);
var inst_109284 = ((inst_109282) || (inst_109283));
var state_109298__$1 = (function (){var statearr_109303 = state_109298;
(statearr_109303[(9)] = inst_109281__$1);

return statearr_109303;
})();
if(cljs.core.truth_(inst_109284)){
var statearr_109304_109316 = state_109298__$1;
(statearr_109304_109316[(1)] = (6));

} else {
var statearr_109305_109317 = state_109298__$1;
(statearr_109305_109317[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109299 === (6))){
var inst_109286 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_109298__$1 = state_109298;
var statearr_109306_109318 = state_109298__$1;
(statearr_109306_109318[(2)] = inst_109286);

(statearr_109306_109318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109299 === (7))){
var inst_109281 = (state_109298[(9)]);
var inst_109288 = fluree.db.storage.core.serde.call(null,conn);
var inst_109289 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_109288,inst_109281);
var inst_109290 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_109289);
var inst_109291 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_109290);
var inst_109292 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109291);
var state_109298__$1 = state_109298;
var statearr_109307_109319 = state_109298__$1;
(statearr_109307_109319[(2)] = inst_109292);

(statearr_109307_109319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109299 === (8))){
var inst_109294 = (state_109298[(2)]);
var state_109298__$1 = state_109298;
var statearr_109308_109320 = state_109298__$1;
(statearr_109308_109320[(2)] = inst_109294);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109298__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0 = (function (){
var statearr_109309 = [null,null,null,null,null,null,null,null,null,null];
(statearr_109309[(0)] = fluree$db$storage$core$reify_history_$_state_machine__99975__auto__);

(statearr_109309[(1)] = (1));

return statearr_109309;
});
var fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1 = (function (state_109298){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109310){if((e109310 instanceof Object)){
var ex__99978__auto__ = e109310;
var statearr_109311_109321 = state_109298;
(statearr_109311_109321[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109322 = state_109298;
state_109298 = G__109322;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__ = function(state_109298){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1.call(this,state_109298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109312 = f__100070__auto__.call(null);
(statearr_109312[(6)] = c__100069__auto___109313);

return statearr_109312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__109324 = arguments.length;
switch (G__109324) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___109424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109384){
var state_val_109385 = (state_109384[(1)]);
if((state_val_109385 === (7))){
var inst_109339 = (state_109384[(7)]);
var inst_109343 = (inst_109339 < t);
var state_109384__$1 = state_109384;
if(cljs.core.truth_(inst_109343)){
var statearr_109386_109425 = state_109384__$1;
(statearr_109386_109425[(1)] = (9));

} else {
var statearr_109387_109426 = state_109384__$1;
(statearr_109387_109426[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (20))){
var inst_109339 = (state_109384[(7)]);
var inst_109354 = (state_109384[(8)]);
var inst_109367 = (state_109384[(9)]);
var inst_109338 = (state_109384[(10)]);
var inst_109337 = (state_109384[(11)]);
var inst_109374 = (state_109384[(2)]);
var inst_109375 = (function (){var base_node = inst_109337;
var first_flake = inst_109338;
var node_t = inst_109339;
var source = inst_109354;
var coll = inst_109367;
var conj_QMARK_ = inst_109374;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_109376 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_109337);
var inst_109377 = cljs.core.reduce.call(null,inst_109375,inst_109376,inst_109367);
var inst_109378 = cljs.core.doall.call(null,inst_109377);
var inst_109379 = cljs.core.assoc.call(null,inst_109337,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_109378);
var inst_109380 = cljs.core.async.put_BANG_.call(null,result_ch,inst_109379);
var state_109384__$1 = state_109384;
var statearr_109388_109427 = state_109384__$1;
(statearr_109388_109427[(2)] = inst_109380);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109384__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (1))){
var state_109384__$1 = state_109384;
var statearr_109389_109428 = state_109384__$1;
(statearr_109389_109428[(2)] = null);

(statearr_109389_109428[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109384,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_109334 = fluree.db.dbproto._resolve.call(null,node);
var state_109384__$1 = state_109384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109384__$1,(5),inst_109334);
} else {
if((state_val_109385 === (15))){
var inst_109354 = (state_109384[(8)]);
var inst_109367 = (state_109384[(2)]);
var state_109384__$1 = (function (){var statearr_109390 = state_109384;
(statearr_109390[(9)] = inst_109367);

return statearr_109390;
})();
var G__109391_109429 = inst_109354;
var G__109391_109430__$1 = (((G__109391_109429 instanceof cljs.core.Keyword))?G__109391_109429.fqn:null);
switch (G__109391_109430__$1) {
case "novelty":
var statearr_109392_109432 = state_109384__$1;
(statearr_109392_109432[(1)] = (21));


break;
case "history":
var statearr_109393_109433 = state_109384__$1;
(statearr_109393_109433[(1)] = (22));


break;
case "none":
var statearr_109394_109434 = state_109384__$1;
(statearr_109394_109434[(1)] = (23));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__109391_109430__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (21))){
var inst_109339 = (state_109384[(7)]);
var inst_109354 = (state_109384[(8)]);
var inst_109367 = (state_109384[(9)]);
var inst_109338 = (state_109384[(10)]);
var inst_109337 = (state_109384[(11)]);
var inst_109368 = (function (){var base_node = inst_109337;
var first_flake = inst_109338;
var node_t = inst_109339;
var source = inst_109354;
var coll = inst_109367;
return (function (f){
return f.op === true;
});
})();
var state_109384__$1 = state_109384;
var statearr_109395_109435 = state_109384__$1;
(statearr_109395_109435[(2)] = inst_109368);

(statearr_109395_109435[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (13))){
var state_109384__$1 = state_109384;
var statearr_109396_109436 = state_109384__$1;
(statearr_109396_109436[(2)] = null);

(statearr_109396_109436[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (22))){
var inst_109339 = (state_109384[(7)]);
var inst_109354 = (state_109384[(8)]);
var inst_109367 = (state_109384[(9)]);
var inst_109338 = (state_109384[(10)]);
var inst_109337 = (state_109384[(11)]);
var inst_109370 = (function (){var base_node = inst_109337;
var first_flake = inst_109338;
var node_t = inst_109339;
var source = inst_109354;
var coll = inst_109367;
return (function (f){
return f.op === false;
});
})();
var state_109384__$1 = state_109384;
var statearr_109397_109437 = state_109384__$1;
(statearr_109397_109437[(2)] = inst_109370);

(statearr_109397_109437[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (6))){
var state_109384__$1 = state_109384;
var statearr_109398_109438 = state_109384__$1;
(statearr_109398_109438[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_109398_109438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (17))){
var inst_109339 = (state_109384[(7)]);
var inst_109354 = (state_109384[(8)]);
var inst_109338 = (state_109384[(10)]);
var inst_109337 = (state_109384[(11)]);
var inst_109357 = (function (){var base_node = inst_109337;
var first_flake = inst_109338;
var node_t = inst_109339;
var source = inst_109354;
return (function (p1__109326_SHARP_){
return (p1__109326_SHARP_.t <= t);
});
})();
var inst_109358 = fluree.db.dbproto._resolve_history.call(null,node);
var state_109384__$1 = (function (){var statearr_109399 = state_109384;
(statearr_109399[(12)] = inst_109357);

return statearr_109399;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109384__$1,(18),inst_109358);
} else {
if((state_val_109385 === (3))){
var inst_109327 = (state_109384[(2)]);
var inst_109328 = error_fn.call(null);
var inst_109329 = cljs.core.async.put_BANG_.call(null,result_ch,inst_109327);
var inst_109330 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_109384__$1 = (function (){var statearr_109400 = state_109384;
(statearr_109400[(13)] = inst_109328);

(statearr_109400[(14)] = inst_109329);

return statearr_109400;
})();
var statearr_109401_109439 = state_109384__$1;
(statearr_109401_109439[(2)] = inst_109330);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109384__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (12))){
var state_109384__$1 = state_109384;
var statearr_109402_109440 = state_109384__$1;
(statearr_109402_109440[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_109402_109440[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (2))){
var inst_109382 = (state_109384[(2)]);
var state_109384__$1 = state_109384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109384__$1,inst_109382);
} else {
if((state_val_109385 === (23))){
var state_109384__$1 = state_109384;
var statearr_109403_109441 = state_109384__$1;
(statearr_109403_109441[(2)] = null);

(statearr_109403_109441[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (19))){
var inst_109364 = cljs.core.PersistentVector.EMPTY;
var state_109384__$1 = state_109384;
var statearr_109404_109442 = state_109384__$1;
(statearr_109404_109442[(2)] = inst_109364);

(statearr_109404_109442[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (11))){
var inst_109352 = (state_109384[(2)]);
var state_109384__$1 = state_109384;
var statearr_109405_109443 = state_109384__$1;
(statearr_109405_109443[(2)] = inst_109352);

(statearr_109405_109443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (9))){
var state_109384__$1 = state_109384;
var statearr_109406_109444 = state_109384__$1;
(statearr_109406_109444[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_109406_109444[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (5))){
var inst_109339 = (state_109384[(7)]);
var inst_109337 = (state_109384[(11)]);
var inst_109336 = (state_109384[(2)]);
var inst_109337__$1 = fluree.db.util.async.throw_err.call(null,inst_109336);
var inst_109338 = fluree.db.dbproto._first_flake.call(null,inst_109337__$1);
var inst_109339__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_109337__$1);
var inst_109340 = (inst_109339__$1 > t);
var state_109384__$1 = (function (){var statearr_109407 = state_109384;
(statearr_109407[(7)] = inst_109339__$1);

(statearr_109407[(10)] = inst_109338);

(statearr_109407[(11)] = inst_109337__$1);

return statearr_109407;
})();
if(cljs.core.truth_(inst_109340)){
var statearr_109408_109445 = state_109384__$1;
(statearr_109408_109445[(1)] = (6));

} else {
var statearr_109409_109446 = state_109384__$1;
(statearr_109409_109446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (14))){
var inst_109350 = (state_109384[(2)]);
var state_109384__$1 = state_109384;
var statearr_109410_109447 = state_109384__$1;
(statearr_109410_109447[(2)] = inst_109350);

(statearr_109410_109447[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (16))){
var inst_109338 = (state_109384[(10)]);
var inst_109355 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_109338,rhs,leftmost_QMARK_,t);
var state_109384__$1 = state_109384;
var statearr_109411_109448 = state_109384__$1;
(statearr_109411_109448[(2)] = inst_109355);

(statearr_109411_109448[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (10))){
var inst_109339 = (state_109384[(7)]);
var inst_109346 = cljs.core._EQ_.call(null,inst_109339,t);
var state_109384__$1 = state_109384;
if(inst_109346){
var statearr_109412_109449 = state_109384__$1;
(statearr_109412_109449[(1)] = (12));

} else {
var statearr_109413_109450 = state_109384__$1;
(statearr_109413_109450[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (18))){
var inst_109357 = (state_109384[(12)]);
var inst_109360 = (state_109384[(2)]);
var inst_109361 = fluree.db.util.async.throw_err.call(null,inst_109360);
var inst_109362 = cljs.core.take_while.call(null,inst_109357,inst_109361);
var state_109384__$1 = state_109384;
var statearr_109414_109451 = state_109384__$1;
(statearr_109414_109451[(2)] = inst_109362);

(statearr_109414_109451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109385 === (8))){
var inst_109354 = (state_109384[(8)]);
var inst_109354__$1 = (state_109384[(2)]);
var state_109384__$1 = (function (){var statearr_109415 = state_109384;
(statearr_109415[(8)] = inst_109354__$1);

return statearr_109415;
})();
var G__109416_109452 = inst_109354__$1;
var G__109416_109453__$1 = (((G__109416_109452 instanceof cljs.core.Keyword))?G__109416_109452.fqn:null);
switch (G__109416_109453__$1) {
case "novelty":
var statearr_109417_109455 = state_109384__$1;
(statearr_109417_109455[(1)] = (16));


break;
case "history":
var statearr_109418_109456 = state_109384__$1;
(statearr_109418_109456[(1)] = (17));


break;
case "none":
var statearr_109419_109457 = state_109384__$1;
(statearr_109419_109457[(1)] = (19));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__109416_109453__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0 = (function (){
var statearr_109420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109420[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__);

(statearr_109420[(1)] = (1));

return statearr_109420;
});
var fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1 = (function (state_109384){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109421){if((e109421 instanceof Object)){
var ex__99978__auto__ = e109421;
var statearr_109422_109458 = state_109384;
(statearr_109422_109458[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109384);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109421;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109459 = state_109384;
state_109384 = G__109459;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__ = function(state_109384){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1.call(this,state_109384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__99975__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109423 = f__100070__auto__.call(null);
(statearr_109423[(6)] = c__100069__auto___109424);

return statearr_109423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109513){
var state_val_109514 = (state_109513[(1)]);
if((state_val_109514 === (7))){
var inst_109493 = (state_109513[(2)]);
var inst_109494 = fluree.db.dbproto._first_flake.call(null,node);
var inst_109495 = fluree.db.dbproto._rhs.call(null,node);
var inst_109496 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_109513__$1 = (function (){var statearr_109515 = state_109513;
(statearr_109515[(7)] = inst_109493);

(statearr_109515[(8)] = inst_109494);

(statearr_109515[(9)] = inst_109495);

return statearr_109515;
})();
if(cljs.core.truth_(inst_109496)){
var statearr_109516_109544 = state_109513__$1;
(statearr_109516_109544[(1)] = (15));

} else {
var statearr_109517_109545 = state_109513__$1;
(statearr_109517_109545[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (1))){
var state_109513__$1 = state_109513;
var statearr_109518_109546 = state_109513__$1;
(statearr_109518_109546[(2)] = null);

(statearr_109518_109546[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (4))){
var inst_109468 = (state_109513[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109513,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_109468__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_109469 = (from_t == null);
var inst_109470 = (inst_109468__$1 <= from_t);
var inst_109471 = ((inst_109469) || (inst_109470));
var state_109513__$1 = (function (){var statearr_109519 = state_109513;
(statearr_109519[(10)] = inst_109468__$1);

return statearr_109519;
})();
if(cljs.core.truth_(inst_109471)){
var statearr_109520_109547 = state_109513__$1;
(statearr_109520_109547[(1)] = (5));

} else {
var statearr_109521_109548 = state_109513__$1;
(statearr_109521_109548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (15))){
var state_109513__$1 = state_109513;
var statearr_109522_109549 = state_109513__$1;
(statearr_109522_109549[(2)] = null);

(statearr_109522_109549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (13))){
var inst_109484 = (state_109513[(11)]);
var state_109513__$1 = state_109513;
var statearr_109523_109550 = state_109513__$1;
(statearr_109523_109550[(2)] = inst_109484);

(statearr_109523_109550[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (6))){
var state_109513__$1 = state_109513;
var statearr_109524_109551 = state_109513__$1;
(statearr_109524_109551[(2)] = null);

(statearr_109524_109551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (17))){
var inst_109493 = (state_109513[(7)]);
var inst_109494 = (state_109513[(8)]);
var inst_109495 = (state_109513[(9)]);
var inst_109507 = (state_109513[(2)]);
var inst_109508 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_109494,inst_109495,leftmost_QMARK_,to_t);
var inst_109509 = cljs.core.into.call(null,inst_109508,inst_109493);
var state_109513__$1 = (function (){var statearr_109525 = state_109513;
(statearr_109525[(12)] = inst_109507);

return statearr_109525;
})();
var statearr_109526_109552 = state_109513__$1;
(statearr_109526_109552[(2)] = inst_109509);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109513__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (3))){
var inst_109462 = (state_109513[(2)]);
var inst_109463 = fluree.db.util.log.error.call(null,inst_109462);
var inst_109464 = (function(){throw inst_109462})();
var state_109513__$1 = (function (){var statearr_109527 = state_109513;
(statearr_109527[(13)] = inst_109463);

return statearr_109527;
})();
var statearr_109528_109553 = state_109513__$1;
(statearr_109528_109553[(2)] = inst_109464);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109513__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (12))){
var inst_109468 = (state_109513[(10)]);
var inst_109484 = (state_109513[(11)]);
var inst_109486 = (function (){var node_t = inst_109468;
var G__109473 = inst_109484;
return (function (p1__109461_SHARP_){
return (p1__109461_SHARP_.t <= from_t);
});
})();
var inst_109487 = cljs.core.take_while.call(null,inst_109486,inst_109484);
var state_109513__$1 = state_109513;
var statearr_109529_109554 = state_109513__$1;
(statearr_109529_109554[(2)] = inst_109487);

(statearr_109529_109554[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (2))){
var inst_109511 = (state_109513[(2)]);
var state_109513__$1 = state_109513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109513__$1,inst_109511);
} else {
if((state_val_109514 === (11))){
var inst_109484 = (state_109513[(2)]);
var state_109513__$1 = (function (){var statearr_109530 = state_109513;
(statearr_109530[(11)] = inst_109484);

return statearr_109530;
})();
if(cljs.core.truth_(from_t)){
var statearr_109531_109555 = state_109513__$1;
(statearr_109531_109555[(1)] = (12));

} else {
var statearr_109532_109556 = state_109513__$1;
(statearr_109532_109556[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (9))){
var inst_109468 = (state_109513[(10)]);
var inst_109477 = (state_109513[(14)]);
var inst_109480 = (function (){var node_t = inst_109468;
var G__109473 = inst_109477;
return (function (p1__109460_SHARP_){
return (p1__109460_SHARP_.t < to_t);
});
})();
var inst_109481 = cljs.core.drop_while.call(null,inst_109480,inst_109477);
var state_109513__$1 = state_109513;
var statearr_109533_109557 = state_109513__$1;
(statearr_109533_109557[(2)] = inst_109481);

(statearr_109533_109557[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (5))){
var inst_109474 = fluree.db.dbproto._resolve_history.call(null,node);
var state_109513__$1 = state_109513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109513__$1,(8),inst_109474);
} else {
if((state_val_109514 === (14))){
var inst_109490 = (state_109513[(2)]);
var state_109513__$1 = state_109513;
var statearr_109534_109558 = state_109513__$1;
(statearr_109534_109558[(2)] = inst_109490);

(statearr_109534_109558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (16))){
var inst_109499 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_109500 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109499)].join('');
var inst_109501 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109502 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_109503 = cljs.core.PersistentHashMap.fromArrays(inst_109501,inst_109502);
var inst_109504 = cljs.core.ex_info.call(null,inst_109500,inst_109503);
var inst_109505 = (function(){throw inst_109504})();
var state_109513__$1 = state_109513;
var statearr_109535_109559 = state_109513__$1;
(statearr_109535_109559[(2)] = inst_109505);

(statearr_109535_109559[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (10))){
var inst_109477 = (state_109513[(14)]);
var state_109513__$1 = state_109513;
var statearr_109536_109560 = state_109513__$1;
(statearr_109536_109560[(2)] = inst_109477);

(statearr_109536_109560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109514 === (8))){
var inst_109468 = (state_109513[(10)]);
var inst_109476 = (state_109513[(2)]);
var inst_109477 = fluree.db.util.async.throw_err.call(null,inst_109476);
var inst_109478 = (to_t > inst_109468);
var state_109513__$1 = (function (){var statearr_109537 = state_109513;
(statearr_109537[(14)] = inst_109477);

return statearr_109537;
})();
if(cljs.core.truth_(inst_109478)){
var statearr_109538_109561 = state_109513__$1;
(statearr_109538_109561[(1)] = (9));

} else {
var statearr_109539_109562 = state_109513__$1;
(statearr_109539_109562[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0 = (function (){
var statearr_109540 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109540[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__);

(statearr_109540[(1)] = (1));

return statearr_109540;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1 = (function (state_109513){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109541){if((e109541 instanceof Object)){
var ex__99978__auto__ = e109541;
var statearr_109542_109563 = state_109513;
(statearr_109542_109563[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109541;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109564 = state_109513;
state_109513 = G__109564;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__ = function(state_109513){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1.call(this,state_109513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109543 = f__100070__auto__.call(null);
(statearr_109543[(6)] = c__100069__auto__);

return statearr_109543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109582){
var state_val_109583 = (state_109582[(1)]);
if((state_val_109583 === (1))){
var state_109582__$1 = state_109582;
var statearr_109584_109597 = state_109582__$1;
(statearr_109584_109597[(2)] = null);

(statearr_109584_109597[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109583 === (2))){
var inst_109580 = (state_109582[(2)]);
var state_109582__$1 = state_109582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109582__$1,inst_109580);
} else {
if((state_val_109583 === (3))){
var inst_109565 = (state_109582[(2)]);
var state_109582__$1 = state_109582;
var statearr_109585_109598 = state_109582__$1;
(statearr_109585_109598[(2)] = inst_109565);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109582__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109583 === (4))){
var inst_109569 = (state_109582[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109582,(3),Error,null,(2));
var inst_109569__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_109582__$1 = (function (){var statearr_109586 = state_109582;
(statearr_109586[(7)] = inst_109569__$1);

return statearr_109586;
})();
if(cljs.core.truth_(inst_109569__$1)){
var statearr_109587_109599 = state_109582__$1;
(statearr_109587_109599[(1)] = (5));

} else {
var statearr_109588_109600 = state_109582__$1;
(statearr_109588_109600[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109583 === (5))){
var inst_109569 = (state_109582[(7)]);
var inst_109571 = fluree.db.storage.core.serde.call(null,conn);
var state_109582__$1 = (function (){var statearr_109589 = state_109582;
(statearr_109589[(8)] = inst_109571);

return statearr_109589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109582__$1,(8),inst_109569);
} else {
if((state_val_109583 === (6))){
var state_109582__$1 = state_109582;
var statearr_109590_109601 = state_109582__$1;
(statearr_109590_109601[(2)] = null);

(statearr_109590_109601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109583 === (7))){
var inst_109578 = (state_109582[(2)]);
var state_109582__$1 = state_109582;
var statearr_109591_109602 = state_109582__$1;
(statearr_109591_109602[(2)] = inst_109578);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109582__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109583 === (8))){
var inst_109571 = (state_109582[(8)]);
var inst_109573 = (state_109582[(2)]);
var inst_109574 = fluree.db.util.async.throw_err.call(null,inst_109573);
var inst_109575 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_109571,inst_109574);
var state_109582__$1 = state_109582;
var statearr_109592_109603 = state_109582__$1;
(statearr_109592_109603[(2)] = inst_109575);

(statearr_109592_109603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0 = (function (){
var statearr_109593 = [null,null,null,null,null,null,null,null,null];
(statearr_109593[(0)] = fluree$db$storage$core$read_branch_$_state_machine__99975__auto__);

(statearr_109593[(1)] = (1));

return statearr_109593;
});
var fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1 = (function (state_109582){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109594){if((e109594 instanceof Object)){
var ex__99978__auto__ = e109594;
var statearr_109595_109604 = state_109582;
(statearr_109595_109604[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109582);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109605 = state_109582;
state_109582 = G__109605;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__ = function(state_109582){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1.call(this,state_109582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109596 = f__100070__auto__.call(null);
(statearr_109596[(6)] = c__100069__auto__);

return statearr_109596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___109740 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109692){
var state_val_109693 = (state_109692[(1)]);
if((state_val_109693 === (7))){
var state_109692__$1 = state_109692;
var statearr_109694_109741 = state_109692__$1;
(statearr_109694_109741[(2)] = null);

(statearr_109694_109741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (20))){
var inst_109656 = (state_109692[(7)]);
var inst_109656__$1 = (state_109692[(2)]);
var inst_109657 = cljs.core.get.call(null,inst_109656__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_109658 = cljs.core.get.call(null,inst_109656__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_109660 = (config == null);
var inst_109661 = cljs.core.not.call(null,inst_109660);
var state_109692__$1 = (function (){var statearr_109695 = state_109692;
(statearr_109695[(8)] = inst_109657);

(statearr_109695[(7)] = inst_109656__$1);

(statearr_109695[(9)] = inst_109658);

return statearr_109695;
})();
if(inst_109661){
var statearr_109696_109742 = state_109692__$1;
(statearr_109696_109742[(1)] = (21));

} else {
var statearr_109697_109743 = state_109692__$1;
(statearr_109697_109743[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (27))){
var inst_109676 = cljs.core.apply.call(null,cljs.core.hash_map,config);
var state_109692__$1 = state_109692;
var statearr_109698_109744 = state_109692__$1;
(statearr_109698_109744[(2)] = inst_109676);

(statearr_109698_109744[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (1))){
var state_109692__$1 = state_109692;
var statearr_109699_109745 = state_109692__$1;
(statearr_109699_109745[(2)] = null);

(statearr_109699_109745[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (24))){
var state_109692__$1 = state_109692;
var statearr_109700_109746 = state_109692__$1;
(statearr_109700_109746[(2)] = true);

(statearr_109700_109746[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109692,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_109615 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_109692__$1 = state_109692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109692__$1,(5),inst_109615);
} else {
if((state_val_109693 === (15))){
var state_109692__$1 = state_109692;
var statearr_109701_109747 = state_109692__$1;
(statearr_109701_109747[(2)] = true);

(statearr_109701_109747[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (21))){
var inst_109663 = config.cljs$lang$protocol_mask$partition0$;
var inst_109664 = (inst_109663 & (64));
var inst_109665 = config.cljs$core$ISeq$;
var inst_109666 = (cljs.core.PROTOCOL_SENTINEL === inst_109665);
var inst_109667 = ((inst_109664) || (inst_109666));
var state_109692__$1 = state_109692;
if(cljs.core.truth_(inst_109667)){
var statearr_109702_109748 = state_109692__$1;
(statearr_109702_109748[(1)] = (24));

} else {
var statearr_109703_109749 = state_109692__$1;
(statearr_109703_109749[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (13))){
var state_109692__$1 = state_109692;
var statearr_109704_109750 = state_109692__$1;
(statearr_109704_109750[(2)] = false);

(statearr_109704_109750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (22))){
var state_109692__$1 = state_109692;
var statearr_109705_109751 = state_109692__$1;
(statearr_109705_109751[(2)] = false);

(statearr_109705_109751[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (29))){
var inst_109635 = (state_109692[(10)]);
var inst_109657 = (state_109692[(8)]);
var inst_109618 = (state_109692[(11)]);
var inst_109656 = (state_109692[(7)]);
var inst_109658 = (state_109692[(9)]);
var inst_109679 = (state_109692[(2)]);
var inst_109680 = cljs.core.get.call(null,inst_109679,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_109682 = (function (){var data = inst_109618;
var _ = inst_109635;
var map__109613 = inst_109656;
var children = inst_109657;
var rhs = inst_109658;
var map__109614 = inst_109679;
var comparator = inst_109680;
return (function (idx,p__109681){
var map__109706 = p__109681;
var map__109706__$1 = (((((!((map__109706 == null))))?(((((map__109706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109706.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109706):map__109706);
var child = map__109706__$1;
var id = cljs.core.get.call(null,map__109706__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__109706__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__109706__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__109706__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__109706__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_109683 = cljs.core.map_indexed.call(null,inst_109682,inst_109657);
var inst_109684 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_109683);
var inst_109685 = cljs.core.interleave.call(null,inst_109684,inst_109683);
var inst_109686 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_109680,inst_109685);
var inst_109687 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_109658,inst_109686,config,leftmost_QMARK_);
var inst_109688 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109687);
var state_109692__$1 = state_109692;
var statearr_109708_109752 = state_109692__$1;
(statearr_109708_109752[(2)] = inst_109688);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109692__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (6))){
var inst_109621 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_109622 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109623 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_109624 = cljs.core.PersistentHashMap.fromArrays(inst_109622,inst_109623);
var inst_109625 = cljs.core.ex_info.call(null,inst_109621,inst_109624);
var inst_109626 = (function(){throw inst_109625})();
var state_109692__$1 = state_109692;
var statearr_109709_109753 = state_109692__$1;
(statearr_109709_109753[(2)] = inst_109626);

(statearr_109709_109753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (28))){
var state_109692__$1 = state_109692;
var statearr_109710_109754 = state_109692__$1;
(statearr_109710_109754[(2)] = config);

(statearr_109710_109754[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (25))){
var state_109692__$1 = state_109692;
var statearr_109711_109755 = state_109692__$1;
(statearr_109711_109755[(2)] = false);

(statearr_109711_109755[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (17))){
var inst_109648 = (state_109692[(2)]);
var state_109692__$1 = state_109692;
var statearr_109712_109756 = state_109692__$1;
(statearr_109712_109756[(2)] = inst_109648);

(statearr_109712_109756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (3))){
var inst_109606 = (state_109692[(2)]);
var inst_109607 = error_fn.call(null);
var inst_109608 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109606);
var inst_109609 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_109692__$1 = (function (){var statearr_109713 = state_109692;
(statearr_109713[(12)] = inst_109608);

(statearr_109713[(13)] = inst_109607);

return statearr_109713;
})();
var statearr_109714_109757 = state_109692__$1;
(statearr_109714_109757[(2)] = inst_109609);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109692__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (12))){
var inst_109618 = (state_109692[(11)]);
var inst_109640 = inst_109618.cljs$lang$protocol_mask$partition0$;
var inst_109641 = (inst_109640 & (64));
var inst_109642 = inst_109618.cljs$core$ISeq$;
var inst_109643 = (cljs.core.PROTOCOL_SENTINEL === inst_109642);
var inst_109644 = ((inst_109641) || (inst_109643));
var state_109692__$1 = state_109692;
if(cljs.core.truth_(inst_109644)){
var statearr_109715_109758 = state_109692__$1;
(statearr_109715_109758[(1)] = (15));

} else {
var statearr_109716_109759 = state_109692__$1;
(statearr_109716_109759[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (2))){
var inst_109690 = (state_109692[(2)]);
var state_109692__$1 = state_109692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109692__$1,inst_109690);
} else {
if((state_val_109693 === (23))){
var inst_109674 = (state_109692[(2)]);
var state_109692__$1 = state_109692;
if(cljs.core.truth_(inst_109674)){
var statearr_109717_109760 = state_109692__$1;
(statearr_109717_109760[(1)] = (27));

} else {
var statearr_109718_109761 = state_109692__$1;
(statearr_109718_109761[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (19))){
var inst_109618 = (state_109692[(11)]);
var state_109692__$1 = state_109692;
var statearr_109719_109762 = state_109692__$1;
(statearr_109719_109762[(2)] = inst_109618);

(statearr_109719_109762[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (11))){
var inst_109618 = (state_109692[(11)]);
var inst_109635 = (state_109692[(2)]);
var inst_109637 = (inst_109618 == null);
var inst_109638 = cljs.core.not.call(null,inst_109637);
var state_109692__$1 = (function (){var statearr_109720 = state_109692;
(statearr_109720[(10)] = inst_109635);

return statearr_109720;
})();
if(inst_109638){
var statearr_109721_109763 = state_109692__$1;
(statearr_109721_109763[(1)] = (12));

} else {
var statearr_109722_109764 = state_109692__$1;
(statearr_109722_109764[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (9))){
var inst_109618 = (state_109692[(11)]);
var inst_109632 = (function(){throw inst_109618})();
var state_109692__$1 = state_109692;
var statearr_109723_109765 = state_109692__$1;
(statearr_109723_109765[(2)] = inst_109632);

(statearr_109723_109765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (5))){
var inst_109618 = (state_109692[(11)]);
var inst_109617 = (state_109692[(2)]);
var inst_109618__$1 = fluree.db.util.async.throw_err.call(null,inst_109617);
var inst_109619 = (inst_109618__$1 == null);
var state_109692__$1 = (function (){var statearr_109724 = state_109692;
(statearr_109724[(11)] = inst_109618__$1);

return statearr_109724;
})();
if(cljs.core.truth_(inst_109619)){
var statearr_109725_109766 = state_109692__$1;
(statearr_109725_109766[(1)] = (6));

} else {
var statearr_109726_109767 = state_109692__$1;
(statearr_109726_109767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (14))){
var inst_109651 = (state_109692[(2)]);
var state_109692__$1 = state_109692;
if(cljs.core.truth_(inst_109651)){
var statearr_109727_109768 = state_109692__$1;
(statearr_109727_109768[(1)] = (18));

} else {
var statearr_109728_109769 = state_109692__$1;
(statearr_109728_109769[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (26))){
var inst_109671 = (state_109692[(2)]);
var state_109692__$1 = state_109692;
var statearr_109729_109770 = state_109692__$1;
(statearr_109729_109770[(2)] = inst_109671);

(statearr_109729_109770[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (16))){
var state_109692__$1 = state_109692;
var statearr_109730_109771 = state_109692__$1;
(statearr_109730_109771[(2)] = false);

(statearr_109730_109771[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (10))){
var state_109692__$1 = state_109692;
var statearr_109731_109772 = state_109692__$1;
(statearr_109731_109772[(2)] = null);

(statearr_109731_109772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (18))){
var inst_109618 = (state_109692[(11)]);
var inst_109653 = cljs.core.apply.call(null,cljs.core.hash_map,inst_109618);
var state_109692__$1 = state_109692;
var statearr_109732_109773 = state_109692__$1;
(statearr_109732_109773[(2)] = inst_109653);

(statearr_109732_109773[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109693 === (8))){
var inst_109618 = (state_109692[(11)]);
var inst_109629 = (state_109692[(2)]);
var inst_109630 = fluree.db.util.core.exception_QMARK_.call(null,inst_109618);
var state_109692__$1 = (function (){var statearr_109733 = state_109692;
(statearr_109733[(14)] = inst_109629);

return statearr_109733;
})();
if(inst_109630){
var statearr_109734_109774 = state_109692__$1;
(statearr_109734_109774[(1)] = (9));

} else {
var statearr_109735_109775 = state_109692__$1;
(statearr_109735_109775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0 = (function (){
var statearr_109736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109736[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__);

(statearr_109736[(1)] = (1));

return statearr_109736;
});
var fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1 = (function (state_109692){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109737){if((e109737 instanceof Object)){
var ex__99978__auto__ = e109737;
var statearr_109738_109776 = state_109692;
(statearr_109738_109776[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109777 = state_109692;
state_109692 = G__109777;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__ = function(state_109692){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1.call(this,state_109692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109739 = f__100070__auto__.call(null);
(statearr_109739[(6)] = c__100069__auto___109740);

return statearr_109739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109795){
var state_val_109796 = (state_109795[(1)]);
if((state_val_109796 === (1))){
var state_109795__$1 = state_109795;
var statearr_109797_109810 = state_109795__$1;
(statearr_109797_109810[(2)] = null);

(statearr_109797_109810[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109796 === (2))){
var inst_109793 = (state_109795[(2)]);
var state_109795__$1 = state_109795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109795__$1,inst_109793);
} else {
if((state_val_109796 === (3))){
var inst_109778 = (state_109795[(2)]);
var state_109795__$1 = state_109795;
var statearr_109798_109811 = state_109795__$1;
(statearr_109798_109811[(2)] = inst_109778);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109795__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109796 === (4))){
var inst_109782 = (state_109795[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109795,(3),Error,null,(2));
var inst_109782__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_109795__$1 = (function (){var statearr_109799 = state_109795;
(statearr_109799[(7)] = inst_109782__$1);

return statearr_109799;
})();
if(cljs.core.truth_(inst_109782__$1)){
var statearr_109800_109812 = state_109795__$1;
(statearr_109800_109812[(1)] = (5));

} else {
var statearr_109801_109813 = state_109795__$1;
(statearr_109801_109813[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109796 === (5))){
var inst_109782 = (state_109795[(7)]);
var inst_109784 = fluree.db.storage.core.serde.call(null,conn);
var state_109795__$1 = (function (){var statearr_109802 = state_109795;
(statearr_109802[(8)] = inst_109784);

return statearr_109802;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109795__$1,(8),inst_109782);
} else {
if((state_val_109796 === (6))){
var state_109795__$1 = state_109795;
var statearr_109803_109814 = state_109795__$1;
(statearr_109803_109814[(2)] = null);

(statearr_109803_109814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109796 === (7))){
var inst_109791 = (state_109795[(2)]);
var state_109795__$1 = state_109795;
var statearr_109804_109815 = state_109795__$1;
(statearr_109804_109815[(2)] = inst_109791);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109795__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109796 === (8))){
var inst_109784 = (state_109795[(8)]);
var inst_109786 = (state_109795[(2)]);
var inst_109787 = fluree.db.util.async.throw_err.call(null,inst_109786);
var inst_109788 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_109784,inst_109787);
var state_109795__$1 = state_109795;
var statearr_109805_109816 = state_109795__$1;
(statearr_109805_109816[(2)] = inst_109788);

(statearr_109805_109816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_109806 = [null,null,null,null,null,null,null,null,null];
(statearr_109806[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__);

(statearr_109806[(1)] = (1));

return statearr_109806;
});
var fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1 = (function (state_109795){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109807){if((e109807 instanceof Object)){
var ex__99978__auto__ = e109807;
var statearr_109808_109817 = state_109795;
(statearr_109808_109817[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109818 = state_109795;
state_109795 = G__109818;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__ = function(state_109795){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1.call(this,state_109795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109809 = f__100070__auto__.call(null);
(statearr_109809[(6)] = c__100069__auto__);

return statearr_109809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___109945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_109899){
var state_val_109900 = (state_109899[(1)]);
if((state_val_109900 === (7))){
var state_109899__$1 = state_109899;
var statearr_109901_109946 = state_109899__$1;
(statearr_109901_109946[(2)] = null);

(statearr_109901_109946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (20))){
var inst_109868 = (state_109899[(2)]);
var inst_109869 = cljs.core.get.call(null,inst_109868,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_109870 = cljs.core.get.call(null,inst_109868,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_109872 = (config == null);
var inst_109873 = cljs.core.not.call(null,inst_109872);
var state_109899__$1 = (function (){var statearr_109902 = state_109899;
(statearr_109902[(7)] = inst_109870);

(statearr_109902[(8)] = inst_109869);

return statearr_109902;
})();
if(inst_109873){
var statearr_109903_109947 = state_109899__$1;
(statearr_109903_109947[(1)] = (21));

} else {
var statearr_109904_109948 = state_109899__$1;
(statearr_109904_109948[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (27))){
var inst_109888 = cljs.core.apply.call(null,cljs.core.hash_map,config);
var state_109899__$1 = state_109899;
var statearr_109905_109949 = state_109899__$1;
(statearr_109905_109949[(2)] = inst_109888);

(statearr_109905_109949[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (1))){
var state_109899__$1 = state_109899;
var statearr_109906_109950 = state_109899__$1;
(statearr_109906_109950[(2)] = null);

(statearr_109906_109950[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (24))){
var state_109899__$1 = state_109899;
var statearr_109907_109951 = state_109899__$1;
(statearr_109907_109951[(2)] = true);

(statearr_109907_109951[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_109899,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_109828 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_109899__$1 = state_109899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_109899__$1,(5),inst_109828);
} else {
if((state_val_109900 === (15))){
var state_109899__$1 = state_109899;
var statearr_109908_109952 = state_109899__$1;
(statearr_109908_109952[(2)] = true);

(statearr_109908_109952[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (21))){
var inst_109875 = config.cljs$lang$protocol_mask$partition0$;
var inst_109876 = (inst_109875 & (64));
var inst_109877 = config.cljs$core$ISeq$;
var inst_109878 = (cljs.core.PROTOCOL_SENTINEL === inst_109877);
var inst_109879 = ((inst_109876) || (inst_109878));
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109879)){
var statearr_109909_109953 = state_109899__$1;
(statearr_109909_109953[(1)] = (24));

} else {
var statearr_109910_109954 = state_109899__$1;
(statearr_109910_109954[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (13))){
var state_109899__$1 = state_109899;
var statearr_109911_109955 = state_109899__$1;
(statearr_109911_109955[(2)] = false);

(statearr_109911_109955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (22))){
var state_109899__$1 = state_109899;
var statearr_109912_109956 = state_109899__$1;
(statearr_109912_109956[(2)] = false);

(statearr_109912_109956[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (29))){
var inst_109869 = (state_109899[(8)]);
var inst_109891 = (state_109899[(2)]);
var inst_109892 = cljs.core.get.call(null,inst_109891,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_109893 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_109892,inst_109869);
var inst_109894 = fluree.db.index.data_node.call(null,block,t,inst_109893,rhs,config);
var inst_109895 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109894);
var state_109899__$1 = state_109899;
var statearr_109913_109957 = state_109899__$1;
(statearr_109913_109957[(2)] = inst_109895);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109899__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (6))){
var inst_109833 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_109834 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_109835 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_109836 = cljs.core.PersistentHashMap.fromArrays(inst_109834,inst_109835);
var inst_109837 = cljs.core.ex_info.call(null,inst_109833,inst_109836);
var inst_109838 = (function(){throw inst_109837})();
var state_109899__$1 = state_109899;
var statearr_109914_109958 = state_109899__$1;
(statearr_109914_109958[(2)] = inst_109838);

(statearr_109914_109958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (28))){
var state_109899__$1 = state_109899;
var statearr_109915_109959 = state_109899__$1;
(statearr_109915_109959[(2)] = config);

(statearr_109915_109959[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (25))){
var state_109899__$1 = state_109899;
var statearr_109916_109960 = state_109899__$1;
(statearr_109916_109960[(2)] = false);

(statearr_109916_109960[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (17))){
var inst_109860 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
var statearr_109917_109961 = state_109899__$1;
(statearr_109917_109961[(2)] = inst_109860);

(statearr_109917_109961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (3))){
var inst_109819 = (state_109899[(2)]);
var inst_109820 = error_fn.call(null);
var inst_109821 = cljs.core.async.put_BANG_.call(null,return_ch,inst_109819);
var inst_109822 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_109899__$1 = (function (){var statearr_109918 = state_109899;
(statearr_109918[(9)] = inst_109820);

(statearr_109918[(10)] = inst_109821);

return statearr_109918;
})();
var statearr_109919_109962 = state_109899__$1;
(statearr_109919_109962[(2)] = inst_109822);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109899__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (12))){
var inst_109830 = (state_109899[(11)]);
var inst_109852 = inst_109830.cljs$lang$protocol_mask$partition0$;
var inst_109853 = (inst_109852 & (64));
var inst_109854 = inst_109830.cljs$core$ISeq$;
var inst_109855 = (cljs.core.PROTOCOL_SENTINEL === inst_109854);
var inst_109856 = ((inst_109853) || (inst_109855));
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109856)){
var statearr_109920_109963 = state_109899__$1;
(statearr_109920_109963[(1)] = (15));

} else {
var statearr_109921_109964 = state_109899__$1;
(statearr_109921_109964[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (2))){
var inst_109897 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_109899__$1,inst_109897);
} else {
if((state_val_109900 === (23))){
var inst_109886 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109886)){
var statearr_109922_109965 = state_109899__$1;
(statearr_109922_109965[(1)] = (27));

} else {
var statearr_109923_109966 = state_109899__$1;
(statearr_109923_109966[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (19))){
var inst_109830 = (state_109899[(11)]);
var state_109899__$1 = state_109899;
var statearr_109924_109967 = state_109899__$1;
(statearr_109924_109967[(2)] = inst_109830);

(statearr_109924_109967[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (11))){
var inst_109830 = (state_109899[(11)]);
var inst_109847 = (state_109899[(2)]);
var inst_109849 = (inst_109830 == null);
var inst_109850 = cljs.core.not.call(null,inst_109849);
var state_109899__$1 = (function (){var statearr_109925 = state_109899;
(statearr_109925[(12)] = inst_109847);

return statearr_109925;
})();
if(inst_109850){
var statearr_109926_109968 = state_109899__$1;
(statearr_109926_109968[(1)] = (12));

} else {
var statearr_109927_109969 = state_109899__$1;
(statearr_109927_109969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (9))){
var inst_109830 = (state_109899[(11)]);
var inst_109844 = (function(){throw inst_109830})();
var state_109899__$1 = state_109899;
var statearr_109928_109970 = state_109899__$1;
(statearr_109928_109970[(2)] = inst_109844);

(statearr_109928_109970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (5))){
var inst_109830 = (state_109899[(11)]);
var inst_109830__$1 = (state_109899[(2)]);
var inst_109831 = (inst_109830__$1 == null);
var state_109899__$1 = (function (){var statearr_109929 = state_109899;
(statearr_109929[(11)] = inst_109830__$1);

return statearr_109929;
})();
if(cljs.core.truth_(inst_109831)){
var statearr_109930_109971 = state_109899__$1;
(statearr_109930_109971[(1)] = (6));

} else {
var statearr_109931_109972 = state_109899__$1;
(statearr_109931_109972[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (14))){
var inst_109863 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
if(cljs.core.truth_(inst_109863)){
var statearr_109932_109973 = state_109899__$1;
(statearr_109932_109973[(1)] = (18));

} else {
var statearr_109933_109974 = state_109899__$1;
(statearr_109933_109974[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (26))){
var inst_109883 = (state_109899[(2)]);
var state_109899__$1 = state_109899;
var statearr_109934_109975 = state_109899__$1;
(statearr_109934_109975[(2)] = inst_109883);

(statearr_109934_109975[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (16))){
var state_109899__$1 = state_109899;
var statearr_109935_109976 = state_109899__$1;
(statearr_109935_109976[(2)] = false);

(statearr_109935_109976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (10))){
var state_109899__$1 = state_109899;
var statearr_109936_109977 = state_109899__$1;
(statearr_109936_109977[(2)] = null);

(statearr_109936_109977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (18))){
var inst_109830 = (state_109899[(11)]);
var inst_109865 = cljs.core.apply.call(null,cljs.core.hash_map,inst_109830);
var state_109899__$1 = state_109899;
var statearr_109937_109978 = state_109899__$1;
(statearr_109937_109978[(2)] = inst_109865);

(statearr_109937_109978[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_109900 === (8))){
var inst_109830 = (state_109899[(11)]);
var inst_109841 = (state_109899[(2)]);
var inst_109842 = fluree.db.util.core.exception_QMARK_.call(null,inst_109830);
var state_109899__$1 = (function (){var statearr_109938 = state_109899;
(statearr_109938[(13)] = inst_109841);

return statearr_109938;
})();
if(inst_109842){
var statearr_109939_109979 = state_109899__$1;
(statearr_109939_109979[(1)] = (9));

} else {
var statearr_109940_109980 = state_109899__$1;
(statearr_109940_109980[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0 = (function (){
var statearr_109941 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109941[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__);

(statearr_109941[(1)] = (1));

return statearr_109941;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1 = (function (state_109899){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_109899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e109942){if((e109942 instanceof Object)){
var ex__99978__auto__ = e109942;
var statearr_109943_109981 = state_109899;
(statearr_109943_109981[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_109899);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e109942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__109982 = state_109899;
state_109899 = G__109982;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__ = function(state_109899){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1.call(this,state_109899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_109944 = f__100070__auto__.call(null);
(statearr_109944[(6)] = c__100069__auto___109945);

return statearr_109944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k109984,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__109988 = k109984;
var G__109988__$1 = (((G__109988 instanceof cljs.core.Keyword))?G__109988.fqn:null);
switch (G__109988__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k109984,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__109989){
var vec__109990 = p__109989;
var k__4403__auto__ = cljs.core.nth.call(null,vec__109990,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__109990,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__109983){
var self__ = this;
var G__109983__$1 = this;
return (new cljs.core.RecordIter((0),G__109983__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this109985,other109986){
var self__ = this;
var this109985__$1 = this;
return (((!((other109986 == null)))) && ((this109985__$1.constructor === other109986.constructor)) && (cljs.core._EQ_.call(null,this109985__$1.conn,other109986.conn)) && (cljs.core._EQ_.call(null,this109985__$1.config,other109986.config)) && (cljs.core._EQ_.call(null,this109985__$1.network,other109986.network)) && (cljs.core._EQ_.call(null,this109985__$1.dbid,other109986.dbid)) && (cljs.core._EQ_.call(null,this109985__$1.id,other109986.id)) && (cljs.core._EQ_.call(null,this109985__$1.leaf,other109986.leaf)) && (cljs.core._EQ_.call(null,this109985__$1.first,other109986.first)) && (cljs.core._EQ_.call(null,this109985__$1.rhs,other109986.rhs)) && (cljs.core._EQ_.call(null,this109985__$1.size,other109986.size)) && (cljs.core._EQ_.call(null,this109985__$1.block,other109986.block)) && (cljs.core._EQ_.call(null,this109985__$1.t,other109986.t)) && (cljs.core._EQ_.call(null,this109985__$1.tt_id,other109986.tt_id)) && (cljs.core._EQ_.call(null,this109985__$1.leftmost_QMARK_,other109986.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this109985__$1.tempid,other109986.tempid)) && (cljs.core._EQ_.call(null,this109985__$1.__extmap,other109986.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__109983){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__109993 = cljs.core.keyword_identical_QMARK_;
var expr__109994 = k__4388__auto__;
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(G__109983,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__109983,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__109983,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__109983,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__109983,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__109983,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__109983,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__109983,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__109983,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__109983,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__109983,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__109983,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__109983,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__109993.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__109994))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__109983,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__109983),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__109983){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__109983,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__109987){
var extmap__4419__auto__ = (function (){var G__109996 = cljs.core.dissoc.call(null,G__109987,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__109987)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__109996);
} else {
return G__109996;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__109987),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__109987),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__109998 = blank_db;
var map__109998__$1 = (((((!((map__109998 == null))))?(((((map__109998.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109998.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109998):map__109998);
var network = cljs.core.get.call(null,map__109998__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__109998__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__109998__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__109999 = root_data;
var map__109999__$1 = (((((!((map__109999 == null))))?(((((map__109999.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109999.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__109999):map__109999);
var block = cljs.core.get.call(null,map__109999__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__109999__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__109999__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__109999__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110020){
var state_val_110021 = (state_110020[(1)]);
if((state_val_110021 === (1))){
var state_110020__$1 = state_110020;
var statearr_110022_110035 = state_110020__$1;
(statearr_110022_110035[(2)] = null);

(statearr_110022_110035[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110021 === (2))){
var inst_110018 = (state_110020[(2)]);
var state_110020__$1 = state_110020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110020__$1,inst_110018);
} else {
if((state_val_110021 === (3))){
var inst_110002 = (state_110020[(2)]);
var state_110020__$1 = state_110020;
var statearr_110023_110036 = state_110020__$1;
(statearr_110023_110036[(2)] = inst_110002);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110020__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110021 === (4))){
var inst_110007 = (state_110020[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110020,(3),Error,null,(2));
var inst_110006 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_110007__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_110006);
var state_110020__$1 = (function (){var statearr_110024 = state_110020;
(statearr_110024[(7)] = inst_110007__$1);

return statearr_110024;
})();
if(cljs.core.truth_(inst_110007__$1)){
var statearr_110025_110037 = state_110020__$1;
(statearr_110025_110037[(1)] = (5));

} else {
var statearr_110026_110038 = state_110020__$1;
(statearr_110026_110038[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110021 === (5))){
var inst_110007 = (state_110020[(7)]);
var inst_110009 = fluree.db.storage.core.serde.call(null,conn);
var state_110020__$1 = (function (){var statearr_110027 = state_110020;
(statearr_110027[(8)] = inst_110009);

return statearr_110027;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110020__$1,(8),inst_110007);
} else {
if((state_val_110021 === (6))){
var state_110020__$1 = state_110020;
var statearr_110028_110039 = state_110020__$1;
(statearr_110028_110039[(2)] = null);

(statearr_110028_110039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110021 === (7))){
var inst_110016 = (state_110020[(2)]);
var state_110020__$1 = state_110020;
var statearr_110029_110040 = state_110020__$1;
(statearr_110029_110040[(2)] = inst_110016);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110020__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110021 === (8))){
var inst_110009 = (state_110020[(8)]);
var inst_110011 = (state_110020[(2)]);
var inst_110012 = fluree.db.util.async.throw_err.call(null,inst_110011);
var inst_110013 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_110009,inst_110012);
var state_110020__$1 = state_110020;
var statearr_110030_110041 = state_110020__$1;
(statearr_110030_110041[(2)] = inst_110013);

(statearr_110030_110041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0 = (function (){
var statearr_110031 = [null,null,null,null,null,null,null,null,null];
(statearr_110031[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__);

(statearr_110031[(1)] = (1));

return statearr_110031;
});
var fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1 = (function (state_110020){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110032){if((e110032 instanceof Object)){
var ex__99978__auto__ = e110032;
var statearr_110033_110042 = state_110020;
(statearr_110033_110042[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110043 = state_110020;
state_110020 = G__110043;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__ = function(state_110020){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1.call(this,state_110020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110034 = f__100070__auto__.call(null);
(statearr_110034[(6)] = c__100069__auto__);

return statearr_110034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110062){
var state_val_110063 = (state_110062[(1)]);
if((state_val_110063 === (1))){
var state_110062__$1 = state_110062;
var statearr_110064_110077 = state_110062__$1;
(statearr_110064_110077[(2)] = null);

(statearr_110064_110077[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110063 === (2))){
var inst_110060 = (state_110062[(2)]);
var state_110062__$1 = state_110062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110062__$1,inst_110060);
} else {
if((state_val_110063 === (3))){
var inst_110044 = (state_110062[(2)]);
var state_110062__$1 = state_110062;
var statearr_110065_110078 = state_110062__$1;
(statearr_110065_110078[(2)] = inst_110044);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110062__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110063 === (4))){
var inst_110049 = (state_110062[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110062,(3),Error,null,(2));
var inst_110048 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_110049__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_110048);
var state_110062__$1 = (function (){var statearr_110066 = state_110062;
(statearr_110066[(7)] = inst_110049__$1);

return statearr_110066;
})();
if(cljs.core.truth_(inst_110049__$1)){
var statearr_110067_110079 = state_110062__$1;
(statearr_110067_110079[(1)] = (5));

} else {
var statearr_110068_110080 = state_110062__$1;
(statearr_110068_110080[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110063 === (5))){
var inst_110049 = (state_110062[(7)]);
var inst_110051 = fluree.db.storage.core.serde.call(null,conn);
var state_110062__$1 = (function (){var statearr_110069 = state_110062;
(statearr_110069[(8)] = inst_110051);

return statearr_110069;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110062__$1,(8),inst_110049);
} else {
if((state_val_110063 === (6))){
var state_110062__$1 = state_110062;
var statearr_110070_110081 = state_110062__$1;
(statearr_110070_110081[(2)] = null);

(statearr_110070_110081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110063 === (7))){
var inst_110058 = (state_110062[(2)]);
var state_110062__$1 = state_110062;
var statearr_110071_110082 = state_110062__$1;
(statearr_110071_110082[(2)] = inst_110058);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110062__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110063 === (8))){
var inst_110051 = (state_110062[(8)]);
var inst_110053 = (state_110062[(2)]);
var inst_110054 = fluree.db.util.async.throw_err.call(null,inst_110053);
var inst_110055 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_110051,inst_110054);
var state_110062__$1 = state_110062;
var statearr_110072_110083 = state_110062__$1;
(statearr_110072_110083[(2)] = inst_110055);

(statearr_110072_110083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0 = (function (){
var statearr_110073 = [null,null,null,null,null,null,null,null,null];
(statearr_110073[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__);

(statearr_110073[(1)] = (1));

return statearr_110073;
});
var fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1 = (function (state_110062){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110074){if((e110074 instanceof Object)){
var ex__99978__auto__ = e110074;
var statearr_110075_110084 = state_110062;
(statearr_110075_110084[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110074;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110085 = state_110062;
state_110062 = G__110085;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__ = function(state_110062){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1.call(this,state_110062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__99975__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110076 = f__100070__auto__.call(null);
(statearr_110076[(6)] = c__100069__auto__);

return statearr_110076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110118){
var state_val_110119 = (state_110118[(1)]);
if((state_val_110119 === (7))){
var inst_110090 = (state_110118[(7)]);
var inst_110100 = (state_110118[(2)]);
var state_110118__$1 = (function (){var statearr_110120 = state_110118;
(statearr_110120[(8)] = inst_110100);

return statearr_110120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110118__$1,(8),inst_110090);
} else {
if((state_val_110119 === (1))){
var state_110118__$1 = state_110118;
var statearr_110121_110135 = state_110118__$1;
(statearr_110121_110135[(2)] = null);

(statearr_110121_110135[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (4))){
var inst_110090 = (state_110118[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110118,(3),Error,null,(2));
var inst_110090__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_110118__$1 = (function (){var statearr_110122 = state_110118;
(statearr_110122[(7)] = inst_110090__$1);

return statearr_110122;
})();
if(cljs.core.truth_(inst_110090__$1)){
var statearr_110123_110136 = state_110118__$1;
(statearr_110123_110136[(1)] = (5));

} else {
var statearr_110124_110137 = state_110118__$1;
(statearr_110124_110137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (6))){
var inst_110093 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_110094 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_110095 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_110096 = cljs.core.PersistentHashMap.fromArrays(inst_110094,inst_110095);
var inst_110097 = cljs.core.ex_info.call(null,inst_110093,inst_110096);
var inst_110098 = (function(){throw inst_110097})();
var state_110118__$1 = state_110118;
var statearr_110125_110138 = state_110118__$1;
(statearr_110125_110138[(2)] = inst_110098);

(statearr_110125_110138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (3))){
var inst_110086 = (state_110118[(2)]);
var state_110118__$1 = state_110118;
var statearr_110126_110139 = state_110118__$1;
(statearr_110126_110139[(2)] = inst_110086);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110118__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (2))){
var inst_110116 = (state_110118[(2)]);
var state_110118__$1 = state_110118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110118__$1,inst_110116);
} else {
if((state_val_110119 === (9))){
var inst_110104 = (state_110118[(9)]);
var inst_110109 = (state_110118[(10)]);
var inst_110107 = (state_110118[(2)]);
var inst_110108 = fluree.db.util.async.throw_err.call(null,inst_110107);
var inst_110109__$1 = cljs.core.assoc.call(null,inst_110104,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_110108);
var inst_110110 = fluree.db.query.schema.setting_map.call(null,inst_110109__$1);
var state_110118__$1 = (function (){var statearr_110127 = state_110118;
(statearr_110127[(10)] = inst_110109__$1);

return statearr_110127;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110118__$1,(10),inst_110110);
} else {
if((state_val_110119 === (5))){
var state_110118__$1 = state_110118;
var statearr_110128_110140 = state_110118__$1;
(statearr_110128_110140[(2)] = null);

(statearr_110128_110140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (10))){
var inst_110109 = (state_110118[(10)]);
var inst_110112 = (state_110118[(2)]);
var inst_110113 = fluree.db.util.async.throw_err.call(null,inst_110112);
var inst_110114 = cljs.core.assoc.call(null,inst_110109,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_110113);
var state_110118__$1 = state_110118;
var statearr_110129_110141 = state_110118__$1;
(statearr_110129_110141[(2)] = inst_110114);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110118__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110119 === (8))){
var inst_110104 = (state_110118[(9)]);
var inst_110102 = (state_110118[(2)]);
var inst_110103 = fluree.db.util.async.throw_err.call(null,inst_110102);
var inst_110104__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_110103);
var inst_110105 = fluree.db.query.schema.schema_map.call(null,inst_110104__$1);
var state_110118__$1 = (function (){var statearr_110130 = state_110118;
(statearr_110130[(9)] = inst_110104__$1);

return statearr_110130;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110118__$1,(9),inst_110105);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0 = (function (){
var statearr_110131 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_110131[(0)] = fluree$db$storage$core$reify_db_$_state_machine__99975__auto__);

(statearr_110131[(1)] = (1));

return statearr_110131;
});
var fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1 = (function (state_110118){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110132){if((e110132 instanceof Object)){
var ex__99978__auto__ = e110132;
var statearr_110133_110142 = state_110118;
(statearr_110133_110142[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110132;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110143 = state_110118;
state_110118 = G__110143;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__ = function(state_110118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1.call(this,state_110118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__99975__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__99975__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110134 = f__100070__auto__.call(null);
(statearr_110134[(6)] = c__100069__auto__);

return statearr_110134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__110145 = arguments.length;
switch (G__110145) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110191){
var state_val_110192 = (state_110191[(1)]);
if((state_val_110192 === (7))){
var inst_110157 = (state_110191[(2)]);
var inst_110158 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_110159 = cljs.core.PersistentVector.EMPTY;
var inst_110160 = start;
var inst_110161 = inst_110159;
var state_110191__$1 = (function (){var statearr_110193 = state_110191;
(statearr_110193[(7)] = inst_110158);

(statearr_110193[(8)] = inst_110160);

(statearr_110193[(9)] = inst_110157);

(statearr_110193[(10)] = inst_110161);

return statearr_110193;
})();
var statearr_110194_110222 = state_110191__$1;
(statearr_110194_110222[(2)] = null);

(statearr_110194_110222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (1))){
var state_110191__$1 = state_110191;
var statearr_110195_110223 = state_110191__$1;
(statearr_110195_110223[(2)] = null);

(statearr_110195_110223[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110191,(3),Error,null,(2));
var inst_110150 = (end >= start);
var state_110191__$1 = state_110191;
if(cljs.core.truth_(inst_110150)){
var statearr_110196_110224 = state_110191__$1;
(statearr_110196_110224[(1)] = (5));

} else {
var statearr_110197_110225 = state_110191__$1;
(statearr_110197_110225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (15))){
var state_110191__$1 = state_110191;
var statearr_110198_110226 = state_110191__$1;
(statearr_110198_110226[(1)] = (17));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (13))){
var inst_110185 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
var statearr_110200_110227 = state_110191__$1;
(statearr_110200_110227[(2)] = inst_110185);

(statearr_110200_110227[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (6))){
var inst_110153 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_110154 = (new Error(inst_110153));
var inst_110155 = (function(){throw inst_110154})();
var state_110191__$1 = state_110191;
var statearr_110201_110228 = state_110191__$1;
(statearr_110201_110228[(2)] = inst_110155);

(statearr_110201_110228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (17))){
var inst_110160 = (state_110191[(8)]);
var inst_110161 = (state_110191[(10)]);
var inst_110165 = (state_110191[(11)]);
var inst_110176 = (inst_110160 + (1));
var inst_110177 = cljs.core.conj.call(null,inst_110161,inst_110165);
var inst_110160__$1 = inst_110176;
var inst_110161__$1 = inst_110177;
var state_110191__$1 = (function (){var statearr_110202 = state_110191;
(statearr_110202[(8)] = inst_110160__$1);

(statearr_110202[(10)] = inst_110161__$1);

return statearr_110202;
})();
var statearr_110203_110229 = state_110191__$1;
(statearr_110203_110229[(2)] = null);

(statearr_110203_110229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (3))){
var inst_110146 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
var statearr_110204_110230 = state_110191__$1;
(statearr_110204_110230[(2)] = inst_110146);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110191__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (12))){
var inst_110160 = (state_110191[(8)]);
var inst_110171 = cljs.core._EQ_.call(null,inst_110160,end);
var state_110191__$1 = state_110191;
if(inst_110171){
var statearr_110205_110231 = state_110191__$1;
(statearr_110205_110231[(1)] = (14));

} else {
var statearr_110206_110232 = state_110191__$1;
(statearr_110206_110232[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (2))){
var inst_110189 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110191__$1,inst_110189);
} else {
if((state_val_110192 === (19))){
var inst_110181 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
var statearr_110207_110233 = state_110191__$1;
(statearr_110207_110233[(2)] = inst_110181);

(statearr_110207_110233[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (11))){
var inst_110161 = (state_110191[(10)]);
var state_110191__$1 = state_110191;
var statearr_110208_110234 = state_110191__$1;
(statearr_110208_110234[(2)] = inst_110161);

(statearr_110208_110234[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (9))){
var inst_110187 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
var statearr_110209_110235 = state_110191__$1;
(statearr_110209_110235[(2)] = inst_110187);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110191__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (5))){
var state_110191__$1 = state_110191;
var statearr_110210_110236 = state_110191__$1;
(statearr_110210_110236[(2)] = null);

(statearr_110210_110236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (14))){
var inst_110161 = (state_110191[(10)]);
var inst_110165 = (state_110191[(11)]);
var inst_110173 = cljs.core.conj.call(null,inst_110161,inst_110165);
var state_110191__$1 = state_110191;
var statearr_110211_110237 = state_110191__$1;
(statearr_110211_110237[(2)] = inst_110173);

(statearr_110211_110237[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (16))){
var inst_110183 = (state_110191[(2)]);
var state_110191__$1 = state_110191;
var statearr_110212_110238 = state_110191__$1;
(statearr_110212_110238[(2)] = inst_110183);

(statearr_110212_110238[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (10))){
var inst_110165 = (state_110191[(11)]);
var inst_110165__$1 = (state_110191[(2)]);
var inst_110166 = (inst_110165__$1 == null);
var inst_110167 = (inst_110165__$1 instanceof Error);
var inst_110168 = ((inst_110166) || (inst_110167));
var state_110191__$1 = (function (){var statearr_110213 = state_110191;
(statearr_110213[(11)] = inst_110165__$1);

return statearr_110213;
})();
if(cljs.core.truth_(inst_110168)){
var statearr_110214_110239 = state_110191__$1;
(statearr_110214_110239[(1)] = (11));

} else {
var statearr_110215_110240 = state_110191__$1;
(statearr_110215_110240[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (18))){
var state_110191__$1 = state_110191;
var statearr_110216_110241 = state_110191__$1;
(statearr_110216_110241[(2)] = null);

(statearr_110216_110241[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110192 === (8))){
var inst_110160 = (state_110191[(8)]);
var inst_110163 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_110160);
var state_110191__$1 = state_110191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110191__$1,(10),inst_110163);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__99975__auto__ = null;
var fluree$db$storage$core$state_machine__99975__auto____0 = (function (){
var statearr_110217 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110217[(0)] = fluree$db$storage$core$state_machine__99975__auto__);

(statearr_110217[(1)] = (1));

return statearr_110217;
});
var fluree$db$storage$core$state_machine__99975__auto____1 = (function (state_110191){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110218){if((e110218 instanceof Object)){
var ex__99978__auto__ = e110218;
var statearr_110219_110242 = state_110191;
(statearr_110219_110242[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110191);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110218;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110243 = state_110191;
state_110191 = G__110243;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99975__auto__ = function(state_110191){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99975__auto____1.call(this,state_110191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99975__auto____0;
fluree$db$storage$core$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99975__auto____1;
return fluree$db$storage$core$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110220 = f__100070__auto__.call(null);
(statearr_110220[(6)] = c__100069__auto__);

return statearr_110220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110256){
var state_val_110257 = (state_110256[(1)]);
if((state_val_110257 === (1))){
var state_110256__$1 = state_110256;
var statearr_110258_110265 = state_110256__$1;
(statearr_110258_110265[(2)] = null);

(statearr_110258_110265[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110257 === (2))){
var inst_110254 = (state_110256[(2)]);
var state_110256__$1 = state_110256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110256__$1,inst_110254);
} else {
if((state_val_110257 === (3))){
var inst_110244 = (state_110256[(2)]);
var state_110256__$1 = state_110256;
var statearr_110259_110266 = state_110256__$1;
(statearr_110259_110266[(2)] = inst_110244);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110256__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110257 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110256,(3),Error,null,(2));
var inst_110248 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_110256__$1 = state_110256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_110256__$1,(5),inst_110248);
} else {
if((state_val_110257 === (5))){
var inst_110250 = (state_110256[(2)]);
var inst_110251 = fluree.db.util.async.throw_err.call(null,inst_110250);
var inst_110252 = cljs.core.first.call(null,inst_110251);
var state_110256__$1 = state_110256;
var statearr_110260_110267 = state_110256__$1;
(statearr_110260_110267[(2)] = inst_110252);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110256__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__99975__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__99975__auto____0 = (function (){
var statearr_110261 = [null,null,null,null,null,null,null];
(statearr_110261[(0)] = fluree$db$storage$core$block_$_state_machine__99975__auto__);

(statearr_110261[(1)] = (1));

return statearr_110261;
});
var fluree$db$storage$core$block_$_state_machine__99975__auto____1 = (function (state_110256){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110262){if((e110262 instanceof Object)){
var ex__99978__auto__ = e110262;
var statearr_110263_110268 = state_110256;
(statearr_110263_110268[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110256);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110262;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110269 = state_110256;
state_110256 = G__110269;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__99975__auto__ = function(state_110256){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__99975__auto____1.call(this,state_110256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__99975__auto____0;
fluree$db$storage$core$block_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__99975__auto____1;
return fluree$db$storage$core$block_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110264 = f__100070__auto__.call(null);
(statearr_110264[(6)] = c__100069__auto__);

return statearr_110264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
