// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__120911_121074 = cljs.core.seq.call(null,servers);
var chunk__120912_121075 = null;
var count__120913_121076 = (0);
var i__120914_121077 = (0);
while(true){
if((i__120914_121077 < count__120913_121076)){
var server_121078 = cljs.core._nth.call(null,chunk__120912_121075,i__120914_121077);
var healthcheck_uri_121079 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_121078),"/fdb/health"].join('');
var resp_chan_121080 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_121079,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__100069__auto___121081 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078){
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = ((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078){
return (function (state_120973){
var state_val_120974 = (state_120973[(1)]);
if((state_val_120974 === (1))){
var state_120973__$1 = state_120973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_120973__$1,(2),resp_chan_121080);
} else {
if((state_val_120974 === (2))){
var inst_120962 = (state_120973[(7)]);
var inst_120962__$1 = (state_120973[(2)]);
var inst_120963 = fluree.db.util.core.exception_QMARK_.call(null,inst_120962__$1);
var state_120973__$1 = (function (){var statearr_120975 = state_120973;
(statearr_120975[(7)] = inst_120962__$1);

return statearr_120975;
})();
if(inst_120963){
var statearr_120976_121082 = state_120973__$1;
(statearr_120976_121082[(1)] = (3));

} else {
var statearr_120977_121083 = state_120973__$1;
(statearr_120977_121083[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120974 === (3))){
var inst_120962 = (state_120973[(7)]);
var inst_120965 = cljs.core.ex_message.call(null,inst_120962);
var inst_120966 = cljs.core.ex_data.call(null,inst_120962);
var inst_120967 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_120965,inst_120966);
var state_120973__$1 = state_120973;
var statearr_120978_121084 = state_120973__$1;
(statearr_120978_121084[(2)] = inst_120967);

(statearr_120978_121084[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120974 === (4))){
var inst_120969 = cljs.core.async.put_BANG_.call(null,promise_chan,server_121078);
var state_120973__$1 = state_120973;
var statearr_120979_121085 = state_120973__$1;
(statearr_120979_121085[(2)] = inst_120969);

(statearr_120979_121085[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120974 === (5))){
var inst_120971 = (state_120973[(2)]);
var state_120973__$1 = state_120973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_120973__$1,inst_120971);
} else {
return null;
}
}
}
}
}
});})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078))
;
return ((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,switch__99974__auto__,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0 = (function (){
var statearr_120980 = [null,null,null,null,null,null,null,null];
(statearr_120980[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__);

(statearr_120980[(1)] = (1));

return statearr_120980;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1 = (function (state_120973){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_120973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e120981){if((e120981 instanceof Object)){
var ex__99978__auto__ = e120981;
var statearr_120982_121086 = state_120973;
(statearr_120982_121086[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_120973);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e120981;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121087 = state_120973;
state_120973 = G__121087;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = function(state_120973){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1.call(this,state_120973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__;
})()
;})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,switch__99974__auto__,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078))
})();
var state__100071__auto__ = (function (){var statearr_120983 = f__100070__auto__.call(null);
(statearr_120983[(6)] = c__100069__auto___121081);

return statearr_120983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121081,healthcheck_uri_121079,resp_chan_121080,server_121078))
);



var G__121088 = seq__120911_121074;
var G__121089 = chunk__120912_121075;
var G__121090 = count__120913_121076;
var G__121091 = (i__120914_121077 + (1));
seq__120911_121074 = G__121088;
chunk__120912_121075 = G__121089;
count__120913_121076 = G__121090;
i__120914_121077 = G__121091;
continue;
} else {
var temp__5735__auto___121092 = cljs.core.seq.call(null,seq__120911_121074);
if(temp__5735__auto___121092){
var seq__120911_121093__$1 = temp__5735__auto___121092;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__120911_121093__$1)){
var c__4556__auto___121094 = cljs.core.chunk_first.call(null,seq__120911_121093__$1);
var G__121095 = cljs.core.chunk_rest.call(null,seq__120911_121093__$1);
var G__121096 = c__4556__auto___121094;
var G__121097 = cljs.core.count.call(null,c__4556__auto___121094);
var G__121098 = (0);
seq__120911_121074 = G__121095;
chunk__120912_121075 = G__121096;
count__120913_121076 = G__121097;
i__120914_121077 = G__121098;
continue;
} else {
var server_121099 = cljs.core.first.call(null,seq__120911_121093__$1);
var healthcheck_uri_121100 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_121099),"/fdb/health"].join('');
var resp_chan_121101 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_121100,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__100069__auto___121102 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092){
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = ((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092){
return (function (state_120996){
var state_val_120997 = (state_120996[(1)]);
if((state_val_120997 === (1))){
var state_120996__$1 = state_120996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_120996__$1,(2),resp_chan_121101);
} else {
if((state_val_120997 === (2))){
var inst_120985 = (state_120996[(7)]);
var inst_120985__$1 = (state_120996[(2)]);
var inst_120986 = fluree.db.util.core.exception_QMARK_.call(null,inst_120985__$1);
var state_120996__$1 = (function (){var statearr_120998 = state_120996;
(statearr_120998[(7)] = inst_120985__$1);

return statearr_120998;
})();
if(inst_120986){
var statearr_120999_121103 = state_120996__$1;
(statearr_120999_121103[(1)] = (3));

} else {
var statearr_121000_121104 = state_120996__$1;
(statearr_121000_121104[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120997 === (3))){
var inst_120985 = (state_120996[(7)]);
var inst_120988 = cljs.core.ex_message.call(null,inst_120985);
var inst_120989 = cljs.core.ex_data.call(null,inst_120985);
var inst_120990 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_120988,inst_120989);
var state_120996__$1 = state_120996;
var statearr_121001_121105 = state_120996__$1;
(statearr_121001_121105[(2)] = inst_120990);

(statearr_121001_121105[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120997 === (4))){
var inst_120992 = cljs.core.async.put_BANG_.call(null,promise_chan,server_121099);
var state_120996__$1 = state_120996;
var statearr_121002_121106 = state_120996__$1;
(statearr_121002_121106[(2)] = inst_120992);

(statearr_121002_121106[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_120997 === (5))){
var inst_120994 = (state_120996[(2)]);
var state_120996__$1 = state_120996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_120996__$1,inst_120994);
} else {
return null;
}
}
}
}
}
});})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092))
;
return ((function (seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,switch__99974__auto__,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0 = (function (){
var statearr_121003 = [null,null,null,null,null,null,null,null];
(statearr_121003[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__);

(statearr_121003[(1)] = (1));

return statearr_121003;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1 = (function (state_120996){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_120996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121004){if((e121004 instanceof Object)){
var ex__99978__auto__ = e121004;
var statearr_121005_121107 = state_120996;
(statearr_121005_121107[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_120996);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121004;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121108 = state_120996;
state_120996 = G__121108;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = function(state_120996){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1.call(this,state_120996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__;
})()
;})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,switch__99974__auto__,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092))
})();
var state__100071__auto__ = (function (){var statearr_121006 = f__100070__auto__.call(null);
(statearr_121006[(6)] = c__100069__auto___121102);

return statearr_121006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});})(seq__120911_121074,chunk__120912_121075,count__120913_121076,i__120914_121077,c__100069__auto___121102,healthcheck_uri_121100,resp_chan_121101,server_121099,seq__120911_121093__$1,temp__5735__auto___121092))
);



var G__121109 = cljs.core.next.call(null,seq__120911_121093__$1);
var G__121110 = null;
var G__121111 = (0);
var G__121112 = (0);
seq__120911_121074 = G__121109;
chunk__120912_121075 = G__121110;
count__120913_121076 = G__121111;
i__120914_121077 = G__121112;
continue;
}
} else {
}
}
break;
}

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121049){
var state_val_121050 = (state_121049[(1)]);
if((state_val_121050 === (7))){
var inst_121021 = (state_121049[(7)]);
var inst_121028 = cljs.core._EQ_.call(null,inst_121021,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_121049__$1 = state_121049;
if(inst_121028){
var statearr_121051_121113 = state_121049__$1;
(statearr_121051_121113[(1)] = (9));

} else {
var statearr_121052_121114 = state_121049__$1;
(statearr_121052_121114[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (1))){
var inst_121014 = (state_121049[(8)]);
var inst_121014__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_121015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121016 = [promise_chan,inst_121014__$1];
var inst_121017 = (new cljs.core.PersistentVector(null,2,(5),inst_121015,inst_121016,null));
var state_121049__$1 = (function (){var statearr_121053 = state_121049;
(statearr_121053[(8)] = inst_121014__$1);

return statearr_121053;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_121049__$1,(2),inst_121017);
} else {
if((state_val_121050 === (4))){
var inst_121014 = (state_121049[(8)]);
var inst_121021 = (state_121049[(7)]);
var inst_121025 = cljs.core._EQ_.call(null,inst_121021,inst_121014);
var state_121049__$1 = state_121049;
if(inst_121025){
var statearr_121054_121115 = state_121049__$1;
(statearr_121054_121115[(1)] = (6));

} else {
var statearr_121055_121116 = state_121049__$1;
(statearr_121055_121116[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (13))){
var state_121049__$1 = state_121049;
var statearr_121056_121117 = state_121049__$1;
(statearr_121056_121117[(2)] = null);

(statearr_121056_121117[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (6))){
var state_121049__$1 = state_121049;
var statearr_121057_121118 = state_121049__$1;
(statearr_121057_121118[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_121057_121118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (3))){
var state_121049__$1 = state_121049;
var statearr_121058_121119 = state_121049__$1;
(statearr_121058_121119[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_121058_121119[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (12))){
var inst_121039 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_121040 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_121041 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_121042 = cljs.core.PersistentHashMap.fromArrays(inst_121040,inst_121041);
var inst_121043 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_121042);
var inst_121044 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_121043);
var state_121049__$1 = (function (){var statearr_121059 = state_121049;
(statearr_121059[(9)] = inst_121039);

return statearr_121059;
})();
var statearr_121060_121120 = state_121049__$1;
(statearr_121060_121120[(2)] = inst_121044);

(statearr_121060_121120[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (2))){
var inst_121021 = (state_121049[(7)]);
var inst_121019 = (state_121049[(2)]);
var inst_121020 = cljs.core.nth.call(null,inst_121019,(0),null);
var inst_121021__$1 = cljs.core.nth.call(null,inst_121019,(1),null);
var inst_121022 = cljs.core._EQ_.call(null,inst_121021__$1,promise_chan);
var state_121049__$1 = (function (){var statearr_121061 = state_121049;
(statearr_121061[(10)] = inst_121020);

(statearr_121061[(7)] = inst_121021__$1);

return statearr_121061;
})();
if(inst_121022){
var statearr_121062_121121 = state_121049__$1;
(statearr_121062_121121[(1)] = (3));

} else {
var statearr_121063_121122 = state_121049__$1;
(statearr_121063_121122[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (11))){
var inst_121032 = (state_121049[(2)]);
var state_121049__$1 = state_121049;
var statearr_121064_121123 = state_121049__$1;
(statearr_121064_121123[(2)] = inst_121032);

(statearr_121064_121123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (9))){
var inst_121020 = (state_121049[(10)]);
var state_121049__$1 = state_121049;
var statearr_121065_121124 = state_121049__$1;
(statearr_121065_121124[(2)] = inst_121020);

(statearr_121065_121124[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (5))){
var inst_121036 = (state_121049[(2)]);
var inst_121037 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_121036);
var state_121049__$1 = state_121049;
if(inst_121037){
var statearr_121066_121125 = state_121049__$1;
(statearr_121066_121125[(1)] = (12));

} else {
var statearr_121067_121126 = state_121049__$1;
(statearr_121067_121126[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (14))){
var inst_121047 = (state_121049[(2)]);
var state_121049__$1 = state_121049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121049__$1,inst_121047);
} else {
if((state_val_121050 === (10))){
var state_121049__$1 = state_121049;
var statearr_121068_121127 = state_121049__$1;
(statearr_121068_121127[(2)] = null);

(statearr_121068_121127[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121050 === (8))){
var inst_121034 = (state_121049[(2)]);
var state_121049__$1 = state_121049;
var statearr_121069_121128 = state_121049__$1;
(statearr_121069_121128[(2)] = inst_121034);

(statearr_121069_121128[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0 = (function (){
var statearr_121070 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_121070[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__);

(statearr_121070[(1)] = (1));

return statearr_121070;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1 = (function (state_121049){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121071){if((e121071 instanceof Object)){
var ex__99978__auto__ = e121071;
var statearr_121072_121129 = state_121049;
(statearr_121072_121129[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121049);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121071;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121130 = state_121049;
state_121049 = G__121130;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__ = function(state_121049){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1.call(this,state_121049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121073 = f__100070__auto__.call(null);
(statearr_121073[(6)] = c__100069__auto__);

return statearr_121073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121171){
var state_val_121172 = (state_121171[(1)]);
if((state_val_121172 === (7))){
var inst_121149 = (state_121171[(7)]);
var inst_121167 = (state_121171[(2)]);
var state_121171__$1 = (function (){var statearr_121173 = state_121171;
(statearr_121173[(8)] = inst_121167);

return statearr_121173;
})();
var statearr_121174_121192 = state_121171__$1;
(statearr_121174_121192[(2)] = inst_121149);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121171__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (1))){
var state_121171__$1 = state_121171;
var statearr_121175_121193 = state_121171__$1;
(statearr_121175_121193[(2)] = null);

(statearr_121175_121193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (4))){
var inst_121135 = (state_121171[(9)]);
var inst_121140 = (state_121171[(10)]);
var inst_121145 = (state_121171[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_121171,(3),Error,null,(2));
var inst_121135__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_121136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121137 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_121138 = (new cljs.core.PersistentVector(null,2,(5),inst_121136,inst_121137,null));
var inst_121139 = (function (){var lock_id = inst_121135__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_121140__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_121138,inst_121139);
var inst_121141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121142 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_121143 = (new cljs.core.PersistentVector(null,3,(5),inst_121141,inst_121142,null));
var inst_121144 = cljs.core.get_in.call(null,inst_121140__$1,inst_121143);
var inst_121145__$1 = cljs.core._EQ_.call(null,inst_121135__$1,inst_121144);
var inst_121146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121147 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_121148 = (new cljs.core.PersistentVector(null,3,(5),inst_121146,inst_121147,null));
var inst_121149 = cljs.core.get_in.call(null,inst_121140__$1,inst_121148);
var state_121171__$1 = (function (){var statearr_121176 = state_121171;
(statearr_121176[(7)] = inst_121149);

(statearr_121176[(9)] = inst_121135__$1);

(statearr_121176[(10)] = inst_121140__$1);

(statearr_121176[(11)] = inst_121145__$1);

return statearr_121176;
})();
if(inst_121145__$1){
var statearr_121177_121194 = state_121171__$1;
(statearr_121177_121194[(1)] = (5));

} else {
var statearr_121178_121195 = state_121171__$1;
(statearr_121178_121195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (6))){
var state_121171__$1 = state_121171;
var statearr_121179_121196 = state_121171__$1;
(statearr_121179_121196[(2)] = null);

(statearr_121179_121196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (3))){
var inst_121131 = (state_121171[(2)]);
var state_121171__$1 = state_121171;
var statearr_121180_121197 = state_121171__$1;
(statearr_121180_121197[(2)] = inst_121131);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121171__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (2))){
var inst_121169 = (state_121171[(2)]);
var state_121171__$1 = state_121171;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121171__$1,inst_121169);
} else {
if((state_val_121172 === (11))){
var inst_121164 = (state_121171[(2)]);
var state_121171__$1 = state_121171;
var statearr_121181_121198 = state_121171__$1;
(statearr_121181_121198[(2)] = inst_121164);

(statearr_121181_121198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (9))){
var inst_121149 = (state_121171[(7)]);
var inst_121153 = (state_121171[(12)]);
var inst_121159 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_121160 = cljs.core.async.put_BANG_.call(null,inst_121149,inst_121153);
var state_121171__$1 = (function (){var statearr_121182 = state_121171;
(statearr_121182[(13)] = inst_121159);

return statearr_121182;
})();
var statearr_121183_121199 = state_121171__$1;
(statearr_121183_121199[(2)] = inst_121160);

(statearr_121183_121199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (5))){
var inst_121151 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_121171__$1 = state_121171;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121171__$1,(8),inst_121151);
} else {
if((state_val_121172 === (10))){
var inst_121149 = (state_121171[(7)]);
var inst_121156 = (state_121171[(14)]);
var inst_121155 = (state_121171[(15)]);
var inst_121162 = fluree.db.util.xhttp.try_socket.call(null,inst_121155,sub_chan,pub_chan,inst_121149,(60000),inst_121156);
var state_121171__$1 = state_121171;
var statearr_121184_121200 = state_121171__$1;
(statearr_121184_121200[(2)] = inst_121162);

(statearr_121184_121200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121172 === (8))){
var inst_121149 = (state_121171[(7)]);
var inst_121135 = (state_121171[(9)]);
var inst_121153 = (state_121171[(12)]);
var inst_121140 = (state_121171[(10)]);
var inst_121155 = (state_121171[(15)]);
var inst_121145 = (state_121171[(11)]);
var inst_121153__$1 = (state_121171[(2)]);
var inst_121154 = clojure.string.replace.call(null,inst_121153__$1,"http","ws");
var inst_121155__$1 = [inst_121154,"/fdb/ws"].join('');
var inst_121156 = (function (){var lock_id = inst_121135;
var state = inst_121140;
var have_lock_QMARK_ = inst_121145;
var resp_chan = inst_121149;
var healthy_server = inst_121153__$1;
var ws_url = inst_121155__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_121157 = fluree.db.util.core.exception_QMARK_.call(null,inst_121153__$1);
var state_121171__$1 = (function (){var statearr_121185 = state_121171;
(statearr_121185[(14)] = inst_121156);

(statearr_121185[(12)] = inst_121153__$1);

(statearr_121185[(15)] = inst_121155__$1);

return statearr_121185;
})();
if(inst_121157){
var statearr_121186_121201 = state_121171__$1;
(statearr_121186_121201[(1)] = (9));

} else {
var statearr_121187_121202 = state_121171__$1;
(statearr_121187_121202[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__99975__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__99975__auto____0 = (function (){
var statearr_121188 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121188[(0)] = fluree$db$connection$establish_socket_$_state_machine__99975__auto__);

(statearr_121188[(1)] = (1));

return statearr_121188;
});
var fluree$db$connection$establish_socket_$_state_machine__99975__auto____1 = (function (state_121171){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121171);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121189){if((e121189 instanceof Object)){
var ex__99978__auto__ = e121189;
var statearr_121190_121203 = state_121171;
(statearr_121190_121203[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121171);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121204 = state_121171;
state_121171 = G__121204;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__99975__auto__ = function(state_121171){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__99975__auto____1.call(this,state_121171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__99975__auto____0;
fluree$db$connection$establish_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__99975__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121191 = f__100070__auto__.call(null);
(statearr_121191[(6)] = c__100069__auto__);

return statearr_121191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k121206,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__121210 = k121206;
var G__121210__$1 = (((G__121210 instanceof cljs.core.Keyword))?G__121210.fqn:null);
switch (G__121210__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k121206,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__121211){
var vec__121212 = p__121211;
var k__4403__auto__ = cljs.core.nth.call(null,vec__121212,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__121212,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__121205){
var self__ = this;
var G__121205__$1 = this;
return (new cljs.core.RecordIter((0),G__121205__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this121207,other121208){
var self__ = this;
var this121207__$1 = this;
return (((!((other121208 == null)))) && ((this121207__$1.constructor === other121208.constructor)) && (cljs.core._EQ_.call(null,this121207__$1.id,other121208.id)) && (cljs.core._EQ_.call(null,this121207__$1.servers,other121208.servers)) && (cljs.core._EQ_.call(null,this121207__$1.state,other121208.state)) && (cljs.core._EQ_.call(null,this121207__$1.req_chan,other121208.req_chan)) && (cljs.core._EQ_.call(null,this121207__$1.sub_chan,other121208.sub_chan)) && (cljs.core._EQ_.call(null,this121207__$1.pub_chan,other121208.pub_chan)) && (cljs.core._EQ_.call(null,this121207__$1.storage_read,other121208.storage_read)) && (cljs.core._EQ_.call(null,this121207__$1.storage_write,other121208.storage_write)) && (cljs.core._EQ_.call(null,this121207__$1.object_cache,other121208.object_cache)) && (cljs.core._EQ_.call(null,this121207__$1.parallelism,other121208.parallelism)) && (cljs.core._EQ_.call(null,this121207__$1.serializer,other121208.serializer)) && (cljs.core._EQ_.call(null,this121207__$1.default_network,other121208.default_network)) && (cljs.core._EQ_.call(null,this121207__$1.transactor_QMARK_,other121208.transactor_QMARK_)) && (cljs.core._EQ_.call(null,this121207__$1.publish,other121208.publish)) && (cljs.core._EQ_.call(null,this121207__$1.transact_handler,other121208.transact_handler)) && (cljs.core._EQ_.call(null,this121207__$1.tx_private_key,other121208.tx_private_key)) && (cljs.core._EQ_.call(null,this121207__$1.tx_key_id,other121208.tx_key_id)) && (cljs.core._EQ_.call(null,this121207__$1.meta,other121208.meta)) && (cljs.core._EQ_.call(null,this121207__$1.add_listener,other121208.add_listener)) && (cljs.core._EQ_.call(null,this121207__$1.remove_listener,other121208.remove_listener)) && (cljs.core._EQ_.call(null,this121207__$1.close,other121208.close)) && (cljs.core._EQ_.call(null,this121207__$1.__extmap,other121208.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__121205){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__121215 = cljs.core.keyword_identical_QMARK_;
var expr__121216 = k__4388__auto__;
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__121216))){
return (new fluree.db.connection.Connection(G__121205,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,G__121205,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__121205,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__121205,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__121205,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__121205,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__121205,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__121205,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__121205,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__121205,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__121205,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__121205,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__121205,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__121205,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__121205,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__121205,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__121205,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__121205,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__121205,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__121205,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__121215.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__121216))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__121205,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__121205),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__121205){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__121205,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__121209){
var extmap__4419__auto__ = (function (){var G__121218 = cljs.core.dissoc.call(null,G__121209,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__121209)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__121218);
} else {
return G__121218;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__121209),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__121209),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__121223 = servers_STAR_;
var vec__121224 = G__121223;
var seq__121225 = cljs.core.seq.call(null,vec__121224);
var first__121226 = cljs.core.first.call(null,seq__121225);
var seq__121225__$1 = cljs.core.next.call(null,seq__121225);
var server = first__121226;
var r = seq__121225__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__121223__$1 = G__121223;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__121230 = G__121223__$1;
var seq__121231 = cljs.core.seq.call(null,vec__121230);
var first__121232 = cljs.core.first.call(null,seq__121231);
var seq__121231__$1 = cljs.core.next.call(null,seq__121231);
var server__$1 = first__121232;
var r__$1 = seq__121231__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__121233 = r__$1;
var G__121234 = is_https_QMARK_;
var G__121235 = result_STAR_;
G__121223__$1 = G__121233;
https_QMARK___$1 = G__121234;
result__$1 = G__121235;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.connection !== 'undefined') && (typeof fluree.db.connection.process_event !== 'undefined')){
} else {
fluree.db.connection.process_event = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.connection","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.connection.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.connection.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__121236 = cljs.core.seq.call(null,callbacks);
var chunk__121237 = null;
var count__121238 = (0);
var i__121239 = (0);
while(true){
if((i__121239 < count__121238)){
var vec__121248 = cljs.core._nth.call(null,chunk__121237,i__121239);
var k = cljs.core.nth.call(null,vec__121248,(0),null);
var f = cljs.core.nth.call(null,vec__121248,(1),null);
try{f.call(null,event_type,event_data);
}catch (e121251){var e_121256 = e121251;
fluree.db.util.log.error.call(null,e_121256,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__121257 = seq__121236;
var G__121258 = chunk__121237;
var G__121259 = count__121238;
var G__121260 = (i__121239 + (1));
seq__121236 = G__121257;
chunk__121237 = G__121258;
count__121238 = G__121259;
i__121239 = G__121260;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__121236);
if(temp__5735__auto__){
var seq__121236__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__121236__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__121236__$1);
var G__121261 = cljs.core.chunk_rest.call(null,seq__121236__$1);
var G__121262 = c__4556__auto__;
var G__121263 = cljs.core.count.call(null,c__4556__auto__);
var G__121264 = (0);
seq__121236 = G__121261;
chunk__121237 = G__121262;
count__121238 = G__121263;
i__121239 = G__121264;
continue;
} else {
var vec__121252 = cljs.core.first.call(null,seq__121236__$1);
var k = cljs.core.nth.call(null,vec__121252,(0),null);
var f = cljs.core.nth.call(null,vec__121252,(1),null);
try{f.call(null,event_type,event_data);
}catch (e121255){var e_121265 = e121255;
fluree.db.util.log.error.call(null,e_121265,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__121266 = cljs.core.next.call(null,seq__121236__$1);
var G__121267 = null;
var G__121268 = (0);
var G__121269 = (0);
seq__121236 = G__121266;
chunk__121237 = G__121267;
count__121238 = G__121268;
i__121239 = G__121269;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.connection.process_events = (function fluree$db$connection$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__121272 = msg;
var event_type = cljs.core.nth.call(null,vec__121272,(0),null);
var subject = cljs.core.nth.call(null,vec__121272,(1),null);
var event_data = cljs.core.nth.call(null,vec__121272,(2),null);
var error_data = cljs.core.nth.call(null,vec__121272,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__121275 = conn;
var map__121275__$1 = (((((!((map__121275 == null))))?(((((map__121275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__121275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__121275):map__121275);
var state = cljs.core.get.call(null,map__121275__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__121277 = event_type__$1;
var G__121277__$1 = (((G__121277 instanceof cljs.core.Keyword))?G__121277.fqn:null);
switch (G__121277__$1) {
case "response":
var temp__5735__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5735__auto__)){
var res_chan = temp__5735__auto__;
cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__121270_SHARP_){
return cljs.core.dissoc.call(null,p1__121270_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__121278 = error_data;
var map__121278__$1 = (((((!((map__121278 == null))))?(((((map__121278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__121278.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__121278):map__121278);
var message = cljs.core.get.call(null,map__121278__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.connection.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e121271){var e = e121271;
return fluree.db.util.log.error.call(null,e);
}});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__121281 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__121281 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__121281);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121307){
var state_val_121308 = (state_121307[(1)]);
if((state_val_121308 === (1))){
var state_121307__$1 = state_121307;
var statearr_121309_121321 = state_121307__$1;
(statearr_121309_121321[(2)] = null);

(statearr_121309_121321[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121308 === (2))){
var inst_121305 = (state_121307[(2)]);
var state_121307__$1 = state_121307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121307__$1,inst_121305);
} else {
if((state_val_121308 === (3))){
var inst_121282 = (state_121307[(2)]);
var state_121307__$1 = state_121307;
var statearr_121310_121322 = state_121307__$1;
(statearr_121310_121322[(2)] = inst_121282);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121307__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121308 === (4))){
var inst_121291 = (state_121307[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_121307,(3),Error,null,(2));
var inst_121286 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_121287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121288 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121289 = [inst_121288,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_121290 = (new cljs.core.PersistentVector(null,3,(5),inst_121287,inst_121289,null));
var inst_121291__$1 = cljs.core.get_in.call(null,inst_121286,inst_121290);
var state_121307__$1 = (function (){var statearr_121311 = state_121307;
(statearr_121311[(7)] = inst_121291__$1);

return statearr_121311;
})();
if(cljs.core.truth_(inst_121291__$1)){
var statearr_121312_121323 = state_121307__$1;
(statearr_121312_121323[(1)] = (5));

} else {
var statearr_121313_121324 = state_121307__$1;
(statearr_121313_121324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121308 === (5))){
var inst_121291 = (state_121307[(7)]);
var state_121307__$1 = state_121307;
var statearr_121314_121325 = state_121307__$1;
(statearr_121314_121325[(2)] = inst_121291);

(statearr_121314_121325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121308 === (6))){
var inst_121294 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121295 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121296 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121297 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121298 = fluree.db.connection.establish_socket.call(null,inst_121294,inst_121295,inst_121296,inst_121297);
var state_121307__$1 = state_121307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121307__$1,(8),inst_121298);
} else {
if((state_val_121308 === (7))){
var inst_121303 = (state_121307[(2)]);
var state_121307__$1 = state_121307;
var statearr_121315_121326 = state_121307__$1;
(statearr_121315_121326[(2)] = inst_121303);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121307__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121308 === (8))){
var inst_121300 = (state_121307[(2)]);
var inst_121301 = fluree.db.util.async.throw_err.call(null,inst_121300);
var state_121307__$1 = state_121307;
var statearr_121316_121327 = state_121307__$1;
(statearr_121316_121327[(2)] = inst_121301);

(statearr_121316_121327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__99975__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__99975__auto____0 = (function (){
var statearr_121317 = [null,null,null,null,null,null,null,null];
(statearr_121317[(0)] = fluree$db$connection$get_socket_$_state_machine__99975__auto__);

(statearr_121317[(1)] = (1));

return statearr_121317;
});
var fluree$db$connection$get_socket_$_state_machine__99975__auto____1 = (function (state_121307){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121318){if((e121318 instanceof Object)){
var ex__99978__auto__ = e121318;
var statearr_121319_121328 = state_121307;
(statearr_121319_121328[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121307);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121318;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121329 = state_121307;
state_121307 = G__121329;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__99975__auto__ = function(state_121307){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__99975__auto____1.call(this,state_121307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__99975__auto____0;
fluree$db$connection$get_socket_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__99975__auto____1;
return fluree$db$connection$get_socket_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121320 = f__100070__auto__.call(null);
(statearr_121320[(6)] = c__100069__auto__);

return statearr_121320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e121330){var e = e121330;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121474){
var state_val_121475 = (state_121474[(1)]);
if((state_val_121475 === (7))){
var inst_121470 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121476_121552 = state_121474__$1;
(statearr_121476_121552[(2)] = inst_121470);

(statearr_121476_121552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (20))){
var inst_121373 = (state_121474[(7)]);
var inst_121378 = inst_121373.cljs$lang$protocol_mask$partition0$;
var inst_121379 = (inst_121378 & (64));
var inst_121380 = inst_121373.cljs$core$ISeq$;
var inst_121381 = (cljs.core.PROTOCOL_SENTINEL === inst_121380);
var inst_121382 = ((inst_121379) || (inst_121381));
var state_121474__$1 = state_121474;
if(cljs.core.truth_(inst_121382)){
var statearr_121477_121553 = state_121474__$1;
(statearr_121477_121553[(1)] = (23));

} else {
var statearr_121478_121554 = state_121474__$1;
(statearr_121478_121554[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (27))){
var inst_121373 = (state_121474[(7)]);
var state_121474__$1 = state_121474;
var statearr_121479_121555 = state_121474__$1;
(statearr_121479_121555[(2)] = inst_121373);

(statearr_121479_121555[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (1))){
var inst_121332 = (0);
var state_121474__$1 = (function (){var statearr_121480 = state_121474;
(statearr_121480[(8)] = inst_121332);

return statearr_121480;
})();
var statearr_121481_121556 = state_121474__$1;
(statearr_121481_121556[(2)] = null);

(statearr_121481_121556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (24))){
var state_121474__$1 = state_121474;
var statearr_121482_121557 = state_121474__$1;
(statearr_121482_121557[(2)] = false);

(statearr_121482_121557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (39))){
var inst_121451 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_121474__$1 = state_121474;
var statearr_121483_121558 = state_121474__$1;
(statearr_121483_121558[(2)] = inst_121451);

(statearr_121483_121558[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (4))){
var inst_121335 = (state_121474[(9)]);
var inst_121335__$1 = (state_121474[(2)]);
var state_121474__$1 = (function (){var statearr_121484 = state_121474;
(statearr_121484[(9)] = inst_121335__$1);

return statearr_121484;
})();
if(cljs.core.truth_(inst_121335__$1)){
var statearr_121485_121559 = state_121474__$1;
(statearr_121485_121559[(1)] = (5));

} else {
var statearr_121486_121560 = state_121474__$1;
(statearr_121486_121560[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (15))){
var inst_121353 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
if(cljs.core.truth_(inst_121353)){
var statearr_121487_121561 = state_121474__$1;
(statearr_121487_121561[(1)] = (16));

} else {
var statearr_121488_121562 = state_121474__$1;
(statearr_121488_121562[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (21))){
var state_121474__$1 = state_121474;
var statearr_121489_121563 = state_121474__$1;
(statearr_121489_121563[(2)] = false);

(statearr_121489_121563[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (31))){
var inst_121371 = (state_121474[(10)]);
var inst_121397 = (state_121474[(11)]);
var inst_121370 = (state_121474[(12)]);
var inst_121435 = (state_121474[(2)]);
var inst_121436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121437 = [inst_121370,inst_121397,inst_121371];
var inst_121438 = (new cljs.core.PersistentVector(null,3,(5),inst_121436,inst_121437,null));
var inst_121439 = publish_fn.call(null,conn,inst_121438);
var state_121474__$1 = (function (){var statearr_121490 = state_121474;
(statearr_121490[(13)] = inst_121435);

return statearr_121490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121474__$1,(32),inst_121439);
} else {
if((state_val_121475 === (32))){
var inst_121441 = (state_121474[(14)]);
var inst_121441__$1 = (state_121474[(2)]);
var inst_121442 = inst_121441__$1 === true;
var state_121474__$1 = (function (){var statearr_121491 = state_121474;
(statearr_121491[(14)] = inst_121441__$1);

return statearr_121491;
})();
if(cljs.core.truth_(inst_121442)){
var statearr_121492_121564 = state_121474__$1;
(statearr_121492_121564[(1)] = (33));

} else {
var statearr_121493_121565 = state_121474__$1;
(statearr_121493_121565[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (40))){
var state_121474__$1 = state_121474;
var statearr_121494_121566 = state_121474__$1;
(statearr_121494_121566[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (33))){
var state_121474__$1 = state_121474;
var statearr_121496_121567 = state_121474__$1;
(statearr_121496_121567[(2)] = null);

(statearr_121496_121567[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (13))){
var inst_121348 = (state_121474[(15)]);
var inst_121350 = fluree.db.util.async.channel_QMARK_.call(null,inst_121348);
var state_121474__$1 = state_121474;
var statearr_121497_121568 = state_121474__$1;
(statearr_121497_121568[(2)] = inst_121350);

(statearr_121497_121568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (22))){
var inst_121389 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
if(cljs.core.truth_(inst_121389)){
var statearr_121498_121569 = state_121474__$1;
(statearr_121498_121569[(1)] = (26));

} else {
var statearr_121499_121570 = state_121474__$1;
(statearr_121499_121570[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (36))){
var inst_121441 = (state_121474[(14)]);
var inst_121447 = fluree.db.util.log.error.call(null,inst_121441,"Error processing message in producer.");
var state_121474__$1 = state_121474;
var statearr_121500_121571 = state_121474__$1;
(statearr_121500_121571[(2)] = inst_121447);

(statearr_121500_121571[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (41))){
var inst_121459 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121501_121572 = state_121474__$1;
(statearr_121501_121572[(2)] = inst_121459);

(statearr_121501_121572[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (43))){
var state_121474__$1 = state_121474;
var statearr_121502_121573 = state_121474__$1;
(statearr_121502_121573[(2)] = null);

(statearr_121502_121573[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (29))){
var inst_121372 = (state_121474[(16)]);
var inst_121371 = (state_121474[(10)]);
var inst_121397 = (state_121474[(11)]);
var inst_121370 = (state_121474[(12)]);
var inst_121398 = (state_121474[(17)]);
var inst_121369 = (state_121474[(18)]);
var inst_121335 = (state_121474[(9)]);
var inst_121332 = (state_121474[(8)]);
var inst_121373 = (state_121474[(7)]);
var inst_121394 = (state_121474[(19)]);
var inst_121400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121401 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_121397];
var inst_121402 = (new cljs.core.PersistentVector(null,2,(5),inst_121400,inst_121401,null));
var inst_121403 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_121402,inst_121372);
var inst_121430 = cljs.core.async.chan.call(null,(1));
var inst_121431 = (function (){var resp_chan = inst_121372;
var timeout = inst_121398;
var i = inst_121332;
var vec__121365 = inst_121335;
var data = inst_121371;
var c__100069__auto____$1 = inst_121430;
var _ = inst_121369;
var req_id = inst_121397;
var operation = inst_121370;
var msg = inst_121335;
var map__121368 = inst_121394;
var opts = inst_121373;
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121428){
var state_val_121429 = (state_121428[(1)]);
if((state_val_121429 === (1))){
var inst_121407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121408 = cljs.core.async.timeout.call(null,timeout);
var inst_121409 = [resp_chan,inst_121408];
var inst_121410 = (new cljs.core.PersistentVector(null,2,(5),inst_121407,inst_121409,null));
var state_121428__$1 = state_121428;
return cljs.core.async.ioc_alts_BANG_.call(null,state_121428__$1,(2),inst_121410);
} else {
if((state_val_121429 === (2))){
var inst_121413 = (state_121428[(7)]);
var inst_121412 = (state_121428[(2)]);
var inst_121413__$1 = cljs.core.nth.call(null,inst_121412,(0),null);
var inst_121414 = cljs.core.nth.call(null,inst_121412,(1),null);
var inst_121415 = (function (){var vec__121404 = inst_121412;
var resp = inst_121413__$1;
var c = inst_121414;
return (function (p1__121331_SHARP_){
return cljs.core.dissoc.call(null,p1__121331_SHARP_,req_id);
});
})();
var inst_121416 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_121415);
var inst_121417 = cljs.core._EQ_.call(null,inst_121414,resp_chan);
var state_121428__$1 = (function (){var statearr_121503 = state_121428;
(statearr_121503[(8)] = inst_121416);

(statearr_121503[(7)] = inst_121413__$1);

return statearr_121503;
})();
if(inst_121417){
var statearr_121504_121574 = state_121428__$1;
(statearr_121504_121574[(1)] = (3));

} else {
var statearr_121505_121575 = state_121428__$1;
(statearr_121505_121575[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121429 === (3))){
var inst_121413 = (state_121428[(7)]);
var state_121428__$1 = state_121428;
var statearr_121506_121576 = state_121428__$1;
(statearr_121506_121576[(2)] = inst_121413);

(statearr_121506_121576[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121429 === (4))){
var inst_121420 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_121421 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_121422 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_121423 = cljs.core.PersistentHashMap.fromArrays(inst_121421,inst_121422);
var inst_121424 = cljs.core.ex_info.call(null,inst_121420,inst_121423);
var state_121428__$1 = state_121428;
var statearr_121507_121577 = state_121428__$1;
(statearr_121507_121577[(2)] = inst_121424);

(statearr_121507_121577[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121429 === (5))){
var inst_121426 = (state_121428[(2)]);
var state_121428__$1 = state_121428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121428__$1,inst_121426);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__99975__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__99975__auto____0 = (function (){
var statearr_121508 = [null,null,null,null,null,null,null,null,null];
(statearr_121508[(0)] = fluree$db$connection$msg_producer_$_state_machine__99975__auto__);

(statearr_121508[(1)] = (1));

return statearr_121508;
});
var fluree$db$connection$msg_producer_$_state_machine__99975__auto____1 = (function (state_121428){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121509){if((e121509 instanceof Object)){
var ex__99978__auto__ = e121509;
var statearr_121510_121578 = state_121428;
(statearr_121510_121578[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121428);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121579 = state_121428;
state_121428 = G__121579;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__99975__auto__ = function(state_121428){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__99975__auto____1.call(this,state_121428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__99975__auto____0;
fluree$db$connection$msg_producer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__99975__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121511 = f__100070__auto__.call(null);
(statearr_121511[(6)] = c__100069__auto____$1);

return statearr_121511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});
})();
var inst_121432 = cljs.core.async.impl.dispatch.run.call(null,inst_121431);
var state_121474__$1 = (function (){var statearr_121512 = state_121474;
(statearr_121512[(20)] = inst_121403);

(statearr_121512[(21)] = inst_121432);

return statearr_121512;
})();
var statearr_121513_121580 = state_121474__$1;
(statearr_121513_121580[(2)] = inst_121430);

(statearr_121513_121580[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (44))){
var inst_121457 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121514_121581 = state_121474__$1;
(statearr_121514_121581[(2)] = inst_121457);

(statearr_121514_121581[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (6))){
var state_121474__$1 = state_121474;
var statearr_121515_121582 = state_121474__$1;
(statearr_121515_121582[(2)] = null);

(statearr_121515_121582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (28))){
var inst_121372 = (state_121474[(16)]);
var inst_121394 = (state_121474[(19)]);
var inst_121394__$1 = (state_121474[(2)]);
var inst_121395 = fluree.db.util.core.random_uuid.call(null);
var inst_121396 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_121395);
var inst_121397 = cljs.core.get.call(null,inst_121394__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_121396);
var inst_121398 = cljs.core.get.call(null,inst_121394__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_121474__$1 = (function (){var statearr_121516 = state_121474;
(statearr_121516[(11)] = inst_121397);

(statearr_121516[(17)] = inst_121398);

(statearr_121516[(19)] = inst_121394__$1);

return statearr_121516;
})();
if(cljs.core.truth_(inst_121372)){
var statearr_121517_121583 = state_121474__$1;
(statearr_121517_121583[(1)] = (29));

} else {
var statearr_121518_121584 = state_121474__$1;
(statearr_121518_121584[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (25))){
var inst_121386 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121519_121585 = state_121474__$1;
(statearr_121519_121585[(2)] = inst_121386);

(statearr_121519_121585[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (34))){
var inst_121441 = (state_121474[(14)]);
var inst_121445 = fluree.db.util.core.exception_QMARK_.call(null,inst_121441);
var state_121474__$1 = state_121474;
if(inst_121445){
var statearr_121520_121586 = state_121474__$1;
(statearr_121520_121586[(1)] = (36));

} else {
var statearr_121521_121587 = state_121474__$1;
(statearr_121521_121587[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (17))){
var inst_121337 = (state_121474[(22)]);
var inst_121335 = (state_121474[(9)]);
var inst_121357 = cljs.core.pr_str.call(null,inst_121335);
var inst_121358 = ["Error processing ledger request, no valid return channel: ",inst_121357].join('');
var inst_121359 = fluree.db.util.log.error.call(null,inst_121337,inst_121358);
var state_121474__$1 = state_121474;
var statearr_121522_121588 = state_121474__$1;
(statearr_121522_121588[(2)] = inst_121359);

(statearr_121522_121588[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (3))){
var inst_121472 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121474__$1,inst_121472);
} else {
if((state_val_121475 === (12))){
var inst_121348 = (state_121474[(15)]);
var inst_121345 = (state_121474[(2)]);
var inst_121346 = cljs.core.nth.call(null,inst_121345,(0),null);
var inst_121347 = cljs.core.nth.call(null,inst_121345,(1),null);
var inst_121348__$1 = cljs.core.nth.call(null,inst_121345,(2),null);
var state_121474__$1 = (function (){var statearr_121523 = state_121474;
(statearr_121523[(23)] = inst_121346);

(statearr_121523[(24)] = inst_121347);

(statearr_121523[(15)] = inst_121348__$1);

return statearr_121523;
})();
if(cljs.core.truth_(inst_121348__$1)){
var statearr_121524_121589 = state_121474__$1;
(statearr_121524_121589[(1)] = (13));

} else {
var statearr_121525_121590 = state_121474__$1;
(statearr_121525_121590[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (2))){
var state_121474__$1 = state_121474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121474__$1,(4),req_chan);
} else {
if((state_val_121475 === (23))){
var state_121474__$1 = state_121474;
var statearr_121526_121591 = state_121474__$1;
(statearr_121526_121591[(2)] = true);

(statearr_121526_121591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (35))){
var inst_121463 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121527_121592 = state_121474__$1;
(statearr_121527_121592[(2)] = inst_121463);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (19))){
var inst_121335 = (state_121474[(9)]);
var inst_121373 = (state_121474[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_121474,(9),new cljs.core.Keyword(null,"default","default",-1987822328),null,(8));
var inst_121369 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_121335);
var inst_121370 = cljs.core.nth.call(null,inst_121335,(0),null);
var inst_121371 = cljs.core.nth.call(null,inst_121335,(1),null);
var inst_121372 = cljs.core.nth.call(null,inst_121335,(2),null);
var inst_121373__$1 = cljs.core.nth.call(null,inst_121335,(3),null);
var inst_121375 = (inst_121373__$1 == null);
var inst_121376 = cljs.core.not.call(null,inst_121375);
var state_121474__$1 = (function (){var statearr_121528 = state_121474;
(statearr_121528[(16)] = inst_121372);

(statearr_121528[(10)] = inst_121371);

(statearr_121528[(12)] = inst_121370);

(statearr_121528[(18)] = inst_121369);

(statearr_121528[(7)] = inst_121373__$1);

return statearr_121528;
})();
if(inst_121376){
var statearr_121529_121593 = state_121474__$1;
(statearr_121529_121593[(1)] = (20));

} else {
var statearr_121530_121594 = state_121474__$1;
(statearr_121530_121594[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (11))){
var state_121474__$1 = state_121474;
var statearr_121531_121595 = state_121474__$1;
(statearr_121531_121595[(2)] = null);

(statearr_121531_121595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (9))){
var inst_121335 = (state_121474[(9)]);
var inst_121337 = (state_121474[(2)]);
var inst_121341 = cljs.core.sequential_QMARK_.call(null,inst_121335);
var state_121474__$1 = (function (){var statearr_121532 = state_121474;
(statearr_121532[(22)] = inst_121337);

return statearr_121532;
})();
if(inst_121341){
var statearr_121533_121596 = state_121474__$1;
(statearr_121533_121596[(1)] = (10));

} else {
var statearr_121534_121597 = state_121474__$1;
(statearr_121534_121597[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (5))){
var state_121474__$1 = state_121474;
var statearr_121535_121598 = state_121474__$1;
(statearr_121535_121598[(2)] = null);

(statearr_121535_121598[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (14))){
var inst_121348 = (state_121474[(15)]);
var state_121474__$1 = state_121474;
var statearr_121536_121599 = state_121474__$1;
(statearr_121536_121599[(2)] = inst_121348);

(statearr_121536_121599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (26))){
var inst_121373 = (state_121474[(7)]);
var inst_121391 = cljs.core.apply.call(null,cljs.core.hash_map,inst_121373);
var state_121474__$1 = state_121474;
var statearr_121537_121600 = state_121474__$1;
(statearr_121537_121600[(2)] = inst_121391);

(statearr_121537_121600[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (16))){
var inst_121337 = (state_121474[(22)]);
var inst_121348 = (state_121474[(15)]);
var inst_121355 = cljs.core.async.put_BANG_.call(null,inst_121348,inst_121337);
var state_121474__$1 = state_121474;
var statearr_121538_121601 = state_121474__$1;
(statearr_121538_121601[(2)] = inst_121355);

(statearr_121538_121601[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (38))){
var inst_121461 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121539_121602 = state_121474__$1;
(statearr_121539_121602[(2)] = inst_121461);

(statearr_121539_121602[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (30))){
var state_121474__$1 = state_121474;
var statearr_121540_121603 = state_121474__$1;
(statearr_121540_121603[(2)] = null);

(statearr_121540_121603[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (10))){
var inst_121335 = (state_121474[(9)]);
var state_121474__$1 = state_121474;
var statearr_121541_121604 = state_121474__$1;
(statearr_121541_121604[(2)] = inst_121335);

(statearr_121541_121604[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (18))){
var inst_121361 = (state_121474[(2)]);
var state_121474__$1 = state_121474;
var statearr_121542_121605 = state_121474__$1;
(statearr_121542_121605[(2)] = inst_121361);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (42))){
var inst_121441 = (state_121474[(14)]);
var inst_121454 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_121441);
var state_121474__$1 = state_121474;
var statearr_121543_121606 = state_121474__$1;
(statearr_121543_121606[(2)] = inst_121454);

(statearr_121543_121606[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (37))){
var inst_121441 = (state_121474[(14)]);
var inst_121449 = (inst_121441 == null);
var state_121474__$1 = state_121474;
if(cljs.core.truth_(inst_121449)){
var statearr_121544_121607 = state_121474__$1;
(statearr_121544_121607[(1)] = (39));

} else {
var statearr_121545_121608 = state_121474__$1;
(statearr_121545_121608[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121475 === (8))){
var inst_121332 = (state_121474[(8)]);
var inst_121465 = (state_121474[(2)]);
var inst_121466 = (inst_121332 + (1));
var inst_121332__$1 = inst_121466;
var state_121474__$1 = (function (){var statearr_121546 = state_121474;
(statearr_121546[(25)] = inst_121465);

(statearr_121546[(8)] = inst_121332__$1);

return statearr_121546;
})();
var statearr_121547_121609 = state_121474__$1;
(statearr_121547_121609[(2)] = null);

(statearr_121547_121609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__99975__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__99975__auto____0 = (function (){
var statearr_121548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121548[(0)] = fluree$db$connection$msg_producer_$_state_machine__99975__auto__);

(statearr_121548[(1)] = (1));

return statearr_121548;
});
var fluree$db$connection$msg_producer_$_state_machine__99975__auto____1 = (function (state_121474){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121549){if((e121549 instanceof Object)){
var ex__99978__auto__ = e121549;
var statearr_121550_121610 = state_121474;
(statearr_121550_121610[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121549;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121611 = state_121474;
state_121474 = G__121611;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__99975__auto__ = function(state_121474){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__99975__auto____1.call(this,state_121474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__99975__auto____0;
fluree$db$connection$msg_producer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__99975__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121551 = f__100070__auto__.call(null);
(statearr_121551[(6)] = c__100069__auto__);

return statearr_121551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__121612 = conn;
var map__121612__$1 = (((((!((map__121612 == null))))?(((((map__121612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__121612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__121612):map__121612);
var sub_chan = cljs.core.get.call(null,map__121612__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121695){
var state_val_121696 = (state_121695[(1)]);
if((state_val_121696 === (7))){
var inst_121691 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121697_121747 = state_121695__$1;
(statearr_121697_121747[(2)] = inst_121691);

(statearr_121697_121747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (20))){
var inst_121632 = (state_121695[(7)]);
var inst_121646 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_121647 = [inst_121632];
var inst_121648 = cljs.core.PersistentHashMap.fromArrays(inst_121646,inst_121647);
var inst_121649 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_121648);
var state_121695__$1 = state_121695;
var statearr_121698_121748 = state_121695__$1;
(statearr_121698_121748[(2)] = inst_121649);

(statearr_121698_121748[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (27))){
var state_121695__$1 = state_121695;
var statearr_121699_121749 = state_121695__$1;
(statearr_121699_121749[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (1))){
var inst_121614 = (0);
var state_121695__$1 = (function (){var statearr_121701 = state_121695;
(statearr_121701[(8)] = inst_121614);

return statearr_121701;
})();
var statearr_121702_121750 = state_121695__$1;
(statearr_121702_121750[(2)] = null);

(statearr_121702_121750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (24))){
var inst_121625 = (state_121695[(9)]);
var inst_121674 = fluree.db.util.core.exception_QMARK_.call(null,inst_121625);
var state_121695__$1 = state_121695;
if(inst_121674){
var statearr_121703_121751 = state_121695__$1;
(statearr_121703_121751[(1)] = (26));

} else {
var statearr_121704_121752 = state_121695__$1;
(statearr_121704_121752[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (4))){
var inst_121619 = (state_121695[(10)]);
var inst_121624 = (state_121695[(2)]);
var inst_121625 = cljs.core.nth.call(null,inst_121624,(0),null);
var inst_121626 = cljs.core.nth.call(null,inst_121624,(1),null);
var inst_121627 = cljs.core._EQ_.call(null,inst_121626,inst_121619);
var state_121695__$1 = (function (){var statearr_121705 = state_121695;
(statearr_121705[(9)] = inst_121625);

return statearr_121705;
})();
if(inst_121627){
var statearr_121706_121753 = state_121695__$1;
(statearr_121706_121753[(1)] = (5));

} else {
var statearr_121707_121754 = state_121695__$1;
(statearr_121707_121754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (15))){
var inst_121632 = (state_121695[(7)]);
var inst_121641 = typeof inst_121632 === 'string';
var state_121695__$1 = state_121695;
if(cljs.core.truth_(inst_121641)){
var statearr_121708_121755 = state_121695__$1;
(statearr_121708_121755[(1)] = (17));

} else {
var statearr_121709_121756 = state_121695__$1;
(statearr_121709_121756[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (21))){
var state_121695__$1 = state_121695;
var statearr_121710_121757 = state_121695__$1;
(statearr_121710_121757[(2)] = null);

(statearr_121710_121757[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (31))){
var inst_121685 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121711_121758 = state_121695__$1;
(statearr_121711_121758[(2)] = inst_121685);

(statearr_121711_121758[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (13))){
var inst_121658 = (state_121695[(2)]);
var inst_121659 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121660 = fluree.db.connection.close_websocket.call(null,inst_121659);
var inst_121661 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121662 = fluree.db.session.close_all_sessions.call(null,inst_121661);
var state_121695__$1 = (function (){var statearr_121712 = state_121695;
(statearr_121712[(11)] = inst_121658);

(statearr_121712[(12)] = inst_121660);

return statearr_121712;
})();
var statearr_121713_121759 = state_121695__$1;
(statearr_121713_121759[(2)] = inst_121662);

(statearr_121713_121759[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (22))){
var inst_121652 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121714_121760 = state_121695__$1;
(statearr_121714_121760[(2)] = inst_121652);

(statearr_121714_121760[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (29))){
var inst_121625 = (state_121695[(9)]);
var inst_121680 = fluree.db.util.json.parse.call(null,inst_121625);
var inst_121681 = fluree.db.connection.process_events.call(null,conn,inst_121680);
var inst_121614 = (0);
var state_121695__$1 = (function (){var statearr_121715 = state_121695;
(statearr_121715[(8)] = inst_121614);

(statearr_121715[(13)] = inst_121681);

return statearr_121715;
})();
var statearr_121716_121761 = state_121695__$1;
(statearr_121716_121761[(2)] = null);

(statearr_121716_121761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (6))){
var inst_121625 = (state_121695[(9)]);
var inst_121670 = (inst_121625 == null);
var state_121695__$1 = state_121695;
if(cljs.core.truth_(inst_121670)){
var statearr_121717_121762 = state_121695__$1;
(statearr_121717_121762[(1)] = (23));

} else {
var statearr_121718_121763 = state_121695__$1;
(statearr_121718_121763[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (28))){
var inst_121687 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121719_121764 = state_121695__$1;
(statearr_121719_121764[(2)] = inst_121687);

(statearr_121719_121764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (25))){
var inst_121689 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121720_121765 = state_121695__$1;
(statearr_121720_121765[(2)] = inst_121689);

(statearr_121720_121765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (17))){
var inst_121632 = (state_121695[(7)]);
var inst_121643 = cljs.core.eval.call(null,inst_121632);
var state_121695__$1 = state_121695;
var statearr_121721_121766 = state_121695__$1;
(statearr_121721_121766[(2)] = inst_121643);

(statearr_121721_121766[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (3))){
var inst_121693 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121695__$1,inst_121693);
} else {
if((state_val_121696 === (12))){
var inst_121632 = (state_121695[(7)]);
var inst_121637 = cljs.core.fn_QMARK_.call(null,inst_121632);
var state_121695__$1 = state_121695;
if(inst_121637){
var statearr_121722_121767 = state_121695__$1;
(statearr_121722_121767[(1)] = (14));

} else {
var statearr_121723_121768 = state_121695__$1;
(statearr_121723_121768[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (2))){
var inst_121619 = (state_121695[(10)]);
var inst_121619__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_121620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121621 = [sub_chan,inst_121619__$1];
var inst_121622 = (new cljs.core.PersistentVector(null,2,(5),inst_121620,inst_121621,null));
var state_121695__$1 = (function (){var statearr_121724 = state_121695;
(statearr_121724[(10)] = inst_121619__$1);

return statearr_121724;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_121695__$1,(4),inst_121622);
} else {
if((state_val_121696 === (23))){
var inst_121672 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_121695__$1 = state_121695;
var statearr_121725_121769 = state_121695__$1;
(statearr_121725_121769[(2)] = inst_121672);

(statearr_121725_121769[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (19))){
var inst_121654 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121726_121770 = state_121695__$1;
(statearr_121726_121770[(2)] = inst_121654);

(statearr_121726_121770[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (11))){
var inst_121635 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_121695__$1 = state_121695;
var statearr_121727_121771 = state_121695__$1;
(statearr_121727_121771[(2)] = inst_121635);

(statearr_121727_121771[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (9))){
var inst_121614 = (state_121695[(8)]);
var inst_121664 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_121665 = (inst_121614 + (1));
var inst_121614__$1 = inst_121665;
var state_121695__$1 = (function (){var statearr_121728 = state_121695;
(statearr_121728[(14)] = inst_121664);

(statearr_121728[(8)] = inst_121614__$1);

return statearr_121728;
})();
var statearr_121729_121772 = state_121695__$1;
(statearr_121729_121772[(2)] = null);

(statearr_121729_121772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (5))){
var inst_121614 = (state_121695[(8)]);
var inst_121629 = cljs.core._EQ_.call(null,(2),inst_121614);
var state_121695__$1 = state_121695;
if(inst_121629){
var statearr_121730_121773 = state_121695__$1;
(statearr_121730_121773[(1)] = (8));

} else {
var statearr_121731_121774 = state_121695__$1;
(statearr_121731_121774[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (14))){
var inst_121632 = (state_121695[(7)]);
var inst_121639 = inst_121632.call(null);
var state_121695__$1 = state_121695;
var statearr_121732_121775 = state_121695__$1;
(statearr_121732_121775[(2)] = inst_121639);

(statearr_121732_121775[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (26))){
var inst_121625 = (state_121695[(9)]);
var inst_121676 = fluree.db.util.log.error.call(null,inst_121625);
var inst_121614 = (0);
var state_121695__$1 = (function (){var statearr_121733 = state_121695;
(statearr_121733[(8)] = inst_121614);

(statearr_121733[(15)] = inst_121676);

return statearr_121733;
})();
var statearr_121734_121776 = state_121695__$1;
(statearr_121734_121776[(2)] = null);

(statearr_121734_121776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (16))){
var inst_121656 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121735_121777 = state_121695__$1;
(statearr_121735_121777[(2)] = inst_121656);

(statearr_121735_121777[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (30))){
var state_121695__$1 = state_121695;
var statearr_121736_121778 = state_121695__$1;
(statearr_121736_121778[(2)] = null);

(statearr_121736_121778[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (10))){
var inst_121668 = (state_121695[(2)]);
var state_121695__$1 = state_121695;
var statearr_121737_121779 = state_121695__$1;
(statearr_121737_121779[(2)] = inst_121668);

(statearr_121737_121779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (18))){
var state_121695__$1 = state_121695;
var statearr_121738_121780 = state_121695__$1;
(statearr_121738_121780[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121696 === (8))){
var inst_121632 = (state_121695[(7)]);
var inst_121631 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_121632__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121633 = (inst_121632__$1 == null);
var state_121695__$1 = (function (){var statearr_121740 = state_121695;
(statearr_121740[(7)] = inst_121632__$1);

(statearr_121740[(16)] = inst_121631);

return statearr_121740;
})();
if(cljs.core.truth_(inst_121633)){
var statearr_121741_121781 = state_121695__$1;
(statearr_121741_121781[(1)] = (11));

} else {
var statearr_121742_121782 = state_121695__$1;
(statearr_121742_121782[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__99975__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__99975__auto____0 = (function (){
var statearr_121743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121743[(0)] = fluree$db$connection$msg_consumer_$_state_machine__99975__auto__);

(statearr_121743[(1)] = (1));

return statearr_121743;
});
var fluree$db$connection$msg_consumer_$_state_machine__99975__auto____1 = (function (state_121695){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121744){if((e121744 instanceof Object)){
var ex__99978__auto__ = e121744;
var statearr_121745_121783 = state_121695;
(statearr_121745_121783[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121744;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121784 = state_121695;
state_121695 = G__121784;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__99975__auto__ = function(state_121695){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__99975__auto____1.call(this,state_121695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__99975__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__99975__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121746 = f__100070__auto__.call(null);
(statearr_121746[(6)] = c__100069__auto__);

return statearr_121746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__121786 = arguments.length;
switch (G__121786) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__121787 = opts;
var map__121787__$1 = (((((!((map__121787 == null))))?(((((map__121787.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__121787.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__121787):map__121787);
var private$ = cljs.core.get.call(null,map__121787__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__121787__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121846){
var state_val_121847 = (state_121846[(1)]);
if((state_val_121847 === (7))){
var inst_121801 = (state_121846[(2)]);
var inst_121802 = clojure.string.replace.call(null,k,"_","/");
var inst_121803 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_121846__$1 = (function (){var statearr_121848 = state_121846;
(statearr_121848[(7)] = inst_121802);

(statearr_121848[(8)] = inst_121801);

return statearr_121848;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121846__$1,(8),inst_121803);
} else {
if((state_val_121847 === (20))){
var inst_121806 = (state_121846[(9)]);
var inst_121835 = (state_121846[(2)]);
var inst_121836 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_121837 = [(5000),inst_121835,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_121838 = cljs.core.PersistentHashMap.fromArrays(inst_121836,inst_121837);
var inst_121839 = fluree.db.util.xhttp.get.call(null,inst_121806,inst_121838);
var state_121846__$1 = state_121846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121846__$1,(21),inst_121839);
} else {
if((state_val_121847 === (1))){
var state_121846__$1 = state_121846;
var statearr_121849_121881 = state_121846__$1;
(statearr_121849_121881[(2)] = null);

(statearr_121849_121881[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_121846,(3),Error,null,(2));
var state_121846__$1 = state_121846;
if(cljs.core.truth_(jwt)){
var statearr_121850_121882 = state_121846__$1;
(statearr_121850_121882[(1)] = (5));

} else {
var statearr_121851_121883 = state_121846__$1;
(statearr_121851_121883[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (15))){
var inst_121820 = (state_121846[(10)]);
var inst_121801 = (state_121846[(8)]);
var inst_121822 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_121801)].join('');
var inst_121823 = cljs.core.assoc.call(null,inst_121820,"Authorization",inst_121822);
var state_121846__$1 = state_121846;
var statearr_121852_121884 = state_121846__$1;
(statearr_121852_121884[(2)] = inst_121823);

(statearr_121852_121884[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (21))){
var inst_121841 = (state_121846[(2)]);
var inst_121842 = fluree.db.util.async.throw_err.call(null,inst_121841);
var state_121846__$1 = state_121846;
var statearr_121853_121885 = state_121846__$1;
(statearr_121853_121885[(2)] = inst_121842);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121846__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (13))){
var inst_121815 = (state_121846[(11)]);
var state_121846__$1 = state_121846;
var statearr_121854_121886 = state_121846__$1;
(statearr_121854_121886[(2)] = inst_121815);

(statearr_121854_121886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (6))){
var inst_121795 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_121796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121797 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_121798 = (new cljs.core.PersistentVector(null,2,(5),inst_121796,inst_121797,null));
var inst_121799 = cljs.core.get_in.call(null,inst_121795,inst_121798);
var state_121846__$1 = state_121846;
var statearr_121855_121887 = state_121846__$1;
(statearr_121855_121887[(2)] = inst_121799);

(statearr_121855_121887[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (17))){
var inst_121826 = (state_121846[(2)]);
var state_121846__$1 = (function (){var statearr_121856 = state_121846;
(statearr_121856[(12)] = inst_121826);

return statearr_121856;
})();
if(cljs.core.truth_(private$)){
var statearr_121857_121888 = state_121846__$1;
(statearr_121857_121888[(1)] = (18));

} else {
var statearr_121858_121889 = state_121846__$1;
(statearr_121858_121889[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (3))){
var inst_121789 = (state_121846[(2)]);
var state_121846__$1 = state_121846;
var statearr_121859_121890 = state_121846__$1;
(statearr_121859_121890[(2)] = inst_121789);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121846__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (12))){
var inst_121815 = (state_121846[(11)]);
var inst_121801 = (state_121846[(8)]);
var inst_121817 = cljs.core.assoc.call(null,inst_121815,"X-fdb-jwt",inst_121801);
var state_121846__$1 = state_121846;
var statearr_121860_121891 = state_121846__$1;
(statearr_121860_121891[(2)] = inst_121817);

(statearr_121860_121891[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (2))){
var inst_121844 = (state_121846[(2)]);
var state_121846__$1 = state_121846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121846__$1,inst_121844);
} else {
if((state_val_121847 === (19))){
var inst_121826 = (state_121846[(12)]);
var state_121846__$1 = state_121846;
var statearr_121861_121892 = state_121846__$1;
(statearr_121861_121892[(2)] = inst_121826);

(statearr_121861_121892[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (11))){
var inst_121801 = (state_121846[(8)]);
var inst_121815 = (state_121846[(2)]);
var state_121846__$1 = (function (){var statearr_121862 = state_121846;
(statearr_121862[(11)] = inst_121815);

return statearr_121862;
})();
if(cljs.core.truth_(inst_121801)){
var statearr_121863_121893 = state_121846__$1;
(statearr_121863_121893[(1)] = (12));

} else {
var statearr_121864_121894 = state_121846__$1;
(statearr_121864_121894[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (9))){
var inst_121810 = (state_121846[(13)]);
var inst_121812 = cljs.core.assoc.call(null,inst_121810,"X-fdb-pri",private$);
var state_121846__$1 = state_121846;
var statearr_121865_121895 = state_121846__$1;
(statearr_121865_121895[(2)] = inst_121812);

(statearr_121865_121895[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (5))){
var state_121846__$1 = state_121846;
var statearr_121866_121896 = state_121846__$1;
(statearr_121866_121896[(2)] = jwt);

(statearr_121866_121896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (14))){
var inst_121801 = (state_121846[(8)]);
var inst_121820 = (state_121846[(2)]);
var state_121846__$1 = (function (){var statearr_121867 = state_121846;
(statearr_121867[(10)] = inst_121820);

return statearr_121867;
})();
if(cljs.core.truth_(inst_121801)){
var statearr_121868_121897 = state_121846__$1;
(statearr_121868_121897[(1)] = (15));

} else {
var statearr_121869_121898 = state_121846__$1;
(statearr_121869_121898[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (16))){
var inst_121820 = (state_121846[(10)]);
var state_121846__$1 = state_121846;
var statearr_121870_121899 = state_121846__$1;
(statearr_121870_121899[(2)] = inst_121820);

(statearr_121870_121899[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (10))){
var inst_121810 = (state_121846[(13)]);
var state_121846__$1 = state_121846;
var statearr_121871_121900 = state_121846__$1;
(statearr_121871_121900[(2)] = inst_121810);

(statearr_121871_121900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (18))){
var inst_121826 = (state_121846[(12)]);
var inst_121806 = (state_121846[(9)]);
var inst_121828 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_121829 = [inst_121826];
var inst_121830 = cljs.core.PersistentHashMap.fromArrays(inst_121828,inst_121829);
var inst_121831 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_121806,inst_121830,private$);
var inst_121832 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_121831);
var state_121846__$1 = state_121846;
var statearr_121872_121901 = state_121846__$1;
(statearr_121872_121901[(2)] = inst_121832);

(statearr_121872_121901[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121847 === (8))){
var inst_121802 = (state_121846[(7)]);
var inst_121805 = (state_121846[(2)]);
var inst_121806 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_121805),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_121802)].join('');
var inst_121808 = ["Accept"];
var inst_121809 = ["application/json"];
var inst_121810 = cljs.core.PersistentHashMap.fromArrays(inst_121808,inst_121809);
var state_121846__$1 = (function (){var statearr_121873 = state_121846;
(statearr_121873[(13)] = inst_121810);

(statearr_121873[(9)] = inst_121806);

return statearr_121873;
})();
if(cljs.core.truth_(private$)){
var statearr_121874_121902 = state_121846__$1;
(statearr_121874_121902[(1)] = (9));

} else {
var statearr_121875_121903 = state_121846__$1;
(statearr_121875_121903[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__99975__auto__ = null;
var fluree$db$connection$state_machine__99975__auto____0 = (function (){
var statearr_121876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121876[(0)] = fluree$db$connection$state_machine__99975__auto__);

(statearr_121876[(1)] = (1));

return statearr_121876;
});
var fluree$db$connection$state_machine__99975__auto____1 = (function (state_121846){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121877){if((e121877 instanceof Object)){
var ex__99978__auto__ = e121877;
var statearr_121878_121904 = state_121846;
(statearr_121878_121904[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121846);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121905 = state_121846;
state_121846 = G__121905;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$state_machine__99975__auto__ = function(state_121846){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__99975__auto____1.call(this,state_121846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__99975__auto____0;
fluree$db$connection$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__99975__auto____1;
return fluree$db$connection$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121879 = f__100070__auto__.call(null);
(statearr_121879[(6)] = c__100069__auto__);

return statearr_121879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn_state){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,conn_state));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__121906_SHARP_){
if(cljs.core.truth_(p1__121906_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__121907 = opts;
var map__121907__$1 = (((((!((map__121907 == null))))?(((((map__121907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__121907.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__121907):map__121907);
var sub_chan = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__121907__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e121909){var _ = e121909;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___121941 = arguments.length;
var i__4737__auto___121942 = (0);
while(true){
if((i__4737__auto___121942 < len__4736__auto___121941)){
args__4742__auto__.push((arguments[i__4737__auto___121942]));

var G__121943 = (i__4737__auto___121942 + (1));
i__4737__auto___121942 = G__121943;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__121912){
var vec__121913 = p__121912;
var opts = cljs.core.nth.call(null,vec__121913,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__100069__auto___121944 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_121930){
var state_val_121931 = (state_121930[(1)]);
if((state_val_121931 === (1))){
var inst_121916 = fluree.db.connection.get_socket.call(null,conn);
var state_121930__$1 = state_121930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_121930__$1,(2),inst_121916);
} else {
if((state_val_121931 === (2))){
var inst_121918 = (state_121930[(2)]);
var inst_121919 = (inst_121918 == null);
var inst_121920 = fluree.db.util.core.exception_QMARK_.call(null,inst_121918);
var inst_121921 = ((inst_121919) || (inst_121920));
var state_121930__$1 = state_121930;
if(cljs.core.truth_(inst_121921)){
var statearr_121932_121945 = state_121930__$1;
(statearr_121932_121945[(1)] = (3));

} else {
var statearr_121933_121946 = state_121930__$1;
(statearr_121933_121946[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121931 === (3))){
var inst_121923 = fluree.db.util.log.warn.call(null,"Cannot establish connection to a healthy server, disconnecting.");
var inst_121924 = cljs.core.async.close_BANG_.call(null,conn);
var state_121930__$1 = (function (){var statearr_121934 = state_121930;
(statearr_121934[(7)] = inst_121923);

return statearr_121934;
})();
var statearr_121935_121947 = state_121930__$1;
(statearr_121935_121947[(2)] = inst_121924);

(statearr_121935_121947[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121931 === (4))){
var inst_121926 = fluree.db.connection.msg_consumer.call(null,conn);
var state_121930__$1 = state_121930;
var statearr_121936_121948 = state_121930__$1;
(statearr_121936_121948[(2)] = inst_121926);

(statearr_121936_121948[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_121931 === (5))){
var inst_121928 = (state_121930[(2)]);
var state_121930__$1 = state_121930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_121930__$1,inst_121928);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__99975__auto__ = null;
var fluree$db$connection$state_machine__99975__auto____0 = (function (){
var statearr_121937 = [null,null,null,null,null,null,null,null];
(statearr_121937[(0)] = fluree$db$connection$state_machine__99975__auto__);

(statearr_121937[(1)] = (1));

return statearr_121937;
});
var fluree$db$connection$state_machine__99975__auto____1 = (function (state_121930){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_121930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e121938){if((e121938 instanceof Object)){
var ex__99978__auto__ = e121938;
var statearr_121939_121949 = state_121930;
(statearr_121939_121949[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_121930);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e121938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__121950 = state_121930;
state_121930 = G__121950;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection$state_machine__99975__auto__ = function(state_121930){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__99975__auto____1.call(this,state_121930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__99975__auto____0;
fluree$db$connection$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__99975__auto____1;
return fluree$db$connection$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_121940 = f__100070__auto__.call(null);
(statearr_121940[(6)] = c__100069__auto___121944);

return statearr_121940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq121910){
var G__121911 = cljs.core.first.call(null,seq121910);
var seq121910__$1 = cljs.core.next.call(null,seq121910);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__121911,seq121910__$1);
}));

