// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__100129 = arguments.length;
switch (G__100129) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100130 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100130 = (function (f,blockable,meta100131){
this.f = f;
this.blockable = blockable;
this.meta100131 = meta100131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100132,meta100131__$1){
var self__ = this;
var _100132__$1 = this;
return (new cljs.core.async.t_cljs$core$async100130(self__.f,self__.blockable,meta100131__$1));
}));

(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100132){
var self__ = this;
var _100132__$1 = this;
return self__.meta100131;
}));

(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async100130.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async100130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta100131","meta100131",-231460621,null)], null);
}));

(cljs.core.async.t_cljs$core$async100130.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100130");

(cljs.core.async.t_cljs$core$async100130.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async100130");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100130.
 */
cljs.core.async.__GT_t_cljs$core$async100130 = (function cljs$core$async$__GT_t_cljs$core$async100130(f__$1,blockable__$1,meta100131){
return (new cljs.core.async.t_cljs$core$async100130(f__$1,blockable__$1,meta100131));
});

}

return (new cljs.core.async.t_cljs$core$async100130(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__100136 = arguments.length;
switch (G__100136) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__100139 = arguments.length;
switch (G__100139) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__100142 = arguments.length;
switch (G__100142) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_100144 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_100144);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_100144);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__100146 = arguments.length;
switch (G__100146) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___100148 = n;
var x_100149 = (0);
while(true){
if((x_100149 < n__4613__auto___100148)){
(a[x_100149] = (0));

var G__100150 = (x_100149 + (1));
x_100149 = G__100150;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__100151 = (i + (1));
i = G__100151;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100152 = (function (flag,meta100153){
this.flag = flag;
this.meta100153 = meta100153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100154,meta100153__$1){
var self__ = this;
var _100154__$1 = this;
return (new cljs.core.async.t_cljs$core$async100152(self__.flag,meta100153__$1));
}));

(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100154){
var self__ = this;
var _100154__$1 = this;
return self__.meta100153;
}));

(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100152.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async100152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta100153","meta100153",-587484222,null)], null);
}));

(cljs.core.async.t_cljs$core$async100152.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100152.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100152");

(cljs.core.async.t_cljs$core$async100152.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async100152");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100152.
 */
cljs.core.async.__GT_t_cljs$core$async100152 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async100152(flag__$1,meta100153){
return (new cljs.core.async.t_cljs$core$async100152(flag__$1,meta100153));
});

}

return (new cljs.core.async.t_cljs$core$async100152(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100155 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100155 = (function (flag,cb,meta100156){
this.flag = flag;
this.cb = cb;
this.meta100156 = meta100156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100157,meta100156__$1){
var self__ = this;
var _100157__$1 = this;
return (new cljs.core.async.t_cljs$core$async100155(self__.flag,self__.cb,meta100156__$1));
}));

(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100157){
var self__ = this;
var _100157__$1 = this;
return self__.meta100156;
}));

(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async100155.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async100155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta100156","meta100156",-1924039437,null)], null);
}));

(cljs.core.async.t_cljs$core$async100155.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100155");

(cljs.core.async.t_cljs$core$async100155.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async100155");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100155.
 */
cljs.core.async.__GT_t_cljs$core$async100155 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async100155(flag__$1,cb__$1,meta100156){
return (new cljs.core.async.t_cljs$core$async100155(flag__$1,cb__$1,meta100156));
});

}

return (new cljs.core.async.t_cljs$core$async100155(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__100158_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__100158_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__100159_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__100159_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__100160 = (i + (1));
i = G__100160;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___100166 = arguments.length;
var i__4737__auto___100167 = (0);
while(true){
if((i__4737__auto___100167 < len__4736__auto___100166)){
args__4742__auto__.push((arguments[i__4737__auto___100167]));

var G__100168 = (i__4737__auto___100167 + (1));
i__4737__auto___100167 = G__100168;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__100163){
var map__100164 = p__100163;
var map__100164__$1 = (((((!((map__100164 == null))))?(((((map__100164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100164.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100164):map__100164);
var opts = map__100164__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq100161){
var G__100162 = cljs.core.first.call(null,seq100161);
var seq100161__$1 = cljs.core.next.call(null,seq100161);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__100162,seq100161__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__100170 = arguments.length;
switch (G__100170) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__100069__auto___100216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100194){
var state_val_100195 = (state_100194[(1)]);
if((state_val_100195 === (7))){
var inst_100190 = (state_100194[(2)]);
var state_100194__$1 = state_100194;
var statearr_100196_100217 = state_100194__$1;
(statearr_100196_100217[(2)] = inst_100190);

(statearr_100196_100217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (1))){
var state_100194__$1 = state_100194;
var statearr_100197_100218 = state_100194__$1;
(statearr_100197_100218[(2)] = null);

(statearr_100197_100218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (4))){
var inst_100173 = (state_100194[(7)]);
var inst_100173__$1 = (state_100194[(2)]);
var inst_100174 = (inst_100173__$1 == null);
var state_100194__$1 = (function (){var statearr_100198 = state_100194;
(statearr_100198[(7)] = inst_100173__$1);

return statearr_100198;
})();
if(cljs.core.truth_(inst_100174)){
var statearr_100199_100219 = state_100194__$1;
(statearr_100199_100219[(1)] = (5));

} else {
var statearr_100200_100220 = state_100194__$1;
(statearr_100200_100220[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (13))){
var state_100194__$1 = state_100194;
var statearr_100201_100221 = state_100194__$1;
(statearr_100201_100221[(2)] = null);

(statearr_100201_100221[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (6))){
var inst_100173 = (state_100194[(7)]);
var state_100194__$1 = state_100194;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100194__$1,(11),to,inst_100173);
} else {
if((state_val_100195 === (3))){
var inst_100192 = (state_100194[(2)]);
var state_100194__$1 = state_100194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100194__$1,inst_100192);
} else {
if((state_val_100195 === (12))){
var state_100194__$1 = state_100194;
var statearr_100202_100222 = state_100194__$1;
(statearr_100202_100222[(2)] = null);

(statearr_100202_100222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (2))){
var state_100194__$1 = state_100194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100194__$1,(4),from);
} else {
if((state_val_100195 === (11))){
var inst_100183 = (state_100194[(2)]);
var state_100194__$1 = state_100194;
if(cljs.core.truth_(inst_100183)){
var statearr_100203_100223 = state_100194__$1;
(statearr_100203_100223[(1)] = (12));

} else {
var statearr_100204_100224 = state_100194__$1;
(statearr_100204_100224[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (9))){
var state_100194__$1 = state_100194;
var statearr_100205_100225 = state_100194__$1;
(statearr_100205_100225[(2)] = null);

(statearr_100205_100225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (5))){
var state_100194__$1 = state_100194;
if(cljs.core.truth_(close_QMARK_)){
var statearr_100206_100226 = state_100194__$1;
(statearr_100206_100226[(1)] = (8));

} else {
var statearr_100207_100227 = state_100194__$1;
(statearr_100207_100227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (14))){
var inst_100188 = (state_100194[(2)]);
var state_100194__$1 = state_100194;
var statearr_100208_100228 = state_100194__$1;
(statearr_100208_100228[(2)] = inst_100188);

(statearr_100208_100228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (10))){
var inst_100180 = (state_100194[(2)]);
var state_100194__$1 = state_100194;
var statearr_100209_100229 = state_100194__$1;
(statearr_100209_100229[(2)] = inst_100180);

(statearr_100209_100229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100195 === (8))){
var inst_100177 = cljs.core.async.close_BANG_.call(null,to);
var state_100194__$1 = state_100194;
var statearr_100210_100230 = state_100194__$1;
(statearr_100210_100230[(2)] = inst_100177);

(statearr_100210_100230[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_100211 = [null,null,null,null,null,null,null,null];
(statearr_100211[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_100211[(1)] = (1));

return statearr_100211;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_100194){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100212){if((e100212 instanceof Object)){
var ex__99978__auto__ = e100212;
var statearr_100213_100231 = state_100194;
(statearr_100213_100231[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100194);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100212;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100232 = state_100194;
state_100194 = G__100232;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_100194){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_100194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100214 = f__100070__auto__.call(null);
(statearr_100214[(6)] = c__100069__auto___100216);

return statearr_100214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__100233){
var vec__100234 = p__100233;
var v = cljs.core.nth.call(null,vec__100234,(0),null);
var p = cljs.core.nth.call(null,vec__100234,(1),null);
var job = vec__100234;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__100069__auto___100405 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100241){
var state_val_100242 = (state_100241[(1)]);
if((state_val_100242 === (1))){
var state_100241__$1 = state_100241;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100241__$1,(2),res,v);
} else {
if((state_val_100242 === (2))){
var inst_100238 = (state_100241[(2)]);
var inst_100239 = cljs.core.async.close_BANG_.call(null,res);
var state_100241__$1 = (function (){var statearr_100243 = state_100241;
(statearr_100243[(7)] = inst_100238);

return statearr_100243;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100241__$1,inst_100239);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_100244 = [null,null,null,null,null,null,null,null];
(statearr_100244[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__);

(statearr_100244[(1)] = (1));

return statearr_100244;
});
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1 = (function (state_100241){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100245){if((e100245 instanceof Object)){
var ex__99978__auto__ = e100245;
var statearr_100246_100406 = state_100241;
(statearr_100246_100406[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100241);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100407 = state_100241;
state_100241 = G__100407;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = function(state_100241){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1.call(this,state_100241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100247 = f__100070__auto__.call(null);
(statearr_100247[(6)] = c__100069__auto___100405);

return statearr_100247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__100248){
var vec__100249 = p__100248;
var v = cljs.core.nth.call(null,vec__100249,(0),null);
var p = cljs.core.nth.call(null,vec__100249,(1),null);
var job = vec__100249;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___100408 = n;
var __100409 = (0);
while(true){
if((__100409 < n__4613__auto___100408)){
var G__100252_100410 = type;
var G__100252_100411__$1 = (((G__100252_100410 instanceof cljs.core.Keyword))?G__100252_100410.fqn:null);
switch (G__100252_100411__$1) {
case "compute":
var c__100069__auto___100413 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__100409,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = ((function (__100409,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function (state_100265){
var state_val_100266 = (state_100265[(1)]);
if((state_val_100266 === (1))){
var state_100265__$1 = state_100265;
var statearr_100267_100414 = state_100265__$1;
(statearr_100267_100414[(2)] = null);

(statearr_100267_100414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100266 === (2))){
var state_100265__$1 = state_100265;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100265__$1,(4),jobs);
} else {
if((state_val_100266 === (3))){
var inst_100263 = (state_100265[(2)]);
var state_100265__$1 = state_100265;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100265__$1,inst_100263);
} else {
if((state_val_100266 === (4))){
var inst_100255 = (state_100265[(2)]);
var inst_100256 = process.call(null,inst_100255);
var state_100265__$1 = state_100265;
if(cljs.core.truth_(inst_100256)){
var statearr_100268_100415 = state_100265__$1;
(statearr_100268_100415[(1)] = (5));

} else {
var statearr_100269_100416 = state_100265__$1;
(statearr_100269_100416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100266 === (5))){
var state_100265__$1 = state_100265;
var statearr_100270_100417 = state_100265__$1;
(statearr_100270_100417[(2)] = null);

(statearr_100270_100417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100266 === (6))){
var state_100265__$1 = state_100265;
var statearr_100271_100418 = state_100265__$1;
(statearr_100271_100418[(2)] = null);

(statearr_100271_100418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100266 === (7))){
var inst_100261 = (state_100265[(2)]);
var state_100265__$1 = state_100265;
var statearr_100272_100419 = state_100265__$1;
(statearr_100272_100419[(2)] = inst_100261);

(statearr_100272_100419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__100409,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
;
return ((function (__100409,switch__99974__auto__,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_100273 = [null,null,null,null,null,null,null];
(statearr_100273[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__);

(statearr_100273[(1)] = (1));

return statearr_100273;
});
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1 = (function (state_100265){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100274){if((e100274 instanceof Object)){
var ex__99978__auto__ = e100274;
var statearr_100275_100420 = state_100265;
(statearr_100275_100420[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100274;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100421 = state_100265;
state_100265 = G__100421;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = function(state_100265){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1.call(this,state_100265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__;
})()
;})(__100409,switch__99974__auto__,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
})();
var state__100071__auto__ = (function (){var statearr_100276 = f__100070__auto__.call(null);
(statearr_100276[(6)] = c__100069__auto___100413);

return statearr_100276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});})(__100409,c__100069__auto___100413,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
);


break;
case "async":
var c__100069__auto___100422 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__100409,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = ((function (__100409,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function (state_100289){
var state_val_100290 = (state_100289[(1)]);
if((state_val_100290 === (1))){
var state_100289__$1 = state_100289;
var statearr_100291_100423 = state_100289__$1;
(statearr_100291_100423[(2)] = null);

(statearr_100291_100423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100290 === (2))){
var state_100289__$1 = state_100289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100289__$1,(4),jobs);
} else {
if((state_val_100290 === (3))){
var inst_100287 = (state_100289[(2)]);
var state_100289__$1 = state_100289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100289__$1,inst_100287);
} else {
if((state_val_100290 === (4))){
var inst_100279 = (state_100289[(2)]);
var inst_100280 = async.call(null,inst_100279);
var state_100289__$1 = state_100289;
if(cljs.core.truth_(inst_100280)){
var statearr_100292_100424 = state_100289__$1;
(statearr_100292_100424[(1)] = (5));

} else {
var statearr_100293_100425 = state_100289__$1;
(statearr_100293_100425[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100290 === (5))){
var state_100289__$1 = state_100289;
var statearr_100294_100426 = state_100289__$1;
(statearr_100294_100426[(2)] = null);

(statearr_100294_100426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100290 === (6))){
var state_100289__$1 = state_100289;
var statearr_100295_100427 = state_100289__$1;
(statearr_100295_100427[(2)] = null);

(statearr_100295_100427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100290 === (7))){
var inst_100285 = (state_100289[(2)]);
var state_100289__$1 = state_100289;
var statearr_100296_100428 = state_100289__$1;
(statearr_100296_100428[(2)] = inst_100285);

(statearr_100296_100428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__100409,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
;
return ((function (__100409,switch__99974__auto__,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_100297 = [null,null,null,null,null,null,null];
(statearr_100297[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__);

(statearr_100297[(1)] = (1));

return statearr_100297;
});
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1 = (function (state_100289){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100298){if((e100298 instanceof Object)){
var ex__99978__auto__ = e100298;
var statearr_100299_100429 = state_100289;
(statearr_100299_100429[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100289);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100298;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100430 = state_100289;
state_100289 = G__100430;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = function(state_100289){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1.call(this,state_100289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__;
})()
;})(__100409,switch__99974__auto__,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
})();
var state__100071__auto__ = (function (){var statearr_100300 = f__100070__auto__.call(null);
(statearr_100300[(6)] = c__100069__auto___100422);

return statearr_100300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
});})(__100409,c__100069__auto___100422,G__100252_100410,G__100252_100411__$1,n__4613__auto___100408,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__100252_100411__$1)].join('')));

}

var G__100431 = (__100409 + (1));
__100409 = G__100431;
continue;
} else {
}
break;
}

var c__100069__auto___100432 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100322){
var state_val_100323 = (state_100322[(1)]);
if((state_val_100323 === (7))){
var inst_100318 = (state_100322[(2)]);
var state_100322__$1 = state_100322;
var statearr_100324_100433 = state_100322__$1;
(statearr_100324_100433[(2)] = inst_100318);

(statearr_100324_100433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100323 === (1))){
var state_100322__$1 = state_100322;
var statearr_100325_100434 = state_100322__$1;
(statearr_100325_100434[(2)] = null);

(statearr_100325_100434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100323 === (4))){
var inst_100303 = (state_100322[(7)]);
var inst_100303__$1 = (state_100322[(2)]);
var inst_100304 = (inst_100303__$1 == null);
var state_100322__$1 = (function (){var statearr_100326 = state_100322;
(statearr_100326[(7)] = inst_100303__$1);

return statearr_100326;
})();
if(cljs.core.truth_(inst_100304)){
var statearr_100327_100435 = state_100322__$1;
(statearr_100327_100435[(1)] = (5));

} else {
var statearr_100328_100436 = state_100322__$1;
(statearr_100328_100436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100323 === (6))){
var inst_100308 = (state_100322[(8)]);
var inst_100303 = (state_100322[(7)]);
var inst_100308__$1 = cljs.core.async.chan.call(null,(1));
var inst_100309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100310 = [inst_100303,inst_100308__$1];
var inst_100311 = (new cljs.core.PersistentVector(null,2,(5),inst_100309,inst_100310,null));
var state_100322__$1 = (function (){var statearr_100329 = state_100322;
(statearr_100329[(8)] = inst_100308__$1);

return statearr_100329;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100322__$1,(8),jobs,inst_100311);
} else {
if((state_val_100323 === (3))){
var inst_100320 = (state_100322[(2)]);
var state_100322__$1 = state_100322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100322__$1,inst_100320);
} else {
if((state_val_100323 === (2))){
var state_100322__$1 = state_100322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100322__$1,(4),from);
} else {
if((state_val_100323 === (9))){
var inst_100315 = (state_100322[(2)]);
var state_100322__$1 = (function (){var statearr_100330 = state_100322;
(statearr_100330[(9)] = inst_100315);

return statearr_100330;
})();
var statearr_100331_100437 = state_100322__$1;
(statearr_100331_100437[(2)] = null);

(statearr_100331_100437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100323 === (5))){
var inst_100306 = cljs.core.async.close_BANG_.call(null,jobs);
var state_100322__$1 = state_100322;
var statearr_100332_100438 = state_100322__$1;
(statearr_100332_100438[(2)] = inst_100306);

(statearr_100332_100438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100323 === (8))){
var inst_100308 = (state_100322[(8)]);
var inst_100313 = (state_100322[(2)]);
var state_100322__$1 = (function (){var statearr_100333 = state_100322;
(statearr_100333[(10)] = inst_100313);

return statearr_100333;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100322__$1,(9),results,inst_100308);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_100334 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_100334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__);

(statearr_100334[(1)] = (1));

return statearr_100334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1 = (function (state_100322){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100335){if((e100335 instanceof Object)){
var ex__99978__auto__ = e100335;
var statearr_100336_100439 = state_100322;
(statearr_100336_100439[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100440 = state_100322;
state_100322 = G__100440;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = function(state_100322){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1.call(this,state_100322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100337 = f__100070__auto__.call(null);
(statearr_100337[(6)] = c__100069__auto___100432);

return statearr_100337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100375){
var state_val_100376 = (state_100375[(1)]);
if((state_val_100376 === (7))){
var inst_100371 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
var statearr_100377_100441 = state_100375__$1;
(statearr_100377_100441[(2)] = inst_100371);

(statearr_100377_100441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (20))){
var state_100375__$1 = state_100375;
var statearr_100378_100442 = state_100375__$1;
(statearr_100378_100442[(2)] = null);

(statearr_100378_100442[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (1))){
var state_100375__$1 = state_100375;
var statearr_100379_100443 = state_100375__$1;
(statearr_100379_100443[(2)] = null);

(statearr_100379_100443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (4))){
var inst_100340 = (state_100375[(7)]);
var inst_100340__$1 = (state_100375[(2)]);
var inst_100341 = (inst_100340__$1 == null);
var state_100375__$1 = (function (){var statearr_100380 = state_100375;
(statearr_100380[(7)] = inst_100340__$1);

return statearr_100380;
})();
if(cljs.core.truth_(inst_100341)){
var statearr_100381_100444 = state_100375__$1;
(statearr_100381_100444[(1)] = (5));

} else {
var statearr_100382_100445 = state_100375__$1;
(statearr_100382_100445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (15))){
var inst_100353 = (state_100375[(8)]);
var state_100375__$1 = state_100375;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100375__$1,(18),to,inst_100353);
} else {
if((state_val_100376 === (21))){
var inst_100366 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
var statearr_100383_100446 = state_100375__$1;
(statearr_100383_100446[(2)] = inst_100366);

(statearr_100383_100446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (13))){
var inst_100368 = (state_100375[(2)]);
var state_100375__$1 = (function (){var statearr_100384 = state_100375;
(statearr_100384[(9)] = inst_100368);

return statearr_100384;
})();
var statearr_100385_100447 = state_100375__$1;
(statearr_100385_100447[(2)] = null);

(statearr_100385_100447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (6))){
var inst_100340 = (state_100375[(7)]);
var state_100375__$1 = state_100375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100375__$1,(11),inst_100340);
} else {
if((state_val_100376 === (17))){
var inst_100361 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
if(cljs.core.truth_(inst_100361)){
var statearr_100386_100448 = state_100375__$1;
(statearr_100386_100448[(1)] = (19));

} else {
var statearr_100387_100449 = state_100375__$1;
(statearr_100387_100449[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (3))){
var inst_100373 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100375__$1,inst_100373);
} else {
if((state_val_100376 === (12))){
var inst_100350 = (state_100375[(10)]);
var state_100375__$1 = state_100375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100375__$1,(14),inst_100350);
} else {
if((state_val_100376 === (2))){
var state_100375__$1 = state_100375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100375__$1,(4),results);
} else {
if((state_val_100376 === (19))){
var state_100375__$1 = state_100375;
var statearr_100388_100450 = state_100375__$1;
(statearr_100388_100450[(2)] = null);

(statearr_100388_100450[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (11))){
var inst_100350 = (state_100375[(2)]);
var state_100375__$1 = (function (){var statearr_100389 = state_100375;
(statearr_100389[(10)] = inst_100350);

return statearr_100389;
})();
var statearr_100390_100451 = state_100375__$1;
(statearr_100390_100451[(2)] = null);

(statearr_100390_100451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (9))){
var state_100375__$1 = state_100375;
var statearr_100391_100452 = state_100375__$1;
(statearr_100391_100452[(2)] = null);

(statearr_100391_100452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (5))){
var state_100375__$1 = state_100375;
if(cljs.core.truth_(close_QMARK_)){
var statearr_100392_100453 = state_100375__$1;
(statearr_100392_100453[(1)] = (8));

} else {
var statearr_100393_100454 = state_100375__$1;
(statearr_100393_100454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (14))){
var inst_100353 = (state_100375[(8)]);
var inst_100353__$1 = (state_100375[(2)]);
var inst_100354 = (inst_100353__$1 == null);
var inst_100355 = cljs.core.not.call(null,inst_100354);
var state_100375__$1 = (function (){var statearr_100394 = state_100375;
(statearr_100394[(8)] = inst_100353__$1);

return statearr_100394;
})();
if(inst_100355){
var statearr_100395_100455 = state_100375__$1;
(statearr_100395_100455[(1)] = (15));

} else {
var statearr_100396_100456 = state_100375__$1;
(statearr_100396_100456[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (16))){
var state_100375__$1 = state_100375;
var statearr_100397_100457 = state_100375__$1;
(statearr_100397_100457[(2)] = false);

(statearr_100397_100457[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (10))){
var inst_100347 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
var statearr_100398_100458 = state_100375__$1;
(statearr_100398_100458[(2)] = inst_100347);

(statearr_100398_100458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (18))){
var inst_100358 = (state_100375[(2)]);
var state_100375__$1 = state_100375;
var statearr_100399_100459 = state_100375__$1;
(statearr_100399_100459[(2)] = inst_100358);

(statearr_100399_100459[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100376 === (8))){
var inst_100344 = cljs.core.async.close_BANG_.call(null,to);
var state_100375__$1 = state_100375;
var statearr_100400_100460 = state_100375__$1;
(statearr_100400_100460[(2)] = inst_100344);

(statearr_100400_100460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_100401 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_100401[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__);

(statearr_100401[(1)] = (1));

return statearr_100401;
});
var cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1 = (function (state_100375){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100402){if((e100402 instanceof Object)){
var ex__99978__auto__ = e100402;
var statearr_100403_100461 = state_100375;
(statearr_100403_100461[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100375);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100462 = state_100375;
state_100375 = G__100462;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__ = function(state_100375){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1.call(this,state_100375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100404 = f__100070__auto__.call(null);
(statearr_100404[(6)] = c__100069__auto__);

return statearr_100404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__100464 = arguments.length;
switch (G__100464) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__100467 = arguments.length;
switch (G__100467) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__100470 = arguments.length;
switch (G__100470) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__100069__auto___100519 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100496){
var state_val_100497 = (state_100496[(1)]);
if((state_val_100497 === (7))){
var inst_100492 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
var statearr_100498_100520 = state_100496__$1;
(statearr_100498_100520[(2)] = inst_100492);

(statearr_100498_100520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (1))){
var state_100496__$1 = state_100496;
var statearr_100499_100521 = state_100496__$1;
(statearr_100499_100521[(2)] = null);

(statearr_100499_100521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (4))){
var inst_100473 = (state_100496[(7)]);
var inst_100473__$1 = (state_100496[(2)]);
var inst_100474 = (inst_100473__$1 == null);
var state_100496__$1 = (function (){var statearr_100500 = state_100496;
(statearr_100500[(7)] = inst_100473__$1);

return statearr_100500;
})();
if(cljs.core.truth_(inst_100474)){
var statearr_100501_100522 = state_100496__$1;
(statearr_100501_100522[(1)] = (5));

} else {
var statearr_100502_100523 = state_100496__$1;
(statearr_100502_100523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (13))){
var state_100496__$1 = state_100496;
var statearr_100503_100524 = state_100496__$1;
(statearr_100503_100524[(2)] = null);

(statearr_100503_100524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (6))){
var inst_100473 = (state_100496[(7)]);
var inst_100479 = p.call(null,inst_100473);
var state_100496__$1 = state_100496;
if(cljs.core.truth_(inst_100479)){
var statearr_100504_100525 = state_100496__$1;
(statearr_100504_100525[(1)] = (9));

} else {
var statearr_100505_100526 = state_100496__$1;
(statearr_100505_100526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (3))){
var inst_100494 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100496__$1,inst_100494);
} else {
if((state_val_100497 === (12))){
var state_100496__$1 = state_100496;
var statearr_100506_100527 = state_100496__$1;
(statearr_100506_100527[(2)] = null);

(statearr_100506_100527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (2))){
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100496__$1,(4),ch);
} else {
if((state_val_100497 === (11))){
var inst_100473 = (state_100496[(7)]);
var inst_100483 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100496__$1,(8),inst_100483,inst_100473);
} else {
if((state_val_100497 === (9))){
var state_100496__$1 = state_100496;
var statearr_100507_100528 = state_100496__$1;
(statearr_100507_100528[(2)] = tc);

(statearr_100507_100528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (5))){
var inst_100476 = cljs.core.async.close_BANG_.call(null,tc);
var inst_100477 = cljs.core.async.close_BANG_.call(null,fc);
var state_100496__$1 = (function (){var statearr_100508 = state_100496;
(statearr_100508[(8)] = inst_100476);

return statearr_100508;
})();
var statearr_100509_100529 = state_100496__$1;
(statearr_100509_100529[(2)] = inst_100477);

(statearr_100509_100529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (14))){
var inst_100490 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
var statearr_100510_100530 = state_100496__$1;
(statearr_100510_100530[(2)] = inst_100490);

(statearr_100510_100530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (10))){
var state_100496__$1 = state_100496;
var statearr_100511_100531 = state_100496__$1;
(statearr_100511_100531[(2)] = fc);

(statearr_100511_100531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100497 === (8))){
var inst_100485 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
if(cljs.core.truth_(inst_100485)){
var statearr_100512_100532 = state_100496__$1;
(statearr_100512_100532[(1)] = (12));

} else {
var statearr_100513_100533 = state_100496__$1;
(statearr_100513_100533[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_100514 = [null,null,null,null,null,null,null,null,null];
(statearr_100514[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_100514[(1)] = (1));

return statearr_100514;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_100496){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100515){if((e100515 instanceof Object)){
var ex__99978__auto__ = e100515;
var statearr_100516_100534 = state_100496;
(statearr_100516_100534[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100515;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100535 = state_100496;
state_100496 = G__100535;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_100496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_100496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100517 = f__100070__auto__.call(null);
(statearr_100517[(6)] = c__100069__auto___100519);

return statearr_100517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100556){
var state_val_100557 = (state_100556[(1)]);
if((state_val_100557 === (7))){
var inst_100552 = (state_100556[(2)]);
var state_100556__$1 = state_100556;
var statearr_100558_100576 = state_100556__$1;
(statearr_100558_100576[(2)] = inst_100552);

(statearr_100558_100576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (1))){
var inst_100536 = init;
var state_100556__$1 = (function (){var statearr_100559 = state_100556;
(statearr_100559[(7)] = inst_100536);

return statearr_100559;
})();
var statearr_100560_100577 = state_100556__$1;
(statearr_100560_100577[(2)] = null);

(statearr_100560_100577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (4))){
var inst_100539 = (state_100556[(8)]);
var inst_100539__$1 = (state_100556[(2)]);
var inst_100540 = (inst_100539__$1 == null);
var state_100556__$1 = (function (){var statearr_100561 = state_100556;
(statearr_100561[(8)] = inst_100539__$1);

return statearr_100561;
})();
if(cljs.core.truth_(inst_100540)){
var statearr_100562_100578 = state_100556__$1;
(statearr_100562_100578[(1)] = (5));

} else {
var statearr_100563_100579 = state_100556__$1;
(statearr_100563_100579[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (6))){
var inst_100536 = (state_100556[(7)]);
var inst_100539 = (state_100556[(8)]);
var inst_100543 = (state_100556[(9)]);
var inst_100543__$1 = f.call(null,inst_100536,inst_100539);
var inst_100544 = cljs.core.reduced_QMARK_.call(null,inst_100543__$1);
var state_100556__$1 = (function (){var statearr_100564 = state_100556;
(statearr_100564[(9)] = inst_100543__$1);

return statearr_100564;
})();
if(inst_100544){
var statearr_100565_100580 = state_100556__$1;
(statearr_100565_100580[(1)] = (8));

} else {
var statearr_100566_100581 = state_100556__$1;
(statearr_100566_100581[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (3))){
var inst_100554 = (state_100556[(2)]);
var state_100556__$1 = state_100556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100556__$1,inst_100554);
} else {
if((state_val_100557 === (2))){
var state_100556__$1 = state_100556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100556__$1,(4),ch);
} else {
if((state_val_100557 === (9))){
var inst_100543 = (state_100556[(9)]);
var inst_100536 = inst_100543;
var state_100556__$1 = (function (){var statearr_100567 = state_100556;
(statearr_100567[(7)] = inst_100536);

return statearr_100567;
})();
var statearr_100568_100582 = state_100556__$1;
(statearr_100568_100582[(2)] = null);

(statearr_100568_100582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (5))){
var inst_100536 = (state_100556[(7)]);
var state_100556__$1 = state_100556;
var statearr_100569_100583 = state_100556__$1;
(statearr_100569_100583[(2)] = inst_100536);

(statearr_100569_100583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (10))){
var inst_100550 = (state_100556[(2)]);
var state_100556__$1 = state_100556;
var statearr_100570_100584 = state_100556__$1;
(statearr_100570_100584[(2)] = inst_100550);

(statearr_100570_100584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100557 === (8))){
var inst_100543 = (state_100556[(9)]);
var inst_100546 = cljs.core.deref.call(null,inst_100543);
var state_100556__$1 = state_100556;
var statearr_100571_100585 = state_100556__$1;
(statearr_100571_100585[(2)] = inst_100546);

(statearr_100571_100585[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__99975__auto__ = null;
var cljs$core$async$reduce_$_state_machine__99975__auto____0 = (function (){
var statearr_100572 = [null,null,null,null,null,null,null,null,null,null];
(statearr_100572[(0)] = cljs$core$async$reduce_$_state_machine__99975__auto__);

(statearr_100572[(1)] = (1));

return statearr_100572;
});
var cljs$core$async$reduce_$_state_machine__99975__auto____1 = (function (state_100556){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100573){if((e100573 instanceof Object)){
var ex__99978__auto__ = e100573;
var statearr_100574_100586 = state_100556;
(statearr_100574_100586[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100556);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100573;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100587 = state_100556;
state_100556 = G__100587;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__99975__auto__ = function(state_100556){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__99975__auto____1.call(this,state_100556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__99975__auto____0;
cljs$core$async$reduce_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__99975__auto____1;
return cljs$core$async$reduce_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100575 = f__100070__auto__.call(null);
(statearr_100575[(6)] = c__100069__auto__);

return statearr_100575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100593){
var state_val_100594 = (state_100593[(1)]);
if((state_val_100594 === (1))){
var inst_100588 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_100593__$1 = state_100593;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100593__$1,(2),inst_100588);
} else {
if((state_val_100594 === (2))){
var inst_100590 = (state_100593[(2)]);
var inst_100591 = f__$1.call(null,inst_100590);
var state_100593__$1 = state_100593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100593__$1,inst_100591);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__99975__auto__ = null;
var cljs$core$async$transduce_$_state_machine__99975__auto____0 = (function (){
var statearr_100595 = [null,null,null,null,null,null,null];
(statearr_100595[(0)] = cljs$core$async$transduce_$_state_machine__99975__auto__);

(statearr_100595[(1)] = (1));

return statearr_100595;
});
var cljs$core$async$transduce_$_state_machine__99975__auto____1 = (function (state_100593){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100596){if((e100596 instanceof Object)){
var ex__99978__auto__ = e100596;
var statearr_100597_100599 = state_100593;
(statearr_100597_100599[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100593);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100600 = state_100593;
state_100593 = G__100600;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__99975__auto__ = function(state_100593){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__99975__auto____1.call(this,state_100593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__99975__auto____0;
cljs$core$async$transduce_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__99975__auto____1;
return cljs$core$async$transduce_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100598 = f__100070__auto__.call(null);
(statearr_100598[(6)] = c__100069__auto__);

return statearr_100598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__100602 = arguments.length;
switch (G__100602) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100627){
var state_val_100628 = (state_100627[(1)]);
if((state_val_100628 === (7))){
var inst_100609 = (state_100627[(2)]);
var state_100627__$1 = state_100627;
var statearr_100629_100650 = state_100627__$1;
(statearr_100629_100650[(2)] = inst_100609);

(statearr_100629_100650[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (1))){
var inst_100603 = cljs.core.seq.call(null,coll);
var inst_100604 = inst_100603;
var state_100627__$1 = (function (){var statearr_100630 = state_100627;
(statearr_100630[(7)] = inst_100604);

return statearr_100630;
})();
var statearr_100631_100651 = state_100627__$1;
(statearr_100631_100651[(2)] = null);

(statearr_100631_100651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (4))){
var inst_100604 = (state_100627[(7)]);
var inst_100607 = cljs.core.first.call(null,inst_100604);
var state_100627__$1 = state_100627;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100627__$1,(7),ch,inst_100607);
} else {
if((state_val_100628 === (13))){
var inst_100621 = (state_100627[(2)]);
var state_100627__$1 = state_100627;
var statearr_100632_100652 = state_100627__$1;
(statearr_100632_100652[(2)] = inst_100621);

(statearr_100632_100652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (6))){
var inst_100612 = (state_100627[(2)]);
var state_100627__$1 = state_100627;
if(cljs.core.truth_(inst_100612)){
var statearr_100633_100653 = state_100627__$1;
(statearr_100633_100653[(1)] = (8));

} else {
var statearr_100634_100654 = state_100627__$1;
(statearr_100634_100654[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (3))){
var inst_100625 = (state_100627[(2)]);
var state_100627__$1 = state_100627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100627__$1,inst_100625);
} else {
if((state_val_100628 === (12))){
var state_100627__$1 = state_100627;
var statearr_100635_100655 = state_100627__$1;
(statearr_100635_100655[(2)] = null);

(statearr_100635_100655[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (2))){
var inst_100604 = (state_100627[(7)]);
var state_100627__$1 = state_100627;
if(cljs.core.truth_(inst_100604)){
var statearr_100636_100656 = state_100627__$1;
(statearr_100636_100656[(1)] = (4));

} else {
var statearr_100637_100657 = state_100627__$1;
(statearr_100637_100657[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (11))){
var inst_100618 = cljs.core.async.close_BANG_.call(null,ch);
var state_100627__$1 = state_100627;
var statearr_100638_100658 = state_100627__$1;
(statearr_100638_100658[(2)] = inst_100618);

(statearr_100638_100658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (9))){
var state_100627__$1 = state_100627;
if(cljs.core.truth_(close_QMARK_)){
var statearr_100639_100659 = state_100627__$1;
(statearr_100639_100659[(1)] = (11));

} else {
var statearr_100640_100660 = state_100627__$1;
(statearr_100640_100660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (5))){
var inst_100604 = (state_100627[(7)]);
var state_100627__$1 = state_100627;
var statearr_100641_100661 = state_100627__$1;
(statearr_100641_100661[(2)] = inst_100604);

(statearr_100641_100661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (10))){
var inst_100623 = (state_100627[(2)]);
var state_100627__$1 = state_100627;
var statearr_100642_100662 = state_100627__$1;
(statearr_100642_100662[(2)] = inst_100623);

(statearr_100642_100662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100628 === (8))){
var inst_100604 = (state_100627[(7)]);
var inst_100614 = cljs.core.next.call(null,inst_100604);
var inst_100604__$1 = inst_100614;
var state_100627__$1 = (function (){var statearr_100643 = state_100627;
(statearr_100643[(7)] = inst_100604__$1);

return statearr_100643;
})();
var statearr_100644_100663 = state_100627__$1;
(statearr_100644_100663[(2)] = null);

(statearr_100644_100663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_100645 = [null,null,null,null,null,null,null,null];
(statearr_100645[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_100645[(1)] = (1));

return statearr_100645;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_100627){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100646){if((e100646 instanceof Object)){
var ex__99978__auto__ = e100646;
var statearr_100647_100664 = state_100627;
(statearr_100647_100664[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100665 = state_100627;
state_100627 = G__100665;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_100627){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_100627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100648 = f__100070__auto__.call(null);
(statearr_100648[(6)] = c__100069__auto__);

return statearr_100648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_100666 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_100666.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_100667 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_100667.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_100668 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_100668.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_100669 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_100669.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100670 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100670 = (function (ch,cs,meta100671){
this.ch = ch;
this.cs = cs;
this.meta100671 = meta100671;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100672,meta100671__$1){
var self__ = this;
var _100672__$1 = this;
return (new cljs.core.async.t_cljs$core$async100670(self__.ch,self__.cs,meta100671__$1));
}));

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100672){
var self__ = this;
var _100672__$1 = this;
return self__.meta100671;
}));

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async100670.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async100670.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta100671","meta100671",1801119089,null)], null);
}));

(cljs.core.async.t_cljs$core$async100670.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100670.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100670");

(cljs.core.async.t_cljs$core$async100670.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async100670");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100670.
 */
cljs.core.async.__GT_t_cljs$core$async100670 = (function cljs$core$async$mult_$___GT_t_cljs$core$async100670(ch__$1,cs__$1,meta100671){
return (new cljs.core.async.t_cljs$core$async100670(ch__$1,cs__$1,meta100671));
});

}

return (new cljs.core.async.t_cljs$core$async100670(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__100069__auto___100892 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_100807){
var state_val_100808 = (state_100807[(1)]);
if((state_val_100808 === (7))){
var inst_100803 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100809_100893 = state_100807__$1;
(statearr_100809_100893[(2)] = inst_100803);

(statearr_100809_100893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (20))){
var inst_100706 = (state_100807[(7)]);
var inst_100718 = cljs.core.first.call(null,inst_100706);
var inst_100719 = cljs.core.nth.call(null,inst_100718,(0),null);
var inst_100720 = cljs.core.nth.call(null,inst_100718,(1),null);
var state_100807__$1 = (function (){var statearr_100810 = state_100807;
(statearr_100810[(8)] = inst_100719);

return statearr_100810;
})();
if(cljs.core.truth_(inst_100720)){
var statearr_100811_100894 = state_100807__$1;
(statearr_100811_100894[(1)] = (22));

} else {
var statearr_100812_100895 = state_100807__$1;
(statearr_100812_100895[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (27))){
var inst_100755 = (state_100807[(9)]);
var inst_100675 = (state_100807[(10)]);
var inst_100750 = (state_100807[(11)]);
var inst_100748 = (state_100807[(12)]);
var inst_100755__$1 = cljs.core._nth.call(null,inst_100748,inst_100750);
var inst_100756 = cljs.core.async.put_BANG_.call(null,inst_100755__$1,inst_100675,done);
var state_100807__$1 = (function (){var statearr_100813 = state_100807;
(statearr_100813[(9)] = inst_100755__$1);

return statearr_100813;
})();
if(cljs.core.truth_(inst_100756)){
var statearr_100814_100896 = state_100807__$1;
(statearr_100814_100896[(1)] = (30));

} else {
var statearr_100815_100897 = state_100807__$1;
(statearr_100815_100897[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (1))){
var state_100807__$1 = state_100807;
var statearr_100816_100898 = state_100807__$1;
(statearr_100816_100898[(2)] = null);

(statearr_100816_100898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (24))){
var inst_100706 = (state_100807[(7)]);
var inst_100725 = (state_100807[(2)]);
var inst_100726 = cljs.core.next.call(null,inst_100706);
var inst_100684 = inst_100726;
var inst_100685 = null;
var inst_100686 = (0);
var inst_100687 = (0);
var state_100807__$1 = (function (){var statearr_100817 = state_100807;
(statearr_100817[(13)] = inst_100687);

(statearr_100817[(14)] = inst_100686);

(statearr_100817[(15)] = inst_100685);

(statearr_100817[(16)] = inst_100725);

(statearr_100817[(17)] = inst_100684);

return statearr_100817;
})();
var statearr_100818_100899 = state_100807__$1;
(statearr_100818_100899[(2)] = null);

(statearr_100818_100899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (39))){
var state_100807__$1 = state_100807;
var statearr_100822_100900 = state_100807__$1;
(statearr_100822_100900[(2)] = null);

(statearr_100822_100900[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (4))){
var inst_100675 = (state_100807[(10)]);
var inst_100675__$1 = (state_100807[(2)]);
var inst_100676 = (inst_100675__$1 == null);
var state_100807__$1 = (function (){var statearr_100823 = state_100807;
(statearr_100823[(10)] = inst_100675__$1);

return statearr_100823;
})();
if(cljs.core.truth_(inst_100676)){
var statearr_100824_100901 = state_100807__$1;
(statearr_100824_100901[(1)] = (5));

} else {
var statearr_100825_100902 = state_100807__$1;
(statearr_100825_100902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (15))){
var inst_100687 = (state_100807[(13)]);
var inst_100686 = (state_100807[(14)]);
var inst_100685 = (state_100807[(15)]);
var inst_100684 = (state_100807[(17)]);
var inst_100702 = (state_100807[(2)]);
var inst_100703 = (inst_100687 + (1));
var tmp100819 = inst_100686;
var tmp100820 = inst_100685;
var tmp100821 = inst_100684;
var inst_100684__$1 = tmp100821;
var inst_100685__$1 = tmp100820;
var inst_100686__$1 = tmp100819;
var inst_100687__$1 = inst_100703;
var state_100807__$1 = (function (){var statearr_100826 = state_100807;
(statearr_100826[(18)] = inst_100702);

(statearr_100826[(13)] = inst_100687__$1);

(statearr_100826[(14)] = inst_100686__$1);

(statearr_100826[(15)] = inst_100685__$1);

(statearr_100826[(17)] = inst_100684__$1);

return statearr_100826;
})();
var statearr_100827_100903 = state_100807__$1;
(statearr_100827_100903[(2)] = null);

(statearr_100827_100903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (21))){
var inst_100729 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100831_100904 = state_100807__$1;
(statearr_100831_100904[(2)] = inst_100729);

(statearr_100831_100904[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (31))){
var inst_100755 = (state_100807[(9)]);
var inst_100759 = done.call(null,null);
var inst_100760 = cljs.core.async.untap_STAR_.call(null,m,inst_100755);
var state_100807__$1 = (function (){var statearr_100832 = state_100807;
(statearr_100832[(19)] = inst_100759);

return statearr_100832;
})();
var statearr_100833_100905 = state_100807__$1;
(statearr_100833_100905[(2)] = inst_100760);

(statearr_100833_100905[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (32))){
var inst_100750 = (state_100807[(11)]);
var inst_100748 = (state_100807[(12)]);
var inst_100747 = (state_100807[(20)]);
var inst_100749 = (state_100807[(21)]);
var inst_100762 = (state_100807[(2)]);
var inst_100763 = (inst_100750 + (1));
var tmp100828 = inst_100748;
var tmp100829 = inst_100747;
var tmp100830 = inst_100749;
var inst_100747__$1 = tmp100829;
var inst_100748__$1 = tmp100828;
var inst_100749__$1 = tmp100830;
var inst_100750__$1 = inst_100763;
var state_100807__$1 = (function (){var statearr_100834 = state_100807;
(statearr_100834[(11)] = inst_100750__$1);

(statearr_100834[(12)] = inst_100748__$1);

(statearr_100834[(20)] = inst_100747__$1);

(statearr_100834[(22)] = inst_100762);

(statearr_100834[(21)] = inst_100749__$1);

return statearr_100834;
})();
var statearr_100835_100906 = state_100807__$1;
(statearr_100835_100906[(2)] = null);

(statearr_100835_100906[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (40))){
var inst_100775 = (state_100807[(23)]);
var inst_100779 = done.call(null,null);
var inst_100780 = cljs.core.async.untap_STAR_.call(null,m,inst_100775);
var state_100807__$1 = (function (){var statearr_100836 = state_100807;
(statearr_100836[(24)] = inst_100779);

return statearr_100836;
})();
var statearr_100837_100907 = state_100807__$1;
(statearr_100837_100907[(2)] = inst_100780);

(statearr_100837_100907[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (33))){
var inst_100766 = (state_100807[(25)]);
var inst_100768 = cljs.core.chunked_seq_QMARK_.call(null,inst_100766);
var state_100807__$1 = state_100807;
if(inst_100768){
var statearr_100838_100908 = state_100807__$1;
(statearr_100838_100908[(1)] = (36));

} else {
var statearr_100839_100909 = state_100807__$1;
(statearr_100839_100909[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (13))){
var inst_100696 = (state_100807[(26)]);
var inst_100699 = cljs.core.async.close_BANG_.call(null,inst_100696);
var state_100807__$1 = state_100807;
var statearr_100840_100910 = state_100807__$1;
(statearr_100840_100910[(2)] = inst_100699);

(statearr_100840_100910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (22))){
var inst_100719 = (state_100807[(8)]);
var inst_100722 = cljs.core.async.close_BANG_.call(null,inst_100719);
var state_100807__$1 = state_100807;
var statearr_100841_100911 = state_100807__$1;
(statearr_100841_100911[(2)] = inst_100722);

(statearr_100841_100911[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (36))){
var inst_100766 = (state_100807[(25)]);
var inst_100770 = cljs.core.chunk_first.call(null,inst_100766);
var inst_100771 = cljs.core.chunk_rest.call(null,inst_100766);
var inst_100772 = cljs.core.count.call(null,inst_100770);
var inst_100747 = inst_100771;
var inst_100748 = inst_100770;
var inst_100749 = inst_100772;
var inst_100750 = (0);
var state_100807__$1 = (function (){var statearr_100842 = state_100807;
(statearr_100842[(11)] = inst_100750);

(statearr_100842[(12)] = inst_100748);

(statearr_100842[(20)] = inst_100747);

(statearr_100842[(21)] = inst_100749);

return statearr_100842;
})();
var statearr_100843_100912 = state_100807__$1;
(statearr_100843_100912[(2)] = null);

(statearr_100843_100912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (41))){
var inst_100766 = (state_100807[(25)]);
var inst_100782 = (state_100807[(2)]);
var inst_100783 = cljs.core.next.call(null,inst_100766);
var inst_100747 = inst_100783;
var inst_100748 = null;
var inst_100749 = (0);
var inst_100750 = (0);
var state_100807__$1 = (function (){var statearr_100844 = state_100807;
(statearr_100844[(11)] = inst_100750);

(statearr_100844[(12)] = inst_100748);

(statearr_100844[(27)] = inst_100782);

(statearr_100844[(20)] = inst_100747);

(statearr_100844[(21)] = inst_100749);

return statearr_100844;
})();
var statearr_100845_100913 = state_100807__$1;
(statearr_100845_100913[(2)] = null);

(statearr_100845_100913[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (43))){
var state_100807__$1 = state_100807;
var statearr_100846_100914 = state_100807__$1;
(statearr_100846_100914[(2)] = null);

(statearr_100846_100914[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (29))){
var inst_100791 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100847_100915 = state_100807__$1;
(statearr_100847_100915[(2)] = inst_100791);

(statearr_100847_100915[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (44))){
var inst_100800 = (state_100807[(2)]);
var state_100807__$1 = (function (){var statearr_100848 = state_100807;
(statearr_100848[(28)] = inst_100800);

return statearr_100848;
})();
var statearr_100849_100916 = state_100807__$1;
(statearr_100849_100916[(2)] = null);

(statearr_100849_100916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (6))){
var inst_100739 = (state_100807[(29)]);
var inst_100738 = cljs.core.deref.call(null,cs);
var inst_100739__$1 = cljs.core.keys.call(null,inst_100738);
var inst_100740 = cljs.core.count.call(null,inst_100739__$1);
var inst_100741 = cljs.core.reset_BANG_.call(null,dctr,inst_100740);
var inst_100746 = cljs.core.seq.call(null,inst_100739__$1);
var inst_100747 = inst_100746;
var inst_100748 = null;
var inst_100749 = (0);
var inst_100750 = (0);
var state_100807__$1 = (function (){var statearr_100850 = state_100807;
(statearr_100850[(29)] = inst_100739__$1);

(statearr_100850[(30)] = inst_100741);

(statearr_100850[(11)] = inst_100750);

(statearr_100850[(12)] = inst_100748);

(statearr_100850[(20)] = inst_100747);

(statearr_100850[(21)] = inst_100749);

return statearr_100850;
})();
var statearr_100851_100917 = state_100807__$1;
(statearr_100851_100917[(2)] = null);

(statearr_100851_100917[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (28))){
var inst_100766 = (state_100807[(25)]);
var inst_100747 = (state_100807[(20)]);
var inst_100766__$1 = cljs.core.seq.call(null,inst_100747);
var state_100807__$1 = (function (){var statearr_100852 = state_100807;
(statearr_100852[(25)] = inst_100766__$1);

return statearr_100852;
})();
if(inst_100766__$1){
var statearr_100853_100918 = state_100807__$1;
(statearr_100853_100918[(1)] = (33));

} else {
var statearr_100854_100919 = state_100807__$1;
(statearr_100854_100919[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (25))){
var inst_100750 = (state_100807[(11)]);
var inst_100749 = (state_100807[(21)]);
var inst_100752 = (inst_100750 < inst_100749);
var inst_100753 = inst_100752;
var state_100807__$1 = state_100807;
if(cljs.core.truth_(inst_100753)){
var statearr_100855_100920 = state_100807__$1;
(statearr_100855_100920[(1)] = (27));

} else {
var statearr_100856_100921 = state_100807__$1;
(statearr_100856_100921[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (34))){
var state_100807__$1 = state_100807;
var statearr_100857_100922 = state_100807__$1;
(statearr_100857_100922[(2)] = null);

(statearr_100857_100922[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (17))){
var state_100807__$1 = state_100807;
var statearr_100858_100923 = state_100807__$1;
(statearr_100858_100923[(2)] = null);

(statearr_100858_100923[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (3))){
var inst_100805 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100807__$1,inst_100805);
} else {
if((state_val_100808 === (12))){
var inst_100734 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100859_100924 = state_100807__$1;
(statearr_100859_100924[(2)] = inst_100734);

(statearr_100859_100924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (2))){
var state_100807__$1 = state_100807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100807__$1,(4),ch);
} else {
if((state_val_100808 === (23))){
var state_100807__$1 = state_100807;
var statearr_100860_100925 = state_100807__$1;
(statearr_100860_100925[(2)] = null);

(statearr_100860_100925[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (35))){
var inst_100789 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100861_100926 = state_100807__$1;
(statearr_100861_100926[(2)] = inst_100789);

(statearr_100861_100926[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (19))){
var inst_100706 = (state_100807[(7)]);
var inst_100710 = cljs.core.chunk_first.call(null,inst_100706);
var inst_100711 = cljs.core.chunk_rest.call(null,inst_100706);
var inst_100712 = cljs.core.count.call(null,inst_100710);
var inst_100684 = inst_100711;
var inst_100685 = inst_100710;
var inst_100686 = inst_100712;
var inst_100687 = (0);
var state_100807__$1 = (function (){var statearr_100862 = state_100807;
(statearr_100862[(13)] = inst_100687);

(statearr_100862[(14)] = inst_100686);

(statearr_100862[(15)] = inst_100685);

(statearr_100862[(17)] = inst_100684);

return statearr_100862;
})();
var statearr_100863_100927 = state_100807__$1;
(statearr_100863_100927[(2)] = null);

(statearr_100863_100927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (11))){
var inst_100706 = (state_100807[(7)]);
var inst_100684 = (state_100807[(17)]);
var inst_100706__$1 = cljs.core.seq.call(null,inst_100684);
var state_100807__$1 = (function (){var statearr_100864 = state_100807;
(statearr_100864[(7)] = inst_100706__$1);

return statearr_100864;
})();
if(inst_100706__$1){
var statearr_100865_100928 = state_100807__$1;
(statearr_100865_100928[(1)] = (16));

} else {
var statearr_100866_100929 = state_100807__$1;
(statearr_100866_100929[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (9))){
var inst_100736 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100867_100930 = state_100807__$1;
(statearr_100867_100930[(2)] = inst_100736);

(statearr_100867_100930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (5))){
var inst_100682 = cljs.core.deref.call(null,cs);
var inst_100683 = cljs.core.seq.call(null,inst_100682);
var inst_100684 = inst_100683;
var inst_100685 = null;
var inst_100686 = (0);
var inst_100687 = (0);
var state_100807__$1 = (function (){var statearr_100868 = state_100807;
(statearr_100868[(13)] = inst_100687);

(statearr_100868[(14)] = inst_100686);

(statearr_100868[(15)] = inst_100685);

(statearr_100868[(17)] = inst_100684);

return statearr_100868;
})();
var statearr_100869_100931 = state_100807__$1;
(statearr_100869_100931[(2)] = null);

(statearr_100869_100931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (14))){
var state_100807__$1 = state_100807;
var statearr_100870_100932 = state_100807__$1;
(statearr_100870_100932[(2)] = null);

(statearr_100870_100932[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (45))){
var inst_100797 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100871_100933 = state_100807__$1;
(statearr_100871_100933[(2)] = inst_100797);

(statearr_100871_100933[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (26))){
var inst_100739 = (state_100807[(29)]);
var inst_100793 = (state_100807[(2)]);
var inst_100794 = cljs.core.seq.call(null,inst_100739);
var state_100807__$1 = (function (){var statearr_100872 = state_100807;
(statearr_100872[(31)] = inst_100793);

return statearr_100872;
})();
if(inst_100794){
var statearr_100873_100934 = state_100807__$1;
(statearr_100873_100934[(1)] = (42));

} else {
var statearr_100874_100935 = state_100807__$1;
(statearr_100874_100935[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (16))){
var inst_100706 = (state_100807[(7)]);
var inst_100708 = cljs.core.chunked_seq_QMARK_.call(null,inst_100706);
var state_100807__$1 = state_100807;
if(inst_100708){
var statearr_100875_100936 = state_100807__$1;
(statearr_100875_100936[(1)] = (19));

} else {
var statearr_100876_100937 = state_100807__$1;
(statearr_100876_100937[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (38))){
var inst_100786 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100877_100938 = state_100807__$1;
(statearr_100877_100938[(2)] = inst_100786);

(statearr_100877_100938[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (30))){
var state_100807__$1 = state_100807;
var statearr_100878_100939 = state_100807__$1;
(statearr_100878_100939[(2)] = null);

(statearr_100878_100939[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (10))){
var inst_100687 = (state_100807[(13)]);
var inst_100685 = (state_100807[(15)]);
var inst_100695 = cljs.core._nth.call(null,inst_100685,inst_100687);
var inst_100696 = cljs.core.nth.call(null,inst_100695,(0),null);
var inst_100697 = cljs.core.nth.call(null,inst_100695,(1),null);
var state_100807__$1 = (function (){var statearr_100879 = state_100807;
(statearr_100879[(26)] = inst_100696);

return statearr_100879;
})();
if(cljs.core.truth_(inst_100697)){
var statearr_100880_100940 = state_100807__$1;
(statearr_100880_100940[(1)] = (13));

} else {
var statearr_100881_100941 = state_100807__$1;
(statearr_100881_100941[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (18))){
var inst_100732 = (state_100807[(2)]);
var state_100807__$1 = state_100807;
var statearr_100882_100942 = state_100807__$1;
(statearr_100882_100942[(2)] = inst_100732);

(statearr_100882_100942[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (42))){
var state_100807__$1 = state_100807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100807__$1,(45),dchan);
} else {
if((state_val_100808 === (37))){
var inst_100766 = (state_100807[(25)]);
var inst_100775 = (state_100807[(23)]);
var inst_100675 = (state_100807[(10)]);
var inst_100775__$1 = cljs.core.first.call(null,inst_100766);
var inst_100776 = cljs.core.async.put_BANG_.call(null,inst_100775__$1,inst_100675,done);
var state_100807__$1 = (function (){var statearr_100883 = state_100807;
(statearr_100883[(23)] = inst_100775__$1);

return statearr_100883;
})();
if(cljs.core.truth_(inst_100776)){
var statearr_100884_100943 = state_100807__$1;
(statearr_100884_100943[(1)] = (39));

} else {
var statearr_100885_100944 = state_100807__$1;
(statearr_100885_100944[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100808 === (8))){
var inst_100687 = (state_100807[(13)]);
var inst_100686 = (state_100807[(14)]);
var inst_100689 = (inst_100687 < inst_100686);
var inst_100690 = inst_100689;
var state_100807__$1 = state_100807;
if(cljs.core.truth_(inst_100690)){
var statearr_100886_100945 = state_100807__$1;
(statearr_100886_100945[(1)] = (10));

} else {
var statearr_100887_100946 = state_100807__$1;
(statearr_100887_100946[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__99975__auto__ = null;
var cljs$core$async$mult_$_state_machine__99975__auto____0 = (function (){
var statearr_100888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100888[(0)] = cljs$core$async$mult_$_state_machine__99975__auto__);

(statearr_100888[(1)] = (1));

return statearr_100888;
});
var cljs$core$async$mult_$_state_machine__99975__auto____1 = (function (state_100807){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_100807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e100889){if((e100889 instanceof Object)){
var ex__99978__auto__ = e100889;
var statearr_100890_100947 = state_100807;
(statearr_100890_100947[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100948 = state_100807;
state_100807 = G__100948;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__99975__auto__ = function(state_100807){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__99975__auto____1.call(this,state_100807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__99975__auto____0;
cljs$core$async$mult_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__99975__auto____1;
return cljs$core$async$mult_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_100891 = f__100070__auto__.call(null);
(statearr_100891[(6)] = c__100069__auto___100892);

return statearr_100891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__100950 = arguments.length;
switch (G__100950) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_100952 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_100952.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_100953 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_100953.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_100954 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_100954.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_100955 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_100955.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_100956 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_100956.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___100967 = arguments.length;
var i__4737__auto___100968 = (0);
while(true){
if((i__4737__auto___100968 < len__4736__auto___100967)){
args__4742__auto__.push((arguments[i__4737__auto___100968]));

var G__100969 = (i__4737__auto___100968 + (1));
i__4737__auto___100968 = G__100969;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__100961){
var map__100962 = p__100961;
var map__100962__$1 = (((((!((map__100962 == null))))?(((((map__100962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100962):map__100962);
var opts = map__100962__$1;
var statearr_100964_100970 = state;
(statearr_100964_100970[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_100965_100971 = state;
(statearr_100965_100971[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_100966_100972 = state;
(statearr_100966_100972[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq100957){
var G__100958 = cljs.core.first.call(null,seq100957);
var seq100957__$1 = cljs.core.next.call(null,seq100957);
var G__100959 = cljs.core.first.call(null,seq100957__$1);
var seq100957__$2 = cljs.core.next.call(null,seq100957__$1);
var G__100960 = cljs.core.first.call(null,seq100957__$2);
var seq100957__$3 = cljs.core.next.call(null,seq100957__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__100958,G__100959,G__100960,seq100957__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100973 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100973 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta100974){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta100974 = meta100974;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100975,meta100974__$1){
var self__ = this;
var _100975__$1 = this;
return (new cljs.core.async.t_cljs$core$async100973(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta100974__$1));
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100975){
var self__ = this;
var _100975__$1 = this;
return self__.meta100974;
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async100973.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async100973.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta100974","meta100974",1303453374,null)], null);
}));

(cljs.core.async.t_cljs$core$async100973.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async100973.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100973");

(cljs.core.async.t_cljs$core$async100973.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async100973");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100973.
 */
cljs.core.async.__GT_t_cljs$core$async100973 = (function cljs$core$async$mix_$___GT_t_cljs$core$async100973(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta100974){
return (new cljs.core.async.t_cljs$core$async100973(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta100974));
});

}

return (new cljs.core.async.t_cljs$core$async100973(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__100069__auto___101137 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101077){
var state_val_101078 = (state_101077[(1)]);
if((state_val_101078 === (7))){
var inst_100992 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
var statearr_101079_101138 = state_101077__$1;
(statearr_101079_101138[(2)] = inst_100992);

(statearr_101079_101138[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (20))){
var inst_101004 = (state_101077[(7)]);
var state_101077__$1 = state_101077;
var statearr_101080_101139 = state_101077__$1;
(statearr_101080_101139[(2)] = inst_101004);

(statearr_101080_101139[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (27))){
var state_101077__$1 = state_101077;
var statearr_101081_101140 = state_101077__$1;
(statearr_101081_101140[(2)] = null);

(statearr_101081_101140[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (1))){
var inst_100979 = (state_101077[(8)]);
var inst_100979__$1 = calc_state.call(null);
var inst_100981 = (inst_100979__$1 == null);
var inst_100982 = cljs.core.not.call(null,inst_100981);
var state_101077__$1 = (function (){var statearr_101082 = state_101077;
(statearr_101082[(8)] = inst_100979__$1);

return statearr_101082;
})();
if(inst_100982){
var statearr_101083_101141 = state_101077__$1;
(statearr_101083_101141[(1)] = (2));

} else {
var statearr_101084_101142 = state_101077__$1;
(statearr_101084_101142[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (24))){
var inst_101037 = (state_101077[(9)]);
var inst_101028 = (state_101077[(10)]);
var inst_101051 = (state_101077[(11)]);
var inst_101051__$1 = inst_101028.call(null,inst_101037);
var state_101077__$1 = (function (){var statearr_101085 = state_101077;
(statearr_101085[(11)] = inst_101051__$1);

return statearr_101085;
})();
if(cljs.core.truth_(inst_101051__$1)){
var statearr_101086_101143 = state_101077__$1;
(statearr_101086_101143[(1)] = (29));

} else {
var statearr_101087_101144 = state_101077__$1;
(statearr_101087_101144[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (4))){
var inst_100995 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_100995)){
var statearr_101088_101145 = state_101077__$1;
(statearr_101088_101145[(1)] = (8));

} else {
var statearr_101089_101146 = state_101077__$1;
(statearr_101089_101146[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (15))){
var inst_101022 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_101022)){
var statearr_101090_101147 = state_101077__$1;
(statearr_101090_101147[(1)] = (19));

} else {
var statearr_101091_101148 = state_101077__$1;
(statearr_101091_101148[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (21))){
var inst_101027 = (state_101077[(12)]);
var inst_101027__$1 = (state_101077[(2)]);
var inst_101028 = cljs.core.get.call(null,inst_101027__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_101029 = cljs.core.get.call(null,inst_101027__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_101030 = cljs.core.get.call(null,inst_101027__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_101077__$1 = (function (){var statearr_101092 = state_101077;
(statearr_101092[(13)] = inst_101029);

(statearr_101092[(10)] = inst_101028);

(statearr_101092[(12)] = inst_101027__$1);

return statearr_101092;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_101077__$1,(22),inst_101030);
} else {
if((state_val_101078 === (31))){
var inst_101059 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_101059)){
var statearr_101093_101149 = state_101077__$1;
(statearr_101093_101149[(1)] = (32));

} else {
var statearr_101094_101150 = state_101077__$1;
(statearr_101094_101150[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (32))){
var inst_101036 = (state_101077[(14)]);
var state_101077__$1 = state_101077;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101077__$1,(35),out,inst_101036);
} else {
if((state_val_101078 === (33))){
var inst_101027 = (state_101077[(12)]);
var inst_101004 = inst_101027;
var state_101077__$1 = (function (){var statearr_101095 = state_101077;
(statearr_101095[(7)] = inst_101004);

return statearr_101095;
})();
var statearr_101096_101151 = state_101077__$1;
(statearr_101096_101151[(2)] = null);

(statearr_101096_101151[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (13))){
var inst_101004 = (state_101077[(7)]);
var inst_101011 = inst_101004.cljs$lang$protocol_mask$partition0$;
var inst_101012 = (inst_101011 & (64));
var inst_101013 = inst_101004.cljs$core$ISeq$;
var inst_101014 = (cljs.core.PROTOCOL_SENTINEL === inst_101013);
var inst_101015 = ((inst_101012) || (inst_101014));
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_101015)){
var statearr_101097_101152 = state_101077__$1;
(statearr_101097_101152[(1)] = (16));

} else {
var statearr_101098_101153 = state_101077__$1;
(statearr_101098_101153[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (22))){
var inst_101037 = (state_101077[(9)]);
var inst_101036 = (state_101077[(14)]);
var inst_101035 = (state_101077[(2)]);
var inst_101036__$1 = cljs.core.nth.call(null,inst_101035,(0),null);
var inst_101037__$1 = cljs.core.nth.call(null,inst_101035,(1),null);
var inst_101038 = (inst_101036__$1 == null);
var inst_101039 = cljs.core._EQ_.call(null,inst_101037__$1,change);
var inst_101040 = ((inst_101038) || (inst_101039));
var state_101077__$1 = (function (){var statearr_101099 = state_101077;
(statearr_101099[(9)] = inst_101037__$1);

(statearr_101099[(14)] = inst_101036__$1);

return statearr_101099;
})();
if(cljs.core.truth_(inst_101040)){
var statearr_101100_101154 = state_101077__$1;
(statearr_101100_101154[(1)] = (23));

} else {
var statearr_101101_101155 = state_101077__$1;
(statearr_101101_101155[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (36))){
var inst_101027 = (state_101077[(12)]);
var inst_101004 = inst_101027;
var state_101077__$1 = (function (){var statearr_101102 = state_101077;
(statearr_101102[(7)] = inst_101004);

return statearr_101102;
})();
var statearr_101103_101156 = state_101077__$1;
(statearr_101103_101156[(2)] = null);

(statearr_101103_101156[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (29))){
var inst_101051 = (state_101077[(11)]);
var state_101077__$1 = state_101077;
var statearr_101104_101157 = state_101077__$1;
(statearr_101104_101157[(2)] = inst_101051);

(statearr_101104_101157[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (6))){
var state_101077__$1 = state_101077;
var statearr_101105_101158 = state_101077__$1;
(statearr_101105_101158[(2)] = false);

(statearr_101105_101158[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (28))){
var inst_101047 = (state_101077[(2)]);
var inst_101048 = calc_state.call(null);
var inst_101004 = inst_101048;
var state_101077__$1 = (function (){var statearr_101106 = state_101077;
(statearr_101106[(15)] = inst_101047);

(statearr_101106[(7)] = inst_101004);

return statearr_101106;
})();
var statearr_101107_101159 = state_101077__$1;
(statearr_101107_101159[(2)] = null);

(statearr_101107_101159[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (25))){
var inst_101073 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
var statearr_101108_101160 = state_101077__$1;
(statearr_101108_101160[(2)] = inst_101073);

(statearr_101108_101160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (34))){
var inst_101071 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
var statearr_101109_101161 = state_101077__$1;
(statearr_101109_101161[(2)] = inst_101071);

(statearr_101109_101161[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (17))){
var state_101077__$1 = state_101077;
var statearr_101110_101162 = state_101077__$1;
(statearr_101110_101162[(2)] = false);

(statearr_101110_101162[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (3))){
var state_101077__$1 = state_101077;
var statearr_101111_101163 = state_101077__$1;
(statearr_101111_101163[(2)] = false);

(statearr_101111_101163[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (12))){
var inst_101075 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101077__$1,inst_101075);
} else {
if((state_val_101078 === (2))){
var inst_100979 = (state_101077[(8)]);
var inst_100984 = inst_100979.cljs$lang$protocol_mask$partition0$;
var inst_100985 = (inst_100984 & (64));
var inst_100986 = inst_100979.cljs$core$ISeq$;
var inst_100987 = (cljs.core.PROTOCOL_SENTINEL === inst_100986);
var inst_100988 = ((inst_100985) || (inst_100987));
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_100988)){
var statearr_101112_101164 = state_101077__$1;
(statearr_101112_101164[(1)] = (5));

} else {
var statearr_101113_101165 = state_101077__$1;
(statearr_101113_101165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (23))){
var inst_101036 = (state_101077[(14)]);
var inst_101042 = (inst_101036 == null);
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_101042)){
var statearr_101114_101166 = state_101077__$1;
(statearr_101114_101166[(1)] = (26));

} else {
var statearr_101115_101167 = state_101077__$1;
(statearr_101115_101167[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (35))){
var inst_101062 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
if(cljs.core.truth_(inst_101062)){
var statearr_101116_101168 = state_101077__$1;
(statearr_101116_101168[(1)] = (36));

} else {
var statearr_101117_101169 = state_101077__$1;
(statearr_101117_101169[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (19))){
var inst_101004 = (state_101077[(7)]);
var inst_101024 = cljs.core.apply.call(null,cljs.core.hash_map,inst_101004);
var state_101077__$1 = state_101077;
var statearr_101118_101170 = state_101077__$1;
(statearr_101118_101170[(2)] = inst_101024);

(statearr_101118_101170[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (11))){
var inst_101004 = (state_101077[(7)]);
var inst_101008 = (inst_101004 == null);
var inst_101009 = cljs.core.not.call(null,inst_101008);
var state_101077__$1 = state_101077;
if(inst_101009){
var statearr_101119_101171 = state_101077__$1;
(statearr_101119_101171[(1)] = (13));

} else {
var statearr_101120_101172 = state_101077__$1;
(statearr_101120_101172[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (9))){
var inst_100979 = (state_101077[(8)]);
var state_101077__$1 = state_101077;
var statearr_101121_101173 = state_101077__$1;
(statearr_101121_101173[(2)] = inst_100979);

(statearr_101121_101173[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (5))){
var state_101077__$1 = state_101077;
var statearr_101122_101174 = state_101077__$1;
(statearr_101122_101174[(2)] = true);

(statearr_101122_101174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (14))){
var state_101077__$1 = state_101077;
var statearr_101123_101175 = state_101077__$1;
(statearr_101123_101175[(2)] = false);

(statearr_101123_101175[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (26))){
var inst_101037 = (state_101077[(9)]);
var inst_101044 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_101037);
var state_101077__$1 = state_101077;
var statearr_101124_101176 = state_101077__$1;
(statearr_101124_101176[(2)] = inst_101044);

(statearr_101124_101176[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (16))){
var state_101077__$1 = state_101077;
var statearr_101125_101177 = state_101077__$1;
(statearr_101125_101177[(2)] = true);

(statearr_101125_101177[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (38))){
var inst_101067 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
var statearr_101126_101178 = state_101077__$1;
(statearr_101126_101178[(2)] = inst_101067);

(statearr_101126_101178[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (30))){
var inst_101029 = (state_101077[(13)]);
var inst_101037 = (state_101077[(9)]);
var inst_101028 = (state_101077[(10)]);
var inst_101054 = cljs.core.empty_QMARK_.call(null,inst_101028);
var inst_101055 = inst_101029.call(null,inst_101037);
var inst_101056 = cljs.core.not.call(null,inst_101055);
var inst_101057 = ((inst_101054) && (inst_101056));
var state_101077__$1 = state_101077;
var statearr_101127_101179 = state_101077__$1;
(statearr_101127_101179[(2)] = inst_101057);

(statearr_101127_101179[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (10))){
var inst_100979 = (state_101077[(8)]);
var inst_101000 = (state_101077[(2)]);
var inst_101001 = cljs.core.get.call(null,inst_101000,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_101002 = cljs.core.get.call(null,inst_101000,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_101003 = cljs.core.get.call(null,inst_101000,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_101004 = inst_100979;
var state_101077__$1 = (function (){var statearr_101128 = state_101077;
(statearr_101128[(16)] = inst_101001);

(statearr_101128[(17)] = inst_101002);

(statearr_101128[(7)] = inst_101004);

(statearr_101128[(18)] = inst_101003);

return statearr_101128;
})();
var statearr_101129_101180 = state_101077__$1;
(statearr_101129_101180[(2)] = null);

(statearr_101129_101180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (18))){
var inst_101019 = (state_101077[(2)]);
var state_101077__$1 = state_101077;
var statearr_101130_101181 = state_101077__$1;
(statearr_101130_101181[(2)] = inst_101019);

(statearr_101130_101181[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (37))){
var state_101077__$1 = state_101077;
var statearr_101131_101182 = state_101077__$1;
(statearr_101131_101182[(2)] = null);

(statearr_101131_101182[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101078 === (8))){
var inst_100979 = (state_101077[(8)]);
var inst_100997 = cljs.core.apply.call(null,cljs.core.hash_map,inst_100979);
var state_101077__$1 = state_101077;
var statearr_101132_101183 = state_101077__$1;
(statearr_101132_101183[(2)] = inst_100997);

(statearr_101132_101183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__99975__auto__ = null;
var cljs$core$async$mix_$_state_machine__99975__auto____0 = (function (){
var statearr_101133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101133[(0)] = cljs$core$async$mix_$_state_machine__99975__auto__);

(statearr_101133[(1)] = (1));

return statearr_101133;
});
var cljs$core$async$mix_$_state_machine__99975__auto____1 = (function (state_101077){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101134){if((e101134 instanceof Object)){
var ex__99978__auto__ = e101134;
var statearr_101135_101184 = state_101077;
(statearr_101135_101184[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101134;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101185 = state_101077;
state_101077 = G__101185;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__99975__auto__ = function(state_101077){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__99975__auto____1.call(this,state_101077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__99975__auto____0;
cljs$core$async$mix_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__99975__auto____1;
return cljs$core$async$mix_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101136 = f__100070__auto__.call(null);
(statearr_101136[(6)] = c__100069__auto___101137);

return statearr_101136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_101188 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_101188.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_101189 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_101189.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_101190 = (function() {
var G__101191 = null;
var G__101191__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__101191__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__101191 = function(p,v){
switch(arguments.length){
case 1:
return G__101191__1.call(this,p);
case 2:
return G__101191__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__101191.cljs$core$IFn$_invoke$arity$1 = G__101191__1;
G__101191.cljs$core$IFn$_invoke$arity$2 = G__101191__2;
return G__101191;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__101187 = arguments.length;
switch (G__101187) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_101190.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_101190.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__101195 = arguments.length;
switch (G__101195) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__101193_SHARP_){
if(cljs.core.truth_(p1__101193_SHARP_.call(null,topic))){
return p1__101193_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__101193_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101196 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101196 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta101197){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta101197 = meta101197;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101198,meta101197__$1){
var self__ = this;
var _101198__$1 = this;
return (new cljs.core.async.t_cljs$core$async101196(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta101197__$1));
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101198){
var self__ = this;
var _101198__$1 = this;
return self__.meta101197;
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async101196.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async101196.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta101197","meta101197",-1327094067,null)], null);
}));

(cljs.core.async.t_cljs$core$async101196.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101196.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101196");

(cljs.core.async.t_cljs$core$async101196.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async101196");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101196.
 */
cljs.core.async.__GT_t_cljs$core$async101196 = (function cljs$core$async$__GT_t_cljs$core$async101196(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta101197){
return (new cljs.core.async.t_cljs$core$async101196(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta101197));
});

}

return (new cljs.core.async.t_cljs$core$async101196(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__100069__auto___101316 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101270){
var state_val_101271 = (state_101270[(1)]);
if((state_val_101271 === (7))){
var inst_101266 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101272_101317 = state_101270__$1;
(statearr_101272_101317[(2)] = inst_101266);

(statearr_101272_101317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (20))){
var state_101270__$1 = state_101270;
var statearr_101273_101318 = state_101270__$1;
(statearr_101273_101318[(2)] = null);

(statearr_101273_101318[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (1))){
var state_101270__$1 = state_101270;
var statearr_101274_101319 = state_101270__$1;
(statearr_101274_101319[(2)] = null);

(statearr_101274_101319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (24))){
var inst_101249 = (state_101270[(7)]);
var inst_101258 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_101249);
var state_101270__$1 = state_101270;
var statearr_101275_101320 = state_101270__$1;
(statearr_101275_101320[(2)] = inst_101258);

(statearr_101275_101320[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (4))){
var inst_101201 = (state_101270[(8)]);
var inst_101201__$1 = (state_101270[(2)]);
var inst_101202 = (inst_101201__$1 == null);
var state_101270__$1 = (function (){var statearr_101276 = state_101270;
(statearr_101276[(8)] = inst_101201__$1);

return statearr_101276;
})();
if(cljs.core.truth_(inst_101202)){
var statearr_101277_101321 = state_101270__$1;
(statearr_101277_101321[(1)] = (5));

} else {
var statearr_101278_101322 = state_101270__$1;
(statearr_101278_101322[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (15))){
var inst_101243 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101279_101323 = state_101270__$1;
(statearr_101279_101323[(2)] = inst_101243);

(statearr_101279_101323[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (21))){
var inst_101263 = (state_101270[(2)]);
var state_101270__$1 = (function (){var statearr_101280 = state_101270;
(statearr_101280[(9)] = inst_101263);

return statearr_101280;
})();
var statearr_101281_101324 = state_101270__$1;
(statearr_101281_101324[(2)] = null);

(statearr_101281_101324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (13))){
var inst_101225 = (state_101270[(10)]);
var inst_101227 = cljs.core.chunked_seq_QMARK_.call(null,inst_101225);
var state_101270__$1 = state_101270;
if(inst_101227){
var statearr_101282_101325 = state_101270__$1;
(statearr_101282_101325[(1)] = (16));

} else {
var statearr_101283_101326 = state_101270__$1;
(statearr_101283_101326[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (22))){
var inst_101255 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
if(cljs.core.truth_(inst_101255)){
var statearr_101284_101327 = state_101270__$1;
(statearr_101284_101327[(1)] = (23));

} else {
var statearr_101285_101328 = state_101270__$1;
(statearr_101285_101328[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (6))){
var inst_101251 = (state_101270[(11)]);
var inst_101249 = (state_101270[(7)]);
var inst_101201 = (state_101270[(8)]);
var inst_101249__$1 = topic_fn.call(null,inst_101201);
var inst_101250 = cljs.core.deref.call(null,mults);
var inst_101251__$1 = cljs.core.get.call(null,inst_101250,inst_101249__$1);
var state_101270__$1 = (function (){var statearr_101286 = state_101270;
(statearr_101286[(11)] = inst_101251__$1);

(statearr_101286[(7)] = inst_101249__$1);

return statearr_101286;
})();
if(cljs.core.truth_(inst_101251__$1)){
var statearr_101287_101329 = state_101270__$1;
(statearr_101287_101329[(1)] = (19));

} else {
var statearr_101288_101330 = state_101270__$1;
(statearr_101288_101330[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (25))){
var inst_101260 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101289_101331 = state_101270__$1;
(statearr_101289_101331[(2)] = inst_101260);

(statearr_101289_101331[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (17))){
var inst_101225 = (state_101270[(10)]);
var inst_101234 = cljs.core.first.call(null,inst_101225);
var inst_101235 = cljs.core.async.muxch_STAR_.call(null,inst_101234);
var inst_101236 = cljs.core.async.close_BANG_.call(null,inst_101235);
var inst_101237 = cljs.core.next.call(null,inst_101225);
var inst_101211 = inst_101237;
var inst_101212 = null;
var inst_101213 = (0);
var inst_101214 = (0);
var state_101270__$1 = (function (){var statearr_101290 = state_101270;
(statearr_101290[(12)] = inst_101213);

(statearr_101290[(13)] = inst_101236);

(statearr_101290[(14)] = inst_101212);

(statearr_101290[(15)] = inst_101211);

(statearr_101290[(16)] = inst_101214);

return statearr_101290;
})();
var statearr_101291_101332 = state_101270__$1;
(statearr_101291_101332[(2)] = null);

(statearr_101291_101332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (3))){
var inst_101268 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101270__$1,inst_101268);
} else {
if((state_val_101271 === (12))){
var inst_101245 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101292_101333 = state_101270__$1;
(statearr_101292_101333[(2)] = inst_101245);

(statearr_101292_101333[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (2))){
var state_101270__$1 = state_101270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101270__$1,(4),ch);
} else {
if((state_val_101271 === (23))){
var state_101270__$1 = state_101270;
var statearr_101293_101334 = state_101270__$1;
(statearr_101293_101334[(2)] = null);

(statearr_101293_101334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (19))){
var inst_101251 = (state_101270[(11)]);
var inst_101201 = (state_101270[(8)]);
var inst_101253 = cljs.core.async.muxch_STAR_.call(null,inst_101251);
var state_101270__$1 = state_101270;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101270__$1,(22),inst_101253,inst_101201);
} else {
if((state_val_101271 === (11))){
var inst_101211 = (state_101270[(15)]);
var inst_101225 = (state_101270[(10)]);
var inst_101225__$1 = cljs.core.seq.call(null,inst_101211);
var state_101270__$1 = (function (){var statearr_101294 = state_101270;
(statearr_101294[(10)] = inst_101225__$1);

return statearr_101294;
})();
if(inst_101225__$1){
var statearr_101295_101335 = state_101270__$1;
(statearr_101295_101335[(1)] = (13));

} else {
var statearr_101296_101336 = state_101270__$1;
(statearr_101296_101336[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (9))){
var inst_101247 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101297_101337 = state_101270__$1;
(statearr_101297_101337[(2)] = inst_101247);

(statearr_101297_101337[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (5))){
var inst_101208 = cljs.core.deref.call(null,mults);
var inst_101209 = cljs.core.vals.call(null,inst_101208);
var inst_101210 = cljs.core.seq.call(null,inst_101209);
var inst_101211 = inst_101210;
var inst_101212 = null;
var inst_101213 = (0);
var inst_101214 = (0);
var state_101270__$1 = (function (){var statearr_101298 = state_101270;
(statearr_101298[(12)] = inst_101213);

(statearr_101298[(14)] = inst_101212);

(statearr_101298[(15)] = inst_101211);

(statearr_101298[(16)] = inst_101214);

return statearr_101298;
})();
var statearr_101299_101338 = state_101270__$1;
(statearr_101299_101338[(2)] = null);

(statearr_101299_101338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (14))){
var state_101270__$1 = state_101270;
var statearr_101303_101339 = state_101270__$1;
(statearr_101303_101339[(2)] = null);

(statearr_101303_101339[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (16))){
var inst_101225 = (state_101270[(10)]);
var inst_101229 = cljs.core.chunk_first.call(null,inst_101225);
var inst_101230 = cljs.core.chunk_rest.call(null,inst_101225);
var inst_101231 = cljs.core.count.call(null,inst_101229);
var inst_101211 = inst_101230;
var inst_101212 = inst_101229;
var inst_101213 = inst_101231;
var inst_101214 = (0);
var state_101270__$1 = (function (){var statearr_101304 = state_101270;
(statearr_101304[(12)] = inst_101213);

(statearr_101304[(14)] = inst_101212);

(statearr_101304[(15)] = inst_101211);

(statearr_101304[(16)] = inst_101214);

return statearr_101304;
})();
var statearr_101305_101340 = state_101270__$1;
(statearr_101305_101340[(2)] = null);

(statearr_101305_101340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (10))){
var inst_101213 = (state_101270[(12)]);
var inst_101212 = (state_101270[(14)]);
var inst_101211 = (state_101270[(15)]);
var inst_101214 = (state_101270[(16)]);
var inst_101219 = cljs.core._nth.call(null,inst_101212,inst_101214);
var inst_101220 = cljs.core.async.muxch_STAR_.call(null,inst_101219);
var inst_101221 = cljs.core.async.close_BANG_.call(null,inst_101220);
var inst_101222 = (inst_101214 + (1));
var tmp101300 = inst_101213;
var tmp101301 = inst_101212;
var tmp101302 = inst_101211;
var inst_101211__$1 = tmp101302;
var inst_101212__$1 = tmp101301;
var inst_101213__$1 = tmp101300;
var inst_101214__$1 = inst_101222;
var state_101270__$1 = (function (){var statearr_101306 = state_101270;
(statearr_101306[(12)] = inst_101213__$1);

(statearr_101306[(14)] = inst_101212__$1);

(statearr_101306[(17)] = inst_101221);

(statearr_101306[(15)] = inst_101211__$1);

(statearr_101306[(16)] = inst_101214__$1);

return statearr_101306;
})();
var statearr_101307_101341 = state_101270__$1;
(statearr_101307_101341[(2)] = null);

(statearr_101307_101341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (18))){
var inst_101240 = (state_101270[(2)]);
var state_101270__$1 = state_101270;
var statearr_101308_101342 = state_101270__$1;
(statearr_101308_101342[(2)] = inst_101240);

(statearr_101308_101342[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101271 === (8))){
var inst_101213 = (state_101270[(12)]);
var inst_101214 = (state_101270[(16)]);
var inst_101216 = (inst_101214 < inst_101213);
var inst_101217 = inst_101216;
var state_101270__$1 = state_101270;
if(cljs.core.truth_(inst_101217)){
var statearr_101309_101343 = state_101270__$1;
(statearr_101309_101343[(1)] = (10));

} else {
var statearr_101310_101344 = state_101270__$1;
(statearr_101310_101344[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101311[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101311[(1)] = (1));

return statearr_101311;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101270){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101312){if((e101312 instanceof Object)){
var ex__99978__auto__ = e101312;
var statearr_101313_101345 = state_101270;
(statearr_101313_101345[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101270);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101346 = state_101270;
state_101270 = G__101346;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101270){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101314 = f__100070__auto__.call(null);
(statearr_101314[(6)] = c__100069__auto___101316);

return statearr_101314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__101348 = arguments.length;
switch (G__101348) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__101351 = arguments.length;
switch (G__101351) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__101354 = arguments.length;
switch (G__101354) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__100069__auto___101421 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101393){
var state_val_101394 = (state_101393[(1)]);
if((state_val_101394 === (7))){
var state_101393__$1 = state_101393;
var statearr_101395_101422 = state_101393__$1;
(statearr_101395_101422[(2)] = null);

(statearr_101395_101422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (1))){
var state_101393__$1 = state_101393;
var statearr_101396_101423 = state_101393__$1;
(statearr_101396_101423[(2)] = null);

(statearr_101396_101423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (4))){
var inst_101357 = (state_101393[(7)]);
var inst_101359 = (inst_101357 < cnt);
var state_101393__$1 = state_101393;
if(cljs.core.truth_(inst_101359)){
var statearr_101397_101424 = state_101393__$1;
(statearr_101397_101424[(1)] = (6));

} else {
var statearr_101398_101425 = state_101393__$1;
(statearr_101398_101425[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (15))){
var inst_101389 = (state_101393[(2)]);
var state_101393__$1 = state_101393;
var statearr_101399_101426 = state_101393__$1;
(statearr_101399_101426[(2)] = inst_101389);

(statearr_101399_101426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (13))){
var inst_101382 = cljs.core.async.close_BANG_.call(null,out);
var state_101393__$1 = state_101393;
var statearr_101400_101427 = state_101393__$1;
(statearr_101400_101427[(2)] = inst_101382);

(statearr_101400_101427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (6))){
var state_101393__$1 = state_101393;
var statearr_101401_101428 = state_101393__$1;
(statearr_101401_101428[(2)] = null);

(statearr_101401_101428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (3))){
var inst_101391 = (state_101393[(2)]);
var state_101393__$1 = state_101393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101393__$1,inst_101391);
} else {
if((state_val_101394 === (12))){
var inst_101379 = (state_101393[(8)]);
var inst_101379__$1 = (state_101393[(2)]);
var inst_101380 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_101379__$1);
var state_101393__$1 = (function (){var statearr_101402 = state_101393;
(statearr_101402[(8)] = inst_101379__$1);

return statearr_101402;
})();
if(cljs.core.truth_(inst_101380)){
var statearr_101403_101429 = state_101393__$1;
(statearr_101403_101429[(1)] = (13));

} else {
var statearr_101404_101430 = state_101393__$1;
(statearr_101404_101430[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (2))){
var inst_101356 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_101357 = (0);
var state_101393__$1 = (function (){var statearr_101405 = state_101393;
(statearr_101405[(7)] = inst_101357);

(statearr_101405[(9)] = inst_101356);

return statearr_101405;
})();
var statearr_101406_101431 = state_101393__$1;
(statearr_101406_101431[(2)] = null);

(statearr_101406_101431[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (11))){
var inst_101357 = (state_101393[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_101393,(10),Object,null,(9));
var inst_101366 = chs__$1.call(null,inst_101357);
var inst_101367 = done.call(null,inst_101357);
var inst_101368 = cljs.core.async.take_BANG_.call(null,inst_101366,inst_101367);
var state_101393__$1 = state_101393;
var statearr_101407_101432 = state_101393__$1;
(statearr_101407_101432[(2)] = inst_101368);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101393__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (9))){
var inst_101357 = (state_101393[(7)]);
var inst_101370 = (state_101393[(2)]);
var inst_101371 = (inst_101357 + (1));
var inst_101357__$1 = inst_101371;
var state_101393__$1 = (function (){var statearr_101408 = state_101393;
(statearr_101408[(10)] = inst_101370);

(statearr_101408[(7)] = inst_101357__$1);

return statearr_101408;
})();
var statearr_101409_101433 = state_101393__$1;
(statearr_101409_101433[(2)] = null);

(statearr_101409_101433[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (5))){
var inst_101377 = (state_101393[(2)]);
var state_101393__$1 = (function (){var statearr_101410 = state_101393;
(statearr_101410[(11)] = inst_101377);

return statearr_101410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101393__$1,(12),dchan);
} else {
if((state_val_101394 === (14))){
var inst_101379 = (state_101393[(8)]);
var inst_101384 = cljs.core.apply.call(null,f,inst_101379);
var state_101393__$1 = state_101393;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101393__$1,(16),out,inst_101384);
} else {
if((state_val_101394 === (16))){
var inst_101386 = (state_101393[(2)]);
var state_101393__$1 = (function (){var statearr_101411 = state_101393;
(statearr_101411[(12)] = inst_101386);

return statearr_101411;
})();
var statearr_101412_101434 = state_101393__$1;
(statearr_101412_101434[(2)] = null);

(statearr_101412_101434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (10))){
var inst_101361 = (state_101393[(2)]);
var inst_101362 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_101393__$1 = (function (){var statearr_101413 = state_101393;
(statearr_101413[(13)] = inst_101361);

return statearr_101413;
})();
var statearr_101414_101435 = state_101393__$1;
(statearr_101414_101435[(2)] = inst_101362);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101393__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101394 === (8))){
var inst_101375 = (state_101393[(2)]);
var state_101393__$1 = state_101393;
var statearr_101415_101436 = state_101393__$1;
(statearr_101415_101436[(2)] = inst_101375);

(statearr_101415_101436[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101416[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101416[(1)] = (1));

return statearr_101416;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101393){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101417){if((e101417 instanceof Object)){
var ex__99978__auto__ = e101417;
var statearr_101418_101437 = state_101393;
(statearr_101418_101437[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101417;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101438 = state_101393;
state_101393 = G__101438;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101419 = f__100070__auto__.call(null);
(statearr_101419[(6)] = c__100069__auto___101421);

return statearr_101419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__101441 = arguments.length;
switch (G__101441) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101495 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101473){
var state_val_101474 = (state_101473[(1)]);
if((state_val_101474 === (7))){
var inst_101453 = (state_101473[(7)]);
var inst_101452 = (state_101473[(8)]);
var inst_101452__$1 = (state_101473[(2)]);
var inst_101453__$1 = cljs.core.nth.call(null,inst_101452__$1,(0),null);
var inst_101454 = cljs.core.nth.call(null,inst_101452__$1,(1),null);
var inst_101455 = (inst_101453__$1 == null);
var state_101473__$1 = (function (){var statearr_101475 = state_101473;
(statearr_101475[(9)] = inst_101454);

(statearr_101475[(7)] = inst_101453__$1);

(statearr_101475[(8)] = inst_101452__$1);

return statearr_101475;
})();
if(cljs.core.truth_(inst_101455)){
var statearr_101476_101496 = state_101473__$1;
(statearr_101476_101496[(1)] = (8));

} else {
var statearr_101477_101497 = state_101473__$1;
(statearr_101477_101497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (1))){
var inst_101442 = cljs.core.vec.call(null,chs);
var inst_101443 = inst_101442;
var state_101473__$1 = (function (){var statearr_101478 = state_101473;
(statearr_101478[(10)] = inst_101443);

return statearr_101478;
})();
var statearr_101479_101498 = state_101473__$1;
(statearr_101479_101498[(2)] = null);

(statearr_101479_101498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (4))){
var inst_101443 = (state_101473[(10)]);
var state_101473__$1 = state_101473;
return cljs.core.async.ioc_alts_BANG_.call(null,state_101473__$1,(7),inst_101443);
} else {
if((state_val_101474 === (6))){
var inst_101469 = (state_101473[(2)]);
var state_101473__$1 = state_101473;
var statearr_101480_101499 = state_101473__$1;
(statearr_101480_101499[(2)] = inst_101469);

(statearr_101480_101499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (3))){
var inst_101471 = (state_101473[(2)]);
var state_101473__$1 = state_101473;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101473__$1,inst_101471);
} else {
if((state_val_101474 === (2))){
var inst_101443 = (state_101473[(10)]);
var inst_101445 = cljs.core.count.call(null,inst_101443);
var inst_101446 = (inst_101445 > (0));
var state_101473__$1 = state_101473;
if(cljs.core.truth_(inst_101446)){
var statearr_101482_101500 = state_101473__$1;
(statearr_101482_101500[(1)] = (4));

} else {
var statearr_101483_101501 = state_101473__$1;
(statearr_101483_101501[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (11))){
var inst_101443 = (state_101473[(10)]);
var inst_101462 = (state_101473[(2)]);
var tmp101481 = inst_101443;
var inst_101443__$1 = tmp101481;
var state_101473__$1 = (function (){var statearr_101484 = state_101473;
(statearr_101484[(11)] = inst_101462);

(statearr_101484[(10)] = inst_101443__$1);

return statearr_101484;
})();
var statearr_101485_101502 = state_101473__$1;
(statearr_101485_101502[(2)] = null);

(statearr_101485_101502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (9))){
var inst_101453 = (state_101473[(7)]);
var state_101473__$1 = state_101473;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101473__$1,(11),out,inst_101453);
} else {
if((state_val_101474 === (5))){
var inst_101467 = cljs.core.async.close_BANG_.call(null,out);
var state_101473__$1 = state_101473;
var statearr_101486_101503 = state_101473__$1;
(statearr_101486_101503[(2)] = inst_101467);

(statearr_101486_101503[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (10))){
var inst_101465 = (state_101473[(2)]);
var state_101473__$1 = state_101473;
var statearr_101487_101504 = state_101473__$1;
(statearr_101487_101504[(2)] = inst_101465);

(statearr_101487_101504[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101474 === (8))){
var inst_101454 = (state_101473[(9)]);
var inst_101453 = (state_101473[(7)]);
var inst_101452 = (state_101473[(8)]);
var inst_101443 = (state_101473[(10)]);
var inst_101457 = (function (){var cs = inst_101443;
var vec__101448 = inst_101452;
var v = inst_101453;
var c = inst_101454;
return (function (p1__101439_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__101439_SHARP_);
});
})();
var inst_101458 = cljs.core.filterv.call(null,inst_101457,inst_101443);
var inst_101443__$1 = inst_101458;
var state_101473__$1 = (function (){var statearr_101488 = state_101473;
(statearr_101488[(10)] = inst_101443__$1);

return statearr_101488;
})();
var statearr_101489_101505 = state_101473__$1;
(statearr_101489_101505[(2)] = null);

(statearr_101489_101505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101490 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101490[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101490[(1)] = (1));

return statearr_101490;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101473){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101491){if((e101491 instanceof Object)){
var ex__99978__auto__ = e101491;
var statearr_101492_101506 = state_101473;
(statearr_101492_101506[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101507 = state_101473;
state_101473 = G__101507;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101473){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101493 = f__100070__auto__.call(null);
(statearr_101493[(6)] = c__100069__auto___101495);

return statearr_101493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__101509 = arguments.length;
switch (G__101509) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101554 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101533){
var state_val_101534 = (state_101533[(1)]);
if((state_val_101534 === (7))){
var inst_101515 = (state_101533[(7)]);
var inst_101515__$1 = (state_101533[(2)]);
var inst_101516 = (inst_101515__$1 == null);
var inst_101517 = cljs.core.not.call(null,inst_101516);
var state_101533__$1 = (function (){var statearr_101535 = state_101533;
(statearr_101535[(7)] = inst_101515__$1);

return statearr_101535;
})();
if(inst_101517){
var statearr_101536_101555 = state_101533__$1;
(statearr_101536_101555[(1)] = (8));

} else {
var statearr_101537_101556 = state_101533__$1;
(statearr_101537_101556[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (1))){
var inst_101510 = (0);
var state_101533__$1 = (function (){var statearr_101538 = state_101533;
(statearr_101538[(8)] = inst_101510);

return statearr_101538;
})();
var statearr_101539_101557 = state_101533__$1;
(statearr_101539_101557[(2)] = null);

(statearr_101539_101557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (4))){
var state_101533__$1 = state_101533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101533__$1,(7),ch);
} else {
if((state_val_101534 === (6))){
var inst_101528 = (state_101533[(2)]);
var state_101533__$1 = state_101533;
var statearr_101540_101558 = state_101533__$1;
(statearr_101540_101558[(2)] = inst_101528);

(statearr_101540_101558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (3))){
var inst_101530 = (state_101533[(2)]);
var inst_101531 = cljs.core.async.close_BANG_.call(null,out);
var state_101533__$1 = (function (){var statearr_101541 = state_101533;
(statearr_101541[(9)] = inst_101530);

return statearr_101541;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101533__$1,inst_101531);
} else {
if((state_val_101534 === (2))){
var inst_101510 = (state_101533[(8)]);
var inst_101512 = (inst_101510 < n);
var state_101533__$1 = state_101533;
if(cljs.core.truth_(inst_101512)){
var statearr_101542_101559 = state_101533__$1;
(statearr_101542_101559[(1)] = (4));

} else {
var statearr_101543_101560 = state_101533__$1;
(statearr_101543_101560[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (11))){
var inst_101510 = (state_101533[(8)]);
var inst_101520 = (state_101533[(2)]);
var inst_101521 = (inst_101510 + (1));
var inst_101510__$1 = inst_101521;
var state_101533__$1 = (function (){var statearr_101544 = state_101533;
(statearr_101544[(10)] = inst_101520);

(statearr_101544[(8)] = inst_101510__$1);

return statearr_101544;
})();
var statearr_101545_101561 = state_101533__$1;
(statearr_101545_101561[(2)] = null);

(statearr_101545_101561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (9))){
var state_101533__$1 = state_101533;
var statearr_101546_101562 = state_101533__$1;
(statearr_101546_101562[(2)] = null);

(statearr_101546_101562[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (5))){
var state_101533__$1 = state_101533;
var statearr_101547_101563 = state_101533__$1;
(statearr_101547_101563[(2)] = null);

(statearr_101547_101563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (10))){
var inst_101525 = (state_101533[(2)]);
var state_101533__$1 = state_101533;
var statearr_101548_101564 = state_101533__$1;
(statearr_101548_101564[(2)] = inst_101525);

(statearr_101548_101564[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101534 === (8))){
var inst_101515 = (state_101533[(7)]);
var state_101533__$1 = state_101533;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101533__$1,(11),out,inst_101515);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101549 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_101549[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101549[(1)] = (1));

return statearr_101549;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101533){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101550){if((e101550 instanceof Object)){
var ex__99978__auto__ = e101550;
var statearr_101551_101565 = state_101533;
(statearr_101551_101565[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101533);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101550;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101566 = state_101533;
state_101533 = G__101566;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101533){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101552 = f__100070__auto__.call(null);
(statearr_101552[(6)] = c__100069__auto___101554);

return statearr_101552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101568 = (function (f,ch,meta101569){
this.f = f;
this.ch = ch;
this.meta101569 = meta101569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101570,meta101569__$1){
var self__ = this;
var _101570__$1 = this;
return (new cljs.core.async.t_cljs$core$async101568(self__.f,self__.ch,meta101569__$1));
}));

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101570){
var self__ = this;
var _101570__$1 = this;
return self__.meta101569;
}));

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101571 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101571 = (function (f,ch,meta101569,_,fn1,meta101572){
this.f = f;
this.ch = ch;
this.meta101569 = meta101569;
this._ = _;
this.fn1 = fn1;
this.meta101572 = meta101572;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101573,meta101572__$1){
var self__ = this;
var _101573__$1 = this;
return (new cljs.core.async.t_cljs$core$async101571(self__.f,self__.ch,self__.meta101569,self__._,self__.fn1,meta101572__$1));
}));

(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101573){
var self__ = this;
var _101573__$1 = this;
return self__.meta101572;
}));

(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async101571.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__101567_SHARP_){
return f1.call(null,(((p1__101567_SHARP_ == null))?null:self__.f.call(null,p1__101567_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async101571.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta101569","meta101569",-298444198,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async101568","cljs.core.async/t_cljs$core$async101568",2066577948,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta101572","meta101572",1082103960,null)], null);
}));

(cljs.core.async.t_cljs$core$async101571.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101571.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101571");

(cljs.core.async.t_cljs$core$async101571.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async101571");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101571.
 */
cljs.core.async.__GT_t_cljs$core$async101571 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async101571(f__$1,ch__$1,meta101569__$1,___$2,fn1__$1,meta101572){
return (new cljs.core.async.t_cljs$core$async101571(f__$1,ch__$1,meta101569__$1,___$2,fn1__$1,meta101572));
});

}

return (new cljs.core.async.t_cljs$core$async101571(self__.f,self__.ch,self__.meta101569,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101568.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async101568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta101569","meta101569",-298444198,null)], null);
}));

(cljs.core.async.t_cljs$core$async101568.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101568");

(cljs.core.async.t_cljs$core$async101568.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async101568");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101568.
 */
cljs.core.async.__GT_t_cljs$core$async101568 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async101568(f__$1,ch__$1,meta101569){
return (new cljs.core.async.t_cljs$core$async101568(f__$1,ch__$1,meta101569));
});

}

return (new cljs.core.async.t_cljs$core$async101568(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101574 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101574 = (function (f,ch,meta101575){
this.f = f;
this.ch = ch;
this.meta101575 = meta101575;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101576,meta101575__$1){
var self__ = this;
var _101576__$1 = this;
return (new cljs.core.async.t_cljs$core$async101574(self__.f,self__.ch,meta101575__$1));
}));

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101576){
var self__ = this;
var _101576__$1 = this;
return self__.meta101575;
}));

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101574.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async101574.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta101575","meta101575",-1021980272,null)], null);
}));

(cljs.core.async.t_cljs$core$async101574.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101574.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101574");

(cljs.core.async.t_cljs$core$async101574.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async101574");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101574.
 */
cljs.core.async.__GT_t_cljs$core$async101574 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async101574(f__$1,ch__$1,meta101575){
return (new cljs.core.async.t_cljs$core$async101574(f__$1,ch__$1,meta101575));
});

}

return (new cljs.core.async.t_cljs$core$async101574(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async101577 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async101577 = (function (p,ch,meta101578){
this.p = p;
this.ch = ch;
this.meta101578 = meta101578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_101579,meta101578__$1){
var self__ = this;
var _101579__$1 = this;
return (new cljs.core.async.t_cljs$core$async101577(self__.p,self__.ch,meta101578__$1));
}));

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_101579){
var self__ = this;
var _101579__$1 = this;
return self__.meta101578;
}));

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async101577.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async101577.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta101578","meta101578",2146723550,null)], null);
}));

(cljs.core.async.t_cljs$core$async101577.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async101577.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async101577");

(cljs.core.async.t_cljs$core$async101577.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async101577");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async101577.
 */
cljs.core.async.__GT_t_cljs$core$async101577 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async101577(p__$1,ch__$1,meta101578){
return (new cljs.core.async.t_cljs$core$async101577(p__$1,ch__$1,meta101578));
});

}

return (new cljs.core.async.t_cljs$core$async101577(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__101581 = arguments.length;
switch (G__101581) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101621 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101602){
var state_val_101603 = (state_101602[(1)]);
if((state_val_101603 === (7))){
var inst_101598 = (state_101602[(2)]);
var state_101602__$1 = state_101602;
var statearr_101604_101622 = state_101602__$1;
(statearr_101604_101622[(2)] = inst_101598);

(statearr_101604_101622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (1))){
var state_101602__$1 = state_101602;
var statearr_101605_101623 = state_101602__$1;
(statearr_101605_101623[(2)] = null);

(statearr_101605_101623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (4))){
var inst_101584 = (state_101602[(7)]);
var inst_101584__$1 = (state_101602[(2)]);
var inst_101585 = (inst_101584__$1 == null);
var state_101602__$1 = (function (){var statearr_101606 = state_101602;
(statearr_101606[(7)] = inst_101584__$1);

return statearr_101606;
})();
if(cljs.core.truth_(inst_101585)){
var statearr_101607_101624 = state_101602__$1;
(statearr_101607_101624[(1)] = (5));

} else {
var statearr_101608_101625 = state_101602__$1;
(statearr_101608_101625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (6))){
var inst_101584 = (state_101602[(7)]);
var inst_101589 = p.call(null,inst_101584);
var state_101602__$1 = state_101602;
if(cljs.core.truth_(inst_101589)){
var statearr_101609_101626 = state_101602__$1;
(statearr_101609_101626[(1)] = (8));

} else {
var statearr_101610_101627 = state_101602__$1;
(statearr_101610_101627[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (3))){
var inst_101600 = (state_101602[(2)]);
var state_101602__$1 = state_101602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101602__$1,inst_101600);
} else {
if((state_val_101603 === (2))){
var state_101602__$1 = state_101602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101602__$1,(4),ch);
} else {
if((state_val_101603 === (11))){
var inst_101592 = (state_101602[(2)]);
var state_101602__$1 = state_101602;
var statearr_101611_101628 = state_101602__$1;
(statearr_101611_101628[(2)] = inst_101592);

(statearr_101611_101628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (9))){
var state_101602__$1 = state_101602;
var statearr_101612_101629 = state_101602__$1;
(statearr_101612_101629[(2)] = null);

(statearr_101612_101629[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (5))){
var inst_101587 = cljs.core.async.close_BANG_.call(null,out);
var state_101602__$1 = state_101602;
var statearr_101613_101630 = state_101602__$1;
(statearr_101613_101630[(2)] = inst_101587);

(statearr_101613_101630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (10))){
var inst_101595 = (state_101602[(2)]);
var state_101602__$1 = (function (){var statearr_101614 = state_101602;
(statearr_101614[(8)] = inst_101595);

return statearr_101614;
})();
var statearr_101615_101631 = state_101602__$1;
(statearr_101615_101631[(2)] = null);

(statearr_101615_101631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101603 === (8))){
var inst_101584 = (state_101602[(7)]);
var state_101602__$1 = state_101602;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101602__$1,(11),out,inst_101584);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101616 = [null,null,null,null,null,null,null,null,null];
(statearr_101616[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101616[(1)] = (1));

return statearr_101616;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101602){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101617){if((e101617 instanceof Object)){
var ex__99978__auto__ = e101617;
var statearr_101618_101632 = state_101602;
(statearr_101618_101632[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101617;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101633 = state_101602;
state_101602 = G__101633;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101602){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101619 = f__100070__auto__.call(null);
(statearr_101619[(6)] = c__100069__auto___101621);

return statearr_101619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__101635 = arguments.length;
switch (G__101635) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101698){
var state_val_101699 = (state_101698[(1)]);
if((state_val_101699 === (7))){
var inst_101694 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
var statearr_101700_101738 = state_101698__$1;
(statearr_101700_101738[(2)] = inst_101694);

(statearr_101700_101738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (20))){
var inst_101664 = (state_101698[(7)]);
var inst_101675 = (state_101698[(2)]);
var inst_101676 = cljs.core.next.call(null,inst_101664);
var inst_101650 = inst_101676;
var inst_101651 = null;
var inst_101652 = (0);
var inst_101653 = (0);
var state_101698__$1 = (function (){var statearr_101701 = state_101698;
(statearr_101701[(8)] = inst_101651);

(statearr_101701[(9)] = inst_101675);

(statearr_101701[(10)] = inst_101652);

(statearr_101701[(11)] = inst_101653);

(statearr_101701[(12)] = inst_101650);

return statearr_101701;
})();
var statearr_101702_101739 = state_101698__$1;
(statearr_101702_101739[(2)] = null);

(statearr_101702_101739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (1))){
var state_101698__$1 = state_101698;
var statearr_101703_101740 = state_101698__$1;
(statearr_101703_101740[(2)] = null);

(statearr_101703_101740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (4))){
var inst_101639 = (state_101698[(13)]);
var inst_101639__$1 = (state_101698[(2)]);
var inst_101640 = (inst_101639__$1 == null);
var state_101698__$1 = (function (){var statearr_101704 = state_101698;
(statearr_101704[(13)] = inst_101639__$1);

return statearr_101704;
})();
if(cljs.core.truth_(inst_101640)){
var statearr_101705_101741 = state_101698__$1;
(statearr_101705_101741[(1)] = (5));

} else {
var statearr_101706_101742 = state_101698__$1;
(statearr_101706_101742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (15))){
var state_101698__$1 = state_101698;
var statearr_101710_101743 = state_101698__$1;
(statearr_101710_101743[(2)] = null);

(statearr_101710_101743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (21))){
var state_101698__$1 = state_101698;
var statearr_101711_101744 = state_101698__$1;
(statearr_101711_101744[(2)] = null);

(statearr_101711_101744[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (13))){
var inst_101651 = (state_101698[(8)]);
var inst_101652 = (state_101698[(10)]);
var inst_101653 = (state_101698[(11)]);
var inst_101650 = (state_101698[(12)]);
var inst_101660 = (state_101698[(2)]);
var inst_101661 = (inst_101653 + (1));
var tmp101707 = inst_101651;
var tmp101708 = inst_101652;
var tmp101709 = inst_101650;
var inst_101650__$1 = tmp101709;
var inst_101651__$1 = tmp101707;
var inst_101652__$1 = tmp101708;
var inst_101653__$1 = inst_101661;
var state_101698__$1 = (function (){var statearr_101712 = state_101698;
(statearr_101712[(14)] = inst_101660);

(statearr_101712[(8)] = inst_101651__$1);

(statearr_101712[(10)] = inst_101652__$1);

(statearr_101712[(11)] = inst_101653__$1);

(statearr_101712[(12)] = inst_101650__$1);

return statearr_101712;
})();
var statearr_101713_101745 = state_101698__$1;
(statearr_101713_101745[(2)] = null);

(statearr_101713_101745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (22))){
var state_101698__$1 = state_101698;
var statearr_101714_101746 = state_101698__$1;
(statearr_101714_101746[(2)] = null);

(statearr_101714_101746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (6))){
var inst_101639 = (state_101698[(13)]);
var inst_101648 = f.call(null,inst_101639);
var inst_101649 = cljs.core.seq.call(null,inst_101648);
var inst_101650 = inst_101649;
var inst_101651 = null;
var inst_101652 = (0);
var inst_101653 = (0);
var state_101698__$1 = (function (){var statearr_101715 = state_101698;
(statearr_101715[(8)] = inst_101651);

(statearr_101715[(10)] = inst_101652);

(statearr_101715[(11)] = inst_101653);

(statearr_101715[(12)] = inst_101650);

return statearr_101715;
})();
var statearr_101716_101747 = state_101698__$1;
(statearr_101716_101747[(2)] = null);

(statearr_101716_101747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (17))){
var inst_101664 = (state_101698[(7)]);
var inst_101668 = cljs.core.chunk_first.call(null,inst_101664);
var inst_101669 = cljs.core.chunk_rest.call(null,inst_101664);
var inst_101670 = cljs.core.count.call(null,inst_101668);
var inst_101650 = inst_101669;
var inst_101651 = inst_101668;
var inst_101652 = inst_101670;
var inst_101653 = (0);
var state_101698__$1 = (function (){var statearr_101717 = state_101698;
(statearr_101717[(8)] = inst_101651);

(statearr_101717[(10)] = inst_101652);

(statearr_101717[(11)] = inst_101653);

(statearr_101717[(12)] = inst_101650);

return statearr_101717;
})();
var statearr_101718_101748 = state_101698__$1;
(statearr_101718_101748[(2)] = null);

(statearr_101718_101748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (3))){
var inst_101696 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101698__$1,inst_101696);
} else {
if((state_val_101699 === (12))){
var inst_101684 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
var statearr_101719_101749 = state_101698__$1;
(statearr_101719_101749[(2)] = inst_101684);

(statearr_101719_101749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (2))){
var state_101698__$1 = state_101698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101698__$1,(4),in$);
} else {
if((state_val_101699 === (23))){
var inst_101692 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
var statearr_101720_101750 = state_101698__$1;
(statearr_101720_101750[(2)] = inst_101692);

(statearr_101720_101750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (19))){
var inst_101679 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
var statearr_101721_101751 = state_101698__$1;
(statearr_101721_101751[(2)] = inst_101679);

(statearr_101721_101751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (11))){
var inst_101664 = (state_101698[(7)]);
var inst_101650 = (state_101698[(12)]);
var inst_101664__$1 = cljs.core.seq.call(null,inst_101650);
var state_101698__$1 = (function (){var statearr_101722 = state_101698;
(statearr_101722[(7)] = inst_101664__$1);

return statearr_101722;
})();
if(inst_101664__$1){
var statearr_101723_101752 = state_101698__$1;
(statearr_101723_101752[(1)] = (14));

} else {
var statearr_101724_101753 = state_101698__$1;
(statearr_101724_101753[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (9))){
var inst_101686 = (state_101698[(2)]);
var inst_101687 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_101698__$1 = (function (){var statearr_101725 = state_101698;
(statearr_101725[(15)] = inst_101686);

return statearr_101725;
})();
if(cljs.core.truth_(inst_101687)){
var statearr_101726_101754 = state_101698__$1;
(statearr_101726_101754[(1)] = (21));

} else {
var statearr_101727_101755 = state_101698__$1;
(statearr_101727_101755[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (5))){
var inst_101642 = cljs.core.async.close_BANG_.call(null,out);
var state_101698__$1 = state_101698;
var statearr_101728_101756 = state_101698__$1;
(statearr_101728_101756[(2)] = inst_101642);

(statearr_101728_101756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (14))){
var inst_101664 = (state_101698[(7)]);
var inst_101666 = cljs.core.chunked_seq_QMARK_.call(null,inst_101664);
var state_101698__$1 = state_101698;
if(inst_101666){
var statearr_101729_101757 = state_101698__$1;
(statearr_101729_101757[(1)] = (17));

} else {
var statearr_101730_101758 = state_101698__$1;
(statearr_101730_101758[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (16))){
var inst_101682 = (state_101698[(2)]);
var state_101698__$1 = state_101698;
var statearr_101731_101759 = state_101698__$1;
(statearr_101731_101759[(2)] = inst_101682);

(statearr_101731_101759[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101699 === (10))){
var inst_101651 = (state_101698[(8)]);
var inst_101653 = (state_101698[(11)]);
var inst_101658 = cljs.core._nth.call(null,inst_101651,inst_101653);
var state_101698__$1 = state_101698;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101698__$1,(13),out,inst_101658);
} else {
if((state_val_101699 === (18))){
var inst_101664 = (state_101698[(7)]);
var inst_101673 = cljs.core.first.call(null,inst_101664);
var state_101698__$1 = state_101698;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101698__$1,(20),out,inst_101673);
} else {
if((state_val_101699 === (8))){
var inst_101652 = (state_101698[(10)]);
var inst_101653 = (state_101698[(11)]);
var inst_101655 = (inst_101653 < inst_101652);
var inst_101656 = inst_101655;
var state_101698__$1 = state_101698;
if(cljs.core.truth_(inst_101656)){
var statearr_101732_101760 = state_101698__$1;
(statearr_101732_101760[(1)] = (10));

} else {
var statearr_101733_101761 = state_101698__$1;
(statearr_101733_101761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____0 = (function (){
var statearr_101734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101734[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__);

(statearr_101734[(1)] = (1));

return statearr_101734;
});
var cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____1 = (function (state_101698){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101698);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101735){if((e101735 instanceof Object)){
var ex__99978__auto__ = e101735;
var statearr_101736_101762 = state_101698;
(statearr_101736_101762[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101698);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101763 = state_101698;
state_101698 = G__101763;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__ = function(state_101698){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____1.call(this,state_101698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__99975__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101737 = f__100070__auto__.call(null);
(statearr_101737[(6)] = c__100069__auto__);

return statearr_101737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__101765 = arguments.length;
switch (G__101765) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__101768 = arguments.length;
switch (G__101768) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__101771 = arguments.length;
switch (G__101771) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101818 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101795){
var state_val_101796 = (state_101795[(1)]);
if((state_val_101796 === (7))){
var inst_101790 = (state_101795[(2)]);
var state_101795__$1 = state_101795;
var statearr_101797_101819 = state_101795__$1;
(statearr_101797_101819[(2)] = inst_101790);

(statearr_101797_101819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (1))){
var inst_101772 = null;
var state_101795__$1 = (function (){var statearr_101798 = state_101795;
(statearr_101798[(7)] = inst_101772);

return statearr_101798;
})();
var statearr_101799_101820 = state_101795__$1;
(statearr_101799_101820[(2)] = null);

(statearr_101799_101820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (4))){
var inst_101775 = (state_101795[(8)]);
var inst_101775__$1 = (state_101795[(2)]);
var inst_101776 = (inst_101775__$1 == null);
var inst_101777 = cljs.core.not.call(null,inst_101776);
var state_101795__$1 = (function (){var statearr_101800 = state_101795;
(statearr_101800[(8)] = inst_101775__$1);

return statearr_101800;
})();
if(inst_101777){
var statearr_101801_101821 = state_101795__$1;
(statearr_101801_101821[(1)] = (5));

} else {
var statearr_101802_101822 = state_101795__$1;
(statearr_101802_101822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (6))){
var state_101795__$1 = state_101795;
var statearr_101803_101823 = state_101795__$1;
(statearr_101803_101823[(2)] = null);

(statearr_101803_101823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (3))){
var inst_101792 = (state_101795[(2)]);
var inst_101793 = cljs.core.async.close_BANG_.call(null,out);
var state_101795__$1 = (function (){var statearr_101804 = state_101795;
(statearr_101804[(9)] = inst_101792);

return statearr_101804;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101795__$1,inst_101793);
} else {
if((state_val_101796 === (2))){
var state_101795__$1 = state_101795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101795__$1,(4),ch);
} else {
if((state_val_101796 === (11))){
var inst_101775 = (state_101795[(8)]);
var inst_101784 = (state_101795[(2)]);
var inst_101772 = inst_101775;
var state_101795__$1 = (function (){var statearr_101805 = state_101795;
(statearr_101805[(10)] = inst_101784);

(statearr_101805[(7)] = inst_101772);

return statearr_101805;
})();
var statearr_101806_101824 = state_101795__$1;
(statearr_101806_101824[(2)] = null);

(statearr_101806_101824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (9))){
var inst_101775 = (state_101795[(8)]);
var state_101795__$1 = state_101795;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101795__$1,(11),out,inst_101775);
} else {
if((state_val_101796 === (5))){
var inst_101775 = (state_101795[(8)]);
var inst_101772 = (state_101795[(7)]);
var inst_101779 = cljs.core._EQ_.call(null,inst_101775,inst_101772);
var state_101795__$1 = state_101795;
if(inst_101779){
var statearr_101808_101825 = state_101795__$1;
(statearr_101808_101825[(1)] = (8));

} else {
var statearr_101809_101826 = state_101795__$1;
(statearr_101809_101826[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (10))){
var inst_101787 = (state_101795[(2)]);
var state_101795__$1 = state_101795;
var statearr_101810_101827 = state_101795__$1;
(statearr_101810_101827[(2)] = inst_101787);

(statearr_101810_101827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101796 === (8))){
var inst_101772 = (state_101795[(7)]);
var tmp101807 = inst_101772;
var inst_101772__$1 = tmp101807;
var state_101795__$1 = (function (){var statearr_101811 = state_101795;
(statearr_101811[(7)] = inst_101772__$1);

return statearr_101811;
})();
var statearr_101812_101828 = state_101795__$1;
(statearr_101812_101828[(2)] = null);

(statearr_101812_101828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101813 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_101813[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101813[(1)] = (1));

return statearr_101813;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101795){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101814){if((e101814 instanceof Object)){
var ex__99978__auto__ = e101814;
var statearr_101815_101829 = state_101795;
(statearr_101815_101829[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101830 = state_101795;
state_101795 = G__101830;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101795){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101816 = f__100070__auto__.call(null);
(statearr_101816[(6)] = c__100069__auto___101818);

return statearr_101816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__101832 = arguments.length;
switch (G__101832) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101898 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101870){
var state_val_101871 = (state_101870[(1)]);
if((state_val_101871 === (7))){
var inst_101866 = (state_101870[(2)]);
var state_101870__$1 = state_101870;
var statearr_101872_101899 = state_101870__$1;
(statearr_101872_101899[(2)] = inst_101866);

(statearr_101872_101899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (1))){
var inst_101833 = (new Array(n));
var inst_101834 = inst_101833;
var inst_101835 = (0);
var state_101870__$1 = (function (){var statearr_101873 = state_101870;
(statearr_101873[(7)] = inst_101834);

(statearr_101873[(8)] = inst_101835);

return statearr_101873;
})();
var statearr_101874_101900 = state_101870__$1;
(statearr_101874_101900[(2)] = null);

(statearr_101874_101900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (4))){
var inst_101838 = (state_101870[(9)]);
var inst_101838__$1 = (state_101870[(2)]);
var inst_101839 = (inst_101838__$1 == null);
var inst_101840 = cljs.core.not.call(null,inst_101839);
var state_101870__$1 = (function (){var statearr_101875 = state_101870;
(statearr_101875[(9)] = inst_101838__$1);

return statearr_101875;
})();
if(inst_101840){
var statearr_101876_101901 = state_101870__$1;
(statearr_101876_101901[(1)] = (5));

} else {
var statearr_101877_101902 = state_101870__$1;
(statearr_101877_101902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (15))){
var inst_101860 = (state_101870[(2)]);
var state_101870__$1 = state_101870;
var statearr_101878_101903 = state_101870__$1;
(statearr_101878_101903[(2)] = inst_101860);

(statearr_101878_101903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (13))){
var state_101870__$1 = state_101870;
var statearr_101879_101904 = state_101870__$1;
(statearr_101879_101904[(2)] = null);

(statearr_101879_101904[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (6))){
var inst_101835 = (state_101870[(8)]);
var inst_101856 = (inst_101835 > (0));
var state_101870__$1 = state_101870;
if(cljs.core.truth_(inst_101856)){
var statearr_101880_101905 = state_101870__$1;
(statearr_101880_101905[(1)] = (12));

} else {
var statearr_101881_101906 = state_101870__$1;
(statearr_101881_101906[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (3))){
var inst_101868 = (state_101870[(2)]);
var state_101870__$1 = state_101870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101870__$1,inst_101868);
} else {
if((state_val_101871 === (12))){
var inst_101834 = (state_101870[(7)]);
var inst_101858 = cljs.core.vec.call(null,inst_101834);
var state_101870__$1 = state_101870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101870__$1,(15),out,inst_101858);
} else {
if((state_val_101871 === (2))){
var state_101870__$1 = state_101870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101870__$1,(4),ch);
} else {
if((state_val_101871 === (11))){
var inst_101850 = (state_101870[(2)]);
var inst_101851 = (new Array(n));
var inst_101834 = inst_101851;
var inst_101835 = (0);
var state_101870__$1 = (function (){var statearr_101882 = state_101870;
(statearr_101882[(7)] = inst_101834);

(statearr_101882[(8)] = inst_101835);

(statearr_101882[(10)] = inst_101850);

return statearr_101882;
})();
var statearr_101883_101907 = state_101870__$1;
(statearr_101883_101907[(2)] = null);

(statearr_101883_101907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (9))){
var inst_101834 = (state_101870[(7)]);
var inst_101848 = cljs.core.vec.call(null,inst_101834);
var state_101870__$1 = state_101870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101870__$1,(11),out,inst_101848);
} else {
if((state_val_101871 === (5))){
var inst_101834 = (state_101870[(7)]);
var inst_101835 = (state_101870[(8)]);
var inst_101843 = (state_101870[(11)]);
var inst_101838 = (state_101870[(9)]);
var inst_101842 = (inst_101834[inst_101835] = inst_101838);
var inst_101843__$1 = (inst_101835 + (1));
var inst_101844 = (inst_101843__$1 < n);
var state_101870__$1 = (function (){var statearr_101884 = state_101870;
(statearr_101884[(12)] = inst_101842);

(statearr_101884[(11)] = inst_101843__$1);

return statearr_101884;
})();
if(cljs.core.truth_(inst_101844)){
var statearr_101885_101908 = state_101870__$1;
(statearr_101885_101908[(1)] = (8));

} else {
var statearr_101886_101909 = state_101870__$1;
(statearr_101886_101909[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (14))){
var inst_101863 = (state_101870[(2)]);
var inst_101864 = cljs.core.async.close_BANG_.call(null,out);
var state_101870__$1 = (function (){var statearr_101888 = state_101870;
(statearr_101888[(13)] = inst_101863);

return statearr_101888;
})();
var statearr_101889_101910 = state_101870__$1;
(statearr_101889_101910[(2)] = inst_101864);

(statearr_101889_101910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (10))){
var inst_101854 = (state_101870[(2)]);
var state_101870__$1 = state_101870;
var statearr_101890_101911 = state_101870__$1;
(statearr_101890_101911[(2)] = inst_101854);

(statearr_101890_101911[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101871 === (8))){
var inst_101834 = (state_101870[(7)]);
var inst_101843 = (state_101870[(11)]);
var tmp101887 = inst_101834;
var inst_101834__$1 = tmp101887;
var inst_101835 = inst_101843;
var state_101870__$1 = (function (){var statearr_101891 = state_101870;
(statearr_101891[(7)] = inst_101834__$1);

(statearr_101891[(8)] = inst_101835);

return statearr_101891;
})();
var statearr_101892_101912 = state_101870__$1;
(statearr_101892_101912[(2)] = null);

(statearr_101892_101912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101893[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101893[(1)] = (1));

return statearr_101893;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101870){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101894){if((e101894 instanceof Object)){
var ex__99978__auto__ = e101894;
var statearr_101895_101913 = state_101870;
(statearr_101895_101913[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__101914 = state_101870;
state_101870 = G__101914;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101896 = f__100070__auto__.call(null);
(statearr_101896[(6)] = c__100069__auto___101898);

return statearr_101896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__101916 = arguments.length;
switch (G__101916) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__100069__auto___101986 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_101958){
var state_val_101959 = (state_101958[(1)]);
if((state_val_101959 === (7))){
var inst_101954 = (state_101958[(2)]);
var state_101958__$1 = state_101958;
var statearr_101960_101987 = state_101958__$1;
(statearr_101960_101987[(2)] = inst_101954);

(statearr_101960_101987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (1))){
var inst_101917 = [];
var inst_101918 = inst_101917;
var inst_101919 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_101958__$1 = (function (){var statearr_101961 = state_101958;
(statearr_101961[(7)] = inst_101918);

(statearr_101961[(8)] = inst_101919);

return statearr_101961;
})();
var statearr_101962_101988 = state_101958__$1;
(statearr_101962_101988[(2)] = null);

(statearr_101962_101988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (4))){
var inst_101922 = (state_101958[(9)]);
var inst_101922__$1 = (state_101958[(2)]);
var inst_101923 = (inst_101922__$1 == null);
var inst_101924 = cljs.core.not.call(null,inst_101923);
var state_101958__$1 = (function (){var statearr_101963 = state_101958;
(statearr_101963[(9)] = inst_101922__$1);

return statearr_101963;
})();
if(inst_101924){
var statearr_101964_101989 = state_101958__$1;
(statearr_101964_101989[(1)] = (5));

} else {
var statearr_101965_101990 = state_101958__$1;
(statearr_101965_101990[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (15))){
var inst_101948 = (state_101958[(2)]);
var state_101958__$1 = state_101958;
var statearr_101966_101991 = state_101958__$1;
(statearr_101966_101991[(2)] = inst_101948);

(statearr_101966_101991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (13))){
var state_101958__$1 = state_101958;
var statearr_101967_101992 = state_101958__$1;
(statearr_101967_101992[(2)] = null);

(statearr_101967_101992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (6))){
var inst_101918 = (state_101958[(7)]);
var inst_101943 = inst_101918.length;
var inst_101944 = (inst_101943 > (0));
var state_101958__$1 = state_101958;
if(cljs.core.truth_(inst_101944)){
var statearr_101968_101993 = state_101958__$1;
(statearr_101968_101993[(1)] = (12));

} else {
var statearr_101969_101994 = state_101958__$1;
(statearr_101969_101994[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (3))){
var inst_101956 = (state_101958[(2)]);
var state_101958__$1 = state_101958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_101958__$1,inst_101956);
} else {
if((state_val_101959 === (12))){
var inst_101918 = (state_101958[(7)]);
var inst_101946 = cljs.core.vec.call(null,inst_101918);
var state_101958__$1 = state_101958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101958__$1,(15),out,inst_101946);
} else {
if((state_val_101959 === (2))){
var state_101958__$1 = state_101958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_101958__$1,(4),ch);
} else {
if((state_val_101959 === (11))){
var inst_101926 = (state_101958[(10)]);
var inst_101922 = (state_101958[(9)]);
var inst_101936 = (state_101958[(2)]);
var inst_101937 = [];
var inst_101938 = inst_101937.push(inst_101922);
var inst_101918 = inst_101937;
var inst_101919 = inst_101926;
var state_101958__$1 = (function (){var statearr_101970 = state_101958;
(statearr_101970[(11)] = inst_101936);

(statearr_101970[(7)] = inst_101918);

(statearr_101970[(8)] = inst_101919);

(statearr_101970[(12)] = inst_101938);

return statearr_101970;
})();
var statearr_101971_101995 = state_101958__$1;
(statearr_101971_101995[(2)] = null);

(statearr_101971_101995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (9))){
var inst_101918 = (state_101958[(7)]);
var inst_101934 = cljs.core.vec.call(null,inst_101918);
var state_101958__$1 = state_101958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_101958__$1,(11),out,inst_101934);
} else {
if((state_val_101959 === (5))){
var inst_101926 = (state_101958[(10)]);
var inst_101922 = (state_101958[(9)]);
var inst_101919 = (state_101958[(8)]);
var inst_101926__$1 = f.call(null,inst_101922);
var inst_101927 = cljs.core._EQ_.call(null,inst_101926__$1,inst_101919);
var inst_101928 = cljs.core.keyword_identical_QMARK_.call(null,inst_101919,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_101929 = ((inst_101927) || (inst_101928));
var state_101958__$1 = (function (){var statearr_101972 = state_101958;
(statearr_101972[(10)] = inst_101926__$1);

return statearr_101972;
})();
if(cljs.core.truth_(inst_101929)){
var statearr_101973_101996 = state_101958__$1;
(statearr_101973_101996[(1)] = (8));

} else {
var statearr_101974_101997 = state_101958__$1;
(statearr_101974_101997[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (14))){
var inst_101951 = (state_101958[(2)]);
var inst_101952 = cljs.core.async.close_BANG_.call(null,out);
var state_101958__$1 = (function (){var statearr_101976 = state_101958;
(statearr_101976[(13)] = inst_101951);

return statearr_101976;
})();
var statearr_101977_101998 = state_101958__$1;
(statearr_101977_101998[(2)] = inst_101952);

(statearr_101977_101998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (10))){
var inst_101941 = (state_101958[(2)]);
var state_101958__$1 = state_101958;
var statearr_101978_101999 = state_101958__$1;
(statearr_101978_101999[(2)] = inst_101941);

(statearr_101978_101999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_101959 === (8))){
var inst_101926 = (state_101958[(10)]);
var inst_101918 = (state_101958[(7)]);
var inst_101922 = (state_101958[(9)]);
var inst_101931 = inst_101918.push(inst_101922);
var tmp101975 = inst_101918;
var inst_101918__$1 = tmp101975;
var inst_101919 = inst_101926;
var state_101958__$1 = (function (){var statearr_101979 = state_101958;
(statearr_101979[(7)] = inst_101918__$1);

(statearr_101979[(8)] = inst_101919);

(statearr_101979[(14)] = inst_101931);

return statearr_101979;
})();
var statearr_101980_102000 = state_101958__$1;
(statearr_101980_102000[(2)] = null);

(statearr_101980_102000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__99975__auto__ = null;
var cljs$core$async$state_machine__99975__auto____0 = (function (){
var statearr_101981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101981[(0)] = cljs$core$async$state_machine__99975__auto__);

(statearr_101981[(1)] = (1));

return statearr_101981;
});
var cljs$core$async$state_machine__99975__auto____1 = (function (state_101958){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_101958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e101982){if((e101982 instanceof Object)){
var ex__99978__auto__ = e101982;
var statearr_101983_102001 = state_101958;
(statearr_101983_102001[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_101958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e101982;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__102002 = state_101958;
state_101958 = G__102002;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
cljs$core$async$state_machine__99975__auto__ = function(state_101958){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__99975__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__99975__auto____1.call(this,state_101958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__99975__auto____0;
cljs$core$async$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__99975__auto____1;
return cljs$core$async$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_101984 = f__100070__auto__.call(null);
(statearr_101984[(6)] = c__100069__auto___101986);

return statearr_101984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

