// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__105067 = cljs.core._EQ_;
var expr__105068 = e.getLastErrorCode();
if(cljs.core.truth_((pred__105067.cljs$core$IFn$_invoke$arity$2 ? pred__105067.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__105068) : pred__105067.call(null,goog.net.ErrorCode.NO_ERROR,expr__105068)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__105067.cljs$core$IFn$_invoke$arity$2 ? pred__105067.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__105068) : pred__105067.call(null,goog.net.ErrorCode.EXCEPTION,expr__105068)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__105067.cljs$core$IFn$_invoke$arity$2 ? pred__105067.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__105068) : pred__105067.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__105068)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__105067.cljs$core$IFn$_invoke$arity$2 ? pred__105067.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__105068) : pred__105067.call(null,goog.net.ErrorCode.ABORT,expr__105068)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__105067.cljs$core$IFn$_invoke$arity$2 ? pred__105067.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__105068) : pred__105067.call(null,goog.net.ErrorCode.TIMEOUT,expr__105068)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4120__auto__ = status;
if(cljs.core.truth_(and__4120__auto__)){
return (status > (0));
} else {
return and__4120__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__105070 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__105070,cljs.core.cst$kw$status,status);
} else {
return G__105070;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__105071 = opts;
var map__105071__$1 = (((((!((map__105071 == null))))?(((((map__105071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105071.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105071):map__105071);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__105071__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105071__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105071__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__105073 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__105073__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__105073,headers], 0)):G__105073);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__105073__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__105073__$1;
}
})();
try{var G__105075_105081 = url;
var G__105076_105082 = ((function (G__105075_105081,map__105071,map__105071__$1,request_timeout,token,headers,response_chan,headers__$1){
return (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});})(G__105075_105081,map__105071,map__105071__$1,request_timeout,token,headers,response_chan,headers__$1))
;
var G__105077_105083 = "POST";
var G__105078_105084 = fluree.db.util.json.stringify(message);
var G__105079_105085 = cljs.core.clj__GT_js(headers__$1);
var G__105080_105086 = request_timeout;
goog.net.XhrIo.send(G__105075_105081,G__105076_105082,G__105077_105083,G__105078_105084,G__105079_105085,G__105080_105086);
}catch (e105074){var e_105087 = e105074;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_105087);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__105088 = opts;
var map__105088__$1 = (((((!((map__105088 == null))))?(((((map__105088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105088.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105088):map__105088);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__105088__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105088__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105088__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105088__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__105088__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__105090 = cljs.core.PersistentArrayMap.EMPTY;
var G__105090__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__105090,headers], 0)):G__105090);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__105090__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__105090__$1;
}
})();
try{var G__105092_105099 = url;
var G__105093_105100 = ((function (G__105092_105099,map__105088,map__105088__$1,request_timeout,token,headers,body,output_format,response_chan,headers__$1){
return (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__105098 = output_format;
var G__105098__$1 = (((G__105098 instanceof cljs.core.Keyword))?G__105098.fqn:null);
switch (G__105098__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});})(G__105092_105099,map__105088,map__105088__$1,request_timeout,token,headers,body,output_format,response_chan,headers__$1))
;
var G__105094_105101 = "GET";
var G__105095_105102 = body;
var G__105096_105103 = cljs.core.clj__GT_js(headers__$1);
var G__105097_105104 = request_timeout;
goog.net.XhrIo.send(G__105092_105099,G__105093_105100,G__105094_105101,G__105095_105102,G__105096_105103,G__105097_105104);
}catch (e105091){var e_105106 = e105091;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_105106);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__105107 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__105107,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__105107;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105137){
var state_val_105138 = (state_105137[(1)]);
if((state_val_105138 === (7))){
var inst_105133 = (state_105137[(2)]);
var state_105137__$1 = state_105137;
var statearr_105139_105157 = state_105137__$1;
(statearr_105139_105157[(2)] = inst_105133);

(statearr_105139_105157[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (1))){
var state_105137__$1 = state_105137;
var statearr_105140_105158 = state_105137__$1;
(statearr_105140_105158[(2)] = null);

(statearr_105140_105158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (4))){
var inst_105111 = (state_105137[(7)]);
var inst_105111__$1 = (state_105137[(2)]);
var inst_105112 = (inst_105111__$1 == null);
var state_105137__$1 = (function (){var statearr_105141 = state_105137;
(statearr_105141[(7)] = inst_105111__$1);

return statearr_105141;
})();
if(cljs.core.truth_(inst_105112)){
var statearr_105142_105159 = state_105137__$1;
(statearr_105142_105159[(1)] = (5));

} else {
var statearr_105143_105160 = state_105137__$1;
(statearr_105143_105160[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (6))){
var inst_105111 = (state_105137[(7)]);
var inst_105119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105111,(0),null);
var inst_105120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105111,(1),null);
var state_105137__$1 = (function (){var statearr_105144 = state_105137;
(statearr_105144[(8)] = inst_105120);

(statearr_105144[(9)] = inst_105119);

return statearr_105144;
})();
var statearr_105145_105161 = state_105137__$1;
(statearr_105145_105161[(2)] = null);

(statearr_105145_105161[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (3))){
var inst_105135 = (state_105137[(2)]);
var state_105137__$1 = state_105137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105137__$1,inst_105135);
} else {
if((state_val_105138 === (2))){
var state_105137__$1 = state_105137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105137__$1,(4),pub_chan);
} else {
if((state_val_105138 === (9))){
var inst_105120 = (state_105137[(8)]);
var inst_105121 = (state_105137[(2)]);
var inst_105122 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_105121,"Websocket send message error:",inst_105121], 0));
var inst_105123 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_105120,false);
var state_105137__$1 = (function (){var statearr_105146 = state_105137;
(statearr_105146[(10)] = inst_105122);

return statearr_105146;
})();
var statearr_105147_105162 = state_105137__$1;
(statearr_105147_105162[(2)] = inst_105123);


cljs.core.async.impl.ioc_helpers.process_exception(state_105137__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (5))){
var inst_105114 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_105137__$1 = state_105137;
var statearr_105148_105163 = state_105137__$1;
(statearr_105148_105163[(2)] = inst_105114);

(statearr_105148_105163[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (10))){
var inst_105120 = (state_105137[(8)]);
var inst_105119 = (state_105137[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105137,(9),Error,null,(8));
var inst_105127 = ws.send(inst_105119);
var inst_105128 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_105120,true);
var state_105137__$1 = (function (){var statearr_105149 = state_105137;
(statearr_105149[(11)] = inst_105127);

return statearr_105149;
})();
var statearr_105150_105164 = state_105137__$1;
(statearr_105150_105164[(2)] = inst_105128);


cljs.core.async.impl.ioc_helpers.process_exception(state_105137__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105138 === (8))){
var inst_105130 = (state_105137[(2)]);
var state_105137__$1 = (function (){var statearr_105151 = state_105137;
(statearr_105151[(12)] = inst_105130);

return statearr_105151;
})();
var statearr_105152_105165 = state_105137__$1;
(statearr_105152_105165[(2)] = null);

(statearr_105152_105165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____0 = (function (){
var statearr_105153 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_105153[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__);

(statearr_105153[(1)] = (1));

return statearr_105153;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____1 = (function (state_105137){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105137);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105154){if((e105154 instanceof Object)){
var ex__99040__auto__ = e105154;
var statearr_105155_105166 = state_105137;
(statearr_105155_105166[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105137);

return cljs.core.cst$kw$recur;
} else {
throw e105154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105167 = state_105137;
state_105137 = G__105167;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__ = function(state_105137){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____1.call(this,state_105137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105156 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105156[(6)] = c__99059__auto__);

return statearr_105156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
ws.binaryType = "arraybuffer";

ws.onopen = ((function (ws,open_QMARK_,timeout_chan){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
});})(ws,open_QMARK_,timeout_chan))
;

ws.onmessage = ((function (ws,open_QMARK_,timeout_chan){
return (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
});})(ws,open_QMARK_,timeout_chan))
;

ws.onclose = ((function (ws,open_QMARK_,timeout_chan){
return (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
});})(ws,open_QMARK_,timeout_chan))
;

var c__99059__auto___105205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___105205,ws,open_QMARK_,timeout_chan){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___105205,ws,open_QMARK_,timeout_chan){
return (function (state_105193){
var state_val_105194 = (state_105193[(1)]);
if((state_val_105194 === (1))){
var inst_105172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105173 = [open_QMARK_,timeout_chan];
var inst_105174 = (new cljs.core.PersistentVector(null,2,(5),inst_105172,inst_105173,null));
var state_105193__$1 = state_105193;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_105193__$1,(2),inst_105174,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_105194 === (2))){
var inst_105176 = (state_105193[(2)]);
var inst_105177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105176,(0),null);
var inst_105178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_105176,(1),null);
var inst_105179 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_105178,timeout_chan);
var state_105193__$1 = (function (){var statearr_105195 = state_105193;
(statearr_105195[(7)] = inst_105177);

return statearr_105195;
})();
if(inst_105179){
var statearr_105196_105206 = state_105193__$1;
(statearr_105196_105206[(1)] = (3));

} else {
var statearr_105197_105207 = state_105193__$1;
(statearr_105197_105207[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105194 === (3))){
var inst_105181 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_105182 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105183 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_105184 = cljs.core.PersistentHashMap.fromArrays(inst_105182,inst_105183);
var inst_105185 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105181,inst_105184);
var inst_105186 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_105185);
var inst_105187 = fluree.db.util.xhttp.close_websocket(ws);
var state_105193__$1 = (function (){var statearr_105198 = state_105193;
(statearr_105198[(8)] = inst_105186);

return statearr_105198;
})();
var statearr_105199_105208 = state_105193__$1;
(statearr_105199_105208[(2)] = inst_105187);

(statearr_105199_105208[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105194 === (4))){
var inst_105189 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_105193__$1 = state_105193;
var statearr_105200_105209 = state_105193__$1;
(statearr_105200_105209[(2)] = inst_105189);

(statearr_105200_105209[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105194 === (5))){
var inst_105191 = (state_105193[(2)]);
var state_105193__$1 = state_105193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105193__$1,inst_105191);
} else {
return null;
}
}
}
}
}
});})(c__99059__auto___105205,ws,open_QMARK_,timeout_chan))
;
return ((function (switch__99036__auto__,c__99059__auto___105205,ws,open_QMARK_,timeout_chan){
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____0 = (function (){
var statearr_105201 = [null,null,null,null,null,null,null,null,null];
(statearr_105201[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__);

(statearr_105201[(1)] = (1));

return statearr_105201;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____1 = (function (state_105193){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105193);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105202){if((e105202 instanceof Object)){
var ex__99040__auto__ = e105202;
var statearr_105203_105210 = state_105193;
(statearr_105203_105210[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105193);

return cljs.core.cst$kw$recur;
} else {
throw e105202;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105211 = state_105193;
state_105193 = G__105211;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__ = function(state_105193){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____1.call(this,state_105193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___105205,ws,open_QMARK_,timeout_chan))
})();
var state__99061__auto__ = (function (){var statearr_105204 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105204[(6)] = c__99059__auto___105205);

return statearr_105204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___105205,ws,open_QMARK_,timeout_chan))
);


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});

//# sourceMappingURL=xhttp.js.map?rel=1593118617544
