// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.time_travel');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.range');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
/**
 * Given a duration, returns a ISO-8601 formatted time string of now minus duration
 */
fluree.db.time_travel.duration_parse = (function fluree$db$time_travel$duration_parse(time_str){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Duration timeframes not yet supported in javascript.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_platform_DASH_support], null));
});
fluree.db.time_travel.time_to_t = (function fluree$db$time_travel$time_to_t(db,time_str){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104454){
var state_val_104455 = (state_104454[(1)]);
if((state_val_104455 === (7))){
var inst_104407 = (state_104454[(7)]);
var inst_104405 = (state_104454[(2)]);
var inst_104407__$1 = fluree.db.dbproto._rootdb(db);
var inst_104408 = (inst_104407__$1 == null);
var state_104454__$1 = (function (){var statearr_104456 = state_104454;
(statearr_104456[(8)] = inst_104405);

(statearr_104456[(7)] = inst_104407__$1);

return statearr_104456;
})();
if(cljs.core.truth_(inst_104408)){
var statearr_104457_104491 = state_104454__$1;
(statearr_104457_104491[(1)] = (8));

} else {
var statearr_104458_104492 = state_104454__$1;
(statearr_104458_104492[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (20))){
var inst_104450 = (state_104454[(2)]);
var state_104454__$1 = state_104454;
var statearr_104459_104493 = state_104454__$1;
(statearr_104459_104493[(2)] = inst_104450);


cljs.core.async.impl.ioc_helpers.process_exception(state_104454__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (1))){
var state_104454__$1 = state_104454;
var statearr_104460_104494 = state_104454__$1;
(statearr_104460_104494[(2)] = null);

(statearr_104460_104494[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104454,(3),Error,null,(2));
var inst_104400 = typeof time_str === 'string';
var state_104454__$1 = state_104454;
if(cljs.core.truth_(inst_104400)){
var statearr_104461_104495 = state_104454__$1;
(statearr_104461_104495[(1)] = (5));

} else {
var statearr_104462_104496 = state_104454__$1;
(statearr_104462_104496[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (15))){
var inst_104405 = (state_104454[(8)]);
var inst_104430 = ["There is no data as of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104405)].join('');
var inst_104431 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104432 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_block];
var inst_104433 = cljs.core.PersistentHashMap.fromArrays(inst_104431,inst_104432);
var inst_104434 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_104430,inst_104433);
var inst_104435 = (function(){throw inst_104434})();
var state_104454__$1 = state_104454;
var statearr_104463_104497 = state_104454__$1;
(statearr_104463_104497[(2)] = inst_104435);

(statearr_104463_104497[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (21))){
var inst_104440 = (state_104454[(9)]);
var state_104454__$1 = state_104454;
var statearr_104464_104498 = state_104454__$1;
(statearr_104464_104498[(2)] = inst_104440);

(statearr_104464_104498[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (13))){
var inst_104427 = (state_104454[(10)]);
var inst_104427__$1 = (state_104454[(2)]);
var inst_104428 = cljs.core.empty_QMARK_(inst_104427__$1);
var state_104454__$1 = (function (){var statearr_104465 = state_104454;
(statearr_104465[(10)] = inst_104427__$1);

return statearr_104465;
})();
if(inst_104428){
var statearr_104466_104499 = state_104454__$1;
(statearr_104466_104499[(1)] = (15));

} else {
var statearr_104467_104500 = state_104454__$1;
(statearr_104467_104500[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (22))){
var inst_104446 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_104454__$1 = state_104454;
var statearr_104468_104501 = state_104454__$1;
(statearr_104468_104501[(2)] = inst_104446);

(statearr_104468_104501[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (6))){
var state_104454__$1 = state_104454;
var statearr_104469_104502 = state_104454__$1;
(statearr_104469_104502[(2)] = time_str);

(statearr_104469_104502[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (17))){
var inst_104427 = (state_104454[(10)]);
var inst_104441 = (state_104454[(11)]);
var inst_104440 = (state_104454[(9)]);
var inst_104405 = (state_104454[(8)]);
var inst_104438 = (state_104454[(2)]);
var inst_104439 = (function (){var epoch_as_of = inst_104405;
var ts = inst_104427;
var _ = inst_104438;
return ((function (epoch_as_of,ts,_,inst_104427,inst_104441,inst_104440,inst_104405,inst_104438,state_val_104455,c__99059__auto__){
return (function (p1__104395_SHARP_){
return p1__104395_SHARP_.s;
});
;})(epoch_as_of,ts,_,inst_104427,inst_104441,inst_104440,inst_104405,inst_104438,state_val_104455,c__99059__auto__))
})();
var inst_104440__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,inst_104439,inst_104427);
var inst_104441__$1 = inst_104440__$1.s;
var state_104454__$1 = (function (){var statearr_104470 = state_104454;
(statearr_104470[(11)] = inst_104441__$1);

(statearr_104470[(9)] = inst_104440__$1);

return statearr_104470;
})();
if(cljs.core.truth_(inst_104441__$1)){
var statearr_104471_104503 = state_104454__$1;
(statearr_104471_104503[(1)] = (18));

} else {
var statearr_104472_104504 = state_104454__$1;
(statearr_104472_104504[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (3))){
var inst_104396 = (state_104454[(2)]);
var state_104454__$1 = state_104454;
var statearr_104473_104505 = state_104454__$1;
(statearr_104473_104505[(2)] = inst_104396);


cljs.core.async.impl.ioc_helpers.process_exception(state_104454__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (12))){
var inst_104419 = (state_104454[(12)]);
var state_104454__$1 = state_104454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104454__$1,(14),inst_104419);
} else {
if((state_val_104455 === (2))){
var inst_104452 = (state_104454[(2)]);
var state_104454__$1 = state_104454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104454__$1,inst_104452);
} else {
if((state_val_104455 === (23))){
var inst_104448 = (state_104454[(2)]);
var state_104454__$1 = state_104454;
var statearr_104474_104506 = state_104454__$1;
(statearr_104474_104506[(2)] = inst_104448);

(statearr_104474_104506[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (19))){
var inst_104440 = (state_104454[(9)]);
var state_104454__$1 = state_104454;
if(cljs.core.truth_(inst_104440)){
var statearr_104475_104507 = state_104454__$1;
(statearr_104475_104507[(1)] = (21));

} else {
var statearr_104476_104508 = state_104454__$1;
(statearr_104476_104508[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (11))){
var state_104454__$1 = state_104454;
var statearr_104477_104509 = state_104454__$1;
(statearr_104477_104509[(2)] = null);

(statearr_104477_104509[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (9))){
var inst_104405 = (state_104454[(8)]);
var inst_104407 = (state_104454[(7)]);
var inst_104411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104412 = ["_block/instant",(0)];
var inst_104413 = (new cljs.core.PersistentVector(null,2,(5),inst_104411,inst_104412,null));
var inst_104414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104415 = ["_block/instant",inst_104405];
var inst_104416 = (new cljs.core.PersistentVector(null,2,(5),inst_104414,inst_104415,null));
var inst_104417 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(inst_104407,cljs.core.cst$kw$post,cljs.core._GT_,inst_104413,cljs.core._LT_,inst_104416);
var state_104454__$1 = state_104454;
var statearr_104478_104510 = state_104454__$1;
(statearr_104478_104510[(2)] = inst_104417);

(statearr_104478_104510[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (5))){
var inst_104402 = fluree.db.util.core.str__GT_epoch_ms(time_str);
var state_104454__$1 = state_104454;
var statearr_104479_104511 = state_104454__$1;
(statearr_104479_104511[(2)] = inst_104402);

(statearr_104479_104511[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (14))){
var inst_104424 = (state_104454[(2)]);
var inst_104425 = fluree.db.util.async.throw_err(inst_104424);
var state_104454__$1 = state_104454;
var statearr_104480_104512 = state_104454__$1;
(statearr_104480_104512[(2)] = inst_104425);

(statearr_104480_104512[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (16))){
var state_104454__$1 = state_104454;
var statearr_104481_104513 = state_104454__$1;
(statearr_104481_104513[(2)] = null);

(statearr_104481_104513[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (10))){
var inst_104419 = (state_104454[(12)]);
var inst_104419__$1 = (state_104454[(2)]);
var inst_104420 = (inst_104419__$1 == null);
var state_104454__$1 = (function (){var statearr_104482 = state_104454;
(statearr_104482[(12)] = inst_104419__$1);

return statearr_104482;
})();
if(cljs.core.truth_(inst_104420)){
var statearr_104483_104514 = state_104454__$1;
(statearr_104483_104514[(1)] = (11));

} else {
var statearr_104484_104515 = state_104454__$1;
(statearr_104484_104515[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (18))){
var inst_104441 = (state_104454[(11)]);
var state_104454__$1 = state_104454;
var statearr_104485_104516 = state_104454__$1;
(statearr_104485_104516[(2)] = inst_104441);

(statearr_104485_104516[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104455 === (8))){
var state_104454__$1 = state_104454;
var statearr_104486_104517 = state_104454__$1;
(statearr_104486_104517[(2)] = null);

(statearr_104486_104517[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____0 = (function (){
var statearr_104487 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104487[(0)] = fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__);

(statearr_104487[(1)] = (1));

return statearr_104487;
});
var fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____1 = (function (state_104454){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104454);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104488){if((e104488 instanceof Object)){
var ex__99040__auto__ = e104488;
var statearr_104489_104518 = state_104454;
(statearr_104489_104518[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104454);

return cljs.core.cst$kw$recur;
} else {
throw e104488;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104519 = state_104454;
state_104454 = G__104519;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__ = function(state_104454){
switch(arguments.length){
case 0:
return fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____1.call(this,state_104454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____0;
fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$time_to_t_$_state_machine__99037__auto____1;
return fluree$db$time_travel$time_to_t_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104490 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104490[(6)] = c__99059__auto__);

return statearr_104490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.time_travel.t_to_block = (function fluree$db$time_travel$t_to_block(db,t){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104569){
var state_val_104570 = (state_104569[(1)]);
if((state_val_104570 === (7))){
var inst_104540 = (state_104569[(7)]);
var inst_104540__$1 = (state_104569[(2)]);
var inst_104541 = (inst_104540__$1 == null);
var state_104569__$1 = (function (){var statearr_104571 = state_104569;
(statearr_104571[(7)] = inst_104540__$1);

return statearr_104571;
})();
if(cljs.core.truth_(inst_104541)){
var statearr_104572_104603 = state_104569__$1;
(statearr_104572_104603[(1)] = (8));

} else {
var statearr_104573_104604 = state_104569__$1;
(statearr_104573_104604[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (20))){
var inst_104565 = (state_104569[(2)]);
var state_104569__$1 = state_104569;
var statearr_104574_104605 = state_104569__$1;
(statearr_104574_104605[(2)] = inst_104565);


cljs.core.async.impl.ioc_helpers.process_exception(state_104569__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (1))){
var state_104569__$1 = state_104569;
var statearr_104575_104606 = state_104569__$1;
(statearr_104575_104606[(2)] = null);

(statearr_104575_104606[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (4))){
var inst_104525 = (state_104569[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104569,(3),Error,null,(2));
var inst_104525__$1 = fluree.db.dbproto._rootdb(db);
var inst_104526 = (inst_104525__$1 == null);
var state_104569__$1 = (function (){var statearr_104576 = state_104569;
(statearr_104576[(8)] = inst_104525__$1);

return statearr_104576;
})();
if(cljs.core.truth_(inst_104526)){
var statearr_104577_104607 = state_104569__$1;
(statearr_104577_104607[(1)] = (5));

} else {
var statearr_104578_104608 = state_104569__$1;
(statearr_104578_104608[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (15))){
var state_104569__$1 = state_104569;
var statearr_104579_104609 = state_104569__$1;
(statearr_104579_104609[(2)] = null);

(statearr_104579_104609[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (13))){
var inst_104548 = (state_104569[(9)]);
var inst_104552 = cljs.core.first(inst_104548);
var state_104569__$1 = state_104569;
var statearr_104580_104610 = state_104569__$1;
(statearr_104580_104610[(2)] = inst_104552);

(statearr_104580_104610[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (6))){
var inst_104525 = (state_104569[(8)]);
var inst_104529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104530 = ["_block/number",t];
var inst_104531 = (new cljs.core.PersistentVector(null,2,(5),inst_104529,inst_104530,null));
var inst_104532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104533 = ["_block/number"];
var inst_104534 = (new cljs.core.PersistentVector(null,1,(5),inst_104532,inst_104533,null));
var inst_104535 = [cljs.core.cst$kw$limit];
var inst_104536 = [(1)];
var inst_104537 = cljs.core.PersistentHashMap.fromArrays(inst_104535,inst_104536);
var inst_104538 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(inst_104525,cljs.core.cst$kw$psot,cljs.core._GT__EQ_,inst_104531,cljs.core._LT__EQ_,inst_104534,inst_104537);
var state_104569__$1 = state_104569;
var statearr_104581_104611 = state_104569__$1;
(statearr_104581_104611[(2)] = inst_104538);

(statearr_104581_104611[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (17))){
var inst_104560 = (state_104569[(10)]);
var inst_104560__$1 = (state_104569[(2)]);
var inst_104561 = (inst_104560__$1 > (1));
var state_104569__$1 = (function (){var statearr_104582 = state_104569;
(statearr_104582[(10)] = inst_104560__$1);

return statearr_104582;
})();
if(cljs.core.truth_(inst_104561)){
var statearr_104583_104612 = state_104569__$1;
(statearr_104583_104612[(1)] = (18));

} else {
var statearr_104584_104613 = state_104569__$1;
(statearr_104584_104613[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (3))){
var inst_104520 = (state_104569[(2)]);
var state_104569__$1 = state_104569;
var statearr_104585_104614 = state_104569__$1;
(statearr_104585_104614[(2)] = inst_104520);


cljs.core.async.impl.ioc_helpers.process_exception(state_104569__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (12))){
var state_104569__$1 = state_104569;
var statearr_104586_104615 = state_104569__$1;
(statearr_104586_104615[(2)] = null);

(statearr_104586_104615[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (2))){
var inst_104567 = (state_104569[(2)]);
var state_104569__$1 = state_104569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104569__$1,inst_104567);
} else {
if((state_val_104570 === (19))){
var state_104569__$1 = state_104569;
var statearr_104587_104616 = state_104569__$1;
(statearr_104587_104616[(2)] = (1));

(statearr_104587_104616[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (11))){
var inst_104545 = (state_104569[(2)]);
var inst_104546 = fluree.db.util.async.throw_err(inst_104545);
var state_104569__$1 = state_104569;
var statearr_104588_104617 = state_104569__$1;
(statearr_104588_104617[(2)] = inst_104546);

(statearr_104588_104617[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (9))){
var inst_104540 = (state_104569[(7)]);
var state_104569__$1 = state_104569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104569__$1,(11),inst_104540);
} else {
if((state_val_104570 === (5))){
var state_104569__$1 = state_104569;
var statearr_104589_104618 = state_104569__$1;
(statearr_104589_104618[(2)] = null);

(statearr_104589_104618[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (14))){
var inst_104554 = (state_104569[(11)]);
var inst_104554__$1 = (state_104569[(2)]);
var inst_104555 = (inst_104554__$1 == null);
var state_104569__$1 = (function (){var statearr_104590 = state_104569;
(statearr_104590[(11)] = inst_104554__$1);

return statearr_104590;
})();
if(cljs.core.truth_(inst_104555)){
var statearr_104591_104619 = state_104569__$1;
(statearr_104591_104619[(1)] = (15));

} else {
var statearr_104592_104620 = state_104569__$1;
(statearr_104592_104620[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (16))){
var inst_104554 = (state_104569[(11)]);
var inst_104558 = inst_104554.o;
var state_104569__$1 = state_104569;
var statearr_104593_104621 = state_104569__$1;
(statearr_104593_104621[(2)] = inst_104558);

(statearr_104593_104621[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (10))){
var inst_104548 = (state_104569[(9)]);
var inst_104548__$1 = (state_104569[(2)]);
var inst_104549 = (inst_104548__$1 == null);
var state_104569__$1 = (function (){var statearr_104594 = state_104569;
(statearr_104594[(9)] = inst_104548__$1);

return statearr_104594;
})();
if(cljs.core.truth_(inst_104549)){
var statearr_104595_104622 = state_104569__$1;
(statearr_104595_104622[(1)] = (12));

} else {
var statearr_104596_104623 = state_104569__$1;
(statearr_104596_104623[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (18))){
var inst_104560 = (state_104569[(10)]);
var state_104569__$1 = state_104569;
var statearr_104597_104624 = state_104569__$1;
(statearr_104597_104624[(2)] = inst_104560);

(statearr_104597_104624[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104570 === (8))){
var state_104569__$1 = state_104569;
var statearr_104598_104625 = state_104569__$1;
(statearr_104598_104625[(2)] = null);

(statearr_104598_104625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____0 = (function (){
var statearr_104599 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104599[(0)] = fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__);

(statearr_104599[(1)] = (1));

return statearr_104599;
});
var fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____1 = (function (state_104569){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104569);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104600){if((e104600 instanceof Object)){
var ex__99040__auto__ = e104600;
var statearr_104601_104626 = state_104569;
(statearr_104601_104626[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104569);

return cljs.core.cst$kw$recur;
} else {
throw e104600;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104627 = state_104569;
state_104569 = G__104627;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__ = function(state_104569){
switch(arguments.length){
case 0:
return fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____1.call(this,state_104569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____0;
fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$t_to_block_$_state_machine__99037__auto____1;
return fluree$db$time_travel$t_to_block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104602 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104602[(6)] = c__99059__auto__);

return statearr_104602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.time_travel.non_border_t_to_block = (function fluree$db$time_travel$non_border_t_to_block(db,t){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104675){
var state_val_104676 = (state_104675[(1)]);
if((state_val_104676 === (7))){
var inst_104642 = (state_104675[(7)]);
var inst_104642__$1 = (state_104675[(2)]);
var inst_104643 = (inst_104642__$1 == null);
var state_104675__$1 = (function (){var statearr_104677 = state_104675;
(statearr_104677[(7)] = inst_104642__$1);

return statearr_104677;
})();
if(cljs.core.truth_(inst_104643)){
var statearr_104678_104709 = state_104675__$1;
(statearr_104678_104709[(1)] = (8));

} else {
var statearr_104679_104710 = state_104675__$1;
(statearr_104679_104710[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (20))){
var state_104675__$1 = state_104675;
var statearr_104680_104711 = state_104675__$1;
(statearr_104680_104711[(2)] = (1));

(statearr_104680_104711[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (1))){
var state_104675__$1 = state_104675;
var statearr_104681_104712 = state_104675__$1;
(statearr_104681_104712[(2)] = null);

(statearr_104681_104712[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (4))){
var inst_104633 = (state_104675[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104675,(3),Error,null,(2));
var inst_104633__$1 = fluree.db.dbproto._rootdb(db);
var inst_104634 = (inst_104633__$1 == null);
var state_104675__$1 = (function (){var statearr_104682 = state_104675;
(statearr_104682[(8)] = inst_104633__$1);

return statearr_104682;
})();
if(cljs.core.truth_(inst_104634)){
var statearr_104683_104713 = state_104675__$1;
(statearr_104683_104713[(1)] = (5));

} else {
var statearr_104684_104714 = state_104675__$1;
(statearr_104684_104714[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (15))){
var state_104675__$1 = state_104675;
var statearr_104685_104715 = state_104675__$1;
(statearr_104685_104715[(2)] = null);

(statearr_104685_104715[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (21))){
var inst_104671 = (state_104675[(2)]);
var state_104675__$1 = state_104675;
var statearr_104686_104716 = state_104675__$1;
(statearr_104686_104716[(2)] = inst_104671);


cljs.core.async.impl.ioc_helpers.process_exception(state_104675__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (13))){
var inst_104650 = (state_104675[(9)]);
var inst_104654 = cljs.core.first(inst_104650);
var state_104675__$1 = state_104675;
var statearr_104687_104717 = state_104675__$1;
(statearr_104687_104717[(2)] = inst_104654);

(statearr_104687_104717[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (6))){
var inst_104633 = (state_104675[(8)]);
var inst_104637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104638 = [t,"_block/transactions"];
var inst_104639 = (new cljs.core.PersistentVector(null,2,(5),inst_104637,inst_104638,null));
var inst_104640 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_104633,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_104639);
var state_104675__$1 = state_104675;
var statearr_104688_104718 = state_104675__$1;
(statearr_104688_104718[(2)] = inst_104640);

(statearr_104688_104718[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (17))){
var inst_104662 = (state_104675[(2)]);
var inst_104663 = fluree.db.time_travel.t_to_block(db,inst_104662);
var state_104675__$1 = state_104675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104675__$1,(18),inst_104663);
} else {
if((state_val_104676 === (3))){
var inst_104628 = (state_104675[(2)]);
var state_104675__$1 = state_104675;
var statearr_104689_104719 = state_104675__$1;
(statearr_104689_104719[(2)] = inst_104628);


cljs.core.async.impl.ioc_helpers.process_exception(state_104675__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (12))){
var state_104675__$1 = state_104675;
var statearr_104690_104720 = state_104675__$1;
(statearr_104690_104720[(2)] = null);

(statearr_104690_104720[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (2))){
var inst_104673 = (state_104675[(2)]);
var state_104675__$1 = state_104675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104675__$1,inst_104673);
} else {
if((state_val_104676 === (19))){
var inst_104666 = (state_104675[(10)]);
var state_104675__$1 = state_104675;
var statearr_104691_104721 = state_104675__$1;
(statearr_104691_104721[(2)] = inst_104666);

(statearr_104691_104721[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (11))){
var inst_104647 = (state_104675[(2)]);
var inst_104648 = fluree.db.util.async.throw_err(inst_104647);
var state_104675__$1 = state_104675;
var statearr_104692_104722 = state_104675__$1;
(statearr_104692_104722[(2)] = inst_104648);

(statearr_104692_104722[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (9))){
var inst_104642 = (state_104675[(7)]);
var state_104675__$1 = state_104675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104675__$1,(11),inst_104642);
} else {
if((state_val_104676 === (5))){
var state_104675__$1 = state_104675;
var statearr_104693_104723 = state_104675__$1;
(statearr_104693_104723[(2)] = null);

(statearr_104693_104723[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (14))){
var inst_104656 = (state_104675[(11)]);
var inst_104656__$1 = (state_104675[(2)]);
var inst_104657 = (inst_104656__$1 == null);
var state_104675__$1 = (function (){var statearr_104694 = state_104675;
(statearr_104694[(11)] = inst_104656__$1);

return statearr_104694;
})();
if(cljs.core.truth_(inst_104657)){
var statearr_104695_104724 = state_104675__$1;
(statearr_104695_104724[(1)] = (15));

} else {
var statearr_104696_104725 = state_104675__$1;
(statearr_104696_104725[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (16))){
var inst_104656 = (state_104675[(11)]);
var inst_104660 = inst_104656.s;
var state_104675__$1 = state_104675;
var statearr_104697_104726 = state_104675__$1;
(statearr_104697_104726[(2)] = inst_104660);

(statearr_104697_104726[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (10))){
var inst_104650 = (state_104675[(9)]);
var inst_104650__$1 = (state_104675[(2)]);
var inst_104651 = (inst_104650__$1 == null);
var state_104675__$1 = (function (){var statearr_104698 = state_104675;
(statearr_104698[(9)] = inst_104650__$1);

return statearr_104698;
})();
if(cljs.core.truth_(inst_104651)){
var statearr_104699_104727 = state_104675__$1;
(statearr_104699_104727[(1)] = (12));

} else {
var statearr_104700_104728 = state_104675__$1;
(statearr_104700_104728[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (18))){
var inst_104666 = (state_104675[(10)]);
var inst_104665 = (state_104675[(2)]);
var inst_104666__$1 = fluree.db.util.async.throw_err(inst_104665);
var inst_104667 = (inst_104666__$1 > (1));
var state_104675__$1 = (function (){var statearr_104701 = state_104675;
(statearr_104701[(10)] = inst_104666__$1);

return statearr_104701;
})();
if(cljs.core.truth_(inst_104667)){
var statearr_104702_104729 = state_104675__$1;
(statearr_104702_104729[(1)] = (19));

} else {
var statearr_104703_104730 = state_104675__$1;
(statearr_104703_104730[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104676 === (8))){
var state_104675__$1 = state_104675;
var statearr_104704_104731 = state_104675__$1;
(statearr_104704_104731[(2)] = null);

(statearr_104704_104731[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____0 = (function (){
var statearr_104705 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104705[(0)] = fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__);

(statearr_104705[(1)] = (1));

return statearr_104705;
});
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____1 = (function (state_104675){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104675);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104706){if((e104706 instanceof Object)){
var ex__99040__auto__ = e104706;
var statearr_104707_104732 = state_104675;
(statearr_104707_104732[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104675);

return cljs.core.cst$kw$recur;
} else {
throw e104706;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104733 = state_104675;
state_104675 = G__104733;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__ = function(state_104675){
switch(arguments.length){
case 0:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____1.call(this,state_104675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____0;
fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto____1;
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104708 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104708[(6)] = c__99059__auto__);

return statearr_104708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.time_travel.block_to_int_format = (function fluree$db$time_travel$block_to_int_format(db,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104788){
var state_val_104789 = (state_104788[(1)]);
if((state_val_104789 === (7))){
var inst_104784 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
var statearr_104790_104813 = state_104788__$1;
(statearr_104790_104813[(2)] = inst_104784);


cljs.core.async.impl.ioc_helpers.process_exception(state_104788__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (20))){
var inst_104778 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
var statearr_104791_104814 = state_104788__$1;
(statearr_104791_104814[(2)] = inst_104778);

(statearr_104791_104814[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (1))){
var state_104788__$1 = state_104788;
var statearr_104792_104815 = state_104788__$1;
(statearr_104792_104815[(2)] = null);

(statearr_104792_104815[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104788,(3),Error,null,(2));
var inst_104738 = cljs.core.pos_int_QMARK_(block);
var state_104788__$1 = state_104788;
if(inst_104738){
var statearr_104793_104816 = state_104788__$1;
(statearr_104793_104816[(1)] = (5));

} else {
var statearr_104794_104817 = state_104788__$1;
(statearr_104794_104817[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (15))){
var inst_104780 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
var statearr_104795_104818 = state_104788__$1;
(statearr_104795_104818[(2)] = inst_104780);

(statearr_104795_104818[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (13))){
var inst_104759 = fluree.db.time_travel.time_to_t(db,block);
var state_104788__$1 = state_104788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104788__$1,(16),inst_104759);
} else {
if((state_val_104789 === (6))){
var inst_104741 = typeof block === 'string';
var inst_104742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block,(0));
var inst_104743 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104742);
var inst_104744 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_104743);
var inst_104745 = ((inst_104741) && (inst_104744));
var state_104788__$1 = state_104788;
if(cljs.core.truth_(inst_104745)){
var statearr_104796_104819 = state_104788__$1;
(statearr_104796_104819[(1)] = (8));

} else {
var statearr_104797_104820 = state_104788__$1;
(statearr_104797_104820[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (17))){
var inst_104765 = (state_104788[(2)]);
var inst_104766 = fluree.db.util.async.throw_err(inst_104765);
var state_104788__$1 = state_104788;
var statearr_104798_104821 = state_104788__$1;
(statearr_104798_104821[(2)] = inst_104766);

(statearr_104798_104821[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (3))){
var inst_104734 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
var statearr_104799_104822 = state_104788__$1;
(statearr_104799_104822[(2)] = inst_104734);


cljs.core.async.impl.ioc_helpers.process_exception(state_104788__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (12))){
var inst_104754 = (state_104788[(2)]);
var inst_104755 = fluree.db.util.async.throw_err(inst_104754);
var state_104788__$1 = state_104788;
var statearr_104800_104823 = state_104788__$1;
(statearr_104800_104823[(2)] = inst_104755);

(statearr_104800_104823[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (2))){
var inst_104786 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104788__$1,inst_104786);
} else {
if((state_val_104789 === (19))){
var state_104788__$1 = state_104788;
var statearr_104801_104824 = state_104788__$1;
(statearr_104801_104824[(2)] = null);

(statearr_104801_104824[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (11))){
var inst_104750 = (state_104788[(2)]);
var inst_104751 = fluree.db.util.async.throw_err(inst_104750);
var inst_104752 = fluree.db.time_travel.t_to_block(db,inst_104751);
var state_104788__$1 = state_104788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104788__$1,(12),inst_104752);
} else {
if((state_val_104789 === (9))){
var inst_104757 = typeof block === 'string';
var state_104788__$1 = state_104788;
if(cljs.core.truth_(inst_104757)){
var statearr_104802_104825 = state_104788__$1;
(statearr_104802_104825[(1)] = (13));

} else {
var statearr_104803_104826 = state_104788__$1;
(statearr_104803_104826[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (5))){
var state_104788__$1 = state_104788;
var statearr_104804_104827 = state_104788__$1;
(statearr_104804_104827[(2)] = block);

(statearr_104804_104827[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (14))){
var state_104788__$1 = state_104788;
var statearr_104805_104828 = state_104788__$1;
(statearr_104805_104828[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (16))){
var inst_104761 = (state_104788[(2)]);
var inst_104762 = fluree.db.util.async.throw_err(inst_104761);
var inst_104763 = fluree.db.time_travel.t_to_block(db,inst_104762);
var state_104788__$1 = state_104788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104788__$1,(17),inst_104763);
} else {
if((state_val_104789 === (10))){
var inst_104782 = (state_104788[(2)]);
var state_104788__$1 = state_104788;
var statearr_104807_104829 = state_104788__$1;
(statearr_104807_104829[(2)] = inst_104782);

(statearr_104807_104829[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (18))){
var inst_104769 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_104770 = ["Invalid block key provided: ",inst_104769].join('');
var inst_104771 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104772 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_104773 = cljs.core.PersistentHashMap.fromArrays(inst_104771,inst_104772);
var inst_104774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_104770,inst_104773);
var inst_104775 = (function(){throw inst_104774})();
var state_104788__$1 = state_104788;
var statearr_104808_104830 = state_104788__$1;
(statearr_104808_104830[(2)] = inst_104775);

(statearr_104808_104830[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104789 === (8))){
var inst_104747 = fluree.db.time_travel.duration_parse(block);
var inst_104748 = fluree.db.time_travel.time_to_t(db,inst_104747);
var state_104788__$1 = state_104788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104788__$1,(11),inst_104748);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____0 = (function (){
var statearr_104809 = [null,null,null,null,null,null,null];
(statearr_104809[(0)] = fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__);

(statearr_104809[(1)] = (1));

return statearr_104809;
});
var fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____1 = (function (state_104788){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104788);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104810){if((e104810 instanceof Object)){
var ex__99040__auto__ = e104810;
var statearr_104811_104831 = state_104788;
(statearr_104811_104831[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104788);

return cljs.core.cst$kw$recur;
} else {
throw e104810;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104832 = state_104788;
state_104788 = G__104832;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__ = function(state_104788){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____1.call(this,state_104788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____0;
fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto____1;
return fluree$db$time_travel$block_to_int_format_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104812 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104812[(6)] = c__99059__auto__);

return statearr_104812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.time_travel.block_to_t = (function fluree$db$time_travel$block_to_t(db,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104882){
var state_val_104883 = (state_104882[(1)]);
if((state_val_104883 === (7))){
var inst_104847 = (state_104882[(7)]);
var inst_104847__$1 = (state_104882[(2)]);
var inst_104848 = (inst_104847__$1 == null);
var state_104882__$1 = (function (){var statearr_104884 = state_104882;
(statearr_104884[(7)] = inst_104847__$1);

return statearr_104884;
})();
if(cljs.core.truth_(inst_104848)){
var statearr_104885_104917 = state_104882__$1;
(statearr_104885_104917[(1)] = (8));

} else {
var statearr_104886_104918 = state_104882__$1;
(statearr_104886_104918[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (20))){
var inst_104867 = (state_104882[(8)]);
var inst_104878 = (state_104882[(2)]);
var state_104882__$1 = (function (){var statearr_104887 = state_104882;
(statearr_104887[(9)] = inst_104878);

return statearr_104887;
})();
var statearr_104888_104919 = state_104882__$1;
(statearr_104888_104919[(2)] = inst_104867);


cljs.core.async.impl.ioc_helpers.process_exception(state_104882__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (1))){
var state_104882__$1 = state_104882;
var statearr_104889_104920 = state_104882__$1;
(statearr_104889_104920[(2)] = null);

(statearr_104889_104920[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (4))){
var inst_104838 = (state_104882[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104882,(3),Error,null,(2));
var inst_104838__$1 = fluree.db.dbproto._rootdb(db);
var inst_104839 = (inst_104838__$1 == null);
var state_104882__$1 = (function (){var statearr_104890 = state_104882;
(statearr_104890[(10)] = inst_104838__$1);

return statearr_104890;
})();
if(cljs.core.truth_(inst_104839)){
var statearr_104891_104921 = state_104882__$1;
(statearr_104891_104921[(1)] = (5));

} else {
var statearr_104892_104922 = state_104882__$1;
(statearr_104892_104922[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (15))){
var state_104882__$1 = state_104882;
var statearr_104893_104923 = state_104882__$1;
(statearr_104893_104923[(2)] = null);

(statearr_104893_104923[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (13))){
var inst_104855 = (state_104882[(11)]);
var inst_104859 = cljs.core.first(inst_104855);
var state_104882__$1 = state_104882;
var statearr_104894_104924 = state_104882__$1;
(statearr_104894_104924[(2)] = inst_104859);

(statearr_104894_104924[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (6))){
var inst_104838 = (state_104882[(10)]);
var inst_104842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104843 = ["_block/number",block];
var inst_104844 = (new cljs.core.PersistentVector(null,2,(5),inst_104842,inst_104843,null));
var inst_104845 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_104838,cljs.core.cst$kw$post,cljs.core._EQ_,inst_104844);
var state_104882__$1 = state_104882;
var statearr_104895_104925 = state_104882__$1;
(statearr_104895_104925[(2)] = inst_104845);

(statearr_104895_104925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (17))){
var inst_104867 = (state_104882[(8)]);
var inst_104867__$1 = (state_104882[(2)]);
var state_104882__$1 = (function (){var statearr_104896 = state_104882;
(statearr_104896[(8)] = inst_104867__$1);

return statearr_104896;
})();
if(cljs.core.truth_(inst_104867__$1)){
var statearr_104897_104926 = state_104882__$1;
(statearr_104897_104926[(1)] = (18));

} else {
var statearr_104898_104927 = state_104882__$1;
(statearr_104898_104927[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (3))){
var inst_104833 = (state_104882[(2)]);
var state_104882__$1 = state_104882;
var statearr_104899_104928 = state_104882__$1;
(statearr_104899_104928[(2)] = inst_104833);


cljs.core.async.impl.ioc_helpers.process_exception(state_104882__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (12))){
var state_104882__$1 = state_104882;
var statearr_104900_104929 = state_104882__$1;
(statearr_104900_104929[(2)] = null);

(statearr_104900_104929[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (2))){
var inst_104880 = (state_104882[(2)]);
var state_104882__$1 = state_104882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104882__$1,inst_104880);
} else {
if((state_val_104883 === (19))){
var inst_104870 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_104871 = ["Invalid block key provided: ",inst_104870].join('');
var inst_104872 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104873 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_104874 = cljs.core.PersistentHashMap.fromArrays(inst_104872,inst_104873);
var inst_104875 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_104871,inst_104874);
var inst_104876 = (function(){throw inst_104875})();
var state_104882__$1 = state_104882;
var statearr_104901_104930 = state_104882__$1;
(statearr_104901_104930[(2)] = inst_104876);

(statearr_104901_104930[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (11))){
var inst_104852 = (state_104882[(2)]);
var inst_104853 = fluree.db.util.async.throw_err(inst_104852);
var state_104882__$1 = state_104882;
var statearr_104902_104931 = state_104882__$1;
(statearr_104902_104931[(2)] = inst_104853);

(statearr_104902_104931[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (9))){
var inst_104847 = (state_104882[(7)]);
var state_104882__$1 = state_104882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104882__$1,(11),inst_104847);
} else {
if((state_val_104883 === (5))){
var state_104882__$1 = state_104882;
var statearr_104903_104932 = state_104882__$1;
(statearr_104903_104932[(2)] = null);

(statearr_104903_104932[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (14))){
var inst_104861 = (state_104882[(12)]);
var inst_104861__$1 = (state_104882[(2)]);
var inst_104862 = (inst_104861__$1 == null);
var state_104882__$1 = (function (){var statearr_104904 = state_104882;
(statearr_104904[(12)] = inst_104861__$1);

return statearr_104904;
})();
if(cljs.core.truth_(inst_104862)){
var statearr_104905_104933 = state_104882__$1;
(statearr_104905_104933[(1)] = (15));

} else {
var statearr_104906_104934 = state_104882__$1;
(statearr_104906_104934[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (16))){
var inst_104861 = (state_104882[(12)]);
var inst_104865 = inst_104861.t;
var state_104882__$1 = state_104882;
var statearr_104907_104935 = state_104882__$1;
(statearr_104907_104935[(2)] = inst_104865);

(statearr_104907_104935[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (10))){
var inst_104855 = (state_104882[(11)]);
var inst_104855__$1 = (state_104882[(2)]);
var inst_104856 = (inst_104855__$1 == null);
var state_104882__$1 = (function (){var statearr_104908 = state_104882;
(statearr_104908[(11)] = inst_104855__$1);

return statearr_104908;
})();
if(cljs.core.truth_(inst_104856)){
var statearr_104909_104936 = state_104882__$1;
(statearr_104909_104936[(1)] = (12));

} else {
var statearr_104910_104937 = state_104882__$1;
(statearr_104910_104937[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (18))){
var state_104882__$1 = state_104882;
var statearr_104911_104938 = state_104882__$1;
(statearr_104911_104938[(2)] = null);

(statearr_104911_104938[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104883 === (8))){
var state_104882__$1 = state_104882;
var statearr_104912_104939 = state_104882__$1;
(statearr_104912_104939[(2)] = null);

(statearr_104912_104939[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____0 = (function (){
var statearr_104913 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104913[(0)] = fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__);

(statearr_104913[(1)] = (1));

return statearr_104913;
});
var fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____1 = (function (state_104882){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104882);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104914){if((e104914 instanceof Object)){
var ex__99040__auto__ = e104914;
var statearr_104915_104940 = state_104882;
(statearr_104915_104940[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104882);

return cljs.core.cst$kw$recur;
} else {
throw e104914;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104941 = state_104882;
state_104882 = G__104941;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__ = function(state_104882){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____1.call(this,state_104882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____0;
fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_t_$_state_machine__99037__auto____1;
return fluree$db$time_travel$block_to_t_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104916 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104916[(6)] = c__99059__auto__);

return statearr_104916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets the database as-of a specified block. Either block number or a time string in ISO-8601 format.
 *   Returns db as a promise channel
 */
fluree.db.time_travel.as_of_block = (function fluree$db$time_travel$as_of_block(db,block_or_t_or_time){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
try{var c__99059__auto___105039 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___105039,pc){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___105039,pc){
return (function (state_105007){
var state_val_105008 = (state_105007[(1)]);
if((state_val_105008 === (7))){
var inst_104946 = (state_105007[(7)]);
var inst_104949 = (state_105007[(2)]);
var inst_104950 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_104946);
var state_105007__$1 = (function (){var statearr_105009 = state_105007;
(statearr_105009[(8)] = inst_104949);

return statearr_105009;
})();
var statearr_105010_105040 = state_105007__$1;
(statearr_105010_105040[(2)] = inst_104950);


cljs.core.async.impl.ioc_helpers.process_exception(state_105007__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (20))){
var inst_104978 = (state_105007[(2)]);
var inst_104979 = fluree.db.util.async.throw_err(inst_104978);
var state_105007__$1 = state_105007;
var statearr_105011_105041 = state_105007__$1;
(statearr_105011_105041[(2)] = inst_104979);

(statearr_105011_105041[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (1))){
var inst_104943 = fluree.db.dbproto._latest_db(db);
var state_105007__$1 = state_105007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105007__$1,(2),inst_104943);
} else {
if((state_val_105008 === (24))){
var inst_104999 = (state_105007[(9)]);
var inst_105002 = (state_105007[(2)]);
var inst_105003 = fluree.db.util.async.throw_err(inst_105002);
var inst_105004 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$t,inst_104999,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,inst_105003], 0));
var inst_105005 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_105004);
var state_105007__$1 = state_105007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105007__$1,inst_105005);
} else {
if((state_val_105008 === (4))){
var inst_104961 = cljs.core.neg_int_QMARK_(block_or_t_or_time);
var state_105007__$1 = state_105007;
if(inst_104961){
var statearr_105012_105042 = state_105007__$1;
(statearr_105012_105042[(1)] = (10));

} else {
var statearr_105013_105043 = state_105007__$1;
(statearr_105013_105043[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (15))){
var inst_104995 = (state_105007[(2)]);
var state_105007__$1 = state_105007;
var statearr_105014_105044 = state_105007__$1;
(statearr_105014_105044[(2)] = inst_104995);

(statearr_105014_105044[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (21))){
var inst_104984 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_or_t_or_time], 0));
var inst_104985 = ["Invalid block key provided: ",inst_104984].join('');
var inst_104986 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104987 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_104988 = cljs.core.PersistentHashMap.fromArrays(inst_104986,inst_104987);
var inst_104989 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_104985,inst_104988);
var inst_104990 = (function(){throw inst_104989})();
var state_105007__$1 = state_105007;
var statearr_105015_105045 = state_105007__$1;
(statearr_105015_105045[(2)] = inst_104990);

(statearr_105015_105045[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (13))){
var inst_104966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block_or_t_or_time,(0));
var inst_104967 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104966);
var inst_104968 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_104967);
var state_105007__$1 = state_105007;
if(inst_104968){
var statearr_105016_105046 = state_105007__$1;
(statearr_105016_105046[(1)] = (16));

} else {
var statearr_105017_105047 = state_105007__$1;
(statearr_105017_105047[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (22))){
var state_105007__$1 = state_105007;
var statearr_105018_105048 = state_105007__$1;
(statearr_105018_105048[(2)] = null);

(statearr_105018_105048[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (6))){
var inst_104959 = (state_105007[(2)]);
var state_105007__$1 = state_105007;
var statearr_105019_105049 = state_105007__$1;
(statearr_105019_105049[(2)] = inst_104959);

(statearr_105019_105049[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (17))){
var inst_104946 = (state_105007[(7)]);
var inst_104976 = fluree.db.time_travel.time_to_t(inst_104946,block_or_t_or_time);
var state_105007__$1 = state_105007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105007__$1,(20),inst_104976);
} else {
if((state_val_105008 === (3))){
var state_105007__$1 = state_105007;
var statearr_105020_105050 = state_105007__$1;
(statearr_105020_105050[(2)] = null);

(statearr_105020_105050[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (12))){
var inst_104997 = (state_105007[(2)]);
var state_105007__$1 = state_105007;
var statearr_105021_105051 = state_105007__$1;
(statearr_105021_105051[(2)] = inst_104997);

(statearr_105021_105051[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (2))){
var inst_104945 = (state_105007[(2)]);
var inst_104946 = fluree.db.util.async.throw_err(inst_104945);
var inst_104947 = cljs.core.pos_int_QMARK_(block_or_t_or_time);
var state_105007__$1 = (function (){var statearr_105022 = state_105007;
(statearr_105022[(7)] = inst_104946);

return statearr_105022;
})();
if(inst_104947){
var statearr_105023_105052 = state_105007__$1;
(statearr_105023_105052[(1)] = (3));

} else {
var statearr_105024_105053 = state_105007__$1;
(statearr_105024_105053[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (23))){
var inst_104993 = (state_105007[(2)]);
var state_105007__$1 = state_105007;
var statearr_105025_105054 = state_105007__$1;
(statearr_105025_105054[(2)] = inst_104993);

(statearr_105025_105054[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (19))){
var inst_104973 = (state_105007[(2)]);
var inst_104974 = fluree.db.util.async.throw_err(inst_104973);
var state_105007__$1 = state_105007;
var statearr_105026_105055 = state_105007__$1;
(statearr_105026_105055[(2)] = inst_104974);

(statearr_105026_105055[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (11))){
var inst_104964 = typeof block_or_t_or_time === 'string';
var state_105007__$1 = state_105007;
if(cljs.core.truth_(inst_104964)){
var statearr_105027_105056 = state_105007__$1;
(statearr_105027_105056[(1)] = (13));

} else {
var statearr_105028_105057 = state_105007__$1;
(statearr_105028_105057[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (9))){
var inst_104956 = (state_105007[(2)]);
var inst_104957 = fluree.db.util.async.throw_err(inst_104956);
var state_105007__$1 = state_105007;
var statearr_105029_105058 = state_105007__$1;
(statearr_105029_105058[(2)] = inst_104957);


cljs.core.async.impl.ioc_helpers.process_exception(state_105007__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (5))){
var inst_104999 = (state_105007[(9)]);
var inst_104946 = (state_105007[(7)]);
var inst_104999__$1 = (state_105007[(2)]);
var inst_105000 = fluree.db.time_travel.t_to_block(inst_104946,inst_104999__$1);
var state_105007__$1 = (function (){var statearr_105030 = state_105007;
(statearr_105030[(9)] = inst_104999__$1);

return statearr_105030;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105007__$1,(24),inst_105000);
} else {
if((state_val_105008 === (14))){
var state_105007__$1 = state_105007;
var statearr_105031_105059 = state_105007__$1;
(statearr_105031_105059[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (16))){
var inst_104946 = (state_105007[(7)]);
var inst_104970 = fluree.db.time_travel.duration_parse(block_or_t_or_time);
var inst_104971 = fluree.db.time_travel.time_to_t(inst_104946,inst_104970);
var state_105007__$1 = state_105007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105007__$1,(19),inst_104971);
} else {
if((state_val_105008 === (10))){
var state_105007__$1 = state_105007;
var statearr_105033_105060 = state_105007__$1;
(statearr_105033_105060[(2)] = block_or_t_or_time);

(statearr_105033_105060[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (18))){
var inst_104981 = (state_105007[(2)]);
var state_105007__$1 = state_105007;
var statearr_105034_105061 = state_105007__$1;
(statearr_105034_105061[(2)] = inst_104981);

(statearr_105034_105061[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105008 === (8))){
var inst_104946 = (state_105007[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105007,(7),java.lang.Exception,null,(6));
var inst_104954 = fluree.db.time_travel.block_to_t(inst_104946,block_or_t_or_time);
var state_105007__$1 = state_105007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105007__$1,(9),inst_104954);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___105039,pc))
;
return ((function (switch__99036__auto__,c__99059__auto___105039,pc){
return (function() {
var fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__ = null;
var fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____0 = (function (){
var statearr_105035 = [null,null,null,null,null,null,null,null,null,null];
(statearr_105035[(0)] = fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__);

(statearr_105035[(1)] = (1));

return statearr_105035;
});
var fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____1 = (function (state_105007){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105007);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105036){if((e105036 instanceof Object)){
var ex__99040__auto__ = e105036;
var statearr_105037_105062 = state_105007;
(statearr_105037_105062[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105007);

return cljs.core.cst$kw$recur;
} else {
throw e105036;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105063 = state_105007;
state_105007 = G__105063;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__ = function(state_105007){
switch(arguments.length){
case 0:
return fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____1.call(this,state_105007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____0;
fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$as_of_block_$_state_machine__99037__auto____1;
return fluree$db$time_travel$as_of_block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___105039,pc))
})();
var state__99061__auto__ = (function (){var statearr_105038 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105038[(6)] = c__99059__auto___105039);

return statearr_105038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___105039,pc))
);

}catch (e104942){if((e104942 instanceof java.lang.Exception)){
var e_105064 = e104942;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,e_105064);
} else {
throw e104942;

}
}
return pc;
});

//# sourceMappingURL=time_travel.js.map?rel=1593118617455
