// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101303){
var state_val_101304 = (state_101303[(1)]);
if((state_val_101304 === (1))){
var state_101303__$1 = state_101303;
var statearr_101305_101312 = state_101303__$1;
(statearr_101305_101312[(2)] = null);

(statearr_101305_101312[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101304 === (2))){
var inst_101301 = (state_101303[(2)]);
var state_101303__$1 = state_101303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101303__$1,inst_101301);
} else {
if((state_val_101304 === (3))){
var inst_101291 = (state_101303[(2)]);
var state_101303__$1 = state_101303;
var statearr_101306_101313 = state_101303__$1;
(statearr_101306_101313[(2)] = inst_101291);


cljs.core.async.impl.ioc_helpers.process_exception(state_101303__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101304 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101303,(3),Error,null,(2));
var inst_101295 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_101303__$1 = state_101303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101303__$1,(5),inst_101295);
} else {
if((state_val_101304 === (5))){
var inst_101297 = (state_101303[(2)]);
var inst_101298 = fluree.db.util.async.throw_err(inst_101297);
var inst_101299 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_101298);
var state_101303__$1 = state_101303;
var statearr_101307_101314 = state_101303__$1;
(statearr_101307_101314[(2)] = inst_101299);


cljs.core.async.impl.ioc_helpers.process_exception(state_101303__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____0 = (function (){
var statearr_101308 = [null,null,null,null,null,null,null];
(statearr_101308[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__);

(statearr_101308[(1)] = (1));

return statearr_101308;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____1 = (function (state_101303){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101303);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101309){if((e101309 instanceof Object)){
var ex__99040__auto__ = e101309;
var statearr_101310_101315 = state_101303;
(statearr_101310_101315[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101303);

return cljs.core.cst$kw$recur;
} else {
throw e101309;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__101316 = state_101303;
state_101303 = G__101316;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__ = function(state_101303){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____1.call(this,state_101303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101311 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101311[(6)] = c__99059__auto__);

return statearr_101311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101345){
var state_val_101346 = (state_101345[(1)]);
if((state_val_101346 === (7))){
var inst_101330 = (state_101345[(7)]);
var state_101345__$1 = state_101345;
var statearr_101347_101364 = state_101345__$1;
(statearr_101347_101364[(2)] = inst_101330);

(statearr_101347_101364[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (1))){
var state_101345__$1 = state_101345;
var statearr_101348_101365 = state_101345__$1;
(statearr_101348_101365[(2)] = null);

(statearr_101348_101365[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101345,(3),Error,null,(2));
var inst_101322 = (function (){return ((function (_,state_val_101346,c__99059__auto__){
return (function (p1__101317_SHARP_){
return p1__101317_SHARP_.o;
});
;})(_,state_val_101346,c__99059__auto__))
})();
var inst_101323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101324 = [pred_id];
var inst_101325 = (new cljs.core.PersistentVector(null,1,(5),inst_101323,inst_101324,null));
var inst_101326 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_101325);
var state_101345__$1 = (function (){var statearr_101349 = state_101345;
(statearr_101349[(8)] = inst_101322);

return statearr_101349;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101345__$1,(5),inst_101326);
} else {
if((state_val_101346 === (6))){
var inst_101330 = (state_101345[(7)]);
var inst_101332 = cljs.core.empty_QMARK_(inst_101330);
var inst_101333 = (!(inst_101332));
var state_101345__$1 = state_101345;
var statearr_101350_101366 = state_101345__$1;
(statearr_101350_101366[(2)] = inst_101333);

(statearr_101350_101366[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (3))){
var inst_101318 = (state_101345[(2)]);
var state_101345__$1 = state_101345;
var statearr_101351_101367 = state_101345__$1;
(statearr_101351_101367[(2)] = inst_101318);


cljs.core.async.impl.ioc_helpers.process_exception(state_101345__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (2))){
var inst_101343 = (state_101345[(2)]);
var state_101345__$1 = state_101345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101345__$1,inst_101343);
} else {
if((state_val_101346 === (11))){
var inst_101341 = (state_101345[(2)]);
var state_101345__$1 = state_101345;
var statearr_101352_101368 = state_101345__$1;
(statearr_101352_101368[(2)] = inst_101341);


cljs.core.async.impl.ioc_helpers.process_exception(state_101345__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (9))){
var inst_101330 = (state_101345[(7)]);
var inst_101338 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_101330);
var state_101345__$1 = state_101345;
var statearr_101353_101369 = state_101345__$1;
(statearr_101353_101369[(2)] = inst_101338);

(statearr_101353_101369[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (5))){
var inst_101322 = (state_101345[(8)]);
var inst_101330 = (state_101345[(7)]);
var inst_101328 = (state_101345[(2)]);
var inst_101329 = fluree.db.util.async.throw_err(inst_101328);
var inst_101330__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_101322,inst_101329);
var state_101345__$1 = (function (){var statearr_101354 = state_101345;
(statearr_101354[(7)] = inst_101330__$1);

return statearr_101354;
})();
if(cljs.core.truth_(inst_101330__$1)){
var statearr_101355_101370 = state_101345__$1;
(statearr_101355_101370[(1)] = (6));

} else {
var statearr_101356_101371 = state_101345__$1;
(statearr_101356_101371[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (10))){
var state_101345__$1 = state_101345;
var statearr_101357_101372 = state_101345__$1;
(statearr_101357_101372[(2)] = true);

(statearr_101357_101372[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101346 === (8))){
var inst_101336 = (state_101345[(2)]);
var state_101345__$1 = state_101345;
if(cljs.core.truth_(inst_101336)){
var statearr_101358_101373 = state_101345__$1;
(statearr_101358_101373[(1)] = (9));

} else {
var statearr_101359_101374 = state_101345__$1;
(statearr_101359_101374[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_101360 = [null,null,null,null,null,null,null,null,null];
(statearr_101360[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__);

(statearr_101360[(1)] = (1));

return statearr_101360;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____1 = (function (state_101345){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101345);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101361){if((e101361 instanceof Object)){
var ex__99040__auto__ = e101361;
var statearr_101362_101375 = state_101345;
(statearr_101362_101375[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101345);

return cljs.core.cst$kw$recur;
} else {
throw e101361;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__101376 = state_101345;
state_101345 = G__101376;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__ = function(state_101345){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____1.call(this,state_101345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101363 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101363[(6)] = c__99059__auto__);

return statearr_101363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101450){
var state_val_101451 = (state_101450[(1)]);
if((state_val_101451 === (7))){
var inst_101401 = (state_101450[(7)]);
var state_101450__$1 = state_101450;
var statearr_101452_101479 = state_101450__$1;
(statearr_101452_101479[(2)] = inst_101401);

(statearr_101452_101479[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (1))){
var state_101450__$1 = state_101450;
var statearr_101453_101480 = state_101450__$1;
(statearr_101453_101480[(2)] = null);

(statearr_101453_101480[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101450,(3),Error,null,(2));
var inst_101383 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_101384 = cljs.core.PersistentHashSet.EMPTY;
var inst_101385 = cljs.core.vals(tempids);
var inst_101386 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_101384,inst_101385);
var inst_101387 = (function (){var pred_flakes = inst_101383;
var is_new_QMARK_ = inst_101386;
return ((function (pred_flakes,is_new_QMARK_,_,inst_101383,inst_101384,inst_101385,inst_101386,state_val_101451,c__99059__auto__){
return (function (p1__101377_SHARP_,p2__101378_SHARP_){
return cljs.core.assoc_in(p1__101377_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__101378_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__101454 = p2__101378_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__101454) : is_new_QMARK_.call(null,G__101454));
})()));
});
;})(pred_flakes,is_new_QMARK_,_,inst_101383,inst_101384,inst_101385,inst_101386,state_val_101451,c__99059__auto__))
})();
var inst_101388 = cljs.core.PersistentHashMap.EMPTY;
var inst_101389 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_101387,inst_101388,inst_101383);
var inst_101397 = cljs.core.seq(inst_101383);
var inst_101398 = cljs.core.first(inst_101397);
var inst_101399 = cljs.core.next(inst_101397);
var inst_101400 = inst_101383;
var inst_101401 = inst_101389;
var state_101450__$1 = (function (){var statearr_101455 = state_101450;
(statearr_101455[(8)] = inst_101400);

(statearr_101455[(7)] = inst_101401);

(statearr_101455[(9)] = inst_101399);

(statearr_101455[(10)] = inst_101398);

return statearr_101455;
})();
var statearr_101456_101481 = state_101450__$1;
(statearr_101456_101481[(2)] = null);

(statearr_101456_101481[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (15))){
var inst_101407 = (state_101450[(11)]);
var inst_101427 = (state_101450[(12)]);
var inst_101401 = (state_101450[(7)]);
var inst_101414 = (state_101450[(13)]);
var inst_101435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101436 = inst_101407.s;
var inst_101437 = [inst_101436,inst_101414,cljs.core.cst$kw$new];
var inst_101438 = (new cljs.core.PersistentVector(null,3,(5),inst_101435,inst_101437,null));
var inst_101439 = cljs.core.assoc_in(inst_101401,inst_101438,inst_101427);
var state_101450__$1 = state_101450;
var statearr_101457_101482 = state_101450__$1;
(statearr_101457_101482[(2)] = inst_101439);

(statearr_101457_101482[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (13))){
var inst_101422 = (state_101450[(2)]);
var inst_101423 = fluree.db.util.async.throw_err(inst_101422);
var state_101450__$1 = state_101450;
var statearr_101458_101483 = state_101450__$1;
(statearr_101458_101483[(2)] = inst_101423);

(statearr_101458_101483[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (6))){
var inst_101446 = (state_101450[(2)]);
var state_101450__$1 = state_101450;
var statearr_101459_101484 = state_101450__$1;
(statearr_101459_101484[(2)] = inst_101446);


cljs.core.async.impl.ioc_helpers.process_exception(state_101450__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (3))){
var inst_101379 = (state_101450[(2)]);
var state_101450__$1 = state_101450;
var statearr_101460_101485 = state_101450__$1;
(statearr_101460_101485[(2)] = inst_101379);


cljs.core.async.impl.ioc_helpers.process_exception(state_101450__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (12))){
var inst_101416 = (state_101450[(14)]);
var inst_101427 = (state_101450[(2)]);
var state_101450__$1 = (function (){var statearr_101461 = state_101450;
(statearr_101461[(12)] = inst_101427);

return statearr_101461;
})();
if(cljs.core.truth_(inst_101416)){
var statearr_101462_101486 = state_101450__$1;
(statearr_101462_101486[(1)] = (14));

} else {
var statearr_101463_101487 = state_101450__$1;
(statearr_101463_101487[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (2))){
var inst_101448 = (state_101450[(2)]);
var state_101450__$1 = state_101450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101450__$1,inst_101448);
} else {
if((state_val_101451 === (11))){
var inst_101407 = (state_101450[(11)]);
var inst_101425 = inst_101407.o;
var state_101450__$1 = state_101450;
var statearr_101464_101488 = state_101450__$1;
(statearr_101464_101488[(2)] = inst_101425);

(statearr_101464_101488[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (9))){
var inst_101444 = (state_101450[(2)]);
var state_101450__$1 = state_101450;
var statearr_101465_101489 = state_101450__$1;
(statearr_101465_101489[(2)] = inst_101444);

(statearr_101465_101489[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (5))){
var inst_101400 = (state_101450[(8)]);
var inst_101407 = (state_101450[(11)]);
var inst_101406 = cljs.core.seq(inst_101400);
var inst_101407__$1 = cljs.core.first(inst_101406);
var inst_101408 = cljs.core.next(inst_101406);
var inst_101409 = cljs.core.not(inst_101407__$1);
var state_101450__$1 = (function (){var statearr_101466 = state_101450;
(statearr_101466[(15)] = inst_101408);

(statearr_101466[(11)] = inst_101407__$1);

return statearr_101466;
})();
if(inst_101409){
var statearr_101467_101490 = state_101450__$1;
(statearr_101467_101490[(1)] = (7));

} else {
var statearr_101468_101491 = state_101450__$1;
(statearr_101468_101491[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (14))){
var inst_101407 = (state_101450[(11)]);
var inst_101427 = (state_101450[(12)]);
var inst_101401 = (state_101450[(7)]);
var inst_101414 = (state_101450[(13)]);
var inst_101429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101430 = inst_101407.s;
var inst_101431 = [inst_101430,inst_101414,cljs.core.cst$kw$old];
var inst_101432 = (new cljs.core.PersistentVector(null,3,(5),inst_101429,inst_101431,null));
var inst_101433 = cljs.core.assoc_in(inst_101401,inst_101432,inst_101427);
var state_101450__$1 = state_101450;
var statearr_101469_101492 = state_101450__$1;
(statearr_101469_101492[(2)] = inst_101433);

(statearr_101469_101492[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (16))){
var inst_101408 = (state_101450[(15)]);
var inst_101441 = (state_101450[(2)]);
var inst_101400 = inst_101408;
var inst_101401 = inst_101441;
var state_101450__$1 = (function (){var statearr_101470 = state_101450;
(statearr_101470[(8)] = inst_101400);

(statearr_101470[(7)] = inst_101401);

return statearr_101470;
})();
var statearr_101471_101493 = state_101450__$1;
(statearr_101471_101493[(2)] = null);

(statearr_101471_101493[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101451 === (10))){
var inst_101407 = (state_101450[(11)]);
var inst_101419 = inst_101407.o;
var inst_101420 = fluree.db.query.schema.convert_type_to_kw(inst_101419,db);
var state_101450__$1 = state_101450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101450__$1,(13),inst_101420);
} else {
if((state_val_101451 === (8))){
var inst_101407 = (state_101450[(11)]);
var inst_101414 = (state_101450[(13)]);
var inst_101412 = inst_101407.p;
var inst_101413 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_101412);
var inst_101414__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_101413);
var inst_101415 = inst_101407.op;
var inst_101416 = inst_101415 === false;
var inst_101417 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_101414__$1);
var state_101450__$1 = (function (){var statearr_101472 = state_101450;
(statearr_101472[(14)] = inst_101416);

(statearr_101472[(13)] = inst_101414__$1);

return statearr_101472;
})();
if(inst_101417){
var statearr_101473_101494 = state_101450__$1;
(statearr_101473_101494[(1)] = (10));

} else {
var statearr_101474_101495 = state_101450__$1;
(statearr_101474_101495[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____0 = (function (){
var statearr_101475 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101475[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__);

(statearr_101475[(1)] = (1));

return statearr_101475;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____1 = (function (state_101450){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101450);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101476){if((e101476 instanceof Object)){
var ex__99040__auto__ = e101476;
var statearr_101477_101496 = state_101450;
(statearr_101477_101496[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101450);

return cljs.core.cst$kw$recur;
} else {
throw e101476;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__101497 = state_101450;
state_101450 = G__101497;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__ = function(state_101450){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____1.call(this,state_101450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101478 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101478[(6)] = c__99059__auto__);

return statearr_101478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__101499 = arguments.length;
switch (G__101499) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
});

fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
});

fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4;

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__101502 = arguments.length;
switch (G__101502) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
});

fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101806){
var state_val_101807 = (state_101806[(1)]);
if((state_val_101807 === (65))){
var inst_101670 = (state_101806[(7)]);
var state_101806__$1 = state_101806;
var G__101808_101973 = inst_101670;
var G__101808_101974__$1 = (((G__101808_101973 instanceof cljs.core.Keyword))?G__101808_101973.fqn:null);
switch (G__101808_101974__$1) {
case "long":
var statearr_101809_101976 = state_101806__$1;
(statearr_101809_101976[(1)] = (69));


break;
case "bigint":
var statearr_101810_101977 = state_101806__$1;
(statearr_101810_101977[(1)] = (73));


break;
case "double":
var statearr_101811_101978 = state_101806__$1;
(statearr_101811_101978[(1)] = (77));


break;
case "float":
var statearr_101812_101979 = state_101806__$1;
(statearr_101812_101979[(1)] = (81));


break;
case "bigdec":
var statearr_101813_101980 = state_101806__$1;
(statearr_101813_101980[(1)] = (85));


break;
case "string":
var statearr_101814_101981 = state_101806__$1;
(statearr_101814_101981[(1)] = (89));


break;
case "instant":
var statearr_101815_101982 = state_101806__$1;
(statearr_101815_101982[(1)] = (93));


break;
default:
var statearr_101816_101983 = state_101806__$1;
(statearr_101816_101983[(1)] = (97));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (70))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101817_101984 = state_101806__$1;
(statearr_101817_101984[(2)] = inst_101637);

(statearr_101817_101984[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (62))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101679 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101818_101985 = state_101806__$1;
(statearr_101818_101985[(2)] = inst_101679);

(statearr_101818_101985[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (74))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101819_101986 = state_101806__$1;
(statearr_101819_101986[(2)] = inst_101637);

(statearr_101819_101986[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (7))){
var inst_101526 = (state_101806[(10)]);
var state_101806__$1 = state_101806;
var statearr_101820_101987 = state_101806__$1;
(statearr_101820_101987[(2)] = inst_101526);

(statearr_101820_101987[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (59))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101821_101988 = state_101806__$1;
(statearr_101821_101988[(2)] = inst_101637);

(statearr_101821_101988[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (86))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101822_101989 = state_101806__$1;
(statearr_101822_101989[(2)] = inst_101637);

(statearr_101822_101989[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (20))){
var inst_101561 = (state_101806[(11)]);
var state_101806__$1 = state_101806;
var statearr_101823_101990 = state_101806__$1;
(statearr_101823_101990[(2)] = inst_101561);

(statearr_101823_101990[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (72))){
var inst_101690 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101824_101991 = state_101806__$1;
(statearr_101824_101991[(2)] = inst_101690);

(statearr_101824_101991[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (58))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101668 = (state_101806[(2)]);
var inst_101669__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101668,cljs.core.cst$kw$old);
var inst_101670__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_101668,cljs.core.cst$kw$new);
var inst_101671 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_101670__$1,inst_101669__$1);
var state_101806__$1 = (function (){var statearr_101825 = state_101806;
(statearr_101825[(9)] = inst_101669__$1);

(statearr_101825[(7)] = inst_101670__$1);

return statearr_101825;
})();
if(inst_101671){
var statearr_101826_101992 = state_101806__$1;
(statearr_101826_101992[(1)] = (59));

} else {
var statearr_101827_101993 = state_101806__$1;
(statearr_101827_101993[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (60))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101674 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_101675 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_101674,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,3,inst_101674,null));
var inst_101676 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101675,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101675,null));
var inst_101677 = (inst_101676.cljs$core$IFn$_invoke$arity$1 ? inst_101676.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101676.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101677)){
var statearr_101828_101994 = state_101806__$1;
(statearr_101828_101994[(1)] = (62));

} else {
var statearr_101829_101995 = state_101806__$1;
(statearr_101829_101995[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (27))){
var inst_101587 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101830_101996 = state_101806__$1;
(statearr_101830_101996[(2)] = inst_101587);

(statearr_101830_101996[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (1))){
var state_101806__$1 = state_101806;
var statearr_101831_101997 = state_101806__$1;
(statearr_101831_101997[(2)] = null);

(statearr_101831_101997[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (69))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101682 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_101683 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_101682,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,2,inst_101682,null));
var inst_101684 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101683,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101683,null));
var inst_101685 = (inst_101684.cljs$core$IFn$_invoke$arity$1 ? inst_101684.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101684.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101685)){
var statearr_101832_101998 = state_101806__$1;
(statearr_101832_101998[(1)] = (70));

} else {
var statearr_101833_101999 = state_101806__$1;
(statearr_101833_101999[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (101))){
var inst_101538 = (state_101806[(12)]);
var inst_101771 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101772 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101771);
var inst_101773 = inst_101772 === true;
var inst_101774 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101775 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101774);
var inst_101776 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_101775);
var inst_101777 = (!(inst_101776));
var inst_101778 = ((inst_101773) && (inst_101777));
var state_101806__$1 = state_101806;
var statearr_101834_102000 = state_101806__$1;
(statearr_101834_102000[(2)] = inst_101778);

(statearr_101834_102000[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (24))){
var inst_101591 = (state_101806[(13)]);
var inst_101538 = (state_101806[(12)]);
var inst_101590 = (state_101806[(2)]);
var inst_101591__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101835 = state_101806;
(statearr_101835[(13)] = inst_101591__$1);

(statearr_101835[(14)] = inst_101590);

return statearr_101835;
})();
if(cljs.core.truth_(inst_101591__$1)){
var statearr_101836_102001 = state_101806__$1;
(statearr_101836_102001[(1)] = (28));

} else {
var statearr_101837_102002 = state_101806__$1;
(statearr_101837_102002[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (102))){
var inst_101769 = (state_101806[(15)]);
var state_101806__$1 = state_101806;
var statearr_101838_102003 = state_101806__$1;
(statearr_101838_102003[(2)] = inst_101769);

(statearr_101838_102003[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (55))){
var inst_101660 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101839_102004 = state_101806__$1;
(statearr_101839_102004[(2)] = inst_101660);

(statearr_101839_102004[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (85))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101722 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_101723 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_101722,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,5,inst_101722,null));
var inst_101724 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101723,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101723,null));
var inst_101725 = (inst_101724.cljs$core$IFn$_invoke$arity$1 ? inst_101724.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101724.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101725)){
var statearr_101840_102005 = state_101806__$1;
(statearr_101840_102005[(1)] = (86));

} else {
var statearr_101841_102006 = state_101806__$1;
(statearr_101841_102006[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (39))){
var inst_101606 = (state_101806[(16)]);
var state_101806__$1 = state_101806;
var statearr_101842_102007 = state_101806__$1;
(statearr_101842_102007[(2)] = inst_101606);

(statearr_101842_102007[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (88))){
var inst_101730 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101843_102008 = state_101806__$1;
(statearr_101843_102008[(2)] = inst_101730);

(statearr_101843_102008[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (46))){
var inst_101644 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101644)){
var statearr_101844_102009 = state_101806__$1;
(statearr_101844_102009[(1)] = (47));

} else {
var statearr_101845_102010 = state_101806__$1;
(statearr_101845_102010[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101806,(3),Error,null,(2));
var inst_101520 = cljs.core.seq(pred_changes);
var inst_101521 = cljs.core.first(inst_101520);
var inst_101522 = cljs.core.next(inst_101520);
var inst_101523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101521,(0),null);
var inst_101524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101521,(1),null);
var inst_101525 = pred_changes;
var inst_101526 = db;
var state_101806__$1 = (function (){var statearr_101846 = state_101806;
(statearr_101846[(17)] = inst_101522);

(statearr_101846[(18)] = inst_101524);

(statearr_101846[(19)] = inst_101525);

(statearr_101846[(20)] = inst_101523);

(statearr_101846[(10)] = inst_101526);

return statearr_101846;
})();
var statearr_101847_102011 = state_101806__$1;
(statearr_101847_102011[(2)] = null);

(statearr_101847_102011[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (77))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101702 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_101703 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_101702,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,3,inst_101702,null));
var inst_101704 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101703,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101703,null));
var inst_101705 = (inst_101704.cljs$core$IFn$_invoke$arity$1 ? inst_101704.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101704.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101705)){
var statearr_101848_102012 = state_101806__$1;
(statearr_101848_102012[(1)] = (78));

} else {
var statearr_101849_102013 = state_101806__$1;
(statearr_101849_102013[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (106))){
var inst_101536 = (state_101806[(21)]);
var inst_101797 = (state_101806[(2)]);
var inst_101525 = inst_101536;
var inst_101526 = inst_101797;
var state_101806__$1 = (function (){var statearr_101850 = state_101806;
(statearr_101850[(19)] = inst_101525);

(statearr_101850[(10)] = inst_101526);

return statearr_101850;
})();
var statearr_101851_102014 = state_101806__$1;
(statearr_101851_102014[(2)] = null);

(statearr_101851_102014[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (95))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101748 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101852_102015 = state_101806__$1;
(statearr_101852_102015[(2)] = inst_101748);

(statearr_101852_102015[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (54))){
var state_101806__$1 = state_101806;
var statearr_101853_102016 = state_101806__$1;
(statearr_101853_102016[(2)] = false);

(statearr_101853_102016[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (92))){
var inst_101740 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101854_102017 = state_101806__$1;
(statearr_101854_102017[(2)] = inst_101740);

(statearr_101854_102017[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (104))){
var state_101806__$1 = state_101806;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_101855_102018 = state_101806__$1;
(statearr_101855_102018[(1)] = (107));

} else {
var statearr_101856_102019 = state_101806__$1;
(statearr_101856_102019[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (15))){
var inst_101538 = (state_101806[(12)]);
var inst_101559 = (state_101806[(22)]);
var inst_101558 = (state_101806[(2)]);
var inst_101559__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101857 = state_101806;
(statearr_101857[(23)] = inst_101558);

(statearr_101857[(22)] = inst_101559__$1);

return statearr_101857;
})();
if(cljs.core.truth_(inst_101559__$1)){
var statearr_101858_102020 = state_101806__$1;
(statearr_101858_102020[(1)] = (16));

} else {
var statearr_101859_102021 = state_101806__$1;
(statearr_101859_102021[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (48))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101860_102022 = state_101806__$1;
(statearr_101860_102022[(2)] = inst_101637);

(statearr_101860_102022[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (50))){
var inst_101647 = (state_101806[(24)]);
var inst_101652 = inst_101647.cljs$lang$protocol_mask$partition0$;
var inst_101653 = (inst_101652 & (64));
var inst_101654 = inst_101647.cljs$core$ISeq$;
var inst_101655 = (cljs.core.PROTOCOL_SENTINEL === inst_101654);
var inst_101656 = ((inst_101653) || (inst_101655));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101656)){
var statearr_101861_102023 = state_101806__$1;
(statearr_101861_102023[(1)] = (53));

} else {
var statearr_101862_102024 = state_101806__$1;
(statearr_101862_102024[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (75))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101698 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101863_102025 = state_101806__$1;
(statearr_101863_102025[(2)] = inst_101698);

(statearr_101863_102025[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (99))){
var inst_101767 = (state_101806[(25)]);
var state_101806__$1 = state_101806;
var statearr_101864_102026 = state_101806__$1;
(statearr_101864_102026[(2)] = inst_101767);

(statearr_101864_102026[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (21))){
var inst_101574 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101865_102027 = state_101806__$1;
(statearr_101865_102027[(2)] = inst_101574);

(statearr_101865_102027[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (31))){
var inst_101590 = (state_101806[(14)]);
var inst_101603 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_101590,"a component","a non-component",throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101866_102028 = state_101806__$1;
(statearr_101866_102028[(2)] = inst_101603);

(statearr_101866_102028[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (32))){
var inst_101590 = (state_101806[(14)]);
var state_101806__$1 = state_101806;
var statearr_101867_102029 = state_101806__$1;
(statearr_101867_102029[(2)] = inst_101590);

(statearr_101867_102029[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (40))){
var inst_101538 = (state_101806[(12)]);
var inst_101638 = (state_101806[(26)]);
var inst_101637 = (state_101806[(2)]);
var inst_101638__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101868 = state_101806;
(statearr_101868[(8)] = inst_101637);

(statearr_101868[(26)] = inst_101638__$1);

return statearr_101868;
})();
if(cljs.core.truth_(inst_101638__$1)){
var statearr_101869_102030 = state_101806__$1;
(statearr_101869_102030[(1)] = (44));

} else {
var statearr_101870_102031 = state_101806__$1;
(statearr_101870_102031[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (91))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101738 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101871_102032 = state_101806__$1;
(statearr_101871_102032[(2)] = inst_101738);

(statearr_101871_102032[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (108))){
var inst_101765 = (state_101806[(27)]);
var state_101806__$1 = state_101806;
var statearr_101872_102033 = state_101806__$1;
(statearr_101872_102033[(2)] = inst_101765);

(statearr_101872_102033[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (56))){
var inst_101647 = (state_101806[(24)]);
var inst_101665 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_101647);
var state_101806__$1 = state_101806;
var statearr_101873_102034 = state_101806__$1;
(statearr_101873_102034[(2)] = inst_101665);

(statearr_101873_102034[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (33))){
var inst_101607 = (state_101806[(28)]);
var inst_101538 = (state_101806[(12)]);
var inst_101606 = (state_101806[(2)]);
var inst_101607__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101874 = state_101806;
(statearr_101874[(28)] = inst_101607__$1);

(statearr_101874[(16)] = inst_101606);

return statearr_101874;
})();
if(cljs.core.truth_(inst_101607__$1)){
var statearr_101875_102035 = state_101806__$1;
(statearr_101875_102035[(1)] = (34));

} else {
var statearr_101876_102036 = state_101806__$1;
(statearr_101876_102036[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (13))){
var inst_101526 = (state_101806[(10)]);
var inst_101555 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_101526,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101877_102037 = state_101806__$1;
(statearr_101877_102037[(2)] = inst_101555);

(statearr_101877_102037[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (22))){
var state_101806__$1 = state_101806;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_101878_102038 = state_101806__$1;
(statearr_101878_102038[(1)] = (25));

} else {
var statearr_101879_102039 = state_101806__$1;
(statearr_101879_102039[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (90))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101880_102040 = state_101806__$1;
(statearr_101880_102040[(2)] = inst_101637);

(statearr_101880_102040[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (109))){
var inst_101794 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101881_102041 = state_101806__$1;
(statearr_101881_102041[(2)] = inst_101794);

(statearr_101881_102041[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (36))){
var inst_101622 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101622)){
var statearr_101882_102042 = state_101806__$1;
(statearr_101882_102042[(1)] = (38));

} else {
var statearr_101883_102043 = state_101806__$1;
(statearr_101883_102043[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (41))){
var inst_101537 = (state_101806[(29)]);
var inst_101526 = (state_101806[(10)]);
var inst_101625 = fluree.db.dbproto._p_prop(inst_101526,cljs.core.cst$kw$name,inst_101537);
var inst_101626 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_101625)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_101627 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_101628 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_101629 = cljs.core.PersistentHashMap.fromArrays(inst_101627,inst_101628);
var inst_101630 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_101626,inst_101629);
var inst_101631 = (function(){throw inst_101630})();
var state_101806__$1 = state_101806;
var statearr_101884_102044 = state_101806__$1;
(statearr_101884_102044[(2)] = inst_101631);

(statearr_101884_102044[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (89))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101732 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_101733 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_101732,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,5,inst_101732,null));
var inst_101734 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101733,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101733,null));
var inst_101735 = (inst_101734.cljs$core$IFn$_invoke$arity$1 ? inst_101734.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101734.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101735)){
var statearr_101885_102045 = state_101806__$1;
(statearr_101885_102045[(1)] = (90));

} else {
var statearr_101886_102046 = state_101806__$1;
(statearr_101886_102046[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (100))){
var inst_101784 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101784)){
var statearr_101887_102047 = state_101806__$1;
(statearr_101887_102047[(1)] = (104));

} else {
var statearr_101888_102048 = state_101806__$1;
(statearr_101888_102048[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (43))){
var inst_101634 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101889_102049 = state_101806__$1;
(statearr_101889_102049[(2)] = inst_101634);

(statearr_101889_102049[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (61))){
var inst_101762 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101890_102050 = state_101806__$1;
(statearr_101890_102050[(2)] = inst_101762);

(statearr_101890_102050[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (29))){
var inst_101591 = (state_101806[(13)]);
var state_101806__$1 = state_101806;
var statearr_101891_102051 = state_101806__$1;
(statearr_101891_102051[(2)] = inst_101591);

(statearr_101891_102051[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (44))){
var inst_101538 = (state_101806[(12)]);
var inst_101640 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101641 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_101640);
var state_101806__$1 = state_101806;
var statearr_101892_102052 = state_101806__$1;
(statearr_101892_102052[(2)] = inst_101641);

(statearr_101892_102052[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (93))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101742 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_101743 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_101742,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,2,inst_101742,null));
var inst_101744 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101743,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101743,null));
var inst_101745 = (inst_101744.cljs$core$IFn$_invoke$arity$1 ? inst_101744.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101744.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101745)){
var statearr_101893_102053 = state_101806__$1;
(statearr_101893_102053[(1)] = (94));

} else {
var statearr_101894_102054 = state_101806__$1;
(statearr_101894_102054[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (6))){
var inst_101802 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101895_102055 = state_101806__$1;
(statearr_101895_102055[(2)] = inst_101802);


cljs.core.async.impl.ioc_helpers.process_exception(state_101806__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (28))){
var inst_101538 = (state_101806[(12)]);
var inst_101593 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101594 = cljs.core.not(inst_101593);
var inst_101595 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101596 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101595);
var inst_101597 = inst_101596 === true;
var inst_101598 = ((inst_101594) && (inst_101597));
var state_101806__$1 = state_101806;
var statearr_101896_102056 = state_101806__$1;
(statearr_101896_102056[(2)] = inst_101598);

(statearr_101896_102056[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (64))){
var inst_101760 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101897_102057 = state_101806__$1;
(statearr_101897_102057[(2)] = inst_101760);

(statearr_101897_102057[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (103))){
var inst_101781 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101898_102058 = state_101806__$1;
(statearr_101898_102058[(2)] = inst_101781);

(statearr_101898_102058[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (51))){
var state_101806__$1 = state_101806;
var statearr_101899_102059 = state_101806__$1;
(statearr_101899_102059[(2)] = false);

(statearr_101899_102059[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (25))){
var inst_101580 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_101581 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_101582 = cljs.core.PersistentHashMap.fromArrays(inst_101580,inst_101581);
var inst_101583 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_101582);
var inst_101584 = (function(){throw inst_101583})();
var state_101806__$1 = state_101806;
var statearr_101900_102060 = state_101806__$1;
(statearr_101900_102060[(2)] = inst_101584);

(statearr_101900_102060[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (34))){
var inst_101537 = (state_101806[(29)]);
var inst_101538 = (state_101806[(12)]);
var inst_101526 = (state_101806[(10)]);
var inst_101609 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101610 = cljs.core.not(inst_101609);
var inst_101611 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101612 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101611);
var inst_101613 = inst_101612 === true;
var inst_101614 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_101526,inst_101537);
var state_101806__$1 = (function (){var statearr_101901 = state_101806;
(statearr_101901[(30)] = inst_101610);

(statearr_101901[(31)] = inst_101613);

return statearr_101901;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101806__$1,(37),inst_101614);
} else {
if((state_val_101807 === (17))){
var inst_101559 = (state_101806[(22)]);
var state_101806__$1 = state_101806;
var statearr_101902_102061 = state_101806__$1;
(statearr_101902_102061[(2)] = inst_101559);

(statearr_101902_102061[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (3))){
var inst_101503 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101903_102062 = state_101806__$1;
(statearr_101903_102062[(2)] = inst_101503);


cljs.core.async.impl.ioc_helpers.process_exception(state_101806__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (12))){
var inst_101553 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101553)){
var statearr_101904_102063 = state_101806__$1;
(statearr_101904_102063[(1)] = (13));

} else {
var statearr_101905_102064 = state_101806__$1;
(statearr_101905_102064[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (2))){
var inst_101804 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101806__$1,inst_101804);
} else {
if((state_val_101807 === (66))){
var state_101806__$1 = state_101806;
var statearr_101906_102065 = state_101806__$1;
(statearr_101906_102065[(2)] = null);

(statearr_101906_102065[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (107))){
var inst_101787 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_101788 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_101789 = cljs.core.PersistentHashMap.fromArrays(inst_101787,inst_101788);
var inst_101790 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_101789);
var inst_101791 = (function(){throw inst_101790})();
var state_101806__$1 = state_101806;
var statearr_101907_102066 = state_101806__$1;
(statearr_101907_102066[(2)] = inst_101791);

(statearr_101907_102066[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (23))){
var inst_101558 = (state_101806[(23)]);
var state_101806__$1 = state_101806;
var statearr_101908_102067 = state_101806__$1;
(statearr_101908_102067[(2)] = inst_101558);

(statearr_101908_102067[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (47))){
var inst_101647 = (state_101806[(24)]);
var inst_101538 = (state_101806[(12)]);
var inst_101647__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101649 = (inst_101647__$1 == null);
var inst_101650 = cljs.core.not(inst_101649);
var state_101806__$1 = (function (){var statearr_101909 = state_101806;
(statearr_101909[(24)] = inst_101647__$1);

return statearr_101909;
})();
if(inst_101650){
var statearr_101910_102068 = state_101806__$1;
(statearr_101910_102068[(1)] = (50));

} else {
var statearr_101911_102069 = state_101806__$1;
(statearr_101911_102069[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (35))){
var inst_101607 = (state_101806[(28)]);
var state_101806__$1 = state_101806;
var statearr_101912_102070 = state_101806__$1;
(statearr_101912_102070[(2)] = inst_101607);

(statearr_101912_102070[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (82))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101913_102071 = state_101806__$1;
(statearr_101913_102071[(2)] = inst_101637);

(statearr_101913_102071[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (76))){
var inst_101700 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101914_102072 = state_101806__$1;
(statearr_101914_102072[(2)] = inst_101700);

(statearr_101914_102072[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (97))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101752 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101915_102073 = state_101806__$1;
(statearr_101915_102073[(2)] = inst_101752);

(statearr_101915_102073[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (19))){
var inst_101538 = (state_101806[(12)]);
var inst_101563 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101564 = inst_101563 === true;
var inst_101565 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101566 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101565);
var inst_101567 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_101566);
var inst_101568 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101569 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101568);
var inst_101570 = inst_101569 === true;
var inst_101571 = ((inst_101564) && (inst_101567) && (inst_101570));
var state_101806__$1 = state_101806;
var statearr_101916_102074 = state_101806__$1;
(statearr_101916_102074[(2)] = inst_101571);

(statearr_101916_102074[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (57))){
var inst_101647 = (state_101806[(24)]);
var state_101806__$1 = state_101806;
var statearr_101917_102075 = state_101806__$1;
(statearr_101917_102075[(2)] = inst_101647);

(statearr_101917_102075[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (68))){
var inst_101755 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101918_102076 = state_101806__$1;
(statearr_101918_102076[(2)] = inst_101755);

(statearr_101918_102076[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (11))){
var inst_101542 = (state_101806[(32)]);
var state_101806__$1 = state_101806;
var statearr_101919_102077 = state_101806__$1;
(statearr_101919_102077[(2)] = inst_101542);

(statearr_101919_102077[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (9))){
var inst_101800 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101920_102078 = state_101806__$1;
(statearr_101920_102078[(2)] = inst_101800);

(statearr_101920_102078[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (5))){
var inst_101537 = (state_101806[(29)]);
var inst_101525 = (state_101806[(19)]);
var inst_101534 = cljs.core.seq(inst_101525);
var inst_101535 = cljs.core.first(inst_101534);
var inst_101536 = cljs.core.next(inst_101534);
var inst_101537__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101535,(0),null);
var inst_101538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_101535,(1),null);
var inst_101539 = cljs.core.not(inst_101537__$1);
var state_101806__$1 = (function (){var statearr_101921 = state_101806;
(statearr_101921[(29)] = inst_101537__$1);

(statearr_101921[(12)] = inst_101538);

(statearr_101921[(21)] = inst_101536);

return statearr_101921;
})();
if(inst_101539){
var statearr_101922_102079 = state_101806__$1;
(statearr_101922_102079[(1)] = (7));

} else {
var statearr_101923_102080 = state_101806__$1;
(statearr_101923_102080[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (83))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101718 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101924_102081 = state_101806__$1;
(statearr_101924_102081[(2)] = inst_101718);

(statearr_101924_102081[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (14))){
var inst_101526 = (state_101806[(10)]);
var state_101806__$1 = state_101806;
var statearr_101925_102082 = state_101806__$1;
(statearr_101925_102082[(2)] = inst_101526);

(statearr_101925_102082[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (45))){
var inst_101638 = (state_101806[(26)]);
var state_101806__$1 = state_101806;
var statearr_101926_102083 = state_101806__$1;
(statearr_101926_102083[(2)] = inst_101638);

(statearr_101926_102083[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (53))){
var state_101806__$1 = state_101806;
var statearr_101927_102084 = state_101806__$1;
(statearr_101927_102084[(2)] = true);

(statearr_101927_102084[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (78))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101928_102085 = state_101806__$1;
(statearr_101928_102085[(2)] = inst_101637);

(statearr_101928_102085[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (26))){
var inst_101558 = (state_101806[(23)]);
var state_101806__$1 = state_101806;
var statearr_101929_102086 = state_101806__$1;
(statearr_101929_102086[(2)] = inst_101558);

(statearr_101929_102086[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (16))){
var inst_101538 = (state_101806[(12)]);
var inst_101561 = (state_101806[(11)]);
var inst_101561__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101930 = state_101806;
(statearr_101930[(11)] = inst_101561__$1);

return statearr_101930;
})();
if(cljs.core.truth_(inst_101561__$1)){
var statearr_101931_102087 = state_101806__$1;
(statearr_101931_102087[(1)] = (19));

} else {
var statearr_101932_102088 = state_101806__$1;
(statearr_101932_102088[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (81))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101712 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_101713 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_101712,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,3,inst_101712,null));
var inst_101714 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101713,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101713,null));
var inst_101715 = (inst_101714.cljs$core$IFn$_invoke$arity$1 ? inst_101714.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101714.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101715)){
var statearr_101933_102089 = state_101806__$1;
(statearr_101933_102089[(1)] = (82));

} else {
var statearr_101934_102090 = state_101806__$1;
(statearr_101934_102090[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (79))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101708 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101935_102091 = state_101806__$1;
(statearr_101935_102091[(2)] = inst_101708);

(statearr_101935_102091[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (38))){
var state_101806__$1 = state_101806;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_101936_102092 = state_101806__$1;
(statearr_101936_102092[(1)] = (41));

} else {
var statearr_101937_102093 = state_101806__$1;
(statearr_101937_102093[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (98))){
var inst_101538 = (state_101806[(12)]);
var inst_101769 = (state_101806[(15)]);
var inst_101769__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101938 = state_101806;
(statearr_101938[(15)] = inst_101769__$1);

return statearr_101938;
})();
if(cljs.core.truth_(inst_101769__$1)){
var statearr_101939_102094 = state_101806__$1;
(statearr_101939_102094[(1)] = (101));

} else {
var statearr_101940_102095 = state_101806__$1;
(statearr_101940_102095[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (87))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101728 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101941_102096 = state_101806__$1;
(statearr_101941_102096[(2)] = inst_101728);

(statearr_101941_102096[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (30))){
var inst_101601 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101601)){
var statearr_101942_102097 = state_101806__$1;
(statearr_101942_102097[(1)] = (31));

} else {
var statearr_101943_102098 = state_101806__$1;
(statearr_101943_102098[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (73))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101692 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_101693 = (inst_101670.cljs$core$IFn$_invoke$arity$5 ? inst_101670.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_101692,null) : inst_101670.call(null,cljs.core.PersistentArrayMap,null,3,inst_101692,null));
var inst_101694 = (inst_101670.cljs$core$IFn$_invoke$arity$4 ? inst_101670.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_101693,null) : inst_101670.call(null,cljs.core.PersistentHashSet,null,inst_101693,null));
var inst_101695 = (inst_101694.cljs$core$IFn$_invoke$arity$1 ? inst_101694.cljs$core$IFn$_invoke$arity$1(inst_101669) : inst_101694.call(null,inst_101669));
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101695)){
var statearr_101944_102099 = state_101806__$1;
(statearr_101944_102099[(1)] = (74));

} else {
var statearr_101945_102100 = state_101806__$1;
(statearr_101945_102100[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (96))){
var inst_101750 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101946_102101 = state_101806__$1;
(statearr_101946_102101[(2)] = inst_101750);

(statearr_101946_102101[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (10))){
var inst_101538 = (state_101806[(12)]);
var inst_101544 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101545 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_101544);
var inst_101546 = inst_101545 === false;
var inst_101547 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101548 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_101547);
var inst_101549 = inst_101548 === true;
var inst_101550 = ((inst_101546) && (inst_101549));
var state_101806__$1 = state_101806;
var statearr_101947_102102 = state_101806__$1;
(statearr_101947_102102[(2)] = inst_101550);

(statearr_101947_102102[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (18))){
var inst_101577 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101577)){
var statearr_101948_102103 = state_101806__$1;
(statearr_101948_102103[(1)] = (22));

} else {
var statearr_101949_102104 = state_101806__$1;
(statearr_101949_102104[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (105))){
var inst_101765 = (state_101806[(27)]);
var state_101806__$1 = state_101806;
var statearr_101950_102105 = state_101806__$1;
(statearr_101950_102105[(2)] = inst_101765);

(statearr_101950_102105[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (52))){
var inst_101663 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
if(cljs.core.truth_(inst_101663)){
var statearr_101951_102106 = state_101806__$1;
(statearr_101951_102106[(1)] = (56));

} else {
var statearr_101952_102107 = state_101806__$1;
(statearr_101952_102107[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (67))){
var inst_101758 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101953_102108 = state_101806__$1;
(statearr_101953_102108[(2)] = inst_101758);

(statearr_101953_102108[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (71))){
var inst_101669 = (state_101806[(9)]);
var inst_101670 = (state_101806[(7)]);
var inst_101688 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_101669,inst_101670,throw_QMARK_);
var state_101806__$1 = state_101806;
var statearr_101954_102109 = state_101806__$1;
(statearr_101954_102109[(2)] = inst_101688);

(statearr_101954_102109[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (42))){
var inst_101606 = (state_101806[(16)]);
var state_101806__$1 = state_101806;
var statearr_101955_102110 = state_101806__$1;
(statearr_101955_102110[(2)] = inst_101606);

(statearr_101955_102110[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (80))){
var inst_101710 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101956_102111 = state_101806__$1;
(statearr_101956_102111[(2)] = inst_101710);

(statearr_101956_102111[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (37))){
var inst_101610 = (state_101806[(30)]);
var inst_101613 = (state_101806[(31)]);
var inst_101616 = (state_101806[(2)]);
var inst_101617 = fluree.db.util.async.throw_err(inst_101616);
var inst_101618 = cljs.core.not(inst_101617);
var inst_101619 = ((inst_101610) && (inst_101613) && (inst_101618));
var state_101806__$1 = state_101806;
var statearr_101957_102112 = state_101806__$1;
(statearr_101957_102112[(2)] = inst_101619);

(statearr_101957_102112[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (63))){
var state_101806__$1 = state_101806;
var statearr_101958_102113 = state_101806__$1;
(statearr_101958_102113[(1)] = (65));



return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (94))){
var inst_101637 = (state_101806[(8)]);
var state_101806__$1 = state_101806;
var statearr_101960_102114 = state_101806__$1;
(statearr_101960_102114[(2)] = inst_101637);

(statearr_101960_102114[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (8))){
var inst_101538 = (state_101806[(12)]);
var inst_101542 = (state_101806[(32)]);
var inst_101542__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_101538);
var state_101806__$1 = (function (){var statearr_101961 = state_101806;
(statearr_101961[(32)] = inst_101542__$1);

return statearr_101961;
})();
if(cljs.core.truth_(inst_101542__$1)){
var statearr_101962_102115 = state_101806__$1;
(statearr_101962_102115[(1)] = (10));

} else {
var statearr_101963_102116 = state_101806__$1;
(statearr_101963_102116[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (49))){
var inst_101767 = (state_101806[(25)]);
var inst_101538 = (state_101806[(12)]);
var inst_101765 = (state_101806[(2)]);
var inst_101766 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_101538);
var inst_101767__$1 = inst_101766 === true;
var state_101806__$1 = (function (){var statearr_101964 = state_101806;
(statearr_101964[(25)] = inst_101767__$1);

(statearr_101964[(27)] = inst_101765);

return statearr_101964;
})();
if(cljs.core.truth_(inst_101767__$1)){
var statearr_101965_102117 = state_101806__$1;
(statearr_101965_102117[(1)] = (98));

} else {
var statearr_101966_102118 = state_101806__$1;
(statearr_101966_102118[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101807 === (84))){
var inst_101720 = (state_101806[(2)]);
var state_101806__$1 = state_101806;
var statearr_101967_102119 = state_101806__$1;
(statearr_101967_102119[(2)] = inst_101720);

(statearr_101967_102119[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$state_machine__99037__auto__ = null;
var fluree$db$query$schema$state_machine__99037__auto____0 = (function (){
var statearr_101968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101968[(0)] = fluree$db$query$schema$state_machine__99037__auto__);

(statearr_101968[(1)] = (1));

return statearr_101968;
});
var fluree$db$query$schema$state_machine__99037__auto____1 = (function (state_101806){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101806);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101969){if((e101969 instanceof Object)){
var ex__99040__auto__ = e101969;
var statearr_101970_102120 = state_101806;
(statearr_101970_102120[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101806);

return cljs.core.cst$kw$recur;
} else {
throw e101969;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102121 = state_101806;
state_101806 = G__102121;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__99037__auto__ = function(state_101806){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__99037__auto____1.call(this,state_101806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__99037__auto____0;
fluree$db$query$schema$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__99037__auto____1;
return fluree$db$query$schema$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101971 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101971[(6)] = c__99059__auto__);

return statearr_101971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3;

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102142){
var state_val_102143 = (state_102142[(1)]);
if((state_val_102143 === (7))){
var inst_102129 = (state_102142[(7)]);
var inst_102133 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_102129,db,true);
var state_102142__$1 = state_102142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102142__$1,(9),inst_102133);
} else {
if((state_val_102143 === (1))){
var state_102142__$1 = state_102142;
var statearr_102144_102156 = state_102142__$1;
(statearr_102144_102156[(2)] = null);

(statearr_102144_102156[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102143 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102142,(3),Error,null,(2));
var inst_102126 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_102142__$1 = state_102142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102142__$1,(5),inst_102126);
} else {
if((state_val_102143 === (6))){
var state_102142__$1 = state_102142;
var statearr_102145_102157 = state_102142__$1;
(statearr_102145_102157[(2)] = db);

(statearr_102145_102157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102143 === (3))){
var inst_102122 = (state_102142[(2)]);
var state_102142__$1 = state_102142;
var statearr_102146_102158 = state_102142__$1;
(statearr_102146_102158[(2)] = inst_102122);


cljs.core.async.impl.ioc_helpers.process_exception(state_102142__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102143 === (2))){
var inst_102140 = (state_102142[(2)]);
var state_102142__$1 = state_102142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102142__$1,inst_102140);
} else {
if((state_val_102143 === (9))){
var inst_102135 = (state_102142[(2)]);
var inst_102136 = fluree.db.util.async.throw_err(inst_102135);
var state_102142__$1 = state_102142;
var statearr_102147_102159 = state_102142__$1;
(statearr_102147_102159[(2)] = inst_102136);

(statearr_102147_102159[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102143 === (5))){
var inst_102129 = (state_102142[(7)]);
var inst_102128 = (state_102142[(2)]);
var inst_102129__$1 = fluree.db.util.async.throw_err(inst_102128);
var inst_102130 = cljs.core.empty_QMARK_(inst_102129__$1);
var state_102142__$1 = (function (){var statearr_102148 = state_102142;
(statearr_102148[(7)] = inst_102129__$1);

return statearr_102148;
})();
if(inst_102130){
var statearr_102149_102160 = state_102142__$1;
(statearr_102149_102160[(1)] = (6));

} else {
var statearr_102150_102161 = state_102142__$1;
(statearr_102150_102161[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102143 === (8))){
var inst_102138 = (state_102142[(2)]);
var state_102142__$1 = state_102142;
var statearr_102151_102162 = state_102142__$1;
(statearr_102151_102162[(2)] = inst_102138);


cljs.core.async.impl.ioc_helpers.process_exception(state_102142__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____0 = (function (){
var statearr_102152 = [null,null,null,null,null,null,null,null];
(statearr_102152[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__);

(statearr_102152[(1)] = (1));

return statearr_102152;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____1 = (function (state_102142){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102142);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102153){if((e102153 instanceof Object)){
var ex__99040__auto__ = e102153;
var statearr_102154_102163 = state_102142;
(statearr_102154_102163[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102142);

return cljs.core.cst$kw$recur;
} else {
throw e102153;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102164 = state_102142;
state_102142 = G__102164;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__ = function(state_102142){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____1.call(this,state_102142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102155 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102155[(6)] = c__99059__auto__);

return statearr_102155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__102166 = arguments.length;
switch (G__102166) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2;

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__102168 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102168,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102168,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102168,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4120__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,((function (p,o,existing_QMARK_){
return (function (p1__102171_SHARP_,p2__102172_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__102171_SHARP_,p2__102172_SHARP_], null));
});})(p,o,existing_QMARK_))
,o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102235){
var state_val_102236 = (state_102235[(1)]);
if((state_val_102236 === (1))){
var state_102235__$1 = state_102235;
var statearr_102237_102248 = state_102235__$1;
(statearr_102237_102248[(2)] = null);

(statearr_102237_102248[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102236 === (2))){
var inst_102233 = (state_102235[(2)]);
var state_102235__$1 = state_102235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102235__$1,inst_102233);
} else {
if((state_val_102236 === (3))){
var inst_102178 = (state_102235[(2)]);
var state_102235__$1 = state_102235;
var statearr_102238_102249 = state_102235__$1;
(statearr_102238_102249[(2)] = inst_102178);


cljs.core.async.impl.ioc_helpers.process_exception(state_102235__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102236 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102235,(3),Error,null,(2));
var inst_102188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102189 = fluree.db.flake.max_subject_id((1));
var inst_102190 = [inst_102189];
var inst_102191 = (new cljs.core.PersistentVector(null,1,(5),inst_102188,inst_102190,null));
var inst_102192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102193 = [(0)];
var inst_102194 = (new cljs.core.PersistentVector(null,1,(5),inst_102192,inst_102193,null));
var inst_102195 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_102191,cljs.core._LT__EQ_,inst_102194);
var state_102235__$1 = state_102235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102235__$1,(5),inst_102195);
} else {
if((state_val_102236 === (5))){
var inst_102197 = (state_102235[(2)]);
var inst_102198 = fluree.db.util.async.throw_err(inst_102197);
var inst_102199 = (function (){var schema_flakes = inst_102198;
return ((function (schema_flakes,inst_102197,inst_102198,state_val_102236,c__99059__auto__){
return (function (p1__102173_SHARP_){
return (p1__102173_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
;})(schema_flakes,inst_102197,inst_102198,state_val_102236,c__99059__auto__))
})();
var inst_102200 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_102199,inst_102198);
var inst_102201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102200,(0),null);
var inst_102202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102200,(1),null);
var inst_102203 = (function (){var schema_flakes = inst_102198;
var vec__102182 = inst_102200;
var collection_flakes = inst_102201;
var predicate_flakes = inst_102202;
return ((function (schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,state_val_102236,c__99059__auto__){
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sid,id,schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,state_val_102236,c__99059__auto__){
return (function (p1__102175_SHARP_,p2__102176_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__102175_SHARP_,p2__102176_SHARP_.p,p2__102176_SHARP_.o);
});})(sid,id,schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,state_val_102236,c__99059__auto__))
,cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
;})(schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,state_val_102236,c__99059__auto__))
})();
var inst_102204 = [(-1),"_tx"];
var inst_102205 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_102206 = ["_tx",(-1),(-1)];
var inst_102207 = cljs.core.PersistentHashMap.fromArrays(inst_102205,inst_102206);
var inst_102208 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_102209 = ["_tx",(-1),(-1)];
var inst_102210 = cljs.core.PersistentHashMap.fromArrays(inst_102208,inst_102209);
var inst_102211 = [inst_102207,inst_102210];
var inst_102212 = cljs.core.PersistentHashMap.fromArrays(inst_102204,inst_102211);
var inst_102213 = (function (){var schema_flakes = inst_102198;
var vec__102182 = inst_102200;
var collection_flakes = inst_102201;
var predicate_flakes = inst_102202;
return ((function (schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,state_val_102236,c__99059__auto__){
return (function (p1__102174_SHARP_){
return p1__102174_SHARP_.s;
});
;})(schema_flakes,vec__102182,collection_flakes,predicate_flakes,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,state_val_102236,c__99059__auto__))
})();
var inst_102214 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_102213,inst_102201);
var inst_102215 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_102203,inst_102212,inst_102214);
var inst_102217 = (function (){var schema_flakes = inst_102198;
var vec__102182 = inst_102200;
var collection_flakes = inst_102201;
var predicate_flakes = inst_102202;
var coll = inst_102215;
return ((function (schema_flakes,vec__102182,collection_flakes,predicate_flakes,coll,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,inst_102213,inst_102214,inst_102215,state_val_102236,c__99059__auto__){
return (function (p__102216,pred_flakes){
var vec__102239 = p__102216;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102239,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102239,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__102242 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__102242.cljs$core$IFn$_invoke$arity$1 ? fexpr__102242.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__102242.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4131__auto__ = ref_QMARK_;
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
;})(schema_flakes,vec__102182,collection_flakes,predicate_flakes,coll,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,inst_102213,inst_102214,inst_102215,state_val_102236,c__99059__auto__))
})();
var inst_102218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102219 = cljs.core.PersistentHashMap.EMPTY;
var inst_102220 = cljs.core.PersistentHashSet.EMPTY;
var inst_102221 = [inst_102219,inst_102220];
var inst_102222 = (new cljs.core.PersistentVector(null,2,(5),inst_102218,inst_102221,null));
var inst_102223 = (function (){var schema_flakes = inst_102198;
var vec__102182 = inst_102200;
var collection_flakes = inst_102201;
var predicate_flakes = inst_102202;
var coll = inst_102215;
return ((function (schema_flakes,vec__102182,collection_flakes,predicate_flakes,coll,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,inst_102213,inst_102214,inst_102215,inst_102217,inst_102218,inst_102219,inst_102220,inst_102221,inst_102222,state_val_102236,c__99059__auto__){
return (function (p1__102177_SHARP_){
return p1__102177_SHARP_.s;
});
;})(schema_flakes,vec__102182,collection_flakes,predicate_flakes,coll,inst_102197,inst_102198,inst_102199,inst_102200,inst_102201,inst_102202,inst_102203,inst_102204,inst_102205,inst_102206,inst_102207,inst_102208,inst_102209,inst_102210,inst_102211,inst_102212,inst_102213,inst_102214,inst_102215,inst_102217,inst_102218,inst_102219,inst_102220,inst_102221,inst_102222,state_val_102236,c__99059__auto__))
})();
var inst_102224 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_102223,inst_102202);
var inst_102225 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_102217,inst_102222,inst_102224);
var inst_102226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102225,(0),null);
var inst_102227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_102225,(1),null);
var inst_102228 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_102229 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_102230 = [inst_102229,inst_102215,inst_102226,inst_102227];
var inst_102231 = cljs.core.PersistentHashMap.fromArrays(inst_102228,inst_102230);
var state_102235__$1 = state_102235;
var statearr_102243_102250 = state_102235__$1;
(statearr_102243_102250[(2)] = inst_102231);


cljs.core.async.impl.ioc_helpers.process_exception(state_102235__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__99037__auto____0 = (function (){
var statearr_102244 = [null,null,null,null,null,null,null];
(statearr_102244[(0)] = fluree$db$query$schema$schema_map_$_state_machine__99037__auto__);

(statearr_102244[(1)] = (1));

return statearr_102244;
});
var fluree$db$query$schema$schema_map_$_state_machine__99037__auto____1 = (function (state_102235){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102235);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102245){if((e102245 instanceof Object)){
var ex__99040__auto__ = e102245;
var statearr_102246_102251 = state_102235;
(statearr_102246_102251[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102235);

return cljs.core.cst$kw$recur;
} else {
throw e102245;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102252 = state_102235;
state_102235 = G__102252;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__99037__auto__ = function(state_102235){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__99037__auto____1.call(this,state_102235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__99037__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__99037__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102247 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102247[(6)] = c__99059__auto__);

return statearr_102247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102288){
var state_val_102289 = (state_102288[(1)]);
if((state_val_102289 === (1))){
var state_102288__$1 = state_102288;
var statearr_102290_102301 = state_102288__$1;
(statearr_102290_102301[(2)] = null);

(statearr_102290_102301[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102289 === (2))){
var inst_102286 = (state_102288[(2)]);
var state_102288__$1 = state_102288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102288__$1,inst_102286);
} else {
if((state_val_102289 === (3))){
var inst_102253 = (state_102288[(2)]);
var state_102288__$1 = state_102288;
var statearr_102291_102302 = state_102288__$1;
(statearr_102291_102302[(2)] = inst_102253);


cljs.core.async.impl.ioc_helpers.process_exception(state_102288__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102289 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102288,(3),Error,null,(2));
var state_102288__$1 = state_102288;
var statearr_102292_102303 = state_102288__$1;
(statearr_102292_102303[(2)] = null);

(statearr_102292_102303[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102289 === (5))){
var inst_102272 = (state_102288[(2)]);
var inst_102273 = fluree.db.query.schema.flake__GT_pred_map(inst_102272);
var inst_102274 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_102275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(114));
var inst_102276 = cljs.core.boolean$(inst_102275);
var inst_102277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(110));
var inst_102278 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(117));
var inst_102279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_102278);
var inst_102280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(111));
var inst_102281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(115));
var inst_102282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102273,(112));
var inst_102283 = [inst_102276,inst_102277,inst_102279,inst_102280,inst_102281,inst_102282];
var inst_102284 = cljs.core.PersistentHashMap.fromArrays(inst_102274,inst_102283);
var state_102288__$1 = state_102288;
var statearr_102293_102304 = state_102288__$1;
(statearr_102293_102304[(2)] = inst_102284);


cljs.core.async.impl.ioc_helpers.process_exception(state_102288__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102289 === (6))){
var inst_102257 = (state_102288[(2)]);
var state_102288__$1 = (function (){var statearr_102294 = state_102288;
(statearr_102294[(7)] = inst_102257);

return statearr_102294;
})();
var statearr_102295_102305 = state_102288__$1;
(statearr_102295_102305[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_102288__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102289 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102288,(6),java.lang.Exception,null,(5));
var inst_102261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102263 = ["_setting/id","root"];
var inst_102264 = (new cljs.core.PersistentVector(null,2,(5),inst_102262,inst_102263,null));
var inst_102265 = [inst_102264];
var inst_102266 = (new cljs.core.PersistentVector(null,1,(5),inst_102261,inst_102265,null));
var inst_102267 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_102266);
var state_102288__$1 = state_102288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102288__$1,(8),inst_102267);
} else {
if((state_val_102289 === (8))){
var inst_102269 = (state_102288[(2)]);
var inst_102270 = fluree.db.util.async.throw_err(inst_102269);
var state_102288__$1 = state_102288;
var statearr_102296_102306 = state_102288__$1;
(statearr_102296_102306[(2)] = inst_102270);


cljs.core.async.impl.ioc_helpers.process_exception(state_102288__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__99037__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__99037__auto____0 = (function (){
var statearr_102297 = [null,null,null,null,null,null,null,null];
(statearr_102297[(0)] = fluree$db$query$schema$setting_map_$_state_machine__99037__auto__);

(statearr_102297[(1)] = (1));

return statearr_102297;
});
var fluree$db$query$schema$setting_map_$_state_machine__99037__auto____1 = (function (state_102288){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102288);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102298){if((e102298 instanceof Object)){
var ex__99040__auto__ = e102298;
var statearr_102299_102307 = state_102288;
(statearr_102299_102307[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102288);

return cljs.core.cst$kw$recur;
} else {
throw e102298;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102308 = state_102288;
state_102288 = G__102308;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__99037__auto__ = function(state_102288){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__99037__auto____1.call(this,state_102288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__99037__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__99037__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102300 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102300[(6)] = c__99059__auto__);

return statearr_102300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});

//# sourceMappingURL=schema.js.map?rel=1593118616270
