// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k102488,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__102492 = k102488;
var G__102492__$1 = (((G__102492 instanceof cljs.core.Keyword))?G__102492.fqn:null);
switch (G__102492__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k102488,else__4388__auto__);

}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__102493){
var vec__102494 = p__102493;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102494,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102494,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__102487){
var self__ = this;
var G__102487__$1 = this;
return (new cljs.core.RecordIter((0),G__102487__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__102497 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__102497(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this102489,other102490){
var self__ = this;
var this102489__$1 = this;
return (((!((other102490 == null)))) && ((this102489__$1.constructor === other102490.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102489__$1.index_type,other102490.index_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102489__$1.comparator,other102490.comparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102489__$1.historyComparator,other102490.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102489__$1.__extmap,other102490.__extmap)));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__102487){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__102498 = cljs.core.keyword_identical_QMARK_;
var expr__102499 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__102501 = cljs.core.cst$kw$index_DASH_type;
var G__102502 = expr__102499;
return (pred__102498.cljs$core$IFn$_invoke$arity$2 ? pred__102498.cljs$core$IFn$_invoke$arity$2(G__102501,G__102502) : pred__102498.call(null,G__102501,G__102502));
})())){
return (new fluree.db.index.IndexConfig(G__102487,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102503 = cljs.core.cst$kw$comparator;
var G__102504 = expr__102499;
return (pred__102498.cljs$core$IFn$_invoke$arity$2 ? pred__102498.cljs$core$IFn$_invoke$arity$2(G__102503,G__102504) : pred__102498.call(null,G__102503,G__102504));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__102487,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102505 = cljs.core.cst$kw$historyComparator;
var G__102506 = expr__102499;
return (pred__102498.cljs$core$IFn$_invoke$arity$2 ? pred__102498.cljs$core$IFn$_invoke$arity$2(G__102505,G__102506) : pred__102498.call(null,G__102505,G__102506));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__102487,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__102487),null));
}
}
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__102487){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__102487,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
});

fluree.db.index.IndexConfig.cljs$lang$type = true;

fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
});

fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/IndexConfig");
});

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__102491){
var extmap__4424__auto__ = (function (){var G__102507 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__102491,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__102491)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__102507);
} else {
return G__102507;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__102491),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__102491),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__102491),null,cljs.core.not_empty(extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k102510,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__102514 = k102510;
var G__102514__$1 = (((G__102514 instanceof cljs.core.Keyword))?G__102514.fqn:null);
switch (G__102514__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k102510,else__4388__auto__);

}
});

fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__102515){
var vec__102516 = p__102515;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102516,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102516,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
});

fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__102509){
var self__ = this;
var G__102509__$1 = this;
return (new cljs.core.RecordIter((0),G__102509__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_102520){
var state_val_102521 = (state_102520[(1)]);
if((state_val_102521 === (1))){
var state_102520__$1 = state_102520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102520__$1,this$__$1);
} else {
return null;
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__99037__auto__ = null;
var fluree$db$index$state_machine__99037__auto____0 = (function (){
var statearr_102522 = [null,null,null,null,null,null,null];
(statearr_102522[(0)] = fluree$db$index$state_machine__99037__auto__);

(statearr_102522[(1)] = (1));

return statearr_102522;
});
var fluree$db$index$state_machine__99037__auto____1 = (function (state_102520){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102520);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102523){if((e102523 instanceof Object)){
var ex__99040__auto__ = e102523;
var statearr_102524_102614 = state_102520;
(statearr_102524_102614[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102520);

return cljs.core.cst$kw$recur;
} else {
throw e102523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102615 = state_102520;
state_102520 = G__102615;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$index$state_machine__99037__auto__ = function(state_102520){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99037__auto____1.call(this,state_102520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99037__auto____0;
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99037__auto____1;
return fluree$db$index$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_102525 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102525[(6)] = c__99059__auto__);

return statearr_102525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4131__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4131__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_102547){
var state_val_102548 = (state_102547[(1)]);
if((state_val_102548 === (7))){
var inst_102543 = (state_102547[(2)]);
var state_102547__$1 = state_102547;
var statearr_102549_102616 = state_102547__$1;
(statearr_102549_102616[(2)] = inst_102543);


cljs.core.async.impl.ioc_helpers.process_exception(state_102547__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102548 === (1))){
var state_102547__$1 = state_102547;
var statearr_102550_102617 = state_102547__$1;
(statearr_102550_102617[(2)] = null);

(statearr_102550_102617[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102548 === (4))){
var inst_102530 = (state_102547[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102547,(3),Error,null,(2));
var inst_102530__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_102531 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_102530__$1);
var state_102547__$1 = (function (){var statearr_102551 = state_102547;
(statearr_102551[(7)] = inst_102530__$1);

return statearr_102551;
})();
if(cljs.core.truth_(inst_102531)){
var statearr_102552_102618 = state_102547__$1;
(statearr_102552_102618[(1)] = (5));

} else {
var statearr_102553_102619 = state_102547__$1;
(statearr_102553_102619[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102548 === (6))){
var inst_102530 = (state_102547[(7)]);
var inst_102534 = fluree.db.dbproto._resolve(inst_102530);
var state_102547__$1 = state_102547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102547__$1,(9),inst_102534);
} else {
if((state_val_102548 === (3))){
var inst_102526 = (state_102547[(2)]);
var state_102547__$1 = state_102547;
var statearr_102554_102620 = state_102547__$1;
(statearr_102554_102620[(2)] = inst_102526);


cljs.core.async.impl.ioc_helpers.process_exception(state_102547__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102548 === (2))){
var inst_102545 = (state_102547[(2)]);
var state_102547__$1 = state_102547;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102547__$1,inst_102545);
} else {
if((state_val_102548 === (9))){
var inst_102536 = (state_102547[(2)]);
var inst_102537 = fluree.db.util.async.throw_err(inst_102536);
var inst_102538 = fluree.db.dbproto._lookup_leaf(inst_102537,flake);
var state_102547__$1 = state_102547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102547__$1,(8),inst_102538);
} else {
if((state_val_102548 === (5))){
var inst_102530 = (state_102547[(7)]);
var state_102547__$1 = state_102547;
var statearr_102555_102621 = state_102547__$1;
(statearr_102555_102621[(2)] = inst_102530);

(statearr_102555_102621[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102548 === (8))){
var inst_102540 = (state_102547[(2)]);
var inst_102541 = fluree.db.util.async.throw_err(inst_102540);
var state_102547__$1 = state_102547;
var statearr_102556_102622 = state_102547__$1;
(statearr_102556_102622[(2)] = inst_102541);

(statearr_102556_102622[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__99037__auto__ = null;
var fluree$db$index$state_machine__99037__auto____0 = (function (){
var statearr_102557 = [null,null,null,null,null,null,null,null];
(statearr_102557[(0)] = fluree$db$index$state_machine__99037__auto__);

(statearr_102557[(1)] = (1));

return statearr_102557;
});
var fluree$db$index$state_machine__99037__auto____1 = (function (state_102547){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102547);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102558){if((e102558 instanceof Object)){
var ex__99040__auto__ = e102558;
var statearr_102559_102623 = state_102547;
(statearr_102559_102623[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102547);

return cljs.core.cst$kw$recur;
} else {
throw e102558;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102624 = state_102547;
state_102547 = G__102624;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$index$state_machine__99037__auto__ = function(state_102547){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99037__auto____1.call(this,state_102547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99037__auto____0;
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99037__auto____1;
return fluree$db$index$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_102560 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102560[(6)] = c__99059__auto__);

return statearr_102560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_102582){
var state_val_102583 = (state_102582[(1)]);
if((state_val_102583 === (7))){
var inst_102578 = (state_102582[(2)]);
var state_102582__$1 = state_102582;
var statearr_102584_102625 = state_102582__$1;
(statearr_102584_102625[(2)] = inst_102578);


cljs.core.async.impl.ioc_helpers.process_exception(state_102582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102583 === (1))){
var state_102582__$1 = state_102582;
var statearr_102585_102626 = state_102582__$1;
(statearr_102585_102626[(2)] = null);

(statearr_102585_102626[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102583 === (4))){
var inst_102565 = (state_102582[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102582,(3),Error,null,(2));
var inst_102565__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_102566 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_102565__$1);
var state_102582__$1 = (function (){var statearr_102586 = state_102582;
(statearr_102586[(7)] = inst_102565__$1);

return statearr_102586;
})();
if(cljs.core.truth_(inst_102566)){
var statearr_102587_102627 = state_102582__$1;
(statearr_102587_102627[(1)] = (5));

} else {
var statearr_102588_102628 = state_102582__$1;
(statearr_102588_102628[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102583 === (6))){
var inst_102565 = (state_102582[(7)]);
var inst_102569 = fluree.db.dbproto._resolve(inst_102565);
var state_102582__$1 = state_102582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102582__$1,(9),inst_102569);
} else {
if((state_val_102583 === (3))){
var inst_102561 = (state_102582[(2)]);
var state_102582__$1 = state_102582;
var statearr_102589_102629 = state_102582__$1;
(statearr_102589_102629[(2)] = inst_102561);


cljs.core.async.impl.ioc_helpers.process_exception(state_102582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102583 === (2))){
var inst_102580 = (state_102582[(2)]);
var state_102582__$1 = state_102582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102582__$1,inst_102580);
} else {
if((state_val_102583 === (9))){
var inst_102571 = (state_102582[(2)]);
var inst_102572 = fluree.db.util.async.throw_err(inst_102571);
var inst_102573 = fluree.db.dbproto._lookup_leaf_after(inst_102572,flake);
var state_102582__$1 = state_102582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102582__$1,(8),inst_102573);
} else {
if((state_val_102583 === (5))){
var inst_102565 = (state_102582[(7)]);
var state_102582__$1 = state_102582;
var statearr_102590_102630 = state_102582__$1;
(statearr_102590_102630[(2)] = inst_102565);

(statearr_102590_102630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102583 === (8))){
var inst_102575 = (state_102582[(2)]);
var inst_102576 = fluree.db.util.async.throw_err(inst_102575);
var state_102582__$1 = state_102582;
var statearr_102591_102631 = state_102582__$1;
(statearr_102591_102631[(2)] = inst_102576);

(statearr_102591_102631[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__99037__auto__ = null;
var fluree$db$index$state_machine__99037__auto____0 = (function (){
var statearr_102592 = [null,null,null,null,null,null,null,null];
(statearr_102592[(0)] = fluree$db$index$state_machine__99037__auto__);

(statearr_102592[(1)] = (1));

return statearr_102592;
});
var fluree$db$index$state_machine__99037__auto____1 = (function (state_102582){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102582);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102593){if((e102593 instanceof Object)){
var ex__99040__auto__ = e102593;
var statearr_102594_102632 = state_102582;
(statearr_102594_102632[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102582);

return cljs.core.cst$kw$recur;
} else {
throw e102593;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102633 = state_102582;
state_102582 = G__102633;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$index$state_machine__99037__auto__ = function(state_102582){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99037__auto____1.call(this,state_102582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99037__auto____0;
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99037__auto____1;
return fluree$db$index$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_102595 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102595[(6)] = c__99059__auto__);

return statearr_102595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__102596 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__102596(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this102511,other102512){
var self__ = this;
var this102511__$1 = this;
return (((!((other102512 == null)))) && ((this102511__$1.constructor === other102512.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.block,other102512.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.t,other102512.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.rhs,other102512.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.children,other102512.children)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.config,other102512.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.leftmost_QMARK_,other102512.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102511__$1.__extmap,other102512.__extmap)));
});

fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__102509){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__102597 = cljs.core.keyword_identical_QMARK_;
var expr__102598 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__102600 = cljs.core.cst$kw$block;
var G__102601 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102600,G__102601) : pred__102597.call(null,G__102600,G__102601));
})())){
return (new fluree.db.index.IndexNode(G__102509,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102602 = cljs.core.cst$kw$t;
var G__102603 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102602,G__102603) : pred__102597.call(null,G__102602,G__102603));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__102509,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102604 = cljs.core.cst$kw$rhs;
var G__102605 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102604,G__102605) : pred__102597.call(null,G__102604,G__102605));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__102509,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102606 = cljs.core.cst$kw$children;
var G__102607 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102606,G__102607) : pred__102597.call(null,G__102606,G__102607));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__102509,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102608 = cljs.core.cst$kw$config;
var G__102609 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102608,G__102609) : pred__102597.call(null,G__102608,G__102609));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__102509,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102610 = cljs.core.cst$kw$leftmost_QMARK_;
var G__102611 = expr__102598;
return (pred__102597.cljs$core$IFn$_invoke$arity$2 ? pred__102597.cljs$core$IFn$_invoke$arity$2(G__102610,G__102611) : pred__102597.call(null,G__102610,G__102611));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__102509,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__102509),null));
}
}
}
}
}
}
});

fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
});

fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__102509){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__102509,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
});

fluree.db.index.IndexNode.cljs$lang$type = true;

fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
});

fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/IndexNode");
});

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__102513){
var extmap__4424__auto__ = (function (){var G__102612 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__102513,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__102513)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__102612);
} else {
return G__102612;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__102513),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__102513),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__102513),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__102513),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__102513),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__102513),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k102635,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__102639 = k102635;
var G__102639__$1 = (((G__102639 instanceof cljs.core.Keyword))?G__102639.fqn:null);
switch (G__102639__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k102635,else__4388__auto__);

}
});

fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__102640){
var vec__102641 = p__102640;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102641,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__102641,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
});

fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__102634){
var self__ = this;
var G__102634__$1 = this;
return (new cljs.core.RecordIter((0),G__102634__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,this$__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,this$__$1){
return (function (state_102645){
var state_val_102646 = (state_102645[(1)]);
if((state_val_102646 === (1))){
var state_102645__$1 = state_102645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102645__$1,this$__$1);
} else {
return null;
}
});})(c__99059__auto__,this$__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__99037__auto__ = null;
var fluree$db$index$state_machine__99037__auto____0 = (function (){
var statearr_102647 = [null,null,null,null,null,null,null];
(statearr_102647[(0)] = fluree$db$index$state_machine__99037__auto__);

(statearr_102647[(1)] = (1));

return statearr_102647;
});
var fluree$db$index$state_machine__99037__auto____1 = (function (state_102645){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102645);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102648){if((e102648 instanceof Object)){
var ex__99040__auto__ = e102648;
var statearr_102649_102678 = state_102645;
(statearr_102649_102678[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102645);

return cljs.core.cst$kw$recur;
} else {
throw e102648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102679 = state_102645;
state_102645 = G__102679;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$index$state_machine__99037__auto__ = function(state_102645){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99037__auto____1.call(this,state_102645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99037__auto____0;
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99037__auto____1;
return fluree$db$index$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,this$__$1))
})();
var state__99061__auto__ = (function (){var statearr_102650 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102650[(6)] = c__99059__auto__);

return statearr_102650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,this$__$1))
);

return c__99059__auto__;
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,root__$1){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,root__$1){
return (function (state_102656){
var state_val_102657 = (state_102656[(1)]);
if((state_val_102657 === (1))){
var inst_102651 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_102652 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_102653 = cljs.core.PersistentHashMap.fromArrays(inst_102651,inst_102652);
var inst_102654 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_102653);
var state_102656__$1 = state_102656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102656__$1,inst_102654);
} else {
return null;
}
});})(c__99059__auto__,root__$1))
;
return ((function (switch__99036__auto__,c__99059__auto__,root__$1){
return (function() {
var fluree$db$index$state_machine__99037__auto__ = null;
var fluree$db$index$state_machine__99037__auto____0 = (function (){
var statearr_102658 = [null,null,null,null,null,null,null];
(statearr_102658[(0)] = fluree$db$index$state_machine__99037__auto__);

(statearr_102658[(1)] = (1));

return statearr_102658;
});
var fluree$db$index$state_machine__99037__auto____1 = (function (state_102656){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102656);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102659){if((e102659 instanceof Object)){
var ex__99040__auto__ = e102659;
var statearr_102660_102680 = state_102656;
(statearr_102660_102680[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102656);

return cljs.core.cst$kw$recur;
} else {
throw e102659;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102681 = state_102656;
state_102656 = G__102681;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$index$state_machine__99037__auto__ = function(state_102656){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99037__auto____1.call(this,state_102656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99037__auto____0;
fluree$db$index$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99037__auto____1;
return fluree$db$index$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,root__$1))
})();
var state__99061__auto__ = (function (){var statearr_102661 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102661[(6)] = c__99059__auto__);

return statearr_102661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,root__$1))
);

return c__99059__auto__;
});

fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__102662 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__102662(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this102636,other102637){
var self__ = this;
var this102636__$1 = this;
return (((!((other102637 == null)))) && ((this102636__$1.constructor === other102637.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.block,other102637.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.t,other102637.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.flakes,other102637.flakes)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.rhs,other102637.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.config,other102637.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this102636__$1.__extmap,other102637.__extmap)));
});

fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__102634){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__102663 = cljs.core.keyword_identical_QMARK_;
var expr__102664 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__102666 = cljs.core.cst$kw$block;
var G__102667 = expr__102664;
return (pred__102663.cljs$core$IFn$_invoke$arity$2 ? pred__102663.cljs$core$IFn$_invoke$arity$2(G__102666,G__102667) : pred__102663.call(null,G__102666,G__102667));
})())){
return (new fluree.db.index.DataNode(G__102634,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102668 = cljs.core.cst$kw$t;
var G__102669 = expr__102664;
return (pred__102663.cljs$core$IFn$_invoke$arity$2 ? pred__102663.cljs$core$IFn$_invoke$arity$2(G__102668,G__102669) : pred__102663.call(null,G__102668,G__102669));
})())){
return (new fluree.db.index.DataNode(self__.block,G__102634,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102670 = cljs.core.cst$kw$flakes;
var G__102671 = expr__102664;
return (pred__102663.cljs$core$IFn$_invoke$arity$2 ? pred__102663.cljs$core$IFn$_invoke$arity$2(G__102670,G__102671) : pred__102663.call(null,G__102670,G__102671));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__102634,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102672 = cljs.core.cst$kw$rhs;
var G__102673 = expr__102664;
return (pred__102663.cljs$core$IFn$_invoke$arity$2 ? pred__102663.cljs$core$IFn$_invoke$arity$2(G__102672,G__102673) : pred__102663.call(null,G__102672,G__102673));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__102634,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__102674 = cljs.core.cst$kw$config;
var G__102675 = expr__102664;
return (pred__102663.cljs$core$IFn$_invoke$arity$2 ? pred__102663.cljs$core$IFn$_invoke$arity$2(G__102674,G__102675) : pred__102663.call(null,G__102674,G__102675));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__102634,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__102634),null));
}
}
}
}
}
});

fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
});

fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__102634){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__102634,self__.__extmap,self__.__hash));
});

fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
});

fluree.db.index.DataNode.cljs$lang$type = true;

fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
});

fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/DataNode");
});

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__102638){
var extmap__4424__auto__ = (function (){var G__102676 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__102638,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__102638)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__102676);
} else {
return G__102676;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__102638),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__102638),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__102638),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__102638),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__102638),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});

//# sourceMappingURL=index.js.map?rel=1593118616588
