// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__100608 = s;
var map__100608__$1 = (((((!((map__100608 == null))))?(((((map__100608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100608.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100608):map__100608);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100608__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100608__$1,cljs.core.cst$kw$info);
var d = (0);
var G__100611 = info;
var map__100612 = G__100611;
var map__100612__$1 = (((((!((map__100612 == null))))?(((((map__100612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100612):map__100612);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100612__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__100611__$1 = G__100611;
while(true){
var d__$2 = d__$1;
var map__100616 = G__100611__$1;
var map__100616__$1 = (((((!((map__100616 == null))))?(((((map__100616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100616.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100616):map__100616);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100616__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__100618 = (d__$2 + (1));
var G__100619 = shadow__$1;
d__$1 = G__100618;
G__100611__$1 = G__100619;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__100620){
var map__100621 = p__100620;
var map__100621__$1 = (((((!((map__100621 == null))))?(((((map__100621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100621):map__100621);
var name_var = map__100621__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100621__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100621__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__100623 = info;
var map__100623__$1 = (((((!((map__100623 == null))))?(((((map__100623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100623):map__100623);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100623__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100623__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__100625 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__100625) : cljs.compiler.munge.call(null,G__100625));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__100627 = arguments.length;
switch (G__100627) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__100628 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",(17),(1),(11478),(11478),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__100628.cljs$core$IFn$_invoke$arity$1 ? fexpr__100628.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__100628.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__100630 = cp;
switch (G__100630) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__100632_100636 = cljs.core.seq(s);
var chunk__100633_100637 = null;
var count__100634_100638 = (0);
var i__100635_100639 = (0);
while(true){
if((i__100635_100639 < count__100634_100638)){
var c_100640 = chunk__100633_100637.cljs$core$IIndexed$_nth$arity$2(null,i__100635_100639);
sb.append(cljs.compiler.escape_char(c_100640));


var G__100641 = seq__100632_100636;
var G__100642 = chunk__100633_100637;
var G__100643 = count__100634_100638;
var G__100644 = (i__100635_100639 + (1));
seq__100632_100636 = G__100641;
chunk__100633_100637 = G__100642;
count__100634_100638 = G__100643;
i__100635_100639 = G__100644;
continue;
} else {
var temp__5735__auto___100645 = cljs.core.seq(seq__100632_100636);
if(temp__5735__auto___100645){
var seq__100632_100646__$1 = temp__5735__auto___100645;
if(cljs.core.chunked_seq_QMARK_(seq__100632_100646__$1)){
var c__4550__auto___100647 = cljs.core.chunk_first(seq__100632_100646__$1);
var G__100648 = cljs.core.chunk_rest(seq__100632_100646__$1);
var G__100649 = c__4550__auto___100647;
var G__100650 = cljs.core.count(c__4550__auto___100647);
var G__100651 = (0);
seq__100632_100636 = G__100648;
chunk__100633_100637 = G__100649;
count__100634_100638 = G__100650;
i__100635_100639 = G__100651;
continue;
} else {
var c_100652 = cljs.core.first(seq__100632_100646__$1);
sb.append(cljs.compiler.escape_char(c_100652));


var G__100653 = cljs.core.next(seq__100632_100646__$1);
var G__100654 = null;
var G__100655 = (0);
var G__100656 = (0);
seq__100632_100636 = G__100653;
chunk__100633_100637 = G__100654;
count__100634_100638 = G__100655;
i__100635_100639 = G__100656;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__100657 = cljs.core.get_global_hierarchy;
return (fexpr__100657.cljs$core$IFn$_invoke$arity$0 ? fexpr__100657.cljs$core$IFn$_invoke$arity$0() : fexpr__100657.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__100658_100665 = ast;
var map__100658_100666__$1 = (((((!((map__100658_100665 == null))))?(((((map__100658_100665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100658_100665.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100658_100665):map__100658_100665);
var env_100667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100658_100666__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_100667))){
var map__100660_100668 = env_100667;
var map__100660_100669__$1 = (((((!((map__100660_100668 == null))))?(((((map__100660_100668.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100660_100668.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100660_100668):map__100660_100668);
var line_100670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100660_100669__$1,cljs.core.cst$kw$line);
var column_100671 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100660_100669__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,((function (map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667){
return (function (m){
var minfo = (function (){var G__100662 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__100664 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__100663 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__100663.cljs$core$IFn$_invoke$arity$1 ? fexpr__100663.cljs$core$IFn$_invoke$arity$1(G__100664) : fexpr__100663.call(null,G__100664));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__100662,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__100662;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_100670 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (minfo,map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667){
return (function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_100671)?(column_100671 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (minfo,map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667){
return (function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
});})(minfo,map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667))
,cljs.core.sorted_map()));
});})(map__100660_100668,map__100660_100669__$1,line_100670,column_100671,map__100658_100665,map__100658_100666__$1,env_100667))
);
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__100680 = arguments.length;
switch (G__100680) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___100687 = arguments.length;
var i__4731__auto___100688 = (0);
while(true){
if((i__4731__auto___100688 < len__4730__auto___100687)){
args_arr__4751__auto__.push((arguments[i__4731__auto___100688]));

var G__100689 = (i__4731__auto___100688 + (1));
i__4731__auto___100688 = G__100689;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_100690 = (function (){var G__100681 = a;
if((!(typeof a === 'string'))){
return G__100681.toString();
} else {
return G__100681;
}
})();
var temp__5739__auto___100691 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___100691 == null)){
} else {
var sm_data_100692 = temp__5739__auto___100691;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_100692,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,((function (sm_data_100692,temp__5739__auto___100691,s_100690){
return (function (p1__100672_SHARP_){
return (p1__100672_SHARP_ + s_100690.length);
});})(sm_data_100692,temp__5739__auto___100691,s_100690))
);
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_100690], 0));

}
}
}
}

return null;
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__100682 = cljs.core.seq(xs);
var chunk__100683 = null;
var count__100684 = (0);
var i__100685 = (0);
while(true){
if((i__100685 < count__100684)){
var x = chunk__100683.cljs$core$IIndexed$_nth$arity$2(null,i__100685);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__100693 = seq__100682;
var G__100694 = chunk__100683;
var G__100695 = count__100684;
var G__100696 = (i__100685 + (1));
seq__100682 = G__100693;
chunk__100683 = G__100694;
count__100684 = G__100695;
i__100685 = G__100696;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__100682);
if(temp__5735__auto__){
var seq__100682__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__100682__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__100682__$1);
var G__100697 = cljs.core.chunk_rest(seq__100682__$1);
var G__100698 = c__4550__auto__;
var G__100699 = cljs.core.count(c__4550__auto__);
var G__100700 = (0);
seq__100682 = G__100697;
chunk__100683 = G__100698;
count__100684 = G__100699;
i__100685 = G__100700;
continue;
} else {
var x = cljs.core.first(seq__100682__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__100701 = cljs.core.next(seq__100682__$1);
var G__100702 = null;
var G__100703 = (0);
var G__100704 = (0);
seq__100682 = G__100701;
chunk__100683 = G__100702;
count__100684 = G__100703;
i__100685 = G__100704;
continue;
}
} else {
return null;
}
}
break;
}
});

/** @this {Function} */
cljs.compiler.emits.cljs$lang$applyTo = (function (seq100674){
var G__100675 = cljs.core.first(seq100674);
var seq100674__$1 = cljs.core.next(seq100674);
var G__100676 = cljs.core.first(seq100674__$1);
var seq100674__$2 = cljs.core.next(seq100674__$1);
var G__100677 = cljs.core.first(seq100674__$2);
var seq100674__$3 = cljs.core.next(seq100674__$2);
var G__100678 = cljs.core.first(seq100674__$3);
var seq100674__$4 = cljs.core.next(seq100674__$3);
var G__100679 = cljs.core.first(seq100674__$4);
var seq100674__$5 = cljs.core.next(seq100674__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__100675,G__100676,G__100677,G__100678,G__100679,seq100674__$5);
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (5);

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__100705){
var map__100706 = p__100705;
var map__100706__$1 = (((((!((map__100706 == null))))?(((((map__100706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100706.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100706):map__100706);
var m = map__100706__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100706__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__100715 = arguments.length;
switch (G__100715) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___100721 = arguments.length;
var i__4731__auto___100722 = (0);
while(true){
if((i__4731__auto___100722 < len__4730__auto___100721)){
args_arr__4751__auto__.push((arguments[i__4731__auto___100722]));

var G__100723 = (i__4731__auto___100722 + (1));
i__4731__auto___100722 = G__100723;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4752__auto__);

}
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__100716_100724 = cljs.core.seq(xs);
var chunk__100717_100725 = null;
var count__100718_100726 = (0);
var i__100719_100727 = (0);
while(true){
if((i__100719_100727 < count__100718_100726)){
var x_100728 = chunk__100717_100725.cljs$core$IIndexed$_nth$arity$2(null,i__100719_100727);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_100728);


var G__100729 = seq__100716_100724;
var G__100730 = chunk__100717_100725;
var G__100731 = count__100718_100726;
var G__100732 = (i__100719_100727 + (1));
seq__100716_100724 = G__100729;
chunk__100717_100725 = G__100730;
count__100718_100726 = G__100731;
i__100719_100727 = G__100732;
continue;
} else {
var temp__5735__auto___100733 = cljs.core.seq(seq__100716_100724);
if(temp__5735__auto___100733){
var seq__100716_100734__$1 = temp__5735__auto___100733;
if(cljs.core.chunked_seq_QMARK_(seq__100716_100734__$1)){
var c__4550__auto___100735 = cljs.core.chunk_first(seq__100716_100734__$1);
var G__100736 = cljs.core.chunk_rest(seq__100716_100734__$1);
var G__100737 = c__4550__auto___100735;
var G__100738 = cljs.core.count(c__4550__auto___100735);
var G__100739 = (0);
seq__100716_100724 = G__100736;
chunk__100717_100725 = G__100737;
count__100718_100726 = G__100738;
i__100719_100727 = G__100739;
continue;
} else {
var x_100740 = cljs.core.first(seq__100716_100734__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_100740);


var G__100741 = cljs.core.next(seq__100716_100734__$1);
var G__100742 = null;
var G__100743 = (0);
var G__100744 = (0);
seq__100716_100724 = G__100741;
chunk__100717_100725 = G__100742;
count__100718_100726 = G__100743;
i__100719_100727 = G__100744;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
});

/** @this {Function} */
cljs.compiler.emitln.cljs$lang$applyTo = (function (seq100709){
var G__100710 = cljs.core.first(seq100709);
var seq100709__$1 = cljs.core.next(seq100709);
var G__100711 = cljs.core.first(seq100709__$1);
var seq100709__$2 = cljs.core.next(seq100709__$1);
var G__100712 = cljs.core.first(seq100709__$2);
var seq100709__$3 = cljs.core.next(seq100709__$2);
var G__100713 = cljs.core.first(seq100709__$3);
var seq100709__$4 = cljs.core.next(seq100709__$3);
var G__100714 = cljs.core.first(seq100709__$4);
var seq100709__$5 = cljs.core.next(seq100709__$4);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__100710,G__100711,G__100712,G__100713,G__100714,seq100709__$5);
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (5);

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__100745_100749 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__100746_100750 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__100747_100751 = true;
var _STAR_print_fn_STAR__temp_val__100748_100752 = ((function (_STAR_print_newline_STAR__orig_val__100745_100749,_STAR_print_fn_STAR__orig_val__100746_100750,_STAR_print_newline_STAR__temp_val__100747_100751,sb__4661__auto__){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__100745_100749,_STAR_print_fn_STAR__orig_val__100746_100750,_STAR_print_newline_STAR__temp_val__100747_100751,sb__4661__auto__))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__100747_100751;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__100748_100752;

try{cljs.compiler.emit(expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__100746_100750;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__100745_100749;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__100753 = cljs.core.get_global_hierarchy;
return (fexpr__100753.cljs$core$IFn$_invoke$arity$0 ? fexpr__100753.cljs$core$IFn$_invoke$arity$0() : fexpr__100753.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__100754 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100754,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100754,(1),null);
var G__100757 = ns;
var G__100758 = name;
var G__100759 = ((function (G__100757,G__100758,vec__100754,ns,name){
return (function (){
var G__100760 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__100760) : cljs.compiler.emit_constant.call(null,G__100760));
});})(G__100757,G__100758,vec__100754,ns,name))
;
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__100757,G__100758,G__100759) : cljs.compiler.emit_record_value.call(null,G__100757,G__100758,G__100759));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__100761 = cljs.core.keys(x);
var G__100762 = cljs.core.vals(x);
var G__100763 = cljs.compiler.emit_constants_comma_sep;
var G__100764 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__100761,G__100762,G__100763,G__100764) : cljs.compiler.emit_map.call(null,G__100761,G__100762,G__100763,G__100764));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__100765 = ((function (m){
return (function (){
return cljs.compiler.emit_constant_no_meta(v);
});})(m))
;
var G__100766 = ((function (G__100765,m){
return (function (){
return cljs.compiler.emit_constant_no_meta(m);
});})(G__100765,m))
;
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__100765,G__100766) : cljs.compiler.emit_with_meta.call(null,G__100765,G__100766));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__100767 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100767,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100767,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100767,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4120__auto__)){
var G__100770 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__100770) : x.call(null,G__100770));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4120__auto__)){
var G__100771 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__100771) : x.call(null,G__100771));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__100773 = items;
var G__100774 = ((function (G__100773,items){
return (function (p1__100772_SHARP_){
return ((function (G__100773,items){
return (function (){
return cljs.compiler.emit_constant(p1__100772_SHARP_);
});
;})(G__100773,items))
});})(G__100773,items))
;
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__100773,G__100774) : cljs.compiler.emit_js_object.call(null,G__100773,G__100774));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__100776){
var map__100777 = p__100776;
var map__100777__$1 = (((((!((map__100777 == null))))?(((((map__100777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100777.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100777):map__100777);
var ast = map__100777__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100777__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100777__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100777__$1,cljs.core.cst$kw$form);
var temp__5733__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__100779 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__100779__$1 = (((((!((map__100779 == null))))?(((((map__100779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100779):map__100779);
var cenv = map__100779__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100779__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4131__auto__ = js_module_name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__100781 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4120__auto__ = (function (){var G__100783 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__100783) : cljs.compiler.es5_GT__EQ_.call(null,G__100783));
})();
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4120__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__100781,cljs.analyzer.es5_allowed);
} else {
return G__100781;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4131__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__100784 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__100784,reserved);
} else {
return G__100784;
}
})();
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__100785_100786 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__100785_100787__$1 = (((G__100785_100786 instanceof cljs.core.Keyword))?G__100785_100786.fqn:null);
switch (G__100785_100787__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4120__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__100789){
var map__100790 = p__100789;
var map__100790__$1 = (((((!((map__100790 == null))))?(((((map__100790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100790):map__100790);
var arg = map__100790__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100790__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100790__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100790__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100790__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__100792 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__100792__$1 = (((((!((map__100792 == null))))?(((((map__100792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100792):map__100792);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100792__$1,cljs.core.cst$kw$name);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__100794){
var map__100795 = p__100794;
var map__100795__$1 = (((((!((map__100795 == null))))?(((((map__100795.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100795.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100795):map__100795);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100795__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100795__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100795__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_(((function (keys__$1){
return (function (p1__100797_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__100797_SHARP_),cljs.core.cst$kw$const);
});})(keys__$1))
,keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__100798 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__100798) : comma_sep.call(null,G__100798));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__100799 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__100799) : comma_sep.call(null,G__100799));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__100800){
var map__100801 = p__100800;
var map__100801__$1 = (((((!((map__100801 == null))))?(((((map__100801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100801):map__100801);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100801__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100801__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100801__$1,cljs.core.cst$kw$vals);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__100803){
var map__100804 = p__100803;
var map__100804__$1 = (((((!((map__100804 == null))))?(((((map__100804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100804):map__100804);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100804__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100804__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_(((function (items__$1){
return (function (p1__100806_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__100806_SHARP_),cljs.core.cst$kw$const);
});})(items__$1))
,items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__100807 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__100807) : comma_sep.call(null,G__100807));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__100808){
var map__100809 = p__100808;
var map__100809__$1 = (((((!((map__100809 == null))))?(((((map__100809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100809):map__100809);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100809__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100809__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___100833 = cljs.core.seq(items);
if(temp__5735__auto___100833){
var items_100834__$1 = temp__5735__auto___100833;
var vec__100811_100835 = items_100834__$1;
var seq__100812_100836 = cljs.core.seq(vec__100811_100835);
var first__100813_100837 = cljs.core.first(seq__100812_100836);
var seq__100812_100838__$1 = cljs.core.next(seq__100812_100836);
var vec__100814_100839 = first__100813_100837;
var k_100840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100814_100839,(0),null);
var v_100841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100814_100839,(1),null);
var r_100842 = seq__100812_100838__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_100840),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_100841) : emit_js_object_val.call(null,v_100841)));

var seq__100817_100843 = cljs.core.seq(r_100842);
var chunk__100818_100844 = null;
var count__100819_100845 = (0);
var i__100820_100846 = (0);
while(true){
if((i__100820_100846 < count__100819_100845)){
var vec__100827_100847 = chunk__100818_100844.cljs$core$IIndexed$_nth$arity$2(null,i__100820_100846);
var k_100848__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100827_100847,(0),null);
var v_100849__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100827_100847,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_100848__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_100849__$1) : emit_js_object_val.call(null,v_100849__$1)));


var G__100850 = seq__100817_100843;
var G__100851 = chunk__100818_100844;
var G__100852 = count__100819_100845;
var G__100853 = (i__100820_100846 + (1));
seq__100817_100843 = G__100850;
chunk__100818_100844 = G__100851;
count__100819_100845 = G__100852;
i__100820_100846 = G__100853;
continue;
} else {
var temp__5735__auto___100854__$1 = cljs.core.seq(seq__100817_100843);
if(temp__5735__auto___100854__$1){
var seq__100817_100855__$1 = temp__5735__auto___100854__$1;
if(cljs.core.chunked_seq_QMARK_(seq__100817_100855__$1)){
var c__4550__auto___100856 = cljs.core.chunk_first(seq__100817_100855__$1);
var G__100857 = cljs.core.chunk_rest(seq__100817_100855__$1);
var G__100858 = c__4550__auto___100856;
var G__100859 = cljs.core.count(c__4550__auto___100856);
var G__100860 = (0);
seq__100817_100843 = G__100857;
chunk__100818_100844 = G__100858;
count__100819_100845 = G__100859;
i__100820_100846 = G__100860;
continue;
} else {
var vec__100830_100861 = cljs.core.first(seq__100817_100855__$1);
var k_100862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100830_100861,(0),null);
var v_100863__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100830_100861,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_100862__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_100863__$1) : emit_js_object_val.call(null,v_100863__$1)));


var G__100864 = cljs.core.next(seq__100817_100855__$1);
var G__100865 = null;
var G__100866 = (0);
var G__100867 = (0);
seq__100817_100843 = G__100864;
chunk__100818_100844 = G__100865;
count__100819_100845 = G__100866;
i__100820_100846 = G__100867;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__100868){
var map__100869 = p__100868;
var map__100869__$1 = (((((!((map__100869 == null))))?(((((map__100869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100869.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100869):map__100869);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100869__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100869__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100869__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__100871){
var map__100872 = p__100871;
var map__100872__$1 = (((((!((map__100872 == null))))?(((((map__100872.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100872.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100872):map__100872);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100872__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100872__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__100874){
var map__100875 = p__100874;
var map__100875__$1 = (((((!((map__100875 == null))))?(((((map__100875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100875.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100875):map__100875);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100875__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__100877){
var map__100878 = p__100877;
var map__100878__$1 = (((((!((map__100878 == null))))?(((((map__100878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100878):map__100878);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100878__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100878__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__100880 = cljs.analyzer.unwrap_quote(expr);
var map__100880__$1 = (((((!((map__100880 == null))))?(((((map__100880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100880):map__100880);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100880__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100880__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100880__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4131__auto__ = (function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4120__auto__){
var and__4120__auto____$1 = form;
if(cljs.core.truth_(and__4120__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = (!((const_expr == null)));
if(and__4120__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4120__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__100882 = cljs.analyzer.unwrap_quote(expr);
var map__100882__$1 = (((((!((map__100882 == null))))?(((((map__100882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100882):map__100882);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100882__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100882__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100882__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4131__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = (!((const_expr == null)));
if(and__4120__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4120__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4131__auto__ = (function (){var fexpr__100885 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__100885.cljs$core$IFn$_invoke$arity$1 ? fexpr__100885.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__100885.call(null,tag));
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__100886){
var map__100887 = p__100886;
var map__100887__$1 = (((((!((map__100887 == null))))?(((((map__100887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100887):map__100887);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100887__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100887__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100887__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100887__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100887__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4131__auto__ = unchecked;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__100889){
var map__100890 = p__100889;
var map__100890__$1 = (((((!((map__100890 == null))))?(((((map__100890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100890):map__100890);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100890__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100890__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100890__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100890__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__100892_100928 = cljs.core.seq(nodes);
var chunk__100893_100929 = null;
var count__100894_100930 = (0);
var i__100895_100931 = (0);
while(true){
if((i__100895_100931 < count__100894_100930)){
var map__100912_100932 = chunk__100893_100929.cljs$core$IIndexed$_nth$arity$2(null,i__100895_100931);
var map__100912_100933__$1 = (((((!((map__100912_100932 == null))))?(((((map__100912_100932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100912_100932.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100912_100932):map__100912_100932);
var ts_100934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100912_100933__$1,cljs.core.cst$kw$tests);
var map__100913_100935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100912_100933__$1,cljs.core.cst$kw$then);
var map__100913_100936__$1 = (((((!((map__100913_100935 == null))))?(((((map__100913_100935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100913_100935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100913_100935):map__100913_100935);
var then_100937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100913_100936__$1,cljs.core.cst$kw$then);
var seq__100916_100938 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_100934));
var chunk__100917_100939 = null;
var count__100918_100940 = (0);
var i__100919_100941 = (0);
while(true){
if((i__100919_100941 < count__100918_100940)){
var test_100942 = chunk__100917_100939.cljs$core$IIndexed$_nth$arity$2(null,i__100919_100941);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_100942,":");


var G__100943 = seq__100916_100938;
var G__100944 = chunk__100917_100939;
var G__100945 = count__100918_100940;
var G__100946 = (i__100919_100941 + (1));
seq__100916_100938 = G__100943;
chunk__100917_100939 = G__100944;
count__100918_100940 = G__100945;
i__100919_100941 = G__100946;
continue;
} else {
var temp__5735__auto___100947 = cljs.core.seq(seq__100916_100938);
if(temp__5735__auto___100947){
var seq__100916_100948__$1 = temp__5735__auto___100947;
if(cljs.core.chunked_seq_QMARK_(seq__100916_100948__$1)){
var c__4550__auto___100949 = cljs.core.chunk_first(seq__100916_100948__$1);
var G__100950 = cljs.core.chunk_rest(seq__100916_100948__$1);
var G__100951 = c__4550__auto___100949;
var G__100952 = cljs.core.count(c__4550__auto___100949);
var G__100953 = (0);
seq__100916_100938 = G__100950;
chunk__100917_100939 = G__100951;
count__100918_100940 = G__100952;
i__100919_100941 = G__100953;
continue;
} else {
var test_100954 = cljs.core.first(seq__100916_100948__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_100954,":");


var G__100955 = cljs.core.next(seq__100916_100948__$1);
var G__100956 = null;
var G__100957 = (0);
var G__100958 = (0);
seq__100916_100938 = G__100955;
chunk__100917_100939 = G__100956;
count__100918_100940 = G__100957;
i__100919_100941 = G__100958;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_100937);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_100937);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__100959 = seq__100892_100928;
var G__100960 = chunk__100893_100929;
var G__100961 = count__100894_100930;
var G__100962 = (i__100895_100931 + (1));
seq__100892_100928 = G__100959;
chunk__100893_100929 = G__100960;
count__100894_100930 = G__100961;
i__100895_100931 = G__100962;
continue;
} else {
var temp__5735__auto___100963 = cljs.core.seq(seq__100892_100928);
if(temp__5735__auto___100963){
var seq__100892_100964__$1 = temp__5735__auto___100963;
if(cljs.core.chunked_seq_QMARK_(seq__100892_100964__$1)){
var c__4550__auto___100965 = cljs.core.chunk_first(seq__100892_100964__$1);
var G__100966 = cljs.core.chunk_rest(seq__100892_100964__$1);
var G__100967 = c__4550__auto___100965;
var G__100968 = cljs.core.count(c__4550__auto___100965);
var G__100969 = (0);
seq__100892_100928 = G__100966;
chunk__100893_100929 = G__100967;
count__100894_100930 = G__100968;
i__100895_100931 = G__100969;
continue;
} else {
var map__100920_100970 = cljs.core.first(seq__100892_100964__$1);
var map__100920_100971__$1 = (((((!((map__100920_100970 == null))))?(((((map__100920_100970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100920_100970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100920_100970):map__100920_100970);
var ts_100972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100920_100971__$1,cljs.core.cst$kw$tests);
var map__100921_100973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100920_100971__$1,cljs.core.cst$kw$then);
var map__100921_100974__$1 = (((((!((map__100921_100973 == null))))?(((((map__100921_100973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100921_100973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__100921_100973):map__100921_100973);
var then_100975 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__100921_100974__$1,cljs.core.cst$kw$then);
var seq__100924_100976 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_100972));
var chunk__100925_100977 = null;
var count__100926_100978 = (0);
var i__100927_100979 = (0);
while(true){
if((i__100927_100979 < count__100926_100978)){
var test_100980 = chunk__100925_100977.cljs$core$IIndexed$_nth$arity$2(null,i__100927_100979);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_100980,":");


var G__100981 = seq__100924_100976;
var G__100982 = chunk__100925_100977;
var G__100983 = count__100926_100978;
var G__100984 = (i__100927_100979 + (1));
seq__100924_100976 = G__100981;
chunk__100925_100977 = G__100982;
count__100926_100978 = G__100983;
i__100927_100979 = G__100984;
continue;
} else {
var temp__5735__auto___100985__$1 = cljs.core.seq(seq__100924_100976);
if(temp__5735__auto___100985__$1){
var seq__100924_100986__$1 = temp__5735__auto___100985__$1;
if(cljs.core.chunked_seq_QMARK_(seq__100924_100986__$1)){
var c__4550__auto___100987 = cljs.core.chunk_first(seq__100924_100986__$1);
var G__100988 = cljs.core.chunk_rest(seq__100924_100986__$1);
var G__100989 = c__4550__auto___100987;
var G__100990 = cljs.core.count(c__4550__auto___100987);
var G__100991 = (0);
seq__100924_100976 = G__100988;
chunk__100925_100977 = G__100989;
count__100926_100978 = G__100990;
i__100927_100979 = G__100991;
continue;
} else {
var test_100992 = cljs.core.first(seq__100924_100986__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_100992,":");


var G__100993 = cljs.core.next(seq__100924_100986__$1);
var G__100994 = null;
var G__100995 = (0);
var G__100996 = (0);
seq__100924_100976 = G__100993;
chunk__100925_100977 = G__100994;
count__100926_100978 = G__100995;
i__100927_100979 = G__100996;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_100975);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_100975);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__100997 = cljs.core.next(seq__100892_100964__$1);
var G__100998 = null;
var G__100999 = (0);
var G__101000 = (0);
seq__100892_100928 = G__100997;
chunk__100893_100929 = G__100998;
count__100894_100930 = G__100999;
i__100895_100931 = G__101000;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__101001){
var map__101002 = p__101001;
var map__101002__$1 = (((((!((map__101002 == null))))?(((((map__101002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101002.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101002):map__101002);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101002__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101002__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__101007 = env;
var G__101008 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__101007,G__101008) : cljs.compiler.resolve_type.call(null,G__101007,G__101008));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__101009 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101009,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101009,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (idx,vec__101009,fstr,rstr,ret_t,axstr){
return (function (p1__101004_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__101004_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__101004_SHARP_));
});})(idx,vec__101009,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__101012 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__101012,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__101012;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__101015 = env;
var G__101016 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__101015,G__101016) : cljs.compiler.resolve_type.call(null,G__101015,G__101016));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ts__$1,xs){
return (function (p1__101017_SHARP_){
return cljs.compiler.resolve_type(env,p1__101017_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__101018 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__101019 = cljs.core.seq(vec__101018);
var first__101020 = cljs.core.first(seq__101019);
var seq__101019__$1 = cljs.core.next(seq__101019);
var p = first__101020;
var first__101020__$1 = cljs.core.first(seq__101019__$1);
var seq__101019__$2 = cljs.core.next(seq__101019__$1);
var ts = first__101020__$1;
var first__101020__$2 = cljs.core.first(seq__101019__$2);
var seq__101019__$3 = cljs.core.next(seq__101019__$2);
var n = first__101020__$2;
var xs = seq__101019__$3;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4120__auto__){
var and__4120__auto____$1 = ts;
if(cljs.core.truth_(and__4120__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__101021 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__101022 = cljs.core.seq(vec__101021);
var first__101023 = cljs.core.first(seq__101022);
var seq__101022__$1 = cljs.core.next(seq__101022);
var p = first__101023;
var first__101023__$1 = cljs.core.first(seq__101022__$1);
var seq__101022__$2 = cljs.core.next(seq__101022__$1);
var ts = first__101023__$1;
var xs = seq__101022__$2;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4120__auto__){
var and__4120__auto____$1 = ts;
if(cljs.core.truth_(and__4120__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__101025 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__101024 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__101024.cljs$core$IFn$_invoke$arity$1 ? fexpr__101024.cljs$core$IFn$_invoke$arity$1(G__101025) : fexpr__101024.call(null,G__101025));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__101028 = arguments.length;
switch (G__101028) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__101036 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (docs,docs__$1,docs__$2){
return (function (p1__101026_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__101026_SHARP_);
} else {
return p1__101026_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines(e));
var seq__101037 = cljs.core.seq(vec__101036);
var first__101038 = cljs.core.first(seq__101037);
var seq__101037__$1 = cljs.core.next(seq__101037);
var x = first__101038;
var ys = seq__101037__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__101039 = cljs.core.seq(ys);
var chunk__101040 = null;
var count__101041 = (0);
var i__101042 = (0);
while(true){
if((i__101042 < count__101041)){
var next_line = chunk__101040.cljs$core$IIndexed$_nth$arity$2(null,i__101042);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__101048 = seq__101039;
var G__101049 = chunk__101040;
var G__101050 = count__101041;
var G__101051 = (i__101042 + (1));
seq__101039 = G__101048;
chunk__101040 = G__101049;
count__101041 = G__101050;
i__101042 = G__101051;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__101039);
if(temp__5735__auto__){
var seq__101039__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__101039__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__101039__$1);
var G__101052 = cljs.core.chunk_rest(seq__101039__$1);
var G__101053 = c__4550__auto__;
var G__101054 = cljs.core.count(c__4550__auto__);
var G__101055 = (0);
seq__101039 = G__101052;
chunk__101040 = G__101053;
count__101041 = G__101054;
i__101042 = G__101055;
continue;
} else {
var next_line = cljs.core.first(seq__101039__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__101056 = cljs.core.next(seq__101039__$1);
var G__101057 = null;
var G__101058 = (0);
var G__101059 = (0);
seq__101039 = G__101056;
chunk__101040 = G__101057;
count__101041 = G__101058;
i__101042 = G__101059;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__101043_101060 = cljs.core.seq(docs__$2);
var chunk__101044_101061 = null;
var count__101045_101062 = (0);
var i__101046_101063 = (0);
while(true){
if((i__101046_101063 < count__101045_101062)){
var e_101064 = chunk__101044_101061.cljs$core$IIndexed$_nth$arity$2(null,i__101046_101063);
if(cljs.core.truth_(e_101064)){
print_comment_lines(e_101064);
} else {
}


var G__101065 = seq__101043_101060;
var G__101066 = chunk__101044_101061;
var G__101067 = count__101045_101062;
var G__101068 = (i__101046_101063 + (1));
seq__101043_101060 = G__101065;
chunk__101044_101061 = G__101066;
count__101045_101062 = G__101067;
i__101046_101063 = G__101068;
continue;
} else {
var temp__5735__auto___101069 = cljs.core.seq(seq__101043_101060);
if(temp__5735__auto___101069){
var seq__101043_101070__$1 = temp__5735__auto___101069;
if(cljs.core.chunked_seq_QMARK_(seq__101043_101070__$1)){
var c__4550__auto___101071 = cljs.core.chunk_first(seq__101043_101070__$1);
var G__101072 = cljs.core.chunk_rest(seq__101043_101070__$1);
var G__101073 = c__4550__auto___101071;
var G__101074 = cljs.core.count(c__4550__auto___101071);
var G__101075 = (0);
seq__101043_101060 = G__101072;
chunk__101044_101061 = G__101073;
count__101045_101062 = G__101074;
i__101046_101063 = G__101075;
continue;
} else {
var e_101076 = cljs.core.first(seq__101043_101070__$1);
if(cljs.core.truth_(e_101076)){
print_comment_lines(e_101076);
} else {
}


var G__101077 = cljs.core.next(seq__101043_101070__$1);
var G__101078 = null;
var G__101079 = (0);
var G__101080 = (0);
seq__101043_101060 = G__101077;
chunk__101044_101061 = G__101078;
count__101045_101062 = G__101079;
i__101046_101063 = G__101080;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4120__auto__ = cljs.core.some(((function (opts){
return (function (p1__101082_SHARP_){
return goog.string.startsWith(p1__101082_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = opts;
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4120__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__101083){
var map__101084 = p__101083;
var map__101084__$1 = (((((!((map__101084 == null))))?(((((map__101084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101084):map__101084);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$test);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101084__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4131__auto__ = init;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__4120__auto__){
return test;
} else {
return and__4120__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__101086){
var map__101087 = p__101086;
var map__101087__$1 = (((((!((map__101087 == null))))?(((((map__101087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101087.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101087):map__101087);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101087__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101087__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101087__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__101089_101113 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__101090_101114 = null;
var count__101091_101115 = (0);
var i__101092_101116 = (0);
while(true){
if((i__101092_101116 < count__101091_101115)){
var vec__101099_101117 = chunk__101090_101114.cljs$core$IIndexed$_nth$arity$2(null,i__101092_101116);
var i_101118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101099_101117,(0),null);
var param_101119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101099_101117,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_101119);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__101120 = seq__101089_101113;
var G__101121 = chunk__101090_101114;
var G__101122 = count__101091_101115;
var G__101123 = (i__101092_101116 + (1));
seq__101089_101113 = G__101120;
chunk__101090_101114 = G__101121;
count__101091_101115 = G__101122;
i__101092_101116 = G__101123;
continue;
} else {
var temp__5735__auto___101124 = cljs.core.seq(seq__101089_101113);
if(temp__5735__auto___101124){
var seq__101089_101125__$1 = temp__5735__auto___101124;
if(cljs.core.chunked_seq_QMARK_(seq__101089_101125__$1)){
var c__4550__auto___101126 = cljs.core.chunk_first(seq__101089_101125__$1);
var G__101127 = cljs.core.chunk_rest(seq__101089_101125__$1);
var G__101128 = c__4550__auto___101126;
var G__101129 = cljs.core.count(c__4550__auto___101126);
var G__101130 = (0);
seq__101089_101113 = G__101127;
chunk__101090_101114 = G__101128;
count__101091_101115 = G__101129;
i__101092_101116 = G__101130;
continue;
} else {
var vec__101102_101131 = cljs.core.first(seq__101089_101125__$1);
var i_101132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101102_101131,(0),null);
var param_101133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101102_101131,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_101133);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__101134 = cljs.core.next(seq__101089_101125__$1);
var G__101135 = null;
var G__101136 = (0);
var G__101137 = (0);
seq__101089_101113 = G__101134;
chunk__101090_101114 = G__101135;
count__101091_101115 = G__101136;
i__101092_101116 = G__101137;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__101105_101138 = cljs.core.seq(params);
var chunk__101106_101139 = null;
var count__101107_101140 = (0);
var i__101108_101141 = (0);
while(true){
if((i__101108_101141 < count__101107_101140)){
var param_101142 = chunk__101106_101139.cljs$core$IIndexed$_nth$arity$2(null,i__101108_101141);
cljs.compiler.emit(param_101142);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101142,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101143 = seq__101105_101138;
var G__101144 = chunk__101106_101139;
var G__101145 = count__101107_101140;
var G__101146 = (i__101108_101141 + (1));
seq__101105_101138 = G__101143;
chunk__101106_101139 = G__101144;
count__101107_101140 = G__101145;
i__101108_101141 = G__101146;
continue;
} else {
var temp__5735__auto___101147 = cljs.core.seq(seq__101105_101138);
if(temp__5735__auto___101147){
var seq__101105_101148__$1 = temp__5735__auto___101147;
if(cljs.core.chunked_seq_QMARK_(seq__101105_101148__$1)){
var c__4550__auto___101149 = cljs.core.chunk_first(seq__101105_101148__$1);
var G__101150 = cljs.core.chunk_rest(seq__101105_101148__$1);
var G__101151 = c__4550__auto___101149;
var G__101152 = cljs.core.count(c__4550__auto___101149);
var G__101153 = (0);
seq__101105_101138 = G__101150;
chunk__101106_101139 = G__101151;
count__101107_101140 = G__101152;
i__101108_101141 = G__101153;
continue;
} else {
var param_101154 = cljs.core.first(seq__101105_101148__$1);
cljs.compiler.emit(param_101154);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101154,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101155 = cljs.core.next(seq__101105_101148__$1);
var G__101156 = null;
var G__101157 = (0);
var G__101158 = (0);
seq__101105_101138 = G__101155;
chunk__101106_101139 = G__101156;
count__101107_101140 = G__101157;
i__101108_101141 = G__101158;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__101109_101159 = cljs.core.seq(params);
var chunk__101110_101160 = null;
var count__101111_101161 = (0);
var i__101112_101162 = (0);
while(true){
if((i__101112_101162 < count__101111_101161)){
var param_101163 = chunk__101110_101160.cljs$core$IIndexed$_nth$arity$2(null,i__101112_101162);
cljs.compiler.emit(param_101163);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101163,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101164 = seq__101109_101159;
var G__101165 = chunk__101110_101160;
var G__101166 = count__101111_101161;
var G__101167 = (i__101112_101162 + (1));
seq__101109_101159 = G__101164;
chunk__101110_101160 = G__101165;
count__101111_101161 = G__101166;
i__101112_101162 = G__101167;
continue;
} else {
var temp__5735__auto___101168 = cljs.core.seq(seq__101109_101159);
if(temp__5735__auto___101168){
var seq__101109_101169__$1 = temp__5735__auto___101168;
if(cljs.core.chunked_seq_QMARK_(seq__101109_101169__$1)){
var c__4550__auto___101170 = cljs.core.chunk_first(seq__101109_101169__$1);
var G__101171 = cljs.core.chunk_rest(seq__101109_101169__$1);
var G__101172 = c__4550__auto___101170;
var G__101173 = cljs.core.count(c__4550__auto___101170);
var G__101174 = (0);
seq__101109_101159 = G__101171;
chunk__101110_101160 = G__101172;
count__101111_101161 = G__101173;
i__101112_101162 = G__101174;
continue;
} else {
var param_101175 = cljs.core.first(seq__101109_101169__$1);
cljs.compiler.emit(param_101175);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101175,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101176 = cljs.core.next(seq__101109_101169__$1);
var G__101177 = null;
var G__101178 = (0);
var G__101179 = (0);
seq__101109_101159 = G__101176;
chunk__101110_101160 = G__101177;
count__101111_101161 = G__101178;
i__101112_101162 = G__101179;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__101180 = cljs.core.seq(params);
var chunk__101181 = null;
var count__101182 = (0);
var i__101183 = (0);
while(true){
if((i__101183 < count__101182)){
var param = chunk__101181.cljs$core$IIndexed$_nth$arity$2(null,i__101183);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101184 = seq__101180;
var G__101185 = chunk__101181;
var G__101186 = count__101182;
var G__101187 = (i__101183 + (1));
seq__101180 = G__101184;
chunk__101181 = G__101185;
count__101182 = G__101186;
i__101183 = G__101187;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__101180);
if(temp__5735__auto__){
var seq__101180__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__101180__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__101180__$1);
var G__101188 = cljs.core.chunk_rest(seq__101180__$1);
var G__101189 = c__4550__auto__;
var G__101190 = cljs.core.count(c__4550__auto__);
var G__101191 = (0);
seq__101180 = G__101188;
chunk__101181 = G__101189;
count__101182 = G__101190;
i__101183 = G__101191;
continue;
} else {
var param = cljs.core.first(seq__101180__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101192 = cljs.core.next(seq__101180__$1);
var G__101193 = null;
var G__101194 = (0);
var G__101195 = (0);
seq__101180 = G__101192;
chunk__101181 = G__101193;
count__101182 = G__101194;
i__101183 = G__101195;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__101196){
var map__101197 = p__101196;
var map__101197__$1 = (((((!((map__101197 == null))))?(((((map__101197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101197):map__101197);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101197__$1,cljs.core.cst$kw$recurs);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__101199){
var map__101200 = p__101199;
var map__101200__$1 = (((((!((map__101200 == null))))?(((((map__101200.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101200.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101200):map__101200);
var f = map__101200__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101200__$1,cljs.core.cst$kw$recurs);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_101210__$1 = (function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_101211 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_101210__$1);
var delegate_name_101212 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_101211),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_101212," = function (");

var seq__101202_101213 = cljs.core.seq(params);
var chunk__101203_101214 = null;
var count__101204_101215 = (0);
var i__101205_101216 = (0);
while(true){
if((i__101205_101216 < count__101204_101215)){
var param_101217 = chunk__101203_101214.cljs$core$IIndexed$_nth$arity$2(null,i__101205_101216);
cljs.compiler.emit(param_101217);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101217,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101218 = seq__101202_101213;
var G__101219 = chunk__101203_101214;
var G__101220 = count__101204_101215;
var G__101221 = (i__101205_101216 + (1));
seq__101202_101213 = G__101218;
chunk__101203_101214 = G__101219;
count__101204_101215 = G__101220;
i__101205_101216 = G__101221;
continue;
} else {
var temp__5735__auto___101222 = cljs.core.seq(seq__101202_101213);
if(temp__5735__auto___101222){
var seq__101202_101223__$1 = temp__5735__auto___101222;
if(cljs.core.chunked_seq_QMARK_(seq__101202_101223__$1)){
var c__4550__auto___101224 = cljs.core.chunk_first(seq__101202_101223__$1);
var G__101225 = cljs.core.chunk_rest(seq__101202_101223__$1);
var G__101226 = c__4550__auto___101224;
var G__101227 = cljs.core.count(c__4550__auto___101224);
var G__101228 = (0);
seq__101202_101213 = G__101225;
chunk__101203_101214 = G__101226;
count__101204_101215 = G__101227;
i__101205_101216 = G__101228;
continue;
} else {
var param_101229 = cljs.core.first(seq__101202_101223__$1);
cljs.compiler.emit(param_101229);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101229,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101230 = cljs.core.next(seq__101202_101223__$1);
var G__101231 = null;
var G__101232 = (0);
var G__101233 = (0);
seq__101202_101213 = G__101230;
chunk__101203_101214 = G__101231;
count__101204_101215 = G__101232;
i__101205_101216 = G__101233;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_101211," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_101234 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_101234,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_101212,".call(this,");

var seq__101206_101235 = cljs.core.seq(params);
var chunk__101207_101236 = null;
var count__101208_101237 = (0);
var i__101209_101238 = (0);
while(true){
if((i__101209_101238 < count__101208_101237)){
var param_101239 = chunk__101207_101236.cljs$core$IIndexed$_nth$arity$2(null,i__101209_101238);
cljs.compiler.emit(param_101239);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101239,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101240 = seq__101206_101235;
var G__101241 = chunk__101207_101236;
var G__101242 = count__101208_101237;
var G__101243 = (i__101209_101238 + (1));
seq__101206_101235 = G__101240;
chunk__101207_101236 = G__101241;
count__101208_101237 = G__101242;
i__101209_101238 = G__101243;
continue;
} else {
var temp__5735__auto___101244 = cljs.core.seq(seq__101206_101235);
if(temp__5735__auto___101244){
var seq__101206_101245__$1 = temp__5735__auto___101244;
if(cljs.core.chunked_seq_QMARK_(seq__101206_101245__$1)){
var c__4550__auto___101246 = cljs.core.chunk_first(seq__101206_101245__$1);
var G__101247 = cljs.core.chunk_rest(seq__101206_101245__$1);
var G__101248 = c__4550__auto___101246;
var G__101249 = cljs.core.count(c__4550__auto___101246);
var G__101250 = (0);
seq__101206_101235 = G__101247;
chunk__101207_101236 = G__101248;
count__101208_101237 = G__101249;
i__101209_101238 = G__101250;
continue;
} else {
var param_101251 = cljs.core.first(seq__101206_101245__$1);
cljs.compiler.emit(param_101251);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_101251,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__101252 = cljs.core.next(seq__101206_101245__$1);
var G__101253 = null;
var G__101254 = (0);
var G__101255 = (0);
seq__101206_101235 = G__101252;
chunk__101207_101236 = G__101253;
count__101208_101237 = G__101254;
i__101209_101238 = G__101255;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101211,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_101211,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_101210__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101211,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_101212,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_101211,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__101259){
var map__101260 = p__101259;
var map__101260__$1 = (((((!((map__101260 == null))))?(((((map__101260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101260):map__101260);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$recur_DASH_frames);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__101256_SHARP_){
var and__4120__auto__ = p1__101256_SHARP_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__101256_SHARP_));
} else {
return and__4120__auto__;
}
});})(map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,recur_frames)], 0)),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_101313__$1 = (function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_101314 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_101313__$1);
var maxparams_101315 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_101316 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (name_101313__$1,mname_101314,maxparams_101315,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_101314),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_101313__$1,mname_101314,maxparams_101315,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,methods$));
var ms_101317 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (name_101313__$1,mname_101314,maxparams_101315,mmap_101316,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__101257_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__101257_SHARP_)));
});})(name_101313__$1,mname_101314,maxparams_101315,mmap_101316,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,cljs.core.seq(mmap_101316));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_101314," = null;");

var seq__101262_101318 = cljs.core.seq(ms_101317);
var chunk__101263_101319 = null;
var count__101264_101320 = (0);
var i__101265_101321 = (0);
while(true){
if((i__101265_101321 < count__101264_101320)){
var vec__101272_101322 = chunk__101263_101319.cljs$core$IIndexed$_nth$arity$2(null,i__101265_101321);
var n_101323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101272_101322,(0),null);
var meth_101324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101272_101322,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_101323," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101324))){
cljs.compiler.emit_variadic_fn_method(meth_101324);
} else {
cljs.compiler.emit_fn_method(meth_101324);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__101325 = seq__101262_101318;
var G__101326 = chunk__101263_101319;
var G__101327 = count__101264_101320;
var G__101328 = (i__101265_101321 + (1));
seq__101262_101318 = G__101325;
chunk__101263_101319 = G__101326;
count__101264_101320 = G__101327;
i__101265_101321 = G__101328;
continue;
} else {
var temp__5735__auto___101329 = cljs.core.seq(seq__101262_101318);
if(temp__5735__auto___101329){
var seq__101262_101330__$1 = temp__5735__auto___101329;
if(cljs.core.chunked_seq_QMARK_(seq__101262_101330__$1)){
var c__4550__auto___101331 = cljs.core.chunk_first(seq__101262_101330__$1);
var G__101332 = cljs.core.chunk_rest(seq__101262_101330__$1);
var G__101333 = c__4550__auto___101331;
var G__101334 = cljs.core.count(c__4550__auto___101331);
var G__101335 = (0);
seq__101262_101318 = G__101332;
chunk__101263_101319 = G__101333;
count__101264_101320 = G__101334;
i__101265_101321 = G__101335;
continue;
} else {
var vec__101275_101336 = cljs.core.first(seq__101262_101330__$1);
var n_101337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101275_101336,(0),null);
var meth_101338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101275_101336,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_101337," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101338))){
cljs.compiler.emit_variadic_fn_method(meth_101338);
} else {
cljs.compiler.emit_fn_method(meth_101338);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__101339 = cljs.core.next(seq__101262_101330__$1);
var G__101340 = null;
var G__101341 = (0);
var G__101342 = (0);
seq__101262_101318 = G__101339;
chunk__101263_101319 = G__101340;
count__101264_101320 = G__101341;
i__101265_101321 = G__101342;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101314," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_101315),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_101315)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_101315));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__101278_101343 = cljs.core.seq(ms_101317);
var chunk__101279_101344 = null;
var count__101280_101345 = (0);
var i__101281_101346 = (0);
while(true){
if((i__101281_101346 < count__101280_101345)){
var vec__101288_101347 = chunk__101279_101344.cljs$core$IIndexed$_nth$arity$2(null,i__101281_101346);
var n_101348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101288_101347,(0),null);
var meth_101349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101288_101347,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101349))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_101350 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_101350," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_101351 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_101350," = new cljs.core.IndexedSeq(",a_101351,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_101348,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_101315)),(((cljs.core.count(maxparams_101315) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_101350,");"], 0));
} else {
var pcnt_101352 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_101349));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_101352,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_101348,".call(this",(((pcnt_101352 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_101352,maxparams_101315)),null,(1),null)),(2),null))),");");
}


var G__101353 = seq__101278_101343;
var G__101354 = chunk__101279_101344;
var G__101355 = count__101280_101345;
var G__101356 = (i__101281_101346 + (1));
seq__101278_101343 = G__101353;
chunk__101279_101344 = G__101354;
count__101280_101345 = G__101355;
i__101281_101346 = G__101356;
continue;
} else {
var temp__5735__auto___101357 = cljs.core.seq(seq__101278_101343);
if(temp__5735__auto___101357){
var seq__101278_101358__$1 = temp__5735__auto___101357;
if(cljs.core.chunked_seq_QMARK_(seq__101278_101358__$1)){
var c__4550__auto___101359 = cljs.core.chunk_first(seq__101278_101358__$1);
var G__101360 = cljs.core.chunk_rest(seq__101278_101358__$1);
var G__101361 = c__4550__auto___101359;
var G__101362 = cljs.core.count(c__4550__auto___101359);
var G__101363 = (0);
seq__101278_101343 = G__101360;
chunk__101279_101344 = G__101361;
count__101280_101345 = G__101362;
i__101281_101346 = G__101363;
continue;
} else {
var vec__101291_101364 = cljs.core.first(seq__101278_101358__$1);
var n_101365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101291_101364,(0),null);
var meth_101366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101291_101364,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101366))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_101367 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_101367," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_101368 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_101367," = new cljs.core.IndexedSeq(",a_101368,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_101365,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_101315)),(((cljs.core.count(maxparams_101315) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_101367,");"], 0));
} else {
var pcnt_101369 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_101366));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_101369,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_101365,".call(this",(((pcnt_101369 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_101369,maxparams_101315)),null,(1),null)),(2),null))),");");
}


var G__101370 = cljs.core.next(seq__101278_101358__$1);
var G__101371 = null;
var G__101372 = (0);
var G__101373 = (0);
seq__101278_101343 = G__101370;
chunk__101279_101344 = G__101371;
count__101280_101345 = G__101372;
i__101281_101346 = G__101373;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_101374 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_101317)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_101374,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101314,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101314,".cljs$lang$applyTo = ",cljs.core.some(((function (name_101313__$1,mname_101314,maxparams_101315,mmap_101316,ms_101317,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets){
return (function (p1__101258_SHARP_){
var vec__101294 = p1__101258_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101294,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101294,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_101313__$1,mname_101314,maxparams_101315,mmap_101316,ms_101317,loop_locals,map__101260,map__101260__$1,variadic,name,env,methods$,max_fixed_arity,recur_frames,loop_lets))
,ms_101317),".cljs$lang$applyTo;");
} else {
}

var seq__101297_101375 = cljs.core.seq(ms_101317);
var chunk__101298_101376 = null;
var count__101299_101377 = (0);
var i__101300_101378 = (0);
while(true){
if((i__101300_101378 < count__101299_101377)){
var vec__101307_101379 = chunk__101298_101376.cljs$core$IIndexed$_nth$arity$2(null,i__101300_101378);
var n_101380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101307_101379,(0),null);
var meth_101381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101307_101379,(1),null);
var c_101382 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_101381));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101381))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101314,".cljs$core$IFn$_invoke$arity$variadic = ",n_101380,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_101314,".cljs$core$IFn$_invoke$arity$",c_101382," = ",n_101380,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__101383 = seq__101297_101375;
var G__101384 = chunk__101298_101376;
var G__101385 = count__101299_101377;
var G__101386 = (i__101300_101378 + (1));
seq__101297_101375 = G__101383;
chunk__101298_101376 = G__101384;
count__101299_101377 = G__101385;
i__101300_101378 = G__101386;
continue;
} else {
var temp__5735__auto___101387 = cljs.core.seq(seq__101297_101375);
if(temp__5735__auto___101387){
var seq__101297_101388__$1 = temp__5735__auto___101387;
if(cljs.core.chunked_seq_QMARK_(seq__101297_101388__$1)){
var c__4550__auto___101389 = cljs.core.chunk_first(seq__101297_101388__$1);
var G__101390 = cljs.core.chunk_rest(seq__101297_101388__$1);
var G__101391 = c__4550__auto___101389;
var G__101392 = cljs.core.count(c__4550__auto___101389);
var G__101393 = (0);
seq__101297_101375 = G__101390;
chunk__101298_101376 = G__101391;
count__101299_101377 = G__101392;
i__101300_101378 = G__101393;
continue;
} else {
var vec__101310_101394 = cljs.core.first(seq__101297_101388__$1);
var n_101395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101310_101394,(0),null);
var meth_101396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101310_101394,(1),null);
var c_101397 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_101396));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_101396))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_101314,".cljs$core$IFn$_invoke$arity$variadic = ",n_101395,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_101314,".cljs$core$IFn$_invoke$arity$",c_101397," = ",n_101395,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__101398 = cljs.core.next(seq__101297_101388__$1);
var G__101399 = null;
var G__101400 = (0);
var G__101401 = (0);
seq__101297_101375 = G__101398;
chunk__101298_101376 = G__101399;
count__101299_101377 = G__101400;
i__101300_101378 = G__101401;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_101314,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__101402){
var map__101403 = p__101402;
var map__101403__$1 = (((((!((map__101403 == null))))?(((((map__101403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101403.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101403):map__101403);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101403__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101403__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101403__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__101405_101409 = cljs.core.seq(statements);
var chunk__101406_101410 = null;
var count__101407_101411 = (0);
var i__101408_101412 = (0);
while(true){
if((i__101408_101412 < count__101407_101411)){
var s_101413 = chunk__101406_101410.cljs$core$IIndexed$_nth$arity$2(null,i__101408_101412);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_101413);


var G__101414 = seq__101405_101409;
var G__101415 = chunk__101406_101410;
var G__101416 = count__101407_101411;
var G__101417 = (i__101408_101412 + (1));
seq__101405_101409 = G__101414;
chunk__101406_101410 = G__101415;
count__101407_101411 = G__101416;
i__101408_101412 = G__101417;
continue;
} else {
var temp__5735__auto___101418 = cljs.core.seq(seq__101405_101409);
if(temp__5735__auto___101418){
var seq__101405_101419__$1 = temp__5735__auto___101418;
if(cljs.core.chunked_seq_QMARK_(seq__101405_101419__$1)){
var c__4550__auto___101420 = cljs.core.chunk_first(seq__101405_101419__$1);
var G__101421 = cljs.core.chunk_rest(seq__101405_101419__$1);
var G__101422 = c__4550__auto___101420;
var G__101423 = cljs.core.count(c__4550__auto___101420);
var G__101424 = (0);
seq__101405_101409 = G__101421;
chunk__101406_101410 = G__101422;
count__101407_101411 = G__101423;
i__101408_101412 = G__101424;
continue;
} else {
var s_101425 = cljs.core.first(seq__101405_101419__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_101425);


var G__101426 = cljs.core.next(seq__101405_101419__$1);
var G__101427 = null;
var G__101428 = (0);
var G__101429 = (0);
seq__101405_101409 = G__101426;
chunk__101406_101410 = G__101427;
count__101407_101411 = G__101428;
i__101408_101412 = G__101429;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__101430){
var map__101431 = p__101430;
var map__101431__$1 = (((((!((map__101431 == null))))?(((((map__101431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101431):map__101431);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101431__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101431__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101431__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101431__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101431__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__101433,is_loop){
var map__101434 = p__101433;
var map__101434__$1 = (((((!((map__101434 == null))))?(((((map__101434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101434.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101434):map__101434);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101434__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101434__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101434__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__101436_101450 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__101437_101451 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_lexical_renames_STAR__orig_val__101436_101450,context,map__101434,map__101434__$1,expr,bindings,env){
return (function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR__orig_val__101436_101450,context,map__101434,map__101434__$1,expr,bindings,env))
,bindings):null));
cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__101437_101451;

try{var seq__101438_101452 = cljs.core.seq(bindings);
var chunk__101439_101453 = null;
var count__101440_101454 = (0);
var i__101441_101455 = (0);
while(true){
if((i__101441_101455 < count__101440_101454)){
var map__101446_101456 = chunk__101439_101453.cljs$core$IIndexed$_nth$arity$2(null,i__101441_101455);
var map__101446_101457__$1 = (((((!((map__101446_101456 == null))))?(((((map__101446_101456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101446_101456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101446_101456):map__101446_101456);
var binding_101458 = map__101446_101457__$1;
var init_101459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101446_101457__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_101458);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_101459,";");


var G__101460 = seq__101438_101452;
var G__101461 = chunk__101439_101453;
var G__101462 = count__101440_101454;
var G__101463 = (i__101441_101455 + (1));
seq__101438_101452 = G__101460;
chunk__101439_101453 = G__101461;
count__101440_101454 = G__101462;
i__101441_101455 = G__101463;
continue;
} else {
var temp__5735__auto___101464 = cljs.core.seq(seq__101438_101452);
if(temp__5735__auto___101464){
var seq__101438_101465__$1 = temp__5735__auto___101464;
if(cljs.core.chunked_seq_QMARK_(seq__101438_101465__$1)){
var c__4550__auto___101466 = cljs.core.chunk_first(seq__101438_101465__$1);
var G__101467 = cljs.core.chunk_rest(seq__101438_101465__$1);
var G__101468 = c__4550__auto___101466;
var G__101469 = cljs.core.count(c__4550__auto___101466);
var G__101470 = (0);
seq__101438_101452 = G__101467;
chunk__101439_101453 = G__101468;
count__101440_101454 = G__101469;
i__101441_101455 = G__101470;
continue;
} else {
var map__101448_101471 = cljs.core.first(seq__101438_101465__$1);
var map__101448_101472__$1 = (((((!((map__101448_101471 == null))))?(((((map__101448_101471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101448_101471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101448_101471):map__101448_101471);
var binding_101473 = map__101448_101472__$1;
var init_101474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101448_101472__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_101473);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_101474,";");


var G__101475 = cljs.core.next(seq__101438_101465__$1);
var G__101476 = null;
var G__101477 = (0);
var G__101478 = (0);
seq__101438_101452 = G__101475;
chunk__101439_101453 = G__101476;
count__101440_101454 = G__101477;
i__101441_101455 = G__101478;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__101436_101450;
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__101479){
var map__101480 = p__101479;
var map__101480__$1 = (((((!((map__101480 == null))))?(((((map__101480.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101480.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101480):map__101480);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101480__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101480__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101480__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4607__auto___101482 = cljs.core.count(exprs);
var i_101483 = (0);
while(true){
if((i_101483 < n__4607__auto___101482)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_101483) : temps.call(null,i_101483))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_101483) : exprs.call(null,i_101483)),";");

var G__101484 = (i_101483 + (1));
i_101483 = G__101484;
continue;
} else {
}
break;
}

var n__4607__auto___101485 = cljs.core.count(exprs);
var i_101486 = (0);
while(true){
if((i_101486 < n__4607__auto___101485)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_101486) : params.call(null,i_101486)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_101486) : temps.call(null,i_101486)),";");

var G__101487 = (i_101486 + (1));
i_101486 = G__101487;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__101488){
var map__101489 = p__101488;
var map__101489__$1 = (((((!((map__101489 == null))))?(((((map__101489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101489.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101489):map__101489);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101489__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101489__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101489__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__101491_101503 = cljs.core.seq(bindings);
var chunk__101492_101504 = null;
var count__101493_101505 = (0);
var i__101494_101506 = (0);
while(true){
if((i__101494_101506 < count__101493_101505)){
var map__101499_101507 = chunk__101492_101504.cljs$core$IIndexed$_nth$arity$2(null,i__101494_101506);
var map__101499_101508__$1 = (((((!((map__101499_101507 == null))))?(((((map__101499_101507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101499_101507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101499_101507):map__101499_101507);
var binding_101509 = map__101499_101508__$1;
var init_101510 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101499_101508__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_101509)," = ",init_101510,";");


var G__101511 = seq__101491_101503;
var G__101512 = chunk__101492_101504;
var G__101513 = count__101493_101505;
var G__101514 = (i__101494_101506 + (1));
seq__101491_101503 = G__101511;
chunk__101492_101504 = G__101512;
count__101493_101505 = G__101513;
i__101494_101506 = G__101514;
continue;
} else {
var temp__5735__auto___101515 = cljs.core.seq(seq__101491_101503);
if(temp__5735__auto___101515){
var seq__101491_101516__$1 = temp__5735__auto___101515;
if(cljs.core.chunked_seq_QMARK_(seq__101491_101516__$1)){
var c__4550__auto___101517 = cljs.core.chunk_first(seq__101491_101516__$1);
var G__101518 = cljs.core.chunk_rest(seq__101491_101516__$1);
var G__101519 = c__4550__auto___101517;
var G__101520 = cljs.core.count(c__4550__auto___101517);
var G__101521 = (0);
seq__101491_101503 = G__101518;
chunk__101492_101504 = G__101519;
count__101493_101505 = G__101520;
i__101494_101506 = G__101521;
continue;
} else {
var map__101501_101522 = cljs.core.first(seq__101491_101516__$1);
var map__101501_101523__$1 = (((((!((map__101501_101522 == null))))?(((((map__101501_101522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101501_101522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101501_101522):map__101501_101522);
var binding_101524 = map__101501_101523__$1;
var init_101525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101501_101523__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_101524)," = ",init_101525,";");


var G__101526 = cljs.core.next(seq__101491_101516__$1);
var G__101527 = null;
var G__101528 = (0);
var G__101529 = (0);
seq__101491_101503 = G__101526;
chunk__101492_101504 = G__101527;
count__101493_101505 = G__101528;
i__101494_101506 = G__101529;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__101532){
var map__101533 = p__101532;
var map__101533__$1 = (((((!((map__101533 == null))))?(((((map__101533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101533.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101533):map__101533);
var expr = map__101533__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101533__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101533__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101533__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4120__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4120__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4120__auto__ = protocol;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = tag;
if(cljs.core.truth_(and__4120__auto____$1)){
var or__4131__auto__ = (function (){var and__4120__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto____$2){
var and__4120__auto____$3 = protocol;
if(cljs.core.truth_(and__4120__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4120__auto____$3;
}
} else {
return and__4120__auto____$2;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto____$2 = (function (){var or__4131__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4120__auto____$2)){
var or__4131__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
var and__4120__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4120__auto____$3){
var and__4120__auto____$4 = cljs.core.not((function (){var fexpr__101543 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__101543.cljs$core$IFn$_invoke$arity$1 ? fexpr__101543.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__101543.call(null,tag));
})());
if(and__4120__auto____$4){
var temp__5735__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4120__auto____$4;
}
} else {
return and__4120__auto____$3;
}
}
} else {
return and__4120__auto____$2;
}
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr))),cljs.core.cst$sym$boolean)));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,cljs.analyzer.infer_tag(env,f));
if(or__4131__auto__){
return or__4131__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__101535 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (arity > mfa);
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env){
return (function (p1__101530_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__101530_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env){
return (function (p1__101531_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__101531_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__101533,map__101533__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101535,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101535,(1),null);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_101548 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_101548,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_101549 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_101549,args)),(((mfa_101549 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_101549,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = js_QMARK_;
if(or__4131__auto____$1){
return or__4131__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__4120__auto__){
var G__101547 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__101546 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__101546.cljs$core$IFn$_invoke$arity$1 ? fexpr__101546.cljs$core$IFn$_invoke$arity$1(G__101547) : fexpr__101546.call(null,G__101547));
} else {
return and__4120__auto__;
}
})())){
var fprop_101550 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_101550," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_101550,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_101550," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_101550,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__101551){
var map__101552 = p__101551;
var map__101552__$1 = (((((!((map__101552 == null))))?(((((map__101552.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101552.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101552):map__101552);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101552__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101552__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101552__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__101554){
var map__101555 = p__101554;
var map__101555__$1 = (((((!((map__101555 == null))))?(((((map__101555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101555.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101555):map__101555);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101555__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101555__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101555__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target," = ",val);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__101557 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__101557__$1 = (((((!((map__101557 == null))))?(((((map__101557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101557.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101557):map__101557);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101557__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101557__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__101558 = options;
var map__101558__$1 = (((((!((map__101558 == null))))?(((((map__101558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101558.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101558):map__101558);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101558__$1,cljs.core.cst$kw$target);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101558__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__101559 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__101564 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__101564__$1 = (((((!((map__101564 == null))))?(((((map__101564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101564.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101564):map__101564);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101564__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101564__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101559,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101559,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__101566_101586 = cljs.core.seq(libs_to_load);
var chunk__101567_101587 = null;
var count__101568_101588 = (0);
var i__101569_101589 = (0);
while(true){
if((i__101569_101589 < count__101568_101588)){
var lib_101590 = chunk__101567_101587.cljs$core$IIndexed$_nth$arity$2(null,i__101569_101589);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_101590)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_101590),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101590),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_101590),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101590),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_101590,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101590),"');");
}

}
}
}


var G__101591 = seq__101566_101586;
var G__101592 = chunk__101567_101587;
var G__101593 = count__101568_101588;
var G__101594 = (i__101569_101589 + (1));
seq__101566_101586 = G__101591;
chunk__101567_101587 = G__101592;
count__101568_101588 = G__101593;
i__101569_101589 = G__101594;
continue;
} else {
var temp__5735__auto___101595 = cljs.core.seq(seq__101566_101586);
if(temp__5735__auto___101595){
var seq__101566_101596__$1 = temp__5735__auto___101595;
if(cljs.core.chunked_seq_QMARK_(seq__101566_101596__$1)){
var c__4550__auto___101597 = cljs.core.chunk_first(seq__101566_101596__$1);
var G__101598 = cljs.core.chunk_rest(seq__101566_101596__$1);
var G__101599 = c__4550__auto___101597;
var G__101600 = cljs.core.count(c__4550__auto___101597);
var G__101601 = (0);
seq__101566_101586 = G__101598;
chunk__101567_101587 = G__101599;
count__101568_101588 = G__101600;
i__101569_101589 = G__101601;
continue;
} else {
var lib_101602 = cljs.core.first(seq__101566_101596__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_101602)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_101602),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101602),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_101602),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101602),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_101602,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_101602),"');");
}

}
}
}


var G__101603 = cljs.core.next(seq__101566_101596__$1);
var G__101604 = null;
var G__101605 = (0);
var G__101606 = (0);
seq__101566_101586 = G__101603;
chunk__101567_101587 = G__101604;
count__101568_101588 = G__101605;
i__101569_101589 = G__101606;
continue;
}
} else {
}
}
break;
}

var seq__101570_101607 = cljs.core.seq(node_libs);
var chunk__101571_101608 = null;
var count__101572_101609 = (0);
var i__101573_101610 = (0);
while(true){
if((i__101573_101610 < count__101572_101609)){
var lib_101611 = chunk__101571_101608.cljs$core$IIndexed$_nth$arity$2(null,i__101573_101610);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_101611)," = require('",lib_101611,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__101612 = seq__101570_101607;
var G__101613 = chunk__101571_101608;
var G__101614 = count__101572_101609;
var G__101615 = (i__101573_101610 + (1));
seq__101570_101607 = G__101612;
chunk__101571_101608 = G__101613;
count__101572_101609 = G__101614;
i__101573_101610 = G__101615;
continue;
} else {
var temp__5735__auto___101616 = cljs.core.seq(seq__101570_101607);
if(temp__5735__auto___101616){
var seq__101570_101617__$1 = temp__5735__auto___101616;
if(cljs.core.chunked_seq_QMARK_(seq__101570_101617__$1)){
var c__4550__auto___101618 = cljs.core.chunk_first(seq__101570_101617__$1);
var G__101619 = cljs.core.chunk_rest(seq__101570_101617__$1);
var G__101620 = c__4550__auto___101618;
var G__101621 = cljs.core.count(c__4550__auto___101618);
var G__101622 = (0);
seq__101570_101607 = G__101619;
chunk__101571_101608 = G__101620;
count__101572_101609 = G__101621;
i__101573_101610 = G__101622;
continue;
} else {
var lib_101623 = cljs.core.first(seq__101570_101617__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_101623)," = require('",lib_101623,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__101624 = cljs.core.next(seq__101570_101617__$1);
var G__101625 = null;
var G__101626 = (0);
var G__101627 = (0);
seq__101570_101607 = G__101624;
chunk__101571_101608 = G__101625;
count__101572_101609 = G__101626;
i__101573_101610 = G__101627;
continue;
}
} else {
}
}
break;
}

var seq__101574_101628 = cljs.core.seq(global_exports_libs);
var chunk__101575_101629 = null;
var count__101576_101630 = (0);
var i__101577_101631 = (0);
while(true){
if((i__101577_101631 < count__101576_101630)){
var lib_101632 = chunk__101575_101629.cljs$core$IIndexed$_nth$arity$2(null,i__101577_101631);
var map__101582_101633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_101632));
var map__101582_101634__$1 = (((((!((map__101582_101633 == null))))?(((((map__101582_101633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101582_101633.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101582_101633):map__101582_101633);
var global_exports_101635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101582_101634__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_101635,lib_101632);


var G__101636 = seq__101574_101628;
var G__101637 = chunk__101575_101629;
var G__101638 = count__101576_101630;
var G__101639 = (i__101577_101631 + (1));
seq__101574_101628 = G__101636;
chunk__101575_101629 = G__101637;
count__101576_101630 = G__101638;
i__101577_101631 = G__101639;
continue;
} else {
var temp__5735__auto___101640 = cljs.core.seq(seq__101574_101628);
if(temp__5735__auto___101640){
var seq__101574_101641__$1 = temp__5735__auto___101640;
if(cljs.core.chunked_seq_QMARK_(seq__101574_101641__$1)){
var c__4550__auto___101642 = cljs.core.chunk_first(seq__101574_101641__$1);
var G__101643 = cljs.core.chunk_rest(seq__101574_101641__$1);
var G__101644 = c__4550__auto___101642;
var G__101645 = cljs.core.count(c__4550__auto___101642);
var G__101646 = (0);
seq__101574_101628 = G__101643;
chunk__101575_101629 = G__101644;
count__101576_101630 = G__101645;
i__101577_101631 = G__101646;
continue;
} else {
var lib_101647 = cljs.core.first(seq__101574_101641__$1);
var map__101584_101648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_101647));
var map__101584_101649__$1 = (((((!((map__101584_101648 == null))))?(((((map__101584_101648.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101584_101648.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101584_101648):map__101584_101648);
var global_exports_101650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101584_101649__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_101650,lib_101647);


var G__101651 = cljs.core.next(seq__101574_101641__$1);
var G__101652 = null;
var G__101653 = (0);
var G__101654 = (0);
seq__101574_101628 = G__101651;
chunk__101575_101629 = G__101652;
count__101576_101630 = G__101653;
i__101577_101631 = G__101654;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__101655){
var map__101656 = p__101655;
var map__101656__$1 = (((((!((map__101656 == null))))?(((((map__101656.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101656.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101656):map__101656);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101656__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__101658){
var map__101659 = p__101658;
var map__101659__$1 = (((((!((map__101659 == null))))?(((((map__101659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101659.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101659):map__101659);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101659__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__101661){
var map__101662 = p__101661;
var map__101662__$1 = (((((!((map__101662 == null))))?(((((map__101662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101662):map__101662);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101662__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101662__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101662__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101662__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101662__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__101664_101688 = cljs.core.seq(protocols);
var chunk__101665_101689 = null;
var count__101666_101690 = (0);
var i__101667_101691 = (0);
while(true){
if((i__101667_101691 < count__101666_101690)){
var protocol_101692 = chunk__101665_101689.cljs$core$IIndexed$_nth$arity$2(null,i__101667_101691);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_101692)),"}");


var G__101693 = seq__101664_101688;
var G__101694 = chunk__101665_101689;
var G__101695 = count__101666_101690;
var G__101696 = (i__101667_101691 + (1));
seq__101664_101688 = G__101693;
chunk__101665_101689 = G__101694;
count__101666_101690 = G__101695;
i__101667_101691 = G__101696;
continue;
} else {
var temp__5735__auto___101697 = cljs.core.seq(seq__101664_101688);
if(temp__5735__auto___101697){
var seq__101664_101698__$1 = temp__5735__auto___101697;
if(cljs.core.chunked_seq_QMARK_(seq__101664_101698__$1)){
var c__4550__auto___101699 = cljs.core.chunk_first(seq__101664_101698__$1);
var G__101700 = cljs.core.chunk_rest(seq__101664_101698__$1);
var G__101701 = c__4550__auto___101699;
var G__101702 = cljs.core.count(c__4550__auto___101699);
var G__101703 = (0);
seq__101664_101688 = G__101700;
chunk__101665_101689 = G__101701;
count__101666_101690 = G__101702;
i__101667_101691 = G__101703;
continue;
} else {
var protocol_101704 = cljs.core.first(seq__101664_101698__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_101704)),"}");


var G__101705 = cljs.core.next(seq__101664_101698__$1);
var G__101706 = null;
var G__101707 = (0);
var G__101708 = (0);
seq__101664_101688 = G__101705;
chunk__101665_101689 = G__101706;
count__101666_101690 = G__101707;
i__101667_101691 = G__101708;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__101668_101709 = cljs.core.seq(fields__$1);
var chunk__101669_101710 = null;
var count__101670_101711 = (0);
var i__101671_101712 = (0);
while(true){
if((i__101671_101712 < count__101670_101711)){
var fld_101713 = chunk__101669_101710.cljs$core$IIndexed$_nth$arity$2(null,i__101671_101712);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_101713," = ",fld_101713,";");


var G__101714 = seq__101668_101709;
var G__101715 = chunk__101669_101710;
var G__101716 = count__101670_101711;
var G__101717 = (i__101671_101712 + (1));
seq__101668_101709 = G__101714;
chunk__101669_101710 = G__101715;
count__101670_101711 = G__101716;
i__101671_101712 = G__101717;
continue;
} else {
var temp__5735__auto___101718 = cljs.core.seq(seq__101668_101709);
if(temp__5735__auto___101718){
var seq__101668_101719__$1 = temp__5735__auto___101718;
if(cljs.core.chunked_seq_QMARK_(seq__101668_101719__$1)){
var c__4550__auto___101720 = cljs.core.chunk_first(seq__101668_101719__$1);
var G__101721 = cljs.core.chunk_rest(seq__101668_101719__$1);
var G__101722 = c__4550__auto___101720;
var G__101723 = cljs.core.count(c__4550__auto___101720);
var G__101724 = (0);
seq__101668_101709 = G__101721;
chunk__101669_101710 = G__101722;
count__101670_101711 = G__101723;
i__101671_101712 = G__101724;
continue;
} else {
var fld_101725 = cljs.core.first(seq__101668_101719__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_101725," = ",fld_101725,";");


var G__101726 = cljs.core.next(seq__101668_101719__$1);
var G__101727 = null;
var G__101728 = (0);
var G__101729 = (0);
seq__101668_101709 = G__101726;
chunk__101669_101710 = G__101727;
count__101670_101711 = G__101728;
i__101671_101712 = G__101729;
continue;
}
} else {
}
}
break;
}

var seq__101672_101730 = cljs.core.seq(pmasks);
var chunk__101673_101731 = null;
var count__101674_101732 = (0);
var i__101675_101733 = (0);
while(true){
if((i__101675_101733 < count__101674_101732)){
var vec__101682_101734 = chunk__101673_101731.cljs$core$IIndexed$_nth$arity$2(null,i__101675_101733);
var pno_101735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101682_101734,(0),null);
var pmask_101736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101682_101734,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_101735,"$ = ",pmask_101736,";");


var G__101737 = seq__101672_101730;
var G__101738 = chunk__101673_101731;
var G__101739 = count__101674_101732;
var G__101740 = (i__101675_101733 + (1));
seq__101672_101730 = G__101737;
chunk__101673_101731 = G__101738;
count__101674_101732 = G__101739;
i__101675_101733 = G__101740;
continue;
} else {
var temp__5735__auto___101741 = cljs.core.seq(seq__101672_101730);
if(temp__5735__auto___101741){
var seq__101672_101742__$1 = temp__5735__auto___101741;
if(cljs.core.chunked_seq_QMARK_(seq__101672_101742__$1)){
var c__4550__auto___101743 = cljs.core.chunk_first(seq__101672_101742__$1);
var G__101744 = cljs.core.chunk_rest(seq__101672_101742__$1);
var G__101745 = c__4550__auto___101743;
var G__101746 = cljs.core.count(c__4550__auto___101743);
var G__101747 = (0);
seq__101672_101730 = G__101744;
chunk__101673_101731 = G__101745;
count__101674_101732 = G__101746;
i__101675_101733 = G__101747;
continue;
} else {
var vec__101685_101748 = cljs.core.first(seq__101672_101742__$1);
var pno_101749 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101685_101748,(0),null);
var pmask_101750 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101685_101748,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_101749,"$ = ",pmask_101750,";");


var G__101751 = cljs.core.next(seq__101672_101742__$1);
var G__101752 = null;
var G__101753 = (0);
var G__101754 = (0);
seq__101672_101730 = G__101751;
chunk__101673_101731 = G__101752;
count__101674_101732 = G__101753;
i__101675_101733 = G__101754;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__101755){
var map__101756 = p__101755;
var map__101756__$1 = (((((!((map__101756 == null))))?(((((map__101756.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101756.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101756):map__101756);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101756__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101756__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101756__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101756__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101756__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__101758_101782 = cljs.core.seq(protocols);
var chunk__101759_101783 = null;
var count__101760_101784 = (0);
var i__101761_101785 = (0);
while(true){
if((i__101761_101785 < count__101760_101784)){
var protocol_101786 = chunk__101759_101783.cljs$core$IIndexed$_nth$arity$2(null,i__101761_101785);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_101786)),"}");


var G__101787 = seq__101758_101782;
var G__101788 = chunk__101759_101783;
var G__101789 = count__101760_101784;
var G__101790 = (i__101761_101785 + (1));
seq__101758_101782 = G__101787;
chunk__101759_101783 = G__101788;
count__101760_101784 = G__101789;
i__101761_101785 = G__101790;
continue;
} else {
var temp__5735__auto___101791 = cljs.core.seq(seq__101758_101782);
if(temp__5735__auto___101791){
var seq__101758_101792__$1 = temp__5735__auto___101791;
if(cljs.core.chunked_seq_QMARK_(seq__101758_101792__$1)){
var c__4550__auto___101793 = cljs.core.chunk_first(seq__101758_101792__$1);
var G__101794 = cljs.core.chunk_rest(seq__101758_101792__$1);
var G__101795 = c__4550__auto___101793;
var G__101796 = cljs.core.count(c__4550__auto___101793);
var G__101797 = (0);
seq__101758_101782 = G__101794;
chunk__101759_101783 = G__101795;
count__101760_101784 = G__101796;
i__101761_101785 = G__101797;
continue;
} else {
var protocol_101798 = cljs.core.first(seq__101758_101792__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_101798)),"}");


var G__101799 = cljs.core.next(seq__101758_101792__$1);
var G__101800 = null;
var G__101801 = (0);
var G__101802 = (0);
seq__101758_101782 = G__101799;
chunk__101759_101783 = G__101800;
count__101760_101784 = G__101801;
i__101761_101785 = G__101802;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__101762_101803 = cljs.core.seq(fields__$1);
var chunk__101763_101804 = null;
var count__101764_101805 = (0);
var i__101765_101806 = (0);
while(true){
if((i__101765_101806 < count__101764_101805)){
var fld_101807 = chunk__101763_101804.cljs$core$IIndexed$_nth$arity$2(null,i__101765_101806);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_101807," = ",fld_101807,";");


var G__101808 = seq__101762_101803;
var G__101809 = chunk__101763_101804;
var G__101810 = count__101764_101805;
var G__101811 = (i__101765_101806 + (1));
seq__101762_101803 = G__101808;
chunk__101763_101804 = G__101809;
count__101764_101805 = G__101810;
i__101765_101806 = G__101811;
continue;
} else {
var temp__5735__auto___101812 = cljs.core.seq(seq__101762_101803);
if(temp__5735__auto___101812){
var seq__101762_101813__$1 = temp__5735__auto___101812;
if(cljs.core.chunked_seq_QMARK_(seq__101762_101813__$1)){
var c__4550__auto___101814 = cljs.core.chunk_first(seq__101762_101813__$1);
var G__101815 = cljs.core.chunk_rest(seq__101762_101813__$1);
var G__101816 = c__4550__auto___101814;
var G__101817 = cljs.core.count(c__4550__auto___101814);
var G__101818 = (0);
seq__101762_101803 = G__101815;
chunk__101763_101804 = G__101816;
count__101764_101805 = G__101817;
i__101765_101806 = G__101818;
continue;
} else {
var fld_101819 = cljs.core.first(seq__101762_101813__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_101819," = ",fld_101819,";");


var G__101820 = cljs.core.next(seq__101762_101813__$1);
var G__101821 = null;
var G__101822 = (0);
var G__101823 = (0);
seq__101762_101803 = G__101820;
chunk__101763_101804 = G__101821;
count__101764_101805 = G__101822;
i__101765_101806 = G__101823;
continue;
}
} else {
}
}
break;
}

var seq__101766_101824 = cljs.core.seq(pmasks);
var chunk__101767_101825 = null;
var count__101768_101826 = (0);
var i__101769_101827 = (0);
while(true){
if((i__101769_101827 < count__101768_101826)){
var vec__101776_101828 = chunk__101767_101825.cljs$core$IIndexed$_nth$arity$2(null,i__101769_101827);
var pno_101829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101776_101828,(0),null);
var pmask_101830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101776_101828,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_101829,"$ = ",pmask_101830,";");


var G__101831 = seq__101766_101824;
var G__101832 = chunk__101767_101825;
var G__101833 = count__101768_101826;
var G__101834 = (i__101769_101827 + (1));
seq__101766_101824 = G__101831;
chunk__101767_101825 = G__101832;
count__101768_101826 = G__101833;
i__101769_101827 = G__101834;
continue;
} else {
var temp__5735__auto___101835 = cljs.core.seq(seq__101766_101824);
if(temp__5735__auto___101835){
var seq__101766_101836__$1 = temp__5735__auto___101835;
if(cljs.core.chunked_seq_QMARK_(seq__101766_101836__$1)){
var c__4550__auto___101837 = cljs.core.chunk_first(seq__101766_101836__$1);
var G__101838 = cljs.core.chunk_rest(seq__101766_101836__$1);
var G__101839 = c__4550__auto___101837;
var G__101840 = cljs.core.count(c__4550__auto___101837);
var G__101841 = (0);
seq__101766_101824 = G__101838;
chunk__101767_101825 = G__101839;
count__101768_101826 = G__101840;
i__101769_101827 = G__101841;
continue;
} else {
var vec__101779_101842 = cljs.core.first(seq__101766_101836__$1);
var pno_101843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101779_101842,(0),null);
var pmask_101844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101779_101842,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_101843,"$ = ",pmask_101844,";");


var G__101845 = cljs.core.next(seq__101766_101836__$1);
var G__101846 = null;
var G__101847 = (0);
var G__101848 = (0);
seq__101766_101824 = G__101845;
chunk__101767_101825 = G__101846;
count__101768_101826 = G__101847;
i__101769_101827 = G__101848;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__101849){
var map__101850 = p__101849;
var map__101850__$1 = (((((!((map__101850 == null))))?(((((map__101850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101850.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101850):map__101850);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101850__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101850__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101850__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101850__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101850__$1,cljs.core.cst$kw$env);
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__101852){
var map__101853 = p__101852;
var map__101853__$1 = (((((!((map__101853 == null))))?(((((map__101853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101853):map__101853);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101853__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101853__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101853__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101853__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101853__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4120__auto__ = code;
if(cljs.core.truth_(and__4120__auto__)){
var G__101855 = clojure.string.trim(code);
var G__101856 = "/*";
return goog.string.startsWith(G__101855,G__101856);
} else {
return and__4120__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__100600__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__100600__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__101861 = cljs.core.seq(table);
var chunk__101862 = null;
var count__101863 = (0);
var i__101864 = (0);
while(true){
if((i__101864 < count__101863)){
var vec__101871 = chunk__101862.cljs$core$IIndexed$_nth$arity$2(null,i__101864);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101871,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101871,(1),null);
var ns_101877 = cljs.core.namespace(sym);
var name_101878 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__101879 = seq__101861;
var G__101880 = chunk__101862;
var G__101881 = count__101863;
var G__101882 = (i__101864 + (1));
seq__101861 = G__101879;
chunk__101862 = G__101880;
count__101863 = G__101881;
i__101864 = G__101882;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__101861);
if(temp__5735__auto__){
var seq__101861__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__101861__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__101861__$1);
var G__101883 = cljs.core.chunk_rest(seq__101861__$1);
var G__101884 = c__4550__auto__;
var G__101885 = cljs.core.count(c__4550__auto__);
var G__101886 = (0);
seq__101861 = G__101883;
chunk__101862 = G__101884;
count__101863 = G__101885;
i__101864 = G__101886;
continue;
} else {
var vec__101874 = cljs.core.first(seq__101861__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101874,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101874,(1),null);
var ns_101887 = cljs.core.namespace(sym);
var name_101888 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__101889 = cljs.core.next(seq__101861__$1);
var G__101890 = null;
var G__101891 = (0);
var G__101892 = (0);
seq__101861 = G__101889;
chunk__101862 = G__101890;
count__101863 = G__101891;
i__101864 = G__101892;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__101894 = arguments.length;
switch (G__101894) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.core.cst$kw$cljs$analyzer_SLASH_externs.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_101899 = cljs.core.first(ks);
var vec__101895_101900 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_101899);
var top_101901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__101895_101900,(0),null);
var prefix_SINGLEQUOTE__101902 = vec__101895_101900;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_101899)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__101902) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_101901)) || (cljs.core.contains_QMARK_(known_externs,top_101901)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__101902)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_101901);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__101902)),";");
}
} else {
}

var m_101903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_101899);
if(cljs.core.empty_QMARK_(m_101903)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__101902,m_101903,top_level,known_externs);
}

var G__101904 = cljs.core.next(ks);
ks = G__101904;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=compiler.js.map?rel=1593113245159
