// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33878(s__33879){
return (new cljs.core.LazySeq(null,(function (){
var s__33879__$1 = s__33879;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33879__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33884 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33884,(0),null);
var item_set = cljs.core.nth.call(null,vec__33884,(1),null);
var iterys__4525__auto__ = ((function (s__33879__$1,vec__33884,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__33878_$_iter__33880(s__33881){
return (new cljs.core.LazySeq(null,((function (s__33879__$1,vec__33884,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__33881__$1 = s__33881;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33881__$1);
if(temp__5735__auto____$1){
var s__33881__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33881__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33881__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33883 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33882 = (0);
while(true){
if((i__33882 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33882);
cljs.core.chunk_append.call(null,b__33883,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__33932 = (i__33882 + (1));
i__33882 = G__33932;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33883),tailrecursion$priority_map$iter__33878_$_iter__33880.call(null,cljs.core.chunk_rest.call(null,s__33881__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33883),null);
}
} else {
var item = cljs.core.first.call(null,s__33881__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__33878_$_iter__33880.call(null,cljs.core.rest.call(null,s__33881__$2)));
}
} else {
return null;
}
break;
}
});})(s__33879__$1,vec__33884,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__33879__$1,vec__33884,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33878.call(null,cljs.core.rest.call(null,s__33879__$1)));
} else {
var G__33933 = cljs.core.rest.call(null,s__33879__$1);
s__33879__$1 = G__33933;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33887(s__33888){
return (new cljs.core.LazySeq(null,(function (){
var s__33888__$1 = s__33888;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33888__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33893 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33893,(0),null);
var item_set = cljs.core.nth.call(null,vec__33893,(1),null);
var iterys__4525__auto__ = ((function (s__33888__$1,vec__33893,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__33887_$_iter__33889(s__33890){
return (new cljs.core.LazySeq(null,((function (s__33888__$1,vec__33893,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__33890__$1 = s__33890;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33890__$1);
if(temp__5735__auto____$1){
var s__33890__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33890__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33890__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33892 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33891 = (0);
while(true){
if((i__33891 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33891);
cljs.core.chunk_append.call(null,b__33892,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__33934 = (i__33891 + (1));
i__33891 = G__33934;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33892),tailrecursion$priority_map$iter__33887_$_iter__33889.call(null,cljs.core.chunk_rest.call(null,s__33890__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33892),null);
}
} else {
var item = cljs.core.first.call(null,s__33890__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__33887_$_iter__33889.call(null,cljs.core.rest.call(null,s__33890__$2)));
}
} else {
return null;
}
break;
}
});})(s__33888__$1,vec__33893,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__33888__$1,vec__33893,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33887.call(null,cljs.core.rest.call(null,s__33888__$1)));
} else {
var G__33935 = cljs.core.rest.call(null,s__33888__$1);
s__33888__$1 = G__33935;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5733__auto__)){
var current_priority = temp__5733__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33896(s__33897){
return (new cljs.core.LazySeq(null,(function (){
var s__33897__$1 = s__33897;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33897__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33902 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33902,(0),null);
var item_set = cljs.core.nth.call(null,vec__33902,(1),null);
var iterys__4525__auto__ = ((function (s__33897__$1,vec__33902,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__33896_$_iter__33898(s__33899){
return (new cljs.core.LazySeq(null,((function (s__33897__$1,vec__33902,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__33899__$1 = s__33899;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33899__$1);
if(temp__5735__auto____$1){
var s__33899__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33899__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33899__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33901 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33900 = (0);
while(true){
if((i__33900 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33900);
cljs.core.chunk_append.call(null,b__33901,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__33936 = (i__33900 + (1));
i__33900 = G__33936;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33901),tailrecursion$priority_map$iter__33896_$_iter__33898.call(null,cljs.core.chunk_rest.call(null,s__33899__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33901),null);
}
} else {
var item = cljs.core.first.call(null,s__33899__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__33896_$_iter__33898.call(null,cljs.core.rest.call(null,s__33899__$2)));
}
} else {
return null;
}
break;
}
});})(s__33897__$1,vec__33902,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__33897__$1,vec__33902,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33896.call(null,cljs.core.rest.call(null,s__33897__$1)));
} else {
var G__33937 = cljs.core.rest.call(null,s__33897__$1);
s__33897__$1 = G__33937;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33905(s__33906){
return (new cljs.core.LazySeq(null,(function (){
var s__33906__$1 = s__33906;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33906__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33911 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33911,(0),null);
var item_set = cljs.core.nth.call(null,vec__33911,(1),null);
var iterys__4525__auto__ = ((function (s__33906__$1,vec__33911,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__33905_$_iter__33907(s__33908){
return (new cljs.core.LazySeq(null,((function (s__33906__$1,vec__33911,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__33908__$1 = s__33908;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33908__$1);
if(temp__5735__auto____$1){
var s__33908__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33908__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33908__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33910 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33909 = (0);
while(true){
if((i__33909 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33909);
cljs.core.chunk_append.call(null,b__33910,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__33938 = (i__33909 + (1));
i__33909 = G__33938;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33910),tailrecursion$priority_map$iter__33905_$_iter__33907.call(null,cljs.core.chunk_rest.call(null,s__33908__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33910),null);
}
} else {
var item = cljs.core.first.call(null,s__33908__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__33905_$_iter__33907.call(null,cljs.core.rest.call(null,s__33908__$2)));
}
} else {
return null;
}
break;
}
});})(s__33906__$1,vec__33911,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__33906__$1,vec__33911,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33905.call(null,cljs.core.rest.call(null,s__33906__$1)));
} else {
var G__33939 = cljs.core.rest.call(null,s__33906__$1);
s__33906__$1 = G__33939;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__33940 = null;
var G__33940__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__33940__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__33940 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__33940__2.call(this,self__,item);
case 3:
return G__33940__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__33940.cljs$core$IFn$_invoke$arity$2 = G__33940__2;
G__33940.cljs$core$IFn$_invoke$arity$3 = G__33940__3;
return G__33940;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args33877){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args33877)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33914(s__33915){
return (new cljs.core.LazySeq(null,(function (){
var s__33915__$1 = s__33915;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33915__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33920 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33920,(0),null);
var item_set = cljs.core.nth.call(null,vec__33920,(1),null);
var iterys__4525__auto__ = ((function (s__33915__$1,vec__33920,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__33914_$_iter__33916(s__33917){
return (new cljs.core.LazySeq(null,((function (s__33915__$1,vec__33920,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__33917__$1 = s__33917;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33917__$1);
if(temp__5735__auto____$1){
var s__33917__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33917__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33917__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33919 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33918 = (0);
while(true){
if((i__33918 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33918);
cljs.core.chunk_append.call(null,b__33919,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__33941 = (i__33918 + (1));
i__33918 = G__33941;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33919),tailrecursion$priority_map$iter__33914_$_iter__33916.call(null,cljs.core.chunk_rest.call(null,s__33917__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33919),null);
}
} else {
var item = cljs.core.first.call(null,s__33917__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__33914_$_iter__33916.call(null,cljs.core.rest.call(null,s__33917__$2)));
}
} else {
return null;
}
break;
}
});})(s__33915__$1,vec__33920,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__33915__$1,vec__33920,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33914.call(null,cljs.core.rest.call(null,s__33915__$1)));
} else {
var G__33942 = cljs.core.rest.call(null,s__33915__$1);
s__33915__$1 = G__33942;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__33923(s__33924){
return (new cljs.core.LazySeq(null,(function (){
var s__33924__$1 = s__33924;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__33924__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__33929 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__33929,(0),null);
var item_set = cljs.core.nth.call(null,vec__33929,(1),null);
var iterys__4525__auto__ = ((function (s__33924__$1,vec__33929,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__33923_$_iter__33925(s__33926){
return (new cljs.core.LazySeq(null,((function (s__33924__$1,vec__33929,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__33926__$1 = s__33926;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__33926__$1);
if(temp__5735__auto____$1){
var s__33926__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33926__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__33926__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__33928 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__33927 = (0);
while(true){
if((i__33927 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__33927);
cljs.core.chunk_append.call(null,b__33928,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__33943 = (i__33927 + (1));
i__33927 = G__33943;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33928),tailrecursion$priority_map$iter__33923_$_iter__33925.call(null,cljs.core.chunk_rest.call(null,s__33926__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33928),null);
}
} else {
var item = cljs.core.first.call(null,s__33926__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__33923_$_iter__33925.call(null,cljs.core.rest.call(null,s__33926__$2)));
}
} else {
return null;
}
break;
}
});})(s__33924__$1,vec__33929,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__33924__$1,vec__33929,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__33923.call(null,cljs.core.rest.call(null,s__33924__$1)));
} else {
var G__33944 = cljs.core.rest.call(null,s__33924__$1);
s__33924__$1 = G__33944;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__33946 = arguments.length;
switch (G__33946) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33949 = arguments.length;
var i__4737__auto___33950 = (0);
while(true){
if((i__4737__auto___33950 < len__4736__auto___33949)){
args__4742__auto__.push((arguments[i__4737__auto___33950]));

var G__33951 = (i__4737__auto___33950 + (1));
i__4737__auto___33950 = G__33951;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__33952 = cljs.core.nnext.call(null,in$);
var G__33953 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__33952;
out = G__33953;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq33948){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33948));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33956 = arguments.length;
var i__4737__auto___33957 = (0);
while(true){
if((i__4737__auto___33957 < len__4736__auto___33956)){
args__4742__auto__.push((arguments[i__4737__auto___33957]));

var G__33958 = (i__4737__auto___33957 + (1));
i__4737__auto___33957 = G__33958;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__33959 = cljs.core.nnext.call(null,in$);
var G__33960 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__33959;
out = G__33960;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq33954){
var G__33955 = cljs.core.first.call(null,seq33954);
var seq33954__$1 = cljs.core.next.call(null,seq33954);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33955,seq33954__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33963 = arguments.length;
var i__4737__auto___33964 = (0);
while(true){
if((i__4737__auto___33964 < len__4736__auto___33963)){
args__4742__auto__.push((arguments[i__4737__auto___33964]));

var G__33965 = (i__4737__auto___33964 + (1));
i__4737__auto___33964 = G__33965;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__33966 = cljs.core.nnext.call(null,in$);
var G__33967 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__33966;
out = G__33967;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq33961){
var G__33962 = cljs.core.first.call(null,seq33961);
var seq33961__$1 = cljs.core.next.call(null,seq33961);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33962,seq33961__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33971 = arguments.length;
var i__4737__auto___33972 = (0);
while(true){
if((i__4737__auto___33972 < len__4736__auto___33971)){
args__4742__auto__.push((arguments[i__4737__auto___33972]));

var G__33973 = (i__4737__auto___33972 + (1));
i__4737__auto___33972 = G__33973;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__33974 = cljs.core.nnext.call(null,in$);
var G__33975 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__33974;
out = G__33975;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq33968){
var G__33969 = cljs.core.first.call(null,seq33968);
var seq33968__$1 = cljs.core.next.call(null,seq33968);
var G__33970 = cljs.core.first.call(null,seq33968__$1);
var seq33968__$2 = cljs.core.next.call(null,seq33968__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33969,G__33970,seq33968__$2);
}));


//# sourceMappingURL=priority_map.js.map
