// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__37156 = (line + (1));
var G__37157 = (1);
var G__37158 = (counter + (1));
line = G__37156;
col = G__37157;
counter = G__37158;
continue;
} else {
var G__37159 = line;
var G__37160 = (col + (1));
var G__37161 = (counter + (1));
line = G__37159;
col = G__37160;
counter = G__37161;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__37162 = cljs.core.next.call(null,chars);
var G__37163 = (n__$1 - (1));
chars = G__37162;
n__$1 = G__37163;
continue;
} else {
var G__37164 = cljs.core.next.call(null,chars);
var G__37165 = n__$1;
chars = G__37164;
n__$1 = G__37165;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__37166){
var map__37167 = p__37166;
var map__37167__$1 = (((((!((map__37167 == null))))?(((((map__37167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37167.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37167):map__37167);
var line = cljs.core.get.call(null,map__37167__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__37167__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__37167__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__37167__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__37169_37177 = cljs.core.seq.call(null,full_reasons);
var chunk__37170_37178 = null;
var count__37171_37179 = (0);
var i__37172_37180 = (0);
while(true){
if((i__37172_37180 < count__37171_37179)){
var r_37181 = cljs.core._nth.call(null,chunk__37170_37178,i__37172_37180);
instaparse.failure.print_reason.call(null,r_37181);

cljs.core.println.call(null," (followed by end-of-string)");


var G__37182 = seq__37169_37177;
var G__37183 = chunk__37170_37178;
var G__37184 = count__37171_37179;
var G__37185 = (i__37172_37180 + (1));
seq__37169_37177 = G__37182;
chunk__37170_37178 = G__37183;
count__37171_37179 = G__37184;
i__37172_37180 = G__37185;
continue;
} else {
var temp__5735__auto___37186 = cljs.core.seq.call(null,seq__37169_37177);
if(temp__5735__auto___37186){
var seq__37169_37187__$1 = temp__5735__auto___37186;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37169_37187__$1)){
var c__4556__auto___37188 = cljs.core.chunk_first.call(null,seq__37169_37187__$1);
var G__37189 = cljs.core.chunk_rest.call(null,seq__37169_37187__$1);
var G__37190 = c__4556__auto___37188;
var G__37191 = cljs.core.count.call(null,c__4556__auto___37188);
var G__37192 = (0);
seq__37169_37177 = G__37189;
chunk__37170_37178 = G__37190;
count__37171_37179 = G__37191;
i__37172_37180 = G__37192;
continue;
} else {
var r_37193 = cljs.core.first.call(null,seq__37169_37187__$1);
instaparse.failure.print_reason.call(null,r_37193);

cljs.core.println.call(null," (followed by end-of-string)");


var G__37194 = cljs.core.next.call(null,seq__37169_37187__$1);
var G__37195 = null;
var G__37196 = (0);
var G__37197 = (0);
seq__37169_37177 = G__37194;
chunk__37170_37178 = G__37195;
count__37171_37179 = G__37196;
i__37172_37180 = G__37197;
continue;
}
} else {
}
}
break;
}

var seq__37173 = cljs.core.seq.call(null,partial_reasons);
var chunk__37174 = null;
var count__37175 = (0);
var i__37176 = (0);
while(true){
if((i__37176 < count__37175)){
var r = cljs.core._nth.call(null,chunk__37174,i__37176);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__37198 = seq__37173;
var G__37199 = chunk__37174;
var G__37200 = count__37175;
var G__37201 = (i__37176 + (1));
seq__37173 = G__37198;
chunk__37174 = G__37199;
count__37175 = G__37200;
i__37176 = G__37201;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__37173);
if(temp__5735__auto__){
var seq__37173__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37173__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__37173__$1);
var G__37202 = cljs.core.chunk_rest.call(null,seq__37173__$1);
var G__37203 = c__4556__auto__;
var G__37204 = cljs.core.count.call(null,c__4556__auto__);
var G__37205 = (0);
seq__37173 = G__37202;
chunk__37174 = G__37203;
count__37175 = G__37204;
i__37176 = G__37205;
continue;
} else {
var r = cljs.core.first.call(null,seq__37173__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__37206 = cljs.core.next.call(null,seq__37173__$1);
var G__37207 = null;
var G__37208 = (0);
var G__37209 = (0);
seq__37173 = G__37206;
chunk__37174 = G__37207;
count__37175 = G__37208;
i__37176 = G__37209;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=failure.js.map
