// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.string.format');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
var st_65617 = cljs.js.empty_state.call(null);
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_65617,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs.app_state !== 'undefined')){
} else {
flureenjs.app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v0.15.0"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)));
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.set_logging = (function flureenjs$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__65618 = opts_SINGLEQUOTE_;
var map__65618__$1 = (((((!((map__65618 == null))))?(((((map__65618.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65618.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65618):map__65618);
var level = cljs.core.get.call(null,map__65618__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.set_logging', flureenjs.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var G__65621 = arguments.length;
switch (G__65621) {
case 1:
return flureenjs.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureenjs.connect.call(null,servers_string,null);
}));

(flureenjs.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect.call(null,servers_string,opts_SINGLEQUOTE_);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect_p = (function flureenjs$connect_p(var_args){
var G__65624 = arguments.length;
switch (G__65624) {
case 1:
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.connect_p', flureenjs.connect_p);

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureenjs.connect_p.call(null,servers_string,null);
}));

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,opts_SINGLEQUOTE_);
}));

(flureenjs.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 */
flureenjs.password_generate = (function flureenjs$password_generate(var_args){
var G__65627 = arguments.length;
switch (G__65627) {
case 4:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_generate', flureenjs.password_generate);

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.password_generate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
var data = cljs.core.assoc.call(null,opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureenjs.password_login = (function flureenjs$password_login(var_args){
var G__65630 = arguments.length;
switch (G__65630) {
case 4:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_login', flureenjs.password_login);

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renew_token = (function flureenjs$renew_token(var_args){
var G__65633 = arguments.length;
switch (G__65633) {
case 2:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renew_token', flureenjs.renew_token);

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.close_listener = (function flureenjs$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.close_listener', flureenjs.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65642 = arguments.length;
var i__4737__auto___65643 = (0);
while(true){
if((i__4737__auto___65643 < len__4736__auto___65642)){
args__4742__auto__.push((arguments[i__4737__auto___65643]));

var G__65644 = (i__4737__auto___65643 + (1));
i__4737__auto___65643 = G__65644;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__65638){
var vec__65639 = p__65638;
var opts = cljs.core.nth.call(null,vec__65639,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return flureenjs.db_instance.call(null,conn,ledger,opts__$1);
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq65635){
var G__65636 = cljs.core.first.call(null,seq65635);
var seq65635__$1 = cljs.core.next.call(null,seq65635);
var G__65637 = cljs.core.first.call(null,seq65635__$1);
var seq65635__$2 = cljs.core.next.call(null,seq65635__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65636,G__65637,seq65635__$2);
}));

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_instance = (function flureenjs$db_instance(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65794 = arguments.length;
var i__4737__auto___65795 = (0);
while(true){
if((i__4737__auto___65795 < len__4736__auto___65794)){
args__4742__auto__.push((arguments[i__4737__auto___65795]));

var G__65796 = (i__4737__auto___65795 + (1));
i__4737__auto___65795 = G__65796;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__65648){
var vec__65649 = p__65648;
var opts = cljs.core.nth.call(null,vec__65649,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2476__auto___65797 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_65739){
var state_val_65740 = (state_65739[(1)]);
if((state_val_65740 === (7))){
var state_65739__$1 = state_65739;
var statearr_65741_65798 = state_65739__$1;
(statearr_65741_65798[(2)] = false);

(statearr_65741_65798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (20))){
var state_65739__$1 = state_65739;
var statearr_65742_65799 = state_65739__$1;
(statearr_65742_65799[(2)] = null);

(statearr_65742_65799[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (27))){
var inst_65699 = (state_65739[(7)]);
var state_65739__$1 = state_65739;
var statearr_65743_65800 = state_65739__$1;
(statearr_65743_65800[(2)] = inst_65699);

(statearr_65743_65800[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (1))){
var state_65739__$1 = state_65739;
var statearr_65744_65801 = state_65739__$1;
(statearr_65744_65801[(2)] = null);

(statearr_65744_65801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (24))){
var state_65739__$1 = state_65739;
var statearr_65745_65802 = state_65739__$1;
(statearr_65745_65802[(2)] = null);

(statearr_65745_65802[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (4))){
var inst_65652 = (state_65739[(2)]);
var inst_65653 = fluree.db.util.log.error.call(null,inst_65652);
var inst_65654 = cljs.core.async.put_BANG_.call(null,pc,inst_65652);
var inst_65655 = cljs.core.async.close_BANG_.call(null,pc);
var state_65739__$1 = (function (){var statearr_65746 = state_65739;
(statearr_65746[(8)] = inst_65653);

(statearr_65746[(9)] = inst_65654);

return statearr_65746;
})();
var statearr_65747_65803 = state_65739__$1;
(statearr_65747_65803[(2)] = inst_65655);

(statearr_65747_65803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (15))){
var inst_65694 = (state_65739[(10)]);
var inst_65687 = (state_65739[(11)]);
var inst_65693 = (state_65739[(12)]);
var inst_65697 = (state_65739[(2)]);
var inst_65698 = fluree.db.util.async.throw_err.call(null,inst_65697);
var inst_65699 = cljs.core.assoc.call(null,inst_65698,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_65693,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_65694);
var state_65739__$1 = (function (){var statearr_65748 = state_65739;
(statearr_65748[(7)] = inst_65699);

return statearr_65748;
})();
if(cljs.core.truth_(inst_65687)){
var statearr_65749_65804 = state_65739__$1;
(statearr_65749_65804[(1)] = (16));

} else {
var statearr_65750_65805 = state_65739__$1;
(statearr_65750_65805[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (21))){
var inst_65709 = (state_65739[(2)]);
var state_65739__$1 = state_65739;
var statearr_65751_65806 = state_65739__$1;
(statearr_65751_65806[(2)] = inst_65709);

(statearr_65751_65806[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (31))){
var inst_65725 = (state_65739[(13)]);
var state_65739__$1 = state_65739;
var statearr_65752_65807 = state_65739__$1;
(statearr_65752_65807[(2)] = inst_65725);

(statearr_65752_65807[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (32))){
var inst_65733 = (state_65739[(2)]);
var inst_65734 = cljs.core.async.put_BANG_.call(null,pc,inst_65733);
var _ = (function (){var statearr_65753 = state_65739;
(statearr_65753[(4)] = cljs.core.rest.call(null,(state_65739[(4)])));

return statearr_65753;
})();
var state_65739__$1 = state_65739;
var statearr_65754_65808 = state_65739__$1;
(statearr_65754_65808[(2)] = inst_65734);

(statearr_65754_65808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (33))){
var inst_65725 = (state_65739[(13)]);
var inst_65728 = (state_65739[(2)]);
var inst_65729 = fluree.db.util.async.throw_err.call(null,inst_65728);
var inst_65730 = cljs.core.assoc.call(null,inst_65725,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65729);
var state_65739__$1 = state_65739;
var statearr_65755_65809 = state_65739__$1;
(statearr_65755_65809[(2)] = inst_65730);

(statearr_65755_65809[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (13))){
var inst_65665 = (state_65739[(14)]);
var state_65739__$1 = state_65739;
var statearr_65756_65810 = state_65739__$1;
(statearr_65756_65810[(2)] = inst_65665);

(statearr_65756_65810[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (22))){
var inst_65705 = (state_65739[(2)]);
var inst_65706 = fluree.db.util.async.throw_err.call(null,inst_65705);
var state_65739__$1 = state_65739;
var statearr_65757_65811 = state_65739__$1;
(statearr_65757_65811[(2)] = inst_65706);

(statearr_65757_65811[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (29))){
var inst_65721 = (state_65739[(2)]);
var inst_65722 = fluree.db.util.async.throw_err.call(null,inst_65721);
var state_65739__$1 = state_65739;
var statearr_65758_65812 = state_65739__$1;
(statearr_65758_65812[(2)] = inst_65722);

(statearr_65758_65812[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (6))){
var inst_65665 = (state_65739[(14)]);
var inst_65670 = inst_65665.cljs$lang$protocol_mask$partition0$;
var inst_65671 = (inst_65670 & (64));
var inst_65672 = inst_65665.cljs$core$ISeq$;
var inst_65673 = (cljs.core.PROTOCOL_SENTINEL === inst_65672);
var inst_65674 = ((inst_65671) || (inst_65673));
var state_65739__$1 = state_65739;
if(cljs.core.truth_(inst_65674)){
var statearr_65759_65813 = state_65739__$1;
(statearr_65759_65813[(1)] = (9));

} else {
var statearr_65760_65814 = state_65739__$1;
(statearr_65760_65814[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (28))){
var inst_65711 = (state_65739[(15)]);
var inst_65725 = (state_65739[(2)]);
var state_65739__$1 = (function (){var statearr_65761 = state_65739;
(statearr_65761[(13)] = inst_65725);

return statearr_65761;
})();
if(cljs.core.truth_(inst_65711)){
var statearr_65762_65815 = state_65739__$1;
(statearr_65762_65815[(1)] = (30));

} else {
var statearr_65763_65816 = state_65739__$1;
(statearr_65763_65816[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (25))){
var inst_65690 = (state_65739[(16)]);
var inst_65716 = (state_65739[(2)]);
var state_65739__$1 = (function (){var statearr_65764 = state_65739;
(statearr_65764[(17)] = inst_65716);

return statearr_65764;
})();
if(cljs.core.truth_(inst_65690)){
var statearr_65765_65817 = state_65739__$1;
(statearr_65765_65817[(1)] = (26));

} else {
var statearr_65766_65818 = state_65739__$1;
(statearr_65766_65818[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (17))){
var inst_65689 = (state_65739[(18)]);
var state_65739__$1 = state_65739;
if(cljs.core.truth_(inst_65689)){
var statearr_65767_65819 = state_65739__$1;
(statearr_65767_65819[(1)] = (19));

} else {
var statearr_65768_65820 = state_65739__$1;
(statearr_65768_65820[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (3))){
var inst_65737 = (state_65739[(2)]);
var state_65739__$1 = state_65739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65739__$1,inst_65737);
} else {
if((state_val_65740 === (12))){
var inst_65665 = (state_65739[(14)]);
var inst_65683 = cljs.core.apply.call(null,cljs.core.hash_map,inst_65665);
var state_65739__$1 = state_65739;
var statearr_65769_65821 = state_65739__$1;
(statearr_65769_65821[(2)] = inst_65683);

(statearr_65769_65821[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (2))){
var inst_65665 = (state_65739[(14)]);
var _ = (function (){var statearr_65770 = state_65739;
(statearr_65770[(4)] = cljs.core.cons.call(null,(5),(state_65739[(4)])));

return statearr_65770;
})();
var inst_65665__$1 = opts;
var inst_65667 = (inst_65665__$1 == null);
var inst_65668 = cljs.core.not.call(null,inst_65667);
var state_65739__$1 = (function (){var statearr_65771 = state_65739;
(statearr_65771[(14)] = inst_65665__$1);

return statearr_65771;
})();
if(inst_65668){
var statearr_65772_65822 = state_65739__$1;
(statearr_65772_65822[(1)] = (6));

} else {
var statearr_65773_65823 = state_65739__$1;
(statearr_65773_65823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (23))){
var inst_65711 = (state_65739[(15)]);
var inst_65699 = (state_65739[(7)]);
var inst_65713 = fluree.db.permissions.permission_map.call(null,inst_65699,inst_65711,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65739__$1 = state_65739;
var statearr_65774_65824 = state_65739__$1;
(statearr_65774_65824[(2)] = inst_65713);

(statearr_65774_65824[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (19))){
var inst_65689 = (state_65739[(18)]);
var inst_65699 = (state_65739[(7)]);
var inst_65703 = fluree.db.auth.roles.call(null,inst_65699,inst_65689);
var state_65739__$1 = state_65739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65739__$1,(22),inst_65703);
} else {
if((state_val_65740 === (11))){
var inst_65678 = (state_65739[(2)]);
var state_65739__$1 = state_65739;
var statearr_65776_65825 = state_65739__$1;
(statearr_65776_65825[(2)] = inst_65678);

(statearr_65776_65825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (9))){
var state_65739__$1 = state_65739;
var statearr_65777_65826 = state_65739__$1;
(statearr_65777_65826[(2)] = true);

(statearr_65777_65826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (5))){
var _ = (function (){var statearr_65778 = state_65739;
(statearr_65778[(4)] = cljs.core.rest.call(null,(state_65739[(4)])));

return statearr_65778;
})();
var state_65739__$1 = state_65739;
var ex65775 = (state_65739__$1[(2)]);
var statearr_65779_65827 = state_65739__$1;
(statearr_65779_65827[(5)] = ex65775);


var statearr_65780_65828 = state_65739__$1;
(statearr_65780_65828[(1)] = (4));

(statearr_65780_65828[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (14))){
var inst_65686 = (state_65739[(2)]);
var inst_65687 = cljs.core.get.call(null,inst_65686,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_65688 = cljs.core.get.call(null,inst_65686,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_65689 = cljs.core.get.call(null,inst_65686,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65690 = cljs.core.get.call(null,inst_65686,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65691 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_65692 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_65693 = cljs.core.nth.call(null,inst_65692,(0),null);
var inst_65694 = cljs.core.nth.call(null,inst_65692,(1),null);
var inst_65695 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_65739__$1 = (function (){var statearr_65781 = state_65739;
(statearr_65781[(10)] = inst_65694);

(statearr_65781[(18)] = inst_65689);

(statearr_65781[(16)] = inst_65690);

(statearr_65781[(19)] = inst_65688);

(statearr_65781[(11)] = inst_65687);

(statearr_65781[(20)] = inst_65691);

(statearr_65781[(12)] = inst_65693);

return statearr_65781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65739__$1,(15),inst_65695);
} else {
if((state_val_65740 === (26))){
var inst_65699 = (state_65739[(7)]);
var inst_65718 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65719 = fluree.db.time_travel.as_of_block.call(null,inst_65699,inst_65718);
var state_65739__$1 = state_65739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65739__$1,(29),inst_65719);
} else {
if((state_val_65740 === (16))){
var inst_65687 = (state_65739[(11)]);
var state_65739__$1 = state_65739;
var statearr_65782_65829 = state_65739__$1;
(statearr_65782_65829[(2)] = inst_65687);

(statearr_65782_65829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (30))){
var inst_65716 = (state_65739[(17)]);
var state_65739__$1 = state_65739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65739__$1,(33),inst_65716);
} else {
if((state_val_65740 === (10))){
var state_65739__$1 = state_65739;
var statearr_65783_65830 = state_65739__$1;
(statearr_65783_65830[(2)] = false);

(statearr_65783_65830[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (18))){
var inst_65711 = (state_65739[(15)]);
var inst_65711__$1 = (state_65739[(2)]);
var state_65739__$1 = (function (){var statearr_65784 = state_65739;
(statearr_65784[(15)] = inst_65711__$1);

return statearr_65784;
})();
if(cljs.core.truth_(inst_65711__$1)){
var statearr_65785_65831 = state_65739__$1;
(statearr_65785_65831[(1)] = (23));

} else {
var statearr_65786_65832 = state_65739__$1;
(statearr_65786_65832[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65740 === (8))){
var inst_65681 = (state_65739[(2)]);
var state_65739__$1 = state_65739;
if(cljs.core.truth_(inst_65681)){
var statearr_65787_65833 = state_65739__$1;
(statearr_65787_65833[(1)] = (12));

} else {
var statearr_65788_65834 = state_65739__$1;
(statearr_65788_65834[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_65789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65789[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_65789[(1)] = (1));

return statearr_65789;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_65739){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_65739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e65790){var ex__2457__auto__ = e65790;
var statearr_65791_65835 = state_65739;
(statearr_65791_65835[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_65739[(4)]))){
var statearr_65792_65836 = state_65739;
(statearr_65792_65836[(1)] = cljs.core.first.call(null,(state_65739[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65837 = state_65739;
state_65739 = G__65837;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_65739){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_65739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_65793 = f__2477__auto__.call(null);
(statearr_65793[(6)] = c__2476__auto___65797);

return statearr_65793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return pc;
}));

(flureenjs.db_instance.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db_instance.cljs$lang$applyTo = (function (seq65645){
var G__65646 = cljs.core.first.call(null,seq65645);
var seq65645__$1 = cljs.core.next.call(null,seq65645);
var G__65647 = cljs.core.first.call(null,seq65645__$1);
var seq65645__$2 = cljs.core.next.call(null,seq65645__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65646,G__65647,seq65645__$2);
}));

/**
 * Returns db's schema map.
 */
flureenjs.db_schema = (function flureenjs$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_65856){
var state_val_65857 = (state_65856[(1)]);
if((state_val_65857 === (1))){
var state_65856__$1 = state_65856;
var statearr_65858_65873 = state_65856__$1;
(statearr_65858_65873[(2)] = null);

(statearr_65858_65873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65857 === (2))){
var _ = (function (){var statearr_65859 = state_65856;
(statearr_65859[(4)] = cljs.core.cons.call(null,(5),(state_65856[(4)])));

return statearr_65859;
})();
var state_65856__$1 = state_65856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65856__$1,(6),db);
} else {
if((state_val_65857 === (3))){
var inst_65854 = (state_65856[(2)]);
var state_65856__$1 = state_65856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65856__$1,inst_65854);
} else {
if((state_val_65857 === (4))){
var inst_65838 = (state_65856[(2)]);
var inst_65839 = fluree.db.util.log.error.call(null,inst_65838);
var inst_65840 = reject.call(null,inst_65838);
var state_65856__$1 = (function (){var statearr_65861 = state_65856;
(statearr_65861[(7)] = inst_65839);

return statearr_65861;
})();
var statearr_65862_65874 = state_65856__$1;
(statearr_65862_65874[(2)] = inst_65840);

(statearr_65862_65874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65857 === (5))){
var _ = (function (){var statearr_65863 = state_65856;
(statearr_65863[(4)] = cljs.core.rest.call(null,(state_65856[(4)])));

return statearr_65863;
})();
var state_65856__$1 = state_65856;
var ex65860 = (state_65856__$1[(2)]);
var statearr_65864_65875 = state_65856__$1;
(statearr_65864_65875[(5)] = ex65860);


var statearr_65865_65876 = state_65856__$1;
(statearr_65865_65876[(1)] = (4));

(statearr_65865_65876[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65857 === (6))){
var inst_65847 = (state_65856[(2)]);
var inst_65848 = fluree.db.util.async.throw_err.call(null,inst_65847);
var inst_65849 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_65848);
var inst_65850 = cljs.core.clj__GT_js.call(null,inst_65849);
var inst_65851 = resolve.call(null,inst_65850);
var _ = (function (){var statearr_65866 = state_65856;
(statearr_65866[(4)] = cljs.core.rest.call(null,(state_65856[(4)])));

return statearr_65866;
})();
var state_65856__$1 = state_65856;
var statearr_65867_65877 = state_65856__$1;
(statearr_65867_65877[(2)] = inst_65851);

(statearr_65867_65877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$db_schema_$_state_machine__2454__auto__ = null;
var flureenjs$db_schema_$_state_machine__2454__auto____0 = (function (){
var statearr_65868 = [null,null,null,null,null,null,null,null];
(statearr_65868[(0)] = flureenjs$db_schema_$_state_machine__2454__auto__);

(statearr_65868[(1)] = (1));

return statearr_65868;
});
var flureenjs$db_schema_$_state_machine__2454__auto____1 = (function (state_65856){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_65856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e65869){var ex__2457__auto__ = e65869;
var statearr_65870_65878 = state_65856;
(statearr_65870_65878[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_65856[(4)]))){
var statearr_65871_65879 = state_65856;
(statearr_65871_65879[(1)] = cljs.core.first.call(null,(state_65856[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65880 = state_65856;
state_65856 = G__65880;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$db_schema_$_state_machine__2454__auto__ = function(state_65856){
switch(arguments.length){
case 0:
return flureenjs$db_schema_$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$db_schema_$_state_machine__2454__auto____1.call(this,state_65856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$db_schema_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$db_schema_$_state_machine__2454__auto____0;
flureenjs$db_schema_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$db_schema_$_state_machine__2454__auto____1;
return flureenjs$db_schema_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_65872 = f__2477__auto__.call(null);
(statearr_65872[(6)] = c__2476__auto__);

return statearr_65872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
goog.exportSymbol('flureenjs.db_schema', flureenjs.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.delete_ledger = (function flureenjs$delete_ledger(var_args){
var G__65882 = arguments.length;
switch (G__65882) {
case 2:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.delete_ledger', flureenjs.delete_ledger);

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.delete_ledger.call(null,conn,ledger,null);
}));

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_65972){
var state_val_65973 = (state_65972[(1)]);
if((state_val_65973 === (7))){
var inst_65895 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_65972__$1 = state_65972;
var statearr_65974_66032 = state_65972__$1;
(statearr_65974_66032[(2)] = inst_65895);

(statearr_65974_66032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (20))){
var inst_65921 = (state_65972[(7)]);
var inst_65928 = (state_65972[(2)]);
var state_65972__$1 = (function (){var statearr_65975 = state_65972;
(statearr_65975[(8)] = inst_65928);

return statearr_65975;
})();
if(cljs.core.truth_(inst_65921)){
var statearr_65976_66033 = state_65972__$1;
(statearr_65976_66033[(1)] = (21));

} else {
var statearr_65977_66034 = state_65972__$1;
(statearr_65977_66034[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (27))){
var inst_65923 = (state_65972[(9)]);
var inst_65942 = (state_65972[(10)]);
var inst_65944 = fluree.crypto.sign_message.call(null,inst_65942,inst_65923);
var state_65972__$1 = state_65972;
var statearr_65978_66035 = state_65972__$1;
(statearr_65978_66035[(2)] = inst_65944);

(statearr_65978_66035[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (1))){
var state_65972__$1 = state_65972;
var statearr_65979_66036 = state_65972__$1;
(statearr_65979_66036[(2)] = null);

(statearr_65979_66036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (24))){
var inst_65936 = (state_65972[(11)]);
var inst_65938 = fluree.db.util.core.without_nils.call(null,inst_65936);
var inst_65939 = fluree.db.util.json.stringify.call(null,inst_65938);
var state_65972__$1 = state_65972;
var statearr_65980_66037 = state_65972__$1;
(statearr_65980_66037[(2)] = inst_65939);

(statearr_65980_66037[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (4))){
var inst_65883 = (state_65972[(2)]);
var inst_65884 = fluree.db.util.log.error.call(null,inst_65883);
var inst_65885 = reject.call(null,inst_65883);
var state_65972__$1 = (function (){var statearr_65981 = state_65972;
(statearr_65981[(12)] = inst_65884);

return statearr_65981;
})();
var statearr_65982_66038 = state_65972__$1;
(statearr_65982_66038[(2)] = inst_65885);

(statearr_65982_66038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (15))){
var inst_65897 = (state_65972[(13)]);
var inst_65916 = cljs.core.apply.call(null,cljs.core.hash_map,inst_65897);
var state_65972__$1 = state_65972;
var statearr_65983_66039 = state_65972__$1;
(statearr_65983_66039[(2)] = inst_65916);

(statearr_65983_66039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (21))){
var inst_65921 = (state_65972[(7)]);
var state_65972__$1 = state_65972;
var statearr_65984_66040 = state_65972__$1;
(statearr_65984_66040[(2)] = inst_65921);

(statearr_65984_66040[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (31))){
var inst_65936 = (state_65972[(11)]);
var inst_65957 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_65936);
var state_65972__$1 = state_65972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65972__$1,(34),inst_65957);
} else {
if((state_val_65973 === (32))){
var inst_65962 = (state_65972[(2)]);
var inst_65963 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65964 = [(200),inst_65962];
var inst_65965 = cljs.core.PersistentHashMap.fromArrays(inst_65963,inst_65964);
var inst_65966 = cljs.core.clj__GT_js.call(null,inst_65965);
var inst_65967 = resolve.call(null,inst_65966);
var _ = (function (){var statearr_65985 = state_65972;
(statearr_65985[(4)] = cljs.core.rest.call(null,(state_65972[(4)])));

return statearr_65985;
})();
var state_65972__$1 = state_65972;
var statearr_65986_66041 = state_65972__$1;
(statearr_65986_66041[(2)] = inst_65967);

(statearr_65986_66041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (33))){
var inst_65954 = (state_65972[(2)]);
var inst_65955 = fluree.db.util.async.throw_err.call(null,inst_65954);
var state_65972__$1 = state_65972;
var statearr_65987_66042 = state_65972__$1;
(statearr_65987_66042[(2)] = inst_65955);

(statearr_65987_66042[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (13))){
var state_65972__$1 = state_65972;
var statearr_65988_66043 = state_65972__$1;
(statearr_65988_66043[(2)] = false);

(statearr_65988_66043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (22))){
var inst_65924 = (state_65972[(14)]);
var inst_65931 = (inst_65924 + (30000));
var state_65972__$1 = state_65972;
var statearr_65989_66044 = state_65972__$1;
(statearr_65989_66044[(2)] = inst_65931);

(statearr_65989_66044[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (29))){
var inst_65923 = (state_65972[(9)]);
var inst_65947 = (state_65972[(2)]);
var state_65972__$1 = (function (){var statearr_65990 = state_65972;
(statearr_65990[(15)] = inst_65947);

return statearr_65990;
})();
if(cljs.core.truth_(inst_65923)){
var statearr_65991_66045 = state_65972__$1;
(statearr_65991_66045[(1)] = (30));

} else {
var statearr_65992_66046 = state_65972__$1;
(statearr_65992_66046[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (6))){
var state_65972__$1 = state_65972;
var statearr_65993_66047 = state_65972__$1;
(statearr_65993_66047[(2)] = null);

(statearr_65993_66047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (28))){
var state_65972__$1 = state_65972;
var statearr_65994_66048 = state_65972__$1;
(statearr_65994_66048[(2)] = null);

(statearr_65994_66048[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (25))){
var state_65972__$1 = state_65972;
var statearr_65995_66049 = state_65972__$1;
(statearr_65995_66049[(2)] = null);

(statearr_65995_66049[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (34))){
var inst_65959 = (state_65972[(2)]);
var inst_65960 = fluree.db.util.async.throw_err.call(null,inst_65959);
var state_65972__$1 = state_65972;
var statearr_65996_66050 = state_65972__$1;
(statearr_65996_66050[(2)] = inst_65960);

(statearr_65996_66050[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (17))){
var inst_65920 = (state_65972[(16)]);
var inst_65919 = (state_65972[(2)]);
var inst_65920__$1 = cljs.core.get.call(null,inst_65919,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65921 = cljs.core.get.call(null,inst_65919,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65922 = cljs.core.get.call(null,inst_65919,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65923 = cljs.core.get.call(null,inst_65919,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65924 = fluree.db.util.core.current_time_millis.call(null);
var state_65972__$1 = (function (){var statearr_65997 = state_65972;
(statearr_65997[(14)] = inst_65924);

(statearr_65997[(16)] = inst_65920__$1);

(statearr_65997[(9)] = inst_65923);

(statearr_65997[(7)] = inst_65921);

(statearr_65997[(17)] = inst_65922);

return statearr_65997;
})();
if(cljs.core.truth_(inst_65920__$1)){
var statearr_65998_66051 = state_65972__$1;
(statearr_65998_66051[(1)] = (18));

} else {
var statearr_65999_66052 = state_65972__$1;
(statearr_65999_66052[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (3))){
var inst_65970 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65972__$1,inst_65970);
} else {
if((state_val_65973 === (12))){
var state_65972__$1 = state_65972;
var statearr_66000_66053 = state_65972__$1;
(statearr_66000_66053[(2)] = true);

(statearr_66000_66053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (2))){
var _ = (function (){var statearr_66001 = state_65972;
(statearr_66001[(4)] = cljs.core.cons.call(null,(5),(state_65972[(4)])));

return statearr_66001;
})();
var inst_65892 = (opts == null);
var state_65972__$1 = state_65972;
if(cljs.core.truth_(inst_65892)){
var statearr_66002_66054 = state_65972__$1;
(statearr_66002_66054[(1)] = (6));

} else {
var statearr_66003_66055 = state_65972__$1;
(statearr_66003_66055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (23))){
var inst_65928 = (state_65972[(8)]);
var inst_65923 = (state_65972[(9)]);
var inst_65933 = (state_65972[(2)]);
var inst_65934 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_65935 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_65928,inst_65933];
var inst_65936 = cljs.core.PersistentHashMap.fromArrays(inst_65934,inst_65935);
var state_65972__$1 = (function (){var statearr_66004 = state_65972;
(statearr_66004[(11)] = inst_65936);

return statearr_66004;
})();
if(cljs.core.truth_(inst_65923)){
var statearr_66005_66056 = state_65972__$1;
(statearr_66005_66056[(1)] = (24));

} else {
var statearr_66006_66057 = state_65972__$1;
(statearr_66006_66057[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (19))){
var inst_65924 = (state_65972[(14)]);
var state_65972__$1 = state_65972;
var statearr_66007_66058 = state_65972__$1;
(statearr_66007_66058[(2)] = inst_65924);

(statearr_66007_66058[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (11))){
var inst_65914 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
if(cljs.core.truth_(inst_65914)){
var statearr_66009_66059 = state_65972__$1;
(statearr_66009_66059[(1)] = (15));

} else {
var statearr_66010_66060 = state_65972__$1;
(statearr_66010_66060[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (9))){
var inst_65897 = (state_65972[(13)]);
var inst_65903 = inst_65897.cljs$lang$protocol_mask$partition0$;
var inst_65904 = (inst_65903 & (64));
var inst_65905 = inst_65897.cljs$core$ISeq$;
var inst_65906 = (cljs.core.PROTOCOL_SENTINEL === inst_65905);
var inst_65907 = ((inst_65904) || (inst_65906));
var state_65972__$1 = state_65972;
if(cljs.core.truth_(inst_65907)){
var statearr_66011_66061 = state_65972__$1;
(statearr_66011_66061[(1)] = (12));

} else {
var statearr_66012_66062 = state_65972__$1;
(statearr_66012_66062[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (5))){
var _ = (function (){var statearr_66013 = state_65972;
(statearr_66013[(4)] = cljs.core.rest.call(null,(state_65972[(4)])));

return statearr_66013;
})();
var state_65972__$1 = state_65972;
var ex66008 = (state_65972__$1[(2)]);
var statearr_66014_66063 = state_65972__$1;
(statearr_66014_66063[(5)] = ex66008);


var statearr_66015_66064 = state_65972__$1;
(statearr_66015_66064[(1)] = (4));

(statearr_66015_66064[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (14))){
var inst_65911 = (state_65972[(2)]);
var state_65972__$1 = state_65972;
var statearr_66016_66065 = state_65972__$1;
(statearr_66016_66065[(2)] = inst_65911);

(statearr_66016_66065[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (26))){
var inst_65923 = (state_65972[(9)]);
var inst_65942 = (state_65972[(2)]);
var state_65972__$1 = (function (){var statearr_66017 = state_65972;
(statearr_66017[(10)] = inst_65942);

return statearr_66017;
})();
if(cljs.core.truth_(inst_65923)){
var statearr_66018_66066 = state_65972__$1;
(statearr_66018_66066[(1)] = (27));

} else {
var statearr_66019_66067 = state_65972__$1;
(statearr_66019_66067[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (16))){
var inst_65897 = (state_65972[(13)]);
var state_65972__$1 = state_65972;
var statearr_66020_66068 = state_65972__$1;
(statearr_66020_66068[(2)] = inst_65897);

(statearr_66020_66068[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (30))){
var inst_65947 = (state_65972[(15)]);
var inst_65942 = (state_65972[(10)]);
var inst_65949 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65950 = [inst_65942,inst_65947];
var inst_65951 = cljs.core.PersistentHashMap.fromArrays(inst_65949,inst_65950);
var inst_65952 = fluree.db.operations.command_async.call(null,conn,inst_65951);
var state_65972__$1 = state_65972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65972__$1,(33),inst_65952);
} else {
if((state_val_65973 === (10))){
var state_65972__$1 = state_65972;
var statearr_66021_66069 = state_65972__$1;
(statearr_66021_66069[(2)] = false);

(statearr_66021_66069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (18))){
var inst_65920 = (state_65972[(16)]);
var state_65972__$1 = state_65972;
var statearr_66022_66070 = state_65972__$1;
(statearr_66022_66070[(2)] = inst_65920);

(statearr_66022_66070[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65973 === (8))){
var inst_65897 = (state_65972[(13)]);
var inst_65897__$1 = (state_65972[(2)]);
var inst_65898 = fluree.db.connection_js.check_connection.call(null,conn,inst_65897__$1);
var inst_65900 = (inst_65897__$1 == null);
var inst_65901 = cljs.core.not.call(null,inst_65900);
var state_65972__$1 = (function (){var statearr_66023 = state_65972;
(statearr_66023[(13)] = inst_65897__$1);

(statearr_66023[(18)] = inst_65898);

return statearr_66023;
})();
if(inst_65901){
var statearr_66024_66071 = state_65972__$1;
(statearr_66024_66071[(1)] = (9));

} else {
var statearr_66025_66072 = state_65972__$1;
(statearr_66025_66072[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66026 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66026[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66026[(1)] = (1));

return statearr_66026;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_65972){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_65972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66027){var ex__2457__auto__ = e66027;
var statearr_66028_66073 = state_65972;
(statearr_66028_66073[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_65972[(4)]))){
var statearr_66029_66074 = state_65972;
(statearr_66029_66074[(1)] = cljs.core.first.call(null,(state_65972[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66075 = state_65972;
state_65972 = G__66075;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_65972){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_65972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66030 = f__2477__auto__.call(null);
(statearr_66030[(6)] = c__2476__auto__);

return statearr_66030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's  with ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_stats = (function flureenjs$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66094){
var state_val_66095 = (state_66094[(1)]);
if((state_val_66095 === (1))){
var state_66094__$1 = state_66094;
var statearr_66096_66111 = state_66094__$1;
(statearr_66096_66111[(2)] = null);

(statearr_66096_66111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66095 === (2))){
var _ = (function (){var statearr_66097 = state_66094;
(statearr_66097[(4)] = cljs.core.cons.call(null,(5),(state_66094[(4)])));

return statearr_66097;
})();
var inst_66084 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_66094__$1 = state_66094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66094__$1,(6),inst_66084);
} else {
if((state_val_66095 === (3))){
var inst_66092 = (state_66094[(2)]);
var state_66094__$1 = state_66094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66094__$1,inst_66092);
} else {
if((state_val_66095 === (4))){
var inst_66076 = (state_66094[(2)]);
var inst_66077 = fluree.db.util.log.error.call(null,inst_66076);
var inst_66078 = reject.call(null,inst_66076);
var state_66094__$1 = (function (){var statearr_66099 = state_66094;
(statearr_66099[(7)] = inst_66077);

return statearr_66099;
})();
var statearr_66100_66112 = state_66094__$1;
(statearr_66100_66112[(2)] = inst_66078);

(statearr_66100_66112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66095 === (5))){
var _ = (function (){var statearr_66101 = state_66094;
(statearr_66101[(4)] = cljs.core.rest.call(null,(state_66094[(4)])));

return statearr_66101;
})();
var state_66094__$1 = state_66094;
var ex66098 = (state_66094__$1[(2)]);
var statearr_66102_66113 = state_66094__$1;
(statearr_66102_66113[(5)] = ex66098);


var statearr_66103_66114 = state_66094__$1;
(statearr_66103_66114[(1)] = (4));

(statearr_66103_66114[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66095 === (6))){
var inst_66086 = (state_66094[(2)]);
var inst_66087 = fluree.db.util.async.throw_err.call(null,inst_66086);
var inst_66088 = cljs.core.clj__GT_js.call(null,inst_66087);
var inst_66089 = resolve.call(null,inst_66088);
var _ = (function (){var statearr_66104 = state_66094;
(statearr_66104[(4)] = cljs.core.rest.call(null,(state_66094[(4)])));

return statearr_66104;
})();
var state_66094__$1 = state_66094;
var statearr_66105_66115 = state_66094__$1;
(statearr_66105_66115[(2)] = inst_66089);

(statearr_66105_66115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_stats_$_state_machine__2454__auto__ = null;
var flureenjs$ledger_stats_$_state_machine__2454__auto____0 = (function (){
var statearr_66106 = [null,null,null,null,null,null,null,null];
(statearr_66106[(0)] = flureenjs$ledger_stats_$_state_machine__2454__auto__);

(statearr_66106[(1)] = (1));

return statearr_66106;
});
var flureenjs$ledger_stats_$_state_machine__2454__auto____1 = (function (state_66094){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66107){var ex__2457__auto__ = e66107;
var statearr_66108_66116 = state_66094;
(statearr_66108_66116[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66094[(4)]))){
var statearr_66109_66117 = state_66094;
(statearr_66109_66117[(1)] = cljs.core.first.call(null,(state_66094[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66118 = state_66094;
state_66094 = G__66118;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$ledger_stats_$_state_machine__2454__auto__ = function(state_66094){
switch(arguments.length){
case 0:
return flureenjs$ledger_stats_$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$ledger_stats_$_state_machine__2454__auto____1.call(this,state_66094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_stats_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_stats_$_state_machine__2454__auto____0;
flureenjs$ledger_stats_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_stats_$_state_machine__2454__auto____1;
return flureenjs$ledger_stats_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66110 = f__2477__auto__.call(null);
(statearr_66110[(6)] = c__2476__auto__);

return statearr_66110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_stats', flureenjs.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.new_ledger = (function flureenjs$new_ledger(var_args){
var G__66120 = arguments.length;
switch (G__66120) {
case 2:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.new_ledger', flureenjs.new_ledger);

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.new_ledger.call(null,conn,ledger,null);
}));

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66258){
var state_val_66259 = (state_66258[(1)]);
if((state_val_66259 === (7))){
var inst_66143 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66258__$1 = state_66258;
var statearr_66260_66338 = state_66258__$1;
(statearr_66260_66338[(2)] = inst_66143);

(statearr_66260_66338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (20))){
var inst_66182 = (state_66258[(7)]);
var inst_66179 = (state_66258[(8)]);
var inst_66189 = (state_66258[(9)]);
var inst_66189__$1 = (state_66258[(2)]);
var inst_66190 = fluree.db.graphdb.validate_ledger_name.call(null,inst_66189__$1,"ledger");
var inst_66191 = fluree.db.graphdb.validate_ledger_name.call(null,inst_66182,"network");
var state_66258__$1 = (function (){var statearr_66261 = state_66258;
(statearr_66261[(10)] = inst_66191);

(statearr_66261[(9)] = inst_66189__$1);

(statearr_66261[(11)] = inst_66190);

return statearr_66261;
})();
if(cljs.core.truth_(inst_66179)){
var statearr_66262_66339 = state_66258__$1;
(statearr_66262_66339[(1)] = (21));

} else {
var statearr_66263_66340 = state_66258__$1;
(statearr_66263_66340[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (27))){
var inst_66198 = (state_66258[(12)]);
var inst_66197 = (state_66258[(13)]);
var inst_66205 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66197),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66198)].join('');
var state_66258__$1 = state_66258;
var statearr_66264_66341 = state_66258__$1;
(statearr_66264_66341[(2)] = inst_66205);

(statearr_66264_66341[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (1))){
var state_66258__$1 = state_66258;
var statearr_66265_66342 = state_66258__$1;
(statearr_66265_66342[(2)] = null);

(statearr_66265_66342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (24))){
var inst_66198 = (state_66258[(12)]);
var inst_66200 = fluree.db.graphdb.validate_ledger_name.call(null,inst_66198,"alias");
var state_66258__$1 = state_66258;
var statearr_66266_66343 = state_66258__$1;
(statearr_66266_66343[(2)] = inst_66200);

(statearr_66266_66343[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (39))){
var inst_66172 = (state_66258[(14)]);
var inst_66228 = (state_66258[(15)]);
var inst_66230 = fluree.crypto.sign_message.call(null,inst_66228,inst_66172);
var state_66258__$1 = state_66258;
var statearr_66267_66344 = state_66258__$1;
(statearr_66267_66344[(2)] = inst_66230);

(statearr_66267_66344[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (46))){
var inst_66245 = (state_66258[(2)]);
var inst_66246 = fluree.db.util.async.throw_err.call(null,inst_66245);
var state_66258__$1 = state_66258;
var statearr_66268_66345 = state_66258__$1;
(statearr_66268_66345[(2)] = inst_66246);

(statearr_66268_66345[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (4))){
var inst_66121 = (state_66258[(2)]);
var inst_66122 = fluree.db.util.log.error.call(null,inst_66121);
var inst_66123 = cljs.core.ex_data.call(null,inst_66121);
var inst_66124 = cljs.core.ex_message.call(null,inst_66121);
var inst_66125 = cljs.core.assoc.call(null,inst_66123,new cljs.core.Keyword(null,"message","message",-406056002),inst_66124);
var inst_66126 = cljs.core.clj__GT_js.call(null,inst_66125);
var inst_66127 = reject.call(null,inst_66126);
var state_66258__$1 = (function (){var statearr_66269 = state_66258;
(statearr_66269[(16)] = inst_66122);

return statearr_66269;
})();
var statearr_66270_66346 = state_66258__$1;
(statearr_66270_66346[(2)] = inst_66127);

(statearr_66270_66346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (15))){
var inst_66145 = (state_66258[(17)]);
var inst_66164 = cljs.core.apply.call(null,cljs.core.hash_map,inst_66145);
var state_66258__$1 = state_66258;
var statearr_66271_66347 = state_66258__$1;
(statearr_66271_66347[(2)] = inst_66164);

(statearr_66271_66347[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (21))){
var inst_66193 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_66258__$1 = state_66258;
var statearr_66272_66348 = state_66258__$1;
(statearr_66272_66348[(2)] = inst_66193);

(statearr_66272_66348[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (31))){
var inst_66209 = (state_66258[(18)]);
var state_66258__$1 = state_66258;
var statearr_66273_66349 = state_66258__$1;
(statearr_66273_66349[(2)] = inst_66209);

(statearr_66273_66349[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (32))){
var inst_66176 = (state_66258[(19)]);
var inst_66213 = (state_66258[(2)]);
var state_66258__$1 = (function (){var statearr_66274 = state_66258;
(statearr_66274[(20)] = inst_66213);

return statearr_66274;
})();
if(cljs.core.truth_(inst_66176)){
var statearr_66275_66350 = state_66258__$1;
(statearr_66275_66350[(1)] = (33));

} else {
var statearr_66276_66351 = state_66258__$1;
(statearr_66276_66351[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (40))){
var state_66258__$1 = state_66258;
var statearr_66277_66352 = state_66258__$1;
(statearr_66277_66352[(2)] = null);

(statearr_66277_66352[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (33))){
var inst_66176 = (state_66258[(19)]);
var state_66258__$1 = state_66258;
var statearr_66278_66353 = state_66258__$1;
(statearr_66278_66353[(2)] = inst_66176);

(statearr_66278_66353[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (13))){
var state_66258__$1 = state_66258;
var statearr_66279_66354 = state_66258__$1;
(statearr_66279_66354[(2)] = false);

(statearr_66279_66354[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (22))){
var state_66258__$1 = state_66258;
var statearr_66280_66355 = state_66258__$1;
(statearr_66280_66355[(2)] = null);

(statearr_66280_66355[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (36))){
var inst_66222 = (state_66258[(21)]);
var inst_66224 = fluree.db.util.core.without_nils.call(null,inst_66222);
var inst_66225 = fluree.db.util.json.stringify.call(null,inst_66224);
var state_66258__$1 = state_66258;
var statearr_66281_66356 = state_66258__$1;
(statearr_66281_66356[(2)] = inst_66225);

(statearr_66281_66356[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (41))){
var inst_66172 = (state_66258[(14)]);
var inst_66233 = (state_66258[(2)]);
var state_66258__$1 = (function (){var statearr_66282 = state_66258;
(statearr_66282[(22)] = inst_66233);

return statearr_66282;
})();
if(cljs.core.truth_(inst_66172)){
var statearr_66283_66357 = state_66258__$1;
(statearr_66283_66357[(1)] = (42));

} else {
var statearr_66284_66358 = state_66258__$1;
(statearr_66284_66358[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (43))){
var inst_66222 = (state_66258[(21)]);
var inst_66243 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_66222);
var state_66258__$1 = state_66258;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66258__$1,(46),inst_66243);
} else {
if((state_val_66259 === (29))){
var inst_66170 = (state_66258[(23)]);
var inst_66208 = (state_66258[(2)]);
var inst_66209 = fluree.db.util.core.current_time_millis.call(null);
var state_66258__$1 = (function (){var statearr_66285 = state_66258;
(statearr_66285[(18)] = inst_66209);

(statearr_66285[(24)] = inst_66208);

return statearr_66285;
})();
if(cljs.core.truth_(inst_66170)){
var statearr_66286_66359 = state_66258__$1;
(statearr_66286_66359[(1)] = (30));

} else {
var statearr_66287_66360 = state_66258__$1;
(statearr_66287_66360[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (44))){
var inst_66248 = (state_66258[(2)]);
var inst_66249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66250 = [(200),inst_66248];
var inst_66251 = cljs.core.PersistentHashMap.fromArrays(inst_66249,inst_66250);
var inst_66252 = cljs.core.clj__GT_js.call(null,inst_66251);
var inst_66253 = resolve.call(null,inst_66252);
var _ = (function (){var statearr_66288 = state_66258;
(statearr_66288[(4)] = cljs.core.rest.call(null,(state_66258[(4)])));

return statearr_66288;
})();
var state_66258__$1 = state_66258;
var statearr_66289_66361 = state_66258__$1;
(statearr_66289_66361[(2)] = inst_66253);

(statearr_66289_66361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (6))){
var state_66258__$1 = state_66258;
var statearr_66290_66362 = state_66258__$1;
(statearr_66290_66362[(2)] = null);

(statearr_66290_66362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (28))){
var state_66258__$1 = state_66258;
var statearr_66291_66363 = state_66258__$1;
(statearr_66291_66363[(2)] = null);

(statearr_66291_66363[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (25))){
var state_66258__$1 = state_66258;
var statearr_66292_66364 = state_66258__$1;
(statearr_66292_66364[(2)] = null);

(statearr_66292_66364[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (34))){
var inst_66209 = (state_66258[(18)]);
var inst_66216 = (inst_66209 + (30000));
var state_66258__$1 = state_66258;
var statearr_66293_66365 = state_66258__$1;
(statearr_66293_66365[(2)] = inst_66216);

(statearr_66293_66365[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (17))){
var inst_66183 = (state_66258[(25)]);
var inst_66167 = (state_66258[(2)]);
var inst_66168 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66169 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_66170 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66171 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_66172 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66173 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_66174 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_66175 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_66176 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66177 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66178 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_66179 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_66180 = cljs.core.get.call(null,inst_66167,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_66181 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_66182 = cljs.core.nth.call(null,inst_66181,(0),null);
var inst_66183__$1 = cljs.core.nth.call(null,inst_66181,(1),null);
var inst_66184 = clojure.string.starts_with_QMARK_.call(null,inst_66183__$1,"$");
var state_66258__$1 = (function (){var statearr_66294 = state_66258;
(statearr_66294[(14)] = inst_66172);

(statearr_66294[(26)] = inst_66174);

(statearr_66294[(27)] = inst_66168);

(statearr_66294[(25)] = inst_66183__$1);

(statearr_66294[(28)] = inst_66177);

(statearr_66294[(7)] = inst_66182);

(statearr_66294[(29)] = inst_66173);

(statearr_66294[(8)] = inst_66179);

(statearr_66294[(30)] = inst_66178);

(statearr_66294[(31)] = inst_66171);

(statearr_66294[(32)] = inst_66180);

(statearr_66294[(23)] = inst_66170);

(statearr_66294[(33)] = inst_66169);

(statearr_66294[(34)] = inst_66175);

(statearr_66294[(19)] = inst_66176);

return statearr_66294;
})();
if(inst_66184){
var statearr_66295_66366 = state_66258__$1;
(statearr_66295_66366[(1)] = (18));

} else {
var statearr_66296_66367 = state_66258__$1;
(statearr_66296_66367[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (3))){
var inst_66256 = (state_66258[(2)]);
var state_66258__$1 = state_66258;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66258__$1,inst_66256);
} else {
if((state_val_66259 === (12))){
var state_66258__$1 = state_66258;
var statearr_66297_66368 = state_66258__$1;
(statearr_66297_66368[(2)] = true);

(statearr_66297_66368[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (2))){
var _ = (function (){var statearr_66298 = state_66258;
(statearr_66298[(4)] = cljs.core.cons.call(null,(5),(state_66258[(4)])));

return statearr_66298;
})();
var inst_66140 = (opts == null);
var state_66258__$1 = state_66258;
if(cljs.core.truth_(inst_66140)){
var statearr_66299_66369 = state_66258__$1;
(statearr_66299_66369[(1)] = (6));

} else {
var statearr_66300_66370 = state_66258__$1;
(statearr_66300_66370[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (23))){
var inst_66179 = (state_66258[(8)]);
var inst_66196 = (state_66258[(2)]);
var inst_66197 = cljs.core.nth.call(null,inst_66196,(0),null);
var inst_66198 = cljs.core.nth.call(null,inst_66196,(1),null);
var state_66258__$1 = (function (){var statearr_66301 = state_66258;
(statearr_66301[(12)] = inst_66198);

(statearr_66301[(13)] = inst_66197);

return statearr_66301;
})();
if(cljs.core.truth_(inst_66179)){
var statearr_66302_66371 = state_66258__$1;
(statearr_66302_66371[(1)] = (24));

} else {
var statearr_66303_66372 = state_66258__$1;
(statearr_66303_66372[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (35))){
var inst_66172 = (state_66258[(14)]);
var inst_66174 = (state_66258[(26)]);
var inst_66177 = (state_66258[(28)]);
var inst_66182 = (state_66258[(7)]);
var inst_66173 = (state_66258[(29)]);
var inst_66178 = (state_66258[(30)]);
var inst_66189 = (state_66258[(9)]);
var inst_66171 = (state_66258[(31)]);
var inst_66180 = (state_66258[(32)]);
var inst_66208 = (state_66258[(24)]);
var inst_66169 = (state_66258[(33)]);
var inst_66175 = (state_66258[(34)]);
var inst_66213 = (state_66258[(20)]);
var inst_66218 = (state_66258[(2)]);
var inst_66219 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_66220 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66182),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66189)].join('');
var inst_66221 = [inst_66174,inst_66175,inst_66220,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_66218,inst_66177,inst_66208,inst_66180,inst_66178,inst_66169,inst_66213,inst_66171,inst_66173];
var inst_66222 = cljs.core.PersistentHashMap.fromArrays(inst_66219,inst_66221);
var state_66258__$1 = (function (){var statearr_66304 = state_66258;
(statearr_66304[(21)] = inst_66222);

return statearr_66304;
})();
if(cljs.core.truth_(inst_66172)){
var statearr_66305_66373 = state_66258__$1;
(statearr_66305_66373[(1)] = (36));

} else {
var statearr_66306_66374 = state_66258__$1;
(statearr_66306_66374[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (19))){
var inst_66183 = (state_66258[(25)]);
var state_66258__$1 = state_66258;
var statearr_66307_66375 = state_66258__$1;
(statearr_66307_66375[(2)] = inst_66183);

(statearr_66307_66375[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (11))){
var inst_66162 = (state_66258[(2)]);
var state_66258__$1 = state_66258;
if(cljs.core.truth_(inst_66162)){
var statearr_66309_66376 = state_66258__$1;
(statearr_66309_66376[(1)] = (15));

} else {
var statearr_66310_66377 = state_66258__$1;
(statearr_66310_66377[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (9))){
var inst_66145 = (state_66258[(17)]);
var inst_66151 = inst_66145.cljs$lang$protocol_mask$partition0$;
var inst_66152 = (inst_66151 & (64));
var inst_66153 = inst_66145.cljs$core$ISeq$;
var inst_66154 = (cljs.core.PROTOCOL_SENTINEL === inst_66153);
var inst_66155 = ((inst_66152) || (inst_66154));
var state_66258__$1 = state_66258;
if(cljs.core.truth_(inst_66155)){
var statearr_66311_66378 = state_66258__$1;
(statearr_66311_66378[(1)] = (12));

} else {
var statearr_66312_66379 = state_66258__$1;
(statearr_66312_66379[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (5))){
var _ = (function (){var statearr_66313 = state_66258;
(statearr_66313[(4)] = cljs.core.rest.call(null,(state_66258[(4)])));

return statearr_66313;
})();
var state_66258__$1 = state_66258;
var ex66308 = (state_66258__$1[(2)]);
var statearr_66314_66380 = state_66258__$1;
(statearr_66314_66380[(5)] = ex66308);


var statearr_66315_66381 = state_66258__$1;
(statearr_66315_66381[(1)] = (4));

(statearr_66315_66381[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (14))){
var inst_66159 = (state_66258[(2)]);
var state_66258__$1 = state_66258;
var statearr_66316_66382 = state_66258__$1;
(statearr_66316_66382[(2)] = inst_66159);

(statearr_66316_66382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (45))){
var inst_66240 = (state_66258[(2)]);
var inst_66241 = fluree.db.util.async.throw_err.call(null,inst_66240);
var state_66258__$1 = state_66258;
var statearr_66317_66383 = state_66258__$1;
(statearr_66317_66383[(2)] = inst_66241);

(statearr_66317_66383[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (26))){
var inst_66179 = (state_66258[(8)]);
var inst_66203 = (state_66258[(2)]);
var state_66258__$1 = (function (){var statearr_66318 = state_66258;
(statearr_66318[(35)] = inst_66203);

return statearr_66318;
})();
if(cljs.core.truth_(inst_66179)){
var statearr_66319_66384 = state_66258__$1;
(statearr_66319_66384[(1)] = (27));

} else {
var statearr_66320_66385 = state_66258__$1;
(statearr_66320_66385[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (16))){
var inst_66145 = (state_66258[(17)]);
var state_66258__$1 = state_66258;
var statearr_66321_66386 = state_66258__$1;
(statearr_66321_66386[(2)] = inst_66145);

(statearr_66321_66386[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (38))){
var inst_66172 = (state_66258[(14)]);
var inst_66228 = (state_66258[(2)]);
var state_66258__$1 = (function (){var statearr_66322 = state_66258;
(statearr_66322[(15)] = inst_66228);

return statearr_66322;
})();
if(cljs.core.truth_(inst_66172)){
var statearr_66323_66387 = state_66258__$1;
(statearr_66323_66387[(1)] = (39));

} else {
var statearr_66324_66388 = state_66258__$1;
(statearr_66324_66388[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (30))){
var inst_66170 = (state_66258[(23)]);
var state_66258__$1 = state_66258;
var statearr_66325_66389 = state_66258__$1;
(statearr_66325_66389[(2)] = inst_66170);

(statearr_66325_66389[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (10))){
var state_66258__$1 = state_66258;
var statearr_66326_66390 = state_66258__$1;
(statearr_66326_66390[(2)] = false);

(statearr_66326_66390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (18))){
var inst_66183 = (state_66258[(25)]);
var inst_66186 = cljs.core.subs.call(null,inst_66183,(1));
var state_66258__$1 = state_66258;
var statearr_66327_66391 = state_66258__$1;
(statearr_66327_66391[(2)] = inst_66186);

(statearr_66327_66391[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (42))){
var inst_66228 = (state_66258[(15)]);
var inst_66233 = (state_66258[(22)]);
var inst_66235 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66236 = [inst_66228,inst_66233];
var inst_66237 = cljs.core.PersistentHashMap.fromArrays(inst_66235,inst_66236);
var inst_66238 = fluree.db.operations.command_async.call(null,conn,inst_66237);
var state_66258__$1 = state_66258;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66258__$1,(45),inst_66238);
} else {
if((state_val_66259 === (37))){
var state_66258__$1 = state_66258;
var statearr_66328_66392 = state_66258__$1;
(statearr_66328_66392[(2)] = null);

(statearr_66328_66392[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66259 === (8))){
var inst_66145 = (state_66258[(17)]);
var inst_66145__$1 = (state_66258[(2)]);
var inst_66146 = fluree.db.connection_js.check_connection.call(null,conn,inst_66145__$1);
var inst_66148 = (inst_66145__$1 == null);
var inst_66149 = cljs.core.not.call(null,inst_66148);
var state_66258__$1 = (function (){var statearr_66329 = state_66258;
(statearr_66329[(17)] = inst_66145__$1);

(statearr_66329[(36)] = inst_66146);

return statearr_66329;
})();
if(inst_66149){
var statearr_66330_66393 = state_66258__$1;
(statearr_66330_66393[(1)] = (9));

} else {
var statearr_66331_66394 = state_66258__$1;
(statearr_66331_66394[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66332 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66332[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66332[(1)] = (1));

return statearr_66332;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_66258){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66333){var ex__2457__auto__ = e66333;
var statearr_66334_66395 = state_66258;
(statearr_66334_66395[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66258[(4)]))){
var statearr_66335_66396 = state_66258;
(statearr_66335_66396[(1)] = cljs.core.first.call(null,(state_66258[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66397 = state_66258;
state_66258 = G__66397;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_66258){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_66258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66336 = f__2477__auto__.call(null);
(statearr_66336[(6)] = c__2476__auto__);

return statearr_66336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitor_tx = (function flureenjs$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66417){
var state_val_66418 = (state_66417[(1)]);
if((state_val_66418 === (1))){
var state_66417__$1 = state_66417;
var statearr_66419_66435 = state_66417__$1;
(statearr_66419_66435[(2)] = null);

(statearr_66419_66435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66418 === (2))){
var _ = (function (){var statearr_66420 = state_66417;
(statearr_66420[(4)] = cljs.core.cons.call(null,(5),(state_66417[(4)])));

return statearr_66420;
})();
var inst_66407 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_66408 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_66417__$1 = (function (){var statearr_66421 = state_66417;
(statearr_66421[(7)] = inst_66407);

return statearr_66421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66417__$1,(6),inst_66408);
} else {
if((state_val_66418 === (3))){
var inst_66415 = (state_66417[(2)]);
var state_66417__$1 = state_66417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66417__$1,inst_66415);
} else {
if((state_val_66418 === (4))){
var inst_66398 = (state_66417[(2)]);
var inst_66399 = fluree.db.util.log.error.call(null,inst_66398);
var inst_66400 = cljs.core.clj__GT_js.call(null,inst_66398);
var inst_66401 = reject.call(null,inst_66400);
var state_66417__$1 = (function (){var statearr_66423 = state_66417;
(statearr_66423[(8)] = inst_66399);

return statearr_66423;
})();
var statearr_66424_66436 = state_66417__$1;
(statearr_66424_66436[(2)] = inst_66401);

(statearr_66424_66436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66418 === (5))){
var _ = (function (){var statearr_66425 = state_66417;
(statearr_66425[(4)] = cljs.core.rest.call(null,(state_66417[(4)])));

return statearr_66425;
})();
var state_66417__$1 = state_66417;
var ex66422 = (state_66417__$1[(2)]);
var statearr_66426_66437 = state_66417__$1;
(statearr_66426_66437[(5)] = ex66422);


var statearr_66427_66438 = state_66417__$1;
(statearr_66427_66438[(1)] = (4));

(statearr_66427_66438[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66418 === (6))){
var inst_66410 = (state_66417[(2)]);
var inst_66411 = cljs.core.clj__GT_js.call(null,inst_66410);
var inst_66412 = resolve.call(null,inst_66411);
var _ = (function (){var statearr_66428 = state_66417;
(statearr_66428[(4)] = cljs.core.rest.call(null,(state_66417[(4)])));

return statearr_66428;
})();
var state_66417__$1 = state_66417;
var statearr_66429_66439 = state_66417__$1;
(statearr_66429_66439[(2)] = inst_66412);

(statearr_66429_66439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitor_tx_$_state_machine__2454__auto__ = null;
var flureenjs$monitor_tx_$_state_machine__2454__auto____0 = (function (){
var statearr_66430 = [null,null,null,null,null,null,null,null,null];
(statearr_66430[(0)] = flureenjs$monitor_tx_$_state_machine__2454__auto__);

(statearr_66430[(1)] = (1));

return statearr_66430;
});
var flureenjs$monitor_tx_$_state_machine__2454__auto____1 = (function (state_66417){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66431){var ex__2457__auto__ = e66431;
var statearr_66432_66440 = state_66417;
(statearr_66432_66440[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66417[(4)]))){
var statearr_66433_66441 = state_66417;
(statearr_66433_66441[(1)] = cljs.core.first.call(null,(state_66417[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66442 = state_66417;
state_66417 = G__66442;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$monitor_tx_$_state_machine__2454__auto__ = function(state_66417){
switch(arguments.length){
case 0:
return flureenjs$monitor_tx_$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$monitor_tx_$_state_machine__2454__auto____1.call(this,state_66417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitor_tx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitor_tx_$_state_machine__2454__auto____0;
flureenjs$monitor_tx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitor_tx_$_state_machine__2454__auto____1;
return flureenjs$monitor_tx_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66434 = f__2477__auto__.call(null);
(statearr_66434[(6)] = c__2476__auto__);

return statearr_66434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
goog.exportSymbol('flureenjs.monitor_tx', flureenjs.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__66444 = arguments.length;
switch (G__66444) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66470){
var state_val_66471 = (state_66470[(1)]);
if((state_val_66471 === (7))){
var inst_66456 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66470__$1 = state_66470;
var statearr_66472_66493 = state_66470__$1;
(statearr_66472_66493[(2)] = inst_66456);

(statearr_66472_66493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (1))){
var state_66470__$1 = state_66470;
var statearr_66473_66494 = state_66470__$1;
(statearr_66473_66494[(2)] = null);

(statearr_66473_66494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (4))){
var inst_66445 = (state_66470[(2)]);
var inst_66446 = fluree.db.util.log.error.call(null,inst_66445);
var inst_66447 = reject.call(null,inst_66445);
var state_66470__$1 = (function (){var statearr_66474 = state_66470;
(statearr_66474[(7)] = inst_66446);

return statearr_66474;
})();
var statearr_66475_66495 = state_66470__$1;
(statearr_66475_66495[(2)] = inst_66447);

(statearr_66475_66495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (6))){
var state_66470__$1 = state_66470;
var statearr_66476_66496 = state_66470__$1;
(statearr_66476_66496[(2)] = null);

(statearr_66476_66496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (3))){
var inst_66468 = (state_66470[(2)]);
var state_66470__$1 = state_66470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66470__$1,inst_66468);
} else {
if((state_val_66471 === (2))){
var _ = (function (){var statearr_66478 = state_66470;
(statearr_66478[(4)] = cljs.core.cons.call(null,(5),(state_66470[(4)])));

return statearr_66478;
})();
var inst_66453 = (opts == null);
var state_66470__$1 = state_66470;
if(cljs.core.truth_(inst_66453)){
var statearr_66479_66497 = state_66470__$1;
(statearr_66479_66497[(1)] = (6));

} else {
var statearr_66480_66498 = state_66470__$1;
(statearr_66480_66498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (9))){
var inst_66463 = (state_66470[(2)]);
var inst_66464 = cljs.core.clj__GT_js.call(null,inst_66463);
var inst_66465 = resolve.call(null,inst_66464);
var _ = (function (){var statearr_66481 = state_66470;
(statearr_66481[(4)] = cljs.core.rest.call(null,(state_66470[(4)])));

return statearr_66481;
})();
var state_66470__$1 = state_66470;
var statearr_66482_66499 = state_66470__$1;
(statearr_66482_66499[(2)] = inst_66465);

(statearr_66482_66499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (5))){
var _ = (function (){var statearr_66483 = state_66470;
(statearr_66483[(4)] = cljs.core.rest.call(null,(state_66470[(4)])));

return statearr_66483;
})();
var state_66470__$1 = state_66470;
var ex66477 = (state_66470__$1[(2)]);
var statearr_66484_66500 = state_66470__$1;
(statearr_66484_66500[(5)] = ex66477);


var statearr_66485_66501 = state_66470__$1;
(statearr_66485_66501[(1)] = (4));

(statearr_66485_66501[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66471 === (8))){
var inst_66458 = (state_66470[(2)]);
var inst_66459 = fluree.db.connection_js.check_connection.call(null,conn,inst_66458);
var inst_66460 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_66461 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_66460,inst_66458);
var state_66470__$1 = (function (){var statearr_66486 = state_66470;
(statearr_66486[(8)] = inst_66459);

return statearr_66486;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66470__$1,(9),inst_66461);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66487 = [null,null,null,null,null,null,null,null,null];
(statearr_66487[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66487[(1)] = (1));

return statearr_66487;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_66470){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66488){var ex__2457__auto__ = e66488;
var statearr_66489_66502 = state_66470;
(statearr_66489_66502[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66470[(4)]))){
var statearr_66490_66503 = state_66470;
(statearr_66490_66503[(1)] = cljs.core.first.call(null,(state_66470[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66504 = state_66470;
state_66470 = G__66504;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_66470){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_66470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66491 = f__2477__auto__.call(null);
(statearr_66491[(6)] = c__2476__auto__);

return statearr_66491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureenjs.block_range = (function flureenjs$block_range(var_args){
var G__66506 = arguments.length;
switch (G__66506) {
case 3:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range', flureenjs.block_range);

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureenjs.block_range.call(null,conn,ledger,start,start,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureenjs.block_range.call(null,conn,ledger,start,end,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66534){
var state_val_66535 = (state_66534[(1)]);
if((state_val_66535 === (7))){
var inst_66518 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66534__$1 = state_66534;
var statearr_66536_66557 = state_66534__$1;
(statearr_66536_66557[(2)] = inst_66518);

(statearr_66536_66557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (1))){
var state_66534__$1 = state_66534;
var statearr_66537_66558 = state_66534__$1;
(statearr_66537_66558[(2)] = null);

(statearr_66537_66558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (4))){
var inst_66507 = (state_66534[(2)]);
var inst_66508 = fluree.db.util.log.error.call(null,inst_66507);
var inst_66509 = reject.call(null,inst_66507);
var state_66534__$1 = (function (){var statearr_66538 = state_66534;
(statearr_66538[(7)] = inst_66508);

return statearr_66538;
})();
var statearr_66539_66559 = state_66534__$1;
(statearr_66539_66559[(2)] = inst_66509);

(statearr_66539_66559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (6))){
var state_66534__$1 = state_66534;
var statearr_66540_66560 = state_66534__$1;
(statearr_66540_66560[(2)] = null);

(statearr_66540_66560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (3))){
var inst_66532 = (state_66534[(2)]);
var state_66534__$1 = state_66534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66534__$1,inst_66532);
} else {
if((state_val_66535 === (2))){
var _ = (function (){var statearr_66542 = state_66534;
(statearr_66542[(4)] = cljs.core.cons.call(null,(5),(state_66534[(4)])));

return statearr_66542;
})();
var inst_66515 = (opts == null);
var state_66534__$1 = state_66534;
if(cljs.core.truth_(inst_66515)){
var statearr_66543_66561 = state_66534__$1;
(statearr_66543_66561[(1)] = (6));

} else {
var statearr_66544_66562 = state_66534__$1;
(statearr_66544_66562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (9))){
var inst_66520 = (state_66534[(8)]);
var inst_66523 = (state_66534[(2)]);
var inst_66524 = fluree.db.query.block.block_range.call(null,inst_66523,start,end,inst_66520);
var state_66534__$1 = state_66534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66534__$1,(10),inst_66524);
} else {
if((state_val_66535 === (5))){
var _ = (function (){var statearr_66545 = state_66534;
(statearr_66545[(4)] = cljs.core.rest.call(null,(state_66534[(4)])));

return statearr_66545;
})();
var state_66534__$1 = state_66534;
var ex66541 = (state_66534__$1[(2)]);
var statearr_66546_66563 = state_66534__$1;
(statearr_66546_66563[(5)] = ex66541);


var statearr_66547_66564 = state_66534__$1;
(statearr_66547_66564[(1)] = (4));

(statearr_66547_66564[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (10))){
var inst_66526 = (state_66534[(2)]);
var inst_66527 = fluree.db.util.async.throw_err.call(null,inst_66526);
var inst_66528 = cljs.core.clj__GT_js.call(null,inst_66527);
var inst_66529 = resolve.call(null,inst_66528);
var _ = (function (){var statearr_66548 = state_66534;
(statearr_66548[(4)] = cljs.core.rest.call(null,(state_66534[(4)])));

return statearr_66548;
})();
var state_66534__$1 = state_66534;
var statearr_66549_66565 = state_66534__$1;
(statearr_66549_66565[(2)] = inst_66529);

(statearr_66549_66565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (8))){
var inst_66520 = (state_66534[(8)]);
var inst_66520__$1 = (state_66534[(2)]);
var inst_66521 = flureenjs.db_instance.call(null,conn,ledger,inst_66520__$1);
var state_66534__$1 = (function (){var statearr_66550 = state_66534;
(statearr_66550[(8)] = inst_66520__$1);

return statearr_66550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66534__$1,(9),inst_66521);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66551 = [null,null,null,null,null,null,null,null,null];
(statearr_66551[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66551[(1)] = (1));

return statearr_66551;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_66534){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66552){var ex__2457__auto__ = e66552;
var statearr_66553_66566 = state_66534;
(statearr_66553_66566[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66534[(4)]))){
var statearr_66554_66567 = state_66534;
(statearr_66554_66567[(1)] = cljs.core.first.call(null,(state_66534[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66568 = state_66534;
state_66534 = G__66568;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_66534){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_66534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66555 = f__2477__auto__.call(null);
(statearr_66555[(6)] = c__2476__auto__);

return statearr_66555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.block_range_with_txn = (function flureenjs$block_range_with_txn(var_args){
var G__66570 = arguments.length;
switch (G__66570) {
case 3:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range_with_txn', flureenjs.block_range_with_txn);

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.block_range_with_txn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66629){
var state_val_66630 = (state_66629[(1)]);
if((state_val_66630 === (7))){
var inst_66583 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66629__$1 = state_66629;
var statearr_66631_66670 = state_66629__$1;
(statearr_66631_66670[(2)] = inst_66583);

(statearr_66631_66670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (20))){
var inst_66585 = (state_66629[(7)]);
var inst_66612 = (state_66629[(2)]);
var inst_66613 = cljs.core.get.call(null,inst_66612,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_66614 = cljs.core.get.call(null,inst_66612,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_66615 = flureenjs.db_instance.call(null,conn,ledger,inst_66585);
var state_66629__$1 = (function (){var statearr_66632 = state_66629;
(statearr_66632[(8)] = inst_66613);

(statearr_66632[(9)] = inst_66614);

return statearr_66632;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66629__$1,(21),inst_66615);
} else {
if((state_val_66630 === (1))){
var state_66629__$1 = state_66629;
var statearr_66633_66671 = state_66629__$1;
(statearr_66633_66671[(2)] = null);

(statearr_66633_66671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (4))){
var inst_66571 = (state_66629[(2)]);
var inst_66572 = fluree.db.util.log.error.call(null,inst_66571);
var inst_66573 = reject.call(null,inst_66571);
var state_66629__$1 = (function (){var statearr_66634 = state_66629;
(statearr_66634[(10)] = inst_66572);

return statearr_66634;
})();
var statearr_66635_66672 = state_66629__$1;
(statearr_66635_66672[(2)] = inst_66573);

(statearr_66635_66672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (15))){
var state_66629__$1 = state_66629;
var statearr_66636_66673 = state_66629__$1;
(statearr_66636_66673[(2)] = true);

(statearr_66636_66673[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (21))){
var inst_66613 = (state_66629[(8)]);
var inst_66585 = (state_66629[(7)]);
var inst_66614 = (state_66629[(9)]);
var inst_66617 = (state_66629[(2)]);
var inst_66618 = fluree.db.query.block.block_range.call(null,inst_66617,inst_66613,inst_66614,inst_66585);
var state_66629__$1 = state_66629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66629__$1,(22),inst_66618);
} else {
if((state_val_66630 === (13))){
var state_66629__$1 = state_66629;
var statearr_66637_66674 = state_66629__$1;
(statearr_66637_66674[(2)] = false);

(statearr_66637_66674[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (22))){
var inst_66620 = (state_66629[(2)]);
var inst_66621 = fluree.db.util.async.throw_err.call(null,inst_66620);
var inst_66622 = fluree.db.query.range.block_with_tx_data.call(null,inst_66621);
var inst_66623 = cljs.core.clj__GT_js.call(null,inst_66622);
var inst_66624 = resolve.call(null,inst_66623);
var _ = (function (){var statearr_66638 = state_66629;
(statearr_66638[(4)] = cljs.core.rest.call(null,(state_66629[(4)])));

return statearr_66638;
})();
var state_66629__$1 = state_66629;
var statearr_66639_66675 = state_66629__$1;
(statearr_66639_66675[(2)] = inst_66624);

(statearr_66639_66675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (6))){
var state_66629__$1 = state_66629;
var statearr_66640_66676 = state_66629__$1;
(statearr_66640_66676[(2)] = null);

(statearr_66640_66676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (17))){
var inst_66604 = (state_66629[(2)]);
var state_66629__$1 = state_66629;
var statearr_66641_66677 = state_66629__$1;
(statearr_66641_66677[(2)] = inst_66604);

(statearr_66641_66677[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (3))){
var inst_66627 = (state_66629[(2)]);
var state_66629__$1 = state_66629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66629__$1,inst_66627);
} else {
if((state_val_66630 === (12))){
var inst_66591 = (state_66629[(11)]);
var inst_66596 = inst_66591.cljs$lang$protocol_mask$partition0$;
var inst_66597 = (inst_66596 & (64));
var inst_66598 = inst_66591.cljs$core$ISeq$;
var inst_66599 = (cljs.core.PROTOCOL_SENTINEL === inst_66598);
var inst_66600 = ((inst_66597) || (inst_66599));
var state_66629__$1 = state_66629;
if(cljs.core.truth_(inst_66600)){
var statearr_66642_66678 = state_66629__$1;
(statearr_66642_66678[(1)] = (15));

} else {
var statearr_66643_66679 = state_66629__$1;
(statearr_66643_66679[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (2))){
var _ = (function (){var statearr_66644 = state_66629;
(statearr_66644[(4)] = cljs.core.cons.call(null,(5),(state_66629[(4)])));

return statearr_66644;
})();
var inst_66580 = (opts == null);
var state_66629__$1 = state_66629;
if(cljs.core.truth_(inst_66580)){
var statearr_66645_66680 = state_66629__$1;
(statearr_66645_66680[(1)] = (6));

} else {
var statearr_66646_66681 = state_66629__$1;
(statearr_66646_66681[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (19))){
var inst_66591 = (state_66629[(11)]);
var state_66629__$1 = state_66629;
var statearr_66647_66682 = state_66629__$1;
(statearr_66647_66682[(2)] = inst_66591);

(statearr_66647_66682[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (11))){
var inst_66591 = (state_66629[(11)]);
var inst_66591__$1 = (state_66629[(2)]);
var inst_66593 = (inst_66591__$1 == null);
var inst_66594 = cljs.core.not.call(null,inst_66593);
var state_66629__$1 = (function (){var statearr_66649 = state_66629;
(statearr_66649[(11)] = inst_66591__$1);

return statearr_66649;
})();
if(inst_66594){
var statearr_66650_66683 = state_66629__$1;
(statearr_66650_66683[(1)] = (12));

} else {
var statearr_66651_66684 = state_66629__$1;
(statearr_66651_66684[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (9))){
var state_66629__$1 = state_66629;
var statearr_66652_66685 = state_66629__$1;
(statearr_66652_66685[(2)] = null);

(statearr_66652_66685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (5))){
var _ = (function (){var statearr_66653 = state_66629;
(statearr_66653[(4)] = cljs.core.rest.call(null,(state_66629[(4)])));

return statearr_66653;
})();
var state_66629__$1 = state_66629;
var ex66648 = (state_66629__$1[(2)]);
var statearr_66654_66686 = state_66629__$1;
(statearr_66654_66686[(5)] = ex66648);


var statearr_66655_66687 = state_66629__$1;
(statearr_66655_66687[(1)] = (4));

(statearr_66655_66687[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (14))){
var inst_66607 = (state_66629[(2)]);
var state_66629__$1 = state_66629;
if(cljs.core.truth_(inst_66607)){
var statearr_66656_66688 = state_66629__$1;
(statearr_66656_66688[(1)] = (18));

} else {
var statearr_66657_66689 = state_66629__$1;
(statearr_66657_66689[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (16))){
var state_66629__$1 = state_66629;
var statearr_66658_66690 = state_66629__$1;
(statearr_66658_66690[(2)] = false);

(statearr_66658_66690[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (10))){
var inst_66589 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66629__$1 = state_66629;
var statearr_66659_66691 = state_66629__$1;
(statearr_66659_66691[(2)] = inst_66589);

(statearr_66659_66691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (18))){
var inst_66591 = (state_66629[(11)]);
var inst_66609 = cljs.core.apply.call(null,cljs.core.hash_map,inst_66591);
var state_66629__$1 = state_66629;
var statearr_66660_66692 = state_66629__$1;
(statearr_66660_66692[(2)] = inst_66609);

(statearr_66660_66692[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66630 === (8))){
var inst_66585 = (state_66629[(2)]);
var inst_66586 = (block_map == null);
var state_66629__$1 = (function (){var statearr_66661 = state_66629;
(statearr_66661[(7)] = inst_66585);

return statearr_66661;
})();
if(cljs.core.truth_(inst_66586)){
var statearr_66662_66693 = state_66629__$1;
(statearr_66662_66693[(1)] = (9));

} else {
var statearr_66663_66694 = state_66629__$1;
(statearr_66663_66694[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66664 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66664[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66664[(1)] = (1));

return statearr_66664;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_66629){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66665){var ex__2457__auto__ = e66665;
var statearr_66666_66695 = state_66629;
(statearr_66666_66695[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66629[(4)]))){
var statearr_66667_66696 = state_66629;
(statearr_66667_66696[(1)] = cljs.core.first.call(null,(state_66629[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66697 = state_66629;
state_66629 = G__66697;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_66629){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_66629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66668 = f__2477__auto__.call(null);
(statearr_66668[(6)] = c__2476__auto__);

return statearr_66668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureenjs.block_query = (function flureenjs$block_query(var_args){
var G__66699 = arguments.length;
switch (G__66699) {
case 3:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_query', flureenjs.block_query);

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.block_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66766){
var state_val_66767 = (state_66766[(1)]);
if((state_val_66767 === (7))){
var inst_66712 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_66766__$1 = state_66766;
var statearr_66768_66809 = state_66766__$1;
(statearr_66768_66809[(2)] = inst_66712);

(statearr_66768_66809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (20))){
var inst_66708 = (state_66766[(7)]);
var inst_66714 = (state_66766[(8)]);
var inst_66750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66751 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66752 = (new cljs.core.PersistentVector(null,1,(5),inst_66750,inst_66751,null));
var inst_66753 = cljs.core.assoc_in.call(null,inst_66714,inst_66752,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66754 = fluree.db.api_js.signed_query_async.call(null,conn,ledger,inst_66708,inst_66753);
var state_66766__$1 = state_66766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66766__$1,(23),inst_66754);
} else {
if((state_val_66767 === (1))){
var state_66766__$1 = state_66766;
var statearr_66769_66810 = state_66766__$1;
(statearr_66769_66810[(2)] = null);

(statearr_66769_66810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (4))){
var inst_66700 = (state_66766[(2)]);
var inst_66701 = fluree.db.util.log.error.call(null,inst_66700);
var inst_66702 = reject.call(null,inst_66700);
var state_66766__$1 = (function (){var statearr_66770 = state_66766;
(statearr_66770[(9)] = inst_66701);

return statearr_66770;
})();
var statearr_66771_66811 = state_66766__$1;
(statearr_66771_66811[(2)] = inst_66702);

(statearr_66771_66811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (15))){
var inst_66738 = (state_66766[(2)]);
var inst_66739 = fluree.db.util.async.throw_err.call(null,inst_66738);
var state_66766__$1 = state_66766;
var statearr_66772_66812 = state_66766__$1;
(statearr_66772_66812[(2)] = inst_66739);

(statearr_66772_66812[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (21))){
var inst_66759 = (state_66766[(2)]);
var inst_66760 = cljs.core.clj__GT_js.call(null,inst_66759);
var inst_66761 = resolve.call(null,inst_66760);
var _ = (function (){var statearr_66773 = state_66766;
(statearr_66773[(4)] = cljs.core.rest.call(null,(state_66766[(4)])));

return statearr_66773;
})();
var state_66766__$1 = state_66766;
var statearr_66774_66813 = state_66766__$1;
(statearr_66774_66813[(2)] = inst_66761);

(statearr_66774_66813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (13))){
var state_66766__$1 = state_66766;
var statearr_66775_66814 = state_66766__$1;
(statearr_66775_66814[(2)] = null);

(statearr_66775_66814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (22))){
var inst_66747 = (state_66766[(2)]);
var inst_66748 = fluree.db.util.async.throw_err.call(null,inst_66747);
var state_66766__$1 = state_66766;
var statearr_66776_66815 = state_66766__$1;
(statearr_66776_66815[(2)] = inst_66748);

(statearr_66776_66815[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (6))){
var state_66766__$1 = state_66766;
var statearr_66777_66816 = state_66766__$1;
(statearr_66777_66816[(2)] = null);

(statearr_66777_66816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (17))){
var state_66766__$1 = state_66766;
var statearr_66778_66817 = state_66766__$1;
(statearr_66778_66817[(2)] = null);

(statearr_66778_66817[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (3))){
var inst_66764 = (state_66766[(2)]);
var state_66766__$1 = state_66766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66766__$1,inst_66764);
} else {
if((state_val_66767 === (12))){
var inst_66721 = (state_66766[(10)]);
var inst_66726 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_66766__$1 = (function (){var statearr_66779 = state_66766;
(statearr_66779[(11)] = inst_66726);

return statearr_66779;
})();
if(cljs.core.truth_(inst_66721)){
var statearr_66780_66818 = state_66766__$1;
(statearr_66780_66818[(1)] = (16));

} else {
var statearr_66781_66819 = state_66766__$1;
(statearr_66781_66819[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (2))){
var _ = (function (){var statearr_66782 = state_66766;
(statearr_66782[(4)] = cljs.core.cons.call(null,(5),(state_66766[(4)])));

return statearr_66782;
})();
var inst_66708 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_66709 = (opts == null);
var state_66766__$1 = (function (){var statearr_66783 = state_66766;
(statearr_66783[(7)] = inst_66708);

return statearr_66783;
})();
if(cljs.core.truth_(inst_66709)){
var statearr_66784_66820 = state_66766__$1;
(statearr_66784_66820[(1)] = (6));

} else {
var statearr_66785_66821 = state_66766__$1;
(statearr_66785_66821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (23))){
var inst_66756 = (state_66766[(2)]);
var inst_66757 = fluree.db.util.async.throw_err.call(null,inst_66756);
var state_66766__$1 = state_66766;
var statearr_66786_66822 = state_66766__$1;
(statearr_66786_66822[(2)] = inst_66757);

(statearr_66786_66822[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (19))){
var inst_66742 = (state_66766[(12)]);
var inst_66708 = (state_66766[(7)]);
var inst_66714 = (state_66766[(8)]);
var inst_66745 = fluree.db.api_js.block_query_async.call(null,inst_66742,inst_66708,inst_66714);
var state_66766__$1 = state_66766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66766__$1,(22),inst_66745);
} else {
if((state_val_66767 === (11))){
var inst_66714 = (state_66766[(8)]);
var inst_66723 = (state_66766[(13)]);
var inst_66721 = (state_66766[(2)]);
var inst_66722 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_66714);
var inst_66723__$1 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_66714);
var inst_66724 = (inst_66723__$1 == null);
var state_66766__$1 = (function (){var statearr_66788 = state_66766;
(statearr_66788[(14)] = inst_66722);

(statearr_66788[(10)] = inst_66721);

(statearr_66788[(13)] = inst_66723__$1);

return statearr_66788;
})();
if(cljs.core.truth_(inst_66724)){
var statearr_66789_66823 = state_66766__$1;
(statearr_66789_66823[(1)] = (12));

} else {
var statearr_66790_66824 = state_66766__$1;
(statearr_66790_66824[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (9))){
var inst_66716 = (state_66766[(15)]);
var state_66766__$1 = state_66766;
var statearr_66791_66825 = state_66766__$1;
(statearr_66791_66825[(2)] = inst_66716);

(statearr_66791_66825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (5))){
var _ = (function (){var statearr_66792 = state_66766;
(statearr_66792[(4)] = cljs.core.rest.call(null,(state_66766[(4)])));

return statearr_66792;
})();
var state_66766__$1 = state_66766;
var ex66787 = (state_66766__$1[(2)]);
var statearr_66793_66826 = state_66766__$1;
(statearr_66793_66826[(5)] = ex66787);


var statearr_66794_66827 = state_66766__$1;
(statearr_66794_66827[(1)] = (4));

(statearr_66794_66827[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (14))){
var inst_66723 = (state_66766[(13)]);
var inst_66742 = (state_66766[(2)]);
var inst_66743 = (inst_66723 == null);
var state_66766__$1 = (function (){var statearr_66795 = state_66766;
(statearr_66795[(12)] = inst_66742);

return statearr_66795;
})();
if(cljs.core.truth_(inst_66743)){
var statearr_66796_66828 = state_66766__$1;
(statearr_66796_66828[(1)] = (19));

} else {
var statearr_66797_66829 = state_66766__$1;
(statearr_66797_66829[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (16))){
var inst_66721 = (state_66766[(10)]);
var inst_66728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66729 = ["_auth/id",inst_66721];
var inst_66730 = (new cljs.core.PersistentVector(null,2,(5),inst_66728,inst_66729,null));
var state_66766__$1 = state_66766;
var statearr_66798_66830 = state_66766__$1;
(statearr_66798_66830[(2)] = inst_66730);

(statearr_66798_66830[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (10))){
var inst_66714 = (state_66766[(8)]);
var inst_66719 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_66714);
var state_66766__$1 = state_66766;
var statearr_66799_66831 = state_66766__$1;
(statearr_66799_66831[(2)] = inst_66719);

(statearr_66799_66831[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66767 === (18))){
var inst_66722 = (state_66766[(14)]);
var inst_66726 = (state_66766[(11)]);
var inst_66733 = (state_66766[(2)]);
var inst_66734 = [inst_66733,inst_66722];
var inst_66735 = cljs.core.PersistentHashMap.fromArrays(inst_66726,inst_66734);
var inst_66736 = flureenjs.db_instance.call(null,conn,ledger,inst_66735);
var state_66766__$1 = state_66766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66766__$1,(15),inst_66736);
} else {
if((state_val_66767 === (8))){
var inst_66716 = (state_66766[(15)]);
var inst_66714 = (state_66766[(8)]);
var inst_66714__$1 = (state_66766[(2)]);
var inst_66715 = fluree.db.connection_js.check_connection.call(null,conn,inst_66714__$1);
var inst_66716__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_66714__$1);
var state_66766__$1 = (function (){var statearr_66800 = state_66766;
(statearr_66800[(15)] = inst_66716__$1);

(statearr_66800[(16)] = inst_66715);

(statearr_66800[(8)] = inst_66714__$1);

return statearr_66800;
})();
if(cljs.core.truth_(inst_66716__$1)){
var statearr_66801_66832 = state_66766__$1;
(statearr_66801_66832[(1)] = (9));

} else {
var statearr_66802_66833 = state_66766__$1;
(statearr_66802_66833[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_66803 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66803[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_66803[(1)] = (1));

return statearr_66803;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_66766){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66804){var ex__2457__auto__ = e66804;
var statearr_66805_66834 = state_66766;
(statearr_66805_66834[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66766[(4)]))){
var statearr_66806_66835 = state_66766;
(statearr_66806_66835[(1)] = cljs.core.first.call(null,(state_66766[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66836 = state_66766;
state_66766 = G__66836;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_66766){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_66766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66807 = f__2477__auto__.call(null);
(statearr_66807[(6)] = c__2476__auto__);

return statearr_66807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.block_query.cljs$lang$maxFixedArity = 4);

/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A forward-time-travel db can be further forward-time-traveled.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
flureenjs.forward_time_travel = (function flureenjs$forward_time_travel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66852){
var state_val_66853 = (state_66852[(1)]);
if((state_val_66853 === (1))){
var state_66852__$1 = state_66852;
var statearr_66854_66869 = state_66852__$1;
(statearr_66854_66869[(2)] = null);

(statearr_66854_66869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66853 === (2))){
var _ = (function (){var statearr_66855 = state_66852;
(statearr_66855[(4)] = cljs.core.cons.call(null,(5),(state_66852[(4)])));

return statearr_66855;
})();
var inst_66845 = fluree.db.graphdb.forward_time_travel.call(null,db,null,flakes);
var inst_66846 = cljs.core.clj__GT_js.call(null,inst_66845);
var inst_66847 = resolve.call(null,inst_66846);
var ___$1 = (function (){var statearr_66856 = state_66852;
(statearr_66856[(4)] = cljs.core.rest.call(null,(state_66852[(4)])));

return statearr_66856;
})();
var state_66852__$1 = state_66852;
var statearr_66857_66870 = state_66852__$1;
(statearr_66857_66870[(2)] = inst_66847);

(statearr_66857_66870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66853 === (3))){
var inst_66850 = (state_66852[(2)]);
var state_66852__$1 = state_66852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66852__$1,inst_66850);
} else {
if((state_val_66853 === (4))){
var inst_66837 = (state_66852[(2)]);
var inst_66838 = fluree.db.util.log.error.call(null,inst_66837);
var inst_66839 = reject.call(null,inst_66837);
var state_66852__$1 = (function (){var statearr_66859 = state_66852;
(statearr_66859[(7)] = inst_66838);

return statearr_66859;
})();
var statearr_66860_66871 = state_66852__$1;
(statearr_66860_66871[(2)] = inst_66839);

(statearr_66860_66871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66853 === (5))){
var _ = (function (){var statearr_66861 = state_66852;
(statearr_66861[(4)] = cljs.core.rest.call(null,(state_66852[(4)])));

return statearr_66861;
})();
var state_66852__$1 = state_66852;
var ex66858 = (state_66852__$1[(2)]);
var statearr_66862_66872 = state_66852__$1;
(statearr_66862_66872[(5)] = ex66858);


var statearr_66863_66873 = state_66852__$1;
(statearr_66863_66873[(1)] = (4));

(statearr_66863_66873[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_$_state_machine__2454__auto__ = null;
var flureenjs$forward_time_travel_$_state_machine__2454__auto____0 = (function (){
var statearr_66864 = [null,null,null,null,null,null,null,null];
(statearr_66864[(0)] = flureenjs$forward_time_travel_$_state_machine__2454__auto__);

(statearr_66864[(1)] = (1));

return statearr_66864;
});
var flureenjs$forward_time_travel_$_state_machine__2454__auto____1 = (function (state_66852){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66865){var ex__2457__auto__ = e66865;
var statearr_66866_66874 = state_66852;
(statearr_66866_66874[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66852[(4)]))){
var statearr_66867_66875 = state_66852;
(statearr_66867_66875[(1)] = cljs.core.first.call(null,(state_66852[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66876 = state_66852;
state_66852 = G__66876;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$forward_time_travel_$_state_machine__2454__auto__ = function(state_66852){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_$_state_machine__2454__auto____1.call(this,state_66852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_$_state_machine__2454__auto____0;
flureenjs$forward_time_travel_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_$_state_machine__2454__auto____1;
return flureenjs$forward_time_travel_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66868 = f__2477__auto__.call(null);
(statearr_66868[(6)] = c__2476__auto__);

return statearr_66868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.forward_time_travel_db_QMARK_ = (function flureenjs$forward_time_travel_db_QMARK_(db){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_66892){
var state_val_66893 = (state_66892[(1)]);
if((state_val_66893 === (1))){
var state_66892__$1 = state_66892;
var statearr_66894_66909 = state_66892__$1;
(statearr_66894_66909[(2)] = null);

(statearr_66894_66909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (2))){
var _ = (function (){var statearr_66895 = state_66892;
(statearr_66895[(4)] = cljs.core.cons.call(null,(5),(state_66892[(4)])));

return statearr_66895;
})();
var inst_66885 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,db);
var inst_66886 = cljs.core.clj__GT_js.call(null,inst_66885);
var inst_66887 = resolve.call(null,inst_66886);
var ___$1 = (function (){var statearr_66896 = state_66892;
(statearr_66896[(4)] = cljs.core.rest.call(null,(state_66892[(4)])));

return statearr_66896;
})();
var state_66892__$1 = state_66892;
var statearr_66897_66910 = state_66892__$1;
(statearr_66897_66910[(2)] = inst_66887);

(statearr_66897_66910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (3))){
var inst_66890 = (state_66892[(2)]);
var state_66892__$1 = state_66892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66892__$1,inst_66890);
} else {
if((state_val_66893 === (4))){
var inst_66877 = (state_66892[(2)]);
var inst_66878 = fluree.db.util.log.error.call(null,inst_66877);
var inst_66879 = reject.call(null,inst_66877);
var state_66892__$1 = (function (){var statearr_66899 = state_66892;
(statearr_66899[(7)] = inst_66878);

return statearr_66899;
})();
var statearr_66900_66911 = state_66892__$1;
(statearr_66900_66911[(2)] = inst_66879);

(statearr_66900_66911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (5))){
var _ = (function (){var statearr_66901 = state_66892;
(statearr_66901[(4)] = cljs.core.rest.call(null,(state_66892[(4)])));

return statearr_66901;
})();
var state_66892__$1 = state_66892;
var ex66898 = (state_66892__$1[(2)]);
var statearr_66902_66912 = state_66892__$1;
(statearr_66902_66912[(5)] = ex66898);


var statearr_66903_66913 = state_66892__$1;
(statearr_66903_66913[(1)] = (4));

(statearr_66903_66913[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__ = null;
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_66904 = [null,null,null,null,null,null,null,null];
(statearr_66904[(0)] = flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__);

(statearr_66904[(1)] = (1));

return statearr_66904;
});
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____1 = (function (state_66892){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_66892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e66905){var ex__2457__auto__ = e66905;
var statearr_66906_66914 = state_66892;
(statearr_66906_66914[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_66892[(4)]))){
var statearr_66907_66915 = state_66892;
(statearr_66907_66915[(1)] = cljs.core.first.call(null,(state_66892[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66916 = state_66892;
state_66892 = G__66916;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__ = function(state_66892){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____1.call(this,state_66892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____0;
flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto____1;
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_66908 = f__2477__auto__.call(null);
(statearr_66908[(6)] = c__2476__auto__);

return statearr_66908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__66918 = arguments.length;
switch (G__66918) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,db_name,param){
return flureenjs.graphql.call(null,conn,db_name,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,db_name,param,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67041){
var state_val_67042 = (state_67041[(1)]);
if((state_val_67042 === (7))){
var state_67041__$1 = state_67041;
var statearr_67043_67108 = state_67041__$1;
(statearr_67043_67108[(2)] = false);

(statearr_67043_67108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (20))){
var inst_66973 = (state_67041[(7)]);
var state_67041__$1 = state_67041;
var statearr_67044_67109 = state_67041__$1;
(statearr_67044_67109[(2)] = inst_66973);

(statearr_67044_67109[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (27))){
var inst_66973 = (state_67041[(7)]);
var inst_66987 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_66973);
var state_67041__$1 = state_67041;
var statearr_67045_67110 = state_67041__$1;
(statearr_67045_67110[(2)] = inst_66987);

(statearr_67045_67110[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (1))){
var state_67041__$1 = state_67041;
var statearr_67046_67111 = state_67041__$1;
(statearr_67046_67111[(2)] = null);

(statearr_67046_67111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (24))){
var inst_66973 = (state_67041[(7)]);
var inst_66991 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_66973);
var inst_66992 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_66991);
var state_67041__$1 = state_67041;
if(inst_66992){
var statearr_67047_67112 = state_67041__$1;
(statearr_67047_67112[(1)] = (29));

} else {
var statearr_67048_67113 = state_67041__$1;
(statearr_67048_67113[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (39))){
var inst_67026 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67049_67114 = state_67041__$1;
(statearr_67049_67114[(2)] = inst_67026);

(statearr_67049_67114[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (4))){
var inst_66919 = (state_67041[(2)]);
var inst_66920 = fluree.db.util.log.error.call(null,inst_66919);
var inst_66921 = cljs.core.clj__GT_js.call(null,inst_66919);
var inst_66922 = reject.call(null,inst_66921);
var state_67041__$1 = (function (){var statearr_67050 = state_67041;
(statearr_67050[(8)] = inst_66920);

return statearr_67050;
})();
var statearr_67051_67115 = state_67041__$1;
(statearr_67051_67115[(2)] = inst_66922);

(statearr_67051_67115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (15))){
var inst_66932 = (state_67041[(9)]);
var inst_66958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66959 = ["_auth/id",inst_66932];
var inst_66960 = (new cljs.core.PersistentVector(null,2,(5),inst_66958,inst_66959,null));
var state_67041__$1 = state_67041;
var statearr_67052_67116 = state_67041__$1;
(statearr_67052_67116[(2)] = inst_66960);

(statearr_67052_67116[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (21))){
var inst_66973 = (state_67041[(7)]);
var inst_66977 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_66978 = (new cljs.core.PersistentArrayMap(null,2,inst_66977,null));
var inst_66979 = (new cljs.core.PersistentHashSet(null,inst_66978,null));
var inst_66980 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_66973);
var inst_66981 = inst_66979.call(null,inst_66980);
var state_67041__$1 = state_67041;
if(cljs.core.truth_(inst_66981)){
var statearr_67053_67117 = state_67041__$1;
(statearr_67053_67117[(1)] = (23));

} else {
var statearr_67054_67118 = state_67041__$1;
(statearr_67054_67118[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (31))){
var inst_67030 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67055_67119 = state_67041__$1;
(statearr_67055_67119[(2)] = inst_67030);

(statearr_67055_67119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (32))){
var inst_66997 = (state_67041[(2)]);
var inst_66998 = fluree.db.util.async.throw_err.call(null,inst_66997);
var state_67041__$1 = state_67041;
var statearr_67056_67120 = state_67041__$1;
(statearr_67056_67120[(2)] = inst_66998);

(statearr_67056_67120[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (40))){
var inst_67014 = (state_67041[(2)]);
var inst_67015 = fluree.db.util.async.throw_err.call(null,inst_67014);
var state_67041__$1 = state_67041;
var statearr_67057_67121 = state_67041__$1;
(statearr_67057_67121[(2)] = inst_67015);

(statearr_67057_67121[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (33))){
var inst_66969 = (state_67041[(10)]);
var inst_66973 = (state_67041[(7)]);
var inst_66931 = (state_67041[(11)]);
var inst_67003 = cljs.core.dissoc.call(null,inst_66973,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_67004 = fluree.db.api_js.block_query_async.call(null,inst_66969,inst_67003,inst_66931);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(36),inst_67004);
} else {
if((state_val_67042 === (13))){
var inst_66930 = (state_67041[(12)]);
var state_67041__$1 = state_67041;
var statearr_67058_67122 = state_67041__$1;
(statearr_67058_67122[(2)] = inst_66930);

(statearr_67058_67122[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (22))){
var inst_67034 = (state_67041[(2)]);
var inst_67035 = cljs.core.clj__GT_js.call(null,inst_67034);
var inst_67036 = resolve.call(null,inst_67035);
var _ = (function (){var statearr_67059 = state_67041;
(statearr_67059[(4)] = cljs.core.rest.call(null,(state_67041[(4)])));

return statearr_67059;
})();
var state_67041__$1 = state_67041;
var statearr_67060_67123 = state_67041__$1;
(statearr_67060_67123[(2)] = inst_67036);

(statearr_67060_67123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (36))){
var inst_67006 = (state_67041[(2)]);
var inst_67007 = fluree.db.util.async.throw_err.call(null,inst_67006);
var state_67041__$1 = state_67041;
var statearr_67061_67124 = state_67041__$1;
(statearr_67061_67124[(2)] = inst_67007);

(statearr_67061_67124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (41))){
var inst_66973 = (state_67041[(7)]);
var inst_66931 = (state_67041[(11)]);
var inst_66966 = (state_67041[(13)]);
var inst_67018 = fluree.db.api_js.multi_query_async.call(null,inst_66966,inst_66973,inst_66931);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(44),inst_67018);
} else {
if((state_val_67042 === (43))){
var inst_67024 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67062_67125 = state_67041__$1;
(statearr_67062_67125[(2)] = inst_67024);

(statearr_67062_67125[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (29))){
var inst_66969 = (state_67041[(10)]);
var inst_66973 = (state_67041[(7)]);
var inst_66931 = (state_67041[(11)]);
var inst_66994 = cljs.core.dissoc.call(null,inst_66973,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_66995 = fluree.db.api_js.history_query_async.call(null,inst_66969,inst_66994,inst_66931);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(32),inst_66995);
} else {
if((state_val_67042 === (44))){
var inst_67020 = (state_67041[(2)]);
var inst_67021 = fluree.db.util.async.throw_err.call(null,inst_67020);
var state_67041__$1 = state_67041;
var statearr_67063_67126 = state_67041__$1;
(statearr_67063_67126[(2)] = inst_67021);

(statearr_67063_67126[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (6))){
var inst_66930 = (state_67041[(12)]);
var inst_66937 = inst_66930.cljs$lang$protocol_mask$partition0$;
var inst_66938 = (inst_66937 & (64));
var inst_66939 = inst_66930.cljs$core$ISeq$;
var inst_66940 = (cljs.core.PROTOCOL_SENTINEL === inst_66939);
var inst_66941 = ((inst_66938) || (inst_66940));
var state_67041__$1 = state_67041;
if(cljs.core.truth_(inst_66941)){
var statearr_67064_67127 = state_67041__$1;
(statearr_67064_67127[(1)] = (9));

} else {
var statearr_67065_67128 = state_67041__$1;
(statearr_67065_67128[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (28))){
var inst_66989 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67066_67129 = state_67041__$1;
(statearr_67066_67129[(2)] = inst_66989);

(statearr_67066_67129[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (25))){
var inst_67032 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67067_67130 = state_67041__$1;
(statearr_67067_67130[(2)] = inst_67032);

(statearr_67067_67130[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (34))){
var inst_66973 = (state_67041[(7)]);
var inst_67009 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_66973);
var state_67041__$1 = state_67041;
if(cljs.core.truth_(inst_67009)){
var statearr_67068_67131 = state_67041__$1;
(statearr_67068_67131[(1)] = (37));

} else {
var statearr_67069_67132 = state_67041__$1;
(statearr_67069_67132[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (17))){
var inst_66956 = (state_67041[(14)]);
var inst_66966 = (state_67041[(13)]);
var inst_66963 = (state_67041[(2)]);
var inst_66964 = [inst_66963];
var inst_66965 = cljs.core.PersistentHashMap.fromArrays(inst_66956,inst_66964);
var inst_66966__$1 = flureenjs.db_instance.call(null,conn,db_name,inst_66965);
var state_67041__$1 = (function (){var statearr_67070 = state_67041;
(statearr_67070[(13)] = inst_66966__$1);

return statearr_67070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(18),inst_66966__$1);
} else {
if((state_val_67042 === (3))){
var inst_67039 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67041__$1,inst_67039);
} else {
if((state_val_67042 === (12))){
var inst_66930 = (state_67041[(12)]);
var inst_66950 = cljs.core.apply.call(null,cljs.core.hash_map,inst_66930);
var state_67041__$1 = state_67041;
var statearr_67071_67133 = state_67041__$1;
(statearr_67071_67133[(2)] = inst_66950);

(statearr_67071_67133[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (2))){
var inst_66931 = (state_67041[(11)]);
var inst_66930 = (state_67041[(12)]);
var _ = (function (){var statearr_67072 = state_67041;
(statearr_67072[(4)] = cljs.core.cons.call(null,(5),(state_67041[(4)])));

return statearr_67072;
})();
var inst_66929 = fluree.db.util.json.parse.call(null,param);
var inst_66930__$1 = cljs.core.js__GT_clj.call(null,inst_66929,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_66931__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_66932 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_66931__$1);
var inst_66934 = (inst_66930__$1 == null);
var inst_66935 = cljs.core.not.call(null,inst_66934);
var state_67041__$1 = (function (){var statearr_67073 = state_67041;
(statearr_67073[(9)] = inst_66932);

(statearr_67073[(11)] = inst_66931__$1);

(statearr_67073[(12)] = inst_66930__$1);

return statearr_67073;
})();
if(inst_66935){
var statearr_67074_67134 = state_67041__$1;
(statearr_67074_67134[(1)] = (6));

} else {
var statearr_67075_67135 = state_67041__$1;
(statearr_67075_67135[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (23))){
var inst_66931 = (state_67041[(11)]);
var inst_66983 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_66931);
var state_67041__$1 = state_67041;
if(cljs.core.truth_(inst_66983)){
var statearr_67076_67136 = state_67041__$1;
(statearr_67076_67136[(1)] = (26));

} else {
var statearr_67077_67137 = state_67041__$1;
(statearr_67077_67137[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (35))){
var inst_67028 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67078_67138 = state_67041__$1;
(statearr_67078_67138[(2)] = inst_67028);

(statearr_67078_67138[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (19))){
var inst_66973 = (state_67041[(7)]);
var inst_66972 = (state_67041[(2)]);
var inst_66973__$1 = fluree.db.util.async.throw_err.call(null,inst_66972);
var inst_66974 = fluree.db.util.core.exception_QMARK_.call(null,inst_66973__$1);
var state_67041__$1 = (function (){var statearr_67079 = state_67041;
(statearr_67079[(7)] = inst_66973__$1);

return statearr_67079;
})();
if(inst_66974){
var statearr_67080_67139 = state_67041__$1;
(statearr_67080_67139[(1)] = (20));

} else {
var statearr_67081_67140 = state_67041__$1;
(statearr_67081_67140[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (11))){
var inst_66945 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67083_67141 = state_67041__$1;
(statearr_67083_67141[(2)] = inst_66945);

(statearr_67083_67141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (9))){
var state_67041__$1 = state_67041;
var statearr_67084_67142 = state_67041__$1;
(statearr_67084_67142[(2)] = true);

(statearr_67084_67142[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (5))){
var _ = (function (){var statearr_67085 = state_67041;
(statearr_67085[(4)] = cljs.core.rest.call(null,(state_67041[(4)])));

return statearr_67085;
})();
var state_67041__$1 = state_67041;
var ex67082 = (state_67041__$1[(2)]);
var statearr_67086_67143 = state_67041__$1;
(statearr_67086_67143[(5)] = ex67082);


var statearr_67087_67144 = state_67041__$1;
(statearr_67087_67144[(1)] = (4));

(statearr_67087_67144[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (14))){
var inst_66932 = (state_67041[(9)]);
var inst_66953 = (state_67041[(2)]);
var inst_66954 = cljs.core.get.call(null,inst_66953,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_66955 = cljs.core.get.call(null,inst_66953,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_66956 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_67041__$1 = (function (){var statearr_67088 = state_67041;
(statearr_67088[(14)] = inst_66956);

(statearr_67088[(15)] = inst_66955);

(statearr_67088[(16)] = inst_66954);

return statearr_67088;
})();
if(cljs.core.truth_(inst_66932)){
var statearr_67089_67145 = state_67041__$1;
(statearr_67089_67145[(1)] = (15));

} else {
var statearr_67090_67146 = state_67041__$1;
(statearr_67090_67146[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (26))){
var inst_66973 = (state_67041[(7)]);
var inst_66985 = cljs.core.dissoc.call(null,inst_66973,new cljs.core.Keyword(null,"type","type",1174270348));
var state_67041__$1 = state_67041;
var statearr_67091_67147 = state_67041__$1;
(statearr_67091_67147[(2)] = inst_66985);

(statearr_67091_67147[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (16))){
var state_67041__$1 = state_67041;
var statearr_67092_67148 = state_67041__$1;
(statearr_67092_67148[(2)] = null);

(statearr_67092_67148[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (38))){
var state_67041__$1 = state_67041;
var statearr_67093_67149 = state_67041__$1;
(statearr_67093_67149[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (30))){
var inst_66973 = (state_67041[(7)]);
var inst_67000 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_66973);
var inst_67001 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_67000);
var state_67041__$1 = state_67041;
if(inst_67001){
var statearr_67095_67150 = state_67041__$1;
(statearr_67095_67150[(1)] = (33));

} else {
var statearr_67096_67151 = state_67041__$1;
(statearr_67096_67151[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (10))){
var state_67041__$1 = state_67041;
var statearr_67097_67152 = state_67041__$1;
(statearr_67097_67152[(2)] = false);

(statearr_67097_67152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (18))){
var inst_66969 = (state_67041[(10)]);
var inst_66955 = (state_67041[(15)]);
var inst_66931 = (state_67041[(11)]);
var inst_66954 = (state_67041[(16)]);
var inst_66968 = (state_67041[(2)]);
var inst_66969__$1 = fluree.db.util.async.throw_err.call(null,inst_66968);
var inst_66970 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_66969__$1,inst_66954,inst_66955,inst_66931);
var state_67041__$1 = (function (){var statearr_67098 = state_67041;
(statearr_67098[(10)] = inst_66969__$1);

return statearr_67098;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(19),inst_66970);
} else {
if((state_val_67042 === (42))){
var state_67041__$1 = state_67041;
var statearr_67099_67153 = state_67041__$1;
(statearr_67099_67153[(2)] = null);

(statearr_67099_67153[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (37))){
var inst_66973 = (state_67041[(7)]);
var inst_66931 = (state_67041[(11)]);
var inst_67011 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_66973);
var inst_67012 = fluree.db.api_js.transact_async.call(null,conn,db_name,inst_67011,inst_66931);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(40),inst_67012);
} else {
if((state_val_67042 === (8))){
var inst_66948 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
if(cljs.core.truth_(inst_66948)){
var statearr_67100_67154 = state_67041__$1;
(statearr_67100_67154[(1)] = (12));

} else {
var statearr_67101_67155 = state_67041__$1;
(statearr_67101_67155[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_67102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67102[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_67102[(1)] = (1));

return statearr_67102;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_67041){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67103){var ex__2457__auto__ = e67103;
var statearr_67104_67156 = state_67041;
(statearr_67104_67156[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67041[(4)]))){
var statearr_67105_67157 = state_67041;
(statearr_67105_67157[(1)] = cljs.core.first.call(null,(state_67041[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67158 = state_67041;
state_67041 = G__67158;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_67041){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_67041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67106 = f__2477__auto__.call(null);
(statearr_67106[(6)] = c__2476__auto__);

return statearr_67106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.history_query = (function flureenjs$history_query(var_args){
var G__67160 = arguments.length;
switch (G__67160) {
case 2:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.history_query', flureenjs.history_query);

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.history_query.call(null,sources,query_map,null);
}));

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67188){
var state_val_67189 = (state_67188[(1)]);
if((state_val_67189 === (7))){
var inst_67175 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_67188__$1 = state_67188;
var statearr_67190_67211 = state_67188__$1;
(statearr_67190_67211[(2)] = inst_67175);

(statearr_67190_67211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (1))){
var state_67188__$1 = state_67188;
var statearr_67191_67212 = state_67188__$1;
(statearr_67191_67212[(2)] = null);

(statearr_67191_67212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (4))){
var inst_67161 = (state_67188[(2)]);
var inst_67162 = fluree.db.util.log.error.call(null,inst_67161);
var inst_67163 = reject.call(null,inst_67161);
var state_67188__$1 = (function (){var statearr_67192 = state_67188;
(statearr_67192[(7)] = inst_67162);

return statearr_67192;
})();
var statearr_67193_67213 = state_67188__$1;
(statearr_67193_67213[(2)] = inst_67163);

(statearr_67193_67213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (6))){
var state_67188__$1 = state_67188;
var statearr_67194_67214 = state_67188__$1;
(statearr_67194_67214[(2)] = null);

(statearr_67194_67214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (3))){
var inst_67186 = (state_67188[(2)]);
var state_67188__$1 = state_67188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67188__$1,inst_67186);
} else {
if((state_val_67189 === (2))){
var _ = (function (){var statearr_67196 = state_67188;
(statearr_67196[(4)] = cljs.core.cons.call(null,(5),(state_67188[(4)])));

return statearr_67196;
})();
var inst_67169 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67170 = (opts == null);
var inst_67171 = cljs.core.empty_QMARK_.call(null,opts);
var inst_67172 = ((inst_67170) || (inst_67171));
var state_67188__$1 = (function (){var statearr_67197 = state_67188;
(statearr_67197[(8)] = inst_67169);

return statearr_67197;
})();
if(cljs.core.truth_(inst_67172)){
var statearr_67198_67215 = state_67188__$1;
(statearr_67198_67215[(1)] = (6));

} else {
var statearr_67199_67216 = state_67188__$1;
(statearr_67199_67216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (9))){
var inst_67180 = (state_67188[(2)]);
var inst_67181 = fluree.db.util.async.throw_err.call(null,inst_67180);
var inst_67182 = cljs.core.clj__GT_js.call(null,inst_67181);
var inst_67183 = resolve.call(null,inst_67182);
var _ = (function (){var statearr_67200 = state_67188;
(statearr_67200[(4)] = cljs.core.rest.call(null,(state_67188[(4)])));

return statearr_67200;
})();
var state_67188__$1 = state_67188;
var statearr_67201_67217 = state_67188__$1;
(statearr_67201_67217[(2)] = inst_67183);

(statearr_67201_67217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (5))){
var _ = (function (){var statearr_67202 = state_67188;
(statearr_67202[(4)] = cljs.core.rest.call(null,(state_67188[(4)])));

return statearr_67202;
})();
var state_67188__$1 = state_67188;
var ex67195 = (state_67188__$1[(2)]);
var statearr_67203_67218 = state_67188__$1;
(statearr_67203_67218[(5)] = ex67195);


var statearr_67204_67219 = state_67188__$1;
(statearr_67204_67219[(1)] = (4));

(statearr_67204_67219[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67189 === (8))){
var inst_67169 = (state_67188[(8)]);
var inst_67177 = (state_67188[(2)]);
var inst_67178 = fluree.db.api_js.history_query_async.call(null,sources,inst_67169,inst_67177);
var state_67188__$1 = state_67188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67188__$1,(9),inst_67178);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_67205 = [null,null,null,null,null,null,null,null,null];
(statearr_67205[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_67205[(1)] = (1));

return statearr_67205;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_67188){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67206){var ex__2457__auto__ = e67206;
var statearr_67207_67220 = state_67188;
(statearr_67207_67220[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67188[(4)]))){
var statearr_67208_67221 = state_67188;
(statearr_67208_67221[(1)] = cljs.core.first.call(null,(state_67188[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67222 = state_67188;
state_67188 = G__67222;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_67188){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_67188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67209 = f__2477__auto__.call(null);
(statearr_67209[(6)] = c__2476__auto__);

return statearr_67209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.history_query.cljs$lang$maxFixedArity = 3);

flureenjs.multi_query = (function flureenjs$multi_query(var_args){
var G__67224 = arguments.length;
switch (G__67224) {
case 2:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multi_query', flureenjs.multi_query);

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return flureenjs.multi_query.call(null,sources,multi_query_map,null);
}));

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67245){
var state_val_67246 = (state_67245[(1)]);
if((state_val_67246 === (1))){
var state_67245__$1 = state_67245;
var statearr_67247_67263 = state_67245__$1;
(statearr_67247_67263[(2)] = null);

(statearr_67247_67263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (2))){
var _ = (function (){var statearr_67248 = state_67245;
(statearr_67248[(4)] = cljs.core.cons.call(null,(5),(state_67245[(4)])));

return statearr_67248;
})();
var inst_67233 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67234 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67235 = fluree.db.api_js.multi_query_async.call(null,sources,inst_67233,inst_67234,flureenjs.db_instance);
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67245__$1,(6),inst_67235);
} else {
if((state_val_67246 === (3))){
var inst_67243 = (state_67245[(2)]);
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67245__$1,inst_67243);
} else {
if((state_val_67246 === (4))){
var inst_67225 = (state_67245[(2)]);
var inst_67226 = fluree.db.util.log.error.call(null,inst_67225);
var inst_67227 = reject.call(null,inst_67225);
var state_67245__$1 = (function (){var statearr_67250 = state_67245;
(statearr_67250[(7)] = inst_67226);

return statearr_67250;
})();
var statearr_67251_67264 = state_67245__$1;
(statearr_67251_67264[(2)] = inst_67227);

(statearr_67251_67264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (5))){
var _ = (function (){var statearr_67252 = state_67245;
(statearr_67252[(4)] = cljs.core.rest.call(null,(state_67245[(4)])));

return statearr_67252;
})();
var state_67245__$1 = state_67245;
var ex67249 = (state_67245__$1[(2)]);
var statearr_67253_67265 = state_67245__$1;
(statearr_67253_67265[(5)] = ex67249);


var statearr_67254_67266 = state_67245__$1;
(statearr_67254_67266[(1)] = (4));

(statearr_67254_67266[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (6))){
var inst_67237 = (state_67245[(2)]);
var inst_67238 = fluree.db.util.async.throw_err.call(null,inst_67237);
var inst_67239 = cljs.core.clj__GT_js.call(null,inst_67238);
var inst_67240 = resolve.call(null,inst_67239);
var _ = (function (){var statearr_67255 = state_67245;
(statearr_67255[(4)] = cljs.core.rest.call(null,(state_67245[(4)])));

return statearr_67255;
})();
var state_67245__$1 = state_67245;
var statearr_67256_67267 = state_67245__$1;
(statearr_67256_67267[(2)] = inst_67240);

(statearr_67256_67267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_67257 = [null,null,null,null,null,null,null,null];
(statearr_67257[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_67257[(1)] = (1));

return statearr_67257;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_67245){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67258){var ex__2457__auto__ = e67258;
var statearr_67259_67268 = state_67245;
(statearr_67259_67268[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67245[(4)]))){
var statearr_67260_67269 = state_67245;
(statearr_67260_67269[(1)] = cljs.core.first.call(null,(state_67245[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67270 = state_67245;
state_67245 = G__67270;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_67245){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_67245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67261 = f__2477__auto__.call(null);
(statearr_67261[(6)] = c__2476__auto__);

return statearr_67261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.multi_query.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureenjs.q = (function flureenjs$q(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67290){
var state_val_67291 = (state_67290[(1)]);
if((state_val_67291 === (1))){
var state_67290__$1 = state_67290;
var statearr_67292_67307 = state_67290__$1;
(statearr_67292_67307[(2)] = null);

(statearr_67292_67307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67291 === (2))){
var _ = (function (){var statearr_67293 = state_67290;
(statearr_67293[(4)] = cljs.core.cons.call(null,(5),(state_67290[(4)])));

return statearr_67293;
})();
var inst_67280 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67281 = fluree.db.api_js.query_async.call(null,sources,inst_67280,flureenjs.db_instance);
var state_67290__$1 = state_67290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67290__$1,(6),inst_67281);
} else {
if((state_val_67291 === (3))){
var inst_67288 = (state_67290[(2)]);
var state_67290__$1 = state_67290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67290__$1,inst_67288);
} else {
if((state_val_67291 === (4))){
var inst_67271 = (state_67290[(2)]);
var inst_67272 = fluree.db.util.log.error.call(null,inst_67271);
var inst_67273 = cljs.core.clj__GT_js.call(null,inst_67271);
var inst_67274 = reject.call(null,inst_67273);
var state_67290__$1 = (function (){var statearr_67295 = state_67290;
(statearr_67295[(7)] = inst_67272);

return statearr_67295;
})();
var statearr_67296_67308 = state_67290__$1;
(statearr_67296_67308[(2)] = inst_67274);

(statearr_67296_67308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67291 === (5))){
var _ = (function (){var statearr_67297 = state_67290;
(statearr_67297[(4)] = cljs.core.rest.call(null,(state_67290[(4)])));

return statearr_67297;
})();
var state_67290__$1 = state_67290;
var ex67294 = (state_67290__$1[(2)]);
var statearr_67298_67309 = state_67290__$1;
(statearr_67298_67309[(5)] = ex67294);


var statearr_67299_67310 = state_67290__$1;
(statearr_67299_67310[(1)] = (4));

(statearr_67299_67310[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67291 === (6))){
var inst_67283 = (state_67290[(2)]);
var inst_67284 = cljs.core.clj__GT_js.call(null,inst_67283);
var inst_67285 = resolve.call(null,inst_67284);
var _ = (function (){var statearr_67300 = state_67290;
(statearr_67300[(4)] = cljs.core.rest.call(null,(state_67290[(4)])));

return statearr_67300;
})();
var state_67290__$1 = state_67290;
var statearr_67301_67311 = state_67290__$1;
(statearr_67301_67311[(2)] = inst_67285);

(statearr_67301_67311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$q_$_state_machine__2454__auto__ = null;
var flureenjs$q_$_state_machine__2454__auto____0 = (function (){
var statearr_67302 = [null,null,null,null,null,null,null,null];
(statearr_67302[(0)] = flureenjs$q_$_state_machine__2454__auto__);

(statearr_67302[(1)] = (1));

return statearr_67302;
});
var flureenjs$q_$_state_machine__2454__auto____1 = (function (state_67290){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67303){var ex__2457__auto__ = e67303;
var statearr_67304_67312 = state_67290;
(statearr_67304_67312[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67290[(4)]))){
var statearr_67305_67313 = state_67290;
(statearr_67305_67313[(1)] = cljs.core.first.call(null,(state_67290[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67314 = state_67290;
state_67290 = G__67314;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$q_$_state_machine__2454__auto__ = function(state_67290){
switch(arguments.length){
case 0:
return flureenjs$q_$_state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$q_$_state_machine__2454__auto____1.call(this,state_67290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$q_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$q_$_state_machine__2454__auto____0;
flureenjs$q_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$q_$_state_machine__2454__auto____1;
return flureenjs$q_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67306 = f__2477__auto__.call(null);
(statearr_67306[(6)] = c__2476__auto__);

return statearr_67306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
goog.exportSymbol('flureenjs.q', flureenjs.q);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureenjs.signed_query = (function flureenjs$signed_query(var_args){
var G__67316 = arguments.length;
switch (G__67316) {
case 3:
return flureenjs.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.signed_query', flureenjs.signed_query);

(flureenjs.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.signed_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67343){
var state_val_67344 = (state_67343[(1)]);
if((state_val_67344 === (7))){
var inst_67330 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_67343__$1 = state_67343;
var statearr_67345_67366 = state_67343__$1;
(statearr_67345_67366[(2)] = inst_67330);

(statearr_67345_67366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (1))){
var state_67343__$1 = state_67343;
var statearr_67346_67367 = state_67343__$1;
(statearr_67346_67367[(2)] = null);

(statearr_67346_67367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (4))){
var inst_67317 = (state_67343[(2)]);
var inst_67318 = fluree.db.util.log.error.call(null,inst_67317);
var inst_67319 = cljs.core.clj__GT_js.call(null,inst_67317);
var inst_67320 = reject.call(null,inst_67319);
var state_67343__$1 = (function (){var statearr_67347 = state_67343;
(statearr_67347[(7)] = inst_67318);

return statearr_67347;
})();
var statearr_67348_67368 = state_67343__$1;
(statearr_67348_67368[(2)] = inst_67320);

(statearr_67348_67368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (6))){
var state_67343__$1 = state_67343;
var statearr_67349_67369 = state_67343__$1;
(statearr_67349_67369[(2)] = null);

(statearr_67349_67369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (3))){
var inst_67341 = (state_67343[(2)]);
var state_67343__$1 = state_67343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67343__$1,inst_67341);
} else {
if((state_val_67344 === (2))){
var _ = (function (){var statearr_67351 = state_67343;
(statearr_67351[(4)] = cljs.core.cons.call(null,(5),(state_67343[(4)])));

return statearr_67351;
})();
var inst_67326 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_67327 = (opts == null);
var state_67343__$1 = (function (){var statearr_67352 = state_67343;
(statearr_67352[(8)] = inst_67326);

return statearr_67352;
})();
if(cljs.core.truth_(inst_67327)){
var statearr_67353_67370 = state_67343__$1;
(statearr_67353_67370[(1)] = (6));

} else {
var statearr_67354_67371 = state_67343__$1;
(statearr_67354_67371[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (9))){
var inst_67335 = (state_67343[(2)]);
var inst_67336 = fluree.db.util.async.throw_err.call(null,inst_67335);
var inst_67337 = cljs.core.clj__GT_js.call(null,inst_67336);
var inst_67338 = resolve.call(null,inst_67337);
var _ = (function (){var statearr_67355 = state_67343;
(statearr_67355[(4)] = cljs.core.rest.call(null,(state_67343[(4)])));

return statearr_67355;
})();
var state_67343__$1 = state_67343;
var statearr_67356_67372 = state_67343__$1;
(statearr_67356_67372[(2)] = inst_67338);

(statearr_67356_67372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (5))){
var _ = (function (){var statearr_67357 = state_67343;
(statearr_67357[(4)] = cljs.core.rest.call(null,(state_67343[(4)])));

return statearr_67357;
})();
var state_67343__$1 = state_67343;
var ex67350 = (state_67343__$1[(2)]);
var statearr_67358_67373 = state_67343__$1;
(statearr_67358_67373[(5)] = ex67350);


var statearr_67359_67374 = state_67343__$1;
(statearr_67359_67374[(1)] = (4));

(statearr_67359_67374[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67344 === (8))){
var inst_67326 = (state_67343[(8)]);
var inst_67332 = (state_67343[(2)]);
var inst_67333 = fluree.db.api_js.signed_query_async.call(null,conn,ledger,inst_67326,inst_67332);
var state_67343__$1 = state_67343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67343__$1,(9),inst_67333);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_67360 = [null,null,null,null,null,null,null,null,null];
(statearr_67360[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_67360[(1)] = (1));

return statearr_67360;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_67343){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67361){var ex__2457__auto__ = e67361;
var statearr_67362_67375 = state_67343;
(statearr_67362_67375[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67343[(4)]))){
var statearr_67363_67376 = state_67343;
(statearr_67363_67376[(1)] = cljs.core.first.call(null,(state_67343[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67377 = state_67343;
state_67343 = G__67377;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_67343){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_67343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67364 = f__2477__auto__.call(null);
(statearr_67364[(6)] = c__2476__auto__);

return statearr_67364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__67379 = arguments.length;
switch (G__67379) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_67409){
var state_val_67410 = (state_67409[(1)]);
if((state_val_67410 === (7))){
var state_67409__$1 = state_67409;
var statearr_67411_67432 = state_67409__$1;
(statearr_67411_67432[(2)] = null);

(statearr_67411_67432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (1))){
var state_67409__$1 = state_67409;
var statearr_67412_67433 = state_67409__$1;
(statearr_67412_67433[(2)] = null);

(statearr_67412_67433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (4))){
var inst_67380 = (state_67409[(2)]);
var inst_67381 = fluree.db.util.log.error.call(null,inst_67380);
var inst_67382 = cljs.core.clj__GT_js.call(null,inst_67380);
var inst_67383 = reject.call(null,inst_67382);
var state_67409__$1 = (function (){var statearr_67413 = state_67409;
(statearr_67413[(7)] = inst_67381);

return statearr_67413;
})();
var statearr_67414_67434 = state_67409__$1;
(statearr_67414_67434[(2)] = inst_67383);

(statearr_67414_67434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (6))){
var inst_67393 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_67409__$1 = state_67409;
var statearr_67415_67435 = state_67409__$1;
(statearr_67415_67435[(2)] = inst_67393);

(statearr_67415_67435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (3))){
var inst_67407 = (state_67409[(2)]);
var state_67409__$1 = state_67409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67409__$1,inst_67407);
} else {
if((state_val_67410 === (2))){
var inst_67390 = (state_67409[(8)]);
var _ = (function (){var statearr_67417 = state_67409;
(statearr_67417[(4)] = cljs.core.cons.call(null,(5),(state_67409[(4)])));

return statearr_67417;
})();
var inst_67389 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_67390__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_67389);
var inst_67391 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_67390__$1);
var state_67409__$1 = (function (){var statearr_67418 = state_67409;
(statearr_67418[(9)] = inst_67391);

(statearr_67418[(8)] = inst_67390__$1);

return statearr_67418;
})();
if(cljs.core.truth_(opts)){
var statearr_67419_67436 = state_67409__$1;
(statearr_67419_67436[(1)] = (6));

} else {
var statearr_67420_67437 = state_67409__$1;
(statearr_67420_67437[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (9))){
var inst_67401 = (state_67409[(2)]);
var inst_67402 = fluree.db.util.async.throw_err.call(null,inst_67401);
var inst_67403 = cljs.core.clj__GT_js.call(null,inst_67402);
var inst_67404 = resolve.call(null,inst_67403);
var _ = (function (){var statearr_67421 = state_67409;
(statearr_67421[(4)] = cljs.core.rest.call(null,(state_67409[(4)])));

return statearr_67421;
})();
var state_67409__$1 = state_67409;
var statearr_67422_67438 = state_67409__$1;
(statearr_67422_67438[(2)] = inst_67404);

(statearr_67422_67438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (5))){
var _ = (function (){var statearr_67423 = state_67409;
(statearr_67423[(4)] = cljs.core.rest.call(null,(state_67409[(4)])));

return statearr_67423;
})();
var state_67409__$1 = state_67409;
var ex67416 = (state_67409__$1[(2)]);
var statearr_67424_67439 = state_67409__$1;
(statearr_67424_67439[(5)] = ex67416);


var statearr_67425_67440 = state_67409__$1;
(statearr_67425_67440[(1)] = (4));

(statearr_67425_67440[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67410 === (8))){
var inst_67391 = (state_67409[(9)]);
var inst_67390 = (state_67409[(8)]);
var inst_67396 = (state_67409[(2)]);
var inst_67397 = cljs.core.merge.call(null,inst_67391,inst_67396);
var inst_67398 = cljs.core.assoc.call(null,inst_67390,new cljs.core.Keyword(null,"opts","opts",155075701),inst_67397);
var inst_67399 = fluree.db.api_js.query_async.call(null,db,inst_67398,flureenjs.db_instance);
var state_67409__$1 = state_67409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67409__$1,(9),inst_67399);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2454__auto__ = null;
var flureenjs$state_machine__2454__auto____0 = (function (){
var statearr_67426 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67426[(0)] = flureenjs$state_machine__2454__auto__);

(statearr_67426[(1)] = (1));

return statearr_67426;
});
var flureenjs$state_machine__2454__auto____1 = (function (state_67409){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_67409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e67427){var ex__2457__auto__ = e67427;
var statearr_67428_67441 = state_67409;
(statearr_67428_67441[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_67409[(4)]))){
var statearr_67429_67442 = state_67409;
(statearr_67429_67442[(1)] = cljs.core.first.call(null,(state_67409[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67443 = state_67409;
state_67409 = G__67443;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
flureenjs$state_machine__2454__auto__ = function(state_67409){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2454__auto____0.call(this);
case 1:
return flureenjs$state_machine__2454__auto____1.call(this,state_67409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2454__auto____0;
flureenjs$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2454__auto____1;
return flureenjs$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_67430 = f__2477__auto__.call(null);
(statearr_67430[(6)] = c__2476__auto__);

return statearr_67430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.http_signature = (function flureenjs$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureenjs.http_signature', flureenjs.http_signature);
