// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__15848 = cljs.core._EQ_;
var expr__15849 = e.getLastErrorCode();
if(cljs.core.truth_(pred__15848.call(null,goog.net.ErrorCode.NO_ERROR,expr__15849))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__15848.call(null,goog.net.ErrorCode.EXCEPTION,expr__15849))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__15848.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__15849))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__15848.call(null,goog.net.ErrorCode.ABORT,expr__15849))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__15848.call(null,goog.net.ErrorCode.TIMEOUT,expr__15849))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__15851 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__15851,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__15851;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__15852 = opts;
var map__15852__$1 = (((((!((map__15852 == null))))?(((((map__15852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15852.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15852):map__15852);
var request_timeout = cljs.core.get.call(null,map__15852__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__15852__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__15852__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__15854 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__15854__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__15854,headers):G__15854);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__15854__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__15854__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e15855){var e_15856 = e15855;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_15856);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__15857 = opts;
var map__15857__$1 = (((((!((map__15857 == null))))?(((((map__15857.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15857.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15857):map__15857);
var request_timeout = cljs.core.get.call(null,map__15857__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__15857__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__15857__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__15857__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__15857__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__15859 = cljs.core.PersistentArrayMap.EMPTY;
var G__15859__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__15859,headers):G__15859);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__15859__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__15859__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__15861 = output_format;
var G__15861__$1 = (((G__15861 instanceof cljs.core.Keyword))?G__15861.fqn:null);
switch (G__15861__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e15860){var e_15863 = e15860;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_15863);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__15864 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__15864,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__15864;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_15897){
var state_val_15898 = (state_15897[(1)]);
if((state_val_15898 === (7))){
var inst_15893 = (state_15897[(2)]);
var state_15897__$1 = state_15897;
var statearr_15899_15924 = state_15897__$1;
(statearr_15899_15924[(2)] = inst_15893);

(statearr_15899_15924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (1))){
var state_15897__$1 = state_15897;
var statearr_15900_15925 = state_15897__$1;
(statearr_15900_15925[(2)] = null);

(statearr_15900_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (4))){
var inst_15868 = (state_15897[(7)]);
var inst_15868__$1 = (state_15897[(2)]);
var inst_15869 = (inst_15868__$1 == null);
var state_15897__$1 = (function (){var statearr_15901 = state_15897;
(statearr_15901[(7)] = inst_15868__$1);

return statearr_15901;
})();
if(cljs.core.truth_(inst_15869)){
var statearr_15902_15926 = state_15897__$1;
(statearr_15902_15926[(1)] = (5));

} else {
var statearr_15903_15927 = state_15897__$1;
(statearr_15903_15927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (6))){
var inst_15868 = (state_15897[(7)]);
var inst_15876 = cljs.core.nth.call(null,inst_15868,(0),null);
var inst_15877 = cljs.core.nth.call(null,inst_15868,(1),null);
var state_15897__$1 = (function (){var statearr_15904 = state_15897;
(statearr_15904[(8)] = inst_15877);

(statearr_15904[(9)] = inst_15876);

return statearr_15904;
})();
var statearr_15905_15928 = state_15897__$1;
(statearr_15905_15928[(2)] = null);

(statearr_15905_15928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (3))){
var inst_15895 = (state_15897[(2)]);
var state_15897__$1 = state_15897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15897__$1,inst_15895);
} else {
if((state_val_15898 === (2))){
var state_15897__$1 = state_15897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15897__$1,(4),pub_chan);
} else {
if((state_val_15898 === (11))){
var _ = (function (){var statearr_15907 = state_15897;
(statearr_15907[(4)] = cljs.core.rest.call(null,(state_15897[(4)])));

return statearr_15907;
})();
var state_15897__$1 = state_15897;
var ex15906 = (state_15897__$1[(2)]);
var statearr_15908_15929 = state_15897__$1;
(statearr_15908_15929[(5)] = ex15906);


if((ex15906 instanceof Error)){
var statearr_15909_15930 = state_15897__$1;
(statearr_15909_15930[(1)] = (10));

(statearr_15909_15930[(5)] = null);

} else {
throw ex15906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (9))){
var inst_15890 = (state_15897[(2)]);
var state_15897__$1 = (function (){var statearr_15910 = state_15897;
(statearr_15910[(10)] = inst_15890);

return statearr_15910;
})();
var statearr_15911_15931 = state_15897__$1;
(statearr_15911_15931[(2)] = null);

(statearr_15911_15931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (5))){
var inst_15871 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_15897__$1 = state_15897;
var statearr_15912_15932 = state_15897__$1;
(statearr_15912_15932[(2)] = inst_15871);

(statearr_15912_15932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (10))){
var inst_15877 = (state_15897[(8)]);
var inst_15878 = (state_15897[(2)]);
var inst_15879 = fluree.db.util.log.error.call(null,inst_15878,"Websocket send message error:",inst_15878);
var inst_15880 = cljs.core.async.put_BANG_.call(null,inst_15877,false);
var state_15897__$1 = (function (){var statearr_15913 = state_15897;
(statearr_15913[(11)] = inst_15879);

return statearr_15913;
})();
var statearr_15914_15933 = state_15897__$1;
(statearr_15914_15933[(2)] = inst_15880);

(statearr_15914_15933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15898 === (8))){
var inst_15877 = (state_15897[(8)]);
var inst_15876 = (state_15897[(9)]);
var _ = (function (){var statearr_15915 = state_15897;
(statearr_15915[(4)] = cljs.core.cons.call(null,(11),(state_15897[(4)])));

return statearr_15915;
})();
var inst_15886 = ws.send(inst_15876);
var inst_15887 = cljs.core.async.put_BANG_.call(null,inst_15877,true);
var ___$1 = (function (){var statearr_15916 = state_15897;
(statearr_15916[(4)] = cljs.core.rest.call(null,(state_15897[(4)])));

return statearr_15916;
})();
var state_15897__$1 = (function (){var statearr_15917 = state_15897;
(statearr_15917[(12)] = inst_15886);

return statearr_15917;
})();
var statearr_15918_15934 = state_15897__$1;
(statearr_15918_15934[(2)] = inst_15887);

(statearr_15918_15934[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____0 = (function (){
var statearr_15919 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15919[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__);

(statearr_15919[(1)] = (1));

return statearr_15919;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____1 = (function (state_15897){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_15897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e15920){var ex__2457__auto__ = e15920;
var statearr_15921_15935 = state_15897;
(statearr_15921_15935[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_15897[(4)]))){
var statearr_15922_15936 = state_15897;
(statearr_15922_15936[(1)] = cljs.core.first.call(null,(state_15897[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15937 = state_15897;
state_15897 = G__15937;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__ = function(state_15897){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____1.call(this,state_15897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_15923 = f__2477__auto__.call(null);
(statearr_15923[(6)] = c__2476__auto__);

return statearr_15923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2476__auto___15976 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_15963){
var state_val_15964 = (state_15963[(1)]);
if((state_val_15964 === (1))){
var inst_15942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15943 = [open_QMARK_,timeout_chan];
var inst_15944 = (new cljs.core.PersistentVector(null,2,(5),inst_15942,inst_15943,null));
var state_15963__$1 = state_15963;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15963__$1,(2),inst_15944,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_15964 === (2))){
var inst_15946 = (state_15963[(2)]);
var inst_15947 = cljs.core.nth.call(null,inst_15946,(0),null);
var inst_15948 = cljs.core.nth.call(null,inst_15946,(1),null);
var inst_15949 = cljs.core._EQ_.call(null,inst_15948,timeout_chan);
var state_15963__$1 = (function (){var statearr_15965 = state_15963;
(statearr_15965[(7)] = inst_15947);

return statearr_15965;
})();
if(inst_15949){
var statearr_15966_15977 = state_15963__$1;
(statearr_15966_15977[(1)] = (3));

} else {
var statearr_15967_15978 = state_15963__$1;
(statearr_15967_15978[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15964 === (3))){
var inst_15951 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_15952 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15953 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_15954 = cljs.core.PersistentHashMap.fromArrays(inst_15952,inst_15953);
var inst_15955 = cljs.core.ex_info.call(null,inst_15951,inst_15954);
var inst_15956 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_15955);
var inst_15957 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_15963__$1 = (function (){var statearr_15968 = state_15963;
(statearr_15968[(8)] = inst_15956);

return statearr_15968;
})();
var statearr_15969_15979 = state_15963__$1;
(statearr_15969_15979[(2)] = inst_15957);

(statearr_15969_15979[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15964 === (4))){
var inst_15959 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_15963__$1 = state_15963;
var statearr_15970_15980 = state_15963__$1;
(statearr_15970_15980[(2)] = inst_15959);

(statearr_15970_15980[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15964 === (5))){
var inst_15961 = (state_15963[(2)]);
var state_15963__$1 = state_15963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15963__$1,inst_15961);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____0 = (function (){
var statearr_15971 = [null,null,null,null,null,null,null,null,null];
(statearr_15971[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__);

(statearr_15971[(1)] = (1));

return statearr_15971;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____1 = (function (state_15963){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_15963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e15972){var ex__2457__auto__ = e15972;
var statearr_15973_15981 = state_15963;
(statearr_15973_15981[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_15963[(4)]))){
var statearr_15974_15982 = state_15963;
(statearr_15974_15982[(1)] = cljs.core.first.call(null,(state_15963[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15983 = state_15963;
state_15963 = G__15983;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__ = function(state_15963){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____1.call(this,state_15963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_15975 = f__2477__auto__.call(null);
(statearr_15975[(6)] = c__2476__auto___15976);

return statearr_15975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
