// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
fluree.db.util.schema.schema_sid_start = fluree.db.flake.min_subject_id.call(null,(0));
fluree.db.util.schema.schema_sid_end = fluree.db.flake.max_subject_id.call(null,(1));
fluree.db.util.schema.collection_sid_start = fluree.db.flake.min_subject_id.call(null,(1));
fluree.db.util.schema.collection_sid_end = fluree.db.flake.max_subject_id.call(null,(1));
fluree.db.util.schema.predicate_sid_start = fluree.db.flake.min_subject_id.call(null,(0));
fluree.db.util.schema.predicate_sid_end = fluree.db.flake.max_subject_id.call(null,(0));
fluree.db.util.schema.setting_sid_start = fluree.db.flake.min_subject_id.call(null,(9));
fluree.db.util.schema.setting_sid_end = fluree.db.flake.max_subject_id.call(null,(9));
fluree.db.util.schema.auth_sid_start = fluree.db.flake.min_subject_id.call(null,(6));
fluree.db.util.schema.auth_sid_end = fluree.db.flake.max_subject_id.call(null,(6));
fluree.db.util.schema.role_sid_start = fluree.db.flake.min_subject_id.call(null,(7));
fluree.db.util.schema.role_sid_end = fluree.db.flake.max_subject_id.call(null,(7));
fluree.db.util.schema.rule_sid_start = fluree.db.flake.min_subject_id.call(null,(8));
fluree.db.util.schema.rule_sid_end = fluree.db.flake.max_subject_id.call(null,(8));
fluree.db.util.schema.fn_sid_start = fluree.db.flake.min_subject_id.call(null,(4));
fluree.db.util.schema.fn_sid_end = fluree.db.flake.max_subject_id.call(null,(4));
fluree.db.util.schema.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.util.schema.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_schema_flake_QMARK_ = (function fluree$db$util$schema$is_schema_flake_QMARK_(f){
return (((fluree.db.util.schema.schema_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.schema_sid_end)));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_setting_flake_QMARK_ = (function fluree$db$util$schema$is_setting_flake_QMARK_(f){
return (((fluree.db.util.schema.setting_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.setting_sid_end)));
});
/**
 * Returns true if flake is a language flake.
 */
fluree.db.util.schema.is_language_flake_QMARK_ = (function fluree$db$util$schema$is_language_flake_QMARK_(f){
return cljs.core._EQ_.call(null,f.p,(117));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_genesis_flake_QMARK_ = (function fluree$db$util$schema$is_genesis_flake_QMARK_(f){
if((((fluree.db.util.schema.tag_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.tag_sid_end)))){
return true;
} else {
if(fluree.db.util.schema.is_setting_flake_QMARK_.call(null,f)){
return true;
} else {
if((((fluree.db.util.schema.auth_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.auth_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.role_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.role_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.rule_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.rule_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.fn_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.fn_sid_end)))){
return true;
} else {
if((((((fluree.db.util.schema.collection_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.collection_sid_end)))) && ((fluree.db.flake.sid__GT_i.call(null,f.s) <= (9))))){
return true;
} else {
if((((((fluree.db.util.schema.predicate_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.predicate_sid_end)))) && ((fluree.db.flake.sid__GT_i.call(null,f.s) <= (999))))){
return true;
} else {
return false;

}
}
}
}
}
}
}
}
});
fluree.db.util.schema.add_to_post_preds_QMARK_ = (function fluree$db$util$schema$add_to_post_preds_QMARK_(flakes,pred_ecount){
return cljs.core.keep.call(null,(function (p1__18040_SHARP_){
if(((((cljs.core._EQ_.call(null,p1__18040_SHARP_.p,(15))) || (cljs.core._EQ_.call(null,p1__18040_SHARP_.p,(13))))) && (cljs.core._EQ_.call(null,p1__18040_SHARP_.o,true)) && ((pred_ecount >= p1__18040_SHARP_.s)))){
return p1__18040_SHARP_.s;
} else {
return null;
}
}),flakes);
});
fluree.db.util.schema.remove_from_post_preds = (function fluree$db$util$schema$remove_from_post_preds(flakes){
return cljs.core.keep.call(null,(function (p1__18041_SHARP_){
if(((p1__18041_SHARP_.op === true) && (((cljs.core._EQ_.call(null,p1__18041_SHARP_.p,(15))) || (cljs.core._EQ_.call(null,p1__18041_SHARP_.p,(13))))) && (cljs.core._EQ_.call(null,p1__18041_SHARP_.o,false)))){
return p1__18041_SHARP_.s;
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if any of the provided flakes are a schema flake.
 */
fluree.db.util.schema.schema_change_QMARK_ = (function fluree$db$util$schema$schema_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_schema_flake_QMARK_,flakes);
});
fluree.db.util.schema.setting_change_QMARK_ = (function fluree$db$util$schema$setting_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_setting_flake_QMARK_,flakes);
});
/**
 * Returns the language being added, if any. Else returns nil.
 */
fluree.db.util.schema.get_language_change = (function fluree$db$util$schema$get_language_change(flakes){
return cljs.core.some.call(null,(function (p1__18042_SHARP_){
if(((fluree.db.util.schema.is_language_flake_QMARK_.call(null,p1__18042_SHARP_)) && (fluree.db.util.schema.is_setting_flake_QMARK_.call(null,p1__18042_SHARP_)) && (p1__18042_SHARP_.op === true))){
return p1__18042_SHARP_.o;
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_pred_flake_QMARK_ = (function fluree$db$util$schema$is_pred_flake_QMARK_(f){
return (((fluree.db.flake.MIN_PREDICATE_ID <= f.s)) && ((f.s <= fluree.db.flake.MAX_PREDICATE_ID)));
});
/**
 * Returns true if there are any predicate changes present in set of flakes.
 */
fluree.db.util.schema.pred_change_QMARK_ = (function fluree$db$util$schema$pred_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
});
