// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19400){
var state_val_19401 = (state_19400[(1)]);
if((state_val_19401 === (7))){
var inst_19389 = (state_19400[(7)]);
var inst_19391 = fluree.db.storage.core.serde.call(null,conn);
var inst_19392 = fluree.db.serde.protocol._deserialize_block.call(null,inst_19391,inst_19389);
var state_19400__$1 = state_19400;
var statearr_19402_19421 = state_19400__$1;
(statearr_19402_19421[(2)] = inst_19392);

(statearr_19402_19421[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (1))){
var state_19400__$1 = state_19400;
var statearr_19403_19422 = state_19400__$1;
(statearr_19403_19422[(2)] = null);

(statearr_19403_19422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (4))){
var inst_19379 = (state_19400[(2)]);
var state_19400__$1 = state_19400;
var statearr_19404_19423 = state_19400__$1;
(statearr_19404_19423[(2)] = inst_19379);

(statearr_19404_19423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (6))){
var inst_19389 = (state_19400[(7)]);
var inst_19388 = (state_19400[(2)]);
var inst_19389__$1 = fluree.db.util.async.throw_err.call(null,inst_19388);
var state_19400__$1 = (function (){var statearr_19405 = state_19400;
(statearr_19405[(7)] = inst_19389__$1);

return statearr_19405;
})();
if(cljs.core.truth_(inst_19389__$1)){
var statearr_19406_19424 = state_19400__$1;
(statearr_19406_19424[(1)] = (7));

} else {
var statearr_19407_19425 = state_19400__$1;
(statearr_19407_19425[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (3))){
var inst_19398 = (state_19400[(2)]);
var state_19400__$1 = state_19400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19400__$1,inst_19398);
} else {
if((state_val_19401 === (2))){
var _ = (function (){var statearr_19409 = state_19400;
(statearr_19409[(4)] = cljs.core.cons.call(null,(5),(state_19400[(4)])));

return statearr_19409;
})();
var inst_19385 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_19386 = fluree.db.storage.core.storage_read.call(null,conn,inst_19385);
var state_19400__$1 = state_19400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19400__$1,(6),inst_19386);
} else {
if((state_val_19401 === (9))){
var inst_19395 = (state_19400[(2)]);
var _ = (function (){var statearr_19410 = state_19400;
(statearr_19410[(4)] = cljs.core.rest.call(null,(state_19400[(4)])));

return statearr_19410;
})();
var state_19400__$1 = state_19400;
var statearr_19411_19426 = state_19400__$1;
(statearr_19411_19426[(2)] = inst_19395);

(statearr_19411_19426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (5))){
var _ = (function (){var statearr_19412 = state_19400;
(statearr_19412[(4)] = cljs.core.rest.call(null,(state_19400[(4)])));

return statearr_19412;
})();
var state_19400__$1 = state_19400;
var ex19408 = (state_19400__$1[(2)]);
var statearr_19413_19427 = state_19400__$1;
(statearr_19413_19427[(5)] = ex19408);


if((ex19408 instanceof Error)){
var statearr_19414_19428 = state_19400__$1;
(statearr_19414_19428[(1)] = (4));

(statearr_19414_19428[(5)] = null);

} else {
throw ex19408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19401 === (8))){
var state_19400__$1 = state_19400;
var statearr_19415_19429 = state_19400__$1;
(statearr_19415_19429[(2)] = null);

(statearr_19415_19429[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2454__auto____0 = (function (){
var statearr_19416 = [null,null,null,null,null,null,null,null];
(statearr_19416[(0)] = fluree$db$storage$core$read_block_$_state_machine__2454__auto__);

(statearr_19416[(1)] = (1));

return statearr_19416;
});
var fluree$db$storage$core$read_block_$_state_machine__2454__auto____1 = (function (state_19400){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19417){var ex__2457__auto__ = e19417;
var statearr_19418_19430 = state_19400;
(statearr_19418_19430[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19400[(4)]))){
var statearr_19419_19431 = state_19400;
(statearr_19419_19431[(1)] = cljs.core.first.call(null,(state_19400[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19432 = state_19400;
state_19400 = G__19432;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2454__auto__ = function(state_19400){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2454__auto____1.call(this,state_19400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19420 = f__2477__auto__.call(null);
(statearr_19420[(6)] = c__2476__auto__);

return statearr_19420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19455){
var state_val_19456 = (state_19455[(1)]);
if((state_val_19456 === (7))){
var inst_19444 = (state_19455[(7)]);
var inst_19446 = fluree.db.storage.core.serde.call(null,conn);
var inst_19447 = fluree.db.serde.protocol._deserialize_block.call(null,inst_19446,inst_19444);
var state_19455__$1 = state_19455;
var statearr_19457_19476 = state_19455__$1;
(statearr_19457_19476[(2)] = inst_19447);

(statearr_19457_19476[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (1))){
var state_19455__$1 = state_19455;
var statearr_19458_19477 = state_19455__$1;
(statearr_19458_19477[(2)] = null);

(statearr_19458_19477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (4))){
var inst_19433 = (state_19455[(2)]);
var state_19455__$1 = state_19455;
var statearr_19459_19478 = state_19455__$1;
(statearr_19459_19478[(2)] = inst_19433);

(statearr_19459_19478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (6))){
var inst_19444 = (state_19455[(7)]);
var inst_19443 = (state_19455[(2)]);
var inst_19444__$1 = fluree.db.util.async.throw_err.call(null,inst_19443);
var state_19455__$1 = (function (){var statearr_19460 = state_19455;
(statearr_19460[(7)] = inst_19444__$1);

return statearr_19460;
})();
if(cljs.core.truth_(inst_19444__$1)){
var statearr_19461_19479 = state_19455__$1;
(statearr_19461_19479[(1)] = (7));

} else {
var statearr_19462_19480 = state_19455__$1;
(statearr_19462_19480[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (3))){
var inst_19453 = (state_19455[(2)]);
var state_19455__$1 = state_19455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19455__$1,inst_19453);
} else {
if((state_val_19456 === (2))){
var _ = (function (){var statearr_19464 = state_19455;
(statearr_19464[(4)] = cljs.core.cons.call(null,(5),(state_19455[(4)])));

return statearr_19464;
})();
var inst_19439 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_19440 = [inst_19439,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_19441 = fluree.db.storage.core.storage_read.call(null,conn,inst_19440);
var state_19455__$1 = state_19455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19455__$1,(6),inst_19441);
} else {
if((state_val_19456 === (9))){
var inst_19450 = (state_19455[(2)]);
var _ = (function (){var statearr_19465 = state_19455;
(statearr_19465[(4)] = cljs.core.rest.call(null,(state_19455[(4)])));

return statearr_19465;
})();
var state_19455__$1 = state_19455;
var statearr_19466_19481 = state_19455__$1;
(statearr_19466_19481[(2)] = inst_19450);

(statearr_19466_19481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (5))){
var _ = (function (){var statearr_19467 = state_19455;
(statearr_19467[(4)] = cljs.core.rest.call(null,(state_19455[(4)])));

return statearr_19467;
})();
var state_19455__$1 = state_19455;
var ex19463 = (state_19455__$1[(2)]);
var statearr_19468_19482 = state_19455__$1;
(statearr_19468_19482[(5)] = ex19463);


if((ex19463 instanceof Error)){
var statearr_19469_19483 = state_19455__$1;
(statearr_19469_19483[(1)] = (4));

(statearr_19469_19483[(5)] = null);

} else {
throw ex19463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19456 === (8))){
var state_19455__$1 = state_19455;
var statearr_19470_19484 = state_19455__$1;
(statearr_19470_19484[(2)] = null);

(statearr_19470_19484[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____0 = (function (){
var statearr_19471 = [null,null,null,null,null,null,null,null];
(statearr_19471[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__);

(statearr_19471[(1)] = (1));

return statearr_19471;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____1 = (function (state_19455){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19472){var ex__2457__auto__ = e19472;
var statearr_19473_19485 = state_19455;
(statearr_19473_19485[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19455[(4)]))){
var statearr_19474_19486 = state_19455;
(statearr_19474_19486[(1)] = cljs.core.first.call(null,(state_19455[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19487 = state_19455;
state_19455 = G__19487;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__ = function(state_19455){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____1.call(this,state_19455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19475 = f__2477__auto__.call(null);
(statearr_19475[(6)] = c__2476__auto__);

return statearr_19475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19511){
var state_val_19512 = (state_19511[(1)]);
if((state_val_19512 === (1))){
var state_19511__$1 = state_19511;
var statearr_19513_19527 = state_19511__$1;
(statearr_19513_19527[(2)] = null);

(statearr_19513_19527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19512 === (2))){
var _ = (function (){var statearr_19514 = state_19511;
(statearr_19514[(4)] = cljs.core.cons.call(null,(5),(state_19511[(4)])));

return statearr_19514;
})();
var inst_19494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19495 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_19496 = (new cljs.core.PersistentVector(null,3,(5),inst_19494,inst_19495,null));
var inst_19497 = cljs.core.select_keys.call(null,block_data,inst_19496);
var inst_19498 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_19497);
var inst_19499 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_19498);
var inst_19500 = [inst_19499,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_19501 = fluree.db.storage.core.serde.call(null,conn);
var inst_19502 = fluree.db.serde.protocol._serialize_block.call(null,inst_19501,inst_19497);
var inst_19503 = fluree.db.storage.core.storage_write.call(null,conn,inst_19500,inst_19502);
var state_19511__$1 = state_19511;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19511__$1,(6),inst_19503);
} else {
if((state_val_19512 === (3))){
var inst_19509 = (state_19511[(2)]);
var state_19511__$1 = state_19511;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19511__$1,inst_19509);
} else {
if((state_val_19512 === (4))){
var inst_19488 = (state_19511[(2)]);
var state_19511__$1 = state_19511;
var statearr_19516_19528 = state_19511__$1;
(statearr_19516_19528[(2)] = inst_19488);

(statearr_19516_19528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19512 === (5))){
var _ = (function (){var statearr_19517 = state_19511;
(statearr_19517[(4)] = cljs.core.rest.call(null,(state_19511[(4)])));

return statearr_19517;
})();
var state_19511__$1 = state_19511;
var ex19515 = (state_19511__$1[(2)]);
var statearr_19518_19529 = state_19511__$1;
(statearr_19518_19529[(5)] = ex19515);


if((ex19515 instanceof Error)){
var statearr_19519_19530 = state_19511__$1;
(statearr_19519_19530[(1)] = (4));

(statearr_19519_19530[(5)] = null);

} else {
throw ex19515;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19512 === (6))){
var inst_19505 = (state_19511[(2)]);
var inst_19506 = fluree.db.util.async.throw_err.call(null,inst_19505);
var _ = (function (){var statearr_19520 = state_19511;
(statearr_19520[(4)] = cljs.core.rest.call(null,(state_19511[(4)])));

return statearr_19520;
})();
var state_19511__$1 = state_19511;
var statearr_19521_19531 = state_19511__$1;
(statearr_19521_19531[(2)] = inst_19506);

(statearr_19521_19531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____0 = (function (){
var statearr_19522 = [null,null,null,null,null,null,null];
(statearr_19522[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__);

(statearr_19522[(1)] = (1));

return statearr_19522;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____1 = (function (state_19511){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19511);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19523){var ex__2457__auto__ = e19523;
var statearr_19524_19532 = state_19511;
(statearr_19524_19532[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19511[(4)]))){
var statearr_19525_19533 = state_19511;
(statearr_19525_19533[(1)] = cljs.core.first.call(null,(state_19511[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19534 = state_19511;
state_19511 = G__19534;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__ = function(state_19511){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____1.call(this,state_19511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19526 = f__2477__auto__.call(null);
(statearr_19526[(6)] = c__2476__auto__);

return statearr_19526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19557){
var state_val_19558 = (state_19557[(1)]);
if((state_val_19558 === (1))){
var state_19557__$1 = state_19557;
var statearr_19559_19573 = state_19557__$1;
(statearr_19559_19573[(2)] = null);

(statearr_19559_19573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19558 === (2))){
var _ = (function (){var statearr_19560 = state_19557;
(statearr_19560[(4)] = cljs.core.cons.call(null,(5),(state_19557[(4)])));

return statearr_19560;
})();
var inst_19541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19542 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_19543 = (new cljs.core.PersistentVector(null,3,(5),inst_19541,inst_19542,null));
var inst_19544 = cljs.core.select_keys.call(null,block_data,inst_19543);
var inst_19545 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_19544);
var inst_19546 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_19545);
var inst_19547 = fluree.db.storage.core.serde.call(null,conn);
var inst_19548 = fluree.db.serde.protocol._serialize_block.call(null,inst_19547,inst_19544);
var inst_19549 = fluree.db.storage.core.storage_write.call(null,conn,inst_19546,inst_19548);
var state_19557__$1 = state_19557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19557__$1,(6),inst_19549);
} else {
if((state_val_19558 === (3))){
var inst_19555 = (state_19557[(2)]);
var state_19557__$1 = state_19557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19557__$1,inst_19555);
} else {
if((state_val_19558 === (4))){
var inst_19535 = (state_19557[(2)]);
var state_19557__$1 = state_19557;
var statearr_19562_19574 = state_19557__$1;
(statearr_19562_19574[(2)] = inst_19535);

(statearr_19562_19574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19558 === (5))){
var _ = (function (){var statearr_19563 = state_19557;
(statearr_19563[(4)] = cljs.core.rest.call(null,(state_19557[(4)])));

return statearr_19563;
})();
var state_19557__$1 = state_19557;
var ex19561 = (state_19557__$1[(2)]);
var statearr_19564_19575 = state_19557__$1;
(statearr_19564_19575[(5)] = ex19561);


if((ex19561 instanceof Error)){
var statearr_19565_19576 = state_19557__$1;
(statearr_19565_19576[(1)] = (4));

(statearr_19565_19576[(5)] = null);

} else {
throw ex19561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19558 === (6))){
var inst_19551 = (state_19557[(2)]);
var inst_19552 = fluree.db.util.async.throw_err.call(null,inst_19551);
var _ = (function (){var statearr_19566 = state_19557;
(statearr_19566[(4)] = cljs.core.rest.call(null,(state_19557[(4)])));

return statearr_19566;
})();
var state_19557__$1 = state_19557;
var statearr_19567_19577 = state_19557__$1;
(statearr_19567_19577[(2)] = inst_19552);

(statearr_19567_19577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2454__auto____0 = (function (){
var statearr_19568 = [null,null,null,null,null,null,null];
(statearr_19568[(0)] = fluree$db$storage$core$write_block_$_state_machine__2454__auto__);

(statearr_19568[(1)] = (1));

return statearr_19568;
});
var fluree$db$storage$core$write_block_$_state_machine__2454__auto____1 = (function (state_19557){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19569){var ex__2457__auto__ = e19569;
var statearr_19570_19578 = state_19557;
(statearr_19570_19578[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19557[(4)]))){
var statearr_19571_19579 = state_19557;
(statearr_19571_19579[(1)] = cljs.core.first.call(null,(state_19557[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19580 = state_19557;
state_19557 = G__19580;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2454__auto__ = function(state_19557){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2454__auto____1.call(this,state_19557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19572 = f__2477__auto__.call(null);
(statearr_19572[(6)] = c__2476__auto__);

return statearr_19572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19600){
var state_val_19601 = (state_19600[(1)]);
if((state_val_19601 === (1))){
var state_19600__$1 = state_19600;
var statearr_19602_19616 = state_19600__$1;
(statearr_19602_19616[(2)] = null);

(statearr_19602_19616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (2))){
var _ = (function (){var statearr_19603 = state_19600;
(statearr_19603[(4)] = cljs.core.cons.call(null,(5),(state_19600[(4)])));

return statearr_19603;
})();
var inst_19587 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_19588 = [history,next_his_key];
var inst_19589 = cljs.core.PersistentHashMap.fromArrays(inst_19587,inst_19588);
var inst_19590 = fluree.db.storage.core.serde.call(null,conn);
var inst_19591 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_19590,inst_19589);
var inst_19592 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_19591);
var state_19600__$1 = state_19600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19600__$1,(6),inst_19592);
} else {
if((state_val_19601 === (3))){
var inst_19598 = (state_19600[(2)]);
var state_19600__$1 = state_19600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19600__$1,inst_19598);
} else {
if((state_val_19601 === (4))){
var inst_19581 = (state_19600[(2)]);
var state_19600__$1 = state_19600;
var statearr_19605_19617 = state_19600__$1;
(statearr_19605_19617[(2)] = inst_19581);

(statearr_19605_19617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (5))){
var _ = (function (){var statearr_19606 = state_19600;
(statearr_19606[(4)] = cljs.core.rest.call(null,(state_19600[(4)])));

return statearr_19606;
})();
var state_19600__$1 = state_19600;
var ex19604 = (state_19600__$1[(2)]);
var statearr_19607_19618 = state_19600__$1;
(statearr_19607_19618[(5)] = ex19604);


if((ex19604 instanceof Error)){
var statearr_19608_19619 = state_19600__$1;
(statearr_19608_19619[(1)] = (4));

(statearr_19608_19619[(5)] = null);

} else {
throw ex19604;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (6))){
var inst_19594 = (state_19600[(2)]);
var inst_19595 = fluree.db.util.async.throw_err.call(null,inst_19594);
var _ = (function (){var statearr_19609 = state_19600;
(statearr_19609[(4)] = cljs.core.rest.call(null,(state_19600[(4)])));

return statearr_19609;
})();
var state_19600__$1 = state_19600;
var statearr_19610_19620 = state_19600__$1;
(statearr_19610_19620[(2)] = inst_19595);

(statearr_19610_19620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2454__auto____0 = (function (){
var statearr_19611 = [null,null,null,null,null,null,null];
(statearr_19611[(0)] = fluree$db$storage$core$write_history_$_state_machine__2454__auto__);

(statearr_19611[(1)] = (1));

return statearr_19611;
});
var fluree$db$storage$core$write_history_$_state_machine__2454__auto____1 = (function (state_19600){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19612){var ex__2457__auto__ = e19612;
var statearr_19613_19621 = state_19600;
(statearr_19613_19621[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19600[(4)]))){
var statearr_19614_19622 = state_19600;
(statearr_19614_19622[(1)] = cljs.core.first.call(null,(state_19600[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19623 = state_19600;
state_19600 = G__19623;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2454__auto__ = function(state_19600){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2454__auto____1.call(this,state_19600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19615 = f__2477__auto__.call(null);
(statearr_19615[(6)] = c__2476__auto__);

return statearr_19615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19649){
var state_val_19650 = (state_19649[(1)]);
if((state_val_19650 === (1))){
var state_19649__$1 = state_19649;
var statearr_19651_19668 = state_19649__$1;
(statearr_19651_19668[(2)] = null);

(statearr_19651_19668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19650 === (2))){
var inst_19630 = (state_19649[(7)]);
var _ = (function (){var statearr_19652 = state_19649;
(statearr_19652[(4)] = cljs.core.cons.call(null,(5),(state_19649[(4)])));

return statearr_19652;
})();
var inst_19630__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_19631 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19630__$1),"-his"].join('');
var inst_19632 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_19633 = [flakes,inst_19631];
var inst_19634 = cljs.core.PersistentHashMap.fromArrays(inst_19632,inst_19633);
var inst_19635 = fluree.db.storage.core.serde.call(null,conn);
var inst_19636 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_19635,inst_19634);
var inst_19637 = fluree.db.storage.core.write_history.call(null,conn,history,inst_19631,null);
var inst_19638 = fluree.db.storage.core.storage_write.call(null,conn,inst_19630__$1,inst_19636);
var state_19649__$1 = (function (){var statearr_19653 = state_19649;
(statearr_19653[(8)] = inst_19638);

(statearr_19653[(7)] = inst_19630__$1);

return statearr_19653;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19649__$1,(6),inst_19637);
} else {
if((state_val_19650 === (3))){
var inst_19647 = (state_19649[(2)]);
var state_19649__$1 = state_19649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19649__$1,inst_19647);
} else {
if((state_val_19650 === (4))){
var inst_19624 = (state_19649[(2)]);
var state_19649__$1 = state_19649;
var statearr_19655_19669 = state_19649__$1;
(statearr_19655_19669[(2)] = inst_19624);

(statearr_19655_19669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19650 === (5))){
var _ = (function (){var statearr_19656 = state_19649;
(statearr_19656[(4)] = cljs.core.rest.call(null,(state_19649[(4)])));

return statearr_19656;
})();
var state_19649__$1 = state_19649;
var ex19654 = (state_19649__$1[(2)]);
var statearr_19657_19670 = state_19649__$1;
(statearr_19657_19670[(5)] = ex19654);


if((ex19654 instanceof Error)){
var statearr_19658_19671 = state_19649__$1;
(statearr_19658_19671[(1)] = (4));

(statearr_19658_19671[(5)] = null);

} else {
throw ex19654;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19650 === (6))){
var inst_19638 = (state_19649[(8)]);
var inst_19640 = (state_19649[(2)]);
var inst_19641 = fluree.db.util.async.throw_err.call(null,inst_19640);
var state_19649__$1 = (function (){var statearr_19659 = state_19649;
(statearr_19659[(9)] = inst_19641);

return statearr_19659;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19649__$1,(7),inst_19638);
} else {
if((state_val_19650 === (7))){
var inst_19630 = (state_19649[(7)]);
var inst_19643 = (state_19649[(2)]);
var inst_19644 = fluree.db.util.async.throw_err.call(null,inst_19643);
var _ = (function (){var statearr_19660 = state_19649;
(statearr_19660[(4)] = cljs.core.rest.call(null,(state_19649[(4)])));

return statearr_19660;
})();
var state_19649__$1 = (function (){var statearr_19661 = state_19649;
(statearr_19661[(10)] = inst_19644);

return statearr_19661;
})();
var statearr_19662_19672 = state_19649__$1;
(statearr_19662_19672[(2)] = inst_19630);

(statearr_19662_19672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____0 = (function (){
var statearr_19663 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19663[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__);

(statearr_19663[(1)] = (1));

return statearr_19663;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____1 = (function (state_19649){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19664){var ex__2457__auto__ = e19664;
var statearr_19665_19673 = state_19649;
(statearr_19665_19673[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19649[(4)]))){
var statearr_19666_19674 = state_19649;
(statearr_19666_19674[(1)] = cljs.core.first.call(null,(state_19649[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19675 = state_19649;
state_19649 = G__19675;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__ = function(state_19649){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____1.call(this,state_19649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19667 = f__2477__auto__.call(null);
(statearr_19667[(6)] = c__2476__auto__);

return statearr_19667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19692){
var state_val_19693 = (state_19692[(1)]);
if((state_val_19693 === (1))){
var state_19692__$1 = state_19692;
var statearr_19694_19709 = state_19692__$1;
(statearr_19694_19709[(2)] = null);

(statearr_19694_19709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19693 === (2))){
var _ = (function (){var statearr_19695 = state_19692;
(statearr_19695[(4)] = cljs.core.cons.call(null,(5),(state_19692[(4)])));

return statearr_19695;
})();
var inst_19682 = fluree.db.storage.core.serde.call(null,conn);
var inst_19683 = fluree.db.serde.protocol._serialize_branch.call(null,inst_19682,data);
var inst_19684 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_19683);
var state_19692__$1 = state_19692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19692__$1,(6),inst_19684);
} else {
if((state_val_19693 === (3))){
var inst_19690 = (state_19692[(2)]);
var state_19692__$1 = state_19692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19692__$1,inst_19690);
} else {
if((state_val_19693 === (4))){
var inst_19676 = (state_19692[(2)]);
var state_19692__$1 = state_19692;
var statearr_19697_19710 = state_19692__$1;
(statearr_19697_19710[(2)] = inst_19676);

(statearr_19697_19710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19693 === (5))){
var _ = (function (){var statearr_19698 = state_19692;
(statearr_19698[(4)] = cljs.core.rest.call(null,(state_19692[(4)])));

return statearr_19698;
})();
var state_19692__$1 = state_19692;
var ex19696 = (state_19692__$1[(2)]);
var statearr_19699_19711 = state_19692__$1;
(statearr_19699_19711[(5)] = ex19696);


if((ex19696 instanceof Error)){
var statearr_19700_19712 = state_19692__$1;
(statearr_19700_19712[(1)] = (4));

(statearr_19700_19712[(5)] = null);

} else {
throw ex19696;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19693 === (6))){
var inst_19686 = (state_19692[(2)]);
var inst_19687 = fluree.db.util.async.throw_err.call(null,inst_19686);
var _ = (function (){var statearr_19701 = state_19692;
(statearr_19701[(4)] = cljs.core.rest.call(null,(state_19692[(4)])));

return statearr_19701;
})();
var state_19692__$1 = (function (){var statearr_19702 = state_19692;
(statearr_19702[(7)] = inst_19687);

return statearr_19702;
})();
var statearr_19703_19713 = state_19692__$1;
(statearr_19703_19713[(2)] = key);

(statearr_19703_19713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____0 = (function (){
var statearr_19704 = [null,null,null,null,null,null,null,null];
(statearr_19704[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__);

(statearr_19704[(1)] = (1));

return statearr_19704;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____1 = (function (state_19692){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19705){var ex__2457__auto__ = e19705;
var statearr_19706_19714 = state_19692;
(statearr_19706_19714[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19692[(4)]))){
var statearr_19707_19715 = state_19692;
(statearr_19707_19715[(1)] = cljs.core.first.call(null,(state_19692[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19716 = state_19692;
state_19692 = G__19716;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__ = function(state_19692){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____1.call(this,state_19692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19708 = f__2477__auto__.call(null);
(statearr_19708[(6)] = c__2476__auto__);

return statearr_19708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__19717_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__19717_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__19718){
var map__19719 = p__19718;
var map__19719__$1 = (((((!((map__19719 == null))))?(((((map__19719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19719):map__19719);
var progress = map__19719__$1;
var garbage = cljs.core.get.call(null,map__19719__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19768){
var state_val_19769 = (state_19768[(1)]);
if((state_val_19769 === (7))){
var state_19768__$1 = state_19768;
var statearr_19770_19799 = state_19768__$1;
(statearr_19770_19799[(2)] = false);

(statearr_19770_19799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (1))){
var state_19768__$1 = state_19768;
var statearr_19771_19800 = state_19768__$1;
(statearr_19771_19800[(2)] = null);

(statearr_19771_19800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (4))){
var inst_19721 = (state_19768[(2)]);
var state_19768__$1 = state_19768;
var statearr_19772_19801 = state_19768__$1;
(statearr_19772_19801[(2)] = inst_19721);

(statearr_19772_19801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (15))){
var inst_19754 = (state_19768[(7)]);
var inst_19762 = (state_19768[(2)]);
var inst_19763 = fluree.db.util.async.throw_err.call(null,inst_19762);
var _ = (function (){var statearr_19773 = state_19768;
(statearr_19773[(4)] = cljs.core.rest.call(null,(state_19768[(4)])));

return statearr_19773;
})();
var state_19768__$1 = (function (){var statearr_19774 = state_19768;
(statearr_19774[(8)] = inst_19763);

return statearr_19774;
})();
var statearr_19775_19802 = state_19768__$1;
(statearr_19775_19802[(2)] = inst_19754);

(statearr_19775_19802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (13))){
var inst_19728 = (state_19768[(9)]);
var state_19768__$1 = state_19768;
var statearr_19776_19803 = state_19768__$1;
(statearr_19776_19803[(2)] = inst_19728);

(statearr_19776_19803[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (6))){
var inst_19728 = (state_19768[(9)]);
var inst_19733 = inst_19728.cljs$lang$protocol_mask$partition0$;
var inst_19734 = (inst_19733 & (64));
var inst_19735 = inst_19728.cljs$core$ISeq$;
var inst_19736 = (cljs.core.PROTOCOL_SENTINEL === inst_19735);
var inst_19737 = ((inst_19734) || (inst_19736));
var state_19768__$1 = state_19768;
if(cljs.core.truth_(inst_19737)){
var statearr_19777_19804 = state_19768__$1;
(statearr_19777_19804[(1)] = (9));

} else {
var statearr_19778_19805 = state_19768__$1;
(statearr_19778_19805[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (3))){
var inst_19766 = (state_19768[(2)]);
var state_19768__$1 = state_19768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19768__$1,inst_19766);
} else {
if((state_val_19769 === (12))){
var inst_19728 = (state_19768[(9)]);
var inst_19746 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19728);
var state_19768__$1 = state_19768;
var statearr_19779_19806 = state_19768__$1;
(statearr_19779_19806[(2)] = inst_19746);

(statearr_19779_19806[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (2))){
var inst_19728 = (state_19768[(9)]);
var _ = (function (){var statearr_19780 = state_19768;
(statearr_19780[(4)] = cljs.core.cons.call(null,(5),(state_19768[(4)])));

return statearr_19780;
})();
var inst_19728__$1 = db;
var inst_19730 = (inst_19728__$1 == null);
var inst_19731 = cljs.core.not.call(null,inst_19730);
var state_19768__$1 = (function (){var statearr_19781 = state_19768;
(statearr_19781[(9)] = inst_19728__$1);

return statearr_19781;
})();
if(inst_19731){
var statearr_19782_19807 = state_19768__$1;
(statearr_19782_19807[(1)] = (6));

} else {
var statearr_19783_19808 = state_19768__$1;
(statearr_19783_19808[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (11))){
var inst_19741 = (state_19768[(2)]);
var state_19768__$1 = state_19768;
var statearr_19785_19809 = state_19768__$1;
(statearr_19785_19809[(2)] = inst_19741);

(statearr_19785_19809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (9))){
var state_19768__$1 = state_19768;
var statearr_19786_19810 = state_19768__$1;
(statearr_19786_19810[(2)] = true);

(statearr_19786_19810[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (5))){
var _ = (function (){var statearr_19787 = state_19768;
(statearr_19787[(4)] = cljs.core.rest.call(null,(state_19768[(4)])));

return statearr_19787;
})();
var state_19768__$1 = state_19768;
var ex19784 = (state_19768__$1[(2)]);
var statearr_19788_19811 = state_19768__$1;
(statearr_19788_19811[(5)] = ex19784);


if((ex19784 instanceof Error)){
var statearr_19789_19812 = state_19768__$1;
(statearr_19789_19812[(1)] = (4));

(statearr_19789_19812[(5)] = null);

} else {
throw ex19784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (14))){
var inst_19754 = (state_19768[(7)]);
var inst_19749 = (state_19768[(2)]);
var inst_19750 = cljs.core.get.call(null,inst_19749,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19751 = cljs.core.get.call(null,inst_19749,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19752 = cljs.core.get.call(null,inst_19749,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19753 = cljs.core.get.call(null,inst_19749,new cljs.core.Keyword(null,"block","block",664686210));
var inst_19754__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_19751,inst_19752,inst_19753);
var inst_19755 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_19756 = [inst_19752,inst_19753,garbage];
var inst_19757 = cljs.core.PersistentHashMap.fromArrays(inst_19755,inst_19756);
var inst_19758 = fluree.db.storage.core.serde.call(null,inst_19750);
var inst_19759 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_19758,inst_19757);
var inst_19760 = fluree.db.storage.core.storage_write.call(null,inst_19750,inst_19754__$1,inst_19759);
var state_19768__$1 = (function (){var statearr_19790 = state_19768;
(statearr_19790[(7)] = inst_19754__$1);

return statearr_19790;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19768__$1,(15),inst_19760);
} else {
if((state_val_19769 === (10))){
var state_19768__$1 = state_19768;
var statearr_19791_19813 = state_19768__$1;
(statearr_19791_19813[(2)] = false);

(statearr_19791_19813[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19769 === (8))){
var inst_19744 = (state_19768[(2)]);
var state_19768__$1 = state_19768;
if(cljs.core.truth_(inst_19744)){
var statearr_19792_19814 = state_19768__$1;
(statearr_19792_19814[(1)] = (12));

} else {
var statearr_19793_19815 = state_19768__$1;
(statearr_19793_19815[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____0 = (function (){
var statearr_19794 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19794[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__);

(statearr_19794[(1)] = (1));

return statearr_19794;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____1 = (function (state_19768){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19795){var ex__2457__auto__ = e19795;
var statearr_19796_19816 = state_19768;
(statearr_19796_19816[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19768[(4)]))){
var statearr_19797_19817 = state_19768;
(statearr_19797_19817[(1)] = cljs.core.first.call(null,(state_19768[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19818 = state_19768;
state_19768 = G__19818;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__ = function(state_19768){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____1.call(this,state_19768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2454__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19798 = f__2477__auto__.call(null);
(statearr_19798[(6)] = c__2476__auto__);

return statearr_19798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__19820 = arguments.length;
switch (G__19820) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19896){
var state_val_19897 = (state_19896[(1)]);
if((state_val_19897 === (7))){
var state_19896__$1 = state_19896;
var statearr_19898_19937 = state_19896__$1;
(statearr_19898_19937[(2)] = false);

(statearr_19898_19937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (20))){
var inst_19853 = (state_19896[(7)]);
var inst_19870 = (state_19896[(8)]);
var inst_19860 = (state_19896[(9)]);
var inst_19861 = (state_19896[(10)]);
var inst_19854 = (state_19896[(11)]);
var inst_19856 = (state_19896[(12)]);
var inst_19852 = (state_19896[(13)]);
var inst_19858 = (state_19896[(14)]);
var inst_19855 = (state_19896[(15)]);
var inst_19862 = (state_19896[(16)]);
var inst_19864 = (state_19896[(17)]);
var inst_19863 = (state_19896[(18)]);
var inst_19851 = (state_19896[(19)]);
var inst_19865 = (state_19896[(20)]);
var inst_19875 = (state_19896[(2)]);
var inst_19876 = fluree.db.storage.core.child_data.call(null,inst_19860);
var inst_19877 = fluree.db.storage.core.child_data.call(null,inst_19862);
var inst_19878 = fluree.db.util.core.current_time_millis.call(null);
var inst_19879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19880 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_19881 = (new cljs.core.PersistentVector(null,2,(5),inst_19879,inst_19880,null));
var inst_19882 = cljs.core.select_keys.call(null,inst_19854,inst_19881);
var inst_19883 = fluree.db.storage.core.child_data.call(null,inst_19853);
var inst_19884 = [inst_19856,inst_19865,inst_19858,inst_19870,inst_19875,inst_19876,inst_19877,inst_19851,inst_19878,inst_19852,inst_19861,inst_19882,inst_19883];
var inst_19885 = cljs.core.PersistentHashMap.fromArrays(inst_19864,inst_19884);
var inst_19886 = fluree.db.storage.core.serde.call(null,inst_19855);
var inst_19887 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_19886,inst_19885);
var inst_19888 = fluree.db.storage.core.storage_write.call(null,inst_19855,inst_19863,inst_19887);
var state_19896__$1 = state_19896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19896__$1,(21),inst_19888);
} else {
if((state_val_19897 === (1))){
var state_19896__$1 = state_19896;
var statearr_19899_19938 = state_19896__$1;
(statearr_19899_19938[(2)] = null);

(statearr_19899_19938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (4))){
var inst_19821 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19900_19939 = state_19896__$1;
(statearr_19900_19939[(2)] = inst_19821);

(statearr_19900_19939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (15))){
var inst_19866 = (state_19896[(21)]);
var state_19896__$1 = state_19896;
var statearr_19901_19940 = state_19896__$1;
(statearr_19901_19940[(2)] = inst_19866);

(statearr_19901_19940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (21))){
var inst_19863 = (state_19896[(18)]);
var inst_19890 = (state_19896[(2)]);
var inst_19891 = fluree.db.util.async.throw_err.call(null,inst_19890);
var _ = (function (){var statearr_19902 = state_19896;
(statearr_19902[(4)] = cljs.core.rest.call(null,(state_19896[(4)])));

return statearr_19902;
})();
var state_19896__$1 = (function (){var statearr_19903 = state_19896;
(statearr_19903[(22)] = inst_19891);

return statearr_19903;
})();
var statearr_19904_19941 = state_19896__$1;
(statearr_19904_19941[(2)] = inst_19863);

(statearr_19904_19941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (13))){
var inst_19828 = (state_19896[(23)]);
var state_19896__$1 = state_19896;
var statearr_19905_19942 = state_19896__$1;
(statearr_19905_19942[(2)] = inst_19828);

(statearr_19905_19942[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (6))){
var inst_19828 = (state_19896[(23)]);
var inst_19833 = inst_19828.cljs$lang$protocol_mask$partition0$;
var inst_19834 = (inst_19833 & (64));
var inst_19835 = inst_19828.cljs$core$ISeq$;
var inst_19836 = (cljs.core.PROTOCOL_SENTINEL === inst_19835);
var inst_19837 = ((inst_19834) || (inst_19836));
var state_19896__$1 = state_19896;
if(cljs.core.truth_(inst_19837)){
var statearr_19906_19943 = state_19896__$1;
(statearr_19906_19943[(1)] = (9));

} else {
var statearr_19907_19944 = state_19896__$1;
(statearr_19907_19944[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (17))){
var inst_19871 = (state_19896[(24)]);
var inst_19870 = (state_19896[(2)]);
var inst_19871__$1 = custom_ecount;
var state_19896__$1 = (function (){var statearr_19908 = state_19896;
(statearr_19908[(8)] = inst_19870);

(statearr_19908[(24)] = inst_19871__$1);

return statearr_19908;
})();
if(cljs.core.truth_(inst_19871__$1)){
var statearr_19909_19945 = state_19896__$1;
(statearr_19909_19945[(1)] = (18));

} else {
var statearr_19910_19946 = state_19896__$1;
(statearr_19910_19946[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (3))){
var inst_19894 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19896__$1,inst_19894);
} else {
if((state_val_19897 === (12))){
var inst_19828 = (state_19896[(23)]);
var inst_19846 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19828);
var state_19896__$1 = state_19896;
var statearr_19911_19947 = state_19896__$1;
(statearr_19911_19947[(2)] = inst_19846);

(statearr_19911_19947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (2))){
var inst_19828 = (state_19896[(23)]);
var _ = (function (){var statearr_19912 = state_19896;
(statearr_19912[(4)] = cljs.core.cons.call(null,(5),(state_19896[(4)])));

return statearr_19912;
})();
var inst_19828__$1 = db;
var inst_19830 = (inst_19828__$1 == null);
var inst_19831 = cljs.core.not.call(null,inst_19830);
var state_19896__$1 = (function (){var statearr_19913 = state_19896;
(statearr_19913[(23)] = inst_19828__$1);

return statearr_19913;
})();
if(inst_19831){
var statearr_19914_19948 = state_19896__$1;
(statearr_19914_19948[(1)] = (6));

} else {
var statearr_19915_19949 = state_19896__$1;
(statearr_19915_19949[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (19))){
var inst_19859 = (state_19896[(25)]);
var state_19896__$1 = state_19896;
var statearr_19916_19950 = state_19896__$1;
(statearr_19916_19950[(2)] = inst_19859);

(statearr_19916_19950[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (11))){
var inst_19841 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19918_19951 = state_19896__$1;
(statearr_19918_19951[(2)] = inst_19841);

(statearr_19918_19951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (9))){
var state_19896__$1 = state_19896;
var statearr_19919_19952 = state_19896__$1;
(statearr_19919_19952[(2)] = true);

(statearr_19919_19952[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (5))){
var _ = (function (){var statearr_19920 = state_19896;
(statearr_19920[(4)] = cljs.core.rest.call(null,(state_19896[(4)])));

return statearr_19920;
})();
var state_19896__$1 = state_19896;
var ex19917 = (state_19896__$1[(2)]);
var statearr_19921_19953 = state_19896__$1;
(statearr_19921_19953[(5)] = ex19917);


if((ex19917 instanceof Error)){
var statearr_19922_19954 = state_19896__$1;
(statearr_19922_19954[(1)] = (4));

(statearr_19922_19954[(5)] = null);

} else {
throw ex19917;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (14))){
var inst_19854 = (state_19896[(11)]);
var inst_19856 = (state_19896[(12)]);
var inst_19858 = (state_19896[(14)]);
var inst_19866 = (state_19896[(21)]);
var inst_19849 = (state_19896[(2)]);
var inst_19850 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_19851 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_19852 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_19853 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_19854__$1 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_19855 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_19856__$1 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"block","block",664686210));
var inst_19857 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_19858__$1 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_19859 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_19860 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_19861 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_19862 = cljs.core.get.call(null,inst_19849,new cljs.core.Keyword(null,"post","post",269697687));
var inst_19863 = fluree.db.storage.core.ledger_root_key.call(null,inst_19850,inst_19858__$1,inst_19856__$1);
var inst_19864 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_19865 = fluree.db.storage.core.child_data.call(null,inst_19857);
var inst_19866__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_19854__$1);
var state_19896__$1 = (function (){var statearr_19923 = state_19896;
(statearr_19923[(7)] = inst_19853);

(statearr_19923[(9)] = inst_19860);

(statearr_19923[(25)] = inst_19859);

(statearr_19923[(10)] = inst_19861);

(statearr_19923[(11)] = inst_19854__$1);

(statearr_19923[(12)] = inst_19856__$1);

(statearr_19923[(13)] = inst_19852);

(statearr_19923[(14)] = inst_19858__$1);

(statearr_19923[(15)] = inst_19855);

(statearr_19923[(16)] = inst_19862);

(statearr_19923[(17)] = inst_19864);

(statearr_19923[(18)] = inst_19863);

(statearr_19923[(19)] = inst_19851);

(statearr_19923[(21)] = inst_19866__$1);

(statearr_19923[(20)] = inst_19865);

return statearr_19923;
})();
if(cljs.core.truth_(inst_19866__$1)){
var statearr_19924_19955 = state_19896__$1;
(statearr_19924_19955[(1)] = (15));

} else {
var statearr_19925_19956 = state_19896__$1;
(statearr_19925_19956[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (16))){
var state_19896__$1 = state_19896;
var statearr_19926_19957 = state_19896__$1;
(statearr_19926_19957[(2)] = (0));

(statearr_19926_19957[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (10))){
var state_19896__$1 = state_19896;
var statearr_19927_19958 = state_19896__$1;
(statearr_19927_19958[(2)] = false);

(statearr_19927_19958[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (18))){
var inst_19871 = (state_19896[(24)]);
var state_19896__$1 = state_19896;
var statearr_19928_19959 = state_19896__$1;
(statearr_19928_19959[(2)] = inst_19871);

(statearr_19928_19959[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (8))){
var inst_19844 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
if(cljs.core.truth_(inst_19844)){
var statearr_19929_19960 = state_19896__$1;
(statearr_19929_19960[(1)] = (12));

} else {
var statearr_19930_19961 = state_19896__$1;
(statearr_19930_19961[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2454__auto__ = null;
var fluree$db$storage$core$state_machine__2454__auto____0 = (function (){
var statearr_19931 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19931[(0)] = fluree$db$storage$core$state_machine__2454__auto__);

(statearr_19931[(1)] = (1));

return statearr_19931;
});
var fluree$db$storage$core$state_machine__2454__auto____1 = (function (state_19896){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19932){var ex__2457__auto__ = e19932;
var statearr_19933_19962 = state_19896;
(statearr_19933_19962[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19896[(4)]))){
var statearr_19934_19963 = state_19896;
(statearr_19934_19963[(1)] = cljs.core.first.call(null,(state_19896[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19964 = state_19896;
state_19896 = G__19964;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2454__auto__ = function(state_19896){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2454__auto____1.call(this,state_19896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2454__auto____0;
fluree$db$storage$core$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2454__auto____1;
return fluree$db$storage$core$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19935 = f__2477__auto__.call(null);
(statearr_19935[(6)] = c__2476__auto__);

return statearr_19935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2476__auto___20016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19994){
var state_val_19995 = (state_19994[(1)]);
if((state_val_19995 === (7))){
var inst_19981 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_19994__$1 = state_19994;
var statearr_19996_20017 = state_19994__$1;
(statearr_19996_20017[(2)] = inst_19981);

(statearr_19996_20017[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (1))){
var state_19994__$1 = state_19994;
var statearr_19997_20018 = state_19994__$1;
(statearr_19997_20018[(2)] = null);

(statearr_19997_20018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (4))){
var inst_19965 = (state_19994[(2)]);
var inst_19966 = error_fn.call(null);
var inst_19967 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19965);
var inst_19968 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_19994__$1 = (function (){var statearr_19998 = state_19994;
(statearr_19998[(7)] = inst_19966);

(statearr_19998[(8)] = inst_19967);

return statearr_19998;
})();
var statearr_19999_20019 = state_19994__$1;
(statearr_19999_20019[(2)] = inst_19968);

(statearr_19999_20019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (6))){
var inst_19976 = (state_19994[(9)]);
var inst_19976__$1 = (state_19994[(2)]);
var inst_19977 = (inst_19976__$1 == null);
var inst_19978 = (inst_19976__$1 instanceof Error);
var inst_19979 = ((inst_19977) || (inst_19978));
var state_19994__$1 = (function (){var statearr_20000 = state_19994;
(statearr_20000[(9)] = inst_19976__$1);

return statearr_20000;
})();
if(cljs.core.truth_(inst_19979)){
var statearr_20001_20020 = state_19994__$1;
(statearr_20001_20020[(1)] = (7));

} else {
var statearr_20002_20021 = state_19994__$1;
(statearr_20002_20021[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (3))){
var inst_19992 = (state_19994[(2)]);
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19994__$1,inst_19992);
} else {
if((state_val_19995 === (2))){
var _ = (function (){var statearr_20004 = state_19994;
(statearr_20004[(4)] = cljs.core.cons.call(null,(5),(state_19994[(4)])));

return statearr_20004;
})();
var inst_19974 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_19994__$1 = state_19994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19994__$1,(6),inst_19974);
} else {
if((state_val_19995 === (9))){
var inst_19989 = (state_19994[(2)]);
var _ = (function (){var statearr_20005 = state_19994;
(statearr_20005[(4)] = cljs.core.rest.call(null,(state_19994[(4)])));

return statearr_20005;
})();
var state_19994__$1 = state_19994;
var statearr_20006_20022 = state_19994__$1;
(statearr_20006_20022[(2)] = inst_19989);

(statearr_20006_20022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (5))){
var _ = (function (){var statearr_20007 = state_19994;
(statearr_20007[(4)] = cljs.core.rest.call(null,(state_19994[(4)])));

return statearr_20007;
})();
var state_19994__$1 = state_19994;
var ex20003 = (state_19994__$1[(2)]);
var statearr_20008_20023 = state_19994__$1;
(statearr_20008_20023[(5)] = ex20003);


if((ex20003 instanceof java.lang.Exception)){
var statearr_20009_20024 = state_19994__$1;
(statearr_20009_20024[(1)] = (4));

(statearr_20009_20024[(5)] = null);

} else {
throw ex20003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19995 === (8))){
var inst_19976 = (state_19994[(9)]);
var inst_19983 = fluree.db.storage.core.serde.call(null,conn);
var inst_19984 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_19983,inst_19976);
var inst_19985 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_19984);
var inst_19986 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_19985);
var inst_19987 = cljs.core.async.put_BANG_.call(null,return_ch,inst_19986);
var state_19994__$1 = state_19994;
var statearr_20010_20025 = state_19994__$1;
(statearr_20010_20025[(2)] = inst_19987);

(statearr_20010_20025[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2454__auto____0 = (function (){
var statearr_20011 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20011[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2454__auto__);

(statearr_20011[(1)] = (1));

return statearr_20011;
});
var fluree$db$storage$core$reify_history_$_state_machine__2454__auto____1 = (function (state_19994){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20012){var ex__2457__auto__ = e20012;
var statearr_20013_20026 = state_19994;
(statearr_20013_20026[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19994[(4)]))){
var statearr_20014_20027 = state_19994;
(statearr_20014_20027[(1)] = cljs.core.first.call(null,(state_19994[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20028 = state_19994;
state_19994 = G__20028;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2454__auto__ = function(state_19994){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2454__auto____1.call(this,state_19994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2454__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2454__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20015 = f__2477__auto__.call(null);
(statearr_20015[(6)] = c__2476__auto___20016);

return statearr_20015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__20030 = arguments.length;
switch (G__20030) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2476__auto___20140 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20093){
var state_val_20094 = (state_20093[(1)]);
if((state_val_20094 === (7))){
var state_20093__$1 = state_20093;
var statearr_20095_20141 = state_20093__$1;
(statearr_20095_20141[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_20095_20141[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (20))){
var inst_20072 = cljs.core.PersistentVector.EMPTY;
var state_20093__$1 = state_20093;
var statearr_20096_20142 = state_20093__$1;
(statearr_20096_20142[(2)] = inst_20072);

(statearr_20096_20142[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (1))){
var state_20093__$1 = state_20093;
var statearr_20097_20143 = state_20093__$1;
(statearr_20097_20143[(2)] = null);

(statearr_20097_20143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (24))){
var state_20093__$1 = state_20093;
var statearr_20098_20144 = state_20093__$1;
(statearr_20098_20144[(2)] = null);

(statearr_20098_20144[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (4))){
var inst_20033 = (state_20093[(2)]);
var inst_20034 = error_fn.call(null);
var inst_20035 = cljs.core.async.put_BANG_.call(null,result_ch,inst_20033);
var inst_20036 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_20093__$1 = (function (){var statearr_20099 = state_20093;
(statearr_20099[(7)] = inst_20035);

(statearr_20099[(8)] = inst_20034);

return statearr_20099;
})();
var statearr_20100_20145 = state_20093__$1;
(statearr_20100_20145[(2)] = inst_20036);

(statearr_20100_20145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (15))){
var inst_20058 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
var statearr_20101_20146 = state_20093__$1;
(statearr_20101_20146[(2)] = inst_20058);

(statearr_20101_20146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (21))){
var inst_20062 = (state_20093[(9)]);
var inst_20047 = (state_20093[(10)]);
var inst_20046 = (state_20093[(11)]);
var inst_20045 = (state_20093[(12)]);
var inst_20075 = (state_20093[(13)]);
var inst_20082 = (state_20093[(2)]);
var inst_20083 = (function (){var base_node = inst_20045;
var first_flake = inst_20046;
var node_t = inst_20047;
var source = inst_20062;
var coll = inst_20075;
var conj_QMARK_ = inst_20082;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_20084 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20045);
var inst_20085 = cljs.core.reduce.call(null,inst_20083,inst_20084,inst_20075);
var inst_20086 = cljs.core.doall.call(null,inst_20085);
var inst_20087 = cljs.core.assoc.call(null,inst_20045,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_20086);
var inst_20088 = cljs.core.async.put_BANG_.call(null,result_ch,inst_20087);
var _ = (function (){var statearr_20102 = state_20093;
(statearr_20102[(4)] = cljs.core.rest.call(null,(state_20093[(4)])));

return statearr_20102;
})();
var state_20093__$1 = state_20093;
var statearr_20103_20147 = state_20093__$1;
(statearr_20103_20147[(2)] = inst_20088);

(statearr_20103_20147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (13))){
var state_20093__$1 = state_20093;
var statearr_20104_20148 = state_20093__$1;
(statearr_20104_20148[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_20104_20148[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (22))){
var inst_20062 = (state_20093[(9)]);
var inst_20047 = (state_20093[(10)]);
var inst_20046 = (state_20093[(11)]);
var inst_20045 = (state_20093[(12)]);
var inst_20075 = (state_20093[(13)]);
var inst_20076 = (function (){var base_node = inst_20045;
var first_flake = inst_20046;
var node_t = inst_20047;
var source = inst_20062;
var coll = inst_20075;
return (function (f){
return f.op === true;
});
})();
var state_20093__$1 = state_20093;
var statearr_20105_20149 = state_20093__$1;
(statearr_20105_20149[(2)] = inst_20076);

(statearr_20105_20149[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (6))){
var inst_20047 = (state_20093[(10)]);
var inst_20045 = (state_20093[(12)]);
var inst_20044 = (state_20093[(2)]);
var inst_20045__$1 = fluree.db.util.async.throw_err.call(null,inst_20044);
var inst_20046 = fluree.db.dbproto._first_flake.call(null,inst_20045__$1);
var inst_20047__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_20045__$1);
var inst_20048 = (inst_20047__$1 > t);
var state_20093__$1 = (function (){var statearr_20106 = state_20093;
(statearr_20106[(10)] = inst_20047__$1);

(statearr_20106[(11)] = inst_20046);

(statearr_20106[(12)] = inst_20045__$1);

return statearr_20106;
})();
if(cljs.core.truth_(inst_20048)){
var statearr_20107_20150 = state_20093__$1;
(statearr_20107_20150[(1)] = (7));

} else {
var statearr_20108_20151 = state_20093__$1;
(statearr_20108_20151[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (17))){
var inst_20046 = (state_20093[(11)]);
var inst_20063 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_20046,rhs,leftmost_QMARK_,t);
var state_20093__$1 = state_20093;
var statearr_20109_20152 = state_20093__$1;
(statearr_20109_20152[(2)] = inst_20063);

(statearr_20109_20152[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (3))){
var inst_20091 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20093__$1,inst_20091);
} else {
if((state_val_20094 === (12))){
var inst_20060 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
var statearr_20110_20153 = state_20093__$1;
(statearr_20110_20153[(2)] = inst_20060);

(statearr_20110_20153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (2))){
var _ = (function (){var statearr_20111 = state_20093;
(statearr_20111[(4)] = cljs.core.cons.call(null,(5),(state_20093[(4)])));

return statearr_20111;
})();
var inst_20042 = fluree.db.dbproto._resolve.call(null,node);
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20093__$1,(6),inst_20042);
} else {
if((state_val_20094 === (23))){
var inst_20062 = (state_20093[(9)]);
var inst_20047 = (state_20093[(10)]);
var inst_20046 = (state_20093[(11)]);
var inst_20045 = (state_20093[(12)]);
var inst_20075 = (state_20093[(13)]);
var inst_20078 = (function (){var base_node = inst_20045;
var first_flake = inst_20046;
var node_t = inst_20047;
var source = inst_20062;
var coll = inst_20075;
return (function (f){
return f.op === false;
});
})();
var state_20093__$1 = state_20093;
var statearr_20112_20154 = state_20093__$1;
(statearr_20112_20154[(2)] = inst_20078);

(statearr_20112_20154[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (19))){
var inst_20065 = (state_20093[(14)]);
var inst_20068 = (state_20093[(2)]);
var inst_20069 = fluree.db.util.async.throw_err.call(null,inst_20068);
var inst_20070 = cljs.core.take_while.call(null,inst_20065,inst_20069);
var state_20093__$1 = state_20093;
var statearr_20113_20155 = state_20093__$1;
(statearr_20113_20155[(2)] = inst_20070);

(statearr_20113_20155[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (11))){
var inst_20047 = (state_20093[(10)]);
var inst_20054 = cljs.core._EQ_.call(null,inst_20047,t);
var state_20093__$1 = state_20093;
if(inst_20054){
var statearr_20115_20156 = state_20093__$1;
(statearr_20115_20156[(1)] = (13));

} else {
var statearr_20116_20157 = state_20093__$1;
(statearr_20116_20157[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (9))){
var inst_20062 = (state_20093[(9)]);
var inst_20062__$1 = (state_20093[(2)]);
var state_20093__$1 = (function (){var statearr_20117 = state_20093;
(statearr_20117[(9)] = inst_20062__$1);

return statearr_20117;
})();
var G__20118_20158 = inst_20062__$1;
var G__20118_20159__$1 = (((G__20118_20158 instanceof cljs.core.Keyword))?G__20118_20158.fqn:null);
switch (G__20118_20159__$1) {
case "novelty":
var statearr_20119_20161 = state_20093__$1;
(statearr_20119_20161[(1)] = (17));


break;
case "history":
var statearr_20120_20162 = state_20093__$1;
(statearr_20120_20162[(1)] = (18));


break;
case "none":
var statearr_20121_20163 = state_20093__$1;
(statearr_20121_20163[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20118_20159__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (5))){
var _ = (function (){var statearr_20122 = state_20093;
(statearr_20122[(4)] = cljs.core.rest.call(null,(state_20093[(4)])));

return statearr_20122;
})();
var state_20093__$1 = state_20093;
var ex20114 = (state_20093__$1[(2)]);
var statearr_20123_20164 = state_20093__$1;
(statearr_20123_20164[(5)] = ex20114);


if((ex20114 instanceof java.lang.Exception)){
var statearr_20124_20165 = state_20093__$1;
(statearr_20124_20165[(1)] = (4));

(statearr_20124_20165[(5)] = null);

} else {
throw ex20114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (14))){
var state_20093__$1 = state_20093;
var statearr_20125_20166 = state_20093__$1;
(statearr_20125_20166[(2)] = null);

(statearr_20125_20166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (16))){
var inst_20062 = (state_20093[(9)]);
var inst_20075 = (state_20093[(2)]);
var state_20093__$1 = (function (){var statearr_20126 = state_20093;
(statearr_20126[(13)] = inst_20075);

return statearr_20126;
})();
var G__20127_20167 = inst_20062;
var G__20127_20168__$1 = (((G__20127_20167 instanceof cljs.core.Keyword))?G__20127_20167.fqn:null);
switch (G__20127_20168__$1) {
case "novelty":
var statearr_20128_20170 = state_20093__$1;
(statearr_20128_20170[(1)] = (22));


break;
case "history":
var statearr_20129_20171 = state_20093__$1;
(statearr_20129_20171[(1)] = (23));


break;
case "none":
var statearr_20130_20172 = state_20093__$1;
(statearr_20130_20172[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20127_20168__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (10))){
var state_20093__$1 = state_20093;
var statearr_20131_20173 = state_20093__$1;
(statearr_20131_20173[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_20131_20173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (18))){
var inst_20062 = (state_20093[(9)]);
var inst_20047 = (state_20093[(10)]);
var inst_20046 = (state_20093[(11)]);
var inst_20045 = (state_20093[(12)]);
var inst_20065 = (function (){var base_node = inst_20045;
var first_flake = inst_20046;
var node_t = inst_20047;
var source = inst_20062;
return (function (p1__20032_SHARP_){
return (p1__20032_SHARP_.t <= t);
});
})();
var inst_20066 = fluree.db.dbproto._resolve_history.call(null,node);
var state_20093__$1 = (function (){var statearr_20132 = state_20093;
(statearr_20132[(14)] = inst_20065);

return statearr_20132;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20093__$1,(19),inst_20066);
} else {
if((state_val_20094 === (8))){
var inst_20047 = (state_20093[(10)]);
var inst_20051 = (inst_20047 < t);
var state_20093__$1 = state_20093;
if(cljs.core.truth_(inst_20051)){
var statearr_20133_20174 = state_20093__$1;
(statearr_20133_20174[(1)] = (10));

} else {
var statearr_20134_20175 = state_20093__$1;
(statearr_20134_20175[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____0 = (function (){
var statearr_20135 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20135[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__);

(statearr_20135[(1)] = (1));

return statearr_20135;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____1 = (function (state_20093){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20136){var ex__2457__auto__ = e20136;
var statearr_20137_20176 = state_20093;
(statearr_20137_20176[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20093[(4)]))){
var statearr_20138_20177 = state_20093;
(statearr_20138_20177[(1)] = cljs.core.first.call(null,(state_20093[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20178 = state_20093;
state_20093 = G__20178;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__ = function(state_20093){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____1.call(this,state_20093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2454__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20139 = f__2477__auto__.call(null);
(statearr_20139[(6)] = c__2476__auto___20140);

return statearr_20139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20235){
var state_val_20236 = (state_20235[(1)]);
if((state_val_20236 === (7))){
var state_20235__$1 = state_20235;
var statearr_20237_20273 = state_20235__$1;
(statearr_20237_20273[(2)] = null);

(statearr_20237_20273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (1))){
var state_20235__$1 = state_20235;
var statearr_20238_20274 = state_20235__$1;
(statearr_20238_20274[(2)] = null);

(statearr_20238_20274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (4))){
var inst_20181 = (state_20235[(2)]);
var inst_20182 = fluree.db.util.log.error.call(null,inst_20181);
var inst_20183 = (function(){throw inst_20181})();
var state_20235__$1 = (function (){var statearr_20239 = state_20235;
(statearr_20239[(7)] = inst_20182);

return statearr_20239;
})();
var statearr_20240_20275 = state_20235__$1;
(statearr_20240_20275[(2)] = inst_20183);

(statearr_20240_20275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (15))){
var inst_20211 = (state_20235[(2)]);
var state_20235__$1 = state_20235;
var statearr_20241_20276 = state_20235__$1;
(statearr_20241_20276[(2)] = inst_20211);

(statearr_20241_20276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (13))){
var inst_20189 = (state_20235[(8)]);
var inst_20205 = (state_20235[(9)]);
var inst_20207 = (function (){var node_t = inst_20189;
var G__20194 = inst_20205;
return (function (p1__20180_SHARP_){
return (p1__20180_SHARP_.t <= from_t);
});
})();
var inst_20208 = cljs.core.take_while.call(null,inst_20207,inst_20205);
var state_20235__$1 = state_20235;
var statearr_20242_20277 = state_20235__$1;
(statearr_20242_20277[(2)] = inst_20208);

(statearr_20242_20277[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (6))){
var inst_20195 = fluree.db.dbproto._resolve_history.call(null,node);
var state_20235__$1 = state_20235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20235__$1,(9),inst_20195);
} else {
if((state_val_20236 === (17))){
var inst_20220 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_20221 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20220)].join('');
var inst_20222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20223 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_20224 = cljs.core.PersistentHashMap.fromArrays(inst_20222,inst_20223);
var inst_20225 = cljs.core.ex_info.call(null,inst_20221,inst_20224);
var inst_20226 = (function(){throw inst_20225})();
var state_20235__$1 = state_20235;
var statearr_20243_20278 = state_20235__$1;
(statearr_20243_20278[(2)] = inst_20226);

(statearr_20243_20278[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (3))){
var inst_20233 = (state_20235[(2)]);
var state_20235__$1 = state_20235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20235__$1,inst_20233);
} else {
if((state_val_20236 === (12))){
var inst_20205 = (state_20235[(2)]);
var state_20235__$1 = (function (){var statearr_20244 = state_20235;
(statearr_20244[(9)] = inst_20205);

return statearr_20244;
})();
if(cljs.core.truth_(from_t)){
var statearr_20245_20279 = state_20235__$1;
(statearr_20245_20279[(1)] = (13));

} else {
var statearr_20246_20280 = state_20235__$1;
(statearr_20246_20280[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (2))){
var inst_20189 = (state_20235[(8)]);
var _ = (function (){var statearr_20247 = state_20235;
(statearr_20247[(4)] = cljs.core.cons.call(null,(5),(state_20235[(4)])));

return statearr_20247;
})();
var inst_20189__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_20190 = (from_t == null);
var inst_20191 = (inst_20189__$1 <= from_t);
var inst_20192 = ((inst_20190) || (inst_20191));
var state_20235__$1 = (function (){var statearr_20248 = state_20235;
(statearr_20248[(8)] = inst_20189__$1);

return statearr_20248;
})();
if(cljs.core.truth_(inst_20192)){
var statearr_20249_20281 = state_20235__$1;
(statearr_20249_20281[(1)] = (6));

} else {
var statearr_20250_20282 = state_20235__$1;
(statearr_20250_20282[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (11))){
var inst_20198 = (state_20235[(10)]);
var state_20235__$1 = state_20235;
var statearr_20252_20283 = state_20235__$1;
(statearr_20252_20283[(2)] = inst_20198);

(statearr_20252_20283[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (9))){
var inst_20189 = (state_20235[(8)]);
var inst_20197 = (state_20235[(2)]);
var inst_20198 = fluree.db.util.async.throw_err.call(null,inst_20197);
var inst_20199 = (to_t > inst_20189);
var state_20235__$1 = (function (){var statearr_20253 = state_20235;
(statearr_20253[(10)] = inst_20198);

return statearr_20253;
})();
if(cljs.core.truth_(inst_20199)){
var statearr_20254_20284 = state_20235__$1;
(statearr_20254_20284[(1)] = (10));

} else {
var statearr_20255_20285 = state_20235__$1;
(statearr_20255_20285[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (5))){
var _ = (function (){var statearr_20256 = state_20235;
(statearr_20256[(4)] = cljs.core.rest.call(null,(state_20235[(4)])));

return statearr_20256;
})();
var state_20235__$1 = state_20235;
var ex20251 = (state_20235__$1[(2)]);
var statearr_20257_20286 = state_20235__$1;
(statearr_20257_20286[(5)] = ex20251);


if((ex20251 instanceof java.lang.Exception)){
var statearr_20258_20287 = state_20235__$1;
(statearr_20258_20287[(1)] = (4));

(statearr_20258_20287[(5)] = null);

} else {
throw ex20251;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (14))){
var inst_20205 = (state_20235[(9)]);
var state_20235__$1 = state_20235;
var statearr_20259_20288 = state_20235__$1;
(statearr_20259_20288[(2)] = inst_20205);

(statearr_20259_20288[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (16))){
var state_20235__$1 = state_20235;
var statearr_20260_20289 = state_20235__$1;
(statearr_20260_20289[(2)] = null);

(statearr_20260_20289[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (10))){
var inst_20198 = (state_20235[(10)]);
var inst_20189 = (state_20235[(8)]);
var inst_20201 = (function (){var node_t = inst_20189;
var G__20194 = inst_20198;
return (function (p1__20179_SHARP_){
return (p1__20179_SHARP_.t < to_t);
});
})();
var inst_20202 = cljs.core.drop_while.call(null,inst_20201,inst_20198);
var state_20235__$1 = state_20235;
var statearr_20261_20290 = state_20235__$1;
(statearr_20261_20290[(2)] = inst_20202);

(statearr_20261_20290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (18))){
var inst_20216 = (state_20235[(11)]);
var inst_20215 = (state_20235[(12)]);
var inst_20214 = (state_20235[(13)]);
var inst_20228 = (state_20235[(2)]);
var inst_20229 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_20215,inst_20216,leftmost_QMARK_,to_t);
var inst_20230 = cljs.core.into.call(null,inst_20229,inst_20214);
var _ = (function (){var statearr_20262 = state_20235;
(statearr_20262[(4)] = cljs.core.rest.call(null,(state_20235[(4)])));

return statearr_20262;
})();
var state_20235__$1 = (function (){var statearr_20263 = state_20235;
(statearr_20263[(14)] = inst_20228);

return statearr_20263;
})();
var statearr_20264_20291 = state_20235__$1;
(statearr_20264_20291[(2)] = inst_20230);

(statearr_20264_20291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20236 === (8))){
var inst_20214 = (state_20235[(2)]);
var inst_20215 = fluree.db.dbproto._first_flake.call(null,node);
var inst_20216 = fluree.db.dbproto._rhs.call(null,node);
var inst_20217 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_20235__$1 = (function (){var statearr_20265 = state_20235;
(statearr_20265[(11)] = inst_20216);

(statearr_20265[(12)] = inst_20215);

(statearr_20265[(13)] = inst_20214);

return statearr_20265;
})();
if(cljs.core.truth_(inst_20217)){
var statearr_20266_20292 = state_20235__$1;
(statearr_20266_20292[(1)] = (16));

} else {
var statearr_20267_20293 = state_20235__$1;
(statearr_20267_20293[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____0 = (function (){
var statearr_20268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20268[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__);

(statearr_20268[(1)] = (1));

return statearr_20268;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____1 = (function (state_20235){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20269){var ex__2457__auto__ = e20269;
var statearr_20270_20294 = state_20235;
(statearr_20270_20294[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20235[(4)]))){
var statearr_20271_20295 = state_20235;
(statearr_20271_20295[(1)] = cljs.core.first.call(null,(state_20235[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20296 = state_20235;
state_20235 = G__20296;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__ = function(state_20235){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____1.call(this,state_20235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20272 = f__2477__auto__.call(null);
(statearr_20272[(6)] = c__2476__auto__);

return statearr_20272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20317){
var state_val_20318 = (state_20317[(1)]);
if((state_val_20318 === (7))){
var state_20317__$1 = state_20317;
var statearr_20319_20339 = state_20317__$1;
(statearr_20319_20339[(2)] = null);

(statearr_20319_20339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (1))){
var state_20317__$1 = state_20317;
var statearr_20320_20340 = state_20317__$1;
(statearr_20320_20340[(2)] = null);

(statearr_20320_20340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (4))){
var inst_20297 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20321_20341 = state_20317__$1;
(statearr_20321_20341[(2)] = inst_20297);

(statearr_20321_20341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (6))){
var inst_20303 = (state_20317[(7)]);
var inst_20305 = fluree.db.storage.core.serde.call(null,conn);
var state_20317__$1 = (function (){var statearr_20322 = state_20317;
(statearr_20322[(8)] = inst_20305);

return statearr_20322;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20317__$1,(9),inst_20303);
} else {
if((state_val_20318 === (3))){
var inst_20315 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20317__$1,inst_20315);
} else {
if((state_val_20318 === (2))){
var inst_20303 = (state_20317[(7)]);
var _ = (function (){var statearr_20324 = state_20317;
(statearr_20324[(4)] = cljs.core.cons.call(null,(5),(state_20317[(4)])));

return statearr_20324;
})();
var inst_20303__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_20317__$1 = (function (){var statearr_20325 = state_20317;
(statearr_20325[(7)] = inst_20303__$1);

return statearr_20325;
})();
if(cljs.core.truth_(inst_20303__$1)){
var statearr_20326_20342 = state_20317__$1;
(statearr_20326_20342[(1)] = (6));

} else {
var statearr_20327_20343 = state_20317__$1;
(statearr_20327_20343[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (9))){
var inst_20305 = (state_20317[(8)]);
var inst_20307 = (state_20317[(2)]);
var inst_20308 = fluree.db.util.async.throw_err.call(null,inst_20307);
var inst_20309 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_20305,inst_20308);
var state_20317__$1 = state_20317;
var statearr_20328_20344 = state_20317__$1;
(statearr_20328_20344[(2)] = inst_20309);

(statearr_20328_20344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (5))){
var _ = (function (){var statearr_20329 = state_20317;
(statearr_20329[(4)] = cljs.core.rest.call(null,(state_20317[(4)])));

return statearr_20329;
})();
var state_20317__$1 = state_20317;
var ex20323 = (state_20317__$1[(2)]);
var statearr_20330_20345 = state_20317__$1;
(statearr_20330_20345[(5)] = ex20323);


if((ex20323 instanceof Error)){
var statearr_20331_20346 = state_20317__$1;
(statearr_20331_20346[(1)] = (4));

(statearr_20331_20346[(5)] = null);

} else {
throw ex20323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (8))){
var inst_20312 = (state_20317[(2)]);
var _ = (function (){var statearr_20332 = state_20317;
(statearr_20332[(4)] = cljs.core.rest.call(null,(state_20317[(4)])));

return statearr_20332;
})();
var state_20317__$1 = state_20317;
var statearr_20333_20347 = state_20317__$1;
(statearr_20333_20347[(2)] = inst_20312);

(statearr_20333_20347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2454__auto____0 = (function (){
var statearr_20334 = [null,null,null,null,null,null,null,null,null];
(statearr_20334[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2454__auto__);

(statearr_20334[(1)] = (1));

return statearr_20334;
});
var fluree$db$storage$core$read_branch_$_state_machine__2454__auto____1 = (function (state_20317){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20335){var ex__2457__auto__ = e20335;
var statearr_20336_20348 = state_20317;
(statearr_20336_20348[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20317[(4)]))){
var statearr_20337_20349 = state_20317;
(statearr_20337_20349[(1)] = cljs.core.first.call(null,(state_20317[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20350 = state_20317;
state_20317 = G__20350;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2454__auto__ = function(state_20317){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2454__auto____1.call(this,state_20317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20338 = f__2477__auto__.call(null);
(statearr_20338[(6)] = c__2476__auto__);

return statearr_20338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2476__auto___20496 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20441){
var state_val_20442 = (state_20441[(1)]);
if((state_val_20442 === (7))){
var inst_20368 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_20369 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20370 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_20371 = cljs.core.PersistentHashMap.fromArrays(inst_20369,inst_20370);
var inst_20372 = cljs.core.ex_info.call(null,inst_20368,inst_20371);
var inst_20373 = (function(){throw inst_20372})();
var state_20441__$1 = state_20441;
var statearr_20443_20497 = state_20441__$1;
(statearr_20443_20497[(2)] = inst_20373);

(statearr_20443_20497[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (20))){
var inst_20365 = (state_20441[(7)]);
var state_20441__$1 = state_20441;
var statearr_20444_20498 = state_20441__$1;
(statearr_20444_20498[(2)] = inst_20365);

(statearr_20444_20498[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (27))){
var inst_20419 = (state_20441[(2)]);
var state_20441__$1 = state_20441;
var statearr_20445_20499 = state_20441__$1;
(statearr_20445_20499[(2)] = inst_20419);

(statearr_20445_20499[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (1))){
var state_20441__$1 = state_20441;
var statearr_20446_20500 = state_20441__$1;
(statearr_20446_20500[(2)] = null);

(statearr_20446_20500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (24))){
var inst_20422 = (state_20441[(2)]);
var state_20441__$1 = state_20441;
if(cljs.core.truth_(inst_20422)){
var statearr_20447_20501 = state_20441__$1;
(statearr_20447_20501[(1)] = (28));

} else {
var statearr_20448_20502 = state_20441__$1;
(statearr_20448_20502[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (4))){
var inst_20351 = (state_20441[(2)]);
var inst_20352 = error_fn.call(null);
var inst_20353 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20351);
var inst_20354 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20441__$1 = (function (){var statearr_20449 = state_20441;
(statearr_20449[(8)] = inst_20352);

(statearr_20449[(9)] = inst_20353);

return statearr_20449;
})();
var statearr_20450_20503 = state_20441__$1;
(statearr_20450_20503[(2)] = inst_20354);

(statearr_20450_20503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (15))){
var inst_20398 = (state_20441[(2)]);
var state_20441__$1 = state_20441;
if(cljs.core.truth_(inst_20398)){
var statearr_20451_20504 = state_20441__$1;
(statearr_20451_20504[(1)] = (19));

} else {
var statearr_20452_20505 = state_20441__$1;
(statearr_20452_20505[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (21))){
var inst_20403 = (state_20441[(10)]);
var inst_20406 = (state_20441[(11)]);
var inst_20403__$1 = (state_20441[(2)]);
var inst_20404 = cljs.core.get.call(null,inst_20403__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_20405 = cljs.core.get.call(null,inst_20403__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_20406__$1 = config;
var inst_20408 = (inst_20406__$1 == null);
var inst_20409 = cljs.core.not.call(null,inst_20408);
var state_20441__$1 = (function (){var statearr_20453 = state_20441;
(statearr_20453[(12)] = inst_20404);

(statearr_20453[(10)] = inst_20403__$1);

(statearr_20453[(11)] = inst_20406__$1);

(statearr_20453[(13)] = inst_20405);

return statearr_20453;
})();
if(inst_20409){
var statearr_20454_20506 = state_20441__$1;
(statearr_20454_20506[(1)] = (22));

} else {
var statearr_20455_20507 = state_20441__$1;
(statearr_20455_20507[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (13))){
var inst_20365 = (state_20441[(7)]);
var inst_20387 = inst_20365.cljs$lang$protocol_mask$partition0$;
var inst_20388 = (inst_20387 & (64));
var inst_20389 = inst_20365.cljs$core$ISeq$;
var inst_20390 = (cljs.core.PROTOCOL_SENTINEL === inst_20389);
var inst_20391 = ((inst_20388) || (inst_20390));
var state_20441__$1 = state_20441;
if(cljs.core.truth_(inst_20391)){
var statearr_20456_20508 = state_20441__$1;
(statearr_20456_20508[(1)] = (16));

} else {
var statearr_20457_20509 = state_20441__$1;
(statearr_20457_20509[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (22))){
var inst_20406 = (state_20441[(11)]);
var inst_20411 = inst_20406.cljs$lang$protocol_mask$partition0$;
var inst_20412 = (inst_20411 & (64));
var inst_20413 = inst_20406.cljs$core$ISeq$;
var inst_20414 = (cljs.core.PROTOCOL_SENTINEL === inst_20413);
var inst_20415 = ((inst_20412) || (inst_20414));
var state_20441__$1 = state_20441;
if(cljs.core.truth_(inst_20415)){
var statearr_20458_20510 = state_20441__$1;
(statearr_20458_20510[(1)] = (25));

} else {
var statearr_20459_20511 = state_20441__$1;
(statearr_20459_20511[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (29))){
var inst_20406 = (state_20441[(11)]);
var state_20441__$1 = state_20441;
var statearr_20460_20512 = state_20441__$1;
(statearr_20460_20512[(2)] = inst_20406);

(statearr_20460_20512[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (6))){
var inst_20365 = (state_20441[(7)]);
var inst_20364 = (state_20441[(2)]);
var inst_20365__$1 = fluree.db.util.async.throw_err.call(null,inst_20364);
var inst_20366 = (inst_20365__$1 == null);
var state_20441__$1 = (function (){var statearr_20461 = state_20441;
(statearr_20461[(7)] = inst_20365__$1);

return statearr_20461;
})();
if(cljs.core.truth_(inst_20366)){
var statearr_20462_20513 = state_20441__$1;
(statearr_20462_20513[(1)] = (7));

} else {
var statearr_20463_20514 = state_20441__$1;
(statearr_20463_20514[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (28))){
var inst_20406 = (state_20441[(11)]);
var inst_20424 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20406);
var state_20441__$1 = state_20441;
var statearr_20464_20515 = state_20441__$1;
(statearr_20464_20515[(2)] = inst_20424);

(statearr_20464_20515[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (25))){
var state_20441__$1 = state_20441;
var statearr_20465_20516 = state_20441__$1;
(statearr_20465_20516[(2)] = true);

(statearr_20465_20516[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (17))){
var state_20441__$1 = state_20441;
var statearr_20466_20517 = state_20441__$1;
(statearr_20466_20517[(2)] = false);

(statearr_20466_20517[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (3))){
var inst_20439 = (state_20441[(2)]);
var state_20441__$1 = state_20441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20441__$1,inst_20439);
} else {
if((state_val_20442 === (12))){
var inst_20365 = (state_20441[(7)]);
var inst_20382 = (state_20441[(2)]);
var inst_20384 = (inst_20365 == null);
var inst_20385 = cljs.core.not.call(null,inst_20384);
var state_20441__$1 = (function (){var statearr_20467 = state_20441;
(statearr_20467[(14)] = inst_20382);

return statearr_20467;
})();
if(inst_20385){
var statearr_20468_20518 = state_20441__$1;
(statearr_20468_20518[(1)] = (13));

} else {
var statearr_20469_20519 = state_20441__$1;
(statearr_20469_20519[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (2))){
var _ = (function (){var statearr_20470 = state_20441;
(statearr_20470[(4)] = cljs.core.cons.call(null,(5),(state_20441[(4)])));

return statearr_20470;
})();
var inst_20362 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_20441__$1 = state_20441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20441__$1,(6),inst_20362);
} else {
if((state_val_20442 === (23))){
var state_20441__$1 = state_20441;
var statearr_20471_20520 = state_20441__$1;
(statearr_20471_20520[(2)] = false);

(statearr_20471_20520[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (19))){
var inst_20365 = (state_20441[(7)]);
var inst_20400 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20365);
var state_20441__$1 = state_20441;
var statearr_20472_20521 = state_20441__$1;
(statearr_20472_20521[(2)] = inst_20400);

(statearr_20472_20521[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (11))){
var state_20441__$1 = state_20441;
var statearr_20474_20522 = state_20441__$1;
(statearr_20474_20522[(2)] = null);

(statearr_20474_20522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (9))){
var inst_20365 = (state_20441[(7)]);
var inst_20376 = (state_20441[(2)]);
var inst_20377 = fluree.db.util.core.exception_QMARK_.call(null,inst_20365);
var state_20441__$1 = (function (){var statearr_20475 = state_20441;
(statearr_20475[(15)] = inst_20376);

return statearr_20475;
})();
if(inst_20377){
var statearr_20476_20523 = state_20441__$1;
(statearr_20476_20523[(1)] = (10));

} else {
var statearr_20477_20524 = state_20441__$1;
(statearr_20477_20524[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (5))){
var _ = (function (){var statearr_20478 = state_20441;
(statearr_20478[(4)] = cljs.core.rest.call(null,(state_20441[(4)])));

return statearr_20478;
})();
var state_20441__$1 = state_20441;
var ex20473 = (state_20441__$1[(2)]);
var statearr_20479_20525 = state_20441__$1;
(statearr_20479_20525[(5)] = ex20473);


if((ex20473 instanceof java.lang.Exception)){
var statearr_20480_20526 = state_20441__$1;
(statearr_20480_20526[(1)] = (4));

(statearr_20480_20526[(5)] = null);

} else {
throw ex20473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (14))){
var state_20441__$1 = state_20441;
var statearr_20481_20527 = state_20441__$1;
(statearr_20481_20527[(2)] = false);

(statearr_20481_20527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (26))){
var state_20441__$1 = state_20441;
var statearr_20482_20528 = state_20441__$1;
(statearr_20482_20528[(2)] = false);

(statearr_20482_20528[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (16))){
var state_20441__$1 = state_20441;
var statearr_20483_20529 = state_20441__$1;
(statearr_20483_20529[(2)] = true);

(statearr_20483_20529[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (30))){
var inst_20404 = (state_20441[(12)]);
var inst_20382 = (state_20441[(14)]);
var inst_20403 = (state_20441[(10)]);
var inst_20365 = (state_20441[(7)]);
var inst_20405 = (state_20441[(13)]);
var inst_20427 = (state_20441[(2)]);
var inst_20428 = cljs.core.get.call(null,inst_20427,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_20430 = (function (){var data = inst_20365;
var _ = inst_20382;
var map__20360 = inst_20403;
var children = inst_20404;
var rhs = inst_20405;
var map__20361 = inst_20427;
var comparator = inst_20428;
return (function (idx,p__20429){
var map__20484 = p__20429;
var map__20484__$1 = (((((!((map__20484 == null))))?(((((map__20484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20484):map__20484);
var child = map__20484__$1;
var id = cljs.core.get.call(null,map__20484__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__20484__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__20484__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__20484__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__20484__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_20431 = cljs.core.map_indexed.call(null,inst_20430,inst_20404);
var inst_20432 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_20431);
var inst_20433 = cljs.core.interleave.call(null,inst_20432,inst_20431);
var inst_20434 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_20428,inst_20433);
var inst_20435 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_20405,inst_20434,config,leftmost_QMARK_);
var inst_20436 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20435);
var _ = (function (){var statearr_20486 = state_20441;
(statearr_20486[(4)] = cljs.core.rest.call(null,(state_20441[(4)])));

return statearr_20486;
})();
var state_20441__$1 = state_20441;
var statearr_20487_20530 = state_20441__$1;
(statearr_20487_20530[(2)] = inst_20436);

(statearr_20487_20530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (10))){
var inst_20365 = (state_20441[(7)]);
var inst_20379 = (function(){throw inst_20365})();
var state_20441__$1 = state_20441;
var statearr_20488_20531 = state_20441__$1;
(statearr_20488_20531[(2)] = inst_20379);

(statearr_20488_20531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (18))){
var inst_20395 = (state_20441[(2)]);
var state_20441__$1 = state_20441;
var statearr_20489_20532 = state_20441__$1;
(statearr_20489_20532[(2)] = inst_20395);

(statearr_20489_20532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20442 === (8))){
var state_20441__$1 = state_20441;
var statearr_20490_20533 = state_20441__$1;
(statearr_20490_20533[(2)] = null);

(statearr_20490_20533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____0 = (function (){
var statearr_20491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20491[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__);

(statearr_20491[(1)] = (1));

return statearr_20491;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____1 = (function (state_20441){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20492){var ex__2457__auto__ = e20492;
var statearr_20493_20534 = state_20441;
(statearr_20493_20534[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20441[(4)]))){
var statearr_20494_20535 = state_20441;
(statearr_20494_20535[(1)] = cljs.core.first.call(null,(state_20441[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20536 = state_20441;
state_20441 = G__20536;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__ = function(state_20441){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____1.call(this,state_20441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2454__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20495 = f__2477__auto__.call(null);
(statearr_20495[(6)] = c__2476__auto___20496);

return statearr_20495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20557){
var state_val_20558 = (state_20557[(1)]);
if((state_val_20558 === (7))){
var state_20557__$1 = state_20557;
var statearr_20559_20579 = state_20557__$1;
(statearr_20559_20579[(2)] = null);

(statearr_20559_20579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (1))){
var state_20557__$1 = state_20557;
var statearr_20560_20580 = state_20557__$1;
(statearr_20560_20580[(2)] = null);

(statearr_20560_20580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (4))){
var inst_20537 = (state_20557[(2)]);
var state_20557__$1 = state_20557;
var statearr_20561_20581 = state_20557__$1;
(statearr_20561_20581[(2)] = inst_20537);

(statearr_20561_20581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (6))){
var inst_20543 = (state_20557[(7)]);
var inst_20545 = fluree.db.storage.core.serde.call(null,conn);
var state_20557__$1 = (function (){var statearr_20562 = state_20557;
(statearr_20562[(8)] = inst_20545);

return statearr_20562;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20557__$1,(9),inst_20543);
} else {
if((state_val_20558 === (3))){
var inst_20555 = (state_20557[(2)]);
var state_20557__$1 = state_20557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20557__$1,inst_20555);
} else {
if((state_val_20558 === (2))){
var inst_20543 = (state_20557[(7)]);
var _ = (function (){var statearr_20564 = state_20557;
(statearr_20564[(4)] = cljs.core.cons.call(null,(5),(state_20557[(4)])));

return statearr_20564;
})();
var inst_20543__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_20557__$1 = (function (){var statearr_20565 = state_20557;
(statearr_20565[(7)] = inst_20543__$1);

return statearr_20565;
})();
if(cljs.core.truth_(inst_20543__$1)){
var statearr_20566_20582 = state_20557__$1;
(statearr_20566_20582[(1)] = (6));

} else {
var statearr_20567_20583 = state_20557__$1;
(statearr_20567_20583[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (9))){
var inst_20545 = (state_20557[(8)]);
var inst_20547 = (state_20557[(2)]);
var inst_20548 = fluree.db.util.async.throw_err.call(null,inst_20547);
var inst_20549 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_20545,inst_20548);
var state_20557__$1 = state_20557;
var statearr_20568_20584 = state_20557__$1;
(statearr_20568_20584[(2)] = inst_20549);

(statearr_20568_20584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (5))){
var _ = (function (){var statearr_20569 = state_20557;
(statearr_20569[(4)] = cljs.core.rest.call(null,(state_20557[(4)])));

return statearr_20569;
})();
var state_20557__$1 = state_20557;
var ex20563 = (state_20557__$1[(2)]);
var statearr_20570_20585 = state_20557__$1;
(statearr_20570_20585[(5)] = ex20563);


if((ex20563 instanceof Error)){
var statearr_20571_20586 = state_20557__$1;
(statearr_20571_20586[(1)] = (4));

(statearr_20571_20586[(5)] = null);

} else {
throw ex20563;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (8))){
var inst_20552 = (state_20557[(2)]);
var _ = (function (){var statearr_20572 = state_20557;
(statearr_20572[(4)] = cljs.core.rest.call(null,(state_20557[(4)])));

return statearr_20572;
})();
var state_20557__$1 = state_20557;
var statearr_20573_20587 = state_20557__$1;
(statearr_20573_20587[(2)] = inst_20552);

(statearr_20573_20587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____0 = (function (){
var statearr_20574 = [null,null,null,null,null,null,null,null,null];
(statearr_20574[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__);

(statearr_20574[(1)] = (1));

return statearr_20574;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____1 = (function (state_20557){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20575){var ex__2457__auto__ = e20575;
var statearr_20576_20588 = state_20557;
(statearr_20576_20588[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20557[(4)]))){
var statearr_20577_20589 = state_20557;
(statearr_20577_20589[(1)] = cljs.core.first.call(null,(state_20557[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20590 = state_20557;
state_20557 = G__20590;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__ = function(state_20557){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____1.call(this,state_20557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20578 = f__2477__auto__.call(null);
(statearr_20578[(6)] = c__2476__auto__);

return statearr_20578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2476__auto___20728 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20675){
var state_val_20676 = (state_20675[(1)]);
if((state_val_20676 === (7))){
var inst_20607 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_20608 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20609 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_20610 = cljs.core.PersistentHashMap.fromArrays(inst_20608,inst_20609);
var inst_20611 = cljs.core.ex_info.call(null,inst_20607,inst_20610);
var inst_20612 = (function(){throw inst_20611})();
var state_20675__$1 = state_20675;
var statearr_20677_20729 = state_20675__$1;
(statearr_20677_20729[(2)] = inst_20612);

(statearr_20677_20729[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (20))){
var inst_20604 = (state_20675[(7)]);
var state_20675__$1 = state_20675;
var statearr_20678_20730 = state_20675__$1;
(statearr_20678_20730[(2)] = inst_20604);

(statearr_20678_20730[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (27))){
var inst_20658 = (state_20675[(2)]);
var state_20675__$1 = state_20675;
var statearr_20679_20731 = state_20675__$1;
(statearr_20679_20731[(2)] = inst_20658);

(statearr_20679_20731[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (1))){
var state_20675__$1 = state_20675;
var statearr_20680_20732 = state_20675__$1;
(statearr_20680_20732[(2)] = null);

(statearr_20680_20732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (24))){
var inst_20661 = (state_20675[(2)]);
var state_20675__$1 = state_20675;
if(cljs.core.truth_(inst_20661)){
var statearr_20681_20733 = state_20675__$1;
(statearr_20681_20733[(1)] = (28));

} else {
var statearr_20682_20734 = state_20675__$1;
(statearr_20682_20734[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (4))){
var inst_20591 = (state_20675[(2)]);
var inst_20592 = error_fn.call(null);
var inst_20593 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20591);
var inst_20594 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20675__$1 = (function (){var statearr_20683 = state_20675;
(statearr_20683[(8)] = inst_20593);

(statearr_20683[(9)] = inst_20592);

return statearr_20683;
})();
var statearr_20684_20735 = state_20675__$1;
(statearr_20684_20735[(2)] = inst_20594);

(statearr_20684_20735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (15))){
var inst_20637 = (state_20675[(2)]);
var state_20675__$1 = state_20675;
if(cljs.core.truth_(inst_20637)){
var statearr_20685_20736 = state_20675__$1;
(statearr_20685_20736[(1)] = (19));

} else {
var statearr_20686_20737 = state_20675__$1;
(statearr_20686_20737[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (21))){
var inst_20645 = (state_20675[(10)]);
var inst_20642 = (state_20675[(2)]);
var inst_20643 = cljs.core.get.call(null,inst_20642,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_20644 = cljs.core.get.call(null,inst_20642,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_20645__$1 = config;
var inst_20647 = (inst_20645__$1 == null);
var inst_20648 = cljs.core.not.call(null,inst_20647);
var state_20675__$1 = (function (){var statearr_20687 = state_20675;
(statearr_20687[(10)] = inst_20645__$1);

(statearr_20687[(11)] = inst_20643);

(statearr_20687[(12)] = inst_20644);

return statearr_20687;
})();
if(inst_20648){
var statearr_20688_20738 = state_20675__$1;
(statearr_20688_20738[(1)] = (22));

} else {
var statearr_20689_20739 = state_20675__$1;
(statearr_20689_20739[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (13))){
var inst_20604 = (state_20675[(7)]);
var inst_20626 = inst_20604.cljs$lang$protocol_mask$partition0$;
var inst_20627 = (inst_20626 & (64));
var inst_20628 = inst_20604.cljs$core$ISeq$;
var inst_20629 = (cljs.core.PROTOCOL_SENTINEL === inst_20628);
var inst_20630 = ((inst_20627) || (inst_20629));
var state_20675__$1 = state_20675;
if(cljs.core.truth_(inst_20630)){
var statearr_20690_20740 = state_20675__$1;
(statearr_20690_20740[(1)] = (16));

} else {
var statearr_20691_20741 = state_20675__$1;
(statearr_20691_20741[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (22))){
var inst_20645 = (state_20675[(10)]);
var inst_20650 = inst_20645.cljs$lang$protocol_mask$partition0$;
var inst_20651 = (inst_20650 & (64));
var inst_20652 = inst_20645.cljs$core$ISeq$;
var inst_20653 = (cljs.core.PROTOCOL_SENTINEL === inst_20652);
var inst_20654 = ((inst_20651) || (inst_20653));
var state_20675__$1 = state_20675;
if(cljs.core.truth_(inst_20654)){
var statearr_20692_20742 = state_20675__$1;
(statearr_20692_20742[(1)] = (25));

} else {
var statearr_20693_20743 = state_20675__$1;
(statearr_20693_20743[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (29))){
var inst_20645 = (state_20675[(10)]);
var state_20675__$1 = state_20675;
var statearr_20694_20744 = state_20675__$1;
(statearr_20694_20744[(2)] = inst_20645);

(statearr_20694_20744[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (6))){
var inst_20604 = (state_20675[(7)]);
var inst_20604__$1 = (state_20675[(2)]);
var inst_20605 = (inst_20604__$1 == null);
var state_20675__$1 = (function (){var statearr_20695 = state_20675;
(statearr_20695[(7)] = inst_20604__$1);

return statearr_20695;
})();
if(cljs.core.truth_(inst_20605)){
var statearr_20696_20745 = state_20675__$1;
(statearr_20696_20745[(1)] = (7));

} else {
var statearr_20697_20746 = state_20675__$1;
(statearr_20697_20746[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (28))){
var inst_20645 = (state_20675[(10)]);
var inst_20663 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20645);
var state_20675__$1 = state_20675;
var statearr_20698_20747 = state_20675__$1;
(statearr_20698_20747[(2)] = inst_20663);

(statearr_20698_20747[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (25))){
var state_20675__$1 = state_20675;
var statearr_20699_20748 = state_20675__$1;
(statearr_20699_20748[(2)] = true);

(statearr_20699_20748[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (17))){
var state_20675__$1 = state_20675;
var statearr_20700_20749 = state_20675__$1;
(statearr_20700_20749[(2)] = false);

(statearr_20700_20749[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (3))){
var inst_20673 = (state_20675[(2)]);
var state_20675__$1 = state_20675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20675__$1,inst_20673);
} else {
if((state_val_20676 === (12))){
var inst_20604 = (state_20675[(7)]);
var inst_20621 = (state_20675[(2)]);
var inst_20623 = (inst_20604 == null);
var inst_20624 = cljs.core.not.call(null,inst_20623);
var state_20675__$1 = (function (){var statearr_20701 = state_20675;
(statearr_20701[(13)] = inst_20621);

return statearr_20701;
})();
if(inst_20624){
var statearr_20702_20750 = state_20675__$1;
(statearr_20702_20750[(1)] = (13));

} else {
var statearr_20703_20751 = state_20675__$1;
(statearr_20703_20751[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (2))){
var _ = (function (){var statearr_20704 = state_20675;
(statearr_20704[(4)] = cljs.core.cons.call(null,(5),(state_20675[(4)])));

return statearr_20704;
})();
var inst_20602 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_20675__$1 = state_20675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20675__$1,(6),inst_20602);
} else {
if((state_val_20676 === (23))){
var state_20675__$1 = state_20675;
var statearr_20705_20752 = state_20675__$1;
(statearr_20705_20752[(2)] = false);

(statearr_20705_20752[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (19))){
var inst_20604 = (state_20675[(7)]);
var inst_20639 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20604);
var state_20675__$1 = state_20675;
var statearr_20706_20753 = state_20675__$1;
(statearr_20706_20753[(2)] = inst_20639);

(statearr_20706_20753[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (11))){
var state_20675__$1 = state_20675;
var statearr_20708_20754 = state_20675__$1;
(statearr_20708_20754[(2)] = null);

(statearr_20708_20754[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (9))){
var inst_20604 = (state_20675[(7)]);
var inst_20615 = (state_20675[(2)]);
var inst_20616 = fluree.db.util.core.exception_QMARK_.call(null,inst_20604);
var state_20675__$1 = (function (){var statearr_20709 = state_20675;
(statearr_20709[(14)] = inst_20615);

return statearr_20709;
})();
if(inst_20616){
var statearr_20710_20755 = state_20675__$1;
(statearr_20710_20755[(1)] = (10));

} else {
var statearr_20711_20756 = state_20675__$1;
(statearr_20711_20756[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (5))){
var _ = (function (){var statearr_20712 = state_20675;
(statearr_20712[(4)] = cljs.core.rest.call(null,(state_20675[(4)])));

return statearr_20712;
})();
var state_20675__$1 = state_20675;
var ex20707 = (state_20675__$1[(2)]);
var statearr_20713_20757 = state_20675__$1;
(statearr_20713_20757[(5)] = ex20707);


if((ex20707 instanceof java.lang.Exception)){
var statearr_20714_20758 = state_20675__$1;
(statearr_20714_20758[(1)] = (4));

(statearr_20714_20758[(5)] = null);

} else {
throw ex20707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (14))){
var state_20675__$1 = state_20675;
var statearr_20715_20759 = state_20675__$1;
(statearr_20715_20759[(2)] = false);

(statearr_20715_20759[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (26))){
var state_20675__$1 = state_20675;
var statearr_20716_20760 = state_20675__$1;
(statearr_20716_20760[(2)] = false);

(statearr_20716_20760[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (16))){
var state_20675__$1 = state_20675;
var statearr_20717_20761 = state_20675__$1;
(statearr_20717_20761[(2)] = true);

(statearr_20717_20761[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (30))){
var inst_20643 = (state_20675[(11)]);
var inst_20666 = (state_20675[(2)]);
var inst_20667 = cljs.core.get.call(null,inst_20666,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_20668 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_20667,inst_20643);
var inst_20669 = fluree.db.index.data_node.call(null,block,t,inst_20668,rhs,config);
var inst_20670 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20669);
var _ = (function (){var statearr_20718 = state_20675;
(statearr_20718[(4)] = cljs.core.rest.call(null,(state_20675[(4)])));

return statearr_20718;
})();
var state_20675__$1 = state_20675;
var statearr_20719_20762 = state_20675__$1;
(statearr_20719_20762[(2)] = inst_20670);

(statearr_20719_20762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (10))){
var inst_20604 = (state_20675[(7)]);
var inst_20618 = (function(){throw inst_20604})();
var state_20675__$1 = state_20675;
var statearr_20720_20763 = state_20675__$1;
(statearr_20720_20763[(2)] = inst_20618);

(statearr_20720_20763[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (18))){
var inst_20634 = (state_20675[(2)]);
var state_20675__$1 = state_20675;
var statearr_20721_20764 = state_20675__$1;
(statearr_20721_20764[(2)] = inst_20634);

(statearr_20721_20764[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20676 === (8))){
var state_20675__$1 = state_20675;
var statearr_20722_20765 = state_20675__$1;
(statearr_20722_20765[(2)] = null);

(statearr_20722_20765[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____0 = (function (){
var statearr_20723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20723[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__);

(statearr_20723[(1)] = (1));

return statearr_20723;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____1 = (function (state_20675){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20724){var ex__2457__auto__ = e20724;
var statearr_20725_20766 = state_20675;
(statearr_20725_20766[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20675[(4)]))){
var statearr_20726_20767 = state_20675;
(statearr_20726_20767[(1)] = cljs.core.first.call(null,(state_20675[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20768 = state_20675;
state_20675 = G__20768;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__ = function(state_20675){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____1.call(this,state_20675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20727 = f__2477__auto__.call(null);
(statearr_20727[(6)] = c__2476__auto___20728);

return statearr_20727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k20770,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__20774 = k20770;
var G__20774__$1 = (((G__20774 instanceof cljs.core.Keyword))?G__20774.fqn:null);
switch (G__20774__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k20770,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__20775){
var vec__20776 = p__20775;
var k__4403__auto__ = cljs.core.nth.call(null,vec__20776,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__20776,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__20769){
var self__ = this;
var G__20769__$1 = this;
return (new cljs.core.RecordIter((0),G__20769__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this20771,other20772){
var self__ = this;
var this20771__$1 = this;
return (((!((other20772 == null)))) && ((this20771__$1.constructor === other20772.constructor)) && (cljs.core._EQ_.call(null,this20771__$1.conn,other20772.conn)) && (cljs.core._EQ_.call(null,this20771__$1.config,other20772.config)) && (cljs.core._EQ_.call(null,this20771__$1.network,other20772.network)) && (cljs.core._EQ_.call(null,this20771__$1.dbid,other20772.dbid)) && (cljs.core._EQ_.call(null,this20771__$1.id,other20772.id)) && (cljs.core._EQ_.call(null,this20771__$1.leaf,other20772.leaf)) && (cljs.core._EQ_.call(null,this20771__$1.first,other20772.first)) && (cljs.core._EQ_.call(null,this20771__$1.rhs,other20772.rhs)) && (cljs.core._EQ_.call(null,this20771__$1.size,other20772.size)) && (cljs.core._EQ_.call(null,this20771__$1.block,other20772.block)) && (cljs.core._EQ_.call(null,this20771__$1.t,other20772.t)) && (cljs.core._EQ_.call(null,this20771__$1.tt_id,other20772.tt_id)) && (cljs.core._EQ_.call(null,this20771__$1.leftmost_QMARK_,other20772.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this20771__$1.tempid,other20772.tempid)) && (cljs.core._EQ_.call(null,this20771__$1.__extmap,other20772.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__20769){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__20779 = cljs.core.keyword_identical_QMARK_;
var expr__20780 = k__4388__auto__;
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(G__20769,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__20769,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__20769,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__20769,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__20769,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__20769,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__20769,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__20769,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__20769,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__20769,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__20769,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__20769,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__20769,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20779.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__20780))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__20769,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__20769),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__20769){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__20769,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__20773){
var extmap__4419__auto__ = (function (){var G__20782 = cljs.core.dissoc.call(null,G__20773,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__20773)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__20782);
} else {
return G__20782;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__20773),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__20773),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__20784 = blank_db;
var map__20784__$1 = (((((!((map__20784 == null))))?(((((map__20784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20784):map__20784);
var network = cljs.core.get.call(null,map__20784__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__20784__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__20784__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__20785 = root_data;
var map__20785__$1 = (((((!((map__20785 == null))))?(((((map__20785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20785):map__20785);
var block = cljs.core.get.call(null,map__20785__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__20785__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__20785__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__20785__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20809){
var state_val_20810 = (state_20809[(1)]);
if((state_val_20810 === (7))){
var state_20809__$1 = state_20809;
var statearr_20811_20831 = state_20809__$1;
(statearr_20811_20831[(2)] = null);

(statearr_20811_20831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (1))){
var state_20809__$1 = state_20809;
var statearr_20812_20832 = state_20809__$1;
(statearr_20812_20832[(2)] = null);

(statearr_20812_20832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (4))){
var inst_20788 = (state_20809[(2)]);
var state_20809__$1 = state_20809;
var statearr_20813_20833 = state_20809__$1;
(statearr_20813_20833[(2)] = inst_20788);

(statearr_20813_20833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (6))){
var inst_20795 = (state_20809[(7)]);
var inst_20797 = fluree.db.storage.core.serde.call(null,conn);
var state_20809__$1 = (function (){var statearr_20814 = state_20809;
(statearr_20814[(8)] = inst_20797);

return statearr_20814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20809__$1,(9),inst_20795);
} else {
if((state_val_20810 === (3))){
var inst_20807 = (state_20809[(2)]);
var state_20809__$1 = state_20809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20809__$1,inst_20807);
} else {
if((state_val_20810 === (2))){
var inst_20795 = (state_20809[(7)]);
var _ = (function (){var statearr_20816 = state_20809;
(statearr_20816[(4)] = cljs.core.cons.call(null,(5),(state_20809[(4)])));

return statearr_20816;
})();
var inst_20794 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_20795__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_20794);
var state_20809__$1 = (function (){var statearr_20817 = state_20809;
(statearr_20817[(7)] = inst_20795__$1);

return statearr_20817;
})();
if(cljs.core.truth_(inst_20795__$1)){
var statearr_20818_20834 = state_20809__$1;
(statearr_20818_20834[(1)] = (6));

} else {
var statearr_20819_20835 = state_20809__$1;
(statearr_20819_20835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (9))){
var inst_20797 = (state_20809[(8)]);
var inst_20799 = (state_20809[(2)]);
var inst_20800 = fluree.db.util.async.throw_err.call(null,inst_20799);
var inst_20801 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_20797,inst_20800);
var state_20809__$1 = state_20809;
var statearr_20820_20836 = state_20809__$1;
(statearr_20820_20836[(2)] = inst_20801);

(statearr_20820_20836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (5))){
var _ = (function (){var statearr_20821 = state_20809;
(statearr_20821[(4)] = cljs.core.rest.call(null,(state_20809[(4)])));

return statearr_20821;
})();
var state_20809__$1 = state_20809;
var ex20815 = (state_20809__$1[(2)]);
var statearr_20822_20837 = state_20809__$1;
(statearr_20822_20837[(5)] = ex20815);


if((ex20815 instanceof Error)){
var statearr_20823_20838 = state_20809__$1;
(statearr_20823_20838[(1)] = (4));

(statearr_20823_20838[(5)] = null);

} else {
throw ex20815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20810 === (8))){
var inst_20804 = (state_20809[(2)]);
var _ = (function (){var statearr_20824 = state_20809;
(statearr_20824[(4)] = cljs.core.rest.call(null,(state_20809[(4)])));

return statearr_20824;
})();
var state_20809__$1 = state_20809;
var statearr_20825_20839 = state_20809__$1;
(statearr_20825_20839[(2)] = inst_20804);

(statearr_20825_20839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____0 = (function (){
var statearr_20826 = [null,null,null,null,null,null,null,null,null];
(statearr_20826[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__);

(statearr_20826[(1)] = (1));

return statearr_20826;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____1 = (function (state_20809){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20827){var ex__2457__auto__ = e20827;
var statearr_20828_20840 = state_20809;
(statearr_20828_20840[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20809[(4)]))){
var statearr_20829_20841 = state_20809;
(statearr_20829_20841[(1)] = cljs.core.first.call(null,(state_20809[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20842 = state_20809;
state_20809 = G__20842;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__ = function(state_20809){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____1.call(this,state_20809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20830 = f__2477__auto__.call(null);
(statearr_20830[(6)] = c__2476__auto__);

return statearr_20830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20864){
var state_val_20865 = (state_20864[(1)]);
if((state_val_20865 === (7))){
var state_20864__$1 = state_20864;
var statearr_20866_20886 = state_20864__$1;
(statearr_20866_20886[(2)] = null);

(statearr_20866_20886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (1))){
var state_20864__$1 = state_20864;
var statearr_20867_20887 = state_20864__$1;
(statearr_20867_20887[(2)] = null);

(statearr_20867_20887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (4))){
var inst_20843 = (state_20864[(2)]);
var state_20864__$1 = state_20864;
var statearr_20868_20888 = state_20864__$1;
(statearr_20868_20888[(2)] = inst_20843);

(statearr_20868_20888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (6))){
var inst_20850 = (state_20864[(7)]);
var inst_20852 = fluree.db.storage.core.serde.call(null,conn);
var state_20864__$1 = (function (){var statearr_20869 = state_20864;
(statearr_20869[(8)] = inst_20852);

return statearr_20869;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20864__$1,(9),inst_20850);
} else {
if((state_val_20865 === (3))){
var inst_20862 = (state_20864[(2)]);
var state_20864__$1 = state_20864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20864__$1,inst_20862);
} else {
if((state_val_20865 === (2))){
var inst_20850 = (state_20864[(7)]);
var _ = (function (){var statearr_20871 = state_20864;
(statearr_20871[(4)] = cljs.core.cons.call(null,(5),(state_20864[(4)])));

return statearr_20871;
})();
var inst_20849 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_20850__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_20849);
var state_20864__$1 = (function (){var statearr_20872 = state_20864;
(statearr_20872[(7)] = inst_20850__$1);

return statearr_20872;
})();
if(cljs.core.truth_(inst_20850__$1)){
var statearr_20873_20889 = state_20864__$1;
(statearr_20873_20889[(1)] = (6));

} else {
var statearr_20874_20890 = state_20864__$1;
(statearr_20874_20890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (9))){
var inst_20852 = (state_20864[(8)]);
var inst_20854 = (state_20864[(2)]);
var inst_20855 = fluree.db.util.async.throw_err.call(null,inst_20854);
var inst_20856 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_20852,inst_20855);
var state_20864__$1 = state_20864;
var statearr_20875_20891 = state_20864__$1;
(statearr_20875_20891[(2)] = inst_20856);

(statearr_20875_20891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (5))){
var _ = (function (){var statearr_20876 = state_20864;
(statearr_20876[(4)] = cljs.core.rest.call(null,(state_20864[(4)])));

return statearr_20876;
})();
var state_20864__$1 = state_20864;
var ex20870 = (state_20864__$1[(2)]);
var statearr_20877_20892 = state_20864__$1;
(statearr_20877_20892[(5)] = ex20870);


if((ex20870 instanceof Error)){
var statearr_20878_20893 = state_20864__$1;
(statearr_20878_20893[(1)] = (4));

(statearr_20878_20893[(5)] = null);

} else {
throw ex20870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20865 === (8))){
var inst_20859 = (state_20864[(2)]);
var _ = (function (){var statearr_20879 = state_20864;
(statearr_20879[(4)] = cljs.core.rest.call(null,(state_20864[(4)])));

return statearr_20879;
})();
var state_20864__$1 = state_20864;
var statearr_20880_20894 = state_20864__$1;
(statearr_20880_20894[(2)] = inst_20859);

(statearr_20880_20894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____0 = (function (){
var statearr_20881 = [null,null,null,null,null,null,null,null,null];
(statearr_20881[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__);

(statearr_20881[(1)] = (1));

return statearr_20881;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____1 = (function (state_20864){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20882){var ex__2457__auto__ = e20882;
var statearr_20883_20895 = state_20864;
(statearr_20883_20895[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20864[(4)]))){
var statearr_20884_20896 = state_20864;
(statearr_20884_20896[(1)] = cljs.core.first.call(null,(state_20864[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20897 = state_20864;
state_20864 = G__20897;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__ = function(state_20864){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____1.call(this,state_20864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2454__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20885 = f__2477__auto__.call(null);
(statearr_20885[(6)] = c__2476__auto__);

return statearr_20885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_20933){
var state_val_20934 = (state_20933[(1)]);
if((state_val_20934 === (7))){
var inst_20907 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_20908 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20909 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_20910 = cljs.core.PersistentHashMap.fromArrays(inst_20908,inst_20909);
var inst_20911 = cljs.core.ex_info.call(null,inst_20907,inst_20910);
var inst_20912 = (function(){throw inst_20911})();
var state_20933__$1 = state_20933;
var statearr_20935_20957 = state_20933__$1;
(statearr_20935_20957[(2)] = inst_20912);

(statearr_20935_20957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (1))){
var state_20933__$1 = state_20933;
var statearr_20936_20958 = state_20933__$1;
(statearr_20936_20958[(2)] = null);

(statearr_20936_20958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (4))){
var inst_20898 = (state_20933[(2)]);
var state_20933__$1 = state_20933;
var statearr_20937_20959 = state_20933__$1;
(statearr_20937_20959[(2)] = inst_20898);

(statearr_20937_20959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (6))){
var state_20933__$1 = state_20933;
var statearr_20938_20960 = state_20933__$1;
(statearr_20938_20960[(2)] = null);

(statearr_20938_20960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (3))){
var inst_20931 = (state_20933[(2)]);
var state_20933__$1 = state_20933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20933__$1,inst_20931);
} else {
if((state_val_20934 === (2))){
var inst_20904 = (state_20933[(7)]);
var _ = (function (){var statearr_20939 = state_20933;
(statearr_20939[(4)] = cljs.core.cons.call(null,(5),(state_20933[(4)])));

return statearr_20939;
})();
var inst_20904__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_20933__$1 = (function (){var statearr_20940 = state_20933;
(statearr_20940[(7)] = inst_20904__$1);

return statearr_20940;
})();
if(cljs.core.truth_(inst_20904__$1)){
var statearr_20941_20961 = state_20933__$1;
(statearr_20941_20961[(1)] = (6));

} else {
var statearr_20942_20962 = state_20933__$1;
(statearr_20942_20962[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (11))){
var inst_20923 = (state_20933[(8)]);
var inst_20926 = (state_20933[(2)]);
var inst_20927 = fluree.db.util.async.throw_err.call(null,inst_20926);
var inst_20928 = cljs.core.assoc.call(null,inst_20923,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_20927);
var _ = (function (){var statearr_20944 = state_20933;
(statearr_20944[(4)] = cljs.core.rest.call(null,(state_20933[(4)])));

return statearr_20944;
})();
var state_20933__$1 = state_20933;
var statearr_20945_20963 = state_20933__$1;
(statearr_20945_20963[(2)] = inst_20928);

(statearr_20945_20963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (9))){
var inst_20918 = (state_20933[(9)]);
var inst_20916 = (state_20933[(2)]);
var inst_20917 = fluree.db.util.async.throw_err.call(null,inst_20916);
var inst_20918__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_20917);
var inst_20919 = fluree.db.query.schema.schema_map.call(null,inst_20918__$1);
var state_20933__$1 = (function (){var statearr_20946 = state_20933;
(statearr_20946[(9)] = inst_20918__$1);

return statearr_20946;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20933__$1,(10),inst_20919);
} else {
if((state_val_20934 === (5))){
var _ = (function (){var statearr_20947 = state_20933;
(statearr_20947[(4)] = cljs.core.rest.call(null,(state_20933[(4)])));

return statearr_20947;
})();
var state_20933__$1 = state_20933;
var ex20943 = (state_20933__$1[(2)]);
var statearr_20948_20964 = state_20933__$1;
(statearr_20948_20964[(5)] = ex20943);


if((ex20943 instanceof Error)){
var statearr_20949_20965 = state_20933__$1;
(statearr_20949_20965[(1)] = (4));

(statearr_20949_20965[(5)] = null);

} else {
throw ex20943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20934 === (10))){
var inst_20918 = (state_20933[(9)]);
var inst_20923 = (state_20933[(8)]);
var inst_20921 = (state_20933[(2)]);
var inst_20922 = fluree.db.util.async.throw_err.call(null,inst_20921);
var inst_20923__$1 = cljs.core.assoc.call(null,inst_20918,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_20922);
var inst_20924 = fluree.db.query.schema.setting_map.call(null,inst_20923__$1);
var state_20933__$1 = (function (){var statearr_20950 = state_20933;
(statearr_20950[(8)] = inst_20923__$1);

return statearr_20950;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20933__$1,(11),inst_20924);
} else {
if((state_val_20934 === (8))){
var inst_20904 = (state_20933[(7)]);
var inst_20914 = (state_20933[(2)]);
var state_20933__$1 = (function (){var statearr_20951 = state_20933;
(statearr_20951[(10)] = inst_20914);

return statearr_20951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20933__$1,(9),inst_20904);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2454__auto____0 = (function (){
var statearr_20952 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20952[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2454__auto__);

(statearr_20952[(1)] = (1));

return statearr_20952;
});
var fluree$db$storage$core$reify_db_$_state_machine__2454__auto____1 = (function (state_20933){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_20933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e20953){var ex__2457__auto__ = e20953;
var statearr_20954_20966 = state_20933;
(statearr_20954_20966[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_20933[(4)]))){
var statearr_20955_20967 = state_20933;
(statearr_20955_20967[(1)] = cljs.core.first.call(null,(state_20933[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20968 = state_20933;
state_20933 = G__20968;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2454__auto__ = function(state_20933){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2454__auto____1.call(this,state_20933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2454__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2454__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_20956 = f__2477__auto__.call(null);
(statearr_20956[(6)] = c__2476__auto__);

return statearr_20956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__20970 = arguments.length;
switch (G__20970) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_21020){
var state_val_21021 = (state_21020[(1)]);
if((state_val_21021 === (7))){
var inst_20980 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_20981 = (new Error(inst_20980));
var inst_20982 = (function(){throw inst_20981})();
var state_21020__$1 = state_21020;
var statearr_21022_21058 = state_21020__$1;
(statearr_21022_21058[(2)] = inst_20982);

(statearr_21022_21058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (20))){
var inst_21009 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21023_21059 = state_21020__$1;
(statearr_21023_21059[(2)] = inst_21009);

(statearr_21023_21059[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (1))){
var state_21020__$1 = state_21020;
var statearr_21024_21060 = state_21020__$1;
(statearr_21024_21060[(2)] = null);

(statearr_21024_21060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (4))){
var inst_20971 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21025_21061 = state_21020__$1;
(statearr_21025_21061[(2)] = inst_20971);

(statearr_21025_21061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (15))){
var inst_20989 = (state_21020[(7)]);
var inst_20993 = (state_21020[(8)]);
var inst_21001 = cljs.core.conj.call(null,inst_20989,inst_20993);
var state_21020__$1 = state_21020;
var statearr_21026_21062 = state_21020__$1;
(statearr_21026_21062[(2)] = inst_21001);

(statearr_21026_21062[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (13))){
var inst_20988 = (state_21020[(9)]);
var inst_20999 = cljs.core._EQ_.call(null,inst_20988,end);
var state_21020__$1 = state_21020;
if(inst_20999){
var statearr_21027_21063 = state_21020__$1;
(statearr_21027_21063[(1)] = (15));

} else {
var statearr_21028_21064 = state_21020__$1;
(statearr_21028_21064[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (6))){
var state_21020__$1 = state_21020;
var statearr_21029_21065 = state_21020__$1;
(statearr_21029_21065[(2)] = null);

(statearr_21029_21065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (17))){
var inst_21011 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21030_21066 = state_21020__$1;
(statearr_21030_21066[(2)] = inst_21011);

(statearr_21030_21066[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (3))){
var inst_21018 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21020__$1,inst_21018);
} else {
if((state_val_21021 === (12))){
var inst_20989 = (state_21020[(7)]);
var state_21020__$1 = state_21020;
var statearr_21031_21067 = state_21020__$1;
(statearr_21031_21067[(2)] = inst_20989);

(statearr_21031_21067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (2))){
var _ = (function (){var statearr_21032 = state_21020;
(statearr_21032[(4)] = cljs.core.cons.call(null,(5),(state_21020[(4)])));

return statearr_21032;
})();
var inst_20977 = (end >= start);
var state_21020__$1 = state_21020;
if(cljs.core.truth_(inst_20977)){
var statearr_21033_21068 = state_21020__$1;
(statearr_21033_21068[(1)] = (6));

} else {
var statearr_21034_21069 = state_21020__$1;
(statearr_21034_21069[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (19))){
var state_21020__$1 = state_21020;
var statearr_21035_21070 = state_21020__$1;
(statearr_21035_21070[(2)] = null);

(statearr_21035_21070[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (11))){
var inst_20993 = (state_21020[(8)]);
var inst_20993__$1 = (state_21020[(2)]);
var inst_20994 = (inst_20993__$1 == null);
var inst_20995 = (inst_20993__$1 instanceof Error);
var inst_20996 = ((inst_20994) || (inst_20995));
var state_21020__$1 = (function (){var statearr_21037 = state_21020;
(statearr_21037[(8)] = inst_20993__$1);

return statearr_21037;
})();
if(cljs.core.truth_(inst_20996)){
var statearr_21038_21071 = state_21020__$1;
(statearr_21038_21071[(1)] = (12));

} else {
var statearr_21039_21072 = state_21020__$1;
(statearr_21039_21072[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (9))){
var inst_20988 = (state_21020[(9)]);
var inst_20991 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_20988);
var state_21020__$1 = state_21020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21020__$1,(11),inst_20991);
} else {
if((state_val_21021 === (5))){
var _ = (function (){var statearr_21040 = state_21020;
(statearr_21040[(4)] = cljs.core.rest.call(null,(state_21020[(4)])));

return statearr_21040;
})();
var state_21020__$1 = state_21020;
var ex21036 = (state_21020__$1[(2)]);
var statearr_21041_21073 = state_21020__$1;
(statearr_21041_21073[(5)] = ex21036);


if((ex21036 instanceof Error)){
var statearr_21042_21074 = state_21020__$1;
(statearr_21042_21074[(1)] = (4));

(statearr_21042_21074[(5)] = null);

} else {
throw ex21036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (14))){
var inst_21013 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21043_21075 = state_21020__$1;
(statearr_21043_21075[(2)] = inst_21013);

(statearr_21043_21075[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (16))){
var state_21020__$1 = state_21020;
var statearr_21044_21076 = state_21020__$1;
(statearr_21044_21076[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (10))){
var inst_21015 = (state_21020[(2)]);
var _ = (function (){var statearr_21046 = state_21020;
(statearr_21046[(4)] = cljs.core.rest.call(null,(state_21020[(4)])));

return statearr_21046;
})();
var state_21020__$1 = state_21020;
var statearr_21047_21077 = state_21020__$1;
(statearr_21047_21077[(2)] = inst_21015);

(statearr_21047_21077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (18))){
var inst_20988 = (state_21020[(9)]);
var inst_20989 = (state_21020[(7)]);
var inst_20993 = (state_21020[(8)]);
var inst_21004 = (inst_20988 + (1));
var inst_21005 = cljs.core.conj.call(null,inst_20989,inst_20993);
var inst_20988__$1 = inst_21004;
var inst_20989__$1 = inst_21005;
var state_21020__$1 = (function (){var statearr_21048 = state_21020;
(statearr_21048[(9)] = inst_20988__$1);

(statearr_21048[(7)] = inst_20989__$1);

return statearr_21048;
})();
var statearr_21049_21078 = state_21020__$1;
(statearr_21049_21078[(2)] = null);

(statearr_21049_21078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (8))){
var inst_20984 = (state_21020[(2)]);
var inst_20985 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_20986 = start;
var inst_20987 = cljs.core.PersistentVector.EMPTY;
var inst_20988 = inst_20986;
var inst_20989 = inst_20987;
var state_21020__$1 = (function (){var statearr_21050 = state_21020;
(statearr_21050[(10)] = inst_20984);

(statearr_21050[(9)] = inst_20988);

(statearr_21050[(7)] = inst_20989);

(statearr_21050[(11)] = inst_20985);

return statearr_21050;
})();
var statearr_21051_21079 = state_21020__$1;
(statearr_21051_21079[(2)] = null);

(statearr_21051_21079[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2454__auto__ = null;
var fluree$db$storage$core$state_machine__2454__auto____0 = (function (){
var statearr_21052 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21052[(0)] = fluree$db$storage$core$state_machine__2454__auto__);

(statearr_21052[(1)] = (1));

return statearr_21052;
});
var fluree$db$storage$core$state_machine__2454__auto____1 = (function (state_21020){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_21020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e21053){var ex__2457__auto__ = e21053;
var statearr_21054_21080 = state_21020;
(statearr_21054_21080[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_21020[(4)]))){
var statearr_21055_21081 = state_21020;
(statearr_21055_21081[(1)] = cljs.core.first.call(null,(state_21020[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21082 = state_21020;
state_21020 = G__21082;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2454__auto__ = function(state_21020){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2454__auto____1.call(this,state_21020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2454__auto____0;
fluree$db$storage$core$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2454__auto____1;
return fluree$db$storage$core$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_21056 = f__2477__auto__.call(null);
(statearr_21056[(6)] = c__2476__auto__);

return statearr_21056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_21098){
var state_val_21099 = (state_21098[(1)]);
if((state_val_21099 === (1))){
var state_21098__$1 = state_21098;
var statearr_21100_21114 = state_21098__$1;
(statearr_21100_21114[(2)] = null);

(statearr_21100_21114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (2))){
var _ = (function (){var statearr_21101 = state_21098;
(statearr_21101[(4)] = cljs.core.cons.call(null,(5),(state_21098[(4)])));

return statearr_21101;
})();
var inst_21089 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_21098__$1 = state_21098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21098__$1,(6),inst_21089);
} else {
if((state_val_21099 === (3))){
var inst_21096 = (state_21098[(2)]);
var state_21098__$1 = state_21098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21098__$1,inst_21096);
} else {
if((state_val_21099 === (4))){
var inst_21083 = (state_21098[(2)]);
var state_21098__$1 = state_21098;
var statearr_21103_21115 = state_21098__$1;
(statearr_21103_21115[(2)] = inst_21083);

(statearr_21103_21115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (5))){
var _ = (function (){var statearr_21104 = state_21098;
(statearr_21104[(4)] = cljs.core.rest.call(null,(state_21098[(4)])));

return statearr_21104;
})();
var state_21098__$1 = state_21098;
var ex21102 = (state_21098__$1[(2)]);
var statearr_21105_21116 = state_21098__$1;
(statearr_21105_21116[(5)] = ex21102);


if((ex21102 instanceof Error)){
var statearr_21106_21117 = state_21098__$1;
(statearr_21106_21117[(1)] = (4));

(statearr_21106_21117[(5)] = null);

} else {
throw ex21102;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (6))){
var inst_21091 = (state_21098[(2)]);
var inst_21092 = fluree.db.util.async.throw_err.call(null,inst_21091);
var inst_21093 = cljs.core.first.call(null,inst_21092);
var _ = (function (){var statearr_21107 = state_21098;
(statearr_21107[(4)] = cljs.core.rest.call(null,(state_21098[(4)])));

return statearr_21107;
})();
var state_21098__$1 = state_21098;
var statearr_21108_21118 = state_21098__$1;
(statearr_21108_21118[(2)] = inst_21093);

(statearr_21108_21118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2454__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2454__auto____0 = (function (){
var statearr_21109 = [null,null,null,null,null,null,null];
(statearr_21109[(0)] = fluree$db$storage$core$block_$_state_machine__2454__auto__);

(statearr_21109[(1)] = (1));

return statearr_21109;
});
var fluree$db$storage$core$block_$_state_machine__2454__auto____1 = (function (state_21098){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_21098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e21110){var ex__2457__auto__ = e21110;
var statearr_21111_21119 = state_21098;
(statearr_21111_21119[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_21098[(4)]))){
var statearr_21112_21120 = state_21098;
(statearr_21112_21120[(1)] = cljs.core.first.call(null,(state_21098[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21121 = state_21098;
state_21098 = G__21121;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2454__auto__ = function(state_21098){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2454__auto____1.call(this,state_21098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2454__auto____0;
fluree$db$storage$core$block_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2454__auto____1;
return fluree$db$storage$core$block_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_21113 = f__2477__auto__.call(null);
(statearr_21113[(6)] = c__2476__auto__);

return statearr_21113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
