// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27467,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27471 = k27467;
var G__27471__$1 = (((G__27471 instanceof cljs.core.Keyword))?G__27471.fqn:null);
switch (G__27471__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27467,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__27472){
var vec__27473 = p__27472;
var k__4403__auto__ = cljs.core.nth.call(null,vec__27473,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__27473,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27466){
var self__ = this;
var G__27466__$1 = this;
return (new cljs.core.RecordIter((0),G__27466__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27468,other27469){
var self__ = this;
var this27468__$1 = this;
return (((!((other27469 == null)))) && ((this27468__$1.constructor === other27469.constructor)) && (cljs.core._EQ_.call(null,this27468__$1.conn,other27469.conn)) && (cljs.core._EQ_.call(null,this27468__$1.network,other27469.network)) && (cljs.core._EQ_.call(null,this27468__$1.dbid,other27469.dbid)) && (cljs.core._EQ_.call(null,this27468__$1.db_name,other27469.db_name)) && (cljs.core._EQ_.call(null,this27468__$1.update_chan,other27469.update_chan)) && (cljs.core._EQ_.call(null,this27468__$1.transact_chan,other27469.transact_chan)) && (cljs.core._EQ_.call(null,this27468__$1.state,other27469.state)) && (cljs.core._EQ_.call(null,this27468__$1.schema_cache,other27469.schema_cache)) && (cljs.core._EQ_.call(null,this27468__$1.blank_db,other27469.blank_db)) && (cljs.core._EQ_.call(null,this27468__$1.close,other27469.close)) && (cljs.core._EQ_.call(null,this27468__$1.id,other27469.id)) && (cljs.core._EQ_.call(null,this27468__$1.__extmap,other27469.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27466){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27476 = cljs.core.keyword_identical_QMARK_;
var expr__27477 = k__4388__auto__;
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27477))){
return (new fluree.db.session.DbSession(G__27466,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,G__27466,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27466,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27466,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27466,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27466,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27466,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27466,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27466,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27466,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27476.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27477))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27466,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__27466),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27466){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27466,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27470){
var extmap__4419__auto__ = (function (){var G__27479 = cljs.core.dissoc.call(null,G__27470,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27470)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27479);
} else {
return G__27479;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27470),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27470),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27481 = session;
var map__27481__$1 = (((((!((map__27481 == null))))?(((((map__27481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27481):map__27481);
var network = cljs.core.get.call(null,map__27481__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27481__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2476__auto___27699 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27626){
var state_val_27627 = (state_27626[(1)]);
if((state_val_27627 === (7))){
var state_27626__$1 = state_27626;
var statearr_27628_27700 = state_27626__$1;
(statearr_27628_27700[(2)] = false);

(statearr_27628_27700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (20))){
var inst_27515 = (state_27626[(7)]);
var inst_27523 = (state_27626[(8)]);
var inst_27516 = (state_27626[(9)]);
var inst_27532 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27523);
var inst_27533 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27515),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27516)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27532),"."].join('');
var state_27626__$1 = state_27626;
var statearr_27629_27701 = state_27626__$1;
(statearr_27629_27701[(2)] = inst_27533);

(statearr_27629_27701[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (27))){
var inst_27607 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
var statearr_27630_27702 = state_27626__$1;
(statearr_27630_27702[(2)] = inst_27607);

(statearr_27630_27702[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (1))){
var state_27626__$1 = state_27626;
var statearr_27631_27703 = state_27626__$1;
(statearr_27631_27703[(2)] = null);

(statearr_27631_27703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (24))){
var state_27626__$1 = state_27626;
var statearr_27632_27704 = state_27626__$1;
(statearr_27632_27704[(2)] = null);

(statearr_27632_27704[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (39))){
var state_27626__$1 = state_27626;
var statearr_27633_27705 = state_27626__$1;
(statearr_27633_27705[(2)] = false);

(statearr_27633_27705[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (46))){
var inst_27615 = (state_27626[(10)]);
var inst_27618 = (state_27626[(2)]);
var inst_27619 = fluree.db.util.async.throw_err.call(null,inst_27618);
var inst_27620 = cljs.core.assoc.call(null,inst_27615,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27619);
var inst_27621 = cljs.core.async.put_BANG_.call(null,pc,inst_27620);
var _ = (function (){var statearr_27634 = state_27626;
(statearr_27634[(4)] = cljs.core.rest.call(null,(state_27626[(4)])));

return statearr_27634;
})();
var state_27626__$1 = state_27626;
var statearr_27635_27706 = state_27626__$1;
(statearr_27635_27706[(2)] = inst_27621);

(statearr_27635_27706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (4))){
var inst_27483 = (state_27626[(2)]);
var inst_27484 = cljs.core.async.put_BANG_.call(null,pc,inst_27483);
var state_27626__$1 = state_27626;
var statearr_27636_27707 = state_27626__$1;
(statearr_27636_27707[(2)] = inst_27484);

(statearr_27636_27707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (15))){
var inst_27523 = (state_27626[(8)]);
var inst_27522 = (state_27626[(2)]);
var inst_27523__$1 = fluree.db.util.async.throw_err.call(null,inst_27522);
var inst_27524 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27523__$1);
var inst_27525 = cljs.core.keyword.call(null,inst_27524);
var inst_27526 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27525);
var state_27626__$1 = (function (){var statearr_27637 = state_27626;
(statearr_27637[(8)] = inst_27523__$1);

return statearr_27637;
})();
if(inst_27526){
var statearr_27638_27708 = state_27626__$1;
(statearr_27638_27708[(1)] = (16));

} else {
var statearr_27639_27709 = state_27626__$1;
(statearr_27639_27709[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (21))){
var inst_27535 = (state_27626[(2)]);
var inst_27536 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27537 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27538 = cljs.core.PersistentHashMap.fromArrays(inst_27536,inst_27537);
var inst_27539 = cljs.core.ex_info.call(null,inst_27535,inst_27538);
var inst_27540 = (function(){throw inst_27539})();
var state_27626__$1 = state_27626;
var statearr_27640_27710 = state_27626__$1;
(statearr_27640_27710[(2)] = inst_27540);

(statearr_27640_27710[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (31))){
var inst_27562 = (state_27626[(11)]);
var inst_27561 = (state_27626[(2)]);
var inst_27562__$1 = fluree.db.util.async.throw_err.call(null,inst_27561);
var state_27626__$1 = (function (){var statearr_27641 = state_27626;
(statearr_27641[(11)] = inst_27562__$1);

return statearr_27641;
})();
if(cljs.core.truth_(inst_27562__$1)){
var statearr_27642_27711 = state_27626__$1;
(statearr_27642_27711[(1)] = (32));

} else {
var statearr_27643_27712 = state_27626__$1;
(statearr_27643_27712[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (32))){
var inst_27562 = (state_27626[(11)]);
var inst_27566 = (inst_27562 == null);
var inst_27567 = cljs.core.not.call(null,inst_27566);
var state_27626__$1 = state_27626;
if(inst_27567){
var statearr_27644_27713 = state_27626__$1;
(statearr_27644_27713[(1)] = (35));

} else {
var statearr_27645_27714 = state_27626__$1;
(statearr_27645_27714[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (40))){
var inst_27577 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
var statearr_27646_27715 = state_27626__$1;
(statearr_27646_27715[(2)] = inst_27577);

(statearr_27646_27715[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (33))){
var inst_27515 = (state_27626[(7)]);
var inst_27554 = (state_27626[(12)]);
var inst_27516 = (state_27626[(9)]);
var inst_27596 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27554)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27515),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27516),"."].join('');
var inst_27597 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27598 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27599 = cljs.core.PersistentHashMap.fromArrays(inst_27597,inst_27598);
var inst_27600 = cljs.core.ex_info.call(null,inst_27596,inst_27599);
var inst_27601 = (function(){throw inst_27600})();
var state_27626__$1 = state_27626;
var statearr_27647_27716 = state_27626__$1;
(statearr_27647_27716[(2)] = inst_27601);

(statearr_27647_27716[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (13))){
var inst_27492 = (state_27626[(13)]);
var state_27626__$1 = state_27626;
var statearr_27648_27717 = state_27626__$1;
(statearr_27648_27717[(2)] = inst_27492);

(statearr_27648_27717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (22))){
var inst_27523 = (state_27626[(8)]);
var inst_27548 = (state_27626[(14)]);
var inst_27547 = (state_27626[(2)]);
var inst_27548__$1 = fluree.db.util.async.throw_err.call(null,inst_27547);
var inst_27549 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27523);
var state_27626__$1 = (function (){var statearr_27649 = state_27626;
(statearr_27649[(15)] = inst_27549);

(statearr_27649[(14)] = inst_27548__$1);

return statearr_27649;
})();
if(cljs.core.truth_(inst_27548__$1)){
var statearr_27650_27718 = state_27626__$1;
(statearr_27650_27718[(1)] = (23));

} else {
var statearr_27651_27719 = state_27626__$1;
(statearr_27651_27719[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (36))){
var state_27626__$1 = state_27626;
var statearr_27652_27720 = state_27626__$1;
(statearr_27652_27720[(2)] = false);

(statearr_27652_27720[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (41))){
var inst_27562 = (state_27626[(11)]);
var inst_27582 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27562);
var state_27626__$1 = state_27626;
var statearr_27653_27721 = state_27626__$1;
(statearr_27653_27721[(2)] = inst_27582);

(statearr_27653_27721[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (43))){
var inst_27553 = (state_27626[(16)]);
var inst_27585 = (state_27626[(2)]);
var inst_27586 = cljs.core.get.call(null,inst_27585,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27587 = cljs.core.get.call(null,inst_27585,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27588 = cljs.core.get.call(null,inst_27585,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27589 = fluree.db.dbproto._with.call(null,inst_27553,inst_27587,inst_27586);
var state_27626__$1 = (function (){var statearr_27654 = state_27626;
(statearr_27654[(17)] = inst_27588);

return statearr_27654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(44),inst_27589);
} else {
if((state_val_27627 === (29))){
var inst_27515 = (state_27626[(7)]);
var inst_27514 = (state_27626[(18)]);
var inst_27554 = (state_27626[(12)]);
var inst_27516 = (state_27626[(9)]);
var inst_27559 = fluree.db.storage.core.read_block.call(null,inst_27514,inst_27515,inst_27516,inst_27554);
var state_27626__$1 = state_27626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(31),inst_27559);
} else {
if((state_val_27627 === (44))){
var inst_27554 = (state_27626[(12)]);
var inst_27591 = (state_27626[(2)]);
var inst_27592 = fluree.db.util.async.throw_err.call(null,inst_27591);
var inst_27593 = (inst_27554 + (1));
var inst_27553 = inst_27592;
var inst_27554__$1 = inst_27593;
var state_27626__$1 = (function (){var statearr_27655 = state_27626;
(statearr_27655[(12)] = inst_27554__$1);

(statearr_27655[(16)] = inst_27553);

return statearr_27655;
})();
var statearr_27656_27722 = state_27626__$1;
(statearr_27656_27722[(2)] = null);

(statearr_27656_27722[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (6))){
var inst_27492 = (state_27626[(13)]);
var inst_27497 = inst_27492.cljs$lang$protocol_mask$partition0$;
var inst_27498 = (inst_27497 & (64));
var inst_27499 = inst_27492.cljs$core$ISeq$;
var inst_27500 = (cljs.core.PROTOCOL_SENTINEL === inst_27499);
var inst_27501 = ((inst_27498) || (inst_27500));
var state_27626__$1 = state_27626;
if(cljs.core.truth_(inst_27501)){
var statearr_27657_27723 = state_27626__$1;
(statearr_27657_27723[(1)] = (9));

} else {
var statearr_27658_27724 = state_27626__$1;
(statearr_27658_27724[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (28))){
var inst_27553 = (state_27626[(16)]);
var state_27626__$1 = state_27626;
var statearr_27659_27725 = state_27626__$1;
(statearr_27659_27725[(2)] = inst_27553);

(statearr_27659_27725[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (25))){
var inst_27610 = (state_27626[(19)]);
var inst_27610__$1 = (state_27626[(2)]);
var inst_27611 = fluree.db.query.schema.schema_map.call(null,inst_27610__$1);
var state_27626__$1 = (function (){var statearr_27660 = state_27626;
(statearr_27660[(19)] = inst_27610__$1);

return statearr_27660;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(45),inst_27611);
} else {
if((state_val_27627 === (34))){
var inst_27603 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
var statearr_27661_27726 = state_27626__$1;
(statearr_27661_27726[(2)] = inst_27603);

(statearr_27661_27726[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (17))){
var state_27626__$1 = state_27626;
var statearr_27662_27727 = state_27626__$1;
(statearr_27662_27727[(2)] = null);

(statearr_27662_27727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (3))){
var inst_27624 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27626__$1,inst_27624);
} else {
if((state_val_27627 === (12))){
var inst_27492 = (state_27626[(13)]);
var inst_27510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27492);
var state_27626__$1 = state_27626;
var statearr_27663_27728 = state_27626__$1;
(statearr_27663_27728[(2)] = inst_27510);

(statearr_27663_27728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (2))){
var inst_27492 = (state_27626[(13)]);
var _ = (function (){var statearr_27664 = state_27626;
(statearr_27664[(4)] = cljs.core.cons.call(null,(5),(state_27626[(4)])));

return statearr_27664;
})();
var inst_27491 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27492__$1 = session;
var inst_27494 = (inst_27492__$1 == null);
var inst_27495 = cljs.core.not.call(null,inst_27494);
var state_27626__$1 = (function (){var statearr_27665 = state_27626;
(statearr_27665[(13)] = inst_27492__$1);

(statearr_27665[(20)] = inst_27491);

return statearr_27665;
})();
if(inst_27495){
var statearr_27666_27729 = state_27626__$1;
(statearr_27666_27729[(1)] = (6));

} else {
var statearr_27667_27730 = state_27626__$1;
(statearr_27667_27730[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (23))){
var inst_27548 = (state_27626[(14)]);
var inst_27551 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27548);
var inst_27552 = (inst_27551 + (1));
var inst_27553 = inst_27548;
var inst_27554 = inst_27552;
var state_27626__$1 = (function (){var statearr_27668 = state_27626;
(statearr_27668[(12)] = inst_27554);

(statearr_27668[(16)] = inst_27553);

return statearr_27668;
})();
var statearr_27669_27731 = state_27626__$1;
(statearr_27669_27731[(2)] = null);

(statearr_27669_27731[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (35))){
var inst_27562 = (state_27626[(11)]);
var inst_27569 = inst_27562.cljs$lang$protocol_mask$partition0$;
var inst_27570 = (inst_27569 & (64));
var inst_27571 = inst_27562.cljs$core$ISeq$;
var inst_27572 = (cljs.core.PROTOCOL_SENTINEL === inst_27571);
var inst_27573 = ((inst_27570) || (inst_27572));
var state_27626__$1 = state_27626;
if(cljs.core.truth_(inst_27573)){
var statearr_27670_27732 = state_27626__$1;
(statearr_27670_27732[(1)] = (38));

} else {
var statearr_27671_27733 = state_27626__$1;
(statearr_27671_27733[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (19))){
var inst_27515 = (state_27626[(7)]);
var inst_27516 = (state_27626[(9)]);
var inst_27530 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27515),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27516)," is not found on this ledger group."].join('');
var state_27626__$1 = state_27626;
var statearr_27672_27734 = state_27626__$1;
(statearr_27672_27734[(2)] = inst_27530);

(statearr_27672_27734[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (11))){
var inst_27505 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
var statearr_27674_27735 = state_27626__$1;
(statearr_27674_27735[(2)] = inst_27505);

(statearr_27674_27735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (9))){
var state_27626__$1 = state_27626;
var statearr_27675_27736 = state_27626__$1;
(statearr_27675_27736[(2)] = true);

(statearr_27675_27736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (5))){
var _ = (function (){var statearr_27676 = state_27626;
(statearr_27676[(4)] = cljs.core.rest.call(null,(state_27626[(4)])));

return statearr_27676;
})();
var state_27626__$1 = state_27626;
var ex27673 = (state_27626__$1[(2)]);
var statearr_27677_27737 = state_27626__$1;
(statearr_27677_27737[(5)] = ex27673);


if((ex27673 instanceof java.lang.Exception)){
var statearr_27678_27738 = state_27626__$1;
(statearr_27678_27738[(1)] = (4));

(statearr_27678_27738[(5)] = null);

} else {
throw ex27673;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (14))){
var inst_27515 = (state_27626[(7)]);
var inst_27514 = (state_27626[(18)]);
var inst_27516 = (state_27626[(9)]);
var inst_27513 = (state_27626[(2)]);
var inst_27514__$1 = cljs.core.get.call(null,inst_27513,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27515__$1 = cljs.core.get.call(null,inst_27513,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27516__$1 = cljs.core.get.call(null,inst_27513,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27518 = [inst_27515__$1,inst_27516__$1];
var inst_27519 = (new cljs.core.PersistentVector(null,2,(5),inst_27517,inst_27518,null));
var inst_27520 = fluree.db.operations.ledger_info_async.call(null,inst_27514__$1,inst_27519);
var state_27626__$1 = (function (){var statearr_27679 = state_27626;
(statearr_27679[(7)] = inst_27515__$1);

(statearr_27679[(18)] = inst_27514__$1);

(statearr_27679[(9)] = inst_27516__$1);

return statearr_27679;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(15),inst_27520);
} else {
if((state_val_27627 === (45))){
var inst_27610 = (state_27626[(19)]);
var inst_27615 = (state_27626[(10)]);
var inst_27613 = (state_27626[(2)]);
var inst_27614 = fluree.db.util.async.throw_err.call(null,inst_27613);
var inst_27615__$1 = cljs.core.assoc.call(null,inst_27610,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27614);
var inst_27616 = fluree.db.query.schema.setting_map.call(null,inst_27615__$1);
var state_27626__$1 = (function (){var statearr_27680 = state_27626;
(statearr_27680[(10)] = inst_27615__$1);

return statearr_27680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(46),inst_27616);
} else {
if((state_val_27627 === (26))){
var inst_27549 = (state_27626[(15)]);
var inst_27554 = (state_27626[(12)]);
var inst_27556 = (inst_27554 > inst_27549);
var state_27626__$1 = state_27626;
if(cljs.core.truth_(inst_27556)){
var statearr_27681_27739 = state_27626__$1;
(statearr_27681_27739[(1)] = (28));

} else {
var statearr_27682_27740 = state_27626__$1;
(statearr_27682_27740[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (16))){
var inst_27523 = (state_27626[(8)]);
var inst_27528 = cljs.core.empty_QMARK_.call(null,inst_27523);
var state_27626__$1 = state_27626;
if(inst_27528){
var statearr_27683_27741 = state_27626__$1;
(statearr_27683_27741[(1)] = (19));

} else {
var statearr_27684_27742 = state_27626__$1;
(statearr_27684_27742[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (38))){
var state_27626__$1 = state_27626;
var statearr_27685_27743 = state_27626__$1;
(statearr_27685_27743[(2)] = true);

(statearr_27685_27743[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (30))){
var inst_27605 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
var statearr_27686_27744 = state_27626__$1;
(statearr_27686_27744[(2)] = inst_27605);

(statearr_27686_27744[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (10))){
var state_27626__$1 = state_27626;
var statearr_27687_27745 = state_27626__$1;
(statearr_27687_27745[(2)] = false);

(statearr_27687_27745[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (18))){
var inst_27515 = (state_27626[(7)]);
var inst_27523 = (state_27626[(8)]);
var inst_27514 = (state_27626[(18)]);
var inst_27491 = (state_27626[(20)]);
var inst_27516 = (state_27626[(9)]);
var inst_27543 = (state_27626[(2)]);
var inst_27544 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27523);
var inst_27545 = fluree.db.storage.core.reify_db.call(null,inst_27514,inst_27515,inst_27516,inst_27491,inst_27544);
var state_27626__$1 = (function (){var statearr_27688 = state_27626;
(statearr_27688[(21)] = inst_27543);

return statearr_27688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27626__$1,(22),inst_27545);
} else {
if((state_val_27627 === (42))){
var inst_27562 = (state_27626[(11)]);
var state_27626__$1 = state_27626;
var statearr_27689_27746 = state_27626__$1;
(statearr_27689_27746[(2)] = inst_27562);

(statearr_27689_27746[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (37))){
var inst_27580 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
if(cljs.core.truth_(inst_27580)){
var statearr_27690_27747 = state_27626__$1;
(statearr_27690_27747[(1)] = (41));

} else {
var statearr_27691_27748 = state_27626__$1;
(statearr_27691_27748[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27627 === (8))){
var inst_27508 = (state_27626[(2)]);
var state_27626__$1 = state_27626;
if(cljs.core.truth_(inst_27508)){
var statearr_27692_27749 = state_27626__$1;
(statearr_27692_27749[(1)] = (12));

} else {
var statearr_27693_27750 = state_27626__$1;
(statearr_27693_27750[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____0 = (function (){
var statearr_27694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27694[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__);

(statearr_27694[(1)] = (1));

return statearr_27694;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____1 = (function (state_27626){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27695){var ex__2457__auto__ = e27695;
var statearr_27696_27751 = state_27626;
(statearr_27696_27751[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27626[(4)]))){
var statearr_27697_27752 = state_27626;
(statearr_27697_27752[(1)] = cljs.core.first.call(null,(state_27626[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27753 = state_27626;
state_27626 = G__27753;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__ = function(state_27626){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____1.call(this,state_27626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2454__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27698 = f__2477__auto__.call(null);
(statearr_27698[(6)] = c__2476__auto___27699);

return statearr_27698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27754 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__27754,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27754;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27756){
var map__27757 = p__27756;
var map__27757__$1 = (((((!((map__27757 == null))))?(((((map__27757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27757):map__27757);
var data = map__27757__$1;
var block = cljs.core.get.call(null,map__27757__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27757__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27757__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27806){
var state_val_27807 = (state_27806[(1)]);
if((state_val_27807 === (7))){
var inst_27772 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27773 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27774 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27772),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27773),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27775 = fluree.db.util.log.info.call(null,inst_27774);
var state_27806__$1 = state_27806;
var statearr_27808_27838 = state_27806__$1;
(statearr_27808_27838[(2)] = inst_27775);

(statearr_27808_27838[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (1))){
var state_27806__$1 = state_27806;
var statearr_27809_27839 = state_27806__$1;
(statearr_27809_27839[(2)] = null);

(statearr_27809_27839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (4))){
var inst_27759 = (state_27806[(2)]);
var state_27806__$1 = state_27806;
var statearr_27810_27840 = state_27806__$1;
(statearr_27810_27840[(2)] = inst_27759);

(statearr_27810_27840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (15))){
var inst_27797 = (state_27806[(2)]);
var state_27806__$1 = state_27806;
var statearr_27811_27841 = state_27806__$1;
(statearr_27811_27841[(2)] = inst_27797);

(statearr_27811_27841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (13))){
var inst_27769 = (state_27806[(7)]);
var inst_27790 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27791 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27792 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27790),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27791),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27769),". Forcing a db reload."].join('');
var inst_27793 = fluree.db.util.log.info.call(null,inst_27792);
var inst_27794 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27806__$1 = (function (){var statearr_27812 = state_27806;
(statearr_27812[(8)] = inst_27793);

return statearr_27812;
})();
var statearr_27813_27842 = state_27806__$1;
(statearr_27813_27842[(2)] = inst_27794);

(statearr_27813_27842[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (6))){
var inst_27769 = (state_27806[(7)]);
var inst_27768 = (state_27806[(9)]);
var inst_27767 = (state_27806[(2)]);
var inst_27768__$1 = fluree.db.util.async.throw_err.call(null,inst_27767);
var inst_27769__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27768__$1);
var inst_27770 = (block <= inst_27769__$1);
var state_27806__$1 = (function (){var statearr_27814 = state_27806;
(statearr_27814[(7)] = inst_27769__$1);

(statearr_27814[(9)] = inst_27768__$1);

return statearr_27814;
})();
if(cljs.core.truth_(inst_27770)){
var statearr_27815_27843 = state_27806__$1;
(statearr_27815_27843[(1)] = (7));

} else {
var statearr_27816_27844 = state_27806__$1;
(statearr_27816_27844[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (3))){
var inst_27804 = (state_27806[(2)]);
var state_27806__$1 = state_27806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27806__$1,inst_27804);
} else {
if((state_val_27807 === (12))){
var inst_27799 = (state_27806[(2)]);
var state_27806__$1 = state_27806;
var statearr_27817_27845 = state_27806__$1;
(statearr_27817_27845[(2)] = inst_27799);

(statearr_27817_27845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (2))){
var inst_27765 = (state_27806[(10)]);
var _ = (function (){var statearr_27818 = state_27806;
(statearr_27818[(4)] = cljs.core.cons.call(null,(5),(state_27806[(4)])));

return statearr_27818;
})();
var inst_27765__$1 = fluree.db.session.current_db.call(null,session);
var state_27806__$1 = (function (){var statearr_27819 = state_27806;
(statearr_27819[(10)] = inst_27765__$1);

return statearr_27819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27806__$1,(6),inst_27765__$1);
} else {
if((state_val_27807 === (11))){
var state_27806__$1 = state_27806;
var statearr_27821_27846 = state_27806__$1;
(statearr_27821_27846[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (9))){
var inst_27801 = (state_27806[(2)]);
var _ = (function (){var statearr_27823 = state_27806;
(statearr_27823[(4)] = cljs.core.rest.call(null,(state_27806[(4)])));

return statearr_27823;
})();
var state_27806__$1 = state_27806;
var statearr_27824_27847 = state_27806__$1;
(statearr_27824_27847[(2)] = inst_27801);

(statearr_27824_27847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (5))){
var _ = (function (){var statearr_27825 = state_27806;
(statearr_27825[(4)] = cljs.core.rest.call(null,(state_27806[(4)])));

return statearr_27825;
})();
var state_27806__$1 = state_27806;
var ex27820 = (state_27806__$1[(2)]);
var statearr_27826_27848 = state_27806__$1;
(statearr_27826_27848[(5)] = ex27820);


if((ex27820 instanceof Error)){
var statearr_27827_27849 = state_27806__$1;
(statearr_27827_27849[(1)] = (4));

(statearr_27827_27849[(5)] = null);

} else {
throw ex27820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (14))){
var state_27806__$1 = state_27806;
var statearr_27828_27850 = state_27806__$1;
(statearr_27828_27850[(2)] = null);

(statearr_27828_27850[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (10))){
var inst_27769 = (state_27806[(7)]);
var inst_27768 = (state_27806[(9)]);
var inst_27765 = (state_27806[(10)]);
var inst_27780 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27781 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27782 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27780),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27781),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27783 = fluree.db.util.log.trace.call(null,inst_27782);
var inst_27784 = (function (){var current_db_ch = inst_27765;
var current_db = inst_27768;
var current_block = inst_27769;
return (function (p1__27755_SHARP_){
if((p1__27755_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27755_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__27755_SHARP_);
}
});
})();
var inst_27785 = cljs.core.map.call(null,inst_27784,flakes);
var inst_27786 = fluree.db.dbproto._with.call(null,inst_27768,block,inst_27785);
var inst_27787 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27765,inst_27786);
var state_27806__$1 = (function (){var statearr_27829 = state_27806;
(statearr_27829[(11)] = inst_27783);

return statearr_27829;
})();
var statearr_27830_27851 = state_27806__$1;
(statearr_27830_27851[(2)] = inst_27787);

(statearr_27830_27851[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27807 === (8))){
var inst_27769 = (state_27806[(7)]);
var inst_27777 = ((1) + inst_27769);
var inst_27778 = cljs.core._EQ_.call(null,block,inst_27777);
var state_27806__$1 = state_27806;
if(inst_27778){
var statearr_27831_27852 = state_27806__$1;
(statearr_27831_27852[(1)] = (10));

} else {
var statearr_27832_27853 = state_27806__$1;
(statearr_27832_27853[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2454__auto__ = null;
var fluree$db$session$state_machine__2454__auto____0 = (function (){
var statearr_27833 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27833[(0)] = fluree$db$session$state_machine__2454__auto__);

(statearr_27833[(1)] = (1));

return statearr_27833;
});
var fluree$db$session$state_machine__2454__auto____1 = (function (state_27806){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27834){var ex__2457__auto__ = e27834;
var statearr_27835_27854 = state_27806;
(statearr_27835_27854[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27806[(4)]))){
var statearr_27836_27855 = state_27806;
(statearr_27836_27855[(1)] = cljs.core.first.call(null,(state_27806[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27856 = state_27806;
state_27806 = G__27856;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$session$state_machine__2454__auto__ = function(state_27806){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2454__auto____1.call(this,state_27806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2454__auto____0;
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2454__auto____1;
return fluree$db$session$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27837 = f__2477__auto__.call(null);
(statearr_27837[(6)] = c__2476__auto__);

return statearr_27837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27863){
var state_val_27864 = (state_27863[(1)]);
if((state_val_27864 === (1))){
var inst_27857 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27858 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27859 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27860 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27858),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27859)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27861 = fluree.db.util.log.debug.call(null,inst_27860);
var state_27863__$1 = (function (){var statearr_27865 = state_27863;
(statearr_27865[(7)] = inst_27857);

(statearr_27865[(8)] = inst_27861);

return statearr_27865;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27863__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2454__auto__ = null;
var fluree$db$session$state_machine__2454__auto____0 = (function (){
var statearr_27866 = [null,null,null,null,null,null,null,null,null];
(statearr_27866[(0)] = fluree$db$session$state_machine__2454__auto__);

(statearr_27866[(1)] = (1));

return statearr_27866;
});
var fluree$db$session$state_machine__2454__auto____1 = (function (state_27863){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27867){var ex__2457__auto__ = e27867;
var statearr_27868_27871 = state_27863;
(statearr_27868_27871[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27863[(4)]))){
var statearr_27869_27872 = state_27863;
(statearr_27869_27872[(1)] = cljs.core.first.call(null,(state_27863[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27873 = state_27863;
state_27863 = G__27873;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$session$state_machine__2454__auto__ = function(state_27863){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2454__auto____1.call(this,state_27863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2454__auto____0;
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2454__auto____1;
return fluree$db$session$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27870 = f__2477__auto__.call(null);
(statearr_27870[(6)] = c__2476__auto__);

return statearr_27870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27875 = arguments.length;
switch (G__27875) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__27876 = session;
var map__27876__$1 = (((((!((map__27876 == null))))?(((((map__27876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27876):map__27876);
var conn = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__27876__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27931){
var state_val_27932 = (state_27931[(1)]);
if((state_val_27932 === (7))){
var inst_27927 = (state_27931[(2)]);
var state_27931__$1 = state_27931;
var statearr_27933_27964 = state_27931__$1;
(statearr_27933_27964[(2)] = inst_27927);

(statearr_27933_27964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (1))){
var state_27931__$1 = state_27931;
var statearr_27934_27965 = state_27931__$1;
(statearr_27934_27965[(2)] = null);

(statearr_27934_27965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (4))){
var inst_27882 = (state_27931[(7)]);
var inst_27881 = (state_27931[(2)]);
var inst_27882__$1 = fluree.db.util.async.throw_err.call(null,inst_27881);
var inst_27883 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27884 = (inst_27882__$1 == null);
var state_27931__$1 = (function (){var statearr_27935 = state_27931;
(statearr_27935[(7)] = inst_27882__$1);

(statearr_27935[(8)] = inst_27883);

return statearr_27935;
})();
if(cljs.core.truth_(inst_27884)){
var statearr_27936_27966 = state_27931__$1;
(statearr_27936_27966[(1)] = (5));

} else {
var statearr_27937_27967 = state_27931__$1;
(statearr_27937_27967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (15))){
var inst_27919 = (state_27931[(2)]);
var state_27931__$1 = (function (){var statearr_27938 = state_27931;
(statearr_27938[(9)] = inst_27919);

return statearr_27938;
})();
var statearr_27939_27968 = state_27931__$1;
(statearr_27939_27968[(2)] = null);

(statearr_27939_27968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (13))){
var inst_27923 = (state_27931[(2)]);
var state_27931__$1 = state_27931;
var statearr_27941_27969 = state_27931__$1;
(statearr_27941_27969[(2)] = inst_27923);

(statearr_27941_27969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (6))){
var inst_27883 = (state_27931[(8)]);
var inst_27889 = (inst_27883 == null);
var state_27931__$1 = state_27931;
if(cljs.core.truth_(inst_27889)){
var statearr_27942_27970 = state_27931__$1;
(statearr_27942_27970[(1)] = (8));

} else {
var statearr_27943_27971 = state_27931__$1;
(statearr_27943_27971[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (17))){
var _ = (function (){var statearr_27944 = state_27931;
(statearr_27944[(4)] = cljs.core.rest.call(null,(state_27931[(4)])));

return statearr_27944;
})();
var state_27931__$1 = state_27931;
var ex27940 = (state_27931__$1[(2)]);
var statearr_27945_27972 = state_27931__$1;
(statearr_27945_27972[(5)] = ex27940);


if((ex27940 instanceof java.lang.Exception)){
var statearr_27946_27973 = state_27931__$1;
(statearr_27946_27973[(1)] = (16));

(statearr_27946_27973[(5)] = null);

} else {
throw ex27940;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (3))){
var inst_27929 = (state_27931[(2)]);
var state_27931__$1 = state_27931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27931__$1,inst_27929);
} else {
if((state_val_27932 === (12))){
var state_27931__$1 = state_27931;
var statearr_27947_27974 = state_27931__$1;
(statearr_27947_27974[(2)] = null);

(statearr_27947_27974[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (2))){
var state_27931__$1 = state_27931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27931__$1,(4),update_chan);
} else {
if((state_val_27932 === (11))){
var state_27931__$1 = state_27931;
var statearr_27948_27975 = state_27931__$1;
(statearr_27948_27975[(2)] = null);

(statearr_27948_27975[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (9))){
var state_27931__$1 = state_27931;
var statearr_27949_27976 = state_27931__$1;
(statearr_27949_27976[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (5))){
var inst_27886 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27887 = fluree.db.util.log.info.call(null,inst_27886);
var state_27931__$1 = state_27931;
var statearr_27951_27977 = state_27931__$1;
(statearr_27951_27977[(2)] = inst_27887);

(statearr_27951_27977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (14))){
var inst_27882 = (state_27931[(7)]);
var inst_27883 = (state_27931[(8)]);
var _ = (function (){var statearr_27952 = state_27931;
(statearr_27952[(4)] = cljs.core.cons.call(null,(17),(state_27931[(4)])));

return statearr_27952;
})();
var inst_27907 = cljs.core.nth.call(null,inst_27882,(0),null);
var inst_27908 = cljs.core.nth.call(null,inst_27882,(1),null);
var inst_27909 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27910 = cljs.core.pr_str.call(null,inst_27882);
var inst_27911 = fluree.db.util.core.trunc.call(null,inst_27910,(200));
var inst_27912 = fluree.db.util.log.trace.call(null,inst_27909,inst_27911);
var inst_27913 = fluree.db.session.process_ledger_update.call(null,inst_27883,inst_27907,inst_27908);
var state_27931__$1 = (function (){var statearr_27953 = state_27931;
(statearr_27953[(10)] = inst_27912);

return statearr_27953;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27931__$1,(18),inst_27913);
} else {
if((state_val_27932 === (16))){
var inst_27882 = (state_27931[(7)]);
var inst_27897 = (state_27931[(2)]);
var inst_27898 = fluree.db.util.log.error.call(null,inst_27897,"Exception processing ledger updates for message: ",inst_27882);
var state_27931__$1 = state_27931;
var statearr_27954_27978 = state_27931__$1;
(statearr_27954_27978[(2)] = inst_27898);

(statearr_27954_27978[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (10))){
var inst_27925 = (state_27931[(2)]);
var state_27931__$1 = state_27931;
var statearr_27955_27979 = state_27931__$1;
(statearr_27955_27979[(2)] = inst_27925);

(statearr_27955_27979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (18))){
var inst_27915 = (state_27931[(2)]);
var inst_27916 = fluree.db.util.async.throw_err.call(null,inst_27915);
var _ = (function (){var statearr_27956 = state_27931;
(statearr_27956[(4)] = cljs.core.rest.call(null,(state_27931[(4)])));

return statearr_27956;
})();
var state_27931__$1 = state_27931;
var statearr_27957_27980 = state_27931__$1;
(statearr_27957_27980[(2)] = inst_27916);

(statearr_27957_27980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27932 === (8))){
var inst_27882 = (state_27931[(7)]);
var inst_27891 = cljs.core.first.call(null,inst_27882);
var inst_27892 = cljs.core.pr_str.call(null,inst_27891);
var inst_27893 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_27892].join('');
var inst_27894 = fluree.db.util.log.warn.call(null,inst_27893);
var state_27931__$1 = state_27931;
var statearr_27958_27981 = state_27931__$1;
(statearr_27958_27981[(2)] = inst_27894);

(statearr_27958_27981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____0 = (function (){
var statearr_27959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27959[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__);

(statearr_27959[(1)] = (1));

return statearr_27959;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____1 = (function (state_27931){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27960){var ex__2457__auto__ = e27960;
var statearr_27961_27982 = state_27931;
(statearr_27961_27982[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27931[(4)]))){
var statearr_27962_27983 = state_27931;
(statearr_27962_27983[(1)] = cljs.core.first.call(null,(state_27931[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27984 = state_27931;
state_27931 = G__27984;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__ = function(state_27931){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____1.call(this,state_27931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2454__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27963 = f__2477__auto__.call(null);
(statearr_27963[(6)] = c__2476__auto__);

return statearr_27963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27985){
var map__27986 = p__27985;
var map__27986__$1 = (((((!((map__27986 == null))))?(((((map__27986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27986):map__27986);
var network = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27986__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27991 = block_result;
var map__27991__$1 = (((((!((map__27991 == null))))?(((((map__27991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27991):map__27991);
var block = cljs.core.get.call(null,map__27991__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27991__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27991__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27991__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27991__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27992 = tx_result;
var map__27992__$1 = (((((!((map__27992 == null))))?(((((map__27992.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27992.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27992):map__27992);
var t = cljs.core.get.call(null,map__27992__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27992__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27988_SHARP_){
return cljs.core._EQ_.call(null,t,p1__27988_SHARP_.t);
}):(function (p1__27989_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27989_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27990_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27990_SHARP_))){
return cljs.core.nth.call(null,p1__27990_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27995 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27995,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27995,(1),null);
var error = cljs.core.nth.call(null,vec__27995,(2),null);
var message = cljs.core.nth.call(null,vec__27995,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = fluree.db.util.core.random_uuid.call(null);
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27999 = arguments.length;
switch (G__27999) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28000){
var map__28001 = p__28000;
var map__28001__$1 = (((((!((map__28001 == null))))?(((((map__28001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28001.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28001):map__28001);
var state = cljs.core.get.call(null,map__28001__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__28001__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__28001__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__28001__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28003 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__28003,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__28003,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__28003,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28006 = cljs.core.seq.call(null,tids);
var chunk__28007 = null;
var count__28008 = (0);
var i__28009 = (0);
while(true){
if((i__28009 < count__28008)){
var tid = cljs.core._nth.call(null,chunk__28007,i__28009);
var temp__5735__auto___28122__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___28122__$1)){
var keyed_callbacks_28123 = temp__5735__auto___28122__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28124 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28050_28125 = cljs.core.seq.call(null,keyed_callbacks_28123);
var chunk__28051_28126 = null;
var count__28052_28127 = (0);
var i__28053_28128 = (0);
while(true){
if((i__28053_28128 < count__28052_28127)){
var vec__28062_28129 = cljs.core._nth.call(null,chunk__28051_28126,i__28053_28128);
var k_28130 = cljs.core.nth.call(null,vec__28062_28129,(0),null);
var f_28131 = cljs.core.nth.call(null,vec__28062_28129,(1),null);
try{f_28131.call(null,tx_response_28124);
}catch (e28065){if((e28065 instanceof java.lang.Exception)){
var e_28132 = e28065;
fluree.db.util.log.error.call(null,e_28132,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e28065;

}
}

var G__28133 = seq__28050_28125;
var G__28134 = chunk__28051_28126;
var G__28135 = count__28052_28127;
var G__28136 = (i__28053_28128 + (1));
seq__28050_28125 = G__28133;
chunk__28051_28126 = G__28134;
count__28052_28127 = G__28135;
i__28053_28128 = G__28136;
continue;
} else {
var temp__5735__auto___28137__$2 = cljs.core.seq.call(null,seq__28050_28125);
if(temp__5735__auto___28137__$2){
var seq__28050_28138__$1 = temp__5735__auto___28137__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28050_28138__$1)){
var c__4556__auto___28139 = cljs.core.chunk_first.call(null,seq__28050_28138__$1);
var G__28140 = cljs.core.chunk_rest.call(null,seq__28050_28138__$1);
var G__28141 = c__4556__auto___28139;
var G__28142 = cljs.core.count.call(null,c__4556__auto___28139);
var G__28143 = (0);
seq__28050_28125 = G__28140;
chunk__28051_28126 = G__28141;
count__28052_28127 = G__28142;
i__28053_28128 = G__28143;
continue;
} else {
var vec__28066_28144 = cljs.core.first.call(null,seq__28050_28138__$1);
var k_28145 = cljs.core.nth.call(null,vec__28066_28144,(0),null);
var f_28146 = cljs.core.nth.call(null,vec__28066_28144,(1),null);
try{f_28146.call(null,tx_response_28124);
}catch (e28069){if((e28069 instanceof java.lang.Exception)){
var e_28147 = e28069;
fluree.db.util.log.error.call(null,e_28147,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e28069;

}
}

var G__28148 = cljs.core.next.call(null,seq__28050_28138__$1);
var G__28149 = null;
var G__28150 = (0);
var G__28151 = (0);
seq__28050_28125 = G__28148;
chunk__28051_28126 = G__28149;
count__28052_28127 = G__28150;
i__28053_28128 = G__28151;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28152 = seq__28006;
var G__28153 = chunk__28007;
var G__28154 = count__28008;
var G__28155 = (i__28009 + (1));
seq__28006 = G__28152;
chunk__28007 = G__28153;
count__28008 = G__28154;
i__28009 = G__28155;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__28006);
if(temp__5735__auto____$1){
var seq__28006__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28006__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__28006__$1);
var G__28156 = cljs.core.chunk_rest.call(null,seq__28006__$1);
var G__28157 = c__4556__auto__;
var G__28158 = cljs.core.count.call(null,c__4556__auto__);
var G__28159 = (0);
seq__28006 = G__28156;
chunk__28007 = G__28157;
count__28008 = G__28158;
i__28009 = G__28159;
continue;
} else {
var tid = cljs.core.first.call(null,seq__28006__$1);
var temp__5735__auto___28160__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___28160__$2)){
var keyed_callbacks_28161 = temp__5735__auto___28160__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28162 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28070_28163 = cljs.core.seq.call(null,keyed_callbacks_28161);
var chunk__28071_28164 = null;
var count__28072_28165 = (0);
var i__28073_28166 = (0);
while(true){
if((i__28073_28166 < count__28072_28165)){
var vec__28082_28167 = cljs.core._nth.call(null,chunk__28071_28164,i__28073_28166);
var k_28168 = cljs.core.nth.call(null,vec__28082_28167,(0),null);
var f_28169 = cljs.core.nth.call(null,vec__28082_28167,(1),null);
try{f_28169.call(null,tx_response_28162);
}catch (e28085){if((e28085 instanceof java.lang.Exception)){
var e_28170 = e28085;
fluree.db.util.log.error.call(null,e_28170,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e28085;

}
}

var G__28171 = seq__28070_28163;
var G__28172 = chunk__28071_28164;
var G__28173 = count__28072_28165;
var G__28174 = (i__28073_28166 + (1));
seq__28070_28163 = G__28171;
chunk__28071_28164 = G__28172;
count__28072_28165 = G__28173;
i__28073_28166 = G__28174;
continue;
} else {
var temp__5735__auto___28175__$3 = cljs.core.seq.call(null,seq__28070_28163);
if(temp__5735__auto___28175__$3){
var seq__28070_28176__$1 = temp__5735__auto___28175__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28070_28176__$1)){
var c__4556__auto___28177 = cljs.core.chunk_first.call(null,seq__28070_28176__$1);
var G__28178 = cljs.core.chunk_rest.call(null,seq__28070_28176__$1);
var G__28179 = c__4556__auto___28177;
var G__28180 = cljs.core.count.call(null,c__4556__auto___28177);
var G__28181 = (0);
seq__28070_28163 = G__28178;
chunk__28071_28164 = G__28179;
count__28072_28165 = G__28180;
i__28073_28166 = G__28181;
continue;
} else {
var vec__28086_28182 = cljs.core.first.call(null,seq__28070_28176__$1);
var k_28183 = cljs.core.nth.call(null,vec__28086_28182,(0),null);
var f_28184 = cljs.core.nth.call(null,vec__28086_28182,(1),null);
try{f_28184.call(null,tx_response_28162);
}catch (e28089){if((e28089 instanceof java.lang.Exception)){
var e_28185 = e28089;
fluree.db.util.log.error.call(null,e_28185,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
} else {
throw e28089;

}
}

var G__28186 = cljs.core.next.call(null,seq__28070_28176__$1);
var G__28187 = null;
var G__28188 = (0);
var G__28189 = (0);
seq__28070_28163 = G__28186;
chunk__28071_28164 = G__28187;
count__28072_28165 = G__28188;
i__28073_28166 = G__28189;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28190 = cljs.core.next.call(null,seq__28006__$1);
var G__28191 = null;
var G__28192 = (0);
var G__28193 = (0);
seq__28006 = G__28190;
chunk__28007 = G__28191;
count__28008 = G__28192;
i__28009 = G__28193;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28194 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2476__auto___28195 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_28106){
var state_val_28107 = (state_28106[(1)]);
if((state_val_28107 === (1))){
var state_28106__$1 = state_28106;
var statearr_28108_28196 = state_28106__$1;
(statearr_28108_28196[(2)] = null);

(statearr_28108_28196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28107 === (2))){
var inst_28091 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28106__$1 = state_28106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28106__$1,(4),inst_28091);
} else {
if((state_val_28107 === (3))){
var inst_28104 = (state_28106[(2)]);
var state_28106__$1 = state_28106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28106__$1,inst_28104);
} else {
if((state_val_28107 === (4))){
var inst_28093 = (state_28106[(7)]);
var inst_28093__$1 = (state_28106[(2)]);
var inst_28094 = (inst_28093__$1 == null);
var state_28106__$1 = (function (){var statearr_28109 = state_28106;
(statearr_28109[(7)] = inst_28093__$1);

return statearr_28109;
})();
if(cljs.core.truth_(inst_28094)){
var statearr_28110_28197 = state_28106__$1;
(statearr_28110_28197[(1)] = (5));

} else {
var statearr_28111_28198 = state_28106__$1;
(statearr_28111_28198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28107 === (5))){
var inst_28096 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28097 = fluree.db.util.log.info.call(null,inst_28096);
var state_28106__$1 = state_28106;
var statearr_28112_28199 = state_28106__$1;
(statearr_28112_28199[(2)] = inst_28097);

(statearr_28112_28199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28107 === (6))){
var inst_28093 = (state_28106[(7)]);
var inst_28099 = transact_handler_28194.call(null,conn,inst_28093);
var state_28106__$1 = (function (){var statearr_28113 = state_28106;
(statearr_28113[(8)] = inst_28099);

return statearr_28113;
})();
var statearr_28114_28200 = state_28106__$1;
(statearr_28114_28200[(2)] = null);

(statearr_28114_28200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28107 === (7))){
var inst_28102 = (state_28106[(2)]);
var state_28106__$1 = state_28106;
var statearr_28115_28201 = state_28106__$1;
(statearr_28115_28201[(2)] = inst_28102);

(statearr_28115_28201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2454__auto__ = null;
var fluree$db$session$state_machine__2454__auto____0 = (function (){
var statearr_28116 = [null,null,null,null,null,null,null,null,null];
(statearr_28116[(0)] = fluree$db$session$state_machine__2454__auto__);

(statearr_28116[(1)] = (1));

return statearr_28116;
});
var fluree$db$session$state_machine__2454__auto____1 = (function (state_28106){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28117){var ex__2457__auto__ = e28117;
var statearr_28118_28202 = state_28106;
(statearr_28118_28202[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28106[(4)]))){
var statearr_28119_28203 = state_28106;
(statearr_28119_28203[(1)] = cljs.core.first.call(null,(state_28106[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28204 = state_28106;
state_28106 = G__28204;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$session$state_machine__2454__auto__ = function(state_28106){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2454__auto____1.call(this,state_28106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2454__auto____0;
fluree$db$session$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2454__auto____1;
return fluree$db$session$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_28120 = f__2477__auto__.call(null);
(statearr_28120[(6)] = c__2476__auto___28195);

return statearr_28120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28205_SHARP_){
return cljs.core.assoc.call(null,p1__28205_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28205_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28206_SHARP_){
return cljs.core.assoc.call(null,p1__28206_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28209 = arguments.length;
switch (G__28209) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28210 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__28207_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__28207_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28210);
} else {
return G__28210;
}
})();
var seq__28211 = cljs.core.seq.call(null,sessions);
var chunk__28212 = null;
var count__28213 = (0);
var i__28214 = (0);
while(true){
if((i__28214 < count__28213)){
var session = cljs.core._nth.call(null,chunk__28212,i__28214);
fluree.db.session.close.call(null,session);


var G__28216 = seq__28211;
var G__28217 = chunk__28212;
var G__28218 = count__28213;
var G__28219 = (i__28214 + (1));
seq__28211 = G__28216;
chunk__28212 = G__28217;
count__28213 = G__28218;
i__28214 = G__28219;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__28211);
if(temp__5735__auto__){
var seq__28211__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28211__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__28211__$1);
var G__28220 = cljs.core.chunk_rest.call(null,seq__28211__$1);
var G__28221 = c__4556__auto__;
var G__28222 = cljs.core.count.call(null,c__4556__auto__);
var G__28223 = (0);
seq__28211 = G__28220;
chunk__28212 = G__28221;
count__28213 = G__28222;
i__28214 = G__28223;
continue;
} else {
var session = cljs.core.first.call(null,seq__28211__$1);
fluree.db.session.close.call(null,session);


var G__28224 = cljs.core.next.call(null,seq__28211__$1);
var G__28225 = null;
var G__28226 = (0);
var G__28227 = (0);
seq__28211 = G__28224;
chunk__28212 = G__28225;
count__28213 = G__28226;
i__28214 = G__28227;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
