// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13170 = match;
var p1 = cljs.core.nth.call(null,vec__13170,(0),null);
var p2 = cljs.core.nth.call(null,vec__13170,(1),null);
var p3 = cljs.core.nth.call(null,vec__13170,(2),null);
var t = cljs.core.nth.call(null,vec__13170,(3),null);
var op = cljs.core.nth.call(null,vec__13170,(4),null);
var m = cljs.core.nth.call(null,vec__13170,(5),null);
var G__13173 = idx;
var G__13173__$1 = (((G__13173 instanceof cljs.core.Keyword))?G__13173.fqn:null);
switch (G__13173__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13173__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13175 = idx;
var G__13175__$1 = (((G__13175 instanceof cljs.core.Keyword))?G__13175.fqn:null);
switch (G__13175__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13175__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13177 = idx;
var G__13177__$1 = (((G__13177 instanceof cljs.core.Keyword))?G__13177.fqn:null);
switch (G__13177__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13177__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13180 = arguments.length;
switch (G__13180) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13181 = (function (){var pred__13184 = cljs.core.identical_QMARK_;
var expr__13185 = test;
if(cljs.core.truth_(pred__13184.call(null,cljs.core._EQ_,expr__13185))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13184.call(null,cljs.core._LT_,expr__13185))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13184.call(null,cljs.core._LT__EQ_,expr__13185))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13184.call(null,cljs.core._GT_,expr__13185))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13184.call(null,cljs.core._GT__EQ_,expr__13185))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13185)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13181,(0),null);
var start_match = cljs.core.nth.call(null,vec__13181,(1),null);
var end_test = cljs.core.nth.call(null,vec__13181,(2),null);
var end_match = cljs.core.nth.call(null,vec__13181,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_13398){
var state_val_13399 = (state_13398[(1)]);
if((state_val_13399 === (65))){
var inst_13351 = (state_13398[(7)]);
var inst_13319 = (state_13398[(8)]);
var inst_13363 = cljs.core.into.call(null,inst_13351,inst_13319);
var state_13398__$1 = state_13398;
var statearr_13400_13516 = state_13398__$1;
(statearr_13400_13516[(2)] = inst_13363);

(statearr_13400_13516[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (70))){
var inst_13381 = (state_13398[(2)]);
var inst_13382 = cljs.core.not.call(null,inst_13381);
var state_13398__$1 = state_13398;
if(inst_13382){
var statearr_13401_13517 = state_13398__$1;
(statearr_13401_13517[(1)] = (71));

} else {
var statearr_13402_13518 = state_13398__$1;
(statearr_13402_13518[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (62))){
var inst_13333 = (state_13398[(9)]);
var inst_13372 = (state_13398[(10)]);
var inst_13372__$1 = (state_13398[(2)]);
var inst_13373 = cljs.core.count.call(null,inst_13372__$1);
var state_13398__$1 = (function (){var statearr_13403 = state_13398;
(statearr_13403[(10)] = inst_13372__$1);

(statearr_13403[(11)] = inst_13373);

return statearr_13403;
})();
if(cljs.core.truth_(inst_13333)){
var statearr_13404_13519 = state_13398__$1;
(statearr_13404_13519[(1)] = (68));

} else {
var statearr_13405_13520 = state_13398__$1;
(statearr_13405_13520[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (74))){
var inst_13372 = (state_13398[(10)]);
var inst_13373 = (state_13398[(11)]);
var inst_13387 = (state_13398[(2)]);
var inst_13388 = fluree.db.util.async.throw_err.call(null,inst_13387);
var inst_13317 = inst_13388;
var inst_13318 = inst_13373;
var inst_13319 = inst_13372;
var state_13398__$1 = (function (){var statearr_13406 = state_13398;
(statearr_13406[(12)] = inst_13318);

(statearr_13406[(13)] = inst_13317);

(statearr_13406[(8)] = inst_13319);

return statearr_13406;
})();
var statearr_13407_13521 = state_13398__$1;
(statearr_13407_13521[(2)] = null);

(statearr_13407_13521[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (7))){
var inst_13200 = (state_13398[(14)]);
var state_13398__$1 = state_13398;
var statearr_13408_13522 = state_13398__$1;
(statearr_13408_13522[(2)] = inst_13200);

(statearr_13408_13522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (59))){
var inst_13317 = (state_13398[(13)]);
var inst_13332 = (state_13398[(2)]);
var inst_13333 = fluree.db.dbproto._rhs.call(null,inst_13317);
var state_13398__$1 = (function (){var statearr_13409 = state_13398;
(statearr_13409[(9)] = inst_13333);

(statearr_13409[(15)] = inst_13332);

return statearr_13409;
})();
var statearr_13410_13523 = state_13398__$1;
(statearr_13410_13523[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (20))){
var inst_13201 = (state_13398[(16)]);
var inst_13248 = (state_13398[(2)]);
var inst_13249 = (inst_13201 == null);
var state_13398__$1 = (function (){var statearr_13412 = state_13398;
(statearr_13412[(17)] = inst_13248);

return statearr_13412;
})();
if(cljs.core.truth_(inst_13249)){
var statearr_13413_13524 = state_13398__$1;
(statearr_13413_13524[(1)] = (22));

} else {
var statearr_13414_13525 = state_13398__$1;
(statearr_13414_13525[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (72))){
var inst_13312 = (state_13398[(18)]);
var inst_13333 = (state_13398[(9)]);
var inst_13385 = fluree.db.dbproto._lookup_leaf.call(null,inst_13312,inst_13333);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(74),inst_13385);
} else {
if((state_val_13399 === (58))){
var inst_13325 = (state_13398[(19)]);
var state_13398__$1 = state_13398;
var statearr_13415_13526 = state_13398__$1;
(statearr_13415_13526[(2)] = inst_13325);

(statearr_13415_13526[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (60))){
var inst_13318 = (state_13398[(12)]);
var inst_13291 = (state_13398[(20)]);
var inst_13332 = (state_13398[(15)]);
var inst_13319 = (state_13398[(8)]);
var inst_13335 = (inst_13291 - inst_13318);
var inst_13336 = fluree.db.flake.take.call(null,inst_13335,inst_13332);
var inst_13337 = cljs.core.into.call(null,inst_13336,inst_13319);
var state_13398__$1 = state_13398;
var statearr_13416_13527 = state_13398__$1;
(statearr_13416_13527[(2)] = inst_13337);

(statearr_13416_13527[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (27))){
var inst_13208 = (state_13398[(21)]);
var inst_13257 = (state_13398[(2)]);
var inst_13258 = (inst_13208 == null);
var state_13398__$1 = (function (){var statearr_13417 = state_13398;
(statearr_13417[(22)] = inst_13257);

return statearr_13417;
})();
if(cljs.core.truth_(inst_13258)){
var statearr_13418_13528 = state_13398__$1;
(statearr_13418_13528[(1)] = (28));

} else {
var statearr_13419_13529 = state_13398__$1;
(statearr_13419_13529[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (1))){
var state_13398__$1 = state_13398;
var statearr_13420_13530 = state_13398__$1;
(statearr_13420_13530[(2)] = null);

(statearr_13420_13530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (69))){
var inst_13333 = (state_13398[(9)]);
var state_13398__$1 = state_13398;
var statearr_13421_13531 = state_13398__$1;
(statearr_13421_13531[(2)] = inst_13333);

(statearr_13421_13531[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (24))){
var inst_13253 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
if(cljs.core.truth_(inst_13253)){
var statearr_13422_13532 = state_13398__$1;
(statearr_13422_13532[(1)] = (25));

} else {
var statearr_13423_13533 = state_13398__$1;
(statearr_13423_13533[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (55))){
var inst_13393 = (state_13398[(2)]);
var _ = (function (){var statearr_13424 = state_13398;
(statearr_13424[(4)] = cljs.core.rest.call(null,(state_13398[(4)])));

return statearr_13424;
})();
var state_13398__$1 = state_13398;
var statearr_13425_13534 = state_13398__$1;
(statearr_13425_13534[(2)] = inst_13393);

(statearr_13425_13534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (39))){
var inst_13273 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13426_13535 = state_13398__$1;
(statearr_13426_13535[(2)] = inst_13273);

(statearr_13426_13535[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (46))){
var inst_13287 = (state_13398[(23)]);
var state_13398__$1 = state_13398;
var statearr_13427_13536 = state_13398__$1;
(statearr_13427_13536[(2)] = inst_13287);

(statearr_13427_13536[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (4))){
var inst_13187 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13428_13537 = state_13398__$1;
(statearr_13428_13537[(2)] = inst_13187);

(statearr_13428_13537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (54))){
var inst_13317 = (state_13398[(13)]);
var inst_13302 = (state_13398[(24)]);
var inst_13307 = (state_13398[(25)]);
var inst_13303 = (state_13398[(26)]);
var inst_13321 = fluree.db.dbproto._resolve_history_range.call(null,inst_13317,inst_13302,inst_13303,inst_13307);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(56),inst_13321);
} else {
if((state_val_13399 === (15))){
var inst_13202 = (state_13398[(27)]);
var state_13398__$1 = state_13398;
var statearr_13429_13538 = state_13398__$1;
(statearr_13429_13538[(2)] = inst_13202);

(statearr_13429_13538[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (48))){
var inst_13297 = (state_13398[(28)]);
var inst_13291 = (state_13398[(2)]);
var inst_13292 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13294 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13295 = (new cljs.core.PersistentVector(null,3,(5),inst_13293,inst_13294,null));
var inst_13296 = cljs.core.get_in.call(null,db,inst_13295);
var inst_13297__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13398__$1 = (function (){var statearr_13430 = state_13398;
(statearr_13430[(20)] = inst_13291);

(statearr_13430[(29)] = inst_13296);

(statearr_13430[(28)] = inst_13297__$1);

(statearr_13430[(30)] = inst_13292);

return statearr_13430;
})();
if(cljs.core.truth_(inst_13297__$1)){
var statearr_13431_13539 = state_13398__$1;
(statearr_13431_13539[(1)] = (49));

} else {
var statearr_13432_13540 = state_13398__$1;
(statearr_13432_13540[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (50))){
var inst_13300 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13398__$1 = state_13398;
var statearr_13433_13541 = state_13398__$1;
(statearr_13433_13541[(2)] = inst_13300);

(statearr_13433_13541[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (21))){
var inst_13244 = (state_13398[(2)]);
var inst_13245 = fluree.db.util.async.throw_err.call(null,inst_13244);
var state_13398__$1 = state_13398;
var statearr_13434_13542 = state_13398__$1;
(statearr_13434_13542[(2)] = inst_13245);

(statearr_13434_13542[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (31))){
var state_13398__$1 = state_13398;
var statearr_13435_13543 = state_13398__$1;
(statearr_13435_13543[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13435_13543[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (32))){
var inst_13208 = (state_13398[(21)]);
var state_13398__$1 = state_13398;
var statearr_13436_13544 = state_13398__$1;
(statearr_13436_13544[(2)] = inst_13208);

(statearr_13436_13544[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (40))){
var inst_13212 = (state_13398[(31)]);
var state_13398__$1 = state_13398;
var statearr_13437_13545 = state_13398__$1;
(statearr_13437_13545[(2)] = inst_13212);

(statearr_13437_13545[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (56))){
var inst_13286 = (state_13398[(32)]);
var inst_13285 = (state_13398[(33)]);
var inst_13324 = (state_13398[(34)]);
var inst_13323 = (state_13398[(2)]);
var inst_13324__$1 = fluree.db.util.async.throw_err.call(null,inst_13323);
var inst_13325 = fluree.db.flake.subrange.call(null,inst_13324__$1,start_test,inst_13285,end_test,inst_13286);
var inst_13326 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13285,inst_13286);
var state_13398__$1 = (function (){var statearr_13438 = state_13398;
(statearr_13438[(19)] = inst_13325);

(statearr_13438[(34)] = inst_13324__$1);

return statearr_13438;
})();
if(inst_13326){
var statearr_13439_13546 = state_13398__$1;
(statearr_13439_13546[(1)] = (57));

} else {
var statearr_13440_13547 = state_13398__$1;
(statearr_13440_13547[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (33))){
var inst_13205 = (state_13398[(35)]);
var inst_13266 = (state_13398[(2)]);
var state_13398__$1 = (function (){var statearr_13441 = state_13398;
(statearr_13441[(36)] = inst_13266);

return statearr_13441;
})();
if(cljs.core.truth_(inst_13205)){
var statearr_13442_13548 = state_13398__$1;
(statearr_13442_13548[(1)] = (34));

} else {
var statearr_13443_13549 = state_13398__$1;
(statearr_13443_13549[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (13))){
var inst_13226 = (state_13398[(2)]);
var inst_13227 = fluree.db.util.async.throw_err.call(null,inst_13226);
var state_13398__$1 = state_13398;
var statearr_13444_13550 = state_13398__$1;
(statearr_13444_13550[(2)] = inst_13227);

(statearr_13444_13550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (22))){
var inst_13239 = (state_13398[(37)]);
var state_13398__$1 = state_13398;
var statearr_13445_13551 = state_13398__$1;
(statearr_13445_13551[(2)] = inst_13239);

(statearr_13445_13551[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (36))){
var inst_13212 = (state_13398[(31)]);
var inst_13275 = (state_13398[(2)]);
var state_13398__$1 = (function (){var statearr_13446 = state_13398;
(statearr_13446[(38)] = inst_13275);

return statearr_13446;
})();
if(cljs.core.truth_(inst_13212)){
var statearr_13447_13552 = state_13398__$1;
(statearr_13447_13552[(1)] = (40));

} else {
var statearr_13448_13553 = state_13398__$1;
(statearr_13448_13553[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (41))){
var inst_13278 = (cljs.core._LT__EQ_ === end_test);
var state_13398__$1 = state_13398;
if(cljs.core.truth_(inst_13278)){
var statearr_13449_13554 = state_13398__$1;
(statearr_13449_13554[(1)] = (43));

} else {
var statearr_13450_13555 = state_13398__$1;
(statearr_13450_13555[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (43))){
var state_13398__$1 = state_13398;
var statearr_13451_13556 = state_13398__$1;
(statearr_13451_13556[(2)] = (2147483647));

(statearr_13451_13556[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (61))){
var inst_13318 = (state_13398[(12)]);
var inst_13332 = (state_13398[(15)]);
var inst_13346 = cljs.core.seq.call(null,inst_13332);
var inst_13347 = cljs.core.first.call(null,inst_13346);
var inst_13348 = cljs.core.next.call(null,inst_13346);
var inst_13349 = inst_13332;
var inst_13350 = inst_13318;
var inst_13351 = inst_13332;
var state_13398__$1 = (function (){var statearr_13452 = state_13398;
(statearr_13452[(39)] = inst_13348);

(statearr_13452[(40)] = inst_13349);

(statearr_13452[(7)] = inst_13351);

(statearr_13452[(41)] = inst_13350);

(statearr_13452[(42)] = inst_13347);

return statearr_13452;
})();
var statearr_13453_13557 = state_13398__$1;
(statearr_13453_13557[(2)] = null);

(statearr_13453_13557[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (29))){
var state_13398__$1 = state_13398;
var statearr_13454_13558 = state_13398__$1;
(statearr_13454_13558[(2)] = false);

(statearr_13454_13558[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (44))){
var state_13398__$1 = state_13398;
var statearr_13455_13559 = state_13398__$1;
(statearr_13455_13559[(2)] = fluree.db.util.core.min_integer);

(statearr_13455_13559[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (6))){
var inst_13200 = (state_13398[(14)]);
var inst_13215 = fluree.db.dbproto._subid.call(null,db,inst_13200);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(9),inst_13215);
} else {
if((state_val_13399 === (28))){
var inst_13248 = (state_13398[(17)]);
var state_13398__$1 = state_13398;
var statearr_13456_13560 = state_13398__$1;
(statearr_13456_13560[(2)] = inst_13248);

(statearr_13456_13560[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (64))){
var inst_13370 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13457_13561 = state_13398__$1;
(statearr_13457_13561[(2)] = inst_13370);

(statearr_13457_13561[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (51))){
var inst_13302 = (state_13398[(2)]);
var inst_13303 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13305 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13306 = (new cljs.core.PersistentVector(null,2,(5),inst_13304,inst_13305,null));
var inst_13307 = cljs.core.get_in.call(null,db,inst_13306);
var inst_13308 = cljs.core.get.call(null,db,idx);
var inst_13309 = fluree.db.dbproto._resolve.call(null,inst_13308);
var state_13398__$1 = (function (){var statearr_13458 = state_13398;
(statearr_13458[(24)] = inst_13302);

(statearr_13458[(25)] = inst_13307);

(statearr_13458[(26)] = inst_13303);

return statearr_13458;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(52),inst_13309);
} else {
if((state_val_13399 === (25))){
var state_13398__$1 = state_13398;
var statearr_13459_13562 = state_13398__$1;
(statearr_13459_13562[(2)] = (-1));

(statearr_13459_13562[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (34))){
var inst_13205 = (state_13398[(35)]);
var state_13398__$1 = state_13398;
var statearr_13460_13563 = state_13398__$1;
(statearr_13460_13563[(2)] = inst_13205);

(statearr_13460_13563[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (17))){
var inst_13235 = (state_13398[(2)]);
var inst_13236 = fluree.db.util.async.throw_err.call(null,inst_13235);
var state_13398__$1 = state_13398;
var statearr_13461_13564 = state_13398__$1;
(statearr_13461_13564[(2)] = inst_13236);

(statearr_13461_13564[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (3))){
var inst_13396 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13398__$1,inst_13396);
} else {
if((state_val_13399 === (12))){
var inst_13202 = (state_13398[(27)]);
var inst_13230 = (state_13398[(2)]);
var inst_13231 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13202);
var state_13398__$1 = (function (){var statearr_13463 = state_13398;
(statearr_13463[(43)] = inst_13230);

return statearr_13463;
})();
if(inst_13231){
var statearr_13464_13565 = state_13398__$1;
(statearr_13464_13565[(1)] = (14));

} else {
var statearr_13465_13566 = state_13398__$1;
(statearr_13465_13566[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (2))){
var inst_13206 = (state_13398[(44)]);
var inst_13199 = (state_13398[(45)]);
var inst_13200 = (state_13398[(14)]);
var _ = (function (){var statearr_13466 = state_13398;
(statearr_13466[(4)] = cljs.core.cons.call(null,(5),(state_13398[(4)])));

return statearr_13466;
})();
var inst_13199__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13200__$1 = cljs.core.nth.call(null,inst_13199__$1,(0),null);
var inst_13201 = cljs.core.nth.call(null,inst_13199__$1,(1),null);
var inst_13202 = cljs.core.nth.call(null,inst_13199__$1,(2),null);
var inst_13203 = cljs.core.nth.call(null,inst_13199__$1,(3),null);
var inst_13204 = cljs.core.nth.call(null,inst_13199__$1,(4),null);
var inst_13205 = cljs.core.nth.call(null,inst_13199__$1,(5),null);
var inst_13206__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13207 = cljs.core.nth.call(null,inst_13206__$1,(0),null);
var inst_13208 = cljs.core.nth.call(null,inst_13206__$1,(1),null);
var inst_13209 = cljs.core.nth.call(null,inst_13206__$1,(2),null);
var inst_13210 = cljs.core.nth.call(null,inst_13206__$1,(3),null);
var inst_13211 = cljs.core.nth.call(null,inst_13206__$1,(4),null);
var inst_13212 = cljs.core.nth.call(null,inst_13206__$1,(5),null);
var inst_13213 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13200__$1);
var state_13398__$1 = (function (){var statearr_13467 = state_13398;
(statearr_13467[(46)] = inst_13204);

(statearr_13467[(31)] = inst_13212);

(statearr_13467[(21)] = inst_13208);

(statearr_13467[(27)] = inst_13202);

(statearr_13467[(47)] = inst_13210);

(statearr_13467[(44)] = inst_13206__$1);

(statearr_13467[(48)] = inst_13209);

(statearr_13467[(49)] = inst_13203);

(statearr_13467[(35)] = inst_13205);

(statearr_13467[(16)] = inst_13201);

(statearr_13467[(45)] = inst_13199__$1);

(statearr_13467[(50)] = inst_13207);

(statearr_13467[(51)] = inst_13211);

(statearr_13467[(14)] = inst_13200__$1);

return statearr_13467;
})();
if(inst_13213){
var statearr_13468_13567 = state_13398__$1;
(statearr_13468_13567[(1)] = (6));

} else {
var statearr_13469_13568 = state_13398__$1;
(statearr_13469_13568[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (66))){
var inst_13351 = (state_13398[(7)]);
var inst_13350 = (state_13398[(41)]);
var inst_13358 = (state_13398[(52)]);
var inst_13365 = (inst_13350 + (1));
var tmp13462 = inst_13351;
var inst_13349 = inst_13358;
var inst_13350__$1 = inst_13365;
var inst_13351__$1 = tmp13462;
var state_13398__$1 = (function (){var statearr_13470 = state_13398;
(statearr_13470[(40)] = inst_13349);

(statearr_13470[(7)] = inst_13351__$1);

(statearr_13470[(41)] = inst_13350__$1);

return statearr_13470;
})();
var statearr_13471_13569 = state_13398__$1;
(statearr_13471_13569[(2)] = null);

(statearr_13471_13569[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (23))){
var state_13398__$1 = state_13398;
var statearr_13472_13570 = state_13398__$1;
(statearr_13472_13570[(2)] = false);

(statearr_13472_13570[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (47))){
var state_13398__$1 = state_13398;
var statearr_13473_13571 = state_13398__$1;
(statearr_13473_13571[(2)] = fluree.db.util.core.max_long);

(statearr_13473_13571[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (35))){
var inst_13269 = (cljs.core._GT__EQ_ === start_test);
var state_13398__$1 = state_13398;
if(cljs.core.truth_(inst_13269)){
var statearr_13474_13572 = state_13398__$1;
(statearr_13474_13572[(1)] = (37));

} else {
var statearr_13475_13573 = state_13398__$1;
(statearr_13475_13573[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (19))){
var inst_13209 = (state_13398[(48)]);
var state_13398__$1 = state_13398;
var statearr_13476_13574 = state_13398__$1;
(statearr_13476_13574[(2)] = inst_13209);

(statearr_13476_13574[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (57))){
var inst_13312 = (state_13398[(18)]);
var inst_13257 = (state_13398[(22)]);
var inst_13318 = (state_13398[(12)]);
var inst_13239 = (state_13398[(37)]);
var inst_13204 = (state_13398[(46)]);
var inst_13291 = (state_13398[(20)]);
var inst_13275 = (state_13398[(38)]);
var inst_13286 = (state_13398[(32)]);
var inst_13221 = (state_13398[(53)]);
var inst_13210 = (state_13398[(47)]);
var inst_13325 = (state_13398[(19)]);
var inst_13266 = (state_13398[(36)]);
var inst_13206 = (state_13398[(44)]);
var inst_13296 = (state_13398[(29)]);
var inst_13317 = (state_13398[(13)]);
var inst_13284 = (state_13398[(54)]);
var inst_13248 = (state_13398[(17)]);
var inst_13302 = (state_13398[(24)]);
var inst_13319 = (state_13398[(8)]);
var inst_13285 = (state_13398[(33)]);
var inst_13307 = (state_13398[(25)]);
var inst_13203 = (state_13398[(49)]);
var inst_13199 = (state_13398[(45)]);
var inst_13211 = (state_13398[(51)]);
var inst_13303 = (state_13398[(26)]);
var inst_13324 = (state_13398[(34)]);
var inst_13230 = (state_13398[(43)]);
var inst_13292 = (state_13398[(30)]);
var inst_13328 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13317;
var flakes = inst_13324;
var s1 = inst_13221;
var o2 = inst_13248;
var t1 = inst_13203;
var i = inst_13318;
var m1 = inst_13275;
var root_node = inst_13312;
var to_t = inst_13303;
var s2 = inst_13230;
var vec__13196 = inst_13206;
var p2 = inst_13266;
var permissions = inst_13292;
var limit = inst_13291;
var start_flake = inst_13285;
var acc = inst_13319;
var t2 = inst_13210;
var op1 = inst_13204;
var o1 = inst_13239;
var end_flake = inst_13286;
var base_result = inst_13325;
var p1 = inst_13257;
var idx_compare = inst_13296;
var op2 = inst_13211;
var from_t = inst_13302;
var m2 = inst_13284;
var vec__13193 = inst_13199;
var novelty = inst_13307;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_13329 = cljs.core.reduce.call(null,inst_13328,inst_13325,inst_13325);
var state_13398__$1 = state_13398;
var statearr_13477_13575 = state_13398__$1;
(statearr_13477_13575[(2)] = inst_13329);

(statearr_13477_13575[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (68))){
var inst_13291 = (state_13398[(20)]);
var inst_13286 = (state_13398[(32)]);
var inst_13333 = (state_13398[(9)]);
var inst_13296 = (state_13398[(29)]);
var inst_13373 = (state_13398[(11)]);
var inst_13375 = inst_13296.call(null,inst_13333,inst_13286);
var inst_13376 = (inst_13375 < (0));
var inst_13377 = (inst_13373 < inst_13291);
var inst_13378 = ((inst_13376) && (inst_13377));
var state_13398__$1 = state_13398;
var statearr_13478_13576 = state_13398__$1;
(statearr_13478_13576[(2)] = inst_13378);

(statearr_13478_13576[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (11))){
var inst_13207 = (state_13398[(50)]);
var state_13398__$1 = state_13398;
var statearr_13480_13577 = state_13398__$1;
(statearr_13480_13577[(2)] = inst_13207);

(statearr_13480_13577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (9))){
var inst_13217 = (state_13398[(2)]);
var inst_13218 = fluree.db.util.async.throw_err.call(null,inst_13217);
var state_13398__$1 = state_13398;
var statearr_13481_13578 = state_13398__$1;
(statearr_13481_13578[(2)] = inst_13218);

(statearr_13481_13578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (5))){
var _ = (function (){var statearr_13482 = state_13398;
(statearr_13482[(4)] = cljs.core.rest.call(null,(state_13398[(4)])));

return statearr_13482;
})();
var state_13398__$1 = state_13398;
var ex13479 = (state_13398__$1[(2)]);
var statearr_13483_13579 = state_13398__$1;
(statearr_13483_13579[(5)] = ex13479);


if((ex13479 instanceof Error)){
var statearr_13484_13580 = state_13398__$1;
(statearr_13484_13580[(1)] = (4));

(statearr_13484_13580[(5)] = null);

} else {
throw ex13479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (14))){
var inst_13202 = (state_13398[(27)]);
var inst_13233 = fluree.db.dbproto._subid.call(null,db,inst_13202);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(17),inst_13233);
} else {
if((state_val_13399 === (45))){
var inst_13282 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13485_13581 = state_13398__$1;
(statearr_13485_13581[(2)] = inst_13282);

(statearr_13485_13581[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (53))){
var inst_13315 = (state_13398[(2)]);
var inst_13316 = fluree.db.util.async.throw_err.call(null,inst_13315);
var inst_13317 = inst_13316;
var inst_13318 = (0);
var inst_13319 = null;
var state_13398__$1 = (function (){var statearr_13486 = state_13398;
(statearr_13486[(12)] = inst_13318);

(statearr_13486[(13)] = inst_13317);

(statearr_13486[(8)] = inst_13319);

return statearr_13486;
})();
var statearr_13487_13582 = state_13398__$1;
(statearr_13487_13582[(2)] = null);

(statearr_13487_13582[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (26))){
var inst_13201 = (state_13398[(16)]);
var state_13398__$1 = state_13398;
var statearr_13488_13583 = state_13398__$1;
(statearr_13488_13583[(2)] = inst_13201);

(statearr_13488_13583[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (16))){
var inst_13209 = (state_13398[(48)]);
var inst_13239 = (state_13398[(2)]);
var inst_13240 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13209);
var state_13398__$1 = (function (){var statearr_13489 = state_13398;
(statearr_13489[(37)] = inst_13239);

return statearr_13489;
})();
if(inst_13240){
var statearr_13490_13584 = state_13398__$1;
(statearr_13490_13584[(1)] = (18));

} else {
var statearr_13491_13585 = state_13398__$1;
(statearr_13491_13585[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (38))){
var state_13398__$1 = state_13398;
var statearr_13492_13586 = state_13398__$1;
(statearr_13492_13586[(2)] = (2147483647));

(statearr_13492_13586[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (30))){
var inst_13262 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
if(cljs.core.truth_(inst_13262)){
var statearr_13493_13587 = state_13398__$1;
(statearr_13493_13587[(1)] = (31));

} else {
var statearr_13494_13588 = state_13398__$1;
(statearr_13494_13588[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (73))){
var inst_13391 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13495_13589 = state_13398__$1;
(statearr_13495_13589[(2)] = inst_13391);

(statearr_13495_13589[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (10))){
var inst_13207 = (state_13398[(50)]);
var inst_13224 = fluree.db.dbproto._subid.call(null,db,inst_13207);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(13),inst_13224);
} else {
if((state_val_13399 === (18))){
var inst_13209 = (state_13398[(48)]);
var inst_13242 = fluree.db.dbproto._subid.call(null,db,inst_13209);
var state_13398__$1 = state_13398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(21),inst_13242);
} else {
if((state_val_13399 === (52))){
var inst_13312 = (state_13398[(18)]);
var inst_13285 = (state_13398[(33)]);
var inst_13311 = (state_13398[(2)]);
var inst_13312__$1 = fluree.db.util.async.throw_err.call(null,inst_13311);
var inst_13313 = fluree.db.dbproto._lookup_leaf.call(null,inst_13312__$1,inst_13285);
var state_13398__$1 = (function (){var statearr_13496 = state_13398;
(statearr_13496[(18)] = inst_13312__$1);

return statearr_13496;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13398__$1,(53),inst_13313);
} else {
if((state_val_13399 === (67))){
var inst_13368 = (state_13398[(2)]);
var state_13398__$1 = state_13398;
var statearr_13497_13590 = state_13398__$1;
(statearr_13497_13590[(2)] = inst_13368);

(statearr_13497_13590[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (71))){
var inst_13372 = (state_13398[(10)]);
var state_13398__$1 = state_13398;
var statearr_13498_13591 = state_13398__$1;
(statearr_13498_13591[(2)] = inst_13372);

(statearr_13498_13591[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (42))){
var inst_13257 = (state_13398[(22)]);
var inst_13239 = (state_13398[(37)]);
var inst_13204 = (state_13398[(46)]);
var inst_13275 = (state_13398[(38)]);
var inst_13221 = (state_13398[(53)]);
var inst_13210 = (state_13398[(47)]);
var inst_13266 = (state_13398[(36)]);
var inst_13284 = (state_13398[(54)]);
var inst_13287 = (state_13398[(23)]);
var inst_13248 = (state_13398[(17)]);
var inst_13203 = (state_13398[(49)]);
var inst_13211 = (state_13398[(51)]);
var inst_13230 = (state_13398[(43)]);
var inst_13284__$1 = (state_13398[(2)]);
var inst_13285 = fluree.db.flake.__GT_Flake.call(null,inst_13221,inst_13257,inst_13239,inst_13203,inst_13204,inst_13275);
var inst_13286 = fluree.db.flake.__GT_Flake.call(null,inst_13230,inst_13266,inst_13248,inst_13210,inst_13211,inst_13284__$1);
var inst_13287__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13398__$1 = (function (){var statearr_13499 = state_13398;
(statearr_13499[(32)] = inst_13286);

(statearr_13499[(54)] = inst_13284__$1);

(statearr_13499[(23)] = inst_13287__$1);

(statearr_13499[(33)] = inst_13285);

return statearr_13499;
})();
if(cljs.core.truth_(inst_13287__$1)){
var statearr_13500_13592 = state_13398__$1;
(statearr_13500_13592[(1)] = (46));

} else {
var statearr_13501_13593 = state_13398__$1;
(statearr_13501_13593[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (37))){
var state_13398__$1 = state_13398;
var statearr_13502_13594 = state_13398__$1;
(statearr_13502_13594[(2)] = fluree.db.util.core.min_integer);

(statearr_13502_13594[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (63))){
var inst_13349 = (state_13398[(40)]);
var inst_13291 = (state_13398[(20)]);
var inst_13350 = (state_13398[(41)]);
var inst_13356 = cljs.core.seq.call(null,inst_13349);
var inst_13357 = cljs.core.first.call(null,inst_13356);
var inst_13358 = cljs.core.next.call(null,inst_13356);
var inst_13359 = (inst_13357 == null);
var inst_13360 = (inst_13350 > inst_13291);
var inst_13361 = ((inst_13359) || (inst_13360));
var state_13398__$1 = (function (){var statearr_13503 = state_13398;
(statearr_13503[(52)] = inst_13358);

return statearr_13503;
})();
if(cljs.core.truth_(inst_13361)){
var statearr_13504_13595 = state_13398__$1;
(statearr_13504_13595[(1)] = (65));

} else {
var statearr_13505_13596 = state_13398__$1;
(statearr_13505_13596[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (8))){
var inst_13207 = (state_13398[(50)]);
var inst_13221 = (state_13398[(2)]);
var inst_13222 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13207);
var state_13398__$1 = (function (){var statearr_13506 = state_13398;
(statearr_13506[(53)] = inst_13221);

return statearr_13506;
})();
if(inst_13222){
var statearr_13507_13597 = state_13398__$1;
(statearr_13507_13597[(1)] = (10));

} else {
var statearr_13508_13598 = state_13398__$1;
(statearr_13508_13598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13399 === (49))){
var inst_13297 = (state_13398[(28)]);
var state_13398__$1 = state_13398;
var statearr_13509_13599 = state_13398__$1;
(statearr_13509_13599[(2)] = inst_13297);

(statearr_13509_13599[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2454__auto__ = null;
var fluree$db$query$range$state_machine__2454__auto____0 = (function (){
var statearr_13510 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13510[(0)] = fluree$db$query$range$state_machine__2454__auto__);

(statearr_13510[(1)] = (1));

return statearr_13510;
});
var fluree$db$query$range$state_machine__2454__auto____1 = (function (state_13398){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_13398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e13511){var ex__2457__auto__ = e13511;
var statearr_13512_13600 = state_13398;
(statearr_13512_13600[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_13398[(4)]))){
var statearr_13513_13601 = state_13398;
(statearr_13513_13601[(1)] = cljs.core.first.call(null,(state_13398[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13602 = state_13398;
state_13398 = G__13602;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2454__auto__ = function(state_13398){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2454__auto____1.call(this,state_13398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2454__auto____0;
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2454__auto____1;
return fluree$db$query$range$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_13514 = f__2477__auto__.call(null);
(statearr_13514[(6)] = c__2476__auto__);

return statearr_13514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_13652){
var state_val_13653 = (state_13652[(1)]);
if((state_val_13653 === (7))){
var state_13652__$1 = state_13652;
var statearr_13654_13673 = state_13652__$1;
(statearr_13654_13673[(2)] = (0));

(statearr_13654_13673[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (1))){
var inst_13610 = subject_groups;
var inst_13611 = cljs.core.seq.call(null,inst_13610);
var inst_13612 = cljs.core.first.call(null,inst_13611);
var inst_13613 = cljs.core.next.call(null,inst_13611);
var inst_13614 = flake_start;
var inst_13615 = subject_start;
var inst_13616 = cljs.core.PersistentVector.EMPTY;
var inst_13617 = inst_13610;
var inst_13618 = inst_13614;
var inst_13619 = inst_13615;
var inst_13620 = inst_13616;
var state_13652__$1 = (function (){var statearr_13655 = state_13652;
(statearr_13655[(7)] = inst_13617);

(statearr_13655[(8)] = inst_13619);

(statearr_13655[(9)] = inst_13620);

(statearr_13655[(10)] = inst_13618);

(statearr_13655[(11)] = inst_13612);

(statearr_13655[(12)] = inst_13613);

return statearr_13655;
})();
var statearr_13656_13674 = state_13652__$1;
(statearr_13656_13674[(2)] = null);

(statearr_13656_13674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (4))){
var inst_13619 = (state_13652[(8)]);
var inst_13620 = (state_13652[(9)]);
var inst_13618 = (state_13652[(10)]);
var inst_13633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13634 = [inst_13618,inst_13619,inst_13620];
var inst_13635 = (new cljs.core.PersistentVector(null,3,(5),inst_13633,inst_13634,null));
var state_13652__$1 = state_13652;
var statearr_13657_13675 = state_13652__$1;
(statearr_13657_13675[(2)] = inst_13635);

(statearr_13657_13675[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (6))){
var inst_13648 = (state_13652[(2)]);
var state_13652__$1 = state_13652;
var statearr_13658_13676 = state_13652__$1;
(statearr_13658_13676[(2)] = inst_13648);

(statearr_13658_13676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (3))){
var inst_13650 = (state_13652[(2)]);
var state_13652__$1 = state_13652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13652__$1,inst_13650);
} else {
if((state_val_13653 === (2))){
var inst_13617 = (state_13652[(7)]);
var inst_13619 = (state_13652[(8)]);
var inst_13626 = (state_13652[(13)]);
var inst_13618 = (state_13652[(10)]);
var inst_13625 = cljs.core.seq.call(null,inst_13617);
var inst_13626__$1 = cljs.core.first.call(null,inst_13625);
var inst_13627 = cljs.core.next.call(null,inst_13625);
var inst_13628 = (inst_13626__$1 == null);
var inst_13629 = (inst_13618 >= flake_limit);
var inst_13630 = (inst_13619 >= subject_limit);
var inst_13631 = ((inst_13628) || (inst_13629) || (inst_13630));
var state_13652__$1 = (function (){var statearr_13659 = state_13652;
(statearr_13659[(13)] = inst_13626__$1);

(statearr_13659[(14)] = inst_13627);

return statearr_13659;
})();
if(cljs.core.truth_(inst_13631)){
var statearr_13660_13677 = state_13652__$1;
(statearr_13660_13677[(1)] = (4));

} else {
var statearr_13661_13678 = state_13652__$1;
(statearr_13661_13678[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (9))){
var inst_13619 = (state_13652[(8)]);
var inst_13626 = (state_13652[(13)]);
var inst_13620 = (state_13652[(9)]);
var inst_13618 = (state_13652[(10)]);
var inst_13627 = (state_13652[(14)]);
var inst_13637 = (state_13652[(15)]);
var inst_13642 = (state_13652[(2)]);
var inst_13643 = (inst_13618 + inst_13637);
var inst_13644 = (inst_13619 + inst_13642);
var inst_13645 = cljs.core.into.call(null,inst_13620,inst_13626);
var inst_13617 = inst_13627;
var inst_13618__$1 = inst_13643;
var inst_13619__$1 = inst_13644;
var inst_13620__$1 = inst_13645;
var state_13652__$1 = (function (){var statearr_13662 = state_13652;
(statearr_13662[(7)] = inst_13617);

(statearr_13662[(8)] = inst_13619__$1);

(statearr_13662[(9)] = inst_13620__$1);

(statearr_13662[(10)] = inst_13618__$1);

return statearr_13662;
})();
var statearr_13663_13679 = state_13652__$1;
(statearr_13663_13679[(2)] = null);

(statearr_13663_13679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (5))){
var inst_13626 = (state_13652[(13)]);
var inst_13637 = (state_13652[(15)]);
var inst_13637__$1 = cljs.core.count.call(null,inst_13626);
var inst_13638 = cljs.core._EQ_.call(null,(0),inst_13637__$1);
var state_13652__$1 = (function (){var statearr_13664 = state_13652;
(statearr_13664[(15)] = inst_13637__$1);

return statearr_13664;
})();
if(inst_13638){
var statearr_13665_13680 = state_13652__$1;
(statearr_13665_13680[(1)] = (7));

} else {
var statearr_13666_13681 = state_13652__$1;
(statearr_13666_13681[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13653 === (8))){
var state_13652__$1 = state_13652;
var statearr_13667_13682 = state_13652__$1;
(statearr_13667_13682[(2)] = (1));

(statearr_13667_13682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____0 = (function (){
var statearr_13668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13668[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__);

(statearr_13668[(1)] = (1));

return statearr_13668;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____1 = (function (state_13652){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_13652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e13669){var ex__2457__auto__ = e13669;
var statearr_13670_13683 = state_13652;
(statearr_13670_13683[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_13652[(4)]))){
var statearr_13671_13684 = state_13652;
(statearr_13671_13684[(1)] = cljs.core.first.call(null,(state_13652[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13685 = state_13652;
state_13652 = G__13685;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__ = function(state_13652){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____1.call(this,state_13652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_13672 = f__2477__auto__.call(null);
(statearr_13672[(6)] = c__2476__auto__);

return statearr_13672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_13731){
var state_val_13732 = (state_13731[(1)]);
if((state_val_13732 === (7))){
var state_13731__$1 = state_13731;
var statearr_13733_13771 = state_13731__$1;
(statearr_13733_13771[(2)] = null);

(statearr_13733_13771[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (20))){
var inst_13717 = (state_13731[(2)]);
var inst_13718 = fluree.db.util.async.throw_err.call(null,inst_13717);
var inst_13696 = inst_13718;
var state_13731__$1 = (function (){var statearr_13734 = state_13731;
(statearr_13734[(7)] = inst_13696);

return statearr_13734;
})();
var statearr_13735_13772 = state_13731__$1;
(statearr_13735_13772[(2)] = null);

(statearr_13735_13772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (1))){
var state_13731__$1 = state_13731;
var statearr_13736_13773 = state_13731__$1;
(statearr_13736_13773[(2)] = null);

(statearr_13736_13773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (4))){
var inst_13686 = (state_13731[(2)]);
var state_13731__$1 = state_13731;
var statearr_13737_13774 = state_13731__$1;
(statearr_13737_13774[(2)] = inst_13686);

(statearr_13737_13774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (15))){
var inst_13713 = (state_13731[(8)]);
var inst_13696 = (state_13731[(7)]);
var inst_13713__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_13696);
var state_13731__$1 = (function (){var statearr_13738 = state_13731;
(statearr_13738[(8)] = inst_13713__$1);

return statearr_13738;
})();
if(cljs.core.truth_(inst_13713__$1)){
var statearr_13739_13775 = state_13731__$1;
(statearr_13739_13775[(1)] = (17));

} else {
var statearr_13740_13776 = state_13731__$1;
(statearr_13740_13776[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (13))){
var inst_13706 = (state_13731[(2)]);
var inst_13707 = fluree.db.util.async.throw_err.call(null,inst_13706);
var _ = (function (){var statearr_13741 = state_13731;
(statearr_13741[(4)] = cljs.core.rest.call(null,(state_13731[(4)])));

return statearr_13741;
})();
var state_13731__$1 = state_13731;
var statearr_13742_13777 = state_13731__$1;
(statearr_13742_13777[(2)] = inst_13707);

(statearr_13742_13777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (6))){
var inst_13694 = (state_13731[(2)]);
var inst_13695 = fluree.db.util.async.throw_err.call(null,inst_13694);
var inst_13696 = inst_13695;
var state_13731__$1 = (function (){var statearr_13743 = state_13731;
(statearr_13743[(7)] = inst_13696);

return statearr_13743;
})();
var statearr_13744_13778 = state_13731__$1;
(statearr_13744_13778[(2)] = null);

(statearr_13744_13778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (17))){
var inst_13713 = (state_13731[(8)]);
var inst_13715 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_13713);
var state_13731__$1 = state_13731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13731__$1,(20),inst_13715);
} else {
if((state_val_13732 === (3))){
var inst_13729 = (state_13731[(2)]);
var state_13731__$1 = state_13731;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13731__$1,inst_13729);
} else {
if((state_val_13732 === (12))){
var _ = (function (){var statearr_13746 = state_13731;
(statearr_13746[(4)] = cljs.core.rest.call(null,(state_13731[(4)])));

return statearr_13746;
})();
var state_13731__$1 = state_13731;
var ex13745 = (state_13731__$1[(2)]);
var statearr_13747_13779 = state_13731__$1;
(statearr_13747_13779[(5)] = ex13745);


if((ex13745 instanceof java.lang.Exception)){
var statearr_13748_13780 = state_13731__$1;
(statearr_13748_13780[(1)] = (11));

(statearr_13748_13780[(5)] = null);

} else {
throw ex13745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (2))){
var _ = (function (){var statearr_13749 = state_13731;
(statearr_13749[(4)] = cljs.core.cons.call(null,(5),(state_13731[(4)])));

return statearr_13749;
})();
var inst_13692 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_13731__$1 = state_13731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13731__$1,(6),inst_13692);
} else {
if((state_val_13732 === (19))){
var inst_13722 = (state_13731[(2)]);
var state_13731__$1 = state_13731;
var statearr_13750_13781 = state_13731__$1;
(statearr_13750_13781[(2)] = inst_13722);

(statearr_13750_13781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (11))){
var inst_13698 = (state_13731[(2)]);
var state_13731__$1 = (function (){var statearr_13752 = state_13731;
(statearr_13752[(9)] = inst_13698);

return statearr_13752;
})();
var statearr_13753_13782 = state_13731__$1;
(statearr_13753_13782[(2)] = null);

(statearr_13753_13782[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (9))){
var inst_13696 = (state_13731[(7)]);
var _ = (function (){var statearr_13754 = state_13731;
(statearr_13754[(4)] = cljs.core.cons.call(null,(12),(state_13731[(4)])));

return statearr_13754;
})();
var inst_13704 = fluree.db.dbproto._resolve_to_t.call(null,inst_13696,t,novelty,fast_forward_db_QMARK_);
var state_13731__$1 = state_13731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13731__$1,(13),inst_13704);
} else {
if((state_val_13732 === (5))){
var _ = (function (){var statearr_13755 = state_13731;
(statearr_13755[(4)] = cljs.core.rest.call(null,(state_13731[(4)])));

return statearr_13755;
})();
var state_13731__$1 = state_13731;
var ex13751 = (state_13731__$1[(2)]);
var statearr_13756_13783 = state_13731__$1;
(statearr_13756_13783[(5)] = ex13751);


if((ex13751 instanceof Error)){
var statearr_13757_13784 = state_13731__$1;
(statearr_13757_13784[(1)] = (4));

(statearr_13757_13784[(5)] = null);

} else {
throw ex13751;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (14))){
var inst_13710 = (state_13731[(10)]);
var state_13731__$1 = state_13731;
var statearr_13758_13785 = state_13731__$1;
(statearr_13758_13785[(2)] = inst_13710);

(statearr_13758_13785[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (16))){
var inst_13724 = (state_13731[(2)]);
var state_13731__$1 = state_13731;
var statearr_13759_13786 = state_13731__$1;
(statearr_13759_13786[(2)] = inst_13724);

(statearr_13759_13786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (10))){
var inst_13710 = (state_13731[(10)]);
var inst_13710__$1 = (state_13731[(2)]);
var state_13731__$1 = (function (){var statearr_13760 = state_13731;
(statearr_13760[(10)] = inst_13710__$1);

return statearr_13760;
})();
if(cljs.core.truth_(inst_13710__$1)){
var statearr_13761_13787 = state_13731__$1;
(statearr_13761_13787[(1)] = (14));

} else {
var statearr_13762_13788 = state_13731__$1;
(statearr_13762_13788[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (18))){
var state_13731__$1 = state_13731;
var statearr_13763_13789 = state_13731__$1;
(statearr_13763_13789[(2)] = null);

(statearr_13763_13789[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13732 === (8))){
var inst_13726 = (state_13731[(2)]);
var _ = (function (){var statearr_13764 = state_13731;
(statearr_13764[(4)] = cljs.core.rest.call(null,(state_13731[(4)])));

return statearr_13764;
})();
var state_13731__$1 = state_13731;
var statearr_13765_13790 = state_13731__$1;
(statearr_13765_13790[(2)] = inst_13726);

(statearr_13765_13790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____0 = (function (){
var statearr_13766 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13766[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__);

(statearr_13766[(1)] = (1));

return statearr_13766;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____1 = (function (state_13731){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_13731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e13767){var ex__2457__auto__ = e13767;
var statearr_13768_13791 = state_13731;
(statearr_13768_13791[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_13731[(4)]))){
var statearr_13769_13792 = state_13731;
(statearr_13769_13792[(1)] = cljs.core.first.call(null,(state_13731[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13793 = state_13731;
state_13731 = G__13793;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__ = function(state_13731){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____1.call(this,state_13731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_13770 = f__2477__auto__.call(null);
(statearr_13770[(6)] = c__2476__auto__);

return statearr_13770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__13800 = arguments.length;
switch (G__13800) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13801 = (function (){var pred__13804 = cljs.core.identical_QMARK_;
var expr__13805 = test;
if(cljs.core.truth_(pred__13804.call(null,cljs.core._EQ_,expr__13805))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13804.call(null,cljs.core._LT_,expr__13805))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13804.call(null,cljs.core._LT__EQ_,expr__13805))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13804.call(null,cljs.core._GT_,expr__13805))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13804.call(null,cljs.core._GT__EQ_,expr__13805))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13805)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13801,(0),null);
var start_match = cljs.core.nth.call(null,vec__13801,(1),null);
var end_test = cljs.core.nth.call(null,vec__13801,(2),null);
var end_match = cljs.core.nth.call(null,vec__13801,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_14203){
var state_val_14204 = (state_14203[(1)]);
if((state_val_14204 === (121))){
var inst_14064 = (state_14203[(7)]);
var state_14203__$1 = state_14203;
var statearr_14205_14408 = state_14203__$1;
(statearr_14205_14408[(2)] = inst_14064);

(statearr_14205_14408[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (65))){
var state_14203__$1 = state_14203;
var statearr_14206_14409 = state_14203__$1;
(statearr_14206_14409[(2)] = fluree.db.util.core.min_integer);

(statearr_14206_14409[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (70))){
var state_14203__$1 = state_14203;
var statearr_14207_14410 = state_14203__$1;
(statearr_14207_14410[(2)] = true);

(statearr_14207_14410[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (62))){
var inst_13966 = (cljs.core._LT__EQ_ === end_test);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13966)){
var statearr_14208_14411 = state_14203__$1;
(statearr_14208_14411[(1)] = (64));

} else {
var statearr_14209_14412 = state_14203__$1;
(statearr_14209_14412[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (74))){
var inst_13975 = (state_14203[(8)]);
var state_14203__$1 = state_14203;
var statearr_14210_14413 = state_14203__$1;
(statearr_14210_14413[(2)] = inst_13975);

(statearr_14210_14413[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (110))){
var inst_14107 = (state_14203[(9)]);
var inst_14105 = (state_14203[(10)]);
var inst_14030 = (state_14203[(11)]);
var inst_14106 = (state_14203[(12)]);
var inst_14097 = (state_14203[(13)]);
var inst_14003 = (state_14203[(14)]);
var inst_14105__$1 = cljs.core.count.call(null,inst_14097);
var inst_14106__$1 = (inst_14030 + inst_14105__$1);
var inst_14107__$1 = (inst_14106__$1 - inst_14003);
var inst_14108 = cljs.core.pos_int_QMARK_.call(null,inst_14107__$1);
var state_14203__$1 = (function (){var statearr_14211 = state_14203;
(statearr_14211[(9)] = inst_14107__$1);

(statearr_14211[(10)] = inst_14105__$1);

(statearr_14211[(12)] = inst_14106__$1);

return statearr_14211;
})();
if(inst_14108){
var statearr_14212_14414 = state_14203__$1;
(statearr_14212_14414[(1)] = (113));

} else {
var statearr_14213_14415 = state_14203__$1;
(statearr_14213_14415[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (130))){
var inst_14166 = (state_14203[(15)]);
var state_14203__$1 = state_14203;
var statearr_14214_14416 = state_14203__$1;
(statearr_14214_14416[(2)] = inst_14166);

(statearr_14214_14416[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (128))){
var inst_14175 = (state_14203[(16)]);
var state_14203__$1 = state_14203;
var statearr_14215_14417 = state_14203__$1;
(statearr_14215_14417[(2)] = inst_14175);

(statearr_14215_14417[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (7))){
var state_14203__$1 = state_14203;
var statearr_14216_14418 = state_14203__$1;
(statearr_14216_14418[(2)] = false);

(statearr_14216_14418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (59))){
var state_14203__$1 = state_14203;
var statearr_14217_14419 = state_14203__$1;
(statearr_14217_14419[(2)] = (2147483647));

(statearr_14217_14419[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (86))){
var inst_13936 = (state_14203[(17)]);
var inst_14027 = (state_14203[(18)]);
var inst_13883 = (state_14203[(19)]);
var inst_14004 = (state_14203[(20)]);
var inst_14014 = (state_14203[(21)]);
var inst_13973 = (state_14203[(22)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_14009 = (state_14203[(25)]);
var inst_13827 = (state_14203[(26)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_14010 = (state_14203[(31)]);
var inst_13954 = (state_14203[(32)]);
var inst_13864 = (state_14203[(33)]);
var inst_13974 = (state_14203[(34)]);
var inst_14030 = (state_14203[(11)]);
var inst_14005 = (state_14203[(35)]);
var inst_14015 = (state_14203[(36)]);
var inst_13863 = (state_14203[(37)]);
var inst_13915 = (state_14203[(38)]);
var inst_14024 = (state_14203[(39)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_14029 = (state_14203[(43)]);
var inst_13831 = (state_14203[(44)]);
var inst_13914 = (state_14203[(45)]);
var inst_13997 = (state_14203[(46)]);
var inst_14020 = (state_14203[(47)]);
var inst_13918 = (state_14203[(48)]);
var inst_13839 = (state_14203[(49)]);
var inst_13996 = (state_14203[(50)]);
var inst_13874 = (state_14203[(51)]);
var inst_14037 = (state_14203[(52)]);
var inst_13927 = (state_14203[(53)]);
var inst_14003 = (state_14203[(14)]);
var inst_14041 = (function (){var no_filter_QMARK_ = true;
var t = inst_14010;
var max_limit_QMARK_ = inst_14004;
var next_node = inst_14027;
var fast_forward_db_QMARK_ = inst_14015;
var s1 = inst_13874;
var o2 = inst_13936;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var i = inst_14029;
var m1 = inst_13963;
var root_node = inst_14020;
var s2 = inst_13883;
var vec__13820 = inst_13914;
var p2 = inst_13954;
var G__14038 = inst_14037;
var permissions = inst_14005;
var limit = inst_14003;
var start_flake = inst_13973;
var map__13826 = inst_13996;
var flake_limit = inst_13997;
var offset = inst_14028;
var vec__13823 = inst_13915;
var acc = inst_14031;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13927;
var map__13819 = inst_13862;
var end_flake = inst_13974;
var base_result = inst_14037;
var s = inst_14030;
var node_start = inst_14024;
var p1 = inst_13945;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13918;
var idx_compare = inst_14009;
var op2 = inst_13839;
var m2 = inst_13972;
var novelty = inst_14014;
return (function (p1__13794_SHARP_){
return cljs.core._EQ_.call(null,p1__13794_SHARP_.o,start_flake.o);
});
})();
var inst_14042 = cljs.core.filter.call(null,inst_14041,inst_14037);
var state_14203__$1 = state_14203;
var statearr_14218_14420 = state_14203__$1;
(statearr_14218_14420[(2)] = inst_14042);

(statearr_14218_14420[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (20))){
var inst_13835 = (state_14203[(54)]);
var state_14203__$1 = state_14203;
var statearr_14219_14421 = state_14203__$1;
(statearr_14219_14421[(2)] = inst_13835);

(statearr_14219_14421[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (72))){
var inst_13988 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14220_14422 = state_14203__$1;
(statearr_14220_14422[(2)] = inst_13988);

(statearr_14220_14422[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (58))){
var state_14203__$1 = state_14203;
var statearr_14221_14423 = state_14203__$1;
(statearr_14221_14423[(2)] = fluree.db.util.core.min_integer);

(statearr_14221_14423[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (60))){
var inst_13961 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14222_14424 = state_14203__$1;
(statearr_14222_14424[(2)] = inst_13961);

(statearr_14222_14424[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (27))){
var state_14203__$1 = state_14203;
var statearr_14223_14425 = state_14203__$1;
(statearr_14223_14425[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (1))){
var state_14203__$1 = state_14203;
var statearr_14225_14426 = state_14203__$1;
(statearr_14225_14426[(2)] = null);

(statearr_14225_14426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (69))){
var inst_13991 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13991)){
var statearr_14226_14427 = state_14203__$1;
(statearr_14226_14427[(1)] = (73));

} else {
var statearr_14227_14428 = state_14203__$1;
(statearr_14227_14428[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (101))){
var state_14203__$1 = state_14203;
var statearr_14228_14429 = state_14203__$1;
(statearr_14228_14429[(2)] = true);

(statearr_14228_14429[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (24))){
var inst_13837 = (state_14203[(55)]);
var inst_13887 = cljs.core.boolean_QMARK_.call(null,inst_13837);
var state_14203__$1 = state_14203;
if(inst_13887){
var statearr_14229_14430 = state_14203__$1;
(statearr_14229_14430[(1)] = (26));

} else {
var statearr_14230_14431 = state_14203__$1;
(statearr_14230_14431[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (102))){
var state_14203__$1 = state_14203;
var statearr_14231_14432 = state_14203__$1;
(statearr_14231_14432[(2)] = false);

(statearr_14231_14432[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (55))){
var inst_13833 = (state_14203[(56)]);
var state_14203__$1 = state_14203;
var statearr_14232_14433 = state_14203__$1;
(statearr_14232_14433[(2)] = inst_13833);

(statearr_14232_14433[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (85))){
var inst_14195 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14233_14434 = state_14203__$1;
(statearr_14233_14434[(2)] = inst_14195);

(statearr_14233_14434[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (39))){
var inst_13917 = (state_14203[(57)]);
var inst_13930 = fluree.db.dbproto._subid.call(null,db,inst_13917);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(42),inst_13930);
} else {
if((state_val_14204 === (88))){
var inst_13863 = (state_14203[(37)]);
var inst_14045 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14234 = state_14203;
(statearr_14234[(58)] = inst_14045);

return statearr_14234;
})();
if(cljs.core.truth_(inst_13863)){
var statearr_14235_14435 = state_14203__$1;
(statearr_14235_14435[(1)] = (89));

} else {
var statearr_14236_14436 = state_14203__$1;
(statearr_14236_14436[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (46))){
var state_14203__$1 = state_14203;
var statearr_14237_14437 = state_14203__$1;
(statearr_14237_14437[(2)] = (-1));

(statearr_14237_14437[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (4))){
var inst_13807 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14238_14438 = state_14203__$1;
(statearr_14238_14438[(2)] = inst_13807);

(statearr_14238_14438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (77))){
var state_14203__$1 = state_14203;
var statearr_14239_14439 = state_14203__$1;
(statearr_14239_14439[(2)] = fluree.db.util.core.max_long);

(statearr_14239_14439[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (106))){
var inst_14064 = (state_14203[(7)]);
var inst_14162 = (state_14203[(2)]);
var inst_14163 = cljs.core.nth.call(null,inst_14162,(0),null);
var inst_14164 = cljs.core.nth.call(null,inst_14162,(1),null);
var inst_14165 = cljs.core.nth.call(null,inst_14162,(2),null);
var inst_14166 = cljs.core.nth.call(null,inst_14162,(3),null);
var state_14203__$1 = (function (){var statearr_14240 = state_14203;
(statearr_14240[(15)] = inst_14166);

(statearr_14240[(59)] = inst_14163);

(statearr_14240[(60)] = inst_14165);

(statearr_14240[(61)] = inst_14164);

return statearr_14240;
})();
if(cljs.core.truth_(inst_14064)){
var statearr_14241_14440 = state_14203__$1;
(statearr_14241_14440[(1)] = (120));

} else {
var statearr_14242_14441 = state_14203__$1;
(statearr_14242_14441[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (119))){
var inst_14148 = (state_14203[(2)]);
var inst_14149 = fluree.db.util.async.throw_err.call(null,inst_14148);
var state_14203__$1 = state_14203;
var statearr_14243_14442 = state_14203__$1;
(statearr_14243_14442[(2)] = inst_14149);

(statearr_14243_14442[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (95))){
var inst_13936 = (state_14203[(17)]);
var inst_14027 = (state_14203[(18)]);
var inst_13883 = (state_14203[(19)]);
var inst_14004 = (state_14203[(20)]);
var inst_14014 = (state_14203[(21)]);
var inst_13973 = (state_14203[(22)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_14009 = (state_14203[(25)]);
var inst_13827 = (state_14203[(26)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_14010 = (state_14203[(31)]);
var inst_13954 = (state_14203[(32)]);
var inst_13864 = (state_14203[(33)]);
var inst_13974 = (state_14203[(34)]);
var inst_14030 = (state_14203[(11)]);
var inst_14005 = (state_14203[(35)]);
var inst_14057 = (state_14203[(62)]);
var inst_14015 = (state_14203[(36)]);
var inst_13863 = (state_14203[(37)]);
var inst_13915 = (state_14203[(38)]);
var inst_14024 = (state_14203[(39)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_14029 = (state_14203[(43)]);
var inst_13831 = (state_14203[(44)]);
var inst_13914 = (state_14203[(45)]);
var inst_13997 = (state_14203[(46)]);
var inst_14020 = (state_14203[(47)]);
var inst_13918 = (state_14203[(48)]);
var inst_13839 = (state_14203[(49)]);
var inst_13996 = (state_14203[(50)]);
var inst_13874 = (state_14203[(51)]);
var inst_14037 = (state_14203[(52)]);
var inst_13927 = (state_14203[(53)]);
var inst_14003 = (state_14203[(14)]);
var inst_14059 = (function (){var no_filter_QMARK_ = true;
var t = inst_14010;
var max_limit_QMARK_ = inst_14004;
var next_node = inst_14027;
var fast_forward_db_QMARK_ = inst_14015;
var s1 = inst_13874;
var o2 = inst_13936;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var i = inst_14029;
var m1 = inst_13963;
var root_node = inst_14020;
var s2 = inst_13883;
var vec__13820 = inst_13914;
var p2 = inst_13954;
var G__14038 = inst_14057;
var permissions = inst_14005;
var limit = inst_14003;
var start_flake = inst_13973;
var map__13826 = inst_13996;
var flake_limit = inst_13997;
var offset = inst_14028;
var vec__13823 = inst_13915;
var acc = inst_14031;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13927;
var map__13819 = inst_13862;
var end_flake = inst_13974;
var base_result = inst_14037;
var s = inst_14030;
var node_start = inst_14024;
var p1 = inst_13945;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13918;
var idx_compare = inst_14009;
var op2 = inst_13839;
var m2 = inst_13972;
var novelty = inst_14014;
return (function (p1__13797_SHARP_){
return object_fn.call(null,p1__13797_SHARP_.o);
});
})();
var inst_14060 = cljs.core.filter.call(null,inst_14059,inst_14057);
var state_14203__$1 = state_14203;
var statearr_14244_14443 = state_14203__$1;
(statearr_14244_14443[(2)] = inst_14060);

(statearr_14244_14443[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (54))){
var inst_13833 = (state_14203[(56)]);
var inst_13954 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14245 = state_14203;
(statearr_14245[(32)] = inst_13954);

return statearr_14245;
})();
if(cljs.core.truth_(inst_13833)){
var statearr_14246_14444 = state_14203__$1;
(statearr_14246_14444[(1)] = (55));

} else {
var statearr_14247_14445 = state_14203__$1;
(statearr_14247_14445[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (92))){
var inst_13936 = (state_14203[(17)]);
var inst_14027 = (state_14203[(18)]);
var inst_13883 = (state_14203[(19)]);
var inst_14004 = (state_14203[(20)]);
var inst_14014 = (state_14203[(21)]);
var inst_13973 = (state_14203[(22)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_14009 = (state_14203[(25)]);
var inst_13827 = (state_14203[(26)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_14010 = (state_14203[(31)]);
var inst_13954 = (state_14203[(32)]);
var inst_13864 = (state_14203[(33)]);
var inst_13974 = (state_14203[(34)]);
var inst_14051 = (state_14203[(63)]);
var inst_14030 = (state_14203[(11)]);
var inst_14005 = (state_14203[(35)]);
var inst_14015 = (state_14203[(36)]);
var inst_13863 = (state_14203[(37)]);
var inst_13915 = (state_14203[(38)]);
var inst_14024 = (state_14203[(39)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_14029 = (state_14203[(43)]);
var inst_13831 = (state_14203[(44)]);
var inst_13914 = (state_14203[(45)]);
var inst_13997 = (state_14203[(46)]);
var inst_14020 = (state_14203[(47)]);
var inst_13918 = (state_14203[(48)]);
var inst_13839 = (state_14203[(49)]);
var inst_13996 = (state_14203[(50)]);
var inst_13874 = (state_14203[(51)]);
var inst_14037 = (state_14203[(52)]);
var inst_13927 = (state_14203[(53)]);
var inst_14003 = (state_14203[(14)]);
var inst_14053 = (function (){var no_filter_QMARK_ = true;
var t = inst_14010;
var max_limit_QMARK_ = inst_14004;
var next_node = inst_14027;
var fast_forward_db_QMARK_ = inst_14015;
var s1 = inst_13874;
var o2 = inst_13936;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var i = inst_14029;
var m1 = inst_13963;
var root_node = inst_14020;
var s2 = inst_13883;
var vec__13820 = inst_13914;
var p2 = inst_13954;
var G__14038 = inst_14051;
var permissions = inst_14005;
var limit = inst_14003;
var start_flake = inst_13973;
var map__13826 = inst_13996;
var flake_limit = inst_13997;
var offset = inst_14028;
var vec__13823 = inst_13915;
var acc = inst_14031;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13927;
var map__13819 = inst_13862;
var end_flake = inst_13974;
var base_result = inst_14037;
var s = inst_14030;
var node_start = inst_14024;
var p1 = inst_13945;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13918;
var idx_compare = inst_14009;
var op2 = inst_13839;
var m2 = inst_13972;
var novelty = inst_14014;
return (function (p1__13796_SHARP_){
return predicate_fn.call(null,p1__13796_SHARP_.p);
});
})();
var inst_14054 = cljs.core.filter.call(null,inst_14053,inst_14051);
var state_14203__$1 = state_14203;
var statearr_14248_14446 = state_14203__$1;
(statearr_14248_14446[(2)] = inst_14054);

(statearr_14248_14446[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (104))){
var inst_14031 = (state_14203[(28)]);
var inst_14030 = (state_14203[(11)]);
var inst_14063 = (state_14203[(64)]);
var inst_14029 = (state_14203[(43)]);
var inst_13997 = (state_14203[(46)]);
var inst_14075 = cljs.core.count.call(null,inst_14063);
var inst_14076 = (inst_13997 - inst_14029);
var inst_14077 = cljs.core.take.call(null,inst_14076,inst_14063);
var inst_14078 = cljs.core.into.call(null,inst_14031,inst_14077);
var inst_14079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14080 = (inst_14029 + inst_14075);
var inst_14081 = [(0),inst_14080,inst_14030,inst_14078];
var inst_14082 = (new cljs.core.PersistentVector(null,4,(5),inst_14079,inst_14081,null));
var state_14203__$1 = state_14203;
var statearr_14249_14447 = state_14203__$1;
(statearr_14249_14447[(2)] = inst_14082);

(statearr_14249_14447[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (15))){
var inst_13828 = (state_14203[(65)]);
var inst_13868 = fluree.db.dbproto._subid.call(null,db,inst_13828);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(18),inst_13868);
} else {
if((state_val_14204 === (48))){
var inst_13836 = (state_14203[(66)]);
var inst_13945 = (state_14203[(2)]);
var inst_13946 = (inst_13836 == null);
var state_14203__$1 = (function (){var statearr_14250 = state_14203;
(statearr_14250[(42)] = inst_13945);

return statearr_14250;
})();
if(cljs.core.truth_(inst_13946)){
var statearr_14251_14448 = state_14203__$1;
(statearr_14251_14448[(1)] = (49));

} else {
var statearr_14252_14449 = state_14203__$1;
(statearr_14252_14449[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (50))){
var state_14203__$1 = state_14203;
var statearr_14253_14450 = state_14203__$1;
(statearr_14253_14450[(2)] = false);

(statearr_14253_14450[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (116))){
var inst_14123 = (state_14203[(67)]);
var inst_13997 = (state_14203[(46)]);
var inst_14125 = (state_14203[(68)]);
var inst_14124 = (state_14203[(69)]);
var inst_14128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14129 = (inst_14125 - inst_13997);
var inst_14130 = (inst_14124 - inst_14129);
var inst_14131 = cljs.core.take.call(null,inst_14130,inst_14123);
var inst_14132 = [inst_13997,inst_14131];
var inst_14133 = (new cljs.core.PersistentVector(null,2,(5),inst_14128,inst_14132,null));
var state_14203__$1 = state_14203;
var statearr_14254_14451 = state_14203__$1;
(statearr_14254_14451[(2)] = inst_14133);

(statearr_14254_14451[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (75))){
var inst_13998 = (state_14203[(70)]);
var inst_13996 = (state_14203[(50)]);
var inst_13996__$1 = (state_14203[(2)]);
var inst_13997 = cljs.core.get.call(null,inst_13996__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_13998__$1 = cljs.core.get.call(null,inst_13996__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_13999 = cljs.core.get.call(null,inst_13996__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14203__$1 = (function (){var statearr_14255 = state_14203;
(statearr_14255[(70)] = inst_13998__$1);

(statearr_14255[(71)] = inst_13999);

(statearr_14255[(46)] = inst_13997);

(statearr_14255[(50)] = inst_13996__$1);

return statearr_14255;
})();
if(cljs.core.truth_(inst_13998__$1)){
var statearr_14256_14452 = state_14203__$1;
(statearr_14256_14452[(1)] = (76));

} else {
var statearr_14257_14453 = state_14203__$1;
(statearr_14257_14453[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (99))){
var inst_14004 = (state_14203[(20)]);
var state_14203__$1 = state_14203;
var statearr_14258_14454 = state_14203__$1;
(statearr_14258_14454[(2)] = inst_14004);

(statearr_14258_14454[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (21))){
var inst_13830 = (state_14203[(72)]);
var inst_13883 = (state_14203[(2)]);
var inst_13884 = cljs.core.boolean_QMARK_.call(null,inst_13830);
var state_14203__$1 = (function (){var statearr_14259 = state_14203;
(statearr_14259[(19)] = inst_13883);

return statearr_14259;
})();
if(inst_13884){
var statearr_14260_14455 = state_14203__$1;
(statearr_14260_14455[(1)] = (23));

} else {
var statearr_14261_14456 = state_14203__$1;
(statearr_14261_14456[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (31))){
var inst_13893 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14262_14457 = state_14203__$1;
(statearr_14262_14457[(2)] = inst_13893);

(statearr_14262_14457[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (113))){
var inst_14107 = (state_14203[(9)]);
var inst_14105 = (state_14203[(10)]);
var inst_14003 = (state_14203[(14)]);
var inst_14110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14111 = (inst_14105 - inst_14107);
var inst_14112 = [inst_14003,inst_14111];
var inst_14113 = (new cljs.core.PersistentVector(null,2,(5),inst_14110,inst_14112,null));
var state_14203__$1 = state_14203;
var statearr_14263_14458 = state_14203__$1;
(statearr_14263_14458[(2)] = inst_14113);

(statearr_14263_14458[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (32))){
var inst_13883 = (state_14203[(19)]);
var inst_13833 = (state_14203[(56)]);
var inst_13837 = (state_14203[(55)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_13827 = (state_14203[(26)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_13830 = (state_14203[(72)]);
var inst_13897 = (state_14203[(73)]);
var inst_13864 = (state_14203[(33)]);
var inst_13836 = (state_14203[(66)]);
var inst_13863 = (state_14203[(37)]);
var inst_13831 = (state_14203[(44)]);
var inst_13839 = (state_14203[(49)]);
var inst_13874 = (state_14203[(51)]);
var inst_13865 = (state_14203[(74)]);
var inst_13840 = (state_14203[(75)]);
var inst_13829 = (state_14203[(76)]);
var inst_13899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13901 = [null,null];
var inst_13902 = (new cljs.core.PersistentVector(null,2,(5),inst_13900,inst_13901,null));
var inst_13903 = (function (){var bool = inst_13897;
var temp__5733__auto__ = inst_13897;
var s1 = inst_13874;
var o2 = inst_13837;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var m1 = inst_13833;
var s2 = inst_13883;
var p2 = inst_13836;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13830;
var map__13819 = inst_13862;
var p1 = inst_13829;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13865;
var op2 = inst_13839;
var m2 = inst_13840;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_13904 = [inst_13902,inst_13903];
var inst_13905 = (new cljs.core.PersistentVector(null,2,(5),inst_13899,inst_13904,null));
var state_14203__$1 = state_14203;
var statearr_14264_14459 = state_14203__$1;
(statearr_14264_14459[(2)] = inst_13905);

(statearr_14264_14459[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (40))){
var inst_13917 = (state_14203[(57)]);
var state_14203__$1 = state_14203;
var statearr_14265_14460 = state_14203__$1;
(statearr_14265_14460[(2)] = inst_13917);

(statearr_14265_14460[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (129))){
var inst_14187 = (state_14203[(2)]);
var inst_14188 = cljs.core.not.call(null,inst_14187);
var state_14203__$1 = state_14203;
if(inst_14188){
var statearr_14266_14461 = state_14203__$1;
(statearr_14266_14461[(1)] = (130));

} else {
var statearr_14267_14462 = state_14203__$1;
(statearr_14267_14462[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (91))){
var inst_13864 = (state_14203[(33)]);
var inst_14051 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14268 = state_14203;
(statearr_14268[(63)] = inst_14051);

return statearr_14268;
})();
if(cljs.core.truth_(inst_13864)){
var statearr_14269_14463 = state_14203__$1;
(statearr_14269_14463[(1)] = (92));

} else {
var statearr_14270_14464 = state_14203__$1;
(statearr_14270_14464[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (117))){
var inst_14123 = (state_14203[(67)]);
var inst_14125 = (state_14203[(68)]);
var inst_14135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14136 = [inst_14125,inst_14123];
var inst_14137 = (new cljs.core.PersistentVector(null,2,(5),inst_14135,inst_14136,null));
var state_14203__$1 = state_14203;
var statearr_14271_14465 = state_14203__$1;
(statearr_14271_14465[(2)] = inst_14137);

(statearr_14271_14465[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (108))){
var inst_14085 = (state_14203[(77)]);
var inst_14028 = (state_14203[(27)]);
var inst_14097 = cljs.core.drop.call(null,inst_14028,inst_14085);
var state_14203__$1 = (function (){var statearr_14272 = state_14203;
(statearr_14272[(13)] = inst_14097);

return statearr_14272;
})();
var statearr_14273_14466 = state_14203__$1;
(statearr_14273_14466[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (56))){
var inst_13957 = (cljs.core._GT__EQ_ === start_test);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13957)){
var statearr_14275_14467 = state_14203__$1;
(statearr_14275_14467[(1)] = (58));

} else {
var statearr_14276_14468 = state_14203__$1;
(statearr_14276_14468[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (33))){
var inst_13837 = (state_14203[(55)]);
var inst_13830 = (state_14203[(72)]);
var inst_13865 = (state_14203[(74)]);
var inst_13907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13909 = [inst_13830,inst_13837];
var inst_13910 = (new cljs.core.PersistentVector(null,2,(5),inst_13908,inst_13909,null));
var inst_13911 = [inst_13910,inst_13865];
var inst_13912 = (new cljs.core.PersistentVector(null,2,(5),inst_13907,inst_13911,null));
var state_14203__$1 = state_14203;
var statearr_14277_14469 = state_14203__$1;
(statearr_14277_14469[(2)] = inst_13912);

(statearr_14277_14469[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (13))){
var inst_13841 = (state_14203[(78)]);
var state_14203__$1 = state_14203;
var statearr_14278_14470 = state_14203__$1;
(statearr_14278_14470[(2)] = inst_13841);

(statearr_14278_14470[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (22))){
var inst_13879 = (state_14203[(2)]);
var inst_13880 = fluree.db.util.async.throw_err.call(null,inst_13879);
var state_14203__$1 = state_14203;
var statearr_14279_14471 = state_14203__$1;
(statearr_14279_14471[(2)] = inst_13880);

(statearr_14279_14471[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (90))){
var inst_14045 = (state_14203[(58)]);
var state_14203__$1 = state_14203;
var statearr_14280_14472 = state_14203__$1;
(statearr_14280_14472[(2)] = inst_14045);

(statearr_14280_14472[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (109))){
var inst_14160 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14281_14473 = state_14203__$1;
(statearr_14281_14473[(2)] = inst_14160);

(statearr_14281_14473[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (36))){
var inst_13916 = (state_14203[(79)]);
var state_14203__$1 = state_14203;
var statearr_14282_14474 = state_14203__$1;
(statearr_14282_14474[(2)] = inst_13916);

(statearr_14282_14474[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (41))){
var inst_13829 = (state_14203[(76)]);
var inst_13936 = (state_14203[(2)]);
var inst_13937 = (inst_13829 == null);
var state_14203__$1 = (function (){var statearr_14283 = state_14203;
(statearr_14283[(17)] = inst_13936);

return statearr_14283;
})();
if(cljs.core.truth_(inst_13937)){
var statearr_14284_14475 = state_14203__$1;
(statearr_14284_14475[(1)] = (43));

} else {
var statearr_14285_14476 = state_14203__$1;
(statearr_14285_14476[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (118))){
var inst_14120 = (state_14203[(80)]);
var inst_14139 = (state_14203[(2)]);
var inst_14140 = cljs.core.nth.call(null,inst_14139,(0),null);
var inst_14141 = cljs.core.nth.call(null,inst_14139,(1),null);
var inst_14142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14143 = [inst_14140,inst_14120,inst_14141];
var inst_14144 = (new cljs.core.PersistentVector(null,3,(5),inst_14142,inst_14143,null));
var state_14203__$1 = state_14203;
var statearr_14286_14477 = state_14203__$1;
(statearr_14286_14477[(2)] = inst_14144);

(statearr_14286_14477[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (89))){
var inst_13936 = (state_14203[(17)]);
var inst_14045 = (state_14203[(58)]);
var inst_14027 = (state_14203[(18)]);
var inst_13883 = (state_14203[(19)]);
var inst_14004 = (state_14203[(20)]);
var inst_14014 = (state_14203[(21)]);
var inst_13973 = (state_14203[(22)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_14009 = (state_14203[(25)]);
var inst_13827 = (state_14203[(26)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_14010 = (state_14203[(31)]);
var inst_13954 = (state_14203[(32)]);
var inst_13864 = (state_14203[(33)]);
var inst_13974 = (state_14203[(34)]);
var inst_14030 = (state_14203[(11)]);
var inst_14005 = (state_14203[(35)]);
var inst_14015 = (state_14203[(36)]);
var inst_13863 = (state_14203[(37)]);
var inst_13915 = (state_14203[(38)]);
var inst_14024 = (state_14203[(39)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_14029 = (state_14203[(43)]);
var inst_13831 = (state_14203[(44)]);
var inst_13914 = (state_14203[(45)]);
var inst_13997 = (state_14203[(46)]);
var inst_14020 = (state_14203[(47)]);
var inst_13918 = (state_14203[(48)]);
var inst_13839 = (state_14203[(49)]);
var inst_13996 = (state_14203[(50)]);
var inst_13874 = (state_14203[(51)]);
var inst_14037 = (state_14203[(52)]);
var inst_13927 = (state_14203[(53)]);
var inst_14003 = (state_14203[(14)]);
var inst_14047 = (function (){var no_filter_QMARK_ = true;
var t = inst_14010;
var max_limit_QMARK_ = inst_14004;
var next_node = inst_14027;
var fast_forward_db_QMARK_ = inst_14015;
var s1 = inst_13874;
var o2 = inst_13936;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var i = inst_14029;
var m1 = inst_13963;
var root_node = inst_14020;
var s2 = inst_13883;
var vec__13820 = inst_13914;
var p2 = inst_13954;
var G__14038 = inst_14045;
var permissions = inst_14005;
var limit = inst_14003;
var start_flake = inst_13973;
var map__13826 = inst_13996;
var flake_limit = inst_13997;
var offset = inst_14028;
var vec__13823 = inst_13915;
var acc = inst_14031;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13927;
var map__13819 = inst_13862;
var end_flake = inst_13974;
var base_result = inst_14037;
var s = inst_14030;
var node_start = inst_14024;
var p1 = inst_13945;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13918;
var idx_compare = inst_14009;
var op2 = inst_13839;
var m2 = inst_13972;
var novelty = inst_14014;
return (function (p1__13795_SHARP_){
return subject_fn.call(null,p1__13795_SHARP_.s);
});
})();
var inst_14048 = cljs.core.filter.call(null,inst_14047,inst_14045);
var state_14203__$1 = state_14203;
var statearr_14287_14478 = state_14203__$1;
(statearr_14287_14478[(2)] = inst_14048);

(statearr_14287_14478[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (100))){
var inst_14073 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_14073)){
var statearr_14288_14479 = state_14203__$1;
(statearr_14288_14479[(1)] = (104));

} else {
var statearr_14289_14480 = state_14203__$1;
(statearr_14289_14480[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (131))){
var inst_14166 = (state_14203[(15)]);
var inst_14163 = (state_14203[(59)]);
var inst_14165 = (state_14203[(60)]);
var inst_14164 = (state_14203[(61)]);
var inst_14183 = (state_14203[(81)]);
var inst_14027 = inst_14183;
var inst_14028 = inst_14163;
var inst_14029 = inst_14164;
var inst_14030 = inst_14165;
var inst_14031 = inst_14166;
var state_14203__$1 = (function (){var statearr_14290 = state_14203;
(statearr_14290[(18)] = inst_14027);

(statearr_14290[(27)] = inst_14028);

(statearr_14290[(28)] = inst_14031);

(statearr_14290[(11)] = inst_14030);

(statearr_14290[(43)] = inst_14029);

return statearr_14290;
})();
var statearr_14291_14481 = state_14203__$1;
(statearr_14291_14481[(2)] = null);

(statearr_14291_14481[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (122))){
var inst_14175 = (state_14203[(16)]);
var inst_14175__$1 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14292 = state_14203;
(statearr_14292[(16)] = inst_14175__$1);

return statearr_14292;
})();
if(cljs.core.truth_(inst_14175__$1)){
var statearr_14293_14482 = state_14203__$1;
(statearr_14293_14482[(1)] = (123));

} else {
var statearr_14294_14483 = state_14203__$1;
(statearr_14294_14483[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (43))){
var inst_13927 = (state_14203[(53)]);
var state_14203__$1 = state_14203;
var statearr_14295_14484 = state_14203__$1;
(statearr_14295_14484[(2)] = inst_13927);

(statearr_14295_14484[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (61))){
var inst_13840 = (state_14203[(75)]);
var state_14203__$1 = state_14203;
var statearr_14296_14485 = state_14203__$1;
(statearr_14296_14485[(2)] = inst_13840);

(statearr_14296_14485[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (29))){
var state_14203__$1 = state_14203;
var statearr_14297_14486 = state_14203__$1;
(statearr_14297_14486[(2)] = null);

(statearr_14297_14486[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (44))){
var state_14203__$1 = state_14203;
var statearr_14298_14487 = state_14203__$1;
(statearr_14298_14487[(2)] = false);

(statearr_14298_14487[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (93))){
var inst_14051 = (state_14203[(63)]);
var state_14203__$1 = state_14203;
var statearr_14299_14488 = state_14203__$1;
(statearr_14299_14488[(2)] = inst_14051);

(statearr_14299_14488[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (6))){
var inst_13841 = (state_14203[(78)]);
var inst_13846 = inst_13841.cljs$lang$protocol_mask$partition0$;
var inst_13847 = (inst_13846 & (64));
var inst_13848 = inst_13841.cljs$core$ISeq$;
var inst_13849 = (cljs.core.PROTOCOL_SENTINEL === inst_13848);
var inst_13850 = ((inst_13847) || (inst_13849));
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13850)){
var statearr_14300_14489 = state_14203__$1;
(statearr_14300_14489[(1)] = (9));

} else {
var statearr_14301_14490 = state_14203__$1;
(statearr_14301_14490[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (111))){
var inst_14030 = (state_14203[(11)]);
var inst_14029 = (state_14203[(43)]);
var inst_13997 = (state_14203[(46)]);
var inst_14097 = (state_14203[(13)]);
var inst_14003 = (state_14203[(14)]);
var inst_14146 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_14097,inst_14029,inst_14030,inst_13997,inst_14003);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(119),inst_14146);
} else {
if((state_val_14204 === (28))){
var inst_13895 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14302_14491 = state_14203__$1;
(statearr_14302_14491[(2)] = inst_13895);

(statearr_14302_14491[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (64))){
var state_14203__$1 = state_14203;
var statearr_14303_14492 = state_14203__$1;
(statearr_14303_14492[(2)] = (2147483647));

(statearr_14303_14492[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (103))){
var inst_14070 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14304_14493 = state_14203__$1;
(statearr_14304_14493[(2)] = inst_14070);

(statearr_14304_14493[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (51))){
var inst_13950 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13950)){
var statearr_14305_14494 = state_14203__$1;
(statearr_14305_14494[(1)] = (52));

} else {
var statearr_14306_14495 = state_14203__$1;
(statearr_14306_14495[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (25))){
var inst_13897 = (state_14203[(73)]);
var inst_13897__$1 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14307 = state_14203;
(statearr_14307[(73)] = inst_13897__$1);

return statearr_14307;
})();
if(cljs.core.truth_(inst_13897__$1)){
var statearr_14308_14496 = state_14203__$1;
(statearr_14308_14496[(1)] = (32));

} else {
var statearr_14309_14497 = state_14203__$1;
(statearr_14309_14497[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (34))){
var inst_13915 = (state_14203[(38)]);
var inst_13914 = (state_14203[(45)]);
var inst_13916 = (state_14203[(79)]);
var inst_13914__$1 = (state_14203[(2)]);
var inst_13915__$1 = cljs.core.nth.call(null,inst_13914__$1,(0),null);
var inst_13916__$1 = cljs.core.nth.call(null,inst_13915__$1,(0),null);
var inst_13917 = cljs.core.nth.call(null,inst_13915__$1,(1),null);
var inst_13918 = cljs.core.nth.call(null,inst_13914__$1,(1),null);
var inst_13919 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13916__$1);
var state_14203__$1 = (function (){var statearr_14310 = state_14203;
(statearr_14310[(57)] = inst_13917);

(statearr_14310[(38)] = inst_13915__$1);

(statearr_14310[(45)] = inst_13914__$1);

(statearr_14310[(48)] = inst_13918);

(statearr_14310[(79)] = inst_13916__$1);

return statearr_14310;
})();
if(inst_13919){
var statearr_14311_14498 = state_14203__$1;
(statearr_14311_14498[(1)] = (35));

} else {
var statearr_14312_14499 = state_14203__$1;
(statearr_14312_14499[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (125))){
var inst_14175 = (state_14203[(16)]);
var inst_14183 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14313 = state_14203;
(statearr_14313[(81)] = inst_14183);

return statearr_14313;
})();
if(cljs.core.truth_(inst_14175)){
var statearr_14314_14500 = state_14203__$1;
(statearr_14314_14500[(1)] = (127));

} else {
var statearr_14315_14501 = state_14203__$1;
(statearr_14315_14501[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (17))){
var inst_13835 = (state_14203[(54)]);
var inst_13874 = (state_14203[(2)]);
var inst_13875 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13835);
var state_14203__$1 = (function (){var statearr_14316 = state_14203;
(statearr_14316[(51)] = inst_13874);

return statearr_14316;
})();
if(inst_13875){
var statearr_14317_14502 = state_14203__$1;
(statearr_14317_14502[(1)] = (19));

} else {
var statearr_14318_14503 = state_14203__$1;
(statearr_14318_14503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (3))){
var inst_14201 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14203__$1,inst_14201);
} else {
if((state_val_14204 === (12))){
var inst_13841 = (state_14203[(78)]);
var inst_13859 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13841);
var state_14203__$1 = state_14203;
var statearr_14319_14504 = state_14203__$1;
(statearr_14319_14504[(2)] = inst_13859);

(statearr_14319_14504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (2))){
var inst_13827 = (state_14203[(26)]);
var inst_13834 = (state_14203[(29)]);
var inst_13841 = (state_14203[(78)]);
var _ = (function (){var statearr_14320 = state_14203;
(statearr_14320[(4)] = cljs.core.cons.call(null,(5),(state_14203[(4)])));

return statearr_14320;
})();
var inst_13827__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13828 = cljs.core.nth.call(null,inst_13827__$1,(0),null);
var inst_13829 = cljs.core.nth.call(null,inst_13827__$1,(1),null);
var inst_13830 = cljs.core.nth.call(null,inst_13827__$1,(2),null);
var inst_13831 = cljs.core.nth.call(null,inst_13827__$1,(3),null);
var inst_13832 = cljs.core.nth.call(null,inst_13827__$1,(4),null);
var inst_13833 = cljs.core.nth.call(null,inst_13827__$1,(5),null);
var inst_13834__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13835 = cljs.core.nth.call(null,inst_13834__$1,(0),null);
var inst_13836 = cljs.core.nth.call(null,inst_13834__$1,(1),null);
var inst_13837 = cljs.core.nth.call(null,inst_13834__$1,(2),null);
var inst_13838 = cljs.core.nth.call(null,inst_13834__$1,(3),null);
var inst_13839 = cljs.core.nth.call(null,inst_13834__$1,(4),null);
var inst_13840 = cljs.core.nth.call(null,inst_13834__$1,(5),null);
var inst_13841__$1 = opts;
var inst_13843 = (inst_13841__$1 == null);
var inst_13844 = cljs.core.not.call(null,inst_13843);
var state_14203__$1 = (function (){var statearr_14321 = state_14203;
(statearr_14321[(56)] = inst_13833);

(statearr_14321[(55)] = inst_13837);

(statearr_14321[(23)] = inst_13832);

(statearr_14321[(24)] = inst_13838);

(statearr_14321[(26)] = inst_13827__$1);

(statearr_14321[(29)] = inst_13834__$1);

(statearr_14321[(72)] = inst_13830);

(statearr_14321[(78)] = inst_13841__$1);

(statearr_14321[(65)] = inst_13828);

(statearr_14321[(66)] = inst_13836);

(statearr_14321[(54)] = inst_13835);

(statearr_14321[(44)] = inst_13831);

(statearr_14321[(49)] = inst_13839);

(statearr_14321[(75)] = inst_13840);

(statearr_14321[(76)] = inst_13829);

return statearr_14321;
})();
if(inst_13844){
var statearr_14322_14505 = state_14203__$1;
(statearr_14322_14505[(1)] = (6));

} else {
var statearr_14323_14506 = state_14203__$1;
(statearr_14323_14506[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (66))){
var inst_13970 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14324_14507 = state_14203__$1;
(statearr_14324_14507[(2)] = inst_13970);

(statearr_14324_14507[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (107))){
var inst_14086 = (state_14203[(82)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_14030 = (state_14203[(11)]);
var inst_14029 = (state_14203[(43)]);
var inst_14089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14090 = (inst_14028 - inst_14086);
var inst_14091 = [inst_14090,inst_14029,inst_14030,inst_14031];
var inst_14092 = (new cljs.core.PersistentVector(null,4,(5),inst_14089,inst_14091,null));
var state_14203__$1 = state_14203;
var statearr_14325_14508 = state_14203__$1;
(statearr_14325_14508[(2)] = inst_14092);

(statearr_14325_14508[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (23))){
var inst_13830 = (state_14203[(72)]);
var state_14203__$1 = state_14203;
var statearr_14326_14509 = state_14203__$1;
(statearr_14326_14509[(2)] = inst_13830);

(statearr_14326_14509[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (47))){
var inst_13829 = (state_14203[(76)]);
var state_14203__$1 = state_14203;
var statearr_14327_14510 = state_14203__$1;
(statearr_14327_14510[(2)] = inst_13829);

(statearr_14327_14510[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (35))){
var inst_13916 = (state_14203[(79)]);
var inst_13921 = fluree.db.dbproto._subid.call(null,db,inst_13916);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(38),inst_13921);
} else {
if((state_val_14204 === (127))){
var inst_14183 = (state_14203[(81)]);
var state_14203__$1 = state_14203;
var statearr_14328_14511 = state_14203__$1;
(statearr_14328_14511[(2)] = inst_14183);

(statearr_14328_14511[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (82))){
var state_14203__$1 = state_14203;
var statearr_14329_14512 = state_14203__$1;
(statearr_14329_14512[(2)] = null);

(statearr_14329_14512[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (76))){
var inst_13998 = (state_14203[(70)]);
var state_14203__$1 = state_14203;
var statearr_14330_14513 = state_14203__$1;
(statearr_14330_14513[(2)] = inst_13998);

(statearr_14330_14513[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (97))){
var inst_14027 = (state_14203[(18)]);
var inst_14004 = (state_14203[(20)]);
var inst_14063 = (state_14203[(2)]);
var inst_14064 = fluree.db.dbproto._rhs.call(null,inst_14027);
var state_14203__$1 = (function (){var statearr_14331 = state_14203;
(statearr_14331[(64)] = inst_14063);

(statearr_14331[(7)] = inst_14064);

return statearr_14331;
})();
if(cljs.core.truth_(inst_14004)){
var statearr_14332_14514 = state_14203__$1;
(statearr_14332_14514[(1)] = (98));

} else {
var statearr_14333_14515 = state_14203__$1;
(statearr_14333_14515[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (19))){
var inst_13835 = (state_14203[(54)]);
var inst_13877 = fluree.db.dbproto._subid.call(null,db,inst_13835);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(22),inst_13877);
} else {
if((state_val_14204 === (57))){
var inst_13840 = (state_14203[(75)]);
var inst_13963 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14334 = state_14203;
(statearr_14334[(40)] = inst_13963);

return statearr_14334;
})();
if(cljs.core.truth_(inst_13840)){
var statearr_14335_14516 = state_14203__$1;
(statearr_14335_14516[(1)] = (61));

} else {
var statearr_14336_14517 = state_14203__$1;
(statearr_14336_14517[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (68))){
var state_14203__$1 = state_14203;
var statearr_14337_14518 = state_14203__$1;
(statearr_14337_14518[(2)] = false);

(statearr_14337_14518[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (11))){
var inst_13854 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14338_14519 = state_14203__$1;
(statearr_14338_14519[(2)] = inst_13854);

(statearr_14338_14519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (115))){
var inst_14123 = (state_14203[(67)]);
var inst_14029 = (state_14203[(43)]);
var inst_13997 = (state_14203[(46)]);
var inst_14125 = (state_14203[(68)]);
var inst_14097 = (state_14203[(13)]);
var inst_14124 = (state_14203[(69)]);
var inst_14119 = (state_14203[(2)]);
var inst_14120 = cljs.core.nth.call(null,inst_14119,(0),null);
var inst_14121 = cljs.core.nth.call(null,inst_14119,(1),null);
var inst_14122 = cljs.core.take.call(null,inst_14121,inst_14097);
var inst_14123__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_14122);
var inst_14124__$1 = cljs.core.count.call(null,inst_14123__$1);
var inst_14125__$1 = (inst_14029 + inst_14124__$1);
var inst_14126 = (inst_14125__$1 > inst_13997);
var state_14203__$1 = (function (){var statearr_14340 = state_14203;
(statearr_14340[(67)] = inst_14123__$1);

(statearr_14340[(80)] = inst_14120);

(statearr_14340[(68)] = inst_14125__$1);

(statearr_14340[(69)] = inst_14124__$1);

return statearr_14340;
})();
if(cljs.core.truth_(inst_14126)){
var statearr_14341_14520 = state_14203__$1;
(statearr_14341_14520[(1)] = (116));

} else {
var statearr_14342_14521 = state_14203__$1;
(statearr_14342_14521[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (9))){
var state_14203__$1 = state_14203;
var statearr_14343_14522 = state_14203__$1;
(statearr_14343_14522[(2)] = true);

(statearr_14343_14522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (5))){
var _ = (function (){var statearr_14344 = state_14203;
(statearr_14344[(4)] = cljs.core.rest.call(null,(state_14203[(4)])));

return statearr_14344;
})();
var state_14203__$1 = state_14203;
var ex14339 = (state_14203__$1[(2)]);
var statearr_14345_14523 = state_14203__$1;
(statearr_14345_14523[(5)] = ex14339);


if((ex14339 instanceof Error)){
var statearr_14346_14524 = state_14203__$1;
(statearr_14346_14524[(1)] = (4));

(statearr_14346_14524[(5)] = null);

} else {
throw ex14339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (112))){
var inst_14031 = (state_14203[(28)]);
var inst_14151 = (state_14203[(2)]);
var inst_14152 = cljs.core.nth.call(null,inst_14151,(0),null);
var inst_14153 = cljs.core.nth.call(null,inst_14151,(1),null);
var inst_14154 = cljs.core.nth.call(null,inst_14151,(2),null);
var inst_14155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14156 = cljs.core.into.call(null,inst_14031,inst_14154);
var inst_14157 = [(0),inst_14152,inst_14153,inst_14156];
var inst_14158 = (new cljs.core.PersistentVector(null,4,(5),inst_14155,inst_14157,null));
var state_14203__$1 = state_14203;
var statearr_14347_14525 = state_14203__$1;
(statearr_14347_14525[(2)] = inst_14158);

(statearr_14347_14525[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (83))){
var inst_14198 = (state_14203[(2)]);
var _ = (function (){var statearr_14348 = state_14203;
(statearr_14348[(4)] = cljs.core.rest.call(null,(state_14203[(4)])));

return statearr_14348;
})();
var state_14203__$1 = state_14203;
var statearr_14349_14526 = state_14203__$1;
(statearr_14349_14526[(2)] = inst_14198);

(statearr_14349_14526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (14))){
var inst_13862 = (state_14203[(30)]);
var inst_13828 = (state_14203[(65)]);
var inst_13862__$1 = (state_14203[(2)]);
var inst_13863 = cljs.core.get.call(null,inst_13862__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_13864 = cljs.core.get.call(null,inst_13862__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_13865 = cljs.core.get.call(null,inst_13862__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_13866 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13828);
var state_14203__$1 = (function (){var statearr_14350 = state_14203;
(statearr_14350[(30)] = inst_13862__$1);

(statearr_14350[(33)] = inst_13864);

(statearr_14350[(37)] = inst_13863);

(statearr_14350[(74)] = inst_13865);

return statearr_14350;
})();
if(inst_13866){
var statearr_14351_14527 = state_14203__$1;
(statearr_14351_14527[(1)] = (15));

} else {
var statearr_14352_14528 = state_14203__$1;
(statearr_14352_14528[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (45))){
var inst_13941 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13941)){
var statearr_14353_14529 = state_14203__$1;
(statearr_14353_14529[(1)] = (46));

} else {
var statearr_14354_14530 = state_14203__$1;
(statearr_14354_14530[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (53))){
var inst_13836 = (state_14203[(66)]);
var state_14203__$1 = state_14203;
var statearr_14355_14531 = state_14203__$1;
(statearr_14355_14531[(2)] = inst_13836);

(statearr_14355_14531[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (78))){
var inst_14003 = (state_14203[(14)]);
var inst_14003__$1 = (state_14203[(2)]);
var inst_14004 = cljs.core._EQ_.call(null,inst_14003__$1,fluree.db.util.core.max_long);
var inst_14005 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14007 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14008 = (new cljs.core.PersistentVector(null,3,(5),inst_14006,inst_14007,null));
var inst_14009 = cljs.core.get_in.call(null,db,inst_14008);
var inst_14010 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14012 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14013 = (new cljs.core.PersistentVector(null,2,(5),inst_14011,inst_14012,null));
var inst_14014 = cljs.core.get_in.call(null,db,inst_14013);
var inst_14015 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14016 = cljs.core.get.call(null,db,idx);
var inst_14017 = fluree.db.dbproto._resolve.call(null,inst_14016);
var state_14203__$1 = (function (){var statearr_14356 = state_14203;
(statearr_14356[(20)] = inst_14004);

(statearr_14356[(21)] = inst_14014);

(statearr_14356[(25)] = inst_14009);

(statearr_14356[(31)] = inst_14010);

(statearr_14356[(35)] = inst_14005);

(statearr_14356[(36)] = inst_14015);

(statearr_14356[(14)] = inst_14003__$1);

return statearr_14356;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(79),inst_14017);
} else {
if((state_val_14204 === (132))){
var inst_14193 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
var statearr_14357_14532 = state_14203__$1;
(statearr_14357_14532[(2)] = inst_14193);

(statearr_14357_14532[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (26))){
var inst_13837 = (state_14203[(55)]);
var state_14203__$1 = state_14203;
var statearr_14358_14533 = state_14203__$1;
(statearr_14358_14533[(2)] = inst_13837);

(statearr_14358_14533[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (123))){
var inst_14014 = (state_14203[(21)]);
var inst_14010 = (state_14203[(31)]);
var inst_14015 = (state_14203[(36)]);
var inst_14020 = (state_14203[(47)]);
var inst_14064 = (state_14203[(7)]);
var inst_14177 = fluree.db.query.range.find_next_valid_node.call(null,inst_14020,inst_14064,inst_14010,inst_14014,inst_14015);
var state_14203__$1 = state_14203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(126),inst_14177);
} else {
if((state_val_14204 === (16))){
var inst_13828 = (state_14203[(65)]);
var state_14203__$1 = state_14203;
var statearr_14359_14534 = state_14203__$1;
(statearr_14359_14534[(2)] = inst_13828);

(statearr_14359_14534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (81))){
var inst_14024 = (state_14203[(39)]);
var inst_13999 = (state_14203[(71)]);
var inst_14026 = cljs.core.PersistentVector.EMPTY;
var inst_14027 = inst_14024;
var inst_14028 = inst_13999;
var inst_14029 = (0);
var inst_14030 = (0);
var inst_14031 = inst_14026;
var state_14203__$1 = (function (){var statearr_14360 = state_14203;
(statearr_14360[(18)] = inst_14027);

(statearr_14360[(27)] = inst_14028);

(statearr_14360[(28)] = inst_14031);

(statearr_14360[(11)] = inst_14030);

(statearr_14360[(43)] = inst_14029);

return statearr_14360;
})();
var statearr_14361_14535 = state_14203__$1;
(statearr_14361_14535[(2)] = null);

(statearr_14361_14535[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (120))){
var inst_14009 = (state_14203[(25)]);
var inst_13974 = (state_14203[(34)]);
var inst_13997 = (state_14203[(46)]);
var inst_14165 = (state_14203[(60)]);
var inst_14164 = (state_14203[(61)]);
var inst_14064 = (state_14203[(7)]);
var inst_14003 = (state_14203[(14)]);
var inst_14168 = inst_14009.call(null,inst_14064,inst_13974);
var inst_14169 = (inst_14168 < (0));
var inst_14170 = (inst_14164 < inst_13997);
var inst_14171 = (inst_14165 < inst_14003);
var inst_14172 = ((inst_14169) && (inst_14170) && (inst_14171));
var state_14203__$1 = state_14203;
var statearr_14362_14536 = state_14203__$1;
(statearr_14362_14536[(2)] = inst_14172);

(statearr_14362_14536[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (79))){
var inst_14014 = (state_14203[(21)]);
var inst_13973 = (state_14203[(22)]);
var inst_14010 = (state_14203[(31)]);
var inst_14015 = (state_14203[(36)]);
var inst_14020 = (state_14203[(47)]);
var inst_14019 = (state_14203[(2)]);
var inst_14020__$1 = fluree.db.util.async.throw_err.call(null,inst_14019);
var inst_14021 = fluree.db.query.range.find_next_valid_node.call(null,inst_14020__$1,inst_13973,inst_14010,inst_14014,inst_14015);
var state_14203__$1 = (function (){var statearr_14363 = state_14203;
(statearr_14363[(47)] = inst_14020__$1);

return statearr_14363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14203__$1,(80),inst_14021);
} else {
if((state_val_14204 === (38))){
var inst_13923 = (state_14203[(2)]);
var inst_13924 = fluree.db.util.async.throw_err.call(null,inst_13923);
var state_14203__$1 = state_14203;
var statearr_14364_14537 = state_14203__$1;
(statearr_14364_14537[(2)] = inst_13924);

(statearr_14364_14537[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (126))){
var inst_14179 = (state_14203[(2)]);
var inst_14180 = fluree.db.util.async.throw_err.call(null,inst_14179);
var state_14203__$1 = state_14203;
var statearr_14365_14538 = state_14203__$1;
(statearr_14365_14538[(2)] = inst_14180);

(statearr_14365_14538[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (98))){
var inst_14028 = (state_14203[(27)]);
var inst_14066 = cljs.core._EQ_.call(null,(0),inst_14028);
var state_14203__$1 = state_14203;
if(inst_14066){
var statearr_14366_14539 = state_14203__$1;
(statearr_14366_14539[(1)] = (101));

} else {
var statearr_14367_14540 = state_14203__$1;
(statearr_14367_14540[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (124))){
var state_14203__$1 = state_14203;
var statearr_14368_14541 = state_14203__$1;
(statearr_14368_14541[(2)] = null);

(statearr_14368_14541[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (87))){
var inst_14037 = (state_14203[(52)]);
var state_14203__$1 = state_14203;
var statearr_14369_14542 = state_14203__$1;
(statearr_14369_14542[(2)] = inst_14037);

(statearr_14369_14542[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (30))){
var state_14203__$1 = state_14203;
var statearr_14370_14543 = state_14203__$1;
(statearr_14370_14543[(2)] = null);

(statearr_14370_14543[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (73))){
var inst_13975 = (state_14203[(8)]);
var inst_13993 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13975);
var state_14203__$1 = state_14203;
var statearr_14371_14544 = state_14203__$1;
(statearr_14371_14544[(2)] = inst_13993);

(statearr_14371_14544[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (96))){
var inst_14057 = (state_14203[(62)]);
var state_14203__$1 = state_14203;
var statearr_14372_14545 = state_14203__$1;
(statearr_14372_14545[(2)] = inst_14057);

(statearr_14372_14545[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (10))){
var state_14203__$1 = state_14203;
var statearr_14373_14546 = state_14203__$1;
(statearr_14373_14546[(2)] = false);

(statearr_14373_14546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (18))){
var inst_13870 = (state_14203[(2)]);
var inst_13871 = fluree.db.util.async.throw_err.call(null,inst_13870);
var state_14203__$1 = state_14203;
var statearr_14374_14547 = state_14203__$1;
(statearr_14374_14547[(2)] = inst_13871);

(statearr_14374_14547[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (105))){
var inst_13936 = (state_14203[(17)]);
var inst_14027 = (state_14203[(18)]);
var inst_14085 = (state_14203[(77)]);
var inst_13883 = (state_14203[(19)]);
var inst_14004 = (state_14203[(20)]);
var inst_14014 = (state_14203[(21)]);
var inst_14086 = (state_14203[(82)]);
var inst_13973 = (state_14203[(22)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_14009 = (state_14203[(25)]);
var inst_13827 = (state_14203[(26)]);
var inst_14028 = (state_14203[(27)]);
var inst_14031 = (state_14203[(28)]);
var inst_13834 = (state_14203[(29)]);
var inst_13862 = (state_14203[(30)]);
var inst_14010 = (state_14203[(31)]);
var inst_13954 = (state_14203[(32)]);
var inst_13864 = (state_14203[(33)]);
var inst_13974 = (state_14203[(34)]);
var inst_14030 = (state_14203[(11)]);
var inst_14005 = (state_14203[(35)]);
var inst_14015 = (state_14203[(36)]);
var inst_13863 = (state_14203[(37)]);
var inst_13915 = (state_14203[(38)]);
var inst_14024 = (state_14203[(39)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_14063 = (state_14203[(64)]);
var inst_14029 = (state_14203[(43)]);
var inst_13831 = (state_14203[(44)]);
var inst_13914 = (state_14203[(45)]);
var inst_13997 = (state_14203[(46)]);
var inst_14020 = (state_14203[(47)]);
var inst_13918 = (state_14203[(48)]);
var inst_13839 = (state_14203[(49)]);
var inst_13996 = (state_14203[(50)]);
var inst_13874 = (state_14203[(51)]);
var inst_14064 = (state_14203[(7)]);
var inst_14037 = (state_14203[(52)]);
var inst_13927 = (state_14203[(53)]);
var inst_14003 = (state_14203[(14)]);
var inst_14084 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_14063;
var t = inst_14010;
var max_limit_QMARK_ = inst_14004;
var next_node = inst_14027;
var fast_forward_db_QMARK_ = inst_14015;
var s1 = inst_13874;
var o2 = inst_13936;
var t1 = inst_13831;
var predicate_fn = inst_13864;
var i = inst_14029;
var rhs = inst_14064;
var m1 = inst_13963;
var root_node = inst_14020;
var s2 = inst_13883;
var vec__13820 = inst_13914;
var p2 = inst_13954;
var permissions = inst_14005;
var limit = inst_14003;
var start_flake = inst_13973;
var map__13826 = inst_13996;
var flake_limit = inst_13997;
var offset = inst_14028;
var vec__13823 = inst_13915;
var acc = inst_14031;
var t2 = inst_13838;
var op1 = inst_13832;
var o1 = inst_13927;
var map__13819 = inst_13862;
var end_flake = inst_13974;
var base_result = inst_14037;
var s = inst_14030;
var node_start = inst_14024;
var p1 = inst_13945;
var subject_fn = inst_13863;
var vec__13813 = inst_13827;
var vec__13816 = inst_13834;
var object_fn = inst_13918;
var idx_compare = inst_14009;
var op2 = inst_13839;
var m2 = inst_13972;
var novelty = inst_14014;
return (function (p1__13798_SHARP_){
return p1__13798_SHARP_.s;
});
})();
var inst_14085__$1 = cljs.core.partition_by.call(null,inst_14084,inst_14063);
var inst_14086__$1 = cljs.core.count.call(null,inst_14085__$1);
var inst_14087 = (inst_14028 > inst_14086__$1);
var state_14203__$1 = (function (){var statearr_14375 = state_14203;
(statearr_14375[(77)] = inst_14085__$1);

(statearr_14375[(82)] = inst_14086__$1);

return statearr_14375;
})();
if(cljs.core.truth_(inst_14087)){
var statearr_14376_14548 = state_14203__$1;
(statearr_14376_14548[(1)] = (107));

} else {
var statearr_14377_14549 = state_14203__$1;
(statearr_14377_14549[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (52))){
var state_14203__$1 = state_14203;
var statearr_14378_14550 = state_14203__$1;
(statearr_14378_14550[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14378_14550[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (114))){
var inst_14106 = (state_14203[(12)]);
var inst_14115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14116 = [inst_14106,inst_14106];
var inst_14117 = (new cljs.core.PersistentVector(null,2,(5),inst_14115,inst_14116,null));
var state_14203__$1 = state_14203;
var statearr_14379_14551 = state_14203__$1;
(statearr_14379_14551[(2)] = inst_14117);

(statearr_14379_14551[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (67))){
var inst_13975 = (state_14203[(8)]);
var inst_13980 = inst_13975.cljs$lang$protocol_mask$partition0$;
var inst_13981 = (inst_13980 & (64));
var inst_13982 = inst_13975.cljs$core$ISeq$;
var inst_13983 = (cljs.core.PROTOCOL_SENTINEL === inst_13982);
var inst_13984 = ((inst_13981) || (inst_13983));
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13984)){
var statearr_14380_14552 = state_14203__$1;
(statearr_14380_14552[(1)] = (70));

} else {
var statearr_14381_14553 = state_14203__$1;
(statearr_14381_14553[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (71))){
var state_14203__$1 = state_14203;
var statearr_14382_14554 = state_14203__$1;
(statearr_14382_14554[(2)] = false);

(statearr_14382_14554[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (42))){
var inst_13932 = (state_14203[(2)]);
var inst_13933 = fluree.db.util.async.throw_err.call(null,inst_13932);
var state_14203__$1 = state_14203;
var statearr_14383_14555 = state_14203__$1;
(statearr_14383_14555[(2)] = inst_13933);

(statearr_14383_14555[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (80))){
var inst_14024 = (state_14203[(39)]);
var inst_14023 = (state_14203[(2)]);
var inst_14024__$1 = fluree.db.util.async.throw_err.call(null,inst_14023);
var state_14203__$1 = (function (){var statearr_14384 = state_14203;
(statearr_14384[(39)] = inst_14024__$1);

return statearr_14384;
})();
if(cljs.core.truth_(inst_14024__$1)){
var statearr_14385_14556 = state_14203__$1;
(statearr_14385_14556[(1)] = (81));

} else {
var statearr_14386_14557 = state_14203__$1;
(statearr_14386_14557[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (37))){
var inst_13917 = (state_14203[(57)]);
var inst_13927 = (state_14203[(2)]);
var inst_13928 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13917);
var state_14203__$1 = (function (){var statearr_14387 = state_14203;
(statearr_14387[(53)] = inst_13927);

return statearr_14387;
})();
if(inst_13928){
var statearr_14388_14558 = state_14203__$1;
(statearr_14388_14558[(1)] = (39));

} else {
var statearr_14389_14559 = state_14203__$1;
(statearr_14389_14559[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (63))){
var inst_13936 = (state_14203[(17)]);
var inst_13883 = (state_14203[(19)]);
var inst_13832 = (state_14203[(23)]);
var inst_13838 = (state_14203[(24)]);
var inst_13975 = (state_14203[(8)]);
var inst_13954 = (state_14203[(32)]);
var inst_13963 = (state_14203[(40)]);
var inst_13972 = (state_14203[(41)]);
var inst_13945 = (state_14203[(42)]);
var inst_13831 = (state_14203[(44)]);
var inst_13839 = (state_14203[(49)]);
var inst_13874 = (state_14203[(51)]);
var inst_13927 = (state_14203[(53)]);
var inst_13972__$1 = (state_14203[(2)]);
var inst_13973 = fluree.db.flake.__GT_Flake.call(null,inst_13874,inst_13945,inst_13927,inst_13831,inst_13832,inst_13963);
var inst_13974 = fluree.db.flake.__GT_Flake.call(null,inst_13883,inst_13954,inst_13936,inst_13838,inst_13839,inst_13972__$1);
var inst_13975__$1 = opts;
var inst_13977 = (inst_13975__$1 == null);
var inst_13978 = cljs.core.not.call(null,inst_13977);
var state_14203__$1 = (function (){var statearr_14390 = state_14203;
(statearr_14390[(22)] = inst_13973);

(statearr_14390[(8)] = inst_13975__$1);

(statearr_14390[(34)] = inst_13974);

(statearr_14390[(41)] = inst_13972__$1);

return statearr_14390;
})();
if(inst_13978){
var statearr_14391_14560 = state_14203__$1;
(statearr_14391_14560[(1)] = (67));

} else {
var statearr_14392_14561 = state_14203__$1;
(statearr_14392_14561[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (94))){
var inst_13918 = (state_14203[(48)]);
var inst_14057 = (state_14203[(2)]);
var state_14203__$1 = (function (){var statearr_14393 = state_14203;
(statearr_14393[(62)] = inst_14057);

return statearr_14393;
})();
if(cljs.core.truth_(inst_13918)){
var statearr_14394_14562 = state_14203__$1;
(statearr_14394_14562[(1)] = (95));

} else {
var statearr_14395_14563 = state_14203__$1;
(statearr_14395_14563[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (8))){
var inst_13857 = (state_14203[(2)]);
var state_14203__$1 = state_14203;
if(cljs.core.truth_(inst_13857)){
var statearr_14396_14564 = state_14203__$1;
(statearr_14396_14564[(1)] = (12));

} else {
var statearr_14397_14565 = state_14203__$1;
(statearr_14397_14565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (49))){
var inst_13936 = (state_14203[(17)]);
var state_14203__$1 = state_14203;
var statearr_14398_14566 = state_14203__$1;
(statearr_14398_14566[(2)] = inst_13936);

(statearr_14398_14566[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14204 === (84))){
var inst_14027 = (state_14203[(18)]);
var inst_13973 = (state_14203[(22)]);
var inst_13974 = (state_14203[(34)]);
var inst_14036 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14027);
var inst_14037 = fluree.db.flake.subrange.call(null,inst_14036,start_test,inst_13973,end_test,inst_13974);
var inst_14039 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13973,inst_13974);
var state_14203__$1 = (function (){var statearr_14399 = state_14203;
(statearr_14399[(52)] = inst_14037);

return statearr_14399;
})();
if(inst_14039){
var statearr_14400_14567 = state_14203__$1;
(statearr_14400_14567[(1)] = (86));

} else {
var statearr_14401_14568 = state_14203__$1;
(statearr_14401_14568[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2454__auto__ = null;
var fluree$db$query$range$state_machine__2454__auto____0 = (function (){
var statearr_14402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14402[(0)] = fluree$db$query$range$state_machine__2454__auto__);

(statearr_14402[(1)] = (1));

return statearr_14402;
});
var fluree$db$query$range$state_machine__2454__auto____1 = (function (state_14203){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_14203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e14403){var ex__2457__auto__ = e14403;
var statearr_14404_14569 = state_14203;
(statearr_14404_14569[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_14203[(4)]))){
var statearr_14405_14570 = state_14203;
(statearr_14405_14570[(1)] = cljs.core.first.call(null,(state_14203[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14571 = state_14203;
state_14203 = G__14571;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2454__auto__ = function(state_14203){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2454__auto____1.call(this,state_14203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2454__auto____0;
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2454__auto____1;
return fluree$db$query$range$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_14406 = f__2477__auto__.call(null);
(statearr_14406[(6)] = c__2476__auto__);

return statearr_14406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_14627){
var state_val_14628 = (state_14627[(1)]);
if((state_val_14628 === (7))){
var inst_14601 = (state_14627[(7)]);
var inst_14591 = (state_14627[(8)]);
var inst_14599 = fluree.db.flake.Flake__GT_parts.call(null,inst_14591);
var inst_14600 = cljs.core.nth.call(null,inst_14599,(0),null);
var inst_14601__$1 = cljs.core.nth.call(null,inst_14599,(1),null);
var inst_14602 = cljs.core.nth.call(null,inst_14599,(2),null);
var inst_14603 = cljs.core.nth.call(null,inst_14599,(3),null);
var inst_14604 = cljs.core.nth.call(null,inst_14599,(4),null);
var inst_14605 = cljs.core.nth.call(null,inst_14599,(5),null);
var inst_14606 = fluree.db.dbproto._tag.call(null,db,inst_14602,inst_14601__$1);
var state_14627__$1 = (function (){var statearr_14629 = state_14627;
(statearr_14629[(7)] = inst_14601__$1);

(statearr_14629[(9)] = inst_14604);

(statearr_14629[(10)] = inst_14603);

(statearr_14629[(11)] = inst_14600);

(statearr_14629[(12)] = inst_14605);

return statearr_14629;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14627__$1,(10),inst_14606);
} else {
if((state_val_14628 === (1))){
var inst_14579 = flakes;
var inst_14580 = cljs.core.seq.call(null,inst_14579);
var inst_14581 = cljs.core.first.call(null,inst_14580);
var inst_14582 = cljs.core.next.call(null,inst_14580);
var inst_14583 = cljs.core.PersistentVector.EMPTY;
var inst_14584 = inst_14579;
var inst_14585 = inst_14583;
var state_14627__$1 = (function (){var statearr_14630 = state_14627;
(statearr_14630[(13)] = inst_14584);

(statearr_14630[(14)] = inst_14581);

(statearr_14630[(15)] = inst_14585);

(statearr_14630[(16)] = inst_14582);

return statearr_14630;
})();
var statearr_14631_14649 = state_14627__$1;
(statearr_14631_14649[(2)] = null);

(statearr_14631_14649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (4))){
var inst_14591 = (state_14627[(8)]);
var inst_14594 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_14591);
var state_14627__$1 = state_14627;
if(inst_14594){
var statearr_14632_14650 = state_14627__$1;
(statearr_14632_14650[(1)] = (7));

} else {
var statearr_14633_14651 = state_14627__$1;
(statearr_14633_14651[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (6))){
var inst_14623 = (state_14627[(2)]);
var state_14627__$1 = state_14627;
var statearr_14634_14652 = state_14627__$1;
(statearr_14634_14652[(2)] = inst_14623);

(statearr_14634_14652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (3))){
var inst_14625 = (state_14627[(2)]);
var state_14627__$1 = state_14627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14627__$1,inst_14625);
} else {
if((state_val_14628 === (2))){
var inst_14584 = (state_14627[(13)]);
var inst_14591 = (state_14627[(8)]);
var inst_14590 = cljs.core.seq.call(null,inst_14584);
var inst_14591__$1 = cljs.core.first.call(null,inst_14590);
var inst_14592 = cljs.core.next.call(null,inst_14590);
var state_14627__$1 = (function (){var statearr_14635 = state_14627;
(statearr_14635[(17)] = inst_14592);

(statearr_14635[(8)] = inst_14591__$1);

return statearr_14635;
})();
if(cljs.core.truth_(inst_14591__$1)){
var statearr_14636_14653 = state_14627__$1;
(statearr_14636_14653[(1)] = (4));

} else {
var statearr_14637_14654 = state_14627__$1;
(statearr_14637_14654[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (9))){
var inst_14620 = (state_14627[(2)]);
var state_14627__$1 = state_14627;
var statearr_14638_14655 = state_14627__$1;
(statearr_14638_14655[(2)] = inst_14620);

(statearr_14638_14655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (5))){
var inst_14585 = (state_14627[(15)]);
var state_14627__$1 = state_14627;
var statearr_14639_14656 = state_14627__$1;
(statearr_14639_14656[(2)] = inst_14585);

(statearr_14639_14656[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (10))){
var inst_14592 = (state_14627[(17)]);
var inst_14601 = (state_14627[(7)]);
var inst_14604 = (state_14627[(9)]);
var inst_14603 = (state_14627[(10)]);
var inst_14600 = (state_14627[(11)]);
var inst_14605 = (state_14627[(12)]);
var inst_14585 = (state_14627[(15)]);
var inst_14608 = (state_14627[(2)]);
var inst_14609 = fluree.db.util.async.throw_err.call(null,inst_14608);
var inst_14610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14611 = [inst_14600,inst_14601,inst_14609,inst_14603,inst_14604,inst_14605];
var inst_14612 = (new cljs.core.PersistentVector(null,6,(5),inst_14610,inst_14611,null));
var inst_14613 = fluree.db.flake.parts__GT_Flake.call(null,inst_14612);
var inst_14614 = cljs.core.conj.call(null,inst_14585,inst_14613);
var inst_14584 = inst_14592;
var inst_14585__$1 = inst_14614;
var state_14627__$1 = (function (){var statearr_14640 = state_14627;
(statearr_14640[(13)] = inst_14584);

(statearr_14640[(15)] = inst_14585__$1);

return statearr_14640;
})();
var statearr_14641_14657 = state_14627__$1;
(statearr_14641_14657[(2)] = null);

(statearr_14641_14657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (8))){
var inst_14592 = (state_14627[(17)]);
var inst_14591 = (state_14627[(8)]);
var inst_14585 = (state_14627[(15)]);
var inst_14617 = cljs.core.conj.call(null,inst_14585,inst_14591);
var inst_14584 = inst_14592;
var inst_14585__$1 = inst_14617;
var state_14627__$1 = (function (){var statearr_14642 = state_14627;
(statearr_14642[(13)] = inst_14584);

(statearr_14642[(15)] = inst_14585__$1);

return statearr_14642;
})();
var statearr_14643_14658 = state_14627__$1;
(statearr_14643_14658[(2)] = null);

(statearr_14643_14658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____0 = (function (){
var statearr_14644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14644[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__);

(statearr_14644[(1)] = (1));

return statearr_14644;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____1 = (function (state_14627){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_14627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e14645){var ex__2457__auto__ = e14645;
var statearr_14646_14659 = state_14627;
(statearr_14646_14659[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_14627[(4)]))){
var statearr_14647_14660 = state_14627;
(statearr_14647_14660[(1)] = cljs.core.first.call(null,(state_14627[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14661 = state_14627;
state_14627 = G__14661;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__ = function(state_14627){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____1.call(this,state_14627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_14648 = f__2477__auto__.call(null);
(statearr_14648[(6)] = c__2476__auto__);

return statearr_14648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14663 = arguments.length;
switch (G__14663) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_14814){
var state_val_14815 = (state_14814[(1)]);
if((state_val_14815 === (62))){
var inst_14801 = (state_14814[(7)]);
var state_14814__$1 = state_14814;
var statearr_14816_14905 = state_14814__$1;
(statearr_14816_14905[(2)] = inst_14801);

(statearr_14816_14905[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (7))){
var state_14814__$1 = state_14814;
var statearr_14817_14906 = state_14814__$1;
(statearr_14817_14906[(2)] = false);

(statearr_14817_14906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (59))){
var inst_14793 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14818_14907 = state_14814__$1;
(statearr_14818_14907[(2)] = inst_14793);

(statearr_14818_14907[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (20))){
var state_14814__$1 = state_14814;
var statearr_14819_14908 = state_14814__$1;
(statearr_14819_14908[(2)] = null);

(statearr_14819_14908[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (58))){
var state_14814__$1 = state_14814;
var statearr_14820_14909 = state_14814__$1;
(statearr_14820_14909[(2)] = null);

(statearr_14820_14909[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (60))){
var inst_14789 = (state_14814[(2)]);
var inst_14790 = fluree.db.util.async.throw_err.call(null,inst_14789);
var state_14814__$1 = state_14814;
var statearr_14821_14910 = state_14814__$1;
(statearr_14821_14910[(2)] = inst_14790);

(statearr_14821_14910[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (27))){
var inst_14714 = (state_14814[(8)]);
var inst_14725 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_14714);
var state_14814__$1 = state_14814;
if(inst_14725){
var statearr_14822_14911 = state_14814__$1;
(statearr_14822_14911[(1)] = (30));

} else {
var statearr_14823_14912 = state_14814__$1;
(statearr_14823_14912[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (1))){
var state_14814__$1 = state_14814;
var statearr_14824_14913 = state_14814__$1;
(statearr_14824_14913[(2)] = null);

(statearr_14824_14913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (24))){
var inst_14675 = (state_14814[(9)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14675)){
var statearr_14825_14914 = state_14814__$1;
(statearr_14825_14914[(1)] = (27));

} else {
var statearr_14826_14915 = state_14814__$1;
(statearr_14826_14915[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (55))){
var inst_14795 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14827_14916 = state_14814__$1;
(statearr_14827_14916[(2)] = inst_14795);

(statearr_14827_14916[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (39))){
var inst_14745 = (state_14814[(2)]);
var inst_14746 = fluree.db.util.async.throw_err.call(null,inst_14745);
var state_14814__$1 = state_14814;
var statearr_14828_14917 = state_14814__$1;
(statearr_14828_14917[(2)] = inst_14746);

(statearr_14828_14917[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (46))){
var inst_14758 = (state_14814[(10)]);
var inst_14758__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14814__$1 = (function (){var statearr_14829 = state_14814;
(statearr_14829[(10)] = inst_14758__$1);

return statearr_14829;
})();
if(cljs.core.truth_(inst_14758__$1)){
var statearr_14830_14918 = state_14814__$1;
(statearr_14830_14918[(1)] = (49));

} else {
var statearr_14831_14919 = state_14814__$1;
(statearr_14831_14919[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (4))){
var inst_14664 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14832_14920 = state_14814__$1;
(statearr_14832_14920[(2)] = inst_14664);

(statearr_14832_14920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (54))){
var inst_14714 = (state_14814[(8)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14714)){
var statearr_14833_14921 = state_14814__$1;
(statearr_14833_14921[(1)] = (57));

} else {
var statearr_14834_14922 = state_14814__$1;
(statearr_14834_14922[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (15))){
var inst_14676 = (state_14814[(11)]);
var inst_14695 = fluree.db.dbproto._tag_id.call(null,db,inst_14676);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(18),inst_14695);
} else {
if((state_val_14815 === (48))){
var inst_14797 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14835_14923 = state_14814__$1;
(statearr_14835_14923[(2)] = inst_14797);

(statearr_14835_14923[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (50))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14684 = (state_14814[(13)]);
var inst_14677 = (state_14814[(14)]);
var inst_14678 = (state_14814[(15)]);
var inst_14714 = (state_14814[(8)]);
var inst_14689 = (state_14814[(16)]);
var inst_14758 = (state_14814[(10)]);
var inst_14673 = (state_14814[(17)]);
var inst_14762 = (function (){var t = inst_14677;
var temp__5733__auto__ = inst_14758;
var p = inst_14675;
var vec__14670 = inst_14673;
var idx_predicate_QMARK_ = inst_14678;
var o = inst_14714;
var tag_predicate_QMARK_ = inst_14684;
var s = inst_14674;
var o_coerce_QMARK_ = inst_14689;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_14814__$1 = state_14814;
var statearr_14836_14924 = state_14814__$1;
(statearr_14836_14924[(2)] = inst_14762);

(statearr_14836_14924[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (21))){
var inst_14710 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14837_14925 = state_14814__$1;
(statearr_14837_14925[(2)] = inst_14710);

(statearr_14837_14925[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (31))){
var state_14814__$1 = state_14814;
var statearr_14838_14926 = state_14814__$1;
(statearr_14838_14926[(2)] = false);

(statearr_14838_14926[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (32))){
var inst_14735 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14839_14927 = state_14814__$1;
(statearr_14839_14927[(2)] = inst_14735);

(statearr_14839_14927[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (40))){
var inst_14678 = (state_14814[(15)]);
var inst_14749 = cljs.core.not.call(null,inst_14678);
var state_14814__$1 = state_14814;
if(inst_14749){
var statearr_14840_14928 = state_14814__$1;
(statearr_14840_14928[(1)] = (43));

} else {
var statearr_14841_14929 = state_14814__$1;
(statearr_14841_14929[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (56))){
var inst_14780 = (state_14814[(2)]);
var inst_14781 = fluree.db.util.async.throw_err.call(null,inst_14780);
var state_14814__$1 = state_14814;
var statearr_14842_14930 = state_14814__$1;
(statearr_14842_14930[(2)] = inst_14781);

(statearr_14842_14930[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (33))){
var inst_14714 = (state_14814[(8)]);
var inst_14728 = cljs.core.fn_QMARK_.call(null,inst_14714);
var inst_14729 = (!(inst_14728));
var state_14814__$1 = state_14814;
var statearr_14843_14931 = state_14814__$1;
(statearr_14843_14931[(2)] = inst_14729);

(statearr_14843_14931[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (13))){
var inst_14676 = (state_14814[(11)]);
var inst_14693 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_14676);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14693)){
var statearr_14844_14932 = state_14814__$1;
(statearr_14844_14932[(1)] = (15));

} else {
var statearr_14845_14933 = state_14814__$1;
(statearr_14845_14933[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (22))){
var inst_14706 = (state_14814[(2)]);
var inst_14707 = fluree.db.util.async.throw_err.call(null,inst_14706);
var state_14814__$1 = state_14814;
var statearr_14846_14934 = state_14814__$1;
(statearr_14846_14934[(2)] = inst_14707);

(statearr_14846_14934[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (36))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14677 = (state_14814[(14)]);
var inst_14714 = (state_14814[(8)]);
var inst_14740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14741 = [inst_14675,inst_14714,inst_14674,inst_14677];
var inst_14742 = (new cljs.core.PersistentVector(null,4,(5),inst_14740,inst_14741,null));
var inst_14743 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14742,opts);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(39),inst_14743);
} else {
if((state_val_14815 === (41))){
var inst_14675 = (state_14814[(9)]);
var state_14814__$1 = state_14814;
var statearr_14847_14935 = state_14814__$1;
(statearr_14847_14935[(2)] = inst_14675);

(statearr_14847_14935[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (43))){
var inst_14714 = (state_14814[(8)]);
var state_14814__$1 = state_14814;
var statearr_14848_14936 = state_14814__$1;
(statearr_14848_14936[(2)] = inst_14714);

(statearr_14848_14936[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (61))){
var inst_14801 = (state_14814[(7)]);
var inst_14803 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_14801);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(64),inst_14803);
} else {
if((state_val_14815 === (29))){
var inst_14738 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14738)){
var statearr_14849_14937 = state_14814__$1;
(statearr_14849_14937[(1)] = (36));

} else {
var statearr_14850_14938 = state_14814__$1;
(statearr_14850_14938[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (44))){
var state_14814__$1 = state_14814;
var statearr_14851_14939 = state_14814__$1;
(statearr_14851_14939[(2)] = false);

(statearr_14851_14939[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (6))){
var inst_14675 = (state_14814[(9)]);
var inst_14680 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14675);
var inst_14681 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14680);
var state_14814__$1 = state_14814;
var statearr_14852_14940 = state_14814__$1;
(statearr_14852_14940[(2)] = inst_14681);

(statearr_14852_14940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (28))){
var inst_14675 = (state_14814[(9)]);
var state_14814__$1 = state_14814;
var statearr_14853_14941 = state_14814__$1;
(statearr_14853_14941[(2)] = inst_14675);

(statearr_14853_14941[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (64))){
var inst_14805 = (state_14814[(2)]);
var inst_14806 = fluree.db.util.async.throw_err.call(null,inst_14805);
var state_14814__$1 = state_14814;
var statearr_14854_14942 = state_14814__$1;
(statearr_14854_14942[(2)] = inst_14806);

(statearr_14854_14942[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (51))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14677 = (state_14814[(14)]);
var inst_14764 = (state_14814[(2)]);
var inst_14765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14766 = [inst_14675,inst_14674,null,inst_14677];
var inst_14767 = (new cljs.core.PersistentVector(null,4,(5),inst_14765,inst_14766,null));
var inst_14768 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14764);
var inst_14769 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14767,inst_14768);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(52),inst_14769);
} else {
if((state_val_14815 === (25))){
var inst_14684 = (state_14814[(13)]);
var inst_14801 = (state_14814[(2)]);
var state_14814__$1 = (function (){var statearr_14855 = state_14814;
(statearr_14855[(7)] = inst_14801);

return statearr_14855;
})();
if(cljs.core.truth_(inst_14684)){
var statearr_14856_14943 = state_14814__$1;
(statearr_14856_14943[(1)] = (61));

} else {
var statearr_14857_14944 = state_14814__$1;
(statearr_14857_14944[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (34))){
var inst_14678 = (state_14814[(15)]);
var state_14814__$1 = state_14814;
var statearr_14858_14945 = state_14814__$1;
(statearr_14858_14945[(2)] = inst_14678);

(statearr_14858_14945[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (17))){
var inst_14712 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14859_14946 = state_14814__$1;
(statearr_14859_14946[(2)] = inst_14712);

(statearr_14859_14946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (3))){
var inst_14812 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14814__$1,inst_14812);
} else {
if((state_val_14815 === (12))){
var inst_14676 = (state_14814[(11)]);
var state_14814__$1 = state_14814;
var statearr_14860_14947 = state_14814__$1;
(statearr_14860_14947[(2)] = inst_14676);

(statearr_14860_14947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (2))){
var inst_14675 = (state_14814[(9)]);
var inst_14673 = (state_14814[(17)]);
var _ = (function (){var statearr_14861 = state_14814;
(statearr_14861[(4)] = cljs.core.cons.call(null,(5),(state_14814[(4)])));

return statearr_14861;
})();
var inst_14673__$1 = fparts;
var inst_14674 = cljs.core.nth.call(null,inst_14673__$1,(0),null);
var inst_14675__$1 = cljs.core.nth.call(null,inst_14673__$1,(1),null);
var inst_14676 = cljs.core.nth.call(null,inst_14673__$1,(2),null);
var inst_14677 = cljs.core.nth.call(null,inst_14673__$1,(3),null);
var inst_14678 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14675__$1);
var state_14814__$1 = (function (){var statearr_14862 = state_14814;
(statearr_14862[(12)] = inst_14674);

(statearr_14862[(9)] = inst_14675__$1);

(statearr_14862[(14)] = inst_14677);

(statearr_14862[(15)] = inst_14678);

(statearr_14862[(11)] = inst_14676);

(statearr_14862[(17)] = inst_14673__$1);

return statearr_14862;
})();
if(cljs.core.truth_(inst_14675__$1)){
var statearr_14863_14948 = state_14814__$1;
(statearr_14863_14948[(1)] = (6));

} else {
var statearr_14864_14949 = state_14814__$1;
(statearr_14864_14949[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (23))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14677 = (state_14814[(14)]);
var inst_14714 = (state_14814[(8)]);
var inst_14716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14717 = [inst_14674,inst_14675,inst_14714,inst_14677];
var inst_14718 = (new cljs.core.PersistentVector(null,4,(5),inst_14716,inst_14717,null));
var inst_14719 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14718,opts);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(26),inst_14719);
} else {
if((state_val_14815 === (47))){
var inst_14675 = (state_14814[(9)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14675)){
var statearr_14865_14950 = state_14814__$1;
(statearr_14865_14950[(1)] = (53));

} else {
var statearr_14866_14951 = state_14814__$1;
(statearr_14866_14951[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (35))){
var inst_14732 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14867_14952 = state_14814__$1;
(statearr_14867_14952[(2)] = inst_14732);

(statearr_14867_14952[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (19))){
var inst_14675 = (state_14814[(9)]);
var inst_14676 = (state_14814[(11)]);
var inst_14702 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14675);
var inst_14703 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14702),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14676)].join('');
var inst_14704 = fluree.db.dbproto._tag_id.call(null,db,inst_14703);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(22),inst_14704);
} else {
if((state_val_14815 === (57))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14677 = (state_14814[(14)]);
var inst_14714 = (state_14814[(8)]);
var inst_14784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14785 = [inst_14714,inst_14675,inst_14674,inst_14677];
var inst_14786 = (new cljs.core.PersistentVector(null,4,(5),inst_14784,inst_14785,null));
var inst_14787 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14786,opts);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(60),inst_14787);
} else {
if((state_val_14815 === (11))){
var inst_14689 = (state_14814[(16)]);
var inst_14689__$1 = (state_14814[(2)]);
var inst_14690 = cljs.core.not.call(null,inst_14689__$1);
var state_14814__$1 = (function (){var statearr_14869 = state_14814;
(statearr_14869[(16)] = inst_14689__$1);

return statearr_14869;
})();
if(inst_14690){
var statearr_14870_14953 = state_14814__$1;
(statearr_14870_14953[(1)] = (12));

} else {
var statearr_14871_14954 = state_14814__$1;
(statearr_14871_14954[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (9))){
var inst_14676 = (state_14814[(11)]);
var inst_14686 = typeof inst_14676 === 'string';
var state_14814__$1 = state_14814;
var statearr_14872_14955 = state_14814__$1;
(statearr_14872_14955[(2)] = inst_14686);

(statearr_14872_14955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (5))){
var _ = (function (){var statearr_14873 = state_14814;
(statearr_14873[(4)] = cljs.core.rest.call(null,(state_14814[(4)])));

return statearr_14873;
})();
var state_14814__$1 = state_14814;
var ex14868 = (state_14814__$1[(2)]);
var statearr_14874_14956 = state_14814__$1;
(statearr_14874_14956[(5)] = ex14868);


if((ex14868 instanceof Error)){
var statearr_14875_14957 = state_14814__$1;
(statearr_14875_14957[(1)] = (4));

(statearr_14875_14957[(5)] = null);

} else {
throw ex14868;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (14))){
var inst_14674 = (state_14814[(12)]);
var inst_14714 = (state_14814[(2)]);
var state_14814__$1 = (function (){var statearr_14876 = state_14814;
(statearr_14876[(8)] = inst_14714);

return statearr_14876;
})();
if(cljs.core.truth_(inst_14674)){
var statearr_14877_14958 = state_14814__$1;
(statearr_14877_14958[(1)] = (23));

} else {
var statearr_14878_14959 = state_14814__$1;
(statearr_14878_14959[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (45))){
var inst_14753 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14879_14960 = state_14814__$1;
(statearr_14879_14960[(2)] = inst_14753);

(statearr_14879_14960[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (53))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14677 = (state_14814[(14)]);
var inst_14714 = (state_14814[(8)]);
var inst_14775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14776 = [inst_14675,inst_14674,inst_14714,inst_14677];
var inst_14777 = (new cljs.core.PersistentVector(null,4,(5),inst_14775,inst_14776,null));
var inst_14778 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14777,opts);
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14814__$1,(56),inst_14778);
} else {
if((state_val_14815 === (26))){
var inst_14721 = (state_14814[(2)]);
var inst_14722 = fluree.db.util.async.throw_err.call(null,inst_14721);
var state_14814__$1 = state_14814;
var statearr_14880_14961 = state_14814__$1;
(statearr_14880_14961[(2)] = inst_14722);

(statearr_14880_14961[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (16))){
var inst_14676 = (state_14814[(11)]);
var inst_14700 = typeof inst_14676 === 'string';
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14700)){
var statearr_14881_14962 = state_14814__$1;
(statearr_14881_14962[(1)] = (19));

} else {
var statearr_14882_14963 = state_14814__$1;
(statearr_14882_14963[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (38))){
var inst_14799 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
var statearr_14883_14964 = state_14814__$1;
(statearr_14883_14964[(2)] = inst_14799);

(statearr_14883_14964[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (30))){
var inst_14678 = (state_14814[(15)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14678)){
var statearr_14884_14965 = state_14814__$1;
(statearr_14884_14965[(1)] = (33));

} else {
var statearr_14885_14966 = state_14814__$1;
(statearr_14885_14966[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (10))){
var inst_14684 = (state_14814[(13)]);
var state_14814__$1 = state_14814;
var statearr_14886_14967 = state_14814__$1;
(statearr_14886_14967[(2)] = inst_14684);

(statearr_14886_14967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (18))){
var inst_14697 = (state_14814[(2)]);
var inst_14698 = fluree.db.util.async.throw_err.call(null,inst_14697);
var state_14814__$1 = state_14814;
var statearr_14887_14968 = state_14814__$1;
(statearr_14887_14968[(2)] = inst_14698);

(statearr_14887_14968[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (52))){
var inst_14771 = (state_14814[(2)]);
var inst_14772 = fluree.db.util.async.throw_err.call(null,inst_14771);
var state_14814__$1 = state_14814;
var statearr_14888_14969 = state_14814__$1;
(statearr_14888_14969[(2)] = inst_14772);

(statearr_14888_14969[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (42))){
var inst_14756 = (state_14814[(2)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14756)){
var statearr_14889_14970 = state_14814__$1;
(statearr_14889_14970[(1)] = (46));

} else {
var statearr_14890_14971 = state_14814__$1;
(statearr_14890_14971[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (37))){
var inst_14675 = (state_14814[(9)]);
var state_14814__$1 = state_14814;
if(cljs.core.truth_(inst_14675)){
var statearr_14891_14972 = state_14814__$1;
(statearr_14891_14972[(1)] = (40));

} else {
var statearr_14892_14973 = state_14814__$1;
(statearr_14892_14973[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (63))){
var inst_14809 = (state_14814[(2)]);
var _ = (function (){var statearr_14893 = state_14814;
(statearr_14893[(4)] = cljs.core.rest.call(null,(state_14814[(4)])));

return statearr_14893;
})();
var state_14814__$1 = state_14814;
var statearr_14894_14974 = state_14814__$1;
(statearr_14894_14974[(2)] = inst_14809);

(statearr_14894_14974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (8))){
var inst_14684 = (state_14814[(13)]);
var inst_14684__$1 = (state_14814[(2)]);
var state_14814__$1 = (function (){var statearr_14895 = state_14814;
(statearr_14895[(13)] = inst_14684__$1);

return statearr_14895;
})();
if(cljs.core.truth_(inst_14684__$1)){
var statearr_14896_14975 = state_14814__$1;
(statearr_14896_14975[(1)] = (9));

} else {
var statearr_14897_14976 = state_14814__$1;
(statearr_14897_14976[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14815 === (49))){
var inst_14674 = (state_14814[(12)]);
var inst_14675 = (state_14814[(9)]);
var inst_14684 = (state_14814[(13)]);
var inst_14677 = (state_14814[(14)]);
var inst_14678 = (state_14814[(15)]);
var inst_14714 = (state_14814[(8)]);
var inst_14689 = (state_14814[(16)]);
var inst_14758 = (state_14814[(10)]);
var inst_14673 = (state_14814[(17)]);
var inst_14760 = (function (){var obj_fn = inst_14758;
var t = inst_14677;
var temp__5733__auto__ = inst_14758;
var p = inst_14675;
var vec__14670 = inst_14673;
var idx_predicate_QMARK_ = inst_14678;
var o = inst_14714;
var tag_predicate_QMARK_ = inst_14684;
var s = inst_14674;
var o_coerce_QMARK_ = inst_14689;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_14814__$1 = state_14814;
var statearr_14898_14977 = state_14814__$1;
(statearr_14898_14977[(2)] = inst_14760);

(statearr_14898_14977[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2454__auto__ = null;
var fluree$db$query$range$state_machine__2454__auto____0 = (function (){
var statearr_14899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14899[(0)] = fluree$db$query$range$state_machine__2454__auto__);

(statearr_14899[(1)] = (1));

return statearr_14899;
});
var fluree$db$query$range$state_machine__2454__auto____1 = (function (state_14814){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_14814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e14900){var ex__2457__auto__ = e14900;
var statearr_14901_14978 = state_14814;
(statearr_14901_14978[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_14814[(4)]))){
var statearr_14902_14979 = state_14814;
(statearr_14902_14979[(1)] = cljs.core.first.call(null,(state_14814[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14980 = state_14814;
state_14814 = G__14980;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2454__auto__ = function(state_14814){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2454__auto____1.call(this,state_14814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2454__auto____0;
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2454__auto____1;
return fluree$db$query$range$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_14903 = f__2477__auto__.call(null);
(statearr_14903[(6)] = c__2476__auto__);

return statearr_14903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__14982 = arguments.length;
switch (G__14982) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_15017){
var state_val_15018 = (state_15017[(1)]);
if((state_val_15018 === (7))){
var inst_15004 = cljs.core.pr_str.call(null,name);
var inst_15005 = ["Invalid collection name: ",inst_15004].join('');
var inst_15006 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15007 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15008 = cljs.core.PersistentHashMap.fromArrays(inst_15006,inst_15007);
var inst_15009 = cljs.core.ex_info.call(null,inst_15005,inst_15008);
var inst_15010 = (function(){throw inst_15009})();
var state_15017__$1 = state_15017;
var statearr_15019_15039 = state_15017__$1;
(statearr_15019_15039[(2)] = inst_15010);

(statearr_15019_15039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (1))){
var state_15017__$1 = state_15017;
var statearr_15020_15040 = state_15017__$1;
(statearr_15020_15040[(2)] = null);

(statearr_15020_15040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (4))){
var inst_14983 = (state_15017[(2)]);
var state_15017__$1 = state_15017;
var statearr_15021_15041 = state_15017__$1;
(statearr_15021_15041[(2)] = inst_14983);

(statearr_15021_15041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (6))){
var inst_14989 = (state_15017[(7)]);
var inst_14991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14992 = fluree.db.flake.max_subject_id.call(null,inst_14989);
var inst_14993 = [inst_14992];
var inst_14994 = (new cljs.core.PersistentVector(null,1,(5),inst_14991,inst_14993,null));
var inst_14995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14996 = fluree.db.flake.min_subject_id.call(null,inst_14989);
var inst_14997 = [inst_14996];
var inst_14998 = (new cljs.core.PersistentVector(null,1,(5),inst_14995,inst_14997,null));
var inst_14999 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_14994,cljs.core._LT__EQ_,inst_14998,opts);
var state_15017__$1 = state_15017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15017__$1,(9),inst_14999);
} else {
if((state_val_15018 === (3))){
var inst_15015 = (state_15017[(2)]);
var state_15017__$1 = state_15017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15017__$1,inst_15015);
} else {
if((state_val_15018 === (2))){
var inst_14989 = (state_15017[(7)]);
var _ = (function (){var statearr_15023 = state_15017;
(statearr_15023[(4)] = cljs.core.cons.call(null,(5),(state_15017[(4)])));

return statearr_15023;
})();
var inst_14989__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15017__$1 = (function (){var statearr_15024 = state_15017;
(statearr_15024[(7)] = inst_14989__$1);

return statearr_15024;
})();
if(cljs.core.truth_(inst_14989__$1)){
var statearr_15025_15042 = state_15017__$1;
(statearr_15025_15042[(1)] = (6));

} else {
var statearr_15026_15043 = state_15017__$1;
(statearr_15026_15043[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (9))){
var inst_15001 = (state_15017[(2)]);
var inst_15002 = fluree.db.util.async.throw_err.call(null,inst_15001);
var state_15017__$1 = state_15017;
var statearr_15027_15044 = state_15017__$1;
(statearr_15027_15044[(2)] = inst_15002);

(statearr_15027_15044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (5))){
var _ = (function (){var statearr_15028 = state_15017;
(statearr_15028[(4)] = cljs.core.rest.call(null,(state_15017[(4)])));

return statearr_15028;
})();
var state_15017__$1 = state_15017;
var ex15022 = (state_15017__$1[(2)]);
var statearr_15029_15045 = state_15017__$1;
(statearr_15029_15045[(5)] = ex15022);


if((ex15022 instanceof java.lang.Exception)){
var statearr_15030_15046 = state_15017__$1;
(statearr_15030_15046[(1)] = (4));

(statearr_15030_15046[(5)] = null);

} else {
throw ex15022;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15018 === (8))){
var inst_15012 = (state_15017[(2)]);
var _ = (function (){var statearr_15031 = state_15017;
(statearr_15031[(4)] = cljs.core.rest.call(null,(state_15017[(4)])));

return statearr_15031;
})();
var state_15017__$1 = state_15017;
var statearr_15032_15047 = state_15017__$1;
(statearr_15032_15047[(2)] = inst_15012);

(statearr_15032_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2454__auto__ = null;
var fluree$db$query$range$state_machine__2454__auto____0 = (function (){
var statearr_15033 = [null,null,null,null,null,null,null,null];
(statearr_15033[(0)] = fluree$db$query$range$state_machine__2454__auto__);

(statearr_15033[(1)] = (1));

return statearr_15033;
});
var fluree$db$query$range$state_machine__2454__auto____1 = (function (state_15017){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_15017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e15034){var ex__2457__auto__ = e15034;
var statearr_15035_15048 = state_15017;
(statearr_15035_15048[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_15017[(4)]))){
var statearr_15036_15049 = state_15017;
(statearr_15036_15049[(1)] = cljs.core.first.call(null,(state_15017[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15050 = state_15017;
state_15017 = G__15050;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2454__auto__ = function(state_15017){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2454__auto____1.call(this,state_15017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2454__auto____0;
fluree$db$query$range$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2454__auto____1;
return fluree$db$query$range$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_15037 = f__2477__auto__.call(null);
(statearr_15037[(6)] = c__2476__auto__);

return statearr_15037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15054 = flakes;
var vec__15055 = G__15054;
var seq__15056 = cljs.core.seq.call(null,vec__15055);
var first__15057 = cljs.core.first.call(null,seq__15056);
var seq__15056__$1 = cljs.core.next.call(null,seq__15056);
var flake_SINGLEQUOTE_ = first__15057;
var r = seq__15056__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15054__$1 = G__15054;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15064 = G__15054__$1;
var seq__15065 = cljs.core.seq.call(null,vec__15064);
var first__15066 = cljs.core.first.call(null,seq__15065);
var seq__15065__$1 = cljs.core.next.call(null,seq__15065);
var flake_SINGLEQUOTE___$1 = first__15066;
var r__$1 = seq__15065__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15068){if((e15068 instanceof java.lang.Exception)){
var e = e15068;
return null;
} else {
throw e15068;

}
}})();
var map__15067 = cmd_map;
var map__15067__$1 = (((((!((map__15067 == null))))?(((((map__15067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15067):map__15067);
var type = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15070 = r__$1;
var G__15071 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15054__$1 = G__15070;
result_STAR___$1 = G__15071;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15080 = blocks;
var vec__15081 = G__15080;
var seq__15082 = cljs.core.seq.call(null,vec__15081);
var first__15083 = cljs.core.first.call(null,seq__15082);
var seq__15082__$1 = cljs.core.next.call(null,seq__15082);
var block_SINGLEQUOTE_ = first__15083;
var r = seq__15082__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15080__$1 = G__15080;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15089 = G__15080__$1;
var seq__15090 = cljs.core.seq.call(null,vec__15089);
var first__15091 = cljs.core.first.call(null,seq__15090);
var seq__15090__$1 = cljs.core.next.call(null,seq__15090);
var block_SINGLEQUOTE___$1 = first__15091;
var r__$1 = seq__15090__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15092 = block_SINGLEQUOTE___$1;
var map__15092__$1 = (((((!((map__15092 == null))))?(((((map__15092.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15092.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15092):map__15092);
var block = cljs.core.get.call(null,map__15092__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15092__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15092__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15072_SHARP_){
if(cljs.core._EQ_.call(null,p1__15072_SHARP_.p,(2))){
return p1__15072_SHARP_.o;
} else {
return null;
}
});})(G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15073_SHARP_){
if(cljs.core._EQ_.call(null,p1__15073_SHARP_.p,(1))){
return p1__15073_SHARP_.o;
} else {
return null;
}
});})(G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15074_SHARP_){
if(cljs.core._EQ_.call(null,p1__15074_SHARP_.p,(5))){
return p1__15074_SHARP_.o;
} else {
return null;
}
});})(G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,instant,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15075_SHARP_){
if(cljs.core._EQ_.call(null,p1__15075_SHARP_.p,(7))){
return p1__15075_SHARP_.o;
} else {
return null;
}
});})(G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,instant,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15076_SHARP_){
return cljs.core._EQ_.call(null,p1__15076_SHARP_.p,(106));
});})(G__15080__$1,result_STAR___$1,map__15092,map__15092__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15089,seq__15090,first__15091,seq__15090__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15080,vec__15081,seq__15082,first__15083,seq__15082__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15094 = r__$1;
var G__15095 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15080__$1 = G__15094;
result_STAR___$1 = G__15095;
continue;
}
break;
}
});
