// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e16245){var e = e16245;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__16246_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__16246_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__16246_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__16246_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16247_SHARP_){
return cljs.core.conj.call(null,p1__16247_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16248_SHARP_){
return cljs.core.conj.call(null,p1__16248_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__16253 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__16253,(0),null);
var _ = cljs.core.nth.call(null,vec__16253,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16249_SHARP_){
return cljs.core.conj.call(null,p1__16249_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__16256 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__16256,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__16256,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16250_SHARP_){
return cljs.core.conj.call(null,p1__16250_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16251_SHARP_){
return cljs.core.conj.call(null,p1__16251_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__16252_SHARP_){
return cljs.core.conj.call(null,p1__16252_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__16259_SHARP_){
return cljs.core.nth.call(null,array,p1__16259_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__16262,optional_QMARK_,fuel,max_fuel){
var map__16263 = p__16262;
var map__16263__$1 = (((((!((map__16263 == null))))?(((((map__16263.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16263.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16263):map__16263);
var res = map__16263__$1;
var vars = cljs.core.get.call(null,map__16263__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16330){
var state_val_16331 = (state_16330[(1)]);
if((state_val_16331 === (7))){
var inst_16319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16320 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_16321 = cljs.core.conj.call(null,inst_16320,clause);
var inst_16322 = [null,inst_16321];
var inst_16323 = (new cljs.core.PersistentVector(null,2,(5),inst_16319,inst_16322,null));
var state_16330__$1 = state_16330;
var statearr_16332_16360 = state_16330__$1;
(statearr_16332_16360[(2)] = inst_16323);

(statearr_16332_16360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (1))){
var state_16330__$1 = state_16330;
var statearr_16333_16361 = state_16330__$1;
(statearr_16333_16361[(2)] = null);

(statearr_16333_16361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (4))){
var inst_16265 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
var statearr_16334_16362 = state_16330__$1;
(statearr_16334_16362[(2)] = inst_16265);

(statearr_16334_16362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (15))){
var inst_16308 = (state_16330[(2)]);
var inst_16309 = fluree.db.util.async.throw_err.call(null,inst_16308);
var inst_16310 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_16309);
var inst_16311 = cljs.core.count.call(null,inst_16310);
var inst_16312 = fluree.db.query.analytical.add_fuel.call(null,inst_16311,fuel,max_fuel);
var inst_16313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16314 = [inst_16309,r];
var inst_16315 = (new cljs.core.PersistentVector(null,2,(5),inst_16313,inst_16314,null));
var state_16330__$1 = (function (){var statearr_16335 = state_16330;
(statearr_16335[(7)] = inst_16312);

return statearr_16335;
})();
var statearr_16336_16363 = state_16330__$1;
(statearr_16336_16363[(2)] = inst_16315);

(statearr_16336_16363[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (13))){
var inst_16274 = (state_16330[(8)]);
var inst_16287 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16288 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_16287);
var inst_16289 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_16274);
var inst_16290 = cljs.core.apply.call(null,cljs.core.concat,inst_16289);
var inst_16291 = cljs.core.set.call(null,inst_16290);
var inst_16292 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_16288);
var inst_16293 = cljs.core.apply.call(null,cljs.core.concat,inst_16292);
var inst_16294 = cljs.core.into.call(null,inst_16291,inst_16293);
var inst_16295 = (function (){var all_wd = inst_16274;
var optional = inst_16288;
var all_wd_vars = inst_16291;
var all_vars = inst_16294;
return (function (p1__16260_SHARP_){
return all_vars.call(null,p1__16260_SHARP_);
});
})();
var inst_16296 = cljs.core.keys.call(null,vars);
var inst_16297 = cljs.core.map.call(null,inst_16295,inst_16296);
var inst_16298 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_16297);
var inst_16299 = cljs.core.set.call(null,inst_16298);
var inst_16300 = (function (){var all_wd = inst_16274;
var optional = inst_16288;
var all_wd_vars = inst_16291;
var all_vars = inst_16294;
var intersecting_vars = inst_16299;
return (function (p1__16261_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__16261_SHARP_);
});
})();
var inst_16301 = cljs.core.map.call(null,inst_16300,inst_16274);
var inst_16302 = cljs.core.apply.call(null,cljs.core.concat,inst_16301);
var inst_16303 = fluree.db.query.analytical.select_from_tuples.call(null,inst_16302,res);
var inst_16304 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_16274,inst_16299,vars);
var inst_16305 = cljs.core.remove.call(null,inst_16299,inst_16294);
var inst_16306 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_16304,inst_16302,inst_16303,inst_16305,inst_16288);
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16330__$1,(15),inst_16306);
} else {
if((state_val_16331 === (6))){
var inst_16275 = (state_16330[(9)]);
var inst_16273 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_16274 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_16273);
var inst_16275__$1 = optional_QMARK_;
var state_16330__$1 = (function (){var statearr_16337 = state_16330;
(statearr_16337[(8)] = inst_16274);

(statearr_16337[(9)] = inst_16275__$1);

return statearr_16337;
})();
if(cljs.core.truth_(inst_16275__$1)){
var statearr_16338_16364 = state_16330__$1;
(statearr_16338_16364[(1)] = (9));

} else {
var statearr_16339_16365 = state_16330__$1;
(statearr_16339_16365[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (3))){
var inst_16328 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16330__$1,inst_16328);
} else {
if((state_val_16331 === (12))){
var inst_16283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16284 = [null,r];
var inst_16285 = (new cljs.core.PersistentVector(null,2,(5),inst_16283,inst_16284,null));
var state_16330__$1 = state_16330;
var statearr_16340_16366 = state_16330__$1;
(statearr_16340_16366[(2)] = inst_16285);

(statearr_16340_16366[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (2))){
var _ = (function (){var statearr_16341 = state_16330;
(statearr_16341[(4)] = cljs.core.cons.call(null,(5),(state_16330[(4)])));

return statearr_16341;
})();
var inst_16271 = (r == null);
var state_16330__$1 = state_16330;
if(cljs.core.truth_(inst_16271)){
var statearr_16342_16367 = state_16330__$1;
(statearr_16342_16367[(1)] = (6));

} else {
var statearr_16343_16368 = state_16330__$1;
(statearr_16343_16368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (11))){
var inst_16281 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
if(cljs.core.truth_(inst_16281)){
var statearr_16345_16369 = state_16330__$1;
(statearr_16345_16369[(1)] = (12));

} else {
var statearr_16346_16370 = state_16330__$1;
(statearr_16346_16370[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (9))){
var inst_16274 = (state_16330[(8)]);
var inst_16277 = cljs.core.empty_QMARK_.call(null,inst_16274);
var inst_16278 = (!(inst_16277));
var state_16330__$1 = state_16330;
var statearr_16347_16371 = state_16330__$1;
(statearr_16347_16371[(2)] = inst_16278);

(statearr_16347_16371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (5))){
var _ = (function (){var statearr_16348 = state_16330;
(statearr_16348[(4)] = cljs.core.rest.call(null,(state_16330[(4)])));

return statearr_16348;
})();
var state_16330__$1 = state_16330;
var ex16344 = (state_16330__$1[(2)]);
var statearr_16349_16372 = state_16330__$1;
(statearr_16349_16372[(5)] = ex16344);


if((ex16344 instanceof Error)){
var statearr_16350_16373 = state_16330__$1;
(statearr_16350_16373[(1)] = (4));

(statearr_16350_16373[(5)] = null);

} else {
throw ex16344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (14))){
var inst_16317 = (state_16330[(2)]);
var state_16330__$1 = state_16330;
var statearr_16351_16374 = state_16330__$1;
(statearr_16351_16374[(2)] = inst_16317);

(statearr_16351_16374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (10))){
var inst_16275 = (state_16330[(9)]);
var state_16330__$1 = state_16330;
var statearr_16352_16375 = state_16330__$1;
(statearr_16352_16375[(2)] = inst_16275);

(statearr_16352_16375[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16331 === (8))){
var inst_16325 = (state_16330[(2)]);
var _ = (function (){var statearr_16353 = state_16330;
(statearr_16353[(4)] = cljs.core.rest.call(null,(state_16330[(4)])));

return statearr_16353;
})();
var state_16330__$1 = state_16330;
var statearr_16354_16376 = state_16330__$1;
(statearr_16354_16376[(2)] = inst_16325);

(statearr_16354_16376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_16355 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16355[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__);

(statearr_16355[(1)] = (1));

return statearr_16355;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____1 = (function (state_16330){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16356){var ex__2457__auto__ = e16356;
var statearr_16357_16377 = state_16330;
(statearr_16357_16377[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16330[(4)]))){
var statearr_16358_16378 = state_16330;
(statearr_16358_16378[(1)] = cljs.core.first.call(null,(state_16330[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16379 = state_16330;
state_16330 = G__16379;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__ = function(state_16330){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____1.call(this,state_16330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16359 = f__2477__auto__.call(null);
(statearr_16359[(6)] = c__2476__auto__);

return statearr_16359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__16381 = arguments.length;
switch (G__16381) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16475){
var state_val_16476 = (state_16475[(1)]);
if((state_val_16476 === (7))){
var inst_16388 = (state_16475[(7)]);
var inst_16398 = clojure.string.starts_with_QMARK_.call(null,inst_16388,"$fdb");
var state_16475__$1 = state_16475;
if(inst_16398){
var statearr_16477_16526 = state_16475__$1;
(statearr_16477_16526[(1)] = (9));

} else {
var statearr_16478_16527 = state_16475__$1;
(statearr_16478_16527[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (20))){
var state_16475__$1 = state_16475;
var statearr_16479_16528 = state_16475__$1;
(statearr_16479_16528[(2)] = null);

(statearr_16479_16528[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (27))){
var inst_16438 = (state_16475[(8)]);
var state_16475__$1 = state_16475;
var statearr_16480_16529 = state_16475__$1;
(statearr_16480_16529[(2)] = inst_16438);

(statearr_16480_16529[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (1))){
var state_16475__$1 = state_16475;
var statearr_16481_16530 = state_16475__$1;
(statearr_16481_16530[(2)] = null);

(statearr_16481_16530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (24))){
var inst_16461 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16482_16531 = state_16475__$1;
(statearr_16482_16531[(2)] = inst_16461);

(statearr_16482_16531[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (4))){
var inst_16382 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16483_16532 = state_16475__$1;
(statearr_16483_16532[(2)] = inst_16382);

(statearr_16483_16532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (15))){
var inst_16405 = (state_16475[(9)]);
var inst_16411 = (state_16475[(2)]);
var inst_16412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16413 = cljs.core.PersistentVector.EMPTY;
var inst_16414 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16415 = cljs.core.into.call(null,inst_16413,inst_16414);
var inst_16416 = [inst_16405,inst_16415];
var inst_16417 = (new cljs.core.PersistentVector(null,2,(5),inst_16412,inst_16416,null));
var state_16475__$1 = (function (){var statearr_16484 = state_16475;
(statearr_16484[(10)] = inst_16411);

return statearr_16484;
})();
var statearr_16485_16533 = state_16475__$1;
(statearr_16485_16533[(2)] = inst_16417);

(statearr_16485_16533[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (21))){
var inst_16464 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16486_16534 = state_16475__$1;
(statearr_16486_16534[(2)] = inst_16464);

(statearr_16486_16534[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (13))){
var inst_16405 = (state_16475[(9)]);
var inst_16408 = (function(){throw inst_16405})();
var state_16475__$1 = state_16475;
var statearr_16487_16535 = state_16475__$1;
(statearr_16487_16535[(2)] = inst_16408);

(statearr_16487_16535[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (22))){
var inst_16429 = (state_16475[(11)]);
var inst_16427 = (state_16475[(12)]);
var inst_16431 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_16427);
var inst_16432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16433 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_16429];
var inst_16434 = (new cljs.core.PersistentVector(null,2,(5),inst_16432,inst_16433,null));
var inst_16435 = cljs.core.get_in.call(null,opts,inst_16434);
var state_16475__$1 = (function (){var statearr_16488 = state_16475;
(statearr_16488[(13)] = inst_16431);

return statearr_16488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16475__$1,(25),inst_16435);
} else {
if((state_val_16476 === (29))){
var inst_16442 = (state_16475[(2)]);
var inst_16443 = fluree.db.util.async.throw_err.call(null,inst_16442);
var state_16475__$1 = state_16475;
var statearr_16489_16536 = state_16475__$1;
(statearr_16489_16536[(2)] = inst_16443);

(statearr_16489_16536[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (6))){
var inst_16391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16392 = cljs.core.PersistentVector.EMPTY;
var inst_16393 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16394 = cljs.core.into.call(null,inst_16392,inst_16393);
var inst_16395 = [db,inst_16394];
var inst_16396 = (new cljs.core.PersistentVector(null,2,(5),inst_16391,inst_16395,null));
var state_16475__$1 = state_16475;
var statearr_16490_16537 = state_16475__$1;
(statearr_16490_16537[(2)] = inst_16396);

(statearr_16490_16537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (28))){
var inst_16446 = (state_16475[(2)]);
var inst_16447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16448 = cljs.core.PersistentVector.EMPTY;
var inst_16449 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_16450 = cljs.core.into.call(null,inst_16448,inst_16449);
var inst_16451 = [inst_16446,inst_16450];
var inst_16452 = (new cljs.core.PersistentVector(null,2,(5),inst_16447,inst_16451,null));
var state_16475__$1 = state_16475;
var statearr_16491_16538 = state_16475__$1;
(statearr_16491_16538[(2)] = inst_16452);

(statearr_16491_16538[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (25))){
var inst_16431 = (state_16475[(13)]);
var inst_16437 = (state_16475[(2)]);
var inst_16438 = fluree.db.util.async.throw_err.call(null,inst_16437);
var state_16475__$1 = (function (){var statearr_16492 = state_16475;
(statearr_16492[(8)] = inst_16438);

return statearr_16492;
})();
if(cljs.core.truth_(inst_16431)){
var statearr_16493_16539 = state_16475__$1;
(statearr_16493_16539[(1)] = (26));

} else {
var statearr_16494_16540 = state_16475__$1;
(statearr_16494_16540[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (17))){
var state_16475__$1 = state_16475;
var statearr_16495_16541 = state_16475__$1;
(statearr_16495_16541[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (3))){
var inst_16473 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16475__$1,inst_16473);
} else {
if((state_val_16476 === (12))){
var inst_16405 = (state_16475[(9)]);
var inst_16404 = (state_16475[(2)]);
var inst_16405__$1 = fluree.db.util.async.throw_err.call(null,inst_16404);
var inst_16406 = fluree.db.util.core.exception_QMARK_.call(null,inst_16405__$1);
var state_16475__$1 = (function (){var statearr_16497 = state_16475;
(statearr_16497[(9)] = inst_16405__$1);

return statearr_16497;
})();
if(inst_16406){
var statearr_16498_16542 = state_16475__$1;
(statearr_16498_16542[(1)] = (13));

} else {
var statearr_16499_16543 = state_16475__$1;
(statearr_16499_16543[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (2))){
var inst_16388 = (state_16475[(7)]);
var _ = (function (){var statearr_16500 = state_16475;
(statearr_16500[(4)] = cljs.core.cons.call(null,(5),(state_16475[(4)])));

return statearr_16500;
})();
var inst_16388__$1 = cljs.core.first.call(null,clause);
var inst_16389 = cljs.core._EQ_.call(null,"$fdb",inst_16388__$1);
var state_16475__$1 = (function (){var statearr_16501 = state_16475;
(statearr_16501[(7)] = inst_16388__$1);

return statearr_16501;
})();
if(inst_16389){
var statearr_16502_16544 = state_16475__$1;
(statearr_16502_16544[(1)] = (6));

} else {
var statearr_16503_16545 = state_16475__$1;
(statearr_16503_16545[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (23))){
var inst_16388 = (state_16475[(7)]);
var inst_16454 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16388)," is not supported in Fluree"].join('');
var inst_16455 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16456 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16457 = cljs.core.PersistentHashMap.fromArrays(inst_16455,inst_16456);
var inst_16458 = cljs.core.ex_info.call(null,inst_16454,inst_16457);
var inst_16459 = (function(){throw inst_16458})();
var state_16475__$1 = state_16475;
var statearr_16504_16546 = state_16475__$1;
(statearr_16504_16546[(2)] = inst_16459);

(statearr_16504_16546[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (19))){
var inst_16429 = (state_16475[(11)]);
var inst_16388 = (state_16475[(7)]);
var inst_16426 = fluree.db.query.analytical.isolate_source_name.call(null,inst_16388);
var inst_16427 = fluree.db.query.analytical.isolate_source_block.call(null,inst_16388);
var inst_16428 = cljs.core.keyword.call(null,inst_16426);
var inst_16429__$1 = cljs.core.get.call(null,prefixes,inst_16428);
var state_16475__$1 = (function (){var statearr_16505 = state_16475;
(statearr_16505[(11)] = inst_16429__$1);

(statearr_16505[(12)] = inst_16427);

return statearr_16505;
})();
if(cljs.core.truth_(inst_16429__$1)){
var statearr_16506_16547 = state_16475__$1;
(statearr_16506_16547[(1)] = (22));

} else {
var statearr_16507_16548 = state_16475__$1;
(statearr_16507_16548[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (11))){
var inst_16468 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16509_16549 = state_16475__$1;
(statearr_16509_16549[(2)] = inst_16468);

(statearr_16509_16549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (9))){
var inst_16388 = (state_16475[(7)]);
var inst_16400 = cljs.core.subs.call(null,inst_16388,(4));
var inst_16401 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_16400);
var inst_16402 = fluree.db.time_travel.as_of_block.call(null,db,inst_16401);
var state_16475__$1 = state_16475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16475__$1,(12),inst_16402);
} else {
if((state_val_16476 === (5))){
var _ = (function (){var statearr_16510 = state_16475;
(statearr_16510[(4)] = cljs.core.rest.call(null,(state_16475[(4)])));

return statearr_16510;
})();
var state_16475__$1 = state_16475;
var ex16508 = (state_16475__$1[(2)]);
var statearr_16511_16550 = state_16475__$1;
(statearr_16511_16550[(5)] = ex16508);


if((ex16508 instanceof Error)){
var statearr_16512_16551 = state_16475__$1;
(statearr_16512_16551[(1)] = (4));

(statearr_16512_16551[(5)] = null);

} else {
throw ex16508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (14))){
var state_16475__$1 = state_16475;
var statearr_16513_16552 = state_16475__$1;
(statearr_16513_16552[(2)] = null);

(statearr_16513_16552[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (26))){
var inst_16431 = (state_16475[(13)]);
var inst_16438 = (state_16475[(8)]);
var inst_16440 = fluree.db.time_travel.as_of_block.call(null,inst_16438,inst_16431);
var state_16475__$1 = state_16475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16475__$1,(29),inst_16440);
} else {
if((state_val_16476 === (16))){
var inst_16421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16422 = ["$wd",clause];
var inst_16423 = (new cljs.core.PersistentVector(null,2,(5),inst_16421,inst_16422,null));
var state_16475__$1 = state_16475;
var statearr_16514_16553 = state_16475__$1;
(statearr_16514_16553[(2)] = inst_16423);

(statearr_16514_16553[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (10))){
var inst_16388 = (state_16475[(7)]);
var inst_16419 = cljs.core._EQ_.call(null,"$wd",inst_16388);
var state_16475__$1 = state_16475;
if(inst_16419){
var statearr_16515_16554 = state_16475__$1;
(statearr_16515_16554[(1)] = (16));

} else {
var statearr_16516_16555 = state_16475__$1;
(statearr_16516_16555[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (18))){
var inst_16466 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16517_16556 = state_16475__$1;
(statearr_16517_16556[(2)] = inst_16466);

(statearr_16517_16556[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (8))){
var inst_16470 = (state_16475[(2)]);
var _ = (function (){var statearr_16518 = state_16475;
(statearr_16518[(4)] = cljs.core.rest.call(null,(state_16475[(4)])));

return statearr_16518;
})();
var state_16475__$1 = state_16475;
var statearr_16519_16557 = state_16475__$1;
(statearr_16519_16557[(2)] = inst_16470);

(statearr_16519_16557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2454__auto__ = null;
var fluree$db$query$analytical$state_machine__2454__auto____0 = (function (){
var statearr_16520 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16520[(0)] = fluree$db$query$analytical$state_machine__2454__auto__);

(statearr_16520[(1)] = (1));

return statearr_16520;
});
var fluree$db$query$analytical$state_machine__2454__auto____1 = (function (state_16475){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16521){var ex__2457__auto__ = e16521;
var statearr_16522_16558 = state_16475;
(statearr_16522_16558[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16475[(4)]))){
var statearr_16523_16559 = state_16475;
(statearr_16523_16559[(1)] = cljs.core.first.call(null,(state_16475[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16560 = state_16475;
state_16475 = G__16560;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2454__auto__ = function(state_16475){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2454__auto____1.call(this,state_16475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2454__auto____0;
fluree$db$query$analytical$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2454__auto____1;
return fluree$db$query$analytical$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16524 = f__2477__auto__.call(null);
(statearr_16524[(6)] = c__2476__auto__);

return statearr_16524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__16561){
var vec__16562 = p__16561;
var sub = cljs.core.nth.call(null,vec__16562,(0),null);
var obj = cljs.core.nth.call(null,vec__16562,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__16565_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__16565_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__16569 = subjects;
var vec__16570 = G__16569;
var seq__16571 = cljs.core.seq.call(null,vec__16570);
var first__16572 = cljs.core.first.call(null,seq__16571);
var seq__16571__$1 = cljs.core.next.call(null,seq__16571);
var subject = first__16572;
var r = seq__16571__$1;
var acc = expanded_map;
var G__16569__$1 = G__16569;
var acc__$1 = acc;
while(true){
var vec__16576 = G__16569__$1;
var seq__16577 = cljs.core.seq.call(null,vec__16576);
var first__16578 = cljs.core.first.call(null,seq__16577);
var seq__16577__$1 = cljs.core.next.call(null,seq__16577);
var subject__$1 = first__16578;
var r__$1 = seq__16577__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__16579 = r__$1;
var G__16580 = acc__$2;
G__16569__$1 = G__16579;
acc__$1 = G__16580;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__16569__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__16569__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__16569__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__16569__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__16569__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__16569__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__16576,seq__16577,first__16578,seq__16577__$1,subject__$1,r__$1,acc__$2,G__16569,vec__16570,seq__16571,first__16572,seq__16571__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__16581 = r__$1;
var G__16582 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__16569__$1 = G__16581;
acc__$1 = G__16582;
continue;
} else {
var G__16583 = subjects;
var G__16584 = acc_STAR_;
G__16569__$1 = G__16583;
acc__$1 = G__16584;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__16585_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__16585_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16676){
var state_val_16677 = (state_16676[(1)]);
if((state_val_16677 === (7))){
var state_16676__$1 = state_16676;
var statearr_16678_16724 = state_16676__$1;
(statearr_16678_16724[(2)] = (100));

(statearr_16678_16724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (20))){
var inst_16625 = (state_16676[(7)]);
var state_16676__$1 = state_16676;
var statearr_16679_16725 = state_16676__$1;
(statearr_16679_16725[(2)] = inst_16625);

(statearr_16679_16725[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (1))){
var state_16676__$1 = state_16676;
var statearr_16680_16726 = state_16676__$1;
(statearr_16680_16726[(2)] = null);

(statearr_16680_16726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (24))){
var inst_16662 = (state_16676[(8)]);
var inst_16663 = (state_16676[(9)]);
var inst_16597 = (state_16676[(10)]);
var inst_16664 = (state_16676[(11)]);
var inst_16667 = (function (){var max_depth = inst_16597;
var recur_map__$1 = inst_16663;
var subjects = inst_16662;
var tuples = inst_16664;
return (function (p1__16586_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__16586_SHARP_)],null));
});
})();
var inst_16668 = cljs.core.map.call(null,inst_16667,inst_16664);
var inst_16669 = cljs.core.distinct.call(null,inst_16668);
var state_16676__$1 = state_16676;
var statearr_16681_16727 = state_16676__$1;
(statearr_16681_16727[(2)] = inst_16669);

(statearr_16681_16727[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (4))){
var inst_16587 = (state_16676[(2)]);
var state_16676__$1 = state_16676;
var statearr_16682_16728 = state_16676__$1;
(statearr_16682_16728[(2)] = inst_16587);

(statearr_16682_16728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (15))){
var inst_16610 = (state_16676[(12)]);
var inst_16621 = cljs.core.PersistentVector.EMPTY;
var inst_16622 = cljs.core.seq.call(null,inst_16610);
var inst_16623 = cljs.core.first.call(null,inst_16622);
var inst_16624 = cljs.core.next.call(null,inst_16622);
var inst_16625 = inst_16621;
var inst_16626 = inst_16610;
var state_16676__$1 = (function (){var statearr_16683 = state_16676;
(statearr_16683[(13)] = inst_16623);

(statearr_16683[(7)] = inst_16625);

(statearr_16683[(14)] = inst_16624);

(statearr_16683[(15)] = inst_16626);

return statearr_16683;
})();
var statearr_16684_16729 = state_16676__$1;
(statearr_16684_16729[(2)] = null);

(statearr_16684_16729[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (21))){
var inst_16646 = (state_16676[(2)]);
var state_16676__$1 = state_16676;
var statearr_16685_16730 = state_16676__$1;
(statearr_16685_16730[(2)] = inst_16646);

(statearr_16685_16730[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (13))){
var inst_16659 = (state_16676[(2)]);
var state_16676__$1 = state_16676;
var statearr_16686_16731 = state_16676__$1;
(statearr_16686_16731[(2)] = inst_16659);

(statearr_16686_16731[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (22))){
var inst_16633 = (state_16676[(16)]);
var inst_16625 = (state_16676[(7)]);
var inst_16640 = (state_16676[(2)]);
var inst_16641 = fluree.db.util.async.throw_err.call(null,inst_16640);
var inst_16642 = cljs.core.concat.call(null,inst_16625,inst_16641);
var inst_16625__$1 = inst_16642;
var inst_16626 = inst_16633;
var state_16676__$1 = (function (){var statearr_16687 = state_16676;
(statearr_16687[(7)] = inst_16625__$1);

(statearr_16687[(15)] = inst_16626);

return statearr_16687;
})();
var statearr_16688_16732 = state_16676__$1;
(statearr_16688_16732[(2)] = null);

(statearr_16688_16732[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (6))){
var inst_16593 = (state_16676[(17)]);
var state_16676__$1 = state_16676;
var statearr_16689_16733 = state_16676__$1;
(statearr_16689_16733[(2)] = inst_16593);

(statearr_16689_16733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (25))){
var inst_16671 = (state_16676[(2)]);
var _ = (function (){var statearr_16690 = state_16676;
(statearr_16690[(4)] = cljs.core.rest.call(null,(state_16676[(4)])));

return statearr_16690;
})();
var state_16676__$1 = state_16676;
var statearr_16691_16734 = state_16676__$1;
(statearr_16691_16734[(2)] = inst_16671);

(statearr_16691_16734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (17))){
var inst_16632 = (state_16676[(18)]);
var inst_16626 = (state_16676[(15)]);
var inst_16631 = cljs.core.seq.call(null,inst_16626);
var inst_16632__$1 = cljs.core.first.call(null,inst_16631);
var inst_16633 = cljs.core.next.call(null,inst_16631);
var state_16676__$1 = (function (){var statearr_16692 = state_16676;
(statearr_16692[(16)] = inst_16633);

(statearr_16692[(18)] = inst_16632__$1);

return statearr_16692;
})();
if(cljs.core.truth_(inst_16632__$1)){
var statearr_16693_16735 = state_16676__$1;
(statearr_16693_16735[(1)] = (19));

} else {
var statearr_16694_16736 = state_16676__$1;
(statearr_16694_16736[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (3))){
var inst_16674 = (state_16676[(2)]);
var state_16676__$1 = state_16676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16676__$1,inst_16674);
} else {
if((state_val_16677 === (12))){
var inst_16610 = (state_16676[(12)]);
var inst_16599 = (state_16676[(19)]);
var inst_16605 = cljs.core.vals.call(null,inst_16599);
var inst_16606 = cljs.core.flatten.call(null,inst_16605);
var inst_16607 = cljs.core.set.call(null,inst_16606);
var inst_16608 = cljs.core.keys.call(null,inst_16599);
var inst_16609 = cljs.core.set.call(null,inst_16608);
var inst_16610__$1 = clojure.set.difference.call(null,inst_16607,inst_16609);
var inst_16611 = cljs.core.empty_QMARK_.call(null,inst_16610__$1);
var state_16676__$1 = (function (){var statearr_16695 = state_16676;
(statearr_16695[(12)] = inst_16610__$1);

return statearr_16695;
})();
if(inst_16611){
var statearr_16696_16737 = state_16676__$1;
(statearr_16696_16737[(1)] = (14));

} else {
var statearr_16697_16738 = state_16676__$1;
(statearr_16697_16738[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (2))){
var inst_16593 = (state_16676[(17)]);
var _ = (function (){var statearr_16698 = state_16676;
(statearr_16698[(4)] = cljs.core.cons.call(null,(5),(state_16676[(4)])));

return statearr_16698;
})();
var inst_16593__$1 = depth;
var state_16676__$1 = (function (){var statearr_16699 = state_16676;
(statearr_16699[(17)] = inst_16593__$1);

return statearr_16699;
})();
if(cljs.core.truth_(inst_16593__$1)){
var statearr_16700_16739 = state_16676__$1;
(statearr_16700_16739[(1)] = (6));

} else {
var statearr_16701_16740 = state_16676__$1;
(statearr_16701_16740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (23))){
var inst_16664 = (state_16676[(11)]);
var state_16676__$1 = state_16676;
var statearr_16702_16741 = state_16676__$1;
(statearr_16702_16741[(2)] = inst_16664);

(statearr_16702_16741[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (19))){
var inst_16632 = (state_16676[(18)]);
var inst_16635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16636 = [inst_16632,predicate];
var inst_16637 = (new cljs.core.PersistentVector(null,2,(5),inst_16635,inst_16636,null));
var inst_16638 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16637);
var state_16676__$1 = state_16676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16676__$1,(22),inst_16638);
} else {
if((state_val_16677 === (11))){
var inst_16599 = (state_16676[(19)]);
var state_16676__$1 = state_16676;
var statearr_16704_16742 = state_16676__$1;
(statearr_16704_16742[(2)] = inst_16599);

(statearr_16704_16742[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (9))){
var inst_16600 = (state_16676[(20)]);
var inst_16597 = (state_16676[(10)]);
var inst_16602 = (inst_16600 >= inst_16597);
var state_16676__$1 = state_16676;
if(cljs.core.truth_(inst_16602)){
var statearr_16705_16743 = state_16676__$1;
(statearr_16705_16743[(1)] = (11));

} else {
var statearr_16706_16744 = state_16676__$1;
(statearr_16706_16744[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (5))){
var _ = (function (){var statearr_16707 = state_16676;
(statearr_16707[(4)] = cljs.core.rest.call(null,(state_16676[(4)])));

return statearr_16707;
})();
var state_16676__$1 = state_16676;
var ex16703 = (state_16676__$1[(2)]);
var statearr_16708_16745 = state_16676__$1;
(statearr_16708_16745[(5)] = ex16703);


if((ex16703 instanceof Error)){
var statearr_16709_16746 = state_16676__$1;
(statearr_16709_16746[(1)] = (4));

(statearr_16709_16746[(5)] = null);

} else {
throw ex16703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (14))){
var inst_16599 = (state_16676[(19)]);
var state_16676__$1 = state_16676;
var statearr_16710_16747 = state_16676__$1;
(statearr_16710_16747[(2)] = inst_16599);

(statearr_16710_16747[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (16))){
var inst_16657 = (state_16676[(2)]);
var state_16676__$1 = state_16676;
var statearr_16711_16748 = state_16676__$1;
(statearr_16711_16748[(2)] = inst_16657);

(statearr_16711_16748[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (10))){
var inst_16662 = (state_16676[(8)]);
var inst_16663 = (state_16676[(9)]);
var inst_16661 = (state_16676[(2)]);
var inst_16662__$1 = cljs.core.keys.call(null,inst_16661);
var inst_16663__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_16662__$1,inst_16661);
var inst_16664 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_16662__$1,inst_16663__$1);
var state_16676__$1 = (function (){var statearr_16712 = state_16676;
(statearr_16712[(8)] = inst_16662__$1);

(statearr_16712[(9)] = inst_16663__$1);

(statearr_16712[(11)] = inst_16664);

return statearr_16712;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_16713_16749 = state_16676__$1;
(statearr_16713_16749[(1)] = (23));

} else {
var statearr_16714_16750 = state_16676__$1;
(statearr_16714_16750[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (18))){
var inst_16600 = (state_16676[(20)]);
var inst_16599 = (state_16676[(19)]);
var inst_16648 = (state_16676[(2)]);
var inst_16649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16650 = [(0),(2)];
var inst_16651 = (new cljs.core.PersistentVector(null,2,(5),inst_16649,inst_16650,null));
var inst_16652 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_16651,inst_16648);
var inst_16653 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_16599,inst_16652);
var inst_16654 = (inst_16600 + (1));
var inst_16599__$1 = inst_16653;
var inst_16600__$1 = inst_16654;
var state_16676__$1 = (function (){var statearr_16715 = state_16676;
(statearr_16715[(20)] = inst_16600__$1);

(statearr_16715[(19)] = inst_16599__$1);

return statearr_16715;
})();
var statearr_16716_16751 = state_16676__$1;
(statearr_16716_16751[(2)] = null);

(statearr_16716_16751[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16677 === (8))){
var inst_16597 = (state_16676[(2)]);
var inst_16598 = recur_map;
var inst_16599 = inst_16598;
var inst_16600 = (1);
var state_16676__$1 = (function (){var statearr_16717 = state_16676;
(statearr_16717[(20)] = inst_16600);

(statearr_16717[(19)] = inst_16599);

(statearr_16717[(10)] = inst_16597);

return statearr_16717;
})();
var statearr_16718_16752 = state_16676__$1;
(statearr_16718_16752[(2)] = null);

(statearr_16718_16752[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____0 = (function (){
var statearr_16719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16719[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__);

(statearr_16719[(1)] = (1));

return statearr_16719;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____1 = (function (state_16676){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16720){var ex__2457__auto__ = e16720;
var statearr_16721_16753 = state_16676;
(statearr_16721_16753[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16676[(4)]))){
var statearr_16722_16754 = state_16676;
(statearr_16722_16754[(1)] = cljs.core.first.call(null,(state_16676[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16755 = state_16676;
state_16676 = G__16755;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__ = function(state_16676){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____1.call(this,state_16676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16723 = f__2477__auto__.call(null);
(statearr_16723[(6)] = c__2476__auto__);

return statearr_16723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__16756,clause,fuel,max_fuel){
var map__16757 = p__16756;
var map__16757__$1 = (((((!((map__16757 == null))))?(((((map__16757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16757):map__16757);
var res = map__16757__$1;
var headers = cljs.core.get.call(null,map__16757__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__16757__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__16757__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16889){
var state_val_16890 = (state_16889[(1)]);
if((state_val_16890 === (7))){
var state_16889__$1 = state_16889;
var statearr_16891_16957 = state_16889__$1;
(statearr_16891_16957[(2)] = false);

(statearr_16891_16957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (20))){
var inst_16821 = (state_16889[(7)]);
var state_16889__$1 = state_16889;
var statearr_16892_16958 = state_16889__$1;
(statearr_16892_16958[(2)] = inst_16821);

(statearr_16892_16958[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (27))){
var inst_16825 = (state_16889[(8)]);
var inst_16849 = (state_16889[(2)]);
var state_16889__$1 = (function (){var statearr_16893 = state_16889;
(statearr_16893[(9)] = inst_16849);

return statearr_16893;
})();
if(cljs.core.truth_(inst_16825)){
var statearr_16894_16959 = state_16889__$1;
(statearr_16894_16959[(1)] = (28));

} else {
var statearr_16895_16960 = state_16889__$1;
(statearr_16895_16960[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (1))){
var state_16889__$1 = state_16889;
var statearr_16896_16961 = state_16889__$1;
(statearr_16896_16961[(2)] = null);

(statearr_16896_16961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (24))){
var inst_16837 = (state_16889[(2)]);
var inst_16838 = cljs.core.nth.call(null,clause,(2));
var inst_16839 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_16838);
var state_16889__$1 = (function (){var statearr_16897 = state_16889;
(statearr_16897[(10)] = inst_16837);

return statearr_16897;
})();
if(cljs.core.truth_(inst_16839)){
var statearr_16898_16962 = state_16889__$1;
(statearr_16898_16962[(1)] = (25));

} else {
var statearr_16899_16963 = state_16889__$1;
(statearr_16899_16963[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (4))){
var inst_16759 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
var statearr_16900_16964 = state_16889__$1;
(statearr_16900_16964[(2)] = inst_16759);

(statearr_16900_16964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (15))){
var inst_16807 = (state_16889[(11)]);
var state_16889__$1 = state_16889;
var statearr_16901_16965 = state_16889__$1;
(statearr_16901_16965[(2)] = inst_16807);

(statearr_16901_16965[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (21))){
var inst_16792 = (state_16889[(12)]);
var inst_16880 = (state_16889[(2)]);
var inst_16881 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_16882 = cljs.core.keys.call(null,inst_16792);
var inst_16883 = [inst_16882,vars,inst_16880];
var inst_16884 = cljs.core.PersistentHashMap.fromArrays(inst_16881,inst_16883);
var _ = (function (){var statearr_16902 = state_16889;
(statearr_16902[(4)] = cljs.core.rest.call(null,(state_16889[(4)])));

return statearr_16902;
})();
var state_16889__$1 = state_16889;
var statearr_16903_16966 = state_16889__$1;
(statearr_16903_16966[(2)] = inst_16884);

(statearr_16903_16966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (31))){
var inst_16821 = (state_16889[(7)]);
var inst_16823 = (state_16889[(13)]);
var inst_16856 = cljs.core.PersistentHashMap.EMPTY;
var inst_16857 = cljs.core.flatten.call(null,inst_16821);
var inst_16858 = cljs.core.assoc.call(null,inst_16856,inst_16823,inst_16857);
var state_16889__$1 = state_16889;
var statearr_16904_16967 = state_16889__$1;
(statearr_16904_16967[(2)] = inst_16858);

(statearr_16904_16967[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (32))){
var inst_16823 = (state_16889[(13)]);
var inst_16860 = cljs.core.coll_QMARK_.call(null,inst_16823);
var state_16889__$1 = state_16889;
if(inst_16860){
var statearr_16905_16968 = state_16889__$1;
(statearr_16905_16968[(1)] = (34));

} else {
var statearr_16906_16969 = state_16889__$1;
(statearr_16906_16969[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (33))){
var inst_16871 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
var statearr_16907_16970 = state_16889__$1;
(statearr_16907_16970[(2)] = inst_16871);

(statearr_16907_16970[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (13))){
var inst_16769 = (state_16889[(14)]);
var state_16889__$1 = state_16889;
var statearr_16908_16971 = state_16889__$1;
(statearr_16908_16971[(2)] = inst_16769);

(statearr_16908_16971[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (22))){
var inst_16805 = (state_16889[(15)]);
var inst_16829 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16805)].join('');
var inst_16830 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16831 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16832 = cljs.core.PersistentHashMap.fromArrays(inst_16830,inst_16831);
var inst_16833 = cljs.core.ex_info.call(null,inst_16829,inst_16832);
var inst_16834 = (function(){throw inst_16833})();
var state_16889__$1 = state_16889;
var statearr_16909_16972 = state_16889__$1;
(statearr_16909_16972[(2)] = inst_16834);

(statearr_16909_16972[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (36))){
var inst_16869 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
var statearr_16910_16973 = state_16889__$1;
(statearr_16910_16973[(2)] = inst_16869);

(statearr_16910_16973[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (29))){
var inst_16823 = (state_16889[(13)]);
var inst_16854 = typeof inst_16823 === 'number';
var state_16889__$1 = state_16889;
if(cljs.core.truth_(inst_16854)){
var statearr_16911_16974 = state_16889__$1;
(statearr_16911_16974[(1)] = (31));

} else {
var statearr_16912_16975 = state_16889__$1;
(statearr_16912_16975[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (6))){
var inst_16769 = (state_16889[(14)]);
var inst_16774 = inst_16769.cljs$lang$protocol_mask$partition0$;
var inst_16775 = (inst_16774 & (64));
var inst_16776 = inst_16769.cljs$core$ISeq$;
var inst_16777 = (cljs.core.PROTOCOL_SENTINEL === inst_16776);
var inst_16778 = ((inst_16775) || (inst_16777));
var state_16889__$1 = state_16889;
if(cljs.core.truth_(inst_16778)){
var statearr_16913_16976 = state_16889__$1;
(statearr_16913_16976[(1)] = (9));

} else {
var statearr_16914_16977 = state_16889__$1;
(statearr_16914_16977[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (28))){
var inst_16821 = (state_16889[(7)]);
var inst_16851 = cljs.core.PersistentHashMap.EMPTY;
var inst_16852 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_16851,inst_16821);
var state_16889__$1 = state_16889;
var statearr_16915_16978 = state_16889__$1;
(statearr_16915_16978[(2)] = inst_16852);

(statearr_16915_16978[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (25))){
var state_16889__$1 = state_16889;
var statearr_16916_16979 = state_16889__$1;
(statearr_16916_16979[(2)] = null);

(statearr_16916_16979[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (34))){
var inst_16821 = (state_16889[(7)]);
var inst_16817 = (state_16889[(16)]);
var inst_16862 = cljs.core.PersistentHashMap.EMPTY;
var inst_16863 = cljs.core.first.call(null,inst_16817);
var inst_16864 = cljs.core.first.call(null,inst_16863);
var inst_16865 = cljs.core.flatten.call(null,inst_16821);
var inst_16866 = cljs.core.assoc.call(null,inst_16862,inst_16864,inst_16865);
var state_16889__$1 = state_16889;
var statearr_16917_16980 = state_16889__$1;
(statearr_16917_16980[(2)] = inst_16866);

(statearr_16917_16980[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (17))){
var inst_16806 = (state_16889[(17)]);
var inst_16805 = (state_16889[(15)]);
var inst_16811 = (state_16889[(2)]);
var inst_16812 = [inst_16811];
var inst_16813 = cljs.core.PersistentHashMap.fromArrays(inst_16806,inst_16812);
var inst_16814 = fluree.db.query.range.search.call(null,db,inst_16805,inst_16813);
var state_16889__$1 = state_16889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16889__$1,(18),inst_16814);
} else {
if((state_val_16890 === (3))){
var inst_16887 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16889__$1,inst_16887);
} else {
if((state_val_16890 === (12))){
var inst_16769 = (state_16889[(14)]);
var inst_16787 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16769);
var state_16889__$1 = state_16889;
var statearr_16918_16981 = state_16889__$1;
(statearr_16918_16981[(2)] = inst_16787);

(statearr_16918_16981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (2))){
var inst_16769 = (state_16889[(14)]);
var _ = (function (){var statearr_16919 = state_16889;
(statearr_16919[(4)] = cljs.core.cons.call(null,(5),(state_16889[(4)])));

return statearr_16919;
})();
var inst_16769__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_16771 = (inst_16769__$1 == null);
var inst_16772 = cljs.core.not.call(null,inst_16771);
var state_16889__$1 = (function (){var statearr_16920 = state_16889;
(statearr_16920[(14)] = inst_16769__$1);

return statearr_16920;
})();
if(inst_16772){
var statearr_16921_16982 = state_16889__$1;
(statearr_16921_16982[(1)] = (6));

} else {
var statearr_16922_16983 = state_16889__$1;
(statearr_16922_16983[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (23))){
var state_16889__$1 = state_16889;
var statearr_16923_16984 = state_16889__$1;
(statearr_16923_16984[(2)] = null);

(statearr_16923_16984[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (35))){
var state_16889__$1 = state_16889;
var statearr_16924_16985 = state_16889__$1;
(statearr_16924_16985[(2)] = null);

(statearr_16924_16985[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (19))){
var inst_16805 = (state_16889[(15)]);
var inst_16826 = (state_16889[(18)]);
var inst_16823 = cljs.core.first.call(null,inst_16805);
var inst_16824 = cljs.core.first.call(null,clause);
var inst_16825 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_16824);
var inst_16826__$1 = cljs.core.nth.call(null,inst_16805,(1));
var inst_16827 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_16826__$1);
var state_16889__$1 = (function (){var statearr_16925 = state_16889;
(statearr_16925[(13)] = inst_16823);

(statearr_16925[(8)] = inst_16825);

(statearr_16925[(18)] = inst_16826__$1);

return statearr_16925;
})();
if(cljs.core.truth_(inst_16827)){
var statearr_16926_16986 = state_16889__$1;
(statearr_16926_16986[(1)] = (22));

} else {
var statearr_16927_16987 = state_16889__$1;
(statearr_16927_16987[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (11))){
var inst_16782 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
var statearr_16929_16988 = state_16889__$1;
(statearr_16929_16988[(2)] = inst_16782);

(statearr_16929_16988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (9))){
var state_16889__$1 = state_16889;
var statearr_16930_16989 = state_16889__$1;
(statearr_16930_16989[(2)] = true);

(statearr_16930_16989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (5))){
var _ = (function (){var statearr_16931 = state_16889;
(statearr_16931[(4)] = cljs.core.rest.call(null,(state_16889[(4)])));

return statearr_16931;
})();
var state_16889__$1 = state_16889;
var ex16928 = (state_16889__$1[(2)]);
var statearr_16932_16990 = state_16889__$1;
(statearr_16932_16990[(5)] = ex16928);


if((ex16928 instanceof Error)){
var statearr_16933_16991 = state_16889__$1;
(statearr_16933_16991[(1)] = (4));

(statearr_16933_16991[(5)] = null);

} else {
throw ex16928;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (14))){
var inst_16792 = (state_16889[(12)]);
var inst_16795 = (state_16889[(19)]);
var inst_16796 = (state_16889[(20)]);
var inst_16807 = (state_16889[(11)]);
var inst_16790 = (state_16889[(2)]);
var inst_16791 = cljs.core.get.call(null,inst_16790,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_16792__$1 = cljs.core.get.call(null,inst_16790,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_16793 = cljs.core.get.call(null,inst_16790,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_16794 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_16795__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_16793);
var inst_16796__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_16793);
var inst_16798 = (function (){var map__16765 = inst_16790;
var search = inst_16791;
var rel = inst_16792__$1;
var opts = inst_16793;
var common_keys = inst_16794;
var object_fn = inst_16795__$1;
var recur_depth = inst_16796__$1;
return (function (p__16797,common_key){
var vec__16934 = p__16797;
var acc = cljs.core.nth.call(null,vec__16934,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__16934,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__16937 = cljs.core._EQ_;
var expr__16938 = idx_of;
if(cljs.core.truth_(pred__16937.call(null,(0),expr__16938))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__16937.call(null,(1),expr__16938))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__16937.call(null,(2),expr__16938))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__16938)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_16799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16800 = cljs.core.PersistentHashMap.EMPTY;
var inst_16801 = [inst_16800,inst_16791];
var inst_16802 = (new cljs.core.PersistentVector(null,2,(5),inst_16799,inst_16801,null));
var inst_16803 = cljs.core.reduce.call(null,inst_16798,inst_16802,inst_16794);
var inst_16804 = cljs.core.nth.call(null,inst_16803,(0),null);
var inst_16805 = cljs.core.nth.call(null,inst_16803,(1),null);
var inst_16806 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_16807__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_16804);
var state_16889__$1 = (function (){var statearr_16940 = state_16889;
(statearr_16940[(17)] = inst_16806);

(statearr_16940[(12)] = inst_16792__$1);

(statearr_16940[(19)] = inst_16795__$1);

(statearr_16940[(20)] = inst_16796__$1);

(statearr_16940[(11)] = inst_16807__$1);

(statearr_16940[(15)] = inst_16805);

return statearr_16940;
})();
if(cljs.core.truth_(inst_16807__$1)){
var statearr_16941_16992 = state_16889__$1;
(statearr_16941_16992[(1)] = (15));

} else {
var statearr_16942_16993 = state_16889__$1;
(statearr_16942_16993[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (26))){
var inst_16805 = (state_16889[(15)]);
var inst_16842 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16805)].join('');
var inst_16843 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16844 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_16845 = cljs.core.PersistentHashMap.fromArrays(inst_16843,inst_16844);
var inst_16846 = cljs.core.ex_info.call(null,inst_16842,inst_16845);
var inst_16847 = (function(){throw inst_16846})();
var state_16889__$1 = state_16889;
var statearr_16943_16994 = state_16889__$1;
(statearr_16943_16994[(2)] = inst_16847);

(statearr_16943_16994[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (16))){
var inst_16795 = (state_16889[(19)]);
var state_16889__$1 = state_16889;
var statearr_16944_16995 = state_16889__$1;
(statearr_16944_16995[(2)] = inst_16795);

(statearr_16944_16995[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (30))){
var inst_16796 = (state_16889[(20)]);
var inst_16825 = (state_16889[(8)]);
var inst_16826 = (state_16889[(18)]);
var inst_16873 = (state_16889[(2)]);
var inst_16874 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_16826,inst_16873,inst_16796,inst_16825);
var state_16889__$1 = state_16889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16889__$1,(37),inst_16874);
} else {
if((state_val_16890 === (10))){
var state_16889__$1 = state_16889;
var statearr_16945_16996 = state_16889__$1;
(statearr_16945_16996[(2)] = false);

(statearr_16945_16996[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (18))){
var inst_16792 = (state_16889[(12)]);
var inst_16796 = (state_16889[(20)]);
var inst_16817 = (state_16889[(16)]);
var inst_16816 = (state_16889[(2)]);
var inst_16817__$1 = fluree.db.util.async.throw_err.call(null,inst_16816);
var inst_16818 = cljs.core.count.call(null,inst_16817__$1);
var inst_16819 = fluree.db.query.analytical.add_fuel.call(null,inst_16818,fuel,max_fuel);
var inst_16820 = cljs.core.vals.call(null,inst_16792);
var inst_16821 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_16820,inst_16817__$1);
var state_16889__$1 = (function (){var statearr_16946 = state_16889;
(statearr_16946[(7)] = inst_16821);

(statearr_16946[(16)] = inst_16817__$1);

(statearr_16946[(21)] = inst_16819);

return statearr_16946;
})();
if(cljs.core.truth_(inst_16796)){
var statearr_16947_16997 = state_16889__$1;
(statearr_16947_16997[(1)] = (19));

} else {
var statearr_16948_16998 = state_16889__$1;
(statearr_16948_16998[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (37))){
var inst_16876 = (state_16889[(2)]);
var inst_16877 = fluree.db.util.async.throw_err.call(null,inst_16876);
var state_16889__$1 = state_16889;
var statearr_16949_16999 = state_16889__$1;
(statearr_16949_16999[(2)] = inst_16877);

(statearr_16949_16999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16890 === (8))){
var inst_16785 = (state_16889[(2)]);
var state_16889__$1 = state_16889;
if(cljs.core.truth_(inst_16785)){
var statearr_16950_17000 = state_16889__$1;
(statearr_16950_17000[(1)] = (12));

} else {
var statearr_16951_17001 = state_16889__$1;
(statearr_16951_17001[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_16952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16952[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__);

(statearr_16952[(1)] = (1));

return statearr_16952;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____1 = (function (state_16889){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16953){var ex__2457__auto__ = e16953;
var statearr_16954_17002 = state_16889;
(statearr_16954_17002[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16889[(4)]))){
var statearr_16955_17003 = state_16889;
(statearr_16955_17003[(1)] = cljs.core.first.call(null,(state_16889[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17004 = state_16889;
state_16889 = G__17004;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__ = function(state_16889){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____1.call(this,state_16889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16956 = f__2477__auto__.call(null);
(statearr_16956[(6)] = c__2476__auto__);

return statearr_16956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_17103){
var state_val_17104 = (state_17103[(1)]);
if((state_val_17104 === (7))){
var inst_17014 = (state_17103[(7)]);
var state_17103__$1 = state_17103;
var statearr_17105_17145 = state_17103__$1;
(statearr_17105_17145[(2)] = inst_17014);

(statearr_17105_17145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (20))){
var inst_17094 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
var statearr_17106_17146 = state_17103__$1;
(statearr_17106_17146[(2)] = inst_17094);

(statearr_17106_17146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (1))){
var state_17103__$1 = state_17103;
var statearr_17107_17147 = state_17103__$1;
(statearr_17107_17147[(2)] = null);

(statearr_17107_17147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (24))){
var inst_17073 = (state_17103[(2)]);
var inst_17074 = fluree.db.util.async.throw_err.call(null,inst_17073);
var state_17103__$1 = state_17103;
var statearr_17108_17148 = state_17103__$1;
(statearr_17108_17148[(2)] = inst_17074);

(statearr_17108_17148[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (4))){
var inst_17007 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
var statearr_17109_17149 = state_17103__$1;
(statearr_17109_17149[(2)] = inst_17007);

(statearr_17109_17149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (15))){
var inst_17016 = (state_17103[(8)]);
var inst_17014 = (state_17103[(7)]);
var inst_17035 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17036 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17038 = [inst_17014];
var inst_17039 = (new cljs.core.PersistentVector(null,1,(5),inst_17037,inst_17038,null));
var inst_17040 = (function (){var subject_var = inst_17014;
var object_var = inst_17016;
var min_sid = inst_17035;
var max_sid = (0);
return (function (p1__17005_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17005_SHARP_);
});
})();
var inst_17041 = cljs.core.range.call(null,inst_17035,(0));
var inst_17042 = cljs.core.map.call(null,inst_17040,inst_17041);
var inst_17043 = cljs.core.PersistentHashMap.EMPTY;
var inst_17044 = [inst_17039,inst_17042,inst_17043];
var inst_17045 = cljs.core.PersistentHashMap.fromArrays(inst_17036,inst_17044);
var state_17103__$1 = state_17103;
var statearr_17110_17150 = state_17103__$1;
(statearr_17110_17150[(2)] = inst_17045);

(statearr_17110_17150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (21))){
var inst_17067 = (state_17103[(9)]);
var state_17103__$1 = state_17103;
var statearr_17111_17151 = state_17103__$1;
(statearr_17111_17151[(2)] = inst_17067);

(statearr_17111_17151[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (13))){
var inst_17016 = (state_17103[(8)]);
var state_17103__$1 = state_17103;
if(cljs.core.truth_(inst_17016)){
var statearr_17112_17152 = state_17103__$1;
(statearr_17112_17152[(1)] = (18));

} else {
var statearr_17113_17153 = state_17103__$1;
(statearr_17113_17153[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (22))){
var inst_17067 = (state_17103[(9)]);
var inst_17071 = fluree.db.dbproto._subid.call(null,db,inst_17067);
var state_17103__$1 = state_17103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17103__$1,(24),inst_17071);
} else {
if((state_val_17104 === (6))){
var inst_17016 = (state_17103[(8)]);
var state_17103__$1 = state_17103;
var statearr_17114_17154 = state_17103__$1;
(statearr_17114_17154[(2)] = inst_17016);

(statearr_17114_17154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (17))){
var inst_17064 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
var statearr_17115_17155 = state_17103__$1;
(statearr_17115_17155[(2)] = inst_17064);

(statearr_17115_17155[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (3))){
var inst_17101 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17103__$1,inst_17101);
} else {
if((state_val_17104 === (12))){
var inst_17029 = ["_tx",null,"_block",null];
var inst_17030 = (new cljs.core.PersistentArrayMap(null,2,inst_17029,null));
var inst_17031 = (new cljs.core.PersistentHashSet(null,inst_17030,null));
var inst_17032 = cljs.core.last.call(null,clause);
var inst_17033 = inst_17031.call(null,inst_17032);
var state_17103__$1 = state_17103;
if(cljs.core.truth_(inst_17033)){
var statearr_17116_17156 = state_17103__$1;
(statearr_17116_17156[(1)] = (15));

} else {
var statearr_17117_17157 = state_17103__$1;
(statearr_17117_17157[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (2))){
var inst_17014 = (state_17103[(7)]);
var _ = (function (){var statearr_17118 = state_17103;
(statearr_17118[(4)] = cljs.core.cons.call(null,(5),(state_17103[(4)])));

return statearr_17118;
})();
var inst_17013 = cljs.core.first.call(null,clause);
var inst_17014__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17013);
var inst_17015 = cljs.core.last.call(null,clause);
var inst_17016 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17015);
var state_17103__$1 = (function (){var statearr_17119 = state_17103;
(statearr_17119[(8)] = inst_17016);

(statearr_17119[(7)] = inst_17014__$1);

return statearr_17119;
})();
if(cljs.core.truth_(inst_17014__$1)){
var statearr_17120_17158 = state_17103__$1;
(statearr_17120_17158[(1)] = (6));

} else {
var statearr_17121_17159 = state_17103__$1;
(statearr_17121_17159[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (23))){
var inst_17016 = (state_17103[(8)]);
var inst_17076 = (state_17103[(2)]);
var inst_17077 = fluree.db.flake.sid__GT_cid.call(null,inst_17076);
var inst_17078 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_17077);
var inst_17079 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17081 = [inst_17016];
var inst_17082 = (new cljs.core.PersistentVector(null,1,(5),inst_17080,inst_17081,null));
var inst_17083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17085 = [inst_17078];
var inst_17086 = (new cljs.core.PersistentVector(null,1,(5),inst_17084,inst_17085,null));
var inst_17087 = [inst_17086];
var inst_17088 = (new cljs.core.PersistentVector(null,1,(5),inst_17083,inst_17087,null));
var inst_17089 = cljs.core.PersistentHashMap.EMPTY;
var inst_17090 = [inst_17082,inst_17088,inst_17089];
var inst_17091 = cljs.core.PersistentHashMap.fromArrays(inst_17079,inst_17090);
var state_17103__$1 = state_17103;
var statearr_17122_17160 = state_17103__$1;
(statearr_17122_17160[(2)] = inst_17091);

(statearr_17122_17160[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (19))){
var state_17103__$1 = state_17103;
var statearr_17123_17161 = state_17103__$1;
(statearr_17123_17161[(2)] = null);

(statearr_17123_17161[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (11))){
var inst_17098 = (state_17103[(2)]);
var _ = (function (){var statearr_17125 = state_17103;
(statearr_17125[(4)] = cljs.core.rest.call(null,(state_17103[(4)])));

return statearr_17125;
})();
var state_17103__$1 = state_17103;
var statearr_17126_17162 = state_17103__$1;
(statearr_17126_17162[(2)] = inst_17098);

(statearr_17126_17162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (9))){
var inst_17022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17023 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17024 = cljs.core.PersistentHashMap.fromArrays(inst_17022,inst_17023);
var inst_17025 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_17024);
var inst_17026 = (function(){throw inst_17025})();
var state_17103__$1 = state_17103;
var statearr_17127_17163 = state_17103__$1;
(statearr_17127_17163[(2)] = inst_17026);

(statearr_17127_17163[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (5))){
var _ = (function (){var statearr_17128 = state_17103;
(statearr_17128[(4)] = cljs.core.rest.call(null,(state_17103[(4)])));

return statearr_17128;
})();
var state_17103__$1 = state_17103;
var ex17124 = (state_17103__$1[(2)]);
var statearr_17129_17164 = state_17103__$1;
(statearr_17129_17164[(5)] = ex17124);


if((ex17124 instanceof Error)){
var statearr_17130_17165 = state_17103__$1;
(statearr_17130_17165[(1)] = (4));

(statearr_17130_17165[(5)] = null);

} else {
throw ex17124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (14))){
var inst_17096 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
var statearr_17131_17166 = state_17103__$1;
(statearr_17131_17166[(2)] = inst_17096);

(statearr_17131_17166[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (16))){
var inst_17016 = (state_17103[(8)]);
var inst_17014 = (state_17103[(7)]);
var inst_17047 = cljs.core.last.call(null,clause);
var inst_17048 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_17047);
var inst_17049 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_17050 = cljs.core.get.call(null,inst_17049,inst_17048);
var inst_17051 = fluree.db.flake.min_subject_id.call(null,inst_17048);
var inst_17052 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17054 = [inst_17014];
var inst_17055 = (new cljs.core.PersistentVector(null,1,(5),inst_17053,inst_17054,null));
var inst_17056 = (function (){var subject_var = inst_17014;
var object_var = inst_17016;
var cid = inst_17048;
var max_sid = inst_17050;
var min_sid = inst_17051;
return (function (p1__17006_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17006_SHARP_);
});
})();
var inst_17057 = (inst_17050 + (1));
var inst_17058 = cljs.core.range.call(null,inst_17051,inst_17057);
var inst_17059 = cljs.core.map.call(null,inst_17056,inst_17058);
var inst_17060 = cljs.core.PersistentHashMap.EMPTY;
var inst_17061 = [inst_17055,inst_17059,inst_17060];
var inst_17062 = cljs.core.PersistentHashMap.fromArrays(inst_17052,inst_17061);
var state_17103__$1 = state_17103;
var statearr_17132_17167 = state_17103__$1;
(statearr_17132_17167[(2)] = inst_17062);

(statearr_17132_17167[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (10))){
var inst_17014 = (state_17103[(7)]);
var state_17103__$1 = state_17103;
if(cljs.core.truth_(inst_17014)){
var statearr_17133_17168 = state_17103__$1;
(statearr_17133_17168[(1)] = (12));

} else {
var statearr_17134_17169 = state_17103__$1;
(statearr_17134_17169[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (18))){
var inst_17067 = (state_17103[(9)]);
var inst_17067__$1 = cljs.core.first.call(null,clause);
var inst_17068 = typeof inst_17067__$1 === 'number';
var state_17103__$1 = (function (){var statearr_17135 = state_17103;
(statearr_17135[(9)] = inst_17067__$1);

return statearr_17135;
})();
if(cljs.core.truth_(inst_17068)){
var statearr_17136_17170 = state_17103__$1;
(statearr_17136_17170[(1)] = (21));

} else {
var statearr_17137_17171 = state_17103__$1;
(statearr_17137_17171[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17104 === (8))){
var inst_17020 = (state_17103[(2)]);
var state_17103__$1 = state_17103;
if(cljs.core.truth_(inst_17020)){
var statearr_17138_17172 = state_17103__$1;
(statearr_17138_17172[(1)] = (9));

} else {
var statearr_17139_17173 = state_17103__$1;
(statearr_17139_17173[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_17140 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17140[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__);

(statearr_17140[(1)] = (1));

return statearr_17140;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____1 = (function (state_17103){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_17103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e17141){var ex__2457__auto__ = e17141;
var statearr_17142_17174 = state_17103;
(statearr_17142_17174[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_17103[(4)]))){
var statearr_17143_17175 = state_17103;
(statearr_17143_17175[(1)] = cljs.core.first.call(null,(state_17103[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17176 = state_17103;
state_17103 = G__17176;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__ = function(state_17103){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____1.call(this,state_17103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_17144 = f__2477__auto__.call(null);
(statearr_17144[(6)] = c__2476__auto__);

return statearr_17144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__17182 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__17182 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__17182;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__17183(s__17184){
return (new cljs.core.LazySeq(null,(function (){
var s__17184__$1 = s__17184;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__17184__$1);
if(temp__5735__auto__){
var s__17184__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17184__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__17184__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__17186 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__17185 = (0);
while(true){
if((i__17185 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__17185);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__17186,(delta * delta));

var G__17187 = (i__17185 + (1));
i__17185 = G__17187;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17186),fluree$db$query$analytical$variance_$_iter__17183.call(null,cljs.core.chunk_rest.call(null,s__17184__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17186),null);
}
} else {
var x = cljs.core.first.call(null,s__17184__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__17183.call(null,cljs.core.rest.call(null,s__17184__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__17188 = null;
var G__17188__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17188__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17188 = function(n,coll){
switch(arguments.length){
case 1:
return G__17188__1.call(this,n);
case 2:
return G__17188__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17188.cljs$core$IFn$_invoke$arity$1 = G__17188__1;
G__17188.cljs$core$IFn$_invoke$arity$2 = G__17188__2;
return G__17188;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17189 = null;
var G__17189__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__17189__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17189 = function(n,coll){
switch(arguments.length){
case 1:
return G__17189__1.call(this,n);
case 2:
return G__17189__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17189.cljs$core$IFn$_invoke$arity$1 = G__17189__1;
G__17189.cljs$core$IFn$_invoke$arity$2 = G__17189__2;
return G__17189;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17190 = null;
var G__17190__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__17190__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__17190 = function(n,coll){
switch(arguments.length){
case 1:
return G__17190__1.call(this,n);
case 2:
return G__17190__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17190.cljs$core$IFn$_invoke$arity$1 = G__17190__1;
G__17190.cljs$core$IFn$_invoke$arity$2 = G__17190__2;
return G__17190;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__17191 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__17191,(0),null);
var arg = cljs.core.nth.call(null,vec__17191,(1),null);
var var$ = cljs.core.nth.call(null,vec__17191,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17194 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__17194,(0),null);
var variable = cljs.core.nth.call(null,vec__17194,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__17197 = agg;
var map__17197__$1 = (((((!((map__17197 == null))))?(((((map__17197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17197):map__17197);
var variable = cljs.core.get.call(null,map__17197__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__17197__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__17197__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__17200 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__17200,(0),null);
var agg_result = cljs.core.nth.call(null,vec__17200,(1),null);
var map__17203 = res__$1;
var map__17203__$1 = (((((!((map__17203 == null))))?(((((map__17203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17203.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17203):map__17203);
var headers = cljs.core.get.call(null,map__17203__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__17203__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__17199_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__17199_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__17205_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__17205_SHARP_);
}),a_idxs);
return cljs.core.reduce.call(null,(function (acc,b_tuple){
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__17206_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17206_SHARP_);
}),b_idxs))){
return cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__17207_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17207_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__17208_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__17208_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__17211,row,b_tuple){
var vec__17212 = p__17211;
var acc = cljs.core.nth.call(null,vec__17212,(0),null);
var b_rows = cljs.core.nth.call(null,vec__17212,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__17209_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17209_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__17210_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__17210_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__17215_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__17215_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17216_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17216_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17218_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17218_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17217_SHARP_){
return cljs.core.range.call(null,(0),p1__17217_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
return fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__17219_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__17219_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__17220_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17220_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17221_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17221_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17223_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17223_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17222_SHARP_){
return cljs.core.range.call(null,(0),p1__17222_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
var matches = fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__17224_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17224_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__17225_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__17225_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__17226_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17226_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__17228_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__17228_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__17227_SHARP_){
return cljs.core.range.call(null,(0),p1__17227_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__17231 = cljs.core.reduce.call(null,(function (p__17234,a_tuple){
var vec__17235 = p__17234;
var c_tuples = cljs.core.nth.call(null,vec__17235,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__17235,(1),null);
var vec__17238 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__17238,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__17238,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,c_tuples,matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__17231,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__17231,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__17229_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17229_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__17230_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__17230_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__17242 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__17242,(0),null);
var _ = cljs.core.nth.call(null,vec__17242,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__17241_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__17241_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__17247 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__17247,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__17247,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__17245_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__17245_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__17246_SHARP_){
return cljs.core.nth.call(null,clause,p1__17246_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__17250,filters,optional_QMARK_){
var map__17251 = p__17250;
var map__17251__$1 = (((((!((map__17251 == null))))?(((((map__17251.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17251.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17251):map__17251);
var tuple_map = map__17251__$1;
var headers = cljs.core.get.call(null,map__17251__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__17251__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__17251__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__17253 = clause;
var k = cljs.core.nth.call(null,vec__17253,(0),null);
var v = cljs.core.nth.call(null,vec__17253,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__17256 = res;
var map__17256__$1 = (((((!((map__17256 == null))))?(((((map__17256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17256):map__17256);
var headers = cljs.core.get.call(null,map__17256__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__17256__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_17313){
var state_val_17314 = (state_17313[(1)]);
if((state_val_17314 === (7))){
var inst_17287 = (state_17313[(7)]);
var inst_17285 = (state_17313[(2)]);
var inst_17286 = fluree.db.util.async.throw_err.call(null,inst_17285);
var inst_17287__$1 = cljs.core.nth.call(null,inst_17286,(0),null);
var inst_17288 = cljs.core.nth.call(null,inst_17286,(1),null);
var inst_17289 = (inst_17287__$1 == null);
var state_17313__$1 = (function (){var statearr_17315 = state_17313;
(statearr_17315[(8)] = inst_17288);

(statearr_17315[(7)] = inst_17287__$1);

return statearr_17315;
})();
if(cljs.core.truth_(inst_17289)){
var statearr_17316_17345 = state_17313__$1;
(statearr_17316_17345[(1)] = (8));

} else {
var statearr_17317_17346 = state_17313__$1;
(statearr_17317_17346[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (1))){
var inst_17265 = optional_clauses;
var inst_17266 = cljs.core.seq.call(null,inst_17265);
var inst_17267 = cljs.core.first.call(null,inst_17266);
var inst_17268 = cljs.core.next.call(null,inst_17266);
var inst_17269 = where_tuples;
var inst_17270 = inst_17265;
var inst_17271 = inst_17269;
var state_17313__$1 = (function (){var statearr_17318 = state_17313;
(statearr_17318[(9)] = inst_17271);

(statearr_17318[(10)] = inst_17270);

(statearr_17318[(11)] = inst_17267);

(statearr_17318[(12)] = inst_17268);

return statearr_17318;
})();
var statearr_17319_17347 = state_17313__$1;
(statearr_17319_17347[(2)] = null);

(statearr_17319_17347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (4))){
var inst_17277 = (state_17313[(13)]);
var inst_17271 = (state_17313[(9)]);
var inst_17278 = (state_17313[(14)]);
var inst_17283 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_17271,inst_17277,inst_17278,true,fuel,max_fuel,opts);
var state_17313__$1 = state_17313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17313__$1,(7),inst_17283);
} else {
if((state_val_17314 === (15))){
var state_17313__$1 = state_17313;
var statearr_17320_17348 = state_17313__$1;
(statearr_17320_17348[(2)] = null);

(statearr_17320_17348[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (13))){
var inst_17304 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
var statearr_17321_17349 = state_17313__$1;
(statearr_17321_17349[(2)] = inst_17304);

(statearr_17321_17349[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (6))){
var inst_17309 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
var statearr_17322_17350 = state_17313__$1;
(statearr_17322_17350[(2)] = inst_17309);

(statearr_17322_17350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (3))){
var inst_17311 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17313__$1,inst_17311);
} else {
if((state_val_17314 === (12))){
var state_17313__$1 = state_17313;
var statearr_17323_17351 = state_17313__$1;
(statearr_17323_17351[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (2))){
var inst_17277 = (state_17313[(13)]);
var inst_17270 = (state_17313[(10)]);
var inst_17276 = cljs.core.seq.call(null,inst_17270);
var inst_17277__$1 = cljs.core.first.call(null,inst_17276);
var inst_17278 = cljs.core.next.call(null,inst_17276);
var state_17313__$1 = (function (){var statearr_17325 = state_17313;
(statearr_17325[(13)] = inst_17277__$1);

(statearr_17325[(14)] = inst_17278);

return statearr_17325;
})();
if(cljs.core.truth_(inst_17277__$1)){
var statearr_17326_17352 = state_17313__$1;
(statearr_17326_17352[(1)] = (4));

} else {
var statearr_17327_17353 = state_17313__$1;
(statearr_17327_17353[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (11))){
var inst_17288 = (state_17313[(8)]);
var inst_17287 = (state_17313[(7)]);
var inst_17270 = inst_17288;
var inst_17271 = inst_17287;
var state_17313__$1 = (function (){var statearr_17328 = state_17313;
(statearr_17328[(9)] = inst_17271);

(statearr_17328[(10)] = inst_17270);

return statearr_17328;
})();
var statearr_17329_17354 = state_17313__$1;
(statearr_17329_17354[(2)] = null);

(statearr_17329_17354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (9))){
var inst_17277 = (state_17313[(13)]);
var inst_17293 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_17277);
var state_17313__$1 = state_17313;
if(cljs.core.truth_(inst_17293)){
var statearr_17330_17355 = state_17313__$1;
(statearr_17330_17355[(1)] = (11));

} else {
var statearr_17331_17356 = state_17313__$1;
(statearr_17331_17356[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (5))){
var inst_17271 = (state_17313[(9)]);
var state_17313__$1 = state_17313;
var statearr_17332_17357 = state_17313__$1;
(statearr_17332_17357[(2)] = inst_17271);

(statearr_17332_17357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (14))){
var inst_17271 = (state_17313[(9)]);
var inst_17288 = (state_17313[(8)]);
var inst_17287 = (state_17313[(7)]);
var inst_17298 = fluree.db.query.analytical.left_outer_join.call(null,inst_17271,inst_17287);
var inst_17270 = inst_17288;
var inst_17271__$1 = inst_17298;
var state_17313__$1 = (function (){var statearr_17333 = state_17313;
(statearr_17333[(9)] = inst_17271__$1);

(statearr_17333[(10)] = inst_17270);

return statearr_17333;
})();
var statearr_17334_17358 = state_17313__$1;
(statearr_17334_17358[(2)] = null);

(statearr_17334_17358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (16))){
var inst_17302 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
var statearr_17336_17359 = state_17313__$1;
(statearr_17336_17359[(2)] = inst_17302);

(statearr_17336_17359[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (10))){
var inst_17306 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
var statearr_17337_17360 = state_17313__$1;
(statearr_17337_17360[(2)] = inst_17306);

(statearr_17337_17360[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (8))){
var inst_17271 = (state_17313[(9)]);
var inst_17288 = (state_17313[(8)]);
var tmp17335 = inst_17271;
var inst_17270 = inst_17288;
var inst_17271__$1 = tmp17335;
var state_17313__$1 = (function (){var statearr_17338 = state_17313;
(statearr_17338[(9)] = inst_17271__$1);

(statearr_17338[(10)] = inst_17270);

return statearr_17338;
})();
var statearr_17339_17361 = state_17313__$1;
(statearr_17339_17361[(2)] = null);

(statearr_17339_17361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____0 = (function (){
var statearr_17340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17340[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__);

(statearr_17340[(1)] = (1));

return statearr_17340;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____1 = (function (state_17313){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_17313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e17341){var ex__2457__auto__ = e17341;
var statearr_17342_17362 = state_17313;
(statearr_17342_17362[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_17313[(4)]))){
var statearr_17343_17363 = state_17313;
(statearr_17343_17363[(1)] = cljs.core.first.call(null,(state_17313[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17364 = state_17313;
state_17313 = G__17364;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__ = function(state_17313){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____1.call(this,state_17313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_17344 = f__2477__auto__.call(null);
(statearr_17344[(6)] = c__2476__auto__);

return statearr_17344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__17366){
var vec__17367 = p__17366;
var var_name = cljs.core.nth.call(null,vec__17367,(0),null);
var var_val = cljs.core.nth.call(null,vec__17367,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__17365_SHARP_){
return cljs.core.conj.call(null,p1__17365_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__17371,p__17372,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__17373 = p__17371;
var map__17373__$1 = (((((!((map__17373 == null))))?(((((map__17373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17373):map__17373);
var q_map = map__17373__$1;
var prefixes = cljs.core.get.call(null,map__17373__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__17374 = p__17372;
var map__17374__$1 = (((((!((map__17374 == null))))?(((((map__17374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17374):map__17374);
var res = map__17374__$1;
var vars = cljs.core.get.call(null,map__17374__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_17583){
var state_val_17584 = (state_17583[(1)]);
if((state_val_17584 === (7))){
var inst_17481 = cljs.core.count.call(null,clause);
var inst_17482 = cljs.core._EQ_.call(null,(3),inst_17481);
var inst_17483 = cljs.core.second.call(null,clause);
var inst_17484 = clojure.string.starts_with_QMARK_.call(null,inst_17483,"fullText:");
var inst_17485 = ((inst_17482) && (inst_17484));
var state_17583__$1 = state_17583;
if(cljs.core.truth_(inst_17485)){
var statearr_17585_17672 = state_17583__$1;
(statearr_17585_17672[(1)] = (31));

} else {
var statearr_17586_17673 = state_17583__$1;
(statearr_17586_17673[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (59))){
var inst_17552 = (state_17583[(7)]);
var inst_17555 = (state_17583[(2)]);
var inst_17556 = fluree.db.util.async.throw_err.call(null,inst_17555);
var inst_17557 = [inst_17556,r];
var inst_17558 = (new cljs.core.PersistentVector(null,2,(5),inst_17552,inst_17557,null));
var state_17583__$1 = state_17583;
var statearr_17587_17674 = state_17583__$1;
(statearr_17587_17674[(2)] = inst_17558);

(statearr_17587_17674[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (20))){
var inst_17445 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17588_17675 = state_17583__$1;
(statearr_17588_17675[(2)] = inst_17445);

(statearr_17588_17675[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (58))){
var inst_17561 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17589_17676 = state_17583__$1;
(statearr_17589_17676[(2)] = inst_17561);

(statearr_17589_17676[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (27))){
var inst_17475 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17590_17677 = state_17583__$1;
(statearr_17590_17677[(2)] = inst_17475);

(statearr_17590_17677[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (1))){
var state_17583__$1 = state_17583;
var statearr_17591_17678 = state_17583__$1;
(statearr_17591_17678[(2)] = null);

(statearr_17591_17678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (24))){
var inst_17439 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17592_17679 = state_17583__$1;
(statearr_17592_17679[(2)] = inst_17439);

(statearr_17592_17679[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (55))){
var inst_17563 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17593_17680 = state_17583__$1;
(statearr_17593_17680[(2)] = inst_17563);

(statearr_17593_17680[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (39))){
var inst_17517 = cljs.core.count.call(null,clause);
var inst_17518 = cljs.core._EQ_.call(null,(2),inst_17517);
var state_17583__$1 = state_17583;
if(inst_17518){
var statearr_17594_17681 = state_17583__$1;
(statearr_17594_17681[(1)] = (42));

} else {
var statearr_17595_17682 = state_17583__$1;
(statearr_17595_17682[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (46))){
var state_17583__$1 = state_17583;
var statearr_17596_17683 = state_17583__$1;
(statearr_17596_17683[(2)] = null);

(statearr_17596_17683[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (4))){
var inst_17377 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17597_17684 = state_17583__$1;
(statearr_17597_17684[(2)] = inst_17377);

(statearr_17597_17684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (54))){
var state_17583__$1 = state_17583;
var statearr_17598_17685 = state_17583__$1;
(statearr_17598_17685[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (15))){
var inst_17477 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17600_17686 = state_17583__$1;
(statearr_17600_17686[(2)] = inst_17477);

(statearr_17600_17686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (48))){
var inst_17534 = (state_17583[(8)]);
var inst_17532 = (state_17583[(2)]);
var inst_17533 = fluree.db.util.async.throw_err.call(null,inst_17532);
var inst_17534__$1 = cljs.core.nth.call(null,inst_17533,(0),null);
var inst_17535 = cljs.core.nth.call(null,inst_17533,(1),null);
var inst_17536 = cljs.core._EQ_.call(null,"$wd",inst_17534__$1);
var state_17583__$1 = (function (){var statearr_17601 = state_17583;
(statearr_17601[(8)] = inst_17534__$1);

(statearr_17601[(9)] = inst_17535);

return statearr_17601;
})();
if(inst_17536){
var statearr_17602_17687 = state_17583__$1;
(statearr_17602_17687[(1)] = (49));

} else {
var statearr_17603_17688 = state_17583__$1;
(statearr_17603_17688[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (50))){
var inst_17535 = (state_17583[(9)]);
var inst_17543 = cljs.core.second.call(null,inst_17535);
var inst_17544 = clojure.string.starts_with_QMARK_.call(null,inst_17543,"fullText:");
var state_17583__$1 = state_17583;
if(inst_17544){
var statearr_17604_17689 = state_17583__$1;
(statearr_17604_17689[(1)] = (53));

} else {
var statearr_17605_17690 = state_17583__$1;
(statearr_17605_17690[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (21))){
var inst_17423 = (state_17583[(10)]);
var inst_17390 = (state_17583[(11)]);
var inst_17413 = (state_17583[(12)]);
var inst_17415 = (state_17583[(13)]);
var inst_17414 = (state_17583[(14)]);
var inst_17386 = (state_17583[(15)]);
var inst_17411 = (state_17583[(16)]);
var inst_17422 = (state_17583[(17)]);
var inst_17416 = (state_17583[(18)]);
var inst_17427 = (state_17583[(2)]);
var inst_17428 = fluree.db.util.async.throw_err.call(null,inst_17427);
var inst_17429 = (function (){var first__17410 = inst_17413;
var new_res = inst_17428;
var seq__17419 = inst_17423;
var rest = inst_17423;
var tuples = inst_17416;
var seq__17409 = inst_17414;
var vec__17408 = inst_17411;
var vec__17418 = inst_17415;
var pred__17387 = inst_17390;
var expr__17388 = inst_17386;
var first__17420 = inst_17422;
var segment_type = inst_17386;
var G__17407 = inst_17415;
var clause_group = inst_17422;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_17430 = cljs.core.keys.call(null,vars);
var inst_17431 = cljs.core.reduce.call(null,inst_17429,inst_17428,inst_17430);
var inst_17432 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_17431);
var state_17583__$1 = (function (){var statearr_17606 = state_17583;
(statearr_17606[(19)] = inst_17432);

return statearr_17606;
})();
if(cljs.core.truth_(inst_17416)){
var statearr_17607_17691 = state_17583__$1;
(statearr_17607_17691[(1)] = (22));

} else {
var statearr_17608_17692 = state_17583__$1;
(statearr_17608_17692[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (31))){
var inst_17487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17488 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_17489 = [inst_17488,r];
var inst_17490 = (new cljs.core.PersistentVector(null,2,(5),inst_17487,inst_17489,null));
var state_17583__$1 = state_17583;
var statearr_17609_17693 = state_17583__$1;
(statearr_17609_17693[(2)] = inst_17490);

(statearr_17609_17693[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (32))){
var inst_17492 = cljs.core.count.call(null,clause);
var inst_17493 = cljs.core._EQ_.call(null,(3),inst_17492);
var inst_17494 = cljs.core.second.call(null,clause);
var inst_17495 = cljs.core._EQ_.call(null,inst_17494,"rdf:type");
var inst_17496 = ((inst_17493) && (inst_17495));
var state_17583__$1 = state_17583;
if(cljs.core.truth_(inst_17496)){
var statearr_17610_17694 = state_17583__$1;
(statearr_17610_17694[(1)] = (34));

} else {
var statearr_17611_17695 = state_17583__$1;
(statearr_17611_17695[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (40))){
var inst_17572 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17612_17696 = state_17583__$1;
(statearr_17612_17696[(2)] = inst_17572);

(statearr_17612_17696[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (56))){
var inst_17534 = (state_17583[(8)]);
var inst_17535 = (state_17583[(9)]);
var inst_17552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17553 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_17534,res,inst_17535,fuel,max_fuel);
var state_17583__$1 = (function (){var statearr_17613 = state_17583;
(statearr_17613[(7)] = inst_17552);

return statearr_17613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(59),inst_17553);
} else {
if((state_val_17584 === (33))){
var inst_17576 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17614_17697 = state_17583__$1;
(statearr_17614_17697[(2)] = inst_17576);

(statearr_17614_17697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (13))){
var inst_17411 = (state_17583[(16)]);
var inst_17411__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17412 = cljs.core.seq.call(null,inst_17411__$1);
var inst_17413 = cljs.core.first.call(null,inst_17412);
var inst_17414 = cljs.core.next.call(null,inst_17412);
var inst_17415 = inst_17411__$1;
var inst_17416 = null;
var state_17583__$1 = (function (){var statearr_17615 = state_17583;
(statearr_17615[(12)] = inst_17413);

(statearr_17615[(13)] = inst_17415);

(statearr_17615[(14)] = inst_17414);

(statearr_17615[(16)] = inst_17411__$1);

(statearr_17615[(18)] = inst_17416);

return statearr_17615;
})();
var statearr_17616_17698 = state_17583__$1;
(statearr_17616_17698[(2)] = null);

(statearr_17616_17698[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (22))){
var inst_17432 = (state_17583[(19)]);
var inst_17423 = (state_17583[(10)]);
var inst_17416 = (state_17583[(18)]);
var inst_17434 = fluree.db.query.analytical.outer_union.call(null,inst_17416,inst_17432);
var inst_17415 = inst_17423;
var inst_17416__$1 = inst_17434;
var state_17583__$1 = (function (){var statearr_17617 = state_17583;
(statearr_17617[(13)] = inst_17415);

(statearr_17617[(18)] = inst_17416__$1);

return statearr_17617;
})();
var statearr_17618_17699 = state_17583__$1;
(statearr_17618_17699[(2)] = null);

(statearr_17618_17699[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (36))){
var inst_17574 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17619_17700 = state_17583__$1;
(statearr_17619_17700[(2)] = inst_17574);

(statearr_17619_17700[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (41))){
var inst_17509 = (state_17583[(20)]);
var inst_17512 = (state_17583[(2)]);
var inst_17513 = fluree.db.util.async.throw_err.call(null,inst_17512);
var inst_17514 = [inst_17513,r];
var inst_17515 = (new cljs.core.PersistentVector(null,2,(5),inst_17509,inst_17514,null));
var state_17583__$1 = state_17583;
var statearr_17620_17701 = state_17583__$1;
(statearr_17620_17701[(2)] = inst_17515);

(statearr_17620_17701[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (43))){
var state_17583__$1 = state_17583;
var statearr_17621_17702 = state_17583__$1;
(statearr_17621_17702[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (29))){
var inst_17386 = (state_17583[(15)]);
var inst_17469 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17386)].join('');
var inst_17470 = (new Error(inst_17469));
var inst_17471 = (function(){throw inst_17470})();
var state_17583__$1 = state_17583;
var statearr_17623_17703 = state_17583__$1;
(statearr_17623_17703[(2)] = inst_17471);

(statearr_17623_17703[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (44))){
var inst_17570 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17624_17704 = state_17583__$1;
(statearr_17624_17704[(2)] = inst_17570);

(statearr_17624_17704[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (6))){
var inst_17390 = (state_17583[(11)]);
var inst_17386 = (state_17583[(15)]);
var inst_17385 = cljs.core.keys.call(null,clause);
var inst_17386__$1 = cljs.core.first.call(null,inst_17385);
var inst_17390__$1 = cljs.core._EQ_;
var inst_17391 = inst_17390__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_17386__$1);
var state_17583__$1 = (function (){var statearr_17625 = state_17583;
(statearr_17625[(11)] = inst_17390__$1);

(statearr_17625[(15)] = inst_17386__$1);

return statearr_17625;
})();
if(cljs.core.truth_(inst_17391)){
var statearr_17626_17705 = state_17583__$1;
(statearr_17626_17705[(1)] = (9));

} else {
var statearr_17627_17706 = state_17583__$1;
(statearr_17627_17706[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (28))){
var inst_17463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17464 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17465 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_17464,optional_QMARK_);
var inst_17466 = [inst_17465,r];
var inst_17467 = (new cljs.core.PersistentVector(null,2,(5),inst_17463,inst_17466,null));
var state_17583__$1 = state_17583;
var statearr_17628_17707 = state_17583__$1;
(statearr_17628_17707[(2)] = inst_17467);

(statearr_17628_17707[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (51))){
var inst_17565 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17629_17708 = state_17583__$1;
(statearr_17629_17708[(2)] = inst_17565);

(statearr_17629_17708[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (25))){
var inst_17390 = (state_17583[(11)]);
var inst_17386 = (state_17583[(15)]);
var inst_17451 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17452 = (function (){var segment_type = inst_17386;
var pred__17387 = inst_17390;
var expr__17388 = inst_17386;
var bindings = inst_17451;
return (function (p1__17370_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__17370_SHARP_);
});
})();
var inst_17453 = cljs.core.map.call(null,inst_17452,inst_17451);
var inst_17454 = cljs.core.PersistentHashMap.EMPTY;
var inst_17455 = cljs.core.into.call(null,inst_17454,inst_17453);
var inst_17456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17457 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_17455);
var inst_17458 = [inst_17457,r];
var inst_17459 = (new cljs.core.PersistentVector(null,2,(5),inst_17456,inst_17458,null));
var state_17583__$1 = state_17583;
var statearr_17630_17709 = state_17583__$1;
(statearr_17630_17709[(2)] = inst_17459);

(statearr_17630_17709[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (34))){
var inst_17498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17499 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_17583__$1 = (function (){var statearr_17631 = state_17583;
(statearr_17631[(21)] = inst_17498);

return statearr_17631;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(37),inst_17499);
} else {
if((state_val_17584 === (17))){
var inst_17447 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17632_17710 = state_17583__$1;
(statearr_17632_17710[(2)] = inst_17447);

(statearr_17632_17710[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (3))){
var inst_17581 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17583__$1,inst_17581);
} else {
if((state_val_17584 === (12))){
var inst_17393 = (state_17583[(22)]);
var inst_17397 = (state_17583[(2)]);
var inst_17398 = fluree.db.util.async.throw_err.call(null,inst_17397);
var inst_17399 = [inst_17398,r];
var inst_17400 = (new cljs.core.PersistentVector(null,2,(5),inst_17393,inst_17399,null));
var state_17583__$1 = state_17583;
var statearr_17633_17711 = state_17583__$1;
(statearr_17633_17711[(2)] = inst_17400);

(statearr_17633_17711[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (2))){
var _ = (function (){var statearr_17634 = state_17583;
(statearr_17634[(4)] = cljs.core.cons.call(null,(5),(state_17583[(4)])));

return statearr_17634;
})();
var inst_17383 = cljs.core.map_QMARK_.call(null,clause);
var state_17583__$1 = state_17583;
if(inst_17383){
var statearr_17635_17712 = state_17583__$1;
(statearr_17635_17712[(1)] = (6));

} else {
var statearr_17636_17713 = state_17583__$1;
(statearr_17636_17713[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (23))){
var inst_17432 = (state_17583[(19)]);
var inst_17423 = (state_17583[(10)]);
var inst_17415 = inst_17423;
var inst_17416 = inst_17432;
var state_17583__$1 = (function (){var statearr_17637 = state_17583;
(statearr_17637[(13)] = inst_17415);

(statearr_17637[(18)] = inst_17416);

return statearr_17637;
})();
var statearr_17638_17714 = state_17583__$1;
(statearr_17638_17714[(2)] = null);

(statearr_17638_17714[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (47))){
var inst_17568 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17639_17715 = state_17583__$1;
(statearr_17639_17715[(2)] = inst_17568);

(statearr_17639_17715[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (35))){
var inst_17506 = cljs.core.count.call(null,clause);
var inst_17507 = cljs.core._EQ_.call(null,(3),inst_17506);
var state_17583__$1 = state_17583;
if(inst_17507){
var statearr_17640_17716 = state_17583__$1;
(statearr_17640_17716[(1)] = (38));

} else {
var statearr_17641_17717 = state_17583__$1;
(statearr_17641_17717[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (19))){
var inst_17416 = (state_17583[(18)]);
var inst_17441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17442 = [inst_17416,r];
var inst_17443 = (new cljs.core.PersistentVector(null,2,(5),inst_17441,inst_17442,null));
var state_17583__$1 = state_17583;
var statearr_17642_17718 = state_17583__$1;
(statearr_17642_17718[(2)] = inst_17443);

(statearr_17642_17718[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (57))){
var state_17583__$1 = state_17583;
var statearr_17643_17719 = state_17583__$1;
(statearr_17643_17719[(2)] = null);

(statearr_17643_17719[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (11))){
var inst_17479 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17645_17720 = state_17583__$1;
(statearr_17645_17720[(2)] = inst_17479);

(statearr_17645_17720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (9))){
var inst_17393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17394 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_17395 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_17394,res,fuel,max_fuel,opts);
var state_17583__$1 = (function (){var statearr_17646 = state_17583;
(statearr_17646[(22)] = inst_17393);

return statearr_17646;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(12),inst_17395);
} else {
if((state_val_17584 === (5))){
var _ = (function (){var statearr_17647 = state_17583;
(statearr_17647[(4)] = cljs.core.rest.call(null,(state_17583[(4)])));

return statearr_17647;
})();
var state_17583__$1 = state_17583;
var ex17644 = (state_17583__$1[(2)]);
var statearr_17648_17721 = state_17583__$1;
(statearr_17648_17721[(5)] = ex17644);


if((ex17644 instanceof Error)){
var statearr_17649_17722 = state_17583__$1;
(statearr_17649_17722[(1)] = (4));

(statearr_17649_17722[(5)] = null);

} else {
throw ex17644;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (14))){
var inst_17390 = (state_17583[(11)]);
var inst_17386 = (state_17583[(15)]);
var inst_17449 = inst_17390.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_17386);
var state_17583__$1 = state_17583;
if(cljs.core.truth_(inst_17449)){
var statearr_17650_17723 = state_17583__$1;
(statearr_17650_17723[(1)] = (25));

} else {
var statearr_17651_17724 = state_17583__$1;
(statearr_17651_17724[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (45))){
var inst_17530 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_17583__$1 = state_17583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(48),inst_17530);
} else {
if((state_val_17584 === (53))){
var inst_17534 = (state_17583[(8)]);
var inst_17535 = (state_17583[(9)]);
var inst_17546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17547 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_17534,res,inst_17535);
var inst_17548 = [inst_17547,r];
var inst_17549 = (new cljs.core.PersistentVector(null,2,(5),inst_17546,inst_17548,null));
var state_17583__$1 = state_17583;
var statearr_17652_17725 = state_17583__$1;
(statearr_17652_17725[(2)] = inst_17549);

(statearr_17652_17725[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (26))){
var inst_17390 = (state_17583[(11)]);
var inst_17386 = (state_17583[(15)]);
var inst_17461 = inst_17390.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_17386);
var state_17583__$1 = state_17583;
if(cljs.core.truth_(inst_17461)){
var statearr_17653_17726 = state_17583__$1;
(statearr_17653_17726[(1)] = (28));

} else {
var statearr_17654_17727 = state_17583__$1;
(statearr_17654_17727[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (16))){
var inst_17415 = (state_17583[(13)]);
var inst_17422 = (state_17583[(17)]);
var inst_17421 = cljs.core.seq.call(null,inst_17415);
var inst_17422__$1 = cljs.core.first.call(null,inst_17421);
var inst_17423 = cljs.core.next.call(null,inst_17421);
var state_17583__$1 = (function (){var statearr_17655 = state_17583;
(statearr_17655[(10)] = inst_17423);

(statearr_17655[(17)] = inst_17422__$1);

return statearr_17655;
})();
if(cljs.core.truth_(inst_17422__$1)){
var statearr_17656_17728 = state_17583__$1;
(statearr_17656_17728[(1)] = (18));

} else {
var statearr_17657_17729 = state_17583__$1;
(statearr_17657_17729[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (38))){
var inst_17509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17510 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_17583__$1 = (function (){var statearr_17658 = state_17583;
(statearr_17658[(20)] = inst_17509);

return statearr_17658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(41),inst_17510);
} else {
if((state_val_17584 === (30))){
var inst_17473 = (state_17583[(2)]);
var state_17583__$1 = state_17583;
var statearr_17659_17730 = state_17583__$1;
(statearr_17659_17730[(2)] = inst_17473);

(statearr_17659_17730[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (10))){
var inst_17390 = (state_17583[(11)]);
var inst_17386 = (state_17583[(15)]);
var inst_17402 = inst_17390.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_17386);
var state_17583__$1 = state_17583;
if(cljs.core.truth_(inst_17402)){
var statearr_17660_17731 = state_17583__$1;
(statearr_17660_17731[(1)] = (13));

} else {
var statearr_17661_17732 = state_17583__$1;
(statearr_17661_17732[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (18))){
var inst_17422 = (state_17583[(17)]);
var inst_17425 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_17422,q_map,vars,fuel,max_fuel,opts);
var state_17583__$1 = state_17583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(21),inst_17425);
} else {
if((state_val_17584 === (52))){
var inst_17540 = (state_17583[(2)]);
var inst_17541 = fluree.db.util.async.throw_err.call(null,inst_17540);
var state_17583__$1 = state_17583;
var statearr_17662_17733 = state_17583__$1;
(statearr_17662_17733[(2)] = inst_17541);

(statearr_17662_17733[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (42))){
var inst_17520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17521 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_17522 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_17521);
var inst_17523 = [inst_17522,r];
var inst_17524 = (new cljs.core.PersistentVector(null,2,(5),inst_17520,inst_17523,null));
var state_17583__$1 = state_17583;
var statearr_17663_17734 = state_17583__$1;
(statearr_17663_17734[(2)] = inst_17524);

(statearr_17663_17734[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (37))){
var inst_17498 = (state_17583[(21)]);
var inst_17501 = (state_17583[(2)]);
var inst_17502 = fluree.db.util.async.throw_err.call(null,inst_17501);
var inst_17503 = [inst_17502,r];
var inst_17504 = (new cljs.core.PersistentVector(null,2,(5),inst_17498,inst_17503,null));
var state_17583__$1 = state_17583;
var statearr_17664_17735 = state_17583__$1;
(statearr_17664_17735[(2)] = inst_17504);

(statearr_17664_17735[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (8))){
var inst_17578 = (state_17583[(2)]);
var _ = (function (){var statearr_17665 = state_17583;
(statearr_17665[(4)] = cljs.core.rest.call(null,(state_17583[(4)])));

return statearr_17665;
})();
var state_17583__$1 = state_17583;
var statearr_17666_17736 = state_17583__$1;
(statearr_17666_17736[(2)] = inst_17578);

(statearr_17666_17736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17584 === (49))){
var inst_17535 = (state_17583[(9)]);
var inst_17538 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_17535,r,res,optional_QMARK_,fuel,max_fuel);
var state_17583__$1 = state_17583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17583__$1,(52),inst_17538);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_17667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17667[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__);

(statearr_17667[(1)] = (1));

return statearr_17667;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____1 = (function (state_17583){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_17583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e17668){var ex__2457__auto__ = e17668;
var statearr_17669_17737 = state_17583;
(statearr_17669_17737[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_17583[(4)]))){
var statearr_17670_17738 = state_17583;
(statearr_17670_17738[(1)] = cljs.core.first.call(null,(state_17583[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17739 = state_17583;
state_17583 = G__17739;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__ = function(state_17583){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____1.call(this,state_17583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_17671 = f__2477__auto__.call(null);
(statearr_17671[(6)] = c__2476__auto__);

return statearr_17671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__17741 = arguments.length;
switch (G__17741) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_17821){
var state_val_17822 = (state_17821[(1)]);
if((state_val_17822 === (7))){
var inst_17816 = (state_17821[(2)]);
var _ = (function (){var statearr_17823 = state_17821;
(statearr_17823[(4)] = cljs.core.rest.call(null,(state_17821[(4)])));

return statearr_17823;
})();
var state_17821__$1 = state_17821;
var statearr_17824_17872 = state_17821__$1;
(statearr_17824_17872[(2)] = inst_17816);

(statearr_17824_17872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (20))){
var inst_17781 = (state_17821[(7)]);
var inst_17793 = (state_17821[(2)]);
var inst_17763 = inst_17781;
var inst_17764 = inst_17793;
var state_17821__$1 = (function (){var statearr_17825 = state_17821;
(statearr_17825[(8)] = inst_17763);

(statearr_17825[(9)] = inst_17764);

return statearr_17825;
})();
var statearr_17826_17873 = state_17821__$1;
(statearr_17826_17873[(2)] = null);

(statearr_17826_17873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (1))){
var state_17821__$1 = state_17821;
var statearr_17827_17874 = state_17821__$1;
(statearr_17827_17874[(2)] = null);

(statearr_17827_17874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (24))){
var inst_17780 = (state_17821[(10)]);
var inst_17764 = (state_17821[(9)]);
var inst_17781 = (state_17821[(7)]);
var inst_17801 = fluree.db.query.analytical.inner_join.call(null,inst_17764,inst_17780);
var inst_17763 = inst_17781;
var inst_17764__$1 = inst_17801;
var state_17821__$1 = (function (){var statearr_17828 = state_17821;
(statearr_17828[(8)] = inst_17763);

(statearr_17828[(9)] = inst_17764__$1);

return statearr_17828;
})();
var statearr_17829_17875 = state_17821__$1;
(statearr_17829_17875[(2)] = null);

(statearr_17829_17875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (4))){
var inst_17742 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17831_17876 = state_17821__$1;
(statearr_17831_17876[(2)] = inst_17742);

(statearr_17831_17876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (15))){
var inst_17780 = (state_17821[(10)]);
var state_17821__$1 = state_17821;
if(cljs.core.truth_(inst_17780)){
var statearr_17832_17877 = state_17821__$1;
(statearr_17832_17877[(1)] = (18));

} else {
var statearr_17833_17878 = state_17821__$1;
(statearr_17833_17878[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (21))){
var inst_17764 = (state_17821[(9)]);
var inst_17781 = (state_17821[(7)]);
var tmp17830 = inst_17764;
var inst_17763 = inst_17781;
var inst_17764__$1 = tmp17830;
var state_17821__$1 = (function (){var statearr_17834 = state_17821;
(statearr_17834[(8)] = inst_17763);

(statearr_17834[(9)] = inst_17764__$1);

return statearr_17834;
})();
var statearr_17835_17879 = state_17821__$1;
(statearr_17835_17879[(2)] = null);

(statearr_17835_17879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (13))){
var inst_17764 = (state_17821[(9)]);
var inst_17787 = cljs.core.dissoc.call(null,inst_17764,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_17788 = cljs.core.empty_QMARK_.call(null,inst_17787);
var state_17821__$1 = state_17821;
if(inst_17788){
var statearr_17836_17880 = state_17821__$1;
(statearr_17836_17880[(1)] = (15));

} else {
var statearr_17837_17881 = state_17821__$1;
(statearr_17837_17881[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (22))){
var state_17821__$1 = state_17821;
var statearr_17838_17882 = state_17821__$1;
(statearr_17838_17882[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (6))){
var inst_17763 = (state_17821[(8)]);
var inst_17770 = (state_17821[(11)]);
var inst_17769 = cljs.core.seq.call(null,inst_17763);
var inst_17770__$1 = cljs.core.first.call(null,inst_17769);
var inst_17771 = cljs.core.next.call(null,inst_17769);
var state_17821__$1 = (function (){var statearr_17840 = state_17821;
(statearr_17840[(11)] = inst_17770__$1);

(statearr_17840[(12)] = inst_17771);

return statearr_17840;
})();
if(cljs.core.truth_(inst_17770__$1)){
var statearr_17841_17883 = state_17821__$1;
(statearr_17841_17883[(1)] = (8));

} else {
var statearr_17842_17884 = state_17821__$1;
(statearr_17842_17884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (25))){
var state_17821__$1 = state_17821;
var statearr_17843_17885 = state_17821__$1;
(statearr_17843_17885[(2)] = null);

(statearr_17843_17885[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (17))){
var inst_17809 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17844_17886 = state_17821__$1;
(statearr_17844_17886[(2)] = inst_17809);

(statearr_17844_17886[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (3))){
var inst_17819 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17821__$1,inst_17819);
} else {
if((state_val_17822 === (12))){
var inst_17780 = (state_17821[(10)]);
var inst_17781 = (state_17821[(7)]);
var inst_17763 = inst_17781;
var inst_17764 = inst_17780;
var state_17821__$1 = (function (){var statearr_17845 = state_17821;
(statearr_17845[(8)] = inst_17763);

(statearr_17845[(9)] = inst_17764);

return statearr_17845;
})();
var statearr_17846_17887 = state_17821__$1;
(statearr_17846_17887[(2)] = null);

(statearr_17846_17887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (2))){
var _ = (function (){var statearr_17847 = state_17821;
(statearr_17847[(4)] = cljs.core.cons.call(null,(5),(state_17821[(4)])));

return statearr_17847;
})();
var inst_17755 = where;
var inst_17756 = cljs.core.seq.call(null,inst_17755);
var inst_17757 = cljs.core.first.call(null,inst_17756);
var inst_17758 = cljs.core.next.call(null,inst_17756);
var inst_17759 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17760 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_17761 = [inst_17760];
var inst_17762 = cljs.core.PersistentHashMap.fromArrays(inst_17759,inst_17761);
var inst_17763 = inst_17755;
var inst_17764 = inst_17762;
var state_17821__$1 = (function (){var statearr_17848 = state_17821;
(statearr_17848[(13)] = inst_17758);

(statearr_17848[(8)] = inst_17763);

(statearr_17848[(9)] = inst_17764);

(statearr_17848[(14)] = inst_17757);

return statearr_17848;
})();
var statearr_17849_17888 = state_17821__$1;
(statearr_17849_17888[(2)] = null);

(statearr_17849_17888[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (23))){
var inst_17807 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17850_17889 = state_17821__$1;
(statearr_17850_17889[(2)] = inst_17807);

(statearr_17850_17889[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (19))){
var inst_17764 = (state_17821[(9)]);
var state_17821__$1 = state_17821;
var statearr_17851_17890 = state_17821__$1;
(statearr_17851_17890[(2)] = inst_17764);

(statearr_17851_17890[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (11))){
var inst_17770 = (state_17821[(11)]);
var inst_17778 = (state_17821[(2)]);
var inst_17779 = fluree.db.util.async.throw_err.call(null,inst_17778);
var inst_17780 = cljs.core.nth.call(null,inst_17779,(0),null);
var inst_17781 = cljs.core.nth.call(null,inst_17779,(1),null);
var inst_17782 = cljs.core.count.call(null,inst_17770);
var inst_17783 = cljs.core._EQ_.call(null,(2),inst_17782);
var state_17821__$1 = (function (){var statearr_17853 = state_17821;
(statearr_17853[(10)] = inst_17780);

(statearr_17853[(7)] = inst_17781);

return statearr_17853;
})();
if(inst_17783){
var statearr_17854_17891 = state_17821__$1;
(statearr_17854_17891[(1)] = (12));

} else {
var statearr_17855_17892 = state_17821__$1;
(statearr_17855_17892[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (9))){
var inst_17764 = (state_17821[(9)]);
var state_17821__$1 = state_17821;
var statearr_17856_17893 = state_17821__$1;
(statearr_17856_17893[(2)] = inst_17764);

(statearr_17856_17893[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (5))){
var _ = (function (){var statearr_17857 = state_17821;
(statearr_17857[(4)] = cljs.core.rest.call(null,(state_17821[(4)])));

return statearr_17857;
})();
var state_17821__$1 = state_17821;
var ex17852 = (state_17821__$1[(2)]);
var statearr_17858_17894 = state_17821__$1;
(statearr_17858_17894[(5)] = ex17852);


if((ex17852 instanceof Error)){
var statearr_17859_17895 = state_17821__$1;
(statearr_17859_17895[(1)] = (4));

(statearr_17859_17895[(5)] = null);

} else {
throw ex17852;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (14))){
var inst_17811 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17860_17896 = state_17821__$1;
(statearr_17860_17896[(2)] = inst_17811);

(statearr_17860_17896[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (26))){
var inst_17805 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17861_17897 = state_17821__$1;
(statearr_17861_17897[(2)] = inst_17805);

(statearr_17861_17897[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (16))){
var inst_17780 = (state_17821[(10)]);
var inst_17796 = (inst_17780 == null);
var state_17821__$1 = state_17821;
if(cljs.core.truth_(inst_17796)){
var statearr_17862_17898 = state_17821__$1;
(statearr_17862_17898[(1)] = (21));

} else {
var statearr_17863_17899 = state_17821__$1;
(statearr_17863_17899[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (10))){
var inst_17814 = (state_17821[(2)]);
var state_17821__$1 = state_17821;
var statearr_17864_17900 = state_17821__$1;
(statearr_17864_17900[(2)] = inst_17814);

(statearr_17864_17900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (18))){
var inst_17780 = (state_17821[(10)]);
var state_17821__$1 = state_17821;
var statearr_17865_17901 = state_17821__$1;
(statearr_17865_17901[(2)] = inst_17780);

(statearr_17865_17901[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17822 === (8))){
var inst_17770 = (state_17821[(11)]);
var inst_17771 = (state_17821[(12)]);
var inst_17764 = (state_17821[(9)]);
var inst_17776 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_17764,inst_17770,inst_17771,false,fuel,max_fuel,opts);
var state_17821__$1 = state_17821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17821__$1,(11),inst_17776);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2454__auto__ = null;
var fluree$db$query$analytical$state_machine__2454__auto____0 = (function (){
var statearr_17866 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17866[(0)] = fluree$db$query$analytical$state_machine__2454__auto__);

(statearr_17866[(1)] = (1));

return statearr_17866;
});
var fluree$db$query$analytical$state_machine__2454__auto____1 = (function (state_17821){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_17821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e17867){var ex__2457__auto__ = e17867;
var statearr_17868_17902 = state_17821;
(statearr_17868_17902[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_17821[(4)]))){
var statearr_17869_17903 = state_17821;
(statearr_17869_17903[(1)] = cljs.core.first.call(null,(state_17821[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17904 = state_17821;
state_17821 = G__17904;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2454__auto__ = function(state_17821){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2454__auto____1.call(this,state_17821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2454__auto____0;
fluree$db$query$analytical$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2454__auto____1;
return fluree$db$query$analytical$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_17870 = f__2477__auto__.call(null);
(statearr_17870[(6)] = c__2476__auto__);

return statearr_17870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_17965){
var state_val_17966 = (state_17965[(1)]);
if((state_val_17966 === (7))){
var state_17965__$1 = state_17965;
var statearr_17967_18007 = state_17965__$1;
(statearr_17967_18007[(2)] = false);

(statearr_17967_18007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (20))){
var inst_17937 = (state_17965[(7)]);
var inst_17952 = (state_17965[(8)]);
var inst_17954 = cljs.core.pr_str.call(null,q_map);
var inst_17955 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_17954].join('');
var inst_17956 = fluree.db.util.log.warn.call(null,inst_17955);
var inst_17957 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_17952,inst_17937,null);
var state_17965__$1 = (function (){var statearr_17968 = state_17965;
(statearr_17968[(9)] = inst_17956);

return statearr_17968;
})();
var statearr_17969_18008 = state_17965__$1;
(statearr_17969_18008[(2)] = inst_17957);

(statearr_17969_18008[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (1))){
var state_17965__$1 = state_17965;
var statearr_17970_18009 = state_17965__$1;
(statearr_17970_18009[(2)] = null);

(statearr_17970_18009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (4))){
var inst_17905 = (state_17965[(2)]);
var state_17965__$1 = state_17965;
var statearr_17971_18010 = state_17965__$1;
(statearr_17971_18010[(2)] = inst_17905);

(statearr_17971_18010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (15))){
var inst_17936 = (state_17965[(10)]);
var inst_17940 = (state_17965[(2)]);
var inst_17941 = fluree.db.util.async.throw_err.call(null,inst_17940);
var state_17965__$1 = (function (){var statearr_17972 = state_17965;
(statearr_17972[(11)] = inst_17941);

return statearr_17972;
})();
if(cljs.core.truth_(inst_17936)){
var statearr_17973_18011 = state_17965__$1;
(statearr_17973_18011[(1)] = (16));

} else {
var statearr_17974_18012 = state_17965__$1;
(statearr_17974_18012[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (21))){
var inst_17952 = (state_17965[(8)]);
var state_17965__$1 = state_17965;
var statearr_17975_18013 = state_17965__$1;
(statearr_17975_18013[(2)] = inst_17952);

(statearr_17975_18013[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (13))){
var inst_17912 = (state_17965[(12)]);
var state_17965__$1 = state_17965;
var statearr_17976_18014 = state_17965__$1;
(statearr_17976_18014[(2)] = inst_17912);

(statearr_17976_18014[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (22))){
var inst_17960 = (state_17965[(2)]);
var _ = (function (){var statearr_17977 = state_17965;
(statearr_17977[(4)] = cljs.core.rest.call(null,(state_17965[(4)])));

return statearr_17977;
})();
var state_17965__$1 = state_17965;
var statearr_17978_18015 = state_17965__$1;
(statearr_17978_18015[(2)] = inst_17960);

(statearr_17978_18015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (6))){
var inst_17912 = (state_17965[(12)]);
var inst_17917 = inst_17912.cljs$lang$protocol_mask$partition0$;
var inst_17918 = (inst_17917 & (64));
var inst_17919 = inst_17912.cljs$core$ISeq$;
var inst_17920 = (cljs.core.PROTOCOL_SENTINEL === inst_17919);
var inst_17921 = ((inst_17918) || (inst_17920));
var state_17965__$1 = state_17965;
if(cljs.core.truth_(inst_17921)){
var statearr_17979_18016 = state_17965__$1;
(statearr_17979_18016[(1)] = (9));

} else {
var statearr_17980_18017 = state_17965__$1;
(statearr_17980_18017[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (17))){
var inst_17941 = (state_17965[(11)]);
var state_17965__$1 = state_17965;
var statearr_17981_18018 = state_17965__$1;
(statearr_17981_18018[(2)] = inst_17941);

(statearr_17981_18018[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (3))){
var inst_17963 = (state_17965[(2)]);
var state_17965__$1 = state_17965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17965__$1,inst_17963);
} else {
if((state_val_17966 === (12))){
var inst_17912 = (state_17965[(12)]);
var inst_17930 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17912);
var state_17965__$1 = state_17965;
var statearr_17982_18019 = state_17965__$1;
(statearr_17982_18019[(2)] = inst_17930);

(statearr_17982_18019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (2))){
var inst_17912 = (state_17965[(12)]);
var _ = (function (){var statearr_17983 = state_17965;
(statearr_17983[(4)] = cljs.core.cons.call(null,(5),(state_17965[(4)])));

return statearr_17983;
})();
var inst_17912__$1 = q_map;
var inst_17914 = (inst_17912__$1 == null);
var inst_17915 = cljs.core.not.call(null,inst_17914);
var state_17965__$1 = (function (){var statearr_17984 = state_17965;
(statearr_17984[(12)] = inst_17912__$1);

return statearr_17984;
})();
if(inst_17915){
var statearr_17985_18020 = state_17965__$1;
(statearr_17985_18020[(1)] = (6));

} else {
var statearr_17986_18021 = state_17965__$1;
(statearr_17986_18021[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (19))){
var inst_17948 = (state_17965[(2)]);
var inst_17949 = fluree.db.util.async.throw_err.call(null,inst_17948);
var state_17965__$1 = state_17965;
var statearr_17987_18022 = state_17965__$1;
(statearr_17987_18022[(2)] = inst_17949);

(statearr_17987_18022[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (11))){
var inst_17925 = (state_17965[(2)]);
var state_17965__$1 = state_17965;
var statearr_17989_18023 = state_17965__$1;
(statearr_17989_18023[(2)] = inst_17925);

(statearr_17989_18023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (9))){
var state_17965__$1 = state_17965;
var statearr_17990_18024 = state_17965__$1;
(statearr_17990_18024[(2)] = true);

(statearr_17990_18024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (5))){
var _ = (function (){var statearr_17991 = state_17965;
(statearr_17991[(4)] = cljs.core.rest.call(null,(state_17965[(4)])));

return statearr_17991;
})();
var state_17965__$1 = state_17965;
var ex17988 = (state_17965__$1[(2)]);
var statearr_17992_18025 = state_17965__$1;
(statearr_17992_18025[(5)] = ex17988);


if((ex17988 instanceof Error)){
var statearr_17993_18026 = state_17965__$1;
(statearr_17993_18026[(1)] = (4));

(statearr_17993_18026[(5)] = null);

} else {
throw ex17988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (14))){
var inst_17933 = (state_17965[(2)]);
var inst_17934 = cljs.core.get.call(null,inst_17933,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_17935 = cljs.core.get.call(null,inst_17933,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_17936 = cljs.core.get.call(null,inst_17933,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_17937 = cljs.core.get.call(null,inst_17933,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_17938 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_17935,q_map,inst_17934,fuel,max_fuel,opts);
var state_17965__$1 = (function (){var statearr_17994 = state_17965;
(statearr_17994[(10)] = inst_17936);

(statearr_17994[(7)] = inst_17937);

return statearr_17994;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17965__$1,(15),inst_17938);
} else {
if((state_val_17966 === (16))){
var inst_17936 = (state_17965[(10)]);
var inst_17941 = (state_17965[(11)]);
var inst_17943 = cljs.core.pr_str.call(null,q_map);
var inst_17944 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_17943].join('');
var inst_17945 = fluree.db.util.log.warn.call(null,inst_17944);
var inst_17946 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_17936,inst_17941,fuel,max_fuel,opts);
var state_17965__$1 = (function (){var statearr_17995 = state_17965;
(statearr_17995[(13)] = inst_17945);

return statearr_17995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17965__$1,(19),inst_17946);
} else {
if((state_val_17966 === (10))){
var state_17965__$1 = state_17965;
var statearr_17996_18027 = state_17965__$1;
(statearr_17996_18027[(2)] = false);

(statearr_17996_18027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (18))){
var inst_17937 = (state_17965[(7)]);
var inst_17952 = (state_17965[(2)]);
var state_17965__$1 = (function (){var statearr_17997 = state_17965;
(statearr_17997[(8)] = inst_17952);

return statearr_17997;
})();
if(cljs.core.truth_(inst_17937)){
var statearr_17998_18028 = state_17965__$1;
(statearr_17998_18028[(1)] = (20));

} else {
var statearr_17999_18029 = state_17965__$1;
(statearr_17999_18029[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17966 === (8))){
var inst_17928 = (state_17965[(2)]);
var state_17965__$1 = state_17965;
if(cljs.core.truth_(inst_17928)){
var statearr_18000_18030 = state_17965__$1;
(statearr_18000_18030[(1)] = (12));

} else {
var statearr_18001_18031 = state_17965__$1;
(statearr_18001_18031[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2454__auto____0 = (function (){
var statearr_18002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18002[(0)] = fluree$db$query$analytical$q_$_state_machine__2454__auto__);

(statearr_18002[(1)] = (1));

return statearr_18002;
});
var fluree$db$query$analytical$q_$_state_machine__2454__auto____1 = (function (state_17965){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_17965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18003){var ex__2457__auto__ = e18003;
var statearr_18004_18032 = state_17965;
(statearr_18004_18032[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_17965[(4)]))){
var statearr_18005_18033 = state_17965;
(statearr_18005_18033[(1)] = cljs.core.first.call(null,(state_17965[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18034 = state_17965;
state_17965 = G__18034;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2454__auto__ = function(state_17965){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2454__auto____1.call(this,state_17965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2454__auto____0;
fluree$db$query$analytical$q_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2454__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18006 = f__2477__auto__.call(null);
(statearr_18006[(6)] = c__2476__auto__);

return statearr_18006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
