// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__21125 = arguments.length;
switch (G__21125) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__21128 = arguments.length;
switch (G__21128) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2476__auto___21181 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_21159){
var state_val_21160 = (state_21159[(1)]);
if((state_val_21160 === (1))){
var state_21159__$1 = state_21159;
var statearr_21161_21182 = state_21159__$1;
(statearr_21161_21182[(2)] = null);

(statearr_21161_21182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (2))){
var _ = (function (){var statearr_21162 = state_21159;
(statearr_21162[(4)] = cljs.core.cons.call(null,(5),(state_21159[(4)])));

return statearr_21162;
})();
var inst_21136 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_21159__$1 = state_21159;
if(cljs.core.truth_(inst_21136)){
var statearr_21163_21183 = state_21159__$1;
(statearr_21163_21183[(1)] = (6));

} else {
var statearr_21164_21184 = state_21159__$1;
(statearr_21164_21184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (3))){
var inst_21157 = (state_21159[(2)]);
var state_21159__$1 = state_21159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21159__$1,inst_21157);
} else {
if((state_val_21160 === (4))){
var inst_21129 = (state_21159[(2)]);
var inst_21130 = cljs.core.async.put_BANG_.call(null,pc,inst_21129);
var state_21159__$1 = state_21159;
var statearr_21166_21185 = state_21159__$1;
(statearr_21166_21185[(2)] = inst_21130);

(statearr_21166_21185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (5))){
var _ = (function (){var statearr_21167 = state_21159;
(statearr_21167[(4)] = cljs.core.rest.call(null,(state_21159[(4)])));

return statearr_21167;
})();
var state_21159__$1 = state_21159;
var ex21165 = (state_21159__$1[(2)]);
var statearr_21168_21186 = state_21159__$1;
(statearr_21168_21186[(5)] = ex21165);


if((ex21165 instanceof java.lang.Exception)){
var statearr_21169_21187 = state_21159__$1;
(statearr_21169_21187[(1)] = (4));

(statearr_21169_21187[(5)] = null);

} else {
throw ex21165;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (6))){
var inst_21138 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21139 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_21140 = cljs.core.PersistentHashMap.fromArrays(inst_21138,inst_21139);
var inst_21141 = cljs.core.ex_info.call(null,"Connection was closed.",inst_21140);
var inst_21142 = (function(){throw inst_21141})();
var state_21159__$1 = state_21159;
var statearr_21170_21188 = state_21159__$1;
(statearr_21170_21188[(2)] = inst_21142);

(statearr_21170_21188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (7))){
var inst_21144 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21146 = [operation,data,pc,opts];
var inst_21147 = (new cljs.core.PersistentVector(null,4,(5),inst_21145,inst_21146,null));
var inst_21148 = cljs.core.async.put_BANG_.call(null,inst_21144,inst_21147);
var inst_21149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21150 = [operation,data,pc,opts];
var inst_21151 = (new cljs.core.PersistentVector(null,4,(5),inst_21149,inst_21150,null));
var inst_21152 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_21151);
var state_21159__$1 = (function (){var statearr_21171 = state_21159;
(statearr_21171[(7)] = inst_21148);

return statearr_21171;
})();
var statearr_21172_21189 = state_21159__$1;
(statearr_21172_21189[(2)] = inst_21152);

(statearr_21172_21189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21160 === (8))){
var inst_21154 = (state_21159[(2)]);
var _ = (function (){var statearr_21173 = state_21159;
(statearr_21173[(4)] = cljs.core.rest.call(null,(state_21159[(4)])));

return statearr_21173;
})();
var state_21159__$1 = state_21159;
var statearr_21174_21190 = state_21159__$1;
(statearr_21174_21190[(2)] = inst_21154);

(statearr_21174_21190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2454__auto__ = null;
var fluree$db$operations$state_machine__2454__auto____0 = (function (){
var statearr_21175 = [null,null,null,null,null,null,null,null];
(statearr_21175[(0)] = fluree$db$operations$state_machine__2454__auto__);

(statearr_21175[(1)] = (1));

return statearr_21175;
});
var fluree$db$operations$state_machine__2454__auto____1 = (function (state_21159){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_21159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e21176){var ex__2457__auto__ = e21176;
var statearr_21177_21191 = state_21159;
(statearr_21177_21191[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_21159[(4)]))){
var statearr_21178_21192 = state_21159;
(statearr_21178_21192[(1)] = cljs.core.first.call(null,(state_21159[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21193 = state_21159;
state_21159 = G__21193;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2454__auto__ = function(state_21159){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2454__auto____1.call(this,state_21159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2454__auto____0;
fluree$db$operations$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2454__auto____1;
return fluree$db$operations$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_21179 = f__2477__auto__.call(null);
(statearr_21179[(6)] = c__2476__auto___21181);

return statearr_21179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__21195 = arguments.length;
switch (G__21195) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__21196){
var map__21197 = p__21196;
var map__21197__$1 = (((((!((map__21197 == null))))?(((((map__21197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21197):map__21197);
var opts = map__21197__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__21197__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__21199 = session;
var map__21199__$1 = (((((!((map__21199 == null))))?(((((map__21199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21199.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21199):map__21199);
var dbid = cljs.core.get.call(null,map__21199__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__21199__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__21199__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___21261 = arguments.length;
var i__4737__auto___21262 = (0);
while(true){
if((i__4737__auto___21262 < len__4736__auto___21261)){
args__4742__auto__.push((arguments[i__4737__auto___21262]));

var G__21263 = (i__4737__auto___21262 + (1));
i__4737__auto___21262 = G__21263;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__21204){
var vec__21205 = p__21204;
var map__21208 = cljs.core.nth.call(null,vec__21205,(0),null);
var map__21208__$1 = (((((!((map__21208 == null))))?(((((map__21208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21208.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21208):map__21208);
var toBlock = cljs.core.get.call(null,map__21208__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__21208__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__21205;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_21241){
var state_val_21242 = (state_21241[(1)]);
if((state_val_21242 === (7))){
var inst_21224 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
var statearr_21243_21264 = state_21241__$1;
(statearr_21243_21264[(2)] = inst_21224);

(statearr_21243_21264[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (1))){
var inst_21211 = (state_21241[(7)]);
var inst_21211__$1 = session;
var inst_21213 = (inst_21211__$1 == null);
var inst_21214 = cljs.core.not.call(null,inst_21213);
var state_21241__$1 = (function (){var statearr_21244 = state_21241;
(statearr_21244[(7)] = inst_21211__$1);

return statearr_21244;
})();
if(inst_21214){
var statearr_21245_21265 = state_21241__$1;
(statearr_21245_21265[(1)] = (2));

} else {
var statearr_21246_21266 = state_21241__$1;
(statearr_21246_21266[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (4))){
var inst_21227 = (state_21241[(2)]);
var state_21241__$1 = state_21241;
if(cljs.core.truth_(inst_21227)){
var statearr_21247_21267 = state_21241__$1;
(statearr_21247_21267[(1)] = (8));

} else {
var statearr_21248_21268 = state_21241__$1;
(statearr_21248_21268[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (6))){
var state_21241__$1 = state_21241;
var statearr_21249_21269 = state_21241__$1;
(statearr_21249_21269[(2)] = false);

(statearr_21249_21269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (3))){
var state_21241__$1 = state_21241;
var statearr_21250_21270 = state_21241__$1;
(statearr_21250_21270[(2)] = false);

(statearr_21250_21270[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (2))){
var inst_21211 = (state_21241[(7)]);
var inst_21216 = inst_21211.cljs$lang$protocol_mask$partition0$;
var inst_21217 = (inst_21216 & (64));
var inst_21218 = inst_21211.cljs$core$ISeq$;
var inst_21219 = (cljs.core.PROTOCOL_SENTINEL === inst_21218);
var inst_21220 = ((inst_21217) || (inst_21219));
var state_21241__$1 = state_21241;
if(cljs.core.truth_(inst_21220)){
var statearr_21251_21271 = state_21241__$1;
(statearr_21251_21271[(1)] = (5));

} else {
var statearr_21252_21272 = state_21241__$1;
(statearr_21252_21272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (9))){
var inst_21211 = (state_21241[(7)]);
var state_21241__$1 = state_21241;
var statearr_21253_21273 = state_21241__$1;
(statearr_21253_21273[(2)] = inst_21211);

(statearr_21253_21273[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (5))){
var state_21241__$1 = state_21241;
var statearr_21254_21274 = state_21241__$1;
(statearr_21254_21274[(2)] = true);

(statearr_21254_21274[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21242 === (10))){
var inst_21232 = (state_21241[(2)]);
var inst_21233 = cljs.core.get.call(null,inst_21232,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_21234 = cljs.core.get.call(null,inst_21232,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_21235 = cljs.core.get.call(null,inst_21232,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_21236 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_21237 = [inst_21233,inst_21234,toBlock,toTime];
var inst_21238 = cljs.core.PersistentHashMap.fromArrays(inst_21236,inst_21237);
var inst_21239 = fluree.db.operations.send_operation.call(null,inst_21235,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_21238);
var state_21241__$1 = state_21241;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21241__$1,inst_21239);
} else {
if((state_val_21242 === (8))){
var inst_21211 = (state_21241[(7)]);
var inst_21229 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21211);
var state_21241__$1 = state_21241;
var statearr_21255_21275 = state_21241__$1;
(statearr_21255_21275[(2)] = inst_21229);

(statearr_21255_21275[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2454__auto__ = null;
var fluree$db$operations$state_machine__2454__auto____0 = (function (){
var statearr_21256 = [null,null,null,null,null,null,null,null];
(statearr_21256[(0)] = fluree$db$operations$state_machine__2454__auto__);

(statearr_21256[(1)] = (1));

return statearr_21256;
});
var fluree$db$operations$state_machine__2454__auto____1 = (function (state_21241){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_21241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e21257){var ex__2457__auto__ = e21257;
var statearr_21258_21276 = state_21241;
(statearr_21258_21276[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_21241[(4)]))){
var statearr_21259_21277 = state_21241;
(statearr_21259_21277[(1)] = cljs.core.first.call(null,(state_21241[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21278 = state_21241;
state_21241 = G__21278;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2454__auto__ = function(state_21241){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2454__auto____1.call(this,state_21241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2454__auto____0;
fluree$db$operations$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2454__auto____1;
return fluree$db$operations$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_21260 = f__2477__auto__.call(null);
(statearr_21260[(6)] = c__2476__auto__);

return statearr_21260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq21202){
var G__21203 = cljs.core.first.call(null,seq21202);
var seq21202__$1 = cljs.core.next.call(null,seq21202);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21203,seq21202__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__21279 = session;
var map__21279__$1 = (((((!((map__21279 == null))))?(((((map__21279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21279):map__21279);
var network = cljs.core.get.call(null,map__21279__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21279__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__21279__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__21282 = arguments.length;
switch (G__21282) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__21283 = opts;
var map__21283__$1 = (((((!((map__21283 == null))))?(((((map__21283.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21283.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21283):map__21283);
var auth = cljs.core.get.call(null,map__21283__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__21283__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
