// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19182,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19186 = k19182;
var G__19186__$1 = (((G__19186 instanceof cljs.core.Keyword))?G__19186.fqn:null);
switch (G__19186__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19182,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19187){
var vec__19188 = p__19187;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19188,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19188,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19181){
var self__ = this;
var G__19181__$1 = this;
return (new cljs.core.RecordIter((0),G__19181__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19183,other19184){
var self__ = this;
var this19183__$1 = this;
return (((!((other19184 == null)))) && ((this19183__$1.constructor === other19184.constructor)) && (cljs.core._EQ_.call(null,this19183__$1.index_type,other19184.index_type)) && (cljs.core._EQ_.call(null,this19183__$1.comparator,other19184.comparator)) && (cljs.core._EQ_.call(null,this19183__$1.historyComparator,other19184.historyComparator)) && (cljs.core._EQ_.call(null,this19183__$1.__extmap,other19184.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19181){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19191 = cljs.core.keyword_identical_QMARK_;
var expr__19192 = k__4388__auto__;
if(cljs.core.truth_(pred__19191.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__19192))){
return (new fluree.db.index.IndexConfig(G__19181,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19191.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__19192))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__19181,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19191.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__19192))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__19181,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19181),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19181){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__19181,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__19185){
var extmap__4419__auto__ = (function (){var G__19194 = cljs.core.dissoc.call(null,G__19185,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__19185)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19194);
} else {
return G__19194;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__19185),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__19185),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__19185),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19197,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19201 = k19197;
var G__19201__$1 = (((G__19201 instanceof cljs.core.Keyword))?G__19201.fqn:null);
switch (G__19201__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19197,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19202){
var vec__19203 = p__19202;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19203,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19203,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19196){
var self__ = this;
var G__19196__$1 = this;
return (new cljs.core.RecordIter((0),G__19196__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19207){
var state_val_19208 = (state_19207[(1)]);
if((state_val_19208 === (1))){
var state_19207__$1 = state_19207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19207__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2454__auto__ = null;
var fluree$db$index$state_machine__2454__auto____0 = (function (){
var statearr_19209 = [null,null,null,null,null,null,null];
(statearr_19209[(0)] = fluree$db$index$state_machine__2454__auto__);

(statearr_19209[(1)] = (1));

return statearr_19209;
});
var fluree$db$index$state_machine__2454__auto____1 = (function (state_19207){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19210){var ex__2457__auto__ = e19210;
var statearr_19211_19309 = state_19207;
(statearr_19211_19309[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19207[(4)]))){
var statearr_19212_19310 = state_19207;
(statearr_19212_19310[(1)] = cljs.core.first.call(null,(state_19207[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19311 = state_19207;
state_19207 = G__19311;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$index$state_machine__2454__auto__ = function(state_19207){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2454__auto____1.call(this,state_19207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2454__auto____0;
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2454__auto____1;
return fluree$db$index$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19213 = f__2477__auto__.call(null);
(statearr_19213[(6)] = c__2476__auto__);

return statearr_19213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19238){
var state_val_19239 = (state_19238[(1)]);
if((state_val_19239 === (7))){
var inst_19220 = (state_19238[(7)]);
var inst_19224 = fluree.db.dbproto._resolve.call(null,inst_19220);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19238__$1,(10),inst_19224);
} else {
if((state_val_19239 === (1))){
var state_19238__$1 = state_19238;
var statearr_19240_19312 = state_19238__$1;
(statearr_19240_19312[(2)] = null);

(statearr_19240_19312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (4))){
var inst_19214 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19241_19313 = state_19238__$1;
(statearr_19241_19313[(2)] = inst_19214);

(statearr_19241_19313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (6))){
var inst_19220 = (state_19238[(7)]);
var state_19238__$1 = state_19238;
var statearr_19242_19314 = state_19238__$1;
(statearr_19242_19314[(2)] = inst_19220);

(statearr_19242_19314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (3))){
var inst_19236 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19238__$1,inst_19236);
} else {
if((state_val_19239 === (2))){
var inst_19220 = (state_19238[(7)]);
var _ = (function (){var statearr_19244 = state_19238;
(statearr_19244[(4)] = cljs.core.cons.call(null,(5),(state_19238[(4)])));

return statearr_19244;
})();
var inst_19220__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_19221 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_19220__$1);
var state_19238__$1 = (function (){var statearr_19245 = state_19238;
(statearr_19245[(7)] = inst_19220__$1);

return statearr_19245;
})();
if(cljs.core.truth_(inst_19221)){
var statearr_19246_19315 = state_19238__$1;
(statearr_19246_19315[(1)] = (6));

} else {
var statearr_19247_19316 = state_19238__$1;
(statearr_19247_19316[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (9))){
var inst_19230 = (state_19238[(2)]);
var inst_19231 = fluree.db.util.async.throw_err.call(null,inst_19230);
var state_19238__$1 = state_19238;
var statearr_19248_19317 = state_19238__$1;
(statearr_19248_19317[(2)] = inst_19231);

(statearr_19248_19317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (5))){
var _ = (function (){var statearr_19249 = state_19238;
(statearr_19249[(4)] = cljs.core.rest.call(null,(state_19238[(4)])));

return statearr_19249;
})();
var state_19238__$1 = state_19238;
var ex19243 = (state_19238__$1[(2)]);
var statearr_19250_19318 = state_19238__$1;
(statearr_19250_19318[(5)] = ex19243);


if((ex19243 instanceof Error)){
var statearr_19251_19319 = state_19238__$1;
(statearr_19251_19319[(1)] = (4));

(statearr_19251_19319[(5)] = null);

} else {
throw ex19243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (10))){
var inst_19226 = (state_19238[(2)]);
var inst_19227 = fluree.db.util.async.throw_err.call(null,inst_19226);
var inst_19228 = fluree.db.dbproto._lookup_leaf.call(null,inst_19227,flake);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19238__$1,(9),inst_19228);
} else {
if((state_val_19239 === (8))){
var inst_19233 = (state_19238[(2)]);
var _ = (function (){var statearr_19252 = state_19238;
(statearr_19252[(4)] = cljs.core.rest.call(null,(state_19238[(4)])));

return statearr_19252;
})();
var state_19238__$1 = state_19238;
var statearr_19253_19320 = state_19238__$1;
(statearr_19253_19320[(2)] = inst_19233);

(statearr_19253_19320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2454__auto__ = null;
var fluree$db$index$state_machine__2454__auto____0 = (function (){
var statearr_19254 = [null,null,null,null,null,null,null,null];
(statearr_19254[(0)] = fluree$db$index$state_machine__2454__auto__);

(statearr_19254[(1)] = (1));

return statearr_19254;
});
var fluree$db$index$state_machine__2454__auto____1 = (function (state_19238){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19255){var ex__2457__auto__ = e19255;
var statearr_19256_19321 = state_19238;
(statearr_19256_19321[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19238[(4)]))){
var statearr_19257_19322 = state_19238;
(statearr_19257_19322[(1)] = cljs.core.first.call(null,(state_19238[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19323 = state_19238;
state_19238 = G__19323;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$index$state_machine__2454__auto__ = function(state_19238){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2454__auto____1.call(this,state_19238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2454__auto____0;
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2454__auto____1;
return fluree$db$index$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19258 = f__2477__auto__.call(null);
(statearr_19258[(6)] = c__2476__auto__);

return statearr_19258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19283){
var state_val_19284 = (state_19283[(1)]);
if((state_val_19284 === (7))){
var inst_19265 = (state_19283[(7)]);
var inst_19269 = fluree.db.dbproto._resolve.call(null,inst_19265);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19283__$1,(10),inst_19269);
} else {
if((state_val_19284 === (1))){
var state_19283__$1 = state_19283;
var statearr_19285_19324 = state_19283__$1;
(statearr_19285_19324[(2)] = null);

(statearr_19285_19324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (4))){
var inst_19259 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
var statearr_19286_19325 = state_19283__$1;
(statearr_19286_19325[(2)] = inst_19259);

(statearr_19286_19325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (6))){
var inst_19265 = (state_19283[(7)]);
var state_19283__$1 = state_19283;
var statearr_19287_19326 = state_19283__$1;
(statearr_19287_19326[(2)] = inst_19265);

(statearr_19287_19326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (3))){
var inst_19281 = (state_19283[(2)]);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19283__$1,inst_19281);
} else {
if((state_val_19284 === (2))){
var inst_19265 = (state_19283[(7)]);
var _ = (function (){var statearr_19289 = state_19283;
(statearr_19289[(4)] = cljs.core.cons.call(null,(5),(state_19283[(4)])));

return statearr_19289;
})();
var inst_19265__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_19266 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_19265__$1);
var state_19283__$1 = (function (){var statearr_19290 = state_19283;
(statearr_19290[(7)] = inst_19265__$1);

return statearr_19290;
})();
if(cljs.core.truth_(inst_19266)){
var statearr_19291_19327 = state_19283__$1;
(statearr_19291_19327[(1)] = (6));

} else {
var statearr_19292_19328 = state_19283__$1;
(statearr_19292_19328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (9))){
var inst_19275 = (state_19283[(2)]);
var inst_19276 = fluree.db.util.async.throw_err.call(null,inst_19275);
var state_19283__$1 = state_19283;
var statearr_19293_19329 = state_19283__$1;
(statearr_19293_19329[(2)] = inst_19276);

(statearr_19293_19329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (5))){
var _ = (function (){var statearr_19294 = state_19283;
(statearr_19294[(4)] = cljs.core.rest.call(null,(state_19283[(4)])));

return statearr_19294;
})();
var state_19283__$1 = state_19283;
var ex19288 = (state_19283__$1[(2)]);
var statearr_19295_19330 = state_19283__$1;
(statearr_19295_19330[(5)] = ex19288);


if((ex19288 instanceof Error)){
var statearr_19296_19331 = state_19283__$1;
(statearr_19296_19331[(1)] = (4));

(statearr_19296_19331[(5)] = null);

} else {
throw ex19288;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19284 === (10))){
var inst_19271 = (state_19283[(2)]);
var inst_19272 = fluree.db.util.async.throw_err.call(null,inst_19271);
var inst_19273 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_19272,flake);
var state_19283__$1 = state_19283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19283__$1,(9),inst_19273);
} else {
if((state_val_19284 === (8))){
var inst_19278 = (state_19283[(2)]);
var _ = (function (){var statearr_19297 = state_19283;
(statearr_19297[(4)] = cljs.core.rest.call(null,(state_19283[(4)])));

return statearr_19297;
})();
var state_19283__$1 = state_19283;
var statearr_19298_19332 = state_19283__$1;
(statearr_19298_19332[(2)] = inst_19278);

(statearr_19298_19332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2454__auto__ = null;
var fluree$db$index$state_machine__2454__auto____0 = (function (){
var statearr_19299 = [null,null,null,null,null,null,null,null];
(statearr_19299[(0)] = fluree$db$index$state_machine__2454__auto__);

(statearr_19299[(1)] = (1));

return statearr_19299;
});
var fluree$db$index$state_machine__2454__auto____1 = (function (state_19283){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19300){var ex__2457__auto__ = e19300;
var statearr_19301_19333 = state_19283;
(statearr_19301_19333[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19283[(4)]))){
var statearr_19302_19334 = state_19283;
(statearr_19302_19334[(1)] = cljs.core.first.call(null,(state_19283[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19335 = state_19283;
state_19283 = G__19335;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$index$state_machine__2454__auto__ = function(state_19283){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2454__auto____1.call(this,state_19283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2454__auto____0;
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2454__auto____1;
return fluree$db$index$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19303 = f__2477__auto__.call(null);
(statearr_19303[(6)] = c__2476__auto__);

return statearr_19303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19198,other19199){
var self__ = this;
var this19198__$1 = this;
return (((!((other19199 == null)))) && ((this19198__$1.constructor === other19199.constructor)) && (cljs.core._EQ_.call(null,this19198__$1.block,other19199.block)) && (cljs.core._EQ_.call(null,this19198__$1.t,other19199.t)) && (cljs.core._EQ_.call(null,this19198__$1.rhs,other19199.rhs)) && (cljs.core._EQ_.call(null,this19198__$1.children,other19199.children)) && (cljs.core._EQ_.call(null,this19198__$1.config,other19199.config)) && (cljs.core._EQ_.call(null,this19198__$1.leftmost_QMARK_,other19199.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this19198__$1.__extmap,other19199.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19196){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19304 = cljs.core.keyword_identical_QMARK_;
var expr__19305 = k__4388__auto__;
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19305))){
return (new fluree.db.index.IndexNode(G__19196,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19305))){
return (new fluree.db.index.IndexNode(self__.block,G__19196,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19305))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__19196,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__19305))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__19196,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19305))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__19196,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19304.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__19305))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__19196,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19196),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19196){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__19196,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__19200){
var extmap__4419__auto__ = (function (){var G__19307 = cljs.core.dissoc.call(null,G__19200,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__19200)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19307);
} else {
return G__19307;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19200),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19200),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19200),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__19200),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19200),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19200),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19337,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19341 = k19337;
var G__19341__$1 = (((G__19341 instanceof cljs.core.Keyword))?G__19341.fqn:null);
switch (G__19341__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19337,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19342){
var vec__19343 = p__19342;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19343,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19343,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19336){
var self__ = this;
var G__19336__$1 = this;
return (new cljs.core.RecordIter((0),G__19336__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19347){
var state_val_19348 = (state_19347[(1)]);
if((state_val_19348 === (1))){
var state_19347__$1 = state_19347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19347__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2454__auto__ = null;
var fluree$db$index$state_machine__2454__auto____0 = (function (){
var statearr_19349 = [null,null,null,null,null,null,null];
(statearr_19349[(0)] = fluree$db$index$state_machine__2454__auto__);

(statearr_19349[(1)] = (1));

return statearr_19349;
});
var fluree$db$index$state_machine__2454__auto____1 = (function (state_19347){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19350){var ex__2457__auto__ = e19350;
var statearr_19351_19371 = state_19347;
(statearr_19351_19371[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19347[(4)]))){
var statearr_19352_19372 = state_19347;
(statearr_19352_19372[(1)] = cljs.core.first.call(null,(state_19347[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19373 = state_19347;
state_19347 = G__19373;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$index$state_machine__2454__auto__ = function(state_19347){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2454__auto____1.call(this,state_19347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2454__auto____0;
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2454__auto____1;
return fluree$db$index$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19353 = f__2477__auto__.call(null);
(statearr_19353[(6)] = c__2476__auto__);

return statearr_19353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19359){
var state_val_19360 = (state_19359[(1)]);
if((state_val_19360 === (1))){
var inst_19354 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19355 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_19356 = cljs.core.PersistentHashMap.fromArrays(inst_19354,inst_19355);
var inst_19357 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_19356);
var state_19359__$1 = state_19359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19359__$1,inst_19357);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2454__auto__ = null;
var fluree$db$index$state_machine__2454__auto____0 = (function (){
var statearr_19361 = [null,null,null,null,null,null,null];
(statearr_19361[(0)] = fluree$db$index$state_machine__2454__auto__);

(statearr_19361[(1)] = (1));

return statearr_19361;
});
var fluree$db$index$state_machine__2454__auto____1 = (function (state_19359){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19362){var ex__2457__auto__ = e19362;
var statearr_19363_19374 = state_19359;
(statearr_19363_19374[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19359[(4)]))){
var statearr_19364_19375 = state_19359;
(statearr_19364_19375[(1)] = cljs.core.first.call(null,(state_19359[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19376 = state_19359;
state_19359 = G__19376;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$index$state_machine__2454__auto__ = function(state_19359){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2454__auto____1.call(this,state_19359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2454__auto____0;
fluree$db$index$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2454__auto____1;
return fluree$db$index$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19365 = f__2477__auto__.call(null);
(statearr_19365[(6)] = c__2476__auto__);

return statearr_19365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19338,other19339){
var self__ = this;
var this19338__$1 = this;
return (((!((other19339 == null)))) && ((this19338__$1.constructor === other19339.constructor)) && (cljs.core._EQ_.call(null,this19338__$1.block,other19339.block)) && (cljs.core._EQ_.call(null,this19338__$1.t,other19339.t)) && (cljs.core._EQ_.call(null,this19338__$1.flakes,other19339.flakes)) && (cljs.core._EQ_.call(null,this19338__$1.rhs,other19339.rhs)) && (cljs.core._EQ_.call(null,this19338__$1.config,other19339.config)) && (cljs.core._EQ_.call(null,this19338__$1.__extmap,other19339.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19336){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19366 = cljs.core.keyword_identical_QMARK_;
var expr__19367 = k__4388__auto__;
if(cljs.core.truth_(pred__19366.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19367))){
return (new fluree.db.index.DataNode(G__19336,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19366.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19367))){
return (new fluree.db.index.DataNode(self__.block,G__19336,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19366.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__19367))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__19336,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19366.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19367))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__19336,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19366.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19367))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__19336,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19336),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19336){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__19336,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__19340){
var extmap__4419__auto__ = (function (){var G__19369 = cljs.core.dissoc.call(null,G__19340,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__19340)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19369);
} else {
return G__19369;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19340),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19340),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__19340),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19340),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19340),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
