// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26057 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__26057,(0),null);
var network = cljs.core.nth.call(null,vec__26057,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__26057,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_26154){
var state_val_26155 = (state_26154[(1)]);
if((state_val_26155 === (7))){
var inst_26075 = (state_26154[(7)]);
var inst_26080 = inst_26075.cljs$lang$protocol_mask$partition0$;
var inst_26081 = (inst_26080 & (64));
var inst_26082 = inst_26075.cljs$core$ISeq$;
var inst_26083 = (cljs.core.PROTOCOL_SENTINEL === inst_26082);
var inst_26084 = ((inst_26081) || (inst_26083));
var state_26154__$1 = state_26154;
if(cljs.core.truth_(inst_26084)){
var statearr_26156_26202 = state_26154__$1;
(statearr_26156_26202[(1)] = (10));

} else {
var statearr_26157_26203 = state_26154__$1;
(statearr_26157_26203[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (20))){
var state_26154__$1 = state_26154;
var statearr_26158_26204 = state_26154__$1;
(statearr_26158_26204[(2)] = false);

(statearr_26158_26204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (27))){
var inst_26097 = (state_26154[(8)]);
var inst_26100 = (state_26154[(9)]);
var inst_26074 = (state_26154[(10)]);
var inst_26138 = (state_26154[(2)]);
var inst_26139 = cljs.core.into.call(null,inst_26097,inst_26074);
var inst_26140 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26141 = cljs.core.swap_BANG_.call(null,inst_26140,cljs.core.empty);
var inst_26142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26143 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26144 = (new cljs.core.PersistentVector(null,2,(5),inst_26142,inst_26143,null));
var inst_26145 = cljs.core.assoc_in.call(null,db,inst_26144,inst_26139);
var inst_26146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26147 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26148 = (new cljs.core.PersistentVector(null,2,(5),inst_26146,inst_26147,null));
var inst_26149 = cljs.core.assoc_in.call(null,inst_26145,inst_26148,inst_26100);
var _ = (function (){var statearr_26159 = state_26154;
(statearr_26159[(4)] = cljs.core.rest.call(null,(state_26154[(4)])));

return statearr_26159;
})();
var state_26154__$1 = (function (){var statearr_26160 = state_26154;
(statearr_26160[(11)] = inst_26138);

(statearr_26160[(12)] = inst_26141);

return statearr_26160;
})();
var statearr_26161_26205 = state_26154__$1;
(statearr_26161_26205[(2)] = inst_26149);

(statearr_26161_26205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (1))){
var state_26154__$1 = state_26154;
var statearr_26162_26206 = state_26154__$1;
(statearr_26162_26206[(2)] = null);

(statearr_26162_26206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (24))){
var inst_26100 = (state_26154[(9)]);
var inst_26125 = (state_26154[(2)]);
var inst_26126 = cljs.core.get.call(null,inst_26125,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26127 = cljs.core.get.call(null,inst_26125,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26128 = (inst_26100 > inst_26127);
var state_26154__$1 = (function (){var statearr_26163 = state_26154;
(statearr_26163[(13)] = inst_26126);

return statearr_26163;
})();
if(cljs.core.truth_(inst_26128)){
var statearr_26164_26207 = state_26154__$1;
(statearr_26164_26207[(1)] = (25));

} else {
var statearr_26165_26208 = state_26154__$1;
(statearr_26165_26208[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (4))){
var inst_26060 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
var statearr_26166_26209 = state_26154__$1;
(statearr_26166_26209[(2)] = inst_26060);

(statearr_26166_26209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (15))){
var inst_26104 = (state_26154[(14)]);
var inst_26074 = (state_26154[(10)]);
var inst_26096 = (state_26154[(2)]);
var inst_26097 = cljs.core.get.call(null,inst_26096,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26098 = cljs.core.get.call(null,inst_26096,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26099 = fluree.db.flake.size_bytes.call(null,inst_26074);
var inst_26100 = (inst_26098 + inst_26099);
var inst_26101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26102 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26103 = (new cljs.core.PersistentVector(null,2,(5),inst_26101,inst_26102,null));
var inst_26104__$1 = cljs.core.get_in.call(null,db,inst_26103);
var inst_26106 = (inst_26104__$1 == null);
var inst_26107 = cljs.core.not.call(null,inst_26106);
var state_26154__$1 = (function (){var statearr_26167 = state_26154;
(statearr_26167[(8)] = inst_26097);

(statearr_26167[(14)] = inst_26104__$1);

(statearr_26167[(9)] = inst_26100);

return statearr_26167;
})();
if(inst_26107){
var statearr_26168_26210 = state_26154__$1;
(statearr_26168_26210[(1)] = (16));

} else {
var statearr_26169_26211 = state_26154__$1;
(statearr_26169_26211[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (21))){
var inst_26117 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
var statearr_26170_26212 = state_26154__$1;
(statearr_26170_26212[(2)] = inst_26117);

(statearr_26170_26212[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (13))){
var inst_26075 = (state_26154[(7)]);
var inst_26093 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26075);
var state_26154__$1 = state_26154;
var statearr_26171_26213 = state_26154__$1;
(statearr_26171_26213[(2)] = inst_26093);

(statearr_26171_26213[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (22))){
var inst_26104 = (state_26154[(14)]);
var inst_26122 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26104);
var state_26154__$1 = state_26154;
var statearr_26172_26214 = state_26154__$1;
(statearr_26172_26214[(2)] = inst_26122);

(statearr_26172_26214[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (6))){
var inst_26075 = (state_26154[(7)]);
var inst_26073 = (state_26154[(2)]);
var inst_26074 = fluree.db.util.async.throw_err.call(null,inst_26073);
var inst_26075__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26077 = (inst_26075__$1 == null);
var inst_26078 = cljs.core.not.call(null,inst_26077);
var state_26154__$1 = (function (){var statearr_26173 = state_26154;
(statearr_26173[(7)] = inst_26075__$1);

(statearr_26173[(10)] = inst_26074);

return statearr_26173;
})();
if(inst_26078){
var statearr_26174_26215 = state_26154__$1;
(statearr_26174_26215[(1)] = (7));

} else {
var statearr_26175_26216 = state_26154__$1;
(statearr_26175_26216[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (25))){
var inst_26130 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26131 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26132 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26133 = cljs.core.PersistentHashMap.fromArrays(inst_26131,inst_26132);
var inst_26134 = cljs.core.ex_info.call(null,inst_26130,inst_26133);
var inst_26135 = (function(){throw inst_26134})();
var state_26154__$1 = state_26154;
var statearr_26176_26217 = state_26154__$1;
(statearr_26176_26217[(2)] = inst_26135);

(statearr_26176_26217[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (17))){
var state_26154__$1 = state_26154;
var statearr_26177_26218 = state_26154__$1;
(statearr_26177_26218[(2)] = false);

(statearr_26177_26218[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (3))){
var inst_26152 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26154__$1,inst_26152);
} else {
if((state_val_26155 === (12))){
var inst_26088 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
var statearr_26178_26219 = state_26154__$1;
(statearr_26178_26219[(2)] = inst_26088);

(statearr_26178_26219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (2))){
var _ = (function (){var statearr_26179 = state_26154;
(statearr_26179[(4)] = cljs.core.cons.call(null,(5),(state_26154[(4)])));

return statearr_26179;
})();
var inst_26068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26069 = [pred_id];
var inst_26070 = (new cljs.core.PersistentVector(null,1,(5),inst_26068,inst_26069,null));
var inst_26071 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26070);
var state_26154__$1 = state_26154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26154__$1,(6),inst_26071);
} else {
if((state_val_26155 === (23))){
var inst_26104 = (state_26154[(14)]);
var state_26154__$1 = state_26154;
var statearr_26180_26220 = state_26154__$1;
(statearr_26180_26220[(2)] = inst_26104);

(statearr_26180_26220[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (19))){
var state_26154__$1 = state_26154;
var statearr_26181_26221 = state_26154__$1;
(statearr_26181_26221[(2)] = true);

(statearr_26181_26221[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (11))){
var state_26154__$1 = state_26154;
var statearr_26183_26222 = state_26154__$1;
(statearr_26183_26222[(2)] = false);

(statearr_26183_26222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (9))){
var inst_26091 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
if(cljs.core.truth_(inst_26091)){
var statearr_26184_26223 = state_26154__$1;
(statearr_26184_26223[(1)] = (13));

} else {
var statearr_26185_26224 = state_26154__$1;
(statearr_26185_26224[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (5))){
var _ = (function (){var statearr_26186 = state_26154;
(statearr_26186[(4)] = cljs.core.rest.call(null,(state_26154[(4)])));

return statearr_26186;
})();
var state_26154__$1 = state_26154;
var ex26182 = (state_26154__$1[(2)]);
var statearr_26187_26225 = state_26154__$1;
(statearr_26187_26225[(5)] = ex26182);


if((ex26182 instanceof Error)){
var statearr_26188_26226 = state_26154__$1;
(statearr_26188_26226[(1)] = (4));

(statearr_26188_26226[(5)] = null);

} else {
throw ex26182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (14))){
var inst_26075 = (state_26154[(7)]);
var state_26154__$1 = state_26154;
var statearr_26189_26227 = state_26154__$1;
(statearr_26189_26227[(2)] = inst_26075);

(statearr_26189_26227[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (26))){
var state_26154__$1 = state_26154;
var statearr_26190_26228 = state_26154__$1;
(statearr_26190_26228[(2)] = null);

(statearr_26190_26228[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (16))){
var inst_26104 = (state_26154[(14)]);
var inst_26109 = inst_26104.cljs$lang$protocol_mask$partition0$;
var inst_26110 = (inst_26109 & (64));
var inst_26111 = inst_26104.cljs$core$ISeq$;
var inst_26112 = (cljs.core.PROTOCOL_SENTINEL === inst_26111);
var inst_26113 = ((inst_26110) || (inst_26112));
var state_26154__$1 = state_26154;
if(cljs.core.truth_(inst_26113)){
var statearr_26191_26229 = state_26154__$1;
(statearr_26191_26229[(1)] = (19));

} else {
var statearr_26192_26230 = state_26154__$1;
(statearr_26192_26230[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (10))){
var state_26154__$1 = state_26154;
var statearr_26193_26231 = state_26154__$1;
(statearr_26193_26231[(2)] = true);

(statearr_26193_26231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (18))){
var inst_26120 = (state_26154[(2)]);
var state_26154__$1 = state_26154;
if(cljs.core.truth_(inst_26120)){
var statearr_26194_26232 = state_26154__$1;
(statearr_26194_26232[(1)] = (22));

} else {
var statearr_26195_26233 = state_26154__$1;
(statearr_26195_26233[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26155 === (8))){
var state_26154__$1 = state_26154;
var statearr_26196_26234 = state_26154__$1;
(statearr_26196_26234[(2)] = false);

(statearr_26196_26234[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____0 = (function (){
var statearr_26197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26197[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__);

(statearr_26197[(1)] = (1));

return statearr_26197;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____1 = (function (state_26154){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_26154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e26198){var ex__2457__auto__ = e26198;
var statearr_26199_26235 = state_26154;
(statearr_26199_26235[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_26154[(4)]))){
var statearr_26200_26236 = state_26154;
(statearr_26200_26236[(1)] = cljs.core.first.call(null,(state_26154[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26237 = state_26154;
state_26154 = G__26237;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__ = function(state_26154){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____1.call(this,state_26154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_26201 = f__2477__auto__.call(null);
(statearr_26201[(6)] = c__2476__auto__);

return statearr_26201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_26436){
var state_val_26437 = (state_26436[(1)]);
if((state_val_26437 === (7))){
var state_26436__$1 = state_26436;
var statearr_26438_26504 = state_26436__$1;
(statearr_26438_26504[(2)] = null);

(statearr_26438_26504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (20))){
var inst_26358 = (state_26436[(7)]);
var inst_26279 = (state_26436[(8)]);
var inst_26362 = (state_26436[(9)]);
var inst_26360 = (state_26436[(10)]);
var inst_26361 = (state_26436[(11)]);
var inst_26329 = (state_26436[(12)]);
var inst_26359 = (state_26436[(13)]);
var inst_26278 = (state_26436[(14)]);
var inst_26372 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26374 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26375 = (new cljs.core.PersistentVector(null,2,(5),inst_26373,inst_26374,null));
var inst_26376 = cljs.core.get_in.call(null,inst_26329,inst_26375);
var inst_26377 = (inst_26278 + inst_26376);
var inst_26378 = [inst_26358,inst_26359,inst_26360,inst_26361,inst_26377];
var inst_26379 = cljs.core.PersistentHashMap.fromArrays(inst_26372,inst_26378);
var inst_26380 = cljs.core.assoc.call(null,inst_26329,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26362,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26379);
var state_26436__$1 = (function (){var statearr_26439 = state_26436;
(statearr_26439[(15)] = inst_26380);

return statearr_26439;
})();
if(cljs.core.truth_(inst_26279)){
var statearr_26440_26505 = state_26436__$1;
(statearr_26440_26505[(1)] = (23));

} else {
var statearr_26441_26506 = state_26436__$1;
(statearr_26441_26506[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (27))){
var inst_26380 = (state_26436[(15)]);
var state_26436__$1 = state_26436;
var statearr_26442_26507 = state_26436__$1;
(statearr_26442_26507[(2)] = inst_26380);

(statearr_26442_26507[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (1))){
var state_26436__$1 = state_26436;
var statearr_26443_26508 = state_26436__$1;
(statearr_26443_26508[(2)] = null);

(statearr_26443_26508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (24))){
var inst_26380 = (state_26436[(15)]);
var inst_26383 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26380);
var inst_26384 = (inst_26383 == null);
var state_26436__$1 = state_26436;
var statearr_26444_26509 = state_26436__$1;
(statearr_26444_26509[(2)] = inst_26384);

(statearr_26444_26509[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (39))){
var inst_26412 = (state_26436[(16)]);
var inst_26411 = (state_26436[(17)]);
var inst_26369 = (state_26436[(18)]);
var inst_26419 = (state_26436[(19)]);
var inst_26410 = (state_26436[(20)]);
var inst_26426 = (state_26436[(2)]);
var inst_26357 = inst_26369;
var inst_26358 = inst_26411;
var inst_26359 = inst_26412;
var inst_26360 = inst_26419;
var inst_26361 = inst_26426;
var inst_26362 = inst_26410;
var state_26436__$1 = (function (){var statearr_26445 = state_26436;
(statearr_26445[(7)] = inst_26358);

(statearr_26445[(21)] = inst_26357);

(statearr_26445[(9)] = inst_26362);

(statearr_26445[(10)] = inst_26360);

(statearr_26445[(11)] = inst_26361);

(statearr_26445[(13)] = inst_26359);

return statearr_26445;
})();
var statearr_26446_26510 = state_26436__$1;
(statearr_26446_26510[(2)] = null);

(statearr_26446_26510[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (4))){
var inst_26241 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
var statearr_26447_26511 = state_26436__$1;
(statearr_26447_26511[(2)] = inst_26241);

(statearr_26447_26511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (15))){
var inst_26301 = (state_26436[(22)]);
var state_26436__$1 = state_26436;
var statearr_26448_26512 = state_26436__$1;
(statearr_26448_26512[(2)] = inst_26301);

(statearr_26448_26512[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (21))){
var inst_26248 = (state_26436[(23)]);
var inst_26282 = (state_26436[(24)]);
var inst_26358 = (state_26436[(7)]);
var inst_26357 = (state_26436[(21)]);
var inst_26273 = (state_26436[(25)]);
var inst_26368 = (state_26436[(26)]);
var inst_26279 = (state_26436[(8)]);
var inst_26263 = (state_26436[(27)]);
var inst_26362 = (state_26436[(9)]);
var inst_26360 = (state_26436[(10)]);
var inst_26369 = (state_26436[(18)]);
var inst_26269 = (state_26436[(28)]);
var inst_26339 = (state_26436[(29)]);
var inst_26280 = (state_26436[(30)]);
var inst_26361 = (state_26436[(11)]);
var inst_26329 = (state_26436[(12)]);
var inst_26359 = (state_26436[(13)]);
var inst_26265 = (state_26436[(31)]);
var inst_26278 = (state_26436[(14)]);
var inst_26288 = (state_26436[(32)]);
var inst_26277 = (state_26436[(33)]);
var inst_26338 = (state_26436[(34)]);
var inst_26407 = inst_26368.s;
var inst_26408 = fluree.db.flake.sid__GT_cid.call(null,inst_26407);
var inst_26409 = (function (){var flakes_bytes = inst_26278;
var t = inst_26248;
var seq__26335 = inst_26339;
var spot = inst_26358;
var seq__26365 = inst_26369;
var add_flakes = inst_26265;
var root_setting_change_QMARK_ = inst_26280;
var ref_QMARK__map = inst_26277;
var r = inst_26369;
var psot = inst_26359;
var add_pred_to_idx_QMARK_ = inst_26288;
var _ = inst_26263;
var G__26333 = inst_26357;
var cid = inst_26408;
var ecount = inst_26362;
var pred_ecount = inst_26282;
var first__26366 = inst_26368;
var db_STAR_ = inst_26329;
var schema_change_QMARK_ = inst_26279;
var vec__26364 = inst_26357;
var add_preds = inst_26269;
var opst = inst_26361;
var idx_QMARK__map = inst_26273;
var post = inst_26360;
var first__26336 = inst_26338;
var vec__26334 = inst_26265;
var f = inst_26368;
return (function (p1__26240_SHARP_){
if(cljs.core.truth_(p1__26240_SHARP_)){
var x__4214__auto__ = p1__26240_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_26410 = cljs.core.update.call(null,inst_26362,inst_26408,inst_26409);
var inst_26411 = cljs.core.conj.call(null,inst_26358,inst_26368);
var inst_26412 = cljs.core.conj.call(null,inst_26359,inst_26368);
var inst_26413 = inst_26368.p;
var inst_26414 = cljs.core.get.call(null,inst_26273,inst_26413);
var state_26436__$1 = (function (){var statearr_26449 = state_26436;
(statearr_26449[(16)] = inst_26412);

(statearr_26449[(17)] = inst_26411);

(statearr_26449[(20)] = inst_26410);

return statearr_26449;
})();
if(cljs.core.truth_(inst_26414)){
var statearr_26450_26513 = state_26436__$1;
(statearr_26450_26513[(1)] = (34));

} else {
var statearr_26451_26514 = state_26436__$1;
(statearr_26451_26514[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (31))){
var inst_26395 = (state_26436[(35)]);
var state_26436__$1 = state_26436;
var statearr_26452_26515 = state_26436__$1;
(statearr_26452_26515[(2)] = inst_26395);

(statearr_26452_26515[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (32))){
var inst_26405 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
var statearr_26453_26516 = state_26436__$1;
(statearr_26453_26516[(2)] = inst_26405);

(statearr_26453_26516[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (33))){
var inst_26395 = (state_26436[(35)]);
var inst_26400 = (state_26436[(2)]);
var inst_26401 = fluree.db.util.async.throw_err.call(null,inst_26400);
var inst_26402 = cljs.core.assoc.call(null,inst_26395,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26401);
var state_26436__$1 = state_26436;
var statearr_26454_26517 = state_26436__$1;
(statearr_26454_26517[(2)] = inst_26402);

(statearr_26454_26517[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (13))){
var inst_26248 = (state_26436[(23)]);
var inst_26329 = (state_26436[(12)]);
var inst_26265 = (state_26436[(31)]);
var inst_26278 = (state_26436[(14)]);
var inst_26319 = (state_26436[(2)]);
var inst_26320 = cljs.core.assoc.call(null,inst_26319,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26248);
var inst_26321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26322 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26323 = (new cljs.core.PersistentVector(null,2,(5),inst_26321,inst_26322,null));
var inst_26324 = cljs.core.update_in.call(null,inst_26320,inst_26323,cljs.core._PLUS_,inst_26278);
var inst_26325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26326 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26327 = (new cljs.core.PersistentVector(null,2,(5),inst_26325,inst_26326,null));
var inst_26328 = cljs.core.count.call(null,inst_26265);
var inst_26329__$1 = cljs.core.update_in.call(null,inst_26324,inst_26327,cljs.core._PLUS_,inst_26328);
var inst_26337 = cljs.core.seq.call(null,inst_26265);
var inst_26338 = cljs.core.first.call(null,inst_26337);
var inst_26339 = cljs.core.next.call(null,inst_26337);
var inst_26340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26341 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26342 = (new cljs.core.PersistentVector(null,2,(5),inst_26340,inst_26341,null));
var inst_26343 = cljs.core.get_in.call(null,inst_26329__$1,inst_26342);
var inst_26344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26345 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26346 = (new cljs.core.PersistentVector(null,2,(5),inst_26344,inst_26345,null));
var inst_26347 = cljs.core.get_in.call(null,inst_26329__$1,inst_26346);
var inst_26348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26349 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26350 = (new cljs.core.PersistentVector(null,2,(5),inst_26348,inst_26349,null));
var inst_26351 = cljs.core.get_in.call(null,inst_26329__$1,inst_26350);
var inst_26352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26353 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26354 = (new cljs.core.PersistentVector(null,2,(5),inst_26352,inst_26353,null));
var inst_26355 = cljs.core.get_in.call(null,inst_26329__$1,inst_26354);
var inst_26356 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26357 = inst_26265;
var inst_26358 = inst_26343;
var inst_26359 = inst_26347;
var inst_26360 = inst_26351;
var inst_26361 = inst_26355;
var inst_26362 = inst_26356;
var state_26436__$1 = (function (){var statearr_26455 = state_26436;
(statearr_26455[(7)] = inst_26358);

(statearr_26455[(21)] = inst_26357);

(statearr_26455[(9)] = inst_26362);

(statearr_26455[(10)] = inst_26360);

(statearr_26455[(29)] = inst_26339);

(statearr_26455[(11)] = inst_26361);

(statearr_26455[(12)] = inst_26329__$1);

(statearr_26455[(13)] = inst_26359);

(statearr_26455[(34)] = inst_26338);

return statearr_26455;
})();
var statearr_26456_26518 = state_26436__$1;
(statearr_26456_26518[(2)] = null);

(statearr_26456_26518[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (22))){
var inst_26429 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
var statearr_26457_26519 = state_26436__$1;
(statearr_26457_26519[(2)] = inst_26429);

(statearr_26457_26519[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (36))){
var inst_26368 = (state_26436[(26)]);
var inst_26277 = (state_26436[(33)]);
var inst_26419 = (state_26436[(2)]);
var inst_26420 = inst_26368.p;
var inst_26421 = cljs.core.get.call(null,inst_26277,inst_26420);
var state_26436__$1 = (function (){var statearr_26458 = state_26436;
(statearr_26458[(19)] = inst_26419);

return statearr_26458;
})();
if(cljs.core.truth_(inst_26421)){
var statearr_26459_26520 = state_26436__$1;
(statearr_26459_26520[(1)] = (37));

} else {
var statearr_26460_26521 = state_26436__$1;
(statearr_26460_26521[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (29))){
var inst_26380 = (state_26436[(15)]);
var inst_26390 = (state_26436[(2)]);
var inst_26391 = fluree.db.util.async.throw_err.call(null,inst_26390);
var inst_26392 = cljs.core.assoc.call(null,inst_26380,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26391);
var state_26436__$1 = state_26436;
var statearr_26461_26522 = state_26436__$1;
(statearr_26461_26522[(2)] = inst_26392);

(statearr_26461_26522[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (6))){
var inst_26248 = (state_26436[(23)]);
var inst_26253 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26254 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26255 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26253)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26254)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26248),"."].join('');
var inst_26256 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26257 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26258 = cljs.core.PersistentHashMap.fromArrays(inst_26256,inst_26257);
var inst_26259 = cljs.core.ex_info.call(null,inst_26255,inst_26258);
var inst_26260 = (function(){throw inst_26259})();
var state_26436__$1 = state_26436;
var statearr_26462_26523 = state_26436__$1;
(statearr_26462_26523[(2)] = inst_26260);

(statearr_26462_26523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (28))){
var inst_26280 = (state_26436[(30)]);
var inst_26395 = (state_26436[(2)]);
var state_26436__$1 = (function (){var statearr_26463 = state_26436;
(statearr_26463[(35)] = inst_26395);

return statearr_26463;
})();
if(cljs.core.truth_(inst_26280)){
var statearr_26464_26524 = state_26436__$1;
(statearr_26464_26524[(1)] = (30));

} else {
var statearr_26465_26525 = state_26436__$1;
(statearr_26465_26525[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (25))){
var inst_26386 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
if(cljs.core.truth_(inst_26386)){
var statearr_26466_26526 = state_26436__$1;
(statearr_26466_26526[(1)] = (26));

} else {
var statearr_26467_26527 = state_26436__$1;
(statearr_26467_26527[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (34))){
var inst_26368 = (state_26436[(26)]);
var inst_26360 = (state_26436[(10)]);
var inst_26416 = cljs.core.conj.call(null,inst_26360,inst_26368);
var state_26436__$1 = state_26436;
var statearr_26468_26528 = state_26436__$1;
(statearr_26468_26528[(2)] = inst_26416);

(statearr_26468_26528[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (17))){
var inst_26308 = (state_26436[(36)]);
var inst_26312 = (state_26436[(2)]);
var inst_26313 = fluree.db.util.async.throw_err.call(null,inst_26312);
var inst_26300 = inst_26308;
var inst_26301 = inst_26313;
var state_26436__$1 = (function (){var statearr_26469 = state_26436;
(statearr_26469[(22)] = inst_26301);

(statearr_26469[(37)] = inst_26300);

return statearr_26469;
})();
var statearr_26470_26529 = state_26436__$1;
(statearr_26470_26529[(2)] = null);

(statearr_26470_26529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (3))){
var inst_26434 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26436__$1,inst_26434);
} else {
if((state_val_26437 === (12))){
var inst_26307 = (state_26436[(38)]);
var inst_26300 = (state_26436[(37)]);
var inst_26306 = cljs.core.seq.call(null,inst_26300);
var inst_26307__$1 = cljs.core.first.call(null,inst_26306);
var inst_26308 = cljs.core.next.call(null,inst_26306);
var state_26436__$1 = (function (){var statearr_26471 = state_26436;
(statearr_26471[(36)] = inst_26308);

(statearr_26471[(38)] = inst_26307__$1);

return statearr_26471;
})();
if(cljs.core.truth_(inst_26307__$1)){
var statearr_26472_26530 = state_26436__$1;
(statearr_26472_26530[(1)] = (14));

} else {
var statearr_26473_26531 = state_26436__$1;
(statearr_26473_26531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (2))){
var inst_26248 = (state_26436[(23)]);
var _ = (function (){var statearr_26474 = state_26436;
(statearr_26474[(4)] = cljs.core.cons.call(null,(5),(state_26436[(4)])));

return statearr_26474;
})();
var inst_26247 = cljs.core.first.call(null,flakes);
var inst_26248__$1 = inst_26247.t;
var inst_26249 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26250 = (inst_26249 - (1));
var inst_26251 = cljs.core.not_EQ_.call(null,inst_26248__$1,inst_26250);
var state_26436__$1 = (function (){var statearr_26475 = state_26436;
(statearr_26475[(23)] = inst_26248__$1);

return statearr_26475;
})();
if(inst_26251){
var statearr_26476_26532 = state_26436__$1;
(statearr_26476_26532[(1)] = (6));

} else {
var statearr_26477_26533 = state_26436__$1;
(statearr_26477_26533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (23))){
var inst_26279 = (state_26436[(8)]);
var state_26436__$1 = state_26436;
var statearr_26478_26534 = state_26436__$1;
(statearr_26478_26534[(2)] = inst_26279);

(statearr_26478_26534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (35))){
var inst_26360 = (state_26436[(10)]);
var state_26436__$1 = state_26436;
var statearr_26479_26535 = state_26436__$1;
(statearr_26479_26535[(2)] = inst_26360);

(statearr_26479_26535[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (19))){
var inst_26431 = (state_26436[(2)]);
var _ = (function (){var statearr_26480 = state_26436;
(statearr_26480[(4)] = cljs.core.rest.call(null,(state_26436[(4)])));

return statearr_26480;
})();
var state_26436__$1 = state_26436;
var statearr_26481_26536 = state_26436__$1;
(statearr_26481_26536[(2)] = inst_26431);

(statearr_26481_26536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (11))){
var inst_26288 = (state_26436[(32)]);
var inst_26288__$1 = (state_26436[(2)]);
var inst_26296 = cljs.core.seq.call(null,inst_26288__$1);
var inst_26297 = cljs.core.first.call(null,inst_26296);
var inst_26298 = cljs.core.next.call(null,inst_26296);
var inst_26299 = db;
var inst_26300 = inst_26288__$1;
var inst_26301 = inst_26299;
var state_26436__$1 = (function (){var statearr_26483 = state_26436;
(statearr_26483[(22)] = inst_26301);

(statearr_26483[(39)] = inst_26298);

(statearr_26483[(37)] = inst_26300);

(statearr_26483[(40)] = inst_26297);

(statearr_26483[(32)] = inst_26288__$1);

return statearr_26483;
})();
var statearr_26484_26537 = state_26436__$1;
(statearr_26484_26537[(2)] = null);

(statearr_26484_26537[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (9))){
var inst_26282 = (state_26436[(24)]);
var inst_26265 = (state_26436[(31)]);
var inst_26284 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26265,inst_26282);
var state_26436__$1 = state_26436;
var statearr_26485_26538 = state_26436__$1;
(statearr_26485_26538[(2)] = inst_26284);

(statearr_26485_26538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (5))){
var _ = (function (){var statearr_26486 = state_26436;
(statearr_26486[(4)] = cljs.core.rest.call(null,(state_26436[(4)])));

return statearr_26486;
})();
var state_26436__$1 = state_26436;
var ex26482 = (state_26436__$1[(2)]);
var statearr_26487_26539 = state_26436__$1;
(statearr_26487_26539[(5)] = ex26482);


if((ex26482 instanceof Error)){
var statearr_26488_26540 = state_26436__$1;
(statearr_26488_26540[(1)] = (4));

(statearr_26488_26540[(5)] = null);

} else {
throw ex26482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (14))){
var inst_26301 = (state_26436[(22)]);
var inst_26307 = (state_26436[(38)]);
var inst_26310 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26301,inst_26307);
var state_26436__$1 = state_26436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26436__$1,(17),inst_26310);
} else {
if((state_val_26437 === (26))){
var inst_26380 = (state_26436[(15)]);
var inst_26388 = fluree.db.query.schema.schema_map.call(null,inst_26380);
var state_26436__$1 = state_26436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26436__$1,(29),inst_26388);
} else {
if((state_val_26437 === (16))){
var inst_26317 = (state_26436[(2)]);
var state_26436__$1 = state_26436;
var statearr_26489_26541 = state_26436__$1;
(statearr_26489_26541[(2)] = inst_26317);

(statearr_26489_26541[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (38))){
var inst_26361 = (state_26436[(11)]);
var state_26436__$1 = state_26436;
var statearr_26490_26542 = state_26436__$1;
(statearr_26490_26542[(2)] = inst_26361);

(statearr_26490_26542[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (30))){
var inst_26395 = (state_26436[(35)]);
var inst_26398 = fluree.db.query.schema.setting_map.call(null,inst_26395);
var state_26436__$1 = state_26436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26436__$1,(33),inst_26398);
} else {
if((state_val_26437 === (10))){
var inst_26286 = cljs.core.PersistentVector.EMPTY;
var state_26436__$1 = state_26436;
var statearr_26491_26543 = state_26436__$1;
(statearr_26491_26543[(2)] = inst_26286);

(statearr_26491_26543[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (18))){
var inst_26357 = (state_26436[(21)]);
var inst_26368 = (state_26436[(26)]);
var inst_26367 = cljs.core.seq.call(null,inst_26357);
var inst_26368__$1 = cljs.core.first.call(null,inst_26367);
var inst_26369 = cljs.core.next.call(null,inst_26367);
var inst_26370 = cljs.core.not.call(null,inst_26368__$1);
var state_26436__$1 = (function (){var statearr_26492 = state_26436;
(statearr_26492[(26)] = inst_26368__$1);

(statearr_26492[(18)] = inst_26369);

return statearr_26492;
})();
if(inst_26370){
var statearr_26493_26544 = state_26436__$1;
(statearr_26493_26544[(1)] = (20));

} else {
var statearr_26494_26545 = state_26436__$1;
(statearr_26494_26545[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (37))){
var inst_26368 = (state_26436[(26)]);
var inst_26361 = (state_26436[(11)]);
var inst_26423 = cljs.core.conj.call(null,inst_26361,inst_26368);
var state_26436__$1 = state_26436;
var statearr_26495_26546 = state_26436__$1;
(statearr_26495_26546[(2)] = inst_26423);

(statearr_26495_26546[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26437 === (8))){
var inst_26248 = (state_26436[(23)]);
var inst_26273 = (state_26436[(25)]);
var inst_26279 = (state_26436[(8)]);
var inst_26263 = (state_26436[(27)]);
var inst_26269 = (state_26436[(28)]);
var inst_26265 = (state_26436[(31)]);
var inst_26263__$1 = (state_26436[(2)]);
var inst_26264 = (function (){var t = inst_26248;
var _ = inst_26263__$1;
return (function (p1__26238_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26238_SHARP_.p));
});
})();
var inst_26265__$1 = cljs.core.filter.call(null,inst_26264,flakes);
var inst_26266 = cljs.core.PersistentHashSet.EMPTY;
var inst_26267 = (function (){var t = inst_26248;
var _ = inst_26263__$1;
var add_flakes = inst_26265__$1;
return (function (p1__26239_SHARP_){
return p1__26239_SHARP_.p;
});
})();
var inst_26268 = cljs.core.map.call(null,inst_26267,inst_26265__$1);
var inst_26269__$1 = cljs.core.into.call(null,inst_26266,inst_26268);
var inst_26270 = cljs.core.PersistentHashMap.EMPTY;
var inst_26271 = (function (){var t = inst_26248;
var _ = inst_26263__$1;
var add_flakes = inst_26265__$1;
var add_preds = inst_26269__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26272 = cljs.core.map.call(null,inst_26271,inst_26269__$1);
var inst_26273__$1 = cljs.core.into.call(null,inst_26270,inst_26272);
var inst_26274 = cljs.core.PersistentHashMap.EMPTY;
var inst_26275 = (function (){var t = inst_26248;
var _ = inst_26263__$1;
var add_flakes = inst_26265__$1;
var add_preds = inst_26269__$1;
var idx_QMARK__map = inst_26273__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26276 = cljs.core.map.call(null,inst_26275,inst_26269__$1);
var inst_26277 = cljs.core.into.call(null,inst_26274,inst_26276);
var inst_26278 = fluree.db.flake.size_bytes.call(null,inst_26265__$1);
var inst_26279__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26265__$1);
var inst_26280 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26265__$1);
var inst_26281 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26282 = cljs.core.get.call(null,inst_26281,(0));
var state_26436__$1 = (function (){var statearr_26496 = state_26436;
(statearr_26496[(24)] = inst_26282);

(statearr_26496[(25)] = inst_26273__$1);

(statearr_26496[(8)] = inst_26279__$1);

(statearr_26496[(27)] = inst_26263__$1);

(statearr_26496[(28)] = inst_26269__$1);

(statearr_26496[(30)] = inst_26280);

(statearr_26496[(31)] = inst_26265__$1);

(statearr_26496[(14)] = inst_26278);

(statearr_26496[(33)] = inst_26277);

return statearr_26496;
})();
if(cljs.core.truth_(inst_26279__$1)){
var statearr_26497_26547 = state_26436__$1;
(statearr_26497_26547[(1)] = (9));

} else {
var statearr_26498_26548 = state_26436__$1;
(statearr_26498_26548[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2454__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2454__auto____0 = (function (){
var statearr_26499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26499[(0)] = fluree$db$graphdb$with_t_$_state_machine__2454__auto__);

(statearr_26499[(1)] = (1));

return statearr_26499;
});
var fluree$db$graphdb$with_t_$_state_machine__2454__auto____1 = (function (state_26436){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_26436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e26500){var ex__2457__auto__ = e26500;
var statearr_26501_26549 = state_26436;
(statearr_26501_26549[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_26436[(4)]))){
var statearr_26502_26550 = state_26436;
(statearr_26502_26550[(1)] = cljs.core.first.call(null,(state_26436[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26551 = state_26436;
state_26436 = G__26551;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2454__auto__ = function(state_26436){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2454__auto____1.call(this,state_26436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2454__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2454__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_26503 = f__2477__auto__.call(null);
(statearr_26503[(6)] = c__2476__auto__);

return statearr_26503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2476__auto___26697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_26647){
var state_val_26648 = (state_26647[(1)]);
if((state_val_26648 === (7))){
var state_26647__$1 = state_26647;
var statearr_26649_26698 = state_26647__$1;
(statearr_26649_26698[(2)] = null);

(statearr_26649_26698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (20))){
var inst_26596 = (state_26647[(7)]);
var inst_26595 = (state_26647[(8)]);
var inst_26597 = (state_26647[(9)]);
var inst_26616 = (inst_26595 + (1));
var inst_26617 = cljs.core.assoc.call(null,inst_26597,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26616);
var inst_26618 = fluree.db.graphdb.with_t.call(null,inst_26617,inst_26596);
var state_26647__$1 = state_26647;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26647__$1,(23),inst_26618);
} else {
if((state_val_26648 === (1))){
var state_26647__$1 = state_26647;
var statearr_26650_26699 = state_26647__$1;
(statearr_26650_26699[(2)] = null);

(statearr_26650_26699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (24))){
var inst_26621 = (state_26647[(10)]);
var inst_26624 = cljs.core.assoc.call(null,inst_26621,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26647__$1 = state_26647;
var statearr_26651_26700 = state_26647__$1;
(statearr_26651_26700[(2)] = inst_26624);

(statearr_26651_26700[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (4))){
var inst_26552 = (state_26647[(2)]);
var inst_26553 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26552);
var state_26647__$1 = state_26647;
var statearr_26652_26701 = state_26647__$1;
(statearr_26652_26701[(2)] = inst_26553);

(statearr_26652_26701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (15))){
var inst_26603 = (state_26647[(11)]);
var state_26647__$1 = state_26647;
var statearr_26653_26702 = state_26647__$1;
(statearr_26653_26702[(2)] = inst_26603);

(statearr_26653_26702[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (21))){
var state_26647__$1 = state_26647;
var statearr_26654_26703 = state_26647__$1;
(statearr_26654_26703[(2)] = null);

(statearr_26654_26703[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (13))){
var inst_26639 = (state_26647[(2)]);
var inst_26640 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26639);
var state_26647__$1 = state_26647;
var statearr_26655_26704 = state_26647__$1;
(statearr_26655_26704[(2)] = inst_26640);

(statearr_26655_26704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (22))){
var inst_26635 = (state_26647[(2)]);
var state_26647__$1 = state_26647;
var statearr_26656_26705 = state_26647__$1;
(statearr_26656_26705[(2)] = inst_26635);

(statearr_26656_26705[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (6))){
var inst_26563 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26564 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26565 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26563)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26564)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26566 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26567 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26568 = cljs.core.PersistentHashMap.fromArrays(inst_26566,inst_26567);
var inst_26569 = cljs.core.ex_info.call(null,inst_26565,inst_26568);
var inst_26570 = (function(){throw inst_26569})();
var state_26647__$1 = state_26647;
var statearr_26659_26706 = state_26647__$1;
(statearr_26659_26706[(2)] = inst_26570);

(statearr_26659_26706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (25))){
var inst_26603 = (state_26647[(11)]);
var inst_26604 = (state_26647[(12)]);
var inst_26621 = (state_26647[(10)]);
var inst_26626 = inst_26603.t;
var inst_26627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26628 = [inst_26603];
var inst_26629 = (new cljs.core.PersistentVector(null,1,(5),inst_26627,inst_26628,null));
var inst_26594 = inst_26604;
var inst_26595 = inst_26626;
var inst_26596 = inst_26629;
var inst_26597 = inst_26621;
var state_26647__$1 = (function (){var statearr_26660 = state_26647;
(statearr_26660[(7)] = inst_26596);

(statearr_26660[(8)] = inst_26595);

(statearr_26660[(13)] = inst_26594);

(statearr_26660[(9)] = inst_26597);

return statearr_26660;
})();
var statearr_26661_26707 = state_26647__$1;
(statearr_26661_26707[(2)] = null);

(statearr_26661_26707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (17))){
var inst_26603 = (state_26647[(11)]);
var inst_26596 = (state_26647[(7)]);
var inst_26595 = (state_26647[(8)]);
var inst_26604 = (state_26647[(12)]);
var inst_26597 = (state_26647[(9)]);
var inst_26612 = cljs.core.conj.call(null,inst_26596,inst_26603);
var tmp26657 = inst_26595;
var tmp26658 = inst_26597;
var inst_26594 = inst_26604;
var inst_26595__$1 = tmp26657;
var inst_26596__$1 = inst_26612;
var inst_26597__$1 = tmp26658;
var state_26647__$1 = (function (){var statearr_26662 = state_26647;
(statearr_26662[(7)] = inst_26596__$1);

(statearr_26662[(8)] = inst_26595__$1);

(statearr_26662[(13)] = inst_26594);

(statearr_26662[(9)] = inst_26597__$1);

return statearr_26662;
})();
var statearr_26663_26708 = state_26647__$1;
(statearr_26663_26708[(2)] = null);

(statearr_26663_26708[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (3))){
var inst_26645 = (state_26647[(2)]);
var state_26647__$1 = state_26647;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26647__$1,inst_26645);
} else {
if((state_val_26648 === (12))){
var inst_26603 = (state_26647[(11)]);
var inst_26594 = (state_26647[(13)]);
var inst_26602 = cljs.core.seq.call(null,inst_26594);
var inst_26603__$1 = cljs.core.first.call(null,inst_26602);
var inst_26604 = cljs.core.next.call(null,inst_26602);
var state_26647__$1 = (function (){var statearr_26664 = state_26647;
(statearr_26664[(11)] = inst_26603__$1);

(statearr_26664[(12)] = inst_26604);

return statearr_26664;
})();
if(cljs.core.truth_(inst_26603__$1)){
var statearr_26665_26709 = state_26647__$1;
(statearr_26665_26709[(1)] = (14));

} else {
var statearr_26666_26710 = state_26647__$1;
(statearr_26666_26710[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (2))){
var _ = (function (){var statearr_26667 = state_26647;
(statearr_26667[(4)] = cljs.core.cons.call(null,(5),(state_26647[(4)])));

return statearr_26667;
})();
var inst_26559 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26560 = (inst_26559 + (1));
var inst_26561 = cljs.core.not_EQ_.call(null,block,inst_26560);
var state_26647__$1 = state_26647;
if(inst_26561){
var statearr_26668_26711 = state_26647__$1;
(statearr_26668_26711[(1)] = (6));

} else {
var statearr_26669_26712 = state_26647__$1;
(statearr_26669_26712[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (23))){
var inst_26603 = (state_26647[(11)]);
var inst_26620 = (state_26647[(2)]);
var inst_26621 = fluree.db.util.async.throw_err.call(null,inst_26620);
var inst_26622 = (inst_26603 == null);
var state_26647__$1 = (function (){var statearr_26670 = state_26647;
(statearr_26670[(10)] = inst_26621);

return statearr_26670;
})();
if(cljs.core.truth_(inst_26622)){
var statearr_26671_26713 = state_26647__$1;
(statearr_26671_26713[(1)] = (24));

} else {
var statearr_26672_26714 = state_26647__$1;
(statearr_26672_26714[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (19))){
var inst_26637 = (state_26647[(2)]);
var state_26647__$1 = state_26647;
var statearr_26673_26715 = state_26647__$1;
(statearr_26673_26715[(2)] = inst_26637);

(statearr_26673_26715[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (11))){
var inst_26642 = (state_26647[(2)]);
var _ = (function (){var statearr_26675 = state_26647;
(statearr_26675[(4)] = cljs.core.rest.call(null,(state_26647[(4)])));

return statearr_26675;
})();
var state_26647__$1 = state_26647;
var statearr_26676_26716 = state_26647__$1;
(statearr_26676_26716[(2)] = inst_26642);

(statearr_26676_26716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (9))){
var inst_26576 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26577 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26576);
var state_26647__$1 = state_26647;
var statearr_26677_26717 = state_26647__$1;
(statearr_26677_26717[(2)] = inst_26577);

(statearr_26677_26717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (5))){
var _ = (function (){var statearr_26678 = state_26647;
(statearr_26678[(4)] = cljs.core.rest.call(null,(state_26647[(4)])));

return statearr_26678;
})();
var state_26647__$1 = state_26647;
var ex26674 = (state_26647__$1[(2)]);
var statearr_26679_26718 = state_26647__$1;
(statearr_26679_26718[(5)] = ex26674);


if((ex26674 instanceof java.lang.Exception)){
var statearr_26680_26719 = state_26647__$1;
(statearr_26680_26719[(1)] = (4));

(statearr_26680_26719[(5)] = null);

} else {
throw ex26674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (14))){
var inst_26603 = (state_26647[(11)]);
var inst_26595 = (state_26647[(8)]);
var inst_26606 = inst_26603.t;
var inst_26607 = cljs.core._EQ_.call(null,inst_26595,inst_26606);
var state_26647__$1 = state_26647;
var statearr_26681_26720 = state_26647__$1;
(statearr_26681_26720[(2)] = inst_26607);

(statearr_26681_26720[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (26))){
var inst_26632 = (state_26647[(2)]);
var state_26647__$1 = state_26647;
var statearr_26682_26721 = state_26647__$1;
(statearr_26682_26721[(2)] = inst_26632);

(statearr_26682_26721[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (16))){
var inst_26610 = (state_26647[(2)]);
var state_26647__$1 = state_26647;
if(cljs.core.truth_(inst_26610)){
var statearr_26683_26722 = state_26647__$1;
(statearr_26683_26722[(1)] = (17));

} else {
var statearr_26684_26723 = state_26647__$1;
(statearr_26684_26723[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (10))){
var inst_26579 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26587 = cljs.core.seq.call(null,inst_26579);
var inst_26588 = cljs.core.first.call(null,inst_26587);
var inst_26589 = cljs.core.next.call(null,inst_26587);
var inst_26590 = cljs.core.first.call(null,inst_26579);
var inst_26591 = inst_26590.t;
var inst_26592 = cljs.core.PersistentVector.EMPTY;
var inst_26593 = db;
var inst_26594 = inst_26579;
var inst_26595 = inst_26591;
var inst_26596 = inst_26592;
var inst_26597 = inst_26593;
var state_26647__$1 = (function (){var statearr_26685 = state_26647;
(statearr_26685[(14)] = inst_26589);

(statearr_26685[(15)] = inst_26588);

(statearr_26685[(7)] = inst_26596);

(statearr_26685[(8)] = inst_26595);

(statearr_26685[(13)] = inst_26594);

(statearr_26685[(9)] = inst_26597);

return statearr_26685;
})();
var statearr_26686_26724 = state_26647__$1;
(statearr_26686_26724[(2)] = null);

(statearr_26686_26724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (18))){
var state_26647__$1 = state_26647;
var statearr_26687_26725 = state_26647__$1;
(statearr_26687_26725[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26648 === (8))){
var inst_26573 = (state_26647[(2)]);
var inst_26574 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26647__$1 = (function (){var statearr_26689 = state_26647;
(statearr_26689[(16)] = inst_26573);

return statearr_26689;
})();
if(inst_26574){
var statearr_26690_26726 = state_26647__$1;
(statearr_26690_26726[(1)] = (9));

} else {
var statearr_26691_26727 = state_26647__$1;
(statearr_26691_26727[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2454__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2454__auto____0 = (function (){
var statearr_26692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26692[(0)] = fluree$db$graphdb$with_$_state_machine__2454__auto__);

(statearr_26692[(1)] = (1));

return statearr_26692;
});
var fluree$db$graphdb$with_$_state_machine__2454__auto____1 = (function (state_26647){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_26647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e26693){var ex__2457__auto__ = e26693;
var statearr_26694_26728 = state_26647;
(statearr_26694_26728[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_26647[(4)]))){
var statearr_26695_26729 = state_26647;
(statearr_26695_26729[(1)] = cljs.core.first.call(null,(state_26647[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26730 = state_26647;
state_26647 = G__26730;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2454__auto__ = function(state_26647){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2454__auto____1.call(this,state_26647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2454__auto____0;
fluree$db$graphdb$with_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2454__auto____1;
return fluree$db$graphdb$with_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_26696 = f__2477__auto__.call(null);
(statearr_26696[(6)] = c__2476__auto___26697);

return statearr_26696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_26786){
var state_val_26787 = (state_26786[(1)]);
if((state_val_26787 === (7))){
var state_26786__$1 = state_26786;
var statearr_26788_26815 = state_26786__$1;
(statearr_26788_26815[(2)] = tt_id);

(statearr_26788_26815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (1))){
var state_26786__$1 = state_26786;
var statearr_26789_26816 = state_26786__$1;
(statearr_26789_26816[(2)] = null);

(statearr_26789_26816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (4))){
var inst_26731 = (state_26786[(2)]);
var state_26786__$1 = state_26786;
var statearr_26790_26817 = state_26786__$1;
(statearr_26790_26817[(2)] = inst_26731);

(statearr_26790_26817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (13))){
var inst_26779 = (state_26786[(2)]);
var state_26786__$1 = state_26786;
var statearr_26791_26818 = state_26786__$1;
(statearr_26791_26818[(2)] = inst_26779);

(statearr_26791_26818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (6))){
var inst_26739 = fluree.db.util.core.random_uuid.call(null);
var state_26786__$1 = state_26786;
var statearr_26792_26819 = state_26786__$1;
(statearr_26792_26819[(2)] = inst_26739);

(statearr_26792_26819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (3))){
var inst_26784 = (state_26786[(2)]);
var state_26786__$1 = state_26786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26786__$1,inst_26784);
} else {
if((state_val_26787 === (12))){
var inst_26762 = (state_26786[(7)]);
var state_26786__$1 = state_26786;
var statearr_26793_26820 = state_26786__$1;
(statearr_26793_26820[(2)] = inst_26762);

(statearr_26793_26820[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (2))){
var _ = (function (){var statearr_26794 = state_26786;
(statearr_26794[(4)] = cljs.core.cons.call(null,(5),(state_26786[(4)])));

return statearr_26794;
})();
var inst_26737 = (tt_id == null);
var state_26786__$1 = state_26786;
if(cljs.core.truth_(inst_26737)){
var statearr_26795_26821 = state_26786__$1;
(statearr_26795_26821[(1)] = (6));

} else {
var statearr_26796_26822 = state_26786__$1;
(statearr_26796_26822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (11))){
var inst_26769 = (state_26786[(8)]);
var inst_26762 = (state_26786[(7)]);
var inst_26772 = fluree.db.graphdb.with_t.call(null,inst_26762,inst_26769);
var state_26786__$1 = state_26786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26786__$1,(14),inst_26772);
} else {
if((state_val_26787 === (9))){
var inst_26769 = (state_26786[(8)]);
var inst_26763 = (state_26786[(9)]);
var inst_26768 = cljs.core.seq.call(null,inst_26763);
var inst_26769__$1 = cljs.core.first.call(null,inst_26768);
var inst_26770 = cljs.core.next.call(null,inst_26768);
var state_26786__$1 = (function (){var statearr_26798 = state_26786;
(statearr_26798[(8)] = inst_26769__$1);

(statearr_26798[(10)] = inst_26770);

return statearr_26798;
})();
if(cljs.core.truth_(inst_26769__$1)){
var statearr_26799_26823 = state_26786__$1;
(statearr_26799_26823[(1)] = (11));

} else {
var statearr_26800_26824 = state_26786__$1;
(statearr_26800_26824[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (5))){
var _ = (function (){var statearr_26801 = state_26786;
(statearr_26801[(4)] = cljs.core.rest.call(null,(state_26786[(4)])));

return statearr_26801;
})();
var state_26786__$1 = state_26786;
var ex26797 = (state_26786__$1[(2)]);
var statearr_26802_26825 = state_26786__$1;
(statearr_26802_26825[(5)] = ex26797);


if((ex26797 instanceof Error)){
var statearr_26803_26826 = state_26786__$1;
(statearr_26803_26826[(1)] = (4));

(statearr_26803_26826[(5)] = null);

} else {
throw ex26797;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (14))){
var inst_26770 = (state_26786[(10)]);
var inst_26774 = (state_26786[(2)]);
var inst_26775 = fluree.db.util.async.throw_err.call(null,inst_26774);
var inst_26762 = inst_26775;
var inst_26763 = inst_26770;
var state_26786__$1 = (function (){var statearr_26804 = state_26786;
(statearr_26804[(7)] = inst_26762);

(statearr_26804[(9)] = inst_26763);

return statearr_26804;
})();
var statearr_26805_26827 = state_26786__$1;
(statearr_26805_26827[(2)] = null);

(statearr_26805_26827[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (10))){
var inst_26781 = (state_26786[(2)]);
var _ = (function (){var statearr_26806 = state_26786;
(statearr_26806[(4)] = cljs.core.rest.call(null,(state_26786[(4)])));

return statearr_26806;
})();
var state_26786__$1 = state_26786;
var statearr_26807_26828 = state_26786__$1;
(statearr_26807_26828[(2)] = inst_26781);

(statearr_26807_26828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26787 === (8))){
var inst_26742 = (state_26786[(2)]);
var inst_26743 = (function (){var tt_id_SINGLEQUOTE_ = inst_26742;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26744 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26742);
var inst_26745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26746 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26747 = (new cljs.core.PersistentVector(null,4,(5),inst_26745,inst_26746,null));
var inst_26748 = cljs.core.reduce.call(null,inst_26743,inst_26744,inst_26747);
var inst_26749 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26750 = cljs.core.reverse.call(null,inst_26749);
var inst_26751 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26750);
var inst_26759 = cljs.core.seq.call(null,inst_26751);
var inst_26760 = cljs.core.first.call(null,inst_26759);
var inst_26761 = cljs.core.next.call(null,inst_26759);
var inst_26762 = inst_26748;
var inst_26763 = inst_26751;
var state_26786__$1 = (function (){var statearr_26808 = state_26786;
(statearr_26808[(11)] = inst_26760);

(statearr_26808[(12)] = inst_26761);

(statearr_26808[(7)] = inst_26762);

(statearr_26808[(9)] = inst_26763);

return statearr_26808;
})();
var statearr_26809_26829 = state_26786__$1;
(statearr_26809_26829[(2)] = null);

(statearr_26809_26829[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____0 = (function (){
var statearr_26810 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26810[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__);

(statearr_26810[(1)] = (1));

return statearr_26810;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____1 = (function (state_26786){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_26786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e26811){var ex__2457__auto__ = e26811;
var statearr_26812_26830 = state_26786;
(statearr_26812_26830[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_26786[(4)]))){
var statearr_26813_26831 = state_26786;
(statearr_26813_26831[(1)] = cljs.core.first.call(null,(state_26786[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26832 = state_26786;
state_26786 = G__26832;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__ = function(state_26786){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____1.call(this,state_26786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_26814 = f__2477__auto__.call(null);
(statearr_26814[(6)] = c__2476__auto__);

return statearr_26814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2476__auto___27010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_26947){
var state_val_26948 = (state_26947[(1)]);
if((state_val_26948 === (7))){
var inst_26860 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var inst_26861 = cljs.core.first.call(null,ident);
var inst_26862 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26861);
var inst_26863 = (inst_26862 == null);
var inst_26864 = ((inst_26860) && (inst_26863));
var state_26947__$1 = state_26947;
if(cljs.core.truth_(inst_26864)){
var statearr_26949_27011 = state_26947__$1;
(statearr_26949_27011[(1)] = (13));

} else {
var statearr_26950_27012 = state_26947__$1;
(statearr_26950_27012[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (20))){
var state_26947__$1 = state_26947;
var statearr_26951_27013 = state_26947__$1;
(statearr_26951_27013[(2)] = null);

(statearr_26951_27013[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (27))){
var state_26947__$1 = state_26947;
var statearr_26952_27014 = state_26947__$1;
(statearr_26952_27014[(2)] = null);

(statearr_26952_27014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (1))){
var state_26947__$1 = state_26947;
var statearr_26953_27015 = state_26947__$1;
(statearr_26953_27015[(2)] = null);

(statearr_26953_27015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (24))){
var inst_26893 = (state_26947[(7)]);
var inst_26897 = inst_26893.s;
var state_26947__$1 = state_26947;
var statearr_26954_27016 = state_26947__$1;
(statearr_26954_27016[(2)] = inst_26897);

(statearr_26954_27016[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (39))){
var state_26947__$1 = state_26947;
var statearr_26955_27017 = state_26947__$1;
(statearr_26955_27017[(2)] = null);

(statearr_26955_27017[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (4))){
var inst_26833 = (state_26947[(2)]);
var inst_26834 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26835 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26836 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26837 = cljs.core.PersistentHashMap.fromArrays(inst_26835,inst_26836);
var inst_26838 = cljs.core.ex_info.call(null,inst_26834,inst_26837,inst_26833);
var inst_26839 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26838);
var state_26947__$1 = state_26947;
var statearr_26956_27018 = state_26947__$1;
(statearr_26956_27018[(2)] = inst_26839);

(statearr_26956_27018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (15))){
var inst_26915 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_26957_27019 = state_26947__$1;
(statearr_26957_27019[(2)] = inst_26915);

(statearr_26957_27019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (21))){
var inst_26887 = (state_26947[(8)]);
var inst_26891 = cljs.core.first.call(null,inst_26887);
var state_26947__$1 = state_26947;
var statearr_26958_27020 = state_26947__$1;
(statearr_26958_27020[(2)] = inst_26891);

(statearr_26958_27020[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (31))){
var inst_26942 = (state_26947[(2)]);
var _ = (function (){var statearr_26959 = state_26947;
(statearr_26959[(4)] = cljs.core.rest.call(null,(state_26947[(4)])));

return statearr_26959;
})();
var state_26947__$1 = state_26947;
var statearr_26960_27021 = state_26947__$1;
(statearr_26960_27021[(2)] = inst_26942);

(statearr_26960_27021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (32))){
var state_26947__$1 = state_26947;
var statearr_26961_27022 = state_26947__$1;
(statearr_26961_27022[(2)] = strict_QMARK_);

(statearr_26961_27022[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (40))){
var inst_26938 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_26962_27023 = state_26947__$1;
(statearr_26962_27023[(2)] = inst_26938);

(statearr_26962_27023[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (33))){
var state_26947__$1 = state_26947;
var statearr_26963_27024 = state_26947__$1;
(statearr_26963_27024[(2)] = false);

(statearr_26963_27024[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (13))){
var inst_26866 = cljs.core.first.call(null,ident);
var inst_26867 = cljs.core.pr_str.call(null,inst_26866);
var inst_26868 = ["Subject ID lookup failed. The predicate ",inst_26867," does not exist."].join('');
var inst_26869 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26870 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26871 = cljs.core.PersistentHashMap.fromArrays(inst_26869,inst_26870);
var inst_26872 = cljs.core.ex_info.call(null,inst_26868,inst_26871);
var inst_26873 = (function(){throw inst_26872})();
var state_26947__$1 = state_26947;
var statearr_26964_27025 = state_26947__$1;
(statearr_26964_27025[(2)] = inst_26873);

(statearr_26964_27025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (22))){
var inst_26893 = (state_26947[(7)]);
var inst_26893__$1 = (state_26947[(2)]);
var inst_26894 = (inst_26893__$1 == null);
var state_26947__$1 = (function (){var statearr_26965 = state_26947;
(statearr_26965[(7)] = inst_26893__$1);

return statearr_26965;
})();
if(cljs.core.truth_(inst_26894)){
var statearr_26966_27026 = state_26947__$1;
(statearr_26966_27026[(1)] = (23));

} else {
var statearr_26967_27027 = state_26947__$1;
(statearr_26967_27027[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (36))){
var state_26947__$1 = state_26947;
var statearr_26968_27028 = state_26947__$1;
(statearr_26968_27028[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (29))){
var inst_26917 = (state_26947[(9)]);
var inst_26919 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26917);
var state_26947__$1 = state_26947;
var statearr_26970_27029 = state_26947__$1;
(statearr_26970_27029[(2)] = inst_26919);

(statearr_26970_27029[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (6))){
var inst_26847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26848 = [ident];
var inst_26849 = (new cljs.core.PersistentVector(null,1,(5),inst_26847,inst_26848,null));
var inst_26850 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26849);
var state_26947__$1 = state_26947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26947__$1,(9),inst_26850);
} else {
if((state_val_26948 === (28))){
var inst_26911 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_26971_27030 = state_26947__$1;
(statearr_26971_27030[(2)] = inst_26911);

(statearr_26971_27030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (25))){
var inst_26899 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_26972_27031 = state_26947__$1;
(statearr_26972_27031[(2)] = inst_26899);

(statearr_26972_27031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (34))){
var inst_26925 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
if(cljs.core.truth_(inst_26925)){
var statearr_26973_27032 = state_26947__$1;
(statearr_26973_27032[(1)] = (35));

} else {
var statearr_26974_27033 = state_26947__$1;
(statearr_26974_27033[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (17))){
var state_26947__$1 = state_26947;
var statearr_26975_27034 = state_26947__$1;
(statearr_26975_27034[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (3))){
var inst_26945 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26947__$1,inst_26945);
} else {
if((state_val_26948 === (12))){
var inst_26858 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_26977_27035 = state_26947__$1;
(statearr_26977_27035[(2)] = inst_26858);

(statearr_26977_27035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (2))){
var _ = (function (){var statearr_26978 = state_26947;
(statearr_26978[(4)] = cljs.core.cons.call(null,(5),(state_26947[(4)])));

return statearr_26978;
})();
var inst_26845 = typeof ident === 'number';
var state_26947__$1 = state_26947;
if(cljs.core.truth_(inst_26845)){
var statearr_26979_27036 = state_26947__$1;
(statearr_26979_27036[(1)] = (6));

} else {
var statearr_26980_27037 = state_26947__$1;
(statearr_26980_27037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (23))){
var state_26947__$1 = state_26947;
var statearr_26981_27038 = state_26947__$1;
(statearr_26981_27038[(2)] = null);

(statearr_26981_27038[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (35))){
var inst_26927 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26929 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26930 = cljs.core.PersistentHashMap.fromArrays(inst_26928,inst_26929);
var inst_26931 = cljs.core.ex_info.call(null,inst_26927,inst_26930);
var inst_26932 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26931);
var state_26947__$1 = state_26947;
var statearr_26982_27039 = state_26947__$1;
(statearr_26982_27039[(2)] = inst_26932);

(statearr_26982_27039[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (19))){
var inst_26887 = (state_26947[(8)]);
var inst_26886 = (state_26947[(2)]);
var inst_26887__$1 = fluree.db.util.async.throw_err.call(null,inst_26886);
var inst_26888 = (inst_26887__$1 == null);
var state_26947__$1 = (function (){var statearr_26983 = state_26947;
(statearr_26983[(8)] = inst_26887__$1);

return statearr_26983;
})();
if(cljs.core.truth_(inst_26888)){
var statearr_26984_27040 = state_26947__$1;
(statearr_26984_27040[(1)] = (20));

} else {
var statearr_26985_27041 = state_26947__$1;
(statearr_26985_27041[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (11))){
var state_26947__$1 = state_26947;
var statearr_26987_27042 = state_26947__$1;
(statearr_26987_27042[(2)] = null);

(statearr_26987_27042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (9))){
var inst_26852 = (state_26947[(2)]);
var inst_26853 = fluree.db.util.async.throw_err.call(null,inst_26852);
var inst_26854 = cljs.core.not_empty.call(null,inst_26853);
var state_26947__$1 = state_26947;
if(cljs.core.truth_(inst_26854)){
var statearr_26988_27043 = state_26947__$1;
(statearr_26988_27043[(1)] = (10));

} else {
var statearr_26989_27044 = state_26947__$1;
(statearr_26989_27044[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (5))){
var _ = (function (){var statearr_26990 = state_26947;
(statearr_26990[(4)] = cljs.core.rest.call(null,(state_26947[(4)])));

return statearr_26990;
})();
var state_26947__$1 = state_26947;
var ex26986 = (state_26947__$1[(2)]);
var statearr_26991_27045 = state_26947__$1;
(statearr_26991_27045[(5)] = ex26986);


if((ex26986 instanceof java.lang.Exception)){
var statearr_26992_27046 = state_26947__$1;
(statearr_26992_27046[(1)] = (4));

(statearr_26992_27046[(5)] = null);

} else {
throw ex26986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (14))){
var inst_26875 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26947__$1 = state_26947;
if(inst_26875){
var statearr_26993_27047 = state_26947__$1;
(statearr_26993_27047[(1)] = (16));

} else {
var statearr_26994_27048 = state_26947__$1;
(statearr_26994_27048[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (26))){
var inst_26902 = cljs.core.pr_str.call(null,ident);
var inst_26903 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26902].join('');
var inst_26904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26905 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26906 = cljs.core.PersistentHashMap.fromArrays(inst_26904,inst_26905);
var inst_26907 = cljs.core.ex_info.call(null,inst_26903,inst_26906);
var inst_26908 = (function(){throw inst_26907})();
var state_26947__$1 = state_26947;
var statearr_26995_27049 = state_26947__$1;
(statearr_26995_27049[(2)] = inst_26908);

(statearr_26995_27049[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (16))){
var inst_26878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26879 = cljs.core.first.call(null,ident);
var inst_26880 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26879);
var inst_26881 = cljs.core.second.call(null,ident);
var inst_26882 = [inst_26880,inst_26881];
var inst_26883 = (new cljs.core.PersistentVector(null,2,(5),inst_26878,inst_26882,null));
var inst_26884 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26883);
var state_26947__$1 = state_26947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26947__$1,(19),inst_26884);
} else {
if((state_val_26948 === (38))){
var inst_26935 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26947__$1 = state_26947;
var statearr_26996_27050 = state_26947__$1;
(statearr_26996_27050[(2)] = inst_26935);

(statearr_26996_27050[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (30))){
var inst_26917 = (state_26947[(9)]);
var inst_26921 = (inst_26917 == null);
var state_26947__$1 = state_26947;
if(cljs.core.truth_(inst_26921)){
var statearr_26997_27051 = state_26947__$1;
(statearr_26997_27051[(1)] = (32));

} else {
var statearr_26998_27052 = state_26947__$1;
(statearr_26998_27052[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (10))){
var state_26947__$1 = state_26947;
var statearr_26999_27053 = state_26947__$1;
(statearr_26999_27053[(2)] = ident);

(statearr_26999_27053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (18))){
var inst_26913 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_27000_27054 = state_26947__$1;
(statearr_27000_27054[(2)] = inst_26913);

(statearr_27000_27054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (37))){
var inst_26940 = (state_26947[(2)]);
var state_26947__$1 = state_26947;
var statearr_27001_27055 = state_26947__$1;
(statearr_27001_27055[(2)] = inst_26940);

(statearr_27001_27055[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26948 === (8))){
var inst_26917 = (state_26947[(9)]);
var inst_26917__$1 = (state_26947[(2)]);
var state_26947__$1 = (function (){var statearr_27002 = state_26947;
(statearr_27002[(9)] = inst_26917__$1);

return statearr_27002;
})();
if(cljs.core.truth_(inst_26917__$1)){
var statearr_27003_27056 = state_26947__$1;
(statearr_27003_27056[(1)] = (29));

} else {
var statearr_27004_27057 = state_26947__$1;
(statearr_27004_27057[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2454__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2454__auto____0 = (function (){
var statearr_27005 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27005[(0)] = fluree$db$graphdb$subid_$_state_machine__2454__auto__);

(statearr_27005[(1)] = (1));

return statearr_27005;
});
var fluree$db$graphdb$subid_$_state_machine__2454__auto____1 = (function (state_26947){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_26947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27006){var ex__2457__auto__ = e27006;
var statearr_27007_27058 = state_26947;
(statearr_27007_27058[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_26947[(4)]))){
var statearr_27008_27059 = state_26947;
(statearr_27008_27059[(1)] = cljs.core.first.call(null,(state_26947[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27060 = state_26947;
state_26947 = G__27060;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2454__auto__ = function(state_26947){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2454__auto____1.call(this,state_26947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2454__auto____0;
fluree$db$graphdb$subid_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2454__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27009 = f__2477__auto__.call(null);
(statearr_27009[(6)] = c__2476__auto___27010);

return statearr_27009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27062,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27066 = k27062;
var G__27066__$1 = (((G__27066 instanceof cljs.core.Keyword))?G__27066.fqn:null);
switch (G__27066__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27062,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__27067){
var vec__27068 = p__27067;
var k__4403__auto__ = cljs.core.nth.call(null,vec__27068,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__27068,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27061){
var self__ = this;
var G__27061__$1 = this;
return (new cljs.core.RecordIter((0),G__27061__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27063,other27064){
var self__ = this;
var this27063__$1 = this;
return (((!((other27064 == null)))) && ((this27063__$1.constructor === other27064.constructor)) && (cljs.core._EQ_.call(null,this27063__$1.conn,other27064.conn)) && (cljs.core._EQ_.call(null,this27063__$1.network,other27064.network)) && (cljs.core._EQ_.call(null,this27063__$1.dbid,other27064.dbid)) && (cljs.core._EQ_.call(null,this27063__$1.block,other27064.block)) && (cljs.core._EQ_.call(null,this27063__$1.t,other27064.t)) && (cljs.core._EQ_.call(null,this27063__$1.tt_id,other27064.tt_id)) && (cljs.core._EQ_.call(null,this27063__$1.stats,other27064.stats)) && (cljs.core._EQ_.call(null,this27063__$1.spot,other27064.spot)) && (cljs.core._EQ_.call(null,this27063__$1.psot,other27064.psot)) && (cljs.core._EQ_.call(null,this27063__$1.post,other27064.post)) && (cljs.core._EQ_.call(null,this27063__$1.opst,other27064.opst)) && (cljs.core._EQ_.call(null,this27063__$1.schema,other27064.schema)) && (cljs.core._EQ_.call(null,this27063__$1.settings,other27064.settings)) && (cljs.core._EQ_.call(null,this27063__$1.index_configs,other27064.index_configs)) && (cljs.core._EQ_.call(null,this27063__$1.schema_cache,other27064.schema_cache)) && (cljs.core._EQ_.call(null,this27063__$1.novelty,other27064.novelty)) && (cljs.core._EQ_.call(null,this27063__$1.permissions,other27064.permissions)) && (cljs.core._EQ_.call(null,this27063__$1.fork,other27064.fork)) && (cljs.core._EQ_.call(null,this27063__$1.fork_block,other27064.fork_block)) && (cljs.core._EQ_.call(null,this27063__$1.current_db_fn,other27064.current_db_fn)) && (cljs.core._EQ_.call(null,this27063__$1.__extmap,other27064.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27061){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27071 = cljs.core.keyword_identical_QMARK_;
var expr__27072 = k__4388__auto__;
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27072))){
return (new fluree.db.graphdb.GraphDb(G__27061,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27061,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27061,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27061,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27061,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27061,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27061,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27061,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27061,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27061,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27061,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27061,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27061,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27061,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27061,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27061,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27061,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27061,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27061,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27071.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27072))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27061,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__27061),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27061){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27061,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27089){
var state_val_27090 = (state_27089[(1)]);
if((state_val_27090 === (1))){
var state_27089__$1 = state_27089;
var statearr_27091_27354 = state_27089__$1;
(statearr_27091_27354[(2)] = null);

(statearr_27091_27354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27090 === (2))){
var _ = (function (){var statearr_27092 = state_27089;
(statearr_27092[(4)] = cljs.core.cons.call(null,(5),(state_27089[(4)])));

return statearr_27092;
})();
var inst_27080 = self__.current_db_fn.call(null);
var state_27089__$1 = state_27089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27089__$1,(6),inst_27080);
} else {
if((state_val_27090 === (3))){
var inst_27087 = (state_27089[(2)]);
var state_27089__$1 = state_27089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27089__$1,inst_27087);
} else {
if((state_val_27090 === (4))){
var inst_27074 = (state_27089[(2)]);
var state_27089__$1 = state_27089;
var statearr_27094_27355 = state_27089__$1;
(statearr_27094_27355[(2)] = inst_27074);

(statearr_27094_27355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27090 === (5))){
var _ = (function (){var statearr_27095 = state_27089;
(statearr_27095[(4)] = cljs.core.rest.call(null,(state_27089[(4)])));

return statearr_27095;
})();
var state_27089__$1 = state_27089;
var ex27093 = (state_27089__$1[(2)]);
var statearr_27096_27356 = state_27089__$1;
(statearr_27096_27356[(5)] = ex27093);


if((ex27093 instanceof Error)){
var statearr_27097_27357 = state_27089__$1;
(statearr_27097_27357[(1)] = (4));

(statearr_27097_27357[(5)] = null);

} else {
throw ex27093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27090 === (6))){
var inst_27082 = (state_27089[(2)]);
var inst_27083 = fluree.db.util.async.throw_err.call(null,inst_27082);
var inst_27084 = cljs.core.assoc.call(null,inst_27083,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27098 = state_27089;
(statearr_27098[(4)] = cljs.core.rest.call(null,(state_27089[(4)])));

return statearr_27098;
})();
var state_27089__$1 = state_27089;
var statearr_27099_27358 = state_27089__$1;
(statearr_27099_27358[(2)] = inst_27084);

(statearr_27099_27358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2454__auto__ = null;
var fluree$db$graphdb$state_machine__2454__auto____0 = (function (){
var statearr_27100 = [null,null,null,null,null,null,null];
(statearr_27100[(0)] = fluree$db$graphdb$state_machine__2454__auto__);

(statearr_27100[(1)] = (1));

return statearr_27100;
});
var fluree$db$graphdb$state_machine__2454__auto____1 = (function (state_27089){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27101){var ex__2457__auto__ = e27101;
var statearr_27102_27359 = state_27089;
(statearr_27102_27359[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27089[(4)]))){
var statearr_27103_27360 = state_27089;
(statearr_27103_27360[(1)] = cljs.core.first.call(null,(state_27089[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27361 = state_27089;
state_27089 = G__27361;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2454__auto__ = function(state_27089){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2454__auto____1.call(this,state_27089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2454__auto____0;
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2454__auto____1;
return fluree$db$graphdb$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27104 = f__2477__auto__.call(null);
(statearr_27104[(6)] = c__2476__auto__);

return statearr_27104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__27105 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__27105);
} else {
return G__27105;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27137){
var state_val_27138 = (state_27137[(1)]);
if((state_val_27138 === (7))){
var state_27137__$1 = state_27137;
var statearr_27139_27362 = state_27137__$1;
(statearr_27139_27362[(2)] = null);

(statearr_27139_27362[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (1))){
var state_27137__$1 = state_27137;
var statearr_27140_27363 = state_27137__$1;
(statearr_27140_27363[(2)] = null);

(statearr_27140_27363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (4))){
var inst_27106 = (state_27137[(2)]);
var state_27137__$1 = state_27137;
var statearr_27141_27364 = state_27137__$1;
(statearr_27141_27364[(2)] = inst_27106);

(statearr_27141_27364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (6))){
var inst_27120 = (state_27137[(7)]);
var inst_27119 = (state_27137[(2)]);
var inst_27120__$1 = fluree.db.util.async.throw_err.call(null,inst_27119);
var inst_27121 = (inst_27120__$1 == null);
var state_27137__$1 = (function (){var statearr_27142 = state_27137;
(statearr_27142[(7)] = inst_27120__$1);

return statearr_27142;
})();
if(cljs.core.truth_(inst_27121)){
var statearr_27143_27365 = state_27137__$1;
(statearr_27143_27365[(1)] = (7));

} else {
var statearr_27144_27366 = state_27137__$1;
(statearr_27144_27366[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (3))){
var inst_27135 = (state_27137[(2)]);
var state_27137__$1 = state_27137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27137__$1,inst_27135);
} else {
if((state_val_27138 === (12))){
var inst_27132 = (state_27137[(2)]);
var _ = (function (){var statearr_27145 = state_27137;
(statearr_27145[(4)] = cljs.core.rest.call(null,(state_27137[(4)])));

return statearr_27145;
})();
var state_27137__$1 = state_27137;
var statearr_27146_27367 = state_27137__$1;
(statearr_27146_27367[(2)] = inst_27132);

(statearr_27146_27367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (2))){
var _ = (function (){var statearr_27147 = state_27137;
(statearr_27147[(4)] = cljs.core.cons.call(null,(5),(state_27137[(4)])));

return statearr_27147;
})();
var inst_27113 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27115 = [tag_id,(30)];
var inst_27116 = (new cljs.core.PersistentVector(null,2,(5),inst_27114,inst_27115,null));
var inst_27117 = fluree.db.query.range.index_range.call(null,inst_27113,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27116);
var state_27137__$1 = state_27137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27137__$1,(6),inst_27117);
} else {
if((state_val_27138 === (11))){
var inst_27126 = (state_27137[(8)]);
var inst_27130 = inst_27126.o;
var state_27137__$1 = state_27137;
var statearr_27149_27368 = state_27137__$1;
(statearr_27149_27368[(2)] = inst_27130);

(statearr_27149_27368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (9))){
var inst_27126 = (state_27137[(8)]);
var inst_27126__$1 = (state_27137[(2)]);
var inst_27127 = (inst_27126__$1 == null);
var state_27137__$1 = (function (){var statearr_27150 = state_27137;
(statearr_27150[(8)] = inst_27126__$1);

return statearr_27150;
})();
if(cljs.core.truth_(inst_27127)){
var statearr_27151_27369 = state_27137__$1;
(statearr_27151_27369[(1)] = (10));

} else {
var statearr_27152_27370 = state_27137__$1;
(statearr_27152_27370[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (5))){
var _ = (function (){var statearr_27153 = state_27137;
(statearr_27153[(4)] = cljs.core.rest.call(null,(state_27137[(4)])));

return statearr_27153;
})();
var state_27137__$1 = state_27137;
var ex27148 = (state_27137__$1[(2)]);
var statearr_27154_27371 = state_27137__$1;
(statearr_27154_27371[(5)] = ex27148);


if((ex27148 instanceof Error)){
var statearr_27155_27372 = state_27137__$1;
(statearr_27155_27372[(1)] = (4));

(statearr_27155_27372[(5)] = null);

} else {
throw ex27148;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (10))){
var state_27137__$1 = state_27137;
var statearr_27156_27373 = state_27137__$1;
(statearr_27156_27373[(2)] = null);

(statearr_27156_27373[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (8))){
var inst_27120 = (state_27137[(7)]);
var inst_27124 = cljs.core.first.call(null,inst_27120);
var state_27137__$1 = state_27137;
var statearr_27157_27374 = state_27137__$1;
(statearr_27157_27374[(2)] = inst_27124);

(statearr_27157_27374[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2454__auto__ = null;
var fluree$db$graphdb$state_machine__2454__auto____0 = (function (){
var statearr_27158 = [null,null,null,null,null,null,null,null,null];
(statearr_27158[(0)] = fluree$db$graphdb$state_machine__2454__auto__);

(statearr_27158[(1)] = (1));

return statearr_27158;
});
var fluree$db$graphdb$state_machine__2454__auto____1 = (function (state_27137){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27159){var ex__2457__auto__ = e27159;
var statearr_27160_27375 = state_27137;
(statearr_27160_27375[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27137[(4)]))){
var statearr_27161_27376 = state_27137;
(statearr_27161_27376[(1)] = cljs.core.first.call(null,(state_27137[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27377 = state_27137;
state_27137 = G__27377;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2454__auto__ = function(state_27137){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2454__auto____1.call(this,state_27137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2454__auto____0;
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2454__auto____1;
return fluree$db$graphdb$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27162 = f__2477__auto__.call(null);
(statearr_27162[(6)] = c__2476__auto__);

return statearr_27162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27198){
var state_val_27199 = (state_27198[(1)]);
if((state_val_27199 === (7))){
var inst_27172 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27198__$1 = state_27198;
var statearr_27200_27378 = state_27198__$1;
(statearr_27200_27378[(2)] = inst_27172);

(statearr_27200_27378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (1))){
var state_27198__$1 = state_27198;
var statearr_27201_27379 = state_27198__$1;
(statearr_27201_27379[(2)] = null);

(statearr_27201_27379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (4))){
var inst_27163 = (state_27198[(2)]);
var state_27198__$1 = state_27198;
var statearr_27202_27380 = state_27198__$1;
(statearr_27202_27380[(2)] = inst_27163);

(statearr_27202_27380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (15))){
var inst_27193 = (state_27198[(2)]);
var _ = (function (){var statearr_27203 = state_27198;
(statearr_27203[(4)] = cljs.core.rest.call(null,(state_27198[(4)])));

return statearr_27203;
})();
var state_27198__$1 = state_27198;
var statearr_27204_27381 = state_27198__$1;
(statearr_27204_27381[(2)] = inst_27193);

(statearr_27204_27381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (13))){
var inst_27178 = (state_27198[(7)]);
var inst_27184 = clojure.string.includes_QMARK_.call(null,inst_27178,":");
var state_27198__$1 = state_27198;
if(inst_27184){
var statearr_27205_27382 = state_27198__$1;
(statearr_27205_27382[(1)] = (16));

} else {
var statearr_27206_27383 = state_27198__$1;
(statearr_27206_27383[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (6))){
var state_27198__$1 = state_27198;
var statearr_27207_27384 = state_27198__$1;
(statearr_27207_27384[(2)] = pred);

(statearr_27207_27384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (17))){
var inst_27178 = (state_27198[(7)]);
var state_27198__$1 = state_27198;
var statearr_27208_27385 = state_27198__$1;
(statearr_27208_27385[(2)] = inst_27178);

(statearr_27208_27385[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (3))){
var inst_27196 = (state_27198[(2)]);
var state_27198__$1 = state_27198;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27198__$1,inst_27196);
} else {
if((state_val_27199 === (12))){
var inst_27182 = (state_27198[(2)]);
var state_27198__$1 = state_27198;
if(cljs.core.truth_(inst_27182)){
var statearr_27209_27386 = state_27198__$1;
(statearr_27209_27386[(1)] = (13));

} else {
var statearr_27210_27387 = state_27198__$1;
(statearr_27210_27387[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (2))){
var _ = (function (){var statearr_27211 = state_27198;
(statearr_27211[(4)] = cljs.core.cons.call(null,(5),(state_27198[(4)])));

return statearr_27211;
})();
var inst_27169 = typeof pred === 'string';
var state_27198__$1 = state_27198;
if(cljs.core.truth_(inst_27169)){
var statearr_27212_27388 = state_27198__$1;
(statearr_27212_27388[(1)] = (6));

} else {
var statearr_27213_27389 = state_27198__$1;
(statearr_27213_27389[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (11))){
var inst_27174 = (state_27198[(8)]);
var state_27198__$1 = state_27198;
var statearr_27215_27390 = state_27198__$1;
(statearr_27215_27390[(2)] = inst_27174);

(statearr_27215_27390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (9))){
var inst_27174 = (state_27198[(8)]);
var inst_27177 = (state_27198[(2)]);
var inst_27178 = fluree.db.util.async.throw_err.call(null,inst_27177);
var state_27198__$1 = (function (){var statearr_27216 = state_27198;
(statearr_27216[(7)] = inst_27178);

return statearr_27216;
})();
if(cljs.core.truth_(inst_27174)){
var statearr_27217_27391 = state_27198__$1;
(statearr_27217_27391[(1)] = (10));

} else {
var statearr_27218_27392 = state_27198__$1;
(statearr_27218_27392[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (5))){
var _ = (function (){var statearr_27219 = state_27198;
(statearr_27219[(4)] = cljs.core.rest.call(null,(state_27198[(4)])));

return statearr_27219;
})();
var state_27198__$1 = state_27198;
var ex27214 = (state_27198__$1[(2)]);
var statearr_27220_27393 = state_27198__$1;
(statearr_27220_27393[(5)] = ex27214);


if((ex27214 instanceof Error)){
var statearr_27221_27394 = state_27198__$1;
(statearr_27221_27394[(1)] = (4));

(statearr_27221_27394[(5)] = null);

} else {
throw ex27214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (14))){
var state_27198__$1 = state_27198;
var statearr_27222_27395 = state_27198__$1;
(statearr_27222_27395[(2)] = null);

(statearr_27222_27395[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (16))){
var inst_27178 = (state_27198[(7)]);
var inst_27186 = clojure.string.split.call(null,inst_27178,/:/);
var inst_27187 = cljs.core.second.call(null,inst_27186);
var state_27198__$1 = state_27198;
var statearr_27223_27396 = state_27198__$1;
(statearr_27223_27396[(2)] = inst_27187);

(statearr_27223_27396[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (10))){
var inst_27178 = (state_27198[(7)]);
var state_27198__$1 = state_27198;
var statearr_27224_27397 = state_27198__$1;
(statearr_27224_27397[(2)] = inst_27178);

(statearr_27224_27397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (18))){
var inst_27190 = (state_27198[(2)]);
var state_27198__$1 = state_27198;
var statearr_27225_27398 = state_27198__$1;
(statearr_27225_27398[(2)] = inst_27190);

(statearr_27225_27398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27199 === (8))){
var inst_27174 = (state_27198[(2)]);
var inst_27175 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_27198__$1 = (function (){var statearr_27226 = state_27198;
(statearr_27226[(8)] = inst_27174);

return statearr_27226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27198__$1,(9),inst_27175);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2454__auto__ = null;
var fluree$db$graphdb$state_machine__2454__auto____0 = (function (){
var statearr_27227 = [null,null,null,null,null,null,null,null,null];
(statearr_27227[(0)] = fluree$db$graphdb$state_machine__2454__auto__);

(statearr_27227[(1)] = (1));

return statearr_27227;
});
var fluree$db$graphdb$state_machine__2454__auto____1 = (function (state_27198){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27228){var ex__2457__auto__ = e27228;
var statearr_27229_27399 = state_27198;
(statearr_27229_27399[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27198[(4)]))){
var statearr_27230_27400 = state_27198;
(statearr_27230_27400[(1)] = cljs.core.first.call(null,(state_27198[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27401 = state_27198;
state_27198 = G__27401;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2454__auto__ = function(state_27198){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2454__auto____1.call(this,state_27198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2454__auto____0;
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2454__auto____1;
return fluree$db$graphdb$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27231 = f__2477__auto__.call(null);
(statearr_27231[(6)] = c__2476__auto__);

return statearr_27231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27263){
var state_val_27264 = (state_27263[(1)]);
if((state_val_27264 === (7))){
var state_27263__$1 = state_27263;
var statearr_27265_27402 = state_27263__$1;
(statearr_27265_27402[(2)] = null);

(statearr_27265_27402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (1))){
var state_27263__$1 = state_27263;
var statearr_27266_27403 = state_27263__$1;
(statearr_27266_27403[(2)] = null);

(statearr_27266_27403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (4))){
var inst_27232 = (state_27263[(2)]);
var state_27263__$1 = state_27263;
var statearr_27267_27404 = state_27263__$1;
(statearr_27267_27404[(2)] = inst_27232);

(statearr_27267_27404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (6))){
var inst_27246 = (state_27263[(7)]);
var inst_27245 = (state_27263[(2)]);
var inst_27246__$1 = fluree.db.util.async.throw_err.call(null,inst_27245);
var inst_27247 = (inst_27246__$1 == null);
var state_27263__$1 = (function (){var statearr_27268 = state_27263;
(statearr_27268[(7)] = inst_27246__$1);

return statearr_27268;
})();
if(cljs.core.truth_(inst_27247)){
var statearr_27269_27405 = state_27263__$1;
(statearr_27269_27405[(1)] = (7));

} else {
var statearr_27270_27406 = state_27263__$1;
(statearr_27270_27406[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (3))){
var inst_27261 = (state_27263[(2)]);
var state_27263__$1 = state_27263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27263__$1,inst_27261);
} else {
if((state_val_27264 === (12))){
var inst_27258 = (state_27263[(2)]);
var _ = (function (){var statearr_27271 = state_27263;
(statearr_27271[(4)] = cljs.core.rest.call(null,(state_27263[(4)])));

return statearr_27271;
})();
var state_27263__$1 = state_27263;
var statearr_27272_27407 = state_27263__$1;
(statearr_27272_27407[(2)] = inst_27258);

(statearr_27272_27407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (2))){
var _ = (function (){var statearr_27273 = state_27263;
(statearr_27273[(4)] = cljs.core.cons.call(null,(5),(state_27263[(4)])));

return statearr_27273;
})();
var inst_27239 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27241 = [(30),tag_name];
var inst_27242 = (new cljs.core.PersistentVector(null,2,(5),inst_27240,inst_27241,null));
var inst_27243 = fluree.db.query.range.index_range.call(null,inst_27239,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27242);
var state_27263__$1 = state_27263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27263__$1,(6),inst_27243);
} else {
if((state_val_27264 === (11))){
var inst_27252 = (state_27263[(8)]);
var inst_27256 = inst_27252.s;
var state_27263__$1 = state_27263;
var statearr_27275_27408 = state_27263__$1;
(statearr_27275_27408[(2)] = inst_27256);

(statearr_27275_27408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (9))){
var inst_27252 = (state_27263[(8)]);
var inst_27252__$1 = (state_27263[(2)]);
var inst_27253 = (inst_27252__$1 == null);
var state_27263__$1 = (function (){var statearr_27276 = state_27263;
(statearr_27276[(8)] = inst_27252__$1);

return statearr_27276;
})();
if(cljs.core.truth_(inst_27253)){
var statearr_27277_27409 = state_27263__$1;
(statearr_27277_27409[(1)] = (10));

} else {
var statearr_27278_27410 = state_27263__$1;
(statearr_27278_27410[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (5))){
var _ = (function (){var statearr_27279 = state_27263;
(statearr_27279[(4)] = cljs.core.rest.call(null,(state_27263[(4)])));

return statearr_27279;
})();
var state_27263__$1 = state_27263;
var ex27274 = (state_27263__$1[(2)]);
var statearr_27280_27411 = state_27263__$1;
(statearr_27280_27411[(5)] = ex27274);


if((ex27274 instanceof Error)){
var statearr_27281_27412 = state_27263__$1;
(statearr_27281_27412[(1)] = (4));

(statearr_27281_27412[(5)] = null);

} else {
throw ex27274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (10))){
var state_27263__$1 = state_27263;
var statearr_27282_27413 = state_27263__$1;
(statearr_27282_27413[(2)] = null);

(statearr_27282_27413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27264 === (8))){
var inst_27246 = (state_27263[(7)]);
var inst_27250 = cljs.core.first.call(null,inst_27246);
var state_27263__$1 = state_27263;
var statearr_27283_27414 = state_27263__$1;
(statearr_27283_27414[(2)] = inst_27250);

(statearr_27283_27414[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2454__auto__ = null;
var fluree$db$graphdb$state_machine__2454__auto____0 = (function (){
var statearr_27284 = [null,null,null,null,null,null,null,null,null];
(statearr_27284[(0)] = fluree$db$graphdb$state_machine__2454__auto__);

(statearr_27284[(1)] = (1));

return statearr_27284;
});
var fluree$db$graphdb$state_machine__2454__auto____1 = (function (state_27263){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27285){var ex__2457__auto__ = e27285;
var statearr_27286_27415 = state_27263;
(statearr_27286_27415[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27263[(4)]))){
var statearr_27287_27416 = state_27263;
(statearr_27287_27416[(1)] = cljs.core.first.call(null,(state_27263[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27417 = state_27263;
state_27263 = G__27417;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2454__auto__ = function(state_27263){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2454__auto____1.call(this,state_27263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2454__auto____0;
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2454__auto____1;
return fluree$db$graphdb$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27288 = f__2477__auto__.call(null);
(statearr_27288[(6)] = c__2476__auto__);

return statearr_27288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_27323){
var state_val_27324 = (state_27323[(1)]);
if((state_val_27324 === (7))){
var inst_27302 = typeof pred === 'string';
var state_27323__$1 = state_27323;
if(cljs.core.truth_(inst_27302)){
var statearr_27325_27418 = state_27323__$1;
(statearr_27325_27418[(1)] = (10));

} else {
var statearr_27326_27419 = state_27323__$1;
(statearr_27326_27419[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (1))){
var state_27323__$1 = state_27323;
var statearr_27327_27420 = state_27323__$1;
(statearr_27327_27420[(2)] = null);

(statearr_27327_27420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (4))){
var inst_27289 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
var statearr_27328_27421 = state_27323__$1;
(statearr_27328_27421[(2)] = inst_27289);

(statearr_27328_27421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (15))){
var inst_27316 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
var statearr_27329_27422 = state_27323__$1;
(statearr_27329_27422[(2)] = inst_27316);

(statearr_27329_27422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (13))){
var inst_27307 = (state_27323[(7)]);
var inst_27309 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27307),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27310 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_27309);
var state_27323__$1 = state_27323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27323__$1,(16),inst_27310);
} else {
if((state_val_27324 === (6))){
var inst_27297 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_27323__$1 = state_27323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27323__$1,(9),inst_27297);
} else {
if((state_val_27324 === (3))){
var inst_27321 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27323__$1,inst_27321);
} else {
if((state_val_27324 === (12))){
var inst_27307 = (state_27323[(7)]);
var inst_27307__$1 = (state_27323[(2)]);
var state_27323__$1 = (function (){var statearr_27330 = state_27323;
(statearr_27330[(7)] = inst_27307__$1);

return statearr_27330;
})();
if(cljs.core.truth_(inst_27307__$1)){
var statearr_27331_27423 = state_27323__$1;
(statearr_27331_27423[(1)] = (13));

} else {
var statearr_27332_27424 = state_27323__$1;
(statearr_27332_27424[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (2))){
var _ = (function (){var statearr_27333 = state_27323;
(statearr_27333[(4)] = cljs.core.cons.call(null,(5),(state_27323[(4)])));

return statearr_27333;
})();
var inst_27295 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27323__$1 = state_27323;
if(inst_27295){
var statearr_27334_27425 = state_27323__$1;
(statearr_27334_27425[(1)] = (6));

} else {
var statearr_27335_27426 = state_27323__$1;
(statearr_27335_27426[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (11))){
var inst_27305 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27323__$1 = state_27323;
var statearr_27337_27427 = state_27323__$1;
(statearr_27337_27427[(2)] = inst_27305);

(statearr_27337_27427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (9))){
var inst_27299 = (state_27323[(2)]);
var inst_27300 = fluree.db.util.async.throw_err.call(null,inst_27299);
var state_27323__$1 = state_27323;
var statearr_27338_27428 = state_27323__$1;
(statearr_27338_27428[(2)] = inst_27300);

(statearr_27338_27428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (5))){
var _ = (function (){var statearr_27339 = state_27323;
(statearr_27339[(4)] = cljs.core.rest.call(null,(state_27323[(4)])));

return statearr_27339;
})();
var state_27323__$1 = state_27323;
var ex27336 = (state_27323__$1[(2)]);
var statearr_27340_27429 = state_27323__$1;
(statearr_27340_27429[(5)] = ex27336);


if((ex27336 instanceof Error)){
var statearr_27341_27430 = state_27323__$1;
(statearr_27341_27430[(1)] = (4));

(statearr_27341_27430[(5)] = null);

} else {
throw ex27336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (14))){
var state_27323__$1 = state_27323;
var statearr_27342_27431 = state_27323__$1;
(statearr_27342_27431[(2)] = null);

(statearr_27342_27431[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (16))){
var inst_27312 = (state_27323[(2)]);
var inst_27313 = fluree.db.util.async.throw_err.call(null,inst_27312);
var state_27323__$1 = state_27323;
var statearr_27343_27432 = state_27323__$1;
(statearr_27343_27432[(2)] = inst_27313);

(statearr_27343_27432[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (10))){
var state_27323__$1 = state_27323;
var statearr_27344_27433 = state_27323__$1;
(statearr_27344_27433[(2)] = pred);

(statearr_27344_27433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (8))){
var inst_27318 = (state_27323[(2)]);
var _ = (function (){var statearr_27345 = state_27323;
(statearr_27345[(4)] = cljs.core.rest.call(null,(state_27323[(4)])));

return statearr_27345;
})();
var state_27323__$1 = state_27323;
var statearr_27346_27434 = state_27323__$1;
(statearr_27346_27434[(2)] = inst_27318);

(statearr_27346_27434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2454__auto__ = null;
var fluree$db$graphdb$state_machine__2454__auto____0 = (function (){
var statearr_27347 = [null,null,null,null,null,null,null,null];
(statearr_27347[(0)] = fluree$db$graphdb$state_machine__2454__auto__);

(statearr_27347[(1)] = (1));

return statearr_27347;
});
var fluree$db$graphdb$state_machine__2454__auto____1 = (function (state_27323){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_27323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e27348){var ex__2457__auto__ = e27348;
var statearr_27349_27435 = state_27323;
(statearr_27349_27435[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_27323[(4)]))){
var statearr_27350_27436 = state_27323;
(statearr_27350_27436[(1)] = cljs.core.first.call(null,(state_27323[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27437 = state_27323;
state_27323 = G__27437;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2454__auto__ = function(state_27323){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2454__auto____1.call(this,state_27323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2454__auto____0;
fluree$db$graphdb$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2454__auto____1;
return fluree$db$graphdb$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_27351 = f__2477__auto__.call(null);
(statearr_27351[(6)] = c__2476__auto__);

return statearr_27351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27065){
var extmap__4419__auto__ = (function (){var G__27352 = cljs.core.dissoc.call(null,G__27065,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27065)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27352);
} else {
return G__27352;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27065),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27065),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
