// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33019 = arguments.length;
var i__4737__auto___33020 = (0);
while(true){
if((i__4737__auto___33020 < len__4736__auto___33019)){
args__4742__auto__.push((arguments[i__4737__auto___33020]));

var G__33021 = (i__4737__auto___33020 + (1));
i__4737__auto___33020 = G__33021;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq33016){
var G__33017 = cljs.core.first.call(null,seq33016);
var seq33016__$1 = cljs.core.next.call(null,seq33016);
var G__33018 = cljs.core.first.call(null,seq33016__$1);
var seq33016__$2 = cljs.core.next.call(null,seq33016__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33017,G__33018,seq33016__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e33022){if((e33022 instanceof java.lang.Exception)){
var e = e33022;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
} else {
throw e33022;

}
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e33023){if((e33023 instanceof java.lang.Exception)){
var e = e33023;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
} else {
throw e33023;

}
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e33024){if((e33024 instanceof java.lang.Exception)){
var e = e33024;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
} else {
throw e33024;

}
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e33025){if((e33025 instanceof java.lang.Exception)){
var e = e33025;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
} else {
throw e33025;

}
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e33026){if((e33026 instanceof java.lang.Exception)){
var e = e33026;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
} else {
throw e33026;

}
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33029 = arguments.length;
var i__4737__auto___33030 = (0);
while(true){
if((i__4737__auto___33030 < len__4736__auto___33029)){
args__4742__auto__.push((arguments[i__4737__auto___33030]));

var G__33031 = (i__4737__auto___33030 + (1));
i__4737__auto___33030 = G__33031;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e33028){if((e33028 instanceof java.lang.Exception)){
var e = e33028;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
} else {
throw e33028;

}
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq33027){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33027));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33034 = arguments.length;
var i__4737__auto___33035 = (0);
while(true){
if((i__4737__auto___33035 < len__4736__auto___33034)){
args__4742__auto__.push((arguments[i__4737__auto___33035]));

var G__33036 = (i__4737__auto___33035 + (1));
i__4737__auto___33035 = G__33036;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e33033){if((e33033 instanceof java.lang.Exception)){
var e = e33033;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
} else {
throw e33033;

}
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq33032){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33032));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e33037){if((e33037 instanceof java.lang.Exception)){
var e = e33037;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
} else {
throw e33037;

}
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33040 = arguments.length;
var i__4737__auto___33041 = (0);
while(true){
if((i__4737__auto___33041 < len__4736__auto___33040)){
args__4742__auto__.push((arguments[i__4737__auto___33041]));

var G__33042 = (i__4737__auto___33041 + (1));
i__4737__auto___33041 = G__33042;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e33039){if((e33039 instanceof java.lang.Exception)){
var e = e33039;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
} else {
throw e33039;

}
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq33038){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33038));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e33043){if((e33043 instanceof java.lang.Exception)){
var e = e33043;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
} else {
throw e33043;

}
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e33044){if((e33044 instanceof java.lang.Exception)){
var e = e33044;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
} else {
throw e33044;

}
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33047 = arguments.length;
var i__4737__auto___33048 = (0);
while(true){
if((i__4737__auto___33048 < len__4736__auto___33047)){
args__4742__auto__.push((arguments[i__4737__auto___33048]));

var G__33049 = (i__4737__auto___33048 + (1));
i__4737__auto___33048 = G__33049;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e33046){if((e33046 instanceof java.lang.Exception)){
var e = e33046;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
} else {
throw e33046;

}
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq33045){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33045));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33052 = arguments.length;
var i__4737__auto___33053 = (0);
while(true){
if((i__4737__auto___33053 < len__4736__auto___33052)){
args__4742__auto__.push((arguments[i__4737__auto___33053]));

var G__33054 = (i__4737__auto___33053 + (1));
i__4737__auto___33053 = G__33054;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e33051){if((e33051 instanceof java.lang.Exception)){
var e = e33051;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
} else {
throw e33051;

}
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq33050){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33050));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33057 = arguments.length;
var i__4737__auto___33058 = (0);
while(true){
if((i__4737__auto___33058 < len__4736__auto___33057)){
args__4742__auto__.push((arguments[i__4737__auto___33058]));

var G__33059 = (i__4737__auto___33058 + (1));
i__4737__auto___33058 = G__33059;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e33056){if((e33056 instanceof java.lang.Exception)){
var e = e33056;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
} else {
throw e33056;

}
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq33055){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33055));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33062 = arguments.length;
var i__4737__auto___33063 = (0);
while(true){
if((i__4737__auto___33063 < len__4736__auto___33062)){
args__4742__auto__.push((arguments[i__4737__auto___33063]));

var G__33064 = (i__4737__auto___33063 + (1));
i__4737__auto___33063 = G__33064;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e33061){if((e33061 instanceof java.lang.Exception)){
var e = e33061;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
} else {
throw e33061;

}
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq33060){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33060));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33067 = arguments.length;
var i__4737__auto___33068 = (0);
while(true){
if((i__4737__auto___33068 < len__4736__auto___33067)){
args__4742__auto__.push((arguments[i__4737__auto___33068]));

var G__33069 = (i__4737__auto___33068 + (1));
i__4737__auto___33068 = G__33069;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e33066){if((e33066 instanceof java.lang.Exception)){
var e = e33066;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
} else {
throw e33066;

}
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq33065){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33065));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33072 = arguments.length;
var i__4737__auto___33073 = (0);
while(true){
if((i__4737__auto___33073 < len__4736__auto___33072)){
args__4742__auto__.push((arguments[i__4737__auto___33073]));

var G__33074 = (i__4737__auto___33073 + (1));
i__4737__auto___33073 = G__33074;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e33071){if((e33071 instanceof java.lang.Exception)){
var e = e33071;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
} else {
throw e33071;

}
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq33070){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33070));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__33076 = arguments.length;
switch (G__33076) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33104){
var state_val_33105 = (state_33104[(1)]);
if((state_val_33105 === (7))){
var inst_33089 = (state_33104[(7)]);
var inst_33092 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33089,"query",query_map);
var state_33104__$1 = state_33104;
var statearr_33106_33192 = state_33104__$1;
(statearr_33106_33192[(2)] = inst_33092);

(statearr_33106_33192[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (1))){
var state_33104__$1 = state_33104;
var statearr_33107_33193 = state_33104__$1;
(statearr_33107_33193[(2)] = null);

(statearr_33107_33193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (4))){
var inst_33077 = (state_33104[(2)]);
var state_33104__$1 = state_33104;
var statearr_33108_33194 = state_33104__$1;
(statearr_33108_33194[(2)] = inst_33077);

(statearr_33108_33194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (6))){
var inst_33089 = (state_33104[(7)]);
var inst_33089__$1 = (state_33104[(2)]);
var inst_33090 = fluree.db.util.core.exception_QMARK_.call(null,inst_33089__$1);
var state_33104__$1 = (function (){var statearr_33109 = state_33104;
(statearr_33109[(7)] = inst_33089__$1);

return statearr_33109;
})();
if(inst_33090){
var statearr_33110_33195 = state_33104__$1;
(statearr_33110_33195[(1)] = (7));

} else {
var statearr_33111_33196 = state_33104__$1;
(statearr_33111_33196[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (3))){
var inst_33102 = (state_33104[(2)]);
var state_33104__$1 = state_33104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33104__$1,inst_33102);
} else {
if((state_val_33105 === (2))){
var inst_33083 = (state_33104[(8)]);
var _ = (function (){var statearr_33113 = state_33104;
(statearr_33113[(4)] = cljs.core.cons.call(null,(5),(state_33104[(4)])));

return statearr_33113;
})();
var inst_33083__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_33084 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_33085 = cljs.core.assoc.call(null,inst_33084,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_33083__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_33086 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_33085);
var inst_33087 = fluree.db.query.fql.query.call(null,db,inst_33086);
var state_33104__$1 = (function (){var statearr_33114 = state_33104;
(statearr_33114[(8)] = inst_33083__$1);

return statearr_33114;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33104__$1,(6),inst_33087);
} else {
if((state_val_33105 === (9))){
var inst_33099 = (state_33104[(2)]);
var _ = (function (){var statearr_33115 = state_33104;
(statearr_33115[(4)] = cljs.core.rest.call(null,(state_33104[(4)])));

return statearr_33115;
})();
var state_33104__$1 = state_33104;
var statearr_33116_33197 = state_33104__$1;
(statearr_33116_33197[(2)] = inst_33099);

(statearr_33116_33197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (5))){
var _ = (function (){var statearr_33117 = state_33104;
(statearr_33117[(4)] = cljs.core.rest.call(null,(state_33104[(4)])));

return statearr_33117;
})();
var state_33104__$1 = state_33104;
var ex33112 = (state_33104__$1[(2)]);
var statearr_33118_33198 = state_33104__$1;
(statearr_33118_33198[(5)] = ex33112);


if((ex33112 instanceof Error)){
var statearr_33119_33199 = state_33104__$1;
(statearr_33119_33199[(1)] = (4));

(statearr_33119_33199[(5)] = null);

} else {
throw ex33112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33105 === (8))){
var inst_33089 = (state_33104[(7)]);
var inst_33083 = (state_33104[(8)]);
var inst_33094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33095 = cljs.core.deref.call(null,inst_33083);
var inst_33096 = [inst_33089,inst_33095];
var inst_33097 = (new cljs.core.PersistentVector(null,2,(5),inst_33094,inst_33096,null));
var state_33104__$1 = state_33104;
var statearr_33120_33200 = state_33104__$1;
(statearr_33120_33200[(2)] = inst_33097);

(statearr_33120_33200[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2454__auto____0 = (function (){
var statearr_33121 = [null,null,null,null,null,null,null,null,null];
(statearr_33121[(0)] = fluree$db$dbfunctions$internal$state_machine__2454__auto__);

(statearr_33121[(1)] = (1));

return statearr_33121;
});
var fluree$db$dbfunctions$internal$state_machine__2454__auto____1 = (function (state_33104){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33122){var ex__2457__auto__ = e33122;
var statearr_33123_33201 = state_33104;
(statearr_33123_33201[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33104[(4)]))){
var statearr_33124_33202 = state_33104;
(statearr_33124_33202[(1)] = cljs.core.first.call(null,(state_33104[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33203 = state_33104;
state_33104 = G__33203;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2454__auto__ = function(state_33104){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____1.call(this,state_33104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33125 = f__2477__auto__.call(null);
(statearr_33125[(6)] = c__2476__auto__);

return statearr_33125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33170){
var state_val_33171 = (state_33170[(1)]);
if((state_val_33171 === (7))){
var inst_33156 = (state_33170[(2)]);
var inst_33157 = fluree.db.query.fql.query.call(null,db,inst_33156);
var state_33170__$1 = state_33170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33170__$1,(8),inst_33157);
} else {
if((state_val_33171 === (1))){
var inst_33126 = typeof select === 'string';
var state_33170__$1 = state_33170;
if(cljs.core.truth_(inst_33126)){
var statearr_33172_33204 = state_33170__$1;
(statearr_33172_33204[(1)] = (2));

} else {
var statearr_33173_33205 = state_33170__$1;
(statearr_33173_33205[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (4))){
var inst_33139 = (state_33170[(7)]);
var inst_33132 = (state_33170[(8)]);
var inst_33131 = (state_33170[(2)]);
var inst_33132__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_33133 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_33134 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_33135 = [inst_33132__$1,(100000)];
var inst_33136 = cljs.core.PersistentHashMap.fromArrays(inst_33134,inst_33135);
var inst_33137 = [inst_33131,from,where,block,limit,inst_33136];
var inst_33138 = cljs.core.PersistentHashMap.fromArrays(inst_33133,inst_33137);
var inst_33139__$1 = fluree.db.util.core.without_nils.call(null,inst_33138);
var inst_33140 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_33139__$1);
var inst_33141 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_33139__$1);
var inst_33142 = cljs.core.first.call(null,inst_33141);
var inst_33143 = fluree.db.dbfunctions.internal.str.call(null,inst_33142);
var inst_33144 = cljs.core._EQ_.call(null,"[",inst_33143);
var inst_33145 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_33139__$1);
var inst_33146 = cljs.core.last.call(null,inst_33145);
var inst_33147 = fluree.db.dbfunctions.internal.str.call(null,inst_33146);
var inst_33148 = cljs.core._EQ_.call(null,"]",inst_33147);
var inst_33149 = fluree.db.dbfunctions.internal.and.call(null,inst_33140,inst_33144,inst_33148);
var state_33170__$1 = (function (){var statearr_33174 = state_33170;
(statearr_33174[(7)] = inst_33139__$1);

(statearr_33174[(8)] = inst_33132__$1);

return statearr_33174;
})();
if(cljs.core.truth_(inst_33149)){
var statearr_33175_33206 = state_33170__$1;
(statearr_33175_33206[(1)] = (5));

} else {
var statearr_33176_33207 = state_33170__$1;
(statearr_33176_33207[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (6))){
var inst_33139 = (state_33170[(7)]);
var state_33170__$1 = state_33170;
var statearr_33177_33208 = state_33170__$1;
(statearr_33177_33208[(2)] = inst_33139);

(statearr_33177_33208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (3))){
var state_33170__$1 = state_33170;
var statearr_33178_33209 = state_33170__$1;
(statearr_33178_33209[(2)] = select);

(statearr_33178_33209[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (2))){
var inst_33128 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_33170__$1 = state_33170;
var statearr_33179_33210 = state_33170__$1;
(statearr_33179_33210[(2)] = inst_33128);

(statearr_33179_33210[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (11))){
var inst_33168 = (state_33170[(2)]);
var state_33170__$1 = state_33170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33170__$1,inst_33168);
} else {
if((state_val_33171 === (9))){
var inst_33159 = (state_33170[(9)]);
var state_33170__$1 = state_33170;
var statearr_33180_33211 = state_33170__$1;
(statearr_33180_33211[(2)] = inst_33159);

(statearr_33180_33211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (5))){
var inst_33139 = (state_33170[(7)]);
var inst_33151 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_33139);
var inst_33152 = cljs.reader.read_string.call(null,inst_33151);
var inst_33153 = cljs.core.assoc.call(null,inst_33139,new cljs.core.Keyword(null,"where","where",-2044795965),inst_33152);
var state_33170__$1 = state_33170;
var statearr_33181_33212 = state_33170__$1;
(statearr_33181_33212[(2)] = inst_33153);

(statearr_33181_33212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (10))){
var inst_33132 = (state_33170[(8)]);
var inst_33159 = (state_33170[(9)]);
var inst_33163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33164 = cljs.core.deref.call(null,inst_33132);
var inst_33165 = [inst_33159,inst_33164];
var inst_33166 = (new cljs.core.PersistentVector(null,2,(5),inst_33163,inst_33165,null));
var state_33170__$1 = state_33170;
var statearr_33182_33213 = state_33170__$1;
(statearr_33182_33213[(2)] = inst_33166);

(statearr_33182_33213[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33171 === (8))){
var inst_33159 = (state_33170[(9)]);
var inst_33159__$1 = (state_33170[(2)]);
var inst_33160 = fluree.db.util.core.exception_QMARK_.call(null,inst_33159__$1);
var state_33170__$1 = (function (){var statearr_33183 = state_33170;
(statearr_33183[(9)] = inst_33159__$1);

return statearr_33183;
})();
if(inst_33160){
var statearr_33184_33214 = state_33170__$1;
(statearr_33184_33214[(1)] = (9));

} else {
var statearr_33185_33215 = state_33170__$1;
(statearr_33185_33215[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2454__auto____0 = (function (){
var statearr_33186 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33186[(0)] = fluree$db$dbfunctions$internal$state_machine__2454__auto__);

(statearr_33186[(1)] = (1));

return statearr_33186;
});
var fluree$db$dbfunctions$internal$state_machine__2454__auto____1 = (function (state_33170){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33187){var ex__2457__auto__ = e33187;
var statearr_33188_33216 = state_33170;
(statearr_33188_33216[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33170[(4)]))){
var statearr_33189_33217 = state_33170;
(statearr_33189_33217[(1)] = cljs.core.first.call(null,(state_33170[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33218 = state_33170;
state_33170 = G__33218;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2454__auto__ = function(state_33170){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____1.call(this,state_33170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33190 = f__2477__auto__.call(null);
(statearr_33190[(6)] = c__2476__auto__);

return statearr_33190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__33219 = clojure.string.split.call(null,var$,/\//);
var coll = cljs.core.nth.call(null,vec__33219,(0),null);
var pred = cljs.core.nth.call(null,vec__33219,(1),null);
var pred__$1 = cljs.core.subs.call(null,pred,(1));
return fluree.db.dbfunctions.internal.str.call(null,coll,"/",pred__$1);
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__33225 = path;
var vec__33226 = G__33225;
var seq__33227 = cljs.core.seq.call(null,vec__33226);
var first__33228 = cljs.core.first.call(null,seq__33227);
var seq__33227__$1 = cljs.core.next.call(null,seq__33227);
var var$ = first__33228;
var r = seq__33227__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__33225__$1 = G__33225;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__33232 = G__33225__$1;
var seq__33233 = cljs.core.seq.call(null,vec__33232);
var first__33234 = cljs.core.first.call(null,seq__33233);
var seq__33233__$1 = cljs.core.next.call(null,seq__33233);
var var$__$1 = first__33234;
var r__$1 = seq__33233__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__33235 = r__$1;
var G__33236 = n__$2;
var G__33237 = next_clauses;
G__33225__$1 = G__33235;
n__$1 = G__33236;
where_clauses__$1 = G__33237;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__33238 = r__$1;
var G__33239 = next_n;
var G__33240 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__33225__$1 = G__33238;
n__$1 = G__33239;
where_clauses__$1 = G__33240;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33277){
var state_val_33278 = (state_33277[(1)]);
if((state_val_33278 === (7))){
var inst_33250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33251 = [path];
var inst_33252 = (new cljs.core.PersistentVector(null,1,(5),inst_33250,inst_33251,null));
var state_33277__$1 = state_33277;
var statearr_33279_33307 = state_33277__$1;
(statearr_33279_33307[(2)] = inst_33252);

(statearr_33279_33307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (1))){
var state_33277__$1 = state_33277;
var statearr_33280_33308 = state_33277__$1;
(statearr_33280_33308[(2)] = null);

(statearr_33280_33308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (4))){
var inst_33241 = (state_33277[(2)]);
var state_33277__$1 = state_33277;
var statearr_33281_33309 = state_33277__$1;
(statearr_33281_33309[(2)] = inst_33241);

(statearr_33281_33309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (13))){
var inst_33268 = (state_33277[(2)]);
var inst_33269 = fluree.db.util.async.throw_err.call(null,inst_33268);
var _ = (function (){var statearr_33282 = state_33277;
(statearr_33282[(4)] = cljs.core.rest.call(null,(state_33277[(4)])));

return statearr_33282;
})();
var state_33277__$1 = state_33277;
var statearr_33283_33310 = state_33277__$1;
(statearr_33283_33310[(2)] = inst_33269);

(statearr_33283_33310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (6))){
var state_33277__$1 = state_33277;
var statearr_33285_33311 = state_33277__$1;
(statearr_33285_33311[(2)] = path);

(statearr_33285_33311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (3))){
var inst_33275 = (state_33277[(2)]);
var state_33277__$1 = state_33277;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33277__$1,inst_33275);
} else {
if((state_val_33278 === (12))){
var _ = (function (){var statearr_33286 = state_33277;
(statearr_33286[(4)] = cljs.core.rest.call(null,(state_33277[(4)])));

return statearr_33286;
})();
var state_33277__$1 = state_33277;
var ex33284 = (state_33277__$1[(2)]);
var statearr_33287_33312 = state_33277__$1;
(statearr_33287_33312[(5)] = ex33284);


if((ex33284 instanceof java.lang.Exception)){
var statearr_33288_33313 = state_33277__$1;
(statearr_33288_33313[(1)] = (11));

(statearr_33288_33313[(5)] = null);

} else {
throw ex33284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (2))){
var _ = (function (){var statearr_33289 = state_33277;
(statearr_33289[(4)] = cljs.core.cons.call(null,(5),(state_33277[(4)])));

return statearr_33289;
})();
var inst_33247 = cljs.core.vector_QMARK_.call(null,path);
var state_33277__$1 = state_33277;
if(inst_33247){
var statearr_33290_33314 = state_33277__$1;
(statearr_33290_33314[(1)] = (6));

} else {
var statearr_33291_33315 = state_33277__$1;
(statearr_33291_33315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (11))){
var inst_33254 = (state_33277[(7)]);
var inst_33259 = (state_33277[(2)]);
var inst_33260 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33259,"relationship?",startSubject,inst_33254,endSubject);
var state_33277__$1 = state_33277;
var statearr_33293_33316 = state_33277__$1;
(statearr_33293_33316[(2)] = inst_33260);

(statearr_33293_33316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (9))){
var inst_33258 = (state_33277[(8)]);
var _ = (function (){var statearr_33294 = state_33277;
(statearr_33294[(4)] = cljs.core.cons.call(null,(12),(state_33277[(4)])));

return statearr_33294;
})();
var inst_33266 = fluree.db.dbfunctions.internal.query.call(null,db,inst_33258);
var state_33277__$1 = state_33277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33277__$1,(13),inst_33266);
} else {
if((state_val_33278 === (5))){
var _ = (function (){var statearr_33295 = state_33277;
(statearr_33295[(4)] = cljs.core.rest.call(null,(state_33277[(4)])));

return statearr_33295;
})();
var state_33277__$1 = state_33277;
var ex33292 = (state_33277__$1[(2)]);
var statearr_33296_33317 = state_33277__$1;
(statearr_33296_33317[(5)] = ex33292);


if((ex33292 instanceof Error)){
var statearr_33297_33318 = state_33277__$1;
(statearr_33297_33318[(1)] = (4));

(statearr_33297_33318[(5)] = null);

} else {
throw ex33292;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (10))){
var inst_33272 = (state_33277[(2)]);
var _ = (function (){var statearr_33298 = state_33277;
(statearr_33298[(4)] = cljs.core.rest.call(null,(state_33277[(4)])));

return statearr_33298;
})();
var state_33277__$1 = state_33277;
var statearr_33299_33319 = state_33277__$1;
(statearr_33299_33319[(2)] = inst_33272);

(statearr_33299_33319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33278 === (8))){
var inst_33254 = (state_33277[(7)]);
var inst_33254__$1 = (state_33277[(2)]);
var inst_33255 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_33254__$1,endSubject);
var inst_33256 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_33257 = ["?var1",inst_33255];
var inst_33258 = cljs.core.PersistentHashMap.fromArrays(inst_33256,inst_33257);
var state_33277__$1 = (function (){var statearr_33300 = state_33277;
(statearr_33300[(8)] = inst_33258);

(statearr_33300[(7)] = inst_33254__$1);

return statearr_33300;
})();
var statearr_33301_33320 = state_33277__$1;
(statearr_33301_33320[(2)] = null);

(statearr_33301_33320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_33302 = [null,null,null,null,null,null,null,null,null];
(statearr_33302[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__);

(statearr_33302[(1)] = (1));

return statearr_33302;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____1 = (function (state_33277){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33303){var ex__2457__auto__ = e33303;
var statearr_33304_33321 = state_33277;
(statearr_33304_33321[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33277[(4)]))){
var statearr_33305_33322 = state_33277;
(statearr_33305_33322[(1)] = cljs.core.first.call(null,(state_33277[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33323 = state_33277;
state_33277 = G__33323;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__ = function(state_33277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____1.call(this,state_33277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33306 = f__2477__auto__.call(null);
(statearr_33306[(6)] = c__2476__auto__);

return statearr_33306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e33324){if((e33324 instanceof java.lang.Exception)){
var e = e33324;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
} else {
throw e33324;

}
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e33325){if((e33325 instanceof java.lang.Exception)){
var e = e33325;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
} else {
throw e33325;

}
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e33326){if((e33326 instanceof java.lang.Exception)){
var e = e33326;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
} else {
throw e33326;

}
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e33327){if((e33327 instanceof java.lang.Exception)){
var e = e33327;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
} else {
throw e33327;

}
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33330 = arguments.length;
var i__4737__auto___33331 = (0);
while(true){
if((i__4737__auto___33331 < len__4736__auto___33330)){
args__4742__auto__.push((arguments[i__4737__auto___33331]));

var G__33332 = (i__4737__auto___33331 + (1));
i__4737__auto___33331 = G__33332;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e33329){if((e33329 instanceof java.lang.Exception)){
var e = e33329;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
} else {
throw e33329;

}
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq33328){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33328));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33335 = arguments.length;
var i__4737__auto___33336 = (0);
while(true){
if((i__4737__auto___33336 < len__4736__auto___33335)){
args__4742__auto__.push((arguments[i__4737__auto___33336]));

var G__33337 = (i__4737__auto___33336 + (1));
i__4737__auto___33336 = G__33337;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e33334){if((e33334 instanceof java.lang.Exception)){
var e = e33334;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
} else {
throw e33334;

}
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq33333){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33333));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33340 = arguments.length;
var i__4737__auto___33341 = (0);
while(true){
if((i__4737__auto___33341 < len__4736__auto___33340)){
args__4742__auto__.push((arguments[i__4737__auto___33341]));

var G__33342 = (i__4737__auto___33341 + (1));
i__4737__auto___33341 = G__33342;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e33339){if((e33339 instanceof java.lang.Exception)){
var e = e33339;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
} else {
throw e33339;

}
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq33338){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33338));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33345 = arguments.length;
var i__4737__auto___33346 = (0);
while(true){
if((i__4737__auto___33346 < len__4736__auto___33345)){
args__4742__auto__.push((arguments[i__4737__auto___33346]));

var G__33347 = (i__4737__auto___33346 + (1));
i__4737__auto___33346 = G__33347;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e33344){if((e33344 instanceof java.lang.Exception)){
var e = e33344;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
} else {
throw e33344;

}
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq33343){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33343));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e33348){if((e33348 instanceof java.lang.Exception)){
var e = e33348;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
} else {
throw e33348;

}
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e33349){if((e33349 instanceof java.lang.Exception)){
var e = e33349;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
} else {
throw e33349;

}
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e33350){if((e33350 instanceof java.lang.Exception)){
var e = e33350;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
} else {
throw e33350;

}
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e33351){if((e33351 instanceof java.lang.Exception)){
var e = e33351;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
} else {
throw e33351;

}
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e33352){if((e33352 instanceof java.lang.Exception)){
var e = e33352;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
} else {
throw e33352;

}
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__33358 = path;
var vec__33359 = G__33358;
var seq__33360 = cljs.core.seq.call(null,vec__33359);
var first__33361 = cljs.core.first.call(null,seq__33360);
var seq__33360__$1 = cljs.core.next.call(null,seq__33360);
var pred = first__33361;
var r = seq__33360__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__33358__$1 = G__33358;
var subjects__$1 = subjects;
while(true){
var vec__33365 = G__33358__$1;
var seq__33366 = cljs.core.seq.call(null,vec__33365);
var first__33367 = cljs.core.first.call(null,seq__33366);
var seq__33366__$1 = cljs.core.next.call(null,seq__33366);
var pred__$1 = first__33367;
var r__$1 = seq__33366__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__33358__$1,subjects__$1,vec__33365,seq__33366,first__33367,seq__33366__$1,pred__$1,r__$1,subjects__$2,G__33358,vec__33359,seq__33360,first__33361,seq__33360__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__33358__$1,subjects__$1,vec__33365,seq__33366,first__33367,seq__33366__$1,pred__$1,r__$1,subjects__$2,G__33358,vec__33359,seq__33360,first__33361,seq__33360__$1,pred,r,subjects){
return (function (p1__33353_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__33353_SHARP_,pred__$1);
});})(G__33358__$1,subjects__$1,vec__33365,seq__33366,first__33367,seq__33366__$1,pred__$1,r__$1,subjects__$2,G__33358,vec__33359,seq__33360,first__33361,seq__33360__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__33358__$1,subjects__$1,vec__33365,seq__33366,first__33367,seq__33366__$1,pred__$1,r__$1,subjects__$2,G__33358,vec__33359,seq__33360,first__33361,seq__33360__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__33368 = r__$1;
var G__33369 = next_subjects;
G__33358__$1 = G__33368;
subjects__$1 = G__33369;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e33354){if((e33354 instanceof java.lang.Exception)){
var e = e33354;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
} else {
throw e33354;

}
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e33370){if((e33370 instanceof java.lang.Exception)){
var e = e33370;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
} else {
throw e33370;

}
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e33371){if((e33371 instanceof java.lang.Exception)){
var e = e33371;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
} else {
throw e33371;

}
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33374 = arguments.length;
var i__4737__auto___33375 = (0);
while(true){
if((i__4737__auto___33375 < len__4736__auto___33374)){
args__4742__auto__.push((arguments[i__4737__auto___33375]));

var G__33376 = (i__4737__auto___33375 + (1));
i__4737__auto___33375 = G__33376;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e33373){if((e33373 instanceof java.lang.Exception)){
var e = e33373;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
} else {
throw e33373;

}
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq33372){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33372));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e33377){if((e33377 instanceof java.lang.Exception)){
var e = e33377;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
} else {
throw e33377;

}
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33380 = arguments.length;
var i__4737__auto___33381 = (0);
while(true){
if((i__4737__auto___33381 < len__4736__auto___33380)){
args__4742__auto__.push((arguments[i__4737__auto___33381]));

var G__33382 = (i__4737__auto___33381 + (1));
i__4737__auto___33381 = G__33382;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e33379){if((e33379 instanceof java.lang.Exception)){
var e = e33379;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
} else {
throw e33379;

}
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq33378){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33378));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e33383){if((e33383 instanceof java.lang.Exception)){
var e = e33383;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
} else {
throw e33383;

}
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33438){
var state_val_33439 = (state_33438[(1)]);
if((state_val_33439 === (7))){
var inst_33385 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33440_33473 = state_33438__$1;
(statearr_33440_33473[(2)] = inst_33385);

(statearr_33440_33473[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (1))){
var state_33438__$1 = state_33438;
var statearr_33441_33474 = state_33438__$1;
(statearr_33441_33474[(2)] = null);

(statearr_33441_33474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (4))){
var inst_33384 = (state_33438[(2)]);
var state_33438__$1 = (function (){var statearr_33442 = state_33438;
(statearr_33442[(7)] = inst_33384);

return statearr_33442;
})();
var statearr_33443_33475 = state_33438__$1;
(statearr_33443_33475[(2)] = null);

(statearr_33443_33475[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (15))){
var inst_33422 = (state_33438[(8)]);
var inst_33426 = inst_33422.o;
var state_33438__$1 = state_33438;
var statearr_33444_33476 = state_33438__$1;
(statearr_33444_33476[(2)] = inst_33426);

(statearr_33444_33476[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (13))){
var inst_33422 = (state_33438[(8)]);
var inst_33418 = (state_33438[(2)]);
var inst_33419 = fluree.db.util.async.throw_err.call(null,inst_33418);
var inst_33420 = fluree.db.dbfunctions.internal.count.call(null,inst_33419);
var inst_33422__$1 = cljs.core.first.call(null,inst_33419);
var inst_33423 = (inst_33422__$1 == null);
var state_33438__$1 = (function (){var statearr_33445 = state_33438;
(statearr_33445[(9)] = inst_33420);

(statearr_33445[(8)] = inst_33422__$1);

return statearr_33445;
})();
if(cljs.core.truth_(inst_33423)){
var statearr_33446_33477 = state_33438__$1;
(statearr_33446_33477[(1)] = (14));

} else {
var statearr_33447_33478 = state_33438__$1;
(statearr_33447_33478[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (6))){
var inst_33394 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33448_33479 = state_33438__$1;
(statearr_33448_33479[(2)] = inst_33394);

(statearr_33448_33479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (3))){
var inst_33436 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33438__$1,inst_33436);
} else {
if((state_val_33439 === (12))){
var inst_33433 = (state_33438[(2)]);
var _ = (function (){var statearr_33449 = state_33438;
(statearr_33449[(4)] = cljs.core.rest.call(null,(state_33438[(4)])));

return statearr_33449;
})();
var state_33438__$1 = state_33438;
var statearr_33450_33480 = state_33438__$1;
(statearr_33450_33480[(2)] = inst_33433);

(statearr_33450_33480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (2))){
var _ = (function (){var statearr_33452 = state_33438;
(statearr_33452[(4)] = cljs.core.cons.call(null,(9),(state_33438[(4)])));

return statearr_33452;
})();
var inst_33400 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33401 = typeof inst_33400 === 'string';
var state_33438__$1 = state_33438;
if(cljs.core.truth_(inst_33401)){
var statearr_33453_33481 = state_33438__$1;
(statearr_33453_33481[(1)] = (10));

} else {
var statearr_33454_33482 = state_33438__$1;
(statearr_33454_33482[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (11))){
var inst_33407 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33408 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_33407);
var inst_33409 = fluree.db.dbfunctions.internal.inc.call(null,inst_33408);
var inst_33410 = cljs.core.assoc.call(null,inst_33407,new cljs.core.Keyword(null,"t","t",-1397832519),inst_33409);
var inst_33411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33412 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33413 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33414 = [inst_33412,inst_33413];
var inst_33415 = (new cljs.core.PersistentVector(null,2,(5),inst_33411,inst_33414,null));
var inst_33416 = fluree.db.dbproto._search.call(null,inst_33410,inst_33415);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33438__$1,(13),inst_33416);
} else {
if((state_val_33439 === (9))){
var _ = (function (){var statearr_33455 = state_33438;
(statearr_33455[(4)] = cljs.core.rest.call(null,(state_33438[(4)])));

return statearr_33455;
})();
var state_33438__$1 = state_33438;
var ex33451 = (state_33438__$1[(2)]);
var statearr_33456_33483 = state_33438__$1;
(statearr_33456_33483[(5)] = ex33451);


if((ex33451 instanceof java.lang.Exception)){
var statearr_33457_33484 = state_33438__$1;
(statearr_33457_33484[(1)] = (4));

(statearr_33457_33484[(5)] = null);

} else {
throw ex33451;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (5))){
var inst_33384 = (state_33438[(7)]);
var _ = (function (){var statearr_33458 = state_33438;
(statearr_33458[(4)] = cljs.core.cons.call(null,(8),(state_33438[(4)])));

return statearr_33458;
})();
var inst_33391 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33384,"?pO","Context Object");
var ___$1 = (function (){var statearr_33459 = state_33438;
(statearr_33459[(4)] = cljs.core.rest.call(null,(state_33438[(4)])));

return statearr_33459;
})();
var state_33438__$1 = state_33438;
var statearr_33460_33485 = state_33438__$1;
(statearr_33460_33485[(2)] = inst_33391);

(statearr_33460_33485[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (14))){
var state_33438__$1 = state_33438;
var statearr_33461_33486 = state_33438__$1;
(statearr_33461_33486[(2)] = null);

(statearr_33461_33486[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (16))){
var inst_33420 = (state_33438[(9)]);
var inst_33428 = (state_33438[(2)]);
var inst_33429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33430 = [inst_33428,inst_33420];
var inst_33431 = (new cljs.core.PersistentVector(null,2,(5),inst_33429,inst_33430,null));
var state_33438__$1 = state_33438;
var statearr_33463_33487 = state_33438__$1;
(statearr_33463_33487[(2)] = inst_33431);

(statearr_33463_33487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (10))){
var inst_33403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33404 = [null,(0)];
var inst_33405 = (new cljs.core.PersistentVector(null,2,(5),inst_33403,inst_33404,null));
var state_33438__$1 = state_33438;
var statearr_33464_33488 = state_33438__$1;
(statearr_33464_33488[(2)] = inst_33405);

(statearr_33464_33488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33439 === (8))){
var _ = (function (){var statearr_33465 = state_33438;
(statearr_33465[(4)] = cljs.core.rest.call(null,(state_33438[(4)])));

return statearr_33465;
})();
var state_33438__$1 = state_33438;
var ex33462 = (state_33438__$1[(2)]);
var statearr_33466_33489 = state_33438__$1;
(statearr_33466_33489[(5)] = ex33462);


if((ex33462 instanceof java.lang.Exception)){
var statearr_33467_33490 = state_33438__$1;
(statearr_33467_33490[(1)] = (7));

(statearr_33467_33490[(5)] = null);

} else {
throw ex33462;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____0 = (function (){
var statearr_33468 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33468[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__);

(statearr_33468[(1)] = (1));

return statearr_33468;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____1 = (function (state_33438){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33469){var ex__2457__auto__ = e33469;
var statearr_33470_33491 = state_33438;
(statearr_33470_33491[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33438[(4)]))){
var statearr_33471_33492 = state_33438;
(statearr_33471_33492[(1)] = cljs.core.first.call(null,(state_33438[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33493 = state_33438;
state_33438 = G__33493;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__ = function(state_33438){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____1.call(this,state_33438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33472 = f__2477__auto__.call(null);
(statearr_33472[(6)] = c__2476__auto__);

return statearr_33472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33545){
var state_val_33546 = (state_33545[(1)]);
if((state_val_33546 === (7))){
var inst_33495 = (state_33545[(2)]);
var state_33545__$1 = state_33545;
var statearr_33547_33576 = state_33545__$1;
(statearr_33547_33576[(2)] = inst_33495);

(statearr_33547_33576[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (1))){
var state_33545__$1 = state_33545;
var statearr_33548_33577 = state_33545__$1;
(statearr_33548_33577[(2)] = null);

(statearr_33548_33577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (4))){
var inst_33494 = (state_33545[(2)]);
var state_33545__$1 = (function (){var statearr_33549 = state_33545;
(statearr_33549[(7)] = inst_33494);

return statearr_33549;
})();
var statearr_33550_33578 = state_33545__$1;
(statearr_33550_33578[(2)] = null);

(statearr_33550_33578[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (13))){
var inst_33540 = (state_33545[(2)]);
var _ = (function (){var statearr_33551 = state_33545;
(statearr_33551[(4)] = cljs.core.rest.call(null,(state_33545[(4)])));

return statearr_33551;
})();
var state_33545__$1 = state_33545;
var statearr_33552_33579 = state_33545__$1;
(statearr_33552_33579[(2)] = inst_33540);

(statearr_33552_33579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (6))){
var inst_33504 = (state_33545[(2)]);
var state_33545__$1 = state_33545;
var statearr_33553_33580 = state_33545__$1;
(statearr_33553_33580[(2)] = inst_33504);

(statearr_33553_33580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (3))){
var inst_33543 = (state_33545[(2)]);
var state_33545__$1 = state_33545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33545__$1,inst_33543);
} else {
if((state_val_33546 === (12))){
var inst_33527 = (state_33545[(8)]);
var inst_33536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33537 = [null,inst_33527];
var inst_33538 = (new cljs.core.PersistentVector(null,2,(5),inst_33536,inst_33537,null));
var state_33545__$1 = state_33545;
var statearr_33554_33581 = state_33545__$1;
(statearr_33554_33581[(2)] = inst_33538);

(statearr_33554_33581[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (2))){
var _ = (function (){var statearr_33556 = state_33545;
(statearr_33556[(4)] = cljs.core.cons.call(null,(9),(state_33545[(4)])));

return statearr_33556;
})();
var inst_33513 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_33514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33516 = [null,pred_name,"?o"];
var inst_33517 = (new cljs.core.PersistentVector(null,3,(5),inst_33515,inst_33516,null));
var inst_33518 = [inst_33517];
var inst_33519 = (new cljs.core.PersistentVector(null,1,(5),inst_33514,inst_33518,null));
var inst_33520 = ["?o",inst_33519,opts];
var inst_33521 = cljs.core.PersistentHashMap.fromArrays(inst_33513,inst_33520);
var inst_33522 = fluree.db.dbfunctions.internal.query.call(null,db,inst_33521);
var state_33545__$1 = state_33545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33545__$1,(10),inst_33522);
} else {
if((state_val_33546 === (11))){
var inst_33526 = (state_33545[(9)]);
var inst_33527 = (state_33545[(8)]);
var inst_33531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33532 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_33526);
var inst_33533 = [inst_33532,inst_33527];
var inst_33534 = (new cljs.core.PersistentVector(null,2,(5),inst_33531,inst_33533,null));
var state_33545__$1 = state_33545;
var statearr_33557_33582 = state_33545__$1;
(statearr_33557_33582[(2)] = inst_33534);

(statearr_33557_33582[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (9))){
var _ = (function (){var statearr_33558 = state_33545;
(statearr_33558[(4)] = cljs.core.rest.call(null,(state_33545[(4)])));

return statearr_33558;
})();
var state_33545__$1 = state_33545;
var ex33555 = (state_33545__$1[(2)]);
var statearr_33559_33583 = state_33545__$1;
(statearr_33559_33583[(5)] = ex33555);


if((ex33555 instanceof java.lang.Exception)){
var statearr_33560_33584 = state_33545__$1;
(statearr_33560_33584[(1)] = (4));

(statearr_33560_33584[(5)] = null);

} else {
throw ex33555;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (5))){
var inst_33494 = (state_33545[(7)]);
var _ = (function (){var statearr_33562 = state_33545;
(statearr_33562[(4)] = cljs.core.cons.call(null,(8),(state_33545[(4)])));

return statearr_33562;
})();
var inst_33501 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33494,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_33563 = state_33545;
(statearr_33563[(4)] = cljs.core.rest.call(null,(state_33545[(4)])));

return statearr_33563;
})();
var state_33545__$1 = state_33545;
var statearr_33564_33585 = state_33545__$1;
(statearr_33564_33585[(2)] = inst_33501);

(statearr_33564_33585[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (10))){
var inst_33526 = (state_33545[(9)]);
var inst_33524 = (state_33545[(2)]);
var inst_33525 = fluree.db.util.async.throw_err.call(null,inst_33524);
var inst_33526__$1 = cljs.core.nth.call(null,inst_33525,(0),null);
var inst_33527 = cljs.core.nth.call(null,inst_33525,(1),null);
var inst_33528 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_33526__$1);
var inst_33529 = cljs.core.not.call(null,inst_33528);
var state_33545__$1 = (function (){var statearr_33565 = state_33545;
(statearr_33565[(9)] = inst_33526__$1);

(statearr_33565[(8)] = inst_33527);

return statearr_33565;
})();
if(inst_33529){
var statearr_33566_33586 = state_33545__$1;
(statearr_33566_33586[(1)] = (11));

} else {
var statearr_33567_33587 = state_33545__$1;
(statearr_33567_33587[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33546 === (8))){
var _ = (function (){var statearr_33568 = state_33545;
(statearr_33568[(4)] = cljs.core.rest.call(null,(state_33545[(4)])));

return statearr_33568;
})();
var state_33545__$1 = state_33545;
var ex33561 = (state_33545__$1[(2)]);
var statearr_33569_33588 = state_33545__$1;
(statearr_33569_33588[(5)] = ex33561);


if((ex33561 instanceof java.lang.Exception)){
var statearr_33570_33589 = state_33545__$1;
(statearr_33570_33589[(1)] = (7));

(statearr_33570_33589[(5)] = null);

} else {
throw ex33561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____0 = (function (){
var statearr_33571 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33571[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__);

(statearr_33571[(1)] = (1));

return statearr_33571;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____1 = (function (state_33545){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33572){var ex__2457__auto__ = e33572;
var statearr_33573_33590 = state_33545;
(statearr_33573_33590[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33545[(4)]))){
var statearr_33574_33591 = state_33545;
(statearr_33574_33591[(1)] = cljs.core.first.call(null,(state_33545[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33592 = state_33545;
state_33545 = G__33592;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__ = function(state_33545){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____1.call(this,state_33545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33575 = f__2477__auto__.call(null);
(statearr_33575[(6)] = c__2476__auto__);

return statearr_33575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,((typeof email === 'string')?cljs.core.re_matches.call(null,pattern,email):false));
}catch (e33593){if((e33593 instanceof java.lang.Exception)){
var e = e33593;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
} else {
throw e33593;

}
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__33595 = arguments.length;
switch (G__33595) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33665){
var state_val_33666 = (state_33665[(1)]);
if((state_val_33666 === (7))){
var inst_33597 = (state_33665[(2)]);
var state_33665__$1 = state_33665;
var statearr_33667_33711 = state_33665__$1;
(statearr_33667_33711[(2)] = inst_33597);

(statearr_33667_33711[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (20))){
var inst_33641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33642 = ["*"];
var inst_33643 = (new cljs.core.PersistentVector(null,1,(5),inst_33641,inst_33642,null));
var state_33665__$1 = state_33665;
var statearr_33668_33712 = state_33665__$1;
(statearr_33668_33712[(2)] = inst_33643);

(statearr_33668_33712[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (1))){
var state_33665__$1 = state_33665;
var statearr_33669_33713 = state_33665__$1;
(statearr_33669_33713[(2)] = null);

(statearr_33669_33713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (4))){
var inst_33596 = (state_33665[(2)]);
var state_33665__$1 = (function (){var statearr_33670 = state_33665;
(statearr_33670[(7)] = inst_33596);

return statearr_33670;
})();
var statearr_33671_33714 = state_33665__$1;
(statearr_33671_33714[(2)] = null);

(statearr_33671_33714[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (15))){
var inst_33660 = (state_33665[(2)]);
var _ = (function (){var statearr_33672 = state_33665;
(statearr_33672[(4)] = cljs.core.rest.call(null,(state_33665[(4)])));

return statearr_33672;
})();
var state_33665__$1 = state_33665;
var statearr_33673_33715 = state_33665__$1;
(statearr_33673_33715[(2)] = inst_33660);

(statearr_33673_33715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (21))){
var inst_33624 = (state_33665[(8)]);
var inst_33631 = (state_33665[(9)]);
var inst_33645 = (state_33665[(2)]);
var inst_33646 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_33647 = [inst_33645,inst_33631];
var inst_33648 = cljs.core.PersistentHashMap.fromArrays(inst_33646,inst_33647);
var inst_33649 = cljs.core.PersistentHashMap.EMPTY;
var inst_33650 = fluree.db.dbfunctions.internal.query.call(null,inst_33624,inst_33648,inst_33649);
var state_33665__$1 = state_33665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33665__$1,(22),inst_33650);
} else {
if((state_val_33666 === (13))){
var inst_33619 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_33665__$1 = state_33665;
var statearr_33674_33716 = state_33665__$1;
(statearr_33674_33716[(2)] = inst_33619);

(statearr_33674_33716[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (22))){
var inst_33652 = (state_33665[(2)]);
var inst_33653 = fluree.db.util.async.throw_err.call(null,inst_33652);
var inst_33654 = cljs.core.nth.call(null,inst_33653,(0),null);
var inst_33655 = cljs.core.nth.call(null,inst_33653,(1),null);
var inst_33656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33657 = [inst_33654,inst_33655];
var inst_33658 = (new cljs.core.PersistentVector(null,2,(5),inst_33656,inst_33657,null));
var state_33665__$1 = state_33665;
var statearr_33675_33717 = state_33665__$1;
(statearr_33675_33717[(2)] = inst_33658);

(statearr_33675_33717[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (6))){
var inst_33606 = (state_33665[(2)]);
var state_33665__$1 = state_33665;
var statearr_33676_33718 = state_33665__$1;
(statearr_33676_33718[(2)] = inst_33606);

(statearr_33676_33718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (17))){
var inst_33628 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33629 = fluree.db.dbfunctions.internal.get.call(null,inst_33628,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_33665__$1 = state_33665;
var statearr_33677_33719 = state_33665__$1;
(statearr_33677_33719[(2)] = inst_33629);

(statearr_33677_33719[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (3))){
var inst_33663 = (state_33665[(2)]);
var state_33665__$1 = state_33665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33665__$1,inst_33663);
} else {
if((state_val_33666 === (12))){
var inst_33617 = (state_33665[(2)]);
var state_33665__$1 = state_33665;
if(cljs.core.truth_(inst_33617)){
var statearr_33678_33720 = state_33665__$1;
(statearr_33678_33720[(1)] = (13));

} else {
var statearr_33679_33721 = state_33665__$1;
(statearr_33679_33721[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (2))){
var inst_33612 = (state_33665[(10)]);
var _ = (function (){var statearr_33680 = state_33665;
(statearr_33680[(4)] = cljs.core.cons.call(null,(9),(state_33665[(4)])));

return statearr_33680;
})();
var inst_33612__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_33665__$1 = (function (){var statearr_33681 = state_33665;
(statearr_33681[(10)] = inst_33612__$1);

return statearr_33681;
})();
if(cljs.core.truth_(inst_33612__$1)){
var statearr_33682_33722 = state_33665__$1;
(statearr_33682_33722[(1)] = (10));

} else {
var statearr_33683_33723 = state_33665__$1;
(statearr_33683_33723[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (19))){
var inst_33633 = cljs.core.PersistentVector.EMPTY;
var inst_33634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33635 = ["*"];
var inst_33636 = (new cljs.core.PersistentVector(null,1,(5),inst_33634,inst_33635,null));
var inst_33637 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_33638 = cljs.core.concat.call(null,inst_33636,inst_33637);
var inst_33639 = cljs.core.into.call(null,inst_33633,inst_33638);
var state_33665__$1 = state_33665;
var statearr_33685_33724 = state_33665__$1;
(statearr_33685_33724[(2)] = inst_33639);

(statearr_33685_33724[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (11))){
var inst_33612 = (state_33665[(10)]);
var state_33665__$1 = state_33665;
var statearr_33686_33725 = state_33665__$1;
(statearr_33686_33725[(2)] = inst_33612);

(statearr_33686_33725[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (9))){
var _ = (function (){var statearr_33687 = state_33665;
(statearr_33687[(4)] = cljs.core.rest.call(null,(state_33665[(4)])));

return statearr_33687;
})();
var state_33665__$1 = state_33665;
var ex33684 = (state_33665__$1[(2)]);
var statearr_33688_33726 = state_33665__$1;
(statearr_33688_33726[(5)] = ex33684);


if((ex33684 instanceof java.lang.Exception)){
var statearr_33689_33727 = state_33665__$1;
(statearr_33689_33727[(1)] = (4));

(statearr_33689_33727[(5)] = null);

} else {
throw ex33684;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (5))){
var inst_33596 = (state_33665[(7)]);
var _ = (function (){var statearr_33690 = state_33665;
(statearr_33690[(4)] = cljs.core.cons.call(null,(8),(state_33665[(4)])));

return statearr_33690;
})();
var inst_33603 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33596,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_33691 = state_33665;
(statearr_33691[(4)] = cljs.core.rest.call(null,(state_33665[(4)])));

return statearr_33691;
})();
var state_33665__$1 = state_33665;
var statearr_33692_33728 = state_33665__$1;
(statearr_33692_33728[(2)] = inst_33603);

(statearr_33692_33728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (14))){
var inst_33625 = (state_33665[(11)]);
var inst_33624 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33625__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_33665__$1 = (function (){var statearr_33693 = state_33665;
(statearr_33693[(8)] = inst_33624);

(statearr_33693[(11)] = inst_33625__$1);

return statearr_33693;
})();
if(cljs.core.truth_(inst_33625__$1)){
var statearr_33694_33729 = state_33665__$1;
(statearr_33694_33729[(1)] = (16));

} else {
var statearr_33695_33730 = state_33665__$1;
(statearr_33695_33730[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (16))){
var inst_33625 = (state_33665[(11)]);
var state_33665__$1 = state_33665;
var statearr_33696_33731 = state_33665__$1;
(statearr_33696_33731[(2)] = inst_33625);

(statearr_33696_33731[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (10))){
var inst_33614 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_33665__$1 = state_33665;
var statearr_33698_33732 = state_33665__$1;
(statearr_33698_33732[(2)] = inst_33614);

(statearr_33698_33732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (18))){
var inst_33631 = (state_33665[(2)]);
var state_33665__$1 = (function (){var statearr_33699 = state_33665;
(statearr_33699[(9)] = inst_33631);

return statearr_33699;
})();
if(cljs.core.truth_(additional_params)){
var statearr_33700_33733 = state_33665__$1;
(statearr_33700_33733[(1)] = (19));

} else {
var statearr_33701_33734 = state_33665__$1;
(statearr_33701_33734[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33666 === (8))){
var _ = (function (){var statearr_33702 = state_33665;
(statearr_33702[(4)] = cljs.core.rest.call(null,(state_33665[(4)])));

return statearr_33702;
})();
var state_33665__$1 = state_33665;
var ex33697 = (state_33665__$1[(2)]);
var statearr_33703_33735 = state_33665__$1;
(statearr_33703_33735[(5)] = ex33697);


if((ex33697 instanceof java.lang.Exception)){
var statearr_33704_33736 = state_33665__$1;
(statearr_33704_33736[(1)] = (7));

(statearr_33704_33736[(5)] = null);

} else {
throw ex33697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2454__auto____0 = (function (){
var statearr_33705 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33705[(0)] = fluree$db$dbfunctions$internal$state_machine__2454__auto__);

(statearr_33705[(1)] = (1));

return statearr_33705;
});
var fluree$db$dbfunctions$internal$state_machine__2454__auto____1 = (function (state_33665){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33706){var ex__2457__auto__ = e33706;
var statearr_33707_33737 = state_33665;
(statearr_33707_33737[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33665[(4)]))){
var statearr_33708_33738 = state_33665;
(statearr_33708_33738[(1)] = cljs.core.first.call(null,(state_33665[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33739 = state_33665;
state_33665 = G__33739;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2454__auto__ = function(state_33665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____1.call(this,state_33665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33709 = f__2477__auto__.call(null);
(statearr_33709[(6)] = c__2476__auto__);

return statearr_33709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__33741 = arguments.length;
switch (G__33741) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33785){
var state_val_33786 = (state_33785[(1)]);
if((state_val_33786 === (7))){
var inst_33763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33764 = ["*"];
var inst_33765 = (new cljs.core.PersistentVector(null,1,(5),inst_33763,inst_33764,null));
var state_33785__$1 = state_33785;
var statearr_33787_33807 = state_33785__$1;
(statearr_33787_33807[(2)] = inst_33765);

(statearr_33787_33807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (1))){
var state_33785__$1 = state_33785;
var statearr_33788_33808 = state_33785__$1;
(statearr_33788_33808[(2)] = null);

(statearr_33788_33808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (4))){
var inst_33742 = (state_33785[(2)]);
var inst_33743 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33742,"?p","Context Object",additional_params);
var state_33785__$1 = state_33785;
var statearr_33789_33809 = state_33785__$1;
(statearr_33789_33809[(2)] = inst_33743);

(statearr_33789_33809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (6))){
var inst_33755 = cljs.core.PersistentVector.EMPTY;
var inst_33756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33757 = ["*"];
var inst_33758 = (new cljs.core.PersistentVector(null,1,(5),inst_33756,inst_33757,null));
var inst_33759 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_33760 = cljs.core.concat.call(null,inst_33758,inst_33759);
var inst_33761 = cljs.core.into.call(null,inst_33755,inst_33760);
var state_33785__$1 = state_33785;
var statearr_33790_33810 = state_33785__$1;
(statearr_33790_33810[(2)] = inst_33761);

(statearr_33790_33810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (3))){
var inst_33783 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33785__$1,inst_33783);
} else {
if((state_val_33786 === (2))){
var _ = (function (){var statearr_33792 = state_33785;
(statearr_33792[(4)] = cljs.core.cons.call(null,(5),(state_33785[(4)])));

return statearr_33792;
})();
var inst_33752 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33753 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_33785__$1 = (function (){var statearr_33793 = state_33785;
(statearr_33793[(7)] = inst_33752);

(statearr_33793[(8)] = inst_33753);

return statearr_33793;
})();
if(cljs.core.truth_(additional_params)){
var statearr_33794_33811 = state_33785__$1;
(statearr_33794_33811[(1)] = (6));

} else {
var statearr_33795_33812 = state_33785__$1;
(statearr_33795_33812[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (9))){
var inst_33774 = (state_33785[(2)]);
var inst_33775 = fluree.db.util.async.throw_err.call(null,inst_33774);
var inst_33776 = cljs.core.nth.call(null,inst_33775,(0),null);
var inst_33777 = cljs.core.nth.call(null,inst_33775,(1),null);
var inst_33778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33779 = [inst_33776,inst_33777];
var inst_33780 = (new cljs.core.PersistentVector(null,2,(5),inst_33778,inst_33779,null));
var _ = (function (){var statearr_33796 = state_33785;
(statearr_33796[(4)] = cljs.core.rest.call(null,(state_33785[(4)])));

return statearr_33796;
})();
var state_33785__$1 = state_33785;
var statearr_33797_33813 = state_33785__$1;
(statearr_33797_33813[(2)] = inst_33780);

(statearr_33797_33813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (5))){
var _ = (function (){var statearr_33798 = state_33785;
(statearr_33798[(4)] = cljs.core.rest.call(null,(state_33785[(4)])));

return statearr_33798;
})();
var state_33785__$1 = state_33785;
var ex33791 = (state_33785__$1[(2)]);
var statearr_33799_33814 = state_33785__$1;
(statearr_33799_33814[(5)] = ex33791);


if((ex33791 instanceof java.lang.Exception)){
var statearr_33800_33815 = state_33785__$1;
(statearr_33800_33815[(1)] = (4));

(statearr_33800_33815[(5)] = null);

} else {
throw ex33791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (8))){
var inst_33752 = (state_33785[(7)]);
var inst_33753 = (state_33785[(8)]);
var inst_33767 = (state_33785[(2)]);
var inst_33768 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_33769 = [inst_33767,inst_33753];
var inst_33770 = cljs.core.PersistentHashMap.fromArrays(inst_33768,inst_33769);
var inst_33771 = cljs.core.PersistentHashMap.EMPTY;
var inst_33772 = fluree.db.dbfunctions.internal.query.call(null,inst_33752,inst_33770,inst_33771);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33785__$1,(9),inst_33772);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2454__auto____0 = (function (){
var statearr_33801 = [null,null,null,null,null,null,null,null,null];
(statearr_33801[(0)] = fluree$db$dbfunctions$internal$state_machine__2454__auto__);

(statearr_33801[(1)] = (1));

return statearr_33801;
});
var fluree$db$dbfunctions$internal$state_machine__2454__auto____1 = (function (state_33785){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33802){var ex__2457__auto__ = e33802;
var statearr_33803_33816 = state_33785;
(statearr_33803_33816[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33785[(4)]))){
var statearr_33804_33817 = state_33785;
(statearr_33804_33817[(1)] = cljs.core.first.call(null,(state_33785[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33818 = state_33785;
state_33785 = G__33818;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2454__auto__ = function(state_33785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2454__auto____1.call(this,state_33785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33805 = f__2477__auto__.call(null);
(statearr_33805[(6)] = c__2476__auto__);

return statearr_33805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33862){
var state_val_33863 = (state_33862[(1)]);
if((state_val_33863 === (1))){
var state_33862__$1 = state_33862;
var statearr_33864_33878 = state_33862__$1;
(statearr_33864_33878[(2)] = null);

(statearr_33864_33878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33863 === (2))){
var _ = (function (){var statearr_33865 = state_33862;
(statearr_33865[(4)] = cljs.core.cons.call(null,(5),(state_33862[(4)])));

return statearr_33865;
})();
var inst_33829 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_33830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33831 = ["_user/_auth"];
var inst_33832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33833 = ["*"];
var inst_33834 = (new cljs.core.PersistentVector(null,1,(5),inst_33832,inst_33833,null));
var inst_33835 = [inst_33834];
var inst_33836 = cljs.core.PersistentHashMap.fromArrays(inst_33831,inst_33835);
var inst_33837 = [inst_33836];
var inst_33838 = (new cljs.core.PersistentVector(null,1,(5),inst_33830,inst_33837,null));
var inst_33839 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33840 = [inst_33838,inst_33839];
var inst_33841 = cljs.core.PersistentHashMap.fromArrays(inst_33829,inst_33840);
var inst_33842 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33843 = cljs.core.PersistentHashMap.EMPTY;
var inst_33844 = fluree.db.dbfunctions.internal.query.call(null,inst_33842,inst_33841,inst_33843);
var state_33862__$1 = state_33862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33862__$1,(6),inst_33844);
} else {
if((state_val_33863 === (3))){
var inst_33860 = (state_33862[(2)]);
var state_33862__$1 = state_33862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33862__$1,inst_33860);
} else {
if((state_val_33863 === (4))){
var inst_33819 = (state_33862[(2)]);
var inst_33820 = fluree.db.dbfunctions.internal.function_error.call(null,inst_33819,"?user_id-from-auth","Context Object");
var state_33862__$1 = state_33862;
var statearr_33867_33879 = state_33862__$1;
(statearr_33867_33879[(2)] = inst_33820);

(statearr_33867_33879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33863 === (5))){
var _ = (function (){var statearr_33868 = state_33862;
(statearr_33868[(4)] = cljs.core.rest.call(null,(state_33862[(4)])));

return statearr_33868;
})();
var state_33862__$1 = state_33862;
var ex33866 = (state_33862__$1[(2)]);
var statearr_33869_33880 = state_33862__$1;
(statearr_33869_33880[(5)] = ex33866);


if((ex33866 instanceof java.lang.Exception)){
var statearr_33870_33881 = state_33862__$1;
(statearr_33870_33881[(1)] = (4));

(statearr_33870_33881[(5)] = null);

} else {
throw ex33866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33863 === (6))){
var inst_33846 = (state_33862[(2)]);
var inst_33847 = fluree.db.util.async.throw_err.call(null,inst_33846);
var inst_33848 = cljs.core.nth.call(null,inst_33847,(0),null);
var inst_33849 = cljs.core.nth.call(null,inst_33847,(1),null);
var inst_33850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33851 = ["_user/_auth","_id"];
var inst_33852 = (new cljs.core.PersistentVector(null,2,(5),inst_33850,inst_33851,null));
var inst_33853 = fluree.db.dbfunctions.internal.get_in.call(null,inst_33848,inst_33852);
var inst_33854 = cljs.core.first.call(null,inst_33853);
var inst_33855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33856 = [inst_33854,inst_33849];
var inst_33857 = (new cljs.core.PersistentVector(null,2,(5),inst_33855,inst_33856,null));
var _ = (function (){var statearr_33871 = state_33862;
(statearr_33871[(4)] = cljs.core.rest.call(null,(state_33862[(4)])));

return statearr_33871;
})();
var state_33862__$1 = state_33862;
var statearr_33872_33882 = state_33862__$1;
(statearr_33872_33882[(2)] = inst_33857);

(statearr_33872_33882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____0 = (function (){
var statearr_33873 = [null,null,null,null,null,null,null];
(statearr_33873[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__);

(statearr_33873[(1)] = (1));

return statearr_33873;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____1 = (function (state_33862){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33874){var ex__2457__auto__ = e33874;
var statearr_33875_33883 = state_33862;
(statearr_33875_33883[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33862[(4)]))){
var statearr_33876_33884 = state_33862;
(statearr_33876_33884[(1)] = cljs.core.first.call(null,(state_33862[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33885 = state_33862;
state_33862 = G__33885;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__ = function(state_33862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____1.call(this,state_33862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33877 = f__2477__auto__.call(null);
(statearr_33877[(6)] = c__2476__auto__);

return statearr_33877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_33902){
var state_val_33903 = (state_33902[(1)]);
if((state_val_33903 === (1))){
var state_33902__$1 = state_33902;
var statearr_33904_33918 = state_33902__$1;
(statearr_33904_33918[(2)] = null);

(statearr_33904_33918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33903 === (2))){
var _ = (function (){var statearr_33905 = state_33902;
(statearr_33905[(4)] = cljs.core.cons.call(null,(5),(state_33902[(4)])));

return statearr_33905;
})();
var inst_33892 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33893 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_33894 = fluree.db.dbproto._subid.call(null,inst_33893,inst_33892);
var state_33902__$1 = state_33902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33902__$1,(6),inst_33894);
} else {
if((state_val_33903 === (3))){
var inst_33900 = (state_33902[(2)]);
var state_33902__$1 = state_33902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33902__$1,inst_33900);
} else {
if((state_val_33903 === (4))){
var inst_33886 = (state_33902[(2)]);
var state_33902__$1 = state_33902;
var statearr_33907_33919 = state_33902__$1;
(statearr_33907_33919[(2)] = inst_33886);

(statearr_33907_33919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33903 === (5))){
var _ = (function (){var statearr_33908 = state_33902;
(statearr_33908[(4)] = cljs.core.rest.call(null,(state_33902[(4)])));

return statearr_33908;
})();
var state_33902__$1 = state_33902;
var ex33906 = (state_33902__$1[(2)]);
var statearr_33909_33920 = state_33902__$1;
(statearr_33909_33920[(5)] = ex33906);


if((ex33906 instanceof Error)){
var statearr_33910_33921 = state_33902__$1;
(statearr_33910_33921[(1)] = (4));

(statearr_33910_33921[(5)] = null);

} else {
throw ex33906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33903 === (6))){
var inst_33896 = (state_33902[(2)]);
var inst_33897 = fluree.db.util.async.throw_err.call(null,inst_33896);
var _ = (function (){var statearr_33911 = state_33902;
(statearr_33911[(4)] = cljs.core.rest.call(null,(state_33902[(4)])));

return statearr_33911;
})();
var state_33902__$1 = state_33902;
var statearr_33912_33922 = state_33902__$1;
(statearr_33912_33922[(2)] = inst_33897);

(statearr_33912_33922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____0 = (function (){
var statearr_33913 = [null,null,null,null,null,null,null];
(statearr_33913[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__);

(statearr_33913[(1)] = (1));

return statearr_33913;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____1 = (function (state_33902){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_33902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e33914){var ex__2457__auto__ = e33914;
var statearr_33915_33923 = state_33902;
(statearr_33915_33923[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_33902[(4)]))){
var statearr_33916_33924 = state_33902;
(statearr_33916_33924[(1)] = cljs.core.first.call(null,(state_33902[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33925 = state_33902;
state_33902 = G__33925;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__ = function(state_33902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____1.call(this,state_33902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_33917 = f__2477__auto__.call(null);
(statearr_33917[(6)] = c__2476__auto__);

return statearr_33917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__33926_SHARP_){
return p1__33926_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__33927_SHARP_){
return p1__33927_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e33928){if((e33928 instanceof java.lang.Exception)){
var e = e33928;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
} else {
throw e33928;

}
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__33929_SHARP_){
return p1__33929_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__33930_SHARP_){
return p1__33930_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e33931){if((e33931 instanceof java.lang.Exception)){
var e = e33931;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
} else {
throw e33931;

}
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e33932){if((e33932 instanceof java.lang.Exception)){
var e = e33932;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
} else {
throw e33932;

}
}});
