// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___58629 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_58680){
var state_val_58681 = (state_58680[(1)]);
if((state_val_58681 === (7))){
var inst_58675 = (state_58680[(2)]);
var _ = (function (){var statearr_58682 = state_58680;
(statearr_58682[(4)] = cljs.core.rest.call(null,(state_58680[(4)])));

return statearr_58682;
})();
var state_58680__$1 = state_58680;
var statearr_58683_58710 = state_58680__$1;
(statearr_58683_58710[(2)] = inst_58675);

(statearr_58683_58710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (1))){
var state_58680__$1 = state_58680;
var statearr_58684_58711 = state_58680__$1;
(statearr_58684_58711[(2)] = null);

(statearr_58684_58711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (4))){
var inst_58630 = (state_58680[(2)]);
var state_58680__$1 = state_58680;
var statearr_58685_58712 = state_58680__$1;
(statearr_58685_58712[(2)] = inst_58630);

(statearr_58685_58712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (13))){
var inst_58671 = (state_58680[(2)]);
var state_58680__$1 = state_58680;
var statearr_58686_58713 = state_58680__$1;
(statearr_58686_58713[(2)] = inst_58671);

(statearr_58686_58713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (6))){
var inst_58648 = (state_58680[(7)]);
var inst_58655 = (state_58680[(8)]);
var inst_58654 = cljs.core.seq.call(null,inst_58648);
var inst_58655__$1 = cljs.core.first.call(null,inst_58654);
var inst_58656 = cljs.core.next.call(null,inst_58654);
var inst_58657 = cljs.core.not.call(null,inst_58655__$1);
var state_58680__$1 = (function (){var statearr_58687 = state_58680;
(statearr_58687[(8)] = inst_58655__$1);

(statearr_58687[(9)] = inst_58656);

return statearr_58687;
})();
if(inst_58657){
var statearr_58688_58714 = state_58680__$1;
(statearr_58688_58714[(1)] = (8));

} else {
var statearr_58689_58715 = state_58680__$1;
(statearr_58689_58715[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (3))){
var inst_58678 = (state_58680[(2)]);
var state_58680__$1 = state_58680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58680__$1,inst_58678);
} else {
if((state_val_58681 === (12))){
var inst_58649 = (state_58680[(10)]);
var inst_58655 = (state_58680[(8)]);
var inst_58656 = (state_58680[(9)]);
var inst_58668 = cljs.core.conj.call(null,inst_58649,inst_58655);
var inst_58648 = inst_58656;
var inst_58649__$1 = inst_58668;
var state_58680__$1 = (function (){var statearr_58690 = state_58680;
(statearr_58690[(10)] = inst_58649__$1);

(statearr_58690[(7)] = inst_58648);

return statearr_58690;
})();
var statearr_58691_58716 = state_58680__$1;
(statearr_58691_58716[(2)] = null);

(statearr_58691_58716[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (2))){
var _ = (function (){var statearr_58692 = state_58680;
(statearr_58692[(4)] = cljs.core.cons.call(null,(5),(state_58680[(4)])));

return statearr_58692;
})();
var inst_58643 = args;
var inst_58644 = cljs.core.seq.call(null,inst_58643);
var inst_58645 = cljs.core.first.call(null,inst_58644);
var inst_58646 = cljs.core.next.call(null,inst_58644);
var inst_58647 = cljs.core.PersistentVector.EMPTY;
var inst_58648 = inst_58643;
var inst_58649 = inst_58647;
var state_58680__$1 = (function (){var statearr_58693 = state_58680;
(statearr_58693[(10)] = inst_58649);

(statearr_58693[(7)] = inst_58648);

(statearr_58693[(11)] = inst_58646);

(statearr_58693[(12)] = inst_58645);

return statearr_58693;
})();
var statearr_58694_58717 = state_58680__$1;
(statearr_58694_58717[(2)] = null);

(statearr_58694_58717[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (11))){
var inst_58655 = (state_58680[(8)]);
var state_58680__$1 = state_58680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58680__$1,(14),inst_58655);
} else {
if((state_val_58681 === (9))){
var inst_58655 = (state_58680[(8)]);
var inst_58660 = fluree.db.util.async.channel_QMARK_.call(null,inst_58655);
var state_58680__$1 = state_58680;
if(inst_58660){
var statearr_58696_58718 = state_58680__$1;
(statearr_58696_58718[(1)] = (11));

} else {
var statearr_58697_58719 = state_58680__$1;
(statearr_58697_58719[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (5))){
var _ = (function (){var statearr_58698 = state_58680;
(statearr_58698[(4)] = cljs.core.rest.call(null,(state_58680[(4)])));

return statearr_58698;
})();
var state_58680__$1 = state_58680;
var ex58695 = (state_58680__$1[(2)]);
var statearr_58699_58720 = state_58680__$1;
(statearr_58699_58720[(5)] = ex58695);


if((ex58695 instanceof Error)){
var statearr_58700_58721 = state_58680__$1;
(statearr_58700_58721[(1)] = (4));

(statearr_58700_58721[(5)] = null);

} else {
throw ex58695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (14))){
var inst_58649 = (state_58680[(10)]);
var inst_58656 = (state_58680[(9)]);
var inst_58663 = (state_58680[(2)]);
var inst_58664 = fluree.db.util.async.throw_err.call(null,inst_58663);
var inst_58665 = cljs.core.conj.call(null,inst_58649,inst_58664);
var inst_58648 = inst_58656;
var inst_58649__$1 = inst_58665;
var state_58680__$1 = (function (){var statearr_58701 = state_58680;
(statearr_58701[(10)] = inst_58649__$1);

(statearr_58701[(7)] = inst_58648);

return statearr_58701;
})();
var statearr_58702_58722 = state_58680__$1;
(statearr_58702_58722[(2)] = null);

(statearr_58702_58722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (10))){
var inst_58673 = (state_58680[(2)]);
var state_58680__$1 = state_58680;
var statearr_58703_58723 = state_58680__$1;
(statearr_58703_58723[(2)] = inst_58673);

(statearr_58703_58723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58681 === (8))){
var inst_58649 = (state_58680[(10)]);
var state_58680__$1 = state_58680;
var statearr_58704_58724 = state_58680__$1;
(statearr_58704_58724[(2)] = inst_58649);

(statearr_58704_58724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____0 = (function (){
var statearr_58705 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58705[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__);

(statearr_58705[(1)] = (1));

return statearr_58705;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____1 = (function (state_58680){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_58680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e58706){var ex__2457__auto__ = e58706;
var statearr_58707_58725 = state_58680;
(statearr_58707_58725[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_58680[(4)]))){
var statearr_58708_58726 = state_58680;
(statearr_58708_58726[(1)] = cljs.core.first.call(null,(state_58680[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58727 = state_58680;
state_58680 = G__58727;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__ = function(state_58680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____1.call(this,state_58680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_58709 = f__2477__auto__.call(null);
(statearr_58709[(6)] = c__2476__auto__);

return statearr_58709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__58728 = entry;
var res = cljs.core.nth.call(null,vec__58728,(0),null);
var cost = cljs.core.nth.call(null,vec__58728,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_58776){
var state_val_58777 = (state_58776[(1)]);
if((state_val_58777 === (7))){
var state_58776__$1 = state_58776;
var statearr_58778_58807 = state_58776__$1;
(statearr_58778_58807[(2)] = coll);

(statearr_58778_58807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (1))){
var state_58776__$1 = state_58776;
var statearr_58779_58808 = state_58776__$1;
(statearr_58779_58808[(2)] = null);

(statearr_58779_58808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (4))){
var inst_58731 = (state_58776[(2)]);
var state_58776__$1 = state_58776;
var statearr_58780_58809 = state_58776__$1;
(statearr_58780_58809[(2)] = inst_58731);

(statearr_58780_58809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (15))){
var inst_58750 = (state_58776[(7)]);
var inst_58758 = (state_58776[(2)]);
var inst_58759 = fluree.db.dbfunctions.internal.nth.call(null,inst_58750,inst_58758);
var inst_58760 = cljs.core.count.call(null,inst_58750);
var inst_58761 = ((9) + inst_58760);
var inst_58762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58763 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58765 = [inst_58750,inst_58758];
var inst_58766 = (new cljs.core.PersistentVector(null,2,(5),inst_58764,inst_58765,null));
var inst_58767 = ["nth",inst_58766,inst_58759];
var inst_58768 = cljs.core.PersistentHashMap.fromArrays(inst_58763,inst_58767);
var inst_58769 = [inst_58768,inst_58761];
var inst_58770 = (new cljs.core.PersistentVector(null,2,(5),inst_58762,inst_58769,null));
var inst_58771 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_58770);
var _ = (function (){var statearr_58781 = state_58776;
(statearr_58781[(4)] = cljs.core.rest.call(null,(state_58776[(4)])));

return statearr_58781;
})();
var state_58776__$1 = (function (){var statearr_58782 = state_58776;
(statearr_58782[(8)] = inst_58771);

return statearr_58782;
})();
var statearr_58783_58810 = state_58776__$1;
(statearr_58783_58810[(2)] = inst_58759);

(statearr_58783_58810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (13))){
var state_58776__$1 = state_58776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58776__$1,(16),key);
} else {
if((state_val_58777 === (6))){
var state_58776__$1 = state_58776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58776__$1,(9),coll);
} else {
if((state_val_58777 === (3))){
var inst_58774 = (state_58776[(2)]);
var state_58776__$1 = state_58776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58776__$1,inst_58774);
} else {
if((state_val_58777 === (12))){
var inst_58750 = (state_58776[(2)]);
var inst_58751 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_58776__$1 = (function (){var statearr_58784 = state_58776;
(statearr_58784[(7)] = inst_58750);

return statearr_58784;
})();
if(inst_58751){
var statearr_58785_58811 = state_58776__$1;
(statearr_58785_58811[(1)] = (13));

} else {
var statearr_58786_58812 = state_58776__$1;
(statearr_58786_58812[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (2))){
var _ = (function (){var statearr_58787 = state_58776;
(statearr_58787[(4)] = cljs.core.cons.call(null,(5),(state_58776[(4)])));

return statearr_58787;
})();
var inst_58737 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_58776__$1 = state_58776;
if(inst_58737){
var statearr_58788_58813 = state_58776__$1;
(statearr_58788_58813[(1)] = (6));

} else {
var statearr_58789_58814 = state_58776__$1;
(statearr_58789_58814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (11))){
var inst_58744 = (state_58776[(9)]);
var state_58776__$1 = state_58776;
var statearr_58791_58815 = state_58776__$1;
(statearr_58791_58815[(2)] = inst_58744);

(statearr_58791_58815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (9))){
var inst_58740 = (state_58776[(2)]);
var inst_58741 = fluree.db.util.async.throw_err.call(null,inst_58740);
var state_58776__$1 = state_58776;
var statearr_58792_58816 = state_58776__$1;
(statearr_58792_58816[(2)] = inst_58741);

(statearr_58792_58816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (5))){
var _ = (function (){var statearr_58793 = state_58776;
(statearr_58793[(4)] = cljs.core.rest.call(null,(state_58776[(4)])));

return statearr_58793;
})();
var state_58776__$1 = state_58776;
var ex58790 = (state_58776__$1[(2)]);
var statearr_58794_58817 = state_58776__$1;
(statearr_58794_58817[(5)] = ex58790);


if((ex58790 instanceof Error)){
var statearr_58795_58818 = state_58776__$1;
(statearr_58795_58818[(1)] = (4));

(statearr_58795_58818[(5)] = null);

} else {
throw ex58790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (14))){
var state_58776__$1 = state_58776;
var statearr_58796_58819 = state_58776__$1;
(statearr_58796_58819[(2)] = key);

(statearr_58796_58819[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (16))){
var inst_58754 = (state_58776[(2)]);
var inst_58755 = fluree.db.util.async.throw_err.call(null,inst_58754);
var state_58776__$1 = state_58776;
var statearr_58797_58820 = state_58776__$1;
(statearr_58797_58820[(2)] = inst_58755);

(statearr_58797_58820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (10))){
var inst_58744 = (state_58776[(9)]);
var inst_58747 = cljs.core.vec.call(null,inst_58744);
var state_58776__$1 = state_58776;
var statearr_58798_58821 = state_58776__$1;
(statearr_58798_58821[(2)] = inst_58747);

(statearr_58798_58821[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58777 === (8))){
var inst_58744 = (state_58776[(9)]);
var inst_58744__$1 = (state_58776[(2)]);
var inst_58745 = cljs.core.set_QMARK_.call(null,inst_58744__$1);
var state_58776__$1 = (function (){var statearr_58799 = state_58776;
(statearr_58799[(9)] = inst_58744__$1);

return statearr_58799;
})();
if(inst_58745){
var statearr_58800_58822 = state_58776__$1;
(statearr_58800_58822[(1)] = (10));

} else {
var statearr_58801_58823 = state_58776__$1;
(statearr_58801_58823[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____0 = (function (){
var statearr_58802 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58802[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__);

(statearr_58802[(1)] = (1));

return statearr_58802;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____1 = (function (state_58776){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_58776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e58803){var ex__2457__auto__ = e58803;
var statearr_58804_58824 = state_58776;
(statearr_58804_58824[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_58776[(4)]))){
var statearr_58805_58825 = state_58776;
(statearr_58805_58825[(1)] = cljs.core.first.call(null,(state_58776[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58826 = state_58776;
state_58776 = G__58826;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__ = function(state_58776){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____1.call(this,state_58776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_58806 = f__2477__auto__.call(null);
(statearr_58806[(6)] = c__2476__auto__);

return statearr_58806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_58887){
var state_val_58888 = (state_58887[(1)]);
if((state_val_58888 === (7))){
var state_58887__$1 = state_58887;
var statearr_58889_58923 = state_58887__$1;
(statearr_58889_58923[(2)] = test);

(statearr_58889_58923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (20))){
var inst_58861 = (state_58887[(2)]);
var inst_58862 = fluree.db.util.async.throw_err.call(null,inst_58861);
var state_58887__$1 = state_58887;
var statearr_58890_58924 = state_58887__$1;
(statearr_58890_58924[(2)] = inst_58862);

(statearr_58890_58924[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (1))){
var state_58887__$1 = state_58887;
var statearr_58891_58925 = state_58887__$1;
(statearr_58891_58925[(2)] = null);

(statearr_58891_58925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (4))){
var inst_58827 = (state_58887[(2)]);
var state_58887__$1 = state_58887;
var statearr_58892_58926 = state_58887__$1;
(statearr_58892_58926[(2)] = inst_58827);

(statearr_58892_58926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (15))){
var inst_58845 = (state_58887[(7)]);
var inst_58853 = (state_58887[(2)]);
var inst_58854 = [inst_58853,f];
var inst_58855 = (new cljs.core.PersistentVector(null,2,(5),inst_58845,inst_58854,null));
var state_58887__$1 = state_58887;
var statearr_58893_58927 = state_58887__$1;
(statearr_58893_58927[(2)] = inst_58855);

(statearr_58893_58927[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (13))){
var state_58887__$1 = state_58887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58887__$1,(16),t);
} else {
if((state_val_58888 === (6))){
var state_58887__$1 = state_58887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58887__$1,(9),test);
} else {
if((state_val_58888 === (17))){
var state_58887__$1 = state_58887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58887__$1,(20),f);
} else {
if((state_val_58888 === (3))){
var inst_58885 = (state_58887[(2)]);
var state_58887__$1 = state_58887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58887__$1,inst_58885);
} else {
if((state_val_58888 === (12))){
var inst_58843 = (state_58887[(8)]);
var inst_58869 = (state_58887[(2)]);
var inst_58870 = cljs.core.nth.call(null,inst_58869,(0),null);
var inst_58871 = cljs.core.nth.call(null,inst_58869,(1),null);
var inst_58872 = fluree.db.dbfunctions.internal.if_else.call(null,inst_58843,inst_58870,inst_58871);
var inst_58873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58874 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58876 = [inst_58843,inst_58870,inst_58871];
var inst_58877 = (new cljs.core.PersistentVector(null,3,(5),inst_58875,inst_58876,null));
var inst_58878 = ["if-else",inst_58877,inst_58872];
var inst_58879 = cljs.core.PersistentHashMap.fromArrays(inst_58874,inst_58878);
var inst_58880 = [inst_58879,(10)];
var inst_58881 = (new cljs.core.PersistentVector(null,2,(5),inst_58873,inst_58880,null));
var inst_58882 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_58881);
var _ = (function (){var statearr_58894 = state_58887;
(statearr_58894[(4)] = cljs.core.rest.call(null,(state_58887[(4)])));

return statearr_58894;
})();
var state_58887__$1 = (function (){var statearr_58895 = state_58887;
(statearr_58895[(9)] = inst_58882);

return statearr_58895;
})();
var statearr_58896_58928 = state_58887__$1;
(statearr_58896_58928[(2)] = inst_58872);

(statearr_58896_58928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (2))){
var _ = (function (){var statearr_58897 = state_58887;
(statearr_58897[(4)] = cljs.core.cons.call(null,(5),(state_58887[(4)])));

return statearr_58897;
})();
var inst_58836 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_58887__$1 = state_58887;
if(inst_58836){
var statearr_58898_58929 = state_58887__$1;
(statearr_58898_58929[(1)] = (6));

} else {
var statearr_58899_58930 = state_58887__$1;
(statearr_58899_58930[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (19))){
var inst_58857 = (state_58887[(10)]);
var inst_58865 = (state_58887[(2)]);
var inst_58866 = [f,inst_58865];
var inst_58867 = (new cljs.core.PersistentVector(null,2,(5),inst_58857,inst_58866,null));
var state_58887__$1 = state_58887;
var statearr_58900_58931 = state_58887__$1;
(statearr_58900_58931[(2)] = inst_58867);

(statearr_58900_58931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (11))){
var inst_58857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58858 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_58887__$1 = (function (){var statearr_58902 = state_58887;
(statearr_58902[(10)] = inst_58857);

return statearr_58902;
})();
if(inst_58858){
var statearr_58903_58932 = state_58887__$1;
(statearr_58903_58932[(1)] = (17));

} else {
var statearr_58904_58933 = state_58887__$1;
(statearr_58904_58933[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (9))){
var inst_58839 = (state_58887[(2)]);
var inst_58840 = fluree.db.util.async.throw_err.call(null,inst_58839);
var state_58887__$1 = state_58887;
var statearr_58905_58934 = state_58887__$1;
(statearr_58905_58934[(2)] = inst_58840);

(statearr_58905_58934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (5))){
var _ = (function (){var statearr_58906 = state_58887;
(statearr_58906[(4)] = cljs.core.rest.call(null,(state_58887[(4)])));

return statearr_58906;
})();
var state_58887__$1 = state_58887;
var ex58901 = (state_58887__$1[(2)]);
var statearr_58907_58935 = state_58887__$1;
(statearr_58907_58935[(5)] = ex58901);


if((ex58901 instanceof Error)){
var statearr_58908_58936 = state_58887__$1;
(statearr_58908_58936[(1)] = (4));

(statearr_58908_58936[(5)] = null);

} else {
throw ex58901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (14))){
var state_58887__$1 = state_58887;
var statearr_58909_58937 = state_58887__$1;
(statearr_58909_58937[(2)] = t);

(statearr_58909_58937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (16))){
var inst_58849 = (state_58887[(2)]);
var inst_58850 = fluree.db.util.async.throw_err.call(null,inst_58849);
var state_58887__$1 = state_58887;
var statearr_58910_58938 = state_58887__$1;
(statearr_58910_58938[(2)] = inst_58850);

(statearr_58910_58938[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (10))){
var inst_58845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58846 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_58887__$1 = (function (){var statearr_58911 = state_58887;
(statearr_58911[(7)] = inst_58845);

return statearr_58911;
})();
if(inst_58846){
var statearr_58912_58939 = state_58887__$1;
(statearr_58912_58939[(1)] = (13));

} else {
var statearr_58913_58940 = state_58887__$1;
(statearr_58913_58940[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (18))){
var state_58887__$1 = state_58887;
var statearr_58914_58941 = state_58887__$1;
(statearr_58914_58941[(2)] = f);

(statearr_58914_58941[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58888 === (8))){
var inst_58843 = (state_58887[(8)]);
var inst_58843__$1 = (state_58887[(2)]);
var state_58887__$1 = (function (){var statearr_58915 = state_58887;
(statearr_58915[(8)] = inst_58843__$1);

return statearr_58915;
})();
if(cljs.core.truth_(inst_58843__$1)){
var statearr_58916_58942 = state_58887__$1;
(statearr_58916_58942[(1)] = (10));

} else {
var statearr_58917_58943 = state_58887__$1;
(statearr_58917_58943[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____0 = (function (){
var statearr_58918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58918[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__);

(statearr_58918[(1)] = (1));

return statearr_58918;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____1 = (function (state_58887){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_58887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e58919){var ex__2457__auto__ = e58919;
var statearr_58920_58944 = state_58887;
(statearr_58920_58944[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_58887[(4)]))){
var statearr_58921_58945 = state_58887;
(statearr_58921_58945[(1)] = cljs.core.first.call(null,(state_58887[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58946 = state_58887;
state_58887 = G__58946;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__ = function(state_58887){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____1.call(this,state_58887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_58922 = f__2477__auto__.call(null);
(statearr_58922[(6)] = c__2476__auto__);

return statearr_58922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_58976){
var state_val_58977 = (state_58976[(1)]);
if((state_val_58977 === (7))){
var state_58976__$1 = state_58976;
var statearr_58978_58997 = state_58976__$1;
(statearr_58978_58997[(2)] = arg);

(statearr_58978_58997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (1))){
var state_58976__$1 = state_58976;
var statearr_58979_58998 = state_58976__$1;
(statearr_58979_58998[(2)] = null);

(statearr_58979_58998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (4))){
var inst_58947 = (state_58976[(2)]);
var state_58976__$1 = state_58976;
var statearr_58980_58999 = state_58976__$1;
(statearr_58980_58999[(2)] = inst_58947);

(statearr_58980_58999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (6))){
var state_58976__$1 = state_58976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58976__$1,(9),arg);
} else {
if((state_val_58977 === (3))){
var inst_58974 = (state_58976[(2)]);
var state_58976__$1 = state_58976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58976__$1,inst_58974);
} else {
if((state_val_58977 === (2))){
var _ = (function (){var statearr_58982 = state_58976;
(statearr_58982[(4)] = cljs.core.cons.call(null,(5),(state_58976[(4)])));

return statearr_58982;
})();
var inst_58953 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_58976__$1 = state_58976;
if(inst_58953){
var statearr_58983_59000 = state_58976__$1;
(statearr_58983_59000[(1)] = (6));

} else {
var statearr_58984_59001 = state_58976__$1;
(statearr_58984_59001[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (9))){
var inst_58956 = (state_58976[(2)]);
var inst_58957 = fluree.db.util.async.throw_err.call(null,inst_58956);
var state_58976__$1 = state_58976;
var statearr_58985_59002 = state_58976__$1;
(statearr_58985_59002[(2)] = inst_58957);

(statearr_58985_59002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (5))){
var _ = (function (){var statearr_58986 = state_58976;
(statearr_58986[(4)] = cljs.core.rest.call(null,(state_58976[(4)])));

return statearr_58986;
})();
var state_58976__$1 = state_58976;
var ex58981 = (state_58976__$1[(2)]);
var statearr_58987_59003 = state_58976__$1;
(statearr_58987_59003[(5)] = ex58981);


if((ex58981 instanceof Error)){
var statearr_58988_59004 = state_58976__$1;
(statearr_58988_59004[(1)] = (4));

(statearr_58988_59004[(5)] = null);

} else {
throw ex58981;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58977 === (8))){
var inst_58960 = (state_58976[(2)]);
var inst_58961 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_58960);
var inst_58962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58963 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58965 = [inst_58960];
var inst_58966 = (new cljs.core.PersistentVector(null,1,(5),inst_58964,inst_58965,null));
var inst_58967 = ["nil?",inst_58966,inst_58961];
var inst_58968 = cljs.core.PersistentHashMap.fromArrays(inst_58963,inst_58967);
var inst_58969 = [inst_58968,(10)];
var inst_58970 = (new cljs.core.PersistentVector(null,2,(5),inst_58962,inst_58969,null));
var inst_58971 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_58970);
var _ = (function (){var statearr_58989 = state_58976;
(statearr_58989[(4)] = cljs.core.rest.call(null,(state_58976[(4)])));

return statearr_58989;
})();
var state_58976__$1 = (function (){var statearr_58990 = state_58976;
(statearr_58990[(7)] = inst_58971);

return statearr_58990;
})();
var statearr_58991_59005 = state_58976__$1;
(statearr_58991_59005[(2)] = inst_58961);

(statearr_58991_59005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_58992 = [null,null,null,null,null,null,null,null];
(statearr_58992[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__);

(statearr_58992[(1)] = (1));

return statearr_58992;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____1 = (function (state_58976){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_58976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e58993){var ex__2457__auto__ = e58993;
var statearr_58994_59006 = state_58976;
(statearr_58994_59006[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_58976[(4)]))){
var statearr_58995_59007 = state_58976;
(statearr_58995_59007[(1)] = cljs.core.first.call(null,(state_58976[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59008 = state_58976;
state_58976 = G__59008;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__ = function(state_58976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____1.call(this,state_58976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_58996 = f__2477__auto__.call(null);
(statearr_58996[(6)] = c__2476__auto__);

return statearr_58996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59038){
var state_val_59039 = (state_59038[(1)]);
if((state_val_59039 === (7))){
var state_59038__$1 = state_59038;
var statearr_59040_59059 = state_59038__$1;
(statearr_59040_59059[(2)] = arg);

(statearr_59040_59059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (1))){
var state_59038__$1 = state_59038;
var statearr_59041_59060 = state_59038__$1;
(statearr_59041_59060[(2)] = null);

(statearr_59041_59060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (4))){
var inst_59009 = (state_59038[(2)]);
var state_59038__$1 = state_59038;
var statearr_59042_59061 = state_59038__$1;
(statearr_59042_59061[(2)] = inst_59009);

(statearr_59042_59061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (6))){
var state_59038__$1 = state_59038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59038__$1,(9),arg);
} else {
if((state_val_59039 === (3))){
var inst_59036 = (state_59038[(2)]);
var state_59038__$1 = state_59038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59038__$1,inst_59036);
} else {
if((state_val_59039 === (2))){
var _ = (function (){var statearr_59044 = state_59038;
(statearr_59044[(4)] = cljs.core.cons.call(null,(5),(state_59038[(4)])));

return statearr_59044;
})();
var inst_59015 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_59038__$1 = state_59038;
if(inst_59015){
var statearr_59045_59062 = state_59038__$1;
(statearr_59045_59062[(1)] = (6));

} else {
var statearr_59046_59063 = state_59038__$1;
(statearr_59046_59063[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (9))){
var inst_59018 = (state_59038[(2)]);
var inst_59019 = fluree.db.util.async.throw_err.call(null,inst_59018);
var state_59038__$1 = state_59038;
var statearr_59047_59064 = state_59038__$1;
(statearr_59047_59064[(2)] = inst_59019);

(statearr_59047_59064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (5))){
var _ = (function (){var statearr_59048 = state_59038;
(statearr_59048[(4)] = cljs.core.rest.call(null,(state_59038[(4)])));

return statearr_59048;
})();
var state_59038__$1 = state_59038;
var ex59043 = (state_59038__$1[(2)]);
var statearr_59049_59065 = state_59038__$1;
(statearr_59049_59065[(5)] = ex59043);


if((ex59043 instanceof Error)){
var statearr_59050_59066 = state_59038__$1;
(statearr_59050_59066[(1)] = (4));

(statearr_59050_59066[(5)] = null);

} else {
throw ex59043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59039 === (8))){
var inst_59022 = (state_59038[(2)]);
var inst_59023 = fluree.db.dbfunctions.internal.not.call(null,inst_59022);
var inst_59024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59025 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59027 = [inst_59022];
var inst_59028 = (new cljs.core.PersistentVector(null,1,(5),inst_59026,inst_59027,null));
var inst_59029 = ["not?",inst_59028,inst_59023];
var inst_59030 = cljs.core.PersistentHashMap.fromArrays(inst_59025,inst_59029);
var inst_59031 = [inst_59030,(10)];
var inst_59032 = (new cljs.core.PersistentVector(null,2,(5),inst_59024,inst_59031,null));
var inst_59033 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59032);
var _ = (function (){var statearr_59051 = state_59038;
(statearr_59051[(4)] = cljs.core.rest.call(null,(state_59038[(4)])));

return statearr_59051;
})();
var state_59038__$1 = (function (){var statearr_59052 = state_59038;
(statearr_59052[(7)] = inst_59033);

return statearr_59052;
})();
var statearr_59053_59067 = state_59038__$1;
(statearr_59053_59067[(2)] = inst_59023);

(statearr_59053_59067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____0 = (function (){
var statearr_59054 = [null,null,null,null,null,null,null,null];
(statearr_59054[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__);

(statearr_59054[(1)] = (1));

return statearr_59054;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____1 = (function (state_59038){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59055){var ex__2457__auto__ = e59055;
var statearr_59056_59068 = state_59038;
(statearr_59056_59068[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59038[(4)]))){
var statearr_59057_59069 = state_59038;
(statearr_59057_59069[(1)] = cljs.core.first.call(null,(state_59038[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59070 = state_59038;
state_59038 = G__59070;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__ = function(state_59038){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____1.call(this,state_59038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59058 = f__2477__auto__.call(null);
(statearr_59058[(6)] = c__2476__auto__);

return statearr_59058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59100){
var state_val_59101 = (state_59100[(1)]);
if((state_val_59101 === (7))){
var state_59100__$1 = state_59100;
var statearr_59102_59121 = state_59100__$1;
(statearr_59102_59121[(2)] = arg);

(statearr_59102_59121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (1))){
var state_59100__$1 = state_59100;
var statearr_59103_59122 = state_59100__$1;
(statearr_59103_59122[(2)] = null);

(statearr_59103_59122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (4))){
var inst_59071 = (state_59100[(2)]);
var state_59100__$1 = state_59100;
var statearr_59104_59123 = state_59100__$1;
(statearr_59104_59123[(2)] = inst_59071);

(statearr_59104_59123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (6))){
var state_59100__$1 = state_59100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59100__$1,(9),arg);
} else {
if((state_val_59101 === (3))){
var inst_59098 = (state_59100[(2)]);
var state_59100__$1 = state_59100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59100__$1,inst_59098);
} else {
if((state_val_59101 === (2))){
var _ = (function (){var statearr_59106 = state_59100;
(statearr_59106[(4)] = cljs.core.cons.call(null,(5),(state_59100[(4)])));

return statearr_59106;
})();
var inst_59077 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_59100__$1 = state_59100;
if(inst_59077){
var statearr_59107_59124 = state_59100__$1;
(statearr_59107_59124[(1)] = (6));

} else {
var statearr_59108_59125 = state_59100__$1;
(statearr_59108_59125[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (9))){
var inst_59080 = (state_59100[(2)]);
var inst_59081 = fluree.db.util.async.throw_err.call(null,inst_59080);
var state_59100__$1 = state_59100;
var statearr_59109_59126 = state_59100__$1;
(statearr_59109_59126[(2)] = inst_59081);

(statearr_59109_59126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (5))){
var _ = (function (){var statearr_59110 = state_59100;
(statearr_59110[(4)] = cljs.core.rest.call(null,(state_59100[(4)])));

return statearr_59110;
})();
var state_59100__$1 = state_59100;
var ex59105 = (state_59100__$1[(2)]);
var statearr_59111_59127 = state_59100__$1;
(statearr_59111_59127[(5)] = ex59105);


if((ex59105 instanceof Error)){
var statearr_59112_59128 = state_59100__$1;
(statearr_59112_59128[(1)] = (4));

(statearr_59112_59128[(5)] = null);

} else {
throw ex59105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59101 === (8))){
var inst_59084 = (state_59100[(2)]);
var inst_59085 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_59084);
var inst_59086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59087 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59089 = [inst_59084];
var inst_59090 = (new cljs.core.PersistentVector(null,1,(5),inst_59088,inst_59089,null));
var inst_59091 = ["empty?",inst_59090,inst_59085];
var inst_59092 = cljs.core.PersistentHashMap.fromArrays(inst_59087,inst_59091);
var inst_59093 = [inst_59092,(10)];
var inst_59094 = (new cljs.core.PersistentVector(null,2,(5),inst_59086,inst_59093,null));
var inst_59095 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59094);
var _ = (function (){var statearr_59113 = state_59100;
(statearr_59113[(4)] = cljs.core.rest.call(null,(state_59100[(4)])));

return statearr_59113;
})();
var state_59100__$1 = (function (){var statearr_59114 = state_59100;
(statearr_59114[(7)] = inst_59095);

return statearr_59114;
})();
var statearr_59115_59129 = state_59100__$1;
(statearr_59115_59129[(2)] = inst_59085);

(statearr_59115_59129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_59116 = [null,null,null,null,null,null,null,null];
(statearr_59116[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__);

(statearr_59116[(1)] = (1));

return statearr_59116;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____1 = (function (state_59100){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59117){var ex__2457__auto__ = e59117;
var statearr_59118_59130 = state_59100;
(statearr_59118_59130[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59100[(4)]))){
var statearr_59119_59131 = state_59100;
(statearr_59119_59131[(1)] = cljs.core.first.call(null,(state_59100[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59132 = state_59100;
state_59100 = G__59132;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__ = function(state_59100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____1.call(this,state_59100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59120 = f__2477__auto__.call(null);
(statearr_59120[(6)] = c__2476__auto__);

return statearr_59120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___59177 = arguments.length;
var i__4737__auto___59178 = (0);
while(true){
if((i__4737__auto___59178 < len__4736__auto___59177)){
args__4742__auto__.push((arguments[i__4737__auto___59178]));

var G__59179 = (i__4737__auto___59178 + (1));
i__4737__auto___59178 = G__59179;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59160){
var state_val_59161 = (state_59160[(1)]);
if((state_val_59161 === (1))){
var state_59160__$1 = state_59160;
var statearr_59162_59180 = state_59160__$1;
(statearr_59162_59180[(2)] = null);

(statearr_59162_59180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59161 === (2))){
var _ = (function (){var statearr_59163 = state_59160;
(statearr_59163[(4)] = cljs.core.cons.call(null,(5),(state_59160[(4)])));

return statearr_59163;
})();
var inst_59141 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_59160__$1 = state_59160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59160__$1,(6),inst_59141);
} else {
if((state_val_59161 === (3))){
var inst_59158 = (state_59160[(2)]);
var state_59160__$1 = state_59160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59160__$1,inst_59158);
} else {
if((state_val_59161 === (4))){
var inst_59135 = (state_59160[(2)]);
var state_59160__$1 = state_59160;
var statearr_59165_59181 = state_59160__$1;
(statearr_59165_59181[(2)] = inst_59135);

(statearr_59165_59181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59161 === (5))){
var _ = (function (){var statearr_59166 = state_59160;
(statearr_59166[(4)] = cljs.core.rest.call(null,(state_59160[(4)])));

return statearr_59166;
})();
var state_59160__$1 = state_59160;
var ex59164 = (state_59160__$1[(2)]);
var statearr_59167_59182 = state_59160__$1;
(statearr_59167_59182[(5)] = ex59164);


if((ex59164 instanceof Error)){
var statearr_59168_59183 = state_59160__$1;
(statearr_59168_59183[(1)] = (4));

(statearr_59168_59183[(5)] = null);

} else {
throw ex59164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59161 === (6))){
var inst_59143 = (state_59160[(2)]);
var inst_59144 = fluree.db.util.async.throw_err.call(null,inst_59143);
var inst_59145 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_59144);
var inst_59146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59147 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59149 = [inst_59144];
var inst_59150 = (new cljs.core.PersistentVector(null,1,(5),inst_59148,inst_59149,null));
var inst_59151 = ["str",inst_59150,inst_59145];
var inst_59152 = cljs.core.PersistentHashMap.fromArrays(inst_59147,inst_59151);
var inst_59153 = [inst_59152,(10)];
var inst_59154 = (new cljs.core.PersistentVector(null,2,(5),inst_59146,inst_59153,null));
var inst_59155 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59154);
var _ = (function (){var statearr_59169 = state_59160;
(statearr_59169[(4)] = cljs.core.rest.call(null,(state_59160[(4)])));

return statearr_59169;
})();
var state_59160__$1 = (function (){var statearr_59170 = state_59160;
(statearr_59170[(7)] = inst_59155);

return statearr_59170;
})();
var statearr_59171_59184 = state_59160__$1;
(statearr_59171_59184[(2)] = inst_59145);

(statearr_59171_59184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_59172 = [null,null,null,null,null,null,null,null];
(statearr_59172[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_59172[(1)] = (1));

return statearr_59172;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_59160){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59173){var ex__2457__auto__ = e59173;
var statearr_59174_59185 = state_59160;
(statearr_59174_59185[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59160[(4)]))){
var statearr_59175_59186 = state_59160;
(statearr_59175_59186[(1)] = cljs.core.first.call(null,(state_59160[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59187 = state_59160;
state_59160 = G__59187;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_59160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_59160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59176 = f__2477__auto__.call(null);
(statearr_59176[(6)] = c__2476__auto__);

return statearr_59176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq59133){
var G__59134 = cljs.core.first.call(null,seq59133);
var seq59133__$1 = cljs.core.next.call(null,seq59133);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__59134,seq59133__$1);
}));

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59217){
var state_val_59218 = (state_59217[(1)]);
if((state_val_59218 === (7))){
var state_59217__$1 = state_59217;
var statearr_59219_59238 = state_59217__$1;
(statearr_59219_59238[(2)] = str);

(statearr_59219_59238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (1))){
var state_59217__$1 = state_59217;
var statearr_59220_59239 = state_59217__$1;
(statearr_59220_59239[(2)] = null);

(statearr_59220_59239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (4))){
var inst_59188 = (state_59217[(2)]);
var state_59217__$1 = state_59217;
var statearr_59221_59240 = state_59217__$1;
(statearr_59221_59240[(2)] = inst_59188);

(statearr_59221_59240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (6))){
var state_59217__$1 = state_59217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59217__$1,(9),str);
} else {
if((state_val_59218 === (3))){
var inst_59215 = (state_59217[(2)]);
var state_59217__$1 = state_59217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59217__$1,inst_59215);
} else {
if((state_val_59218 === (2))){
var _ = (function (){var statearr_59223 = state_59217;
(statearr_59223[(4)] = cljs.core.cons.call(null,(5),(state_59217[(4)])));

return statearr_59223;
})();
var inst_59194 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_59217__$1 = state_59217;
if(inst_59194){
var statearr_59224_59241 = state_59217__$1;
(statearr_59224_59241[(1)] = (6));

} else {
var statearr_59225_59242 = state_59217__$1;
(statearr_59225_59242[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (9))){
var inst_59197 = (state_59217[(2)]);
var inst_59198 = fluree.db.util.async.throw_err.call(null,inst_59197);
var state_59217__$1 = state_59217;
var statearr_59226_59243 = state_59217__$1;
(statearr_59226_59243[(2)] = inst_59198);

(statearr_59226_59243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (5))){
var _ = (function (){var statearr_59227 = state_59217;
(statearr_59227[(4)] = cljs.core.rest.call(null,(state_59217[(4)])));

return statearr_59227;
})();
var state_59217__$1 = state_59217;
var ex59222 = (state_59217__$1[(2)]);
var statearr_59228_59244 = state_59217__$1;
(statearr_59228_59244[(5)] = ex59222);


if((ex59222 instanceof Error)){
var statearr_59229_59245 = state_59217__$1;
(statearr_59229_59245[(1)] = (4));

(statearr_59229_59245[(5)] = null);

} else {
throw ex59222;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59218 === (8))){
var inst_59201 = (state_59217[(2)]);
var inst_59202 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_59201);
var inst_59203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59204 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59206 = [inst_59201];
var inst_59207 = (new cljs.core.PersistentVector(null,1,(5),inst_59205,inst_59206,null));
var inst_59208 = ["lower-case",inst_59207,inst_59202];
var inst_59209 = cljs.core.PersistentHashMap.fromArrays(inst_59204,inst_59208);
var inst_59210 = [inst_59209,(10)];
var inst_59211 = (new cljs.core.PersistentVector(null,2,(5),inst_59203,inst_59210,null));
var inst_59212 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59211);
var _ = (function (){var statearr_59230 = state_59217;
(statearr_59230[(4)] = cljs.core.rest.call(null,(state_59217[(4)])));

return statearr_59230;
})();
var state_59217__$1 = (function (){var statearr_59231 = state_59217;
(statearr_59231[(7)] = inst_59212);

return statearr_59231;
})();
var statearr_59232_59246 = state_59217__$1;
(statearr_59232_59246[(2)] = inst_59202);

(statearr_59232_59246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____0 = (function (){
var statearr_59233 = [null,null,null,null,null,null,null,null];
(statearr_59233[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__);

(statearr_59233[(1)] = (1));

return statearr_59233;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____1 = (function (state_59217){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59234){var ex__2457__auto__ = e59234;
var statearr_59235_59247 = state_59217;
(statearr_59235_59247[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59217[(4)]))){
var statearr_59236_59248 = state_59217;
(statearr_59236_59248[(1)] = cljs.core.first.call(null,(state_59217[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59249 = state_59217;
state_59217 = G__59249;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__ = function(state_59217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____1.call(this,state_59217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59237 = f__2477__auto__.call(null);
(statearr_59237[(6)] = c__2476__auto__);

return statearr_59237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59279){
var state_val_59280 = (state_59279[(1)]);
if((state_val_59280 === (7))){
var state_59279__$1 = state_59279;
var statearr_59281_59300 = state_59279__$1;
(statearr_59281_59300[(2)] = str);

(statearr_59281_59300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (1))){
var state_59279__$1 = state_59279;
var statearr_59282_59301 = state_59279__$1;
(statearr_59282_59301[(2)] = null);

(statearr_59282_59301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (4))){
var inst_59250 = (state_59279[(2)]);
var state_59279__$1 = state_59279;
var statearr_59283_59302 = state_59279__$1;
(statearr_59283_59302[(2)] = inst_59250);

(statearr_59283_59302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (6))){
var state_59279__$1 = state_59279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59279__$1,(9),str);
} else {
if((state_val_59280 === (3))){
var inst_59277 = (state_59279[(2)]);
var state_59279__$1 = state_59279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59279__$1,inst_59277);
} else {
if((state_val_59280 === (2))){
var _ = (function (){var statearr_59285 = state_59279;
(statearr_59285[(4)] = cljs.core.cons.call(null,(5),(state_59279[(4)])));

return statearr_59285;
})();
var inst_59256 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_59279__$1 = state_59279;
if(inst_59256){
var statearr_59286_59303 = state_59279__$1;
(statearr_59286_59303[(1)] = (6));

} else {
var statearr_59287_59304 = state_59279__$1;
(statearr_59287_59304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (9))){
var inst_59259 = (state_59279[(2)]);
var inst_59260 = fluree.db.util.async.throw_err.call(null,inst_59259);
var state_59279__$1 = state_59279;
var statearr_59288_59305 = state_59279__$1;
(statearr_59288_59305[(2)] = inst_59260);

(statearr_59288_59305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (5))){
var _ = (function (){var statearr_59289 = state_59279;
(statearr_59289[(4)] = cljs.core.rest.call(null,(state_59279[(4)])));

return statearr_59289;
})();
var state_59279__$1 = state_59279;
var ex59284 = (state_59279__$1[(2)]);
var statearr_59290_59306 = state_59279__$1;
(statearr_59290_59306[(5)] = ex59284);


if((ex59284 instanceof Error)){
var statearr_59291_59307 = state_59279__$1;
(statearr_59291_59307[(1)] = (4));

(statearr_59291_59307[(5)] = null);

} else {
throw ex59284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59280 === (8))){
var inst_59263 = (state_59279[(2)]);
var inst_59264 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_59263);
var inst_59265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59266 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59268 = [inst_59263];
var inst_59269 = (new cljs.core.PersistentVector(null,1,(5),inst_59267,inst_59268,null));
var inst_59270 = ["upper-case",inst_59269,inst_59264];
var inst_59271 = cljs.core.PersistentHashMap.fromArrays(inst_59266,inst_59270);
var inst_59272 = [inst_59271,(10)];
var inst_59273 = (new cljs.core.PersistentVector(null,2,(5),inst_59265,inst_59272,null));
var inst_59274 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59273);
var _ = (function (){var statearr_59292 = state_59279;
(statearr_59292[(4)] = cljs.core.rest.call(null,(state_59279[(4)])));

return statearr_59292;
})();
var state_59279__$1 = (function (){var statearr_59293 = state_59279;
(statearr_59293[(7)] = inst_59274);

return statearr_59293;
})();
var statearr_59294_59308 = state_59279__$1;
(statearr_59294_59308[(2)] = inst_59264);

(statearr_59294_59308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____0 = (function (){
var statearr_59295 = [null,null,null,null,null,null,null,null];
(statearr_59295[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__);

(statearr_59295[(1)] = (1));

return statearr_59295;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____1 = (function (state_59279){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59296){var ex__2457__auto__ = e59296;
var statearr_59297_59309 = state_59279;
(statearr_59297_59309[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59279[(4)]))){
var statearr_59298_59310 = state_59279;
(statearr_59298_59310[(1)] = cljs.core.first.call(null,(state_59279[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59311 = state_59279;
state_59279 = G__59311;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__ = function(state_59279){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____1.call(this,state_59279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59299 = f__2477__auto__.call(null);
(statearr_59299[(6)] = c__2476__auto__);

return statearr_59299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__59313 = arguments.length;
switch (G__59313) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59341){
var state_val_59342 = (state_59341[(1)]);
if((state_val_59342 === (1))){
var state_59341__$1 = state_59341;
var statearr_59343_59359 = state_59341__$1;
(statearr_59343_59359[(2)] = null);

(statearr_59343_59359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59342 === (2))){
var _ = (function (){var statearr_59344 = state_59341;
(statearr_59344[(4)] = cljs.core.cons.call(null,(5),(state_59341[(4)])));

return statearr_59344;
})();
var inst_59323 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_59341__$1 = state_59341;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59341__$1,(6),inst_59323);
} else {
if((state_val_59342 === (3))){
var inst_59339 = (state_59341[(2)]);
var state_59341__$1 = state_59341;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59341__$1,inst_59339);
} else {
if((state_val_59342 === (4))){
var inst_59314 = (state_59341[(2)]);
var state_59341__$1 = state_59341;
var statearr_59346_59360 = state_59341__$1;
(statearr_59346_59360[(2)] = inst_59314);

(statearr_59346_59360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59342 === (5))){
var _ = (function (){var statearr_59347 = state_59341;
(statearr_59347[(4)] = cljs.core.rest.call(null,(state_59341[(4)])));

return statearr_59347;
})();
var state_59341__$1 = state_59341;
var ex59345 = (state_59341__$1[(2)]);
var statearr_59348_59361 = state_59341__$1;
(statearr_59348_59361[(5)] = ex59345);


if((ex59345 instanceof Error)){
var statearr_59349_59362 = state_59341__$1;
(statearr_59349_59362[(1)] = (4));

(statearr_59349_59362[(5)] = null);

} else {
throw ex59345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59342 === (6))){
var inst_59325 = (state_59341[(2)]);
var inst_59326 = fluree.db.util.async.throw_err.call(null,inst_59325);
var inst_59327 = cljs.core.nth.call(null,inst_59326,(0),null);
var inst_59328 = cljs.core.nth.call(null,inst_59326,(1),null);
var inst_59329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59330 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59331 = ["?s","?ctx",inst_59327];
var inst_59332 = cljs.core.PersistentHashMap.fromArrays(inst_59330,inst_59331);
var inst_59333 = ((10) + inst_59328);
var inst_59334 = [inst_59332,inst_59333];
var inst_59335 = (new cljs.core.PersistentVector(null,2,(5),inst_59329,inst_59334,null));
var inst_59336 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59335);
var _ = (function (){var statearr_59350 = state_59341;
(statearr_59350[(4)] = cljs.core.rest.call(null,(state_59341[(4)])));

return statearr_59350;
})();
var state_59341__$1 = (function (){var statearr_59351 = state_59341;
(statearr_59351[(7)] = inst_59336);

return statearr_59351;
})();
var statearr_59352_59363 = state_59341__$1;
(statearr_59352_59363[(2)] = inst_59327);

(statearr_59352_59363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_59353 = [null,null,null,null,null,null,null,null];
(statearr_59353[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_59353[(1)] = (1));

return statearr_59353;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_59341){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59354){var ex__2457__auto__ = e59354;
var statearr_59355_59364 = state_59341;
(statearr_59355_59364[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59341[(4)]))){
var statearr_59356_59365 = state_59341;
(statearr_59356_59365[(1)] = cljs.core.first.call(null,(state_59341[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59366 = state_59341;
state_59341 = G__59366;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_59341){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_59341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59357 = f__2477__auto__.call(null);
(statearr_59357[(6)] = c__2476__auto__);

return statearr_59357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__59368 = arguments.length;
switch (G__59368) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59406){
var state_val_59407 = (state_59406[(1)]);
if((state_val_59407 === (7))){
var inst_59399 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_59406__$1 = state_59406;
var statearr_59408_59428 = state_59406__$1;
(statearr_59408_59428[(2)] = inst_59399);

(statearr_59408_59428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (1))){
var state_59406__$1 = state_59406;
var statearr_59409_59429 = state_59406__$1;
(statearr_59409_59429[(2)] = null);

(statearr_59409_59429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (4))){
var inst_59369 = (state_59406[(2)]);
var state_59406__$1 = state_59406;
var statearr_59410_59430 = state_59406__$1;
(statearr_59410_59430[(2)] = inst_59369);

(statearr_59410_59430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (6))){
var inst_59380 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_59406__$1 = state_59406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59406__$1,(10),inst_59380);
} else {
if((state_val_59407 === (3))){
var inst_59404 = (state_59406[(2)]);
var state_59406__$1 = state_59406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59406__$1,inst_59404);
} else {
if((state_val_59407 === (2))){
var _ = (function (){var statearr_59412 = state_59406;
(statearr_59412[(4)] = cljs.core.cons.call(null,(5),(state_59406[(4)])));

return statearr_59412;
})();
var inst_59375 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_59406__$1 = state_59406;
if(cljs.core.truth_(inst_59375)){
var statearr_59413_59431 = state_59406__$1;
(statearr_59413_59431[(1)] = (6));

} else {
var statearr_59414_59432 = state_59406__$1;
(statearr_59414_59432[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (9))){
var inst_59386 = (state_59406[(2)]);
var inst_59387 = fluree.db.util.async.throw_err.call(null,inst_59386);
var inst_59388 = cljs.core.nth.call(null,inst_59387,(0),null);
var inst_59389 = cljs.core.nth.call(null,inst_59387,(1),null);
var inst_59390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59391 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59392 = ["?p","?ctx",inst_59388];
var inst_59393 = cljs.core.PersistentHashMap.fromArrays(inst_59391,inst_59392);
var inst_59394 = ((10) + inst_59389);
var inst_59395 = [inst_59393,inst_59394];
var inst_59396 = (new cljs.core.PersistentVector(null,2,(5),inst_59390,inst_59395,null));
var inst_59397 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59396);
var state_59406__$1 = (function (){var statearr_59415 = state_59406;
(statearr_59415[(7)] = inst_59397);

return statearr_59415;
})();
var statearr_59416_59433 = state_59406__$1;
(statearr_59416_59433[(2)] = inst_59388);

(statearr_59416_59433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (5))){
var _ = (function (){var statearr_59417 = state_59406;
(statearr_59417[(4)] = cljs.core.rest.call(null,(state_59406[(4)])));

return statearr_59417;
})();
var state_59406__$1 = state_59406;
var ex59411 = (state_59406__$1[(2)]);
var statearr_59418_59434 = state_59406__$1;
(statearr_59418_59434[(5)] = ex59411);


if((ex59411 instanceof Error)){
var statearr_59419_59435 = state_59406__$1;
(statearr_59419_59435[(1)] = (4));

(statearr_59419_59435[(5)] = null);

} else {
throw ex59411;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59407 === (10))){
var inst_59382 = (state_59406[(2)]);
var inst_59383 = fluree.db.util.async.throw_err.call(null,inst_59382);
var inst_59384 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_59383);
var state_59406__$1 = state_59406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59406__$1,(9),inst_59384);
} else {
if((state_val_59407 === (8))){
var inst_59401 = (state_59406[(2)]);
var _ = (function (){var statearr_59420 = state_59406;
(statearr_59420[(4)] = cljs.core.rest.call(null,(state_59406[(4)])));

return statearr_59420;
})();
var state_59406__$1 = state_59406;
var statearr_59421_59436 = state_59406__$1;
(statearr_59421_59436[(2)] = inst_59401);

(statearr_59421_59436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_59422 = [null,null,null,null,null,null,null,null];
(statearr_59422[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_59422[(1)] = (1));

return statearr_59422;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_59406){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59423){var ex__2457__auto__ = e59423;
var statearr_59424_59437 = state_59406;
(statearr_59424_59437[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59406[(4)]))){
var statearr_59425_59438 = state_59406;
(statearr_59425_59438[(1)] = cljs.core.first.call(null,(state_59406[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59439 = state_59406;
state_59406 = G__59439;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_59406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_59406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59426 = f__2477__auto__.call(null);
(statearr_59426[(6)] = c__2476__auto__);

return statearr_59426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___59488 = arguments.length;
var i__4737__auto___59489 = (0);
while(true){
if((i__4737__auto___59489 < len__4736__auto___59488)){
args__4742__auto__.push((arguments[i__4737__auto___59489]));

var G__59490 = (i__4737__auto___59489 + (1));
i__4737__auto___59489 = G__59490;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59471){
var state_val_59472 = (state_59471[(1)]);
if((state_val_59472 === (1))){
var state_59471__$1 = state_59471;
var statearr_59473_59491 = state_59471__$1;
(statearr_59473_59491[(2)] = null);

(statearr_59473_59491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59472 === (2))){
var _ = (function (){var statearr_59474 = state_59471;
(statearr_59474[(4)] = cljs.core.cons.call(null,(5),(state_59471[(4)])));

return statearr_59474;
})();
var inst_59448 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_59471__$1 = state_59471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59471__$1,(6),inst_59448);
} else {
if((state_val_59472 === (3))){
var inst_59469 = (state_59471[(2)]);
var state_59471__$1 = state_59471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59471__$1,inst_59469);
} else {
if((state_val_59472 === (4))){
var inst_59442 = (state_59471[(2)]);
var state_59471__$1 = state_59471;
var statearr_59476_59492 = state_59471__$1;
(statearr_59476_59492[(2)] = inst_59442);

(statearr_59476_59492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59472 === (5))){
var _ = (function (){var statearr_59477 = state_59471;
(statearr_59477[(4)] = cljs.core.rest.call(null,(state_59471[(4)])));

return statearr_59477;
})();
var state_59471__$1 = state_59471;
var ex59475 = (state_59471__$1[(2)]);
var statearr_59478_59493 = state_59471__$1;
(statearr_59478_59493[(5)] = ex59475);


if((ex59475 instanceof Error)){
var statearr_59479_59494 = state_59471__$1;
(statearr_59479_59494[(1)] = (4));

(statearr_59479_59494[(5)] = null);

} else {
throw ex59475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59472 === (6))){
var inst_59450 = (state_59471[(2)]);
var inst_59451 = fluree.db.util.async.throw_err.call(null,inst_59450);
var inst_59452 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_59451);
var inst_59453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59454 = [inst_59451];
var inst_59455 = (new cljs.core.PersistentVector(null,1,(5),inst_59453,inst_59454,null));
var inst_59456 = cljs.core.count.call(null,inst_59455);
var inst_59457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59458 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59460 = [inst_59451];
var inst_59461 = (new cljs.core.PersistentVector(null,1,(5),inst_59459,inst_59460,null));
var inst_59462 = ["and",inst_59461,inst_59452];
var inst_59463 = cljs.core.PersistentHashMap.fromArrays(inst_59458,inst_59462);
var inst_59464 = [inst_59463,inst_59456];
var inst_59465 = (new cljs.core.PersistentVector(null,2,(5),inst_59457,inst_59464,null));
var inst_59466 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59465);
var _ = (function (){var statearr_59480 = state_59471;
(statearr_59480[(4)] = cljs.core.rest.call(null,(state_59471[(4)])));

return statearr_59480;
})();
var state_59471__$1 = (function (){var statearr_59481 = state_59471;
(statearr_59481[(7)] = inst_59466);

return statearr_59481;
})();
var statearr_59482_59495 = state_59471__$1;
(statearr_59482_59495[(2)] = inst_59452);

(statearr_59482_59495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_59483 = [null,null,null,null,null,null,null,null];
(statearr_59483[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_59483[(1)] = (1));

return statearr_59483;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_59471){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59484){var ex__2457__auto__ = e59484;
var statearr_59485_59496 = state_59471;
(statearr_59485_59496[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59471[(4)]))){
var statearr_59486_59497 = state_59471;
(statearr_59486_59497[(1)] = cljs.core.first.call(null,(state_59471[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59498 = state_59471;
state_59471 = G__59498;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_59471){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_59471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59487 = f__2477__auto__.call(null);
(statearr_59487[(6)] = c__2476__auto__);

return statearr_59487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq59440){
var G__59441 = cljs.core.first.call(null,seq59440);
var seq59440__$1 = cljs.core.next.call(null,seq59440);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__59441,seq59440__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___59547 = arguments.length;
var i__4737__auto___59548 = (0);
while(true){
if((i__4737__auto___59548 < len__4736__auto___59547)){
args__4742__auto__.push((arguments[i__4737__auto___59548]));

var G__59549 = (i__4737__auto___59548 + (1));
i__4737__auto___59548 = G__59549;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59530){
var state_val_59531 = (state_59530[(1)]);
if((state_val_59531 === (1))){
var state_59530__$1 = state_59530;
var statearr_59532_59550 = state_59530__$1;
(statearr_59532_59550[(2)] = null);

(statearr_59532_59550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59531 === (2))){
var _ = (function (){var statearr_59533 = state_59530;
(statearr_59533[(4)] = cljs.core.cons.call(null,(5),(state_59530[(4)])));

return statearr_59533;
})();
var inst_59507 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_59530__$1 = state_59530;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59530__$1,(6),inst_59507);
} else {
if((state_val_59531 === (3))){
var inst_59528 = (state_59530[(2)]);
var state_59530__$1 = state_59530;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59530__$1,inst_59528);
} else {
if((state_val_59531 === (4))){
var inst_59501 = (state_59530[(2)]);
var state_59530__$1 = state_59530;
var statearr_59535_59551 = state_59530__$1;
(statearr_59535_59551[(2)] = inst_59501);

(statearr_59535_59551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59531 === (5))){
var _ = (function (){var statearr_59536 = state_59530;
(statearr_59536[(4)] = cljs.core.rest.call(null,(state_59530[(4)])));

return statearr_59536;
})();
var state_59530__$1 = state_59530;
var ex59534 = (state_59530__$1[(2)]);
var statearr_59537_59552 = state_59530__$1;
(statearr_59537_59552[(5)] = ex59534);


if((ex59534 instanceof Error)){
var statearr_59538_59553 = state_59530__$1;
(statearr_59538_59553[(1)] = (4));

(statearr_59538_59553[(5)] = null);

} else {
throw ex59534;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59531 === (6))){
var inst_59509 = (state_59530[(2)]);
var inst_59510 = fluree.db.util.async.throw_err.call(null,inst_59509);
var inst_59511 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_59510);
var inst_59512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59513 = [inst_59510];
var inst_59514 = (new cljs.core.PersistentVector(null,1,(5),inst_59512,inst_59513,null));
var inst_59515 = cljs.core.count.call(null,inst_59514);
var inst_59516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59517 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59519 = [inst_59510];
var inst_59520 = (new cljs.core.PersistentVector(null,1,(5),inst_59518,inst_59519,null));
var inst_59521 = ["or",inst_59520,inst_59511];
var inst_59522 = cljs.core.PersistentHashMap.fromArrays(inst_59517,inst_59521);
var inst_59523 = [inst_59522,inst_59515];
var inst_59524 = (new cljs.core.PersistentVector(null,2,(5),inst_59516,inst_59523,null));
var inst_59525 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59524);
var _ = (function (){var statearr_59539 = state_59530;
(statearr_59539[(4)] = cljs.core.rest.call(null,(state_59530[(4)])));

return statearr_59539;
})();
var state_59530__$1 = (function (){var statearr_59540 = state_59530;
(statearr_59540[(7)] = inst_59525);

return statearr_59540;
})();
var statearr_59541_59554 = state_59530__$1;
(statearr_59541_59554[(2)] = inst_59511);

(statearr_59541_59554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_59542 = [null,null,null,null,null,null,null,null];
(statearr_59542[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_59542[(1)] = (1));

return statearr_59542;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_59530){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59530);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59543){var ex__2457__auto__ = e59543;
var statearr_59544_59555 = state_59530;
(statearr_59544_59555[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59530[(4)]))){
var statearr_59545_59556 = state_59530;
(statearr_59545_59556[(1)] = cljs.core.first.call(null,(state_59530[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59557 = state_59530;
state_59530 = G__59557;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_59530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_59530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59546 = f__2477__auto__.call(null);
(statearr_59546[(6)] = c__2476__auto__);

return statearr_59546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq59499){
var G__59500 = cljs.core.first.call(null,seq59499);
var seq59499__$1 = cljs.core.next.call(null,seq59499);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__59500,seq59499__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59595){
var state_val_59596 = (state_59595[(1)]);
if((state_val_59596 === (7))){
var inst_59571 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_59595__$1 = state_59595;
if(inst_59571){
var statearr_59597_59620 = state_59595__$1;
(statearr_59597_59620[(1)] = (10));

} else {
var statearr_59598_59621 = state_59595__$1;
(statearr_59598_59621[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (1))){
var state_59595__$1 = state_59595;
var statearr_59599_59622 = state_59595__$1;
(statearr_59599_59622[(2)] = null);

(statearr_59599_59622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (4))){
var inst_59558 = (state_59595[(2)]);
var state_59595__$1 = state_59595;
var statearr_59600_59623 = state_59595__$1;
(statearr_59600_59623[(2)] = inst_59558);

(statearr_59600_59623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (13))){
var inst_59574 = (state_59595[(2)]);
var inst_59575 = fluree.db.util.async.throw_err.call(null,inst_59574);
var state_59595__$1 = state_59595;
var statearr_59601_59624 = state_59595__$1;
(statearr_59601_59624[(2)] = inst_59575);

(statearr_59601_59624[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (6))){
var inst_59566 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_59595__$1 = state_59595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59595__$1,(9),inst_59566);
} else {
if((state_val_59596 === (3))){
var inst_59593 = (state_59595[(2)]);
var state_59595__$1 = state_59595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59595__$1,inst_59593);
} else {
if((state_val_59596 === (12))){
var inst_59578 = (state_59595[(2)]);
var state_59595__$1 = state_59595;
var statearr_59602_59625 = state_59595__$1;
(statearr_59602_59625[(2)] = inst_59578);

(statearr_59602_59625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (2))){
var _ = (function (){var statearr_59603 = state_59595;
(statearr_59603[(4)] = cljs.core.cons.call(null,(5),(state_59595[(4)])));

return statearr_59603;
})();
var inst_59564 = cljs.core.vector_QMARK_.call(null,coll);
var state_59595__$1 = state_59595;
if(inst_59564){
var statearr_59604_59626 = state_59595__$1;
(statearr_59604_59626[(1)] = (6));

} else {
var statearr_59605_59627 = state_59595__$1;
(statearr_59605_59627[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (11))){
var state_59595__$1 = state_59595;
var statearr_59607_59628 = state_59595__$1;
(statearr_59607_59628[(2)] = coll);

(statearr_59607_59628[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (9))){
var inst_59568 = (state_59595[(2)]);
var inst_59569 = fluree.db.util.async.throw_err.call(null,inst_59568);
var state_59595__$1 = state_59595;
var statearr_59608_59629 = state_59595__$1;
(statearr_59608_59629[(2)] = inst_59569);

(statearr_59608_59629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (5))){
var _ = (function (){var statearr_59609 = state_59595;
(statearr_59609[(4)] = cljs.core.rest.call(null,(state_59595[(4)])));

return statearr_59609;
})();
var state_59595__$1 = state_59595;
var ex59606 = (state_59595__$1[(2)]);
var statearr_59610_59630 = state_59595__$1;
(statearr_59610_59630[(5)] = ex59606);


if((ex59606 instanceof Error)){
var statearr_59611_59631 = state_59595__$1;
(statearr_59611_59631[(1)] = (4));

(statearr_59611_59631[(5)] = null);

} else {
throw ex59606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59596 === (10))){
var state_59595__$1 = state_59595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59595__$1,(13),coll);
} else {
if((state_val_59596 === (8))){
var inst_59580 = (state_59595[(2)]);
var inst_59581 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_59580);
var inst_59582 = cljs.core.count.call(null,inst_59581);
var inst_59583 = ((9) + inst_59582);
var inst_59584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59585 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59586 = ["count",inst_59580,inst_59582];
var inst_59587 = cljs.core.PersistentHashMap.fromArrays(inst_59585,inst_59586);
var inst_59588 = [inst_59587,inst_59583];
var inst_59589 = (new cljs.core.PersistentVector(null,2,(5),inst_59584,inst_59588,null));
var inst_59590 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59589);
var _ = (function (){var statearr_59612 = state_59595;
(statearr_59612[(4)] = cljs.core.rest.call(null,(state_59595[(4)])));

return statearr_59612;
})();
var state_59595__$1 = (function (){var statearr_59613 = state_59595;
(statearr_59613[(7)] = inst_59590);

return statearr_59613;
})();
var statearr_59614_59632 = state_59595__$1;
(statearr_59614_59632[(2)] = inst_59582);

(statearr_59614_59632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____0 = (function (){
var statearr_59615 = [null,null,null,null,null,null,null,null];
(statearr_59615[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__);

(statearr_59615[(1)] = (1));

return statearr_59615;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____1 = (function (state_59595){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59616){var ex__2457__auto__ = e59616;
var statearr_59617_59633 = state_59595;
(statearr_59617_59633[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59595[(4)]))){
var statearr_59618_59634 = state_59595;
(statearr_59618_59634[(1)] = cljs.core.first.call(null,(state_59595[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59635 = state_59595;
state_59595 = G__59635;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__ = function(state_59595){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____1.call(this,state_59595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59619 = f__2477__auto__.call(null);
(statearr_59619[(6)] = c__2476__auto__);

return statearr_59619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59685){
var state_val_59686 = (state_59685[(1)]);
if((state_val_59686 === (7))){
var state_59685__$1 = state_59685;
var statearr_59687_59720 = state_59685__$1;
(statearr_59687_59720[(2)] = subject);

(statearr_59687_59720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (1))){
var state_59685__$1 = state_59685;
var statearr_59688_59721 = state_59685__$1;
(statearr_59688_59721[(2)] = null);

(statearr_59688_59721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (4))){
var inst_59636 = (state_59685[(2)]);
var state_59685__$1 = state_59685;
var statearr_59689_59722 = state_59685__$1;
(statearr_59689_59722[(2)] = inst_59636);

(statearr_59689_59722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (15))){
var inst_59649 = (state_59685[(7)]);
var state_59685__$1 = state_59685;
var statearr_59690_59723 = state_59685__$1;
(statearr_59690_59723[(2)] = inst_59649);

(statearr_59690_59723[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (13))){
var inst_59653 = (state_59685[(2)]);
var inst_59654 = fluree.db.util.async.throw_err.call(null,inst_59653);
var state_59685__$1 = state_59685;
var statearr_59691_59724 = state_59685__$1;
(statearr_59691_59724[(2)] = inst_59654);

(statearr_59691_59724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (6))){
var state_59685__$1 = state_59685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59685__$1,(9),subject);
} else {
if((state_val_59686 === (17))){
var inst_59649 = (state_59685[(7)]);
var inst_59663 = cljs.core.first.call(null,inst_59649);
var state_59685__$1 = state_59685;
var statearr_59692_59725 = state_59685__$1;
(statearr_59692_59725[(2)] = inst_59663);

(statearr_59692_59725[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (3))){
var inst_59683 = (state_59685[(2)]);
var state_59685__$1 = state_59685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59685__$1,inst_59683);
} else {
if((state_val_59686 === (12))){
var inst_59649 = (state_59685[(7)]);
var inst_59657 = (state_59685[(2)]);
var inst_59658 = cljs.core.vector_QMARK_.call(null,inst_59649);
var state_59685__$1 = (function (){var statearr_59693 = state_59685;
(statearr_59693[(8)] = inst_59657);

return statearr_59693;
})();
if(inst_59658){
var statearr_59694_59726 = state_59685__$1;
(statearr_59694_59726[(1)] = (14));

} else {
var statearr_59695_59727 = state_59685__$1;
(statearr_59695_59727[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (2))){
var _ = (function (){var statearr_59696 = state_59685;
(statearr_59696[(4)] = cljs.core.cons.call(null,(5),(state_59685[(4)])));

return statearr_59696;
})();
var inst_59642 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_59685__$1 = state_59685;
if(inst_59642){
var statearr_59697_59728 = state_59685__$1;
(statearr_59697_59728[(1)] = (6));

} else {
var statearr_59698_59729 = state_59685__$1;
(statearr_59698_59729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (19))){
var inst_59666 = (state_59685[(2)]);
var state_59685__$1 = state_59685;
var statearr_59699_59730 = state_59685__$1;
(statearr_59699_59730[(2)] = inst_59666);

(statearr_59699_59730[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (11))){
var state_59685__$1 = state_59685;
var statearr_59701_59731 = state_59685__$1;
(statearr_59701_59731[(2)] = pred);

(statearr_59701_59731[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (9))){
var inst_59645 = (state_59685[(2)]);
var inst_59646 = fluree.db.util.async.throw_err.call(null,inst_59645);
var state_59685__$1 = state_59685;
var statearr_59702_59732 = state_59685__$1;
(statearr_59702_59732[(2)] = inst_59646);

(statearr_59702_59732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (5))){
var _ = (function (){var statearr_59703 = state_59685;
(statearr_59703[(4)] = cljs.core.rest.call(null,(state_59685[(4)])));

return statearr_59703;
})();
var state_59685__$1 = state_59685;
var ex59700 = (state_59685__$1[(2)]);
var statearr_59704_59733 = state_59685__$1;
(statearr_59704_59733[(5)] = ex59700);


if((ex59700 instanceof Error)){
var statearr_59705_59734 = state_59685__$1;
(statearr_59705_59734[(1)] = (4));

(statearr_59705_59734[(5)] = null);

} else {
throw ex59700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (14))){
var inst_59649 = (state_59685[(7)]);
var inst_59660 = cljs.core.count.call(null,inst_59649);
var inst_59661 = cljs.core._EQ_.call(null,(1),inst_59660);
var state_59685__$1 = state_59685;
if(inst_59661){
var statearr_59706_59735 = state_59685__$1;
(statearr_59706_59735[(1)] = (17));

} else {
var statearr_59707_59736 = state_59685__$1;
(statearr_59707_59736[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (16))){
var inst_59649 = (state_59685[(7)]);
var inst_59657 = (state_59685[(8)]);
var inst_59669 = (state_59685[(2)]);
var inst_59670 = fluree.db.dbfunctions.internal.get.call(null,inst_59669,inst_59657);
var inst_59671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59672 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59674 = [inst_59649,inst_59657];
var inst_59675 = (new cljs.core.PersistentVector(null,2,(5),inst_59673,inst_59674,null));
var inst_59676 = ["get",inst_59675,inst_59670];
var inst_59677 = cljs.core.PersistentHashMap.fromArrays(inst_59672,inst_59676);
var inst_59678 = [inst_59677,(10)];
var inst_59679 = (new cljs.core.PersistentVector(null,2,(5),inst_59671,inst_59678,null));
var inst_59680 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59679);
var _ = (function (){var statearr_59708 = state_59685;
(statearr_59708[(4)] = cljs.core.rest.call(null,(state_59685[(4)])));

return statearr_59708;
})();
var state_59685__$1 = (function (){var statearr_59709 = state_59685;
(statearr_59709[(9)] = inst_59680);

return statearr_59709;
})();
var statearr_59710_59737 = state_59685__$1;
(statearr_59710_59737[(2)] = inst_59670);

(statearr_59710_59737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (10))){
var state_59685__$1 = state_59685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59685__$1,(13),pred);
} else {
if((state_val_59686 === (18))){
var inst_59649 = (state_59685[(7)]);
var state_59685__$1 = state_59685;
var statearr_59711_59738 = state_59685__$1;
(statearr_59711_59738[(2)] = inst_59649);

(statearr_59711_59738[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59686 === (8))){
var inst_59649 = (state_59685[(2)]);
var inst_59650 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_59685__$1 = (function (){var statearr_59712 = state_59685;
(statearr_59712[(7)] = inst_59649);

return statearr_59712;
})();
if(inst_59650){
var statearr_59713_59739 = state_59685__$1;
(statearr_59713_59739[(1)] = (10));

} else {
var statearr_59714_59740 = state_59685__$1;
(statearr_59714_59740[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____0 = (function (){
var statearr_59715 = [null,null,null,null,null,null,null,null,null,null];
(statearr_59715[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__);

(statearr_59715[(1)] = (1));

return statearr_59715;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____1 = (function (state_59685){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59716){var ex__2457__auto__ = e59716;
var statearr_59717_59741 = state_59685;
(statearr_59717_59741[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59685[(4)]))){
var statearr_59718_59742 = state_59685;
(statearr_59718_59742[(1)] = cljs.core.first.call(null,(state_59685[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59743 = state_59685;
state_59685 = G__59743;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__ = function(state_59685){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____1.call(this,state_59685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59719 = f__2477__auto__.call(null);
(statearr_59719[(6)] = c__2476__auto__);

return statearr_59719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59782){
var state_val_59783 = (state_59782[(1)]);
if((state_val_59783 === (7))){
var inst_59750 = (state_59782[(7)]);
var state_59782__$1 = state_59782;
var statearr_59784_59808 = state_59782__$1;
(statearr_59784_59808[(2)] = inst_59750);

(statearr_59784_59808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (1))){
var state_59782__$1 = state_59782;
var statearr_59785_59809 = state_59782__$1;
(statearr_59785_59809[(2)] = null);

(statearr_59785_59809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (4))){
var inst_59744 = (state_59782[(2)]);
var state_59782__$1 = state_59782;
var statearr_59786_59810 = state_59782__$1;
(statearr_59786_59810[(2)] = inst_59744);

(statearr_59786_59810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (6))){
var inst_59752 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_59782__$1 = state_59782;
var statearr_59787_59811 = state_59782__$1;
(statearr_59787_59811[(2)] = inst_59752);

(statearr_59787_59811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (3))){
var inst_59780 = (state_59782[(2)]);
var state_59782__$1 = state_59782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59782__$1,inst_59780);
} else {
if((state_val_59783 === (12))){
var inst_59762 = (state_59782[(2)]);
var inst_59763 = fluree.db.util.async.throw_err.call(null,inst_59762);
var inst_59764 = cljs.core.nth.call(null,inst_59763,(0),null);
var inst_59765 = cljs.core.nth.call(null,inst_59763,(1),null);
var inst_59766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59767 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59768 = ["?pO","?ctx",inst_59764];
var inst_59769 = cljs.core.PersistentHashMap.fromArrays(inst_59767,inst_59768);
var inst_59770 = ((10) + inst_59765);
var inst_59771 = [inst_59769,inst_59770];
var inst_59772 = (new cljs.core.PersistentVector(null,2,(5),inst_59766,inst_59771,null));
var inst_59773 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59772);
var state_59782__$1 = (function (){var statearr_59788 = state_59782;
(statearr_59788[(8)] = inst_59773);

return statearr_59788;
})();
var statearr_59789_59812 = state_59782__$1;
(statearr_59789_59812[(2)] = inst_59764);

(statearr_59789_59812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (2))){
var inst_59750 = (state_59782[(7)]);
var _ = (function (){var statearr_59790 = state_59782;
(statearr_59790[(4)] = cljs.core.cons.call(null,(5),(state_59782[(4)])));

return statearr_59790;
})();
var inst_59750__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_59782__$1 = (function (){var statearr_59791 = state_59782;
(statearr_59791[(7)] = inst_59750__$1);

return statearr_59791;
})();
if(cljs.core.truth_(inst_59750__$1)){
var statearr_59792_59813 = state_59782__$1;
(statearr_59792_59813[(1)] = (6));

} else {
var statearr_59793_59814 = state_59782__$1;
(statearr_59793_59814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (11))){
var inst_59777 = (state_59782[(2)]);
var _ = (function (){var statearr_59795 = state_59782;
(statearr_59795[(4)] = cljs.core.rest.call(null,(state_59782[(4)])));

return statearr_59795;
})();
var state_59782__$1 = state_59782;
var statearr_59796_59815 = state_59782__$1;
(statearr_59796_59815[(2)] = inst_59777);

(statearr_59796_59815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (9))){
var inst_59760 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_59782__$1 = state_59782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59782__$1,(12),inst_59760);
} else {
if((state_val_59783 === (5))){
var _ = (function (){var statearr_59797 = state_59782;
(statearr_59797[(4)] = cljs.core.rest.call(null,(state_59782[(4)])));

return statearr_59797;
})();
var state_59782__$1 = state_59782;
var ex59794 = (state_59782__$1[(2)]);
var statearr_59798_59816 = state_59782__$1;
(statearr_59798_59816[(5)] = ex59794);


if((ex59794 instanceof Error)){
var statearr_59799_59817 = state_59782__$1;
(statearr_59799_59817[(1)] = (4));

(statearr_59799_59817[(5)] = null);

} else {
throw ex59794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (10))){
var inst_59775 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_59782__$1 = state_59782;
var statearr_59800_59818 = state_59782__$1;
(statearr_59800_59818[(2)] = inst_59775);

(statearr_59800_59818[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59783 === (8))){
var inst_59755 = (state_59782[(2)]);
var state_59782__$1 = state_59782;
if(cljs.core.truth_(inst_59755)){
var statearr_59801_59819 = state_59782__$1;
(statearr_59801_59819[(1)] = (9));

} else {
var statearr_59802_59820 = state_59782__$1;
(statearr_59802_59820[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____0 = (function (){
var statearr_59803 = [null,null,null,null,null,null,null,null,null];
(statearr_59803[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__);

(statearr_59803[(1)] = (1));

return statearr_59803;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____1 = (function (state_59782){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59804){var ex__2457__auto__ = e59804;
var statearr_59805_59821 = state_59782;
(statearr_59805_59821[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59782[(4)]))){
var statearr_59806_59822 = state_59782;
(statearr_59806_59822[(1)] = cljs.core.first.call(null,(state_59782[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59823 = state_59782;
state_59782 = G__59823;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__ = function(state_59782){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____1.call(this,state_59782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59807 = f__2477__auto__.call(null);
(statearr_59807[(6)] = c__2476__auto__);

return statearr_59807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59875){
var state_val_59876 = (state_59875[(1)]);
if((state_val_59876 === (7))){
var state_59875__$1 = state_59875;
var statearr_59877_59910 = state_59875__$1;
(statearr_59877_59910[(2)] = subject);

(statearr_59877_59910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (1))){
var state_59875__$1 = state_59875;
var statearr_59878_59911 = state_59875__$1;
(statearr_59878_59911[(2)] = null);

(statearr_59878_59911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (4))){
var inst_59824 = (state_59875[(2)]);
var state_59875__$1 = state_59875;
var statearr_59879_59912 = state_59875__$1;
(statearr_59879_59912[(2)] = inst_59824);

(statearr_59879_59912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (15))){
var inst_59837 = (state_59875[(7)]);
var state_59875__$1 = state_59875;
var statearr_59880_59913 = state_59875__$1;
(statearr_59880_59913[(2)] = inst_59837);

(statearr_59880_59913[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (13))){
var inst_59841 = (state_59875[(2)]);
var inst_59842 = fluree.db.util.async.throw_err.call(null,inst_59841);
var state_59875__$1 = state_59875;
var statearr_59881_59914 = state_59875__$1;
(statearr_59881_59914[(2)] = inst_59842);

(statearr_59881_59914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (6))){
var state_59875__$1 = state_59875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59875__$1,(9),subject);
} else {
if((state_val_59876 === (17))){
var inst_59837 = (state_59875[(7)]);
var inst_59851 = cljs.core.first.call(null,inst_59837);
var state_59875__$1 = state_59875;
var statearr_59882_59915 = state_59875__$1;
(statearr_59882_59915[(2)] = inst_59851);

(statearr_59882_59915[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (3))){
var inst_59873 = (state_59875[(2)]);
var state_59875__$1 = state_59875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59875__$1,inst_59873);
} else {
if((state_val_59876 === (12))){
var inst_59837 = (state_59875[(7)]);
var inst_59845 = (state_59875[(2)]);
var inst_59846 = cljs.core.vector_QMARK_.call(null,inst_59837);
var state_59875__$1 = (function (){var statearr_59883 = state_59875;
(statearr_59883[(8)] = inst_59845);

return statearr_59883;
})();
if(inst_59846){
var statearr_59884_59916 = state_59875__$1;
(statearr_59884_59916[(1)] = (14));

} else {
var statearr_59885_59917 = state_59875__$1;
(statearr_59885_59917[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (2))){
var _ = (function (){var statearr_59886 = state_59875;
(statearr_59886[(4)] = cljs.core.cons.call(null,(5),(state_59875[(4)])));

return statearr_59886;
})();
var inst_59830 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_59875__$1 = state_59875;
if(inst_59830){
var statearr_59887_59918 = state_59875__$1;
(statearr_59887_59918[(1)] = (6));

} else {
var statearr_59888_59919 = state_59875__$1;
(statearr_59888_59919[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (19))){
var inst_59854 = (state_59875[(2)]);
var state_59875__$1 = state_59875;
var statearr_59889_59920 = state_59875__$1;
(statearr_59889_59920[(2)] = inst_59854);

(statearr_59889_59920[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (11))){
var state_59875__$1 = state_59875;
var statearr_59891_59921 = state_59875__$1;
(statearr_59891_59921[(2)] = path);

(statearr_59891_59921[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (9))){
var inst_59833 = (state_59875[(2)]);
var inst_59834 = fluree.db.util.async.throw_err.call(null,inst_59833);
var state_59875__$1 = state_59875;
var statearr_59892_59922 = state_59875__$1;
(statearr_59892_59922[(2)] = inst_59834);

(statearr_59892_59922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (5))){
var _ = (function (){var statearr_59893 = state_59875;
(statearr_59893[(4)] = cljs.core.rest.call(null,(state_59875[(4)])));

return statearr_59893;
})();
var state_59875__$1 = state_59875;
var ex59890 = (state_59875__$1[(2)]);
var statearr_59894_59923 = state_59875__$1;
(statearr_59894_59923[(5)] = ex59890);


if((ex59890 instanceof Error)){
var statearr_59895_59924 = state_59875__$1;
(statearr_59895_59924[(1)] = (4));

(statearr_59895_59924[(5)] = null);

} else {
throw ex59890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (14))){
var inst_59837 = (state_59875[(7)]);
var inst_59848 = cljs.core.count.call(null,inst_59837);
var inst_59849 = cljs.core._EQ_.call(null,(1),inst_59848);
var state_59875__$1 = state_59875;
if(inst_59849){
var statearr_59896_59925 = state_59875__$1;
(statearr_59896_59925[(1)] = (17));

} else {
var statearr_59897_59926 = state_59875__$1;
(statearr_59897_59926[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (16))){
var inst_59837 = (state_59875[(7)]);
var inst_59845 = (state_59875[(8)]);
var inst_59857 = (state_59875[(2)]);
var inst_59858 = fluree.db.dbfunctions.internal.get_all.call(null,inst_59857,inst_59845);
var inst_59859 = cljs.core.count.call(null,inst_59845);
var inst_59860 = ((9) + inst_59859);
var inst_59861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59862 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59864 = [inst_59837,inst_59845];
var inst_59865 = (new cljs.core.PersistentVector(null,2,(5),inst_59863,inst_59864,null));
var inst_59866 = ["get-all",inst_59865,inst_59858];
var inst_59867 = cljs.core.PersistentHashMap.fromArrays(inst_59862,inst_59866);
var inst_59868 = [inst_59867,inst_59860];
var inst_59869 = (new cljs.core.PersistentVector(null,2,(5),inst_59861,inst_59868,null));
var inst_59870 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59869);
var _ = (function (){var statearr_59898 = state_59875;
(statearr_59898[(4)] = cljs.core.rest.call(null,(state_59875[(4)])));

return statearr_59898;
})();
var state_59875__$1 = (function (){var statearr_59899 = state_59875;
(statearr_59899[(9)] = inst_59870);

return statearr_59899;
})();
var statearr_59900_59927 = state_59875__$1;
(statearr_59900_59927[(2)] = inst_59858);

(statearr_59900_59927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (10))){
var state_59875__$1 = state_59875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59875__$1,(13),path);
} else {
if((state_val_59876 === (18))){
var inst_59837 = (state_59875[(7)]);
var state_59875__$1 = state_59875;
var statearr_59901_59928 = state_59875__$1;
(statearr_59901_59928[(2)] = inst_59837);

(statearr_59901_59928[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59876 === (8))){
var inst_59837 = (state_59875[(2)]);
var inst_59838 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_59875__$1 = (function (){var statearr_59902 = state_59875;
(statearr_59902[(7)] = inst_59837);

return statearr_59902;
})();
if(inst_59838){
var statearr_59903_59929 = state_59875__$1;
(statearr_59903_59929[(1)] = (10));

} else {
var statearr_59904_59930 = state_59875__$1;
(statearr_59904_59930[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____0 = (function (){
var statearr_59905 = [null,null,null,null,null,null,null,null,null,null];
(statearr_59905[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__);

(statearr_59905[(1)] = (1));

return statearr_59905;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____1 = (function (state_59875){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59906){var ex__2457__auto__ = e59906;
var statearr_59907_59931 = state_59875;
(statearr_59907_59931[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59875[(4)]))){
var statearr_59908_59932 = state_59875;
(statearr_59908_59932[(1)] = cljs.core.first.call(null,(state_59875[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59933 = state_59875;
state_59875 = G__59933;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__ = function(state_59875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____1.call(this,state_59875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59909 = f__2477__auto__.call(null);
(statearr_59909[(6)] = c__2476__auto__);

return statearr_59909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_59972){
var state_val_59973 = (state_59972[(1)]);
if((state_val_59973 === (7))){
var state_59972__$1 = state_59972;
var statearr_59974_59998 = state_59972__$1;
(statearr_59974_59998[(2)] = subject);

(statearr_59974_59998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (1))){
var state_59972__$1 = state_59972;
var statearr_59975_59999 = state_59972__$1;
(statearr_59975_59999[(2)] = null);

(statearr_59975_59999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (4))){
var inst_59934 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_59976_60000 = state_59972__$1;
(statearr_59976_60000[(2)] = inst_59934);

(statearr_59976_60000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (13))){
var inst_59951 = (state_59972[(2)]);
var inst_59952 = fluree.db.util.async.throw_err.call(null,inst_59951);
var state_59972__$1 = state_59972;
var statearr_59977_60001 = state_59972__$1;
(statearr_59977_60001[(2)] = inst_59952);

(statearr_59977_60001[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (6))){
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59972__$1,(9),subject);
} else {
if((state_val_59973 === (3))){
var inst_59970 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59972__$1,inst_59970);
} else {
if((state_val_59973 === (12))){
var inst_59947 = (state_59972[(7)]);
var inst_59955 = (state_59972[(2)]);
var inst_59956 = fluree.db.dbfunctions.internal.get_in.call(null,inst_59947,inst_59955);
var inst_59957 = cljs.core.count.call(null,inst_59955);
var inst_59958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_59960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59961 = [inst_59947,inst_59955];
var inst_59962 = (new cljs.core.PersistentVector(null,2,(5),inst_59960,inst_59961,null));
var inst_59963 = ["get-in",inst_59962,inst_59956];
var inst_59964 = cljs.core.PersistentHashMap.fromArrays(inst_59959,inst_59963);
var inst_59965 = [inst_59964,inst_59957];
var inst_59966 = (new cljs.core.PersistentVector(null,2,(5),inst_59958,inst_59965,null));
var inst_59967 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_59966);
var _ = (function (){var statearr_59978 = state_59972;
(statearr_59978[(4)] = cljs.core.rest.call(null,(state_59972[(4)])));

return statearr_59978;
})();
var state_59972__$1 = (function (){var statearr_59979 = state_59972;
(statearr_59979[(8)] = inst_59967);

return statearr_59979;
})();
var statearr_59980_60002 = state_59972__$1;
(statearr_59980_60002[(2)] = inst_59956);

(statearr_59980_60002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (2))){
var _ = (function (){var statearr_59981 = state_59972;
(statearr_59981[(4)] = cljs.core.cons.call(null,(5),(state_59972[(4)])));

return statearr_59981;
})();
var inst_59940 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_59972__$1 = state_59972;
if(inst_59940){
var statearr_59982_60003 = state_59972__$1;
(statearr_59982_60003[(1)] = (6));

} else {
var statearr_59983_60004 = state_59972__$1;
(statearr_59983_60004[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (11))){
var state_59972__$1 = state_59972;
var statearr_59985_60005 = state_59972__$1;
(statearr_59985_60005[(2)] = path);

(statearr_59985_60005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (9))){
var inst_59943 = (state_59972[(2)]);
var inst_59944 = fluree.db.util.async.throw_err.call(null,inst_59943);
var state_59972__$1 = state_59972;
var statearr_59986_60006 = state_59972__$1;
(statearr_59986_60006[(2)] = inst_59944);

(statearr_59986_60006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (5))){
var _ = (function (){var statearr_59987 = state_59972;
(statearr_59987[(4)] = cljs.core.rest.call(null,(state_59972[(4)])));

return statearr_59987;
})();
var state_59972__$1 = state_59972;
var ex59984 = (state_59972__$1[(2)]);
var statearr_59988_60007 = state_59972__$1;
(statearr_59988_60007[(5)] = ex59984);


if((ex59984 instanceof Error)){
var statearr_59989_60008 = state_59972__$1;
(statearr_59989_60008[(1)] = (4));

(statearr_59989_60008[(5)] = null);

} else {
throw ex59984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (10))){
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59972__$1,(13),path);
} else {
if((state_val_59973 === (8))){
var inst_59947 = (state_59972[(2)]);
var inst_59948 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_59972__$1 = (function (){var statearr_59990 = state_59972;
(statearr_59990[(7)] = inst_59947);

return statearr_59990;
})();
if(inst_59948){
var statearr_59991_60009 = state_59972__$1;
(statearr_59991_60009[(1)] = (10));

} else {
var statearr_59992_60010 = state_59972__$1;
(statearr_59992_60010[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____0 = (function (){
var statearr_59993 = [null,null,null,null,null,null,null,null,null];
(statearr_59993[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__);

(statearr_59993[(1)] = (1));

return statearr_59993;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____1 = (function (state_59972){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_59972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e59994){var ex__2457__auto__ = e59994;
var statearr_59995_60011 = state_59972;
(statearr_59995_60011[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_59972[(4)]))){
var statearr_59996_60012 = state_59972;
(statearr_59996_60012[(1)] = cljs.core.first.call(null,(state_59972[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60013 = state_59972;
state_59972 = G__60013;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__ = function(state_59972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____1.call(this,state_59972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_59997 = f__2477__auto__.call(null);
(statearr_59997[(6)] = c__2476__auto__);

return statearr_59997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60058){
var state_val_60059 = (state_60058[(1)]);
if((state_val_60059 === (7))){
var state_60058__$1 = state_60058;
var statearr_60060_60089 = state_60058__$1;
(statearr_60060_60089[(2)] = coll);

(statearr_60060_60089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (1))){
var state_60058__$1 = state_60058;
var statearr_60061_60090 = state_60058__$1;
(statearr_60061_60090[(2)] = null);

(statearr_60061_60090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (4))){
var inst_60014 = (state_60058[(2)]);
var state_60058__$1 = state_60058;
var statearr_60062_60091 = state_60058__$1;
(statearr_60062_60091[(2)] = inst_60014);

(statearr_60062_60091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (15))){
var inst_60034 = (state_60058[(7)]);
var inst_60042 = (state_60058[(2)]);
var inst_60043 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_60034,inst_60042);
var inst_60044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60045 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60047 = [inst_60034,inst_60042];
var inst_60048 = (new cljs.core.PersistentVector(null,2,(5),inst_60046,inst_60047,null));
var inst_60049 = ["contains?",inst_60048,inst_60043];
var inst_60050 = cljs.core.PersistentHashMap.fromArrays(inst_60045,inst_60049);
var inst_60051 = [inst_60050,(10)];
var inst_60052 = (new cljs.core.PersistentVector(null,2,(5),inst_60044,inst_60051,null));
var inst_60053 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60052);
var _ = (function (){var statearr_60063 = state_60058;
(statearr_60063[(4)] = cljs.core.rest.call(null,(state_60058[(4)])));

return statearr_60063;
})();
var state_60058__$1 = (function (){var statearr_60064 = state_60058;
(statearr_60064[(8)] = inst_60053);

return statearr_60064;
})();
var statearr_60065_60092 = state_60058__$1;
(statearr_60065_60092[(2)] = inst_60043);

(statearr_60065_60092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (13))){
var state_60058__$1 = state_60058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60058__$1,(16),key);
} else {
if((state_val_60059 === (6))){
var state_60058__$1 = state_60058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60058__$1,(9),coll);
} else {
if((state_val_60059 === (3))){
var inst_60056 = (state_60058[(2)]);
var state_60058__$1 = state_60058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60058__$1,inst_60056);
} else {
if((state_val_60059 === (12))){
var inst_60034 = (state_60058[(2)]);
var inst_60035 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_60058__$1 = (function (){var statearr_60066 = state_60058;
(statearr_60066[(7)] = inst_60034);

return statearr_60066;
})();
if(inst_60035){
var statearr_60067_60093 = state_60058__$1;
(statearr_60067_60093[(1)] = (13));

} else {
var statearr_60068_60094 = state_60058__$1;
(statearr_60068_60094[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (2))){
var _ = (function (){var statearr_60069 = state_60058;
(statearr_60069[(4)] = cljs.core.cons.call(null,(5),(state_60058[(4)])));

return statearr_60069;
})();
var inst_60020 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_60058__$1 = state_60058;
if(inst_60020){
var statearr_60070_60095 = state_60058__$1;
(statearr_60070_60095[(1)] = (6));

} else {
var statearr_60071_60096 = state_60058__$1;
(statearr_60071_60096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (11))){
var inst_60027 = (state_60058[(9)]);
var inst_60031 = cljs.core.flatten.call(null,inst_60027);
var inst_60032 = cljs.core.set.call(null,inst_60031);
var state_60058__$1 = state_60058;
var statearr_60073_60097 = state_60058__$1;
(statearr_60073_60097[(2)] = inst_60032);

(statearr_60073_60097[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (9))){
var inst_60023 = (state_60058[(2)]);
var inst_60024 = fluree.db.util.async.throw_err.call(null,inst_60023);
var state_60058__$1 = state_60058;
var statearr_60074_60098 = state_60058__$1;
(statearr_60074_60098[(2)] = inst_60024);

(statearr_60074_60098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (5))){
var _ = (function (){var statearr_60075 = state_60058;
(statearr_60075[(4)] = cljs.core.rest.call(null,(state_60058[(4)])));

return statearr_60075;
})();
var state_60058__$1 = state_60058;
var ex60072 = (state_60058__$1[(2)]);
var statearr_60076_60099 = state_60058__$1;
(statearr_60076_60099[(5)] = ex60072);


if((ex60072 instanceof Error)){
var statearr_60077_60100 = state_60058__$1;
(statearr_60077_60100[(1)] = (4));

(statearr_60077_60100[(5)] = null);

} else {
throw ex60072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (14))){
var state_60058__$1 = state_60058;
var statearr_60078_60101 = state_60058__$1;
(statearr_60078_60101[(2)] = key);

(statearr_60078_60101[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (16))){
var inst_60038 = (state_60058[(2)]);
var inst_60039 = fluree.db.util.async.throw_err.call(null,inst_60038);
var state_60058__$1 = state_60058;
var statearr_60079_60102 = state_60058__$1;
(statearr_60079_60102[(2)] = inst_60039);

(statearr_60079_60102[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (10))){
var inst_60027 = (state_60058[(9)]);
var state_60058__$1 = state_60058;
var statearr_60080_60103 = state_60058__$1;
(statearr_60080_60103[(2)] = inst_60027);

(statearr_60080_60103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60059 === (8))){
var inst_60027 = (state_60058[(9)]);
var inst_60027__$1 = (state_60058[(2)]);
var inst_60028 = cljs.core.set_QMARK_.call(null,inst_60027__$1);
var state_60058__$1 = (function (){var statearr_60081 = state_60058;
(statearr_60081[(9)] = inst_60027__$1);

return statearr_60081;
})();
if(inst_60028){
var statearr_60082_60104 = state_60058__$1;
(statearr_60082_60104[(1)] = (10));

} else {
var statearr_60083_60105 = state_60058__$1;
(statearr_60083_60105[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_60084 = [null,null,null,null,null,null,null,null,null,null];
(statearr_60084[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__);

(statearr_60084[(1)] = (1));

return statearr_60084;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____1 = (function (state_60058){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60085){var ex__2457__auto__ = e60085;
var statearr_60086_60106 = state_60058;
(statearr_60086_60106[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60058[(4)]))){
var statearr_60087_60107 = state_60058;
(statearr_60087_60107[(1)] = cljs.core.first.call(null,(state_60058[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60108 = state_60058;
state_60058 = G__60108;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__ = function(state_60058){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____1.call(this,state_60058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60088 = f__2477__auto__.call(null);
(statearr_60088[(6)] = c__2476__auto__);

return statearr_60088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60173 = arguments.length;
var i__4737__auto___60174 = (0);
while(true){
if((i__4737__auto___60174 < len__4736__auto___60173)){
args__4742__auto__.push((arguments[i__4737__auto___60174]));

var G__60175 = (i__4737__auto___60174 + (1));
i__4737__auto___60174 = G__60175;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60151){
var state_val_60152 = (state_60151[(1)]);
if((state_val_60152 === (7))){
var inst_60120 = (state_60151[(7)]);
var inst_60127 = cljs.core.first.call(null,inst_60120);
var state_60151__$1 = state_60151;
var statearr_60153_60176 = state_60151__$1;
(statearr_60153_60176[(2)] = inst_60127);

(statearr_60153_60176[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (1))){
var state_60151__$1 = state_60151;
var statearr_60154_60177 = state_60151__$1;
(statearr_60154_60177[(2)] = null);

(statearr_60154_60177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (4))){
var inst_60111 = (state_60151[(2)]);
var state_60151__$1 = state_60151;
var statearr_60155_60178 = state_60151__$1;
(statearr_60155_60178[(2)] = inst_60111);

(statearr_60155_60178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (6))){
var inst_60120 = (state_60151[(7)]);
var inst_60119 = (state_60151[(2)]);
var inst_60120__$1 = fluree.db.util.async.throw_err.call(null,inst_60119);
var inst_60121 = cljs.core.count.call(null,inst_60120__$1);
var inst_60122 = cljs.core._EQ_.call(null,(1),inst_60121);
var inst_60123 = cljs.core.first.call(null,inst_60120__$1);
var inst_60124 = cljs.core.coll_QMARK_.call(null,inst_60123);
var inst_60125 = ((inst_60122) && (inst_60124));
var state_60151__$1 = (function (){var statearr_60156 = state_60151;
(statearr_60156[(7)] = inst_60120__$1);

return statearr_60156;
})();
if(cljs.core.truth_(inst_60125)){
var statearr_60157_60179 = state_60151__$1;
(statearr_60157_60179[(1)] = (7));

} else {
var statearr_60158_60180 = state_60151__$1;
(statearr_60158_60180[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (3))){
var inst_60149 = (state_60151[(2)]);
var state_60151__$1 = state_60151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60151__$1,inst_60149);
} else {
if((state_val_60152 === (2))){
var _ = (function (){var statearr_60160 = state_60151;
(statearr_60160[(4)] = cljs.core.cons.call(null,(5),(state_60151[(4)])));

return statearr_60160;
})();
var inst_60117 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60151__$1 = state_60151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60151__$1,(6),inst_60117);
} else {
if((state_val_60152 === (9))){
var inst_60130 = (state_60151[(2)]);
var inst_60131 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_60130);
var inst_60132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60133 = [inst_60130];
var inst_60134 = (new cljs.core.PersistentVector(null,1,(5),inst_60132,inst_60133,null));
var inst_60135 = cljs.core.count.call(null,inst_60134);
var inst_60136 = ((9) + inst_60135);
var inst_60137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60138 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60140 = [inst_60130];
var inst_60141 = (new cljs.core.PersistentVector(null,1,(5),inst_60139,inst_60140,null));
var inst_60142 = ["hash-set",inst_60141,inst_60131];
var inst_60143 = cljs.core.PersistentHashMap.fromArrays(inst_60138,inst_60142);
var inst_60144 = [inst_60143,inst_60136];
var inst_60145 = (new cljs.core.PersistentVector(null,2,(5),inst_60137,inst_60144,null));
var inst_60146 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60145);
var _ = (function (){var statearr_60161 = state_60151;
(statearr_60161[(4)] = cljs.core.rest.call(null,(state_60151[(4)])));

return statearr_60161;
})();
var state_60151__$1 = (function (){var statearr_60162 = state_60151;
(statearr_60162[(8)] = inst_60146);

return statearr_60162;
})();
var statearr_60163_60181 = state_60151__$1;
(statearr_60163_60181[(2)] = inst_60131);

(statearr_60163_60181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (5))){
var _ = (function (){var statearr_60164 = state_60151;
(statearr_60164[(4)] = cljs.core.rest.call(null,(state_60151[(4)])));

return statearr_60164;
})();
var state_60151__$1 = state_60151;
var ex60159 = (state_60151__$1[(2)]);
var statearr_60165_60182 = state_60151__$1;
(statearr_60165_60182[(5)] = ex60159);


if((ex60159 instanceof Error)){
var statearr_60166_60183 = state_60151__$1;
(statearr_60166_60183[(1)] = (4));

(statearr_60166_60183[(5)] = null);

} else {
throw ex60159;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60152 === (8))){
var inst_60120 = (state_60151[(7)]);
var state_60151__$1 = state_60151;
var statearr_60167_60184 = state_60151__$1;
(statearr_60167_60184[(2)] = inst_60120);

(statearr_60167_60184[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60168 = [null,null,null,null,null,null,null,null,null];
(statearr_60168[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60168[(1)] = (1));

return statearr_60168;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60151){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60169){var ex__2457__auto__ = e60169;
var statearr_60170_60185 = state_60151;
(statearr_60170_60185[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60151[(4)]))){
var statearr_60171_60186 = state_60151;
(statearr_60171_60186[(1)] = cljs.core.first.call(null,(state_60151[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60187 = state_60151;
state_60151 = G__60187;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60151){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60172 = f__2477__auto__.call(null);
(statearr_60172[(6)] = c__2476__auto__);

return statearr_60172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq60109){
var G__60110 = cljs.core.first.call(null,seq60109);
var seq60109__$1 = cljs.core.next.call(null,seq60109);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60110,seq60109__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60237 = arguments.length;
var i__4737__auto___60238 = (0);
while(true){
if((i__4737__auto___60238 < len__4736__auto___60237)){
args__4742__auto__.push((arguments[i__4737__auto___60238]));

var G__60239 = (i__4737__auto___60238 + (1));
i__4737__auto___60238 = G__60239;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60220){
var state_val_60221 = (state_60220[(1)]);
if((state_val_60221 === (1))){
var state_60220__$1 = state_60220;
var statearr_60222_60240 = state_60220__$1;
(statearr_60222_60240[(2)] = null);

(statearr_60222_60240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60221 === (2))){
var _ = (function (){var statearr_60223 = state_60220;
(statearr_60223[(4)] = cljs.core.cons.call(null,(5),(state_60220[(4)])));

return statearr_60223;
})();
var inst_60196 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60220__$1 = state_60220;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60220__$1,(6),inst_60196);
} else {
if((state_val_60221 === (3))){
var inst_60218 = (state_60220[(2)]);
var state_60220__$1 = state_60220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60220__$1,inst_60218);
} else {
if((state_val_60221 === (4))){
var inst_60190 = (state_60220[(2)]);
var state_60220__$1 = state_60220;
var statearr_60225_60241 = state_60220__$1;
(statearr_60225_60241[(2)] = inst_60190);

(statearr_60225_60241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60221 === (5))){
var _ = (function (){var statearr_60226 = state_60220;
(statearr_60226[(4)] = cljs.core.rest.call(null,(state_60220[(4)])));

return statearr_60226;
})();
var state_60220__$1 = state_60220;
var ex60224 = (state_60220__$1[(2)]);
var statearr_60227_60242 = state_60220__$1;
(statearr_60227_60242[(5)] = ex60224);


if((ex60224 instanceof Error)){
var statearr_60228_60243 = state_60220__$1;
(statearr_60228_60243[(1)] = (4));

(statearr_60228_60243[(5)] = null);

} else {
throw ex60224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60221 === (6))){
var inst_60198 = (state_60220[(2)]);
var inst_60199 = fluree.db.util.async.throw_err.call(null,inst_60198);
var inst_60200 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_60199);
var inst_60201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60202 = [inst_60199];
var inst_60203 = (new cljs.core.PersistentVector(null,1,(5),inst_60201,inst_60202,null));
var inst_60204 = cljs.core.count.call(null,inst_60203);
var inst_60205 = ((9) + inst_60204);
var inst_60206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60207 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60209 = [inst_60199];
var inst_60210 = (new cljs.core.PersistentVector(null,1,(5),inst_60208,inst_60209,null));
var inst_60211 = ["==",inst_60210,inst_60200];
var inst_60212 = cljs.core.PersistentHashMap.fromArrays(inst_60207,inst_60211);
var inst_60213 = [inst_60212,inst_60205];
var inst_60214 = (new cljs.core.PersistentVector(null,2,(5),inst_60206,inst_60213,null));
var inst_60215 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60214);
var _ = (function (){var statearr_60229 = state_60220;
(statearr_60229[(4)] = cljs.core.rest.call(null,(state_60220[(4)])));

return statearr_60229;
})();
var state_60220__$1 = (function (){var statearr_60230 = state_60220;
(statearr_60230[(7)] = inst_60215);

return statearr_60230;
})();
var statearr_60231_60244 = state_60220__$1;
(statearr_60231_60244[(2)] = inst_60200);

(statearr_60231_60244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60232 = [null,null,null,null,null,null,null,null];
(statearr_60232[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60232[(1)] = (1));

return statearr_60232;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60220){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60233){var ex__2457__auto__ = e60233;
var statearr_60234_60245 = state_60220;
(statearr_60234_60245[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60220[(4)]))){
var statearr_60235_60246 = state_60220;
(statearr_60235_60246[(1)] = cljs.core.first.call(null,(state_60220[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60247 = state_60220;
state_60220 = G__60247;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60220){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60236 = f__2477__auto__.call(null);
(statearr_60236[(6)] = c__2476__auto__);

return statearr_60236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq60188){
var G__60189 = cljs.core.first.call(null,seq60188);
var seq60188__$1 = cljs.core.next.call(null,seq60188);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60189,seq60188__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60297 = arguments.length;
var i__4737__auto___60298 = (0);
while(true){
if((i__4737__auto___60298 < len__4736__auto___60297)){
args__4742__auto__.push((arguments[i__4737__auto___60298]));

var G__60299 = (i__4737__auto___60298 + (1));
i__4737__auto___60298 = G__60299;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60280){
var state_val_60281 = (state_60280[(1)]);
if((state_val_60281 === (1))){
var state_60280__$1 = state_60280;
var statearr_60282_60300 = state_60280__$1;
(statearr_60282_60300[(2)] = null);

(statearr_60282_60300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60281 === (2))){
var _ = (function (){var statearr_60283 = state_60280;
(statearr_60283[(4)] = cljs.core.cons.call(null,(5),(state_60280[(4)])));

return statearr_60283;
})();
var inst_60256 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60280__$1 = state_60280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60280__$1,(6),inst_60256);
} else {
if((state_val_60281 === (3))){
var inst_60278 = (state_60280[(2)]);
var state_60280__$1 = state_60280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60280__$1,inst_60278);
} else {
if((state_val_60281 === (4))){
var inst_60250 = (state_60280[(2)]);
var state_60280__$1 = state_60280;
var statearr_60285_60301 = state_60280__$1;
(statearr_60285_60301[(2)] = inst_60250);

(statearr_60285_60301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60281 === (5))){
var _ = (function (){var statearr_60286 = state_60280;
(statearr_60286[(4)] = cljs.core.rest.call(null,(state_60280[(4)])));

return statearr_60286;
})();
var state_60280__$1 = state_60280;
var ex60284 = (state_60280__$1[(2)]);
var statearr_60287_60302 = state_60280__$1;
(statearr_60287_60302[(5)] = ex60284);


if((ex60284 instanceof Error)){
var statearr_60288_60303 = state_60280__$1;
(statearr_60288_60303[(1)] = (4));

(statearr_60288_60303[(5)] = null);

} else {
throw ex60284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60281 === (6))){
var inst_60258 = (state_60280[(2)]);
var inst_60259 = fluree.db.util.async.throw_err.call(null,inst_60258);
var inst_60260 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_60259);
var inst_60261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60262 = [inst_60259];
var inst_60263 = (new cljs.core.PersistentVector(null,1,(5),inst_60261,inst_60262,null));
var inst_60264 = cljs.core.count.call(null,inst_60263);
var inst_60265 = ((9) + inst_60264);
var inst_60266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60267 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60269 = [inst_60259];
var inst_60270 = (new cljs.core.PersistentVector(null,1,(5),inst_60268,inst_60269,null));
var inst_60271 = [">",inst_60270,inst_60260];
var inst_60272 = cljs.core.PersistentHashMap.fromArrays(inst_60267,inst_60271);
var inst_60273 = [inst_60272,inst_60265];
var inst_60274 = (new cljs.core.PersistentVector(null,2,(5),inst_60266,inst_60273,null));
var inst_60275 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60274);
var _ = (function (){var statearr_60289 = state_60280;
(statearr_60289[(4)] = cljs.core.rest.call(null,(state_60280[(4)])));

return statearr_60289;
})();
var state_60280__$1 = (function (){var statearr_60290 = state_60280;
(statearr_60290[(7)] = inst_60275);

return statearr_60290;
})();
var statearr_60291_60304 = state_60280__$1;
(statearr_60291_60304[(2)] = inst_60260);

(statearr_60291_60304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60292 = [null,null,null,null,null,null,null,null];
(statearr_60292[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60292[(1)] = (1));

return statearr_60292;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60280){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60293){var ex__2457__auto__ = e60293;
var statearr_60294_60305 = state_60280;
(statearr_60294_60305[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60280[(4)]))){
var statearr_60295_60306 = state_60280;
(statearr_60295_60306[(1)] = cljs.core.first.call(null,(state_60280[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60307 = state_60280;
state_60280 = G__60307;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60296 = f__2477__auto__.call(null);
(statearr_60296[(6)] = c__2476__auto__);

return statearr_60296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq60248){
var G__60249 = cljs.core.first.call(null,seq60248);
var seq60248__$1 = cljs.core.next.call(null,seq60248);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60249,seq60248__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60357 = arguments.length;
var i__4737__auto___60358 = (0);
while(true){
if((i__4737__auto___60358 < len__4736__auto___60357)){
args__4742__auto__.push((arguments[i__4737__auto___60358]));

var G__60359 = (i__4737__auto___60358 + (1));
i__4737__auto___60358 = G__60359;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60340){
var state_val_60341 = (state_60340[(1)]);
if((state_val_60341 === (1))){
var state_60340__$1 = state_60340;
var statearr_60342_60360 = state_60340__$1;
(statearr_60342_60360[(2)] = null);

(statearr_60342_60360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60341 === (2))){
var _ = (function (){var statearr_60343 = state_60340;
(statearr_60343[(4)] = cljs.core.cons.call(null,(5),(state_60340[(4)])));

return statearr_60343;
})();
var inst_60316 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60340__$1 = state_60340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60340__$1,(6),inst_60316);
} else {
if((state_val_60341 === (3))){
var inst_60338 = (state_60340[(2)]);
var state_60340__$1 = state_60340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60340__$1,inst_60338);
} else {
if((state_val_60341 === (4))){
var inst_60310 = (state_60340[(2)]);
var state_60340__$1 = state_60340;
var statearr_60345_60361 = state_60340__$1;
(statearr_60345_60361[(2)] = inst_60310);

(statearr_60345_60361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60341 === (5))){
var _ = (function (){var statearr_60346 = state_60340;
(statearr_60346[(4)] = cljs.core.rest.call(null,(state_60340[(4)])));

return statearr_60346;
})();
var state_60340__$1 = state_60340;
var ex60344 = (state_60340__$1[(2)]);
var statearr_60347_60362 = state_60340__$1;
(statearr_60347_60362[(5)] = ex60344);


if((ex60344 instanceof Error)){
var statearr_60348_60363 = state_60340__$1;
(statearr_60348_60363[(1)] = (4));

(statearr_60348_60363[(5)] = null);

} else {
throw ex60344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60341 === (6))){
var inst_60318 = (state_60340[(2)]);
var inst_60319 = fluree.db.util.async.throw_err.call(null,inst_60318);
var inst_60320 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_60319);
var inst_60321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60322 = [inst_60319];
var inst_60323 = (new cljs.core.PersistentVector(null,1,(5),inst_60321,inst_60322,null));
var inst_60324 = cljs.core.count.call(null,inst_60323);
var inst_60325 = ((9) + inst_60324);
var inst_60326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60329 = [inst_60319];
var inst_60330 = (new cljs.core.PersistentVector(null,1,(5),inst_60328,inst_60329,null));
var inst_60331 = ["<",inst_60330,inst_60320];
var inst_60332 = cljs.core.PersistentHashMap.fromArrays(inst_60327,inst_60331);
var inst_60333 = [inst_60332,inst_60325];
var inst_60334 = (new cljs.core.PersistentVector(null,2,(5),inst_60326,inst_60333,null));
var inst_60335 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60334);
var _ = (function (){var statearr_60349 = state_60340;
(statearr_60349[(4)] = cljs.core.rest.call(null,(state_60340[(4)])));

return statearr_60349;
})();
var state_60340__$1 = (function (){var statearr_60350 = state_60340;
(statearr_60350[(7)] = inst_60335);

return statearr_60350;
})();
var statearr_60351_60364 = state_60340__$1;
(statearr_60351_60364[(2)] = inst_60320);

(statearr_60351_60364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60352 = [null,null,null,null,null,null,null,null];
(statearr_60352[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60352[(1)] = (1));

return statearr_60352;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60340){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60353){var ex__2457__auto__ = e60353;
var statearr_60354_60365 = state_60340;
(statearr_60354_60365[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60340[(4)]))){
var statearr_60355_60366 = state_60340;
(statearr_60355_60366[(1)] = cljs.core.first.call(null,(state_60340[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60367 = state_60340;
state_60340 = G__60367;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60356 = f__2477__auto__.call(null);
(statearr_60356[(6)] = c__2476__auto__);

return statearr_60356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq60308){
var G__60309 = cljs.core.first.call(null,seq60308);
var seq60308__$1 = cljs.core.next.call(null,seq60308);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60309,seq60308__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60417 = arguments.length;
var i__4737__auto___60418 = (0);
while(true){
if((i__4737__auto___60418 < len__4736__auto___60417)){
args__4742__auto__.push((arguments[i__4737__auto___60418]));

var G__60419 = (i__4737__auto___60418 + (1));
i__4737__auto___60418 = G__60419;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60400){
var state_val_60401 = (state_60400[(1)]);
if((state_val_60401 === (1))){
var state_60400__$1 = state_60400;
var statearr_60402_60420 = state_60400__$1;
(statearr_60402_60420[(2)] = null);

(statearr_60402_60420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60401 === (2))){
var _ = (function (){var statearr_60403 = state_60400;
(statearr_60403[(4)] = cljs.core.cons.call(null,(5),(state_60400[(4)])));

return statearr_60403;
})();
var inst_60376 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60400__$1 = state_60400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60400__$1,(6),inst_60376);
} else {
if((state_val_60401 === (3))){
var inst_60398 = (state_60400[(2)]);
var state_60400__$1 = state_60400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60400__$1,inst_60398);
} else {
if((state_val_60401 === (4))){
var inst_60370 = (state_60400[(2)]);
var state_60400__$1 = state_60400;
var statearr_60405_60421 = state_60400__$1;
(statearr_60405_60421[(2)] = inst_60370);

(statearr_60405_60421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60401 === (5))){
var _ = (function (){var statearr_60406 = state_60400;
(statearr_60406[(4)] = cljs.core.rest.call(null,(state_60400[(4)])));

return statearr_60406;
})();
var state_60400__$1 = state_60400;
var ex60404 = (state_60400__$1[(2)]);
var statearr_60407_60422 = state_60400__$1;
(statearr_60407_60422[(5)] = ex60404);


if((ex60404 instanceof Error)){
var statearr_60408_60423 = state_60400__$1;
(statearr_60408_60423[(1)] = (4));

(statearr_60408_60423[(5)] = null);

} else {
throw ex60404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60401 === (6))){
var inst_60378 = (state_60400[(2)]);
var inst_60379 = fluree.db.util.async.throw_err.call(null,inst_60378);
var inst_60380 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_60379);
var inst_60381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60382 = [inst_60379];
var inst_60383 = (new cljs.core.PersistentVector(null,1,(5),inst_60381,inst_60382,null));
var inst_60384 = cljs.core.count.call(null,inst_60383);
var inst_60385 = ((9) + inst_60384);
var inst_60386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60387 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60389 = [inst_60379];
var inst_60390 = (new cljs.core.PersistentVector(null,1,(5),inst_60388,inst_60389,null));
var inst_60391 = ["<=",inst_60390,inst_60380];
var inst_60392 = cljs.core.PersistentHashMap.fromArrays(inst_60387,inst_60391);
var inst_60393 = [inst_60392,inst_60385];
var inst_60394 = (new cljs.core.PersistentVector(null,2,(5),inst_60386,inst_60393,null));
var inst_60395 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60394);
var _ = (function (){var statearr_60409 = state_60400;
(statearr_60409[(4)] = cljs.core.rest.call(null,(state_60400[(4)])));

return statearr_60409;
})();
var state_60400__$1 = (function (){var statearr_60410 = state_60400;
(statearr_60410[(7)] = inst_60395);

return statearr_60410;
})();
var statearr_60411_60424 = state_60400__$1;
(statearr_60411_60424[(2)] = inst_60380);

(statearr_60411_60424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60412 = [null,null,null,null,null,null,null,null];
(statearr_60412[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60412[(1)] = (1));

return statearr_60412;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60400){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60413){var ex__2457__auto__ = e60413;
var statearr_60414_60425 = state_60400;
(statearr_60414_60425[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60400[(4)]))){
var statearr_60415_60426 = state_60400;
(statearr_60415_60426[(1)] = cljs.core.first.call(null,(state_60400[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60427 = state_60400;
state_60400 = G__60427;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60416 = f__2477__auto__.call(null);
(statearr_60416[(6)] = c__2476__auto__);

return statearr_60416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq60368){
var G__60369 = cljs.core.first.call(null,seq60368);
var seq60368__$1 = cljs.core.next.call(null,seq60368);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60369,seq60368__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60477 = arguments.length;
var i__4737__auto___60478 = (0);
while(true){
if((i__4737__auto___60478 < len__4736__auto___60477)){
args__4742__auto__.push((arguments[i__4737__auto___60478]));

var G__60479 = (i__4737__auto___60478 + (1));
i__4737__auto___60478 = G__60479;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60460){
var state_val_60461 = (state_60460[(1)]);
if((state_val_60461 === (1))){
var state_60460__$1 = state_60460;
var statearr_60462_60480 = state_60460__$1;
(statearr_60462_60480[(2)] = null);

(statearr_60462_60480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (2))){
var _ = (function (){var statearr_60463 = state_60460;
(statearr_60463[(4)] = cljs.core.cons.call(null,(5),(state_60460[(4)])));

return statearr_60463;
})();
var inst_60436 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60460__$1,(6),inst_60436);
} else {
if((state_val_60461 === (3))){
var inst_60458 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60460__$1,inst_60458);
} else {
if((state_val_60461 === (4))){
var inst_60430 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60465_60481 = state_60460__$1;
(statearr_60465_60481[(2)] = inst_60430);

(statearr_60465_60481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (5))){
var _ = (function (){var statearr_60466 = state_60460;
(statearr_60466[(4)] = cljs.core.rest.call(null,(state_60460[(4)])));

return statearr_60466;
})();
var state_60460__$1 = state_60460;
var ex60464 = (state_60460__$1[(2)]);
var statearr_60467_60482 = state_60460__$1;
(statearr_60467_60482[(5)] = ex60464);


if((ex60464 instanceof Error)){
var statearr_60468_60483 = state_60460__$1;
(statearr_60468_60483[(1)] = (4));

(statearr_60468_60483[(5)] = null);

} else {
throw ex60464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (6))){
var inst_60438 = (state_60460[(2)]);
var inst_60439 = fluree.db.util.async.throw_err.call(null,inst_60438);
var inst_60440 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_60439);
var inst_60441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60442 = [inst_60439];
var inst_60443 = (new cljs.core.PersistentVector(null,1,(5),inst_60441,inst_60442,null));
var inst_60444 = cljs.core.count.call(null,inst_60443);
var inst_60445 = ((9) + inst_60444);
var inst_60446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60449 = [inst_60439];
var inst_60450 = (new cljs.core.PersistentVector(null,1,(5),inst_60448,inst_60449,null));
var inst_60451 = [">=",inst_60450,inst_60440];
var inst_60452 = cljs.core.PersistentHashMap.fromArrays(inst_60447,inst_60451);
var inst_60453 = [inst_60452,inst_60445];
var inst_60454 = (new cljs.core.PersistentVector(null,2,(5),inst_60446,inst_60453,null));
var inst_60455 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60454);
var _ = (function (){var statearr_60469 = state_60460;
(statearr_60469[(4)] = cljs.core.rest.call(null,(state_60460[(4)])));

return statearr_60469;
})();
var state_60460__$1 = (function (){var statearr_60470 = state_60460;
(statearr_60470[(7)] = inst_60455);

return statearr_60470;
})();
var statearr_60471_60484 = state_60460__$1;
(statearr_60471_60484[(2)] = inst_60440);

(statearr_60471_60484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60472 = [null,null,null,null,null,null,null,null];
(statearr_60472[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60472[(1)] = (1));

return statearr_60472;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60460){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60473){var ex__2457__auto__ = e60473;
var statearr_60474_60485 = state_60460;
(statearr_60474_60485[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60460[(4)]))){
var statearr_60475_60486 = state_60460;
(statearr_60475_60486[(1)] = cljs.core.first.call(null,(state_60460[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60487 = state_60460;
state_60460 = G__60487;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60476 = f__2477__auto__.call(null);
(statearr_60476[(6)] = c__2476__auto__);

return statearr_60476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq60428){
var G__60429 = cljs.core.first.call(null,seq60428);
var seq60428__$1 = cljs.core.next.call(null,seq60428);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60429,seq60428__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60537 = arguments.length;
var i__4737__auto___60538 = (0);
while(true){
if((i__4737__auto___60538 < len__4736__auto___60537)){
args__4742__auto__.push((arguments[i__4737__auto___60538]));

var G__60539 = (i__4737__auto___60538 + (1));
i__4737__auto___60538 = G__60539;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60520){
var state_val_60521 = (state_60520[(1)]);
if((state_val_60521 === (1))){
var state_60520__$1 = state_60520;
var statearr_60522_60540 = state_60520__$1;
(statearr_60522_60540[(2)] = null);

(statearr_60522_60540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60521 === (2))){
var _ = (function (){var statearr_60523 = state_60520;
(statearr_60523[(4)] = cljs.core.cons.call(null,(5),(state_60520[(4)])));

return statearr_60523;
})();
var inst_60496 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60520__$1 = state_60520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60520__$1,(6),inst_60496);
} else {
if((state_val_60521 === (3))){
var inst_60518 = (state_60520[(2)]);
var state_60520__$1 = state_60520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60520__$1,inst_60518);
} else {
if((state_val_60521 === (4))){
var inst_60490 = (state_60520[(2)]);
var state_60520__$1 = state_60520;
var statearr_60525_60541 = state_60520__$1;
(statearr_60525_60541[(2)] = inst_60490);

(statearr_60525_60541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60521 === (5))){
var _ = (function (){var statearr_60526 = state_60520;
(statearr_60526[(4)] = cljs.core.rest.call(null,(state_60520[(4)])));

return statearr_60526;
})();
var state_60520__$1 = state_60520;
var ex60524 = (state_60520__$1[(2)]);
var statearr_60527_60542 = state_60520__$1;
(statearr_60527_60542[(5)] = ex60524);


if((ex60524 instanceof Error)){
var statearr_60528_60543 = state_60520__$1;
(statearr_60528_60543[(1)] = (4));

(statearr_60528_60543[(5)] = null);

} else {
throw ex60524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60521 === (6))){
var inst_60498 = (state_60520[(2)]);
var inst_60499 = fluree.db.util.async.throw_err.call(null,inst_60498);
var inst_60500 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_60499);
var inst_60501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60502 = [inst_60499];
var inst_60503 = (new cljs.core.PersistentVector(null,1,(5),inst_60501,inst_60502,null));
var inst_60504 = cljs.core.count.call(null,inst_60503);
var inst_60505 = ((9) + inst_60504);
var inst_60506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60507 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60509 = [inst_60499];
var inst_60510 = (new cljs.core.PersistentVector(null,1,(5),inst_60508,inst_60509,null));
var inst_60511 = ["max",inst_60510,inst_60500];
var inst_60512 = cljs.core.PersistentHashMap.fromArrays(inst_60507,inst_60511);
var inst_60513 = [inst_60512,inst_60505];
var inst_60514 = (new cljs.core.PersistentVector(null,2,(5),inst_60506,inst_60513,null));
var inst_60515 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60514);
var _ = (function (){var statearr_60529 = state_60520;
(statearr_60529[(4)] = cljs.core.rest.call(null,(state_60520[(4)])));

return statearr_60529;
})();
var state_60520__$1 = (function (){var statearr_60530 = state_60520;
(statearr_60530[(7)] = inst_60515);

return statearr_60530;
})();
var statearr_60531_60544 = state_60520__$1;
(statearr_60531_60544[(2)] = inst_60500);

(statearr_60531_60544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60532 = [null,null,null,null,null,null,null,null];
(statearr_60532[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60532[(1)] = (1));

return statearr_60532;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60520){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60533){var ex__2457__auto__ = e60533;
var statearr_60534_60545 = state_60520;
(statearr_60534_60545[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60520[(4)]))){
var statearr_60535_60546 = state_60520;
(statearr_60535_60546[(1)] = cljs.core.first.call(null,(state_60520[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60547 = state_60520;
state_60520 = G__60547;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60520){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60536 = f__2477__auto__.call(null);
(statearr_60536[(6)] = c__2476__auto__);

return statearr_60536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq60488){
var G__60489 = cljs.core.first.call(null,seq60488);
var seq60488__$1 = cljs.core.next.call(null,seq60488);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60489,seq60488__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60596 = arguments.length;
var i__4737__auto___60597 = (0);
while(true){
if((i__4737__auto___60597 < len__4736__auto___60596)){
args__4742__auto__.push((arguments[i__4737__auto___60597]));

var G__60598 = (i__4737__auto___60597 + (1));
i__4737__auto___60597 = G__60598;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60579){
var state_val_60580 = (state_60579[(1)]);
if((state_val_60580 === (1))){
var state_60579__$1 = state_60579;
var statearr_60581_60599 = state_60579__$1;
(statearr_60581_60599[(2)] = null);

(statearr_60581_60599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (2))){
var _ = (function (){var statearr_60582 = state_60579;
(statearr_60582[(4)] = cljs.core.cons.call(null,(5),(state_60579[(4)])));

return statearr_60582;
})();
var inst_60556 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_60579__$1 = state_60579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60579__$1,(6),inst_60556);
} else {
if((state_val_60580 === (3))){
var inst_60577 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60579__$1,inst_60577);
} else {
if((state_val_60580 === (4))){
var inst_60550 = (state_60579[(2)]);
var state_60579__$1 = state_60579;
var statearr_60584_60600 = state_60579__$1;
(statearr_60584_60600[(2)] = inst_60550);

(statearr_60584_60600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (5))){
var _ = (function (){var statearr_60585 = state_60579;
(statearr_60585[(4)] = cljs.core.rest.call(null,(state_60579[(4)])));

return statearr_60585;
})();
var state_60579__$1 = state_60579;
var ex60583 = (state_60579__$1[(2)]);
var statearr_60586_60601 = state_60579__$1;
(statearr_60586_60601[(5)] = ex60583);


if((ex60583 instanceof Error)){
var statearr_60587_60602 = state_60579__$1;
(statearr_60587_60602[(1)] = (4));

(statearr_60587_60602[(5)] = null);

} else {
throw ex60583;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60580 === (6))){
var inst_60558 = (state_60579[(2)]);
var inst_60559 = fluree.db.util.async.throw_err.call(null,inst_60558);
var inst_60560 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_60559);
var inst_60561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60562 = [inst_60559];
var inst_60563 = (new cljs.core.PersistentVector(null,1,(5),inst_60561,inst_60562,null));
var inst_60564 = cljs.core.count.call(null,inst_60563);
var inst_60565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60566 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60568 = [inst_60559];
var inst_60569 = (new cljs.core.PersistentVector(null,1,(5),inst_60567,inst_60568,null));
var inst_60570 = ["min",inst_60569,inst_60560];
var inst_60571 = cljs.core.PersistentHashMap.fromArrays(inst_60566,inst_60570);
var inst_60572 = [inst_60571,inst_60564];
var inst_60573 = (new cljs.core.PersistentVector(null,2,(5),inst_60565,inst_60572,null));
var inst_60574 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60573);
var _ = (function (){var statearr_60588 = state_60579;
(statearr_60588[(4)] = cljs.core.rest.call(null,(state_60579[(4)])));

return statearr_60588;
})();
var state_60579__$1 = (function (){var statearr_60589 = state_60579;
(statearr_60589[(7)] = inst_60574);

return statearr_60589;
})();
var statearr_60590_60603 = state_60579__$1;
(statearr_60590_60603[(2)] = inst_60560);

(statearr_60590_60603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60591 = [null,null,null,null,null,null,null,null];
(statearr_60591[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60591[(1)] = (1));

return statearr_60591;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60579){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60592){var ex__2457__auto__ = e60592;
var statearr_60593_60604 = state_60579;
(statearr_60593_60604[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60579[(4)]))){
var statearr_60594_60605 = state_60579;
(statearr_60594_60605[(1)] = cljs.core.first.call(null,(state_60579[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60606 = state_60579;
state_60579 = G__60606;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60595 = f__2477__auto__.call(null);
(statearr_60595[(6)] = c__2476__auto__);

return statearr_60595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq60548){
var G__60549 = cljs.core.first.call(null,seq60548);
var seq60548__$1 = cljs.core.next.call(null,seq60548);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__60549,seq60548__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__60608 = arguments.length;
switch (G__60608) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60653){
var state_val_60654 = (state_60653[(1)]);
if((state_val_60654 === (7))){
var state_60653__$1 = state_60653;
var statearr_60655_60792 = state_60653__$1;
(statearr_60655_60792[(2)] = query_map);

(statearr_60655_60792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (1))){
var state_60653__$1 = state_60653;
var statearr_60656_60793 = state_60653__$1;
(statearr_60656_60793[(2)] = null);

(statearr_60656_60793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (4))){
var inst_60609 = (state_60653[(2)]);
var state_60653__$1 = state_60653;
var statearr_60657_60794 = state_60653__$1;
(statearr_60657_60794[(2)] = inst_60609);

(statearr_60657_60794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (13))){
var inst_60631 = (state_60653[(7)]);
var inst_60635 = (state_60653[(2)]);
var inst_60636 = fluree.db.util.async.throw_err.call(null,inst_60635);
var inst_60637 = cljs.core.nth.call(null,inst_60636,(0),null);
var inst_60638 = cljs.core.nth.call(null,inst_60636,(1),null);
var inst_60639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60640 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60642 = [inst_60631];
var inst_60643 = (new cljs.core.PersistentVector(null,1,(5),inst_60641,inst_60642,null));
var inst_60644 = ["query",inst_60643,inst_60637];
var inst_60645 = cljs.core.PersistentHashMap.fromArrays(inst_60640,inst_60644);
var inst_60646 = [inst_60645,inst_60638];
var inst_60647 = (new cljs.core.PersistentVector(null,2,(5),inst_60639,inst_60646,null));
var inst_60648 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60647);
var _ = (function (){var statearr_60658 = state_60653;
(statearr_60658[(4)] = cljs.core.rest.call(null,(state_60653[(4)])));

return statearr_60658;
})();
var state_60653__$1 = (function (){var statearr_60659 = state_60653;
(statearr_60659[(8)] = inst_60648);

return statearr_60659;
})();
var statearr_60660_60795 = state_60653__$1;
(statearr_60660_60795[(2)] = inst_60637);

(statearr_60660_60795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (6))){
var state_60653__$1 = state_60653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60653__$1,(9),query_map);
} else {
if((state_val_60654 === (3))){
var inst_60651 = (state_60653[(2)]);
var state_60653__$1 = state_60653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60653__$1,inst_60651);
} else {
if((state_val_60654 === (12))){
var inst_60631 = (state_60653[(7)]);
var inst_60631__$1 = (state_60653[(2)]);
var inst_60632 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_60633 = fluree.db.dbfunctions.internal.query.call(null,inst_60632,inst_60631__$1);
var state_60653__$1 = (function (){var statearr_60661 = state_60653;
(statearr_60661[(7)] = inst_60631__$1);

return statearr_60661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60653__$1,(13),inst_60633);
} else {
if((state_val_60654 === (2))){
var _ = (function (){var statearr_60662 = state_60653;
(statearr_60662[(4)] = cljs.core.cons.call(null,(5),(state_60653[(4)])));

return statearr_60662;
})();
var inst_60618 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_60653__$1 = state_60653;
if(inst_60618){
var statearr_60663_60796 = state_60653__$1;
(statearr_60663_60796[(1)] = (6));

} else {
var statearr_60664_60797 = state_60653__$1;
(statearr_60664_60797[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (11))){
var inst_60625 = (state_60653[(9)]);
var state_60653__$1 = state_60653;
var statearr_60666_60798 = state_60653__$1;
(statearr_60666_60798[(2)] = inst_60625);

(statearr_60666_60798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (9))){
var inst_60621 = (state_60653[(2)]);
var inst_60622 = fluree.db.util.async.throw_err.call(null,inst_60621);
var state_60653__$1 = state_60653;
var statearr_60667_60799 = state_60653__$1;
(statearr_60667_60799[(2)] = inst_60622);

(statearr_60667_60799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (5))){
var _ = (function (){var statearr_60668 = state_60653;
(statearr_60668[(4)] = cljs.core.rest.call(null,(state_60653[(4)])));

return statearr_60668;
})();
var state_60653__$1 = state_60653;
var ex60665 = (state_60653__$1[(2)]);
var statearr_60669_60800 = state_60653__$1;
(statearr_60669_60800[(5)] = ex60665);


if((ex60665 instanceof Error)){
var statearr_60670_60801 = state_60653__$1;
(statearr_60670_60801[(1)] = (4));

(statearr_60670_60801[(5)] = null);

} else {
throw ex60665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (10))){
var inst_60625 = (state_60653[(9)]);
var inst_60628 = fluree.db.util.json.parse.call(null,inst_60625);
var state_60653__$1 = state_60653;
var statearr_60671_60802 = state_60653__$1;
(statearr_60671_60802[(2)] = inst_60628);

(statearr_60671_60802[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60654 === (8))){
var inst_60625 = (state_60653[(9)]);
var inst_60625__$1 = (state_60653[(2)]);
var inst_60626 = typeof inst_60625__$1 === 'string';
var state_60653__$1 = (function (){var statearr_60672 = state_60653;
(statearr_60672[(9)] = inst_60625__$1);

return statearr_60672;
})();
if(cljs.core.truth_(inst_60626)){
var statearr_60673_60803 = state_60653__$1;
(statearr_60673_60803[(1)] = (10));

} else {
var statearr_60674_60804 = state_60653__$1;
(statearr_60674_60804[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60675 = [null,null,null,null,null,null,null,null,null,null];
(statearr_60675[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60675[(1)] = (1));

return statearr_60675;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60653){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60676){var ex__2457__auto__ = e60676;
var statearr_60677_60805 = state_60653;
(statearr_60677_60805[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60653[(4)]))){
var statearr_60678_60806 = state_60653;
(statearr_60678_60806[(1)] = cljs.core.first.call(null,(state_60653[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60807 = state_60653;
state_60653 = G__60807;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60679 = f__2477__auto__.call(null);
(statearr_60679[(6)] = c__2476__auto__);

return statearr_60679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60750){
var state_val_60751 = (state_60750[(1)]);
if((state_val_60751 === (7))){
var state_60750__$1 = state_60750;
var statearr_60752_60808 = state_60750__$1;
(statearr_60752_60808[(2)] = select);

(statearr_60752_60808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (20))){
var inst_60720 = (state_60750[(2)]);
var inst_60721 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_60750__$1 = (function (){var statearr_60753 = state_60750;
(statearr_60753[(7)] = inst_60720);

return statearr_60753;
})();
if(inst_60721){
var statearr_60754_60809 = state_60750__$1;
(statearr_60754_60809[(1)] = (22));

} else {
var statearr_60755_60810 = state_60750__$1;
(statearr_60755_60810[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (1))){
var state_60750__$1 = state_60750;
var statearr_60756_60811 = state_60750__$1;
(statearr_60756_60811[(2)] = null);

(statearr_60756_60811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (24))){
var inst_60712 = (state_60750[(8)]);
var inst_60696 = (state_60750[(9)]);
var inst_60720 = (state_60750[(7)]);
var inst_60704 = (state_60750[(10)]);
var inst_60728 = (state_60750[(2)]);
var inst_60729 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_60730 = fluree.db.dbfunctions.internal.query.call(null,inst_60729,inst_60696,inst_60704,inst_60712,inst_60720,inst_60728);
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(26),inst_60730);
} else {
if((state_val_60751 === (4))){
var inst_60680 = (state_60750[(2)]);
var state_60750__$1 = state_60750;
var statearr_60757_60812 = state_60750__$1;
(statearr_60757_60812[(2)] = inst_60680);

(statearr_60757_60812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (15))){
var state_60750__$1 = state_60750;
var statearr_60758_60813 = state_60750__$1;
(statearr_60758_60813[(2)] = where);

(statearr_60758_60813[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (21))){
var inst_60716 = (state_60750[(2)]);
var inst_60717 = fluree.db.util.async.throw_err.call(null,inst_60716);
var state_60750__$1 = state_60750;
var statearr_60759_60814 = state_60750__$1;
(statearr_60759_60814[(2)] = inst_60717);

(statearr_60759_60814[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (13))){
var inst_60700 = (state_60750[(2)]);
var inst_60701 = fluree.db.util.async.throw_err.call(null,inst_60700);
var state_60750__$1 = state_60750;
var statearr_60760_60815 = state_60750__$1;
(statearr_60760_60815[(2)] = inst_60701);

(statearr_60760_60815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (22))){
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(25),limit);
} else {
if((state_val_60751 === (6))){
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(9),select);
} else {
if((state_val_60751 === (25))){
var inst_60724 = (state_60750[(2)]);
var inst_60725 = fluree.db.util.async.throw_err.call(null,inst_60724);
var state_60750__$1 = state_60750;
var statearr_60761_60816 = state_60750__$1;
(statearr_60761_60816[(2)] = inst_60725);

(statearr_60761_60816[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (17))){
var inst_60708 = (state_60750[(2)]);
var inst_60709 = fluree.db.util.async.throw_err.call(null,inst_60708);
var state_60750__$1 = state_60750;
var statearr_60762_60817 = state_60750__$1;
(statearr_60762_60817[(2)] = inst_60709);

(statearr_60762_60817[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (3))){
var inst_60748 = (state_60750[(2)]);
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60750__$1,inst_60748);
} else {
if((state_val_60751 === (12))){
var inst_60704 = (state_60750[(2)]);
var inst_60705 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_60750__$1 = (function (){var statearr_60763 = state_60750;
(statearr_60763[(10)] = inst_60704);

return statearr_60763;
})();
if(inst_60705){
var statearr_60764_60818 = state_60750__$1;
(statearr_60764_60818[(1)] = (14));

} else {
var statearr_60765_60819 = state_60750__$1;
(statearr_60765_60819[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (2))){
var _ = (function (){var statearr_60766 = state_60750;
(statearr_60766[(4)] = cljs.core.cons.call(null,(5),(state_60750[(4)])));

return statearr_60766;
})();
var inst_60689 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_60750__$1 = state_60750;
if(inst_60689){
var statearr_60767_60820 = state_60750__$1;
(statearr_60767_60820[(1)] = (6));

} else {
var statearr_60768_60821 = state_60750__$1;
(statearr_60768_60821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (23))){
var state_60750__$1 = state_60750;
var statearr_60769_60822 = state_60750__$1;
(statearr_60769_60822[(2)] = limit);

(statearr_60769_60822[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (19))){
var state_60750__$1 = state_60750;
var statearr_60770_60823 = state_60750__$1;
(statearr_60770_60823[(2)] = block);

(statearr_60770_60823[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (11))){
var state_60750__$1 = state_60750;
var statearr_60772_60824 = state_60750__$1;
(statearr_60772_60824[(2)] = from);

(statearr_60772_60824[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (9))){
var inst_60692 = (state_60750[(2)]);
var inst_60693 = fluree.db.util.async.throw_err.call(null,inst_60692);
var state_60750__$1 = state_60750;
var statearr_60773_60825 = state_60750__$1;
(statearr_60773_60825[(2)] = inst_60693);

(statearr_60773_60825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (5))){
var _ = (function (){var statearr_60774 = state_60750;
(statearr_60774[(4)] = cljs.core.rest.call(null,(state_60750[(4)])));

return statearr_60774;
})();
var state_60750__$1 = state_60750;
var ex60771 = (state_60750__$1[(2)]);
var statearr_60775_60826 = state_60750__$1;
(statearr_60775_60826[(5)] = ex60771);


if((ex60771 instanceof Error)){
var statearr_60776_60827 = state_60750__$1;
(statearr_60776_60827[(1)] = (4));

(statearr_60776_60827[(5)] = null);

} else {
throw ex60771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (14))){
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(17),where);
} else {
if((state_val_60751 === (26))){
var inst_60712 = (state_60750[(8)]);
var inst_60696 = (state_60750[(9)]);
var inst_60720 = (state_60750[(7)]);
var inst_60704 = (state_60750[(10)]);
var inst_60732 = (state_60750[(2)]);
var inst_60733 = fluree.db.util.async.throw_err.call(null,inst_60732);
var inst_60734 = cljs.core.nth.call(null,inst_60733,(0),null);
var inst_60735 = cljs.core.nth.call(null,inst_60733,(1),null);
var inst_60736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60737 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60739 = [inst_60696,inst_60704,inst_60712,inst_60720];
var inst_60740 = (new cljs.core.PersistentVector(null,4,(5),inst_60738,inst_60739,null));
var inst_60741 = ["query",inst_60740,inst_60734];
var inst_60742 = cljs.core.PersistentHashMap.fromArrays(inst_60737,inst_60741);
var inst_60743 = [inst_60742,inst_60735];
var inst_60744 = (new cljs.core.PersistentVector(null,2,(5),inst_60736,inst_60743,null));
var inst_60745 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60744);
var _ = (function (){var statearr_60777 = state_60750;
(statearr_60777[(4)] = cljs.core.rest.call(null,(state_60750[(4)])));

return statearr_60777;
})();
var state_60750__$1 = (function (){var statearr_60778 = state_60750;
(statearr_60778[(11)] = inst_60745);

return statearr_60778;
})();
var statearr_60779_60828 = state_60750__$1;
(statearr_60779_60828[(2)] = inst_60734);

(statearr_60779_60828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (16))){
var inst_60712 = (state_60750[(2)]);
var inst_60713 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_60750__$1 = (function (){var statearr_60780 = state_60750;
(statearr_60780[(8)] = inst_60712);

return statearr_60780;
})();
if(inst_60713){
var statearr_60781_60829 = state_60750__$1;
(statearr_60781_60829[(1)] = (18));

} else {
var statearr_60782_60830 = state_60750__$1;
(statearr_60782_60830[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60751 === (10))){
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(13),from);
} else {
if((state_val_60751 === (18))){
var state_60750__$1 = state_60750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60750__$1,(21),block);
} else {
if((state_val_60751 === (8))){
var inst_60696 = (state_60750[(2)]);
var inst_60697 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_60750__$1 = (function (){var statearr_60783 = state_60750;
(statearr_60783[(9)] = inst_60696);

return statearr_60783;
})();
if(inst_60697){
var statearr_60784_60831 = state_60750__$1;
(statearr_60784_60831[(1)] = (10));

} else {
var statearr_60785_60832 = state_60750__$1;
(statearr_60785_60832[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_60786 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60786[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_60786[(1)] = (1));

return statearr_60786;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_60750){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60787){var ex__2457__auto__ = e60787;
var statearr_60788_60833 = state_60750;
(statearr_60788_60833[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60750[(4)]))){
var statearr_60789_60834 = state_60750;
(statearr_60789_60834[(1)] = cljs.core.first.call(null,(state_60750[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60835 = state_60750;
state_60750 = G__60835;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_60750){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_60750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60790 = f__2477__auto__.call(null);
(statearr_60790[(6)] = c__2476__auto__);

return statearr_60790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60891){
var state_val_60892 = (state_60891[(1)]);
if((state_val_60892 === (7))){
var state_60891__$1 = state_60891;
var statearr_60893_60924 = state_60891__$1;
(statearr_60893_60924[(2)] = startSubject);

(statearr_60893_60924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (1))){
var state_60891__$1 = state_60891;
var statearr_60894_60925 = state_60891__$1;
(statearr_60894_60925[(2)] = null);

(statearr_60894_60925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (4))){
var inst_60836 = (state_60891[(2)]);
var state_60891__$1 = state_60891;
var statearr_60895_60926 = state_60891__$1;
(statearr_60895_60926[(2)] = inst_60836);

(statearr_60895_60926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (15))){
var inst_60868 = (state_60891[(2)]);
var inst_60869 = fluree.db.util.async.throw_err.call(null,inst_60868);
var inst_60870 = cljs.core.nth.call(null,inst_60869,(0),null);
var inst_60871 = cljs.core.nth.call(null,inst_60869,(1),null);
var inst_60872 = cljs.core.empty_QMARK_.call(null,inst_60870);
var state_60891__$1 = (function (){var statearr_60896 = state_60891;
(statearr_60896[(7)] = inst_60871);

return statearr_60896;
})();
if(inst_60872){
var statearr_60897_60927 = state_60891__$1;
(statearr_60897_60927[(1)] = (16));

} else {
var statearr_60898_60928 = state_60891__$1;
(statearr_60898_60928[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (13))){
var inst_60864 = (state_60891[(8)]);
var inst_60852 = (state_60891[(9)]);
var inst_60856 = (state_60891[(10)]);
var inst_60864__$1 = (state_60891[(2)]);
var inst_60865 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_60866 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_60865,inst_60852,inst_60856,inst_60864__$1);
var state_60891__$1 = (function (){var statearr_60899 = state_60891;
(statearr_60899[(8)] = inst_60864__$1);

return statearr_60899;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60891__$1,(15),inst_60866);
} else {
if((state_val_60892 === (6))){
var state_60891__$1 = state_60891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60891__$1,(9),startSubject);
} else {
if((state_val_60892 === (17))){
var state_60891__$1 = state_60891;
var statearr_60900_60929 = state_60891__$1;
(statearr_60900_60929[(2)] = true);

(statearr_60900_60929[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (3))){
var inst_60889 = (state_60891[(2)]);
var state_60891__$1 = state_60891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60891__$1,inst_60889);
} else {
if((state_val_60892 === (12))){
var state_60891__$1 = state_60891;
var statearr_60901_60930 = state_60891__$1;
(statearr_60901_60930[(2)] = endSubject);

(statearr_60901_60930[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (2))){
var _ = (function (){var statearr_60902 = state_60891;
(statearr_60902[(4)] = cljs.core.cons.call(null,(5),(state_60891[(4)])));

return statearr_60902;
})();
var inst_60845 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_60891__$1 = state_60891;
if(inst_60845){
var statearr_60903_60931 = state_60891__$1;
(statearr_60903_60931[(1)] = (6));

} else {
var statearr_60904_60932 = state_60891__$1;
(statearr_60904_60932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (11))){
var state_60891__$1 = state_60891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60891__$1,(14),endSubject);
} else {
if((state_val_60892 === (9))){
var inst_60848 = (state_60891[(2)]);
var inst_60849 = fluree.db.util.async.throw_err.call(null,inst_60848);
var state_60891__$1 = state_60891;
var statearr_60906_60933 = state_60891__$1;
(statearr_60906_60933[(2)] = inst_60849);

(statearr_60906_60933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (5))){
var _ = (function (){var statearr_60907 = state_60891;
(statearr_60907[(4)] = cljs.core.rest.call(null,(state_60891[(4)])));

return statearr_60907;
})();
var state_60891__$1 = state_60891;
var ex60905 = (state_60891__$1[(2)]);
var statearr_60908_60934 = state_60891__$1;
(statearr_60908_60934[(5)] = ex60905);


if((ex60905 instanceof Error)){
var statearr_60909_60935 = state_60891__$1;
(statearr_60909_60935[(1)] = (4));

(statearr_60909_60935[(5)] = null);

} else {
throw ex60905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (14))){
var inst_60860 = (state_60891[(2)]);
var inst_60861 = fluree.db.util.async.throw_err.call(null,inst_60860);
var state_60891__$1 = state_60891;
var statearr_60910_60936 = state_60891__$1;
(statearr_60910_60936[(2)] = inst_60861);

(statearr_60910_60936[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (16))){
var state_60891__$1 = state_60891;
var statearr_60911_60937 = state_60891__$1;
(statearr_60911_60937[(2)] = false);

(statearr_60911_60937[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (10))){
var inst_60855 = (state_60891[(2)]);
var inst_60856 = fluree.db.util.async.throw_err.call(null,inst_60855);
var inst_60857 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_60891__$1 = (function (){var statearr_60912 = state_60891;
(statearr_60912[(10)] = inst_60856);

return statearr_60912;
})();
if(inst_60857){
var statearr_60913_60938 = state_60891__$1;
(statearr_60913_60938[(1)] = (11));

} else {
var statearr_60914_60939 = state_60891__$1;
(statearr_60914_60939[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (18))){
var inst_60864 = (state_60891[(8)]);
var inst_60852 = (state_60891[(9)]);
var inst_60856 = (state_60891[(10)]);
var inst_60871 = (state_60891[(7)]);
var inst_60876 = (state_60891[(2)]);
var inst_60877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60878 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60880 = [inst_60852,inst_60856,inst_60864];
var inst_60881 = (new cljs.core.PersistentVector(null,3,(5),inst_60879,inst_60880,null));
var inst_60882 = ["relationship?",inst_60881,inst_60876];
var inst_60883 = cljs.core.PersistentHashMap.fromArrays(inst_60878,inst_60882);
var inst_60884 = [inst_60883,inst_60871];
var inst_60885 = (new cljs.core.PersistentVector(null,2,(5),inst_60877,inst_60884,null));
var inst_60886 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60885);
var _ = (function (){var statearr_60915 = state_60891;
(statearr_60915[(4)] = cljs.core.rest.call(null,(state_60891[(4)])));

return statearr_60915;
})();
var state_60891__$1 = (function (){var statearr_60916 = state_60891;
(statearr_60916[(11)] = inst_60886);

return statearr_60916;
})();
var statearr_60917_60940 = state_60891__$1;
(statearr_60917_60940[(2)] = inst_60876);

(statearr_60917_60940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60892 === (8))){
var inst_60852 = (state_60891[(2)]);
var inst_60853 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_60891__$1 = (function (){var statearr_60918 = state_60891;
(statearr_60918[(9)] = inst_60852);

return statearr_60918;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60891__$1,(10),inst_60853);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_60919 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60919[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__);

(statearr_60919[(1)] = (1));

return statearr_60919;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____1 = (function (state_60891){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60920){var ex__2457__auto__ = e60920;
var statearr_60921_60941 = state_60891;
(statearr_60921_60941[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60891[(4)]))){
var statearr_60922_60942 = state_60891;
(statearr_60922_60942[(1)] = cljs.core.first.call(null,(state_60891[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60943 = state_60891;
state_60891 = G__60943;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__ = function(state_60891){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____1.call(this,state_60891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_60923 = f__2477__auto__.call(null);
(statearr_60923[(6)] = c__2476__auto__);

return statearr_60923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_60980){
var state_val_60981 = (state_60980[(1)]);
if((state_val_60981 === (7))){
var state_60980__$1 = state_60980;
var statearr_60982_61002 = state_60980__$1;
(statearr_60982_61002[(2)] = pred_name);

(statearr_60982_61002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (1))){
var state_60980__$1 = state_60980;
var statearr_60983_61003 = state_60980__$1;
(statearr_60983_61003[(2)] = null);

(statearr_60983_61003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (4))){
var inst_60944 = (state_60980[(2)]);
var state_60980__$1 = state_60980;
var statearr_60984_61004 = state_60980__$1;
(statearr_60984_61004[(2)] = inst_60944);

(statearr_60984_61004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (6))){
var state_60980__$1 = state_60980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60980__$1,(9),pred_name);
} else {
if((state_val_60981 === (3))){
var inst_60978 = (state_60980[(2)]);
var state_60980__$1 = state_60980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60980__$1,inst_60978);
} else {
if((state_val_60981 === (2))){
var _ = (function (){var statearr_60986 = state_60980;
(statearr_60986[(4)] = cljs.core.cons.call(null,(5),(state_60980[(4)])));

return statearr_60986;
})();
var inst_60953 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_60980__$1 = state_60980;
if(inst_60953){
var statearr_60987_61005 = state_60980__$1;
(statearr_60987_61005[(1)] = (6));

} else {
var statearr_60988_61006 = state_60980__$1;
(statearr_60988_61006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (9))){
var inst_60956 = (state_60980[(2)]);
var inst_60957 = fluree.db.util.async.throw_err.call(null,inst_60956);
var state_60980__$1 = state_60980;
var statearr_60989_61007 = state_60980__$1;
(statearr_60989_61007[(2)] = inst_60957);

(statearr_60989_61007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (5))){
var _ = (function (){var statearr_60990 = state_60980;
(statearr_60990[(4)] = cljs.core.rest.call(null,(state_60980[(4)])));

return statearr_60990;
})();
var state_60980__$1 = state_60980;
var ex60985 = (state_60980__$1[(2)]);
var statearr_60991_61008 = state_60980__$1;
(statearr_60991_61008[(5)] = ex60985);


if((ex60985 instanceof Error)){
var statearr_60992_61009 = state_60980__$1;
(statearr_60992_61009[(1)] = (4));

(statearr_60992_61009[(5)] = null);

} else {
throw ex60985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (10))){
var inst_60960 = (state_60980[(7)]);
var inst_60964 = (state_60980[(2)]);
var inst_60965 = fluree.db.util.async.throw_err.call(null,inst_60964);
var inst_60966 = cljs.core.nth.call(null,inst_60965,(0),null);
var inst_60967 = cljs.core.nth.call(null,inst_60965,(1),null);
var inst_60968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60969 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_60970 = ["max-pred-val",inst_60960,inst_60966];
var inst_60971 = cljs.core.PersistentHashMap.fromArrays(inst_60969,inst_60970);
var inst_60972 = (inst_60967 + (10));
var inst_60973 = [inst_60971,inst_60972];
var inst_60974 = (new cljs.core.PersistentVector(null,2,(5),inst_60968,inst_60973,null));
var inst_60975 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_60974);
var _ = (function (){var statearr_60993 = state_60980;
(statearr_60993[(4)] = cljs.core.rest.call(null,(state_60980[(4)])));

return statearr_60993;
})();
var state_60980__$1 = (function (){var statearr_60994 = state_60980;
(statearr_60994[(8)] = inst_60975);

return statearr_60994;
})();
var statearr_60995_61010 = state_60980__$1;
(statearr_60995_61010[(2)] = inst_60966);

(statearr_60995_61010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60981 === (8))){
var inst_60960 = (state_60980[(7)]);
var inst_60960__$1 = (state_60980[(2)]);
var inst_60961 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_60962 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_60961,inst_60960__$1);
var state_60980__$1 = (function (){var statearr_60996 = state_60980;
(statearr_60996[(7)] = inst_60960__$1);

return statearr_60996;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60980__$1,(10),inst_60962);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____0 = (function (){
var statearr_60997 = [null,null,null,null,null,null,null,null,null];
(statearr_60997[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__);

(statearr_60997[(1)] = (1));

return statearr_60997;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____1 = (function (state_60980){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_60980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e60998){var ex__2457__auto__ = e60998;
var statearr_60999_61011 = state_60980;
(statearr_60999_61011[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_60980[(4)]))){
var statearr_61000_61012 = state_60980;
(statearr_61000_61012[(1)] = cljs.core.first.call(null,(state_60980[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61013 = state_60980;
state_60980 = G__61013;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__ = function(state_60980){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____1.call(this,state_60980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61001 = f__2477__auto__.call(null);
(statearr_61001[(6)] = c__2476__auto__);

return statearr_61001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61040){
var state_val_61041 = (state_61040[(1)]);
if((state_val_61041 === (7))){
var state_61040__$1 = state_61040;
var statearr_61042_61061 = state_61040__$1;
(statearr_61042_61061[(2)] = n);

(statearr_61042_61061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (1))){
var state_61040__$1 = state_61040;
var statearr_61043_61062 = state_61040__$1;
(statearr_61043_61062[(2)] = null);

(statearr_61043_61062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (4))){
var inst_61014 = (state_61040[(2)]);
var state_61040__$1 = state_61040;
var statearr_61044_61063 = state_61040__$1;
(statearr_61044_61063[(2)] = inst_61014);

(statearr_61044_61063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (6))){
var state_61040__$1 = state_61040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61040__$1,(9),n);
} else {
if((state_val_61041 === (3))){
var inst_61038 = (state_61040[(2)]);
var state_61040__$1 = state_61040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61040__$1,inst_61038);
} else {
if((state_val_61041 === (2))){
var _ = (function (){var statearr_61046 = state_61040;
(statearr_61046[(4)] = cljs.core.cons.call(null,(5),(state_61040[(4)])));

return statearr_61046;
})();
var inst_61020 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_61040__$1 = state_61040;
if(inst_61020){
var statearr_61047_61064 = state_61040__$1;
(statearr_61047_61064[(1)] = (6));

} else {
var statearr_61048_61065 = state_61040__$1;
(statearr_61048_61065[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (9))){
var inst_61023 = (state_61040[(2)]);
var inst_61024 = fluree.db.util.async.throw_err.call(null,inst_61023);
var state_61040__$1 = state_61040;
var statearr_61049_61066 = state_61040__$1;
(statearr_61049_61066[(2)] = inst_61024);

(statearr_61049_61066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (5))){
var _ = (function (){var statearr_61050 = state_61040;
(statearr_61050[(4)] = cljs.core.rest.call(null,(state_61040[(4)])));

return statearr_61050;
})();
var state_61040__$1 = state_61040;
var ex61045 = (state_61040__$1[(2)]);
var statearr_61051_61067 = state_61040__$1;
(statearr_61051_61067[(5)] = ex61045);


if((ex61045 instanceof Error)){
var statearr_61052_61068 = state_61040__$1;
(statearr_61052_61068[(1)] = (4));

(statearr_61052_61068[(5)] = null);

} else {
throw ex61045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61041 === (8))){
var inst_61027 = (state_61040[(2)]);
var inst_61028 = fluree.db.dbfunctions.internal.inc.call(null,inst_61027);
var inst_61029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61030 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61031 = ["inc",inst_61027,inst_61028];
var inst_61032 = cljs.core.PersistentHashMap.fromArrays(inst_61030,inst_61031);
var inst_61033 = [inst_61032,(10)];
var inst_61034 = (new cljs.core.PersistentVector(null,2,(5),inst_61029,inst_61033,null));
var inst_61035 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61034);
var _ = (function (){var statearr_61053 = state_61040;
(statearr_61053[(4)] = cljs.core.rest.call(null,(state_61040[(4)])));

return statearr_61053;
})();
var state_61040__$1 = (function (){var statearr_61054 = state_61040;
(statearr_61054[(7)] = inst_61035);

return statearr_61054;
})();
var statearr_61055_61069 = state_61040__$1;
(statearr_61055_61069[(2)] = inst_61028);

(statearr_61055_61069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____0 = (function (){
var statearr_61056 = [null,null,null,null,null,null,null,null];
(statearr_61056[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__);

(statearr_61056[(1)] = (1));

return statearr_61056;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____1 = (function (state_61040){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61057){var ex__2457__auto__ = e61057;
var statearr_61058_61070 = state_61040;
(statearr_61058_61070[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61040[(4)]))){
var statearr_61059_61071 = state_61040;
(statearr_61059_61071[(1)] = cljs.core.first.call(null,(state_61040[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61072 = state_61040;
state_61040 = G__61072;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__ = function(state_61040){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____1.call(this,state_61040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61060 = f__2477__auto__.call(null);
(statearr_61060[(6)] = c__2476__auto__);

return statearr_61060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61099){
var state_val_61100 = (state_61099[(1)]);
if((state_val_61100 === (7))){
var state_61099__$1 = state_61099;
var statearr_61101_61120 = state_61099__$1;
(statearr_61101_61120[(2)] = n);

(statearr_61101_61120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (1))){
var state_61099__$1 = state_61099;
var statearr_61102_61121 = state_61099__$1;
(statearr_61102_61121[(2)] = null);

(statearr_61102_61121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (4))){
var inst_61073 = (state_61099[(2)]);
var state_61099__$1 = state_61099;
var statearr_61103_61122 = state_61099__$1;
(statearr_61103_61122[(2)] = inst_61073);

(statearr_61103_61122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (6))){
var state_61099__$1 = state_61099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61099__$1,(9),n);
} else {
if((state_val_61100 === (3))){
var inst_61097 = (state_61099[(2)]);
var state_61099__$1 = state_61099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61099__$1,inst_61097);
} else {
if((state_val_61100 === (2))){
var _ = (function (){var statearr_61105 = state_61099;
(statearr_61105[(4)] = cljs.core.cons.call(null,(5),(state_61099[(4)])));

return statearr_61105;
})();
var inst_61079 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_61099__$1 = state_61099;
if(inst_61079){
var statearr_61106_61123 = state_61099__$1;
(statearr_61106_61123[(1)] = (6));

} else {
var statearr_61107_61124 = state_61099__$1;
(statearr_61107_61124[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (9))){
var inst_61082 = (state_61099[(2)]);
var inst_61083 = fluree.db.util.async.throw_err.call(null,inst_61082);
var state_61099__$1 = state_61099;
var statearr_61108_61125 = state_61099__$1;
(statearr_61108_61125[(2)] = inst_61083);

(statearr_61108_61125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (5))){
var _ = (function (){var statearr_61109 = state_61099;
(statearr_61109[(4)] = cljs.core.rest.call(null,(state_61099[(4)])));

return statearr_61109;
})();
var state_61099__$1 = state_61099;
var ex61104 = (state_61099__$1[(2)]);
var statearr_61110_61126 = state_61099__$1;
(statearr_61110_61126[(5)] = ex61104);


if((ex61104 instanceof Error)){
var statearr_61111_61127 = state_61099__$1;
(statearr_61111_61127[(1)] = (4));

(statearr_61111_61127[(5)] = null);

} else {
throw ex61104;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61100 === (8))){
var inst_61086 = (state_61099[(2)]);
var inst_61087 = fluree.db.dbfunctions.internal.dec.call(null,inst_61086);
var inst_61088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61089 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61090 = ["dec",inst_61086,inst_61087];
var inst_61091 = cljs.core.PersistentHashMap.fromArrays(inst_61089,inst_61090);
var inst_61092 = [inst_61091,(10)];
var inst_61093 = (new cljs.core.PersistentVector(null,2,(5),inst_61088,inst_61092,null));
var inst_61094 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61093);
var _ = (function (){var statearr_61112 = state_61099;
(statearr_61112[(4)] = cljs.core.rest.call(null,(state_61099[(4)])));

return statearr_61112;
})();
var state_61099__$1 = (function (){var statearr_61113 = state_61099;
(statearr_61113[(7)] = inst_61094);

return statearr_61113;
})();
var statearr_61114_61128 = state_61099__$1;
(statearr_61114_61128[(2)] = inst_61087);

(statearr_61114_61128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____0 = (function (){
var statearr_61115 = [null,null,null,null,null,null,null,null];
(statearr_61115[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__);

(statearr_61115[(1)] = (1));

return statearr_61115;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____1 = (function (state_61099){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61116){var ex__2457__auto__ = e61116;
var statearr_61117_61129 = state_61099;
(statearr_61117_61129[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61099[(4)]))){
var statearr_61118_61130 = state_61099;
(statearr_61118_61130[(1)] = cljs.core.first.call(null,(state_61099[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61131 = state_61099;
state_61099 = G__61131;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__ = function(state_61099){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____1.call(this,state_61099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61119 = f__2477__auto__.call(null);
(statearr_61119[(6)] = c__2476__auto__);

return statearr_61119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61181 = arguments.length;
var i__4737__auto___61182 = (0);
while(true){
if((i__4737__auto___61182 < len__4736__auto___61181)){
args__4742__auto__.push((arguments[i__4737__auto___61182]));

var G__61183 = (i__4737__auto___61182 + (1));
i__4737__auto___61182 = G__61183;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61164){
var state_val_61165 = (state_61164[(1)]);
if((state_val_61165 === (1))){
var state_61164__$1 = state_61164;
var statearr_61166_61184 = state_61164__$1;
(statearr_61166_61184[(2)] = null);

(statearr_61166_61184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61165 === (2))){
var _ = (function (){var statearr_61167 = state_61164;
(statearr_61167[(4)] = cljs.core.cons.call(null,(5),(state_61164[(4)])));

return statearr_61167;
})();
var inst_61140 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_61164__$1 = state_61164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61164__$1,(6),inst_61140);
} else {
if((state_val_61165 === (3))){
var inst_61162 = (state_61164[(2)]);
var state_61164__$1 = state_61164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61164__$1,inst_61162);
} else {
if((state_val_61165 === (4))){
var inst_61134 = (state_61164[(2)]);
var state_61164__$1 = state_61164;
var statearr_61169_61185 = state_61164__$1;
(statearr_61169_61185[(2)] = inst_61134);

(statearr_61169_61185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61165 === (5))){
var _ = (function (){var statearr_61170 = state_61164;
(statearr_61170[(4)] = cljs.core.rest.call(null,(state_61164[(4)])));

return statearr_61170;
})();
var state_61164__$1 = state_61164;
var ex61168 = (state_61164__$1[(2)]);
var statearr_61171_61186 = state_61164__$1;
(statearr_61171_61186[(5)] = ex61168);


if((ex61168 instanceof Error)){
var statearr_61172_61187 = state_61164__$1;
(statearr_61172_61187[(1)] = (4));

(statearr_61172_61187[(5)] = null);

} else {
throw ex61168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61165 === (6))){
var inst_61142 = (state_61164[(2)]);
var inst_61143 = fluree.db.util.async.throw_err.call(null,inst_61142);
var inst_61144 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_61143);
var inst_61145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61146 = [inst_61143];
var inst_61147 = (new cljs.core.PersistentVector(null,1,(5),inst_61145,inst_61146,null));
var inst_61148 = cljs.core.count.call(null,inst_61147);
var inst_61149 = ((9) + inst_61148);
var inst_61150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61151 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61153 = [inst_61143];
var inst_61154 = (new cljs.core.PersistentVector(null,1,(5),inst_61152,inst_61153,null));
var inst_61155 = ["+",inst_61154,inst_61144];
var inst_61156 = cljs.core.PersistentHashMap.fromArrays(inst_61151,inst_61155);
var inst_61157 = [inst_61156,inst_61149];
var inst_61158 = (new cljs.core.PersistentVector(null,2,(5),inst_61150,inst_61157,null));
var inst_61159 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61158);
var _ = (function (){var statearr_61173 = state_61164;
(statearr_61173[(4)] = cljs.core.rest.call(null,(state_61164[(4)])));

return statearr_61173;
})();
var state_61164__$1 = (function (){var statearr_61174 = state_61164;
(statearr_61174[(7)] = inst_61159);

return statearr_61174;
})();
var statearr_61175_61188 = state_61164__$1;
(statearr_61175_61188[(2)] = inst_61144);

(statearr_61175_61188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_61176 = [null,null,null,null,null,null,null,null];
(statearr_61176[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_61176[(1)] = (1));

return statearr_61176;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_61164){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61177){var ex__2457__auto__ = e61177;
var statearr_61178_61189 = state_61164;
(statearr_61178_61189[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61164[(4)]))){
var statearr_61179_61190 = state_61164;
(statearr_61179_61190[(1)] = cljs.core.first.call(null,(state_61164[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61191 = state_61164;
state_61164 = G__61191;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_61164){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_61164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61180 = f__2477__auto__.call(null);
(statearr_61180[(6)] = c__2476__auto__);

return statearr_61180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq61132){
var G__61133 = cljs.core.first.call(null,seq61132);
var seq61132__$1 = cljs.core.next.call(null,seq61132);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61133,seq61132__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61241 = arguments.length;
var i__4737__auto___61242 = (0);
while(true){
if((i__4737__auto___61242 < len__4736__auto___61241)){
args__4742__auto__.push((arguments[i__4737__auto___61242]));

var G__61243 = (i__4737__auto___61242 + (1));
i__4737__auto___61242 = G__61243;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61224){
var state_val_61225 = (state_61224[(1)]);
if((state_val_61225 === (1))){
var state_61224__$1 = state_61224;
var statearr_61226_61244 = state_61224__$1;
(statearr_61226_61244[(2)] = null);

(statearr_61226_61244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61225 === (2))){
var _ = (function (){var statearr_61227 = state_61224;
(statearr_61227[(4)] = cljs.core.cons.call(null,(5),(state_61224[(4)])));

return statearr_61227;
})();
var inst_61200 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_61224__$1 = state_61224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61224__$1,(6),inst_61200);
} else {
if((state_val_61225 === (3))){
var inst_61222 = (state_61224[(2)]);
var state_61224__$1 = state_61224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61224__$1,inst_61222);
} else {
if((state_val_61225 === (4))){
var inst_61194 = (state_61224[(2)]);
var state_61224__$1 = state_61224;
var statearr_61229_61245 = state_61224__$1;
(statearr_61229_61245[(2)] = inst_61194);

(statearr_61229_61245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61225 === (5))){
var _ = (function (){var statearr_61230 = state_61224;
(statearr_61230[(4)] = cljs.core.rest.call(null,(state_61224[(4)])));

return statearr_61230;
})();
var state_61224__$1 = state_61224;
var ex61228 = (state_61224__$1[(2)]);
var statearr_61231_61246 = state_61224__$1;
(statearr_61231_61246[(5)] = ex61228);


if((ex61228 instanceof Error)){
var statearr_61232_61247 = state_61224__$1;
(statearr_61232_61247[(1)] = (4));

(statearr_61232_61247[(5)] = null);

} else {
throw ex61228;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61225 === (6))){
var inst_61202 = (state_61224[(2)]);
var inst_61203 = fluree.db.util.async.throw_err.call(null,inst_61202);
var inst_61204 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_61203);
var inst_61205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61206 = [inst_61203];
var inst_61207 = (new cljs.core.PersistentVector(null,1,(5),inst_61205,inst_61206,null));
var inst_61208 = cljs.core.count.call(null,inst_61207);
var inst_61209 = ((9) + inst_61208);
var inst_61210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61211 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61213 = [inst_61203];
var inst_61214 = (new cljs.core.PersistentVector(null,1,(5),inst_61212,inst_61213,null));
var inst_61215 = ["-",inst_61214,inst_61204];
var inst_61216 = cljs.core.PersistentHashMap.fromArrays(inst_61211,inst_61215);
var inst_61217 = [inst_61216,inst_61209];
var inst_61218 = (new cljs.core.PersistentVector(null,2,(5),inst_61210,inst_61217,null));
var inst_61219 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61218);
var _ = (function (){var statearr_61233 = state_61224;
(statearr_61233[(4)] = cljs.core.rest.call(null,(state_61224[(4)])));

return statearr_61233;
})();
var state_61224__$1 = (function (){var statearr_61234 = state_61224;
(statearr_61234[(7)] = inst_61219);

return statearr_61234;
})();
var statearr_61235_61248 = state_61224__$1;
(statearr_61235_61248[(2)] = inst_61204);

(statearr_61235_61248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_61236 = [null,null,null,null,null,null,null,null];
(statearr_61236[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_61236[(1)] = (1));

return statearr_61236;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_61224){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61237){var ex__2457__auto__ = e61237;
var statearr_61238_61249 = state_61224;
(statearr_61238_61249[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61224[(4)]))){
var statearr_61239_61250 = state_61224;
(statearr_61239_61250[(1)] = cljs.core.first.call(null,(state_61224[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61251 = state_61224;
state_61224 = G__61251;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_61224){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_61224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61240 = f__2477__auto__.call(null);
(statearr_61240[(6)] = c__2476__auto__);

return statearr_61240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq61192){
var G__61193 = cljs.core.first.call(null,seq61192);
var seq61192__$1 = cljs.core.next.call(null,seq61192);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61193,seq61192__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61301 = arguments.length;
var i__4737__auto___61302 = (0);
while(true){
if((i__4737__auto___61302 < len__4736__auto___61301)){
args__4742__auto__.push((arguments[i__4737__auto___61302]));

var G__61303 = (i__4737__auto___61302 + (1));
i__4737__auto___61302 = G__61303;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61284){
var state_val_61285 = (state_61284[(1)]);
if((state_val_61285 === (1))){
var state_61284__$1 = state_61284;
var statearr_61286_61304 = state_61284__$1;
(statearr_61286_61304[(2)] = null);

(statearr_61286_61304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61285 === (2))){
var _ = (function (){var statearr_61287 = state_61284;
(statearr_61287[(4)] = cljs.core.cons.call(null,(5),(state_61284[(4)])));

return statearr_61287;
})();
var inst_61260 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_61284__$1 = state_61284;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61284__$1,(6),inst_61260);
} else {
if((state_val_61285 === (3))){
var inst_61282 = (state_61284[(2)]);
var state_61284__$1 = state_61284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61284__$1,inst_61282);
} else {
if((state_val_61285 === (4))){
var inst_61254 = (state_61284[(2)]);
var state_61284__$1 = state_61284;
var statearr_61289_61305 = state_61284__$1;
(statearr_61289_61305[(2)] = inst_61254);

(statearr_61289_61305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61285 === (5))){
var _ = (function (){var statearr_61290 = state_61284;
(statearr_61290[(4)] = cljs.core.rest.call(null,(state_61284[(4)])));

return statearr_61290;
})();
var state_61284__$1 = state_61284;
var ex61288 = (state_61284__$1[(2)]);
var statearr_61291_61306 = state_61284__$1;
(statearr_61291_61306[(5)] = ex61288);


if((ex61288 instanceof Error)){
var statearr_61292_61307 = state_61284__$1;
(statearr_61292_61307[(1)] = (4));

(statearr_61292_61307[(5)] = null);

} else {
throw ex61288;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61285 === (6))){
var inst_61262 = (state_61284[(2)]);
var inst_61263 = fluree.db.util.async.throw_err.call(null,inst_61262);
var inst_61264 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_61263);
var inst_61265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61266 = [inst_61263];
var inst_61267 = (new cljs.core.PersistentVector(null,1,(5),inst_61265,inst_61266,null));
var inst_61268 = cljs.core.count.call(null,inst_61267);
var inst_61269 = ((9) + inst_61268);
var inst_61270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61271 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61273 = [inst_61263];
var inst_61274 = (new cljs.core.PersistentVector(null,1,(5),inst_61272,inst_61273,null));
var inst_61275 = ["*",inst_61274,inst_61264];
var inst_61276 = cljs.core.PersistentHashMap.fromArrays(inst_61271,inst_61275);
var inst_61277 = [inst_61276,inst_61269];
var inst_61278 = (new cljs.core.PersistentVector(null,2,(5),inst_61270,inst_61277,null));
var inst_61279 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61278);
var _ = (function (){var statearr_61293 = state_61284;
(statearr_61293[(4)] = cljs.core.rest.call(null,(state_61284[(4)])));

return statearr_61293;
})();
var state_61284__$1 = (function (){var statearr_61294 = state_61284;
(statearr_61294[(7)] = inst_61279);

return statearr_61294;
})();
var statearr_61295_61308 = state_61284__$1;
(statearr_61295_61308[(2)] = inst_61264);

(statearr_61295_61308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_61296 = [null,null,null,null,null,null,null,null];
(statearr_61296[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_61296[(1)] = (1));

return statearr_61296;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_61284){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61297){var ex__2457__auto__ = e61297;
var statearr_61298_61309 = state_61284;
(statearr_61298_61309[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61284[(4)]))){
var statearr_61299_61310 = state_61284;
(statearr_61299_61310[(1)] = cljs.core.first.call(null,(state_61284[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61311 = state_61284;
state_61284 = G__61311;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_61284){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_61284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61300 = f__2477__auto__.call(null);
(statearr_61300[(6)] = c__2476__auto__);

return statearr_61300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq61252){
var G__61253 = cljs.core.first.call(null,seq61252);
var seq61252__$1 = cljs.core.next.call(null,seq61252);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61253,seq61252__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61361 = arguments.length;
var i__4737__auto___61362 = (0);
while(true){
if((i__4737__auto___61362 < len__4736__auto___61361)){
args__4742__auto__.push((arguments[i__4737__auto___61362]));

var G__61363 = (i__4737__auto___61362 + (1));
i__4737__auto___61362 = G__61363;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61344){
var state_val_61345 = (state_61344[(1)]);
if((state_val_61345 === (1))){
var state_61344__$1 = state_61344;
var statearr_61346_61364 = state_61344__$1;
(statearr_61346_61364[(2)] = null);

(statearr_61346_61364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61345 === (2))){
var _ = (function (){var statearr_61347 = state_61344;
(statearr_61347[(4)] = cljs.core.cons.call(null,(5),(state_61344[(4)])));

return statearr_61347;
})();
var inst_61320 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_61344__$1 = state_61344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61344__$1,(6),inst_61320);
} else {
if((state_val_61345 === (3))){
var inst_61342 = (state_61344[(2)]);
var state_61344__$1 = state_61344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61344__$1,inst_61342);
} else {
if((state_val_61345 === (4))){
var inst_61314 = (state_61344[(2)]);
var state_61344__$1 = state_61344;
var statearr_61349_61365 = state_61344__$1;
(statearr_61349_61365[(2)] = inst_61314);

(statearr_61349_61365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61345 === (5))){
var _ = (function (){var statearr_61350 = state_61344;
(statearr_61350[(4)] = cljs.core.rest.call(null,(state_61344[(4)])));

return statearr_61350;
})();
var state_61344__$1 = state_61344;
var ex61348 = (state_61344__$1[(2)]);
var statearr_61351_61366 = state_61344__$1;
(statearr_61351_61366[(5)] = ex61348);


if((ex61348 instanceof Error)){
var statearr_61352_61367 = state_61344__$1;
(statearr_61352_61367[(1)] = (4));

(statearr_61352_61367[(5)] = null);

} else {
throw ex61348;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61345 === (6))){
var inst_61322 = (state_61344[(2)]);
var inst_61323 = fluree.db.util.async.throw_err.call(null,inst_61322);
var inst_61324 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_61323);
var inst_61325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61326 = [inst_61323];
var inst_61327 = (new cljs.core.PersistentVector(null,1,(5),inst_61325,inst_61326,null));
var inst_61328 = cljs.core.count.call(null,inst_61327);
var inst_61329 = ((9) + inst_61328);
var inst_61330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61331 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61333 = [inst_61323];
var inst_61334 = (new cljs.core.PersistentVector(null,1,(5),inst_61332,inst_61333,null));
var inst_61335 = ["/",inst_61334,inst_61324];
var inst_61336 = cljs.core.PersistentHashMap.fromArrays(inst_61331,inst_61335);
var inst_61337 = [inst_61336,inst_61329];
var inst_61338 = (new cljs.core.PersistentVector(null,2,(5),inst_61330,inst_61337,null));
var inst_61339 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61338);
var _ = (function (){var statearr_61353 = state_61344;
(statearr_61353[(4)] = cljs.core.rest.call(null,(state_61344[(4)])));

return statearr_61353;
})();
var state_61344__$1 = (function (){var statearr_61354 = state_61344;
(statearr_61354[(7)] = inst_61339);

return statearr_61354;
})();
var statearr_61355_61368 = state_61344__$1;
(statearr_61355_61368[(2)] = inst_61324);

(statearr_61355_61368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_61356 = [null,null,null,null,null,null,null,null];
(statearr_61356[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_61356[(1)] = (1));

return statearr_61356;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_61344){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61357){var ex__2457__auto__ = e61357;
var statearr_61358_61369 = state_61344;
(statearr_61358_61369[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61344[(4)]))){
var statearr_61359_61370 = state_61344;
(statearr_61359_61370[(1)] = cljs.core.first.call(null,(state_61344[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61371 = state_61344;
state_61344 = G__61371;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_61344){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_61344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61360 = f__2477__auto__.call(null);
(statearr_61360[(6)] = c__2476__auto__);

return statearr_61360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq61312){
var G__61313 = cljs.core.first.call(null,seq61312);
var seq61312__$1 = cljs.core.next.call(null,seq61312);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61313,seq61312__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61409){
var state_val_61410 = (state_61409[(1)]);
if((state_val_61410 === (7))){
var state_61409__$1 = state_61409;
var statearr_61411_61435 = state_61409__$1;
(statearr_61411_61435[(2)] = n);

(statearr_61411_61435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (1))){
var state_61409__$1 = state_61409;
var statearr_61412_61436 = state_61409__$1;
(statearr_61412_61436[(2)] = null);

(statearr_61412_61436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (4))){
var inst_61372 = (state_61409[(2)]);
var state_61409__$1 = state_61409;
var statearr_61413_61437 = state_61409__$1;
(statearr_61413_61437[(2)] = inst_61372);

(statearr_61413_61437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (13))){
var inst_61389 = (state_61409[(2)]);
var inst_61390 = fluree.db.util.async.throw_err.call(null,inst_61389);
var state_61409__$1 = state_61409;
var statearr_61414_61438 = state_61409__$1;
(statearr_61414_61438[(2)] = inst_61390);

(statearr_61414_61438[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (6))){
var state_61409__$1 = state_61409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61409__$1,(9),n);
} else {
if((state_val_61410 === (3))){
var inst_61407 = (state_61409[(2)]);
var state_61409__$1 = state_61409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61409__$1,inst_61407);
} else {
if((state_val_61410 === (12))){
var inst_61385 = (state_61409[(7)]);
var inst_61393 = (state_61409[(2)]);
var inst_61394 = fluree.db.dbfunctions.internal.quot.call(null,inst_61385,inst_61393);
var inst_61395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61396 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61398 = [inst_61385,inst_61393];
var inst_61399 = (new cljs.core.PersistentVector(null,2,(5),inst_61397,inst_61398,null));
var inst_61400 = ["quot",inst_61399,inst_61394];
var inst_61401 = cljs.core.PersistentHashMap.fromArrays(inst_61396,inst_61400);
var inst_61402 = [inst_61401,(2)];
var inst_61403 = (new cljs.core.PersistentVector(null,2,(5),inst_61395,inst_61402,null));
var inst_61404 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61403);
var _ = (function (){var statearr_61415 = state_61409;
(statearr_61415[(4)] = cljs.core.rest.call(null,(state_61409[(4)])));

return statearr_61415;
})();
var state_61409__$1 = (function (){var statearr_61416 = state_61409;
(statearr_61416[(8)] = inst_61404);

return statearr_61416;
})();
var statearr_61417_61439 = state_61409__$1;
(statearr_61417_61439[(2)] = inst_61394);

(statearr_61417_61439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (2))){
var _ = (function (){var statearr_61418 = state_61409;
(statearr_61418[(4)] = cljs.core.cons.call(null,(5),(state_61409[(4)])));

return statearr_61418;
})();
var inst_61378 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_61409__$1 = state_61409;
if(inst_61378){
var statearr_61419_61440 = state_61409__$1;
(statearr_61419_61440[(1)] = (6));

} else {
var statearr_61420_61441 = state_61409__$1;
(statearr_61420_61441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (11))){
var state_61409__$1 = state_61409;
var statearr_61422_61442 = state_61409__$1;
(statearr_61422_61442[(2)] = d);

(statearr_61422_61442[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (9))){
var inst_61381 = (state_61409[(2)]);
var inst_61382 = fluree.db.util.async.throw_err.call(null,inst_61381);
var state_61409__$1 = state_61409;
var statearr_61423_61443 = state_61409__$1;
(statearr_61423_61443[(2)] = inst_61382);

(statearr_61423_61443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (5))){
var _ = (function (){var statearr_61424 = state_61409;
(statearr_61424[(4)] = cljs.core.rest.call(null,(state_61409[(4)])));

return statearr_61424;
})();
var state_61409__$1 = state_61409;
var ex61421 = (state_61409__$1[(2)]);
var statearr_61425_61444 = state_61409__$1;
(statearr_61425_61444[(5)] = ex61421);


if((ex61421 instanceof Error)){
var statearr_61426_61445 = state_61409__$1;
(statearr_61426_61445[(1)] = (4));

(statearr_61426_61445[(5)] = null);

} else {
throw ex61421;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61410 === (10))){
var state_61409__$1 = state_61409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61409__$1,(13),d);
} else {
if((state_val_61410 === (8))){
var inst_61385 = (state_61409[(2)]);
var inst_61386 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_61409__$1 = (function (){var statearr_61427 = state_61409;
(statearr_61427[(7)] = inst_61385);

return statearr_61427;
})();
if(inst_61386){
var statearr_61428_61446 = state_61409__$1;
(statearr_61428_61446[(1)] = (10));

} else {
var statearr_61429_61447 = state_61409__$1;
(statearr_61429_61447[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____0 = (function (){
var statearr_61430 = [null,null,null,null,null,null,null,null,null];
(statearr_61430[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__);

(statearr_61430[(1)] = (1));

return statearr_61430;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____1 = (function (state_61409){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61431){var ex__2457__auto__ = e61431;
var statearr_61432_61448 = state_61409;
(statearr_61432_61448[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61409[(4)]))){
var statearr_61433_61449 = state_61409;
(statearr_61433_61449[(1)] = cljs.core.first.call(null,(state_61409[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61450 = state_61409;
state_61409 = G__61450;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__ = function(state_61409){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____1.call(this,state_61409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61434 = f__2477__auto__.call(null);
(statearr_61434[(6)] = c__2476__auto__);

return statearr_61434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61488){
var state_val_61489 = (state_61488[(1)]);
if((state_val_61489 === (7))){
var state_61488__$1 = state_61488;
var statearr_61490_61514 = state_61488__$1;
(statearr_61490_61514[(2)] = n);

(statearr_61490_61514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (1))){
var state_61488__$1 = state_61488;
var statearr_61491_61515 = state_61488__$1;
(statearr_61491_61515[(2)] = null);

(statearr_61491_61515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (4))){
var inst_61451 = (state_61488[(2)]);
var state_61488__$1 = state_61488;
var statearr_61492_61516 = state_61488__$1;
(statearr_61492_61516[(2)] = inst_61451);

(statearr_61492_61516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (13))){
var inst_61468 = (state_61488[(2)]);
var inst_61469 = fluree.db.util.async.throw_err.call(null,inst_61468);
var state_61488__$1 = state_61488;
var statearr_61493_61517 = state_61488__$1;
(statearr_61493_61517[(2)] = inst_61469);

(statearr_61493_61517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (6))){
var state_61488__$1 = state_61488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61488__$1,(9),n);
} else {
if((state_val_61489 === (3))){
var inst_61486 = (state_61488[(2)]);
var state_61488__$1 = state_61488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61488__$1,inst_61486);
} else {
if((state_val_61489 === (12))){
var inst_61464 = (state_61488[(7)]);
var inst_61472 = (state_61488[(2)]);
var inst_61473 = fluree.db.dbfunctions.internal.mod.call(null,inst_61464,inst_61472);
var inst_61474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61475 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61477 = [inst_61464,inst_61472];
var inst_61478 = (new cljs.core.PersistentVector(null,2,(5),inst_61476,inst_61477,null));
var inst_61479 = ["mod",inst_61478,inst_61473];
var inst_61480 = cljs.core.PersistentHashMap.fromArrays(inst_61475,inst_61479);
var inst_61481 = [inst_61480,(2)];
var inst_61482 = (new cljs.core.PersistentVector(null,2,(5),inst_61474,inst_61481,null));
var inst_61483 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61482);
var _ = (function (){var statearr_61494 = state_61488;
(statearr_61494[(4)] = cljs.core.rest.call(null,(state_61488[(4)])));

return statearr_61494;
})();
var state_61488__$1 = (function (){var statearr_61495 = state_61488;
(statearr_61495[(8)] = inst_61483);

return statearr_61495;
})();
var statearr_61496_61518 = state_61488__$1;
(statearr_61496_61518[(2)] = inst_61473);

(statearr_61496_61518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (2))){
var _ = (function (){var statearr_61497 = state_61488;
(statearr_61497[(4)] = cljs.core.cons.call(null,(5),(state_61488[(4)])));

return statearr_61497;
})();
var inst_61457 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_61488__$1 = state_61488;
if(inst_61457){
var statearr_61498_61519 = state_61488__$1;
(statearr_61498_61519[(1)] = (6));

} else {
var statearr_61499_61520 = state_61488__$1;
(statearr_61499_61520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (11))){
var state_61488__$1 = state_61488;
var statearr_61501_61521 = state_61488__$1;
(statearr_61501_61521[(2)] = d);

(statearr_61501_61521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (9))){
var inst_61460 = (state_61488[(2)]);
var inst_61461 = fluree.db.util.async.throw_err.call(null,inst_61460);
var state_61488__$1 = state_61488;
var statearr_61502_61522 = state_61488__$1;
(statearr_61502_61522[(2)] = inst_61461);

(statearr_61502_61522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (5))){
var _ = (function (){var statearr_61503 = state_61488;
(statearr_61503[(4)] = cljs.core.rest.call(null,(state_61488[(4)])));

return statearr_61503;
})();
var state_61488__$1 = state_61488;
var ex61500 = (state_61488__$1[(2)]);
var statearr_61504_61523 = state_61488__$1;
(statearr_61504_61523[(5)] = ex61500);


if((ex61500 instanceof Error)){
var statearr_61505_61524 = state_61488__$1;
(statearr_61505_61524[(1)] = (4));

(statearr_61505_61524[(5)] = null);

} else {
throw ex61500;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61489 === (10))){
var state_61488__$1 = state_61488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61488__$1,(13),d);
} else {
if((state_val_61489 === (8))){
var inst_61464 = (state_61488[(2)]);
var inst_61465 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_61488__$1 = (function (){var statearr_61506 = state_61488;
(statearr_61506[(7)] = inst_61464);

return statearr_61506;
})();
if(inst_61465){
var statearr_61507_61525 = state_61488__$1;
(statearr_61507_61525[(1)] = (10));

} else {
var statearr_61508_61526 = state_61488__$1;
(statearr_61508_61526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____0 = (function (){
var statearr_61509 = [null,null,null,null,null,null,null,null,null];
(statearr_61509[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__);

(statearr_61509[(1)] = (1));

return statearr_61509;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____1 = (function (state_61488){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61510){var ex__2457__auto__ = e61510;
var statearr_61511_61527 = state_61488;
(statearr_61511_61527[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61488[(4)]))){
var statearr_61512_61528 = state_61488;
(statearr_61512_61528[(1)] = cljs.core.first.call(null,(state_61488[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61529 = state_61488;
state_61488 = G__61529;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__ = function(state_61488){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____1.call(this,state_61488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61513 = f__2477__auto__.call(null);
(statearr_61513[(6)] = c__2476__auto__);

return statearr_61513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61567){
var state_val_61568 = (state_61567[(1)]);
if((state_val_61568 === (7))){
var state_61567__$1 = state_61567;
var statearr_61569_61593 = state_61567__$1;
(statearr_61569_61593[(2)] = n);

(statearr_61569_61593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (1))){
var state_61567__$1 = state_61567;
var statearr_61570_61594 = state_61567__$1;
(statearr_61570_61594[(2)] = null);

(statearr_61570_61594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (4))){
var inst_61530 = (state_61567[(2)]);
var state_61567__$1 = state_61567;
var statearr_61571_61595 = state_61567__$1;
(statearr_61571_61595[(2)] = inst_61530);

(statearr_61571_61595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (13))){
var inst_61547 = (state_61567[(2)]);
var inst_61548 = fluree.db.util.async.throw_err.call(null,inst_61547);
var state_61567__$1 = state_61567;
var statearr_61572_61596 = state_61567__$1;
(statearr_61572_61596[(2)] = inst_61548);

(statearr_61572_61596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (6))){
var state_61567__$1 = state_61567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61567__$1,(9),n);
} else {
if((state_val_61568 === (3))){
var inst_61565 = (state_61567[(2)]);
var state_61567__$1 = state_61567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61567__$1,inst_61565);
} else {
if((state_val_61568 === (12))){
var inst_61543 = (state_61567[(7)]);
var inst_61551 = (state_61567[(2)]);
var inst_61552 = fluree.db.dbfunctions.internal.rem.call(null,inst_61543,inst_61551);
var inst_61553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61554 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61556 = [inst_61543,inst_61551];
var inst_61557 = (new cljs.core.PersistentVector(null,2,(5),inst_61555,inst_61556,null));
var inst_61558 = ["rem",inst_61557,inst_61552];
var inst_61559 = cljs.core.PersistentHashMap.fromArrays(inst_61554,inst_61558);
var inst_61560 = [inst_61559,(2)];
var inst_61561 = (new cljs.core.PersistentVector(null,2,(5),inst_61553,inst_61560,null));
var inst_61562 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61561);
var _ = (function (){var statearr_61573 = state_61567;
(statearr_61573[(4)] = cljs.core.rest.call(null,(state_61567[(4)])));

return statearr_61573;
})();
var state_61567__$1 = (function (){var statearr_61574 = state_61567;
(statearr_61574[(8)] = inst_61562);

return statearr_61574;
})();
var statearr_61575_61597 = state_61567__$1;
(statearr_61575_61597[(2)] = inst_61552);

(statearr_61575_61597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (2))){
var _ = (function (){var statearr_61576 = state_61567;
(statearr_61576[(4)] = cljs.core.cons.call(null,(5),(state_61567[(4)])));

return statearr_61576;
})();
var inst_61536 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_61567__$1 = state_61567;
if(inst_61536){
var statearr_61577_61598 = state_61567__$1;
(statearr_61577_61598[(1)] = (6));

} else {
var statearr_61578_61599 = state_61567__$1;
(statearr_61578_61599[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (11))){
var state_61567__$1 = state_61567;
var statearr_61580_61600 = state_61567__$1;
(statearr_61580_61600[(2)] = d);

(statearr_61580_61600[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (9))){
var inst_61539 = (state_61567[(2)]);
var inst_61540 = fluree.db.util.async.throw_err.call(null,inst_61539);
var state_61567__$1 = state_61567;
var statearr_61581_61601 = state_61567__$1;
(statearr_61581_61601[(2)] = inst_61540);

(statearr_61581_61601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (5))){
var _ = (function (){var statearr_61582 = state_61567;
(statearr_61582[(4)] = cljs.core.rest.call(null,(state_61567[(4)])));

return statearr_61582;
})();
var state_61567__$1 = state_61567;
var ex61579 = (state_61567__$1[(2)]);
var statearr_61583_61602 = state_61567__$1;
(statearr_61583_61602[(5)] = ex61579);


if((ex61579 instanceof Error)){
var statearr_61584_61603 = state_61567__$1;
(statearr_61584_61603[(1)] = (4));

(statearr_61584_61603[(5)] = null);

} else {
throw ex61579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61568 === (10))){
var state_61567__$1 = state_61567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61567__$1,(13),d);
} else {
if((state_val_61568 === (8))){
var inst_61543 = (state_61567[(2)]);
var inst_61544 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_61567__$1 = (function (){var statearr_61585 = state_61567;
(statearr_61585[(7)] = inst_61543);

return statearr_61585;
})();
if(inst_61544){
var statearr_61586_61604 = state_61567__$1;
(statearr_61586_61604[(1)] = (10));

} else {
var statearr_61587_61605 = state_61567__$1;
(statearr_61587_61605[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____0 = (function (){
var statearr_61588 = [null,null,null,null,null,null,null,null,null];
(statearr_61588[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__);

(statearr_61588[(1)] = (1));

return statearr_61588;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____1 = (function (state_61567){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61589){var ex__2457__auto__ = e61589;
var statearr_61590_61606 = state_61567;
(statearr_61590_61606[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61567[(4)]))){
var statearr_61591_61607 = state_61567;
(statearr_61591_61607[(1)] = cljs.core.first.call(null,(state_61567[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61608 = state_61567;
state_61567 = G__61608;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__ = function(state_61567){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____1.call(this,state_61567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61592 = f__2477__auto__.call(null);
(statearr_61592[(6)] = c__2476__auto__);

return statearr_61592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61635){
var state_val_61636 = (state_61635[(1)]);
if((state_val_61636 === (7))){
var state_61635__$1 = state_61635;
var statearr_61637_61656 = state_61635__$1;
(statearr_61637_61656[(2)] = x);

(statearr_61637_61656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (1))){
var state_61635__$1 = state_61635;
var statearr_61638_61657 = state_61635__$1;
(statearr_61638_61657[(2)] = null);

(statearr_61638_61657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (4))){
var inst_61609 = (state_61635[(2)]);
var state_61635__$1 = state_61635;
var statearr_61639_61658 = state_61635__$1;
(statearr_61639_61658[(2)] = inst_61609);

(statearr_61639_61658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (6))){
var state_61635__$1 = state_61635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61635__$1,(9),x);
} else {
if((state_val_61636 === (3))){
var inst_61633 = (state_61635[(2)]);
var state_61635__$1 = state_61635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61635__$1,inst_61633);
} else {
if((state_val_61636 === (2))){
var _ = (function (){var statearr_61641 = state_61635;
(statearr_61641[(4)] = cljs.core.cons.call(null,(5),(state_61635[(4)])));

return statearr_61641;
})();
var inst_61615 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_61635__$1 = state_61635;
if(inst_61615){
var statearr_61642_61659 = state_61635__$1;
(statearr_61642_61659[(1)] = (6));

} else {
var statearr_61643_61660 = state_61635__$1;
(statearr_61643_61660[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (9))){
var inst_61618 = (state_61635[(2)]);
var inst_61619 = fluree.db.util.async.throw_err.call(null,inst_61618);
var state_61635__$1 = state_61635;
var statearr_61644_61661 = state_61635__$1;
(statearr_61644_61661[(2)] = inst_61619);

(statearr_61644_61661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (5))){
var _ = (function (){var statearr_61645 = state_61635;
(statearr_61645[(4)] = cljs.core.rest.call(null,(state_61635[(4)])));

return statearr_61645;
})();
var state_61635__$1 = state_61635;
var ex61640 = (state_61635__$1[(2)]);
var statearr_61646_61662 = state_61635__$1;
(statearr_61646_61662[(5)] = ex61640);


if((ex61640 instanceof Error)){
var statearr_61647_61663 = state_61635__$1;
(statearr_61647_61663[(1)] = (4));

(statearr_61647_61663[(5)] = null);

} else {
throw ex61640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61636 === (8))){
var inst_61622 = (state_61635[(2)]);
var inst_61623 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_61622);
var inst_61624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61625 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61626 = ["boolean",inst_61622,inst_61623];
var inst_61627 = cljs.core.PersistentHashMap.fromArrays(inst_61625,inst_61626);
var inst_61628 = [inst_61627,(10)];
var inst_61629 = (new cljs.core.PersistentVector(null,2,(5),inst_61624,inst_61628,null));
var inst_61630 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61629);
var _ = (function (){var statearr_61648 = state_61635;
(statearr_61648[(4)] = cljs.core.rest.call(null,(state_61635[(4)])));

return statearr_61648;
})();
var state_61635__$1 = (function (){var statearr_61649 = state_61635;
(statearr_61649[(7)] = inst_61630);

return statearr_61649;
})();
var statearr_61650_61664 = state_61635__$1;
(statearr_61650_61664[(2)] = inst_61623);

(statearr_61650_61664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____0 = (function (){
var statearr_61651 = [null,null,null,null,null,null,null,null];
(statearr_61651[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__);

(statearr_61651[(1)] = (1));

return statearr_61651;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____1 = (function (state_61635){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61652){var ex__2457__auto__ = e61652;
var statearr_61653_61665 = state_61635;
(statearr_61653_61665[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61635[(4)]))){
var statearr_61654_61666 = state_61635;
(statearr_61654_61666[(1)] = cljs.core.first.call(null,(state_61635[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61667 = state_61635;
state_61635 = G__61667;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__ = function(state_61635){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____1.call(this,state_61635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61655 = f__2477__auto__.call(null);
(statearr_61655[(6)] = c__2476__auto__);

return statearr_61655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61705){
var state_val_61706 = (state_61705[(1)]);
if((state_val_61706 === (7))){
var state_61705__$1 = state_61705;
var statearr_61707_61731 = state_61705__$1;
(statearr_61707_61731[(2)] = pattern);

(statearr_61707_61731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (1))){
var state_61705__$1 = state_61705;
var statearr_61708_61732 = state_61705__$1;
(statearr_61708_61732[(2)] = null);

(statearr_61708_61732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (4))){
var inst_61668 = (state_61705[(2)]);
var state_61705__$1 = state_61705;
var statearr_61709_61733 = state_61705__$1;
(statearr_61709_61733[(2)] = inst_61668);

(statearr_61709_61733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (13))){
var inst_61685 = (state_61705[(2)]);
var inst_61686 = fluree.db.util.async.throw_err.call(null,inst_61685);
var state_61705__$1 = state_61705;
var statearr_61710_61734 = state_61705__$1;
(statearr_61710_61734[(2)] = inst_61686);

(statearr_61710_61734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (6))){
var state_61705__$1 = state_61705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61705__$1,(9),pattern);
} else {
if((state_val_61706 === (3))){
var inst_61703 = (state_61705[(2)]);
var state_61705__$1 = state_61705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61705__$1,inst_61703);
} else {
if((state_val_61706 === (12))){
var inst_61681 = (state_61705[(7)]);
var inst_61689 = (state_61705[(2)]);
var inst_61690 = fluree.db.dbfunctions.internal.re_find.call(null,inst_61681,inst_61689);
var inst_61691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61692 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61694 = [inst_61681,inst_61689];
var inst_61695 = (new cljs.core.PersistentVector(null,2,(5),inst_61693,inst_61694,null));
var inst_61696 = ["re-find",inst_61695,inst_61690];
var inst_61697 = cljs.core.PersistentHashMap.fromArrays(inst_61692,inst_61696);
var inst_61698 = [inst_61697,(10)];
var inst_61699 = (new cljs.core.PersistentVector(null,2,(5),inst_61691,inst_61698,null));
var inst_61700 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61699);
var _ = (function (){var statearr_61711 = state_61705;
(statearr_61711[(4)] = cljs.core.rest.call(null,(state_61705[(4)])));

return statearr_61711;
})();
var state_61705__$1 = (function (){var statearr_61712 = state_61705;
(statearr_61712[(8)] = inst_61700);

return statearr_61712;
})();
var statearr_61713_61735 = state_61705__$1;
(statearr_61713_61735[(2)] = inst_61690);

(statearr_61713_61735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (2))){
var _ = (function (){var statearr_61714 = state_61705;
(statearr_61714[(4)] = cljs.core.cons.call(null,(5),(state_61705[(4)])));

return statearr_61714;
})();
var inst_61674 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_61705__$1 = state_61705;
if(inst_61674){
var statearr_61715_61736 = state_61705__$1;
(statearr_61715_61736[(1)] = (6));

} else {
var statearr_61716_61737 = state_61705__$1;
(statearr_61716_61737[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (11))){
var state_61705__$1 = state_61705;
var statearr_61718_61738 = state_61705__$1;
(statearr_61718_61738[(2)] = string);

(statearr_61718_61738[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (9))){
var inst_61677 = (state_61705[(2)]);
var inst_61678 = fluree.db.util.async.throw_err.call(null,inst_61677);
var state_61705__$1 = state_61705;
var statearr_61719_61739 = state_61705__$1;
(statearr_61719_61739[(2)] = inst_61678);

(statearr_61719_61739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (5))){
var _ = (function (){var statearr_61720 = state_61705;
(statearr_61720[(4)] = cljs.core.rest.call(null,(state_61705[(4)])));

return statearr_61720;
})();
var state_61705__$1 = state_61705;
var ex61717 = (state_61705__$1[(2)]);
var statearr_61721_61740 = state_61705__$1;
(statearr_61721_61740[(5)] = ex61717);


if((ex61717 instanceof Error)){
var statearr_61722_61741 = state_61705__$1;
(statearr_61722_61741[(1)] = (4));

(statearr_61722_61741[(5)] = null);

} else {
throw ex61717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61706 === (10))){
var state_61705__$1 = state_61705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61705__$1,(13),string);
} else {
if((state_val_61706 === (8))){
var inst_61681 = (state_61705[(2)]);
var inst_61682 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_61705__$1 = (function (){var statearr_61723 = state_61705;
(statearr_61723[(7)] = inst_61681);

return statearr_61723;
})();
if(inst_61682){
var statearr_61724_61742 = state_61705__$1;
(statearr_61724_61742[(1)] = (10));

} else {
var statearr_61725_61743 = state_61705__$1;
(statearr_61725_61743[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____0 = (function (){
var statearr_61726 = [null,null,null,null,null,null,null,null,null];
(statearr_61726[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__);

(statearr_61726[(1)] = (1));

return statearr_61726;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____1 = (function (state_61705){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61727){var ex__2457__auto__ = e61727;
var statearr_61728_61744 = state_61705;
(statearr_61728_61744[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61705[(4)]))){
var statearr_61729_61745 = state_61705;
(statearr_61729_61745[(1)] = cljs.core.first.call(null,(state_61705[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61746 = state_61705;
state_61705 = G__61746;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__ = function(state_61705){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____1.call(this,state_61705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61730 = f__2477__auto__.call(null);
(statearr_61730[(6)] = c__2476__auto__);

return statearr_61730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61773){
var state_val_61774 = (state_61773[(1)]);
if((state_val_61774 === (7))){
var state_61773__$1 = state_61773;
var statearr_61775_61794 = state_61773__$1;
(statearr_61775_61794[(2)] = email);

(statearr_61775_61794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (1))){
var state_61773__$1 = state_61773;
var statearr_61776_61795 = state_61773__$1;
(statearr_61776_61795[(2)] = null);

(statearr_61776_61795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (4))){
var inst_61747 = (state_61773[(2)]);
var state_61773__$1 = state_61773;
var statearr_61777_61796 = state_61773__$1;
(statearr_61777_61796[(2)] = inst_61747);

(statearr_61777_61796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (6))){
var state_61773__$1 = state_61773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61773__$1,(9),email);
} else {
if((state_val_61774 === (3))){
var inst_61771 = (state_61773[(2)]);
var state_61773__$1 = state_61773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61773__$1,inst_61771);
} else {
if((state_val_61774 === (2))){
var _ = (function (){var statearr_61779 = state_61773;
(statearr_61779[(4)] = cljs.core.cons.call(null,(5),(state_61773[(4)])));

return statearr_61779;
})();
var inst_61753 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_61773__$1 = state_61773;
if(inst_61753){
var statearr_61780_61797 = state_61773__$1;
(statearr_61780_61797[(1)] = (6));

} else {
var statearr_61781_61798 = state_61773__$1;
(statearr_61781_61798[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (9))){
var inst_61756 = (state_61773[(2)]);
var inst_61757 = fluree.db.util.async.throw_err.call(null,inst_61756);
var state_61773__$1 = state_61773;
var statearr_61782_61799 = state_61773__$1;
(statearr_61782_61799[(2)] = inst_61757);

(statearr_61782_61799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (5))){
var _ = (function (){var statearr_61783 = state_61773;
(statearr_61783[(4)] = cljs.core.rest.call(null,(state_61773[(4)])));

return statearr_61783;
})();
var state_61773__$1 = state_61773;
var ex61778 = (state_61773__$1[(2)]);
var statearr_61784_61800 = state_61773__$1;
(statearr_61784_61800[(5)] = ex61778);


if((ex61778 instanceof Error)){
var statearr_61785_61801 = state_61773__$1;
(statearr_61785_61801[(1)] = (4));

(statearr_61785_61801[(5)] = null);

} else {
throw ex61778;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61774 === (8))){
var inst_61760 = (state_61773[(2)]);
var inst_61761 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_61760);
var inst_61762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61763 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61764 = ["re-find",inst_61760,inst_61761];
var inst_61765 = cljs.core.PersistentHashMap.fromArrays(inst_61763,inst_61764);
var inst_61766 = [inst_61765,(10)];
var inst_61767 = (new cljs.core.PersistentVector(null,2,(5),inst_61762,inst_61766,null));
var inst_61768 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61767);
var _ = (function (){var statearr_61786 = state_61773;
(statearr_61786[(4)] = cljs.core.rest.call(null,(state_61773[(4)])));

return statearr_61786;
})();
var state_61773__$1 = (function (){var statearr_61787 = state_61773;
(statearr_61787[(7)] = inst_61768);

return statearr_61787;
})();
var statearr_61788_61802 = state_61773__$1;
(statearr_61788_61802[(2)] = inst_61761);

(statearr_61788_61802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_61789 = [null,null,null,null,null,null,null,null];
(statearr_61789[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__);

(statearr_61789[(1)] = (1));

return statearr_61789;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____1 = (function (state_61773){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61790){var ex__2457__auto__ = e61790;
var statearr_61791_61803 = state_61773;
(statearr_61791_61803[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61773[(4)]))){
var statearr_61792_61804 = state_61773;
(statearr_61792_61804[(1)] = cljs.core.first.call(null,(state_61773[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61805 = state_61773;
state_61773 = G__61805;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__ = function(state_61773){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____1.call(this,state_61773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61793 = f__2477__auto__.call(null);
(statearr_61793[(6)] = c__2476__auto__);

return statearr_61793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61852){
var state_val_61853 = (state_61852[(1)]);
if((state_val_61853 === (7))){
var inst_61822 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_61852__$1 = state_61852;
if(cljs.core.truth_(inst_61822)){
var statearr_61854_61881 = state_61852__$1;
(statearr_61854_61881[(1)] = (9));

} else {
var statearr_61855_61882 = state_61852__$1;
(statearr_61855_61882[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (1))){
var state_61852__$1 = state_61852;
var statearr_61856_61883 = state_61852__$1;
(statearr_61856_61883[(2)] = null);

(statearr_61856_61883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (4))){
var inst_61806 = (state_61852[(2)]);
var state_61852__$1 = state_61852;
var statearr_61857_61884 = state_61852__$1;
(statearr_61857_61884[(2)] = inst_61806);

(statearr_61857_61884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (15))){
var inst_61833 = (state_61852[(2)]);
var state_61852__$1 = state_61852;
var statearr_61858_61885 = state_61852__$1;
(statearr_61858_61885[(2)] = inst_61833);

(statearr_61858_61885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (13))){
var inst_61830 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_61852__$1 = state_61852;
var statearr_61859_61886 = state_61852__$1;
(statearr_61859_61886[(2)] = inst_61830);

(statearr_61859_61886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (6))){
var inst_61817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61818 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_61819 = [inst_61818,(0)];
var inst_61820 = (new cljs.core.PersistentVector(null,2,(5),inst_61817,inst_61819,null));
var state_61852__$1 = state_61852;
var statearr_61860_61887 = state_61852__$1;
(statearr_61860_61887[(2)] = inst_61820);

(statearr_61860_61887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (3))){
var inst_61850 = (state_61852[(2)]);
var state_61852__$1 = state_61852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61852__$1,inst_61850);
} else {
if((state_val_61853 === (12))){
var inst_61826 = (state_61852[(2)]);
var inst_61827 = fluree.db.util.async.throw_err.call(null,inst_61826);
var state_61852__$1 = state_61852;
var statearr_61861_61888 = state_61852__$1;
(statearr_61861_61888[(2)] = inst_61827);

(statearr_61861_61888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (2))){
var _ = (function (){var statearr_61862 = state_61852;
(statearr_61862[(4)] = cljs.core.cons.call(null,(5),(state_61852[(4)])));

return statearr_61862;
})();
var inst_61815 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_61852__$1 = state_61852;
if(cljs.core.truth_(inst_61815)){
var statearr_61863_61889 = state_61852__$1;
(statearr_61863_61889[(1)] = (6));

} else {
var statearr_61864_61890 = state_61852__$1;
(statearr_61864_61890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (11))){
var inst_61835 = (state_61852[(2)]);
var state_61852__$1 = state_61852;
var statearr_61866_61891 = state_61852__$1;
(statearr_61866_61891[(2)] = inst_61835);

(statearr_61866_61891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (9))){
var inst_61824 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_61852__$1 = state_61852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61852__$1,(12),inst_61824);
} else {
if((state_val_61853 === (5))){
var _ = (function (){var statearr_61867 = state_61852;
(statearr_61867[(4)] = cljs.core.rest.call(null,(state_61852[(4)])));

return statearr_61867;
})();
var state_61852__$1 = state_61852;
var ex61865 = (state_61852__$1[(2)]);
var statearr_61868_61892 = state_61852__$1;
(statearr_61868_61892[(5)] = ex61865);


if((ex61865 instanceof Error)){
var statearr_61869_61893 = state_61852__$1;
(statearr_61869_61893[(1)] = (4));

(statearr_61869_61893[(5)] = null);

} else {
throw ex61865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (14))){
var state_61852__$1 = state_61852;
var statearr_61870_61894 = state_61852__$1;
(statearr_61870_61894[(2)] = null);

(statearr_61870_61894[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (10))){
var state_61852__$1 = state_61852;
var statearr_61871_61895 = state_61852__$1;
(statearr_61871_61895[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61853 === (8))){
var inst_61837 = (state_61852[(2)]);
var inst_61838 = cljs.core.nth.call(null,inst_61837,(0),null);
var inst_61839 = cljs.core.nth.call(null,inst_61837,(1),null);
var inst_61840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61841 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61842 = ["?user_id","?ctx",inst_61838];
var inst_61843 = cljs.core.PersistentHashMap.fromArrays(inst_61841,inst_61842);
var inst_61844 = ((10) + inst_61839);
var inst_61845 = [inst_61843,inst_61844];
var inst_61846 = (new cljs.core.PersistentVector(null,2,(5),inst_61840,inst_61845,null));
var inst_61847 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61846);
var _ = (function (){var statearr_61873 = state_61852;
(statearr_61873[(4)] = cljs.core.rest.call(null,(state_61852[(4)])));

return statearr_61873;
})();
var state_61852__$1 = (function (){var statearr_61874 = state_61852;
(statearr_61874[(7)] = inst_61847);

return statearr_61874;
})();
var statearr_61875_61896 = state_61852__$1;
(statearr_61875_61896[(2)] = inst_61838);

(statearr_61875_61896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____0 = (function (){
var statearr_61876 = [null,null,null,null,null,null,null,null];
(statearr_61876[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__);

(statearr_61876[(1)] = (1));

return statearr_61876;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____1 = (function (state_61852){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61877){var ex__2457__auto__ = e61877;
var statearr_61878_61897 = state_61852;
(statearr_61878_61897[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61852[(4)]))){
var statearr_61879_61898 = state_61852;
(statearr_61879_61898[(1)] = cljs.core.first.call(null,(state_61852[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61899 = state_61852;
state_61852 = G__61899;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__ = function(state_61852){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____1.call(this,state_61852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61880 = f__2477__auto__.call(null);
(statearr_61880[(6)] = c__2476__auto__);

return statearr_61880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_61927){
var state_val_61928 = (state_61927[(1)]);
if((state_val_61928 === (7))){
var inst_61920 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_61927__$1 = state_61927;
var statearr_61929_61948 = state_61927__$1;
(statearr_61929_61948[(2)] = inst_61920);

(statearr_61929_61948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (1))){
var state_61927__$1 = state_61927;
var statearr_61930_61949 = state_61927__$1;
(statearr_61930_61949[(2)] = null);

(statearr_61930_61949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (4))){
var inst_61900 = (state_61927[(2)]);
var state_61927__$1 = state_61927;
var statearr_61931_61950 = state_61927__$1;
(statearr_61931_61950[(2)] = inst_61900);

(statearr_61931_61950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (6))){
var inst_61908 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_61927__$1 = state_61927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61927__$1,(9),inst_61908);
} else {
if((state_val_61928 === (3))){
var inst_61925 = (state_61927[(2)]);
var state_61927__$1 = state_61927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61927__$1,inst_61925);
} else {
if((state_val_61928 === (2))){
var _ = (function (){var statearr_61933 = state_61927;
(statearr_61933[(4)] = cljs.core.cons.call(null,(5),(state_61927[(4)])));

return statearr_61933;
})();
var inst_61906 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_61927__$1 = state_61927;
if(cljs.core.truth_(inst_61906)){
var statearr_61934_61951 = state_61927__$1;
(statearr_61934_61951[(1)] = (6));

} else {
var statearr_61935_61952 = state_61927__$1;
(statearr_61935_61952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (9))){
var inst_61910 = (state_61927[(2)]);
var inst_61911 = fluree.db.util.async.throw_err.call(null,inst_61910);
var inst_61912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61913 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61914 = ["?auth_id","?ctx",inst_61911];
var inst_61915 = cljs.core.PersistentHashMap.fromArrays(inst_61913,inst_61914);
var inst_61916 = [inst_61915,(10)];
var inst_61917 = (new cljs.core.PersistentVector(null,2,(5),inst_61912,inst_61916,null));
var inst_61918 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61917);
var state_61927__$1 = (function (){var statearr_61936 = state_61927;
(statearr_61936[(7)] = inst_61918);

return statearr_61936;
})();
var statearr_61937_61953 = state_61927__$1;
(statearr_61937_61953[(2)] = inst_61911);

(statearr_61937_61953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (5))){
var _ = (function (){var statearr_61938 = state_61927;
(statearr_61938[(4)] = cljs.core.rest.call(null,(state_61927[(4)])));

return statearr_61938;
})();
var state_61927__$1 = state_61927;
var ex61932 = (state_61927__$1[(2)]);
var statearr_61939_61954 = state_61927__$1;
(statearr_61939_61954[(5)] = ex61932);


if((ex61932 instanceof Error)){
var statearr_61940_61955 = state_61927__$1;
(statearr_61940_61955[(1)] = (4));

(statearr_61940_61955[(5)] = null);

} else {
throw ex61932;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61928 === (8))){
var inst_61922 = (state_61927[(2)]);
var _ = (function (){var statearr_61941 = state_61927;
(statearr_61941[(4)] = cljs.core.rest.call(null,(state_61927[(4)])));

return statearr_61941;
})();
var state_61927__$1 = state_61927;
var statearr_61942_61956 = state_61927__$1;
(statearr_61942_61956[(2)] = inst_61922);

(statearr_61942_61956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____0 = (function (){
var statearr_61943 = [null,null,null,null,null,null,null,null];
(statearr_61943[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__);

(statearr_61943[(1)] = (1));

return statearr_61943;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____1 = (function (state_61927){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_61927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e61944){var ex__2457__auto__ = e61944;
var statearr_61945_61957 = state_61927;
(statearr_61945_61957[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_61927[(4)]))){
var statearr_61946_61958 = state_61927;
(statearr_61946_61958[(1)] = cljs.core.first.call(null,(state_61927[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61959 = state_61927;
state_61927 = G__61959;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__ = function(state_61927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____1.call(this,state_61927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_61947 = f__2477__auto__.call(null);
(statearr_61947[(6)] = c__2476__auto__);

return statearr_61947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__61961 = arguments.length;
switch (G__61961) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_62003){
var state_val_62004 = (state_62003[(1)]);
if((state_val_62004 === (7))){
var state_62003__$1 = state_62003;
var statearr_62005_62035 = state_62003__$1;
(statearr_62005_62035[(2)] = seed);

(statearr_62005_62035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (1))){
var state_62003__$1 = state_62003;
var statearr_62006_62036 = state_62003__$1;
(statearr_62006_62036[(2)] = null);

(statearr_62006_62036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (4))){
var inst_61962 = (state_62003[(2)]);
var state_62003__$1 = state_62003;
var statearr_62007_62037 = state_62003__$1;
(statearr_62007_62037[(2)] = inst_61962);

(statearr_62007_62037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (15))){
var state_62003__$1 = state_62003;
var statearr_62008_62038 = state_62003__$1;
(statearr_62008_62038[(2)] = (10));

(statearr_62008_62038[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (13))){
var inst_61979 = (state_62003[(2)]);
var inst_61980 = fluree.db.util.async.throw_err.call(null,inst_61979);
var state_62003__$1 = state_62003;
var statearr_62009_62039 = state_62003__$1;
(statearr_62009_62039[(2)] = inst_61980);

(statearr_62009_62039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (6))){
var state_62003__$1 = state_62003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62003__$1,(9),seed);
} else {
if((state_val_62004 === (3))){
var inst_62001 = (state_62003[(2)]);
var state_62003__$1 = state_62003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62003__$1,inst_62001);
} else {
if((state_val_62004 === (12))){
var inst_61983 = (state_62003[(7)]);
var inst_61983__$1 = (state_62003[(2)]);
var state_62003__$1 = (function (){var statearr_62010 = state_62003;
(statearr_62010[(7)] = inst_61983__$1);

return statearr_62010;
})();
if(cljs.core.truth_(inst_61983__$1)){
var statearr_62011_62040 = state_62003__$1;
(statearr_62011_62040[(1)] = (14));

} else {
var statearr_62012_62041 = state_62003__$1;
(statearr_62012_62041[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (2))){
var _ = (function (){var statearr_62013 = state_62003;
(statearr_62013[(4)] = cljs.core.cons.call(null,(5),(state_62003[(4)])));

return statearr_62013;
})();
var inst_61968 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_62003__$1 = state_62003;
if(inst_61968){
var statearr_62014_62042 = state_62003__$1;
(statearr_62014_62042[(1)] = (6));

} else {
var statearr_62015_62043 = state_62003__$1;
(statearr_62015_62043[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (11))){
var state_62003__$1 = state_62003;
var statearr_62017_62044 = state_62003__$1;
(statearr_62017_62044[(2)] = max);

(statearr_62017_62044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (9))){
var inst_61971 = (state_62003[(2)]);
var inst_61972 = fluree.db.util.async.throw_err.call(null,inst_61971);
var state_62003__$1 = state_62003;
var statearr_62018_62045 = state_62003__$1;
(statearr_62018_62045[(2)] = inst_61972);

(statearr_62018_62045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (5))){
var _ = (function (){var statearr_62019 = state_62003;
(statearr_62019[(4)] = cljs.core.rest.call(null,(state_62003[(4)])));

return statearr_62019;
})();
var state_62003__$1 = state_62003;
var ex62016 = (state_62003__$1[(2)]);
var statearr_62020_62046 = state_62003__$1;
(statearr_62020_62046[(5)] = ex62016);


if((ex62016 instanceof Error)){
var statearr_62021_62047 = state_62003__$1;
(statearr_62021_62047[(1)] = (4));

(statearr_62021_62047[(5)] = null);

} else {
throw ex62016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (14))){
var inst_61983 = (state_62003[(7)]);
var state_62003__$1 = state_62003;
var statearr_62022_62048 = state_62003__$1;
(statearr_62022_62048[(2)] = inst_61983);

(statearr_62022_62048[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (16))){
var inst_61975 = (state_62003[(8)]);
var inst_61987 = (state_62003[(2)]);
var inst_61988 = fluree.db.dbfunctions.internal.rand.call(null,inst_61975,inst_61987);
var inst_61989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61990 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_61991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61992 = [seed,max];
var inst_61993 = (new cljs.core.PersistentVector(null,2,(5),inst_61991,inst_61992,null));
var inst_61994 = ["rand",inst_61993,inst_61988];
var inst_61995 = cljs.core.PersistentHashMap.fromArrays(inst_61990,inst_61994);
var inst_61996 = [inst_61995,(10)];
var inst_61997 = (new cljs.core.PersistentVector(null,2,(5),inst_61989,inst_61996,null));
var inst_61998 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_61997);
var _ = (function (){var statearr_62023 = state_62003;
(statearr_62023[(4)] = cljs.core.rest.call(null,(state_62003[(4)])));

return statearr_62023;
})();
var state_62003__$1 = (function (){var statearr_62024 = state_62003;
(statearr_62024[(9)] = inst_61998);

return statearr_62024;
})();
var statearr_62025_62049 = state_62003__$1;
(statearr_62025_62049[(2)] = inst_61988);

(statearr_62025_62049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62004 === (10))){
var state_62003__$1 = state_62003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62003__$1,(13),max);
} else {
if((state_val_62004 === (8))){
var inst_61975 = (state_62003[(2)]);
var inst_61976 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_62003__$1 = (function (){var statearr_62026 = state_62003;
(statearr_62026[(8)] = inst_61975);

return statearr_62026;
})();
if(inst_61976){
var statearr_62027_62050 = state_62003__$1;
(statearr_62027_62050[(1)] = (10));

} else {
var statearr_62028_62051 = state_62003__$1;
(statearr_62028_62051[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2454__auto____0 = (function (){
var statearr_62029 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62029[(0)] = fluree$db$dbfunctions$fns$state_machine__2454__auto__);

(statearr_62029[(1)] = (1));

return statearr_62029;
});
var fluree$db$dbfunctions$fns$state_machine__2454__auto____1 = (function (state_62003){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_62003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e62030){var ex__2457__auto__ = e62030;
var statearr_62031_62052 = state_62003;
(statearr_62031_62052[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_62003[(4)]))){
var statearr_62032_62053 = state_62003;
(statearr_62032_62053[(1)] = cljs.core.first.call(null,(state_62003[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62054 = state_62003;
state_62003 = G__62054;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2454__auto__ = function(state_62003){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2454__auto____1.call(this,state_62003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_62033 = f__2477__auto__.call(null);
(statearr_62033[(6)] = c__2476__auto__);

return statearr_62033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_62075){
var state_val_62076 = (state_62075[(1)]);
if((state_val_62076 === (1))){
var state_62075__$1 = state_62075;
var statearr_62077_62092 = state_62075__$1;
(statearr_62077_62092[(2)] = null);

(statearr_62077_62092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62076 === (2))){
var _ = (function (){var statearr_62078 = state_62075;
(statearr_62078[(4)] = cljs.core.cons.call(null,(5),(state_62075[(4)])));

return statearr_62078;
})();
var inst_62061 = fluree.db.util.core.random_uuid.call(null);
var inst_62062 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62061);
var inst_62063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62064 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62065 = cljs.core.PersistentVector.EMPTY;
var inst_62066 = ["uuid",inst_62065,inst_62062];
var inst_62067 = cljs.core.PersistentHashMap.fromArrays(inst_62064,inst_62066);
var inst_62068 = [inst_62067,(10)];
var inst_62069 = (new cljs.core.PersistentVector(null,2,(5),inst_62063,inst_62068,null));
var inst_62070 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62069);
var ___$1 = (function (){var statearr_62079 = state_62075;
(statearr_62079[(4)] = cljs.core.rest.call(null,(state_62075[(4)])));

return statearr_62079;
})();
var state_62075__$1 = (function (){var statearr_62080 = state_62075;
(statearr_62080[(7)] = inst_62070);

return statearr_62080;
})();
var statearr_62081_62093 = state_62075__$1;
(statearr_62081_62093[(2)] = inst_62062);

(statearr_62081_62093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62076 === (3))){
var inst_62073 = (state_62075[(2)]);
var state_62075__$1 = state_62075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62075__$1,inst_62073);
} else {
if((state_val_62076 === (4))){
var inst_62055 = (state_62075[(2)]);
var state_62075__$1 = state_62075;
var statearr_62083_62094 = state_62075__$1;
(statearr_62083_62094[(2)] = inst_62055);

(statearr_62083_62094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62076 === (5))){
var _ = (function (){var statearr_62084 = state_62075;
(statearr_62084[(4)] = cljs.core.rest.call(null,(state_62075[(4)])));

return statearr_62084;
})();
var state_62075__$1 = state_62075;
var ex62082 = (state_62075__$1[(2)]);
var statearr_62085_62095 = state_62075__$1;
(statearr_62085_62095[(5)] = ex62082);


if((ex62082 instanceof Error)){
var statearr_62086_62096 = state_62075__$1;
(statearr_62086_62096[(1)] = (4));

(statearr_62086_62096[(5)] = null);

} else {
throw ex62082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____0 = (function (){
var statearr_62087 = [null,null,null,null,null,null,null,null];
(statearr_62087[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__);

(statearr_62087[(1)] = (1));

return statearr_62087;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____1 = (function (state_62075){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_62075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e62088){var ex__2457__auto__ = e62088;
var statearr_62089_62097 = state_62075;
(statearr_62089_62097[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_62075[(4)]))){
var statearr_62090_62098 = state_62075;
(statearr_62090_62098[(1)] = cljs.core.first.call(null,(state_62075[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62099 = state_62075;
state_62075 = G__62099;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__ = function(state_62075){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____1.call(this,state_62075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_62091 = f__2477__auto__.call(null);
(statearr_62091[(6)] = c__2476__auto__);

return statearr_62091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_62129){
var state_val_62130 = (state_62129[(1)]);
if((state_val_62130 === (7))){
var state_62129__$1 = state_62129;
var statearr_62131_62150 = state_62129__$1;
(statearr_62131_62150[(2)] = num);

(statearr_62131_62150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (1))){
var state_62129__$1 = state_62129;
var statearr_62132_62151 = state_62129__$1;
(statearr_62132_62151[(2)] = null);

(statearr_62132_62151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (4))){
var inst_62100 = (state_62129[(2)]);
var state_62129__$1 = state_62129;
var statearr_62133_62152 = state_62129__$1;
(statearr_62133_62152[(2)] = inst_62100);

(statearr_62133_62152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (6))){
var state_62129__$1 = state_62129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62129__$1,(9),num);
} else {
if((state_val_62130 === (3))){
var inst_62127 = (state_62129[(2)]);
var state_62129__$1 = state_62129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62129__$1,inst_62127);
} else {
if((state_val_62130 === (2))){
var _ = (function (){var statearr_62135 = state_62129;
(statearr_62135[(4)] = cljs.core.cons.call(null,(5),(state_62129[(4)])));

return statearr_62135;
})();
var inst_62106 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_62129__$1 = state_62129;
if(inst_62106){
var statearr_62136_62153 = state_62129__$1;
(statearr_62136_62153[(1)] = (6));

} else {
var statearr_62137_62154 = state_62129__$1;
(statearr_62137_62154[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (9))){
var inst_62109 = (state_62129[(2)]);
var inst_62110 = fluree.db.util.async.throw_err.call(null,inst_62109);
var state_62129__$1 = state_62129;
var statearr_62138_62155 = state_62129__$1;
(statearr_62138_62155[(2)] = inst_62110);

(statearr_62138_62155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (5))){
var _ = (function (){var statearr_62139 = state_62129;
(statearr_62139[(4)] = cljs.core.rest.call(null,(state_62129[(4)])));

return statearr_62139;
})();
var state_62129__$1 = state_62129;
var ex62134 = (state_62129__$1[(2)]);
var statearr_62140_62156 = state_62129__$1;
(statearr_62140_62156[(5)] = ex62134);


if((ex62134 instanceof Error)){
var statearr_62141_62157 = state_62129__$1;
(statearr_62141_62157[(1)] = (4));

(statearr_62141_62157[(5)] = null);

} else {
throw ex62134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62130 === (8))){
var inst_62113 = (state_62129[(2)]);
var inst_62114 = fluree.db.dbfunctions.internal.ceil.call(null,inst_62113);
var inst_62115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62116 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62118 = [fluree.db.dbfunctions.fns.ceil];
var inst_62119 = (new cljs.core.PersistentVector(null,1,(5),inst_62117,inst_62118,null));
var inst_62120 = ["",inst_62119,inst_62114];
var inst_62121 = cljs.core.PersistentHashMap.fromArrays(inst_62116,inst_62120);
var inst_62122 = [inst_62121,(10)];
var inst_62123 = (new cljs.core.PersistentVector(null,2,(5),inst_62115,inst_62122,null));
var inst_62124 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62123);
var _ = (function (){var statearr_62142 = state_62129;
(statearr_62142[(4)] = cljs.core.rest.call(null,(state_62129[(4)])));

return statearr_62142;
})();
var state_62129__$1 = (function (){var statearr_62143 = state_62129;
(statearr_62143[(7)] = inst_62124);

return statearr_62143;
})();
var statearr_62144_62158 = state_62129__$1;
(statearr_62144_62158[(2)] = inst_62114);

(statearr_62144_62158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____0 = (function (){
var statearr_62145 = [null,null,null,null,null,null,null,null];
(statearr_62145[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__);

(statearr_62145[(1)] = (1));

return statearr_62145;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____1 = (function (state_62129){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_62129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e62146){var ex__2457__auto__ = e62146;
var statearr_62147_62159 = state_62129;
(statearr_62147_62159[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_62129[(4)]))){
var statearr_62148_62160 = state_62129;
(statearr_62148_62160[(1)] = cljs.core.first.call(null,(state_62129[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62161 = state_62129;
state_62129 = G__62161;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__ = function(state_62129){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____1.call(this,state_62129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_62149 = f__2477__auto__.call(null);
(statearr_62149[(6)] = c__2476__auto__);

return statearr_62149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_62191){
var state_val_62192 = (state_62191[(1)]);
if((state_val_62192 === (7))){
var state_62191__$1 = state_62191;
var statearr_62193_62212 = state_62191__$1;
(statearr_62193_62212[(2)] = num);

(statearr_62193_62212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (1))){
var state_62191__$1 = state_62191;
var statearr_62194_62213 = state_62191__$1;
(statearr_62194_62213[(2)] = null);

(statearr_62194_62213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (4))){
var inst_62162 = (state_62191[(2)]);
var state_62191__$1 = state_62191;
var statearr_62195_62214 = state_62191__$1;
(statearr_62195_62214[(2)] = inst_62162);

(statearr_62195_62214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (6))){
var state_62191__$1 = state_62191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62191__$1,(9),num);
} else {
if((state_val_62192 === (3))){
var inst_62189 = (state_62191[(2)]);
var state_62191__$1 = state_62191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62191__$1,inst_62189);
} else {
if((state_val_62192 === (2))){
var _ = (function (){var statearr_62197 = state_62191;
(statearr_62197[(4)] = cljs.core.cons.call(null,(5),(state_62191[(4)])));

return statearr_62197;
})();
var inst_62168 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_62191__$1 = state_62191;
if(inst_62168){
var statearr_62198_62215 = state_62191__$1;
(statearr_62198_62215[(1)] = (6));

} else {
var statearr_62199_62216 = state_62191__$1;
(statearr_62199_62216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (9))){
var inst_62171 = (state_62191[(2)]);
var inst_62172 = fluree.db.util.async.throw_err.call(null,inst_62171);
var state_62191__$1 = state_62191;
var statearr_62200_62217 = state_62191__$1;
(statearr_62200_62217[(2)] = inst_62172);

(statearr_62200_62217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (5))){
var _ = (function (){var statearr_62201 = state_62191;
(statearr_62201[(4)] = cljs.core.rest.call(null,(state_62191[(4)])));

return statearr_62201;
})();
var state_62191__$1 = state_62191;
var ex62196 = (state_62191__$1[(2)]);
var statearr_62202_62218 = state_62191__$1;
(statearr_62202_62218[(5)] = ex62196);


if((ex62196 instanceof Error)){
var statearr_62203_62219 = state_62191__$1;
(statearr_62203_62219[(1)] = (4));

(statearr_62203_62219[(5)] = null);

} else {
throw ex62196;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62192 === (8))){
var inst_62175 = (state_62191[(2)]);
var inst_62176 = fluree.db.dbfunctions.internal.floor.call(null,inst_62175);
var inst_62177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62178 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_62179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62180 = [fluree.db.dbfunctions.fns.floor];
var inst_62181 = (new cljs.core.PersistentVector(null,1,(5),inst_62179,inst_62180,null));
var inst_62182 = ["",inst_62181,inst_62176];
var inst_62183 = cljs.core.PersistentHashMap.fromArrays(inst_62178,inst_62182);
var inst_62184 = [inst_62183,(10)];
var inst_62185 = (new cljs.core.PersistentVector(null,2,(5),inst_62177,inst_62184,null));
var inst_62186 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_62185);
var _ = (function (){var statearr_62204 = state_62191;
(statearr_62204[(4)] = cljs.core.rest.call(null,(state_62191[(4)])));

return statearr_62204;
})();
var state_62191__$1 = (function (){var statearr_62205 = state_62191;
(statearr_62205[(7)] = inst_62186);

return statearr_62205;
})();
var statearr_62206_62220 = state_62191__$1;
(statearr_62206_62220[(2)] = inst_62176);

(statearr_62206_62220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____0 = (function (){
var statearr_62207 = [null,null,null,null,null,null,null,null];
(statearr_62207[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__);

(statearr_62207[(1)] = (1));

return statearr_62207;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____1 = (function (state_62191){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_62191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e62208){var ex__2457__auto__ = e62208;
var statearr_62209_62221 = state_62191;
(statearr_62209_62221[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_62191[(4)]))){
var statearr_62210_62222 = state_62191;
(statearr_62210_62222[(1)] = cljs.core.first.call(null,(state_62191[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62223 = state_62191;
state_62191 = G__62223;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__ = function(state_62191){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____1.call(this,state_62191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_62211 = f__2477__auto__.call(null);
(statearr_62211[(6)] = c__2476__auto__);

return statearr_62211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
