// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__28440_28609 = cljs.core.seq.call(null,servers);
var chunk__28441_28610 = null;
var count__28442_28611 = (0);
var i__28443_28612 = (0);
while(true){
if((i__28443_28612 < count__28442_28611)){
var server_28613 = cljs.core._nth.call(null,chunk__28441_28610,i__28443_28612);
var healthcheck_uri_28614 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_28613),"/fdb/health"].join('');
var resp_chan_28615 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_28614,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2476__auto___28616 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613){
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = ((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613){
return (function (state_28504){
var state_val_28505 = (state_28504[(1)]);
if((state_val_28505 === (1))){
var state_28504__$1 = state_28504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28504__$1,(2),resp_chan_28615);
} else {
if((state_val_28505 === (2))){
var inst_28493 = (state_28504[(7)]);
var inst_28493__$1 = (state_28504[(2)]);
var inst_28494 = fluree.db.util.core.exception_QMARK_.call(null,inst_28493__$1);
var state_28504__$1 = (function (){var statearr_28506 = state_28504;
(statearr_28506[(7)] = inst_28493__$1);

return statearr_28506;
})();
if(inst_28494){
var statearr_28507_28617 = state_28504__$1;
(statearr_28507_28617[(1)] = (3));

} else {
var statearr_28508_28618 = state_28504__$1;
(statearr_28508_28618[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28505 === (3))){
var inst_28493 = (state_28504[(7)]);
var inst_28496 = cljs.core.ex_message.call(null,inst_28493);
var inst_28497 = cljs.core.ex_data.call(null,inst_28493);
var inst_28498 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_28496,inst_28497);
var state_28504__$1 = state_28504;
var statearr_28509_28619 = state_28504__$1;
(statearr_28509_28619[(2)] = inst_28498);

(statearr_28509_28619[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28505 === (4))){
var inst_28500 = cljs.core.async.put_BANG_.call(null,promise_chan,server_28613);
var state_28504__$1 = state_28504;
var statearr_28510_28620 = state_28504__$1;
(statearr_28510_28620[(2)] = inst_28500);

(statearr_28510_28620[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28505 === (5))){
var inst_28502 = (state_28504[(2)]);
var state_28504__$1 = state_28504;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28504__$1,inst_28502);
} else {
return null;
}
}
}
}
}
});})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613))
;
return ((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,switch__2453__auto__,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0 = (function (){
var statearr_28511 = [null,null,null,null,null,null,null,null];
(statearr_28511[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__);

(statearr_28511[(1)] = (1));

return statearr_28511;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1 = (function (state_28504){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28512){var ex__2457__auto__ = e28512;
var statearr_28513_28621 = state_28504;
(statearr_28513_28621[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28504[(4)]))){
var statearr_28514_28622 = state_28504;
(statearr_28514_28622[(1)] = cljs.core.first.call(null,(state_28504[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28623 = state_28504;
state_28504 = G__28623;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = function(state_28504){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1.call(this,state_28504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__;
})()
;})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,switch__2453__auto__,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613))
})();
var state__2478__auto__ = (function (){var statearr_28515 = f__2477__auto__.call(null);
(statearr_28515[(6)] = c__2476__auto___28616);

return statearr_28515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28616,healthcheck_uri_28614,resp_chan_28615,server_28613))
);



var G__28624 = seq__28440_28609;
var G__28625 = chunk__28441_28610;
var G__28626 = count__28442_28611;
var G__28627 = (i__28443_28612 + (1));
seq__28440_28609 = G__28624;
chunk__28441_28610 = G__28625;
count__28442_28611 = G__28626;
i__28443_28612 = G__28627;
continue;
} else {
var temp__5735__auto___28628 = cljs.core.seq.call(null,seq__28440_28609);
if(temp__5735__auto___28628){
var seq__28440_28629__$1 = temp__5735__auto___28628;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28440_28629__$1)){
var c__4556__auto___28630 = cljs.core.chunk_first.call(null,seq__28440_28629__$1);
var G__28631 = cljs.core.chunk_rest.call(null,seq__28440_28629__$1);
var G__28632 = c__4556__auto___28630;
var G__28633 = cljs.core.count.call(null,c__4556__auto___28630);
var G__28634 = (0);
seq__28440_28609 = G__28631;
chunk__28441_28610 = G__28632;
count__28442_28611 = G__28633;
i__28443_28612 = G__28634;
continue;
} else {
var server_28635 = cljs.core.first.call(null,seq__28440_28629__$1);
var healthcheck_uri_28636 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_28635),"/fdb/health"].join('');
var resp_chan_28637 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_28636,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2476__auto___28638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628){
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = ((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628){
return (function (state_28528){
var state_val_28529 = (state_28528[(1)]);
if((state_val_28529 === (1))){
var state_28528__$1 = state_28528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28528__$1,(2),resp_chan_28637);
} else {
if((state_val_28529 === (2))){
var inst_28517 = (state_28528[(7)]);
var inst_28517__$1 = (state_28528[(2)]);
var inst_28518 = fluree.db.util.core.exception_QMARK_.call(null,inst_28517__$1);
var state_28528__$1 = (function (){var statearr_28530 = state_28528;
(statearr_28530[(7)] = inst_28517__$1);

return statearr_28530;
})();
if(inst_28518){
var statearr_28531_28639 = state_28528__$1;
(statearr_28531_28639[(1)] = (3));

} else {
var statearr_28532_28640 = state_28528__$1;
(statearr_28532_28640[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28529 === (3))){
var inst_28517 = (state_28528[(7)]);
var inst_28520 = cljs.core.ex_message.call(null,inst_28517);
var inst_28521 = cljs.core.ex_data.call(null,inst_28517);
var inst_28522 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_28520,inst_28521);
var state_28528__$1 = state_28528;
var statearr_28533_28641 = state_28528__$1;
(statearr_28533_28641[(2)] = inst_28522);

(statearr_28533_28641[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28529 === (4))){
var inst_28524 = cljs.core.async.put_BANG_.call(null,promise_chan,server_28635);
var state_28528__$1 = state_28528;
var statearr_28534_28642 = state_28528__$1;
(statearr_28534_28642[(2)] = inst_28524);

(statearr_28534_28642[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28529 === (5))){
var inst_28526 = (state_28528[(2)]);
var state_28528__$1 = state_28528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28528__$1,inst_28526);
} else {
return null;
}
}
}
}
}
});})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628))
;
return ((function (seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,switch__2453__auto__,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0 = (function (){
var statearr_28535 = [null,null,null,null,null,null,null,null];
(statearr_28535[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__);

(statearr_28535[(1)] = (1));

return statearr_28535;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1 = (function (state_28528){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28536){var ex__2457__auto__ = e28536;
var statearr_28537_28643 = state_28528;
(statearr_28537_28643[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28528[(4)]))){
var statearr_28538_28644 = state_28528;
(statearr_28538_28644[(1)] = cljs.core.first.call(null,(state_28528[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28645 = state_28528;
state_28528 = G__28645;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = function(state_28528){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1.call(this,state_28528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__;
})()
;})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,switch__2453__auto__,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628))
})();
var state__2478__auto__ = (function (){var statearr_28539 = f__2477__auto__.call(null);
(statearr_28539[(6)] = c__2476__auto___28638);

return statearr_28539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});})(seq__28440_28609,chunk__28441_28610,count__28442_28611,i__28443_28612,c__2476__auto___28638,healthcheck_uri_28636,resp_chan_28637,server_28635,seq__28440_28629__$1,temp__5735__auto___28628))
);



var G__28646 = cljs.core.next.call(null,seq__28440_28629__$1);
var G__28647 = null;
var G__28648 = (0);
var G__28649 = (0);
seq__28440_28609 = G__28646;
chunk__28441_28610 = G__28647;
count__28442_28611 = G__28648;
i__28443_28612 = G__28649;
continue;
}
} else {
}
}
break;
}

var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_28583){
var state_val_28584 = (state_28583[(1)]);
if((state_val_28584 === (7))){
var inst_28555 = (state_28583[(7)]);
var inst_28562 = cljs.core._EQ_.call(null,inst_28555,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_28583__$1 = state_28583;
if(inst_28562){
var statearr_28585_28650 = state_28583__$1;
(statearr_28585_28650[(1)] = (9));

} else {
var statearr_28586_28651 = state_28583__$1;
(statearr_28586_28651[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (1))){
var inst_28547 = (state_28583[(8)]);
var inst_28548 = (state_28583[(9)]);
var inst_28547__$1 = promise_chan;
var inst_28548__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_28549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28550 = [inst_28547__$1,inst_28548__$1];
var inst_28551 = (new cljs.core.PersistentVector(null,2,(5),inst_28549,inst_28550,null));
var state_28583__$1 = (function (){var statearr_28587 = state_28583;
(statearr_28587[(8)] = inst_28547__$1);

(statearr_28587[(9)] = inst_28548__$1);

return statearr_28587;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28583__$1,(2),inst_28551);
} else {
if((state_val_28584 === (4))){
var inst_28548 = (state_28583[(9)]);
var inst_28555 = (state_28583[(7)]);
var inst_28559 = cljs.core._EQ_.call(null,inst_28555,inst_28548);
var state_28583__$1 = state_28583;
if(inst_28559){
var statearr_28588_28652 = state_28583__$1;
(statearr_28588_28652[(1)] = (6));

} else {
var statearr_28589_28653 = state_28583__$1;
(statearr_28589_28653[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (13))){
var state_28583__$1 = state_28583;
var statearr_28590_28654 = state_28583__$1;
(statearr_28590_28654[(2)] = null);

(statearr_28590_28654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (6))){
var state_28583__$1 = state_28583;
var statearr_28591_28655 = state_28583__$1;
(statearr_28591_28655[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_28591_28655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (3))){
var state_28583__$1 = state_28583;
var statearr_28592_28656 = state_28583__$1;
(statearr_28592_28656[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_28592_28656[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (12))){
var inst_28573 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_28574 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28575 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_28576 = cljs.core.PersistentHashMap.fromArrays(inst_28574,inst_28575);
var inst_28577 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_28576);
var inst_28578 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_28577);
var state_28583__$1 = (function (){var statearr_28593 = state_28583;
(statearr_28593[(10)] = inst_28573);

return statearr_28593;
})();
var statearr_28594_28657 = state_28583__$1;
(statearr_28594_28657[(2)] = inst_28578);

(statearr_28594_28657[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (2))){
var inst_28547 = (state_28583[(8)]);
var inst_28555 = (state_28583[(7)]);
var inst_28553 = (state_28583[(2)]);
var inst_28554 = cljs.core.nth.call(null,inst_28553,(0),null);
var inst_28555__$1 = cljs.core.nth.call(null,inst_28553,(1),null);
var inst_28556 = cljs.core._EQ_.call(null,inst_28555__$1,inst_28547);
var state_28583__$1 = (function (){var statearr_28595 = state_28583;
(statearr_28595[(11)] = inst_28554);

(statearr_28595[(7)] = inst_28555__$1);

return statearr_28595;
})();
if(inst_28556){
var statearr_28596_28658 = state_28583__$1;
(statearr_28596_28658[(1)] = (3));

} else {
var statearr_28597_28659 = state_28583__$1;
(statearr_28597_28659[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (11))){
var inst_28566 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
var statearr_28598_28660 = state_28583__$1;
(statearr_28598_28660[(2)] = inst_28566);

(statearr_28598_28660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (9))){
var inst_28554 = (state_28583[(11)]);
var state_28583__$1 = state_28583;
var statearr_28599_28661 = state_28583__$1;
(statearr_28599_28661[(2)] = inst_28554);

(statearr_28599_28661[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (5))){
var inst_28570 = (state_28583[(2)]);
var inst_28571 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_28570);
var state_28583__$1 = state_28583;
if(inst_28571){
var statearr_28600_28662 = state_28583__$1;
(statearr_28600_28662[(1)] = (12));

} else {
var statearr_28601_28663 = state_28583__$1;
(statearr_28601_28663[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (14))){
var inst_28581 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28583__$1,inst_28581);
} else {
if((state_val_28584 === (10))){
var state_28583__$1 = state_28583;
var statearr_28602_28664 = state_28583__$1;
(statearr_28602_28664[(2)] = null);

(statearr_28602_28664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (8))){
var inst_28568 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
var statearr_28603_28665 = state_28583__$1;
(statearr_28603_28665[(2)] = inst_28568);

(statearr_28603_28665[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0 = (function (){
var statearr_28604 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28604[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__);

(statearr_28604[(1)] = (1));

return statearr_28604;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1 = (function (state_28583){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28605){var ex__2457__auto__ = e28605;
var statearr_28606_28666 = state_28583;
(statearr_28606_28666[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28583[(4)]))){
var statearr_28607_28667 = state_28583;
(statearr_28607_28667[(1)] = cljs.core.first.call(null,(state_28583[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28668 = state_28583;
state_28583 = G__28668;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__ = function(state_28583){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1.call(this,state_28583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_28608 = f__2477__auto__.call(null);
(statearr_28608[(6)] = c__2476__auto__);

return statearr_28608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_28712){
var state_val_28713 = (state_28712[(1)]);
if((state_val_28713 === (7))){
var state_28712__$1 = state_28712;
var statearr_28714_28740 = state_28712__$1;
(statearr_28714_28740[(2)] = null);

(statearr_28714_28740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (1))){
var state_28712__$1 = state_28712;
var statearr_28715_28741 = state_28712__$1;
(statearr_28715_28741[(2)] = null);

(statearr_28715_28741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (4))){
var inst_28669 = (state_28712[(2)]);
var state_28712__$1 = state_28712;
var statearr_28716_28742 = state_28712__$1;
(statearr_28716_28742[(2)] = inst_28669);

(statearr_28716_28742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (6))){
var inst_28691 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_28712__$1 = state_28712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28712__$1,(9),inst_28691);
} else {
if((state_val_28713 === (3))){
var inst_28710 = (state_28712[(2)]);
var state_28712__$1 = state_28712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28712__$1,inst_28710);
} else {
if((state_val_28713 === (12))){
var inst_28704 = (state_28712[(2)]);
var state_28712__$1 = state_28712;
var statearr_28717_28743 = state_28712__$1;
(statearr_28717_28743[(2)] = inst_28704);

(statearr_28717_28743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (2))){
var inst_28680 = (state_28712[(7)]);
var inst_28675 = (state_28712[(8)]);
var inst_28685 = (state_28712[(9)]);
var _ = (function (){var statearr_28718 = state_28712;
(statearr_28718[(4)] = cljs.core.cons.call(null,(5),(state_28712[(4)])));

return statearr_28718;
})();
var inst_28675__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_28676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28677 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_28678 = (new cljs.core.PersistentVector(null,2,(5),inst_28676,inst_28677,null));
var inst_28679 = (function (){var lock_id = inst_28675__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_28680__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_28678,inst_28679);
var inst_28681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28682 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_28683 = (new cljs.core.PersistentVector(null,3,(5),inst_28681,inst_28682,null));
var inst_28684 = cljs.core.get_in.call(null,inst_28680__$1,inst_28683);
var inst_28685__$1 = cljs.core._EQ_.call(null,inst_28675__$1,inst_28684);
var inst_28686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28687 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_28688 = (new cljs.core.PersistentVector(null,3,(5),inst_28686,inst_28687,null));
var inst_28689 = cljs.core.get_in.call(null,inst_28680__$1,inst_28688);
var state_28712__$1 = (function (){var statearr_28719 = state_28712;
(statearr_28719[(7)] = inst_28680__$1);

(statearr_28719[(8)] = inst_28675__$1);

(statearr_28719[(10)] = inst_28689);

(statearr_28719[(9)] = inst_28685__$1);

return statearr_28719;
})();
if(inst_28685__$1){
var statearr_28720_28744 = state_28712__$1;
(statearr_28720_28744[(1)] = (6));

} else {
var statearr_28721_28745 = state_28712__$1;
(statearr_28721_28745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (11))){
var inst_28695 = (state_28712[(11)]);
var inst_28689 = (state_28712[(10)]);
var inst_28696 = (state_28712[(12)]);
var inst_28702 = fluree.db.util.xhttp.try_socket.call(null,inst_28695,sub_chan,pub_chan,inst_28689,(60000),inst_28696);
var state_28712__$1 = state_28712;
var statearr_28723_28746 = state_28712__$1;
(statearr_28723_28746[(2)] = inst_28702);

(statearr_28723_28746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (9))){
var inst_28680 = (state_28712[(7)]);
var inst_28695 = (state_28712[(11)]);
var inst_28675 = (state_28712[(8)]);
var inst_28689 = (state_28712[(10)]);
var inst_28685 = (state_28712[(9)]);
var inst_28693 = (state_28712[(13)]);
var inst_28693__$1 = (state_28712[(2)]);
var inst_28694 = clojure.string.replace.call(null,inst_28693__$1,"http","ws");
var inst_28695__$1 = [inst_28694,"/fdb/ws"].join('');
var inst_28696 = (function (){var lock_id = inst_28675;
var state = inst_28680;
var have_lock_QMARK_ = inst_28685;
var resp_chan = inst_28689;
var healthy_server = inst_28693__$1;
var ws_url = inst_28695__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_28697 = fluree.db.util.core.exception_QMARK_.call(null,inst_28693__$1);
var state_28712__$1 = (function (){var statearr_28724 = state_28712;
(statearr_28724[(11)] = inst_28695__$1);

(statearr_28724[(12)] = inst_28696);

(statearr_28724[(13)] = inst_28693__$1);

return statearr_28724;
})();
if(inst_28697){
var statearr_28725_28747 = state_28712__$1;
(statearr_28725_28747[(1)] = (10));

} else {
var statearr_28726_28748 = state_28712__$1;
(statearr_28726_28748[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (5))){
var _ = (function (){var statearr_28727 = state_28712;
(statearr_28727[(4)] = cljs.core.rest.call(null,(state_28712[(4)])));

return statearr_28727;
})();
var state_28712__$1 = state_28712;
var ex28722 = (state_28712__$1[(2)]);
var statearr_28728_28749 = state_28712__$1;
(statearr_28728_28749[(5)] = ex28722);


if((ex28722 instanceof Error)){
var statearr_28729_28750 = state_28712__$1;
(statearr_28729_28750[(1)] = (4));

(statearr_28729_28750[(5)] = null);

} else {
throw ex28722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (10))){
var inst_28689 = (state_28712[(10)]);
var inst_28693 = (state_28712[(13)]);
var inst_28699 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_28700 = cljs.core.async.put_BANG_.call(null,inst_28689,inst_28693);
var state_28712__$1 = (function (){var statearr_28730 = state_28712;
(statearr_28730[(14)] = inst_28699);

return statearr_28730;
})();
var statearr_28731_28751 = state_28712__$1;
(statearr_28731_28751[(2)] = inst_28700);

(statearr_28731_28751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28713 === (8))){
var inst_28689 = (state_28712[(10)]);
var inst_28707 = (state_28712[(2)]);
var _ = (function (){var statearr_28732 = state_28712;
(statearr_28732[(4)] = cljs.core.rest.call(null,(state_28712[(4)])));

return statearr_28732;
})();
var state_28712__$1 = (function (){var statearr_28733 = state_28712;
(statearr_28733[(15)] = inst_28707);

return statearr_28733;
})();
var statearr_28734_28752 = state_28712__$1;
(statearr_28734_28752[(2)] = inst_28689);

(statearr_28734_28752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2454__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2454__auto____0 = (function (){
var statearr_28735 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28735[(0)] = fluree$db$connection$establish_socket_$_state_machine__2454__auto__);

(statearr_28735[(1)] = (1));

return statearr_28735;
});
var fluree$db$connection$establish_socket_$_state_machine__2454__auto____1 = (function (state_28712){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28736){var ex__2457__auto__ = e28736;
var statearr_28737_28753 = state_28712;
(statearr_28737_28753[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28712[(4)]))){
var statearr_28738_28754 = state_28712;
(statearr_28738_28754[(1)] = cljs.core.first.call(null,(state_28712[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28755 = state_28712;
state_28712 = G__28755;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2454__auto__ = function(state_28712){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2454__auto____1.call(this,state_28712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2454__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2454__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_28739 = f__2477__auto__.call(null);
(statearr_28739[(6)] = c__2476__auto__);

return statearr_28739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k28757,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__28761 = k28757;
var G__28761__$1 = (((G__28761 instanceof cljs.core.Keyword))?G__28761.fqn:null);
switch (G__28761__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28757,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__28762){
var vec__28763 = p__28762;
var k__4403__auto__ = cljs.core.nth.call(null,vec__28763,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__28763,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28756){
var self__ = this;
var G__28756__$1 = this;
return (new cljs.core.RecordIter((0),G__28756__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28758,other28759){
var self__ = this;
var this28758__$1 = this;
return (((!((other28759 == null)))) && ((this28758__$1.constructor === other28759.constructor)) && (cljs.core._EQ_.call(null,this28758__$1.id,other28759.id)) && (cljs.core._EQ_.call(null,this28758__$1.servers,other28759.servers)) && (cljs.core._EQ_.call(null,this28758__$1.state,other28759.state)) && (cljs.core._EQ_.call(null,this28758__$1.req_chan,other28759.req_chan)) && (cljs.core._EQ_.call(null,this28758__$1.sub_chan,other28759.sub_chan)) && (cljs.core._EQ_.call(null,this28758__$1.pub_chan,other28759.pub_chan)) && (cljs.core._EQ_.call(null,this28758__$1.storage_read,other28759.storage_read)) && (cljs.core._EQ_.call(null,this28758__$1.storage_write,other28759.storage_write)) && (cljs.core._EQ_.call(null,this28758__$1.object_cache,other28759.object_cache)) && (cljs.core._EQ_.call(null,this28758__$1.parallelism,other28759.parallelism)) && (cljs.core._EQ_.call(null,this28758__$1.serializer,other28759.serializer)) && (cljs.core._EQ_.call(null,this28758__$1.default_network,other28759.default_network)) && (cljs.core._EQ_.call(null,this28758__$1.transactor_QMARK_,other28759.transactor_QMARK_)) && (cljs.core._EQ_.call(null,this28758__$1.publish,other28759.publish)) && (cljs.core._EQ_.call(null,this28758__$1.transact_handler,other28759.transact_handler)) && (cljs.core._EQ_.call(null,this28758__$1.tx_private_key,other28759.tx_private_key)) && (cljs.core._EQ_.call(null,this28758__$1.tx_key_id,other28759.tx_key_id)) && (cljs.core._EQ_.call(null,this28758__$1.meta,other28759.meta)) && (cljs.core._EQ_.call(null,this28758__$1.add_listener,other28759.add_listener)) && (cljs.core._EQ_.call(null,this28758__$1.remove_listener,other28759.remove_listener)) && (cljs.core._EQ_.call(null,this28758__$1.close,other28759.close)) && (cljs.core._EQ_.call(null,this28758__$1.__extmap,other28759.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__28756){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__28766 = cljs.core.keyword_identical_QMARK_;
var expr__28767 = k__4388__auto__;
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__28767))){
return (new fluree.db.connection.Connection(G__28756,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,G__28756,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__28756,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__28756,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__28756,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__28756,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__28756,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__28756,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__28756,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__28756,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__28756,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__28756,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__28756,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__28756,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__28756,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__28756,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__28756,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__28756,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__28756,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__28756,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28766.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__28767))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__28756,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__28756),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__28756){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__28756,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__28760){
var extmap__4419__auto__ = (function (){var G__28769 = cljs.core.dissoc.call(null,G__28760,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__28760)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28769);
} else {
return G__28769;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__28760),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28760),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__28774 = servers_STAR_;
var vec__28775 = G__28774;
var seq__28776 = cljs.core.seq.call(null,vec__28775);
var first__28777 = cljs.core.first.call(null,seq__28776);
var seq__28776__$1 = cljs.core.next.call(null,seq__28776);
var server = first__28777;
var r = seq__28776__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__28774__$1 = G__28774;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__28781 = G__28774__$1;
var seq__28782 = cljs.core.seq.call(null,vec__28781);
var first__28783 = cljs.core.first.call(null,seq__28782);
var seq__28782__$1 = cljs.core.next.call(null,seq__28782);
var server__$1 = first__28783;
var r__$1 = seq__28782__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__28784 = r__$1;
var G__28785 = is_https_QMARK_;
var G__28786 = result_STAR_;
G__28774__$1 = G__28784;
https_QMARK___$1 = G__28785;
result__$1 = G__28786;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.connection !== 'undefined') && (typeof fluree.db.connection.process_event !== 'undefined')){
} else {
fluree.db.connection.process_event = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.connection","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.connection.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.connection.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__28787 = cljs.core.seq.call(null,callbacks);
var chunk__28788 = null;
var count__28789 = (0);
var i__28790 = (0);
while(true){
if((i__28790 < count__28789)){
var vec__28799 = cljs.core._nth.call(null,chunk__28788,i__28790);
var k = cljs.core.nth.call(null,vec__28799,(0),null);
var f = cljs.core.nth.call(null,vec__28799,(1),null);
try{f.call(null,event_type,event_data);
}catch (e28802){if((e28802 instanceof java.lang.Exception)){
var e_28807 = e28802;
fluree.db.util.log.error.call(null,e_28807,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
} else {
throw e28802;

}
}

var G__28808 = seq__28787;
var G__28809 = chunk__28788;
var G__28810 = count__28789;
var G__28811 = (i__28790 + (1));
seq__28787 = G__28808;
chunk__28788 = G__28809;
count__28789 = G__28810;
i__28790 = G__28811;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__28787);
if(temp__5735__auto__){
var seq__28787__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28787__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__28787__$1);
var G__28812 = cljs.core.chunk_rest.call(null,seq__28787__$1);
var G__28813 = c__4556__auto__;
var G__28814 = cljs.core.count.call(null,c__4556__auto__);
var G__28815 = (0);
seq__28787 = G__28812;
chunk__28788 = G__28813;
count__28789 = G__28814;
i__28790 = G__28815;
continue;
} else {
var vec__28803 = cljs.core.first.call(null,seq__28787__$1);
var k = cljs.core.nth.call(null,vec__28803,(0),null);
var f = cljs.core.nth.call(null,vec__28803,(1),null);
try{f.call(null,event_type,event_data);
}catch (e28806){if((e28806 instanceof java.lang.Exception)){
var e_28816 = e28806;
fluree.db.util.log.error.call(null,e_28816,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
} else {
throw e28806;

}
}

var G__28817 = cljs.core.next.call(null,seq__28787__$1);
var G__28818 = null;
var G__28819 = (0);
var G__28820 = (0);
seq__28787 = G__28817;
chunk__28788 = G__28818;
count__28789 = G__28819;
i__28790 = G__28820;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.connection.process_events = (function fluree$db$connection$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__28823 = msg;
var event_type = cljs.core.nth.call(null,vec__28823,(0),null);
var subject = cljs.core.nth.call(null,vec__28823,(1),null);
var event_data = cljs.core.nth.call(null,vec__28823,(2),null);
var error_data = cljs.core.nth.call(null,vec__28823,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__28826 = conn;
var map__28826__$1 = (((((!((map__28826 == null))))?(((((map__28826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28826.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28826):map__28826);
var state = cljs.core.get.call(null,map__28826__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__28828 = event_type__$1;
var G__28828__$1 = (((G__28828 instanceof cljs.core.Keyword))?G__28828.fqn:null);
switch (G__28828__$1) {
case "response":
var temp__5735__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5735__auto__)){
var res_chan = temp__5735__auto__;
cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__28821_SHARP_){
return cljs.core.dissoc.call(null,p1__28821_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__28829 = error_data;
var map__28829__$1 = (((((!((map__28829 == null))))?(((((map__28829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28829):map__28829);
var message = cljs.core.get.call(null,map__28829__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.connection.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e28822){if((e28822 instanceof java.lang.Exception)){
var e = e28822;
return fluree.db.util.log.error.call(null,e);
} else {
throw e28822;

}
}});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__28832 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__28832 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__28832);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_28861){
var state_val_28862 = (state_28861[(1)]);
if((state_val_28862 === (7))){
var inst_28847 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28848 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28849 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28850 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28851 = fluree.db.connection.establish_socket.call(null,inst_28847,inst_28848,inst_28849,inst_28850);
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28861__$1,(9),inst_28851);
} else {
if((state_val_28862 === (1))){
var state_28861__$1 = state_28861;
var statearr_28863_28882 = state_28861__$1;
(statearr_28863_28882[(2)] = null);

(statearr_28863_28882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (4))){
var inst_28833 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
var statearr_28864_28883 = state_28861__$1;
(statearr_28864_28883[(2)] = inst_28833);

(statearr_28864_28883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (6))){
var inst_28844 = (state_28861[(7)]);
var state_28861__$1 = state_28861;
var statearr_28865_28884 = state_28861__$1;
(statearr_28865_28884[(2)] = inst_28844);

(statearr_28865_28884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (3))){
var inst_28859 = (state_28861[(2)]);
var state_28861__$1 = state_28861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28861__$1,inst_28859);
} else {
if((state_val_28862 === (2))){
var inst_28844 = (state_28861[(7)]);
var _ = (function (){var statearr_28867 = state_28861;
(statearr_28867[(4)] = cljs.core.cons.call(null,(5),(state_28861[(4)])));

return statearr_28867;
})();
var inst_28839 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_28840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28841 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28842 = [inst_28841,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_28843 = (new cljs.core.PersistentVector(null,3,(5),inst_28840,inst_28842,null));
var inst_28844__$1 = cljs.core.get_in.call(null,inst_28839,inst_28843);
var state_28861__$1 = (function (){var statearr_28868 = state_28861;
(statearr_28868[(7)] = inst_28844__$1);

return statearr_28868;
})();
if(cljs.core.truth_(inst_28844__$1)){
var statearr_28869_28885 = state_28861__$1;
(statearr_28869_28885[(1)] = (6));

} else {
var statearr_28870_28886 = state_28861__$1;
(statearr_28870_28886[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (9))){
var inst_28853 = (state_28861[(2)]);
var inst_28854 = fluree.db.util.async.throw_err.call(null,inst_28853);
var state_28861__$1 = state_28861;
var statearr_28871_28887 = state_28861__$1;
(statearr_28871_28887[(2)] = inst_28854);

(statearr_28871_28887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (5))){
var _ = (function (){var statearr_28872 = state_28861;
(statearr_28872[(4)] = cljs.core.rest.call(null,(state_28861[(4)])));

return statearr_28872;
})();
var state_28861__$1 = state_28861;
var ex28866 = (state_28861__$1[(2)]);
var statearr_28873_28888 = state_28861__$1;
(statearr_28873_28888[(5)] = ex28866);


if((ex28866 instanceof Error)){
var statearr_28874_28889 = state_28861__$1;
(statearr_28874_28889[(1)] = (4));

(statearr_28874_28889[(5)] = null);

} else {
throw ex28866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28862 === (8))){
var inst_28856 = (state_28861[(2)]);
var _ = (function (){var statearr_28875 = state_28861;
(statearr_28875[(4)] = cljs.core.rest.call(null,(state_28861[(4)])));

return statearr_28875;
})();
var state_28861__$1 = state_28861;
var statearr_28876_28890 = state_28861__$1;
(statearr_28876_28890[(2)] = inst_28856);

(statearr_28876_28890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2454__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2454__auto____0 = (function (){
var statearr_28877 = [null,null,null,null,null,null,null,null];
(statearr_28877[(0)] = fluree$db$connection$get_socket_$_state_machine__2454__auto__);

(statearr_28877[(1)] = (1));

return statearr_28877;
});
var fluree$db$connection$get_socket_$_state_machine__2454__auto____1 = (function (state_28861){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e28878){var ex__2457__auto__ = e28878;
var statearr_28879_28891 = state_28861;
(statearr_28879_28891[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28861[(4)]))){
var statearr_28880_28892 = state_28861;
(statearr_28880_28892[(1)] = cljs.core.first.call(null,(state_28861[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28893 = state_28861;
state_28861 = G__28893;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2454__auto__ = function(state_28861){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2454__auto____1.call(this,state_28861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2454__auto____0;
fluree$db$connection$get_socket_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2454__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_28881 = f__2477__auto__.call(null);
(statearr_28881[(6)] = c__2476__auto__);

return statearr_28881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e28894){if((e28894 instanceof java.lang.Exception)){
var e = e28894;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
} else {
throw e28894;

}
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29041){
var state_val_29042 = (state_29041[(1)]);
if((state_val_29042 === (7))){
var inst_29037 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29044_29127 = state_29041__$1;
(statearr_29044_29127[(2)] = inst_29037);

(statearr_29044_29127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (20))){
var _ = (function (){var statearr_29045 = state_29041;
(statearr_29045[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29045;
})();
var state_29041__$1 = state_29041;
var ex29043 = (state_29041__$1[(2)]);
var statearr_29046_29128 = state_29041__$1;
(statearr_29046_29128[(5)] = ex29043);


if((ex29043 instanceof java.lang.Exception)){
var statearr_29047_29129 = state_29041__$1;
(statearr_29047_29129[(1)] = (10));

(statearr_29047_29129[(5)] = null);

} else {
throw ex29043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (27))){
var inst_28939 = (state_29041[(7)]);
var inst_28957 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28939);
var state_29041__$1 = state_29041;
var statearr_29048_29130 = state_29041__$1;
(statearr_29048_29130[(2)] = inst_28957);

(statearr_29048_29130[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (1))){
var inst_28896 = (0);
var state_29041__$1 = (function (){var statearr_29049 = state_29041;
(statearr_29049[(8)] = inst_28896);

return statearr_29049;
})();
var statearr_29050_29131 = state_29041__$1;
(statearr_29050_29131[(2)] = null);

(statearr_29050_29131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (24))){
var state_29041__$1 = state_29041;
var statearr_29051_29132 = state_29041__$1;
(statearr_29051_29132[(2)] = true);

(statearr_29051_29132[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (39))){
var inst_29027 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29052_29133 = state_29041__$1;
(statearr_29052_29133[(2)] = inst_29027);

(statearr_29052_29133[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (4))){
var inst_28899 = (state_29041[(9)]);
var inst_28899__$1 = (state_29041[(2)]);
var state_29041__$1 = (function (){var statearr_29053 = state_29041;
(statearr_29053[(9)] = inst_28899__$1);

return statearr_29053;
})();
if(cljs.core.truth_(inst_28899__$1)){
var statearr_29054_29134 = state_29041__$1;
(statearr_29054_29134[(1)] = (5));

} else {
var statearr_29055_29135 = state_29041__$1;
(statearr_29055_29135[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (15))){
var inst_28912 = (state_29041[(10)]);
var state_29041__$1 = state_29041;
var statearr_29056_29136 = state_29041__$1;
(statearr_29056_29136[(2)] = inst_28912);

(statearr_29056_29136[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (21))){
var inst_28939 = (state_29041[(7)]);
var inst_28944 = inst_28939.cljs$lang$protocol_mask$partition0$;
var inst_28945 = (inst_28944 & (64));
var inst_28946 = inst_28939.cljs$core$ISeq$;
var inst_28947 = (cljs.core.PROTOCOL_SENTINEL === inst_28946);
var inst_28948 = ((inst_28945) || (inst_28947));
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_28948)){
var statearr_29057_29137 = state_29041__$1;
(statearr_29057_29137[(1)] = (24));

} else {
var statearr_29058_29138 = state_29041__$1;
(statearr_29058_29138[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (31))){
var state_29041__$1 = state_29041;
var statearr_29059_29139 = state_29041__$1;
(statearr_29059_29139[(2)] = null);

(statearr_29059_29139[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (32))){
var inst_28963 = (state_29041[(11)]);
var inst_28936 = (state_29041[(12)]);
var inst_28937 = (state_29041[(13)]);
var inst_29001 = (state_29041[(2)]);
var inst_29002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29003 = [inst_28936,inst_28963,inst_28937];
var inst_29004 = (new cljs.core.PersistentVector(null,3,(5),inst_29002,inst_29003,null));
var inst_29005 = publish_fn.call(null,conn,inst_29004);
var state_29041__$1 = (function (){var statearr_29060 = state_29041;
(statearr_29060[(14)] = inst_29001);

return statearr_29060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29041__$1,(33),inst_29005);
} else {
if((state_val_29042 === (40))){
var inst_29017 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_29041__$1 = state_29041;
var statearr_29061_29140 = state_29041__$1;
(statearr_29061_29140[(2)] = inst_29017);

(statearr_29061_29140[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (33))){
var inst_29007 = (state_29041[(15)]);
var inst_29007__$1 = (state_29041[(2)]);
var inst_29008 = inst_29007__$1 === true;
var state_29041__$1 = (function (){var statearr_29062 = state_29041;
(statearr_29062[(15)] = inst_29007__$1);

return statearr_29062;
})();
if(cljs.core.truth_(inst_29008)){
var statearr_29063_29141 = state_29041__$1;
(statearr_29063_29141[(1)] = (34));

} else {
var statearr_29064_29142 = state_29041__$1;
(statearr_29064_29142[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (13))){
var inst_28912 = (state_29041[(10)]);
var inst_28909 = (state_29041[(2)]);
var inst_28910 = cljs.core.nth.call(null,inst_28909,(0),null);
var inst_28911 = cljs.core.nth.call(null,inst_28909,(1),null);
var inst_28912__$1 = cljs.core.nth.call(null,inst_28909,(2),null);
var state_29041__$1 = (function (){var statearr_29065 = state_29041;
(statearr_29065[(16)] = inst_28911);

(statearr_29065[(10)] = inst_28912__$1);

(statearr_29065[(17)] = inst_28910);

return statearr_29065;
})();
if(cljs.core.truth_(inst_28912__$1)){
var statearr_29066_29143 = state_29041__$1;
(statearr_29066_29143[(1)] = (14));

} else {
var statearr_29067_29144 = state_29041__$1;
(statearr_29067_29144[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (22))){
var state_29041__$1 = state_29041;
var statearr_29068_29145 = state_29041__$1;
(statearr_29068_29145[(2)] = false);

(statearr_29068_29145[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (36))){
var inst_29029 = (state_29041[(2)]);
var _ = (function (){var statearr_29069 = state_29041;
(statearr_29069[(4)] = cljs.core.rest.call(null,(state_29041[(4)])));

return statearr_29069;
})();
var state_29041__$1 = state_29041;
var statearr_29070_29146 = state_29041__$1;
(statearr_29070_29146[(2)] = inst_29029);

(statearr_29070_29146[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (41))){
var state_29041__$1 = state_29041;
var statearr_29071_29147 = state_29041__$1;
(statearr_29071_29147[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (43))){
var inst_29007 = (state_29041[(15)]);
var inst_29020 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_29007);
var state_29041__$1 = state_29041;
var statearr_29073_29148 = state_29041__$1;
(statearr_29073_29148[(2)] = inst_29020);

(statearr_29073_29148[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (29))){
var inst_28960 = (state_29041[(18)]);
var inst_28938 = (state_29041[(19)]);
var inst_28960__$1 = (state_29041[(2)]);
var inst_28961 = fluree.db.util.core.random_uuid.call(null);
var inst_28962 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28961);
var inst_28963 = cljs.core.get.call(null,inst_28960__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_28962);
var inst_28964 = cljs.core.get.call(null,inst_28960__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_29041__$1 = (function (){var statearr_29074 = state_29041;
(statearr_29074[(11)] = inst_28963);

(statearr_29074[(18)] = inst_28960__$1);

(statearr_29074[(20)] = inst_28964);

return statearr_29074;
})();
if(cljs.core.truth_(inst_28938)){
var statearr_29075_29149 = state_29041__$1;
(statearr_29075_29149[(1)] = (30));

} else {
var statearr_29076_29150 = state_29041__$1;
(statearr_29076_29150[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (44))){
var state_29041__$1 = state_29041;
var statearr_29077_29151 = state_29041__$1;
(statearr_29077_29151[(2)] = null);

(statearr_29077_29151[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (6))){
var state_29041__$1 = state_29041;
var statearr_29078_29152 = state_29041__$1;
(statearr_29078_29152[(2)] = null);

(statearr_29078_29152[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (28))){
var inst_28939 = (state_29041[(7)]);
var state_29041__$1 = state_29041;
var statearr_29079_29153 = state_29041__$1;
(statearr_29079_29153[(2)] = inst_28939);

(statearr_29079_29153[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (25))){
var state_29041__$1 = state_29041;
var statearr_29080_29154 = state_29041__$1;
(statearr_29080_29154[(2)] = false);

(statearr_29080_29154[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (34))){
var state_29041__$1 = state_29041;
var statearr_29081_29155 = state_29041__$1;
(statearr_29081_29155[(2)] = null);

(statearr_29081_29155[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (17))){
var inst_28912 = (state_29041[(10)]);
var inst_28901 = (state_29041[(21)]);
var inst_28919 = cljs.core.async.put_BANG_.call(null,inst_28912,inst_28901);
var state_29041__$1 = state_29041;
var statearr_29082_29156 = state_29041__$1;
(statearr_29082_29156[(2)] = inst_28919);

(statearr_29082_29156[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (3))){
var inst_29039 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29041__$1,inst_29039);
} else {
if((state_val_29042 === (12))){
var state_29041__$1 = state_29041;
var statearr_29083_29157 = state_29041__$1;
(statearr_29083_29157[(2)] = null);

(statearr_29083_29157[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (2))){
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29041__$1,(4),req_chan);
} else {
if((state_val_29042 === (23))){
var inst_28955 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_28955)){
var statearr_29084_29158 = state_29041__$1;
(statearr_29084_29158[(1)] = (27));

} else {
var statearr_29085_29159 = state_29041__$1;
(statearr_29085_29159[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (35))){
var inst_29007 = (state_29041[(15)]);
var inst_29011 = fluree.db.util.core.exception_QMARK_.call(null,inst_29007);
var state_29041__$1 = state_29041;
if(inst_29011){
var statearr_29086_29160 = state_29041__$1;
(statearr_29086_29160[(1)] = (37));

} else {
var statearr_29087_29161 = state_29041__$1;
(statearr_29087_29161[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (19))){
var inst_28925 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29088_29162 = state_29041__$1;
(statearr_29088_29162[(2)] = inst_28925);

(statearr_29088_29162[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (11))){
var inst_28899 = (state_29041[(9)]);
var state_29041__$1 = state_29041;
var statearr_29089_29163 = state_29041__$1;
(statearr_29089_29163[(2)] = inst_28899);

(statearr_29089_29163[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (9))){
var inst_28896 = (state_29041[(8)]);
var inst_29032 = (state_29041[(2)]);
var inst_29033 = (inst_28896 + (1));
var inst_28896__$1 = inst_29033;
var state_29041__$1 = (function (){var statearr_29090 = state_29041;
(statearr_29090[(8)] = inst_28896__$1);

(statearr_29090[(22)] = inst_29032);

return statearr_29090;
})();
var statearr_29091_29164 = state_29041__$1;
(statearr_29091_29164[(2)] = null);

(statearr_29091_29164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (5))){
var state_29041__$1 = state_29041;
var statearr_29092_29165 = state_29041__$1;
(statearr_29092_29165[(2)] = null);

(statearr_29092_29165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (14))){
var inst_28912 = (state_29041[(10)]);
var inst_28914 = fluree.db.util.async.channel_QMARK_.call(null,inst_28912);
var state_29041__$1 = state_29041;
var statearr_29093_29166 = state_29041__$1;
(statearr_29093_29166[(2)] = inst_28914);

(statearr_29093_29166[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (45))){
var inst_29023 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29094_29167 = state_29041__$1;
(statearr_29094_29167[(2)] = inst_29023);

(statearr_29094_29167[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (26))){
var inst_28952 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29095_29168 = state_29041__$1;
(statearr_29095_29168[(2)] = inst_28952);

(statearr_29095_29168[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (16))){
var inst_28917 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_28917)){
var statearr_29096_29169 = state_29041__$1;
(statearr_29096_29169[(1)] = (17));

} else {
var statearr_29097_29170 = state_29041__$1;
(statearr_29097_29170[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (38))){
var inst_29007 = (state_29041[(15)]);
var inst_29015 = (inst_29007 == null);
var state_29041__$1 = state_29041;
if(cljs.core.truth_(inst_29015)){
var statearr_29098_29171 = state_29041__$1;
(statearr_29098_29171[(1)] = (40));

} else {
var statearr_29099_29172 = state_29041__$1;
(statearr_29099_29172[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (30))){
var inst_28963 = (state_29041[(11)]);
var inst_28960 = (state_29041[(18)]);
var inst_28964 = (state_29041[(20)]);
var inst_28896 = (state_29041[(8)]);
var inst_28938 = (state_29041[(19)]);
var inst_28939 = (state_29041[(7)]);
var inst_28899 = (state_29041[(9)]);
var inst_28935 = (state_29041[(23)]);
var inst_28936 = (state_29041[(12)]);
var inst_28937 = (state_29041[(13)]);
var inst_28966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28967 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_28963];
var inst_28968 = (new cljs.core.PersistentVector(null,2,(5),inst_28966,inst_28967,null));
var inst_28969 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_28968,inst_28938);
var inst_28996 = cljs.core.async.chan.call(null,(1));
var inst_28997 = (function (){var resp_chan = inst_28938;
var timeout = inst_28964;
var i = inst_28896;
var data = inst_28937;
var vec__28931 = inst_28899;
var c__2476__auto____$1 = inst_28996;
var _ = inst_28935;
var req_id = inst_28963;
var operation = inst_28936;
var map__28934 = inst_28960;
var msg = inst_28899;
var opts = inst_28939;
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_28994){
var state_val_28995 = (state_28994[(1)]);
if((state_val_28995 === (1))){
var inst_28973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28974 = cljs.core.async.timeout.call(null,timeout);
var inst_28975 = [resp_chan,inst_28974];
var inst_28976 = (new cljs.core.PersistentVector(null,2,(5),inst_28973,inst_28975,null));
var state_28994__$1 = state_28994;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28994__$1,(2),inst_28976);
} else {
if((state_val_28995 === (2))){
var inst_28979 = (state_28994[(7)]);
var inst_28978 = (state_28994[(2)]);
var inst_28979__$1 = cljs.core.nth.call(null,inst_28978,(0),null);
var inst_28980 = cljs.core.nth.call(null,inst_28978,(1),null);
var inst_28981 = (function (){var vec__28970 = inst_28978;
var resp = inst_28979__$1;
var c = inst_28980;
return (function (p1__28895_SHARP_){
return cljs.core.dissoc.call(null,p1__28895_SHARP_,req_id);
});
})();
var inst_28982 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_28981);
var inst_28983 = cljs.core._EQ_.call(null,inst_28980,resp_chan);
var state_28994__$1 = (function (){var statearr_29100 = state_28994;
(statearr_29100[(8)] = inst_28982);

(statearr_29100[(7)] = inst_28979__$1);

return statearr_29100;
})();
if(inst_28983){
var statearr_29101_29173 = state_28994__$1;
(statearr_29101_29173[(1)] = (3));

} else {
var statearr_29102_29174 = state_28994__$1;
(statearr_29102_29174[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28995 === (3))){
var inst_28979 = (state_28994[(7)]);
var state_28994__$1 = state_28994;
var statearr_29103_29175 = state_28994__$1;
(statearr_29103_29175[(2)] = inst_28979);

(statearr_29103_29175[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28995 === (4))){
var inst_28986 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_28987 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28988 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_28989 = cljs.core.PersistentHashMap.fromArrays(inst_28987,inst_28988);
var inst_28990 = cljs.core.ex_info.call(null,inst_28986,inst_28989);
var state_28994__$1 = state_28994;
var statearr_29104_29176 = state_28994__$1;
(statearr_29104_29176[(2)] = inst_28990);

(statearr_29104_29176[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28995 === (5))){
var inst_28992 = (state_28994[(2)]);
var state_28994__$1 = state_28994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28994__$1,inst_28992);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2454__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2454__auto____0 = (function (){
var statearr_29105 = [null,null,null,null,null,null,null,null,null];
(statearr_29105[(0)] = fluree$db$connection$msg_producer_$_state_machine__2454__auto__);

(statearr_29105[(1)] = (1));

return statearr_29105;
});
var fluree$db$connection$msg_producer_$_state_machine__2454__auto____1 = (function (state_28994){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_28994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29106){var ex__2457__auto__ = e29106;
var statearr_29107_29177 = state_28994;
(statearr_29107_29177[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_28994[(4)]))){
var statearr_29108_29178 = state_28994;
(statearr_29108_29178[(1)] = cljs.core.first.call(null,(state_28994[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29179 = state_28994;
state_28994 = G__29179;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2454__auto__ = function(state_28994){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2454__auto____1.call(this,state_28994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2454__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2454__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29109 = f__2477__auto__.call(null);
(statearr_29109[(6)] = c__2476__auto____$1);

return statearr_29109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});
})();
var inst_28998 = cljs.core.async.impl.dispatch.run.call(null,inst_28997);
var state_29041__$1 = (function (){var statearr_29110 = state_29041;
(statearr_29110[(24)] = inst_28969);

(statearr_29110[(25)] = inst_28998);

return statearr_29110;
})();
var statearr_29111_29180 = state_29041__$1;
(statearr_29111_29180[(2)] = inst_28996);

(statearr_29111_29180[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (10))){
var inst_28899 = (state_29041[(9)]);
var inst_28901 = (state_29041[(2)]);
var inst_28905 = cljs.core.sequential_QMARK_.call(null,inst_28899);
var state_29041__$1 = (function (){var statearr_29112 = state_29041;
(statearr_29112[(21)] = inst_28901);

return statearr_29112;
})();
if(inst_28905){
var statearr_29113_29181 = state_29041__$1;
(statearr_29113_29181[(1)] = (11));

} else {
var statearr_29114_29182 = state_29041__$1;
(statearr_29114_29182[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (18))){
var inst_28899 = (state_29041[(9)]);
var inst_28901 = (state_29041[(21)]);
var inst_28921 = cljs.core.pr_str.call(null,inst_28899);
var inst_28922 = ["Error processing ledger request, no valid return channel: ",inst_28921].join('');
var inst_28923 = fluree.db.util.log.error.call(null,inst_28901,inst_28922);
var state_29041__$1 = state_29041;
var statearr_29115_29183 = state_29041__$1;
(statearr_29115_29183[(2)] = inst_28923);

(statearr_29115_29183[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (42))){
var inst_29025 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29116_29184 = state_29041__$1;
(statearr_29116_29184[(2)] = inst_29025);

(statearr_29116_29184[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (37))){
var inst_29007 = (state_29041[(15)]);
var inst_29013 = fluree.db.util.log.error.call(null,inst_29007,"Error processing message in producer.");
var state_29041__$1 = state_29041;
var statearr_29117_29185 = state_29041__$1;
(statearr_29117_29185[(2)] = inst_29013);

(statearr_29117_29185[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (8))){
var inst_28939 = (state_29041[(7)]);
var inst_28899 = (state_29041[(9)]);
var _ = (function (){var statearr_29118 = state_29041;
(statearr_29118[(4)] = cljs.core.cons.call(null,(20),(state_29041[(4)])));

return statearr_29118;
})();
var inst_28935 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_28899);
var inst_28936 = cljs.core.nth.call(null,inst_28899,(0),null);
var inst_28937 = cljs.core.nth.call(null,inst_28899,(1),null);
var inst_28938 = cljs.core.nth.call(null,inst_28899,(2),null);
var inst_28939__$1 = cljs.core.nth.call(null,inst_28899,(3),null);
var inst_28941 = (inst_28939__$1 == null);
var inst_28942 = cljs.core.not.call(null,inst_28941);
var state_29041__$1 = (function (){var statearr_29119 = state_29041;
(statearr_29119[(19)] = inst_28938);

(statearr_29119[(7)] = inst_28939__$1);

(statearr_29119[(23)] = inst_28935);

(statearr_29119[(12)] = inst_28936);

(statearr_29119[(13)] = inst_28937);

return statearr_29119;
})();
if(inst_28942){
var statearr_29120_29186 = state_29041__$1;
(statearr_29120_29186[(1)] = (21));

} else {
var statearr_29121_29187 = state_29041__$1;
(statearr_29121_29187[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2454__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2454__auto____0 = (function (){
var statearr_29122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29122[(0)] = fluree$db$connection$msg_producer_$_state_machine__2454__auto__);

(statearr_29122[(1)] = (1));

return statearr_29122;
});
var fluree$db$connection$msg_producer_$_state_machine__2454__auto____1 = (function (state_29041){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29123){var ex__2457__auto__ = e29123;
var statearr_29124_29188 = state_29041;
(statearr_29124_29188[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29041[(4)]))){
var statearr_29125_29189 = state_29041;
(statearr_29125_29189[(1)] = cljs.core.first.call(null,(state_29041[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29190 = state_29041;
state_29041 = G__29190;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2454__auto__ = function(state_29041){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2454__auto____1.call(this,state_29041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2454__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2454__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29126 = f__2477__auto__.call(null);
(statearr_29126[(6)] = c__2476__auto__);

return statearr_29126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__29191 = conn;
var map__29191__$1 = (((((!((map__29191 == null))))?(((((map__29191.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29191.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29191):map__29191);
var sub_chan = cljs.core.get.call(null,map__29191__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29274){
var state_val_29275 = (state_29274[(1)]);
if((state_val_29275 === (7))){
var inst_29270 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29276_29327 = state_29274__$1;
(statearr_29276_29327[(2)] = inst_29270);

(statearr_29276_29327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (20))){
var inst_29211 = (state_29274[(7)]);
var inst_29225 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_29226 = [inst_29211];
var inst_29227 = cljs.core.PersistentHashMap.fromArrays(inst_29225,inst_29226);
var inst_29228 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_29227);
var state_29274__$1 = state_29274;
var statearr_29277_29328 = state_29274__$1;
(statearr_29277_29328[(2)] = inst_29228);

(statearr_29277_29328[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (27))){
var state_29274__$1 = state_29274;
var statearr_29278_29329 = state_29274__$1;
(statearr_29278_29329[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (1))){
var inst_29193 = (0);
var state_29274__$1 = (function (){var statearr_29280 = state_29274;
(statearr_29280[(8)] = inst_29193);

return statearr_29280;
})();
var statearr_29281_29330 = state_29274__$1;
(statearr_29281_29330[(2)] = null);

(statearr_29281_29330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (24))){
var inst_29204 = (state_29274[(9)]);
var inst_29253 = fluree.db.util.core.exception_QMARK_.call(null,inst_29204);
var state_29274__$1 = state_29274;
if(inst_29253){
var statearr_29282_29331 = state_29274__$1;
(statearr_29282_29331[(1)] = (26));

} else {
var statearr_29283_29332 = state_29274__$1;
(statearr_29283_29332[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (4))){
var inst_29198 = (state_29274[(10)]);
var inst_29203 = (state_29274[(2)]);
var inst_29204 = cljs.core.nth.call(null,inst_29203,(0),null);
var inst_29205 = cljs.core.nth.call(null,inst_29203,(1),null);
var inst_29206 = cljs.core._EQ_.call(null,inst_29205,inst_29198);
var state_29274__$1 = (function (){var statearr_29284 = state_29274;
(statearr_29284[(9)] = inst_29204);

return statearr_29284;
})();
if(inst_29206){
var statearr_29285_29333 = state_29274__$1;
(statearr_29285_29333[(1)] = (5));

} else {
var statearr_29286_29334 = state_29274__$1;
(statearr_29286_29334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (15))){
var inst_29211 = (state_29274[(7)]);
var inst_29220 = typeof inst_29211 === 'string';
var state_29274__$1 = state_29274;
if(cljs.core.truth_(inst_29220)){
var statearr_29287_29335 = state_29274__$1;
(statearr_29287_29335[(1)] = (17));

} else {
var statearr_29288_29336 = state_29274__$1;
(statearr_29288_29336[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (21))){
var state_29274__$1 = state_29274;
var statearr_29289_29337 = state_29274__$1;
(statearr_29289_29337[(2)] = null);

(statearr_29289_29337[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (31))){
var inst_29264 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29290_29338 = state_29274__$1;
(statearr_29290_29338[(2)] = inst_29264);

(statearr_29290_29338[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (13))){
var inst_29237 = (state_29274[(2)]);
var inst_29238 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29239 = fluree.db.connection.close_websocket.call(null,inst_29238);
var inst_29240 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29241 = fluree.db.session.close_all_sessions.call(null,inst_29240);
var state_29274__$1 = (function (){var statearr_29291 = state_29274;
(statearr_29291[(11)] = inst_29239);

(statearr_29291[(12)] = inst_29237);

return statearr_29291;
})();
var statearr_29292_29339 = state_29274__$1;
(statearr_29292_29339[(2)] = inst_29241);

(statearr_29292_29339[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (22))){
var inst_29231 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29293_29340 = state_29274__$1;
(statearr_29293_29340[(2)] = inst_29231);

(statearr_29293_29340[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (29))){
var inst_29204 = (state_29274[(9)]);
var inst_29259 = fluree.db.util.json.parse.call(null,inst_29204);
var inst_29260 = fluree.db.connection.process_events.call(null,conn,inst_29259);
var inst_29193 = (0);
var state_29274__$1 = (function (){var statearr_29294 = state_29274;
(statearr_29294[(13)] = inst_29260);

(statearr_29294[(8)] = inst_29193);

return statearr_29294;
})();
var statearr_29295_29341 = state_29274__$1;
(statearr_29295_29341[(2)] = null);

(statearr_29295_29341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (6))){
var inst_29204 = (state_29274[(9)]);
var inst_29249 = (inst_29204 == null);
var state_29274__$1 = state_29274;
if(cljs.core.truth_(inst_29249)){
var statearr_29296_29342 = state_29274__$1;
(statearr_29296_29342[(1)] = (23));

} else {
var statearr_29297_29343 = state_29274__$1;
(statearr_29297_29343[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (28))){
var inst_29266 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29298_29344 = state_29274__$1;
(statearr_29298_29344[(2)] = inst_29266);

(statearr_29298_29344[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (25))){
var inst_29268 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29299_29345 = state_29274__$1;
(statearr_29299_29345[(2)] = inst_29268);

(statearr_29299_29345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (17))){
var inst_29211 = (state_29274[(7)]);
var inst_29222 = cljs.core.eval.call(null,inst_29211);
var state_29274__$1 = state_29274;
var statearr_29300_29346 = state_29274__$1;
(statearr_29300_29346[(2)] = inst_29222);

(statearr_29300_29346[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (3))){
var inst_29272 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29274__$1,inst_29272);
} else {
if((state_val_29275 === (12))){
var inst_29211 = (state_29274[(7)]);
var inst_29216 = cljs.core.fn_QMARK_.call(null,inst_29211);
var state_29274__$1 = state_29274;
if(inst_29216){
var statearr_29301_29347 = state_29274__$1;
(statearr_29301_29347[(1)] = (14));

} else {
var statearr_29302_29348 = state_29274__$1;
(statearr_29302_29348[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (2))){
var inst_29198 = (state_29274[(10)]);
var inst_29198__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_29199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29200 = [sub_chan,inst_29198__$1];
var inst_29201 = (new cljs.core.PersistentVector(null,2,(5),inst_29199,inst_29200,null));
var state_29274__$1 = (function (){var statearr_29303 = state_29274;
(statearr_29303[(10)] = inst_29198__$1);

return statearr_29303;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29274__$1,(4),inst_29201);
} else {
if((state_val_29275 === (23))){
var inst_29251 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_29274__$1 = state_29274;
var statearr_29304_29349 = state_29274__$1;
(statearr_29304_29349[(2)] = inst_29251);

(statearr_29304_29349[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (19))){
var inst_29233 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29305_29350 = state_29274__$1;
(statearr_29305_29350[(2)] = inst_29233);

(statearr_29305_29350[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (11))){
var inst_29214 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_29274__$1 = state_29274;
var statearr_29306_29351 = state_29274__$1;
(statearr_29306_29351[(2)] = inst_29214);

(statearr_29306_29351[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (9))){
var inst_29193 = (state_29274[(8)]);
var inst_29243 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_29244 = (inst_29193 + (1));
var inst_29193__$1 = inst_29244;
var state_29274__$1 = (function (){var statearr_29307 = state_29274;
(statearr_29307[(14)] = inst_29243);

(statearr_29307[(8)] = inst_29193__$1);

return statearr_29307;
})();
var statearr_29308_29352 = state_29274__$1;
(statearr_29308_29352[(2)] = null);

(statearr_29308_29352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (5))){
var inst_29193 = (state_29274[(8)]);
var inst_29208 = cljs.core._EQ_.call(null,(2),inst_29193);
var state_29274__$1 = state_29274;
if(inst_29208){
var statearr_29309_29353 = state_29274__$1;
(statearr_29309_29353[(1)] = (8));

} else {
var statearr_29310_29354 = state_29274__$1;
(statearr_29310_29354[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (14))){
var inst_29211 = (state_29274[(7)]);
var inst_29218 = inst_29211.call(null);
var state_29274__$1 = state_29274;
var statearr_29311_29355 = state_29274__$1;
(statearr_29311_29355[(2)] = inst_29218);

(statearr_29311_29355[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (26))){
var inst_29204 = (state_29274[(9)]);
var inst_29255 = fluree.db.util.log.error.call(null,inst_29204);
var inst_29193 = (0);
var state_29274__$1 = (function (){var statearr_29312 = state_29274;
(statearr_29312[(8)] = inst_29193);

(statearr_29312[(15)] = inst_29255);

return statearr_29312;
})();
var statearr_29313_29356 = state_29274__$1;
(statearr_29313_29356[(2)] = null);

(statearr_29313_29356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (16))){
var inst_29235 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29314_29357 = state_29274__$1;
(statearr_29314_29357[(2)] = inst_29235);

(statearr_29314_29357[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (30))){
var state_29274__$1 = state_29274;
var statearr_29315_29358 = state_29274__$1;
(statearr_29315_29358[(2)] = null);

(statearr_29315_29358[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (10))){
var inst_29247 = (state_29274[(2)]);
var state_29274__$1 = state_29274;
var statearr_29316_29359 = state_29274__$1;
(statearr_29316_29359[(2)] = inst_29247);

(statearr_29316_29359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (18))){
var state_29274__$1 = state_29274;
var statearr_29317_29360 = state_29274__$1;
(statearr_29317_29360[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29275 === (8))){
var inst_29211 = (state_29274[(7)]);
var inst_29210 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_29211__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29212 = (inst_29211__$1 == null);
var state_29274__$1 = (function (){var statearr_29319 = state_29274;
(statearr_29319[(7)] = inst_29211__$1);

(statearr_29319[(16)] = inst_29210);

return statearr_29319;
})();
if(cljs.core.truth_(inst_29212)){
var statearr_29320_29361 = state_29274__$1;
(statearr_29320_29361[(1)] = (11));

} else {
var statearr_29321_29362 = state_29274__$1;
(statearr_29321_29362[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2454__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2454__auto____0 = (function (){
var statearr_29322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29322[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2454__auto__);

(statearr_29322[(1)] = (1));

return statearr_29322;
});
var fluree$db$connection$msg_consumer_$_state_machine__2454__auto____1 = (function (state_29274){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29323){var ex__2457__auto__ = e29323;
var statearr_29324_29363 = state_29274;
(statearr_29324_29363[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29274[(4)]))){
var statearr_29325_29364 = state_29274;
(statearr_29325_29364[(1)] = cljs.core.first.call(null,(state_29274[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29365 = state_29274;
state_29274 = G__29365;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2454__auto__ = function(state_29274){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2454__auto____1.call(this,state_29274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2454__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2454__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29326 = f__2477__auto__.call(null);
(statearr_29326[(6)] = c__2476__auto__);

return statearr_29326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__29367 = arguments.length;
switch (G__29367) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__29368 = opts;
var map__29368__$1 = (((((!((map__29368 == null))))?(((((map__29368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29368):map__29368);
var private$ = cljs.core.get.call(null,map__29368__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__29368__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29431){
var state_val_29432 = (state_29431[(1)]);
if((state_val_29432 === (7))){
var inst_29379 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_29380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29381 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_29382 = (new cljs.core.PersistentVector(null,2,(5),inst_29380,inst_29381,null));
var inst_29383 = cljs.core.get_in.call(null,inst_29379,inst_29382);
var state_29431__$1 = state_29431;
var statearr_29433_29474 = state_29431__$1;
(statearr_29433_29474[(2)] = inst_29383);

(statearr_29433_29474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (20))){
var inst_29410 = (state_29431[(7)]);
var state_29431__$1 = state_29431;
var statearr_29434_29475 = state_29431__$1;
(statearr_29434_29475[(2)] = inst_29410);

(statearr_29434_29475[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (1))){
var state_29431__$1 = state_29431;
var statearr_29435_29476 = state_29431__$1;
(statearr_29435_29476[(2)] = null);

(statearr_29435_29476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (4))){
var inst_29370 = (state_29431[(2)]);
var state_29431__$1 = state_29431;
var statearr_29436_29477 = state_29431__$1;
(statearr_29436_29477[(2)] = inst_29370);

(statearr_29436_29477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (15))){
var inst_29385 = (state_29431[(8)]);
var inst_29404 = (state_29431[(2)]);
var state_29431__$1 = (function (){var statearr_29437 = state_29431;
(statearr_29437[(9)] = inst_29404);

return statearr_29437;
})();
if(cljs.core.truth_(inst_29385)){
var statearr_29438_29478 = state_29431__$1;
(statearr_29438_29478[(1)] = (16));

} else {
var statearr_29439_29479 = state_29431__$1;
(statearr_29439_29479[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (21))){
var inst_29390 = (state_29431[(10)]);
var inst_29419 = (state_29431[(2)]);
var inst_29420 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_29421 = [(5000),inst_29419,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_29422 = cljs.core.PersistentHashMap.fromArrays(inst_29420,inst_29421);
var inst_29423 = fluree.db.util.xhttp.get.call(null,inst_29390,inst_29422);
var state_29431__$1 = state_29431;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29431__$1,(22),inst_29423);
} else {
if((state_val_29432 === (13))){
var inst_29399 = (state_29431[(11)]);
var inst_29385 = (state_29431[(8)]);
var inst_29401 = cljs.core.assoc.call(null,inst_29399,"X-fdb-jwt",inst_29385);
var state_29431__$1 = state_29431;
var statearr_29440_29480 = state_29431__$1;
(statearr_29440_29480[(2)] = inst_29401);

(statearr_29440_29480[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (22))){
var inst_29425 = (state_29431[(2)]);
var inst_29426 = fluree.db.util.async.throw_err.call(null,inst_29425);
var _ = (function (){var statearr_29441 = state_29431;
(statearr_29441[(4)] = cljs.core.rest.call(null,(state_29431[(4)])));

return statearr_29441;
})();
var state_29431__$1 = state_29431;
var statearr_29442_29481 = state_29431__$1;
(statearr_29442_29481[(2)] = inst_29426);

(statearr_29442_29481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (6))){
var inst_29376 = (state_29431[(12)]);
var state_29431__$1 = state_29431;
var statearr_29443_29482 = state_29431__$1;
(statearr_29443_29482[(2)] = inst_29376);

(statearr_29443_29482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (17))){
var inst_29404 = (state_29431[(9)]);
var state_29431__$1 = state_29431;
var statearr_29444_29483 = state_29431__$1;
(statearr_29444_29483[(2)] = inst_29404);

(statearr_29444_29483[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (3))){
var inst_29429 = (state_29431[(2)]);
var state_29431__$1 = state_29431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29431__$1,inst_29429);
} else {
if((state_val_29432 === (12))){
var inst_29385 = (state_29431[(8)]);
var inst_29399 = (state_29431[(2)]);
var state_29431__$1 = (function (){var statearr_29445 = state_29431;
(statearr_29445[(11)] = inst_29399);

return statearr_29445;
})();
if(cljs.core.truth_(inst_29385)){
var statearr_29446_29484 = state_29431__$1;
(statearr_29446_29484[(1)] = (13));

} else {
var statearr_29447_29485 = state_29431__$1;
(statearr_29447_29485[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (2))){
var inst_29376 = (state_29431[(12)]);
var _ = (function (){var statearr_29448 = state_29431;
(statearr_29448[(4)] = cljs.core.cons.call(null,(5),(state_29431[(4)])));

return statearr_29448;
})();
var inst_29376__$1 = jwt;
var state_29431__$1 = (function (){var statearr_29449 = state_29431;
(statearr_29449[(12)] = inst_29376__$1);

return statearr_29449;
})();
if(cljs.core.truth_(inst_29376__$1)){
var statearr_29450_29486 = state_29431__$1;
(statearr_29450_29486[(1)] = (6));

} else {
var statearr_29451_29487 = state_29431__$1;
(statearr_29451_29487[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (19))){
var inst_29410 = (state_29431[(7)]);
var inst_29390 = (state_29431[(10)]);
var inst_29412 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_29413 = [inst_29410];
var inst_29414 = cljs.core.PersistentHashMap.fromArrays(inst_29412,inst_29413);
var inst_29415 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_29390,inst_29414,private$);
var inst_29416 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_29415);
var state_29431__$1 = state_29431;
var statearr_29452_29488 = state_29431__$1;
(statearr_29452_29488[(2)] = inst_29416);

(statearr_29452_29488[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (11))){
var inst_29394 = (state_29431[(13)]);
var state_29431__$1 = state_29431;
var statearr_29454_29489 = state_29431__$1;
(statearr_29454_29489[(2)] = inst_29394);

(statearr_29454_29489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (9))){
var inst_29386 = (state_29431[(14)]);
var inst_29389 = (state_29431[(2)]);
var inst_29390 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29389),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29386)].join('');
var inst_29392 = ["Accept"];
var inst_29393 = ["application/json"];
var inst_29394 = cljs.core.PersistentHashMap.fromArrays(inst_29392,inst_29393);
var state_29431__$1 = (function (){var statearr_29455 = state_29431;
(statearr_29455[(10)] = inst_29390);

(statearr_29455[(13)] = inst_29394);

return statearr_29455;
})();
if(cljs.core.truth_(private$)){
var statearr_29456_29490 = state_29431__$1;
(statearr_29456_29490[(1)] = (10));

} else {
var statearr_29457_29491 = state_29431__$1;
(statearr_29457_29491[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (5))){
var _ = (function (){var statearr_29458 = state_29431;
(statearr_29458[(4)] = cljs.core.rest.call(null,(state_29431[(4)])));

return statearr_29458;
})();
var state_29431__$1 = state_29431;
var ex29453 = (state_29431__$1[(2)]);
var statearr_29459_29492 = state_29431__$1;
(statearr_29459_29492[(5)] = ex29453);


if((ex29453 instanceof Error)){
var statearr_29460_29493 = state_29431__$1;
(statearr_29460_29493[(1)] = (4));

(statearr_29460_29493[(5)] = null);

} else {
throw ex29453;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (14))){
var inst_29399 = (state_29431[(11)]);
var state_29431__$1 = state_29431;
var statearr_29461_29494 = state_29431__$1;
(statearr_29461_29494[(2)] = inst_29399);

(statearr_29461_29494[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (16))){
var inst_29404 = (state_29431[(9)]);
var inst_29385 = (state_29431[(8)]);
var inst_29406 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29385)].join('');
var inst_29407 = cljs.core.assoc.call(null,inst_29404,"Authorization",inst_29406);
var state_29431__$1 = state_29431;
var statearr_29462_29495 = state_29431__$1;
(statearr_29462_29495[(2)] = inst_29407);

(statearr_29462_29495[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (10))){
var inst_29394 = (state_29431[(13)]);
var inst_29396 = cljs.core.assoc.call(null,inst_29394,"X-fdb-pri",private$);
var state_29431__$1 = state_29431;
var statearr_29463_29496 = state_29431__$1;
(statearr_29463_29496[(2)] = inst_29396);

(statearr_29463_29496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (18))){
var inst_29410 = (state_29431[(2)]);
var state_29431__$1 = (function (){var statearr_29464 = state_29431;
(statearr_29464[(7)] = inst_29410);

return statearr_29464;
})();
if(cljs.core.truth_(private$)){
var statearr_29465_29497 = state_29431__$1;
(statearr_29465_29497[(1)] = (19));

} else {
var statearr_29466_29498 = state_29431__$1;
(statearr_29466_29498[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29432 === (8))){
var inst_29385 = (state_29431[(2)]);
var inst_29386 = clojure.string.replace.call(null,k,"_","/");
var inst_29387 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_29431__$1 = (function (){var statearr_29467 = state_29431;
(statearr_29467[(14)] = inst_29386);

(statearr_29467[(8)] = inst_29385);

return statearr_29467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29431__$1,(9),inst_29387);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2454__auto__ = null;
var fluree$db$connection$state_machine__2454__auto____0 = (function (){
var statearr_29468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29468[(0)] = fluree$db$connection$state_machine__2454__auto__);

(statearr_29468[(1)] = (1));

return statearr_29468;
});
var fluree$db$connection$state_machine__2454__auto____1 = (function (state_29431){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29469){var ex__2457__auto__ = e29469;
var statearr_29470_29499 = state_29431;
(statearr_29470_29499[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29431[(4)]))){
var statearr_29471_29500 = state_29431;
(statearr_29471_29500[(1)] = cljs.core.first.call(null,(state_29431[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29501 = state_29431;
state_29431 = G__29501;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2454__auto__ = function(state_29431){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2454__auto____1.call(this,state_29431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2454__auto____0;
fluree$db$connection$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2454__auto____1;
return fluree$db$connection$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29472 = f__2477__auto__.call(null);
(statearr_29472[(6)] = c__2476__auto__);

return statearr_29472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn_state){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,conn_state));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__29502_SHARP_){
if(cljs.core.truth_(p1__29502_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__29503 = opts;
var map__29503__$1 = (((((!((map__29503 == null))))?(((((map__29503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29503):map__29503);
var sub_chan = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__29503__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e29505){var _ = e29505;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29538 = arguments.length;
var i__4737__auto___29539 = (0);
while(true){
if((i__4737__auto___29539 < len__4736__auto___29538)){
args__4742__auto__.push((arguments[i__4737__auto___29539]));

var G__29540 = (i__4737__auto___29539 + (1));
i__4737__auto___29539 = G__29540;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__29508){
var vec__29509 = p__29508;
var opts = cljs.core.nth.call(null,vec__29509,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2476__auto___29541 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29526){
var state_val_29527 = (state_29526[(1)]);
if((state_val_29527 === (1))){
var inst_29512 = fluree.db.connection.get_socket.call(null,conn);
var state_29526__$1 = state_29526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29526__$1,(2),inst_29512);
} else {
if((state_val_29527 === (2))){
var inst_29514 = (state_29526[(2)]);
var inst_29515 = (inst_29514 == null);
var inst_29516 = fluree.db.util.core.exception_QMARK_.call(null,inst_29514);
var inst_29517 = ((inst_29515) || (inst_29516));
var state_29526__$1 = state_29526;
if(cljs.core.truth_(inst_29517)){
var statearr_29528_29542 = state_29526__$1;
(statearr_29528_29542[(1)] = (3));

} else {
var statearr_29529_29543 = state_29526__$1;
(statearr_29529_29543[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29527 === (3))){
var inst_29519 = fluree.db.util.log.warn.call(null,"Cannot establish connection to a healthy server, disconnecting.");
var inst_29520 = cljs.core.async.close_BANG_.call(null,conn);
var state_29526__$1 = (function (){var statearr_29530 = state_29526;
(statearr_29530[(7)] = inst_29519);

return statearr_29530;
})();
var statearr_29531_29544 = state_29526__$1;
(statearr_29531_29544[(2)] = inst_29520);

(statearr_29531_29544[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29527 === (4))){
var inst_29522 = fluree.db.connection.msg_consumer.call(null,conn);
var state_29526__$1 = state_29526;
var statearr_29532_29545 = state_29526__$1;
(statearr_29532_29545[(2)] = inst_29522);

(statearr_29532_29545[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29527 === (5))){
var inst_29524 = (state_29526[(2)]);
var state_29526__$1 = state_29526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29526__$1,inst_29524);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2454__auto__ = null;
var fluree$db$connection$state_machine__2454__auto____0 = (function (){
var statearr_29533 = [null,null,null,null,null,null,null,null];
(statearr_29533[(0)] = fluree$db$connection$state_machine__2454__auto__);

(statearr_29533[(1)] = (1));

return statearr_29533;
});
var fluree$db$connection$state_machine__2454__auto____1 = (function (state_29526){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29534){var ex__2457__auto__ = e29534;
var statearr_29535_29546 = state_29526;
(statearr_29535_29546[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29526[(4)]))){
var statearr_29536_29547 = state_29526;
(statearr_29536_29547[(1)] = cljs.core.first.call(null,(state_29526[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29548 = state_29526;
state_29526 = G__29548;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2454__auto__ = function(state_29526){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2454__auto____1.call(this,state_29526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2454__auto____0;
fluree$db$connection$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2454__auto____1;
return fluree$db$connection$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29537 = f__2477__auto__.call(null);
(statearr_29537[(6)] = c__2476__auto___29541);

return statearr_29537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq29506){
var G__29507 = cljs.core.first.call(null,seq29506);
var seq29506__$1 = cljs.core.next.call(null,seq29506);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29507,seq29506__$1);
}));

