(ns fluree.db.util.cljs-shim)

(defmacro inline-resource
  "Macro allowing ClojureScript to inline a SMALL bundle of resource file(s) (< 1mb)
  at compile time.  If inline content grows, need to consider publishing to
  and downloading from a cdn

  This command is needed during compilation, which records the following warnings
  that should be ignored.
  1. Use of undeclared Var fluree.db.util.core/slurp
  2. Use of undeclared Var clojure.java.io/resource"
  [resource-path]
  (slurp (clojure.java.io/resource resource-path)))

