// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__126871 = (line + (1));
var G__126872 = (1);
var G__126873 = (counter + (1));
line = G__126871;
col = G__126872;
counter = G__126873;
continue;
} else {
var G__126874 = line;
var G__126875 = (col + (1));
var G__126876 = (counter + (1));
line = G__126874;
col = G__126875;
counter = G__126876;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__126877 = cljs.core.next.call(null,chars);
var G__126878 = (n__$1 - (1));
chars = G__126877;
n__$1 = G__126878;
continue;
} else {
var G__126879 = cljs.core.next.call(null,chars);
var G__126880 = n__$1;
chars = G__126879;
n__$1 = G__126880;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__126881){
var map__126882 = p__126881;
var map__126882__$1 = (((((!((map__126882 == null))))?(((((map__126882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__126882):map__126882);
var line = cljs.core.get.call(null,map__126882__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__126882__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__126882__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__126882__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__126884_126892 = cljs.core.seq.call(null,full_reasons);
var chunk__126885_126893 = null;
var count__126886_126894 = (0);
var i__126887_126895 = (0);
while(true){
if((i__126887_126895 < count__126886_126894)){
var r_126896 = cljs.core._nth.call(null,chunk__126885_126893,i__126887_126895);
instaparse.failure.print_reason.call(null,r_126896);

cljs.core.println.call(null," (followed by end-of-string)");


var G__126897 = seq__126884_126892;
var G__126898 = chunk__126885_126893;
var G__126899 = count__126886_126894;
var G__126900 = (i__126887_126895 + (1));
seq__126884_126892 = G__126897;
chunk__126885_126893 = G__126898;
count__126886_126894 = G__126899;
i__126887_126895 = G__126900;
continue;
} else {
var temp__5735__auto___126901 = cljs.core.seq.call(null,seq__126884_126892);
if(temp__5735__auto___126901){
var seq__126884_126902__$1 = temp__5735__auto___126901;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__126884_126902__$1)){
var c__4556__auto___126903 = cljs.core.chunk_first.call(null,seq__126884_126902__$1);
var G__126904 = cljs.core.chunk_rest.call(null,seq__126884_126902__$1);
var G__126905 = c__4556__auto___126903;
var G__126906 = cljs.core.count.call(null,c__4556__auto___126903);
var G__126907 = (0);
seq__126884_126892 = G__126904;
chunk__126885_126893 = G__126905;
count__126886_126894 = G__126906;
i__126887_126895 = G__126907;
continue;
} else {
var r_126908 = cljs.core.first.call(null,seq__126884_126902__$1);
instaparse.failure.print_reason.call(null,r_126908);

cljs.core.println.call(null," (followed by end-of-string)");


var G__126909 = cljs.core.next.call(null,seq__126884_126902__$1);
var G__126910 = null;
var G__126911 = (0);
var G__126912 = (0);
seq__126884_126892 = G__126909;
chunk__126885_126893 = G__126910;
count__126886_126894 = G__126911;
i__126887_126895 = G__126912;
continue;
}
} else {
}
}
break;
}

var seq__126888 = cljs.core.seq.call(null,partial_reasons);
var chunk__126889 = null;
var count__126890 = (0);
var i__126891 = (0);
while(true){
if((i__126891 < count__126890)){
var r = cljs.core._nth.call(null,chunk__126889,i__126891);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__126913 = seq__126888;
var G__126914 = chunk__126889;
var G__126915 = count__126890;
var G__126916 = (i__126891 + (1));
seq__126888 = G__126913;
chunk__126889 = G__126914;
count__126890 = G__126915;
i__126891 = G__126916;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__126888);
if(temp__5735__auto__){
var seq__126888__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__126888__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__126888__$1);
var G__126917 = cljs.core.chunk_rest.call(null,seq__126888__$1);
var G__126918 = c__4556__auto__;
var G__126919 = cljs.core.count.call(null,c__4556__auto__);
var G__126920 = (0);
seq__126888 = G__126917;
chunk__126889 = G__126918;
count__126890 = G__126919;
i__126891 = G__126920;
continue;
} else {
var r = cljs.core.first.call(null,seq__126888__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__126921 = cljs.core.next.call(null,seq__126888__$1);
var G__126922 = null;
var G__126923 = (0);
var G__126924 = (0);
seq__126888 = G__126921;
chunk__126889 = G__126922;
count__126890 = G__126923;
i__126891 = G__126924;
continue;
}
} else {
return null;
}
}
break;
}
});
