// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__103102 = match;
var p1 = cljs.core.nth.call(null,vec__103102,(0),null);
var p2 = cljs.core.nth.call(null,vec__103102,(1),null);
var p3 = cljs.core.nth.call(null,vec__103102,(2),null);
var t = cljs.core.nth.call(null,vec__103102,(3),null);
var op = cljs.core.nth.call(null,vec__103102,(4),null);
var m = cljs.core.nth.call(null,vec__103102,(5),null);
var G__103105 = idx;
var G__103105__$1 = (((G__103105 instanceof cljs.core.Keyword))?G__103105.fqn:null);
switch (G__103105__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103105__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__103107 = idx;
var G__103107__$1 = (((G__103107 instanceof cljs.core.Keyword))?G__103107.fqn:null);
switch (G__103107__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103107__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__103109 = idx;
var G__103109__$1 = (((G__103109 instanceof cljs.core.Keyword))?G__103109.fqn:null);
switch (G__103109__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103109__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__103112 = arguments.length;
switch (G__103112) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__103113 = (function (){var pred__103116 = cljs.core.identical_QMARK_;
var expr__103117 = test;
if(cljs.core.truth_(pred__103116.call(null,cljs.core._EQ_,expr__103117))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103116.call(null,cljs.core._LT_,expr__103117))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__103116.call(null,cljs.core._LT__EQ_,expr__103117))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103116.call(null,cljs.core._GT_,expr__103117))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__103116.call(null,cljs.core._GT__EQ_,expr__103117))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__103117)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__103113,(0),null);
var start_match = cljs.core.nth.call(null,vec__103113,(1),null);
var end_test = cljs.core.nth.call(null,vec__103113,(2),null);
var end_match = cljs.core.nth.call(null,vec__103113,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103327){
var state_val_103328 = (state_103327[(1)]);
if((state_val_103328 === (65))){
var inst_103288 = (state_103327[(7)]);
var inst_103281 = (state_103327[(8)]);
var inst_103280 = (state_103327[(9)]);
var inst_103295 = (inst_103280 + (1));
var tmp103329 = inst_103281;
var inst_103279 = inst_103288;
var inst_103280__$1 = inst_103295;
var inst_103281__$1 = tmp103329;
var state_103327__$1 = (function (){var statearr_103330 = state_103327;
(statearr_103330[(8)] = inst_103281__$1);

(statearr_103330[(10)] = inst_103279);

(statearr_103330[(9)] = inst_103280__$1);

return statearr_103330;
})();
var statearr_103331_103438 = state_103327__$1;
(statearr_103331_103438[(2)] = null);

(statearr_103331_103438[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (70))){
var inst_103302 = (state_103327[(11)]);
var state_103327__$1 = state_103327;
var statearr_103332_103439 = state_103327__$1;
(statearr_103332_103439[(2)] = inst_103302);

(statearr_103332_103439[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (62))){
var inst_103279 = (state_103327[(10)]);
var inst_103280 = (state_103327[(9)]);
var inst_103221 = (state_103327[(12)]);
var inst_103286 = cljs.core.seq.call(null,inst_103279);
var inst_103287 = cljs.core.first.call(null,inst_103286);
var inst_103288 = cljs.core.next.call(null,inst_103286);
var inst_103289 = (inst_103287 == null);
var inst_103290 = (inst_103280 > inst_103221);
var inst_103291 = ((inst_103289) || (inst_103290));
var state_103327__$1 = (function (){var statearr_103333 = state_103327;
(statearr_103333[(7)] = inst_103288);

return statearr_103333;
})();
if(cljs.core.truth_(inst_103291)){
var statearr_103334_103440 = state_103327__$1;
(statearr_103334_103440[(1)] = (64));

} else {
var statearr_103335_103441 = state_103327__$1;
(statearr_103335_103441[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (7))){
var inst_103137 = (state_103327[(13)]);
var inst_103151 = (state_103327[(2)]);
var inst_103152 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103137);
var state_103327__$1 = (function (){var statearr_103336 = state_103327;
(statearr_103336[(14)] = inst_103151);

return statearr_103336;
})();
if(inst_103152){
var statearr_103337_103442 = state_103327__$1;
(statearr_103337_103442[(1)] = (9));

} else {
var statearr_103338_103443 = state_103327__$1;
(statearr_103338_103443[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (59))){
var inst_103248 = (state_103327[(15)]);
var inst_103262 = (state_103327[(16)]);
var inst_103249 = (state_103327[(17)]);
var inst_103221 = (state_103327[(12)]);
var inst_103265 = (inst_103221 - inst_103248);
var inst_103266 = fluree.db.flake.take.call(null,inst_103265,inst_103262);
var inst_103267 = cljs.core.into.call(null,inst_103266,inst_103249);
var state_103327__$1 = state_103327;
var statearr_103339_103444 = state_103327__$1;
(statearr_103339_103444[(2)] = inst_103267);

(statearr_103339_103444[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (20))){
var inst_103174 = (state_103327[(2)]);
var inst_103175 = fluree.db.util.async.throw_err.call(null,inst_103174);
var state_103327__$1 = state_103327;
var statearr_103340_103445 = state_103327__$1;
(statearr_103340_103445[(2)] = inst_103175);

(statearr_103340_103445[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (72))){
var inst_103321 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103341_103446 = state_103327__$1;
(statearr_103341_103446[(2)] = inst_103321);

(statearr_103341_103446[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (58))){
var inst_103247 = (state_103327[(18)]);
var inst_103262 = (state_103327[(2)]);
var inst_103263 = fluree.db.dbproto._rhs.call(null,inst_103247);
var state_103327__$1 = (function (){var statearr_103342 = state_103327;
(statearr_103342[(16)] = inst_103262);

(statearr_103342[(19)] = inst_103263);

return statearr_103342;
})();
var statearr_103343_103447 = state_103327__$1;
(statearr_103343_103447[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (60))){
var inst_103248 = (state_103327[(15)]);
var inst_103262 = (state_103327[(16)]);
var inst_103276 = cljs.core.seq.call(null,inst_103262);
var inst_103277 = cljs.core.first.call(null,inst_103276);
var inst_103278 = cljs.core.next.call(null,inst_103276);
var inst_103279 = inst_103262;
var inst_103280 = inst_103248;
var inst_103281 = inst_103262;
var state_103327__$1 = (function (){var statearr_103345 = state_103327;
(statearr_103345[(20)] = inst_103278);

(statearr_103345[(21)] = inst_103277);

(statearr_103345[(8)] = inst_103281);

(statearr_103345[(10)] = inst_103279);

(statearr_103345[(9)] = inst_103280);

return statearr_103345;
})();
var statearr_103346_103448 = state_103327__$1;
(statearr_103346_103448[(2)] = null);

(statearr_103346_103448[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (27))){
var inst_103178 = (state_103327[(22)]);
var state_103327__$1 = state_103327;
var statearr_103347_103449 = state_103327__$1;
(statearr_103347_103449[(2)] = inst_103178);

(statearr_103347_103449[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (1))){
var state_103327__$1 = state_103327;
var statearr_103348_103450 = state_103327__$1;
(statearr_103348_103450[(2)] = null);

(statearr_103348_103450[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (69))){
var inst_103311 = (state_103327[(2)]);
var inst_103312 = cljs.core.not.call(null,inst_103311);
var state_103327__$1 = state_103327;
if(inst_103312){
var statearr_103349_103451 = state_103327__$1;
(statearr_103349_103451[(1)] = (70));

} else {
var statearr_103350_103452 = state_103327__$1;
(statearr_103350_103452[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (24))){
var state_103327__$1 = state_103327;
var statearr_103351_103453 = state_103327__$1;
(statearr_103351_103453[(2)] = (-1));

(statearr_103351_103453[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (55))){
var inst_103215 = (state_103327[(23)]);
var inst_103216 = (state_103327[(24)]);
var inst_103254 = (state_103327[(25)]);
var inst_103253 = (state_103327[(2)]);
var inst_103254__$1 = fluree.db.util.async.throw_err.call(null,inst_103253);
var inst_103255 = fluree.db.flake.subrange.call(null,inst_103254__$1,start_test,inst_103215,end_test,inst_103216);
var inst_103256 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_103215,inst_103216);
var state_103327__$1 = (function (){var statearr_103352 = state_103327;
(statearr_103352[(26)] = inst_103255);

(statearr_103352[(25)] = inst_103254__$1);

return statearr_103352;
})();
if(inst_103256){
var statearr_103353_103454 = state_103327__$1;
(statearr_103353_103454[(1)] = (56));

} else {
var statearr_103354_103455 = state_103327__$1;
(statearr_103354_103455[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (39))){
var inst_103142 = (state_103327[(27)]);
var state_103327__$1 = state_103327;
var statearr_103355_103456 = state_103327__$1;
(statearr_103355_103456[(2)] = inst_103142);

(statearr_103355_103456[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (46))){
var state_103327__$1 = state_103327;
var statearr_103356_103457 = state_103327__$1;
(statearr_103356_103457[(2)] = fluree.db.util.core.max_long);

(statearr_103356_103457[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (4))){
var inst_103136 = (state_103327[(28)]);
var inst_103129 = (state_103327[(29)]);
var inst_103130 = (state_103327[(30)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103327,(3),Error,null,(2));
var inst_103129__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_103130__$1 = cljs.core.nth.call(null,inst_103129__$1,(0),null);
var inst_103131 = cljs.core.nth.call(null,inst_103129__$1,(1),null);
var inst_103132 = cljs.core.nth.call(null,inst_103129__$1,(2),null);
var inst_103133 = cljs.core.nth.call(null,inst_103129__$1,(3),null);
var inst_103134 = cljs.core.nth.call(null,inst_103129__$1,(4),null);
var inst_103135 = cljs.core.nth.call(null,inst_103129__$1,(5),null);
var inst_103136__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_103137 = cljs.core.nth.call(null,inst_103136__$1,(0),null);
var inst_103138 = cljs.core.nth.call(null,inst_103136__$1,(1),null);
var inst_103139 = cljs.core.nth.call(null,inst_103136__$1,(2),null);
var inst_103140 = cljs.core.nth.call(null,inst_103136__$1,(3),null);
var inst_103141 = cljs.core.nth.call(null,inst_103136__$1,(4),null);
var inst_103142 = cljs.core.nth.call(null,inst_103136__$1,(5),null);
var inst_103143 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103130__$1);
var state_103327__$1 = (function (){var statearr_103357 = state_103327;
(statearr_103357[(27)] = inst_103142);

(statearr_103357[(31)] = inst_103131);

(statearr_103357[(28)] = inst_103136__$1);

(statearr_103357[(32)] = inst_103134);

(statearr_103357[(33)] = inst_103133);

(statearr_103357[(13)] = inst_103137);

(statearr_103357[(29)] = inst_103129__$1);

(statearr_103357[(34)] = inst_103132);

(statearr_103357[(35)] = inst_103135);

(statearr_103357[(30)] = inst_103130__$1);

(statearr_103357[(36)] = inst_103138);

(statearr_103357[(37)] = inst_103141);

(statearr_103357[(38)] = inst_103140);

(statearr_103357[(39)] = inst_103139);

return statearr_103357;
})();
if(inst_103143){
var statearr_103358_103458 = state_103327__$1;
(statearr_103358_103458[(1)] = (5));

} else {
var statearr_103359_103459 = state_103327__$1;
(statearr_103359_103459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (54))){
var inst_103323 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103360_103460 = state_103327__$1;
(statearr_103360_103460[(2)] = inst_103323);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103327__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (15))){
var inst_103139 = (state_103327[(39)]);
var inst_103169 = (state_103327[(2)]);
var inst_103170 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103139);
var state_103327__$1 = (function (){var statearr_103361 = state_103327;
(statearr_103361[(40)] = inst_103169);

return statearr_103361;
})();
if(inst_103170){
var statearr_103362_103461 = state_103327__$1;
(statearr_103362_103461[(1)] = (17));

} else {
var statearr_103363_103462 = state_103327__$1;
(statearr_103363_103462[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (48))){
var inst_103227 = (state_103327[(41)]);
var state_103327__$1 = state_103327;
var statearr_103364_103463 = state_103327__$1;
(statearr_103364_103463[(2)] = inst_103227);

(statearr_103364_103463[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (50))){
var inst_103232 = (state_103327[(2)]);
var inst_103233 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_103234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103235 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_103236 = (new cljs.core.PersistentVector(null,2,(5),inst_103234,inst_103235,null));
var inst_103237 = cljs.core.get_in.call(null,db,inst_103236);
var inst_103238 = cljs.core.get.call(null,db,idx);
var inst_103239 = fluree.db.dbproto._resolve.call(null,inst_103238);
var state_103327__$1 = (function (){var statearr_103365 = state_103327;
(statearr_103365[(42)] = inst_103233);

(statearr_103365[(43)] = inst_103232);

(statearr_103365[(44)] = inst_103237);

return statearr_103365;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(51),inst_103239);
} else {
if((state_val_103328 === (21))){
var inst_103169 = (state_103327[(40)]);
var state_103327__$1 = state_103327;
var statearr_103366_103464 = state_103327__$1;
(statearr_103366_103464[(2)] = inst_103169);

(statearr_103366_103464[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (31))){
var inst_103138 = (state_103327[(36)]);
var state_103327__$1 = state_103327;
var statearr_103367_103465 = state_103327__$1;
(statearr_103367_103465[(2)] = inst_103138);

(statearr_103367_103465[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (32))){
var inst_103135 = (state_103327[(35)]);
var inst_103196 = (state_103327[(2)]);
var state_103327__$1 = (function (){var statearr_103368 = state_103327;
(statearr_103368[(45)] = inst_103196);

return statearr_103368;
})();
if(cljs.core.truth_(inst_103135)){
var statearr_103369_103466 = state_103327__$1;
(statearr_103369_103466[(1)] = (33));

} else {
var statearr_103370_103467 = state_103327__$1;
(statearr_103370_103467[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (40))){
var inst_103208 = (cljs.core._LT__EQ_ === end_test);
var state_103327__$1 = state_103327;
if(cljs.core.truth_(inst_103208)){
var statearr_103371_103468 = state_103327__$1;
(statearr_103371_103468[(1)] = (42));

} else {
var statearr_103372_103469 = state_103327__$1;
(statearr_103372_103469[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (56))){
var inst_103226 = (state_103327[(46)]);
var inst_103248 = (state_103327[(15)]);
var inst_103215 = (state_103327[(23)]);
var inst_103242 = (state_103327[(47)]);
var inst_103247 = (state_103327[(18)]);
var inst_103169 = (state_103327[(40)]);
var inst_103205 = (state_103327[(48)]);
var inst_103136 = (state_103327[(28)]);
var inst_103255 = (state_103327[(26)]);
var inst_103134 = (state_103327[(32)]);
var inst_103133 = (state_103327[(33)]);
var inst_103129 = (state_103327[(29)]);
var inst_103187 = (state_103327[(49)]);
var inst_103214 = (state_103327[(50)]);
var inst_103151 = (state_103327[(14)]);
var inst_103141 = (state_103327[(37)]);
var inst_103249 = (state_103327[(17)]);
var inst_103140 = (state_103327[(38)]);
var inst_103160 = (state_103327[(51)]);
var inst_103233 = (state_103327[(42)]);
var inst_103232 = (state_103327[(43)]);
var inst_103178 = (state_103327[(22)]);
var inst_103216 = (state_103327[(24)]);
var inst_103221 = (state_103327[(12)]);
var inst_103196 = (state_103327[(45)]);
var inst_103222 = (state_103327[(52)]);
var inst_103237 = (state_103327[(44)]);
var inst_103254 = (state_103327[(25)]);
var inst_103258 = (function (){var no_filter_QMARK_ = true;
var vec__103126 = inst_103136;
var next_node = inst_103247;
var flakes = inst_103254;
var s1 = inst_103151;
var o2 = inst_103178;
var t1 = inst_103133;
var i = inst_103248;
var m1 = inst_103205;
var root_node = inst_103242;
var to_t = inst_103233;
var s2 = inst_103160;
var p2 = inst_103196;
var vec__103123 = inst_103129;
var permissions = inst_103222;
var limit = inst_103221;
var start_flake = inst_103215;
var acc = inst_103249;
var t2 = inst_103140;
var op1 = inst_103134;
var o1 = inst_103169;
var end_flake = inst_103216;
var base_result = inst_103255;
var p1 = inst_103187;
var idx_compare = inst_103226;
var op2 = inst_103141;
var from_t = inst_103232;
var m2 = inst_103214;
var novelty = inst_103237;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_103259 = cljs.core.reduce.call(null,inst_103258,inst_103255,inst_103255);
var state_103327__$1 = state_103327;
var statearr_103373_103470 = state_103327__$1;
(statearr_103373_103470[(2)] = inst_103259);

(statearr_103373_103470[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (33))){
var inst_103135 = (state_103327[(35)]);
var state_103327__$1 = state_103327;
var statearr_103374_103471 = state_103327__$1;
(statearr_103374_103471[(2)] = inst_103135);

(statearr_103374_103471[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (13))){
var inst_103132 = (state_103327[(34)]);
var inst_103163 = fluree.db.dbproto._subid.call(null,db,inst_103132);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(16),inst_103163);
} else {
if((state_val_103328 === (22))){
var state_103327__$1 = state_103327;
var statearr_103375_103472 = state_103327__$1;
(statearr_103375_103472[(2)] = false);

(statearr_103375_103472[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (36))){
var state_103327__$1 = state_103327;
var statearr_103376_103473 = state_103327__$1;
(statearr_103376_103473[(2)] = fluree.db.util.core.min_integer);

(statearr_103376_103473[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (41))){
var inst_103169 = (state_103327[(40)]);
var inst_103205 = (state_103327[(48)]);
var inst_103134 = (state_103327[(32)]);
var inst_103133 = (state_103327[(33)]);
var inst_103187 = (state_103327[(49)]);
var inst_103214 = (state_103327[(50)]);
var inst_103151 = (state_103327[(14)]);
var inst_103217 = (state_103327[(53)]);
var inst_103141 = (state_103327[(37)]);
var inst_103140 = (state_103327[(38)]);
var inst_103160 = (state_103327[(51)]);
var inst_103178 = (state_103327[(22)]);
var inst_103196 = (state_103327[(45)]);
var inst_103214__$1 = (state_103327[(2)]);
var inst_103215 = fluree.db.flake.__GT_Flake.call(null,inst_103151,inst_103187,inst_103169,inst_103133,inst_103134,inst_103205);
var inst_103216 = fluree.db.flake.__GT_Flake.call(null,inst_103160,inst_103196,inst_103178,inst_103140,inst_103141,inst_103214__$1);
var inst_103217__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_103327__$1 = (function (){var statearr_103377 = state_103327;
(statearr_103377[(23)] = inst_103215);

(statearr_103377[(50)] = inst_103214__$1);

(statearr_103377[(53)] = inst_103217__$1);

(statearr_103377[(24)] = inst_103216);

return statearr_103377;
})();
if(cljs.core.truth_(inst_103217__$1)){
var statearr_103378_103474 = state_103327__$1;
(statearr_103378_103474[(1)] = (45));

} else {
var statearr_103379_103475 = state_103327__$1;
(statearr_103379_103475[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (43))){
var state_103327__$1 = state_103327;
var statearr_103380_103476 = state_103327__$1;
(statearr_103380_103476[(2)] = fluree.db.util.core.min_integer);

(statearr_103380_103476[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (61))){
var inst_103302 = (state_103327[(11)]);
var inst_103263 = (state_103327[(19)]);
var inst_103302__$1 = (state_103327[(2)]);
var inst_103303 = cljs.core.count.call(null,inst_103302__$1);
var state_103327__$1 = (function (){var statearr_103381 = state_103327;
(statearr_103381[(54)] = inst_103303);

(statearr_103381[(11)] = inst_103302__$1);

return statearr_103381;
})();
if(cljs.core.truth_(inst_103263)){
var statearr_103382_103477 = state_103327__$1;
(statearr_103382_103477[(1)] = (67));

} else {
var statearr_103383_103478 = state_103327__$1;
(statearr_103383_103478[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (29))){
var inst_103192 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
if(cljs.core.truth_(inst_103192)){
var statearr_103384_103479 = state_103327__$1;
(statearr_103384_103479[(1)] = (30));

} else {
var statearr_103385_103480 = state_103327__$1;
(statearr_103385_103480[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (44))){
var inst_103212 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103386_103481 = state_103327__$1;
(statearr_103386_103481[(2)] = inst_103212);

(statearr_103386_103481[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (6))){
var inst_103130 = (state_103327[(30)]);
var state_103327__$1 = state_103327;
var statearr_103387_103482 = state_103327__$1;
(statearr_103387_103482[(2)] = inst_103130);

(statearr_103387_103482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (28))){
var state_103327__$1 = state_103327;
var statearr_103388_103483 = state_103327__$1;
(statearr_103388_103483[(2)] = false);

(statearr_103388_103483[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (64))){
var inst_103281 = (state_103327[(8)]);
var inst_103249 = (state_103327[(17)]);
var inst_103293 = cljs.core.into.call(null,inst_103281,inst_103249);
var state_103327__$1 = state_103327;
var statearr_103389_103484 = state_103327__$1;
(statearr_103389_103484[(2)] = inst_103293);

(statearr_103389_103484[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (51))){
var inst_103215 = (state_103327[(23)]);
var inst_103242 = (state_103327[(47)]);
var inst_103241 = (state_103327[(2)]);
var inst_103242__$1 = fluree.db.util.async.throw_err.call(null,inst_103241);
var inst_103243 = fluree.db.dbproto._lookup_leaf.call(null,inst_103242__$1,inst_103215);
var state_103327__$1 = (function (){var statearr_103390 = state_103327;
(statearr_103390[(47)] = inst_103242__$1);

return statearr_103390;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(52),inst_103243);
} else {
if((state_val_103328 === (25))){
var inst_103131 = (state_103327[(31)]);
var state_103327__$1 = state_103327;
var statearr_103391_103485 = state_103327__$1;
(statearr_103391_103485[(2)] = inst_103131);

(statearr_103391_103485[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (34))){
var inst_103199 = (cljs.core._GT__EQ_ === start_test);
var state_103327__$1 = state_103327;
if(cljs.core.truth_(inst_103199)){
var statearr_103392_103486 = state_103327__$1;
(statearr_103392_103486[(1)] = (36));

} else {
var statearr_103393_103487 = state_103327__$1;
(statearr_103393_103487[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (17))){
var inst_103139 = (state_103327[(39)]);
var inst_103172 = fluree.db.dbproto._subid.call(null,db,inst_103139);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(20),inst_103172);
} else {
if((state_val_103328 === (3))){
var inst_103119 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103394_103488 = state_103327__$1;
(statearr_103394_103488[(2)] = inst_103119);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103327__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (12))){
var inst_103156 = (state_103327[(2)]);
var inst_103157 = fluree.db.util.async.throw_err.call(null,inst_103156);
var state_103327__$1 = state_103327;
var statearr_103395_103489 = state_103327__$1;
(statearr_103395_103489[(2)] = inst_103157);

(statearr_103395_103489[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (2))){
var inst_103325 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103327__$1,inst_103325);
} else {
if((state_val_103328 === (66))){
var inst_103298 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103396_103490 = state_103327__$1;
(statearr_103396_103490[(2)] = inst_103298);

(statearr_103396_103490[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (23))){
var inst_103183 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
if(cljs.core.truth_(inst_103183)){
var statearr_103397_103491 = state_103327__$1;
(statearr_103397_103491[(1)] = (24));

} else {
var statearr_103398_103492 = state_103327__$1;
(statearr_103398_103492[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (47))){
var inst_103227 = (state_103327[(41)]);
var inst_103221 = (state_103327[(2)]);
var inst_103222 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_103223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103224 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_103225 = (new cljs.core.PersistentVector(null,3,(5),inst_103223,inst_103224,null));
var inst_103226 = cljs.core.get_in.call(null,db,inst_103225);
var inst_103227__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_103327__$1 = (function (){var statearr_103399 = state_103327;
(statearr_103399[(46)] = inst_103226);

(statearr_103399[(41)] = inst_103227__$1);

(statearr_103399[(12)] = inst_103221);

(statearr_103399[(52)] = inst_103222);

return statearr_103399;
})();
if(cljs.core.truth_(inst_103227__$1)){
var statearr_103400_103493 = state_103327__$1;
(statearr_103400_103493[(1)] = (48));

} else {
var statearr_103401_103494 = state_103327__$1;
(statearr_103401_103494[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (35))){
var inst_103142 = (state_103327[(27)]);
var inst_103205 = (state_103327[(2)]);
var state_103327__$1 = (function (){var statearr_103402 = state_103327;
(statearr_103402[(48)] = inst_103205);

return statearr_103402;
})();
if(cljs.core.truth_(inst_103142)){
var statearr_103403_103495 = state_103327__$1;
(statearr_103403_103495[(1)] = (39));

} else {
var statearr_103404_103496 = state_103327__$1;
(statearr_103404_103496[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (19))){
var inst_103131 = (state_103327[(31)]);
var inst_103178 = (state_103327[(2)]);
var inst_103179 = (inst_103131 == null);
var state_103327__$1 = (function (){var statearr_103405 = state_103327;
(statearr_103405[(22)] = inst_103178);

return statearr_103405;
})();
if(cljs.core.truth_(inst_103179)){
var statearr_103406_103497 = state_103327__$1;
(statearr_103406_103497[(1)] = (21));

} else {
var statearr_103407_103498 = state_103327__$1;
(statearr_103407_103498[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (57))){
var inst_103255 = (state_103327[(26)]);
var state_103327__$1 = state_103327;
var statearr_103408_103499 = state_103327__$1;
(statearr_103408_103499[(2)] = inst_103255);

(statearr_103408_103499[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (68))){
var inst_103263 = (state_103327[(19)]);
var state_103327__$1 = state_103327;
var statearr_103409_103500 = state_103327__$1;
(statearr_103409_103500[(2)] = inst_103263);

(statearr_103409_103500[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (11))){
var inst_103132 = (state_103327[(34)]);
var inst_103160 = (state_103327[(2)]);
var inst_103161 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103132);
var state_103327__$1 = (function (){var statearr_103410 = state_103327;
(statearr_103410[(51)] = inst_103160);

return statearr_103410;
})();
if(inst_103161){
var statearr_103411_103501 = state_103327__$1;
(statearr_103411_103501[(1)] = (13));

} else {
var statearr_103412_103502 = state_103327__$1;
(statearr_103412_103502[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (9))){
var inst_103137 = (state_103327[(13)]);
var inst_103154 = fluree.db.dbproto._subid.call(null,db,inst_103137);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(12),inst_103154);
} else {
if((state_val_103328 === (5))){
var inst_103130 = (state_103327[(30)]);
var inst_103145 = fluree.db.dbproto._subid.call(null,db,inst_103130);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(8),inst_103145);
} else {
if((state_val_103328 === (14))){
var inst_103132 = (state_103327[(34)]);
var state_103327__$1 = state_103327;
var statearr_103413_103503 = state_103327__$1;
(statearr_103413_103503[(2)] = inst_103132);

(statearr_103413_103503[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (45))){
var inst_103217 = (state_103327[(53)]);
var state_103327__$1 = state_103327;
var statearr_103414_103504 = state_103327__$1;
(statearr_103414_103504[(2)] = inst_103217);

(statearr_103414_103504[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (53))){
var inst_103247 = (state_103327[(18)]);
var inst_103233 = (state_103327[(42)]);
var inst_103232 = (state_103327[(43)]);
var inst_103237 = (state_103327[(44)]);
var inst_103251 = fluree.db.dbproto._resolve_history_range.call(null,inst_103247,inst_103232,inst_103233,inst_103237);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(55),inst_103251);
} else {
if((state_val_103328 === (26))){
var inst_103138 = (state_103327[(36)]);
var inst_103187 = (state_103327[(2)]);
var inst_103188 = (inst_103138 == null);
var state_103327__$1 = (function (){var statearr_103415 = state_103327;
(statearr_103415[(49)] = inst_103187);

return statearr_103415;
})();
if(cljs.core.truth_(inst_103188)){
var statearr_103416_103505 = state_103327__$1;
(statearr_103416_103505[(1)] = (27));

} else {
var statearr_103417_103506 = state_103327__$1;
(statearr_103417_103506[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (16))){
var inst_103165 = (state_103327[(2)]);
var inst_103166 = fluree.db.util.async.throw_err.call(null,inst_103165);
var state_103327__$1 = state_103327;
var statearr_103418_103507 = state_103327__$1;
(statearr_103418_103507[(2)] = inst_103166);

(statearr_103418_103507[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (38))){
var inst_103203 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103419_103508 = state_103327__$1;
(statearr_103419_103508[(2)] = inst_103203);

(statearr_103419_103508[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (30))){
var state_103327__$1 = state_103327;
var statearr_103420_103509 = state_103327__$1;
(statearr_103420_103509[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_103420_103509[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (73))){
var inst_103303 = (state_103327[(54)]);
var inst_103302 = (state_103327[(11)]);
var inst_103317 = (state_103327[(2)]);
var inst_103318 = fluree.db.util.async.throw_err.call(null,inst_103317);
var inst_103247 = inst_103318;
var inst_103248 = inst_103303;
var inst_103249 = inst_103302;
var state_103327__$1 = (function (){var statearr_103421 = state_103327;
(statearr_103421[(15)] = inst_103248);

(statearr_103421[(18)] = inst_103247);

(statearr_103421[(17)] = inst_103249);

return statearr_103421;
})();
var statearr_103422_103510 = state_103327__$1;
(statearr_103422_103510[(2)] = null);

(statearr_103422_103510[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (10))){
var inst_103137 = (state_103327[(13)]);
var state_103327__$1 = state_103327;
var statearr_103423_103511 = state_103327__$1;
(statearr_103423_103511[(2)] = inst_103137);

(statearr_103423_103511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (18))){
var inst_103139 = (state_103327[(39)]);
var state_103327__$1 = state_103327;
var statearr_103424_103512 = state_103327__$1;
(statearr_103424_103512[(2)] = inst_103139);

(statearr_103424_103512[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (52))){
var inst_103245 = (state_103327[(2)]);
var inst_103246 = fluree.db.util.async.throw_err.call(null,inst_103245);
var inst_103247 = inst_103246;
var inst_103248 = (0);
var inst_103249 = null;
var state_103327__$1 = (function (){var statearr_103425 = state_103327;
(statearr_103425[(15)] = inst_103248);

(statearr_103425[(18)] = inst_103247);

(statearr_103425[(17)] = inst_103249);

return statearr_103425;
})();
var statearr_103426_103513 = state_103327__$1;
(statearr_103426_103513[(2)] = null);

(statearr_103426_103513[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (67))){
var inst_103226 = (state_103327[(46)]);
var inst_103303 = (state_103327[(54)]);
var inst_103216 = (state_103327[(24)]);
var inst_103221 = (state_103327[(12)]);
var inst_103263 = (state_103327[(19)]);
var inst_103305 = inst_103226.call(null,inst_103263,inst_103216);
var inst_103306 = (inst_103305 < (0));
var inst_103307 = (inst_103303 < inst_103221);
var inst_103308 = ((inst_103306) && (inst_103307));
var state_103327__$1 = state_103327;
var statearr_103427_103514 = state_103327__$1;
(statearr_103427_103514[(2)] = inst_103308);

(statearr_103427_103514[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (71))){
var inst_103242 = (state_103327[(47)]);
var inst_103263 = (state_103327[(19)]);
var inst_103315 = fluree.db.dbproto._lookup_leaf.call(null,inst_103242,inst_103263);
var state_103327__$1 = state_103327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103327__$1,(73),inst_103315);
} else {
if((state_val_103328 === (42))){
var state_103327__$1 = state_103327;
var statearr_103428_103515 = state_103327__$1;
(statearr_103428_103515[(2)] = (2147483647));

(statearr_103428_103515[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (37))){
var state_103327__$1 = state_103327;
var statearr_103429_103516 = state_103327__$1;
(statearr_103429_103516[(2)] = (2147483647));

(statearr_103429_103516[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (63))){
var inst_103300 = (state_103327[(2)]);
var state_103327__$1 = state_103327;
var statearr_103430_103517 = state_103327__$1;
(statearr_103430_103517[(2)] = inst_103300);

(statearr_103430_103517[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (8))){
var inst_103147 = (state_103327[(2)]);
var inst_103148 = fluree.db.util.async.throw_err.call(null,inst_103147);
var state_103327__$1 = state_103327;
var statearr_103431_103518 = state_103327__$1;
(statearr_103431_103518[(2)] = inst_103148);

(statearr_103431_103518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103328 === (49))){
var inst_103230 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_103327__$1 = state_103327;
var statearr_103432_103519 = state_103327__$1;
(statearr_103432_103519[(2)] = inst_103230);

(statearr_103432_103519[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_103433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103433[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_103433[(1)] = (1));

return statearr_103433;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_103327){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103434){if((e103434 instanceof Object)){
var ex__99978__auto__ = e103434;
var statearr_103435_103520 = state_103327;
(statearr_103435_103520[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103521 = state_103327;
state_103327 = G__103521;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_103327){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_103327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103436 = f__100070__auto__.call(null);
(statearr_103436[(6)] = c__100069__auto__);

return statearr_103436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103568){
var state_val_103569 = (state_103568[(1)]);
if((state_val_103569 === (7))){
var state_103568__$1 = state_103568;
var statearr_103570_103588 = state_103568__$1;
(statearr_103570_103588[(2)] = (0));

(statearr_103570_103588[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (1))){
var inst_103529 = cljs.core.seq.call(null,subject_groups);
var inst_103530 = cljs.core.first.call(null,inst_103529);
var inst_103531 = cljs.core.next.call(null,inst_103529);
var inst_103532 = cljs.core.PersistentVector.EMPTY;
var inst_103533 = subject_groups;
var inst_103534 = flake_start;
var inst_103535 = subject_start;
var inst_103536 = inst_103532;
var state_103568__$1 = (function (){var statearr_103571 = state_103568;
(statearr_103571[(7)] = inst_103535);

(statearr_103571[(8)] = inst_103530);

(statearr_103571[(9)] = inst_103536);

(statearr_103571[(10)] = inst_103533);

(statearr_103571[(11)] = inst_103534);

(statearr_103571[(12)] = inst_103531);

return statearr_103571;
})();
var statearr_103572_103589 = state_103568__$1;
(statearr_103572_103589[(2)] = null);

(statearr_103572_103589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (4))){
var inst_103535 = (state_103568[(7)]);
var inst_103536 = (state_103568[(9)]);
var inst_103534 = (state_103568[(11)]);
var inst_103549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103550 = [inst_103534,inst_103535,inst_103536];
var inst_103551 = (new cljs.core.PersistentVector(null,3,(5),inst_103549,inst_103550,null));
var state_103568__$1 = state_103568;
var statearr_103573_103590 = state_103568__$1;
(statearr_103573_103590[(2)] = inst_103551);

(statearr_103573_103590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (6))){
var inst_103564 = (state_103568[(2)]);
var state_103568__$1 = state_103568;
var statearr_103574_103591 = state_103568__$1;
(statearr_103574_103591[(2)] = inst_103564);

(statearr_103574_103591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (3))){
var inst_103566 = (state_103568[(2)]);
var state_103568__$1 = state_103568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103568__$1,inst_103566);
} else {
if((state_val_103569 === (2))){
var inst_103535 = (state_103568[(7)]);
var inst_103533 = (state_103568[(10)]);
var inst_103534 = (state_103568[(11)]);
var inst_103542 = (state_103568[(13)]);
var inst_103541 = cljs.core.seq.call(null,inst_103533);
var inst_103542__$1 = cljs.core.first.call(null,inst_103541);
var inst_103543 = cljs.core.next.call(null,inst_103541);
var inst_103544 = (inst_103542__$1 == null);
var inst_103545 = (inst_103534 >= flake_limit);
var inst_103546 = (inst_103535 >= subject_limit);
var inst_103547 = ((inst_103544) || (inst_103545) || (inst_103546));
var state_103568__$1 = (function (){var statearr_103575 = state_103568;
(statearr_103575[(14)] = inst_103543);

(statearr_103575[(13)] = inst_103542__$1);

return statearr_103575;
})();
if(cljs.core.truth_(inst_103547)){
var statearr_103576_103592 = state_103568__$1;
(statearr_103576_103592[(1)] = (4));

} else {
var statearr_103577_103593 = state_103568__$1;
(statearr_103577_103593[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (9))){
var inst_103535 = (state_103568[(7)]);
var inst_103536 = (state_103568[(9)]);
var inst_103543 = (state_103568[(14)]);
var inst_103534 = (state_103568[(11)]);
var inst_103542 = (state_103568[(13)]);
var inst_103553 = (state_103568[(15)]);
var inst_103558 = (state_103568[(2)]);
var inst_103559 = (inst_103534 + inst_103553);
var inst_103560 = (inst_103535 + inst_103558);
var inst_103561 = cljs.core.into.call(null,inst_103536,inst_103542);
var inst_103533 = inst_103543;
var inst_103534__$1 = inst_103559;
var inst_103535__$1 = inst_103560;
var inst_103536__$1 = inst_103561;
var state_103568__$1 = (function (){var statearr_103578 = state_103568;
(statearr_103578[(7)] = inst_103535__$1);

(statearr_103578[(9)] = inst_103536__$1);

(statearr_103578[(10)] = inst_103533);

(statearr_103578[(11)] = inst_103534__$1);

return statearr_103578;
})();
var statearr_103579_103594 = state_103568__$1;
(statearr_103579_103594[(2)] = null);

(statearr_103579_103594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (5))){
var inst_103542 = (state_103568[(13)]);
var inst_103553 = (state_103568[(15)]);
var inst_103553__$1 = cljs.core.count.call(null,inst_103542);
var inst_103554 = cljs.core._EQ_.call(null,(0),inst_103553__$1);
var state_103568__$1 = (function (){var statearr_103580 = state_103568;
(statearr_103580[(15)] = inst_103553__$1);

return statearr_103580;
})();
if(inst_103554){
var statearr_103581_103595 = state_103568__$1;
(statearr_103581_103595[(1)] = (7));

} else {
var statearr_103582_103596 = state_103568__$1;
(statearr_103582_103596[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103569 === (8))){
var state_103568__$1 = state_103568;
var statearr_103583_103597 = state_103568__$1;
(statearr_103583_103597[(2)] = (1));

(statearr_103583_103597[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0 = (function (){
var statearr_103584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103584[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__);

(statearr_103584[(1)] = (1));

return statearr_103584;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1 = (function (state_103568){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103585){if((e103585 instanceof Object)){
var ex__99978__auto__ = e103585;
var statearr_103586_103598 = state_103568;
(statearr_103586_103598[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103585;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103599 = state_103568;
state_103568 = G__103599;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__ = function(state_103568){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1.call(this,state_103568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103587 = f__100070__auto__.call(null);
(statearr_103587[(6)] = c__100069__auto__);

return statearr_103587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_103639){
var state_val_103640 = (state_103639[(1)]);
if((state_val_103640 === (7))){
var inst_103635 = (state_103639[(2)]);
var state_103639__$1 = state_103639;
var statearr_103641_103666 = state_103639__$1;
(statearr_103641_103666[(2)] = inst_103635);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103639__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (1))){
var state_103639__$1 = state_103639;
var statearr_103642_103667 = state_103639__$1;
(statearr_103642_103667[(2)] = null);

(statearr_103642_103667[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103639,(3),Error,null,(2));
var inst_103604 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_103639__$1 = state_103639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103639__$1,(5),inst_103604);
} else {
if((state_val_103640 === (15))){
var inst_103622 = (state_103639[(7)]);
var inst_103624 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_103622);
var state_103639__$1 = state_103639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103639__$1,(18),inst_103624);
} else {
if((state_val_103640 === (13))){
var inst_103622 = (state_103639[(7)]);
var inst_103608 = (state_103639[(8)]);
var inst_103622__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_103608);
var state_103639__$1 = (function (){var statearr_103643 = state_103639;
(statearr_103643[(7)] = inst_103622__$1);

return statearr_103643;
})();
if(cljs.core.truth_(inst_103622__$1)){
var statearr_103644_103668 = state_103639__$1;
(statearr_103644_103668[(1)] = (15));

} else {
var statearr_103645_103669 = state_103639__$1;
(statearr_103645_103669[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (6))){
var state_103639__$1 = state_103639;
var statearr_103646_103670 = state_103639__$1;
(statearr_103646_103670[(2)] = null);

(statearr_103646_103670[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (17))){
var inst_103631 = (state_103639[(2)]);
var state_103639__$1 = state_103639;
var statearr_103647_103671 = state_103639__$1;
(statearr_103647_103671[(2)] = inst_103631);

(statearr_103647_103671[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (3))){
var inst_103600 = (state_103639[(2)]);
var state_103639__$1 = state_103639;
var statearr_103648_103672 = state_103639__$1;
(statearr_103648_103672[(2)] = inst_103600);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103639__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (12))){
var inst_103619 = (state_103639[(9)]);
var state_103639__$1 = state_103639;
var statearr_103649_103673 = state_103639__$1;
(statearr_103649_103673[(2)] = inst_103619);

(statearr_103649_103673[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (2))){
var inst_103637 = (state_103639[(2)]);
var state_103639__$1 = state_103639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_103639__$1,inst_103637);
} else {
if((state_val_103640 === (11))){
var inst_103616 = (state_103639[(2)]);
var inst_103617 = fluree.db.util.async.throw_err.call(null,inst_103616);
var state_103639__$1 = state_103639;
var statearr_103650_103674 = state_103639__$1;
(statearr_103650_103674[(2)] = inst_103617);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103639__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (9))){
var inst_103610 = (state_103639[(2)]);
var state_103639__$1 = (function (){var statearr_103651 = state_103639;
(statearr_103651[(10)] = inst_103610);

return statearr_103651;
})();
var statearr_103652_103675 = state_103639__$1;
(statearr_103652_103675[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103639__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (5))){
var inst_103606 = (state_103639[(2)]);
var inst_103607 = fluree.db.util.async.throw_err.call(null,inst_103606);
var inst_103608 = inst_103607;
var state_103639__$1 = (function (){var statearr_103653 = state_103639;
(statearr_103653[(8)] = inst_103608);

return statearr_103653;
})();
var statearr_103654_103676 = state_103639__$1;
(statearr_103654_103676[(2)] = null);

(statearr_103654_103676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (14))){
var inst_103633 = (state_103639[(2)]);
var state_103639__$1 = state_103639;
var statearr_103655_103677 = state_103639__$1;
(statearr_103655_103677[(2)] = inst_103633);

(statearr_103655_103677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (16))){
var state_103639__$1 = state_103639;
var statearr_103656_103678 = state_103639__$1;
(statearr_103656_103678[(2)] = null);

(statearr_103656_103678[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (10))){
var inst_103608 = (state_103639[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_103639,(9),new cljs.core.Keyword(null,"default","default",-1987822328),null,(8));
var inst_103614 = fluree.db.dbproto._resolve_to_t.call(null,inst_103608,t,novelty,fast_forward_db_QMARK_);
var state_103639__$1 = state_103639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_103639__$1,(11),inst_103614);
} else {
if((state_val_103640 === (18))){
var inst_103626 = (state_103639[(2)]);
var inst_103627 = fluree.db.util.async.throw_err.call(null,inst_103626);
var inst_103608 = inst_103627;
var state_103639__$1 = (function (){var statearr_103657 = state_103639;
(statearr_103657[(8)] = inst_103608);

return statearr_103657;
})();
var statearr_103658_103679 = state_103639__$1;
(statearr_103658_103679[(2)] = null);

(statearr_103658_103679[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_103640 === (8))){
var inst_103619 = (state_103639[(9)]);
var inst_103619__$1 = (state_103639[(2)]);
var state_103639__$1 = (function (){var statearr_103659 = state_103639;
(statearr_103659[(9)] = inst_103619__$1);

return statearr_103659;
})();
if(cljs.core.truth_(inst_103619__$1)){
var statearr_103660_103680 = state_103639__$1;
(statearr_103660_103680[(1)] = (12));

} else {
var statearr_103661_103681 = state_103639__$1;
(statearr_103661_103681[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0 = (function (){
var statearr_103662 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_103662[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__);

(statearr_103662[(1)] = (1));

return statearr_103662;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1 = (function (state_103639){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_103639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e103663){if((e103663 instanceof Object)){
var ex__99978__auto__ = e103663;
var statearr_103664_103682 = state_103639;
(statearr_103664_103682[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_103639);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e103663;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__103683 = state_103639;
state_103639 = G__103683;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__ = function(state_103639){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1.call(this,state_103639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_103665 = f__100070__auto__.call(null);
(statearr_103665[(6)] = c__100069__auto__);

return statearr_103665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__103690 = arguments.length;
switch (G__103690) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__103691 = (function (){var pred__103694 = cljs.core.identical_QMARK_;
var expr__103695 = test;
if(cljs.core.truth_(pred__103694.call(null,cljs.core._EQ_,expr__103695))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103694.call(null,cljs.core._LT_,expr__103695))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__103694.call(null,cljs.core._LT__EQ_,expr__103695))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__103694.call(null,cljs.core._GT_,expr__103695))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__103694.call(null,cljs.core._GT__EQ_,expr__103695))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__103695)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__103691,(0),null);
var start_match = cljs.core.nth.call(null,vec__103691,(1),null);
var end_test = cljs.core.nth.call(null,vec__103691,(2),null);
var end_match = cljs.core.nth.call(null,vec__103691,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104088){
var state_val_104089 = (state_104088[(1)]);
if((state_val_104089 === (121))){
var inst_104061 = (state_104088[(7)]);
var inst_104061__$1 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104090 = state_104088;
(statearr_104090[(7)] = inst_104061__$1);

return statearr_104090;
})();
if(cljs.core.truth_(inst_104061__$1)){
var statearr_104091_104286 = state_104088__$1;
(statearr_104091_104286[(1)] = (122));

} else {
var statearr_104092_104287 = state_104088__$1;
(statearr_104092_104287[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (65))){
var inst_103857 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104093_104288 = state_104088__$1;
(statearr_104093_104288[(2)] = inst_103857);

(statearr_104093_104288[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (70))){
var state_104088__$1 = state_104088;
var statearr_104094_104289 = state_104088__$1;
(statearr_104094_104289[(2)] = false);

(statearr_104094_104289[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (62))){
var inst_103832 = (state_104088[(8)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103719 = (state_104088[(15)]);
var inst_103761 = (state_104088[(16)]);
var inst_103727 = (state_104088[(17)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103859__$1 = (state_104088[(2)]);
var inst_103860 = fluree.db.flake.__GT_Flake.call(null,inst_103761,inst_103832,inst_103814,inst_103719,inst_103720,inst_103850);
var inst_103861 = fluree.db.flake.__GT_Flake.call(null,inst_103770,inst_103841,inst_103823,inst_103726,inst_103727,inst_103859__$1);
var inst_103863 = (opts == null);
var inst_103864 = cljs.core.not.call(null,inst_103863);
var state_104088__$1 = (function (){var statearr_104095 = state_104088;
(statearr_104095[(20)] = inst_103861);

(statearr_104095[(11)] = inst_103859__$1);

(statearr_104095[(21)] = inst_103860);

return statearr_104095;
})();
if(inst_103864){
var statearr_104096_104290 = state_104088__$1;
(statearr_104096_104290[(1)] = (66));

} else {
var statearr_104097_104291 = state_104088__$1;
(statearr_104097_104291[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (74))){
var inst_103884 = (state_104088[(22)]);
var inst_103882 = (state_104088[(23)]);
var inst_103882__$1 = (state_104088[(2)]);
var inst_103883 = cljs.core.get.call(null,inst_103882__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_103884__$1 = cljs.core.get.call(null,inst_103882__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_103885 = cljs.core.get.call(null,inst_103882__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_104088__$1 = (function (){var statearr_104098 = state_104088;
(statearr_104098[(22)] = inst_103884__$1);

(statearr_104098[(24)] = inst_103883);

(statearr_104098[(25)] = inst_103885);

(statearr_104098[(23)] = inst_103882__$1);

return statearr_104098;
})();
if(cljs.core.truth_(inst_103884__$1)){
var statearr_104099_104292 = state_104088__$1;
(statearr_104099_104292[(1)] = (75));

} else {
var statearr_104100_104293 = state_104088__$1;
(statearr_104100_104293[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (110))){
var inst_103889 = (state_104088[(26)]);
var inst_103983 = (state_104088[(27)]);
var inst_103883 = (state_104088[(24)]);
var inst_103916 = (state_104088[(28)]);
var inst_103915 = (state_104088[(29)]);
var inst_104032 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_103983,inst_103915,inst_103916,inst_103883,inst_103889);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(118),inst_104032);
} else {
if((state_val_104089 === (130))){
var inst_104050 = (state_104088[(30)]);
var inst_104051 = (state_104088[(31)]);
var inst_104052 = (state_104088[(32)]);
var inst_104049 = (state_104088[(33)]);
var inst_104069 = (state_104088[(34)]);
var inst_103913 = inst_104069;
var inst_103914 = inst_104049;
var inst_103915 = inst_104050;
var inst_103916 = inst_104051;
var inst_103917 = inst_104052;
var state_104088__$1 = (function (){var statearr_104101 = state_104088;
(statearr_104101[(35)] = inst_103917);

(statearr_104101[(36)] = inst_103913);

(statearr_104101[(37)] = inst_103914);

(statearr_104101[(28)] = inst_103916);

(statearr_104101[(29)] = inst_103915);

return statearr_104101;
})();
var statearr_104102_104294 = state_104088__$1;
(statearr_104102_104294[(2)] = null);

(statearr_104102_104294[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (128))){
var inst_104073 = (state_104088[(2)]);
var inst_104074 = cljs.core.not.call(null,inst_104073);
var state_104088__$1 = state_104088;
if(inst_104074){
var statearr_104103_104295 = state_104088__$1;
(statearr_104103_104295[(1)] = (129));

} else {
var statearr_104104_104296 = state_104088__$1;
(statearr_104104_104296[(1)] = (130));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (7))){
var inst_103744 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103744)){
var statearr_104105_104297 = state_104088__$1;
(statearr_104105_104297[(1)] = (11));

} else {
var statearr_104106_104298 = state_104088__$1;
(statearr_104106_104298[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (59))){
var inst_103848 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104107_104299 = state_104088__$1;
(statearr_104107_104299[(2)] = inst_103848);

(statearr_104107_104299[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (86))){
var inst_103923 = (state_104088[(38)]);
var state_104088__$1 = state_104088;
var statearr_104108_104300 = state_104088__$1;
(statearr_104108_104300[(2)] = inst_103923);

(statearr_104108_104300[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (20))){
var inst_103718 = (state_104088[(39)]);
var inst_103770 = (state_104088[(2)]);
var inst_103771 = cljs.core.boolean_QMARK_.call(null,inst_103718);
var state_104088__$1 = (function (){var statearr_104109 = state_104088;
(statearr_104109[(10)] = inst_103770);

return statearr_104109;
})();
if(inst_103771){
var statearr_104110_104301 = state_104088__$1;
(statearr_104110_104301[(1)] = (22));

} else {
var statearr_104111_104302 = state_104088__$1;
(statearr_104111_104302[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (72))){
var inst_103879 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_104088__$1 = state_104088;
var statearr_104112_104303 = state_104088__$1;
(statearr_104112_104303[(2)] = inst_103879);

(statearr_104112_104303[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (58))){
var state_104088__$1 = state_104088;
var statearr_104113_104304 = state_104088__$1;
(statearr_104113_104304[(2)] = (2147483647));

(statearr_104113_104304[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (60))){
var inst_103728 = (state_104088[(40)]);
var state_104088__$1 = state_104088;
var statearr_104114_104305 = state_104088__$1;
(statearr_104114_104305[(2)] = inst_103728);

(statearr_104114_104305[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (27))){
var inst_103782 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104115_104306 = state_104088__$1;
(statearr_104115_104306[(2)] = inst_103782);

(statearr_104115_104306[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (1))){
var state_104088__$1 = state_104088;
var statearr_104116_104307 = state_104088__$1;
(statearr_104116_104307[(2)] = null);

(statearr_104116_104307[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (69))){
var state_104088__$1 = state_104088;
var statearr_104117_104308 = state_104088__$1;
(statearr_104117_104308[(2)] = true);

(statearr_104117_104308[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (101))){
var state_104088__$1 = state_104088;
var statearr_104118_104309 = state_104088__$1;
(statearr_104118_104309[(2)] = false);

(statearr_104118_104309[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (24))){
var inst_103784 = (state_104088[(41)]);
var inst_103784__$1 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104119 = state_104088;
(statearr_104119[(41)] = inst_103784__$1);

return statearr_104119;
})();
if(cljs.core.truth_(inst_103784__$1)){
var statearr_104120_104310 = state_104088__$1;
(statearr_104120_104310[(1)] = (31));

} else {
var statearr_104121_104311 = state_104088__$1;
(statearr_104121_104311[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (102))){
var inst_103956 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104122_104312 = state_104088__$1;
(statearr_104122_104312[(2)] = inst_103956);

(statearr_104122_104312[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (55))){
var inst_103844 = (cljs.core._GT__EQ_ === start_test);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103844)){
var statearr_104123_104313 = state_104088__$1;
(statearr_104123_104313[(1)] = (57));

} else {
var statearr_104124_104314 = state_104088__$1;
(statearr_104124_104314[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (85))){
var inst_103900 = (state_104088[(42)]);
var inst_103889 = (state_104088[(26)]);
var inst_103751 = (state_104088[(43)]);
var inst_103832 = (state_104088[(8)]);
var inst_103861 = (state_104088[(20)]);
var inst_103917 = (state_104088[(35)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103891 = (state_104088[(44)]);
var inst_103913 = (state_104088[(36)]);
var inst_103750 = (state_104088[(45)]);
var inst_103883 = (state_104088[(24)]);
var inst_103890 = (state_104088[(46)]);
var inst_103914 = (state_104088[(37)]);
var inst_103801 = (state_104088[(47)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103895 = (state_104088[(48)]);
var inst_103719 = (state_104088[(15)]);
var inst_103910 = (state_104088[(49)]);
var inst_103860 = (state_104088[(21)]);
var inst_103761 = (state_104088[(16)]);
var inst_103805 = (state_104088[(50)]);
var inst_103923 = (state_104088[(38)]);
var inst_103727 = (state_104088[(17)]);
var inst_103906 = (state_104088[(51)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103916 = (state_104088[(28)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103901 = (state_104088[(54)]);
var inst_103915 = (state_104088[(29)]);
var inst_103882 = (state_104088[(23)]);
var inst_103749 = (state_104088[(55)]);
var inst_103802 = (state_104088[(56)]);
var inst_103896 = (state_104088[(57)]);
var inst_103927 = (function (){var no_filter_QMARK_ = true;
var t = inst_103896;
var max_limit_QMARK_ = inst_103890;
var next_node = inst_103913;
var fast_forward_db_QMARK_ = inst_103901;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103823;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var i = inst_103915;
var m1 = inst_103850;
var root_node = inst_103906;
var s2 = inst_103770;
var p2 = inst_103841;
var vec__103711 = inst_103802;
var permissions = inst_103891;
var vec__103704 = inst_103722;
var limit = inst_103889;
var start_flake = inst_103860;
var flake_limit = inst_103883;
var offset = inst_103914;
var acc = inst_103917;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103814;
var end_flake = inst_103861;
var base_result = inst_103923;
var s = inst_103916;
var node_start = inst_103910;
var p1 = inst_103832;
var subject_fn = inst_103750;
var G__103924 = inst_103923;
var object_fn = inst_103805;
var map__103714 = inst_103882;
var idx_compare = inst_103895;
var vec__103708 = inst_103801;
var op2 = inst_103727;
var m2 = inst_103859;
var novelty = inst_103900;
return (function (p1__103684_SHARP_){
return cljs.core._EQ_.call(null,p1__103684_SHARP_.o,start_flake.o);
});
})();
var inst_103928 = cljs.core.filter.call(null,inst_103927,inst_103923);
var state_104088__$1 = state_104088;
var statearr_104125_104315 = state_104088__$1;
(statearr_104125_104315[(2)] = inst_103928);

(statearr_104125_104315[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (39))){
var inst_103804 = (state_104088[(58)]);
var state_104088__$1 = state_104088;
var statearr_104126_104316 = state_104088__$1;
(statearr_104126_104316[(2)] = inst_103804);

(statearr_104126_104316[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (88))){
var inst_103900 = (state_104088[(42)]);
var inst_103889 = (state_104088[(26)]);
var inst_103751 = (state_104088[(43)]);
var inst_103832 = (state_104088[(8)]);
var inst_103861 = (state_104088[(20)]);
var inst_103917 = (state_104088[(35)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103891 = (state_104088[(44)]);
var inst_103913 = (state_104088[(36)]);
var inst_103750 = (state_104088[(45)]);
var inst_103883 = (state_104088[(24)]);
var inst_103890 = (state_104088[(46)]);
var inst_103914 = (state_104088[(37)]);
var inst_103931 = (state_104088[(59)]);
var inst_103801 = (state_104088[(47)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103895 = (state_104088[(48)]);
var inst_103719 = (state_104088[(15)]);
var inst_103910 = (state_104088[(49)]);
var inst_103860 = (state_104088[(21)]);
var inst_103761 = (state_104088[(16)]);
var inst_103805 = (state_104088[(50)]);
var inst_103923 = (state_104088[(38)]);
var inst_103727 = (state_104088[(17)]);
var inst_103906 = (state_104088[(51)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103916 = (state_104088[(28)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103901 = (state_104088[(54)]);
var inst_103915 = (state_104088[(29)]);
var inst_103882 = (state_104088[(23)]);
var inst_103749 = (state_104088[(55)]);
var inst_103802 = (state_104088[(56)]);
var inst_103896 = (state_104088[(57)]);
var inst_103933 = (function (){var no_filter_QMARK_ = true;
var t = inst_103896;
var max_limit_QMARK_ = inst_103890;
var next_node = inst_103913;
var fast_forward_db_QMARK_ = inst_103901;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103823;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var i = inst_103915;
var m1 = inst_103850;
var root_node = inst_103906;
var s2 = inst_103770;
var p2 = inst_103841;
var vec__103711 = inst_103802;
var permissions = inst_103891;
var vec__103704 = inst_103722;
var limit = inst_103889;
var start_flake = inst_103860;
var flake_limit = inst_103883;
var offset = inst_103914;
var acc = inst_103917;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103814;
var end_flake = inst_103861;
var base_result = inst_103923;
var s = inst_103916;
var node_start = inst_103910;
var p1 = inst_103832;
var subject_fn = inst_103750;
var G__103924 = inst_103931;
var object_fn = inst_103805;
var map__103714 = inst_103882;
var idx_compare = inst_103895;
var vec__103708 = inst_103801;
var op2 = inst_103727;
var m2 = inst_103859;
var novelty = inst_103900;
return (function (p1__103685_SHARP_){
return subject_fn.call(null,p1__103685_SHARP_.s);
});
})();
var inst_103934 = cljs.core.filter.call(null,inst_103933,inst_103931);
var state_104088__$1 = state_104088;
var statearr_104127_104317 = state_104088__$1;
(statearr_104127_104317[(2)] = inst_103934);

(statearr_104127_104317[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (46))){
var inst_103717 = (state_104088[(60)]);
var state_104088__$1 = state_104088;
var statearr_104128_104318 = state_104088__$1;
(statearr_104128_104318[(2)] = inst_103717);

(statearr_104128_104318[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (4))){
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104088,(3),Error,null,(2));
var inst_103715__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_103716 = cljs.core.nth.call(null,inst_103715__$1,(0),null);
var inst_103717 = cljs.core.nth.call(null,inst_103715__$1,(1),null);
var inst_103718 = cljs.core.nth.call(null,inst_103715__$1,(2),null);
var inst_103719 = cljs.core.nth.call(null,inst_103715__$1,(3),null);
var inst_103720 = cljs.core.nth.call(null,inst_103715__$1,(4),null);
var inst_103721 = cljs.core.nth.call(null,inst_103715__$1,(5),null);
var inst_103722__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_103723 = cljs.core.nth.call(null,inst_103722__$1,(0),null);
var inst_103724 = cljs.core.nth.call(null,inst_103722__$1,(1),null);
var inst_103725 = cljs.core.nth.call(null,inst_103722__$1,(2),null);
var inst_103726 = cljs.core.nth.call(null,inst_103722__$1,(3),null);
var inst_103727 = cljs.core.nth.call(null,inst_103722__$1,(4),null);
var inst_103728 = cljs.core.nth.call(null,inst_103722__$1,(5),null);
var inst_103730 = (opts == null);
var inst_103731 = cljs.core.not.call(null,inst_103730);
var state_104088__$1 = (function (){var statearr_104129 = state_104088;
(statearr_104129[(61)] = inst_103716);

(statearr_104129[(40)] = inst_103728);

(statearr_104129[(62)] = inst_103721);

(statearr_104129[(60)] = inst_103717);

(statearr_104129[(63)] = inst_103724);

(statearr_104129[(13)] = inst_103720);

(statearr_104129[(64)] = inst_103725);

(statearr_104129[(15)] = inst_103719);

(statearr_104129[(65)] = inst_103723);

(statearr_104129[(17)] = inst_103727);

(statearr_104129[(19)] = inst_103726);

(statearr_104129[(52)] = inst_103715__$1);

(statearr_104129[(53)] = inst_103722__$1);

(statearr_104129[(39)] = inst_103718);

return statearr_104129;
})();
if(inst_103731){
var statearr_104130_104319 = state_104088__$1;
(statearr_104130_104319[(1)] = (5));

} else {
var statearr_104131_104320 = state_104088__$1;
(statearr_104131_104320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (77))){
var inst_103889 = (state_104088[(26)]);
var inst_103889__$1 = (state_104088[(2)]);
var inst_103890 = cljs.core._EQ_.call(null,inst_103889__$1,fluree.db.util.core.max_long);
var inst_103891 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_103892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103893 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_103894 = (new cljs.core.PersistentVector(null,3,(5),inst_103892,inst_103893,null));
var inst_103895 = cljs.core.get_in.call(null,db,inst_103894);
var inst_103896 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_103897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103898 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_103899 = (new cljs.core.PersistentVector(null,2,(5),inst_103897,inst_103898,null));
var inst_103900 = cljs.core.get_in.call(null,db,inst_103899);
var inst_103901 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_103902 = cljs.core.get.call(null,db,idx);
var inst_103903 = fluree.db.dbproto._resolve.call(null,inst_103902);
var state_104088__$1 = (function (){var statearr_104132 = state_104088;
(statearr_104132[(42)] = inst_103900);

(statearr_104132[(26)] = inst_103889__$1);

(statearr_104132[(44)] = inst_103891);

(statearr_104132[(46)] = inst_103890);

(statearr_104132[(48)] = inst_103895);

(statearr_104132[(54)] = inst_103901);

(statearr_104132[(57)] = inst_103896);

return statearr_104132;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(78),inst_103903);
} else {
if((state_val_104089 === (106))){
var inst_103917 = (state_104088[(35)]);
var inst_103914 = (state_104088[(37)]);
var inst_103972 = (state_104088[(66)]);
var inst_103916 = (state_104088[(28)]);
var inst_103915 = (state_104088[(29)]);
var inst_103975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103976 = (inst_103914 - inst_103972);
var inst_103977 = [inst_103976,inst_103915,inst_103916,inst_103917];
var inst_103978 = (new cljs.core.PersistentVector(null,4,(5),inst_103975,inst_103977,null));
var state_104088__$1 = state_104088;
var statearr_104133_104321 = state_104088__$1;
(statearr_104133_104321[(2)] = inst_103978);

(statearr_104133_104321[(1)] = (108));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (119))){
var inst_104050 = (state_104088[(30)]);
var inst_103889 = (state_104088[(26)]);
var inst_103950 = (state_104088[(67)]);
var inst_103861 = (state_104088[(20)]);
var inst_104051 = (state_104088[(31)]);
var inst_103883 = (state_104088[(24)]);
var inst_103895 = (state_104088[(48)]);
var inst_104054 = inst_103895.call(null,inst_103950,inst_103861);
var inst_104055 = (inst_104054 < (0));
var inst_104056 = (inst_104050 < inst_103883);
var inst_104057 = (inst_104051 < inst_103889);
var inst_104058 = ((inst_104055) && (inst_104056) && (inst_104057));
var state_104088__$1 = state_104088;
var statearr_104134_104322 = state_104088__$1;
(statearr_104134_104322[(2)] = inst_104058);

(statearr_104134_104322[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (95))){
var inst_103943 = (state_104088[(68)]);
var state_104088__$1 = state_104088;
var statearr_104135_104323 = state_104088__$1;
(statearr_104135_104323[(2)] = inst_103943);

(statearr_104135_104323[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (54))){
var inst_103721 = (state_104088[(62)]);
var state_104088__$1 = state_104088;
var statearr_104136_104324 = state_104088__$1;
(statearr_104136_104324[(2)] = inst_103721);

(statearr_104136_104324[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (92))){
var inst_103937 = (state_104088[(69)]);
var state_104088__$1 = state_104088;
var statearr_104137_104325 = state_104088__$1;
(statearr_104137_104325[(2)] = inst_103937);

(statearr_104137_104325[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (104))){
var inst_103900 = (state_104088[(42)]);
var inst_103889 = (state_104088[(26)]);
var inst_103950 = (state_104088[(67)]);
var inst_103751 = (state_104088[(43)]);
var inst_103832 = (state_104088[(8)]);
var inst_103861 = (state_104088[(20)]);
var inst_103917 = (state_104088[(35)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103891 = (state_104088[(44)]);
var inst_103913 = (state_104088[(36)]);
var inst_103750 = (state_104088[(45)]);
var inst_103883 = (state_104088[(24)]);
var inst_103890 = (state_104088[(46)]);
var inst_103914 = (state_104088[(37)]);
var inst_103972 = (state_104088[(66)]);
var inst_103949 = (state_104088[(70)]);
var inst_103801 = (state_104088[(47)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103895 = (state_104088[(48)]);
var inst_103719 = (state_104088[(15)]);
var inst_103910 = (state_104088[(49)]);
var inst_103860 = (state_104088[(21)]);
var inst_103761 = (state_104088[(16)]);
var inst_103805 = (state_104088[(50)]);
var inst_103923 = (state_104088[(38)]);
var inst_103727 = (state_104088[(17)]);
var inst_103906 = (state_104088[(51)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103916 = (state_104088[(28)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103901 = (state_104088[(54)]);
var inst_103915 = (state_104088[(29)]);
var inst_103882 = (state_104088[(23)]);
var inst_103971 = (state_104088[(71)]);
var inst_103749 = (state_104088[(55)]);
var inst_103802 = (state_104088[(56)]);
var inst_103896 = (state_104088[(57)]);
var inst_103970 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_103949;
var t = inst_103896;
var max_limit_QMARK_ = inst_103890;
var next_node = inst_103913;
var fast_forward_db_QMARK_ = inst_103901;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103823;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var i = inst_103915;
var rhs = inst_103950;
var m1 = inst_103850;
var root_node = inst_103906;
var s2 = inst_103770;
var p2 = inst_103841;
var vec__103711 = inst_103802;
var permissions = inst_103891;
var vec__103704 = inst_103722;
var limit = inst_103889;
var start_flake = inst_103860;
var flake_limit = inst_103883;
var offset = inst_103914;
var acc = inst_103917;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103814;
var end_flake = inst_103861;
var base_result = inst_103923;
var s = inst_103916;
var node_start = inst_103910;
var p1 = inst_103832;
var subject_fn = inst_103750;
var object_fn = inst_103805;
var map__103714 = inst_103882;
var idx_compare = inst_103895;
var vec__103708 = inst_103801;
var op2 = inst_103727;
var m2 = inst_103859;
var novelty = inst_103900;
return (function (p1__103688_SHARP_){
return p1__103688_SHARP_.s;
});
})();
var inst_103971__$1 = cljs.core.partition_by.call(null,inst_103970,inst_103949);
var inst_103972__$1 = cljs.core.count.call(null,inst_103971__$1);
var inst_103973 = (inst_103914 > inst_103972__$1);
var state_104088__$1 = (function (){var statearr_104138 = state_104088;
(statearr_104138[(66)] = inst_103972__$1);

(statearr_104138[(71)] = inst_103971__$1);

return statearr_104138;
})();
if(cljs.core.truth_(inst_103973)){
var statearr_104139_104326 = state_104088__$1;
(statearr_104139_104326[(1)] = (106));

} else {
var statearr_104140_104327 = state_104088__$1;
(statearr_104140_104327[(1)] = (107));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (15))){
var inst_103716 = (state_104088[(61)]);
var state_104088__$1 = state_104088;
var statearr_104141_104328 = state_104088__$1;
(statearr_104141_104328[(2)] = inst_103716);

(statearr_104141_104328[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (48))){
var inst_103823 = (state_104088[(14)]);
var state_104088__$1 = state_104088;
var statearr_104142_104329 = state_104088__$1;
(statearr_104142_104329[(2)] = inst_103823);

(statearr_104142_104329[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (50))){
var inst_103837 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103837)){
var statearr_104143_104330 = state_104088__$1;
(statearr_104143_104330[(1)] = (51));

} else {
var statearr_104144_104331 = state_104088__$1;
(statearr_104144_104331[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (116))){
var inst_104009 = (state_104088[(72)]);
var inst_104011 = (state_104088[(73)]);
var inst_104021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104022 = [inst_104011,inst_104009];
var inst_104023 = (new cljs.core.PersistentVector(null,2,(5),inst_104021,inst_104022,null));
var state_104088__$1 = state_104088;
var statearr_104145_104332 = state_104088__$1;
(statearr_104145_104332[(2)] = inst_104023);

(statearr_104145_104332[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (75))){
var inst_103884 = (state_104088[(22)]);
var state_104088__$1 = state_104088;
var statearr_104146_104333 = state_104088__$1;
(statearr_104146_104333[(2)] = inst_103884);

(statearr_104146_104333[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (99))){
var inst_103959 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103959)){
var statearr_104147_104334 = state_104088__$1;
(statearr_104147_104334[(1)] = (103));

} else {
var statearr_104148_104335 = state_104088__$1;
(statearr_104148_104335[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (21))){
var inst_103766 = (state_104088[(2)]);
var inst_103767 = fluree.db.util.async.throw_err.call(null,inst_103766);
var state_104088__$1 = state_104088;
var statearr_104149_104336 = state_104088__$1;
(statearr_104149_104336[(2)] = inst_103767);

(statearr_104149_104336[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (31))){
var inst_103728 = (state_104088[(40)]);
var inst_103751 = (state_104088[(43)]);
var inst_103770 = (state_104088[(10)]);
var inst_103721 = (state_104088[(62)]);
var inst_103750 = (state_104088[(45)]);
var inst_103717 = (state_104088[(60)]);
var inst_103784 = (state_104088[(41)]);
var inst_103724 = (state_104088[(63)]);
var inst_103720 = (state_104088[(13)]);
var inst_103725 = (state_104088[(64)]);
var inst_103752 = (state_104088[(74)]);
var inst_103719 = (state_104088[(15)]);
var inst_103761 = (state_104088[(16)]);
var inst_103727 = (state_104088[(17)]);
var inst_103726 = (state_104088[(19)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103718 = (state_104088[(39)]);
var inst_103749 = (state_104088[(55)]);
var inst_103786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103788 = [null,null];
var inst_103789 = (new cljs.core.PersistentVector(null,2,(5),inst_103787,inst_103788,null));
var inst_103790 = (function (){var bool = inst_103784;
var temp__5733__auto__ = inst_103784;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103725;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var m1 = inst_103721;
var s2 = inst_103770;
var p2 = inst_103724;
var vec__103704 = inst_103722;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103718;
var p1 = inst_103717;
var subject_fn = inst_103750;
var object_fn = inst_103752;
var op2 = inst_103727;
var m2 = inst_103728;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_103791 = [inst_103789,inst_103790];
var inst_103792 = (new cljs.core.PersistentVector(null,2,(5),inst_103786,inst_103791,null));
var state_104088__$1 = state_104088;
var statearr_104150_104337 = state_104088__$1;
(statearr_104150_104337[(2)] = inst_103792);

(statearr_104150_104337[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (113))){
var inst_103992 = (state_104088[(75)]);
var inst_104001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104002 = [inst_103992,inst_103992];
var inst_104003 = (new cljs.core.PersistentVector(null,2,(5),inst_104001,inst_104002,null));
var state_104088__$1 = state_104088;
var statearr_104151_104338 = state_104088__$1;
(statearr_104151_104338[(2)] = inst_104003);

(statearr_104151_104338[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (32))){
var inst_103725 = (state_104088[(64)]);
var inst_103752 = (state_104088[(74)]);
var inst_103718 = (state_104088[(39)]);
var inst_103794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103796 = [inst_103718,inst_103725];
var inst_103797 = (new cljs.core.PersistentVector(null,2,(5),inst_103795,inst_103796,null));
var inst_103798 = [inst_103797,inst_103752];
var inst_103799 = (new cljs.core.PersistentVector(null,2,(5),inst_103794,inst_103798,null));
var state_104088__$1 = state_104088;
var statearr_104152_104339 = state_104088__$1;
(statearr_104152_104339[(2)] = inst_103799);

(statearr_104152_104339[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (40))){
var inst_103717 = (state_104088[(60)]);
var inst_103823 = (state_104088[(2)]);
var inst_103824 = (inst_103717 == null);
var state_104088__$1 = (function (){var statearr_104153 = state_104088;
(statearr_104153[(14)] = inst_103823);

return statearr_104153;
})();
if(cljs.core.truth_(inst_103824)){
var statearr_104154_104340 = state_104088__$1;
(statearr_104154_104340[(1)] = (42));

} else {
var statearr_104155_104341 = state_104088__$1;
(statearr_104155_104341[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (129))){
var inst_104052 = (state_104088[(32)]);
var state_104088__$1 = state_104088;
var statearr_104156_104342 = state_104088__$1;
(statearr_104156_104342[(2)] = inst_104052);

(statearr_104156_104342[(1)] = (131));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (91))){
var inst_103900 = (state_104088[(42)]);
var inst_103889 = (state_104088[(26)]);
var inst_103751 = (state_104088[(43)]);
var inst_103832 = (state_104088[(8)]);
var inst_103861 = (state_104088[(20)]);
var inst_103917 = (state_104088[(35)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103891 = (state_104088[(44)]);
var inst_103913 = (state_104088[(36)]);
var inst_103750 = (state_104088[(45)]);
var inst_103883 = (state_104088[(24)]);
var inst_103890 = (state_104088[(46)]);
var inst_103937 = (state_104088[(69)]);
var inst_103914 = (state_104088[(37)]);
var inst_103801 = (state_104088[(47)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103895 = (state_104088[(48)]);
var inst_103719 = (state_104088[(15)]);
var inst_103910 = (state_104088[(49)]);
var inst_103860 = (state_104088[(21)]);
var inst_103761 = (state_104088[(16)]);
var inst_103805 = (state_104088[(50)]);
var inst_103923 = (state_104088[(38)]);
var inst_103727 = (state_104088[(17)]);
var inst_103906 = (state_104088[(51)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103916 = (state_104088[(28)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103901 = (state_104088[(54)]);
var inst_103915 = (state_104088[(29)]);
var inst_103882 = (state_104088[(23)]);
var inst_103749 = (state_104088[(55)]);
var inst_103802 = (state_104088[(56)]);
var inst_103896 = (state_104088[(57)]);
var inst_103939 = (function (){var no_filter_QMARK_ = true;
var t = inst_103896;
var max_limit_QMARK_ = inst_103890;
var next_node = inst_103913;
var fast_forward_db_QMARK_ = inst_103901;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103823;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var i = inst_103915;
var m1 = inst_103850;
var root_node = inst_103906;
var s2 = inst_103770;
var p2 = inst_103841;
var vec__103711 = inst_103802;
var permissions = inst_103891;
var vec__103704 = inst_103722;
var limit = inst_103889;
var start_flake = inst_103860;
var flake_limit = inst_103883;
var offset = inst_103914;
var acc = inst_103917;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103814;
var end_flake = inst_103861;
var base_result = inst_103923;
var s = inst_103916;
var node_start = inst_103910;
var p1 = inst_103832;
var subject_fn = inst_103750;
var G__103924 = inst_103937;
var object_fn = inst_103805;
var map__103714 = inst_103882;
var idx_compare = inst_103895;
var vec__103708 = inst_103801;
var op2 = inst_103727;
var m2 = inst_103859;
var novelty = inst_103900;
return (function (p1__103686_SHARP_){
return predicate_fn.call(null,p1__103686_SHARP_.p);
});
})();
var inst_103940 = cljs.core.filter.call(null,inst_103939,inst_103937);
var state_104088__$1 = state_104088;
var statearr_104157_104343 = state_104088__$1;
(statearr_104157_104343[(2)] = inst_103940);

(statearr_104157_104343[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (117))){
var inst_104006 = (state_104088[(76)]);
var inst_104025 = (state_104088[(2)]);
var inst_104026 = cljs.core.nth.call(null,inst_104025,(0),null);
var inst_104027 = cljs.core.nth.call(null,inst_104025,(1),null);
var inst_104028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104029 = [inst_104026,inst_104006,inst_104027];
var inst_104030 = (new cljs.core.PersistentVector(null,3,(5),inst_104028,inst_104029,null));
var state_104088__$1 = state_104088;
var statearr_104158_104344 = state_104088__$1;
(statearr_104158_104344[(2)] = inst_104030);

(statearr_104158_104344[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (108))){
var inst_104046 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104159_104345 = state_104088__$1;
(statearr_104159_104345[(2)] = inst_104046);

(statearr_104159_104345[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (56))){
var inst_103728 = (state_104088[(40)]);
var inst_103850 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104160 = state_104088;
(statearr_104160[(18)] = inst_103850);

return statearr_104160;
})();
if(cljs.core.truth_(inst_103728)){
var statearr_104161_104346 = state_104088__$1;
(statearr_104161_104346[(1)] = (60));

} else {
var statearr_104162_104347 = state_104088__$1;
(statearr_104162_104347[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (33))){
var inst_103803 = (state_104088[(77)]);
var inst_103801 = (state_104088[(47)]);
var inst_103802 = (state_104088[(56)]);
var inst_103801__$1 = (state_104088[(2)]);
var inst_103802__$1 = cljs.core.nth.call(null,inst_103801__$1,(0),null);
var inst_103803__$1 = cljs.core.nth.call(null,inst_103802__$1,(0),null);
var inst_103804 = cljs.core.nth.call(null,inst_103802__$1,(1),null);
var inst_103805 = cljs.core.nth.call(null,inst_103801__$1,(1),null);
var inst_103806 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103803__$1);
var state_104088__$1 = (function (){var statearr_104163 = state_104088;
(statearr_104163[(77)] = inst_103803__$1);

(statearr_104163[(58)] = inst_103804);

(statearr_104163[(47)] = inst_103801__$1);

(statearr_104163[(50)] = inst_103805);

(statearr_104163[(56)] = inst_103802__$1);

return statearr_104163;
})();
if(inst_103806){
var statearr_104164_104348 = state_104088__$1;
(statearr_104164_104348[(1)] = (34));

} else {
var statearr_104165_104349 = state_104088__$1;
(statearr_104165_104349[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (13))){
var inst_103716 = (state_104088[(61)]);
var inst_103749 = (state_104088[(55)]);
var inst_103749__$1 = (state_104088[(2)]);
var inst_103750 = cljs.core.get.call(null,inst_103749__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_103751 = cljs.core.get.call(null,inst_103749__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_103752 = cljs.core.get.call(null,inst_103749__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_103753 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103716);
var state_104088__$1 = (function (){var statearr_104166 = state_104088;
(statearr_104166[(43)] = inst_103751);

(statearr_104166[(45)] = inst_103750);

(statearr_104166[(74)] = inst_103752);

(statearr_104166[(55)] = inst_103749__$1);

return statearr_104166;
})();
if(inst_103753){
var statearr_104167_104350 = state_104088__$1;
(statearr_104167_104350[(1)] = (14));

} else {
var statearr_104168_104351 = state_104088__$1;
(statearr_104168_104351[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (22))){
var inst_103718 = (state_104088[(39)]);
var state_104088__$1 = state_104088;
var statearr_104169_104352 = state_104088__$1;
(statearr_104169_104352[(2)] = inst_103718);

(statearr_104169_104352[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (90))){
var inst_103751 = (state_104088[(43)]);
var inst_103937 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104170 = state_104088;
(statearr_104170[(69)] = inst_103937);

return statearr_104170;
})();
if(cljs.core.truth_(inst_103751)){
var statearr_104171_104353 = state_104088__$1;
(statearr_104171_104353[(1)] = (91));

} else {
var statearr_104172_104354 = state_104088__$1;
(statearr_104172_104354[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (109))){
var inst_103889 = (state_104088[(26)]);
var inst_103992 = (state_104088[(75)]);
var inst_103983 = (state_104088[(27)]);
var inst_103993 = (state_104088[(78)]);
var inst_103916 = (state_104088[(28)]);
var inst_103991 = (state_104088[(79)]);
var inst_103991__$1 = cljs.core.count.call(null,inst_103983);
var inst_103992__$1 = (inst_103916 + inst_103991__$1);
var inst_103993__$1 = (inst_103992__$1 - inst_103889);
var inst_103994 = cljs.core.pos_int_QMARK_.call(null,inst_103993__$1);
var state_104088__$1 = (function (){var statearr_104173 = state_104088;
(statearr_104173[(75)] = inst_103992__$1);

(statearr_104173[(78)] = inst_103993__$1);

(statearr_104173[(79)] = inst_103991__$1);

return statearr_104173;
})();
if(inst_103994){
var statearr_104174_104355 = state_104088__$1;
(statearr_104174_104355[(1)] = (112));

} else {
var statearr_104175_104356 = state_104088__$1;
(statearr_104175_104356[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (36))){
var inst_103804 = (state_104088[(58)]);
var inst_103814 = (state_104088[(2)]);
var inst_103815 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103804);
var state_104088__$1 = (function (){var statearr_104176 = state_104088;
(statearr_104176[(12)] = inst_103814);

return statearr_104176;
})();
if(inst_103815){
var statearr_104177_104357 = state_104088__$1;
(statearr_104177_104357[(1)] = (38));

} else {
var statearr_104178_104358 = state_104088__$1;
(statearr_104178_104358[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (41))){
var inst_103819 = (state_104088[(2)]);
var inst_103820 = fluree.db.util.async.throw_err.call(null,inst_103819);
var state_104088__$1 = state_104088;
var statearr_104179_104359 = state_104088__$1;
(statearr_104179_104359[(2)] = inst_103820);

(statearr_104179_104359[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (118))){
var inst_104034 = (state_104088[(2)]);
var inst_104035 = fluree.db.util.async.throw_err.call(null,inst_104034);
var state_104088__$1 = state_104088;
var statearr_104180_104360 = state_104088__$1;
(statearr_104180_104360[(2)] = inst_104035);

(statearr_104180_104360[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (89))){
var inst_103931 = (state_104088[(59)]);
var state_104088__$1 = state_104088;
var statearr_104181_104361 = state_104088__$1;
(statearr_104181_104361[(2)] = inst_103931);

(statearr_104181_104361[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (100))){
var state_104088__$1 = state_104088;
var statearr_104182_104362 = state_104088__$1;
(statearr_104182_104362[(2)] = true);

(statearr_104182_104362[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (131))){
var inst_104079 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104183_104363 = state_104088__$1;
(statearr_104183_104363[(2)] = inst_104079);

(statearr_104183_104363[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (122))){
var inst_103900 = (state_104088[(42)]);
var inst_103950 = (state_104088[(67)]);
var inst_103906 = (state_104088[(51)]);
var inst_103901 = (state_104088[(54)]);
var inst_103896 = (state_104088[(57)]);
var inst_104063 = fluree.db.query.range.find_next_valid_node.call(null,inst_103906,inst_103950,inst_103896,inst_103900,inst_103901);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(125),inst_104063);
} else {
if((state_val_104089 === (43))){
var state_104088__$1 = state_104088;
var statearr_104184_104364 = state_104088__$1;
(statearr_104184_104364[(2)] = false);

(statearr_104184_104364[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (61))){
var inst_103853 = (cljs.core._LT__EQ_ === end_test);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103853)){
var statearr_104185_104365 = state_104088__$1;
(statearr_104185_104365[(1)] = (63));

} else {
var statearr_104186_104366 = state_104088__$1;
(statearr_104186_104366[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (29))){
var state_104088__$1 = state_104088;
var statearr_104187_104367 = state_104088__$1;
(statearr_104187_104367[(2)] = null);

(statearr_104187_104367[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (44))){
var inst_103828 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103828)){
var statearr_104188_104368 = state_104088__$1;
(statearr_104188_104368[(1)] = (45));

} else {
var statearr_104189_104369 = state_104088__$1;
(statearr_104189_104369[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (93))){
var inst_103805 = (state_104088[(50)]);
var inst_103943 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104190 = state_104088;
(statearr_104190[(68)] = inst_103943);

return statearr_104190;
})();
if(cljs.core.truth_(inst_103805)){
var statearr_104191_104370 = state_104088__$1;
(statearr_104191_104370[(1)] = (94));

} else {
var statearr_104192_104371 = state_104088__$1;
(statearr_104192_104371[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (6))){
var state_104088__$1 = state_104088;
var statearr_104193_104372 = state_104088__$1;
(statearr_104193_104372[(2)] = false);

(statearr_104193_104372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (111))){
var inst_103917 = (state_104088[(35)]);
var inst_104037 = (state_104088[(2)]);
var inst_104038 = cljs.core.nth.call(null,inst_104037,(0),null);
var inst_104039 = cljs.core.nth.call(null,inst_104037,(1),null);
var inst_104040 = cljs.core.nth.call(null,inst_104037,(2),null);
var inst_104041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104042 = cljs.core.into.call(null,inst_103917,inst_104040);
var inst_104043 = [(0),inst_104038,inst_104039,inst_104042];
var inst_104044 = (new cljs.core.PersistentVector(null,4,(5),inst_104041,inst_104043,null));
var state_104088__$1 = state_104088;
var statearr_104194_104373 = state_104088__$1;
(statearr_104194_104373[(2)] = inst_104044);

(statearr_104194_104373[(1)] = (108));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (28))){
var state_104088__$1 = state_104088;
var statearr_104195_104374 = state_104088__$1;
(statearr_104195_104374[(2)] = null);

(statearr_104195_104374[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (64))){
var state_104088__$1 = state_104088;
var statearr_104196_104375 = state_104088__$1;
(statearr_104196_104375[(2)] = fluree.db.util.core.min_integer);

(statearr_104196_104375[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (103))){
var inst_103917 = (state_104088[(35)]);
var inst_103883 = (state_104088[(24)]);
var inst_103949 = (state_104088[(70)]);
var inst_103916 = (state_104088[(28)]);
var inst_103915 = (state_104088[(29)]);
var inst_103961 = cljs.core.count.call(null,inst_103949);
var inst_103962 = (inst_103883 - inst_103915);
var inst_103963 = cljs.core.take.call(null,inst_103962,inst_103949);
var inst_103964 = cljs.core.into.call(null,inst_103917,inst_103963);
var inst_103965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103966 = (inst_103915 + inst_103961);
var inst_103967 = [(0),inst_103966,inst_103916,inst_103964];
var inst_103968 = (new cljs.core.PersistentVector(null,4,(5),inst_103965,inst_103967,null));
var state_104088__$1 = state_104088;
var statearr_104197_104376 = state_104088__$1;
(statearr_104197_104376[(2)] = inst_103968);

(statearr_104197_104376[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (51))){
var state_104088__$1 = state_104088;
var statearr_104198_104377 = state_104088__$1;
(statearr_104198_104377[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_104198_104377[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (25))){
var inst_103725 = (state_104088[(64)]);
var state_104088__$1 = state_104088;
var statearr_104199_104378 = state_104088__$1;
(statearr_104199_104378[(2)] = inst_103725);

(statearr_104199_104378[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (34))){
var inst_103803 = (state_104088[(77)]);
var inst_103808 = fluree.db.dbproto._subid.call(null,db,inst_103803);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(37),inst_103808);
} else {
if((state_val_104089 === (125))){
var inst_104065 = (state_104088[(2)]);
var inst_104066 = fluree.db.util.async.throw_err.call(null,inst_104065);
var state_104088__$1 = state_104088;
var statearr_104200_104379 = state_104088__$1;
(statearr_104200_104379[(2)] = inst_104066);

(statearr_104200_104379[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (17))){
var inst_103757 = (state_104088[(2)]);
var inst_103758 = fluree.db.util.async.throw_err.call(null,inst_103757);
var state_104088__$1 = state_104088;
var statearr_104201_104380 = state_104088__$1;
(statearr_104201_104380[(2)] = inst_103758);

(statearr_104201_104380[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (3))){
var inst_103697 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104202_104381 = state_104088__$1;
(statearr_104202_104381[(2)] = inst_103697);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104088__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (12))){
var state_104088__$1 = state_104088;
var statearr_104203_104382 = state_104088__$1;
(statearr_104203_104382[(2)] = opts);

(statearr_104203_104382[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (2))){
var inst_104086 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104088__$1,inst_104086);
} else {
if((state_val_104089 === (66))){
var inst_103866 = opts.cljs$lang$protocol_mask$partition0$;
var inst_103867 = (inst_103866 & (64));
var inst_103868 = opts.cljs$core$ISeq$;
var inst_103869 = (cljs.core.PROTOCOL_SENTINEL === inst_103868);
var inst_103870 = ((inst_103867) || (inst_103869));
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103870)){
var statearr_104204_104383 = state_104088__$1;
(statearr_104204_104383[(1)] = (69));

} else {
var statearr_104205_104384 = state_104088__$1;
(statearr_104205_104384[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (107))){
var inst_103914 = (state_104088[(37)]);
var inst_103971 = (state_104088[(71)]);
var inst_103983 = cljs.core.drop.call(null,inst_103914,inst_103971);
var state_104088__$1 = (function (){var statearr_104206 = state_104088;
(statearr_104206[(27)] = inst_103983);

return statearr_104206;
})();
var statearr_104207_104385 = state_104088__$1;
(statearr_104207_104385[(1)] = (109));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (23))){
var inst_103725 = (state_104088[(64)]);
var inst_103774 = cljs.core.boolean_QMARK_.call(null,inst_103725);
var state_104088__$1 = state_104088;
if(inst_103774){
var statearr_104209_104386 = state_104088__$1;
(statearr_104209_104386[(1)] = (25));

} else {
var statearr_104210_104387 = state_104088__$1;
(statearr_104210_104387[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (47))){
var inst_103724 = (state_104088[(63)]);
var inst_103832 = (state_104088[(2)]);
var inst_103833 = (inst_103724 == null);
var state_104088__$1 = (function (){var statearr_104211 = state_104088;
(statearr_104211[(8)] = inst_103832);

return statearr_104211;
})();
if(cljs.core.truth_(inst_103833)){
var statearr_104212_104388 = state_104088__$1;
(statearr_104212_104388[(1)] = (48));

} else {
var statearr_104213_104389 = state_104088__$1;
(statearr_104213_104389[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (35))){
var inst_103803 = (state_104088[(77)]);
var state_104088__$1 = state_104088;
var statearr_104214_104390 = state_104088__$1;
(statearr_104214_104390[(2)] = inst_103803);

(statearr_104214_104390[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (127))){
var inst_104061 = (state_104088[(7)]);
var state_104088__$1 = state_104088;
var statearr_104215_104391 = state_104088__$1;
(statearr_104215_104391[(2)] = inst_104061);

(statearr_104215_104391[(1)] = (128));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (82))){
var inst_104084 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104216_104392 = state_104088__$1;
(statearr_104216_104392[(2)] = inst_104084);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104088__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (76))){
var state_104088__$1 = state_104088;
var statearr_104217_104393 = state_104088__$1;
(statearr_104217_104393[(2)] = fluree.db.util.core.max_long);

(statearr_104217_104393[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (97))){
var inst_103914 = (state_104088[(37)]);
var inst_103952 = cljs.core._EQ_.call(null,(0),inst_103914);
var state_104088__$1 = state_104088;
if(inst_103952){
var statearr_104218_104394 = state_104088__$1;
(statearr_104218_104394[(1)] = (100));

} else {
var statearr_104219_104395 = state_104088__$1;
(statearr_104219_104395[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (19))){
var inst_103723 = (state_104088[(65)]);
var state_104088__$1 = state_104088;
var statearr_104220_104396 = state_104088__$1;
(statearr_104220_104396[(2)] = inst_103723);

(statearr_104220_104396[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (57))){
var state_104088__$1 = state_104088;
var statearr_104221_104397 = state_104088__$1;
(statearr_104221_104397[(2)] = fluree.db.util.core.min_integer);

(statearr_104221_104397[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (68))){
var inst_103877 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103877)){
var statearr_104222_104398 = state_104088__$1;
(statearr_104222_104398[(1)] = (72));

} else {
var statearr_104223_104399 = state_104088__$1;
(statearr_104223_104399[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (11))){
var inst_103746 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_104088__$1 = state_104088;
var statearr_104224_104400 = state_104088__$1;
(statearr_104224_104400[(2)] = inst_103746);

(statearr_104224_104400[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (115))){
var inst_104010 = (state_104088[(80)]);
var inst_103883 = (state_104088[(24)]);
var inst_104009 = (state_104088[(72)]);
var inst_104011 = (state_104088[(73)]);
var inst_104014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104015 = (inst_104011 - inst_103883);
var inst_104016 = (inst_104010 - inst_104015);
var inst_104017 = cljs.core.take.call(null,inst_104016,inst_104009);
var inst_104018 = [inst_103883,inst_104017];
var inst_104019 = (new cljs.core.PersistentVector(null,2,(5),inst_104014,inst_104018,null));
var state_104088__$1 = state_104088;
var statearr_104225_104401 = state_104088__$1;
(statearr_104225_104401[(2)] = inst_104019);

(statearr_104225_104401[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (9))){
var state_104088__$1 = state_104088;
var statearr_104226_104402 = state_104088__$1;
(statearr_104226_104402[(2)] = false);

(statearr_104226_104402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (5))){
var inst_103733 = opts.cljs$lang$protocol_mask$partition0$;
var inst_103734 = (inst_103733 & (64));
var inst_103735 = opts.cljs$core$ISeq$;
var inst_103736 = (cljs.core.PROTOCOL_SENTINEL === inst_103735);
var inst_103737 = ((inst_103734) || (inst_103736));
var state_104088__$1 = state_104088;
if(cljs.core.truth_(inst_103737)){
var statearr_104227_104403 = state_104088__$1;
(statearr_104227_104403[(1)] = (8));

} else {
var statearr_104228_104404 = state_104088__$1;
(statearr_104228_104404[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (112))){
var inst_103889 = (state_104088[(26)]);
var inst_103993 = (state_104088[(78)]);
var inst_103991 = (state_104088[(79)]);
var inst_103996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103997 = (inst_103991 - inst_103993);
var inst_103998 = [inst_103889,inst_103997];
var inst_103999 = (new cljs.core.PersistentVector(null,2,(5),inst_103996,inst_103998,null));
var state_104088__$1 = state_104088;
var statearr_104229_104405 = state_104088__$1;
(statearr_104229_104405[(2)] = inst_103999);

(statearr_104229_104405[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (83))){
var inst_103861 = (state_104088[(20)]);
var inst_103913 = (state_104088[(36)]);
var inst_103860 = (state_104088[(21)]);
var inst_103922 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_103913);
var inst_103923 = fluree.db.flake.subrange.call(null,inst_103922,start_test,inst_103860,end_test,inst_103861);
var inst_103925 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_103860,inst_103861);
var state_104088__$1 = (function (){var statearr_104230 = state_104088;
(statearr_104230[(38)] = inst_103923);

return statearr_104230;
})();
if(inst_103925){
var statearr_104231_104406 = state_104088__$1;
(statearr_104231_104406[(1)] = (85));

} else {
var statearr_104232_104407 = state_104088__$1;
(statearr_104232_104407[(1)] = (86));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (14))){
var inst_103716 = (state_104088[(61)]);
var inst_103755 = fluree.db.dbproto._subid.call(null,db,inst_103716);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(17),inst_103755);
} else {
if((state_val_104089 === (45))){
var state_104088__$1 = state_104088;
var statearr_104233_104408 = state_104088__$1;
(statearr_104233_104408[(2)] = (-1));

(statearr_104233_104408[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (53))){
var inst_103721 = (state_104088[(62)]);
var inst_103841 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104234 = state_104088;
(statearr_104234[(9)] = inst_103841);

return statearr_104234;
})();
if(cljs.core.truth_(inst_103721)){
var statearr_104235_104409 = state_104088__$1;
(statearr_104235_104409[(1)] = (54));

} else {
var statearr_104236_104410 = state_104088__$1;
(statearr_104236_104410[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (78))){
var inst_103900 = (state_104088[(42)]);
var inst_103860 = (state_104088[(21)]);
var inst_103906 = (state_104088[(51)]);
var inst_103901 = (state_104088[(54)]);
var inst_103896 = (state_104088[(57)]);
var inst_103905 = (state_104088[(2)]);
var inst_103906__$1 = fluree.db.util.async.throw_err.call(null,inst_103905);
var inst_103907 = fluree.db.query.range.find_next_valid_node.call(null,inst_103906__$1,inst_103860,inst_103896,inst_103900,inst_103901);
var state_104088__$1 = (function (){var statearr_104237 = state_104088;
(statearr_104237[(51)] = inst_103906__$1);

return statearr_104237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(79),inst_103907);
} else {
if((state_val_104089 === (26))){
var state_104088__$1 = state_104088;
var statearr_104238_104411 = state_104088__$1;
(statearr_104238_104411[(1)] = (28));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (123))){
var state_104088__$1 = state_104088;
var statearr_104240_104412 = state_104088__$1;
(statearr_104240_104412[(2)] = null);

(statearr_104240_104412[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (16))){
var inst_103723 = (state_104088[(65)]);
var inst_103761 = (state_104088[(2)]);
var inst_103762 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_103723);
var state_104088__$1 = (function (){var statearr_104241 = state_104088;
(statearr_104241[(16)] = inst_103761);

return statearr_104241;
})();
if(inst_103762){
var statearr_104242_104413 = state_104088__$1;
(statearr_104242_104413[(1)] = (18));

} else {
var statearr_104243_104414 = state_104088__$1;
(statearr_104243_104414[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (81))){
var state_104088__$1 = state_104088;
var statearr_104244_104415 = state_104088__$1;
(statearr_104244_104415[(2)] = null);

(statearr_104244_104415[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (120))){
var inst_103950 = (state_104088[(67)]);
var state_104088__$1 = state_104088;
var statearr_104245_104416 = state_104088__$1;
(statearr_104245_104416[(2)] = inst_103950);

(statearr_104245_104416[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (79))){
var inst_103910 = (state_104088[(49)]);
var inst_103909 = (state_104088[(2)]);
var inst_103910__$1 = fluree.db.util.async.throw_err.call(null,inst_103909);
var state_104088__$1 = (function (){var statearr_104246 = state_104088;
(statearr_104246[(49)] = inst_103910__$1);

return statearr_104246;
})();
if(cljs.core.truth_(inst_103910__$1)){
var statearr_104247_104417 = state_104088__$1;
(statearr_104247_104417[(1)] = (80));

} else {
var statearr_104248_104418 = state_104088__$1;
(statearr_104248_104418[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (38))){
var inst_103804 = (state_104088[(58)]);
var inst_103817 = fluree.db.dbproto._subid.call(null,db,inst_103804);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(41),inst_103817);
} else {
if((state_val_104089 === (126))){
var inst_104069 = (state_104088[(34)]);
var state_104088__$1 = state_104088;
var statearr_104249_104419 = state_104088__$1;
(statearr_104249_104419[(2)] = inst_104069);

(statearr_104249_104419[(1)] = (128));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (98))){
var inst_103890 = (state_104088[(46)]);
var state_104088__$1 = state_104088;
var statearr_104250_104420 = state_104088__$1;
(statearr_104250_104420[(2)] = inst_103890);

(statearr_104250_104420[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (124))){
var inst_104061 = (state_104088[(7)]);
var inst_104069 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104251 = state_104088;
(statearr_104251[(34)] = inst_104069);

return statearr_104251;
})();
if(cljs.core.truth_(inst_104061)){
var statearr_104252_104421 = state_104088__$1;
(statearr_104252_104421[(1)] = (126));

} else {
var statearr_104253_104422 = state_104088__$1;
(statearr_104253_104422[(1)] = (127));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (87))){
var inst_103750 = (state_104088[(45)]);
var inst_103931 = (state_104088[(2)]);
var state_104088__$1 = (function (){var statearr_104254 = state_104088;
(statearr_104254[(59)] = inst_103931);

return statearr_104254;
})();
if(cljs.core.truth_(inst_103750)){
var statearr_104255_104423 = state_104088__$1;
(statearr_104255_104423[(1)] = (88));

} else {
var statearr_104256_104424 = state_104088__$1;
(statearr_104256_104424[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (30))){
var inst_103780 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104257_104425 = state_104088__$1;
(statearr_104257_104425[(2)] = inst_103780);

(statearr_104257_104425[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (73))){
var state_104088__$1 = state_104088;
var statearr_104258_104426 = state_104088__$1;
(statearr_104258_104426[(2)] = opts);

(statearr_104258_104426[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (96))){
var inst_103913 = (state_104088[(36)]);
var inst_103890 = (state_104088[(46)]);
var inst_103949 = (state_104088[(2)]);
var inst_103950 = fluree.db.dbproto._rhs.call(null,inst_103913);
var state_104088__$1 = (function (){var statearr_104259 = state_104088;
(statearr_104259[(67)] = inst_103950);

(statearr_104259[(70)] = inst_103949);

return statearr_104259;
})();
if(cljs.core.truth_(inst_103890)){
var statearr_104260_104427 = state_104088__$1;
(statearr_104260_104427[(1)] = (97));

} else {
var statearr_104261_104428 = state_104088__$1;
(statearr_104261_104428[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (10))){
var inst_103741 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104262_104429 = state_104088__$1;
(statearr_104262_104429[(2)] = inst_103741);

(statearr_104262_104429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (18))){
var inst_103723 = (state_104088[(65)]);
var inst_103764 = fluree.db.dbproto._subid.call(null,db,inst_103723);
var state_104088__$1 = state_104088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104088__$1,(21),inst_103764);
} else {
if((state_val_104089 === (105))){
var inst_103950 = (state_104088[(67)]);
var inst_104048 = (state_104088[(2)]);
var inst_104049 = cljs.core.nth.call(null,inst_104048,(0),null);
var inst_104050 = cljs.core.nth.call(null,inst_104048,(1),null);
var inst_104051 = cljs.core.nth.call(null,inst_104048,(2),null);
var inst_104052 = cljs.core.nth.call(null,inst_104048,(3),null);
var state_104088__$1 = (function (){var statearr_104263 = state_104088;
(statearr_104263[(30)] = inst_104050);

(statearr_104263[(31)] = inst_104051);

(statearr_104263[(32)] = inst_104052);

(statearr_104263[(33)] = inst_104049);

return statearr_104263;
})();
if(cljs.core.truth_(inst_103950)){
var statearr_104264_104430 = state_104088__$1;
(statearr_104264_104430[(1)] = (119));

} else {
var statearr_104265_104431 = state_104088__$1;
(statearr_104265_104431[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (52))){
var inst_103724 = (state_104088[(63)]);
var state_104088__$1 = state_104088;
var statearr_104266_104432 = state_104088__$1;
(statearr_104266_104432[(2)] = inst_103724);

(statearr_104266_104432[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (114))){
var inst_103983 = (state_104088[(27)]);
var inst_104010 = (state_104088[(80)]);
var inst_103883 = (state_104088[(24)]);
var inst_104009 = (state_104088[(72)]);
var inst_104011 = (state_104088[(73)]);
var inst_103915 = (state_104088[(29)]);
var inst_104005 = (state_104088[(2)]);
var inst_104006 = cljs.core.nth.call(null,inst_104005,(0),null);
var inst_104007 = cljs.core.nth.call(null,inst_104005,(1),null);
var inst_104008 = cljs.core.take.call(null,inst_104007,inst_103983);
var inst_104009__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_104008);
var inst_104010__$1 = cljs.core.count.call(null,inst_104009__$1);
var inst_104011__$1 = (inst_103915 + inst_104010__$1);
var inst_104012 = (inst_104011__$1 > inst_103883);
var state_104088__$1 = (function (){var statearr_104267 = state_104088;
(statearr_104267[(80)] = inst_104010__$1);

(statearr_104267[(76)] = inst_104006);

(statearr_104267[(72)] = inst_104009__$1);

(statearr_104267[(73)] = inst_104011__$1);

return statearr_104267;
})();
if(cljs.core.truth_(inst_104012)){
var statearr_104268_104433 = state_104088__$1;
(statearr_104268_104433[(1)] = (115));

} else {
var statearr_104269_104434 = state_104088__$1;
(statearr_104269_104434[(1)] = (116));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (67))){
var state_104088__$1 = state_104088;
var statearr_104270_104435 = state_104088__$1;
(statearr_104270_104435[(2)] = false);

(statearr_104270_104435[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (71))){
var inst_103874 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104271_104436 = state_104088__$1;
(statearr_104271_104436[(2)] = inst_103874);

(statearr_104271_104436[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (42))){
var inst_103814 = (state_104088[(12)]);
var state_104088__$1 = state_104088;
var statearr_104272_104437 = state_104088__$1;
(statearr_104272_104437[(2)] = inst_103814);

(statearr_104272_104437[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (80))){
var inst_103910 = (state_104088[(49)]);
var inst_103885 = (state_104088[(25)]);
var inst_103912 = cljs.core.PersistentVector.EMPTY;
var inst_103913 = inst_103910;
var inst_103914 = inst_103885;
var inst_103915 = (0);
var inst_103916 = (0);
var inst_103917 = inst_103912;
var state_104088__$1 = (function (){var statearr_104273 = state_104088;
(statearr_104273[(35)] = inst_103917);

(statearr_104273[(36)] = inst_103913);

(statearr_104273[(37)] = inst_103914);

(statearr_104273[(28)] = inst_103916);

(statearr_104273[(29)] = inst_103915);

return statearr_104273;
})();
var statearr_104274_104438 = state_104088__$1;
(statearr_104274_104438[(2)] = null);

(statearr_104274_104438[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (37))){
var inst_103810 = (state_104088[(2)]);
var inst_103811 = fluree.db.util.async.throw_err.call(null,inst_103810);
var state_104088__$1 = state_104088;
var statearr_104275_104439 = state_104088__$1;
(statearr_104275_104439[(2)] = inst_103811);

(statearr_104275_104439[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (63))){
var state_104088__$1 = state_104088;
var statearr_104276_104440 = state_104088__$1;
(statearr_104276_104440[(2)] = (2147483647));

(statearr_104276_104440[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (94))){
var inst_103900 = (state_104088[(42)]);
var inst_103889 = (state_104088[(26)]);
var inst_103751 = (state_104088[(43)]);
var inst_103832 = (state_104088[(8)]);
var inst_103861 = (state_104088[(20)]);
var inst_103917 = (state_104088[(35)]);
var inst_103841 = (state_104088[(9)]);
var inst_103770 = (state_104088[(10)]);
var inst_103859 = (state_104088[(11)]);
var inst_103814 = (state_104088[(12)]);
var inst_103891 = (state_104088[(44)]);
var inst_103913 = (state_104088[(36)]);
var inst_103750 = (state_104088[(45)]);
var inst_103883 = (state_104088[(24)]);
var inst_103890 = (state_104088[(46)]);
var inst_103943 = (state_104088[(68)]);
var inst_103914 = (state_104088[(37)]);
var inst_103801 = (state_104088[(47)]);
var inst_103720 = (state_104088[(13)]);
var inst_103823 = (state_104088[(14)]);
var inst_103895 = (state_104088[(48)]);
var inst_103719 = (state_104088[(15)]);
var inst_103910 = (state_104088[(49)]);
var inst_103860 = (state_104088[(21)]);
var inst_103761 = (state_104088[(16)]);
var inst_103805 = (state_104088[(50)]);
var inst_103923 = (state_104088[(38)]);
var inst_103727 = (state_104088[(17)]);
var inst_103906 = (state_104088[(51)]);
var inst_103850 = (state_104088[(18)]);
var inst_103726 = (state_104088[(19)]);
var inst_103916 = (state_104088[(28)]);
var inst_103715 = (state_104088[(52)]);
var inst_103722 = (state_104088[(53)]);
var inst_103901 = (state_104088[(54)]);
var inst_103915 = (state_104088[(29)]);
var inst_103882 = (state_104088[(23)]);
var inst_103749 = (state_104088[(55)]);
var inst_103802 = (state_104088[(56)]);
var inst_103896 = (state_104088[(57)]);
var inst_103945 = (function (){var no_filter_QMARK_ = true;
var t = inst_103896;
var max_limit_QMARK_ = inst_103890;
var next_node = inst_103913;
var fast_forward_db_QMARK_ = inst_103901;
var map__103707 = inst_103749;
var s1 = inst_103761;
var o2 = inst_103823;
var t1 = inst_103719;
var predicate_fn = inst_103751;
var i = inst_103915;
var m1 = inst_103850;
var root_node = inst_103906;
var s2 = inst_103770;
var p2 = inst_103841;
var vec__103711 = inst_103802;
var permissions = inst_103891;
var vec__103704 = inst_103722;
var limit = inst_103889;
var start_flake = inst_103860;
var flake_limit = inst_103883;
var offset = inst_103914;
var acc = inst_103917;
var t2 = inst_103726;
var op1 = inst_103720;
var vec__103701 = inst_103715;
var o1 = inst_103814;
var end_flake = inst_103861;
var base_result = inst_103923;
var s = inst_103916;
var node_start = inst_103910;
var p1 = inst_103832;
var subject_fn = inst_103750;
var G__103924 = inst_103943;
var object_fn = inst_103805;
var map__103714 = inst_103882;
var idx_compare = inst_103895;
var vec__103708 = inst_103801;
var op2 = inst_103727;
var m2 = inst_103859;
var novelty = inst_103900;
return (function (p1__103687_SHARP_){
return object_fn.call(null,p1__103687_SHARP_.o);
});
})();
var inst_103946 = cljs.core.filter.call(null,inst_103945,inst_103943);
var state_104088__$1 = state_104088;
var statearr_104277_104441 = state_104088__$1;
(statearr_104277_104441[(2)] = inst_103946);

(statearr_104277_104441[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (8))){
var state_104088__$1 = state_104088;
var statearr_104278_104442 = state_104088__$1;
(statearr_104278_104442[(2)] = true);

(statearr_104278_104442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (49))){
var state_104088__$1 = state_104088;
var statearr_104279_104443 = state_104088__$1;
(statearr_104279_104443[(2)] = false);

(statearr_104279_104443[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104089 === (84))){
var inst_104081 = (state_104088[(2)]);
var state_104088__$1 = state_104088;
var statearr_104280_104444 = state_104088__$1;
(statearr_104280_104444[(2)] = inst_104081);

(statearr_104280_104444[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_104281 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104281[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_104281[(1)] = (1));

return statearr_104281;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_104088){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104282){if((e104282 instanceof Object)){
var ex__99978__auto__ = e104282;
var statearr_104283_104445 = state_104088;
(statearr_104283_104445[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104088);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104282;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104446 = state_104088;
state_104088 = G__104446;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_104088){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_104088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104284 = f__100070__auto__.call(null);
(statearr_104284[(6)] = c__100069__auto__);

return statearr_104284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104501){
var state_val_104502 = (state_104501[(1)]);
if((state_val_104502 === (7))){
var inst_104475 = (state_104501[(7)]);
var inst_104465 = (state_104501[(8)]);
var inst_104473 = fluree.db.flake.Flake__GT_parts.call(null,inst_104465);
var inst_104474 = cljs.core.nth.call(null,inst_104473,(0),null);
var inst_104475__$1 = cljs.core.nth.call(null,inst_104473,(1),null);
var inst_104476 = cljs.core.nth.call(null,inst_104473,(2),null);
var inst_104477 = cljs.core.nth.call(null,inst_104473,(3),null);
var inst_104478 = cljs.core.nth.call(null,inst_104473,(4),null);
var inst_104479 = cljs.core.nth.call(null,inst_104473,(5),null);
var inst_104480 = fluree.db.dbproto._tag.call(null,db,inst_104476,inst_104475__$1);
var state_104501__$1 = (function (){var statearr_104503 = state_104501;
(statearr_104503[(7)] = inst_104475__$1);

(statearr_104503[(9)] = inst_104477);

(statearr_104503[(10)] = inst_104479);

(statearr_104503[(11)] = inst_104474);

(statearr_104503[(12)] = inst_104478);

return statearr_104503;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104501__$1,(10),inst_104480);
} else {
if((state_val_104502 === (1))){
var inst_104454 = cljs.core.seq.call(null,flakes);
var inst_104455 = cljs.core.first.call(null,inst_104454);
var inst_104456 = cljs.core.next.call(null,inst_104454);
var inst_104457 = cljs.core.PersistentVector.EMPTY;
var inst_104458 = flakes;
var inst_104459 = inst_104457;
var state_104501__$1 = (function (){var statearr_104504 = state_104501;
(statearr_104504[(13)] = inst_104456);

(statearr_104504[(14)] = inst_104459);

(statearr_104504[(15)] = inst_104458);

(statearr_104504[(16)] = inst_104455);

return statearr_104504;
})();
var statearr_104505_104522 = state_104501__$1;
(statearr_104505_104522[(2)] = null);

(statearr_104505_104522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (4))){
var inst_104465 = (state_104501[(8)]);
var inst_104468 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_104465);
var state_104501__$1 = state_104501;
if(inst_104468){
var statearr_104506_104523 = state_104501__$1;
(statearr_104506_104523[(1)] = (7));

} else {
var statearr_104507_104524 = state_104501__$1;
(statearr_104507_104524[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (6))){
var inst_104497 = (state_104501[(2)]);
var state_104501__$1 = state_104501;
var statearr_104508_104525 = state_104501__$1;
(statearr_104508_104525[(2)] = inst_104497);

(statearr_104508_104525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (3))){
var inst_104499 = (state_104501[(2)]);
var state_104501__$1 = state_104501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104501__$1,inst_104499);
} else {
if((state_val_104502 === (2))){
var inst_104465 = (state_104501[(8)]);
var inst_104458 = (state_104501[(15)]);
var inst_104464 = cljs.core.seq.call(null,inst_104458);
var inst_104465__$1 = cljs.core.first.call(null,inst_104464);
var inst_104466 = cljs.core.next.call(null,inst_104464);
var state_104501__$1 = (function (){var statearr_104509 = state_104501;
(statearr_104509[(8)] = inst_104465__$1);

(statearr_104509[(17)] = inst_104466);

return statearr_104509;
})();
if(cljs.core.truth_(inst_104465__$1)){
var statearr_104510_104526 = state_104501__$1;
(statearr_104510_104526[(1)] = (4));

} else {
var statearr_104511_104527 = state_104501__$1;
(statearr_104511_104527[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (9))){
var inst_104494 = (state_104501[(2)]);
var state_104501__$1 = state_104501;
var statearr_104512_104528 = state_104501__$1;
(statearr_104512_104528[(2)] = inst_104494);

(statearr_104512_104528[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (5))){
var inst_104459 = (state_104501[(14)]);
var state_104501__$1 = state_104501;
var statearr_104513_104529 = state_104501__$1;
(statearr_104513_104529[(2)] = inst_104459);

(statearr_104513_104529[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (10))){
var inst_104475 = (state_104501[(7)]);
var inst_104477 = (state_104501[(9)]);
var inst_104459 = (state_104501[(14)]);
var inst_104466 = (state_104501[(17)]);
var inst_104479 = (state_104501[(10)]);
var inst_104474 = (state_104501[(11)]);
var inst_104478 = (state_104501[(12)]);
var inst_104482 = (state_104501[(2)]);
var inst_104483 = fluree.db.util.async.throw_err.call(null,inst_104482);
var inst_104484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104485 = [inst_104474,inst_104475,inst_104483,inst_104477,inst_104478,inst_104479];
var inst_104486 = (new cljs.core.PersistentVector(null,6,(5),inst_104484,inst_104485,null));
var inst_104487 = fluree.db.flake.parts__GT_Flake.call(null,inst_104486);
var inst_104488 = cljs.core.conj.call(null,inst_104459,inst_104487);
var inst_104458 = inst_104466;
var inst_104459__$1 = inst_104488;
var state_104501__$1 = (function (){var statearr_104514 = state_104501;
(statearr_104514[(14)] = inst_104459__$1);

(statearr_104514[(15)] = inst_104458);

return statearr_104514;
})();
var statearr_104515_104530 = state_104501__$1;
(statearr_104515_104530[(2)] = null);

(statearr_104515_104530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104502 === (8))){
var inst_104465 = (state_104501[(8)]);
var inst_104459 = (state_104501[(14)]);
var inst_104466 = (state_104501[(17)]);
var inst_104491 = cljs.core.conj.call(null,inst_104459,inst_104465);
var inst_104458 = inst_104466;
var inst_104459__$1 = inst_104491;
var state_104501__$1 = (function (){var statearr_104516 = state_104501;
(statearr_104516[(14)] = inst_104459__$1);

(statearr_104516[(15)] = inst_104458);

return statearr_104516;
})();
var statearr_104517_104531 = state_104501__$1;
(statearr_104517_104531[(2)] = null);

(statearr_104517_104531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0 = (function (){
var statearr_104518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104518[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__);

(statearr_104518[(1)] = (1));

return statearr_104518;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1 = (function (state_104501){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104519){if((e104519 instanceof Object)){
var ex__99978__auto__ = e104519;
var statearr_104520_104532 = state_104501;
(statearr_104520_104532[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104519;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104533 = state_104501;
state_104501 = G__104533;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__ = function(state_104501){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1.call(this,state_104501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104521 = f__100070__auto__.call(null);
(statearr_104521[(6)] = c__100069__auto__);

return statearr_104521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__104535 = arguments.length;
switch (G__104535) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104682){
var state_val_104683 = (state_104682[(1)]);
if((state_val_104683 === (62))){
var inst_104678 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104684_104766 = state_104682__$1;
(statearr_104684_104766[(2)] = inst_104678);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104682__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (7))){
var inst_104553 = (state_104682[(7)]);
var inst_104553__$1 = (state_104682[(2)]);
var state_104682__$1 = (function (){var statearr_104685 = state_104682;
(statearr_104685[(7)] = inst_104553__$1);

return statearr_104685;
})();
if(cljs.core.truth_(inst_104553__$1)){
var statearr_104686_104767 = state_104682__$1;
(statearr_104686_104767[(1)] = (8));

} else {
var statearr_104687_104768 = state_104682__$1;
(statearr_104687_104768[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (59))){
var inst_104658 = (state_104682[(2)]);
var inst_104659 = fluree.db.util.async.throw_err.call(null,inst_104658);
var state_104682__$1 = state_104682;
var statearr_104688_104769 = state_104682__$1;
(statearr_104688_104769[(2)] = inst_104659);

(statearr_104688_104769[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (20))){
var inst_104579 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104689_104770 = state_104682__$1;
(statearr_104689_104770[(2)] = inst_104579);

(statearr_104689_104770[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (58))){
var inst_104662 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104690_104771 = state_104682__$1;
(statearr_104690_104771[(2)] = inst_104662);

(statearr_104690_104771[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (60))){
var inst_104670 = (state_104682[(8)]);
var inst_104672 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_104670);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(63),inst_104672);
} else {
if((state_val_104683 === (27))){
var inst_104544 = (state_104682[(9)]);
var state_104682__$1 = state_104682;
var statearr_104691_104772 = state_104682__$1;
(statearr_104691_104772[(2)] = inst_104544);

(statearr_104691_104772[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (1))){
var state_104682__$1 = state_104682;
var statearr_104692_104773 = state_104682__$1;
(statearr_104692_104773[(2)] = null);

(statearr_104692_104773[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (24))){
var inst_104553 = (state_104682[(7)]);
var inst_104670 = (state_104682[(2)]);
var state_104682__$1 = (function (){var statearr_104693 = state_104682;
(statearr_104693[(8)] = inst_104670);

return statearr_104693;
})();
if(cljs.core.truth_(inst_104553)){
var statearr_104694_104774 = state_104682__$1;
(statearr_104694_104774[(1)] = (60));

} else {
var statearr_104695_104775 = state_104682__$1;
(statearr_104695_104775[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (55))){
var inst_104649 = (state_104682[(2)]);
var inst_104650 = fluree.db.util.async.throw_err.call(null,inst_104649);
var state_104682__$1 = state_104682;
var statearr_104696_104776 = state_104682__$1;
(statearr_104696_104776[(2)] = inst_104650);

(statearr_104696_104776[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (39))){
var inst_104547 = (state_104682[(10)]);
var inst_104618 = cljs.core.not.call(null,inst_104547);
var state_104682__$1 = state_104682;
if(inst_104618){
var statearr_104697_104777 = state_104682__$1;
(statearr_104697_104777[(1)] = (42));

} else {
var statearr_104698_104778 = state_104682__$1;
(statearr_104698_104778[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (46))){
var inst_104544 = (state_104682[(9)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104544)){
var statearr_104699_104779 = state_104682__$1;
(statearr_104699_104779[(1)] = (52));

} else {
var statearr_104700_104780 = state_104682__$1;
(statearr_104700_104780[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (4))){
var inst_104544 = (state_104682[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104682,(3),Error,null,(2));
var inst_104543 = cljs.core.nth.call(null,fparts,(0),null);
var inst_104544__$1 = cljs.core.nth.call(null,fparts,(1),null);
var inst_104545 = cljs.core.nth.call(null,fparts,(2),null);
var inst_104546 = cljs.core.nth.call(null,fparts,(3),null);
var inst_104547 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_104544__$1);
var state_104682__$1 = (function (){var statearr_104701 = state_104682;
(statearr_104701[(9)] = inst_104544__$1);

(statearr_104701[(11)] = inst_104543);

(statearr_104701[(12)] = inst_104545);

(statearr_104701[(10)] = inst_104547);

(statearr_104701[(13)] = inst_104546);

return statearr_104701;
})();
if(cljs.core.truth_(inst_104544__$1)){
var statearr_104702_104781 = state_104682__$1;
(statearr_104702_104781[(1)] = (5));

} else {
var statearr_104703_104782 = state_104682__$1;
(statearr_104703_104782[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (54))){
var inst_104664 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104704_104783 = state_104682__$1;
(statearr_104704_104783[(2)] = inst_104664);

(statearr_104704_104783[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (15))){
var inst_104545 = (state_104682[(12)]);
var inst_104569 = typeof inst_104545 === 'string';
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104569)){
var statearr_104705_104784 = state_104682__$1;
(statearr_104705_104784[(1)] = (18));

} else {
var statearr_104706_104785 = state_104682__$1;
(statearr_104706_104785[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (48))){
var inst_104558 = (state_104682[(14)]);
var inst_104627 = (state_104682[(15)]);
var inst_104553 = (state_104682[(7)]);
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104547 = (state_104682[(10)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104629 = (function (){var obj_fn = inst_104627;
var t = inst_104546;
var temp__5733__auto__ = inst_104627;
var p = inst_104544;
var idx_predicate_QMARK_ = inst_104547;
var o = inst_104583;
var vec__104540 = fparts;
var tag_predicate_QMARK_ = inst_104553;
var s = inst_104543;
var o_coerce_QMARK_ = inst_104558;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_104682__$1 = state_104682;
var statearr_104707_104786 = state_104682__$1;
(statearr_104707_104786[(2)] = inst_104629);

(statearr_104707_104786[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (50))){
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104546 = (state_104682[(13)]);
var inst_104633 = (state_104682[(2)]);
var inst_104634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104635 = [inst_104544,inst_104543,null,inst_104546];
var inst_104636 = (new cljs.core.PersistentVector(null,4,(5),inst_104634,inst_104635,null));
var inst_104637 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_104633);
var inst_104638 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_104636,inst_104637);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(51),inst_104638);
} else {
if((state_val_104683 === (21))){
var inst_104575 = (state_104682[(2)]);
var inst_104576 = fluree.db.util.async.throw_err.call(null,inst_104575);
var state_104682__$1 = state_104682;
var statearr_104708_104787 = state_104682__$1;
(statearr_104708_104787[(2)] = inst_104576);

(statearr_104708_104787[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (31))){
var inst_104604 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104709_104788 = state_104682__$1;
(statearr_104709_104788[(2)] = inst_104604);

(statearr_104709_104788[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (32))){
var inst_104583 = (state_104682[(16)]);
var inst_104597 = cljs.core.fn_QMARK_.call(null,inst_104583);
var inst_104598 = (!(inst_104597));
var state_104682__$1 = state_104682;
var statearr_104710_104789 = state_104682__$1;
(statearr_104710_104789[(2)] = inst_104598);

(statearr_104710_104789[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (40))){
var inst_104544 = (state_104682[(9)]);
var state_104682__$1 = state_104682;
var statearr_104711_104790 = state_104682__$1;
(statearr_104711_104790[(2)] = inst_104544);

(statearr_104711_104790[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (56))){
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104654 = [inst_104583,inst_104544,inst_104543,inst_104546];
var inst_104655 = (new cljs.core.PersistentVector(null,4,(5),inst_104653,inst_104654,null));
var inst_104656 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_104655,opts);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(59),inst_104656);
} else {
if((state_val_104683 === (33))){
var inst_104547 = (state_104682[(10)]);
var state_104682__$1 = state_104682;
var statearr_104712_104791 = state_104682__$1;
(statearr_104712_104791[(2)] = inst_104547);

(statearr_104712_104791[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (13))){
var inst_104543 = (state_104682[(11)]);
var inst_104583 = (state_104682[(2)]);
var state_104682__$1 = (function (){var statearr_104713 = state_104682;
(statearr_104713[(16)] = inst_104583);

return statearr_104713;
})();
if(cljs.core.truth_(inst_104543)){
var statearr_104714_104792 = state_104682__$1;
(statearr_104714_104792[(1)] = (22));

} else {
var statearr_104715_104793 = state_104682__$1;
(statearr_104715_104793[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (22))){
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104586 = [inst_104543,inst_104544,inst_104583,inst_104546];
var inst_104587 = (new cljs.core.PersistentVector(null,4,(5),inst_104585,inst_104586,null));
var inst_104588 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_104587,opts);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(25),inst_104588);
} else {
if((state_val_104683 === (36))){
var inst_104544 = (state_104682[(9)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104544)){
var statearr_104716_104794 = state_104682__$1;
(statearr_104716_104794[(1)] = (39));

} else {
var statearr_104717_104795 = state_104682__$1;
(statearr_104717_104795[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (41))){
var inst_104625 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104625)){
var statearr_104718_104796 = state_104682__$1;
(statearr_104718_104796[(1)] = (45));

} else {
var statearr_104719_104797 = state_104682__$1;
(statearr_104719_104797[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (43))){
var state_104682__$1 = state_104682;
var statearr_104720_104798 = state_104682__$1;
(statearr_104720_104798[(2)] = false);

(statearr_104720_104798[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (61))){
var inst_104670 = (state_104682[(8)]);
var state_104682__$1 = state_104682;
var statearr_104721_104799 = state_104682__$1;
(statearr_104721_104799[(2)] = inst_104670);

(statearr_104721_104799[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (29))){
var inst_104547 = (state_104682[(10)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104547)){
var statearr_104722_104800 = state_104682__$1;
(statearr_104722_104800[(1)] = (32));

} else {
var statearr_104723_104801 = state_104682__$1;
(statearr_104723_104801[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (44))){
var inst_104622 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104724_104802 = state_104682__$1;
(statearr_104724_104802[(2)] = inst_104622);

(statearr_104724_104802[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (6))){
var state_104682__$1 = state_104682;
var statearr_104725_104803 = state_104682__$1;
(statearr_104725_104803[(2)] = false);

(statearr_104725_104803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (28))){
var inst_104607 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104607)){
var statearr_104726_104804 = state_104682__$1;
(statearr_104726_104804[(1)] = (35));

} else {
var statearr_104727_104805 = state_104682__$1;
(statearr_104727_104805[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (51))){
var inst_104640 = (state_104682[(2)]);
var inst_104641 = fluree.db.util.async.throw_err.call(null,inst_104640);
var state_104682__$1 = state_104682;
var statearr_104728_104806 = state_104682__$1;
(statearr_104728_104806[(2)] = inst_104641);

(statearr_104728_104806[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (25))){
var inst_104590 = (state_104682[(2)]);
var inst_104591 = fluree.db.util.async.throw_err.call(null,inst_104590);
var state_104682__$1 = state_104682;
var statearr_104729_104807 = state_104682__$1;
(statearr_104729_104807[(2)] = inst_104591);

(statearr_104729_104807[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (34))){
var inst_104601 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104730_104808 = state_104682__$1;
(statearr_104730_104808[(2)] = inst_104601);

(statearr_104730_104808[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (17))){
var inst_104566 = (state_104682[(2)]);
var inst_104567 = fluree.db.util.async.throw_err.call(null,inst_104566);
var state_104682__$1 = state_104682;
var statearr_104731_104809 = state_104682__$1;
(statearr_104731_104809[(2)] = inst_104567);

(statearr_104731_104809[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (3))){
var inst_104536 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104732_104810 = state_104682__$1;
(statearr_104732_104810[(2)] = inst_104536);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104682__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (12))){
var inst_104545 = (state_104682[(12)]);
var inst_104562 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_104545);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104562)){
var statearr_104733_104811 = state_104682__$1;
(statearr_104733_104811[(1)] = (14));

} else {
var statearr_104734_104812 = state_104682__$1;
(statearr_104734_104812[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (2))){
var inst_104680 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104682__$1,inst_104680);
} else {
if((state_val_104683 === (23))){
var inst_104544 = (state_104682[(9)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104544)){
var statearr_104735_104813 = state_104682__$1;
(statearr_104735_104813[(1)] = (26));

} else {
var statearr_104736_104814 = state_104682__$1;
(statearr_104736_104814[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (47))){
var inst_104666 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104737_104815 = state_104682__$1;
(statearr_104737_104815[(2)] = inst_104666);

(statearr_104737_104815[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (35))){
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104610 = [inst_104544,inst_104583,inst_104543,inst_104546];
var inst_104611 = (new cljs.core.PersistentVector(null,4,(5),inst_104609,inst_104610,null));
var inst_104612 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_104611,opts);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(38),inst_104612);
} else {
if((state_val_104683 === (19))){
var state_104682__$1 = state_104682;
var statearr_104738_104816 = state_104682__$1;
(statearr_104738_104816[(2)] = null);

(statearr_104738_104816[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (57))){
var state_104682__$1 = state_104682;
var statearr_104739_104817 = state_104682__$1;
(statearr_104739_104817[(2)] = null);

(statearr_104739_104817[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (11))){
var inst_104545 = (state_104682[(12)]);
var state_104682__$1 = state_104682;
var statearr_104740_104818 = state_104682__$1;
(statearr_104740_104818[(2)] = inst_104545);

(statearr_104740_104818[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (9))){
var inst_104553 = (state_104682[(7)]);
var state_104682__$1 = state_104682;
var statearr_104741_104819 = state_104682__$1;
(statearr_104741_104819[(2)] = inst_104553);

(statearr_104741_104819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (5))){
var inst_104544 = (state_104682[(9)]);
var inst_104549 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_104544);
var inst_104550 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_104549);
var state_104682__$1 = state_104682;
var statearr_104742_104820 = state_104682__$1;
(statearr_104742_104820[(2)] = inst_104550);

(statearr_104742_104820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (14))){
var inst_104545 = (state_104682[(12)]);
var inst_104564 = fluree.db.dbproto._tag_id.call(null,db,inst_104545);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(17),inst_104564);
} else {
if((state_val_104683 === (45))){
var inst_104627 = (state_104682[(15)]);
var inst_104627__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_104682__$1 = (function (){var statearr_104743 = state_104682;
(statearr_104743[(15)] = inst_104627__$1);

return statearr_104743;
})();
if(cljs.core.truth_(inst_104627__$1)){
var statearr_104744_104821 = state_104682__$1;
(statearr_104744_104821[(1)] = (48));

} else {
var statearr_104745_104822 = state_104682__$1;
(statearr_104745_104822[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (53))){
var inst_104583 = (state_104682[(16)]);
var state_104682__$1 = state_104682;
if(cljs.core.truth_(inst_104583)){
var statearr_104746_104823 = state_104682__$1;
(statearr_104746_104823[(1)] = (56));

} else {
var statearr_104747_104824 = state_104682__$1;
(statearr_104747_104824[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (26))){
var inst_104583 = (state_104682[(16)]);
var inst_104594 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_104583);
var state_104682__$1 = state_104682;
if(inst_104594){
var statearr_104748_104825 = state_104682__$1;
(statearr_104748_104825[(1)] = (29));

} else {
var statearr_104749_104826 = state_104682__$1;
(statearr_104749_104826[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (16))){
var inst_104581 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104750_104827 = state_104682__$1;
(statearr_104750_104827[(2)] = inst_104581);

(statearr_104750_104827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (38))){
var inst_104614 = (state_104682[(2)]);
var inst_104615 = fluree.db.util.async.throw_err.call(null,inst_104614);
var state_104682__$1 = state_104682;
var statearr_104751_104828 = state_104682__$1;
(statearr_104751_104828[(2)] = inst_104615);

(statearr_104751_104828[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (30))){
var state_104682__$1 = state_104682;
var statearr_104752_104829 = state_104682__$1;
(statearr_104752_104829[(2)] = false);

(statearr_104752_104829[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (10))){
var inst_104558 = (state_104682[(14)]);
var inst_104558__$1 = (state_104682[(2)]);
var inst_104559 = cljs.core.not.call(null,inst_104558__$1);
var state_104682__$1 = (function (){var statearr_104753 = state_104682;
(statearr_104753[(14)] = inst_104558__$1);

return statearr_104753;
})();
if(inst_104559){
var statearr_104754_104830 = state_104682__$1;
(statearr_104754_104830[(1)] = (11));

} else {
var statearr_104755_104831 = state_104682__$1;
(statearr_104755_104831[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (18))){
var inst_104544 = (state_104682[(9)]);
var inst_104545 = (state_104682[(12)]);
var inst_104571 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_104544);
var inst_104572 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104571),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_104545)].join('');
var inst_104573 = fluree.db.dbproto._tag_id.call(null,db,inst_104572);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(21),inst_104573);
} else {
if((state_val_104683 === (52))){
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104645 = [inst_104544,inst_104543,inst_104583,inst_104546];
var inst_104646 = (new cljs.core.PersistentVector(null,4,(5),inst_104644,inst_104645,null));
var inst_104647 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_104646,opts);
var state_104682__$1 = state_104682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104682__$1,(55),inst_104647);
} else {
if((state_val_104683 === (42))){
var inst_104583 = (state_104682[(16)]);
var state_104682__$1 = state_104682;
var statearr_104756_104832 = state_104682__$1;
(statearr_104756_104832[(2)] = inst_104583);

(statearr_104756_104832[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (37))){
var inst_104668 = (state_104682[(2)]);
var state_104682__$1 = state_104682;
var statearr_104757_104833 = state_104682__$1;
(statearr_104757_104833[(2)] = inst_104668);

(statearr_104757_104833[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (63))){
var inst_104674 = (state_104682[(2)]);
var inst_104675 = fluree.db.util.async.throw_err.call(null,inst_104674);
var state_104682__$1 = state_104682;
var statearr_104758_104834 = state_104682__$1;
(statearr_104758_104834[(2)] = inst_104675);

(statearr_104758_104834[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (8))){
var inst_104545 = (state_104682[(12)]);
var inst_104555 = typeof inst_104545 === 'string';
var state_104682__$1 = state_104682;
var statearr_104759_104835 = state_104682__$1;
(statearr_104759_104835[(2)] = inst_104555);

(statearr_104759_104835[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104683 === (49))){
var inst_104558 = (state_104682[(14)]);
var inst_104627 = (state_104682[(15)]);
var inst_104553 = (state_104682[(7)]);
var inst_104544 = (state_104682[(9)]);
var inst_104543 = (state_104682[(11)]);
var inst_104547 = (state_104682[(10)]);
var inst_104583 = (state_104682[(16)]);
var inst_104546 = (state_104682[(13)]);
var inst_104631 = (function (){var t = inst_104546;
var temp__5733__auto__ = inst_104627;
var p = inst_104544;
var idx_predicate_QMARK_ = inst_104547;
var o = inst_104583;
var vec__104540 = fparts;
var tag_predicate_QMARK_ = inst_104553;
var s = inst_104543;
var o_coerce_QMARK_ = inst_104558;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_104682__$1 = state_104682;
var statearr_104760_104836 = state_104682__$1;
(statearr_104760_104836[(2)] = inst_104631);

(statearr_104760_104836[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_104761 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104761[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_104761[(1)] = (1));

return statearr_104761;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_104682){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104762){if((e104762 instanceof Object)){
var ex__99978__auto__ = e104762;
var statearr_104763_104837 = state_104682;
(statearr_104763_104837[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104762;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104838 = state_104682;
state_104682 = G__104838;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_104682){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_104682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104764 = f__100070__auto__.call(null);
(statearr_104764[(6)] = c__100069__auto__);

return statearr_104764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__104840 = arguments.length;
switch (G__104840) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_104872){
var state_val_104873 = (state_104872[(1)]);
if((state_val_104873 === (1))){
var state_104872__$1 = state_104872;
var statearr_104874_104887 = state_104872__$1;
(statearr_104874_104887[(2)] = null);

(statearr_104874_104887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104873 === (2))){
var inst_104870 = (state_104872[(2)]);
var state_104872__$1 = state_104872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_104872__$1,inst_104870);
} else {
if((state_val_104873 === (3))){
var inst_104841 = (state_104872[(2)]);
var state_104872__$1 = state_104872;
var statearr_104875_104888 = state_104872__$1;
(statearr_104875_104888[(2)] = inst_104841);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104872__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104873 === (4))){
var inst_104845 = (state_104872[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_104872,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_104845__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_104872__$1 = (function (){var statearr_104876 = state_104872;
(statearr_104876[(7)] = inst_104845__$1);

return statearr_104876;
})();
if(cljs.core.truth_(inst_104845__$1)){
var statearr_104877_104889 = state_104872__$1;
(statearr_104877_104889[(1)] = (5));

} else {
var statearr_104878_104890 = state_104872__$1;
(statearr_104878_104890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104873 === (5))){
var inst_104845 = (state_104872[(7)]);
var inst_104847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104848 = fluree.db.flake.max_subject_id.call(null,inst_104845);
var inst_104849 = [inst_104848];
var inst_104850 = (new cljs.core.PersistentVector(null,1,(5),inst_104847,inst_104849,null));
var inst_104851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104852 = fluree.db.flake.min_subject_id.call(null,inst_104845);
var inst_104853 = [inst_104852];
var inst_104854 = (new cljs.core.PersistentVector(null,1,(5),inst_104851,inst_104853,null));
var inst_104855 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_104850,cljs.core._LT__EQ_,inst_104854,opts);
var state_104872__$1 = state_104872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_104872__$1,(8),inst_104855);
} else {
if((state_val_104873 === (6))){
var inst_104860 = cljs.core.pr_str.call(null,name);
var inst_104861 = ["Invalid collection name: ",inst_104860].join('');
var inst_104862 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_104863 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_104864 = cljs.core.PersistentHashMap.fromArrays(inst_104862,inst_104863);
var inst_104865 = cljs.core.ex_info.call(null,inst_104861,inst_104864);
var inst_104866 = (function(){throw inst_104865})();
var state_104872__$1 = state_104872;
var statearr_104879_104891 = state_104872__$1;
(statearr_104879_104891[(2)] = inst_104866);

(statearr_104879_104891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104873 === (7))){
var inst_104868 = (state_104872[(2)]);
var state_104872__$1 = state_104872;
var statearr_104880_104892 = state_104872__$1;
(statearr_104880_104892[(2)] = inst_104868);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104872__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_104873 === (8))){
var inst_104857 = (state_104872[(2)]);
var inst_104858 = fluree.db.util.async.throw_err.call(null,inst_104857);
var state_104872__$1 = state_104872;
var statearr_104881_104893 = state_104872__$1;
(statearr_104881_104893[(2)] = inst_104858);

(statearr_104881_104893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__99975__auto__ = null;
var fluree$db$query$range$state_machine__99975__auto____0 = (function (){
var statearr_104882 = [null,null,null,null,null,null,null,null];
(statearr_104882[(0)] = fluree$db$query$range$state_machine__99975__auto__);

(statearr_104882[(1)] = (1));

return statearr_104882;
});
var fluree$db$query$range$state_machine__99975__auto____1 = (function (state_104872){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_104872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e104883){if((e104883 instanceof Object)){
var ex__99978__auto__ = e104883;
var statearr_104884_104894 = state_104872;
(statearr_104884_104894[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_104872);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e104883;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__104895 = state_104872;
state_104872 = G__104895;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99975__auto__ = function(state_104872){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99975__auto____1.call(this,state_104872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99975__auto____0;
fluree$db$query$range$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99975__auto____1;
return fluree$db$query$range$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_104885 = f__100070__auto__.call(null);
(statearr_104885[(6)] = c__100069__auto__);

return statearr_104885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__104899 = flakes;
var vec__104900 = G__104899;
var seq__104901 = cljs.core.seq.call(null,vec__104900);
var first__104902 = cljs.core.first.call(null,seq__104901);
var seq__104901__$1 = cljs.core.next.call(null,seq__104901);
var flake_SINGLEQUOTE_ = first__104902;
var r = seq__104901__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__104899__$1 = G__104899;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__104909 = G__104899__$1;
var seq__104910 = cljs.core.seq.call(null,vec__104909);
var first__104911 = cljs.core.first.call(null,seq__104910);
var seq__104910__$1 = cljs.core.next.call(null,seq__104910);
var flake_SINGLEQUOTE___$1 = first__104911;
var r__$1 = seq__104910__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e104913){var e = e104913;
return null;
}})();
var map__104912 = cmd_map;
var map__104912__$1 = (((((!((map__104912 == null))))?(((((map__104912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__104912):map__104912);
var type = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__104912__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__104915 = r__$1;
var G__104916 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__104899__$1 = G__104915;
result_STAR___$1 = G__104916;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__104925 = blocks;
var vec__104926 = G__104925;
var seq__104927 = cljs.core.seq.call(null,vec__104926);
var first__104928 = cljs.core.first.call(null,seq__104927);
var seq__104927__$1 = cljs.core.next.call(null,seq__104927);
var block_SINGLEQUOTE_ = first__104928;
var r = seq__104927__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__104925__$1 = G__104925;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__104934 = G__104925__$1;
var seq__104935 = cljs.core.seq.call(null,vec__104934);
var first__104936 = cljs.core.first.call(null,seq__104935);
var seq__104935__$1 = cljs.core.next.call(null,seq__104935);
var block_SINGLEQUOTE___$1 = first__104936;
var r__$1 = seq__104935__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__104937 = block_SINGLEQUOTE___$1;
var map__104937__$1 = (((((!((map__104937 == null))))?(((((map__104937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__104937):map__104937);
var block = cljs.core.get.call(null,map__104937__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__104937__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__104937__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104917_SHARP_){
if(cljs.core._EQ_.call(null,p1__104917_SHARP_.p,(2))){
return p1__104917_SHARP_.o;
} else {
return null;
}
});})(G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104918_SHARP_){
if(cljs.core._EQ_.call(null,p1__104918_SHARP_.p,(1))){
return p1__104918_SHARP_.o;
} else {
return null;
}
});})(G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104919_SHARP_){
if(cljs.core._EQ_.call(null,p1__104919_SHARP_.p,(5))){
return p1__104919_SHARP_.o;
} else {
return null;
}
});})(G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,instant,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104920_SHARP_){
if(cljs.core._EQ_.call(null,p1__104920_SHARP_.p,(7))){
return p1__104920_SHARP_.o;
} else {
return null;
}
});})(G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,instant,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__104921_SHARP_){
return cljs.core._EQ_.call(null,p1__104921_SHARP_.p,(106));
});})(G__104925__$1,result_STAR___$1,map__104937,map__104937__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__104934,seq__104935,first__104936,seq__104935__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__104925,vec__104926,seq__104927,first__104928,seq__104927__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__104939 = r__$1;
var G__104940 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__104925__$1 = G__104939;
result_STAR___$1 = G__104940;
continue;
}
break;
}
});
