// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___127959 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128006){
var state_val_128007 = (state_128006[(1)]);
if((state_val_128007 === (7))){
var inst_127976 = (state_128006[(7)]);
var state_128006__$1 = state_128006;
var statearr_128008_128029 = state_128006__$1;
(statearr_128008_128029[(2)] = inst_127976);

(statearr_128008_128029[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (1))){
var state_128006__$1 = state_128006;
var statearr_128009_128030 = state_128006__$1;
(statearr_128009_128030[(2)] = null);

(statearr_128009_128030[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128006,(3),Error,null,(2));
var inst_127971 = cljs.core.seq.call(null,args);
var inst_127972 = cljs.core.first.call(null,inst_127971);
var inst_127973 = cljs.core.next.call(null,inst_127971);
var inst_127974 = cljs.core.PersistentVector.EMPTY;
var inst_127975 = args;
var inst_127976 = inst_127974;
var state_128006__$1 = (function (){var statearr_128010 = state_128006;
(statearr_128010[(8)] = inst_127973);

(statearr_128010[(9)] = inst_127972);

(statearr_128010[(7)] = inst_127976);

(statearr_128010[(10)] = inst_127975);

return statearr_128010;
})();
var statearr_128011_128031 = state_128006__$1;
(statearr_128011_128031[(2)] = null);

(statearr_128011_128031[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (13))){
var inst_127983 = (state_128006[(11)]);
var inst_127976 = (state_128006[(7)]);
var inst_127990 = (state_128006[(2)]);
var inst_127991 = fluree.db.util.async.throw_err.call(null,inst_127990);
var inst_127992 = cljs.core.conj.call(null,inst_127976,inst_127991);
var inst_127975 = inst_127983;
var inst_127976__$1 = inst_127992;
var state_128006__$1 = (function (){var statearr_128012 = state_128006;
(statearr_128012[(7)] = inst_127976__$1);

(statearr_128012[(10)] = inst_127975);

return statearr_128012;
})();
var statearr_128013_128032 = state_128006__$1;
(statearr_128013_128032[(2)] = null);

(statearr_128013_128032[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (6))){
var inst_128002 = (state_128006[(2)]);
var state_128006__$1 = state_128006;
var statearr_128014_128033 = state_128006__$1;
(statearr_128014_128033[(2)] = inst_128002);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128006__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (3))){
var inst_127960 = (state_128006[(2)]);
var state_128006__$1 = state_128006;
var statearr_128015_128034 = state_128006__$1;
(statearr_128015_128034[(2)] = inst_127960);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128006__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (12))){
var inst_127998 = (state_128006[(2)]);
var state_128006__$1 = state_128006;
var statearr_128016_128035 = state_128006__$1;
(statearr_128016_128035[(2)] = inst_127998);

(statearr_128016_128035[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (2))){
var inst_128004 = (state_128006[(2)]);
var state_128006__$1 = state_128006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128006__$1,inst_128004);
} else {
if((state_val_128007 === (11))){
var inst_127983 = (state_128006[(11)]);
var inst_127982 = (state_128006[(12)]);
var inst_127976 = (state_128006[(7)]);
var inst_127995 = cljs.core.conj.call(null,inst_127976,inst_127982);
var inst_127975 = inst_127983;
var inst_127976__$1 = inst_127995;
var state_128006__$1 = (function (){var statearr_128017 = state_128006;
(statearr_128017[(7)] = inst_127976__$1);

(statearr_128017[(10)] = inst_127975);

return statearr_128017;
})();
var statearr_128018_128036 = state_128006__$1;
(statearr_128018_128036[(2)] = null);

(statearr_128018_128036[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (9))){
var inst_128000 = (state_128006[(2)]);
var state_128006__$1 = state_128006;
var statearr_128019_128037 = state_128006__$1;
(statearr_128019_128037[(2)] = inst_128000);

(statearr_128019_128037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (5))){
var inst_127982 = (state_128006[(12)]);
var inst_127975 = (state_128006[(10)]);
var inst_127981 = cljs.core.seq.call(null,inst_127975);
var inst_127982__$1 = cljs.core.first.call(null,inst_127981);
var inst_127983 = cljs.core.next.call(null,inst_127981);
var inst_127984 = cljs.core.not.call(null,inst_127982__$1);
var state_128006__$1 = (function (){var statearr_128020 = state_128006;
(statearr_128020[(11)] = inst_127983);

(statearr_128020[(12)] = inst_127982__$1);

return statearr_128020;
})();
if(inst_127984){
var statearr_128021_128038 = state_128006__$1;
(statearr_128021_128038[(1)] = (7));

} else {
var statearr_128022_128039 = state_128006__$1;
(statearr_128022_128039[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128007 === (10))){
var inst_127982 = (state_128006[(12)]);
var state_128006__$1 = state_128006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128006__$1,(13),inst_127982);
} else {
if((state_val_128007 === (8))){
var inst_127982 = (state_128006[(12)]);
var inst_127987 = fluree.db.util.async.channel_QMARK_.call(null,inst_127982);
var state_128006__$1 = state_128006;
if(inst_127987){
var statearr_128023_128040 = state_128006__$1;
(statearr_128023_128040[(1)] = (10));

} else {
var statearr_128024_128041 = state_128006__$1;
(statearr_128024_128041[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____0 = (function (){
var statearr_128025 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_128025[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__);

(statearr_128025[(1)] = (1));

return statearr_128025;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____1 = (function (state_128006){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128026){if((e128026 instanceof Object)){
var ex__99978__auto__ = e128026;
var statearr_128027_128042 = state_128006;
(statearr_128027_128042[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128043 = state_128006;
state_128006 = G__128043;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__ = function(state_128006){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____1.call(this,state_128006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128028 = f__100070__auto__.call(null);
(statearr_128028[(6)] = c__100069__auto__);

return statearr_128028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__128044 = entry;
var res = cljs.core.nth.call(null,vec__128044,(0),null);
var cost = cljs.core.nth.call(null,vec__128044,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128089){
var state_val_128090 = (state_128089[(1)]);
if((state_val_128090 === (7))){
var inst_128058 = (state_128089[(7)]);
var inst_128058__$1 = (state_128089[(2)]);
var inst_128059 = cljs.core.set_QMARK_.call(null,inst_128058__$1);
var state_128089__$1 = (function (){var statearr_128091 = state_128089;
(statearr_128091[(7)] = inst_128058__$1);

return statearr_128091;
})();
if(inst_128059){
var statearr_128092_128113 = state_128089__$1;
(statearr_128092_128113[(1)] = (9));

} else {
var statearr_128093_128114 = state_128089__$1;
(statearr_128093_128114[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (1))){
var state_128089__$1 = state_128089;
var statearr_128094_128115 = state_128089__$1;
(statearr_128094_128115[(2)] = null);

(statearr_128094_128115[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128089,(3),Error,null,(2));
var inst_128051 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_128089__$1 = state_128089;
if(inst_128051){
var statearr_128095_128116 = state_128089__$1;
(statearr_128095_128116[(1)] = (5));

} else {
var statearr_128096_128117 = state_128089__$1;
(statearr_128096_128117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (15))){
var inst_128068 = (state_128089[(2)]);
var inst_128069 = fluree.db.util.async.throw_err.call(null,inst_128068);
var state_128089__$1 = state_128089;
var statearr_128097_128118 = state_128089__$1;
(statearr_128097_128118[(2)] = inst_128069);

(statearr_128097_128118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (13))){
var state_128089__$1 = state_128089;
var statearr_128098_128119 = state_128089__$1;
(statearr_128098_128119[(2)] = key);

(statearr_128098_128119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (6))){
var state_128089__$1 = state_128089;
var statearr_128099_128120 = state_128089__$1;
(statearr_128099_128120[(2)] = coll);

(statearr_128099_128120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (3))){
var inst_128047 = (state_128089[(2)]);
var state_128089__$1 = state_128089;
var statearr_128100_128121 = state_128089__$1;
(statearr_128100_128121[(2)] = inst_128047);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128089__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (12))){
var state_128089__$1 = state_128089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128089__$1,(15),key);
} else {
if((state_val_128090 === (2))){
var inst_128087 = (state_128089[(2)]);
var state_128089__$1 = state_128089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128089__$1,inst_128087);
} else {
if((state_val_128090 === (11))){
var inst_128064 = (state_128089[(2)]);
var inst_128065 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_128089__$1 = (function (){var statearr_128101 = state_128089;
(statearr_128101[(8)] = inst_128064);

return statearr_128101;
})();
if(inst_128065){
var statearr_128102_128122 = state_128089__$1;
(statearr_128102_128122[(1)] = (12));

} else {
var statearr_128103_128123 = state_128089__$1;
(statearr_128103_128123[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (9))){
var inst_128058 = (state_128089[(7)]);
var inst_128061 = cljs.core.vec.call(null,inst_128058);
var state_128089__$1 = state_128089;
var statearr_128104_128124 = state_128089__$1;
(statearr_128104_128124[(2)] = inst_128061);

(statearr_128104_128124[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (5))){
var state_128089__$1 = state_128089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128089__$1,(8),coll);
} else {
if((state_val_128090 === (14))){
var inst_128064 = (state_128089[(8)]);
var inst_128072 = (state_128089[(2)]);
var inst_128073 = fluree.db.dbfunctions.internal.nth.call(null,inst_128064,inst_128072);
var inst_128074 = cljs.core.count.call(null,inst_128064);
var inst_128075 = ((9) + inst_128074);
var inst_128076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128077 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128079 = [inst_128064,inst_128072];
var inst_128080 = (new cljs.core.PersistentVector(null,2,(5),inst_128078,inst_128079,null));
var inst_128081 = ["nth",inst_128080,inst_128073];
var inst_128082 = cljs.core.PersistentHashMap.fromArrays(inst_128077,inst_128081);
var inst_128083 = [inst_128082,inst_128075];
var inst_128084 = (new cljs.core.PersistentVector(null,2,(5),inst_128076,inst_128083,null));
var inst_128085 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128084);
var state_128089__$1 = (function (){var statearr_128105 = state_128089;
(statearr_128105[(9)] = inst_128085);

return statearr_128105;
})();
var statearr_128106_128125 = state_128089__$1;
(statearr_128106_128125[(2)] = inst_128073);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128089__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (10))){
var inst_128058 = (state_128089[(7)]);
var state_128089__$1 = state_128089;
var statearr_128107_128126 = state_128089__$1;
(statearr_128107_128126[(2)] = inst_128058);

(statearr_128107_128126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128090 === (8))){
var inst_128054 = (state_128089[(2)]);
var inst_128055 = fluree.db.util.async.throw_err.call(null,inst_128054);
var state_128089__$1 = state_128089;
var statearr_128108_128127 = state_128089__$1;
(statearr_128108_128127[(2)] = inst_128055);

(statearr_128108_128127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____0 = (function (){
var statearr_128109 = [null,null,null,null,null,null,null,null,null,null];
(statearr_128109[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__);

(statearr_128109[(1)] = (1));

return statearr_128109;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____1 = (function (state_128089){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128110){if((e128110 instanceof Object)){
var ex__99978__auto__ = e128110;
var statearr_128111_128128 = state_128089;
(statearr_128111_128128[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128129 = state_128089;
state_128089 = G__128129;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__ = function(state_128089){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____1.call(this,state_128089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128112 = f__100070__auto__.call(null);
(statearr_128112[(6)] = c__100069__auto__);

return statearr_128112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128187){
var state_val_128188 = (state_128187[(1)]);
if((state_val_128188 === (7))){
var inst_128144 = (state_128187[(7)]);
var inst_128144__$1 = (state_128187[(2)]);
var state_128187__$1 = (function (){var statearr_128189 = state_128187;
(statearr_128189[(7)] = inst_128144__$1);

return statearr_128189;
})();
if(cljs.core.truth_(inst_128144__$1)){
var statearr_128190_128216 = state_128187__$1;
(statearr_128190_128216[(1)] = (9));

} else {
var statearr_128191_128217 = state_128187__$1;
(statearr_128191_128217[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (1))){
var state_128187__$1 = state_128187;
var statearr_128192_128218 = state_128187__$1;
(statearr_128192_128218[(2)] = null);

(statearr_128192_128218[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128187,(3),Error,null,(2));
var inst_128137 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_128187__$1 = state_128187;
if(inst_128137){
var statearr_128193_128219 = state_128187__$1;
(statearr_128193_128219[(1)] = (5));

} else {
var statearr_128194_128220 = state_128187__$1;
(statearr_128194_128220[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (15))){
var inst_128150 = (state_128187[(2)]);
var inst_128151 = fluree.db.util.async.throw_err.call(null,inst_128150);
var state_128187__$1 = state_128187;
var statearr_128195_128221 = state_128187__$1;
(statearr_128195_128221[(2)] = inst_128151);

(statearr_128195_128221[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (13))){
var state_128187__$1 = state_128187;
var statearr_128196_128222 = state_128187__$1;
(statearr_128196_128222[(2)] = t);

(statearr_128196_128222[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (6))){
var state_128187__$1 = state_128187;
var statearr_128197_128223 = state_128187__$1;
(statearr_128197_128223[(2)] = test);

(statearr_128197_128223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (17))){
var state_128187__$1 = state_128187;
var statearr_128198_128224 = state_128187__$1;
(statearr_128198_128224[(2)] = f);

(statearr_128198_128224[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (3))){
var inst_128130 = (state_128187[(2)]);
var state_128187__$1 = state_128187;
var statearr_128199_128225 = state_128187__$1;
(statearr_128199_128225[(2)] = inst_128130);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (12))){
var state_128187__$1 = state_128187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128187__$1,(15),t);
} else {
if((state_val_128188 === (2))){
var inst_128185 = (state_128187[(2)]);
var state_128187__$1 = state_128187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128187__$1,inst_128185);
} else {
if((state_val_128188 === (19))){
var inst_128162 = (state_128187[(2)]);
var inst_128163 = fluree.db.util.async.throw_err.call(null,inst_128162);
var state_128187__$1 = state_128187;
var statearr_128200_128226 = state_128187__$1;
(statearr_128200_128226[(2)] = inst_128163);

(statearr_128200_128226[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (11))){
var inst_128144 = (state_128187[(7)]);
var inst_128170 = (state_128187[(2)]);
var inst_128171 = cljs.core.nth.call(null,inst_128170,(0),null);
var inst_128172 = cljs.core.nth.call(null,inst_128170,(1),null);
var inst_128173 = fluree.db.dbfunctions.internal.if_else.call(null,inst_128144,inst_128171,inst_128172);
var inst_128174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128175 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128177 = [inst_128144,inst_128171,inst_128172];
var inst_128178 = (new cljs.core.PersistentVector(null,3,(5),inst_128176,inst_128177,null));
var inst_128179 = ["if-else",inst_128178,inst_128173];
var inst_128180 = cljs.core.PersistentHashMap.fromArrays(inst_128175,inst_128179);
var inst_128181 = [inst_128180,(10)];
var inst_128182 = (new cljs.core.PersistentVector(null,2,(5),inst_128174,inst_128181,null));
var inst_128183 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128182);
var state_128187__$1 = (function (){var statearr_128201 = state_128187;
(statearr_128201[(8)] = inst_128183);

return statearr_128201;
})();
var statearr_128202_128227 = state_128187__$1;
(statearr_128202_128227[(2)] = inst_128173);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (9))){
var inst_128146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128147 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_128187__$1 = (function (){var statearr_128203 = state_128187;
(statearr_128203[(9)] = inst_128146);

return statearr_128203;
})();
if(inst_128147){
var statearr_128204_128228 = state_128187__$1;
(statearr_128204_128228[(1)] = (12));

} else {
var statearr_128205_128229 = state_128187__$1;
(statearr_128205_128229[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (5))){
var state_128187__$1 = state_128187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128187__$1,(8),test);
} else {
if((state_val_128188 === (14))){
var inst_128146 = (state_128187[(9)]);
var inst_128154 = (state_128187[(2)]);
var inst_128155 = [inst_128154,f];
var inst_128156 = (new cljs.core.PersistentVector(null,2,(5),inst_128146,inst_128155,null));
var state_128187__$1 = state_128187;
var statearr_128206_128230 = state_128187__$1;
(statearr_128206_128230[(2)] = inst_128156);

(statearr_128206_128230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (16))){
var state_128187__$1 = state_128187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128187__$1,(19),f);
} else {
if((state_val_128188 === (10))){
var inst_128158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128159 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_128187__$1 = (function (){var statearr_128207 = state_128187;
(statearr_128207[(10)] = inst_128158);

return statearr_128207;
})();
if(inst_128159){
var statearr_128208_128231 = state_128187__$1;
(statearr_128208_128231[(1)] = (16));

} else {
var statearr_128209_128232 = state_128187__$1;
(statearr_128209_128232[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (18))){
var inst_128158 = (state_128187[(10)]);
var inst_128166 = (state_128187[(2)]);
var inst_128167 = [f,inst_128166];
var inst_128168 = (new cljs.core.PersistentVector(null,2,(5),inst_128158,inst_128167,null));
var state_128187__$1 = state_128187;
var statearr_128210_128233 = state_128187__$1;
(statearr_128210_128233[(2)] = inst_128168);

(statearr_128210_128233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128188 === (8))){
var inst_128140 = (state_128187[(2)]);
var inst_128141 = fluree.db.util.async.throw_err.call(null,inst_128140);
var state_128187__$1 = state_128187;
var statearr_128211_128234 = state_128187__$1;
(statearr_128211_128234[(2)] = inst_128141);

(statearr_128211_128234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____0 = (function (){
var statearr_128212 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_128212[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__);

(statearr_128212[(1)] = (1));

return statearr_128212;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____1 = (function (state_128187){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128213){if((e128213 instanceof Object)){
var ex__99978__auto__ = e128213;
var statearr_128214_128235 = state_128187;
(statearr_128214_128235[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128213;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128236 = state_128187;
state_128187 = G__128236;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__ = function(state_128187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____1.call(this,state_128187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128215 = f__100070__auto__.call(null);
(statearr_128215[(6)] = c__100069__auto__);

return statearr_128215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128263){
var state_val_128264 = (state_128263[(1)]);
if((state_val_128264 === (1))){
var state_128263__$1 = state_128263;
var statearr_128265_128277 = state_128263__$1;
(statearr_128265_128277[(2)] = null);

(statearr_128265_128277[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128264 === (2))){
var inst_128261 = (state_128263[(2)]);
var state_128263__$1 = state_128263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128263__$1,inst_128261);
} else {
if((state_val_128264 === (3))){
var inst_128237 = (state_128263[(2)]);
var state_128263__$1 = state_128263;
var statearr_128266_128278 = state_128263__$1;
(statearr_128266_128278[(2)] = inst_128237);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128263__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128264 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128263,(3),Error,null,(2));
var inst_128241 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_128263__$1 = state_128263;
if(inst_128241){
var statearr_128267_128279 = state_128263__$1;
(statearr_128267_128279[(1)] = (5));

} else {
var statearr_128268_128280 = state_128263__$1;
(statearr_128268_128280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128264 === (5))){
var state_128263__$1 = state_128263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128263__$1,(8),arg);
} else {
if((state_val_128264 === (6))){
var state_128263__$1 = state_128263;
var statearr_128269_128281 = state_128263__$1;
(statearr_128269_128281[(2)] = arg);

(statearr_128269_128281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128264 === (7))){
var inst_128248 = (state_128263[(2)]);
var inst_128249 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_128248);
var inst_128250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128251 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128253 = [inst_128248];
var inst_128254 = (new cljs.core.PersistentVector(null,1,(5),inst_128252,inst_128253,null));
var inst_128255 = ["nil?",inst_128254,inst_128249];
var inst_128256 = cljs.core.PersistentHashMap.fromArrays(inst_128251,inst_128255);
var inst_128257 = [inst_128256,(10)];
var inst_128258 = (new cljs.core.PersistentVector(null,2,(5),inst_128250,inst_128257,null));
var inst_128259 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128258);
var state_128263__$1 = (function (){var statearr_128270 = state_128263;
(statearr_128270[(7)] = inst_128259);

return statearr_128270;
})();
var statearr_128271_128282 = state_128263__$1;
(statearr_128271_128282[(2)] = inst_128249);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128263__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128264 === (8))){
var inst_128244 = (state_128263[(2)]);
var inst_128245 = fluree.db.util.async.throw_err.call(null,inst_128244);
var state_128263__$1 = state_128263;
var statearr_128272_128283 = state_128263__$1;
(statearr_128272_128283[(2)] = inst_128245);

(statearr_128272_128283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_128273 = [null,null,null,null,null,null,null,null];
(statearr_128273[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__);

(statearr_128273[(1)] = (1));

return statearr_128273;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____1 = (function (state_128263){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128274){if((e128274 instanceof Object)){
var ex__99978__auto__ = e128274;
var statearr_128275_128284 = state_128263;
(statearr_128275_128284[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128274;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128285 = state_128263;
state_128263 = G__128285;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__ = function(state_128263){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____1.call(this,state_128263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128276 = f__100070__auto__.call(null);
(statearr_128276[(6)] = c__100069__auto__);

return statearr_128276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128312){
var state_val_128313 = (state_128312[(1)]);
if((state_val_128313 === (1))){
var state_128312__$1 = state_128312;
var statearr_128314_128326 = state_128312__$1;
(statearr_128314_128326[(2)] = null);

(statearr_128314_128326[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128313 === (2))){
var inst_128310 = (state_128312[(2)]);
var state_128312__$1 = state_128312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128312__$1,inst_128310);
} else {
if((state_val_128313 === (3))){
var inst_128286 = (state_128312[(2)]);
var state_128312__$1 = state_128312;
var statearr_128315_128327 = state_128312__$1;
(statearr_128315_128327[(2)] = inst_128286);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128312__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128313 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128312,(3),Error,null,(2));
var inst_128290 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_128312__$1 = state_128312;
if(inst_128290){
var statearr_128316_128328 = state_128312__$1;
(statearr_128316_128328[(1)] = (5));

} else {
var statearr_128317_128329 = state_128312__$1;
(statearr_128317_128329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128313 === (5))){
var state_128312__$1 = state_128312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128312__$1,(8),arg);
} else {
if((state_val_128313 === (6))){
var state_128312__$1 = state_128312;
var statearr_128318_128330 = state_128312__$1;
(statearr_128318_128330[(2)] = arg);

(statearr_128318_128330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128313 === (7))){
var inst_128297 = (state_128312[(2)]);
var inst_128298 = fluree.db.dbfunctions.internal.not.call(null,inst_128297);
var inst_128299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128300 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128302 = [inst_128297];
var inst_128303 = (new cljs.core.PersistentVector(null,1,(5),inst_128301,inst_128302,null));
var inst_128304 = ["not?",inst_128303,inst_128298];
var inst_128305 = cljs.core.PersistentHashMap.fromArrays(inst_128300,inst_128304);
var inst_128306 = [inst_128305,(10)];
var inst_128307 = (new cljs.core.PersistentVector(null,2,(5),inst_128299,inst_128306,null));
var inst_128308 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128307);
var state_128312__$1 = (function (){var statearr_128319 = state_128312;
(statearr_128319[(7)] = inst_128308);

return statearr_128319;
})();
var statearr_128320_128331 = state_128312__$1;
(statearr_128320_128331[(2)] = inst_128298);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128312__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128313 === (8))){
var inst_128293 = (state_128312[(2)]);
var inst_128294 = fluree.db.util.async.throw_err.call(null,inst_128293);
var state_128312__$1 = state_128312;
var statearr_128321_128332 = state_128312__$1;
(statearr_128321_128332[(2)] = inst_128294);

(statearr_128321_128332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____0 = (function (){
var statearr_128322 = [null,null,null,null,null,null,null,null];
(statearr_128322[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__);

(statearr_128322[(1)] = (1));

return statearr_128322;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____1 = (function (state_128312){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128323){if((e128323 instanceof Object)){
var ex__99978__auto__ = e128323;
var statearr_128324_128333 = state_128312;
(statearr_128324_128333[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128323;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128334 = state_128312;
state_128312 = G__128334;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__ = function(state_128312){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____1.call(this,state_128312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128325 = f__100070__auto__.call(null);
(statearr_128325[(6)] = c__100069__auto__);

return statearr_128325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128361){
var state_val_128362 = (state_128361[(1)]);
if((state_val_128362 === (1))){
var state_128361__$1 = state_128361;
var statearr_128363_128375 = state_128361__$1;
(statearr_128363_128375[(2)] = null);

(statearr_128363_128375[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128362 === (2))){
var inst_128359 = (state_128361[(2)]);
var state_128361__$1 = state_128361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128361__$1,inst_128359);
} else {
if((state_val_128362 === (3))){
var inst_128335 = (state_128361[(2)]);
var state_128361__$1 = state_128361;
var statearr_128364_128376 = state_128361__$1;
(statearr_128364_128376[(2)] = inst_128335);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128361__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128362 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128361,(3),Error,null,(2));
var inst_128339 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_128361__$1 = state_128361;
if(inst_128339){
var statearr_128365_128377 = state_128361__$1;
(statearr_128365_128377[(1)] = (5));

} else {
var statearr_128366_128378 = state_128361__$1;
(statearr_128366_128378[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128362 === (5))){
var state_128361__$1 = state_128361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128361__$1,(8),arg);
} else {
if((state_val_128362 === (6))){
var state_128361__$1 = state_128361;
var statearr_128367_128379 = state_128361__$1;
(statearr_128367_128379[(2)] = arg);

(statearr_128367_128379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128362 === (7))){
var inst_128346 = (state_128361[(2)]);
var inst_128347 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_128346);
var inst_128348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128349 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128351 = [inst_128346];
var inst_128352 = (new cljs.core.PersistentVector(null,1,(5),inst_128350,inst_128351,null));
var inst_128353 = ["empty?",inst_128352,inst_128347];
var inst_128354 = cljs.core.PersistentHashMap.fromArrays(inst_128349,inst_128353);
var inst_128355 = [inst_128354,(10)];
var inst_128356 = (new cljs.core.PersistentVector(null,2,(5),inst_128348,inst_128355,null));
var inst_128357 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128356);
var state_128361__$1 = (function (){var statearr_128368 = state_128361;
(statearr_128368[(7)] = inst_128357);

return statearr_128368;
})();
var statearr_128369_128380 = state_128361__$1;
(statearr_128369_128380[(2)] = inst_128347);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128361__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128362 === (8))){
var inst_128342 = (state_128361[(2)]);
var inst_128343 = fluree.db.util.async.throw_err.call(null,inst_128342);
var state_128361__$1 = state_128361;
var statearr_128370_128381 = state_128361__$1;
(statearr_128370_128381[(2)] = inst_128343);

(statearr_128370_128381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_128371 = [null,null,null,null,null,null,null,null];
(statearr_128371[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__);

(statearr_128371[(1)] = (1));

return statearr_128371;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____1 = (function (state_128361){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128372){if((e128372 instanceof Object)){
var ex__99978__auto__ = e128372;
var statearr_128373_128382 = state_128361;
(statearr_128373_128382[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128372;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128383 = state_128361;
state_128361 = G__128383;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__ = function(state_128361){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____1.call(this,state_128361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128374 = f__100070__auto__.call(null);
(statearr_128374[(6)] = c__100069__auto__);

return statearr_128374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___128418 = arguments.length;
var i__4737__auto___128419 = (0);
while(true){
if((i__4737__auto___128419 < len__4736__auto___128418)){
args__4742__auto__.push((arguments[i__4737__auto___128419]));

var G__128420 = (i__4737__auto___128419 + (1));
i__4737__auto___128419 = G__128420;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128408){
var state_val_128409 = (state_128408[(1)]);
if((state_val_128409 === (1))){
var state_128408__$1 = state_128408;
var statearr_128410_128421 = state_128408__$1;
(statearr_128410_128421[(2)] = null);

(statearr_128410_128421[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128409 === (2))){
var inst_128406 = (state_128408[(2)]);
var state_128408__$1 = state_128408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128408__$1,inst_128406);
} else {
if((state_val_128409 === (3))){
var inst_128386 = (state_128408[(2)]);
var state_128408__$1 = state_128408;
var statearr_128411_128422 = state_128408__$1;
(statearr_128411_128422[(2)] = inst_128386);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128408__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128409 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128408,(3),Error,null,(2));
var inst_128390 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_128408__$1 = state_128408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128408__$1,(5),inst_128390);
} else {
if((state_val_128409 === (5))){
var inst_128392 = (state_128408[(2)]);
var inst_128393 = fluree.db.util.async.throw_err.call(null,inst_128392);
var inst_128394 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_128393);
var inst_128395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128396 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128398 = [inst_128393];
var inst_128399 = (new cljs.core.PersistentVector(null,1,(5),inst_128397,inst_128398,null));
var inst_128400 = ["str",inst_128399,inst_128394];
var inst_128401 = cljs.core.PersistentHashMap.fromArrays(inst_128396,inst_128400);
var inst_128402 = [inst_128401,(10)];
var inst_128403 = (new cljs.core.PersistentVector(null,2,(5),inst_128395,inst_128402,null));
var inst_128404 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128403);
var state_128408__$1 = (function (){var statearr_128412 = state_128408;
(statearr_128412[(7)] = inst_128404);

return statearr_128412;
})();
var statearr_128413_128423 = state_128408__$1;
(statearr_128413_128423[(2)] = inst_128394);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128408__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_128414 = [null,null,null,null,null,null,null,null];
(statearr_128414[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_128414[(1)] = (1));

return statearr_128414;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_128408){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128415){if((e128415 instanceof Object)){
var ex__99978__auto__ = e128415;
var statearr_128416_128424 = state_128408;
(statearr_128416_128424[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128408);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128415;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128425 = state_128408;
state_128408 = G__128425;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_128408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_128408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128417 = f__100070__auto__.call(null);
(statearr_128417[(6)] = c__100069__auto__);

return statearr_128417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq128384){
var G__128385 = cljs.core.first.call(null,seq128384);
var seq128384__$1 = cljs.core.next.call(null,seq128384);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128385,seq128384__$1);
}));

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128452){
var state_val_128453 = (state_128452[(1)]);
if((state_val_128453 === (1))){
var state_128452__$1 = state_128452;
var statearr_128454_128466 = state_128452__$1;
(statearr_128454_128466[(2)] = null);

(statearr_128454_128466[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128453 === (2))){
var inst_128450 = (state_128452[(2)]);
var state_128452__$1 = state_128452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128452__$1,inst_128450);
} else {
if((state_val_128453 === (3))){
var inst_128426 = (state_128452[(2)]);
var state_128452__$1 = state_128452;
var statearr_128455_128467 = state_128452__$1;
(statearr_128455_128467[(2)] = inst_128426);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128452__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128453 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128452,(3),Error,null,(2));
var inst_128430 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_128452__$1 = state_128452;
if(inst_128430){
var statearr_128456_128468 = state_128452__$1;
(statearr_128456_128468[(1)] = (5));

} else {
var statearr_128457_128469 = state_128452__$1;
(statearr_128457_128469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128453 === (5))){
var state_128452__$1 = state_128452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128452__$1,(8),str);
} else {
if((state_val_128453 === (6))){
var state_128452__$1 = state_128452;
var statearr_128458_128470 = state_128452__$1;
(statearr_128458_128470[(2)] = str);

(statearr_128458_128470[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128453 === (7))){
var inst_128437 = (state_128452[(2)]);
var inst_128438 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_128437);
var inst_128439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128440 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128442 = [inst_128437];
var inst_128443 = (new cljs.core.PersistentVector(null,1,(5),inst_128441,inst_128442,null));
var inst_128444 = ["lower-case",inst_128443,inst_128438];
var inst_128445 = cljs.core.PersistentHashMap.fromArrays(inst_128440,inst_128444);
var inst_128446 = [inst_128445,(10)];
var inst_128447 = (new cljs.core.PersistentVector(null,2,(5),inst_128439,inst_128446,null));
var inst_128448 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128447);
var state_128452__$1 = (function (){var statearr_128459 = state_128452;
(statearr_128459[(7)] = inst_128448);

return statearr_128459;
})();
var statearr_128460_128471 = state_128452__$1;
(statearr_128460_128471[(2)] = inst_128438);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128452__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128453 === (8))){
var inst_128433 = (state_128452[(2)]);
var inst_128434 = fluree.db.util.async.throw_err.call(null,inst_128433);
var state_128452__$1 = state_128452;
var statearr_128461_128472 = state_128452__$1;
(statearr_128461_128472[(2)] = inst_128434);

(statearr_128461_128472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____0 = (function (){
var statearr_128462 = [null,null,null,null,null,null,null,null];
(statearr_128462[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__);

(statearr_128462[(1)] = (1));

return statearr_128462;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____1 = (function (state_128452){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128463){if((e128463 instanceof Object)){
var ex__99978__auto__ = e128463;
var statearr_128464_128473 = state_128452;
(statearr_128464_128473[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128463;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128474 = state_128452;
state_128452 = G__128474;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__ = function(state_128452){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____1.call(this,state_128452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128465 = f__100070__auto__.call(null);
(statearr_128465[(6)] = c__100069__auto__);

return statearr_128465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128501){
var state_val_128502 = (state_128501[(1)]);
if((state_val_128502 === (1))){
var state_128501__$1 = state_128501;
var statearr_128503_128515 = state_128501__$1;
(statearr_128503_128515[(2)] = null);

(statearr_128503_128515[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128502 === (2))){
var inst_128499 = (state_128501[(2)]);
var state_128501__$1 = state_128501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128501__$1,inst_128499);
} else {
if((state_val_128502 === (3))){
var inst_128475 = (state_128501[(2)]);
var state_128501__$1 = state_128501;
var statearr_128504_128516 = state_128501__$1;
(statearr_128504_128516[(2)] = inst_128475);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128501__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128502 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128501,(3),Error,null,(2));
var inst_128479 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_128501__$1 = state_128501;
if(inst_128479){
var statearr_128505_128517 = state_128501__$1;
(statearr_128505_128517[(1)] = (5));

} else {
var statearr_128506_128518 = state_128501__$1;
(statearr_128506_128518[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128502 === (5))){
var state_128501__$1 = state_128501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128501__$1,(8),str);
} else {
if((state_val_128502 === (6))){
var state_128501__$1 = state_128501;
var statearr_128507_128519 = state_128501__$1;
(statearr_128507_128519[(2)] = str);

(statearr_128507_128519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128502 === (7))){
var inst_128486 = (state_128501[(2)]);
var inst_128487 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_128486);
var inst_128488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128489 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128491 = [inst_128486];
var inst_128492 = (new cljs.core.PersistentVector(null,1,(5),inst_128490,inst_128491,null));
var inst_128493 = ["upper-case",inst_128492,inst_128487];
var inst_128494 = cljs.core.PersistentHashMap.fromArrays(inst_128489,inst_128493);
var inst_128495 = [inst_128494,(10)];
var inst_128496 = (new cljs.core.PersistentVector(null,2,(5),inst_128488,inst_128495,null));
var inst_128497 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128496);
var state_128501__$1 = (function (){var statearr_128508 = state_128501;
(statearr_128508[(7)] = inst_128497);

return statearr_128508;
})();
var statearr_128509_128520 = state_128501__$1;
(statearr_128509_128520[(2)] = inst_128487);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128501__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128502 === (8))){
var inst_128482 = (state_128501[(2)]);
var inst_128483 = fluree.db.util.async.throw_err.call(null,inst_128482);
var state_128501__$1 = state_128501;
var statearr_128510_128521 = state_128501__$1;
(statearr_128510_128521[(2)] = inst_128483);

(statearr_128510_128521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____0 = (function (){
var statearr_128511 = [null,null,null,null,null,null,null,null];
(statearr_128511[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__);

(statearr_128511[(1)] = (1));

return statearr_128511;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____1 = (function (state_128501){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128512){if((e128512 instanceof Object)){
var ex__99978__auto__ = e128512;
var statearr_128513_128522 = state_128501;
(statearr_128513_128522[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128523 = state_128501;
state_128501 = G__128523;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__ = function(state_128501){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____1.call(this,state_128501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128514 = f__100070__auto__.call(null);
(statearr_128514[(6)] = c__100069__auto__);

return statearr_128514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__128525 = arguments.length;
switch (G__128525) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128550){
var state_val_128551 = (state_128550[(1)]);
if((state_val_128551 === (1))){
var state_128550__$1 = state_128550;
var statearr_128552_128561 = state_128550__$1;
(statearr_128552_128561[(2)] = null);

(statearr_128552_128561[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128551 === (2))){
var inst_128548 = (state_128550[(2)]);
var state_128550__$1 = state_128550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128550__$1,inst_128548);
} else {
if((state_val_128551 === (3))){
var inst_128526 = (state_128550[(2)]);
var state_128550__$1 = state_128550;
var statearr_128553_128562 = state_128550__$1;
(statearr_128553_128562[(2)] = inst_128526);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128550__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128551 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128550,(3),Error,null,(2));
var inst_128533 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_128550__$1 = state_128550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128550__$1,(5),inst_128533);
} else {
if((state_val_128551 === (5))){
var inst_128535 = (state_128550[(2)]);
var inst_128536 = fluree.db.util.async.throw_err.call(null,inst_128535);
var inst_128537 = cljs.core.nth.call(null,inst_128536,(0),null);
var inst_128538 = cljs.core.nth.call(null,inst_128536,(1),null);
var inst_128539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128540 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128541 = ["?s","?ctx",inst_128537];
var inst_128542 = cljs.core.PersistentHashMap.fromArrays(inst_128540,inst_128541);
var inst_128543 = ((10) + inst_128538);
var inst_128544 = [inst_128542,inst_128543];
var inst_128545 = (new cljs.core.PersistentVector(null,2,(5),inst_128539,inst_128544,null));
var inst_128546 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128545);
var state_128550__$1 = (function (){var statearr_128554 = state_128550;
(statearr_128554[(7)] = inst_128546);

return statearr_128554;
})();
var statearr_128555_128563 = state_128550__$1;
(statearr_128555_128563[(2)] = inst_128537);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128550__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_128556 = [null,null,null,null,null,null,null,null];
(statearr_128556[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_128556[(1)] = (1));

return statearr_128556;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_128550){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128557){if((e128557 instanceof Object)){
var ex__99978__auto__ = e128557;
var statearr_128558_128564 = state_128550;
(statearr_128558_128564[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128557;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128565 = state_128550;
state_128550 = G__128565;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_128550){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_128550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128559 = f__100070__auto__.call(null);
(statearr_128559[(6)] = c__100069__auto__);

return statearr_128559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__128567 = arguments.length;
switch (G__128567) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128602){
var state_val_128603 = (state_128602[(1)]);
if((state_val_128603 === (7))){
var inst_128598 = (state_128602[(2)]);
var state_128602__$1 = state_128602;
var statearr_128604_128617 = state_128602__$1;
(statearr_128604_128617[(2)] = inst_128598);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128602__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128603 === (1))){
var state_128602__$1 = state_128602;
var statearr_128605_128618 = state_128602__$1;
(statearr_128605_128618[(2)] = null);

(statearr_128605_128618[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128603 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128602,(3),Error,null,(2));
var inst_128572 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128602__$1 = state_128602;
if(cljs.core.truth_(inst_128572)){
var statearr_128606_128619 = state_128602__$1;
(statearr_128606_128619[(1)] = (5));

} else {
var statearr_128607_128620 = state_128602__$1;
(statearr_128607_128620[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128603 === (6))){
var inst_128596 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_128602__$1 = state_128602;
var statearr_128608_128621 = state_128602__$1;
(statearr_128608_128621[(2)] = inst_128596);

(statearr_128608_128621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128603 === (3))){
var inst_128568 = (state_128602[(2)]);
var state_128602__$1 = state_128602;
var statearr_128609_128622 = state_128602__$1;
(statearr_128609_128622[(2)] = inst_128568);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128602__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128603 === (2))){
var inst_128600 = (state_128602[(2)]);
var state_128602__$1 = state_128602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128602__$1,inst_128600);
} else {
if((state_val_128603 === (9))){
var inst_128579 = (state_128602[(2)]);
var inst_128580 = fluree.db.util.async.throw_err.call(null,inst_128579);
var inst_128581 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_128580);
var state_128602__$1 = state_128602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128602__$1,(8),inst_128581);
} else {
if((state_val_128603 === (5))){
var inst_128577 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_128602__$1 = state_128602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128602__$1,(9),inst_128577);
} else {
if((state_val_128603 === (8))){
var inst_128583 = (state_128602[(2)]);
var inst_128584 = fluree.db.util.async.throw_err.call(null,inst_128583);
var inst_128585 = cljs.core.nth.call(null,inst_128584,(0),null);
var inst_128586 = cljs.core.nth.call(null,inst_128584,(1),null);
var inst_128587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128588 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128589 = ["?p","?ctx",inst_128585];
var inst_128590 = cljs.core.PersistentHashMap.fromArrays(inst_128588,inst_128589);
var inst_128591 = ((10) + inst_128586);
var inst_128592 = [inst_128590,inst_128591];
var inst_128593 = (new cljs.core.PersistentVector(null,2,(5),inst_128587,inst_128592,null));
var inst_128594 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128593);
var state_128602__$1 = (function (){var statearr_128610 = state_128602;
(statearr_128610[(7)] = inst_128594);

return statearr_128610;
})();
var statearr_128611_128623 = state_128602__$1;
(statearr_128611_128623[(2)] = inst_128585);

(statearr_128611_128623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_128612 = [null,null,null,null,null,null,null,null];
(statearr_128612[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_128612[(1)] = (1));

return statearr_128612;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_128602){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128613){if((e128613 instanceof Object)){
var ex__99978__auto__ = e128613;
var statearr_128614_128624 = state_128602;
(statearr_128614_128624[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128613;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128625 = state_128602;
state_128602 = G__128625;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_128602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_128602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128615 = f__100070__auto__.call(null);
(statearr_128615[(6)] = c__100069__auto__);

return statearr_128615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___128664 = arguments.length;
var i__4737__auto___128665 = (0);
while(true){
if((i__4737__auto___128665 < len__4736__auto___128664)){
args__4742__auto__.push((arguments[i__4737__auto___128665]));

var G__128666 = (i__4737__auto___128665 + (1));
i__4737__auto___128665 = G__128666;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128654){
var state_val_128655 = (state_128654[(1)]);
if((state_val_128655 === (1))){
var state_128654__$1 = state_128654;
var statearr_128656_128667 = state_128654__$1;
(statearr_128656_128667[(2)] = null);

(statearr_128656_128667[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128655 === (2))){
var inst_128652 = (state_128654[(2)]);
var state_128654__$1 = state_128654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128654__$1,inst_128652);
} else {
if((state_val_128655 === (3))){
var inst_128628 = (state_128654[(2)]);
var state_128654__$1 = state_128654;
var statearr_128657_128668 = state_128654__$1;
(statearr_128657_128668[(2)] = inst_128628);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128654__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128655 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128654,(3),Error,null,(2));
var inst_128632 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_128654__$1 = state_128654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128654__$1,(5),inst_128632);
} else {
if((state_val_128655 === (5))){
var inst_128634 = (state_128654[(2)]);
var inst_128635 = fluree.db.util.async.throw_err.call(null,inst_128634);
var inst_128636 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_128635);
var inst_128637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128638 = [inst_128635];
var inst_128639 = (new cljs.core.PersistentVector(null,1,(5),inst_128637,inst_128638,null));
var inst_128640 = cljs.core.count.call(null,inst_128639);
var inst_128641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128644 = [inst_128635];
var inst_128645 = (new cljs.core.PersistentVector(null,1,(5),inst_128643,inst_128644,null));
var inst_128646 = ["and",inst_128645,inst_128636];
var inst_128647 = cljs.core.PersistentHashMap.fromArrays(inst_128642,inst_128646);
var inst_128648 = [inst_128647,inst_128640];
var inst_128649 = (new cljs.core.PersistentVector(null,2,(5),inst_128641,inst_128648,null));
var inst_128650 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128649);
var state_128654__$1 = (function (){var statearr_128658 = state_128654;
(statearr_128658[(7)] = inst_128650);

return statearr_128658;
})();
var statearr_128659_128669 = state_128654__$1;
(statearr_128659_128669[(2)] = inst_128636);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128654__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_128660 = [null,null,null,null,null,null,null,null];
(statearr_128660[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_128660[(1)] = (1));

return statearr_128660;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_128654){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128661){if((e128661 instanceof Object)){
var ex__99978__auto__ = e128661;
var statearr_128662_128670 = state_128654;
(statearr_128662_128670[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128654);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128661;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128671 = state_128654;
state_128654 = G__128671;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_128654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_128654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128663 = f__100070__auto__.call(null);
(statearr_128663[(6)] = c__100069__auto__);

return statearr_128663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq128626){
var G__128627 = cljs.core.first.call(null,seq128626);
var seq128626__$1 = cljs.core.next.call(null,seq128626);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128627,seq128626__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___128710 = arguments.length;
var i__4737__auto___128711 = (0);
while(true){
if((i__4737__auto___128711 < len__4736__auto___128710)){
args__4742__auto__.push((arguments[i__4737__auto___128711]));

var G__128712 = (i__4737__auto___128711 + (1));
i__4737__auto___128711 = G__128712;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128700){
var state_val_128701 = (state_128700[(1)]);
if((state_val_128701 === (1))){
var state_128700__$1 = state_128700;
var statearr_128702_128713 = state_128700__$1;
(statearr_128702_128713[(2)] = null);

(statearr_128702_128713[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128701 === (2))){
var inst_128698 = (state_128700[(2)]);
var state_128700__$1 = state_128700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128700__$1,inst_128698);
} else {
if((state_val_128701 === (3))){
var inst_128674 = (state_128700[(2)]);
var state_128700__$1 = state_128700;
var statearr_128703_128714 = state_128700__$1;
(statearr_128703_128714[(2)] = inst_128674);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128700__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128701 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128700,(3),Error,null,(2));
var inst_128678 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_128700__$1 = state_128700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128700__$1,(5),inst_128678);
} else {
if((state_val_128701 === (5))){
var inst_128680 = (state_128700[(2)]);
var inst_128681 = fluree.db.util.async.throw_err.call(null,inst_128680);
var inst_128682 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_128681);
var inst_128683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128684 = [inst_128681];
var inst_128685 = (new cljs.core.PersistentVector(null,1,(5),inst_128683,inst_128684,null));
var inst_128686 = cljs.core.count.call(null,inst_128685);
var inst_128687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128688 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128690 = [inst_128681];
var inst_128691 = (new cljs.core.PersistentVector(null,1,(5),inst_128689,inst_128690,null));
var inst_128692 = ["or",inst_128691,inst_128682];
var inst_128693 = cljs.core.PersistentHashMap.fromArrays(inst_128688,inst_128692);
var inst_128694 = [inst_128693,inst_128686];
var inst_128695 = (new cljs.core.PersistentVector(null,2,(5),inst_128687,inst_128694,null));
var inst_128696 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128695);
var state_128700__$1 = (function (){var statearr_128704 = state_128700;
(statearr_128704[(7)] = inst_128696);

return statearr_128704;
})();
var statearr_128705_128715 = state_128700__$1;
(statearr_128705_128715[(2)] = inst_128682);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128700__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_128706 = [null,null,null,null,null,null,null,null];
(statearr_128706[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_128706[(1)] = (1));

return statearr_128706;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_128700){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128707){if((e128707 instanceof Object)){
var ex__99978__auto__ = e128707;
var statearr_128708_128716 = state_128700;
(statearr_128708_128716[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128700);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128707;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128717 = state_128700;
state_128700 = G__128717;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_128700){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_128700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128709 = f__100070__auto__.call(null);
(statearr_128709[(6)] = c__100069__auto__);

return statearr_128709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq128672){
var G__128673 = cljs.core.first.call(null,seq128672);
var seq128672__$1 = cljs.core.next.call(null,seq128672);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__128673,seq128672__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128752){
var state_val_128753 = (state_128752[(1)]);
if((state_val_128753 === (7))){
var inst_128738 = (state_128752[(2)]);
var inst_128739 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_128738);
var inst_128740 = cljs.core.count.call(null,inst_128739);
var inst_128741 = ((9) + inst_128740);
var inst_128742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128743 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128744 = ["count",inst_128738,inst_128740];
var inst_128745 = cljs.core.PersistentHashMap.fromArrays(inst_128743,inst_128744);
var inst_128746 = [inst_128745,inst_128741];
var inst_128747 = (new cljs.core.PersistentVector(null,2,(5),inst_128742,inst_128746,null));
var inst_128748 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128747);
var state_128752__$1 = (function (){var statearr_128754 = state_128752;
(statearr_128754[(7)] = inst_128748);

return statearr_128754;
})();
var statearr_128755_128770 = state_128752__$1;
(statearr_128755_128770[(2)] = inst_128740);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128752__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (1))){
var state_128752__$1 = state_128752;
var statearr_128756_128771 = state_128752__$1;
(statearr_128756_128771[(2)] = null);

(statearr_128756_128771[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128752,(3),Error,null,(2));
var inst_128722 = cljs.core.vector_QMARK_.call(null,coll);
var state_128752__$1 = state_128752;
if(inst_128722){
var statearr_128757_128772 = state_128752__$1;
(statearr_128757_128772[(1)] = (5));

} else {
var statearr_128758_128773 = state_128752__$1;
(statearr_128758_128773[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (6))){
var inst_128729 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_128752__$1 = state_128752;
if(inst_128729){
var statearr_128759_128774 = state_128752__$1;
(statearr_128759_128774[(1)] = (9));

} else {
var statearr_128760_128775 = state_128752__$1;
(statearr_128760_128775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (3))){
var inst_128718 = (state_128752[(2)]);
var state_128752__$1 = state_128752;
var statearr_128761_128776 = state_128752__$1;
(statearr_128761_128776[(2)] = inst_128718);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128752__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (12))){
var inst_128732 = (state_128752[(2)]);
var inst_128733 = fluree.db.util.async.throw_err.call(null,inst_128732);
var state_128752__$1 = state_128752;
var statearr_128762_128777 = state_128752__$1;
(statearr_128762_128777[(2)] = inst_128733);

(statearr_128762_128777[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (2))){
var inst_128750 = (state_128752[(2)]);
var state_128752__$1 = state_128752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128752__$1,inst_128750);
} else {
if((state_val_128753 === (11))){
var inst_128736 = (state_128752[(2)]);
var state_128752__$1 = state_128752;
var statearr_128763_128778 = state_128752__$1;
(statearr_128763_128778[(2)] = inst_128736);

(statearr_128763_128778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (9))){
var state_128752__$1 = state_128752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128752__$1,(12),coll);
} else {
if((state_val_128753 === (5))){
var inst_128724 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_128752__$1 = state_128752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128752__$1,(8),inst_128724);
} else {
if((state_val_128753 === (10))){
var state_128752__$1 = state_128752;
var statearr_128764_128779 = state_128752__$1;
(statearr_128764_128779[(2)] = coll);

(statearr_128764_128779[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128753 === (8))){
var inst_128726 = (state_128752[(2)]);
var inst_128727 = fluree.db.util.async.throw_err.call(null,inst_128726);
var state_128752__$1 = state_128752;
var statearr_128765_128780 = state_128752__$1;
(statearr_128765_128780[(2)] = inst_128727);

(statearr_128765_128780[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____0 = (function (){
var statearr_128766 = [null,null,null,null,null,null,null,null];
(statearr_128766[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__);

(statearr_128766[(1)] = (1));

return statearr_128766;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____1 = (function (state_128752){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128767){if((e128767 instanceof Object)){
var ex__99978__auto__ = e128767;
var statearr_128768_128781 = state_128752;
(statearr_128768_128781[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128767;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128782 = state_128752;
state_128752 = G__128782;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__ = function(state_128752){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____1.call(this,state_128752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128769 = f__100070__auto__.call(null);
(statearr_128769[(6)] = c__100069__auto__);

return statearr_128769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128829){
var state_val_128830 = (state_128829[(1)]);
if((state_val_128830 === (7))){
var inst_128794 = (state_128829[(2)]);
var inst_128795 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_128829__$1 = (function (){var statearr_128831 = state_128829;
(statearr_128831[(7)] = inst_128794);

return statearr_128831;
})();
if(inst_128795){
var statearr_128832_128857 = state_128829__$1;
(statearr_128832_128857[(1)] = (9));

} else {
var statearr_128833_128858 = state_128829__$1;
(statearr_128833_128858[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (1))){
var state_128829__$1 = state_128829;
var statearr_128834_128859 = state_128829__$1;
(statearr_128834_128859[(2)] = null);

(statearr_128834_128859[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128829,(3),Error,null,(2));
var inst_128787 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_128829__$1 = state_128829;
if(inst_128787){
var statearr_128835_128860 = state_128829__$1;
(statearr_128835_128860[(1)] = (5));

} else {
var statearr_128836_128861 = state_128829__$1;
(statearr_128836_128861[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (15))){
var inst_128794 = (state_128829[(7)]);
var inst_128802 = (state_128829[(8)]);
var inst_128814 = (state_128829[(2)]);
var inst_128815 = fluree.db.dbfunctions.internal.get.call(null,inst_128814,inst_128802);
var inst_128816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128817 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128819 = [inst_128794,inst_128802];
var inst_128820 = (new cljs.core.PersistentVector(null,2,(5),inst_128818,inst_128819,null));
var inst_128821 = ["get",inst_128820,inst_128815];
var inst_128822 = cljs.core.PersistentHashMap.fromArrays(inst_128817,inst_128821);
var inst_128823 = [inst_128822,(10)];
var inst_128824 = (new cljs.core.PersistentVector(null,2,(5),inst_128816,inst_128823,null));
var inst_128825 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128824);
var state_128829__$1 = (function (){var statearr_128837 = state_128829;
(statearr_128837[(9)] = inst_128825);

return statearr_128837;
})();
var statearr_128838_128862 = state_128829__$1;
(statearr_128838_128862[(2)] = inst_128815);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128829__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (13))){
var inst_128794 = (state_128829[(7)]);
var inst_128805 = cljs.core.count.call(null,inst_128794);
var inst_128806 = cljs.core._EQ_.call(null,(1),inst_128805);
var state_128829__$1 = state_128829;
if(inst_128806){
var statearr_128839_128863 = state_128829__$1;
(statearr_128839_128863[(1)] = (16));

} else {
var statearr_128840_128864 = state_128829__$1;
(statearr_128840_128864[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (6))){
var state_128829__$1 = state_128829;
var statearr_128841_128865 = state_128829__$1;
(statearr_128841_128865[(2)] = subject);

(statearr_128841_128865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (17))){
var inst_128794 = (state_128829[(7)]);
var state_128829__$1 = state_128829;
var statearr_128842_128866 = state_128829__$1;
(statearr_128842_128866[(2)] = inst_128794);

(statearr_128842_128866[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (3))){
var inst_128783 = (state_128829[(2)]);
var state_128829__$1 = state_128829;
var statearr_128843_128867 = state_128829__$1;
(statearr_128843_128867[(2)] = inst_128783);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128829__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (12))){
var inst_128798 = (state_128829[(2)]);
var inst_128799 = fluree.db.util.async.throw_err.call(null,inst_128798);
var state_128829__$1 = state_128829;
var statearr_128844_128868 = state_128829__$1;
(statearr_128844_128868[(2)] = inst_128799);

(statearr_128844_128868[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (2))){
var inst_128827 = (state_128829[(2)]);
var state_128829__$1 = state_128829;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128829__$1,inst_128827);
} else {
if((state_val_128830 === (11))){
var inst_128794 = (state_128829[(7)]);
var inst_128802 = (state_128829[(2)]);
var inst_128803 = cljs.core.vector_QMARK_.call(null,inst_128794);
var state_128829__$1 = (function (){var statearr_128845 = state_128829;
(statearr_128845[(8)] = inst_128802);

return statearr_128845;
})();
if(inst_128803){
var statearr_128846_128869 = state_128829__$1;
(statearr_128846_128869[(1)] = (13));

} else {
var statearr_128847_128870 = state_128829__$1;
(statearr_128847_128870[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (9))){
var state_128829__$1 = state_128829;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128829__$1,(12),pred);
} else {
if((state_val_128830 === (5))){
var state_128829__$1 = state_128829;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128829__$1,(8),subject);
} else {
if((state_val_128830 === (14))){
var inst_128794 = (state_128829[(7)]);
var state_128829__$1 = state_128829;
var statearr_128848_128871 = state_128829__$1;
(statearr_128848_128871[(2)] = inst_128794);

(statearr_128848_128871[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (16))){
var inst_128794 = (state_128829[(7)]);
var inst_128808 = cljs.core.first.call(null,inst_128794);
var state_128829__$1 = state_128829;
var statearr_128849_128872 = state_128829__$1;
(statearr_128849_128872[(2)] = inst_128808);

(statearr_128849_128872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (10))){
var state_128829__$1 = state_128829;
var statearr_128850_128873 = state_128829__$1;
(statearr_128850_128873[(2)] = pred);

(statearr_128850_128873[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (18))){
var inst_128811 = (state_128829[(2)]);
var state_128829__$1 = state_128829;
var statearr_128851_128874 = state_128829__$1;
(statearr_128851_128874[(2)] = inst_128811);

(statearr_128851_128874[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128830 === (8))){
var inst_128790 = (state_128829[(2)]);
var inst_128791 = fluree.db.util.async.throw_err.call(null,inst_128790);
var state_128829__$1 = state_128829;
var statearr_128852_128875 = state_128829__$1;
(statearr_128852_128875[(2)] = inst_128791);

(statearr_128852_128875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____0 = (function (){
var statearr_128853 = [null,null,null,null,null,null,null,null,null,null];
(statearr_128853[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__);

(statearr_128853[(1)] = (1));

return statearr_128853;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____1 = (function (state_128829){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128829);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128854){if((e128854 instanceof Object)){
var ex__99978__auto__ = e128854;
var statearr_128855_128876 = state_128829;
(statearr_128855_128876[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128829);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128854;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128877 = state_128829;
state_128829 = G__128877;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__ = function(state_128829){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____1.call(this,state_128829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128856 = f__100070__auto__.call(null);
(statearr_128856[(6)] = c__100069__auto__);

return statearr_128856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128913){
var state_val_128914 = (state_128913[(1)]);
if((state_val_128914 === (7))){
var inst_128887 = (state_128913[(2)]);
var state_128913__$1 = state_128913;
if(cljs.core.truth_(inst_128887)){
var statearr_128915_128932 = state_128913__$1;
(statearr_128915_128932[(1)] = (8));

} else {
var statearr_128916_128933 = state_128913__$1;
(statearr_128916_128933[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (1))){
var state_128913__$1 = state_128913;
var statearr_128917_128934 = state_128913__$1;
(statearr_128917_128934[(2)] = null);

(statearr_128917_128934[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (4))){
var inst_128882 = (state_128913[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128913,(3),Error,null,(2));
var inst_128882__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128913__$1 = (function (){var statearr_128918 = state_128913;
(statearr_128918[(7)] = inst_128882__$1);

return statearr_128918;
})();
if(cljs.core.truth_(inst_128882__$1)){
var statearr_128919_128935 = state_128913__$1;
(statearr_128919_128935[(1)] = (5));

} else {
var statearr_128920_128936 = state_128913__$1;
(statearr_128920_128936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (6))){
var inst_128882 = (state_128913[(7)]);
var state_128913__$1 = state_128913;
var statearr_128921_128937 = state_128913__$1;
(statearr_128921_128937[(2)] = inst_128882);

(statearr_128921_128937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (3))){
var inst_128878 = (state_128913[(2)]);
var state_128913__$1 = state_128913;
var statearr_128922_128938 = state_128913__$1;
(statearr_128922_128938[(2)] = inst_128878);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128913__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (2))){
var inst_128911 = (state_128913[(2)]);
var state_128913__$1 = state_128913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128913__$1,inst_128911);
} else {
if((state_val_128914 === (11))){
var inst_128894 = (state_128913[(2)]);
var inst_128895 = fluree.db.util.async.throw_err.call(null,inst_128894);
var inst_128896 = cljs.core.nth.call(null,inst_128895,(0),null);
var inst_128897 = cljs.core.nth.call(null,inst_128895,(1),null);
var inst_128898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128900 = ["?pO","?ctx",inst_128896];
var inst_128901 = cljs.core.PersistentHashMap.fromArrays(inst_128899,inst_128900);
var inst_128902 = ((10) + inst_128897);
var inst_128903 = [inst_128901,inst_128902];
var inst_128904 = (new cljs.core.PersistentVector(null,2,(5),inst_128898,inst_128903,null));
var inst_128905 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128904);
var state_128913__$1 = (function (){var statearr_128923 = state_128913;
(statearr_128923[(8)] = inst_128905);

return statearr_128923;
})();
var statearr_128924_128939 = state_128913__$1;
(statearr_128924_128939[(2)] = inst_128896);

(statearr_128924_128939[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (9))){
var inst_128907 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_128913__$1 = state_128913;
var statearr_128925_128940 = state_128913__$1;
(statearr_128925_128940[(2)] = inst_128907);

(statearr_128925_128940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (5))){
var inst_128884 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_128913__$1 = state_128913;
var statearr_128926_128941 = state_128913__$1;
(statearr_128926_128941[(2)] = inst_128884);

(statearr_128926_128941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (10))){
var inst_128909 = (state_128913[(2)]);
var state_128913__$1 = state_128913;
var statearr_128927_128942 = state_128913__$1;
(statearr_128927_128942[(2)] = inst_128909);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128913__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128914 === (8))){
var inst_128892 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_128913__$1 = state_128913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128913__$1,(11),inst_128892);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____0 = (function (){
var statearr_128928 = [null,null,null,null,null,null,null,null,null];
(statearr_128928[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__);

(statearr_128928[(1)] = (1));

return statearr_128928;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____1 = (function (state_128913){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e128929){if((e128929 instanceof Object)){
var ex__99978__auto__ = e128929;
var statearr_128930_128943 = state_128913;
(statearr_128930_128943[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128913);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e128929;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__128944 = state_128913;
state_128913 = G__128944;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__ = function(state_128913){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____1.call(this,state_128913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_128931 = f__100070__auto__.call(null);
(statearr_128931[(6)] = c__100069__auto__);

return statearr_128931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_128993){
var state_val_128994 = (state_128993[(1)]);
if((state_val_128994 === (7))){
var inst_128956 = (state_128993[(2)]);
var inst_128957 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_128993__$1 = (function (){var statearr_128995 = state_128993;
(statearr_128995[(7)] = inst_128956);

return statearr_128995;
})();
if(inst_128957){
var statearr_128996_129021 = state_128993__$1;
(statearr_128996_129021[(1)] = (9));

} else {
var statearr_128997_129022 = state_128993__$1;
(statearr_128997_129022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (1))){
var state_128993__$1 = state_128993;
var statearr_128998_129023 = state_128993__$1;
(statearr_128998_129023[(2)] = null);

(statearr_128998_129023[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_128993,(3),Error,null,(2));
var inst_128949 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_128993__$1 = state_128993;
if(inst_128949){
var statearr_128999_129024 = state_128993__$1;
(statearr_128999_129024[(1)] = (5));

} else {
var statearr_129000_129025 = state_128993__$1;
(statearr_129000_129025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (15))){
var inst_128964 = (state_128993[(8)]);
var inst_128956 = (state_128993[(7)]);
var inst_128976 = (state_128993[(2)]);
var inst_128977 = fluree.db.dbfunctions.internal.get_all.call(null,inst_128976,inst_128964);
var inst_128978 = cljs.core.count.call(null,inst_128964);
var inst_128979 = ((9) + inst_128978);
var inst_128980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_128982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_128983 = [inst_128956,inst_128964];
var inst_128984 = (new cljs.core.PersistentVector(null,2,(5),inst_128982,inst_128983,null));
var inst_128985 = ["get-all",inst_128984,inst_128977];
var inst_128986 = cljs.core.PersistentHashMap.fromArrays(inst_128981,inst_128985);
var inst_128987 = [inst_128986,inst_128979];
var inst_128988 = (new cljs.core.PersistentVector(null,2,(5),inst_128980,inst_128987,null));
var inst_128989 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_128988);
var state_128993__$1 = (function (){var statearr_129001 = state_128993;
(statearr_129001[(9)] = inst_128989);

return statearr_129001;
})();
var statearr_129002_129026 = state_128993__$1;
(statearr_129002_129026[(2)] = inst_128977);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128993__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (13))){
var inst_128956 = (state_128993[(7)]);
var inst_128967 = cljs.core.count.call(null,inst_128956);
var inst_128968 = cljs.core._EQ_.call(null,(1),inst_128967);
var state_128993__$1 = state_128993;
if(inst_128968){
var statearr_129003_129027 = state_128993__$1;
(statearr_129003_129027[(1)] = (16));

} else {
var statearr_129004_129028 = state_128993__$1;
(statearr_129004_129028[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (6))){
var state_128993__$1 = state_128993;
var statearr_129005_129029 = state_128993__$1;
(statearr_129005_129029[(2)] = subject);

(statearr_129005_129029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (17))){
var inst_128956 = (state_128993[(7)]);
var state_128993__$1 = state_128993;
var statearr_129006_129030 = state_128993__$1;
(statearr_129006_129030[(2)] = inst_128956);

(statearr_129006_129030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (3))){
var inst_128945 = (state_128993[(2)]);
var state_128993__$1 = state_128993;
var statearr_129007_129031 = state_128993__$1;
(statearr_129007_129031[(2)] = inst_128945);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128993__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (12))){
var inst_128960 = (state_128993[(2)]);
var inst_128961 = fluree.db.util.async.throw_err.call(null,inst_128960);
var state_128993__$1 = state_128993;
var statearr_129008_129032 = state_128993__$1;
(statearr_129008_129032[(2)] = inst_128961);

(statearr_129008_129032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (2))){
var inst_128991 = (state_128993[(2)]);
var state_128993__$1 = state_128993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_128993__$1,inst_128991);
} else {
if((state_val_128994 === (11))){
var inst_128956 = (state_128993[(7)]);
var inst_128964 = (state_128993[(2)]);
var inst_128965 = cljs.core.vector_QMARK_.call(null,inst_128956);
var state_128993__$1 = (function (){var statearr_129009 = state_128993;
(statearr_129009[(8)] = inst_128964);

return statearr_129009;
})();
if(inst_128965){
var statearr_129010_129033 = state_128993__$1;
(statearr_129010_129033[(1)] = (13));

} else {
var statearr_129011_129034 = state_128993__$1;
(statearr_129011_129034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (9))){
var state_128993__$1 = state_128993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128993__$1,(12),path);
} else {
if((state_val_128994 === (5))){
var state_128993__$1 = state_128993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_128993__$1,(8),subject);
} else {
if((state_val_128994 === (14))){
var inst_128956 = (state_128993[(7)]);
var state_128993__$1 = state_128993;
var statearr_129012_129035 = state_128993__$1;
(statearr_129012_129035[(2)] = inst_128956);

(statearr_129012_129035[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (16))){
var inst_128956 = (state_128993[(7)]);
var inst_128970 = cljs.core.first.call(null,inst_128956);
var state_128993__$1 = state_128993;
var statearr_129013_129036 = state_128993__$1;
(statearr_129013_129036[(2)] = inst_128970);

(statearr_129013_129036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (10))){
var state_128993__$1 = state_128993;
var statearr_129014_129037 = state_128993__$1;
(statearr_129014_129037[(2)] = path);

(statearr_129014_129037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (18))){
var inst_128973 = (state_128993[(2)]);
var state_128993__$1 = state_128993;
var statearr_129015_129038 = state_128993__$1;
(statearr_129015_129038[(2)] = inst_128973);

(statearr_129015_129038[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_128994 === (8))){
var inst_128952 = (state_128993[(2)]);
var inst_128953 = fluree.db.util.async.throw_err.call(null,inst_128952);
var state_128993__$1 = state_128993;
var statearr_129016_129039 = state_128993__$1;
(statearr_129016_129039[(2)] = inst_128953);

(statearr_129016_129039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____0 = (function (){
var statearr_129017 = [null,null,null,null,null,null,null,null,null,null];
(statearr_129017[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__);

(statearr_129017[(1)] = (1));

return statearr_129017;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____1 = (function (state_128993){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_128993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129018){if((e129018 instanceof Object)){
var ex__99978__auto__ = e129018;
var statearr_129019_129040 = state_128993;
(statearr_129019_129040[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_128993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129018;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129041 = state_128993;
state_128993 = G__129041;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__ = function(state_128993){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____1.call(this,state_128993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129020 = f__100070__auto__.call(null);
(statearr_129020[(6)] = c__100069__auto__);

return statearr_129020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129077){
var state_val_129078 = (state_129077[(1)]);
if((state_val_129078 === (7))){
var inst_129053 = (state_129077[(2)]);
var inst_129054 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_129077__$1 = (function (){var statearr_129079 = state_129077;
(statearr_129079[(7)] = inst_129053);

return statearr_129079;
})();
if(inst_129054){
var statearr_129080_129096 = state_129077__$1;
(statearr_129080_129096[(1)] = (9));

} else {
var statearr_129081_129097 = state_129077__$1;
(statearr_129081_129097[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (1))){
var state_129077__$1 = state_129077;
var statearr_129082_129098 = state_129077__$1;
(statearr_129082_129098[(2)] = null);

(statearr_129082_129098[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129077,(3),Error,null,(2));
var inst_129046 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_129077__$1 = state_129077;
if(inst_129046){
var statearr_129083_129099 = state_129077__$1;
(statearr_129083_129099[(1)] = (5));

} else {
var statearr_129084_129100 = state_129077__$1;
(statearr_129084_129100[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (6))){
var state_129077__$1 = state_129077;
var statearr_129085_129101 = state_129077__$1;
(statearr_129085_129101[(2)] = subject);

(statearr_129085_129101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (3))){
var inst_129042 = (state_129077[(2)]);
var state_129077__$1 = state_129077;
var statearr_129086_129102 = state_129077__$1;
(statearr_129086_129102[(2)] = inst_129042);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129077__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (12))){
var inst_129057 = (state_129077[(2)]);
var inst_129058 = fluree.db.util.async.throw_err.call(null,inst_129057);
var state_129077__$1 = state_129077;
var statearr_129087_129103 = state_129077__$1;
(statearr_129087_129103[(2)] = inst_129058);

(statearr_129087_129103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (2))){
var inst_129075 = (state_129077[(2)]);
var state_129077__$1 = state_129077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129077__$1,inst_129075);
} else {
if((state_val_129078 === (11))){
var inst_129053 = (state_129077[(7)]);
var inst_129061 = (state_129077[(2)]);
var inst_129062 = fluree.db.dbfunctions.internal.get_in.call(null,inst_129053,inst_129061);
var inst_129063 = cljs.core.count.call(null,inst_129061);
var inst_129064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129065 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129067 = [inst_129053,inst_129061];
var inst_129068 = (new cljs.core.PersistentVector(null,2,(5),inst_129066,inst_129067,null));
var inst_129069 = ["get-in",inst_129068,inst_129062];
var inst_129070 = cljs.core.PersistentHashMap.fromArrays(inst_129065,inst_129069);
var inst_129071 = [inst_129070,inst_129063];
var inst_129072 = (new cljs.core.PersistentVector(null,2,(5),inst_129064,inst_129071,null));
var inst_129073 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129072);
var state_129077__$1 = (function (){var statearr_129088 = state_129077;
(statearr_129088[(8)] = inst_129073);

return statearr_129088;
})();
var statearr_129089_129104 = state_129077__$1;
(statearr_129089_129104[(2)] = inst_129062);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129077__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (9))){
var state_129077__$1 = state_129077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129077__$1,(12),path);
} else {
if((state_val_129078 === (5))){
var state_129077__$1 = state_129077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129077__$1,(8),subject);
} else {
if((state_val_129078 === (10))){
var state_129077__$1 = state_129077;
var statearr_129090_129105 = state_129077__$1;
(statearr_129090_129105[(2)] = path);

(statearr_129090_129105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129078 === (8))){
var inst_129049 = (state_129077[(2)]);
var inst_129050 = fluree.db.util.async.throw_err.call(null,inst_129049);
var state_129077__$1 = state_129077;
var statearr_129091_129106 = state_129077__$1;
(statearr_129091_129106[(2)] = inst_129050);

(statearr_129091_129106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____0 = (function (){
var statearr_129092 = [null,null,null,null,null,null,null,null,null];
(statearr_129092[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__);

(statearr_129092[(1)] = (1));

return statearr_129092;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____1 = (function (state_129077){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129093){if((e129093 instanceof Object)){
var ex__99978__auto__ = e129093;
var statearr_129094_129107 = state_129077;
(statearr_129094_129107[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129108 = state_129077;
state_129077 = G__129108;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__ = function(state_129077){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____1.call(this,state_129077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129095 = f__100070__auto__.call(null);
(statearr_129095[(6)] = c__100069__auto__);

return statearr_129095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129150){
var state_val_129151 = (state_129150[(1)]);
if((state_val_129151 === (7))){
var inst_129120 = (state_129150[(7)]);
var inst_129120__$1 = (state_129150[(2)]);
var inst_129121 = cljs.core.set_QMARK_.call(null,inst_129120__$1);
var state_129150__$1 = (function (){var statearr_129152 = state_129150;
(statearr_129152[(7)] = inst_129120__$1);

return statearr_129152;
})();
if(inst_129121){
var statearr_129153_129174 = state_129150__$1;
(statearr_129153_129174[(1)] = (9));

} else {
var statearr_129154_129175 = state_129150__$1;
(statearr_129154_129175[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (1))){
var state_129150__$1 = state_129150;
var statearr_129155_129176 = state_129150__$1;
(statearr_129155_129176[(2)] = null);

(statearr_129155_129176[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129150,(3),Error,null,(2));
var inst_129113 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_129150__$1 = state_129150;
if(inst_129113){
var statearr_129156_129177 = state_129150__$1;
(statearr_129156_129177[(1)] = (5));

} else {
var statearr_129157_129178 = state_129150__$1;
(statearr_129157_129178[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (15))){
var inst_129131 = (state_129150[(2)]);
var inst_129132 = fluree.db.util.async.throw_err.call(null,inst_129131);
var state_129150__$1 = state_129150;
var statearr_129158_129179 = state_129150__$1;
(statearr_129158_129179[(2)] = inst_129132);

(statearr_129158_129179[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (13))){
var state_129150__$1 = state_129150;
var statearr_129159_129180 = state_129150__$1;
(statearr_129159_129180[(2)] = key);

(statearr_129159_129180[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (6))){
var state_129150__$1 = state_129150;
var statearr_129160_129181 = state_129150__$1;
(statearr_129160_129181[(2)] = coll);

(statearr_129160_129181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (3))){
var inst_129109 = (state_129150[(2)]);
var state_129150__$1 = state_129150;
var statearr_129161_129182 = state_129150__$1;
(statearr_129161_129182[(2)] = inst_129109);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129150__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (12))){
var state_129150__$1 = state_129150;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129150__$1,(15),key);
} else {
if((state_val_129151 === (2))){
var inst_129148 = (state_129150[(2)]);
var state_129150__$1 = state_129150;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129150__$1,inst_129148);
} else {
if((state_val_129151 === (11))){
var inst_129127 = (state_129150[(2)]);
var inst_129128 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_129150__$1 = (function (){var statearr_129162 = state_129150;
(statearr_129162[(8)] = inst_129127);

return statearr_129162;
})();
if(inst_129128){
var statearr_129163_129183 = state_129150__$1;
(statearr_129163_129183[(1)] = (12));

} else {
var statearr_129164_129184 = state_129150__$1;
(statearr_129164_129184[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (9))){
var inst_129120 = (state_129150[(7)]);
var state_129150__$1 = state_129150;
var statearr_129165_129185 = state_129150__$1;
(statearr_129165_129185[(2)] = inst_129120);

(statearr_129165_129185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (5))){
var state_129150__$1 = state_129150;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129150__$1,(8),coll);
} else {
if((state_val_129151 === (14))){
var inst_129127 = (state_129150[(8)]);
var inst_129135 = (state_129150[(2)]);
var inst_129136 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_129127,inst_129135);
var inst_129137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129138 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129140 = [inst_129127,inst_129135];
var inst_129141 = (new cljs.core.PersistentVector(null,2,(5),inst_129139,inst_129140,null));
var inst_129142 = ["contains?",inst_129141,inst_129136];
var inst_129143 = cljs.core.PersistentHashMap.fromArrays(inst_129138,inst_129142);
var inst_129144 = [inst_129143,(10)];
var inst_129145 = (new cljs.core.PersistentVector(null,2,(5),inst_129137,inst_129144,null));
var inst_129146 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129145);
var state_129150__$1 = (function (){var statearr_129166 = state_129150;
(statearr_129166[(9)] = inst_129146);

return statearr_129166;
})();
var statearr_129167_129186 = state_129150__$1;
(statearr_129167_129186[(2)] = inst_129136);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129150__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (10))){
var inst_129120 = (state_129150[(7)]);
var inst_129124 = cljs.core.flatten.call(null,inst_129120);
var inst_129125 = cljs.core.set.call(null,inst_129124);
var state_129150__$1 = state_129150;
var statearr_129168_129187 = state_129150__$1;
(statearr_129168_129187[(2)] = inst_129125);

(statearr_129168_129187[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129151 === (8))){
var inst_129116 = (state_129150[(2)]);
var inst_129117 = fluree.db.util.async.throw_err.call(null,inst_129116);
var state_129150__$1 = state_129150;
var statearr_129169_129188 = state_129150__$1;
(statearr_129169_129188[(2)] = inst_129117);

(statearr_129169_129188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_129170 = [null,null,null,null,null,null,null,null,null,null];
(statearr_129170[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__);

(statearr_129170[(1)] = (1));

return statearr_129170;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____1 = (function (state_129150){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129150);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129171){if((e129171 instanceof Object)){
var ex__99978__auto__ = e129171;
var statearr_129172_129189 = state_129150;
(statearr_129172_129189[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129150);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129190 = state_129150;
state_129150 = G__129190;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__ = function(state_129150){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____1.call(this,state_129150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129173 = f__100070__auto__.call(null);
(statearr_129173[(6)] = c__100069__auto__);

return statearr_129173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129245 = arguments.length;
var i__4737__auto___129246 = (0);
while(true){
if((i__4737__auto___129246 < len__4736__auto___129245)){
args__4742__auto__.push((arguments[i__4737__auto___129246]));

var G__129247 = (i__4737__auto___129246 + (1));
i__4737__auto___129246 = G__129247;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129230){
var state_val_129231 = (state_129230[(1)]);
if((state_val_129231 === (1))){
var state_129230__$1 = state_129230;
var statearr_129232_129248 = state_129230__$1;
(statearr_129232_129248[(2)] = null);

(statearr_129232_129248[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129231 === (2))){
var inst_129228 = (state_129230[(2)]);
var state_129230__$1 = state_129230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129230__$1,inst_129228);
} else {
if((state_val_129231 === (3))){
var inst_129193 = (state_129230[(2)]);
var state_129230__$1 = state_129230;
var statearr_129233_129249 = state_129230__$1;
(statearr_129233_129249[(2)] = inst_129193);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129230__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129231 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129230,(3),Error,null,(2));
var inst_129197 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129230__$1 = state_129230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129230__$1,(5),inst_129197);
} else {
if((state_val_129231 === (5))){
var inst_129200 = (state_129230[(7)]);
var inst_129199 = (state_129230[(2)]);
var inst_129200__$1 = fluree.db.util.async.throw_err.call(null,inst_129199);
var inst_129201 = cljs.core.count.call(null,inst_129200__$1);
var inst_129202 = cljs.core._EQ_.call(null,(1),inst_129201);
var inst_129203 = cljs.core.first.call(null,inst_129200__$1);
var inst_129204 = cljs.core.coll_QMARK_.call(null,inst_129203);
var inst_129205 = ((inst_129202) && (inst_129204));
var state_129230__$1 = (function (){var statearr_129234 = state_129230;
(statearr_129234[(7)] = inst_129200__$1);

return statearr_129234;
})();
if(cljs.core.truth_(inst_129205)){
var statearr_129235_129250 = state_129230__$1;
(statearr_129235_129250[(1)] = (6));

} else {
var statearr_129236_129251 = state_129230__$1;
(statearr_129236_129251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129231 === (6))){
var inst_129200 = (state_129230[(7)]);
var inst_129207 = cljs.core.first.call(null,inst_129200);
var state_129230__$1 = state_129230;
var statearr_129237_129252 = state_129230__$1;
(statearr_129237_129252[(2)] = inst_129207);

(statearr_129237_129252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129231 === (7))){
var inst_129200 = (state_129230[(7)]);
var state_129230__$1 = state_129230;
var statearr_129238_129253 = state_129230__$1;
(statearr_129238_129253[(2)] = inst_129200);

(statearr_129238_129253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129231 === (8))){
var inst_129210 = (state_129230[(2)]);
var inst_129211 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_129210);
var inst_129212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129213 = [inst_129210];
var inst_129214 = (new cljs.core.PersistentVector(null,1,(5),inst_129212,inst_129213,null));
var inst_129215 = cljs.core.count.call(null,inst_129214);
var inst_129216 = ((9) + inst_129215);
var inst_129217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129218 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129220 = [inst_129210];
var inst_129221 = (new cljs.core.PersistentVector(null,1,(5),inst_129219,inst_129220,null));
var inst_129222 = ["hash-set",inst_129221,inst_129211];
var inst_129223 = cljs.core.PersistentHashMap.fromArrays(inst_129218,inst_129222);
var inst_129224 = [inst_129223,inst_129216];
var inst_129225 = (new cljs.core.PersistentVector(null,2,(5),inst_129217,inst_129224,null));
var inst_129226 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129225);
var state_129230__$1 = (function (){var statearr_129239 = state_129230;
(statearr_129239[(8)] = inst_129226);

return statearr_129239;
})();
var statearr_129240_129254 = state_129230__$1;
(statearr_129240_129254[(2)] = inst_129211);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129230__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129241 = [null,null,null,null,null,null,null,null,null];
(statearr_129241[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129241[(1)] = (1));

return statearr_129241;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129230){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129242){if((e129242 instanceof Object)){
var ex__99978__auto__ = e129242;
var statearr_129243_129255 = state_129230;
(statearr_129243_129255[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129256 = state_129230;
state_129230 = G__129256;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129244 = f__100070__auto__.call(null);
(statearr_129244[(6)] = c__100069__auto__);

return statearr_129244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq129191){
var G__129192 = cljs.core.first.call(null,seq129191);
var seq129191__$1 = cljs.core.next.call(null,seq129191);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129192,seq129191__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129296 = arguments.length;
var i__4737__auto___129297 = (0);
while(true){
if((i__4737__auto___129297 < len__4736__auto___129296)){
args__4742__auto__.push((arguments[i__4737__auto___129297]));

var G__129298 = (i__4737__auto___129297 + (1));
i__4737__auto___129297 = G__129298;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129286){
var state_val_129287 = (state_129286[(1)]);
if((state_val_129287 === (1))){
var state_129286__$1 = state_129286;
var statearr_129288_129299 = state_129286__$1;
(statearr_129288_129299[(2)] = null);

(statearr_129288_129299[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129287 === (2))){
var inst_129284 = (state_129286[(2)]);
var state_129286__$1 = state_129286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129286__$1,inst_129284);
} else {
if((state_val_129287 === (3))){
var inst_129259 = (state_129286[(2)]);
var state_129286__$1 = state_129286;
var statearr_129289_129300 = state_129286__$1;
(statearr_129289_129300[(2)] = inst_129259);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129286__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129287 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129286,(3),Error,null,(2));
var inst_129263 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129286__$1 = state_129286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129286__$1,(5),inst_129263);
} else {
if((state_val_129287 === (5))){
var inst_129265 = (state_129286[(2)]);
var inst_129266 = fluree.db.util.async.throw_err.call(null,inst_129265);
var inst_129267 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_129266);
var inst_129268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129269 = [inst_129266];
var inst_129270 = (new cljs.core.PersistentVector(null,1,(5),inst_129268,inst_129269,null));
var inst_129271 = cljs.core.count.call(null,inst_129270);
var inst_129272 = ((9) + inst_129271);
var inst_129273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129274 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129276 = [inst_129266];
var inst_129277 = (new cljs.core.PersistentVector(null,1,(5),inst_129275,inst_129276,null));
var inst_129278 = ["==",inst_129277,inst_129267];
var inst_129279 = cljs.core.PersistentHashMap.fromArrays(inst_129274,inst_129278);
var inst_129280 = [inst_129279,inst_129272];
var inst_129281 = (new cljs.core.PersistentVector(null,2,(5),inst_129273,inst_129280,null));
var inst_129282 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129281);
var state_129286__$1 = (function (){var statearr_129290 = state_129286;
(statearr_129290[(7)] = inst_129282);

return statearr_129290;
})();
var statearr_129291_129301 = state_129286__$1;
(statearr_129291_129301[(2)] = inst_129267);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129286__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129292 = [null,null,null,null,null,null,null,null];
(statearr_129292[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129292[(1)] = (1));

return statearr_129292;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129286){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129293){if((e129293 instanceof Object)){
var ex__99978__auto__ = e129293;
var statearr_129294_129302 = state_129286;
(statearr_129294_129302[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129286);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129303 = state_129286;
state_129286 = G__129303;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129286){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129295 = f__100070__auto__.call(null);
(statearr_129295[(6)] = c__100069__auto__);

return statearr_129295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq129257){
var G__129258 = cljs.core.first.call(null,seq129257);
var seq129257__$1 = cljs.core.next.call(null,seq129257);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129258,seq129257__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129343 = arguments.length;
var i__4737__auto___129344 = (0);
while(true){
if((i__4737__auto___129344 < len__4736__auto___129343)){
args__4742__auto__.push((arguments[i__4737__auto___129344]));

var G__129345 = (i__4737__auto___129344 + (1));
i__4737__auto___129344 = G__129345;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129333){
var state_val_129334 = (state_129333[(1)]);
if((state_val_129334 === (1))){
var state_129333__$1 = state_129333;
var statearr_129335_129346 = state_129333__$1;
(statearr_129335_129346[(2)] = null);

(statearr_129335_129346[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129334 === (2))){
var inst_129331 = (state_129333[(2)]);
var state_129333__$1 = state_129333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129333__$1,inst_129331);
} else {
if((state_val_129334 === (3))){
var inst_129306 = (state_129333[(2)]);
var state_129333__$1 = state_129333;
var statearr_129336_129347 = state_129333__$1;
(statearr_129336_129347[(2)] = inst_129306);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129333__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129334 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129333,(3),Error,null,(2));
var inst_129310 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129333__$1 = state_129333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129333__$1,(5),inst_129310);
} else {
if((state_val_129334 === (5))){
var inst_129312 = (state_129333[(2)]);
var inst_129313 = fluree.db.util.async.throw_err.call(null,inst_129312);
var inst_129314 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_129313);
var inst_129315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129316 = [inst_129313];
var inst_129317 = (new cljs.core.PersistentVector(null,1,(5),inst_129315,inst_129316,null));
var inst_129318 = cljs.core.count.call(null,inst_129317);
var inst_129319 = ((9) + inst_129318);
var inst_129320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129321 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129323 = [inst_129313];
var inst_129324 = (new cljs.core.PersistentVector(null,1,(5),inst_129322,inst_129323,null));
var inst_129325 = [">",inst_129324,inst_129314];
var inst_129326 = cljs.core.PersistentHashMap.fromArrays(inst_129321,inst_129325);
var inst_129327 = [inst_129326,inst_129319];
var inst_129328 = (new cljs.core.PersistentVector(null,2,(5),inst_129320,inst_129327,null));
var inst_129329 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129328);
var state_129333__$1 = (function (){var statearr_129337 = state_129333;
(statearr_129337[(7)] = inst_129329);

return statearr_129337;
})();
var statearr_129338_129348 = state_129333__$1;
(statearr_129338_129348[(2)] = inst_129314);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129333__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129339 = [null,null,null,null,null,null,null,null];
(statearr_129339[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129339[(1)] = (1));

return statearr_129339;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129333){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129340){if((e129340 instanceof Object)){
var ex__99978__auto__ = e129340;
var statearr_129341_129349 = state_129333;
(statearr_129341_129349[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129340;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129350 = state_129333;
state_129333 = G__129350;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129333){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129342 = f__100070__auto__.call(null);
(statearr_129342[(6)] = c__100069__auto__);

return statearr_129342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq129304){
var G__129305 = cljs.core.first.call(null,seq129304);
var seq129304__$1 = cljs.core.next.call(null,seq129304);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129305,seq129304__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129390 = arguments.length;
var i__4737__auto___129391 = (0);
while(true){
if((i__4737__auto___129391 < len__4736__auto___129390)){
args__4742__auto__.push((arguments[i__4737__auto___129391]));

var G__129392 = (i__4737__auto___129391 + (1));
i__4737__auto___129391 = G__129392;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129380){
var state_val_129381 = (state_129380[(1)]);
if((state_val_129381 === (1))){
var state_129380__$1 = state_129380;
var statearr_129382_129393 = state_129380__$1;
(statearr_129382_129393[(2)] = null);

(statearr_129382_129393[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129381 === (2))){
var inst_129378 = (state_129380[(2)]);
var state_129380__$1 = state_129380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129380__$1,inst_129378);
} else {
if((state_val_129381 === (3))){
var inst_129353 = (state_129380[(2)]);
var state_129380__$1 = state_129380;
var statearr_129383_129394 = state_129380__$1;
(statearr_129383_129394[(2)] = inst_129353);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129380__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129381 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129380,(3),Error,null,(2));
var inst_129357 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129380__$1 = state_129380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129380__$1,(5),inst_129357);
} else {
if((state_val_129381 === (5))){
var inst_129359 = (state_129380[(2)]);
var inst_129360 = fluree.db.util.async.throw_err.call(null,inst_129359);
var inst_129361 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_129360);
var inst_129362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129363 = [inst_129360];
var inst_129364 = (new cljs.core.PersistentVector(null,1,(5),inst_129362,inst_129363,null));
var inst_129365 = cljs.core.count.call(null,inst_129364);
var inst_129366 = ((9) + inst_129365);
var inst_129367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129368 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129370 = [inst_129360];
var inst_129371 = (new cljs.core.PersistentVector(null,1,(5),inst_129369,inst_129370,null));
var inst_129372 = ["<",inst_129371,inst_129361];
var inst_129373 = cljs.core.PersistentHashMap.fromArrays(inst_129368,inst_129372);
var inst_129374 = [inst_129373,inst_129366];
var inst_129375 = (new cljs.core.PersistentVector(null,2,(5),inst_129367,inst_129374,null));
var inst_129376 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129375);
var state_129380__$1 = (function (){var statearr_129384 = state_129380;
(statearr_129384[(7)] = inst_129376);

return statearr_129384;
})();
var statearr_129385_129395 = state_129380__$1;
(statearr_129385_129395[(2)] = inst_129361);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129380__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129386 = [null,null,null,null,null,null,null,null];
(statearr_129386[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129386[(1)] = (1));

return statearr_129386;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129380){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129387){if((e129387 instanceof Object)){
var ex__99978__auto__ = e129387;
var statearr_129388_129396 = state_129380;
(statearr_129388_129396[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129380);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129397 = state_129380;
state_129380 = G__129397;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129380){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129389 = f__100070__auto__.call(null);
(statearr_129389[(6)] = c__100069__auto__);

return statearr_129389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq129351){
var G__129352 = cljs.core.first.call(null,seq129351);
var seq129351__$1 = cljs.core.next.call(null,seq129351);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129352,seq129351__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129437 = arguments.length;
var i__4737__auto___129438 = (0);
while(true){
if((i__4737__auto___129438 < len__4736__auto___129437)){
args__4742__auto__.push((arguments[i__4737__auto___129438]));

var G__129439 = (i__4737__auto___129438 + (1));
i__4737__auto___129438 = G__129439;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129427){
var state_val_129428 = (state_129427[(1)]);
if((state_val_129428 === (1))){
var state_129427__$1 = state_129427;
var statearr_129429_129440 = state_129427__$1;
(statearr_129429_129440[(2)] = null);

(statearr_129429_129440[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129428 === (2))){
var inst_129425 = (state_129427[(2)]);
var state_129427__$1 = state_129427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129427__$1,inst_129425);
} else {
if((state_val_129428 === (3))){
var inst_129400 = (state_129427[(2)]);
var state_129427__$1 = state_129427;
var statearr_129430_129441 = state_129427__$1;
(statearr_129430_129441[(2)] = inst_129400);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129428 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129427,(3),Error,null,(2));
var inst_129404 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129427__$1 = state_129427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129427__$1,(5),inst_129404);
} else {
if((state_val_129428 === (5))){
var inst_129406 = (state_129427[(2)]);
var inst_129407 = fluree.db.util.async.throw_err.call(null,inst_129406);
var inst_129408 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_129407);
var inst_129409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129410 = [inst_129407];
var inst_129411 = (new cljs.core.PersistentVector(null,1,(5),inst_129409,inst_129410,null));
var inst_129412 = cljs.core.count.call(null,inst_129411);
var inst_129413 = ((9) + inst_129412);
var inst_129414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129415 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129417 = [inst_129407];
var inst_129418 = (new cljs.core.PersistentVector(null,1,(5),inst_129416,inst_129417,null));
var inst_129419 = ["<=",inst_129418,inst_129408];
var inst_129420 = cljs.core.PersistentHashMap.fromArrays(inst_129415,inst_129419);
var inst_129421 = [inst_129420,inst_129413];
var inst_129422 = (new cljs.core.PersistentVector(null,2,(5),inst_129414,inst_129421,null));
var inst_129423 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129422);
var state_129427__$1 = (function (){var statearr_129431 = state_129427;
(statearr_129431[(7)] = inst_129423);

return statearr_129431;
})();
var statearr_129432_129442 = state_129427__$1;
(statearr_129432_129442[(2)] = inst_129408);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129433 = [null,null,null,null,null,null,null,null];
(statearr_129433[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129433[(1)] = (1));

return statearr_129433;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129427){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129434){if((e129434 instanceof Object)){
var ex__99978__auto__ = e129434;
var statearr_129435_129443 = state_129427;
(statearr_129435_129443[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129444 = state_129427;
state_129427 = G__129444;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129427){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129436 = f__100070__auto__.call(null);
(statearr_129436[(6)] = c__100069__auto__);

return statearr_129436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq129398){
var G__129399 = cljs.core.first.call(null,seq129398);
var seq129398__$1 = cljs.core.next.call(null,seq129398);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129399,seq129398__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129484 = arguments.length;
var i__4737__auto___129485 = (0);
while(true){
if((i__4737__auto___129485 < len__4736__auto___129484)){
args__4742__auto__.push((arguments[i__4737__auto___129485]));

var G__129486 = (i__4737__auto___129485 + (1));
i__4737__auto___129485 = G__129486;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129474){
var state_val_129475 = (state_129474[(1)]);
if((state_val_129475 === (1))){
var state_129474__$1 = state_129474;
var statearr_129476_129487 = state_129474__$1;
(statearr_129476_129487[(2)] = null);

(statearr_129476_129487[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129475 === (2))){
var inst_129472 = (state_129474[(2)]);
var state_129474__$1 = state_129474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129474__$1,inst_129472);
} else {
if((state_val_129475 === (3))){
var inst_129447 = (state_129474[(2)]);
var state_129474__$1 = state_129474;
var statearr_129477_129488 = state_129474__$1;
(statearr_129477_129488[(2)] = inst_129447);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129475 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129474,(3),Error,null,(2));
var inst_129451 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129474__$1 = state_129474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129474__$1,(5),inst_129451);
} else {
if((state_val_129475 === (5))){
var inst_129453 = (state_129474[(2)]);
var inst_129454 = fluree.db.util.async.throw_err.call(null,inst_129453);
var inst_129455 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_129454);
var inst_129456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129457 = [inst_129454];
var inst_129458 = (new cljs.core.PersistentVector(null,1,(5),inst_129456,inst_129457,null));
var inst_129459 = cljs.core.count.call(null,inst_129458);
var inst_129460 = ((9) + inst_129459);
var inst_129461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129462 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129464 = [inst_129454];
var inst_129465 = (new cljs.core.PersistentVector(null,1,(5),inst_129463,inst_129464,null));
var inst_129466 = [">=",inst_129465,inst_129455];
var inst_129467 = cljs.core.PersistentHashMap.fromArrays(inst_129462,inst_129466);
var inst_129468 = [inst_129467,inst_129460];
var inst_129469 = (new cljs.core.PersistentVector(null,2,(5),inst_129461,inst_129468,null));
var inst_129470 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129469);
var state_129474__$1 = (function (){var statearr_129478 = state_129474;
(statearr_129478[(7)] = inst_129470);

return statearr_129478;
})();
var statearr_129479_129489 = state_129474__$1;
(statearr_129479_129489[(2)] = inst_129455);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129480 = [null,null,null,null,null,null,null,null];
(statearr_129480[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129480[(1)] = (1));

return statearr_129480;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129474){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129481){if((e129481 instanceof Object)){
var ex__99978__auto__ = e129481;
var statearr_129482_129490 = state_129474;
(statearr_129482_129490[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129481;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129491 = state_129474;
state_129474 = G__129491;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129474){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129483 = f__100070__auto__.call(null);
(statearr_129483[(6)] = c__100069__auto__);

return statearr_129483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq129445){
var G__129446 = cljs.core.first.call(null,seq129445);
var seq129445__$1 = cljs.core.next.call(null,seq129445);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129446,seq129445__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129531 = arguments.length;
var i__4737__auto___129532 = (0);
while(true){
if((i__4737__auto___129532 < len__4736__auto___129531)){
args__4742__auto__.push((arguments[i__4737__auto___129532]));

var G__129533 = (i__4737__auto___129532 + (1));
i__4737__auto___129532 = G__129533;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129521){
var state_val_129522 = (state_129521[(1)]);
if((state_val_129522 === (1))){
var state_129521__$1 = state_129521;
var statearr_129523_129534 = state_129521__$1;
(statearr_129523_129534[(2)] = null);

(statearr_129523_129534[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129522 === (2))){
var inst_129519 = (state_129521[(2)]);
var state_129521__$1 = state_129521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129521__$1,inst_129519);
} else {
if((state_val_129522 === (3))){
var inst_129494 = (state_129521[(2)]);
var state_129521__$1 = state_129521;
var statearr_129524_129535 = state_129521__$1;
(statearr_129524_129535[(2)] = inst_129494);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129521__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129522 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129521,(3),Error,null,(2));
var inst_129498 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129521__$1 = state_129521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129521__$1,(5),inst_129498);
} else {
if((state_val_129522 === (5))){
var inst_129500 = (state_129521[(2)]);
var inst_129501 = fluree.db.util.async.throw_err.call(null,inst_129500);
var inst_129502 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_129501);
var inst_129503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129504 = [inst_129501];
var inst_129505 = (new cljs.core.PersistentVector(null,1,(5),inst_129503,inst_129504,null));
var inst_129506 = cljs.core.count.call(null,inst_129505);
var inst_129507 = ((9) + inst_129506);
var inst_129508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129509 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129511 = [inst_129501];
var inst_129512 = (new cljs.core.PersistentVector(null,1,(5),inst_129510,inst_129511,null));
var inst_129513 = ["max",inst_129512,inst_129502];
var inst_129514 = cljs.core.PersistentHashMap.fromArrays(inst_129509,inst_129513);
var inst_129515 = [inst_129514,inst_129507];
var inst_129516 = (new cljs.core.PersistentVector(null,2,(5),inst_129508,inst_129515,null));
var inst_129517 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129516);
var state_129521__$1 = (function (){var statearr_129525 = state_129521;
(statearr_129525[(7)] = inst_129517);

return statearr_129525;
})();
var statearr_129526_129536 = state_129521__$1;
(statearr_129526_129536[(2)] = inst_129502);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129521__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129527 = [null,null,null,null,null,null,null,null];
(statearr_129527[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129527[(1)] = (1));

return statearr_129527;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129521){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129528){if((e129528 instanceof Object)){
var ex__99978__auto__ = e129528;
var statearr_129529_129537 = state_129521;
(statearr_129529_129537[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129521);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129528;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129538 = state_129521;
state_129521 = G__129538;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129521){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129530 = f__100070__auto__.call(null);
(statearr_129530[(6)] = c__100069__auto__);

return statearr_129530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq129492){
var G__129493 = cljs.core.first.call(null,seq129492);
var seq129492__$1 = cljs.core.next.call(null,seq129492);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129493,seq129492__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___129577 = arguments.length;
var i__4737__auto___129578 = (0);
while(true){
if((i__4737__auto___129578 < len__4736__auto___129577)){
args__4742__auto__.push((arguments[i__4737__auto___129578]));

var G__129579 = (i__4737__auto___129578 + (1));
i__4737__auto___129578 = G__129579;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129567){
var state_val_129568 = (state_129567[(1)]);
if((state_val_129568 === (1))){
var state_129567__$1 = state_129567;
var statearr_129569_129580 = state_129567__$1;
(statearr_129569_129580[(2)] = null);

(statearr_129569_129580[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129568 === (2))){
var inst_129565 = (state_129567[(2)]);
var state_129567__$1 = state_129567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129567__$1,inst_129565);
} else {
if((state_val_129568 === (3))){
var inst_129541 = (state_129567[(2)]);
var state_129567__$1 = state_129567;
var statearr_129570_129581 = state_129567__$1;
(statearr_129570_129581[(2)] = inst_129541);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129568 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129567,(3),Error,null,(2));
var inst_129545 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_129567__$1 = state_129567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129567__$1,(5),inst_129545);
} else {
if((state_val_129568 === (5))){
var inst_129547 = (state_129567[(2)]);
var inst_129548 = fluree.db.util.async.throw_err.call(null,inst_129547);
var inst_129549 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_129548);
var inst_129550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129551 = [inst_129548];
var inst_129552 = (new cljs.core.PersistentVector(null,1,(5),inst_129550,inst_129551,null));
var inst_129553 = cljs.core.count.call(null,inst_129552);
var inst_129554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129555 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129557 = [inst_129548];
var inst_129558 = (new cljs.core.PersistentVector(null,1,(5),inst_129556,inst_129557,null));
var inst_129559 = ["min",inst_129558,inst_129549];
var inst_129560 = cljs.core.PersistentHashMap.fromArrays(inst_129555,inst_129559);
var inst_129561 = [inst_129560,inst_129553];
var inst_129562 = (new cljs.core.PersistentVector(null,2,(5),inst_129554,inst_129561,null));
var inst_129563 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129562);
var state_129567__$1 = (function (){var statearr_129571 = state_129567;
(statearr_129571[(7)] = inst_129563);

return statearr_129571;
})();
var statearr_129572_129582 = state_129567__$1;
(statearr_129572_129582[(2)] = inst_129549);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129567__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129573 = [null,null,null,null,null,null,null,null];
(statearr_129573[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129573[(1)] = (1));

return statearr_129573;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129567){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129574){if((e129574 instanceof Object)){
var ex__99978__auto__ = e129574;
var statearr_129575_129583 = state_129567;
(statearr_129575_129583[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129574;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129584 = state_129567;
state_129567 = G__129584;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129567){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129576 = f__100070__auto__.call(null);
(statearr_129576[(6)] = c__100069__auto__);

return statearr_129576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq129539){
var G__129540 = cljs.core.first.call(null,seq129539);
var seq129539__$1 = cljs.core.next.call(null,seq129539);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__129540,seq129539__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__129586 = arguments.length;
switch (G__129586) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129632){
var state_val_129633 = (state_129632[(1)]);
if((state_val_129633 === (7))){
var inst_129601 = (state_129632[(7)]);
var inst_129601__$1 = (state_129632[(2)]);
var inst_129602 = typeof inst_129601__$1 === 'string';
var state_129632__$1 = (function (){var statearr_129634 = state_129632;
(statearr_129634[(7)] = inst_129601__$1);

return statearr_129634;
})();
if(cljs.core.truth_(inst_129602)){
var statearr_129635_129754 = state_129632__$1;
(statearr_129635_129754[(1)] = (9));

} else {
var statearr_129636_129755 = state_129632__$1;
(statearr_129636_129755[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (1))){
var state_129632__$1 = state_129632;
var statearr_129637_129756 = state_129632__$1;
(statearr_129637_129756[(2)] = null);

(statearr_129637_129756[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129632,(3),Error,null,(2));
var inst_129594 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_129632__$1 = state_129632;
if(inst_129594){
var statearr_129638_129757 = state_129632__$1;
(statearr_129638_129757[(1)] = (5));

} else {
var statearr_129639_129758 = state_129632__$1;
(statearr_129639_129758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (6))){
var state_129632__$1 = state_129632;
var statearr_129640_129759 = state_129632__$1;
(statearr_129640_129759[(2)] = query_map);

(statearr_129640_129759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (3))){
var inst_129587 = (state_129632[(2)]);
var state_129632__$1 = state_129632;
var statearr_129641_129760 = state_129632__$1;
(statearr_129641_129760[(2)] = inst_129587);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129632__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (12))){
var inst_129607 = (state_129632[(8)]);
var inst_129615 = (state_129632[(2)]);
var inst_129616 = fluree.db.util.async.throw_err.call(null,inst_129615);
var inst_129617 = cljs.core.nth.call(null,inst_129616,(0),null);
var inst_129618 = cljs.core.nth.call(null,inst_129616,(1),null);
var inst_129619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129620 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129622 = [inst_129607];
var inst_129623 = (new cljs.core.PersistentVector(null,1,(5),inst_129621,inst_129622,null));
var inst_129624 = ["query",inst_129623,inst_129617];
var inst_129625 = cljs.core.PersistentHashMap.fromArrays(inst_129620,inst_129624);
var inst_129626 = [inst_129625,inst_129618];
var inst_129627 = (new cljs.core.PersistentVector(null,2,(5),inst_129619,inst_129626,null));
var inst_129628 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129627);
var state_129632__$1 = (function (){var statearr_129642 = state_129632;
(statearr_129642[(9)] = inst_129628);

return statearr_129642;
})();
var statearr_129643_129761 = state_129632__$1;
(statearr_129643_129761[(2)] = inst_129617);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129632__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (2))){
var inst_129630 = (state_129632[(2)]);
var state_129632__$1 = state_129632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129632__$1,inst_129630);
} else {
if((state_val_129633 === (11))){
var inst_129607 = (state_129632[(8)]);
var inst_129607__$1 = (state_129632[(2)]);
var inst_129608 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129609 = [new cljs.core.Keyword(null,"test","test",577538877)];
var inst_129610 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129611 = [inst_129610];
var inst_129612 = cljs.core.PersistentHashMap.fromArrays(inst_129609,inst_129611);
var inst_129613 = fluree.db.dbfunctions.internal.query.call(null,inst_129608,inst_129607__$1,inst_129612);
var state_129632__$1 = (function (){var statearr_129644 = state_129632;
(statearr_129644[(8)] = inst_129607__$1);

return statearr_129644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129632__$1,(12),inst_129613);
} else {
if((state_val_129633 === (9))){
var inst_129601 = (state_129632[(7)]);
var inst_129604 = fluree.db.util.json.parse.call(null,inst_129601);
var state_129632__$1 = state_129632;
var statearr_129645_129762 = state_129632__$1;
(statearr_129645_129762[(2)] = inst_129604);

(statearr_129645_129762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (5))){
var state_129632__$1 = state_129632;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129632__$1,(8),query_map);
} else {
if((state_val_129633 === (10))){
var inst_129601 = (state_129632[(7)]);
var state_129632__$1 = state_129632;
var statearr_129646_129763 = state_129632__$1;
(statearr_129646_129763[(2)] = inst_129601);

(statearr_129646_129763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129633 === (8))){
var inst_129597 = (state_129632[(2)]);
var inst_129598 = fluree.db.util.async.throw_err.call(null,inst_129597);
var state_129632__$1 = state_129632;
var statearr_129647_129764 = state_129632__$1;
(statearr_129647_129764[(2)] = inst_129598);

(statearr_129647_129764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129648 = [null,null,null,null,null,null,null,null,null,null];
(statearr_129648[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129648[(1)] = (1));

return statearr_129648;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129632){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129649){if((e129649 instanceof Object)){
var ex__99978__auto__ = e129649;
var statearr_129650_129765 = state_129632;
(statearr_129650_129765[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129766 = state_129632;
state_129632 = G__129766;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129632){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129651 = f__100070__auto__.call(null);
(statearr_129651[(6)] = c__100069__auto__);

return statearr_129651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129719){
var state_val_129720 = (state_129719[(1)]);
if((state_val_129720 === (7))){
var inst_129666 = (state_129719[(2)]);
var inst_129667 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_129719__$1 = (function (){var statearr_129721 = state_129719;
(statearr_129721[(7)] = inst_129666);

return statearr_129721;
})();
if(inst_129667){
var statearr_129722_129767 = state_129719__$1;
(statearr_129722_129767[(1)] = (9));

} else {
var statearr_129723_129768 = state_129719__$1;
(statearr_129723_129768[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (20))){
var inst_129686 = (state_129719[(2)]);
var inst_129687 = fluree.db.util.async.throw_err.call(null,inst_129686);
var state_129719__$1 = state_129719;
var statearr_129724_129769 = state_129719__$1;
(statearr_129724_129769[(2)] = inst_129687);

(statearr_129724_129769[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (1))){
var state_129719__$1 = state_129719;
var statearr_129725_129770 = state_129719__$1;
(statearr_129725_129770[(2)] = null);

(statearr_129725_129770[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (24))){
var inst_129694 = (state_129719[(2)]);
var inst_129695 = fluree.db.util.async.throw_err.call(null,inst_129694);
var state_129719__$1 = state_129719;
var statearr_129726_129771 = state_129719__$1;
(statearr_129726_129771[(2)] = inst_129695);

(statearr_129726_129771[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129719,(3),Error,null,(2));
var inst_129659 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_129719__$1 = state_129719;
if(inst_129659){
var statearr_129727_129772 = state_129719__$1;
(statearr_129727_129772[(1)] = (5));

} else {
var statearr_129728_129773 = state_129719__$1;
(statearr_129728_129773[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (15))){
var inst_129682 = (state_129719[(2)]);
var inst_129683 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_129719__$1 = (function (){var statearr_129729 = state_129719;
(statearr_129729[(8)] = inst_129682);

return statearr_129729;
})();
if(inst_129683){
var statearr_129730_129774 = state_129719__$1;
(statearr_129730_129774[(1)] = (17));

} else {
var statearr_129731_129775 = state_129719__$1;
(statearr_129731_129775[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (21))){
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(24),limit);
} else {
if((state_val_129720 === (13))){
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(16),where);
} else {
if((state_val_129720 === (22))){
var state_129719__$1 = state_129719;
var statearr_129732_129776 = state_129719__$1;
(statearr_129732_129776[(2)] = limit);

(statearr_129732_129776[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (6))){
var state_129719__$1 = state_129719;
var statearr_129733_129777 = state_129719__$1;
(statearr_129733_129777[(2)] = select);

(statearr_129733_129777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (25))){
var inst_129666 = (state_129719[(7)]);
var inst_129682 = (state_129719[(8)]);
var inst_129674 = (state_129719[(9)]);
var inst_129690 = (state_129719[(10)]);
var inst_129702 = (state_129719[(2)]);
var inst_129703 = fluree.db.util.async.throw_err.call(null,inst_129702);
var inst_129704 = cljs.core.nth.call(null,inst_129703,(0),null);
var inst_129705 = cljs.core.nth.call(null,inst_129703,(1),null);
var inst_129706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129707 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129709 = [inst_129666,inst_129674,inst_129682,inst_129690];
var inst_129710 = (new cljs.core.PersistentVector(null,4,(5),inst_129708,inst_129709,null));
var inst_129711 = ["query",inst_129710,inst_129704];
var inst_129712 = cljs.core.PersistentHashMap.fromArrays(inst_129707,inst_129711);
var inst_129713 = [inst_129712,inst_129705];
var inst_129714 = (new cljs.core.PersistentVector(null,2,(5),inst_129706,inst_129713,null));
var inst_129715 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129714);
var state_129719__$1 = (function (){var statearr_129734 = state_129719;
(statearr_129734[(11)] = inst_129715);

return statearr_129734;
})();
var statearr_129735_129778 = state_129719__$1;
(statearr_129735_129778[(2)] = inst_129704);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129719__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (17))){
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(20),block);
} else {
if((state_val_129720 === (3))){
var inst_129652 = (state_129719[(2)]);
var state_129719__$1 = state_129719;
var statearr_129736_129779 = state_129719__$1;
(statearr_129736_129779[(2)] = inst_129652);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129719__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (12))){
var inst_129670 = (state_129719[(2)]);
var inst_129671 = fluree.db.util.async.throw_err.call(null,inst_129670);
var state_129719__$1 = state_129719;
var statearr_129737_129780 = state_129719__$1;
(statearr_129737_129780[(2)] = inst_129671);

(statearr_129737_129780[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (2))){
var inst_129717 = (state_129719[(2)]);
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129719__$1,inst_129717);
} else {
if((state_val_129720 === (23))){
var inst_129666 = (state_129719[(7)]);
var inst_129682 = (state_129719[(8)]);
var inst_129674 = (state_129719[(9)]);
var inst_129690 = (state_129719[(10)]);
var inst_129698 = (state_129719[(2)]);
var inst_129699 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129700 = fluree.db.dbfunctions.internal.query.call(null,inst_129699,inst_129666,inst_129674,inst_129682,inst_129690,inst_129698);
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(25),inst_129700);
} else {
if((state_val_129720 === (19))){
var inst_129690 = (state_129719[(2)]);
var inst_129691 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_129719__$1 = (function (){var statearr_129738 = state_129719;
(statearr_129738[(10)] = inst_129690);

return statearr_129738;
})();
if(inst_129691){
var statearr_129739_129781 = state_129719__$1;
(statearr_129739_129781[(1)] = (21));

} else {
var statearr_129740_129782 = state_129719__$1;
(statearr_129740_129782[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (11))){
var inst_129674 = (state_129719[(2)]);
var inst_129675 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_129719__$1 = (function (){var statearr_129741 = state_129719;
(statearr_129741[(9)] = inst_129674);

return statearr_129741;
})();
if(inst_129675){
var statearr_129742_129783 = state_129719__$1;
(statearr_129742_129783[(1)] = (13));

} else {
var statearr_129743_129784 = state_129719__$1;
(statearr_129743_129784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (9))){
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(12),from);
} else {
if((state_val_129720 === (5))){
var state_129719__$1 = state_129719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129719__$1,(8),select);
} else {
if((state_val_129720 === (14))){
var state_129719__$1 = state_129719;
var statearr_129744_129785 = state_129719__$1;
(statearr_129744_129785[(2)] = where);

(statearr_129744_129785[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (16))){
var inst_129678 = (state_129719[(2)]);
var inst_129679 = fluree.db.util.async.throw_err.call(null,inst_129678);
var state_129719__$1 = state_129719;
var statearr_129745_129786 = state_129719__$1;
(statearr_129745_129786[(2)] = inst_129679);

(statearr_129745_129786[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (10))){
var state_129719__$1 = state_129719;
var statearr_129746_129787 = state_129719__$1;
(statearr_129746_129787[(2)] = from);

(statearr_129746_129787[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (18))){
var state_129719__$1 = state_129719;
var statearr_129747_129788 = state_129719__$1;
(statearr_129747_129788[(2)] = block);

(statearr_129747_129788[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129720 === (8))){
var inst_129662 = (state_129719[(2)]);
var inst_129663 = fluree.db.util.async.throw_err.call(null,inst_129662);
var state_129719__$1 = state_129719;
var statearr_129748_129789 = state_129719__$1;
(statearr_129748_129789[(2)] = inst_129663);

(statearr_129748_129789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_129749 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_129749[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_129749[(1)] = (1));

return statearr_129749;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_129719){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129750){if((e129750 instanceof Object)){
var ex__99978__auto__ = e129750;
var statearr_129751_129790 = state_129719;
(statearr_129751_129790[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129791 = state_129719;
state_129719 = G__129791;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_129719){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_129719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129752 = f__100070__auto__.call(null);
(statearr_129752[(6)] = c__100069__auto__);

return statearr_129752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129844){
var state_val_129845 = (state_129844[(1)]);
if((state_val_129845 === (7))){
var inst_129806 = (state_129844[(2)]);
var inst_129807 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_129844__$1 = (function (){var statearr_129846 = state_129844;
(statearr_129846[(7)] = inst_129806);

return statearr_129846;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129844__$1,(9),inst_129807);
} else {
if((state_val_129845 === (1))){
var state_129844__$1 = state_129844;
var statearr_129847_129870 = state_129844__$1;
(statearr_129847_129870[(2)] = null);

(statearr_129847_129870[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129844,(3),Error,null,(2));
var inst_129799 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_129844__$1 = state_129844;
if(inst_129799){
var statearr_129848_129871 = state_129844__$1;
(statearr_129848_129871[(1)] = (5));

} else {
var statearr_129849_129872 = state_129844__$1;
(statearr_129849_129872[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (15))){
var state_129844__$1 = state_129844;
var statearr_129850_129873 = state_129844__$1;
(statearr_129850_129873[(2)] = false);

(statearr_129850_129873[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (13))){
var inst_129814 = (state_129844[(2)]);
var inst_129815 = fluree.db.util.async.throw_err.call(null,inst_129814);
var state_129844__$1 = state_129844;
var statearr_129851_129874 = state_129844__$1;
(statearr_129851_129874[(2)] = inst_129815);

(statearr_129851_129874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (6))){
var state_129844__$1 = state_129844;
var statearr_129852_129875 = state_129844__$1;
(statearr_129852_129875[(2)] = startSubject);

(statearr_129852_129875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (17))){
var inst_129818 = (state_129844[(8)]);
var inst_129806 = (state_129844[(7)]);
var inst_129825 = (state_129844[(9)]);
var inst_129810 = (state_129844[(10)]);
var inst_129830 = (state_129844[(2)]);
var inst_129831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129834 = [inst_129806,inst_129810,inst_129818];
var inst_129835 = (new cljs.core.PersistentVector(null,3,(5),inst_129833,inst_129834,null));
var inst_129836 = ["relationship?",inst_129835,inst_129830];
var inst_129837 = cljs.core.PersistentHashMap.fromArrays(inst_129832,inst_129836);
var inst_129838 = [inst_129837,inst_129825];
var inst_129839 = (new cljs.core.PersistentVector(null,2,(5),inst_129831,inst_129838,null));
var inst_129840 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129839);
var state_129844__$1 = (function (){var statearr_129853 = state_129844;
(statearr_129853[(11)] = inst_129840);

return statearr_129853;
})();
var statearr_129854_129876 = state_129844__$1;
(statearr_129854_129876[(2)] = inst_129830);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129844__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (3))){
var inst_129792 = (state_129844[(2)]);
var state_129844__$1 = state_129844;
var statearr_129855_129877 = state_129844__$1;
(statearr_129855_129877[(2)] = inst_129792);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129844__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (12))){
var inst_129818 = (state_129844[(8)]);
var inst_129806 = (state_129844[(7)]);
var inst_129810 = (state_129844[(10)]);
var inst_129818__$1 = (state_129844[(2)]);
var inst_129819 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129820 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_129819,inst_129806,inst_129810,inst_129818__$1);
var state_129844__$1 = (function (){var statearr_129856 = state_129844;
(statearr_129856[(8)] = inst_129818__$1);

return statearr_129856;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129844__$1,(14),inst_129820);
} else {
if((state_val_129845 === (2))){
var inst_129842 = (state_129844[(2)]);
var state_129844__$1 = state_129844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129844__$1,inst_129842);
} else {
if((state_val_129845 === (11))){
var state_129844__$1 = state_129844;
var statearr_129857_129878 = state_129844__$1;
(statearr_129857_129878[(2)] = endSubject);

(statearr_129857_129878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (9))){
var inst_129809 = (state_129844[(2)]);
var inst_129810 = fluree.db.util.async.throw_err.call(null,inst_129809);
var inst_129811 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_129844__$1 = (function (){var statearr_129858 = state_129844;
(statearr_129858[(10)] = inst_129810);

return statearr_129858;
})();
if(inst_129811){
var statearr_129859_129879 = state_129844__$1;
(statearr_129859_129879[(1)] = (10));

} else {
var statearr_129860_129880 = state_129844__$1;
(statearr_129860_129880[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (5))){
var state_129844__$1 = state_129844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129844__$1,(8),startSubject);
} else {
if((state_val_129845 === (14))){
var inst_129822 = (state_129844[(2)]);
var inst_129823 = fluree.db.util.async.throw_err.call(null,inst_129822);
var inst_129824 = cljs.core.nth.call(null,inst_129823,(0),null);
var inst_129825 = cljs.core.nth.call(null,inst_129823,(1),null);
var inst_129826 = cljs.core.empty_QMARK_.call(null,inst_129824);
var state_129844__$1 = (function (){var statearr_129861 = state_129844;
(statearr_129861[(9)] = inst_129825);

return statearr_129861;
})();
if(inst_129826){
var statearr_129862_129881 = state_129844__$1;
(statearr_129862_129881[(1)] = (15));

} else {
var statearr_129863_129882 = state_129844__$1;
(statearr_129863_129882[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (16))){
var state_129844__$1 = state_129844;
var statearr_129864_129883 = state_129844__$1;
(statearr_129864_129883[(2)] = true);

(statearr_129864_129883[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129845 === (10))){
var state_129844__$1 = state_129844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129844__$1,(13),endSubject);
} else {
if((state_val_129845 === (8))){
var inst_129802 = (state_129844[(2)]);
var inst_129803 = fluree.db.util.async.throw_err.call(null,inst_129802);
var state_129844__$1 = state_129844;
var statearr_129865_129884 = state_129844__$1;
(statearr_129865_129884[(2)] = inst_129803);

(statearr_129865_129884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_129866 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_129866[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__);

(statearr_129866[(1)] = (1));

return statearr_129866;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____1 = (function (state_129844){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129867){if((e129867 instanceof Object)){
var ex__99978__auto__ = e129867;
var statearr_129868_129885 = state_129844;
(statearr_129868_129885[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129844);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129867;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129886 = state_129844;
state_129844 = G__129886;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__ = function(state_129844){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____1.call(this,state_129844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129869 = f__100070__auto__.call(null);
(statearr_129869[(6)] = c__100069__auto__);

return statearr_129869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129924){
var state_val_129925 = (state_129924[(1)]);
if((state_val_129925 === (7))){
var inst_129901 = (state_129924[(7)]);
var inst_129901__$1 = (state_129924[(2)]);
var inst_129902 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129903 = [new cljs.core.Keyword(null,"test","test",577538877)];
var inst_129904 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_129905 = [inst_129904];
var inst_129906 = cljs.core.PersistentHashMap.fromArrays(inst_129903,inst_129905);
var inst_129907 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_129902,inst_129901__$1,inst_129906);
var state_129924__$1 = (function (){var statearr_129926 = state_129924;
(statearr_129926[(7)] = inst_129901__$1);

return statearr_129926;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129924__$1,(9),inst_129907);
} else {
if((state_val_129925 === (1))){
var state_129924__$1 = state_129924;
var statearr_129927_129939 = state_129924__$1;
(statearr_129927_129939[(2)] = null);

(statearr_129927_129939[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129925 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129924,(3),Error,null,(2));
var inst_129894 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_129924__$1 = state_129924;
if(inst_129894){
var statearr_129928_129940 = state_129924__$1;
(statearr_129928_129940[(1)] = (5));

} else {
var statearr_129929_129941 = state_129924__$1;
(statearr_129929_129941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129925 === (6))){
var state_129924__$1 = state_129924;
var statearr_129930_129942 = state_129924__$1;
(statearr_129930_129942[(2)] = pred_name);

(statearr_129930_129942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129925 === (3))){
var inst_129887 = (state_129924[(2)]);
var state_129924__$1 = state_129924;
var statearr_129931_129943 = state_129924__$1;
(statearr_129931_129943[(2)] = inst_129887);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129924__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129925 === (2))){
var inst_129922 = (state_129924[(2)]);
var state_129924__$1 = state_129924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129924__$1,inst_129922);
} else {
if((state_val_129925 === (9))){
var inst_129901 = (state_129924[(7)]);
var inst_129909 = (state_129924[(2)]);
var inst_129910 = fluree.db.util.async.throw_err.call(null,inst_129909);
var inst_129911 = cljs.core.nth.call(null,inst_129910,(0),null);
var inst_129912 = cljs.core.nth.call(null,inst_129910,(1),null);
var inst_129913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129914 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129915 = ["max-pred-val",inst_129901,inst_129911];
var inst_129916 = cljs.core.PersistentHashMap.fromArrays(inst_129914,inst_129915);
var inst_129917 = (inst_129912 + (10));
var inst_129918 = [inst_129916,inst_129917];
var inst_129919 = (new cljs.core.PersistentVector(null,2,(5),inst_129913,inst_129918,null));
var inst_129920 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129919);
var state_129924__$1 = (function (){var statearr_129932 = state_129924;
(statearr_129932[(8)] = inst_129920);

return statearr_129932;
})();
var statearr_129933_129944 = state_129924__$1;
(statearr_129933_129944[(2)] = inst_129911);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129924__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129925 === (5))){
var state_129924__$1 = state_129924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129924__$1,(8),pred_name);
} else {
if((state_val_129925 === (8))){
var inst_129897 = (state_129924[(2)]);
var inst_129898 = fluree.db.util.async.throw_err.call(null,inst_129897);
var state_129924__$1 = state_129924;
var statearr_129934_129945 = state_129924__$1;
(statearr_129934_129945[(2)] = inst_129898);

(statearr_129934_129945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____0 = (function (){
var statearr_129935 = [null,null,null,null,null,null,null,null,null];
(statearr_129935[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__);

(statearr_129935[(1)] = (1));

return statearr_129935;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____1 = (function (state_129924){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129936){if((e129936 instanceof Object)){
var ex__99978__auto__ = e129936;
var statearr_129937_129946 = state_129924;
(statearr_129937_129946[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129924);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129947 = state_129924;
state_129924 = G__129947;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__ = function(state_129924){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____1.call(this,state_129924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129938 = f__100070__auto__.call(null);
(statearr_129938[(6)] = c__100069__auto__);

return statearr_129938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_129971){
var state_val_129972 = (state_129971[(1)]);
if((state_val_129972 === (1))){
var state_129971__$1 = state_129971;
var statearr_129973_129985 = state_129971__$1;
(statearr_129973_129985[(2)] = null);

(statearr_129973_129985[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129972 === (2))){
var inst_129969 = (state_129971[(2)]);
var state_129971__$1 = state_129971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_129971__$1,inst_129969);
} else {
if((state_val_129972 === (3))){
var inst_129948 = (state_129971[(2)]);
var state_129971__$1 = state_129971;
var statearr_129974_129986 = state_129971__$1;
(statearr_129974_129986[(2)] = inst_129948);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129971__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129972 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_129971,(3),Error,null,(2));
var inst_129952 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_129971__$1 = state_129971;
if(inst_129952){
var statearr_129975_129987 = state_129971__$1;
(statearr_129975_129987[(1)] = (5));

} else {
var statearr_129976_129988 = state_129971__$1;
(statearr_129976_129988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129972 === (5))){
var state_129971__$1 = state_129971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_129971__$1,(8),n);
} else {
if((state_val_129972 === (6))){
var state_129971__$1 = state_129971;
var statearr_129977_129989 = state_129971__$1;
(statearr_129977_129989[(2)] = n);

(statearr_129977_129989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129972 === (7))){
var inst_129959 = (state_129971[(2)]);
var inst_129960 = fluree.db.dbfunctions.internal.inc.call(null,inst_129959);
var inst_129961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_129962 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_129963 = ["inc",inst_129959,inst_129960];
var inst_129964 = cljs.core.PersistentHashMap.fromArrays(inst_129962,inst_129963);
var inst_129965 = [inst_129964,(10)];
var inst_129966 = (new cljs.core.PersistentVector(null,2,(5),inst_129961,inst_129965,null));
var inst_129967 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_129966);
var state_129971__$1 = (function (){var statearr_129978 = state_129971;
(statearr_129978[(7)] = inst_129967);

return statearr_129978;
})();
var statearr_129979_129990 = state_129971__$1;
(statearr_129979_129990[(2)] = inst_129960);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129971__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_129972 === (8))){
var inst_129955 = (state_129971[(2)]);
var inst_129956 = fluree.db.util.async.throw_err.call(null,inst_129955);
var state_129971__$1 = state_129971;
var statearr_129980_129991 = state_129971__$1;
(statearr_129980_129991[(2)] = inst_129956);

(statearr_129980_129991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____0 = (function (){
var statearr_129981 = [null,null,null,null,null,null,null,null];
(statearr_129981[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__);

(statearr_129981[(1)] = (1));

return statearr_129981;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____1 = (function (state_129971){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_129971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e129982){if((e129982 instanceof Object)){
var ex__99978__auto__ = e129982;
var statearr_129983_129992 = state_129971;
(statearr_129983_129992[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_129971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e129982;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__129993 = state_129971;
state_129971 = G__129993;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__ = function(state_129971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____1.call(this,state_129971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_129984 = f__100070__auto__.call(null);
(statearr_129984[(6)] = c__100069__auto__);

return statearr_129984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130017){
var state_val_130018 = (state_130017[(1)]);
if((state_val_130018 === (1))){
var state_130017__$1 = state_130017;
var statearr_130019_130031 = state_130017__$1;
(statearr_130019_130031[(2)] = null);

(statearr_130019_130031[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130018 === (2))){
var inst_130015 = (state_130017[(2)]);
var state_130017__$1 = state_130017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130017__$1,inst_130015);
} else {
if((state_val_130018 === (3))){
var inst_129994 = (state_130017[(2)]);
var state_130017__$1 = state_130017;
var statearr_130020_130032 = state_130017__$1;
(statearr_130020_130032[(2)] = inst_129994);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130017__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130018 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130017,(3),Error,null,(2));
var inst_129998 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_130017__$1 = state_130017;
if(inst_129998){
var statearr_130021_130033 = state_130017__$1;
(statearr_130021_130033[(1)] = (5));

} else {
var statearr_130022_130034 = state_130017__$1;
(statearr_130022_130034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130018 === (5))){
var state_130017__$1 = state_130017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130017__$1,(8),n);
} else {
if((state_val_130018 === (6))){
var state_130017__$1 = state_130017;
var statearr_130023_130035 = state_130017__$1;
(statearr_130023_130035[(2)] = n);

(statearr_130023_130035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130018 === (7))){
var inst_130005 = (state_130017[(2)]);
var inst_130006 = fluree.db.dbfunctions.internal.dec.call(null,inst_130005);
var inst_130007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130008 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130009 = ["dec",inst_130005,inst_130006];
var inst_130010 = cljs.core.PersistentHashMap.fromArrays(inst_130008,inst_130009);
var inst_130011 = [inst_130010,(10)];
var inst_130012 = (new cljs.core.PersistentVector(null,2,(5),inst_130007,inst_130011,null));
var inst_130013 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130012);
var state_130017__$1 = (function (){var statearr_130024 = state_130017;
(statearr_130024[(7)] = inst_130013);

return statearr_130024;
})();
var statearr_130025_130036 = state_130017__$1;
(statearr_130025_130036[(2)] = inst_130006);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130017__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130018 === (8))){
var inst_130001 = (state_130017[(2)]);
var inst_130002 = fluree.db.util.async.throw_err.call(null,inst_130001);
var state_130017__$1 = state_130017;
var statearr_130026_130037 = state_130017__$1;
(statearr_130026_130037[(2)] = inst_130002);

(statearr_130026_130037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____0 = (function (){
var statearr_130027 = [null,null,null,null,null,null,null,null];
(statearr_130027[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__);

(statearr_130027[(1)] = (1));

return statearr_130027;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____1 = (function (state_130017){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130028){if((e130028 instanceof Object)){
var ex__99978__auto__ = e130028;
var statearr_130029_130038 = state_130017;
(statearr_130029_130038[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130028;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130039 = state_130017;
state_130017 = G__130039;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__ = function(state_130017){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____1.call(this,state_130017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130030 = f__100070__auto__.call(null);
(statearr_130030[(6)] = c__100069__auto__);

return statearr_130030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___130079 = arguments.length;
var i__4737__auto___130080 = (0);
while(true){
if((i__4737__auto___130080 < len__4736__auto___130079)){
args__4742__auto__.push((arguments[i__4737__auto___130080]));

var G__130081 = (i__4737__auto___130080 + (1));
i__4737__auto___130080 = G__130081;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130069){
var state_val_130070 = (state_130069[(1)]);
if((state_val_130070 === (1))){
var state_130069__$1 = state_130069;
var statearr_130071_130082 = state_130069__$1;
(statearr_130071_130082[(2)] = null);

(statearr_130071_130082[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130070 === (2))){
var inst_130067 = (state_130069[(2)]);
var state_130069__$1 = state_130069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130069__$1,inst_130067);
} else {
if((state_val_130070 === (3))){
var inst_130042 = (state_130069[(2)]);
var state_130069__$1 = state_130069;
var statearr_130072_130083 = state_130069__$1;
(statearr_130072_130083[(2)] = inst_130042);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130069__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130070 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130069,(3),Error,null,(2));
var inst_130046 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_130069__$1 = state_130069;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130069__$1,(5),inst_130046);
} else {
if((state_val_130070 === (5))){
var inst_130048 = (state_130069[(2)]);
var inst_130049 = fluree.db.util.async.throw_err.call(null,inst_130048);
var inst_130050 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_130049);
var inst_130051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130052 = [inst_130049];
var inst_130053 = (new cljs.core.PersistentVector(null,1,(5),inst_130051,inst_130052,null));
var inst_130054 = cljs.core.count.call(null,inst_130053);
var inst_130055 = ((9) + inst_130054);
var inst_130056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130057 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130059 = [inst_130049];
var inst_130060 = (new cljs.core.PersistentVector(null,1,(5),inst_130058,inst_130059,null));
var inst_130061 = ["+",inst_130060,inst_130050];
var inst_130062 = cljs.core.PersistentHashMap.fromArrays(inst_130057,inst_130061);
var inst_130063 = [inst_130062,inst_130055];
var inst_130064 = (new cljs.core.PersistentVector(null,2,(5),inst_130056,inst_130063,null));
var inst_130065 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130064);
var state_130069__$1 = (function (){var statearr_130073 = state_130069;
(statearr_130073[(7)] = inst_130065);

return statearr_130073;
})();
var statearr_130074_130084 = state_130069__$1;
(statearr_130074_130084[(2)] = inst_130050);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130069__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_130075 = [null,null,null,null,null,null,null,null];
(statearr_130075[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_130075[(1)] = (1));

return statearr_130075;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_130069){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130076){if((e130076 instanceof Object)){
var ex__99978__auto__ = e130076;
var statearr_130077_130085 = state_130069;
(statearr_130077_130085[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130069);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130076;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130086 = state_130069;
state_130069 = G__130086;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_130069){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_130069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130078 = f__100070__auto__.call(null);
(statearr_130078[(6)] = c__100069__auto__);

return statearr_130078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq130040){
var G__130041 = cljs.core.first.call(null,seq130040);
var seq130040__$1 = cljs.core.next.call(null,seq130040);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__130041,seq130040__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___130126 = arguments.length;
var i__4737__auto___130127 = (0);
while(true){
if((i__4737__auto___130127 < len__4736__auto___130126)){
args__4742__auto__.push((arguments[i__4737__auto___130127]));

var G__130128 = (i__4737__auto___130127 + (1));
i__4737__auto___130127 = G__130128;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130116){
var state_val_130117 = (state_130116[(1)]);
if((state_val_130117 === (1))){
var state_130116__$1 = state_130116;
var statearr_130118_130129 = state_130116__$1;
(statearr_130118_130129[(2)] = null);

(statearr_130118_130129[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130117 === (2))){
var inst_130114 = (state_130116[(2)]);
var state_130116__$1 = state_130116;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130116__$1,inst_130114);
} else {
if((state_val_130117 === (3))){
var inst_130089 = (state_130116[(2)]);
var state_130116__$1 = state_130116;
var statearr_130119_130130 = state_130116__$1;
(statearr_130119_130130[(2)] = inst_130089);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130116__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130117 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130116,(3),Error,null,(2));
var inst_130093 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_130116__$1 = state_130116;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130116__$1,(5),inst_130093);
} else {
if((state_val_130117 === (5))){
var inst_130095 = (state_130116[(2)]);
var inst_130096 = fluree.db.util.async.throw_err.call(null,inst_130095);
var inst_130097 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_130096);
var inst_130098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130099 = [inst_130096];
var inst_130100 = (new cljs.core.PersistentVector(null,1,(5),inst_130098,inst_130099,null));
var inst_130101 = cljs.core.count.call(null,inst_130100);
var inst_130102 = ((9) + inst_130101);
var inst_130103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130106 = [inst_130096];
var inst_130107 = (new cljs.core.PersistentVector(null,1,(5),inst_130105,inst_130106,null));
var inst_130108 = ["-",inst_130107,inst_130097];
var inst_130109 = cljs.core.PersistentHashMap.fromArrays(inst_130104,inst_130108);
var inst_130110 = [inst_130109,inst_130102];
var inst_130111 = (new cljs.core.PersistentVector(null,2,(5),inst_130103,inst_130110,null));
var inst_130112 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130111);
var state_130116__$1 = (function (){var statearr_130120 = state_130116;
(statearr_130120[(7)] = inst_130112);

return statearr_130120;
})();
var statearr_130121_130131 = state_130116__$1;
(statearr_130121_130131[(2)] = inst_130097);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130116__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_130122 = [null,null,null,null,null,null,null,null];
(statearr_130122[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_130122[(1)] = (1));

return statearr_130122;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_130116){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130116);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130123){if((e130123 instanceof Object)){
var ex__99978__auto__ = e130123;
var statearr_130124_130132 = state_130116;
(statearr_130124_130132[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130116);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130133 = state_130116;
state_130116 = G__130133;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_130116){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_130116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130125 = f__100070__auto__.call(null);
(statearr_130125[(6)] = c__100069__auto__);

return statearr_130125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq130087){
var G__130088 = cljs.core.first.call(null,seq130087);
var seq130087__$1 = cljs.core.next.call(null,seq130087);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__130088,seq130087__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___130173 = arguments.length;
var i__4737__auto___130174 = (0);
while(true){
if((i__4737__auto___130174 < len__4736__auto___130173)){
args__4742__auto__.push((arguments[i__4737__auto___130174]));

var G__130175 = (i__4737__auto___130174 + (1));
i__4737__auto___130174 = G__130175;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130163){
var state_val_130164 = (state_130163[(1)]);
if((state_val_130164 === (1))){
var state_130163__$1 = state_130163;
var statearr_130165_130176 = state_130163__$1;
(statearr_130165_130176[(2)] = null);

(statearr_130165_130176[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130164 === (2))){
var inst_130161 = (state_130163[(2)]);
var state_130163__$1 = state_130163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130163__$1,inst_130161);
} else {
if((state_val_130164 === (3))){
var inst_130136 = (state_130163[(2)]);
var state_130163__$1 = state_130163;
var statearr_130166_130177 = state_130163__$1;
(statearr_130166_130177[(2)] = inst_130136);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130163__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130164 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130163,(3),Error,null,(2));
var inst_130140 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_130163__$1 = state_130163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130163__$1,(5),inst_130140);
} else {
if((state_val_130164 === (5))){
var inst_130142 = (state_130163[(2)]);
var inst_130143 = fluree.db.util.async.throw_err.call(null,inst_130142);
var inst_130144 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_130143);
var inst_130145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130146 = [inst_130143];
var inst_130147 = (new cljs.core.PersistentVector(null,1,(5),inst_130145,inst_130146,null));
var inst_130148 = cljs.core.count.call(null,inst_130147);
var inst_130149 = ((9) + inst_130148);
var inst_130150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130151 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130153 = [inst_130143];
var inst_130154 = (new cljs.core.PersistentVector(null,1,(5),inst_130152,inst_130153,null));
var inst_130155 = ["*",inst_130154,inst_130144];
var inst_130156 = cljs.core.PersistentHashMap.fromArrays(inst_130151,inst_130155);
var inst_130157 = [inst_130156,inst_130149];
var inst_130158 = (new cljs.core.PersistentVector(null,2,(5),inst_130150,inst_130157,null));
var inst_130159 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130158);
var state_130163__$1 = (function (){var statearr_130167 = state_130163;
(statearr_130167[(7)] = inst_130159);

return statearr_130167;
})();
var statearr_130168_130178 = state_130163__$1;
(statearr_130168_130178[(2)] = inst_130144);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130163__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_130169 = [null,null,null,null,null,null,null,null];
(statearr_130169[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_130169[(1)] = (1));

return statearr_130169;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_130163){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130170){if((e130170 instanceof Object)){
var ex__99978__auto__ = e130170;
var statearr_130171_130179 = state_130163;
(statearr_130171_130179[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130180 = state_130163;
state_130163 = G__130180;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_130163){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_130163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130172 = f__100070__auto__.call(null);
(statearr_130172[(6)] = c__100069__auto__);

return statearr_130172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq130134){
var G__130135 = cljs.core.first.call(null,seq130134);
var seq130134__$1 = cljs.core.next.call(null,seq130134);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__130135,seq130134__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___130220 = arguments.length;
var i__4737__auto___130221 = (0);
while(true){
if((i__4737__auto___130221 < len__4736__auto___130220)){
args__4742__auto__.push((arguments[i__4737__auto___130221]));

var G__130222 = (i__4737__auto___130221 + (1));
i__4737__auto___130221 = G__130222;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130210){
var state_val_130211 = (state_130210[(1)]);
if((state_val_130211 === (1))){
var state_130210__$1 = state_130210;
var statearr_130212_130223 = state_130210__$1;
(statearr_130212_130223[(2)] = null);

(statearr_130212_130223[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130211 === (2))){
var inst_130208 = (state_130210[(2)]);
var state_130210__$1 = state_130210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130210__$1,inst_130208);
} else {
if((state_val_130211 === (3))){
var inst_130183 = (state_130210[(2)]);
var state_130210__$1 = state_130210;
var statearr_130213_130224 = state_130210__$1;
(statearr_130213_130224[(2)] = inst_130183);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130210__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130211 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130210,(3),Error,null,(2));
var inst_130187 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_130210__$1 = state_130210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130210__$1,(5),inst_130187);
} else {
if((state_val_130211 === (5))){
var inst_130189 = (state_130210[(2)]);
var inst_130190 = fluree.db.util.async.throw_err.call(null,inst_130189);
var inst_130191 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_130190);
var inst_130192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130193 = [inst_130190];
var inst_130194 = (new cljs.core.PersistentVector(null,1,(5),inst_130192,inst_130193,null));
var inst_130195 = cljs.core.count.call(null,inst_130194);
var inst_130196 = ((9) + inst_130195);
var inst_130197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130200 = [inst_130190];
var inst_130201 = (new cljs.core.PersistentVector(null,1,(5),inst_130199,inst_130200,null));
var inst_130202 = ["/",inst_130201,inst_130191];
var inst_130203 = cljs.core.PersistentHashMap.fromArrays(inst_130198,inst_130202);
var inst_130204 = [inst_130203,inst_130196];
var inst_130205 = (new cljs.core.PersistentVector(null,2,(5),inst_130197,inst_130204,null));
var inst_130206 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130205);
var state_130210__$1 = (function (){var statearr_130214 = state_130210;
(statearr_130214[(7)] = inst_130206);

return statearr_130214;
})();
var statearr_130215_130225 = state_130210__$1;
(statearr_130215_130225[(2)] = inst_130191);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130210__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_130216 = [null,null,null,null,null,null,null,null];
(statearr_130216[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_130216[(1)] = (1));

return statearr_130216;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_130210){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130217){if((e130217 instanceof Object)){
var ex__99978__auto__ = e130217;
var statearr_130218_130226 = state_130210;
(statearr_130218_130226[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130227 = state_130210;
state_130210 = G__130227;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_130210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_130210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130219 = f__100070__auto__.call(null);
(statearr_130219[(6)] = c__100069__auto__);

return statearr_130219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq130181){
var G__130182 = cljs.core.first.call(null,seq130181);
var seq130181__$1 = cljs.core.next.call(null,seq130181);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__130182,seq130181__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130262){
var state_val_130263 = (state_130262[(1)]);
if((state_val_130263 === (7))){
var inst_130239 = (state_130262[(2)]);
var inst_130240 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_130262__$1 = (function (){var statearr_130264 = state_130262;
(statearr_130264[(7)] = inst_130239);

return statearr_130264;
})();
if(inst_130240){
var statearr_130265_130281 = state_130262__$1;
(statearr_130265_130281[(1)] = (9));

} else {
var statearr_130266_130282 = state_130262__$1;
(statearr_130266_130282[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (1))){
var state_130262__$1 = state_130262;
var statearr_130267_130283 = state_130262__$1;
(statearr_130267_130283[(2)] = null);

(statearr_130267_130283[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130262,(3),Error,null,(2));
var inst_130232 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_130262__$1 = state_130262;
if(inst_130232){
var statearr_130268_130284 = state_130262__$1;
(statearr_130268_130284[(1)] = (5));

} else {
var statearr_130269_130285 = state_130262__$1;
(statearr_130269_130285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (6))){
var state_130262__$1 = state_130262;
var statearr_130270_130286 = state_130262__$1;
(statearr_130270_130286[(2)] = n);

(statearr_130270_130286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (3))){
var inst_130228 = (state_130262[(2)]);
var state_130262__$1 = state_130262;
var statearr_130271_130287 = state_130262__$1;
(statearr_130271_130287[(2)] = inst_130228);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130262__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (12))){
var inst_130243 = (state_130262[(2)]);
var inst_130244 = fluree.db.util.async.throw_err.call(null,inst_130243);
var state_130262__$1 = state_130262;
var statearr_130272_130288 = state_130262__$1;
(statearr_130272_130288[(2)] = inst_130244);

(statearr_130272_130288[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (2))){
var inst_130260 = (state_130262[(2)]);
var state_130262__$1 = state_130262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130262__$1,inst_130260);
} else {
if((state_val_130263 === (11))){
var inst_130239 = (state_130262[(7)]);
var inst_130247 = (state_130262[(2)]);
var inst_130248 = fluree.db.dbfunctions.internal.quot.call(null,inst_130239,inst_130247);
var inst_130249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130250 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130252 = [inst_130239,inst_130247];
var inst_130253 = (new cljs.core.PersistentVector(null,2,(5),inst_130251,inst_130252,null));
var inst_130254 = ["quot",inst_130253,inst_130248];
var inst_130255 = cljs.core.PersistentHashMap.fromArrays(inst_130250,inst_130254);
var inst_130256 = [inst_130255,(2)];
var inst_130257 = (new cljs.core.PersistentVector(null,2,(5),inst_130249,inst_130256,null));
var inst_130258 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130257);
var state_130262__$1 = (function (){var statearr_130273 = state_130262;
(statearr_130273[(8)] = inst_130258);

return statearr_130273;
})();
var statearr_130274_130289 = state_130262__$1;
(statearr_130274_130289[(2)] = inst_130248);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130262__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (9))){
var state_130262__$1 = state_130262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130262__$1,(12),d);
} else {
if((state_val_130263 === (5))){
var state_130262__$1 = state_130262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130262__$1,(8),n);
} else {
if((state_val_130263 === (10))){
var state_130262__$1 = state_130262;
var statearr_130275_130290 = state_130262__$1;
(statearr_130275_130290[(2)] = d);

(statearr_130275_130290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130263 === (8))){
var inst_130235 = (state_130262[(2)]);
var inst_130236 = fluree.db.util.async.throw_err.call(null,inst_130235);
var state_130262__$1 = state_130262;
var statearr_130276_130291 = state_130262__$1;
(statearr_130276_130291[(2)] = inst_130236);

(statearr_130276_130291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____0 = (function (){
var statearr_130277 = [null,null,null,null,null,null,null,null,null];
(statearr_130277[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__);

(statearr_130277[(1)] = (1));

return statearr_130277;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____1 = (function (state_130262){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130278){if((e130278 instanceof Object)){
var ex__99978__auto__ = e130278;
var statearr_130279_130292 = state_130262;
(statearr_130279_130292[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130293 = state_130262;
state_130262 = G__130293;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__ = function(state_130262){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____1.call(this,state_130262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130280 = f__100070__auto__.call(null);
(statearr_130280[(6)] = c__100069__auto__);

return statearr_130280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130328){
var state_val_130329 = (state_130328[(1)]);
if((state_val_130329 === (7))){
var inst_130305 = (state_130328[(2)]);
var inst_130306 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_130328__$1 = (function (){var statearr_130330 = state_130328;
(statearr_130330[(7)] = inst_130305);

return statearr_130330;
})();
if(inst_130306){
var statearr_130331_130347 = state_130328__$1;
(statearr_130331_130347[(1)] = (9));

} else {
var statearr_130332_130348 = state_130328__$1;
(statearr_130332_130348[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (1))){
var state_130328__$1 = state_130328;
var statearr_130333_130349 = state_130328__$1;
(statearr_130333_130349[(2)] = null);

(statearr_130333_130349[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130328,(3),Error,null,(2));
var inst_130298 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_130328__$1 = state_130328;
if(inst_130298){
var statearr_130334_130350 = state_130328__$1;
(statearr_130334_130350[(1)] = (5));

} else {
var statearr_130335_130351 = state_130328__$1;
(statearr_130335_130351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (6))){
var state_130328__$1 = state_130328;
var statearr_130336_130352 = state_130328__$1;
(statearr_130336_130352[(2)] = n);

(statearr_130336_130352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (3))){
var inst_130294 = (state_130328[(2)]);
var state_130328__$1 = state_130328;
var statearr_130337_130353 = state_130328__$1;
(statearr_130337_130353[(2)] = inst_130294);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130328__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (12))){
var inst_130309 = (state_130328[(2)]);
var inst_130310 = fluree.db.util.async.throw_err.call(null,inst_130309);
var state_130328__$1 = state_130328;
var statearr_130338_130354 = state_130328__$1;
(statearr_130338_130354[(2)] = inst_130310);

(statearr_130338_130354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (2))){
var inst_130326 = (state_130328[(2)]);
var state_130328__$1 = state_130328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130328__$1,inst_130326);
} else {
if((state_val_130329 === (11))){
var inst_130305 = (state_130328[(7)]);
var inst_130313 = (state_130328[(2)]);
var inst_130314 = fluree.db.dbfunctions.internal.mod.call(null,inst_130305,inst_130313);
var inst_130315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130316 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130318 = [inst_130305,inst_130313];
var inst_130319 = (new cljs.core.PersistentVector(null,2,(5),inst_130317,inst_130318,null));
var inst_130320 = ["mod",inst_130319,inst_130314];
var inst_130321 = cljs.core.PersistentHashMap.fromArrays(inst_130316,inst_130320);
var inst_130322 = [inst_130321,(2)];
var inst_130323 = (new cljs.core.PersistentVector(null,2,(5),inst_130315,inst_130322,null));
var inst_130324 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130323);
var state_130328__$1 = (function (){var statearr_130339 = state_130328;
(statearr_130339[(8)] = inst_130324);

return statearr_130339;
})();
var statearr_130340_130355 = state_130328__$1;
(statearr_130340_130355[(2)] = inst_130314);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130328__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (9))){
var state_130328__$1 = state_130328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130328__$1,(12),d);
} else {
if((state_val_130329 === (5))){
var state_130328__$1 = state_130328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130328__$1,(8),n);
} else {
if((state_val_130329 === (10))){
var state_130328__$1 = state_130328;
var statearr_130341_130356 = state_130328__$1;
(statearr_130341_130356[(2)] = d);

(statearr_130341_130356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130329 === (8))){
var inst_130301 = (state_130328[(2)]);
var inst_130302 = fluree.db.util.async.throw_err.call(null,inst_130301);
var state_130328__$1 = state_130328;
var statearr_130342_130357 = state_130328__$1;
(statearr_130342_130357[(2)] = inst_130302);

(statearr_130342_130357[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____0 = (function (){
var statearr_130343 = [null,null,null,null,null,null,null,null,null];
(statearr_130343[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__);

(statearr_130343[(1)] = (1));

return statearr_130343;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____1 = (function (state_130328){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130344){if((e130344 instanceof Object)){
var ex__99978__auto__ = e130344;
var statearr_130345_130358 = state_130328;
(statearr_130345_130358[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130359 = state_130328;
state_130328 = G__130359;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__ = function(state_130328){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____1.call(this,state_130328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130346 = f__100070__auto__.call(null);
(statearr_130346[(6)] = c__100069__auto__);

return statearr_130346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130394){
var state_val_130395 = (state_130394[(1)]);
if((state_val_130395 === (7))){
var inst_130371 = (state_130394[(2)]);
var inst_130372 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_130394__$1 = (function (){var statearr_130396 = state_130394;
(statearr_130396[(7)] = inst_130371);

return statearr_130396;
})();
if(inst_130372){
var statearr_130397_130413 = state_130394__$1;
(statearr_130397_130413[(1)] = (9));

} else {
var statearr_130398_130414 = state_130394__$1;
(statearr_130398_130414[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (1))){
var state_130394__$1 = state_130394;
var statearr_130399_130415 = state_130394__$1;
(statearr_130399_130415[(2)] = null);

(statearr_130399_130415[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130394,(3),Error,null,(2));
var inst_130364 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_130394__$1 = state_130394;
if(inst_130364){
var statearr_130400_130416 = state_130394__$1;
(statearr_130400_130416[(1)] = (5));

} else {
var statearr_130401_130417 = state_130394__$1;
(statearr_130401_130417[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (6))){
var state_130394__$1 = state_130394;
var statearr_130402_130418 = state_130394__$1;
(statearr_130402_130418[(2)] = n);

(statearr_130402_130418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (3))){
var inst_130360 = (state_130394[(2)]);
var state_130394__$1 = state_130394;
var statearr_130403_130419 = state_130394__$1;
(statearr_130403_130419[(2)] = inst_130360);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130394__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (12))){
var inst_130375 = (state_130394[(2)]);
var inst_130376 = fluree.db.util.async.throw_err.call(null,inst_130375);
var state_130394__$1 = state_130394;
var statearr_130404_130420 = state_130394__$1;
(statearr_130404_130420[(2)] = inst_130376);

(statearr_130404_130420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (2))){
var inst_130392 = (state_130394[(2)]);
var state_130394__$1 = state_130394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130394__$1,inst_130392);
} else {
if((state_val_130395 === (11))){
var inst_130371 = (state_130394[(7)]);
var inst_130379 = (state_130394[(2)]);
var inst_130380 = fluree.db.dbfunctions.internal.rem.call(null,inst_130371,inst_130379);
var inst_130381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130384 = [inst_130371,inst_130379];
var inst_130385 = (new cljs.core.PersistentVector(null,2,(5),inst_130383,inst_130384,null));
var inst_130386 = ["rem",inst_130385,inst_130380];
var inst_130387 = cljs.core.PersistentHashMap.fromArrays(inst_130382,inst_130386);
var inst_130388 = [inst_130387,(2)];
var inst_130389 = (new cljs.core.PersistentVector(null,2,(5),inst_130381,inst_130388,null));
var inst_130390 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130389);
var state_130394__$1 = (function (){var statearr_130405 = state_130394;
(statearr_130405[(8)] = inst_130390);

return statearr_130405;
})();
var statearr_130406_130421 = state_130394__$1;
(statearr_130406_130421[(2)] = inst_130380);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130394__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (9))){
var state_130394__$1 = state_130394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130394__$1,(12),d);
} else {
if((state_val_130395 === (5))){
var state_130394__$1 = state_130394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130394__$1,(8),n);
} else {
if((state_val_130395 === (10))){
var state_130394__$1 = state_130394;
var statearr_130407_130422 = state_130394__$1;
(statearr_130407_130422[(2)] = d);

(statearr_130407_130422[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130395 === (8))){
var inst_130367 = (state_130394[(2)]);
var inst_130368 = fluree.db.util.async.throw_err.call(null,inst_130367);
var state_130394__$1 = state_130394;
var statearr_130408_130423 = state_130394__$1;
(statearr_130408_130423[(2)] = inst_130368);

(statearr_130408_130423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____0 = (function (){
var statearr_130409 = [null,null,null,null,null,null,null,null,null];
(statearr_130409[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__);

(statearr_130409[(1)] = (1));

return statearr_130409;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____1 = (function (state_130394){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130410){if((e130410 instanceof Object)){
var ex__99978__auto__ = e130410;
var statearr_130411_130424 = state_130394;
(statearr_130411_130424[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130394);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130410;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130425 = state_130394;
state_130394 = G__130425;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__ = function(state_130394){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____1.call(this,state_130394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130412 = f__100070__auto__.call(null);
(statearr_130412[(6)] = c__100069__auto__);

return statearr_130412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130449){
var state_val_130450 = (state_130449[(1)]);
if((state_val_130450 === (1))){
var state_130449__$1 = state_130449;
var statearr_130451_130463 = state_130449__$1;
(statearr_130451_130463[(2)] = null);

(statearr_130451_130463[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130450 === (2))){
var inst_130447 = (state_130449[(2)]);
var state_130449__$1 = state_130449;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130449__$1,inst_130447);
} else {
if((state_val_130450 === (3))){
var inst_130426 = (state_130449[(2)]);
var state_130449__$1 = state_130449;
var statearr_130452_130464 = state_130449__$1;
(statearr_130452_130464[(2)] = inst_130426);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130449__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130450 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130449,(3),Error,null,(2));
var inst_130430 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_130449__$1 = state_130449;
if(inst_130430){
var statearr_130453_130465 = state_130449__$1;
(statearr_130453_130465[(1)] = (5));

} else {
var statearr_130454_130466 = state_130449__$1;
(statearr_130454_130466[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130450 === (5))){
var state_130449__$1 = state_130449;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130449__$1,(8),x);
} else {
if((state_val_130450 === (6))){
var state_130449__$1 = state_130449;
var statearr_130455_130467 = state_130449__$1;
(statearr_130455_130467[(2)] = x);

(statearr_130455_130467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130450 === (7))){
var inst_130437 = (state_130449[(2)]);
var inst_130438 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_130437);
var inst_130439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130440 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130441 = ["boolean",inst_130437,inst_130438];
var inst_130442 = cljs.core.PersistentHashMap.fromArrays(inst_130440,inst_130441);
var inst_130443 = [inst_130442,(10)];
var inst_130444 = (new cljs.core.PersistentVector(null,2,(5),inst_130439,inst_130443,null));
var inst_130445 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130444);
var state_130449__$1 = (function (){var statearr_130456 = state_130449;
(statearr_130456[(7)] = inst_130445);

return statearr_130456;
})();
var statearr_130457_130468 = state_130449__$1;
(statearr_130457_130468[(2)] = inst_130438);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130449__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130450 === (8))){
var inst_130433 = (state_130449[(2)]);
var inst_130434 = fluree.db.util.async.throw_err.call(null,inst_130433);
var state_130449__$1 = state_130449;
var statearr_130458_130469 = state_130449__$1;
(statearr_130458_130469[(2)] = inst_130434);

(statearr_130458_130469[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____0 = (function (){
var statearr_130459 = [null,null,null,null,null,null,null,null];
(statearr_130459[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__);

(statearr_130459[(1)] = (1));

return statearr_130459;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____1 = (function (state_130449){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130449);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130460){if((e130460 instanceof Object)){
var ex__99978__auto__ = e130460;
var statearr_130461_130470 = state_130449;
(statearr_130461_130470[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130449);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130460;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130471 = state_130449;
state_130449 = G__130471;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__ = function(state_130449){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____1.call(this,state_130449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130462 = f__100070__auto__.call(null);
(statearr_130462[(6)] = c__100069__auto__);

return statearr_130462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130506){
var state_val_130507 = (state_130506[(1)]);
if((state_val_130507 === (7))){
var inst_130483 = (state_130506[(2)]);
var inst_130484 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_130506__$1 = (function (){var statearr_130508 = state_130506;
(statearr_130508[(7)] = inst_130483);

return statearr_130508;
})();
if(inst_130484){
var statearr_130509_130525 = state_130506__$1;
(statearr_130509_130525[(1)] = (9));

} else {
var statearr_130510_130526 = state_130506__$1;
(statearr_130510_130526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (1))){
var state_130506__$1 = state_130506;
var statearr_130511_130527 = state_130506__$1;
(statearr_130511_130527[(2)] = null);

(statearr_130511_130527[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130506,(3),Error,null,(2));
var inst_130476 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_130506__$1 = state_130506;
if(inst_130476){
var statearr_130512_130528 = state_130506__$1;
(statearr_130512_130528[(1)] = (5));

} else {
var statearr_130513_130529 = state_130506__$1;
(statearr_130513_130529[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (6))){
var state_130506__$1 = state_130506;
var statearr_130514_130530 = state_130506__$1;
(statearr_130514_130530[(2)] = pattern);

(statearr_130514_130530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (3))){
var inst_130472 = (state_130506[(2)]);
var state_130506__$1 = state_130506;
var statearr_130515_130531 = state_130506__$1;
(statearr_130515_130531[(2)] = inst_130472);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130506__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (12))){
var inst_130487 = (state_130506[(2)]);
var inst_130488 = fluree.db.util.async.throw_err.call(null,inst_130487);
var state_130506__$1 = state_130506;
var statearr_130516_130532 = state_130506__$1;
(statearr_130516_130532[(2)] = inst_130488);

(statearr_130516_130532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (2))){
var inst_130504 = (state_130506[(2)]);
var state_130506__$1 = state_130506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130506__$1,inst_130504);
} else {
if((state_val_130507 === (11))){
var inst_130483 = (state_130506[(7)]);
var inst_130491 = (state_130506[(2)]);
var inst_130492 = fluree.db.dbfunctions.internal.re_find.call(null,inst_130483,inst_130491);
var inst_130493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130494 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130496 = [inst_130483,inst_130491];
var inst_130497 = (new cljs.core.PersistentVector(null,2,(5),inst_130495,inst_130496,null));
var inst_130498 = ["re-find",inst_130497,inst_130492];
var inst_130499 = cljs.core.PersistentHashMap.fromArrays(inst_130494,inst_130498);
var inst_130500 = [inst_130499,(10)];
var inst_130501 = (new cljs.core.PersistentVector(null,2,(5),inst_130493,inst_130500,null));
var inst_130502 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130501);
var state_130506__$1 = (function (){var statearr_130517 = state_130506;
(statearr_130517[(8)] = inst_130502);

return statearr_130517;
})();
var statearr_130518_130533 = state_130506__$1;
(statearr_130518_130533[(2)] = inst_130492);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130506__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (9))){
var state_130506__$1 = state_130506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130506__$1,(12),string);
} else {
if((state_val_130507 === (5))){
var state_130506__$1 = state_130506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130506__$1,(8),pattern);
} else {
if((state_val_130507 === (10))){
var state_130506__$1 = state_130506;
var statearr_130519_130534 = state_130506__$1;
(statearr_130519_130534[(2)] = string);

(statearr_130519_130534[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130507 === (8))){
var inst_130479 = (state_130506[(2)]);
var inst_130480 = fluree.db.util.async.throw_err.call(null,inst_130479);
var state_130506__$1 = state_130506;
var statearr_130520_130535 = state_130506__$1;
(statearr_130520_130535[(2)] = inst_130480);

(statearr_130520_130535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____0 = (function (){
var statearr_130521 = [null,null,null,null,null,null,null,null,null];
(statearr_130521[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__);

(statearr_130521[(1)] = (1));

return statearr_130521;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____1 = (function (state_130506){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130522){if((e130522 instanceof Object)){
var ex__99978__auto__ = e130522;
var statearr_130523_130536 = state_130506;
(statearr_130523_130536[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130522;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130537 = state_130506;
state_130506 = G__130537;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__ = function(state_130506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____1.call(this,state_130506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130524 = f__100070__auto__.call(null);
(statearr_130524[(6)] = c__100069__auto__);

return statearr_130524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130561){
var state_val_130562 = (state_130561[(1)]);
if((state_val_130562 === (1))){
var state_130561__$1 = state_130561;
var statearr_130563_130575 = state_130561__$1;
(statearr_130563_130575[(2)] = null);

(statearr_130563_130575[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130562 === (2))){
var inst_130559 = (state_130561[(2)]);
var state_130561__$1 = state_130561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130561__$1,inst_130559);
} else {
if((state_val_130562 === (3))){
var inst_130538 = (state_130561[(2)]);
var state_130561__$1 = state_130561;
var statearr_130564_130576 = state_130561__$1;
(statearr_130564_130576[(2)] = inst_130538);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130561__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130562 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130561,(3),Error,null,(2));
var inst_130542 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_130561__$1 = state_130561;
if(inst_130542){
var statearr_130565_130577 = state_130561__$1;
(statearr_130565_130577[(1)] = (5));

} else {
var statearr_130566_130578 = state_130561__$1;
(statearr_130566_130578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130562 === (5))){
var state_130561__$1 = state_130561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130561__$1,(8),email);
} else {
if((state_val_130562 === (6))){
var state_130561__$1 = state_130561;
var statearr_130567_130579 = state_130561__$1;
(statearr_130567_130579[(2)] = email);

(statearr_130567_130579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130562 === (7))){
var inst_130549 = (state_130561[(2)]);
var inst_130550 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_130549);
var inst_130551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130552 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130553 = ["re-find",inst_130549,inst_130550];
var inst_130554 = cljs.core.PersistentHashMap.fromArrays(inst_130552,inst_130553);
var inst_130555 = [inst_130554,(10)];
var inst_130556 = (new cljs.core.PersistentVector(null,2,(5),inst_130551,inst_130555,null));
var inst_130557 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130556);
var state_130561__$1 = (function (){var statearr_130568 = state_130561;
(statearr_130568[(7)] = inst_130557);

return statearr_130568;
})();
var statearr_130569_130580 = state_130561__$1;
(statearr_130569_130580[(2)] = inst_130550);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130561__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130562 === (8))){
var inst_130545 = (state_130561[(2)]);
var inst_130546 = fluree.db.util.async.throw_err.call(null,inst_130545);
var state_130561__$1 = state_130561;
var statearr_130570_130581 = state_130561__$1;
(statearr_130570_130581[(2)] = inst_130546);

(statearr_130570_130581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_130571 = [null,null,null,null,null,null,null,null];
(statearr_130571[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__);

(statearr_130571[(1)] = (1));

return statearr_130571;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____1 = (function (state_130561){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130572){if((e130572 instanceof Object)){
var ex__99978__auto__ = e130572;
var statearr_130573_130582 = state_130561;
(statearr_130573_130582[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130583 = state_130561;
state_130561 = G__130583;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__ = function(state_130561){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____1.call(this,state_130561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130574 = f__100070__auto__.call(null);
(statearr_130574[(6)] = c__100069__auto__);

return statearr_130574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130627){
var state_val_130628 = (state_130627[(1)]);
if((state_val_130628 === (7))){
var inst_130613 = (state_130627[(2)]);
var inst_130614 = cljs.core.nth.call(null,inst_130613,(0),null);
var inst_130615 = cljs.core.nth.call(null,inst_130613,(1),null);
var inst_130616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130617 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130618 = ["?user_id","?ctx",inst_130614];
var inst_130619 = cljs.core.PersistentHashMap.fromArrays(inst_130617,inst_130618);
var inst_130620 = ((10) + inst_130615);
var inst_130621 = [inst_130619,inst_130620];
var inst_130622 = (new cljs.core.PersistentVector(null,2,(5),inst_130616,inst_130621,null));
var inst_130623 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130622);
var state_130627__$1 = (function (){var statearr_130629 = state_130627;
(statearr_130629[(7)] = inst_130623);

return statearr_130629;
})();
var statearr_130630_130649 = state_130627__$1;
(statearr_130630_130649[(2)] = inst_130614);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130627__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (1))){
var state_130627__$1 = state_130627;
var statearr_130631_130650 = state_130627__$1;
(statearr_130631_130650[(2)] = null);

(statearr_130631_130650[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130627,(3),Error,null,(2));
var inst_130591 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130627__$1 = state_130627;
if(cljs.core.truth_(inst_130591)){
var statearr_130632_130651 = state_130627__$1;
(statearr_130632_130651[(1)] = (5));

} else {
var statearr_130633_130652 = state_130627__$1;
(statearr_130633_130652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (13))){
var state_130627__$1 = state_130627;
var statearr_130634_130653 = state_130627__$1;
(statearr_130634_130653[(2)] = null);

(statearr_130634_130653[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (6))){
var inst_130598 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130627__$1 = state_130627;
if(cljs.core.truth_(inst_130598)){
var statearr_130635_130654 = state_130627__$1;
(statearr_130635_130654[(1)] = (8));

} else {
var statearr_130636_130655 = state_130627__$1;
(statearr_130636_130655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (3))){
var inst_130584 = (state_130627[(2)]);
var state_130627__$1 = state_130627;
var statearr_130637_130656 = state_130627__$1;
(statearr_130637_130656[(2)] = inst_130584);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130627__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (12))){
var inst_130606 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_130627__$1 = state_130627;
var statearr_130638_130657 = state_130627__$1;
(statearr_130638_130657[(2)] = inst_130606);

(statearr_130638_130657[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (2))){
var inst_130625 = (state_130627[(2)]);
var state_130627__$1 = state_130627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130627__$1,inst_130625);
} else {
if((state_val_130628 === (11))){
var inst_130602 = (state_130627[(2)]);
var inst_130603 = fluree.db.util.async.throw_err.call(null,inst_130602);
var state_130627__$1 = state_130627;
var statearr_130639_130658 = state_130627__$1;
(statearr_130639_130658[(2)] = inst_130603);

(statearr_130639_130658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (9))){
var state_130627__$1 = state_130627;
var statearr_130640_130659 = state_130627__$1;
(statearr_130640_130659[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (5))){
var inst_130593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130594 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_130595 = [inst_130594,(0)];
var inst_130596 = (new cljs.core.PersistentVector(null,2,(5),inst_130593,inst_130595,null));
var state_130627__$1 = state_130627;
var statearr_130642_130660 = state_130627__$1;
(statearr_130642_130660[(2)] = inst_130596);

(statearr_130642_130660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (14))){
var inst_130609 = (state_130627[(2)]);
var state_130627__$1 = state_130627;
var statearr_130643_130661 = state_130627__$1;
(statearr_130643_130661[(2)] = inst_130609);

(statearr_130643_130661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (10))){
var inst_130611 = (state_130627[(2)]);
var state_130627__$1 = state_130627;
var statearr_130644_130662 = state_130627__$1;
(statearr_130644_130662[(2)] = inst_130611);

(statearr_130644_130662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130628 === (8))){
var inst_130600 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_130627__$1 = state_130627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130627__$1,(11),inst_130600);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____0 = (function (){
var statearr_130645 = [null,null,null,null,null,null,null,null];
(statearr_130645[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__);

(statearr_130645[(1)] = (1));

return statearr_130645;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____1 = (function (state_130627){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130646){if((e130646 instanceof Object)){
var ex__99978__auto__ = e130646;
var statearr_130647_130663 = state_130627;
(statearr_130647_130663[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130664 = state_130627;
state_130627 = G__130664;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__ = function(state_130627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____1.call(this,state_130627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130648 = f__100070__auto__.call(null);
(statearr_130648[(6)] = c__100069__auto__);

return statearr_130648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130689){
var state_val_130690 = (state_130689[(1)]);
if((state_val_130690 === (1))){
var state_130689__$1 = state_130689;
var statearr_130691_130703 = state_130689__$1;
(statearr_130691_130703[(2)] = null);

(statearr_130691_130703[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130690 === (2))){
var inst_130687 = (state_130689[(2)]);
var state_130689__$1 = state_130689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130689__$1,inst_130687);
} else {
if((state_val_130690 === (3))){
var inst_130665 = (state_130689[(2)]);
var state_130689__$1 = state_130689;
var statearr_130692_130704 = state_130689__$1;
(statearr_130692_130704[(2)] = inst_130665);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130690 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130689,(3),Error,null,(2));
var inst_130669 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_130689__$1 = state_130689;
if(cljs.core.truth_(inst_130669)){
var statearr_130693_130705 = state_130689__$1;
(statearr_130693_130705[(1)] = (5));

} else {
var statearr_130694_130706 = state_130689__$1;
(statearr_130694_130706[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130690 === (5))){
var inst_130671 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_130689__$1 = state_130689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130689__$1,(8),inst_130671);
} else {
if((state_val_130690 === (6))){
var inst_130683 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_130689__$1 = state_130689;
var statearr_130695_130707 = state_130689__$1;
(statearr_130695_130707[(2)] = inst_130683);

(statearr_130695_130707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130690 === (7))){
var inst_130685 = (state_130689[(2)]);
var state_130689__$1 = state_130689;
var statearr_130696_130708 = state_130689__$1;
(statearr_130696_130708[(2)] = inst_130685);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130690 === (8))){
var inst_130673 = (state_130689[(2)]);
var inst_130674 = fluree.db.util.async.throw_err.call(null,inst_130673);
var inst_130675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130676 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130677 = ["?auth_id","?ctx",inst_130674];
var inst_130678 = cljs.core.PersistentHashMap.fromArrays(inst_130676,inst_130677);
var inst_130679 = [inst_130678,(10)];
var inst_130680 = (new cljs.core.PersistentVector(null,2,(5),inst_130675,inst_130679,null));
var inst_130681 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130680);
var state_130689__$1 = (function (){var statearr_130697 = state_130689;
(statearr_130697[(7)] = inst_130681);

return statearr_130697;
})();
var statearr_130698_130709 = state_130689__$1;
(statearr_130698_130709[(2)] = inst_130674);

(statearr_130698_130709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____0 = (function (){
var statearr_130699 = [null,null,null,null,null,null,null,null];
(statearr_130699[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__);

(statearr_130699[(1)] = (1));

return statearr_130699;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____1 = (function (state_130689){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130700){if((e130700 instanceof Object)){
var ex__99978__auto__ = e130700;
var statearr_130701_130710 = state_130689;
(statearr_130701_130710[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130711 = state_130689;
state_130689 = G__130711;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__ = function(state_130689){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____1.call(this,state_130689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130702 = f__100070__auto__.call(null);
(statearr_130702[(6)] = c__100069__auto__);

return statearr_130702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__130713 = arguments.length;
switch (G__130713) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130752){
var state_val_130753 = (state_130752[(1)]);
if((state_val_130753 === (7))){
var inst_130725 = (state_130752[(2)]);
var inst_130726 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_130752__$1 = (function (){var statearr_130754 = state_130752;
(statearr_130754[(7)] = inst_130725);

return statearr_130754;
})();
if(inst_130726){
var statearr_130755_130777 = state_130752__$1;
(statearr_130755_130777[(1)] = (9));

} else {
var statearr_130756_130778 = state_130752__$1;
(statearr_130756_130778[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (1))){
var state_130752__$1 = state_130752;
var statearr_130757_130779 = state_130752__$1;
(statearr_130757_130779[(2)] = null);

(statearr_130757_130779[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130752,(3),Error,null,(2));
var inst_130718 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_130752__$1 = state_130752;
if(inst_130718){
var statearr_130758_130780 = state_130752__$1;
(statearr_130758_130780[(1)] = (5));

} else {
var statearr_130759_130781 = state_130752__$1;
(statearr_130759_130781[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (15))){
var inst_130725 = (state_130752[(7)]);
var inst_130737 = (state_130752[(2)]);
var inst_130738 = fluree.db.dbfunctions.internal.rand.call(null,inst_130725,inst_130737);
var inst_130739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130740 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130742 = [seed,max];
var inst_130743 = (new cljs.core.PersistentVector(null,2,(5),inst_130741,inst_130742,null));
var inst_130744 = ["rand",inst_130743,inst_130738];
var inst_130745 = cljs.core.PersistentHashMap.fromArrays(inst_130740,inst_130744);
var inst_130746 = [inst_130745,(10)];
var inst_130747 = (new cljs.core.PersistentVector(null,2,(5),inst_130739,inst_130746,null));
var inst_130748 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130747);
var state_130752__$1 = (function (){var statearr_130760 = state_130752;
(statearr_130760[(8)] = inst_130748);

return statearr_130760;
})();
var statearr_130761_130782 = state_130752__$1;
(statearr_130761_130782[(2)] = inst_130738);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130752__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (13))){
var inst_130733 = (state_130752[(9)]);
var state_130752__$1 = state_130752;
var statearr_130762_130783 = state_130752__$1;
(statearr_130762_130783[(2)] = inst_130733);

(statearr_130762_130783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (6))){
var state_130752__$1 = state_130752;
var statearr_130763_130784 = state_130752__$1;
(statearr_130763_130784[(2)] = seed);

(statearr_130763_130784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (3))){
var inst_130714 = (state_130752[(2)]);
var state_130752__$1 = state_130752;
var statearr_130764_130785 = state_130752__$1;
(statearr_130764_130785[(2)] = inst_130714);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130752__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (12))){
var inst_130729 = (state_130752[(2)]);
var inst_130730 = fluree.db.util.async.throw_err.call(null,inst_130729);
var state_130752__$1 = state_130752;
var statearr_130765_130786 = state_130752__$1;
(statearr_130765_130786[(2)] = inst_130730);

(statearr_130765_130786[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (2))){
var inst_130750 = (state_130752[(2)]);
var state_130752__$1 = state_130752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130752__$1,inst_130750);
} else {
if((state_val_130753 === (11))){
var inst_130733 = (state_130752[(9)]);
var inst_130733__$1 = (state_130752[(2)]);
var state_130752__$1 = (function (){var statearr_130766 = state_130752;
(statearr_130766[(9)] = inst_130733__$1);

return statearr_130766;
})();
if(cljs.core.truth_(inst_130733__$1)){
var statearr_130767_130787 = state_130752__$1;
(statearr_130767_130787[(1)] = (13));

} else {
var statearr_130768_130788 = state_130752__$1;
(statearr_130768_130788[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (9))){
var state_130752__$1 = state_130752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130752__$1,(12),max);
} else {
if((state_val_130753 === (5))){
var state_130752__$1 = state_130752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130752__$1,(8),seed);
} else {
if((state_val_130753 === (14))){
var state_130752__$1 = state_130752;
var statearr_130769_130789 = state_130752__$1;
(statearr_130769_130789[(2)] = (10));

(statearr_130769_130789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (10))){
var state_130752__$1 = state_130752;
var statearr_130770_130790 = state_130752__$1;
(statearr_130770_130790[(2)] = max);

(statearr_130770_130790[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130753 === (8))){
var inst_130721 = (state_130752[(2)]);
var inst_130722 = fluree.db.util.async.throw_err.call(null,inst_130721);
var state_130752__$1 = state_130752;
var statearr_130771_130791 = state_130752__$1;
(statearr_130771_130791[(2)] = inst_130722);

(statearr_130771_130791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99975__auto____0 = (function (){
var statearr_130772 = [null,null,null,null,null,null,null,null,null,null];
(statearr_130772[(0)] = fluree$db$dbfunctions$fns$state_machine__99975__auto__);

(statearr_130772[(1)] = (1));

return statearr_130772;
});
var fluree$db$dbfunctions$fns$state_machine__99975__auto____1 = (function (state_130752){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130773){if((e130773 instanceof Object)){
var ex__99978__auto__ = e130773;
var statearr_130774_130792 = state_130752;
(statearr_130774_130792[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130773;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130793 = state_130752;
state_130752 = G__130793;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99975__auto__ = function(state_130752){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99975__auto____1.call(this,state_130752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130775 = f__100070__auto__.call(null);
(statearr_130775[(6)] = c__100069__auto__);

return statearr_130775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130811){
var state_val_130812 = (state_130811[(1)]);
if((state_val_130812 === (1))){
var state_130811__$1 = state_130811;
var statearr_130813_130821 = state_130811__$1;
(statearr_130813_130821[(2)] = null);

(statearr_130813_130821[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130812 === (2))){
var inst_130809 = (state_130811[(2)]);
var state_130811__$1 = state_130811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130811__$1,inst_130809);
} else {
if((state_val_130812 === (3))){
var inst_130794 = (state_130811[(2)]);
var state_130811__$1 = state_130811;
var statearr_130814_130822 = state_130811__$1;
(statearr_130814_130822[(2)] = inst_130794);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130811__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130812 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130811,(3),Error,null,(2));
var inst_130798 = fluree.db.util.core.random_uuid.call(null);
var inst_130799 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_130798);
var inst_130800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130801 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130802 = cljs.core.PersistentVector.EMPTY;
var inst_130803 = ["uuid",inst_130802,inst_130799];
var inst_130804 = cljs.core.PersistentHashMap.fromArrays(inst_130801,inst_130803);
var inst_130805 = [inst_130804,(10)];
var inst_130806 = (new cljs.core.PersistentVector(null,2,(5),inst_130800,inst_130805,null));
var inst_130807 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130806);
var state_130811__$1 = (function (){var statearr_130815 = state_130811;
(statearr_130815[(7)] = inst_130807);

return statearr_130815;
})();
var statearr_130816_130823 = state_130811__$1;
(statearr_130816_130823[(2)] = inst_130799);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130811__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____0 = (function (){
var statearr_130817 = [null,null,null,null,null,null,null,null];
(statearr_130817[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__);

(statearr_130817[(1)] = (1));

return statearr_130817;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____1 = (function (state_130811){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130818){if((e130818 instanceof Object)){
var ex__99978__auto__ = e130818;
var statearr_130819_130824 = state_130811;
(statearr_130819_130824[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130818;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130825 = state_130811;
state_130811 = G__130825;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__ = function(state_130811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____1.call(this,state_130811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130820 = f__100070__auto__.call(null);
(statearr_130820[(6)] = c__100069__auto__);

return statearr_130820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130852){
var state_val_130853 = (state_130852[(1)]);
if((state_val_130853 === (1))){
var state_130852__$1 = state_130852;
var statearr_130854_130866 = state_130852__$1;
(statearr_130854_130866[(2)] = null);

(statearr_130854_130866[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130853 === (2))){
var inst_130850 = (state_130852[(2)]);
var state_130852__$1 = state_130852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130852__$1,inst_130850);
} else {
if((state_val_130853 === (3))){
var inst_130826 = (state_130852[(2)]);
var state_130852__$1 = state_130852;
var statearr_130855_130867 = state_130852__$1;
(statearr_130855_130867[(2)] = inst_130826);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130852__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130853 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130852,(3),Error,null,(2));
var inst_130830 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_130852__$1 = state_130852;
if(inst_130830){
var statearr_130856_130868 = state_130852__$1;
(statearr_130856_130868[(1)] = (5));

} else {
var statearr_130857_130869 = state_130852__$1;
(statearr_130857_130869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130853 === (5))){
var state_130852__$1 = state_130852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130852__$1,(8),num);
} else {
if((state_val_130853 === (6))){
var state_130852__$1 = state_130852;
var statearr_130858_130870 = state_130852__$1;
(statearr_130858_130870[(2)] = num);

(statearr_130858_130870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130853 === (7))){
var inst_130837 = (state_130852[(2)]);
var inst_130838 = fluree.db.dbfunctions.internal.ceil.call(null,inst_130837);
var inst_130839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130840 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130842 = [fluree.db.dbfunctions.fns.ceil];
var inst_130843 = (new cljs.core.PersistentVector(null,1,(5),inst_130841,inst_130842,null));
var inst_130844 = ["",inst_130843,inst_130838];
var inst_130845 = cljs.core.PersistentHashMap.fromArrays(inst_130840,inst_130844);
var inst_130846 = [inst_130845,(10)];
var inst_130847 = (new cljs.core.PersistentVector(null,2,(5),inst_130839,inst_130846,null));
var inst_130848 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130847);
var state_130852__$1 = (function (){var statearr_130859 = state_130852;
(statearr_130859[(7)] = inst_130848);

return statearr_130859;
})();
var statearr_130860_130871 = state_130852__$1;
(statearr_130860_130871[(2)] = inst_130838);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130852__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130853 === (8))){
var inst_130833 = (state_130852[(2)]);
var inst_130834 = fluree.db.util.async.throw_err.call(null,inst_130833);
var state_130852__$1 = state_130852;
var statearr_130861_130872 = state_130852__$1;
(statearr_130861_130872[(2)] = inst_130834);

(statearr_130861_130872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____0 = (function (){
var statearr_130862 = [null,null,null,null,null,null,null,null];
(statearr_130862[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__);

(statearr_130862[(1)] = (1));

return statearr_130862;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____1 = (function (state_130852){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130863){if((e130863 instanceof Object)){
var ex__99978__auto__ = e130863;
var statearr_130864_130873 = state_130852;
(statearr_130864_130873[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130863;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130874 = state_130852;
state_130852 = G__130874;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__ = function(state_130852){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____1.call(this,state_130852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130865 = f__100070__auto__.call(null);
(statearr_130865[(6)] = c__100069__auto__);

return statearr_130865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_130901){
var state_val_130902 = (state_130901[(1)]);
if((state_val_130902 === (1))){
var state_130901__$1 = state_130901;
var statearr_130903_130915 = state_130901__$1;
(statearr_130903_130915[(2)] = null);

(statearr_130903_130915[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130902 === (2))){
var inst_130899 = (state_130901[(2)]);
var state_130901__$1 = state_130901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_130901__$1,inst_130899);
} else {
if((state_val_130902 === (3))){
var inst_130875 = (state_130901[(2)]);
var state_130901__$1 = state_130901;
var statearr_130904_130916 = state_130901__$1;
(statearr_130904_130916[(2)] = inst_130875);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130901__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130902 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_130901,(3),Error,null,(2));
var inst_130879 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_130901__$1 = state_130901;
if(inst_130879){
var statearr_130905_130917 = state_130901__$1;
(statearr_130905_130917[(1)] = (5));

} else {
var statearr_130906_130918 = state_130901__$1;
(statearr_130906_130918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130902 === (5))){
var state_130901__$1 = state_130901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_130901__$1,(8),num);
} else {
if((state_val_130902 === (6))){
var state_130901__$1 = state_130901;
var statearr_130907_130919 = state_130901__$1;
(statearr_130907_130919[(2)] = num);

(statearr_130907_130919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130902 === (7))){
var inst_130886 = (state_130901[(2)]);
var inst_130887 = fluree.db.dbfunctions.internal.floor.call(null,inst_130886);
var inst_130888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_130890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_130891 = [fluree.db.dbfunctions.fns.floor];
var inst_130892 = (new cljs.core.PersistentVector(null,1,(5),inst_130890,inst_130891,null));
var inst_130893 = ["",inst_130892,inst_130887];
var inst_130894 = cljs.core.PersistentHashMap.fromArrays(inst_130889,inst_130893);
var inst_130895 = [inst_130894,(10)];
var inst_130896 = (new cljs.core.PersistentVector(null,2,(5),inst_130888,inst_130895,null));
var inst_130897 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_130896);
var state_130901__$1 = (function (){var statearr_130908 = state_130901;
(statearr_130908[(7)] = inst_130897);

return statearr_130908;
})();
var statearr_130909_130920 = state_130901__$1;
(statearr_130909_130920[(2)] = inst_130887);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130901__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_130902 === (8))){
var inst_130882 = (state_130901[(2)]);
var inst_130883 = fluree.db.util.async.throw_err.call(null,inst_130882);
var state_130901__$1 = state_130901;
var statearr_130910_130921 = state_130901__$1;
(statearr_130910_130921[(2)] = inst_130883);

(statearr_130910_130921[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____0 = (function (){
var statearr_130911 = [null,null,null,null,null,null,null,null];
(statearr_130911[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__);

(statearr_130911[(1)] = (1));

return statearr_130911;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____1 = (function (state_130901){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_130901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e130912){if((e130912 instanceof Object)){
var ex__99978__auto__ = e130912;
var statearr_130913_130922 = state_130901;
(statearr_130913_130922[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_130901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e130912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__130923 = state_130901;
state_130901 = G__130923;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__ = function(state_130901){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____1.call(this,state_130901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_130914 = f__100070__auto__.call(null);
(statearr_130914[(6)] = c__100069__auto__);

return statearr_130914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
