// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 * 
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
if(fluree.db.connection_js.dbaas_QMARK_.call(null,conn)){
return true;
} else {
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
}
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__121961 = arguments.length;
switch (G__121961) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122000){
var state_val_122001 = (state_122000[(1)]);
if((state_val_122001 === (7))){
var inst_121984 = (state_122000[(2)]);
var inst_121985 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_121986 = [account,inst_121984,password,expireSeconds,syncTo];
var inst_121987 = cljs.core.PersistentHashMap.fromArrays(inst_121985,inst_121986);
var inst_121988 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_121987);
var state_122000__$1 = state_122000;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_122000__$1,(14),inst_121988);
} else {
if((state_val_122001 === (1))){
var state_122000__$1 = state_122000;
var statearr_122002_122024 = state_122000__$1;
(statearr_122002_122024[(2)] = null);

(statearr_122002_122024[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122000,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_121968 = typeof user === 'number';
var state_122000__$1 = state_122000;
if(cljs.core.truth_(inst_121968)){
var statearr_122003_122025 = state_122000__$1;
(statearr_122003_122025[(1)] = (5));

} else {
var statearr_122004_122026 = state_122000__$1;
(statearr_122004_122026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (13))){
var inst_121980 = (state_122000[(2)]);
var state_122000__$1 = state_122000;
var statearr_122005_122027 = state_122000__$1;
(statearr_122005_122027[(2)] = inst_121980);

(statearr_122005_122027[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (6))){
var inst_121971 = typeof user === 'string';
var state_122000__$1 = state_122000;
if(cljs.core.truth_(inst_121971)){
var statearr_122006_122028 = state_122000__$1;
(statearr_122006_122028[(1)] = (8));

} else {
var statearr_122007_122029 = state_122000__$1;
(statearr_122007_122029[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (3))){
var inst_121962 = (state_122000[(2)]);
var inst_121963 = fluree.db.util.log.error.call(null,inst_121962);
var inst_121964 = reject.call(null,inst_121962);
var state_122000__$1 = (function (){var statearr_122008 = state_122000;
(statearr_122008[(7)] = inst_121963);

return statearr_122008;
})();
var statearr_122009_122030 = state_122000__$1;
(statearr_122009_122030[(2)] = inst_121964);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122000__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (12))){
var state_122000__$1 = state_122000;
var statearr_122010_122031 = state_122000__$1;
(statearr_122010_122031[(2)] = null);

(statearr_122010_122031[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (2))){
var inst_121998 = (state_122000[(2)]);
var state_122000__$1 = state_122000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122000__$1,inst_121998);
} else {
if((state_val_122001 === (11))){
var state_122000__$1 = state_122000;
var statearr_122011_122032 = state_122000__$1;
(statearr_122011_122032[(2)] = user);

(statearr_122011_122032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (9))){
var state_122000__$1 = state_122000;
var statearr_122012_122033 = state_122000__$1;
(statearr_122012_122033[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (5))){
var state_122000__$1 = state_122000;
var statearr_122014_122034 = state_122000__$1;
(statearr_122014_122034[(2)] = user);

(statearr_122014_122034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (14))){
var inst_121990 = (state_122000[(2)]);
var inst_121991 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_121990);
var inst_121992 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_121993 = cljs.core.constantly.call(null,inst_121991);
var inst_121994 = cljs.core.swap_BANG_.call(null,inst_121992,inst_121993);
var inst_121995 = fluree.db.connection.add_token.call(null,conn,inst_121991);
var inst_121996 = resolve.call(null,inst_121990);
var state_122000__$1 = (function (){var statearr_122015 = state_122000;
(statearr_122015[(8)] = inst_121994);

(statearr_122015[(9)] = inst_121995);

return statearr_122015;
})();
var statearr_122016_122035 = state_122000__$1;
(statearr_122016_122035[(2)] = inst_121996);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122000__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (10))){
var inst_121982 = (state_122000[(2)]);
var state_122000__$1 = state_122000;
var statearr_122017_122036 = state_122000__$1;
(statearr_122017_122036[(2)] = inst_121982);

(statearr_122017_122036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122001 === (8))){
var inst_121973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121974 = ["_user/username",user];
var inst_121975 = (new cljs.core.PersistentVector(null,2,(5),inst_121973,inst_121974,null));
var state_122000__$1 = state_122000;
var statearr_122018_122037 = state_122000__$1;
(statearr_122018_122037[(2)] = inst_121975);

(statearr_122018_122037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__99975__auto__ = null;
var fluree$db$connection_js$state_machine__99975__auto____0 = (function (){
var statearr_122019 = [null,null,null,null,null,null,null,null,null,null];
(statearr_122019[(0)] = fluree$db$connection_js$state_machine__99975__auto__);

(statearr_122019[(1)] = (1));

return statearr_122019;
});
var fluree$db$connection_js$state_machine__99975__auto____1 = (function (state_122000){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122020){if((e122020 instanceof Object)){
var ex__99978__auto__ = e122020;
var statearr_122021_122038 = state_122000;
(statearr_122021_122038[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122000);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122039 = state_122000;
state_122000 = G__122039;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__99975__auto__ = function(state_122000){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__99975__auto____1.call(this,state_122000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__99975__auto____0;
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__99975__auto____1;
return fluree$db$connection_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122022 = f__100070__auto__.call(null);
(statearr_122022[(6)] = c__100069__auto__);

return statearr_122022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__122041 = arguments.length;
switch (G__122041) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122050){
var state_val_122051 = (state_122050[(1)]);
if((state_val_122051 === (1))){
var inst_122042 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_122043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122044 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_122045 = (new cljs.core.PersistentVector(null,4,(5),inst_122043,inst_122044,null));
var inst_122046 = cljs.core.async.put_BANG_.call(null,inst_122042,inst_122045);
var inst_122047 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__122052 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__122053 = null;
var count__122054 = (0);
var i__122055 = (0);
while(true){
if((i__122055 < count__122054)){
var k = cljs.core._nth.call(null,chunk__122053,i__122055);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__122062 = seq__122052;
var G__122063 = chunk__122053;
var G__122064 = count__122054;
var G__122065 = (i__122055 + (1));
seq__122052 = G__122062;
chunk__122053 = G__122063;
count__122054 = G__122064;
i__122055 = G__122065;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__122052);
if(temp__5735__auto__){
var seq__122052__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__122052__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__122052__$1);
var G__122066 = cljs.core.chunk_rest.call(null,seq__122052__$1);
var G__122067 = c__4556__auto__;
var G__122068 = cljs.core.count.call(null,c__4556__auto__);
var G__122069 = (0);
seq__122052 = G__122066;
chunk__122053 = G__122067;
count__122054 = G__122068;
i__122055 = G__122069;
continue;
} else {
var k = cljs.core.first.call(null,seq__122052__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__122070 = cljs.core.next.call(null,seq__122052__$1);
var G__122071 = null;
var G__122072 = (0);
var G__122073 = (0);
seq__122052 = G__122070;
chunk__122053 = G__122071;
count__122054 = G__122072;
i__122055 = G__122073;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_122048 = cljs.core.async.take_BANG_.call(null,pc,inst_122047);
var state_122050__$1 = (function (){var statearr_122056 = state_122050;
(statearr_122056[(7)] = inst_122046);

return statearr_122056;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122050__$1,inst_122048);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__99975__auto__ = null;
var fluree$db$connection_js$state_machine__99975__auto____0 = (function (){
var statearr_122057 = [null,null,null,null,null,null,null,null];
(statearr_122057[(0)] = fluree$db$connection_js$state_machine__99975__auto__);

(statearr_122057[(1)] = (1));

return statearr_122057;
});
var fluree$db$connection_js$state_machine__99975__auto____1 = (function (state_122050){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122058){if((e122058 instanceof Object)){
var ex__99978__auto__ = e122058;
var statearr_122059_122074 = state_122050;
(statearr_122059_122074[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122050);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122058;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122075 = state_122050;
state_122050 = G__122075;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__99975__auto__ = function(state_122050){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__99975__auto____1.call(this,state_122050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__99975__auto____0;
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__99975__auto____1;
return fluree$db$connection_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122060 = f__100070__auto__.call(null);
(statearr_122060[(6)] = c__100069__auto__);

return statearr_122060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__122077 = arguments.length;
switch (G__122077) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122108){
var state_val_122109 = (state_122108[(1)]);
if((state_val_122109 === (1))){
var state_122108__$1 = state_122108;
var statearr_122110_122124 = state_122108__$1;
(statearr_122110_122124[(2)] = null);

(statearr_122110_122124[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122109 === (2))){
var inst_122106 = (state_122108[(2)]);
var state_122108__$1 = state_122108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122108__$1,inst_122106);
} else {
if((state_val_122109 === (3))){
var inst_122078 = (state_122108[(2)]);
var inst_122079 = fluree.db.util.log.error.call(null,inst_122078);
var inst_122080 = reject.call(null,inst_122078);
var state_122108__$1 = (function (){var statearr_122111 = state_122108;
(statearr_122111[(7)] = inst_122079);

return statearr_122111;
})();
var statearr_122112_122125 = state_122108__$1;
(statearr_122112_122125[(2)] = inst_122080);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122108__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122109 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122108,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122084 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_122085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122086 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_122087 = (new cljs.core.PersistentVector(null,1,(5),inst_122085,inst_122086,null));
var inst_122088 = cljs.core.PersistentHashMap.EMPTY;
var inst_122089 = cljs.core.atom.call(null,inst_122088);
var inst_122090 = cljs.core.assoc_in.call(null,inst_122084,inst_122087,inst_122089);
var inst_122091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122092 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_122093 = (new cljs.core.PersistentVector(null,1,(5),inst_122091,inst_122092,null));
var inst_122094 = cljs.core.PersistentHashMap.EMPTY;
var inst_122095 = cljs.core.atom.call(null,inst_122094);
var inst_122096 = cljs.core.assoc_in.call(null,inst_122090,inst_122093,inst_122095);
var inst_122097 = cljs.core.async.promise_chan.call(null);
var inst_122098 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_122096);
var inst_122099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122100 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_122097,null];
var inst_122101 = (new cljs.core.PersistentVector(null,4,(5),inst_122099,inst_122100,null));
var inst_122102 = cljs.core.async.put_BANG_.call(null,inst_122098,inst_122101);
var inst_122103 = (function (){var conn = inst_122096;
var pc = inst_122097;
return (function (x){
if((x == null)){
} else {
var seq__122113_122126 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__122114_122127 = null;
var count__122115_122128 = (0);
var i__122116_122129 = (0);
while(true){
if((i__122116_122129 < count__122115_122128)){
var k_122130 = cljs.core._nth.call(null,chunk__122114_122127,i__122116_122129);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_122130], null),cljs.core.get.call(null,x,k_122130,null));


var G__122131 = seq__122113_122126;
var G__122132 = chunk__122114_122127;
var G__122133 = count__122115_122128;
var G__122134 = (i__122116_122129 + (1));
seq__122113_122126 = G__122131;
chunk__122114_122127 = G__122132;
count__122115_122128 = G__122133;
i__122116_122129 = G__122134;
continue;
} else {
var temp__5735__auto___122135 = cljs.core.seq.call(null,seq__122113_122126);
if(temp__5735__auto___122135){
var seq__122113_122136__$1 = temp__5735__auto___122135;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__122113_122136__$1)){
var c__4556__auto___122137 = cljs.core.chunk_first.call(null,seq__122113_122136__$1);
var G__122138 = cljs.core.chunk_rest.call(null,seq__122113_122136__$1);
var G__122139 = c__4556__auto___122137;
var G__122140 = cljs.core.count.call(null,c__4556__auto___122137);
var G__122141 = (0);
seq__122113_122126 = G__122138;
chunk__122114_122127 = G__122139;
count__122115_122128 = G__122140;
i__122116_122129 = G__122141;
continue;
} else {
var k_122142 = cljs.core.first.call(null,seq__122113_122136__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_122142], null),cljs.core.get.call(null,x,k_122142,null));


var G__122143 = cljs.core.next.call(null,seq__122113_122136__$1);
var G__122144 = null;
var G__122145 = (0);
var G__122146 = (0);
seq__122113_122126 = G__122143;
chunk__122114_122127 = G__122144;
count__122115_122128 = G__122145;
i__122116_122129 = G__122146;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_122104 = cljs.core.async.take_BANG_.call(null,inst_122097,inst_122103);
var state_122108__$1 = (function (){var statearr_122117 = state_122108;
(statearr_122117[(8)] = inst_122102);

return statearr_122117;
})();
var statearr_122118_122147 = state_122108__$1;
(statearr_122118_122147[(2)] = inst_122104);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122108__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__99975__auto__ = null;
var fluree$db$connection_js$state_machine__99975__auto____0 = (function (){
var statearr_122119 = [null,null,null,null,null,null,null,null,null];
(statearr_122119[(0)] = fluree$db$connection_js$state_machine__99975__auto__);

(statearr_122119[(1)] = (1));

return statearr_122119;
});
var fluree$db$connection_js$state_machine__99975__auto____1 = (function (state_122108){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122120){if((e122120 instanceof Object)){
var ex__99978__auto__ = e122120;
var statearr_122121_122148 = state_122108;
(statearr_122121_122148[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122149 = state_122108;
state_122108 = G__122149;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__99975__auto__ = function(state_122108){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__99975__auto____1.call(this,state_122108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__99975__auto____0;
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__99975__auto____1;
return fluree$db$connection_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122122 = f__100070__auto__.call(null);
(statearr_122122[(6)] = c__100069__auto__);

return statearr_122122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__122151 = arguments.length;
switch (G__122151) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__122153 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__122153,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__122153,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__122156 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__122156,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__122156,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122206){
var state_val_122207 = (state_122206[(1)]);
if((state_val_122207 === (7))){
var inst_122174 = (state_122206[(2)]);
var state_122206__$1 = (function (){var statearr_122208 = state_122206;
(statearr_122208[(7)] = inst_122174);

return statearr_122208;
})();
if(cljs.core.truth_(ledger)){
var statearr_122209_122230 = state_122206__$1;
(statearr_122209_122230[(1)] = (8));

} else {
var statearr_122210_122231 = state_122206__$1;
(statearr_122210_122231[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (1))){
var state_122206__$1 = state_122206;
var statearr_122211_122232 = state_122206__$1;
(statearr_122211_122232[(2)] = null);

(statearr_122211_122232[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122206,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122165 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_122206__$1 = state_122206;
if(cljs.core.truth_(inst_122165)){
var statearr_122212_122233 = state_122206__$1;
(statearr_122212_122233[(1)] = (5));

} else {
var statearr_122213_122234 = state_122206__$1;
(statearr_122213_122234[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (13))){
var inst_122192 = (state_122206[(2)]);
var inst_122193 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_122194 = fluree.db.util.core.without_nils.call(null,inst_122193);
var inst_122195 = cljs.core.async.promise_chan.call(null);
var inst_122196 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_122197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122198 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_122194,inst_122195,null];
var inst_122199 = (new cljs.core.PersistentVector(null,4,(5),inst_122197,inst_122198,null));
var inst_122200 = cljs.core.async.put_BANG_.call(null,inst_122196,inst_122199);
var inst_122201 = (function (){var _ = inst_122192;
var data = inst_122194;
var pc = inst_122195;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_122202 = cljs.core.async.take_BANG_.call(null,inst_122195,inst_122201);
var state_122206__$1 = (function (){var statearr_122214 = state_122206;
(statearr_122214[(8)] = inst_122200);

return statearr_122214;
})();
var statearr_122215_122235 = state_122206__$1;
(statearr_122215_122235[(2)] = inst_122202);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122206__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (6))){
var inst_122168 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122169 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_122170 = cljs.core.PersistentHashMap.fromArrays(inst_122168,inst_122169);
var inst_122171 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_122170);
var inst_122172 = (function(){throw inst_122171})();
var state_122206__$1 = state_122206;
var statearr_122216_122236 = state_122206__$1;
(statearr_122216_122236[(2)] = inst_122172);

(statearr_122216_122236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (3))){
var inst_122159 = (state_122206[(2)]);
var inst_122160 = cljs.core.clj__GT_js.call(null,inst_122159);
var inst_122161 = reject.call(null,inst_122160);
var state_122206__$1 = state_122206;
var statearr_122217_122237 = state_122206__$1;
(statearr_122217_122237[(2)] = inst_122161);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122206__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (12))){
var inst_122186 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122187 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_122188 = cljs.core.PersistentHashMap.fromArrays(inst_122186,inst_122187);
var inst_122189 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_122188);
var inst_122190 = (function(){throw inst_122189})();
var state_122206__$1 = state_122206;
var statearr_122218_122238 = state_122206__$1;
(statearr_122218_122238[(2)] = inst_122190);

(statearr_122218_122238[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (2))){
var inst_122204 = (state_122206[(2)]);
var state_122206__$1 = state_122206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122206__$1,inst_122204);
} else {
if((state_val_122207 === (11))){
var state_122206__$1 = state_122206;
var statearr_122219_122239 = state_122206__$1;
(statearr_122219_122239[(2)] = null);

(statearr_122219_122239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (9))){
var inst_122177 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122178 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_122179 = cljs.core.PersistentHashMap.fromArrays(inst_122177,inst_122178);
var inst_122180 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_122179);
var inst_122181 = (function(){throw inst_122180})();
var state_122206__$1 = state_122206;
var statearr_122220_122240 = state_122206__$1;
(statearr_122220_122240[(2)] = inst_122181);

(statearr_122220_122240[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (5))){
var state_122206__$1 = state_122206;
var statearr_122221_122241 = state_122206__$1;
(statearr_122221_122241[(2)] = null);

(statearr_122221_122241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (10))){
var inst_122183 = (state_122206[(2)]);
var state_122206__$1 = (function (){var statearr_122222 = state_122206;
(statearr_122222[(9)] = inst_122183);

return statearr_122222;
})();
if(cljs.core.truth_(password)){
var statearr_122223_122242 = state_122206__$1;
(statearr_122223_122242[(1)] = (11));

} else {
var statearr_122224_122243 = state_122206__$1;
(statearr_122224_122243[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122207 === (8))){
var state_122206__$1 = state_122206;
var statearr_122225_122244 = state_122206__$1;
(statearr_122225_122244[(2)] = null);

(statearr_122225_122244[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__99975__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__99975__auto____0 = (function (){
var statearr_122226 = [null,null,null,null,null,null,null,null,null,null];
(statearr_122226[(0)] = fluree$db$connection_js$password_generate_$_state_machine__99975__auto__);

(statearr_122226[(1)] = (1));

return statearr_122226;
});
var fluree$db$connection_js$password_generate_$_state_machine__99975__auto____1 = (function (state_122206){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122227){if((e122227 instanceof Object)){
var ex__99978__auto__ = e122227;
var statearr_122228_122245 = state_122206;
(statearr_122228_122245[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122227;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122246 = state_122206;
state_122206 = G__122246;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__99975__auto__ = function(state_122206){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__99975__auto____1.call(this,state_122206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__99975__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__99975__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122229 = f__100070__auto__.call(null);
(statearr_122229[(6)] = c__100069__auto__);

return statearr_122229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__122248 = arguments.length;
switch (G__122248) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122311){
var state_val_122312 = (state_122311[(1)]);
if((state_val_122312 === (7))){
var inst_122264 = (state_122311[(2)]);
var state_122311__$1 = (function (){var statearr_122313 = state_122311;
(statearr_122313[(7)] = inst_122264);

return statearr_122313;
})();
if(cljs.core.truth_(ledger)){
var statearr_122314_122345 = state_122311__$1;
(statearr_122314_122345[(1)] = (8));

} else {
var statearr_122315_122346 = state_122311__$1;
(statearr_122315_122346[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (1))){
var state_122311__$1 = state_122311;
var statearr_122316_122347 = state_122311__$1;
(statearr_122316_122347[(2)] = null);

(statearr_122316_122347[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122311,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122255 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_122311__$1 = state_122311;
if(cljs.core.truth_(inst_122255)){
var statearr_122317_122348 = state_122311__$1;
(statearr_122317_122348[(1)] = (5));

} else {
var statearr_122318_122349 = state_122311__$1;
(statearr_122318_122349[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (15))){
var state_122311__$1 = state_122311;
var statearr_122319_122350 = state_122311__$1;
(statearr_122319_122350[(2)] = auth);

(statearr_122319_122350[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (13))){
var inst_122282 = (state_122311[(2)]);
var state_122311__$1 = (function (){var statearr_122320 = state_122311;
(statearr_122320[(8)] = inst_122282);

return statearr_122320;
})();
if(cljs.core.truth_(user)){
var statearr_122321_122351 = state_122311__$1;
(statearr_122321_122351[(1)] = (14));

} else {
var statearr_122322_122352 = state_122311__$1;
(statearr_122322_122352[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (6))){
var inst_122258 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122259 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_122260 = cljs.core.PersistentHashMap.fromArrays(inst_122258,inst_122259);
var inst_122261 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_122260);
var inst_122262 = (function(){throw inst_122261})();
var state_122311__$1 = state_122311;
var statearr_122323_122353 = state_122311__$1;
(statearr_122323_122353[(2)] = inst_122262);

(statearr_122323_122353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (17))){
var state_122311__$1 = state_122311;
var statearr_122324_122354 = state_122311__$1;
(statearr_122324_122354[(2)] = null);

(statearr_122324_122354[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (3))){
var inst_122249 = (state_122311[(2)]);
var inst_122250 = cljs.core.clj__GT_js.call(null,inst_122249);
var inst_122251 = reject.call(null,inst_122250);
var state_122311__$1 = state_122311;
var statearr_122325_122355 = state_122311__$1;
(statearr_122325_122355[(2)] = inst_122251);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122311__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (12))){
var inst_122276 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122277 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_122278 = cljs.core.PersistentHashMap.fromArrays(inst_122276,inst_122277);
var inst_122279 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_122278);
var inst_122280 = (function(){throw inst_122279})();
var state_122311__$1 = state_122311;
var statearr_122326_122356 = state_122311__$1;
(statearr_122326_122356[(2)] = inst_122280);

(statearr_122326_122356[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (2))){
var inst_122309 = (state_122311[(2)]);
var state_122311__$1 = state_122311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122311__$1,inst_122309);
} else {
if((state_val_122312 === (19))){
var inst_122295 = (state_122311[(2)]);
var inst_122296 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_122297 = [ledger,password,user,auth,expire];
var inst_122298 = cljs.core.PersistentHashMap.fromArrays(inst_122296,inst_122297);
var inst_122299 = fluree.db.util.core.without_nils.call(null,inst_122298);
var inst_122300 = cljs.core.async.promise_chan.call(null);
var inst_122301 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_122302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122303 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_122299,inst_122300,null];
var inst_122304 = (new cljs.core.PersistentVector(null,4,(5),inst_122302,inst_122303,null));
var inst_122305 = cljs.core.async.put_BANG_.call(null,inst_122301,inst_122304);
var inst_122306 = (function (){var _ = inst_122295;
var data = inst_122299;
var pc = inst_122300;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_122307 = cljs.core.async.take_BANG_.call(null,inst_122300,inst_122306);
var state_122311__$1 = (function (){var statearr_122327 = state_122311;
(statearr_122327[(9)] = inst_122305);

return statearr_122327;
})();
var statearr_122328_122357 = state_122311__$1;
(statearr_122328_122357[(2)] = inst_122307);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122311__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (11))){
var state_122311__$1 = state_122311;
var statearr_122329_122358 = state_122311__$1;
(statearr_122329_122358[(2)] = null);

(statearr_122329_122358[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (9))){
var inst_122267 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122268 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_122269 = cljs.core.PersistentHashMap.fromArrays(inst_122267,inst_122268);
var inst_122270 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_122269);
var inst_122271 = (function(){throw inst_122270})();
var state_122311__$1 = state_122311;
var statearr_122330_122359 = state_122311__$1;
(statearr_122330_122359[(2)] = inst_122271);

(statearr_122330_122359[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (5))){
var state_122311__$1 = state_122311;
var statearr_122331_122360 = state_122311__$1;
(statearr_122331_122360[(2)] = null);

(statearr_122331_122360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (14))){
var state_122311__$1 = state_122311;
var statearr_122332_122361 = state_122311__$1;
(statearr_122332_122361[(2)] = user);

(statearr_122332_122361[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (16))){
var inst_122286 = (state_122311[(2)]);
var state_122311__$1 = state_122311;
if(cljs.core.truth_(inst_122286)){
var statearr_122333_122362 = state_122311__$1;
(statearr_122333_122362[(1)] = (17));

} else {
var statearr_122334_122363 = state_122311__$1;
(statearr_122334_122363[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (10))){
var inst_122273 = (state_122311[(2)]);
var state_122311__$1 = (function (){var statearr_122335 = state_122311;
(statearr_122335[(10)] = inst_122273);

return statearr_122335;
})();
if(cljs.core.truth_(password)){
var statearr_122336_122364 = state_122311__$1;
(statearr_122336_122364[(1)] = (11));

} else {
var statearr_122337_122365 = state_122311__$1;
(statearr_122337_122365[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (18))){
var inst_122289 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122290 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_122291 = cljs.core.PersistentHashMap.fromArrays(inst_122289,inst_122290);
var inst_122292 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_122291);
var inst_122293 = (function(){throw inst_122292})();
var state_122311__$1 = state_122311;
var statearr_122338_122366 = state_122311__$1;
(statearr_122338_122366[(2)] = inst_122293);

(statearr_122338_122366[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122312 === (8))){
var state_122311__$1 = state_122311;
var statearr_122339_122367 = state_122311__$1;
(statearr_122339_122367[(2)] = null);

(statearr_122339_122367[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__99975__auto__ = null;
var fluree$db$connection_js$state_machine__99975__auto____0 = (function (){
var statearr_122340 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_122340[(0)] = fluree$db$connection_js$state_machine__99975__auto__);

(statearr_122340[(1)] = (1));

return statearr_122340;
});
var fluree$db$connection_js$state_machine__99975__auto____1 = (function (state_122311){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122341){if((e122341 instanceof Object)){
var ex__99978__auto__ = e122341;
var statearr_122342_122368 = state_122311;
(statearr_122342_122368[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122311);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122369 = state_122311;
state_122311 = G__122369;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__99975__auto__ = function(state_122311){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__99975__auto____1.call(this,state_122311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__99975__auto____0;
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__99975__auto____1;
return fluree$db$connection_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122343 = f__100070__auto__.call(null);
(statearr_122343[(6)] = c__100069__auto__);

return statearr_122343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__122371 = arguments.length;
switch (G__122371) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_122403){
var state_val_122404 = (state_122403[(1)]);
if((state_val_122404 === (1))){
var state_122403__$1 = state_122403;
var statearr_122405_122418 = state_122403__$1;
(statearr_122405_122418[(2)] = null);

(statearr_122405_122418[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122404 === (2))){
var inst_122401 = (state_122403[(2)]);
var state_122403__$1 = state_122403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_122403__$1,inst_122401);
} else {
if((state_val_122404 === (3))){
var inst_122372 = (state_122403[(2)]);
var inst_122373 = cljs.core.clj__GT_js.call(null,inst_122372);
var inst_122374 = reject.call(null,inst_122373);
var state_122403__$1 = state_122403;
var statearr_122406_122419 = state_122403__$1;
(statearr_122406_122419[(2)] = inst_122374);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122404 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_122403,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_122378 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_122403__$1 = state_122403;
if(cljs.core.truth_(inst_122378)){
var statearr_122407_122420 = state_122403__$1;
(statearr_122407_122420[(1)] = (5));

} else {
var statearr_122408_122421 = state_122403__$1;
(statearr_122408_122421[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122404 === (5))){
var state_122403__$1 = state_122403;
var statearr_122409_122422 = state_122403__$1;
(statearr_122409_122422[(2)] = null);

(statearr_122409_122422[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122404 === (6))){
var inst_122381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_122382 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_122383 = cljs.core.PersistentHashMap.fromArrays(inst_122381,inst_122382);
var inst_122384 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_122383);
var inst_122385 = (function(){throw inst_122384})();
var state_122403__$1 = state_122403;
var statearr_122410_122423 = state_122403__$1;
(statearr_122410_122423[(2)] = inst_122385);

(statearr_122410_122423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_122404 === (7))){
var inst_122387 = (state_122403[(2)]);
var inst_122388 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_122389 = [jwt,expire];
var inst_122390 = cljs.core.PersistentHashMap.fromArrays(inst_122388,inst_122389);
var inst_122391 = fluree.db.util.core.without_nils.call(null,inst_122390);
var inst_122392 = cljs.core.async.promise_chan.call(null);
var inst_122393 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_122394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122395 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_122391,inst_122392,null];
var inst_122396 = (new cljs.core.PersistentVector(null,4,(5),inst_122394,inst_122395,null));
var inst_122397 = cljs.core.async.put_BANG_.call(null,inst_122393,inst_122396);
var inst_122398 = (function (){var _ = inst_122387;
var data = inst_122391;
var pc = inst_122392;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_122399 = cljs.core.async.take_BANG_.call(null,inst_122392,inst_122398);
var state_122403__$1 = (function (){var statearr_122411 = state_122403;
(statearr_122411[(7)] = inst_122397);

return statearr_122411;
})();
var statearr_122412_122424 = state_122403__$1;
(statearr_122412_122424[(2)] = inst_122399);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122403__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__99975__auto__ = null;
var fluree$db$connection_js$state_machine__99975__auto____0 = (function (){
var statearr_122413 = [null,null,null,null,null,null,null,null];
(statearr_122413[(0)] = fluree$db$connection_js$state_machine__99975__auto__);

(statearr_122413[(1)] = (1));

return statearr_122413;
});
var fluree$db$connection_js$state_machine__99975__auto____1 = (function (state_122403){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_122403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e122414){if((e122414 instanceof Object)){
var ex__99978__auto__ = e122414;
var statearr_122415_122425 = state_122403;
(statearr_122415_122425[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_122403);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e122414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__122426 = state_122403;
state_122403 = G__122426;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__99975__auto__ = function(state_122403){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__99975__auto____1.call(this,state_122403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__99975__auto____0;
fluree$db$connection_js$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__99975__auto____1;
return fluree$db$connection_js$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_122416 = f__100070__auto__.call(null);
(statearr_122416[(6)] = c__100069__auto__);

return statearr_122416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

